// Copyright (C) 2005 - Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Containing Verilog Model for the Atoms:                                   //
//                                                                           //
//                         stratixiigx_hssi_receiver                         //
//                         stratixiigx_hssi_transmitter                      //
//                         stratixiigx_hssi_central_management_unit          //
//                         stratixiigx_hssi_cmu_pll                          //
//                         stratixiigx_hssi_cmu_clock_divider                //
//                         stratixiigx_hssi_refclk_divider                   //
//                         stratixiigx_hssi_calibration_block                //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



`timescale 1 ps / 1 ps
module stratixiigx_hssi_aux_clock_div (
    clk,     // input clock
    reset,   // reset
    clkout   // divided clock
);
input clk,reset;
output clkout;

parameter clk_divide_by  = 1;
parameter extra_latency  = 0;

integer clk_edges,m;
reg [2*extra_latency:0] div_n_register;

initial
begin
    div_n_register = 'b0;
    clk_edges = -1;
    m = 0;
end

always @(posedge clk or negedge clk or posedge reset)
begin
    if (reset === 1'b1) 
    begin
        clk_edges = -1;
        div_n_register <= 'b0;
    end
    else
    begin
        if (clk_edges == -1) 
        begin
            div_n_register[0] <= clk;
            if (clk == 1'b1) clk_edges = 0;
        end
        else if (clk_edges % clk_divide_by == 0) 
            div_n_register[0] <= ~div_n_register[0];
        if (clk_edges >= 0 || clk == 1'b1)
            clk_edges = (clk_edges + 1) % (2*clk_divide_by) ;
    end
    for (m = 0; m < 2*extra_latency; m=m+1)
            div_n_register[m+1] <= div_n_register[m];
end

assign clkout = div_n_register[2*extra_latency];

endmodule


`timescale 1 ps / 1 ps
`define INITIAL 2'b01
`define ACTIVE  2'b11
`define INACTIVE  2'b00
module stratixiigx_hssi_aux_clock_mult (
    clk,     // input clock
    adjust,  // adjust frequency
    reset,   // reset
    clkout,  // multiplied clock
    busy     // state
);
input clk,adjust,reset;
output clkout;
output [1:0] busy;
reg [1:0] busy;

parameter clk_multiply_by  = 1;

reg  clk_adjust_settled;
real last_rising_edge,clk_period;
integer clk_fast_period,clk_adjust,clk_adjust_interval,clk_adjust_running,clk_sync_period;
reg  mult_n;
integer n;

initial
begin
    busy = `INITIAL;
    last_rising_edge = 0;
    mult_n = 'b0;
    n = 0;
end

always @(posedge adjust) busy = `INITIAL;

always @(posedge clk or posedge reset)
begin
    if (reset === 1'b1) 
    begin
        mult_n = 1'b0;
        busy = `INITIAL;
    end
    else
    begin
        if (busy == `INITIAL)        // first rising edge
        begin 
            mult_n = 1'b0;
            last_rising_edge = $realtime;
            busy = `ACTIVE;
        end
        else 
        begin
            if (busy == `ACTIVE)    // second rising edge
            begin
                clk_period = $realtime - last_rising_edge;
                clk_fast_period = clk_period/clk_multiply_by - 0.5;
                clk_adjust = clk_period - clk_fast_period * clk_multiply_by;
                busy = `INACTIVE;
            end
            mult_n = ~mult_n;
            if (clk_adjust > 0) clk_adjust_running = clk_adjust + 1;
            clk_adjust_settled = (clk_adjust == 0);                    // if no adjustment necessary
            for (n = clk_multiply_by; n >= 1 ; n=n-1)
            begin
                if (clk_adjust_settled == 1'b0) 
                begin
                    clk_adjust_running = clk_adjust_running - 1;
                    clk_adjust_interval = n/clk_adjust_running;
                    if (n % clk_adjust_running == 0) 
                        clk_adjust_settled = 1'b1;
                    clk_sync_period = clk_fast_period + 1;       
                end
                else
                begin
                    if (clk_adjust == 0)
                        clk_sync_period = clk_fast_period;
                    else
                    begin
                        if (n % clk_adjust_interval == 0) 
                            clk_sync_period = clk_fast_period + 1;     
                        else
                            clk_sync_period = clk_fast_period;
                    end
                end
                if (reset == 1'b1) mult_n = 1'b0;
                else
                begin
                    #(clk_sync_period/2) mult_n = ~mult_n; 
                    if (n > 1) #(clk_sync_period - clk_sync_period/2) mult_n = ~mult_n; 
                end
            end
        end
    end
end

assign clkout = mult_n;

endmodule


`timescale 1 ps / 1 ps
module stratixiigx_hssi_aux_clock_phaseshift (
    clk,     // input clock
    clkout   // delayed clock
);
input clk;
output clkout;
parameter clk_phase_shift_by  = 0;

reg pclk;

always @(clk) pclk <=  #(clk_phase_shift_by) clk;

assign clkout = pclk;
endmodule


`timescale 1 ps / 1 ps
module stratixiigx_hssi_tx_channel_clk_div (
    clkin0,clkin1,     // CMU PLL clocks
    reset,
    vcobypassin,       // VCO Bypass
    lclkout,           // Low speed clock
    fclkout            // Fast speed clock
);
input  clkin0,clkin1;
input  reset;
input  vcobypassin;
output lclkout,fclkout;

parameter clkin0_select = "true"; // true => select clkin0, false => select clkin1
parameter clk_divide_by_n = 1;    // n=1,2,4
parameter clk_divide_by_m = 4;    // m=4,5
parameter clk_divide_by_2_select = "true"; // true => use /2 divider, false => bypass
parameter allow_vco_bypass = "false";
parameter lclkout_latency = 0;
parameter fclkout_latency = 0;
parameter lclkout_phase_shift = 0;
parameter fclkout_phase_shift = 0; 

wire divide_by_n_in,divide_by_n_out,divide_by_m_out,divide_by_2_out; // divider i/o
wire lclkout_undelayed,hclkout_undelayed;     // before phase shift
wire lclkout_pre_latency,hclkout_pre_latency; // before latency

assign divide_by_n_in = (allow_vco_bypass == "true") ? vcobypassin : ((clkin0_select == "true") ? clkin0 : clkin1);

// N divider
stratixiigx_hssi_aux_clock_div divide_by_n (
    .clk(divide_by_n_in),
    .reset(reset),
    .clkout(divide_by_n_out)
);
defparam divide_by_n.clk_divide_by = clk_divide_by_n;
defparam divide_by_n.extra_latency = 0;

// 4,5 divider
stratixiigx_hssi_aux_clock_div divide_by_m (
    .clk(divide_by_n_out),
    .reset(reset),
    .clkout(divide_by_m_out)
);
defparam divide_by_m.clk_divide_by = clk_divide_by_m;
defparam divide_by_m.extra_latency = 0;

// 2 divider
stratixiigx_hssi_aux_clock_div divide_by_2 (
    .clk(divide_by_m_out),
    .reset(reset),
    .clkout(divide_by_2_out)
);
defparam divide_by_2.clk_divide_by = 2;
defparam divide_by_2.extra_latency = 0;

assign lclkout_undelayed = (clk_divide_by_2_select == "true") ? divide_by_2_out : divide_by_m_out;
assign hclkout_undelayed = divide_by_n_out;

// Low speed clock phase shift
stratixiigx_hssi_aux_clock_phaseshift lclk_phase_shift (
    .clk(lclkout_undelayed),
    .clkout(lclkout_pre_latency)
);
defparam lclk_phase_shift.clk_phase_shift_by = lclkout_phase_shift;

// High speed clock phase shift
stratixiigx_hssi_aux_clock_phaseshift hclk_phase_shift (
    .clk(hclkout_undelayed),
    .clkout(hclkout_pre_latency)
);
defparam hclk_phase_shift.clk_phase_shift_by = fclkout_phase_shift;

// Low speed clock latency
stratixiigx_hssi_aux_clock_div lclk_latency (
    .clk(lclkout_pre_latency),
    .reset(reset),
    .clkout(lclkout)
);
defparam lclk_latency.clk_divide_by = 1;
defparam lclk_latency.extra_latency = lclkout_latency;

// High speed clock latency
stratixiigx_hssi_aux_clock_div hclk_latency (
    .clk(hclkout_pre_latency),
    .reset(reset),
    .clkout(fclkout)
);
defparam hclk_latency.clk_divide_by = 1;
defparam hclk_latency.extra_latency = fclkout_latency;

endmodule


`timescale 1 ps / 1 ps
module stratixiigx_hssi_refclk_divider (
    inclk,       // input from REFCLK pin
    dprioin,
    dpriodisable,
    clkout,      // clock output
    dprioout
);
input inclk,dprioin,dpriodisable;
output clkout,dprioout;

wire inclk_ipd;
wire dprioin_ipd;
wire dpriodisable_ipd;

buf buf_inclk (inclk_ipd,inclk);
buf buf_dprioin (dprioin_ipd,dprioin);
buf buf_dpriodisable (dpriodisable_ipd,dpriodisable);

specify
    (inclk => clkout) = (0,0);
endspecify

parameter enable_divider = "true"; // true -> use /2 divider, false -> bypass
parameter divider_number = 0;      // 0 or 1 for logical numbering
parameter refclk_coupling_termination = "dc_coupling_external_termination"; // new in 5.1 SP1

wire divide_by_2_out;

stratixiigx_hssi_aux_clock_div divide_by_2 (
    .clk(inclk_ipd),
    .reset(1'b0),
    .clkout(divide_by_2_out)
);
defparam divide_by_2.clk_divide_by = 2;
defparam divide_by_2.extra_latency = 0;

assign clkout = (enable_divider == "true") ? divide_by_2_out : inclk_ipd;
assign dprioout = (dpriodisable_ipd == 1'b1) ? 1'b0 : dprioin_ipd; // temporary, needs to be changed later

endmodule

`timescale 1 ps / 1 ps
module stratixiigx_hssi_cmu_clock_divider (
    clk,                 // CMU PLL clocks 0,1,2
    pclkin,              // pclk from adjacent QUAD
    dprioin,           
    dpriodisable,
    powerdn,
    quadreset,
    refclkdig,
    scanclk,
    scanin,
    vcobypassin,
    scanshift,
    scanmode,
    analogrefclkout,     // output of /4/5 divider
    analogfastrefclkout, // output of /N divider
    digitalrefclkout,    // refclk_pma
    pclkx8out,           // pclk output to adjacent QUAD
    coreclkout,          // coreclk output to PLD
    dprioout,
    scanout
);
input  [2:0] clk;
input  pclkin;
input  [29:0] dprioin;
input  dpriodisable;
input  powerdn,quadreset;
input  refclkdig,scanclk,scanshift,scanmode;
input  [22:0] scanin;
input  vcobypassin;
output analogrefclkout,analogfastrefclkout,digitalrefclkout,coreclkout;
output pclkx8out;
output [29:0] dprioout;
output [22:0] scanout;

wire pclkin_ipd;
wire  [2:0] clk_ipd;
wire [29:0] dprioin_ipd;
wire dpriodisable_ipd;
wire powerdn_ipd;
wire quadreset_ipd;
wire refclkdig_ipd;
wire scanclk_ipd;
wire scanshift_ipd;
wire scanmode_ipd;
wire [22:0] scanin_ipd;

buf buf_pclkin (pclkin_ipd,pclkin);
buf buf_clk  [2:0] (clk_ipd,clk);
buf buf_dprioin [29:0] (dprioin_ipd,dprioin);
buf buf_dpriodisable (dpriodisable_ipd,dpriodisable);
buf buf_powerdn (powerdn_ipd,powerdn);
buf buf_quadreset (quadreset_ipd,quadreset);
buf buf_refclkdig (refclkdig_ipd,refclkdig);
buf buf_scanclk (scanclk_ipd,scanclk);
buf buf_scanshift (scanshift_ipd,scanshift);
buf buf_scanmode (scanmode_ipd,scanmode);
buf buf_scanin [22:0] (scanin_ipd,scanin);

specify
    (clk => coreclkout)    = (0,0);
    (clk => pclkx8out)     = (0,0);
    (pclkin => coreclkout) = (0,0);
endspecify

parameter inclk_select   = 0;   // 0-2 logical index for clk
parameter use_vco_bypass = "false"; 
parameter use_digital_refclk_post_divider = "false"; // true -> /2 div, false -> bypass
parameter use_coreclk_out_post_divider = "false";    // true -> /2 div, false -> bypass
parameter divide_by = 4; // /4 or /5 div
parameter enable_refclk_out = "true";
parameter enable_pclk_x8_out = "false";
parameter select_neighbor_pclk = "false";
parameter coreclk_out_gated_by_quad_reset = "false";
parameter select_refclk_dig = "false";

// Simulation only
parameter sim_analogrefclkout_phase_shift = 0;
parameter sim_analogfastrefclkout_phase_shift = 0;
parameter sim_digitalrefclkout_phase_shift = 0;
parameter sim_pclkx8out_phase_shift = 0;
parameter sim_coreclkout_phase_shift = 0;

wire divide_by_n_out,divide_by_m_out,divide_by_2_dig_out,divide_by_2_core_out; // divider i/o
wire mux_pclk,mux_digrefclk,mux_coreclk;
wire reset_divs,reset_coreclk_only;
wire vco_bypass_mux;

wire analogrefclkout_undelayed,analogfastrefclkout_undelayed,digitalrefclkout_undelayed,
     coreclkout_undelayed,pclkx8out_undelayed;

assign reset_divs = powerdn_ipd | quadreset_ipd;
assign reset_coreclk_only = (coreclk_out_gated_by_quad_reset == "false") ? 1'b0 : quadreset_ipd;

// /N=1 divider

stratixiigx_hssi_aux_clock_div divide_by_n (
    .clk(clk_ipd[inclk_select]),
    .reset(reset_divs),
    .clkout(divide_by_n_out)
);
defparam divide_by_n.clk_divide_by = 1;
defparam divide_by_n.extra_latency = 0;

// 4,5 divider
stratixiigx_hssi_aux_clock_div divide_by_m (
    .clk(divide_by_n_out),
    .reset(reset_divs),
    .clkout(divide_by_m_out)
);
defparam divide_by_m.clk_divide_by = divide_by;
defparam divide_by_m.extra_latency = 0;

assign vco_bypass_mux = (use_vco_bypass == "true") ? vcobypassin : divide_by_m_out;

// 2 divider for refclk_pma
stratixiigx_hssi_aux_clock_div divide_by_2_dig (
    .clk(vco_bypass_mux),
    .reset(reset_divs),
    .clkout(divide_by_2_dig_out)
);
defparam divide_by_2_dig.clk_divide_by = 2;
defparam divide_by_2_dig.extra_latency = 0;

// 2 divider for coreclk
stratixiigx_hssi_aux_clock_div divide_by_2_core (
    .clk(mux_digrefclk),
    .reset(reset_coreclk_only),
    .clkout(divide_by_2_core_out)
);
defparam divide_by_2_core.clk_divide_by = 2;
defparam divide_by_2_core.extra_latency = 0;

assign analogfastrefclkout_undelayed = divide_by_n_out;
assign analogrefclkout_undelayed = (enable_refclk_out == "false") ? 1'bz : divide_by_m_out;
assign mux_pclk = (use_digital_refclk_post_divider == "true") ? divide_by_2_dig_out : vco_bypass_mux;
assign mux_digrefclk = (select_neighbor_pclk == "true") ? pclkin_ipd : mux_pclk;
assign pclkx8out_undelayed = (enable_pclk_x8_out == "false") ? 1'bz : mux_pclk;
assign digitalrefclkout_undelayed = (select_refclk_dig == "true") ? refclkdig_ipd : mux_digrefclk;
assign mux_coreclk = (use_coreclk_out_post_divider == "false") ? mux_digrefclk : divide_by_2_core_out;
assign coreclkout_undelayed = mux_coreclk;

stratixiigx_hssi_aux_clock_phaseshift extra_ps_afrc (
    .clk(analogfastrefclkout_undelayed),
    .clkout(analogfastrefclkout)
);
defparam extra_ps_afrc.clk_phase_shift_by = sim_analogfastrefclkout_phase_shift;

stratixiigx_hssi_aux_clock_phaseshift extra_ps_arc (
    .clk(analogrefclkout_undelayed),
    .clkout(analogrefclkout)
);
defparam extra_ps_arc.clk_phase_shift_by = sim_analogrefclkout_phase_shift;

stratixiigx_hssi_aux_clock_phaseshift extra_ps_drc (
    .clk(digitalrefclkout_undelayed),
    .clkout(digitalrefclkout)
);
defparam extra_ps_drc.clk_phase_shift_by = sim_digitalrefclkout_phase_shift;

stratixiigx_hssi_aux_clock_phaseshift extra_ps_cc (
    .clk(coreclkout_undelayed),
    .clkout(coreclkout)
);
defparam extra_ps_cc.clk_phase_shift_by = sim_coreclkout_phase_shift;

stratixiigx_hssi_aux_clock_phaseshift extra_ps_p8c (
    .clk(pclkx8out_undelayed),
    .clkout(pclkx8out)
);
defparam extra_ps_p8c.clk_phase_shift_by = sim_pclkx8out_phase_shift;


endmodule


`timescale 1 ps/1 ps
`define INITIAL 2'b01
`define ACTIVE  2'b11
`define INACTIVE  2'b00
module stratixiigx_hssi_cmu_pll (
   clk,dprioin,dpriodisable,
   pllreset,pllpowerdn,
   clkout,locked,
   dprioout,
   fbclkout,
   vcobypassout
);
input [7:0] clk;
input [39:0] dprioin;
input dpriodisable;
input pllreset,pllpowerdn;
output clkout,locked;
output [39:0] dprioout;
output fbclkout;
output vcobypassout;

wire dpriodisable_ipd;
wire [7:0] clk_ipd;
wire [39:0] dprioin_ipd;
wire pllreset_ipd;
wire pllpowerdn_ipd;

buf buf_dpriodisable (dpriodisable_ipd,dpriodisable);
buf buf_clk [7:0] (clk_ipd,clk);
buf buf_dprioin [39:0] (dprioin_ipd,dprioin);
buf buf_pllreset (pllreset_ipd,pllreset);
buf buf_pllpowerdn (pllpowerdn_ipd,pllpowerdn);

specify
    (clk => clkout) = (0,0);
endspecify
parameter inclk0_period = 0;  // time period in ps
parameter inclk1_period = 0;
parameter inclk2_period = 0;
parameter inclk3_period = 0;
parameter inclk4_period = 0;
parameter inclk5_period = 0;
parameter inclk6_period = 0;
parameter inclk7_period = 0;

parameter pfd_clk_select = 0; // logical clock select 0-7
parameter multiply_by = 1;    // feedback loop divider 1,4,5,8,10,16,20,25
parameter divide_by = 1;      // post divider 1,2,4
parameter low_speed_test_sel = 4'b0000;
parameter pll_type = "normal"; // normal,fast,auto
parameter charge_pump_current_test_enable = 2'b00;
parameter vco_range = "low";   // CMU_CTL[0]
parameter loop_filter_resistor_control = 2'b00; // CMU_CTL[2:1]
parameter loop_filter_ripple_capacitor_control = 2'b00; // CMU_CTL[4:3].
parameter use_default_charge_pump_current_selection = "false"; // CMU_CTL[5]
parameter use_default_charge_pump_supply_vccm_vod_control  = "false"; // CMU_CTL[6]
parameter pll_number = 0; // PLL 0-2 
parameter charge_pump_current_control = 2'b00;
parameter up_down_control_percent = 4'b0000;
parameter charge_pump_tristate_enable = "false";

// Simulation only
parameter sim_clkout_phase_shift = 0;
parameter sim_clkout_latency = 0;

wire pll_clkin_pre_latency;
wire pll_clkin,clk_pll,clk_div,clk_div_delayed,clk_vco;
reg  charge_pump; // re-adjust VCO frequency
wire charge_pump_delayed;
wire [1:0] busy;  // VCO state

real last_fb_clk_edge;
wire check_phase;
real expected_clk_period,clk_tolerance,real_clk_period,last_pll_clkin_edge,last_real_clk_period;
reg  first_pll_clkin_edge_detect;
reg  display_msgs,freq_viol_msg_sem;
wire reset;
reg locked_real;

function real select_clock_period;
input clk_select;
integer clk_select;
real period;
begin
    case (clk_select)
        0 : period = inclk0_period;
        1 : period = inclk1_period;
        2 : period = inclk2_period;
        3 : period = inclk3_period;
        4 : period = inclk4_period;
        5 : period = inclk5_period;
        6 : period = inclk6_period;
        7 : period = inclk7_period;
        default : $display("Invalid logical clock select");
    endcase
    select_clock_period = period;
end
endfunction

initial
begin
    charge_pump = 1'b1;
    first_pll_clkin_edge_detect = 1'b0;
    expected_clk_period = select_clock_period(pfd_clk_select);
    clk_tolerance = 0.1 * expected_clk_period; // same as Stratix
    display_msgs = 1'b1;
    freq_viol_msg_sem = 1'b1;
    locked_real = 1'b0;
end

assign pll_clkin_pre_latency = clk_ipd[pfd_clk_select];
assign reset = pllreset_ipd | pllpowerdn_ipd;

// Clock latency

stratixiigx_hssi_aux_clock_div clock_latency (
    .clk(pll_clkin_pre_latency),
    .reset(1'b0),
    .clkout(pll_clkin)
);
defparam clock_latency.clk_divide_by = 1;
defparam clock_latency.extra_latency = sim_clkout_latency;

// Input frequency checks

always @(posedge pll_clkin)
begin
    if (first_pll_clkin_edge_detect == 1'b0)
        first_pll_clkin_edge_detect = 1'b1; 
    else 
    begin
        real_clk_period = $realtime - last_pll_clkin_edge;
        if ((real_clk_period < expected_clk_period - clk_tolerance) ||
            (real_clk_period > expected_clk_period + clk_tolerance))
        begin
            if (freq_viol_msg_sem == 1'b1)
            begin
                $display("Warning : CMU PLL input frequency violation");
                $display("Time: %0t  Instance: %m", $time);
                $display("Expected clock period is %0t but real clock period is %0t",expected_clk_period,real_clk_period);
                freq_viol_msg_sem = 1'b0;
            end
        end
        if ((real_clk_period != last_real_clk_period) && (last_real_clk_period > 0)) 
            charge_pump = 1'b1;
        last_real_clk_period = real_clk_period;
    end
    last_pll_clkin_edge = $realtime;
end

// PFD

always @(posedge clk_pll)   last_fb_clk_edge = $realtime;

always @(negedge pll_clkin) 
begin
    if (($realtime > 0) && (busy != `ACTIVE) && (busy != `INITIAL))
    begin
        charge_pump = (last_pll_clkin_edge != last_fb_clk_edge);
    end
end

always @(negedge reset)
begin
    charge_pump = 1'b1;
    display_msgs = 1'b0;
end

always @(posedge reset)
begin
    if (reset == 1'b1) 
    begin
        $display ("Note : CMU PLL is reset");
        $display ("Time: %0t  Instance: %m", $time);
    end
end
always @(charge_pump)
begin
    if (charge_pump == 1'b1) 
    begin
        if (display_msgs == 1'b0)
        begin
            $display ("Note : CMU PLL lost lock due to reset or change in frequency of input clock");
            $display ("Time: %0t  Instance: %m", $time);
            display_msgs = 1'b1;
        end
    end
    else
    begin
        if (display_msgs == 1'b1)
        begin
            $display ("Note : CMU PLL locked to incoming clock");
            $display ("Time: %0t  Instance: %m", $time);
            display_msgs = 1'b0;
        end
    end
end

always @(busy) if (busy == `INACTIVE) charge_pump = 1'b0;
// VCO

stratixiigx_hssi_aux_clock_mult vco (
    .clk(pll_clkin),
    .adjust(charge_pump),
    .reset(reset),
    .clkout(clk_vco), // VCO output
    .busy(busy)
);
defparam vco.clk_multiply_by = multiply_by*divide_by;

// Post divider /L

stratixiigx_hssi_aux_clock_div divide_by_L (
    .clk(clk_vco),
    .reset(reset),
    .clkout(clk_div)
);
defparam divide_by_L.clk_divide_by = divide_by;
defparam divide_by_L.extra_latency = 0;

// Feedback

stratixiigx_hssi_aux_clock_div divide_by_M (
    .clk(clk_div),
    .reset(reset),
    .clkout(clk_pll)
);
defparam divide_by_M.clk_divide_by = multiply_by;
defparam divide_by_M.extra_latency = 0;

// Extra phase shift on output

stratixiigx_hssi_aux_clock_phaseshift extra_ps_clkout (
    .clk(clk_div),
    .clkout(clk_div_delayed)
);
defparam extra_ps_clkout.clk_phase_shift_by = sim_clkout_phase_shift;
        
// Extra phase shift on lock

stratixiigx_hssi_aux_clock_phaseshift extra_ps_lock (
    .clk(charge_pump),
    .clkout(charge_pump_delayed)
);
defparam extra_ps_lock.clk_phase_shift_by = sim_clkout_phase_shift;

always @(busy or reset)
begin
    if (reset  ===  1'b1)
        locked_real <= 1'b0;
    else if (busy == `INACTIVE) 
        locked_real <= 1'b1;
    else
        locked_real <= 1'b0;
end

assign clkout = clk_div_delayed && locked; 
assign dprioout = (dpriodisable_ipd == 1'b1) ? 'b0 : dprioin_ipd;
assign locked = locked_real;
assign fbclkout = clk_pll;
assign vcobypassout = pll_clkin;

endmodule
module DIV_BY_2 (CLK, RESET_N, CLKOUT); // synthesis syn_black_box

   input         CLK, RESET_N;
   output        CLKOUT;
   reg           CLKOUT;
   wire 	 NEXT_VAL;
   
   // state definition
   always @ (posedge CLK or negedge RESET_N)
     if (!RESET_N)
	  CLKOUT <= 1'b0;
     else
          CLKOUT <= NEXT_VAL;
   
    assign   NEXT_VAL = ~CLKOUT;

endmodule // div_by_2
// synchronizer to synchronize the receiver

module CLK_GEN (CLK, RESET_N, CLKOUT);

   input         CLK, RESET_N;
   output	 CLKOUT;
   wire 	 CLKOUT;

   wire 	 CLK8M, CLK4M, CLK2M;
 	 
   DIV_BY_2         DIV_1(.CLK(CLK), .RESET_N(RESET_N), .CLKOUT(CLK8M));
   DIV_BY_2         DIV_2(.CLK(CLK8M), .RESET_N(RESET_N), .CLKOUT(CLK4M));
   DIV_BY_2         DIV_3(.CLK(CLK4M), .RESET_N(RESET_N), .CLKOUT(CLK2M));
   DIV_BY_2         DIV_4(.CLK(CLK2M), .RESET_N(RESET_N), .CLKOUT(CLKOUT));

endmodule // clk_gen
module RCV_DET_SYNC (CLK, RESET_N, RCV_DET, RCV_DET_OUT); // synthesis syn_black_box

   input         CLK, RESET_N, RCV_DET;
   output        RCV_DET_OUT;
   reg           RCV_DET_OUT;
   reg 		 RCV_DET_MID; 	 

   always @ (posedge CLK or negedge RESET_N)
     if (!RESET_N)
       begin
	  RCV_DET_OUT <= 1'b0;
	  RCV_DET_MID <= 1'b0;
       end
     else
       begin
          RCV_DET_OUT <= RCV_DET_MID;
	  RCV_DET_MID <= RCV_DET;
       end

endmodule // rcv_det_sync
// receiver detect finite state machine
module RCV_DET_FSM (CLK, RESET_N, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND); // synthesis syn_black_box

   input         CLK, RESET_N, COM_PASS, PROBE_PASS;
   
   output 	 RCV_FOUND, DET_ON, DETECT_VALID;
   reg [2:0] 	 STATE;
   reg [2:0] 	 NEXTSTATE;
   reg 		 RCV_FOUND, DET_ON, NEXT_RCV_FOUND, DETECT_VALID;
   
   reg		FAKE_RCV_PRESENT;
   
 // state definition
   parameter RESET   = 3'b000;
   parameter WAKE    = 3'b001;
   parameter STATE_1 = 3'b011;
   parameter STATE_2 = 3'b101;
   parameter HOLD    = 3'b100;
   
 
   initial
   begin
   	FAKE_RCV_PRESENT = 1'b1;
   end

// State logic and FSM
   always @ (posedge CLK or negedge RESET_N)
     if(!RESET_N)
       STATE <= RESET;
     else
       STATE <= NEXTSTATE;

   always @ (STATE or COM_PASS)
     begin
	case (STATE)
	  RESET: NEXTSTATE = WAKE;
	  WAKE: begin
	     if (COM_PASS) 
	     	NEXTSTATE = STATE_1;
	     else NEXTSTATE = WAKE;
	  end
	  STATE_1: NEXTSTATE = STATE_2;
	  STATE_2: NEXTSTATE = HOLD;
	  HOLD: NEXTSTATE = HOLD;
	  default: NEXTSTATE = RESET;
	endcase // case(state)
     end // always @ (state or com_pass)

// Output logic
   always @ (posedge CLK or negedge RESET_N)
     if(!RESET_N)
	  RCV_FOUND <= 1'b0;
     else
          RCV_FOUND <= NEXT_RCV_FOUND;

    always @ (NEXTSTATE or PROBE_PASS or FAKE_RCV_PRESENT)
      begin
	 if ((NEXTSTATE == STATE_2) && (!PROBE_PASS) && FAKE_RCV_PRESENT)  // probe pass goes up slow -> there is rx 
	   NEXT_RCV_FOUND = 1'b1;
	 else if ((NEXTSTATE == HOLD) && FAKE_RCV_PRESENT)
	   NEXT_RCV_FOUND = RCV_FOUND;
	 else    // probe pass goes up fast -> no rx
	   NEXT_RCV_FOUND = 1'b0;
      end
      
// there is no rcv_det_syn
   always @ (STATE)
     if (STATE == RESET)
       DET_ON = 1'b0;
     else
       DET_ON = 1'b1;
   	
   always @ (STATE)
     if (STATE == HOLD)
       DETECT_VALID = 1'b1;
     else
       DETECT_VALID = 1'b0;
   
endmodule // rcv_det_fsm
module RCV_DET_CONTROL (CLK, RCV_DET_EN, RCV_DET_PDB, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND);
   input         CLK, RCV_DET_EN, RCV_DET_PDB, COM_PASS, PROBE_PASS;
   output 	 DET_ON, DETECT_VALID, RCV_FOUND;
   wire 	 RCV_DET_SYN;
   
   RCV_DET_SYNC  XRCV_DET_SYNC (CLK, RCV_DET_PDB, RCV_DET_EN, RCV_DET_SYN);
   RCV_DET_FSM   XRCV_DET_FSM (CLK, RCV_DET_SYN, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND);
endmodule // rcv_det_control
// Digital part of the receiver detection
module RCV_DET_DIGITAL (OSCCLK, RCV_DET_PDB, RCV_DET_EN, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND);

   input  OSCCLK, RCV_DET_PDB, RCV_DET_EN, COM_PASS, PROBE_PASS;
   output DET_ON, RCV_FOUND, DETECT_VALID;
   wire   CLK;

   CLK_GEN         XCLK_GEN (OSCCLK, RCV_DET_PDB, CLK);
   RCV_DET_CONTROL XRCV_DET_CTRL(CLK, RCV_DET_EN, RCV_DET_PDB, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND);
   
endmodule // rcv_det_digital
// This module is the behavior model for rx_det block
// If there is rx -  set parameter RX_EXIST to 1, set to 0 otherwise

`timescale 1ps / 1ps

module stratixiigx_hssi_tx_rx_det (RX_DET_PDB, CLK15M, TX_DET_RX, RX_FOUND, RX_DET_VALID);

input           RX_DET_PDB, CLK15M, TX_DET_RX;
output 	        RX_FOUND, RX_DET_VALID;
wire            RX_FOUND, RX_DET_VALID;
wire 	        COM_PASS, PROBE_PASS, DET_ON;
   
   parameter 	RX_EXIST = 1'b1;

   assign #100000	COM_PASS = DET_ON;
   assign #100000 	PROBE_PASS = ~RX_EXIST;
   
   
    
RCV_DET_DIGITAL XRCV_DET_DIGITAL (.OSCCLK (CLK15M), 
				  .RCV_DET_PDB (RX_DET_PDB), 
				  .RCV_DET_EN (TX_DET_RX), 
				  .COM_PASS (COM_PASS), 
				  .PROBE_PASS (PROBE_PASS), 
				  .DET_ON (DET_ON),
				  .DETECT_VALID (RX_DET_VALID),
				  .RCV_FOUND (RX_FOUND));

endmodule // RX_DET

`timescale 1 ps / 1 ps
module stratixiigx_hssi_tx_ser (
    serialclk,
    parallelclk,
    datain,
    reset,
    elecreset,
    rseriallpbkdatain,
    rseriallpbkctrl,
    rdwidth,
    rdoublewidth,
    serialdataout,
    seriallpbkdataout,
    clkout
);

input serialclk;
input parallelclk;
input [19:0] datain;
input reset;
input elecreset;           // Z dataout buf
input rseriallpbkdatain;
input rseriallpbkctrl;
input rdwidth;             // 0 => 8-bit, 1 => 10-bit
input rdoublewidth;        // 0 => 8/10,  1 => 16/20

output serialdataout;
output seriallpbkdataout;
output clkout;             // = parallelclk/2 when doublewidth 

wire         dataout_tmp;
reg          VOP_int;      // serial data from serializer
wire   [9:0] PUDR;         // parallel data from Byte Deserializer

reg    [9:0] PUDR_int;     // one latency
reg    [9:0] PUDR_sync_1;  // second latency
reg    [9:0] PUDR_sync;    // may be 1 fastclk latency: loaded with cmuclk0

reg          CMUCLKL_sync_1;
reg          CMUCLKL_sync; // parallel clock synch'd to cmuclk0 - 2/3rd fastclk latency

reg    [3:0] cnt;
reg    [3:0] index;
reg    [3:0] cnt1;
wire         load_cnt;
wire         CMUCLK0;
wire         CMUCLK0_dly;
wire         CMUCLK0_dly2;

reg          elecreset1, elecreset2;
reg          elecreset_dly;   // delay electric idle

// Byte Deserializer
wire       mux_clkin;
wire [9:0] mux_a_in;
wire [9:0] mux_b_in;
reg        mux_clk_by2;
reg  [9:0] mux_a_in_sync;
reg  [9:0] mux_b_in_sync;
wire [9:0] mux_d;
wire       mux_select;
reg  [9:0] mux_dataout;
wire       mux_clkout;

assign mux_clkin = parallelclk;
assign mux_a_in = {datain[9],datain[8],datain[7],datain[6],datain[5],
                   datain[4],datain[3],datain[2],datain[1],datain[0]};
assign mux_b_in = {datain[19],datain[18],datain[17],datain[16],datain[15],
                   datain[14],datain[13],datain[12],datain[11],datain[10]};
assign PUDR = mux_dataout;
assign mux_clkout = (rdoublewidth === 1'b1) ? mux_clk_by2 : mux_clkin;

initial 
begin
    mux_clk_by2 = 1'b0;
end

always @(posedge reset or posedge mux_clkin)
begin
    if (reset === 1'b1)
        mux_clk_by2 <= 1'b0;
    else if (mux_clkin)
        mux_clk_by2 <= ~mux_clk_by2;
end 

always @(posedge reset or posedge mux_clkout)
begin
    if (reset === 1'b1)
        begin
            mux_a_in_sync <= 10'd0;
            mux_b_in_sync <= 10'd0;
        end
    else if (mux_clkout)
        begin
            mux_a_in_sync <= mux_a_in;
            mux_b_in_sync <= mux_b_in;
        end
end 

assign mux_select = (rdoublewidth === 1'b1 && mux_clk_by2 === 1'b1) ? 1'b1 : 1'b0;
assign mux_d = (rdoublewidth !== 1'b1) ? mux_a_in_sync : (mux_select === 1'b1) ? mux_a_in_sync : mux_b_in_sync;

always @(posedge reset or posedge mux_clkin)
begin
    if (reset === 1'b1)
        mux_dataout <= 10'd0;
    else if (mux_clkin)
        mux_dataout <= mux_d;
end 


initial
begin
    CMUCLKL_sync_1 = 1'b0;
    CMUCLKL_sync   = 1'b0;
    cnt            = 4'd8;
    cnt1           = 4'd9;
    PUDR_sync_1    = 10'd0;
    PUDR_int       = 10'd0;
    PUDR_sync      = 10'd0;
end

always @ (posedge parallelclk)
begin
    elecreset1 <= elecreset;
    elecreset2 <= elecreset1;
    elecreset_dly <= elecreset2;
end

assign seriallpbkdataout = VOP_int;

assign dataout_tmp = (rseriallpbkctrl === 1'b1) ? rseriallpbkdatain : VOP_int;
assign serialdataout = (elecreset_dly === 1'b1) ? 1'bz : dataout_tmp;
assign clkout = mux_clkout;

assign CMUCLK0 = serialclk;
assign #100 CMUCLK0_dly = serialclk;
assign #10  CMUCLK0_dly2 = CMUCLK0_dly;

// 110 ps phase offset on serial bit
always @ (CMUCLK0_dly2)
      VOP_int <= PUDR_sync[index];

// LFCLKP is synchronized by 2 flops
always @ (posedge reset or posedge CMUCLK0)
begin
   if (reset)
      begin
         CMUCLKL_sync_1   <= 1'b0;
         CMUCLKL_sync     <= 1'b0;
      end
   else
      begin
         CMUCLKL_sync_1   <= parallelclk;
         CMUCLKL_sync     <= CMUCLKL_sync_1;
      end
end

// Load counter with 0   at rising edge of syncd slow clock
assign load_cnt = CMUCLKL_sync_1 & ~CMUCLKL_sync;

// counter to div by 5
always @ (posedge reset or posedge CMUCLK0)
begin
   if (reset === 1'b1)
      begin
         cnt <= 4'd8;
         cnt1 <= 4'd9;
      end
   else if (load_cnt === 1'b1 || ((cnt>=4'd8) && rdwidth) || ((cnt>=4'd6) && ~rdwidth))
      begin
         cnt <= 4'd0;
         cnt1 <= 4'd1;
      end
   else
      begin
         cnt <= cnt + 2;
         cnt1 <= cnt1 + 2;
      end
end

// Latch PUDR_int using parallelclk
always @ (posedge reset or posedge parallelclk)
begin
   if (reset === 1'b1)
      begin
         PUDR_sync_1 <= 10'd0;
         PUDR_int <= 10'd0;
      end
   else
      begin
         PUDR_int <= PUDR;
         PUDR_sync_1 <= PUDR_int;
      end
end

// Latch PUDR_sync using CMUCLK0
always @ (posedge reset or posedge CMUCLK0)
begin
   if (reset === 1'b1)
      PUDR_sync <= 10'd0;
   else if (load_cnt === 1'b1)
      PUDR_sync <= {PUDR_sync_1[9], PUDR_sync_1[8], PUDR_sync_1[7], PUDR_sync_1[6],
                    PUDR_sync_1[5], PUDR_sync_1[4], PUDR_sync_1[3], PUDR_sync_1[2],
                    PUDR_sync_1[1], PUDR_sync_1[0]};
end

       
// index will change from 0 to 9 incrementally at 2x speed as CMUCLK0
always @ (CMUCLK0_dly)
   if (CMUCLK0_dly)
      index <= cnt;  
   else
      index <= cnt1;

endmodule


// 
// no digital behavior to simulate
//

`timescale 1 ps / 1 ps
module stratixiigx_hssi_calibration_block (
    clk,
    powerdn,
    enabletestbus,
    calibrationstatus
);

input  clk;
input  powerdn;
input  enabletestbus;
output [4:0] calibrationstatus;

parameter use_continuous_calibration_mode = "false";
parameter rx_calibration_write_test_value = 0;
parameter tx_calibration_write_test_value = 0;
parameter enable_rx_calibration_test_write = "false";
parameter enable_tx_calibration_test_write = "false";
parameter send_rx_calibration_status = "true";

endmodule

//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 70 mux21 7 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_phystatus_generator
	( 
	clk,
	latched_p0,
	latched_p0s,
	latched_p1,
	latched_p2,
	phystat_ena,
	phystatus,
	power_state_transition_done,
	power_state_transition_done_ena,
	powerdown,
	reset_n,
	rphystatus_rst_toggle,
	rx_detect_valid) /* synthesis synthesis_clearbox=1 */;
	input   clk;
	input   latched_p0;
	input   latched_p0s;
	input   latched_p1;
	input   latched_p2;
	input   phystat_ena;
	output   phystatus;
	input   power_state_transition_done;
	input   power_state_transition_done_ena;
	input   [1:0]  powerdown;
	input   reset_n;
	input   rphystatus_rst_toggle;
	input   rx_detect_valid;

	reg	nliiO31;
	reg	nliiO32;
	reg	nliiO33;
	reg	nlill28;
	reg	nlill29;
	reg	nlill30;
	reg	nliOi25;
	reg	nliOi26;
	reg	nliOi27;
	reg	nll0O16;
	reg	nll0O17;
	reg	nll0O18;
	reg	nll1i22;
	reg	nll1i23;
	reg	nll1i24;
	reg	nll1O19;
	reg	nll1O20;
	reg	nll1O21;
	reg	nllil13;
	reg	nllil14;
	reg	nllil15;
	reg	nllli10;
	reg	nllli11;
	reg	nllli12;
	reg	nllOi7;
	reg	nllOi8;
	reg	nllOi9;
	reg	nllOO4;
	reg	nllOO5;
	reg	nllOO6;
	reg	nlO1l1;
	reg	nlO1l2;
	reg	nlO1l3;
	reg	n01i;
	reg	n01O;
	reg	n1Ol;
	reg	n1OO;
	reg	ni1i;
	reg	ni1O;
	reg	n00i;
	reg	n00l;
	reg	n00O;
	reg	n0ii;
	reg	n0il;
	reg	n0iO;
	reg	n0li;
	reg	n10i;
	reg	n10l;
	reg	n10O;
	reg	n11i;
	reg	n11l;
	reg	n11O;
	reg	n1il;
	reg	n1iO;
	reg	n1li;
	reg	n1ll;
	reg	n1lO;
	reg	n1Oi;
	reg	ni0i;
	reg	ni0l;
	reg	niiO;
	reg	nili;
	reg	nill;
	reg	nilO;
	reg	niOO;
	reg	nl0l;
	reg	nl1i;
	reg	nl1l;
	reg	nl1O;
	reg	nlOOO;
	wire	wire_ni0O_dataout;
	wire	wire_niii_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nlll_dataout;
	wire  nliOO;
	wire  nll0l;
	wire  nlllO;

	initial
		nliiO31 = {1{1'b1}};
	always @ ( posedge clk)
		  nliiO31 <= nliiO33;
	initial
		nliiO32 = {1{1'b1}};
	always @ ( posedge clk)
		  nliiO32 <= (nliiO33 ^ nliiO31);
	initial
		nliiO33 = 0;
	always @ ( posedge clk)
		  nliiO33 <= nliiO31;
	initial
		nlill28 = {1{1'b1}};
	always @ ( posedge clk)
		  nlill28 <= nlill30;
	initial
		nlill29 = {1{1'b1}};
	always @ ( posedge clk)
		  nlill29 <= (nlill30 ^ nlill28);
	initial
		nlill30 = 0;
	always @ ( posedge clk)
		  nlill30 <= nlill28;
	initial
		nliOi25 = {1{1'b1}};
	always @ ( posedge clk)
		  nliOi25 <= nliOi27;
	initial
		nliOi26 = {1{1'b1}};
	always @ ( posedge clk)
		  nliOi26 <= (nliOi27 ^ nliOi25);
	initial
		nliOi27 = 0;
	always @ ( posedge clk)
		  nliOi27 <= nliOi25;
	initial
		nll0O16 = {1{1'b1}};
	always @ ( posedge clk)
		  nll0O16 <= nll0O18;
	initial
		nll0O17 = {1{1'b1}};
	always @ ( posedge clk)
		  nll0O17 <= (nll0O18 ^ nll0O16);
	initial
		nll0O18 = 0;
	always @ ( posedge clk)
		  nll0O18 <= nll0O16;
	initial
		nll1i22 = {1{1'b1}};
	always @ ( posedge clk)
		  nll1i22 <= nll1i24;
	initial
		nll1i23 = {1{1'b1}};
	always @ ( posedge clk)
		  nll1i23 <= (nll1i24 ^ nll1i22);
	initial
		nll1i24 = 0;
	always @ ( posedge clk)
		  nll1i24 <= nll1i22;
	initial
		nll1O19 = {1{1'b1}};
	always @ ( posedge clk)
		  nll1O19 <= nll1O21;
	initial
		nll1O20 = {1{1'b1}};
	always @ ( posedge clk)
		  nll1O20 <= (nll1O21 ^ nll1O19);
	initial
		nll1O21 = 0;
	always @ ( posedge clk)
		  nll1O21 <= nll1O19;
	initial
		nllil13 = {1{1'b1}};
	always @ ( posedge clk)
		  nllil13 <= nllil15;
	initial
		nllil14 = {1{1'b1}};
	always @ ( posedge clk)
		  nllil14 <= (nllil15 ^ nllil13);
	initial
		nllil15 = 0;
	always @ ( posedge clk)
		  nllil15 <= nllil13;
	initial
		nllli10 = {1{1'b1}};
	always @ ( posedge clk)
		  nllli10 <= nllli12;
	initial
		nllli11 = {1{1'b1}};
	always @ ( posedge clk)
		  nllli11 <= (nllli12 ^ nllli10);
	initial
		nllli12 = 0;
	always @ ( posedge clk)
		  nllli12 <= nllli10;
	initial
		nllOi7 = {1{1'b1}};
	always @ ( posedge clk)
		  nllOi7 <= nllOi9;
	initial
		nllOi8 = {1{1'b1}};
	always @ ( posedge clk)
		  nllOi8 <= (nllOi9 ^ nllOi7);
	initial
		nllOi9 = 0;
	always @ ( posedge clk)
		  nllOi9 <= nllOi7;
	initial
		nllOO4 = {1{1'b1}};
	always @ ( posedge clk)
		  nllOO4 <= nllOO6;
	initial
		nllOO5 = {1{1'b1}};
	always @ ( posedge clk)
		  nllOO5 <= (nllOO6 ^ nllOO4);
	initial
		nllOO6 = 0;
	always @ ( posedge clk)
		  nllOO6 <= nllOO4;
	initial
		nlO1l1 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO1l1 <= nlO1l3;
	initial
		nlO1l2 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO1l2 <= (nlO1l3 ^ nlO1l1);
	initial
		nlO1l3 = 0;
	always @ ( posedge clk)
		  nlO1l3 <= nlO1l1;
	initial
	begin
		n01i = 0;
		n01O = 0;
		n1Ol = 0;
		n1OO = 0;
	end
	always @ ( posedge clk or negedge reset_n)
	begin
		if (reset_n == 1'b0) 
		begin
			n01i <= 0;
			n01O <= 0;
			n1Ol <= 0;
			n1OO <= 0;
		end
		else if  (nliOO == 1'b1) 
		begin
			n01i <= n00O;
			n01O <= n0ii;
			n1Ol <= n00i;
			n1OO <= n00l;
		end
	end
	initial
	begin
		ni1i = 0;
		ni1O = 0;
	end
	always @ ( posedge clk or negedge reset_n)
	begin
		if (reset_n == 1'b0) 
		begin
			ni1i <= 1;
			ni1O <= 1;
		end
		else 
		begin
			ni1i <= wire_nl0O_dataout;
			ni1O <= nll0l;
		end
	end
	initial
	begin
		n00i = 0;
		n00l = 0;
		n00O = 0;
		n0ii = 0;
		n0il = 0;
		n0iO = 0;
		n0li = 0;
		n10i = 0;
		n10l = 0;
		n10O = 0;
		n11i = 0;
		n11l = 0;
		n11O = 0;
		n1il = 0;
		n1iO = 0;
		n1li = 0;
		n1ll = 0;
		n1lO = 0;
		n1Oi = 0;
		ni0i = 0;
		ni0l = 0;
		niiO = 0;
		nili = 0;
		nill = 0;
		nilO = 0;
		niOO = 0;
		nl0l = 0;
		nl1i = 0;
		nl1l = 0;
		nl1O = 0;
		nlOOO = 0;
	end
	always @ ( posedge clk or negedge reset_n)
	begin
		if (reset_n == 1'b0) 
		begin
			n00i <= 0;
			n00l <= 0;
			n00O <= 0;
			n0ii <= 0;
			n0il <= 0;
			n0iO <= 0;
			n0li <= 0;
			n10i <= 0;
			n10l <= 0;
			n10O <= 0;
			n11i <= 0;
			n11l <= 0;
			n11O <= 0;
			n1il <= 0;
			n1iO <= 0;
			n1li <= 0;
			n1ll <= 0;
			n1lO <= 0;
			n1Oi <= 0;
			ni0i <= 0;
			ni0l <= 0;
			niiO <= 0;
			nili <= 0;
			nill <= 0;
			nilO <= 0;
			niOO <= 0;
			nl0l <= 0;
			nl1i <= 0;
			nl1l <= 0;
			nl1O <= 0;
			nlOOO <= 0;
		end
		else 
		begin
			n00i <= n0il;
			n00l <= n0iO;
			n00O <= n0li;
			n0ii <= nlOOO;
			n0il <= latched_p0;
			n0iO <= latched_p0s;
			n0li <= latched_p1;
			n10i <= n10l;
			n10l <= n10O;
			n10O <= n1il;
			n11i <= n11l;
			n11l <= n11O;
			n11O <= n10i;
			n1il <= ((n1iO & (phystat_ena & (~ power_state_transition_done_ena))) & nliiO32);
			n1iO <= (~ ((((~ (n1Ol ^ n1li)) & (~ ((n1OO ^ n1ll) ^ (~ nliOi26)))) & (~ ((n01i ^ n1lO) ^ (~ nlill29)))) & (~ (n01O ^ n1Oi))));
			n1li <= n1Ol;
			n1ll <= n1OO;
			n1lO <= n01i;
			n1Oi <= n01O;
			ni0i <= wire_ni0O_dataout;
			ni0l <= niiO;
			niiO <= wire_nlil_dataout;
			nili <= (((~ nill) & ((nilO & rx_detect_valid) & nllli11)) & nllil14);
			nill <= rx_detect_valid;
			nilO <= niOO;
			niOO <= latched_p1;
			nl0l <= power_state_transition_done;
			nl1i <= wire_nliO_dataout;
			nl1l <= nl1O;
			nl1O <= nl0l;
			nlOOO <= latched_p2;
		end
	end
	or(wire_ni0O_dataout, wire_niii_dataout, (((~ wire_nlil_dataout) & niiO) & nll0O17));
	and(wire_niii_dataout, ni0i, ~{wire_nliO_dataout});
	and(wire_nl0O_dataout, wire_nlii_dataout, ~{rphystatus_rst_toggle});
	and(wire_nlii_dataout, ni1i, ~{wire_nliO_dataout});
	and(wire_nlil_dataout, phystat_ena, (powerdown[0] & powerdown[1]));
	assign		wire_nliO_dataout = (power_state_transition_done_ena === 1'b1) ? (nl1O & (~ nl1l)) : n11i;
	or(wire_nlll_dataout, ((ni1i | (nili | ((nl1i | ni1O) | (~ nlO1l2)))) | (~ nllOO5)), ((ni0i | (ni0l & (~ wire_nlil_dataout))) | (~ nllOi8)));
	assign
		nliOO = ((((((n00i & (~ n0ii)) & (~ n00O)) & (~ n00l)) | (((((~ n00i) & (~ n0ii)) & (~ n00O)) & n00l) & nll1O20)) | ((((~ n00i) & (~ n0ii)) & n00O) & (~ n00l))) | (((((~ n00i) & n0ii) & (~ n00O)) & (~ n00l)) & nll1i23)),
		nll0l = 1'b0,
		nlllO = 1'b1,
		phystatus = wire_nlll_dataout;
endmodule //stratixiigx_hssi_phystatus_generator
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 140 mux21 128 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_rx_pipe_interface
	( 
	clk,
	latched_p0,
	latched_p0s,
	latched_p1,
	latched_p2,
	polinv_rx,
	polinv_rx_int,
	rclkcmpinsertpad,
	reset_n,
	rrdwidth_rx,
	rrx_pipe_enable,
	rx_detect_valid,
	rx_detect_valid_sync,
	rx_found,
	rxbeacon,
	rxd,
	rxd_ch,
	rxelecidle,
	rxelectricalidle,
	rxpolarity,
	rxstatus,
	rxvalid) /* synthesis synthesis_clearbox=1 */;
	input   clk;
	input   latched_p0;
	input   latched_p0s;
	input   latched_p1;
	input   latched_p2;
	input   polinv_rx;
	output   polinv_rx_int;
	input   rclkcmpinsertpad;
	input   reset_n;
	input   rrdwidth_rx;
	input   rrx_pipe_enable;
	input   rx_detect_valid;
	input   rx_detect_valid_sync;
	input   rx_found;
	input   rxbeacon;
	input   [63:0]  rxd;
	output   [63:0]  rxd_ch;
	output   rxelecidle;
	input   rxelectricalidle;
	input   rxpolarity;
	output   [2:0]  rxstatus;
	output   rxvalid;

	reg	nlllOi55;
	reg	nlllOi56;
	reg	nlllOi57;
	reg	nllO0l49;
	reg	nllO0l50;
	reg	nllO0l51;
	reg	nllO1l52;
	reg	nllO1l53;
	reg	nllO1l54;
	reg	nllOil46;
	reg	nllOil47;
	reg	nllOil48;
	reg	nllOlO43;
	reg	nllOlO44;
	reg	nllOlO45;
	reg	nllOOl40;
	reg	nllOOl41;
	reg	nllOOl42;
	reg	nlO01O22;
	reg	nlO01O23;
	reg	nlO01O24;
	reg	nlO0il19;
	reg	nlO0il20;
	reg	nlO0il21;
	reg	nlO0lO16;
	reg	nlO0lO17;
	reg	nlO0lO18;
	reg	nlO0Ol13;
	reg	nlO0Ol14;
	reg	nlO0Ol15;
	reg	nlO10O34;
	reg	nlO10O35;
	reg	nlO10O36;
	reg	nlO11l37;
	reg	nlO11l38;
	reg	nlO11l39;
	reg	nlO1il31;
	reg	nlO1il32;
	reg	nlO1il33;
	reg	nlO1lO28;
	reg	nlO1lO29;
	reg	nlO1lO30;
	reg	nlO1OO25;
	reg	nlO1OO26;
	reg	nlO1OO27;
	reg	nlOi1l10;
	reg	nlOi1l11;
	reg	nlOi1l12;
	reg	nlOiii7;
	reg	nlOiii8;
	reg	nlOiii9;
	reg	nlOill4;
	reg	nlOill5;
	reg	nlOill6;
	reg	nlOiOl1;
	reg	nlOiOl2;
	reg	nlOiOl3;
	reg	n100l;
	reg	n100O;
	reg	n10ii;
	reg	n10il;
	reg	n10O;
	reg	n11ii;
	reg	n11il;
	reg	n11iO;
	reg	n11l;
	reg	n11Oi;
	reg	n1lii;
	reg	n1liO;
	reg	n1lll;
	reg	n1O1i;
	reg	niO0i;
	reg	niO0l;
	reg	niO0O;
	reg	niO1l;
	reg	niO1O;
	reg	niOii;
	reg	niOil;
	reg	niOiO;
	reg	niOli;
	reg	niOll;
	reg	niOlO;
	reg	niOOi;
	reg	niOOl;
	reg	niOOO;
	reg	nl00i;
	reg	nl00l;
	reg	nl00O;
	reg	nl01i;
	reg	nl01l;
	reg	nl01O;
	reg	nl0ii;
	reg	nl0il;
	reg	nl0iO;
	reg	nl0li;
	reg	nl0ll;
	reg	nl0lO;
	reg	nl0Oi;
	reg	nl0Ol;
	reg	nl0OO;
	reg	nl10i;
	reg	nl10l;
	reg	nl10O;
	reg	nl11i;
	reg	nl11l;
	reg	nl11O;
	reg	nl1ii;
	reg	nl1il;
	reg	nl1iO;
	reg	nl1li;
	reg	nl1ll;
	reg	nl1lO;
	reg	nl1Oi;
	reg	nl1Ol;
	reg	nl1OO;
	reg	nli0i;
	reg	nli0l;
	reg	nli0O;
	reg	nli1i;
	reg	nli1l;
	reg	nli1O;
	reg	nliii;
	reg	nliil;
	reg	nliiO;
	reg	nlili;
	reg	nlill;
	reg	nlilO;
	reg	nliOi;
	reg	nliOl;
	reg	nliOO;
	reg	nll0i;
	reg	nll0l;
	reg	nll0O;
	reg	nll1i;
	reg	nll1l;
	reg	nll1O;
	reg	nlOliO;
	reg	nlOlli;
	reg	nlOlll;
	reg	nlOllO;
	wire	wire_n00i_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n10iO_dataout;
	wire	wire_n10li_dataout;
	wire	wire_n10ll_dataout;
	wire	wire_n10lO_dataout;
	wire	wire_n10Oi_dataout;
	wire	wire_n10Ol_dataout;
	wire	wire_n10OO_dataout;
	wire	wire_n11li_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1i0i_dataout;
	wire	wire_n1i0l_dataout;
	wire	wire_n1i0O_dataout;
	wire	wire_n1i1i_dataout;
	wire	wire_n1i1l_dataout;
	wire	wire_n1i1O_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1iii_dataout;
	wire	wire_n1iil_dataout;
	wire	wire_n1iiO_dataout;
	wire	wire_n1ili_dataout;
	wire	wire_n1ill_dataout;
	wire	wire_n1ilO_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1iOi_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1lil_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lli_dataout;
	wire	wire_n1llO_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1lOi_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_ni_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_niii_dataout;
	wire	wire_niil_dataout;
	wire	wire_niiO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nili_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nli_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO0l_dataout;
	wire	wire_nlO0O_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOlOi_dataout;
	wire	wire_nlOlOl_dataout;
	wire	wire_nlOlOO_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOO0i_dataout;
	wire	wire_nlOO0l_dataout;
	wire	wire_nlOO0O_dataout;
	wire	wire_nlOO1i_dataout;
	wire	wire_nlOO1l_dataout;
	wire	wire_nlOO1O_dataout;
	wire	wire_nlOOii_dataout;
	wire	wire_nlOOil_dataout;
	wire	wire_nlOOiO_dataout;
	wire	wire_nlOOli_dataout;
	wire	wire_nlOOll_dataout;
	wire	wire_nlOOlO_dataout;
	wire	wire_nlOOOi_dataout;
	wire	wire_nO_dataout;
	wire  nlllOO;
	wire  nllO0i;
	wire  nllO1i;
	wire  nllOii;
	wire  nllOli;
	wire  nllOll;
	wire  nlO00l;
	wire  nlO00O;
	wire  nlO01l;
	wire  nlO0ii;
	wire  nlO0li;
	wire  nlO0ll;
	wire  nlO10i;
	wire  nlO10l;
	wire  nlO11i;
	wire  nlO1li;
	wire  nlO1ll;
	wire  nlO1Ol;
	wire  nlOi0i;
	wire  nlOi0l;
	wire  nlOi0O;
	wire  nlOi1i;
	wire  nlOiiO;
	wire  nlOili;
	wire  nlOiOi;

	initial
		nlllOi55 = {1{1'b1}};
	always @ ( posedge clk)
		  nlllOi55 <= nlllOi57;
	initial
		nlllOi56 = {1{1'b1}};
	always @ ( posedge clk)
		  nlllOi56 <= (nlllOi57 ^ nlllOi55);
	initial
		nlllOi57 = 0;
	always @ ( posedge clk)
		  nlllOi57 <= nlllOi55;
	initial
		nllO0l49 = {1{1'b1}};
	always @ ( posedge clk)
		  nllO0l49 <= nllO0l51;
	initial
		nllO0l50 = {1{1'b1}};
	always @ ( posedge clk)
		  nllO0l50 <= (nllO0l51 ^ nllO0l49);
	initial
		nllO0l51 = 0;
	always @ ( posedge clk)
		  nllO0l51 <= nllO0l49;
	initial
		nllO1l52 = {1{1'b1}};
	always @ ( posedge clk)
		  nllO1l52 <= nllO1l54;
	initial
		nllO1l53 = {1{1'b1}};
	always @ ( posedge clk)
		  nllO1l53 <= (nllO1l54 ^ nllO1l52);
	initial
		nllO1l54 = 0;
	always @ ( posedge clk)
		  nllO1l54 <= nllO1l52;
	initial
		nllOil46 = {1{1'b1}};
	always @ ( posedge clk)
		  nllOil46 <= nllOil48;
	initial
		nllOil47 = {1{1'b1}};
	always @ ( posedge clk)
		  nllOil47 <= (nllOil48 ^ nllOil46);
	initial
		nllOil48 = 0;
	always @ ( posedge clk)
		  nllOil48 <= nllOil46;
	initial
		nllOlO43 = {1{1'b1}};
	always @ ( posedge clk)
		  nllOlO43 <= nllOlO45;
	initial
		nllOlO44 = {1{1'b1}};
	always @ ( posedge clk)
		  nllOlO44 <= (nllOlO45 ^ nllOlO43);
	initial
		nllOlO45 = 0;
	always @ ( posedge clk)
		  nllOlO45 <= nllOlO43;
	initial
		nllOOl40 = {1{1'b1}};
	always @ ( posedge clk)
		  nllOOl40 <= nllOOl42;
	initial
		nllOOl41 = {1{1'b1}};
	always @ ( posedge clk)
		  nllOOl41 <= (nllOOl42 ^ nllOOl40);
	initial
		nllOOl42 = 0;
	always @ ( posedge clk)
		  nllOOl42 <= nllOOl40;
	initial
		nlO01O22 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO01O22 <= nlO01O24;
	initial
		nlO01O23 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO01O23 <= (nlO01O24 ^ nlO01O22);
	initial
		nlO01O24 = 0;
	always @ ( posedge clk)
		  nlO01O24 <= nlO01O22;
	initial
		nlO0il19 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO0il19 <= nlO0il21;
	initial
		nlO0il20 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO0il20 <= (nlO0il21 ^ nlO0il19);
	initial
		nlO0il21 = 0;
	always @ ( posedge clk)
		  nlO0il21 <= nlO0il19;
	initial
		nlO0lO16 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO0lO16 <= nlO0lO18;
	initial
		nlO0lO17 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO0lO17 <= (nlO0lO18 ^ nlO0lO16);
	initial
		nlO0lO18 = 0;
	always @ ( posedge clk)
		  nlO0lO18 <= nlO0lO16;
	initial
		nlO0Ol13 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO0Ol13 <= nlO0Ol15;
	initial
		nlO0Ol14 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO0Ol14 <= (nlO0Ol15 ^ nlO0Ol13);
	initial
		nlO0Ol15 = 0;
	always @ ( posedge clk)
		  nlO0Ol15 <= nlO0Ol13;
	initial
		nlO10O34 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO10O34 <= nlO10O36;
	initial
		nlO10O35 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO10O35 <= (nlO10O36 ^ nlO10O34);
	initial
		nlO10O36 = 0;
	always @ ( posedge clk)
		  nlO10O36 <= nlO10O34;
	initial
		nlO11l37 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO11l37 <= nlO11l39;
	initial
		nlO11l38 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO11l38 <= (nlO11l39 ^ nlO11l37);
	initial
		nlO11l39 = 0;
	always @ ( posedge clk)
		  nlO11l39 <= nlO11l37;
	initial
		nlO1il31 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO1il31 <= nlO1il33;
	initial
		nlO1il32 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO1il32 <= (nlO1il33 ^ nlO1il31);
	initial
		nlO1il33 = 0;
	always @ ( posedge clk)
		  nlO1il33 <= nlO1il31;
	initial
		nlO1lO28 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO1lO28 <= nlO1lO30;
	initial
		nlO1lO29 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO1lO29 <= (nlO1lO30 ^ nlO1lO28);
	initial
		nlO1lO30 = 0;
	always @ ( posedge clk)
		  nlO1lO30 <= nlO1lO28;
	initial
		nlO1OO25 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO1OO25 <= nlO1OO27;
	initial
		nlO1OO26 = {1{1'b1}};
	always @ ( posedge clk)
		  nlO1OO26 <= (nlO1OO27 ^ nlO1OO25);
	initial
		nlO1OO27 = 0;
	always @ ( posedge clk)
		  nlO1OO27 <= nlO1OO25;
	initial
		nlOi1l10 = {1{1'b1}};
	always @ ( posedge clk)
		  nlOi1l10 <= nlOi1l12;
	initial
		nlOi1l11 = {1{1'b1}};
	always @ ( posedge clk)
		  nlOi1l11 <= (nlOi1l12 ^ nlOi1l10);
	initial
		nlOi1l12 = 0;
	always @ ( posedge clk)
		  nlOi1l12 <= nlOi1l10;
	initial
		nlOiii7 = {1{1'b1}};
	always @ ( posedge clk)
		  nlOiii7 <= nlOiii9;
	initial
		nlOiii8 = {1{1'b1}};
	always @ ( posedge clk)
		  nlOiii8 <= (nlOiii9 ^ nlOiii7);
	initial
		nlOiii9 = 0;
	always @ ( posedge clk)
		  nlOiii9 <= nlOiii7;
	initial
		nlOill4 = {1{1'b1}};
	always @ ( posedge clk)
		  nlOill4 <= nlOill6;
	initial
		nlOill5 = {1{1'b1}};
	always @ ( posedge clk)
		  nlOill5 <= (nlOill6 ^ nlOill4);
	initial
		nlOill6 = 0;
	always @ ( posedge clk)
		  nlOill6 <= nlOill4;
	initial
		nlOiOl1 = {1{1'b1}};
	always @ ( posedge clk)
		  nlOiOl1 <= nlOiOl3;
	initial
		nlOiOl2 = {1{1'b1}};
	always @ ( posedge clk)
		  nlOiOl2 <= (nlOiOl3 ^ nlOiOl1);
	initial
		nlOiOl3 = 0;
	always @ ( posedge clk)
		  nlOiOl3 <= nlOiOl1;
	initial
	begin
		n100l = 0;
		n100O = 0;
		n10ii = 0;
		n10il = 0;
		n10O = 0;
		n11ii = 0;
		n11il = 0;
		n11iO = 0;
		n11l = 0;
		n11Oi = 0;
		n1lii = 0;
		n1liO = 0;
		n1lll = 0;
		n1O1i = 0;
		niO0i = 0;
		niO0l = 0;
		niO0O = 0;
		niO1l = 0;
		niO1O = 0;
		niOii = 0;
		niOil = 0;
		niOiO = 0;
		niOli = 0;
		niOll = 0;
		niOlO = 0;
		niOOi = 0;
		niOOl = 0;
		niOOO = 0;
		nl00i = 0;
		nl00l = 0;
		nl00O = 0;
		nl01i = 0;
		nl01l = 0;
		nl01O = 0;
		nl0ii = 0;
		nl0il = 0;
		nl0iO = 0;
		nl0li = 0;
		nl0ll = 0;
		nl0lO = 0;
		nl0Oi = 0;
		nl0Ol = 0;
		nl0OO = 0;
		nl10i = 0;
		nl10l = 0;
		nl10O = 0;
		nl11i = 0;
		nl11l = 0;
		nl11O = 0;
		nl1ii = 0;
		nl1il = 0;
		nl1iO = 0;
		nl1li = 0;
		nl1ll = 0;
		nl1lO = 0;
		nl1Oi = 0;
		nl1Ol = 0;
		nl1OO = 0;
		nli0i = 0;
		nli0l = 0;
		nli0O = 0;
		nli1i = 0;
		nli1l = 0;
		nli1O = 0;
		nliii = 0;
		nliil = 0;
		nliiO = 0;
		nlili = 0;
		nlill = 0;
		nlilO = 0;
		nliOi = 0;
		nliOl = 0;
		nliOO = 0;
		nll0i = 0;
		nll0l = 0;
		nll0O = 0;
		nll1i = 0;
		nll1l = 0;
		nll1O = 0;
		nlOliO = 0;
		nlOlli = 0;
		nlOlll = 0;
		nlOllO = 0;
	end
	always @ ( posedge clk or negedge reset_n)
	begin
		if (reset_n == 1'b0) 
		begin
			n100l <= 0;
			n100O <= 0;
			n10ii <= 0;
			n10il <= 0;
			n10O <= 0;
			n11ii <= 0;
			n11il <= 0;
			n11iO <= 0;
			n11l <= 0;
			n11Oi <= 0;
			n1lii <= 0;
			n1liO <= 0;
			n1lll <= 0;
			n1O1i <= 0;
			niO0i <= 0;
			niO0l <= 0;
			niO0O <= 0;
			niO1l <= 0;
			niO1O <= 0;
			niOii <= 0;
			niOil <= 0;
			niOiO <= 0;
			niOli <= 0;
			niOll <= 0;
			niOlO <= 0;
			niOOi <= 0;
			niOOl <= 0;
			niOOO <= 0;
			nl00i <= 0;
			nl00l <= 0;
			nl00O <= 0;
			nl01i <= 0;
			nl01l <= 0;
			nl01O <= 0;
			nl0ii <= 0;
			nl0il <= 0;
			nl0iO <= 0;
			nl0li <= 0;
			nl0ll <= 0;
			nl0lO <= 0;
			nl0Oi <= 0;
			nl0Ol <= 0;
			nl0OO <= 0;
			nl10i <= 0;
			nl10l <= 0;
			nl10O <= 0;
			nl11i <= 0;
			nl11l <= 0;
			nl11O <= 0;
			nl1ii <= 0;
			nl1il <= 0;
			nl1iO <= 0;
			nl1li <= 0;
			nl1ll <= 0;
			nl1lO <= 0;
			nl1Oi <= 0;
			nl1Ol <= 0;
			nl1OO <= 0;
			nli0i <= 0;
			nli0l <= 0;
			nli0O <= 0;
			nli1i <= 0;
			nli1l <= 0;
			nli1O <= 0;
			nliii <= 0;
			nliil <= 0;
			nliiO <= 0;
			nlili <= 0;
			nlill <= 0;
			nlilO <= 0;
			nliOi <= 0;
			nliOl <= 0;
			nliOO <= 0;
			nll0i <= 0;
			nll0l <= 0;
			nll0O <= 0;
			nll1i <= 0;
			nll1l <= 0;
			nll1O <= 0;
			nlOliO <= 0;
			nlOlli <= 0;
			nlOlll <= 0;
			nlOllO <= 0;
		end
		else 
		begin
			n100l <= rx_detect_valid_sync;
			n100O <= wire_n10iO_dataout;
			n10ii <= wire_n10li_dataout;
			n10il <= wire_n10ll_dataout;
			n10O <= wire_n11O_dataout;
			n11ii <= wire_nlOO1i_dataout;
			n11il <= rxd[11];
			n11iO <= rxd[9];
			n11l <= rxpolarity;
			n11Oi <= wire_n11li_dataout;
			n1lii <= wire_n10lO_dataout;
			n1liO <= wire_n1lil_dataout;
			n1lll <= wire_n1lli_dataout;
			n1O1i <= wire_n1llO_dataout;
			niO0i <= rxd[1];
			niO0l <= rxd[2];
			niO0O <= rxd[3];
			niO1l <= wire_n1ii_dataout;
			niO1O <= rxd[0];
			niOii <= rxd[4];
			niOil <= rxd[5];
			niOiO <= rxd[6];
			niOli <= rxd[7];
			niOll <= rxd[8];
			niOlO <= rxd[9];
			niOOi <= rxd[10];
			niOOl <= rxd[11];
			niOOO <= rxd[12];
			nl00i <= rxd[31];
			nl00l <= rxd[32];
			nl00O <= rxd[33];
			nl01i <= rxd[28];
			nl01l <= rxd[29];
			nl01O <= rxd[30];
			nl0ii <= rxd[34];
			nl0il <= rxd[35];
			nl0iO <= rxd[36];
			nl0li <= rxd[37];
			nl0ll <= rxd[38];
			nl0lO <= rxd[39];
			nl0Oi <= rxd[40];
			nl0Ol <= rxd[41];
			nl0OO <= rxd[42];
			nl10i <= rxd[16];
			nl10l <= rxd[17];
			nl10O <= rxd[18];
			nl11i <= rxd[13];
			nl11l <= rxd[14];
			nl11O <= rxd[15];
			nl1ii <= rxd[19];
			nl1il <= rxd[20];
			nl1iO <= rxd[21];
			nl1li <= rxd[22];
			nl1ll <= rxd[23];
			nl1lO <= rxd[24];
			nl1Oi <= rxd[25];
			nl1Ol <= rxd[26];
			nl1OO <= rxd[27];
			nli0i <= rxd[46];
			nli0l <= rxd[47];
			nli0O <= rxd[48];
			nli1i <= rxd[43];
			nli1l <= rxd[44];
			nli1O <= rxd[45];
			nliii <= rxd[49];
			nliil <= rxd[50];
			nliiO <= rxd[51];
			nlili <= rxd[52];
			nlill <= rxd[53];
			nlilO <= rxd[54];
			nliOi <= rxd[55];
			nliOl <= rxd[56];
			nliOO <= rxd[57];
			nll0i <= rxd[61];
			nll0l <= rxd[62];
			nll0O <= rxd[63];
			nll1i <= rxd[58];
			nll1l <= rxd[59];
			nll1O <= rxd[60];
			nlOliO <= rx_detect_valid_sync;
			nlOlli <= wire_nlOlOi_dataout;
			nlOlll <= wire_nlOlOl_dataout;
			nlOllO <= wire_nlOlOO_dataout;
		end
	end
	assign		wire_n00i_dataout = (rrx_pipe_enable === 1'b1) ? niOli : rxd[7];
	assign		wire_n00l_dataout = (rrx_pipe_enable === 1'b1) ? niOll : rxd[8];
	assign		wire_n00O_dataout = (rrx_pipe_enable === 1'b1) ? niOlO : rxd[9];
	assign		wire_n01i_dataout = (rrx_pipe_enable === 1'b1) ? niOii : rxd[4];
	assign		wire_n01l_dataout = (rrx_pipe_enable === 1'b1) ? niOil : rxd[5];
	assign		wire_n01O_dataout = (rrx_pipe_enable === 1'b1) ? niOiO : rxd[6];
	assign		wire_n0i_dataout = (rrx_pipe_enable === 1'b1) ? nlili : rxd[52];
	assign		wire_n0ii_dataout = (rrx_pipe_enable === 1'b1) ? niOOi : rxd[10];
	assign		wire_n0il_dataout = (rrx_pipe_enable === 1'b1) ? niOOl : rxd[11];
	assign		wire_n0iO_dataout = (rrx_pipe_enable === 1'b1) ? niOOO : rxd[12];
	assign		wire_n0l_dataout = (rrx_pipe_enable === 1'b1) ? nlill : rxd[53];
	assign		wire_n0li_dataout = (rrx_pipe_enable === 1'b1) ? nl11i : rxd[13];
	assign		wire_n0ll_dataout = (rrx_pipe_enable === 1'b1) ? nl11l : rxd[14];
	assign		wire_n0lO_dataout = (rrx_pipe_enable === 1'b1) ? nl11O : rxd[15];
	assign		wire_n0O_dataout = (rrx_pipe_enable === 1'b1) ? nlilO : rxd[54];
	assign		wire_n0Oi_dataout = (rrx_pipe_enable === 1'b1) ? nl10i : rxd[16];
	assign		wire_n0Ol_dataout = (rrx_pipe_enable === 1'b1) ? nl10l : rxd[17];
	assign		wire_n0OO_dataout = (rrx_pipe_enable === 1'b1) ? nl10O : rxd[18];
	and(wire_n10iO_dataout, wire_n10Oi_dataout, ~{(~ rrdwidth_rx)});
	and(wire_n10li_dataout, wire_n10Ol_dataout, ~{(~ rrdwidth_rx)});
	and(wire_n10ll_dataout, wire_n10OO_dataout, ~{(~ rrdwidth_rx)});
	and(wire_n10lO_dataout, wire_n1i1i_dataout, ~{(~ rrdwidth_rx)});
	and(wire_n10Oi_dataout, wire_n1i1l_dataout, ~{nlO1li});
	and(wire_n10Ol_dataout, nlO1ll, ~{nlO1li});
	and(wire_n10OO_dataout, wire_n1i1O_dataout, ~{nlO1li});
	and(wire_n11li_dataout, ((~ nlOliO) & (rx_found & rx_detect_valid_sync)), latched_p1);
	and(wire_n11O_dataout, rxelectricalidle, ~{(rxbeacon & latched_p2)});
	assign		wire_n1i_dataout = (rrx_pipe_enable === 1'b1) ? nliii : rxd[49];
	and(wire_n1i0i_dataout, wire_n1iii_dataout, ~{nlO1ll});
	and(wire_n1i0l_dataout, wire_n1iil_dataout, ~{nlO0ii});
	or(wire_n1i0O_dataout, wire_n1iiO_dataout, nlO0ii);
	and(wire_n1i1i_dataout, wire_n1i0i_dataout, ~{nlO1li});
	and(wire_n1i1l_dataout, wire_n1i0l_dataout, ~{nlO1ll});
	and(wire_n1i1O_dataout, wire_n1i0O_dataout, ~{nlO1ll});
	assign		wire_n1ii_dataout = (rrdwidth_rx === 1'b1) ? ((rxd[10] & rxd[42]) & nlOiOl2) : rxd[10];
	and(wire_n1iii_dataout, wire_n1ili_dataout, ~{nlO0ii});
	or(wire_n1iil_dataout, wire_n1ill_dataout, nlO00O);
	and(wire_n1iiO_dataout, nlO01l, ~{nlO00O});
	and(wire_n1ili_dataout, wire_n1ilO_dataout, ~{nlO00O});
	and(wire_n1ill_dataout, nlO1Ol, ~{nlO01l});
	and(wire_n1ilO_dataout, wire_n1iOi_dataout, ~{nlO01l});
	assign		wire_n1iO_dataout = (rrx_pipe_enable === 1'b1) ? n10O : rxelectricalidle;
	and(wire_n1iOi_dataout, ((rxd[45] & rxd[46]) & nlO1lO29), ~{nlO1Ol});
	assign		wire_n1l_dataout = (rrx_pipe_enable === 1'b1) ? nliil : rxd[50];
	and(wire_n1li_dataout, niO1l, rrx_pipe_enable);
	and(wire_n1lil_dataout, rxd[43], rrdwidth_rx);
	assign		wire_n1ll_dataout = (rrx_pipe_enable === 1'b1) ? n11l : polinv_rx;
	and(wire_n1lli_dataout, rxd[41], rrdwidth_rx);
	and(wire_n1llO_dataout, wire_n1lOi_dataout, rrdwidth_rx);
	assign		wire_n1lO_dataout = (rrx_pipe_enable === 1'b1) ? niO1O : rxd[0];
	and(wire_n1lOi_dataout, ((~ n100l) & ((rx_found & rx_detect_valid_sync) & nlO0lO17)), latched_p1);
	assign		wire_n1O_dataout = (rrx_pipe_enable === 1'b1) ? nliiO : rxd[51];
	assign		wire_n1Oi_dataout = (rrx_pipe_enable === 1'b1) ? niO0i : rxd[1];
	assign		wire_n1Ol_dataout = (rrx_pipe_enable === 1'b1) ? niO0l : rxd[2];
	assign		wire_n1OO_dataout = (rrx_pipe_enable === 1'b1) ? niO0O : rxd[3];
	assign		wire_ni_dataout = (rrx_pipe_enable === 1'b1) ? nll0i : rxd[61];
	assign		wire_ni0i_dataout = (rrx_pipe_enable === 1'b1) ? nl1li : rxd[22];
	assign		wire_ni0l_dataout = (rrx_pipe_enable === 1'b1) ? nl1ll : rxd[23];
	assign		wire_ni0O_dataout = (rrx_pipe_enable === 1'b1) ? nl1lO : rxd[24];
	assign		wire_ni1i_dataout = (rrx_pipe_enable === 1'b1) ? nl1ii : rxd[19];
	assign		wire_ni1l_dataout = (rrx_pipe_enable === 1'b1) ? nl1il : rxd[20];
	assign		wire_ni1O_dataout = (rrx_pipe_enable === 1'b1) ? nl1iO : rxd[21];
	assign		wire_nii_dataout = (rrx_pipe_enable === 1'b1) ? nliOi : rxd[55];
	assign		wire_niii_dataout = (rrx_pipe_enable === 1'b1) ? nl1Oi : rxd[25];
	assign		wire_niil_dataout = (rrx_pipe_enable === 1'b1) ? nl1Ol : rxd[26];
	assign		wire_niiO_dataout = (rrx_pipe_enable === 1'b1) ? nl1OO : rxd[27];
	assign		wire_nil_dataout = (rrx_pipe_enable === 1'b1) ? nliOl : rxd[56];
	assign		wire_nili_dataout = (rrx_pipe_enable === 1'b1) ? nl01i : rxd[28];
	assign		wire_nill_dataout = (rrx_pipe_enable === 1'b1) ? nl01l : rxd[29];
	assign		wire_nilO_dataout = (rrx_pipe_enable === 1'b1) ? nl01O : rxd[30];
	assign		wire_niO_dataout = (rrx_pipe_enable === 1'b1) ? nliOO : rxd[57];
	assign		wire_niOi_dataout = (rrx_pipe_enable === 1'b1) ? nl00i : rxd[31];
	assign		wire_niOl_dataout = (rrx_pipe_enable === 1'b1) ? nl00l : rxd[32];
	assign		wire_niOO_dataout = (rrx_pipe_enable === 1'b1) ? nl00O : rxd[33];
	assign		wire_nl_dataout = (rrx_pipe_enable === 1'b1) ? nll0l : rxd[62];
	assign		wire_nl0i_dataout = (rrx_pipe_enable === 1'b1) ? nl0li : rxd[37];
	assign		wire_nl0l_dataout = (rrx_pipe_enable === 1'b1) ? nl0ll : rxd[38];
	assign		wire_nl0O_dataout = (rrx_pipe_enable === 1'b1) ? nl0lO : rxd[39];
	assign		wire_nl1i_dataout = (rrx_pipe_enable === 1'b1) ? nl0ii : rxd[34];
	assign		wire_nl1l_dataout = (rrx_pipe_enable === 1'b1) ? nl0il : rxd[35];
	assign		wire_nl1O_dataout = (rrx_pipe_enable === 1'b1) ? nl0iO : rxd[36];
	assign		wire_nli_dataout = (rrx_pipe_enable === 1'b1) ? nll1i : rxd[58];
	assign		wire_nlii_dataout = (rrx_pipe_enable === 1'b1) ? nl0Oi : rxd[40];
	assign		wire_nlil_dataout = (rrx_pipe_enable === 1'b1) ? nl0Ol : rxd[41];
	assign		wire_nliO_dataout = (rrx_pipe_enable === 1'b1) ? nl0OO : rxd[42];
	assign		wire_nll_dataout = (rrx_pipe_enable === 1'b1) ? nll1l : rxd[59];
	assign		wire_nlli_dataout = (rrx_pipe_enable === 1'b1) ? nli1i : rxd[43];
	assign		wire_nllii_dataout = ((~ rrx_pipe_enable) === 1'b1) ? rx_found : wire_nllli_dataout;
	assign		wire_nllil_dataout = ((~ rrx_pipe_enable) === 1'b1) ? rx_detect_valid : wire_nllll_dataout;
	assign		wire_nlliO_dataout = ((~ rrx_pipe_enable) === 1'b1) ? rxbeacon : wire_nlllO_dataout;
	assign		wire_nlll_dataout = (rrx_pipe_enable === 1'b1) ? nli1l : rxd[44];
	or(wire_nllli_dataout, wire_nllOi_dataout, nlOili);
	or(wire_nllll_dataout, wire_nllOl_dataout, nlOili);
	and(wire_nlllO_dataout, wire_nllOO_dataout, ~{nlOili});
	assign		wire_nllO_dataout = (rrx_pipe_enable === 1'b1) ? nli1O : rxd[45];
	and(wire_nllOi_dataout, wire_nlO1i_dataout, ~{nlOiiO});
	and(wire_nllOl_dataout, wire_nlO1l_dataout, ~{nlOiiO});
	or(wire_nllOO_dataout, wire_nlO1O_dataout, nlOiiO);
	assign		wire_nlO_dataout = (rrx_pipe_enable === 1'b1) ? nll1O : rxd[60];
	and(wire_nlO0i_dataout, wire_nlOii_dataout, ~{nlOi0l});
	or(wire_nlO0l_dataout, wire_nlOil_dataout, nlOi0l);
	or(wire_nlO0O_dataout, nlOi0i, nlOi0l);
	or(wire_nlO1i_dataout, wire_nlO0i_dataout, nlOi0O);
	and(wire_nlO1l_dataout, wire_nlO0l_dataout, ~{nlOi0O});
	or(wire_nlO1O_dataout, wire_nlO0O_dataout, nlOi0O);
	assign		wire_nlOi_dataout = (rrx_pipe_enable === 1'b1) ? nli0i : rxd[46];
	or(wire_nlOii_dataout, wire_nlOiO_dataout, nlOi0i);
	or(wire_nlOil_dataout, nlOi1i, nlOi0i);
	and(wire_nlOiO_dataout, ((n100O | nlOlli) | (~ nlO0Ol14)), ~{nlOi1i});
	assign		wire_nlOl_dataout = (rrx_pipe_enable === 1'b1) ? nli0l : rxd[47];
	and(wire_nlOlOi_dataout, wire_nlOO1l_dataout, ~{nlllOO});
	and(wire_nlOlOl_dataout, nllO1i, ~{nlllOO});
	and(wire_nlOlOO_dataout, wire_nlOO1O_dataout, ~{nlllOO});
	assign		wire_nlOO_dataout = (rrx_pipe_enable === 1'b1) ? nli0O : rxd[48];
	and(wire_nlOO0i_dataout, wire_nlOOii_dataout, ~{nllO1i});
	and(wire_nlOO0l_dataout, wire_nlOOil_dataout, ~{nlO11i});
	or(wire_nlOO0O_dataout, wire_nlOOiO_dataout, nlO11i);
	and(wire_nlOO1i_dataout, wire_nlOO0i_dataout, ~{nlllOO});
	and(wire_nlOO1l_dataout, wire_nlOO0l_dataout, ~{nllO1i});
	and(wire_nlOO1O_dataout, wire_nlOO0O_dataout, ~{nllO1i});
	and(wire_nlOOii_dataout, wire_nlOOli_dataout, ~{nlO11i});
	or(wire_nlOOil_dataout, wire_nlOOll_dataout, nllOll);
	and(wire_nlOOiO_dataout, nllOii, ~{nllOll});
	and(wire_nlOOli_dataout, wire_nlOOlO_dataout, ~{nllOll});
	and(wire_nlOOll_dataout, nllO0i, ~{nllOii});
	and(wire_nlOOlO_dataout, wire_nlOOOi_dataout, ~{nllOii});
	and(wire_nlOOOi_dataout, ((rxd[13] & rxd[14]) & nllO1l53), ~{nllO0i});
	assign		wire_nO_dataout = (rrx_pipe_enable === 1'b1) ? nll0O : rxd[63];
	assign
		nlllOO = ((~ rxd[13]) & (~ rxd[14])),
		nllO0i = (rclkcmpinsertpad & ((nlO10l & (~ nllOli)) & nllO0l50)),
		nllO1i = (rxd[13] & (~ rxd[14])),
		nllOii = (rclkcmpinsertpad & ((nlO10l & nllOli) & nllOil47)),
		nllOli = (((((((rxd[0] & rxd[1]) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		nllOll = (((~ rclkcmpinsertpad) & ((nlO10l & (~ nlO10i)) & nllOOl41)) & nllOlO44),
		nlO00l = ((((((((rxd[32] & rxd[33]) & rxd[34]) & (~ rxd[35])) & rxd[36]) & rxd[37]) & rxd[38]) & rxd[39]) & nlO10O35),
		nlO00O = ((~ rclkcmpinsertpad) & (nlO0ll & (~ nlO0li))),
		nlO01l = (rclkcmpinsertpad & ((nlO0ll & nlO00l) & nlO01O23)),
		nlO0ii = ((~ rclkcmpinsertpad) & ((nlO0ll & nlO0li) & nlO0il20)),
		nlO0li = ((((((((~ rxd[32]) & rxd[33]) & rxd[34]) & rxd[35]) & rxd[36]) & rxd[37]) & rxd[38]) & rxd[39]),
		nlO0ll = (((~ rxd[45]) & rxd[46]) & nlO1il32),
		nlO10i = (((((((((~ rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & nlllOi56),
		nlO10l = ((~ rxd[13]) & rxd[14]),
		nlO11i = ((~ rclkcmpinsertpad) & ((nlO10l & nlO10i) & nlO11l38)),
		nlO1li = ((~ rxd[45]) & (~ rxd[46])),
		nlO1ll = (rxd[45] & (~ rxd[46])),
		nlO1Ol = (((nlO0ll & (~ nlO00l)) & rclkcmpinsertpad) & nlO1OO26),
		nlOi0i = (n1liO | n11il),
		nlOi0l = (n10il | nlOllO),
		nlOi0O = ((n1lii | n11ii) | (~ nlOiii8)),
		nlOi1i = ((n10ii | nlOlll) | (~ nlOi1l11)),
		nlOiiO = (n1lll | n11iO),
		nlOili = ((n1O1i | n11Oi) | (~ nlOill5)),
		nlOiOi = 1'b1,
		polinv_rx_int = wire_n1ll_dataout,
		rxd_ch = {wire_nO_dataout, wire_nl_dataout, wire_ni_dataout, wire_nlO_dataout, wire_nll_dataout, wire_nli_dataout, wire_niO_dataout, wire_nil_dataout, wire_nii_dataout, wire_n0O_dataout, wire_n0l_dataout, wire_n0i_dataout, wire_n1O_dataout, wire_n1l_dataout, wire_n1i_dataout, wire_nlOO_dataout, wire_nlOl_dataout, wire_nlOi_dataout, wire_nllO_dataout, wire_nlll_dataout, wire_nlli_dataout, wire_nliO_dataout, wire_nlil_dataout, wire_nlii_dataout, wire_nl0O_dataout, wire_nl0l_dataout, wire_nl0i_dataout, wire_nl1O_dataout, wire_nl1l_dataout, wire_nl1i_dataout, wire_niOO_dataout, wire_niOl_dataout, wire_niOi_dataout, wire_nilO_dataout, wire_nill_dataout, wire_nili_dataout, wire_niiO_dataout, wire_niil_dataout, wire_niii_dataout, wire_ni0O_dataout, wire_ni0l_dataout, wire_ni0i_dataout, wire_ni1O_dataout, wire_ni1l_dataout, wire_ni1i_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout, wire_n0lO_dataout, wire_n0ll_dataout, wire_n0li_dataout, wire_n0iO_dataout, wire_n0il_dataout, wire_n0ii_dataout, wire_n00O_dataout, wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout, wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout},
		rxelecidle = wire_n1iO_dataout,
		rxstatus = {wire_nlliO_dataout, wire_nllil_dataout, wire_nllii_dataout},
		rxvalid = wire_n1li_dataout;
endmodule //stratixiigx_hssi_rx_pipe_interface
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 88 mux21 56 oper_decoder 1 oper_selector 1 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_tx_pipe_interface
	( 
	clk,
	powerdown,
	powerstate,
	refclk_b,
	refclk_b_reset_n,
	reset_n,
	rev_loopbk,
	revloopback,
	rtx_elec_idle_delay,
	rtx_pipe_enable,
	tx_elec_idle,
	tx_elec_idle_comp,
	txbeacon,
	txcompliance,
	txd,
	txd_ch,
	txdetectrx,
	txdetectrxloopback,
	txelecidle) /* synthesis synthesis_clearbox=1 */;
	input   clk;
	input   [1:0]  powerdown;
	output   [3:0]  powerstate;
	input   refclk_b;
	input   refclk_b_reset_n;
	input   reset_n;
	output   rev_loopbk;
	input   revloopback;
	input   [1:0]  rtx_elec_idle_delay;
	input   rtx_pipe_enable;
	output   tx_elec_idle;
	input   tx_elec_idle_comp;
	output   txbeacon;
	input   txcompliance;
	output   [43:0]  txd;
	input   [43:0]  txd_ch;
	output   txdetectrx;
	input   txdetectrxloopback;
	input   txelecidle;

	reg	n0i0l22;
	reg	n0i0l23;
	reg	n0i0l24;
	reg	n0i1i28;
	reg	n0i1i29;
	reg	n0i1i30;
	reg	n0i1O25;
	reg	n0i1O26;
	reg	n0i1O27;
	reg	n0iii19;
	reg	n0iii20;
	reg	n0iii21;
	reg	n0ill16;
	reg	n0ill17;
	reg	n0ill18;
	reg	n0ilO13;
	reg	n0ilO14;
	reg	n0ilO15;
	reg	n0iOi10;
	reg	n0iOi11;
	reg	n0iOi12;
	reg	n0iOO7;
	reg	n0iOO8;
	reg	n0iOO9;
	reg	n0l0i1;
	reg	n0l0i2;
	reg	n0l0i3;
	reg	n0l1l4;
	reg	n0l1l5;
	reg	n0l1l6;
	reg	n0Oii;
	reg	n0Oil;
	reg	n0OiO;
	reg	n0Oli;
	reg	n0OlO;
	reg	n0OOl;
	wire	wire_n0OOi_ENA;
	reg	ni0il;
	reg	ni10l;
	reg	ni11O;
	reg	n0lOi;
	reg	n0lOl;
	reg	n0lOO;
	reg	n0O1i;
	reg	ni01l;
	reg	ni0iO;
	reg	ni0Ol;
	reg	ni0OO;
	reg	ni1iO;
	reg	nii0i;
	reg	nii0l;
	reg	nii0O;
	reg	nii1i;
	reg	nii1l;
	reg	nii1O;
	reg	niiii;
	reg	niiil;
	reg	niiiO;
	reg	niili;
	reg	niill;
	reg	niilO;
	reg	niiOi;
	reg	niiOl;
	reg	niiOO;
	reg	nil0i;
	reg	nil0l;
	reg	nil0O;
	reg	nil1i;
	reg	nil1l;
	reg	nil1O;
	reg	nilii;
	reg	nilil;
	reg	niliO;
	reg	nilli;
	reg	nilll;
	reg	nillO;
	reg	nilOi;
	reg	nilOl;
	reg	nilOO;
	reg	niO0i;
	reg	niO0l;
	reg	niO0O;
	reg	niO1i;
	reg	niO1l;
	reg	niO1O;
	reg	niOii;
	reg	niOil;
	reg	niOiO;
	reg	niOll;
	wire	wire_n0O0O_dataout;
	wire	wire_n0OOO_dataout;
	wire	wire_ni00i_dataout;
	wire	wire_ni00l_dataout;
	wire	wire_ni00O_dataout;
	wire	wire_ni01O_dataout;
	wire	wire_ni0li_dataout;
	wire	wire_ni0ll_dataout;
	wire	wire_ni1li_dataout;
	wire	wire_ni1lO_dataout;
	wire	wire_ni1Ol_dataout;
	wire	wire_ni1OO_dataout;
	wire	wire_niOlO_dataout;
	wire	wire_niOOi_dataout;
	wire	wire_niOOl_dataout;
	wire	wire_niOOO_dataout;
	wire	wire_nl00i_dataout;
	wire	wire_nl00l_dataout;
	wire	wire_nl00O_dataout;
	wire	wire_nl01i_dataout;
	wire	wire_nl01l_dataout;
	wire	wire_nl01O_dataout;
	wire	wire_nl0ii_dataout;
	wire	wire_nl0il_dataout;
	wire	wire_nl0iO_dataout;
	wire	wire_nl0li_dataout;
	wire	wire_nl0ll_dataout;
	wire	wire_nl0lO_dataout;
	wire	wire_nl0Oi_dataout;
	wire	wire_nl0Ol_dataout;
	wire	wire_nl0OO_dataout;
	wire	wire_nl10i_dataout;
	wire	wire_nl10l_dataout;
	wire	wire_nl10O_dataout;
	wire	wire_nl11i_dataout;
	wire	wire_nl11l_dataout;
	wire	wire_nl11O_dataout;
	wire	wire_nl1ii_dataout;
	wire	wire_nl1il_dataout;
	wire	wire_nl1iO_dataout;
	wire	wire_nl1li_dataout;
	wire	wire_nl1ll_dataout;
	wire	wire_nl1lO_dataout;
	wire	wire_nl1Oi_dataout;
	wire	wire_nl1Ol_dataout;
	wire	wire_nl1OO_dataout;
	wire	wire_nli0i_dataout;
	wire	wire_nli0l_dataout;
	wire	wire_nli0O_dataout;
	wire	wire_nli1i_dataout;
	wire	wire_nli1l_dataout;
	wire	wire_nli1O_dataout;
	wire	wire_nliii_dataout;
	wire	wire_nliil_dataout;
	wire	wire_nliiO_dataout;
	wire	wire_nlili_dataout;
	wire  [3:0]   wire_ni11l_o;
	wire  wire_ni11i_o;
	wire  n0iiO;
	wire  n0ili;
	wire  n0iOl;
	wire  n0l0O;

	initial
		n0i0l22 = {1{1'b1}};
	always @ ( posedge clk)
		  n0i0l22 <= n0i0l24;
	initial
		n0i0l23 = {1{1'b1}};
	always @ ( posedge clk)
		  n0i0l23 <= (n0i0l24 ^ n0i0l22);
	initial
		n0i0l24 = 0;
	always @ ( posedge clk)
		  n0i0l24 <= n0i0l22;
	initial
		n0i1i28 = {1{1'b1}};
	always @ ( posedge clk)
		  n0i1i28 <= n0i1i30;
	initial
		n0i1i29 = {1{1'b1}};
	always @ ( posedge clk)
		  n0i1i29 <= (n0i1i30 ^ n0i1i28);
	initial
		n0i1i30 = 0;
	always @ ( posedge clk)
		  n0i1i30 <= n0i1i28;
	initial
		n0i1O25 = {1{1'b1}};
	always @ ( posedge clk)
		  n0i1O25 <= n0i1O27;
	initial
		n0i1O26 = {1{1'b1}};
	always @ ( posedge clk)
		  n0i1O26 <= (n0i1O27 ^ n0i1O25);
	initial
		n0i1O27 = 0;
	always @ ( posedge clk)
		  n0i1O27 <= n0i1O25;
	initial
		n0iii19 = {1{1'b1}};
	always @ ( posedge clk)
		  n0iii19 <= n0iii21;
	initial
		n0iii20 = {1{1'b1}};
	always @ ( posedge clk)
		  n0iii20 <= (n0iii21 ^ n0iii19);
	initial
		n0iii21 = 0;
	always @ ( posedge clk)
		  n0iii21 <= n0iii19;
	initial
		n0ill16 = {1{1'b1}};
	always @ ( posedge clk)
		  n0ill16 <= n0ill18;
	initial
		n0ill17 = {1{1'b1}};
	always @ ( posedge clk)
		  n0ill17 <= (n0ill18 ^ n0ill16);
	initial
		n0ill18 = 0;
	always @ ( posedge clk)
		  n0ill18 <= n0ill16;
	initial
		n0ilO13 = {1{1'b1}};
	always @ ( posedge clk)
		  n0ilO13 <= n0ilO15;
	initial
		n0ilO14 = {1{1'b1}};
	always @ ( posedge clk)
		  n0ilO14 <= (n0ilO15 ^ n0ilO13);
	initial
		n0ilO15 = 0;
	always @ ( posedge clk)
		  n0ilO15 <= n0ilO13;
	initial
		n0iOi10 = {1{1'b1}};
	always @ ( posedge clk)
		  n0iOi10 <= n0iOi12;
	initial
		n0iOi11 = {1{1'b1}};
	always @ ( posedge clk)
		  n0iOi11 <= (n0iOi12 ^ n0iOi10);
	initial
		n0iOi12 = 0;
	always @ ( posedge clk)
		  n0iOi12 <= n0iOi10;
	initial
		n0iOO7 = {1{1'b1}};
	always @ ( posedge clk)
		  n0iOO7 <= n0iOO9;
	initial
		n0iOO8 = {1{1'b1}};
	always @ ( posedge clk)
		  n0iOO8 <= (n0iOO9 ^ n0iOO7);
	initial
		n0iOO9 = 0;
	always @ ( posedge clk)
		  n0iOO9 <= n0iOO7;
	initial
		n0l0i1 = {1{1'b1}};
	always @ ( posedge clk)
		  n0l0i1 <= n0l0i3;
	initial
		n0l0i2 = {1{1'b1}};
	always @ ( posedge clk)
		  n0l0i2 <= (n0l0i3 ^ n0l0i1);
	initial
		n0l0i3 = 0;
	always @ ( posedge clk)
		  n0l0i3 <= n0l0i1;
	initial
		n0l1l4 = {1{1'b1}};
	always @ ( posedge clk)
		  n0l1l4 <= n0l1l6;
	initial
		n0l1l5 = {1{1'b1}};
	always @ ( posedge clk)
		  n0l1l5 <= (n0l1l6 ^ n0l1l4);
	initial
		n0l1l6 = 0;
	always @ ( posedge clk)
		  n0l1l6 <= n0l1l4;
	initial
	begin
		n0Oii = 0;
		n0Oil = 0;
		n0OiO = 0;
		n0Oli = 0;
		n0OlO = 0;
	end
	always @ ( posedge refclk_b or negedge refclk_b_reset_n)
	begin
		if (refclk_b_reset_n == 1'b0) 
		begin
			n0Oii <= 1;
			n0Oil <= 1;
			n0OiO <= 1;
			n0Oli <= 1;
			n0OlO <= 1;
		end
		else 
		begin
			n0Oii <= n0Oil;
			n0Oil <= n0OiO;
			n0OiO <= n0Oli;
			n0Oli <= n0OlO;
			n0OlO <= n0iOl;
		end
	end
	initial
	begin
		n0OOl = 0;
	end
	always @ ( posedge refclk_b or negedge refclk_b_reset_n)
	begin
		if (refclk_b_reset_n == 1'b0) 
		begin
			n0OOl <= 1;
		end
		else if  (wire_n0OOi_ENA == 1'b1) 
		begin
			n0OOl <= n0ili;
		end
	end
	assign
		wire_n0OOi_ENA = ((~ ni11O) & (n0OOl & ni10l));
	initial
	begin
		ni0il = 0;
	end
	always @ ( posedge clk or negedge reset_n)
	begin
		if (reset_n == 1'b0) 
		begin
			ni0il <= 1;
		end
		else 
		begin
			ni0il <= txelecidle;
		end
	end
	initial
	begin
		ni10l = 0;
		ni11O = 0;
	end
	always @ ( posedge refclk_b or negedge refclk_b_reset_n)
	begin
		if (refclk_b_reset_n == 1'b0) 
		begin
			ni10l <= 0;
			ni11O <= 0;
		end
		else 
		begin
			ni10l <= tx_elec_idle_comp;
			ni11O <= ni10l;
		end
	end
	initial
	begin
		n0lOi = 0;
		n0lOl = 0;
		n0lOO = 0;
		n0O1i = 0;
		ni01l = 0;
		ni0iO = 0;
		ni0Ol = 0;
		ni0OO = 0;
		ni1iO = 0;
		nii0i = 0;
		nii0l = 0;
		nii0O = 0;
		nii1i = 0;
		nii1l = 0;
		nii1O = 0;
		niiii = 0;
		niiil = 0;
		niiiO = 0;
		niili = 0;
		niill = 0;
		niilO = 0;
		niiOi = 0;
		niiOl = 0;
		niiOO = 0;
		nil0i = 0;
		nil0l = 0;
		nil0O = 0;
		nil1i = 0;
		nil1l = 0;
		nil1O = 0;
		nilii = 0;
		nilil = 0;
		niliO = 0;
		nilli = 0;
		nilll = 0;
		nillO = 0;
		nilOi = 0;
		nilOl = 0;
		nilOO = 0;
		niO0i = 0;
		niO0l = 0;
		niO0O = 0;
		niO1i = 0;
		niO1l = 0;
		niO1O = 0;
		niOii = 0;
		niOil = 0;
		niOiO = 0;
		niOll = 0;
	end
	always @ ( posedge clk or negedge reset_n)
	begin
		if (reset_n == 1'b0) 
		begin
			n0lOi <= 0;
			n0lOl <= 0;
			n0lOO <= 0;
			n0O1i <= 0;
			ni01l <= 0;
			ni0iO <= 0;
			ni0Ol <= 0;
			ni0OO <= 0;
			ni1iO <= 0;
			nii0i <= 0;
			nii0l <= 0;
			nii0O <= 0;
			nii1i <= 0;
			nii1l <= 0;
			nii1O <= 0;
			niiii <= 0;
			niiil <= 0;
			niiiO <= 0;
			niili <= 0;
			niill <= 0;
			niilO <= 0;
			niiOi <= 0;
			niiOl <= 0;
			niiOO <= 0;
			nil0i <= 0;
			nil0l <= 0;
			nil0O <= 0;
			nil1i <= 0;
			nil1l <= 0;
			nil1O <= 0;
			nilii <= 0;
			nilil <= 0;
			niliO <= 0;
			nilli <= 0;
			nilll <= 0;
			nillO <= 0;
			nilOi <= 0;
			nilOl <= 0;
			nilOO <= 0;
			niO0i <= 0;
			niO0l <= 0;
			niO0O <= 0;
			niO1i <= 0;
			niO1l <= 0;
			niO1O <= 0;
			niOii <= 0;
			niOil <= 0;
			niOiO <= 0;
			niOll <= 0;
		end
		else 
		begin
			n0lOi <= ((rtx_pipe_enable & n0iiO) & n0i1i29);
			n0lOl <= ((rtx_pipe_enable & (powerdown[0] & powerdown[1])) & n0i1O26);
			n0lOO <= (rtx_pipe_enable & ((~ powerdown[0]) & powerdown[1]));
			n0O1i <= ((rtx_pipe_enable & ((powerdown[0] & (~ powerdown[1])) & n0iii20)) & n0i0l23);
			ni01l <= txelecidle;
			ni0iO <= txd_ch[43];
			ni0Ol <= wire_n0O0O_dataout;
			ni0OO <= txcompliance;
			ni1iO <= txdetectrxloopback;
			nii0i <= txd_ch[3];
			nii0l <= txd_ch[4];
			nii0O <= txd_ch[5];
			nii1i <= txd_ch[0];
			nii1l <= txd_ch[1];
			nii1O <= txd_ch[2];
			niiii <= txd_ch[6];
			niiil <= txd_ch[7];
			niiiO <= txd_ch[8];
			niili <= txd_ch[9];
			niill <= txd_ch[11];
			niilO <= txd_ch[12];
			niiOi <= txd_ch[13];
			niiOl <= txd_ch[14];
			niiOO <= txd_ch[15];
			nil0i <= txd_ch[19];
			nil0l <= txd_ch[20];
			nil0O <= txd_ch[21];
			nil1i <= txd_ch[16];
			nil1l <= txd_ch[17];
			nil1O <= txd_ch[18];
			nilii <= txd_ch[22];
			nilil <= txd_ch[23];
			niliO <= txd_ch[24];
			nilli <= txd_ch[25];
			nilll <= txd_ch[26];
			nillO <= txd_ch[27];
			nilOi <= txd_ch[28];
			nilOl <= txd_ch[29];
			nilOO <= txd_ch[30];
			niO0i <= txd_ch[36];
			niO0l <= txd_ch[37];
			niO0O <= txd_ch[38];
			niO1i <= txd_ch[33];
			niO1l <= txd_ch[34];
			niO1O <= txd_ch[35];
			niOii <= txd_ch[39];
			niOil <= txd_ch[40];
			niOiO <= txd_ch[41];
			niOll <= txd_ch[42];
		end
	end
	and(wire_n0O0O_dataout, rtx_pipe_enable, n0iiO);
	assign		wire_n0OOO_dataout = ((~ n0iOl) === 1'b1) ? n0OlO : wire_ni11i_o;
	and(wire_ni00i_dataout, n0O1i, rtx_pipe_enable);
	and(wire_ni00l_dataout, n0lOO, rtx_pipe_enable);
	and(wire_ni00O_dataout, n0lOl, rtx_pipe_enable);
	and(wire_ni01O_dataout, n0lOi, rtx_pipe_enable);
	or(wire_ni0li_dataout, wire_ni0ll_dataout, (ni0OO & ni0Ol));
	and(wire_ni0ll_dataout, niili, ~{(((~ ni0OO) & ni0Ol) & n0l0i2)});
	and(wire_ni1li_dataout, (((~ ni01l) & n0lOl) & n0iOO8), ~{(~ rtx_pipe_enable)});
	assign		wire_ni1lO_dataout = ((~ rtx_pipe_enable) === 1'b1) ? txdetectrxloopback : (ni1iO & n0lOO);
	assign		wire_ni1Ol_dataout = ((~ rtx_pipe_enable) === 1'b1) ? txelecidle : wire_n0OOO_dataout;
	assign		wire_ni1OO_dataout = ((~ rtx_pipe_enable) === 1'b1) ? revloopback : ((ni1iO & n0lOi) & n0l1l5);
	assign		wire_niOlO_dataout = (rtx_pipe_enable === 1'b1) ? nii1i : txd_ch[0];
	assign		wire_niOOi_dataout = (rtx_pipe_enable === 1'b1) ? nii1l : txd_ch[1];
	assign		wire_niOOl_dataout = (rtx_pipe_enable === 1'b1) ? nii1O : txd_ch[2];
	assign		wire_niOOO_dataout = (rtx_pipe_enable === 1'b1) ? nii0i : txd_ch[3];
	assign		wire_nl00i_dataout = (rtx_pipe_enable === 1'b1) ? nilii : txd_ch[22];
	assign		wire_nl00l_dataout = (rtx_pipe_enable === 1'b1) ? nilil : txd_ch[23];
	assign		wire_nl00O_dataout = (rtx_pipe_enable === 1'b1) ? niliO : txd_ch[24];
	assign		wire_nl01i_dataout = (rtx_pipe_enable === 1'b1) ? nil0i : txd_ch[19];
	assign		wire_nl01l_dataout = (rtx_pipe_enable === 1'b1) ? nil0l : txd_ch[20];
	assign		wire_nl01O_dataout = (rtx_pipe_enable === 1'b1) ? nil0O : txd_ch[21];
	assign		wire_nl0ii_dataout = (rtx_pipe_enable === 1'b1) ? nilli : txd_ch[25];
	assign		wire_nl0il_dataout = (rtx_pipe_enable === 1'b1) ? nilll : txd_ch[26];
	assign		wire_nl0iO_dataout = (rtx_pipe_enable === 1'b1) ? nillO : txd_ch[27];
	assign		wire_nl0li_dataout = (rtx_pipe_enable === 1'b1) ? nilOi : txd_ch[28];
	assign		wire_nl0ll_dataout = (rtx_pipe_enable === 1'b1) ? nilOl : txd_ch[29];
	assign		wire_nl0lO_dataout = (rtx_pipe_enable === 1'b1) ? nilOO : txd_ch[30];
	and(wire_nl0Oi_dataout, txd_ch[31], ~{rtx_pipe_enable});
	assign		wire_nl0Ol_dataout = (rtx_pipe_enable === 1'b1) ? ni0il : txd_ch[32];
	assign		wire_nl0OO_dataout = (rtx_pipe_enable === 1'b1) ? niO1i : txd_ch[33];
	assign		wire_nl10i_dataout = (rtx_pipe_enable === 1'b1) ? niiil : txd_ch[7];
	assign		wire_nl10l_dataout = (rtx_pipe_enable === 1'b1) ? niiiO : txd_ch[8];
	assign		wire_nl10O_dataout = (rtx_pipe_enable === 1'b1) ? wire_ni0li_dataout : txd_ch[9];
	assign		wire_nl11i_dataout = (rtx_pipe_enable === 1'b1) ? nii0l : txd_ch[4];
	assign		wire_nl11l_dataout = (rtx_pipe_enable === 1'b1) ? nii0O : txd_ch[5];
	assign		wire_nl11O_dataout = (rtx_pipe_enable === 1'b1) ? niiii : txd_ch[6];
	assign		wire_nl1ii_dataout = (rtx_pipe_enable === 1'b1) ? ni0il : txd_ch[10];
	assign		wire_nl1il_dataout = (rtx_pipe_enable === 1'b1) ? niill : txd_ch[11];
	assign		wire_nl1iO_dataout = (rtx_pipe_enable === 1'b1) ? niilO : txd_ch[12];
	assign		wire_nl1li_dataout = (rtx_pipe_enable === 1'b1) ? niiOi : txd_ch[13];
	assign		wire_nl1ll_dataout = (rtx_pipe_enable === 1'b1) ? niiOl : txd_ch[14];
	assign		wire_nl1lO_dataout = (rtx_pipe_enable === 1'b1) ? niiOO : txd_ch[15];
	assign		wire_nl1Oi_dataout = (rtx_pipe_enable === 1'b1) ? nil1i : txd_ch[16];
	assign		wire_nl1Ol_dataout = (rtx_pipe_enable === 1'b1) ? nil1l : txd_ch[17];
	assign		wire_nl1OO_dataout = (rtx_pipe_enable === 1'b1) ? nil1O : txd_ch[18];
	assign		wire_nli0i_dataout = (rtx_pipe_enable === 1'b1) ? niO0l : txd_ch[37];
	assign		wire_nli0l_dataout = (rtx_pipe_enable === 1'b1) ? niO0O : txd_ch[38];
	assign		wire_nli0O_dataout = (rtx_pipe_enable === 1'b1) ? niOii : txd_ch[39];
	assign		wire_nli1i_dataout = (rtx_pipe_enable === 1'b1) ? niO1l : txd_ch[34];
	assign		wire_nli1l_dataout = (rtx_pipe_enable === 1'b1) ? niO1O : txd_ch[35];
	assign		wire_nli1O_dataout = (rtx_pipe_enable === 1'b1) ? niO0i : txd_ch[36];
	assign		wire_nliii_dataout = (rtx_pipe_enable === 1'b1) ? niOil : txd_ch[40];
	assign		wire_nliil_dataout = (rtx_pipe_enable === 1'b1) ? niOiO : txd_ch[41];
	assign		wire_nliiO_dataout = (rtx_pipe_enable === 1'b1) ? niOll : txd_ch[42];
	assign		wire_nlili_dataout = (rtx_pipe_enable === 1'b1) ? ni0iO : txd_ch[43];
	oper_decoder   ni11l
	( 
	.i({rtx_elec_idle_delay[1:0]}),
	.o(wire_ni11l_o));
	defparam
		ni11l.width_i = 2,
		ni11l.width_o = 4;
	oper_selector   ni11i
	( 
	.data({n0Oii, n0Oil, n0OiO, n0Oli}),
	.o(wire_ni11i_o),
	.sel({(n0ill17 & wire_ni11l_o[3]), wire_ni11l_o[2], (n0ilO14 & wire_ni11l_o[1]), (n0iOi11 & wire_ni11l_o[0])}));
	defparam
		ni11i.width_data = 4,
		ni11i.width_sel = 4;
	assign
		n0iiO = ((~ powerdown[0]) & (~ powerdown[1])),
		n0ili = 1'b0,
		n0iOl = (n0OOl | tx_elec_idle_comp),
		n0l0O = 1'b1,
		powerstate = {wire_ni00O_dataout, wire_ni00l_dataout, wire_ni00i_dataout, wire_ni01O_dataout},
		rev_loopbk = wire_ni1OO_dataout,
		tx_elec_idle = wire_ni1Ol_dataout,
		txbeacon = wire_ni1li_dataout,
		txd = {wire_nlili_dataout, wire_nliiO_dataout, wire_nliil_dataout, wire_nliii_dataout, wire_nli0O_dataout, wire_nli0l_dataout, wire_nli0i_dataout, wire_nli1O_dataout, wire_nli1l_dataout, wire_nli1i_dataout, wire_nl0OO_dataout, wire_nl0Ol_dataout, wire_nl0Oi_dataout, wire_nl0lO_dataout, wire_nl0ll_dataout, wire_nl0li_dataout, wire_nl0iO_dataout, wire_nl0il_dataout, wire_nl0ii_dataout, wire_nl00O_dataout, wire_nl00l_dataout, wire_nl00i_dataout, wire_nl01O_dataout, wire_nl01l_dataout, wire_nl01i_dataout, wire_nl1OO_dataout, wire_nl1Ol_dataout, wire_nl1Oi_dataout, wire_nl1lO_dataout, wire_nl1ll_dataout, wire_nl1li_dataout, wire_nl1iO_dataout, wire_nl1il_dataout, wire_nl1ii_dataout, wire_nl10O_dataout, wire_nl10l_dataout, wire_nl10i_dataout, wire_nl11O_dataout, wire_nl11l_dataout, wire_nl11i_dataout, wire_niOOO_dataout, wire_niOOl_dataout, wire_niOOi_dataout, wire_niOlO_dataout},
		txdetectrx = wire_ni1lO_dataout;
endmodule //stratixiigx_hssi_tx_pipe_interface
//synopsys translate_on
//VALID FILE

//************************************************************
// Description:
// pipe_interface_top
//
// This is the top module for the PIPE Interface.
// 
//************************************************************


`timescale 1 ns / 1 ps

module stratixiigx_hssi_q_pipe_interface_top (

	// General signals
	pipe_tx_clk,
	pipe_rx_clk,
	refclk_b,
	tx_pipe_reset,
	rx_pipe_reset,
	refclk_b_reset,
	
	// CRAM 
	rtx_pipe_enable,
	rrx_pipe_enable,
	rrdwidth_rx,
	rtx_elec_idle_delay,
	rrx_detect_bypass,
	rclkcmpinsertpad,
	rphystatus_rst_toggle,
	

	// PLD - PIPE Interface
	// TX PIPE Interface: Command 
	txdetectrxloopback,
	txelecidle,
	txcompliance,
	powerdown,
	
	// TX PIPE Interface: Data
	txd_ch,
	
	// RX PIPE Interface: Command/Status
	rxpolarity,
	
	rxvalid,
	rxelecidle,
	rxstatus,
	
	// RX PIPE Interface: Data
	rxd_ch,
	
	// PHYStatus Generator
	phystatus,
	
	// Commands
	revloopback,
	polinv_rx,
	
	// PIPE - PCS Inteface
	// TX PIPE Interface
	txd,
	rev_loopbk,
	tx_elec_idle_comp,

	// RX PIPE Interface
	rxd,
	polinv_rx_int,
	
	// PIPE - PMA Interface
	// TX PIPE Interface
	tx_elec_idle,
	txdetectrx,
	powerstate,
	txbeacon,
	
	// RX PIPE Interface
	rx_found,
	rx_detect_valid,
	rxelectricalidle,
	rxbeacon,

	txdetectrxin, //shawn
	powerstatein, //shawn
	use_powerstatein, //shawn

	
	// PHYStatus Generator
	power_state_transition_done,
	power_state_transition_done_ena
);

//********************************************************************************
// INCLUDE STATEMENTS
//********************************************************************************

//********************************************************************************
// I/O SIGNALS
//********************************************************************************
	// General signals
input           txdetectrxin; //shawn
input [3:0]		powerstatein; //shawn
input           use_powerstatein; //shawn

input			pipe_tx_clk;
input			pipe_rx_clk;
input			refclk_b;
input			tx_pipe_reset;
input			rx_pipe_reset;
input			refclk_b_reset;
	
	// CRAM 
input			rtx_pipe_enable;
input			rrx_pipe_enable;
input			rrdwidth_rx;
input	[1:0]	rtx_elec_idle_delay;
input			rrx_detect_bypass;
input			rclkcmpinsertpad;
input			rphystatus_rst_toggle;

	// PLD - PIPE Interface
	// TX PIPE Interface: Command 
input			txdetectrxloopback;
input			txelecidle;
input			txcompliance;
input	[1:0]	powerdown;
	
	// TX PIPE Interface: Data
input	[43:0]	txd_ch;
	
	// RX PIPE Interface: Command/Status
input			rxpolarity;
	
output			rxvalid;
output			rxelecidle;
output	[2:0]	rxstatus;
	
	// RX PIPE Interface: Data
output	[63:0]	rxd_ch;
	
	// PHYStatus Generator
output			phystatus;
	
	// Commands
input			revloopback;
input			polinv_rx;
	
	// PIPE - PCS Inteface
	// TX PIPE Interface
output	[43:0]	txd;
output			rev_loopbk;
input			tx_elec_idle_comp;

	// RX PIPE Interface
input	[63:0]	rxd;
output			polinv_rx_int;
	
	// PIPE - PMA Interface
	// TX PIPE Interface
output			tx_elec_idle;
output			txdetectrx;
output	[3:0]	powerstate;
output			txbeacon;
	
	// RX PIPE Interface
input			rx_found;
input			rx_detect_valid;
input			rxelectricalidle;
input			rxbeacon;
	
	// PHYStatus Generator
input			power_state_transition_done;
input			power_state_transition_done_ena;

//********************************************************************************
// PARAMETERS
//********************************************************************************

//********************************************************************************
// DECLARATIONS
//********************************************************************************

wire			phystat_ena;


reg			rx_detect_valid_reg_0;
reg			rx_detect_valid_reg_1;

wire			tx_pipe_reset_n;
wire			rx_pipe_reset_n;
wire			refclk_b_reset_n;	// reset for txelecidle_d_generator

reg			txdetectrx_reg_0;
reg			txdetectrx_reg_1;
reg			txdetectrx_reg_2;
reg			txdetectrx_reg_3;
reg			txdetectrx_reg_4;
reg			txdetectrx_reg_5;
reg			txdetectrx_reg_6;

reg			bypass_rx_found;
reg			bypass_rx_detect_valid;

wire			rx_found_int;
wire			rx_detect_valid_int;

wire			latched_p0;
wire			latched_p0s;
wire			latched_p1;
wire			latched_p2;

wire            tmp_txdetectrxin;   //shawn

//********************************************************************************
// ASSIGN STATEMENTS
//********************************************************************************
assign phystat_ena = rtx_pipe_enable || rrx_pipe_enable;

assign tx_pipe_reset_n = ~tx_pipe_reset;
assign rx_pipe_reset_n = ~rx_pipe_reset;
assign refclk_b_reset_n = ~refclk_b_reset;

assign rx_found_int = rrx_detect_bypass? bypass_rx_found: rx_found;
assign rx_detect_valid_int = rrx_detect_bypass? bypass_rx_detect_valid: rx_detect_valid_reg_1;

assign tmp_txdetectrxin = (use_powerstatein == 1'b1) ? txdetectrxin : txdetectrx;  //shawn

assign latched_p0 = (use_powerstatein == 1'b1) ? powerstatein[0] : powerstate [0]; //shawn
assign latched_p0s = (use_powerstatein == 1'b1) ? powerstatein[1] : powerstate [1]; //shawn;
assign latched_p1 = (use_powerstatein == 1'b1) ? powerstatein[2] : powerstate [2]; //shawn;
assign latched_p2 = (use_powerstatein == 1'b1) ? powerstatein[3] : powerstate [3]; //shawn;
//********************************************************************************
// SUBMODULE INSTANTIATIONS
//********************************************************************************

stratixiigx_hssi_tx_pipe_interface tx_pipe_interface_inst (

	// General signals
	.clk							(pipe_tx_clk),
	.refclk_b						(refclk_b),
	.reset_n						(tx_pipe_reset_n),
	.refclk_b_reset_n				(refclk_b_reset_n),
	
	// CRAM 
	.rtx_pipe_enable				(rtx_pipe_enable),
	.rtx_elec_idle_delay			(rtx_elec_idle_delay),
	
	// PLD - PIPE Interface
	// TX PIPE Interface: Command
	.txdetectrxloopback				(txdetectrxloopback),
	.txelecidle					(txelecidle),
	.txcompliance					(txcompliance),
	.powerdown					(powerdown),
	
	// TX PIPE Interface: Data
	.txd_ch						(txd_ch),
	
	// Commands
	.revloopback					(revloopback),
	
	// PIPE - PCS Inteface
	// TX PIPE Interface
	.txd							(txd),
	.rev_loopbk					(rev_loopbk),
	.tx_elec_idle_comp				(tx_elec_idle_comp),
	
	
	// PIPE - PMA Interface
	.tx_elec_idle					(tx_elec_idle),
	.txdetectrx					(txdetectrx),
	.txbeacon						(txbeacon),

	// Central PCS
	.powerstate					(powerstate)
	
);


stratixiigx_hssi_rx_pipe_interface rx_pipe_interface_inst (

	// General signals
	.clk							(pipe_rx_clk),
	.reset_n						(rx_pipe_reset_n),
	
	// CRAM 
	.rrx_pipe_enable				(rrx_pipe_enable),
	.rrdwidth_rx					(rrdwidth_rx),
	.rclkcmpinsertpad				(rclkcmpinsertpad),
	
	// PLD - PIPE Interface
	// RX PIPE Interface: Command/Status
	.rxpolarity					(rxpolarity),
	
	.rxvalid						(rxvalid),
	.rxelecidle					(rxelecidle),
	.rxstatus						(rxstatus),
	
	// RX PIPE Interface: Data
	.rxd_ch						(rxd_ch),
	
	// Commands
	.polinv_rx					(polinv_rx),
	
	// PIPE - PCS Inteface
	// RX PIPE Interface
	.rxd							(rxd),
	.polinv_rx_int					(polinv_rx_int),

	// Latched Power State Signals
	.latched_p0					(latched_p0),
	.latched_p0s					(latched_p0s),
	.latched_p1					(latched_p1),
	.latched_p2					(latched_p2),
	
	// PIPE - PMA Interface
	// TX PIPE Interface
	.rx_found						(rx_found_int),
	.rx_detect_valid				(rx_detect_valid),
	.rx_detect_valid_sync			(rx_detect_valid_int),	
	
	// RX PIPE Interface
	.rxelectricalidle				(rxelectricalidle),
	.rxbeacon						(rxbeacon)
	
);

stratixiigx_hssi_phystatus_generator phystatus_generator_inst (

	// General signals
	.clk							(pipe_rx_clk),
	.reset_n						(rx_pipe_reset_n),
	
	//CRAM
	.phystat_ena					(phystat_ena),
	.rphystatus_rst_toggle			(rphystatus_rst_toggle),

	// PLD Interface
	.powerdown					(powerdown),
	.phystatus					(phystatus),
	
	// Latched Power State Signals
	.latched_p0					(latched_p0),
	.latched_p0s					(latched_p0s),
	.latched_p1					(latched_p1),
	.latched_p2					(latched_p2),

	// PMA interface
	// TX PMA Interface
	.rx_detect_valid				(rx_detect_valid_int),

	// RX PMA Interface
	.power_state_transition_done		(power_state_transition_done),
	.power_state_transition_done_ena	(power_state_transition_done_ena)
	
);

//********************************************************************************
// MAIN CODE 
//********************************************************************************

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		rx_detect_valid_reg_0	<= 1'b0;
	end
	else
	begin
		rx_detect_valid_reg_0	<= rx_detect_valid;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		rx_detect_valid_reg_1	<= 1'b0;
	end
	else
	begin
		rx_detect_valid_reg_1	<= rx_detect_valid_reg_0;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		txdetectrx_reg_0	<= 1'b0;
	end
	else
	begin
		txdetectrx_reg_0	<= tmp_txdetectrxin;      // txdetectrx; shawn
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		txdetectrx_reg_1	<= 1'b0;
	end
	else
	begin
		txdetectrx_reg_1	<= txdetectrx_reg_0;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		txdetectrx_reg_2	<= 1'b0;
	end
	else
	begin
		txdetectrx_reg_2	<= txdetectrx_reg_1;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		txdetectrx_reg_3	<= 1'b0;
	end
	else
	begin
		txdetectrx_reg_3	<= txdetectrx_reg_2;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		txdetectrx_reg_4	<= 1'b0;
	end
	else
	begin
		txdetectrx_reg_4	<= txdetectrx_reg_3;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		txdetectrx_reg_5	<= 1'b0;
	end
	else
	begin
		txdetectrx_reg_5	<= txdetectrx_reg_4;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		txdetectrx_reg_6	<= 1'b0;
	end
	else
	begin
		txdetectrx_reg_6	<= txdetectrx_reg_5;
	end
end

always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		bypass_rx_found		<= 1'b0;
		bypass_rx_detect_valid	<= 1'b0;
	end
	else
	begin
		bypass_rx_found		<= txdetectrx_reg_6;
		bypass_rx_detect_valid	<= txdetectrx_reg_6;
	end
end

	// Synchronize powerstate to rx clk domain
/*
always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		powerstate_0	<= 1'b0;
		powerstate_1	<= 1'b0;
		powerstate_2	<= 1'b0;
		powerstate_3	<= 1'b0;
	end
	else
	begin
		powerstate_0	<= powerstate[0];
		powerstate_1	<= powerstate[1];
		powerstate_2	<= powerstate[2];
		powerstate_3	<= powerstate[3];
	end
end
always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
begin
	if (!rx_pipe_reset_n)
	begin
		latched_p0	<= 1'b0;
		latched_p0s	<= 1'b0;
		latched_p1	<= 1'b0;
		latched_p2	<= 1'b0;
	end
	else
	begin
		latched_p0	<= powerstate_0;
		latched_p0s	<= powerstate_1;
		latched_p1	<= powerstate_2;
		latched_p2	<= powerstate_3;
	end
end*/
endmodule

`timescale 1 ns / 1 ps

module stratixiigx_hssi_pcs_reset (hard_reset, clk_2_b, refclk_b_in, scan_mode, rxpcs_rst, txpcs_rst,
                  rxrst_int, txrst_int);

input   hard_reset;
input   clk_2_b;
input   refclk_b_in;
input   scan_mode;
input   rxpcs_rst;
input   txpcs_rst;

output  rxrst_int;
output  txrst_int;

reg 	txrst_sync1, txrst_sync2;
reg     rxrst_sync1, rxrst_sync2;
wire    txrst_int, rxrst_int;


always @(posedge hard_reset or posedge clk_2_b)
begin
	if (hard_reset)
		begin
		 rxrst_sync2	<= 1'b1;
		 rxrst_sync1 	<= 1'b1;
		end
	else
		begin
		 rxrst_sync2	<= #1 rxrst_sync1;
		 rxrst_sync1	<= rxpcs_rst;
		end
end

always @(posedge hard_reset or posedge refclk_b_in)
begin
	if (hard_reset)
		begin
		 txrst_sync2	<= 1'b1;
		 txrst_sync1 	<= 1'b1;
		end
	else
		begin
		 txrst_sync2	<= #1 txrst_sync1;
		 txrst_sync1	<= txpcs_rst;
		end
end

// 06-14-02 BT Changed SCAN_SHIFT signal to SCAN_MODE
//assign rxrst_int = !SCAN_SHIFT & rxrst_sync2;
//assign txrst_int = !SCAN_SHIFT & txrst_sync2;
assign rxrst_int = !scan_mode & rxrst_sync2;
assign txrst_int = !scan_mode & txrst_sync2;

endmodule

`timescale 1 ps / 1 ps

module stratixiigx_hssi_tx_txclk_ctl (txrst, pld_tx_clk, refclk_pma, txpma_local_clk, 
                  tx_div2_sync_in_ch0, tx_div2_sync_in_q0_ch0,
                  rindv_tx, rtxwrclksel, rtxrdclksel, rdwidth_tx,            
                  rfreerun_tx, rphfifo_master_sel_tx, scan_mode,             
                  tx_clk_out, tx_div2_sync_out, wr_clk_pos,            
                  fifo_rd_clk, refclk_b
                 );

input        txrst;                  // reset for the tx_pcs
input        pld_tx_clk;             // The transmit clock from XGMII.
input        refclk_pma;             // from the root clock tree
input        txpma_local_clk;        // Local channel TX PMA clock.
input        tx_div2_sync_in_ch0;    // from the channel zero tx_div2_sync_out
input        tx_div2_sync_in_q0_ch0; // From channel0 of Master Quad
input	     rindv_tx;               // Selects between indiv chan. mode and bundled mode
input        rtxwrclksel;            // Selects which clock writes into FIFO
input        rtxrdclksel;            // Selects which clock reads from FIFO and also clocks reest of TX logic
input  	     rdwidth_tx;             // divide by 1 or 2 before feeding to FIFO read clock
input        rfreerun_tx;            // Select whether divider is permamently enabled (free -running) or
			             // divider should be enabled / reset by TX PCS reset  
input        rphfifo_master_sel_tx;  // TX Phase comp. FIFO tx_div2_sync selection CRAM
input        scan_mode;              // Scan mode enable signal for selecting scan_clk from refclk_pma

output       tx_clk_out;             // Drives to the PLD clock tree -- unconnected
output       tx_div2_sync_out;       // Synchronizes the divided by two clock
output       wr_clk_pos;             // Drives tx phase comp fifo write side
output       fifo_rd_clk;            // Drives tx phase comp fifo read side
output       refclk_b;               // Drives the tx channel clock

wire tx_rst_n,tx_div2_sync;
reg fifo_rd_clk_by2;
wire rd_clk_before_div;  //Same as refclk_b. Different name for clarity.

// initial begin ------
initial begin
    fifo_rd_clk_by2 = 1'b0;
end             
// initial end   ------

// Select between the local synchronization signal or the global synchronization signal (either from Channel0 or 
// Channel0 of Master Quad
//assign tx_div2_sync = rindv_tx ? tx_div2_sync_out : tx_div2_sync_in;
assign tx_div2_sync = (rphfifo_master_sel_tx == 1'b0) ? tx_div2_sync_in_q0_ch0 :
                      (rindv_tx == 1'b0) ? tx_div2_sync_in_ch0 : tx_div2_sync_out;

assign tx_div2_sync_out = ~fifo_rd_clk_by2;

// Divide-by-2 FF
always @(negedge tx_rst_n or posedge rd_clk_before_div)
begin
	if (~tx_rst_n)
		fifo_rd_clk_by2 <= 1'b0;
	else if (rd_clk_before_div)
		fifo_rd_clk_by2 <= tx_div2_sync; // local divided clock
end

// Reset for Divide-by-2 FF
assign tx_rst_n = (rfreerun_tx) ? 1'b1 : ~txrst;

// Full speed clock for TX PCS
assign refclk_b = rd_clk_before_div;	// Internal

// Output clock for PLD
assign tx_clk_out = fifo_rd_clk;	// to PLD

// TX FIFO read clock: could be fast or divided by 2
assign fifo_rd_clk = ((rdwidth_tx == 1'b0) || scan_mode) ? rd_clk_before_div : fifo_rd_clk_by2;
assign rd_clk_before_div = (rtxrdclksel || scan_mode) ? refclk_pma : txpma_local_clk; //Same as refclk_b. Different name for clarity.

// TX FIFO write clock: used internal clock when in BIST 
assign wr_clk_pos = (rtxwrclksel || scan_mode) ? fifo_rd_clk : pld_tx_clk;


endmodule

`timescale 1ps / 1ps

module stratixiigx_hssi_tx_ram8x44_syn (
    data_in,
    clk,
    fifo_wr,
    rst_l, 
    fifo_re,
    data_out
    );

input 		clk;
input 		rst_l;
input 	[7:0]	fifo_wr;
input 	[7:0] 	fifo_re;
input 	[43:0] 	data_in;
output 	[43:0] 	data_out;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 44;

reg [ram_width-1:0] data_out_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, 
                    ram_array_d_3, ram_array_d_4, ram_array_d_5, 
                    ram_array_d_6, ram_array_d_7, 
 		    ram_array_q_0, ram_array_q_1, ram_array_q_2, 
                    ram_array_q_3, ram_array_q_4, ram_array_q_5, 
                    ram_array_q_6, ram_array_q_7;

wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7;

wire 		we, re_l;

assign we = 1'b1;
assign re_l = 1'b0;

/* Modelling the read port */
/* Assuming address trigerred operation only */
assign
    data_reg_0 = ( fifo_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( fifo_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( fifo_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( fifo_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( fifo_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( fifo_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( fifo_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( fifo_wr[7] == 1'b1 ) ? data_in : ram_array_q_7;

assign  data_out = re_l ? 44'b0 : data_out_i;

always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    fifo_re		
    )
begin
    case ( fifo_re )  // synopsys parallel_case full_case
    8'b00000001 : data_out_i = ram_array_q_0;
    8'b00000010 : data_out_i = ram_array_q_1;
    8'b00000100 : data_out_i = ram_array_q_2;
    8'b00001000 : data_out_i = ram_array_q_3;
    8'b00010000 : data_out_i = ram_array_q_4;
    8'b00100000 : data_out_i = ram_array_q_5;
    8'b01000000 : data_out_i = ram_array_q_6;
    8'b10000000 : data_out_i = ram_array_q_7;
    default     : data_out_i = ram_array_q_0;
    endcase
end


/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 0;
	ram_array_q_1 <= #write_access_time 0;
	ram_array_q_2 <= #write_access_time 0; 
	ram_array_q_3 <= #write_access_time 0; 
        ram_array_q_4 <= #write_access_time 0;
        ram_array_q_5 <= #write_access_time 0;
        ram_array_q_6 <= #write_access_time 0;
        ram_array_q_7 <= #write_access_time 0; 
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
    end
end
         
always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	
       )
begin
    if(we) begin
	ram_array_d_0 =  data_reg_0;
	ram_array_d_1 =  data_reg_1;
	ram_array_d_2 =  data_reg_2;
	ram_array_d_3 =  data_reg_3;
        ram_array_d_4 =  data_reg_4;
        ram_array_d_5 =  data_reg_5;
        ram_array_d_6 =  data_reg_6;
        ram_array_d_7 =  data_reg_7; 
    end
    else begin
	ram_array_d_0 =  ram_array_q_0;
	ram_array_d_1 =  ram_array_q_1;
	ram_array_d_2 =  ram_array_q_2;
	ram_array_d_3 =  ram_array_q_3;
        ram_array_d_4 =  ram_array_q_4;
        ram_array_d_5 =  ram_array_q_5;
        ram_array_d_6 =  ram_array_q_6;
        ram_array_d_7 =  ram_array_q_7;
    end
end

endmodule

`timescale 1 ps / 1 ps

module tx_ph_fifo (
// inputs
	rst_wclk,
	rst_rclk,
	wr_clk,
	rd_clk,
	bypass_en,
	//en,
	lowlatency_en,
	we,
	re,
	din,
// outputs
	data_out,
	ph_fifo_full,
	ph_fifo_empty,
	wptr_bin,
	rptr_bin
);

// =======
// inputs
// =======
input         rst_wclk;		// wr clk rst
input         rst_rclk;		// rd clk rst
input         wr_clk;		// Write Clock
input         rd_clk;		// Read Clock
input         bypass_en;	// FIFO bypass enable - only for Altera internal debug
//input         en;		// Disable FIFO, reset wptr and rptr 
				// only for Altera internal debug
input         lowlatency_en;	// Enable low latency option 
input         we;		// PLD dynamic write pointer enable  
input         re;		// PLD dynamic read pointer enable  
input  [43:0] din;		// 10-bit code-group bus from deskew module.

// =======
// outputs
// =======
output        ph_fifo_full;	// Indicates overflow (rd_clk)
output        ph_fifo_empty;	// FIFO empty (rd_clk)
output [43:0] data_out;		// output data (rd_clk synchronous if not FIFO bypass)
output  [2:0] wptr_bin;		// wptr test bus
output  [2:0] rptr_bin;		// rptr test bus

// ===================
// signal declaration
// ===================
reg  [ 7:0] wptr, rptr;
reg  [ 7:0] wptr0;
reg  [ 7:0] wptr1;
reg  [ 3:0] rptr_gray;
reg  [ 2:0] rptr0;
reg  [ 2:0] rptr1;
reg  [ 7:0] rptr1_onehot;
reg  [ 2:0] wptr_bin;		// wptr test bus
reg  [ 2:0] rptr_bin;		// rptr test bus
reg         first_rd;		// first read after reset
reg  [43:0] ram_data_out;
wire [43:0] ram_data_out_pre;

reg  ph_fifo_full, ph_fifo_empty;

// Invert rst for new FIFO     
wire rst_n;

// =============
// functionality
// =============
assign rst_n = ~rst_wclk;

assign data_out[43:0] = (bypass_en)? din : ram_data_out;

always @ (posedge rst_wclk or posedge wr_clk)
begin
   if (rst_wclk == 1'b1)
   begin
      wptr  <= 8'h01;
      wptr0 <= 8'h01;
      wptr1 <= 8'h01;
      rptr0 <= 3'h0;
      rptr1 <= 3'h0;
      ph_fifo_full <= 1'b0;
      ph_fifo_empty <= 1'b0;
   end
   else
   begin

      wptr0 <= wptr;
      wptr1 <= wptr0;

      rptr0 <= rptr_gray;
      rptr1 <= rptr0;

      // wptr operation
      if (we == 1'b1)
         wptr <= {wptr[6:0],wptr[7]};

      // full condition
      if ({wptr1[6:0],wptr1[7]} == rptr1_onehot)
         ph_fifo_full <= 1'b1;
      else if (ph_fifo_full == 1'b1 & ({wptr1[6:0],wptr1[7]} != rptr1_onehot) & (wptr1 != rptr1_onehot))
         ph_fifo_full <= 1'b0;

      // empty condition
      if ({rptr1_onehot[6:0],rptr1_onehot[7]} == wptr1)
         ph_fifo_empty <= 1'b1;
      else if (ph_fifo_empty == 1'b1 & ({rptr1_onehot[6:0],rptr1_onehot[7]} != wptr1) & (wptr1 != rptr1_onehot))
         ph_fifo_empty <= 1'b0;
   end
end


always @ (posedge rst_rclk or posedge rd_clk)
begin
   if (rst_rclk == 1'b1)
   begin
      first_rd <= 1'b1;
      rptr  <= 8'h20;
   end
   else
   begin

      if (first_rd == 1'b1 && re == 1'b1)
          first_rd <= 1'b0;

      // read pointer operation
      if (re == 1'b1)
         // low latency option, advance 2 on the first read 
         if (first_rd == 1'b1 && lowlatency_en == 1'b1)
            rptr <= {rptr[5:0],rptr[7:6]};	
         else
            rptr <= {rptr[6:0],rptr[7]};
   end

end

// Instantiate FIFO CORE Module. Fifo 8 words deep, 44 bits wide
stratixiigx_hssi_tx_ram8x44_syn   ram8x44_syn_1 (
                                  .rst_l (rst_n),
                                  .clk (wr_clk),
                                  .fifo_wr (wptr),
                                  .data_in (din),
                                  .fifo_re (rptr),
                                  .data_out (ram_data_out_pre)
		        	);

always @ (posedge rst_rclk or posedge rd_clk)
begin
   if (rst_rclk)
   begin
	ram_data_out <= 44'h00000000000;
   end
   else  
        ram_data_out <= ram_data_out_pre;
end

always@(wptr)
begin
  case(wptr)
  8'h01: wptr_bin = 3'h0;
  8'h02: wptr_bin = 3'h1;
  8'h04: wptr_bin = 3'h2;
  8'h08: wptr_bin = 3'h3;
  8'h10: wptr_bin = 3'h4;
  8'h20: wptr_bin = 3'h5;
  8'h40: wptr_bin = 3'h6;
  8'h80: wptr_bin = 3'h7;
  default: wptr_bin = 3'h7;
  endcase
end

always@(rptr)
begin
  case(rptr)
  8'h01: rptr_bin = 3'h0;
  8'h02: rptr_bin = 3'h1;
  8'h04: rptr_bin = 3'h2;
  8'h08: rptr_bin = 3'h3;
  8'h10: rptr_bin = 3'h4;
  8'h20: rptr_bin = 3'h5;
  8'h40: rptr_bin = 3'h6;
  8'h80: rptr_bin = 3'h7;
  default: rptr_bin = 3'h7;
  endcase
end

always@(rptr)
begin
  case(rptr)
  8'h01: rptr_gray = 3'h0;
  8'h02: rptr_gray = 3'h1;
  8'h04: rptr_gray = 3'h3;
  8'h08: rptr_gray = 3'h2;
  8'h10: rptr_gray = 3'h6;
  8'h20: rptr_gray = 3'h7;
  8'h40: rptr_gray = 3'h5;
  8'h80: rptr_gray = 3'h4;
  default: rptr_gray = 3'h0;
  endcase
end

always@(rptr1)
begin
  case(rptr1)
  3'h0: rptr1_onehot = 8'h01;
  3'h1: rptr1_onehot = 8'h02;
  3'h3: rptr1_onehot = 8'h04;
  3'h2: rptr1_onehot = 8'h08;
  3'h6: rptr1_onehot = 8'h10;
  3'h7: rptr1_onehot = 8'h20;
  3'h5: rptr1_onehot = 8'h40;
  3'h4: rptr1_onehot = 8'h80;
  default: rptr1_onehot = 8'h01;
  endcase
end

endmodule
//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 125 mux21 250 tx_ph_fifo 1 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_tx_ctrl
	( 
	d21_5_eq_n,
	d2_2_eq_n,
	dwidth,
	fifo_rd_clk,
	fifo_select_in_ch0,
	fifo_select_in_q0_ch0,
	fifo_select_out,
	fifo_wr_clk,
	indv,
	k_det,
	p_rlpbk,
	ph_fifo_empty,
	ph_fifo_full,
	pipe_electric_idle,
	pld_rd_dis,
	pld_we,
	rd_enable2,
	rd_enable_ch0,
	rd_enable_out,
	rd_enable_q0_ch0,
	rd_enable_sync,
	redund_ctl,
	refclk_b_in,
	rforce_disp,
	rforce_echar,
	rforce_kchar,
	rphfifo_master_sel_tx,
	rptr_bin,
	rtx_pipe_enable,
	rtxfifo_lowlatency_en,
	rtxfifo_urst_en,
	rtxphfifopldctl_en,
	rxd_lpbk,
	scan_mode,
	selftest_en,
	soft_reset,
	soft_reset_wclk1,
	tx_control_sg,
	tx_ctl_tc,
	tx_data_9_tc,
	tx_data_sg,
	tx_data_tc,
	txd,
	txd_extend,
	txd_extend_tc,
	txd_redun,
	txfifo_dis,
	txfifo_urst,
	wptr_bin,
	wr_enable2,
	wr_enable_ch0,
	wr_enable_out,
	wr_enable_q0_ch0) /* synthesis synthesis_clearbox=1 */;
	output   [1:0]  d21_5_eq_n;
	output   [1:0]  d2_2_eq_n;
	input   dwidth;
	input   fifo_rd_clk;
	input   fifo_select_in_ch0;
	input   fifo_select_in_q0_ch0;
	output   fifo_select_out;
	input   fifo_wr_clk;
	input   indv;
	output   [1:0]  k_det;
	input   p_rlpbk;
	output   ph_fifo_empty;
	output   ph_fifo_full;
	output   pipe_electric_idle;
	input   pld_rd_dis;
	input   pld_we;
	output   rd_enable2;
	input   rd_enable_ch0;
	output   rd_enable_out;
	input   rd_enable_q0_ch0;
	output   rd_enable_sync;
	input   [3:0]  redund_ctl;
	input   refclk_b_in;
	input   rforce_disp;
	input   rforce_echar;
	input   rforce_kchar;
	input   rphfifo_master_sel_tx;
	output   [2:0]  rptr_bin;
	input   rtx_pipe_enable;
	input   rtxfifo_lowlatency_en;
	input   rtxfifo_urst_en;
	input   rtxphfifopldctl_en;
	input   [39:0]  rxd_lpbk;
	input   scan_mode;
	input   selftest_en;
	input   soft_reset;
	output   soft_reset_wclk1;
	input   [3:0]  tx_control_sg;
	output   [1:0]  tx_ctl_tc;
	output   [1:0]  tx_data_9_tc;
	input   [31:0]  tx_data_sg;
	output   [15:0]  tx_data_tc;
	input   [39:0]  txd;
	input   [3:0]  txd_extend;
	output   [1:0]  txd_extend_tc;
	input   [39:0]  txd_redun;
	input   txfifo_dis;
	input   txfifo_urst;
	output   [2:0]  wptr_bin;
	output   wr_enable2;
	input   wr_enable_ch0;
	output   wr_enable_out;
	input   wr_enable_q0_ch0;

	reg	nl00ii49;
	reg	nl00ii50;
	reg	nl00ii51;
	reg	nl00iO46;
	reg	nl00iO47;
	reg	nl00iO48;
	reg	nl00ll43;
	reg	nl00ll44;
	reg	nl00ll45;
	reg	nl00Oi40;
	reg	nl00Oi41;
	reg	nl00Oi42;
	reg	nl0iii37;
	reg	nl0iii38;
	reg	nl0iii39;
	reg	nl0iiO34;
	reg	nl0iiO35;
	reg	nl0iiO36;
	reg	nl0ill31;
	reg	nl0ill32;
	reg	nl0ill33;
	reg	nl0iOi28;
	reg	nl0iOi29;
	reg	nl0iOi30;
	reg	nl0iOO25;
	reg	nl0iOO26;
	reg	nl0iOO27;
	reg	nl0l0l19;
	reg	nl0l0l20;
	reg	nl0l0l21;
	reg	nl0l1l22;
	reg	nl0l1l23;
	reg	nl0l1l24;
	reg	nl0lii16;
	reg	nl0lii17;
	reg	nl0lii18;
	reg	nl0liO13;
	reg	nl0liO14;
	reg	nl0liO15;
	reg	nl0lll10;
	reg	nl0lll11;
	reg	nl0lll12;
	reg	nl0O0O7;
	reg	nl0O0O8;
	reg	nl0O0O9;
	reg	nl0OiO4;
	reg	nl0OiO5;
	reg	nl0OiO6;
	reg	nl0OlO1;
	reg	nl0OlO2;
	reg	nl0OlO3;
	reg	n010i;
	reg	n010l;
	reg	n010O;
	reg	n011i;
	reg	n011l;
	reg	n011O;
	reg	n01ii;
	reg	n01il;
	reg	n01iO;
	reg	n01li;
	reg	n01Oi;
	reg	n10OO;
	reg	n1i1i;
	reg	n1i1l;
	reg	n1iil;
	reg	n1iiO;
	reg	n1ili;
	reg	n1ill;
	reg	n1ilO;
	reg	n1iOi;
	reg	n1O0l;
	reg	n1O0O;
	reg	n1Oii;
	reg	n1Oil;
	reg	n1OiO;
	reg	n1Oli;
	reg	n1Oll;
	reg	n1OlO;
	reg	n1OOi;
	reg	n1OOl;
	reg	n1OOO;
	reg	n100i;
	reg	n100l;
	reg	n100O;
	reg	n10il;
	reg	n10iO;
	reg	n10ll;
	reg	n10lO;
	reg	n10Ol;
	reg	n1iOl;
	reg	n1iOO;
	reg	n1l0i;
	reg	n1l0l;
	reg	n1l0O;
	reg	n1l1i;
	reg	n1l1l;
	reg	n1l1O;
	reg	n1lii;
	reg	n1lil;
	reg	n1liO;
	reg	n1lli;
	reg	n1lll;
	reg	n1llO;
	reg	n1lOi;
	reg	n1lOl;
	reg	n1lOO;
	reg	n1O0i;
	reg	n1O1i;
	reg	n1O1l;
	reg	nl00O;
	reg	nl1lO;
	reg	nl1Oi;
	reg	nl1Ol;
	reg	n000i;
	reg	n000l;
	reg	n000O;
	reg	n001i;
	reg	n001l;
	reg	n001O;
	reg	n00ii;
	reg	n00il;
	reg	n01Ol;
	reg	n01OO;
	reg	nl1ll;
	wire	wire_n00i_dataout;
	wire	wire_n00iO_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00li_dataout;
	wire	wire_n00ll_dataout;
	wire	wire_n00lO_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n00Ol_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0i0i_dataout;
	wire	wire_n0i0l_dataout;
	wire	wire_n0i0O_dataout;
	wire	wire_n0i1l_dataout;
	wire	wire_n0i1O_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0iii_dataout;
	wire	wire_n0iil_dataout;
	wire	wire_n0iiO_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0ili_dataout;
	wire	wire_n0ill_dataout;
	wire	wire_n0ilO_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0iOi_dataout;
	wire	wire_n0iOl_dataout;
	wire	wire_n0iOO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0l0i_dataout;
	wire	wire_n0l0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0l1i_dataout;
	wire	wire_n0l1l_dataout;
	wire	wire_n0l1O_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0lii_dataout;
	wire	wire_n0lil_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lli_dataout;
	wire	wire_n0lll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0lOi_dataout;
	wire	wire_n0lOl_dataout;
	wire	wire_n0lOO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O0l_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n0OOO_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1i0i_dataout;
	wire	wire_n1i0l_dataout;
	wire	wire_n1i0O_dataout;
	wire	wire_n1i1O_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1iii_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_ni_dataout;
	wire	wire_ni00i_dataout;
	wire	wire_ni00l_dataout;
	wire	wire_ni00O_dataout;
	wire	wire_ni01i_dataout;
	wire	wire_ni01l_dataout;
	wire	wire_ni01O_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0ii_dataout;
	wire	wire_ni0il_dataout;
	wire	wire_ni0iO_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0li_dataout;
	wire	wire_ni0ll_dataout;
	wire	wire_ni0lO_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0Oi_dataout;
	wire	wire_ni0Ol_dataout;
	wire	wire_ni0OO_dataout;
	wire	wire_ni10i_dataout;
	wire	wire_ni10l_dataout;
	wire	wire_ni10O_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni11l_dataout;
	wire	wire_ni11O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1ii_dataout;
	wire	wire_ni1il_dataout;
	wire	wire_ni1iO_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1li_dataout;
	wire	wire_ni1ll_dataout;
	wire	wire_ni1lO_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1Oi_dataout;
	wire	wire_ni1Ol_dataout;
	wire	wire_ni1OO_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii1i_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil1i_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nili_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO0l_dataout;
	wire	wire_niO0O_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOii_dataout;
	wire	wire_niOil_dataout;
	wire	wire_niOiO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOli_dataout;
	wire	wire_niOll_dataout;
	wire	wire_niOlO_dataout;
	wire	wire_niOO_dataout;
	wire	wire_niOOi_dataout;
	wire	wire_niOOl_dataout;
	wire	wire_niOOO_dataout;
	wire	wire_nl_dataout;
	wire	wire_nl00i_dataout;
	wire	wire_nl01i_dataout;
	wire	wire_nl01l_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0ii_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0li_dataout;
	wire	wire_nl0ll_dataout;
	wire	wire_nl0lO_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl0Oi_dataout;
	wire	wire_nl0Ol_dataout;
	wire	wire_nl0OO_dataout;
	wire	wire_nl10i_dataout;
	wire	wire_nl10l_dataout;
	wire	wire_nl10O_dataout;
	wire	wire_nl11i_dataout;
	wire	wire_nl11l_dataout;
	wire	wire_nl11O_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1ii_dataout;
	wire	wire_nl1il_dataout;
	wire	wire_nl1iO_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1OO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli0i_dataout;
	wire	wire_nli0l_dataout;
	wire	wire_nli0O_dataout;
	wire	wire_nli1i_dataout;
	wire	wire_nli1l_dataout;
	wire	wire_nli1O_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nliii_dataout;
	wire	wire_nliil_dataout;
	wire	wire_nliiO_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlili_dataout;
	wire	wire_nlill_dataout;
	wire	wire_nlilO_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliOi_dataout;
	wire	wire_nliOl_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO0l_dataout;
	wire	wire_nlO0O_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOO_dataout;
	wire	wire_nO_dataout;
	wire  [43:0]   wire_nli11i_data_out;
	wire  wire_nli11i_ph_fifo_empty;
	wire  wire_nli11i_ph_fifo_full;
	wire  [2:0]   wire_nli11i_rptr_bin;
	wire  [2:0]   wire_nli11i_wptr_bin;
	wire  nl00OO;
	wire  nl0i0i;
	wire  nl0i0l;
	wire  nl0i0O;
	wire  nl0i1i;
	wire  nl0i1l;
	wire  nl0i1O;
	wire  nl0l0i;
	wire  nl0lOi;
	wire  nl0lOl;
	wire  nl0lOO;
	wire  nl0O0i;
	wire  nl0O0l;
	wire  nl0O1i;
	wire  nl0O1l;
	wire  nl0O1O;
	wire  nl0Oil;
	wire  nl0Oll;

	initial
		nl00ii49 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl00ii49 <= nl00ii51;
	initial
		nl00ii50 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl00ii50 <= (nl00ii51 ^ nl00ii49);
	initial
		nl00ii51 = 0;
	always @ ( posedge refclk_b_in)
		  nl00ii51 <= nl00ii49;
	initial
		nl00iO46 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl00iO46 <= nl00iO48;
	initial
		nl00iO47 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl00iO47 <= (nl00iO48 ^ nl00iO46);
	initial
		nl00iO48 = 0;
	always @ ( posedge refclk_b_in)
		  nl00iO48 <= nl00iO46;
	initial
		nl00ll43 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl00ll43 <= nl00ll45;
	initial
		nl00ll44 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl00ll44 <= (nl00ll45 ^ nl00ll43);
	initial
		nl00ll45 = 0;
	always @ ( posedge refclk_b_in)
		  nl00ll45 <= nl00ll43;
	initial
		nl00Oi40 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl00Oi40 <= nl00Oi42;
	initial
		nl00Oi41 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl00Oi41 <= (nl00Oi42 ^ nl00Oi40);
	initial
		nl00Oi42 = 0;
	always @ ( posedge refclk_b_in)
		  nl00Oi42 <= nl00Oi40;
	initial
		nl0iii37 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0iii37 <= nl0iii39;
	initial
		nl0iii38 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0iii38 <= (nl0iii39 ^ nl0iii37);
	initial
		nl0iii39 = 0;
	always @ ( posedge refclk_b_in)
		  nl0iii39 <= nl0iii37;
	initial
		nl0iiO34 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0iiO34 <= nl0iiO36;
	initial
		nl0iiO35 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0iiO35 <= (nl0iiO36 ^ nl0iiO34);
	initial
		nl0iiO36 = 0;
	always @ ( posedge refclk_b_in)
		  nl0iiO36 <= nl0iiO34;
	initial
		nl0ill31 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0ill31 <= nl0ill33;
	initial
		nl0ill32 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0ill32 <= (nl0ill33 ^ nl0ill31);
	initial
		nl0ill33 = 0;
	always @ ( posedge refclk_b_in)
		  nl0ill33 <= nl0ill31;
	initial
		nl0iOi28 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0iOi28 <= nl0iOi30;
	initial
		nl0iOi29 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0iOi29 <= (nl0iOi30 ^ nl0iOi28);
	initial
		nl0iOi30 = 0;
	always @ ( posedge refclk_b_in)
		  nl0iOi30 <= nl0iOi28;
	initial
		nl0iOO25 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0iOO25 <= nl0iOO27;
	initial
		nl0iOO26 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0iOO26 <= (nl0iOO27 ^ nl0iOO25);
	initial
		nl0iOO27 = 0;
	always @ ( posedge refclk_b_in)
		  nl0iOO27 <= nl0iOO25;
	initial
		nl0l0l19 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0l0l19 <= nl0l0l21;
	initial
		nl0l0l20 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0l0l20 <= (nl0l0l21 ^ nl0l0l19);
	initial
		nl0l0l21 = 0;
	always @ ( posedge refclk_b_in)
		  nl0l0l21 <= nl0l0l19;
	initial
		nl0l1l22 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0l1l22 <= nl0l1l24;
	initial
		nl0l1l23 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0l1l23 <= (nl0l1l24 ^ nl0l1l22);
	initial
		nl0l1l24 = 0;
	always @ ( posedge refclk_b_in)
		  nl0l1l24 <= nl0l1l22;
	initial
		nl0lii16 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0lii16 <= nl0lii18;
	initial
		nl0lii17 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0lii17 <= (nl0lii18 ^ nl0lii16);
	initial
		nl0lii18 = 0;
	always @ ( posedge refclk_b_in)
		  nl0lii18 <= nl0lii16;
	initial
		nl0liO13 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0liO13 <= nl0liO15;
	initial
		nl0liO14 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0liO14 <= (nl0liO15 ^ nl0liO13);
	initial
		nl0liO15 = 0;
	always @ ( posedge refclk_b_in)
		  nl0liO15 <= nl0liO13;
	initial
		nl0lll10 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0lll10 <= nl0lll12;
	initial
		nl0lll11 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0lll11 <= (nl0lll12 ^ nl0lll10);
	initial
		nl0lll12 = 0;
	always @ ( posedge refclk_b_in)
		  nl0lll12 <= nl0lll10;
	initial
		nl0O0O7 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0O0O7 <= nl0O0O9;
	initial
		nl0O0O8 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0O0O8 <= (nl0O0O9 ^ nl0O0O7);
	initial
		nl0O0O9 = 0;
	always @ ( posedge refclk_b_in)
		  nl0O0O9 <= nl0O0O7;
	initial
		nl0OiO4 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0OiO4 <= nl0OiO6;
	initial
		nl0OiO5 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0OiO5 <= (nl0OiO6 ^ nl0OiO4);
	initial
		nl0OiO6 = 0;
	always @ ( posedge refclk_b_in)
		  nl0OiO6 <= nl0OiO4;
	initial
		nl0OlO1 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0OlO1 <= nl0OlO3;
	initial
		nl0OlO2 = {1{1'b1}};
	always @ ( posedge refclk_b_in)
		  nl0OlO2 <= (nl0OlO3 ^ nl0OlO1);
	initial
		nl0OlO3 = 0;
	always @ ( posedge refclk_b_in)
		  nl0OlO3 <= nl0OlO1;
	initial
	begin
		n010i = 0;
		n010l = 0;
		n010O = 0;
		n011i = 0;
		n011l = 0;
		n011O = 0;
		n01ii = 0;
		n01il = 0;
		n01iO = 0;
		n01li = 0;
		n01Oi = 0;
		n10OO = 0;
		n1i1i = 0;
		n1i1l = 0;
		n1iil = 0;
		n1iiO = 0;
		n1ili = 0;
		n1ill = 0;
		n1ilO = 0;
		n1iOi = 0;
		n1O0l = 0;
		n1O0O = 0;
		n1Oii = 0;
		n1Oil = 0;
		n1OiO = 0;
		n1Oli = 0;
		n1Oll = 0;
		n1OlO = 0;
		n1OOi = 0;
		n1OOl = 0;
		n1OOO = 0;
	end
	always @ ( posedge refclk_b_in or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n010i <= 0;
			n010l <= 0;
			n010O <= 0;
			n011i <= 0;
			n011l <= 0;
			n011O <= 0;
			n01ii <= 0;
			n01il <= 0;
			n01iO <= 0;
			n01li <= 0;
			n01Oi <= 0;
			n10OO <= 0;
			n1i1i <= 0;
			n1i1l <= 0;
			n1iil <= 0;
			n1iiO <= 0;
			n1ili <= 0;
			n1ill <= 0;
			n1ilO <= 0;
			n1iOi <= 0;
			n1O0l <= 0;
			n1O0O <= 0;
			n1Oii <= 0;
			n1Oil <= 0;
			n1OiO <= 0;
			n1Oli <= 0;
			n1Oll <= 0;
			n1OlO <= 0;
			n1OOi <= 0;
			n1OOl <= 0;
			n1OOO <= 0;
		end
		else 
		begin
			n010i <= wire_ni1li_dataout;
			n010l <= wire_ni1ll_dataout;
			n010O <= wire_ni1lO_dataout;
			n011i <= wire_ni1ii_dataout;
			n011l <= wire_ni1il_dataout;
			n011O <= wire_ni1iO_dataout;
			n01ii <= wire_ni1Oi_dataout;
			n01il <= wire_niOiO_dataout;
			n01iO <= wire_niOli_dataout;
			n01li <= wire_nl10i_dataout;
			n01Oi <= wire_nl10l_dataout;
			n10OO <= wire_n1i1O_dataout;
			n1i1i <= n1i1l;
			n1i1l <= nl0O0i;
			n1iil <= wire_n1i0O_dataout;
			n1iiO <= wire_ni1Ol_dataout;
			n1ili <= n1ilO;
			n1ill <= n1iOi;
			n1ilO <= nl0i0l;
			n1iOi <= nl0i0O;
			n1O0l <= wire_n01ll_dataout;
			n1O0O <= wire_ni1OO_dataout;
			n1Oii <= wire_n0OOi_dataout;
			n1Oil <= wire_n0OOl_dataout;
			n1OiO <= wire_n0OOO_dataout;
			n1Oli <= wire_ni11i_dataout;
			n1Oll <= wire_ni11l_dataout;
			n1OlO <= wire_ni11O_dataout;
			n1OOi <= wire_ni10i_dataout;
			n1OOl <= wire_ni10l_dataout;
			n1OOO <= wire_ni10O_dataout;
		end
	end
	initial
	begin
		n100i = 0;
		n100l = 0;
		n100O = 0;
		n10il = 0;
	end
	always @ ( posedge refclk_b_in or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n100i <= 1;
			n100l <= 1;
			n100O <= 1;
			n10il <= 1;
		end
		else 
		begin
			n100i <= (~ nl00OO);
			n100l <= (~ nl0i1i);
			n100O <= (~ nl0i1l);
			n10il <= (~ nl0i1O);
		end
	end
	initial
	begin
		n10iO = 0;
		n10ll = 0;
	end
	always @ ( posedge fifo_rd_clk or posedge nl0O0l)
	begin
		if (nl0O0l == 1'b1) 
		begin
			n10iO <= 1;
			n10ll <= 1;
		end
		else 
		begin
			n10iO <= n10ll;
			n10ll <= nl0i0i;
		end
	end
	initial
	begin
		n10lO = 0;
		n10Ol = 0;
	end
	always @ ( posedge fifo_wr_clk or posedge nl0O0l)
	begin
		if (nl0O0l == 1'b1) 
		begin
			n10lO <= 1;
			n10Ol <= 1;
		end
		else 
		begin
			n10lO <= n10Ol;
			n10Ol <= nl0i0i;
		end
	end
	initial
	begin
		n1iOl = 0;
		n1iOO = 0;
		n1l0i = 0;
		n1l0l = 0;
		n1l0O = 0;
		n1l1i = 0;
		n1l1l = 0;
		n1l1O = 0;
		n1lii = 0;
		n1lil = 0;
		n1liO = 0;
		n1lli = 0;
		n1lll = 0;
		n1llO = 0;
		n1lOi = 0;
		n1lOl = 0;
		n1lOO = 0;
		n1O0i = 0;
		n1O1i = 0;
		n1O1l = 0;
	end
	always @ ( posedge refclk_b_in or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1iOl <= 0;
			n1iOO <= 0;
			n1l0i <= 0;
			n1l0l <= 0;
			n1l0O <= 0;
			n1l1i <= 0;
			n1l1l <= 0;
			n1l1O <= 0;
			n1lii <= 0;
			n1lil <= 0;
			n1liO <= 0;
			n1lli <= 0;
			n1lll <= 0;
			n1llO <= 0;
			n1lOi <= 0;
			n1lOl <= 0;
			n1lOO <= 0;
			n1O0i <= 0;
			n1O1i <= 0;
			n1O1l <= 0;
		end
		else if  (nl0l0i == 1'b1) 
		begin
			n1iOl <= wire_nl0li_dataout;
			n1iOO <= wire_nl0ll_dataout;
			n1l0i <= wire_nl0OO_dataout;
			n1l0l <= wire_nli1i_dataout;
			n1l0O <= wire_nli1l_dataout;
			n1l1i <= wire_nl0lO_dataout;
			n1l1l <= wire_nl0Oi_dataout;
			n1l1O <= wire_nl0Ol_dataout;
			n1lii <= wire_nli1O_dataout;
			n1lil <= wire_nli0i_dataout;
			n1liO <= wire_nli0l_dataout;
			n1lli <= wire_nli0O_dataout;
			n1lll <= wire_nliii_dataout;
			n1llO <= wire_nliil_dataout;
			n1lOi <= wire_nliiO_dataout;
			n1lOl <= wire_nlili_dataout;
			n1lOO <= wire_nlill_dataout;
			n1O0i <= wire_nliOl_dataout;
			n1O1i <= wire_nlilO_dataout;
			n1O1l <= wire_nliOi_dataout;
		end
	end
	initial
	begin
		nl00O = 0;
		nl1lO = 0;
		nl1Oi = 0;
		nl1Ol = 0;
	end
	always @ ( posedge fifo_wr_clk or posedge wire_nl0ii_dataout)
	begin
		if (wire_nl0ii_dataout == 1'b1) 
		begin
			nl00O <= 0;
			nl1lO <= 0;
			nl1Oi <= 0;
			nl1Ol <= 0;
		end
		else 
		begin
			nl00O <= nl0O0i;
			nl1lO <= wire_nl1OO_dataout;
			nl1Oi <= wire_nl01l_dataout;
			nl1Ol <= nl00O;
		end
	end
	initial
	begin
		n000i = 0;
		n000l = 0;
		n000O = 0;
		n001i = 0;
		n001l = 0;
		n001O = 0;
		n00ii = 0;
		n00il = 0;
		n01Ol = 0;
		n01OO = 0;
		nl1ll = 0;
	end
	always @ ( posedge fifo_rd_clk or posedge wire_nl00i_dataout)
	begin
		if (wire_nl00i_dataout == 1'b1) 
		begin
			n000i <= 0;
			n000l <= 0;
			n000O <= 0;
			n001i <= 0;
			n001l <= 0;
			n001O <= 0;
			n00ii <= 0;
			n00il <= 0;
			n01Ol <= 0;
			n01OO <= 0;
			nl1ll <= 0;
		end
		else 
		begin
			n000i <= n000l;
			n000l <= nl0O0i;
			n000O <= ((n00il ^ n00ii) ^ (~ nl0iii38));
			n001i <= nl0O0i;
			n001l <= wire_n00ll_dataout;
			n001O <= wire_n00Ol_dataout;
			n00ii <= n00il;
			n00il <= nl1ll;
			n01Ol <= wire_n00iO_dataout;
			n01OO <= n001i;
			nl1ll <= pld_rd_dis;
		end
	end
	assign		wire_n00i_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[8] : wire_niiO_dataout;
	assign		wire_n00iO_dataout = (((~ n01Ol) & (((~ wire_nli11i_rptr_bin[0]) & (~ wire_nli11i_rptr_bin[1])) & (~ wire_nli11i_rptr_bin[2]))) === 1'b1) ? wire_n00ll_dataout : wire_n00li_dataout;
	assign		wire_n00l_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[9] : wire_nili_dataout;
	and(wire_n00li_dataout, n01Ol, n01OO);
	assign		wire_n00ll_dataout = (rphfifo_master_sel_tx === 1'b1) ? wire_n00lO_dataout : rd_enable_q0_ch0;
	assign		wire_n00lO_dataout = (indv === 1'b1) ? n001O : rd_enable_ch0;
	assign		wire_n00O_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[10] : wire_nill_dataout;
	assign		wire_n00Ol_dataout = (rtxphfifopldctl_en === 1'b1) ? ((n000i & (~ n000O)) & nl0iiO35) : n000i;
	assign		wire_n01i_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[5] : wire_ni0O_dataout;
	assign		wire_n01l_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[6] : wire_niii_dataout;
	assign		wire_n01ll_dataout = (rtx_pipe_enable === 1'b1) ? wire_nl10i_dataout : wire_ni1Ol_dataout;
	assign		wire_n01O_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[7] : wire_niil_dataout;
	assign		wire_n0i_dataout = (nl0Oll === 1'b1) ? txd_redun[13] : txd[13];
	or(wire_n0i0i_dataout, wire_n0lii_dataout, nl0lOl);
	or(wire_n0i0l_dataout, wire_n0lil_dataout, nl0lOl);
	or(wire_n0i0O_dataout, wire_n0liO_dataout, nl0lOl);
	and(wire_n0i1l_dataout, wire_n0l0l_dataout, ~{nl0lOl});
	or(wire_n0i1O_dataout, wire_n0l0O_dataout, nl0lOl);
	assign		wire_n0ii_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[11] : wire_nilO_dataout;
	or(wire_n0iii_dataout, wire_n0lli_dataout, nl0lOl);
	or(wire_n0iil_dataout, wire_n0lll_dataout, nl0lOl);
	or(wire_n0iiO_dataout, wire_n0llO_dataout, nl0lOl);
	assign		wire_n0il_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[12] : wire_niOi_dataout;
	and(wire_n0ili_dataout, wire_n0lOi_dataout, ~{nl0lOl});
	or(wire_n0ill_dataout, wire_n0lOl_dataout, nl0lOl);
	or(wire_n0ilO_dataout, wire_n0lOO_dataout, nl0lOl);
	assign		wire_n0iO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[13] : wire_niOl_dataout;
	or(wire_n0iOi_dataout, wire_n0O1i_dataout, nl0lOl);
	or(wire_n0iOl_dataout, wire_n0O1l_dataout, nl0lOl);
	or(wire_n0iOO_dataout, wire_n0O1O_dataout, nl0lOl);
	assign		wire_n0l_dataout = (nl0Oll === 1'b1) ? txd_redun[14] : txd[14];
	and(wire_n0l0i_dataout, wire_n0Oii_dataout, ~{nl0lOl});
	assign		wire_n0l0l_dataout = (nl0lOO === 1'b1) ? n1iOl : (~ indv);
	assign		wire_n0l0O_dataout = (nl0lOO === 1'b1) ? n1iOO : (~ indv);
	or(wire_n0l1i_dataout, wire_n0O0i_dataout, nl0lOl);
	or(wire_n0l1l_dataout, wire_n0O0l_dataout, nl0lOl);
	and(wire_n0l1O_dataout, wire_n0O0O_dataout, ~{nl0lOl});
	assign		wire_n0li_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[14] : wire_niOO_dataout;
	or(wire_n0lii_dataout, n1l1i, ~{nl0lOO});
	assign		wire_n0lil_dataout = (nl0lOO === 1'b1) ? n1l1l : indv;
	assign		wire_n0liO_dataout = (nl0lOO === 1'b1) ? n1l1O : indv;
	assign		wire_n0ll_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[15] : wire_nl1i_dataout;
	assign		wire_n0lli_dataout = (nl0lOO === 1'b1) ? n1l0i : indv;
	and(wire_n0lll_dataout, n1l0l, nl0lOO);
	assign		wire_n0llO_dataout = (nl0lOO === 1'b1) ? n1l0O : indv;
	assign		wire_n0lO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[16] : wire_nl1l_dataout;
	assign		wire_n0lOi_dataout = (nl0lOO === 1'b1) ? n1liO : (~ indv);
	assign		wire_n0lOl_dataout = (nl0lOO === 1'b1) ? n1lli : (~ indv);
	or(wire_n0lOO_dataout, n1lll, ~{nl0lOO});
	assign		wire_n0O_dataout = (nl0Oll === 1'b1) ? txd_redun[15] : txd[15];
	and(wire_n0O0i_dataout, n1lOO, nl0lOO);
	assign		wire_n0O0l_dataout = (nl0lOO === 1'b1) ? n1O1i : indv;
	and(wire_n0O0O_dataout, wire_nl_dataout, nl0lOO);
	assign		wire_n0O1i_dataout = (nl0lOO === 1'b1) ? n1llO : indv;
	assign		wire_n0O1l_dataout = (nl0lOO === 1'b1) ? n1lOi : indv;
	assign		wire_n0O1O_dataout = (nl0lOO === 1'b1) ? n1lOl : indv;
	assign		wire_n0Oi_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[17] : wire_nl1O_dataout;
	and(wire_n0Oii_dataout, wire_nO_dataout, nl0lOO);
	assign		wire_n0Ol_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[18] : wire_nl0i_dataout;
	assign		wire_n0OO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[19] : wire_nl0l_dataout;
	assign		wire_n0OOi_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[0] : wire_ni01i_dataout;
	assign		wire_n0OOl_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[1] : wire_ni01l_dataout;
	assign		wire_n0OOO_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[2] : wire_ni01O_dataout;
	assign		wire_n10i_dataout = (nl0Oil === 1'b1) ? txd_redun[34] : txd[34];
	assign		wire_n10l_dataout = (nl0Oil === 1'b1) ? txd_redun[35] : txd[35];
	assign		wire_n10O_dataout = (nl0Oil === 1'b1) ? txd_redun[36] : txd[36];
	assign		wire_n11i_dataout = (nl0Oil === 1'b1) ? txd_redun[31] : txd[31];
	assign		wire_n11l_dataout = (nl0Oil === 1'b1) ? txd_redun[32] : txd[32];
	assign		wire_n11O_dataout = (nl0Oil === 1'b1) ? txd_redun[33] : txd[33];
	assign		wire_n1i_dataout = (nl0Oll === 1'b1) ? txd_redun[10] : txd[10];
	assign		wire_n1i0i_dataout = (rphfifo_master_sel_tx === 1'b1) ? wire_n1i0l_dataout : (~ fifo_select_in_q0_ch0);
	assign		wire_n1i0l_dataout = (indv === 1'b1) ? (~ n10OO) : (~ fifo_select_in_ch0);
	and(wire_n1i0O_dataout, wire_n1iii_dataout, n1i1i);
	and(wire_n1i1O_dataout, wire_n1i0i_dataout, n1iil);
	assign		wire_n1ii_dataout = (nl0Oil === 1'b1) ? txd_redun[37] : txd[37];
	assign		wire_n1iii_dataout = (n1iil === 1'b1) ? n1iil : n001l;
	assign		wire_n1il_dataout = (nl0Oil === 1'b1) ? txd_redun[38] : txd[38];
	assign		wire_n1iO_dataout = (nl0Oil === 1'b1) ? txd_redun[39] : txd[39];
	assign		wire_n1l_dataout = (nl0Oll === 1'b1) ? txd_redun[11] : txd[11];
	assign		wire_n1ll_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[0] : wire_ni1i_dataout;
	assign		wire_n1lO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[1] : wire_ni1l_dataout;
	assign		wire_n1O_dataout = (nl0Oll === 1'b1) ? txd_redun[12] : txd[12];
	assign		wire_n1Oi_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[2] : wire_ni1O_dataout;
	assign		wire_n1Ol_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[3] : wire_ni0i_dataout;
	assign		wire_n1OO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[4] : wire_ni0l_dataout;
	and(wire_ni_dataout, txd_extend[1], rforce_disp);
	assign		wire_ni00i_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[25] : wire_niiii_dataout;
	assign		wire_ni00l_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[26] : wire_niiil_dataout;
	assign		wire_ni00O_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[27] : wire_niiiO_dataout;
	assign		wire_ni01i_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[22] : wire_nii0i_dataout;
	assign		wire_ni01l_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[23] : wire_nii0l_dataout;
	assign		wire_ni01O_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[24] : wire_nii0O_dataout;
	assign		wire_ni0i_dataout = (selftest_en === 1'b1) ? tx_data_sg[3] : wire_nliO_dataout;
	assign		wire_ni0ii_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[28] : wire_niili_dataout;
	assign		wire_ni0il_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[29] : wire_niill_dataout;
	assign		wire_ni0iO_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[32] : wire_niilO_dataout;
	assign		wire_ni0l_dataout = (selftest_en === 1'b1) ? tx_data_sg[4] : wire_nlli_dataout;
	assign		wire_ni0li_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[33] : wire_niiOi_dataout;
	assign		wire_ni0ll_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[34] : wire_niiOl_dataout;
	assign		wire_ni0lO_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[35] : wire_niiOO_dataout;
	assign		wire_ni0O_dataout = (selftest_en === 1'b1) ? tx_data_sg[5] : wire_nlll_dataout;
	assign		wire_ni0Oi_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[36] : wire_nil1i_dataout;
	assign		wire_ni0Ol_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[37] : wire_nil1l_dataout;
	assign		wire_ni0OO_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[38] : wire_nil1O_dataout;
	assign		wire_ni10i_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[6] : wire_ni0ii_dataout;
	assign		wire_ni10l_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[7] : wire_ni0il_dataout;
	assign		wire_ni10O_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[10] : wire_ni0iO_dataout;
	assign		wire_ni11i_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[3] : wire_ni00i_dataout;
	assign		wire_ni11l_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[4] : wire_ni00l_dataout;
	assign		wire_ni11O_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[5] : wire_ni00O_dataout;
	assign		wire_ni1i_dataout = (selftest_en === 1'b1) ? tx_data_sg[0] : wire_nl0O_dataout;
	assign		wire_ni1ii_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[11] : wire_ni0li_dataout;
	assign		wire_ni1il_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[12] : wire_ni0ll_dataout;
	assign		wire_ni1iO_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[13] : wire_ni0lO_dataout;
	assign		wire_ni1l_dataout = (selftest_en === 1'b1) ? tx_data_sg[1] : wire_nlii_dataout;
	assign		wire_ni1li_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[14] : wire_ni0Oi_dataout;
	assign		wire_ni1ll_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[15] : wire_ni0Ol_dataout;
	assign		wire_ni1lO_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[16] : wire_ni0OO_dataout;
	assign		wire_ni1O_dataout = (selftest_en === 1'b1) ? tx_data_sg[2] : wire_nlil_dataout;
	assign		wire_ni1Oi_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[17] : wire_nii1i_dataout;
	assign		wire_ni1Ol_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[20] : wire_nii1l_dataout;
	assign		wire_ni1OO_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[21] : wire_nii1O_dataout;
	assign		wire_nii_dataout = (nl0Oll === 1'b1) ? txd_redun[16] : txd[16];
	assign		wire_nii0i_dataout = (nl0O1O === 1'b1) ? wire_n1ll_dataout : wire_n0i1l_dataout;
	assign		wire_nii0l_dataout = (nl0O1O === 1'b1) ? wire_n1lO_dataout : wire_n0i1O_dataout;
	assign		wire_nii0O_dataout = (nl0O1O === 1'b1) ? wire_n1Oi_dataout : wire_n0i0i_dataout;
	assign		wire_nii1i_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[39] : wire_nil0i_dataout;
	assign		wire_nii1l_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[42] : wire_nil0l_dataout;
	assign		wire_nii1O_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[43] : wire_nil0O_dataout;
	assign		wire_niii_dataout = (selftest_en === 1'b1) ? tx_data_sg[6] : wire_nllO_dataout;
	assign		wire_niiii_dataout = (nl0O1O === 1'b1) ? wire_n1Ol_dataout : wire_n0i0l_dataout;
	assign		wire_niiil_dataout = (nl0O1O === 1'b1) ? wire_n1OO_dataout : wire_n0i0O_dataout;
	assign		wire_niiiO_dataout = (nl0O1O === 1'b1) ? wire_n01i_dataout : wire_n0iii_dataout;
	assign		wire_niil_dataout = (selftest_en === 1'b1) ? tx_data_sg[7] : wire_nlOi_dataout;
	assign		wire_niili_dataout = (nl0O1O === 1'b1) ? wire_n01l_dataout : wire_n0iil_dataout;
	assign		wire_niill_dataout = (nl0O1O === 1'b1) ? wire_n01O_dataout : wire_n0iiO_dataout;
	assign		wire_niilO_dataout = (nl0O1O === 1'b1) ? wire_n00O_dataout : wire_n0ili_dataout;
	assign		wire_niiO_dataout = (selftest_en === 1'b1) ? tx_control_sg[0] : wire_nlOl_dataout;
	assign		wire_niiOi_dataout = (nl0O1O === 1'b1) ? wire_n0ii_dataout : wire_n0ill_dataout;
	assign		wire_niiOl_dataout = (nl0O1O === 1'b1) ? wire_n0il_dataout : wire_n0ilO_dataout;
	assign		wire_niiOO_dataout = (nl0O1O === 1'b1) ? wire_n0iO_dataout : wire_n0iOi_dataout;
	assign		wire_nil_dataout = (nl0Oll === 1'b1) ? txd_redun[17] : txd[17];
	assign		wire_nil0i_dataout = (nl0O1O === 1'b1) ? wire_n0Oi_dataout : wire_n0l1l_dataout;
	assign		wire_nil0l_dataout = (nl0O1O === 1'b1) ? wire_nlO_dataout : wire_n0l1O_dataout;
	assign		wire_nil0O_dataout = (nl0O1O === 1'b1) ? wire_ni_dataout : wire_n0l0i_dataout;
	assign		wire_nil1i_dataout = (nl0O1O === 1'b1) ? wire_n0li_dataout : wire_n0iOl_dataout;
	assign		wire_nil1l_dataout = (nl0O1O === 1'b1) ? wire_n0ll_dataout : wire_n0iOO_dataout;
	assign		wire_nil1O_dataout = (nl0O1O === 1'b1) ? wire_n0lO_dataout : wire_n0l1i_dataout;
	and(wire_nili_dataout, wire_nlOO_dataout, ~{selftest_en});
	assign		wire_nill_dataout = (selftest_en === 1'b1) ? tx_data_sg[8] : wire_n1i_dataout;
	assign		wire_nilO_dataout = (selftest_en === 1'b1) ? tx_data_sg[9] : wire_n1l_dataout;
	assign		wire_niO_dataout = (nl0Oll === 1'b1) ? txd_redun[18] : txd[18];
	or(wire_niO0l_dataout, wire_niOii_dataout, nl0lOl);
	or(wire_niO0O_dataout, wire_niOil_dataout, nl0lOl);
	assign		wire_niOi_dataout = (selftest_en === 1'b1) ? tx_data_sg[10] : wire_n1O_dataout;
	or(wire_niOii_dataout, n1lii, ~{nl0lOO});
	or(wire_niOil_dataout, n1O1l, ~{nl0lOO});
	assign		wire_niOiO_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[8] : wire_niOll_dataout;
	assign		wire_niOl_dataout = (selftest_en === 1'b1) ? tx_data_sg[11] : wire_n0i_dataout;
	assign		wire_niOli_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[18] : wire_niOlO_dataout;
	assign		wire_niOll_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[30] : wire_niOOi_dataout;
	assign		wire_niOlO_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[40] : wire_niOOl_dataout;
	assign		wire_niOO_dataout = (selftest_en === 1'b1) ? tx_data_sg[12] : wire_n0l_dataout;
	assign		wire_niOOi_dataout = (nl0O1O === 1'b1) ? wire_n00i_dataout : wire_niO0l_dataout;
	assign		wire_niOOl_dataout = (nl0O1O === 1'b1) ? wire_n0Ol_dataout : wire_niO0O_dataout;
	and(wire_niOOO_dataout, wire_nl11l_dataout, ~{nl0lOl});
	and(wire_nl_dataout, txd_extend[2], rforce_disp);
	and(wire_nl00i_dataout, n10iO, ~{scan_mode});
	assign		wire_nl01i_dataout = (indv === 1'b1) ? nl1Oi : wr_enable_ch0;
	assign		wire_nl01l_dataout = (rtxphfifopldctl_en === 1'b1) ? (nl1Ol & pld_we) : nl1Ol;
	assign		wire_nl0i_dataout = (selftest_en === 1'b1) ? tx_control_sg[1] : wire_niO_dataout;
	and(wire_nl0ii_dataout, n10lO, ~{scan_mode});
	and(wire_nl0l_dataout, wire_nli_dataout, ~{selftest_en});
	assign		wire_nl0li_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[20] : wire_nliOO_dataout;
	assign		wire_nl0ll_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[21] : wire_nll1i_dataout;
	assign		wire_nl0lO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[22] : wire_nll1l_dataout;
	assign		wire_nl0O_dataout = (nl0Oll === 1'b1) ? txd_redun[0] : txd[0];
	assign		wire_nl0Oi_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[23] : wire_nll1O_dataout;
	assign		wire_nl0Ol_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[24] : wire_nll0i_dataout;
	assign		wire_nl0OO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[25] : wire_nll0l_dataout;
	assign		wire_nl10i_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[9] : wire_nl10O_dataout;
	assign		wire_nl10l_dataout = (nl0O1i === 1'b1) ? wire_nli11i_data_out[19] : wire_nl1ii_dataout;
	assign		wire_nl10O_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[31] : wire_nl1il_dataout;
	and(wire_nl11i_dataout, wire_nl11O_dataout, ~{nl0lOl});
	and(wire_nl11l_dataout, n1lil, nl0lOO);
	and(wire_nl11O_dataout, n1O0i, nl0lOO);
	assign		wire_nl1i_dataout = (selftest_en === 1'b1) ? tx_data_sg[13] : wire_n0O_dataout;
	assign		wire_nl1ii_dataout = (nl0O1l === 1'b1) ? wire_nli11i_data_out[41] : wire_nl1iO_dataout;
	assign		wire_nl1il_dataout = (nl0O1O === 1'b1) ? wire_n00l_dataout : wire_niOOO_dataout;
	assign		wire_nl1iO_dataout = (nl0O1O === 1'b1) ? wire_n0OO_dataout : wire_nl11i_dataout;
	assign		wire_nl1l_dataout = (selftest_en === 1'b1) ? tx_data_sg[14] : wire_nii_dataout;
	assign		wire_nl1O_dataout = (selftest_en === 1'b1) ? tx_data_sg[15] : wire_nil_dataout;
	assign		wire_nl1OO_dataout = (rphfifo_master_sel_tx === 1'b1) ? wire_nl01i_dataout : wr_enable_q0_ch0;
	assign		wire_nli_dataout = (nl0Oll === 1'b1) ? txd_redun[19] : txd[19];
	assign		wire_nli0i_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[29] : wire_nlliO_dataout;
	assign		wire_nli0l_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[30] : wire_nllli_dataout;
	assign		wire_nli0O_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[31] : wire_nllll_dataout;
	assign		wire_nli1i_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[26] : wire_nll0O_dataout;
	assign		wire_nli1l_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[27] : wire_nllii_dataout;
	assign		wire_nli1O_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[28] : wire_nllil_dataout;
	assign		wire_nlii_dataout = (nl0Oll === 1'b1) ? txd_redun[1] : txd[1];
	assign		wire_nliii_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[32] : wire_nlllO_dataout;
	assign		wire_nliil_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[33] : wire_nllOi_dataout;
	assign		wire_nliiO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[34] : wire_nllOl_dataout;
	assign		wire_nlil_dataout = (nl0Oll === 1'b1) ? txd_redun[2] : txd[2];
	assign		wire_nlili_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[35] : wire_nllOO_dataout;
	assign		wire_nlill_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[36] : wire_nlO1i_dataout;
	assign		wire_nlilO_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[37] : wire_nlO1l_dataout;
	assign		wire_nliO_dataout = (nl0Oll === 1'b1) ? txd_redun[3] : txd[3];
	assign		wire_nliOi_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[38] : wire_nlO1O_dataout;
	assign		wire_nliOl_dataout = (p_rlpbk === 1'b1) ? rxd_lpbk[39] : wire_nlO0i_dataout;
	assign		wire_nliOO_dataout = (selftest_en === 1'b1) ? tx_data_sg[8] : wire_nlO0l_dataout;
	assign		wire_nll0i_dataout = (selftest_en === 1'b1) ? tx_data_sg[12] : wire_nlOiO_dataout;
	assign		wire_nll0l_dataout = (selftest_en === 1'b1) ? tx_data_sg[13] : wire_nlOli_dataout;
	assign		wire_nll0O_dataout = (selftest_en === 1'b1) ? tx_data_sg[14] : wire_nlOll_dataout;
	assign		wire_nll1i_dataout = (selftest_en === 1'b1) ? tx_data_sg[9] : wire_nlO0O_dataout;
	assign		wire_nll1l_dataout = (selftest_en === 1'b1) ? tx_data_sg[10] : wire_nlOii_dataout;
	assign		wire_nll1O_dataout = (selftest_en === 1'b1) ? tx_data_sg[11] : wire_nlOil_dataout;
	assign		wire_nlli_dataout = (nl0Oll === 1'b1) ? txd_redun[4] : txd[4];
	assign		wire_nllii_dataout = (selftest_en === 1'b1) ? tx_data_sg[15] : wire_nlOlO_dataout;
	assign		wire_nllil_dataout = (selftest_en === 1'b1) ? tx_control_sg[1] : wire_nlOOi_dataout;
	and(wire_nlliO_dataout, wire_nlOOl_dataout, ~{selftest_en});
	assign		wire_nlll_dataout = (nl0Oll === 1'b1) ? txd_redun[5] : txd[5];
	assign		wire_nllli_dataout = (selftest_en === 1'b1) ? tx_data_sg[24] : wire_nlOOO_dataout;
	assign		wire_nllll_dataout = (selftest_en === 1'b1) ? tx_data_sg[25] : wire_n11i_dataout;
	assign		wire_nlllO_dataout = (selftest_en === 1'b1) ? tx_data_sg[26] : wire_n11l_dataout;
	assign		wire_nllO_dataout = (nl0Oll === 1'b1) ? txd_redun[6] : txd[6];
	assign		wire_nllOi_dataout = (selftest_en === 1'b1) ? tx_data_sg[27] : wire_n11O_dataout;
	assign		wire_nllOl_dataout = (selftest_en === 1'b1) ? tx_data_sg[28] : wire_n10i_dataout;
	assign		wire_nllOO_dataout = (selftest_en === 1'b1) ? tx_data_sg[29] : wire_n10l_dataout;
	and(wire_nlO_dataout, txd_extend[0], rforce_disp);
	and(wire_nlO0i_dataout, wire_n1iO_dataout, ~{selftest_en});
	assign		wire_nlO0l_dataout = (nl0Oil === 1'b1) ? txd_redun[20] : txd[20];
	assign		wire_nlO0O_dataout = (nl0Oil === 1'b1) ? txd_redun[21] : txd[21];
	assign		wire_nlO1i_dataout = (selftest_en === 1'b1) ? tx_data_sg[30] : wire_n10O_dataout;
	assign		wire_nlO1l_dataout = (selftest_en === 1'b1) ? tx_data_sg[31] : wire_n1ii_dataout;
	assign		wire_nlO1O_dataout = (selftest_en === 1'b1) ? tx_control_sg[3] : wire_n1il_dataout;
	assign		wire_nlOi_dataout = (nl0Oll === 1'b1) ? txd_redun[7] : txd[7];
	assign		wire_nlOii_dataout = (nl0Oil === 1'b1) ? txd_redun[22] : txd[22];
	assign		wire_nlOil_dataout = (nl0Oil === 1'b1) ? txd_redun[23] : txd[23];
	assign		wire_nlOiO_dataout = (nl0Oil === 1'b1) ? txd_redun[24] : txd[24];
	assign		wire_nlOl_dataout = (nl0Oll === 1'b1) ? txd_redun[8] : txd[8];
	assign		wire_nlOli_dataout = (nl0Oil === 1'b1) ? txd_redun[25] : txd[25];
	assign		wire_nlOll_dataout = (nl0Oil === 1'b1) ? txd_redun[26] : txd[26];
	assign		wire_nlOlO_dataout = (nl0Oil === 1'b1) ? txd_redun[27] : txd[27];
	assign		wire_nlOO_dataout = (nl0Oll === 1'b1) ? txd_redun[9] : txd[9];
	assign		wire_nlOOi_dataout = (nl0Oil === 1'b1) ? txd_redun[28] : txd[28];
	assign		wire_nlOOl_dataout = (nl0Oil === 1'b1) ? txd_redun[29] : txd[29];
	assign		wire_nlOOO_dataout = (nl0Oil === 1'b1) ? txd_redun[30] : txd[30];
	and(wire_nO_dataout, txd_extend[3], rforce_disp);
	tx_ph_fifo   nli11i
	( 
	.bypass_en(txfifo_dis),
	.data_out(wire_nli11i_data_out),
	.din({wire_nO_dataout, wire_nl_dataout, wire_nliOl_dataout, wire_nliOi_dataout, wire_nlilO_dataout, wire_nlill_dataout, wire_nlili_dataout, wire_nliiO_dataout, wire_nliil_dataout, wire_nliii_dataout, wire_nli0O_dataout, wire_nli0l_dataout, wire_nli0i_dataout, wire_nli1O_dataout, wire_nli1l_dataout, wire_nli1i_dataout, wire_nl0OO_dataout, wire_nl0Ol_dataout, wire_nl0Oi_dataout, wire_nl0lO_dataout, wire_nl0ll_dataout, wire_nl0li_dataout, wire_ni_dataout, wire_nlO_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout, wire_n0lO_dataout, wire_n0ll_dataout, wire_n0li_dataout, wire_n0iO_dataout, wire_n0il_dataout, wire_n0ii_dataout, wire_n00O_dataout, wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout, wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout, wire_n1ll_dataout}),
	.lowlatency_en(rtxfifo_lowlatency_en),
	.ph_fifo_empty(wire_nli11i_ph_fifo_empty),
	.ph_fifo_full(wire_nli11i_ph_fifo_full),
	.rd_clk(fifo_rd_clk),
	.re(n001l),
	.rptr_bin(wire_nli11i_rptr_bin),
	.rst_rclk(wire_nl00i_dataout),
	.rst_wclk(wire_nl0ii_dataout),
	.we(nl1lO),
	.wptr_bin(wire_nli11i_wptr_bin),
	.wr_clk(fifo_wr_clk));
	assign
		d21_5_eq_n = {n10il, n100O},
		d2_2_eq_n = {n100l, n100i},
		fifo_select_out = n10OO,
		k_det = {n1ill, n1ili},
		nl00OO = ((((((((((~ wire_n0OOi_dataout) & wire_n0OOl_dataout) & (~ wire_n0OOO_dataout)) & (~ wire_ni11i_dataout)) & (~ wire_ni11l_dataout)) & (~ wire_ni11O_dataout)) & wire_ni10i_dataout) & (~ wire_ni10l_dataout)) & (~ wire_niOiO_dataout)) & nl00ll44),
		nl0i0i = 1'b0,
		nl0i0l = (((((((((~ wire_n0OOi_dataout) & (~ wire_n0OOl_dataout)) & wire_n0OOO_dataout) & wire_ni11i_dataout) & wire_ni11l_dataout) & wire_ni11O_dataout) & (~ wire_ni10i_dataout)) & wire_ni10l_dataout) & wire_niOiO_dataout),
		nl0i0O = ((((((((((~ wire_ni10O_dataout) & (~ wire_ni1ii_dataout)) & wire_ni1il_dataout) & wire_ni1iO_dataout) & wire_ni1li_dataout) & wire_ni1ll_dataout) & (~ wire_ni1lO_dataout)) & wire_ni1Oi_dataout) & wire_niOli_dataout) & nl00ii50),
		nl0i1i = ((((((((((~ wire_ni10O_dataout) & wire_ni1ii_dataout) & (~ wire_ni1il_dataout)) & (~ wire_ni1iO_dataout)) & (~ wire_ni1li_dataout)) & (~ wire_ni1ll_dataout)) & wire_ni1lO_dataout) & (~ wire_ni1Oi_dataout)) & (~ wire_niOli_dataout)) & nl00iO47),
		nl0i1l = ((((((((wire_n0OOi_dataout & (~ wire_n0OOl_dataout)) & wire_n0OOO_dataout) & (~ wire_ni11i_dataout)) & wire_ni11l_dataout) & wire_ni11O_dataout) & (~ wire_ni10i_dataout)) & wire_ni10l_dataout) & (~ wire_niOiO_dataout)),
		nl0i1O = (((((((((wire_ni10O_dataout & (~ wire_ni1ii_dataout)) & wire_ni1il_dataout) & (~ wire_ni1iO_dataout)) & wire_ni1li_dataout) & wire_ni1ll_dataout) & (~ wire_ni1lO_dataout)) & wire_ni1Oi_dataout) & (~ wire_niOli_dataout)) & nl00Oi41),
		nl0l0i = (((~ n10OO) & dwidth) & nl0l0l20),
		nl0lOi = (n01Ol & (~ txfifo_dis)),
		nl0lOl = (((~ rforce_kchar) & rforce_echar) & nl0iOi29),
		nl0lOO = ((((n10OO & (txfifo_dis & dwidth)) & (~ rforce_kchar)) & (~ rforce_echar)) & nl0ill32),
		nl0O0i = 1'b1,
		nl0O0l = ((soft_reset | (rtxfifo_urst_en & txfifo_urst)) | (~ nl0O0O8)),
		nl0O1i = (((~ rforce_echar) & (((~ rforce_kchar) & ((nl0lOi & (n10OO | (~ dwidth))) & nl0lll11)) & nl0liO14)) & nl0lii17),
		nl0O1l = ((~ rforce_echar) & ((~ rforce_kchar) & (nl0lOi & nl0l0i))),
		nl0O1O = (((~ rforce_echar) & ((~ rforce_kchar) & (txfifo_dis & (((~ n10OO) | (~ dwidth)) | (~ nl0l1l23))))) & nl0iOO26),
		nl0Oil = ((((redund_ctl[3] | redund_ctl[2]) | redund_ctl[1]) | redund_ctl[0]) | (~ nl0OiO5)),
		nl0Oll = ((((redund_ctl[3] | redund_ctl[2]) | redund_ctl[1]) | redund_ctl[0]) | (~ nl0OlO2)),
		ph_fifo_empty = wire_nli11i_ph_fifo_empty,
		ph_fifo_full = wire_nli11i_ph_fifo_full,
		pipe_electric_idle = n1iiO,
		rd_enable2 = n001l,
		rd_enable_out = n001O,
		rd_enable_sync = n01Ol,
		rptr_bin = {wire_nli11i_rptr_bin[2:0]},
		soft_reset_wclk1 = wire_nl0ii_dataout,
		tx_ctl_tc = {n01iO, n01il},
		tx_data_9_tc = {n01Oi, n01li},
		tx_data_tc = {n01ii, n010O, n010l, n010i, n011O, n011l, n011i, n1OOO, n1OOl, n1OOi, n1OlO, n1Oll, n1Oli, n1OiO, n1Oil, n1Oii},
		txd_extend_tc = {n1O0O, n1O0l},
		wptr_bin = {wire_nli11i_wptr_bin[2:0]},
		wr_enable2 = nl1lO,
		wr_enable_out = nl1Oi;
endmodule //stratixiigx_hssi_tx_ctrl
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 225 mux21 443 oper_add 10 oper_selector 88 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_tx_bist_gen
	( 
	bist_ctl_sg,
	bist_data_sg,
	rbist_sel,
	rbisten_tx,
	rcxpat_chnl_sel,
	rdwidth_tx,
	rpma_doublewidth_tx,
	rpmadwidth_tx,
	soft_reset,
	tx_clk) /* synthesis synthesis_clearbox=1 */;
	output   [1:0]  bist_ctl_sg;
	output   [15:0]  bist_data_sg;
	input   [1:0]  rbist_sel;
	input   rbisten_tx;
	input   [1:0]  rcxpat_chnl_sel;
	input   rdwidth_tx;
	input   rpma_doublewidth_tx;
	input   rpmadwidth_tx;
	input   soft_reset;
	input   tx_clk;

	reg	nii00O49;
	reg	nii00O50;
	reg	nii00O51;
	reg	nii01l52;
	reg	nii01l53;
	reg	nii01l54;
	reg	nii0iO46;
	reg	nii0iO47;
	reg	nii0iO48;
	reg	nii0li43;
	reg	nii0li44;
	reg	nii0li45;
	reg	nii0lO40;
	reg	nii0lO41;
	reg	nii0lO42;
	reg	nii0Oi37;
	reg	nii0Oi38;
	reg	nii0Oi39;
	reg	nii0Ol34;
	reg	nii0Ol35;
	reg	nii0Ol36;
	reg	nii0OO31;
	reg	nii0OO32;
	reg	nii0OO33;
	reg	nii1lO58;
	reg	nii1lO59;
	reg	nii1lO60;
	reg	nii1Ol55;
	reg	nii1Ol56;
	reg	nii1Ol57;
	reg	niii0O28;
	reg	niii0O29;
	reg	niii0O30;
	reg	niiill25;
	reg	niiill26;
	reg	niiill27;
	reg	niilli22;
	reg	niilli23;
	reg	niilli24;
	reg	niilll19;
	reg	niilll20;
	reg	niilll21;
	reg	niillO16;
	reg	niillO17;
	reg	niillO18;
	reg	niilOl13;
	reg	niilOl14;
	reg	niilOl15;
	reg	niiO0O7;
	reg	niiO0O8;
	reg	niiO0O9;
	reg	niiO1i10;
	reg	niiO1i11;
	reg	niiO1i12;
	reg	niiOiO4;
	reg	niiOiO5;
	reg	niiOiO6;
	reg	niiOll1;
	reg	niiOll2;
	reg	niiOll3;
	reg	n0iii;
	reg	n110l;
	wire	wire_n110i_ENA;
	reg	n11ii;
	wire	wire_n110O_ENA;
	reg	n111O;
	wire	wire_n111l_ENA;
	reg	n100i;
	reg	n100l;
	reg	n100O;
	reg	n101i;
	reg	n101l;
	reg	n101O;
	reg	n10ii;
	reg	n10il;
	reg	n10iO;
	reg	n10li;
	reg	n10ll;
	reg	n10lO;
	reg	n10Oi;
	reg	n10Ol;
	reg	n10OO;
	reg	n111i;
	reg	n11il;
	reg	n11iO;
	reg	n11li;
	reg	n11ll;
	reg	n11lO;
	reg	n11Oi;
	reg	n11Ol;
	reg	n11OO;
	reg	n1i0i;
	reg	n1i0l;
	reg	n1i0O;
	reg	n1i1i;
	reg	n1i1l;
	reg	n1i1O;
	reg	n1iii;
	reg	n1iil;
	reg	n1iiO;
	reg	n1ili;
	reg	n1ill;
	reg	n1ilO;
	reg	n1iOi;
	reg	n1iOl;
	reg	n1iOO;
	reg	n1l0i;
	reg	n1l0l;
	reg	n1l0O;
	reg	n1l1i;
	reg	n1l1l;
	reg	n1l1O;
	reg	n1lii;
	reg	n1lil;
	reg	n1liO;
	reg	n1lll;
	reg	nlOOil;
	reg	nlOOiO;
	reg	nlOOli;
	reg	nlOOll;
	reg	nlOOlO;
	reg	nlOOOi;
	reg	nlOOOl;
	reg	nlOOOO;
	reg	nil10l;
	reg	nil10O;
	reg	nl000O;
	reg	nl00ii;
	reg	nl00il;
	reg	nl00iO;
	reg	nl00li;
	reg	nl00ll;
	reg	nl00lO;
	reg	nl00Oi;
	reg	nl00Ol;
	reg	nl00OO;
	reg	nl0i0i;
	reg	nl0i0l;
	reg	nl0i0O;
	reg	nl0i1i;
	reg	nl0i1l;
	reg	nl0i1O;
	reg	nl0iii;
	reg	nl0iil;
	reg	nl0iiO;
	reg	nl0ili;
	reg	nl0ill;
	reg	nl0ilO;
	reg	nl0iOi;
	reg	nl0iOl;
	reg	nl0iOO;
	reg	nl0l0i;
	reg	nl0l0l;
	reg	nl0l0O;
	reg	nl0l1i;
	reg	nl0l1l;
	reg	nl0l1O;
	reg	nl0lii;
	reg	nl0lil;
	reg	nl0liO;
	reg	nl0lli;
	reg	nl0lll;
	reg	nl0llO;
	reg	nl0lOi;
	reg	nl0lOl;
	reg	nl0lOO;
	reg	nl0O0i;
	reg	nl0O0l;
	reg	nl0O0O;
	reg	nl0O1i;
	reg	nl0O1l;
	reg	nl0O1O;
	reg	nl0Oii;
	reg	nl0Oil;
	reg	nl0OiO;
	reg	nl0Oli;
	reg	nl0Oll;
	reg	nl0OOi;
	reg	niO0O;
	reg	niOii;
	reg	niOil;
	reg	niOiO;
	reg	niOli;
	reg	niOll;
	reg	niOlO;
	reg	niOOi;
	reg	niOOl;
	reg	niOOO;
	reg	nl00i;
	reg	nl00l;
	reg	nl00O;
	reg	nl01i;
	reg	nl01l;
	reg	nl01O;
	reg	nl0ii;
	reg	nl0il;
	reg	nl0iO;
	reg	nl0li;
	reg	nl0ll;
	reg	nl0lO;
	reg	nl0Oi;
	reg	nl0Ol;
	reg	nl0OO;
	reg	nl10i;
	reg	nl10l;
	reg	nl10O;
	reg	nl11i;
	reg	nl11l;
	reg	nl11O;
	reg	nl1ii;
	reg	nl1il;
	reg	nl1iO;
	reg	nl1li;
	reg	nl1ll;
	reg	nl1lO;
	reg	nl1Oi;
	reg	nl1Ol;
	reg	nl1OO;
	reg	nli0i;
	reg	nli0l;
	reg	nli0O;
	reg	nli1i;
	reg	nli1l;
	reg	nli1O;
	reg	nliii;
	reg	nliil;
	reg	nlili;
	reg	nlil0l;
	wire	wire_n000i_dataout;
	wire	wire_n000l_dataout;
	wire	wire_n000O_dataout;
	wire	wire_n001i_dataout;
	wire	wire_n001l_dataout;
	wire	wire_n001O_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00ii_dataout;
	wire	wire_n00il_dataout;
	wire	wire_n00iO_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00li_dataout;
	wire	wire_n00ll_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n011i_dataout;
	wire	wire_n011l_dataout;
	wire	wire_n011O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01ii_dataout;
	wire	wire_n01iO_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01lO_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01Oi_dataout;
	wire	wire_n01Ol_dataout;
	wire	wire_n01OO_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0lOO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O1O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0OlO_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1llO_dataout;
	wire	wire_n1lOi_dataout;
	wire	wire_n1lOl_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1O0i_dataout;
	wire	wire_n1O0l_dataout;
	wire	wire_n1O0O_dataout;
	wire	wire_n1O1i_dataout;
	wire	wire_n1O1l_dataout;
	wire	wire_n1O1O_dataout;
	wire	wire_n1Oii_dataout;
	wire	wire_n1Oil_dataout;
	wire	wire_n1OiO_dataout;
	wire	wire_n1Oli_dataout;
	wire	wire_n1Oll_dataout;
	wire	wire_n1OlO_dataout;
	wire	wire_n1OOO_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0OO_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii1i_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil1i_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nili_dataout;
	wire	wire_nilii_dataout;
	wire	wire_nilil_dataout;
	wire	wire_niliO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilli_dataout;
	wire	wire_nilll_dataout;
	wire	wire_nillO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilOi_dataout;
	wire	wire_nilOl_dataout;
	wire	wire_nilOO_dataout;
	wire	wire_nilOOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO00i_dataout;
	wire	wire_niO00l_dataout;
	wire	wire_niO00O_dataout;
	wire	wire_niO01i_dataout;
	wire	wire_niO01l_dataout;
	wire	wire_niO01O_dataout;
	wire	wire_niO0ii_dataout;
	wire	wire_niO0il_dataout;
	wire	wire_niO0iO_dataout;
	wire	wire_niO0li_dataout;
	wire	wire_niO0ll_dataout;
	wire	wire_niO0lO_dataout;
	wire	wire_niO0Oi_dataout;
	wire	wire_niO0Ol_dataout;
	wire	wire_niO0OO_dataout;
	wire	wire_niO10i_dataout;
	wire	wire_niO10l_dataout;
	wire	wire_niO10O_dataout;
	wire	wire_niO11i_dataout;
	wire	wire_niO11l_dataout;
	wire	wire_niO11O_dataout;
	wire	wire_niO1i_dataout;
	wire	wire_niO1ii_dataout;
	wire	wire_niO1il_dataout;
	wire	wire_niO1iO_dataout;
	wire	wire_niO1l_dataout;
	wire	wire_niO1li_dataout;
	wire	wire_niO1ll_dataout;
	wire	wire_niO1lO_dataout;
	wire	wire_niO1O_dataout;
	wire	wire_niO1Oi_dataout;
	wire	wire_niO1Ol_dataout;
	wire	wire_niO1OO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOi0i_dataout;
	wire	wire_niOi0l_dataout;
	wire	wire_niOi0O_dataout;
	wire	wire_niOi1i_dataout;
	wire	wire_niOi1l_dataout;
	wire	wire_niOi1O_dataout;
	wire	wire_niOiii_dataout;
	wire	wire_niOiil_dataout;
	wire	wire_niOiiO_dataout;
	wire	wire_niOili_dataout;
	wire	wire_niOill_dataout;
	wire	wire_niOilO_dataout;
	wire	wire_niOiOi_dataout;
	wire	wire_niOiOl_dataout;
	wire	wire_niOiOO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOl0i_dataout;
	wire	wire_niOl0l_dataout;
	wire	wire_niOl0O_dataout;
	wire	wire_niOl1i_dataout;
	wire	wire_niOl1l_dataout;
	wire	wire_niOl1O_dataout;
	wire	wire_niOlii_dataout;
	wire	wire_niOlil_dataout;
	wire	wire_niOliO_dataout;
	wire	wire_niOlli_dataout;
	wire	wire_niOlll_dataout;
	wire	wire_niOllO_dataout;
	wire	wire_niOlOi_dataout;
	wire	wire_niOlOl_dataout;
	wire	wire_niOlOO_dataout;
	wire	wire_niOO_dataout;
	wire	wire_niOO0i_dataout;
	wire	wire_niOO0l_dataout;
	wire	wire_niOO0O_dataout;
	wire	wire_niOO1i_dataout;
	wire	wire_niOO1l_dataout;
	wire	wire_niOO1O_dataout;
	wire	wire_niOOii_dataout;
	wire	wire_niOOil_dataout;
	wire	wire_niOOiO_dataout;
	wire	wire_niOOli_dataout;
	wire	wire_niOOll_dataout;
	wire	wire_niOOlO_dataout;
	wire	wire_niOOOi_dataout;
	wire	wire_niOOOl_dataout;
	wire	wire_niOOOO_dataout;
	wire	wire_nl000i_dataout;
	wire	wire_nl000l_dataout;
	wire	wire_nl001i_dataout;
	wire	wire_nl001l_dataout;
	wire	wire_nl001O_dataout;
	wire	wire_nl010i_dataout;
	wire	wire_nl010l_dataout;
	wire	wire_nl010O_dataout;
	wire	wire_nl011i_dataout;
	wire	wire_nl011l_dataout;
	wire	wire_nl011O_dataout;
	wire	wire_nl01ii_dataout;
	wire	wire_nl01il_dataout;
	wire	wire_nl01iO_dataout;
	wire	wire_nl01li_dataout;
	wire	wire_nl01ll_dataout;
	wire	wire_nl01lO_dataout;
	wire	wire_nl01Oi_dataout;
	wire	wire_nl01Ol_dataout;
	wire	wire_nl01OO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl0OOl_dataout;
	wire	wire_nl0OOO_dataout;
	wire	wire_nl100i_dataout;
	wire	wire_nl100l_dataout;
	wire	wire_nl100O_dataout;
	wire	wire_nl101i_dataout;
	wire	wire_nl101l_dataout;
	wire	wire_nl101O_dataout;
	wire	wire_nl10ii_dataout;
	wire	wire_nl10il_dataout;
	wire	wire_nl10iO_dataout;
	wire	wire_nl10li_dataout;
	wire	wire_nl10ll_dataout;
	wire	wire_nl10lO_dataout;
	wire	wire_nl10Oi_dataout;
	wire	wire_nl10Ol_dataout;
	wire	wire_nl10OO_dataout;
	wire	wire_nl110i_dataout;
	wire	wire_nl110l_dataout;
	wire	wire_nl110O_dataout;
	wire	wire_nl111i_dataout;
	wire	wire_nl111l_dataout;
	wire	wire_nl111O_dataout;
	wire	wire_nl11ii_dataout;
	wire	wire_nl11il_dataout;
	wire	wire_nl11iO_dataout;
	wire	wire_nl11li_dataout;
	wire	wire_nl11ll_dataout;
	wire	wire_nl11lO_dataout;
	wire	wire_nl11Oi_dataout;
	wire	wire_nl11Ol_dataout;
	wire	wire_nl11OO_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1i0i_dataout;
	wire	wire_nl1i0l_dataout;
	wire	wire_nl1i0O_dataout;
	wire	wire_nl1i1i_dataout;
	wire	wire_nl1i1l_dataout;
	wire	wire_nl1i1O_dataout;
	wire	wire_nl1iii_dataout;
	wire	wire_nl1iil_dataout;
	wire	wire_nl1iiO_dataout;
	wire	wire_nl1ili_dataout;
	wire	wire_nl1ill_dataout;
	wire	wire_nl1ilO_dataout;
	wire	wire_nl1iOi_dataout;
	wire	wire_nl1iOl_dataout;
	wire	wire_nl1iOO_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1l0i_dataout;
	wire	wire_nl1l0l_dataout;
	wire	wire_nl1l0O_dataout;
	wire	wire_nl1l1i_dataout;
	wire	wire_nl1l1l_dataout;
	wire	wire_nl1l1O_dataout;
	wire	wire_nl1lii_dataout;
	wire	wire_nl1lil_dataout;
	wire	wire_nl1liO_dataout;
	wire	wire_nl1lli_dataout;
	wire	wire_nl1lll_dataout;
	wire	wire_nl1llO_dataout;
	wire	wire_nl1lOi_dataout;
	wire	wire_nl1lOl_dataout;
	wire	wire_nl1lOO_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1O0i_dataout;
	wire	wire_nl1O0l_dataout;
	wire	wire_nl1O0O_dataout;
	wire	wire_nl1O1i_dataout;
	wire	wire_nl1O1l_dataout;
	wire	wire_nl1O1O_dataout;
	wire	wire_nl1Oii_dataout;
	wire	wire_nl1Oil_dataout;
	wire	wire_nl1OiO_dataout;
	wire	wire_nl1Oli_dataout;
	wire	wire_nl1Oll_dataout;
	wire	wire_nl1OlO_dataout;
	wire	wire_nl1OOi_dataout;
	wire	wire_nl1OOl_dataout;
	wire	wire_nl1OOO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli00i_dataout;
	wire	wire_nli00l_dataout;
	wire	wire_nli01i_dataout;
	wire	wire_nli01l_dataout;
	wire	wire_nli01O_dataout;
	wire	wire_nli10i_dataout;
	wire	wire_nli10l_dataout;
	wire	wire_nli10O_dataout;
	wire	wire_nli11i_dataout;
	wire	wire_nli11l_dataout;
	wire	wire_nli11O_dataout;
	wire	wire_nli1ii_dataout;
	wire	wire_nli1il_dataout;
	wire	wire_nli1iO_dataout;
	wire	wire_nli1li_dataout;
	wire	wire_nli1ll_dataout;
	wire	wire_nli1lO_dataout;
	wire	wire_nli1Oi_dataout;
	wire	wire_nli1Ol_dataout;
	wire	wire_nli1OO_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlil0O_dataout;
	wire	wire_nlilii_dataout;
	wire	wire_nlilil_dataout;
	wire	wire_nliliO_dataout;
	wire	wire_nlill_dataout;
	wire	wire_nlilli_dataout;
	wire	wire_nlilll_dataout;
	wire	wire_nlilO_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliOi_dataout;
	wire	wire_nliOll_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nliOOl_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1lO_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nlllii_dataout;
	wire	wire_nlllil_dataout;
	wire	wire_nllliO_dataout;
	wire	wire_nlllli_dataout;
	wire	wire_nlllll_dataout;
	wire	wire_nllllO_dataout;
	wire	wire_nlllOi_dataout;
	wire	wire_nlllOl_dataout;
	wire	wire_nlllOO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllO0i_dataout;
	wire	wire_nllO0l_dataout;
	wire	wire_nllO0O_dataout;
	wire	wire_nllO1i_dataout;
	wire	wire_nllO1l_dataout;
	wire	wire_nllO1O_dataout;
	wire	wire_nllOii_dataout;
	wire	wire_nllOil_dataout;
	wire	wire_nllOiO_dataout;
	wire	wire_nllOli_dataout;
	wire	wire_nllOll_dataout;
	wire	wire_nllOlO_dataout;
	wire	wire_nllOOi_dataout;
	wire	wire_nllOOl_dataout;
	wire	wire_nllOOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO00i_dataout;
	wire	wire_nlO00l_dataout;
	wire	wire_nlO00O_dataout;
	wire	wire_nlO01i_dataout;
	wire	wire_nlO01l_dataout;
	wire	wire_nlO01O_dataout;
	wire	wire_nlO0ii_dataout;
	wire	wire_nlO0il_dataout;
	wire	wire_nlO0iO_dataout;
	wire	wire_nlO0li_dataout;
	wire	wire_nlO0ll_dataout;
	wire	wire_nlO0lO_dataout;
	wire	wire_nlO0Oi_dataout;
	wire	wire_nlO0Ol_dataout;
	wire	wire_nlO0OO_dataout;
	wire	wire_nlO10i_dataout;
	wire	wire_nlO10l_dataout;
	wire	wire_nlO10O_dataout;
	wire	wire_nlO11i_dataout;
	wire	wire_nlO11l_dataout;
	wire	wire_nlO11O_dataout;
	wire	wire_nlO1ii_dataout;
	wire	wire_nlO1il_dataout;
	wire	wire_nlO1iO_dataout;
	wire	wire_nlO1li_dataout;
	wire	wire_nlO1ll_dataout;
	wire	wire_nlO1lO_dataout;
	wire	wire_nlO1Oi_dataout;
	wire	wire_nlO1Ol_dataout;
	wire	wire_nlO1OO_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOi0l_dataout;
	wire	wire_nlOi0O_dataout;
	wire	wire_nlOi1i_dataout;
	wire	wire_nlOi1l_dataout;
	wire	wire_nlOi1O_dataout;
	wire	wire_nlOiii_dataout;
	wire	wire_nlOiil_dataout;
	wire	wire_nlOiiO_dataout;
	wire	wire_nlOili_dataout;
	wire	wire_nlOill_dataout;
	wire	wire_nlOilO_dataout;
	wire	wire_nlOiOi_dataout;
	wire	wire_nlOiOl_dataout;
	wire	wire_nlOiOO_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOl0i_dataout;
	wire	wire_nlOl0l_dataout;
	wire	wire_nlOl0O_dataout;
	wire	wire_nlOl1i_dataout;
	wire	wire_nlOl1l_dataout;
	wire	wire_nlOl1O_dataout;
	wire	wire_nlOlii_dataout;
	wire	wire_nlOlil_dataout;
	wire	wire_nlOliO_dataout;
	wire	wire_nlOlli_dataout;
	wire	wire_nlOlll_dataout;
	wire	wire_nlOllO_dataout;
	wire	wire_nlOlOi_dataout;
	wire	wire_nlOlOl_dataout;
	wire	wire_nlOlOO_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOO0i_dataout;
	wire	wire_nlOO0l_dataout;
	wire	wire_nlOO1i_dataout;
	wire	wire_nlOO1l_dataout;
	wire	wire_nlOO1O_dataout;
	wire  [8:0]   wire_n00lO_o;
	wire  [3:0]   wire_n01il_o;
	wire  [2:0]   wire_n1lOO_o;
	wire  [5:0]   wire_n1OOi_o;
	wire  [2:0]   wire_n1OOl_o;
	wire  [6:0]   wire_nli00O_o;
	wire  [6:0]   wire_nli0ii_o;
	wire  [7:0]   wire_nli0il_o;
	wire  [2:0]   wire_nliOl_o;
	wire  [4:0]   wire_nllli_o;
	wire  wire_n0iil_o;
	wire  wire_n0iiO_o;
	wire  wire_n0ili_o;
	wire  wire_n0iOi_o;
	wire  wire_n0iOO_o;
	wire  wire_n0l0i_o;
	wire  wire_n0l1l_o;
	wire  wire_n0lii_o;
	wire  wire_n0lli_o;
	wire  wire_n0lOi_o;
	wire  wire_n0O0i_o;
	wire  wire_n0O1i_o;
	wire  wire_n0Oii_o;
	wire  wire_n0Oil_o;
	wire  wire_n0OiO_o;
	wire  wire_n0Oli_o;
	wire  wire_n0OOi_o;
	wire  wire_ni00l_o;
	wire  wire_ni01i_o;
	wire  wire_ni01O_o;
	wire  wire_ni0ii_o;
	wire  wire_ni0iO_o;
	wire  wire_ni0ll_o;
	wire  wire_ni0Oi_o;
	wire  wire_ni10i_o;
	wire  wire_ni11l_o;
	wire  wire_ni1Ol_o;
	wire  wire_nil00O_o;
	wire  wire_nil01i_o;
	wire  wire_nil01O_o;
	wire  wire_nil0il_o;
	wire  wire_nil0ll_o;
	wire  wire_nil0Ol_o;
	wire  wire_nil1il_o;
	wire  wire_nil1li_o;
	wire  wire_nil1Oi_o;
	wire  wire_nili0i_o;
	wire  wire_nili0O_o;
	wire  wire_nili1l_o;
	wire  wire_niliil_o;
	wire  wire_nilili_o;
	wire  wire_nililO_o;
	wire  wire_niliOl_o;
	wire  wire_nill0i_o;
	wire  wire_nill0O_o;
	wire  wire_nill1i_o;
	wire  wire_nillii_o;
	wire  wire_nillil_o;
	wire  wire_nillli_o;
	wire  wire_nilllO_o;
	wire  wire_nillOl_o;
	wire  wire_nilO0l_o;
	wire  wire_nilO1i_o;
	wire  wire_nilO1O_o;
	wire  wire_nilOii_o;
	wire  wire_nilOiO_o;
	wire  wire_nilOll_o;
	wire  wire_nilOOi_o;
	wire  wire_nlillO_o;
	wire  wire_nlilOO_o;
	wire  wire_nliO0i_o;
	wire  wire_nliO0O_o;
	wire  wire_nliO1l_o;
	wire  wire_nliOil_o;
	wire  wire_nliOlO_o;
	wire  wire_nliOOO_o;
	wire  wire_nll00l_o;
	wire  wire_nll01l_o;
	wire  wire_nll0il_o;
	wire  wire_nll0ll_o;
	wire  wire_nll0Ol_o;
	wire  wire_nll10l_o;
	wire  wire_nll11i_o;
	wire  wire_nll11l_o;
	wire  wire_nll11O_o;
	wire  wire_nll1ii_o;
	wire  wire_nll1iO_o;
	wire  wire_nll1Oi_o;
	wire  wire_nll1OO_o;
	wire  wire_nlli1O_o;
	wire  wire_nlliii_o;
	wire  wire_nlliiO_o;
	wire  wire_nllill_o;
	wire  wire_nllilO_o;
	wire  wire_nlliOl_o;
	wire  wire_nlll0l_o;
	wire  wire_nlll1i_o;
	wire  wire_nlll1O_o;
	wire  ni000i;
	wire  ni000l;
	wire  ni000O;
	wire  ni001i;
	wire  ni001l;
	wire  ni001O;
	wire  ni00ii;
	wire  ni00il;
	wire  ni00iO;
	wire  ni00li;
	wire  ni00ll;
	wire  ni00lO;
	wire  ni00Oi;
	wire  ni00Ol;
	wire  ni00OO;
	wire  ni010i;
	wire  ni010l;
	wire  ni010O;
	wire  ni011i;
	wire  ni011l;
	wire  ni011O;
	wire  ni01ii;
	wire  ni01il;
	wire  ni01iO;
	wire  ni01li;
	wire  ni01ll;
	wire  ni01lO;
	wire  ni01Oi;
	wire  ni01Ol;
	wire  ni01OO;
	wire  ni0i0i;
	wire  ni0i0l;
	wire  ni0i0O;
	wire  ni0i1i;
	wire  ni0i1l;
	wire  ni0i1O;
	wire  ni0iii;
	wire  ni0iil;
	wire  ni0iiO;
	wire  ni0ili;
	wire  ni0ill;
	wire  ni0ilO;
	wire  ni0iOi;
	wire  ni0iOl;
	wire  ni0iOO;
	wire  ni0l0i;
	wire  ni0l0l;
	wire  ni0l0O;
	wire  ni0l1i;
	wire  ni0l1l;
	wire  ni0l1O;
	wire  ni0lii;
	wire  ni0lil;
	wire  ni0liO;
	wire  ni0lli;
	wire  ni0lll;
	wire  ni0llO;
	wire  ni0lOi;
	wire  ni0lOl;
	wire  ni0lOO;
	wire  ni0O0i;
	wire  ni0O0l;
	wire  ni0O0O;
	wire  ni0O1i;
	wire  ni0O1l;
	wire  ni0O1O;
	wire  ni0Oii;
	wire  ni0Oil;
	wire  ni0OiO;
	wire  ni0Oli;
	wire  ni0Oll;
	wire  ni0OlO;
	wire  ni0OOi;
	wire  ni0OOl;
	wire  ni0OOO;
	wire  ni1liO;
	wire  ni1lli;
	wire  ni1lll;
	wire  ni1llO;
	wire  ni1lOi;
	wire  ni1lOl;
	wire  ni1lOO;
	wire  ni1O0i;
	wire  ni1O0l;
	wire  ni1O0O;
	wire  ni1O1i;
	wire  ni1O1l;
	wire  ni1O1O;
	wire  ni1Oii;
	wire  ni1Oil;
	wire  ni1OiO;
	wire  ni1Oli;
	wire  ni1Oll;
	wire  ni1OlO;
	wire  ni1OOi;
	wire  ni1OOl;
	wire  ni1OOO;
	wire  nii00i;
	wire  nii00l;
	wire  nii01i;
	wire  nii0ii;
	wire  nii0il;
	wire  nii0ll;
	wire  nii10i;
	wire  nii10l;
	wire  nii10O;
	wire  nii11i;
	wire  nii11l;
	wire  nii11O;
	wire  nii1ii;
	wire  nii1il;
	wire  nii1iO;
	wire  nii1li;
	wire  nii1ll;
	wire  nii1OO;
	wire  niii0i;
	wire  niii0l;
	wire  niii1i;
	wire  niii1l;
	wire  niii1O;
	wire  niiiil;
	wire  niiiiO;
	wire  niiili;
	wire  niiiOi;
	wire  niiiOl;
	wire  niiiOO;
	wire  niil0i;
	wire  niil0l;
	wire  niil0O;
	wire  niil1i;
	wire  niil1l;
	wire  niil1O;
	wire  niilii;
	wire  niilil;
	wire  niiliO;
	wire  niiO0i;
	wire  niiO0l;
	wire  niiO1O;
	wire  niiOil;

	initial
		nii00O49 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii00O49 <= nii00O51;
	initial
		nii00O50 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii00O50 <= (nii00O51 ^ nii00O49);
	initial
		nii00O51 = 0;
	always @ ( posedge tx_clk)
		  nii00O51 <= nii00O49;
	initial
		nii01l52 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii01l52 <= nii01l54;
	initial
		nii01l53 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii01l53 <= (nii01l54 ^ nii01l52);
	initial
		nii01l54 = 0;
	always @ ( posedge tx_clk)
		  nii01l54 <= nii01l52;
	initial
		nii0iO46 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii0iO46 <= nii0iO48;
	initial
		nii0iO47 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii0iO47 <= (nii0iO48 ^ nii0iO46);
	initial
		nii0iO48 = 0;
	always @ ( posedge tx_clk)
		  nii0iO48 <= nii0iO46;
	initial
		nii0li43 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii0li43 <= nii0li45;
	initial
		nii0li44 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii0li44 <= (nii0li45 ^ nii0li43);
	initial
		nii0li45 = 0;
	always @ ( posedge tx_clk)
		  nii0li45 <= nii0li43;
	initial
		nii0lO40 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii0lO40 <= nii0lO42;
	initial
		nii0lO41 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii0lO41 <= (nii0lO42 ^ nii0lO40);
	initial
		nii0lO42 = 0;
	always @ ( posedge tx_clk)
		  nii0lO42 <= nii0lO40;
	initial
		nii0Oi37 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii0Oi37 <= nii0Oi39;
	initial
		nii0Oi38 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii0Oi38 <= (nii0Oi39 ^ nii0Oi37);
	initial
		nii0Oi39 = 0;
	always @ ( posedge tx_clk)
		  nii0Oi39 <= nii0Oi37;
	initial
		nii0Ol34 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii0Ol34 <= nii0Ol36;
	initial
		nii0Ol35 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii0Ol35 <= (nii0Ol36 ^ nii0Ol34);
	initial
		nii0Ol36 = 0;
	always @ ( posedge tx_clk)
		  nii0Ol36 <= nii0Ol34;
	initial
		nii0OO31 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii0OO31 <= nii0OO33;
	initial
		nii0OO32 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii0OO32 <= (nii0OO33 ^ nii0OO31);
	initial
		nii0OO33 = 0;
	always @ ( posedge tx_clk)
		  nii0OO33 <= nii0OO31;
	initial
		nii1lO58 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii1lO58 <= nii1lO60;
	initial
		nii1lO59 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii1lO59 <= (nii1lO60 ^ nii1lO58);
	initial
		nii1lO60 = 0;
	always @ ( posedge tx_clk)
		  nii1lO60 <= nii1lO58;
	initial
		nii1Ol55 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii1Ol55 <= nii1Ol57;
	initial
		nii1Ol56 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nii1Ol56 <= (nii1Ol57 ^ nii1Ol55);
	initial
		nii1Ol57 = 0;
	always @ ( posedge tx_clk)
		  nii1Ol57 <= nii1Ol55;
	initial
		niii0O28 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niii0O28 <= niii0O30;
	initial
		niii0O29 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niii0O29 <= (niii0O30 ^ niii0O28);
	initial
		niii0O30 = 0;
	always @ ( posedge tx_clk)
		  niii0O30 <= niii0O28;
	initial
		niiill25 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niiill25 <= niiill27;
	initial
		niiill26 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niiill26 <= (niiill27 ^ niiill25);
	initial
		niiill27 = 0;
	always @ ( posedge tx_clk)
		  niiill27 <= niiill25;
	initial
		niilli22 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niilli22 <= niilli24;
	initial
		niilli23 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niilli23 <= (niilli24 ^ niilli22);
	initial
		niilli24 = 0;
	always @ ( posedge tx_clk)
		  niilli24 <= niilli22;
	initial
		niilll19 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niilll19 <= niilll21;
	initial
		niilll20 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niilll20 <= (niilll21 ^ niilll19);
	initial
		niilll21 = 0;
	always @ ( posedge tx_clk)
		  niilll21 <= niilll19;
	initial
		niillO16 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niillO16 <= niillO18;
	initial
		niillO17 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niillO17 <= (niillO18 ^ niillO16);
	initial
		niillO18 = 0;
	always @ ( posedge tx_clk)
		  niillO18 <= niillO16;
	initial
		niilOl13 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niilOl13 <= niilOl15;
	initial
		niilOl14 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niilOl14 <= (niilOl15 ^ niilOl13);
	initial
		niilOl15 = 0;
	always @ ( posedge tx_clk)
		  niilOl15 <= niilOl13;
	initial
		niiO0O7 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niiO0O7 <= niiO0O9;
	initial
		niiO0O8 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niiO0O8 <= (niiO0O9 ^ niiO0O7);
	initial
		niiO0O9 = 0;
	always @ ( posedge tx_clk)
		  niiO0O9 <= niiO0O7;
	initial
		niiO1i10 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niiO1i10 <= niiO1i12;
	initial
		niiO1i11 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niiO1i11 <= (niiO1i12 ^ niiO1i10);
	initial
		niiO1i12 = 0;
	always @ ( posedge tx_clk)
		  niiO1i12 <= niiO1i10;
	initial
		niiOiO4 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niiOiO4 <= niiOiO6;
	initial
		niiOiO5 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niiOiO5 <= (niiOiO6 ^ niiOiO4);
	initial
		niiOiO6 = 0;
	always @ ( posedge tx_clk)
		  niiOiO6 <= niiOiO4;
	initial
		niiOll1 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niiOll1 <= niiOll3;
	initial
		niiOll2 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  niiOll2 <= (niiOll3 ^ niiOll1);
	initial
		niiOll3 = 0;
	always @ ( posedge tx_clk)
		  niiOll3 <= niiOll1;
	initial
	begin
		n0iii = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n0iii <= 1;
		end
		else if  (wire_nli_dataout == 1'b1) 
		begin
			n0iii <= ni0OlO;
		end
	end
	initial
	begin
		n110l = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n110l <= 0;
		end
		else if  (wire_n110i_ENA == 1'b1) 
		begin
			n110l <= wire_n1OOl_o[1];
		end
	end
	assign
		wire_n110i_ENA = (wire_nll_dataout & wire_nlilil_dataout);
	initial
	begin
		n11ii = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n11ii <= 0;
		end
		else if  (wire_n110O_ENA == 1'b1) 
		begin
			n11ii <= wire_n1OOl_o[2];
		end
	end
	assign
		wire_n110O_ENA = (wire_nll_dataout & wire_nlilil_dataout);
	initial
	begin
		n111O = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n111O <= 0;
		end
		else if  (wire_n111l_ENA == 1'b1) 
		begin
			n111O <= wire_n1OOl_o[0];
		end
	end
	assign
		wire_n111l_ENA = (wire_nll_dataout & wire_nlilil_dataout);
	initial
	begin
		n100i = 0;
		n100l = 0;
		n100O = 0;
		n101i = 0;
		n101l = 0;
		n101O = 0;
		n10ii = 0;
		n10il = 0;
		n10iO = 0;
		n10li = 0;
		n10ll = 0;
		n10lO = 0;
		n10Oi = 0;
		n10Ol = 0;
		n10OO = 0;
		n111i = 0;
		n11il = 0;
		n11iO = 0;
		n11li = 0;
		n11ll = 0;
		n11lO = 0;
		n11Oi = 0;
		n11Ol = 0;
		n11OO = 0;
		n1i0i = 0;
		n1i0l = 0;
		n1i0O = 0;
		n1i1i = 0;
		n1i1l = 0;
		n1i1O = 0;
		n1iii = 0;
		n1iil = 0;
		n1iiO = 0;
		n1ili = 0;
		n1ill = 0;
		n1ilO = 0;
		n1iOi = 0;
		n1iOl = 0;
		n1iOO = 0;
		n1l0i = 0;
		n1l0l = 0;
		n1l0O = 0;
		n1l1i = 0;
		n1l1l = 0;
		n1l1O = 0;
		n1lii = 0;
		n1lil = 0;
		n1liO = 0;
		n1lll = 0;
		nlOOil = 0;
		nlOOiO = 0;
		nlOOli = 0;
		nlOOll = 0;
		nlOOlO = 0;
		nlOOOi = 0;
		nlOOOl = 0;
		nlOOOO = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n100i <= 0;
			n100l <= 0;
			n100O <= 0;
			n101i <= 0;
			n101l <= 0;
			n101O <= 0;
			n10ii <= 0;
			n10il <= 0;
			n10iO <= 0;
			n10li <= 0;
			n10ll <= 0;
			n10lO <= 0;
			n10Oi <= 0;
			n10Ol <= 0;
			n10OO <= 0;
			n111i <= 0;
			n11il <= 0;
			n11iO <= 0;
			n11li <= 0;
			n11ll <= 0;
			n11lO <= 0;
			n11Oi <= 0;
			n11Ol <= 0;
			n11OO <= 0;
			n1i0i <= 0;
			n1i0l <= 0;
			n1i0O <= 0;
			n1i1i <= 0;
			n1i1l <= 0;
			n1i1O <= 0;
			n1iii <= 0;
			n1iil <= 0;
			n1iiO <= 0;
			n1ili <= 0;
			n1ill <= 0;
			n1ilO <= 0;
			n1iOi <= 0;
			n1iOl <= 0;
			n1iOO <= 0;
			n1l0i <= 0;
			n1l0l <= 0;
			n1l0O <= 0;
			n1l1i <= 0;
			n1l1l <= 0;
			n1l1O <= 0;
			n1lii <= 0;
			n1lil <= 0;
			n1liO <= 0;
			n1lll <= 0;
			nlOOil <= 0;
			nlOOiO <= 0;
			nlOOli <= 0;
			nlOOll <= 0;
			nlOOlO <= 0;
			nlOOOi <= 0;
			nlOOOl <= 0;
			nlOOOO <= 0;
		end
		else if  (wire_nll_dataout == 1'b1) 
		begin
			n100i <= wire_n001i_dataout;
			n100l <= wire_n001l_dataout;
			n100O <= ni0OiO;
			n101i <= wire_n01Oi_dataout;
			n101l <= wire_n01Ol_dataout;
			n101O <= wire_n01OO_dataout;
			n10ii <= wire_nlilOO_o;
			n10il <= wire_nll01l_o;
			n10iO <= wire_nll00l_o;
			n10li <= wire_nll0il_o;
			n10ll <= wire_nll0ll_o;
			n10lO <= wire_nll0Ol_o;
			n10Oi <= (~ ni0Oli);
			n10Ol <= wire_nlli1O_o;
			n10OO <= (~ ni0Oll);
			n111i <= wire_n1O0O_dataout;
			n11il <= wire_n1OOO_dataout;
			n11iO <= wire_n011i_dataout;
			n11li <= wire_n011l_dataout;
			n11ll <= wire_n011O_dataout;
			n11lO <= wire_n01iO_dataout;
			n11Oi <= wire_n01li_dataout;
			n11Ol <= wire_n01ll_dataout;
			n11OO <= wire_n01lO_dataout;
			n1i0i <= wire_nllilO_o;
			n1i0l <= wire_nlliOl_o;
			n1i0O <= wire_nlll1i_o;
			n1i1i <= wire_nlliii_o;
			n1i1l <= wire_nlliiO_o;
			n1i1O <= wire_nllill_o;
			n1iii <= wire_nlll1O_o;
			n1iil <= wire_nlll0l_o;
			n1iiO <= wire_nliO1l_o;
			n1ili <= wire_nliO0i_o;
			n1ill <= wire_nliO0O_o;
			n1ilO <= wire_nliOil_o;
			n1iOi <= wire_nliOll_dataout;
			n1iOl <= wire_nliOlO_o;
			n1iOO <= wire_nliOOl_dataout;
			n1l0i <= wire_nll11O_o;
			n1l0l <= wire_nll10l_o;
			n1l0O <= wire_nll1ii_o;
			n1l1i <= wire_nliOOO_o;
			n1l1l <= wire_nll11i_o;
			n1l1O <= wire_nll11l_o;
			n1lii <= wire_nll1iO_o;
			n1lil <= wire_nll1lO_dataout;
			n1liO <= wire_nll1Oi_o;
			n1lll <= wire_nll1OO_o;
			nlOOil <= wire_n1llO_dataout;
			nlOOiO <= wire_n1lOi_dataout;
			nlOOli <= wire_n1lOl_dataout;
			nlOOll <= wire_n1O1i_dataout;
			nlOOlO <= wire_n1O1l_dataout;
			nlOOOi <= wire_n1O1O_dataout;
			nlOOOl <= wire_n1O0i_dataout;
			nlOOOO <= wire_n1O0l_dataout;
		end
	end
	initial
	begin
		nil10l = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			nil10l <= 1;
		end
		else 
		begin
			nil10l <= wire_nill0O_o;
		end
	end
	initial
	begin
		nil10O = 0;
		nl000O = 0;
		nl00ii = 0;
		nl00il = 0;
		nl00iO = 0;
		nl00li = 0;
		nl00ll = 0;
		nl00lO = 0;
		nl00Oi = 0;
		nl00Ol = 0;
		nl00OO = 0;
		nl0i0i = 0;
		nl0i0l = 0;
		nl0i0O = 0;
		nl0i1i = 0;
		nl0i1l = 0;
		nl0i1O = 0;
		nl0iii = 0;
		nl0iil = 0;
		nl0iiO = 0;
		nl0ili = 0;
		nl0ill = 0;
		nl0ilO = 0;
		nl0iOi = 0;
		nl0iOl = 0;
		nl0iOO = 0;
		nl0l0i = 0;
		nl0l0l = 0;
		nl0l0O = 0;
		nl0l1i = 0;
		nl0l1l = 0;
		nl0l1O = 0;
		nl0lii = 0;
		nl0lil = 0;
		nl0liO = 0;
		nl0lli = 0;
		nl0lll = 0;
		nl0llO = 0;
		nl0lOi = 0;
		nl0lOl = 0;
		nl0lOO = 0;
		nl0O0i = 0;
		nl0O0l = 0;
		nl0O0O = 0;
		nl0O1i = 0;
		nl0O1l = 0;
		nl0O1O = 0;
		nl0Oii = 0;
		nl0Oil = 0;
		nl0OiO = 0;
		nl0Oli = 0;
		nl0Oll = 0;
		nl0OOi = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			nil10O <= 0;
			nl000O <= 0;
			nl00ii <= 0;
			nl00il <= 0;
			nl00iO <= 0;
			nl00li <= 0;
			nl00ll <= 0;
			nl00lO <= 0;
			nl00Oi <= 0;
			nl00Ol <= 0;
			nl00OO <= 0;
			nl0i0i <= 0;
			nl0i0l <= 0;
			nl0i0O <= 0;
			nl0i1i <= 0;
			nl0i1l <= 0;
			nl0i1O <= 0;
			nl0iii <= 0;
			nl0iil <= 0;
			nl0iiO <= 0;
			nl0ili <= 0;
			nl0ill <= 0;
			nl0ilO <= 0;
			nl0iOi <= 0;
			nl0iOl <= 0;
			nl0iOO <= 0;
			nl0l0i <= 0;
			nl0l0l <= 0;
			nl0l0O <= 0;
			nl0l1i <= 0;
			nl0l1l <= 0;
			nl0l1O <= 0;
			nl0lii <= 0;
			nl0lil <= 0;
			nl0liO <= 0;
			nl0lli <= 0;
			nl0lll <= 0;
			nl0llO <= 0;
			nl0lOi <= 0;
			nl0lOl <= 0;
			nl0lOO <= 0;
			nl0O0i <= 0;
			nl0O0l <= 0;
			nl0O0O <= 0;
			nl0O1i <= 0;
			nl0O1l <= 0;
			nl0O1O <= 0;
			nl0Oii <= 0;
			nl0Oil <= 0;
			nl0OiO <= 0;
			nl0Oli <= 0;
			nl0Oll <= 0;
			nl0OOi <= 0;
		end
		else 
		begin
			nil10O <= wire_nilOOi_o;
			nl000O <= wire_nl0OOl_dataout;
			nl00ii <= wire_nl0OOO_dataout;
			nl00il <= wire_nli11i_dataout;
			nl00iO <= wire_nli11l_dataout;
			nl00li <= wire_nli11O_dataout;
			nl00ll <= wire_nli10i_dataout;
			nl00lO <= wire_nli10l_dataout;
			nl00Oi <= wire_nli10O_dataout;
			nl00Ol <= wire_nli1ii_dataout;
			nl00OO <= wire_nli1il_dataout;
			nl0i0i <= wire_nli1lO_dataout;
			nl0i0l <= wire_nli1Oi_dataout;
			nl0i0O <= wire_nli1Ol_dataout;
			nl0i1i <= wire_nli1iO_dataout;
			nl0i1l <= wire_nli1li_dataout;
			nl0i1O <= wire_nli1ll_dataout;
			nl0iii <= wire_nli1OO_dataout;
			nl0iil <= wire_nli01i_dataout;
			nl0iiO <= wire_nli01l_dataout;
			nl0ili <= wire_nli01O_dataout;
			nl0ill <= wire_nli00i_dataout;
			nl0ilO <= wire_nli00l_dataout;
			nl0iOi <= (~ (nil10l | nl0O1O));
			nl0iOl <= wire_nil1il_o;
			nl0iOO <= wire_nil1li_o;
			nl0l0i <= wire_nil00O_o;
			nl0l0l <= wire_nil0il_o;
			nl0l0O <= wire_nil0ll_o;
			nl0l1i <= wire_nil1Oi_o;
			nl0l1l <= wire_nil01i_o;
			nl0l1O <= wire_nil01O_o;
			nl0lii <= wire_nil0Ol_o;
			nl0lil <= wire_nili1l_o;
			nl0liO <= wire_nili0i_o;
			nl0lli <= wire_nili0O_o;
			nl0lll <= wire_niliil_o;
			nl0llO <= wire_nilili_o;
			nl0lOi <= wire_nililO_o;
			nl0lOl <= wire_niliOl_o;
			nl0lOO <= wire_nill1i_o;
			nl0O0i <= wire_nillli_o;
			nl0O0l <= wire_nilllO_o;
			nl0O0O <= wire_nillOl_o;
			nl0O1i <= wire_nill0i_o;
			nl0O1l <= wire_nillii_o;
			nl0O1O <= wire_nillil_o;
			nl0Oii <= wire_nilO1i_o;
			nl0Oil <= wire_nilO1O_o;
			nl0OiO <= wire_nilO0l_o;
			nl0Oli <= wire_nilOii_o;
			nl0Oll <= wire_nilOiO_o;
			nl0OOi <= wire_nilOll_o;
		end
	end
	initial
	begin
		niO0O = 0;
		niOii = 0;
		niOil = 0;
		niOiO = 0;
		niOli = 0;
		niOll = 0;
		niOlO = 0;
		niOOi = 0;
		niOOl = 0;
		niOOO = 0;
		nl00i = 0;
		nl00l = 0;
		nl00O = 0;
		nl01i = 0;
		nl01l = 0;
		nl01O = 0;
		nl0ii = 0;
		nl0il = 0;
		nl0iO = 0;
		nl0li = 0;
		nl0ll = 0;
		nl0lO = 0;
		nl0Oi = 0;
		nl0Ol = 0;
		nl0OO = 0;
		nl10i = 0;
		nl10l = 0;
		nl10O = 0;
		nl11i = 0;
		nl11l = 0;
		nl11O = 0;
		nl1ii = 0;
		nl1il = 0;
		nl1iO = 0;
		nl1li = 0;
		nl1ll = 0;
		nl1lO = 0;
		nl1Oi = 0;
		nl1Ol = 0;
		nl1OO = 0;
		nli0i = 0;
		nli0l = 0;
		nli0O = 0;
		nli1i = 0;
		nli1l = 0;
		nli1O = 0;
		nliii = 0;
		nliil = 0;
		nlili = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			niO0O <= 0;
			niOii <= 0;
			niOil <= 0;
			niOiO <= 0;
			niOli <= 0;
			niOll <= 0;
			niOlO <= 0;
			niOOi <= 0;
			niOOl <= 0;
			niOOO <= 0;
			nl00i <= 0;
			nl00l <= 0;
			nl00O <= 0;
			nl01i <= 0;
			nl01l <= 0;
			nl01O <= 0;
			nl0ii <= 0;
			nl0il <= 0;
			nl0iO <= 0;
			nl0li <= 0;
			nl0ll <= 0;
			nl0lO <= 0;
			nl0Oi <= 0;
			nl0Ol <= 0;
			nl0OO <= 0;
			nl10i <= 0;
			nl10l <= 0;
			nl10O <= 0;
			nl11i <= 0;
			nl11l <= 0;
			nl11O <= 0;
			nl1ii <= 0;
			nl1il <= 0;
			nl1iO <= 0;
			nl1li <= 0;
			nl1ll <= 0;
			nl1lO <= 0;
			nl1Oi <= 0;
			nl1Ol <= 0;
			nl1OO <= 0;
			nli0i <= 0;
			nli0l <= 0;
			nli0O <= 0;
			nli1i <= 0;
			nli1l <= 0;
			nli1O <= 0;
			nliii <= 0;
			nliil <= 0;
			nlili <= 0;
		end
		else if  (wire_nli_dataout == 1'b1) 
		begin
			niO0O <= wire_nlill_dataout;
			niOii <= wire_nlilO_dataout;
			niOil <= wire_nliOi_dataout;
			niOiO <= wire_nliOO_dataout;
			niOli <= wire_nll1i_dataout;
			niOll <= wire_nll1l_dataout;
			niOlO <= wire_nll1O_dataout;
			niOOi <= wire_nll0i_dataout;
			niOOl <= niiiOO;
			niOOO <= wire_n0iOi_o;
			nl00i <= wire_n0l0i_o;
			nl00l <= wire_n0l0O_dataout;
			nl00O <= wire_n0lii_o;
			nl01i <= wire_ni0Oi_o;
			nl01l <= wire_n0iOO_o;
			nl01O <= wire_n0l1l_o;
			nl0ii <= wire_n0liO_dataout;
			nl0il <= wire_n0lli_o;
			nl0iO <= wire_n0llO_dataout;
			nl0li <= wire_n0lOi_o;
			nl0ll <= wire_n0lOO_dataout;
			nl0lO <= wire_n0O1i_o;
			nl0Oi <= wire_n0O1O_dataout;
			nl0Ol <= wire_n0O0i_o;
			nl0OO <= wire_n0O0O_dataout;
			nl10i <= (~ niil0i);
			nl10l <= (~ niil0l);
			nl10O <= (~ niil0O);
			nl11i <= (~ niil1i);
			nl11l <= niil1l;
			nl11O <= (~ niil1O);
			nl1ii <= (~ niilii);
			nl1il <= niilil;
			nl1iO <= wire_ni1Ol_o;
			nl1li <= wire_ni01i_o;
			nl1ll <= wire_ni01O_o;
			nl1lO <= wire_ni00l_o;
			nl1Oi <= wire_ni0ii_o;
			nl1Ol <= wire_ni0iO_o;
			nl1OO <= wire_ni0ll_o;
			nli0i <= wire_n0Oli_o;
			nli0l <= wire_n0OlO_dataout;
			nli0O <= wire_n0OOi_o;
			nli1i <= wire_n0Oii_o;
			nli1l <= wire_n0Oil_o;
			nli1O <= wire_n0OiO_o;
			nliii <= wire_ni11i_dataout;
			nliil <= wire_ni11l_o;
			nlili <= wire_ni10i_o;
		end
	end
	initial
	begin
		nlil0l = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			nlil0l <= 1;
		end
		else if  (wire_nll_dataout == 1'b1) 
		begin
			nlil0l <= ni0OlO;
		end
	end
	assign		wire_n000i_dataout = (n1ilO === 1'b1) ? wire_n00lO_o[1] : n11Oi;
	assign		wire_n000l_dataout = (n1ilO === 1'b1) ? wire_n00lO_o[2] : n11Ol;
	assign		wire_n000O_dataout = (n1ilO === 1'b1) ? wire_n00lO_o[3] : n11OO;
	and(wire_n001i_dataout, wire_n00li_dataout, ~{wire_nlilll_dataout});
	and(wire_n001l_dataout, wire_n00ll_dataout, ~{wire_nlilll_dataout});
	assign		wire_n001O_dataout = (n1ilO === 1'b1) ? wire_n00lO_o[0] : n11lO;
	assign		wire_n00i_dataout = (niiO1O === 1'b1) ? nl0l1O : wire_niii_dataout;
	assign		wire_n00ii_dataout = (n1ilO === 1'b1) ? wire_n00lO_o[4] : n101i;
	assign		wire_n00il_dataout = (n1ilO === 1'b1) ? wire_n00lO_o[5] : n101l;
	assign		wire_n00iO_dataout = (n1ilO === 1'b1) ? wire_n00lO_o[6] : n101O;
	assign		wire_n00l_dataout = (niiO1O === 1'b1) ? nl0l0i : wire_niil_dataout;
	assign		wire_n00li_dataout = (n1ilO === 1'b1) ? wire_n00lO_o[7] : n100i;
	assign		wire_n00ll_dataout = (n1ilO === 1'b1) ? wire_n00lO_o[8] : n100l;
	assign		wire_n00O_dataout = (niiO1O === 1'b1) ? nl0l0l : wire_niiO_dataout;
	assign		wire_n010i_dataout = (wire_nliliO_dataout === 1'b1) ? wire_n01il_o[0] : n11il;
	assign		wire_n010l_dataout = (wire_nliliO_dataout === 1'b1) ? wire_n01il_o[1] : n11iO;
	assign		wire_n010O_dataout = (wire_nliliO_dataout === 1'b1) ? wire_n01il_o[2] : n11li;
	and(wire_n011i_dataout, wire_n010l_dataout, ~{wire_nlilli_dataout});
	and(wire_n011l_dataout, wire_n010O_dataout, ~{wire_nlilli_dataout});
	and(wire_n011O_dataout, wire_n01ii_dataout, ~{wire_nlilli_dataout});
	assign		wire_n01i_dataout = (niiO1O === 1'b1) ? nl0iOO : wire_ni0i_dataout;
	assign		wire_n01ii_dataout = (wire_nliliO_dataout === 1'b1) ? wire_n01il_o[3] : n11ll;
	and(wire_n01iO_dataout, wire_n001O_dataout, ~{wire_nlilll_dataout});
	assign		wire_n01l_dataout = (niiO1O === 1'b1) ? nl0l1i : wire_ni0l_dataout;
	and(wire_n01li_dataout, wire_n000i_dataout, ~{wire_nlilll_dataout});
	and(wire_n01ll_dataout, wire_n000l_dataout, ~{wire_nlilll_dataout});
	and(wire_n01lO_dataout, wire_n000O_dataout, ~{wire_nlilll_dataout});
	assign		wire_n01O_dataout = (niiO1O === 1'b1) ? nl0l1l : wire_ni0O_dataout;
	and(wire_n01Oi_dataout, wire_n00ii_dataout, ~{wire_nlilll_dataout});
	and(wire_n01Ol_dataout, wire_n00il_dataout, ~{wire_nlilll_dataout});
	and(wire_n01OO_dataout, wire_n00iO_dataout, ~{wire_nlilll_dataout});
	and(wire_n0i_dataout, nl1Oi, niiO0l);
	assign		wire_n0ii_dataout = (niiO1O === 1'b1) ? nl0l0O : wire_nili_dataout;
	assign		wire_n0il_dataout = (niiO1O === 1'b1) ? nl0lii : wire_nill_dataout;
	assign		wire_n0iO_dataout = (niiO1O === 1'b1) ? nl0lil : wire_nilO_dataout;
	and(wire_n0l_dataout, nl1Ol, niiO0l);
	and(wire_n0l0O_dataout, wire_nilOi_dataout, nl01O);
	assign		wire_n0li_dataout = (niiO1O === 1'b1) ? nl0liO : wire_niOi_dataout;
	and(wire_n0liO_dataout, (~ niiOil), nl00i);
	assign		wire_n0ll_dataout = (niiO1O === 1'b1) ? nl0lli : wire_niOl_dataout;
	and(wire_n0llO_dataout, (~ niiOil), nl00O);
	assign		wire_n0lO_dataout = (niiO1O === 1'b1) ? nl0lll : wire_niOO_dataout;
	and(wire_n0lOO_dataout, (~ niiOil), nl0il);
	and(wire_n0O_dataout, nl1OO, niiO0l);
	and(wire_n0O0O_dataout, (~ niiOil), nl0lO);
	and(wire_n0O1O_dataout, (~ niiOil), nl0li);
	assign		wire_n0Oi_dataout = (niiO1O === 1'b1) ? nl0llO : wire_nl1i_dataout;
	assign		wire_n0Ol_dataout = (niiO1O === 1'b1) ? nl0lOi : wire_nl1l_dataout;
	and(wire_n0OlO_dataout, (~ niiOil), nl0Ol);
	assign		wire_n0OO_dataout = (niiO1O === 1'b1) ? nl0lOl : wire_nl1O_dataout;
	and(wire_n1i_dataout, nl1li, niiO0l);
	and(wire_n1l_dataout, nl1ll, niiO0l);
	and(wire_n1llO_dataout, wire_n1lOO_o[0], wire_nlillO_o);
	and(wire_n1lOi_dataout, wire_n1lOO_o[1], wire_nlillO_o);
	and(wire_n1lOl_dataout, wire_n1lOO_o[2], wire_nlillO_o);
	and(wire_n1O_dataout, nl1lO, niiO0l);
	assign		wire_n1O0i_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1OOi_o[3] : wire_n1Oli_dataout;
	assign		wire_n1O0l_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1OOi_o[4] : wire_n1Oll_dataout;
	assign		wire_n1O0O_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1OOi_o[5] : wire_n1OlO_dataout;
	assign		wire_n1O1i_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1OOi_o[0] : wire_n1Oii_dataout;
	assign		wire_n1O1l_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1OOi_o[1] : wire_n1Oil_dataout;
	assign		wire_n1O1O_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1OOi_o[2] : wire_n1OiO_dataout;
	and(wire_n1Oii_dataout, nlOOll, ~{wire_nlilii_dataout});
	and(wire_n1Oil_dataout, nlOOlO, ~{wire_nlilii_dataout});
	and(wire_n1OiO_dataout, nlOOOi, ~{wire_nlilii_dataout});
	and(wire_n1Oli_dataout, nlOOOl, ~{wire_nlilii_dataout});
	and(wire_n1Oll_dataout, nlOOOO, ~{wire_nlilii_dataout});
	and(wire_n1OlO_dataout, n111i, ~{wire_nlilii_dataout});
	and(wire_n1OOO_dataout, wire_n010i_dataout, ~{wire_nlilli_dataout});
	assign		wire_ni0i_dataout = (niiO0i === 1'b1) ? n10il : wire_nlii_dataout;
	assign		wire_ni0l_dataout = (niiO0i === 1'b1) ? n10iO : wire_nlil_dataout;
	assign		wire_ni0O_dataout = (niiO0i === 1'b1) ? n10li : wire_nliO_dataout;
	and(wire_ni0OO_dataout, niii1l, niiiil);
	and(wire_ni11i_dataout, (~ niiOil), nli1i);
	assign		wire_ni1i_dataout = (niiO1O === 1'b1) ? nl0lOO : wire_nl0i_dataout;
	assign		wire_ni1l_dataout = (niiO1O === 1'b1) ? nl0iOi : wire_nl0l_dataout;
	assign		wire_ni1O_dataout = (niiO1O === 1'b1) ? nl0iOl : wire_nl0O_dataout;
	and(wire_nii_dataout, nl01i, niiO0l);
	assign		wire_nii0i_dataout = (niiOil === 1'b1) ? (~ niii0i) : wire_nii0O_dataout;
	and(wire_nii0l_dataout, wire_niiii_dataout, ~{niiOil});
	assign		wire_nii0O_dataout = (niiiil === 1'b1) ? (~ niii1l) : (~ niii1O);
	and(wire_nii1i_dataout, niii1l, ~{niiiil});
	and(wire_nii1l_dataout, wire_niiil_dataout, niiOil);
	and(wire_nii1O_dataout, wire_niiiO_dataout, niiOil);
	assign		wire_niii_dataout = (niiO0i === 1'b1) ? n10ll : wire_nlli_dataout;
	assign		wire_niiii_dataout = (niiiil === 1'b1) ? niii1l : niii1O;
	and(wire_niiil_dataout, niii0i, niiiil);
	and(wire_niiiO_dataout, niii0i, ~{niiiil});
	assign		wire_niil_dataout = (niiO0i === 1'b1) ? n10lO : wire_nlll_dataout;
	and(wire_niili_dataout, (~ niii0l), niiOil);
	and(wire_niill_dataout, wire_nil1i_dataout, niiOil);
	and(wire_niilO_dataout, wire_nil1l_dataout, niiOil);
	assign		wire_niiO_dataout = (niiO0i === 1'b1) ? n10Oi : wire_nllO_dataout;
	and(wire_niiOi_dataout, wire_nil1O_dataout, niiOil);
	and(wire_niiOl_dataout, wire_nil0i_dataout, niiOil);
	and(wire_niiOO_dataout, niii0l, niiOil);
	and(wire_nil_dataout, niOOl, niiO0l);
	and(wire_nil0i_dataout, wire_nilii_dataout, niii0l);
	and(wire_nil0l_dataout, niiiOi, ~{niiiil});
	and(wire_nil0O_dataout, wire_nilil_dataout, ~{niiiil});
	and(wire_nil1i_dataout, niiiil, niii0l);
	and(wire_nil1l_dataout, wire_nil0l_dataout, niii0l);
	and(wire_nil1O_dataout, wire_nil0O_dataout, niii0l);
	assign		wire_nili_dataout = (niiO0i === 1'b1) ? n10Ol : wire_nlOi_dataout;
	and(wire_nilii_dataout, wire_niliO_dataout, ~{niiiil});
	and(wire_nilil_dataout, niiiOl, ~{niiiOi});
	and(wire_niliO_dataout, (~ niiiOl), ~{niiiOi});
	assign		wire_nill_dataout = (niiO0i === 1'b1) ? n10OO : wire_nlOl_dataout;
	and(wire_nilli_dataout, (~ ((niiiOl | niiiOi) | (~ niii0O29))), niiOil);
	and(wire_nilll_dataout, wire_nilOl_dataout, ~{niiOil});
	or(wire_nillO_dataout, wire_nilOO_dataout, niiOil);
	assign		wire_nilO_dataout = (niiO0i === 1'b1) ? n1i1i : wire_nlOO_dataout;
	and(wire_nilOi_dataout, wire_niO1i_dataout, ~{niiOil});
	and(wire_nilOl_dataout, wire_niO1l_dataout, ~{niiiil});
	or(wire_nilOO_dataout, wire_niO1O_dataout, niiiil);
	and(wire_nilOOO_dataout, wire_nlO_dataout, niiOil);
	and(wire_niO_dataout, niOOO, niiO0l);
	assign		wire_niO00i_dataout = (niiOil === 1'b1) ? nl00OO : nl0iil;
	assign		wire_niO00l_dataout = (niiOil === 1'b1) ? nl0i1i : nl0iiO;
	assign		wire_niO00O_dataout = (niiOil === 1'b1) ? nl0i1l : nl0ili;
	and(wire_niO01i_dataout, nl0i0l, ~{niiOil});
	assign		wire_niO01l_dataout = (niiOil === 1'b1) ? nl00Oi : nl0i0O;
	assign		wire_niO01O_dataout = (niiOil === 1'b1) ? nl00Ol : nl0iii;
	assign		wire_niO0ii_dataout = (niiOil === 1'b1) ? nl0i1O : nl0ill;
	assign		wire_niO0il_dataout = (niiOil === 1'b1) ? nl0i0i : nl0ilO;
	and(wire_niO0iO_dataout, nl000O, niiOil);
	and(wire_niO0li_dataout, nl00ii, niiOil);
	and(wire_niO0ll_dataout, nl00il, niiOil);
	and(wire_niO0lO_dataout, nl00iO, niiOil);
	and(wire_niO0Oi_dataout, nl00li, niiOil);
	and(wire_niO0Ol_dataout, nl00ll, niiOil);
	and(wire_niO0OO_dataout, nl00lO, niiOil);
	assign		wire_niO10i_dataout = (niiOil === 1'b1) ? wire_niOO1i_dataout : wire_niOi1O_dataout;
	assign		wire_niO10l_dataout = (niiOil === 1'b1) ? wire_niOO1l_dataout : wire_niOi0i_dataout;
	assign		wire_niO10O_dataout = (niiOil === 1'b1) ? wire_niOO1O_dataout : wire_niOi0l_dataout;
	and(wire_niO11i_dataout, wire_nlO_dataout, ~{niiOil});
	assign		wire_niO11l_dataout = (niiOil === 1'b1) ? wire_niOlOl_dataout : wire_niOi1i_dataout;
	assign		wire_niO11O_dataout = (niiOil === 1'b1) ? wire_niOlOO_dataout : wire_niOi1l_dataout;
	and(wire_niO1i_dataout, (~ niiili), ~{niiiil});
	assign		wire_niO1ii_dataout = (niiOil === 1'b1) ? wire_niOO0i_dataout : wire_niOi0O_dataout;
	assign		wire_niO1il_dataout = (niiOil === 1'b1) ? wire_niOO0l_dataout : wire_niOiii_dataout;
	assign		wire_niO1iO_dataout = (niiOil === 1'b1) ? wire_niOO0O_dataout : wire_niOiil_dataout;
	and(wire_niO1l_dataout, (~ niiiiO), niiili);
	assign		wire_niO1li_dataout = (niiOil === 1'b1) ? wire_niOOii_dataout : wire_niOiiO_dataout;
	assign		wire_niO1ll_dataout = (niiOil === 1'b1) ? wire_niOOil_dataout : wire_niOili_dataout;
	assign		wire_niO1lO_dataout = (niiOil === 1'b1) ? wire_niOOiO_dataout : wire_niOill_dataout;
	and(wire_niO1O_dataout, niiiiO, niiili);
	assign		wire_niO1Oi_dataout = (niiOil === 1'b1) ? wire_niOOli_dataout : wire_niOilO_dataout;
	assign		wire_niO1Ol_dataout = (niiOil === 1'b1) ? wire_niOOll_dataout : wire_niOiOi_dataout;
	assign		wire_niO1OO_dataout = (niiOil === 1'b1) ? wire_niOOlO_dataout : wire_niOiOl_dataout;
	assign		wire_niOi_dataout = (niiO0i === 1'b1) ? n1i1l : wire_n1i_dataout;
	and(wire_niOi0i_dataout, wire_niOl1O_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOi0l_dataout, wire_niOl0i_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOi0O_dataout, wire_niOl0l_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOi1i_dataout, wire_niOiOO_dataout, ~{(~ wire_nlO_dataout)});
	or(wire_niOi1l_dataout, wire_niOl1i_dataout, (~ wire_nlO_dataout));
	and(wire_niOi1O_dataout, wire_niOl1l_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOiii_dataout, wire_niOl0O_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOiil_dataout, wire_niOlii_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOiiO_dataout, wire_niOlil_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOili_dataout, wire_niOliO_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOill_dataout, wire_niOlli_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOilO_dataout, wire_niOlll_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOiOi_dataout, wire_niOllO_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOiOl_dataout, wire_niOlOi_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOiOO_dataout, nl0O1i, ~{ni01ll});
	assign		wire_niOl_dataout = (niiO0i === 1'b1) ? n1i1O : wire_n1l_dataout;
	or(wire_niOl0i_dataout, nl0O0i, ni01ll);
	and(wire_niOl0l_dataout, nl0O0l, ~{ni01ll});
	and(wire_niOl0O_dataout, nl0O0O, ~{ni01ll});
	and(wire_niOl1i_dataout, nil10l, ~{ni01ll});
	and(wire_niOl1l_dataout, nl0O1l, ~{ni01ll});
	and(wire_niOl1O_dataout, nl0O1O, ~{ni01ll});
	and(wire_niOlii_dataout, nl0Oii, ~{ni01ll});
	and(wire_niOlil_dataout, nl0Oil, ~{ni01ll});
	and(wire_niOliO_dataout, nl0OiO, ~{ni01ll});
	and(wire_niOlli_dataout, nl0Oli, ~{ni01ll});
	and(wire_niOlll_dataout, nl0Oll, ~{ni01ll});
	and(wire_niOllO_dataout, nl0OOi, ~{ni01ll});
	and(wire_niOlOi_dataout, nil10O, ~{ni01ll});
	and(wire_niOlOl_dataout, wire_niOOOi_dataout, ~{(~ wire_nlO_dataout)});
	or(wire_niOlOO_dataout, wire_niOOOl_dataout, (~ wire_nlO_dataout));
	assign		wire_niOO_dataout = (niiO0i === 1'b1) ? n1i0i : wire_n1O_dataout;
	and(wire_niOO0i_dataout, wire_nl111O_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOO0l_dataout, wire_nl110i_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOO0O_dataout, wire_nl110l_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOO1i_dataout, wire_niOOOO_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOO1l_dataout, wire_nl111i_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOO1O_dataout, wire_nl111l_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOOii_dataout, wire_nl110O_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOOil_dataout, wire_nl11ii_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOOiO_dataout, wire_nl11il_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOOli_dataout, wire_nl11iO_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOOll_dataout, wire_nl11li_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOOlO_dataout, wire_nl11ll_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_niOOOi_dataout, nl0O1i, ~{ni01lO});
	and(wire_niOOOl_dataout, nil10l, ~{ni01lO});
	and(wire_niOOOO_dataout, nl0O1l, ~{ni01lO});
	and(wire_nl000i_dataout, nl0OOi, ~{wire_nlO_dataout});
	and(wire_nl000l_dataout, nil10O, ~{wire_nlO_dataout});
	and(wire_nl001i_dataout, nl0OiO, ~{wire_nlO_dataout});
	and(wire_nl001l_dataout, nl0Oli, ~{wire_nlO_dataout});
	and(wire_nl001O_dataout, nl0Oll, ~{wire_nlO_dataout});
	and(wire_nl010i_dataout, nl0Oll, ~{ni01Ol});
	and(wire_nl010l_dataout, nl0OOi, ~{ni01Ol});
	and(wire_nl010O_dataout, nil10O, ~{ni01Ol});
	and(wire_nl011i_dataout, nl0Oil, ~{ni01Ol});
	and(wire_nl011l_dataout, nl0OiO, ~{ni01Ol});
	and(wire_nl011O_dataout, nl0Oli, ~{ni01Ol});
	or(wire_nl01ii_dataout, nl0O1i, wire_nlO_dataout);
	and(wire_nl01il_dataout, nil10l, ~{wire_nlO_dataout});
	and(wire_nl01iO_dataout, nl0O1l, ~{wire_nlO_dataout});
	and(wire_nl01li_dataout, nl0O1O, ~{wire_nlO_dataout});
	and(wire_nl01ll_dataout, nl0O0i, ~{wire_nlO_dataout});
	and(wire_nl01lO_dataout, nl0O0l, ~{wire_nlO_dataout});
	and(wire_nl01Oi_dataout, nl0O0O, ~{wire_nlO_dataout});
	and(wire_nl01Ol_dataout, nl0Oii, ~{wire_nlO_dataout});
	and(wire_nl01OO_dataout, nl0Oil, ~{wire_nlO_dataout});
	assign		wire_nl0i_dataout = (niiO0i === 1'b1) ? n1iil : wire_nii_dataout;
	assign		wire_nl0l_dataout = (niiO0i === 1'b1) ? n100O : wire_nil_dataout;
	assign		wire_nl0O_dataout = (niiO0i === 1'b1) ? n10ii : wire_niO_dataout;
	and(wire_nl0OOl_dataout, wire_nli00O_o[0], ni01OO);
	and(wire_nl0OOO_dataout, wire_nli00O_o[1], ni01OO);
	assign		wire_nl100i_dataout = (niiOil === 1'b1) ? wire_nl1O1i_dataout : wire_nl1i1O_dataout;
	assign		wire_nl100l_dataout = (niiOil === 1'b1) ? wire_nl1O1l_dataout : wire_nl1i0i_dataout;
	assign		wire_nl100O_dataout = (niiOil === 1'b1) ? wire_nl1O1O_dataout : wire_nl1i0l_dataout;
	assign		wire_nl101i_dataout = (niiOil === 1'b1) ? wire_nl1lOi_dataout : wire_nl10OO_dataout;
	assign		wire_nl101l_dataout = (niiOil === 1'b1) ? wire_nl1lOl_dataout : wire_nl1i1i_dataout;
	assign		wire_nl101O_dataout = (niiOil === 1'b1) ? wire_nl1lOO_dataout : wire_nl1i1l_dataout;
	assign		wire_nl10ii_dataout = (niiOil === 1'b1) ? wire_nl1O0i_dataout : wire_nl1i0O_dataout;
	assign		wire_nl10il_dataout = (niiOil === 1'b1) ? wire_nl1O0l_dataout : wire_nl1iii_dataout;
	assign		wire_nl10iO_dataout = (niiOil === 1'b1) ? wire_nl1O0O_dataout : wire_nl1iil_dataout;
	assign		wire_nl10li_dataout = (niiOil === 1'b1) ? wire_nl1Oii_dataout : wire_nl1iiO_dataout;
	and(wire_nl10ll_dataout, wire_nl1ili_dataout, ~{(~ wire_nlO_dataout)});
	or(wire_nl10lO_dataout, wire_nl1ill_dataout, (~ wire_nlO_dataout));
	and(wire_nl10Oi_dataout, wire_nl1ilO_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl10Ol_dataout, wire_nl1iOi_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl10OO_dataout, wire_nl1iOl_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl110i_dataout, nl0O0O, ~{ni01lO});
	and(wire_nl110l_dataout, nl0Oii, ~{ni01lO});
	and(wire_nl110O_dataout, nl0Oil, ~{ni01lO});
	and(wire_nl111i_dataout, nl0O1O, ~{ni01lO});
	or(wire_nl111l_dataout, nl0O0i, ni01lO);
	and(wire_nl111O_dataout, nl0O0l, ~{ni01lO});
	and(wire_nl11ii_dataout, nl0OiO, ~{ni01lO});
	and(wire_nl11il_dataout, nl0Oli, ~{ni01lO});
	and(wire_nl11iO_dataout, nl0Oll, ~{ni01lO});
	and(wire_nl11li_dataout, nl0OOi, ~{ni01lO});
	and(wire_nl11ll_dataout, nil10O, ~{ni01lO});
	assign		wire_nl11lO_dataout = (niiOil === 1'b1) ? wire_nl1liO_dataout : wire_nl10ll_dataout;
	assign		wire_nl11Oi_dataout = (niiOil === 1'b1) ? wire_nl1lli_dataout : wire_nl10lO_dataout;
	assign		wire_nl11Ol_dataout = (niiOil === 1'b1) ? wire_nl1lll_dataout : wire_nl10Oi_dataout;
	assign		wire_nl11OO_dataout = (niiOil === 1'b1) ? wire_nl1llO_dataout : wire_nl10Ol_dataout;
	assign		wire_nl1i_dataout = (niiO0i === 1'b1) ? n1i0l : wire_n0i_dataout;
	and(wire_nl1i0i_dataout, wire_nl1l1O_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1i0l_dataout, wire_nl1l0i_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1i0O_dataout, wire_nl1l0l_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1i1i_dataout, wire_nl1iOO_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1i1l_dataout, wire_nl1l1i_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1i1O_dataout, wire_nl1l1l_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1iii_dataout, wire_nl1l0O_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1iil_dataout, wire_nl1lii_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1iiO_dataout, wire_nl1lil_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1ili_dataout, nl0O1i, ~{ni01Oi});
	and(wire_nl1ill_dataout, nil10l, ~{ni01Oi});
	or(wire_nl1ilO_dataout, nl0O1l, ni01Oi);
	and(wire_nl1iOi_dataout, nl0O1O, ~{ni01Oi});
	and(wire_nl1iOl_dataout, nl0O0i, ~{ni01Oi});
	and(wire_nl1iOO_dataout, nl0O0l, ~{ni01Oi});
	assign		wire_nl1l_dataout = (niiO0i === 1'b1) ? n1i0O : wire_n0l_dataout;
	and(wire_nl1l0i_dataout, nl0OiO, ~{ni01Oi});
	and(wire_nl1l0l_dataout, nl0Oli, ~{ni01Oi});
	and(wire_nl1l0O_dataout, nl0Oll, ~{ni01Oi});
	and(wire_nl1l1i_dataout, nl0O0O, ~{ni01Oi});
	and(wire_nl1l1l_dataout, nl0Oii, ~{ni01Oi});
	and(wire_nl1l1O_dataout, nl0Oil, ~{ni01Oi});
	and(wire_nl1lii_dataout, nl0OOi, ~{ni01Oi});
	and(wire_nl1lil_dataout, nil10O, ~{ni01Oi});
	and(wire_nl1liO_dataout, wire_nl1Oil_dataout, ~{(~ wire_nlO_dataout)});
	or(wire_nl1lli_dataout, wire_nl1OiO_dataout, (~ wire_nlO_dataout));
	and(wire_nl1lll_dataout, wire_nl1Oli_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1llO_dataout, wire_nl1Oll_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1lOi_dataout, wire_nl1OlO_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1lOl_dataout, wire_nl1OOi_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1lOO_dataout, wire_nl1OOl_dataout, ~{(~ wire_nlO_dataout)});
	assign		wire_nl1O_dataout = (niiO0i === 1'b1) ? n1iii : wire_n0O_dataout;
	and(wire_nl1O0i_dataout, wire_nl011O_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1O0l_dataout, wire_nl010i_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1O0O_dataout, wire_nl010l_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1O1i_dataout, wire_nl1OOO_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1O1l_dataout, wire_nl011i_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1O1O_dataout, wire_nl011l_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1Oii_dataout, wire_nl010O_dataout, ~{(~ wire_nlO_dataout)});
	and(wire_nl1Oil_dataout, nl0O1i, ~{ni01Ol});
	and(wire_nl1OiO_dataout, nil10l, ~{ni01Ol});
	or(wire_nl1Oli_dataout, nl0O1l, ni01Ol);
	and(wire_nl1Oll_dataout, nl0O1O, ~{ni01Ol});
	and(wire_nl1OlO_dataout, nl0O0i, ~{ni01Ol});
	and(wire_nl1OOi_dataout, nl0O0l, ~{ni01Ol});
	and(wire_nl1OOl_dataout, nl0O0O, ~{ni01Ol});
	and(wire_nl1OOO_dataout, nl0Oii, ~{ni01Ol});
	and(wire_nli_dataout, rbisten_tx, ((~ rbist_sel[0]) & rbist_sel[1]));
	and(wire_nli00i_dataout, wire_nli0il_o[6], ni01OO);
	and(wire_nli00l_dataout, wire_nli0il_o[7], ni01OO);
	and(wire_nli01i_dataout, wire_nli0il_o[3], ni01OO);
	and(wire_nli01l_dataout, wire_nli0il_o[4], ni01OO);
	and(wire_nli01O_dataout, wire_nli0il_o[5], ni01OO);
	and(wire_nli10i_dataout, wire_nli00O_o[5], ni01OO);
	and(wire_nli10l_dataout, wire_nli00O_o[6], ni01OO);
	and(wire_nli10O_dataout, wire_nli0ii_o[0], ni01OO);
	and(wire_nli11i_dataout, wire_nli00O_o[2], ni01OO);
	and(wire_nli11l_dataout, wire_nli00O_o[3], ni01OO);
	and(wire_nli11O_dataout, wire_nli00O_o[4], ni01OO);
	and(wire_nli1ii_dataout, wire_nli0ii_o[1], ni01OO);
	and(wire_nli1il_dataout, wire_nli0ii_o[2], ni01OO);
	and(wire_nli1iO_dataout, wire_nli0ii_o[3], ni01OO);
	and(wire_nli1li_dataout, wire_nli0ii_o[4], ni01OO);
	and(wire_nli1ll_dataout, wire_nli0ii_o[5], ni01OO);
	and(wire_nli1lO_dataout, wire_nli0ii_o[6], ni01OO);
	and(wire_nli1Oi_dataout, wire_nli0il_o[0], ni01OO);
	and(wire_nli1Ol_dataout, wire_nli0il_o[1], ni01OO);
	and(wire_nli1OO_dataout, wire_nli0il_o[2], ni01OO);
	and(wire_nlii_dataout, nl11i, niiO0l);
	and(wire_nlil_dataout, nl11l, niiO0l);
	and(wire_nlil0O_dataout, wire_nllO1O_dataout, n1l0O);
	and(wire_nlilii_dataout, wire_nllO1l_dataout, n1l0O);
	and(wire_nlilil_dataout, niiOil, n1l0l);
	and(wire_nliliO_dataout, wire_nlO10i_dataout, n1iOl);
	and(wire_nlill_dataout, wire_nliOl_o[0], wire_n0ili_o);
	and(wire_nlilli_dataout, wire_nlO10l_dataout, n1iOl);
	and(wire_nlilll_dataout, wire_nlOi0l_dataout, n1ilO);
	and(wire_nlilO_dataout, wire_nliOl_o[1], wire_n0ili_o);
	and(wire_nliO_dataout, nl11O, niiO0l);
	and(wire_nliOi_dataout, wire_nliOl_o[2], wire_n0ili_o);
	and(wire_nliOll_dataout, wire_nlOlOO_dataout, n1ili);
	assign		wire_nliOO_dataout = (wire_n0iil_o === 1'b1) ? wire_nllli_o[0] : wire_nll0l_dataout;
	and(wire_nliOOl_dataout, wire_nlO1il_dataout, n1iOl);
	and(wire_nll_dataout, rbisten_tx, (rbist_sel[0] & (~ rbist_sel[1])));
	assign		wire_nll0i_dataout = (wire_n0iil_o === 1'b1) ? wire_nllli_o[4] : wire_nlliO_dataout;
	and(wire_nll0l_dataout, niOiO, ~{wire_n0iiO_o});
	and(wire_nll0O_dataout, niOli, ~{wire_n0iiO_o});
	assign		wire_nll1i_dataout = (wire_n0iil_o === 1'b1) ? wire_nllli_o[1] : wire_nll0O_dataout;
	assign		wire_nll1l_dataout = (wire_n0iil_o === 1'b1) ? wire_nllli_o[2] : wire_nllii_dataout;
	and(wire_nll1lO_dataout, (~ niiOil), n1l1i);
	assign		wire_nll1O_dataout = (wire_n0iil_o === 1'b1) ? wire_nllli_o[3] : wire_nllil_dataout;
	and(wire_nlli_dataout, nl10i, niiO0l);
	and(wire_nllii_dataout, niOll, ~{wire_n0iiO_o});
	and(wire_nllil_dataout, niOlO, ~{wire_n0iiO_o});
	and(wire_nlliO_dataout, niOOi, ~{wire_n0iiO_o});
	and(wire_nlll_dataout, nl10l, niiO0l);
	and(wire_nlllii_dataout, ni0l1l, ni0O0i);
	and(wire_nlllil_dataout, ni0l1l, ~{ni0O0i});
	and(wire_nllliO_dataout, wire_nlllOO_dataout, niiOil);
	and(wire_nlllli_dataout, wire_nllO1i_dataout, niiOil);
	assign		wire_nlllll_dataout = (niiOil === 1'b1) ? (~ ni0l0i) : wire_nlllOi_dataout;
	and(wire_nllllO_dataout, wire_nlllOl_dataout, ~{niiOil});
	assign		wire_nlllOi_dataout = (ni0O0i === 1'b1) ? (~ ni0l1l) : (~ ni0l1O);
	assign		wire_nlllOl_dataout = (ni0O0i === 1'b1) ? ni0l1l : ni0l1O;
	and(wire_nlllOO_dataout, ni0l0i, ni0O0i);
	and(wire_nllO_dataout, nl10O, niiO0l);
	and(wire_nllO0i_dataout, ni0lii, niiOil);
	and(wire_nllO0l_dataout, wire_nllOli_dataout, niiOil);
	and(wire_nllO0O_dataout, wire_nllOll_dataout, niiOil);
	and(wire_nllO1i_dataout, ni0l0i, ~{ni0O0i});
	assign		wire_nllO1l_dataout = (niiOil === 1'b1) ? ni0l0l : ni0l0O;
	assign		wire_nllO1O_dataout = (niiOil === 1'b1) ? (~ ni0l0l) : (~ ni0l0O);
	and(wire_nllOii_dataout, wire_nllOlO_dataout, niiOil);
	and(wire_nllOil_dataout, wire_nllOOi_dataout, niiOil);
	and(wire_nllOiO_dataout, wire_nllOOl_dataout, niiOil);
	and(wire_nllOli_dataout, wire_nllOOO_dataout, ~{ni0lii});
	and(wire_nllOll_dataout, wire_nlO11i_dataout, ~{ni0lii});
	and(wire_nllOlO_dataout, wire_nlO11l_dataout, ~{ni0lii});
	and(wire_nllOOi_dataout, wire_nlO11O_dataout, ~{ni0lii});
	and(wire_nllOOl_dataout, (~ ni0lil), ~{ni0lii});
	and(wire_nllOOO_dataout, ni0O0i, ni0lil);
	and(wire_nlO_dataout, rbisten_tx, (((~ rbist_sel[0]) & (~ rbist_sel[1])) & niiO0O8));
	and(wire_nlO00i_dataout, wire_nlO0iO_dataout, ~{ni0llO});
	and(wire_nlO00l_dataout, wire_nlO0li_dataout, ~{ni0lli});
	and(wire_nlO00O_dataout, wire_nlO0ll_dataout, ~{ni0lli});
	and(wire_nlO01i_dataout, wire_nlO00O_dataout, ~{ni0llO});
	and(wire_nlO01l_dataout, wire_nlO0ii_dataout, ~{ni0llO});
	and(wire_nlO01O_dataout, wire_nlO0il_dataout, ~{ni0llO});
	and(wire_nlO0ii_dataout, wire_nlO0lO_dataout, ~{ni0lli});
	and(wire_nlO0il_dataout, wire_nlO0Oi_dataout, ~{ni0lli});
	and(wire_nlO0iO_dataout, (~ ni0lll), ~{ni0lli});
	and(wire_nlO0li_dataout, ni0O0i, ni0lll);
	and(wire_nlO0ll_dataout, wire_nlO0Ol_dataout, ni0lll);
	and(wire_nlO0lO_dataout, wire_nlO0OO_dataout, ni0lll);
	and(wire_nlO0Oi_dataout, wire_nlOi1i_dataout, ni0lll);
	and(wire_nlO0Ol_dataout, ni0Oii, ~{ni0O0i});
	and(wire_nlO0OO_dataout, wire_nlOi1l_dataout, ~{ni0O0i});
	or(wire_nlO10i_dataout, (~ ni0liO), ~{niiOil});
	and(wire_nlO10l_dataout, ni0liO, niiOil);
	and(wire_nlO10O_dataout, wire_nlO1Ol_dataout, ~{niiOil});
	and(wire_nlO11i_dataout, wire_nlO0Ol_dataout, ni0lil);
	and(wire_nlO11l_dataout, wire_nlO0OO_dataout, ni0lil);
	and(wire_nlO11O_dataout, wire_nlOi1i_dataout, ni0lil);
	and(wire_nlO1ii_dataout, (~ ni0liO), niiOil);
	assign		wire_nlO1il_dataout = (niiOil === 1'b1) ? ni0liO : ni0llO;
	and(wire_nlO1iO_dataout, wire_nlO1OO_dataout, ~{niiOil});
	and(wire_nlO1li_dataout, wire_nlO01i_dataout, ~{niiOil});
	and(wire_nlO1ll_dataout, wire_nlO01l_dataout, ~{niiOil});
	and(wire_nlO1lO_dataout, wire_nlO01O_dataout, ~{niiOil});
	and(wire_nlO1Oi_dataout, wire_nlO00i_dataout, ~{niiOil});
	and(wire_nlO1Ol_dataout, ni0lli, ~{ni0llO});
	and(wire_nlO1OO_dataout, wire_nlO00l_dataout, ~{ni0llO});
	and(wire_nlOi_dataout, nl1ii, niiO0l);
	assign		wire_nlOi0l_dataout = (niiOil === 1'b1) ? wire_nlOl1l_dataout : wire_nlOiil_dataout;
	assign		wire_nlOi0O_dataout = (niiOil === 1'b1) ? wire_nlOl1O_dataout : wire_nlOiiO_dataout;
	and(wire_nlOi1i_dataout, wire_nlOi1O_dataout, ~{ni0O0i});
	and(wire_nlOi1l_dataout, ni0Oil, ~{ni0Oii});
	and(wire_nlOi1O_dataout, (~ ni0Oil), ~{ni0Oii});
	assign		wire_nlOiii_dataout = (niiOil === 1'b1) ? wire_nlOl0i_dataout : wire_nlOili_dataout;
	assign		wire_nlOiil_dataout = (ni0O0i === 1'b1) ? wire_nlOiOl_dataout : wire_nlOill_dataout;
	assign		wire_nlOiiO_dataout = (ni0O0i === 1'b1) ? wire_nlOiOO_dataout : wire_nlOilO_dataout;
	assign		wire_nlOili_dataout = (ni0O0i === 1'b1) ? wire_nlOl1i_dataout : wire_nlOiOi_dataout;
	and(wire_nlOill_dataout, ni0lOi, ~{ni0O1i});
	and(wire_nlOilO_dataout, (~ ni0lOi), ~{ni0O1i});
	or(wire_nlOiOi_dataout, ni0lOi, ni0O1i);
	and(wire_nlOiOl_dataout, ni0lOl, ~{ni0O1O});
	and(wire_nlOiOO_dataout, (~ ni0lOl), ~{ni0O1O});
	and(wire_nlOl_dataout, nl1il, niiO0l);
	assign		wire_nlOl0i_dataout = (ni0O0i === 1'b1) ? wire_nlOlli_dataout : wire_nlOlii_dataout;
	and(wire_nlOl0l_dataout, ni0O1i, ~{ni0lOO});
	and(wire_nlOl0O_dataout, (~ ni0O1i), ~{ni0lOO});
	or(wire_nlOl1i_dataout, ni0lOl, ni0O1O);
	assign		wire_nlOl1l_dataout = (ni0O0i === 1'b1) ? wire_nlOlil_dataout : wire_nlOl0l_dataout;
	assign		wire_nlOl1O_dataout = (ni0O0i === 1'b1) ? wire_nlOliO_dataout : wire_nlOl0O_dataout;
	or(wire_nlOlii_dataout, ni0O1i, ni0lOO);
	and(wire_nlOlil_dataout, ni0O1O, ~{ni0O1l});
	and(wire_nlOliO_dataout, (~ ni0O1O), ~{ni0O1l});
	or(wire_nlOlli_dataout, ni0O1O, ni0O1l);
	and(wire_nlOlll_dataout, (~ (ni0Oil | ni0Oii)), niiOil);
	and(wire_nlOllO_dataout, wire_nlOO1i_dataout, ~{niiOil});
	and(wire_nlOlOi_dataout, ni0O0i, ~{niiOil});
	or(wire_nlOlOl_dataout, wire_nlOO1l_dataout, niiOil);
	and(wire_nlOlOO_dataout, wire_nlOO1O_dataout, ~{niiOil});
	and(wire_nlOO_dataout, nl1iO, niiO0l);
	and(wire_nlOO0i_dataout, (~ ni0O0l), ni0O0O);
	and(wire_nlOO0l_dataout, ni0O0l, ni0O0O);
	and(wire_nlOO1i_dataout, wire_nlOO0i_dataout, ~{ni0O0i});
	and(wire_nlOO1l_dataout, wire_nlOO0l_dataout, ~{ni0O0i});
	and(wire_nlOO1O_dataout, (~ ni0O0O), ~{ni0O0i});
	oper_add   n00lO
	( 
	.a({n100l, n100i, n101O, n101l, n101i, n11OO, n11Ol, n11Oi, n11lO}),
	.b({{8{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n00lO_o));
	defparam
		n00lO.sgate_representation = 0,
		n00lO.width_a = 9,
		n00lO.width_b = 9,
		n00lO.width_o = 9;
	oper_add   n01il
	( 
	.a({n11ll, n11li, n11iO, n11il}),
	.b({{3{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n01il_o));
	defparam
		n01il.sgate_representation = 0,
		n01il.width_a = 4,
		n01il.width_b = 4,
		n01il.width_o = 4;
	oper_add   n1lOO
	( 
	.a({nlOOli, nlOOiO, nlOOil}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1lOO_o));
	defparam
		n1lOO.sgate_representation = 0,
		n1lOO.width_a = 3,
		n1lOO.width_b = 3,
		n1lOO.width_o = 3;
	oper_add   n1OOi
	( 
	.a({n111i, nlOOOO, nlOOOl, nlOOOi, nlOOlO, nlOOll}),
	.b({{5{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1OOi_o));
	defparam
		n1OOi.sgate_representation = 0,
		n1OOi.width_a = 6,
		n1OOi.width_b = 6,
		n1OOi.width_o = 6;
	oper_add   n1OOl
	( 
	.a({n11ii, n110l, n111O}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1OOl_o));
	defparam
		n1OOl.sgate_representation = 0,
		n1OOl.width_a = 3,
		n1OOl.width_b = 3,
		n1OOl.width_o = 3;
	oper_add   nli00O
	( 
	.a({nl00lO, nl00ll, nl00li, nl00iO, nl00il, nl00ii, nl000O}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli00O_o));
	defparam
		nli00O.sgate_representation = 0,
		nli00O.width_a = 7,
		nli00O.width_b = 7,
		nli00O.width_o = 7;
	oper_add   nli0ii
	( 
	.a({nl0i0i, nl0i1O, nl0i1l, nl0i1i, nl00OO, nl00Ol, nl00Oi}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0ii_o));
	defparam
		nli0ii.sgate_representation = 0,
		nli0ii.width_a = 7,
		nli0ii.width_b = 7,
		nli0ii.width_o = 7;
	oper_add   nli0il
	( 
	.a({nl0ilO, nl0ill, nl0ili, nl0iiO, nl0iil, nl0iii, nl0i0O, nl0i0l}),
	.b({{7{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0il_o));
	defparam
		nli0il.sgate_representation = 0,
		nli0il.width_a = 8,
		nli0il.width_b = 8,
		nli0il.width_o = 8;
	oper_add   nliOl
	( 
	.a({(niilli23 & niOil), niOii, niO0O}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nliOl_o));
	defparam
		nliOl.sgate_representation = 0,
		nliOl.width_a = 3,
		nliOl.width_b = 3,
		nliOl.width_o = 3;
	oper_add   nllli
	( 
	.a({niOOi, niOlO, niOll, (niilll20 & niOli), niOiO}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllli_o));
	defparam
		nllli.sgate_representation = 0,
		nllli.width_a = 5,
		nllli.width_b = 5,
		nllli.width_o = 5;
	oper_selector   n0iil
	( 
	.data({1'b0, wire_niili_dataout, (~ niii0l)}),
	.o(wire_n0iil_o),
	.sel({nii1il, nl0Ol, nli0l}));
	defparam
		n0iil.width_data = 3,
		n0iil.width_sel = 3;
	oper_selector   n0iiO
	( 
	.data({1'b0, wire_niiOO_dataout, niii0l}),
	.o(wire_n0iiO_o),
	.sel({nii1il, nl0Ol, nli0l}));
	defparam
		n0iiO.width_data = 3,
		n0iiO.width_sel = 3;
	oper_selector   n0ili
	( 
	.data({1'b0, wire_nilll_dataout, wire_nii0i_dataout, {2{(~ niii1l)}}}),
	.o(wire_n0ili_o),
	.sel({ni0OOi, nl01O, nli0O, nliil, nlili}));
	defparam
		n0ili.width_data = 5,
		n0ili.width_sel = 5;
	oper_selector   n0iOi
	( 
	.data({1'b0, niiOil}),
	.o(wire_n0iOi_o),
	.sel({ni0OOl, (~ ni0OOl)}));
	defparam
		n0iOi.width_data = 2,
		n0iOi.width_sel = 2;
	oper_selector   n0iOO
	( 
	.data({niiiil, 1'b0, wire_nii1l_dataout, wire_ni0OO_dataout}),
	.o(wire_n0iOO_o),
	.sel({n0iii, ni0OOO, nli0O, nlili}));
	defparam
		n0iOO.width_data = 4,
		n0iOO.width_sel = 4;
	oper_selector   n0l0i
	( 
	.data({1'b0, niiOil, wire_nillO_dataout, 1'b1, wire_niili_dataout, (~ niii0l)}),
	.o(wire_n0l0i_o),
	.sel({nii11l, nl01l, nl01O, nl00l, nl0Ol, nli0l}));
	defparam
		n0l0i.width_data = 6,
		n0l0i.width_sel = 6;
	oper_selector   n0l1l
	( 
	.data({(~ niiiil), (~ niiOil), wire_nilll_dataout, 1'b0, wire_nii1O_dataout, wire_nii1i_dataout}),
	.o(wire_n0l1l_o),
	.sel({n0iii, nl01l, nl01O, nii11i, nli0O, nlili}));
	defparam
		n0l1l.width_data = 6,
		n0l1l.width_sel = 6;
	oper_selector   n0lii
	( 
	.data({1'b0, niiOil, 1'b1}),
	.o(wire_n0lii_o),
	.sel({nii11O, nl00i, nl0ii}));
	defparam
		n0lii.width_data = 3,
		n0lii.width_sel = 3;
	oper_selector   n0lli
	( 
	.data({1'b0, niiOil, 1'b1}),
	.o(wire_n0lli_o),
	.sel({nii10i, nl00O, nl0iO}));
	defparam
		n0lli.width_data = 3,
		n0lli.width_sel = 3;
	oper_selector   n0lOi
	( 
	.data({1'b0, niiOil, 1'b1}),
	.o(wire_n0lOi_o),
	.sel({nii10l, nl0il, nl0ll}));
	defparam
		n0lOi.width_data = 3,
		n0lOi.width_sel = 3;
	oper_selector   n0O0i
	( 
	.data({1'b0, niiOil, 1'b1}),
	.o(wire_n0O0i_o),
	.sel({nii1ii, nl0lO, nl0OO}));
	defparam
		n0O0i.width_data = 3,
		n0O0i.width_sel = 3;
	oper_selector   n0O1i
	( 
	.data({1'b0, niiOil, 1'b1}),
	.o(wire_n0O1i_o),
	.sel({nii10O, nl0li, nl0Oi}));
	defparam
		n0O1i.width_data = 3,
		n0O1i.width_sel = 3;
	oper_selector   n0Oii
	( 
	.data({1'b0, wire_niill_dataout, wire_nil1i_dataout}),
	.o(wire_n0Oii_o),
	.sel({nii1il, nl0Ol, nli0l}));
	defparam
		n0Oii.width_data = 3,
		n0Oii.width_sel = 3;
	oper_selector   n0Oil
	( 
	.data({1'b0, wire_niilO_dataout, wire_nil1l_dataout}),
	.o(wire_n0Oil_o),
	.sel({nii1il, nl0Ol, nli0l}));
	defparam
		n0Oil.width_data = 3,
		n0Oil.width_sel = 3;
	oper_selector   n0OiO
	( 
	.data({1'b0, wire_niiOi_dataout, wire_nil1O_dataout}),
	.o(wire_n0OiO_o),
	.sel({nii1il, nl0Ol, nli0l}));
	defparam
		n0OiO.width_data = 3,
		n0OiO.width_sel = 3;
	oper_selector   n0Oli
	( 
	.data({1'b0, wire_niiOl_dataout, wire_nil0i_dataout}),
	.o(wire_n0Oli_o),
	.sel({nii1il, nl0Ol, nli0l}));
	defparam
		n0Oli.width_data = 3,
		n0Oli.width_sel = 3;
	oper_selector   n0OOi
	( 
	.data({1'b0, niiOil, 1'b1, wire_nii0i_dataout}),
	.o(wire_n0OOi_o),
	.sel({nii1iO, nli1i, (((nli0i | nli1l) | nli1O) | nliii), nli0O}));
	defparam
		n0OOi.width_data = 4,
		n0OOi.width_sel = 4;
	oper_selector   ni00l
	( 
	.data({1'b0, niiOil}),
	.o(wire_ni00l_o),
	.sel({nii00l, (~ nii00l)}));
	defparam
		ni00l.width_data = 2,
		ni00l.width_sel = 2;
	oper_selector   ni01i
	( 
	.data({1'b0, niiOil}),
	.o(wire_ni01i_o),
	.sel({nii01i, (~ nii01i)}));
	defparam
		ni01i.width_data = 2,
		ni01i.width_sel = 2;
	oper_selector   ni01O
	( 
	.data({1'b0, niiOil}),
	.o(wire_ni01O_o),
	.sel({nii00i, (~ nii00i)}));
	defparam
		ni01O.width_data = 2,
		ni01O.width_sel = 2;
	oper_selector   ni0ii
	( 
	.data({1'b0, niiOil}),
	.o(wire_ni0ii_o),
	.sel({nii0ii, (nii00O50 & (~ nii0ii))}));
	defparam
		ni0ii.width_data = 2,
		ni0ii.width_sel = 2;
	oper_selector   ni0iO
	( 
	.data({1'b0, niiOil}),
	.o(wire_ni0iO_o),
	.sel({nii0il, (~ nii0il)}));
	defparam
		ni0iO.width_data = 2,
		ni0iO.width_sel = 2;
	oper_selector   ni0ll
	( 
	.data({1'b0, niiOil}),
	.o(wire_ni0ll_o),
	.sel({(nii0iO47 & nii0ll), (nii0li44 & (~ nii0ll))}));
	defparam
		ni0ll.width_data = 2,
		ni0ll.width_sel = 2;
	oper_selector   ni0Oi
	( 
	.data({1'b0, wire_nilli_dataout, {5{niiOil}}, (nii0lO41 & niiOil), {2{niiOil}}}),
	.o(wire_ni0Oi_o),
	.sel({niii1i, nl01O, nl00i, nl0il, (nii0Oi38 & nl0lO), (nii0Ol35 & nli1i), nli1l, nli1O, nli0i, (nii0OO32 & nli0O)}));
	defparam
		ni0Oi.width_data = 10,
		ni0Oi.width_sel = 10;
	oper_selector   ni10i
	( 
	.data({1'b0, niii1l, (~ niii1l)}),
	.o(wire_ni10i_o),
	.sel({nii1ll, nliil, nlili}));
	defparam
		ni10i.width_data = 3,
		ni10i.width_sel = 3;
	oper_selector   ni11l
	( 
	.data({1'b0, wire_nii0l_dataout, (~ niii1l)}),
	.o(wire_ni11l_o),
	.sel({nii1li, nli0O, nliil}));
	defparam
		ni11l.width_data = 3,
		ni11l.width_sel = 3;
	oper_selector   ni1Ol
	( 
	.data({1'b0, niiOil}),
	.o(wire_ni1Ol_o),
	.sel({(nii1Ol56 & nii1OO), (~ nii1OO)}));
	defparam
		ni1Ol.width_data = 2,
		ni1Ol.width_sel = 2;
	oper_selector   nil00O
	( 
	.data({1'b0, 1'b1, wire_niO00l_dataout}),
	.o(wire_nil00O_o),
	.sel({nil10l, ni1lOl, nl0O1O}));
	defparam
		nil00O.width_data = 3,
		nil00O.width_sel = 3;
	oper_selector   nil01i
	( 
	.data({1'b0, 1'b1, niiOil, wire_niO01O_dataout}),
	.o(wire_nil01i_o),
	.sel({nil10l, ni1llO, nl0O1l, nl0O1O}));
	defparam
		nil01i.width_data = 4,
		nil01i.width_sel = 4;
	oper_selector   nil01O
	( 
	.data({1'b0, 1'b1, wire_niO00i_dataout}),
	.o(wire_nil01O_o),
	.sel({(nil10l | nl0OOi), ni1lOi, nl0O1O}));
	defparam
		nil01O.width_data = 3,
		nil01O.width_sel = 3;
	oper_selector   nil0il
	( 
	.data({1'b0, 1'b1, wire_niO00O_dataout}),
	.o(wire_nil0il_o),
	.sel({ni1O1i, ni1lOO, nl0O1O}));
	defparam
		nil0il.width_data = 3,
		nil0il.width_sel = 3;
	oper_selector   nil0ll
	( 
	.data({1'b0, (~ niiOil), wire_niO0ii_dataout, 1'b1}),
	.o(wire_nil0ll_o),
	.sel({ni1O1O, nl0O1l, nl0O1O, ni1O1l}));
	defparam
		nil0ll.width_data = 4,
		nil0ll.width_sel = 4;
	oper_selector   nil0Ol
	( 
	.data({1'b0, 1'b1, wire_niO0il_dataout}),
	.o(wire_nil0Ol_o),
	.sel({ni1O0l, ni1O0i, nl0O1O}));
	defparam
		nil0Ol.width_data = 3,
		nil0Ol.width_sel = 3;
	oper_selector   nil1il
	( 
	.data({1'b0, niiOil}),
	.o(wire_nil1il_o),
	.sel({ni1liO, (~ ni1liO)}));
	defparam
		nil1il.width_data = 2,
		nil1il.width_sel = 2;
	oper_selector   nil1li
	( 
	.data({1'b0, (~ niiOil), wire_niO01i_dataout, 1'b1}),
	.o(wire_nil1li_o),
	.sel({ni1lli, nl0O1l, nl0O1O, (nl0OOi | nil10O)}));
	defparam
		nil1li.width_data = 4,
		nil1li.width_sel = 4;
	oper_selector   nil1Oi
	( 
	.data({1'b0, (~ niiOil), wire_niO01l_dataout, 1'b1}),
	.o(wire_nil1Oi_o),
	.sel({ni1lll, nl0O1l, nl0O1O, (nl0Oll | nl0OOi)}));
	defparam
		nil1Oi.width_data = 4,
		nil1Oi.width_sel = 4;
	oper_selector   nili0i
	( 
	.data({1'b0, niiOil, wire_niO0iO_dataout, niiOil}),
	.o(wire_nili0i_o),
	.sel({ni1Oii, nl0O1l, nl0O1O, nl0OiO}));
	defparam
		nili0i.width_data = 4,
		nili0i.width_sel = 4;
	oper_selector   nili0O
	( 
	.data({1'b0, niiOil, wire_niO0li_dataout, {5{niiOil}}}),
	.o(wire_nili0O_o),
	.sel({ni1Oil, nl0O1i, nl0O1O, nl0O0i, nl0O0l, nl0Oii, nl0OiO, nl0Oll}));
	defparam
		nili0O.width_data = 8,
		nili0O.width_sel = 8;
	oper_selector   nili1l
	( 
	.data({1'b0, niiOil}),
	.o(wire_nili1l_o),
	.sel({ni1O0O, (~ ni1O0O)}));
	defparam
		nili1l.width_data = 2,
		nili1l.width_sel = 2;
	oper_selector   niliil
	( 
	.data({1'b0, {2{niiOil}}, wire_niO0ll_dataout, {4{niiOil}}}),
	.o(wire_niliil_o),
	.sel({ni1OiO, nl0O1i, nl0O1l, nl0O1O, nl0O0i, nl0O0l, nl0Oii, nl0Oll}));
	defparam
		niliil.width_data = 8,
		niliil.width_sel = 8;
	oper_selector   nilili
	( 
	.data({1'b0, {2{niiOil}}, wire_niO0lO_dataout, {5{niiOil}}}),
	.o(wire_nilili_o),
	.sel({ni1Oli, nl0O1i, nl0O1l, nl0O1O, nl0O0i, nl0O0l, nl0Oii, nl0OiO, nl0Oll}));
	defparam
		nilili.width_data = 9,
		nilili.width_sel = 9;
	oper_selector   nililO
	( 
	.data({1'b0, {2{niiOil}}, wire_niO0Oi_dataout, {4{niiOil}}}),
	.o(wire_nililO_o),
	.sel({ni1Oll, nl0O1i, nl0O1l, nl0O1O, nl0O0i, nl0O0l, nl0OiO, nl0Oll}));
	defparam
		nililO.width_data = 8,
		nililO.width_sel = 8;
	oper_selector   niliOl
	( 
	.data({1'b0, niiOil, wire_niO0Ol_dataout, {4{niiOil}}}),
	.o(wire_niliOl_o),
	.sel({ni1OlO, nl0O1l, nl0O1O, nl0O0l, nl0Oii, nl0OiO, nl0Oll}));
	defparam
		niliOl.width_data = 7,
		niliOl.width_sel = 7;
	oper_selector   nill0i
	( 
	.data({wire_nl01ii_dataout, wire_nl11lO_dataout, 1'b0, wire_niO11l_dataout, wire_nilOOO_dataout, wire_nlO_dataout}),
	.o(wire_nill0i_o),
	.sel({nil10l, nl0O1i, ni1OOl, nl0O1O, nl0Oll, nil10O}));
	defparam
		nill0i.width_data = 6,
		nill0i.width_sel = 6;
	oper_selector   nill0O
	( 
	.data({wire_nl01il_dataout, wire_nl11Oi_dataout, (~ wire_nlO_dataout), wire_niO11O_dataout, {10{(~ wire_nlO_dataout)}}}),
	.o(wire_nill0O_o),
	.sel({nil10l, nl0O1i, nl0O1l, nl0O1O, nl0O0i, nl0O0O, nl0O0l, nl0Oil, nl0Oii, nl0Oli, nl0OiO, nl0OOi, nl0Oll, nil10O}));
	defparam
		nill0O.width_data = 14,
		nill0O.width_sel = 14;
	oper_selector   nill1i
	( 
	.data({1'b0, {2{niiOil}}, wire_niO0OO_dataout, {3{niiOil}}}),
	.o(wire_nill1i_o),
	.sel({ni1OOi, nl0O1i, nl0O1l, nl0O1O, nl0Oii, nl0OiO, nl0Oll}));
	defparam
		nill1i.width_data = 7,
		nill1i.width_sel = 7;
	oper_selector   nillii
	( 
	.data({wire_nl01iO_dataout, wire_nl11Ol_dataout, 1'b0, wire_niO10i_dataout}),
	.o(wire_nillii_o),
	.sel({nil10l, nl0O1i, ni011i, nl0O1O}));
	defparam
		nillii.width_data = 4,
		nillii.width_sel = 4;
	oper_selector   nillil
	( 
	.data({wire_nl01li_dataout, wire_nl11OO_dataout, wire_nlO_dataout, wire_niO10l_dataout, 1'b0}),
	.o(wire_nillil_o),
	.sel({nil10l, nl0O1i, nl0O1l, nl0O1O, ni1OOO}));
	defparam
		nillil.width_data = 5,
		nillil.width_sel = 5;
	oper_selector   nillli
	( 
	.data({wire_nl01ll_dataout, wire_nl101i_dataout, 1'b0, wire_niO10O_dataout}),
	.o(wire_nillli_o),
	.sel({nil10l, nl0O1i, ni011i, nl0O1O}));
	defparam
		nillli.width_data = 4,
		nillli.width_sel = 4;
	oper_selector   nilllO
	( 
	.data({wire_nl01lO_dataout, wire_nl101l_dataout, 1'b0, wire_niO1ii_dataout, wire_nilOOO_dataout, wire_nlO_dataout}),
	.o(wire_nilllO_o),
	.sel({nil10l, nl0O1i, ni011l, nl0O1O, nl0O0i, nl0O0O}));
	defparam
		nilllO.width_data = 6,
		nilllO.width_sel = 6;
	oper_selector   nillOl
	( 
	.data({wire_nl01Oi_dataout, wire_nl101O_dataout, 1'b0, wire_niO1il_dataout, wire_niO11i_dataout}),
	.o(wire_nillOl_o),
	.sel({nil10l, nl0O1i, ni011O, nl0O1O, nl0O0i}));
	defparam
		nillOl.width_data = 5,
		nillOl.width_sel = 5;
	oper_selector   nilO0l
	( 
	.data({wire_nl001i_dataout, wire_nl100O_dataout, 1'b0, wire_niO1ll_dataout, wire_nilOOO_dataout, wire_nlO_dataout}),
	.o(wire_nilO0l_o),
	.sel({nil10l, nl0O1i, ni010O, nl0O1O, nl0Oii, nl0Oli}));
	defparam
		nilO0l.width_data = 6,
		nilO0l.width_sel = 6;
	oper_selector   nilO1i
	( 
	.data({wire_nl01Ol_dataout, wire_nl100i_dataout, 1'b0, wire_niO1iO_dataout, wire_nilOOO_dataout, wire_nlO_dataout}),
	.o(wire_nilO1i_o),
	.sel({nil10l, nl0O1i, ni010i, nl0O1O, nl0O0l, nl0Oil}));
	defparam
		nilO1i.width_data = 6,
		nilO1i.width_sel = 6;
	oper_selector   nilO1O
	( 
	.data({wire_nl01OO_dataout, wire_nl100l_dataout, 1'b0, wire_niO1li_dataout, wire_niO11i_dataout}),
	.o(wire_nilO1O_o),
	.sel({nil10l, nl0O1i, ni010l, nl0O1O, nl0O0l}));
	defparam
		nilO1O.width_data = 5,
		nilO1O.width_sel = 5;
	oper_selector   nilOii
	( 
	.data({wire_nl001l_dataout, wire_nl10ii_dataout, 1'b0, wire_niO1lO_dataout, wire_niO11i_dataout}),
	.o(wire_nilOii_o),
	.sel({nil10l, nl0O1i, ni01ii, nl0O1O, nl0Oii}));
	defparam
		nilOii.width_data = 5,
		nilOii.width_sel = 5;
	oper_selector   nilOiO
	( 
	.data({wire_nl001O_dataout, wire_nl10il_dataout, 1'b0, wire_niO1Oi_dataout, wire_nilOOO_dataout, wire_nlO_dataout}),
	.o(wire_nilOiO_o),
	.sel({nil10l, nl0O1i, ni01il, nl0O1O, nl0OiO, nl0OOi}));
	defparam
		nilOiO.width_data = 6,
		nilOiO.width_sel = 6;
	oper_selector   nilOll
	( 
	.data({wire_nl000i_dataout, wire_nl10iO_dataout, 1'b0, wire_niO1Ol_dataout, wire_niO11i_dataout}),
	.o(wire_nilOll_o),
	.sel({nil10l, nl0O1i, ni01iO, nl0O1O, nl0OiO}));
	defparam
		nilOll.width_data = 5,
		nilOll.width_sel = 5;
	oper_selector   nilOOi
	( 
	.data({wire_nl000l_dataout, wire_nl10li_dataout, 1'b0, wire_niO1OO_dataout, wire_niO11i_dataout}),
	.o(wire_nilOOi_o),
	.sel({nil10l, nl0O1i, ni01li, nl0O1O, nl0Oll}));
	defparam
		nilOOi.width_data = 5,
		nilOOi.width_sel = 5;
	oper_selector   nlillO
	( 
	.data({1'b0, wire_nlOllO_dataout, wire_nlllll_dataout, {2{(~ ni0l1l)}}}),
	.o(wire_nlillO_o),
	.sel({ni001i, n1ili, n1lii, n1liO, n1lll}));
	defparam
		nlillO.width_data = 5,
		nlillO.width_sel = 5;
	oper_selector   nlilOO
	( 
	.data({1'b0, niiOil}),
	.o(wire_nlilOO_o),
	.sel({ni001l, (~ ni001l)}));
	defparam
		nlilOO.width_data = 2,
		nlilOO.width_sel = 2;
	oper_selector   nliO0i
	( 
	.data({(~ ni0O0i), (~ niiOil), wire_nlOllO_dataout, 1'b0, wire_nlllli_dataout, wire_nlllil_dataout}),
	.o(wire_nliO0i_o),
	.sel({nlil0l, n1iiO, n1ili, ni000i, n1lii, n1lll}));
	defparam
		nliO0i.width_data = 6,
		nliO0i.width_sel = 6;
	oper_selector   nliO0O
	( 
	.data({1'b0, niiOil, wire_nlOlOi_dataout}),
	.o(wire_nliO0O_o),
	.sel({ni000l, n1iiO, n1ili}));
	defparam
		nliO0O.width_data = 3,
		nliO0O.width_sel = 3;
	oper_selector   nliO1l
	( 
	.data({ni0O0i, 1'b0, wire_nllliO_dataout, wire_nlllii_dataout}),
	.o(wire_nliO1l_o),
	.sel({nlil0l, ni001O, n1lii, n1lll}));
	defparam
		nliO1l.width_data = 4,
		nliO1l.width_sel = 4;
	oper_selector   nliOil
	( 
	.data({1'b0, wire_nlOlOl_dataout, 1'b1, wire_nlOi0O_dataout, wire_nlO10O_dataout, wire_nllO0i_dataout}),
	.o(wire_nliOil_o),
	.sel({ni000O, n1ili, (n1iOi | n1ill), n1ilO, n1iOl, n1l0l}));
	defparam
		nliOil.width_data = 6,
		nliOil.width_sel = 6;
	oper_selector   nliOlO
	( 
	.data({1'b0, wire_nlOiii_dataout, wire_nlO1ii_dataout, (~ niiOil)}),
	.o(wire_nliOlO_o),
	.sel({ni00ii, n1ilO, n1iOl, n1l0l}));
	defparam
		nliOlO.width_data = 4,
		nliOlO.width_sel = 4;
	oper_selector   nliOOO
	( 
	.data({1'b0, wire_nlO1iO_dataout, wire_nllO0l_dataout}),
	.o(wire_nliOOO_o),
	.sel({ni00il, n1iOl, n1l0l}));
	defparam
		nliOOO.width_data = 3,
		nliOOO.width_sel = 3;
	oper_selector   nll00l
	( 
	.data({1'b0, 1'b1, (~ niiOil)}),
	.o(wire_nll00l_o),
	.sel({ni0i1l, ni0i1i, n1iOO}));
	defparam
		nll00l.width_data = 3,
		nll00l.width_sel = 3;
	oper_selector   nll01l
	( 
	.data({1'b0, 1'b1, (~ niiOil)}),
	.o(wire_nll01l_o),
	.sel({ni00OO, ni00Ol, n1iOO}));
	defparam
		nll01l.width_data = 3,
		nll01l.width_sel = 3;
	oper_selector   nll0il
	( 
	.data({1'b0, 1'b1, niiOil}),
	.o(wire_nll0il_o),
	.sel({ni0i0i, ni0i1O, n1iOO}));
	defparam
		nll0il.width_data = 3,
		nll0il.width_sel = 3;
	oper_selector   nll0ll
	( 
	.data({1'b0, 1'b1, (~ niiOil)}),
	.o(wire_nll0ll_o),
	.sel({ni0i0O, ni0i0l, n1iOO}));
	defparam
		nll0ll.width_data = 3,
		nll0ll.width_sel = 3;
	oper_selector   nll0Ol
	( 
	.data({1'b0, 1'b1, niiOil}),
	.o(wire_nll0Ol_o),
	.sel({(((nlil0l | n1l0l) | n1l0i) | n1ill), ni0iii, n1iOO}));
	defparam
		nll0Ol.width_data = 3,
		nll0Ol.width_sel = 3;
	oper_selector   nll10l
	( 
	.data({1'b0, wire_nlO1Oi_dataout, wire_nllOiO_dataout, wire_nllO1l_dataout}),
	.o(wire_nll10l_o),
	.sel({ni00iO, n1iOl, n1l0l, n1l0O}));
	defparam
		nll10l.width_data = 4,
		nll10l.width_sel = 4;
	oper_selector   nll11i
	( 
	.data({1'b0, wire_nlO1li_dataout, wire_nllO0O_dataout}),
	.o(wire_nll11i_o),
	.sel({ni00il, n1iOl, n1l0l}));
	defparam
		nll11i.width_data = 3,
		nll11i.width_sel = 3;
	oper_selector   nll11l
	( 
	.data({1'b0, wire_nlO1ll_dataout, wire_nllOii_dataout}),
	.o(wire_nll11l_o),
	.sel({ni00il, n1iOl, n1l0l}));
	defparam
		nll11l.width_data = 3,
		nll11l.width_sel = 3;
	oper_selector   nll11O
	( 
	.data({1'b0, wire_nlO1lO_dataout, wire_nllOil_dataout}),
	.o(wire_nll11O_o),
	.sel({ni00il, n1iOl, n1l0l}));
	defparam
		nll11O.width_data = 3,
		nll11O.width_sel = 3;
	oper_selector   nll1ii
	( 
	.data({1'b0, 1'b1, wire_nllO1O_dataout}),
	.o(wire_nll1ii_o),
	.sel({ni00li, n1iOO, n1l0O}));
	defparam
		nll1ii.width_data = 3,
		nll1ii.width_sel = 3;
	oper_selector   nll1iO
	( 
	.data({1'b0, niiOil, 1'b1, wire_nlllll_dataout}),
	.o(wire_nll1iO_o),
	.sel({ni00ll, n1l1i, (((n1l1O | n1lil) | n1l0i) | n1l1l), n1lii}));
	defparam
		nll1iO.width_data = 4,
		nll1iO.width_sel = 4;
	oper_selector   nll1Oi
	( 
	.data({1'b0, wire_nllllO_dataout, (~ ni0l1l)}),
	.o(wire_nll1Oi_o),
	.sel({ni00lO, n1lii, n1liO}));
	defparam
		nll1Oi.width_data = 3,
		nll1Oi.width_sel = 3;
	oper_selector   nll1OO
	( 
	.data({1'b0, ni0l1l, (~ ni0l1l)}),
	.o(wire_nll1OO_o),
	.sel({ni00Oi, n1liO, n1lll}));
	defparam
		nll1OO.width_data = 3,
		nll1OO.width_sel = 3;
	oper_selector   nlli1O
	( 
	.data({1'b0, 1'b1, niiOil}),
	.o(wire_nlli1O_o),
	.sel({ni0iiO, ni0iil, n1iOO}));
	defparam
		nlli1O.width_data = 3,
		nlli1O.width_sel = 3;
	oper_selector   nlliii
	( 
	.data({1'b0, niiOil}),
	.o(wire_nlliii_o),
	.sel({ni0ili, (~ ni0ili)}));
	defparam
		nlliii.width_data = 2,
		nlliii.width_sel = 2;
	oper_selector   nlliiO
	( 
	.data({1'b0, niiOil}),
	.o(wire_nlliiO_o),
	.sel({ni0ill, (~ ni0ill)}));
	defparam
		nlliiO.width_data = 2,
		nlliiO.width_sel = 2;
	oper_selector   nllill
	( 
	.data({1'b0, niiOil}),
	.o(wire_nllill_o),
	.sel({ni0iOi, (~ ni0iOi)}));
	defparam
		nllill.width_data = 2,
		nllill.width_sel = 2;
	oper_selector   nllilO
	( 
	.data({1'b0, niiOil}),
	.o(wire_nllilO_o),
	.sel({ni0ilO, (~ ni0ilO)}));
	defparam
		nllilO.width_data = 2,
		nllilO.width_sel = 2;
	oper_selector   nlliOl
	( 
	.data({1'b0, niiOil}),
	.o(wire_nlliOl_o),
	.sel({ni0iOi, (~ ni0iOi)}));
	defparam
		nlliOl.width_data = 2,
		nlliOl.width_sel = 2;
	oper_selector   nlll0l
	( 
	.data({1'b0, wire_nlOlll_dataout, {9{niiOil}}}),
	.o(wire_nlll0l_o),
	.sel({ni0l1i, n1ili, n1iOl, n1l0l, n1iOO, n1l0O, n1l1i, n1l1l, n1l1O, n1l0i, n1lii}));
	defparam
		nlll0l.width_data = 11,
		nlll0l.width_sel = 11;
	oper_selector   nlll1i
	( 
	.data({1'b0, niiOil}),
	.o(wire_nlll1i_o),
	.sel({ni0iOl, (~ ni0iOl)}));
	defparam
		nlll1i.width_data = 2,
		nlll1i.width_sel = 2;
	oper_selector   nlll1O
	( 
	.data({1'b0, niiOil}),
	.o(wire_nlll1O_o),
	.sel({ni0iOO, (~ ni0iOO)}));
	defparam
		nlll1O.width_data = 2,
		nlll1O.width_sel = 2;
	assign
		bist_ctl_sg = {wire_ni1O_dataout, wire_ni1l_dataout},
		bist_data_sg = {wire_ni1i_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout, wire_n0lO_dataout, wire_n0ll_dataout, wire_n0li_dataout, wire_n0iO_dataout, wire_n0il_dataout, wire_n0ii_dataout, wire_n00O_dataout, wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout},
		ni000i = ((((((((((((n1liO | n1l1O) | n1iOl) | n1ilO) | n1lil) | n1l0O) | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOi) | n1ill) | n1iOO),
		ni000l = (((((((((((((((n1lll | n1liO) | n1lii) | n1l1O) | n1iOl) | n1ilO) | nlil0l) | n1lil) | n1l0O) | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOi) | n1ill) | n1iOO),
		ni000O = (((((((((((n1lll | n1liO) | n1lii) | n1l1O) | nlil0l) | n1lil) | n1l0O) | n1l0i) | n1l1l) | n1l1i) | n1iiO) | n1iOO),
		ni001i = (((((((((((((n1l1O | n1iOl) | n1ilO) | nlil0l) | n1lil) | n1l0O) | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOi) | n1ill) | n1iiO) | n1iOO),
		ni001l = ((((((((((((n1lll | n1liO) | n1iOl) | n1ilO) | nlil0l) | n1lil) | n1l0O) | n1l0l) | n1iOi) | n1ill) | n1ili) | n1iiO) | n1iOO),
		ni001O = ((((((((((((((n1liO | n1l1O) | n1iOl) | n1ilO) | n1lil) | n1l0O) | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOi) | n1ill) | n1ili) | n1iiO) | n1iOO),
		ni00ii = ((((((((((((((n1lll | n1liO) | n1lii) | n1l1O) | nlil0l) | n1lil) | n1l0O) | n1l0i) | n1l1l) | n1l1i) | n1iOi) | n1ill) | n1ili) | n1iiO) | n1iOO),
		ni00il = (((((((((((((((n1lll | n1liO) | n1lii) | n1l1O) | n1ilO) | nlil0l) | n1lil) | n1l0O) | n1l0i) | n1l1l) | n1l1i) | n1iOi) | n1ill) | n1ili) | n1iiO) | n1iOO),
		ni00iO = ((((((((((((((n1lll | n1liO) | n1lii) | n1l1O) | n1ilO) | nlil0l) | n1lil) | n1l0i) | n1l1l) | n1l1i) | n1iOi) | n1ill) | n1ili) | n1iiO) | n1iOO),
		ni00li = (((((((((((((((n1lll | n1liO) | n1lii) | n1l1O) | n1iOl) | n1ilO) | nlil0l) | n1lil) | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOi) | n1ill) | n1ili) | n1iiO),
		ni00ll = (((((((((((n1lll | n1liO) | n1iOl) | n1ilO) | nlil0l) | n1l0O) | n1l0l) | n1iOi) | n1ill) | n1ili) | n1iiO) | n1iOO),
		ni00lO = (((((((((((((((n1lll | n1l1O) | n1iOl) | n1ilO) | nlil0l) | n1lil) | n1l0O) | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOi) | n1ill) | n1ili) | n1iiO) | n1iOO),
		ni00Oi = (((((((((((((((n1lii | n1l1O) | n1iOl) | n1ilO) | nlil0l) | n1lil) | n1l0O) | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOi) | n1ill) | n1ili) | n1iiO) | n1iOO),
		ni00Ol = (((((((((n1lil | n1l0O) | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOi) | n1ill) | n1ili) | n1iiO),
		ni00OO = ((((((n1lll | n1liO) | n1lii) | n1l1O) | n1iOl) | n1ilO) | nlil0l),
		ni010i = ((((((((nl0Oll | nl0Oli) | nl0OiO) | nl0Oii) | nl0O0O) | nl0O0i) | nl0OOi) | nil10O) | nl0O1l),
		ni010l = (((((((((nl0Oll | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0i) | nl0OOi) | nil10O) | nl0O1l),
		ni010O = ((((((((nl0Oll | nl0OiO) | nl0Oil) | nl0O0O) | nl0O0l) | nl0O0i) | nl0OOi) | nil10O) | nl0O1l),
		ni011i = ((((((((((nl0Oll | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0OOi) | nil10O) | nl0O1l),
		ni011l = ((((((((nl0Oll | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0l) | nl0OOi) | nil10O) | nl0O1l),
		ni011O = (((((((((nl0Oll | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0OOi) | nil10O) | nl0O1l),
		ni01ii = (((((((((nl0Oll | nl0Oli) | nl0OiO) | nl0Oil) | nl0O0O) | nl0O0l) | nl0O0i) | nl0OOi) | nil10O) | nl0O1l),
		ni01il = ((((((((nl0Oll | nl0Oli) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nil10O) | nl0O1l),
		ni01iO = (((((((((nl0Oll | nl0Oli) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0OOi) | nil10O) | nl0O1l),
		ni01li = (((((((((nl0Oli | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0OOi) | nil10O) | nl0O1l),
		ni01ll = (((((((nl0i0l & nl0i0O) & nl0iii) & nl0iil) & nl0iiO) & nl0ili) & nl0ill) & nl0ilO),
		ni01lO = ((((((nl000O & nl00ii) & nl00il) & nl00iO) & nl00li) & nl00ll) & nl00lO),
		ni01Oi = ((((((((~ nl0i0l) & (~ nl0i0O)) & (~ nl0iii)) & (~ nl0iil)) & nl0iiO) & (~ nl0ili)) & (~ nl0ill)) & (~ nl0ilO)),
		ni01Ol = (((((((nl0i0l & nl0i0O) & nl0iii) & (~ nl0iil)) & (~ nl0iiO)) & (~ nl0ili)) & (~ nl0ill)) & (~ nl0ilO)),
		ni01OO = (nl0O1i | nl0O1O),
		ni0i0i = ((((nlil0l | n1l0l) | n1l0i) | n1ill) | n1iiO),
		ni0i0l = (((((((((((n1lll | n1liO) | n1lii) | n1l1O) | n1ilO) | n1lil) | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1ill) | n1iiO),
		ni0i0O = ((((n1iOl | nlil0l) | n1l0O) | n1iOi) | n1ili),
		ni0i1i = ((((((n1l1O | n1ilO) | n1l0l) | n1l0i) | n1l1l) | n1ill) | n1iiO),
		ni0i1l = (((((((((n1lll | n1liO) | n1lii) | n1iOl) | nlil0l) | n1lil) | n1l0O) | n1l1i) | n1iOi) | n1ili),
		ni0i1O = (((((((((((n1lll | n1liO) | n1lii) | n1l1O) | n1iOl) | n1ilO) | n1lil) | n1l0O) | n1l1l) | n1l1i) | n1iOi) | n1ili),
		ni0iii = ((((((((((((n1lll | n1liO) | n1lii) | n1l1O) | n1iOl) | n1ilO) | n1lil) | n1l0O) | n1l1l) | n1l1i) | n1iOi) | n1ili) | n1iiO),
		ni0iil = (((((((n1liO | n1iOl) | n1ilO) | n1lil) | n1l0l) | n1iOi) | n1ili) | n1iiO),
		ni0iiO = ((((((((n1lll | n1lii) | n1l1O) | nlil0l) | n1l0O) | n1l0i) | n1l1l) | n1l1i) | n1ill),
		ni0ili = (((((((((((n1lll | n1liO) | n1lii) | n1l1O) | n1ilO) | nlil0l) | n1lil) | n1l0l) | n1l0i) | n1l1l) | n1iOi) | n1ill),
		ni0ill = (((((((((((((n1lll | n1liO) | n1lii) | n1l1O) | nlil0l) | n1lil) | n1l0O) | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOi) | n1ili) | n1iiO),
		ni0ilO = ((((((((n1lll | n1liO) | nlil0l) | n1lil) | n1l0O) | n1l0l) | n1iOi) | n1ili) | n1iiO),
		ni0iOi = ((((((n1lll | n1liO) | n1iOl) | nlil0l) | n1lil) | n1iOi) | n1iOO),
		ni0iOl = ((((((n1lll | n1liO) | nlil0l) | n1lil) | n1iOi) | n1ili) | n1iiO),
		ni0iOO = ((((((((((n1lll | n1liO) | n1lii) | n1l1O) | nlil0l) | n1lil) | n1l0O) | n1l0i) | n1l1l) | n1iOi) | n1iOO),
		ni0l0i = (((~ nlOOli) & nlOOiO) & (~ nlOOil)),
		ni0l0l = ((((((~ n111i) & nlOOOO) & (~ nlOOOl)) & (~ nlOOOi)) & nlOOlO) & nlOOll),
		ni0l0O = (((((n111i & (~ nlOOOO)) & (~ nlOOOl)) & nlOOOi) & nlOOlO) & nlOOll),
		ni0l1i = (((((((n1lll | n1liO) | n1ilO) | nlil0l) | n1lil) | n1iOi) | n1ill) | n1iiO),
		ni0l1l = ((nlOOli & (~ nlOOiO)) & nlOOil),
		ni0l1O = ((nlOOli & nlOOiO) & (~ nlOOil)),
		ni0lii = (((~ n11ii) & n110l) & n111O),
		ni0lil = ((n11ii & n110l) & n111O),
		ni0liO = ((((~ n11ll) & (~ n11li)) & n11iO) & (~ n11il)),
		ni0lli = ((((~ n11ll) & n11li) & n11iO) & n11il),
		ni0lll = (((n11ll & n11li) & n11iO) & n11il),
		ni0llO = (((((~ n11ll) & (~ n11li)) & n11iO) & n11il) | (((n11ll & (~ n11li)) & n11iO) & n11il)),
		ni0lOi = ((((((((n100l & (~ n100i)) & (~ n101O)) & (~ n101l)) & (~ n101i)) & (~ n11OO)) & n11Ol) & n11Oi) & n11lO),
		ni0lOl = ((((((((n100l & (~ n100i)) & (~ n101O)) & (~ n101l)) & (~ n101i)) & (~ n11OO)) & n11Ol) & n11Oi) & (~ n11lO)),
		ni0lOO = (((((((((~ n100l) & (~ n100i)) & n101O) & (~ n101l)) & (~ n101i)) & (~ n11OO)) & (~ n11Ol)) & (~ n11Oi)) & n11lO),
		ni0O0i = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		ni0O0l = (((~ nlOOli) & (~ nlOOiO)) & nlOOil),
		ni0O0O = (ni0Oil | ni0Oii),
		ni0O1i = (((((((((~ n100l) & n100i) & (~ n101O)) & (~ n101l)) & (~ n101i)) & (~ n11OO)) & (~ n11Ol)) & n11Oi) & n11lO),
		ni0O1l = (((((((((~ n100l) & (~ n100i)) & n101O) & (~ n101l)) & (~ n101i)) & (~ n11OO)) & (~ n11Ol)) & (~ n11Oi)) & (~ n11lO)),
		ni0O1O = (((((((((~ n100l) & n100i) & (~ n101O)) & (~ n101l)) & (~ n101i)) & (~ n11OO)) & (~ n11Ol)) & n11Oi) & (~ n11lO)),
		ni0Oii = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		ni0Oil = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		ni0OiO = ((((n1lll | n1liO) | n1lii) | n1lil) | n1iiO),
		ni0Oli = ((((((n1lll | n1l1O) | nlil0l) | n1l1l) | n1iOi) | n1ill) | n1ili),
		ni0Oll = ((((((n1lll | n1liO) | n1l1O) | n1ilO) | nlil0l) | n1ill) | n1ili),
		ni0OlO = 1'b0,
		ni0OOi = (((((((((((((((((((nli1i | nl0Oi) | nl0lO) | nl00i) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl01l) | nli0l) | nli0i) | nli1l) | nli1O) | nl0Ol) | nl00l) | nliii),
		ni0OOl = ((((((((((((((((((nlili | nliil) | nl0Oi) | nl0lO) | nl00i) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl01l) | nli0l) | nl0Ol) | nl00l) | nl01O) | nliii),
		ni0OOO = ((((((((((((((((((((nliil | nli1i) | nl0Oi) | nl0lO) | nl00i) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl01l) | nli0l) | nli0i) | nli1l) | nli1O) | nl0Ol) | nl00l) | nl01O) | nliii),
		ni1liO = ((((((nl0Oli | nl0Oil) | nl0O0O) | nil10l) | nl0OOi) | nil10O) | nl0O1O),
		ni1lli = (((((((((nl0Oll | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1i) | nil10l),
		ni1lll = (((((((((nl0Oli | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1i) | nil10l) | nil10O),
		ni1llO = ((((((((((nl0Oll | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1i) | nl0OOi) | nil10O),
		ni1lOi = ((((((((((nl0Oll | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1i) | nil10O) | nl0O1l),
		ni1lOl = (((((((((((nl0Oll | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1i) | nl0OOi) | nil10O) | nl0O1l),
		ni1lOO = (((((((nl0Oll | nl0OiO) | nl0Oil) | nl0O0O) | nl0O1i) | nl0OOi) | nil10O) | nl0O1l),
		ni1O0i = (((((((nl0Oll | nl0Oli) | nl0OiO) | nl0Oii) | nl0O1i) | nl0OOi) | nil10O) | nl0O1l),
		ni1O0l = ((((nl0Oil | nl0O0O) | nl0O0l) | nl0O0i) | nil10l),
		ni1O0O = (((((((((nl0Oli | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1i) | nil10l) | nl0OOi) | nil10O),
		ni1O1i = ((((nl0Oli | nl0Oii) | nl0O0l) | nl0O0i) | nil10l),
		ni1O1l = ((((((nl0Oll | nl0Oli) | nl0OiO) | nl0Oil) | nl0O0l) | nl0OOi) | nil10O),
		ni1O1O = ((((nl0Oii | nl0O0O) | nl0O0i) | nl0O1i) | nil10l),
		ni1Oii = ((((((((((nl0Oll | nl0Oli) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1i) | nil10l) | nl0OOi) | nil10O),
		ni1Oil = ((((((nl0Oli | nl0Oil) | nl0O0O) | nil10l) | nl0OOi) | nil10O) | nl0O1l),
		ni1OiO = ((((((nl0Oli | nl0OiO) | nl0Oil) | nl0O0O) | nil10l) | nl0OOi) | nil10O),
		ni1Oli = (((((nl0Oli | nl0Oil) | nl0O0O) | nil10l) | nl0OOi) | nil10O),
		ni1Oll = ((((((nl0Oli | nl0Oil) | nl0Oii) | nl0O0O) | nil10l) | nl0OOi) | nil10O),
		ni1OlO = (((((((nl0Oli | nl0Oil) | nl0O0O) | nl0O0i) | nl0O1i) | nil10l) | nl0OOi) | nil10O),
		ni1OOi = (((((((nl0Oli | nl0Oil) | nl0O0O) | nl0O0l) | nl0O0i) | nil10l) | nl0OOi) | nil10O),
		ni1OOl = ((((((((nl0Oli | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0OOi) | nl0O1l),
		ni1OOO = (((((((((nl0Oll | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0OOi) | nil10O),
		nii00i = ((((((((((((nlili | nliil) | nl0Oi) | nl0lO) | n0iii) | nl0OO) | nl0ll) | nl0iO) | nl0ii) | nli0l) | nl0Ol) | nl00l) | nliii),
		nii00l = (((((((((((((((nlili | nliil) | nl0Oi) | nl00i) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0ii) | nl00O) | nl01l) | nli0l) | nl00l) | nl01O) | nliii),
		nii01i = ((((((((((((((((((((nlili | nliil) | nli0O) | nli1i) | nl0Oi) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0ii) | nl01l) | nli0l) | nli0i) | nli1l) | nli1O) | nl0Ol) | nl00l) | nl01O) | nliii) | (~ nii01l53)),
		nii0ii = ((((((((((((nlili | nliil) | nl0Oi) | n0iii) | nl0OO) | nl0ll) | nl0iO) | nl0il) | nl0ii) | nl00O) | nli0l) | nl00l) | nliii),
		nii0il = (((((((((((((((((nlili | nliil) | nl0Oi) | nl00i) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl01l) | nli0l) | nl0Ol) | nl00l) | nl01O) | nliii),
		nii0ll = ((((((((((((((((nlili | nliil) | nli0O) | nl0Oi) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nli0l) | nli0i) | nli1l) | nli1O) | nl00l) | nliii),
		nii10i = (((((((((((((((((((((nlili | nliil) | nli0O) | nli1i) | nl0Oi) | nl0lO) | nl00i) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0il) | nl0ii) | nl01l) | nli0l) | nli0i) | nli1l) | nli1O) | nl0Ol) | nl00l) | nl01O) | nliii),
		nii10l = (((((((((((((((((((((nlili | nliil) | nli0O) | nli1i) | nl0Oi) | nl0lO) | nl00i) | n0iii) | nl0OO) | nl0li) | nl0iO) | nl0ii) | nl00O) | nl01l) | nli0l) | nli0i) | nli1l) | nli1O) | nl0Ol) | nl00l) | nl01O) | nliii),
		nii10O = (((((((((((((((((((((nlili | nliil) | nli0O) | nli1i) | nl0lO) | nl00i) | n0iii) | nl0OO) | nl0ll) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl01l) | nli0l) | nli0i) | nli1l) | nli1O) | nl0Ol) | nl00l) | nl01O) | nliii),
		nii11i = ((((((((((((((((((nliil | nli1i) | nl0Oi) | nl0lO) | nl00i) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nli0l) | nli0i) | nli1l) | nli1O) | nl0Ol) | nl00l) | nliii),
		nii11l = ((((((((((((((((((nlili | nliil) | nli0O) | nli1i) | nl0Oi) | nl0lO) | nl00i) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nli0i) | nli1l) | nli1O) | nliii),
		nii11O = (((((((((((((((((((((nlili | nliil) | nli0O) | nli1i) | nl0Oi) | nl0lO) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl00O) | nl01l) | nli0l) | nli0i) | nli1l) | nli1O) | nl0Ol) | nl00l) | nl01O) | nliii),
		nii1ii = (((((((((((((((((((((nlili | nliil) | nli0O) | nli1i) | nl0Oi) | nl00i) | n0iii) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl01l) | nli0l) | nli0i) | nli1l) | nli1O) | nl0Ol) | nl00l) | nl01O) | nliii),
		nii1il = (((((((((((((((((((((nlili | nliil) | nli0O) | nli1i) | nl0Oi) | nl0lO) | nl00i) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl01l) | nli0i) | nli1l) | nli1O) | nl00l) | nl01O) | nliii),
		nii1iO = (((((((((((((((((nlili | nliil) | nl0Oi) | nl0lO) | nl00i) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl01l) | nli0l) | nl0Ol) | nl00l) | nl01O),
		nii1li = (((((((((((((((((((((nlili | nli1i) | nl0Oi) | nl0lO) | nl00i) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl01l) | nli0l) | nli0i) | nli1l) | nli1O) | nl0Ol) | nl00l) | nl01O) | nliii),
		nii1ll = (((((((((((((((((((((nli0O | nli1i) | nl0Oi) | nl0lO) | nl00i) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl01l) | nli0l) | nli0i) | nli1l) | nli1O) | nl0Ol) | nl00l) | nl01O) | nliii),
		nii1OO = (((((((((((((((nlili | nliil) | nli0O) | nl0Oi) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0ii) | nli0l) | nli0i) | nli1l) | nli1O) | nl00l) | nliii),
		niii0i = (((~ niOil) & niOii) & (~ niO0O)),
		niii0l = ((((niOOi & niOlO) & niOll) & niOli) & (~ niOiO)),
		niii1i = ((((((((((((((nlili | nliil) | nl0Oi) | n0iii) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0ii) | nl00O) | nl01l) | nli0l) | nl0Ol) | nl00l) | nliii),
		niii1l = ((niOil & (~ niOii)) & niO0O),
		niii1O = ((niOil & niOii) & (~ niO0O)),
		niiiil = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		niiiiO = (((~ niOil) & (~ niOii)) & niO0O),
		niiili = ((niiiOl | niiiOi) | (~ niiill26)),
		niiiOi = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		niiiOl = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		niiiOO = ((((nlili | nliil) | nli0O) | nl01l) | nliii),
		niil0i = (((((((((nl0Oi | n0iii) | nl0li) | nl0iO) | nl0ii) | nl00O) | nli1O) | nl0Ol) | nl00l) | nl01O),
		niil0l = (((((n0iii | nl0ll) | nl0iO) | nl0il) | nl00O) | nli1O),
		niil0O = (((((((((((nlili | nl0Oi) | nl0lO) | n0iii) | nl0ll) | nl0iO) | nl0ii) | nli0l) | nli0i) | nli1O) | nl00l) | nl01O),
		niil1i = (((((((nlili | nliil) | nli0O) | nli1i) | nl0Oi) | nl0lO) | nl00i) | n0iii),
		niil1l = (((((((((nl0lO | nl00i) | nl0OO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl01l),
		niil1O = (((((((((nli1i | n0iii) | nl0OO) | nl0li) | nl0il) | nl00O) | nl01l) | nli0l) | nli0i) | nli1l),
		niilii = (((((((((nlili | nli0O) | nl0Oi) | nl00i) | n0iii) | nl0ll) | nl0li) | nl00O) | nli1O) | nl0Ol),
		niilil = ((((((((((nli0O | nli1i) | nl00i) | nl0OO) | nl0ll) | nl0li) | nl0ii) | nl01l) | nl00l) | nliii) | (~ nii1lO59)),
		niiliO = 1'b1,
		niiO0i = ((rbist_sel[0] & (~ rbist_sel[1])) & niilOl14),
		niiO0l = (((~ rbist_sel[0]) & rbist_sel[1]) & niillO17),
		niiO1O = (((~ rbist_sel[0]) & (~ rbist_sel[1])) & niiO1i11),
		niiOil = (((rpmadwidth_tx & rpma_doublewidth_tx) & niiOll2) | (((rpmadwidth_tx & (~ rpma_doublewidth_tx)) & rdwidth_tx) & niiOiO5));
endmodule //stratixiigx_hssi_tx_bist_gen
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 107 mux21 92 oper_decoder 1 oper_selector 43 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_tx_prbs_gen
	( 
	prbs_out,
	rpma_doublewidth_tx,
	rpmadwidth_tx,
	rprbs_en_tx,
	rprbs_sel,
	soft_reset,
	tx_clk) /* synthesis synthesis_clearbox=1 */;
	output   [19:0]  prbs_out;
	input   rpma_doublewidth_tx;
	input   rpmadwidth_tx;
	input   rprbs_en_tx;
	input   [2:0]  rprbs_sel;
	input   soft_reset;
	input   tx_clk;

	reg	nllOiO58;
	reg	nllOiO59;
	reg	nllOiO60;
	reg	nllOli55;
	reg	nllOli56;
	reg	nllOli57;
	reg	nllOlO52;
	reg	nllOlO53;
	reg	nllOlO54;
	reg	nllOOl49;
	reg	nllOOl50;
	reg	nllOOl51;
	reg	nlO00l31;
	reg	nlO00l32;
	reg	nlO00l33;
	reg	nlO01l34;
	reg	nlO01l35;
	reg	nlO01l36;
	reg	nlO0ll28;
	reg	nlO0ll29;
	reg	nlO0ll30;
	reg	nlO0Ol25;
	reg	nlO0Ol26;
	reg	nlO0Ol27;
	reg	nlO10l43;
	reg	nlO10l44;
	reg	nlO10l45;
	reg	nlO11l46;
	reg	nlO11l47;
	reg	nlO11l48;
	reg	nlO1il40;
	reg	nlO1il41;
	reg	nlO1il42;
	reg	nlO1lO37;
	reg	nlO1lO38;
	reg	nlO1lO39;
	reg	nlOi0i22;
	reg	nlOi0i23;
	reg	nlOi0i24;
	reg	nlOili19;
	reg	nlOili20;
	reg	nlOili21;
	reg	nlOiOl16;
	reg	nlOiOl17;
	reg	nlOiOl18;
	reg	nlOl0l10;
	reg	nlOl0l11;
	reg	nlOl0l12;
	reg	nlOl1l13;
	reg	nlOl1l14;
	reg	nlOl1l15;
	reg	nlOlli7;
	reg	nlOlli8;
	reg	nlOlli9;
	reg	nlOlOl4;
	reg	nlOlOl5;
	reg	nlOlOl6;
	reg	nlOO1O1;
	reg	nlOO1O2;
	reg	nlOO1O3;
	reg	n010O;
	wire	wire_n010l_ENA;
	reg	n011l;
	wire	wire_n011i_ENA;
	reg	n010i;
	wire	wire_n011O_ENA;
	reg	n01il;
	wire	wire_n01ii_ENA;
	reg	n01li;
	wire	wire_n01iO_ENA;
	reg	n1iOO;
	wire	wire_n1iOl_ENA;
	reg	n1l0O;
	wire	wire_n1l0l_ENA;
	reg	n1l1l;
	wire	wire_n1l1i_ENA;
	reg	n1l0i;
	wire	wire_n1l1O_ENA;
	reg	n1lil;
	wire	wire_n1lii_ENA;
	reg	n1lli;
	wire	wire_n1liO_ENA;
	reg	n1llO;
	wire	wire_n1lll_ENA;
	reg	n1lOl;
	wire	wire_n1lOi_ENA;
	reg	n1O1i;
	wire	wire_n1lOO_ENA;
	reg	n1O0l;
	wire	wire_n1O0i_ENA;
	reg	n1Oii;
	wire	wire_n1O0O_ENA;
	reg	n1O1O;
	wire	wire_n1O1l_ENA;
	reg	n1OiO;
	wire	wire_n1Oil_ENA;
	reg	n1Oll;
	wire	wire_n1Oli_ENA;
	reg	n1OOi;
	wire	wire_n1OlO_ENA;
	reg	n1OOO;
	wire	wire_n1OOl_ENA;
	reg	n000i;
	reg	n000l;
	reg	n000O;
	reg	n001i;
	reg	n001l;
	reg	n001O;
	reg	n00ii;
	reg	n00il;
	reg	n00iO;
	reg	n00li;
	reg	n00ll;
	reg	n00lO;
	reg	n00Oi;
	reg	n00Ol;
	reg	n00OO;
	reg	n01ll;
	reg	n01lO;
	reg	n01Oi;
	reg	n01Ol;
	reg	n01OO;
	reg	n0i1i;
	reg	n0i1l;
	reg	n1iOi;
	reg	ni;
	reg	nlO;
	reg	nO;
	wire	wire_n00i_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n0i0i_dataout;
	wire	wire_n0i0l_dataout;
	wire	wire_n0i0O_dataout;
	wire	wire_n0i1O_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0iii_dataout;
	wire	wire_n0iil_dataout;
	wire	wire_n0iiO_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0ili_dataout;
	wire	wire_n0ill_dataout;
	wire	wire_n0ilO_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0iOi_dataout;
	wire	wire_n0iOl_dataout;
	wire	wire_n0iOO_dataout;
	wire	wire_n0l0i_dataout;
	wire	wire_n0l0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0l1i_dataout;
	wire	wire_n0l1l_dataout;
	wire	wire_n0l1O_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0lii_dataout;
	wire	wire_n0lil_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lli_dataout;
	wire	wire_n0lll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0lOi_dataout;
	wire	wire_n0lOl_dataout;
	wire	wire_n0lOO_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O0l_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Oil_dataout;
	wire	wire_n0OiO_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0Oll_dataout;
	wire	wire_n0OlO_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n0OOO_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni11l_dataout;
	wire	wire_ni11O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_niii_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOO_dataout;
	wire  [31:0]   wire_niOOl_o;
	wire  wire_ni00O_o;
	wire  wire_ni01i_o;
	wire  wire_ni01O_o;
	wire  wire_ni0il_o;
	wire  wire_ni0iO_o;
	wire  wire_ni0li_o;
	wire  wire_ni0ll_o;
	wire  wire_ni0OO_o;
	wire  wire_ni10i_o;
	wire  wire_ni10l_o;
	wire  wire_ni10O_o;
	wire  wire_ni1ii_o;
	wire  wire_ni1il_o;
	wire  wire_ni1iO_o;
	wire  wire_ni1li_o;
	wire  wire_ni1ll_o;
	wire  wire_ni1Oi_o;
	wire  wire_ni1Ol_o;
	wire  wire_ni1OO_o;
	wire  wire_nii0i_o;
	wire  wire_nii0l_o;
	wire  wire_nii0O_o;
	wire  wire_nii1i_o;
	wire  wire_niiii_o;
	wire  wire_niili_o;
	wire  wire_niilO_o;
	wire  wire_niiOi_o;
	wire  wire_nil0O_o;
	wire  wire_nil1i_o;
	wire  wire_nil1O_o;
	wire  wire_nilil_o;
	wire  wire_niliO_o;
	wire  wire_nilli_o;
	wire  wire_nilll_o;
	wire  wire_nilOi_o;
	wire  wire_niO0i_o;
	wire  wire_niO0O_o;
	wire  wire_niO1i_o;
	wire  wire_niO1O_o;
	wire  wire_niOil_o;
	wire  wire_niOli_o;
	wire  wire_niOll_o;
	wire  wire_niOlO_o;
	wire  nlll0i;
	wire  nlll0l;
	wire  nlll0O;
	wire  nlll1i;
	wire  nlll1l;
	wire  nlll1O;
	wire  nlllii;
	wire  nlllil;
	wire  nllliO;
	wire  nlllli;
	wire  nlllll;
	wire  nllllO;
	wire  nlllOi;
	wire  nlllOl;
	wire  nlllOO;
	wire  nllO0i;
	wire  nllO0l;
	wire  nllO0O;
	wire  nllO1i;
	wire  nllO1l;
	wire  nllO1O;
	wire  nllOii;
	wire  nllOil;
	wire  nllOll;
	wire  nllOOO;
	wire  nlO00i;
	wire  nlO01i;
	wire  nlO0ii;
	wire  nlO0il;
	wire  nlO0iO;
	wire  nlO0li;
	wire  nlO0Oi;
	wire  nlO10i;
	wire  nlO11i;
	wire  nlO1ii;
	wire  nlO1li;
	wire  nlO1ll;
	wire  nlO1Ol;
	wire  nlO1OO;
	wire  nlOi0O;
	wire  nlOi1i;
	wire  nlOi1l;
	wire  nlOi1O;
	wire  nlOiii;
	wire  nlOiil;
	wire  nlOiiO;
	wire  nlOilO;
	wire  nlOiOi;
	wire  nlOl0i;
	wire  nlOl1i;
	wire  nlOlii;
	wire  nlOlil;
	wire  nlOliO;
	wire  nlOllO;
	wire  nlOlOi;
	wire  nlOO0O;
	wire  nlOO1i;
	wire  nlOO1l;

	initial
		nllOiO58 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nllOiO58 <= nllOiO60;
	initial
		nllOiO59 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nllOiO59 <= (nllOiO60 ^ nllOiO58);
	initial
		nllOiO60 = 0;
	always @ ( posedge tx_clk)
		  nllOiO60 <= nllOiO58;
	initial
		nllOli55 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nllOli55 <= nllOli57;
	initial
		nllOli56 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nllOli56 <= (nllOli57 ^ nllOli55);
	initial
		nllOli57 = 0;
	always @ ( posedge tx_clk)
		  nllOli57 <= nllOli55;
	initial
		nllOlO52 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nllOlO52 <= nllOlO54;
	initial
		nllOlO53 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nllOlO53 <= (nllOlO54 ^ nllOlO52);
	initial
		nllOlO54 = 0;
	always @ ( posedge tx_clk)
		  nllOlO54 <= nllOlO52;
	initial
		nllOOl49 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nllOOl49 <= nllOOl51;
	initial
		nllOOl50 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nllOOl50 <= (nllOOl51 ^ nllOOl49);
	initial
		nllOOl51 = 0;
	always @ ( posedge tx_clk)
		  nllOOl51 <= nllOOl49;
	initial
		nlO00l31 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO00l31 <= nlO00l33;
	initial
		nlO00l32 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO00l32 <= (nlO00l33 ^ nlO00l31);
	initial
		nlO00l33 = 0;
	always @ ( posedge tx_clk)
		  nlO00l33 <= nlO00l31;
	initial
		nlO01l34 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO01l34 <= nlO01l36;
	initial
		nlO01l35 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO01l35 <= (nlO01l36 ^ nlO01l34);
	initial
		nlO01l36 = 0;
	always @ ( posedge tx_clk)
		  nlO01l36 <= nlO01l34;
	initial
		nlO0ll28 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO0ll28 <= nlO0ll30;
	initial
		nlO0ll29 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO0ll29 <= (nlO0ll30 ^ nlO0ll28);
	initial
		nlO0ll30 = 0;
	always @ ( posedge tx_clk)
		  nlO0ll30 <= nlO0ll28;
	initial
		nlO0Ol25 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO0Ol25 <= nlO0Ol27;
	initial
		nlO0Ol26 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO0Ol26 <= (nlO0Ol27 ^ nlO0Ol25);
	initial
		nlO0Ol27 = 0;
	always @ ( posedge tx_clk)
		  nlO0Ol27 <= nlO0Ol25;
	initial
		nlO10l43 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO10l43 <= nlO10l45;
	initial
		nlO10l44 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO10l44 <= (nlO10l45 ^ nlO10l43);
	initial
		nlO10l45 = 0;
	always @ ( posedge tx_clk)
		  nlO10l45 <= nlO10l43;
	initial
		nlO11l46 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO11l46 <= nlO11l48;
	initial
		nlO11l47 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO11l47 <= (nlO11l48 ^ nlO11l46);
	initial
		nlO11l48 = 0;
	always @ ( posedge tx_clk)
		  nlO11l48 <= nlO11l46;
	initial
		nlO1il40 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO1il40 <= nlO1il42;
	initial
		nlO1il41 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO1il41 <= (nlO1il42 ^ nlO1il40);
	initial
		nlO1il42 = 0;
	always @ ( posedge tx_clk)
		  nlO1il42 <= nlO1il40;
	initial
		nlO1lO37 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO1lO37 <= nlO1lO39;
	initial
		nlO1lO38 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlO1lO38 <= (nlO1lO39 ^ nlO1lO37);
	initial
		nlO1lO39 = 0;
	always @ ( posedge tx_clk)
		  nlO1lO39 <= nlO1lO37;
	initial
		nlOi0i22 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOi0i22 <= nlOi0i24;
	initial
		nlOi0i23 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOi0i23 <= (nlOi0i24 ^ nlOi0i22);
	initial
		nlOi0i24 = 0;
	always @ ( posedge tx_clk)
		  nlOi0i24 <= nlOi0i22;
	initial
		nlOili19 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOili19 <= nlOili21;
	initial
		nlOili20 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOili20 <= (nlOili21 ^ nlOili19);
	initial
		nlOili21 = 0;
	always @ ( posedge tx_clk)
		  nlOili21 <= nlOili19;
	initial
		nlOiOl16 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOiOl16 <= nlOiOl18;
	initial
		nlOiOl17 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOiOl17 <= (nlOiOl18 ^ nlOiOl16);
	initial
		nlOiOl18 = 0;
	always @ ( posedge tx_clk)
		  nlOiOl18 <= nlOiOl16;
	initial
		nlOl0l10 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOl0l10 <= nlOl0l12;
	initial
		nlOl0l11 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOl0l11 <= (nlOl0l12 ^ nlOl0l10);
	initial
		nlOl0l12 = 0;
	always @ ( posedge tx_clk)
		  nlOl0l12 <= nlOl0l10;
	initial
		nlOl1l13 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOl1l13 <= nlOl1l15;
	initial
		nlOl1l14 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOl1l14 <= (nlOl1l15 ^ nlOl1l13);
	initial
		nlOl1l15 = 0;
	always @ ( posedge tx_clk)
		  nlOl1l15 <= nlOl1l13;
	initial
		nlOlli7 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOlli7 <= nlOlli9;
	initial
		nlOlli8 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOlli8 <= (nlOlli9 ^ nlOlli7);
	initial
		nlOlli9 = 0;
	always @ ( posedge tx_clk)
		  nlOlli9 <= nlOlli7;
	initial
		nlOlOl4 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOlOl4 <= nlOlOl6;
	initial
		nlOlOl5 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOlOl5 <= (nlOlOl6 ^ nlOlOl4);
	initial
		nlOlOl6 = 0;
	always @ ( posedge tx_clk)
		  nlOlOl6 <= nlOlOl4;
	initial
		nlOO1O1 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOO1O1 <= nlOO1O3;
	initial
		nlOO1O2 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  nlOO1O2 <= (nlOO1O3 ^ nlOO1O1);
	initial
		nlOO1O3 = 0;
	always @ ( posedge tx_clk)
		  nlOO1O3 <= nlOO1O1;
	initial
	begin
		n010O = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n010O <= 0;
		end
		else if  (wire_n010l_ENA == 1'b1) 
		begin
			n010O <= wire_ni0ll_o;
		end
	end
	assign
		wire_n010l_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n011l = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n011l <= 0;
		end
		else if  (wire_n011i_ENA == 1'b1) 
		begin
			n011l <= wire_ni0iO_o;
		end
	end
	assign
		wire_n011i_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n010i = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n010i <= 0;
		end
		else if  (wire_n011O_ENA == 1'b1) 
		begin
			n010i <= wire_ni0li_o;
		end
	end
	assign
		wire_n011O_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n01il = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n01il <= 0;
		end
		else if  (wire_n01ii_ENA == 1'b1) 
		begin
			n01il <= wire_ni0OO_o;
		end
	end
	assign
		wire_n01ii_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n01li = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n01li <= 0;
		end
		else if  (wire_n01iO_ENA == 1'b1) 
		begin
			n01li <= wire_nii1i_o;
		end
	end
	assign
		wire_n01iO_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1iOO = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1iOO <= 0;
		end
		else if  (wire_n1iOl_ENA == 1'b1) 
		begin
			n1iOO <= (~ n1iOO);
		end
	end
	assign
		wire_n1iOl_ENA = (wire_niOOl_o[11] & (ni & (~ nlOO1l)));
	initial
	begin
		n1l0O = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1l0O <= 0;
		end
		else if  (wire_n1l0l_ENA == 1'b1) 
		begin
			n1l0O <= wire_ni10O_o;
		end
	end
	assign
		wire_n1l0l_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1l1l = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1l1l <= 0;
		end
		else if  (wire_n1l1i_ENA == 1'b1) 
		begin
			n1l1l <= wire_ni10i_o;
		end
	end
	assign
		wire_n1l1i_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1l0i = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1l0i <= 0;
		end
		else if  (wire_n1l1O_ENA == 1'b1) 
		begin
			n1l0i <= wire_ni10l_o;
		end
	end
	assign
		wire_n1l1O_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1lil = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1lil <= 0;
		end
		else if  (wire_n1lii_ENA == 1'b1) 
		begin
			n1lil <= wire_ni1ii_o;
		end
	end
	assign
		wire_n1lii_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1lli = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1lli <= 0;
		end
		else if  (wire_n1liO_ENA == 1'b1) 
		begin
			n1lli <= wire_ni1il_o;
		end
	end
	assign
		wire_n1liO_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1llO = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1llO <= 0;
		end
		else if  (wire_n1lll_ENA == 1'b1) 
		begin
			n1llO <= wire_ni1iO_o;
		end
	end
	assign
		wire_n1lll_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1lOl = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1lOl <= 0;
		end
		else if  (wire_n1lOi_ENA == 1'b1) 
		begin
			n1lOl <= wire_ni1li_o;
		end
	end
	assign
		wire_n1lOi_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1O1i = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1O1i <= 0;
		end
		else if  (wire_n1lOO_ENA == 1'b1) 
		begin
			n1O1i <= wire_ni1ll_o;
		end
	end
	assign
		wire_n1lOO_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1O0l = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1O0l <= 0;
		end
		else if  (wire_n1O0i_ENA == 1'b1) 
		begin
			n1O0l <= wire_ni1Ol_o;
		end
	end
	assign
		wire_n1O0i_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1Oii = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1Oii <= 0;
		end
		else if  (wire_n1O0O_ENA == 1'b1) 
		begin
			n1Oii <= wire_ni1OO_o;
		end
	end
	assign
		wire_n1O0O_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1O1O = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1O1O <= 0;
		end
		else if  (wire_n1O1l_ENA == 1'b1) 
		begin
			n1O1O <= wire_ni1Oi_o;
		end
	end
	assign
		wire_n1O1l_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1OiO = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1OiO <= 0;
		end
		else if  (wire_n1Oil_ENA == 1'b1) 
		begin
			n1OiO <= wire_ni01i_o;
		end
	end
	assign
		wire_n1Oil_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1Oll = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1Oll <= 0;
		end
		else if  (wire_n1Oli_ENA == 1'b1) 
		begin
			n1Oll <= wire_ni01O_o;
		end
	end
	assign
		wire_n1Oli_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1OOi = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1OOi <= 0;
		end
		else if  (wire_n1OlO_ENA == 1'b1) 
		begin
			n1OOi <= wire_ni00O_o;
		end
	end
	assign
		wire_n1OlO_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n1OOO = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1OOO <= 0;
		end
		else if  (wire_n1OOl_ENA == 1'b1) 
		begin
			n1OOO <= wire_ni0il_o;
		end
	end
	assign
		wire_n1OOl_ENA = (ni & (~ nlOO1l));
	initial
	begin
		n000i = 0;
		n000l = 0;
		n000O = 0;
		n001i = 0;
		n001l = 0;
		n001O = 0;
		n00ii = 0;
		n00il = 0;
		n00iO = 0;
		n00li = 0;
		n00ll = 0;
		n00lO = 0;
		n00Oi = 0;
		n00Ol = 0;
		n00OO = 0;
		n01ll = 0;
		n01lO = 0;
		n01Oi = 0;
		n01Ol = 0;
		n01OO = 0;
		n0i1i = 0;
		n0i1l = 0;
		n1iOi = 0;
		ni = 0;
		nlO = 0;
		nO = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n000i <= 0;
			n000l <= 0;
			n000O <= 0;
			n001i <= 0;
			n001l <= 0;
			n001O <= 0;
			n00ii <= 0;
			n00il <= 0;
			n00iO <= 0;
			n00li <= 0;
			n00ll <= 0;
			n00lO <= 0;
			n00Oi <= 0;
			n00Ol <= 0;
			n00OO <= 0;
			n01ll <= 0;
			n01lO <= 0;
			n01Oi <= 0;
			n01Ol <= 0;
			n01OO <= 0;
			n0i1i <= 0;
			n0i1l <= 0;
			n1iOi <= 0;
			ni <= 0;
			nlO <= 0;
			nO <= 0;
		end
		else 
		begin
			n000i <= wire_n0ill_dataout;
			n000l <= wire_n0ilO_dataout;
			n000O <= wire_n0iOi_dataout;
			n001i <= wire_n0iil_dataout;
			n001l <= wire_n0iiO_dataout;
			n001O <= wire_n0ili_dataout;
			n00ii <= wire_n0iOl_dataout;
			n00il <= wire_n0iOO_dataout;
			n00iO <= wire_n0l1i_dataout;
			n00li <= wire_n0l1l_dataout;
			n00ll <= wire_n0l1O_dataout;
			n00lO <= wire_n0l0i_dataout;
			n00Oi <= wire_n0l0l_dataout;
			n00Ol <= wire_n0l0O_dataout;
			n00OO <= wire_n0lii_dataout;
			n01ll <= wire_n0i1O_dataout;
			n01lO <= wire_n0i0i_dataout;
			n01Oi <= wire_n0i0l_dataout;
			n01Ol <= wire_n0i0O_dataout;
			n01OO <= wire_n0iii_dataout;
			n0i1i <= wire_n0lil_dataout;
			n0i1l <= wire_n0liO_dataout;
			n1iOi <= rprbs_en_tx;
			ni <= nO;
			nlO <= wire_n0lli_dataout;
			nO <= n1iOi;
		end
	end
	and(wire_n00i_dataout, n01OO, ~{n1iOO});
	or(wire_n00l_dataout, n001i, n1iOO);
	and(wire_n00O_dataout, n001l, ~{n1iOO});
	and(wire_n01i_dataout, n01lO, ~{n1iOO});
	and(wire_n01l_dataout, n01Oi, ~{n1iOO});
	and(wire_n01O_dataout, n01Ol, ~{n1iOO});
	assign		wire_n0i0i_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0llO_dataout;
	assign		wire_n0i0l_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0lOi_dataout;
	assign		wire_n0i0O_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0lOl_dataout;
	assign		wire_n0i1O_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0lll_dataout;
	or(wire_n0ii_dataout, n001O, n1iOO);
	assign		wire_n0iii_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0lOO_dataout;
	assign		wire_n0iil_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0O1i_dataout;
	or(wire_n0iiO_dataout, wire_n0O1l_dataout, nlOO1l);
	and(wire_n0il_dataout, n000i, ~{n1iOO});
	assign		wire_n0ili_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0O1O_dataout;
	assign		wire_n0ill_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0O0i_dataout;
	assign		wire_n0ilO_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0O0l_dataout;
	and(wire_n0iO_dataout, n000l, ~{n1iOO});
	assign		wire_n0iOi_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0O0O_dataout;
	assign		wire_n0iOl_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0Oii_dataout;
	or(wire_n0iOO_dataout, wire_n0Oil_dataout, nlOO1l);
	assign		wire_n0l0i_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0OlO_dataout;
	assign		wire_n0l0l_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0OOi_dataout;
	assign		wire_n0l0O_dataout = (nlOO1l === 1'b1) ? (~ wire_niOOl_o[16]) : wire_n0OOl_dataout;
	or(wire_n0l1i_dataout, wire_n0OiO_dataout, nlOO1l);
	assign		wire_n0l1l_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0Oli_dataout;
	assign		wire_n0l1O_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0Oll_dataout;
	and(wire_n0li_dataout, n000O, ~{n1iOO});
	assign		wire_n0lii_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_n0OOO_dataout;
	assign		wire_n0lil_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_ni11i_dataout;
	assign		wire_n0liO_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_ni11l_dataout;
	and(wire_n0ll_dataout, n00ii, ~{n1iOO});
	assign		wire_n0lli_dataout = (nlOO1l === 1'b1) ? (~ nlOO1i) : wire_ni11O_dataout;
	assign		wire_n0lll_dataout = (ni === 1'b1) ? wire_nii0i_o : n01ll;
	assign		wire_n0llO_dataout = (ni === 1'b1) ? wire_nii0l_o : n01lO;
	and(wire_n0lO_dataout, n00il, ~{n1iOO});
	assign		wire_n0lOi_dataout = (ni === 1'b1) ? wire_nii0O_o : n01Oi;
	assign		wire_n0lOl_dataout = (ni === 1'b1) ? wire_niiii_o : n01Ol;
	assign		wire_n0lOO_dataout = (ni === 1'b1) ? wire_niili_o : n01OO;
	assign		wire_n0O0i_dataout = (ni === 1'b1) ? wire_nil1O_o : n000i;
	assign		wire_n0O0l_dataout = (ni === 1'b1) ? wire_nil0O_o : n000l;
	assign		wire_n0O0O_dataout = (ni === 1'b1) ? wire_nilil_o : n000O;
	assign		wire_n0O1i_dataout = (ni === 1'b1) ? wire_niilO_o : n001i;
	assign		wire_n0O1l_dataout = (ni === 1'b1) ? wire_niiOi_o : n001l;
	assign		wire_n0O1O_dataout = (ni === 1'b1) ? wire_nil1i_o : n001O;
	and(wire_n0Oi_dataout, n00iO, ~{n1iOO});
	assign		wire_n0Oii_dataout = (ni === 1'b1) ? wire_niliO_o : n00ii;
	assign		wire_n0Oil_dataout = (ni === 1'b1) ? wire_nilli_o : n00il;
	assign		wire_n0OiO_dataout = (ni === 1'b1) ? wire_nilll_o : n00iO;
	and(wire_n0Ol_dataout, n00li, ~{n1iOO});
	assign		wire_n0Oli_dataout = (ni === 1'b1) ? wire_nilOi_o : n00li;
	assign		wire_n0Oll_dataout = (ni === 1'b1) ? wire_niO1i_o : n00ll;
	assign		wire_n0OlO_dataout = (ni === 1'b1) ? wire_niO1O_o : n00lO;
	and(wire_n0OO_dataout, n00ll, ~{n1iOO});
	assign		wire_n0OOi_dataout = (ni === 1'b1) ? wire_niO0i_o : n00Oi;
	assign		wire_n0OOl_dataout = (ni === 1'b1) ? wire_niO0O_o : n00Ol;
	assign		wire_n0OOO_dataout = (ni === 1'b1) ? wire_niOil_o : n00OO;
	and(wire_n10i_dataout, wire_n0lO_dataout, ~{(~ n1iOO)});
	and(wire_n10l_dataout, wire_n0Oi_dataout, ~{(~ n1iOO)});
	and(wire_n10O_dataout, wire_n0Ol_dataout, ~{(~ n1iOO)});
	or(wire_n11i_dataout, wire_n0iO_dataout, (~ n1iOO));
	and(wire_n11l_dataout, wire_n0li_dataout, ~{(~ n1iOO)});
	and(wire_n11O_dataout, wire_n0ll_dataout, ~{(~ n1iOO)});
	and(wire_n1ii_dataout, wire_n0OO_dataout, ~{(~ n1iOO)});
	and(wire_n1il_dataout, wire_ni1i_dataout, ~{(~ n1iOO)});
	and(wire_n1iO_dataout, wire_ni1l_dataout, ~{(~ n1iOO)});
	and(wire_n1li_dataout, wire_ni1O_dataout, ~{(~ n1iOO)});
	and(wire_n1ll_dataout, wire_ni0i_dataout, ~{(~ n1iOO)});
	and(wire_n1lO_dataout, wire_ni0l_dataout, ~{(~ n1iOO)});
	and(wire_n1Oi_dataout, wire_ni0O_dataout, ~{(~ n1iOO)});
	and(wire_n1Ol_dataout, wire_niii_dataout, ~{(~ n1iOO)});
	and(wire_n1OO_dataout, n01ll, ~{n1iOO});
	and(wire_ni0i_dataout, n00OO, ~{n1iOO});
	and(wire_ni0l_dataout, n0i1i, ~{n1iOO});
	and(wire_ni0O_dataout, n0i1l, ~{n1iOO});
	assign		wire_ni11i_dataout = (ni === 1'b1) ? wire_niOli_o : n0i1i;
	assign		wire_ni11l_dataout = (ni === 1'b1) ? wire_niOll_o : n0i1l;
	assign		wire_ni11O_dataout = (ni === 1'b1) ? wire_niOlO_o : nlO;
	and(wire_ni1i_dataout, n00lO, ~{n1iOO});
	and(wire_ni1l_dataout, n00Oi, ~{n1iOO});
	and(wire_ni1O_dataout, n00Ol, ~{n1iOO});
	and(wire_niii_dataout, nlO, ~{n1iOO});
	or(wire_nlOii_dataout, wire_n1OO_dataout, (~ n1iOO));
	or(wire_nlOil_dataout, wire_n01i_dataout, (~ n1iOO));
	or(wire_nlOiO_dataout, wire_n01l_dataout, (~ n1iOO));
	or(wire_nlOli_dataout, wire_n01O_dataout, (~ n1iOO));
	or(wire_nlOll_dataout, wire_n00i_dataout, (~ n1iOO));
	and(wire_nlOlO_dataout, wire_n00l_dataout, ~{(~ n1iOO)});
	or(wire_nlOOi_dataout, wire_n00O_dataout, (~ n1iOO));
	and(wire_nlOOl_dataout, wire_n0ii_dataout, ~{(~ n1iOO)});
	or(wire_nlOOO_dataout, wire_n0il_dataout, (~ n1iOO));
	oper_decoder   niOOl
	( 
	.i({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:1], (nllOOl50 & rprbs_sel[0])}),
	.o(wire_niOOl_o));
	defparam
		niOOl.width_i = 5,
		niOOl.width_o = 32;
	oper_selector   ni00O
	( 
	.data({1'b0, n00iO, n000l, n00ii}),
	.o(wire_ni00O_o),
	.sel({nlllli, nlll0l, wire_niOOl_o[25], ((wire_niOOl_o[18] | wire_niOOl_o[16]) | wire_niOOl_o[17])}));
	defparam
		ni00O.width_data = 4,
		ni00O.width_sel = 4;
	oper_selector   ni01i
	( 
	.data({1'b0, n00ii, n000l, n00iO}),
	.o(wire_ni01i_o),
	.sel({nlllli, nlll1l, nlll0i, wire_niOOl_o[17]}));
	defparam
		ni01i.width_data = 4,
		ni01i.width_sel = 4;
	oper_selector   ni01O
	( 
	.data({1'b0, n00il, n000O}),
	.o(wire_ni01O_o),
	.sel({nlllli, nlll1O, ((wire_niOOl_o[18] | wire_niOOl_o[16]) | wire_niOOl_o[25])}));
	defparam
		ni01O.width_data = 3,
		ni01O.width_sel = 3;
	oper_selector   ni0il
	( 
	.data({1'b0, n00li, n000i, n00il, n000O}),
	.o(wire_ni0il_o),
	.sel({nlllli, nlll0l, wire_niOOl_o[25], nlll0i, wire_niOOl_o[17]}));
	defparam
		ni0il.width_data = 5,
		ni0il.width_sel = 5;
	oper_selector   ni0iO
	( 
	.data({1'b0, n00ll, n001O, n00iO, n000l}),
	.o(wire_ni0iO_o),
	.sel({nlllli, nlll0l, wire_niOOl_o[25], nlll0i, wire_niOOl_o[17]}));
	defparam
		ni0iO.width_data = 5,
		ni0iO.width_sel = 5;
	oper_selector   ni0li
	( 
	.data({1'b0, n00lO, n001l, n00li, n000i}),
	.o(wire_ni0li_o),
	.sel({nlllli, nlll0l, wire_niOOl_o[25], nlll0i, wire_niOOl_o[17]}));
	defparam
		ni0li.width_data = 5,
		ni0li.width_sel = 5;
	oper_selector   ni0ll
	( 
	.data({1'b0, n00Oi, n001i, n00ll, n001O}),
	.o(wire_ni0ll_o),
	.sel({nlllli, nlll0l, wire_niOOl_o[25], nlll0i, wire_niOOl_o[17]}));
	defparam
		ni0ll.width_data = 5,
		ni0ll.width_sel = 5;
	oper_selector   ni0OO
	( 
	.data({1'b0, n00Ol, n01OO}),
	.o(wire_ni0OO_o),
	.sel({nlllii, nlll0O, wire_niOOl_o[25]}));
	defparam
		ni0OO.width_data = 3,
		ni0OO.width_sel = 3;
	oper_selector   ni10i
	( 
	.data({1'b0, n01ll, nlO}),
	.o(wire_ni10i_o),
	.sel({nlllli, nlll0O, nlll1i}));
	defparam
		ni10i.width_data = 3,
		ni10i.width_sel = 3;
	oper_selector   ni10l
	( 
	.data({1'b0, n01lO, n0i1l}),
	.o(wire_ni10l_o),
	.sel({nlllli, nlll0O, nlll1i}));
	defparam
		ni10l.width_data = 3,
		ni10l.width_sel = 3;
	oper_selector   ni10O
	( 
	.data({1'b0, n01Oi, n0i1i}),
	.o(wire_ni10O_o),
	.sel({nlllli, nlll0O, nlll1i}));
	defparam
		ni10O.width_data = 3,
		ni10O.width_sel = 3;
	oper_selector   ni1ii
	( 
	.data({1'b0, n01Ol, n00OO}),
	.o(wire_ni1ii_o),
	.sel({nlllli, nlll0O, nlll1i}));
	defparam
		ni1ii.width_data = 3,
		ni1ii.width_sel = 3;
	oper_selector   ni1il
	( 
	.data({1'b0, n01OO, n00Ol}),
	.o(wire_ni1il_o),
	.sel({nlllli, nlll0O, nlll1i}));
	defparam
		ni1il.width_data = 3,
		ni1il.width_sel = 3;
	oper_selector   ni1iO
	( 
	.data({1'b0, n001i, n00Oi}),
	.o(wire_ni1iO_o),
	.sel({nlllli, nlll0O, nlll1i}));
	defparam
		ni1iO.width_data = 3,
		ni1iO.width_sel = 3;
	oper_selector   ni1li
	( 
	.data({1'b0, n001l, n00lO}),
	.o(wire_ni1li_o),
	.sel({nlllli, nlll0O, nlll1i}));
	defparam
		ni1li.width_data = 3,
		ni1li.width_sel = 3;
	oper_selector   ni1ll
	( 
	.data({1'b0, n001O, n00ll}),
	.o(wire_ni1ll_o),
	.sel({nlllli, nlll0O, nlll1i}));
	defparam
		ni1ll.width_data = 3,
		ni1ll.width_sel = 3;
	oper_selector   ni1Oi
	( 
	.data({1'b0, n000i, n00li, n00lO}),
	.o(wire_ni1Oi_o),
	.sel({nlllii, nlll0l, wire_niOOl_o[25], nlll0i}));
	defparam
		ni1Oi.width_data = 4,
		ni1Oi.width_sel = 4;
	oper_selector   ni1Ol
	( 
	.data({1'b0, n000l, n00iO, n00Oi}),
	.o(wire_ni1Ol_o),
	.sel({nlllii, nlll0l, wire_niOOl_o[25], nlll0i}));
	defparam
		ni1Ol.width_data = 4,
		ni1Ol.width_sel = 4;
	oper_selector   ni1OO
	( 
	.data({1'b0, n000O, n00il, n000i, n00li}),
	.o(wire_ni1OO_o),
	.sel({nlllli, nlll0l, wire_niOOl_o[25], nlll0i, wire_niOOl_o[17]}));
	defparam
		ni1OO.width_data = 5,
		ni1OO.width_sel = 5;
	oper_selector   nii0i
	( 
	.data({1'b0, 1'b1, (n0i1l ^ (n01Ol ^ n00lO)), nlOiiO, nllOOO, (n000l ^ n000O), wire_nlOii_dataout, nlOliO, (n01ll ^ (n01lO ^ nlOllO))}),
	.o(wire_nii0i_o),
	.sel({nlllli, nlllll, wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11], wire_niOOl_o[8], wire_niOOl_o[0]}));
	defparam
		nii0i.width_data = 9,
		nii0i.width_sel = 9;
	oper_selector   nii0l
	( 
	.data({1'b0, 1'b1, (nlO ^ (n01OO ^ n00Oi)), nlOilO, nlO11i, (n000O ^ n00ii), wire_nlOil_dataout, nlOlil, (n01lO ^ (n01Oi ^ nlOlOi))}),
	.o(wire_nii0l_o),
	.sel({nllliO, nlllil, wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11], wire_niOOl_o[8], wire_niOOl_o[0]}));
	defparam
		nii0l.width_data = 9,
		nii0l.width_sel = 9;
	oper_selector   nii0O
	( 
	.data({1'b0, 1'b1, (n01ll ^ n001i), nlOi1l, nlO10i, nlOl1i, wire_nlOiO_dataout, nlOlii, (n01ll ^ (n01lO ^ (n01Oi ^ (n01Ol ^ (n001i ^ nlOlOi)))))}),
	.o(wire_nii0O_o),
	.sel({nlllli, nlllll, wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11], wire_niOOl_o[8], wire_niOOl_o[0]}));
	defparam
		nii0O.width_data = 9,
		nii0O.width_sel = 9;
	oper_selector   nii1i
	( 
	.data({1'b0, n00OO, n01Ol}),
	.o(wire_nii1i_o),
	.sel({nlllii, nlll0O, wire_niOOl_o[25]}));
	defparam
		nii1i.width_data = 3,
		nii1i.width_sel = 3;
	oper_selector   niiii
	( 
	.data({1'b0, 1'b1, (n01lO ^ n001l), nlOi1O, nlO1ii, nlOl0i, wire_nlOli_dataout, (n01Ol ^ n001l), (n01ll ^ (n01Oi ^ (n01Ol ^ (n01OO ^ (n001i ^ n001O)))))}),
	.o(wire_niiii_o),
	.sel({nllliO, nlllil, wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11], wire_niOOl_o[8], wire_niOOl_o[0]}));
	defparam
		niiii.width_data = 9,
		niiii.width_sel = 9;
	oper_selector   niili
	( 
	.data({1'b0, 1'b1, nllOOO, nlOi0O, nlO1li, nlOiiO, wire_nlOll_dataout, (n01OO ^ n001O), (n01ll ^ (n01Ol ^ n01OO))}),
	.o(wire_niili_o),
	.sel({nlllli, nlllll, wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11], wire_niOOl_o[8], wire_niOOl_o[0]}));
	defparam
		niili.width_data = 9,
		niili.width_sel = 9;
	oper_selector   niilO
	( 
	.data({1'b0, nlO11i, nlOiil, nlO1ll, nlOilO, wire_nlOlO_dataout, (n001i ^ n000i), (n01lO ^ (n01OO ^ n001i))}),
	.o(wire_niilO_o),
	.sel({nlllOl, wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11], wire_niOOl_o[8], wire_niOOl_o[0]}));
	defparam
		niilO.width_data = 8,
		niilO.width_sel = 8;
	oper_selector   niiOi
	( 
	.data({1'b0, 1'b1, nlO10i, (n00iO ^ nlO0iO), nlO1Ol, (n000l ^ nlO01i), wire_nlOOi_dataout, (n001l ^ n000l), (n01Oi ^ nlOllO)}),
	.o(wire_niiOi_o),
	.sel({nlllOi, nllllO, wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11], wire_niOOl_o[8], wire_niOOl_o[0]}));
	defparam
		niiOi.width_data = 9,
		niiOi.width_sel = 9;
	oper_selector   nil0O
	( 
	.data({1'b0, 1'b1, nlO1ll, (n00Oi ^ n00ll), nlO00i, (n00iO ^ n00ii), wire_n11i_dataout, (n000l ^ nlOlii)}),
	.o(wire_nil0O_o),
	.sel({nllO1i, wire_niOOl_o[28], wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11], wire_niOOl_o[8]}));
	defparam
		nil0O.width_data = 8,
		nil0O.width_sel = 8;
	oper_selector   nil1i
	( 
	.data({1'b0, nlO1ii, nlOiOi, nlO1OO, (n000l ^ n00ii), wire_nlOOl_dataout, (n001O ^ nlOliO), (n01Ol ^ nlOlOi)}),
	.o(wire_nil1i_o),
	.sel({nlllOl, wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11], wire_niOOl_o[8], wire_niOOl_o[0]}));
	defparam
		nil1i.width_data = 8,
		nil1i.width_sel = 8;
	oper_selector   nil1O
	( 
	.data({1'b0, 1'b1, nlO1li, (n00lO ^ n00li), nlO01i, (n00il ^ n000O), wire_nlOOO_dataout, (n000i ^ nlOlil)}),
	.o(wire_nil1O_o),
	.sel({nlllOO, (((wire_niOOl_o[28] | wire_niOOl_o[26]) | wire_niOOl_o[18]) | wire_niOOl_o[9]), wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11], wire_niOOl_o[8]}));
	defparam
		nil1O.width_data = 8,
		nil1O.width_sel = 8;
	oper_selector   nilil
	( 
	.data({1'b0, 1'b1, nlO1Ol, (n00Ol ^ n00lO), nlO0ii, (n00li ^ n00il), wire_n11l_dataout}),
	.o(wire_nilil_o),
	.sel({nllO0i, nllO1O, wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11]}));
	defparam
		nilil.width_data = 7,
		nilil.width_sel = 7;
	oper_selector   niliO
	( 
	.data({1'b0, 1'b1, nlO1OO, (n00OO ^ n00Oi), nlO0il, nlOiOi, wire_n11O_dataout}),
	.o(wire_niliO_o),
	.sel({nllO1l, wire_niOOl_o[27], wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11]}));
	defparam
		niliO.width_data = 7,
		niliO.width_sel = 7;
	oper_selector   nilli
	( 
	.data({1'b0, 1'b1, nlO01i, (n00iO ^ (n00Ol ^ n00li)), nlO0iO, (n000l ^ (n00li ^ n000O)), wire_n10i_dataout}),
	.o(wire_nilli_o),
	.sel({nllO0i, nllO1O, wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11]}));
	defparam
		nilli.width_data = 7,
		nilli.width_sel = 7;
	oper_selector   nilll
	( 
	.data({1'b0, 1'b1, nlO00i, (n00li ^ (n00OO ^ n00ll)), nlO0li, (n000O ^ (n00ll ^ n00ii)), wire_n10l_dataout}),
	.o(wire_nilll_o),
	.sel({nllO1l, wire_niOOl_o[27], wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11]}));
	defparam
		nilll.width_data = 7,
		nilll.width_sel = 7;
	oper_selector   nilOi
	( 
	.data({1'b0, 1'b1, nlO0ii, (n00iO ^ (n00li ^ nlOi1l)), nlO0Oi, (n000l ^ (n000O ^ nlOl1i)), wire_n10O_dataout}),
	.o(wire_nilOi_o),
	.sel({nllO0i, nllO1O, wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11]}));
	defparam
		nilOi.width_data = 7,
		nilOi.width_sel = 7;
	oper_selector   niO0i
	( 
	.data({1'b0, 1'b1, nlO0li, (n00lO ^ nlOiii), n01lO, wire_n1iO_dataout}),
	.o(wire_niO0i_o),
	.sel({nllO0O, wire_niOOl_o[28], wire_niOOl_o[25:24], wire_niOOl_o[17], wire_niOOl_o[11]}));
	defparam
		niO0i.width_data = 6,
		niO0i.width_sel = 6;
	oper_selector   niO0O
	( 
	.data({1'b0, 1'b1, nlO0Oi, (n00iO ^ (n00li ^ nlOiii)), n01Oi, wire_n1li_dataout}),
	.o(wire_niO0O_o),
	.sel({nllOii, wire_niOOl_o[26:24], wire_niOOl_o[17], wire_niOOl_o[11]}));
	defparam
		niO0O.width_data = 6,
		niO0O.width_sel = 6;
	oper_selector   niO1i
	( 
	.data({1'b0, 1'b1, nlO0il, (n00li ^ (n00ll ^ nlOi1O)), nlOi1i, (n000O ^ (n00ii ^ nlOl0i)), wire_n1ii_dataout}),
	.o(wire_niO1i_o),
	.sel({nllO0l, wire_niOOl_o[28], wire_niOOl_o[25:24], wire_niOOl_o[17:16], wire_niOOl_o[11]}));
	defparam
		niO1i.width_data = 7,
		niO1i.width_sel = 7;
	oper_selector   niO1O
	( 
	.data({1'b0, 1'b1, nlO0iO, (n00ll ^ (n00lO ^ nlOi0O)), n01ll, wire_n1il_dataout}),
	.o(wire_niO1O_o),
	.sel({nllOii, wire_niOOl_o[26:24], wire_niOOl_o[17], wire_niOOl_o[11]}));
	defparam
		niO1O.width_data = 6,
		niO1O.width_sel = 6;
	oper_selector   niOil
	( 
	.data({1'b0, nlOi1i, (n00iO ^ (n00ll ^ nlOiil)), n01Ol, wire_n1ll_dataout}),
	.o(wire_niOil_o),
	.sel({nllOil, wire_niOOl_o[25:24], wire_niOOl_o[17], wire_niOOl_o[11]}));
	defparam
		niOil.width_data = 5,
		niOil.width_sel = 5;
	oper_selector   niOli
	( 
	.data({1'b0, n01ll, n01OO, wire_n1lO_dataout}),
	.o(wire_niOli_o),
	.sel({nllOll, wire_niOOl_o[25], wire_niOOl_o[17], wire_niOOl_o[11]}));
	defparam
		niOli.width_data = 4,
		niOli.width_sel = 4;
	oper_selector   niOll
	( 
	.data({1'b0, n01lO, n001i, wire_n1Oi_dataout}),
	.o(wire_niOll_o),
	.sel({nllOll, wire_niOOl_o[25], wire_niOOl_o[17], wire_niOOl_o[11]}));
	defparam
		niOll.width_data = 4,
		niOll.width_sel = 4;
	oper_selector   niOlO
	( 
	.data({1'b0, n01Oi, n001l, wire_n1Ol_dataout}),
	.o(wire_niOlO_o),
	.sel({(nllOiO59 & nllOll), (nllOli56 & wire_niOOl_o[25]), wire_niOOl_o[17], wire_niOOl_o[11]}));
	defparam
		niOlO.width_data = 4,
		niOlO.width_sel = 4;
	assign
		nlll0i = (wire_niOOl_o[18] | wire_niOOl_o[16]),
		nlll0l = (((((((((wire_niOOl_o[11] | wire_niOOl_o[28]) | wire_niOOl_o[27]) | wire_niOOl_o[26]) | wire_niOOl_o[24]) | wire_niOOl_o[10]) | wire_niOOl_o[9]) | wire_niOOl_o[8]) | wire_niOOl_o[1]) | wire_niOOl_o[0]),
		nlll0O = (((((((((((wire_niOOl_o[11] | wire_niOOl_o[28]) | wire_niOOl_o[27]) | wire_niOOl_o[26]) | wire_niOOl_o[24]) | wire_niOOl_o[18]) | wire_niOOl_o[16]) | wire_niOOl_o[10]) | wire_niOOl_o[9]) | wire_niOOl_o[8]) | wire_niOOl_o[1]) | wire_niOOl_o[0]),
		nlll1i = (wire_niOOl_o[25] | wire_niOOl_o[17]),
		nlll1l = ((((((((((wire_niOOl_o[11] | wire_niOOl_o[28]) | wire_niOOl_o[27]) | wire_niOOl_o[26]) | wire_niOOl_o[24]) | wire_niOOl_o[10]) | wire_niOOl_o[9]) | wire_niOOl_o[8]) | wire_niOOl_o[1]) | wire_niOOl_o[0]) | wire_niOOl_o[25]),
		nlll1O = ((((((((((wire_niOOl_o[11] | wire_niOOl_o[28]) | wire_niOOl_o[27]) | wire_niOOl_o[26]) | wire_niOOl_o[24]) | wire_niOOl_o[10]) | wire_niOOl_o[9]) | wire_niOOl_o[8]) | wire_niOOl_o[1]) | wire_niOOl_o[0]) | wire_niOOl_o[17]),
		nlllii = ((((((((((((((((((wire_niOOl_o[31] | wire_niOOl_o[30]) | wire_niOOl_o[29]) | wire_niOOl_o[23]) | wire_niOOl_o[22]) | wire_niOOl_o[21]) | wire_niOOl_o[20]) | wire_niOOl_o[19]) | wire_niOOl_o[15]) | wire_niOOl_o[14]) | wire_niOOl_o[13]) | wire_niOOl_o[12]) | wire_niOOl_o[7]) | wire_niOOl_o[6]) | wire_niOOl_o[5]) | wire_niOOl_o[4]) | wire_niOOl_o[3]) | wire_niOOl_o[2]) | wire_niOOl_o[17]),
		nlllil = ((wire_niOOl_o[28] | wire_niOOl_o[27]) | wire_niOOl_o[10]),
		nllliO = (((((((((((((((((((((wire_niOOl_o[26] | wire_niOOl_o[18]) | wire_niOOl_o[9]) | wire_niOOl_o[1]) | wire_niOOl_o[31]) | wire_niOOl_o[30]) | wire_niOOl_o[29]) | wire_niOOl_o[23]) | wire_niOOl_o[22]) | wire_niOOl_o[21]) | wire_niOOl_o[20]) | wire_niOOl_o[19]) | wire_niOOl_o[15]) | wire_niOOl_o[14]) | wire_niOOl_o[13]) | wire_niOOl_o[12]) | wire_niOOl_o[7]) | wire_niOOl_o[6]) | wire_niOOl_o[5]) | wire_niOOl_o[4]) | wire_niOOl_o[3]) | wire_niOOl_o[2]),
		nlllli = (((((((((((((((((wire_niOOl_o[31] | wire_niOOl_o[30]) | wire_niOOl_o[29]) | wire_niOOl_o[23]) | wire_niOOl_o[22]) | wire_niOOl_o[21]) | wire_niOOl_o[20]) | wire_niOOl_o[19]) | wire_niOOl_o[15]) | wire_niOOl_o[14]) | wire_niOOl_o[13]) | wire_niOOl_o[12]) | wire_niOOl_o[7]) | wire_niOOl_o[6]) | wire_niOOl_o[5]) | wire_niOOl_o[4]) | wire_niOOl_o[3]) | wire_niOOl_o[2]),
		nlllll = ((((((wire_niOOl_o[28] | wire_niOOl_o[27]) | wire_niOOl_o[26]) | wire_niOOl_o[18]) | wire_niOOl_o[10]) | wire_niOOl_o[9]) | wire_niOOl_o[1]),
		nllllO = ((((wire_niOOl_o[28] | wire_niOOl_o[26]) | wire_niOOl_o[18]) | wire_niOOl_o[9]) | wire_niOOl_o[1]),
		nlllOi = (((((((((((((((((((wire_niOOl_o[27] | wire_niOOl_o[10]) | wire_niOOl_o[31]) | wire_niOOl_o[30]) | wire_niOOl_o[29]) | wire_niOOl_o[23]) | wire_niOOl_o[22]) | wire_niOOl_o[21]) | wire_niOOl_o[20]) | wire_niOOl_o[19]) | wire_niOOl_o[15]) | wire_niOOl_o[14]) | wire_niOOl_o[13]) | wire_niOOl_o[12]) | wire_niOOl_o[7]) | wire_niOOl_o[6]) | wire_niOOl_o[5]) | wire_niOOl_o[4]) | wire_niOOl_o[3]) | wire_niOOl_o[2]),
		nlllOl = ((((((((((((((((((((((((wire_niOOl_o[28] | wire_niOOl_o[27]) | wire_niOOl_o[26]) | wire_niOOl_o[18]) | wire_niOOl_o[10]) | wire_niOOl_o[9]) | wire_niOOl_o[1]) | wire_niOOl_o[31]) | wire_niOOl_o[30]) | wire_niOOl_o[29]) | wire_niOOl_o[23]) | wire_niOOl_o[22]) | wire_niOOl_o[21]) | wire_niOOl_o[20]) | wire_niOOl_o[19]) | wire_niOOl_o[15]) | wire_niOOl_o[14]) | wire_niOOl_o[13]) | wire_niOOl_o[12]) | wire_niOOl_o[7]) | wire_niOOl_o[6]) | wire_niOOl_o[5]) | wire_niOOl_o[4]) | wire_niOOl_o[3]) | wire_niOOl_o[2]),
		nlllOO = (((((((((((((((((((((wire_niOOl_o[27] | wire_niOOl_o[10]) | wire_niOOl_o[1]) | wire_niOOl_o[0]) | wire_niOOl_o[31]) | wire_niOOl_o[30]) | wire_niOOl_o[29]) | wire_niOOl_o[23]) | wire_niOOl_o[22]) | wire_niOOl_o[21]) | wire_niOOl_o[20]) | wire_niOOl_o[19]) | wire_niOOl_o[15]) | wire_niOOl_o[14]) | wire_niOOl_o[13]) | wire_niOOl_o[12]) | wire_niOOl_o[7]) | wire_niOOl_o[6]) | wire_niOOl_o[5]) | wire_niOOl_o[4]) | wire_niOOl_o[3]) | wire_niOOl_o[2]),
		nllO0i = (((((((((((((((((((((((wire_niOOl_o[28] | wire_niOOl_o[10]) | wire_niOOl_o[9]) | wire_niOOl_o[8]) | wire_niOOl_o[1]) | wire_niOOl_o[0]) | wire_niOOl_o[31]) | wire_niOOl_o[30]) | wire_niOOl_o[29]) | wire_niOOl_o[23]) | wire_niOOl_o[22]) | wire_niOOl_o[21]) | wire_niOOl_o[20]) | wire_niOOl_o[19]) | wire_niOOl_o[15]) | wire_niOOl_o[14]) | wire_niOOl_o[13]) | wire_niOOl_o[12]) | wire_niOOl_o[7]) | wire_niOOl_o[6]) | wire_niOOl_o[5]) | wire_niOOl_o[4]) | wire_niOOl_o[3]) | wire_niOOl_o[2]),
		nllO0l = (((((((((((((((((((((((((wire_niOOl_o[27] | wire_niOOl_o[26]) | wire_niOOl_o[18]) | wire_niOOl_o[10]) | wire_niOOl_o[9]) | wire_niOOl_o[8]) | wire_niOOl_o[1]) | wire_niOOl_o[0]) | wire_niOOl_o[31]) | wire_niOOl_o[30]) | wire_niOOl_o[29]) | wire_niOOl_o[23]) | wire_niOOl_o[22]) | wire_niOOl_o[21]) | wire_niOOl_o[20]) | wire_niOOl_o[19]) | wire_niOOl_o[15]) | wire_niOOl_o[14]) | wire_niOOl_o[13]) | wire_niOOl_o[12]) | wire_niOOl_o[7]) | wire_niOOl_o[6]) | wire_niOOl_o[5]) | wire_niOOl_o[4]) | wire_niOOl_o[3]) | wire_niOOl_o[2]),
		nllO0O = ((((((((((((((((((((((((((wire_niOOl_o[27] | wire_niOOl_o[26]) | wire_niOOl_o[18]) | wire_niOOl_o[16]) | wire_niOOl_o[10]) | wire_niOOl_o[9]) | wire_niOOl_o[8]) | wire_niOOl_o[1]) | wire_niOOl_o[0]) | wire_niOOl_o[31]) | wire_niOOl_o[30]) | wire_niOOl_o[29]) | wire_niOOl_o[23]) | wire_niOOl_o[22]) | wire_niOOl_o[21]) | wire_niOOl_o[20]) | wire_niOOl_o[19]) | wire_niOOl_o[15]) | wire_niOOl_o[14]) | wire_niOOl_o[13]) | wire_niOOl_o[12]) | wire_niOOl_o[7]) | wire_niOOl_o[6]) | wire_niOOl_o[5]) | wire_niOOl_o[4]) | wire_niOOl_o[3]) | wire_niOOl_o[2]),
		nllO1i = ((((((((((((((((((((((((wire_niOOl_o[27] | wire_niOOl_o[26]) | wire_niOOl_o[18]) | wire_niOOl_o[10]) | wire_niOOl_o[9]) | wire_niOOl_o[1]) | wire_niOOl_o[0]) | wire_niOOl_o[31]) | wire_niOOl_o[30]) | wire_niOOl_o[29]) | wire_niOOl_o[23]) | wire_niOOl_o[22]) | wire_niOOl_o[21]) | wire_niOOl_o[20]) | wire_niOOl_o[19]) | wire_niOOl_o[15]) | wire_niOOl_o[14]) | wire_niOOl_o[13]) | wire_niOOl_o[12]) | wire_niOOl_o[7]) | wire_niOOl_o[6]) | wire_niOOl_o[5]) | wire_niOOl_o[4]) | wire_niOOl_o[3]) | wire_niOOl_o[2]),
		nllO1l = (((((((((((((((((((((((((wire_niOOl_o[28] | wire_niOOl_o[26]) | wire_niOOl_o[18]) | wire_niOOl_o[10]) | wire_niOOl_o[9]) | wire_niOOl_o[8]) | wire_niOOl_o[1]) | wire_niOOl_o[0]) | wire_niOOl_o[31]) | wire_niOOl_o[30]) | wire_niOOl_o[29]) | wire_niOOl_o[23]) | wire_niOOl_o[22]) | wire_niOOl_o[21]) | wire_niOOl_o[20]) | wire_niOOl_o[19]) | wire_niOOl_o[15]) | wire_niOOl_o[14]) | wire_niOOl_o[13]) | wire_niOOl_o[12]) | wire_niOOl_o[7]) | wire_niOOl_o[6]) | wire_niOOl_o[5]) | wire_niOOl_o[4]) | wire_niOOl_o[3]) | wire_niOOl_o[2]),
		nllO1O = ((wire_niOOl_o[27] | wire_niOOl_o[26]) | wire_niOOl_o[18]),
		nllOii = ((((((((((((((((((((((((((wire_niOOl_o[28] | wire_niOOl_o[27]) | wire_niOOl_o[18]) | wire_niOOl_o[16]) | wire_niOOl_o[10]) | wire_niOOl_o[9]) | wire_niOOl_o[8]) | wire_niOOl_o[1]) | wire_niOOl_o[0]) | wire_niOOl_o[31]) | wire_niOOl_o[30]) | wire_niOOl_o[29]) | wire_niOOl_o[23]) | wire_niOOl_o[22]) | wire_niOOl_o[21]) | wire_niOOl_o[20]) | wire_niOOl_o[19]) | wire_niOOl_o[15]) | wire_niOOl_o[14]) | wire_niOOl_o[13]) | wire_niOOl_o[12]) | wire_niOOl_o[7]) | wire_niOOl_o[6]) | wire_niOOl_o[5]) | wire_niOOl_o[4]) | wire_niOOl_o[3]) | wire_niOOl_o[2]),
		nllOil = (((((((((((((((((((((((((((wire_niOOl_o[28] | wire_niOOl_o[27]) | wire_niOOl_o[26]) | wire_niOOl_o[18]) | wire_niOOl_o[16]) | wire_niOOl_o[10]) | wire_niOOl_o[9]) | wire_niOOl_o[8]) | wire_niOOl_o[1]) | wire_niOOl_o[0]) | wire_niOOl_o[31]) | wire_niOOl_o[30]) | wire_niOOl_o[29]) | wire_niOOl_o[23]) | wire_niOOl_o[22]) | wire_niOOl_o[21]) | wire_niOOl_o[20]) | wire_niOOl_o[19]) | wire_niOOl_o[15]) | wire_niOOl_o[14]) | wire_niOOl_o[13]) | wire_niOOl_o[12]) | wire_niOOl_o[7]) | wire_niOOl_o[6]) | wire_niOOl_o[5]) | wire_niOOl_o[4]) | wire_niOOl_o[3]) | wire_niOOl_o[2]),
		nllOll = (((((((((((((((((((((((((((((wire_niOOl_o[28] | wire_niOOl_o[27]) | wire_niOOl_o[26]) | wire_niOOl_o[24]) | wire_niOOl_o[18]) | wire_niOOl_o[16]) | wire_niOOl_o[10]) | wire_niOOl_o[9]) | wire_niOOl_o[8]) | wire_niOOl_o[1]) | wire_niOOl_o[0]) | wire_niOOl_o[31]) | wire_niOOl_o[30]) | wire_niOOl_o[29]) | wire_niOOl_o[23]) | wire_niOOl_o[22]) | wire_niOOl_o[21]) | wire_niOOl_o[20]) | wire_niOOl_o[19]) | wire_niOOl_o[15]) | wire_niOOl_o[14]) | wire_niOOl_o[13]) | wire_niOOl_o[12]) | wire_niOOl_o[7]) | wire_niOOl_o[6]) | wire_niOOl_o[5]) | wire_niOOl_o[4]) | wire_niOOl_o[3]) | wire_niOOl_o[2]) | (~ nllOlO53)),
		nllOOO = (n01Oi ^ n001O),
		nlO00i = ((n00lO ^ n00ii) ^ (~ nlO00l32)),
		nlO01i = ((n00ll ^ n000O) ^ (~ nlO01l35)),
		nlO0ii = (n00Oi ^ n00il),
		nlO0il = (n00Ol ^ n00iO),
		nlO0iO = (n00OO ^ n00li),
		nlO0li = ((n0i1i ^ n00ll) ^ (~ nlO0ll29)),
		nlO0Oi = ((n0i1l ^ n00lO) ^ (~ nlO0Ol26)),
		nlO10i = ((n01OO ^ n000l) ^ (~ nlO10l44)),
		nlO11i = ((n01Ol ^ n000i) ^ (~ nlO11l47)),
		nlO1ii = ((n001i ^ n000O) ^ (~ nlO1il41)),
		nlO1li = (n001l ^ n00ii),
		nlO1ll = ((n001O ^ n00il) ^ (~ nlO1lO38)),
		nlO1Ol = (n000i ^ n00iO),
		nlO1OO = (n00li ^ n000l),
		nlOi0O = (n00Ol ^ n00Oi),
		nlOi1i = (nlO ^ n00Oi),
		nlOi1l = (n00lO ^ n00ll),
		nlOi1O = ((n00Oi ^ n00lO) ^ (~ nlOi0i23)),
		nlOiii = (n00Oi ^ nlOiil),
		nlOiil = (n00OO ^ n00Ol),
		nlOiiO = ((n00li ^ n00iO) ^ (~ nlOili20)),
		nlOilO = (n00ll ^ n00li),
		nlOiOi = ((n00ll ^ n00iO) ^ (~ nlOiOl17)),
		nlOl0i = ((n00iO ^ n00il) ^ (~ nlOl0l11)),
		nlOl1i = ((n00il ^ n00ii) ^ (~ nlOl1l14)),
		nlOlii = (n01Oi ^ n001i),
		nlOlil = (n01lO ^ n01OO),
		nlOliO = ((n01ll ^ n01Ol) ^ (~ nlOlli8)),
		nlOllO = (n001i ^ n001l),
		nlOlOi = ((n001l ^ n001O) ^ (~ nlOlOl5)),
		nlOO0O = 1'b1,
		nlOO1i = (wire_niOOl_o[24] | wire_niOOl_o[16]),
		nlOO1l = (((~ ni) & nO) & nlOO1O2),
		prbs_out = {n01li, n01il, n010O, n010i, n011l, n1OOO, n1OOi, n1Oll, n1OiO, n1Oii, n1O0l, n1O1O, n1O1i, n1lOl, n1llO, n1lli, n1lil, n1l0O, n1l0i, n1l1l};
endmodule //stratixiigx_hssi_tx_prbs_gen
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 130 mux21 122 oper_decoder 4 oper_selector 110 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_tx_enc_chnl_top
	( 
	cascaded_8b10b_en,
	clk,
	d21_5_eq_n,
	d2_2_eq_n,
	disp_out_3b,
	doublewidth,
	dwidth,
	endec,
	enpolinv_tx,
	ge_xaui_sel,
	ib_force_disparity,
	k_det,
	prbs_en,
	pudr,
	r8b10b_enc_ibm_en,
	renbitrev_tx,
	rendec_data_sel_tx,
	renpolinv_tx,
	rensymswap_tx,
	rev_loop_data,
	rev_loopbk,
	rforce_disp,
	rrev_loopbk,
	rst,
	tx_ctl_pre_en,
	tx_ctl_tc,
	tx_ctl_ts,
	tx_data_9_pre_en,
	tx_data_9_tc,
	tx_data_pg,
	tx_data_pre_en,
	tx_data_tc,
	tx_data_ts,
	txd_extend_tc,
	txlp20b) /* synthesis synthesis_clearbox=1 */;
	input   cascaded_8b10b_en;
	input   clk;
	input   d21_5_eq_n;
	input   d2_2_eq_n;
	output   [1:0]  disp_out_3b;
	input   doublewidth;
	input   dwidth;
	input   endec;
	input   enpolinv_tx;
	input   ge_xaui_sel;
	input   ib_force_disparity;
	input   k_det;
	input   prbs_en;
	output   [19:0]  pudr;
	input   r8b10b_enc_ibm_en;
	input   renbitrev_tx;
	input   rendec_data_sel_tx;
	input   renpolinv_tx;
	input   rensymswap_tx;
	input   [19:0]  rev_loop_data;
	input   rev_loopbk;
	input   rforce_disp;
	input   rrev_loopbk;
	input   rst;
	output   [1:0]  tx_ctl_pre_en;
	input   [1:0]  tx_ctl_tc;
	input   tx_ctl_ts;
	output   [1:0]  tx_data_9_pre_en;
	input   [1:0]  tx_data_9_tc;
	input   [19:0]  tx_data_pg;
	output   [15:0]  tx_data_pre_en;
	input   [15:0]  tx_data_tc;
	input   [7:0]  tx_data_ts;
	input   [1:0]  txd_extend_tc;
	output   [19:0]  txlp20b;

	reg	nillOO58;
	reg	nillOO59;
	reg	nillOO60;
	reg	nilO0i46;
	reg	nilO0i47;
	reg	nilO0i48;
	reg	nilO0l43;
	reg	nilO0l44;
	reg	nilO0l45;
	reg	nilO0O40;
	reg	nilO0O41;
	reg	nilO0O42;
	reg	nilO1i55;
	reg	nilO1i56;
	reg	nilO1i57;
	reg	nilO1l52;
	reg	nilO1l53;
	reg	nilO1l54;
	reg	nilO1O49;
	reg	nilO1O50;
	reg	nilO1O51;
	reg	nilOii37;
	reg	nilOii38;
	reg	nilOii39;
	reg	nilOil34;
	reg	nilOil35;
	reg	nilOil36;
	reg	nilOiO31;
	reg	nilOiO32;
	reg	nilOiO33;
	reg	nilOli28;
	reg	nilOli29;
	reg	nilOli30;
	reg	nilOll25;
	reg	nilOll26;
	reg	nilOll27;
	reg	nilOlO22;
	reg	nilOlO23;
	reg	nilOlO24;
	reg	nilOOO19;
	reg	nilOOO20;
	reg	nilOOO21;
	reg	niO10l13;
	reg	niO10l14;
	reg	niO10l15;
	reg	niO11l16;
	reg	niO11l17;
	reg	niO11l18;
	reg	niO1ii10;
	reg	niO1ii11;
	reg	niO1ii12;
	reg	niO1iO7;
	reg	niO1iO8;
	reg	niO1iO9;
	reg	niO1lO4;
	reg	niO1lO5;
	reg	niO1lO6;
	reg	niO1Ol1;
	reg	niO1Ol2;
	reg	niO1Ol3;
	reg	n001l;
	reg	n010i;
	reg	n010l;
	reg	n010O;
	reg	n011i;
	reg	n011l;
	reg	n011O;
	reg	n01ii;
	reg	n01il;
	reg	n01iO;
	reg	n01li;
	reg	n01ll;
	reg	n01lO;
	reg	n01Oi;
	reg	n01Ol;
	reg	n01OO;
	reg	n1OlO;
	reg	n1OOi;
	reg	n1OOl;
	reg	n1OOO;
	reg	n0l1O;
	wire	wire_n0l1l_ENA;
	reg	n0iOi;
	reg	n0iOl;
	reg	n0l0i;
	reg	n0l0l;
	reg	n0l0O;
	reg	n0l1i;
	reg	n0lii;
	reg	n0lil;
	reg	n0liO;
	reg	n0lli;
	reg	n0lll;
	reg	n0llO;
	reg	n0lOi;
	reg	n0lOl;
	reg	n0lOO;
	reg	n0O0i;
	reg	n0O0l;
	reg	n0O0O;
	reg	n0O1i;
	reg	n0O1l;
	reg	n0O1O;
	reg	n0Oii;
	reg	n0Oil;
	reg	n0OiO;
	reg	n0Oli;
	reg	n0Oll;
	reg	n0OlO;
	reg	n0OOi;
	reg	n0OOl;
	reg	n0OOO;
	reg	ni10i;
	reg	ni10l;
	reg	ni10O;
	reg	ni11i;
	reg	ni11l;
	reg	ni11O;
	reg	ni1ii;
	reg	ni1il;
	reg	nii0l;
	reg	nii0O;
	reg	niiii;
	reg	niiil;
	reg	niiiO;
	reg	niili;
	reg	niill;
	reg	niilO;
	reg	niiOi;
	reg	niiOl;
	reg	nil1i;
	wire	wire_n00i_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0iOO_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_ni01i_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0il_dataout;
	wire	wire_ni0iO_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0Ol_dataout;
	wire	wire_ni0OO_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1lO_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1Oi_dataout;
	wire	wire_ni1Ol_dataout;
	wire	wire_ni1OO_dataout;
	wire	wire_nii_dataout;
	wire	wire_niii_dataout;
	wire	wire_niil_dataout;
	wire	wire_niiO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nili_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOO_dataout;
	wire	wire_niOOOl_dataout;
	wire	wire_nl00ii_dataout;
	wire	wire_nl00li_dataout;
	wire	wire_nl00ll_dataout;
	wire	wire_nl00OO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0i0i_dataout;
	wire	wire_nl0i0l_dataout;
	wire	wire_nl0i0O_dataout;
	wire	wire_nl0i1l_dataout;
	wire	wire_nl0i1O_dataout;
	wire	wire_nl0ilO_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl100i_dataout;
	wire	wire_nl101i_dataout;
	wire	wire_nl101l_dataout;
	wire	wire_nl101O_dataout;
	wire	wire_nl11Ol_dataout;
	wire	wire_nl11OO_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1iOO_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1l1i_dataout;
	wire	wire_nl1lii_dataout;
	wire	wire_nl1lil_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli0iO_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nliiiO_dataout;
	wire	wire_nliili_dataout;
	wire	wire_nliill_dataout;
	wire	wire_nliilO_dataout;
	wire	wire_nliiOi_dataout;
	wire	wire_nliiOl_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliOli_dataout;
	wire	wire_nliOll_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll11l_dataout;
	wire	wire_nll11O_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlll0l_dataout;
	wire	wire_nlll0O_dataout;
	wire	wire_nlll1l_dataout;
	wire	wire_nlllli_dataout;
	wire	wire_nllllO_dataout;
	wire	wire_nlllOi_dataout;
	wire	wire_nlllOl_dataout;
	wire	wire_nlllOO_dataout;
	wire	wire_nllO1i_dataout;
	wire	wire_nllOii_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOO_dataout;
	wire  [15:0]   wire_n0ilO_o;
	wire  [3:0]   wire_niOii_o;
	wire  [7:0]   wire_nl1Oi_o;
	wire  [3:0]   wire_nllll_o;
	wire  wire_n000i_o;
	wire  wire_n000l_o;
	wire  wire_n000O_o;
	wire  wire_n001O_o;
	wire  wire_n00ii_o;
	wire  wire_n00il_o;
	wire  wire_n00iO_o;
	wire  wire_n00li_o;
	wire  wire_n00ll_o;
	wire  wire_n00lO_o;
	wire  wire_n00Oi_o;
	wire  wire_n0i0i_o;
	wire  wire_n0i0l_o;
	wire  wire_n0i0O_o;
	wire  wire_n0i1O_o;
	wire  wire_n0iii_o;
	wire  wire_n0iil_o;
	wire  wire_n0iiO_o;
	wire  wire_n0ili_o;
	wire  wire_n0ill_o;
	wire  wire_nil0i_o;
	wire  wire_nil0l_o;
	wire  wire_nil0O_o;
	wire  wire_nil1l_o;
	wire  wire_nil1O_o;
	wire  wire_nilii_o;
	wire  wire_nilil_o;
	wire  wire_niliO_o;
	wire  wire_nilli_o;
	wire  wire_nilll_o;
	wire  wire_nillO_o;
	wire  wire_nilOi_o;
	wire  wire_nilOl_o;
	wire  wire_nilOO_o;
	wire  wire_niO0i_o;
	wire  wire_niO0l_o;
	wire  wire_niO0O_o;
	wire  wire_niO1i_o;
	wire  wire_niO1l_o;
	wire  wire_niO1O_o;
	wire  wire_niOil_o;
	wire  wire_niOiO_o;
	wire  wire_niOli_o;
	wire  wire_niOll_o;
	wire  wire_niOlO_o;
	wire  wire_niOOi_o;
	wire  wire_niOOl_o;
	wire  wire_niOOO_o;
	wire  wire_nl00i_o;
	wire  wire_nl00l_o;
	wire  wire_nl00O_o;
	wire  wire_nl01i_o;
	wire  wire_nl01l_o;
	wire  wire_nl01O_o;
	wire  wire_nl0ii_o;
	wire  wire_nl0il_o;
	wire  wire_nl0iO_o;
	wire  wire_nl0li_o;
	wire  wire_nl0ll_o;
	wire  wire_nl0lO_o;
	wire  wire_nl0Oi_o;
	wire  wire_nl0Ol_o;
	wire  wire_nl0OO_o;
	wire  wire_nl10i_o;
	wire  wire_nl10l_o;
	wire  wire_nl10O_o;
	wire  wire_nl11i_o;
	wire  wire_nl11l_o;
	wire  wire_nl11O_o;
	wire  wire_nl1ii_o;
	wire  wire_nl1il_o;
	wire  wire_nl1iO_o;
	wire  wire_nl1li_o;
	wire  wire_nl1ll_o;
	wire  wire_nl1lO_o;
	wire  wire_nl1Ol_o;
	wire  wire_nl1OO_o;
	wire  wire_nli0l_o;
	wire  wire_nli0O_o;
	wire  wire_nli1i_o;
	wire  wire_nli1l_o;
	wire  wire_nli1O_o;
	wire  wire_nliii_o;
	wire  wire_nliil_o;
	wire  wire_nliiO_o;
	wire  wire_nlili_o;
	wire  wire_nlill_o;
	wire  wire_nlilO_o;
	wire  wire_nliOi_o;
	wire  wire_nliOl_o;
	wire  wire_nliOO_o;
	wire  wire_nll0i_o;
	wire  wire_nll0l_o;
	wire  wire_nll0O_o;
	wire  wire_nll1i_o;
	wire  wire_nll1l_o;
	wire  wire_nll1O_o;
	wire  wire_nllii_o;
	wire  wire_nllil_o;
	wire  wire_nlliO_o;
	wire  wire_nlllO_o;
	wire  wire_nllOi_o;
	wire  wire_nllOl_o;
	wire  wire_nllOO_o;
	wire  wire_nlO0i_o;
	wire  wire_nlO0l_o;
	wire  wire_nlO0O_o;
	wire  wire_nlO1i_o;
	wire  wire_nlO1l_o;
	wire  wire_nlO1O_o;
	wire  niiOOO;
	wire  nil00i;
	wire  nil00l;
	wire  nil00O;
	wire  nil01i;
	wire  nil01l;
	wire  nil01O;
	wire  nil0ii;
	wire  nil0il;
	wire  nil0iO;
	wire  nil0li;
	wire  nil0ll;
	wire  nil0lO;
	wire  nil0Oi;
	wire  nil0Ol;
	wire  nil0OO;
	wire  nil10i;
	wire  nil10l;
	wire  nil10O;
	wire  nil11i;
	wire  nil11l;
	wire  nil11O;
	wire  nil1ii;
	wire  nil1il;
	wire  nil1iO;
	wire  nil1li;
	wire  nil1ll;
	wire  nil1lO;
	wire  nil1Oi;
	wire  nil1Ol;
	wire  nil1OO;
	wire  nili0i;
	wire  nili0l;
	wire  nili0O;
	wire  nili1i;
	wire  nili1l;
	wire  nili1O;
	wire  niliii;
	wire  niliil;
	wire  niliiO;
	wire  nilili;
	wire  nilill;
	wire  nililO;
	wire  niliOi;
	wire  niliOl;
	wire  niliOO;
	wire  nill0i;
	wire  nill0l;
	wire  nill0O;
	wire  nill1i;
	wire  nill1l;
	wire  nill1O;
	wire  nillii;
	wire  nillil;
	wire  nilliO;
	wire  nillli;
	wire  nillll;
	wire  nilllO;
	wire  nillOi;
	wire  nillOl;
	wire  nilOOi;
	wire  nilOOl;
	wire  niO10i;
	wire  niO1ll;

	initial
		nillOO58 = {1{1'b1}};
	always @ ( posedge clk)
		  nillOO58 <= nillOO60;
	initial
		nillOO59 = {1{1'b1}};
	always @ ( posedge clk)
		  nillOO59 <= (nillOO60 ^ nillOO58);
	initial
		nillOO60 = 0;
	always @ ( posedge clk)
		  nillOO60 <= nillOO58;
	initial
		nilO0i46 = {1{1'b1}};
	always @ ( posedge clk)
		  nilO0i46 <= nilO0i48;
	initial
		nilO0i47 = {1{1'b1}};
	always @ ( posedge clk)
		  nilO0i47 <= (nilO0i48 ^ nilO0i46);
	initial
		nilO0i48 = 0;
	always @ ( posedge clk)
		  nilO0i48 <= nilO0i46;
	initial
		nilO0l43 = {1{1'b1}};
	always @ ( posedge clk)
		  nilO0l43 <= nilO0l45;
	initial
		nilO0l44 = {1{1'b1}};
	always @ ( posedge clk)
		  nilO0l44 <= (nilO0l45 ^ nilO0l43);
	initial
		nilO0l45 = 0;
	always @ ( posedge clk)
		  nilO0l45 <= nilO0l43;
	initial
		nilO0O40 = {1{1'b1}};
	always @ ( posedge clk)
		  nilO0O40 <= nilO0O42;
	initial
		nilO0O41 = {1{1'b1}};
	always @ ( posedge clk)
		  nilO0O41 <= (nilO0O42 ^ nilO0O40);
	initial
		nilO0O42 = 0;
	always @ ( posedge clk)
		  nilO0O42 <= nilO0O40;
	initial
		nilO1i55 = {1{1'b1}};
	always @ ( posedge clk)
		  nilO1i55 <= nilO1i57;
	initial
		nilO1i56 = {1{1'b1}};
	always @ ( posedge clk)
		  nilO1i56 <= (nilO1i57 ^ nilO1i55);
	initial
		nilO1i57 = 0;
	always @ ( posedge clk)
		  nilO1i57 <= nilO1i55;
	initial
		nilO1l52 = {1{1'b1}};
	always @ ( posedge clk)
		  nilO1l52 <= nilO1l54;
	initial
		nilO1l53 = {1{1'b1}};
	always @ ( posedge clk)
		  nilO1l53 <= (nilO1l54 ^ nilO1l52);
	initial
		nilO1l54 = 0;
	always @ ( posedge clk)
		  nilO1l54 <= nilO1l52;
	initial
		nilO1O49 = {1{1'b1}};
	always @ ( posedge clk)
		  nilO1O49 <= nilO1O51;
	initial
		nilO1O50 = {1{1'b1}};
	always @ ( posedge clk)
		  nilO1O50 <= (nilO1O51 ^ nilO1O49);
	initial
		nilO1O51 = 0;
	always @ ( posedge clk)
		  nilO1O51 <= nilO1O49;
	initial
		nilOii37 = {1{1'b1}};
	always @ ( posedge clk)
		  nilOii37 <= nilOii39;
	initial
		nilOii38 = {1{1'b1}};
	always @ ( posedge clk)
		  nilOii38 <= (nilOii39 ^ nilOii37);
	initial
		nilOii39 = 0;
	always @ ( posedge clk)
		  nilOii39 <= nilOii37;
	initial
		nilOil34 = {1{1'b1}};
	always @ ( posedge clk)
		  nilOil34 <= nilOil36;
	initial
		nilOil35 = {1{1'b1}};
	always @ ( posedge clk)
		  nilOil35 <= (nilOil36 ^ nilOil34);
	initial
		nilOil36 = 0;
	always @ ( posedge clk)
		  nilOil36 <= nilOil34;
	initial
		nilOiO31 = {1{1'b1}};
	always @ ( posedge clk)
		  nilOiO31 <= nilOiO33;
	initial
		nilOiO32 = {1{1'b1}};
	always @ ( posedge clk)
		  nilOiO32 <= (nilOiO33 ^ nilOiO31);
	initial
		nilOiO33 = 0;
	always @ ( posedge clk)
		  nilOiO33 <= nilOiO31;
	initial
		nilOli28 = {1{1'b1}};
	always @ ( posedge clk)
		  nilOli28 <= nilOli30;
	initial
		nilOli29 = {1{1'b1}};
	always @ ( posedge clk)
		  nilOli29 <= (nilOli30 ^ nilOli28);
	initial
		nilOli30 = 0;
	always @ ( posedge clk)
		  nilOli30 <= nilOli28;
	initial
		nilOll25 = {1{1'b1}};
	always @ ( posedge clk)
		  nilOll25 <= nilOll27;
	initial
		nilOll26 = {1{1'b1}};
	always @ ( posedge clk)
		  nilOll26 <= (nilOll27 ^ nilOll25);
	initial
		nilOll27 = 0;
	always @ ( posedge clk)
		  nilOll27 <= nilOll25;
	initial
		nilOlO22 = {1{1'b1}};
	always @ ( posedge clk)
		  nilOlO22 <= nilOlO24;
	initial
		nilOlO23 = {1{1'b1}};
	always @ ( posedge clk)
		  nilOlO23 <= (nilOlO24 ^ nilOlO22);
	initial
		nilOlO24 = 0;
	always @ ( posedge clk)
		  nilOlO24 <= nilOlO22;
	initial
		nilOOO19 = {1{1'b1}};
	always @ ( posedge clk)
		  nilOOO19 <= nilOOO21;
	initial
		nilOOO20 = {1{1'b1}};
	always @ ( posedge clk)
		  nilOOO20 <= (nilOOO21 ^ nilOOO19);
	initial
		nilOOO21 = 0;
	always @ ( posedge clk)
		  nilOOO21 <= nilOOO19;
	initial
		niO10l13 = {1{1'b1}};
	always @ ( posedge clk)
		  niO10l13 <= niO10l15;
	initial
		niO10l14 = {1{1'b1}};
	always @ ( posedge clk)
		  niO10l14 <= (niO10l15 ^ niO10l13);
	initial
		niO10l15 = 0;
	always @ ( posedge clk)
		  niO10l15 <= niO10l13;
	initial
		niO11l16 = {1{1'b1}};
	always @ ( posedge clk)
		  niO11l16 <= niO11l18;
	initial
		niO11l17 = {1{1'b1}};
	always @ ( posedge clk)
		  niO11l17 <= (niO11l18 ^ niO11l16);
	initial
		niO11l18 = 0;
	always @ ( posedge clk)
		  niO11l18 <= niO11l16;
	initial
		niO1ii10 = {1{1'b1}};
	always @ ( posedge clk)
		  niO1ii10 <= niO1ii12;
	initial
		niO1ii11 = {1{1'b1}};
	always @ ( posedge clk)
		  niO1ii11 <= (niO1ii12 ^ niO1ii10);
	initial
		niO1ii12 = 0;
	always @ ( posedge clk)
		  niO1ii12 <= niO1ii10;
	initial
		niO1iO7 = {1{1'b1}};
	always @ ( posedge clk)
		  niO1iO7 <= niO1iO9;
	initial
		niO1iO8 = {1{1'b1}};
	always @ ( posedge clk)
		  niO1iO8 <= (niO1iO9 ^ niO1iO7);
	initial
		niO1iO9 = 0;
	always @ ( posedge clk)
		  niO1iO9 <= niO1iO7;
	initial
		niO1lO4 = {1{1'b1}};
	always @ ( posedge clk)
		  niO1lO4 <= niO1lO6;
	initial
		niO1lO5 = {1{1'b1}};
	always @ ( posedge clk)
		  niO1lO5 <= (niO1lO6 ^ niO1lO4);
	initial
		niO1lO6 = 0;
	always @ ( posedge clk)
		  niO1lO6 <= niO1lO4;
	initial
		niO1Ol1 = {1{1'b1}};
	always @ ( posedge clk)
		  niO1Ol1 <= niO1Ol3;
	initial
		niO1Ol2 = {1{1'b1}};
	always @ ( posedge clk)
		  niO1Ol2 <= (niO1Ol3 ^ niO1Ol1);
	initial
		niO1Ol3 = 0;
	always @ ( posedge clk)
		  niO1Ol3 <= niO1Ol1;
	initial
	begin
		n001l = 0;
		n010i = 0;
		n010l = 0;
		n010O = 0;
		n011i = 0;
		n011l = 0;
		n011O = 0;
		n01ii = 0;
		n01il = 0;
		n01iO = 0;
		n01li = 0;
		n01ll = 0;
		n01lO = 0;
		n01Oi = 0;
		n01Ol = 0;
		n01OO = 0;
		n1OlO = 0;
		n1OOi = 0;
		n1OOl = 0;
		n1OOO = 0;
	end
	always @ ( posedge clk or posedge rst)
	begin
		if (rst == 1'b1) 
		begin
			n001l <= 1;
			n010i <= 1;
			n010l <= 1;
			n010O <= 1;
			n011i <= 1;
			n011l <= 1;
			n011O <= 1;
			n01ii <= 1;
			n01il <= 1;
			n01iO <= 1;
			n01li <= 1;
			n01ll <= 1;
			n01lO <= 1;
			n01Oi <= 1;
			n01Ol <= 1;
			n01OO <= 1;
			n1OlO <= 1;
			n1OOi <= 1;
			n1OOl <= 1;
			n1OOO <= 1;
		end
		else 
		begin
			n001l <= wire_niO0O_o;
			n010i <= n01Ol;
			n010l <= n01OO;
			n010O <= n001l;
			n011i <= n01ll;
			n011l <= n01lO;
			n011O <= n01Oi;
			n01ii <= wire_nil0i_o;
			n01il <= wire_nil0l_o;
			n01iO <= wire_nil0O_o;
			n01li <= wire_nilii_o;
			n01ll <= wire_nilil_o;
			n01lO <= wire_nilli_o;
			n01Oi <= wire_nillO_o;
			n01Ol <= wire_nilOi_o;
			n01OO <= wire_niO0i_o;
			n1OlO <= n01ii;
			n1OOi <= n01il;
			n1OOl <= n01iO;
			n1OOO <= n01li;
		end
	end
	initial
	begin
		n0l1O = 0;
	end
	always @ ( posedge clk or posedge rst)
	begin
		if (rst == 1'b1) 
		begin
			n0l1O <= 0;
		end
		else if  (wire_n0l1l_ENA == 1'b1) 
		begin
			n0l1O <= nillOi;
		end
	end
	assign
		wire_n0l1l_ENA = ((~ n0l1O) & (tx_data_9_tc[0] & ib_force_disparity));
	initial
	begin
		n0iOi = 0;
		n0iOl = 0;
		n0l0i = 0;
		n0l0l = 0;
		n0l0O = 0;
		n0l1i = 0;
		n0lii = 0;
		n0lil = 0;
		n0liO = 0;
		n0lli = 0;
		n0lll = 0;
		n0llO = 0;
		n0lOi = 0;
		n0lOl = 0;
		n0lOO = 0;
		n0O0i = 0;
		n0O0l = 0;
		n0O0O = 0;
		n0O1i = 0;
		n0O1l = 0;
		n0O1O = 0;
		n0Oii = 0;
		n0Oil = 0;
		n0OiO = 0;
		n0Oli = 0;
		n0Oll = 0;
		n0OlO = 0;
		n0OOi = 0;
		n0OOl = 0;
		n0OOO = 0;
		ni10i = 0;
		ni10l = 0;
		ni10O = 0;
		ni11i = 0;
		ni11l = 0;
		ni11O = 0;
		ni1ii = 0;
		ni1il = 0;
		nii0l = 0;
		nii0O = 0;
		niiii = 0;
		niiil = 0;
		niiiO = 0;
		niili = 0;
		niill = 0;
		niilO = 0;
		niiOi = 0;
		niiOl = 0;
		nil1i = 0;
	end
	always @ ( posedge clk or posedge rst)
	begin
		if (rst == 1'b1) 
		begin
			n0iOi <= 0;
			n0iOl <= 0;
			n0l0i <= 0;
			n0l0l <= 0;
			n0l0O <= 0;
			n0l1i <= 0;
			n0lii <= 0;
			n0lil <= 0;
			n0liO <= 0;
			n0lli <= 0;
			n0lll <= 0;
			n0llO <= 0;
			n0lOi <= 0;
			n0lOl <= 0;
			n0lOO <= 0;
			n0O0i <= 0;
			n0O0l <= 0;
			n0O0O <= 0;
			n0O1i <= 0;
			n0O1l <= 0;
			n0O1O <= 0;
			n0Oii <= 0;
			n0Oil <= 0;
			n0OiO <= 0;
			n0Oli <= 0;
			n0Oll <= 0;
			n0OlO <= 0;
			n0OOi <= 0;
			n0OOl <= 0;
			n0OOO <= 0;
			ni10i <= 0;
			ni10l <= 0;
			ni10O <= 0;
			ni11i <= 0;
			ni11l <= 0;
			ni11O <= 0;
			ni1ii <= 0;
			ni1il <= 0;
			nii0l <= 0;
			nii0O <= 0;
			niiii <= 0;
			niiil <= 0;
			niiiO <= 0;
			niili <= 0;
			niill <= 0;
			niilO <= 0;
			niiOi <= 0;
			niiOl <= 0;
			nil1i <= 0;
		end
		else 
		begin
			n0iOi <= n0iOl;
			n0iOl <= rev_loopbk;
			n0l0i <= tx_data_9_tc[0];
			n0l0l <= tx_data_9_tc[1];
			n0l0O <= tx_ctl_tc[0];
			n0l1i <= wire_n0iOO_dataout;
			n0lii <= tx_ctl_tc[1];
			n0lil <= tx_data_tc[0];
			n0liO <= tx_data_tc[1];
			n0lli <= tx_data_tc[2];
			n0lll <= tx_data_tc[3];
			n0llO <= tx_data_tc[4];
			n0lOi <= tx_data_tc[5];
			n0lOl <= tx_data_tc[6];
			n0lOO <= tx_data_tc[7];
			n0O0i <= tx_data_tc[11];
			n0O0l <= tx_data_tc[12];
			n0O0O <= tx_data_tc[13];
			n0O1i <= tx_data_tc[8];
			n0O1l <= tx_data_tc[9];
			n0O1O <= tx_data_tc[10];
			n0Oii <= tx_data_tc[14];
			n0Oil <= tx_data_tc[15];
			n0OiO <= nii0O;
			n0Oli <= niiii;
			n0Oll <= niiil;
			n0OlO <= niiiO;
			n0OOi <= niili;
			n0OOl <= niill;
			n0OOO <= niilO;
			ni10i <= ni10l;
			ni10l <= rensymswap_tx;
			ni10O <= ni1ii;
			ni11i <= niiOi;
			ni11l <= niiOl;
			ni11O <= nil1i;
			ni1ii <= renbitrev_tx;
			ni1il <= nii0l;
			nii0l <= (renpolinv_tx & enpolinv_tx);
			nii0O <= wire_nil1l_o;
			niiii <= wire_nil1O_o;
			niiil <= wire_niliO_o;
			niiiO <= wire_nilll_o;
			niili <= wire_nilOl_o;
			niill <= wire_nilOO_o;
			niilO <= wire_niO1i_o;
			niiOi <= wire_niO1l_o;
			niiOl <= wire_niO1O_o;
			nil1i <= wire_niO0l_o;
		end
	end
	assign		wire_n00i_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[11] : wire_ni0l_dataout;
	assign		wire_n00l_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[12] : wire_ni0O_dataout;
	assign		wire_n00O_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[13] : wire_niii_dataout;
	assign		wire_n01i_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[8] : wire_ni1l_dataout;
	assign		wire_n01l_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[9] : wire_ni1O_dataout;
	assign		wire_n01O_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[10] : wire_ni0i_dataout;
	assign		wire_n0ii_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[14] : wire_niil_dataout;
	assign		wire_n0il_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[15] : wire_niiO_dataout;
	and(wire_n0iO_dataout, wire_nili_dataout, ~{niO10i});
	assign		wire_n0iOO_dataout = (cascaded_8b10b_en === 1'b1) ? wire_nlll1l_dataout : wire_nl00ii_dataout;
	and(wire_n0li_dataout, wire_nill_dataout, ~{niO10i});
	and(wire_n0ll_dataout, wire_nilO_dataout, ~{niO10i});
	and(wire_n0lO_dataout, wire_niOi_dataout, ~{niO10i});
	assign		wire_n0O_dataout = (rendec_data_sel_tx === 1'b1) ? tx_ctl_tc[0] : tx_ctl_ts;
	or(wire_n0Oi_dataout, wire_niOl_dataout, niO10i);
	and(wire_n0Ol_dataout, wire_niOO_dataout, ~{niO10i});
	or(wire_n0OO_dataout, wire_nl1i_dataout, niO10i);
	and(wire_n10i_dataout, tx_data_tc[12], rendec_data_sel_tx);
	and(wire_n10l_dataout, tx_data_tc[13], rendec_data_sel_tx);
	and(wire_n10O_dataout, tx_data_tc[14], rendec_data_sel_tx);
	and(wire_n11i_dataout, tx_data_tc[9], rendec_data_sel_tx);
	and(wire_n11l_dataout, tx_data_tc[10], rendec_data_sel_tx);
	and(wire_n11O_dataout, tx_data_tc[11], rendec_data_sel_tx);
	and(wire_n1ii_dataout, tx_data_tc[15], rendec_data_sel_tx);
	assign		wire_n1il_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[0] : wire_n0iO_dataout;
	assign		wire_n1iO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[1] : wire_n0li_dataout;
	assign		wire_n1li_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[2] : wire_n0ll_dataout;
	assign		wire_n1ll_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[3] : wire_n0lO_dataout;
	assign		wire_n1lO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[4] : wire_n0Oi_dataout;
	assign		wire_n1Oi_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[5] : wire_n0Ol_dataout;
	assign		wire_n1Ol_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[6] : wire_n0OO_dataout;
	assign		wire_n1OO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[7] : wire_ni1i_dataout;
	and(wire_ni01i_dataout, n0l1i, ~{(tx_data_9_tc[0] & (rforce_disp & txd_extend_tc[0]))});
	and(wire_ni0i_dataout, wire_nl0l_dataout, ~{niO10i});
	or(wire_ni0il_dataout, wire_ni0iO_dataout, (tx_data_9_tc[1] & (rforce_disp & (~ txd_extend_tc[1]))));
	and(wire_ni0iO_dataout, wire_nl00ii_dataout, ~{(tx_data_9_tc[1] & (rforce_disp & txd_extend_tc[1]))});
	and(wire_ni0l_dataout, wire_nl0O_dataout, ~{niO10i});
	and(wire_ni0O_dataout, wire_nlii_dataout, ~{niO10i});
	or(wire_ni0Ol_dataout, wire_ni0OO_dataout, (tx_data_9_tc[0] & (rforce_disp & (~ txd_extend_tc[0]))));
	and(wire_ni0OO_dataout, n0l1i, ~{(tx_data_9_tc[0] & (rforce_disp & txd_extend_tc[0]))});
	and(wire_ni1i_dataout, wire_nl1l_dataout, ~{niO10i});
	and(wire_ni1l_dataout, wire_nl1O_dataout, ~{niO10i});
	assign		wire_ni1lO_dataout = (cascaded_8b10b_en === 1'b1) ? wire_ni0Ol_dataout : wire_ni1Ol_dataout;
	and(wire_ni1O_dataout, wire_nl0i_dataout, ~{niO10i});
	assign		wire_ni1Oi_dataout = (cascaded_8b10b_en === 1'b1) ? wire_ni0il_dataout : wire_nl00ii_dataout;
	assign		wire_ni1Ol_dataout = (ib_force_disparity === 1'b1) ? (n0l1i | (tx_data_9_tc[0] & (~ n0l1O))) : wire_ni1OO_dataout;
	or(wire_ni1OO_dataout, wire_ni01i_dataout, (tx_data_9_tc[0] & (rforce_disp & (~ txd_extend_tc[0]))));
	and(wire_nii_dataout, tx_ctl_tc[1], rendec_data_sel_tx);
	and(wire_niii_dataout, wire_nlil_dataout, ~{niO10i});
	and(wire_niil_dataout, wire_nliO_dataout, ~{niO10i});
	and(wire_niiO_dataout, wire_nlli_dataout, ~{niO10i});
	assign		wire_nil_dataout = (cascaded_8b10b_en === 1'b1) ? tx_ctl_tc[0] : wire_nli_dataout;
	or(wire_nili_dataout, wire_nlOii_dataout, nilOOl);
	and(wire_nill_dataout, wire_nlOil_dataout, ~{nilOOl});
	or(wire_nilO_dataout, wire_nlOiO_dataout, nilOOl);
	assign		wire_niO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_ctl_tc[1] : wire_nll_dataout;
	and(wire_niOi_dataout, wire_nlOli_dataout, ~{nilOOl});
	and(wire_niOl_dataout, wire_nlOll_dataout, ~{nilOOl});
	and(wire_niOO_dataout, wire_nlOlO_dataout, ~{nilOOl});
	assign		wire_niOOOl_dataout = ((nil10l | (nil1lO | (nil1Ol | (nil1OO | wire_nl1lil_dataout)))) === 1'b1) ? (~ wire_ni1lO_dataout) : wire_ni1lO_dataout;
	assign		wire_nl00ii_dataout = ((nil00l | (wire_n1OO_dataout & nil0li)) === 1'b1) ? (~ wire_niOOOl_dataout) : wire_niOOOl_dataout;
	or(wire_nl00li_dataout, wire_nl00ll_dataout, nil0ii);
	and(wire_nl00ll_dataout, (~ nil0li), ~{wire_n1OO_dataout});
	assign		wire_nl00OO_dataout = (nil00l === 1'b1) ? (~ wire_n1Ol_dataout) : wire_n1Ol_dataout;
	and(wire_nl0i_dataout, wire_n11i_dataout, ~{nilOOl});
	assign		wire_nl0i0i_dataout = (nil0il === 1'b1) ? (~ wire_nl00OO_dataout) : wire_nl00OO_dataout;
	assign		wire_nl0i0l_dataout = (nil0il === 1'b1) ? (~ wire_n1OO_dataout) : wire_n1OO_dataout;
	assign		wire_nl0i0O_dataout = (nil0il === 1'b1) ? (~ wire_nl00li_dataout) : wire_nl00li_dataout;
	and(wire_nl0i1l_dataout, wire_n1Oi_dataout, ~{nil0ii});
	assign		wire_nl0i1O_dataout = (nil0il === 1'b1) ? (~ wire_nl0i1l_dataout) : wire_nl0i1l_dataout;
	assign		wire_nl0ilO_dataout = (r8b10b_enc_ibm_en === 1'b1) ? nil0ll : wire_nil_dataout;
	and(wire_nl0l_dataout, wire_n11l_dataout, ~{nilOOl});
	and(wire_nl0O_dataout, wire_n11O_dataout, ~{nilOOl});
	assign		wire_nl100i_dataout = (nil10i === 1'b1) ? (~ nil1ii) : nil1ii;
	assign		wire_nl101i_dataout = (nil10i === 1'b1) ? (~ wire_nl1l1i_dataout) : wire_nl1l1i_dataout;
	assign		wire_nl101l_dataout = (nil10i === 1'b1) ? (~ wire_nl1iOO_dataout) : wire_nl1iOO_dataout;
	assign		wire_nl101O_dataout = (nil10i === 1'b1) ? (~ nil1li) : nil1li;
	assign		wire_nl11Ol_dataout = (nil10i === 1'b1) ? (~ wire_n1il_dataout) : wire_n1il_dataout;
	assign		wire_nl11OO_dataout = (nil10i === 1'b1) ? (~ wire_nl1lii_dataout) : wire_nl1lii_dataout;
	or(wire_nl1i_dataout, wire_nlOOi_dataout, nilOOl);
	assign		wire_nl1iOO_dataout = (nil1Ol === 1'b1) ? (~ wire_n1ll_dataout) : wire_n1ll_dataout;
	or(wire_nl1l_dataout, wire_nlOOl_dataout, nilOOl);
	assign		wire_nl1l1i_dataout = ((nil1OO | (wire_n1lO_dataout & (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ((~ wire_n1il_dataout) & (~ wire_n1iO_dataout)))))) === 1'b1) ? (~ wire_n1li_dataout) : wire_n1li_dataout;
	assign		wire_nl1lii_dataout = (nil01i === 1'b1) ? (~ wire_n1iO_dataout) : wire_n1iO_dataout;
	assign		wire_nl1lil_dataout = (r8b10b_enc_ibm_en === 1'b1) ? nil0ll : wire_nil_dataout;
	and(wire_nl1O_dataout, wire_nlOOO_dataout, ~{nilOOl});
	and(wire_nli_dataout, wire_n0O_dataout, ~{niO1ll});
	assign		wire_nli0iO_dataout = ((nili1l | (niliiO | (nilill | (nililO | wire_nll11O_dataout)))) === 1'b1) ? (~ wire_ni1Oi_dataout) : wire_ni1Oi_dataout;
	and(wire_nlii_dataout, wire_n10i_dataout, ~{nilOOl});
	assign		wire_nliiiO_dataout = (nili1i === 1'b1) ? (~ wire_n01i_dataout) : wire_n01i_dataout;
	assign		wire_nliili_dataout = (nili1i === 1'b1) ? (~ wire_nll11l_dataout) : wire_nll11l_dataout;
	assign		wire_nliill_dataout = (nili1i === 1'b1) ? (~ wire_nliOll_dataout) : wire_nliOll_dataout;
	assign		wire_nliilO_dataout = (nili1i === 1'b1) ? (~ wire_nliOli_dataout) : wire_nliOli_dataout;
	assign		wire_nliiOi_dataout = (nili1i === 1'b1) ? (~ niliii) : niliii;
	assign		wire_nliiOl_dataout = (nili1i === 1'b1) ? (~ nili0i) : nili0i;
	and(wire_nlil_dataout, wire_n10l_dataout, ~{nilOOl});
	and(wire_nliO_dataout, wire_n10O_dataout, ~{nilOOl});
	assign		wire_nliOli_dataout = (nilill === 1'b1) ? (~ wire_n00i_dataout) : wire_n00i_dataout;
	assign		wire_nliOll_dataout = ((nililO | (wire_n00l_dataout & (wire_n00i_dataout & ((~ wire_n01O_dataout) & ((~ wire_n01i_dataout) & (~ wire_n01l_dataout)))))) === 1'b1) ? (~ wire_n01O_dataout) : wire_n01O_dataout;
	and(wire_nll_dataout, wire_nii_dataout, ~{niO1ll});
	assign		wire_nll11l_dataout = (niliOi === 1'b1) ? (~ wire_n01l_dataout) : wire_n01l_dataout;
	assign		wire_nll11O_dataout = (r8b10b_enc_ibm_en === 1'b1) ? nillil : wire_niO_dataout;
	and(wire_nlli_dataout, wire_n1ii_dataout, ~{nilOOl});
	or(wire_nlll0l_dataout, wire_nlll0O_dataout, nill0i);
	and(wire_nlll0O_dataout, (~ nillii), ~{wire_n0il_dataout});
	assign		wire_nlll1l_dataout = ((nill1l | (wire_n0il_dataout & nillii)) === 1'b1) ? (~ wire_nli0iO_dataout) : wire_nli0iO_dataout;
	assign		wire_nlllli_dataout = (nill1l === 1'b1) ? (~ wire_n0ii_dataout) : wire_n0ii_dataout;
	and(wire_nllllO_dataout, wire_n00O_dataout, ~{nill0i});
	assign		wire_nlllOi_dataout = (nill0l === 1'b1) ? (~ wire_nllllO_dataout) : wire_nllllO_dataout;
	assign		wire_nlllOl_dataout = (nill0l === 1'b1) ? (~ wire_nlllli_dataout) : wire_nlllli_dataout;
	assign		wire_nlllOO_dataout = (nill0l === 1'b1) ? (~ wire_n0il_dataout) : wire_n0il_dataout;
	assign		wire_nllO1i_dataout = (nill0l === 1'b1) ? (~ wire_nlll0l_dataout) : wire_nlll0l_dataout;
	assign		wire_nllOii_dataout = (r8b10b_enc_ibm_en === 1'b1) ? nillil : wire_niO_dataout;
	assign		wire_nlOii_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[0] : tx_data_ts[0];
	assign		wire_nlOil_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[1] : tx_data_ts[1];
	assign		wire_nlOiO_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[2] : tx_data_ts[2];
	assign		wire_nlOli_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[3] : tx_data_ts[3];
	assign		wire_nlOll_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[4] : tx_data_ts[4];
	assign		wire_nlOlO_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[5] : tx_data_ts[5];
	assign		wire_nlOOi_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[6] : tx_data_ts[6];
	assign		wire_nlOOl_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[7] : tx_data_ts[7];
	and(wire_nlOOO_dataout, tx_data_tc[8], rendec_data_sel_tx);
	oper_decoder   n0ilO
	( 
	.i({endec, prbs_en, rrev_loopbk, n0iOi}),
	.o(wire_n0ilO_o));
	defparam
		n0ilO.width_i = 4,
		n0ilO.width_o = 16;
	oper_decoder   niOii
	( 
	.i({doublewidth, dwidth}),
	.o(wire_niOii_o));
	defparam
		niOii.width_i = 2,
		niOii.width_o = 4;
	oper_decoder   nl1Oi
	( 
	.i({ni1il, ni10O, ni10i}),
	.o(wire_nl1Oi_o));
	defparam
		nl1Oi.width_i = 3,
		nl1Oi.width_o = 8;
	oper_decoder   nllll
	( 
	.i({ni1il, ni10O}),
	.o(wire_nllll_o));
	defparam
		nllll.width_i = 2,
		nllll.width_o = 4;
	oper_selector   n000i
	( 
	.data({tx_data_pg[1], rev_loop_data[1], wire_nl11OO_dataout, tx_data_tc[1]}),
	.o(wire_n000i_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n000i.width_data = 4,
		n000i.width_sel = 4;
	oper_selector   n000l
	( 
	.data({tx_data_pg[2], rev_loop_data[2], wire_nl101i_dataout, tx_data_tc[2]}),
	.o(wire_n000l_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n000l.width_data = 4,
		n000l.width_sel = 4;
	oper_selector   n000O
	( 
	.data({tx_data_pg[3], rev_loop_data[3], wire_nl101l_dataout, tx_data_tc[3]}),
	.o(wire_n000O_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n000O.width_data = 4,
		n000O.width_sel = 4;
	oper_selector   n001O
	( 
	.data({tx_data_pg[0], rev_loop_data[0], wire_nl11Ol_dataout, tx_data_tc[0]}),
	.o(wire_n001O_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n001O.width_data = 4,
		n001O.width_sel = 4;
	oper_selector   n00ii
	( 
	.data({tx_data_pg[4], rev_loop_data[4], wire_nl101O_dataout, tx_data_tc[4]}),
	.o(wire_n00ii_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n00ii.width_data = 4,
		n00ii.width_sel = 4;
	oper_selector   n00il
	( 
	.data({tx_data_pg[5], rev_loop_data[5], wire_nl100i_dataout, tx_data_tc[5]}),
	.o(wire_n00il_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n00il.width_data = 4,
		n00il.width_sel = 4;
	oper_selector   n00iO
	( 
	.data({tx_data_pg[6], rev_loop_data[6], wire_nl0i1O_dataout, tx_data_tc[6]}),
	.o(wire_n00iO_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n00iO.width_data = 4,
		n00iO.width_sel = 4;
	oper_selector   n00li
	( 
	.data({tx_data_pg[7], rev_loop_data[7], wire_nl0i0i_dataout, tx_data_tc[7]}),
	.o(wire_n00li_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n00li.width_data = 4,
		n00li.width_sel = 4;
	oper_selector   n00ll
	( 
	.data({tx_data_pg[8], rev_loop_data[8], wire_nl0i0l_dataout, tx_ctl_tc[1:0]}),
	.o(wire_n00ll_o),
	.sel({nilliO, nillli, nillll, wire_n0ilO_o[2], wire_n0ilO_o[0]}));
	defparam
		n00ll.width_data = 5,
		n00ll.width_sel = 5;
	oper_selector   n00lO
	( 
	.data({tx_data_pg[9], rev_loop_data[9], wire_nl0i0O_dataout, tx_data_9_tc[0]}),
	.o(wire_n00lO_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n00lO.width_data = 4,
		n00lO.width_sel = 4;
	oper_selector   n00Oi
	( 
	.data({tx_data_pg[10], rev_loop_data[10], wire_nliiiO_dataout, tx_data_tc[8]}),
	.o(wire_n00Oi_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n00Oi.width_data = 4,
		n00Oi.width_sel = 4;
	oper_selector   n0i0i
	( 
	.data({tx_data_pg[12], rev_loop_data[12], wire_nliill_dataout, tx_data_tc[10]}),
	.o(wire_n0i0i_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n0i0i.width_data = 4,
		n0i0i.width_sel = 4;
	oper_selector   n0i0l
	( 
	.data({tx_data_pg[13], rev_loop_data[13], wire_nliilO_dataout, tx_data_tc[11]}),
	.o(wire_n0i0l_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n0i0l.width_data = 4,
		n0i0l.width_sel = 4;
	oper_selector   n0i0O
	( 
	.data({tx_data_pg[14], rev_loop_data[14], wire_nliiOi_dataout, tx_data_tc[12]}),
	.o(wire_n0i0O_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n0i0O.width_data = 4,
		n0i0O.width_sel = 4;
	oper_selector   n0i1O
	( 
	.data({tx_data_pg[11], rev_loop_data[11], wire_nliili_dataout, tx_data_tc[9]}),
	.o(wire_n0i1O_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n0i1O.width_data = 4,
		n0i1O.width_sel = 4;
	oper_selector   n0iii
	( 
	.data({tx_data_pg[15], rev_loop_data[15], wire_nliiOl_dataout, tx_data_tc[13]}),
	.o(wire_n0iii_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n0iii.width_data = 4,
		n0iii.width_sel = 4;
	oper_selector   n0iil
	( 
	.data({tx_data_pg[16], rev_loop_data[16], wire_nlllOi_dataout, tx_data_tc[14]}),
	.o(wire_n0iil_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n0iil.width_data = 4,
		n0iil.width_sel = 4;
	oper_selector   n0iiO
	( 
	.data({tx_data_pg[17], rev_loop_data[17], wire_nlllOl_dataout, tx_data_tc[15]}),
	.o(wire_n0iiO_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n0iiO.width_data = 4,
		n0iiO.width_sel = 4;
	oper_selector   n0ili
	( 
	.data({tx_data_pg[18], rev_loop_data[18], wire_nlllOO_dataout, tx_ctl_tc[1]}),
	.o(wire_n0ili_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n0ili.width_data = 4,
		n0ili.width_sel = 4;
	oper_selector   n0ill
	( 
	.data({tx_data_pg[19], rev_loop_data[19], wire_nllO1i_dataout, tx_data_9_tc[1]}),
	.o(wire_n0ill_o),
	.sel({nilliO, nillli, nillll, nilllO}));
	defparam
		n0ill.width_data = 4,
		n0ill.width_sel = 4;
	oper_selector   nil0i
	( 
	.data({wire_niOli_o, wire_nl01i_o, wire_nliii_o, wire_nllOl_o}),
	.o(wire_nil0i_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		nil0i.width_data = 4,
		nil0i.width_sel = 4;
	oper_selector   nil0l
	( 
	.data({wire_niOll_o, wire_nl01l_o, wire_nliil_o, wire_nllOO_o}),
	.o(wire_nil0l_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		nil0l.width_data = 4,
		nil0l.width_sel = 4;
	oper_selector   nil0O
	( 
	.data({wire_niOlO_o, wire_nl01O_o, wire_nliiO_o, wire_nlO1i_o}),
	.o(wire_nil0O_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		nil0O.width_data = 4,
		nil0O.width_sel = 4;
	oper_selector   nil1l
	( 
	.data({wire_niOil_o, wire_nl1Ol_o, wire_nli0l_o, wire_nlllO_o}),
	.o(wire_nil1l_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		nil1l.width_data = 4,
		nil1l.width_sel = 4;
	oper_selector   nil1O
	( 
	.data({wire_niOiO_o, wire_nl1OO_o, wire_nli0O_o, wire_nllOi_o}),
	.o(wire_nil1O_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		nil1O.width_data = 4,
		nil1O.width_sel = 4;
	oper_selector   nilii
	( 
	.data({wire_niOOi_o, wire_nl00i_o, wire_nlili_o, wire_nlO1l_o}),
	.o(wire_nilii_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		nilii.width_data = 4,
		nilii.width_sel = 4;
	oper_selector   nilil
	( 
	.data({wire_niOOl_o, wire_nl00l_o, wire_nlill_o, wire_nlO1O_o}),
	.o(wire_nilil_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		nilil.width_data = 4,
		nilil.width_sel = 4;
	oper_selector   niliO
	( 
	.data({wire_niOOO_o, wire_nl00O_o, wire_nlilO_o, wire_nlO0i_o}),
	.o(wire_niliO_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		niliO.width_data = 4,
		niliO.width_sel = 4;
	oper_selector   nilli
	( 
	.data({wire_nl11i_o, wire_nl0ii_o, wire_nliOi_o, wire_nlO0l_o}),
	.o(wire_nilli_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		nilli.width_data = 4,
		nilli.width_sel = 4;
	oper_selector   nilll
	( 
	.data({wire_nl11l_o, wire_nl0il_o, wire_nliOl_o, wire_nlO0O_o}),
	.o(wire_nilll_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		nilll.width_data = 4,
		nilll.width_sel = 4;
	oper_selector   nillO
	( 
	.data({wire_nl11O_o, wire_nl0iO_o, {2{wire_nliOO_o}}}),
	.o(wire_nillO_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		nillO.width_data = 4,
		nillO.width_sel = 4;
	oper_selector   nilOi
	( 
	.data({wire_nl10i_o, wire_nl0li_o, {2{wire_nll1i_o}}}),
	.o(wire_nilOi_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		nilOi.width_data = 4,
		nilOi.width_sel = 4;
	oper_selector   nilOl
	( 
	.data({wire_nl10l_o, wire_nl0ll_o, {2{wire_nll1l_o}}}),
	.o(wire_nilOl_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		nilOl.width_data = 4,
		nilOl.width_sel = 4;
	oper_selector   nilOO
	( 
	.data({wire_nl10O_o, wire_nl0lO_o, {2{wire_nll1O_o}}}),
	.o(wire_nilOO_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		nilOO.width_data = 4,
		nilOO.width_sel = 4;
	oper_selector   niO0i
	( 
	.data({wire_nl1li_o, wire_nli1i_o, {2{wire_nllii_o}}}),
	.o(wire_niO0i_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		niO0i.width_data = 4,
		niO0i.width_sel = 4;
	oper_selector   niO0l
	( 
	.data({wire_nl1ll_o, wire_nli1l_o, {2{wire_nllil_o}}}),
	.o(wire_niO0l_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		niO0l.width_data = 4,
		niO0l.width_sel = 4;
	oper_selector   niO0O
	( 
	.data({wire_nl1lO_o, wire_nli1O_o, {2{wire_nlliO_o}}}),
	.o(wire_niO0O_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		niO0O.width_data = 4,
		niO0O.width_sel = 4;
	oper_selector   niO1i
	( 
	.data({wire_nl1ii_o, wire_nl0Oi_o, {2{wire_nll0i_o}}}),
	.o(wire_niO1i_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		niO1i.width_data = 4,
		niO1i.width_sel = 4;
	oper_selector   niO1l
	( 
	.data({wire_nl1il_o, wire_nl0Ol_o, {2{wire_nll0l_o}}}),
	.o(wire_niO1l_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		niO1l.width_data = 4,
		niO1l.width_sel = 4;
	oper_selector   niO1O
	( 
	.data({wire_nl1iO_o, wire_nl0OO_o, {2{wire_nll0O_o}}}),
	.o(wire_niO1O_o),
	.sel({wire_niOii_o[3:0]}));
	defparam
		niO1O.width_data = 4,
		niO1O.width_sel = 4;
	oper_selector   niOil
	( 
	.data({(~ wire_n00lO_o), (~ wire_n0ill_o), (~ wire_n00Oi_o), (~ wire_n001O_o), wire_n00lO_o, wire_n0ill_o, wire_n00Oi_o, wire_n001O_o}),
	.o(wire_niOil_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		niOil.width_data = 8,
		niOil.width_sel = 8;
	oper_selector   niOiO
	( 
	.data({(~ wire_n00ll_o), (~ wire_n0ili_o), (~ wire_n0i1O_o), (~ wire_n000i_o), wire_n00ll_o, wire_n0ili_o, wire_n0i1O_o, wire_n000i_o}),
	.o(wire_niOiO_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		niOiO.width_data = 8,
		niOiO.width_sel = 8;
	oper_selector   niOli
	( 
	.data({(~ wire_n00li_o), (~ wire_n0iiO_o), (~ wire_n0i0i_o), (~ wire_n000l_o), wire_n00li_o, wire_n0iiO_o, wire_n0i0i_o, wire_n000l_o}),
	.o(wire_niOli_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		niOli.width_data = 8,
		niOli.width_sel = 8;
	oper_selector   niOll
	( 
	.data({(~ wire_n00iO_o), (~ wire_n0iil_o), (~ wire_n0i0l_o), (~ wire_n000O_o), wire_n00iO_o, wire_n0iil_o, wire_n0i0l_o, wire_n000O_o}),
	.o(wire_niOll_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		niOll.width_data = 8,
		niOll.width_sel = 8;
	oper_selector   niOlO
	( 
	.data({(~ wire_n00il_o), (~ wire_n0iii_o), (~ wire_n0i0O_o), (~ wire_n00ii_o), wire_n00il_o, wire_n0iii_o, wire_n0i0O_o, wire_n00ii_o}),
	.o(wire_niOlO_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		niOlO.width_data = 8,
		niOlO.width_sel = 8;
	oper_selector   niOOi
	( 
	.data({(~ wire_n00ii_o), (~ wire_n0i0O_o), (~ wire_n0iii_o), (~ wire_n00il_o), wire_n00ii_o, wire_n0i0O_o, wire_n0iii_o, wire_n00il_o}),
	.o(wire_niOOi_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		niOOi.width_data = 8,
		niOOi.width_sel = 8;
	oper_selector   niOOl
	( 
	.data({(~ wire_n000O_o), (~ wire_n0i0l_o), (~ wire_n0iil_o), (~ wire_n00iO_o), wire_n000O_o, wire_n0i0l_o, wire_n0iil_o, wire_n00iO_o}),
	.o(wire_niOOl_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		niOOl.width_data = 8,
		niOOl.width_sel = 8;
	oper_selector   niOOO
	( 
	.data({(~ wire_n000l_o), (~ wire_n0i0i_o), (~ wire_n0iiO_o), (~ wire_n00li_o), wire_n000l_o, wire_n0i0i_o, wire_n0iiO_o, wire_n00li_o}),
	.o(wire_niOOO_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		niOOO.width_data = 8,
		niOOO.width_sel = 8;
	oper_selector   nl00i
	( 
	.data({(~ wire_n000l_o), (~ wire_n0i0i_o), (~ wire_n0iii_o), (~ wire_n00il_o), wire_n000l_o, wire_n0i0i_o, wire_n0iii_o, wire_n00il_o}),
	.o(wire_nl00i_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl00i.width_data = 8,
		nl00i.width_sel = 8;
	oper_selector   nl00l
	( 
	.data({(~ wire_n000i_o), (~ wire_n0i1O_o), (~ wire_n0iil_o), (~ wire_n00iO_o), wire_n000i_o, wire_n0i1O_o, wire_n0iil_o, wire_n00iO_o}),
	.o(wire_nl00l_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl00l.width_data = 8,
		nl00l.width_sel = 8;
	oper_selector   nl00O
	( 
	.data({(~ wire_n001O_o), (~ wire_n00Oi_o), (~ wire_n0iiO_o), (~ wire_n00li_o), wire_n001O_o, wire_n00Oi_o, wire_n0iiO_o, wire_n00li_o}),
	.o(wire_nl00O_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl00O.width_data = 8,
		nl00O.width_sel = 8;
	oper_selector   nl01i
	( 
	.data({(~ wire_n00il_o), (~ wire_n0iii_o), (~ wire_n0i0i_o), (~ wire_n000l_o), wire_n00il_o, wire_n0iii_o, wire_n0i0i_o, wire_n000l_o}),
	.o(wire_nl01i_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl01i.width_data = 8,
		nl01i.width_sel = 8;
	oper_selector   nl01l
	( 
	.data({(~ wire_n00ii_o), (~ wire_n0i0O_o), (~ wire_n0i0l_o), (~ wire_n000O_o), wire_n00ii_o, wire_n0i0O_o, wire_n0i0l_o, wire_n000O_o}),
	.o(wire_nl01l_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl01l.width_data = 8,
		nl01l.width_sel = 8;
	oper_selector   nl01O
	( 
	.data({(~ wire_n000O_o), (~ wire_n0i0l_o), (~ wire_n0i0O_o), (~ wire_n00ii_o), wire_n000O_o, wire_n0i0l_o, wire_n0i0O_o, wire_n00ii_o}),
	.o(wire_nl01O_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl01O.width_data = 8,
		nl01O.width_sel = 8;
	oper_selector   nl0ii
	( 
	.data({(~ wire_n00ll_o), wire_n00ll_o}),
	.o(wire_nl0ii_o),
	.sel({(~ nillOl), nillOl}));
	defparam
		nl0ii.width_data = 2,
		nl0ii.width_sel = 2;
	oper_selector   nl0il
	( 
	.data({(~ wire_n00lO_o), wire_n00lO_o}),
	.o(wire_nl0il_o),
	.sel({(~ nillOl), nillOl}));
	defparam
		nl0il.width_data = 2,
		nl0il.width_sel = 2;
	oper_selector   nl0iO
	( 
	.data({(~ wire_n0iiO_o), (~ wire_n00li_o), (~ wire_n001O_o), (~ wire_n00Oi_o), wire_n0iiO_o, wire_n00li_o, wire_n001O_o, wire_n00Oi_o}),
	.o(wire_nl0iO_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl0iO.width_data = 8,
		nl0iO.width_sel = 8;
	oper_selector   nl0li
	( 
	.data({(~ wire_n0iil_o), (~ wire_n00iO_o), (~ wire_n000i_o), (~ wire_n0i1O_o), wire_n0iil_o, wire_n00iO_o, wire_n000i_o, wire_n0i1O_o}),
	.o(wire_nl0li_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl0li.width_data = 8,
		nl0li.width_sel = 8;
	oper_selector   nl0ll
	( 
	.data({(~ wire_n0iii_o), (~ wire_n00il_o), (~ wire_n000l_o), (~ wire_n0i0i_o), wire_n0iii_o, wire_n00il_o, wire_n000l_o, wire_n0i0i_o}),
	.o(wire_nl0ll_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl0ll.width_data = 8,
		nl0ll.width_sel = 8;
	oper_selector   nl0lO
	( 
	.data({(~ wire_n0i0O_o), (~ wire_n00ii_o), (~ wire_n000O_o), (~ wire_n0i0l_o), wire_n0i0O_o, wire_n00ii_o, wire_n000O_o, wire_n0i0l_o}),
	.o(wire_nl0lO_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl0lO.width_data = 8,
		nl0lO.width_sel = 8;
	oper_selector   nl0Oi
	( 
	.data({(~ wire_n0i0l_o), (~ wire_n000O_o), (~ wire_n00ii_o), (~ wire_n0i0O_o), wire_n0i0l_o, wire_n000O_o, wire_n00ii_o, wire_n0i0O_o}),
	.o(wire_nl0Oi_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl0Oi.width_data = 8,
		nl0Oi.width_sel = 8;
	oper_selector   nl0Ol
	( 
	.data({(~ wire_n0i0i_o), (~ wire_n000l_o), (~ wire_n00il_o), (~ wire_n0iii_o), wire_n0i0i_o, wire_n000l_o, wire_n00il_o, wire_n0iii_o}),
	.o(wire_nl0Ol_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl0Ol.width_data = 8,
		nl0Ol.width_sel = 8;
	oper_selector   nl0OO
	( 
	.data({(~ wire_n0i1O_o), (~ wire_n000i_o), (~ wire_n00iO_o), (~ wire_n0iil_o), wire_n0i1O_o, wire_n000i_o, wire_n00iO_o, wire_n0iil_o}),
	.o(wire_nl0OO_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl0OO.width_data = 8,
		nl0OO.width_sel = 8;
	oper_selector   nl10i
	( 
	.data({(~ wire_n0ili_o), (~ wire_n00ll_o), (~ wire_n000i_o), (~ wire_n0i1O_o), wire_n0ili_o, wire_n00ll_o, wire_n000i_o, wire_n0i1O_o}),
	.o(wire_nl10i_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl10i.width_data = 8,
		nl10i.width_sel = 8;
	oper_selector   nl10l
	( 
	.data({(~ wire_n0iiO_o), (~ wire_n00li_o), (~ wire_n000l_o), (~ wire_n0i0i_o), wire_n0iiO_o, wire_n00li_o, wire_n000l_o, wire_n0i0i_o}),
	.o(wire_nl10l_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl10l.width_data = 8,
		nl10l.width_sel = 8;
	oper_selector   nl10O
	( 
	.data({(~ wire_n0iil_o), (~ wire_n00iO_o), (~ wire_n000O_o), (~ wire_n0i0l_o), wire_n0iil_o, wire_n00iO_o, wire_n000O_o, wire_n0i0l_o}),
	.o(wire_nl10O_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl10O.width_data = 8,
		nl10O.width_sel = 8;
	oper_selector   nl11i
	( 
	.data({(~ wire_n000i_o), (~ wire_n0i1O_o), (~ wire_n0ili_o), (~ wire_n00ll_o), wire_n000i_o, wire_n0i1O_o, wire_n0ili_o, wire_n00ll_o}),
	.o(wire_nl11i_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl11i.width_data = 8,
		nl11i.width_sel = 8;
	oper_selector   nl11l
	( 
	.data({(~ wire_n001O_o), (~ wire_n00Oi_o), (~ wire_n0ill_o), (~ wire_n00lO_o), wire_n001O_o, wire_n00Oi_o, wire_n0ill_o, wire_n00lO_o}),
	.o(wire_nl11l_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl11l.width_data = 8,
		nl11l.width_sel = 8;
	oper_selector   nl11O
	( 
	.data({(~ wire_n0ill_o), (~ wire_n00lO_o), (~ wire_n001O_o), (~ wire_n00Oi_o), wire_n0ill_o, wire_n00lO_o, wire_n001O_o, wire_n00Oi_o}),
	.o(wire_nl11O_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl11O.width_data = 8,
		nl11O.width_sel = 8;
	oper_selector   nl1ii
	( 
	.data({(~ wire_n0iii_o), (~ wire_n00il_o), (~ wire_n00ii_o), (~ wire_n0i0O_o), wire_n0iii_o, wire_n00il_o, wire_n00ii_o, wire_n0i0O_o}),
	.o(wire_nl1ii_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl1ii.width_data = 8,
		nl1ii.width_sel = 8;
	oper_selector   nl1il
	( 
	.data({(~ wire_n0i0O_o), (~ wire_n00ii_o), (~ wire_n00il_o), (~ wire_n0iii_o), wire_n0i0O_o, wire_n00ii_o, wire_n00il_o, wire_n0iii_o}),
	.o(wire_nl1il_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl1il.width_data = 8,
		nl1il.width_sel = 8;
	oper_selector   nl1iO
	( 
	.data({(~ wire_n0i0l_o), (~ wire_n000O_o), (~ wire_n00iO_o), (~ wire_n0iil_o), wire_n0i0l_o, wire_n000O_o, wire_n00iO_o, wire_n0iil_o}),
	.o(wire_nl1iO_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl1iO.width_data = 8,
		nl1iO.width_sel = 8;
	oper_selector   nl1li
	( 
	.data({(~ wire_n0i0i_o), (~ wire_n000l_o), (~ wire_n00li_o), (~ wire_n0iiO_o), wire_n0i0i_o, wire_n000l_o, wire_n00li_o, wire_n0iiO_o}),
	.o(wire_nl1li_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl1li.width_data = 8,
		nl1li.width_sel = 8;
	oper_selector   nl1ll
	( 
	.data({(~ wire_n0i1O_o), (~ wire_n000i_o), (~ wire_n00ll_o), (~ wire_n0ili_o), wire_n0i1O_o, wire_n000i_o, wire_n00ll_o, wire_n0ili_o}),
	.o(wire_nl1ll_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl1ll.width_data = 8,
		nl1ll.width_sel = 8;
	oper_selector   nl1lO
	( 
	.data({(~ wire_n00Oi_o), (~ wire_n001O_o), (~ wire_n00lO_o), (~ wire_n0ill_o), wire_n00Oi_o, wire_n001O_o, wire_n00lO_o, wire_n0ill_o}),
	.o(wire_nl1lO_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl1lO.width_data = 8,
		nl1lO.width_sel = 8;
	oper_selector   nl1Ol
	( 
	.data({(~ wire_n00li_o), (~ wire_n0iiO_o), (~ wire_n00Oi_o), (~ wire_n001O_o), wire_n00li_o, wire_n0iiO_o, wire_n00Oi_o, wire_n001O_o}),
	.o(wire_nl1Ol_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl1Ol.width_data = 8,
		nl1Ol.width_sel = 8;
	oper_selector   nl1OO
	( 
	.data({(~ wire_n00iO_o), (~ wire_n0iil_o), (~ wire_n0i1O_o), (~ wire_n000i_o), wire_n00iO_o, wire_n0iil_o, wire_n0i1O_o, wire_n000i_o}),
	.o(wire_nl1OO_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nl1OO.width_data = 8,
		nl1OO.width_sel = 8;
	oper_selector   nli0l
	( 
	.data({(~ wire_n00lO_o), (~ wire_n001O_o), wire_n00lO_o, wire_n001O_o}),
	.o(wire_nli0l_o),
	.sel({wire_nllll_o[3:0]}));
	defparam
		nli0l.width_data = 4,
		nli0l.width_sel = 4;
	oper_selector   nli0O
	( 
	.data({(~ wire_n00ll_o), (~ wire_n000i_o), wire_n00ll_o, wire_n000i_o}),
	.o(wire_nli0O_o),
	.sel({wire_nllll_o[3:0]}));
	defparam
		nli0O.width_data = 4,
		nli0O.width_sel = 4;
	oper_selector   nli1i
	( 
	.data({(~ wire_n00Oi_o), (~ wire_n001O_o), (~ wire_n00li_o), (~ wire_n0iiO_o), wire_n00Oi_o, wire_n001O_o, wire_n00li_o, wire_n0iiO_o}),
	.o(wire_nli1i_o),
	.sel({wire_nl1Oi_o[7:0]}));
	defparam
		nli1i.width_data = 8,
		nli1i.width_sel = 8;
	oper_selector   nli1l
	( 
	.data({(~ wire_n0ili_o), wire_n0ili_o}),
	.o(wire_nli1l_o),
	.sel({(~ nillOl), nillOl}));
	defparam
		nli1l.width_data = 2,
		nli1l.width_sel = 2;
	oper_selector   nli1O
	( 
	.data({(~ wire_n0ill_o), wire_n0ill_o}),
	.o(wire_nli1O_o),
	.sel({(~ nillOl), nillOl}));
	defparam
		nli1O.width_data = 2,
		nli1O.width_sel = 2;
	oper_selector   nliii
	( 
	.data({(~ wire_n00li_o), (~ wire_n000l_o), wire_n00li_o, wire_n000l_o}),
	.o(wire_nliii_o),
	.sel({wire_nllll_o[3:0]}));
	defparam
		nliii.width_data = 4,
		nliii.width_sel = 4;
	oper_selector   nliil
	( 
	.data({(~ wire_n00iO_o), (~ wire_n000O_o), wire_n00iO_o, wire_n000O_o}),
	.o(wire_nliil_o),
	.sel({wire_nllll_o[3:0]}));
	defparam
		nliil.width_data = 4,
		nliil.width_sel = 4;
	oper_selector   nliiO
	( 
	.data({(~ wire_n00il_o), (~ wire_n00ii_o), wire_n00il_o, wire_n00ii_o}),
	.o(wire_nliiO_o),
	.sel({wire_nllll_o[3:0]}));
	defparam
		nliiO.width_data = 4,
		nliiO.width_sel = 4;
	oper_selector   nlili
	( 
	.data({(~ wire_n00ii_o), (~ wire_n00il_o), wire_n00ii_o, wire_n00il_o}),
	.o(wire_nlili_o),
	.sel({wire_nllll_o[3:0]}));
	defparam
		nlili.width_data = 4,
		nlili.width_sel = 4;
	oper_selector   nlill
	( 
	.data({(~ wire_n000O_o), (~ wire_n00iO_o), wire_n000O_o, wire_n00iO_o}),
	.o(wire_nlill_o),
	.sel({wire_nllll_o[3:0]}));
	defparam
		nlill.width_data = 4,
		nlill.width_sel = 4;
	oper_selector   nlilO
	( 
	.data({(~ wire_n000l_o), (~ wire_n00li_o), wire_n000l_o, wire_n00li_o}),
	.o(wire_nlilO_o),
	.sel({wire_nllll_o[3:0]}));
	defparam
		nlilO.width_data = 4,
		nlilO.width_sel = 4;
	oper_selector   nliOi
	( 
	.data({(~ wire_n000i_o), (~ wire_n00ll_o), wire_n000i_o, wire_n00ll_o}),
	.o(wire_nliOi_o),
	.sel({wire_nllll_o[3:0]}));
	defparam
		nliOi.width_data = 4,
		nliOi.width_sel = 4;
	oper_selector   nliOl
	( 
	.data({(~ wire_n001O_o), (~ wire_n00lO_o), wire_n001O_o, wire_n00lO_o}),
	.o(wire_nliOl_o),
	.sel({wire_nllll_o[3:0]}));
	defparam
		nliOl.width_data = 4,
		nliOl.width_sel = 4;
	oper_selector   nliOO
	( 
	.data({(~ wire_n00Oi_o), wire_n00Oi_o}),
	.o(wire_nliOO_o),
	.sel({(~ nilOOi), nilOOi}));
	defparam
		nliOO.width_data = 2,
		nliOO.width_sel = 2;
	oper_selector   nll0i
	( 
	.data({(~ wire_n0i0O_o), wire_n0i0O_o}),
	.o(wire_nll0i_o),
	.sel({(~ nilOOi), nilOOi}));
	defparam
		nll0i.width_data = 2,
		nll0i.width_sel = 2;
	oper_selector   nll0l
	( 
	.data({(~ wire_n0iii_o), wire_n0iii_o}),
	.o(wire_nll0l_o),
	.sel({(~ nilOOi), nilOOi}));
	defparam
		nll0l.width_data = 2,
		nll0l.width_sel = 2;
	oper_selector   nll0O
	( 
	.data({(~ wire_n0iil_o), wire_n0iil_o}),
	.o(wire_nll0O_o),
	.sel({(~ nilOOi), nilOOi}));
	defparam
		nll0O.width_data = 2,
		nll0O.width_sel = 2;
	oper_selector   nll1i
	( 
	.data({(~ wire_n0i1O_o), wire_n0i1O_o}),
	.o(wire_nll1i_o),
	.sel({(~ nilOOi), nilOOi}));
	defparam
		nll1i.width_data = 2,
		nll1i.width_sel = 2;
	oper_selector   nll1l
	( 
	.data({(~ wire_n0i0i_o), wire_n0i0i_o}),
	.o(wire_nll1l_o),
	.sel({(~ nilOOi), nilOOi}));
	defparam
		nll1l.width_data = 2,
		nll1l.width_sel = 2;
	oper_selector   nll1O
	( 
	.data({(~ wire_n0i0l_o), wire_n0i0l_o}),
	.o(wire_nll1O_o),
	.sel({(~ nilOOi), nilOOi}));
	defparam
		nll1O.width_data = 2,
		nll1O.width_sel = 2;
	oper_selector   nllii
	( 
	.data({(~ wire_n0iiO_o), wire_n0iiO_o}),
	.o(wire_nllii_o),
	.sel({(~ nilOOi), nilOOi}));
	defparam
		nllii.width_data = 2,
		nllii.width_sel = 2;
	oper_selector   nllil
	( 
	.data({(~ wire_n0ili_o), wire_n0ili_o}),
	.o(wire_nllil_o),
	.sel({(~ nilOOi), (nillOO59 & nilOOi)}));
	defparam
		nllil.width_data = 2,
		nllil.width_sel = 2;
	oper_selector   nlliO
	( 
	.data({(~ wire_n0ill_o), (nilO1i56 & wire_n0ill_o)}),
	.o(wire_nlliO_o),
	.sel({(~ nilOOi), nilOOi}));
	defparam
		nlliO.width_data = 2,
		nlliO.width_sel = 2;
	oper_selector   nlllO
	( 
	.data({(~ wire_n00li_o), (nilO1l53 & (~ wire_n001O_o)), wire_n00li_o, wire_n001O_o}),
	.o(wire_nlllO_o),
	.sel({wire_nllll_o[3:0]}));
	defparam
		nlllO.width_data = 4,
		nlllO.width_sel = 4;
	oper_selector   nllOi
	( 
	.data({(~ wire_n00iO_o), (~ wire_n000i_o), wire_n00iO_o, wire_n000i_o}),
	.o(wire_nllOi_o),
	.sel({wire_nllll_o[3:0]}));
	defparam
		nllOi.width_data = 4,
		nllOi.width_sel = 4;
	oper_selector   nllOl
	( 
	.data({(~ wire_n00il_o), (~ wire_n000l_o), wire_n00il_o, (nilO1O50 & wire_n000l_o)}),
	.o(wire_nllOl_o),
	.sel({wire_nllll_o[3:0]}));
	defparam
		nllOl.width_data = 4,
		nllOl.width_sel = 4;
	oper_selector   nllOO
	( 
	.data({(~ wire_n00ii_o), (~ wire_n000O_o), wire_n00ii_o, wire_n000O_o}),
	.o(wire_nllOO_o),
	.sel({wire_nllll_o[3:0]}));
	defparam
		nllOO.width_data = 4,
		nllOO.width_sel = 4;
	oper_selector   nlO0i
	( 
	.data({(~ wire_n001O_o), (~ wire_n00li_o), wire_n001O_o, (nilOiO32 & wire_n00li_o)}),
	.o(wire_nlO0i_o),
	.sel({(nilOli29 & wire_nllll_o[3]), wire_nllll_o[2:0]}));
	defparam
		nlO0i.width_data = 4,
		nlO0i.width_sel = 4;
	oper_selector   nlO0l
	( 
	.data({(nilOll26 & (~ wire_n00ll_o)), wire_n00ll_o}),
	.o(wire_nlO0l_o),
	.sel({(~ nilOOi), nilOOi}));
	defparam
		nlO0l.width_data = 2,
		nlO0l.width_sel = 2;
	oper_selector   nlO0O
	( 
	.data({(nilOlO23 & (~ wire_n00lO_o)), wire_n00lO_o}),
	.o(wire_nlO0O_o),
	.sel({(~ nilOOi), nilOOi}));
	defparam
		nlO0O.width_data = 2,
		nlO0O.width_sel = 2;
	oper_selector   nlO1i
	( 
	.data({(~ wire_n000O_o), (nilO0i47 & (~ wire_n00ii_o)), wire_n000O_o, wire_n00ii_o}),
	.o(wire_nlO1i_o),
	.sel({(nilO0l44 & wire_nllll_o[3]), wire_nllll_o[2:0]}));
	defparam
		nlO1i.width_data = 4,
		nlO1i.width_sel = 4;
	oper_selector   nlO1l
	( 
	.data({(~ wire_n000l_o), (~ wire_n00il_o), wire_n000l_o, (nilO0O41 & wire_n00il_o)}),
	.o(wire_nlO1l_o),
	.sel({(nilOii38 & wire_nllll_o[3]), wire_nllll_o[2:0]}));
	defparam
		nlO1l.width_data = 4,
		nlO1l.width_sel = 4;
	oper_selector   nlO1O
	( 
	.data({(~ wire_n000i_o), (~ wire_n00iO_o), wire_n000i_o, wire_n00iO_o}),
	.o(wire_nlO1O_o),
	.sel({(nilOil35 & wire_nllll_o[3]), wire_nllll_o[2:0]}));
	defparam
		nlO1O.width_data = 4,
		nlO1O.width_sel = 4;
	assign
		disp_out_3b = {wire_nlll1l_dataout, wire_nl00ii_dataout},
		niiOOO = (wire_n1il_dataout & wire_n1iO_dataout),
		nil00i = ((~ wire_n1il_dataout) & (~ wire_n1iO_dataout)),
		nil00l = ((~ wire_n1OO_dataout) & nil00O),
		nil00O = ((~ wire_n1Oi_dataout) & (~ wire_n1Ol_dataout)),
		nil01i = (nil1Ol | nil1OO),
		nil01l = ((((wire_n1lO_dataout & (~ wire_n1il_dataout)) & (~ wire_n1iO_dataout)) & wire_n1li_dataout) & wire_n1ll_dataout),
		nil01O = (wire_n1il_dataout & wire_n1iO_dataout),
		nil0ii = (wire_n1OO_dataout & (wire_n1Ol_dataout & (wire_n1Oi_dataout & ((((~ wire_niOOOl_dataout) & ((((((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & (wire_n1il_dataout & (~ wire_n1iO_dataout)))) | ((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & ((~ wire_n1il_dataout) & wire_n1iO_dataout)))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & nil00i))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & nil00i))) & (wire_n1lO_dataout & (~ wire_n1ll_dataout)))) | (wire_niOOOl_dataout & ((((((~ wire_n1ll_dataout) & (wire_n1li_dataout & nil01O)) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & nil01O))) | (wire_n1ll_dataout & (wire_n1li_dataout & (wire_n1il_dataout & (~ wire_n1iO_dataout))))) | (wire_n1ll_dataout & (wire_n1li_dataout & ((~ wire_n1il_dataout) & wire_n1iO_dataout)))) & ((~ wire_n1lO_dataout) & wire_n1ll_dataout)))) | (wire_n1OO_dataout & (wire_n1Ol_dataout & (wire_nil_dataout & wire_n1Oi_dataout))))))),
		nil0il = (((~ wire_niOOOl_dataout) & nil0li) ^ (nil0iO | ((~ wire_niOOOl_dataout) & ((~ nil0li) & wire_nl0ilO_dataout)))),
		nil0iO = (wire_n1Oi_dataout & wire_n1Ol_dataout),
		nil0li = (nil00O | nil0iO),
		nil0ll = (wire_nil_dataout & nil01l),
		nil0lO = (wire_n01i_dataout & wire_n01l_dataout),
		nil0Oi = ((~ wire_n01i_dataout) & (~ wire_n01l_dataout)),
		nil0Ol = ((~ wire_n01i_dataout) & wire_n01l_dataout),
		nil0OO = (wire_n01i_dataout & (~ wire_n01l_dataout)),
		nil10i = (((~ wire_ni1lO_dataout) & (nil10O | (nil10l | (nil01i | ((~ wire_n1lO_dataout) & (nil1Oi | ((~ wire_n1ll_dataout) & nil1il))))))) ^ (nil10O | (((((~ wire_n1ll_dataout) & (wire_n1li_dataout & (wire_n1il_dataout & wire_n1iO_dataout))) | (wire_n1lO_dataout & nil1OO)) | (wire_n1lO_dataout & nil1Ol)) | (wire_n1lO_dataout & nil1il)))),
		nil10l = (wire_n1lO_dataout & (nil1il | (wire_n1ll_dataout & nil1Oi))),
		nil10O = (wire_nl1lil_dataout & nil1iO),
		nil11i = ((~ wire_n1il_dataout) & (~ wire_n1iO_dataout)),
		nil11l = ((~ wire_n1il_dataout) & wire_n1iO_dataout),
		nil11O = (wire_n1il_dataout & (~ wire_n1iO_dataout)),
		nil1ii = ((nil1iO & ((~ wire_n1lO_dataout) | wire_nl1lil_dataout)) | (wire_n1lO_dataout & (nil1ll & ((~ nil1il) & (~ nil1iO))))),
		nil1il = (((((niiOOO & wire_n1li_dataout) & (~ wire_n1ll_dataout)) | (wire_n1ll_dataout & (niiOOO & (~ wire_n1li_dataout)))) | (wire_n1ll_dataout & (wire_n1li_dataout & (wire_n1il_dataout & (~ wire_n1iO_dataout))))) | (wire_n1ll_dataout & (wire_n1li_dataout & ((~ wire_n1il_dataout) & wire_n1iO_dataout)))),
		nil1iO = (((((((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & (wire_n1il_dataout & wire_n1iO_dataout))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & nil11O))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & nil11l))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & nil11O))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & nil11l))) | (wire_n1ll_dataout & (wire_n1li_dataout & ((~ wire_n1il_dataout) & (~ wire_n1iO_dataout))))),
		nil1li = (nil1lO | (wire_n1lO_dataout & nil1ll)),
		nil1ll = ((~ wire_n1ll_dataout) | (wire_n1li_dataout | (wire_n1il_dataout | wire_n1iO_dataout))),
		nil1lO = ((~ wire_n1lO_dataout) & nil1Oi),
		nil1Oi = (((((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & (wire_n1il_dataout & (~ wire_n1iO_dataout)))) | ((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & ((~ wire_n1il_dataout) & wire_n1iO_dataout)))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & nil11i))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & nil11i))),
		nil1Ol = (wire_n1ll_dataout & (wire_n1li_dataout & (wire_n1il_dataout & wire_n1iO_dataout))),
		nil1OO = ((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & ((~ wire_n1il_dataout) & (~ wire_n1iO_dataout)))),
		nili0i = ((nili0O & ((~ wire_n00l_dataout) | wire_nll11O_dataout)) | (wire_n00l_dataout & (niliil & ((~ nili0l) & (~ nili0O))))),
		nili0l = (((((nil0lO & wire_n01O_dataout) & (~ wire_n00i_dataout)) | (wire_n00i_dataout & (nil0lO & (~ wire_n01O_dataout)))) | (wire_n00i_dataout & (wire_n01O_dataout & (wire_n01i_dataout & (~ wire_n01l_dataout))))) | (wire_n00i_dataout & (wire_n01O_dataout & ((~ wire_n01i_dataout) & wire_n01l_dataout)))),
		nili0O = (((((((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & (wire_n01i_dataout & wire_n01l_dataout))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & nil0OO))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & nil0Ol))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & nil0OO))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & nil0Ol))) | (wire_n00i_dataout & (wire_n01O_dataout & ((~ wire_n01i_dataout) & (~ wire_n01l_dataout))))),
		nili1i = (((~ wire_ni1Oi_dataout) & (nili1O | (nili1l | (niliOi | ((~ wire_n00l_dataout) & (nilili | ((~ wire_n00i_dataout) & nili0l))))))) ^ (nili1O | (((((~ wire_n00i_dataout) & (wire_n01O_dataout & (wire_n01i_dataout & wire_n01l_dataout))) | (wire_n00l_dataout & nililO)) | (wire_n00l_dataout & nilill)) | (wire_n00l_dataout & nili0l)))),
		nili1l = (wire_n00l_dataout & (nili0l | (wire_n00i_dataout & nilili))),
		nili1O = (wire_nll11O_dataout & nili0O),
		niliii = (niliiO | (wire_n00l_dataout & niliil)),
		niliil = ((~ wire_n00i_dataout) | (wire_n01O_dataout | (wire_n01i_dataout | wire_n01l_dataout))),
		niliiO = ((~ wire_n00l_dataout) & nilili),
		nilili = (((((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & (wire_n01i_dataout & (~ wire_n01l_dataout)))) | ((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & ((~ wire_n01i_dataout) & wire_n01l_dataout)))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & nil0Oi))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & nil0Oi))),
		nilill = (wire_n00i_dataout & (wire_n01O_dataout & (wire_n01i_dataout & wire_n01l_dataout))),
		nililO = ((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & ((~ wire_n01i_dataout) & (~ wire_n01l_dataout)))),
		niliOi = (nilill | nililO),
		niliOl = ((((wire_n00l_dataout & (~ wire_n01i_dataout)) & (~ wire_n01l_dataout)) & wire_n01O_dataout) & wire_n00i_dataout),
		niliOO = (wire_n01i_dataout & wire_n01l_dataout),
		nill0i = (wire_n0il_dataout & (wire_n0ii_dataout & (wire_n00O_dataout & ((((~ wire_nli0iO_dataout) & ((((((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & (wire_n01i_dataout & (~ wire_n01l_dataout)))) | ((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & ((~ wire_n01i_dataout) & wire_n01l_dataout)))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & nill1i))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & nill1i))) & (wire_n00l_dataout & (~ wire_n00i_dataout)))) | (wire_nli0iO_dataout & ((((((~ wire_n00i_dataout) & (wire_n01O_dataout & niliOO)) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & niliOO))) | (wire_n00i_dataout & (wire_n01O_dataout & (wire_n01i_dataout & (~ wire_n01l_dataout))))) | (wire_n00i_dataout & (wire_n01O_dataout & ((~ wire_n01i_dataout) & wire_n01l_dataout)))) & ((~ wire_n00l_dataout) & wire_n00i_dataout)))) | (wire_n0il_dataout & (wire_n0ii_dataout & (wire_niO_dataout & wire_n00O_dataout))))))),
		nill0l = (((~ wire_nli0iO_dataout) & nillii) ^ (nill0O | ((~ wire_nli0iO_dataout) & ((~ nillii) & wire_nllOii_dataout)))),
		nill0O = (wire_n00O_dataout & wire_n0ii_dataout),
		nill1i = ((~ wire_n01i_dataout) & (~ wire_n01l_dataout)),
		nill1l = ((~ wire_n0il_dataout) & nill1O),
		nill1O = ((~ wire_n00O_dataout) & (~ wire_n0ii_dataout)),
		nillii = (nill1O | nill0O),
		nillil = (wire_niO_dataout & niliOl),
		nilliO = (((((((((wire_n0ilO_o[15] | wire_n0ilO_o[14]) | wire_n0ilO_o[13]) | wire_n0ilO_o[12]) | wire_n0ilO_o[9]) | wire_n0ilO_o[7]) | wire_n0ilO_o[6]) | wire_n0ilO_o[5]) | wire_n0ilO_o[4]) | wire_n0ilO_o[1]),
		nillli = (wire_n0ilO_o[11] | wire_n0ilO_o[3]),
		nillll = (wire_n0ilO_o[10] | wire_n0ilO_o[8]),
		nilllO = (wire_n0ilO_o[2] | wire_n0ilO_o[0]),
		nillOi = 1'b1,
		nillOl = (((wire_nl1Oi_o[3] | wire_nl1Oi_o[2]) | wire_nl1Oi_o[1]) | wire_nl1Oi_o[0]),
		nilOOi = (wire_nllll_o[1] | wire_nllll_o[0]),
		nilOOl = ((~ n0l1i) & ((((~ tx_ctl_tc[0]) & (((d21_5_eq_n & d2_2_eq_n) & niO11l17) & ge_xaui_sel)) & nilOOO20) & k_det)),
		niO10i = ((n0l1i & ((k_det & ((~ tx_ctl_tc[0]) & (ge_xaui_sel & ((d21_5_eq_n & d2_2_eq_n) & niO1iO8)))) & niO1ii11)) & niO10l14),
		niO1ll = (k_det & (((~ tx_ctl_tc[0]) & (ge_xaui_sel & ((d21_5_eq_n & d2_2_eq_n) & niO1Ol2))) & niO1lO5)),
		pudr = {n001l, nil1i, n01OO, niiOl, niiOi, niilO, niill, niili, n01Ol, n01Oi, niiiO, n01lO, niiil, n01ll, n01li, n01iO, n01il, n01ii, niiii, nii0O},
		tx_ctl_pre_en = {n0lii, n0l0O},
		tx_data_9_pre_en = {n0l0l, n0l0i},
		tx_data_pre_en = {n0Oil, n0Oii, n0O0O, n0O0l, n0O0i, n0O1O, n0O1l, n0O1i, n0lOO, n0lOl, n0lOi, n0llO, n0lll, n0lli, n0liO, n0lil},
		txlp20b = {n010O, ni11O, n010l, ni11l, ni11i, n0OOO, n0OOl, n0OOi, n010i, n011O, n0OlO, n011l, n0Oll, n011i, n1OOO, n1OOl, n1OOi, n1OlO, n0Oli, n0OiO};
endmodule //stratixiigx_hssi_tx_enc_chnl_top
//synopsys translate_on
//VALID FILE

`timescale 1 ps/1 ps

module stratixiigx_hssi_tx_digi (txpcs_rst, scan_mode, txd, 
		pld_tx_clk, polinv_tx, rev_loop_data, wrenable_tx, rddisable_tx, 
		phfifourst_tx, txfifo_shared_sig_in_ch0, txfifo_shared_sig_in_q0_ch0, 
		txfifo_shared_sig_out, full_tx, empty_tx,
                tx_data_ts, tx_ctl_ts, refclk_pma, txpma_local_clk,
                tx_clk_out, tx_data_tc, tx_ctl_tc, pudr, 
                rd_enable_sync, refclk_b, txlp20b, tx_pipe_clk, encoder_testbus, tx_ctrl_testbus,
                tx_pipe_soft_reset, tx_pipe_electidle, rrev_loopbk, rev_loopbk, rbisten_tx, 
                rforce_disp, rib_force_disp, rforce_echar, rforce_kchar, rendec_tx, 
                rge_xaui_tx, 
                rdwidth_tx, rtxfifo_dis, rcascaded_8b10b_en_tx, 
                rprbsen_tx, rprbs_sel, rbist_sel, rcxpat_chnl_en, 
                renpolinv_tx, rphfifopldentx, rphfifoursttx,
                rfreerun_tx, rtxwrclksel, rtxrdclksel, renbitrev_tx, rensymswap_tx,
                r8b10b_enc_ibm_en, rtxfifo_lowlatency_en,
                rpmadwidth_tx, rpma_doublewidth_tx, rtx_pipe_enable,
                rindv_tx, rendec_data_sel_tx, rphfifo_master_sel_tx
              );

// Reset inputs
input          txpcs_rst;             // TX PCS resets

// Scan inputs
input          scan_mode;             // 1'b1 = scan mode active; 
                                      // 1'b0 = normal mode
// TX PCS channel inputs/outputs
input   [43:0] txd;                   // TXD data bus from PLD
input          pld_tx_clk;            // XGMII tx clock for this lane from PLD
input          polinv_tx;             // TX polarity inversion dynamic control signal
input   [7:0]  tx_data_ts;            // 8-bit tx data from 10G ethernet 
                                      // tx state machine (tx_sm)
input          tx_ctl_ts;             // 1-bit tx control from 10G ethernet tx state machine (tx_sm)
input          refclk_pma;            // Global parallel clock from TX PLL
input          txpma_local_clk;       // Individual TX PMA clock from TX PMA Extension
input          rev_loopbk;	      // Dynamic signal causes reverse loopback
input   [19:0] rev_loop_data;	      // 10 bit data from RX rate matching FIFO, reverse loopback
input          wrenable_tx;           // TX phase comp. FIFO write enable control signal
input          rddisable_tx;          // TX phase comp. FIFO read disable control signal
input          phfifourst_tx;	      // TX phase comp. FIFO user reset
input   [3:0]  txfifo_shared_sig_in_ch0;    // TX FIFO shared signal from channel 0
input   [3:0]  txfifo_shared_sig_in_q0_ch0; // TX FIFO shared signal from channel 0 of Quad 0

output  [3:0]  txfifo_shared_sig_out; // TX FIFO shared signal output
output         full_tx;               // TX Phase comp. FIFO full flag
output         empty_tx;              // TX Phase comp. FIFO empty flag
output         tx_clk_out;
output  [7:0]  tx_data_tc;            // 8-bit tx data from tx_ctrl to XAUI TX SM
output         tx_ctl_tc;             // TX control/TX data bit 8 from tx_ctrl to XAUI TX SM
output  [19:0] pudr;                  // TX PCS 20-bit code group bus to TX PMA
output         rd_enable_sync;
output         refclk_b;              
output [19:0]  txlp20b;               // tx 20-bit code group bus to RX PCS for loopback
output         tx_pipe_clk;           // TX PIPE interface clock
output [9:0]   encoder_testbus;       // Test bus from 8B10B encoder
output [9:0]   tx_ctrl_testbus;       // Test bus from TX FIFO
output         tx_pipe_soft_reset;    // TX PIPE soft reset from TX FIFO
output         tx_pipe_electidle;     // TxElecIdle output from TX FIFO

// TX PCS CRAMs
input          rrev_loopbk;	      // CRAM - Enable dynamic Reverse, PIPE mode
input          rbisten_tx;            // ENBIST CRAM
input 	       rforce_disp;	      // Acting with TXD[9, 19] forces current disparity to 1 or 0
input          rib_force_disp;        // Disparity force CRAM in IB mode
input          rforce_echar;          // Force /E/ char CRAM
input          rforce_kchar;          // Force /K/ char CRAM
input          rendec_tx;             // Enable 8B/10B encoder CRAM
input          rge_xaui_tx;           // GIGE Idle test enable CRAM
input          rdwidth_tx;            // TX parallel interface data width CRAM
input          rtxfifo_dis;           // TX FIFO disable CRAM
input          rcascaded_8b10b_en_tx; // Caascaded 8b/10b encoder enable CRAM
input          rprbsen_tx;            // PRBS generator enable CRAM
input   [2:0]  rprbs_sel;             // PRBS selection CRAM
input   [1:0]  rbist_sel;             // BIST selection CRAM
input   [1:0]  rcxpat_chnl_en;        // CRPAT or CJPAT selection CRAM
input          renpolinv_tx;          // TX Polarity inversion enable CRAM
input          rphfifopldentx;        // TX phase comp. FIFO PLD read/write enable CRAM
input          rphfifoursttx;         // TX phase comp. FIFO user reset enable CRAM
input          rfreerun_tx;           // TX_CLK out free running during TX PCS reset enable CRAM
input          rtxwrclksel;           // TX FIFO write clock selection CRAM
input          rtxrdclksel;           // TX FIFO read clock selection CRAM
input          renbitrev_tx;          // TX bit reversal enable CRAM
input          rensymswap_tx;         // TX symbol swap enable CRAM
input          r8b10b_enc_ibm_en;     // 8B10B Encoder fix enable CRAM
input          rtxfifo_lowlatency_en; // TX FIFO low latency enable CRAM
input          rpmadwidth_tx;         // TX PCS to TX PMA data width selection CRAM
input          rpma_doublewidth_tx;   // PCS/PMA double width (16/20) selection CRAM
input          rtx_pipe_enable;       // TX PIPE enable CRAM

// Common PCS CRAMs
input          rindv_tx;              // TX SM bypassing CRAM
input          rendec_data_sel_tx;    // TX 8B10B encoder data in selection CRAM
input          rphfifo_master_sel_tx; // TX Phase comp. FIFO pointers selection CRAM

// Wiring section
wire	       refclk_b;
wire           wr_clk_pos;
wire           fifo_rd_clk;
wire    [7:0]  tx_data_tc_high;       // high 8-bit tx data from tx_ctrl
wire    [7:0]  tx_data_tc;            // low 8-bit tx data from tx_ctrl
wire           tx_ctl_tc_high;        // high tx control/tx data bit 8 from tx_ctrl
wire           tx_ctl_tc;             // low tx control/tx data bit 8 from tx_ctrl
wire	       rd_enable_sync;
wire	[1:0]  tx_ctl_pre_en;  
wire    [15:0] tx_data_pre_en;
wire    [1:0]  tx_data_9_pre_en;
wire    [15:0] tx_data_sg;            // 16-bit data sequence generated by bist_gen.
wire    [1:0]  tx_control_sg;         // 2-bit control sequence generated by selftest_gen.
wire    [1:0]  tx_data_9_tc;          // tx data bit 9 from tx_ctrl
wire    [19:0]  tx_data_pg;           // 20-bit tx code group generated by prbs_gen
wire           soft_reset_int;
wire    [1:0]  k_det, d21_5_eq_n, d2_2_eq_n;
wire 	[1:0]  txd_extend_tc;         // Extend txd by 2 bits. Used to force disparity. This will go to the encoder. 
				      // THis is input from the PLD Fabric
wire    [1:0]  disp_out_3b;           // Disparity output from encoder for testbus
wire 	       wr_enable2;
wire    [2:0]  wptr_bin;
wire 	       rd_enable2;
wire    [2:0]  rptr_bin;

// Gated soft reset by scan_mode signal
//assign soft_reset_int = (scan_mode) ? 1'b0 : txpcs_rst;
assign soft_reset_int =  txpcs_rst;

// TX PIPE interface clock
assign tx_pipe_clk = wr_clk_pos;

// Encoder testbus
assign encoder_testbus = {disp_out_3b, pudr[7:0]};

// TX FIFO testbus
assign tx_ctrl_testbus = {1'b0, txfifo_shared_sig_out[0], wr_enable2, wptr_bin, rd_enable2, rptr_bin};

// Clock selection module
stratixiigx_hssi_tx_txclk_ctl txclk_ctl_1 (
                       .txrst(txpcs_rst), 
                       .pld_tx_clk(pld_tx_clk), 
                       .refclk_pma(refclk_pma), 
                       .txpma_local_clk(txpma_local_clk),
                       .tx_div2_sync_in_ch0(txfifo_shared_sig_in_ch0[3]),
                       .tx_div2_sync_in_q0_ch0(txfifo_shared_sig_in_q0_ch0[3]),
		       .rindv_tx(rindv_tx), 
                       .rtxrdclksel(rtxrdclksel), 
                       .rtxwrclksel(rtxwrclksel),
                       .rdwidth_tx(rdwidth_tx), 
                       .rfreerun_tx(rfreerun_tx),
                       .rphfifo_master_sel_tx(rphfifo_master_sel_tx),
                       .scan_mode (scan_mode),
		       .tx_clk_out(tx_clk_out), 
                       .tx_div2_sync_out(txfifo_shared_sig_out[3]), 
                       .wr_clk_pos(wr_clk_pos), 
                       .fifo_rd_clk(fifo_rd_clk),
                       .refclk_b(refclk_b) 
		      );
		     

// TX Phase compensation FIFO module
stratixiigx_hssi_tx_ctrl           tx_ctrl_1 (
                             .soft_reset (soft_reset_int),
                             .fifo_wr_clk (wr_clk_pos),
                             .fifo_rd_clk (fifo_rd_clk),
			     .refclk_b_in (refclk_b),
			     .scan_mode(scan_mode),
                             .indv (rindv_tx),
                             .rphfifo_master_sel_tx (rphfifo_master_sel_tx),
                             .p_rlpbk (1'b0),
                             .selftest_en (rbisten_tx),
                             .dwidth (rdwidth_tx),
                             .txfifo_dis (rtxfifo_dis),
                             .rtxfifo_urst_en(rphfifoursttx),
                             .txfifo_urst(phfifourst_tx),
                             .rtxfifo_lowlatency_en(rtxfifo_lowlatency_en),
                             .rtxphfifopldctl_en(rphfifopldentx),
                             .rtx_pipe_enable(rtx_pipe_enable),
                             .pld_we(wrenable_tx),
                             .pld_rd_dis(rddisable_tx),
                             .txd ({txd[42:33],txd[31:22],txd[20:11],txd[9:0]}),
			     .txd_extend ({txd[43],txd[32],txd[21],txd[10]}),               
			     .rforce_disp (rforce_disp),
                             .tx_data_sg ({16'h0000,tx_data_sg}),      
                             .tx_control_sg ({2'b00,tx_control_sg}),   
                             .rxd_lpbk (40'h0000000000),
                             .redund_ctl (4'h0),
                             .txd_redun (40'h0000000000),
                             .wr_enable_ch0(txfifo_shared_sig_in_ch0[2]),
                             .rd_enable_ch0(txfifo_shared_sig_in_ch0[1]),
                             .fifo_select_in_ch0(txfifo_shared_sig_in_ch0[0]),
                             .wr_enable_q0_ch0(txfifo_shared_sig_in_q0_ch0[2]),
                             .rd_enable_q0_ch0(txfifo_shared_sig_in_q0_ch0[1]),
                             .fifo_select_in_q0_ch0 (txfifo_shared_sig_in_q0_ch0[0]),
                             .rforce_kchar (rforce_kchar),
                             .rforce_echar (rforce_echar),
			     .txd_extend_tc (txd_extend_tc),               
                             .tx_data_tc ({tx_data_tc_high,tx_data_tc}),             
                             .tx_ctl_tc ({tx_ctl_tc_high,tx_ctl_tc}),             
                             .tx_data_9_tc (tx_data_9_tc),
                             .rd_enable_sync (rd_enable_sync),
                             .k_det (k_det),
                             .d21_5_eq_n (d21_5_eq_n),
			     .d2_2_eq_n (d2_2_eq_n),
			     .wr_enable_out(txfifo_shared_sig_out[2]),
			     .rd_enable_out(txfifo_shared_sig_out[1]),
                             .fifo_select_out (txfifo_shared_sig_out[0]),
                             .ph_fifo_full(full_tx),
                             .ph_fifo_empty(empty_tx),
                             .soft_reset_wclk1(tx_pipe_soft_reset),
                             .pipe_electric_idle(tx_pipe_electidle),
                             .wr_enable2(wr_enable2),
                             .wptr_bin(wptr_bin),
                             .rd_enable2(rd_enable2),
                             .rptr_bin(rptr_bin)
                            );           

// BIST generator module
stratixiigx_hssi_tx_bist_gen selftest_gen_1  (
                          .tx_clk(wr_clk_pos),
                          .soft_reset(tx_pipe_soft_reset),
                          .rbisten_tx(rbisten_tx),
                          .rpmadwidth_tx(rpmadwidth_tx),
                          .rpma_doublewidth_tx(rpma_doublewidth_tx),
                          .rdwidth_tx(rdwidth_tx),
                          .rbist_sel(rbist_sel),
                          .rcxpat_chnl_sel(rcxpat_chnl_en),
                          .bist_data_sg(tx_data_sg),
                          .bist_ctl_sg(tx_control_sg)
                         );

// PRBS generator module
stratixiigx_hssi_tx_prbs_gen prbs_gen_1      (
                          .tx_clk(refclk_b), 
                          .soft_reset(soft_reset_int), 
                          .rprbs_en_tx(rprbsen_tx), 
                          .rpmadwidth_tx(rpmadwidth_tx),
                          .rpma_doublewidth_tx(rpma_doublewidth_tx), 
                          .rprbs_sel(rprbs_sel),
                          .prbs_out(tx_data_pg)
                         );

// 8B-10B Encoder module
stratixiigx_hssi_tx_enc_chnl_top enc_chnl_top_1 (
                             .rst(soft_reset_int), 
                             .clk(refclk_b), 
                             .cascaded_8b10b_en(rcascaded_8b10b_en_tx),
                             .rendec_data_sel_tx(rendec_data_sel_tx), 
                             .rrev_loopbk(rrev_loopbk), 
                             .rev_loopbk(rev_loopbk),
                             .dwidth(rpmadwidth_tx),
                             .doublewidth(rpma_doublewidth_tx),
                             .endec(rendec_tx), 
                             .ge_xaui_sel(rge_xaui_tx), 
                             .rforce_disp(rforce_disp), 
                             .ib_force_disparity(rib_force_disp), 
                             .prbs_en(rprbsen_tx), 
                             .r8b10b_enc_ibm_en(r8b10b_enc_ibm_en),
                             .rev_loop_data(rev_loop_data),
                             .tx_ctl_ts(tx_ctl_ts),
                             .tx_ctl_tc({tx_ctl_tc_high,tx_ctl_tc}),
                             .tx_data_ts(tx_data_ts),
                             .txd_extend_tc(txd_extend_tc),
                             .tx_data_tc({tx_data_tc_high,tx_data_tc}), 
                             .tx_data_9_tc(tx_data_9_tc),
                             .tx_data_pg(tx_data_pg),
                             .k_det(k_det[0]),
                             .d21_5_eq_n(d21_5_eq_n[0]),
                             .d2_2_eq_n(d2_2_eq_n[0]),
                             .renpolinv_tx(renpolinv_tx),
                             .enpolinv_tx(polinv_tx),
                             .renbitrev_tx(renbitrev_tx),
                             .rensymswap_tx(rensymswap_tx),
                             .pudr(pudr), 
                             .txlp20b(txlp20b),
                             .tx_data_pre_en(tx_data_pre_en),
                             .tx_data_9_pre_en(tx_data_9_pre_en), 
                             .tx_ctl_pre_en(tx_ctl_pre_en),
                             .disp_out_3b(disp_out_3b)
                             );

endmodule

//****************************************************************************
// Description:
//    This is a flip-flop based implementation
//    Bit 15,14 are the underflow/overflow/insertion/deletion status bits
//    Bit 13 is the running Disparity polarity bits 
//    Bit 12 is the Disparity Error bit
//    Bit 11 is the Resync/Sync_status bit
//    Bit 10 is the Invalid Code bit
//    Bit 9 to 0 -- Encoded 10-bit data
//****************************************************************************

`timescale 1ps / 1ps

module ram20x16_syn (
    data_in,
    clk,
    fifo_wr,
    rst_l, 
    fifo_re1,
    fifo_re2,
    data_out1,
    data_out2
    );

input 		clk;
input 		rst_l;
input 	[19:0]	fifo_wr;
input 	[19:0] 	fifo_re1;
input 	[19:0] 	fifo_re2;
input 	[15:0] 	data_in;
output 	[15:0] 	data_out1;
output 	[15:0] 	data_out2;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 16;

reg [ram_width-1:0] data_out1_i, data_out2_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, 
                    ram_array_d_3, ram_array_d_4, ram_array_d_5, 
                    ram_array_d_6, ram_array_d_7, ram_array_d_8, 
                    ram_array_d_9, ram_array_d_10, ram_array_d_11,
                    ram_array_d_12, ram_array_d_13, ram_array_d_14,
		    ram_array_d_15, ram_array_d_16, ram_array_d_17, 
		    ram_array_d_18, ram_array_d_19, 
 		    ram_array_q_0, ram_array_q_1, ram_array_q_2, 
                    ram_array_q_3, ram_array_q_4, ram_array_q_5, 
                    ram_array_q_6, ram_array_q_7, ram_array_q_8, 
                    ram_array_q_9, ram_array_q_10, ram_array_q_11,
                    ram_array_q_12, ram_array_q_13, ram_array_q_14,
		    ram_array_q_15, ram_array_q_16, ram_array_q_17, 
		    ram_array_q_18, ram_array_q_19; 
wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7,
		     data_reg_8, data_reg_9, data_reg_10, data_reg_11, 
		     data_reg_12, data_reg_13, data_reg_14, data_reg_15, 
	             data_reg_16, data_reg_17, data_reg_18, data_reg_19;

wire 		we, re_l;

assign we = 1'b1;
assign re_l = 1'b0;

/* Modelling the read port */
/* Assuming address trigerred operation only */
//assignment
assign
    data_reg_0 = ( fifo_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( fifo_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( fifo_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( fifo_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( fifo_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( fifo_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( fifo_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( fifo_wr[7] == 1'b1 ) ? data_in : ram_array_q_7,
    data_reg_8 = ( fifo_wr[8] == 1'b1 ) ? data_in : ram_array_q_8,
    data_reg_9 = ( fifo_wr[9] == 1'b1 ) ? data_in : ram_array_q_9,
    data_reg_10 = ( fifo_wr[10] == 1'b1 ) ? data_in : ram_array_q_10,
    data_reg_11 = ( fifo_wr[11] == 1'b1 ) ? data_in : ram_array_q_11,
    data_reg_12 = ( fifo_wr[12] == 1'b1 ) ? data_in : ram_array_q_12,
    data_reg_13 = ( fifo_wr[13] == 1'b1 ) ? data_in : ram_array_q_13,
    data_reg_14 = ( fifo_wr[14] == 1'b1 ) ? data_in : ram_array_q_14,
    data_reg_15 = ( fifo_wr[15] == 1'b1 ) ? data_in : ram_array_q_15,
    data_reg_16 = ( fifo_wr[16] == 1'b1 ) ? data_in : ram_array_q_16,
    data_reg_17 = ( fifo_wr[17] == 1'b1 ) ? data_in : ram_array_q_17,
    data_reg_18 = ( fifo_wr[18] == 1'b1 ) ? data_in : ram_array_q_18,
    data_reg_19 = ( fifo_wr[19] == 1'b1 ) ? data_in : ram_array_q_19;


assign #read_access_time data_out1 = re_l ? 15'b0 : data_out1_i;
assign #read_access_time data_out2 = re_l ? 15'b0 : data_out2_i;


always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11      or 
    ram_array_q_12      or 
    ram_array_q_13      or 
    ram_array_q_14      or 
    ram_array_q_15      or 
    ram_array_q_16      or 
    ram_array_q_17      or 
    ram_array_q_18      or 
    ram_array_q_19      or 
    fifo_re1		or
    fifo_re2		)
begin
    case ( fifo_re1 )  // synopsys parallel_case full_case
    20'b00000000000000000001 : data_out1_i = ram_array_q_0;
    20'b00000000000000000010 : data_out1_i = ram_array_q_1;
    20'b00000000000000000100 : data_out1_i = ram_array_q_2;
    20'b00000000000000001000 : data_out1_i = ram_array_q_3;
    20'b00000000000000010000 : data_out1_i = ram_array_q_4;
    20'b00000000000000100000 : data_out1_i = ram_array_q_5;
    20'b00000000000001000000 : data_out1_i = ram_array_q_6;
    20'b00000000000010000000 : data_out1_i = ram_array_q_7;
    20'b00000000000100000000 : data_out1_i = ram_array_q_8;
    20'b00000000001000000000 : data_out1_i = ram_array_q_9;
    20'b00000000010000000000 : data_out1_i = ram_array_q_10;
    20'b00000000100000000000 : data_out1_i = ram_array_q_11;
    20'b00000001000000000000 : data_out1_i = ram_array_q_12;
    20'b00000010000000000000 : data_out1_i = ram_array_q_13;
    20'b00000100000000000000 : data_out1_i = ram_array_q_14;
    20'b00001000000000000000 : data_out1_i = ram_array_q_15;
    20'b00010000000000000000 : data_out1_i = ram_array_q_16;
    20'b00100000000000000000 : data_out1_i = ram_array_q_17;
    20'b01000000000000000000 : data_out1_i = ram_array_q_18;
    20'b10000000000000000000 : data_out1_i = ram_array_q_19;
    endcase

    case ( fifo_re2 )  // synopsys parallel_case full_case
    20'b00000000000000000001 : data_out2_i = ram_array_q_0;
    20'b00000000000000000010 : data_out2_i = ram_array_q_1;
    20'b00000000000000000100 : data_out2_i = ram_array_q_2;
    20'b00000000000000001000 : data_out2_i = ram_array_q_3;
    20'b00000000000000010000 : data_out2_i = ram_array_q_4;
    20'b00000000000000100000 : data_out2_i = ram_array_q_5;
    20'b00000000000001000000 : data_out2_i = ram_array_q_6;
    20'b00000000000010000000 : data_out2_i = ram_array_q_7;
    20'b00000000000100000000 : data_out2_i = ram_array_q_8;
    20'b00000000001000000000 : data_out2_i = ram_array_q_9;
    20'b00000000010000000000 : data_out2_i = ram_array_q_10;
    20'b00000000100000000000 : data_out2_i = ram_array_q_11;
    20'b00000001000000000000 : data_out2_i = ram_array_q_12;
    20'b00000010000000000000 : data_out2_i = ram_array_q_13;
    20'b00000100000000000000 : data_out2_i = ram_array_q_14;
    20'b00001000000000000000 : data_out2_i = ram_array_q_15;
    20'b00010000000000000000 : data_out2_i = ram_array_q_16;
    20'b00100000000000000000 : data_out2_i = ram_array_q_17;
    20'b01000000000000000000 : data_out2_i = ram_array_q_18;
    20'b10000000000000000000 : data_out2_i = ram_array_q_19;
    endcase
end


/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 0;
	ram_array_q_1 <= #write_access_time 0;
	ram_array_q_2 <= #write_access_time 0; 
	ram_array_q_3 <= #write_access_time 0; 
        ram_array_q_4 <= #write_access_time 0;
        ram_array_q_5 <= #write_access_time 0;
        ram_array_q_6 <= #write_access_time 0;
        ram_array_q_7 <= #write_access_time 0; 
        ram_array_q_8 <= #write_access_time 0;
        ram_array_q_9 <= #write_access_time 0;
        ram_array_q_10 <= #write_access_time 0;
        ram_array_q_11 <= #write_access_time 0; 
        ram_array_q_12 <= #write_access_time 0; 
        ram_array_q_13 <= #write_access_time 0; 
        ram_array_q_14 <= #write_access_time 0; 
        ram_array_q_15 <= #write_access_time 0; 
        ram_array_q_16 <= #write_access_time 0; 
        ram_array_q_17 <= #write_access_time 0; 
        ram_array_q_18 <= #write_access_time 0; 
        ram_array_q_19 <= #write_access_time 0; 
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
        ram_array_q_8 <= #write_access_time ram_array_d_8;
        ram_array_q_9 <= #write_access_time ram_array_d_9;
        ram_array_q_10 <= #write_access_time ram_array_d_10;
        ram_array_q_11 <= #write_access_time ram_array_d_11;
        ram_array_q_12 <= #write_access_time ram_array_d_12;
        ram_array_q_13 <= #write_access_time ram_array_d_13;
        ram_array_q_14 <= #write_access_time ram_array_d_14;
        ram_array_q_15 <= #write_access_time ram_array_d_15;
        ram_array_q_16 <= #write_access_time ram_array_d_16;
        ram_array_q_17 <= #write_access_time ram_array_d_17;
        ram_array_q_18 <= #write_access_time ram_array_d_18;
        ram_array_q_19 <= #write_access_time ram_array_d_19;
    end
end
         
always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    data_reg_8          or
    data_reg_9          or
    data_reg_10         or
    data_reg_11         or
    data_reg_12         or
    data_reg_13         or
    data_reg_14         or
    data_reg_15         or
    data_reg_16         or
    data_reg_17         or
    data_reg_18         or
    data_reg_19         or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	or
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11      or
    ram_array_q_12      or
    ram_array_q_13      or
    ram_array_q_14      or
    ram_array_q_15      or
    ram_array_q_16      or
    ram_array_q_17      or
    ram_array_q_18      or
    ram_array_q_19	)
begin
    if(we) begin
	ram_array_d_0 <= #write_access_time data_reg_0;
	ram_array_d_1 <= #write_access_time data_reg_1;
	ram_array_d_2 <= #write_access_time data_reg_2;
	ram_array_d_3 <= #write_access_time data_reg_3;
        ram_array_d_4 <= #write_access_time data_reg_4;
        ram_array_d_5 <= #write_access_time data_reg_5;
        ram_array_d_6 <= #write_access_time data_reg_6;
        ram_array_d_7 <= #write_access_time data_reg_7; 
        ram_array_d_8 <= #write_access_time data_reg_8;
        ram_array_d_9 <= #write_access_time data_reg_9;
        ram_array_d_10 <= #write_access_time data_reg_10;
        ram_array_d_11 <= #write_access_time data_reg_11; 
        ram_array_d_12 <= #write_access_time data_reg_12; 
        ram_array_d_13 <= #write_access_time data_reg_13; 
        ram_array_d_14 <= #write_access_time data_reg_14; 
        ram_array_d_15 <= #write_access_time data_reg_15; 
        ram_array_d_16 <= #write_access_time data_reg_16; 
        ram_array_d_17 <= #write_access_time data_reg_17; 
        ram_array_d_18 <= #write_access_time data_reg_18; 
        ram_array_d_19 <= #write_access_time data_reg_19; 
    end
    else begin
	ram_array_d_0 <= #write_access_time ram_array_q_0;
	ram_array_d_1 <= #write_access_time ram_array_q_1;
	ram_array_d_2 <= #write_access_time ram_array_q_2;
	ram_array_d_3 <= #write_access_time ram_array_q_3;
        ram_array_d_4 <= #write_access_time ram_array_q_4;
        ram_array_d_5 <= #write_access_time ram_array_q_5;
        ram_array_d_6 <= #write_access_time ram_array_q_6;
        ram_array_d_7 <= #write_access_time ram_array_q_7;
        ram_array_d_8 <= #write_access_time ram_array_q_8;
        ram_array_d_9 <= #write_access_time ram_array_q_9;
        ram_array_d_10 <= #write_access_time ram_array_q_10;
        ram_array_d_11 <= #write_access_time ram_array_q_11;
        ram_array_d_12 <= #write_access_time ram_array_q_12;
        ram_array_d_13 <= #write_access_time ram_array_q_13;
        ram_array_d_14 <= #write_access_time ram_array_q_14;
        ram_array_d_15 <= #write_access_time ram_array_q_15;
        ram_array_d_16 <= #write_access_time ram_array_q_16;
        ram_array_d_17 <= #write_access_time ram_array_q_17;
        ram_array_d_18 <= #write_access_time ram_array_q_18;
        ram_array_d_19 <= #write_access_time ram_array_q_19;
    end
end

endmodule

//************************************************************
// Description:
//
//    Started from ram16x13_syn.v and modified to have 
//    width of 14
//
//    Bit 13 is the running Disparity polarity bits 
//    Bit 12 is the Disparity Error bit
//    Bit 11 is the Resync/Sync_status bit
//    Bit 10 is the Invalid Code bit
//    Bit 9 to 0 -- Encoded 10-bit data
// **********************************************************


`timescale 1ps / 1ps

module ram16x14_syn (
    clk,
    rst_l, 
    addr_wr,
    addr_rd1,
    addr_rd2,
    data_in,
    we,
    re_l,
    data_out1,
    data_out2
    );

input 		clk;
input 		rst_l;
input 	[15:0]	addr_wr;
input 	[15:0] 	addr_rd1;
input 	[15:0] 	addr_rd2;
input 	[13:0] 	data_in;
input 		we, re_l;
output 	[13:0] 	data_out1;
output 	[13:0] 	data_out2;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 14;

reg [ram_width-1:0] data_out1_i, data_out2_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, ram_array_d_3,
		    ram_array_d_4, ram_array_d_5, ram_array_d_6, ram_array_d_7,
		    ram_array_d_8, ram_array_d_9, ram_array_d_10, 
                    ram_array_d_11,
		    ram_array_d_12, ram_array_d_13, ram_array_d_14, 
                    ram_array_d_15,
		    ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3,
		    ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7,
		    ram_array_q_8, ram_array_q_9, ram_array_q_10, 
                    ram_array_q_11,
		    ram_array_q_12, ram_array_q_13, ram_array_q_14, 
                    ram_array_q_15;
wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7,
		     data_reg_8, data_reg_9, data_reg_10, data_reg_11,
		     data_reg_12, data_reg_13, data_reg_14, data_reg_15;

 /* Modelling the read port */
 /* Assuming address trigerred operation only */
//assignment
assign
    data_reg_0 = ( addr_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( addr_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( addr_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( addr_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( addr_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( addr_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( addr_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( addr_wr[7] == 1'b1 ) ? data_in : ram_array_q_7,
    data_reg_8 = ( addr_wr[8] == 1'b1 ) ? data_in : ram_array_q_8,
    data_reg_9 = ( addr_wr[9] == 1'b1 ) ? data_in : ram_array_q_9,
    data_reg_10 = ( addr_wr[10] == 1'b1 ) ? data_in : ram_array_q_10,
    data_reg_11 = ( addr_wr[11] == 1'b1 ) ? data_in : ram_array_q_11,
    data_reg_12 = ( addr_wr[12] == 1'b1 ) ? data_in : ram_array_q_12,
    data_reg_13 = ( addr_wr[13] == 1'b1 ) ? data_in : ram_array_q_13,
    data_reg_14 = ( addr_wr[14] == 1'b1 ) ? data_in : ram_array_q_14,
    data_reg_15 = ( addr_wr[15] == 1'b1 ) ? data_in : ram_array_q_15;


assign #read_access_time data_out1 = re_l ? 13'b0000000000000 : data_out1_i;
assign #read_access_time data_out2 = re_l ? 13'b0000000000000 : data_out2_i;


always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11      or 
    ram_array_q_12      or
    ram_array_q_13      or
    ram_array_q_14      or
    ram_array_q_15      or 
    addr_rd1		or
    addr_rd2		)
begin
    case ( addr_rd1 )  // synopsys parallel_case full_case
    16'b0000000000000001 : data_out1_i = ram_array_q_0;
    16'b0000000000000010 : data_out1_i = ram_array_q_1;
    16'b0000000000000100 : data_out1_i = ram_array_q_2;
    16'b0000000000001000 : data_out1_i = ram_array_q_3;
    16'b0000000000010000 : data_out1_i = ram_array_q_4;
    16'b0000000000100000 : data_out1_i = ram_array_q_5;
    16'b0000000001000000 : data_out1_i = ram_array_q_6;
    16'b0000000010000000 : data_out1_i = ram_array_q_7;
    16'b0000000100000000 : data_out1_i = ram_array_q_8;
    16'b0000001000000000 : data_out1_i = ram_array_q_9;
    16'b0000010000000000 : data_out1_i = ram_array_q_10;
    16'b0000100000000000 : data_out1_i = ram_array_q_11;
    16'b0001000000000000 : data_out1_i = ram_array_q_12;
    16'b0010000000000000 : data_out1_i = ram_array_q_13;
    16'b0100000000000000 : data_out1_i = ram_array_q_14;
    16'b1000000000000000 : data_out1_i = ram_array_q_15;
    endcase

    case ( addr_rd2 )  // synopsys parallel_case full_case
    16'b0000000000000001 : data_out2_i = ram_array_q_0;
    16'b0000000000000010 : data_out2_i = ram_array_q_1;
    16'b0000000000000100 : data_out2_i = ram_array_q_2;
    16'b0000000000001000 : data_out2_i = ram_array_q_3;
    16'b0000000000010000 : data_out2_i = ram_array_q_4;
    16'b0000000000100000 : data_out2_i = ram_array_q_5;
    16'b0000000001000000 : data_out2_i = ram_array_q_6;
    16'b0000000010000000 : data_out2_i = ram_array_q_7;
    16'b0000000100000000 : data_out2_i = ram_array_q_8;
    16'b0000001000000000 : data_out2_i = ram_array_q_9;
    16'b0000010000000000 : data_out2_i = ram_array_q_10;
    16'b0000100000000000 : data_out2_i = ram_array_q_11;
    16'b0001000000000000 : data_out2_i = ram_array_q_12;
    16'b0010000000000000 : data_out2_i = ram_array_q_13;
    16'b0100000000000000 : data_out2_i = ram_array_q_14;
    16'b1000000000000000 : data_out2_i = ram_array_q_15;
    endcase

end


/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 0;
	ram_array_q_1 <= #write_access_time 0;
	ram_array_q_2 <= #write_access_time 0; 
	ram_array_q_3 <= #write_access_time 0; 
        ram_array_q_4 <= #write_access_time 0;
        ram_array_q_5 <= #write_access_time 0;
        ram_array_q_6 <= #write_access_time 0;
        ram_array_q_7 <= #write_access_time 0; 
        ram_array_q_8 <= #write_access_time 0;
        ram_array_q_9 <= #write_access_time 0;
        ram_array_q_10 <= #write_access_time 0;
        ram_array_q_11 <= #write_access_time 0; 
        ram_array_q_12 <= #write_access_time 0;
        ram_array_q_13 <= #write_access_time 0;
        ram_array_q_14 <= #write_access_time 0;
        ram_array_q_15 <= #write_access_time 0; 
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
        ram_array_q_8 <= #write_access_time ram_array_d_8;
        ram_array_q_9 <= #write_access_time ram_array_d_9;
        ram_array_q_10 <= #write_access_time ram_array_d_10;
        ram_array_q_11 <= #write_access_time ram_array_d_11;
        ram_array_q_12 <= #write_access_time ram_array_d_12;
        ram_array_q_13 <= #write_access_time ram_array_d_13;
        ram_array_q_14 <= #write_access_time ram_array_d_14;
        ram_array_q_15 <= #write_access_time ram_array_d_15;
    end
end
         

always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    data_reg_8          or
    data_reg_9          or
    data_reg_10         or
    data_reg_11         or
    data_reg_12         or
    data_reg_13         or
    data_reg_14         or
    data_reg_15         or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	or
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11	or
    ram_array_q_12      or
    ram_array_q_13      or
    ram_array_q_14      or
    ram_array_q_15	)
begin
    if(we) begin
	ram_array_d_0 <= #write_access_time data_reg_0;
	ram_array_d_1 <= #write_access_time data_reg_1;
	ram_array_d_2 <= #write_access_time data_reg_2;
	ram_array_d_3 <= #write_access_time data_reg_3;
        ram_array_d_4 <= #write_access_time data_reg_4;
        ram_array_d_5 <= #write_access_time data_reg_5;
        ram_array_d_6 <= #write_access_time data_reg_6;
        ram_array_d_7 <= #write_access_time data_reg_7; 
        ram_array_d_8 <= #write_access_time data_reg_8;
        ram_array_d_9 <= #write_access_time data_reg_9;
        ram_array_d_10 <= #write_access_time data_reg_10;
        ram_array_d_11 <= #write_access_time data_reg_11; 
        ram_array_d_12 <= #write_access_time data_reg_12;
        ram_array_d_13 <= #write_access_time data_reg_13;
        ram_array_d_14 <= #write_access_time data_reg_14;
        ram_array_d_15 <= #write_access_time data_reg_15; 
    end
    else begin
	ram_array_d_0 <= #write_access_time ram_array_q_0;
	ram_array_d_1 <= #write_access_time ram_array_q_1;
	ram_array_d_2 <= #write_access_time ram_array_q_2;
	ram_array_d_3 <= #write_access_time ram_array_q_3;
        ram_array_d_4 <= #write_access_time ram_array_q_4;
        ram_array_d_5 <= #write_access_time ram_array_q_5;
        ram_array_d_6 <= #write_access_time ram_array_q_6;
        ram_array_d_7 <= #write_access_time ram_array_q_7;
        ram_array_d_8 <= #write_access_time ram_array_q_8;
        ram_array_d_9 <= #write_access_time ram_array_q_9;
        ram_array_d_10 <= #write_access_time ram_array_q_10;
        ram_array_d_11 <= #write_access_time ram_array_q_11;
        ram_array_d_12 <= #write_access_time ram_array_q_12;
        ram_array_d_13 <= #write_access_time ram_array_q_13;
        ram_array_d_14 <= #write_access_time ram_array_q_14;
        ram_array_d_15 <= #write_access_time ram_array_q_15;

    end
end

endmodule

module ram8x65_syn (
    rst_l, 
    clk,
    fifo_wr,
    data_in,
    fifo_re,
    data_out
    );

input 		rst_l;
input 		clk;
input 	[7:0]	fifo_wr;
input 	[64:0] 	data_in;
input 	[7:0] 	fifo_re;
output 	[64:0] 	data_out;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 65;

reg [ram_width-1:0] data_out_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, 
                    ram_array_d_3, ram_array_d_4, ram_array_d_5, 
                    ram_array_d_6, ram_array_d_7, 
 		    ram_array_q_0, ram_array_q_1, ram_array_q_2, 
                    ram_array_q_3, ram_array_q_4, ram_array_q_5, 
                    ram_array_q_6, ram_array_q_7;

wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7;

wire 		we, re_l;

assign we = 1'b1;
assign re_l = 1'b0;

/* Modelling the read port */
/* Assuming address trigerred operation only */
//assignment
assign
    data_reg_0 = ( fifo_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( fifo_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( fifo_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( fifo_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( fifo_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( fifo_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( fifo_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( fifo_wr[7] == 1'b1 ) ? data_in : ram_array_q_7;

assign  data_out = re_l ? 60'b0 : data_out_i;

always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    fifo_re		
    )
begin
    case ( fifo_re )  // synopsys parallel_case full_case
    8'b00000001 : data_out_i = ram_array_q_0;
    8'b00000010 : data_out_i = ram_array_q_1;
    8'b00000100 : data_out_i = ram_array_q_2;
    8'b00001000 : data_out_i = ram_array_q_3;
    8'b00010000 : data_out_i = ram_array_q_4;
    8'b00100000 : data_out_i = ram_array_q_5;
    8'b01000000 : data_out_i = ram_array_q_6;
    8'b10000000 : data_out_i = ram_array_q_7;
    default     : data_out_i = ram_array_q_0;
    endcase

end


/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 0;
	ram_array_q_1 <= #write_access_time 0;
	ram_array_q_2 <= #write_access_time 0; 
	ram_array_q_3 <= #write_access_time 0; 
        ram_array_q_4 <= #write_access_time 0;
        ram_array_q_5 <= #write_access_time 0;
        ram_array_q_6 <= #write_access_time 0;
        ram_array_q_7 <= #write_access_time 0; 
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
    end
end
         
always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	
       )
begin
    if(we) begin
	ram_array_d_0 =  data_reg_0;
	ram_array_d_1 =  data_reg_1;
	ram_array_d_2 =  data_reg_2;
	ram_array_d_3 =  data_reg_3;
        ram_array_d_4 =  data_reg_4;
        ram_array_d_5 =  data_reg_5;
        ram_array_d_6 =  data_reg_6;
        ram_array_d_7 =  data_reg_7; 
    end
    else begin
	ram_array_d_0 =  ram_array_q_0;
	ram_array_d_1 =  ram_array_q_1;
	ram_array_d_2 =  ram_array_q_2;
	ram_array_d_3 =  ram_array_q_3;
        ram_array_d_4 =  ram_array_q_4;
        ram_array_d_5 =  ram_array_q_5;
        ram_array_d_6 =  ram_array_q_6;
        ram_array_d_7 =  ram_array_q_7;
    end
end

endmodule
//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 160 mux21 608 oper_add 8 oper_decoder 4 oper_selector 41 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_rx_bist_ver
	( 
	bistdone,
	bisterr,
	clk_2,
	cur_state,
	err_ctl,
	err_data,
	prbs_done,
	prbs_err,
	rbist_clr_rx,
	rbist_sel,
	rbisten_rx,
	rcxpat_chnl_sel,
	rdwidth_rx,
	rpma_doublewidth_rx,
	rpmadwidth_rx,
	rxc,
	rxd,
	selftest_done,
	selftest_err,
	soft_reset,
	sync_status) /* synthesis synthesis_clearbox=1 */;
	output   bistdone;
	output   bisterr;
	input   clk_2;
	output   [4:0]  cur_state;
	output   [1:0]  err_ctl;
	output   [15:0]  err_data;
	input   prbs_done;
	input   prbs_err;
	input   rbist_clr_rx;
	input   [1:0]  rbist_sel;
	input   rbisten_rx;
	input   [1:0]  rcxpat_chnl_sel;
	input   rdwidth_rx;
	input   rpma_doublewidth_rx;
	input   rpmadwidth_rx;
	input   [3:0]  rxc;
	input   [63:0]  rxd;
	output   selftest_done;
	output   selftest_err;
	input   soft_reset;
	input   sync_status;

	reg	n0liiO58;
	reg	n0liiO59;
	reg	n0liiO60;
	reg	n0lili55;
	reg	n0lili56;
	reg	n0lili57;
	reg	n0lill52;
	reg	n0lill53;
	reg	n0lill54;
	reg	n0lilO49;
	reg	n0lilO50;
	reg	n0lilO51;
	reg	n0liOi46;
	reg	n0liOi47;
	reg	n0liOi48;
	reg	n0liOl43;
	reg	n0liOl44;
	reg	n0liOl45;
	reg	n0ll0i34;
	reg	n0ll0i35;
	reg	n0ll0i36;
	reg	n0ll0O31;
	reg	n0ll0O32;
	reg	n0ll0O33;
	reg	n0ll1i40;
	reg	n0ll1i41;
	reg	n0ll1i42;
	reg	n0ll1O37;
	reg	n0ll1O38;
	reg	n0ll1O39;
	reg	n0llOi28;
	reg	n0llOi29;
	reg	n0llOi30;
	reg	n0O00i10;
	reg	n0O00i11;
	reg	n0O00i12;
	reg	n0O01l13;
	reg	n0O01l14;
	reg	n0O01l15;
	reg	n0O0ll7;
	reg	n0O0ll8;
	reg	n0O0ll9;
	reg	n0O0Oi4;
	reg	n0O0Oi5;
	reg	n0O0Oi6;
	reg	n0O0OO1;
	reg	n0O0OO2;
	reg	n0O0OO3;
	reg	n0O11l25;
	reg	n0O11l26;
	reg	n0O11l27;
	reg	n0O1il22;
	reg	n0O1il23;
	reg	n0O1il24;
	reg	n0O1Oi19;
	reg	n0O1Oi20;
	reg	n0O1Oi21;
	reg	n0O1OO16;
	reg	n0O1OO17;
	reg	n0O1OO18;
	reg	ni00l;
	reg	ni01O;
	reg	nii0OO;
	reg	niii0i;
	reg	niii0l;
	reg	niii0O;
	reg	niii1i;
	reg	niii1l;
	reg	niii1O;
	reg	niiiii;
	reg	niiiil;
	reg	niiiiO;
	reg	niiili;
	reg	niiill;
	reg	niiilO;
	reg	niiiOi;
	reg	niiiOl;
	reg	niiiOO;
	reg	niil1i;
	reg	niil1l;
	reg	niil1O;
	reg	niilii;
	reg	niilil;
	reg	nll1Oi;
	reg	nll1Ol;
	reg	n0OOOi;
	reg	ni00O;
	reg	ni01i;
	reg	ni01l;
	reg	ni0ii;
	reg	ni0il;
	reg	ni0iO;
	reg	ni0li;
	reg	ni0ll;
	reg	ni0lO;
	reg	ni0Oi;
	reg	ni0Ol;
	reg	nii1i;
	reg	niil0i;
	reg	niil0l;
	reg	niil0O;
	reg	niiliO;
	reg	niilli;
	reg	niilll;
	reg	niillO;
	reg	niilOi;
	reg	niilOl;
	reg	niilOO;
	reg	niiO0i;
	reg	niiO0l;
	reg	niiO0O;
	reg	niiO1i;
	reg	niiO1l;
	reg	niiO1O;
	reg	niiOii;
	reg	niiOil;
	reg	niiOiO;
	reg	niiOli;
	reg	niiOll;
	reg	niiOlO;
	reg	niiOOi;
	reg	niiOOl;
	reg	niiOOO;
	reg	nil10i;
	reg	nil10l;
	reg	nil10O;
	reg	nil11i;
	reg	nil11l;
	reg	nil11O;
	reg	nil1ii;
	reg	nl1lii;
	reg	nll00i;
	reg	nll00l;
	reg	nll00O;
	reg	nll01i;
	reg	nll01l;
	reg	nll01O;
	reg	nll0Oi;
	reg	nll0Ol;
	reg	nll0OO;
	reg	nll1ll;
	reg	nll1lO;
	reg	nll1OO;
	reg	nlli0i;
	reg	nlli0l;
	reg	nlli0O;
	reg	nlli1i;
	reg	nlli1l;
	reg	nlli1O;
	reg	nlliii;
	reg	nlliil;
	reg	nlliiO;
	reg	nllili;
	reg	nllill;
	reg	nllilO;
	reg	nlliOi;
	reg	nlOOOi;
	reg	nll0il;
	wire	wire_nll0ii_ENA;
	reg	nll0li;
	wire	wire_nll0iO_ENA;
	reg	nll0lO;
	wire	wire_nll0ll_ENA;
	wire	wire_n000i_dataout;
	wire	wire_n000l_dataout;
	wire	wire_n000O_dataout;
	wire	wire_n001i_dataout;
	wire	wire_n001l_dataout;
	wire	wire_n001O_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00ii_dataout;
	wire	wire_n00il_dataout;
	wire	wire_n00iO_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00li_dataout;
	wire	wire_n00ll_dataout;
	wire	wire_n00lO_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n00Oi_dataout;
	wire	wire_n00Ol_dataout;
	wire	wire_n00OO_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n011i_dataout;
	wire	wire_n011l_dataout;
	wire	wire_n011O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01ii_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01iO_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01lO_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01Oi_dataout;
	wire	wire_n01Ol_dataout;
	wire	wire_n01OO_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0i0i_dataout;
	wire	wire_n0i0l_dataout;
	wire	wire_n0i0O_dataout;
	wire	wire_n0i1i_dataout;
	wire	wire_n0i1l_dataout;
	wire	wire_n0i1O_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0iii_dataout;
	wire	wire_n0iil_dataout;
	wire	wire_n0iiO_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0ili_dataout;
	wire	wire_n0ill_dataout;
	wire	wire_n0ilO_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0iOi_dataout;
	wire	wire_n0iOl_dataout;
	wire	wire_n0iOO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0l0i_dataout;
	wire	wire_n0l0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0l1i_dataout;
	wire	wire_n0l1l_dataout;
	wire	wire_n0l1O_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0lii_dataout;
	wire	wire_n0lil_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0lli_dataout;
	wire	wire_n0lll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lOi_dataout;
	wire	wire_n0lOl_dataout;
	wire	wire_n0lOO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O0l_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Oil_dataout;
	wire	wire_n0OiO_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0Oll_dataout;
	wire	wire_n0OlO_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n0OOO_dataout;
	wire	wire_n100l_dataout;
	wire	wire_n100O_dataout;
	wire	wire_n10ii_dataout;
	wire	wire_n10il_dataout;
	wire	wire_n10iO_dataout;
	wire	wire_n10li_dataout;
	wire	wire_n10ll_dataout;
	wire	wire_n10lO_dataout;
	wire	wire_n10Oi_dataout;
	wire	wire_n10Ol_dataout;
	wire	wire_n10OO_dataout;
	wire	wire_n1i0i_dataout;
	wire	wire_n1i0l_dataout;
	wire	wire_n1i0O_dataout;
	wire	wire_n1i1i_dataout;
	wire	wire_n1i1l_dataout;
	wire	wire_n1iii_dataout;
	wire	wire_n1iil_dataout;
	wire	wire_n1iiO_dataout;
	wire	wire_n1ili_dataout;
	wire	wire_n1ill_dataout;
	wire	wire_n1ilO_dataout;
	wire	wire_n1iOi_dataout;
	wire	wire_n1iOl_dataout;
	wire	wire_n1iOO_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1l0i_dataout;
	wire	wire_n1l0l_dataout;
	wire	wire_n1l0O_dataout;
	wire	wire_n1l1i_dataout;
	wire	wire_n1l1l_dataout;
	wire	wire_n1l1O_dataout;
	wire	wire_n1lii_dataout;
	wire	wire_n1lil_dataout;
	wire	wire_n1liO_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lli_dataout;
	wire	wire_n1lll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1lOi_dataout;
	wire	wire_n1lOl_dataout;
	wire	wire_n1lOO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1O0i_dataout;
	wire	wire_n1O0l_dataout;
	wire	wire_n1O0O_dataout;
	wire	wire_n1O1i_dataout;
	wire	wire_n1O1l_dataout;
	wire	wire_n1O1O_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Oii_dataout;
	wire	wire_n1Oil_dataout;
	wire	wire_n1OiO_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1Oli_dataout;
	wire	wire_n1Oll_dataout;
	wire	wire_n1OlO_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_n1OOi_dataout;
	wire	wire_n1OOl_dataout;
	wire	wire_n1OOO_dataout;
	wire	wire_ni_dataout;
	wire	wire_ni000i_dataout;
	wire	wire_ni000l_dataout;
	wire	wire_ni001i_dataout;
	wire	wire_ni001l_dataout;
	wire	wire_ni001O_dataout;
	wire	wire_ni00ii_dataout;
	wire	wire_ni00il_dataout;
	wire	wire_ni00li_dataout;
	wire	wire_ni00ll_dataout;
	wire	wire_ni00lO_dataout;
	wire	wire_ni00Oi_dataout;
	wire	wire_ni00Ol_dataout;
	wire	wire_ni00OO_dataout;
	wire	wire_ni010i_dataout;
	wire	wire_ni010l_dataout;
	wire	wire_ni010O_dataout;
	wire	wire_ni011i_dataout;
	wire	wire_ni011l_dataout;
	wire	wire_ni011O_dataout;
	wire	wire_ni01ii_dataout;
	wire	wire_ni01iO_dataout;
	wire	wire_ni01li_dataout;
	wire	wire_ni01lO_dataout;
	wire	wire_ni01Oi_dataout;
	wire	wire_ni01OO_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0i0i_dataout;
	wire	wire_ni0i0l_dataout;
	wire	wire_ni0i0O_dataout;
	wire	wire_ni0i1i_dataout;
	wire	wire_ni0i1l_dataout;
	wire	wire_ni0i1O_dataout;
	wire	wire_ni0iii_dataout;
	wire	wire_ni0iil_dataout;
	wire	wire_ni0ill_dataout;
	wire	wire_ni0ilO_dataout;
	wire	wire_ni0iOi_dataout;
	wire	wire_ni0iOl_dataout;
	wire	wire_ni0iOO_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0l0i_dataout;
	wire	wire_ni0l0l_dataout;
	wire	wire_ni0l0O_dataout;
	wire	wire_ni0l1i_dataout;
	wire	wire_ni0l1l_dataout;
	wire	wire_ni0l1O_dataout;
	wire	wire_ni0lii_dataout;
	wire	wire_ni0lil_dataout;
	wire	wire_ni0liO_dataout;
	wire	wire_ni0lli_dataout;
	wire	wire_ni0lll_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0O0i_dataout;
	wire	wire_ni0O0l_dataout;
	wire	wire_ni0O1l_dataout;
	wire	wire_ni0O1O_dataout;
	wire	wire_ni0OOi_dataout;
	wire	wire_ni100i_dataout;
	wire	wire_ni100l_dataout;
	wire	wire_ni100O_dataout;
	wire	wire_ni101O_dataout;
	wire	wire_ni10i_dataout;
	wire	wire_ni10ii_dataout;
	wire	wire_ni10il_dataout;
	wire	wire_ni10iO_dataout;
	wire	wire_ni10l_dataout;
	wire	wire_ni10li_dataout;
	wire	wire_ni10ll_dataout;
	wire	wire_ni10lO_dataout;
	wire	wire_ni10O_dataout;
	wire	wire_ni10Oi_dataout;
	wire	wire_ni10Ol_dataout;
	wire	wire_ni10OO_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni11l_dataout;
	wire	wire_ni11O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1i0i_dataout;
	wire	wire_ni1i0l_dataout;
	wire	wire_ni1i0O_dataout;
	wire	wire_ni1i1l_dataout;
	wire	wire_ni1i1O_dataout;
	wire	wire_ni1ii_dataout;
	wire	wire_ni1iii_dataout;
	wire	wire_ni1iil_dataout;
	wire	wire_ni1iiO_dataout;
	wire	wire_ni1il_dataout;
	wire	wire_ni1ill_dataout;
	wire	wire_ni1ilO_dataout;
	wire	wire_ni1iO_dataout;
	wire	wire_ni1iOi_dataout;
	wire	wire_ni1iOl_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1l0i_dataout;
	wire	wire_ni1l0l_dataout;
	wire	wire_ni1l0O_dataout;
	wire	wire_ni1l1i_dataout;
	wire	wire_ni1l1l_dataout;
	wire	wire_ni1lii_dataout;
	wire	wire_ni1lil_dataout;
	wire	wire_ni1liO_dataout;
	wire	wire_ni1lli_dataout;
	wire	wire_ni1llO_dataout;
	wire	wire_ni1lOi_dataout;
	wire	wire_ni1lOO_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1O0i_dataout;
	wire	wire_ni1O0l_dataout;
	wire	wire_ni1O0O_dataout;
	wire	wire_ni1O1i_dataout;
	wire	wire_ni1O1O_dataout;
	wire	wire_ni1Oii_dataout;
	wire	wire_ni1Oil_dataout;
	wire	wire_ni1Oli_dataout;
	wire	wire_ni1Oll_dataout;
	wire	wire_ni1OOi_dataout;
	wire	wire_ni1OOl_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii11i_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil00i_dataout;
	wire	wire_nil00l_dataout;
	wire	wire_nil00O_dataout;
	wire	wire_nil01i_dataout;
	wire	wire_nil01l_dataout;
	wire	wire_nil01O_dataout;
	wire	wire_nil0ii_dataout;
	wire	wire_nil0il_dataout;
	wire	wire_nil0iO_dataout;
	wire	wire_nil0li_dataout;
	wire	wire_nil0ll_dataout;
	wire	wire_nil0lO_dataout;
	wire	wire_nil0Oi_dataout;
	wire	wire_nil0Ol_dataout;
	wire	wire_nil0OO_dataout;
	wire	wire_nil1il_dataout;
	wire	wire_nil1iO_dataout;
	wire	wire_nil1li_dataout;
	wire	wire_nil1ll_dataout;
	wire	wire_nil1lO_dataout;
	wire	wire_nil1Oi_dataout;
	wire	wire_nil1Ol_dataout;
	wire	wire_nil1OO_dataout;
	wire	wire_nili_dataout;
	wire	wire_nili0i_dataout;
	wire	wire_nili0l_dataout;
	wire	wire_nili0O_dataout;
	wire	wire_nili1i_dataout;
	wire	wire_nili1l_dataout;
	wire	wire_nili1O_dataout;
	wire	wire_niliii_dataout;
	wire	wire_niliil_dataout;
	wire	wire_niliiO_dataout;
	wire	wire_nilili_dataout;
	wire	wire_nilill_dataout;
	wire	wire_nililO_dataout;
	wire	wire_niliOi_dataout;
	wire	wire_niliOl_dataout;
	wire	wire_niliOO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nill0i_dataout;
	wire	wire_nill0l_dataout;
	wire	wire_nill0O_dataout;
	wire	wire_nill1i_dataout;
	wire	wire_nill1l_dataout;
	wire	wire_nill1O_dataout;
	wire	wire_nillii_dataout;
	wire	wire_nillil_dataout;
	wire	wire_nilliO_dataout;
	wire	wire_nillli_dataout;
	wire	wire_nillll_dataout;
	wire	wire_nilllO_dataout;
	wire	wire_nillOi_dataout;
	wire	wire_nillOl_dataout;
	wire	wire_nillOO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilO0i_dataout;
	wire	wire_nilO0l_dataout;
	wire	wire_nilO0O_dataout;
	wire	wire_nilO1i_dataout;
	wire	wire_nilO1l_dataout;
	wire	wire_nilO1O_dataout;
	wire	wire_nilOii_dataout;
	wire	wire_nilOil_dataout;
	wire	wire_nilOiO_dataout;
	wire	wire_nilOli_dataout;
	wire	wire_nilOll_dataout;
	wire	wire_nilOlO_dataout;
	wire	wire_nilOOi_dataout;
	wire	wire_nilOOl_dataout;
	wire	wire_nilOOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO00i_dataout;
	wire	wire_niO00l_dataout;
	wire	wire_niO00O_dataout;
	wire	wire_niO01i_dataout;
	wire	wire_niO01l_dataout;
	wire	wire_niO01O_dataout;
	wire	wire_niO0ii_dataout;
	wire	wire_niO0il_dataout;
	wire	wire_niO0iO_dataout;
	wire	wire_niO0li_dataout;
	wire	wire_niO0ll_dataout;
	wire	wire_niO0lO_dataout;
	wire	wire_niO0Oi_dataout;
	wire	wire_niO0Ol_dataout;
	wire	wire_niO10i_dataout;
	wire	wire_niO10l_dataout;
	wire	wire_niO10O_dataout;
	wire	wire_niO11i_dataout;
	wire	wire_niO11l_dataout;
	wire	wire_niO11O_dataout;
	wire	wire_niO1ii_dataout;
	wire	wire_niO1il_dataout;
	wire	wire_niO1iO_dataout;
	wire	wire_niO1li_dataout;
	wire	wire_niO1ll_dataout;
	wire	wire_niO1OO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl_dataout;
	wire	wire_nl000i_dataout;
	wire	wire_nl000l_dataout;
	wire	wire_nl000O_dataout;
	wire	wire_nl001i_dataout;
	wire	wire_nl001l_dataout;
	wire	wire_nl001O_dataout;
	wire	wire_nl00ii_dataout;
	wire	wire_nl00il_dataout;
	wire	wire_nl00iO_dataout;
	wire	wire_nl00li_dataout;
	wire	wire_nl00ll_dataout;
	wire	wire_nl00lO_dataout;
	wire	wire_nl00Oi_dataout;
	wire	wire_nl00Ol_dataout;
	wire	wire_nl00OO_dataout;
	wire	wire_nl010i_dataout;
	wire	wire_nl010l_dataout;
	wire	wire_nl010O_dataout;
	wire	wire_nl011i_dataout;
	wire	wire_nl011l_dataout;
	wire	wire_nl011O_dataout;
	wire	wire_nl01ii_dataout;
	wire	wire_nl01il_dataout;
	wire	wire_nl01iO_dataout;
	wire	wire_nl01ll_dataout;
	wire	wire_nl01lO_dataout;
	wire	wire_nl01Oi_dataout;
	wire	wire_nl01Ol_dataout;
	wire	wire_nl01OO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0i0l_dataout;
	wire	wire_nl0i0O_dataout;
	wire	wire_nl0i1i_dataout;
	wire	wire_nl0i1l_dataout;
	wire	wire_nl0i1O_dataout;
	wire	wire_nl0iii_dataout;
	wire	wire_nl0iil_dataout;
	wire	wire_nl0iiO_dataout;
	wire	wire_nl0ili_dataout;
	wire	wire_nl0ill_dataout;
	wire	wire_nl0ilO_dataout;
	wire	wire_nl0iOi_dataout;
	wire	wire_nl0iOl_dataout;
	wire	wire_nl0iOO_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0l0i_dataout;
	wire	wire_nl0l0l_dataout;
	wire	wire_nl0l0O_dataout;
	wire	wire_nl0l1i_dataout;
	wire	wire_nl0l1l_dataout;
	wire	wire_nl0l1O_dataout;
	wire	wire_nl0lii_dataout;
	wire	wire_nl0lil_dataout;
	wire	wire_nl0liO_dataout;
	wire	wire_nl0lli_dataout;
	wire	wire_nl0lll_dataout;
	wire	wire_nl0llO_dataout;
	wire	wire_nl0lOi_dataout;
	wire	wire_nl0lOl_dataout;
	wire	wire_nl0lOO_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl0O0i_dataout;
	wire	wire_nl0O0l_dataout;
	wire	wire_nl0O0O_dataout;
	wire	wire_nl0O1i_dataout;
	wire	wire_nl0O1l_dataout;
	wire	wire_nl0O1O_dataout;
	wire	wire_nl0Oii_dataout;
	wire	wire_nl0Oil_dataout;
	wire	wire_nl0OiO_dataout;
	wire	wire_nl0Oli_dataout;
	wire	wire_nl0Oll_dataout;
	wire	wire_nl0OlO_dataout;
	wire	wire_nl0OOi_dataout;
	wire	wire_nl0OOl_dataout;
	wire	wire_nl0OOO_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1lli_dataout;
	wire	wire_nl1lll_dataout;
	wire	wire_nl1llO_dataout;
	wire	wire_nl1lOi_dataout;
	wire	wire_nl1lOl_dataout;
	wire	wire_nl1lOO_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1O1i_dataout;
	wire	wire_nl1OOi_dataout;
	wire	wire_nl1OOl_dataout;
	wire	wire_nl1OOO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli00i_dataout;
	wire	wire_nli00l_dataout;
	wire	wire_nli00O_dataout;
	wire	wire_nli01i_dataout;
	wire	wire_nli01l_dataout;
	wire	wire_nli01O_dataout;
	wire	wire_nli0ii_dataout;
	wire	wire_nli0il_dataout;
	wire	wire_nli0iO_dataout;
	wire	wire_nli0li_dataout;
	wire	wire_nli0ll_dataout;
	wire	wire_nli0lO_dataout;
	wire	wire_nli0Oi_dataout;
	wire	wire_nli0Ol_dataout;
	wire	wire_nli0OO_dataout;
	wire	wire_nli10i_dataout;
	wire	wire_nli10l_dataout;
	wire	wire_nli10O_dataout;
	wire	wire_nli11i_dataout;
	wire	wire_nli11l_dataout;
	wire	wire_nli11O_dataout;
	wire	wire_nli1ii_dataout;
	wire	wire_nli1il_dataout;
	wire	wire_nli1iO_dataout;
	wire	wire_nli1li_dataout;
	wire	wire_nli1ll_dataout;
	wire	wire_nli1lO_dataout;
	wire	wire_nli1Oi_dataout;
	wire	wire_nli1Ol_dataout;
	wire	wire_nli1OO_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlii0i_dataout;
	wire	wire_nlii0l_dataout;
	wire	wire_nlii0O_dataout;
	wire	wire_nlii1l_dataout;
	wire	wire_nlii1O_dataout;
	wire	wire_nliiii_dataout;
	wire	wire_nliiil_dataout;
	wire	wire_nliiiO_dataout;
	wire	wire_nliili_dataout;
	wire	wire_nliill_dataout;
	wire	wire_nliilO_dataout;
	wire	wire_nliiOi_dataout;
	wire	wire_nliiOl_dataout;
	wire	wire_nliiOO_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlil0i_dataout;
	wire	wire_nlil0l_dataout;
	wire	wire_nlil0O_dataout;
	wire	wire_nlil1i_dataout;
	wire	wire_nlil1l_dataout;
	wire	wire_nlil1O_dataout;
	wire	wire_nlilii_dataout;
	wire	wire_nlilil_dataout;
	wire	wire_nliliO_dataout;
	wire	wire_nlilli_dataout;
	wire	wire_nlilll_dataout;
	wire	wire_nlillO_dataout;
	wire	wire_nlilOi_dataout;
	wire	wire_nlilOl_dataout;
	wire	wire_nlilOO_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliO0i_dataout;
	wire	wire_nliO0l_dataout;
	wire	wire_nliO0O_dataout;
	wire	wire_nliO1i_dataout;
	wire	wire_nliO1l_dataout;
	wire	wire_nliO1O_dataout;
	wire	wire_nliOii_dataout;
	wire	wire_nliOiO_dataout;
	wire	wire_nliOli_dataout;
	wire	wire_nliOll_dataout;
	wire	wire_nliOlO_dataout;
	wire	wire_nliOOi_dataout;
	wire	wire_nliOOl_dataout;
	wire	wire_nliOOO_dataout;
	wire	wire_nll10i_dataout;
	wire	wire_nll10l_dataout;
	wire	wire_nll11i_dataout;
	wire	wire_nll11l_dataout;
	wire	wire_nll11O_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlliOl_dataout;
	wire	wire_nlliOO_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nlll0i_dataout;
	wire	wire_nlll0l_dataout;
	wire	wire_nlll0O_dataout;
	wire	wire_nlll1i_dataout;
	wire	wire_nlll1l_dataout;
	wire	wire_nlll1O_dataout;
	wire	wire_nlllii_dataout;
	wire	wire_nlllil_dataout;
	wire	wire_nllliO_dataout;
	wire	wire_nlllli_dataout;
	wire	wire_nlllll_dataout;
	wire	wire_nllllO_dataout;
	wire	wire_nlllOO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllO0i_dataout;
	wire	wire_nllO0l_dataout;
	wire	wire_nllO0O_dataout;
	wire	wire_nllO1i_dataout;
	wire	wire_nllO1l_dataout;
	wire	wire_nllO1O_dataout;
	wire	wire_nllOii_dataout;
	wire	wire_nllOiO_dataout;
	wire	wire_nllOli_dataout;
	wire	wire_nllOll_dataout;
	wire	wire_nllOlO_dataout;
	wire	wire_nllOOi_dataout;
	wire	wire_nllOOl_dataout;
	wire	wire_nllOOO_dataout;
	wire	wire_nlO10i_dataout;
	wire	wire_nlO10l_dataout;
	wire	wire_nlO10O_dataout;
	wire	wire_nlO11i_dataout;
	wire	wire_nlO11l_dataout;
	wire	wire_nlO11O_dataout;
	wire	wire_nlO1ii_dataout;
	wire	wire_nlO1il_dataout;
	wire	wire_nlO1iO_dataout;
	wire	wire_nlO1li_dataout;
	wire	wire_nlO1ll_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nO_dataout;
	wire  [4:0]   wire_niiOl_o;
	wire  [6:0]   wire_niO1lO_o;
	wire  [6:0]   wire_niO1Oi_o;
	wire  [7:0]   wire_niO1Ol_o;
	wire  [5:0]   wire_nlllOi_o;
	wire  [2:0]   wire_nlllOl_o;
	wire  [3:0]   wire_nllOil_o;
	wire  [8:0]   wire_nlO1lO_o;
	wire  [31:0]   wire_n100i_o;
	wire  [15:0]   wire_ni101l_o;
	wire  [15:0]   wire_nii0Ol_o;
	wire  [15:0]   wire_nl1OlO_o;
	wire  wire_n0OOOl_o;
	wire  wire_n101l_o;
	wire  wire_n110i_o;
	wire  wire_n110l_o;
	wire  wire_n111i_o;
	wire  wire_n111l_o;
	wire  wire_n11ii_o;
	wire  wire_n11li_o;
	wire  wire_n11lO_o;
	wire  wire_n11OO_o;
	wire  wire_ni0Oii_o;
	wire  wire_ni0Oli_o;
	wire  wire_ni0OOl_o;
	wire  wire_ni110i_o;
	wire  wire_ni110O_o;
	wire  wire_ni111i_o;
	wire  wire_ni111O_o;
	wire  wire_ni11il_o;
	wire  wire_ni11li_o;
	wire  wire_ni11lO_o;
	wire  wire_ni11Ol_o;
	wire  wire_nii00l_o;
	wire  wire_nii01i_o;
	wire  wire_nii01O_o;
	wire  wire_nii0ii_o;
	wire  wire_nii0iO_o;
	wire  wire_nii0lO_o;
	wire  wire_nii10l_o;
	wire  wire_nii11l_o;
	wire  wire_nii1il_o;
	wire  wire_nii1ll_o;
	wire  wire_nii1Oi_o;
	wire  wire_nii1OO_o;
	wire  wire_nl1lil_o;
	wire  wire_nl1O0l_o;
	wire  wire_nl1O1l_o;
	wire  wire_nl1O1O_o;
	wire  wire_nl1Oii_o;
	wire  wire_nl1Oil_o;
	wire  wire_nl1Oli_o;
	wire  wire_nlOOOl_o;
	wire  n00OOi;
	wire  n00OOl;
	wire  n00OOO;
	wire  n0i00i;
	wire  n0i00l;
	wire  n0i00O;
	wire  n0i01i;
	wire  n0i01l;
	wire  n0i01O;
	wire  n0i0ii;
	wire  n0i0il;
	wire  n0i0iO;
	wire  n0i0li;
	wire  n0i0ll;
	wire  n0i0lO;
	wire  n0i0Oi;
	wire  n0i0Ol;
	wire  n0i0OO;
	wire  n0i10i;
	wire  n0i10l;
	wire  n0i10O;
	wire  n0i11i;
	wire  n0i11l;
	wire  n0i11O;
	wire  n0i1ii;
	wire  n0i1il;
	wire  n0i1iO;
	wire  n0i1li;
	wire  n0i1ll;
	wire  n0i1lO;
	wire  n0i1Oi;
	wire  n0i1Ol;
	wire  n0i1OO;
	wire  n0ii0i;
	wire  n0ii0l;
	wire  n0ii0O;
	wire  n0ii1i;
	wire  n0ii1l;
	wire  n0ii1O;
	wire  n0iiii;
	wire  n0iiil;
	wire  n0iiiO;
	wire  n0iili;
	wire  n0iill;
	wire  n0iilO;
	wire  n0iiOi;
	wire  n0iiOl;
	wire  n0iiOO;
	wire  n0il0i;
	wire  n0il0l;
	wire  n0il0O;
	wire  n0il1i;
	wire  n0il1l;
	wire  n0il1O;
	wire  n0ilii;
	wire  n0ilil;
	wire  n0iliO;
	wire  n0illi;
	wire  n0illl;
	wire  n0illO;
	wire  n0ilOi;
	wire  n0ilOl;
	wire  n0ilOO;
	wire  n0iO0i;
	wire  n0iO0l;
	wire  n0iO0O;
	wire  n0iO1i;
	wire  n0iO1l;
	wire  n0iO1O;
	wire  n0iOii;
	wire  n0iOil;
	wire  n0iOiO;
	wire  n0iOli;
	wire  n0iOll;
	wire  n0iOlO;
	wire  n0iOOi;
	wire  n0iOOl;
	wire  n0iOOO;
	wire  n0l00i;
	wire  n0l00l;
	wire  n0l00O;
	wire  n0l01i;
	wire  n0l01l;
	wire  n0l01O;
	wire  n0l0ii;
	wire  n0l0il;
	wire  n0l0iO;
	wire  n0l0li;
	wire  n0l0ll;
	wire  n0l0lO;
	wire  n0l0Oi;
	wire  n0l0Ol;
	wire  n0l0OO;
	wire  n0l10i;
	wire  n0l10l;
	wire  n0l10O;
	wire  n0l11i;
	wire  n0l11l;
	wire  n0l11O;
	wire  n0l1ii;
	wire  n0l1il;
	wire  n0l1iO;
	wire  n0l1li;
	wire  n0l1ll;
	wire  n0l1lO;
	wire  n0l1Oi;
	wire  n0l1Ol;
	wire  n0l1OO;
	wire  n0li0i;
	wire  n0li0l;
	wire  n0li0O;
	wire  n0li1i;
	wire  n0li1l;
	wire  n0li1O;
	wire  n0liii;
	wire  n0liil;
	wire  n0liOO;
	wire  n0ll0l;
	wire  n0llil;
	wire  n0lliO;
	wire  n0llli;
	wire  n0llll;
	wire  n0lllO;
	wire  n0llOO;
	wire  n0lO0i;
	wire  n0lO0l;
	wire  n0lO0O;
	wire  n0lO1i;
	wire  n0lO1l;
	wire  n0lO1O;
	wire  n0lOii;
	wire  n0lOil;
	wire  n0lOiO;
	wire  n0lOli;
	wire  n0lOll;
	wire  n0lOlO;
	wire  n0lOOi;
	wire  n0lOOl;
	wire  n0lOOO;
	wire  n0O00O;
	wire  n0O0ii;
	wire  n0O0il;
	wire  n0O0iO;
	wire  n0O0li;
	wire  n0O10i;
	wire  n0O10l;
	wire  n0O10O;
	wire  n0O11i;
	wire  n0O1ii;
	wire  n0O1li;
	wire  n0O1ll;
	wire  n0O1lO;

	initial
		n0liiO58 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0liiO58 <= n0liiO60;
	initial
		n0liiO59 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0liiO59 <= (n0liiO60 ^ n0liiO58);
	initial
		n0liiO60 = 0;
	always @ ( posedge clk_2)
		  n0liiO60 <= n0liiO58;
	initial
		n0lili55 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0lili55 <= n0lili57;
	initial
		n0lili56 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0lili56 <= (n0lili57 ^ n0lili55);
	initial
		n0lili57 = 0;
	always @ ( posedge clk_2)
		  n0lili57 <= n0lili55;
	initial
		n0lill52 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0lill52 <= n0lill54;
	initial
		n0lill53 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0lill53 <= (n0lill54 ^ n0lill52);
	initial
		n0lill54 = 0;
	always @ ( posedge clk_2)
		  n0lill54 <= n0lill52;
	initial
		n0lilO49 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0lilO49 <= n0lilO51;
	initial
		n0lilO50 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0lilO50 <= (n0lilO51 ^ n0lilO49);
	initial
		n0lilO51 = 0;
	always @ ( posedge clk_2)
		  n0lilO51 <= n0lilO49;
	initial
		n0liOi46 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0liOi46 <= n0liOi48;
	initial
		n0liOi47 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0liOi47 <= (n0liOi48 ^ n0liOi46);
	initial
		n0liOi48 = 0;
	always @ ( posedge clk_2)
		  n0liOi48 <= n0liOi46;
	initial
		n0liOl43 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0liOl43 <= n0liOl45;
	initial
		n0liOl44 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0liOl44 <= (n0liOl45 ^ n0liOl43);
	initial
		n0liOl45 = 0;
	always @ ( posedge clk_2)
		  n0liOl45 <= n0liOl43;
	initial
		n0ll0i34 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0ll0i34 <= n0ll0i36;
	initial
		n0ll0i35 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0ll0i35 <= (n0ll0i36 ^ n0ll0i34);
	initial
		n0ll0i36 = 0;
	always @ ( posedge clk_2)
		  n0ll0i36 <= n0ll0i34;
	initial
		n0ll0O31 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0ll0O31 <= n0ll0O33;
	initial
		n0ll0O32 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0ll0O32 <= (n0ll0O33 ^ n0ll0O31);
	initial
		n0ll0O33 = 0;
	always @ ( posedge clk_2)
		  n0ll0O33 <= n0ll0O31;
	initial
		n0ll1i40 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0ll1i40 <= n0ll1i42;
	initial
		n0ll1i41 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0ll1i41 <= (n0ll1i42 ^ n0ll1i40);
	initial
		n0ll1i42 = 0;
	always @ ( posedge clk_2)
		  n0ll1i42 <= n0ll1i40;
	initial
		n0ll1O37 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0ll1O37 <= n0ll1O39;
	initial
		n0ll1O38 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0ll1O38 <= (n0ll1O39 ^ n0ll1O37);
	initial
		n0ll1O39 = 0;
	always @ ( posedge clk_2)
		  n0ll1O39 <= n0ll1O37;
	initial
		n0llOi28 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0llOi28 <= n0llOi30;
	initial
		n0llOi29 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0llOi29 <= (n0llOi30 ^ n0llOi28);
	initial
		n0llOi30 = 0;
	always @ ( posedge clk_2)
		  n0llOi30 <= n0llOi28;
	initial
		n0O00i10 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O00i10 <= n0O00i12;
	initial
		n0O00i11 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O00i11 <= (n0O00i12 ^ n0O00i10);
	initial
		n0O00i12 = 0;
	always @ ( posedge clk_2)
		  n0O00i12 <= n0O00i10;
	initial
		n0O01l13 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O01l13 <= n0O01l15;
	initial
		n0O01l14 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O01l14 <= (n0O01l15 ^ n0O01l13);
	initial
		n0O01l15 = 0;
	always @ ( posedge clk_2)
		  n0O01l15 <= n0O01l13;
	initial
		n0O0ll7 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O0ll7 <= n0O0ll9;
	initial
		n0O0ll8 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O0ll8 <= (n0O0ll9 ^ n0O0ll7);
	initial
		n0O0ll9 = 0;
	always @ ( posedge clk_2)
		  n0O0ll9 <= n0O0ll7;
	initial
		n0O0Oi4 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O0Oi4 <= n0O0Oi6;
	initial
		n0O0Oi5 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O0Oi5 <= (n0O0Oi6 ^ n0O0Oi4);
	initial
		n0O0Oi6 = 0;
	always @ ( posedge clk_2)
		  n0O0Oi6 <= n0O0Oi4;
	initial
		n0O0OO1 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O0OO1 <= n0O0OO3;
	initial
		n0O0OO2 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O0OO2 <= (n0O0OO3 ^ n0O0OO1);
	initial
		n0O0OO3 = 0;
	always @ ( posedge clk_2)
		  n0O0OO3 <= n0O0OO1;
	initial
		n0O11l25 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O11l25 <= n0O11l27;
	initial
		n0O11l26 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O11l26 <= (n0O11l27 ^ n0O11l25);
	initial
		n0O11l27 = 0;
	always @ ( posedge clk_2)
		  n0O11l27 <= n0O11l25;
	initial
		n0O1il22 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O1il22 <= n0O1il24;
	initial
		n0O1il23 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O1il23 <= (n0O1il24 ^ n0O1il22);
	initial
		n0O1il24 = 0;
	always @ ( posedge clk_2)
		  n0O1il24 <= n0O1il22;
	initial
		n0O1Oi19 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O1Oi19 <= n0O1Oi21;
	initial
		n0O1Oi20 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O1Oi20 <= (n0O1Oi21 ^ n0O1Oi19);
	initial
		n0O1Oi21 = 0;
	always @ ( posedge clk_2)
		  n0O1Oi21 <= n0O1Oi19;
	initial
		n0O1OO16 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O1OO16 <= n0O1OO18;
	initial
		n0O1OO17 = {1{1'b1}};
	always @ ( posedge clk_2)
		  n0O1OO17 <= (n0O1OO18 ^ n0O1OO16);
	initial
		n0O1OO18 = 0;
	always @ ( posedge clk_2)
		  n0O1OO18 <= n0O1OO16;
	initial
	begin
		ni00l = 0;
		ni01O = 0;
		nii0OO = 0;
		niii0i = 0;
		niii0l = 0;
		niii0O = 0;
		niii1i = 0;
		niii1l = 0;
		niii1O = 0;
		niiiii = 0;
		niiiil = 0;
		niiiiO = 0;
		niiili = 0;
		niiill = 0;
		niiilO = 0;
		niiiOi = 0;
		niiiOl = 0;
		niiiOO = 0;
		niil1i = 0;
		niil1l = 0;
		niil1O = 0;
		niilii = 0;
		niilil = 0;
		nll1Oi = 0;
		nll1Ol = 0;
	end
	always @ ( posedge clk_2 or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			ni00l <= 0;
			ni01O <= 0;
			nii0OO <= 0;
			niii0i <= 0;
			niii0l <= 0;
			niii0O <= 0;
			niii1i <= 0;
			niii1l <= 0;
			niii1O <= 0;
			niiiii <= 0;
			niiiil <= 0;
			niiiiO <= 0;
			niiili <= 0;
			niiill <= 0;
			niiilO <= 0;
			niiiOi <= 0;
			niiiOl <= 0;
			niiiOO <= 0;
			niil1i <= 0;
			niil1l <= 0;
			niil1O <= 0;
			niilii <= 0;
			niilil <= 0;
			nll1Oi <= 0;
			nll1Ol <= 0;
		end
		else 
		begin
			ni00l <= wire_nii1O_dataout;
			ni01O <= wire_nii1l_dataout;
			nii0OO <= wire_nil1il_dataout;
			niii0i <= wire_nil1lO_dataout;
			niii0l <= wire_nil1Oi_dataout;
			niii0O <= wire_nil1Ol_dataout;
			niii1i <= wire_nil1iO_dataout;
			niii1l <= wire_nil1li_dataout;
			niii1O <= wire_nil1ll_dataout;
			niiiii <= wire_nil1OO_dataout;
			niiiil <= wire_nil01i_dataout;
			niiiiO <= wire_nil01l_dataout;
			niiili <= wire_nil01O_dataout;
			niiill <= wire_nil00i_dataout;
			niiilO <= wire_nil00l_dataout;
			niiiOi <= wire_nil00O_dataout;
			niiiOl <= wire_nil0ii_dataout;
			niiiOO <= wire_nil0il_dataout;
			niil1i <= wire_nil0iO_dataout;
			niil1l <= wire_nil0li_dataout;
			niil1O <= wire_nil0ll_dataout;
			niilii <= wire_nil0lO_dataout;
			niilil <= wire_nil0Oi_dataout;
			nll1Oi <= wire_nlliOl_dataout;
			nll1Ol <= wire_nlliOO_dataout;
		end
	end
	initial
	begin
		n0OOOi = 0;
		ni00O = 0;
		ni01i = 0;
		ni01l = 0;
		ni0ii = 0;
		ni0il = 0;
		ni0iO = 0;
		ni0li = 0;
		ni0ll = 0;
		ni0lO = 0;
		ni0Oi = 0;
		ni0Ol = 0;
		nii1i = 0;
		niil0i = 0;
		niil0l = 0;
		niil0O = 0;
		niiliO = 0;
		niilli = 0;
		niilll = 0;
		niillO = 0;
		niilOi = 0;
		niilOl = 0;
		niilOO = 0;
		niiO0i = 0;
		niiO0l = 0;
		niiO0O = 0;
		niiO1i = 0;
		niiO1l = 0;
		niiO1O = 0;
		niiOii = 0;
		niiOil = 0;
		niiOiO = 0;
		niiOli = 0;
		niiOll = 0;
		niiOlO = 0;
		niiOOi = 0;
		niiOOl = 0;
		niiOOO = 0;
		nil10i = 0;
		nil10l = 0;
		nil10O = 0;
		nil11i = 0;
		nil11l = 0;
		nil11O = 0;
		nil1ii = 0;
		nl1lii = 0;
		nll00i = 0;
		nll00l = 0;
		nll00O = 0;
		nll01i = 0;
		nll01l = 0;
		nll01O = 0;
		nll0Oi = 0;
		nll0Ol = 0;
		nll0OO = 0;
		nll1ll = 0;
		nll1lO = 0;
		nll1OO = 0;
		nlli0i = 0;
		nlli0l = 0;
		nlli0O = 0;
		nlli1i = 0;
		nlli1l = 0;
		nlli1O = 0;
		nlliii = 0;
		nlliil = 0;
		nlliiO = 0;
		nllili = 0;
		nllill = 0;
		nllilO = 0;
		nlliOi = 0;
		nlOOOi = 0;
	end
	always @ ( posedge clk_2 or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n0OOOi <= 0;
			ni00O <= 0;
			ni01i <= 0;
			ni01l <= 0;
			ni0ii <= 0;
			ni0il <= 0;
			ni0iO <= 0;
			ni0li <= 0;
			ni0ll <= 0;
			ni0lO <= 0;
			ni0Oi <= 0;
			ni0Ol <= 0;
			nii1i <= 0;
			niil0i <= 0;
			niil0l <= 0;
			niil0O <= 0;
			niiliO <= 0;
			niilli <= 0;
			niilll <= 0;
			niillO <= 0;
			niilOi <= 0;
			niilOl <= 0;
			niilOO <= 0;
			niiO0i <= 0;
			niiO0l <= 0;
			niiO0O <= 0;
			niiO1i <= 0;
			niiO1l <= 0;
			niiO1O <= 0;
			niiOii <= 0;
			niiOil <= 0;
			niiOiO <= 0;
			niiOli <= 0;
			niiOll <= 0;
			niiOlO <= 0;
			niiOOi <= 0;
			niiOOl <= 0;
			niiOOO <= 0;
			nil10i <= 0;
			nil10l <= 0;
			nil10O <= 0;
			nil11i <= 0;
			nil11l <= 0;
			nil11O <= 0;
			nil1ii <= 0;
			nl1lii <= 0;
			nll00i <= 0;
			nll00l <= 0;
			nll00O <= 0;
			nll01i <= 0;
			nll01l <= 0;
			nll01O <= 0;
			nll0Oi <= 0;
			nll0Ol <= 0;
			nll0OO <= 0;
			nll1ll <= 0;
			nll1lO <= 0;
			nll1OO <= 0;
			nlli0i <= 0;
			nlli0l <= 0;
			nlli0O <= 0;
			nlli1i <= 0;
			nlli1l <= 0;
			nlli1O <= 0;
			nlliii <= 0;
			nlliil <= 0;
			nlliiO <= 0;
			nllili <= 0;
			nllill <= 0;
			nllilO <= 0;
			nlliOi <= 0;
			nlOOOi <= 0;
		end
		else if  (rbist_clr_rx == 1'b0) 
		begin
			n0OOOi <= wire_ni11Ol_o;
			ni00O <= wire_nlOOOl_o;
			ni01i <= ni01l;
			ni01l <= sync_status;
			ni0ii <= wire_nii0i_dataout;
			ni0il <= wire_nii0l_dataout;
			ni0iO <= wire_nii0O_dataout;
			ni0li <= wire_niiii_dataout;
			ni0ll <= wire_niiil_dataout;
			ni0lO <= wire_n11ii_o;
			ni0Oi <= wire_n11li_o;
			ni0Ol <= wire_n11lO_o;
			nii1i <= wire_n11OO_o;
			niil0i <= niil0l;
			niil0l <= sync_status;
			niil0O <= wire_n0OOOl_o;
			niiliO <= wire_nilOlO_dataout;
			niilli <= wire_nilOOi_dataout;
			niilll <= wire_nilOOl_dataout;
			niillO <= wire_nilOOO_dataout;
			niilOi <= wire_niO11i_dataout;
			niilOl <= wire_niO11l_dataout;
			niilOO <= wire_niO11O_dataout;
			niiO0i <= wire_nilOil_dataout;
			niiO0l <= wire_nilOiO_dataout;
			niiO0O <= wire_nilOli_dataout;
			niiO1i <= wire_nilO0l_dataout;
			niiO1l <= wire_nilO0O_dataout;
			niiO1O <= wire_nilOii_dataout;
			niiOii <= wire_nilOll_dataout;
			niiOil <= wire_niO10i_dataout;
			niiOiO <= wire_niO10l_dataout;
			niiOli <= wire_niO10O_dataout;
			niiOll <= wire_niO1ii_dataout;
			niiOlO <= wire_niO1il_dataout;
			niiOOi <= wire_niO1iO_dataout;
			niiOOl <= wire_niO1li_dataout;
			niiOOO <= wire_niO1ll_dataout;
			nil10i <= n0OOOi;
			nil10l <= wire_ni11il_o;
			nil10O <= wire_ni11li_o;
			nil11i <= nil10l;
			nil11l <= nil10O;
			nil11O <= nil1ii;
			nil1ii <= wire_ni11lO_o;
			nl1lii <= wire_nl1Oli_o;
			nll00i <= wire_nlll0i_dataout;
			nll00l <= wire_nlll0l_dataout;
			nll00O <= wire_nlll0O_dataout;
			nll01i <= wire_nlll1i_dataout;
			nll01l <= wire_nlll1l_dataout;
			nll01O <= wire_nlll1O_dataout;
			nll0Oi <= wire_nlllOO_dataout;
			nll0Ol <= wire_nllO1i_dataout;
			nll0OO <= wire_nllO1l_dataout;
			nll1ll <= nll1lO;
			nll1lO <= sync_status;
			nll1OO <= wire_nl1lil_o;
			nlli0i <= wire_nllOll_dataout;
			nlli0l <= wire_nllOlO_dataout;
			nlli0O <= wire_nllOOi_dataout;
			nlli1i <= wire_nllO1O_dataout;
			nlli1l <= wire_nllOiO_dataout;
			nlli1O <= wire_nllOli_dataout;
			nlliii <= wire_nllOOl_dataout;
			nlliil <= wire_nllOOO_dataout;
			nlliiO <= wire_nlO11i_dataout;
			nllili <= wire_nlO11l_dataout;
			nllill <= wire_nl1O0l_o;
			nllilO <= wire_nl1Oii_o;
			nlliOi <= wire_nl1Oil_o;
			nlOOOi <= wire_n101l_o;
		end
	end
	initial
	begin
		nll0il = 0;
	end
	always @ ( posedge clk_2 or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			nll0il <= 0;
		end
		else if  (wire_nll0ii_ENA == 1'b1) 
		begin
			nll0il <= wire_nlllOl_o[0];
		end
	end
	assign
		wire_nll0ii_ENA = ((~ rbist_clr_rx) & wire_nl1llO_dataout);
	initial
	begin
		nll0li = 0;
	end
	always @ ( posedge clk_2 or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			nll0li <= 0;
		end
		else if  (wire_nll0iO_ENA == 1'b1) 
		begin
			nll0li <= wire_nlllOl_o[1];
		end
	end
	assign
		wire_nll0iO_ENA = ((~ rbist_clr_rx) & wire_nl1llO_dataout);
	initial
	begin
		nll0lO = 0;
	end
	always @ ( posedge clk_2 or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			nll0lO <= 0;
		end
		else if  (wire_nll0ll_ENA == 1'b1) 
		begin
			nll0lO <= wire_nlllOl_o[2];
		end
	end
	assign
		wire_nll0ll_ENA = ((~ rbist_clr_rx) & wire_nl1llO_dataout);
	or(wire_n000i_dataout, ni01O, (~ n0lO1l));
	or(wire_n000l_dataout, ni00l, (~ n0lO1l));
	or(wire_n000O_dataout, wire_n00lO_dataout, (~ n0lO1l));
	or(wire_n001i_dataout, nlOOOi, n0lOOO);
	and(wire_n001l_dataout, wire_n00ll_dataout, ~{(~ n0lO1l)});
	and(wire_n001O_dataout, wire_n0i1l_dataout, ~{(~ n0lO1l)});
	assign		wire_n00i_dataout = (n0O0ii === 1'b1) ? nl1lii : wire_n0iO_dataout;
	and(wire_n00ii_dataout, wire_n00Oi_dataout, ~{(~ n0lO1l)});
	or(wire_n00il_dataout, wire_n00Ol_dataout, (~ n0lO1l));
	and(wire_n00iO_dataout, wire_n00OO_dataout, ~{(~ n0lO1l)});
	and(wire_n00l_dataout, wire_n0li_dataout, ~{n0O0ii});
	or(wire_n00li_dataout, wire_n0i1i_dataout, (~ n0lO1l));
	and(wire_n00ll_dataout, (~ n0lO1O), n0O0iO);
	or(wire_n00lO_dataout, wire_n1Oii_dataout, ~{n0O0iO});
	and(wire_n00O_dataout, ni0lO, n0O0il);
	or(wire_n00Oi_dataout, wire_n1Oil_dataout, ~{n0O0iO});
	or(wire_n00Ol_dataout, wire_n1OiO_dataout, ~{n0O0iO});
	or(wire_n00OO_dataout, wire_n1Oli_dataout, ~{n0O0iO});
	and(wire_n010i_dataout, wire_n01iO_dataout, ~{n0O10l});
	and(wire_n010l_dataout, wire_n01li_dataout, ~{n0O10l});
	or(wire_n010O_dataout, wire_n01ll_dataout, n0O10l);
	or(wire_n011i_dataout, wire_n010O_dataout, n0O1li);
	or(wire_n011l_dataout, wire_n01ii_dataout, n0O10l);
	and(wire_n011O_dataout, wire_n01il_dataout, ~{n0O10l});
	assign		wire_n01i_dataout = (n0O0ii === 1'b1) ? nllill : wire_n00O_dataout;
	and(wire_n01ii_dataout, wire_n01lO_dataout, ~{n0O10i});
	or(wire_n01il_dataout, wire_n01Oi_dataout, n0O10i);
	and(wire_n01iO_dataout, wire_n01Ol_dataout, ~{n0O10i});
	assign		wire_n01l_dataout = (n0O0ii === 1'b1) ? nllilO : wire_n0ii_dataout;
	and(wire_n01li_dataout, wire_n01OO_dataout, ~{n0O10i});
	or(wire_n01ll_dataout, wire_n001i_dataout, n0O10i);
	or(wire_n01lO_dataout, ni0lO, n0lOOO);
	assign		wire_n01O_dataout = (n0O0ii === 1'b1) ? nlliOi : wire_n0il_dataout;
	or(wire_n01Oi_dataout, ni0Oi, n0lOOO);
	and(wire_n01Ol_dataout, ni0Ol, ~{n0lOOO});
	and(wire_n01OO_dataout, nii1i, ~{n0lOOO});
	assign		wire_n0i_dataout = (n0O0li === 1'b1) ? rxd[33] : rxd[17];
	or(wire_n0i0i_dataout, ni00l, (~ n0lO0i));
	or(wire_n0i0l_dataout, ni01O, (~ n0lO0l));
	or(wire_n0i0O_dataout, ni00l, (~ n0lO0l));
	and(wire_n0i1i_dataout, wire_n1Oll_dataout, n0O0iO);
	and(wire_n0i1l_dataout, n0lO1O, n0O0iO);
	or(wire_n0i1O_dataout, ni01O, (~ n0lO0i));
	and(wire_n0ii_dataout, ni0Oi, n0O0il);
	or(wire_n0iii_dataout, (~ n0O0iO), (~ n0lO0l));
	and(wire_n0iil_dataout, n0O0iO, ~{(~ n0lO0l)});
	or(wire_n0iiO_dataout, ni01O, (~ n0lO0O));
	and(wire_n0il_dataout, ni0Ol, n0O0il);
	or(wire_n0ili_dataout, ni00l, (~ n0lO0O));
	or(wire_n0ill_dataout, ni01O, (~ n0lOii));
	or(wire_n0ilO_dataout, ni00l, (~ n0lOii));
	and(wire_n0iO_dataout, nii1i, n0O0il);
	or(wire_n0iOi_dataout, (~ n0O0iO), (~ n0lOii));
	and(wire_n0iOl_dataout, (~ n0O0iO), ~{(~ n0lOii)});
	or(wire_n0iOO_dataout, n0O0iO, (~ n0lOii));
	assign		wire_n0l_dataout = (n0O0li === 1'b1) ? rxd[34] : rxd[18];
	or(wire_n0l0i_dataout, ni00l, (~ n0lOiO));
	or(wire_n0l0l_dataout, (~ n0O0iO), (~ n0lOiO));
	and(wire_n0l0O_dataout, n0O0iO, ~{(~ n0lOiO)});
	or(wire_n0l1i_dataout, ni01O, (~ n0lOil));
	or(wire_n0l1l_dataout, ni00l, (~ n0lOil));
	or(wire_n0l1O_dataout, ni01O, (~ n0lOiO));
	and(wire_n0li_dataout, nlOOOi, n0O0il);
	or(wire_n0lii_dataout, ni01O, (~ n0lOli));
	or(wire_n0lil_dataout, ni00l, (~ n0lOli));
	or(wire_n0liO_dataout, ni01O, (~ n0lOll));
	or(wire_n0lli_dataout, ni00l, (~ n0lOll));
	and(wire_n0lll_dataout, (~ n0O0iO), ~{(~ n0lOll)});
	or(wire_n0llO_dataout, (~ n0O0iO), (~ n0lOll));
	and(wire_n0lOi_dataout, n0O0iO, ~{(~ n0lOll)});
	or(wire_n0lOl_dataout, ni01O, (~ n0lOlO));
	or(wire_n0lOO_dataout, ni00l, (~ n0lOlO));
	assign		wire_n0O_dataout = (n0O0li === 1'b1) ? rxd[35] : rxd[19];
	and(wire_n0O0i_dataout, n0O0iO, ~{(~ n0lOOi)});
	and(wire_n0O0l_dataout, ni0lO, ~{(~ n0lOOO)});
	and(wire_n0O0O_dataout, ni0Oi, ~{(~ n0lOOO)});
	or(wire_n0O1i_dataout, ni01O, (~ n0lOOi));
	or(wire_n0O1l_dataout, ni00l, (~ n0lOOi));
	or(wire_n0O1O_dataout, (~ n0O0iO), (~ n0lOOi));
	and(wire_n0Oi_dataout, nii0OO, n0O00O);
	or(wire_n0Oii_dataout, ni0Ol, (~ n0lOOO));
	and(wire_n0Oil_dataout, nii1i, ~{(~ n0lOOO)});
	and(wire_n0OiO_dataout, nlOOOi, ~{(~ n0lOOO)});
	and(wire_n0Ol_dataout, niii1i, n0O00O);
	and(wire_n0Oli_dataout, wire_n0OOO_dataout, ~{n0O1ii});
	assign		wire_n0Oll_dataout = (n0O1ii === 1'b1) ? (~ n0O0iO) : wire_ni11i_dataout;
	assign		wire_n0OlO_dataout = (n0O1ii === 1'b1) ? n0O0iO : wire_ni11l_dataout;
	and(wire_n0OO_dataout, niii1l, n0O00O);
	and(wire_n0OOi_dataout, wire_ni11O_dataout, ~{n0O1ii});
	and(wire_n0OOl_dataout, wire_ni10i_dataout, ~{n0O1ii});
	and(wire_n0OOO_dataout, wire_ni10l_dataout, ~{n0O11i});
	and(wire_n100l_dataout, ni00l, ~{(~ wire_ni_dataout)});
	and(wire_n100O_dataout, ni01O, ~{(~ wire_ni_dataout)});
	and(wire_n10ii_dataout, ni0lO, ~{(~ wire_ni_dataout)});
	and(wire_n10il_dataout, ni0Oi, ~{(~ wire_ni_dataout)});
	and(wire_n10iO_dataout, ni0Ol, ~{(~ wire_ni_dataout)});
	and(wire_n10li_dataout, nii1i, ~{(~ wire_ni_dataout)});
	and(wire_n10ll_dataout, nlOOOi, ~{(~ wire_ni_dataout)});
	assign		wire_n10lO_dataout = (n0ll0l === 1'b1) ? ni00O : wire_n1i1i_dataout;
	or(wire_n10Oi_dataout, wire_n1i1l_dataout, n0ll0l);
	or(wire_n10Ol_dataout, ni00l, n0ll0l);
	or(wire_n10OO_dataout, ni00O, n0ll0l);
	assign		wire_n1i0i_dataout = ((~ n0lliO) === 1'b1) ? ni00O : wire_n1i1i_dataout;
	or(wire_n1i0l_dataout, wire_n1i1l_dataout, (~ n0lliO));
	or(wire_n1i0O_dataout, ni00l, (~ n0lliO));
	assign		wire_n1i1i_dataout = (ni00O === 1'b1) ? ni00O : (~ ni00O);
	or(wire_n1i1l_dataout, ni01O, ni00O);
	or(wire_n1iii_dataout, ni00O, (~ n0lliO));
	assign		wire_n1iil_dataout = ((~ n0llli) === 1'b1) ? ni00O : wire_n1i1i_dataout;
	or(wire_n1iiO_dataout, wire_n1i1l_dataout, (~ n0llli));
	or(wire_n1ili_dataout, ni00l, (~ n0llli));
	or(wire_n1ill_dataout, ni00O, (~ n0llli));
	assign		wire_n1ilO_dataout = ((~ n0llll) === 1'b1) ? ni00O : wire_n1i1i_dataout;
	or(wire_n1iOi_dataout, wire_n1i1l_dataout, (~ n0llll));
	or(wire_n1iOl_dataout, ni00l, (~ n0llll));
	or(wire_n1iOO_dataout, ni00O, (~ n0llll));
	assign		wire_n1l_dataout = (n0O0li === 1'b1) ? rxc[2] : rxc[1];
	or(wire_n1l0i_dataout, (~ n0llOO), n0O0iO);
	or(wire_n1l0l_dataout, wire_n1lll_dataout, ~{n0O0iO});
	or(wire_n1l0O_dataout, ni01O, (~ n0llOO));
	assign		wire_n1l1i_dataout = (n0O0iO === 1'b1) ? wire_n1lil_dataout : ni00O;
	assign		wire_n1l1l_dataout = (n0O0iO === 1'b1) ? wire_n1liO_dataout : wire_n1l0O_dataout;
	assign		wire_n1l1O_dataout = (n0O0iO === 1'b1) ? wire_n1lli_dataout : wire_n1lii_dataout;
	or(wire_n1lii_dataout, ni00l, (~ n0llOO));
	assign		wire_n1lil_dataout = (n0lllO === 1'b1) ? ni00O : wire_n1i1i_dataout;
	or(wire_n1liO_dataout, wire_n1i1l_dataout, n0lllO);
	assign		wire_n1ll_dataout = (n0O00O === 1'b1) ? nil10l : wire_n01i_dataout;
	or(wire_n1lli_dataout, ni00l, n0lllO);
	or(wire_n1lll_dataout, ni00O, n0lllO);
	assign		wire_n1lO_dataout = (n0O00O === 1'b1) ? nil10O : wire_n01l_dataout;
	and(wire_n1lOi_dataout, (~ n0lO1O), ~{(~ n0lO1i)});
	and(wire_n1lOl_dataout, n0lO1O, ~{(~ n0lO1i)});
	or(wire_n1lOO_dataout, ni01O, (~ n0lO1i));
	assign		wire_n1O_dataout = (n0O0li === 1'b1) ? rxd[32] : rxd[16];
	or(wire_n1O0i_dataout, wire_n1OiO_dataout, (~ n0lO1i));
	and(wire_n1O0l_dataout, wire_n1Oli_dataout, ~{(~ n0lO1i)});
	or(wire_n1O0O_dataout, wire_n1Oll_dataout, (~ n0lO1i));
	or(wire_n1O1i_dataout, ni00l, (~ n0lO1i));
	or(wire_n1O1l_dataout, wire_n1Oii_dataout, (~ n0lO1i));
	and(wire_n1O1O_dataout, wire_n1Oil_dataout, ~{(~ n0lO1i)});
	assign		wire_n1Oi_dataout = (n0O00O === 1'b1) ? nil1ii : wire_n01O_dataout;
	and(wire_n1Oii_dataout, wire_n1OlO_dataout, n0lO1O);
	and(wire_n1Oil_dataout, wire_n1OOi_dataout, n0lO1O);
	or(wire_n1OiO_dataout, wire_n1OOl_dataout, ~{n0lO1O});
	assign		wire_n1Ol_dataout = (n0O00O === 1'b1) ? n0OOOi : wire_n00i_dataout;
	and(wire_n1Oli_dataout, wire_n1OOO_dataout, n0lO1O);
	and(wire_n1Oll_dataout, wire_n011i_dataout, n0lO1O);
	and(wire_n1OlO_dataout, wire_n011l_dataout, ~{n0O1li});
	and(wire_n1OO_dataout, wire_n00l_dataout, ~{n0O00O});
	and(wire_n1OOi_dataout, wire_n011O_dataout, ~{n0O1li});
	and(wire_n1OOl_dataout, wire_n010i_dataout, ~{n0O1li});
	and(wire_n1OOO_dataout, wire_n010l_dataout, ~{n0O1li});
	and(wire_ni_dataout, rbisten_rx, (((~ rbist_sel[0]) & rbist_sel[1]) & n0O0Oi5));
	or(wire_ni000i_dataout, niilii, n0ii1i);
	or(wire_ni000l_dataout, niilil, n0ii1i);
	assign		wire_ni001i_dataout = (n0O0iO === 1'b1) ? wire_ni00il_dataout : wire_ni000l_dataout;
	or(wire_ni001l_dataout, n0ii1i, n0O0iO);
	assign		wire_ni001O_dataout = (n0O0iO === 1'b1) ? n0ii0i : n0ii1i;
	or(wire_ni00ii_dataout, niilii, n0ii0i);
	or(wire_ni00il_dataout, niilil, n0ii0i);
	or(wire_ni00li_dataout, niilii, n0iili);
	or(wire_ni00ll_dataout, niilil, n0iili);
	or(wire_ni00lO_dataout, wire_ni0i1i_dataout, n0iili);
	and(wire_ni00Oi_dataout, wire_ni0i1l_dataout, ~{n0iili});
	or(wire_ni00Ol_dataout, wire_ni0i1O_dataout, n0iili);
	or(wire_ni00OO_dataout, wire_ni0i0i_dataout, n0iili);
	assign		wire_ni010i_dataout = (n0O0iO === 1'b1) ? (~ n0i0lO) : (~ n0i0li);
	assign		wire_ni010l_dataout = (n0O0iO === 1'b1) ? n0i0lO : n0i0li;
	or(wire_ni010O_dataout, niilii, n0i0li);
	assign		wire_ni011i_dataout = (n0O0iO === 1'b1) ? wire_ni01iO_dataout : wire_ni010O_dataout;
	assign		wire_ni011l_dataout = (n0O0iO === 1'b1) ? wire_ni01li_dataout : wire_ni01ii_dataout;
	or(wire_ni011O_dataout, n0i0li, n0O0iO);
	or(wire_ni01ii_dataout, niilil, n0i0li);
	or(wire_ni01iO_dataout, niilii, n0i0lO);
	or(wire_ni01li_dataout, niilil, n0i0lO);
	or(wire_ni01lO_dataout, niilii, n0i0Ol);
	or(wire_ni01Oi_dataout, niilil, n0i0Ol);
	assign		wire_ni01OO_dataout = (n0O0iO === 1'b1) ? wire_ni00ii_dataout : wire_ni000i_dataout;
	and(wire_ni0i_dataout, niii0O, n0O00O);
	and(wire_ni0i0i_dataout, wire_ni0iil_dataout, ~{n0iiil});
	or(wire_ni0i0l_dataout, nil10l, n0iiii);
	or(wire_ni0i0O_dataout, nil10O, n0iiii);
	or(wire_ni0i1i_dataout, wire_ni0i0l_dataout, n0iiil);
	or(wire_ni0i1l_dataout, wire_ni0i0O_dataout, n0iiil);
	and(wire_ni0i1O_dataout, wire_ni0iii_dataout, ~{n0iiil});
	and(wire_ni0iii_dataout, nil1ii, ~{n0iiii});
	and(wire_ni0iil_dataout, n0OOOi, ~{n0iiii});
	or(wire_ni0ill_dataout, wire_ni0l1O_dataout, n0il1i);
	or(wire_ni0ilO_dataout, niilii, n0il1i);
	or(wire_ni0iOi_dataout, niilil, n0il1i);
	or(wire_ni0iOl_dataout, wire_ni0l0i_dataout, n0il1i);
	and(wire_ni0iOO_dataout, wire_ni0l0l_dataout, ~{n0il1i});
	and(wire_ni0l_dataout, niiiii, n0O00O);
	and(wire_ni0l0i_dataout, wire_ni0lil_dataout, ~{n0iiOl});
	or(wire_ni0l0l_dataout, wire_ni0liO_dataout, n0iiOl);
	and(wire_ni0l0O_dataout, wire_ni0lli_dataout, ~{n0iiOl});
	or(wire_ni0l1i_dataout, wire_ni0l0O_dataout, n0il1i);
	or(wire_ni0l1l_dataout, wire_ni0lii_dataout, n0il1i);
	and(wire_ni0l1O_dataout, (~ n0iilO), ~{n0iiOl});
	and(wire_ni0lii_dataout, wire_ni0lll_dataout, ~{n0iiOl});
	and(wire_ni0lil_dataout, nil10l, ~{n0iilO});
	or(wire_ni0liO_dataout, nil10O, n0iilO);
	and(wire_ni0lli_dataout, nil1ii, ~{n0iilO});
	and(wire_ni0lll_dataout, n0OOOi, ~{n0iilO});
	and(wire_ni0O_dataout, niiiil, n0O00O);
	and(wire_ni0O0i_dataout, nil1ii, ~{n0il1l});
	and(wire_ni0O0l_dataout, n0OOOi, ~{n0il1l});
	or(wire_ni0O1l_dataout, nil10l, n0il1l);
	and(wire_ni0O1O_dataout, nil10O, ~{n0il1l});
	or(wire_ni0OOi_dataout, wire_niO01l_dataout, ~{wire_nii0Ol_o[2]});
	and(wire_ni100i_dataout, niilii, ~{(~ wire_nO_dataout)});
	and(wire_ni100l_dataout, niilil, ~{(~ wire_nO_dataout)});
	and(wire_ni100O_dataout, nil10l, ~{(~ wire_nO_dataout)});
	and(wire_ni101O_dataout, niil0O, ~{(~ wire_nO_dataout)});
	and(wire_ni10i_dataout, wire_ni1iO_dataout, ~{n0O11i});
	and(wire_ni10ii_dataout, nil10O, ~{(~ wire_nO_dataout)});
	and(wire_ni10il_dataout, nil1ii, ~{(~ wire_nO_dataout)});
	and(wire_ni10iO_dataout, n0OOOi, ~{(~ wire_nO_dataout)});
	assign		wire_ni10l_dataout = (n0lOOl === 1'b1) ? (~ n0O0iO) : ni0lO;
	assign		wire_ni10li_dataout = (n0i10l === 1'b1) ? niil0O : wire_ni10Ol_dataout;
	or(wire_ni10ll_dataout, niilii, n0i10l);
	or(wire_ni10lO_dataout, wire_ni10OO_dataout, n0i10l);
	assign		wire_ni10O_dataout = (n0lOOl === 1'b1) ? (~ n0O0iO) : ni0Oi;
	or(wire_ni10Oi_dataout, niil0O, n0i10l);
	assign		wire_ni10Ol_dataout = (niil0O === 1'b1) ? niil0O : (~ niil0O);
	or(wire_ni10OO_dataout, niilil, niil0O);
	assign		wire_ni11i_dataout = (n0O11i === 1'b1) ? (~ n0O0iO) : wire_ni10O_dataout;
	assign		wire_ni11l_dataout = (n0O11i === 1'b1) ? n0O0iO : wire_ni1ii_dataout;
	and(wire_ni11O_dataout, wire_ni1il_dataout, ~{n0O11i});
	and(wire_ni1i_dataout, niii1O, n0O00O);
	assign		wire_ni1i0i_dataout = (n0O0iO === 1'b1) ? wire_ni1ilO_dataout : wire_ni1iil_dataout;
	assign		wire_ni1i0l_dataout = (n0O0iO === 1'b1) ? wire_ni1iOi_dataout : wire_ni1iiO_dataout;
	or(wire_ni1i0O_dataout, n0i1ii, n0O0iO);
	assign		wire_ni1i1l_dataout = (n0O0iO === 1'b1) ? wire_ni1ill_dataout : niil0O;
	assign		wire_ni1i1O_dataout = (n0O0iO === 1'b1) ? n0i1iO : n0i1ii;
	assign		wire_ni1ii_dataout = (n0lOOl === 1'b1) ? n0O0iO : ni0Ol;
	or(wire_ni1iii_dataout, wire_ni1iOl_dataout, ~{n0O0iO});
	or(wire_ni1iil_dataout, niilii, n0i1ii);
	or(wire_ni1iiO_dataout, niilil, n0i1ii);
	and(wire_ni1il_dataout, nii1i, ~{n0lOOl});
	assign		wire_ni1ill_dataout = (n0i1iO === 1'b1) ? niil0O : wire_ni10Ol_dataout;
	or(wire_ni1ilO_dataout, niilii, n0i1iO);
	and(wire_ni1iO_dataout, nlOOOi, ~{n0lOOl});
	or(wire_ni1iOi_dataout, wire_ni10OO_dataout, n0i1iO);
	or(wire_ni1iOl_dataout, niil0O, n0i1iO);
	and(wire_ni1l_dataout, niii0i, n0O00O);
	assign		wire_ni1l0i_dataout = (n0O0iO === 1'b1) ? wire_ni1llO_dataout : wire_ni1liO_dataout;
	assign		wire_ni1l0l_dataout = (n0O0iO === 1'b1) ? wire_ni1lOi_dataout : wire_ni1lli_dataout;
	or(wire_ni1l0O_dataout, n0i1Oi, n0O0iO);
	or(wire_ni1l1i_dataout, niilii, n0i1ll);
	or(wire_ni1l1l_dataout, niilil, n0i1ll);
	assign		wire_ni1lii_dataout = (n0O0iO === 1'b1) ? (~ n0i1OO) : (~ n0i1Oi);
	assign		wire_ni1lil_dataout = (n0O0iO === 1'b1) ? n0i1OO : n0i1Oi;
	or(wire_ni1liO_dataout, niilii, n0i1Oi);
	or(wire_ni1lli_dataout, niilil, n0i1Oi);
	or(wire_ni1llO_dataout, niilii, n0i1OO);
	or(wire_ni1lOi_dataout, niilil, n0i1OO);
	or(wire_ni1lOO_dataout, niilii, n0i01l);
	and(wire_ni1O_dataout, niii0l, n0O00O);
	assign		wire_ni1O0i_dataout = (n0O0iO === 1'b1) ? wire_ni1Oll_dataout : wire_ni1Oil_dataout;
	or(wire_ni1O0l_dataout, n0i00i, n0O0iO);
	assign		wire_ni1O0O_dataout = (n0O0iO === 1'b1) ? n0i00O : n0i00i;
	or(wire_ni1O1i_dataout, niilil, n0i01l);
	assign		wire_ni1O1O_dataout = (n0O0iO === 1'b1) ? wire_ni1Oli_dataout : wire_ni1Oii_dataout;
	or(wire_ni1Oii_dataout, niilii, n0i00i);
	or(wire_ni1Oil_dataout, niilil, n0i00i);
	or(wire_ni1Oli_dataout, niilii, n0i00O);
	or(wire_ni1Oll_dataout, niilil, n0i00O);
	or(wire_ni1OOi_dataout, niilii, n0i0il);
	or(wire_ni1OOl_dataout, niilil, n0i0il);
	assign		wire_nii_dataout = (n0O0li === 1'b1) ? rxd[36] : rxd[20];
	assign		wire_nii0i_dataout = (wire_n111i_o === 1'b1) ? wire_niiOl_o[0] : wire_niiiO_dataout;
	assign		wire_nii0l_dataout = (wire_n111i_o === 1'b1) ? wire_niiOl_o[1] : wire_niili_dataout;
	assign		wire_nii0O_dataout = (wire_n111i_o === 1'b1) ? wire_niiOl_o[2] : wire_niill_dataout;
	or(wire_nii11i_dataout, wire_niO00i_dataout, ~{wire_nii0Ol_o[2]});
	and(wire_nii1l_dataout, wire_n110i_o, ~{rbist_clr_rx});
	and(wire_nii1O_dataout, wire_n110l_o, ~{rbist_clr_rx});
	and(wire_niii_dataout, niiiiO, n0O00O);
	assign		wire_niiii_dataout = (wire_n111i_o === 1'b1) ? wire_niiOl_o[3] : wire_niilO_dataout;
	assign		wire_niiil_dataout = (wire_n111i_o === 1'b1) ? wire_niiOl_o[4] : wire_niiOi_dataout;
	and(wire_niiiO_dataout, ni0ii, ~{wire_n111l_o});
	and(wire_niil_dataout, niiili, n0O00O);
	and(wire_niili_dataout, ni0il, ~{wire_n111l_o});
	and(wire_niill_dataout, ni0iO, ~{wire_n111l_o});
	and(wire_niilO_dataout, ni0li, ~{wire_n111l_o});
	and(wire_niiO_dataout, niiill, n0O00O);
	and(wire_niiOi_dataout, ni0ll, ~{wire_n111l_o});
	assign		wire_nil_dataout = (n0O0li === 1'b1) ? rxd[37] : rxd[21];
	and(wire_nil00i_dataout, wire_nilili_dataout, ~{rbist_clr_rx});
	and(wire_nil00l_dataout, wire_nilill_dataout, ~{rbist_clr_rx});
	and(wire_nil00O_dataout, wire_nililO_dataout, ~{rbist_clr_rx});
	and(wire_nil01i_dataout, wire_niliii_dataout, ~{rbist_clr_rx});
	and(wire_nil01l_dataout, wire_niliil_dataout, ~{rbist_clr_rx});
	and(wire_nil01O_dataout, wire_niliiO_dataout, ~{rbist_clr_rx});
	and(wire_nil0ii_dataout, wire_niliOi_dataout, ~{rbist_clr_rx});
	and(wire_nil0il_dataout, wire_niliOl_dataout, ~{rbist_clr_rx});
	and(wire_nil0iO_dataout, wire_niliOO_dataout, ~{rbist_clr_rx});
	and(wire_nil0li_dataout, wire_nill1i_dataout, ~{rbist_clr_rx});
	and(wire_nil0ll_dataout, wire_ni111i_o, ~{rbist_clr_rx});
	and(wire_nil0lO_dataout, wire_ni111O_o, ~{rbist_clr_rx});
	and(wire_nil0Oi_dataout, wire_ni110i_o, ~{rbist_clr_rx});
	and(wire_nil0Ol_dataout, wire_nill1l_dataout, ~{(~ wire_nO_dataout)});
	and(wire_nil0OO_dataout, wire_nill1O_dataout, ~{(~ wire_nO_dataout)});
	and(wire_nil1il_dataout, wire_nil0Ol_dataout, ~{rbist_clr_rx});
	and(wire_nil1iO_dataout, wire_nil0OO_dataout, ~{rbist_clr_rx});
	and(wire_nil1li_dataout, wire_nili1i_dataout, ~{rbist_clr_rx});
	and(wire_nil1ll_dataout, wire_nili1l_dataout, ~{rbist_clr_rx});
	and(wire_nil1lO_dataout, wire_nili1O_dataout, ~{rbist_clr_rx});
	and(wire_nil1Oi_dataout, wire_nili0i_dataout, ~{rbist_clr_rx});
	and(wire_nil1Ol_dataout, wire_nili0l_dataout, ~{rbist_clr_rx});
	and(wire_nil1OO_dataout, wire_nili0O_dataout, ~{rbist_clr_rx});
	and(wire_nili_dataout, niiilO, n0O00O);
	and(wire_nili0i_dataout, wire_nillii_dataout, ~{(~ wire_nO_dataout)});
	and(wire_nili0l_dataout, wire_nillil_dataout, ~{(~ wire_nO_dataout)});
	and(wire_nili0O_dataout, wire_nilliO_dataout, ~{(~ wire_nO_dataout)});
	and(wire_nili1i_dataout, wire_nill0i_dataout, ~{(~ wire_nO_dataout)});
	and(wire_nili1l_dataout, wire_nill0l_dataout, ~{(~ wire_nO_dataout)});
	and(wire_nili1O_dataout, wire_nill0O_dataout, ~{(~ wire_nO_dataout)});
	and(wire_niliii_dataout, wire_nillli_dataout, ~{(~ wire_nO_dataout)});
	and(wire_niliil_dataout, wire_nillll_dataout, ~{(~ wire_nO_dataout)});
	and(wire_niliiO_dataout, wire_nilllO_dataout, ~{(~ wire_nO_dataout)});
	and(wire_nilili_dataout, wire_nillOi_dataout, ~{(~ wire_nO_dataout)});
	and(wire_nilill_dataout, wire_nillOl_dataout, ~{(~ wire_nO_dataout)});
	and(wire_nililO_dataout, wire_nillOO_dataout, ~{(~ wire_nO_dataout)});
	and(wire_niliOi_dataout, wire_nilO1i_dataout, ~{(~ wire_nO_dataout)});
	and(wire_niliOl_dataout, wire_nilO1l_dataout, ~{(~ wire_nO_dataout)});
	and(wire_niliOO_dataout, wire_nilO1O_dataout, ~{(~ wire_nO_dataout)});
	and(wire_nill_dataout, niiiOi, n0O00O);
	assign		wire_nill0i_dataout = (niil1O === 1'b1) ? wire_ni0OOi_dataout : niii1l;
	assign		wire_nill0l_dataout = (niil1O === 1'b1) ? wire_ni0OOl_o : niii1O;
	assign		wire_nill0O_dataout = (niil1O === 1'b1) ? wire_nii11i_dataout : niii0i;
	and(wire_nill1i_dataout, wire_nilO0i_dataout, ~{(~ wire_nO_dataout)});
	assign		wire_nill1l_dataout = (niil1O === 1'b1) ? wire_ni0Oii_o : nii0OO;
	assign		wire_nill1O_dataout = (niil1O === 1'b1) ? wire_ni0Oli_o : niii1i;
	assign		wire_nillii_dataout = (niil1O === 1'b1) ? wire_nii11l_o : niii0l;
	assign		wire_nillil_dataout = (niil1O === 1'b1) ? wire_nii10l_o : niii0O;
	assign		wire_nilliO_dataout = (niil1O === 1'b1) ? wire_nii1il_o : niiiii;
	assign		wire_nillli_dataout = (niil1O === 1'b1) ? wire_nii1ll_o : niiiil;
	assign		wire_nillll_dataout = (niil1O === 1'b1) ? wire_nii1Oi_o : niiiiO;
	assign		wire_nilllO_dataout = (niil1O === 1'b1) ? wire_nii1OO_o : niiili;
	assign		wire_nillOi_dataout = (niil1O === 1'b1) ? wire_nii01i_o : niiill;
	assign		wire_nillOl_dataout = (niil1O === 1'b1) ? wire_nii01O_o : niiilO;
	assign		wire_nillOO_dataout = (niil1O === 1'b1) ? wire_nii00l_o : niiiOi;
	and(wire_nilO_dataout, niiiOl, n0O00O);
	assign		wire_nilO0i_dataout = (niil1O === 1'b1) ? wire_nii0lO_o : niil1l;
	and(wire_nilO0l_dataout, wire_niO1lO_o[0], wire_ni110O_o);
	and(wire_nilO0O_dataout, wire_niO1lO_o[1], wire_ni110O_o);
	assign		wire_nilO1i_dataout = (niil1O === 1'b1) ? wire_nii0ii_o : niiiOl;
	assign		wire_nilO1l_dataout = (niil1O === 1'b1) ? wire_nii0iO_o : niiiOO;
	assign		wire_nilO1O_dataout = (niil1O === 1'b1) ? (~ wire_nii0Ol_o[2]) : niil1i;
	and(wire_nilOii_dataout, wire_niO1lO_o[2], wire_ni110O_o);
	and(wire_nilOil_dataout, wire_niO1lO_o[3], wire_ni110O_o);
	and(wire_nilOiO_dataout, wire_niO1lO_o[4], wire_ni110O_o);
	and(wire_nilOli_dataout, wire_niO1lO_o[5], wire_ni110O_o);
	and(wire_nilOll_dataout, wire_niO1lO_o[6], wire_ni110O_o);
	and(wire_nilOlO_dataout, wire_niO1Oi_o[0], wire_ni110O_o);
	and(wire_nilOOi_dataout, wire_niO1Oi_o[1], wire_ni110O_o);
	and(wire_nilOOl_dataout, wire_niO1Oi_o[2], wire_ni110O_o);
	and(wire_nilOOO_dataout, wire_niO1Oi_o[3], wire_ni110O_o);
	assign		wire_niO_dataout = (n0O0li === 1'b1) ? rxd[38] : rxd[22];
	assign		wire_niO00i_dataout = (n0O0iO === 1'b1) ? niiO0i : niiOlO;
	assign		wire_niO00l_dataout = (n0O0iO === 1'b1) ? niiO0l : niiOOi;
	assign		wire_niO00O_dataout = (n0O0iO === 1'b1) ? niiO0O : niiOOl;
	assign		wire_niO01i_dataout = (n0O0iO === 1'b1) ? niiO1i : niiOiO;
	assign		wire_niO01l_dataout = (n0O0iO === 1'b1) ? niiO1l : niiOli;
	assign		wire_niO01O_dataout = (n0O0iO === 1'b1) ? niiO1O : niiOll;
	assign		wire_niO0ii_dataout = (n0O0iO === 1'b1) ? niiOii : niiOOO;
	and(wire_niO0il_dataout, niiliO, n0O0iO);
	and(wire_niO0iO_dataout, niilli, n0O0iO);
	and(wire_niO0li_dataout, niilll, n0O0iO);
	and(wire_niO0ll_dataout, niillO, n0O0iO);
	and(wire_niO0lO_dataout, niilOi, n0O0iO);
	and(wire_niO0Oi_dataout, niilOl, n0O0iO);
	and(wire_niO0Ol_dataout, niilOO, n0O0iO);
	and(wire_niO10i_dataout, wire_niO1Ol_o[0], wire_ni110O_o);
	and(wire_niO10l_dataout, wire_niO1Ol_o[1], wire_ni110O_o);
	and(wire_niO10O_dataout, wire_niO1Ol_o[2], wire_ni110O_o);
	and(wire_niO11i_dataout, wire_niO1Oi_o[4], wire_ni110O_o);
	and(wire_niO11l_dataout, wire_niO1Oi_o[5], wire_ni110O_o);
	and(wire_niO11O_dataout, wire_niO1Oi_o[6], wire_ni110O_o);
	and(wire_niO1ii_dataout, wire_niO1Ol_o[3], wire_ni110O_o);
	and(wire_niO1il_dataout, wire_niO1Ol_o[4], wire_ni110O_o);
	and(wire_niO1iO_dataout, wire_niO1Ol_o[5], wire_ni110O_o);
	and(wire_niO1li_dataout, wire_niO1Ol_o[6], wire_ni110O_o);
	and(wire_niO1ll_dataout, wire_niO1Ol_o[7], wire_ni110O_o);
	and(wire_niO1OO_dataout, niiOil, ~{n0O0iO});
	and(wire_niOi_dataout, niiiOO, n0O00O);
	and(wire_niOl_dataout, niil1i, n0O00O);
	and(wire_niOO_dataout, niil1l, n0O00O);
	and(wire_nl_dataout, rbisten_rx, (rbist_sel[0] & (~ rbist_sel[1])));
	assign		wire_nl000i_dataout = ((~ n0iOOi) === 1'b1) ? nll1OO : wire_nl01il_dataout;
	or(wire_nl000l_dataout, wire_nl01iO_dataout, (~ n0iOOi));
	or(wire_nl000O_dataout, nll1Ol, (~ n0iOOi));
	or(wire_nl001i_dataout, wire_nl01iO_dataout, (~ n0iOlO));
	or(wire_nl001l_dataout, nll1Ol, (~ n0iOlO));
	or(wire_nl001O_dataout, nll1OO, (~ n0iOlO));
	or(wire_nl00ii_dataout, nll1OO, (~ n0iOOi));
	assign		wire_nl00il_dataout = (n0O0iO === 1'b1) ? wire_nl00OO_dataout : nll1OO;
	assign		wire_nl00iO_dataout = (n0O0iO === 1'b1) ? wire_nl0i1i_dataout : wire_nl00Oi_dataout;
	assign		wire_nl00li_dataout = (n0O0iO === 1'b1) ? wire_nl0i1l_dataout : wire_nl00Ol_dataout;
	or(wire_nl00ll_dataout, (~ n0iOOO), n0O0iO);
	or(wire_nl00lO_dataout, wire_nl0i1O_dataout, ~{n0O0iO});
	or(wire_nl00Oi_dataout, nll1Oi, (~ n0iOOO));
	or(wire_nl00Ol_dataout, nll1Ol, (~ n0iOOO));
	assign		wire_nl00OO_dataout = (n0iOOl === 1'b1) ? nll1OO : wire_nl01il_dataout;
	assign		wire_nl010i_dataout = (n0iOiO === 1'b1) ? nll1OO : wire_nl01il_dataout;
	or(wire_nl010l_dataout, wire_nl01iO_dataout, n0iOiO);
	or(wire_nl010O_dataout, nll1Ol, n0iOiO);
	and(wire_nl011i_dataout, nllilO, ~{(~ wire_nl_dataout)});
	and(wire_nl011l_dataout, nlliOi, ~{(~ wire_nl_dataout)});
	and(wire_nl011O_dataout, nl1lii, ~{(~ wire_nl_dataout)});
	or(wire_nl01ii_dataout, nll1OO, n0iOiO);
	assign		wire_nl01il_dataout = (nll1OO === 1'b1) ? nll1OO : (~ nll1OO);
	or(wire_nl01iO_dataout, nll1Oi, nll1OO);
	assign		wire_nl01ll_dataout = ((~ n0iOll) === 1'b1) ? nll1OO : wire_nl01il_dataout;
	or(wire_nl01lO_dataout, wire_nl01iO_dataout, (~ n0iOll));
	or(wire_nl01Oi_dataout, nll1Ol, (~ n0iOll));
	or(wire_nl01Ol_dataout, nll1OO, (~ n0iOll));
	assign		wire_nl01OO_dataout = ((~ n0iOlO) === 1'b1) ? nll1OO : wire_nl01il_dataout;
	assign		wire_nl0i_dataout = (n0O0ii === 1'b1) ? nll1Oi : wire_nl0O_dataout;
	and(wire_nl0i0l_dataout, wire_nl0ilO_dataout, ~{(~ n0l11i)});
	and(wire_nl0i0O_dataout, wire_nl0ill_dataout, ~{(~ n0l11i)});
	or(wire_nl0i1i_dataout, wire_nl01iO_dataout, n0iOOl);
	or(wire_nl0i1l_dataout, nll1Ol, n0iOOl);
	or(wire_nl0i1O_dataout, nll1OO, n0iOOl);
	or(wire_nl0iii_dataout, nll1Oi, (~ n0l11i));
	or(wire_nl0iil_dataout, nll1Ol, (~ n0l11i));
	or(wire_nl0iiO_dataout, wire_nl0ill_dataout, (~ n0l11i));
	or(wire_nl0ili_dataout, wire_nl0ilO_dataout, (~ n0l11i));
	assign		wire_nl0ill_dataout = (n0O0iO === 1'b1) ? n0l11l : n0l11O;
	assign		wire_nl0ilO_dataout = (n0O0iO === 1'b1) ? (~ n0l11l) : (~ n0l11O);
	or(wire_nl0iOi_dataout, nll1Oi, (~ n0l10i));
	or(wire_nl0iOl_dataout, nll1Ol, (~ n0l10i));
	and(wire_nl0iOO_dataout, n0O0iO, ~{(~ n0l10l)});
	and(wire_nl0l_dataout, ni00l, n0O0il);
	or(wire_nl0l0i_dataout, wire_nl0lil_dataout, (~ n0l10l));
	or(wire_nl0l0l_dataout, wire_nl0liO_dataout, (~ n0l10l));
	or(wire_nl0l0O_dataout, wire_nl0lli_dataout, (~ n0l10l));
	or(wire_nl0l1i_dataout, nll1Oi, (~ n0l10l));
	or(wire_nl0l1l_dataout, nll1Ol, (~ n0l10l));
	or(wire_nl0l1O_dataout, wire_nl0lii_dataout, (~ n0l10l));
	and(wire_nl0lii_dataout, wire_nl0lll_dataout, n0O0iO);
	or(wire_nl0lil_dataout, wire_nl0llO_dataout, ~{n0O0iO});
	or(wire_nl0liO_dataout, wire_nl0lOi_dataout, ~{n0O0iO});
	and(wire_nl0lli_dataout, wire_nl0lOl_dataout, n0O0iO);
	or(wire_nl0lll_dataout, wire_nl0lOO_dataout, n0l10O);
	and(wire_nl0llO_dataout, wire_nl0O1i_dataout, ~{n0l10O});
	or(wire_nl0lOi_dataout, wire_nl0O1l_dataout, n0l10O);
	and(wire_nl0lOl_dataout, wire_nl0O1O_dataout, ~{n0l10O});
	or(wire_nl0lOO_dataout, wire_nl0O0i_dataout, ~{n0l1ii});
	and(wire_nl0O_dataout, ni01O, n0O0il);
	and(wire_nl0O0i_dataout, wire_nl0Oil_dataout, ~{n0l0Ol});
	or(wire_nl0O0l_dataout, wire_nl0OiO_dataout, n0l0Ol);
	and(wire_nl0O0O_dataout, wire_nl0Oli_dataout, ~{n0l0Ol});
	or(wire_nl0O1i_dataout, wire_nl0O0l_dataout, ~{n0l1ii});
	or(wire_nl0O1l_dataout, wire_nl0O0O_dataout, ~{n0l1ii});
	and(wire_nl0O1O_dataout, wire_nl0Oii_dataout, n0l1ii);
	or(wire_nl0Oii_dataout, wire_nl0Oll_dataout, n0l0Ol);
	or(wire_nl0Oil_dataout, wire_nl0OlO_dataout, n0l0ii);
	or(wire_nl0OiO_dataout, wire_nl0OOi_dataout, n0l0ii);
	and(wire_nl0Oli_dataout, wire_nl0OOl_dataout, ~{n0l0ii});
	or(wire_nl0Oll_dataout, wire_nl0OOO_dataout, n0l0ii);
	and(wire_nl0OlO_dataout, wire_nli11i_dataout, ~{n0l00O});
	and(wire_nl0OOi_dataout, wire_nli11l_dataout, ~{n0l00O});
	or(wire_nl0OOl_dataout, wire_nli11O_dataout, n0l00O);
	or(wire_nl0OOO_dataout, wire_nli10i_dataout, n0l00O);
	assign		wire_nl1i_dataout = (n0O00O === 1'b1) ? niilii : wire_nl1O_dataout;
	assign		wire_nl1l_dataout = (n0O00O === 1'b1) ? niilil : wire_nl0i_dataout;
	and(wire_nl1lli_dataout, wire_nl0i0l_dataout, wire_nl1OlO_o[8]);
	and(wire_nl1lll_dataout, wire_nl0i0O_dataout, wire_nl1OlO_o[8]);
	and(wire_nl1llO_dataout, wire_nl0iOO_dataout, wire_nl1OlO_o[7]);
	and(wire_nl1lOi_dataout, wire_nli10l_dataout, wire_nl1OlO_o[6]);
	and(wire_nl1lOl_dataout, wire_nli10O_dataout, wire_nl1OlO_o[6]);
	and(wire_nl1lOO_dataout, wire_nlii1l_dataout, wire_nl1OlO_o[5]);
	assign		wire_nl1O_dataout = (n0O0ii === 1'b1) ? nll1Ol : wire_nl0l_dataout;
	and(wire_nl1O1i_dataout, n0l1Oi, wire_nl1OlO_o[5]);
	and(wire_nl1OOi_dataout, nll1Ol, ~{(~ wire_nl_dataout)});
	and(wire_nl1OOl_dataout, nll1Oi, ~{(~ wire_nl_dataout)});
	and(wire_nl1OOO_dataout, nllill, ~{(~ wire_nl_dataout)});
	assign		wire_nli_dataout = (n0O0li === 1'b1) ? rxd[39] : rxd[23];
	or(wire_nli00i_dataout, wire_nli0il_dataout, n0l1lO);
	and(wire_nli00l_dataout, wire_nli0iO_dataout, ~{n0l1lO});
	and(wire_nli00O_dataout, wire_nli0li_dataout, ~{n0l1lO});
	assign		wire_nli01i_dataout = (n0O0iO === 1'b1) ? (~ n0l1iO) : wire_nli00l_dataout;
	assign		wire_nli01l_dataout = (n0O0iO === 1'b1) ? (~ n0l1iO) : wire_nli00O_dataout;
	assign		wire_nli01O_dataout = (n0O0iO === 1'b1) ? n0l1iO : wire_nli0ii_dataout;
	or(wire_nli0ii_dataout, wire_nli0ll_dataout, n0l1lO);
	or(wire_nli0il_dataout, wire_nli0lO_dataout, n0l1li);
	and(wire_nli0iO_dataout, wire_nli0Oi_dataout, ~{n0l1li});
	or(wire_nli0li_dataout, wire_nli0Ol_dataout, n0l1li);
	and(wire_nli0ll_dataout, wire_nli0OO_dataout, ~{n0l1li});
	or(wire_nli0lO_dataout, wire_nl0O0i_dataout, ~{n0l1ll});
	or(wire_nli0Oi_dataout, wire_nl0O0l_dataout, ~{n0l1ll});
	or(wire_nli0Ol_dataout, wire_nl0O0O_dataout, ~{n0l1ll});
	and(wire_nli0OO_dataout, wire_nl0Oii_dataout, n0l1ll);
	or(wire_nli10i_dataout, nl1lii, n0l0iO);
	and(wire_nli10l_dataout, wire_nli1Oi_dataout, ~{(~ n0l1il)});
	and(wire_nli10O_dataout, wire_nli1Ol_dataout, ~{(~ n0l1il)});
	or(wire_nli11i_dataout, nllill, n0l0iO);
	and(wire_nli11l_dataout, nllilO, ~{n0l0iO});
	or(wire_nli11O_dataout, nlliOi, n0l0iO);
	or(wire_nli1ii_dataout, nll1Oi, (~ n0l1il));
	or(wire_nli1il_dataout, nll1Ol, (~ n0l1il));
	or(wire_nli1iO_dataout, wire_nli1OO_dataout, (~ n0l1il));
	or(wire_nli1li_dataout, wire_nli01i_dataout, (~ n0l1il));
	or(wire_nli1ll_dataout, wire_nli01l_dataout, (~ n0l1il));
	or(wire_nli1lO_dataout, wire_nli01O_dataout, (~ n0l1il));
	or(wire_nli1Oi_dataout, (~ n0l1iO), ~{n0O0iO});
	and(wire_nli1Ol_dataout, n0l1iO, n0O0iO);
	assign		wire_nli1OO_dataout = (n0O0iO === 1'b1) ? n0l1iO : wire_nli00i_dataout;
	and(wire_nlii_dataout, wire_n1l_dataout, n0O0iO);
	or(wire_nlii0i_dataout, nll1Ol, (~ n0l1Oi));
	or(wire_nlii0l_dataout, wire_nliiil_dataout, (~ n0l1Oi));
	or(wire_nlii0O_dataout, wire_nliiiO_dataout, (~ n0l1Oi));
	and(wire_nlii1l_dataout, wire_nliiii_dataout, ~{(~ n0l1Oi)});
	or(wire_nlii1O_dataout, nll1Oi, (~ n0l1Oi));
	assign		wire_nliiii_dataout = (n0l0Ol === 1'b1) ? wire_nlil0i_dataout : wire_nliili_dataout;
	assign		wire_nliiil_dataout = (n0l0Ol === 1'b1) ? wire_nlil0l_dataout : wire_nliill_dataout;
	assign		wire_nliiiO_dataout = (n0l0Ol === 1'b1) ? wire_nlil0O_dataout : wire_nliilO_dataout;
	assign		wire_nliili_dataout = (n0O0iO === 1'b1) ? wire_nlil1i_dataout : wire_nliiOi_dataout;
	assign		wire_nliill_dataout = (n0O0iO === 1'b1) ? wire_nlil1l_dataout : wire_nliiOl_dataout;
	assign		wire_nliilO_dataout = (n0O0iO === 1'b1) ? wire_nlil1O_dataout : wire_nliiOO_dataout;
	and(wire_nliiOi_dataout, n0l1Ol, ~{n0l01i});
	and(wire_nliiOl_dataout, (~ n0l1Ol), ~{n0l01i});
	or(wire_nliiOO_dataout, n0l1Ol, n0l01i);
	and(wire_nlil_dataout, wire_n1O_dataout, n0O0iO);
	assign		wire_nlil0i_dataout = (n0O0iO === 1'b1) ? wire_nlilli_dataout : wire_nlilii_dataout;
	assign		wire_nlil0l_dataout = (n0O0iO === 1'b1) ? wire_nlilll_dataout : wire_nlilil_dataout;
	assign		wire_nlil0O_dataout = (n0O0iO === 1'b1) ? wire_nlillO_dataout : wire_nliliO_dataout;
	and(wire_nlil1i_dataout, n0l01i, ~{n0l1OO});
	and(wire_nlil1l_dataout, (~ n0l01i), ~{n0l1OO});
	or(wire_nlil1O_dataout, n0l01i, n0l1OO);
	and(wire_nlilii_dataout, n0l01l, ~{n0l00i});
	and(wire_nlilil_dataout, (~ n0l01l), ~{n0l00i});
	or(wire_nliliO_dataout, n0l01l, n0l00i);
	and(wire_nlilli_dataout, n0l00i, ~{n0l01O});
	and(wire_nlilll_dataout, (~ n0l00i), ~{n0l01O});
	or(wire_nlillO_dataout, n0l00i, n0l01O);
	or(wire_nlilOi_dataout, nll1Oi, (~ n0l00l));
	or(wire_nlilOl_dataout, nll1Ol, (~ n0l00l));
	and(wire_nlilOO_dataout, wire_nliO0i_dataout, ~{n0l0Ol});
	and(wire_nliO_dataout, wire_n0i_dataout, n0O0iO);
	or(wire_nliO0i_dataout, nllill, n0l0ll);
	and(wire_nliO0l_dataout, nllilO, ~{n0l0ll});
	or(wire_nliO0O_dataout, nlliOi, n0l0ll);
	and(wire_nliO1i_dataout, wire_nliO0l_dataout, ~{n0l0Ol});
	or(wire_nliO1l_dataout, wire_nliO0O_dataout, n0l0Ol);
	and(wire_nliO1O_dataout, wire_nliOii_dataout, ~{n0l0Ol});
	and(wire_nliOii_dataout, nl1lii, ~{n0l0ll});
	and(wire_nliOiO_dataout, wire_nliOOi_dataout, ~{n0l0Oi});
	assign		wire_nliOli_dataout = (n0l0Oi === 1'b1) ? (~ n0O0iO) : wire_nliOOl_dataout;
	assign		wire_nliOll_dataout = (n0l0Oi === 1'b1) ? n0O0iO : wire_nliOOO_dataout;
	and(wire_nliOlO_dataout, wire_nll11i_dataout, ~{n0l0Oi});
	assign		wire_nliOOi_dataout = (n0l0li === 1'b1) ? n0O0iO : wire_nll11l_dataout;
	assign		wire_nliOOl_dataout = (n0l0li === 1'b1) ? (~ n0O0iO) : wire_nll11O_dataout;
	assign		wire_nliOOO_dataout = (n0l0li === 1'b1) ? n0O0iO : wire_nll10i_dataout;
	assign		wire_nll10i_dataout = (n0l0il === 1'b1) ? n0O0iO : nlliOi;
	and(wire_nll10l_dataout, nl1lii, ~{n0l0il});
	and(wire_nll11i_dataout, wire_nll10l_dataout, ~{n0l0li});
	or(wire_nll11l_dataout, nllill, n0l0il);
	assign		wire_nll11O_dataout = (n0l0il === 1'b1) ? (~ n0O0iO) : nllilO;
	and(wire_nlli_dataout, wire_n0l_dataout, n0O0iO);
	and(wire_nlliOl_dataout, wire_nl1O1l_o, ~{rbist_clr_rx});
	and(wire_nlliOO_dataout, wire_nl1O1O_o, ~{rbist_clr_rx});
	and(wire_nlll_dataout, wire_n0O_dataout, n0O0iO);
	assign		wire_nlll0i_dataout = (wire_nl1lli_dataout === 1'b1) ? wire_nlllOi_o[3] : wire_nlllli_dataout;
	assign		wire_nlll0l_dataout = (wire_nl1lli_dataout === 1'b1) ? wire_nlllOi_o[4] : wire_nlllll_dataout;
	assign		wire_nlll0O_dataout = (wire_nl1lli_dataout === 1'b1) ? wire_nlllOi_o[5] : wire_nllllO_dataout;
	assign		wire_nlll1i_dataout = (wire_nl1lli_dataout === 1'b1) ? wire_nlllOi_o[0] : wire_nlllii_dataout;
	assign		wire_nlll1l_dataout = (wire_nl1lli_dataout === 1'b1) ? wire_nlllOi_o[1] : wire_nlllil_dataout;
	assign		wire_nlll1O_dataout = (wire_nl1lli_dataout === 1'b1) ? wire_nlllOi_o[2] : wire_nllliO_dataout;
	and(wire_nlllii_dataout, nll01i, ~{wire_nl1lll_dataout});
	and(wire_nlllil_dataout, nll01l, ~{wire_nl1lll_dataout});
	and(wire_nllliO_dataout, nll01O, ~{wire_nl1lll_dataout});
	and(wire_nlllli_dataout, nll00i, ~{wire_nl1lll_dataout});
	and(wire_nlllll_dataout, nll00l, ~{wire_nl1lll_dataout});
	and(wire_nllllO_dataout, nll00O, ~{wire_nl1lll_dataout});
	and(wire_nlllOO_dataout, wire_nllO0i_dataout, ~{wire_nl1lOl_dataout});
	and(wire_nllO_dataout, wire_nii_dataout, n0O0iO);
	assign		wire_nllO0i_dataout = (wire_nl1lOi_dataout === 1'b1) ? wire_nllOil_o[0] : nll0Oi;
	assign		wire_nllO0l_dataout = (wire_nl1lOi_dataout === 1'b1) ? wire_nllOil_o[1] : nll0Ol;
	assign		wire_nllO0O_dataout = (wire_nl1lOi_dataout === 1'b1) ? wire_nllOil_o[2] : nll0OO;
	and(wire_nllO1i_dataout, wire_nllO0l_dataout, ~{wire_nl1lOl_dataout});
	and(wire_nllO1l_dataout, wire_nllO0O_dataout, ~{wire_nl1lOl_dataout});
	and(wire_nllO1O_dataout, wire_nllOii_dataout, ~{wire_nl1lOl_dataout});
	assign		wire_nllOii_dataout = (wire_nl1lOi_dataout === 1'b1) ? wire_nllOil_o[3] : nlli1i;
	and(wire_nllOiO_dataout, wire_nlO11O_dataout, ~{wire_nl1lOO_dataout});
	and(wire_nllOli_dataout, wire_nlO10i_dataout, ~{wire_nl1lOO_dataout});
	and(wire_nllOll_dataout, wire_nlO10l_dataout, ~{wire_nl1lOO_dataout});
	and(wire_nllOlO_dataout, wire_nlO10O_dataout, ~{wire_nl1lOO_dataout});
	and(wire_nllOOi_dataout, wire_nlO1ii_dataout, ~{wire_nl1lOO_dataout});
	and(wire_nllOOl_dataout, wire_nlO1il_dataout, ~{wire_nl1lOO_dataout});
	and(wire_nllOOO_dataout, wire_nlO1iO_dataout, ~{wire_nl1lOO_dataout});
	assign		wire_nlO10i_dataout = (wire_nl1O1i_dataout === 1'b1) ? wire_nlO1lO_o[1] : nlli1O;
	assign		wire_nlO10l_dataout = (wire_nl1O1i_dataout === 1'b1) ? wire_nlO1lO_o[2] : nlli0i;
	assign		wire_nlO10O_dataout = (wire_nl1O1i_dataout === 1'b1) ? wire_nlO1lO_o[3] : nlli0l;
	and(wire_nlO11i_dataout, wire_nlO1li_dataout, ~{wire_nl1lOO_dataout});
	and(wire_nlO11l_dataout, wire_nlO1ll_dataout, ~{wire_nl1lOO_dataout});
	assign		wire_nlO11O_dataout = (wire_nl1O1i_dataout === 1'b1) ? wire_nlO1lO_o[0] : nlli1l;
	assign		wire_nlO1ii_dataout = (wire_nl1O1i_dataout === 1'b1) ? wire_nlO1lO_o[4] : nlli0O;
	assign		wire_nlO1il_dataout = (wire_nl1O1i_dataout === 1'b1) ? wire_nlO1lO_o[5] : nlliii;
	assign		wire_nlO1iO_dataout = (wire_nl1O1i_dataout === 1'b1) ? wire_nlO1lO_o[6] : nlliil;
	assign		wire_nlO1li_dataout = (wire_nl1O1i_dataout === 1'b1) ? wire_nlO1lO_o[7] : nlliiO;
	assign		wire_nlO1ll_dataout = (wire_nl1O1i_dataout === 1'b1) ? wire_nlO1lO_o[8] : nllili;
	and(wire_nlOi_dataout, wire_nil_dataout, n0O0iO);
	and(wire_nlOl_dataout, wire_niO_dataout, n0O0iO);
	and(wire_nlOO_dataout, wire_nli_dataout, n0O0iO);
	and(wire_nO_dataout, rbisten_rx, (((~ rbist_sel[0]) & (~ rbist_sel[1])) & n0O0OO2));
	oper_add   niiOl
	( 
	.a({ni0ll, ni0li, ni0iO, ni0il, ni0ii}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niiOl_o));
	defparam
		niiOl.sgate_representation = 0,
		niiOl.width_a = 5,
		niiOl.width_b = 5,
		niiOl.width_o = 5;
	oper_add   niO1lO
	( 
	.a({niiOii, niiO0O, niiO0l, niiO0i, niiO1O, niiO1l, niiO1i}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niO1lO_o));
	defparam
		niO1lO.sgate_representation = 0,
		niO1lO.width_a = 7,
		niO1lO.width_b = 7,
		niO1lO.width_o = 7;
	oper_add   niO1Oi
	( 
	.a({niilOO, niilOl, niilOi, niillO, niilll, niilli, niiliO}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niO1Oi_o));
	defparam
		niO1Oi.sgate_representation = 0,
		niO1Oi.width_a = 7,
		niO1Oi.width_b = 7,
		niO1Oi.width_o = 7;
	oper_add   niO1Ol
	( 
	.a({niiOOO, niiOOl, niiOOi, niiOlO, niiOll, niiOli, niiOiO, niiOil}),
	.b({{7{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niO1Ol_o));
	defparam
		niO1Ol.sgate_representation = 0,
		niO1Ol.width_a = 8,
		niO1Ol.width_b = 8,
		niO1Ol.width_o = 8;
	oper_add   nlllOi
	( 
	.a({nll00O, nll00l, nll00i, nll01O, nll01l, nll01i}),
	.b({{5{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlllOi_o));
	defparam
		nlllOi.sgate_representation = 0,
		nlllOi.width_a = 6,
		nlllOi.width_b = 6,
		nlllOi.width_o = 6;
	oper_add   nlllOl
	( 
	.a({nll0lO, nll0li, nll0il}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlllOl_o));
	defparam
		nlllOl.sgate_representation = 0,
		nlllOl.width_a = 3,
		nlllOl.width_b = 3,
		nlllOl.width_o = 3;
	oper_add   nllOil
	( 
	.a({nlli1i, nll0OO, nll0Ol, nll0Oi}),
	.b({{3{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllOil_o));
	defparam
		nllOil.sgate_representation = 0,
		nllOil.width_a = 4,
		nllOil.width_b = 4,
		nllOil.width_o = 4;
	oper_add   nlO1lO
	( 
	.a({nllili, nlliiO, nlliil, nlliii, nlli0O, nlli0l, nlli0i, nlli1O, nlli1l}),
	.b({{8{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO1lO_o));
	defparam
		nlO1lO.sgate_representation = 0,
		nlO1lO.width_a = 9,
		nlO1lO.width_b = 9,
		nlO1lO.width_o = 9;
	oper_decoder   n100i
	( 
	.i({nlOOOi, nii1i, ni0Ol, (n0ll1O38 & ni0Oi), (n0ll0i35 & ni0lO)}),
	.o(wire_n100i_o));
	defparam
		n100i.width_i = 5,
		n100i.width_o = 32;
	oper_decoder   ni101l
	( 
	.i({n0OOOi, nil1ii, nil10O, nil10l}),
	.o(wire_ni101l_o));
	defparam
		ni101l.width_i = 4,
		ni101l.width_o = 16;
	oper_decoder   nii0Ol
	( 
	.i({nil10i, nil11O, nil11l, nil11i}),
	.o(wire_nii0Ol_o));
	defparam
		nii0Ol.width_i = 4,
		nii0Ol.width_o = 16;
	oper_decoder   nl1OlO
	( 
	.i({nl1lii, nlliOi, nllilO, nllill}),
	.o(wire_nl1OlO_o));
	defparam
		nl1OlO.width_i = 4,
		nl1OlO.width_o = 16;
	oper_selector   n0OOOl
	( 
	.data({niil0O, wire_ni101O_dataout, wire_ni10li_dataout, wire_ni1i1l_dataout}),
	.o(wire_n0OOOl_o),
	.sel({n00OOi, wire_ni101l_o[13:11]}));
	defparam
		n0OOOl.width_data = 4,
		n0OOOl.width_sel = 4;
	oper_selector   n101l
	( 
	.data({1'b0, wire_n10ll_dataout, wire_n10OO_dataout, wire_n1iii_dataout, wire_n1ill_dataout, wire_n1iOO_dataout, (n0liiO59 & wire_n1l0l_dataout), wire_n1O0O_dataout, wire_n00li_dataout, (~ n0lO0i), (~ n0lO0l), (~ n0lO0O), (~ n0lOii), (~ n0lOil), (~ n0lOiO), (~ n0lOli), (~ n0lOll), (~ n0lOlO), (~ n0lOOi), wire_n0OiO_dataout, (n0lili56 & wire_n0OOl_dataout)}),
	.o(wire_n101l_o),
	.sel({n0liOO, wire_n100i_o[21], (n0lill53 & wire_n100i_o[20]), wire_n100i_o[19:14], (n0lilO50 & wire_n100i_o[13]), (n0liOi47 & wire_n100i_o[12]), wire_n100i_o[11:5], (n0liOl44 & wire_n100i_o[4]), wire_n100i_o[2:1]}));
	defparam
		n101l.width_data = 21,
		n101l.width_sel = 21;
	oper_selector   n110i
	( 
	.data({ni01O, wire_n100O_dataout, wire_n10Oi_dataout, wire_n1i0l_dataout, wire_n1iiO_dataout, wire_n1iOi_dataout, wire_n1l1l_dataout, wire_n1lOO_dataout, wire_n000i_dataout, wire_n0i1O_dataout, wire_n0i0l_dataout, wire_n0iiO_dataout, wire_n0ill_dataout, wire_n0l1i_dataout, wire_n0l1O_dataout, wire_n0lii_dataout, wire_n0liO_dataout, wire_n0lOl_dataout, wire_n0O1i_dataout}),
	.o(wire_n110i_o),
	.sel({n0li1O, wire_n100i_o[21:4]}));
	defparam
		n110i.width_data = 19,
		n110i.width_sel = 19;
	oper_selector   n110l
	( 
	.data({ni00l, wire_n100l_dataout, wire_n10Ol_dataout, wire_n1i0O_dataout, wire_n1ili_dataout, wire_n1iOl_dataout, wire_n1l1O_dataout, wire_n1O1i_dataout, wire_n000l_dataout, wire_n0i0i_dataout, wire_n0i0O_dataout, wire_n0ili_dataout, wire_n0ilO_dataout, wire_n0l1l_dataout, wire_n0l0i_dataout, wire_n0lil_dataout, wire_n0lli_dataout, wire_n0lOO_dataout, wire_n0O1l_dataout}),
	.o(wire_n110l_o),
	.sel({n0li1O, wire_n100i_o[21:4]}));
	defparam
		n110l.width_data = 19,
		n110l.width_sel = 19;
	oper_selector   n111i
	( 
	.data({1'b0, wire_n1lOi_dataout, wire_n001l_dataout}),
	.o(wire_n111i_o),
	.sel({n0li1l, wire_n100i_o[15:14]}));
	defparam
		n111i.width_data = 3,
		n111i.width_sel = 3;
	oper_selector   n111l
	( 
	.data({1'b0, wire_n1lOl_dataout, wire_n001O_dataout}),
	.o(wire_n111l_o),
	.sel({n0li1l, wire_n100i_o[15:14]}));
	defparam
		n111l.width_data = 3,
		n111l.width_sel = 3;
	oper_selector   n11ii
	( 
	.data({1'b0, wire_n10ii_dataout, 1'b1, wire_n1l0i_dataout, wire_n1O1l_dataout, wire_n000O_dataout, (~ n0lO0i), wire_n0iii_dataout, (~ n0lO0O), wire_n0iOi_dataout, (~ n0lOil), wire_n0l0l_dataout, (~ n0lOli), wire_n0llO_dataout, (~ n0lOlO), wire_n0O1O_dataout, wire_n0O0l_dataout, wire_n0Oli_dataout, (ni01i & wire_ni_dataout)}),
	.o(wire_n11ii_o),
	.sel({n0li0i, wire_n100i_o[21], (((wire_n100i_o[20] | wire_n100i_o[19]) | wire_n100i_o[18]) | wire_n100i_o[17]), wire_n100i_o[16:4], wire_n100i_o[2:0]}));
	defparam
		n11ii.width_data = 19,
		n11ii.width_sel = 19;
	oper_selector   n11li
	( 
	.data({1'b0, wire_n10il_dataout, wire_n1O1O_dataout, wire_n00ii_dataout, n0lO0i, wire_n0iil_dataout, wire_n0iOl_dataout, n0lOil, wire_n0l0O_dataout, wire_n0lll_dataout, n0lOlO, wire_n0O0i_dataout, wire_n0O0O_dataout, wire_n0Oll_dataout}),
	.o(wire_n11li_o),
	.sel({n0li0l, wire_n100i_o[21], wire_n100i_o[15:12], wire_n100i_o[10:8], wire_n100i_o[6:4], wire_n100i_o[2:1]}));
	defparam
		n11li.width_data = 14,
		n11li.width_sel = 14;
	oper_selector   n11lO
	( 
	.data({1'b0, wire_n10iO_dataout, wire_n10OO_dataout, wire_n1iii_dataout, wire_n1ill_dataout, wire_n1iOO_dataout, wire_n1l0l_dataout, wire_n1O0i_dataout, wire_n00il_dataout, 1'b1, wire_n0iOO_dataout, (~ n0lOil), (~ n0lOiO), (~ n0lOli), wire_n0llO_dataout, wire_n0Oii_dataout, wire_n0OlO_dataout}),
	.o(wire_n11lO_o),
	.sel({n0liii, wire_n100i_o[21:14], n0li0O, wire_n100i_o[10:6], wire_n100i_o[2:1]}));
	defparam
		n11lO.width_data = 17,
		n11lO.width_sel = 17;
	oper_selector   n11OO
	( 
	.data({1'b0, wire_n10li_dataout, wire_n1O0l_dataout, wire_n00iO_dataout, n0lO0i, n0lO0l, n0lO0O, n0lOii, n0lOil, n0lOiO, n0lOli, wire_n0lOi_dataout, wire_n0Oil_dataout, wire_n0OOi_dataout}),
	.o(wire_n11OO_o),
	.sel({n0liil, wire_n100i_o[21], wire_n100i_o[15:6], wire_n100i_o[2:1]}));
	defparam
		n11OO.width_data = 14,
		n11OO.width_sel = 14;
	oper_selector   ni0Oii
	( 
	.data({1'b1, 1'b0, wire_niO1OO_dataout}),
	.o(wire_ni0Oii_o),
	.sel({n0il0i, n0il1O, wire_nii0Ol_o[2]}));
	defparam
		ni0Oii.width_data = 3,
		ni0Oii.width_sel = 3;
	oper_selector   ni0Oli
	( 
	.data({1'b1, 1'b0, wire_niO01i_dataout}),
	.o(wire_ni0Oli_o),
	.sel({n0il0O, n0il0l, wire_nii0Ol_o[2]}));
	defparam
		ni0Oli.width_data = 3,
		ni0Oli.width_sel = 3;
	oper_selector   ni0OOl
	( 
	.data({1'b1, 1'b0, wire_niO01O_dataout}),
	.o(wire_ni0OOl_o),
	.sel({n0ilii, wire_nii0Ol_o[10], wire_nii0Ol_o[2]}));
	defparam
		ni0OOl.width_data = 3,
		ni0OOl.width_sel = 3;
	oper_selector   ni110i
	( 
	.data({niilil, wire_ni100l_dataout, wire_ni10lO_dataout, wire_ni1i0l_dataout, wire_ni1l1l_dataout, wire_ni1l0l_dataout, wire_ni1O1i_dataout, wire_ni1O0i_dataout, wire_ni1OOl_dataout, wire_ni011l_dataout, wire_ni01Oi_dataout, wire_ni001i_dataout, wire_ni00ll_dataout, wire_ni0iOi_dataout}),
	.o(wire_ni110i_o),
	.sel({n00OOO, wire_ni101l_o[13:1]}));
	defparam
		ni110i.width_data = 14,
		ni110i.width_sel = 14;
	oper_selector   ni110O
	( 
	.data({1'b0, 1'b1, wire_ni0ill_dataout}),
	.o(wire_ni110O_o),
	.sel({n0i11i, wire_ni101l_o[2:1]}));
	defparam
		ni110O.width_data = 3,
		ni110O.width_sel = 3;
	oper_selector   ni111i
	( 
	.data({1'b0, n0i10l, wire_ni1i1O_dataout, n0i1ll, wire_ni1lil_dataout, n0i01l, wire_ni1O0O_dataout, wire_ni010l_dataout, n0i0Ol, wire_ni001O_dataout, n0iili, n0il1i}),
	.o(wire_ni111i_o),
	.sel({n00OOl, wire_ni101l_o[12:7], wire_ni101l_o[5:1]}));
	defparam
		ni111i.width_data = 12,
		ni111i.width_sel = 12;
	oper_selector   ni111O
	( 
	.data({niilii, wire_ni100i_dataout, wire_ni10ll_dataout, wire_ni1i0i_dataout, wire_ni1l1i_dataout, wire_ni1l0i_dataout, wire_ni1lOO_dataout, wire_ni1O1O_dataout, wire_ni1OOi_dataout, wire_ni011i_dataout, wire_ni01lO_dataout, wire_ni01OO_dataout, wire_ni00li_dataout, wire_ni0ilO_dataout}),
	.o(wire_ni111O_o),
	.sel({n00OOO, wire_ni101l_o[13:1]}));
	defparam
		ni111O.width_data = 14,
		ni111O.width_sel = 14;
	oper_selector   ni11il
	( 
	.data({1'b0, wire_ni100O_dataout, 1'b1, wire_ni1i0O_dataout, wire_ni1l0O_dataout, wire_ni1O0l_dataout, wire_ni011O_dataout, wire_ni001l_dataout, wire_ni00lO_dataout, wire_ni0iOl_dataout, wire_ni0O1l_dataout}),
	.o(wire_ni11il_o),
	.sel({n0i10i, wire_ni101l_o[13], n0i11l, wire_ni101l_o[11], wire_ni101l_o[9], wire_ni101l_o[7], wire_ni101l_o[5], wire_ni101l_o[3:0]}));
	defparam
		ni11il.width_data = 11,
		ni11il.width_sel = 11;
	oper_selector   ni11li
	( 
	.data({1'b0, wire_ni10ii_dataout, (~ n0i1ll), wire_ni1lii_dataout, (~ n0i0il), wire_ni010i_dataout, wire_ni00Oi_dataout, wire_ni0iOO_dataout, wire_ni0O1O_dataout}),
	.o(wire_ni11li_o),
	.sel({n0i11O, wire_ni101l_o[13], wire_ni101l_o[10:9], wire_ni101l_o[6:5], wire_ni101l_o[2:0]}));
	defparam
		ni11li.width_data = 9,
		ni11li.width_sel = 9;
	oper_selector   ni11lO
	( 
	.data({1'b0, wire_ni10il_dataout, wire_ni10Oi_dataout, wire_ni1iii_dataout, n0i1ll, wire_ni1lil_dataout, n0i01l, wire_ni1O0O_dataout, 1'b1, wire_ni00Ol_dataout, wire_ni0l1i_dataout, wire_ni0O0i_dataout}),
	.o(wire_ni11lO_o),
	.sel({n0i10i, wire_ni101l_o[13:7], (((wire_ni101l_o[5] | wire_ni101l_o[3]) | wire_ni101l_o[6]) | wire_ni101l_o[4]), wire_ni101l_o[2:0]}));
	defparam
		ni11lO.width_data = 12,
		ni11lO.width_sel = 12;
	oper_selector   ni11Ol
	( 
	.data({1'b0, wire_ni10iO_dataout, wire_ni10Oi_dataout, wire_ni1iii_dataout, 1'b1, n0i0il, wire_ni010l_dataout, n0i0Ol, wire_ni001O_dataout, wire_ni00OO_dataout, wire_ni0l1l_dataout, wire_ni0O0l_dataout}),
	.o(wire_ni11Ol_o),
	.sel({n0i10i, wire_ni101l_o[13:11], (((wire_ni101l_o[9] | wire_ni101l_o[7]) | wire_ni101l_o[10]) | wire_ni101l_o[8]), wire_ni101l_o[6:0]}));
	defparam
		ni11Ol.width_data = 12,
		ni11Ol.width_sel = 12;
	oper_selector   nii00l
	( 
	.data({n0O0iO, 1'b0, {4{n0O0iO}}, wire_niO0lO_dataout, n0O0iO}),
	.o(wire_nii00l_o),
	.sel({n0iO1O, n0ilOO, wire_nii0Ol_o[11], wire_nii0Ol_o[9], wire_nii0Ol_o[5], wire_nii0Ol_o[3:1]}));
	defparam
		nii00l.width_data = 8,
		nii00l.width_sel = 8;
	oper_selector   nii01i
	( 
	.data({n0O0iO, 1'b0, {4{n0O0iO}}, wire_niO0li_dataout, n0O0iO}),
	.o(wire_nii01i_o),
	.sel({n0iO1O, n0ilOi, wire_nii0Ol_o[11], wire_nii0Ol_o[7], wire_nii0Ol_o[5], wire_nii0Ol_o[3:1]}));
	defparam
		nii01i.width_data = 8,
		nii01i.width_sel = 8;
	oper_selector   nii01O
	( 
	.data({n0O0iO, 1'b0, {5{n0O0iO}}, wire_niO0ll_dataout, n0O0iO}),
	.o(wire_nii01O_o),
	.sel({n0iO1O, n0ilOl, wire_nii0Ol_o[11], wire_nii0Ol_o[9], wire_nii0Ol_o[7], wire_nii0Ol_o[5], wire_nii0Ol_o[3:1]}));
	defparam
		nii01O.width_data = 9,
		nii01O.width_sel = 9;
	oper_selector   nii0ii
	( 
	.data({n0O0iO, 1'b0, {4{n0O0iO}}, wire_niO0Oi_dataout, n0O0iO}),
	.o(wire_nii0ii_o),
	.sel({n0iO1O, n0iO1i, wire_nii0Ol_o[11], wire_nii0Ol_o[9], wire_nii0Ol_o[7], wire_nii0Ol_o[5], wire_nii0Ol_o[2:1]}));
	defparam
		nii0ii.width_data = 8,
		nii0ii.width_sel = 8;
	oper_selector   nii0iO
	( 
	.data({n0O0iO, 1'b0, {3{n0O0iO}}, wire_niO0Ol_dataout, n0O0iO}),
	.o(wire_nii0iO_o),
	.sel({n0iO1O, n0iO1l, wire_nii0Ol_o[11], wire_nii0Ol_o[9], wire_nii0Ol_o[7], wire_nii0Ol_o[2:1]}));
	defparam
		nii0iO.width_data = 7,
		nii0iO.width_sel = 7;
	oper_selector   nii0lO
	( 
	.data({1'b0, n0O0iO}),
	.o(wire_nii0lO_o),
	.sel({n0iO0i, (~ n0iO0i)}));
	defparam
		nii0lO.width_data = 2,
		nii0lO.width_sel = 2;
	oper_selector   nii10l
	( 
	.data({1'b1, 1'b0, wire_niO00O_dataout}),
	.o(wire_nii10l_o),
	.sel({n0iliO, ((wire_nii0Ol_o[4] | wire_nii0Ol_o[7]) | wire_nii0Ol_o[3]), wire_nii0Ol_o[2]}));
	defparam
		nii10l.width_data = 3,
		nii10l.width_sel = 3;
	oper_selector   nii11l
	( 
	.data({1'b1, 1'b0, wire_niO00l_dataout}),
	.o(wire_nii11l_o),
	.sel({n0ilil, (((wire_nii0Ol_o[8] | wire_nii0Ol_o[7]) | wire_nii0Ol_o[5]) | wire_nii0Ol_o[3]), wire_nii0Ol_o[2]}));
	defparam
		nii11l.width_data = 3,
		nii11l.width_sel = 3;
	oper_selector   nii1il
	( 
	.data({1'b1, 1'b0, wire_niO0ii_dataout}),
	.o(wire_nii1il_o),
	.sel({n0illi, (((wire_nii0Ol_o[6] | wire_nii0Ol_o[4]) | wire_nii0Ol_o[5]) | wire_nii0Ol_o[3]), wire_nii0Ol_o[2]}));
	defparam
		nii1il.width_data = 3,
		nii1il.width_sel = 3;
	oper_selector   nii1ll
	( 
	.data({1'b0, n0O0iO}),
	.o(wire_nii1ll_o),
	.sel({n0illl, (~ n0illl)}));
	defparam
		nii1ll.width_data = 2,
		nii1ll.width_sel = 2;
	oper_selector   nii1Oi
	( 
	.data({n0O0iO, 1'b0, n0O0iO, wire_niO0il_dataout, n0O0iO}),
	.o(wire_nii1Oi_o),
	.sel({n0iO1O, n0illO, wire_nii0Ol_o[9], wire_nii0Ol_o[2:1]}));
	defparam
		nii1Oi.width_data = 5,
		nii1Oi.width_sel = 5;
	oper_selector   nii1OO
	( 
	.data({n0O0iO, 1'b0, {5{n0O0iO}}, wire_niO0iO_dataout, n0O0iO}),
	.o(wire_nii1OO_o),
	.sel({n0iO1O, n0ilOl, wire_nii0Ol_o[11], wire_nii0Ol_o[9], wire_nii0Ol_o[7], wire_nii0Ol_o[5], wire_nii0Ol_o[3:1]}));
	defparam
		nii1OO.width_data = 9,
		nii1OO.width_sel = 9;
	oper_selector   nl1lil
	( 
	.data({nll1OO, wire_nl010i_dataout, wire_nl01ll_dataout, wire_nl01OO_dataout, wire_nl000i_dataout, wire_nl00il_dataout}),
	.o(wire_nl1lil_o),
	.sel({n0iO0l, wire_nl1OlO_o[14:10]}));
	defparam
		nl1lil.width_data = 6,
		nl1lil.width_sel = 6;
	oper_selector   nl1O0l
	( 
	.data({wire_nl1OOO_dataout, 1'b1, wire_nl00ll_dataout, (~ n0l10i), wire_nl0iiO_dataout, wire_nl0l1O_dataout, wire_nli1iO_dataout, wire_nlii0l_dataout, wire_nlilOO_dataout, wire_nliOiO_dataout, (nll1ll & wire_nl_dataout)}),
	.o(wire_nl1O0l_o),
	.sel({wire_nl1OlO_o[15], n0iOii, wire_nl1OlO_o[10:5], wire_nl1OlO_o[2:0]}));
	defparam
		nl1O0l.width_data = 11,
		nl1O0l.width_sel = 11;
	oper_selector   nl1O1l
	( 
	.data({wire_nl1OOl_dataout, wire_nl010l_dataout, wire_nl01lO_dataout, wire_nl001i_dataout, wire_nl000l_dataout, wire_nl00iO_dataout, wire_nl0iOi_dataout, wire_nl0iii_dataout, wire_nl0l1i_dataout, wire_nli1ii_dataout, wire_nlii1O_dataout, wire_nlilOi_dataout, nll1Oi}),
	.o(wire_nl1O1l_o),
	.sel({wire_nl1OlO_o[15:4], n0iO0O}));
	defparam
		nl1O1l.width_data = 13,
		nl1O1l.width_sel = 13;
	oper_selector   nl1O1O
	( 
	.data({wire_nl1OOi_dataout, wire_nl010O_dataout, wire_nl01Oi_dataout, wire_nl001l_dataout, wire_nl000O_dataout, wire_nl00li_dataout, wire_nl0iOl_dataout, wire_nl0iil_dataout, wire_nl0l1l_dataout, wire_nli1il_dataout, wire_nlii0i_dataout, wire_nlilOl_dataout, nll1Ol}),
	.o(wire_nl1O1O_o),
	.sel({wire_nl1OlO_o[15:4], n0iO0O}));
	defparam
		nl1O1O.width_data = 13,
		nl1O1O.width_sel = 13;
	oper_selector   nl1Oii
	( 
	.data({wire_nl011i_dataout, wire_nl01ii_dataout, wire_nl01Ol_dataout, wire_nl001O_dataout, wire_nl00ii_dataout, wire_nl00lO_dataout, (~ n0l10i), wire_nl0iiO_dataout, wire_nl0l0i_dataout, wire_nli1li_dataout, wire_nlii0O_dataout, (~ n0l00l), 1'b0, wire_nliO1i_dataout, wire_nliOli_dataout}),
	.o(wire_nl1Oii_o),
	.sel({wire_nl1OlO_o[15:4], n0iOil, wire_nl1OlO_o[2:1]}));
	defparam
		nl1Oii.width_data = 15,
		nl1Oii.width_sel = 15;
	oper_selector   nl1Oil
	( 
	.data({wire_nl011l_dataout, wire_nl01ii_dataout, wire_nl01Ol_dataout, wire_nl001O_dataout, wire_nl00ii_dataout, wire_nl00lO_dataout, (~ n0l10i), wire_nl0iiO_dataout, wire_nl0l0l_dataout, wire_nli1ll_dataout, 1'b1, wire_nliO1l_dataout, wire_nliOll_dataout, 1'b0}),
	.o(wire_nl1Oil_o),
	.sel({wire_nl1OlO_o[15:6], ((wire_nl1OlO_o[5] | wire_nl1OlO_o[4]) | wire_nl1OlO_o[3]), wire_nl1OlO_o[2:0]}));
	defparam
		nl1Oil.width_data = 14,
		nl1Oil.width_sel = 14;
	oper_selector   nl1Oli
	( 
	.data({wire_nl011O_dataout, wire_nl01ii_dataout, wire_nl01Ol_dataout, wire_nl001O_dataout, wire_nl00ii_dataout, wire_nl00lO_dataout, 1'b1, wire_nl0ili_dataout, wire_nl0l0O_dataout, wire_nli1lO_dataout, (~ n0l1Oi), (~ n0l00l), 1'b0, wire_nliO1O_dataout, wire_nliOlO_dataout}),
	.o(wire_nl1Oli_o),
	.sel({wire_nl1OlO_o[15:4], n0iOil, wire_nl1OlO_o[2:1]}));
	defparam
		nl1Oli.width_data = 15,
		nl1Oli.width_sel = 15;
	oper_selector   nlOOOl
	( 
	.data({ni00O, wire_n10lO_dataout, wire_n1i0i_dataout, wire_n1iil_dataout, wire_n1ilO_dataout, wire_n1l1i_dataout}),
	.o(wire_nlOOOl_o),
	.sel({n0li1i, wire_n100i_o[20:16]}));
	defparam
		nlOOOl.width_data = 6,
		nlOOOl.width_sel = 6;
	assign
		bistdone = ((wire_nl1l_dataout | prbs_done) | (~ n0O01l14)),
		bisterr = ((wire_nl1i_dataout | prbs_err) | (~ n0O00i11)),
		cur_state = {wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout, wire_n1ll_dataout},
		err_ctl = {wire_niOO_dataout, wire_niOl_dataout},
		err_data = {wire_niOi_dataout, wire_nilO_dataout, wire_nill_dataout, wire_nili_dataout, wire_niiO_dataout, wire_niil_dataout, wire_niii_dataout, wire_ni0O_dataout, wire_ni0l_dataout, wire_ni0i_dataout, wire_ni1O_dataout, wire_ni1l_dataout, wire_ni1i_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout},
		n00OOi = ((((((((((((wire_ni101l_o[9] | wire_ni101l_o[7]) | wire_ni101l_o[5]) | wire_ni101l_o[3]) | wire_ni101l_o[2]) | wire_ni101l_o[1]) | wire_ni101l_o[0]) | wire_ni101l_o[15]) | wire_ni101l_o[14]) | wire_ni101l_o[10]) | wire_ni101l_o[8]) | wire_ni101l_o[6]) | wire_ni101l_o[4]),
		n00OOl = ((((wire_ni101l_o[13] | wire_ni101l_o[0]) | wire_ni101l_o[15]) | wire_ni101l_o[14]) | wire_ni101l_o[6]),
		n00OOO = ((wire_ni101l_o[0] | wire_ni101l_o[15]) | wire_ni101l_o[14]),
		n0i00i = ((~ n0ii1O) | (~ n0i00l)),
		n0i00l = ((((((((((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0i00O = ((~ n0ii0O) | (~ n0i0ii)),
		n0i01i = ((((((((((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ wire_nlll_dataout)) & wire_nlOi_dataout) & wire_nlil_dataout) & wire_nliO_dataout) & wire_nlli_dataout) & wire_nllO_dataout) & wire_nlOl_dataout) & wire_nlOO_dataout),
		n0i01l = ((~ n0ii1O) | (~ n0i01O)),
		n0i01O = ((((((((((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & rxd[7]) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0i0ii = ((((((((((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]) & wire_nlll_dataout) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & wire_nlli_dataout) & wire_nllO_dataout) & wire_nlOl_dataout) & wire_nlOO_dataout),
		n0i0il = ((~ n0ii1O) | (~ n0i0iO)),
		n0i0iO = ((((((((((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & (~ rxd[7])) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0i0li = ((~ n0ii1O) | (~ n0i0ll)),
		n0i0ll = ((((((((((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0i0lO = ((~ n0ii0O) | (~ n0i0Oi)),
		n0i0Oi = ((((((((((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])) & wire_nlll_dataout) & wire_nlOi_dataout) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & wire_nlli_dataout) & wire_nllO_dataout) & wire_nlOl_dataout) & (~ wire_nlOO_dataout)),
		n0i0Ol = ((~ n0ii1O) | (~ n0i0OO)),
		n0i0OO = ((((((((((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & (~ rxd[6])) & (~ rxd[7])) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0i10i = (wire_ni101l_o[15] | wire_ni101l_o[14]),
		n0i10l = ((~ n0ii1O) | (~ n0i10O)),
		n0i10O = (((((((((((((((rxd[0] & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0i11i = (((((((((((((wire_ni101l_o[13] | wire_ni101l_o[11]) | wire_ni101l_o[9]) | wire_ni101l_o[7]) | wire_ni101l_o[5]) | wire_ni101l_o[3]) | wire_ni101l_o[0]) | wire_ni101l_o[15]) | wire_ni101l_o[14]) | wire_ni101l_o[12]) | wire_ni101l_o[10]) | wire_ni101l_o[8]) | wire_ni101l_o[6]) | wire_ni101l_o[4]),
		n0i11l = ((((wire_ni101l_o[12] | wire_ni101l_o[10]) | wire_ni101l_o[8]) | wire_ni101l_o[6]) | wire_ni101l_o[4]),
		n0i11O = (((((((wire_ni101l_o[11] | wire_ni101l_o[7]) | wire_ni101l_o[3]) | wire_ni101l_o[15]) | wire_ni101l_o[14]) | wire_ni101l_o[12]) | wire_ni101l_o[8]) | wire_ni101l_o[4]),
		n0i1ii = ((~ n0ii1O) | (~ n0i1il)),
		n0i1il = ((((((((((((((((~ rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0i1iO = ((~ n0ii0O) | (~ n0i1li)),
		n0i1li = ((((((((((((((((~ rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & wire_nlll_dataout) & wire_nlOi_dataout) & wire_nlil_dataout) & (~ wire_nliO_dataout)) & wire_nlli_dataout) & wire_nllO_dataout) & wire_nlOl_dataout) & wire_nlOO_dataout),
		n0i1ll = ((~ n0ii1O) | (~ n0i1lO)),
		n0i1lO = (((((((((((((((rxd[0] & rxd[1]) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0i1Oi = ((~ n0ii1O) | (~ n0i1Ol)),
		n0i1Ol = ((((((((((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0i1OO = ((~ n0ii0O) | (~ n0i01i)),
		n0ii0i = ((~ n0ii0O) | (~ n0ii0l)),
		n0ii0l = ((((((((((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])) & wire_nlll_dataout) & wire_nlOi_dataout) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & wire_nlli_dataout) & wire_nllO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0ii0O = (rxc[0] & wire_nlii_dataout),
		n0ii1i = ((~ n0ii1O) | (~ n0ii1l)),
		n0ii1l = ((((((((((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0ii1O = (rxc[0] & (~ wire_nlii_dataout)),
		n0iiii = (((((((niiOOO & niiOOl) & niiOOi) & niiOlO) & niiOll) & niiOli) & niiOiO) & niiOil),
		n0iiil = (n0O0iO & n0iiiO),
		n0iiiO = ((((((niilOO & niilOl) & niilOi) & niillO) & niilll) & niilli) & niiliO),
		n0iili = ((~ n0iill) | (~ ((~ rxc[0]) & (~ wire_nlii_dataout)))),
		n0iill = ((((((((((((((((~ (rxd[0] ^ wire_niO1OO_dataout)) & (~ (rxd[1] ^ wire_niO01i_dataout))) & (~ (rxd[2] ^ wire_niO01l_dataout))) & (~ (rxd[3] ^ wire_niO01O_dataout))) & (~ (rxd[4] ^ wire_niO00i_dataout))) & (~ (rxd[5] ^ wire_niO00l_dataout))) & (~ (rxd[6] ^ wire_niO00O_dataout))) & (~ (rxd[7] ^ wire_niO0ii_dataout))) & (~ (n0O0iO ^ wire_nlil_dataout))) & (~ (wire_nliO_dataout ^ wire_niO0il_dataout))) & (~ (wire_nlli_dataout ^ wire_niO0iO_dataout))) & (~ (wire_nlll_dataout ^ wire_niO0li_dataout))) & (~ (wire_nllO_dataout ^ wire_niO0ll_dataout))) & (~ (wire_nlOi_dataout ^ wire_niO0lO_dataout))) & (~ (wire_nlOl_dataout ^ wire_niO0Oi_dataout))) & (~ (wire_nlOO_dataout ^ wire_niO0Ol_dataout))),
		n0iilO = ((~ n0O0iO) & (rxc[0] & n0iiOi)),
		n0iiOi = (((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iiOl = (n0O0iO & (wire_nlii_dataout & n0iiOO)),
		n0iiOO = (((((((wire_nlll_dataout & wire_nlOi_dataout) & wire_nlil_dataout) & wire_nliO_dataout) & (~ wire_nlli_dataout)) & wire_nllO_dataout) & wire_nlOl_dataout) & wire_nlOO_dataout),
		n0il0i = ((((((wire_nii0Ol_o[12] | wire_nii0Ol_o[10]) | wire_nii0Ol_o[1]) | wire_nii0Ol_o[15]) | wire_nii0Ol_o[14]) | wire_nii0Ol_o[13]) | wire_nii0Ol_o[0]),
		n0il0l = (((((((wire_nii0Ol_o[12] | wire_nii0Ol_o[8]) | wire_nii0Ol_o[6]) | wire_nii0Ol_o[4]) | wire_nii0Ol_o[9]) | wire_nii0Ol_o[7]) | wire_nii0Ol_o[5]) | wire_nii0Ol_o[3]),
		n0il0O = ((((((wire_nii0Ol_o[10] | wire_nii0Ol_o[1]) | wire_nii0Ol_o[15]) | wire_nii0Ol_o[14]) | wire_nii0Ol_o[13]) | wire_nii0Ol_o[0]) | wire_nii0Ol_o[11]),
		n0il1i = (((((((niiOOO & niiOOl) & niiOOi) & niiOlO) & niiOll) & niiOli) & niiOiO) & niiOil),
		n0il1l = (niil0i & wire_nO_dataout),
		n0il1O = (((((((wire_nii0Ol_o[8] | wire_nii0Ol_o[6]) | wire_nii0Ol_o[4]) | wire_nii0Ol_o[11]) | wire_nii0Ol_o[9]) | wire_nii0Ol_o[7]) | wire_nii0Ol_o[5]) | wire_nii0Ol_o[3]),
		n0ilii = (((((((((((((wire_nii0Ol_o[12] | wire_nii0Ol_o[1]) | wire_nii0Ol_o[15]) | wire_nii0Ol_o[14]) | wire_nii0Ol_o[13]) | wire_nii0Ol_o[0]) | wire_nii0Ol_o[8]) | wire_nii0Ol_o[6]) | wire_nii0Ol_o[4]) | wire_nii0Ol_o[11]) | wire_nii0Ol_o[9]) | wire_nii0Ol_o[7]) | wire_nii0Ol_o[5]) | wire_nii0Ol_o[3]),
		n0ilil = ((((((((((wire_nii0Ol_o[12] | wire_nii0Ol_o[10]) | wire_nii0Ol_o[1]) | wire_nii0Ol_o[15]) | wire_nii0Ol_o[14]) | wire_nii0Ol_o[13]) | wire_nii0Ol_o[0]) | wire_nii0Ol_o[6]) | wire_nii0Ol_o[4]) | wire_nii0Ol_o[11]) | wire_nii0Ol_o[9]),
		n0iliO = (((((((((((wire_nii0Ol_o[12] | wire_nii0Ol_o[10]) | wire_nii0Ol_o[1]) | wire_nii0Ol_o[15]) | wire_nii0Ol_o[14]) | wire_nii0Ol_o[13]) | wire_nii0Ol_o[0]) | wire_nii0Ol_o[8]) | wire_nii0Ol_o[6]) | wire_nii0Ol_o[11]) | wire_nii0Ol_o[9]) | wire_nii0Ol_o[5]),
		n0illi = ((((((((((wire_nii0Ol_o[12] | wire_nii0Ol_o[10]) | wire_nii0Ol_o[1]) | wire_nii0Ol_o[15]) | wire_nii0Ol_o[14]) | wire_nii0Ol_o[13]) | wire_nii0Ol_o[0]) | wire_nii0Ol_o[8]) | wire_nii0Ol_o[11]) | wire_nii0Ol_o[9]) | wire_nii0Ol_o[7]),
		n0illl = (((((((wire_nii0Ol_o[12] | wire_nii0Ol_o[10]) | wire_nii0Ol_o[8]) | wire_nii0Ol_o[6]) | wire_nii0Ol_o[4]) | wire_nii0Ol_o[7]) | wire_nii0Ol_o[5]) | wire_nii0Ol_o[3]),
		n0illO = ((((((((wire_nii0Ol_o[12] | wire_nii0Ol_o[10]) | wire_nii0Ol_o[8]) | wire_nii0Ol_o[6]) | wire_nii0Ol_o[4]) | wire_nii0Ol_o[11]) | wire_nii0Ol_o[7]) | wire_nii0Ol_o[5]) | wire_nii0Ol_o[3]),
		n0ilOi = (((((wire_nii0Ol_o[12] | wire_nii0Ol_o[10]) | wire_nii0Ol_o[8]) | wire_nii0Ol_o[6]) | wire_nii0Ol_o[4]) | wire_nii0Ol_o[9]),
		n0ilOl = ((((wire_nii0Ol_o[12] | wire_nii0Ol_o[10]) | wire_nii0Ol_o[8]) | wire_nii0Ol_o[6]) | wire_nii0Ol_o[4]),
		n0ilOO = (((((wire_nii0Ol_o[12] | wire_nii0Ol_o[10]) | wire_nii0Ol_o[8]) | wire_nii0Ol_o[6]) | wire_nii0Ol_o[4]) | wire_nii0Ol_o[7]),
		n0iO0i = (((((wire_nii0Ol_o[2] | wire_nii0Ol_o[12]) | wire_nii0Ol_o[10]) | wire_nii0Ol_o[8]) | wire_nii0Ol_o[6]) | wire_nii0Ol_o[4]),
		n0iO0l = ((((((((((wire_nl1OlO_o[15] | wire_nl1OlO_o[9]) | wire_nl1OlO_o[8]) | wire_nl1OlO_o[7]) | wire_nl1OlO_o[6]) | wire_nl1OlO_o[5]) | wire_nl1OlO_o[2]) | wire_nl1OlO_o[1]) | wire_nl1OlO_o[0]) | wire_nl1OlO_o[4]) | wire_nl1OlO_o[3]),
		n0iO0O = (((wire_nl1OlO_o[2] | wire_nl1OlO_o[1]) | wire_nl1OlO_o[0]) | wire_nl1OlO_o[3]),
		n0iO1i = (((((wire_nii0Ol_o[12] | wire_nii0Ol_o[10]) | wire_nii0Ol_o[8]) | wire_nii0Ol_o[6]) | wire_nii0Ol_o[4]) | wire_nii0Ol_o[3]),
		n0iO1l = ((((((wire_nii0Ol_o[12] | wire_nii0Ol_o[10]) | wire_nii0Ol_o[8]) | wire_nii0Ol_o[6]) | wire_nii0Ol_o[4]) | wire_nii0Ol_o[5]) | wire_nii0Ol_o[3]),
		n0iO1O = (((wire_nii0Ol_o[15] | wire_nii0Ol_o[14]) | wire_nii0Ol_o[13]) | wire_nii0Ol_o[0]),
		n0iOii = (((((wire_nl1OlO_o[14] | wire_nl1OlO_o[13]) | wire_nl1OlO_o[12]) | wire_nl1OlO_o[11]) | wire_nl1OlO_o[4]) | wire_nl1OlO_o[3]),
		n0iOil = (wire_nl1OlO_o[0] | wire_nl1OlO_o[3]),
		n0iOiO = ((~ rxc[0]) | (~ n0iOli)),
		n0iOli = (((((((((((((((rxd[0] & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0iOll = (((((((((((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlOl_dataout)) & (~ (n0O0iO ^ wire_nlli_dataout))) & (~ (n0O0iO ^ wire_nlll_dataout))) & (~ (n0O0iO ^ wire_nllO_dataout))) & (~ (n0O0iO ^ wire_nlOi_dataout))) & (~ (n0O0iO ^ wire_nlOO_dataout))),
		n0iOlO = ((((((((((((((((~ rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlOl_dataout)) & (~ (n0O0iO ^ wire_nlli_dataout))) & (~ (n0O0iO ^ wire_nlll_dataout))) & (~ (n0O0iO ^ wire_nllO_dataout))) & (~ (n0O0iO ^ wire_nlOi_dataout))) & (~ (n0O0iO ^ wire_nlOO_dataout))),
		n0iOOi = (((((((((((((((rxd[0] & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlOl_dataout)) & (~ (n0O0iO ^ wire_nlli_dataout))) & (~ (n0O0iO ^ wire_nlll_dataout))) & (~ (n0O0iO ^ wire_nllO_dataout))) & (~ (n0O0iO ^ wire_nlOi_dataout))) & (~ (n0O0iO ^ wire_nlOO_dataout))),
		n0iOOl = ((~ n0iOOO) | (~ ((~ rxc[0]) & wire_nlii_dataout))),
		n0iOOO = (((((((((((((((rxd[0] & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ wire_nliO_dataout)) & (~ (n0O0iO ^ wire_nlil_dataout))) & (~ (n0O0iO ^ wire_nlli_dataout))) & (~ (n0O0iO ^ wire_nlll_dataout))) & (~ (n0O0iO ^ wire_nllO_dataout))) & (~ (n0O0iO ^ wire_nlOi_dataout))) & (~ (n0O0iO ^ wire_nlOl_dataout))) & (~ (n0O0iO ^ wire_nlOO_dataout))),
		n0l00i = (((((((((~ nllili) & nlliiO) & (~ nlliil)) & (~ nlliii)) & (~ nlli0O)) & (~ nlli0l)) & (~ nlli0i)) & nlli1O) & (~ nlli1l)),
		n0l00l = (((((((((((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])) & (~ wire_nlil_dataout)) & (~ wire_nlOO_dataout)) & (~ (n0O0iO ^ wire_nliO_dataout))) & (~ (n0O0iO ^ wire_nlli_dataout))) & (~ (n0O0iO ^ wire_nlll_dataout))) & (~ (n0O0iO ^ wire_nllO_dataout))) & (~ (n0O0iO ^ wire_nlOi_dataout))) & (~ (n0O0iO ^ wire_nlOl_dataout))),
		n0l00O = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		n0l01i = (((((((((~ nllili) & nlliiO) & (~ nlliil)) & (~ nlliii)) & (~ nlli0O)) & (~ nlli0l)) & (~ nlli0i)) & nlli1O) & nlli1l),
		n0l01l = ((((((((nllili & (~ nlliiO)) & (~ nlliil)) & (~ nlliii)) & (~ nlli0O)) & (~ nlli0l)) & nlli0i) & nlli1O) & (~ nlli1l)),
		n0l01O = (((((((((~ nllili) & (~ nlliiO)) & nlliil) & (~ nlliii)) & (~ nlli0O)) & (~ nlli0l)) & (~ nlli0i)) & (~ nlli1O)) & (~ nlli1l)),
		n0l0ii = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		n0l0il = (n0l0lO & n0l0iO),
		n0l0iO = (rcxpat_chnl_sel[0] & rcxpat_chnl_sel[1]),
		n0l0li = (n0l0lO & n0l0ll),
		n0l0ll = (n0l0ii | n0l00O),
		n0l0lO = (((((((rxd[0] & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0l0Oi = (rxc[0] & (n0l0OO & n0l0Ol)),
		n0l0Ol = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		n0l0OO = (((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0l10i = (((((((((((((((rxd[5] & rxd[7]) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ ((~ n0O0iO) ^ rxd[0]))) & (~ ((~ n0O0iO) ^ rxd[1]))) & (~ (n0O0iO ^ rxd[2]))) & (~ ((~ n0O0iO) ^ rxd[3]))) & (~ (n0O0iO ^ rxd[4]))) & (~ (n0O0iO ^ rxd[6]))) & (~ (n0O0iO ^ wire_nlil_dataout))) & (~ (n0O0iO ^ wire_nliO_dataout))) & (~ (n0O0iO ^ wire_nlll_dataout))) & (~ (n0O0iO ^ wire_nlOi_dataout))) & (~ (n0O0iO ^ wire_nlOO_dataout))),
		n0l10l = (((((((((((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & rxd[5]) & rxd[6]) & rxd[7]) & (~ wire_nlll_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ (n0O0iO ^ wire_nlli_dataout))) & (~ (n0O0iO ^ wire_nllO_dataout))) & (~ (n0O0iO ^ wire_nlOi_dataout))) & (~ (n0O0iO ^ wire_nlOl_dataout))) & (~ (n0O0iO ^ wire_nlOO_dataout))),
		n0l10O = (((~ nll0lO) & nll0li) & nll0il),
		n0l11i = (((((((((((((((rxd[0] & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ wire_nlll_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlOl_dataout)) & (~ (n0O0iO ^ wire_nlil_dataout))) & (~ (n0O0iO ^ wire_nlli_dataout))) & (~ (n0O0iO ^ wire_nllO_dataout))) & (~ (n0O0iO ^ wire_nlOi_dataout))) & (~ (n0O0iO ^ wire_nlOO_dataout))),
		n0l11l = ((((((~ nll00O) & nll00l) & (~ nll00i)) & (~ nll01O)) & nll01l) & nll01i),
		n0l11O = (((((nll00O & (~ nll00l)) & (~ nll00i)) & nll01O) & nll01l) & nll01i),
		n0l1ii = ((nll0lO & nll0li) & nll0il),
		n0l1il = ((((((((((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ (n0O0iO ^ wire_nlil_dataout))) & (~ (n0O0iO ^ wire_nliO_dataout))) & (~ (n0O0iO ^ wire_nlll_dataout))) & (~ (n0O0iO ^ wire_nlOi_dataout))) & (~ (n0O0iO ^ wire_nlOl_dataout))) & (~ (n0O0iO ^ wire_nlOO_dataout))),
		n0l1iO = ((((~ nlli1i) & (~ nll0OO)) & nll0Ol) & (~ nll0Oi)),
		n0l1li = ((((~ nlli1i) & nll0OO) & nll0Ol) & nll0Oi),
		n0l1ll = (((nlli1i & nll0OO) & nll0Ol) & nll0Oi),
		n0l1lO = (((((~ nlli1i) & (~ nll0OO)) & nll0Ol) & nll0Oi) | (((nlli1i & (~ nll0OO)) & nll0Ol) & nll0Oi)),
		n0l1Oi = ((((((((((((((((~ rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & (~ rxd[7])) & (~ wire_nlil_dataout)) & (~ wire_nlOO_dataout)) & (~ (n0O0iO ^ wire_nliO_dataout))) & (~ (n0O0iO ^ wire_nlli_dataout))) & (~ (n0O0iO ^ wire_nlll_dataout))) & (~ (n0O0iO ^ wire_nllO_dataout))) & (~ (n0O0iO ^ wire_nlOi_dataout))) & (~ (n0O0iO ^ wire_nlOl_dataout))),
		n0l1Ol = ((((((((nllili & (~ nlliiO)) & (~ nlliil)) & (~ nlliii)) & (~ nlli0O)) & (~ nlli0l)) & nlli0i) & nlli1O) & nlli1l),
		n0l1OO = (((((((((~ nllili) & (~ nlliiO)) & nlliil) & (~ nlliii)) & (~ nlli0O)) & (~ nlli0l)) & (~ nlli0i)) & (~ nlli1O)) & nlli1l),
		n0li0i = ((((((((((wire_n100i_o[31] | wire_n100i_o[30]) | wire_n100i_o[29]) | wire_n100i_o[28]) | wire_n100i_o[27]) | wire_n100i_o[26]) | wire_n100i_o[25]) | wire_n100i_o[24]) | wire_n100i_o[23]) | wire_n100i_o[22]) | wire_n100i_o[3]),
		n0li0l = ((((((((((((((((((wire_n100i_o[16] | wire_n100i_o[11]) | wire_n100i_o[7]) | wire_n100i_o[0]) | wire_n100i_o[31]) | wire_n100i_o[30]) | wire_n100i_o[29]) | wire_n100i_o[28]) | wire_n100i_o[27]) | wire_n100i_o[26]) | wire_n100i_o[25]) | wire_n100i_o[24]) | wire_n100i_o[23]) | wire_n100i_o[22]) | wire_n100i_o[3]) | wire_n100i_o[20]) | wire_n100i_o[19]) | wire_n100i_o[18]) | wire_n100i_o[17]),
		n0li0O = (((((wire_n100i_o[13] | wire_n100i_o[12]) | wire_n100i_o[11]) | wire_n100i_o[5]) | wire_n100i_o[4]) | wire_n100i_o[3]),
		n0li1i = ((((((((((((((((((((((((((wire_n100i_o[21] | wire_n100i_o[15]) | wire_n100i_o[14]) | wire_n100i_o[13]) | wire_n100i_o[12]) | wire_n100i_o[11]) | wire_n100i_o[10]) | wire_n100i_o[9]) | wire_n100i_o[8]) | wire_n100i_o[7]) | wire_n100i_o[6]) | wire_n100i_o[5]) | wire_n100i_o[4]) | wire_n100i_o[2]) | wire_n100i_o[1]) | wire_n100i_o[0]) | wire_n100i_o[31]) | wire_n100i_o[30]) | wire_n100i_o[29]) | wire_n100i_o[28]) | wire_n100i_o[27]) | wire_n100i_o[26]) | wire_n100i_o[25]) | wire_n100i_o[24]) | wire_n100i_o[23]) | wire_n100i_o[22]) | wire_n100i_o[3]),
		n0li1l = (((((((((((((((((((((((((((((wire_n100i_o[21] | wire_n100i_o[16]) | wire_n100i_o[13]) | wire_n100i_o[12]) | wire_n100i_o[11]) | wire_n100i_o[10]) | wire_n100i_o[9]) | wire_n100i_o[8]) | wire_n100i_o[7]) | wire_n100i_o[6]) | wire_n100i_o[5]) | wire_n100i_o[4]) | wire_n100i_o[2]) | wire_n100i_o[1]) | wire_n100i_o[0]) | wire_n100i_o[31]) | wire_n100i_o[30]) | wire_n100i_o[29]) | wire_n100i_o[28]) | wire_n100i_o[27]) | wire_n100i_o[26]) | wire_n100i_o[25]) | wire_n100i_o[24]) | wire_n100i_o[23]) | wire_n100i_o[22]) | wire_n100i_o[3]) | wire_n100i_o[20]) | wire_n100i_o[19]) | wire_n100i_o[18]) | wire_n100i_o[17]),
		n0li1O = (((((((((((((wire_n100i_o[2] | wire_n100i_o[1]) | wire_n100i_o[0]) | wire_n100i_o[31]) | wire_n100i_o[30]) | wire_n100i_o[29]) | wire_n100i_o[28]) | wire_n100i_o[27]) | wire_n100i_o[26]) | wire_n100i_o[25]) | wire_n100i_o[24]) | wire_n100i_o[23]) | wire_n100i_o[22]) | wire_n100i_o[3]),
		n0liii = ((((((((((wire_n100i_o[0] | wire_n100i_o[31]) | wire_n100i_o[30]) | wire_n100i_o[29]) | wire_n100i_o[28]) | wire_n100i_o[27]) | wire_n100i_o[26]) | wire_n100i_o[25]) | wire_n100i_o[24]) | wire_n100i_o[23]) | wire_n100i_o[22]),
		n0liil = ((((((((((((((((((wire_n100i_o[16] | wire_n100i_o[5]) | wire_n100i_o[4]) | wire_n100i_o[0]) | wire_n100i_o[31]) | wire_n100i_o[30]) | wire_n100i_o[29]) | wire_n100i_o[28]) | wire_n100i_o[27]) | wire_n100i_o[26]) | wire_n100i_o[25]) | wire_n100i_o[24]) | wire_n100i_o[23]) | wire_n100i_o[22]) | wire_n100i_o[3]) | wire_n100i_o[20]) | wire_n100i_o[19]) | wire_n100i_o[18]) | wire_n100i_o[17]),
		n0liOO = ((((((((((((wire_n100i_o[0] | wire_n100i_o[31]) | wire_n100i_o[30]) | wire_n100i_o[29]) | wire_n100i_o[28]) | wire_n100i_o[27]) | wire_n100i_o[26]) | wire_n100i_o[25]) | wire_n100i_o[24]) | wire_n100i_o[23]) | wire_n100i_o[22]) | wire_n100i_o[3]) | (~ n0ll1i41)),
		n0ll0l = (((~ rxc[0]) | (~ n0llil)) | (~ n0ll0O32)),
		n0llil = (((((((rxd[0] & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0lliO = (((((((rxd[0] & (~ rxd[1])) & (~ rxd[2])) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0llli = (((((((rxd[0] & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & (~ rxd[4])) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])),
		n0llll = (((((((rxd[0] & (~ rxd[1])) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & (~ rxd[7])),
		n0lllO = (((~ n0llOO) | (~ ((~ rxc[0]) & wire_nlii_dataout))) | (~ n0llOi29)),
		n0llOO = ((((((((((((((((~ rxd[0]) & (~ rxd[1])) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ wire_nliO_dataout)) & (~ (n0O0iO ^ wire_nlil_dataout))) & (~ (n0O0iO ^ wire_nlli_dataout))) & (~ (n0O0iO ^ wire_nlll_dataout))) & (~ (n0O0iO ^ wire_nllO_dataout))) & (~ (n0O0iO ^ wire_nlOi_dataout))) & (~ (n0O0iO ^ wire_nlOl_dataout))) & (~ (n0O0iO ^ wire_nlOO_dataout))),
		n0lO0i = (((((((((((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0lO0l = ((((((((((((((((~ rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])) & (~ wire_nlli_dataout)) & (~ (n0O0iO ^ wire_nlil_dataout))) & (~ (n0O0iO ^ wire_nliO_dataout))) & (~ (n0O0iO ^ wire_nlll_dataout))) & (~ (n0O0iO ^ wire_nllO_dataout))) & (~ (n0O0iO ^ wire_nlOi_dataout))) & (~ (n0O0iO ^ wire_nlOl_dataout))) & (~ (n0O0iO ^ wire_nlOO_dataout))),
		n0lO0O = ((((((((((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0lO1i = (((((((((((((((rxd[0] & (~ rxd[1])) & (~ rxd[2])) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0lO1l = (((((((((((((((rxd[0] & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & (~ rxd[6])) & (~ rxd[7])) & (~ wire_nlOi_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nlOO_dataout)) & (~ (n0O0iO ^ wire_nlil_dataout))) & (~ (n0O0iO ^ wire_nlll_dataout))) & (~ (n0O0iO ^ wire_nllO_dataout))) & (~ (n0O0iO ^ wire_nlOl_dataout))),
		n0lO1O = ((((ni0ll & ni0li) & ni0iO) & ni0il) & (~ ni0ii)),
		n0lOii = (((((((((((((((rxd[0] & rxd[1]) & (~ rxd[2])) & (~ rxd[3])) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)) & (~ (n0O0iO ^ wire_nlli_dataout))) & (~ (n0O0iO ^ wire_nllO_dataout))),
		n0lOil = (((((((((((((((rxd[0] & rxd[1]) & rxd[2]) & rxd[3]) & (~ rxd[4])) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0lOiO = (((((((((((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & rxd[5]) & rxd[6]) & (~ rxd[7])) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ (n0O0iO ^ wire_nlil_dataout))) & (~ (n0O0iO ^ wire_nliO_dataout))) & (~ (n0O0iO ^ wire_nlli_dataout))) & (~ (n0O0iO ^ wire_nlll_dataout))) & (~ (n0O0iO ^ wire_nlOO_dataout))),
		n0lOli = (((((((((((((((rxd[0] & rxd[1]) & rxd[2]) & (~ rxd[3])) & (~ rxd[4])) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0lOll = (((((((((((((((rxd[0] & rxd[1]) & (~ rxd[2])) & (~ rxd[3])) & (~ rxd[4])) & rxd[5]) & (~ rxd[6])) & (~ rxd[7])) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOO_dataout)) & (~ (n0O0iO ^ wire_nlil_dataout))) & (~ (n0O0iO ^ wire_nliO_dataout))) & (~ (n0O0iO ^ wire_nlli_dataout))) & (~ (n0O0iO ^ wire_nlOl_dataout))),
		n0lOlO = (((((((((((((((rxd[0] & rxd[1]) & rxd[2]) & (~ rxd[3])) & rxd[4]) & (~ rxd[5])) & rxd[6]) & rxd[7]) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlil_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlOl_dataout)) & (~ wire_nlOO_dataout)),
		n0lOOi = ((((((((((((((((~ rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ wire_nlll_dataout)) & (~ wire_nlOi_dataout)) & (~ (n0O0iO ^ wire_nlil_dataout))) & (~ (n0O0iO ^ wire_nliO_dataout))) & (~ (n0O0iO ^ wire_nlli_dataout))) & (~ (n0O0iO ^ wire_nllO_dataout))) & (~ (n0O0iO ^ wire_nlOl_dataout))) & (~ (n0O0iO ^ wire_nlOO_dataout))),
		n0lOOl = (n0O10O & n0lOOO),
		n0lOOO = (rcxpat_chnl_sel[0] & rcxpat_chnl_sel[1]),
		n0O00O = (((~ rbist_sel[0]) & (~ rbist_sel[1])) & n0O1OO17),
		n0O0ii = (rbist_sel[0] & (~ rbist_sel[1])),
		n0O0il = (((~ rbist_sel[0]) & rbist_sel[1]) & n0O1Oi20),
		n0O0iO = ((rpmadwidth_rx & rpma_doublewidth_rx) | n0O0li),
		n0O0li = (((rpmadwidth_rx & (~ rpma_doublewidth_rx)) & rdwidth_rx) & n0O0ll8),
		n0O10i = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		n0O10l = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		n0O10O = (((((((rxd[0] & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0O11i = (n0O10O & ((n0O10l | n0O10i) | (~ n0O11l26))),
		n0O1ii = (((n0O1ll & n0O1li) & rxc[0]) & n0O1il23),
		n0O1li = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		n0O1ll = (((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0O1lO = 1'b1,
		selftest_done = wire_nl1l_dataout,
		selftest_err = wire_nl1i_dataout;
endmodule //stratixiigx_hssi_rx_bist_ver
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 511 mux21 1053 oper_add 22 oper_decoder 6 oper_less_than 20 oper_selector 14 ram20x16_syn 2 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_rx_comp_chnl_top
	( 
	align_status,
	align_status_sync,
	align_status_sync_0,
	align_status_sync_2,
	audi,
	audi_pre,
	clk_1,
	clk_2,
	cmpfifourst,
	comp_curr_st,
	cudi,
	cudi_valid,
	disable_fifo_rd,
	disable_fifo_rd_0,
	disable_fifo_rd_2,
	disable_fifo_wr,
	disable_fifo_wr_0,
	disable_fifo_wr_2,
	dskwclksel,
	fifo_cnt,
	fifo_rd_in_comp_0,
	fifo_rd_in_comp_2,
	fifo_rd_out_comp,
	hard_reset,
	is_lane0,
	ralempty,
	ralfull,
	rclkcmpinsertpad,
	rclkcmppos,
	rclkcmpsq1n,
	rclkcmpsq1p,
	rclkcmpsqmd,
	rcmpfifourst,
	rdenable,
	rdfifo_almost_empty,
	rdfifo_almost_full,
	rdfifo_empty,
	rdfifo_full,
	rdwidth_rx,
	rev_loop_data,
	rgenericfifo,
	rmatchen,
	rrx_pipe_enable,
	rskpsetbased,
	rtruebac2bac,
	rwa_6g_en,
	scan_mode,
	soft_reset,
	sudi,
	sudi_pre,
	sync_status,
	wrenable) /* synthesis synthesis_clearbox=1 */;
	input   align_status;
	output   align_status_sync;
	input   align_status_sync_0;
	input   align_status_sync_2;
	input   [13:0]  audi;
	input   [13:0]  audi_pre;
	input   clk_1;
	input   clk_2;
	input   cmpfifourst;
	output   [1:0]  comp_curr_st;
	output   [31:0]  cudi;
	output   cudi_valid;
	output   disable_fifo_rd;
	input   disable_fifo_rd_0;
	input   disable_fifo_rd_2;
	output   disable_fifo_wr;
	input   disable_fifo_wr_0;
	input   disable_fifo_wr_2;
	input   [1:0]  dskwclksel;
	output   [4:0]  fifo_cnt;
	input   fifo_rd_in_comp_0;
	input   fifo_rd_in_comp_2;
	output   fifo_rd_out_comp;
	input   hard_reset;
	input   is_lane0;
	input   [3:0]  ralempty;
	input   [3:0]  ralfull;
	input   rclkcmpinsertpad;
	input   rclkcmppos;
	input   [19:0]  rclkcmpsq1n;
	input   [19:0]  rclkcmpsq1p;
	input   rclkcmpsqmd;
	input   rcmpfifourst;
	input   rdenable;
	output   rdfifo_almost_empty;
	output   rdfifo_almost_full;
	output   rdfifo_empty;
	output   rdfifo_full;
	input   rdwidth_rx;
	output   [19:0]  rev_loop_data;
	input   rgenericfifo;
	input   rmatchen;
	input   rrx_pipe_enable;
	input   rskpsetbased;
	input   rtruebac2bac;
	input   rwa_6g_en;
	input   scan_mode;
	input   soft_reset;
	input   [27:0]  sudi;
	input   [13:0]  sudi_pre;
	input   sync_status;
	input   wrenable;

	reg	nliOO0i55;
	reg	nliOO0i56;
	reg	nliOO0i57;
	reg	nliOO1l58;
	reg	nliOO1l59;
	reg	nliOO1l60;
	reg	nliOOil52;
	reg	nliOOil53;
	reg	nliOOil54;
	reg	nll100O19;
	reg	nll100O20;
	reg	nll100O21;
	reg	nll101i25;
	reg	nll101i26;
	reg	nll101i27;
	reg	nll101O22;
	reg	nll101O23;
	reg	nll101O24;
	reg	nll10li16;
	reg	nll10li17;
	reg	nll10li18;
	reg	nll10lO13;
	reg	nll10lO14;
	reg	nll10lO15;
	reg	nll10Ol10;
	reg	nll10Ol11;
	reg	nll10Ol12;
	reg	nll110l40;
	reg	nll110l41;
	reg	nll110l42;
	reg	nll110O37;
	reg	nll110O38;
	reg	nll110O39;
	reg	nll111i49;
	reg	nll111i50;
	reg	nll111i51;
	reg	nll111l46;
	reg	nll111l47;
	reg	nll111l48;
	reg	nll111O43;
	reg	nll111O44;
	reg	nll111O45;
	reg	nll11ii34;
	reg	nll11ii35;
	reg	nll11ii36;
	reg	nll11il31;
	reg	nll11il32;
	reg	nll11il33;
	reg	nll11Ol28;
	reg	nll11Ol29;
	reg	nll11Ol30;
	reg	nll1i1l7;
	reg	nll1i1l8;
	reg	nll1i1l9;
	reg	nll1iii4;
	reg	nll1iii5;
	reg	nll1iii6;
	reg	nll1iOi1;
	reg	nll1iOi2;
	reg	nll1iOi3;
	reg	n0OilO;
	reg	n0OiOl;
	reg	nllll0O;
	reg	nllllii;
	reg	n0Olii;
	wire	wire_n0Ol0O_ENA;
	reg	n0OiOO;
	reg	n0Ol0i;
	reg	n0Ol1i;
	reg	n0Ol1l;
	reg	nllllil;
	reg	nlllliO;
	reg	nllllli;
	reg	nllllll;
	reg	n0OliO;
	wire	wire_n0Olil_ENA;
	reg	n0Olll;
	wire	wire_n0Olli_ENA;
	reg	n0OlOi;
	wire	wire_n0OllO_ENA;
	reg	n0OlOO;
	wire	wire_n0OlOl_ENA;
	reg	n0OO0O;
	wire	wire_n0OO0l_ENA;
	reg	n0OO1l;
	wire	wire_n0OO1i_ENA;
	reg	n0OO0i;
	wire	wire_n0OO1O_ENA;
	reg	n0OOil;
	wire	wire_n0OOii_ENA;
	reg	n0OOli;
	wire	wire_n0OOiO_ENA;
	reg	n0OOlO;
	wire	wire_n0OOll_ENA;
	reg	n0OOOl;
	wire	wire_n0OOOi_ENA;
	reg	ni111i;
	wire	wire_n0OOOO_ENA;
	reg	ni110l;
	wire	wire_ni110i_ENA;
	reg	ni11ii;
	wire	wire_ni110O_ENA;
	reg	ni111O;
	wire	wire_ni111l_ENA;
	reg	ni11iO;
	wire	wire_ni11il_ENA;
	reg	ni11ll;
	wire	wire_ni11li_ENA;
	reg	ni11Oi;
	wire	wire_ni11lO_ENA;
	reg	ni11OO;
	wire	wire_ni11Ol_ENA;
	reg	ni1iOl;
	wire	wire_ni1iOi_ENA;
	reg	ni1l1l;
	wire	wire_ni1l1i_ENA;
	reg	nilll;
	reg	nilOi;
	reg	nilOl;
	reg	niO1i;
	reg	n00i0i;
	reg	n00iii;
	reg	n1000l;
	reg	n1000O;
	reg	n1001i;
	reg	n1001l;
	reg	n1001O;
	reg	n100ii;
	reg	n100il;
	reg	n100iO;
	reg	n1011i;
	reg	n1011l;
	reg	n101Oi;
	reg	n101Ol;
	reg	n101OO;
	reg	n10i0i;
	reg	n10iOl;
	reg	n10iOO;
	reg	n10l1i;
	reg	n10lll;
	reg	n11OiO;
	reg	n11Oli;
	reg	n11Oll;
	reg	n11OlO;
	reg	n11OOi;
	reg	n11OOl;
	reg	n11OOO;
	reg	n1iliO;
	reg	n1illi;
	reg	n1illl;
	reg	n1illO;
	reg	n1ilOi;
	reg	n1ilOl;
	reg	n1ilOO;
	reg	n1l10i;
	reg	n1lOOO;
	reg	n1O0OO;
	reg	n1O10i;
	reg	n1O10l;
	reg	n1O10O;
	reg	n1O11i;
	reg	n1O11l;
	reg	n1O11O;
	reg	ni0OOO;
	reg	ni100i;
	reg	ni100l;
	reg	ni100O;
	reg	ni101i;
	reg	ni101l;
	reg	ni101O;
	reg	ni10ii;
	reg	ni10il;
	reg	ni10iO;
	reg	ni10li;
	reg	ni10ll;
	reg	ni10lO;
	reg	ni10Oi;
	reg	ni10Ol;
	reg	ni10OO;
	reg	ni1i0i;
	reg	ni1i0l;
	reg	ni1i0O;
	reg	ni1i1i;
	reg	ni1i1l;
	reg	ni1i1O;
	reg	ni1iii;
	reg	ni1iil;
	reg	ni1iiO;
	reg	ni1ili;
	reg	ni1ill;
	reg	ni1ilO;
	reg	ni1iOO;
	reg	ni1l1O;
	reg	nii00i;
	reg	nii00l;
	reg	nii00O;
	reg	nii01i;
	reg	nii01l;
	reg	nii01O;
	reg	nii0ii;
	reg	nii0il;
	reg	nii0iO;
	reg	nii0li;
	reg	nii0ll;
	reg	nii0lO;
	reg	nii0Oi;
	reg	nii0Ol;
	reg	nii0OO;
	reg	nii10i;
	reg	nii10l;
	reg	nii10O;
	reg	nii11i;
	reg	nii11l;
	reg	nii11O;
	reg	nii1ii;
	reg	nii1il;
	reg	nii1iO;
	reg	nii1li;
	reg	nii1ll;
	reg	nii1lO;
	reg	nii1Oi;
	reg	nii1Ol;
	reg	nii1OO;
	reg	niii0i;
	reg	niii0l;
	reg	niii0O;
	reg	niii1i;
	reg	niii1l;
	reg	niii1O;
	reg	niiiii;
	reg	niiiil;
	reg	niiiiO;
	reg	niiili;
	reg	niiill;
	reg	niiilO;
	reg	niiiOi;
	reg	niiiOl;
	reg	niiiOO;
	reg	niil1i;
	reg	niil1l;
	reg	niO1OO;
	reg	nl000l;
	reg	nl000O;
	reg	nl001i;
	reg	nl001l;
	reg	nl001O;
	reg	nl00ii;
	reg	nl00il;
	reg	nl00iO;
	reg	nl010i;
	reg	nl011i;
	reg	nl011l;
	reg	nl011O;
	reg	nl01OO;
	reg	nl0i1O;
	reg	nl0ill;
	reg	nl0ilO;
	reg	nl0iOi;
	reg	nl0l0O;
	reg	nl1Oll;
	reg	nl1OlO;
	reg	nl1OOi;
	reg	nl1OOl;
	reg	nl1OOO;
	reg	nll11i;
	reg	nll11l;
	reg	nll1l0O;
	reg	nll1l1O;
	reg	nll1ll;
	reg	nllOlli;
	reg	nllOlll;
	reg	nllOllO;
	reg	nllOlOi;
	reg	nllOlOl;
	reg	nllOlOO;
	reg	nllOO0i;
	reg	nllOO0l;
	reg	nllOO1i;
	reg	nllOO1l;
	reg	nllOO1O;
	reg	nllOOii;
	reg	nllOOli;
	reg	nlO000i;
	reg	nlO000l;
	reg	nlO000O;
	reg	nlO001i;
	reg	nlO001l;
	reg	nlO001O;
	reg	nlO00ii;
	reg	nlO00il;
	reg	nlO00iO;
	reg	nlO00li;
	reg	nlO00ll;
	reg	nlO00lO;
	reg	nlO00Oi;
	reg	nlO00Ol;
	reg	nlO00OO;
	reg	nlO01il;
	reg	nlO01iO;
	reg	nlO01li;
	reg	nlO01ll;
	reg	nlO01lO;
	reg	nlO01Oi;
	reg	nlO01Ol;
	reg	nlO01OO;
	reg	nlO0i0i;
	reg	nlO0i0l;
	reg	nlO0i0O;
	reg	nlO0i1i;
	reg	nlO0i1l;
	reg	nlO0i1O;
	reg	nlO0iii;
	reg	nlO0iil;
	reg	nlO0iiO;
	reg	nlO0ili;
	reg	nlO0ill;
	reg	nlO0ilO;
	reg	nlO0iOi;
	reg	nlO0iOl;
	reg	nlO0iOO;
	reg	nlO0l0i;
	reg	nlO0l0l;
	reg	nlO0l0O;
	reg	nlO0l1i;
	reg	nlO0l1l;
	reg	nlO0l1O;
	reg	nlO0lii;
	reg	nlO0lil;
	reg	nlO0liO;
	reg	nlO0lli;
	reg	nlOl0ii;
	reg	nllllOl;
	wire	wire_nllllOi_ENA;
	reg	nlllO1i;
	wire	wire_nllllOO_ENA;
	reg	nlllO0l;
	wire	wire_nlllO0i_ENA;
	reg	nlllOii;
	wire	wire_nlllO0O_ENA;
	reg	nlllO1O;
	wire	wire_nlllO1l_ENA;
	reg	nlllOiO;
	wire	wire_nlllOil_ENA;
	reg	nlllOll;
	wire	wire_nlllOli_ENA;
	reg	nlllOOi;
	wire	wire_nlllOlO_ENA;
	reg	nlllOOO;
	wire	wire_nlllOOl_ENA;
	reg	nllO00l;
	wire	wire_nllO00i_ENA;
	reg	nllO0ii;
	wire	wire_nllO00O_ENA;
	reg	nllO01O;
	wire	wire_nllO01l_ENA;
	reg	nllO0iO;
	wire	wire_nllO0il_ENA;
	reg	nllO0ll;
	wire	wire_nllO0li_ENA;
	reg	nllO0Oi;
	wire	wire_nllO0lO_ENA;
	reg	nllO0OO;
	wire	wire_nllO0Ol_ENA;
	reg	nllO10O;
	wire	wire_nllO10l_ENA;
	reg	nllO11l;
	wire	wire_nllO11i_ENA;
	reg	nllO10i;
	wire	wire_nllO11O_ENA;
	reg	nllO1il;
	wire	wire_nllO1ii_ENA;
	reg	nllO1li;
	wire	wire_nllO1iO_ENA;
	reg	nllO1lO;
	wire	wire_nllO1ll_ENA;
	reg	nllO1Ol;
	wire	wire_nllO1Oi_ENA;
	reg	nllO01i;
	wire	wire_nllO1OO_ENA;
	reg	nllOi0O;
	wire	wire_nllOi0l_ENA;
	reg	nllOi1l;
	wire	wire_nllOi1i_ENA;
	reg	nllOi0i;
	wire	wire_nllOi1O_ENA;
	reg	nllOiil;
	wire	wire_nllOiii_ENA;
	reg	nllOili;
	wire	wire_nllOiiO_ENA;
	reg	nllOilO;
	wire	wire_nllOill_ENA;
	reg	nllOiOl;
	wire	wire_nllOiOi_ENA;
	reg	nllOl1i;
	wire	wire_nllOiOO_ENA;
	reg	nllOl0l;
	wire	wire_nllOl0i_ENA;
	reg	nllOlii;
	wire	wire_nllOl0O_ENA;
	reg	nllOl1O;
	wire	wire_nllOl1l_ENA;
	reg	nllOliO;
	wire	wire_nllOlil_ENA;
	reg	nllOO0O;
	reg	nllOOiO;
	reg	n00i1O;
	reg	n0Ol0l;
	reg	n10iOi;
	reg	n10llO;
	reg	n10lOO;
	reg	n10O1i;
	reg	n10O1l;
	reg	n1110l;
	reg	n1110O;
	reg	n11l0i;
	reg	n11l0l;
	reg	n11l0O;
	reg	n11l1l;
	reg	n11l1O;
	reg	n11Oil;
	reg	n1i1il;
	reg	n1i1iO;
	reg	n1i1li;
	reg	n1i1ll;
	reg	n1i1lO;
	reg	n1ilil;
	reg	n1l10l;
	reg	n1l10O;
	reg	n1l1ii;
	reg	n1l1il;
	reg	n1l1iO;
	reg	n1lO0i;
	reg	n1lO0l;
	reg	n1lOOi;
	reg	n1Oi0i;
	reg	n1Oi0l;
	reg	n1Oi0O;
	reg	n1Oi1O;
	reg	n1Oiii;
	reg	n1Oiil;
	reg	niO00i;
	reg	niO00l;
	reg	niO00O;
	reg	niO01i;
	reg	niO01l;
	reg	niO01O;
	reg	niO0ii;
	reg	niO0il;
	reg	niO0iO;
	reg	niO0li;
	reg	niO0ll;
	reg	niO0lO;
	reg	niO0Oi;
	reg	niO0Ol;
	reg	niO0OO;
	reg	niOi0i;
	reg	niOi0l;
	reg	niOi0O;
	reg	niOi1i;
	reg	niOi1l;
	reg	niOi1O;
	reg	niOiii;
	reg	niOiil;
	reg	niOiiO;
	reg	niOili;
	reg	niOill;
	reg	niOilO;
	reg	niOiOi;
	reg	niOiOl;
	reg	niOiOO;
	reg	niOl1i;
	reg	niOl1l;
	reg	niOl1O;
	reg	nl0ili;
	reg	nl0lii;
	reg	nl0lli;
	reg	nl0lll;
	reg	nl0llO;
	reg	nl1ili;
	reg	nl1ill;
	reg	nl1l0i;
	reg	nl1l0l;
	reg	nl1l0O;
	reg	nl1lii;
	reg	nl1lil;
	reg	nl1Oli;
	reg	nli10i;
	reg	nli10l;
	reg	nli10O;
	reg	nli11O;
	reg	nli1ii;
	reg	nlii0O;
	reg	nliiii;
	reg	nliiil;
	reg	nliiiO;
	reg	nliili;
	reg	nliOil;
	reg	nliOiO;
	reg	nliOOl;
	reg	nll01i;
	reg	nll01l;
	reg	nll1l1l;
	reg	nll1lO;
	reg	nlllllO;
	reg	nlO00i;
	reg	nlO00l;
	reg	nlO00O;
	reg	nlO01i;
	reg	nlO01l;
	reg	nlO01O;
	reg	nlO0ii;
	reg	nlO0il;
	reg	nlO0iO;
	reg	nlO0li;
	reg	nlO0ll;
	reg	nlO0lO;
	reg	nlO0Oi;
	reg	nlO0Ol;
	reg	nlO0OO;
	reg	nlO1ii;
	reg	nlO1il;
	reg	nlO1iO;
	reg	nlO1li;
	reg	nlO1ll;
	reg	nlO1lO;
	reg	nlO1Oi;
	reg	nlO1Ol;
	reg	nlO1OO;
	reg	nlOi0i;
	reg	nlOi1i;
	reg	nlOi1l;
	reg	nlOi1O;
	reg	nlOiiO;
	reg	nlOili;
	reg	nlOl0il;
	reg	nlOl0iO;
	reg	nlOl0li;
	reg	nlOl0ll;
	reg	nlOl0lO;
	reg	nlOl0Oi;
	reg	nlOl0Ol;
	reg	nlOl0OO;
	reg	nlOli0i;
	reg	nlOli0l;
	reg	nlOli0O;
	reg	nlOli1i;
	reg	nlOli1l;
	reg	nlOli1O;
	reg	nlOliii;
	reg	nlOliil;
	reg	nlOliiO;
	reg	nlOlili;
	reg	nlOlill;
	reg	nlOlilO;
	reg	nlOliOi;
	reg	nlOliOl;
	reg	nlOliOO;
	reg	nlOll0i;
	reg	nlOll0l;
	reg	nlOll0O;
	reg	nlOll1i;
	reg	nlOll1l;
	reg	nlOll1O;
	reg	nlOllii;
	reg	nlOllil;
	reg	nlOlliO;
	reg	nlOllli;
	reg	nlOlOO;
	reg	nlOO1l;
	wire	wire_n0000i_dataout;
	wire	wire_n0000l_dataout;
	wire	wire_n0000O_dataout;
	wire	wire_n0001i_dataout;
	wire	wire_n0001l_dataout;
	wire	wire_n0001O_dataout;
	wire	wire_n000ii_dataout;
	wire	wire_n000il_dataout;
	wire	wire_n000iO_dataout;
	wire	wire_n001OO_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00i0l_dataout;
	wire	wire_n00i0O_dataout;
	wire	wire_n00iil_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n0100i_dataout;
	wire	wire_n0100l_dataout;
	wire	wire_n0100O_dataout;
	wire	wire_n0101i_dataout;
	wire	wire_n0101l_dataout;
	wire	wire_n0101O_dataout;
	wire	wire_n010ii_dataout;
	wire	wire_n010il_dataout;
	wire	wire_n010iO_dataout;
	wire	wire_n010li_dataout;
	wire	wire_n010ll_dataout;
	wire	wire_n010lO_dataout;
	wire	wire_n010Oi_dataout;
	wire	wire_n010Ol_dataout;
	wire	wire_n010OO_dataout;
	wire	wire_n0110i_dataout;
	wire	wire_n0110l_dataout;
	wire	wire_n0110O_dataout;
	wire	wire_n0111i_dataout;
	wire	wire_n011ii_dataout;
	wire	wire_n011lO_dataout;
	wire	wire_n011Oi_dataout;
	wire	wire_n011Ol_dataout;
	wire	wire_n011OO_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01i0i_dataout;
	wire	wire_n01i0l_dataout;
	wire	wire_n01i0O_dataout;
	wire	wire_n01i1i_dataout;
	wire	wire_n01i1l_dataout;
	wire	wire_n01i1O_dataout;
	wire	wire_n01iii_dataout;
	wire	wire_n01iil_dataout;
	wire	wire_n01iiO_dataout;
	wire	wire_n01ili_dataout;
	wire	wire_n01ill_dataout;
	wire	wire_n01ilO_dataout;
	wire	wire_n01iOi_dataout;
	wire	wire_n01iOl_dataout;
	wire	wire_n01iOO_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01l0i_dataout;
	wire	wire_n01l0l_dataout;
	wire	wire_n01l0O_dataout;
	wire	wire_n01l1i_dataout;
	wire	wire_n01l1l_dataout;
	wire	wire_n01l1O_dataout;
	wire	wire_n01lii_dataout;
	wire	wire_n01lil_dataout;
	wire	wire_n01liO_dataout;
	wire	wire_n01lli_dataout;
	wire	wire_n01lll_dataout;
	wire	wire_n01llO_dataout;
	wire	wire_n01lOi_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01O0l_dataout;
	wire	wire_n01OOi_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n100li_dataout;
	wire	wire_n100ll_dataout;
	wire	wire_n100lO_dataout;
	wire	wire_n100Oi_dataout;
	wire	wire_n100Ol_dataout;
	wire	wire_n1010i_dataout;
	wire	wire_n1010l_dataout;
	wire	wire_n1010O_dataout;
	wire	wire_n1011O_dataout;
	wire	wire_n101ii_dataout;
	wire	wire_n101il_dataout;
	wire	wire_n101iO_dataout;
	wire	wire_n101li_dataout;
	wire	wire_n101ll_dataout;
	wire	wire_n101lO_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10i0l_dataout;
	wire	wire_n10i0O_dataout;
	wire	wire_n10iil_dataout;
	wire	wire_n10iiO_dataout;
	wire	wire_n10ili_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10l1l_dataout;
	wire	wire_n10l1O_dataout;
	wire	wire_n10lil_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n10O0i_dataout;
	wire	wire_n10O0l_dataout;
	wire	wire_n10O0O_dataout;
	wire	wire_n10O1O_dataout;
	wire	wire_n10Oii_dataout;
	wire	wire_n10Oil_dataout;
	wire	wire_n10OiO_dataout;
	wire	wire_n10OlO_dataout;
	wire	wire_n1110i_dataout;
	wire	wire_n1111i_dataout;
	wire	wire_n1111l_dataout;
	wire	wire_n1111O_dataout;
	wire	wire_n111il_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11lii_dataout;
	wire	wire_n11lil_dataout;
	wire	wire_n11liO_dataout;
	wire	wire_n11lli_dataout;
	wire	wire_n11lll_dataout;
	wire	wire_n11llO_dataout;
	wire	wire_n11lOi_dataout;
	wire	wire_n11lOl_dataout;
	wire	wire_n11lOO_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n11O1i_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1i00i_dataout;
	wire	wire_n1i00l_dataout;
	wire	wire_n1i00O_dataout;
	wire	wire_n1i01i_dataout;
	wire	wire_n1i01l_dataout;
	wire	wire_n1i01O_dataout;
	wire	wire_n1i0ii_dataout;
	wire	wire_n1i0iO_dataout;
	wire	wire_n1i0li_dataout;
	wire	wire_n1i0ll_dataout;
	wire	wire_n1i0lO_dataout;
	wire	wire_n1i0Oi_dataout;
	wire	wire_n1i10i_dataout;
	wire	wire_n1i11i_dataout;
	wire	wire_n1i1Oi_dataout;
	wire	wire_n1i1Ol_dataout;
	wire	wire_n1i1OO_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1ii1O_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1iO0i_dataout;
	wire	wire_n1iO0l_dataout;
	wire	wire_n1iO0O_dataout;
	wire	wire_n1iO1i_dataout;
	wire	wire_n1iO1l_dataout;
	wire	wire_n1iO1O_dataout;
	wire	wire_n1iOii_dataout;
	wire	wire_n1iOil_dataout;
	wire	wire_n1iOiO_dataout;
	wire	wire_n1iOli_dataout;
	wire	wire_n1iOll_dataout;
	wire	wire_n1iOlO_dataout;
	wire	wire_n1iOOi_dataout;
	wire	wire_n1iOOl_dataout;
	wire	wire_n1iOOO_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1l00i_dataout;
	wire	wire_n1l00l_dataout;
	wire	wire_n1l00O_dataout;
	wire	wire_n1l01i_dataout;
	wire	wire_n1l01l_dataout;
	wire	wire_n1l01O_dataout;
	wire	wire_n1l0ii_dataout;
	wire	wire_n1l0il_dataout;
	wire	wire_n1l0iO_dataout;
	wire	wire_n1l0li_dataout;
	wire	wire_n1l0ll_dataout;
	wire	wire_n1l0lO_dataout;
	wire	wire_n1l0Oi_dataout;
	wire	wire_n1l0Ol_dataout;
	wire	wire_n1l0OO_dataout;
	wire	wire_n1l1li_dataout;
	wire	wire_n1l1ll_dataout;
	wire	wire_n1l1lO_dataout;
	wire	wire_n1l1Oi_dataout;
	wire	wire_n1l1Ol_dataout;
	wire	wire_n1l1OO_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1li0i_dataout;
	wire	wire_n1li0l_dataout;
	wire	wire_n1li1i_dataout;
	wire	wire_n1li1l_dataout;
	wire	wire_n1li1O_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1lO0O_dataout;
	wire	wire_n1lOii_dataout;
	wire	wire_n1lOOl_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1O01i_dataout;
	wire	wire_n1O01l_dataout;
	wire	wire_n1O01O_dataout;
	wire	wire_n1O0iO_dataout;
	wire	wire_n1O0li_dataout;
	wire	wire_n1O0ll_dataout;
	wire	wire_n1O0lO_dataout;
	wire	wire_n1O1ii_dataout;
	wire	wire_n1O1il_dataout;
	wire	wire_n1O1iO_dataout;
	wire	wire_n1O1li_dataout;
	wire	wire_n1O1ll_dataout;
	wire	wire_n1O1lO_dataout;
	wire	wire_n1O1Oi_dataout;
	wire	wire_n1O1Ol_dataout;
	wire	wire_n1O1OO_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Oi1i_dataout;
	wire	wire_n1OiiO_dataout;
	wire	wire_n1Oill_dataout;
	wire	wire_n1OiOi_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1Ol1l_dataout;
	wire	wire_n1Olll_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_n1OO0i_dataout;
	wire	wire_n1OO0l_dataout;
	wire	wire_n1OO0O_dataout;
	wire	wire_n1OO1O_dataout;
	wire	wire_n1OOii_dataout;
	wire	wire_n1OOil_dataout;
	wire	wire_n1OOiO_dataout;
	wire	wire_n1OOli_dataout;
	wire	wire_n1OOll_dataout;
	wire	wire_n1OOlO_dataout;
	wire	wire_n1OOOi_dataout;
	wire	wire_n1OOOl_dataout;
	wire	wire_n1OOOO_dataout;
	wire	wire_ni_dataout;
	wire	wire_ni000i_dataout;
	wire	wire_ni000l_dataout;
	wire	wire_ni000O_dataout;
	wire	wire_ni001i_dataout;
	wire	wire_ni001l_dataout;
	wire	wire_ni001O_dataout;
	wire	wire_ni00ii_dataout;
	wire	wire_ni00il_dataout;
	wire	wire_ni00iO_dataout;
	wire	wire_ni00li_dataout;
	wire	wire_ni00ll_dataout;
	wire	wire_ni00lO_dataout;
	wire	wire_ni00Oi_dataout;
	wire	wire_ni00Ol_dataout;
	wire	wire_ni00OO_dataout;
	wire	wire_ni010i_dataout;
	wire	wire_ni010l_dataout;
	wire	wire_ni010O_dataout;
	wire	wire_ni011i_dataout;
	wire	wire_ni011l_dataout;
	wire	wire_ni011O_dataout;
	wire	wire_ni01ii_dataout;
	wire	wire_ni01il_dataout;
	wire	wire_ni01iO_dataout;
	wire	wire_ni01li_dataout;
	wire	wire_ni01ll_dataout;
	wire	wire_ni01lO_dataout;
	wire	wire_ni01Oi_dataout;
	wire	wire_ni01Ol_dataout;
	wire	wire_ni01OO_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0i0i_dataout;
	wire	wire_ni0i0l_dataout;
	wire	wire_ni0i0O_dataout;
	wire	wire_ni0i1i_dataout;
	wire	wire_ni0i1l_dataout;
	wire	wire_ni0i1O_dataout;
	wire	wire_ni0iii_dataout;
	wire	wire_ni0iil_dataout;
	wire	wire_ni0iiO_dataout;
	wire	wire_ni0ili_dataout;
	wire	wire_ni0ill_dataout;
	wire	wire_ni0ilO_dataout;
	wire	wire_ni0iOi_dataout;
	wire	wire_ni0iOl_dataout;
	wire	wire_ni0iOO_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0l0i_dataout;
	wire	wire_ni0l0l_dataout;
	wire	wire_ni0l0O_dataout;
	wire	wire_ni0l1i_dataout;
	wire	wire_ni0l1l_dataout;
	wire	wire_ni0l1O_dataout;
	wire	wire_ni0lii_dataout;
	wire	wire_ni0lil_dataout;
	wire	wire_ni0liO_dataout;
	wire	wire_ni0lli_dataout;
	wire	wire_ni0lll_dataout;
	wire	wire_ni0llO_dataout;
	wire	wire_ni0lOi_dataout;
	wire	wire_ni0lOl_dataout;
	wire	wire_ni0lOO_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0O0i_dataout;
	wire	wire_ni0O0l_dataout;
	wire	wire_ni0O0O_dataout;
	wire	wire_ni0O1i_dataout;
	wire	wire_ni0O1l_dataout;
	wire	wire_ni0O1O_dataout;
	wire	wire_ni0Oii_dataout;
	wire	wire_ni0Oil_dataout;
	wire	wire_ni0OiO_dataout;
	wire	wire_ni0OOi_dataout;
	wire	wire_ni0OOl_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1l0i_dataout;
	wire	wire_ni1l0l_dataout;
	wire	wire_ni1l0O_dataout;
	wire	wire_ni1lii_dataout;
	wire	wire_ni1lil_dataout;
	wire	wire_ni1liO_dataout;
	wire	wire_ni1lli_dataout;
	wire	wire_ni1lll_dataout;
	wire	wire_ni1llO_dataout;
	wire	wire_ni1lOi_dataout;
	wire	wire_ni1lOl_dataout;
	wire	wire_ni1lOO_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1O0i_dataout;
	wire	wire_ni1O0l_dataout;
	wire	wire_ni1O0O_dataout;
	wire	wire_ni1O1i_dataout;
	wire	wire_ni1O1l_dataout;
	wire	wire_ni1O1O_dataout;
	wire	wire_ni1Oii_dataout;
	wire	wire_ni1Oil_dataout;
	wire	wire_ni1OiO_dataout;
	wire	wire_ni1Oli_dataout;
	wire	wire_ni1Oll_dataout;
	wire	wire_ni1OlO_dataout;
	wire	wire_ni1OOi_dataout;
	wire	wire_ni1OOl_dataout;
	wire	wire_ni1OOO_dataout;
	wire	wire_nii_dataout;
	wire	wire_niii_dataout;
	wire	wire_niil_dataout;
	wire	wire_niil0i_dataout;
	wire	wire_niil0l_dataout;
	wire	wire_niil0O_dataout;
	wire	wire_niil1O_dataout;
	wire	wire_niilii_dataout;
	wire	wire_niilil_dataout;
	wire	wire_niiliO_dataout;
	wire	wire_niilli_dataout;
	wire	wire_niilll_dataout;
	wire	wire_niillO_dataout;
	wire	wire_niilOi_dataout;
	wire	wire_niilOl_dataout;
	wire	wire_niilOO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiO0i_dataout;
	wire	wire_niiO0l_dataout;
	wire	wire_niiO0O_dataout;
	wire	wire_niiO1i_dataout;
	wire	wire_niiO1l_dataout;
	wire	wire_niiO1O_dataout;
	wire	wire_niiOii_dataout;
	wire	wire_niiOil_dataout;
	wire	wire_niiOiO_dataout;
	wire	wire_niiOli_dataout;
	wire	wire_niiOll_dataout;
	wire	wire_niiOlO_dataout;
	wire	wire_niiOOi_dataout;
	wire	wire_niiOOl_dataout;
	wire	wire_niiOOO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil00i_dataout;
	wire	wire_nil00l_dataout;
	wire	wire_nil00O_dataout;
	wire	wire_nil01i_dataout;
	wire	wire_nil01l_dataout;
	wire	wire_nil01O_dataout;
	wire	wire_nil0ii_dataout;
	wire	wire_nil0il_dataout;
	wire	wire_nil0iO_dataout;
	wire	wire_nil0li_dataout;
	wire	wire_nil0ll_dataout;
	wire	wire_nil0lO_dataout;
	wire	wire_nil0Oi_dataout;
	wire	wire_nil0Ol_dataout;
	wire	wire_nil0OO_dataout;
	wire	wire_nil10i_dataout;
	wire	wire_nil10l_dataout;
	wire	wire_nil10O_dataout;
	wire	wire_nil11i_dataout;
	wire	wire_nil11l_dataout;
	wire	wire_nil11O_dataout;
	wire	wire_nil1ii_dataout;
	wire	wire_nil1il_dataout;
	wire	wire_nil1iO_dataout;
	wire	wire_nil1li_dataout;
	wire	wire_nil1ll_dataout;
	wire	wire_nil1lO_dataout;
	wire	wire_nil1Oi_dataout;
	wire	wire_nil1Ol_dataout;
	wire	wire_nil1OO_dataout;
	wire	wire_nili_dataout;
	wire	wire_nili0i_dataout;
	wire	wire_nili0l_dataout;
	wire	wire_nili0O_dataout;
	wire	wire_nili1i_dataout;
	wire	wire_nili1l_dataout;
	wire	wire_nili1O_dataout;
	wire	wire_niliii_dataout;
	wire	wire_niliil_dataout;
	wire	wire_niliiO_dataout;
	wire	wire_nilili_dataout;
	wire	wire_nilill_dataout;
	wire	wire_nililO_dataout;
	wire	wire_niliOi_dataout;
	wire	wire_niliOl_dataout;
	wire	wire_niliOO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nill0i_dataout;
	wire	wire_nill0l_dataout;
	wire	wire_nill0O_dataout;
	wire	wire_nill1i_dataout;
	wire	wire_nill1l_dataout;
	wire	wire_nill1O_dataout;
	wire	wire_nillii_dataout;
	wire	wire_nillil_dataout;
	wire	wire_nilliO_dataout;
	wire	wire_nillli_dataout;
	wire	wire_nillll_dataout;
	wire	wire_nilllO_dataout;
	wire	wire_nillOi_dataout;
	wire	wire_nillOl_dataout;
	wire	wire_nillOO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilO0i_dataout;
	wire	wire_nilO0l_dataout;
	wire	wire_nilO0O_dataout;
	wire	wire_nilO1i_dataout;
	wire	wire_nilO1l_dataout;
	wire	wire_nilO1O_dataout;
	wire	wire_nilOii_dataout;
	wire	wire_nilOil_dataout;
	wire	wire_nilOiO_dataout;
	wire	wire_nilOli_dataout;
	wire	wire_nilOll_dataout;
	wire	wire_nilOlO_dataout;
	wire	wire_niO0i_dataout;
	wire	wire_niO0l_dataout;
	wire	wire_niO0O_dataout;
	wire	wire_niO10i_dataout;
	wire	wire_niO10l_dataout;
	wire	wire_niO10O_dataout;
	wire	wire_niO1ii_dataout;
	wire	wire_niO1il_dataout;
	wire	wire_niO1l_dataout;
	wire	wire_niO1O_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOii_dataout;
	wire	wire_niOil_dataout;
	wire	wire_niOiO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOl0i_dataout;
	wire	wire_niOl0l_dataout;
	wire	wire_niOl0O_dataout;
	wire	wire_niOli_dataout;
	wire	wire_niOlii_dataout;
	wire	wire_niOlil_dataout;
	wire	wire_niOliO_dataout;
	wire	wire_niOll_dataout;
	wire	wire_niOlli_dataout;
	wire	wire_niOlll_dataout;
	wire	wire_niOllO_dataout;
	wire	wire_niOlO_dataout;
	wire	wire_niOlOi_dataout;
	wire	wire_niOlOl_dataout;
	wire	wire_niOlOO_dataout;
	wire	wire_niOO_dataout;
	wire	wire_niOO0i_dataout;
	wire	wire_niOO0l_dataout;
	wire	wire_niOO0O_dataout;
	wire	wire_niOO1i_dataout;
	wire	wire_niOO1l_dataout;
	wire	wire_niOO1O_dataout;
	wire	wire_niOOi_dataout;
	wire	wire_niOOii_dataout;
	wire	wire_niOOil_dataout;
	wire	wire_niOOiO_dataout;
	wire	wire_niOOl_dataout;
	wire	wire_niOOli_dataout;
	wire	wire_niOOll_dataout;
	wire	wire_niOOlO_dataout;
	wire	wire_niOOO_dataout;
	wire	wire_niOOOi_dataout;
	wire	wire_niOOOl_dataout;
	wire	wire_niOOOO_dataout;
	wire	wire_nl_dataout;
	wire	wire_nl00i_dataout;
	wire	wire_nl00l_dataout;
	wire	wire_nl00li_dataout;
	wire	wire_nl00ll_dataout;
	wire	wire_nl00lO_dataout;
	wire	wire_nl00O_dataout;
	wire	wire_nl00Oi_dataout;
	wire	wire_nl00Ol_dataout;
	wire	wire_nl010l_dataout;
	wire	wire_nl010O_dataout;
	wire	wire_nl01i_dataout;
	wire	wire_nl01ii_dataout;
	wire	wire_nl01il_dataout;
	wire	wire_nl01iO_dataout;
	wire	wire_nl01l_dataout;
	wire	wire_nl01li_dataout;
	wire	wire_nl01ll_dataout;
	wire	wire_nl01lO_dataout;
	wire	wire_nl01O_dataout;
	wire	wire_nl01Oi_dataout;
	wire	wire_nl01Ol_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0i0i_dataout;
	wire	wire_nl0i0l_dataout;
	wire	wire_nl0ii_dataout;
	wire	wire_nl0iii_dataout;
	wire	wire_nl0il_dataout;
	wire	wire_nl0iO_dataout;
	wire	wire_nl0iOl_dataout;
	wire	wire_nl0iOO_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0l1O_dataout;
	wire	wire_nl0li_dataout;
	wire	wire_nl0ll_dataout;
	wire	wire_nl0lO_dataout;
	wire	wire_nl0lOi_dataout;
	wire	wire_nl0lOl_dataout;
	wire	wire_nl0lOO_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl0O0i_dataout;
	wire	wire_nl0O1i_dataout;
	wire	wire_nl0O1l_dataout;
	wire	wire_nl0O1O_dataout;
	wire	wire_nl0Oi_dataout;
	wire	wire_nl0Oii_dataout;
	wire	wire_nl0Ol_dataout;
	wire	wire_nl0Oll_dataout;
	wire	wire_nl0OO_dataout;
	wire	wire_nl0OOl_dataout;
	wire	wire_nl100i_dataout;
	wire	wire_nl100l_dataout;
	wire	wire_nl100O_dataout;
	wire	wire_nl101i_dataout;
	wire	wire_nl101l_dataout;
	wire	wire_nl101O_dataout;
	wire	wire_nl10i_dataout;
	wire	wire_nl10ii_dataout;
	wire	wire_nl10il_dataout;
	wire	wire_nl10iO_dataout;
	wire	wire_nl10l_dataout;
	wire	wire_nl10li_dataout;
	wire	wire_nl10ll_dataout;
	wire	wire_nl10lO_dataout;
	wire	wire_nl10O_dataout;
	wire	wire_nl10Oi_dataout;
	wire	wire_nl10OO_dataout;
	wire	wire_nl110i_dataout;
	wire	wire_nl110l_dataout;
	wire	wire_nl110O_dataout;
	wire	wire_nl111i_dataout;
	wire	wire_nl111l_dataout;
	wire	wire_nl111O_dataout;
	wire	wire_nl11i_dataout;
	wire	wire_nl11ii_dataout;
	wire	wire_nl11il_dataout;
	wire	wire_nl11iO_dataout;
	wire	wire_nl11l_dataout;
	wire	wire_nl11li_dataout;
	wire	wire_nl11ll_dataout;
	wire	wire_nl11lO_dataout;
	wire	wire_nl11O_dataout;
	wire	wire_nl11Oi_dataout;
	wire	wire_nl11Ol_dataout;
	wire	wire_nl11OO_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1i0i_dataout;
	wire	wire_nl1i0l_dataout;
	wire	wire_nl1i0O_dataout;
	wire	wire_nl1i1i_dataout;
	wire	wire_nl1i1l_dataout;
	wire	wire_nl1i1O_dataout;
	wire	wire_nl1ii_dataout;
	wire	wire_nl1iii_dataout;
	wire	wire_nl1iil_dataout;
	wire	wire_nl1iiO_dataout;
	wire	wire_nl1il_dataout;
	wire	wire_nl1iO_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1li_dataout;
	wire	wire_nl1liO_dataout;
	wire	wire_nl1ll_dataout;
	wire	wire_nl1lli_dataout;
	wire	wire_nl1lll_dataout;
	wire	wire_nl1llO_dataout;
	wire	wire_nl1lO_dataout;
	wire	wire_nl1lOi_dataout;
	wire	wire_nl1lOl_dataout;
	wire	wire_nl1lOO_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1O1i_dataout;
	wire	wire_nl1O1l_dataout;
	wire	wire_nl1O1O_dataout;
	wire	wire_nl1Oi_dataout;
	wire	wire_nl1Ol_dataout;
	wire	wire_nl1OO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli00i_dataout;
	wire	wire_nli00l_dataout;
	wire	wire_nli00O_dataout;
	wire	wire_nli01i_dataout;
	wire	wire_nli01l_dataout;
	wire	wire_nli0i_dataout;
	wire	wire_nli0ii_dataout;
	wire	wire_nli0il_dataout;
	wire	wire_nli0l_dataout;
	wire	wire_nli0O_dataout;
	wire	wire_nli1i_dataout;
	wire	wire_nli1il_dataout;
	wire	wire_nli1iO_dataout;
	wire	wire_nli1l_dataout;
	wire	wire_nli1li_dataout;
	wire	wire_nli1ll_dataout;
	wire	wire_nli1lO_dataout;
	wire	wire_nli1O_dataout;
	wire	wire_nli1Oi_dataout;
	wire	wire_nli1Ol_dataout;
	wire	wire_nli1OO_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nliii_dataout;
	wire	wire_nliil_dataout;
	wire	wire_nliill_dataout;
	wire	wire_nliilO_dataout;
	wire	wire_nliiO_dataout;
	wire	wire_nliiOi_dataout;
	wire	wire_nliiOl_dataout;
	wire	wire_nliiOO_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlil0i_dataout;
	wire	wire_nlil0l_dataout;
	wire	wire_nlil0O_dataout;
	wire	wire_nlil1i_dataout;
	wire	wire_nlil1l_dataout;
	wire	wire_nlil1O_dataout;
	wire	wire_nlili_dataout;
	wire	wire_nlilii_dataout;
	wire	wire_nlilil_dataout;
	wire	wire_nliliO_dataout;
	wire	wire_nlill_dataout;
	wire	wire_nlilli_dataout;
	wire	wire_nlilO_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliOi_dataout;
	wire	wire_nliOl_dataout;
	wire	wire_nliOli_dataout;
	wire	wire_nliOll_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nliOOO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll01O_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0ll_dataout;
	wire	wire_nll0lO_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll10i_dataout;
	wire	wire_nll10l_dataout;
	wire	wire_nll10O_dataout;
	wire	wire_nll11O_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1l0i_dataout;
	wire	wire_nll1l0l_dataout;
	wire	wire_nll1lii_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nll1Oi_dataout;
	wire	wire_nll1Ol_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlli0O_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nlliii_dataout;
	wire	wire_nlliiO_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nllili_dataout;
	wire	wire_nllill_dataout;
	wire	wire_nllilO_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlliOi_dataout;
	wire	wire_nlliOl_dataout;
	wire	wire_nlliOO_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nlll0i_dataout;
	wire	wire_nlll0l_dataout;
	wire	wire_nlll0O_dataout;
	wire	wire_nlll1i_dataout;
	wire	wire_nlll1l_dataout;
	wire	wire_nlll1O_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nlllii_dataout;
	wire	wire_nlllil_dataout;
	wire	wire_nllliO_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllli_dataout;
	wire	wire_nlllll_dataout;
	wire	wire_nllllO_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nlllOi_dataout;
	wire	wire_nlllOl_dataout;
	wire	wire_nlllOO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllO0i_dataout;
	wire	wire_nllO0l_dataout;
	wire	wire_nllO0O_dataout;
	wire	wire_nllO1i_dataout;
	wire	wire_nllO1l_dataout;
	wire	wire_nllO1O_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOii_dataout;
	wire	wire_nllOil_dataout;
	wire	wire_nllOiO_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOli_dataout;
	wire	wire_nllOll_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nllOOll_dataout;
	wire	wire_nllOOlO_dataout;
	wire	wire_nllOOOi_dataout;
	wire	wire_nllOOOl_dataout;
	wire	wire_nllOOOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO010O_dataout;
	wire	wire_nlO011i_dataout;
	wire	wire_nlO011l_dataout;
	wire	wire_nlO011O_dataout;
	wire	wire_nlO01ii_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO0l_dataout;
	wire	wire_nlO0lll_dataout;
	wire	wire_nlO0llO_dataout;
	wire	wire_nlO0lOi_dataout;
	wire	wire_nlO0lOl_dataout;
	wire	wire_nlO0lOO_dataout;
	wire	wire_nlO0O_dataout;
	wire	wire_nlO0O0i_dataout;
	wire	wire_nlO0O0l_dataout;
	wire	wire_nlO0O0O_dataout;
	wire	wire_nlO0O1i_dataout;
	wire	wire_nlO0O1l_dataout;
	wire	wire_nlO0O1O_dataout;
	wire	wire_nlO0Oii_dataout;
	wire	wire_nlO0Oil_dataout;
	wire	wire_nlO0OiO_dataout;
	wire	wire_nlO0Oli_dataout;
	wire	wire_nlO0Oll_dataout;
	wire	wire_nlO0OlO_dataout;
	wire	wire_nlO0OOi_dataout;
	wire	wire_nlO0OOl_dataout;
	wire	wire_nlO0OOO_dataout;
	wire	wire_nlO100i_dataout;
	wire	wire_nlO100l_dataout;
	wire	wire_nlO100O_dataout;
	wire	wire_nlO101i_dataout;
	wire	wire_nlO101l_dataout;
	wire	wire_nlO101O_dataout;
	wire	wire_nlO10ii_dataout;
	wire	wire_nlO10il_dataout;
	wire	wire_nlO10iO_dataout;
	wire	wire_nlO10li_dataout;
	wire	wire_nlO10ll_dataout;
	wire	wire_nlO10lO_dataout;
	wire	wire_nlO10Oi_dataout;
	wire	wire_nlO10Ol_dataout;
	wire	wire_nlO10OO_dataout;
	wire	wire_nlO110i_dataout;
	wire	wire_nlO110l_dataout;
	wire	wire_nlO110O_dataout;
	wire	wire_nlO111i_dataout;
	wire	wire_nlO111l_dataout;
	wire	wire_nlO111O_dataout;
	wire	wire_nlO11ii_dataout;
	wire	wire_nlO11il_dataout;
	wire	wire_nlO11iO_dataout;
	wire	wire_nlO11li_dataout;
	wire	wire_nlO11ll_dataout;
	wire	wire_nlO11lO_dataout;
	wire	wire_nlO11Oi_dataout;
	wire	wire_nlO11Ol_dataout;
	wire	wire_nlO11OO_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1i0i_dataout;
	wire	wire_nlO1i0l_dataout;
	wire	wire_nlO1i0O_dataout;
	wire	wire_nlO1i1i_dataout;
	wire	wire_nlO1i1l_dataout;
	wire	wire_nlO1i1O_dataout;
	wire	wire_nlO1iii_dataout;
	wire	wire_nlO1iil_dataout;
	wire	wire_nlO1iiO_dataout;
	wire	wire_nlO1ili_dataout;
	wire	wire_nlO1ill_dataout;
	wire	wire_nlO1ilO_dataout;
	wire	wire_nlO1iOi_dataout;
	wire	wire_nlO1iOl_dataout;
	wire	wire_nlO1iOO_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1l0i_dataout;
	wire	wire_nlO1l0l_dataout;
	wire	wire_nlO1l0O_dataout;
	wire	wire_nlO1l1l_dataout;
	wire	wire_nlO1l1O_dataout;
	wire	wire_nlO1lii_dataout;
	wire	wire_nlO1lil_dataout;
	wire	wire_nlO1liO_dataout;
	wire	wire_nlO1lli_dataout;
	wire	wire_nlO1lll_dataout;
	wire	wire_nlO1llO_dataout;
	wire	wire_nlO1lOi_dataout;
	wire	wire_nlO1lOl_dataout;
	wire	wire_nlO1lOO_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlO1O0i_dataout;
	wire	wire_nlO1O0l_dataout;
	wire	wire_nlO1O0O_dataout;
	wire	wire_nlO1O1i_dataout;
	wire	wire_nlO1O1l_dataout;
	wire	wire_nlO1O1O_dataout;
	wire	wire_nlO1Oii_dataout;
	wire	wire_nlO1Oil_dataout;
	wire	wire_nlO1OiO_dataout;
	wire	wire_nlO1Oli_dataout;
	wire	wire_nlO1Oll_dataout;
	wire	wire_nlO1OlO_dataout;
	wire	wire_nlO1OOi_dataout;
	wire	wire_nlO1OOl_dataout;
	wire	wire_nlO1OOO_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOi00i_dataout;
	wire	wire_nlOi00l_dataout;
	wire	wire_nlOi00O_dataout;
	wire	wire_nlOi01i_dataout;
	wire	wire_nlOi01l_dataout;
	wire	wire_nlOi01O_dataout;
	wire	wire_nlOi0ii_dataout;
	wire	wire_nlOi0il_dataout;
	wire	wire_nlOi0iO_dataout;
	wire	wire_nlOi0li_dataout;
	wire	wire_nlOi0ll_dataout;
	wire	wire_nlOi0lO_dataout;
	wire	wire_nlOi0Oi_dataout;
	wire	wire_nlOi0Ol_dataout;
	wire	wire_nlOi0OO_dataout;
	wire	wire_nlOi10i_dataout;
	wire	wire_nlOi10l_dataout;
	wire	wire_nlOi10O_dataout;
	wire	wire_nlOi11i_dataout;
	wire	wire_nlOi11l_dataout;
	wire	wire_nlOi11O_dataout;
	wire	wire_nlOi1ii_dataout;
	wire	wire_nlOi1il_dataout;
	wire	wire_nlOi1iO_dataout;
	wire	wire_nlOi1li_dataout;
	wire	wire_nlOi1ll_dataout;
	wire	wire_nlOi1lO_dataout;
	wire	wire_nlOi1Oi_dataout;
	wire	wire_nlOi1Ol_dataout;
	wire	wire_nlOi1OO_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOii0i_dataout;
	wire	wire_nlOii0l_dataout;
	wire	wire_nlOii0O_dataout;
	wire	wire_nlOii1i_dataout;
	wire	wire_nlOii1l_dataout;
	wire	wire_nlOii1O_dataout;
	wire	wire_nlOiiii_dataout;
	wire	wire_nlOiiil_dataout;
	wire	wire_nlOiiiO_dataout;
	wire	wire_nlOiili_dataout;
	wire	wire_nlOiill_dataout;
	wire	wire_nlOiilO_dataout;
	wire	wire_nlOiiOi_dataout;
	wire	wire_nlOiiOl_dataout;
	wire	wire_nlOiiOO_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOil0i_dataout;
	wire	wire_nlOil0l_dataout;
	wire	wire_nlOil0O_dataout;
	wire	wire_nlOil1i_dataout;
	wire	wire_nlOil1l_dataout;
	wire	wire_nlOil1O_dataout;
	wire	wire_nlOilii_dataout;
	wire	wire_nlOilil_dataout;
	wire	wire_nlOiliO_dataout;
	wire	wire_nlOilli_dataout;
	wire	wire_nlOilll_dataout;
	wire	wire_nlOillO_dataout;
	wire	wire_nlOilOi_dataout;
	wire	wire_nlOilOl_dataout;
	wire	wire_nlOilOO_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOiO0i_dataout;
	wire	wire_nlOiO0l_dataout;
	wire	wire_nlOiO0O_dataout;
	wire	wire_nlOiO1i_dataout;
	wire	wire_nlOiO1l_dataout;
	wire	wire_nlOiO1O_dataout;
	wire	wire_nlOiOii_dataout;
	wire	wire_nlOiOil_dataout;
	wire	wire_nlOiOiO_dataout;
	wire	wire_nlOiOli_dataout;
	wire	wire_nlOiOll_dataout;
	wire	wire_nlOiOlO_dataout;
	wire	wire_nlOiOOi_dataout;
	wire	wire_nlOiOOl_dataout;
	wire	wire_nlOiOOO_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOl01i_dataout;
	wire	wire_nlOl0i_dataout;
	wire	wire_nlOl0l_dataout;
	wire	wire_nlOl0O_dataout;
	wire	wire_nlOl10i_dataout;
	wire	wire_nlOl10l_dataout;
	wire	wire_nlOl11i_dataout;
	wire	wire_nlOl11l_dataout;
	wire	wire_nlOl11O_dataout;
	wire	wire_nlOl1l_dataout;
	wire	wire_nlOl1lO_dataout;
	wire	wire_nlOl1O_dataout;
	wire	wire_nlOl1Oi_dataout;
	wire	wire_nlOl1Ol_dataout;
	wire	wire_nlOl1OO_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOlii_dataout;
	wire	wire_nlOlil_dataout;
	wire	wire_nlOliO_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOlli_dataout;
	wire	wire_nlOlll_dataout;
	wire	wire_nlOllll_dataout;
	wire	wire_nlOlllO_dataout;
	wire	wire_nlOllOi_dataout;
	wire	wire_nlOllOl_dataout;
	wire	wire_nlOllOO_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOlO0i_dataout;
	wire	wire_nlOlO0l_dataout;
	wire	wire_nlOlO0O_dataout;
	wire	wire_nlOlO1i_dataout;
	wire	wire_nlOlO1l_dataout;
	wire	wire_nlOlO1O_dataout;
	wire	wire_nlOlOi_dataout;
	wire	wire_nlOlOii_dataout;
	wire	wire_nlOlOil_dataout;
	wire	wire_nlOlOiO_dataout;
	wire	wire_nlOlOli_dataout;
	wire	wire_nlOlOll_dataout;
	wire	wire_nlOlOlO_dataout;
	wire	wire_nlOlOOi_dataout;
	wire	wire_nlOlOOl_dataout;
	wire	wire_nlOlOOO_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOO00i_dataout;
	wire	wire_nlOO00l_dataout;
	wire	wire_nlOO00O_dataout;
	wire	wire_nlOO01i_dataout;
	wire	wire_nlOO01l_dataout;
	wire	wire_nlOO01O_dataout;
	wire	wire_nlOO0ii_dataout;
	wire	wire_nlOO0il_dataout;
	wire	wire_nlOO0iO_dataout;
	wire	wire_nlOO0li_dataout;
	wire	wire_nlOO0ll_dataout;
	wire	wire_nlOO0lO_dataout;
	wire	wire_nlOO0Oi_dataout;
	wire	wire_nlOO0Ol_dataout;
	wire	wire_nlOO0OO_dataout;
	wire	wire_nlOO10i_dataout;
	wire	wire_nlOO10l_dataout;
	wire	wire_nlOO10O_dataout;
	wire	wire_nlOO11i_dataout;
	wire	wire_nlOO11l_dataout;
	wire	wire_nlOO11O_dataout;
	wire	wire_nlOO1ii_dataout;
	wire	wire_nlOO1il_dataout;
	wire	wire_nlOO1iO_dataout;
	wire	wire_nlOO1li_dataout;
	wire	wire_nlOO1ll_dataout;
	wire	wire_nlOO1lO_dataout;
	wire	wire_nlOO1Oi_dataout;
	wire	wire_nlOO1Ol_dataout;
	wire	wire_nlOO1OO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOi0i_dataout;
	wire	wire_nlOOi0l_dataout;
	wire	wire_nlOOi0O_dataout;
	wire	wire_nlOOi1i_dataout;
	wire	wire_nlOOi1l_dataout;
	wire	wire_nlOOi1O_dataout;
	wire	wire_nlOOiii_dataout;
	wire	wire_nlOOiil_dataout;
	wire	wire_nlOOiiO_dataout;
	wire	wire_nlOOili_dataout;
	wire	wire_nlOOill_dataout;
	wire	wire_nlOOilO_dataout;
	wire	wire_nlOOiOi_dataout;
	wire	wire_nlOOiOl_dataout;
	wire	wire_nlOOiOO_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOl0i_dataout;
	wire	wire_nlOOl0l_dataout;
	wire	wire_nlOOl0O_dataout;
	wire	wire_nlOOl1i_dataout;
	wire	wire_nlOOl1l_dataout;
	wire	wire_nlOOl1O_dataout;
	wire	wire_nlOOlii_dataout;
	wire	wire_nlOOlil_dataout;
	wire	wire_nlOOliO_dataout;
	wire	wire_nlOOlli_dataout;
	wire	wire_nlOOlll_dataout;
	wire	wire_nlOOllO_dataout;
	wire	wire_nlOOlOi_dataout;
	wire	wire_nlOOlOl_dataout;
	wire	wire_nlOOlOO_dataout;
	wire	wire_nlOOO_dataout;
	wire	wire_nlOOO0i_dataout;
	wire	wire_nlOOO0l_dataout;
	wire	wire_nlOOO0O_dataout;
	wire	wire_nlOOOii_dataout;
	wire	wire_nlOOOil_dataout;
	wire	wire_nlOOOli_dataout;
	wire	wire_nlOOOll_dataout;
	wire	wire_nlOOOlO_dataout;
	wire	wire_nlOOOOi_dataout;
	wire	wire_nlOOOOl_dataout;
	wire	wire_nlOOOOO_dataout;
	wire	wire_nO_dataout;
	wire  [5:0]   wire_n1i0Ol_o;
	wire  [5:0]   wire_n1i0OO_o;
	wire  [2:0]   wire_n1i10O_o;
	wire  [5:0]   wire_n1i11O_o;
	wire  [5:0]   wire_n1ii1i_o;
	wire  [5:0]   wire_n1li0O_o;
	wire  [4:0]   wire_n1liii_o;
	wire  [3:0]   wire_n1liOi_o;
	wire  [4:0]   wire_n1liOO_o;
	wire  [2:0]   wire_n1O00i_o;
	wire  [4:0]   wire_niO1iO_o;
	wire  [5:0]   wire_nl0OOi_o;
	wire  [4:0]   wire_nl10Ol_o;
	wire  [5:0]   wire_nli0iO_o;
	wire  [5:0]   wire_nli0li_o;
	wire  [5:0]   wire_nli0ll_o;
	wire  [2:0]   wire_nli11i_o;
	wire  [5:0]   wire_nlilll_o;
	wire  [4:0]   wire_nlillO_o;
	wire  [4:0]   wire_nlOl01l_o;
	wire  [5:0]   wire_nlOOO1i_o;
	wire  [4:0]   wire_nlOOOiO_o;
	wire  [7:0]   wire_n001Ol_o;
	wire  [31:0]   wire_n11Oii_o;
	wire  [31:0]   wire_niO11O_o;
	wire  [31:0]   wire_nl1OiO_o;
	wire  [3:0]   wire_nlOl1i_o;
	wire  [31:0]   wire_nlOl1ll_o;
	wire  wire_n11i0l_o;
	wire  wire_n11i1l_o;
	wire  wire_n11l1i_o;
	wire  wire_n1i10l_o;
	wire  wire_n1i11l_o;
	wire  wire_n1i1ii_o;
	wire  wire_n1ii1l_o;
	wire  wire_n1ilii_o;
	wire  wire_n1l11O_o;
	wire  wire_n1lOll_o;
	wire  wire_n1lOlO_o;
	wire  wire_nl0OlO_o;
	wire  wire_nl0OOO_o;
	wire  wire_nl1l1O_o;
	wire  wire_nli0lO_o;
	wire  wire_nli11l_o;
	wire  wire_nlii0l_o;
	wire  wire_nlii1l_o;
	wire  wire_nliOlO_o;
	wire  wire_nliOOi_o;
	wire  wire_n0010i_o;
	wire  wire_n0010l_o;
	wire  wire_n0010O_o;
	wire  wire_n0011l_o;
	wire  wire_n0011O_o;
	wire  wire_n001ii_o;
	wire  wire_n001il_o;
	wire  wire_n001iO_o;
	wire  wire_n001li_o;
	wire  wire_n001ll_o;
	wire  wire_nlOill_o;
	wire  wire_nlOilO_o;
	wire  wire_nlOiOl_o;
	wire  wire_nlOiOO_o;
	wire  [15:0]   wire_nlOiii_data_out1;
	wire  [15:0]   wire_nlOiii_data_out2;
	wire  [15:0]   wire_nlOiil_data_out1;
	wire  [15:0]   wire_nlOiil_data_out2;
	wire  nliiOll;
	wire  nliiOlO;
	wire  nliiOOi;
	wire  nliiOOl;
	wire  nliiOOO;
	wire  nlil00i;
	wire  nlil00l;
	wire  nlil00O;
	wire  nlil01i;
	wire  nlil01l;
	wire  nlil01O;
	wire  nlil0ii;
	wire  nlil0il;
	wire  nlil0iO;
	wire  nlil0li;
	wire  nlil0ll;
	wire  nlil0lO;
	wire  nlil0Oi;
	wire  nlil0Ol;
	wire  nlil0OO;
	wire  nlil10i;
	wire  nlil10l;
	wire  nlil10O;
	wire  nlil11i;
	wire  nlil11l;
	wire  nlil11O;
	wire  nlil1ii;
	wire  nlil1il;
	wire  nlil1iO;
	wire  nlil1li;
	wire  nlil1ll;
	wire  nlil1lO;
	wire  nlil1Oi;
	wire  nlil1Ol;
	wire  nlil1OO;
	wire  nlili0i;
	wire  nlili0l;
	wire  nlili0O;
	wire  nlili1i;
	wire  nlili1l;
	wire  nlili1O;
	wire  nliliii;
	wire  nliliil;
	wire  nliliiO;
	wire  nlilili;
	wire  nlilill;
	wire  nlililO;
	wire  nliliOi;
	wire  nliliOl;
	wire  nliliOO;
	wire  nlill0i;
	wire  nlill0l;
	wire  nlill0O;
	wire  nlill1i;
	wire  nlill1l;
	wire  nlill1O;
	wire  nlillii;
	wire  nlillil;
	wire  nlilliO;
	wire  nlillli;
	wire  nlillll;
	wire  nlilllO;
	wire  nlillOi;
	wire  nlillOl;
	wire  nlillOO;
	wire  nlilO0i;
	wire  nlilO0l;
	wire  nlilO0O;
	wire  nlilO1i;
	wire  nlilO1l;
	wire  nlilO1O;
	wire  nlilOii;
	wire  nlilOil;
	wire  nlilOiO;
	wire  nlilOli;
	wire  nlilOll;
	wire  nlilOlO;
	wire  nlilOOi;
	wire  nlilOOl;
	wire  nlilOOO;
	wire  nliO00i;
	wire  nliO00l;
	wire  nliO00O;
	wire  nliO01i;
	wire  nliO01l;
	wire  nliO01O;
	wire  nliO0ii;
	wire  nliO0il;
	wire  nliO0iO;
	wire  nliO0li;
	wire  nliO0ll;
	wire  nliO0lO;
	wire  nliO0Oi;
	wire  nliO0Ol;
	wire  nliO0OO;
	wire  nliO10i;
	wire  nliO10l;
	wire  nliO10O;
	wire  nliO11i;
	wire  nliO11l;
	wire  nliO11O;
	wire  nliO1ii;
	wire  nliO1il;
	wire  nliO1iO;
	wire  nliO1li;
	wire  nliO1ll;
	wire  nliO1lO;
	wire  nliO1Oi;
	wire  nliO1Ol;
	wire  nliO1OO;
	wire  nliOi0i;
	wire  nliOi0l;
	wire  nliOi0O;
	wire  nliOi1i;
	wire  nliOi1l;
	wire  nliOi1O;
	wire  nliOiii;
	wire  nliOiil;
	wire  nliOiiO;
	wire  nliOili;
	wire  nliOill;
	wire  nliOilO;
	wire  nliOiOi;
	wire  nliOiOl;
	wire  nliOiOO;
	wire  nliOl0i;
	wire  nliOl0l;
	wire  nliOl0O;
	wire  nliOl1i;
	wire  nliOl1l;
	wire  nliOl1O;
	wire  nliOlii;
	wire  nliOlil;
	wire  nliOliO;
	wire  nliOlli;
	wire  nliOlll;
	wire  nliOllO;
	wire  nliOlOi;
	wire  nliOlOl;
	wire  nliOlOO;
	wire  nliOO0O;
	wire  nliOO1i;
	wire  nliOOii;
	wire  nliOOli;
	wire  nliOOll;
	wire  nliOOlO;
	wire  nliOOOi;
	wire  nliOOOl;
	wire  nliOOOO;
	wire  nll100l;
	wire  nll10il;
	wire  nll10iO;
	wire  nll110i;
	wire  nll11iO;
	wire  nll11li;
	wire  nll11ll;
	wire  nll11lO;
	wire  nll11Oi;
	wire  nll1i0i;
	wire  nll1i0l;
	wire  nll1i0O;
	wire  nll1i1i;
	wire  nll1iiO;
	wire  nll1ili;
	wire  nll1ill;
	wire  nll1ilO;

	initial
		nliOO0i55 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nliOO0i55 <= nliOO0i57;
	initial
		nliOO0i56 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nliOO0i56 <= (nliOO0i57 ^ nliOO0i55);
	initial
		nliOO0i57 = 0;
	always @ ( posedge clk_2)
		  nliOO0i57 <= nliOO0i55;
	initial
		nliOO1l58 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nliOO1l58 <= nliOO1l60;
	initial
		nliOO1l59 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nliOO1l59 <= (nliOO1l60 ^ nliOO1l58);
	initial
		nliOO1l60 = 0;
	always @ ( posedge clk_2)
		  nliOO1l60 <= nliOO1l58;
	initial
		nliOOil52 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nliOOil52 <= nliOOil54;
	initial
		nliOOil53 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nliOOil53 <= (nliOOil54 ^ nliOOil52);
	initial
		nliOOil54 = 0;
	always @ ( posedge clk_2)
		  nliOOil54 <= nliOOil52;
	initial
		nll100O19 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll100O19 <= nll100O21;
	initial
		nll100O20 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll100O20 <= (nll100O21 ^ nll100O19);
	initial
		nll100O21 = 0;
	always @ ( posedge clk_2)
		  nll100O21 <= nll100O19;
	initial
		nll101i25 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll101i25 <= nll101i27;
	initial
		nll101i26 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll101i26 <= (nll101i27 ^ nll101i25);
	initial
		nll101i27 = 0;
	always @ ( posedge clk_2)
		  nll101i27 <= nll101i25;
	initial
		nll101O22 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll101O22 <= nll101O24;
	initial
		nll101O23 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll101O23 <= (nll101O24 ^ nll101O22);
	initial
		nll101O24 = 0;
	always @ ( posedge clk_2)
		  nll101O24 <= nll101O22;
	initial
		nll10li16 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll10li16 <= nll10li18;
	initial
		nll10li17 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll10li17 <= (nll10li18 ^ nll10li16);
	initial
		nll10li18 = 0;
	always @ ( posedge clk_2)
		  nll10li18 <= nll10li16;
	initial
		nll10lO13 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll10lO13 <= nll10lO15;
	initial
		nll10lO14 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll10lO14 <= (nll10lO15 ^ nll10lO13);
	initial
		nll10lO15 = 0;
	always @ ( posedge clk_2)
		  nll10lO15 <= nll10lO13;
	initial
		nll10Ol10 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll10Ol10 <= nll10Ol12;
	initial
		nll10Ol11 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll10Ol11 <= (nll10Ol12 ^ nll10Ol10);
	initial
		nll10Ol12 = 0;
	always @ ( posedge clk_2)
		  nll10Ol12 <= nll10Ol10;
	initial
		nll110l40 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll110l40 <= nll110l42;
	initial
		nll110l41 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll110l41 <= (nll110l42 ^ nll110l40);
	initial
		nll110l42 = 0;
	always @ ( posedge clk_2)
		  nll110l42 <= nll110l40;
	initial
		nll110O37 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll110O37 <= nll110O39;
	initial
		nll110O38 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll110O38 <= (nll110O39 ^ nll110O37);
	initial
		nll110O39 = 0;
	always @ ( posedge clk_2)
		  nll110O39 <= nll110O37;
	initial
		nll111i49 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll111i49 <= nll111i51;
	initial
		nll111i50 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll111i50 <= (nll111i51 ^ nll111i49);
	initial
		nll111i51 = 0;
	always @ ( posedge clk_2)
		  nll111i51 <= nll111i49;
	initial
		nll111l46 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll111l46 <= nll111l48;
	initial
		nll111l47 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll111l47 <= (nll111l48 ^ nll111l46);
	initial
		nll111l48 = 0;
	always @ ( posedge clk_2)
		  nll111l48 <= nll111l46;
	initial
		nll111O43 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll111O43 <= nll111O45;
	initial
		nll111O44 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll111O44 <= (nll111O45 ^ nll111O43);
	initial
		nll111O45 = 0;
	always @ ( posedge clk_2)
		  nll111O45 <= nll111O43;
	initial
		nll11ii34 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll11ii34 <= nll11ii36;
	initial
		nll11ii35 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll11ii35 <= (nll11ii36 ^ nll11ii34);
	initial
		nll11ii36 = 0;
	always @ ( posedge clk_2)
		  nll11ii36 <= nll11ii34;
	initial
		nll11il31 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll11il31 <= nll11il33;
	initial
		nll11il32 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll11il32 <= (nll11il33 ^ nll11il31);
	initial
		nll11il33 = 0;
	always @ ( posedge clk_2)
		  nll11il33 <= nll11il31;
	initial
		nll11Ol28 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll11Ol28 <= nll11Ol30;
	initial
		nll11Ol29 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll11Ol29 <= (nll11Ol30 ^ nll11Ol28);
	initial
		nll11Ol30 = 0;
	always @ ( posedge clk_2)
		  nll11Ol30 <= nll11Ol28;
	initial
		nll1i1l7 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll1i1l7 <= nll1i1l9;
	initial
		nll1i1l8 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll1i1l8 <= (nll1i1l9 ^ nll1i1l7);
	initial
		nll1i1l9 = 0;
	always @ ( posedge clk_2)
		  nll1i1l9 <= nll1i1l7;
	initial
		nll1iii4 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll1iii4 <= nll1iii6;
	initial
		nll1iii5 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll1iii5 <= (nll1iii6 ^ nll1iii4);
	initial
		nll1iii6 = 0;
	always @ ( posedge clk_2)
		  nll1iii6 <= nll1iii4;
	initial
		nll1iOi1 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll1iOi1 <= nll1iOi3;
	initial
		nll1iOi2 = {1{1'b1}};
	always @ ( posedge clk_2)
		  nll1iOi2 <= (nll1iOi3 ^ nll1iOi1);
	initial
		nll1iOi3 = 0;
	always @ ( posedge clk_2)
		  nll1iOi3 <= nll1iOi1;
	initial
	begin
		n0OilO = 0;
		n0OiOl = 0;
		nllll0O = 0;
		nllllii = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			n0OilO <= 1;
			n0OiOl <= 1;
			nllll0O <= 1;
			nllllii <= 1;
		end
		else 
		begin
			n0OilO <= wire_niilOl_dataout;
			n0OiOl <= wire_nil11O_dataout;
			nllll0O <= wire_nlO0Oii_dataout;
			nllllii <= wire_nlOi1ll_dataout;
		end
	end
	initial
	begin
		n0Olii = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			n0Olii <= 0;
		end
		else if  (wire_n0Ol0O_ENA == 1'b1) 
		begin
			n0Olii <= wire_nlOiii_data_out2[0];
		end
	end
	assign
		wire_n0Ol0O_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		n0OiOO = 0;
		n0Ol0i = 0;
		n0Ol1i = 0;
		n0Ol1l = 0;
		nllllil = 0;
		nlllliO = 0;
		nllllli = 0;
		nllllll = 0;
	end
	always @ ( posedge clk_1 or posedge wire_nil_dataout)
	begin
		if (wire_nil_dataout == 1'b1) 
		begin
			n0OiOO <= 1;
			n0Ol0i <= 1;
			n0Ol1i <= 1;
			n0Ol1l <= 1;
			nllllil <= 1;
			nlllliO <= 1;
			nllllli <= 1;
			nllllll <= 1;
		end
		else 
		begin
			n0OiOO <= wire_niOliO_dataout;
			n0Ol0i <= wire_nl0O1i_dataout;
			n0Ol1i <= wire_nl0lOl_dataout;
			n0Ol1l <= wire_nl0lOO_dataout;
			nllllil <= wire_nlOlO1i_dataout;
			nlllliO <= wire_n10O0i_dataout;
			nllllli <= wire_n10O0l_dataout;
			nllllll <= wire_n10O0O_dataout;
		end
	end
	initial
	begin
		n0OliO = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			n0OliO <= 0;
		end
		else if  (wire_n0Olil_ENA == 1'b1) 
		begin
			n0OliO <= wire_nlOiii_data_out2[1];
		end
	end
	assign
		wire_n0Olil_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		n0Olll = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			n0Olll <= 0;
		end
		else if  (wire_n0Olli_ENA == 1'b1) 
		begin
			n0Olll <= wire_nlOiii_data_out2[2];
		end
	end
	assign
		wire_n0Olli_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		n0OlOi = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			n0OlOi <= 0;
		end
		else if  (wire_n0OllO_ENA == 1'b1) 
		begin
			n0OlOi <= wire_nlOiii_data_out2[3];
		end
	end
	assign
		wire_n0OllO_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		n0OlOO = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			n0OlOO <= 0;
		end
		else if  (wire_n0OlOl_ENA == 1'b1) 
		begin
			n0OlOO <= wire_nlOiii_data_out2[4];
		end
	end
	assign
		wire_n0OlOl_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		n0OO0O = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			n0OO0O <= 0;
		end
		else if  (wire_n0OO0l_ENA == 1'b1) 
		begin
			n0OO0O <= wire_nlOiii_data_out2[7];
		end
	end
	assign
		wire_n0OO0l_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		n0OO1l = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			n0OO1l <= 0;
		end
		else if  (wire_n0OO1i_ENA == 1'b1) 
		begin
			n0OO1l <= wire_nlOiii_data_out2[5];
		end
	end
	assign
		wire_n0OO1i_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		n0OO0i = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			n0OO0i <= 0;
		end
		else if  (wire_n0OO1O_ENA == 1'b1) 
		begin
			n0OO0i <= wire_nlOiii_data_out2[6];
		end
	end
	assign
		wire_n0OO1O_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		n0OOil = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			n0OOil <= 0;
		end
		else if  (wire_n0OOii_ENA == 1'b1) 
		begin
			n0OOil <= wire_nlOiii_data_out2[8];
		end
	end
	assign
		wire_n0OOii_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		n0OOli = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			n0OOli <= 0;
		end
		else if  (wire_n0OOiO_ENA == 1'b1) 
		begin
			n0OOli <= wire_nlOiii_data_out2[9];
		end
	end
	assign
		wire_n0OOiO_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		n0OOlO = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			n0OOlO <= 0;
		end
		else if  (wire_n0OOll_ENA == 1'b1) 
		begin
			n0OOlO <= wire_nlOiil_data_out2[0];
		end
	end
	assign
		wire_n0OOll_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		n0OOOl = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			n0OOOl <= 0;
		end
		else if  (wire_n0OOOi_ENA == 1'b1) 
		begin
			n0OOOl <= wire_nlOiil_data_out2[1];
		end
	end
	assign
		wire_n0OOOi_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		ni111i = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			ni111i <= 0;
		end
		else if  (wire_n0OOOO_ENA == 1'b1) 
		begin
			ni111i <= wire_nlOiil_data_out2[2];
		end
	end
	assign
		wire_n0OOOO_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		ni110l = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			ni110l <= 0;
		end
		else if  (wire_ni110i_ENA == 1'b1) 
		begin
			ni110l <= wire_nlOiil_data_out2[4];
		end
	end
	assign
		wire_ni110i_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		ni11ii = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			ni11ii <= 0;
		end
		else if  (wire_ni110O_ENA == 1'b1) 
		begin
			ni11ii <= wire_nlOiil_data_out2[5];
		end
	end
	assign
		wire_ni110O_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		ni111O = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			ni111O <= 0;
		end
		else if  (wire_ni111l_ENA == 1'b1) 
		begin
			ni111O <= wire_nlOiil_data_out2[3];
		end
	end
	assign
		wire_ni111l_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		ni11iO = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			ni11iO <= 0;
		end
		else if  (wire_ni11il_ENA == 1'b1) 
		begin
			ni11iO <= wire_nlOiil_data_out2[6];
		end
	end
	assign
		wire_ni11il_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		ni11ll = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			ni11ll <= 0;
		end
		else if  (wire_ni11li_ENA == 1'b1) 
		begin
			ni11ll <= wire_nlOiil_data_out2[7];
		end
	end
	assign
		wire_ni11li_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		ni11Oi = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			ni11Oi <= 0;
		end
		else if  (wire_ni11lO_ENA == 1'b1) 
		begin
			ni11Oi <= wire_nlOiil_data_out2[8];
		end
	end
	assign
		wire_ni11lO_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		ni11OO = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			ni11OO <= 0;
		end
		else if  (wire_ni11Ol_ENA == 1'b1) 
		begin
			ni11OO <= wire_nlOiil_data_out2[9];
		end
	end
	assign
		wire_ni11Ol_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		ni1iOl = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			ni1iOl <= 0;
		end
		else if  (wire_ni1iOi_ENA == 1'b1) 
		begin
			ni1iOl <= wire_nlOiil_data_out1[11];
		end
	end
	assign
		wire_ni1iOi_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		ni1l1l = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			ni1l1l <= 0;
		end
		else if  (wire_ni1l1i_ENA == 1'b1) 
		begin
			ni1l1l <= wire_nlOiil_data_out1[13];
		end
	end
	assign
		wire_ni1l1i_ENA = ((~ nl0l0O) & nliO1ii);
	initial
	begin
		nilll = 0;
		nilOi = 0;
	end
	always @ ( posedge clk_1 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nilll <= 1;
			nilOi <= 1;
		end
		else 
		begin
			nilll <= nilOi;
			nilOi <= nll11lO;
		end
	end
	initial
	begin
		nilOl = 0;
		niO1i = 0;
	end
	always @ ( posedge clk_2 or posedge hard_reset)
	begin
		if (hard_reset == 1'b1) 
		begin
			nilOl <= 1;
			niO1i <= 1;
		end
		else 
		begin
			nilOl <= wire_nll_dataout;
			niO1i <= nilOl;
		end
	end
	initial
	begin
		n00i0i = 0;
		n00iii = 0;
		n1000l = 0;
		n1000O = 0;
		n1001i = 0;
		n1001l = 0;
		n1001O = 0;
		n100ii = 0;
		n100il = 0;
		n100iO = 0;
		n1011i = 0;
		n1011l = 0;
		n101Oi = 0;
		n101Ol = 0;
		n101OO = 0;
		n10i0i = 0;
		n10iOl = 0;
		n10iOO = 0;
		n10l1i = 0;
		n10lll = 0;
		n11OiO = 0;
		n11Oli = 0;
		n11Oll = 0;
		n11OlO = 0;
		n11OOi = 0;
		n11OOl = 0;
		n11OOO = 0;
		n1iliO = 0;
		n1illi = 0;
		n1illl = 0;
		n1illO = 0;
		n1ilOi = 0;
		n1ilOl = 0;
		n1ilOO = 0;
		n1l10i = 0;
		n1lOOO = 0;
		n1O0OO = 0;
		n1O10i = 0;
		n1O10l = 0;
		n1O10O = 0;
		n1O11i = 0;
		n1O11l = 0;
		n1O11O = 0;
		ni0OOO = 0;
		ni100i = 0;
		ni100l = 0;
		ni100O = 0;
		ni101i = 0;
		ni101l = 0;
		ni101O = 0;
		ni10ii = 0;
		ni10il = 0;
		ni10iO = 0;
		ni10li = 0;
		ni10ll = 0;
		ni10lO = 0;
		ni10Oi = 0;
		ni10Ol = 0;
		ni10OO = 0;
		ni1i0i = 0;
		ni1i0l = 0;
		ni1i0O = 0;
		ni1i1i = 0;
		ni1i1l = 0;
		ni1i1O = 0;
		ni1iii = 0;
		ni1iil = 0;
		ni1iiO = 0;
		ni1ili = 0;
		ni1ill = 0;
		ni1ilO = 0;
		ni1iOO = 0;
		ni1l1O = 0;
		nii00i = 0;
		nii00l = 0;
		nii00O = 0;
		nii01i = 0;
		nii01l = 0;
		nii01O = 0;
		nii0ii = 0;
		nii0il = 0;
		nii0iO = 0;
		nii0li = 0;
		nii0ll = 0;
		nii0lO = 0;
		nii0Oi = 0;
		nii0Ol = 0;
		nii0OO = 0;
		nii10i = 0;
		nii10l = 0;
		nii10O = 0;
		nii11i = 0;
		nii11l = 0;
		nii11O = 0;
		nii1ii = 0;
		nii1il = 0;
		nii1iO = 0;
		nii1li = 0;
		nii1ll = 0;
		nii1lO = 0;
		nii1Oi = 0;
		nii1Ol = 0;
		nii1OO = 0;
		niii0i = 0;
		niii0l = 0;
		niii0O = 0;
		niii1i = 0;
		niii1l = 0;
		niii1O = 0;
		niiiii = 0;
		niiiil = 0;
		niiiiO = 0;
		niiili = 0;
		niiill = 0;
		niiilO = 0;
		niiiOi = 0;
		niiiOl = 0;
		niiiOO = 0;
		niil1i = 0;
		niil1l = 0;
		niO1OO = 0;
		nl000l = 0;
		nl000O = 0;
		nl001i = 0;
		nl001l = 0;
		nl001O = 0;
		nl00ii = 0;
		nl00il = 0;
		nl00iO = 0;
		nl010i = 0;
		nl011i = 0;
		nl011l = 0;
		nl011O = 0;
		nl01OO = 0;
		nl0i1O = 0;
		nl0ill = 0;
		nl0ilO = 0;
		nl0iOi = 0;
		nl0l0O = 0;
		nl1Oll = 0;
		nl1OlO = 0;
		nl1OOi = 0;
		nl1OOl = 0;
		nl1OOO = 0;
		nll11i = 0;
		nll11l = 0;
		nll1l0O = 0;
		nll1l1O = 0;
		nll1ll = 0;
		nllOlli = 0;
		nllOlll = 0;
		nllOllO = 0;
		nllOlOi = 0;
		nllOlOl = 0;
		nllOlOO = 0;
		nllOO0i = 0;
		nllOO0l = 0;
		nllOO1i = 0;
		nllOO1l = 0;
		nllOO1O = 0;
		nllOOii = 0;
		nllOOli = 0;
		nlO000i = 0;
		nlO000l = 0;
		nlO000O = 0;
		nlO001i = 0;
		nlO001l = 0;
		nlO001O = 0;
		nlO00ii = 0;
		nlO00il = 0;
		nlO00iO = 0;
		nlO00li = 0;
		nlO00ll = 0;
		nlO00lO = 0;
		nlO00Oi = 0;
		nlO00Ol = 0;
		nlO00OO = 0;
		nlO01il = 0;
		nlO01iO = 0;
		nlO01li = 0;
		nlO01ll = 0;
		nlO01lO = 0;
		nlO01Oi = 0;
		nlO01Ol = 0;
		nlO01OO = 0;
		nlO0i0i = 0;
		nlO0i0l = 0;
		nlO0i0O = 0;
		nlO0i1i = 0;
		nlO0i1l = 0;
		nlO0i1O = 0;
		nlO0iii = 0;
		nlO0iil = 0;
		nlO0iiO = 0;
		nlO0ili = 0;
		nlO0ill = 0;
		nlO0ilO = 0;
		nlO0iOi = 0;
		nlO0iOl = 0;
		nlO0iOO = 0;
		nlO0l0i = 0;
		nlO0l0l = 0;
		nlO0l0O = 0;
		nlO0l1i = 0;
		nlO0l1l = 0;
		nlO0l1O = 0;
		nlO0lii = 0;
		nlO0lil = 0;
		nlO0liO = 0;
		nlO0lli = 0;
		nlOl0ii = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			n00i0i <= 0;
			n00iii <= 0;
			n1000l <= 0;
			n1000O <= 0;
			n1001i <= 0;
			n1001l <= 0;
			n1001O <= 0;
			n100ii <= 0;
			n100il <= 0;
			n100iO <= 0;
			n1011i <= 0;
			n1011l <= 0;
			n101Oi <= 0;
			n101Ol <= 0;
			n101OO <= 0;
			n10i0i <= 0;
			n10iOl <= 0;
			n10iOO <= 0;
			n10l1i <= 0;
			n10lll <= 0;
			n11OiO <= 0;
			n11Oli <= 0;
			n11Oll <= 0;
			n11OlO <= 0;
			n11OOi <= 0;
			n11OOl <= 0;
			n11OOO <= 0;
			n1iliO <= 0;
			n1illi <= 0;
			n1illl <= 0;
			n1illO <= 0;
			n1ilOi <= 0;
			n1ilOl <= 0;
			n1ilOO <= 0;
			n1l10i <= 0;
			n1lOOO <= 0;
			n1O0OO <= 0;
			n1O10i <= 0;
			n1O10l <= 0;
			n1O10O <= 0;
			n1O11i <= 0;
			n1O11l <= 0;
			n1O11O <= 0;
			ni0OOO <= 0;
			ni100i <= 0;
			ni100l <= 0;
			ni100O <= 0;
			ni101i <= 0;
			ni101l <= 0;
			ni101O <= 0;
			ni10ii <= 0;
			ni10il <= 0;
			ni10iO <= 0;
			ni10li <= 0;
			ni10ll <= 0;
			ni10lO <= 0;
			ni10Oi <= 0;
			ni10Ol <= 0;
			ni10OO <= 0;
			ni1i0i <= 0;
			ni1i0l <= 0;
			ni1i0O <= 0;
			ni1i1i <= 0;
			ni1i1l <= 0;
			ni1i1O <= 0;
			ni1iii <= 0;
			ni1iil <= 0;
			ni1iiO <= 0;
			ni1ili <= 0;
			ni1ill <= 0;
			ni1ilO <= 0;
			ni1iOO <= 0;
			ni1l1O <= 0;
			nii00i <= 0;
			nii00l <= 0;
			nii00O <= 0;
			nii01i <= 0;
			nii01l <= 0;
			nii01O <= 0;
			nii0ii <= 0;
			nii0il <= 0;
			nii0iO <= 0;
			nii0li <= 0;
			nii0ll <= 0;
			nii0lO <= 0;
			nii0Oi <= 0;
			nii0Ol <= 0;
			nii0OO <= 0;
			nii10i <= 0;
			nii10l <= 0;
			nii10O <= 0;
			nii11i <= 0;
			nii11l <= 0;
			nii11O <= 0;
			nii1ii <= 0;
			nii1il <= 0;
			nii1iO <= 0;
			nii1li <= 0;
			nii1ll <= 0;
			nii1lO <= 0;
			nii1Oi <= 0;
			nii1Ol <= 0;
			nii1OO <= 0;
			niii0i <= 0;
			niii0l <= 0;
			niii0O <= 0;
			niii1i <= 0;
			niii1l <= 0;
			niii1O <= 0;
			niiiii <= 0;
			niiiil <= 0;
			niiiiO <= 0;
			niiili <= 0;
			niiill <= 0;
			niiilO <= 0;
			niiiOi <= 0;
			niiiOl <= 0;
			niiiOO <= 0;
			niil1i <= 0;
			niil1l <= 0;
			niO1OO <= 0;
			nl000l <= 0;
			nl000O <= 0;
			nl001i <= 0;
			nl001l <= 0;
			nl001O <= 0;
			nl00ii <= 0;
			nl00il <= 0;
			nl00iO <= 0;
			nl010i <= 0;
			nl011i <= 0;
			nl011l <= 0;
			nl011O <= 0;
			nl01OO <= 0;
			nl0i1O <= 0;
			nl0ill <= 0;
			nl0ilO <= 0;
			nl0iOi <= 0;
			nl0l0O <= 0;
			nl1Oll <= 0;
			nl1OlO <= 0;
			nl1OOi <= 0;
			nl1OOl <= 0;
			nl1OOO <= 0;
			nll11i <= 0;
			nll11l <= 0;
			nll1l0O <= 0;
			nll1l1O <= 0;
			nll1ll <= 0;
			nllOlli <= 0;
			nllOlll <= 0;
			nllOllO <= 0;
			nllOlOi <= 0;
			nllOlOl <= 0;
			nllOlOO <= 0;
			nllOO0i <= 0;
			nllOO0l <= 0;
			nllOO1i <= 0;
			nllOO1l <= 0;
			nllOO1O <= 0;
			nllOOii <= 0;
			nllOOli <= 0;
			nlO000i <= 0;
			nlO000l <= 0;
			nlO000O <= 0;
			nlO001i <= 0;
			nlO001l <= 0;
			nlO001O <= 0;
			nlO00ii <= 0;
			nlO00il <= 0;
			nlO00iO <= 0;
			nlO00li <= 0;
			nlO00ll <= 0;
			nlO00lO <= 0;
			nlO00Oi <= 0;
			nlO00Ol <= 0;
			nlO00OO <= 0;
			nlO01il <= 0;
			nlO01iO <= 0;
			nlO01li <= 0;
			nlO01ll <= 0;
			nlO01lO <= 0;
			nlO01Oi <= 0;
			nlO01Ol <= 0;
			nlO01OO <= 0;
			nlO0i0i <= 0;
			nlO0i0l <= 0;
			nlO0i0O <= 0;
			nlO0i1i <= 0;
			nlO0i1l <= 0;
			nlO0i1O <= 0;
			nlO0iii <= 0;
			nlO0iil <= 0;
			nlO0iiO <= 0;
			nlO0ili <= 0;
			nlO0ill <= 0;
			nlO0ilO <= 0;
			nlO0iOi <= 0;
			nlO0iOl <= 0;
			nlO0iOO <= 0;
			nlO0l0i <= 0;
			nlO0l0l <= 0;
			nlO0l0O <= 0;
			nlO0l1i <= 0;
			nlO0l1l <= 0;
			nlO0l1O <= 0;
			nlO0lii <= 0;
			nlO0lil <= 0;
			nlO0liO <= 0;
			nlO0lli <= 0;
			nlOl0ii <= 0;
		end
		else 
		begin
			n00i0i <= wire_n00i0l_dataout;
			n00iii <= wire_n00i0O_dataout;
			n1000l <= align_status;
			n1000O <= wire_n100li_dataout;
			n1001i <= n1001l;
			n1001l <= sync_status;
			n1001O <= n1000l;
			n100ii <= wire_n100ll_dataout;
			n100il <= wire_n100lO_dataout;
			n100iO <= wire_n100Oi_dataout;
			n1011i <= wire_n101li_dataout;
			n1011l <= wire_n101ll_dataout;
			n101Oi <= wire_n101lO_dataout;
			n101Ol <= n101OO;
			n101OO <= (rgenericfifo & rdenable);
			n10i0i <= wire_n100Ol_dataout;
			n10iOl <= n10iOO;
			n10iOO <= n10lll;
			n10l1i <= wire_n10l1l_dataout;
			n10lll <= wire_n10l1O_dataout;
			n11OiO <= wire_n1011O_dataout;
			n11Oli <= wire_n1010i_dataout;
			n11Oll <= wire_n1010l_dataout;
			n11OlO <= wire_n1010O_dataout;
			n11OOi <= wire_n101ii_dataout;
			n11OOl <= wire_n101il_dataout;
			n11OOO <= wire_n101iO_dataout;
			n1iliO <= wire_n1iO1i_dataout;
			n1illi <= wire_n1iO1l_dataout;
			n1illl <= wire_n1iO1O_dataout;
			n1illO <= wire_n1iO0i_dataout;
			n1ilOi <= wire_n1iO0l_dataout;
			n1ilOl <= wire_n1iO0O_dataout;
			n1ilOO <= wire_n1iOii_dataout;
			n1l10i <= wire_n1iOil_dataout;
			n1lOOO <= wire_n1lOOl_dataout;
			n1O0OO <= wire_n1O0iO_dataout;
			n1O10i <= wire_n1O1ii_dataout;
			n1O10l <= wire_n1O1il_dataout;
			n1O10O <= wire_n1O1iO_dataout;
			n1O11i <= wire_n1O0li_dataout;
			n1O11l <= wire_n1O0lO_dataout;
			n1O11O <= wire_n1O0ll_dataout;
			ni0OOO <= wire_ni011O_dataout;
			ni100i <= wire_ni1lii_dataout;
			ni100l <= wire_ni1lil_dataout;
			ni100O <= wire_ni1liO_dataout;
			ni101i <= wire_ni1l0i_dataout;
			ni101l <= wire_ni1l0l_dataout;
			ni101O <= wire_ni1l0O_dataout;
			ni10ii <= wire_ni1lli_dataout;
			ni10il <= wire_ni1lll_dataout;
			ni10iO <= wire_ni1llO_dataout;
			ni10li <= wire_ni1lOi_dataout;
			ni10ll <= wire_ni1lOl_dataout;
			ni10lO <= wire_ni1lOO_dataout;
			ni10Oi <= wire_ni1O1i_dataout;
			ni10Ol <= wire_ni1O1l_dataout;
			ni10OO <= wire_ni1O1O_dataout;
			ni1i0i <= wire_ni1Oii_dataout;
			ni1i0l <= wire_ni1Oil_dataout;
			ni1i0O <= wire_ni1OiO_dataout;
			ni1i1i <= wire_ni1O0i_dataout;
			ni1i1l <= wire_ni1O0l_dataout;
			ni1i1O <= wire_ni1O0O_dataout;
			ni1iii <= wire_ni1Oli_dataout;
			ni1iil <= wire_ni1Oll_dataout;
			ni1iiO <= wire_ni1OlO_dataout;
			ni1ili <= wire_ni1OOi_dataout;
			ni1ill <= wire_ni1OOl_dataout;
			ni1ilO <= wire_ni1OOO_dataout;
			ni1iOO <= wire_ni011i_dataout;
			ni1l1O <= wire_ni011l_dataout;
			nii00i <= wire_niiOii_dataout;
			nii00l <= wire_niiOil_dataout;
			nii00O <= wire_niiOiO_dataout;
			nii01i <= wire_niiO0i_dataout;
			nii01l <= wire_niiO0l_dataout;
			nii01O <= wire_niiO0O_dataout;
			nii0ii <= wire_niiOli_dataout;
			nii0il <= wire_niiOll_dataout;
			nii0iO <= wire_niiOlO_dataout;
			nii0li <= wire_niiOOi_dataout;
			nii0ll <= wire_niiOOl_dataout;
			nii0lO <= wire_niiOOO_dataout;
			nii0Oi <= wire_nil11i_dataout;
			nii0Ol <= wire_nil11l_dataout;
			nii0OO <= wire_nil10i_dataout;
			nii10i <= wire_niil0O_dataout;
			nii10l <= wire_niilii_dataout;
			nii10O <= wire_niilil_dataout;
			nii11i <= wire_niil1O_dataout;
			nii11l <= wire_niil0i_dataout;
			nii11O <= wire_niil0l_dataout;
			nii1ii <= wire_niiliO_dataout;
			nii1il <= wire_niilli_dataout;
			nii1iO <= wire_niilll_dataout;
			nii1li <= wire_niillO_dataout;
			nii1ll <= wire_niilOi_dataout;
			nii1lO <= wire_niilOO_dataout;
			nii1Oi <= wire_niiO1i_dataout;
			nii1Ol <= wire_niiO1l_dataout;
			nii1OO <= wire_niiO1O_dataout;
			niii0i <= wire_nil1il_dataout;
			niii0l <= wire_nil1iO_dataout;
			niii0O <= wire_nil1li_dataout;
			niii1i <= wire_nil10l_dataout;
			niii1l <= wire_nil10O_dataout;
			niii1O <= wire_nil1ii_dataout;
			niiiii <= wire_nil1ll_dataout;
			niiiil <= wire_nil1lO_dataout;
			niiiiO <= wire_nil1Oi_dataout;
			niiili <= wire_nil1Ol_dataout;
			niiill <= wire_nil1OO_dataout;
			niiilO <= wire_nil01i_dataout;
			niiiOi <= wire_nil01l_dataout;
			niiiOl <= wire_nil01O_dataout;
			niiiOO <= wire_nil00i_dataout;
			niil1i <= wire_nil00l_dataout;
			niil1l <= wire_nil00O_dataout;
			niO1OO <= wire_nil0ii_dataout;
			nl000l <= sync_status;
			nl000O <= wire_nl00li_dataout;
			nl001i <= nl001l;
			nl001l <= (rgenericfifo & rdenable);
			nl001O <= nl000l;
			nl00ii <= wire_nl00ll_dataout;
			nl00il <= wire_nl00lO_dataout;
			nl00iO <= wire_nl00Oi_dataout;
			nl010i <= wire_nl01Oi_dataout;
			nl011i <= wire_nl01li_dataout;
			nl011l <= wire_nl01ll_dataout;
			nl011O <= wire_nl01lO_dataout;
			nl01OO <= wire_nl01Ol_dataout;
			nl0i1O <= wire_nl00Ol_dataout;
			nl0ill <= nl0ilO;
			nl0ilO <= nl0l0O;
			nl0iOi <= wire_nl0iOl_dataout;
			nl0l0O <= wire_nl0iOO_dataout;
			nl1Oll <= wire_nl010l_dataout;
			nl1OlO <= wire_nl010O_dataout;
			nl1OOi <= wire_nl01ii_dataout;
			nl1OOl <= wire_nl01il_dataout;
			nl1OOO <= wire_nl01iO_dataout;
			nll11i <= wire_nliOOO_dataout;
			nll11l <= wire_nll10i_dataout;
			nll1l0O <= wire_nll1l0l_dataout;
			nll1l1O <= wire_nll1l0i_dataout;
			nll1ll <= wire_nll11O_dataout;
			nllOlli <= wire_nllOOll_dataout;
			nllOlll <= wire_nllOOlO_dataout;
			nllOllO <= wire_nllOOOi_dataout;
			nllOlOi <= wire_nllOOOl_dataout;
			nllOlOl <= wire_nllOOOO_dataout;
			nllOlOO <= wire_nlO111i_dataout;
			nllOO0i <= wire_nlO110l_dataout;
			nllOO0l <= wire_nlO110O_dataout;
			nllOO1i <= wire_nlO111l_dataout;
			nllOO1l <= wire_nlO111O_dataout;
			nllOO1O <= wire_nlO110i_dataout;
			nllOOii <= wire_nlO11ii_dataout;
			nllOOli <= wire_nlO11il_dataout;
			nlO000i <= wire_nlO0O0O_dataout;
			nlO000l <= wire_nlO0Oil_dataout;
			nlO000O <= wire_nlO0OiO_dataout;
			nlO001i <= wire_nlO0O1O_dataout;
			nlO001l <= wire_nlO0O0i_dataout;
			nlO001O <= wire_nlO0O0l_dataout;
			nlO00ii <= wire_nlO0Oli_dataout;
			nlO00il <= wire_nlO0Oll_dataout;
			nlO00iO <= wire_nlO0OlO_dataout;
			nlO00li <= wire_nlO0OOi_dataout;
			nlO00ll <= wire_nlO0OOl_dataout;
			nlO00lO <= wire_nlO0OOO_dataout;
			nlO00Oi <= wire_nlOi11i_dataout;
			nlO00Ol <= wire_nlOi11l_dataout;
			nlO00OO <= wire_nlOi11O_dataout;
			nlO01il <= wire_nlO11iO_dataout;
			nlO01iO <= wire_nlO0lll_dataout;
			nlO01li <= wire_nlO0llO_dataout;
			nlO01ll <= wire_nlO0lOi_dataout;
			nlO01lO <= wire_nlO0lOl_dataout;
			nlO01Oi <= wire_nlO0lOO_dataout;
			nlO01Ol <= wire_nlO0O1i_dataout;
			nlO01OO <= wire_nlO0O1l_dataout;
			nlO0i0i <= wire_nlOi1ii_dataout;
			nlO0i0l <= wire_nlOi1il_dataout;
			nlO0i0O <= wire_nlOi1iO_dataout;
			nlO0i1i <= wire_nlOi10i_dataout;
			nlO0i1l <= wire_nlOi10l_dataout;
			nlO0i1O <= wire_nlOi10O_dataout;
			nlO0iii <= wire_nlOi1li_dataout;
			nlO0iil <= wire_nlOi1lO_dataout;
			nlO0iiO <= wire_nlOi1Oi_dataout;
			nlO0ili <= wire_nlOi1Ol_dataout;
			nlO0ill <= wire_nlOi1OO_dataout;
			nlO0ilO <= wire_nlOi01i_dataout;
			nlO0iOi <= wire_nlOi01l_dataout;
			nlO0iOl <= wire_nlOi01O_dataout;
			nlO0iOO <= wire_nlOi00i_dataout;
			nlO0l0i <= wire_nlOi0il_dataout;
			nlO0l0l <= wire_nlOi0iO_dataout;
			nlO0l0O <= wire_nlOi0li_dataout;
			nlO0l1i <= wire_nlOi00l_dataout;
			nlO0l1l <= wire_nlOi00O_dataout;
			nlO0l1O <= wire_nlOi0ii_dataout;
			nlO0lii <= wire_nlOi0ll_dataout;
			nlO0lil <= wire_nlOi0lO_dataout;
			nlO0liO <= wire_nlOi0Oi_dataout;
			nlO0lli <= wire_nlOi0Ol_dataout;
			nlOl0ii <= wire_nlOi0OO_dataout;
		end
	end
	initial
	begin
		nllllOl = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllllOl <= 0;
		end
		else if  (wire_nllllOi_ENA == 1'b1) 
		begin
			nllllOl <= nllO1il;
		end
	end
	assign
		wire_nllllOi_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nlllO1i = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nlllO1i <= 0;
		end
		else if  (wire_nllllOO_ENA == 1'b1) 
		begin
			nlllO1i <= nllO1li;
		end
	end
	assign
		wire_nllllOO_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nlllO0l = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nlllO0l <= 0;
		end
		else if  (wire_nlllO0i_ENA == 1'b1) 
		begin
			nlllO0l <= nllO1Ol;
		end
	end
	assign
		wire_nlllO0i_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nlllOii = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nlllOii <= 0;
		end
		else if  (wire_nlllO0O_ENA == 1'b1) 
		begin
			nlllOii <= nllO01i;
		end
	end
	assign
		wire_nlllO0O_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nlllO1O = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nlllO1O <= 0;
		end
		else if  (wire_nlllO1l_ENA == 1'b1) 
		begin
			nlllO1O <= nllO1lO;
		end
	end
	assign
		wire_nlllO1l_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nlllOiO = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nlllOiO <= 0;
		end
		else if  (wire_nlllOil_ENA == 1'b1) 
		begin
			nlllOiO <= nllO01O;
		end
	end
	assign
		wire_nlllOil_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nlllOll = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nlllOll <= 0;
		end
		else if  (wire_nlllOli_ENA == 1'b1) 
		begin
			nlllOll <= nllO00l;
		end
	end
	assign
		wire_nlllOli_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nlllOOi = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nlllOOi <= 0;
		end
		else if  (wire_nlllOlO_ENA == 1'b1) 
		begin
			nlllOOi <= nllO0ii;
		end
	end
	assign
		wire_nlllOlO_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nlllOOO = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nlllOOO <= 0;
		end
		else if  (wire_nlllOOl_ENA == 1'b1) 
		begin
			nlllOOO <= nllO0iO;
		end
	end
	assign
		wire_nlllOOl_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO00l = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO00l <= 0;
		end
		else if  (wire_nllO00i_ENA == 1'b1) 
		begin
			nllO00l <= nllOiOl;
		end
	end
	assign
		wire_nllO00i_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO0ii = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO0ii <= 0;
		end
		else if  (wire_nllO00O_ENA == 1'b1) 
		begin
			nllO0ii <= nllOl1i;
		end
	end
	assign
		wire_nllO00O_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO01O = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO01O <= 0;
		end
		else if  (wire_nllO01l_ENA == 1'b1) 
		begin
			nllO01O <= nllOilO;
		end
	end
	assign
		wire_nllO01l_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO0iO = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO0iO <= 0;
		end
		else if  (wire_nllO0il_ENA == 1'b1) 
		begin
			nllO0iO <= nllOl1O;
		end
	end
	assign
		wire_nllO0il_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO0ll = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO0ll <= 0;
		end
		else if  (wire_nllO0li_ENA == 1'b1) 
		begin
			nllO0ll <= nllOl0l;
		end
	end
	assign
		wire_nllO0li_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO0Oi = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO0Oi <= 0;
		end
		else if  (wire_nllO0lO_ENA == 1'b1) 
		begin
			nllO0Oi <= nllOlii;
		end
	end
	assign
		wire_nllO0lO_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO0OO = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO0OO <= 0;
		end
		else if  (wire_nllO0Ol_ENA == 1'b1) 
		begin
			nllO0OO <= nllOliO;
		end
	end
	assign
		wire_nllO0Ol_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO10O = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO10O <= 0;
		end
		else if  (wire_nllO10l_ENA == 1'b1) 
		begin
			nllO10O <= nllO0OO;
		end
	end
	assign
		wire_nllO10l_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO11l = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO11l <= 0;
		end
		else if  (wire_nllO11i_ENA == 1'b1) 
		begin
			nllO11l <= nllO0ll;
		end
	end
	assign
		wire_nllO11i_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO10i = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO10i <= 0;
		end
		else if  (wire_nllO11O_ENA == 1'b1) 
		begin
			nllO10i <= nllO0Oi;
		end
	end
	assign
		wire_nllO11O_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO1il = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO1il <= 0;
		end
		else if  (wire_nllO1ii_ENA == 1'b1) 
		begin
			nllO1il <= nllOi1l;
		end
	end
	assign
		wire_nllO1ii_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO1li = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO1li <= 0;
		end
		else if  (wire_nllO1iO_ENA == 1'b1) 
		begin
			nllO1li <= nllOi0i;
		end
	end
	assign
		wire_nllO1iO_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO1lO = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO1lO <= 0;
		end
		else if  (wire_nllO1ll_ENA == 1'b1) 
		begin
			nllO1lO <= nllOi0O;
		end
	end
	assign
		wire_nllO1ll_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO1Ol = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO1Ol <= 0;
		end
		else if  (wire_nllO1Oi_ENA == 1'b1) 
		begin
			nllO1Ol <= nllOiil;
		end
	end
	assign
		wire_nllO1Oi_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllO01i = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllO01i <= 0;
		end
		else if  (wire_nllO1OO_ENA == 1'b1) 
		begin
			nllO01i <= nllOili;
		end
	end
	assign
		wire_nllO1OO_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllOi0O = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllOi0O <= 0;
		end
		else if  (wire_nllOi0l_ENA == 1'b1) 
		begin
			nllOi0O <= wire_nlOiii_data_out2[2];
		end
	end
	assign
		wire_nllOi0l_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllOi1l = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllOi1l <= 0;
		end
		else if  (wire_nllOi1i_ENA == 1'b1) 
		begin
			nllOi1l <= wire_nlOiii_data_out2[0];
		end
	end
	assign
		wire_nllOi1i_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllOi0i = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllOi0i <= 0;
		end
		else if  (wire_nllOi1O_ENA == 1'b1) 
		begin
			nllOi0i <= wire_nlOiii_data_out2[1];
		end
	end
	assign
		wire_nllOi1O_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllOiil = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllOiil <= 0;
		end
		else if  (wire_nllOiii_ENA == 1'b1) 
		begin
			nllOiil <= wire_nlOiii_data_out2[3];
		end
	end
	assign
		wire_nllOiii_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllOili = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllOili <= 0;
		end
		else if  (wire_nllOiiO_ENA == 1'b1) 
		begin
			nllOili <= wire_nlOiii_data_out2[4];
		end
	end
	assign
		wire_nllOiiO_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllOilO = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllOilO <= 0;
		end
		else if  (wire_nllOill_ENA == 1'b1) 
		begin
			nllOilO <= wire_nlOiii_data_out2[5];
		end
	end
	assign
		wire_nllOill_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllOiOl = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllOiOl <= 0;
		end
		else if  (wire_nllOiOi_ENA == 1'b1) 
		begin
			nllOiOl <= wire_nlOiii_data_out2[6];
		end
	end
	assign
		wire_nllOiOi_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllOl1i = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllOl1i <= 0;
		end
		else if  (wire_nllOiOO_ENA == 1'b1) 
		begin
			nllOl1i <= wire_nlOiii_data_out2[7];
		end
	end
	assign
		wire_nllOiOO_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllOl0l = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllOl0l <= 0;
		end
		else if  (wire_nllOl0i_ENA == 1'b1) 
		begin
			nllOl0l <= wire_nlOiii_data_out2[9];
		end
	end
	assign
		wire_nllOl0i_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllOlii = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllOlii <= 0;
		end
		else if  (wire_nllOl0O_ENA == 1'b1) 
		begin
			nllOlii <= wire_nlOiii_data_out2[11];
		end
	end
	assign
		wire_nllOl0O_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllOl1O = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllOl1O <= 0;
		end
		else if  (wire_nllOl1l_ENA == 1'b1) 
		begin
			nllOl1O <= wire_nlOiii_data_out2[8];
		end
	end
	assign
		wire_nllOl1l_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllOliO = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllOliO <= 0;
		end
		else if  (wire_nllOlil_ENA == 1'b1) 
		begin
			nllOliO <= wire_nlOiii_data_out2[13];
		end
	end
	assign
		wire_nllOlil_ENA = ((~ nlil1ll) & nliiOOl);
	initial
	begin
		nllOO0O = 0;
		nllOOiO = 0;
	end
	always @ ( posedge clk_2 or posedge nll1ilO)
	begin
		if (nll1ilO == 1'b1) 
		begin
			nllOO0O <= 0;
			nllOOiO <= 0;
		end
		else if  (nlil1ll == 1'b0) 
		begin
			nllOO0O <= wire_nlO100O_dataout;
			nllOOiO <= wire_nlO10il_dataout;
		end
	end
	initial
	begin
		n00i1O = 0;
		n0Ol0l = 0;
		n10iOi = 0;
		n10llO = 0;
		n10lOO = 0;
		n10O1i = 0;
		n10O1l = 0;
		n1110l = 0;
		n1110O = 0;
		n11l0i = 0;
		n11l0l = 0;
		n11l0O = 0;
		n11l1l = 0;
		n11l1O = 0;
		n11Oil = 0;
		n1i1il = 0;
		n1i1iO = 0;
		n1i1li = 0;
		n1i1ll = 0;
		n1i1lO = 0;
		n1ilil = 0;
		n1l10l = 0;
		n1l10O = 0;
		n1l1ii = 0;
		n1l1il = 0;
		n1l1iO = 0;
		n1lO0i = 0;
		n1lO0l = 0;
		n1lOOi = 0;
		n1Oi0i = 0;
		n1Oi0l = 0;
		n1Oi0O = 0;
		n1Oi1O = 0;
		n1Oiii = 0;
		n1Oiil = 0;
		niO00i = 0;
		niO00l = 0;
		niO00O = 0;
		niO01i = 0;
		niO01l = 0;
		niO01O = 0;
		niO0ii = 0;
		niO0il = 0;
		niO0iO = 0;
		niO0li = 0;
		niO0ll = 0;
		niO0lO = 0;
		niO0Oi = 0;
		niO0Ol = 0;
		niO0OO = 0;
		niOi0i = 0;
		niOi0l = 0;
		niOi0O = 0;
		niOi1i = 0;
		niOi1l = 0;
		niOi1O = 0;
		niOiii = 0;
		niOiil = 0;
		niOiiO = 0;
		niOili = 0;
		niOill = 0;
		niOilO = 0;
		niOiOi = 0;
		niOiOl = 0;
		niOiOO = 0;
		niOl1i = 0;
		niOl1l = 0;
		niOl1O = 0;
		nl0ili = 0;
		nl0lii = 0;
		nl0lli = 0;
		nl0lll = 0;
		nl0llO = 0;
		nl1ili = 0;
		nl1ill = 0;
		nl1l0i = 0;
		nl1l0l = 0;
		nl1l0O = 0;
		nl1lii = 0;
		nl1lil = 0;
		nl1Oli = 0;
		nli10i = 0;
		nli10l = 0;
		nli10O = 0;
		nli11O = 0;
		nli1ii = 0;
		nlii0O = 0;
		nliiii = 0;
		nliiil = 0;
		nliiiO = 0;
		nliili = 0;
		nliOil = 0;
		nliOiO = 0;
		nliOOl = 0;
		nll01i = 0;
		nll01l = 0;
		nll1l1l = 0;
		nll1lO = 0;
		nlllllO = 0;
		nlO00i = 0;
		nlO00l = 0;
		nlO00O = 0;
		nlO01i = 0;
		nlO01l = 0;
		nlO01O = 0;
		nlO0ii = 0;
		nlO0il = 0;
		nlO0iO = 0;
		nlO0li = 0;
		nlO0ll = 0;
		nlO0lO = 0;
		nlO0Oi = 0;
		nlO0Ol = 0;
		nlO0OO = 0;
		nlO1ii = 0;
		nlO1il = 0;
		nlO1iO = 0;
		nlO1li = 0;
		nlO1ll = 0;
		nlO1lO = 0;
		nlO1Oi = 0;
		nlO1Ol = 0;
		nlO1OO = 0;
		nlOi0i = 0;
		nlOi1i = 0;
		nlOi1l = 0;
		nlOi1O = 0;
		nlOiiO = 0;
		nlOili = 0;
		nlOl0il = 0;
		nlOl0iO = 0;
		nlOl0li = 0;
		nlOl0ll = 0;
		nlOl0lO = 0;
		nlOl0Oi = 0;
		nlOl0Ol = 0;
		nlOl0OO = 0;
		nlOli0i = 0;
		nlOli0l = 0;
		nlOli0O = 0;
		nlOli1i = 0;
		nlOli1l = 0;
		nlOli1O = 0;
		nlOliii = 0;
		nlOliil = 0;
		nlOliiO = 0;
		nlOlili = 0;
		nlOlill = 0;
		nlOlilO = 0;
		nlOliOi = 0;
		nlOliOl = 0;
		nlOliOO = 0;
		nlOll0i = 0;
		nlOll0l = 0;
		nlOll0O = 0;
		nlOll1i = 0;
		nlOll1l = 0;
		nlOll1O = 0;
		nlOllii = 0;
		nlOllil = 0;
		nlOlliO = 0;
		nlOllli = 0;
		nlOlOO = 0;
		nlOO1l = 0;
	end
	always @ ( posedge clk_1 or posedge wire_nil_dataout)
	begin
		if (wire_nil_dataout == 1'b1) 
		begin
			n00i1O <= 0;
			n0Ol0l <= 0;
			n10iOi <= 0;
			n10llO <= 0;
			n10lOO <= 0;
			n10O1i <= 0;
			n10O1l <= 0;
			n1110l <= 0;
			n1110O <= 0;
			n11l0i <= 0;
			n11l0l <= 0;
			n11l0O <= 0;
			n11l1l <= 0;
			n11l1O <= 0;
			n11Oil <= 0;
			n1i1il <= 0;
			n1i1iO <= 0;
			n1i1li <= 0;
			n1i1ll <= 0;
			n1i1lO <= 0;
			n1ilil <= 0;
			n1l10l <= 0;
			n1l10O <= 0;
			n1l1ii <= 0;
			n1l1il <= 0;
			n1l1iO <= 0;
			n1lO0i <= 0;
			n1lO0l <= 0;
			n1lOOi <= 0;
			n1Oi0i <= 0;
			n1Oi0l <= 0;
			n1Oi0O <= 0;
			n1Oi1O <= 0;
			n1Oiii <= 0;
			n1Oiil <= 0;
			niO00i <= 0;
			niO00l <= 0;
			niO00O <= 0;
			niO01i <= 0;
			niO01l <= 0;
			niO01O <= 0;
			niO0ii <= 0;
			niO0il <= 0;
			niO0iO <= 0;
			niO0li <= 0;
			niO0ll <= 0;
			niO0lO <= 0;
			niO0Oi <= 0;
			niO0Ol <= 0;
			niO0OO <= 0;
			niOi0i <= 0;
			niOi0l <= 0;
			niOi0O <= 0;
			niOi1i <= 0;
			niOi1l <= 0;
			niOi1O <= 0;
			niOiii <= 0;
			niOiil <= 0;
			niOiiO <= 0;
			niOili <= 0;
			niOill <= 0;
			niOilO <= 0;
			niOiOi <= 0;
			niOiOl <= 0;
			niOiOO <= 0;
			niOl1i <= 0;
			niOl1l <= 0;
			niOl1O <= 0;
			nl0ili <= 0;
			nl0lii <= 0;
			nl0lli <= 0;
			nl0lll <= 0;
			nl0llO <= 0;
			nl1ili <= 0;
			nl1ill <= 0;
			nl1l0i <= 0;
			nl1l0l <= 0;
			nl1l0O <= 0;
			nl1lii <= 0;
			nl1lil <= 0;
			nl1Oli <= 0;
			nli10i <= 0;
			nli10l <= 0;
			nli10O <= 0;
			nli11O <= 0;
			nli1ii <= 0;
			nlii0O <= 0;
			nliiii <= 0;
			nliiil <= 0;
			nliiiO <= 0;
			nliili <= 0;
			nliOil <= 0;
			nliOiO <= 0;
			nliOOl <= 0;
			nll01i <= 0;
			nll01l <= 0;
			nll1l1l <= 0;
			nll1lO <= 0;
			nlllllO <= 0;
			nlO00i <= 0;
			nlO00l <= 0;
			nlO00O <= 0;
			nlO01i <= 0;
			nlO01l <= 0;
			nlO01O <= 0;
			nlO0ii <= 0;
			nlO0il <= 0;
			nlO0iO <= 0;
			nlO0li <= 0;
			nlO0ll <= 0;
			nlO0lO <= 0;
			nlO0Oi <= 0;
			nlO0Ol <= 0;
			nlO0OO <= 0;
			nlO1ii <= 0;
			nlO1il <= 0;
			nlO1iO <= 0;
			nlO1li <= 0;
			nlO1ll <= 0;
			nlO1lO <= 0;
			nlO1Oi <= 0;
			nlO1Ol <= 0;
			nlO1OO <= 0;
			nlOi0i <= 0;
			nlOi1i <= 0;
			nlOi1l <= 0;
			nlOi1O <= 0;
			nlOiiO <= 0;
			nlOili <= 0;
			nlOl0il <= 0;
			nlOl0iO <= 0;
			nlOl0li <= 0;
			nlOl0ll <= 0;
			nlOl0lO <= 0;
			nlOl0Oi <= 0;
			nlOl0Ol <= 0;
			nlOl0OO <= 0;
			nlOli0i <= 0;
			nlOli0l <= 0;
			nlOli0O <= 0;
			nlOli1i <= 0;
			nlOli1l <= 0;
			nlOli1O <= 0;
			nlOliii <= 0;
			nlOliil <= 0;
			nlOliiO <= 0;
			nlOlili <= 0;
			nlOlill <= 0;
			nlOlilO <= 0;
			nlOliOi <= 0;
			nlOliOl <= 0;
			nlOliOO <= 0;
			nlOll0i <= 0;
			nlOll0l <= 0;
			nlOll0O <= 0;
			nlOll1i <= 0;
			nlOll1l <= 0;
			nlOll1O <= 0;
			nlOllii <= 0;
			nlOllil <= 0;
			nlOlliO <= 0;
			nlOllli <= 0;
			nlOlOO <= 0;
			nlOO1l <= 0;
		end
		else 
		begin
			n00i1O <= wire_n00iil_dataout;
			n0Ol0l <= sudi[27];
			n10iOi <= wire_n10i0l_dataout;
			n10llO <= n10lOO;
			n10lOO <= nlill0l;
			n10O1i <= wire_n10O1O_dataout;
			n10O1l <= wire_n10Oii_dataout;
			n1110l <= wire_nlOO10l_dataout;
			n1110O <= n11l1l;
			n11l0i <= wire_n11lil_dataout;
			n11l0l <= wire_n11liO_dataout;
			n11l0O <= wire_n11lli_dataout;
			n11l1l <= (rgenericfifo & wrenable);
			n11l1O <= wire_n11lii_dataout;
			n11Oil <= wire_n11lll_dataout;
			n1i1il <= wire_n10Oil_dataout;
			n1i1iO <= wire_n1i1Oi_dataout;
			n1i1li <= wire_n1i1Ol_dataout;
			n1i1ll <= wire_n1i1OO_dataout;
			n1i1lO <= wire_n1i01i_dataout;
			n1ilil <= wire_n1i01l_dataout;
			n1l10l <= wire_n1l1li_dataout;
			n1l10O <= wire_n1l1ll_dataout;
			n1l1ii <= wire_n1l1lO_dataout;
			n1l1il <= wire_n1l1Oi_dataout;
			n1l1iO <= wire_n1l1Ol_dataout;
			n1lO0i <= wire_n1l1OO_dataout;
			n1lO0l <= wire_n1lO0O_dataout;
			n1lOOi <= wire_n1lOii_dataout;
			n1Oi0i <= (rclkcmpsqmd & (wire_n011lO_dataout & (n1Oi0O | (n1Oiii | (n1Oiil | nlillOi)))));
			n1Oi0l <= wire_n1OiiO_dataout;
			n1Oi0O <= wire_n1Oill_dataout;
			n1Oi1O <= wire_n1Oi1i_dataout;
			n1Oiii <= wire_n1OiOi_dataout;
			n1Oiil <= wire_n1Ol1l_dataout;
			niO00i <= wire_niOlii_dataout;
			niO00l <= wire_niOlil_dataout;
			niO00O <= wire_nl10OO_dataout;
			niO01i <= wire_niOl0i_dataout;
			niO01l <= wire_niOl0l_dataout;
			niO01O <= wire_niOl0O_dataout;
			niO0ii <= wire_nl1i1i_dataout;
			niO0il <= wire_nl1i1l_dataout;
			niO0iO <= wire_nl1i1O_dataout;
			niO0li <= wire_nl1i0i_dataout;
			niO0ll <= wire_nl1i0l_dataout;
			niO0lO <= wire_nl1i0O_dataout;
			niO0Oi <= wire_nl1iii_dataout;
			niO0Ol <= wire_nl1iil_dataout;
			niO0OO <= wire_nl1iiO_dataout;
			niOi0i <= wire_niOlOi_dataout;
			niOi0l <= wire_niOlOl_dataout;
			niOi0O <= wire_niOlOO_dataout;
			niOi1i <= wire_niOlli_dataout;
			niOi1l <= wire_niOlll_dataout;
			niOi1O <= wire_niOllO_dataout;
			niOiii <= wire_niOO1i_dataout;
			niOiil <= wire_niOO1l_dataout;
			niOiiO <= wire_niOO1O_dataout;
			niOili <= wire_niOO0i_dataout;
			niOill <= wire_niOO0l_dataout;
			niOilO <= wire_niOO0O_dataout;
			niOiOi <= wire_niOOii_dataout;
			niOiOl <= wire_niOOil_dataout;
			niOiOO <= wire_niOOiO_dataout;
			niOl1i <= wire_niOOli_dataout;
			niOl1l <= wire_niOOll_dataout;
			niOl1O <= wire_niOOlO_dataout;
			nl0ili <= wire_nl0i0i_dataout;
			nl0lii <= nl0lli;
			nl0lli <= nliOl1l;
			nl0lll <= wire_nl0lOi_dataout;
			nl0llO <= wire_nl0O1l_dataout;
			nl1ili <= wire_niOOOi_dataout;
			nl1ill <= nl1l0i;
			nl1l0i <= (rgenericfifo & wrenable);
			nl1l0l <= wire_nl1liO_dataout;
			nl1l0O <= wire_nl1lli_dataout;
			nl1lii <= wire_nl1lll_dataout;
			nl1lil <= wire_nl1llO_dataout;
			nl1Oli <= wire_nl1lOi_dataout;
			nli10i <= wire_nli1il_dataout;
			nli10l <= wire_nli1iO_dataout;
			nli10O <= wire_nli1li_dataout;
			nli11O <= wire_nl0O1O_dataout;
			nli1ii <= wire_nli1ll_dataout;
			nlii0O <= wire_nli1lO_dataout;
			nliiii <= wire_nliill_dataout;
			nliiil <= wire_nliilO_dataout;
			nliiiO <= wire_nliiOi_dataout;
			nliili <= wire_nliiOl_dataout;
			nliOil <= wire_nliiOO_dataout;
			nliOiO <= wire_nliOli_dataout;
			nliOOl <= wire_nliOll_dataout;
			nll01i <= wire_nll1Ol_dataout;
			nll01l <= wire_nll01O_dataout;
			nll1l1l <= wire_nll1lii_dataout;
			nll1lO <= wire_nll1Oi_dataout;
			nlllllO <= wire_n1Olll_dataout;
			nlO00i <= sudi[11];
			nlO00l <= sudi[12];
			nlO00O <= sudi[13];
			nlO01i <= sudi[8];
			nlO01l <= sudi[9];
			nlO01O <= sudi[10];
			nlO0ii <= sudi[14];
			nlO0il <= sudi[15];
			nlO0iO <= sudi[16];
			nlO0li <= sudi[17];
			nlO0ll <= sudi[18];
			nlO0lO <= sudi[19];
			nlO0Oi <= sudi[20];
			nlO0Ol <= sudi[21];
			nlO0OO <= sudi[22];
			nlO1ii <= wire_nll0ll_dataout;
			nlO1il <= sudi[0];
			nlO1iO <= sudi[1];
			nlO1li <= sudi[2];
			nlO1ll <= sudi[3];
			nlO1lO <= sudi[4];
			nlO1Oi <= sudi[5];
			nlO1Ol <= sudi[6];
			nlO1OO <= sudi[7];
			nlOi0i <= sudi[26];
			nlOi1i <= sudi[23];
			nlOi1l <= sudi[24];
			nlOi1O <= sudi[25];
			nlOiiO <= wire_nlOiOO_o;
			nlOili <= wire_nlOill_o;
			nlOl0il <= wire_nlOllll_dataout;
			nlOl0iO <= wire_nlOlllO_dataout;
			nlOl0li <= wire_nlOllOi_dataout;
			nlOl0ll <= wire_nlOllOl_dataout;
			nlOl0lO <= wire_nlOllOO_dataout;
			nlOl0Oi <= wire_nlOOOli_dataout;
			nlOl0Ol <= wire_nlOOOll_dataout;
			nlOl0OO <= wire_nlOOOlO_dataout;
			nlOli0i <= wire_n1111i_dataout;
			nlOli0l <= wire_n1111l_dataout;
			nlOli0O <= wire_n1111O_dataout;
			nlOli1i <= wire_nlOOOOi_dataout;
			nlOli1l <= wire_nlOOOOl_dataout;
			nlOli1O <= wire_nlOOOOO_dataout;
			nlOliii <= wire_n1110i_dataout;
			nlOliil <= wire_nlOlO1l_dataout;
			nlOliiO <= wire_nlOlO1O_dataout;
			nlOlili <= wire_nlOlO0i_dataout;
			nlOlill <= wire_nlOlO0l_dataout;
			nlOlilO <= wire_nlOlO0O_dataout;
			nlOliOi <= wire_nlOlOii_dataout;
			nlOliOl <= wire_nlOlOil_dataout;
			nlOliOO <= wire_nlOlOiO_dataout;
			nlOll0i <= wire_nlOlOOi_dataout;
			nlOll0l <= wire_nlOlOOl_dataout;
			nlOll0O <= wire_nlOlOOO_dataout;
			nlOll1i <= wire_nlOlOli_dataout;
			nlOll1l <= wire_nlOlOll_dataout;
			nlOll1O <= wire_nlOlOlO_dataout;
			nlOllii <= wire_nlOO11i_dataout;
			nlOllil <= wire_nlOO11l_dataout;
			nlOlliO <= wire_nlOO11O_dataout;
			nlOllli <= wire_nlOO10i_dataout;
			nlOlOO <= wire_nlOilO_o;
			nlOO1l <= wire_nlOiOl_o;
		end
	end
	assign		wire_n0000i_dataout = (nliO11O === 1'b1) ? rclkcmpsq1p[14] : rclkcmpsq1p[4];
	assign		wire_n0000l_dataout = (nliO11O === 1'b1) ? rclkcmpsq1p[15] : rclkcmpsq1p[5];
	assign		wire_n0000O_dataout = (nliO11O === 1'b1) ? rclkcmpsq1p[16] : rclkcmpsq1p[6];
	assign		wire_n0001i_dataout = (nliO11O === 1'b1) ? rclkcmpsq1p[11] : rclkcmpsq1p[1];
	assign		wire_n0001l_dataout = (nliO11O === 1'b1) ? rclkcmpsq1p[12] : rclkcmpsq1p[2];
	assign		wire_n0001O_dataout = (nliO11O === 1'b1) ? rclkcmpsq1p[13] : rclkcmpsq1p[3];
	assign		wire_n000ii_dataout = (nliO11O === 1'b1) ? rclkcmpsq1p[17] : rclkcmpsq1p[7];
	assign		wire_n000il_dataout = (nliO11O === 1'b1) ? rclkcmpsq1p[18] : rclkcmpsq1p[8];
	assign		wire_n000iO_dataout = (nliO11O === 1'b1) ? rclkcmpsq1p[19] : rclkcmpsq1p[9];
	assign		wire_n001OO_dataout = (nliO11O === 1'b1) ? rclkcmpsq1p[10] : rclkcmpsq1p[0];
	assign		wire_n00i_dataout = (rwa_6g_en === 1'b1) ? niiill : nlO0l0i;
	and(wire_n00i0l_dataout, n00iii, ~{(~ nliOili)});
	and(wire_n00i0O_dataout, n00i1O, ~{(~ nliOili)});
	and(wire_n00iil_dataout, wire_nlii0l_o, (rgenericfifo | wire_nlliii_dataout));
	assign		wire_n00l_dataout = (rwa_6g_en === 1'b1) ? niiilO : nlO0l0l;
	assign		wire_n00O_dataout = (rwa_6g_en === 1'b1) ? niiiOi : nlO0l0O;
	assign		wire_n0100i_dataout = (nlilO1O === 1'b1) ? nllOlOl : wire_n01i0l_dataout;
	assign		wire_n0100l_dataout = (nlilO1O === 1'b1) ? nllOlOO : wire_n01i0O_dataout;
	assign		wire_n0100O_dataout = (nlilO1O === 1'b1) ? nllOO1i : wire_n01iii_dataout;
	assign		wire_n0101i_dataout = (nlilO1O === 1'b1) ? nllOlll : wire_n01i1l_dataout;
	assign		wire_n0101l_dataout = (nlilO1O === 1'b1) ? nllOllO : wire_n01i1O_dataout;
	assign		wire_n0101O_dataout = (nlilO1O === 1'b1) ? nllOlOi : wire_n01i0i_dataout;
	assign		wire_n010ii_dataout = (nlilO1O === 1'b1) ? nllOO1l : wire_n01iil_dataout;
	assign		wire_n010il_dataout = (nlilO1O === 1'b1) ? nllOO1O : wire_n01iiO_dataout;
	assign		wire_n010iO_dataout = (nlilO1O === 1'b1) ? nllOO0i : wire_n01ili_dataout;
	assign		wire_n010li_dataout = (nlilO1O === 1'b1) ? nllOO0l : wire_n01ill_dataout;
	assign		wire_n010ll_dataout = (nlilO1O === 1'b1) ? nllOO0O : wire_n01ilO_dataout;
	assign		wire_n010lO_dataout = (nlilO1O === 1'b1) ? nllOOii : wire_n01iOi_dataout;
	assign		wire_n010Oi_dataout = (nlilO1O === 1'b1) ? nllOOiO : wire_n01iOl_dataout;
	and(wire_n010Ol_dataout, wire_n01iOO_dataout, ~{nlilO1O});
	or(wire_n010OO_dataout, wire_n01l1i_dataout, nlilO1O);
	and(wire_n0110i_dataout, wire_n0110l_dataout, ~{nlilO1l});
	assign		wire_n0110l_dataout = (nlillOO === 1'b1) ? align_status_sync_0 : wire_n0110O_dataout;
	assign		wire_n0110O_dataout = (nlillOl === 1'b1) ? align_status_sync_2 : wire_n011ii_dataout;
	assign		wire_n0111i_dataout = (dskwclksel[1] === 1'b1) ? audi[12] : sudi[12];
	assign		wire_n011ii_dataout = (dskwclksel[1] === 1'b1) ? n1001O : n1001i;
	and(wire_n011lO_dataout, wire_n011Oi_dataout, ~{nlilO1l});
	assign		wire_n011Oi_dataout = (dskwclksel[1] === 1'b1) ? align_status : sync_status;
	assign		wire_n011Ol_dataout = (nlilO0i === 1'b1) ? n1000O : wire_n011Oi_dataout;
	assign		wire_n011OO_dataout = (nlilO1O === 1'b1) ? nllOlli : wire_n01i1i_dataout;
	assign		wire_n01i_dataout = (rwa_6g_en === 1'b1) ? niiiil : nlO0l1i;
	assign		wire_n01i0i_dataout = (nlilO0i === 1'b1) ? nllOlOi : wire_n01l0l_dataout;
	assign		wire_n01i0l_dataout = (nlilO0i === 1'b1) ? nllOlOl : wire_n01l0O_dataout;
	assign		wire_n01i0O_dataout = (nlilO0i === 1'b1) ? nllOlOO : wire_n01lii_dataout;
	assign		wire_n01i1i_dataout = (nlilO0i === 1'b1) ? nllOlli : wire_n01l1l_dataout;
	assign		wire_n01i1l_dataout = (nlilO0i === 1'b1) ? nllOlll : wire_n01l1O_dataout;
	assign		wire_n01i1O_dataout = (nlilO0i === 1'b1) ? nllOllO : wire_n01l0i_dataout;
	assign		wire_n01iii_dataout = (nlilO0i === 1'b1) ? nllOO1i : wire_n01lil_dataout;
	assign		wire_n01iil_dataout = (nlilO0i === 1'b1) ? nllOO1l : wire_n01liO_dataout;
	assign		wire_n01iiO_dataout = (nlilO0i === 1'b1) ? nllOO1O : wire_n01lli_dataout;
	assign		wire_n01ili_dataout = (nlilO0i === 1'b1) ? nllOO0i : wire_n01lll_dataout;
	assign		wire_n01ill_dataout = (nlilO0i === 1'b1) ? nllOO0l : wire_n1OOOO_dataout;
	assign		wire_n01ilO_dataout = (nlilO0i === 1'b1) ? nllOO0O : wire_n01llO_dataout;
	assign		wire_n01iOi_dataout = (nlilO0i === 1'b1) ? nllOOii : wire_n0111i_dataout;
	assign		wire_n01iOl_dataout = (nlilO0i === 1'b1) ? nllOOiO : wire_n01lOi_dataout;
	and(wire_n01iOO_dataout, nllOOli, nlilO0i);
	assign		wire_n01l_dataout = (rwa_6g_en === 1'b1) ? niiiiO : nlO0l1l;
	assign		wire_n01l0i_dataout = (dskwclksel[1] === 1'b1) ? audi[2] : sudi[2];
	assign		wire_n01l0l_dataout = (dskwclksel[1] === 1'b1) ? audi[3] : sudi[3];
	assign		wire_n01l0O_dataout = (dskwclksel[1] === 1'b1) ? audi[4] : sudi[4];
	and(wire_n01l1i_dataout, nlO01il, nlilO0i);
	assign		wire_n01l1l_dataout = (dskwclksel[1] === 1'b1) ? audi[0] : sudi[0];
	assign		wire_n01l1O_dataout = (dskwclksel[1] === 1'b1) ? audi[1] : sudi[1];
	assign		wire_n01lii_dataout = (dskwclksel[1] === 1'b1) ? audi[5] : sudi[5];
	assign		wire_n01lil_dataout = (dskwclksel[1] === 1'b1) ? audi[6] : sudi[6];
	assign		wire_n01liO_dataout = (dskwclksel[1] === 1'b1) ? audi[7] : sudi[7];
	assign		wire_n01lli_dataout = (dskwclksel[1] === 1'b1) ? audi[8] : sudi[8];
	assign		wire_n01lll_dataout = (dskwclksel[1] === 1'b1) ? audi[9] : sudi[9];
	assign		wire_n01llO_dataout = (dskwclksel[1] === 1'b1) ? audi[11] : sudi[11];
	assign		wire_n01lOi_dataout = (dskwclksel[1] === 1'b1) ? audi[13] : sudi[13];
	assign		wire_n01O_dataout = (rwa_6g_en === 1'b1) ? niiili : nlO0l1O;
	or(wire_n01O0l_dataout, (rskpsetbased & (nlilOiO | nlilOil)), ((~ rskpsetbased) & (nlilOii | ((~ rclkcmppos) & nlilO0O))));
	assign		wire_n01OOi_dataout = (rskpsetbased === 1'b1) ? (nlilOll | nlilOli) : (nlilOOi | nlilOlO);
	assign		wire_n0i_dataout = (rwa_6g_en === 1'b1) ? nli10l : n1i1li;
	assign		wire_n0ii_dataout = (rwa_6g_en === 1'b1) ? niiiOl : nlO0lii;
	assign		wire_n0il_dataout = (rwa_6g_en === 1'b1) ? niiiOO : nlO0lil;
	assign		wire_n0iO_dataout = (rwa_6g_en === 1'b1) ? niil1i : nlO0liO;
	assign		wire_n0l_dataout = (rwa_6g_en === 1'b1) ? nli10O : n1i1ll;
	assign		wire_n0li_dataout = (rwa_6g_en === 1'b1) ? niil1l : nlO0lli;
	assign		wire_n0ll_dataout = (rwa_6g_en === 1'b1) ? niO1OO : nlOl0ii;
	assign		wire_n0lO_dataout = (rwa_6g_en === 1'b1) ? wire_nli11l_o : wire_n1i1ii_o;
	assign		wire_n0O_dataout = (rwa_6g_en === 1'b1) ? nli1ii : n1i1lO;
	assign		wire_n0Oi_dataout = (rwa_6g_en === 1'b1) ? wire_nliOlO_o : wire_n1lOll_o;
	assign		wire_n0Ol_dataout = (rwa_6g_en === 1'b1) ? wire_nliOOi_o : wire_n1lOlO_o;
	assign		wire_n0OO_dataout = (rwa_6g_en === 1'b1) ? (((nll1i0O | nll1i0l) | nll1i0i) | (~ nll1i1l8)) : (((nll1ill | nll1ili) | nll1iiO) | (~ nll1iii5));
	and(wire_n100li_dataout, ((n100iO & (~ rgenericfifo)) | nlil0ii), ~{nliliil});
	and(wire_n100ll_dataout, n100il, ~{nliliil});
	and(wire_n100lO_dataout, nlOlOO, ~{nliliil});
	and(wire_n100Oi_dataout, n10i0i, ~{nliliil});
	and(wire_n100Ol_dataout, ((~ rgenericfifo) & n10iOi), ~{nliliil});
	and(wire_n1010i_dataout, n11OOO, ~{nliliil});
	and(wire_n1010l_dataout, n1011i, ~{nliliil});
	and(wire_n1010O_dataout, n1011l, ~{nliliil});
	and(wire_n1011O_dataout, n11OOl, ~{nliliil});
	and(wire_n101ii_dataout, n101Oi, ~{nliliil});
	and(wire_n101il_dataout, n11l1O, ~{nliliil});
	and(wire_n101iO_dataout, n11l0i, ~{nliliil});
	and(wire_n101li_dataout, n11l0l, ~{nliliil});
	and(wire_n101ll_dataout, n11l0O, ~{nliliil});
	and(wire_n101lO_dataout, n11Oil, ~{nliliil});
	assign		wire_n10i_dataout = (rwa_6g_en === 1'b1) ? nii0lO : nlO0i0l;
	and(wire_n10i0l_dataout, wire_n10i0O_dataout, wire_n011lO_dataout);
	or(wire_n10i0O_dataout, n10iOi, ((~ n10iOi) & nlil0il));
	assign		wire_n10iil_dataout = (nlillOO === 1'b1) ? fifo_rd_in_comp_0 : wire_n10iiO_dataout;
	assign		wire_n10iiO_dataout = (nlillOl === 1'b1) ? fifo_rd_in_comp_2 : n100iO;
	assign		wire_n10ili_dataout = (rdwidth_rx === 1'b1) ? (nlil0iO | n10iOl) : nlil0iO;
	assign		wire_n10l_dataout = (rwa_6g_en === 1'b1) ? nii0Oi : nlO0i0O;
	and(wire_n10l1l_dataout, nll1l1O, ~{nliliil});
	and(wire_n10l1O_dataout, (((~ n10l1i) & (n100iO & nll1l1O)) & (rskpsetbased | nlil0li)), ~{nliliil});
	assign		wire_n10lil_dataout = (rdwidth_rx === 1'b1) ? (nlil0ll | n10llO) : nlil0ll;
	assign		wire_n10O_dataout = (rwa_6g_en === 1'b1) ? nii0Ol : nlO0iii;
	or(wire_n10O0i_dataout, nllllli, nlill1O);
	or(wire_n10O0l_dataout, wire_n1i11i_dataout, nlill1O);
	or(wire_n10O0O_dataout, wire_n10OiO_dataout, nlill1O);
	and(wire_n10O1O_dataout, n10O1l, ~{nlill1O});
	and(wire_n10Oii_dataout, wire_n1i10i_dataout, ~{nlill1O});
	and(wire_n10Oil_dataout, wire_n10OlO_dataout, ~{nlill1O});
	assign		wire_n10OiO_dataout = (rdwidth_rx === 1'b1) ? (nlil0Ol | nlllliO) : nlil0Ol;
	assign		wire_n10OlO_dataout = (rdwidth_rx === 1'b1) ? (nlil0OO | n10O1i) : nlil0OO;
	and(wire_n1110i_dataout, nlO01Oi, ~{nlill1O});
	and(wire_n1111i_dataout, nlO01li, ~{nlill1O});
	and(wire_n1111l_dataout, nlO01ll, ~{nlill1O});
	and(wire_n1111O_dataout, nlO01lO, ~{nlill1O});
	assign		wire_n111il_dataout = (nll1i1i === 1'b1) ? disable_fifo_rd_0 : nll11ll;
	assign		wire_n11i_dataout = (rwa_6g_en === 1'b1) ? nii0iO : nlO0i1l;
	assign		wire_n11l_dataout = (rwa_6g_en === 1'b1) ? nii0li : nlO0i1O;
	and(wire_n11lii_dataout, wire_n11llO_dataout, ~{nlill1O});
	and(wire_n11lil_dataout, wire_n11lOi_dataout, ~{nlill1O});
	and(wire_n11liO_dataout, wire_n11lOl_dataout, ~{nlill1O});
	and(wire_n11lli_dataout, wire_n11lOO_dataout, ~{nlill1O});
	and(wire_n11lll_dataout, wire_n11O1i_dataout, ~{nlill1O});
	assign		wire_n11llO_dataout = (nlili1i === 1'b1) ? n11l1O : nlil01O;
	assign		wire_n11lOi_dataout = (nlili1i === 1'b1) ? n11l0i : nlil00i;
	assign		wire_n11lOl_dataout = (nlili1i === 1'b1) ? n11l0l : nlil00l;
	assign		wire_n11lOO_dataout = (nlili1i === 1'b1) ? n11l0O : nlil00O;
	assign		wire_n11O_dataout = (rwa_6g_en === 1'b1) ? nii0ll : nlO0i0i;
	assign		wire_n11O1i_dataout = (nlili1i === 1'b1) ? n11Oil : (((wire_n11Oii_o[19] | wire_n11Oii_o[18]) | wire_n11Oii_o[17]) | wire_n11Oii_o[16]);
	and(wire_n1i_dataout, wire_nllOli_dataout, rwa_6g_en);
	assign		wire_n1i00i_dataout = (nlili1i === 1'b1) ? n1i1li : wire_n1i0li_dataout;
	assign		wire_n1i00l_dataout = (nlili1i === 1'b1) ? n1i1ll : wire_n1i0ll_dataout;
	assign		wire_n1i00O_dataout = (nlili1i === 1'b1) ? n1i1lO : wire_n1i0lO_dataout;
	and(wire_n1i01i_dataout, wire_n1i00O_dataout, ~{nlill1O});
	and(wire_n1i01l_dataout, wire_n1i0ii_dataout, ~{nlill1O});
	assign		wire_n1i01O_dataout = (nlili1i === 1'b1) ? n1i1iO : wire_n1i0iO_dataout;
	assign		wire_n1i0ii_dataout = (nlili1i === 1'b1) ? n1ilil : wire_n1i0Oi_dataout;
	assign		wire_n1i0iO_dataout = (wire_n1ii1l_o === 1'b1) ? wire_n1ii1i_o[1] : wire_n1i0Ol_o[1];
	assign		wire_n1i0li_dataout = (wire_n1ii1l_o === 1'b1) ? wire_n1ii1i_o[2] : wire_n1i0Ol_o[2];
	assign		wire_n1i0ll_dataout = (wire_n1ii1l_o === 1'b1) ? wire_n1ii1i_o[3] : wire_n1i0Ol_o[3];
	assign		wire_n1i0lO_dataout = (wire_n1ii1l_o === 1'b1) ? wire_n1ii1i_o[4] : wire_n1i0Ol_o[4];
	assign		wire_n1i0Oi_dataout = (wire_n1ii1l_o === 1'b1) ? wire_n1ii1i_o[5] : wire_n1i0Ol_o[5];
	assign		wire_n1i10i_dataout = (((((~ ralfull[3]) & (~ ralfull[2])) & (~ ralfull[1])) & (~ ralfull[0])) === 1'b1) ? wire_n1lOll_o : wire_n1i10l_o;
	assign		wire_n1i11i_dataout = (((((~ ralempty[3]) & (~ ralempty[2])) & (~ ralempty[1])) & (~ ralempty[0])) === 1'b1) ? wire_n1lOlO_o : wire_n1i11l_o;
	and(wire_n1i1Oi_dataout, wire_n1i01O_dataout, ~{nlill1O});
	and(wire_n1i1Ol_dataout, wire_n1i00i_dataout, ~{nlill1O});
	and(wire_n1i1OO_dataout, wire_n1i00l_dataout, ~{nlill1O});
	assign		wire_n1ii_dataout = (rwa_6g_en === 1'b1) ? n0OiOl : nllllii;
	assign		wire_n1ii1O_dataout = (nll1i1i === 1'b1) ? disable_fifo_wr_0 : nll11li;
	assign		wire_n1il_dataout = (rwa_6g_en === 1'b1) ? nii0OO : nlO0iil;
	assign		wire_n1iO_dataout = (rwa_6g_en === 1'b1) ? niii1i : nlO0iiO;
	and(wire_n1iO0i_dataout, wire_n1iOll_dataout, ~{nliliil});
	and(wire_n1iO0l_dataout, wire_n1iOlO_dataout, ~{nliliil});
	and(wire_n1iO0O_dataout, wire_n1iOOi_dataout, ~{nliliil});
	and(wire_n1iO1i_dataout, wire_n111il_dataout, ~{nliliil});
	and(wire_n1iO1l_dataout, wire_n1iOiO_dataout, ~{nliliil});
	and(wire_n1iO1O_dataout, wire_n1iOli_dataout, ~{nliliil});
	and(wire_n1iOii_dataout, wire_n1iOOl_dataout, ~{nliliil});
	and(wire_n1iOil_dataout, wire_n1iOOO_dataout, ~{nliliil});
	and(wire_n1iOiO_dataout, n1iliO, ~{wire_n111il_dataout});
	and(wire_n1iOli_dataout, n1illi, ~{wire_n111il_dataout});
	and(wire_n1iOll_dataout, n1illl, ~{wire_n111il_dataout});
	and(wire_n1iOlO_dataout, n1illO, ~{wire_n111il_dataout});
	and(wire_n1iOOi_dataout, n1ilOi, ~{wire_n111il_dataout});
	and(wire_n1iOOl_dataout, n1ilOl, ~{wire_n111il_dataout});
	and(wire_n1iOOO_dataout, n1ilOO, ~{wire_n111il_dataout});
	and(wire_n1l_dataout, wire_nllOll_dataout, rwa_6g_en);
	assign		wire_n1l00i_dataout = (nliliOl === 1'b1) ? wire_n1liOO_o[3] : wire_n1l0iO_dataout;
	assign		wire_n1l00l_dataout = (nliliOl === 1'b1) ? wire_n1liOO_o[4] : wire_n1l0li_dataout;
	assign		wire_n1l00O_dataout = (nlililO === 1'b1) ? n1l10O : wire_n1l0ll_dataout;
	assign		wire_n1l01i_dataout = (nliliOl === 1'b1) ? wire_n1liOO_o[0] : wire_n1l00O_dataout;
	assign		wire_n1l01l_dataout = (nliliOl === 1'b1) ? wire_n1liOO_o[1] : wire_n1l0ii_dataout;
	assign		wire_n1l01O_dataout = (nliliOl === 1'b1) ? wire_n1liOO_o[2] : wire_n1l0il_dataout;
	assign		wire_n1l0ii_dataout = (nlililO === 1'b1) ? wire_n1liOi_o[0] : wire_n1l0lO_dataout;
	assign		wire_n1l0il_dataout = (nlililO === 1'b1) ? wire_n1liOi_o[1] : wire_n1l0Oi_dataout;
	assign		wire_n1l0iO_dataout = (nlililO === 1'b1) ? wire_n1liOi_o[2] : wire_n1l0Ol_dataout;
	assign		wire_n1l0li_dataout = (nlililO === 1'b1) ? wire_n1liOi_o[3] : wire_n1l0OO_dataout;
	assign		wire_n1l0ll_dataout = (nlilill === 1'b1) ? wire_n1liii_o[0] : wire_n1li1i_dataout;
	assign		wire_n1l0lO_dataout = (nlilill === 1'b1) ? wire_n1liii_o[1] : wire_n1li1l_dataout;
	assign		wire_n1l0Oi_dataout = (nlilill === 1'b1) ? wire_n1liii_o[2] : wire_n1li1O_dataout;
	assign		wire_n1l0Ol_dataout = (nlilill === 1'b1) ? wire_n1liii_o[3] : wire_n1li0i_dataout;
	assign		wire_n1l0OO_dataout = (nlilill === 1'b1) ? wire_n1liii_o[4] : wire_n1li0l_dataout;
	and(wire_n1l1li_dataout, nll10il, ~{nlill1O});
	and(wire_n1l1ll_dataout, wire_n1l01i_dataout, ~{nlill1O});
	and(wire_n1l1lO_dataout, wire_n1l01l_dataout, ~{nlill1O});
	and(wire_n1l1Oi_dataout, wire_n1l01O_dataout, ~{nlill1O});
	and(wire_n1l1Ol_dataout, wire_n1l00i_dataout, ~{nlill1O});
	and(wire_n1l1OO_dataout, wire_n1l00l_dataout, ~{nlill1O});
	assign		wire_n1li_dataout = (rwa_6g_en === 1'b1) ? niii1l : nlO0ili;
	assign		wire_n1li0i_dataout = ((~ nlilili) === 1'b1) ? wire_n1li0O_o[4] : n1l1iO;
	assign		wire_n1li0l_dataout = ((~ nlilili) === 1'b1) ? wire_n1li0O_o[5] : n1lO0i;
	assign		wire_n1li1i_dataout = ((~ nlilili) === 1'b1) ? wire_n1li0O_o[1] : n1l10O;
	assign		wire_n1li1l_dataout = ((~ nlilili) === 1'b1) ? wire_n1li0O_o[2] : n1l1ii;
	assign		wire_n1li1O_dataout = ((~ nlilili) === 1'b1) ? wire_n1li0O_o[3] : n1l1il;
	assign		wire_n1ll_dataout = (rwa_6g_en === 1'b1) ? niii1O : nlO0ill;
	assign		wire_n1lO_dataout = (rwa_6g_en === 1'b1) ? niii0i : nlO0ilO;
	and(wire_n1lO0O_dataout, nlill0i, ~{nlill1O});
	and(wire_n1lOii_dataout, nlill0i, ~{nlill1O});
	and(wire_n1lOOl_dataout, wire_n01O0l_dataout, wire_n0110i_dataout);
	assign		wire_n1O_dataout = (rwa_6g_en === 1'b1) ? nli10i : n1i1iO;
	and(wire_n1O01i_dataout, wire_n1O00i_o[0], nlill0O);
	and(wire_n1O01l_dataout, wire_n1O00i_o[1], nlill0O);
	and(wire_n1O01O_dataout, wire_n1O00i_o[2], nlill0O);
	and(wire_n1O0iO_dataout, wire_n01OOi_dataout, wire_n0110i_dataout);
	and(wire_n1O0li_dataout, n1O11O, wire_n0110i_dataout);
	and(wire_n1O0ll_dataout, (rclkcmpsqmd & ((~ n1O11O) & wire_n111il_dataout)), wire_n0110i_dataout);
	and(wire_n1O0lO_dataout, wire_n111il_dataout, wire_n0110i_dataout);
	and(wire_n1O1ii_dataout, wire_n1O1li_dataout, wire_n0110i_dataout);
	and(wire_n1O1il_dataout, wire_n1O1ll_dataout, wire_n0110i_dataout);
	and(wire_n1O1iO_dataout, wire_n1O1lO_dataout, wire_n0110i_dataout);
	or(wire_n1O1li_dataout, wire_n1O1Oi_dataout, nlilliO);
	and(wire_n1O1ll_dataout, wire_n1O1Ol_dataout, ~{nlilliO});
	and(wire_n1O1lO_dataout, wire_n1O1OO_dataout, ~{nlilliO});
	assign		wire_n1O1Oi_dataout = (nlillii === 1'b1) ? wire_n1O00i_o[0] : wire_n1O01i_dataout;
	assign		wire_n1O1Ol_dataout = (nlillii === 1'b1) ? wire_n1O00i_o[1] : wire_n1O01l_dataout;
	assign		wire_n1O1OO_dataout = (nlillii === 1'b1) ? wire_n1O00i_o[2] : wire_n1O01O_dataout;
	assign		wire_n1Oi_dataout = (rwa_6g_en === 1'b1) ? niii0l : nlO0iOi;
	and(wire_n1Oi1i_dataout, (nlillll | ((~ rclkcmppos) & nlillli)), (nliO11O & wire_n011lO_dataout));
	and(wire_n1OiiO_dataout, nlilllO, (n1Oi0O & wire_n011lO_dataout));
	and(wire_n1Oill_dataout, nlilllO, (n1Oiii & wire_n011lO_dataout));
	and(wire_n1OiOi_dataout, nlilllO, (n1Oiil & wire_n011lO_dataout));
	assign		wire_n1Ol_dataout = (rwa_6g_en === 1'b1) ? niii0O : nlO0iOl;
	and(wire_n1Ol1l_dataout, nll100l, (wire_n011lO_dataout & (n1Oi0i | (nlillOi & (~ rclkcmpsqmd)))));
	and(wire_n1Olll_dataout, nll100l, (wire_n011lO_dataout & ((~ nliO11O) | ((~ wire_n0111i_dataout) & ((~ wire_n1OOOO_dataout) & n1Oi1O)))));
	assign		wire_n1OO_dataout = (rwa_6g_en === 1'b1) ? niiiii : nlO0iOO;
	assign		wire_n1OO0i_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[1] : sudi_pre[1];
	assign		wire_n1OO0l_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[2] : sudi_pre[2];
	assign		wire_n1OO0O_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[3] : sudi_pre[3];
	assign		wire_n1OO1O_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[0] : sudi_pre[0];
	assign		wire_n1OOii_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[4] : sudi_pre[4];
	assign		wire_n1OOil_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[5] : sudi_pre[5];
	assign		wire_n1OOiO_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[6] : sudi_pre[6];
	assign		wire_n1OOli_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[7] : sudi_pre[7];
	assign		wire_n1OOll_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[8] : sudi_pre[8];
	assign		wire_n1OOlO_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[9] : sudi_pre[9];
	assign		wire_n1OOOi_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[10] : sudi_pre[10];
	assign		wire_n1OOOl_dataout = (dskwclksel[1] === 1'b1) ? audi_pre[12] : sudi_pre[12];
	assign		wire_n1OOOO_dataout = (dskwclksel[1] === 1'b1) ? audi[10] : sudi[10];
	assign		wire_ni_dataout = (rwa_6g_en === 1'b1) ? n0Ol0i : nllllll;
	or(wire_ni000i_dataout, wire_nlOiii_data_out1[15], ~{nliO1ii});
	assign		wire_ni000l_dataout = (nliO1ii === 1'b1) ? wire_nlOiil_data_out1[0] : wire_ni0l1O_dataout;
	assign		wire_ni000O_dataout = (nliO1ii === 1'b1) ? wire_nlOiil_data_out1[1] : wire_ni0l0i_dataout;
	assign		wire_ni001i_dataout = (nliO1ii === 1'b1) ? wire_nlOiii_data_out1[12] : wire_ni0l1i_dataout;
	assign		wire_ni001l_dataout = (nliO1ii === 1'b1) ? wire_nlOiii_data_out1[13] : wire_ni0l1l_dataout;
	and(wire_ni001O_dataout, wire_nlOiii_data_out1[14], nliO1ii);
	assign		wire_ni00ii_dataout = (nliO1ii === 1'b1) ? wire_nlOiil_data_out1[2] : wire_ni0l0l_dataout;
	assign		wire_ni00il_dataout = (nliO1ii === 1'b1) ? wire_nlOiil_data_out1[3] : wire_ni0l0O_dataout;
	assign		wire_ni00iO_dataout = (nliO1ii === 1'b1) ? wire_nlOiil_data_out1[4] : wire_ni0lii_dataout;
	assign		wire_ni00li_dataout = (nliO1ii === 1'b1) ? wire_nlOiil_data_out1[5] : wire_ni0lil_dataout;
	assign		wire_ni00ll_dataout = (nliO1ii === 1'b1) ? wire_nlOiil_data_out1[6] : wire_ni0liO_dataout;
	assign		wire_ni00lO_dataout = (nliO1ii === 1'b1) ? wire_nlOiil_data_out1[7] : wire_ni0lli_dataout;
	assign		wire_ni00Oi_dataout = (nliO1ii === 1'b1) ? wire_nlOiil_data_out1[8] : wire_ni0lll_dataout;
	assign		wire_ni00Ol_dataout = (nliO1ii === 1'b1) ? wire_nlOiil_data_out1[9] : wire_ni0llO_dataout;
	assign		wire_ni00OO_dataout = (nliO1ii === 1'b1) ? wire_nlOiil_data_out1[10] : wire_ni0lOi_dataout;
	assign		wire_ni010i_dataout = (nliO1ii === 1'b1) ? wire_nlOiii_data_out1[0] : wire_ni0i0i_dataout;
	assign		wire_ni010l_dataout = (nliO1ii === 1'b1) ? wire_nlOiii_data_out1[1] : wire_ni0i0l_dataout;
	assign		wire_ni010O_dataout = (nliO1ii === 1'b1) ? wire_nlOiii_data_out1[2] : wire_ni0i0O_dataout;
	and(wire_ni011i_dataout, wire_ni0i1i_dataout, ~{nl0l0O});
	and(wire_ni011l_dataout, wire_ni0i1l_dataout, ~{nl0l0O});
	or(wire_ni011O_dataout, wire_ni0i1O_dataout, nl0l0O);
	assign		wire_ni01ii_dataout = (nliO1ii === 1'b1) ? wire_nlOiii_data_out1[3] : wire_ni0iii_dataout;
	assign		wire_ni01il_dataout = (nliO1ii === 1'b1) ? wire_nlOiii_data_out1[4] : wire_ni0iil_dataout;
	assign		wire_ni01iO_dataout = (nliO1ii === 1'b1) ? wire_nlOiii_data_out1[5] : wire_ni0iiO_dataout;
	assign		wire_ni01li_dataout = (nliO1ii === 1'b1) ? wire_nlOiii_data_out1[6] : wire_ni0ili_dataout;
	assign		wire_ni01ll_dataout = (nliO1ii === 1'b1) ? wire_nlOiii_data_out1[7] : wire_ni0ill_dataout;
	assign		wire_ni01lO_dataout = (nliO1ii === 1'b1) ? wire_nlOiii_data_out1[8] : wire_ni0ilO_dataout;
	assign		wire_ni01Oi_dataout = (nliO1ii === 1'b1) ? wire_nlOiii_data_out1[9] : wire_ni0iOi_dataout;
	assign		wire_ni01Ol_dataout = (nliO1ii === 1'b1) ? wire_nlOiii_data_out1[10] : wire_ni0iOl_dataout;
	assign		wire_ni01OO_dataout = (nliO1ii === 1'b1) ? wire_nlOiii_data_out1[11] : wire_ni0iOO_dataout;
	assign		wire_ni0i_dataout = (rwa_6g_en === 1'b1) ? wire_nlliOi_dataout : wire_n0101O_dataout;
	assign		wire_ni0i0i_dataout = (nliO10O === 1'b1) ? ni101i : wire_ni0lOO_dataout;
	assign		wire_ni0i0l_dataout = (nliO10O === 1'b1) ? ni101l : wire_ni0O1i_dataout;
	assign		wire_ni0i0O_dataout = (nliO10O === 1'b1) ? ni101O : wire_ni0O1l_dataout;
	assign		wire_ni0i1i_dataout = (nliO1ii === 1'b1) ? wire_nlOiil_data_out1[12] : wire_ni0lOl_dataout;
	and(wire_ni0i1l_dataout, wire_nlOiil_data_out1[14], nliO1ii);
	or(wire_ni0i1O_dataout, wire_nlOiil_data_out1[15], ~{nliO1ii});
	assign		wire_ni0iii_dataout = (nliO10O === 1'b1) ? ni100i : wire_ni0O1O_dataout;
	assign		wire_ni0iil_dataout = (nliO10O === 1'b1) ? ni100l : wire_ni0O0i_dataout;
	assign		wire_ni0iiO_dataout = (nliO10O === 1'b1) ? ni100O : wire_ni0O0l_dataout;
	assign		wire_ni0ili_dataout = (nliO10O === 1'b1) ? ni10ii : wire_ni0O0O_dataout;
	assign		wire_ni0ill_dataout = (nliO10O === 1'b1) ? ni10il : wire_ni0Oii_dataout;
	assign		wire_ni0ilO_dataout = (nliO10O === 1'b1) ? ni10iO : wire_ni0Oil_dataout;
	assign		wire_ni0iOi_dataout = (nliO10O === 1'b1) ? ni10li : wire_ni0OiO_dataout;
	and(wire_ni0iOl_dataout, ni10ll, nliO10O);
	assign		wire_ni0iOO_dataout = (nliO10O === 1'b1) ? ni10lO : ni1iOl;
	assign		wire_ni0l_dataout = (rwa_6g_en === 1'b1) ? wire_nlliOl_dataout : wire_n0100i_dataout;
	assign		wire_ni0l0i_dataout = (nliO10O === 1'b1) ? ni1i1O : wire_ni0O1i_dataout;
	assign		wire_ni0l0l_dataout = (nliO10O === 1'b1) ? ni1i0i : wire_ni0O1l_dataout;
	assign		wire_ni0l0O_dataout = (nliO10O === 1'b1) ? ni1i0l : wire_ni0O1O_dataout;
	and(wire_ni0l1i_dataout, ni10Oi, nliO10O);
	assign		wire_ni0l1l_dataout = (nliO10O === 1'b1) ? ni10Ol : ni1l1l;
	assign		wire_ni0l1O_dataout = (nliO10O === 1'b1) ? ni1i1l : wire_ni0lOO_dataout;
	assign		wire_ni0lii_dataout = (nliO10O === 1'b1) ? ni1i0O : wire_ni0O0i_dataout;
	assign		wire_ni0lil_dataout = (nliO10O === 1'b1) ? ni1iii : wire_ni0O0l_dataout;
	assign		wire_ni0liO_dataout = (nliO10O === 1'b1) ? ni1iil : wire_ni0O0O_dataout;
	assign		wire_ni0lli_dataout = (nliO10O === 1'b1) ? ni1iiO : wire_ni0Oii_dataout;
	assign		wire_ni0lll_dataout = (nliO10O === 1'b1) ? ni1ili : wire_ni0Oil_dataout;
	assign		wire_ni0llO_dataout = (nliO10O === 1'b1) ? ni1ill : wire_ni0OiO_dataout;
	and(wire_ni0lOi_dataout, ni1ilO, nliO10O);
	and(wire_ni0lOl_dataout, ni1iOO, nliO10O);
	assign		wire_ni0lOO_dataout = (ni1l1l === 1'b1) ? rclkcmpsq1p[10] : rclkcmpsq1n[10];
	assign		wire_ni0O_dataout = (rwa_6g_en === 1'b1) ? wire_nlliOO_dataout : wire_n0100l_dataout;
	assign		wire_ni0O0i_dataout = (ni1l1l === 1'b1) ? rclkcmpsq1p[14] : rclkcmpsq1n[14];
	assign		wire_ni0O0l_dataout = (ni1l1l === 1'b1) ? rclkcmpsq1p[15] : rclkcmpsq1n[15];
	assign		wire_ni0O0O_dataout = (ni1l1l === 1'b1) ? rclkcmpsq1p[16] : rclkcmpsq1n[16];
	assign		wire_ni0O1i_dataout = (ni1l1l === 1'b1) ? rclkcmpsq1p[11] : rclkcmpsq1n[11];
	assign		wire_ni0O1l_dataout = (ni1l1l === 1'b1) ? rclkcmpsq1p[12] : rclkcmpsq1n[12];
	assign		wire_ni0O1O_dataout = (ni1l1l === 1'b1) ? rclkcmpsq1p[13] : rclkcmpsq1n[13];
	assign		wire_ni0Oii_dataout = (ni1l1l === 1'b1) ? rclkcmpsq1p[17] : rclkcmpsq1n[17];
	assign		wire_ni0Oil_dataout = (ni1l1l === 1'b1) ? rclkcmpsq1p[18] : rclkcmpsq1n[18];
	assign		wire_ni0OiO_dataout = (ni1l1l === 1'b1) ? rclkcmpsq1p[19] : rclkcmpsq1n[19];
	assign		wire_ni0OOi_dataout = (rclkcmpinsertpad === 1'b1) ? (~ ni1l1l) : ni1l1l;
	assign		wire_ni0OOl_dataout = (rclkcmpinsertpad === 1'b1) ? ni1l1l : (~ ni1l1l);
	assign		wire_ni1i_dataout = (rwa_6g_en === 1'b1) ? wire_nllili_dataout : wire_n011OO_dataout;
	assign		wire_ni1l_dataout = (rwa_6g_en === 1'b1) ? wire_nllill_dataout : wire_n0101i_dataout;
	assign		wire_ni1l0i_dataout = (nl0l0O === 1'b1) ? wire_ni0OOi_dataout : wire_ni010i_dataout;
	assign		wire_ni1l0l_dataout = (nl0l0O === 1'b1) ? (~ ni1l1l) : wire_ni010l_dataout;
	assign		wire_ni1l0O_dataout = (nl0l0O === 1'b1) ? (~ ni1l1l) : wire_ni010O_dataout;
	assign		wire_ni1lii_dataout = (nl0l0O === 1'b1) ? wire_ni0OOl_dataout : wire_ni01ii_dataout;
	assign		wire_ni1lil_dataout = (nl0l0O === 1'b1) ? (~ ni1l1l) : wire_ni01il_dataout;
	assign		wire_ni1liO_dataout = (nl0l0O === 1'b1) ? ni1l1l : wire_ni01iO_dataout;
	assign		wire_ni1lli_dataout = (nl0l0O === 1'b1) ? (~ ni1l1l) : wire_ni01li_dataout;
	assign		wire_ni1lll_dataout = (nl0l0O === 1'b1) ? ni1l1l : wire_ni01ll_dataout;
	assign		wire_ni1llO_dataout = (nl0l0O === 1'b1) ? ni1l1l : wire_ni01lO_dataout;
	assign		wire_ni1lOi_dataout = (nl0l0O === 1'b1) ? ni1l1l : wire_ni01Oi_dataout;
	and(wire_ni1lOl_dataout, wire_ni01Ol_dataout, ~{nl0l0O});
	assign		wire_ni1lOO_dataout = (nl0l0O === 1'b1) ? ni1iOl : wire_ni01OO_dataout;
	assign		wire_ni1O_dataout = (rwa_6g_en === 1'b1) ? wire_nllilO_dataout : wire_n0101l_dataout;
	or(wire_ni1O0i_dataout, wire_ni000i_dataout, nl0l0O);
	assign		wire_ni1O0l_dataout = (nl0l0O === 1'b1) ? wire_ni0OOi_dataout : wire_ni000l_dataout;
	assign		wire_ni1O0O_dataout = (nl0l0O === 1'b1) ? (~ ni1l1l) : wire_ni000O_dataout;
	and(wire_ni1O1i_dataout, wire_ni001i_dataout, ~{nl0l0O});
	assign		wire_ni1O1l_dataout = (nl0l0O === 1'b1) ? ni1l1l : wire_ni001l_dataout;
	and(wire_ni1O1O_dataout, wire_ni001O_dataout, ~{nl0l0O});
	assign		wire_ni1Oii_dataout = (nl0l0O === 1'b1) ? (~ ni1l1l) : wire_ni00ii_dataout;
	assign		wire_ni1Oil_dataout = (nl0l0O === 1'b1) ? wire_ni0OOl_dataout : wire_ni00il_dataout;
	assign		wire_ni1OiO_dataout = (nl0l0O === 1'b1) ? (~ ni1l1l) : wire_ni00iO_dataout;
	assign		wire_ni1Oli_dataout = (nl0l0O === 1'b1) ? ni1l1l : wire_ni00li_dataout;
	assign		wire_ni1Oll_dataout = (nl0l0O === 1'b1) ? (~ ni1l1l) : wire_ni00ll_dataout;
	assign		wire_ni1OlO_dataout = (nl0l0O === 1'b1) ? ni1l1l : wire_ni00lO_dataout;
	assign		wire_ni1OOi_dataout = (nl0l0O === 1'b1) ? ni1l1l : wire_ni00Oi_dataout;
	assign		wire_ni1OOl_dataout = (nl0l0O === 1'b1) ? ni1l1l : wire_ni00Ol_dataout;
	and(wire_ni1OOO_dataout, wire_ni00OO_dataout, ~{nl0l0O});
	assign		wire_nii_dataout = (rwa_6g_en === 1'b1) ? nlii0O : n1ilil;
	assign		wire_niii_dataout = (rwa_6g_en === 1'b1) ? wire_nlll1i_dataout : wire_n0100O_dataout;
	assign		wire_niil_dataout = (rwa_6g_en === 1'b1) ? wire_nlll1l_dataout : wire_n010ii_dataout;
	and(wire_niil0i_dataout, wire_nil0iO_dataout, ~{nliO0lO});
	and(wire_niil0l_dataout, wire_nil0li_dataout, ~{nliO0lO});
	and(wire_niil0O_dataout, wire_nil0ll_dataout, ~{nliO0lO});
	and(wire_niil1O_dataout, wire_nil0il_dataout, ~{nliO0lO});
	and(wire_niilii_dataout, wire_nil0lO_dataout, ~{nliO0lO});
	and(wire_niilil_dataout, wire_nil0Oi_dataout, ~{nliO0lO});
	and(wire_niiliO_dataout, wire_nil0Ol_dataout, ~{nliO0lO});
	and(wire_niilli_dataout, wire_nil0OO_dataout, ~{nliO0lO});
	and(wire_niilll_dataout, wire_nili1i_dataout, ~{nliO0lO});
	and(wire_niillO_dataout, wire_nili1l_dataout, ~{nliO0lO});
	and(wire_niilOi_dataout, wire_nili1O_dataout, ~{nliO0lO});
	or(wire_niilOl_dataout, wire_nili0i_dataout, nliO0lO);
	and(wire_niilOO_dataout, wire_nili0l_dataout, ~{nliO0lO});
	assign		wire_niiO_dataout = (rwa_6g_en === 1'b1) ? wire_nlll1O_dataout : wire_n010il_dataout;
	and(wire_niiO0i_dataout, wire_niliiO_dataout, ~{nliO0lO});
	and(wire_niiO0l_dataout, wire_nilili_dataout, ~{nliO0lO});
	and(wire_niiO0O_dataout, wire_nilill_dataout, ~{nliO0lO});
	and(wire_niiO1i_dataout, wire_nili0O_dataout, ~{nliO0lO});
	and(wire_niiO1l_dataout, wire_niliii_dataout, ~{nliO0lO});
	and(wire_niiO1O_dataout, wire_niliil_dataout, ~{nliO0lO});
	and(wire_niiOii_dataout, wire_nililO_dataout, ~{nliO0lO});
	and(wire_niiOil_dataout, wire_niliOi_dataout, ~{nliO0lO});
	and(wire_niiOiO_dataout, wire_niliOl_dataout, ~{nliO0lO});
	and(wire_niiOli_dataout, wire_niliOO_dataout, ~{nliO0lO});
	and(wire_niiOll_dataout, wire_nill1i_dataout, ~{nliO0lO});
	and(wire_niiOlO_dataout, wire_nill1l_dataout, ~{nliO0lO});
	and(wire_niiOOi_dataout, wire_nill1O_dataout, ~{nliO0lO});
	and(wire_niiOOl_dataout, wire_nill0i_dataout, ~{nliO0lO});
	and(wire_niiOOO_dataout, wire_nill0l_dataout, ~{nliO0lO});
	and(wire_nil_dataout, nilll, ~{scan_mode});
	and(wire_nil00i_dataout, wire_nilOiO_dataout, ~{nliO0lO});
	and(wire_nil00l_dataout, wire_nilOli_dataout, ~{nliO0lO});
	and(wire_nil00O_dataout, wire_nilOll_dataout, ~{nliO0lO});
	and(wire_nil01i_dataout, wire_nilO0O_dataout, ~{nliO0lO});
	and(wire_nil01l_dataout, wire_nilOii_dataout, ~{nliO0lO});
	and(wire_nil01O_dataout, wire_nilOil_dataout, ~{nliO0lO});
	and(wire_nil0ii_dataout, wire_nilOlO_dataout, ~{nliO0lO});
	assign		wire_nil0il_dataout = (nliO1Oi === 1'b1) ? nliO1il : nii11i;
	assign		wire_nil0iO_dataout = (nliO1Oi === 1'b1) ? nliO1iO : nii11l;
	assign		wire_nil0li_dataout = (nliO1Oi === 1'b1) ? nliO1li : nii11O;
	assign		wire_nil0ll_dataout = (nliO1Oi === 1'b1) ? nliO1ll : nii10i;
	assign		wire_nil0lO_dataout = (nliO1Oi === 1'b1) ? (((wire_niO11O_o[18] | wire_niO11O_o[17]) | wire_niO11O_o[16]) | wire_niO11O_o[15]) : nii10l;
	assign		wire_nil0Oi_dataout = (nliO1Oi === 1'b1) ? wire_niO10i_dataout : nii10O;
	assign		wire_nil0Ol_dataout = (nliO1Oi === 1'b1) ? wire_niO10l_dataout : nii1ii;
	assign		wire_nil0OO_dataout = (nliO1Oi === 1'b1) ? wire_niO10O_dataout : nii1il;
	and(wire_nil10i_dataout, wire_nilliO_dataout, ~{nliO0lO});
	and(wire_nil10l_dataout, wire_nillli_dataout, ~{nliO0lO});
	and(wire_nil10O_dataout, wire_nillll_dataout, ~{nliO0lO});
	and(wire_nil11i_dataout, wire_nill0O_dataout, ~{nliO0lO});
	and(wire_nil11l_dataout, wire_nillii_dataout, ~{nliO0lO});
	or(wire_nil11O_dataout, wire_nillil_dataout, nliO0lO);
	and(wire_nil1ii_dataout, wire_nilllO_dataout, ~{nliO0lO});
	and(wire_nil1il_dataout, wire_nillOi_dataout, ~{nliO0lO});
	and(wire_nil1iO_dataout, wire_nillOl_dataout, ~{nliO0lO});
	and(wire_nil1li_dataout, wire_nillOO_dataout, ~{nliO0lO});
	and(wire_nil1ll_dataout, wire_nilO1i_dataout, ~{nliO0lO});
	and(wire_nil1lO_dataout, wire_nilO1l_dataout, ~{nliO0lO});
	and(wire_nil1Oi_dataout, wire_nilO1O_dataout, ~{nliO0lO});
	and(wire_nil1Ol_dataout, wire_nilO0i_dataout, ~{nliO0lO});
	and(wire_nil1OO_dataout, wire_nilO0l_dataout, ~{nliO0lO});
	assign		wire_nili_dataout = (rwa_6g_en === 1'b1) ? wire_nlll0i_dataout : wire_n010iO_dataout;
	assign		wire_nili0i_dataout = (nliO1Oi === 1'b1) ? nii1ll : n0OilO;
	assign		wire_nili0l_dataout = (nliO1Oi === 1'b1) ? n0OilO : nii1lO;
	assign		wire_nili0O_dataout = (nliO1Oi === 1'b1) ? nii1lO : nii1Oi;
	assign		wire_nili1i_dataout = (nliO1Oi === 1'b1) ? wire_niO1ii_dataout : nii1iO;
	assign		wire_nili1l_dataout = (nliO1Oi === 1'b1) ? wire_niO1il_dataout : nii1li;
	assign		wire_nili1O_dataout = (nliO1Oi === 1'b1) ? nii0Ol : nii1ll;
	assign		wire_niliii_dataout = (nliO1Oi === 1'b1) ? nii1Oi : nii1Ol;
	assign		wire_niliil_dataout = (nliO1Oi === 1'b1) ? nii1Ol : nii1OO;
	assign		wire_niliiO_dataout = (nliO1Oi === 1'b1) ? nii1OO : nii01i;
	assign		wire_nilili_dataout = (nliO1Oi === 1'b1) ? nii01i : nii01l;
	assign		wire_nilill_dataout = (nliO1Oi === 1'b1) ? nii01l : nii01O;
	assign		wire_nililO_dataout = (nliO1Oi === 1'b1) ? nii01O : nii00i;
	assign		wire_niliOi_dataout = (nliO1Oi === 1'b1) ? nii00i : nii00l;
	assign		wire_niliOl_dataout = (nliO1Oi === 1'b1) ? nii00l : nii00O;
	assign		wire_niliOO_dataout = (nliO1Oi === 1'b1) ? nii00O : nii0ii;
	assign		wire_nill_dataout = (rwa_6g_en === 1'b1) ? wire_nlll0l_dataout : wire_n010li_dataout;
	assign		wire_nill0i_dataout = (nliO1Oi === 1'b1) ? nii0li : nii0ll;
	assign		wire_nill0l_dataout = (nliO1Oi === 1'b1) ? nii0ll : nii0lO;
	assign		wire_nill0O_dataout = (nliO1Oi === 1'b1) ? nii0lO : nii0Oi;
	assign		wire_nill1i_dataout = (nliO1Oi === 1'b1) ? nii0ii : nii0il;
	assign		wire_nill1l_dataout = (nliO1Oi === 1'b1) ? nii0il : nii0iO;
	assign		wire_nill1O_dataout = (nliO1Oi === 1'b1) ? nii0iO : nii0li;
	assign		wire_nillii_dataout = (nliO1Oi === 1'b1) ? nii0Oi : nii0Ol;
	assign		wire_nillil_dataout = (nliO1Oi === 1'b1) ? niO1OO : n0OiOl;
	assign		wire_nilliO_dataout = (nliO1Oi === 1'b1) ? n0OiOl : nii0OO;
	assign		wire_nillli_dataout = (nliO1Oi === 1'b1) ? nii0OO : niii1i;
	assign		wire_nillll_dataout = (nliO1Oi === 1'b1) ? niii1i : niii1l;
	assign		wire_nilllO_dataout = (nliO1Oi === 1'b1) ? niii1l : niii1O;
	assign		wire_nillOi_dataout = (nliO1Oi === 1'b1) ? niii1O : niii0i;
	assign		wire_nillOl_dataout = (nliO1Oi === 1'b1) ? niii0i : niii0l;
	assign		wire_nillOO_dataout = (nliO1Oi === 1'b1) ? niii0l : niii0O;
	assign		wire_nilO_dataout = (rwa_6g_en === 1'b1) ? wire_nlll0O_dataout : wire_n010ll_dataout;
	assign		wire_nilO0i_dataout = (nliO1Oi === 1'b1) ? niiiiO : niiili;
	assign		wire_nilO0l_dataout = (nliO1Oi === 1'b1) ? niiili : niiill;
	assign		wire_nilO0O_dataout = (nliO1Oi === 1'b1) ? niiill : niiilO;
	assign		wire_nilO1i_dataout = (nliO1Oi === 1'b1) ? niii0O : niiiii;
	assign		wire_nilO1l_dataout = (nliO1Oi === 1'b1) ? niiiii : niiiil;
	assign		wire_nilO1O_dataout = (nliO1Oi === 1'b1) ? niiiil : niiiiO;
	assign		wire_nilOii_dataout = (nliO1Oi === 1'b1) ? niiilO : niiiOi;
	assign		wire_nilOil_dataout = (nliO1Oi === 1'b1) ? niiiOi : niiiOl;
	assign		wire_nilOiO_dataout = (nliO1Oi === 1'b1) ? niiiOl : niiiOO;
	assign		wire_nilOli_dataout = (nliO1Oi === 1'b1) ? niiiOO : niil1i;
	assign		wire_nilOll_dataout = (nliO1Oi === 1'b1) ? niil1i : niil1l;
	assign		wire_nilOlO_dataout = (nliO1Oi === 1'b1) ? niil1l : niO1OO;
	assign		wire_niO0i_dataout = (rwa_6g_en === 1'b1) ? wire_nllill_dataout : wire_n0101i_dataout;
	assign		wire_niO0l_dataout = (rwa_6g_en === 1'b1) ? wire_nllilO_dataout : wire_n0101l_dataout;
	assign		wire_niO0O_dataout = (rwa_6g_en === 1'b1) ? wire_nlliOi_dataout : wire_n0101O_dataout;
	and(wire_niO10i_dataout, wire_niO1iO_o[0], ~{nliO1lO});
	and(wire_niO10l_dataout, wire_niO1iO_o[1], ~{nliO1lO});
	and(wire_niO10O_dataout, wire_niO1iO_o[2], ~{nliO1lO});
	and(wire_niO1ii_dataout, wire_niO1iO_o[3], ~{nliO1lO});
	and(wire_niO1il_dataout, wire_niO1iO_o[4], ~{nliO1lO});
	assign		wire_niO1l_dataout = (rwa_6g_en === 1'b1) ? wire_nlliiO_dataout : wire_n011Ol_dataout;
	assign		wire_niO1O_dataout = (rwa_6g_en === 1'b1) ? wire_nllili_dataout : wire_n011OO_dataout;
	assign		wire_niOi_dataout = (rwa_6g_en === 1'b1) ? wire_nlllii_dataout : wire_n010lO_dataout;
	assign		wire_niOii_dataout = (rwa_6g_en === 1'b1) ? wire_nlliOl_dataout : wire_n0100i_dataout;
	assign		wire_niOil_dataout = (rwa_6g_en === 1'b1) ? wire_nlliOO_dataout : wire_n0100l_dataout;
	assign		wire_niOiO_dataout = (rwa_6g_en === 1'b1) ? wire_nlll1i_dataout : wire_n0100O_dataout;
	assign		wire_niOl_dataout = (rwa_6g_en === 1'b1) ? wire_nlllil_dataout : wire_n010Oi_dataout;
	and(wire_niOl0i_dataout, wire_niOOOl_dataout, ~{nliOl1i});
	and(wire_niOl0l_dataout, wire_niOOOO_dataout, ~{nliOl1i});
	and(wire_niOl0O_dataout, wire_nl111i_dataout, ~{nliOl1i});
	assign		wire_niOli_dataout = (rwa_6g_en === 1'b1) ? wire_nlll1l_dataout : wire_n010ii_dataout;
	and(wire_niOlii_dataout, wire_nl111l_dataout, ~{nliOl1i});
	and(wire_niOlil_dataout, wire_nl111O_dataout, ~{nliOl1i});
	or(wire_niOliO_dataout, wire_nl110i_dataout, nliOl1i);
	assign		wire_niOll_dataout = (rwa_6g_en === 1'b1) ? wire_nlll1O_dataout : wire_n010il_dataout;
	and(wire_niOlli_dataout, wire_nl110l_dataout, ~{nliOl1i});
	and(wire_niOlll_dataout, wire_nl110O_dataout, ~{nliOl1i});
	and(wire_niOllO_dataout, wire_nl11ii_dataout, ~{nliOl1i});
	assign		wire_niOlO_dataout = (rwa_6g_en === 1'b1) ? wire_nlll0i_dataout : wire_n010iO_dataout;
	and(wire_niOlOi_dataout, wire_nl11il_dataout, ~{nliOl1i});
	and(wire_niOlOl_dataout, wire_nl11iO_dataout, ~{nliOl1i});
	and(wire_niOlOO_dataout, wire_nl11li_dataout, ~{nliOl1i});
	assign		wire_niOO_dataout = (rwa_6g_en === 1'b1) ? wire_nllliO_dataout : wire_n010Ol_dataout;
	and(wire_niOO0i_dataout, wire_nl11Ol_dataout, ~{nliOl1i});
	and(wire_niOO0l_dataout, wire_nl11OO_dataout, ~{nliOl1i});
	and(wire_niOO0O_dataout, wire_nl101i_dataout, ~{nliOl1i});
	and(wire_niOO1i_dataout, wire_nl11ll_dataout, ~{nliOl1i});
	and(wire_niOO1l_dataout, wire_nl11lO_dataout, ~{nliOl1i});
	and(wire_niOO1O_dataout, wire_nl11Oi_dataout, ~{nliOl1i});
	and(wire_niOOi_dataout, wire_nlllll_dataout, rwa_6g_en);
	and(wire_niOOii_dataout, wire_nl101l_dataout, ~{nliOl1i});
	and(wire_niOOil_dataout, wire_nl101O_dataout, ~{nliOl1i});
	and(wire_niOOiO_dataout, wire_nl100i_dataout, ~{nliOl1i});
	and(wire_niOOl_dataout, wire_nllllO_dataout, rwa_6g_en);
	and(wire_niOOli_dataout, wire_nl100l_dataout, ~{nliOl1i});
	and(wire_niOOll_dataout, wire_nl100O_dataout, ~{nliOl1i});
	and(wire_niOOlO_dataout, wire_nl10ii_dataout, ~{nliOl1i});
	and(wire_niOOO_dataout, wire_nlllOi_dataout, rwa_6g_en);
	and(wire_niOOOi_dataout, wire_nl10il_dataout, ~{nliOl1i});
	assign		wire_niOOOl_dataout = (nliOiOl === 1'b1) ? wire_nl10iO_dataout : niO01i;
	assign		wire_niOOOO_dataout = (nliOiOl === 1'b1) ? wire_nl10li_dataout : niO01l;
	assign		wire_nl_dataout = (rwa_6g_en === 1'b1) ? wire_nl0l1O_dataout : wire_n10lil_dataout;
	assign		wire_nl00i_dataout = (rwa_6g_en === 1'b1) ? nlO00i : wire_n01llO_dataout;
	assign		wire_nl00l_dataout = (rwa_6g_en === 1'b1) ? nlO00l : wire_n0111i_dataout;
	and(wire_nl00li_dataout, (((~ rgenericfifo) & nl00iO) | nliO0iO), ~{nliO0lO});
	and(wire_nl00ll_dataout, nl00il, ~{nliO0lO});
	and(wire_nl00lO_dataout, nlOlOO, ~{nliO0lO});
	assign		wire_nl00O_dataout = (rwa_6g_en === 1'b1) ? nlO00O : wire_n01lOi_dataout;
	and(wire_nl00Oi_dataout, nl0i1O, ~{nliO0lO});
	and(wire_nl00Ol_dataout, ((~ rgenericfifo) & nl0ili), ~{nliO0lO});
	and(wire_nl010l_dataout, nl011i, ~{nliO0lO});
	and(wire_nl010O_dataout, nl011l, ~{nliO0lO});
	assign		wire_nl01i_dataout = (rwa_6g_en === 1'b1) ? nlO01i : wire_n01lli_dataout;
	and(wire_nl01ii_dataout, nl011O, ~{nliO0lO});
	and(wire_nl01il_dataout, nl010i, ~{nliO0lO});
	and(wire_nl01iO_dataout, nl01OO, ~{nliO0lO});
	assign		wire_nl01l_dataout = (rwa_6g_en === 1'b1) ? nlO01l : wire_n01lll_dataout;
	and(wire_nl01li_dataout, nl1l0l, ~{nliO0lO});
	and(wire_nl01ll_dataout, nl1l0O, ~{nliO0lO});
	and(wire_nl01lO_dataout, nl1lii, ~{nliO0lO});
	assign		wire_nl01O_dataout = (rwa_6g_en === 1'b1) ? nlO01O : wire_n1OOOO_dataout;
	and(wire_nl01Oi_dataout, nl1lil, ~{nliO0lO});
	and(wire_nl01Ol_dataout, nl1Oli, ~{nliO0lO});
	and(wire_nl0i_dataout, wire_nlllOi_dataout, rwa_6g_en);
	and(wire_nl0i0i_dataout, wire_nl0i0l_dataout, wire_nlliii_dataout);
	or(wire_nl0i0l_dataout, nl0ili, ((~ nl0ili) & nliO0li));
	assign		wire_nl0ii_dataout = (rwa_6g_en === 1'b1) ? ((nliOiO | nll10iO) | (~ nll11Ol29)) : ((((n1lO0l | nll10il) | (~ nll100O20)) | (wire_n1ilii_o & (n1Oi1O & ((nlOili & (((rrx_pipe_enable & nll100l) & (~ wire_n1OOOi_dataout)) & (~ wire_n1OOOl_dataout))) & nll101O23)))) | (~ nll101i26));
	assign		wire_nl0iii_dataout = (rdwidth_rx === 1'b1) ? (nliO0ll | nl0ill) : nliO0ll;
	assign		wire_nl0il_dataout = (rwa_6g_en === 1'b1) ? nliOOl : n1lOOi;
	and(wire_nl0iO_dataout, nlO0ii, rwa_6g_en);
	and(wire_nl0iOl_dataout, n00i0i, ~{nliO0lO});
	and(wire_nl0iOO_dataout, ((~ nl0iOi) & (nl00iO & n00i0i)), ~{nliO0lO});
	and(wire_nl0l_dataout, wire_nlllOl_dataout, rwa_6g_en);
	assign		wire_nl0l1O_dataout = (rdwidth_rx === 1'b1) ? (nliO0Oi | nl0lii) : nliO0Oi;
	and(wire_nl0li_dataout, nlO0il, rwa_6g_en);
	and(wire_nl0ll_dataout, nlO0iO, rwa_6g_en);
	and(wire_nl0lO_dataout, nlO0li, rwa_6g_en);
	and(wire_nl0lOi_dataout, nl0llO, ~{nliOl1i});
	or(wire_nl0lOl_dataout, n0Ol1l, nliOl1i);
	or(wire_nl0lOO_dataout, wire_nl0Oll_dataout, nliOl1i);
	and(wire_nl0O_dataout, wire_nlllOO_dataout, rwa_6g_en);
	assign		wire_nl0O0i_dataout = (rdwidth_rx === 1'b1) ? (nliOi1i | n0Ol1i) : nliOi1i;
	or(wire_nl0O1i_dataout, wire_nl0O0i_dataout, nliOl1i);
	and(wire_nl0O1l_dataout, wire_nl0OOl_dataout, ~{nliOl1i});
	and(wire_nl0O1O_dataout, wire_nl0Oii_dataout, ~{nliOl1i});
	and(wire_nl0Oi_dataout, nlO0ll, rwa_6g_en);
	assign		wire_nl0Oii_dataout = (rdwidth_rx === 1'b1) ? (nliOi1l | nl0lll) : nliOi1l;
	and(wire_nl0Ol_dataout, nlO0lO, rwa_6g_en);
	assign		wire_nl0Oll_dataout = (((((~ ralempty[3]) & (~ ralempty[2])) & (~ ralempty[1])) & (~ ralempty[0])) === 1'b1) ? wire_nliOOi_o : wire_nl0OlO_o;
	and(wire_nl0OO_dataout, nlO0Oi, rwa_6g_en);
	assign		wire_nl0OOl_dataout = (((((~ ralfull[3]) & (~ ralfull[2])) & (~ ralfull[1])) & (~ ralfull[0])) === 1'b1) ? wire_nliOlO_o : wire_nl0OOO_o;
	assign		wire_nl100i_dataout = (nliOiOl === 1'b1) ? niOiOl : niOiOO;
	assign		wire_nl100l_dataout = (nliOiOl === 1'b1) ? niOiOO : niOl1i;
	assign		wire_nl100O_dataout = (nliOiOl === 1'b1) ? niOl1i : niOl1l;
	assign		wire_nl101i_dataout = (nliOiOl === 1'b1) ? niOill : niOilO;
	assign		wire_nl101l_dataout = (nliOiOl === 1'b1) ? niOilO : niOiOi;
	assign		wire_nl101O_dataout = (nliOiOl === 1'b1) ? niOiOi : niOiOl;
	and(wire_nl10i_dataout, wire_nllO1l_dataout, rwa_6g_en);
	assign		wire_nl10ii_dataout = (nliOiOl === 1'b1) ? niOl1l : niOl1O;
	assign		wire_nl10il_dataout = (nliOiOl === 1'b1) ? niOl1O : nl1ili;
	and(wire_nl10iO_dataout, wire_nl10Ol_o[0], ~{nliO1Ol});
	and(wire_nl10l_dataout, wire_nllO1O_dataout, rwa_6g_en);
	and(wire_nl10li_dataout, wire_nl10Ol_o[1], ~{nliO1Ol});
	and(wire_nl10ll_dataout, wire_nl10Ol_o[2], ~{nliO1Ol});
	and(wire_nl10lO_dataout, wire_nl10Ol_o[3], ~{nliO1Ol});
	and(wire_nl10O_dataout, wire_nllO0i_dataout, rwa_6g_en);
	and(wire_nl10Oi_dataout, wire_nl10Ol_o[4], ~{nliO1Ol});
	and(wire_nl10OO_dataout, niO0ll, ~{nliOl1i});
	assign		wire_nl110i_dataout = (nliOiOl === 1'b1) ? nl1ili : n0OiOO;
	assign		wire_nl110l_dataout = (nliOiOl === 1'b1) ? n0OiOO : niOi1i;
	assign		wire_nl110O_dataout = (nliOiOl === 1'b1) ? niOi1i : niOi1l;
	assign		wire_nl111i_dataout = (nliOiOl === 1'b1) ? wire_nl10ll_dataout : niO01O;
	assign		wire_nl111l_dataout = (nliOiOl === 1'b1) ? wire_nl10lO_dataout : niO00i;
	assign		wire_nl111O_dataout = (nliOiOl === 1'b1) ? wire_nl10Oi_dataout : niO00l;
	and(wire_nl11i_dataout, wire_nlllOl_dataout, rwa_6g_en);
	assign		wire_nl11ii_dataout = (nliOiOl === 1'b1) ? niOi1l : niOi1O;
	assign		wire_nl11il_dataout = (nliOiOl === 1'b1) ? niOi1O : niOi0i;
	assign		wire_nl11iO_dataout = (nliOiOl === 1'b1) ? niOi0i : niOi0l;
	and(wire_nl11l_dataout, wire_nlllOO_dataout, rwa_6g_en);
	assign		wire_nl11li_dataout = (nliOiOl === 1'b1) ? niOi0l : niOi0O;
	assign		wire_nl11ll_dataout = (nliOiOl === 1'b1) ? niOi0O : niOiii;
	assign		wire_nl11lO_dataout = (nliOiOl === 1'b1) ? niOiii : niOiil;
	and(wire_nl11O_dataout, wire_nllO1i_dataout, rwa_6g_en);
	assign		wire_nl11Oi_dataout = (nliOiOl === 1'b1) ? niOiil : niOiiO;
	assign		wire_nl11Ol_dataout = (nliOiOl === 1'b1) ? niOiiO : niOili;
	assign		wire_nl11OO_dataout = (nliOiOl === 1'b1) ? niOili : niOill;
	assign		wire_nl1i_dataout = (rwa_6g_en === 1'b1) ? wire_nlllli_dataout : wire_n010OO_dataout;
	and(wire_nl1i0i_dataout, niO0OO, ~{nliOl1i});
	and(wire_nl1i0l_dataout, nii11i, ~{nliOl1i});
	and(wire_nl1i0O_dataout, nii11l, ~{nliOl1i});
	and(wire_nl1i1i_dataout, niO0lO, ~{nliOl1i});
	and(wire_nl1i1l_dataout, niO0Oi, ~{nliOl1i});
	and(wire_nl1i1O_dataout, niO0Ol, ~{nliOl1i});
	and(wire_nl1ii_dataout, wire_nllO0l_dataout, rwa_6g_en);
	and(wire_nl1iii_dataout, nii11O, ~{nliOl1i});
	and(wire_nl1iil_dataout, nii10i, ~{nliOl1i});
	and(wire_nl1iiO_dataout, nii10l, ~{nliOl1i});
	assign		wire_nl1il_dataout = (rwa_6g_en === 1'b1) ? nlO1il : wire_n01l1l_dataout;
	assign		wire_nl1iO_dataout = (rwa_6g_en === 1'b1) ? nlO1iO : wire_n01l1O_dataout;
	and(wire_nl1l_dataout, wire_nlllll_dataout, rwa_6g_en);
	assign		wire_nl1li_dataout = (rwa_6g_en === 1'b1) ? nlO1li : wire_n01l0i_dataout;
	and(wire_nl1liO_dataout, wire_nl1lOl_dataout, ~{nliOl1i});
	assign		wire_nl1ll_dataout = (rwa_6g_en === 1'b1) ? nlO1ll : wire_n01l0l_dataout;
	and(wire_nl1lli_dataout, wire_nl1lOO_dataout, ~{nliOl1i});
	and(wire_nl1lll_dataout, wire_nl1O1i_dataout, ~{nliOl1i});
	and(wire_nl1llO_dataout, wire_nl1O1l_dataout, ~{nliOl1i});
	assign		wire_nl1lO_dataout = (rwa_6g_en === 1'b1) ? nlO1lO : wire_n01l0O_dataout;
	and(wire_nl1lOi_dataout, wire_nl1O1O_dataout, ~{nliOl1i});
	assign		wire_nl1lOl_dataout = (nliOi1O === 1'b1) ? nl1l0l : nliO00l;
	assign		wire_nl1lOO_dataout = (nliOi1O === 1'b1) ? nl1l0O : nliO00O;
	and(wire_nl1O_dataout, wire_nllllO_dataout, rwa_6g_en);
	assign		wire_nl1O1i_dataout = (nliOi1O === 1'b1) ? nl1lii : nliO0ii;
	assign		wire_nl1O1l_dataout = (nliOi1O === 1'b1) ? nl1lil : nliO0il;
	assign		wire_nl1O1O_dataout = (nliOi1O === 1'b1) ? nl1Oli : (((wire_nl1OiO_o[19] | wire_nl1OiO_o[18]) | wire_nl1OiO_o[17]) | wire_nl1OiO_o[16]);
	assign		wire_nl1Oi_dataout = (rwa_6g_en === 1'b1) ? nlO1Oi : wire_n01lii_dataout;
	assign		wire_nl1Ol_dataout = (rwa_6g_en === 1'b1) ? nlO1Ol : wire_n01lil_dataout;
	assign		wire_nl1OO_dataout = (rwa_6g_en === 1'b1) ? nlO1OO : wire_n01liO_dataout;
	and(wire_nli_dataout, niO1i, ~{scan_mode});
	assign		wire_nli00i_dataout = (wire_nli0lO_o === 1'b1) ? wire_nli0ll_o[1] : wire_nli0iO_o[1];
	assign		wire_nli00l_dataout = (wire_nli0lO_o === 1'b1) ? wire_nli0ll_o[2] : wire_nli0iO_o[2];
	assign		wire_nli00O_dataout = (wire_nli0lO_o === 1'b1) ? wire_nli0ll_o[3] : wire_nli0iO_o[3];
	assign		wire_nli01i_dataout = (nliOi1O === 1'b1) ? nli1ii : wire_nli0ii_dataout;
	assign		wire_nli01l_dataout = (nliOi1O === 1'b1) ? nlii0O : wire_nli0il_dataout;
	and(wire_nli0i_dataout, nlOi1l, rwa_6g_en);
	assign		wire_nli0ii_dataout = (wire_nli0lO_o === 1'b1) ? wire_nli0ll_o[4] : wire_nli0iO_o[4];
	assign		wire_nli0il_dataout = (wire_nli0lO_o === 1'b1) ? wire_nli0ll_o[5] : wire_nli0iO_o[5];
	and(wire_nli0l_dataout, nlOi1O, rwa_6g_en);
	and(wire_nli0O_dataout, nlOi0i, rwa_6g_en);
	and(wire_nli1i_dataout, nlO0Ol, rwa_6g_en);
	and(wire_nli1il_dataout, wire_nli1Oi_dataout, ~{nliOl1i});
	and(wire_nli1iO_dataout, wire_nli1Ol_dataout, ~{nliOl1i});
	and(wire_nli1l_dataout, nlO0OO, rwa_6g_en);
	and(wire_nli1li_dataout, wire_nli1OO_dataout, ~{nliOl1i});
	and(wire_nli1ll_dataout, wire_nli01i_dataout, ~{nliOl1i});
	and(wire_nli1lO_dataout, wire_nli01l_dataout, ~{nliOl1i});
	and(wire_nli1O_dataout, nlOi1i, rwa_6g_en);
	assign		wire_nli1Oi_dataout = (nliOi1O === 1'b1) ? nli10i : wire_nli00i_dataout;
	assign		wire_nli1Ol_dataout = (nliOi1O === 1'b1) ? nli10l : wire_nli00l_dataout;
	assign		wire_nli1OO_dataout = (nliOi1O === 1'b1) ? nli10O : wire_nli00O_dataout;
	and(wire_nlii_dataout, wire_nllO1i_dataout, rwa_6g_en);
	and(wire_nliii_dataout, n0Ol0l, rwa_6g_en);
	and(wire_nliil_dataout, (nliOiO | nll10iO), rwa_6g_en);
	and(wire_nliill_dataout, wire_nlil1i_dataout, ~{nliOl1i});
	and(wire_nliilO_dataout, wire_nlil1l_dataout, ~{nliOl1i});
	and(wire_nliiO_dataout, nliOOl, rwa_6g_en);
	and(wire_nliiOi_dataout, wire_nlil1O_dataout, ~{nliOl1i});
	and(wire_nliiOl_dataout, wire_nlil0i_dataout, ~{nliOl1i});
	and(wire_nliiOO_dataout, wire_nlil0l_dataout, ~{nliOl1i});
	and(wire_nlil_dataout, wire_nllO1l_dataout, rwa_6g_en);
	assign		wire_nlil0i_dataout = (nliOilO === 1'b1) ? wire_nlillO_o[3] : wire_nliliO_dataout;
	assign		wire_nlil0l_dataout = (nliOilO === 1'b1) ? wire_nlillO_o[4] : wire_nlilli_dataout;
	assign		wire_nlil0O_dataout = ((~ nliOill) === 1'b1) ? wire_nlilll_o[1] : nliiii;
	assign		wire_nlil1i_dataout = (nliOilO === 1'b1) ? wire_nlillO_o[0] : wire_nlil0O_dataout;
	assign		wire_nlil1l_dataout = (nliOilO === 1'b1) ? wire_nlillO_o[1] : wire_nlilii_dataout;
	assign		wire_nlil1O_dataout = (nliOilO === 1'b1) ? wire_nlillO_o[2] : wire_nlilil_dataout;
	assign		wire_nlili_dataout = (rwa_6g_en === 1'b1) ? wire_nlliii_dataout : wire_n011lO_dataout;
	assign		wire_nlilii_dataout = ((~ nliOill) === 1'b1) ? wire_nlilll_o[2] : nliiil;
	assign		wire_nlilil_dataout = ((~ nliOill) === 1'b1) ? wire_nlilll_o[3] : nliiiO;
	assign		wire_nliliO_dataout = ((~ nliOill) === 1'b1) ? wire_nlilll_o[4] : nliili;
	assign		wire_nlill_dataout = (rwa_6g_en === 1'b1) ? ((rmatchen & (~ rgenericfifo)) & nll10li17) : (((~ rgenericfifo) & (((nll1i1i & is_lane0) | ((~ dskwclksel[1]) & rmatchen)) | (~ nll10Ol11))) & nll10lO14);
	assign		wire_nlilli_dataout = ((~ nliOill) === 1'b1) ? wire_nlilll_o[5] : nliOil;
	assign		wire_nlilO_dataout = (rwa_6g_en === 1'b1) ? n0OiOO : nllllil;
	and(wire_nliO_dataout, wire_nllO1O_dataout, rwa_6g_en);
	assign		wire_nliOi_dataout = (rwa_6g_en === 1'b1) ? niOi1i : nlOliil;
	assign		wire_nliOl_dataout = (rwa_6g_en === 1'b1) ? niOi1l : nlOliiO;
	and(wire_nliOli_dataout, nliOl1l, ~{nliOl1i});
	and(wire_nliOll_dataout, nliOl1l, ~{nliOl1i});
	assign		wire_nliOO_dataout = (rwa_6g_en === 1'b1) ? niOi1O : nlOlili;
	and(wire_nliOOO_dataout, (nliOl0i | nliOl1O), wire_nlli0O_dataout);
	and(wire_nll_dataout, cmpfifourst, rcmpfifourst);
	or(wire_nll01O_dataout, (nliOOOi & (nliOOli & (wire_nlliii_dataout & nll1lO))), (rtruebac2bac & (nliOOOi & (nliOOli & (nll01l & wire_nlliii_dataout)))));
	assign		wire_nll0i_dataout = (rwa_6g_en === 1'b1) ? niOiii : nlOliOl;
	assign		wire_nll0l_dataout = (rwa_6g_en === 1'b1) ? niOiil : nlOliOO;
	or(wire_nll0ll_dataout, wire_nll0lO_dataout, (rtruebac2bac & ((nliOOli & ((nliOOOi & (nlO1ii & wire_nlliii_dataout)) & nliOO0i56)) & nliOO1l59)));
	and(wire_nll0lO_dataout, (nliOOOi & nliOOli), (wire_nlliii_dataout & nll01i));
	assign		wire_nll0O_dataout = (rwa_6g_en === 1'b1) ? niOiiO : nlOll1i;
	and(wire_nll10i_dataout, nliOl0l, wire_nlli0O_dataout);
	assign		wire_nll10l_dataout = (nll11i === 1'b1) ? (nliOlii | nliOl0O) : wire_nll10O_dataout;
	or(wire_nll10O_dataout, (rtruebac2bac & (nll1ll & (~ nliOllO))), ((nliOlll | nliOlli) & (nliOliO | nliOlil)));
	and(wire_nll11O_dataout, wire_nll10l_dataout, wire_nlli0O_dataout);
	assign		wire_nll1i_dataout = (rwa_6g_en === 1'b1) ? niOi0i : nlOlill;
	assign		wire_nll1l_dataout = (rwa_6g_en === 1'b1) ? niOi0l : nlOlilO;
	and(wire_nll1l0i_dataout, nll1l0O, ~{(~ nliliiO)});
	and(wire_nll1l0l_dataout, nll1l1l, ~{(~ nliliiO)});
	and(wire_nll1lii_dataout, wire_n1l11O_o, (rgenericfifo | wire_n011lO_dataout));
	assign		wire_nll1O_dataout = (rwa_6g_en === 1'b1) ? niOi0O : nlOliOi;
	and(wire_nll1Oi_dataout, (nliOOli & (nliOlOl | nliOlOi)), wire_nlliii_dataout);
	and(wire_nll1Ol_dataout, (nliOO1i | nliOlOO), wire_nlliii_dataout);
	and(wire_nlli_dataout, wire_nllO0i_dataout, rwa_6g_en);
	and(wire_nlli0O_dataout, nl001O, ~{nliOO0O});
	assign		wire_nllii_dataout = (rwa_6g_en === 1'b1) ? niOili : nlOll1l;
	and(wire_nlliii_dataout, sync_status, ~{nliOO0O});
	assign		wire_nlliiO_dataout = (nliOOii === 1'b1) ? nl000O : sync_status;
	assign		wire_nllil_dataout = (rwa_6g_en === 1'b1) ? niOill : nlOll1O;
	assign		wire_nllili_dataout = (nliOOii === 1'b1) ? ni101i : sudi[0];
	assign		wire_nllill_dataout = (nliOOii === 1'b1) ? ni101l : sudi[1];
	assign		wire_nllilO_dataout = (nliOOii === 1'b1) ? ni101O : sudi[2];
	assign		wire_nlliO_dataout = (rwa_6g_en === 1'b1) ? niOilO : nlOll0i;
	assign		wire_nlliOi_dataout = (nliOOii === 1'b1) ? ni100i : sudi[3];
	assign		wire_nlliOl_dataout = (nliOOii === 1'b1) ? ni100l : sudi[4];
	assign		wire_nlliOO_dataout = (nliOOii === 1'b1) ? ni100O : sudi[5];
	and(wire_nlll_dataout, wire_nllO0l_dataout, rwa_6g_en);
	assign		wire_nlll0i_dataout = (nliOOii === 1'b1) ? ni10li : sudi[9];
	assign		wire_nlll0l_dataout = (nliOOii === 1'b1) ? ni10ll : sudi[10];
	assign		wire_nlll0O_dataout = (nliOOii === 1'b1) ? ni10lO : sudi[11];
	assign		wire_nlll1i_dataout = (nliOOii === 1'b1) ? ni10ii : sudi[6];
	assign		wire_nlll1l_dataout = (nliOOii === 1'b1) ? ni10il : sudi[7];
	assign		wire_nlll1O_dataout = (nliOOii === 1'b1) ? ni10iO : sudi[8];
	assign		wire_nllli_dataout = (rwa_6g_en === 1'b1) ? niOiOi : nlOll0l;
	assign		wire_nlllii_dataout = (nliOOii === 1'b1) ? ni10Oi : sudi[12];
	assign		wire_nlllil_dataout = (nliOOii === 1'b1) ? ni10Ol : sudi[13];
	and(wire_nllliO_dataout, ni10OO, nliOOii);
	assign		wire_nllll_dataout = (rwa_6g_en === 1'b1) ? niOiOl : nlOll0O;
	and(wire_nlllli_dataout, ni1i1i, nliOOii);
	assign		wire_nlllll_dataout = (nliOOii === 1'b1) ? ni1i1l : sudi[14];
	assign		wire_nllllO_dataout = (nliOOii === 1'b1) ? ni1i1O : sudi[15];
	assign		wire_nlllO_dataout = (rwa_6g_en === 1'b1) ? niOiOO : nlOllii;
	assign		wire_nlllOi_dataout = (nliOOii === 1'b1) ? ni1i0i : sudi[16];
	assign		wire_nlllOl_dataout = (nliOOii === 1'b1) ? ni1i0l : sudi[17];
	assign		wire_nlllOO_dataout = (nliOOii === 1'b1) ? ni1i0O : sudi[18];
	and(wire_nllO_dataout, wire_nllO0O_dataout, rwa_6g_en);
	assign		wire_nllO0i_dataout = (nliOOii === 1'b1) ? ni1ili : sudi[22];
	assign		wire_nllO0l_dataout = (nliOOii === 1'b1) ? ni1ill : sudi[23];
	assign		wire_nllO0O_dataout = (nliOOii === 1'b1) ? ni1ilO : sudi[24];
	assign		wire_nllO1i_dataout = (nliOOii === 1'b1) ? ni1iii : sudi[19];
	assign		wire_nllO1l_dataout = (nliOOii === 1'b1) ? ni1iil : sudi[20];
	assign		wire_nllO1O_dataout = (nliOOii === 1'b1) ? ni1iiO : sudi[21];
	assign		wire_nllOi_dataout = (rwa_6g_en === 1'b1) ? niOl1i : nlOllil;
	assign		wire_nllOii_dataout = (nliOOii === 1'b1) ? ni1iOl : sudi[25];
	assign		wire_nllOil_dataout = (nliOOii === 1'b1) ? ni1iOO : sudi[26];
	assign		wire_nllOiO_dataout = (nliOOii === 1'b1) ? ni1l1l : sudi[27];
	assign		wire_nllOl_dataout = (rwa_6g_en === 1'b1) ? niOl1l : nlOlliO;
	and(wire_nllOli_dataout, ni1l1O, nliOOii);
	and(wire_nllOll_dataout, ni0OOO, nliOOii);
	assign		wire_nllOO_dataout = (rwa_6g_en === 1'b1) ? niOl1O : nlOllli;
	assign		wire_nllOOll_dataout = (nlil1ll === 1'b1) ? wire_nlO010O_dataout : wire_nlO11li_dataout;
	assign		wire_nllOOlO_dataout = (nlil1ll === 1'b1) ? (~ nllOOiO) : wire_nlO11ll_dataout;
	assign		wire_nllOOOi_dataout = (nlil1ll === 1'b1) ? (~ nllOOiO) : wire_nlO11lO_dataout;
	assign		wire_nllOOOl_dataout = (nlil1ll === 1'b1) ? wire_nlO01ii_dataout : wire_nlO11Oi_dataout;
	assign		wire_nllOOOO_dataout = (nlil1ll === 1'b1) ? (~ nllOOiO) : wire_nlO11Ol_dataout;
	assign		wire_nlO_dataout = (rwa_6g_en === 1'b1) ? wire_nl0iii_dataout : wire_n10ili_dataout;
	assign		wire_nlO010O_dataout = (rclkcmpinsertpad === 1'b1) ? (~ nllOOiO) : nllOOiO;
	assign		wire_nlO011i_dataout = (wire_n111il_dataout === 1'b1) ? nllO10O : nllOOiO;
	and(wire_nlO011l_dataout, nllOOli, ~{wire_n111il_dataout});
	or(wire_nlO011O_dataout, nlO01il, wire_n111il_dataout);
	assign		wire_nlO01ii_dataout = (rclkcmpinsertpad === 1'b1) ? nllOOiO : (~ nllOOiO);
	assign		wire_nlO0i_dataout = (rwa_6g_en === 1'b1) ? nii1lO : nlO000l;
	assign		wire_nlO0l_dataout = (rwa_6g_en === 1'b1) ? nii1Oi : nlO000O;
	and(wire_nlO0lll_dataout, wire_nlOii1i_dataout, ~{nliliil});
	and(wire_nlO0llO_dataout, wire_nlOii1l_dataout, ~{nliliil});
	and(wire_nlO0lOi_dataout, wire_nlOii1O_dataout, ~{nliliil});
	and(wire_nlO0lOl_dataout, wire_nlOii0i_dataout, ~{nliliil});
	and(wire_nlO0lOO_dataout, wire_nlOii0l_dataout, ~{nliliil});
	assign		wire_nlO0O_dataout = (rwa_6g_en === 1'b1) ? nii1Ol : nlO00ii;
	and(wire_nlO0O0i_dataout, wire_nlOiiiO_dataout, ~{nliliil});
	and(wire_nlO0O0l_dataout, wire_nlOiili_dataout, ~{nliliil});
	and(wire_nlO0O0O_dataout, wire_nlOiill_dataout, ~{nliliil});
	and(wire_nlO0O1i_dataout, wire_nlOii0O_dataout, ~{nliliil});
	and(wire_nlO0O1l_dataout, wire_nlOiiii_dataout, ~{nliliil});
	and(wire_nlO0O1O_dataout, wire_nlOiiil_dataout, ~{nliliil});
	or(wire_nlO0Oii_dataout, wire_nlOiilO_dataout, nliliil);
	and(wire_nlO0Oil_dataout, wire_nlOiiOi_dataout, ~{nliliil});
	and(wire_nlO0OiO_dataout, wire_nlOiiOl_dataout, ~{nliliil});
	and(wire_nlO0Oli_dataout, wire_nlOiiOO_dataout, ~{nliliil});
	and(wire_nlO0Oll_dataout, wire_nlOil1i_dataout, ~{nliliil});
	and(wire_nlO0OlO_dataout, wire_nlOil1l_dataout, ~{nliliil});
	and(wire_nlO0OOi_dataout, wire_nlOil1O_dataout, ~{nliliil});
	and(wire_nlO0OOl_dataout, wire_nlOil0i_dataout, ~{nliliil});
	and(wire_nlO0OOO_dataout, wire_nlOil0l_dataout, ~{nliliil});
	assign		wire_nlO100i_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[9] : wire_nlO1i0l_dataout;
	assign		wire_nlO100l_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[10] : wire_nlO1i0O_dataout;
	assign		wire_nlO100O_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[11] : wire_nlO1iii_dataout;
	assign		wire_nlO101i_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[6] : wire_nlO1i1l_dataout;
	assign		wire_nlO101l_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[7] : wire_nlO1i1O_dataout;
	assign		wire_nlO101O_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[8] : wire_nlO1i0i_dataout;
	assign		wire_nlO10ii_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[12] : wire_nlO1iil_dataout;
	assign		wire_nlO10il_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[13] : wire_nlO1iiO_dataout;
	assign		wire_nlO10iO_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[14] : wire_nlO1ili_dataout;
	assign		wire_nlO10li_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[15] : wire_nlO1ill_dataout;
	assign		wire_nlO10ll_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1l1l_dataout : nllOlli;
	assign		wire_nlO10lO_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1l1O_dataout : nllOlll;
	assign		wire_nlO10Oi_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1l0i_dataout : nllOllO;
	assign		wire_nlO10Ol_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1l0l_dataout : nllOlOi;
	assign		wire_nlO10OO_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1l0O_dataout : nllOlOl;
	assign		wire_nlO110i_dataout = (nlil1ll === 1'b1) ? nllOOiO : wire_nlO101O_dataout;
	assign		wire_nlO110l_dataout = (nlil1ll === 1'b1) ? nllOOiO : wire_nlO100i_dataout;
	and(wire_nlO110O_dataout, wire_nlO100l_dataout, ~{nlil1ll});
	assign		wire_nlO111i_dataout = (nlil1ll === 1'b1) ? nllOOiO : wire_nlO11OO_dataout;
	assign		wire_nlO111l_dataout = (nlil1ll === 1'b1) ? (~ nllOOiO) : wire_nlO101i_dataout;
	assign		wire_nlO111O_dataout = (nlil1ll === 1'b1) ? nllOOiO : wire_nlO101l_dataout;
	and(wire_nlO11ii_dataout, wire_nlO10ii_dataout, ~{nlil1ll});
	and(wire_nlO11il_dataout, wire_nlO10iO_dataout, ~{nlil1ll});
	or(wire_nlO11iO_dataout, wire_nlO10li_dataout, nlil1ll);
	assign		wire_nlO11li_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[0] : wire_nlO10ll_dataout;
	assign		wire_nlO11ll_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[1] : wire_nlO10lO_dataout;
	assign		wire_nlO11lO_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[2] : wire_nlO10Oi_dataout;
	assign		wire_nlO11Oi_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[3] : wire_nlO10Ol_dataout;
	assign		wire_nlO11Ol_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[4] : wire_nlO10OO_dataout;
	assign		wire_nlO11OO_dataout = (nliiOOl === 1'b1) ? wire_nlOiii_data_out1[5] : wire_nlO1i1i_dataout;
	assign		wire_nlO1i_dataout = (rwa_6g_en === 1'b1) ? nl1ili : n1110l;
	assign		wire_nlO1i0i_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1lli_dataout : nllOO1O;
	assign		wire_nlO1i0l_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1lll_dataout : nllOO0i;
	assign		wire_nlO1i0O_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1llO_dataout : wire_nlO1ilO_dataout;
	assign		wire_nlO1i1i_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1lii_dataout : nllOlOO;
	assign		wire_nlO1i1l_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1lil_dataout : nllOO1i;
	assign		wire_nlO1i1O_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1liO_dataout : nllOO1l;
	assign		wire_nlO1iii_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1lOi_dataout : nllOO0O;
	assign		wire_nlO1iil_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1lOl_dataout : wire_nlO1iOi_dataout;
	assign		wire_nlO1iiO_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1lOO_dataout : nllOOiO;
	and(wire_nlO1ili_dataout, wire_nlO1O1i_dataout, rclkcmpsqmd);
	assign		wire_nlO1ill_dataout = (rclkcmpsqmd === 1'b1) ? wire_nlO1O1l_dataout : (~ rrx_pipe_enable);
	and(wire_nlO1ilO_dataout, wire_nlO1iOl_dataout, ~{rrx_pipe_enable});
	and(wire_nlO1iOi_dataout, wire_nlO1iOO_dataout, ~{rrx_pipe_enable});
	and(wire_nlO1iOl_dataout, nllOO0l, nliiOOi);
	and(wire_nlO1iOO_dataout, nllOOii, nliiOOi);
	assign		wire_nlO1l_dataout = (rwa_6g_en === 1'b1) ? nii1ll : nlO000i;
	assign		wire_nlO1l0i_dataout = (n1O11O === 1'b1) ? nllO1lO : wire_nlO1O0l_dataout;
	assign		wire_nlO1l0l_dataout = (n1O11O === 1'b1) ? nllO1Ol : wire_nlO1O0O_dataout;
	assign		wire_nlO1l0O_dataout = (n1O11O === 1'b1) ? nllO01i : wire_nlO1Oii_dataout;
	assign		wire_nlO1l1l_dataout = (n1O11O === 1'b1) ? nllO1il : wire_nlO1O1O_dataout;
	assign		wire_nlO1l1O_dataout = (n1O11O === 1'b1) ? nllO1li : wire_nlO1O0i_dataout;
	assign		wire_nlO1lii_dataout = (n1O11O === 1'b1) ? nllO01O : wire_nlO1Oil_dataout;
	assign		wire_nlO1lil_dataout = (n1O11O === 1'b1) ? nllO00l : wire_nlO1OiO_dataout;
	assign		wire_nlO1liO_dataout = (n1O11O === 1'b1) ? nllO0ii : wire_nlO1Oli_dataout;
	assign		wire_nlO1lli_dataout = (n1O11O === 1'b1) ? nllO0iO : wire_nlO1Oll_dataout;
	assign		wire_nlO1lll_dataout = (n1O11O === 1'b1) ? nllO0ll : wire_nlO1OlO_dataout;
	and(wire_nlO1llO_dataout, wire_nlO1OOi_dataout, ~{n1O11O});
	assign		wire_nlO1lOi_dataout = (n1O11O === 1'b1) ? nllO0Oi : wire_nlO1OOl_dataout;
	and(wire_nlO1lOl_dataout, wire_nlO1OOO_dataout, ~{n1O11O});
	assign		wire_nlO1lOO_dataout = (n1O11O === 1'b1) ? nllO0OO : wire_nlO011i_dataout;
	assign		wire_nlO1O_dataout = (rwa_6g_en === 1'b1) ? n0OilO : nllll0O;
	assign		wire_nlO1O0i_dataout = (wire_n111il_dataout === 1'b1) ? nlllO1i : nllOlll;
	assign		wire_nlO1O0l_dataout = (wire_n111il_dataout === 1'b1) ? nlllO1O : nllOllO;
	assign		wire_nlO1O0O_dataout = (wire_n111il_dataout === 1'b1) ? nlllO0l : nllOlOi;
	and(wire_nlO1O1i_dataout, wire_nlO011l_dataout, ~{n1O11O});
	or(wire_nlO1O1l_dataout, wire_nlO011O_dataout, n1O11O);
	assign		wire_nlO1O1O_dataout = (wire_n111il_dataout === 1'b1) ? nllllOl : nllOlli;
	assign		wire_nlO1Oii_dataout = (wire_n111il_dataout === 1'b1) ? nlllOii : nllOlOl;
	assign		wire_nlO1Oil_dataout = (wire_n111il_dataout === 1'b1) ? nlllOiO : nllOlOO;
	assign		wire_nlO1OiO_dataout = (wire_n111il_dataout === 1'b1) ? nlllOll : nllOO1i;
	assign		wire_nlO1Oli_dataout = (wire_n111il_dataout === 1'b1) ? nlllOOi : nllOO1l;
	assign		wire_nlO1Oll_dataout = (wire_n111il_dataout === 1'b1) ? nlllOOO : nllOO1O;
	assign		wire_nlO1OlO_dataout = (wire_n111il_dataout === 1'b1) ? nllO11l : nllOO0i;
	and(wire_nlO1OOi_dataout, nllOO0l, ~{wire_n111il_dataout});
	assign		wire_nlO1OOl_dataout = (wire_n111il_dataout === 1'b1) ? nllO10i : nllOO0O;
	and(wire_nlO1OOO_dataout, nllOOii, ~{wire_n111il_dataout});
	and(wire_nlOi_dataout, wire_nllOii_dataout, rwa_6g_en);
	and(wire_nlOi00i_dataout, wire_nlOiOiO_dataout, ~{nliliil});
	and(wire_nlOi00l_dataout, wire_nlOiOli_dataout, ~{nliliil});
	and(wire_nlOi00O_dataout, wire_nlOiOll_dataout, ~{nliliil});
	and(wire_nlOi01i_dataout, wire_nlOiO0O_dataout, ~{nliliil});
	and(wire_nlOi01l_dataout, wire_nlOiOii_dataout, ~{nliliil});
	and(wire_nlOi01O_dataout, wire_nlOiOil_dataout, ~{nliliil});
	and(wire_nlOi0ii_dataout, wire_nlOiOlO_dataout, ~{nliliil});
	and(wire_nlOi0il_dataout, wire_nlOiOOi_dataout, ~{nliliil});
	and(wire_nlOi0iO_dataout, wire_nlOiOOl_dataout, ~{nliliil});
	and(wire_nlOi0li_dataout, wire_nlOiOOO_dataout, ~{nliliil});
	and(wire_nlOi0ll_dataout, wire_nlOl11i_dataout, ~{nliliil});
	and(wire_nlOi0lO_dataout, wire_nlOl11l_dataout, ~{nliliil});
	and(wire_nlOi0Oi_dataout, wire_nlOl11O_dataout, ~{nliliil});
	and(wire_nlOi0Ol_dataout, wire_nlOl10i_dataout, ~{nliliil});
	and(wire_nlOi0OO_dataout, wire_nlOl10l_dataout, ~{nliliil});
	and(wire_nlOi10i_dataout, wire_nlOiliO_dataout, ~{nliliil});
	and(wire_nlOi10l_dataout, wire_nlOilli_dataout, ~{nliliil});
	and(wire_nlOi10O_dataout, wire_nlOilll_dataout, ~{nliliil});
	and(wire_nlOi11i_dataout, wire_nlOil0O_dataout, ~{nliliil});
	and(wire_nlOi11l_dataout, wire_nlOilii_dataout, ~{nliliil});
	and(wire_nlOi11O_dataout, wire_nlOilil_dataout, ~{nliliil});
	and(wire_nlOi1ii_dataout, wire_nlOillO_dataout, ~{nliliil});
	and(wire_nlOi1il_dataout, wire_nlOilOi_dataout, ~{nliliil});
	and(wire_nlOi1iO_dataout, wire_nlOilOl_dataout, ~{nliliil});
	and(wire_nlOi1li_dataout, wire_nlOilOO_dataout, ~{nliliil});
	or(wire_nlOi1ll_dataout, wire_nlOiO1i_dataout, nliliil);
	and(wire_nlOi1lO_dataout, wire_nlOiO1l_dataout, ~{nliliil});
	and(wire_nlOi1Oi_dataout, wire_nlOiO1O_dataout, ~{nliliil});
	and(wire_nlOi1Ol_dataout, wire_nlOiO0i_dataout, ~{nliliil});
	and(wire_nlOi1OO_dataout, wire_nlOiO0l_dataout, ~{nliliil});
	assign		wire_nlOii_dataout = (rwa_6g_en === 1'b1) ? nii1OO : nlO00il;
	assign		wire_nlOii0i_dataout = (nlil10l === 1'b1) ? nlil11O : nlO01lO;
	assign		wire_nlOii0l_dataout = (nlil10l === 1'b1) ? (((wire_nlOl1ll_o[18] | wire_nlOl1ll_o[17]) | wire_nlOl1ll_o[16]) | wire_nlOl1ll_o[15]) : nlO01Oi;
	assign		wire_nlOii0O_dataout = (nlil10l === 1'b1) ? wire_nlOl1lO_dataout : nlO01Ol;
	assign		wire_nlOii1i_dataout = (nlil10l === 1'b1) ? nliiOOO : nlO01iO;
	assign		wire_nlOii1l_dataout = (nlil10l === 1'b1) ? nlil11i : nlO01li;
	assign		wire_nlOii1O_dataout = (nlil10l === 1'b1) ? nlil11l : nlO01ll;
	assign		wire_nlOiiii_dataout = (nlil10l === 1'b1) ? wire_nlOl1Oi_dataout : nlO01OO;
	assign		wire_nlOiiil_dataout = (nlil10l === 1'b1) ? wire_nlOl1Ol_dataout : nlO001i;
	assign		wire_nlOiiiO_dataout = (nlil10l === 1'b1) ? wire_nlOl1OO_dataout : nlO001l;
	assign		wire_nlOiili_dataout = (nlil10l === 1'b1) ? wire_nlOl01i_dataout : nlO001O;
	assign		wire_nlOiill_dataout = (nlil10l === 1'b1) ? nlO0iii : nlO000i;
	assign		wire_nlOiilO_dataout = (nlil10l === 1'b1) ? nlO000i : nllll0O;
	assign		wire_nlOiiOi_dataout = (nlil10l === 1'b1) ? nllll0O : nlO000l;
	assign		wire_nlOiiOl_dataout = (nlil10l === 1'b1) ? nlO000l : nlO000O;
	assign		wire_nlOiiOO_dataout = (nlil10l === 1'b1) ? nlO000O : nlO00ii;
	assign		wire_nlOil_dataout = (rwa_6g_en === 1'b1) ? nii01i : nlO00iO;
	assign		wire_nlOil0i_dataout = (nlil10l === 1'b1) ? nlO00li : nlO00ll;
	assign		wire_nlOil0l_dataout = (nlil10l === 1'b1) ? nlO00ll : nlO00lO;
	assign		wire_nlOil0O_dataout = (nlil10l === 1'b1) ? nlO00lO : nlO00Oi;
	assign		wire_nlOil1i_dataout = (nlil10l === 1'b1) ? nlO00ii : nlO00il;
	assign		wire_nlOil1l_dataout = (nlil10l === 1'b1) ? nlO00il : nlO00iO;
	assign		wire_nlOil1O_dataout = (nlil10l === 1'b1) ? nlO00iO : nlO00li;
	assign		wire_nlOilii_dataout = (nlil10l === 1'b1) ? nlO00Oi : nlO00Ol;
	assign		wire_nlOilil_dataout = (nlil10l === 1'b1) ? nlO00Ol : nlO00OO;
	assign		wire_nlOiliO_dataout = (nlil10l === 1'b1) ? nlO00OO : nlO0i1i;
	assign		wire_nlOilli_dataout = (nlil10l === 1'b1) ? nlO0i1i : nlO0i1l;
	assign		wire_nlOilll_dataout = (nlil10l === 1'b1) ? nlO0i1l : nlO0i1O;
	assign		wire_nlOillO_dataout = (nlil10l === 1'b1) ? nlO0i1O : nlO0i0i;
	assign		wire_nlOilOi_dataout = (nlil10l === 1'b1) ? nlO0i0i : nlO0i0l;
	assign		wire_nlOilOl_dataout = (nlil10l === 1'b1) ? nlO0i0l : nlO0i0O;
	assign		wire_nlOilOO_dataout = (nlil10l === 1'b1) ? nlO0i0O : nlO0iii;
	assign		wire_nlOiO_dataout = (rwa_6g_en === 1'b1) ? nii01l : nlO00li;
	assign		wire_nlOiO0i_dataout = (nlil10l === 1'b1) ? nlO0iiO : nlO0ili;
	assign		wire_nlOiO0l_dataout = (nlil10l === 1'b1) ? nlO0ili : nlO0ill;
	assign		wire_nlOiO0O_dataout = (nlil10l === 1'b1) ? nlO0ill : nlO0ilO;
	assign		wire_nlOiO1i_dataout = (nlil10l === 1'b1) ? nlOl0ii : nllllii;
	assign		wire_nlOiO1l_dataout = (nlil10l === 1'b1) ? nllllii : nlO0iil;
	assign		wire_nlOiO1O_dataout = (nlil10l === 1'b1) ? nlO0iil : nlO0iiO;
	assign		wire_nlOiOii_dataout = (nlil10l === 1'b1) ? nlO0ilO : nlO0iOi;
	assign		wire_nlOiOil_dataout = (nlil10l === 1'b1) ? nlO0iOi : nlO0iOl;
	assign		wire_nlOiOiO_dataout = (nlil10l === 1'b1) ? nlO0iOl : nlO0iOO;
	assign		wire_nlOiOli_dataout = (nlil10l === 1'b1) ? nlO0iOO : nlO0l1i;
	assign		wire_nlOiOll_dataout = (nlil10l === 1'b1) ? nlO0l1i : nlO0l1l;
	assign		wire_nlOiOlO_dataout = (nlil10l === 1'b1) ? nlO0l1l : nlO0l1O;
	assign		wire_nlOiOOi_dataout = (nlil10l === 1'b1) ? nlO0l1O : nlO0l0i;
	assign		wire_nlOiOOl_dataout = (nlil10l === 1'b1) ? nlO0l0i : nlO0l0l;
	assign		wire_nlOiOOO_dataout = (nlil10l === 1'b1) ? nlO0l0l : nlO0l0O;
	and(wire_nlOl_dataout, wire_nllOil_dataout, rwa_6g_en);
	and(wire_nlOl01i_dataout, wire_nlOl01l_o[4], ~{nlil10i});
	and(wire_nlOl0i_dataout, wire_nlOl0O_dataout, ~{(~ wire_nlili_dataout)});
	and(wire_nlOl0l_dataout, nlOlOO, ~{wire_n0OO_dataout});
	and(wire_nlOl0O_dataout, nlOili, ~{wire_n0OO_dataout});
	assign		wire_nlOl10i_dataout = (nlil10l === 1'b1) ? nlO0liO : nlO0lli;
	assign		wire_nlOl10l_dataout = (nlil10l === 1'b1) ? nlO0lli : nlOl0ii;
	assign		wire_nlOl11i_dataout = (nlil10l === 1'b1) ? nlO0l0O : nlO0lii;
	assign		wire_nlOl11l_dataout = (nlil10l === 1'b1) ? nlO0lii : nlO0lil;
	assign		wire_nlOl11O_dataout = (nlil10l === 1'b1) ? nlO0lil : nlO0liO;
	and(wire_nlOl1l_dataout, wire_n0OO_dataout, ~{(~ wire_nlili_dataout)});
	and(wire_nlOl1lO_dataout, wire_nlOl01l_o[0], ~{nlil10i});
	and(wire_nlOl1O_dataout, wire_nlOl0l_dataout, ~{(~ wire_nlili_dataout)});
	and(wire_nlOl1Oi_dataout, wire_nlOl01l_o[1], ~{nlil10i});
	and(wire_nlOl1Ol_dataout, wire_nlOl01l_o[2], ~{nlil10i});
	and(wire_nlOl1OO_dataout, wire_nlOl01l_o[3], ~{nlil10i});
	assign		wire_nlOli_dataout = (rwa_6g_en === 1'b1) ? nii01O : nlO00ll;
	assign		wire_nlOlii_dataout = ((~ wire_nlili_dataout) === 1'b1) ? nlOili : wire_nlOlli_dataout;
	assign		wire_nlOlil_dataout = ((~ wire_nlili_dataout) === 1'b1) ? nlOlOO : wire_nlOlll_dataout;
	and(wire_nlOliO_dataout, (~ nll11iO), ~{(~ wire_nlili_dataout)});
	assign		wire_nlOll_dataout = (rwa_6g_en === 1'b1) ? nii00i : nlO00lO;
	assign		wire_nlOlli_dataout = (nll11iO === 1'b1) ? wire_n0Oi_dataout : nlOili;
	assign		wire_nlOlll_dataout = (nll11iO === 1'b1) ? wire_n0Ol_dataout : nlOlOO;
	and(wire_nlOllll_dataout, wire_nlOO10O_dataout, ~{nlill1O});
	and(wire_nlOlllO_dataout, wire_nlOO1ii_dataout, ~{nlill1O});
	and(wire_nlOllOi_dataout, wire_nlOO1il_dataout, ~{nlill1O});
	and(wire_nlOllOl_dataout, wire_nlOO1iO_dataout, ~{nlill1O});
	and(wire_nlOllOO_dataout, wire_nlOO1li_dataout, ~{nlill1O});
	assign		wire_nlOlO_dataout = (rwa_6g_en === 1'b1) ? nii00l : nlO00Oi;
	and(wire_nlOlO0i_dataout, wire_nlOO1Ol_dataout, ~{nlill1O});
	and(wire_nlOlO0l_dataout, wire_nlOO1OO_dataout, ~{nlill1O});
	and(wire_nlOlO0O_dataout, wire_nlOO01i_dataout, ~{nlill1O});
	or(wire_nlOlO1i_dataout, wire_nlOO1ll_dataout, nlill1O);
	and(wire_nlOlO1l_dataout, wire_nlOO1lO_dataout, ~{nlill1O});
	and(wire_nlOlO1O_dataout, wire_nlOO1Oi_dataout, ~{nlill1O});
	and(wire_nlOlOi_dataout, wire_n0lO_dataout, wire_nlili_dataout);
	and(wire_nlOlOii_dataout, wire_nlOO01l_dataout, ~{nlill1O});
	and(wire_nlOlOil_dataout, wire_nlOO01O_dataout, ~{nlill1O});
	and(wire_nlOlOiO_dataout, wire_nlOO00i_dataout, ~{nlill1O});
	and(wire_nlOlOli_dataout, wire_nlOO00l_dataout, ~{nlill1O});
	and(wire_nlOlOll_dataout, wire_nlOO00O_dataout, ~{nlill1O});
	and(wire_nlOlOlO_dataout, wire_nlOO0ii_dataout, ~{nlill1O});
	and(wire_nlOlOOi_dataout, wire_nlOO0il_dataout, ~{nlill1O});
	and(wire_nlOlOOl_dataout, wire_nlOO0iO_dataout, ~{nlill1O});
	and(wire_nlOlOOO_dataout, wire_nlOO0li_dataout, ~{nlill1O});
	and(wire_nlOO_dataout, wire_nllOiO_dataout, rwa_6g_en);
	assign		wire_nlOO00i_dataout = (nlill1i === 1'b1) ? nlOliOl : wire_nlOOiOl_dataout;
	assign		wire_nlOO00l_dataout = (nlill1i === 1'b1) ? nlOliOO : wire_nlOOiOO_dataout;
	assign		wire_nlOO00O_dataout = (nlill1i === 1'b1) ? nlOll1i : wire_nlOOl1i_dataout;
	assign		wire_nlOO01i_dataout = (nlill1i === 1'b1) ? nlOlill : wire_nlOOill_dataout;
	assign		wire_nlOO01l_dataout = (nlill1i === 1'b1) ? nlOlilO : wire_nlOOilO_dataout;
	assign		wire_nlOO01O_dataout = (nlill1i === 1'b1) ? nlOliOi : wire_nlOOiOi_dataout;
	assign		wire_nlOO0ii_dataout = (nlill1i === 1'b1) ? nlOll1l : wire_nlOOl1l_dataout;
	assign		wire_nlOO0il_dataout = (nlill1i === 1'b1) ? nlOll1O : wire_nlOOl1O_dataout;
	assign		wire_nlOO0iO_dataout = (nlill1i === 1'b1) ? nlOll0i : wire_nlOOl0i_dataout;
	assign		wire_nlOO0li_dataout = (nlill1i === 1'b1) ? nlOll0l : wire_nlOOl0l_dataout;
	assign		wire_nlOO0ll_dataout = (nlill1i === 1'b1) ? nlOll0O : wire_nlOOl0O_dataout;
	assign		wire_nlOO0lO_dataout = (nlill1i === 1'b1) ? nlOllii : wire_nlOOlii_dataout;
	assign		wire_nlOO0Oi_dataout = (nlill1i === 1'b1) ? nlOllil : wire_nlOOlil_dataout;
	assign		wire_nlOO0Ol_dataout = (nlill1i === 1'b1) ? nlOlliO : wire_nlOOliO_dataout;
	assign		wire_nlOO0OO_dataout = (nlill1i === 1'b1) ? nlOllli : wire_nlOOlli_dataout;
	and(wire_nlOO10i_dataout, wire_nlOO0Ol_dataout, ~{nlill1O});
	and(wire_nlOO10l_dataout, wire_nlOO0OO_dataout, ~{nlill1O});
	assign		wire_nlOO10O_dataout = (nlill1i === 1'b1) ? wire_nlOOO0i_dataout : wire_nlOOi1i_dataout;
	and(wire_nlOO11i_dataout, wire_nlOO0ll_dataout, ~{nlill1O});
	and(wire_nlOO11l_dataout, wire_nlOO0lO_dataout, ~{nlill1O});
	and(wire_nlOO11O_dataout, wire_nlOO0Oi_dataout, ~{nlill1O});
	assign		wire_nlOO1ii_dataout = (nlill1i === 1'b1) ? wire_nlOOO0l_dataout : wire_nlOOi1l_dataout;
	assign		wire_nlOO1il_dataout = (nlill1i === 1'b1) ? wire_nlOOO0O_dataout : wire_nlOOi1O_dataout;
	assign		wire_nlOO1iO_dataout = (nlill1i === 1'b1) ? wire_nlOOOii_dataout : wire_nlOOi0i_dataout;
	assign		wire_nlOO1li_dataout = (nlill1i === 1'b1) ? wire_nlOOOil_dataout : wire_nlOOi0l_dataout;
	assign		wire_nlOO1ll_dataout = (nlill1i === 1'b1) ? n1110l : wire_nlOOi0O_dataout;
	assign		wire_nlOO1lO_dataout = (nlill1i === 1'b1) ? nllllil : wire_nlOOiii_dataout;
	assign		wire_nlOO1Oi_dataout = (nlill1i === 1'b1) ? nlOliil : wire_nlOOiil_dataout;
	assign		wire_nlOO1Ol_dataout = (nlill1i === 1'b1) ? nlOliiO : wire_nlOOiiO_dataout;
	assign		wire_nlOO1OO_dataout = (nlill1i === 1'b1) ? nlOlili : wire_nlOOili_dataout;
	assign		wire_nlOOi_dataout = (rwa_6g_en === 1'b1) ? nii00O : nlO00Ol;
	assign		wire_nlOOi0i_dataout = (nlil1ii === 1'b1) ? wire_nlOOlOl_dataout : nlOl0ll;
	assign		wire_nlOOi0l_dataout = (nlil1ii === 1'b1) ? wire_nlOOlOO_dataout : nlOl0lO;
	assign		wire_nlOOi0O_dataout = (nlil1ii === 1'b1) ? nlOliil : nllllil;
	assign		wire_nlOOi1i_dataout = (nlil1ii === 1'b1) ? wire_nlOOlll_dataout : nlOl0il;
	assign		wire_nlOOi1l_dataout = (nlil1ii === 1'b1) ? wire_nlOOllO_dataout : nlOl0iO;
	assign		wire_nlOOi1O_dataout = (nlil1ii === 1'b1) ? wire_nlOOlOi_dataout : nlOl0li;
	assign		wire_nlOOiii_dataout = (nlil1ii === 1'b1) ? nlOliiO : nlOliil;
	assign		wire_nlOOiil_dataout = (nlil1ii === 1'b1) ? nlOlili : nlOliiO;
	assign		wire_nlOOiiO_dataout = (nlil1ii === 1'b1) ? nlOlill : nlOlili;
	assign		wire_nlOOili_dataout = (nlil1ii === 1'b1) ? nlOlilO : nlOlill;
	assign		wire_nlOOill_dataout = (nlil1ii === 1'b1) ? nlOliOi : nlOlilO;
	assign		wire_nlOOilO_dataout = (nlil1ii === 1'b1) ? nlOliOl : nlOliOi;
	assign		wire_nlOOiOi_dataout = (nlil1ii === 1'b1) ? nlOliOO : nlOliOl;
	assign		wire_nlOOiOl_dataout = (nlil1ii === 1'b1) ? nlOll1i : nlOliOO;
	assign		wire_nlOOiOO_dataout = (nlil1ii === 1'b1) ? nlOll1l : nlOll1i;
	assign		wire_nlOOl_dataout = (rwa_6g_en === 1'b1) ? nii0ii : nlO00OO;
	assign		wire_nlOOl0i_dataout = (nlil1ii === 1'b1) ? nlOll0O : nlOll0l;
	assign		wire_nlOOl0l_dataout = (nlil1ii === 1'b1) ? nlOllii : nlOll0O;
	assign		wire_nlOOl0O_dataout = (nlil1ii === 1'b1) ? nlOllil : nlOllii;
	assign		wire_nlOOl1i_dataout = (nlil1ii === 1'b1) ? nlOll1O : nlOll1l;
	assign		wire_nlOOl1l_dataout = (nlil1ii === 1'b1) ? nlOll0i : nlOll1O;
	assign		wire_nlOOl1O_dataout = (nlil1ii === 1'b1) ? nlOll0l : nlOll0i;
	assign		wire_nlOOlii_dataout = (nlil1ii === 1'b1) ? nlOlliO : nlOllil;
	assign		wire_nlOOlil_dataout = (nlil1ii === 1'b1) ? nlOllli : nlOlliO;
	assign		wire_nlOOliO_dataout = (nlil1ii === 1'b1) ? n1110l : nlOllli;
	assign		wire_nlOOlli_dataout = (nlil1ii === 1'b1) ? nllllil : n1110l;
	or(wire_nlOOlll_dataout, wire_nlOOO1i_o[1], nlil10O);
	or(wire_nlOOllO_dataout, wire_nlOOO1i_o[2], nlil10O);
	and(wire_nlOOlOi_dataout, wire_nlOOO1i_o[3], ~{nlil10O});
	and(wire_nlOOlOl_dataout, wire_nlOOO1i_o[4], ~{nlil10O});
	or(wire_nlOOlOO_dataout, wire_nlOOO1i_o[5], nlil10O);
	assign		wire_nlOOO_dataout = (rwa_6g_en === 1'b1) ? nii0il : nlO0i1i;
	and(wire_nlOOO0i_dataout, wire_nlOOOiO_o[0], ~{nlil1il});
	and(wire_nlOOO0l_dataout, wire_nlOOOiO_o[1], ~{nlil1il});
	and(wire_nlOOO0O_dataout, wire_nlOOOiO_o[2], ~{nlil1il});
	and(wire_nlOOOii_dataout, wire_nlOOOiO_o[3], ~{nlil1il});
	and(wire_nlOOOil_dataout, wire_nlOOOiO_o[4], ~{nlil1il});
	and(wire_nlOOOli_dataout, nlOli1O, ~{nlill1O});
	and(wire_nlOOOll_dataout, nlOli0i, ~{nlill1O});
	and(wire_nlOOOlO_dataout, nlOli0l, ~{nlill1O});
	and(wire_nlOOOOi_dataout, nlOli0O, ~{nlill1O});
	and(wire_nlOOOOl_dataout, nlOliii, ~{nlill1O});
	and(wire_nlOOOOO_dataout, nlO01iO, ~{nlill1O});
	assign		wire_nO_dataout = (rwa_6g_en === 1'b1) ? nli11O : n1i1il;
	oper_add   n1i0Ol
	( 
	.a({(~ wire_n1i0OO_o[5]), (~ wire_n1i0OO_o[4]), (~ wire_n1i0OO_o[3]), (~ wire_n1i0OO_o[2]), (~ wire_n1i0OO_o[1]), 1'b1}),
	.b({1'b1, 1'b0, 1'b1, {2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1i0Ol_o));
	defparam
		n1i0Ol.sgate_representation = 0,
		n1i0Ol.width_a = 6,
		n1i0Ol.width_b = 6,
		n1i0Ol.width_o = 6;
	oper_add   n1i0OO
	( 
	.a({nlOli1l, nlili1O, nlili0i, nlili0l, nlili0O, 1'b1}),
	.b({(~ nlOl0lO), (~ nlOl0ll), (~ nlOl0li), (~ nlOl0iO), (~ nlOl0il), 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1i0OO_o));
	defparam
		n1i0OO.sgate_representation = 0,
		n1i0OO.width_a = 6,
		n1i0OO.width_b = 6,
		n1i0OO.width_o = 6;
	oper_add   n1i10O
	( 
	.a({1'b0, ralfull[3:2]}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1i10O_o));
	defparam
		n1i10O.sgate_representation = 0,
		n1i10O.width_a = 3,
		n1i10O.width_b = 3,
		n1i10O.width_o = 3;
	oper_add   n1i11O
	( 
	.a({1'b0, (~ ralempty[3]), (~ ralempty[2]), (~ ralempty[1]), (~ ralempty[0]), 1'b1}),
	.b({{5{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1i11O_o));
	defparam
		n1i11O.sgate_representation = 0,
		n1i11O.width_a = 6,
		n1i11O.width_b = 6,
		n1i11O.width_o = 6;
	oper_add   n1ii1i
	( 
	.a({nlOl0lO, nlOl0ll, nlOl0li, nlOl0iO, nlOl0il, 1'b1}),
	.b({(~ nlOli1l), (~ nlili1O), (~ nlili0i), (~ nlili0l), (~ nlili0O), 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1ii1i_o));
	defparam
		n1ii1i.sgate_representation = 0,
		n1ii1i.width_a = 6,
		n1ii1i.width_b = 6,
		n1ii1i.width_o = 6;
	oper_add   n1li0O
	( 
	.a({n1lO0i, n1l1iO, n1l1il, n1l1ii, n1l10O, 1'b1}),
	.b({{4{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1li0O_o));
	defparam
		n1li0O.sgate_representation = 0,
		n1li0O.width_a = 6,
		n1li0O.width_b = 6,
		n1li0O.width_o = 6;
	oper_add   n1liii
	( 
	.a({n1lO0i, n1l1iO, n1l1il, n1l1ii, n1l10O}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1liii_o));
	defparam
		n1liii.sgate_representation = 0,
		n1liii.width_a = 5,
		n1liii.width_b = 5,
		n1liii.width_o = 5;
	oper_add   n1liOi
	( 
	.a({n1lO0i, n1l1iO, n1l1il, n1l1ii}),
	.b({{3{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1liOi_o));
	defparam
		n1liOi.sgate_representation = 0,
		n1liOi.width_a = 4,
		n1liOi.width_b = 4,
		n1liOi.width_o = 4;
	oper_add   n1liOO
	( 
	.a({n1lO0i, n1l1iO, n1l1il, n1l1ii, n1l10O}),
	.b({{3{1'b0}}, {2{1'b1}}}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1liOO_o));
	defparam
		n1liOO.sgate_representation = 0,
		n1liOO.width_a = 5,
		n1liOO.width_b = 5,
		n1liOO.width_o = 5;
	oper_add   n1O00i
	( 
	.a({n1O10O, n1O10l, n1O10i}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1O00i_o));
	defparam
		n1O00i.sgate_representation = 0,
		n1O00i.width_a = 3,
		n1O00i.width_b = 3,
		n1O00i.width_o = 3;
	oper_add   niO1iO
	( 
	.a({nii1li, nii1iO, nii1il, nii1ii, nii10O}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niO1iO_o));
	defparam
		niO1iO.sgate_representation = 0,
		niO1iO.width_a = 5,
		niO1iO.width_b = 5,
		niO1iO.width_o = 5;
	oper_add   nl0OOi
	( 
	.a({1'b0, (~ ralempty[3]), (~ ralempty[2]), (~ ralempty[1]), (~ ralempty[0]), 1'b1}),
	.b({{5{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nl0OOi_o));
	defparam
		nl0OOi.sgate_representation = 0,
		nl0OOi.width_a = 6,
		nl0OOi.width_b = 6,
		nl0OOi.width_o = 6;
	oper_add   nl10Ol
	( 
	.a({niO00l, niO00i, niO01O, niO01l, niO01i}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nl10Ol_o));
	defparam
		nl10Ol.sgate_representation = 0,
		nl10Ol.width_a = 5,
		nl10Ol.width_b = 5,
		nl10Ol.width_o = 5;
	oper_add   nli0iO
	( 
	.a({(~ wire_nli0li_o[5]), (~ wire_nli0li_o[4]), (~ wire_nli0li_o[3]), (~ wire_nli0li_o[2]), (~ wire_nli0li_o[1]), 1'b1}),
	.b({1'b1, 1'b0, 1'b1, {2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0iO_o));
	defparam
		nli0iO.sgate_representation = 0,
		nli0iO.width_a = 6,
		nli0iO.width_b = 6,
		nli0iO.width_o = 6;
	oper_add   nli0li
	( 
	.a({niO0li, nliOi0l, nliOi0O, nliOiii, nliOiil, 1'b1}),
	.b({(~ niO00l), (~ niO00i), (~ niO01O), (~ niO01l), (~ niO01i), 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0li_o));
	defparam
		nli0li.sgate_representation = 0,
		nli0li.width_a = 6,
		nli0li.width_b = 6,
		nli0li.width_o = 6;
	oper_add   nli0ll
	( 
	.a({niO00l, niO00i, niO01O, niO01l, niO01i, 1'b1}),
	.b({(~ niO0li), (~ nliOi0l), (~ nliOi0O), (~ nliOiii), (~ nliOiil), 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0ll_o));
	defparam
		nli0ll.sgate_representation = 0,
		nli0ll.width_a = 6,
		nli0ll.width_b = 6,
		nli0ll.width_o = 6;
	oper_add   nli11i
	( 
	.a({1'b0, ralfull[3:2]}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli11i_o));
	defparam
		nli11i.sgate_representation = 0,
		nli11i.width_a = 3,
		nli11i.width_b = 3,
		nli11i.width_o = 3;
	oper_add   nlilll
	( 
	.a({nliOil, nliili, nliiiO, nliiil, nliiii, 1'b1}),
	.b({{4{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlilll_o));
	defparam
		nlilll.sgate_representation = 0,
		nlilll.width_a = 6,
		nlilll.width_b = 6,
		nlilll.width_o = 6;
	oper_add   nlillO
	( 
	.a({nliOil, nliili, nliiiO, nliiil, nliiii}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlillO_o));
	defparam
		nlillO.sgate_representation = 0,
		nlillO.width_a = 5,
		nlillO.width_b = 5,
		nlillO.width_o = 5;
	oper_add   nlOl01l
	( 
	.a({nlO001O, nlO001l, nlO001i, nlO01OO, nlO01Ol}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlOl01l_o));
	defparam
		nlOl01l.sgate_representation = 0,
		nlOl01l.width_a = 5,
		nlOl01l.width_b = 5,
		nlOl01l.width_o = 5;
	oper_add   nlOOO1i
	( 
	.a({nlOl0lO, nlOl0ll, nlOl0li, nlOl0iO, nlOl0il, 1'b1}),
	.b({{4{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlOOO1i_o));
	defparam
		nlOOO1i.sgate_representation = 0,
		nlOOO1i.width_a = 6,
		nlOOO1i.width_b = 6,
		nlOOO1i.width_o = 6;
	oper_add   nlOOOiO
	( 
	.a({nlOl0lO, nlOl0ll, nlOl0li, nlOl0iO, nlOl0il}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlOOOiO_o));
	defparam
		nlOOOiO.sgate_representation = 0,
		nlOOOiO.width_a = 5,
		nlOOOiO.width_b = 5,
		nlOOOiO.width_o = 5;
	oper_decoder   n001Ol
	( 
	.i({rskpsetbased, rclkcmpsqmd, rclkcmppos}),
	.o(wire_n001Ol_o));
	defparam
		n001Ol.width_i = 3,
		n001Ol.width_o = 8;
	oper_decoder   n11Oii
	( 
	.i({wire_n1i0Oi_dataout, wire_n1i0lO_dataout, wire_n1i0ll_dataout, wire_n1i0li_dataout, wire_n1i0iO_dataout}),
	.o(wire_n11Oii_o));
	defparam
		n11Oii.width_i = 5,
		n11Oii.width_o = 32;
	oper_decoder   niO11O
	( 
	.i({nii1li, nii1iO, nii1il, nii1ii, nii10O}),
	.o(wire_niO11O_o));
	defparam
		niO11O.width_i = 5,
		niO11O.width_o = 32;
	oper_decoder   nl1OiO
	( 
	.i({wire_nli0il_dataout, wire_nli0ii_dataout, wire_nli00O_dataout, wire_nli00l_dataout, wire_nli00i_dataout}),
	.o(wire_nl1OiO_o));
	defparam
		nl1OiO.width_i = 5,
		nl1OiO.width_o = 32;
	oper_decoder   nlOl1i
	( 
	.i({nlOiiO, (nll11il32 & nlOO1l)}),
	.o(wire_nlOl1i_o));
	defparam
		nlOl1i.width_i = 2,
		nlOl1i.width_o = 4;
	oper_decoder   nlOl1ll
	( 
	.i({nlO001O, nlO001l, nlO001i, nlO01OO, nlO01Ol}),
	.o(wire_nlOl1ll_o));
	defparam
		nlOl1ll.width_i = 5,
		nlOl1ll.width_o = 32;
	oper_less_than   n11i0l
	( 
	.a({3{1'b0}}),
	.b({n1O10O, n1O10l, n1O10i}),
	.cin(1'b0),
	.o(wire_n11i0l_o));
	defparam
		n11i0l.sgate_representation = 0,
		n11i0l.width_a = 3,
		n11i0l.width_b = 3;
	oper_less_than   n11i1l
	( 
	.a({n1O10O, n1O10l, n1O10i}),
	.b({1'b1, 1'b0, 1'b1}),
	.cin(1'b0),
	.o(wire_n11i1l_o));
	defparam
		n11i1l.sgate_representation = 0,
		n11i1l.width_a = 3,
		n11i1l.width_b = 3;
	oper_less_than   n11l1i
	( 
	.a({1'b0, 1'b1, 1'b0, {2{1'b1}}}),
	.b({n11OOi, nlil1Ol, nlil1OO, nlil01i, nlil01l}),
	.cin(1'b1),
	.o(wire_n11l1i_o));
	defparam
		n11l1i.sgate_representation = 0,
		n11l1i.width_a = 5,
		n11l1i.width_b = 5;
	oper_less_than   n1i10l
	( 
	.a({wire_n1i10O_o[2:0], ralfull[1:0]}),
	.b({n1ilil, n1i1lO, n1i1ll, n1i1li, n1i1iO}),
	.cin(1'b0),
	.o(wire_n1i10l_o));
	defparam
		n1i10l.sgate_representation = 0,
		n1i10l.width_a = 5,
		n1i10l.width_b = 5;
	oper_less_than   n1i11l
	( 
	.a({n1ilil, n1i1lO, n1i1ll, n1i1li, n1i1iO}),
	.b({wire_n1i11O_o[5:1]}),
	.cin(1'b0),
	.o(wire_n1i11l_o));
	defparam
		n1i11l.sgate_representation = 0,
		n1i11l.width_a = 5,
		n1i11l.width_b = 5;
	oper_less_than   n1i1ii
	( 
	.a({5{1'b0}}),
	.b({nlOli1l, nlili1O, nlili0i, nlili0l, nlili0O}),
	.cin(1'b0),
	.o(wire_n1i1ii_o));
	defparam
		n1i1ii.sgate_representation = 0,
		n1i1ii.width_a = 5,
		n1i1ii.width_b = 5;
	oper_less_than   n1ii1l
	( 
	.a({nlOli1l, nlili1O, nlili0i, nlili0l, nlili0O}),
	.b({nlOl0lO, nlOl0ll, nlOl0li, nlOl0iO, nlOl0il}),
	.cin(1'b1),
	.o(wire_n1ii1l_o));
	defparam
		n1ii1l.sgate_representation = 0,
		n1ii1l.width_a = 5,
		n1ii1l.width_b = 5;
	oper_less_than   n1ilii
	( 
	.a({1'b0, {2{1'b1}}, 1'b0, 1'b1}),
	.b({wire_n1i0Oi_dataout, wire_n1i0lO_dataout, wire_n1i0ll_dataout, wire_n1i0li_dataout, wire_n1i0iO_dataout}),
	.cin(1'b0),
	.o(wire_n1ilii_o));
	defparam
		n1ilii.sgate_representation = 0,
		n1ilii.width_a = 5,
		n1ilii.width_b = 5;
	oper_less_than   n1l11O
	( 
	.a({n1ilil, n1i1lO, n1i1ll, n1i1li, n1i1iO}),
	.b({{2{1'b0}}, 1'b1, 1'b0, 1'b1}),
	.cin(1'b0),
	.o(wire_n1l11O_o));
	defparam
		n1l11O.sgate_representation = 0,
		n1l11O.width_a = 5,
		n1l11O.width_b = 5;
	oper_less_than   n1lOll
	( 
	.a({1'b0, {2{1'b1}}, 1'b0, 1'b1}),
	.b({n1ilil, n1i1lO, n1i1ll, n1i1li, n1i1iO}),
	.cin(1'b0),
	.o(wire_n1lOll_o));
	defparam
		n1lOll.sgate_representation = 0,
		n1lOll.width_a = 5,
		n1lOll.width_b = 5;
	oper_less_than   n1lOlO
	( 
	.a({n1ilil, n1i1lO, n1i1ll, n1i1li, n1i1iO}),
	.b({1'b0, 1'b1, 1'b0, {2{1'b1}}}),
	.cin(1'b0),
	.o(wire_n1lOlO_o));
	defparam
		n1lOlO.sgate_representation = 0,
		n1lOlO.width_a = 5,
		n1lOlO.width_b = 5;
	oper_less_than   nl0OlO
	( 
	.a({nlii0O, nli1ii, nli10O, nli10l, nli10i}),
	.b({wire_nl0OOi_o[5:1]}),
	.cin(1'b0),
	.o(wire_nl0OlO_o));
	defparam
		nl0OlO.sgate_representation = 0,
		nl0OlO.width_a = 5,
		nl0OlO.width_b = 5;
	oper_less_than   nl0OOO
	( 
	.a({wire_nli11i_o[2:0], ralfull[1:0]}),
	.b({nlii0O, nli1ii, nli10O, nli10l, nli10i}),
	.cin(1'b0),
	.o(wire_nl0OOO_o));
	defparam
		nl0OOO.sgate_representation = 0,
		nl0OOO.width_a = 5,
		nl0OOO.width_b = 5;
	oper_less_than   nl1l1O
	( 
	.a({1'b0, 1'b1, 1'b0, {2{1'b1}}}),
	.b({nl1OOO, nliO01i, nliO01l, nliO01O, nliO00i}),
	.cin(1'b1),
	.o(wire_nl1l1O_o));
	defparam
		nl1l1O.sgate_representation = 0,
		nl1l1O.width_a = 5,
		nl1l1O.width_b = 5;
	oper_less_than   nli0lO
	( 
	.a({niO0li, nliOi0l, nliOi0O, nliOiii, nliOiil}),
	.b({niO00l, niO00i, niO01O, niO01l, niO01i}),
	.cin(1'b1),
	.o(wire_nli0lO_o));
	defparam
		nli0lO.sgate_representation = 0,
		nli0lO.width_a = 5,
		nli0lO.width_b = 5;
	oper_less_than   nli11l
	( 
	.a({5{1'b0}}),
	.b({niO0li, nliOi0l, nliOi0O, nliOiii, nliOiil}),
	.cin(1'b0),
	.o(wire_nli11l_o));
	defparam
		nli11l.sgate_representation = 0,
		nli11l.width_a = 5,
		nli11l.width_b = 5;
	oper_less_than   nlii0l
	( 
	.a({nlii0O, nli1ii, nli10O, nli10l, nli10i}),
	.b({{2{1'b0}}, 1'b1, 1'b0, 1'b1}),
	.cin(1'b0),
	.o(wire_nlii0l_o));
	defparam
		nlii0l.sgate_representation = 0,
		nlii0l.width_a = 5,
		nlii0l.width_b = 5;
	oper_less_than   nlii1l
	( 
	.a({1'b0, {2{1'b1}}, 1'b0, 1'b1}),
	.b({wire_nli0il_dataout, wire_nli0ii_dataout, wire_nli00O_dataout, wire_nli00l_dataout, wire_nli00i_dataout}),
	.cin(1'b0),
	.o(wire_nlii1l_o));
	defparam
		nlii1l.sgate_representation = 0,
		nlii1l.width_a = 5,
		nlii1l.width_b = 5;
	oper_less_than   nliOlO
	( 
	.a({1'b0, {2{1'b1}}, 1'b0, 1'b1}),
	.b({nlii0O, nli1ii, nli10O, nli10l, nli10i}),
	.cin(1'b0),
	.o(wire_nliOlO_o));
	defparam
		nliOlO.sgate_representation = 0,
		nliOlO.width_a = 5,
		nliOlO.width_b = 5;
	oper_less_than   nliOOi
	( 
	.a({nlii0O, nli1ii, nli10O, nli10l, nli10i}),
	.b({1'b0, 1'b1, 1'b0, {2{1'b1}}}),
	.cin(1'b0),
	.o(wire_nliOOi_o));
	defparam
		nliOOi.sgate_representation = 0,
		nliOOi.width_a = 5,
		nliOOi.width_b = 5;
	oper_selector   n0010i
	( 
	.data({rclkcmpsq1n[2], rclkcmpsq1n[12], rclkcmpsq1p[12], rclkcmpsq1p[2]}),
	.o(wire_n0010i_o),
	.sel({nliO11l, nliO11i, wire_n001Ol_o[3], wire_n001Ol_o[1]}));
	defparam
		n0010i.width_data = 4,
		n0010i.width_sel = 4;
	oper_selector   n0010l
	( 
	.data({rclkcmpsq1n[3], rclkcmpsq1n[13], rclkcmpsq1p[13], rclkcmpsq1p[3]}),
	.o(wire_n0010l_o),
	.sel({nliO11l, nliO11i, wire_n001Ol_o[3], wire_n001Ol_o[1]}));
	defparam
		n0010l.width_data = 4,
		n0010l.width_sel = 4;
	oper_selector   n0010O
	( 
	.data({rclkcmpsq1n[4], rclkcmpsq1n[14], rclkcmpsq1p[14], rclkcmpsq1p[4]}),
	.o(wire_n0010O_o),
	.sel({nliO11l, nliO11i, wire_n001Ol_o[3], wire_n001Ol_o[1]}));
	defparam
		n0010O.width_data = 4,
		n0010O.width_sel = 4;
	oper_selector   n0011l
	( 
	.data({rclkcmpsq1n[0], rclkcmpsq1n[10], rclkcmpsq1p[10], rclkcmpsq1p[0]}),
	.o(wire_n0011l_o),
	.sel({nliO11l, nliO11i, wire_n001Ol_o[3], wire_n001Ol_o[1]}));
	defparam
		n0011l.width_data = 4,
		n0011l.width_sel = 4;
	oper_selector   n0011O
	( 
	.data({rclkcmpsq1n[1], rclkcmpsq1n[11], rclkcmpsq1p[11], rclkcmpsq1p[1]}),
	.o(wire_n0011O_o),
	.sel({nliO11l, nliO11i, wire_n001Ol_o[3], wire_n001Ol_o[1]}));
	defparam
		n0011O.width_data = 4,
		n0011O.width_sel = 4;
	oper_selector   n001ii
	( 
	.data({rclkcmpsq1n[5], rclkcmpsq1n[15], rclkcmpsq1p[15], rclkcmpsq1p[5]}),
	.o(wire_n001ii_o),
	.sel({nliO11l, nliO11i, wire_n001Ol_o[3], wire_n001Ol_o[1]}));
	defparam
		n001ii.width_data = 4,
		n001ii.width_sel = 4;
	oper_selector   n001il
	( 
	.data({rclkcmpsq1n[6], rclkcmpsq1n[16], rclkcmpsq1p[16], rclkcmpsq1p[6]}),
	.o(wire_n001il_o),
	.sel({nliO11l, nliO11i, wire_n001Ol_o[3], wire_n001Ol_o[1]}));
	defparam
		n001il.width_data = 4,
		n001il.width_sel = 4;
	oper_selector   n001iO
	( 
	.data({rclkcmpsq1n[7], rclkcmpsq1n[17], rclkcmpsq1p[17], rclkcmpsq1p[7]}),
	.o(wire_n001iO_o),
	.sel({nliO11l, nliO11i, wire_n001Ol_o[3], wire_n001Ol_o[1]}));
	defparam
		n001iO.width_data = 4,
		n001iO.width_sel = 4;
	oper_selector   n001li
	( 
	.data({rclkcmpsq1n[8], rclkcmpsq1n[18], rclkcmpsq1p[18], rclkcmpsq1p[8]}),
	.o(wire_n001li_o),
	.sel({nliO11l, nliO11i, wire_n001Ol_o[3], wire_n001Ol_o[1]}));
	defparam
		n001li.width_data = 4,
		n001li.width_sel = 4;
	oper_selector   n001ll
	( 
	.data({rclkcmpsq1n[9], rclkcmpsq1n[19], rclkcmpsq1p[19], rclkcmpsq1p[9]}),
	.o(wire_n001ll_o),
	.sel({nliO11l, nliO11i, wire_n001Ol_o[3], wire_n001Ol_o[1]}));
	defparam
		n001ll.width_data = 4,
		n001ll.width_sel = 4;
	oper_selector   nlOill
	( 
	.data({wire_nlOlii_dataout, wire_nlOl0i_dataout, (nll111i50 & nlOili)}),
	.o(wire_nlOill_o),
	.sel({wire_nlOl1i_o[3:2], nll110i}));
	defparam
		nlOill.width_data = 3,
		nlOill.width_sel = 3;
	oper_selector   nlOilO
	( 
	.data({wire_nlOlil_dataout, wire_nlOl1O_dataout, nlOlOO}),
	.o(wire_nlOilO_o),
	.sel({(nll111l47 & wire_nlOl1i_o[3]), (nll111O44 & wire_nlOl1i_o[2]), nll110i}));
	defparam
		nlOilO.width_data = 3,
		nlOilO.width_sel = 3;
	oper_selector   nlOiOl
	( 
	.data({wire_nlOliO_dataout, wire_nlOl1l_dataout, wire_nlili_dataout, (wire_nlili_dataout & wire_nlill_dataout)}),
	.o(wire_nlOiOl_o),
	.sel({(nll110l41 & wire_nlOl1i_o[3]), wire_nlOl1i_o[2:0]}));
	defparam
		nlOiOl.width_data = 4,
		nlOiOl.width_sel = 4;
	oper_selector   nlOiOO
	( 
	.data({{2{wire_nlili_dataout}}, wire_nlOlOi_dataout, 1'b0}),
	.o(wire_nlOiOO_o),
	.sel({(nll110O38 & wire_nlOl1i_o[3]), (nll11ii35 & wire_nlOl1i_o[2]), wire_nlOl1i_o[1:0]}));
	defparam
		nlOiOO.width_data = 4,
		nlOiOO.width_sel = 4;
	ram20x16_syn   nlOiii
	( 
	.clk(clk_1),
	.data_in({wire_nl0il_dataout, wire_nl0ii_dataout, wire_nl00O_dataout, wire_nl00l_dataout, wire_nl00i_dataout, wire_nl01O_dataout, wire_nl01l_dataout, wire_nl01i_dataout, wire_nl1OO_dataout, wire_nl1Ol_dataout, wire_nl1Oi_dataout, wire_nl1lO_dataout, wire_nl1ll_dataout, wire_nl1li_dataout, wire_nl1iO_dataout, wire_nl1il_dataout}),
	.data_out1(wire_nlOiii_data_out1),
	.data_out2(wire_nlOiii_data_out2),
	.fifo_re1({wire_n0ll_dataout, wire_n0li_dataout, wire_n0iO_dataout, wire_n0il_dataout, wire_n0ii_dataout, wire_n00O_dataout, wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout, wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout, wire_n1ll_dataout, wire_n1li_dataout, wire_n1iO_dataout, wire_n1il_dataout, wire_n1ii_dataout}),
	.fifo_re2({wire_n10O_dataout, wire_n10l_dataout, wire_n10i_dataout, wire_n11O_dataout, wire_n11l_dataout, wire_n11i_dataout, wire_nlOOO_dataout, wire_nlOOl_dataout, wire_nlOOi_dataout, wire_nlOlO_dataout, wire_nlOll_dataout, wire_nlOli_dataout, wire_nlOiO_dataout, wire_nlOil_dataout, wire_nlOii_dataout, wire_nlO0O_dataout, wire_nlO0l_dataout, wire_nlO0i_dataout, wire_nlO1O_dataout, wire_nlO1l_dataout}),
	.fifo_wr({wire_nlO1i_dataout, wire_nllOO_dataout, wire_nllOl_dataout, wire_nllOi_dataout, wire_nlllO_dataout, wire_nllll_dataout, wire_nllli_dataout, wire_nlliO_dataout, wire_nllil_dataout, wire_nllii_dataout, wire_nll0O_dataout, wire_nll0l_dataout, wire_nll0i_dataout, wire_nll1O_dataout, wire_nll1l_dataout, wire_nll1i_dataout, wire_nliOO_dataout, wire_nliOl_dataout, wire_nliOi_dataout, wire_nlilO_dataout}),
	.rst_l((~ wire_nil_dataout)));
	defparam
		nlOiii.ram_width = 16,
		nlOiii.read_access_time = 0,
		nlOiii.write_access_time = 0;
	ram20x16_syn   nlOiil
	( 
	.clk(clk_1),
	.data_in({wire_nliiO_dataout, wire_nliil_dataout, wire_nliii_dataout, wire_nli0O_dataout, wire_nli0l_dataout, wire_nli0i_dataout, wire_nli1O_dataout, wire_nli1l_dataout, wire_nli1i_dataout, wire_nl0OO_dataout, wire_nl0Ol_dataout, wire_nl0Oi_dataout, wire_nl0lO_dataout, wire_nl0ll_dataout, wire_nl0li_dataout, wire_nl0iO_dataout}),
	.data_out1(wire_nlOiil_data_out1),
	.data_out2(wire_nlOiil_data_out2),
	.fifo_re1({wire_n0ll_dataout, wire_n0li_dataout, wire_n0iO_dataout, wire_n0il_dataout, wire_n0ii_dataout, wire_n00O_dataout, wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout, wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout, wire_n1ll_dataout, wire_n1li_dataout, wire_n1iO_dataout, wire_n1il_dataout, wire_n1ii_dataout}),
	.fifo_re2({wire_n10O_dataout, wire_n10l_dataout, wire_n10i_dataout, wire_n11O_dataout, wire_n11l_dataout, wire_n11i_dataout, wire_nlOOO_dataout, wire_nlOOl_dataout, wire_nlOOi_dataout, wire_nlOlO_dataout, wire_nlOll_dataout, wire_nlOli_dataout, wire_nlOiO_dataout, wire_nlOil_dataout, wire_nlOii_dataout, wire_nlO0O_dataout, wire_nlO0l_dataout, wire_nlO0i_dataout, wire_nlO1O_dataout, wire_nlO1l_dataout}),
	.fifo_wr({wire_nlO1i_dataout, wire_nllOO_dataout, wire_nllOl_dataout, wire_nllOi_dataout, wire_nlllO_dataout, wire_nllll_dataout, wire_nllli_dataout, wire_nlliO_dataout, wire_nllil_dataout, wire_nllii_dataout, wire_nll0O_dataout, wire_nll0l_dataout, wire_nll0i_dataout, wire_nll1O_dataout, wire_nll1l_dataout, wire_nll1i_dataout, wire_nliOO_dataout, wire_nliOl_dataout, wire_nliOi_dataout, wire_nlilO_dataout}),
	.rst_l((~ wire_nil_dataout)));
	defparam
		nlOiil.ram_width = 16,
		nlOiil.read_access_time = 0,
		nlOiil.write_access_time = 0;
	assign
		align_status_sync = n1001O,
		comp_curr_st = {nlOiiO, nlOO1l},
		cudi = {wire_n1l_dataout, wire_n1i_dataout, wire_nlOO_dataout, wire_nlOl_dataout, wire_nlOi_dataout, wire_nllO_dataout, wire_nlll_dataout, wire_nlli_dataout, wire_nliO_dataout, wire_nlil_dataout, wire_nlii_dataout, wire_nl0O_dataout, wire_nl0l_dataout, wire_nl0i_dataout, wire_nl1O_dataout, wire_nl1l_dataout, wire_nl1i_dataout, wire_niOO_dataout, wire_niOl_dataout, wire_niOi_dataout, wire_nilO_dataout, wire_nill_dataout, wire_nili_dataout, wire_niiO_dataout, wire_niil_dataout, wire_niii_dataout, wire_ni0O_dataout, wire_ni0l_dataout, wire_ni0i_dataout, wire_ni1O_dataout, wire_ni1l_dataout, wire_ni1i_dataout},
		cudi_valid = wire_niO1l_dataout,
		disable_fifo_rd = nll11ll,
		disable_fifo_wr = nll11li,
		fifo_cnt = {wire_nii_dataout, wire_n0O_dataout, wire_n0l_dataout, wire_n0i_dataout, wire_n1O_dataout},
		fifo_rd_out_comp = n100iO,
		nliiOll = (n11OlO ^ n11Oli),
		nliiOlO = (nlOli1i ^ nlOl0Ol),
		nliiOOi = (rgenericfifo & (~ n101Ol)),
		nliiOOl = (n101Ol | ((~ rgenericfifo) & (~ wire_n111il_dataout))),
		nliiOOO = (((((((((wire_nlOl1ll_o[17] | wire_nlOl1ll_o[16]) | wire_nlOl1ll_o[13]) | wire_nlOl1ll_o[12]) | wire_nlOl1ll_o[9]) | wire_nlOl1ll_o[8]) | wire_nlOl1ll_o[5]) | wire_nlOl1ll_o[4]) | wire_nlOl1ll_o[1]) | wire_nlOl1ll_o[0]),
		nlil00i = (((((((wire_n11Oii_o[13] | wire_n11Oii_o[12]) | wire_n11Oii_o[11]) | wire_n11Oii_o[10]) | wire_n11Oii_o[5]) | wire_n11Oii_o[4]) | wire_n11Oii_o[3]) | wire_n11Oii_o[2]),
		nlil00l = (((((((wire_n11Oii_o[11] | wire_n11Oii_o[10]) | wire_n11Oii_o[9]) | wire_n11Oii_o[8]) | wire_n11Oii_o[7]) | wire_n11Oii_o[6]) | wire_n11Oii_o[5]) | wire_n11Oii_o[4]),
		nlil00O = (((((((((wire_n11Oii_o[17] | wire_n11Oii_o[16]) | wire_n11Oii_o[15]) | wire_n11Oii_o[14]) | wire_n11Oii_o[13]) | wire_n11Oii_o[12]) | wire_n11Oii_o[11]) | wire_n11Oii_o[10]) | wire_n11Oii_o[9]) | wire_n11Oii_o[8]),
		nlil01i = (n11OOi ^ (n11Oll ^ nliiOll)),
		nlil01l = (n11OOi ^ (nliiOll ^ (n11Oll ^ n11OiO))),
		nlil01O = (((((((((wire_n11Oii_o[18] | wire_n11Oii_o[17]) | wire_n11Oii_o[14]) | wire_n11Oii_o[13]) | wire_n11Oii_o[10]) | wire_n11Oii_o[9]) | wire_n11Oii_o[6]) | wire_n11Oii_o[5]) | wire_n11Oii_o[2]) | wire_n11Oii_o[1]),
		nlil0ii = (rgenericfifo & n101Ol),
		nlil0il = (((((~ n1ilil) & (~ n1i1lO)) & n1i1ll) & n1i1li) & n1i1iO),
		nlil0iO = (n10lll | n10iOO),
		nlil0li = ((((((((~ n1l10i) & (~ n1ilOO)) & (~ n1ilOl)) & (~ n1ilOi)) & (~ n1illO)) & (~ n1illl)) & (~ n1illi)) & (~ n1iliO)),
		nlil0ll = (n10lOO | nlill0l),
		nlil0lO = ((((n1ilil & (~ n1i1lO)) & (~ n1i1ll)) & n1i1li) & n1i1iO),
		nlil0Oi = (((((~ wire_n1i0iO_dataout) & (~ wire_n1i0li_dataout)) & (~ wire_n1i0ll_dataout)) & (~ wire_n1i0lO_dataout)) & (~ wire_n1i0Oi_dataout)),
		nlil0Ol = (nllllli | wire_n1i11i_dataout),
		nlil0OO = (n10O1l | wire_n1i10i_dataout),
		nlil10i = ((((nlO001O & (~ nlO001l)) & (~ nlO001i)) & nlO01OO) & nlO01Ol),
		nlil10l = (nlil0ii | ((~ rgenericfifo) & ((~ wire_n111il_dataout) & wire_n10iil_dataout))),
		nlil10O = (((((~ nlOl0lO) & (~ nlOl0ll)) & (~ nlOl0li)) & (~ nlOl0iO)) & (~ nlOl0il)),
		nlil11i = (((((((wire_nlOl1ll_o[12] | wire_nlOl1ll_o[11]) | wire_nlOl1ll_o[10]) | wire_nlOl1ll_o[9]) | wire_nlOl1ll_o[4]) | wire_nlOl1ll_o[3]) | wire_nlOl1ll_o[2]) | wire_nlOl1ll_o[1]),
		nlil11l = (((((((wire_nlOl1ll_o[10] | wire_nlOl1ll_o[9]) | wire_nlOl1ll_o[8]) | wire_nlOl1ll_o[7]) | wire_nlOl1ll_o[6]) | wire_nlOl1ll_o[5]) | wire_nlOl1ll_o[4]) | wire_nlOl1ll_o[3]),
		nlil11O = (((((((((wire_nlOl1ll_o[16] | wire_nlOl1ll_o[15]) | wire_nlOl1ll_o[14]) | wire_nlOl1ll_o[13]) | wire_nlOl1ll_o[12]) | wire_nlOl1ll_o[11]) | wire_nlOl1ll_o[10]) | wire_nlOl1ll_o[9]) | wire_nlOl1ll_o[8]) | wire_nlOl1ll_o[7]),
		nlil1ii = ((~ rgenericfifo) & nliliOi),
		nlil1il = ((((nlOl0lO & (~ nlOl0ll)) & (~ nlOl0li)) & nlOl0iO) & nlOl0il),
		nlil1iO = ((((((((((~ (rclkcmpsq1n[0] ^ nllllOl)) & (~ (rclkcmpsq1n[1] ^ nlllO1i))) & (~ (rclkcmpsq1n[2] ^ nlllO1O))) & (~ (rclkcmpsq1n[3] ^ nlllO0l))) & (~ (rclkcmpsq1n[4] ^ nlllOii))) & (~ (rclkcmpsq1n[5] ^ nlllOiO))) & (~ (rclkcmpsq1n[6] ^ nlllOll))) & (~ (rclkcmpsq1n[7] ^ nlllOOi))) & (~ (rclkcmpsq1n[8] ^ nlllOOO))) & (~ (rclkcmpsq1n[9] ^ nllO11l))),
		nlil1li = ((((((((((~ (rclkcmpsq1p[0] ^ nllllOl)) & (~ (rclkcmpsq1p[1] ^ nlllO1i))) & (~ (rclkcmpsq1p[2] ^ nlllO1O))) & (~ (rclkcmpsq1p[3] ^ nlllO0l))) & (~ (rclkcmpsq1p[4] ^ nlllOii))) & (~ (rclkcmpsq1p[5] ^ nlllOiO))) & (~ (rclkcmpsq1p[6] ^ nlllOll))) & (~ (rclkcmpsq1p[7] ^ nlllOOi))) & (~ (rclkcmpsq1p[8] ^ nlllOOO))) & (~ (rclkcmpsq1p[9] ^ nllO11l))),
		nlil1ll = (rskpsetbased & n10lll),
		nlil1lO = (((~ rclkcmpsqmd) & (~ nlilO0l)) & (rtruebac2bac | ((~ rtruebac2bac) & (~ n1O11l)))),
		nlil1Oi = (((((~ n11OOi) & nlil1Ol) & (~ nlil1OO)) & nlil01i) & (~ nlil01l)),
		nlil1Ol = ((~ n11OOi) & n11OlO),
		nlil1OO = ((~ n11OOi) & (n11OlO ^ n11Oll)),
		nlili0i = ((~ nlOli1l) & (nlOli1i ^ nlOl0OO)),
		nlili0l = (nlOli1l ^ (nlOl0OO ^ nliiOlO)),
		nlili0O = (nlOli1l ^ (nliiOlO ^ (nlOl0OO ^ nlOl0Oi))),
		nlili1i = (nlili1l & wire_n1ii1O_dataout),
		nlili1l = (nlil0Oi & nlil0lO),
		nlili1O = ((~ nlOli1l) & nlOli1i),
		nliliii = (((nlOili & ((rskpsetbased & (rtruebac2bac & (n1Oiil | (n1Oiii | (n1Oi0O | n1Oi0l))))) | ((~ rrx_pipe_enable) & (rskpsetbased & ((~ rtruebac2bac) & n1Oiil))))) & wire_n1ilii_o) | ((wire_n1ilii_o & (nlOili & nlillOi)) & (~ (rskpsetbased & (~ rrx_pipe_enable))))),
		nliliil = ((~ rgenericfifo) & (~ wire_n0110i_dataout)),
		nliliiO = (rgenericfifo | wire_n0110i_dataout),
		nlilili = (((((~ n1lO0i) & (~ n1l1iO)) & (~ n1l1il)) & (~ n1l1ii)) & (~ n1l10O)),
		nlilill = (nlill1l & ((~ rclkcmpsqmd) & (((~ rgenericfifo) & wire_n1ii1O_dataout) | (rgenericfifo & (~ n1110O))))),
		nlililO = (nlill1l & nliliOi),
		nliliOi = (rclkcmpsqmd & wire_n1ii1O_dataout),
		nliliOl = (nlill1l & (rclkcmpsqmd & (wire_n1ii1O_dataout & (nll10il | n1l10l)))),
		nliliOO = ((((n1lO0i | n1l1iO) | n1l1il) | n1l1ii) | n1l10O),
		nlill0i = (nlill0l & (rskpsetbased | ((~ rskpsetbased) & (~ wire_n1ii1O_dataout)))),
		nlill0l = (nlili1l & (~ nliliii)),
		nlill0O = (wire_n11i1l_o & (wire_n01OOi_dataout & (~ (((~ n1O10O) & (~ n1O10l)) & (~ n1O10i))))),
		nlill1i = (((~ rgenericfifo) & (~ wire_n1ii1O_dataout)) | (rgenericfifo & n1110O)),
		nlill1l = ((~ rskpsetbased) | (~ nlill0l)),
		nlill1O = ((~ rgenericfifo) & (~ wire_n011lO_dataout)),
		nlillii = (wire_n11i1l_o & nlillil),
		nlillil = (wire_n11i1l_o & ((~ wire_n01OOi_dataout) & ((n100ii & ((~ rrx_pipe_enable) & nlil1lO)) & wire_n11i0l_o))),
		nlilliO = (wire_n01OOi_dataout & wire_n01O0l_dataout),
		nlillli = ((((((((((~ (rclkcmpsq1n[0] ^ wire_n1OO1O_dataout)) & (~ (rclkcmpsq1n[1] ^ wire_n1OO0i_dataout))) & (~ (rclkcmpsq1n[2] ^ wire_n1OO0l_dataout))) & (~ (rclkcmpsq1n[3] ^ wire_n1OO0O_dataout))) & (~ (rclkcmpsq1n[4] ^ wire_n1OOii_dataout))) & (~ (rclkcmpsq1n[5] ^ wire_n1OOil_dataout))) & (~ (rclkcmpsq1n[6] ^ wire_n1OOiO_dataout))) & (~ (rclkcmpsq1n[7] ^ wire_n1OOli_dataout))) & (~ (rclkcmpsq1n[8] ^ wire_n1OOll_dataout))) & (~ (rclkcmpsq1n[9] ^ wire_n1OOlO_dataout))),
		nlillll = ((((((((((~ (rclkcmpsq1p[0] ^ wire_n1OO1O_dataout)) & (~ (rclkcmpsq1p[1] ^ wire_n1OO0i_dataout))) & (~ (rclkcmpsq1p[2] ^ wire_n1OO0l_dataout))) & (~ (rclkcmpsq1p[3] ^ wire_n1OO0O_dataout))) & (~ (rclkcmpsq1p[4] ^ wire_n1OOii_dataout))) & (~ (rclkcmpsq1p[5] ^ wire_n1OOil_dataout))) & (~ (rclkcmpsq1p[6] ^ wire_n1OOiO_dataout))) & (~ (rclkcmpsq1p[7] ^ wire_n1OOli_dataout))) & (~ (rclkcmpsq1p[8] ^ wire_n1OOll_dataout))) & (~ (rclkcmpsq1p[9] ^ wire_n1OOlO_dataout))),
		nlilllO = (nll100l & ((~ rclkcmpsqmd) | n1Oi0i)),
		nlillOi = ((nlllllO & (~ wire_n1OOOO_dataout)) & (~ wire_n0111i_dataout)),
		nlillOl = (nlilO1i & dskwclksel[0]),
		nlillOO = (nlilO1i & (~ dskwclksel[0])),
		nlilO0i = (rmatchen | rgenericfifo),
		nlilO0l = (wire_n11l1i_o | (n1O11l & nlil1Oi)),
		nlilO0O = ((((((((((~ (rclkcmpsq1n[0] ^ nllOi1l)) & (~ (rclkcmpsq1n[1] ^ nllOi0i))) & (~ (rclkcmpsq1n[2] ^ nllOi0O))) & (~ (rclkcmpsq1n[3] ^ nllOiil))) & (~ (rclkcmpsq1n[4] ^ nllOili))) & (~ (rclkcmpsq1n[5] ^ nllOilO))) & (~ (rclkcmpsq1n[6] ^ nllOiOl))) & (~ (rclkcmpsq1n[7] ^ nllOl1i))) & (~ (rclkcmpsq1n[8] ^ nllOl1O))) & (~ (rclkcmpsq1n[9] ^ nllOl0l))),
		nlilO1i = (nll1i1i & (~ is_lane0)),
		nlilO1l = ((~ rmatchen) | rgenericfifo),
		nlilO1O = (n100ii & ((~ nlilO0l) & (wire_n01OOi_dataout & (wire_n01O0l_dataout & (rrx_pipe_enable & nlilO0i))))),
		nlilOii = ((((((((((~ (rclkcmpsq1p[0] ^ nllOi1l)) & (~ (rclkcmpsq1p[1] ^ nllOi0i))) & (~ (rclkcmpsq1p[2] ^ nllOi0O))) & (~ (rclkcmpsq1p[3] ^ nllOiil))) & (~ (rclkcmpsq1p[4] ^ nllOili))) & (~ (rclkcmpsq1p[5] ^ nllOilO))) & (~ (rclkcmpsq1p[6] ^ nllOiOl))) & (~ (rclkcmpsq1p[7] ^ nllOl1i))) & (~ (rclkcmpsq1p[8] ^ nllOl1O))) & (~ (rclkcmpsq1p[9] ^ nllOl0l))),
		nlilOil = ((((((((((~ (nllO1il ^ rclkcmpsq1n[0])) & (~ (nllO1li ^ rclkcmpsq1n[1]))) & (~ (nllO1lO ^ rclkcmpsq1n[2]))) & (~ (nllO1Ol ^ rclkcmpsq1n[3]))) & (~ (nllO01i ^ rclkcmpsq1n[4]))) & (~ (nllO01O ^ rclkcmpsq1n[5]))) & (~ (nllO00l ^ rclkcmpsq1n[6]))) & (~ (nllO0ii ^ rclkcmpsq1n[7]))) & (~ (nllO0iO ^ rclkcmpsq1n[8]))) & (~ (nllO0ll ^ rclkcmpsq1n[9]))),
		nlilOiO = ((((((((((~ (nllO1il ^ rclkcmpsq1p[0])) & (~ (nllO1li ^ rclkcmpsq1p[1]))) & (~ (nllO1lO ^ rclkcmpsq1p[2]))) & (~ (nllO1Ol ^ rclkcmpsq1p[3]))) & (~ (nllO01i ^ rclkcmpsq1p[4]))) & (~ (nllO01O ^ rclkcmpsq1p[5]))) & (~ (nllO00l ^ rclkcmpsq1p[6]))) & (~ (nllO0ii ^ rclkcmpsq1p[7]))) & (~ (nllO0iO ^ rclkcmpsq1p[8]))) & (~ (nllO0ll ^ rclkcmpsq1p[9]))),
		nlilOli = ((((((((((~ (wire_n0011l_o ^ nllOi1l)) & (~ (wire_n0011O_o ^ nllOi0i))) & (~ (wire_n0010i_o ^ nllOi0O))) & (~ (wire_n0010l_o ^ nllOiil))) & (~ (wire_n0010O_o ^ nllOili))) & (~ (wire_n001ii_o ^ nllOilO))) & (~ (wire_n001il_o ^ nllOiOl))) & (~ (wire_n001iO_o ^ nllOl1i))) & (~ (wire_n001li_o ^ nllOl1O))) & (~ (wire_n001ll_o ^ nllOl0l))),
		nlilOll = ((((((((((~ (wire_n001OO_dataout ^ nllOi1l)) & (~ (wire_n0001i_dataout ^ nllOi0i))) & (~ (wire_n0001l_dataout ^ nllOi0O))) & (~ (wire_n0001O_dataout ^ nllOiil))) & (~ (wire_n0000i_dataout ^ nllOili))) & (~ (wire_n0000l_dataout ^ nllOilO))) & (~ (wire_n0000O_dataout ^ nllOiOl))) & (~ (wire_n000ii_dataout ^ nllOl1i))) & (~ (wire_n000il_dataout ^ nllOl1O))) & (~ (wire_n000iO_dataout ^ nllOl0l))),
		nlilOlO = ((((((((((~ (nllO1il ^ wire_n0011l_o)) & (~ (nllO1li ^ wire_n0011O_o))) & (~ (nllO1lO ^ wire_n0010i_o))) & (~ (nllO1Ol ^ wire_n0010l_o))) & (~ (nllO01i ^ wire_n0010O_o))) & (~ (nllO01O ^ wire_n001ii_o))) & (~ (nllO00l ^ wire_n001il_o))) & (~ (nllO0ii ^ wire_n001iO_o))) & (~ (nllO0iO ^ wire_n001li_o))) & (~ (nllO0ll ^ wire_n001ll_o))),
		nlilOOi = ((((((((((~ (nllO1il ^ wire_n001OO_dataout)) & (~ (nllO1li ^ wire_n0001i_dataout))) & (~ (nllO1lO ^ wire_n0001l_dataout))) & (~ (nllO1Ol ^ wire_n0001O_dataout))) & (~ (nllO01i ^ wire_n0000i_dataout))) & (~ (nllO01O ^ wire_n0000l_dataout))) & (~ (nllO00l ^ wire_n0000O_dataout))) & (~ (nllO0ii ^ wire_n000ii_dataout))) & (~ (nllO0iO ^ wire_n000il_dataout))) & (~ (nllO0ll ^ wire_n000iO_dataout))),
		nlilOOl = ((((((((((~ (wire_n0011l_o ^ wire_n1OO1O_dataout)) & (~ (wire_n0011O_o ^ wire_n1OO0i_dataout))) & (~ (wire_n0010i_o ^ wire_n1OO0l_dataout))) & (~ (wire_n0010l_o ^ wire_n1OO0O_dataout))) & (~ (wire_n0010O_o ^ wire_n1OOii_dataout))) & (~ (wire_n001ii_o ^ wire_n1OOil_dataout))) & (~ (wire_n001il_o ^ wire_n1OOiO_dataout))) & (~ (wire_n001iO_o ^ wire_n1OOli_dataout))) & (~ (wire_n001li_o ^ wire_n1OOll_dataout))) & (~ (wire_n001ll_o ^ wire_n1OOlO_dataout))),
		nlilOOO = ((((((((((~ (wire_n001OO_dataout ^ wire_n1OO1O_dataout)) & (~ (wire_n0001i_dataout ^ wire_n1OO0i_dataout))) & (~ (wire_n0001l_dataout ^ wire_n1OO0l_dataout))) & (~ (wire_n0001O_dataout ^ wire_n1OO0O_dataout))) & (~ (wire_n0000i_dataout ^ wire_n1OOii_dataout))) & (~ (wire_n0000l_dataout ^ wire_n1OOil_dataout))) & (~ (wire_n0000O_dataout ^ wire_n1OOiO_dataout))) & (~ (wire_n000ii_dataout ^ wire_n1OOli_dataout))) & (~ (wire_n000il_dataout ^ wire_n1OOll_dataout))) & (~ (wire_n000iO_dataout ^ wire_n1OOlO_dataout))),
		nliO00i = (nl1OOO ^ (nliO10i ^ (nl1OOi ^ nl1Oll))),
		nliO00l = (((((((((wire_nl1OiO_o[18] | wire_nl1OiO_o[17]) | wire_nl1OiO_o[14]) | wire_nl1OiO_o[13]) | wire_nl1OiO_o[10]) | wire_nl1OiO_o[9]) | wire_nl1OiO_o[6]) | wire_nl1OiO_o[5]) | wire_nl1OiO_o[2]) | wire_nl1OiO_o[1]),
		nliO00O = (((((((wire_nl1OiO_o[13] | wire_nl1OiO_o[12]) | wire_nl1OiO_o[11]) | wire_nl1OiO_o[10]) | wire_nl1OiO_o[5]) | wire_nl1OiO_o[4]) | wire_nl1OiO_o[3]) | wire_nl1OiO_o[2]),
		nliO01i = ((~ nl1OOO) & nl1OOl),
		nliO01l = ((~ nl1OOO) & (nl1OOl ^ nl1OOi)),
		nliO01O = (nl1OOO ^ (nl1OOi ^ nliO10i)),
		nliO0ii = (((((((wire_nl1OiO_o[11] | wire_nl1OiO_o[10]) | wire_nl1OiO_o[9]) | wire_nl1OiO_o[8]) | wire_nl1OiO_o[7]) | wire_nl1OiO_o[6]) | wire_nl1OiO_o[5]) | wire_nl1OiO_o[4]),
		nliO0il = (((((((((wire_nl1OiO_o[17] | wire_nl1OiO_o[16]) | wire_nl1OiO_o[15]) | wire_nl1OiO_o[14]) | wire_nl1OiO_o[13]) | wire_nl1OiO_o[12]) | wire_nl1OiO_o[11]) | wire_nl1OiO_o[10]) | wire_nl1OiO_o[9]) | wire_nl1OiO_o[8]),
		nliO0iO = (rgenericfifo & nl001i),
		nliO0li = (((((~ nlii0O) & (~ nli1ii)) & nli10O) & nli10l) & nli10i),
		nliO0ll = (nl0l0O | nl0ilO),
		nliO0lO = ((~ rgenericfifo) & (~ wire_nlli0O_dataout)),
		nliO0Oi = (nl0lli | nliOl1l),
		nliO0Ol = ((((nlii0O & (~ nli1ii)) & (~ nli10O)) & nli10l) & nli10i),
		nliO0OO = (((((~ wire_nli00i_dataout) & (~ wire_nli00l_dataout)) & (~ wire_nli00O_dataout)) & (~ wire_nli0ii_dataout)) & (~ wire_nli0il_dataout)),
		nliO10i = (nl1OOl ^ nl1OlO),
		nliO10l = (niO0iO ^ niO0ii),
		nliO10O = (rgenericfifo & (~ nl001i)),
		nliO11i = (wire_n001Ol_o[4] | wire_n001Ol_o[2]),
		nliO11l = (((wire_n001Ol_o[7] | wire_n001Ol_o[6]) | wire_n001Ol_o[5]) | wire_n001Ol_o[0]),
		nliO11O = (rskpsetbased | rclkcmpsqmd),
		nliO1ii = (nl001i | ((~ rgenericfifo) & (~ nliOl0l))),
		nliO1il = (((((((((wire_niO11O_o[17] | wire_niO11O_o[16]) | wire_niO11O_o[13]) | wire_niO11O_o[12]) | wire_niO11O_o[9]) | wire_niO11O_o[8]) | wire_niO11O_o[5]) | wire_niO11O_o[4]) | wire_niO11O_o[1]) | wire_niO11O_o[0]),
		nliO1iO = (((((((wire_niO11O_o[12] | wire_niO11O_o[11]) | wire_niO11O_o[10]) | wire_niO11O_o[9]) | wire_niO11O_o[4]) | wire_niO11O_o[3]) | wire_niO11O_o[2]) | wire_niO11O_o[1]),
		nliO1li = (((((((wire_niO11O_o[10] | wire_niO11O_o[9]) | wire_niO11O_o[8]) | wire_niO11O_o[7]) | wire_niO11O_o[6]) | wire_niO11O_o[5]) | wire_niO11O_o[4]) | wire_niO11O_o[3]),
		nliO1ll = (((((((((wire_niO11O_o[16] | wire_niO11O_o[15]) | wire_niO11O_o[14]) | wire_niO11O_o[13]) | wire_niO11O_o[12]) | wire_niO11O_o[11]) | wire_niO11O_o[10]) | wire_niO11O_o[9]) | wire_niO11O_o[8]) | wire_niO11O_o[7]),
		nliO1lO = ((((nii1li & (~ nii1iO)) & (~ nii1il)) & nii1ii) & nii10O),
		nliO1Oi = (nliO0iO | ((~ rgenericfifo) & (nl00iO & (~ nliOl0l)))),
		nliO1Ol = ((((niO00l & (~ niO00i)) & (~ niO01O)) & niO01l) & niO01i),
		nliO1OO = (((((~ nl1OOO) & nliO01i) & (~ nliO01l)) & nliO01O) & (~ nliO00i)),
		nliOi0i = (nliO0OO & nliO0Ol),
		nliOi0l = ((~ niO0li) & niO0iO),
		nliOi0O = ((~ niO0li) & (niO0iO ^ niO0il)),
		nliOi1i = (n0Ol1l | wire_nl0Oll_dataout),
		nliOi1l = (nl0llO | wire_nl0OOl_dataout),
		nliOi1O = (nliOi0i & nliOiOO),
		nliOiii = (niO0li ^ (niO0il ^ nliO10l)),
		nliOiil = (niO0li ^ (nliO10l ^ (niO0il ^ niO00O))),
		nliOiiO = ((nlOili & (nlO1ii | nll01l)) & wire_nlii1l_o),
		nliOili = (rgenericfifo | wire_nlli0O_dataout),
		nliOill = (((((~ nliOil) & (~ nliili)) & (~ nliiiO)) & (~ nliiil)) & (~ nliiii)),
		nliOilO = ((~ nliOl1l) & (((~ rgenericfifo) & nliOiOO) | (rgenericfifo & (~ nl1ill)))),
		nliOiOi = ((((nliOil | nliili) | nliiiO) | nliiil) | nliiii),
		nliOiOl = (((~ rgenericfifo) & (~ nliOiOO)) | (rgenericfifo & nl1ill)),
		nliOiOO = (nliOiiO | nliOl1l),
		nliOl0i = ((((((((((~ (wire_nlOiil_data_out2[0] ^ rclkcmpsq1p[0])) & (~ (wire_nlOiil_data_out2[1] ^ rclkcmpsq1p[1]))) & (~ (wire_nlOiil_data_out2[2] ^ rclkcmpsq1p[2]))) & (~ (wire_nlOiil_data_out2[3] ^ rclkcmpsq1p[3]))) & (~ (wire_nlOiil_data_out2[4] ^ rclkcmpsq1p[4]))) & (~ (wire_nlOiil_data_out2[5] ^ rclkcmpsq1p[5]))) & (~ (wire_nlOiil_data_out2[6] ^ rclkcmpsq1p[6]))) & (~ (wire_nlOiil_data_out2[7] ^ rclkcmpsq1p[7]))) & (~ (wire_nlOiil_data_out2[8] ^ rclkcmpsq1p[8]))) & (~ (wire_nlOiil_data_out2[9] ^ rclkcmpsq1p[9]))),
		nliOl0l = (nl0l0O | (nll1ll & (nl00ii & (~ nliOllO)))),
		nliOl0O = ((((((((((~ (wire_nlOiii_data_out2[0] ^ rclkcmpsq1n[10])) & (~ (wire_nlOiii_data_out2[1] ^ rclkcmpsq1n[11]))) & (~ (wire_nlOiii_data_out2[2] ^ rclkcmpsq1n[12]))) & (~ (wire_nlOiii_data_out2[3] ^ rclkcmpsq1n[13]))) & (~ (wire_nlOiii_data_out2[4] ^ rclkcmpsq1n[14]))) & (~ (wire_nlOiii_data_out2[5] ^ rclkcmpsq1n[15]))) & (~ (wire_nlOiii_data_out2[6] ^ rclkcmpsq1n[16]))) & (~ (wire_nlOiii_data_out2[7] ^ rclkcmpsq1n[17]))) & (~ (wire_nlOiii_data_out2[8] ^ rclkcmpsq1n[18]))) & (~ (wire_nlOiii_data_out2[9] ^ rclkcmpsq1n[19]))),
		nliOl1i = ((~ rgenericfifo) & (~ wire_nlliii_dataout)),
		nliOl1l = (nliOi0i & (~ nliOiiO)),
		nliOl1O = ((((((((((~ (wire_nlOiil_data_out2[0] ^ rclkcmpsq1n[0])) & (~ (wire_nlOiil_data_out2[1] ^ rclkcmpsq1n[1]))) & (~ (wire_nlOiil_data_out2[2] ^ rclkcmpsq1n[2]))) & (~ (wire_nlOiil_data_out2[3] ^ rclkcmpsq1n[3]))) & (~ (wire_nlOiil_data_out2[4] ^ rclkcmpsq1n[4]))) & (~ (wire_nlOiil_data_out2[5] ^ rclkcmpsq1n[5]))) & (~ (wire_nlOiil_data_out2[6] ^ rclkcmpsq1n[6]))) & (~ (wire_nlOiil_data_out2[7] ^ rclkcmpsq1n[7]))) & (~ (wire_nlOiil_data_out2[8] ^ rclkcmpsq1n[8]))) & (~ (wire_nlOiil_data_out2[9] ^ rclkcmpsq1n[9]))),
		nliOlii = ((((((((((~ (wire_nlOiii_data_out2[0] ^ rclkcmpsq1p[10])) & (~ (wire_nlOiii_data_out2[1] ^ rclkcmpsq1p[11]))) & (~ (wire_nlOiii_data_out2[2] ^ rclkcmpsq1p[12]))) & (~ (wire_nlOiii_data_out2[3] ^ rclkcmpsq1p[13]))) & (~ (wire_nlOiii_data_out2[4] ^ rclkcmpsq1p[14]))) & (~ (wire_nlOiii_data_out2[5] ^ rclkcmpsq1p[15]))) & (~ (wire_nlOiii_data_out2[6] ^ rclkcmpsq1p[16]))) & (~ (wire_nlOiii_data_out2[7] ^ rclkcmpsq1p[17]))) & (~ (wire_nlOiii_data_out2[8] ^ rclkcmpsq1p[18]))) & (~ (wire_nlOiii_data_out2[9] ^ rclkcmpsq1p[19]))),
		nliOlil = ((((((((((~ (rclkcmpsq1n[0] ^ n0Olii)) & (~ (rclkcmpsq1n[1] ^ n0OliO))) & (~ (rclkcmpsq1n[2] ^ n0Olll))) & (~ (rclkcmpsq1n[3] ^ n0OlOi))) & (~ (rclkcmpsq1n[4] ^ n0OlOO))) & (~ (rclkcmpsq1n[5] ^ n0OO1l))) & (~ (rclkcmpsq1n[6] ^ n0OO0i))) & (~ (rclkcmpsq1n[7] ^ n0OO0O))) & (~ (rclkcmpsq1n[8] ^ n0OOil))) & (~ (rclkcmpsq1n[9] ^ n0OOli))),
		nliOliO = ((((((((((~ (rclkcmpsq1p[0] ^ n0Olii)) & (~ (rclkcmpsq1p[1] ^ n0OliO))) & (~ (rclkcmpsq1p[2] ^ n0Olll))) & (~ (rclkcmpsq1p[3] ^ n0OlOi))) & (~ (rclkcmpsq1p[4] ^ n0OlOO))) & (~ (rclkcmpsq1p[5] ^ n0OO1l))) & (~ (rclkcmpsq1p[6] ^ n0OO0i))) & (~ (rclkcmpsq1p[7] ^ n0OO0O))) & (~ (rclkcmpsq1p[8] ^ n0OOil))) & (~ (rclkcmpsq1p[9] ^ n0OOli))),
		nliOlli = ((((((((((~ (rclkcmpsq1n[10] ^ n0OOlO)) & (~ (rclkcmpsq1n[11] ^ n0OOOl))) & (~ (rclkcmpsq1n[12] ^ ni111i))) & (~ (rclkcmpsq1n[13] ^ ni111O))) & (~ (rclkcmpsq1n[14] ^ ni110l))) & (~ (rclkcmpsq1n[15] ^ ni11ii))) & (~ (rclkcmpsq1n[16] ^ ni11iO))) & (~ (rclkcmpsq1n[17] ^ ni11ll))) & (~ (rclkcmpsq1n[18] ^ ni11Oi))) & (~ (rclkcmpsq1n[19] ^ ni11OO))),
		nliOlll = ((((((((((~ (rclkcmpsq1p[10] ^ n0OOlO)) & (~ (rclkcmpsq1p[11] ^ n0OOOl))) & (~ (rclkcmpsq1p[12] ^ ni111i))) & (~ (rclkcmpsq1p[13] ^ ni111O))) & (~ (rclkcmpsq1p[14] ^ ni110l))) & (~ (rclkcmpsq1p[15] ^ ni11ii))) & (~ (rclkcmpsq1p[16] ^ ni11iO))) & (~ (rclkcmpsq1p[17] ^ ni11ll))) & (~ (rclkcmpsq1p[18] ^ ni11Oi))) & (~ (rclkcmpsq1p[19] ^ ni11OO))),
		nliOllO = (wire_nl1l1O_o | (nll11l & nliO1OO)),
		nliOlOi = ((((((((((~ (rclkcmpsq1n[0] ^ sudi[0])) & (~ (rclkcmpsq1n[1] ^ sudi[1]))) & (~ (rclkcmpsq1n[2] ^ sudi[2]))) & (~ (rclkcmpsq1n[3] ^ sudi[3]))) & (~ (rclkcmpsq1n[4] ^ sudi[4]))) & (~ (rclkcmpsq1n[5] ^ sudi[5]))) & (~ (rclkcmpsq1n[6] ^ sudi[6]))) & (~ (rclkcmpsq1n[7] ^ sudi[7]))) & (~ (rclkcmpsq1n[8] ^ sudi[8]))) & (~ (rclkcmpsq1n[9] ^ sudi[9]))),
		nliOlOl = ((((((((((~ (rclkcmpsq1p[0] ^ sudi[0])) & (~ (rclkcmpsq1p[1] ^ sudi[1]))) & (~ (rclkcmpsq1p[2] ^ sudi[2]))) & (~ (rclkcmpsq1p[3] ^ sudi[3]))) & (~ (rclkcmpsq1p[4] ^ sudi[4]))) & (~ (rclkcmpsq1p[5] ^ sudi[5]))) & (~ (rclkcmpsq1p[6] ^ sudi[6]))) & (~ (rclkcmpsq1p[7] ^ sudi[7]))) & (~ (rclkcmpsq1p[8] ^ sudi[8]))) & (~ (rclkcmpsq1p[9] ^ sudi[9]))),
		nliOlOO = ((((((((((~ (rclkcmpsq1n[0] ^ sudi[14])) & (~ (rclkcmpsq1n[1] ^ sudi[15]))) & (~ (rclkcmpsq1n[2] ^ sudi[16]))) & (~ (rclkcmpsq1n[3] ^ sudi[17]))) & (~ (rclkcmpsq1n[4] ^ sudi[18]))) & (~ (rclkcmpsq1n[5] ^ sudi[19]))) & (~ (rclkcmpsq1n[6] ^ sudi[20]))) & (~ (rclkcmpsq1n[7] ^ sudi[21]))) & (~ (rclkcmpsq1n[8] ^ sudi[22]))) & (~ (rclkcmpsq1n[9] ^ sudi[23]))),
		nliOO0O = ((~ rmatchen) | rgenericfifo),
		nliOO1i = ((((((((((~ (rclkcmpsq1p[0] ^ sudi[14])) & (~ (rclkcmpsq1p[1] ^ sudi[15]))) & (~ (rclkcmpsq1p[2] ^ sudi[16]))) & (~ (rclkcmpsq1p[3] ^ sudi[17]))) & (~ (rclkcmpsq1p[4] ^ sudi[18]))) & (~ (rclkcmpsq1p[5] ^ sudi[19]))) & (~ (rclkcmpsq1p[6] ^ sudi[20]))) & (~ (rclkcmpsq1p[7] ^ sudi[21]))) & (~ (rclkcmpsq1p[8] ^ sudi[22]))) & (~ (rclkcmpsq1p[9] ^ sudi[23]))),
		nliOOii = ((rmatchen | rgenericfifo) | (~ nliOOil53)),
		nliOOli = (nliOOlO | nliOOll),
		nliOOll = ((((((((((~ (rclkcmpsq1n[10] ^ sudi[14])) & (~ (rclkcmpsq1n[11] ^ sudi[15]))) & (~ (rclkcmpsq1n[12] ^ sudi[16]))) & (~ (rclkcmpsq1n[13] ^ sudi[17]))) & (~ (rclkcmpsq1n[14] ^ sudi[18]))) & (~ (rclkcmpsq1n[15] ^ sudi[19]))) & (~ (rclkcmpsq1n[16] ^ sudi[20]))) & (~ (rclkcmpsq1n[17] ^ sudi[21]))) & (~ (rclkcmpsq1n[18] ^ sudi[22]))) & (~ (rclkcmpsq1n[19] ^ sudi[23]))),
		nliOOlO = ((((((((((~ (rclkcmpsq1p[10] ^ sudi[14])) & (~ (rclkcmpsq1p[11] ^ sudi[15]))) & (~ (rclkcmpsq1p[12] ^ sudi[16]))) & (~ (rclkcmpsq1p[13] ^ sudi[17]))) & (~ (rclkcmpsq1p[14] ^ sudi[18]))) & (~ (rclkcmpsq1p[15] ^ sudi[19]))) & (~ (rclkcmpsq1p[16] ^ sudi[20]))) & (~ (rclkcmpsq1p[17] ^ sudi[21]))) & (~ (rclkcmpsq1p[18] ^ sudi[22]))) & (~ (rclkcmpsq1p[19] ^ sudi[23]))),
		nliOOOi = (nliOOOO | nliOOOl),
		nliOOOl = ((((((((((~ (rclkcmpsq1n[10] ^ sudi[0])) & (~ (rclkcmpsq1n[11] ^ sudi[1]))) & (~ (rclkcmpsq1n[12] ^ sudi[2]))) & (~ (rclkcmpsq1n[13] ^ sudi[3]))) & (~ (rclkcmpsq1n[14] ^ sudi[4]))) & (~ (rclkcmpsq1n[15] ^ sudi[5]))) & (~ (rclkcmpsq1n[16] ^ sudi[6]))) & (~ (rclkcmpsq1n[17] ^ sudi[7]))) & (~ (rclkcmpsq1n[18] ^ sudi[8]))) & (~ (rclkcmpsq1n[19] ^ sudi[9]))),
		nliOOOO = ((((((((((~ (rclkcmpsq1p[10] ^ sudi[0])) & (~ (rclkcmpsq1p[11] ^ sudi[1]))) & (~ (rclkcmpsq1p[12] ^ sudi[2]))) & (~ (rclkcmpsq1p[13] ^ sudi[3]))) & (~ (rclkcmpsq1p[14] ^ sudi[4]))) & (~ (rclkcmpsq1p[15] ^ sudi[5]))) & (~ (rclkcmpsq1p[16] ^ sudi[6]))) & (~ (rclkcmpsq1p[17] ^ sudi[7]))) & (~ (rclkcmpsq1p[18] ^ sudi[8]))) & (~ (rclkcmpsq1p[19] ^ sudi[9]))),
		nll100l = (nlilOOO | nlilOOl),
		nll10il = ((((~ rrx_pipe_enable) & nlill1l) & nlill1i) & nliliOO),
		nll10iO = (((~ nliOl1l) & nliOiOl) & nliOiOi),
		nll110i = (wire_nlOl1i_o[1] | wire_nlOl1i_o[0]),
		nll11iO = (wire_n0Oi_dataout | wire_n0Ol_dataout),
		nll11li = (nliliii | (rskpsetbased & nlill0l)),
		nll11ll = (((nlillil | (nlil1ll | (n1O0OO & (n1lOOO & (n100ii & (rrx_pipe_enable & ((~ rclkcmpsqmd) & ((~ rtruebac2bac) & (~ nlilO0l))))))))) | (n1O11O | ((n100ii & ((rclkcmpsqmd & (~ nlilO0l)) & (rtruebac2bac | ((~ rtruebac2bac) & (~ n1O11i))))) & ((nlilOOi & nlil1li) | (nlilOlO & nlil1iO))))) | (wire_n01OOi_dataout & (n100ii & ((~ rskpsetbased) & nlil1lO)))),
		nll11lO = 1'b0,
		nll11Oi = 1'b1,
		nll1i0i = (((((~ nlii0O) & nli1ii) & (~ nli10O)) & nli10l) & nli10i),
		nll1i0l = (((((~ nlii0O) & nli1ii) & nli10O) & (~ nli10l)) & (~ nli10i)),
		nll1i0O = (((((~ nlii0O) & nli1ii) & nli10O) & (~ nli10l)) & nli10i),
		nll1i1i = (dskwclksel[1] & rmatchen),
		nll1iiO = (((((~ n1ilil) & n1i1lO) & (~ n1i1ll)) & n1i1li) & n1i1iO),
		nll1ili = (((((~ n1ilil) & n1i1lO) & n1i1ll) & (~ n1i1li)) & (~ n1i1iO)),
		nll1ill = (((((~ n1ilil) & n1i1lO) & n1i1ll) & (~ n1i1li)) & n1i1iO),
		nll1ilO = ((soft_reset | wire_nli_dataout) | (~ nll1iOi2)),
		rdfifo_almost_empty = wire_ni_dataout,
		rdfifo_almost_full = wire_nO_dataout,
		rdfifo_empty = wire_nlO_dataout,
		rdfifo_full = wire_nl_dataout,
		rev_loop_data = {wire_nl1ii_dataout, wire_nl10O_dataout, wire_nl10l_dataout, wire_nl10i_dataout, wire_nl11O_dataout, wire_nl11l_dataout, wire_nl11i_dataout, wire_niOOO_dataout, wire_niOOl_dataout, wire_niOOi_dataout, wire_niOlO_dataout, wire_niOll_dataout, wire_niOli_dataout, wire_niOiO_dataout, wire_niOil_dataout, wire_niOii_dataout, wire_niO0O_dataout, wire_niO0l_dataout, wire_niO0i_dataout, wire_niO1O_dataout};
endmodule //stratixiigx_hssi_rx_comp_chnl_top
//synopsys translate_on
//VALID FILE

`timescale 1 ps / 1 ps
module rx_byte_des (
    soft_reset,
    clk_2,
    rx_we_out,
    rdwidth,
    rx_wr_clk,
    soft_reset_wclk1,
    bo_en,
    bo_3g_en,
	rx_data_int,
    sync_resync_d,
    disp_err_d,
    pattern_det_d,
    ovr_undflow_d,
    disp_val_d,

    byte_des_fifo_data_in,
    byte_des_bo_3g_start
);

input           soft_reset;
input           clk_2;
input           rx_we_out;
input           rdwidth;
input           rx_wr_clk;
input           soft_reset_wclk1;

input           bo_en;
input           bo_3g_en;
	
input    [19:0] rx_data_int;
input    [1:0]  sync_resync_d;
input    [1:0]  disp_err_d;
input    [1:0]  pattern_det_d;
input    [3:0]  ovr_undflow_d;
input    [1:0]  disp_val_d;

output [63:0] byte_des_fifo_data_in;
output [1:0]  byte_des_bo_3g_start;

reg    [63:0] fifo_data_in;
reg    [1:0]  bo_3g_start;

reg    [31:0] data_lt_0_sync;
reg    [31:0] data_lt_0;
reg    [31:0] data_lt_1;

reg           bo_3g_en_lt_0_sync;
reg           bo_3g_en_lt_0;
reg           bo_3g_en_lt_1;

assign byte_des_fifo_data_in = fifo_data_in;
assign byte_des_bo_3g_start  = bo_3g_start;

always @(posedge soft_reset or posedge clk_2)
begin
   if (soft_reset)
      begin
         data_lt_1            <= 32'h00000000;
         data_lt_0            <= 32'h00000000;
         data_lt_0_sync       <= 32'h00000000;
         bo_3g_en_lt_1        <= 1'b0;
         bo_3g_en_lt_0        <= 1'b0;
         bo_3g_en_lt_0_sync   <= 1'b0;
      end
   else
      begin
         if (rdwidth && !rx_we_out)
            begin
               data_lt_1[7:0]  <= #1  rx_data_int[7:0];
               data_lt_1[8]    <= #1  rx_data_int[8];
               data_lt_1[9]    <= #1  rx_data_int[9];
               data_lt_1[10]   <= #1  sync_resync_d[0];
               data_lt_1[11]   <= #1  disp_err_d[0];
               data_lt_1[12]   <= #1  pattern_det_d[0];
               data_lt_1[13]   <= #1  ovr_undflow_d[0];
               data_lt_1[14]   <= #1  ovr_undflow_d[1];
               data_lt_1[15]   <= #1  disp_val_d[0];
               data_lt_1[23:16]<= #1  rx_data_int[17:10];
               data_lt_1[24]   <= #1  rx_data_int[18];
               data_lt_1[25]   <= #1  rx_data_int[19];
               data_lt_1[26]   <= #1  sync_resync_d[1];
               data_lt_1[27]   <= #1  disp_err_d[1];
               data_lt_1[28]   <= #1  pattern_det_d[1];
               data_lt_1[29]   <= #1  ovr_undflow_d[2];
               data_lt_1[30]   <= #1  ovr_undflow_d[3];
               data_lt_1[31]   <= #1  disp_val_d[1];
               bo_3g_en_lt_1   <= #1  bo_en | bo_3g_en;
            end

         if (rdwidth & rx_we_out)
            begin
               data_lt_0[7:0]  <= #1  rx_data_int[7:0];
               data_lt_0[8]    <= #1  rx_data_int[8];
               data_lt_0[9]    <= #1  rx_data_int[9];
               data_lt_0[10]   <= #1  sync_resync_d[0];
               data_lt_0[11]   <= #1  disp_err_d[0];
               data_lt_0[12]   <= #1  pattern_det_d[0];
               data_lt_0[13]   <= #1  ovr_undflow_d[0];
               data_lt_0[14]   <= #1  ovr_undflow_d[1];
               data_lt_0[15]   <= #1  disp_val_d[0];
               data_lt_0[23:16]<= #1  rx_data_int[17:10];
               data_lt_0[24]   <= #1  rx_data_int[18];
               data_lt_0[25]   <= #1  rx_data_int[19];
               data_lt_0[26]   <= #1  sync_resync_d[1];
               data_lt_0[27]   <= #1  disp_err_d[1];
               data_lt_0[28]   <= #1  pattern_det_d[1];
               data_lt_0[29]   <= #1  ovr_undflow_d[2];
               data_lt_0[30]   <= #1  ovr_undflow_d[3];
               data_lt_0[31]   <= #1  disp_val_d[1];
               bo_3g_en_lt_0   <= #1  bo_en | bo_3g_en;
            end

         if (!rdwidth)
            begin
               data_lt_0_sync[7:0]  <=  rx_data_int[7:0];
               data_lt_0_sync[8]    <=  rx_data_int[8];
               data_lt_0_sync[9]    <=  rx_data_int[9];
               data_lt_0_sync[10]   <=  sync_resync_d[0];
               data_lt_0_sync[11]   <=  disp_err_d[0];
               data_lt_0_sync[12]   <=  pattern_det_d[0];
               data_lt_0_sync[13]   <=  ovr_undflow_d[0];
               data_lt_0_sync[14]   <=  ovr_undflow_d[1];
               data_lt_0_sync[15]   <=  disp_val_d[0];
               data_lt_0_sync[23:16]<=  rx_data_int[17:10];
               data_lt_0_sync[24]   <=  rx_data_int[18];
               data_lt_0_sync[25]   <=  rx_data_int[19];
               data_lt_0_sync[26]   <=  sync_resync_d[1];
               data_lt_0_sync[27]   <=  disp_err_d[1];
               data_lt_0_sync[28]   <=  pattern_det_d[1];
               data_lt_0_sync[29]   <=  ovr_undflow_d[2];
               data_lt_0_sync[30]   <=  ovr_undflow_d[3];
               data_lt_0_sync[31]   <=  disp_val_d[1];
               bo_3g_en_lt_0_sync   <=  bo_en | bo_3g_en;
            end
         else 
            begin
               data_lt_0_sync     <= #1 data_lt_0;
               bo_3g_en_lt_0_sync <= #1 bo_3g_en_lt_0;
            end

      end
end

// write enable, fifo data in
always @(posedge rx_wr_clk or posedge soft_reset_wclk1)
begin
	if (soft_reset_wclk1)
	begin
		fifo_data_in <= 64'h0000000000000000;
		bo_3g_start <= 2'h0;
	end
	else
	begin
		// add one unit delay to help VCS to order the sampling 
		// sequence between clk_2 and rx_wr_clk
		fifo_data_in <= #1 {data_lt_1, data_lt_0_sync};	
		bo_3g_start  <= #1 {bo_3g_en_lt_1, bo_3g_en_lt_0_sync};	
	end
end

endmodule
//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 362 mux21 1224 oper_decoder 10 oper_selector 202 ram8x65_syn 1 rx_byte_des 1 
`timescale 1 ps / 1 ps
module  stratixiigx_hssi_rx_ctrl
	( 
	bytord_valid_out,
	bytordplden,
	clk_2,
	dec_data_valid,
	dec_data_valid_pre,
	disp_err_delay,
	disp_val_delay,
	endec_rx,
	indv_rx,
	invalid_code_delay,
	ovr_undflow,
	ph_fifo_empty,
	ph_fifo_full,
	pld_re,
	pld_wr_dis,
	rautoinsdis,
	rbytord_2sym_en,
	rbytorden,
	rbytordpadval,
	rbytordpat,
	rbytordplden,
	rclkcmpinsertpad,
	rd_enable2,
	rd_enable_ch0,
	rd_enable_out,
	rd_enable_q0_ch0,
	rdwidth,
	rendec_data_sel_rx,
	rinvalid_code_err_only,
	rphfifo_master_sel_rx,
	rpmadatawidth,
	rptr_bin,
	rrxfifo_dis,
	rrxfifo_lowlatency_en,
	rrxfifo_urst_en,
	rrxphfifopldctl_en,
	rsync_comp_pat,
	rsync_comp_porn,
	rsync_comp_size,
	rsync_sm_dis,
	running_disp,
	rwa_6g_en,
	rx_control_dt,
	rx_control_rs,
	rx_data_dt,
	rx_data_rs,
	rx_rd_clk,
	rx_we_in_ch0,
	rx_we_in_q0_ch0,
	rx_we_out,
	rx_wr_clk,
	rxc,
	rxd,
	rxd_19,
	rxd_9,
	rxd_lpbk,
	rxfifo_urst,
	scan_mode,
	signal_detect_out,
	signal_detect_sync_st,
	soft_reset,
	soft_reset_rclk1,
	sync_resync_delay,
	sync_resync_pre,
	tenb_data,
	wptr_bin,
	wr_enable2,
	wr_enable_ch0,
	wr_enable_out,
	wr_enable_q0_ch0) /* synthesis synthesis_clearbox=1 */;
	output   bytord_valid_out;
	input   bytordplden;
	input   clk_2;
	input   [1:0]  dec_data_valid;
	input   [1:0]  dec_data_valid_pre;
	input   [1:0]  disp_err_delay;
	input   [1:0]  disp_val_delay;
	input   endec_rx;
	input   indv_rx;
	input   [1:0]  invalid_code_delay;
	input   [3:0]  ovr_undflow;
	output   ph_fifo_empty;
	output   ph_fifo_full;
	input   pld_re;
	input   pld_wr_dis;
	input   rautoinsdis;
	input   rbytord_2sym_en;
	input   [1:0]  rbytorden;
	input   [9:0]  rbytordpadval;
	input   [9:0]  rbytordpat;
	input   rbytordplden;
	input   rclkcmpinsertpad;
	output   rd_enable2;
	input   rd_enable_ch0;
	output   rd_enable_out;
	input   rd_enable_q0_ch0;
	input   rdwidth;
	input   rendec_data_sel_rx;
	input   rinvalid_code_err_only;
	input   rphfifo_master_sel_rx;
	input   rpmadatawidth;
	output   [2:0]  rptr_bin;
	input   rrxfifo_dis;
	input   rrxfifo_lowlatency_en;
	input   rrxfifo_urst_en;
	input   rrxphfifopldctl_en;
	input   [39:0]  rsync_comp_pat;
	input   rsync_comp_porn;
	input   [2:0]  rsync_comp_size;
	input   rsync_sm_dis;
	output   [1:0]  running_disp;
	input   rwa_6g_en;
	input   [1:0]  rx_control_dt;
	input   rx_control_rs;
	input   [15:0]  rx_data_dt;
	input   [7:0]  rx_data_rs;
	input   rx_rd_clk;
	input   rx_we_in_ch0;
	input   rx_we_in_q0_ch0;
	output   rx_we_out;
	input   rx_wr_clk;
	output   [3:0]  rxc;
	output   [63:0]  rxd;
	output   [1:0]  rxd_19;
	output   [1:0]  rxd_9;
	output   [39:0]  rxd_lpbk;
	input   rxfifo_urst;
	input   scan_mode;
	output   signal_detect_out;
	input   signal_detect_sync_st;
	input   soft_reset;
	output   soft_reset_rclk1;
	input   [1:0]  sync_resync_delay;
	input   [1:0]  sync_resync_pre;
	input   [19:0]  tenb_data;
	output   [2:0]  wptr_bin;
	output   wr_enable2;
	input   wr_enable_ch0;
	output   wr_enable_out;
	input   wr_enable_q0_ch0;

	reg	nl0il0i55;
	reg	nl0il0i56;
	reg	nl0il0i57;
	reg	nl0il1l58;
	reg	nl0il1l59;
	reg	nl0il1l60;
	reg	nl0ilil52;
	reg	nl0ilil53;
	reg	nl0ilil54;
	reg	nl0illi49;
	reg	nl0illi50;
	reg	nl0illi51;
	reg	nl0ilOl46;
	reg	nl0ilOl47;
	reg	nl0ilOl48;
	reg	nl0ilOO43;
	reg	nl0ilOO44;
	reg	nl0ilOO45;
	reg	nl0iO1O40;
	reg	nl0iO1O41;
	reg	nl0iO1O42;
	reg	nl0iOil37;
	reg	nl0iOil38;
	reg	nl0iOil39;
	reg	nl0iOll34;
	reg	nl0iOll35;
	reg	nl0iOll36;
	reg	nl0iOOi31;
	reg	nl0iOOi32;
	reg	nl0iOOi33;
	reg	nl0iOOO28;
	reg	nl0iOOO29;
	reg	nl0iOOO30;
	reg	nl0l01l1;
	reg	nl0l01l2;
	reg	nl0l01l3;
	reg	nl0l10l19;
	reg	nl0l10l20;
	reg	nl0l10l21;
	reg	nl0l11i25;
	reg	nl0l11i26;
	reg	nl0l11i27;
	reg	nl0l11O22;
	reg	nl0l11O23;
	reg	nl0l11O24;
	reg	nl0l1il16;
	reg	nl0l1il17;
	reg	nl0l1il18;
	reg	nl0l1iO13;
	reg	nl0l1iO14;
	reg	nl0l1iO15;
	reg	nl0l1li10;
	reg	nl0l1li11;
	reg	nl0l1li12;
	reg	nl0l1ll7;
	reg	nl0l1ll8;
	reg	nl0l1ll9;
	reg	nl0l1Ol4;
	reg	nl0l1Ol5;
	reg	nl0l1Ol6;
	reg	n110i;
	reg	nl0llOO;
	reg	nli1l0i;
	reg	nli1l0l;
	reg	nli1l0O;
	reg	nli1l1O;
	reg	nli1lii;
	reg	nli1lil;
	reg	nlilOO;
	reg	nliO0i;
	reg	nliO0l;
	reg	nliO0O;
	reg	nliO1i;
	reg	nliO1l;
	reg	nliO1O;
	reg	nliOii;
	reg	nliOil;
	reg	nliOiO;
	reg	nliOli;
	reg	nliOll;
	reg	nliOlO;
	reg	nliOOi;
	reg	nliOOl;
	reg	nliOOO;
	reg	nll00i;
	reg	nll00l;
	reg	nll00O;
	reg	nll01i;
	reg	nll01l;
	reg	nll01O;
	reg	nll0ii;
	reg	nll0il;
	reg	nll0iO;
	reg	nll0li;
	reg	nll0ll;
	reg	nll0lO;
	reg	nll0Oi;
	reg	nll0Ol;
	reg	nll0OO;
	reg	nll10i;
	reg	nll10l;
	reg	nll10O;
	reg	nll11i;
	reg	nll11l;
	reg	nll11O;
	reg	nll1ii;
	reg	nll1il;
	reg	nll1iO;
	reg	nll1li;
	reg	nll1ll;
	reg	nll1lO;
	reg	nll1Oi;
	reg	nll1Ol;
	reg	nll1OO;
	reg	nlli0i;
	reg	nlli0l;
	reg	nlli0O;
	reg	nlli1i;
	reg	nlli1l;
	reg	nlli1O;
	reg	nlliii;
	reg	nlliil;
	reg	nlliiO;
	reg	nllili;
	reg	nllill;
	reg	nllilO;
	reg	nlliOi;
	reg	nlliOl;
	reg	nlliOO;
	reg	nlll0i;
	reg	nlll0l;
	reg	nlll0O;
	reg	nlll1i;
	reg	nlll1l;
	reg	nlll1O;
	reg	nlllii;
	reg	nlllil;
	reg	nllliO;
	reg	nlllli;
	reg	nlllll;
	reg	nllllO;
	reg	nlllOi;
	reg	nlllOl;
	reg	nlllOO;
	reg	nllO0i;
	reg	nllO0l;
	reg	nllO0O;
	reg	nllO1i;
	reg	nllO1l;
	reg	nllO1O;
	reg	nllOii;
	reg	nllOil;
	reg	nllOiO;
	reg	nllOli;
	reg	nllOll;
	reg	nllOlO;
	reg	nllOOi;
	reg	nllOOl;
	reg	nllOOO;
	reg	nlO00i;
	reg	nlO00l;
	reg	nlO00O;
	reg	nlO01i;
	reg	nlO01l;
	reg	nlO01O;
	reg	nlO0ii;
	reg	nlO0il;
	reg	nlO0iO;
	reg	nlO0li;
	reg	nlO0ll;
	reg	nlO0lO;
	reg	nlO0Oi;
	reg	nlO0Ol;
	reg	nlO0OO;
	reg	nlO10i;
	reg	nlO10l;
	reg	nlO10O;
	reg	nlO11i;
	reg	nlO11l;
	reg	nlO11O;
	reg	nlO1ii;
	reg	nlO1il;
	reg	nlO1iO;
	reg	nlO1li;
	reg	nlO1ll;
	reg	nlO1lO;
	reg	nlO1Oi;
	reg	nlO1Ol;
	reg	nlO1OO;
	reg	nlOi1i;
	reg	nlOlli;
	reg	nlOO0l;
	reg	nlOO0O;
	reg	nlOOii;
	reg	nlOOil;
	reg	nlOOiO;
	reg	nlOOli;
	reg	nlOOll;
	reg	n11O0l;
	reg	n11O1O;
	reg	n11O1l;
	reg	n11O0O;
	reg	n11Oil;
	reg	n100i;
	reg	n100l;
	reg	n100O;
	reg	n101i;
	reg	n101l;
	reg	n101O;
	reg	n10ii;
	reg	n10il;
	reg	n10iO;
	reg	n10li;
	reg	n10ll;
	reg	n10lO;
	reg	n10Oi;
	reg	n10Ol;
	reg	n10OO;
	reg	n110O;
	reg	n11ii;
	reg	n11il;
	reg	n11iO;
	reg	n11li;
	reg	n11ll;
	reg	n11lO;
	reg	n11Oi;
	reg	n11OiO;
	reg	n11Ol;
	reg	n11Oli;
	reg	n11Oll;
	reg	n11OlO;
	reg	n11OO;
	reg	n1i0i;
	reg	n1i0l;
	reg	n1i0O;
	reg	n1i1i;
	reg	n1i1l;
	reg	n1i1O;
	reg	n1iii;
	reg	n1iil;
	reg	n1iiO;
	reg	n1ili;
	reg	n1ill;
	reg	n1ilO;
	reg	n1iOi;
	reg	n1iOl;
	reg	n1iOO;
	reg	n1l1i;
	reg	n1l1O;
	reg	nl0ll0O;
	wire	wire_nl0ll0l_ENA;
	reg	nl0llii;
	reg	nl0llil;
	reg	nl0lliO;
	reg	nl0llli;
	reg	nl0lllO;
	reg	nl0llOl;
	reg	nl0lOli;
	reg	nl0lOll;
	reg	nl0lOlO;
	reg	nl0lOOi;
	reg	nl0lOOl;
	reg	nl0lOOO;
	reg	nl0O00i;
	reg	nl0O00l;
	reg	nl0O00O;
	reg	nl0O01i;
	reg	nl0O01l;
	reg	nl0O01O;
	reg	nl0O0ii;
	reg	nl0O0il;
	reg	nl0O0iO;
	reg	nl0O0li;
	reg	nl0O0ll;
	reg	nl0O0lO;
	reg	nl0O0Oi;
	reg	nl0O0Ol;
	reg	nl0O0OO;
	reg	nl0O10i;
	reg	nl0O10l;
	reg	nl0O10O;
	reg	nl0O11i;
	reg	nl0O11l;
	reg	nl0O11O;
	reg	nl0O1ii;
	reg	nl0O1il;
	reg	nl0O1iO;
	reg	nl0O1li;
	reg	nl0O1ll;
	reg	nl0O1lO;
	reg	nl0O1Oi;
	reg	nl0O1Ol;
	reg	nl0O1OO;
	reg	nl0Oi0i;
	reg	nl0Oi0l;
	reg	nl0Oi0O;
	reg	nl0Oi1i;
	reg	nl0Oi1l;
	reg	nl0Oi1O;
	reg	nl0Oiii;
	reg	nl0Oiil;
	reg	nl0OiiO;
	reg	nl0Oili;
	reg	nl0Oill;
	reg	nl0OilO;
	reg	nl0OiOi;
	reg	nl0OiOl;
	reg	nl0OiOO;
	reg	nl0Ol0i;
	reg	nl0Ol0l;
	reg	nl0Ol0O;
	reg	nl0Ol1i;
	reg	nl0Ol1l;
	reg	nl0Ol1O;
	reg	nl0Olii;
	reg	nl0Olil;
	reg	nl0OliO;
	reg	nl0Olli;
	reg	nl0Olll;
	reg	nl0OllO;
	reg	nl0OlOi;
	reg	nl0OlOl;
	reg	nl0OlOO;
	reg	nl0OO0i;
	reg	nl0OO0l;
	reg	nl0OO0O;
	reg	nl0OO1i;
	reg	nl0OO1l;
	reg	nl0OO1O;
	reg	nl0OOii;
	reg	nl0OOil;
	reg	nl0OOiO;
	reg	nl0OOli;
	reg	nl0OOll;
	reg	nl0OOlO;
	reg	nl0OOOi;
	reg	nl0OOOl;
	reg	nl0OOOO;
	reg	nli100i;
	reg	nli100l;
	reg	nli101i;
	reg	nli101l;
	reg	nli101O;
	reg	nli110i;
	reg	nli110l;
	reg	nli110O;
	reg	nli111i;
	reg	nli111l;
	reg	nli111O;
	reg	nli11ii;
	reg	nli11il;
	reg	nli11iO;
	reg	nli11li;
	reg	nli11ll;
	reg	nli11lO;
	reg	nli11Oi;
	reg	nli11Ol;
	reg	nli11OO;
	reg	nli1l1l;
	reg	nlOlll;
	reg	nlOllO;
	reg	nlOlOi;
	reg	nlOO0i;
	wire	wire_n0000i_dataout;
	wire	wire_n0000l_dataout;
	wire	wire_n0000O_dataout;
	wire	wire_n0001i_dataout;
	wire	wire_n0001l_dataout;
	wire	wire_n0001O_dataout;
	wire	wire_n000i_dataout;
	wire	wire_n000ii_dataout;
	wire	wire_n000il_dataout;
	wire	wire_n000iO_dataout;
	wire	wire_n000l_dataout;
	wire	wire_n000li_dataout;
	wire	wire_n000ll_dataout;
	wire	wire_n000lO_dataout;
	wire	wire_n000O_dataout;
	wire	wire_n000Oi_dataout;
	wire	wire_n000Ol_dataout;
	wire	wire_n000OO_dataout;
	wire	wire_n0010i_dataout;
	wire	wire_n0010l_dataout;
	wire	wire_n0010O_dataout;
	wire	wire_n0011i_dataout;
	wire	wire_n0011l_dataout;
	wire	wire_n0011O_dataout;
	wire	wire_n001i_dataout;
	wire	wire_n001ii_dataout;
	wire	wire_n001il_dataout;
	wire	wire_n001iO_dataout;
	wire	wire_n001l_dataout;
	wire	wire_n001li_dataout;
	wire	wire_n001ll_dataout;
	wire	wire_n001lO_dataout;
	wire	wire_n001O_dataout;
	wire	wire_n001Oi_dataout;
	wire	wire_n001Ol_dataout;
	wire	wire_n001OO_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00i0i_dataout;
	wire	wire_n00i0l_dataout;
	wire	wire_n00i0O_dataout;
	wire	wire_n00i1i_dataout;
	wire	wire_n00i1l_dataout;
	wire	wire_n00i1O_dataout;
	wire	wire_n00ii_dataout;
	wire	wire_n00iii_dataout;
	wire	wire_n00iil_dataout;
	wire	wire_n00iiO_dataout;
	wire	wire_n00il_dataout;
	wire	wire_n00ili_dataout;
	wire	wire_n00ill_dataout;
	wire	wire_n00ilO_dataout;
	wire	wire_n00iO_dataout;
	wire	wire_n00iOi_dataout;
	wire	wire_n00iOl_dataout;
	wire	wire_n00iOO_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00l0i_dataout;
	wire	wire_n00l0l_dataout;
	wire	wire_n00l0O_dataout;
	wire	wire_n00l1i_dataout;
	wire	wire_n00l1l_dataout;
	wire	wire_n00l1O_dataout;
	wire	wire_n00li_dataout;
	wire	wire_n00lii_dataout;
	wire	wire_n00lil_dataout;
	wire	wire_n00liO_dataout;
	wire	wire_n00ll_dataout;
	wire	wire_n00lli_dataout;
	wire	wire_n00lll_dataout;
	wire	wire_n00llO_dataout;
	wire	wire_n00lO_dataout;
	wire	wire_n00lOi_dataout;
	wire	wire_n00lOl_dataout;
	wire	wire_n00lOO_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n00O0i_dataout;
	wire	wire_n00O0l_dataout;
	wire	wire_n00O0O_dataout;
	wire	wire_n00O1i_dataout;
	wire	wire_n00O1l_dataout;
	wire	wire_n00O1O_dataout;
	wire	wire_n00Oi_dataout;
	wire	wire_n00Oii_dataout;
	wire	wire_n00Oil_dataout;
	wire	wire_n00OiO_dataout;
	wire	wire_n00Oli_dataout;
	wire	wire_n00Oll_dataout;
	wire	wire_n00OlO_dataout;
	wire	wire_n00OO_dataout;
	wire	wire_n00OOi_dataout;
	wire	wire_n00OOl_dataout;
	wire	wire_n00OOO_dataout;
	wire	wire_n0100i_dataout;
	wire	wire_n0100l_dataout;
	wire	wire_n0100O_dataout;
	wire	wire_n0101i_dataout;
	wire	wire_n0101l_dataout;
	wire	wire_n0101O_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010ii_dataout;
	wire	wire_n010il_dataout;
	wire	wire_n010iO_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010li_dataout;
	wire	wire_n010ll_dataout;
	wire	wire_n010lO_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n010Oi_dataout;
	wire	wire_n010Ol_dataout;
	wire	wire_n010OO_dataout;
	wire	wire_n0110i_dataout;
	wire	wire_n0110l_dataout;
	wire	wire_n0110O_dataout;
	wire	wire_n0111i_dataout;
	wire	wire_n0111l_dataout;
	wire	wire_n0111O_dataout;
	wire	wire_n011i_dataout;
	wire	wire_n011ii_dataout;
	wire	wire_n011il_dataout;
	wire	wire_n011iO_dataout;
	wire	wire_n011l_dataout;
	wire	wire_n011li_dataout;
	wire	wire_n011ll_dataout;
	wire	wire_n011lO_dataout;
	wire	wire_n011O_dataout;
	wire	wire_n011Oi_dataout;
	wire	wire_n011Ol_dataout;
	wire	wire_n011OO_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01i0i_dataout;
	wire	wire_n01i0l_dataout;
	wire	wire_n01i0O_dataout;
	wire	wire_n01i1i_dataout;
	wire	wire_n01i1l_dataout;
	wire	wire_n01i1O_dataout;
	wire	wire_n01ii_dataout;
	wire	wire_n01iii_dataout;
	wire	wire_n01iil_dataout;
	wire	wire_n01iiO_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01ili_dataout;
	wire	wire_n01ill_dataout;
	wire	wire_n01ilO_dataout;
	wire	wire_n01iO_dataout;
	wire	wire_n01iOi_dataout;
	wire	wire_n01iOl_dataout;
	wire	wire_n01iOO_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01l0i_dataout;
	wire	wire_n01l0l_dataout;
	wire	wire_n01l0O_dataout;
	wire	wire_n01l1i_dataout;
	wire	wire_n01l1l_dataout;
	wire	wire_n01l1O_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01lii_dataout;
	wire	wire_n01lil_dataout;
	wire	wire_n01liO_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01lli_dataout;
	wire	wire_n01lll_dataout;
	wire	wire_n01llO_dataout;
	wire	wire_n01lO_dataout;
	wire	wire_n01lOi_dataout;
	wire	wire_n01lOl_dataout;
	wire	wire_n01lOO_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01O0i_dataout;
	wire	wire_n01O0l_dataout;
	wire	wire_n01O0O_dataout;
	wire	wire_n01O1i_dataout;
	wire	wire_n01O1l_dataout;
	wire	wire_n01O1O_dataout;
	wire	wire_n01Oi_dataout;
	wire	wire_n01Oii_dataout;
	wire	wire_n01Oil_dataout;
	wire	wire_n01OiO_dataout;
	wire	wire_n01Ol_dataout;
	wire	wire_n01Oli_dataout;
	wire	wire_n01Oll_dataout;
	wire	wire_n01OlO_dataout;
	wire	wire_n01OO_dataout;
	wire	wire_n01OOi_dataout;
	wire	wire_n01OOl_dataout;
	wire	wire_n01OOO_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0i00i_dataout;
	wire	wire_n0i00l_dataout;
	wire	wire_n0i00O_dataout;
	wire	wire_n0i01i_dataout;
	wire	wire_n0i01l_dataout;
	wire	wire_n0i01O_dataout;
	wire	wire_n0i0i_dataout;
	wire	wire_n0i0ii_dataout;
	wire	wire_n0i0il_dataout;
	wire	wire_n0i0iO_dataout;
	wire	wire_n0i0l_dataout;
	wire	wire_n0i0li_dataout;
	wire	wire_n0i0ll_dataout;
	wire	wire_n0i0lO_dataout;
	wire	wire_n0i0O_dataout;
	wire	wire_n0i0Oi_dataout;
	wire	wire_n0i0Ol_dataout;
	wire	wire_n0i0OO_dataout;
	wire	wire_n0i10i_dataout;
	wire	wire_n0i10l_dataout;
	wire	wire_n0i10O_dataout;
	wire	wire_n0i11i_dataout;
	wire	wire_n0i11l_dataout;
	wire	wire_n0i11O_dataout;
	wire	wire_n0i1ii_dataout;
	wire	wire_n0i1il_dataout;
	wire	wire_n0i1iO_dataout;
	wire	wire_n0i1l_dataout;
	wire	wire_n0i1li_dataout;
	wire	wire_n0i1ll_dataout;
	wire	wire_n0i1lO_dataout;
	wire	wire_n0i1O_dataout;
	wire	wire_n0i1Oi_dataout;
	wire	wire_n0i1Ol_dataout;
	wire	wire_n0i1OO_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0ii0i_dataout;
	wire	wire_n0ii0l_dataout;
	wire	wire_n0ii0O_dataout;
	wire	wire_n0ii1i_dataout;
	wire	wire_n0ii1l_dataout;
	wire	wire_n0ii1O_dataout;
	wire	wire_n0iii_dataout;
	wire	wire_n0iiii_dataout;
	wire	wire_n0iiil_dataout;
	wire	wire_n0iiiO_dataout;
	wire	wire_n0iil_dataout;
	wire	wire_n0iili_dataout;
	wire	wire_n0iill_dataout;
	wire	wire_n0iilO_dataout;
	wire	wire_n0iiO_dataout;
	wire	wire_n0iiOi_dataout;
	wire	wire_n0iiOl_dataout;
	wire	wire_n0iiOO_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0il0i_dataout;
	wire	wire_n0il0l_dataout;
	wire	wire_n0il0O_dataout;
	wire	wire_n0il1i_dataout;
	wire	wire_n0il1l_dataout;
	wire	wire_n0il1O_dataout;
	wire	wire_n0ili_dataout;
	wire	wire_n0ilii_dataout;
	wire	wire_n0ilil_dataout;
	wire	wire_n0iliO_dataout;
	wire	wire_n0ill_dataout;
	wire	wire_n0illi_dataout;
	wire	wire_n0illl_dataout;
	wire	wire_n0illO_dataout;
	wire	wire_n0ilO_dataout;
	wire	wire_n0ilOi_dataout;
	wire	wire_n0ilOl_dataout;
	wire	wire_n0ilOO_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0iO0i_dataout;
	wire	wire_n0iO0l_dataout;
	wire	wire_n0iO0O_dataout;
	wire	wire_n0iO1i_dataout;
	wire	wire_n0iO1l_dataout;
	wire	wire_n0iO1O_dataout;
	wire	wire_n0iOi_dataout;
	wire	wire_n0iOii_dataout;
	wire	wire_n0iOil_dataout;
	wire	wire_n0iOiO_dataout;
	wire	wire_n0iOl_dataout;
	wire	wire_n0iOli_dataout;
	wire	wire_n0iOll_dataout;
	wire	wire_n0iOlO_dataout;
	wire	wire_n0iOO_dataout;
	wire	wire_n0iOOi_dataout;
	wire	wire_n0iOOl_dataout;
	wire	wire_n0iOOO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0l00i_dataout;
	wire	wire_n0l00l_dataout;
	wire	wire_n0l00O_dataout;
	wire	wire_n0l01i_dataout;
	wire	wire_n0l01l_dataout;
	wire	wire_n0l01O_dataout;
	wire	wire_n0l0i_dataout;
	wire	wire_n0l0ii_dataout;
	wire	wire_n0l0il_dataout;
	wire	wire_n0l0iO_dataout;
	wire	wire_n0l0l_dataout;
	wire	wire_n0l0li_dataout;
	wire	wire_n0l0ll_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0l0Oi_dataout;
	wire	wire_n0l0Ol_dataout;
	wire	wire_n0l0OO_dataout;
	wire	wire_n0l10i_dataout;
	wire	wire_n0l10l_dataout;
	wire	wire_n0l10O_dataout;
	wire	wire_n0l11i_dataout;
	wire	wire_n0l11l_dataout;
	wire	wire_n0l11O_dataout;
	wire	wire_n0l1i_dataout;
	wire	wire_n0l1ii_dataout;
	wire	wire_n0l1il_dataout;
	wire	wire_n0l1iO_dataout;
	wire	wire_n0l1l_dataout;
	wire	wire_n0l1li_dataout;
	wire	wire_n0l1ll_dataout;
	wire	wire_n0l1lO_dataout;
	wire	wire_n0l1O_dataout;
	wire	wire_n0l1Oi_dataout;
	wire	wire_n0l1Ol_dataout;
	wire	wire_n0l1OO_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0li0i_dataout;
	wire	wire_n0li0l_dataout;
	wire	wire_n0li0O_dataout;
	wire	wire_n0li1i_dataout;
	wire	wire_n0li1l_dataout;
	wire	wire_n0li1O_dataout;
	wire	wire_n0lii_dataout;
	wire	wire_n0liii_dataout;
	wire	wire_n0liil_dataout;
	wire	wire_n0liiO_dataout;
	wire	wire_n0lil_dataout;
	wire	wire_n0lili_dataout;
	wire	wire_n0lill_dataout;
	wire	wire_n0lilO_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0liOi_dataout;
	wire	wire_n0liOl_dataout;
	wire	wire_n0liOO_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0ll0i_dataout;
	wire	wire_n0ll0l_dataout;
	wire	wire_n0ll0O_dataout;
	wire	wire_n0ll1i_dataout;
	wire	wire_n0ll1l_dataout;
	wire	wire_n0ll1O_dataout;
	wire	wire_n0lli_dataout;
	wire	wire_n0llii_dataout;
	wire	wire_n0llil_dataout;
	wire	wire_n0lliO_dataout;
	wire	wire_n0lll_dataout;
	wire	wire_n0llli_dataout;
	wire	wire_n0llll_dataout;
	wire	wire_n0lllO_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0llOi_dataout;
	wire	wire_n0llOl_dataout;
	wire	wire_n0llOO_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0lO0i_dataout;
	wire	wire_n0lO0l_dataout;
	wire	wire_n0lO0O_dataout;
	wire	wire_n0lO1i_dataout;
	wire	wire_n0lO1l_dataout;
	wire	wire_n0lO1O_dataout;
	wire	wire_n0lOi_dataout;
	wire	wire_n0lOii_dataout;
	wire	wire_n0lOil_dataout;
	wire	wire_n0lOiO_dataout;
	wire	wire_n0lOl_dataout;
	wire	wire_n0lOli_dataout;
	wire	wire_n0lOll_dataout;
	wire	wire_n0lOlO_dataout;
	wire	wire_n0lOO_dataout;
	wire	wire_n0lOOi_dataout;
	wire	wire_n0lOOl_dataout;
	wire	wire_n0lOOO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0O00i_dataout;
	wire	wire_n0O00l_dataout;
	wire	wire_n0O00O_dataout;
	wire	wire_n0O01i_dataout;
	wire	wire_n0O01l_dataout;
	wire	wire_n0O01O_dataout;
	wire	wire_n0O0ii_dataout;
	wire	wire_n0O0il_dataout;
	wire	wire_n0O0iO_dataout;
	wire	wire_n0O0l_dataout;
	wire	wire_n0O0li_dataout;
	wire	wire_n0O0ll_dataout;
	wire	wire_n0O0lO_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O0Oi_dataout;
	wire	wire_n0O0Ol_dataout;
	wire	wire_n0O0OO_dataout;
	wire	wire_n0O10i_dataout;
	wire	wire_n0O10l_dataout;
	wire	wire_n0O10O_dataout;
	wire	wire_n0O11l_dataout;
	wire	wire_n0O11O_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0O1ii_dataout;
	wire	wire_n0O1il_dataout;
	wire	wire_n0O1iO_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1li_dataout;
	wire	wire_n0O1ll_dataout;
	wire	wire_n0O1lO_dataout;
	wire	wire_n0O1Oi_dataout;
	wire	wire_n0O1Ol_dataout;
	wire	wire_n0O1OO_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Oi0i_dataout;
	wire	wire_n0Oi0l_dataout;
	wire	wire_n0Oi0O_dataout;
	wire	wire_n0Oi1i_dataout;
	wire	wire_n0Oi1l_dataout;
	wire	wire_n0Oi1O_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Oiii_dataout;
	wire	wire_n0Oiil_dataout;
	wire	wire_n0OiiO_dataout;
	wire	wire_n0Oil_dataout;
	wire	wire_n0Oili_dataout;
	wire	wire_n0Oill_dataout;
	wire	wire_n0OilO_dataout;
	wire	wire_n0OiO_dataout;
	wire	wire_n0OiOi_dataout;
	wire	wire_n0OiOl_dataout;
	wire	wire_n0OiOO_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0Ol0i_dataout;
	wire	wire_n0Ol0l_dataout;
	wire	wire_n0Ol0O_dataout;
	wire	wire_n0Ol1i_dataout;
	wire	wire_n0Ol1l_dataout;
	wire	wire_n0Ol1O_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0Olii_dataout;
	wire	wire_n0Olil_dataout;
	wire	wire_n0OliO_dataout;
	wire	wire_n0Oll_dataout;
	wire	wire_n0Olli_dataout;
	wire	wire_n0Olll_dataout;
	wire	wire_n0OllO_dataout;
	wire	wire_n0OlO_dataout;
	wire	wire_n0OlOi_dataout;
	wire	wire_n0OlOl_dataout;
	wire	wire_n0OlOO_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OO0i_dataout;
	wire	wire_n0OO0l_dataout;
	wire	wire_n0OO0O_dataout;
	wire	wire_n0OO1i_dataout;
	wire	wire_n0OO1l_dataout;
	wire	wire_n0OO1O_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOii_dataout;
	wire	wire_n0OOil_dataout;
	wire	wire_n0OOiO_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n0OOli_dataout;
	wire	wire_n0OOll_dataout;
	wire	wire_n0OOlO_dataout;
	wire	wire_n0OOO_dataout;
	wire	wire_n0OOOi_dataout;
	wire	wire_n0OOOl_dataout;
	wire	wire_n0OOOO_dataout;
	wire	wire_n1011i_dataout;
	wire	wire_n1011l_dataout;
	wire	wire_n1011O_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n10Oll_dataout;
	wire	wire_n10OlO_dataout;
	wire	wire_n10OOi_dataout;
	wire	wire_n10OOl_dataout;
	wire	wire_n10OOO_dataout;
	wire	wire_n110l_dataout;
	wire	wire_n111l_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n11OOi_dataout;
	wire	wire_n11OOl_dataout;
	wire	wire_n11OOO_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1i00i_dataout;
	wire	wire_n1i00l_dataout;
	wire	wire_n1i00O_dataout;
	wire	wire_n1i01i_dataout;
	wire	wire_n1i01l_dataout;
	wire	wire_n1i01O_dataout;
	wire	wire_n1i0ii_dataout;
	wire	wire_n1i0il_dataout;
	wire	wire_n1i0iO_dataout;
	wire	wire_n1i0li_dataout;
	wire	wire_n1i0ll_dataout;
	wire	wire_n1i0lO_dataout;
	wire	wire_n1i0Oi_dataout;
	wire	wire_n1i0Ol_dataout;
	wire	wire_n1i0OO_dataout;
	wire	wire_n1i10i_dataout;
	wire	wire_n1i10l_dataout;
	wire	wire_n1i10O_dataout;
	wire	wire_n1i11i_dataout;
	wire	wire_n1i11l_dataout;
	wire	wire_n1i11O_dataout;
	wire	wire_n1i1ii_dataout;
	wire	wire_n1i1il_dataout;
	wire	wire_n1i1iO_dataout;
	wire	wire_n1i1li_dataout;
	wire	wire_n1i1ll_dataout;
	wire	wire_n1i1lO_dataout;
	wire	wire_n1i1Oi_dataout;
	wire	wire_n1i1Ol_dataout;
	wire	wire_n1i1OO_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1ii0i_dataout;
	wire	wire_n1ii0l_dataout;
	wire	wire_n1ii0O_dataout;
	wire	wire_n1ii1i_dataout;
	wire	wire_n1ii1l_dataout;
	wire	wire_n1ii1O_dataout;
	wire	wire_n1iiii_dataout;
	wire	wire_n1iiil_dataout;
	wire	wire_n1iiiO_dataout;
	wire	wire_n1iili_dataout;
	wire	wire_n1iill_dataout;
	wire	wire_n1iilO_dataout;
	wire	wire_n1iiOi_dataout;
	wire	wire_n1iiOl_dataout;
	wire	wire_n1iiOO_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1il0i_dataout;
	wire	wire_n1il0l_dataout;
	wire	wire_n1il0O_dataout;
	wire	wire_n1il1i_dataout;
	wire	wire_n1il1l_dataout;
	wire	wire_n1il1O_dataout;
	wire	wire_n1ilii_dataout;
	wire	wire_n1ilil_dataout;
	wire	wire_n1iliO_dataout;
	wire	wire_n1illi_dataout;
	wire	wire_n1illl_dataout;
	wire	wire_n1illO_dataout;
	wire	wire_n1ilOi_dataout;
	wire	wire_n1ilOl_dataout;
	wire	wire_n1ilOO_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1iO0i_dataout;
	wire	wire_n1iO0l_dataout;
	wire	wire_n1iO0O_dataout;
	wire	wire_n1iO1i_dataout;
	wire	wire_n1iO1l_dataout;
	wire	wire_n1iO1O_dataout;
	wire	wire_n1iOii_dataout;
	wire	wire_n1iOil_dataout;
	wire	wire_n1iOiO_dataout;
	wire	wire_n1iOli_dataout;
	wire	wire_n1iOll_dataout;
	wire	wire_n1iOlO_dataout;
	wire	wire_n1iOOi_dataout;
	wire	wire_n1iOOl_dataout;
	wire	wire_n1iOOO_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1l00i_dataout;
	wire	wire_n1l00l_dataout;
	wire	wire_n1l00O_dataout;
	wire	wire_n1l01i_dataout;
	wire	wire_n1l01l_dataout;
	wire	wire_n1l01O_dataout;
	wire	wire_n1l0ii_dataout;
	wire	wire_n1l0il_dataout;
	wire	wire_n1l0iO_dataout;
	wire	wire_n1l0li_dataout;
	wire	wire_n1l0ll_dataout;
	wire	wire_n1l0lO_dataout;
	wire	wire_n1l0Oi_dataout;
	wire	wire_n1l0Ol_dataout;
	wire	wire_n1l0OO_dataout;
	wire	wire_n1l10i_dataout;
	wire	wire_n1l10l_dataout;
	wire	wire_n1l10O_dataout;
	wire	wire_n1l11i_dataout;
	wire	wire_n1l11l_dataout;
	wire	wire_n1l11O_dataout;
	wire	wire_n1l1ii_dataout;
	wire	wire_n1l1il_dataout;
	wire	wire_n1l1iO_dataout;
	wire	wire_n1l1li_dataout;
	wire	wire_n1l1ll_dataout;
	wire	wire_n1l1lO_dataout;
	wire	wire_n1l1Oi_dataout;
	wire	wire_n1l1Ol_dataout;
	wire	wire_n1l1OO_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1li0i_dataout;
	wire	wire_n1li0l_dataout;
	wire	wire_n1li0O_dataout;
	wire	wire_n1li1i_dataout;
	wire	wire_n1li1l_dataout;
	wire	wire_n1li1O_dataout;
	wire	wire_n1liii_dataout;
	wire	wire_n1liil_dataout;
	wire	wire_n1liiO_dataout;
	wire	wire_n1lili_dataout;
	wire	wire_n1lill_dataout;
	wire	wire_n1lilO_dataout;
	wire	wire_n1liOi_dataout;
	wire	wire_n1liOl_dataout;
	wire	wire_n1liOO_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1ll0i_dataout;
	wire	wire_n1ll0l_dataout;
	wire	wire_n1ll0O_dataout;
	wire	wire_n1ll1i_dataout;
	wire	wire_n1ll1l_dataout;
	wire	wire_n1ll1O_dataout;
	wire	wire_n1llii_dataout;
	wire	wire_n1llil_dataout;
	wire	wire_n1lliO_dataout;
	wire	wire_n1llli_dataout;
	wire	wire_n1llll_dataout;
	wire	wire_n1lllO_dataout;
	wire	wire_n1llOi_dataout;
	wire	wire_n1llOl_dataout;
	wire	wire_n1llOO_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1lO0i_dataout;
	wire	wire_n1lO0l_dataout;
	wire	wire_n1lO0O_dataout;
	wire	wire_n1lO1i_dataout;
	wire	wire_n1lO1l_dataout;
	wire	wire_n1lO1O_dataout;
	wire	wire_n1lOii_dataout;
	wire	wire_n1lOil_dataout;
	wire	wire_n1lOiO_dataout;
	wire	wire_n1lOli_dataout;
	wire	wire_n1lOll_dataout;
	wire	wire_n1lOlO_dataout;
	wire	wire_n1lOOi_dataout;
	wire	wire_n1lOOl_dataout;
	wire	wire_n1lOOO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1O00i_dataout;
	wire	wire_n1O00l_dataout;
	wire	wire_n1O00O_dataout;
	wire	wire_n1O01i_dataout;
	wire	wire_n1O01l_dataout;
	wire	wire_n1O01O_dataout;
	wire	wire_n1O0il_dataout;
	wire	wire_n1O0iO_dataout;
	wire	wire_n1O0l_dataout;
	wire	wire_n1O0li_dataout;
	wire	wire_n1O0ll_dataout;
	wire	wire_n1O0lO_dataout;
	wire	wire_n1O0O_dataout;
	wire	wire_n1O0Oi_dataout;
	wire	wire_n1O0Ol_dataout;
	wire	wire_n1O0OO_dataout;
	wire	wire_n1O10i_dataout;
	wire	wire_n1O10l_dataout;
	wire	wire_n1O10O_dataout;
	wire	wire_n1O11i_dataout;
	wire	wire_n1O11l_dataout;
	wire	wire_n1O11O_dataout;
	wire	wire_n1O1ii_dataout;
	wire	wire_n1O1il_dataout;
	wire	wire_n1O1iO_dataout;
	wire	wire_n1O1li_dataout;
	wire	wire_n1O1ll_dataout;
	wire	wire_n1O1lO_dataout;
	wire	wire_n1O1Oi_dataout;
	wire	wire_n1O1Ol_dataout;
	wire	wire_n1O1OO_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Oi0i_dataout;
	wire	wire_n1Oi0l_dataout;
	wire	wire_n1Oi0O_dataout;
	wire	wire_n1Oi1i_dataout;
	wire	wire_n1Oi1l_dataout;
	wire	wire_n1Oi1O_dataout;
	wire	wire_n1Oii_dataout;
	wire	wire_n1Oiii_dataout;
	wire	wire_n1Oiil_dataout;
	wire	wire_n1OiiO_dataout;
	wire	wire_n1Oil_dataout;
	wire	wire_n1Oili_dataout;
	wire	wire_n1Oill_dataout;
	wire	wire_n1OilO_dataout;
	wire	wire_n1OiOi_dataout;
	wire	wire_n1OiOl_dataout;
	wire	wire_n1OiOO_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1Ol0i_dataout;
	wire	wire_n1Ol0l_dataout;
	wire	wire_n1Ol0O_dataout;
	wire	wire_n1Ol1i_dataout;
	wire	wire_n1Ol1l_dataout;
	wire	wire_n1Ol1O_dataout;
	wire	wire_n1Olii_dataout;
	wire	wire_n1Olil_dataout;
	wire	wire_n1OliO_dataout;
	wire	wire_n1Oll_dataout;
	wire	wire_n1Olli_dataout;
	wire	wire_n1Olll_dataout;
	wire	wire_n1OllO_dataout;
	wire	wire_n1OlO_dataout;
	wire	wire_n1OlOi_dataout;
	wire	wire_n1OlOl_dataout;
	wire	wire_n1OlOO_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_n1OO0i_dataout;
	wire	wire_n1OO0l_dataout;
	wire	wire_n1OO0O_dataout;
	wire	wire_n1OO1i_dataout;
	wire	wire_n1OO1l_dataout;
	wire	wire_n1OO1O_dataout;
	wire	wire_n1OOi_dataout;
	wire	wire_n1OOii_dataout;
	wire	wire_n1OOil_dataout;
	wire	wire_n1OOiO_dataout;
	wire	wire_n1OOl_dataout;
	wire	wire_n1OOli_dataout;
	wire	wire_n1OOll_dataout;
	wire	wire_n1OOlO_dataout;
	wire	wire_n1OOO_dataout;
	wire	wire_n1OOOi_dataout;
	wire	wire_n1OOOl_dataout;
	wire	wire_n1OOOO_dataout;
	wire	wire_ni000i_dataout;
	wire	wire_ni000l_dataout;
	wire	wire_ni000O_dataout;
	wire	wire_ni001i_dataout;
	wire	wire_ni001l_dataout;
	wire	wire_ni001O_dataout;
	wire	wire_ni00i_dataout;
	wire	wire_ni00ii_dataout;
	wire	wire_ni00il_dataout;
	wire	wire_ni00iO_dataout;
	wire	wire_ni00l_dataout;
	wire	wire_ni00li_dataout;
	wire	wire_ni00ll_dataout;
	wire	wire_ni00lO_dataout;
	wire	wire_ni00O_dataout;
	wire	wire_ni00Oi_dataout;
	wire	wire_ni00Ol_dataout;
	wire	wire_ni00OO_dataout;
	wire	wire_ni010i_dataout;
	wire	wire_ni010l_dataout;
	wire	wire_ni010O_dataout;
	wire	wire_ni011i_dataout;
	wire	wire_ni011l_dataout;
	wire	wire_ni011O_dataout;
	wire	wire_ni01i_dataout;
	wire	wire_ni01ii_dataout;
	wire	wire_ni01il_dataout;
	wire	wire_ni01iO_dataout;
	wire	wire_ni01l_dataout;
	wire	wire_ni01li_dataout;
	wire	wire_ni01ll_dataout;
	wire	wire_ni01lO_dataout;
	wire	wire_ni01O_dataout;
	wire	wire_ni01Oi_dataout;
	wire	wire_ni01Ol_dataout;
	wire	wire_ni01OO_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0i0i_dataout;
	wire	wire_ni0i0l_dataout;
	wire	wire_ni0i0O_dataout;
	wire	wire_ni0i1i_dataout;
	wire	wire_ni0i1l_dataout;
	wire	wire_ni0i1O_dataout;
	wire	wire_ni0ii_dataout;
	wire	wire_ni0iii_dataout;
	wire	wire_ni0iil_dataout;
	wire	wire_ni0iiO_dataout;
	wire	wire_ni0ili_dataout;
	wire	wire_ni0ill_dataout;
	wire	wire_ni0ilO_dataout;
	wire	wire_ni0iO_dataout;
	wire	wire_ni0iOi_dataout;
	wire	wire_ni0iOl_dataout;
	wire	wire_ni0iOO_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0l0i_dataout;
	wire	wire_ni0l0l_dataout;
	wire	wire_ni0l0O_dataout;
	wire	wire_ni0l1i_dataout;
	wire	wire_ni0l1l_dataout;
	wire	wire_ni0l1O_dataout;
	wire	wire_ni0li_dataout;
	wire	wire_ni0lii_dataout;
	wire	wire_ni0lil_dataout;
	wire	wire_ni0liO_dataout;
	wire	wire_ni0ll_dataout;
	wire	wire_ni0lli_dataout;
	wire	wire_ni0lll_dataout;
	wire	wire_ni0llO_dataout;
	wire	wire_ni0lO_dataout;
	wire	wire_ni0lOi_dataout;
	wire	wire_ni0lOl_dataout;
	wire	wire_ni0lOO_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0O0i_dataout;
	wire	wire_ni0O0l_dataout;
	wire	wire_ni0O0O_dataout;
	wire	wire_ni0O1i_dataout;
	wire	wire_ni0O1l_dataout;
	wire	wire_ni0O1O_dataout;
	wire	wire_ni0Oi_dataout;
	wire	wire_ni0Oii_dataout;
	wire	wire_ni0Oil_dataout;
	wire	wire_ni0OiO_dataout;
	wire	wire_ni0Ol_dataout;
	wire	wire_ni0Oli_dataout;
	wire	wire_ni0Oll_dataout;
	wire	wire_ni0OlO_dataout;
	wire	wire_ni0OO_dataout;
	wire	wire_ni0OOi_dataout;
	wire	wire_ni0OOl_dataout;
	wire	wire_ni0OOO_dataout;
	wire	wire_ni100i_dataout;
	wire	wire_ni100l_dataout;
	wire	wire_ni100O_dataout;
	wire	wire_ni101i_dataout;
	wire	wire_ni101l_dataout;
	wire	wire_ni101O_dataout;
	wire	wire_ni10i_dataout;
	wire	wire_ni10ii_dataout;
	wire	wire_ni10il_dataout;
	wire	wire_ni10iO_dataout;
	wire	wire_ni10l_dataout;
	wire	wire_ni10li_dataout;
	wire	wire_ni10ll_dataout;
	wire	wire_ni10lO_dataout;
	wire	wire_ni10O_dataout;
	wire	wire_ni10Oi_dataout;
	wire	wire_ni10Ol_dataout;
	wire	wire_ni10OO_dataout;
	wire	wire_ni110i_dataout;
	wire	wire_ni110l_dataout;
	wire	wire_ni110O_dataout;
	wire	wire_ni111i_dataout;
	wire	wire_ni111l_dataout;
	wire	wire_ni111O_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni11ii_dataout;
	wire	wire_ni11il_dataout;
	wire	wire_ni11iO_dataout;
	wire	wire_ni11l_dataout;
	wire	wire_ni11li_dataout;
	wire	wire_ni11ll_dataout;
	wire	wire_ni11lO_dataout;
	wire	wire_ni11O_dataout;
	wire	wire_ni11Oi_dataout;
	wire	wire_ni11Ol_dataout;
	wire	wire_ni11OO_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1i0i_dataout;
	wire	wire_ni1i0l_dataout;
	wire	wire_ni1i0O_dataout;
	wire	wire_ni1i1i_dataout;
	wire	wire_ni1i1l_dataout;
	wire	wire_ni1i1O_dataout;
	wire	wire_ni1ii_dataout;
	wire	wire_ni1iii_dataout;
	wire	wire_ni1iil_dataout;
	wire	wire_ni1iiO_dataout;
	wire	wire_ni1il_dataout;
	wire	wire_ni1ili_dataout;
	wire	wire_ni1ill_dataout;
	wire	wire_ni1ilO_dataout;
	wire	wire_ni1iOi_dataout;
	wire	wire_ni1iOl_dataout;
	wire	wire_ni1iOO_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1l0i_dataout;
	wire	wire_ni1l0l_dataout;
	wire	wire_ni1l0O_dataout;
	wire	wire_ni1l1i_dataout;
	wire	wire_ni1l1l_dataout;
	wire	wire_ni1l1O_dataout;
	wire	wire_ni1lii_dataout;
	wire	wire_ni1lil_dataout;
	wire	wire_ni1liO_dataout;
	wire	wire_ni1lli_dataout;
	wire	wire_ni1lll_dataout;
	wire	wire_ni1llO_dataout;
	wire	wire_ni1lOi_dataout;
	wire	wire_ni1lOl_dataout;
	wire	wire_ni1lOO_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1O0i_dataout;
	wire	wire_ni1O0l_dataout;
	wire	wire_ni1O0O_dataout;
	wire	wire_ni1O1i_dataout;
	wire	wire_ni1O1l_dataout;
	wire	wire_ni1O1O_dataout;
	wire	wire_ni1Oi_dataout;
	wire	wire_ni1Oii_dataout;
	wire	wire_ni1Oil_dataout;
	wire	wire_ni1OiO_dataout;
	wire	wire_ni1Ol_dataout;
	wire	wire_ni1Oli_dataout;
	wire	wire_ni1Oll_dataout;
	wire	wire_ni1OlO_dataout;
	wire	wire_ni1OO_dataout;
	wire	wire_ni1OOi_dataout;
	wire	wire_ni1OOl_dataout;
	wire	wire_ni1OOO_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii01i_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii10i_dataout;
	wire	wire_nii10l_dataout;
	wire	wire_nii10O_dataout;
	wire	wire_nii11i_dataout;
	wire	wire_nii11l_dataout;
	wire	wire_nii11O_dataout;
	wire	wire_nii1i_dataout;
	wire	wire_nii1ii_dataout;
	wire	wire_nii1il_dataout;
	wire	wire_nii1iO_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1li_dataout;
	wire	wire_nii1ll_dataout;
	wire	wire_nii1lO_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_nii1Oi_dataout;
	wire	wire_nii1Ol_dataout;
	wire	wire_nii1OO_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil00i_dataout;
	wire	wire_nil00l_dataout;
	wire	wire_nil00O_dataout;
	wire	wire_nil01i_dataout;
	wire	wire_nil01l_dataout;
	wire	wire_nil01O_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0ii_dataout;
	wire	wire_nil0il_dataout;
	wire	wire_nil0iO_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil0li_dataout;
	wire	wire_nil0ll_dataout;
	wire	wire_nil0lO_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil0Oi_dataout;
	wire	wire_nil0Ol_dataout;
	wire	wire_nil0OO_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1li_dataout;
	wire	wire_nil1ll_dataout;
	wire	wire_nil1lO_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nil1Oi_dataout;
	wire	wire_nil1Ol_dataout;
	wire	wire_nil1OO_dataout;
	wire	wire_nili_dataout;
	wire	wire_nili0i_dataout;
	wire	wire_nili0l_dataout;
	wire	wire_nili1i_dataout;
	wire	wire_nili1l_dataout;
	wire	wire_nili1O_dataout;
	wire	wire_nilii_dataout;
	wire	wire_niliil_dataout;
	wire	wire_niliiO_dataout;
	wire	wire_nilil_dataout;
	wire	wire_nilili_dataout;
	wire	wire_nilill_dataout;
	wire	wire_nililO_dataout;
	wire	wire_niliO_dataout;
	wire	wire_niliOl_dataout;
	wire	wire_niliOO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nill0i_dataout;
	wire	wire_nill0l_dataout;
	wire	wire_nill0O_dataout;
	wire	wire_nill1i_dataout;
	wire	wire_nill1l_dataout;
	wire	wire_nill1O_dataout;
	wire	wire_nilli_dataout;
	wire	wire_nillii_dataout;
	wire	wire_nillil_dataout;
	wire	wire_nilll_dataout;
	wire	wire_nilllO_dataout;
	wire	wire_nillOi_dataout;
	wire	wire_nillOl_dataout;
	wire	wire_nillOO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilO0i_dataout;
	wire	wire_nilO0l_dataout;
	wire	wire_nilO0O_dataout;
	wire	wire_nilO1i_dataout;
	wire	wire_nilOii_dataout;
	wire	wire_nilOil_dataout;
	wire	wire_nilOiO_dataout;
	wire	wire_nilOli_dataout;
	wire	wire_nilOll_dataout;
	wire	wire_nilOlO_dataout;
	wire	wire_nilOOi_dataout;
	wire	wire_nilOOl_dataout;
	wire	wire_nilOOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO00i_dataout;
	wire	wire_niO00l_dataout;
	wire	wire_niO00O_dataout;
	wire	wire_niO01i_dataout;
	wire	wire_niO01l_dataout;
	wire	wire_niO01O_dataout;
	wire	wire_niO0ii_dataout;
	wire	wire_niO0il_dataout;
	wire	wire_niO0iO_dataout;
	wire	wire_niO0li_dataout;
	wire	wire_niO0ll_dataout;
	wire	wire_niO0lO_dataout;
	wire	wire_niO0Oi_dataout;
	wire	wire_niO0Ol_dataout;
	wire	wire_niO0OO_dataout;
	wire	wire_niO10i_dataout;
	wire	wire_niO10l_dataout;
	wire	wire_niO10O_dataout;
	wire	wire_niO11i_dataout;
	wire	wire_niO11l_dataout;
	wire	wire_niO11O_dataout;
	wire	wire_niO1ii_dataout;
	wire	wire_niO1il_dataout;
	wire	wire_niO1iO_dataout;
	wire	wire_niO1li_dataout;
	wire	wire_niO1ll_dataout;
	wire	wire_niO1lO_dataout;
	wire	wire_niO1Oi_dataout;
	wire	wire_niO1Ol_dataout;
	wire	wire_niO1OO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOi0i_dataout;
	wire	wire_niOi0l_dataout;
	wire	wire_niOi0O_dataout;
	wire	wire_niOi1i_dataout;
	wire	wire_niOi1l_dataout;
	wire	wire_niOi1O_dataout;
	wire	wire_niOiii_dataout;
	wire	wire_niOiil_dataout;
	wire	wire_niOiiO_dataout;
	wire	wire_niOili_dataout;
	wire	wire_niOill_dataout;
	wire	wire_niOilO_dataout;
	wire	wire_niOiOi_dataout;
	wire	wire_niOiOl_dataout;
	wire	wire_niOiOO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOl0i_dataout;
	wire	wire_niOl0l_dataout;
	wire	wire_niOl0O_dataout;
	wire	wire_niOl1i_dataout;
	wire	wire_niOl1l_dataout;
	wire	wire_niOl1O_dataout;
	wire	wire_niOlii_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl001i_dataout;
	wire	wire_nl001l_dataout;
	wire	wire_nl001O_dataout;
	wire	wire_nl00li_dataout;
	wire	wire_nl00Ol_dataout;
	wire	wire_nl00OO_dataout;
	wire	wire_nl010i_dataout;
	wire	wire_nl010l_dataout;
	wire	wire_nl010O_dataout;
	wire	wire_nl011i_dataout;
	wire	wire_nl011l_dataout;
	wire	wire_nl011O_dataout;
	wire	wire_nl01ii_dataout;
	wire	wire_nl01il_dataout;
	wire	wire_nl01li_dataout;
	wire	wire_nl01ll_dataout;
	wire	wire_nl01lO_dataout;
	wire	wire_nl01Oi_dataout;
	wire	wire_nl01Ol_dataout;
	wire	wire_nl01OO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0i0O_dataout;
	wire	wire_nl0i1O_dataout;
	wire	wire_nl0iil_dataout;
	wire	wire_nl0iiO_dataout;
	wire	wire_nl0ill_dataout;
	wire	wire_nl0iOO_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0l0i_dataout;
	wire	wire_nl0l1i_dataout;
	wire	wire_nl0lii_dataout;
	wire	wire_nl0liO_dataout;
	wire	wire_nl0lli_dataout;
	wire	wire_nl0llO_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl0Oii_dataout;
	wire	wire_nl0Oll_dataout;
	wire	wire_nl10l_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1ilO_dataout;
	wire	wire_nl1iOi_dataout;
	wire	wire_nl1iOl_dataout;
	wire	wire_nl1iOO_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1l0i_dataout;
	wire	wire_nl1l0l_dataout;
	wire	wire_nl1l0O_dataout;
	wire	wire_nl1l1i_dataout;
	wire	wire_nl1l1l_dataout;
	wire	wire_nl1l1O_dataout;
	wire	wire_nl1lii_dataout;
	wire	wire_nl1lil_dataout;
	wire	wire_nl1liO_dataout;
	wire	wire_nl1lli_dataout;
	wire	wire_nl1lll_dataout;
	wire	wire_nl1llO_dataout;
	wire	wire_nl1lOi_dataout;
	wire	wire_nl1lOl_dataout;
	wire	wire_nl1lOO_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1O0i_dataout;
	wire	wire_nl1O0l_dataout;
	wire	wire_nl1O0O_dataout;
	wire	wire_nl1O1i_dataout;
	wire	wire_nl1O1l_dataout;
	wire	wire_nl1O1O_dataout;
	wire	wire_nl1Oii_dataout;
	wire	wire_nl1OiO_dataout;
	wire	wire_nl1Oli_dataout;
	wire	wire_nl1Oll_dataout;
	wire	wire_nl1OlO_dataout;
	wire	wire_nl1OOi_dataout;
	wire	wire_nl1OOl_dataout;
	wire	wire_nl1OOO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli00O_dataout;
	wire	wire_nli0iO_dataout;
	wire	wire_nli0Oi_dataout;
	wire	wire_nli100O_dataout;
	wire	wire_nli10ii_dataout;
	wire	wire_nli10li_dataout;
	wire	wire_nli10ll_dataout;
	wire	wire_nli10Ol_dataout;
	wire	wire_nli10OO_dataout;
	wire	wire_nli11l_dataout;
	wire	wire_nli1i0i_dataout;
	wire	wire_nli1i0l_dataout;
	wire	wire_nli1i0O_dataout;
	wire	wire_nli1i1i_dataout;
	wire	wire_nli1i1l_dataout;
	wire	wire_nli1i1O_dataout;
	wire	wire_nli1ii_dataout;
	wire	wire_nli1iii_dataout;
	wire	wire_nli1iil_dataout;
	wire	wire_nli1iiO_dataout;
	wire	wire_nli1il_dataout;
	wire	wire_nli1ili_dataout;
	wire	wire_nli1ill_dataout;
	wire	wire_nli1ilO_dataout;
	wire	wire_nli1iOi_dataout;
	wire	wire_nli1iOl_dataout;
	wire	wire_nli1liO_dataout;
	wire	wire_nli1lli_dataout;
	wire	wire_nli1lll_dataout;
	wire	wire_nli1llO_dataout;
	wire	wire_nli1lOi_dataout;
	wire	wire_nli1lOl_dataout;
	wire	wire_nli1lOO_dataout;
	wire	wire_nli1O1i_dataout;
	wire	wire_nli1Ol_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlii1l_dataout;
	wire	wire_nlii1O_dataout;
	wire	wire_nliiii_dataout;
	wire	wire_nliiOl_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlil0O_dataout;
	wire	wire_nlil1l_dataout;
	wire	wire_nlilli_dataout;
	wire	wire_nlilll_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOi0l_dataout;
	wire	wire_nlOi0O_dataout;
	wire	wire_nlOi1l_dataout;
	wire	wire_nlOi1O_dataout;
	wire	wire_nlOiiO_dataout;
	wire	wire_nlOili_dataout;
	wire	wire_nlOill_dataout;
	wire	wire_nlOilO_dataout;
	wire	wire_nlOiOi_dataout;
	wire	wire_nlOiOl_dataout;
	wire	wire_nlOiOO_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOl0i_dataout;
	wire	wire_nlOl0l_dataout;
	wire	wire_nlOl0O_dataout;
	wire	wire_nlOl1i_dataout;
	wire	wire_nlOl1l_dataout;
	wire	wire_nlOl1O_dataout;
	wire	wire_nlOlii_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOlOl_dataout;
	wire	wire_nlOlOO_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOO1i_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOlO_dataout;
	wire	wire_nlOOO_dataout;
	wire	wire_nlOOOi_dataout;
	wire	wire_nlOOOl_dataout;
	wire  [3:0]   wire_n0l0lO_o;
	wire  [3:0]   wire_n0O11i_o;
	wire  [7:0]   wire_n10Oli_o;
	wire  [15:0]   wire_nil1iO_o;
	wire  [15:0]   wire_nilO1O_o;
	wire  [7:0]   wire_nl00iO_o;
	wire  [255:0]   wire_nl0lO0l_o;
	wire  [255:0]   wire_nl0lOiO_o;
	wire  [63:0]   wire_nl10i_o;
	wire  [63:0]   wire_nll0i_o;
	wire  wire_n1000i_o;
	wire  wire_n1000l_o;
	wire  wire_n1000O_o;
	wire  wire_n1001i_o;
	wire  wire_n1001l_o;
	wire  wire_n1001O_o;
	wire  wire_n100ii_o;
	wire  wire_n100il_o;
	wire  wire_n100iO_o;
	wire  wire_n100li_o;
	wire  wire_n100ll_o;
	wire  wire_n100lO_o;
	wire  wire_n100Oi_o;
	wire  wire_n100Ol_o;
	wire  wire_n100OO_o;
	wire  wire_n1010l_o;
	wire  wire_n1010O_o;
	wire  wire_n101ii_o;
	wire  wire_n101il_o;
	wire  wire_n101iO_o;
	wire  wire_n101li_o;
	wire  wire_n101ll_o;
	wire  wire_n101lO_o;
	wire  wire_n101Oi_o;
	wire  wire_n101Ol_o;
	wire  wire_n101OO_o;
	wire  wire_n10i0i_o;
	wire  wire_n10i0l_o;
	wire  wire_n10i0O_o;
	wire  wire_n10i1i_o;
	wire  wire_n10i1l_o;
	wire  wire_n10i1O_o;
	wire  wire_n10iii_o;
	wire  wire_n10iil_o;
	wire  wire_n10iiO_o;
	wire  wire_n10ili_o;
	wire  wire_n10ill_o;
	wire  wire_n10ilO_o;
	wire  wire_n10iOi_o;
	wire  wire_n10iOl_o;
	wire  wire_n10iOO_o;
	wire  wire_n10l0i_o;
	wire  wire_n10l0l_o;
	wire  wire_n10l0O_o;
	wire  wire_n10l1i_o;
	wire  wire_n10l1l_o;
	wire  wire_n10l1O_o;
	wire  wire_n10lii_o;
	wire  wire_n10lil_o;
	wire  wire_n10liO_o;
	wire  wire_n10lli_o;
	wire  wire_n10lll_o;
	wire  wire_n10llO_o;
	wire  wire_n10lOi_o;
	wire  wire_n10lOl_o;
	wire  wire_n10lOO_o;
	wire  wire_n10O0i_o;
	wire  wire_n10O0l_o;
	wire  wire_n10O0O_o;
	wire  wire_n10O1i_o;
	wire  wire_n10O1l_o;
	wire  wire_n10O1O_o;
	wire  wire_n10Oii_o;
	wire  wire_n10Oil_o;
	wire  wire_nii00i_o;
	wire  wire_nii00l_o;
	wire  wire_nii00O_o;
	wire  wire_nii01l_o;
	wire  wire_nii01O_o;
	wire  wire_nii0ii_o;
	wire  wire_nii0il_o;
	wire  wire_nii0iO_o;
	wire  wire_nii0li_o;
	wire  wire_nii0ll_o;
	wire  wire_nii0lO_o;
	wire  wire_nii0Oi_o;
	wire  wire_nii0Ol_o;
	wire  wire_nii0OO_o;
	wire  wire_niii0i_o;
	wire  wire_niii0l_o;
	wire  wire_niii0O_o;
	wire  wire_niii1i_o;
	wire  wire_niii1l_o;
	wire  wire_niii1O_o;
	wire  wire_niiiii_o;
	wire  wire_niiiil_o;
	wire  wire_niiiiO_o;
	wire  wire_niiili_o;
	wire  wire_niiill_o;
	wire  wire_niiilO_o;
	wire  wire_niiiOi_o;
	wire  wire_niiiOl_o;
	wire  wire_niiiOO_o;
	wire  wire_niil0i_o;
	wire  wire_niil0l_o;
	wire  wire_niil0O_o;
	wire  wire_niil1i_o;
	wire  wire_niil1l_o;
	wire  wire_niil1O_o;
	wire  wire_niilii_o;
	wire  wire_niilil_o;
	wire  wire_niiliO_o;
	wire  wire_niilli_o;
	wire  wire_niilll_o;
	wire  wire_niillO_o;
	wire  wire_niilOi_o;
	wire  wire_niilOl_o;
	wire  wire_niilOO_o;
	wire  wire_niiO0i_o;
	wire  wire_niiO0l_o;
	wire  wire_niiO0O_o;
	wire  wire_niiO1i_o;
	wire  wire_niiO1l_o;
	wire  wire_niiO1O_o;
	wire  wire_niiOii_o;
	wire  wire_niiOil_o;
	wire  wire_niiOiO_o;
	wire  wire_niiOli_o;
	wire  wire_niiOll_o;
	wire  wire_niiOlO_o;
	wire  wire_niiOOi_o;
	wire  wire_niiOOl_o;
	wire  wire_niiOOO_o;
	wire  wire_nil10i_o;
	wire  wire_nil10l_o;
	wire  wire_nil11i_o;
	wire  wire_nil11l_o;
	wire  wire_nil11O_o;
	wire  wire_nili0O_o;
	wire  wire_nilliO_o;
	wire  wire_niOil_o;
	wire  wire_niOlil_o;
	wire  wire_niOliO_o;
	wire  wire_niOlli_o;
	wire  wire_niOlll_o;
	wire  wire_niOllO_o;
	wire  wire_niOlOi_o;
	wire  wire_niOlOl_o;
	wire  wire_niOlOO_o;
	wire  wire_niOO0i_o;
	wire  wire_niOO0l_o;
	wire  wire_niOO0O_o;
	wire  wire_niOO1i_o;
	wire  wire_niOO1l_o;
	wire  wire_niOO1O_o;
	wire  wire_niOOii_o;
	wire  wire_niOOil_o;
	wire  wire_niOOiO_o;
	wire  wire_niOOli_o;
	wire  wire_niOOll_o;
	wire  wire_niOOlO_o;
	wire  wire_niOOOi_o;
	wire  wire_niOOOl_o;
	wire  wire_niOOOO_o;
	wire  wire_nl000i_o;
	wire  wire_nl000l_o;
	wire  wire_nl000O_o;
	wire  wire_nl00ii_o;
	wire  wire_nl01iO_o;
	wire  wire_nl100i_o;
	wire  wire_nl100l_o;
	wire  wire_nl100O_o;
	wire  wire_nl101i_o;
	wire  wire_nl101l_o;
	wire  wire_nl101O_o;
	wire  wire_nl10ii_o;
	wire  wire_nl10il_o;
	wire  wire_nl10iO_o;
	wire  wire_nl10li_o;
	wire  wire_nl10ll_o;
	wire  wire_nl10lO_o;
	wire  wire_nl10Oi_o;
	wire  wire_nl10Ol_o;
	wire  wire_nl10OO_o;
	wire  wire_nl110i_o;
	wire  wire_nl110l_o;
	wire  wire_nl110O_o;
	wire  wire_nl111i_o;
	wire  wire_nl111l_o;
	wire  wire_nl111O_o;
	wire  wire_nl11ii_o;
	wire  wire_nl11il_o;
	wire  wire_nl11iO_o;
	wire  wire_nl11li_o;
	wire  wire_nl11ll_o;
	wire  wire_nl11lO_o;
	wire  wire_nl11Oi_o;
	wire  wire_nl11Ol_o;
	wire  wire_nl11OO_o;
	wire  wire_nl1i0i_o;
	wire  wire_nl1i0l_o;
	wire  wire_nl1i0O_o;
	wire  wire_nl1i1i_o;
	wire  wire_nl1i1l_o;
	wire  wire_nl1i1O_o;
	wire  wire_nl1iii_o;
	wire  wire_nl1iil_o;
	wire  wire_nl1iiO_o;
	wire  wire_nl1ili_o;
	wire  wire_nl1ill_o;
	wire  wire_nl1Oil_o;
	wire  wire_nliil_o;
	wire  [64:0]   wire_nl0l0ii_data_out;
	wire  [1:0]   wire_nl0l00O_byte_des_bo_3g_start;
	wire  [63:0]   wire_nl0l00O_byte_des_fifo_data_in;
	wire  nl0000i;
	wire  nl0000l;
	wire  nl0000O;
	wire  nl0001l;
	wire  nl0001O;
	wire  nl000ii;
	wire  nl000il;
	wire  nl000iO;
	wire  nl000li;
	wire  nl000ll;
	wire  nl000lO;
	wire  nl000Oi;
	wire  nl000Ol;
	wire  nl000OO;
	wire  nl00i0i;
	wire  nl00i0l;
	wire  nl00i0O;
	wire  nl00i1i;
	wire  nl00i1l;
	wire  nl00i1O;
	wire  nl00iii;
	wire  nl00iil;
	wire  nl00iiO;
	wire  nl00ili;
	wire  nl00ill;
	wire  nl00ilO;
	wire  nl00iOi;
	wire  nl00iOl;
	wire  nl00iOO;
	wire  nl00l0i;
	wire  nl00l0l;
	wire  nl00l0O;
	wire  nl00l1i;
	wire  nl00l1l;
	wire  nl00l1O;
	wire  nl00lii;
	wire  nl00lil;
	wire  nl00liO;
	wire  nl00lli;
	wire  nl00lll;
	wire  nl00llO;
	wire  nl00lOi;
	wire  nl00lOl;
	wire  nl00lOO;
	wire  nl00O0i;
	wire  nl00O0l;
	wire  nl00O0O;
	wire  nl00O1i;
	wire  nl00O1l;
	wire  nl00O1O;
	wire  nl00Oii;
	wire  nl00Oil;
	wire  nl00OiO;
	wire  nl00Oli;
	wire  nl00Oll;
	wire  nl00OlO;
	wire  nl00OOi;
	wire  nl00OOl;
	wire  nl00OOO;
	wire  nl0i00i;
	wire  nl0i00l;
	wire  nl0i00O;
	wire  nl0i01i;
	wire  nl0i01l;
	wire  nl0i01O;
	wire  nl0i0ii;
	wire  nl0i0il;
	wire  nl0i0iO;
	wire  nl0i0li;
	wire  nl0i0ll;
	wire  nl0i0lO;
	wire  nl0i0Oi;
	wire  nl0i0Ol;
	wire  nl0i0OO;
	wire  nl0i10i;
	wire  nl0i10l;
	wire  nl0i10O;
	wire  nl0i11i;
	wire  nl0i11l;
	wire  nl0i11O;
	wire  nl0i1ii;
	wire  nl0i1il;
	wire  nl0i1iO;
	wire  nl0i1li;
	wire  nl0i1ll;
	wire  nl0i1lO;
	wire  nl0i1Oi;
	wire  nl0i1Ol;
	wire  nl0i1OO;
	wire  nl0ii0i;
	wire  nl0ii0l;
	wire  nl0ii0O;
	wire  nl0ii1i;
	wire  nl0ii1l;
	wire  nl0ii1O;
	wire  nl0iiii;
	wire  nl0iiil;
	wire  nl0iiiO;
	wire  nl0iili;
	wire  nl0iill;
	wire  nl0iilO;
	wire  nl0iiOi;
	wire  nl0iiOl;
	wire  nl0iiOO;
	wire  nl0il0O;
	wire  nl0il1i;
	wire  nl0ilii;
	wire  nl0illO;
	wire  nl0ilOi;
	wire  nl0iO0l;
	wire  nl0iO0O;
	wire  nl0iO1l;
	wire  nl0iOii;
	wire  nl0iOiO;
	wire  nl0iOli;
	wire  nl0l01i;
	wire  nl0l1ii;
	wire  nl0l1Oi;

	initial
		nl0il0i55 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0il0i55 <= nl0il0i57;
	initial
		nl0il0i56 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0il0i56 <= (nl0il0i57 ^ nl0il0i55);
	initial
		nl0il0i57 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0il0i57 <= nl0il0i55;
	initial
		nl0il1l58 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0il1l58 <= nl0il1l60;
	initial
		nl0il1l59 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0il1l59 <= (nl0il1l60 ^ nl0il1l58);
	initial
		nl0il1l60 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0il1l60 <= nl0il1l58;
	initial
		nl0ilil52 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0ilil52 <= nl0ilil54;
	initial
		nl0ilil53 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0ilil53 <= (nl0ilil54 ^ nl0ilil52);
	initial
		nl0ilil54 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0ilil54 <= nl0ilil52;
	initial
		nl0illi49 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0illi49 <= nl0illi51;
	initial
		nl0illi50 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0illi50 <= (nl0illi51 ^ nl0illi49);
	initial
		nl0illi51 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0illi51 <= nl0illi49;
	initial
		nl0ilOl46 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0ilOl46 <= nl0ilOl48;
	initial
		nl0ilOl47 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0ilOl47 <= (nl0ilOl48 ^ nl0ilOl46);
	initial
		nl0ilOl48 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0ilOl48 <= nl0ilOl46;
	initial
		nl0ilOO43 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0ilOO43 <= nl0ilOO45;
	initial
		nl0ilOO44 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0ilOO44 <= (nl0ilOO45 ^ nl0ilOO43);
	initial
		nl0ilOO45 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0ilOO45 <= nl0ilOO43;
	initial
		nl0iO1O40 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0iO1O40 <= nl0iO1O42;
	initial
		nl0iO1O41 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0iO1O41 <= (nl0iO1O42 ^ nl0iO1O40);
	initial
		nl0iO1O42 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iO1O42 <= nl0iO1O40;
	initial
		nl0iOil37 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0iOil37 <= nl0iOil39;
	initial
		nl0iOil38 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0iOil38 <= (nl0iOil39 ^ nl0iOil37);
	initial
		nl0iOil39 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iOil39 <= nl0iOil37;
	initial
		nl0iOll34 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0iOll34 <= nl0iOll36;
	initial
		nl0iOll35 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0iOll35 <= (nl0iOll36 ^ nl0iOll34);
	initial
		nl0iOll36 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iOll36 <= nl0iOll34;
	initial
		nl0iOOi31 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0iOOi31 <= nl0iOOi33;
	initial
		nl0iOOi32 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0iOOi32 <= (nl0iOOi33 ^ nl0iOOi31);
	initial
		nl0iOOi33 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iOOi33 <= nl0iOOi31;
	initial
		nl0iOOO28 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0iOOO28 <= nl0iOOO30;
	initial
		nl0iOOO29 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0iOOO29 <= (nl0iOOO30 ^ nl0iOOO28);
	initial
		nl0iOOO30 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0iOOO30 <= nl0iOOO28;
	initial
		nl0l01l1 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l01l1 <= nl0l01l3;
	initial
		nl0l01l2 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l01l2 <= (nl0l01l3 ^ nl0l01l1);
	initial
		nl0l01l3 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l01l3 <= nl0l01l1;
	initial
		nl0l10l19 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l10l19 <= nl0l10l21;
	initial
		nl0l10l20 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l10l20 <= (nl0l10l21 ^ nl0l10l19);
	initial
		nl0l10l21 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l10l21 <= nl0l10l19;
	initial
		nl0l11i25 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l11i25 <= nl0l11i27;
	initial
		nl0l11i26 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l11i26 <= (nl0l11i27 ^ nl0l11i25);
	initial
		nl0l11i27 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l11i27 <= nl0l11i25;
	initial
		nl0l11O22 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l11O22 <= nl0l11O24;
	initial
		nl0l11O23 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l11O23 <= (nl0l11O24 ^ nl0l11O22);
	initial
		nl0l11O24 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l11O24 <= nl0l11O22;
	initial
		nl0l1il16 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l1il16 <= nl0l1il18;
	initial
		nl0l1il17 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l1il17 <= (nl0l1il18 ^ nl0l1il16);
	initial
		nl0l1il18 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l1il18 <= nl0l1il16;
	initial
		nl0l1iO13 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l1iO13 <= nl0l1iO15;
	initial
		nl0l1iO14 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l1iO14 <= (nl0l1iO15 ^ nl0l1iO13);
	initial
		nl0l1iO15 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l1iO15 <= nl0l1iO13;
	initial
		nl0l1li10 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l1li10 <= nl0l1li12;
	initial
		nl0l1li11 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l1li11 <= (nl0l1li12 ^ nl0l1li10);
	initial
		nl0l1li12 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l1li12 <= nl0l1li10;
	initial
		nl0l1ll7 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l1ll7 <= nl0l1ll9;
	initial
		nl0l1ll8 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l1ll8 <= (nl0l1ll9 ^ nl0l1ll7);
	initial
		nl0l1ll9 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l1ll9 <= nl0l1ll7;
	initial
		nl0l1Ol4 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l1Ol4 <= nl0l1Ol6;
	initial
		nl0l1Ol5 = {1{1'b1}};
	always @ ( posedge rx_wr_clk)
		  nl0l1Ol5 <= (nl0l1Ol6 ^ nl0l1Ol4);
	initial
		nl0l1Ol6 = 0;
	always @ ( posedge rx_wr_clk)
		  nl0l1Ol6 <= nl0l1Ol4;
	initial
	begin
		n110i = 0;
		nl0llOO = 0;
		nli1l0i = 0;
		nli1l0l = 0;
		nli1l0O = 0;
		nli1l1O = 0;
		nli1lii = 0;
		nli1lil = 0;
		nlilOO = 0;
		nliO0i = 0;
		nliO0l = 0;
		nliO0O = 0;
		nliO1i = 0;
		nliO1l = 0;
		nliO1O = 0;
		nliOii = 0;
		nliOil = 0;
		nliOiO = 0;
		nliOli = 0;
		nliOll = 0;
		nliOlO = 0;
		nliOOi = 0;
		nliOOl = 0;
		nliOOO = 0;
		nll00i = 0;
		nll00l = 0;
		nll00O = 0;
		nll01i = 0;
		nll01l = 0;
		nll01O = 0;
		nll0ii = 0;
		nll0il = 0;
		nll0iO = 0;
		nll0li = 0;
		nll0ll = 0;
		nll0lO = 0;
		nll0Oi = 0;
		nll0Ol = 0;
		nll0OO = 0;
		nll10i = 0;
		nll10l = 0;
		nll10O = 0;
		nll11i = 0;
		nll11l = 0;
		nll11O = 0;
		nll1ii = 0;
		nll1il = 0;
		nll1iO = 0;
		nll1li = 0;
		nll1ll = 0;
		nll1lO = 0;
		nll1Oi = 0;
		nll1Ol = 0;
		nll1OO = 0;
		nlli0i = 0;
		nlli0l = 0;
		nlli0O = 0;
		nlli1i = 0;
		nlli1l = 0;
		nlli1O = 0;
		nlliii = 0;
		nlliil = 0;
		nlliiO = 0;
		nllili = 0;
		nllill = 0;
		nllilO = 0;
		nlliOi = 0;
		nlliOl = 0;
		nlliOO = 0;
		nlll0i = 0;
		nlll0l = 0;
		nlll0O = 0;
		nlll1i = 0;
		nlll1l = 0;
		nlll1O = 0;
		nlllii = 0;
		nlllil = 0;
		nllliO = 0;
		nlllli = 0;
		nlllll = 0;
		nllllO = 0;
		nlllOi = 0;
		nlllOl = 0;
		nlllOO = 0;
		nllO0i = 0;
		nllO0l = 0;
		nllO0O = 0;
		nllO1i = 0;
		nllO1l = 0;
		nllO1O = 0;
		nllOii = 0;
		nllOil = 0;
		nllOiO = 0;
		nllOli = 0;
		nllOll = 0;
		nllOlO = 0;
		nllOOi = 0;
		nllOOl = 0;
		nllOOO = 0;
		nlO00i = 0;
		nlO00l = 0;
		nlO00O = 0;
		nlO01i = 0;
		nlO01l = 0;
		nlO01O = 0;
		nlO0ii = 0;
		nlO0il = 0;
		nlO0iO = 0;
		nlO0li = 0;
		nlO0ll = 0;
		nlO0lO = 0;
		nlO0Oi = 0;
		nlO0Ol = 0;
		nlO0OO = 0;
		nlO10i = 0;
		nlO10l = 0;
		nlO10O = 0;
		nlO11i = 0;
		nlO11l = 0;
		nlO11O = 0;
		nlO1ii = 0;
		nlO1il = 0;
		nlO1iO = 0;
		nlO1li = 0;
		nlO1ll = 0;
		nlO1lO = 0;
		nlO1Oi = 0;
		nlO1Ol = 0;
		nlO1OO = 0;
		nlOi1i = 0;
		nlOlli = 0;
		nlOO0l = 0;
		nlOO0O = 0;
		nlOOii = 0;
		nlOOil = 0;
		nlOOiO = 0;
		nlOOli = 0;
		nlOOll = 0;
	end
	always @ ( posedge rx_wr_clk or posedge wire_n110l_dataout)
	begin
		if (wire_n110l_dataout == 1'b1) 
		begin
			n110i <= 0;
			nl0llOO <= 0;
			nli1l0i <= 0;
			nli1l0l <= 0;
			nli1l0O <= 0;
			nli1l1O <= 0;
			nli1lii <= 0;
			nli1lil <= 0;
			nlilOO <= 0;
			nliO0i <= 0;
			nliO0l <= 0;
			nliO0O <= 0;
			nliO1i <= 0;
			nliO1l <= 0;
			nliO1O <= 0;
			nliOii <= 0;
			nliOil <= 0;
			nliOiO <= 0;
			nliOli <= 0;
			nliOll <= 0;
			nliOlO <= 0;
			nliOOi <= 0;
			nliOOl <= 0;
			nliOOO <= 0;
			nll00i <= 0;
			nll00l <= 0;
			nll00O <= 0;
			nll01i <= 0;
			nll01l <= 0;
			nll01O <= 0;
			nll0ii <= 0;
			nll0il <= 0;
			nll0iO <= 0;
			nll0li <= 0;
			nll0ll <= 0;
			nll0lO <= 0;
			nll0Oi <= 0;
			nll0Ol <= 0;
			nll0OO <= 0;
			nll10i <= 0;
			nll10l <= 0;
			nll10O <= 0;
			nll11i <= 0;
			nll11l <= 0;
			nll11O <= 0;
			nll1ii <= 0;
			nll1il <= 0;
			nll1iO <= 0;
			nll1li <= 0;
			nll1ll <= 0;
			nll1lO <= 0;
			nll1Oi <= 0;
			nll1Ol <= 0;
			nll1OO <= 0;
			nlli0i <= 0;
			nlli0l <= 0;
			nlli0O <= 0;
			nlli1i <= 0;
			nlli1l <= 0;
			nlli1O <= 0;
			nlliii <= 0;
			nlliil <= 0;
			nlliiO <= 0;
			nllili <= 0;
			nllill <= 0;
			nllilO <= 0;
			nlliOi <= 0;
			nlliOl <= 0;
			nlliOO <= 0;
			nlll0i <= 0;
			nlll0l <= 0;
			nlll0O <= 0;
			nlll1i <= 0;
			nlll1l <= 0;
			nlll1O <= 0;
			nlllii <= 0;
			nlllil <= 0;
			nllliO <= 0;
			nlllli <= 0;
			nlllll <= 0;
			nllllO <= 0;
			nlllOi <= 0;
			nlllOl <= 0;
			nlllOO <= 0;
			nllO0i <= 0;
			nllO0l <= 0;
			nllO0O <= 0;
			nllO1i <= 0;
			nllO1l <= 0;
			nllO1O <= 0;
			nllOii <= 0;
			nllOil <= 0;
			nllOiO <= 0;
			nllOli <= 0;
			nllOll <= 0;
			nllOlO <= 0;
			nllOOi <= 0;
			nllOOl <= 0;
			nllOOO <= 0;
			nlO00i <= 0;
			nlO00l <= 0;
			nlO00O <= 0;
			nlO01i <= 0;
			nlO01l <= 0;
			nlO01O <= 0;
			nlO0ii <= 0;
			nlO0il <= 0;
			nlO0iO <= 0;
			nlO0li <= 0;
			nlO0ll <= 0;
			nlO0lO <= 0;
			nlO0Oi <= 0;
			nlO0Ol <= 0;
			nlO0OO <= 0;
			nlO10i <= 0;
			nlO10l <= 0;
			nlO10O <= 0;
			nlO11i <= 0;
			nlO11l <= 0;
			nlO11O <= 0;
			nlO1ii <= 0;
			nlO1il <= 0;
			nlO1iO <= 0;
			nlO1li <= 0;
			nlO1ll <= 0;
			nlO1lO <= 0;
			nlO1Oi <= 0;
			nlO1Ol <= 0;
			nlO1OO <= 0;
			nlOi1i <= 0;
			nlOlli <= 0;
			nlOO0l <= 0;
			nlOO0O <= 0;
			nlOOii <= 0;
			nlOOil <= 0;
			nlOOiO <= 0;
			nlOOli <= 0;
			nlOOll <= 0;
		end
		else 
		begin
			n110i <= pld_wr_dis;
			nl0llOO <= wire_nli1O1i_dataout;
			nli1l0i <= wire_nli1lll_dataout;
			nli1l0l <= wire_nli1llO_dataout;
			nli1l0O <= wire_nli1lOi_dataout;
			nli1l1O <= wire_nli1lli_dataout;
			nli1lii <= wire_nli1lOl_dataout;
			nli1lil <= wire_nli1lOO_dataout;
			nlilOO <= wire_nlOiiO_dataout;
			nliO0i <= wire_nlOi1l_dataout;
			nliO0l <= nllliO;
			nliO0O <= nlllli;
			nliO1i <= wire_nlOili_dataout;
			nliO1l <= wire_nlOill_dataout;
			nliO1O <= wire_nlOilO_dataout;
			nliOii <= nlllll;
			nliOil <= nllllO;
			nliOiO <= nlllOi;
			nliOli <= nlllOl;
			nliOll <= nlllOO;
			nliOlO <= nllO1i;
			nliOOi <= nllO1l;
			nliOOl <= nllO1O;
			nliOOO <= nllO0i;
			nll00i <= nlO1il;
			nll00l <= nlO1iO;
			nll00O <= nlO1li;
			nll01i <= nlO10l;
			nll01l <= nlO10O;
			nll01O <= nlO1ii;
			nll0ii <= nlO1ll;
			nll0il <= nlO1lO;
			nll0iO <= nlO1Oi;
			nll0li <= nlO1Ol;
			nll0ll <= nlO1OO;
			nll0lO <= nlO01i;
			nll0Oi <= nlO01l;
			nll0Ol <= nlO01O;
			nll0OO <= nlO00i;
			nll10i <= nllOil;
			nll10l <= nllOiO;
			nll10O <= nllOli;
			nll11i <= nllO0l;
			nll11l <= nllO0O;
			nll11O <= nllOii;
			nll1ii <= nllOll;
			nll1il <= nllOlO;
			nll1iO <= nllOOi;
			nll1li <= nllOOl;
			nll1ll <= nllOOO;
			nll1lO <= nlO11i;
			nll1Oi <= nlO11l;
			nll1Ol <= nlO11O;
			nll1OO <= nlO10i;
			nlli0i <= nlO0il;
			nlli0l <= nlO0iO;
			nlli0O <= nlO0li;
			nlli1i <= nlO00l;
			nlli1l <= nlO00O;
			nlli1O <= nlO0ii;
			nlliii <= nlO0ll;
			nlliil <= wire_nl0l00O_byte_des_fifo_data_in[0];
			nlliiO <= wire_nl0l00O_byte_des_fifo_data_in[1];
			nllili <= wire_nl0l00O_byte_des_fifo_data_in[2];
			nllill <= wire_nl0l00O_byte_des_fifo_data_in[3];
			nllilO <= wire_nl0l00O_byte_des_fifo_data_in[4];
			nlliOi <= wire_nl0l00O_byte_des_fifo_data_in[5];
			nlliOl <= wire_nl0l00O_byte_des_fifo_data_in[6];
			nlliOO <= wire_nl0l00O_byte_des_fifo_data_in[7];
			nlll0i <= wire_nl0l00O_byte_des_fifo_data_in[11];
			nlll0l <= wire_nl0l00O_byte_des_fifo_data_in[12];
			nlll0O <= wire_nl0l00O_byte_des_fifo_data_in[13];
			nlll1i <= wire_nl0l00O_byte_des_fifo_data_in[8];
			nlll1l <= wire_nl0l00O_byte_des_fifo_data_in[9];
			nlll1O <= wire_nl0l00O_byte_des_fifo_data_in[10];
			nlllii <= wire_nl0l00O_byte_des_fifo_data_in[14];
			nlllil <= wire_nl0l00O_byte_des_fifo_data_in[15];
			nllliO <= wire_nl0l00O_byte_des_fifo_data_in[16];
			nlllli <= wire_nl0l00O_byte_des_fifo_data_in[17];
			nlllll <= wire_nl0l00O_byte_des_fifo_data_in[18];
			nllllO <= wire_nl0l00O_byte_des_fifo_data_in[19];
			nlllOi <= wire_nl0l00O_byte_des_fifo_data_in[20];
			nlllOl <= wire_nl0l00O_byte_des_fifo_data_in[21];
			nlllOO <= wire_nl0l00O_byte_des_fifo_data_in[22];
			nllO0i <= wire_nl0l00O_byte_des_fifo_data_in[26];
			nllO0l <= wire_nl0l00O_byte_des_fifo_data_in[27];
			nllO0O <= wire_nl0l00O_byte_des_fifo_data_in[28];
			nllO1i <= wire_nl0l00O_byte_des_fifo_data_in[23];
			nllO1l <= wire_nl0l00O_byte_des_fifo_data_in[24];
			nllO1O <= wire_nl0l00O_byte_des_fifo_data_in[25];
			nllOii <= wire_nl0l00O_byte_des_fifo_data_in[29];
			nllOil <= wire_nl0l00O_byte_des_fifo_data_in[30];
			nllOiO <= wire_nl0l00O_byte_des_fifo_data_in[31];
			nllOli <= wire_nl0l00O_byte_des_fifo_data_in[32];
			nllOll <= wire_nl0l00O_byte_des_fifo_data_in[33];
			nllOlO <= wire_nl0l00O_byte_des_fifo_data_in[34];
			nllOOi <= wire_nl0l00O_byte_des_fifo_data_in[35];
			nllOOl <= wire_nl0l00O_byte_des_fifo_data_in[36];
			nllOOO <= wire_nl0l00O_byte_des_fifo_data_in[37];
			nlO00i <= wire_nl0l00O_byte_des_fifo_data_in[56];
			nlO00l <= wire_nl0l00O_byte_des_fifo_data_in[57];
			nlO00O <= wire_nl0l00O_byte_des_fifo_data_in[58];
			nlO01i <= wire_nl0l00O_byte_des_fifo_data_in[53];
			nlO01l <= wire_nl0l00O_byte_des_fifo_data_in[54];
			nlO01O <= wire_nl0l00O_byte_des_fifo_data_in[55];
			nlO0ii <= wire_nl0l00O_byte_des_fifo_data_in[59];
			nlO0il <= wire_nl0l00O_byte_des_fifo_data_in[60];
			nlO0iO <= wire_nl0l00O_byte_des_fifo_data_in[61];
			nlO0li <= wire_nl0l00O_byte_des_fifo_data_in[62];
			nlO0ll <= wire_nl0l00O_byte_des_fifo_data_in[63];
			nlO0lO <= wire_nlOl1l_dataout;
			nlO0Oi <= wire_nlOl1O_dataout;
			nlO0Ol <= wire_nlOi0l_dataout;
			nlO0OO <= nlOi1i;
			nlO10i <= wire_nl0l00O_byte_des_fifo_data_in[41];
			nlO10l <= wire_nl0l00O_byte_des_fifo_data_in[42];
			nlO10O <= wire_nl0l00O_byte_des_fifo_data_in[43];
			nlO11i <= wire_nl0l00O_byte_des_fifo_data_in[38];
			nlO11l <= wire_nl0l00O_byte_des_fifo_data_in[39];
			nlO11O <= wire_nl0l00O_byte_des_fifo_data_in[40];
			nlO1ii <= wire_nl0l00O_byte_des_fifo_data_in[44];
			nlO1il <= wire_nl0l00O_byte_des_fifo_data_in[45];
			nlO1iO <= wire_nl0l00O_byte_des_fifo_data_in[46];
			nlO1li <= wire_nl0l00O_byte_des_fifo_data_in[47];
			nlO1ll <= wire_nl0l00O_byte_des_fifo_data_in[48];
			nlO1lO <= wire_nl0l00O_byte_des_fifo_data_in[49];
			nlO1Oi <= wire_nl0l00O_byte_des_fifo_data_in[50];
			nlO1Ol <= wire_nl0l00O_byte_des_fifo_data_in[51];
			nlO1OO <= wire_nl0l00O_byte_des_fifo_data_in[52];
			nlOi1i <= nlOlli;
			nlOlli <= bytordplden;
			nlOO0l <= wire_nlOOlO_dataout;
			nlOO0O <= wire_nlOOOl_dataout;
			nlOOii <= nlOOil;
			nlOOil <= nl0i1li;
			nlOOiO <= (nlOOll ^ nlOOli);
			nlOOli <= nlOOll;
			nlOOll <= n110i;
		end
	end
	initial
	begin
		n11O0l = 0;
		n11O1O = 0;
	end
	always @ ( posedge rx_rd_clk or posedge nl0l01i)
	begin
		if (nl0l01i == 1'b1) 
		begin
			n11O0l <= 1;
			n11O1O <= 1;
		end
		else 
		begin
			n11O0l <= nl000ii;
			n11O1O <= n11O0l;
		end
	end
	initial
	begin
		n11O1l = 0;
	end
	always @ ( posedge clk_2 or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n11O1l <= 1;
		end
		else 
		begin
			n11O1l <= wire_n11OOi_dataout;
		end
	end
	initial
	begin
		n11O0O = 0;
		n11Oil = 0;
	end
	always @ ( posedge rx_wr_clk or posedge nl0l01i)
	begin
		if (nl0l01i == 1'b1) 
		begin
			n11O0O <= 1;
			n11Oil <= 1;
		end
		else 
		begin
			n11O0O <= n11Oil;
			n11Oil <= nl000ii;
		end
	end
	initial
	begin
		n100i = 0;
		n100l = 0;
		n100O = 0;
		n101i = 0;
		n101l = 0;
		n101O = 0;
		n10ii = 0;
		n10il = 0;
		n10iO = 0;
		n10li = 0;
		n10ll = 0;
		n10lO = 0;
		n10Oi = 0;
		n10Ol = 0;
		n10OO = 0;
		n110O = 0;
		n11ii = 0;
		n11il = 0;
		n11iO = 0;
		n11li = 0;
		n11ll = 0;
		n11lO = 0;
		n11Oi = 0;
		n11OiO = 0;
		n11Ol = 0;
		n11Oli = 0;
		n11Oll = 0;
		n11OlO = 0;
		n11OO = 0;
		n1i0i = 0;
		n1i0l = 0;
		n1i0O = 0;
		n1i1i = 0;
		n1i1l = 0;
		n1i1O = 0;
		n1iii = 0;
		n1iil = 0;
		n1iiO = 0;
		n1ili = 0;
		n1ill = 0;
		n1ilO = 0;
		n1iOi = 0;
		n1iOl = 0;
		n1iOO = 0;
		n1l1i = 0;
		n1l1O = 0;
	end
	always @ ( posedge clk_2 or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n100i <= 0;
			n100l <= 0;
			n100O <= 0;
			n101i <= 0;
			n101l <= 0;
			n101O <= 0;
			n10ii <= 0;
			n10il <= 0;
			n10iO <= 0;
			n10li <= 0;
			n10ll <= 0;
			n10lO <= 0;
			n10Oi <= 0;
			n10Ol <= 0;
			n10OO <= 0;
			n110O <= 0;
			n11ii <= 0;
			n11il <= 0;
			n11iO <= 0;
			n11li <= 0;
			n11ll <= 0;
			n11lO <= 0;
			n11Oi <= 0;
			n11OiO <= 0;
			n11Ol <= 0;
			n11Oli <= 0;
			n11Oll <= 0;
			n11OlO <= 0;
			n11OO <= 0;
			n1i0i <= 0;
			n1i0l <= 0;
			n1i0O <= 0;
			n1i1i <= 0;
			n1i1l <= 0;
			n1i1O <= 0;
			n1iii <= 0;
			n1iil <= 0;
			n1iiO <= 0;
			n1ili <= 0;
			n1ill <= 0;
			n1ilO <= 0;
			n1iOi <= 0;
			n1iOl <= 0;
			n1iOO <= 0;
			n1l1i <= 0;
			n1l1O <= 0;
		end
		else 
		begin
			n100i <= (n100l & (nl0i1iO | ((rsync_comp_porn & (nl0i1il | nl0i1ii)) & (nl0l1Oi | nl0iO1l))));
			n100l <= nl0iili;
			n100O <= nl0i0Ol;
			n101i <= ovr_undflow[3];
			n101l <= (n101O & (nl0i10O | ((rsync_comp_porn & (nl0i10l | nl0i10i)) & (nl0il1i | nl0iiOO))));
			n101O <= nl0iiii;
			n10ii <= nl0ii1O;
			n10il <= nl0iiii;
			n10iO <= nl0iili;
			n10li <= n10lO;
			n10ll <= n10Oi;
			n10lO <= wire_nliil_o;
			n10Oi <= wire_niOil_o;
			n10Ol <= (nl0l1Oi & n1i1i);
			n10OO <= (nl0ii0l & n1i1l);
			n110O <= dec_data_valid[0];
			n11ii <= dec_data_valid[1];
			n11il <= wire_n1O0l_dataout;
			n11iO <= n11Oi;
			n11li <= n11Ol;
			n11ll <= n11OO;
			n11lO <= n101i;
			n11Oi <= ovr_undflow[0];
			n11OiO <= n1l1O;
			n11Ol <= ovr_undflow[1];
			n11Oli <= wire_n1011i_dataout;
			n11Oll <= n11OlO;
			n11OlO <= nl0i1li;
			n11OO <= ovr_undflow[2];
			n1i0i <= nl0iilO;
			n1i0l <= n1iii;
			n1i0O <= n1iil;
			n1i1i <= (nl0iO0O & n1i1O);
			n1i1l <= (nl0iilO & n1i0i);
			n1i1O <= nl0iO0O;
			n1iii <= disp_val_delay[0];
			n1iil <= disp_val_delay[1];
			n1iiO <= n1ill;
			n1ili <= n1ilO;
			n1ill <= disp_err_delay[0];
			n1ilO <= disp_err_delay[1];
			n1iOi <= n1iOO;
			n1iOl <= n1l1i;
			n1iOO <= sync_resync_delay[0];
			n1l1i <= sync_resync_delay[1];
			n1l1O <= signal_detect_sync_st;
		end
	end
	initial
	begin
		nl0ll0O = 0;
	end
	always @ ( posedge rx_rd_clk or posedge wire_n111l_dataout)
	begin
		if (wire_n111l_dataout == 1'b1) 
		begin
			nl0ll0O <= 1;
		end
		else if  (wire_nl0ll0l_ENA == 1'b1) 
		begin
			nl0ll0O <= nl000ii;
		end
	end
	assign
		wire_nl0ll0l_ENA = (nlOlll & nl0ll0O);
	initial
	begin
		nl0llii = 0;
		nl0llil = 0;
		nl0lliO = 0;
		nl0llli = 0;
		nl0lllO = 0;
	end
	always @ ( posedge rx_rd_clk or posedge wire_n111l_dataout)
	begin
		if (wire_n111l_dataout == 1'b1) 
		begin
			nl0llii <= 1;
			nl0llil <= 1;
			nl0lliO <= 1;
			nl0llli <= 1;
			nl0lllO <= 1;
		end
		else 
		begin
			nl0llii <= nl0llil;
			nl0llil <= nli110l;
			nl0lliO <= wire_nli1i0i_dataout;
			nl0llli <= nl0lllO;
			nl0lllO <= wire_nl0lOiO_o[2];
		end
	end
	initial
	begin
		nl0llOl = 0;
	end
	always @ ( posedge rx_wr_clk or posedge wire_n110l_dataout)
	begin
		if (wire_n110l_dataout == 1'b1) 
		begin
			nl0llOl <= 1;
		end
		else 
		begin
			nl0llOl <= wire_nli1liO_dataout;
		end
	end
	initial
	begin
		nl0lOli = 0;
		nl0lOll = 0;
		nl0lOlO = 0;
		nl0lOOi = 0;
		nl0lOOl = 0;
		nl0lOOO = 0;
		nl0O00i = 0;
		nl0O00l = 0;
		nl0O00O = 0;
		nl0O01i = 0;
		nl0O01l = 0;
		nl0O01O = 0;
		nl0O0ii = 0;
		nl0O0il = 0;
		nl0O0iO = 0;
		nl0O0li = 0;
		nl0O0ll = 0;
		nl0O0lO = 0;
		nl0O0Oi = 0;
		nl0O0Ol = 0;
		nl0O0OO = 0;
		nl0O10i = 0;
		nl0O10l = 0;
		nl0O10O = 0;
		nl0O11i = 0;
		nl0O11l = 0;
		nl0O11O = 0;
		nl0O1ii = 0;
		nl0O1il = 0;
		nl0O1iO = 0;
		nl0O1li = 0;
		nl0O1ll = 0;
		nl0O1lO = 0;
		nl0O1Oi = 0;
		nl0O1Ol = 0;
		nl0O1OO = 0;
		nl0Oi0i = 0;
		nl0Oi0l = 0;
		nl0Oi0O = 0;
		nl0Oi1i = 0;
		nl0Oi1l = 0;
		nl0Oi1O = 0;
		nl0Oiii = 0;
		nl0Oiil = 0;
		nl0OiiO = 0;
		nl0Oili = 0;
		nl0Oill = 0;
		nl0OilO = 0;
		nl0OiOi = 0;
		nl0OiOl = 0;
		nl0OiOO = 0;
		nl0Ol0i = 0;
		nl0Ol0l = 0;
		nl0Ol0O = 0;
		nl0Ol1i = 0;
		nl0Ol1l = 0;
		nl0Ol1O = 0;
		nl0Olii = 0;
		nl0Olil = 0;
		nl0OliO = 0;
		nl0Olli = 0;
		nl0Olll = 0;
		nl0OllO = 0;
		nl0OlOi = 0;
		nl0OlOl = 0;
		nl0OlOO = 0;
		nl0OO0i = 0;
		nl0OO0l = 0;
		nl0OO0O = 0;
		nl0OO1i = 0;
		nl0OO1l = 0;
		nl0OO1O = 0;
		nl0OOii = 0;
		nl0OOil = 0;
		nl0OOiO = 0;
		nl0OOli = 0;
		nl0OOll = 0;
		nl0OOlO = 0;
		nl0OOOi = 0;
		nl0OOOl = 0;
		nl0OOOO = 0;
		nli100i = 0;
		nli100l = 0;
		nli101i = 0;
		nli101l = 0;
		nli101O = 0;
		nli110i = 0;
		nli110l = 0;
		nli110O = 0;
		nli111i = 0;
		nli111l = 0;
		nli111O = 0;
		nli11ii = 0;
		nli11il = 0;
		nli11iO = 0;
		nli11li = 0;
		nli11ll = 0;
		nli11lO = 0;
		nli11Oi = 0;
		nli11Ol = 0;
		nli11OO = 0;
		nli1l1l = 0;
		nlOlll = 0;
		nlOllO = 0;
		nlOlOi = 0;
		nlOO0i = 0;
	end
	always @ ( posedge rx_rd_clk or posedge wire_n111l_dataout)
	begin
		if (wire_n111l_dataout == 1'b1) 
		begin
			nl0lOli <= 0;
			nl0lOll <= 0;
			nl0lOlO <= 0;
			nl0lOOi <= 0;
			nl0lOOl <= 0;
			nl0lOOO <= 0;
			nl0O00i <= 0;
			nl0O00l <= 0;
			nl0O00O <= 0;
			nl0O01i <= 0;
			nl0O01l <= 0;
			nl0O01O <= 0;
			nl0O0ii <= 0;
			nl0O0il <= 0;
			nl0O0iO <= 0;
			nl0O0li <= 0;
			nl0O0ll <= 0;
			nl0O0lO <= 0;
			nl0O0Oi <= 0;
			nl0O0Ol <= 0;
			nl0O0OO <= 0;
			nl0O10i <= 0;
			nl0O10l <= 0;
			nl0O10O <= 0;
			nl0O11i <= 0;
			nl0O11l <= 0;
			nl0O11O <= 0;
			nl0O1ii <= 0;
			nl0O1il <= 0;
			nl0O1iO <= 0;
			nl0O1li <= 0;
			nl0O1ll <= 0;
			nl0O1lO <= 0;
			nl0O1Oi <= 0;
			nl0O1Ol <= 0;
			nl0O1OO <= 0;
			nl0Oi0i <= 0;
			nl0Oi0l <= 0;
			nl0Oi0O <= 0;
			nl0Oi1i <= 0;
			nl0Oi1l <= 0;
			nl0Oi1O <= 0;
			nl0Oiii <= 0;
			nl0Oiil <= 0;
			nl0OiiO <= 0;
			nl0Oili <= 0;
			nl0Oill <= 0;
			nl0OilO <= 0;
			nl0OiOi <= 0;
			nl0OiOl <= 0;
			nl0OiOO <= 0;
			nl0Ol0i <= 0;
			nl0Ol0l <= 0;
			nl0Ol0O <= 0;
			nl0Ol1i <= 0;
			nl0Ol1l <= 0;
			nl0Ol1O <= 0;
			nl0Olii <= 0;
			nl0Olil <= 0;
			nl0OliO <= 0;
			nl0Olli <= 0;
			nl0Olll <= 0;
			nl0OllO <= 0;
			nl0OlOi <= 0;
			nl0OlOl <= 0;
			nl0OlOO <= 0;
			nl0OO0i <= 0;
			nl0OO0l <= 0;
			nl0OO0O <= 0;
			nl0OO1i <= 0;
			nl0OO1l <= 0;
			nl0OO1O <= 0;
			nl0OOii <= 0;
			nl0OOil <= 0;
			nl0OOiO <= 0;
			nl0OOli <= 0;
			nl0OOll <= 0;
			nl0OOlO <= 0;
			nl0OOOi <= 0;
			nl0OOOl <= 0;
			nl0OOOO <= 0;
			nli100i <= 0;
			nli100l <= 0;
			nli101i <= 0;
			nli101l <= 0;
			nli101O <= 0;
			nli110i <= 0;
			nli110l <= 0;
			nli110O <= 0;
			nli111i <= 0;
			nli111l <= 0;
			nli111O <= 0;
			nli11ii <= 0;
			nli11il <= 0;
			nli11iO <= 0;
			nli11li <= 0;
			nli11ll <= 0;
			nli11lO <= 0;
			nli11Oi <= 0;
			nli11Ol <= 0;
			nli11OO <= 0;
			nli1l1l <= 0;
			nlOlll <= 0;
			nlOllO <= 0;
			nlOlOi <= 0;
			nlOO0i <= 0;
		end
		else 
		begin
			nl0lOli <= wire_nl0l0ii_data_out[0];
			nl0lOll <= wire_nl0l0ii_data_out[1];
			nl0lOlO <= wire_nl0l0ii_data_out[2];
			nl0lOOi <= wire_nl0l0ii_data_out[3];
			nl0lOOl <= wire_nl0l0ii_data_out[4];
			nl0lOOO <= wire_nl0l0ii_data_out[5];
			nl0O00i <= wire_nl0l0ii_data_out[24];
			nl0O00l <= wire_nl0l0ii_data_out[25];
			nl0O00O <= wire_nl0l0ii_data_out[26];
			nl0O01i <= wire_nl0l0ii_data_out[21];
			nl0O01l <= wire_nl0l0ii_data_out[22];
			nl0O01O <= wire_nl0l0ii_data_out[23];
			nl0O0ii <= wire_nl0l0ii_data_out[27];
			nl0O0il <= wire_nl0l0ii_data_out[28];
			nl0O0iO <= wire_nl0l0ii_data_out[29];
			nl0O0li <= wire_nl0l0ii_data_out[30];
			nl0O0ll <= wire_nl0l0ii_data_out[31];
			nl0O0lO <= wire_nl0l0ii_data_out[32];
			nl0O0Oi <= wire_nl0l0ii_data_out[33];
			nl0O0Ol <= wire_nl0l0ii_data_out[34];
			nl0O0OO <= wire_nl0l0ii_data_out[35];
			nl0O10i <= wire_nl0l0ii_data_out[9];
			nl0O10l <= wire_nl0l0ii_data_out[10];
			nl0O10O <= wire_nl0l0ii_data_out[11];
			nl0O11i <= wire_nl0l0ii_data_out[6];
			nl0O11l <= wire_nl0l0ii_data_out[7];
			nl0O11O <= wire_nl0l0ii_data_out[8];
			nl0O1ii <= wire_nl0l0ii_data_out[12];
			nl0O1il <= wire_nl0l0ii_data_out[13];
			nl0O1iO <= wire_nl0l0ii_data_out[14];
			nl0O1li <= wire_nl0l0ii_data_out[15];
			nl0O1ll <= wire_nl0l0ii_data_out[16];
			nl0O1lO <= wire_nl0l0ii_data_out[17];
			nl0O1Oi <= wire_nl0l0ii_data_out[18];
			nl0O1Ol <= wire_nl0l0ii_data_out[19];
			nl0O1OO <= wire_nl0l0ii_data_out[20];
			nl0Oi0i <= wire_nl0l0ii_data_out[39];
			nl0Oi0l <= wire_nl0l0ii_data_out[40];
			nl0Oi0O <= wire_nl0l0ii_data_out[41];
			nl0Oi1i <= wire_nl0l0ii_data_out[36];
			nl0Oi1l <= wire_nl0l0ii_data_out[37];
			nl0Oi1O <= wire_nl0l0ii_data_out[38];
			nl0Oiii <= wire_nl0l0ii_data_out[42];
			nl0Oiil <= wire_nl0l0ii_data_out[43];
			nl0OiiO <= wire_nl0l0ii_data_out[44];
			nl0Oili <= wire_nl0l0ii_data_out[45];
			nl0Oill <= wire_nl0l0ii_data_out[46];
			nl0OilO <= wire_nl0l0ii_data_out[47];
			nl0OiOi <= wire_nl0l0ii_data_out[48];
			nl0OiOl <= wire_nl0l0ii_data_out[49];
			nl0OiOO <= wire_nl0l0ii_data_out[50];
			nl0Ol0i <= wire_nl0l0ii_data_out[54];
			nl0Ol0l <= wire_nl0l0ii_data_out[55];
			nl0Ol0O <= wire_nl0l0ii_data_out[56];
			nl0Ol1i <= wire_nl0l0ii_data_out[51];
			nl0Ol1l <= wire_nl0l0ii_data_out[52];
			nl0Ol1O <= wire_nl0l0ii_data_out[53];
			nl0Olii <= wire_nl0l0ii_data_out[57];
			nl0Olil <= wire_nl0l0ii_data_out[58];
			nl0OliO <= wire_nl0l0ii_data_out[59];
			nl0Olli <= wire_nl0l0ii_data_out[60];
			nl0Olll <= wire_nl0l0ii_data_out[61];
			nl0OllO <= wire_nl0l0ii_data_out[62];
			nl0OlOi <= wire_nl0l0ii_data_out[63];
			nl0OlOl <= wire_nl0l0ii_data_out[64];
			nl0OlOO <= wire_nli100O_dataout;
			nl0OO0i <= nl0OOll;
			nl0OO0l <= nl0OOlO;
			nl0OO0O <= nl0OOOi;
			nl0OO1i <= wire_nli10li_dataout;
			nl0OO1l <= nl0OOiO;
			nl0OO1O <= nl0OOli;
			nl0OOii <= nl0OOOl;
			nl0OOil <= nl0OOOO;
			nl0OOiO <= nli111i;
			nl0OOli <= nli111l;
			nl0OOll <= nli111O;
			nl0OOlO <= nli110i;
			nl0OOOi <= nl0lliO;
			nl0OOOl <= nli110O;
			nl0OOOO <= nli11ii;
			nli100i <= wire_nl0lOiO_o[32];
			nli100l <= wire_nl0lOiO_o[64];
			nli101i <= wire_nl0lOiO_o[4];
			nli101l <= wire_nl0lOiO_o[8];
			nli101O <= wire_nl0lOiO_o[16];
			nli110i <= wire_nli1i1l_dataout;
			nli110l <= wire_nli1i1O_dataout;
			nli110O <= wire_nli1i0l_dataout;
			nli111i <= wire_nli10Ol_dataout;
			nli111l <= wire_nli10OO_dataout;
			nli111O <= wire_nli1i1i_dataout;
			nli11ii <= wire_nli1i0O_dataout;
			nli11il <= nli11OO;
			nli11iO <= nli101i;
			nli11li <= nli101l;
			nli11ll <= nli101O;
			nli11lO <= nli100i;
			nli11Oi <= nli100l;
			nli11Ol <= nli1l1l;
			nli11OO <= (~ nl0001l);
			nli1l1l <= wire_nl0lOiO_o[128];
			nlOlll <= wire_nlOlOl_dataout;
			nlOllO <= wire_nlOO1i_dataout;
			nlOlOi <= nlOO0i;
			nlOO0i <= nl0i1li;
		end
	end
	assign		wire_n0000i_dataout = (nl00i1l === 1'b1) ? rbytordpadval[2] : wire_nl0l00O_byte_des_fifo_data_in[34];
	assign		wire_n0000l_dataout = (nl00i1l === 1'b1) ? rbytordpadval[3] : wire_nl0l00O_byte_des_fifo_data_in[35];
	assign		wire_n0000O_dataout = (nl00i1l === 1'b1) ? rbytordpadval[4] : wire_nl0l00O_byte_des_fifo_data_in[36];
	and(wire_n0001i_dataout, wire_nl0l00O_byte_des_fifo_data_in[31], ~{nl00i1l});
	assign		wire_n0001l_dataout = (nl00i1l === 1'b1) ? rbytordpadval[0] : wire_nl0l00O_byte_des_fifo_data_in[32];
	assign		wire_n0001O_dataout = (nl00i1l === 1'b1) ? rbytordpadval[1] : wire_nl0l00O_byte_des_fifo_data_in[33];
	assign		wire_n000i_dataout = (endec_rx === 1'b1) ? wire_n0liO_dataout : ovr_undflow[1];
	assign		wire_n000ii_dataout = (nl00i1l === 1'b1) ? rbytordpadval[5] : wire_nl0l00O_byte_des_fifo_data_in[37];
	assign		wire_n000il_dataout = (nl00i1l === 1'b1) ? rbytordpadval[6] : wire_nl0l00O_byte_des_fifo_data_in[38];
	assign		wire_n000iO_dataout = (nl00i1l === 1'b1) ? rbytordpadval[7] : wire_nl0l00O_byte_des_fifo_data_in[39];
	assign		wire_n000l_dataout = (endec_rx === 1'b1) ? wire_n0lli_dataout : ovr_undflow[2];
	assign		wire_n000li_dataout = (nl00i1l === 1'b1) ? rbytordpadval[8] : wire_nl0l00O_byte_des_fifo_data_in[40];
	assign		wire_n000ll_dataout = (nl00i1l === 1'b1) ? rbytordpadval[9] : wire_nl0l00O_byte_des_fifo_data_in[41];
	assign		wire_n000lO_dataout = (nl00i1l === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[10] : wire_nl0l00O_byte_des_fifo_data_in[42];
	assign		wire_n000O_dataout = (endec_rx === 1'b1) ? wire_n0lll_dataout : ovr_undflow[3];
	and(wire_n000Oi_dataout, wire_nl0l00O_byte_des_fifo_data_in[43], ~{nl00i1l});
	and(wire_n000Ol_dataout, wire_nl0l00O_byte_des_fifo_data_in[44], ~{nl00i1l});
	and(wire_n000OO_dataout, wire_nl0l00O_byte_des_fifo_data_in[45], ~{nl00i1l});
	and(wire_n0010i_dataout, wire_nl0l00O_byte_des_fifo_data_in[19], ~{nl00i1l});
	and(wire_n0010l_dataout, wire_nl0l00O_byte_des_fifo_data_in[20], ~{nl00i1l});
	and(wire_n0010O_dataout, wire_nl0l00O_byte_des_fifo_data_in[21], ~{nl00i1l});
	and(wire_n0011i_dataout, wire_nl0l00O_byte_des_fifo_data_in[16], ~{nl00i1l});
	and(wire_n0011l_dataout, wire_nl0l00O_byte_des_fifo_data_in[17], ~{nl00i1l});
	and(wire_n0011O_dataout, wire_nl0l00O_byte_des_fifo_data_in[18], ~{nl00i1l});
	assign		wire_n001i_dataout = (endec_rx === 1'b1) ? wire_n0lii_dataout : tenb_data[18];
	and(wire_n001ii_dataout, wire_nl0l00O_byte_des_fifo_data_in[22], ~{nl00i1l});
	and(wire_n001il_dataout, wire_nl0l00O_byte_des_fifo_data_in[23], ~{nl00i1l});
	and(wire_n001iO_dataout, wire_nl0l00O_byte_des_fifo_data_in[24], ~{nl00i1l});
	assign		wire_n001l_dataout = (endec_rx === 1'b1) ? wire_nll_dataout : tenb_data[19];
	and(wire_n001li_dataout, wire_nl0l00O_byte_des_fifo_data_in[25], ~{nl00i1l});
	and(wire_n001ll_dataout, wire_nl0l00O_byte_des_fifo_data_in[26], ~{nl00i1l});
	and(wire_n001lO_dataout, wire_nl0l00O_byte_des_fifo_data_in[27], ~{nl00i1l});
	assign		wire_n001O_dataout = (endec_rx === 1'b1) ? wire_n0lil_dataout : ovr_undflow[0];
	and(wire_n001Oi_dataout, wire_nl0l00O_byte_des_fifo_data_in[28], ~{nl00i1l});
	and(wire_n001Ol_dataout, wire_nl0l00O_byte_des_fifo_data_in[29], ~{nl00i1l});
	and(wire_n001OO_dataout, wire_nl0l00O_byte_des_fifo_data_in[30], ~{nl00i1l});
	assign		wire_n00i_dataout = (rrxfifo_dis === 1'b1) ? wire_n1001O_o : nl0O1il;
	and(wire_n00i0i_dataout, wire_nl0l00O_byte_des_fifo_data_in[49], ~{nl00i1l});
	and(wire_n00i0l_dataout, wire_nl0l00O_byte_des_fifo_data_in[50], ~{nl00i1l});
	and(wire_n00i0O_dataout, wire_nl0l00O_byte_des_fifo_data_in[51], ~{nl00i1l});
	and(wire_n00i1i_dataout, wire_nl0l00O_byte_des_fifo_data_in[46], ~{nl00i1l});
	and(wire_n00i1l_dataout, wire_nl0l00O_byte_des_fifo_data_in[47], ~{nl00i1l});
	and(wire_n00i1O_dataout, wire_nl0l00O_byte_des_fifo_data_in[48], ~{nl00i1l});
	assign		wire_n00ii_dataout = (endec_rx === 1'b1) ? wire_n0llO_dataout : disp_val_delay[0];
	and(wire_n00iii_dataout, wire_nl0l00O_byte_des_fifo_data_in[52], ~{nl00i1l});
	and(wire_n00iil_dataout, wire_nl0l00O_byte_des_fifo_data_in[53], ~{nl00i1l});
	and(wire_n00iiO_dataout, wire_nl0l00O_byte_des_fifo_data_in[54], ~{nl00i1l});
	assign		wire_n00il_dataout = (endec_rx === 1'b1) ? wire_n0lOi_dataout : disp_val_delay[1];
	and(wire_n00ili_dataout, wire_nl0l00O_byte_des_fifo_data_in[55], ~{nl00i1l});
	and(wire_n00ill_dataout, wire_nl0l00O_byte_des_fifo_data_in[56], ~{nl00i1l});
	and(wire_n00ilO_dataout, wire_nl0l00O_byte_des_fifo_data_in[57], ~{nl00i1l});
	assign		wire_n00iO_dataout = (endec_rx === 1'b1) ? wire_n0lOl_dataout : disp_err_delay[0];
	and(wire_n00iOi_dataout, wire_nl0l00O_byte_des_fifo_data_in[58], ~{nl00i1l});
	and(wire_n00iOl_dataout, wire_nl0l00O_byte_des_fifo_data_in[59], ~{nl00i1l});
	and(wire_n00iOO_dataout, wire_nl0l00O_byte_des_fifo_data_in[60], ~{nl00i1l});
	assign		wire_n00l_dataout = (rrxfifo_dis === 1'b1) ? wire_n1000i_o : nl0O1iO;
	assign		wire_n00l0i_dataout = (nl000iO === 1'b1) ? nlliil : wire_n0iiil_dataout;
	assign		wire_n00l0l_dataout = (nl000iO === 1'b1) ? nlliiO : wire_n0iiiO_dataout;
	assign		wire_n00l0O_dataout = (nl000iO === 1'b1) ? nllili : wire_n0iili_dataout;
	and(wire_n00l1i_dataout, wire_nl0l00O_byte_des_fifo_data_in[61], ~{nl00i1l});
	and(wire_n00l1l_dataout, wire_nl0l00O_byte_des_fifo_data_in[62], ~{nl00i1l});
	and(wire_n00l1O_dataout, wire_nl0l00O_byte_des_fifo_data_in[63], ~{nl00i1l});
	assign		wire_n00li_dataout = (endec_rx === 1'b1) ? wire_n0lOO_dataout : disp_err_delay[1];
	assign		wire_n00lii_dataout = (nl000iO === 1'b1) ? nllill : wire_n0iill_dataout;
	assign		wire_n00lil_dataout = (nl000iO === 1'b1) ? nllilO : wire_n0iilO_dataout;
	assign		wire_n00liO_dataout = (nl000iO === 1'b1) ? nlliOi : wire_n0iiOi_dataout;
	assign		wire_n00ll_dataout = (endec_rx === 1'b1) ? wire_n0O1i_dataout : sync_resync_delay[0];
	assign		wire_n00lli_dataout = (nl000iO === 1'b1) ? nlliOl : wire_n0iiOl_dataout;
	assign		wire_n00lll_dataout = (nl000iO === 1'b1) ? nlliOO : wire_n0iiOO_dataout;
	assign		wire_n00llO_dataout = (nl000iO === 1'b1) ? nlll1i : wire_n0il1i_dataout;
	assign		wire_n00lO_dataout = (endec_rx === 1'b1) ? wire_n0O1l_dataout : sync_resync_delay[1];
	assign		wire_n00lOi_dataout = (nl000iO === 1'b1) ? nlll1l : wire_n0il1l_dataout;
	assign		wire_n00lOl_dataout = (nl000iO === 1'b1) ? nlll1O : wire_n0il1O_dataout;
	assign		wire_n00lOO_dataout = (nl000iO === 1'b1) ? nlll0i : wire_n0il0i_dataout;
	assign		wire_n00O_dataout = (rrxfifo_dis === 1'b1) ? wire_n1000l_o : nl0O1li;
	assign		wire_n00O0i_dataout = (nl000iO === 1'b1) ? nlllil : wire_n0ilil_dataout;
	assign		wire_n00O0l_dataout = (nl000iO === 1'b1) ? wire_n0l0Oi_dataout : wire_n0iliO_dataout;
	assign		wire_n00O0O_dataout = (nl000iO === 1'b1) ? wire_n0l0Ol_dataout : wire_n0illi_dataout;
	assign		wire_n00O1i_dataout = (nl000iO === 1'b1) ? nlll0l : wire_n0il0l_dataout;
	assign		wire_n00O1l_dataout = (nl000iO === 1'b1) ? nlll0O : wire_n0il0O_dataout;
	assign		wire_n00O1O_dataout = (nl000iO === 1'b1) ? nlllii : wire_n0ilii_dataout;
	and(wire_n00Oi_dataout, wire_niOil_o, ~{((~ rsync_sm_dis) & (~ n11ii))});
	assign		wire_n00Oii_dataout = (nl000iO === 1'b1) ? wire_n0l0OO_dataout : wire_n0illl_dataout;
	assign		wire_n00Oil_dataout = (nl000iO === 1'b1) ? wire_n0li1i_dataout : wire_n0illO_dataout;
	assign		wire_n00OiO_dataout = (nl000iO === 1'b1) ? wire_n0li1l_dataout : wire_n0ilOi_dataout;
	assign		wire_n00Oli_dataout = (nl000iO === 1'b1) ? wire_n0li1O_dataout : wire_n0ilOl_dataout;
	assign		wire_n00Oll_dataout = (nl000iO === 1'b1) ? wire_n0li0i_dataout : wire_n0ilOO_dataout;
	assign		wire_n00OlO_dataout = (nl000iO === 1'b1) ? wire_n0li0l_dataout : wire_n0iO1i_dataout;
	and(wire_n00OO_dataout, wire_nliil_o, ~{((~ rsync_sm_dis) & (~ n110O))});
	assign		wire_n00OOi_dataout = (nl000iO === 1'b1) ? wire_n0li0O_dataout : wire_n0iO1l_dataout;
	assign		wire_n00OOl_dataout = (nl000iO === 1'b1) ? wire_n0liii_dataout : wire_n0iO1O_dataout;
	assign		wire_n00OOO_dataout = (nl000iO === 1'b1) ? wire_n0liil_dataout : wire_n0iO0i_dataout;
	assign		wire_n0100i_dataout = (nl000lO === 1'b1) ? nlO11l : wire_nl0l00O_byte_des_fifo_data_in[7];
	assign		wire_n0100l_dataout = (nl000lO === 1'b1) ? nlO11O : wire_nl0l00O_byte_des_fifo_data_in[8];
	assign		wire_n0100O_dataout = (nl000lO === 1'b1) ? nlO10i : wire_nl0l00O_byte_des_fifo_data_in[9];
	assign		wire_n0101i_dataout = (nl000lO === 1'b1) ? nllOOl : wire_nl0l00O_byte_des_fifo_data_in[4];
	assign		wire_n0101l_dataout = (nl000lO === 1'b1) ? nllOOO : wire_nl0l00O_byte_des_fifo_data_in[5];
	assign		wire_n0101O_dataout = (nl000lO === 1'b1) ? nlO11i : wire_nl0l00O_byte_des_fifo_data_in[6];
	assign		wire_n010i_dataout = (endec_rx === 1'b1) ? wire_n0ili_dataout : tenb_data[6];
	assign		wire_n010ii_dataout = (nl000lO === 1'b1) ? nlO10l : wire_nl0l00O_byte_des_fifo_data_in[10];
	assign		wire_n010il_dataout = (nl000lO === 1'b1) ? nlO10O : wire_nl0l00O_byte_des_fifo_data_in[11];
	assign		wire_n010iO_dataout = (nl000lO === 1'b1) ? nlO1ii : wire_nl0l00O_byte_des_fifo_data_in[12];
	assign		wire_n010l_dataout = (endec_rx === 1'b1) ? wire_n0ill_dataout : tenb_data[7];
	assign		wire_n010li_dataout = (nl000lO === 1'b1) ? nlO1il : wire_nl0l00O_byte_des_fifo_data_in[13];
	assign		wire_n010ll_dataout = (nl000lO === 1'b1) ? nlO1iO : wire_nl0l00O_byte_des_fifo_data_in[14];
	assign		wire_n010lO_dataout = (nl000lO === 1'b1) ? nlO1li : wire_nl0l00O_byte_des_fifo_data_in[15];
	assign		wire_n010O_dataout = (endec_rx === 1'b1) ? wire_n0ilO_dataout : tenb_data[8];
	assign		wire_n010Oi_dataout = (nl000lO === 1'b1) ? nlO1ll : wire_nl0l00O_byte_des_fifo_data_in[16];
	assign		wire_n010Ol_dataout = (nl000lO === 1'b1) ? nlO1lO : wire_nl0l00O_byte_des_fifo_data_in[17];
	assign		wire_n010OO_dataout = (nl000lO === 1'b1) ? nlO1Oi : wire_nl0l00O_byte_des_fifo_data_in[18];
	assign		wire_n0110i_dataout = (nl0i11i === 1'b1) ? wire_n00ill_dataout : wire_n01Oil_dataout;
	assign		wire_n0110l_dataout = (nl0i11i === 1'b1) ? wire_n00ilO_dataout : wire_n01OiO_dataout;
	assign		wire_n0110O_dataout = (nl0i11i === 1'b1) ? wire_n00iOi_dataout : wire_n01Oli_dataout;
	assign		wire_n0111i_dataout = (nl0i11i === 1'b1) ? wire_n00iil_dataout : wire_n01O0l_dataout;
	assign		wire_n0111l_dataout = (nl0i11i === 1'b1) ? wire_n00iiO_dataout : wire_n01O0O_dataout;
	assign		wire_n0111O_dataout = (nl0i11i === 1'b1) ? wire_n00ili_dataout : wire_n01Oii_dataout;
	assign		wire_n011i_dataout = (endec_rx === 1'b1) ? wire_n0iii_dataout : tenb_data[3];
	assign		wire_n011ii_dataout = (nl0i11i === 1'b1) ? wire_n00iOl_dataout : wire_n01Oll_dataout;
	assign		wire_n011il_dataout = (nl0i11i === 1'b1) ? wire_n00iOO_dataout : wire_n01OlO_dataout;
	assign		wire_n011iO_dataout = (nl0i11i === 1'b1) ? wire_n00l1i_dataout : wire_n01OOi_dataout;
	assign		wire_n011l_dataout = (endec_rx === 1'b1) ? wire_n0iil_dataout : tenb_data[4];
	assign		wire_n011li_dataout = (nl0i11i === 1'b1) ? wire_n00l1l_dataout : wire_n01OOl_dataout;
	assign		wire_n011ll_dataout = (nl0i11i === 1'b1) ? wire_n00l1O_dataout : wire_n01OOO_dataout;
	assign		wire_n011lO_dataout = (nl000lO === 1'b1) ? nllOli : wire_nl0l00O_byte_des_fifo_data_in[0];
	assign		wire_n011O_dataout = (endec_rx === 1'b1) ? wire_n0iiO_dataout : tenb_data[5];
	assign		wire_n011Oi_dataout = (nl000lO === 1'b1) ? nllOll : wire_nl0l00O_byte_des_fifo_data_in[1];
	assign		wire_n011Ol_dataout = (nl000lO === 1'b1) ? nllOlO : wire_nl0l00O_byte_des_fifo_data_in[2];
	assign		wire_n011OO_dataout = (nl000lO === 1'b1) ? nllOOi : wire_nl0l00O_byte_des_fifo_data_in[3];
	assign		wire_n01i_dataout = (rrxfifo_dis === 1'b1) ? wire_n101OO_o : nl0O10l;
	assign		wire_n01i0i_dataout = (nl000lO === 1'b1) ? nlO01l : wire_nl0l00O_byte_des_fifo_data_in[22];
	assign		wire_n01i0l_dataout = (nl000lO === 1'b1) ? nlO01O : wire_nl0l00O_byte_des_fifo_data_in[23];
	assign		wire_n01i0O_dataout = (nl000lO === 1'b1) ? nlO00i : wire_nl0l00O_byte_des_fifo_data_in[24];
	assign		wire_n01i1i_dataout = (nl000lO === 1'b1) ? nlO1Ol : wire_nl0l00O_byte_des_fifo_data_in[19];
	assign		wire_n01i1l_dataout = (nl000lO === 1'b1) ? nlO1OO : wire_nl0l00O_byte_des_fifo_data_in[20];
	assign		wire_n01i1O_dataout = (nl000lO === 1'b1) ? nlO01i : wire_nl0l00O_byte_des_fifo_data_in[21];
	assign		wire_n01ii_dataout = (endec_rx === 1'b1) ? wire_n0iOi_dataout : tenb_data[9];
	assign		wire_n01iii_dataout = (nl000lO === 1'b1) ? nlO00l : wire_nl0l00O_byte_des_fifo_data_in[25];
	assign		wire_n01iil_dataout = (nl000lO === 1'b1) ? nlO00O : wire_nl0l00O_byte_des_fifo_data_in[26];
	assign		wire_n01iiO_dataout = (nl000lO === 1'b1) ? nlO0ii : wire_nl0l00O_byte_des_fifo_data_in[27];
	assign		wire_n01il_dataout = (endec_rx === 1'b1) ? wire_n0iOl_dataout : tenb_data[10];
	assign		wire_n01ili_dataout = (nl000lO === 1'b1) ? nlO0il : wire_nl0l00O_byte_des_fifo_data_in[28];
	assign		wire_n01ill_dataout = (nl000lO === 1'b1) ? nlO0iO : wire_nl0l00O_byte_des_fifo_data_in[29];
	assign		wire_n01ilO_dataout = (nl000lO === 1'b1) ? nlO0li : wire_nl0l00O_byte_des_fifo_data_in[30];
	assign		wire_n01iO_dataout = (endec_rx === 1'b1) ? wire_n0iOO_dataout : tenb_data[11];
	assign		wire_n01iOi_dataout = (nl000lO === 1'b1) ? nlO0ll : wire_nl0l00O_byte_des_fifo_data_in[31];
	assign		wire_n01iOl_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[0] : wire_nl0l00O_byte_des_fifo_data_in[32];
	assign		wire_n01iOO_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[1] : wire_nl0l00O_byte_des_fifo_data_in[33];
	assign		wire_n01l_dataout = (rrxfifo_dis === 1'b1) ? wire_n1001i_o : nl0O10O;
	assign		wire_n01l0i_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[5] : wire_nl0l00O_byte_des_fifo_data_in[37];
	assign		wire_n01l0l_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[6] : wire_nl0l00O_byte_des_fifo_data_in[38];
	assign		wire_n01l0O_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[7] : wire_nl0l00O_byte_des_fifo_data_in[39];
	assign		wire_n01l1i_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[2] : wire_nl0l00O_byte_des_fifo_data_in[34];
	assign		wire_n01l1l_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[3] : wire_nl0l00O_byte_des_fifo_data_in[35];
	assign		wire_n01l1O_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[4] : wire_nl0l00O_byte_des_fifo_data_in[36];
	assign		wire_n01li_dataout = (endec_rx === 1'b1) ? wire_n0l1i_dataout : tenb_data[12];
	assign		wire_n01lii_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[8] : wire_nl0l00O_byte_des_fifo_data_in[40];
	assign		wire_n01lil_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[9] : wire_nl0l00O_byte_des_fifo_data_in[41];
	assign		wire_n01liO_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[10] : wire_nl0l00O_byte_des_fifo_data_in[42];
	assign		wire_n01ll_dataout = (endec_rx === 1'b1) ? wire_n0l1l_dataout : tenb_data[13];
	assign		wire_n01lli_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[11] : wire_nl0l00O_byte_des_fifo_data_in[43];
	assign		wire_n01lll_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[12] : wire_nl0l00O_byte_des_fifo_data_in[44];
	assign		wire_n01llO_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[13] : wire_nl0l00O_byte_des_fifo_data_in[45];
	assign		wire_n01lO_dataout = (endec_rx === 1'b1) ? wire_n0l1O_dataout : tenb_data[14];
	assign		wire_n01lOi_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[14] : wire_nl0l00O_byte_des_fifo_data_in[46];
	assign		wire_n01lOl_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[15] : wire_nl0l00O_byte_des_fifo_data_in[47];
	assign		wire_n01lOO_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[16] : wire_nl0l00O_byte_des_fifo_data_in[48];
	assign		wire_n01O_dataout = (rrxfifo_dis === 1'b1) ? wire_n1001l_o : nl0O1ii;
	assign		wire_n01O0i_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[20] : wire_nl0l00O_byte_des_fifo_data_in[52];
	assign		wire_n01O0l_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[21] : wire_nl0l00O_byte_des_fifo_data_in[53];
	assign		wire_n01O0O_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[22] : wire_nl0l00O_byte_des_fifo_data_in[54];
	assign		wire_n01O1i_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[17] : wire_nl0l00O_byte_des_fifo_data_in[49];
	assign		wire_n01O1l_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[18] : wire_nl0l00O_byte_des_fifo_data_in[50];
	assign		wire_n01O1O_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[19] : wire_nl0l00O_byte_des_fifo_data_in[51];
	assign		wire_n01Oi_dataout = (endec_rx === 1'b1) ? wire_n0l0i_dataout : tenb_data[15];
	assign		wire_n01Oii_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[23] : wire_nl0l00O_byte_des_fifo_data_in[55];
	assign		wire_n01Oil_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[24] : wire_nl0l00O_byte_des_fifo_data_in[56];
	assign		wire_n01OiO_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[25] : wire_nl0l00O_byte_des_fifo_data_in[57];
	assign		wire_n01Ol_dataout = (endec_rx === 1'b1) ? wire_n0l0l_dataout : tenb_data[16];
	assign		wire_n01Oli_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[26] : wire_nl0l00O_byte_des_fifo_data_in[58];
	assign		wire_n01Oll_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[27] : wire_nl0l00O_byte_des_fifo_data_in[59];
	assign		wire_n01OlO_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[28] : wire_nl0l00O_byte_des_fifo_data_in[60];
	assign		wire_n01OO_dataout = (endec_rx === 1'b1) ? wire_n0l0O_dataout : tenb_data[17];
	assign		wire_n01OOi_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[29] : wire_nl0l00O_byte_des_fifo_data_in[61];
	assign		wire_n01OOl_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[30] : wire_nl0l00O_byte_des_fifo_data_in[62];
	assign		wire_n01OOO_dataout = (nl000lO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[31] : wire_nl0l00O_byte_des_fifo_data_in[63];
	assign		wire_n0i_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O1O_o : nl0Olil;
	assign		wire_n0i00i_dataout = (nl000iO === 1'b1) ? wire_n0lllO_dataout : wire_n0l1il_dataout;
	assign		wire_n0i00l_dataout = (nl000iO === 1'b1) ? wire_n0llOi_dataout : wire_n0l1iO_dataout;
	assign		wire_n0i00O_dataout = (nl000iO === 1'b1) ? wire_n0llOl_dataout : wire_n0l1li_dataout;
	assign		wire_n0i01i_dataout = (nl000iO === 1'b1) ? wire_n0lliO_dataout : wire_n0l10l_dataout;
	assign		wire_n0i01l_dataout = (nl000iO === 1'b1) ? wire_n0llli_dataout : wire_n0l10O_dataout;
	assign		wire_n0i01O_dataout = (nl000iO === 1'b1) ? wire_n0llll_dataout : wire_n0l1ii_dataout;
	assign		wire_n0i0i_dataout = (rendec_data_sel_rx === 1'b1) ? wire_ni0li_dataout : rx_data_rs[0];
	assign		wire_n0i0ii_dataout = (nl000iO === 1'b1) ? wire_n0llOO_dataout : wire_n0l1ll_dataout;
	assign		wire_n0i0il_dataout = (nl000iO === 1'b1) ? wire_n0lO1i_dataout : wire_n0l1lO_dataout;
	assign		wire_n0i0iO_dataout = (nl000iO === 1'b1) ? wire_n0lO1l_dataout : wire_n0l1Oi_dataout;
	assign		wire_n0i0l_dataout = (rendec_data_sel_rx === 1'b1) ? wire_ni0ll_dataout : rx_data_rs[1];
	assign		wire_n0i0li_dataout = (nl000iO === 1'b1) ? wire_n0lO1O_dataout : wire_n0l1Ol_dataout;
	assign		wire_n0i0ll_dataout = (nl000iO === 1'b1) ? wire_n0lO0i_dataout : wire_n0l1OO_dataout;
	assign		wire_n0i0lO_dataout = (nl000iO === 1'b1) ? wire_n0lO0l_dataout : wire_n0l01i_dataout;
	assign		wire_n0i0O_dataout = (rendec_data_sel_rx === 1'b1) ? wire_ni0lO_dataout : rx_data_rs[2];
	assign		wire_n0i0Oi_dataout = (nl000iO === 1'b1) ? wire_n0lO0O_dataout : wire_n0l01l_dataout;
	assign		wire_n0i0Ol_dataout = (nl000iO === 1'b1) ? wire_n0lOii_dataout : wire_n0l01O_dataout;
	assign		wire_n0i0OO_dataout = (nl000iO === 1'b1) ? wire_n0lOil_dataout : wire_n0l00i_dataout;
	assign		wire_n0i10i_dataout = (nl000iO === 1'b1) ? wire_n0lilO_dataout : wire_n0iOil_dataout;
	assign		wire_n0i10l_dataout = (nl000iO === 1'b1) ? wire_n0liOi_dataout : wire_n0iOiO_dataout;
	assign		wire_n0i10O_dataout = (nl000iO === 1'b1) ? wire_n0liOl_dataout : wire_n0iOli_dataout;
	assign		wire_n0i11i_dataout = (nl000iO === 1'b1) ? wire_n0liiO_dataout : wire_n0iO0l_dataout;
	assign		wire_n0i11l_dataout = (nl000iO === 1'b1) ? wire_n0lili_dataout : wire_n0iO0O_dataout;
	assign		wire_n0i11O_dataout = (nl000iO === 1'b1) ? wire_n0lill_dataout : wire_n0iOii_dataout;
	assign		wire_n0i1ii_dataout = (nl000iO === 1'b1) ? wire_n0liOO_dataout : wire_n0iOll_dataout;
	assign		wire_n0i1il_dataout = (nl000iO === 1'b1) ? wire_n0ll1i_dataout : wire_n0iOlO_dataout;
	assign		wire_n0i1iO_dataout = (nl000iO === 1'b1) ? wire_n0ll1l_dataout : wire_n0iOOi_dataout;
	assign		wire_n0i1l_dataout = (rendec_data_sel_rx === 1'b1) ? wire_ni0iO_dataout : n10li;
	assign		wire_n0i1li_dataout = (nl000iO === 1'b1) ? wire_n0ll1O_dataout : wire_n0iOOl_dataout;
	assign		wire_n0i1ll_dataout = (nl000iO === 1'b1) ? wire_n0ll0i_dataout : wire_n0iOOO_dataout;
	assign		wire_n0i1lO_dataout = (nl000iO === 1'b1) ? wire_n0ll0l_dataout : wire_n0l11i_dataout;
	assign		wire_n0i1O_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0O0l_dataout : n10ll;
	assign		wire_n0i1Oi_dataout = (nl000iO === 1'b1) ? wire_n0ll0O_dataout : wire_n0l11l_dataout;
	assign		wire_n0i1Ol_dataout = (nl000iO === 1'b1) ? wire_n0llii_dataout : wire_n0l11O_dataout;
	assign		wire_n0i1OO_dataout = (nl000iO === 1'b1) ? wire_n0llil_dataout : wire_n0l10i_dataout;
	assign		wire_n0ii_dataout = (rrxfifo_dis === 1'b1) ? wire_n1000O_o : nl0O1ll;
	assign		wire_n0ii0i_dataout = (nl000iO === 1'b1) ? wire_n0lOlO_dataout : wire_n0l0il_dataout;
	assign		wire_n0ii0l_dataout = (nl000iO === 1'b1) ? wire_n0lOOi_dataout : wire_n0l0iO_dataout;
	assign		wire_n0ii0O_dataout = (nl000iO === 1'b1) ? wire_n0lOOl_dataout : wire_n0l0li_dataout;
	assign		wire_n0ii1i_dataout = (nl000iO === 1'b1) ? wire_n0lOiO_dataout : wire_n0l00l_dataout;
	assign		wire_n0ii1l_dataout = (nl000iO === 1'b1) ? wire_n0lOli_dataout : wire_n0l00O_dataout;
	assign		wire_n0ii1O_dataout = (nl000iO === 1'b1) ? wire_n0lOll_dataout : wire_n0l0ii_dataout;
	assign		wire_n0iii_dataout = (rendec_data_sel_rx === 1'b1) ? wire_ni0Oi_dataout : rx_data_rs[3];
	assign		wire_n0iiii_dataout = (nl000iO === 1'b1) ? wire_n0lOOO_dataout : wire_n0l0ll_dataout;
	assign		wire_n0iiil_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nliO0l : nlliil;
	assign		wire_n0iiiO_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nliO0O : nlliiO;
	assign		wire_n0iil_dataout = (rendec_data_sel_rx === 1'b1) ? wire_ni0Ol_dataout : rx_data_rs[4];
	assign		wire_n0iili_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nliOii : nllili;
	assign		wire_n0iill_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nliOil : nllill;
	assign		wire_n0iilO_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nliOiO : nllilO;
	assign		wire_n0iiO_dataout = (rendec_data_sel_rx === 1'b1) ? wire_ni0OO_dataout : rx_data_rs[5];
	assign		wire_n0iiOi_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nliOli : nlliOi;
	assign		wire_n0iiOl_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nliOll : nlliOl;
	assign		wire_n0iiOO_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nliOlO : nlliOO;
	assign		wire_n0il_dataout = (rrxfifo_dis === 1'b1) ? wire_n100ii_o : nl0O1lO;
	assign		wire_n0il0i_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nll11i : nlll0i;
	assign		wire_n0il0l_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nll11l : nlll0l;
	assign		wire_n0il0O_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nll11O : nlll0O;
	assign		wire_n0il1i_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nliOOi : nlll1i;
	assign		wire_n0il1l_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nliOOl : nlll1l;
	assign		wire_n0il1O_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nliOOO : nlll1O;
	assign		wire_n0ili_dataout = (rendec_data_sel_rx === 1'b1) ? wire_nii1i_dataout : rx_data_rs[6];
	assign		wire_n0ilii_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nll10i : nlllii;
	assign		wire_n0ilil_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nll10l : nlllil;
	assign		wire_n0iliO_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlliil : nllliO;
	assign		wire_n0ill_dataout = (rendec_data_sel_rx === 1'b1) ? wire_nii1l_dataout : rx_data_rs[7];
	assign		wire_n0illi_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlliiO : nlllli;
	assign		wire_n0illl_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nllili : nlllll;
	assign		wire_n0illO_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nllill : nllllO;
	assign		wire_n0ilO_dataout = (rendec_data_sel_rx === 1'b1) ? wire_nii1O_dataout : rx_control_rs;
	assign		wire_n0ilOi_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nllilO : nlllOi;
	assign		wire_n0ilOl_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlliOi : nlllOl;
	assign		wire_n0ilOO_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlliOl : nlllOO;
	assign		wire_n0iO_dataout = (rrxfifo_dis === 1'b1) ? wire_n100il_o : nl0O1Oi;
	assign		wire_n0iO0i_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlll1O : nllO0i;
	assign		wire_n0iO0l_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlll0i : nllO0l;
	assign		wire_n0iO0O_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlll0l : nllO0O;
	assign		wire_n0iO1i_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlliOO : nllO1i;
	assign		wire_n0iO1l_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlll1i : nllO1l;
	assign		wire_n0iO1O_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlll1l : nllO1O;
	assign		wire_n0iOi_dataout = (rendec_data_sel_rx === 1'b1) ? wire_nli_dataout : (rx_control_rs & (~ nl0i1ll));
	assign		wire_n0iOii_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlll0O : nllOii;
	assign		wire_n0iOil_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlllii : nllOil;
	assign		wire_n0iOiO_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlllil : nllOiO;
	assign		wire_n0iOl_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0O0O_dataout : rx_data_dt[8];
	and(wire_n0iOli_dataout, nllOli, ~{wire_n0l0lO_o[2]});
	and(wire_n0iOll_dataout, nllOll, ~{wire_n0l0lO_o[2]});
	and(wire_n0iOlO_dataout, nllOlO, ~{wire_n0l0lO_o[2]});
	assign		wire_n0iOO_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0Oii_dataout : rx_data_dt[9];
	and(wire_n0iOOi_dataout, nllOOi, ~{wire_n0l0lO_o[2]});
	and(wire_n0iOOl_dataout, nllOOl, ~{wire_n0l0lO_o[2]});
	and(wire_n0iOOO_dataout, nllOOO, ~{wire_n0l0lO_o[2]});
	assign		wire_n0l_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O0i_o : nl0OliO;
	and(wire_n0l00i_dataout, nlO00i, ~{wire_n0l0lO_o[2]});
	and(wire_n0l00l_dataout, nlO00l, ~{wire_n0l0lO_o[2]});
	and(wire_n0l00O_dataout, nlO00O, ~{wire_n0l0lO_o[2]});
	and(wire_n0l01i_dataout, nlO01i, ~{wire_n0l0lO_o[2]});
	and(wire_n0l01l_dataout, nlO01l, ~{wire_n0l0lO_o[2]});
	and(wire_n0l01O_dataout, nlO01O, ~{wire_n0l0lO_o[2]});
	assign		wire_n0l0i_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0Oll_dataout : rx_data_dt[13];
	and(wire_n0l0ii_dataout, nlO0ii, ~{wire_n0l0lO_o[2]});
	and(wire_n0l0il_dataout, nlO0il, ~{wire_n0l0lO_o[2]});
	and(wire_n0l0iO_dataout, nlO0iO, ~{wire_n0l0lO_o[2]});
	assign		wire_n0l0l_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0OlO_dataout : rx_data_dt[14];
	and(wire_n0l0li_dataout, nlO0li, ~{wire_n0l0lO_o[2]});
	and(wire_n0l0ll_dataout, nlO0ll, ~{wire_n0l0lO_o[2]});
	assign		wire_n0l0O_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0OOi_dataout : rx_data_dt[15];
	assign		wire_n0l0Oi_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[0] : nllliO;
	assign		wire_n0l0Ol_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[1] : nlllli;
	assign		wire_n0l0OO_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[2] : nlllll;
	and(wire_n0l10i_dataout, nlO10i, ~{wire_n0l0lO_o[2]});
	and(wire_n0l10l_dataout, nlO10l, ~{wire_n0l0lO_o[2]});
	and(wire_n0l10O_dataout, nlO10O, ~{wire_n0l0lO_o[2]});
	and(wire_n0l11i_dataout, nlO11i, ~{wire_n0l0lO_o[2]});
	and(wire_n0l11l_dataout, nlO11l, ~{wire_n0l0lO_o[2]});
	and(wire_n0l11O_dataout, nlO11O, ~{wire_n0l0lO_o[2]});
	assign		wire_n0l1i_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0Oil_dataout : rx_data_dt[10];
	and(wire_n0l1ii_dataout, nlO1ii, ~{wire_n0l0lO_o[2]});
	and(wire_n0l1il_dataout, nlO1il, ~{wire_n0l0lO_o[2]});
	and(wire_n0l1iO_dataout, nlO1iO, ~{wire_n0l0lO_o[2]});
	assign		wire_n0l1l_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0OiO_dataout : rx_data_dt[11];
	and(wire_n0l1li_dataout, nlO1li, ~{wire_n0l0lO_o[2]});
	and(wire_n0l1ll_dataout, nlO1ll, ~{wire_n0l0lO_o[2]});
	and(wire_n0l1lO_dataout, nlO1lO, ~{wire_n0l0lO_o[2]});
	assign		wire_n0l1O_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0Oli_dataout : rx_data_dt[12];
	and(wire_n0l1Oi_dataout, nlO1Oi, ~{wire_n0l0lO_o[2]});
	and(wire_n0l1Ol_dataout, nlO1Ol, ~{wire_n0l0lO_o[2]});
	and(wire_n0l1OO_dataout, nlO1OO, ~{wire_n0l0lO_o[2]});
	assign		wire_n0li_dataout = (rrxfifo_dis === 1'b1) ? wire_n100iO_o : nl0O1Ol;
	assign		wire_n0li0i_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[6] : nlllOO;
	assign		wire_n0li0l_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[7] : nllO1i;
	assign		wire_n0li0O_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[8] : nllO1l;
	assign		wire_n0li1i_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[3] : nllllO;
	assign		wire_n0li1l_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[4] : nlllOi;
	assign		wire_n0li1O_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[5] : nlllOl;
	assign		wire_n0lii_dataout = (rendec_data_sel_rx === 1'b1) ? wire_n0OOl_dataout : rx_control_dt[1];
	assign		wire_n0liii_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[9] : nllO1O;
	assign		wire_n0liil_dataout = (wire_n0O11i_o[2] === 1'b1) ? nlll1O : nllO0i;
	and(wire_n0liiO_dataout, nllO0l, ~{wire_n0O11i_o[2]});
	assign		wire_n0lil_dataout = (rendec_data_sel_rx === 1'b1) ? ovr_undflow[0] : n11iO;
	and(wire_n0lili_dataout, nllO0O, ~{wire_n0O11i_o[2]});
	and(wire_n0lill_dataout, nllOii, ~{wire_n0O11i_o[2]});
	and(wire_n0lilO_dataout, nllOil, ~{wire_n0O11i_o[2]});
	assign		wire_n0liO_dataout = (rendec_data_sel_rx === 1'b1) ? ovr_undflow[1] : n11li;
	and(wire_n0liOi_dataout, nllOiO, ~{wire_n0O11i_o[2]});
	and(wire_n0liOl_dataout, nllOli, ~{wire_n0O11i_o[2]});
	and(wire_n0liOO_dataout, nllOll, ~{wire_n0O11i_o[2]});
	assign		wire_n0ll_dataout = (rrxfifo_dis === 1'b1) ? wire_n100li_o : nl0O1OO;
	and(wire_n0ll0i_dataout, nllOOO, ~{wire_n0O11i_o[2]});
	and(wire_n0ll0l_dataout, nlO11i, ~{wire_n0O11i_o[2]});
	and(wire_n0ll0O_dataout, nlO11l, ~{wire_n0O11i_o[2]});
	and(wire_n0ll1i_dataout, nllOlO, ~{wire_n0O11i_o[2]});
	and(wire_n0ll1l_dataout, nllOOi, ~{wire_n0O11i_o[2]});
	and(wire_n0ll1O_dataout, nllOOl, ~{wire_n0O11i_o[2]});
	assign		wire_n0lli_dataout = (rendec_data_sel_rx === 1'b1) ? ovr_undflow[2] : n11ll;
	and(wire_n0llii_dataout, nlO11O, ~{wire_n0O11i_o[2]});
	and(wire_n0llil_dataout, nlO10i, ~{wire_n0O11i_o[2]});
	and(wire_n0lliO_dataout, nlO10l, ~{wire_n0O11i_o[2]});
	assign		wire_n0lll_dataout = (rendec_data_sel_rx === 1'b1) ? ovr_undflow[3] : n11lO;
	and(wire_n0llli_dataout, nlO10O, ~{wire_n0O11i_o[2]});
	and(wire_n0llll_dataout, nlO1ii, ~{wire_n0O11i_o[2]});
	and(wire_n0lllO_dataout, nlO1il, ~{wire_n0O11i_o[2]});
	assign		wire_n0llO_dataout = (rendec_data_sel_rx === 1'b1) ? disp_val_delay[0] : n1i0l;
	and(wire_n0llOi_dataout, nlO1iO, ~{wire_n0O11i_o[2]});
	and(wire_n0llOl_dataout, nlO1li, ~{wire_n0O11i_o[2]});
	and(wire_n0llOO_dataout, nlO1ll, ~{wire_n0O11i_o[2]});
	assign		wire_n0lO_dataout = (rrxfifo_dis === 1'b1) ? wire_n100ll_o : nl0O01i;
	and(wire_n0lO0i_dataout, nlO1OO, ~{wire_n0O11i_o[2]});
	and(wire_n0lO0l_dataout, nlO01i, ~{wire_n0O11i_o[2]});
	and(wire_n0lO0O_dataout, nlO01l, ~{wire_n0O11i_o[2]});
	and(wire_n0lO1i_dataout, nlO1lO, ~{wire_n0O11i_o[2]});
	and(wire_n0lO1l_dataout, nlO1Oi, ~{wire_n0O11i_o[2]});
	and(wire_n0lO1O_dataout, nlO1Ol, ~{wire_n0O11i_o[2]});
	assign		wire_n0lOi_dataout = (rendec_data_sel_rx === 1'b1) ? disp_val_delay[1] : n1i0O;
	and(wire_n0lOii_dataout, nlO01O, ~{wire_n0O11i_o[2]});
	and(wire_n0lOil_dataout, nlO00i, ~{wire_n0O11i_o[2]});
	and(wire_n0lOiO_dataout, nlO00l, ~{wire_n0O11i_o[2]});
	assign		wire_n0lOl_dataout = (rendec_data_sel_rx === 1'b1) ? disp_err_delay[0] : n1iiO;
	and(wire_n0lOli_dataout, nlO00O, ~{wire_n0O11i_o[2]});
	and(wire_n0lOll_dataout, nlO0ii, ~{wire_n0O11i_o[2]});
	and(wire_n0lOlO_dataout, nlO0il, ~{wire_n0O11i_o[2]});
	assign		wire_n0lOO_dataout = (rendec_data_sel_rx === 1'b1) ? disp_err_delay[1] : n1ili;
	and(wire_n0lOOi_dataout, nlO0iO, ~{wire_n0O11i_o[2]});
	and(wire_n0lOOl_dataout, nlO0li, ~{wire_n0O11i_o[2]});
	and(wire_n0lOOO_dataout, nlO0ll, ~{wire_n0O11i_o[2]});
	assign		wire_n0O_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O0l_o : nl0Olli;
	assign		wire_n0O00i_dataout = (nl000iO === 1'b1) ? wire_ni1lll_dataout : wire_ni11il_dataout;
	assign		wire_n0O00l_dataout = (nl000iO === 1'b1) ? wire_ni1llO_dataout : wire_ni11iO_dataout;
	assign		wire_n0O00O_dataout = (nl000iO === 1'b1) ? wire_ni1lOi_dataout : wire_ni11li_dataout;
	assign		wire_n0O01i_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[14] : wire_ni110l_dataout;
	assign		wire_n0O01l_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[15] : wire_ni110O_dataout;
	assign		wire_n0O01O_dataout = (nl000iO === 1'b1) ? wire_ni1lli_dataout : wire_ni11ii_dataout;
	assign		wire_n0O0ii_dataout = (nl000iO === 1'b1) ? wire_ni1lOl_dataout : wire_ni11ll_dataout;
	assign		wire_n0O0il_dataout = (nl000iO === 1'b1) ? wire_ni1lOO_dataout : wire_ni11lO_dataout;
	assign		wire_n0O0iO_dataout = (nl000iO === 1'b1) ? wire_ni1O1i_dataout : wire_ni11Oi_dataout;
	assign		wire_n0O0l_dataout = ((~ n11ii) === 1'b1) ? wire_ni1Oi_dataout : wire_niOil_o;
	assign		wire_n0O0li_dataout = (nl000iO === 1'b1) ? wire_ni1O1l_dataout : wire_ni11Ol_dataout;
	assign		wire_n0O0ll_dataout = (nl000iO === 1'b1) ? wire_ni1O1O_dataout : wire_ni11OO_dataout;
	assign		wire_n0O0lO_dataout = (nl000iO === 1'b1) ? wire_ni1O0i_dataout : wire_ni101i_dataout;
	assign		wire_n0O0O_dataout = ((~ n11ii) === 1'b1) ? wire_ni1Ol_dataout : wire_n0OOO_dataout;
	assign		wire_n0O0Oi_dataout = (nl000iO === 1'b1) ? wire_ni1O0l_dataout : wire_ni101l_dataout;
	assign		wire_n0O0Ol_dataout = (nl000iO === 1'b1) ? wire_ni1O0O_dataout : wire_ni101O_dataout;
	assign		wire_n0O0OO_dataout = (nl000iO === 1'b1) ? wire_ni1Oii_dataout : wire_ni100i_dataout;
	assign		wire_n0O10i_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[2] : wire_n0OOil_dataout;
	assign		wire_n0O10l_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[3] : wire_n0OOiO_dataout;
	assign		wire_n0O10O_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[4] : wire_n0OOli_dataout;
	assign		wire_n0O11l_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[0] : wire_n0OO0O_dataout;
	assign		wire_n0O11O_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[1] : wire_n0OOii_dataout;
	assign		wire_n0O1i_dataout = (rendec_data_sel_rx === 1'b1) ? sync_resync_delay[0] : n1iOi;
	assign		wire_n0O1ii_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[5] : wire_n0OOll_dataout;
	assign		wire_n0O1il_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[6] : wire_n0OOlO_dataout;
	assign		wire_n0O1iO_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[7] : wire_n0OOOi_dataout;
	assign		wire_n0O1l_dataout = (rendec_data_sel_rx === 1'b1) ? sync_resync_delay[1] : n1iOl;
	assign		wire_n0O1li_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[8] : wire_n0OOOl_dataout;
	assign		wire_n0O1ll_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[9] : wire_n0OOOO_dataout;
	assign		wire_n0O1lO_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[10] : wire_ni111i_dataout;
	assign		wire_n0O1Oi_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[11] : wire_ni111l_dataout;
	assign		wire_n0O1Ol_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[12] : wire_ni111O_dataout;
	assign		wire_n0O1OO_dataout = (nl000iO === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[13] : wire_ni110i_dataout;
	assign		wire_n0Oi_dataout = (rrxfifo_dis === 1'b1) ? wire_n100lO_o : nl0O01l;
	assign		wire_n0Oi0i_dataout = (nl000iO === 1'b1) ? wire_ni1Oll_dataout : wire_ni10il_dataout;
	assign		wire_n0Oi0l_dataout = (nl000iO === 1'b1) ? wire_ni1OlO_dataout : wire_ni10iO_dataout;
	assign		wire_n0Oi0O_dataout = (nl000iO === 1'b1) ? wire_ni1OOi_dataout : wire_ni10li_dataout;
	assign		wire_n0Oi1i_dataout = (nl000iO === 1'b1) ? wire_ni1Oil_dataout : wire_ni100l_dataout;
	assign		wire_n0Oi1l_dataout = (nl000iO === 1'b1) ? wire_ni1OiO_dataout : wire_ni100O_dataout;
	assign		wire_n0Oi1O_dataout = (nl000iO === 1'b1) ? wire_ni1Oli_dataout : wire_ni10ii_dataout;
	assign		wire_n0Oii_dataout = ((~ n11ii) === 1'b1) ? wire_ni1OO_dataout : wire_ni11i_dataout;
	assign		wire_n0Oiii_dataout = (nl000iO === 1'b1) ? wire_ni1OOl_dataout : wire_ni10ll_dataout;
	assign		wire_n0Oiil_dataout = (nl000iO === 1'b1) ? wire_ni1OOO_dataout : wire_ni10lO_dataout;
	assign		wire_n0OiiO_dataout = (nl000iO === 1'b1) ? wire_ni011i_dataout : wire_ni10Oi_dataout;
	assign		wire_n0Oil_dataout = ((~ n11ii) === 1'b1) ? wire_ni01i_dataout : wire_ni11l_dataout;
	assign		wire_n0Oili_dataout = (nl000iO === 1'b1) ? wire_ni011l_dataout : wire_ni10Ol_dataout;
	assign		wire_n0Oill_dataout = (nl000iO === 1'b1) ? wire_ni011O_dataout : wire_ni10OO_dataout;
	assign		wire_n0OilO_dataout = (nl000iO === 1'b1) ? wire_ni010i_dataout : wire_ni1i1i_dataout;
	assign		wire_n0OiO_dataout = ((~ n11ii) === 1'b1) ? wire_ni01l_dataout : wire_ni11O_dataout;
	assign		wire_n0OiOi_dataout = (nl000iO === 1'b1) ? wire_ni010l_dataout : wire_ni1i1l_dataout;
	assign		wire_n0OiOl_dataout = (nl000iO === 1'b1) ? wire_ni010O_dataout : wire_ni1i1O_dataout;
	assign		wire_n0OiOO_dataout = (nl000iO === 1'b1) ? wire_ni01ii_dataout : wire_ni1i0i_dataout;
	assign		wire_n0Ol_dataout = (rrxfifo_dis === 1'b1) ? wire_n100Oi_o : nl0O01O;
	assign		wire_n0Ol0i_dataout = (nl000iO === 1'b1) ? wire_ni01ll_dataout : wire_ni1iil_dataout;
	assign		wire_n0Ol0l_dataout = (nl000iO === 1'b1) ? wire_ni01lO_dataout : wire_ni1iiO_dataout;
	assign		wire_n0Ol0O_dataout = (nl000iO === 1'b1) ? wire_ni01Oi_dataout : wire_ni1ili_dataout;
	assign		wire_n0Ol1i_dataout = (nl000iO === 1'b1) ? wire_ni01il_dataout : wire_ni1i0l_dataout;
	assign		wire_n0Ol1l_dataout = (nl000iO === 1'b1) ? wire_ni01iO_dataout : wire_ni1i0O_dataout;
	assign		wire_n0Ol1O_dataout = (nl000iO === 1'b1) ? wire_ni01li_dataout : wire_ni1iii_dataout;
	assign		wire_n0Oli_dataout = ((~ n11ii) === 1'b1) ? wire_ni01O_dataout : wire_ni10i_dataout;
	assign		wire_n0Olii_dataout = (nl000iO === 1'b1) ? wire_ni01Ol_dataout : wire_ni1ill_dataout;
	assign		wire_n0Olil_dataout = (nl000iO === 1'b1) ? wire_ni01OO_dataout : wire_ni1ilO_dataout;
	assign		wire_n0OliO_dataout = (nl000iO === 1'b1) ? wire_ni001i_dataout : wire_ni1iOi_dataout;
	assign		wire_n0Oll_dataout = ((~ n11ii) === 1'b1) ? wire_ni00i_dataout : wire_ni10l_dataout;
	assign		wire_n0Olli_dataout = (nl000iO === 1'b1) ? wire_ni001l_dataout : wire_ni1iOl_dataout;
	assign		wire_n0Olll_dataout = (nl000iO === 1'b1) ? wire_ni001O_dataout : wire_ni1iOO_dataout;
	assign		wire_n0OllO_dataout = (nl000iO === 1'b1) ? wire_ni000i_dataout : wire_ni1l1i_dataout;
	assign		wire_n0OlO_dataout = ((~ n11ii) === 1'b1) ? wire_ni00l_dataout : wire_ni10O_dataout;
	assign		wire_n0OlOi_dataout = (nl000iO === 1'b1) ? wire_ni000l_dataout : wire_ni1l1l_dataout;
	assign		wire_n0OlOl_dataout = (nl000iO === 1'b1) ? wire_ni000O_dataout : wire_ni1l1O_dataout;
	assign		wire_n0OlOO_dataout = (nl000iO === 1'b1) ? wire_ni00ii_dataout : wire_ni1l0i_dataout;
	assign		wire_n0OO_dataout = (rrxfifo_dis === 1'b1) ? wire_n100Ol_o : nl0O00i;
	assign		wire_n0OO0i_dataout = (nl000iO === 1'b1) ? wire_ni00ll_dataout : wire_ni1lil_dataout;
	assign		wire_n0OO0l_dataout = (nl000iO === 1'b1) ? wire_ni00lO_dataout : wire_ni1liO_dataout;
	assign		wire_n0OO0O_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nllliO : wire_nl0l00O_byte_des_fifo_data_in[0];
	assign		wire_n0OO1i_dataout = (nl000iO === 1'b1) ? wire_ni00il_dataout : wire_ni1l0l_dataout;
	assign		wire_n0OO1l_dataout = (nl000iO === 1'b1) ? wire_ni00iO_dataout : wire_ni1l0O_dataout;
	assign		wire_n0OO1O_dataout = (nl000iO === 1'b1) ? wire_ni00li_dataout : wire_ni1lii_dataout;
	assign		wire_n0OOi_dataout = ((~ n11ii) === 1'b1) ? wire_ni00O_dataout : wire_ni1ii_dataout;
	assign		wire_n0OOii_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlllli : wire_nl0l00O_byte_des_fifo_data_in[1];
	assign		wire_n0OOil_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlllll : wire_nl0l00O_byte_des_fifo_data_in[2];
	assign		wire_n0OOiO_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nllllO : wire_nl0l00O_byte_des_fifo_data_in[3];
	assign		wire_n0OOl_dataout = ((~ n11ii) === 1'b1) ? wire_ni0ii_dataout : wire_ni1il_dataout;
	assign		wire_n0OOli_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlllOi : wire_nl0l00O_byte_des_fifo_data_in[4];
	assign		wire_n0OOll_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlllOl : wire_nl0l00O_byte_des_fifo_data_in[5];
	assign		wire_n0OOlO_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nlllOO : wire_nl0l00O_byte_des_fifo_data_in[6];
	assign		wire_n0OOO_dataout = (nl0i1lO === 1'b1) ? rclkcmpinsertpad : rx_data_dt[8];
	assign		wire_n0OOOi_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nllO1i : wire_nl0l00O_byte_des_fifo_data_in[7];
	assign		wire_n0OOOl_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nllO1l : wire_nl0l00O_byte_des_fifo_data_in[8];
	assign		wire_n0OOOO_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nllO1O : wire_nl0l00O_byte_des_fifo_data_in[9];
	and(wire_n1011i_dataout, wire_n1011l_dataout, n11Oll);
	assign		wire_n1011l_dataout = (n11Oli === 1'b1) ? n11Oli : nlOO0l;
	or(wire_n1011O_dataout, nliO0i, (wire_nlOl1l_dataout & wire_nl01OO_dataout));
	assign		wire_n10i_dataout = (rrxfifo_dis === 1'b1) ? wire_n10iOO_o : nl0Oi0l;
	assign		wire_n10l_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O1i_o : nl0Ol0O;
	assign		wire_n10O_dataout = (rrxfifo_dis === 1'b1) ? wire_n1010l_o : nl0lOli;
	assign		wire_n10Oll_dataout = (nl0i11i === 1'b1) ? nlliil : wire_n1ilOO_dataout;
	assign		wire_n10OlO_dataout = (nl0i11i === 1'b1) ? nlliiO : wire_n1iO1i_dataout;
	assign		wire_n10OOi_dataout = (nl0i11i === 1'b1) ? nllili : wire_n1iO1l_dataout;
	assign		wire_n10OOl_dataout = (nl0i11i === 1'b1) ? nllill : wire_n1iO1O_dataout;
	assign		wire_n10OOO_dataout = (nl0i11i === 1'b1) ? nllilO : wire_n1iO0i_dataout;
	and(wire_n110l_dataout, n11O0O, ~{scan_mode});
	and(wire_n111l_dataout, n11O1O, ~{scan_mode});
	assign		wire_n11i_dataout = (rrxfifo_dis === 1'b1) ? wire_n100OO_o : nl0O00l;
	assign		wire_n11l_dataout = (rrxfifo_dis === 1'b1) ? wire_n101Oi_o : nl0O11O;
	assign		wire_n11O_dataout = (rrxfifo_dis === 1'b1) ? wire_n100Ol_o : nl0O00i;
	and(wire_n11OOi_dataout, wire_n11OOl_dataout, n11Oli);
	assign		wire_n11OOl_dataout = (rphfifo_master_sel_rx === 1'b1) ? wire_n11OOO_dataout : (~ rx_we_in_q0_ch0);
	assign		wire_n11OOO_dataout = (indv_rx === 1'b1) ? (~ n11O1l) : (~ rx_we_in_ch0);
	assign		wire_n1i_dataout = (rrxfifo_dis === 1'b1) ? wire_n10lOO_o : nl0Ol0l;
	assign		wire_n1i00i_dataout = (nl0i11i === 1'b1) ? wire_n1llll_dataout : wire_n1l1il_dataout;
	assign		wire_n1i00l_dataout = (nl0i11i === 1'b1) ? wire_n1lllO_dataout : wire_n1l1iO_dataout;
	assign		wire_n1i00O_dataout = (nl0i11i === 1'b1) ? wire_n1llOi_dataout : wire_n1l1li_dataout;
	assign		wire_n1i01i_dataout = (nl0i11i === 1'b1) ? wire_n1llil_dataout : wire_n1l10l_dataout;
	assign		wire_n1i01l_dataout = (nl0i11i === 1'b1) ? wire_n1lliO_dataout : wire_n1l10O_dataout;
	assign		wire_n1i01O_dataout = (nl0i11i === 1'b1) ? wire_n1llli_dataout : wire_n1l1ii_dataout;
	assign		wire_n1i0ii_dataout = (nl0i11i === 1'b1) ? wire_n1llOl_dataout : wire_n1l1ll_dataout;
	assign		wire_n1i0il_dataout = (nl0i11i === 1'b1) ? wire_n1llOO_dataout : wire_n1l1lO_dataout;
	assign		wire_n1i0iO_dataout = (nl0i11i === 1'b1) ? wire_n1lO1i_dataout : wire_n1l1Oi_dataout;
	assign		wire_n1i0li_dataout = (nl0i11i === 1'b1) ? wire_n1lO1l_dataout : wire_n1l1Ol_dataout;
	assign		wire_n1i0ll_dataout = (nl0i11i === 1'b1) ? wire_n1lO1O_dataout : wire_n1l1OO_dataout;
	assign		wire_n1i0lO_dataout = (nl0i11i === 1'b1) ? wire_n1lO0i_dataout : wire_n1l01i_dataout;
	assign		wire_n1i0Oi_dataout = (nl0i11i === 1'b1) ? wire_n1lO0l_dataout : wire_n1l01l_dataout;
	assign		wire_n1i0Ol_dataout = (nl0i11i === 1'b1) ? wire_n1lO0O_dataout : wire_n1l01O_dataout;
	assign		wire_n1i0OO_dataout = (nl0i11i === 1'b1) ? wire_n1lOii_dataout : wire_n1l00i_dataout;
	assign		wire_n1i10i_dataout = (nl0i11i === 1'b1) ? nlll1i : wire_n1iOil_dataout;
	assign		wire_n1i10l_dataout = (nl0i11i === 1'b1) ? nlll1l : wire_n1iOiO_dataout;
	assign		wire_n1i10O_dataout = (nl0i11i === 1'b1) ? nlll1O : wire_n1iOli_dataout;
	assign		wire_n1i11i_dataout = (nl0i11i === 1'b1) ? nlliOi : wire_n1iO0l_dataout;
	assign		wire_n1i11l_dataout = (nl0i11i === 1'b1) ? nlliOl : wire_n1iO0O_dataout;
	assign		wire_n1i11O_dataout = (nl0i11i === 1'b1) ? nlliOO : wire_n1iOii_dataout;
	assign		wire_n1i1ii_dataout = (nl0i11i === 1'b1) ? nlll0i : wire_n1iOll_dataout;
	assign		wire_n1i1il_dataout = (nl0i11i === 1'b1) ? nlll0l : wire_n1iOlO_dataout;
	assign		wire_n1i1iO_dataout = (nl0i11i === 1'b1) ? nlll0O : wire_n1iOOi_dataout;
	assign		wire_n1i1li_dataout = (nl0i11i === 1'b1) ? nlllii : wire_n1iOOl_dataout;
	assign		wire_n1i1ll_dataout = (nl0i11i === 1'b1) ? nlllil : wire_n1iOOO_dataout;
	assign		wire_n1i1lO_dataout = (nl0i11i === 1'b1) ? wire_n1ll0i_dataout : wire_n1l11i_dataout;
	assign		wire_n1i1Oi_dataout = (nl0i11i === 1'b1) ? wire_n1ll0l_dataout : wire_n1l11l_dataout;
	assign		wire_n1i1Ol_dataout = (nl0i11i === 1'b1) ? wire_n1ll0O_dataout : wire_n1l11O_dataout;
	assign		wire_n1i1OO_dataout = (nl0i11i === 1'b1) ? wire_n1llii_dataout : wire_n1l10i_dataout;
	assign		wire_n1ii_dataout = (rrxfifo_dis === 1'b1) ? wire_n1010O_o : nl0lOll;
	assign		wire_n1ii0i_dataout = (nl0i11i === 1'b1) ? wire_n1lOll_dataout : wire_n1l0il_dataout;
	assign		wire_n1ii0l_dataout = (nl0i11i === 1'b1) ? wire_n1lOlO_dataout : wire_n1l0iO_dataout;
	assign		wire_n1ii0O_dataout = (nl0i11i === 1'b1) ? wire_n1lOOi_dataout : wire_n1l0li_dataout;
	assign		wire_n1ii1i_dataout = (nl0i11i === 1'b1) ? wire_n1lOil_dataout : wire_n1l00l_dataout;
	assign		wire_n1ii1l_dataout = (nl0i11i === 1'b1) ? wire_n1lOiO_dataout : wire_n1l00O_dataout;
	assign		wire_n1ii1O_dataout = (nl0i11i === 1'b1) ? wire_n1lOli_dataout : wire_n1l0ii_dataout;
	assign		wire_n1iiii_dataout = (nl0i11i === 1'b1) ? wire_n1lOOl_dataout : wire_n1l0ll_dataout;
	assign		wire_n1iiil_dataout = (nl0i11i === 1'b1) ? wire_n1lOOO_dataout : wire_n1l0lO_dataout;
	assign		wire_n1iiiO_dataout = (nl0i11i === 1'b1) ? wire_n1O11i_dataout : wire_n1l0Oi_dataout;
	assign		wire_n1iili_dataout = (nl0i11i === 1'b1) ? wire_n1O11l_dataout : wire_n1l0Ol_dataout;
	assign		wire_n1iill_dataout = (nl0i11i === 1'b1) ? wire_n1O11O_dataout : wire_n1l0OO_dataout;
	assign		wire_n1iilO_dataout = (nl0i11i === 1'b1) ? wire_n1O10i_dataout : wire_n1li1i_dataout;
	assign		wire_n1iiOi_dataout = (nl0i11i === 1'b1) ? wire_n1O10l_dataout : wire_n1li1l_dataout;
	assign		wire_n1iiOl_dataout = (nl0i11i === 1'b1) ? wire_n1O10O_dataout : wire_n1li1O_dataout;
	assign		wire_n1iiOO_dataout = (nl0i11i === 1'b1) ? wire_n1O1ii_dataout : wire_n1li0i_dataout;
	assign		wire_n1il_dataout = (rrxfifo_dis === 1'b1) ? wire_n101ii_o : nl0lOlO;
	assign		wire_n1il0i_dataout = (nl0i11i === 1'b1) ? wire_n1O1ll_dataout : wire_n1liil_dataout;
	assign		wire_n1il0l_dataout = (nl0i11i === 1'b1) ? wire_n1O1lO_dataout : wire_n1liiO_dataout;
	assign		wire_n1il0O_dataout = (nl0i11i === 1'b1) ? wire_n1O1Oi_dataout : wire_n1lili_dataout;
	assign		wire_n1il1i_dataout = (nl0i11i === 1'b1) ? wire_n1O1il_dataout : wire_n1li0l_dataout;
	assign		wire_n1il1l_dataout = (nl0i11i === 1'b1) ? wire_n1O1iO_dataout : wire_n1li0O_dataout;
	assign		wire_n1il1O_dataout = (nl0i11i === 1'b1) ? wire_n1O1li_dataout : wire_n1liii_dataout;
	assign		wire_n1ilii_dataout = (nl0i11i === 1'b1) ? wire_n1O1Ol_dataout : wire_n1lill_dataout;
	assign		wire_n1ilil_dataout = (nl0i11i === 1'b1) ? wire_n1O1OO_dataout : wire_n1lilO_dataout;
	assign		wire_n1iliO_dataout = (nl0i11i === 1'b1) ? wire_n1O01i_dataout : wire_n1liOi_dataout;
	assign		wire_n1illi_dataout = (nl0i11i === 1'b1) ? wire_n1O01l_dataout : wire_n1liOl_dataout;
	assign		wire_n1illl_dataout = (nl0i11i === 1'b1) ? wire_n1O01O_dataout : wire_n1liOO_dataout;
	assign		wire_n1illO_dataout = (nl0i11i === 1'b1) ? wire_n1O00i_dataout : wire_n1ll1i_dataout;
	assign		wire_n1ilOi_dataout = (nl0i11i === 1'b1) ? wire_n1O00l_dataout : wire_n1ll1l_dataout;
	assign		wire_n1ilOl_dataout = (nl0i11i === 1'b1) ? wire_n1O00O_dataout : wire_n1ll1O_dataout;
	assign		wire_n1ilOO_dataout = (nl000lO === 1'b1) ? nll10O : nlliil;
	assign		wire_n1iO_dataout = (rrxfifo_dis === 1'b1) ? wire_n101il_o : nl0lOOi;
	assign		wire_n1iO0i_dataout = (nl000lO === 1'b1) ? nll1li : nllilO;
	assign		wire_n1iO0l_dataout = (nl000lO === 1'b1) ? nll1ll : nlliOi;
	assign		wire_n1iO0O_dataout = (nl000lO === 1'b1) ? nll1lO : nlliOl;
	assign		wire_n1iO1i_dataout = (nl000lO === 1'b1) ? nll1ii : nlliiO;
	assign		wire_n1iO1l_dataout = (nl000lO === 1'b1) ? nll1il : nllili;
	assign		wire_n1iO1O_dataout = (nl000lO === 1'b1) ? nll1iO : nllill;
	assign		wire_n1iOii_dataout = (nl000lO === 1'b1) ? nll1Oi : nlliOO;
	assign		wire_n1iOil_dataout = (nl000lO === 1'b1) ? nll1Ol : nlll1i;
	assign		wire_n1iOiO_dataout = (nl000lO === 1'b1) ? nll1OO : nlll1l;
	assign		wire_n1iOli_dataout = (nl000lO === 1'b1) ? nll01i : nlll1O;
	assign		wire_n1iOll_dataout = (nl000lO === 1'b1) ? nll01l : nlll0i;
	assign		wire_n1iOlO_dataout = (nl000lO === 1'b1) ? nll01O : nlll0l;
	assign		wire_n1iOOi_dataout = (nl000lO === 1'b1) ? nll00i : nlll0O;
	assign		wire_n1iOOl_dataout = (nl000lO === 1'b1) ? nll00l : nlllii;
	assign		wire_n1iOOO_dataout = (nl000lO === 1'b1) ? nll00O : nlllil;
	assign		wire_n1l_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O1i_o : nl0Ol0O;
	assign		wire_n1l00i_dataout = (nl000lO === 1'b1) ? nllili : nllOlO;
	assign		wire_n1l00l_dataout = (nl000lO === 1'b1) ? nllill : nllOOi;
	assign		wire_n1l00O_dataout = (nl000lO === 1'b1) ? nllilO : nllOOl;
	assign		wire_n1l01i_dataout = (nl000lO === 1'b1) ? nlliii : nllOiO;
	assign		wire_n1l01l_dataout = (nl000lO === 1'b1) ? nlliil : nllOli;
	assign		wire_n1l01O_dataout = (nl000lO === 1'b1) ? nlliiO : nllOll;
	assign		wire_n1l0ii_dataout = (nl000lO === 1'b1) ? nlliOi : nllOOO;
	assign		wire_n1l0il_dataout = (nl000lO === 1'b1) ? nlliOl : nlO11i;
	assign		wire_n1l0iO_dataout = (nl000lO === 1'b1) ? nlliOO : nlO11l;
	assign		wire_n1l0li_dataout = (nl000lO === 1'b1) ? nlll1i : nlO11O;
	assign		wire_n1l0ll_dataout = (nl000lO === 1'b1) ? nlll1l : nlO10i;
	assign		wire_n1l0lO_dataout = (nl000lO === 1'b1) ? nlll1O : nlO10l;
	assign		wire_n1l0Oi_dataout = (nl000lO === 1'b1) ? nlll0i : nlO10O;
	assign		wire_n1l0Ol_dataout = (nl000lO === 1'b1) ? nlll0l : nlO1ii;
	assign		wire_n1l0OO_dataout = (nl000lO === 1'b1) ? nlll0O : nlO1il;
	assign		wire_n1l10i_dataout = (nl000lO === 1'b1) ? nll0li : nllllO;
	assign		wire_n1l10l_dataout = (nl000lO === 1'b1) ? nll0ll : nlllOi;
	assign		wire_n1l10O_dataout = (nl000lO === 1'b1) ? nll0lO : nlllOl;
	assign		wire_n1l11i_dataout = (nl000lO === 1'b1) ? nll0ii : nllliO;
	assign		wire_n1l11l_dataout = (nl000lO === 1'b1) ? nll0il : nlllli;
	assign		wire_n1l11O_dataout = (nl000lO === 1'b1) ? nll0iO : nlllll;
	assign		wire_n1l1ii_dataout = (nl000lO === 1'b1) ? nll0Oi : nlllOO;
	assign		wire_n1l1il_dataout = (nl000lO === 1'b1) ? nll0Ol : nllO1i;
	assign		wire_n1l1iO_dataout = (nl000lO === 1'b1) ? nll0OO : nllO1l;
	assign		wire_n1l1li_dataout = (nl000lO === 1'b1) ? nlli1i : nllO1O;
	assign		wire_n1l1ll_dataout = (nl000lO === 1'b1) ? nlli1l : nllO0i;
	assign		wire_n1l1lO_dataout = (nl000lO === 1'b1) ? nlli1O : nllO0l;
	assign		wire_n1l1Oi_dataout = (nl000lO === 1'b1) ? nlli0i : nllO0O;
	assign		wire_n1l1Ol_dataout = (nl000lO === 1'b1) ? nlli0l : nllOii;
	assign		wire_n1l1OO_dataout = (nl000lO === 1'b1) ? nlli0O : nllOil;
	assign		wire_n1li_dataout = (rrxfifo_dis === 1'b1) ? wire_n101iO_o : nl0lOOl;
	assign		wire_n1li0i_dataout = (nl000lO === 1'b1) ? nlllli : nlO1lO;
	assign		wire_n1li0l_dataout = (nl000lO === 1'b1) ? nlllll : nlO1Oi;
	assign		wire_n1li0O_dataout = (nl000lO === 1'b1) ? nllllO : nlO1Ol;
	assign		wire_n1li1i_dataout = (nl000lO === 1'b1) ? nlllii : nlO1iO;
	assign		wire_n1li1l_dataout = (nl000lO === 1'b1) ? nlllil : nlO1li;
	assign		wire_n1li1O_dataout = (nl000lO === 1'b1) ? nllliO : nlO1ll;
	assign		wire_n1liii_dataout = (nl000lO === 1'b1) ? nlllOi : nlO1OO;
	assign		wire_n1liil_dataout = (nl000lO === 1'b1) ? nlllOl : nlO01i;
	assign		wire_n1liiO_dataout = (nl000lO === 1'b1) ? nlllOO : nlO01l;
	assign		wire_n1lili_dataout = (nl000lO === 1'b1) ? nllO1i : nlO01O;
	assign		wire_n1lill_dataout = (nl000lO === 1'b1) ? nllO1l : nlO00i;
	assign		wire_n1lilO_dataout = (nl000lO === 1'b1) ? nllO1O : nlO00l;
	assign		wire_n1liOi_dataout = (nl000lO === 1'b1) ? nllO0i : nlO00O;
	assign		wire_n1liOl_dataout = (nl000lO === 1'b1) ? nllO0l : nlO0ii;
	assign		wire_n1liOO_dataout = (nl000lO === 1'b1) ? nllO0O : nlO0il;
	assign		wire_n1ll_dataout = (rrxfifo_dis === 1'b1) ? wire_n101li_o : nl0lOOO;
	and(wire_n1ll0i_dataout, nllliO, ~{nl00i1l});
	and(wire_n1ll0l_dataout, nlllli, ~{nl00i1l});
	and(wire_n1ll0O_dataout, nlllll, ~{nl00i1l});
	assign		wire_n1ll1i_dataout = (nl000lO === 1'b1) ? nllOii : nlO0iO;
	assign		wire_n1ll1l_dataout = (nl000lO === 1'b1) ? nllOil : nlO0li;
	assign		wire_n1ll1O_dataout = (nl000lO === 1'b1) ? nllOiO : nlO0ll;
	and(wire_n1llii_dataout, nllllO, ~{nl00i1l});
	and(wire_n1llil_dataout, nlllOi, ~{nl00i1l});
	and(wire_n1lliO_dataout, nlllOl, ~{nl00i1l});
	and(wire_n1llli_dataout, nlllOO, ~{nl00i1l});
	and(wire_n1llll_dataout, nllO1i, ~{nl00i1l});
	and(wire_n1lllO_dataout, nllO1l, ~{nl00i1l});
	and(wire_n1llOi_dataout, nllO1O, ~{nl00i1l});
	and(wire_n1llOl_dataout, nllO0i, ~{nl00i1l});
	and(wire_n1llOO_dataout, nllO0l, ~{nl00i1l});
	assign		wire_n1lO_dataout = (rrxfifo_dis === 1'b1) ? wire_n101ll_o : nl0O11i;
	and(wire_n1lO0i_dataout, nllOiO, ~{nl00i1l});
	assign		wire_n1lO0l_dataout = (nl00i1l === 1'b1) ? rbytordpadval[0] : nllOli;
	assign		wire_n1lO0O_dataout = (nl00i1l === 1'b1) ? rbytordpadval[1] : nllOll;
	and(wire_n1lO1i_dataout, nllO0O, ~{nl00i1l});
	and(wire_n1lO1l_dataout, nllOii, ~{nl00i1l});
	and(wire_n1lO1O_dataout, nllOil, ~{nl00i1l});
	assign		wire_n1lOii_dataout = (nl00i1l === 1'b1) ? rbytordpadval[2] : nllOlO;
	assign		wire_n1lOil_dataout = (nl00i1l === 1'b1) ? rbytordpadval[3] : nllOOi;
	assign		wire_n1lOiO_dataout = (nl00i1l === 1'b1) ? rbytordpadval[4] : nllOOl;
	assign		wire_n1lOli_dataout = (nl00i1l === 1'b1) ? rbytordpadval[5] : nllOOO;
	assign		wire_n1lOll_dataout = (nl00i1l === 1'b1) ? rbytordpadval[6] : nlO11i;
	assign		wire_n1lOlO_dataout = (nl00i1l === 1'b1) ? rbytordpadval[7] : nlO11l;
	assign		wire_n1lOOi_dataout = (nl00i1l === 1'b1) ? rbytordpadval[8] : nlO11O;
	assign		wire_n1lOOl_dataout = (nl00i1l === 1'b1) ? rbytordpadval[9] : nlO10i;
	assign		wire_n1lOOO_dataout = (nl00i1l === 1'b1) ? nlll1O : nlO10l;
	assign		wire_n1O_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O1l_o : nl0Olii;
	and(wire_n1O00i_dataout, nlO0iO, ~{nl00i1l});
	and(wire_n1O00l_dataout, nlO0li, ~{nl00i1l});
	and(wire_n1O00O_dataout, nlO0ll, ~{nl00i1l});
	and(wire_n1O01i_dataout, nlO00O, ~{nl00i1l});
	and(wire_n1O01l_dataout, nlO0ii, ~{nl00i1l});
	and(wire_n1O01O_dataout, nlO0il, ~{nl00i1l});
	assign		wire_n1O0il_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[0] : wire_n011lO_dataout;
	assign		wire_n1O0iO_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[1] : wire_n011Oi_dataout;
	assign		wire_n1O0l_dataout = (n11il === 1'b1) ? n11il : wire_n1O0O_dataout;
	assign		wire_n1O0li_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[2] : wire_n011Ol_dataout;
	assign		wire_n1O0ll_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[3] : wire_n011OO_dataout;
	assign		wire_n1O0lO_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[4] : wire_n0101i_dataout;
	assign		wire_n1O0O_dataout = (rwa_6g_en === 1'b1) ? (sync_resync_delay[0] | sync_resync_delay[1]) : wire_n1Oii_dataout;
	assign		wire_n1O0Oi_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[5] : wire_n0101l_dataout;
	assign		wire_n1O0Ol_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[6] : wire_n0101O_dataout;
	assign		wire_n1O0OO_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[7] : wire_n0100i_dataout;
	and(wire_n1O10i_dataout, nlO1iO, ~{nl00i1l});
	and(wire_n1O10l_dataout, nlO1li, ~{nl00i1l});
	and(wire_n1O10O_dataout, nlO1ll, ~{nl00i1l});
	and(wire_n1O11i_dataout, nlO10O, ~{nl00i1l});
	and(wire_n1O11l_dataout, nlO1ii, ~{nl00i1l});
	and(wire_n1O11O_dataout, nlO1il, ~{nl00i1l});
	and(wire_n1O1ii_dataout, nlO1lO, ~{nl00i1l});
	and(wire_n1O1il_dataout, nlO1Oi, ~{nl00i1l});
	and(wire_n1O1iO_dataout, nlO1Ol, ~{nl00i1l});
	and(wire_n1O1li_dataout, nlO1OO, ~{nl00i1l});
	and(wire_n1O1ll_dataout, nlO01i, ~{nl00i1l});
	and(wire_n1O1lO_dataout, nlO01l, ~{nl00i1l});
	and(wire_n1O1Oi_dataout, nlO01O, ~{nl00i1l});
	and(wire_n1O1Ol_dataout, nlO00i, ~{nl00i1l});
	and(wire_n1O1OO_dataout, nlO00l, ~{nl00i1l});
	assign		wire_n1Oi_dataout = (rrxfifo_dis === 1'b1) ? wire_n101lO_o : nl0O11l;
	assign		wire_n1Oi0i_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[11] : wire_n010il_dataout;
	assign		wire_n1Oi0l_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[12] : wire_n010iO_dataout;
	assign		wire_n1Oi0O_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[13] : wire_n010li_dataout;
	assign		wire_n1Oi1i_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[8] : wire_n0100l_dataout;
	assign		wire_n1Oi1l_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[9] : wire_n0100O_dataout;
	assign		wire_n1Oi1O_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[10] : wire_n010ii_dataout;
	assign		wire_n1Oii_dataout = (rsync_sm_dis === 1'b1) ? wire_n1Oil_dataout : dec_data_valid_pre[0];
	assign		wire_n1Oiii_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[14] : wire_n010ll_dataout;
	assign		wire_n1Oiil_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[15] : wire_n010lO_dataout;
	assign		wire_n1OiiO_dataout = (nl0i11i === 1'b1) ? wire_n0011i_dataout : wire_n010Oi_dataout;
	assign		wire_n1Oil_dataout = ((tenb_data[8] & (~ rpmadatawidth)) === 1'b1) ? sync_resync_pre[0] : sync_resync_delay[0];
	assign		wire_n1Oili_dataout = (nl0i11i === 1'b1) ? wire_n0011l_dataout : wire_n010Ol_dataout;
	assign		wire_n1Oill_dataout = (nl0i11i === 1'b1) ? wire_n0011O_dataout : wire_n010OO_dataout;
	assign		wire_n1OilO_dataout = (nl0i11i === 1'b1) ? wire_n0010i_dataout : wire_n01i1i_dataout;
	assign		wire_n1OiOi_dataout = (nl0i11i === 1'b1) ? wire_n0010l_dataout : wire_n01i1l_dataout;
	assign		wire_n1OiOl_dataout = (nl0i11i === 1'b1) ? wire_n0010O_dataout : wire_n01i1O_dataout;
	assign		wire_n1OiOO_dataout = (nl0i11i === 1'b1) ? wire_n001ii_dataout : wire_n01i0i_dataout;
	assign		wire_n1Ol_dataout = (rrxfifo_dis === 1'b1) ? wire_n101Oi_o : nl0O11O;
	assign		wire_n1Ol0i_dataout = (nl0i11i === 1'b1) ? wire_n001ll_dataout : wire_n01iil_dataout;
	assign		wire_n1Ol0l_dataout = (nl0i11i === 1'b1) ? wire_n001lO_dataout : wire_n01iiO_dataout;
	assign		wire_n1Ol0O_dataout = (nl0i11i === 1'b1) ? wire_n001Oi_dataout : wire_n01ili_dataout;
	assign		wire_n1Ol1i_dataout = (nl0i11i === 1'b1) ? wire_n001il_dataout : wire_n01i0l_dataout;
	assign		wire_n1Ol1l_dataout = (nl0i11i === 1'b1) ? wire_n001iO_dataout : wire_n01i0O_dataout;
	assign		wire_n1Ol1O_dataout = (nl0i11i === 1'b1) ? wire_n001li_dataout : wire_n01iii_dataout;
	assign		wire_n1Olii_dataout = (nl0i11i === 1'b1) ? wire_n001Ol_dataout : wire_n01ill_dataout;
	assign		wire_n1Olil_dataout = (nl0i11i === 1'b1) ? wire_n001OO_dataout : wire_n01ilO_dataout;
	assign		wire_n1OliO_dataout = (nl0i11i === 1'b1) ? wire_n0001i_dataout : wire_n01iOi_dataout;
	assign		wire_n1Oll_dataout = (endec_rx === 1'b1) ? wire_n0i1l_dataout : wire_n00OO_dataout;
	assign		wire_n1Olli_dataout = (nl0i11i === 1'b1) ? wire_n0001l_dataout : wire_n01iOl_dataout;
	assign		wire_n1Olll_dataout = (nl0i11i === 1'b1) ? wire_n0001O_dataout : wire_n01iOO_dataout;
	assign		wire_n1OllO_dataout = (nl0i11i === 1'b1) ? wire_n0000i_dataout : wire_n01l1i_dataout;
	assign		wire_n1OlO_dataout = (endec_rx === 1'b1) ? wire_n0i1O_dataout : wire_n00Oi_dataout;
	assign		wire_n1OlOi_dataout = (nl0i11i === 1'b1) ? wire_n0000l_dataout : wire_n01l1l_dataout;
	assign		wire_n1OlOl_dataout = (nl0i11i === 1'b1) ? wire_n0000O_dataout : wire_n01l1O_dataout;
	assign		wire_n1OlOO_dataout = (nl0i11i === 1'b1) ? wire_n000ii_dataout : wire_n01l0i_dataout;
	assign		wire_n1OO_dataout = (rrxfifo_dis === 1'b1) ? wire_n101Ol_o : nl0O10i;
	assign		wire_n1OO0i_dataout = (nl0i11i === 1'b1) ? wire_n000ll_dataout : wire_n01lil_dataout;
	assign		wire_n1OO0l_dataout = (nl0i11i === 1'b1) ? wire_n000lO_dataout : wire_n01liO_dataout;
	assign		wire_n1OO0O_dataout = (nl0i11i === 1'b1) ? wire_n000Oi_dataout : wire_n01lli_dataout;
	assign		wire_n1OO1i_dataout = (nl0i11i === 1'b1) ? wire_n000il_dataout : wire_n01l0l_dataout;
	assign		wire_n1OO1l_dataout = (nl0i11i === 1'b1) ? wire_n000iO_dataout : wire_n01l0O_dataout;
	assign		wire_n1OO1O_dataout = (nl0i11i === 1'b1) ? wire_n000li_dataout : wire_n01lii_dataout;
	assign		wire_n1OOi_dataout = (endec_rx === 1'b1) ? wire_n0i0i_dataout : tenb_data[0];
	assign		wire_n1OOii_dataout = (nl0i11i === 1'b1) ? wire_n000Ol_dataout : wire_n01lll_dataout;
	assign		wire_n1OOil_dataout = (nl0i11i === 1'b1) ? wire_n000OO_dataout : wire_n01llO_dataout;
	assign		wire_n1OOiO_dataout = (nl0i11i === 1'b1) ? wire_n00i1i_dataout : wire_n01lOi_dataout;
	assign		wire_n1OOl_dataout = (endec_rx === 1'b1) ? wire_n0i0l_dataout : tenb_data[1];
	assign		wire_n1OOli_dataout = (nl0i11i === 1'b1) ? wire_n00i1l_dataout : wire_n01lOl_dataout;
	assign		wire_n1OOll_dataout = (nl0i11i === 1'b1) ? wire_n00i1O_dataout : wire_n01lOO_dataout;
	assign		wire_n1OOlO_dataout = (nl0i11i === 1'b1) ? wire_n00i0i_dataout : wire_n01O1i_dataout;
	assign		wire_n1OOO_dataout = (endec_rx === 1'b1) ? wire_n0i0O_dataout : tenb_data[2];
	assign		wire_n1OOOi_dataout = (nl0i11i === 1'b1) ? wire_n00i0l_dataout : wire_n01O1l_dataout;
	assign		wire_n1OOOl_dataout = (nl0i11i === 1'b1) ? wire_n00i0O_dataout : wire_n01O1O_dataout;
	assign		wire_n1OOOO_dataout = (nl0i11i === 1'b1) ? wire_n00iii_dataout : wire_n01O0i_dataout;
	and(wire_ni000i_dataout, wire_nl0l00O_byte_des_fifo_data_in[55], ~{wire_n0O11i_o[2]});
	and(wire_ni000l_dataout, wire_nl0l00O_byte_des_fifo_data_in[56], ~{wire_n0O11i_o[2]});
	and(wire_ni000O_dataout, wire_nl0l00O_byte_des_fifo_data_in[57], ~{wire_n0O11i_o[2]});
	and(wire_ni001i_dataout, wire_nl0l00O_byte_des_fifo_data_in[52], ~{wire_n0O11i_o[2]});
	and(wire_ni001l_dataout, wire_nl0l00O_byte_des_fifo_data_in[53], ~{wire_n0O11i_o[2]});
	and(wire_ni001O_dataout, wire_nl0l00O_byte_des_fifo_data_in[54], ~{wire_n0O11i_o[2]});
	and(wire_ni00i_dataout, rx_data_dt[13], ~{nl0i1Oi});
	and(wire_ni00ii_dataout, wire_nl0l00O_byte_des_fifo_data_in[58], ~{wire_n0O11i_o[2]});
	and(wire_ni00il_dataout, wire_nl0l00O_byte_des_fifo_data_in[59], ~{wire_n0O11i_o[2]});
	and(wire_ni00iO_dataout, wire_nl0l00O_byte_des_fifo_data_in[60], ~{wire_n0O11i_o[2]});
	and(wire_ni00l_dataout, rx_data_dt[14], ~{nl0i1Oi});
	and(wire_ni00li_dataout, wire_nl0l00O_byte_des_fifo_data_in[61], ~{wire_n0O11i_o[2]});
	and(wire_ni00ll_dataout, wire_nl0l00O_byte_des_fifo_data_in[62], ~{wire_n0O11i_o[2]});
	and(wire_ni00lO_dataout, wire_nl0l00O_byte_des_fifo_data_in[63], ~{wire_n0O11i_o[2]});
	or(wire_ni00O_dataout, rx_data_dt[15], nl0i1Oi);
	assign		wire_ni00Oi_dataout = (nl0i11i === 1'b1) ? nlliil : wire_nii01l_o;
	assign		wire_ni00Ol_dataout = (nl0i11i === 1'b1) ? nlliiO : wire_nii01O_o;
	assign		wire_ni00OO_dataout = (nl0i11i === 1'b1) ? nllili : wire_nii00i_o;
	and(wire_ni010i_dataout, wire_nl0l00O_byte_des_fifo_data_in[40], ~{wire_n0O11i_o[2]});
	and(wire_ni010l_dataout, wire_nl0l00O_byte_des_fifo_data_in[41], ~{wire_n0O11i_o[2]});
	and(wire_ni010O_dataout, wire_nl0l00O_byte_des_fifo_data_in[42], ~{wire_n0O11i_o[2]});
	and(wire_ni011i_dataout, wire_nl0l00O_byte_des_fifo_data_in[37], ~{wire_n0O11i_o[2]});
	and(wire_ni011l_dataout, wire_nl0l00O_byte_des_fifo_data_in[38], ~{wire_n0O11i_o[2]});
	and(wire_ni011O_dataout, wire_nl0l00O_byte_des_fifo_data_in[39], ~{wire_n0O11i_o[2]});
	or(wire_ni01i_dataout, rx_data_dt[10], nl0i1Oi);
	and(wire_ni01ii_dataout, wire_nl0l00O_byte_des_fifo_data_in[43], ~{wire_n0O11i_o[2]});
	and(wire_ni01il_dataout, wire_nl0l00O_byte_des_fifo_data_in[44], ~{wire_n0O11i_o[2]});
	and(wire_ni01iO_dataout, wire_nl0l00O_byte_des_fifo_data_in[45], ~{wire_n0O11i_o[2]});
	or(wire_ni01l_dataout, rx_data_dt[11], nl0i1Oi);
	and(wire_ni01li_dataout, wire_nl0l00O_byte_des_fifo_data_in[46], ~{wire_n0O11i_o[2]});
	and(wire_ni01ll_dataout, wire_nl0l00O_byte_des_fifo_data_in[47], ~{wire_n0O11i_o[2]});
	and(wire_ni01lO_dataout, wire_nl0l00O_byte_des_fifo_data_in[48], ~{wire_n0O11i_o[2]});
	or(wire_ni01O_dataout, rx_data_dt[12], nl0i1Oi);
	and(wire_ni01Oi_dataout, wire_nl0l00O_byte_des_fifo_data_in[49], ~{wire_n0O11i_o[2]});
	and(wire_ni01Ol_dataout, wire_nl0l00O_byte_des_fifo_data_in[50], ~{wire_n0O11i_o[2]});
	and(wire_ni01OO_dataout, wire_nl0l00O_byte_des_fifo_data_in[51], ~{wire_n0O11i_o[2]});
	assign		wire_ni0i_dataout = (rrxfifo_dis === 1'b1) ? wire_n10i1O_o : nl0O0il;
	assign		wire_ni0i0i_dataout = (nl0i11i === 1'b1) ? nlliOl : wire_nii0il_o;
	assign		wire_ni0i0l_dataout = (nl0i11i === 1'b1) ? nlliOO : wire_nii0iO_o;
	assign		wire_ni0i0O_dataout = (nl0i11i === 1'b1) ? nlll1i : wire_nii0li_o;
	assign		wire_ni0i1i_dataout = (nl0i11i === 1'b1) ? nllill : wire_nii00l_o;
	assign		wire_ni0i1l_dataout = (nl0i11i === 1'b1) ? nllilO : wire_nii00O_o;
	assign		wire_ni0i1O_dataout = (nl0i11i === 1'b1) ? nlliOi : wire_nii0ii_o;
	or(wire_ni0ii_dataout, rx_control_dt[1], nl0i1Oi);
	assign		wire_ni0iii_dataout = (nl0i11i === 1'b1) ? nlll1l : wire_nii0ll_o;
	assign		wire_ni0iil_dataout = (nl0i11i === 1'b1) ? nlll1O : wire_nii0lO_o;
	assign		wire_ni0iiO_dataout = (nl0i11i === 1'b1) ? nlll0i : wire_nii0Oi_o;
	assign		wire_ni0ili_dataout = (nl0i11i === 1'b1) ? nlll0l : wire_nii0Ol_o;
	assign		wire_ni0ill_dataout = (nl0i11i === 1'b1) ? nlll0O : wire_nii0OO_o;
	assign		wire_ni0ilO_dataout = (nl0i11i === 1'b1) ? nlllii : wire_niii1i_o;
	assign		wire_ni0iO_dataout = ((~ n110O) === 1'b1) ? wire_nil1l_dataout : wire_nliil_o;
	assign		wire_ni0iOi_dataout = (nl0i11i === 1'b1) ? nlllil : wire_niii1l_o;
	assign		wire_ni0iOl_dataout = (nl0i11i === 1'b1) ? wire_nil1li_dataout : wire_niii1O_o;
	assign		wire_ni0iOO_dataout = (nl0i11i === 1'b1) ? wire_nil1ll_dataout : wire_niii0i_o;
	assign		wire_ni0l_dataout = (rrxfifo_dis === 1'b1) ? wire_n10i0i_o : nl0O0iO;
	assign		wire_ni0l0i_dataout = (nl0i11i === 1'b1) ? wire_nil1OO_dataout : wire_niiiil_o;
	assign		wire_ni0l0l_dataout = (nl0i11i === 1'b1) ? wire_nil01i_dataout : wire_niiiiO_o;
	assign		wire_ni0l0O_dataout = (nl0i11i === 1'b1) ? wire_nil01l_dataout : wire_niiili_o;
	assign		wire_ni0l1i_dataout = (nl0i11i === 1'b1) ? wire_nil1lO_dataout : wire_niii0l_o;
	assign		wire_ni0l1l_dataout = (nl0i11i === 1'b1) ? wire_nil1Oi_dataout : wire_niii0O_o;
	assign		wire_ni0l1O_dataout = (nl0i11i === 1'b1) ? wire_nil1Ol_dataout : wire_niiiii_o;
	assign		wire_ni0li_dataout = ((~ n110O) === 1'b1) ? wire_nil1O_dataout : wire_nii0i_dataout;
	assign		wire_ni0lii_dataout = (nl0i11i === 1'b1) ? wire_nil01O_dataout : wire_niiill_o;
	assign		wire_ni0lil_dataout = (nl0i11i === 1'b1) ? wire_nil00i_dataout : wire_niiilO_o;
	assign		wire_ni0liO_dataout = (nl0i11i === 1'b1) ? wire_nil00l_dataout : wire_niiiOi_o;
	assign		wire_ni0ll_dataout = ((~ n110O) === 1'b1) ? wire_nil0i_dataout : wire_nii0l_dataout;
	assign		wire_ni0lli_dataout = (nl0i11i === 1'b1) ? wire_nil00O_dataout : wire_niiiOl_o;
	assign		wire_ni0lll_dataout = (nl0i11i === 1'b1) ? wire_nil0ii_dataout : wire_niiiOO_o;
	assign		wire_ni0llO_dataout = (nl0i11i === 1'b1) ? wire_nil0il_dataout : wire_niil1i_o;
	assign		wire_ni0lO_dataout = ((~ n110O) === 1'b1) ? wire_nil0l_dataout : wire_nii0O_dataout;
	assign		wire_ni0lOi_dataout = (nl0i11i === 1'b1) ? wire_nil0iO_dataout : wire_niil1l_o;
	assign		wire_ni0lOl_dataout = (nl0i11i === 1'b1) ? wire_nil0li_dataout : wire_niil1O_o;
	assign		wire_ni0lOO_dataout = (nl0i11i === 1'b1) ? wire_nil0ll_dataout : wire_niil0i_o;
	assign		wire_ni0O_dataout = (rrxfifo_dis === 1'b1) ? wire_n10i0l_o : nl0O0li;
	assign		wire_ni0O0i_dataout = (nl0i11i === 1'b1) ? wire_nil0OO_dataout : wire_niilil_o;
	assign		wire_ni0O0l_dataout = (nl0i11i === 1'b1) ? wire_nili1i_dataout : wire_niiliO_o;
	assign		wire_ni0O0O_dataout = (nl0i11i === 1'b1) ? wire_nili1l_dataout : wire_niilli_o;
	assign		wire_ni0O1i_dataout = (nl0i11i === 1'b1) ? wire_nil0lO_dataout : wire_niil0l_o;
	assign		wire_ni0O1l_dataout = (nl0i11i === 1'b1) ? wire_nil0Oi_dataout : wire_niil0O_o;
	assign		wire_ni0O1O_dataout = (nl0i11i === 1'b1) ? wire_nil0Ol_dataout : wire_niilii_o;
	assign		wire_ni0Oi_dataout = ((~ n110O) === 1'b1) ? wire_nil0O_dataout : wire_niiii_dataout;
	assign		wire_ni0Oii_dataout = (nl0i11i === 1'b1) ? wire_nili1O_dataout : wire_niilll_o;
	assign		wire_ni0Oil_dataout = (nl0i11i === 1'b1) ? wire_nili0i_dataout : wire_niillO_o;
	assign		wire_ni0OiO_dataout = (nl0i11i === 1'b1) ? wire_nili0l_dataout : wire_niilOi_o;
	assign		wire_ni0Ol_dataout = ((~ n110O) === 1'b1) ? wire_nilii_dataout : wire_niiil_dataout;
	assign		wire_ni0Oli_dataout = (nl0i11i === 1'b1) ? wire_nili0O_o : wire_niilOl_o;
	assign		wire_ni0Oll_dataout = (nl0i11i === 1'b1) ? wire_niliil_dataout : wire_niilOO_o;
	assign		wire_ni0OlO_dataout = (nl0i11i === 1'b1) ? wire_niliiO_dataout : wire_niiO1i_o;
	assign		wire_ni0OO_dataout = ((~ n110O) === 1'b1) ? wire_nilil_dataout : wire_niiiO_dataout;
	assign		wire_ni0OOi_dataout = (nl0i11i === 1'b1) ? wire_nilili_dataout : wire_niiO1l_o;
	assign		wire_ni0OOl_dataout = (nl0i11i === 1'b1) ? wire_nilill_dataout : wire_niiO1O_o;
	assign		wire_ni0OOO_dataout = (nl0i11i === 1'b1) ? wire_nililO_dataout : wire_niiO0i_o;
	assign		wire_ni100i_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[12] : wire_nl0l00O_byte_des_fifo_data_in[28];
	assign		wire_ni100l_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[13] : wire_nl0l00O_byte_des_fifo_data_in[29];
	assign		wire_ni100O_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[14] : wire_nl0l00O_byte_des_fifo_data_in[30];
	assign		wire_ni101i_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[9] : wire_nl0l00O_byte_des_fifo_data_in[25];
	assign		wire_ni101l_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[10] : wire_nl0l00O_byte_des_fifo_data_in[26];
	assign		wire_ni101O_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[11] : wire_nl0l00O_byte_des_fifo_data_in[27];
	or(wire_ni10i_dataout, rx_data_dt[12], nl0i1lO);
	assign		wire_ni10ii_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[15] : wire_nl0l00O_byte_des_fifo_data_in[31];
	and(wire_ni10il_dataout, wire_nl0l00O_byte_des_fifo_data_in[32], ~{wire_n0l0lO_o[2]});
	and(wire_ni10iO_dataout, wire_nl0l00O_byte_des_fifo_data_in[33], ~{wire_n0l0lO_o[2]});
	or(wire_ni10l_dataout, rx_data_dt[13], nl0i1lO);
	and(wire_ni10li_dataout, wire_nl0l00O_byte_des_fifo_data_in[34], ~{wire_n0l0lO_o[2]});
	and(wire_ni10ll_dataout, wire_nl0l00O_byte_des_fifo_data_in[35], ~{wire_n0l0lO_o[2]});
	and(wire_ni10lO_dataout, wire_nl0l00O_byte_des_fifo_data_in[36], ~{wire_n0l0lO_o[2]});
	or(wire_ni10O_dataout, rx_data_dt[14], nl0i1lO);
	and(wire_ni10Oi_dataout, wire_nl0l00O_byte_des_fifo_data_in[37], ~{wire_n0l0lO_o[2]});
	and(wire_ni10Ol_dataout, wire_nl0l00O_byte_des_fifo_data_in[38], ~{wire_n0l0lO_o[2]});
	and(wire_ni10OO_dataout, wire_nl0l00O_byte_des_fifo_data_in[39], ~{wire_n0l0lO_o[2]});
	assign		wire_ni110i_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nllOii : wire_nl0l00O_byte_des_fifo_data_in[13];
	assign		wire_ni110l_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nllOil : wire_nl0l00O_byte_des_fifo_data_in[14];
	assign		wire_ni110O_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nllOiO : wire_nl0l00O_byte_des_fifo_data_in[15];
	assign		wire_ni111i_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nllO0i : wire_nl0l00O_byte_des_fifo_data_in[10];
	assign		wire_ni111l_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nllO0l : wire_nl0l00O_byte_des_fifo_data_in[11];
	assign		wire_ni111O_dataout = (wire_n0l0lO_o[2] === 1'b1) ? nllO0O : wire_nl0l00O_byte_des_fifo_data_in[12];
	or(wire_ni11i_dataout, rx_data_dt[9], nl0i1lO);
	assign		wire_ni11ii_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[0] : wire_nl0l00O_byte_des_fifo_data_in[16];
	assign		wire_ni11il_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[1] : wire_nl0l00O_byte_des_fifo_data_in[17];
	assign		wire_ni11iO_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[2] : wire_nl0l00O_byte_des_fifo_data_in[18];
	or(wire_ni11l_dataout, rx_data_dt[10], nl0i1lO);
	assign		wire_ni11li_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[3] : wire_nl0l00O_byte_des_fifo_data_in[19];
	assign		wire_ni11ll_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[4] : wire_nl0l00O_byte_des_fifo_data_in[20];
	assign		wire_ni11lO_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[5] : wire_nl0l00O_byte_des_fifo_data_in[21];
	assign		wire_ni11O_dataout = (nl0i1lO === 1'b1) ? (~ rclkcmpinsertpad) : rx_data_dt[11];
	assign		wire_ni11Oi_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[6] : wire_nl0l00O_byte_des_fifo_data_in[22];
	assign		wire_ni11Ol_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[7] : wire_nl0l00O_byte_des_fifo_data_in[23];
	assign		wire_ni11OO_dataout = (wire_n0l0lO_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[8] : wire_nl0l00O_byte_des_fifo_data_in[24];
	assign		wire_ni1i_dataout = (rrxfifo_dis === 1'b1) ? wire_n100OO_o : nl0O00l;
	and(wire_ni1i0i_dataout, wire_nl0l00O_byte_des_fifo_data_in[43], ~{wire_n0l0lO_o[2]});
	and(wire_ni1i0l_dataout, wire_nl0l00O_byte_des_fifo_data_in[44], ~{wire_n0l0lO_o[2]});
	and(wire_ni1i0O_dataout, wire_nl0l00O_byte_des_fifo_data_in[45], ~{wire_n0l0lO_o[2]});
	and(wire_ni1i1i_dataout, wire_nl0l00O_byte_des_fifo_data_in[40], ~{wire_n0l0lO_o[2]});
	and(wire_ni1i1l_dataout, wire_nl0l00O_byte_des_fifo_data_in[41], ~{wire_n0l0lO_o[2]});
	and(wire_ni1i1O_dataout, wire_nl0l00O_byte_des_fifo_data_in[42], ~{wire_n0l0lO_o[2]});
	or(wire_ni1ii_dataout, rx_data_dt[15], nl0i1lO);
	and(wire_ni1iii_dataout, wire_nl0l00O_byte_des_fifo_data_in[46], ~{wire_n0l0lO_o[2]});
	and(wire_ni1iil_dataout, wire_nl0l00O_byte_des_fifo_data_in[47], ~{wire_n0l0lO_o[2]});
	and(wire_ni1iiO_dataout, wire_nl0l00O_byte_des_fifo_data_in[48], ~{wire_n0l0lO_o[2]});
	or(wire_ni1il_dataout, rx_control_dt[1], nl0i1lO);
	and(wire_ni1ili_dataout, wire_nl0l00O_byte_des_fifo_data_in[49], ~{wire_n0l0lO_o[2]});
	and(wire_ni1ill_dataout, wire_nl0l00O_byte_des_fifo_data_in[50], ~{wire_n0l0lO_o[2]});
	and(wire_ni1ilO_dataout, wire_nl0l00O_byte_des_fifo_data_in[51], ~{wire_n0l0lO_o[2]});
	and(wire_ni1iOi_dataout, wire_nl0l00O_byte_des_fifo_data_in[52], ~{wire_n0l0lO_o[2]});
	and(wire_ni1iOl_dataout, wire_nl0l00O_byte_des_fifo_data_in[53], ~{wire_n0l0lO_o[2]});
	and(wire_ni1iOO_dataout, wire_nl0l00O_byte_des_fifo_data_in[54], ~{wire_n0l0lO_o[2]});
	assign		wire_ni1l_dataout = (rrxfifo_dis === 1'b1) ? wire_n10i1i_o : nl0O00O;
	and(wire_ni1l0i_dataout, wire_nl0l00O_byte_des_fifo_data_in[58], ~{wire_n0l0lO_o[2]});
	and(wire_ni1l0l_dataout, wire_nl0l00O_byte_des_fifo_data_in[59], ~{wire_n0l0lO_o[2]});
	and(wire_ni1l0O_dataout, wire_nl0l00O_byte_des_fifo_data_in[60], ~{wire_n0l0lO_o[2]});
	and(wire_ni1l1i_dataout, wire_nl0l00O_byte_des_fifo_data_in[55], ~{wire_n0l0lO_o[2]});
	and(wire_ni1l1l_dataout, wire_nl0l00O_byte_des_fifo_data_in[56], ~{wire_n0l0lO_o[2]});
	and(wire_ni1l1O_dataout, wire_nl0l00O_byte_des_fifo_data_in[57], ~{wire_n0l0lO_o[2]});
	and(wire_ni1lii_dataout, wire_nl0l00O_byte_des_fifo_data_in[61], ~{wire_n0l0lO_o[2]});
	and(wire_ni1lil_dataout, wire_nl0l00O_byte_des_fifo_data_in[62], ~{wire_n0l0lO_o[2]});
	and(wire_ni1liO_dataout, wire_nl0l00O_byte_des_fifo_data_in[63], ~{wire_n0l0lO_o[2]});
	assign		wire_ni1lli_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[0] : wire_nl0l00O_byte_des_fifo_data_in[16];
	assign		wire_ni1lll_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[1] : wire_nl0l00O_byte_des_fifo_data_in[17];
	assign		wire_ni1llO_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[2] : wire_nl0l00O_byte_des_fifo_data_in[18];
	assign		wire_ni1lOi_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[3] : wire_nl0l00O_byte_des_fifo_data_in[19];
	assign		wire_ni1lOl_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[4] : wire_nl0l00O_byte_des_fifo_data_in[20];
	assign		wire_ni1lOO_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[5] : wire_nl0l00O_byte_des_fifo_data_in[21];
	assign		wire_ni1O_dataout = (rrxfifo_dis === 1'b1) ? wire_n10i1l_o : nl0O0ii;
	assign		wire_ni1O0i_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[9] : wire_nl0l00O_byte_des_fifo_data_in[25];
	assign		wire_ni1O0l_dataout = (wire_n0O11i_o[2] === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[10] : wire_nl0l00O_byte_des_fifo_data_in[26];
	and(wire_ni1O0O_dataout, wire_nl0l00O_byte_des_fifo_data_in[27], ~{wire_n0O11i_o[2]});
	assign		wire_ni1O1i_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[6] : wire_nl0l00O_byte_des_fifo_data_in[22];
	assign		wire_ni1O1l_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[7] : wire_nl0l00O_byte_des_fifo_data_in[23];
	assign		wire_ni1O1O_dataout = (wire_n0O11i_o[2] === 1'b1) ? rbytordpadval[8] : wire_nl0l00O_byte_des_fifo_data_in[24];
	and(wire_ni1Oi_dataout, wire_niOil_o, ~{nl0i1Oi});
	and(wire_ni1Oii_dataout, wire_nl0l00O_byte_des_fifo_data_in[28], ~{wire_n0O11i_o[2]});
	and(wire_ni1Oil_dataout, wire_nl0l00O_byte_des_fifo_data_in[29], ~{wire_n0O11i_o[2]});
	and(wire_ni1OiO_dataout, wire_nl0l00O_byte_des_fifo_data_in[30], ~{wire_n0O11i_o[2]});
	and(wire_ni1Ol_dataout, rx_data_dt[8], ~{nl0i1Oi});
	and(wire_ni1Oli_dataout, wire_nl0l00O_byte_des_fifo_data_in[31], ~{wire_n0O11i_o[2]});
	and(wire_ni1Oll_dataout, wire_nl0l00O_byte_des_fifo_data_in[32], ~{wire_n0O11i_o[2]});
	and(wire_ni1OlO_dataout, wire_nl0l00O_byte_des_fifo_data_in[33], ~{wire_n0O11i_o[2]});
	and(wire_ni1OO_dataout, rx_data_dt[9], ~{nl0i1Oi});
	and(wire_ni1OOi_dataout, wire_nl0l00O_byte_des_fifo_data_in[34], ~{wire_n0O11i_o[2]});
	and(wire_ni1OOl_dataout, wire_nl0l00O_byte_des_fifo_data_in[35], ~{wire_n0O11i_o[2]});
	and(wire_ni1OOO_dataout, wire_nl0l00O_byte_des_fifo_data_in[36], ~{wire_n0O11i_o[2]});
	assign		wire_nii_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O0O_o : nl0Olll;
	assign		wire_nii01i_dataout = (nl0i11i === 1'b1) ? wire_nilO1i_dataout : wire_nil10l_o;
	assign		wire_nii0i_dataout = (nl0i1Ol === 1'b1) ? rclkcmpinsertpad : rx_data_dt[0];
	or(wire_nii0l_dataout, rx_data_dt[1], nl0i1Ol);
	or(wire_nii0O_dataout, rx_data_dt[2], nl0i1Ol);
	assign		wire_nii10i_dataout = (nl0i11i === 1'b1) ? wire_nill1l_dataout : wire_niiOil_o;
	assign		wire_nii10l_dataout = (nl0i11i === 1'b1) ? wire_nill1O_dataout : wire_niiOiO_o;
	assign		wire_nii10O_dataout = (nl0i11i === 1'b1) ? wire_nill0i_dataout : wire_niiOli_o;
	assign		wire_nii11i_dataout = (nl0i11i === 1'b1) ? wire_niliOl_dataout : wire_niiO0l_o;
	assign		wire_nii11l_dataout = (nl0i11i === 1'b1) ? wire_niliOO_dataout : wire_niiO0O_o;
	assign		wire_nii11O_dataout = (nl0i11i === 1'b1) ? wire_nill1i_dataout : wire_niiOii_o;
	assign		wire_nii1i_dataout = ((~ n110O) === 1'b1) ? wire_niliO_dataout : wire_niili_dataout;
	assign		wire_nii1ii_dataout = (nl0i11i === 1'b1) ? wire_nill0l_dataout : wire_niiOll_o;
	assign		wire_nii1il_dataout = (nl0i11i === 1'b1) ? wire_nill0O_dataout : wire_niiOlO_o;
	assign		wire_nii1iO_dataout = (nl0i11i === 1'b1) ? wire_nillii_dataout : wire_niiOOi_o;
	assign		wire_nii1l_dataout = ((~ n110O) === 1'b1) ? wire_nilli_dataout : wire_niill_dataout;
	assign		wire_nii1li_dataout = (nl0i11i === 1'b1) ? wire_nillil_dataout : wire_niiOOl_o;
	assign		wire_nii1ll_dataout = (nl0i11i === 1'b1) ? wire_nilliO_o : wire_niiOOO_o;
	assign		wire_nii1lO_dataout = (nl0i11i === 1'b1) ? wire_nilllO_dataout : wire_nil11i_o;
	assign		wire_nii1O_dataout = ((~ n110O) === 1'b1) ? wire_nilll_dataout : wire_niilO_dataout;
	assign		wire_nii1Oi_dataout = (nl0i11i === 1'b1) ? wire_nillOi_dataout : wire_nil11l_o;
	assign		wire_nii1Ol_dataout = (nl0i11i === 1'b1) ? wire_nillOl_dataout : wire_nil11O_o;
	assign		wire_nii1OO_dataout = (nl0i11i === 1'b1) ? wire_nillOO_dataout : wire_nil10i_o;
	assign		wire_niii_dataout = (rrxfifo_dis === 1'b1) ? wire_n10i0O_o : nl0O0ll;
	assign		wire_niiii_dataout = (nl0i1Ol === 1'b1) ? (~ rclkcmpinsertpad) : rx_data_dt[3];
	or(wire_niiil_dataout, rx_data_dt[4], nl0i1Ol);
	or(wire_niiiO_dataout, rx_data_dt[5], nl0i1Ol);
	assign		wire_niil_dataout = (rrxfifo_dis === 1'b1) ? wire_n10iii_o : nl0O0lO;
	or(wire_niili_dataout, rx_data_dt[6], nl0i1Ol);
	or(wire_niill_dataout, rx_data_dt[7], nl0i1Ol);
	or(wire_niilO_dataout, rx_control_dt[0], nl0i1Ol);
	assign		wire_niiO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10iil_o : nl0O0Oi;
	assign		wire_nil_dataout = (rrxfifo_dis === 1'b1) ? wire_n10Oii_o : nl0OllO;
	assign		wire_nil00i_dataout = (nl00i1i === 1'b1) ? rbytordpadval[9] : nllO1O;
	assign		wire_nil00l_dataout = (nl00i1i === 1'b1) ? nlll1O : nllO0i;
	and(wire_nil00O_dataout, nllO0l, ~{nl00i1i});
	assign		wire_nil01i_dataout = (nl00i1i === 1'b1) ? rbytordpadval[6] : nlllOO;
	assign		wire_nil01l_dataout = (nl00i1i === 1'b1) ? rbytordpadval[7] : nllO1i;
	assign		wire_nil01O_dataout = (nl00i1i === 1'b1) ? rbytordpadval[8] : nllO1l;
	and(wire_nil0i_dataout, rx_data_dt[1], ~{nl0i1OO});
	and(wire_nil0ii_dataout, nllO0O, ~{nl00i1i});
	and(wire_nil0il_dataout, nllOii, ~{nl00i1i});
	and(wire_nil0iO_dataout, nllOil, ~{nl00i1i});
	or(wire_nil0l_dataout, rx_data_dt[2], nl0i1OO);
	and(wire_nil0li_dataout, nllOiO, ~{nl00i1i});
	assign		wire_nil0ll_dataout = (nl000Ol === 1'b1) ? rbytordpadval[0] : nllOli;
	assign		wire_nil0lO_dataout = (nl000Ol === 1'b1) ? rbytordpadval[1] : nllOll;
	or(wire_nil0O_dataout, rx_data_dt[3], nl0i1OO);
	assign		wire_nil0Oi_dataout = (nl000Ol === 1'b1) ? rbytordpadval[2] : nllOlO;
	assign		wire_nil0Ol_dataout = (nl000Ol === 1'b1) ? rbytordpadval[3] : nllOOi;
	assign		wire_nil0OO_dataout = (nl000Ol === 1'b1) ? rbytordpadval[4] : nllOOl;
	and(wire_nil1l_dataout, wire_nliil_o, ~{nl0i1OO});
	assign		wire_nil1li_dataout = (nl00i1i === 1'b1) ? rbytordpadval[0] : nllliO;
	assign		wire_nil1ll_dataout = (nl00i1i === 1'b1) ? rbytordpadval[1] : nlllli;
	assign		wire_nil1lO_dataout = (nl00i1i === 1'b1) ? rbytordpadval[2] : nlllll;
	and(wire_nil1O_dataout, rx_data_dt[0], ~{nl0i1OO});
	assign		wire_nil1Oi_dataout = (nl00i1i === 1'b1) ? rbytordpadval[3] : nllllO;
	assign		wire_nil1Ol_dataout = (nl00i1i === 1'b1) ? rbytordpadval[4] : nlllOi;
	assign		wire_nil1OO_dataout = (nl00i1i === 1'b1) ? rbytordpadval[5] : nlllOl;
	assign		wire_nili_dataout = (rrxfifo_dis === 1'b1) ? wire_n10iiO_o : nl0O0Ol;
	assign		wire_nili0i_dataout = (nl000Ol === 1'b1) ? rbytordpadval[8] : nlO11O;
	assign		wire_nili0l_dataout = (nl000Ol === 1'b1) ? rbytordpadval[9] : nlO10i;
	assign		wire_nili1i_dataout = (nl000Ol === 1'b1) ? rbytordpadval[5] : nllOOO;
	assign		wire_nili1l_dataout = (nl000Ol === 1'b1) ? rbytordpadval[6] : nlO11i;
	assign		wire_nili1O_dataout = (nl000Ol === 1'b1) ? rbytordpadval[7] : nlO11l;
	or(wire_nilii_dataout, rx_data_dt[4], nl0i1OO);
	and(wire_niliil_dataout, nlO10O, ~{nl000Ol});
	and(wire_niliiO_dataout, nlO1ii, ~{nl000Ol});
	and(wire_nilil_dataout, rx_data_dt[5], ~{nl0i1OO});
	and(wire_nilili_dataout, nlO1il, ~{nl000Ol});
	and(wire_nilill_dataout, nlO1iO, ~{nl000Ol});
	and(wire_nililO_dataout, nlO1li, ~{nl000Ol});
	and(wire_niliO_dataout, rx_data_dt[6], ~{nl0i1OO});
	assign		wire_niliOl_dataout = (nl00i1O === 1'b1) ? rbytordpadval[0] : nlO1ll;
	assign		wire_niliOO_dataout = (nl00i1O === 1'b1) ? rbytordpadval[1] : nlO1lO;
	assign		wire_nill_dataout = (rrxfifo_dis === 1'b1) ? wire_n10ili_o : nl0O0OO;
	assign		wire_nill0i_dataout = (nl00i1O === 1'b1) ? rbytordpadval[5] : nlO01i;
	assign		wire_nill0l_dataout = (nl00i1O === 1'b1) ? rbytordpadval[6] : nlO01l;
	assign		wire_nill0O_dataout = (nl00i1O === 1'b1) ? rbytordpadval[7] : nlO01O;
	assign		wire_nill1i_dataout = (nl00i1O === 1'b1) ? rbytordpadval[2] : nlO1Oi;
	assign		wire_nill1l_dataout = (nl00i1O === 1'b1) ? rbytordpadval[3] : nlO1Ol;
	assign		wire_nill1O_dataout = (nl00i1O === 1'b1) ? rbytordpadval[4] : nlO1OO;
	or(wire_nilli_dataout, rx_data_dt[7], nl0i1OO);
	assign		wire_nillii_dataout = (nl00i1O === 1'b1) ? rbytordpadval[8] : nlO00i;
	assign		wire_nillil_dataout = (nl00i1O === 1'b1) ? rbytordpadval[9] : nlO00l;
	or(wire_nilll_dataout, rx_control_dt[0], nl0i1OO);
	and(wire_nilllO_dataout, nlO0ii, ~{nl00i1O});
	and(wire_nillOi_dataout, nlO0il, ~{nl00i1O});
	and(wire_nillOl_dataout, nlO0iO, ~{nl00i1O});
	and(wire_nillOO_dataout, nlO0li, ~{nl00i1O});
	assign		wire_nilO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10ill_o : nl0Oi1i;
	assign		wire_nilO0i_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[0] : wire_niOlil_o;
	assign		wire_nilO0l_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[1] : wire_niOliO_o;
	assign		wire_nilO0O_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[2] : wire_niOlli_o;
	and(wire_nilO1i_dataout, nlO0ll, ~{nl00i1O});
	assign		wire_nilOii_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[3] : wire_niOlll_o;
	assign		wire_nilOil_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[4] : wire_niOllO_o;
	assign		wire_nilOiO_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[5] : wire_niOlOi_o;
	assign		wire_nilOli_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[6] : wire_niOlOl_o;
	assign		wire_nilOll_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[7] : wire_niOlOO_o;
	assign		wire_nilOlO_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[8] : wire_niOO1i_o;
	assign		wire_nilOOi_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[9] : wire_niOO1l_o;
	assign		wire_nilOOl_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[10] : wire_niOO1O_o;
	assign		wire_nilOOO_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[11] : wire_niOO0i_o;
	assign		wire_niO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10Oil_o : nl0OlOi;
	assign		wire_niO00i_dataout = (nl0i11i === 1'b1) ? wire_nl1lll_dataout : wire_nl11il_o;
	assign		wire_niO00l_dataout = (nl0i11i === 1'b1) ? wire_nl1llO_dataout : wire_nl11iO_o;
	assign		wire_niO00O_dataout = (nl0i11i === 1'b1) ? wire_nl1lOi_dataout : wire_nl11li_o;
	assign		wire_niO01i_dataout = (nl0i11i === 1'b1) ? wire_nl1lil_dataout : wire_nl110l_o;
	assign		wire_niO01l_dataout = (nl0i11i === 1'b1) ? wire_nl1liO_dataout : wire_nl110O_o;
	assign		wire_niO01O_dataout = (nl0i11i === 1'b1) ? wire_nl1lli_dataout : wire_nl11ii_o;
	assign		wire_niO0ii_dataout = (nl0i11i === 1'b1) ? wire_nl1lOl_dataout : wire_nl11ll_o;
	assign		wire_niO0il_dataout = (nl0i11i === 1'b1) ? wire_nl1lOO_dataout : wire_nl11lO_o;
	assign		wire_niO0iO_dataout = (nl0i11i === 1'b1) ? wire_nl1O1i_dataout : wire_nl11Oi_o;
	assign		wire_niO0li_dataout = (nl0i11i === 1'b1) ? wire_nl1O1l_dataout : wire_nl11Ol_o;
	assign		wire_niO0ll_dataout = (nl0i11i === 1'b1) ? wire_nl1O1O_dataout : wire_nl11OO_o;
	assign		wire_niO0lO_dataout = (nl0i11i === 1'b1) ? wire_nl1O0i_dataout : wire_nl101i_o;
	assign		wire_niO0Oi_dataout = (nl0i11i === 1'b1) ? wire_nl1O0l_dataout : wire_nl101l_o;
	assign		wire_niO0Ol_dataout = (nl0i11i === 1'b1) ? wire_nl1O0O_dataout : wire_nl101O_o;
	assign		wire_niO0OO_dataout = (nl0i11i === 1'b1) ? wire_nl1Oii_dataout : wire_nl100i_o;
	assign		wire_niO10i_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[15] : wire_niOOil_o;
	assign		wire_niO10l_dataout = (nl0i11i === 1'b1) ? wire_nl1ilO_dataout : wire_niOOiO_o;
	assign		wire_niO10O_dataout = (nl0i11i === 1'b1) ? wire_nl1iOi_dataout : wire_niOOli_o;
	assign		wire_niO11i_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[12] : wire_niOO0l_o;
	assign		wire_niO11l_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[13] : wire_niOO0O_o;
	assign		wire_niO11O_dataout = (nl0i11i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[14] : wire_niOOii_o;
	assign		wire_niO1ii_dataout = (nl0i11i === 1'b1) ? wire_nl1iOl_dataout : wire_niOOll_o;
	assign		wire_niO1il_dataout = (nl0i11i === 1'b1) ? wire_nl1iOO_dataout : wire_niOOlO_o;
	assign		wire_niO1iO_dataout = (nl0i11i === 1'b1) ? wire_nl1l1i_dataout : wire_niOOOi_o;
	assign		wire_niO1li_dataout = (nl0i11i === 1'b1) ? wire_nl1l1l_dataout : wire_niOOOl_o;
	assign		wire_niO1ll_dataout = (nl0i11i === 1'b1) ? wire_nl1l1O_dataout : wire_niOOOO_o;
	assign		wire_niO1lO_dataout = (nl0i11i === 1'b1) ? wire_nl1l0i_dataout : wire_nl111i_o;
	assign		wire_niO1Oi_dataout = (nl0i11i === 1'b1) ? wire_nl1l0l_dataout : wire_nl111l_o;
	assign		wire_niO1Ol_dataout = (nl0i11i === 1'b1) ? wire_nl1l0O_dataout : wire_nl111O_o;
	assign		wire_niO1OO_dataout = (nl0i11i === 1'b1) ? wire_nl1lii_dataout : wire_nl110i_o;
	assign		wire_niOi_dataout = (rrxfifo_dis === 1'b1) ? wire_n10ilO_o : nl0Oi1l;
	assign		wire_niOi0i_dataout = (nl0i11i === 1'b1) ? wire_nl1Oll_dataout : wire_nl10il_o;
	assign		wire_niOi0l_dataout = (nl0i11i === 1'b1) ? wire_nl1OlO_dataout : wire_nl10iO_o;
	assign		wire_niOi0O_dataout = (nl0i11i === 1'b1) ? wire_nl1OOi_dataout : wire_nl10li_o;
	assign		wire_niOi1i_dataout = (nl0i11i === 1'b1) ? wire_nl1Oil_o : wire_nl100l_o;
	assign		wire_niOi1l_dataout = (nl0i11i === 1'b1) ? wire_nl1OiO_dataout : wire_nl100O_o;
	assign		wire_niOi1O_dataout = (nl0i11i === 1'b1) ? wire_nl1Oli_dataout : wire_nl10ii_o;
	assign		wire_niOiii_dataout = (nl0i11i === 1'b1) ? wire_nl1OOl_dataout : wire_nl10ll_o;
	assign		wire_niOiil_dataout = (nl0i11i === 1'b1) ? wire_nl1OOO_dataout : wire_nl10lO_o;
	assign		wire_niOiiO_dataout = (nl0i11i === 1'b1) ? wire_nl011i_dataout : wire_nl10Oi_o;
	assign		wire_niOili_dataout = (nl0i11i === 1'b1) ? wire_nl011l_dataout : wire_nl10Ol_o;
	assign		wire_niOill_dataout = (nl0i11i === 1'b1) ? wire_nl011O_dataout : wire_nl10OO_o;
	assign		wire_niOilO_dataout = (nl0i11i === 1'b1) ? wire_nl010i_dataout : wire_nl1i1i_o;
	assign		wire_niOiOi_dataout = (nl0i11i === 1'b1) ? wire_nl010l_dataout : wire_nl1i1l_o;
	assign		wire_niOiOl_dataout = (nl0i11i === 1'b1) ? wire_nl010O_dataout : wire_nl1i1O_o;
	assign		wire_niOiOO_dataout = (nl0i11i === 1'b1) ? wire_nl01ii_dataout : wire_nl1i0i_o;
	assign		wire_niOl_dataout = (rrxfifo_dis === 1'b1) ? wire_n10iOi_o : nl0Oi1O;
	assign		wire_niOl0i_dataout = (nl0i11i === 1'b1) ? wire_nl01ll_dataout : wire_nl1iil_o;
	assign		wire_niOl0l_dataout = (nl0i11i === 1'b1) ? wire_nl01lO_dataout : wire_nl1iiO_o;
	assign		wire_niOl0O_dataout = (nl0i11i === 1'b1) ? wire_nl01Oi_dataout : wire_nl1ili_o;
	assign		wire_niOl1i_dataout = (nl0i11i === 1'b1) ? wire_nl01il_dataout : wire_nl1i0l_o;
	assign		wire_niOl1l_dataout = (nl0i11i === 1'b1) ? wire_nl01iO_o : wire_nl1i0O_o;
	assign		wire_niOl1O_dataout = (nl0i11i === 1'b1) ? wire_nl01li_dataout : wire_nl1iii_o;
	assign		wire_niOlii_dataout = (nl0i11i === 1'b1) ? wire_nl01Ol_dataout : wire_nl1ill_o;
	assign		wire_niOO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10iOl_o : nl0Oi0i;
	and(wire_nl001i_dataout, wire_nl000l_o, ~{nl0i11l});
	and(wire_nl001l_dataout, wire_nl000O_o, ~{nl0i11l});
	and(wire_nl001O_dataout, wire_nl00ii_o, ~{nl0i11l});
	assign		wire_nl00li_dataout = (rwa_6g_en === 1'b1) ? (nl00i0O & nl00i0l) : (nlO0lO & (nl00iii & nl00i0O));
	and(wire_nl00Ol_dataout, wire_nl00OO_dataout, rwa_6g_en);
	assign		wire_nl00OO_dataout = (rdwidth === 1'b1) ? (nl00iil & nl00iii) : (nl00ili & nl00iil);
	assign		wire_nl010i_dataout = (nl00i1O === 1'b1) ? rbytordpadval[5] : wire_nl0l00O_byte_des_fifo_data_in[53];
	assign		wire_nl010l_dataout = (nl00i1O === 1'b1) ? rbytordpadval[6] : wire_nl0l00O_byte_des_fifo_data_in[54];
	assign		wire_nl010O_dataout = (nl00i1O === 1'b1) ? rbytordpadval[7] : wire_nl0l00O_byte_des_fifo_data_in[55];
	assign		wire_nl011i_dataout = (nl00i1O === 1'b1) ? rbytordpadval[2] : wire_nl0l00O_byte_des_fifo_data_in[50];
	assign		wire_nl011l_dataout = (nl00i1O === 1'b1) ? rbytordpadval[3] : wire_nl0l00O_byte_des_fifo_data_in[51];
	assign		wire_nl011O_dataout = (nl00i1O === 1'b1) ? rbytordpadval[4] : wire_nl0l00O_byte_des_fifo_data_in[52];
	assign		wire_nl01ii_dataout = (nl00i1O === 1'b1) ? rbytordpadval[8] : wire_nl0l00O_byte_des_fifo_data_in[56];
	assign		wire_nl01il_dataout = (nl00i1O === 1'b1) ? rbytordpadval[9] : wire_nl0l00O_byte_des_fifo_data_in[57];
	and(wire_nl01li_dataout, wire_nl0l00O_byte_des_fifo_data_in[59], ~{nl00i1O});
	and(wire_nl01ll_dataout, wire_nl0l00O_byte_des_fifo_data_in[60], ~{nl00i1O});
	and(wire_nl01lO_dataout, wire_nl0l00O_byte_des_fifo_data_in[61], ~{nl00i1O});
	and(wire_nl01Oi_dataout, wire_nl0l00O_byte_des_fifo_data_in[62], ~{nl00i1O});
	and(wire_nl01Ol_dataout, wire_nl0l00O_byte_des_fifo_data_in[63], ~{nl00i1O});
	and(wire_nl01OO_dataout, wire_nl000i_o, ~{nl0i11l});
	assign		wire_nl0i_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l1O_o : nl0Oiil;
	and(wire_nl0i0O_dataout, (nl00O1O & nl00iiO), rdwidth);
	assign		wire_nl0i1O_dataout = (rwa_6g_en === 1'b1) ? wire_nl0i0O_dataout : (nlO0Oi & (nl00ili & nl00O1O));
	and(wire_nl0iil_dataout, wire_nl0iiO_dataout, rwa_6g_en);
	and(wire_nl0iiO_dataout, (nl00O1l & nl00ili), rdwidth);
	assign		wire_nl0ill_dataout = (rwa_6g_en === 1'b1) ? (nl00ilO & nl00ill) : (nlO0Oi & (nl00iOi & nl00ilO));
	and(wire_nl0iOO_dataout, wire_nl0l1i_dataout, rwa_6g_en);
	assign		wire_nl0l_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l0i_o : nl0OiiO;
	assign		wire_nl0l0i_dataout = (rwa_6g_en === 1'b1) ? wire_nl0lii_dataout : (wire_nlOl1l_dataout & (nl00l1i & nl00Oli));
	assign		wire_nl0l1i_dataout = (rdwidth === 1'b1) ? (nl00iOl & nl00iOi) : (nl00l1i & nl00iOl);
	and(wire_nl0lii_dataout, (nl00Oli & nl00iOO), rdwidth);
	and(wire_nl0liO_dataout, wire_nl0lli_dataout, rwa_6g_en);
	and(wire_nl0lli_dataout, (nl00OiO & nl00l1i), rdwidth);
	assign		wire_nl0llO_dataout = (rwa_6g_en === 1'b1) ? (wire_nlOl1l_dataout & (nl00l0O & ((~ rbytordplden) | ((~ nl00l1O) & (~ nl00l1l))))) : (wire_nlOl1l_dataout & (((~ rbytordplden) | ((~ nl00l0l) & (~ nl00l0i))) & nl00l0O));
	assign		wire_nl0O_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l0l_o : nl0Oili;
	and(wire_nl0Oii_dataout, (wire_nlOl1l_dataout & (nl00lii & (nl00lll | nl00lli))), rwa_6g_en);
	assign		wire_nl0Oll_dataout = (rwa_6g_en === 1'b1) ? wire_nli11l_dataout : (wire_nlOl1O_dataout & (nl00lii & nl00llO));
	assign		wire_nl10l_dataout = (tenb_data[18] === 1'b1) ? (nl0ii0l & n10OO) : (nl0ii0l & n1i0i);
	assign		wire_nl1i_dataout = (rrxfifo_dis === 1'b1) ? wire_n10iOO_o : nl0Oi0l;
	assign		wire_nl1ilO_dataout = (nl00i1i === 1'b1) ? rbytordpadval[0] : wire_nl0l00O_byte_des_fifo_data_in[16];
	assign		wire_nl1iOi_dataout = (nl00i1i === 1'b1) ? rbytordpadval[1] : wire_nl0l00O_byte_des_fifo_data_in[17];
	assign		wire_nl1iOl_dataout = (nl00i1i === 1'b1) ? rbytordpadval[2] : wire_nl0l00O_byte_des_fifo_data_in[18];
	assign		wire_nl1iOO_dataout = (nl00i1i === 1'b1) ? rbytordpadval[3] : wire_nl0l00O_byte_des_fifo_data_in[19];
	assign		wire_nl1l_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l1i_o : nl0Oi0O;
	assign		wire_nl1l0i_dataout = (nl00i1i === 1'b1) ? rbytordpadval[7] : wire_nl0l00O_byte_des_fifo_data_in[23];
	assign		wire_nl1l0l_dataout = (nl00i1i === 1'b1) ? rbytordpadval[8] : wire_nl0l00O_byte_des_fifo_data_in[24];
	assign		wire_nl1l0O_dataout = (nl00i1i === 1'b1) ? rbytordpadval[9] : wire_nl0l00O_byte_des_fifo_data_in[25];
	assign		wire_nl1l1i_dataout = (nl00i1i === 1'b1) ? rbytordpadval[4] : wire_nl0l00O_byte_des_fifo_data_in[20];
	assign		wire_nl1l1l_dataout = (nl00i1i === 1'b1) ? rbytordpadval[5] : wire_nl0l00O_byte_des_fifo_data_in[21];
	assign		wire_nl1l1O_dataout = (nl00i1i === 1'b1) ? rbytordpadval[6] : wire_nl0l00O_byte_des_fifo_data_in[22];
	assign		wire_nl1lii_dataout = (nl00i1i === 1'b1) ? wire_nl0l00O_byte_des_fifo_data_in[10] : wire_nl0l00O_byte_des_fifo_data_in[26];
	and(wire_nl1lil_dataout, wire_nl0l00O_byte_des_fifo_data_in[27], ~{nl00i1i});
	and(wire_nl1liO_dataout, wire_nl0l00O_byte_des_fifo_data_in[28], ~{nl00i1i});
	and(wire_nl1lli_dataout, wire_nl0l00O_byte_des_fifo_data_in[29], ~{nl00i1i});
	and(wire_nl1lll_dataout, wire_nl0l00O_byte_des_fifo_data_in[30], ~{nl00i1i});
	and(wire_nl1llO_dataout, wire_nl0l00O_byte_des_fifo_data_in[31], ~{nl00i1i});
	assign		wire_nl1lOi_dataout = (nl000Ol === 1'b1) ? rbytordpadval[0] : wire_nl0l00O_byte_des_fifo_data_in[32];
	assign		wire_nl1lOl_dataout = (nl000Ol === 1'b1) ? rbytordpadval[1] : wire_nl0l00O_byte_des_fifo_data_in[33];
	assign		wire_nl1lOO_dataout = (nl000Ol === 1'b1) ? rbytordpadval[2] : wire_nl0l00O_byte_des_fifo_data_in[34];
	assign		wire_nl1O_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l1l_o : nl0Oiii;
	assign		wire_nl1O0i_dataout = (nl000Ol === 1'b1) ? rbytordpadval[6] : wire_nl0l00O_byte_des_fifo_data_in[38];
	assign		wire_nl1O0l_dataout = (nl000Ol === 1'b1) ? rbytordpadval[7] : wire_nl0l00O_byte_des_fifo_data_in[39];
	assign		wire_nl1O0O_dataout = (nl000Ol === 1'b1) ? rbytordpadval[8] : wire_nl0l00O_byte_des_fifo_data_in[40];
	assign		wire_nl1O1i_dataout = (nl000Ol === 1'b1) ? rbytordpadval[3] : wire_nl0l00O_byte_des_fifo_data_in[35];
	assign		wire_nl1O1l_dataout = (nl000Ol === 1'b1) ? rbytordpadval[4] : wire_nl0l00O_byte_des_fifo_data_in[36];
	assign		wire_nl1O1O_dataout = (nl000Ol === 1'b1) ? rbytordpadval[5] : wire_nl0l00O_byte_des_fifo_data_in[37];
	assign		wire_nl1Oii_dataout = (nl000Ol === 1'b1) ? rbytordpadval[9] : wire_nl0l00O_byte_des_fifo_data_in[41];
	and(wire_nl1OiO_dataout, wire_nl0l00O_byte_des_fifo_data_in[43], ~{nl000Ol});
	and(wire_nl1Oli_dataout, wire_nl0l00O_byte_des_fifo_data_in[44], ~{nl000Ol});
	and(wire_nl1Oll_dataout, wire_nl0l00O_byte_des_fifo_data_in[45], ~{nl000Ol});
	and(wire_nl1OlO_dataout, wire_nl0l00O_byte_des_fifo_data_in[46], ~{nl000Ol});
	and(wire_nl1OOi_dataout, wire_nl0l00O_byte_des_fifo_data_in[47], ~{nl000Ol});
	assign		wire_nl1OOl_dataout = (nl00i1O === 1'b1) ? rbytordpadval[0] : wire_nl0l00O_byte_des_fifo_data_in[48];
	assign		wire_nl1OOO_dataout = (nl00i1O === 1'b1) ? rbytordpadval[1] : wire_nl0l00O_byte_des_fifo_data_in[49];
	assign		wire_nli_dataout = (rinvalid_code_err_only === 1'b1) ? invalid_code_delay[0] : (disp_err_delay[0] | invalid_code_delay[0]);
	and(wire_nli00O_dataout, (wire_nlOl1l_dataout & (nl00O0i & nl00O0O)), rwa_6g_en);
	assign		wire_nli0iO_dataout = (rwa_6g_en === 1'b1) ? wire_nli0Oi_dataout : (wire_nlOl1O_dataout & (nl00Oil & nl00O0i));
	and(wire_nli0Oi_dataout, (wire_nlOl1O_dataout & (nl00Oil & ((~ rbytordplden) | (~ nl00O0O)))), rdwidth);
	or(wire_nli100O_dataout, wire_nli10ii_dataout, nl0001O);
	and(wire_nli10ii_dataout, nl0OlOO, ~{((~ nl0000l) & (nl0OlOO & (~ nl0001O)))});
	or(wire_nli10li_dataout, wire_nli10ll_dataout, nl0000i);
	and(wire_nli10ll_dataout, nl0OO1i, ~{((~ nl0000l) & (nl0OO1i & (~ nl0000i)))});
	assign		wire_nli10Ol_dataout = (nlOlll === 1'b1) ? wire_nli1iii_dataout : nli111i;
	assign		wire_nli10OO_dataout = (nlOlll === 1'b1) ? wire_nli1iil_dataout : nli111l;
	and(wire_nli11l_dataout, (wire_nlOl1O_dataout & (nl00llO & ((~ rbytordplden) | ((~ nl00lll) & (~ nl00lli))))), rdwidth);
	assign		wire_nli1i0i_dataout = (nlOlll === 1'b1) ? wire_nli1ilO_dataout : nl0lliO;
	assign		wire_nli1i0l_dataout = (nlOlll === 1'b1) ? wire_nli1iOi_dataout : nli110O;
	assign		wire_nli1i0O_dataout = (nlOlll === 1'b1) ? wire_nli1iOl_dataout : nli11ii;
	assign		wire_nli1i1i_dataout = (nlOlll === 1'b1) ? wire_nli1iiO_dataout : nli111O;
	assign		wire_nli1i1l_dataout = (nlOlll === 1'b1) ? wire_nli1ili_dataout : nli110i;
	assign		wire_nli1i1O_dataout = (nlOlll === 1'b1) ? wire_nli1ill_dataout : nli110l;
	and(wire_nli1ii_dataout, wire_nli1il_dataout, rwa_6g_en);
	assign		wire_nli1iii_dataout = (nl0000O === 1'b1) ? nli110O : nli11ii;
	assign		wire_nli1iil_dataout = (nl0000O === 1'b1) ? nli11ii : nli111i;
	assign		wire_nli1iiO_dataout = (nl0000O === 1'b1) ? nli111i : nli111l;
	and(wire_nli1il_dataout, (wire_nlOl1O_dataout & (((~ rbytordplden) | ((~ nl00O1i) & (~ nl00lOO))) & (nl00lOl | nl00lOi))), rdwidth);
	assign		wire_nli1ili_dataout = (nl0000O === 1'b1) ? nli111l : nli111O;
	assign		wire_nli1ill_dataout = (nl0000O === 1'b1) ? nli111O : nli110i;
	assign		wire_nli1ilO_dataout = (nl0000O === 1'b1) ? nli110i : nli110l;
	assign		wire_nli1iOi_dataout = (nl0000O === 1'b1) ? nli110l : nl0lliO;
	assign		wire_nli1iOl_dataout = (nl0000O === 1'b1) ? nl0lliO : nli110O;
	assign		wire_nli1liO_dataout = (nlOO0l === 1'b1) ? nl0llOO : nl0llOl;
	assign		wire_nli1lli_dataout = (nlOO0l === 1'b1) ? nl0llOl : nli1l1O;
	assign		wire_nli1lll_dataout = (nlOO0l === 1'b1) ? nli1l1O : nli1l0i;
	assign		wire_nli1llO_dataout = (nlOO0l === 1'b1) ? nli1l0i : nli1l0l;
	assign		wire_nli1lOi_dataout = (nlOO0l === 1'b1) ? nli1l0l : nli1l0O;
	assign		wire_nli1lOl_dataout = (nlOO0l === 1'b1) ? nli1l0O : nli1lii;
	assign		wire_nli1lOO_dataout = (nlOO0l === 1'b1) ? nli1lii : nli1lil;
	assign		wire_nli1O1i_dataout = (nlOO0l === 1'b1) ? nli1lil : nl0llOO;
	assign		wire_nli1Ol_dataout = (rwa_6g_en === 1'b1) ? (wire_nlOl1l_dataout & (nl00O0l & ((~ rbytordplden) | (~ nl00O1l)))) : (wire_nlOl1l_dataout & (nl00O0l & ((~ rbytordplden) | (~ nl00O1O))));
	assign		wire_nlii_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l0O_o : nl0Oill;
	and(wire_nlii1l_dataout, wire_nlii1O_dataout, rwa_6g_en);
	and(wire_nlii1O_dataout, (wire_nlOl1O_dataout & (((~ rbytordplden) | (~ nl00Oil)) & nl00Oii)), rdwidth);
	assign		wire_nliiii_dataout = (rwa_6g_en === 1'b1) ? (wire_nlOl1l_dataout & (nl00OlO & ((~ rbytordplden) | (~ nl00OiO)))) : (wire_nlOl1l_dataout & (nl00OlO & ((~ rbytordplden) | (~ nl00Oli))));
	and(wire_nliiOl_dataout, (wire_nlOl1l_dataout & (nl00Oll & nl00OOi)), rwa_6g_en);
	assign		wire_nlil_dataout = (rrxfifo_dis === 1'b1) ? wire_n10lii_o : nl0OilO;
	and(wire_nlil0O_dataout, (wire_nlOl1O_dataout & (nl00OOO & ((~ rbytordplden) | (~ nl00OOi)))), rdwidth);
	assign		wire_nlil1l_dataout = (rwa_6g_en === 1'b1) ? wire_nlil0O_dataout : (wire_nlOl1O_dataout & (nl00OOO & nl00Oll));
	and(wire_nlilli_dataout, wire_nlilll_dataout, rwa_6g_en);
	and(wire_nlilll_dataout, (wire_nlOl1O_dataout & (((~ rbytordplden) | (~ nl00OOO)) & nl00OOl)), rdwidth);
	assign		wire_nliO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10lil_o : nl0OiOi;
	assign		wire_nll_dataout = (rinvalid_code_err_only === 1'b1) ? invalid_code_delay[1] : ((disp_err_delay[1] | invalid_code_delay[1]) | (~ nl0l1Ol5));
	assign		wire_nll0l_dataout = (tenb_data[8] === 1'b1) ? (nl0l1Oi & n10Ol) : ((nl0l1Oi & n1i1O) & nl0l1ll8);
	assign		wire_nlli_dataout = (rrxfifo_dis === 1'b1) ? wire_n10liO_o : nl0OiOl;
	assign		wire_nlll_dataout = (rrxfifo_dis === 1'b1) ? wire_n10lli_o : nl0OiOO;
	assign		wire_nllO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10lll_o : nl0Ol1i;
	assign		wire_nlOi_dataout = (rrxfifo_dis === 1'b1) ? wire_n10llO_o : nl0Ol1l;
	and(wire_nlOi0l_dataout, wire_nlOi0O_dataout, ~{((~ nlO0OO) & nlOi1i)});
	or(wire_nlOi0O_dataout, nlO0Ol, ((~ nlO0Ol) & nlO0OO));
	and(wire_nlOi1l_dataout, wire_nlOi1O_dataout, ~{nl0i11l});
	or(wire_nlOi1O_dataout, nliO0i, (((wire_nl001O_dataout | wire_nl001l_dataout) | wire_nl001i_dataout) | wire_nl01OO_dataout));
	assign		wire_nlOiiO_dataout = (nl0i11i === 1'b1) ? wire_nl01OO_dataout : wire_nlOiOi_dataout;
	assign		wire_nlOili_dataout = (nl0i11i === 1'b1) ? wire_nl001i_dataout : wire_nlOiOl_dataout;
	assign		wire_nlOill_dataout = (nl0i11i === 1'b1) ? wire_nl001l_dataout : wire_nlOiOO_dataout;
	assign		wire_nlOilO_dataout = (nl0i11i === 1'b1) ? wire_nl001O_dataout : wire_nlOl1i_dataout;
	and(wire_nlOiOi_dataout, nlilOO, ~{nl0i11l});
	and(wire_nlOiOl_dataout, nliO1i, ~{nl0i11l});
	and(wire_nlOiOO_dataout, nliO1l, ~{nl0i11l});
	assign		wire_nlOl_dataout = (rrxfifo_dis === 1'b1) ? wire_n10lOi_o : nl0Ol1O;
	assign		wire_nlOl0i_dataout = (rbytordplden === 1'b1) ? nlO0Ol : wire_nlOl0O_dataout;
	assign		wire_nlOl0l_dataout = (rbytordplden === 1'b1) ? nlO0Ol : wire_nlOlii_dataout;
	assign		wire_nlOl0O_dataout = (rwa_6g_en === 1'b1) ? (wire_nl0l00O_byte_des_fifo_data_in[10] | wire_nl0l00O_byte_des_fifo_data_in[26]) : wire_nl0l00O_byte_des_bo_3g_start[0];
	and(wire_nlOl1i_dataout, nliO1O, ~{nl0i11l});
	and(wire_nlOl1l_dataout, wire_nlOl0i_dataout, ~{nl0i11O});
	and(wire_nlOl1O_dataout, wire_nlOl0l_dataout, ~{nl0i11O});
	assign		wire_nlOlii_dataout = (rwa_6g_en === 1'b1) ? (wire_nl0l00O_byte_des_fifo_data_in[42] | wire_nl0l00O_byte_des_fifo_data_in[58]) : wire_nl0l00O_byte_des_bo_3g_start[1];
	assign		wire_nlOlO_dataout = (rrxfifo_dis === 1'b1) ? wire_n1011O_dataout : nl0OlOl;
	assign		wire_nlOlOl_dataout = (rphfifo_master_sel_rx === 1'b1) ? wire_nlOlOO_dataout : rd_enable_q0_ch0;
	assign		wire_nlOlOO_dataout = (indv_rx === 1'b1) ? nlOllO : rd_enable_ch0;
	assign		wire_nlOO_dataout = (rrxfifo_dis === 1'b1) ? wire_n10lOl_o : nl0Ol0i;
	assign		wire_nlOO1i_dataout = (rrxphfifopldctl_en === 1'b1) ? (nlOlOi & pld_re) : nlOlOi;
	assign		wire_nlOOi_dataout = (rrxfifo_dis === 1'b1) ? wire_n10l1i_o : nl0Oi0O;
	assign		wire_nlOOl_dataout = (rrxfifo_dis === 1'b1) ? wire_n10O1l_o : nl0Olii;
	assign		wire_nlOOlO_dataout = (rphfifo_master_sel_rx === 1'b1) ? wire_nlOOOi_dataout : wr_enable_q0_ch0;
	assign		wire_nlOOO_dataout = (rrxfifo_dis === 1'b1) ? wire_n101Ol_o : nl0O10i;
	assign		wire_nlOOOi_dataout = (indv_rx === 1'b1) ? nlOO0O : wr_enable_ch0;
	assign		wire_nlOOOl_dataout = (rrxphfifopldctl_en === 1'b1) ? (nlOOii & (~ nlOOiO)) : nlOOii;
	oper_decoder   n0l0lO
	( 
	.i({nliO1i, nlilOO}),
	.o(wire_n0l0lO_o));
	defparam
		n0l0lO.width_i = 2,
		n0l0lO.width_o = 4;
	oper_decoder   n0O11i
	( 
	.i({wire_nl001i_dataout, wire_nl01OO_dataout}),
	.o(wire_n0O11i_o));
	defparam
		n0O11i.width_i = 2,
		n0O11i.width_o = 4;
	oper_decoder   n10Oli
	( 
	.i({rwa_6g_en, rdwidth, rbytord_2sym_en}),
	.o(wire_n10Oli_o));
	defparam
		n10Oli.width_i = 3,
		n10Oli.width_o = 8;
	oper_decoder   nil1iO
	( 
	.i({nliO1O, nliO1l, nliO1i, nlilOO}),
	.o(wire_nil1iO_o));
	defparam
		nil1iO.width_i = 4,
		nil1iO.width_o = 16;
	oper_decoder   nilO1O
	( 
	.i({wire_nl001O_dataout, wire_nl001l_dataout, wire_nl001i_dataout, wire_nl01OO_dataout}),
	.o(wire_nilO1O_o));
	defparam
		nilO1O.width_i = 4,
		nilO1O.width_o = 16;
	oper_decoder   nl00iO
	( 
	.i({rbytord_2sym_en, rbytorden[1:0]}),
	.o(wire_nl00iO_o));
	defparam
		nl00iO.width_i = 3,
		nl00iO.width_o = 8;
	oper_decoder   nl0lO0l
	( 
	.i({nli11ii, nli110O, nl0lliO, nli110l, nli110i, nli111O, nli111l, nli111i}),
	.o(wire_nl0lO0l_o));
	defparam
		nl0lO0l.width_i = 8,
		nl0lO0l.width_o = 256;
	oper_decoder   nl0lOiO
	( 
	.i({nl0llOO, nli1lil, nli1lii, nli1l0O, nli1l0l, nli1l0i, nli1l1O, nl0llOl}),
	.o(wire_nl0lOiO_o));
	defparam
		nl0lOiO.width_i = 8,
		nl0lOiO.width_o = 256;
	oper_decoder   nl10i
	( 
	.i({rwa_6g_en, rpmadatawidth, rsync_comp_size[2:0], tenb_data[18]}),
	.o(wire_nl10i_o));
	defparam
		nl10i.width_i = 6,
		nl10i.width_o = 64;
	oper_decoder   nll0i
	( 
	.i({(nl0l1il17 & rwa_6g_en), rpmadatawidth, (nl0l1iO14 & rsync_comp_size[2]), (nl0l1li11 & rsync_comp_size[1]), rsync_comp_size[0], tenb_data[8]}),
	.o(wire_nll0i_o));
	defparam
		nll0i.width_i = 6,
		nll0i.width_o = 64;
	oper_selector   n1000i
	( 
	.data({wire_ni0ilO_dataout, wire_niO11O_dataout, wire_n00O1O_dataout, wire_n0O01i_dataout, wire_n1i1li_dataout, wire_n1Oiii_dataout, wire_nl0l00O_byte_des_fifo_data_in[14]}),
	.o(wire_n1000i_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n1000i.width_data = 7,
		n1000i.width_sel = 7;
	oper_selector   n1000l
	( 
	.data({wire_ni0iOi_dataout, wire_niO10i_dataout, wire_n00O0i_dataout, wire_n0O01l_dataout, wire_n1i1ll_dataout, wire_n1Oiil_dataout, wire_nl0l00O_byte_des_fifo_data_in[15]}),
	.o(wire_n1000l_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n1000l.width_data = 7,
		n1000l.width_sel = 7;
	oper_selector   n1000O
	( 
	.data({wire_ni0iOl_dataout, wire_niO10l_dataout, wire_n00O0l_dataout, wire_n0O01O_dataout, wire_n1i1lO_dataout, wire_n1OiiO_dataout, wire_nl0l00O_byte_des_fifo_data_in[16]}),
	.o(wire_n1000O_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n1000O.width_data = 7,
		n1000O.width_sel = 7;
	oper_selector   n1001i
	( 
	.data({wire_ni0iiO_dataout, wire_nilOOO_dataout, wire_n00lOO_dataout, wire_n0O1Oi_dataout, wire_n1i1ii_dataout, wire_n1Oi0i_dataout, wire_nl0l00O_byte_des_fifo_data_in[11]}),
	.o(wire_n1001i_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n1001i.width_data = 7,
		n1001i.width_sel = 7;
	oper_selector   n1001l
	( 
	.data({wire_ni0ili_dataout, wire_niO11i_dataout, wire_n00O1i_dataout, wire_n0O1Ol_dataout, wire_n1i1il_dataout, wire_n1Oi0l_dataout, wire_nl0l00O_byte_des_fifo_data_in[12]}),
	.o(wire_n1001l_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n1001l.width_data = 7,
		n1001l.width_sel = 7;
	oper_selector   n1001O
	( 
	.data({wire_ni0ill_dataout, wire_niO11l_dataout, wire_n00O1l_dataout, wire_n0O1OO_dataout, wire_n1i1iO_dataout, wire_n1Oi0O_dataout, wire_nl0l00O_byte_des_fifo_data_in[13]}),
	.o(wire_n1001O_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n1001O.width_data = 7,
		n1001O.width_sel = 7;
	oper_selector   n100ii
	( 
	.data({wire_ni0iOO_dataout, wire_niO10O_dataout, wire_n00O0O_dataout, wire_n0O00i_dataout, wire_n1i1Oi_dataout, wire_n1Oili_dataout, wire_nl0l00O_byte_des_fifo_data_in[17]}),
	.o(wire_n100ii_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n100ii.width_data = 7,
		n100ii.width_sel = 7;
	oper_selector   n100il
	( 
	.data({wire_ni0l1i_dataout, wire_niO1ii_dataout, wire_n00Oii_dataout, wire_n0O00l_dataout, wire_n1i1Ol_dataout, wire_n1Oill_dataout, wire_nl0l00O_byte_des_fifo_data_in[18]}),
	.o(wire_n100il_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n100il.width_data = 7,
		n100il.width_sel = 7;
	oper_selector   n100iO
	( 
	.data({wire_ni0l1l_dataout, wire_niO1il_dataout, wire_n00Oil_dataout, wire_n0O00O_dataout, wire_n1i1OO_dataout, wire_n1OilO_dataout, wire_nl0l00O_byte_des_fifo_data_in[19]}),
	.o(wire_n100iO_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n100iO.width_data = 7,
		n100iO.width_sel = 7;
	oper_selector   n100li
	( 
	.data({wire_ni0l1O_dataout, wire_niO1iO_dataout, wire_n00OiO_dataout, wire_n0O0ii_dataout, wire_n1i01i_dataout, wire_n1OiOi_dataout, wire_nl0l00O_byte_des_fifo_data_in[20]}),
	.o(wire_n100li_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n100li.width_data = 7,
		n100li.width_sel = 7;
	oper_selector   n100ll
	( 
	.data({wire_ni0l0i_dataout, wire_niO1li_dataout, wire_n00Oli_dataout, wire_n0O0il_dataout, wire_n1i01l_dataout, wire_n1OiOl_dataout, wire_nl0l00O_byte_des_fifo_data_in[21]}),
	.o(wire_n100ll_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n100ll.width_data = 7,
		n100ll.width_sel = 7;
	oper_selector   n100lO
	( 
	.data({wire_ni0l0l_dataout, wire_niO1ll_dataout, wire_n00Oll_dataout, wire_n0O0iO_dataout, wire_n1i01O_dataout, wire_n1OiOO_dataout, wire_nl0l00O_byte_des_fifo_data_in[22]}),
	.o(wire_n100lO_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n100lO.width_data = 7,
		n100lO.width_sel = 7;
	oper_selector   n100Oi
	( 
	.data({wire_ni0l0O_dataout, wire_niO1lO_dataout, wire_n00OlO_dataout, wire_n0O0li_dataout, wire_n1i00i_dataout, wire_n1Ol1i_dataout, wire_nl0l00O_byte_des_fifo_data_in[23]}),
	.o(wire_n100Oi_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n100Oi.width_data = 7,
		n100Oi.width_sel = 7;
	oper_selector   n100Ol
	( 
	.data({wire_ni0lii_dataout, wire_niO1Oi_dataout, wire_n00OOi_dataout, wire_n0O0ll_dataout, wire_n1i00l_dataout, wire_n1Ol1l_dataout, wire_nl0l00O_byte_des_fifo_data_in[24]}),
	.o(wire_n100Ol_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n100Ol.width_data = 7,
		n100Ol.width_sel = 7;
	oper_selector   n100OO
	( 
	.data({wire_ni0lil_dataout, wire_niO1Ol_dataout, wire_n00OOl_dataout, wire_n0O0lO_dataout, wire_n1i00O_dataout, wire_n1Ol1O_dataout, wire_nl0l00O_byte_des_fifo_data_in[25]}),
	.o(wire_n100OO_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n100OO.width_data = 7,
		n100OO.width_sel = 7;
	oper_selector   n1010l
	( 
	.data({wire_ni00Oi_dataout, wire_nilO0i_dataout, wire_n00l0i_dataout, wire_n0O11l_dataout, wire_n10Oll_dataout, wire_n1O0il_dataout, wire_nl0l00O_byte_des_fifo_data_in[0]}),
	.o(wire_n1010l_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n1010l.width_data = 7,
		n1010l.width_sel = 7;
	oper_selector   n1010O
	( 
	.data({wire_ni00Ol_dataout, wire_nilO0l_dataout, wire_n00l0l_dataout, wire_n0O11O_dataout, wire_n10OlO_dataout, wire_n1O0iO_dataout, wire_nl0l00O_byte_des_fifo_data_in[1]}),
	.o(wire_n1010O_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n1010O.width_data = 7,
		n1010O.width_sel = 7;
	oper_selector   n101ii
	( 
	.data({wire_ni00OO_dataout, wire_nilO0O_dataout, wire_n00l0O_dataout, wire_n0O10i_dataout, wire_n10OOi_dataout, wire_n1O0li_dataout, wire_nl0l00O_byte_des_fifo_data_in[2]}),
	.o(wire_n101ii_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n101ii.width_data = 7,
		n101ii.width_sel = 7;
	oper_selector   n101il
	( 
	.data({wire_ni0i1i_dataout, wire_nilOii_dataout, wire_n00lii_dataout, wire_n0O10l_dataout, wire_n10OOl_dataout, wire_n1O0ll_dataout, wire_nl0l00O_byte_des_fifo_data_in[3]}),
	.o(wire_n101il_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n101il.width_data = 7,
		n101il.width_sel = 7;
	oper_selector   n101iO
	( 
	.data({wire_ni0i1l_dataout, wire_nilOil_dataout, wire_n00lil_dataout, wire_n0O10O_dataout, wire_n10OOO_dataout, wire_n1O0lO_dataout, wire_nl0l00O_byte_des_fifo_data_in[4]}),
	.o(wire_n101iO_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n101iO.width_data = 7,
		n101iO.width_sel = 7;
	oper_selector   n101li
	( 
	.data({wire_ni0i1O_dataout, wire_nilOiO_dataout, wire_n00liO_dataout, wire_n0O1ii_dataout, wire_n1i11i_dataout, wire_n1O0Oi_dataout, wire_nl0l00O_byte_des_fifo_data_in[5]}),
	.o(wire_n101li_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n101li.width_data = 7,
		n101li.width_sel = 7;
	oper_selector   n101ll
	( 
	.data({wire_ni0i0i_dataout, wire_nilOli_dataout, wire_n00lli_dataout, wire_n0O1il_dataout, wire_n1i11l_dataout, wire_n1O0Ol_dataout, wire_nl0l00O_byte_des_fifo_data_in[6]}),
	.o(wire_n101ll_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n101ll.width_data = 7,
		n101ll.width_sel = 7;
	oper_selector   n101lO
	( 
	.data({wire_ni0i0l_dataout, wire_nilOll_dataout, wire_n00lll_dataout, wire_n0O1iO_dataout, wire_n1i11O_dataout, wire_n1O0OO_dataout, wire_nl0l00O_byte_des_fifo_data_in[7]}),
	.o(wire_n101lO_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n101lO.width_data = 7,
		n101lO.width_sel = 7;
	oper_selector   n101Oi
	( 
	.data({wire_ni0i0O_dataout, wire_nilOlO_dataout, wire_n00llO_dataout, wire_n0O1li_dataout, wire_n1i10i_dataout, wire_n1Oi1i_dataout, wire_nl0l00O_byte_des_fifo_data_in[8]}),
	.o(wire_n101Oi_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n101Oi.width_data = 7,
		n101Oi.width_sel = 7;
	oper_selector   n101Ol
	( 
	.data({wire_ni0iii_dataout, wire_nilOOi_dataout, wire_n00lOi_dataout, wire_n0O1ll_dataout, wire_n1i10l_dataout, wire_n1Oi1l_dataout, wire_nl0l00O_byte_des_fifo_data_in[9]}),
	.o(wire_n101Ol_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n101Ol.width_data = 7,
		n101Ol.width_sel = 7;
	oper_selector   n101OO
	( 
	.data({wire_ni0iil_dataout, wire_nilOOl_dataout, wire_n00lOl_dataout, wire_n0O1lO_dataout, wire_n1i10O_dataout, wire_n1Oi1O_dataout, wire_nl0l00O_byte_des_fifo_data_in[10]}),
	.o(wire_n101OO_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n101OO.width_data = 7,
		n101OO.width_sel = 7;
	oper_selector   n10i0i
	( 
	.data({wire_ni0llO_dataout, wire_niO01O_dataout, wire_n0i11O_dataout, wire_n0Oi1i_dataout, wire_n1i0li_dataout, wire_n1Olii_dataout, wire_nl0l00O_byte_des_fifo_data_in[29]}),
	.o(wire_n10i0i_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10i0i.width_data = 7,
		n10i0i.width_sel = 7;
	oper_selector   n10i0l
	( 
	.data({wire_ni0lOi_dataout, wire_niO00i_dataout, wire_n0i10i_dataout, wire_n0Oi1l_dataout, wire_n1i0ll_dataout, wire_n1Olil_dataout, wire_nl0l00O_byte_des_fifo_data_in[30]}),
	.o(wire_n10i0l_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10i0l.width_data = 7,
		n10i0l.width_sel = 7;
	oper_selector   n10i0O
	( 
	.data({wire_ni0lOl_dataout, wire_niO00l_dataout, wire_n0i10l_dataout, wire_n0Oi1O_dataout, wire_n1i0lO_dataout, wire_n1OliO_dataout, wire_nl0l00O_byte_des_fifo_data_in[31]}),
	.o(wire_n10i0O_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10i0O.width_data = 7,
		n10i0O.width_sel = 7;
	oper_selector   n10i1i
	( 
	.data({wire_ni0liO_dataout, wire_niO1OO_dataout, wire_n00OOO_dataout, wire_n0O0Oi_dataout, wire_n1i0ii_dataout, wire_n1Ol0i_dataout, wire_nl0l00O_byte_des_fifo_data_in[26]}),
	.o(wire_n10i1i_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10i1i.width_data = 7,
		n10i1i.width_sel = 7;
	oper_selector   n10i1l
	( 
	.data({wire_ni0lli_dataout, wire_niO01i_dataout, wire_n0i11i_dataout, wire_n0O0Ol_dataout, wire_n1i0il_dataout, wire_n1Ol0l_dataout, wire_nl0l00O_byte_des_fifo_data_in[27]}),
	.o(wire_n10i1l_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10i1l.width_data = 7,
		n10i1l.width_sel = 7;
	oper_selector   n10i1O
	( 
	.data({wire_ni0lll_dataout, wire_niO01l_dataout, wire_n0i11l_dataout, wire_n0O0OO_dataout, wire_n1i0iO_dataout, wire_n1Ol0O_dataout, wire_nl0l00O_byte_des_fifo_data_in[28]}),
	.o(wire_n10i1O_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10i1O.width_data = 7,
		n10i1O.width_sel = 7;
	oper_selector   n10iii
	( 
	.data({wire_ni0lOO_dataout, wire_niO00O_dataout, wire_n0i10O_dataout, wire_n0Oi0i_dataout, wire_n1i0Oi_dataout, wire_n1Olli_dataout, wire_nl0l00O_byte_des_fifo_data_in[32]}),
	.o(wire_n10iii_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10iii.width_data = 7,
		n10iii.width_sel = 7;
	oper_selector   n10iil
	( 
	.data({wire_ni0O1i_dataout, wire_niO0ii_dataout, wire_n0i1ii_dataout, wire_n0Oi0l_dataout, wire_n1i0Ol_dataout, wire_n1Olll_dataout, wire_nl0l00O_byte_des_fifo_data_in[33]}),
	.o(wire_n10iil_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10iil.width_data = 7,
		n10iil.width_sel = 7;
	oper_selector   n10iiO
	( 
	.data({wire_ni0O1l_dataout, wire_niO0il_dataout, wire_n0i1il_dataout, wire_n0Oi0O_dataout, wire_n1i0OO_dataout, wire_n1OllO_dataout, wire_nl0l00O_byte_des_fifo_data_in[34]}),
	.o(wire_n10iiO_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10iiO.width_data = 7,
		n10iiO.width_sel = 7;
	oper_selector   n10ili
	( 
	.data({wire_ni0O1O_dataout, wire_niO0iO_dataout, wire_n0i1iO_dataout, wire_n0Oiii_dataout, wire_n1ii1i_dataout, wire_n1OlOi_dataout, wire_nl0l00O_byte_des_fifo_data_in[35]}),
	.o(wire_n10ili_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10ili.width_data = 7,
		n10ili.width_sel = 7;
	oper_selector   n10ill
	( 
	.data({wire_ni0O0i_dataout, wire_niO0li_dataout, wire_n0i1li_dataout, wire_n0Oiil_dataout, wire_n1ii1l_dataout, wire_n1OlOl_dataout, wire_nl0l00O_byte_des_fifo_data_in[36]}),
	.o(wire_n10ill_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10ill.width_data = 7,
		n10ill.width_sel = 7;
	oper_selector   n10ilO
	( 
	.data({wire_ni0O0l_dataout, wire_niO0ll_dataout, wire_n0i1ll_dataout, wire_n0OiiO_dataout, wire_n1ii1O_dataout, wire_n1OlOO_dataout, wire_nl0l00O_byte_des_fifo_data_in[37]}),
	.o(wire_n10ilO_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10ilO.width_data = 7,
		n10ilO.width_sel = 7;
	oper_selector   n10iOi
	( 
	.data({wire_ni0O0O_dataout, wire_niO0lO_dataout, wire_n0i1lO_dataout, wire_n0Oili_dataout, wire_n1ii0i_dataout, wire_n1OO1i_dataout, wire_nl0l00O_byte_des_fifo_data_in[38]}),
	.o(wire_n10iOi_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10iOi.width_data = 7,
		n10iOi.width_sel = 7;
	oper_selector   n10iOl
	( 
	.data({wire_ni0Oii_dataout, wire_niO0Oi_dataout, wire_n0i1Oi_dataout, wire_n0Oill_dataout, wire_n1ii0l_dataout, wire_n1OO1l_dataout, wire_nl0l00O_byte_des_fifo_data_in[39]}),
	.o(wire_n10iOl_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10iOl.width_data = 7,
		n10iOl.width_sel = 7;
	oper_selector   n10iOO
	( 
	.data({wire_ni0Oil_dataout, wire_niO0Ol_dataout, wire_n0i1Ol_dataout, wire_n0OilO_dataout, wire_n1ii0O_dataout, wire_n1OO1O_dataout, wire_nl0l00O_byte_des_fifo_data_in[40]}),
	.o(wire_n10iOO_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10iOO.width_data = 7,
		n10iOO.width_sel = 7;
	oper_selector   n10l0i
	( 
	.data({wire_ni0OlO_dataout, wire_niOi1O_dataout, wire_n0i01O_dataout, wire_n0Ol1i_dataout, wire_n1iili_dataout, wire_n1OOii_dataout, wire_nl0l00O_byte_des_fifo_data_in[44]}),
	.o(wire_n10l0i_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10l0i.width_data = 7,
		n10l0i.width_sel = 7;
	oper_selector   n10l0l
	( 
	.data({wire_ni0OOi_dataout, wire_niOi0i_dataout, wire_n0i00i_dataout, wire_n0Ol1l_dataout, wire_n1iill_dataout, wire_n1OOil_dataout, wire_nl0l00O_byte_des_fifo_data_in[45]}),
	.o(wire_n10l0l_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10l0l.width_data = 7,
		n10l0l.width_sel = 7;
	oper_selector   n10l0O
	( 
	.data({wire_ni0OOl_dataout, wire_niOi0l_dataout, wire_n0i00l_dataout, wire_n0Ol1O_dataout, wire_n1iilO_dataout, wire_n1OOiO_dataout, wire_nl0l00O_byte_des_fifo_data_in[46]}),
	.o(wire_n10l0O_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10l0O.width_data = 7,
		n10l0O.width_sel = 7;
	oper_selector   n10l1i
	( 
	.data({wire_ni0OiO_dataout, wire_niO0OO_dataout, wire_n0i1OO_dataout, wire_n0OiOi_dataout, wire_n1iiii_dataout, wire_n1OO0i_dataout, wire_nl0l00O_byte_des_fifo_data_in[41]}),
	.o(wire_n10l1i_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10l1i.width_data = 7,
		n10l1i.width_sel = 7;
	oper_selector   n10l1l
	( 
	.data({wire_ni0Oli_dataout, wire_niOi1i_dataout, wire_n0i01i_dataout, wire_n0OiOl_dataout, wire_n1iiil_dataout, wire_n1OO0l_dataout, wire_nl0l00O_byte_des_fifo_data_in[42]}),
	.o(wire_n10l1l_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10l1l.width_data = 7,
		n10l1l.width_sel = 7;
	oper_selector   n10l1O
	( 
	.data({wire_ni0Oll_dataout, wire_niOi1l_dataout, wire_n0i01l_dataout, wire_n0OiOO_dataout, wire_n1iiiO_dataout, wire_n1OO0O_dataout, wire_nl0l00O_byte_des_fifo_data_in[43]}),
	.o(wire_n10l1O_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10l1O.width_data = 7,
		n10l1O.width_sel = 7;
	oper_selector   n10lii
	( 
	.data({wire_ni0OOO_dataout, wire_niOi0O_dataout, wire_n0i00O_dataout, wire_n0Ol0i_dataout, wire_n1iiOi_dataout, wire_n1OOli_dataout, wire_nl0l00O_byte_des_fifo_data_in[47]}),
	.o(wire_n10lii_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10lii.width_data = 7,
		n10lii.width_sel = 7;
	oper_selector   n10lil
	( 
	.data({wire_nii11i_dataout, wire_niOiii_dataout, wire_n0i0ii_dataout, wire_n0Ol0l_dataout, wire_n1iiOl_dataout, wire_n1OOll_dataout, wire_nl0l00O_byte_des_fifo_data_in[48]}),
	.o(wire_n10lil_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10lil.width_data = 7,
		n10lil.width_sel = 7;
	oper_selector   n10liO
	( 
	.data({wire_nii11l_dataout, wire_niOiil_dataout, wire_n0i0il_dataout, wire_n0Ol0O_dataout, wire_n1iiOO_dataout, wire_n1OOlO_dataout, wire_nl0l00O_byte_des_fifo_data_in[49]}),
	.o(wire_n10liO_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10liO.width_data = 7,
		n10liO.width_sel = 7;
	oper_selector   n10lli
	( 
	.data({wire_nii11O_dataout, wire_niOiiO_dataout, wire_n0i0iO_dataout, wire_n0Olii_dataout, wire_n1il1i_dataout, wire_n1OOOi_dataout, wire_nl0l00O_byte_des_fifo_data_in[50]}),
	.o(wire_n10lli_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10lli.width_data = 7,
		n10lli.width_sel = 7;
	oper_selector   n10lll
	( 
	.data({wire_nii10i_dataout, wire_niOili_dataout, wire_n0i0li_dataout, wire_n0Olil_dataout, wire_n1il1l_dataout, wire_n1OOOl_dataout, wire_nl0l00O_byte_des_fifo_data_in[51]}),
	.o(wire_n10lll_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10lll.width_data = 7,
		n10lll.width_sel = 7;
	oper_selector   n10llO
	( 
	.data({wire_nii10l_dataout, wire_niOill_dataout, wire_n0i0ll_dataout, wire_n0OliO_dataout, wire_n1il1O_dataout, wire_n1OOOO_dataout, wire_nl0l00O_byte_des_fifo_data_in[52]}),
	.o(wire_n10llO_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10llO.width_data = 7,
		n10llO.width_sel = 7;
	oper_selector   n10lOi
	( 
	.data({wire_nii10O_dataout, wire_niOilO_dataout, wire_n0i0lO_dataout, wire_n0Olli_dataout, wire_n1il0i_dataout, wire_n0111i_dataout, wire_nl0l00O_byte_des_fifo_data_in[53]}),
	.o(wire_n10lOi_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10lOi.width_data = 7,
		n10lOi.width_sel = 7;
	oper_selector   n10lOl
	( 
	.data({wire_nii1ii_dataout, wire_niOiOi_dataout, wire_n0i0Oi_dataout, wire_n0Olll_dataout, wire_n1il0l_dataout, wire_n0111l_dataout, wire_nl0l00O_byte_des_fifo_data_in[54]}),
	.o(wire_n10lOl_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10lOl.width_data = 7,
		n10lOl.width_sel = 7;
	oper_selector   n10lOO
	( 
	.data({wire_nii1il_dataout, wire_niOiOl_dataout, wire_n0i0Ol_dataout, wire_n0OllO_dataout, wire_n1il0O_dataout, wire_n0111O_dataout, wire_nl0l00O_byte_des_fifo_data_in[55]}),
	.o(wire_n10lOO_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10lOO.width_data = 7,
		n10lOO.width_sel = 7;
	oper_selector   n10O0i
	( 
	.data({wire_nii1lO_dataout, wire_niOl1O_dataout, wire_n0ii1O_dataout, wire_n0OO1i_dataout, wire_n1illi_dataout, wire_n011ii_dataout, wire_nl0l00O_byte_des_fifo_data_in[59]}),
	.o(wire_n10O0i_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10O0i.width_data = 7,
		n10O0i.width_sel = 7;
	oper_selector   n10O0l
	( 
	.data({wire_nii1Oi_dataout, wire_niOl0i_dataout, wire_n0ii0i_dataout, wire_n0OO1l_dataout, wire_n1illl_dataout, wire_n011il_dataout, wire_nl0l00O_byte_des_fifo_data_in[60]}),
	.o(wire_n10O0l_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10O0l.width_data = 7,
		n10O0l.width_sel = 7;
	oper_selector   n10O0O
	( 
	.data({wire_nii1Ol_dataout, wire_niOl0l_dataout, wire_n0ii0l_dataout, wire_n0OO1O_dataout, wire_n1illO_dataout, wire_n011iO_dataout, wire_nl0l00O_byte_des_fifo_data_in[61]}),
	.o(wire_n10O0O_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10O0O.width_data = 7,
		n10O0O.width_sel = 7;
	oper_selector   n10O1i
	( 
	.data({wire_nii1iO_dataout, wire_niOiOO_dataout, wire_n0i0OO_dataout, wire_n0OlOi_dataout, wire_n1ilii_dataout, wire_n0110i_dataout, wire_nl0l00O_byte_des_fifo_data_in[56]}),
	.o(wire_n10O1i_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10O1i.width_data = 7,
		n10O1i.width_sel = 7;
	oper_selector   n10O1l
	( 
	.data({wire_nii1li_dataout, wire_niOl1i_dataout, wire_n0ii1i_dataout, wire_n0OlOl_dataout, wire_n1ilil_dataout, wire_n0110l_dataout, wire_nl0l00O_byte_des_fifo_data_in[57]}),
	.o(wire_n10O1l_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10O1l.width_data = 7,
		n10O1l.width_sel = 7;
	oper_selector   n10O1O
	( 
	.data({wire_nii1ll_dataout, wire_niOl1l_dataout, wire_n0ii1l_dataout, wire_n0OlOO_dataout, wire_n1iliO_dataout, wire_n0110O_dataout, wire_nl0l00O_byte_des_fifo_data_in[58]}),
	.o(wire_n10O1O_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10O1O.width_data = 7,
		n10O1O.width_sel = 7;
	oper_selector   n10Oii
	( 
	.data({wire_nii1OO_dataout, wire_niOl0O_dataout, wire_n0ii0O_dataout, wire_n0OO0i_dataout, wire_n1ilOi_dataout, wire_n011li_dataout, wire_nl0l00O_byte_des_fifo_data_in[62]}),
	.o(wire_n10Oii_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10Oii.width_data = 7,
		n10Oii.width_sel = 7;
	oper_selector   n10Oil
	( 
	.data({wire_nii01i_dataout, wire_niOlii_dataout, wire_n0iiii_dataout, wire_n0OO0l_dataout, wire_n1ilOl_dataout, wire_n011ll_dataout, wire_nl0l00O_byte_des_fifo_data_in[63]}),
	.o(wire_n10Oil_o),
	.sel({wire_n10Oli_o[7:2], nl000il}));
	defparam
		n10Oil.width_data = 7,
		n10Oil.width_sel = 7;
	oper_selector   nii00i
	( 
	.data({nllili, nliOii, nll1il, nll0iO}),
	.o(wire_nii00i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nii00i.width_data = 4,
		nii00i.width_sel = 4;
	oper_selector   nii00l
	( 
	.data({nllill, nliOil, nll1iO, nll0li}),
	.o(wire_nii00l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nii00l.width_data = 4,
		nii00l.width_sel = 4;
	oper_selector   nii00O
	( 
	.data({nllilO, nliOiO, nll1li, nll0ll}),
	.o(wire_nii00O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nii00O.width_data = 4,
		nii00O.width_sel = 4;
	oper_selector   nii01l
	( 
	.data({nlliil, nliO0l, nll10O, nll0ii}),
	.o(wire_nii01l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nii01l.width_data = 4,
		nii01l.width_sel = 4;
	oper_selector   nii01O
	( 
	.data({nlliiO, nliO0O, nll1ii, nll0il}),
	.o(wire_nii01O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nii01O.width_data = 4,
		nii01O.width_sel = 4;
	oper_selector   nii0ii
	( 
	.data({nlliOi, nliOli, nll1ll, nll0lO}),
	.o(wire_nii0ii_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nii0ii.width_data = 4,
		nii0ii.width_sel = 4;
	oper_selector   nii0il
	( 
	.data({nlliOl, nliOll, nll1lO, nll0Oi}),
	.o(wire_nii0il_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nii0il.width_data = 4,
		nii0il.width_sel = 4;
	oper_selector   nii0iO
	( 
	.data({nlliOO, nliOlO, nll1Oi, nll0Ol}),
	.o(wire_nii0iO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nii0iO.width_data = 4,
		nii0iO.width_sel = 4;
	oper_selector   nii0li
	( 
	.data({nlll1i, nliOOi, nll1Ol, nll0OO}),
	.o(wire_nii0li_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nii0li.width_data = 4,
		nii0li.width_sel = 4;
	oper_selector   nii0ll
	( 
	.data({nlll1l, nliOOl, nll1OO, nlli1i}),
	.o(wire_nii0ll_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nii0ll.width_data = 4,
		nii0ll.width_sel = 4;
	oper_selector   nii0lO
	( 
	.data({nlll1O, nliOOO, nll01i, nlli1l}),
	.o(wire_nii0lO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nii0lO.width_data = 4,
		nii0lO.width_sel = 4;
	oper_selector   nii0Oi
	( 
	.data({nlll0i, nll11i, nll01l, nlli1O}),
	.o(wire_nii0Oi_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nii0Oi.width_data = 4,
		nii0Oi.width_sel = 4;
	oper_selector   nii0Ol
	( 
	.data({nlll0l, nll11l, nll01O, nlli0i}),
	.o(wire_nii0Ol_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nii0Ol.width_data = 4,
		nii0Ol.width_sel = 4;
	oper_selector   nii0OO
	( 
	.data({nlll0O, nll11O, nll00i, nlli0l}),
	.o(wire_nii0OO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nii0OO.width_data = 4,
		nii0OO.width_sel = 4;
	oper_selector   niii0i
	( 
	.data({nlllli, nll1ii, nll0il, nlliiO}),
	.o(wire_niii0i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niii0i.width_data = 4,
		niii0i.width_sel = 4;
	oper_selector   niii0l
	( 
	.data({nlllll, nll1il, nll0iO, nllili}),
	.o(wire_niii0l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niii0l.width_data = 4,
		niii0l.width_sel = 4;
	oper_selector   niii0O
	( 
	.data({nllllO, nll1iO, nll0li, nllill}),
	.o(wire_niii0O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niii0O.width_data = 4,
		niii0O.width_sel = 4;
	oper_selector   niii1i
	( 
	.data({nlllii, nll10i, nll00l, nlli0O}),
	.o(wire_niii1i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niii1i.width_data = 4,
		niii1i.width_sel = 4;
	oper_selector   niii1l
	( 
	.data({nlllil, nll10l, nll00O, nlliii}),
	.o(wire_niii1l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niii1l.width_data = 4,
		niii1l.width_sel = 4;
	oper_selector   niii1O
	( 
	.data({nllliO, nll10O, nll0ii, nlliil}),
	.o(wire_niii1O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niii1O.width_data = 4,
		niii1O.width_sel = 4;
	oper_selector   niiiii
	( 
	.data({nlllOi, nll1li, nll0ll, nllilO}),
	.o(wire_niiiii_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiiii.width_data = 4,
		niiiii.width_sel = 4;
	oper_selector   niiiil
	( 
	.data({nlllOl, nll1ll, nll0lO, nlliOi}),
	.o(wire_niiiil_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiiil.width_data = 4,
		niiiil.width_sel = 4;
	oper_selector   niiiiO
	( 
	.data({nlllOO, nll1lO, nll0Oi, nlliOl}),
	.o(wire_niiiiO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiiiO.width_data = 4,
		niiiiO.width_sel = 4;
	oper_selector   niiili
	( 
	.data({nllO1i, nll1Oi, nll0Ol, nlliOO}),
	.o(wire_niiili_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiili.width_data = 4,
		niiili.width_sel = 4;
	oper_selector   niiill
	( 
	.data({nllO1l, nll1Ol, nll0OO, nlll1i}),
	.o(wire_niiill_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiill.width_data = 4,
		niiill.width_sel = 4;
	oper_selector   niiilO
	( 
	.data({nllO1O, nll1OO, nlli1i, nlll1l}),
	.o(wire_niiilO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiilO.width_data = 4,
		niiilO.width_sel = 4;
	oper_selector   niiiOi
	( 
	.data({nllO0i, nll01i, nlli1l, nlll1O}),
	.o(wire_niiiOi_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiiOi.width_data = 4,
		niiiOi.width_sel = 4;
	oper_selector   niiiOl
	( 
	.data({nllO0l, nll01l, nlli1O, nlll0i}),
	.o(wire_niiiOl_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiiOl.width_data = 4,
		niiiOl.width_sel = 4;
	oper_selector   niiiOO
	( 
	.data({nllO0O, nll01O, nlli0i, nlll0l}),
	.o(wire_niiiOO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiiOO.width_data = 4,
		niiiOO.width_sel = 4;
	oper_selector   niil0i
	( 
	.data({nllOli, nll0ii, nlliil, nllliO}),
	.o(wire_niil0i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niil0i.width_data = 4,
		niil0i.width_sel = 4;
	oper_selector   niil0l
	( 
	.data({nllOll, nll0il, nlliiO, nlllli}),
	.o(wire_niil0l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niil0l.width_data = 4,
		niil0l.width_sel = 4;
	oper_selector   niil0O
	( 
	.data({nllOlO, nll0iO, nllili, nlllll}),
	.o(wire_niil0O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niil0O.width_data = 4,
		niil0O.width_sel = 4;
	oper_selector   niil1i
	( 
	.data({nllOii, nll00i, nlli0l, nlll0O}),
	.o(wire_niil1i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niil1i.width_data = 4,
		niil1i.width_sel = 4;
	oper_selector   niil1l
	( 
	.data({nllOil, nll00l, nlli0O, nlllii}),
	.o(wire_niil1l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niil1l.width_data = 4,
		niil1l.width_sel = 4;
	oper_selector   niil1O
	( 
	.data({nllOiO, nll00O, nlliii, nlllil}),
	.o(wire_niil1O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niil1O.width_data = 4,
		niil1O.width_sel = 4;
	oper_selector   niilii
	( 
	.data({nllOOi, nll0li, nllill, nllllO}),
	.o(wire_niilii_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niilii.width_data = 4,
		niilii.width_sel = 4;
	oper_selector   niilil
	( 
	.data({nllOOl, nll0ll, nllilO, nlllOi}),
	.o(wire_niilil_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niilil.width_data = 4,
		niilil.width_sel = 4;
	oper_selector   niiliO
	( 
	.data({nllOOO, nll0lO, nlliOi, nlllOl}),
	.o(wire_niiliO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiliO.width_data = 4,
		niiliO.width_sel = 4;
	oper_selector   niilli
	( 
	.data({nlO11i, nll0Oi, nlliOl, nlllOO}),
	.o(wire_niilli_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niilli.width_data = 4,
		niilli.width_sel = 4;
	oper_selector   niilll
	( 
	.data({nlO11l, nll0Ol, nlliOO, nllO1i}),
	.o(wire_niilll_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niilll.width_data = 4,
		niilll.width_sel = 4;
	oper_selector   niillO
	( 
	.data({nlO11O, nll0OO, nlll1i, nllO1l}),
	.o(wire_niillO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niillO.width_data = 4,
		niillO.width_sel = 4;
	oper_selector   niilOi
	( 
	.data({nlO10i, nlli1i, nlll1l, nllO1O}),
	.o(wire_niilOi_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niilOi.width_data = 4,
		niilOi.width_sel = 4;
	oper_selector   niilOl
	( 
	.data({nlO10l, nlli1l, nlll1O, nllO0i}),
	.o(wire_niilOl_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niilOl.width_data = 4,
		niilOl.width_sel = 4;
	oper_selector   niilOO
	( 
	.data({nlO10O, nlli1O, nlll0i, nllO0l}),
	.o(wire_niilOO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niilOO.width_data = 4,
		niilOO.width_sel = 4;
	oper_selector   niiO0i
	( 
	.data({nlO1li, nlliii, nlllil, nllOiO}),
	.o(wire_niiO0i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiO0i.width_data = 4,
		niiO0i.width_sel = 4;
	oper_selector   niiO0l
	( 
	.data({nlO1ll, nlliil, nllliO, nllOli}),
	.o(wire_niiO0l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiO0l.width_data = 4,
		niiO0l.width_sel = 4;
	oper_selector   niiO0O
	( 
	.data({nlO1lO, nlliiO, nlllli, nllOll}),
	.o(wire_niiO0O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiO0O.width_data = 4,
		niiO0O.width_sel = 4;
	oper_selector   niiO1i
	( 
	.data({nlO1ii, nlli0i, nlll0l, nllO0O}),
	.o(wire_niiO1i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiO1i.width_data = 4,
		niiO1i.width_sel = 4;
	oper_selector   niiO1l
	( 
	.data({nlO1il, nlli0l, nlll0O, nllOii}),
	.o(wire_niiO1l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiO1l.width_data = 4,
		niiO1l.width_sel = 4;
	oper_selector   niiO1O
	( 
	.data({nlO1iO, nlli0O, nlllii, nllOil}),
	.o(wire_niiO1O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiO1O.width_data = 4,
		niiO1O.width_sel = 4;
	oper_selector   niiOii
	( 
	.data({nlO1Oi, nllili, nlllll, nllOlO}),
	.o(wire_niiOii_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiOii.width_data = 4,
		niiOii.width_sel = 4;
	oper_selector   niiOil
	( 
	.data({nlO1Ol, nllill, nllllO, nllOOi}),
	.o(wire_niiOil_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiOil.width_data = 4,
		niiOil.width_sel = 4;
	oper_selector   niiOiO
	( 
	.data({nlO1OO, nllilO, nlllOi, nllOOl}),
	.o(wire_niiOiO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiOiO.width_data = 4,
		niiOiO.width_sel = 4;
	oper_selector   niiOli
	( 
	.data({nlO01i, nlliOi, nlllOl, nllOOO}),
	.o(wire_niiOli_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiOli.width_data = 4,
		niiOli.width_sel = 4;
	oper_selector   niiOll
	( 
	.data({nlO01l, nlliOl, nlllOO, nlO11i}),
	.o(wire_niiOll_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiOll.width_data = 4,
		niiOll.width_sel = 4;
	oper_selector   niiOlO
	( 
	.data({nlO01O, nlliOO, nllO1i, nlO11l}),
	.o(wire_niiOlO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiOlO.width_data = 4,
		niiOlO.width_sel = 4;
	oper_selector   niiOOi
	( 
	.data({nlO00i, nlll1i, nllO1l, nlO11O}),
	.o(wire_niiOOi_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiOOi.width_data = 4,
		niiOOi.width_sel = 4;
	oper_selector   niiOOl
	( 
	.data({nlO00l, nlll1l, nllO1O, nlO10i}),
	.o(wire_niiOOl_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiOOl.width_data = 4,
		niiOOl.width_sel = 4;
	oper_selector   niiOOO
	( 
	.data({nlO00O, nlll1O, nllO0i, nlO10l}),
	.o(wire_niiOOO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niiOOO.width_data = 4,
		niiOOO.width_sel = 4;
	oper_selector   nil10i
	( 
	.data({nlO0li, nlllii, nllOil, nlO1iO}),
	.o(wire_nil10i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nil10i.width_data = 4,
		nil10i.width_sel = 4;
	oper_selector   nil10l
	( 
	.data({nlO0ll, nlllil, nllOiO, nlO1li}),
	.o(wire_nil10l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nil10l.width_data = 4,
		nil10l.width_sel = 4;
	oper_selector   nil11i
	( 
	.data({nlO0ii, nlll0i, nllO0l, nlO10O}),
	.o(wire_nil11i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nil11i.width_data = 4,
		nil11i.width_sel = 4;
	oper_selector   nil11l
	( 
	.data({nlO0il, nlll0l, nllO0O, nlO1ii}),
	.o(wire_nil11l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nil11l.width_data = 4,
		nil11l.width_sel = 4;
	oper_selector   nil11O
	( 
	.data({nlO0iO, nlll0O, nllOii, nlO1il}),
	.o(wire_nil11O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nil11O.width_data = 4,
		nil11O.width_sel = 4;
	oper_selector   nili0O
	( 
	.data({nlO10l, nlll1O, nllO0i}),
	.o(wire_nili0O_o),
	.sel({nl000Oi, nl00i1i, nl00i1l}));
	defparam
		nili0O.width_data = 3,
		nili0O.width_sel = 3;
	oper_selector   nilliO
	( 
	.data({nlO00O, nlll1O, nllO0i, nlO10l}),
	.o(wire_nilliO_o),
	.sel({nl000OO, nl00i1i, nl00i1l, wire_nilO1O_o[8]}));
	defparam
		nilliO.width_data = 4,
		nilliO.width_sel = 4;
	oper_selector   niOil
	( 
	.data({wire_nl10l_dataout, (n100O & (nl0i00l | ((rsync_comp_porn & (nl0i00i | nl0i01O)) & (nl0i01l | nl0i01i)))), nl0i0Ol, nl0iiii, (nl0i0lO | (rsync_comp_porn & nl0i0ll)), (n10ii & (nl0i0li | ((rsync_comp_porn & (nl0i0iO | nl0i0il)) & (nl0i0ii | nl0i00O)))), nl0ii1O, nl0iili, (nl0iiiO | nl0iiil), (nl0i0lO | nl0i0ll)}),
	.o(wire_niOil_o),
	.sel({nl0i0Oi, (wire_nl10i_o[61] | wire_nl10i_o[60]), (wire_nl10i_o[57] | wire_nl10i_o[56]), (wire_nl10i_o[53] | wire_nl10i_o[52]), (wire_nl10i_o[49] | wire_nl10i_o[48]), (wire_nl10i_o[43] | wire_nl10i_o[42]), (wire_nl10i_o[39] | wire_nl10i_o[38]), (wire_nl10i_o[35] | wire_nl10i_o[34]), (wire_nl10i_o[21] | wire_nl10i_o[20]), (wire_nl10i_o[17] | wire_nl10i_o[16])}));
	defparam
		niOil.width_data = 10,
		niOil.width_sel = 10;
	oper_selector   niOlil
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[0], nllliO, nllOli, nlO1ll}),
	.o(wire_niOlil_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOlil.width_data = 4,
		niOlil.width_sel = 4;
	oper_selector   niOliO
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[1], nlllli, nllOll, nlO1lO}),
	.o(wire_niOliO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOliO.width_data = 4,
		niOliO.width_sel = 4;
	oper_selector   niOlli
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[2], nlllll, nllOlO, nlO1Oi}),
	.o(wire_niOlli_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOlli.width_data = 4,
		niOlli.width_sel = 4;
	oper_selector   niOlll
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[3], nllllO, nllOOi, nlO1Ol}),
	.o(wire_niOlll_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOlll.width_data = 4,
		niOlll.width_sel = 4;
	oper_selector   niOllO
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[4], nlllOi, nllOOl, nlO1OO}),
	.o(wire_niOllO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOllO.width_data = 4,
		niOllO.width_sel = 4;
	oper_selector   niOlOi
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[5], nlllOl, nllOOO, nlO01i}),
	.o(wire_niOlOi_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOlOi.width_data = 4,
		niOlOi.width_sel = 4;
	oper_selector   niOlOl
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[6], nlllOO, nlO11i, nlO01l}),
	.o(wire_niOlOl_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOlOl.width_data = 4,
		niOlOl.width_sel = 4;
	oper_selector   niOlOO
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[7], nllO1i, nlO11l, nlO01O}),
	.o(wire_niOlOO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOlOO.width_data = 4,
		niOlOO.width_sel = 4;
	oper_selector   niOO0i
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[11], nllO0l, nlO10O, nlO0ii}),
	.o(wire_niOO0i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOO0i.width_data = 4,
		niOO0i.width_sel = 4;
	oper_selector   niOO0l
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[12], nllO0O, nlO1ii, nlO0il}),
	.o(wire_niOO0l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOO0l.width_data = 4,
		niOO0l.width_sel = 4;
	oper_selector   niOO0O
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[13], nllOii, nlO1il, nlO0iO}),
	.o(wire_niOO0O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOO0O.width_data = 4,
		niOO0O.width_sel = 4;
	oper_selector   niOO1i
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[8], nllO1l, nlO11O, nlO00i}),
	.o(wire_niOO1i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOO1i.width_data = 4,
		niOO1i.width_sel = 4;
	oper_selector   niOO1l
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[9], nllO1O, nlO10i, nlO00l}),
	.o(wire_niOO1l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOO1l.width_data = 4,
		niOO1l.width_sel = 4;
	oper_selector   niOO1O
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[10], nllO0i, nlO10l, nlO00O}),
	.o(wire_niOO1O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOO1O.width_data = 4,
		niOO1O.width_sel = 4;
	oper_selector   niOOii
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[14], nllOil, nlO1iO, nlO0li}),
	.o(wire_niOOii_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOOii.width_data = 4,
		niOOii.width_sel = 4;
	oper_selector   niOOil
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[15], nllOiO, nlO1li, nlO0ll}),
	.o(wire_niOOil_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOOil.width_data = 4,
		niOOil.width_sel = 4;
	oper_selector   niOOiO
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[16], nllOli, nlO1ll, wire_nl0l00O_byte_des_fifo_data_in[0]}),
	.o(wire_niOOiO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOOiO.width_data = 4,
		niOOiO.width_sel = 4;
	oper_selector   niOOli
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[17], nllOll, nlO1lO, wire_nl0l00O_byte_des_fifo_data_in[1]}),
	.o(wire_niOOli_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOOli.width_data = 4,
		niOOli.width_sel = 4;
	oper_selector   niOOll
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[18], nllOlO, nlO1Oi, wire_nl0l00O_byte_des_fifo_data_in[2]}),
	.o(wire_niOOll_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOOll.width_data = 4,
		niOOll.width_sel = 4;
	oper_selector   niOOlO
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[19], nllOOi, nlO1Ol, wire_nl0l00O_byte_des_fifo_data_in[3]}),
	.o(wire_niOOlO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOOlO.width_data = 4,
		niOOlO.width_sel = 4;
	oper_selector   niOOOi
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[20], nllOOl, nlO1OO, wire_nl0l00O_byte_des_fifo_data_in[4]}),
	.o(wire_niOOOi_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOOOi.width_data = 4,
		niOOOi.width_sel = 4;
	oper_selector   niOOOl
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[21], nllOOO, nlO01i, wire_nl0l00O_byte_des_fifo_data_in[5]}),
	.o(wire_niOOOl_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOOOl.width_data = 4,
		niOOOl.width_sel = 4;
	oper_selector   niOOOO
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[22], nlO11i, nlO01l, wire_nl0l00O_byte_des_fifo_data_in[6]}),
	.o(wire_niOOOO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		niOOOO.width_data = 4,
		niOOOO.width_sel = 4;
	oper_selector   nl000i
	( 
	.data({1'b0, wire_nl00li_dataout, wire_nl0ill_dataout, wire_nl0llO_dataout, wire_nli1Ol_dataout, wire_nliiii_dataout}),
	.o(wire_nl000i_o),
	.sel({nl00i0i, wire_nl00iO_o[6:5], wire_nl00iO_o[3:1]}));
	defparam
		nl000i.width_data = 6,
		nl000i.width_sel = 6;
	oper_selector   nl000l
	( 
	.data({1'b0, wire_nl00Ol_dataout, wire_nl0iOO_dataout, wire_nl0Oii_dataout, wire_nli00O_dataout, wire_nliiOl_dataout}),
	.o(wire_nl000l_o),
	.sel({nl00i0i, wire_nl00iO_o[6:5], wire_nl00iO_o[3:1]}));
	defparam
		nl000l.width_data = 6,
		nl000l.width_sel = 6;
	oper_selector   nl000O
	( 
	.data({1'b0, wire_nl0i1O_dataout, wire_nl0l0i_dataout, wire_nl0Oll_dataout, wire_nli0iO_dataout, wire_nlil1l_dataout}),
	.o(wire_nl000O_o),
	.sel({nl00i0i, wire_nl00iO_o[6:5], wire_nl00iO_o[3:1]}));
	defparam
		nl000O.width_data = 6,
		nl000O.width_sel = 6;
	oper_selector   nl00ii
	( 
	.data({1'b0, wire_nl0iil_dataout, wire_nl0liO_dataout, wire_nli1ii_dataout, wire_nlii1l_dataout, wire_nlilli_dataout}),
	.o(wire_nl00ii_o),
	.sel({nl00i0i, wire_nl00iO_o[6:5], wire_nl00iO_o[3:1]}));
	defparam
		nl00ii.width_data = 6,
		nl00ii.width_sel = 6;
	oper_selector   nl01iO
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[58], wire_nl0l00O_byte_des_fifo_data_in[10], wire_nl0l00O_byte_des_fifo_data_in[26], wire_nl0l00O_byte_des_fifo_data_in[42]}),
	.o(wire_nl01iO_o),
	.sel({nl000OO, nl00i1i, nl00i1l, wire_nilO1O_o[8]}));
	defparam
		nl01iO.width_data = 4,
		nl01iO.width_sel = 4;
	oper_selector   nl100i
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[41], nlO00l, wire_nl0l00O_byte_des_fifo_data_in[9], wire_nl0l00O_byte_des_fifo_data_in[25]}),
	.o(wire_nl100i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl100i.width_data = 4,
		nl100i.width_sel = 4;
	oper_selector   nl100l
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[42], nlO00O, wire_nl0l00O_byte_des_fifo_data_in[10], wire_nl0l00O_byte_des_fifo_data_in[26]}),
	.o(wire_nl100l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl100l.width_data = 4,
		nl100l.width_sel = 4;
	oper_selector   nl100O
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[43], nlO0ii, wire_nl0l00O_byte_des_fifo_data_in[11], wire_nl0l00O_byte_des_fifo_data_in[27]}),
	.o(wire_nl100O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl100O.width_data = 4,
		nl100O.width_sel = 4;
	oper_selector   nl101i
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[38], nlO01l, wire_nl0l00O_byte_des_fifo_data_in[6], wire_nl0l00O_byte_des_fifo_data_in[22]}),
	.o(wire_nl101i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl101i.width_data = 4,
		nl101i.width_sel = 4;
	oper_selector   nl101l
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[39], nlO01O, wire_nl0l00O_byte_des_fifo_data_in[7], wire_nl0l00O_byte_des_fifo_data_in[23]}),
	.o(wire_nl101l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl101l.width_data = 4,
		nl101l.width_sel = 4;
	oper_selector   nl101O
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[40], nlO00i, wire_nl0l00O_byte_des_fifo_data_in[8], wire_nl0l00O_byte_des_fifo_data_in[24]}),
	.o(wire_nl101O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl101O.width_data = 4,
		nl101O.width_sel = 4;
	oper_selector   nl10ii
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[44], nlO0il, wire_nl0l00O_byte_des_fifo_data_in[12], wire_nl0l00O_byte_des_fifo_data_in[28]}),
	.o(wire_nl10ii_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl10ii.width_data = 4,
		nl10ii.width_sel = 4;
	oper_selector   nl10il
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[45], nlO0iO, wire_nl0l00O_byte_des_fifo_data_in[13], wire_nl0l00O_byte_des_fifo_data_in[29]}),
	.o(wire_nl10il_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl10il.width_data = 4,
		nl10il.width_sel = 4;
	oper_selector   nl10iO
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[46], nlO0li, wire_nl0l00O_byte_des_fifo_data_in[14], wire_nl0l00O_byte_des_fifo_data_in[30]}),
	.o(wire_nl10iO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl10iO.width_data = 4,
		nl10iO.width_sel = 4;
	oper_selector   nl10li
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[47], nlO0ll, wire_nl0l00O_byte_des_fifo_data_in[15], wire_nl0l00O_byte_des_fifo_data_in[31]}),
	.o(wire_nl10li_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl10li.width_data = 4,
		nl10li.width_sel = 4;
	oper_selector   nl10ll
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[48], wire_nl0l00O_byte_des_fifo_data_in[0], wire_nl0l00O_byte_des_fifo_data_in[16], wire_nl0l00O_byte_des_fifo_data_in[32]}),
	.o(wire_nl10ll_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl10ll.width_data = 4,
		nl10ll.width_sel = 4;
	oper_selector   nl10lO
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[49], wire_nl0l00O_byte_des_fifo_data_in[1], wire_nl0l00O_byte_des_fifo_data_in[17], wire_nl0l00O_byte_des_fifo_data_in[33]}),
	.o(wire_nl10lO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl10lO.width_data = 4,
		nl10lO.width_sel = 4;
	oper_selector   nl10Oi
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[50], wire_nl0l00O_byte_des_fifo_data_in[2], wire_nl0l00O_byte_des_fifo_data_in[18], wire_nl0l00O_byte_des_fifo_data_in[34]}),
	.o(wire_nl10Oi_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl10Oi.width_data = 4,
		nl10Oi.width_sel = 4;
	oper_selector   nl10Ol
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[51], wire_nl0l00O_byte_des_fifo_data_in[3], wire_nl0l00O_byte_des_fifo_data_in[19], wire_nl0l00O_byte_des_fifo_data_in[35]}),
	.o(wire_nl10Ol_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl10Ol.width_data = 4,
		nl10Ol.width_sel = 4;
	oper_selector   nl10OO
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[52], wire_nl0l00O_byte_des_fifo_data_in[4], wire_nl0l00O_byte_des_fifo_data_in[20], wire_nl0l00O_byte_des_fifo_data_in[36]}),
	.o(wire_nl10OO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl10OO.width_data = 4,
		nl10OO.width_sel = 4;
	oper_selector   nl110i
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[26], nlO10l, nlO00O, wire_nl0l00O_byte_des_fifo_data_in[10]}),
	.o(wire_nl110i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl110i.width_data = 4,
		nl110i.width_sel = 4;
	oper_selector   nl110l
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[27], nlO10O, nlO0ii, wire_nl0l00O_byte_des_fifo_data_in[11]}),
	.o(wire_nl110l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl110l.width_data = 4,
		nl110l.width_sel = 4;
	oper_selector   nl110O
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[28], nlO1ii, nlO0il, wire_nl0l00O_byte_des_fifo_data_in[12]}),
	.o(wire_nl110O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl110O.width_data = 4,
		nl110O.width_sel = 4;
	oper_selector   nl111i
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[23], nlO11l, nlO01O, wire_nl0l00O_byte_des_fifo_data_in[7]}),
	.o(wire_nl111i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl111i.width_data = 4,
		nl111i.width_sel = 4;
	oper_selector   nl111l
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[24], nlO11O, nlO00i, wire_nl0l00O_byte_des_fifo_data_in[8]}),
	.o(wire_nl111l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl111l.width_data = 4,
		nl111l.width_sel = 4;
	oper_selector   nl111O
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[25], nlO10i, nlO00l, wire_nl0l00O_byte_des_fifo_data_in[9]}),
	.o(wire_nl111O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl111O.width_data = 4,
		nl111O.width_sel = 4;
	oper_selector   nl11ii
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[29], nlO1il, nlO0iO, wire_nl0l00O_byte_des_fifo_data_in[13]}),
	.o(wire_nl11ii_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl11ii.width_data = 4,
		nl11ii.width_sel = 4;
	oper_selector   nl11il
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[30], nlO1iO, nlO0li, wire_nl0l00O_byte_des_fifo_data_in[14]}),
	.o(wire_nl11il_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl11il.width_data = 4,
		nl11il.width_sel = 4;
	oper_selector   nl11iO
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[31], nlO1li, nlO0ll, wire_nl0l00O_byte_des_fifo_data_in[15]}),
	.o(wire_nl11iO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl11iO.width_data = 4,
		nl11iO.width_sel = 4;
	oper_selector   nl11li
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[32], nlO1ll, wire_nl0l00O_byte_des_fifo_data_in[0], wire_nl0l00O_byte_des_fifo_data_in[16]}),
	.o(wire_nl11li_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl11li.width_data = 4,
		nl11li.width_sel = 4;
	oper_selector   nl11ll
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[33], nlO1lO, wire_nl0l00O_byte_des_fifo_data_in[1], wire_nl0l00O_byte_des_fifo_data_in[17]}),
	.o(wire_nl11ll_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl11ll.width_data = 4,
		nl11ll.width_sel = 4;
	oper_selector   nl11lO
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[34], nlO1Oi, wire_nl0l00O_byte_des_fifo_data_in[2], wire_nl0l00O_byte_des_fifo_data_in[18]}),
	.o(wire_nl11lO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl11lO.width_data = 4,
		nl11lO.width_sel = 4;
	oper_selector   nl11Oi
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[35], nlO1Ol, wire_nl0l00O_byte_des_fifo_data_in[3], wire_nl0l00O_byte_des_fifo_data_in[19]}),
	.o(wire_nl11Oi_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl11Oi.width_data = 4,
		nl11Oi.width_sel = 4;
	oper_selector   nl11Ol
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[36], nlO1OO, wire_nl0l00O_byte_des_fifo_data_in[4], wire_nl0l00O_byte_des_fifo_data_in[20]}),
	.o(wire_nl11Ol_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl11Ol.width_data = 4,
		nl11Ol.width_sel = 4;
	oper_selector   nl11OO
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[37], nlO01i, wire_nl0l00O_byte_des_fifo_data_in[5], wire_nl0l00O_byte_des_fifo_data_in[21]}),
	.o(wire_nl11OO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl11OO.width_data = 4,
		nl11OO.width_sel = 4;
	oper_selector   nl1i0i
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[56], wire_nl0l00O_byte_des_fifo_data_in[8], wire_nl0l00O_byte_des_fifo_data_in[24], wire_nl0l00O_byte_des_fifo_data_in[40]}),
	.o(wire_nl1i0i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl1i0i.width_data = 4,
		nl1i0i.width_sel = 4;
	oper_selector   nl1i0l
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[57], wire_nl0l00O_byte_des_fifo_data_in[9], wire_nl0l00O_byte_des_fifo_data_in[25], wire_nl0l00O_byte_des_fifo_data_in[41]}),
	.o(wire_nl1i0l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl1i0l.width_data = 4,
		nl1i0l.width_sel = 4;
	oper_selector   nl1i0O
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[58], wire_nl0l00O_byte_des_fifo_data_in[10], wire_nl0l00O_byte_des_fifo_data_in[26], wire_nl0l00O_byte_des_fifo_data_in[42]}),
	.o(wire_nl1i0O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl1i0O.width_data = 4,
		nl1i0O.width_sel = 4;
	oper_selector   nl1i1i
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[53], wire_nl0l00O_byte_des_fifo_data_in[5], wire_nl0l00O_byte_des_fifo_data_in[21], wire_nl0l00O_byte_des_fifo_data_in[37]}),
	.o(wire_nl1i1i_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl1i1i.width_data = 4,
		nl1i1i.width_sel = 4;
	oper_selector   nl1i1l
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[54], wire_nl0l00O_byte_des_fifo_data_in[6], wire_nl0l00O_byte_des_fifo_data_in[22], wire_nl0l00O_byte_des_fifo_data_in[38]}),
	.o(wire_nl1i1l_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl1i1l.width_data = 4,
		nl1i1l.width_sel = 4;
	oper_selector   nl1i1O
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[55], wire_nl0l00O_byte_des_fifo_data_in[7], wire_nl0l00O_byte_des_fifo_data_in[23], wire_nl0l00O_byte_des_fifo_data_in[39]}),
	.o(wire_nl1i1O_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl1i1O.width_data = 4,
		nl1i1O.width_sel = 4;
	oper_selector   nl1iii
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[59], wire_nl0l00O_byte_des_fifo_data_in[11], wire_nl0l00O_byte_des_fifo_data_in[27], wire_nl0l00O_byte_des_fifo_data_in[43]}),
	.o(wire_nl1iii_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl1iii.width_data = 4,
		nl1iii.width_sel = 4;
	oper_selector   nl1iil
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[60], wire_nl0l00O_byte_des_fifo_data_in[12], wire_nl0l00O_byte_des_fifo_data_in[28], wire_nl0l00O_byte_des_fifo_data_in[44]}),
	.o(wire_nl1iil_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl1iil.width_data = 4,
		nl1iil.width_sel = 4;
	oper_selector   nl1iiO
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[61], wire_nl0l00O_byte_des_fifo_data_in[13], wire_nl0l00O_byte_des_fifo_data_in[29], wire_nl0l00O_byte_des_fifo_data_in[45]}),
	.o(wire_nl1iiO_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl1iiO.width_data = 4,
		nl1iiO.width_sel = 4;
	oper_selector   nl1ili
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[62], wire_nl0l00O_byte_des_fifo_data_in[14], wire_nl0l00O_byte_des_fifo_data_in[30], wire_nl0l00O_byte_des_fifo_data_in[46]}),
	.o(wire_nl1ili_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl1ili.width_data = 4,
		nl1ili.width_sel = 4;
	oper_selector   nl1ill
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[63], wire_nl0l00O_byte_des_fifo_data_in[15], wire_nl0l00O_byte_des_fifo_data_in[31], wire_nl0l00O_byte_des_fifo_data_in[47]}),
	.o(wire_nl1ill_o),
	.sel({nl000li, nl000ll, nl000lO, wire_nil1iO_o[8]}));
	defparam
		nl1ill.width_data = 4,
		nl1ill.width_sel = 4;
	oper_selector   nl1Oil
	( 
	.data({wire_nl0l00O_byte_des_fifo_data_in[42], wire_nl0l00O_byte_des_fifo_data_in[10], wire_nl0l00O_byte_des_fifo_data_in[26]}),
	.o(wire_nl1Oil_o),
	.sel({nl000Oi, nl00i1i, nl00i1l}));
	defparam
		nl1Oil.width_data = 3,
		nl1Oil.width_sel = 3;
	oper_selector   nliil
	( 
	.data({wire_nll0l_dataout, (n101l & (nl0iiOl | (rsync_comp_porn & nl0iiOi))), (n10il & (nl0il1i | (rsync_comp_porn & nl0iiOO))), ((nl0ilii | ((rsync_comp_porn & nl0il0O) & nl0il0i56)) | (~ nl0il1l59)), ((nl0iOli | (rsync_comp_porn & nl0iOiO)) | (~ nl0ilil53)), (n100i & (nl0ilOi | ((rsync_comp_porn & nl0illO) & nl0illi50))), (nl0ilOl47 & (n10iO & (nl0l1Oi | ((rsync_comp_porn & nl0iO1l) & nl0ilOO44)))), (nl0iO0O | ((rsync_comp_porn & nl0iO0l) & nl0iO1O41)), nl0iOii, (nl0iOil38 & (nl0iOli | nl0iOiO))}),
	.o(wire_nliil_o),
	.sel({nl0l1ii, ((wire_nll0i_o[61] | wire_nll0i_o[60]) | (~ nl0iOll35)), ((wire_nll0i_o[57] | wire_nll0i_o[56]) | (~ nl0iOOi32)), (nl0iOOO29 & (wire_nll0i_o[53] | wire_nll0i_o[52])), ((wire_nll0i_o[49] | wire_nll0i_o[48]) | (~ nl0l11i26)), (wire_nll0i_o[43] | wire_nll0i_o[42]), ((wire_nll0i_o[39] | wire_nll0i_o[38]) | (~ nl0l11O23)), (wire_nll0i_o[35] | wire_nll0i_o[34]), ((wire_nll0i_o[21] | wire_nll0i_o[20]) | (~ nl0l10l20)), (wire_nll0i_o[17] | wire_nll0i_o[16])}));
	defparam
		nliil.width_data = 10,
		nliil.width_sel = 10;
	ram8x65_syn   nl0l0ii
	( 
	.clk(rx_wr_clk),
	.data_in({wire_n1011O_dataout, wire_n10Oil_o, wire_n10Oii_o, wire_n10O0O_o, wire_n10O0l_o, wire_n10O0i_o, wire_n10O1O_o, wire_n10O1l_o, wire_n10O1i_o, wire_n10lOO_o, wire_n10lOl_o, wire_n10lOi_o, wire_n10llO_o, wire_n10lll_o, wire_n10lli_o, wire_n10liO_o, wire_n10lil_o, wire_n10lii_o, wire_n10l0O_o, wire_n10l0l_o, wire_n10l0i_o, wire_n10l1O_o, wire_n10l1l_o, wire_n10l1i_o, wire_n10iOO_o, wire_n10iOl_o, wire_n10iOi_o, wire_n10ilO_o, wire_n10ill_o, wire_n10ili_o, wire_n10iiO_o, wire_n10iil_o, wire_n10iii_o, wire_n10i0O_o, wire_n10i0l_o, wire_n10i0i_o, wire_n10i1O_o, wire_n10i1l_o, wire_n10i1i_o, wire_n100OO_o, wire_n100Ol_o, wire_n100Oi_o, wire_n100lO_o, wire_n100ll_o, wire_n100li_o, wire_n100iO_o, wire_n100il_o, wire_n100ii_o, wire_n1000O_o, wire_n1000l_o, wire_n1000i_o, wire_n1001O_o, wire_n1001l_o, wire_n1001i_o, wire_n101OO_o, wire_n101Ol_o, wire_n101Oi_o, wire_n101lO_o, wire_n101ll_o, wire_n101li_o, wire_n101iO_o, wire_n101il_o, wire_n101ii_o, wire_n1010O_o, wire_n1010l_o}),
	.data_out(wire_nl0l0ii_data_out),
	.fifo_re({nli11ii, nli110O, nl0lliO, nli110l, nli110i, nli111O, nli111l, nli111i}),
	.fifo_wr({nl0llOO, nli1lil, nli1lii, nli1l0O, nli1l0l, nli1l0i, nli1l1O, nl0llOl}),
	.rst_l((~ wire_n110l_dataout)));
	defparam
		nl0l0ii.ram_width = 65,
		nl0l0ii.read_access_time = 0,
		nl0l0ii.write_access_time = 0;
	rx_byte_des   nl0l00O
	( 
	.bo_3g_en(n11il),
	.bo_en(wire_n1O0O_dataout),
	.byte_des_bo_3g_start(wire_nl0l00O_byte_des_bo_3g_start),
	.byte_des_fifo_data_in(wire_nl0l00O_byte_des_fifo_data_in),
	.clk_2(clk_2),
	.disp_err_d({wire_n00li_dataout, wire_n00iO_dataout}),
	.disp_val_d({wire_n00il_dataout, wire_n00ii_dataout}),
	.ovr_undflow_d({wire_n000O_dataout, wire_n000l_dataout, wire_n000i_dataout, wire_n001O_dataout}),
	.pattern_det_d({wire_n1OlO_dataout, wire_n1Oll_dataout}),
	.rdwidth(rdwidth),
	.rx_data_int({wire_n001l_dataout, wire_n001i_dataout, wire_n01OO_dataout, wire_n01Ol_dataout, wire_n01Oi_dataout, wire_n01lO_dataout, wire_n01ll_dataout, wire_n01li_dataout, wire_n01iO_dataout, wire_n01il_dataout, wire_n01ii_dataout, wire_n010O_dataout, wire_n010l_dataout, wire_n010i_dataout, wire_n011O_dataout, wire_n011l_dataout, wire_n011i_dataout, wire_n1OOO_dataout, wire_n1OOl_dataout, wire_n1OOi_dataout}),
	.rx_we_out(n11O1l),
	.rx_wr_clk(rx_wr_clk),
	.soft_reset(soft_reset),
	.soft_reset_wclk1(wire_n110l_dataout),
	.sync_resync_d({wire_n00lO_dataout, wire_n00ll_dataout}));
	assign
		bytord_valid_out = wire_nlOlO_dataout,
		nl0000i = ((((((((~ (nl0OO1l ^ nli11Ol)) & (~ (nli11il ^ nl0OO1O))) & (~ (nl0llli ^ nl0OO0i))) & (~ (nli11iO ^ nl0OO0l))) & (~ (nli11li ^ nl0llii))) & (~ (nli11ll ^ nl0OO0O))) & (~ (nli11lO ^ nl0OOii))) & (~ (nli11Oi ^ nl0OOil))),
		nl0000l = ((((((((~ (nli11il ^ nl0OO1l)) & (~ (nl0OO1O ^ nl0llli))) & (~ (nli11iO ^ nl0OO0i))) & (~ (nli11li ^ nl0OO0l))) & (~ (nli11ll ^ nl0llii))) & (~ (nli11lO ^ nl0OO0O))) & (~ (nli11Oi ^ nl0OOii))) & (~ (nli11Ol ^ nl0OOil))),
		nl0000O = (nl0ll0O & rrxfifo_lowlatency_en),
		nl0001l = ((((((wire_nl0lOiO_o[64] | wire_nl0lOiO_o[16]) | wire_nl0lOiO_o[4]) | wire_nl0lOiO_o[32]) | wire_nl0lOiO_o[2]) | wire_nl0lOiO_o[8]) | wire_nl0lOiO_o[128]),
		nl0001O = ((((((((~ (nli11il ^ nl0OOil)) & (~ (nl0OO1l ^ nl0llli))) & (~ (nl0OO1O ^ nli11iO))) & (~ (nl0OO0i ^ nli11li))) & (~ (nl0OO0l ^ nli11ll))) & (~ (nl0llii ^ nli11lO))) & (~ (nl0OO0O ^ nli11Oi))) & (~ (nl0OOii ^ nli11Ol))),
		nl000ii = 1'b0,
		nl000il = (wire_n10Oli_o[1] | wire_n10Oli_o[0]),
		nl000iO = ((~ nliO1i) & (~ nlilOO)),
		nl000li = ((((((((wire_nil1iO_o[15] | wire_nil1iO_o[13]) | wire_nil1iO_o[11]) | wire_nil1iO_o[9]) | wire_nil1iO_o[7]) | wire_nil1iO_o[5]) | wire_nil1iO_o[3]) | wire_nil1iO_o[1]) | wire_nil1iO_o[0]),
		nl000ll = (((wire_nil1iO_o[14] | wire_nil1iO_o[10]) | wire_nil1iO_o[6]) | wire_nil1iO_o[2]),
		nl000lO = (wire_nil1iO_o[12] | wire_nil1iO_o[4]),
		nl000Oi = (((((((((wire_nilO1O_o[8] | wire_nilO1O_o[15]) | wire_nilO1O_o[13]) | wire_nilO1O_o[11]) | wire_nilO1O_o[9]) | wire_nilO1O_o[7]) | wire_nilO1O_o[5]) | wire_nilO1O_o[3]) | wire_nilO1O_o[1]) | wire_nilO1O_o[0]),
		nl000Ol = (((((wire_nilO1O_o[14] | wire_nilO1O_o[10]) | wire_nilO1O_o[6]) | wire_nilO1O_o[2]) | wire_nilO1O_o[12]) | wire_nilO1O_o[4]),
		nl000OO = ((((((((wire_nilO1O_o[15] | wire_nilO1O_o[13]) | wire_nilO1O_o[11]) | wire_nilO1O_o[9]) | wire_nilO1O_o[7]) | wire_nilO1O_o[5]) | wire_nilO1O_o[3]) | wire_nilO1O_o[1]) | wire_nilO1O_o[0]),
		nl00i0i = ((wire_nl00iO_o[7] | wire_nl00iO_o[4]) | wire_nl00iO_o[0]),
		nl00i0l = (((((((((~ (nllliO ^ rbytordpat[9])) & (~ (nlllli ^ rsync_comp_pat[32]))) & (~ (nlllll ^ rsync_comp_pat[33]))) & (~ (nllllO ^ rsync_comp_pat[34]))) & (~ (nlllOi ^ rsync_comp_pat[35]))) & (~ (nlllOl ^ rsync_comp_pat[36]))) & (~ (nlllOO ^ rsync_comp_pat[37]))) & (~ (nllO1i ^ rsync_comp_pat[38]))) & (~ (nllO1l ^ rsync_comp_pat[39]))),
		nl00i0O = (((((((((~ (nlliil ^ rbytordpat[0])) & (~ (nlliiO ^ rbytordpat[1]))) & (~ (nllili ^ rbytordpat[2]))) & (~ (nllill ^ rbytordpat[3]))) & (~ (nllilO ^ rbytordpat[4]))) & (~ (nlliOi ^ rbytordpat[5]))) & (~ (nlliOl ^ rbytordpat[6]))) & (~ (nlliOO ^ rbytordpat[7]))) & (~ (nlll1i ^ rbytordpat[8]))),
		nl00i1i = (((wire_nilO1O_o[14] | wire_nilO1O_o[10]) | wire_nilO1O_o[6]) | wire_nilO1O_o[2]),
		nl00i1l = (wire_nilO1O_o[12] | wire_nilO1O_o[4]),
		nl00i1O = ((((((wire_nilO1O_o[14] | wire_nilO1O_o[10]) | wire_nilO1O_o[6]) | wire_nilO1O_o[2]) | wire_nilO1O_o[12]) | wire_nilO1O_o[4]) | wire_nilO1O_o[8]),
		nl00iii = (((((((((~ (nllOli ^ rbytordpat[9])) & (~ (nllOll ^ rsync_comp_pat[32]))) & (~ (nllOlO ^ rsync_comp_pat[33]))) & (~ (nllOOi ^ rsync_comp_pat[34]))) & (~ (nllOOl ^ rsync_comp_pat[35]))) & (~ (nllOOO ^ rsync_comp_pat[36]))) & (~ (nlO11i ^ rsync_comp_pat[37]))) & (~ (nlO11l ^ rsync_comp_pat[38]))) & (~ (nlO11O ^ rsync_comp_pat[39]))),
		nl00iil = (((((((((~ (nllliO ^ rbytordpat[0])) & (~ (nlllli ^ rbytordpat[1]))) & (~ (nlllll ^ rbytordpat[2]))) & (~ (nllllO ^ rbytordpat[3]))) & (~ (nlllOi ^ rbytordpat[4]))) & (~ (nlllOl ^ rbytordpat[5]))) & (~ (nlllOO ^ rbytordpat[6]))) & (~ (nllO1i ^ rbytordpat[7]))) & (~ (nllO1l ^ rbytordpat[8]))),
		nl00iiO = (((((((((~ (nlO1ll ^ rbytordpat[9])) & (~ (nlO1lO ^ rsync_comp_pat[32]))) & (~ (nlO1Oi ^ rsync_comp_pat[33]))) & (~ (nlO1Ol ^ rsync_comp_pat[34]))) & (~ (nlO1OO ^ rsync_comp_pat[35]))) & (~ (nlO01i ^ rsync_comp_pat[36]))) & (~ (nlO01l ^ rsync_comp_pat[37]))) & (~ (nlO01O ^ rsync_comp_pat[38]))) & (~ (nlO00i ^ rsync_comp_pat[39]))),
		nl00ili = (((((((((~ (wire_nl0l00O_byte_des_fifo_data_in[0] ^ rbytordpat[9])) & (~ (wire_nl0l00O_byte_des_fifo_data_in[1] ^ rsync_comp_pat[32]))) & (~ (wire_nl0l00O_byte_des_fifo_data_in[2] ^ rsync_comp_pat[33]))) & (~ (wire_nl0l00O_byte_des_fifo_data_in[3] ^ rsync_comp_pat[34]))) & (~ (wire_nl0l00O_byte_des_fifo_data_in[4] ^ rsync_comp_pat[35]))) & (~ (wire_nl0l00O_byte_des_fifo_data_in[5] ^ rsync_comp_pat[36]))) & (~ (wire_nl0l00O_byte_des_fifo_data_in[6] ^ rsync_comp_pat[37]))) & (~ (wire_nl0l00O_byte_des_fifo_data_in[7] ^ rsync_comp_pat[38]))) & (~ (wire_nl0l00O_byte_des_fifo_data_in[8] ^ rsync_comp_pat[39]))),
		nl00ill = ((((((((~ (nllliO ^ rsync_comp_pat[32])) & (~ (nlllli ^ rsync_comp_pat[33]))) & (~ (nlllll ^ rsync_comp_pat[34]))) & (~ (nllllO ^ rsync_comp_pat[35]))) & (~ (nlllOi ^ rsync_comp_pat[36]))) & (~ (nlllOl ^ rsync_comp_pat[37]))) & (~ (nlllOO ^ rsync_comp_pat[38]))) & (~ (nllO1i ^ rsync_comp_pat[39]))),
		nl00ilO = ((((((((~ (nlliil ^ rbytordpat[0])) & (~ (nlliiO ^ rbytordpat[1]))) & (~ (nllili ^ rbytordpat[2]))) & (~ (nllill ^ rbytordpat[3]))) & (~ (nllilO ^ rbytordpat[4]))) & (~ (nlliOi ^ rbytordpat[5]))) & (~ (nlliOl ^ rbytordpat[6]))) & (~ (nlliOO ^ rbytordpat[7]))),
		nl00iOi = ((((((((~ (nllOli ^ rsync_comp_pat[32])) & (~ (nllOll ^ rsync_comp_pat[33]))) & (~ (nllOlO ^ rsync_comp_pat[34]))) & (~ (nllOOi ^ rsync_comp_pat[35]))) & (~ (nllOOl ^ rsync_comp_pat[36]))) & (~ (nllOOO ^ rsync_comp_pat[37]))) & (~ (nlO11i ^ rsync_comp_pat[38]))) & (~ (nlO11l ^ rsync_comp_pat[39]))),
		nl00iOl = ((((((((~ (nllliO ^ rbytordpat[0])) & (~ (nlllli ^ rbytordpat[1]))) & (~ (nlllll ^ rbytordpat[2]))) & (~ (nllllO ^ rbytordpat[3]))) & (~ (nlllOi ^ rbytordpat[4]))) & (~ (nlllOl ^ rbytordpat[5]))) & (~ (nlllOO ^ rbytordpat[6]))) & (~ (nllO1i ^ rbytordpat[7]))),
		nl00iOO = ((((((((~ (nlO1ll ^ rsync_comp_pat[32])) & (~ (nlO1lO ^ rsync_comp_pat[33]))) & (~ (nlO1Oi ^ rsync_comp_pat[34]))) & (~ (nlO1Ol ^ rsync_comp_pat[35]))) & (~ (nlO1OO ^ rsync_comp_pat[36]))) & (~ (nlO01i ^ rsync_comp_pat[37]))) & (~ (nlO01l ^ rsync_comp_pat[38]))) & (~ (nlO01O ^ rsync_comp_pat[39]))),
		nl00l0i = ((((((((((~ (nllOli ^ (~ rbytordpat[0]))) & (~ (nllOll ^ (~ rbytordpat[1])))) & (~ (nllOlO ^ (~ rbytordpat[2])))) & (~ (nllOOi ^ (~ rbytordpat[3])))) & (~ (nllOOl ^ (~ rbytordpat[4])))) & (~ (nllOOO ^ (~ rbytordpat[5])))) & (~ (nlO11i ^ (~ rbytordpat[6])))) & (~ (nlO11l ^ (~ rbytordpat[7])))) & (~ (nlO11O ^ (~ rbytordpat[8])))) & (~ (nlO10i ^ (~ rbytordpat[9])))),
		nl00l0l = ((((((((((~ (nllOli ^ rbytordpat[0])) & (~ (nllOll ^ rbytordpat[1]))) & (~ (nllOlO ^ rbytordpat[2]))) & (~ (nllOOi ^ rbytordpat[3]))) & (~ (nllOOl ^ rbytordpat[4]))) & (~ (nllOOO ^ rbytordpat[5]))) & (~ (nlO11i ^ rbytordpat[6]))) & (~ (nlO11l ^ rbytordpat[7]))) & (~ (nlO11O ^ rbytordpat[8]))) & (~ (nlO10i ^ rbytordpat[9]))),
		nl00l0O = (nl00liO | nl00lil),
		nl00l1i = ((((((((~ (wire_nl0l00O_byte_des_fifo_data_in[0] ^ rsync_comp_pat[32])) & (~ (wire_nl0l00O_byte_des_fifo_data_in[1] ^ rsync_comp_pat[33]))) & (~ (wire_nl0l00O_byte_des_fifo_data_in[2] ^ rsync_comp_pat[34]))) & (~ (wire_nl0l00O_byte_des_fifo_data_in[3] ^ rsync_comp_pat[35]))) & (~ (wire_nl0l00O_byte_des_fifo_data_in[4] ^ rsync_comp_pat[36]))) & (~ (wire_nl0l00O_byte_des_fifo_data_in[5] ^ rsync_comp_pat[37]))) & (~ (wire_nl0l00O_byte_des_fifo_data_in[6] ^ rsync_comp_pat[38]))) & (~ (wire_nl0l00O_byte_des_fifo_data_in[7] ^ rsync_comp_pat[39]))),
		nl00l1l = ((((((((((~ (nlO1ll ^ (~ rbytordpat[0]))) &