//
// Copyright (C) Altera Corporation
//
// Any megafunction design, and related net list (encrypted or decrypted),
// support information, device programming or simulation file, and any
// other associated documentation or information provided by Altera or a
// partner under Altera's Megafunction Partnership Program may be used only
// to program PLD devices (but not masked PLD devices) from Altera.  Any
// other use of such megafunction design, net list, support information,
// device programming or simulation file, or any other related
// documentation or information is prohibited for any other purpose,
// including, but not limited to modification, reverse engineering, de-
// compiling, or use with any other silicon devices, unless such use is
// explicitly licensed under a separate agreement with Altera or a
// megafunction partner.  Title to the intellectual property, including
// patents, copyrights, trademarks, trade secrets, or maskworks, embodied
// in any such megafunction design, net list, support information, device
// programming or simulation file, or any other related documentation or
// information provided by Altera or a megafunction partner, remains with
// Altera, the megafunction partner, or their respective licensors.  No
// other licenses, including any licenses needed under any third party's
// intellectual property, are provided herein.
//--------------------------------------------------------------------------
// Stratix GX Megafunction Simulation File
//
//--------------------------------------------------------------------------
///////////////////////////////////////////////////////////////////////////////
//
//                           altgxb megafunction
//
///////////////////////////////////////////////////////////////////////////////



`define HSSI_MAXCDR  20
`define HSSI_MAXQUAD  5
`define HSSI_MAXCWIDTH 20
`define HSSI_MAXDIV   1000000000000.0


`timescale 1 ps / 1 ps

module altgxb (
               inclk, 
               pll_areset, 
               rx_in, 
               rx_coreclk, 
               rx_cruclk, 
               rx_aclr, 
               rx_bitslip,                
               rx_enacdet, 
               rx_we, 
               rx_re, 
               rx_slpbk, 
               rx_a1a2size, 
               rx_equalizerctrl, 
               rx_locktorefclk, 
               rx_locktodata,
               tx_in, 
               tx_coreclk, 
               tx_aclr, 
               tx_ctrlenable, 
               tx_forcedisparity, 
               tx_srlpbk, 
               tx_vodctrl,                
               tx_preemphasisctrl,
               txdigitalreset, 
               rxdigitalreset, 
               rxanalogreset, 
               pllenable,
               pll_locked, 
               coreclk_out, 
               rx_out, 
               rx_clkout, 
               rx_locked, 
               rx_freqlocked, 
               rx_rlv, 
               rx_syncstatus,
               rx_patterndetect, 
               rx_ctrldetect, 
               rx_errdetect, 
               rx_disperr, 
               rx_signaldetect,
//               rx_fifoempty, 
//               rx_fifofull, 
               rx_fifoalmostempty, 
               rx_fifoalmostfull,                
               rx_channelaligned,
               rx_bisterr, 
               rx_bistdone, 
               rx_a1a2sizeout,
               tx_out);
    


    parameter operation_mode = "DUPLEX";     // Other modes- "RX", "TX", "DUPLEX"
    parameter loopback_mode = "NONE"; // "SLB", "RSLB", "PLB", "RPLB", "P8LB"
    parameter reverse_loopback_mode = "NONE";
    parameter protocol  = "NONE";     // Other protocols -  "GIGE", "INFINIBAND", "RAPIDIO", "FIBRECHANNEL"
    parameter number_of_channels = 20;
    parameter number_of_quads = 1;
    parameter channel_width = 10;
    parameter pll_inclock_period = 20000;       // 20000ps = 50MHz
    parameter data_rate = 0;  // May be unused
    parameter data_rate_remainder = 0;  // 2.2 

    parameter use_8b_10b_mode = "OFF";
    parameter use_double_data_mode = "OFF";
    parameter dwidth_factor = 2;

   // RX mode
    parameter disparity_mode = "OFF";
    parameter cru_inclock_period = 0;
    parameter run_length = 128;              
    parameter run_length_enable = "OFF";              
    parameter use_channel_align = "OFF";
    parameter use_auto_bit_slip  = "ON";

    parameter use_symbol_align = "ON";
    parameter align_pattern = "0000000101111100";
    parameter align_pattern_length = 10;
    parameter infiniband_invalid_code = 0; 
    parameter clk_out_mode_reference = "ON";
    parameter use_rate_match_fifo = "ON";
    parameter tx_termination = 0; // new in 3.0
    parameter use_fifo_mode = "ON";

    parameter for_engineering_sample_device = "ON"; // new in 3.0 sp2
    // TX mode

    parameter intended_device_family = "ALTGXB";
    parameter force_disparity_mode = "OFF";
    parameter lpm_type = "altgxb";
    
    // Quartus 2.2 new parameters
    // common
    parameter use_self_test_mode = "OFF";
    parameter self_test_mode = 0;

    // Quartus 5.0 new parameter
    parameter allow_gxb_merging = "OFF";
    
    // Receiver
    parameter use_equalizer_ctrl_signal = "OFF";
    parameter equalizer_ctrl_setting = 0;
    parameter signal_threshold_select = 80;
    parameter rx_bandwidth_type = "NEW_MEDIUM";
    parameter rx_enable_dc_coupling = "OFF";
    parameter use_vod_ctrl_signal = "OFF";
    parameter vod_ctrl_setting = 1000;
    parameter use_preemphasis_ctrl_signal = "OFF";
    parameter preemphasis_ctrl_setting = 0;
    parameter use_phase_shift = "ON";
    parameter pll_bandwidth_type = "LOW";
    parameter pll_use_dc_coupling = "OFF";
    parameter rx_ppm_setting = 1000;
    parameter device_family = "";
    parameter use_rx_cruclk = "OFF";
    parameter use_rx_clkout = "OFF";

    parameter use_rx_coreclk   = "OFF";
    parameter use_tx_coreclk   = "OFF";
    parameter instantiate_transmitter_pll = "OFF";
    parameter consider_instantiate_transmitter_pll_param = "OFF";
    parameter use_generic_fifo   = "OFF";
    parameter rx_force_signal_detect = "OFF";
    parameter flip_rx_out = "OFF";
    parameter flip_tx_in = "OFF";
    parameter add_generic_fifo_we_synch_register = "OFF";
    parameter consider_enable_tx_8b_10b_i1i2_generation = "OFF";
    parameter enable_tx_8b_10b_i1i2_generation = "OFF";

    parameter rx_channel_width = (((use_generic_fifo == "ON") || (clk_out_mode_reference == "OFF")) &&
                                 ((channel_width == 16)    ||
                                   (channel_width == 20)))? channel_width/2: channel_width;

    parameter rx_channel_width_div2  = rx_channel_width/2;
    parameter channel_width_div2  = channel_width/2;
    parameter rx_use_double_data_mode = (clk_out_mode_reference == "OFF")?"OFF":use_double_data_mode;


    
    parameter rx_dwidth_factor = (((use_generic_fifo == "ON") || (clk_out_mode_reference == "OFF")) &&
                                  (dwidth_factor == 2))? dwidth_factor/2: dwidth_factor;



    parameter c_align_pattern = (align_pattern_length <= 0)?" ":align_pattern[8 * (align_pattern_length)-1:0];

    parameter deserialization_factor =  (use_8b_10b_mode == "ON")?
                                        10:((use_double_data_mode== "ON")?channel_width/2:channel_width);
   


    parameter rx_data_rate = 0;  // May be unused
    parameter rx_data_rate_remainder = 0;  // 2.2 


    parameter pll_data_rate = (data_rate > 0)?data_rate : rx_data_rate;
    parameter pll_data_rate_remainder = (data_rate_remainder > 0)?data_rate_remainder : rx_data_rate_remainder;


    parameter cru_data_rate = (rx_data_rate > 0)?rx_data_rate : data_rate;
    parameter cru_data_rate_remainder = (rx_data_rate_remainder > 0)?rx_data_rate_remainder : data_rate_remainder;


    parameter pll_mult_value_tmp = (((pll_data_rate * 100 + pll_data_rate_remainder/10000) * 
                                  pll_inclock_period)/ 1000000  + 50)/100;

    parameter pll_mult_value = (pll_mult_value_tmp <= 0 || pll_mult_value_tmp > 20) ? 5 : pll_mult_value_tmp;

    parameter pllclk_mult = (pll_mult_value == 5)?pll_mult_value:pll_mult_value/2;
    parameter pllclk0_div = (pll_mult_value == 5)?2 : 1;
    parameter pllclk_div_adj = (pll_mult_value == 5)?1 : 2;

    parameter int_cru_inclock_period = (cru_inclock_period ==0)?
                                       (pll_inclock_period * deserialization_factor/pll_mult_value):cru_inclock_period;

    
    parameter cru_mult_value = (((cru_data_rate * 100 + cru_data_rate_remainder/10000) * 
                                  int_cru_inclock_period)/ 1000000 + 50)/100;


    parameter cruclk_div = ((cru_inclock_period > 0) && ((cru_mult_value == 4) || (cru_mult_value == 5)))?"ON":"OFF";
    parameter cruclk_mult = ((cru_mult_value == 4) || (cru_mult_value == 5))?cru_mult_value:cru_mult_value/2;
    parameter pllclk2_divisor = (use_double_data_mode == "ON")?deserialization_factor*2:deserialization_factor;





    parameter protocol_to_mode = ((protocol == "XAUI") || (protocol == "XAUI"))?"XAUI":
                           ((protocol == "GIGE") || (protocol == "GIGE"))?"GIGE":"NONE";


     
    parameter tx_transmit_protocol = 
            (consider_enable_tx_8b_10b_i1i2_generation == "OFF")? protocol_to_mode:
              ((protocol == "XAUI") || (protocol == "XAUI"))?"XAUI":
                 (enable_tx_8b_10b_i1i2_generation == "ON")?"GIGE":"NONE";
                           




    // To support for bypass all design - the symbol_align cannot bypass
    parameter d_use_symbol_align = (use_symbol_align == "OFF")?"ON":use_symbol_align;
    parameter d_use_auto_bit_slip = (use_symbol_align == "OFF")?"ON":use_auto_bit_slip;
    parameter d_protocol_to_mode = (use_symbol_align == "OFF")?"NONE":protocol_to_mode;
    parameter d_align_pattern_length = (use_symbol_align == "OFF")?
                                       ((deserialization_factor == 10)?10:16):align_pattern_length;
    parameter d_align_pattern = (use_symbol_align == "OFF")?
        ((deserialization_factor == 10)?"0101111100":"0000111100001111"):c_align_pattern;



    // Common input ports for Rx and Tx mode
    input [number_of_quads-1:0] inclk;
//    input [number_of_channels-1:0] coreclk;
    input [number_of_quads-1:0] pll_areset; // tri0



    // Input ports for RX mode
    input [number_of_channels-1:0] rx_in;
    input [number_of_channels-1:0] rx_coreclk;
    input [number_of_quads-1:0]    rx_cruclk;
    input [number_of_channels-1:0] rx_aclr;    // tri0
    input [number_of_channels-1:0] rx_bitslip;
    input [number_of_channels-1:0] rx_enacdet;
    input [number_of_channels-1:0] rx_we;
    input [number_of_channels-1:0] rx_re;
    input [number_of_channels-1:0] rx_slpbk;
    input [number_of_channels-1:0] rx_a1a2size;
    input [number_of_channels * 3-1:0] rx_equalizerctrl;
    input [number_of_channels-1:0] rx_locktorefclk;
    input [number_of_channels-1:0] rx_locktodata;







    // Input ports for TX mode
    input [channel_width * number_of_channels-1:0] tx_in;
    input [number_of_channels-1:0] tx_coreclk;
    input [number_of_channels-1:0] tx_aclr;  // tri0
    input [dwidth_factor * number_of_channels-1:0] tx_ctrlenable;
    input [dwidth_factor * number_of_channels-1:0] tx_forcedisparity;
    input [number_of_channels-1:0] tx_srlpbk;
    input [number_of_channels * 3-1:0] tx_vodctrl;
    input [number_of_channels * 3-1:0] tx_preemphasisctrl;

    // XGM Input ports, common for Both Rx and Tx Mode

    input [number_of_channels - 1:0] txdigitalreset;
    input [number_of_channels - 1:0] rxdigitalreset;
    input [number_of_channels - 1:0] rxanalogreset;
    input [number_of_quads - 1:0]     pllenable;




  
    // Common output ports for RX and TX mode
    output [number_of_quads-1:0] pll_locked;
    output [number_of_quads-1:0] coreclk_out;

   // Output ports for RX mode
    output [rx_channel_width*number_of_channels-1:0] rx_out;
    output [number_of_channels-1:0] rx_clkout;
    output [number_of_channels-1:0] rx_locked;
    output [number_of_channels-1:0] rx_freqlocked;
    output [number_of_channels-1:0] rx_rlv;
    output [rx_dwidth_factor * number_of_channels-1:0] rx_syncstatus;
    output [rx_dwidth_factor * number_of_channels-1:0] rx_patterndetect;
    output [rx_dwidth_factor * number_of_channels-1:0] rx_ctrldetect;
    output [rx_dwidth_factor * number_of_channels-1:0] rx_errdetect;
    output [rx_dwidth_factor * number_of_channels-1:0] rx_disperr;
    output [number_of_channels-1:0] rx_signaldetect;
//    output [number_of_channels-1:0] rx_fifoempty;
//    output [number_of_channels-1:0] rx_fifofull;
    output [number_of_channels-1:0] rx_fifoalmostempty;
    output [number_of_channels-1:0] rx_fifoalmostfull;
    output [number_of_quads-1:0] rx_channelaligned;
    output [number_of_channels-1:0] rx_bisterr;
    output [number_of_channels-1:0] rx_bistdone;
    output [rx_dwidth_factor * number_of_channels-1:0] rx_a1a2sizeout;


   // Output ports for TX mode
    output [number_of_channels-1:0] tx_out;

   // Output ports from XGM State Machines
//    output [number_of_quads-1:0] xgm_alignstatus;


    // Variables  for Receivers
    reg  [`HSSI_MAXCDR-1:0] i_rx_in;
                            
    reg  [`HSSI_MAXCDR-1:0] i_rx_bitslip;
    reg  [`HSSI_MAXCDR-1:0] i_rx_enacdet;
    reg  [`HSSI_MAXCDR-1:0] i_rx_we;
    reg  [`HSSI_MAXCDR-1:0] i_rx_re;
    reg  [`HSSI_MAXCDR-1:0] i_rx_slpbk;

    reg  [`HSSI_MAXCDR-1:0] i_rx_coreclk;


    // 2.2 Input Ports

    tri0  [`HSSI_MAXCDR-1:0] i_rx_a1a2size;
    reg  [`HSSI_MAXCDR * 3-1:0] i_rx_equalizerctrl;
    reg  [`HSSI_MAXCDR-1:0] i_rx_locktorefclk;
    reg  [`HSSI_MAXCDR-1:0] i_rx_locktodata;


    reg  [`HSSI_MAXCDR * 3-1:0] i_tx_vodctrl;
    reg  [`HSSI_MAXCDR * 3-1:0] i_tx_preemphasisctrl;
    


    wire w_rx_inclk0;
    wire [2 * `HSSI_MAXCDR-1:0] i_rx_syncstatus;
    wire [2 * `HSSI_MAXCDR-1:0] i_rx_patterndetect;
    wire [2 * `HSSI_MAXCDR-1:0] i_rx_ctrldetect;
    wire [2 * `HSSI_MAXCDR-1:0] i_rx_errdetect;
    wire [2 * `HSSI_MAXCDR-1:0] i_rx_disperr;


    reg [2 * `HSSI_MAXCDR-1:0] t_rx_syncstatus;
    reg [2 * `HSSI_MAXCDR-1:0] t_rx_patterndetect;
    reg [2 * `HSSI_MAXCDR-1:0] t_rx_ctrldetect;
    reg [2 * `HSSI_MAXCDR-1:0] t_rx_errdetect;
    reg [2 * `HSSI_MAXCDR-1:0] t_rx_disperr;




    wire  [`HSSI_MAXCDR-1:0] rx_fifofull;
    wire  [`HSSI_MAXCDR-1:0] rx_fifoempty;



    wire  [`HSSI_MAXCDR-1:0] i_rx_syncstatusdeskew;
    wire  [`HSSI_MAXCDR-1:0] i_rx_adetectdeskew;
    wire  [`HSSI_MAXCDR-1:0] i_rx_fifofull;
    wire  [`HSSI_MAXCDR-1:0] i_rx_fifoempty;
    wire  [`HSSI_MAXCDR-1:0] i_rx_fifoalmostfull;
    wire  [`HSSI_MAXCDR-1:0] i_rx_fifoalmostempty;
    wire  [`HSSI_MAXCDR-1:0] i_rx_signaldetect;

    wire  [`HSSI_MAXCDR-1:0] i_rx_locked;
    wire  [`HSSI_MAXCDR-1:0] i_rx_freqlocked;
    wire  [`HSSI_MAXCDR-1:0] i_rx_rlv;
    wire  [`HSSI_MAXCDR-1:0] i_rx_clkout;
    wire  [`HSSI_MAXCDR-1:0] i_rx_recovclkout;


   // 2.2 New Output ports
    wire  [`HSSI_MAXCDR-1:0] i_rx_bisterr;
    wire  [`HSSI_MAXCDR-1:0] i_rx_bistdone;
    wire  [2 * `HSSI_MAXCDR-1:0] i_rx_a1a2sizeout;
    reg  [2 * `HSSI_MAXCDR-1:0] t_rx_a1a2sizeout;



  
    wire  [rx_channel_width * 4 -1:0] w_rx_out00;
    wire  [rx_channel_width * 4 -1:0] w_rx_out01;
    wire  [rx_channel_width * 4 -1:0] w_rx_out02;
    wire  [rx_channel_width * 4 -1:0] w_rx_out03;
    wire  [rx_channel_width * 4 -1:0] w_rx_out04;


    reg  [channel_width * 4 -1:0] w_tx_in00;
    reg  [channel_width * 4 -1:0] w_tx_in01;
    reg  [channel_width * 4 -1:0] w_tx_in02;
    reg  [channel_width * 4 -1:0] w_tx_in03;
    reg  [channel_width * 4 -1:0] w_tx_in04;

    reg   [rx_channel_width*`HSSI_MAXCDR-1:0] t_rx_out;

    reg   [rx_channel_width*`HSSI_MAXCDR-1:0] i_rx_out;
    reg   [rx_channel_width*`HSSI_MAXCDR-1:0] i_w_rx_out;

    // Variables  for Transmitters

    wire  [`HSSI_MAXCDR-1:0] w_tx_out;


    reg  [`HSSI_MAXCDR-1:0] i_tx_coreclk;
    reg  [2 * `HSSI_MAXCDR-1:0] i_tx_ctrlenable;
    reg  [2 * `HSSI_MAXCDR-1:0] i_tx_forcedisparity;
    reg  [`HSSI_MAXCDR-1:0] i_tx_srlpbk;


    reg [20 * `HSSI_MAXCDR - 1:0] i_tx_in;
    reg [20 * `HSSI_MAXCDR - 1:0] tx_in_int;













    // Variables for XGM State Machines
    wire [`HSSI_MAXQUAD-1:0] i_pll_locked;
    wire [`HSSI_MAXQUAD-1:0] i_coreclk_out;
    wire [`HSSI_MAXQUAD-1:0] i_rx_channelaligned;

    reg [`HSSI_MAXQUAD-1:0] i_inclk;
    
    reg [`HSSI_MAXQUAD-1:0] i_rx_cruclk;

    reg [`HSSI_MAXCDR  -1:0] i_txdigitalreset;
    reg [`HSSI_MAXCDR  -1:0] i_rxdigitalreset;
    reg [`HSSI_MAXCDR  -1:0] i_rxanalogreset;
//    reg [`HSSI_MAXQUAD-1:0] i_pllenable;


    tri0 [`HSSI_MAXQUAD-1:0] i_pll_areset;
    tri1 [`HSSI_MAXQUAD - 1 : 0] my_pllenable;


  // Variables for PLL Clock

    integer i;
    integer j;
    integer channel_pos;
// Change Parameter to match the atom level
// PLL Stuff


//    wire [8 * (align_pattern_length)-1:0] c_align_pattern;





   specify
      
   endspecify
   
   initial
      begin

      if (operation_mode == "RX")
       begin
       end
      if (operation_mode == "TX")
       begin
       end
      if (operation_mode == "DUPLEX")
       begin
       end

      end
                                                   
    assign my_pllenable = pllenable[number_of_quads - 1 : 0];
    assign i_pll_areset = pll_areset[number_of_quads - 1: 0];
    assign i_rx_a1a2size= rx_a1a2size[number_of_channels - 1: 0];


    hssi_quad quad0 (.inclk(i_inclk[0]), 
                     .rx_coreclk(i_rx_coreclk[3:0]), 
                     .pll_areset(i_pll_areset[0]), 
                     .rx_cruclk(i_rx_cruclk[0]),
                     .rx_in(i_rx_in[3:0]), 
                     .rx_bitslip(i_rx_bitslip[3:0]), 
                     .rx_enacdet(i_rx_enacdet[3:0]), 
                     .rx_we(i_rx_we[3:0]), 
                     .rx_re(i_rx_re[3:0]), 
                     .rx_slpbk(i_rx_slpbk[3:0]), 
                     .rx_a1a2size(i_rx_a1a2size[3:0]), 
                     .rx_equalizerctrl(i_rx_equalizerctrl[11:0]), 
                     .rx_locktorefclk(i_rx_locktorefclk[3:0]), 
                     .rx_locktodata(i_rx_locktodata[3:0]), 
                     .tx_vodctrl(i_tx_vodctrl[11:0]), 
                     .tx_preemphasisctrl(i_tx_preemphasisctrl[11:0]), 
                     .txdigitalreset(i_txdigitalreset[3:0]),
                     .rxdigitalreset(i_rxdigitalreset[3:0]),
                     .rxanalogreset(i_rxanalogreset[3:0]),
                     .pllenable(my_pllenable[0]),

                     .tx_in(w_tx_in00),
                     .tx_coreclk(i_tx_coreclk[3:0]), 
                     .tx_ctrlenable(i_tx_ctrlenable[7:0]), 
                     .tx_forcedisparity(i_tx_forcedisparity[7:0]), 
                     .tx_srlpbk(i_tx_srlpbk[3:0]), 
                     .pll_locked(i_pll_locked[0]),
                     .coreclk_out(i_coreclk_out[0]), 
                     .rx_out(w_rx_out00), 
                     .rx_clkout(i_rx_clkout[3:0]), 
                     .rx_locked(i_rx_locked[3:0]), 
                     .rx_freqlocked(i_rx_freqlocked[3:0]), 
                     .rx_rlv(i_rx_rlv[3:0]),
                     .rx_syncstatus(i_rx_syncstatus[7:0]),
                     .rx_patterndetect(i_rx_patterndetect[7:0]), 
                     .rx_ctrldetect(i_rx_ctrldetect[7:0]), 
                     .rx_errdetect(i_rx_errdetect[7:0]), 
                     .rx_disperr(i_rx_disperr[7:0]),
                     .rx_signaldetect(i_rx_signaldetect[3:0]),
                     .rx_fifoempty(i_rx_fifoempty[3:0]), 
                     .rx_fifofull(i_rx_fifofull[3:0]), 
                     .rx_fifoalmostempty(i_rx_fifoalmostempty[3:0]), 
                     .rx_fifoalmostfull(i_rx_fifoalmostfull[3:0]), 
                     .rx_channelaligned(i_rx_channelaligned[0]),
                     .rx_bisterr(i_rx_bisterr[3:0]),
                     .rx_bistdone(i_rx_bistdone[3:0]),
                     .rx_a1a2sizeout(i_rx_a1a2sizeout[7:0]),
                     .tx_out(w_tx_out[3:0]));
              defparam
                   quad0.operation_mode               = operation_mode,
                   quad0.loopback_mode                = loopback_mode,
                   quad0.reverse_loopback_mode        = reverse_loopback_mode,
                   quad0.pll_inclock_period           = pll_inclock_period,
                   quad0.data_rate                    = data_rate,
                   quad0.number_of_channels           = 4,
                   quad0.channel_width                = channel_width,
                   quad0.rx_channel_width             = rx_channel_width,
                   quad0.rx_dwidth_factor             = rx_dwidth_factor,
                   quad0.c_use_8b_10b_mode            = use_8b_10b_mode,
                   quad0.c_use_double_data_mode       = use_double_data_mode,
                   quad0.rx_use_double_data_mode      = rx_use_double_data_mode,
                   quad0.protocol                     = protocol,
                   quad0.run_length                   = run_length,
                   quad0.run_length_enable            = run_length_enable,
                   quad0.c_use_rate_match_fifo        = use_rate_match_fifo,
                   quad0.c_use_channel_align          = use_channel_align,
                   quad0.protocol_to_mode             = d_protocol_to_mode,
                   quad0.tx_transmit_protocol         = tx_transmit_protocol,
                   quad0.c_use_symbol_align           = d_use_symbol_align,
                   quad0.c_use_auto_bit_slip          = d_use_auto_bit_slip,
                   quad0.align_pattern                = d_align_pattern,
                   quad0.align_pattern_length         = d_align_pattern_length,
                   quad0.infiniband_invalid_code      = infiniband_invalid_code,
                   quad0.c_disparity_mode             = disparity_mode,
                   quad0.c_force_disparity_mode       = force_disparity_mode,
                   quad0.c_clk_out_mode_reference     = clk_out_mode_reference,
                   quad0.intended_device_family       = intended_device_family,
                   quad0.deserialization_factor       = deserialization_factor,
                   quad0.pll_mult_value               = pll_mult_value,
                   quad0.cru_inclock_period           = int_cru_inclock_period,
                   quad0.cruclk_mult                  = cruclk_mult,
                   quad0.cruclk_div                   = cruclk_div,
                   quad0.pllclk_mult                  = pllclk_mult,
                   quad0.pllclk0_div                  = pllclk0_div,
                   quad0.pllclk_div_adj               = pllclk_div_adj,
                   quad0.pllclk2_divisor              = pllclk2_divisor,
                   quad0.use_self_test_mode           = use_self_test_mode,
                   quad0.self_test_mode               = self_test_mode,
                   quad0.use_equalizer_ctrl_signal    = use_equalizer_ctrl_signal,
                   quad0.equalizer_ctrl_setting       = equalizer_ctrl_setting,
                   quad0.signal_threshold_select      = signal_threshold_select,
                   quad0.rx_bandwidth_type            = rx_bandwidth_type,
                   quad0.rx_enable_dc_coupling        = rx_enable_dc_coupling,
                   quad0.use_vod_ctrl_signal          = use_vod_ctrl_signal,
                   quad0.vod_ctrl_setting             = vod_ctrl_setting,
                   quad0.use_preemphasis_ctrl_signal  = use_preemphasis_ctrl_signal,
                   quad0.preemphasis_ctrl_setting     = preemphasis_ctrl_setting,
                   quad0.use_phase_shift              = use_phase_shift,
                   quad0.pll_bandwidth_type           = pll_bandwidth_type,
                   quad0.pll_use_dc_coupling          = pll_use_dc_coupling,
                   quad0.rx_ppm_setting               = rx_ppm_setting,
                   quad0.device_family                = device_family,
                   quad0.use_rx_cruclk                = use_rx_cruclk,
                   quad0.use_rx_clkout                = use_rx_clkout,
                   quad0.use_rx_coreclk               = use_rx_coreclk,
                   quad0.use_tx_coreclk               = use_tx_coreclk,
                   quad0.instantiate_transmitter_pll  = instantiate_transmitter_pll,
                   quad0.consider_instantiate_transmitter_pll_param  = consider_instantiate_transmitter_pll_param,
                   quad0.flip_rx_out                  = flip_rx_out,
                   quad0.flip_tx_in                   = flip_tx_in,
                   quad0.add_generic_fifo_we_synch_register= add_generic_fifo_we_synch_register,
                   quad0.for_engineering_sample_device     = for_engineering_sample_device;

                   




    hssi_quad quad1 (.inclk(i_inclk[1]), 
                     .rx_coreclk(i_rx_coreclk[7:4]), 
                     .pll_areset(i_pll_areset[1]), 
                     .rx_cruclk(i_rx_cruclk[1]),
                     .rx_in(i_rx_in[7:4]), 

                     .rx_bitslip(i_rx_bitslip[7:4]), 
                     .rx_enacdet(i_rx_enacdet[7:4]), 
                     .rx_we(i_rx_we[7:4]), 
                     .rx_re(i_rx_re[7:4]), 
                     .rx_slpbk(i_rx_slpbk[7:4]), 
                     .rx_a1a2size(i_rx_a1a2size[7:4]), 
                     .rx_equalizerctrl(i_rx_equalizerctrl[23:12]), 
                     .rx_locktorefclk(i_rx_locktorefclk[7:4]), 
                     .rx_locktodata(i_rx_locktodata[7:4]), 
                     .tx_vodctrl(i_tx_vodctrl[23:12]), 
                     .tx_preemphasisctrl(i_tx_preemphasisctrl[23:12]), 

                     .txdigitalreset(i_txdigitalreset[7:4]),
                     .rxdigitalreset(i_rxdigitalreset[7:4]),
                     .rxanalogreset(i_rxanalogreset[7:4]),
                     .pllenable(my_pllenable[1]),

                     .tx_in(w_tx_in01),
                     .tx_coreclk(i_tx_coreclk[7:4]), 
                     .tx_ctrlenable(i_tx_ctrlenable[15:8]), 
                     .tx_forcedisparity(i_tx_forcedisparity[15:8]), 
                     .tx_srlpbk(i_tx_srlpbk[7:4]), 
                     .pll_locked(i_pll_locked[1]),
                     .coreclk_out(i_coreclk_out[1]), 
                     .rx_out(w_rx_out01), 
                     .rx_clkout(i_rx_clkout[7:4]), 
                     .rx_locked(i_rx_locked[7:4]), 
                     .rx_freqlocked(i_rx_freqlocked[7:4]), 
                     .rx_rlv(i_rx_rlv[7:4]),
                     .rx_syncstatus(i_rx_syncstatus[15:8]),
                     .rx_patterndetect(i_rx_patterndetect[15:8]),
                     .rx_ctrldetect(i_rx_ctrldetect[15:8]),
                     .rx_errdetect(i_rx_errdetect[15:8]),
                     .rx_disperr(i_rx_disperr[15:8]),
                     .rx_signaldetect(i_rx_signaldetect[7:4]),
                     .rx_fifoempty(i_rx_fifoempty[7:4]), 
                     .rx_fifofull(i_rx_fifofull[7:4]), 
                     .rx_fifoalmostempty(i_rx_fifoalmostempty[7:4]), 
                     .rx_fifoalmostfull(i_rx_fifoalmostfull[7:4]), 
                     .rx_channelaligned(i_rx_channelaligned[1]),
                     .rx_bisterr(i_rx_bisterr[7:4]),
                     .rx_bistdone(i_rx_bistdone[7:4]),
                     .rx_a1a2sizeout(i_rx_a1a2sizeout[15:8]),
                     .tx_out(w_tx_out[7:4]));
              defparam
                   quad1.operation_mode               = operation_mode,
                   quad1.loopback_mode                = loopback_mode,
                   quad1.reverse_loopback_mode        = reverse_loopback_mode,
                   quad1.pll_inclock_period           = pll_inclock_period,
                   quad1.data_rate                    = data_rate,
                   quad1.number_of_channels           = 4,
                   quad1.protocol                     = protocol,
                   quad1.channel_width                = channel_width,
                   quad1.rx_channel_width             = rx_channel_width,
                   quad1.rx_dwidth_factor             = rx_dwidth_factor,
                   quad1.c_use_8b_10b_mode            = use_8b_10b_mode,
                   quad1.c_use_double_data_mode       = use_double_data_mode,
                   quad1.rx_use_double_data_mode      = rx_use_double_data_mode,
                   quad1.run_length                   = run_length,
                   quad1.run_length_enable            = run_length_enable,
                   quad1.c_use_rate_match_fifo        = use_rate_match_fifo,
                   quad1.c_use_channel_align          = use_channel_align,
                   quad1.protocol_to_mode             = d_protocol_to_mode,
                   quad1.tx_transmit_protocol         = tx_transmit_protocol,
                   quad1.c_use_symbol_align           = d_use_symbol_align,
                   quad1.c_use_auto_bit_slip          = d_use_auto_bit_slip,
                   quad1.align_pattern                = d_align_pattern,
                   quad1.align_pattern_length         = d_align_pattern_length,
                   quad1.infiniband_invalid_code      = infiniband_invalid_code,
                   quad1.c_disparity_mode             = disparity_mode,
                   quad1.c_force_disparity_mode       = force_disparity_mode,
                   quad1.c_clk_out_mode_reference     = clk_out_mode_reference,
                   quad1.intended_device_family       = intended_device_family,
                   quad1.deserialization_factor       = deserialization_factor,
                   quad1.pll_mult_value               = pll_mult_value,
                   quad1.cru_inclock_period           = int_cru_inclock_period,
                   quad1.cruclk_mult                  = cruclk_mult,
                   quad1.cruclk_div                   = cruclk_div,
                   quad1.pllclk_mult                  = pllclk_mult,
                   quad1.pllclk0_div                  = pllclk0_div,
                   quad1.pllclk_div_adj               = pllclk_div_adj,
                   quad1.pllclk2_divisor              = pllclk2_divisor,
                   quad1.use_self_test_mode           = use_self_test_mode,
                   quad1.self_test_mode               = self_test_mode,
                   quad1.use_equalizer_ctrl_signal    = use_equalizer_ctrl_signal,
                   quad1.equalizer_ctrl_setting       = equalizer_ctrl_setting,
                   quad1.signal_threshold_select      = signal_threshold_select,
                   quad1.rx_bandwidth_type            = rx_bandwidth_type,
                   quad1.rx_enable_dc_coupling        = rx_enable_dc_coupling,
                   quad1.use_vod_ctrl_signal          = use_vod_ctrl_signal,
                   quad1.vod_ctrl_setting             = vod_ctrl_setting,
                   quad1.use_preemphasis_ctrl_signal  = use_preemphasis_ctrl_signal,
                   quad1.preemphasis_ctrl_setting     = preemphasis_ctrl_setting,
                   quad1.use_phase_shift              = use_phase_shift,
                   quad1.pll_bandwidth_type           = pll_bandwidth_type,
                   quad1.pll_use_dc_coupling          = pll_use_dc_coupling,
                   quad1.rx_ppm_setting               = rx_ppm_setting,
                   quad1.device_family                = device_family,
                   quad1.use_rx_cruclk                = use_rx_cruclk,
                   quad1.use_rx_clkout                = use_rx_clkout,
                   quad1.use_rx_coreclk               = use_rx_coreclk,
                   quad1.use_tx_coreclk               = use_tx_coreclk,
                   quad1.instantiate_transmitter_pll  = instantiate_transmitter_pll,
                   quad1.consider_instantiate_transmitter_pll_param  = consider_instantiate_transmitter_pll_param,
                   quad1.flip_rx_out                  = flip_rx_out,
                   quad1.flip_tx_in                   = flip_tx_in,
                   quad1.add_generic_fifo_we_synch_register= add_generic_fifo_we_synch_register,
                   quad1.for_engineering_sample_device     = for_engineering_sample_device;







    hssi_quad quad2 (.inclk(i_inclk[2]), 
                     .rx_coreclk(i_rx_coreclk[11:8]), 
                     .pll_areset(i_pll_areset[2]), 
                     .rx_cruclk(i_rx_cruclk[2]),
                     .rx_in(i_rx_in[11:8]), 

                     .rx_bitslip(i_rx_bitslip[11:8]), 
                     .rx_enacdet(i_rx_enacdet[11:8]), 
                     .rx_we(i_rx_we[11:8]), 
                     .rx_re(i_rx_re[11:8]), 
                     .rx_slpbk(i_rx_slpbk[11:8]), 
                     .rx_a1a2size(i_rx_a1a2size[11:8]), 
                     .rx_equalizerctrl(i_rx_equalizerctrl[35:24]), 
                     .rx_locktorefclk(i_rx_locktorefclk[11:8]), 
                     .rx_locktodata(i_rx_locktodata[11:8]), 
                     .tx_vodctrl(i_tx_vodctrl[35:24]), 
                     .tx_preemphasisctrl(i_tx_preemphasisctrl[35:24]), 

                     .txdigitalreset(i_txdigitalreset[11:8]),
                     .rxdigitalreset(i_rxdigitalreset[11:8]),
                     .rxanalogreset(i_rxanalogreset[11:8]),
                     .pllenable(my_pllenable[2]),

                     .tx_in(w_tx_in02),
                     .tx_coreclk(i_tx_coreclk[11:8]), 

                     .tx_ctrlenable(i_tx_ctrlenable[23:16]), 
                     .tx_forcedisparity(i_tx_forcedisparity[23:16]), 
                     .tx_srlpbk(i_tx_srlpbk[11:8]), 
                     .pll_locked(i_pll_locked[2]),
                     .coreclk_out(i_coreclk_out[2]), 
                     .rx_out(w_rx_out02), 
                     .rx_clkout(i_rx_clkout[11:8]), 
                     .rx_locked(i_rx_locked[11:8]), 
                     .rx_freqlocked(i_rx_freqlocked[11:8]), 
                     .rx_rlv(i_rx_rlv[11:8]),
                     .rx_syncstatus(i_rx_syncstatus[23:16]), 
                     .rx_patterndetect(i_rx_patterndetect[23:16]), 
                     .rx_ctrldetect(i_rx_ctrldetect[23:16]), 
                     .rx_errdetect(i_rx_errdetect[23:16]), 
                     .rx_disperr(i_rx_disperr[23:16]), 
                     .rx_signaldetect(i_rx_signaldetect[11:8]),
                     .rx_fifoempty(i_rx_fifoempty[11:8]), 
                     .rx_fifofull(i_rx_fifofull[11:8]), 
                     .rx_fifoalmostempty(i_rx_fifoalmostempty[11:8]), 
                     .rx_fifoalmostfull(i_rx_fifoalmostfull[11:8]), 
                     .rx_channelaligned(i_rx_channelaligned[2]),
                     .rx_bisterr(i_rx_bisterr[11:8]),
                     .rx_bistdone(i_rx_bistdone[11:8]),
                     .rx_a1a2sizeout(i_rx_a1a2sizeout[23:16]),
                     .tx_out(w_tx_out[11:8]));
              defparam
                   quad2.operation_mode               = operation_mode,
                   quad2.loopback_mode                = loopback_mode,
                   quad2.reverse_loopback_mode        = reverse_loopback_mode,
                   quad2.pll_inclock_period           = pll_inclock_period,
                   quad2.data_rate                    = data_rate,
                   quad2.number_of_channels           = 4,
                   quad2.protocol                     = protocol,
                   quad2.channel_width                = channel_width,
                   quad2.rx_channel_width             = rx_channel_width,
                   quad2.rx_dwidth_factor             = rx_dwidth_factor,
                   quad2.c_use_8b_10b_mode            = use_8b_10b_mode,
                   quad2.c_use_double_data_mode       = use_double_data_mode,
                   quad2.rx_use_double_data_mode      = rx_use_double_data_mode,
                   quad2.run_length                   = run_length,
                   quad2.run_length_enable            = run_length_enable,
                   quad2.c_use_rate_match_fifo        = use_rate_match_fifo,
                   quad2.c_use_channel_align          = use_channel_align,
                   quad2.protocol_to_mode             = d_protocol_to_mode,
                   quad2.tx_transmit_protocol         = tx_transmit_protocol,
                   quad2.c_use_symbol_align           = d_use_symbol_align,
                   quad2.c_use_auto_bit_slip          = d_use_auto_bit_slip,
                   quad2.align_pattern                = d_align_pattern,
                   quad2.align_pattern_length         = d_align_pattern_length,
                   quad2.infiniband_invalid_code      = infiniband_invalid_code,
                   quad2.c_disparity_mode             = disparity_mode,
                   quad2.c_force_disparity_mode       = force_disparity_mode,
                   quad2.c_clk_out_mode_reference     = clk_out_mode_reference,
                   quad2.intended_device_family       = intended_device_family,
                   quad2.deserialization_factor       = deserialization_factor,
                   quad2.pll_mult_value               = pll_mult_value,
                   quad2.cru_inclock_period           = int_cru_inclock_period,
                   quad2.cruclk_mult                  = cruclk_mult,
                   quad2.cruclk_div                   = cruclk_div,
                   quad2.pllclk_mult                  = pllclk_mult,
                   quad2.pllclk0_div                  = pllclk0_div,
                   quad2.pllclk_div_adj               = pllclk_div_adj,
                   quad2.pllclk2_divisor              = pllclk2_divisor,
                   quad2.use_self_test_mode           = use_self_test_mode,
                   quad2.self_test_mode               = self_test_mode,
                   quad2.use_equalizer_ctrl_signal    = use_equalizer_ctrl_signal,
                   quad2.equalizer_ctrl_setting       = equalizer_ctrl_setting,
                   quad2.signal_threshold_select      = signal_threshold_select,
                   quad2.rx_bandwidth_type            = rx_bandwidth_type,
                   quad2.rx_enable_dc_coupling        = rx_enable_dc_coupling,
                   quad2.use_vod_ctrl_signal          = use_vod_ctrl_signal,
                   quad2.vod_ctrl_setting             = vod_ctrl_setting,
                   quad2.use_preemphasis_ctrl_signal  = use_preemphasis_ctrl_signal,
                   quad2.preemphasis_ctrl_setting     = preemphasis_ctrl_setting,
                   quad2.use_phase_shift              = use_phase_shift,
                   quad2.pll_bandwidth_type           = pll_bandwidth_type,
                   quad2.pll_use_dc_coupling          = pll_use_dc_coupling,
                   quad2.rx_ppm_setting               = rx_ppm_setting,
                   quad2.device_family                = device_family,
                   quad2.use_rx_cruclk                = use_rx_cruclk,
                   quad2.use_rx_clkout                = use_rx_clkout,
                   quad2.use_rx_coreclk               = use_rx_coreclk,
                   quad2.use_tx_coreclk               = use_tx_coreclk,
                   quad2.instantiate_transmitter_pll  = instantiate_transmitter_pll,
                   quad2.consider_instantiate_transmitter_pll_param  = consider_instantiate_transmitter_pll_param,
                   quad2.flip_rx_out                  = flip_rx_out,
                   quad2.flip_tx_in                   = flip_tx_in,
                   quad2.add_generic_fifo_we_synch_register= add_generic_fifo_we_synch_register,
                   quad2.for_engineering_sample_device     = for_engineering_sample_device;







    hssi_quad quad3 (.inclk(i_inclk[3]), 
                     .rx_coreclk(i_rx_coreclk[15:12]), 
                     .pll_areset(i_pll_areset[3]), 
                     .rx_cruclk(i_rx_cruclk[3]),
                     .rx_in(i_rx_in[15:12]), 

                     .rx_bitslip(i_rx_bitslip[15:12]), 
                     .rx_enacdet(i_rx_enacdet[15:12]), 
                     .rx_we(i_rx_we[15:12]), 
                     .rx_re(i_rx_re[15:12]), 
                     .rx_slpbk(i_rx_slpbk[15:12]), 
                     .rx_a1a2size(i_rx_a1a2size[15:12]), 
                     .rx_equalizerctrl(i_rx_equalizerctrl[47:36]), 
                     .rx_locktorefclk(i_rx_locktorefclk[15:12]), 
                     .rx_locktodata(i_rx_locktodata[15:12]), 
                     .tx_vodctrl(i_tx_vodctrl[47:36]), 
                     .tx_preemphasisctrl(i_tx_preemphasisctrl[47:36]), 

                     .txdigitalreset(i_txdigitalreset[15:12]),
                     .rxdigitalreset(i_rxdigitalreset[15:12]),
                     .rxanalogreset(i_rxanalogreset[15:12]),
                     .pllenable(my_pllenable[3]),

                     .tx_in(w_tx_in03),
                     .tx_coreclk(i_tx_coreclk[15:12]), 

                     .tx_ctrlenable(i_tx_ctrlenable[31:24]), 
                     .tx_forcedisparity(i_tx_forcedisparity[31:24]), 
                     .tx_srlpbk(i_tx_srlpbk[15:12]), 
                     .pll_locked(i_pll_locked[3]),
                     .coreclk_out(i_coreclk_out[3]), 
                     .rx_out(w_rx_out03), 
                     .rx_clkout(i_rx_clkout[15:12]), 
                     .rx_locked(i_rx_locked[15:12]), 
                     .rx_freqlocked(i_rx_freqlocked[15:12]), 
                     .rx_rlv(i_rx_rlv[15:12]),
                     .rx_syncstatus(i_rx_syncstatus[31:24]), 
                     .rx_patterndetect(i_rx_patterndetect[31:24]), 
                     .rx_ctrldetect(i_rx_ctrldetect[31:24]), 
                     .rx_errdetect(i_rx_errdetect[31:24]), 
                     .rx_disperr(i_rx_disperr[31:24]), 
                     .rx_signaldetect(i_rx_signaldetect[15:12]),
                     .rx_fifoempty(i_rx_fifoempty[15:12]), 
                     .rx_fifofull(i_rx_fifofull[15:12]), 
                     .rx_fifoalmostempty(i_rx_fifoalmostempty[15:12]), 
                     .rx_fifoalmostfull(i_rx_fifoalmostfull[15:12]), 
                     .rx_channelaligned(i_rx_channelaligned[3]),
                     .rx_bisterr(i_rx_bisterr[15:12]),
                     .rx_bistdone(i_rx_bistdone[15:12]),
                     .rx_a1a2sizeout(i_rx_a1a2sizeout[31:24]),
                     .tx_out(w_tx_out[15:12]));
              defparam
                   quad3.operation_mode               = operation_mode,
                   quad3.loopback_mode                = loopback_mode,
                   quad3.reverse_loopback_mode        = reverse_loopback_mode,
                   quad3.pll_inclock_period           = pll_inclock_period,
                   quad3.data_rate                    = data_rate,
                   quad3.number_of_channels           = 4,
                   quad3.protocol                     = protocol,
                   quad3.channel_width                = channel_width,
                   quad3.rx_channel_width             = rx_channel_width,
                   quad3.rx_dwidth_factor             = rx_dwidth_factor,
                   quad3.c_use_8b_10b_mode            = use_8b_10b_mode,
                   quad3.c_use_double_data_mode       = use_double_data_mode,
                   quad3.rx_use_double_data_mode      = rx_use_double_data_mode,
                   quad3.run_length                   = run_length,
                   quad3.run_length_enable            = run_length_enable,
                   quad3.c_use_rate_match_fifo        = use_rate_match_fifo,
                   quad3.c_use_channel_align          = use_channel_align,
                   quad3.protocol_to_mode             = d_protocol_to_mode,
                   quad3.tx_transmit_protocol         = tx_transmit_protocol,
                   quad3.c_use_symbol_align           = d_use_symbol_align,
                   quad3.c_use_auto_bit_slip          = d_use_auto_bit_slip,
                   quad3.align_pattern                = d_align_pattern,
                   quad3.align_pattern_length         = d_align_pattern_length,
                   quad3.infiniband_invalid_code      = infiniband_invalid_code,
                   quad3.c_disparity_mode             = disparity_mode,
                   quad3.c_force_disparity_mode       = force_disparity_mode,
                   quad3.c_clk_out_mode_reference     = clk_out_mode_reference,
                   quad3.intended_device_family       = intended_device_family,
                   quad3.deserialization_factor       = deserialization_factor,
                   quad3.pll_mult_value               = pll_mult_value,
                   quad3.cru_inclock_period           = int_cru_inclock_period,
                   quad3.cruclk_mult                  = cruclk_mult,
                   quad3.cruclk_div                   = cruclk_div,
                   quad3.pllclk_mult                  = pllclk_mult,
                   quad3.pllclk0_div                  = pllclk0_div,
                   quad3.pllclk_div_adj               = pllclk_div_adj,
                   quad3.pllclk2_divisor              = pllclk2_divisor,
                   quad3.use_self_test_mode           = use_self_test_mode,
                   quad3.self_test_mode               = self_test_mode,
                   quad3.use_equalizer_ctrl_signal    = use_equalizer_ctrl_signal,
                   quad3.equalizer_ctrl_setting       = equalizer_ctrl_setting,
                   quad3.signal_threshold_select      = signal_threshold_select,
                   quad3.rx_bandwidth_type            = rx_bandwidth_type,
                   quad3.rx_enable_dc_coupling        = rx_enable_dc_coupling,
                   quad3.use_vod_ctrl_signal          = use_vod_ctrl_signal,
                   quad3.vod_ctrl_setting             = vod_ctrl_setting,
                   quad3.use_preemphasis_ctrl_signal  = use_preemphasis_ctrl_signal,
                   quad3.preemphasis_ctrl_setting     = preemphasis_ctrl_setting,
                   quad3.use_phase_shift              = use_phase_shift,
                   quad3.pll_bandwidth_type           = pll_bandwidth_type,
                   quad3.pll_use_dc_coupling          = pll_use_dc_coupling,
                   quad3.rx_ppm_setting               = rx_ppm_setting,
                   quad3.device_family                = device_family,
                   quad3.use_rx_cruclk                = use_rx_cruclk,
                   quad3.use_rx_clkout                = use_rx_clkout,
                   quad3.use_rx_coreclk               = use_rx_coreclk,
                   quad3.use_tx_coreclk               = use_tx_coreclk,
                   quad3.instantiate_transmitter_pll  = instantiate_transmitter_pll,
                   quad3.consider_instantiate_transmitter_pll_param  = consider_instantiate_transmitter_pll_param,
                   quad3.flip_rx_out                  = flip_rx_out,
                   quad3.flip_tx_in                   = flip_tx_in,
                   quad3.add_generic_fifo_we_synch_register= add_generic_fifo_we_synch_register,
                   quad3.for_engineering_sample_device     = for_engineering_sample_device;




    hssi_quad quad4 (.inclk(i_inclk[4]), 
                     .rx_coreclk(i_rx_coreclk[19:16]), 
                     .pll_areset(i_pll_areset[4]), 
                     .rx_cruclk(i_rx_cruclk[4]),
                     .rx_in(i_rx_in[19:16]), 

                     .rx_bitslip(i_rx_bitslip[19:16]), 
                     .rx_enacdet(i_rx_enacdet[19:16]), 
                     .rx_we(i_rx_we[19:16]), 
                     .rx_re(i_rx_re[19:16]), 
                     .rx_slpbk(i_rx_slpbk[19:16]), 
                     .rx_a1a2size(i_rx_a1a2size[19:16]), 
                     .rx_equalizerctrl(i_rx_equalizerctrl[59:48]), 
                     .rx_locktorefclk(i_rx_locktorefclk[19:16]), 
                     .rx_locktodata(i_rx_locktodata[19:16]), 
                     .tx_vodctrl(i_tx_vodctrl[59:48]), 
                     .tx_preemphasisctrl(i_tx_preemphasisctrl[59:48]), 

                     .txdigitalreset(i_txdigitalreset[19:16]),
                     .rxdigitalreset(i_rxdigitalreset[19:16]),
                     .rxanalogreset(i_rxanalogreset[19:16]),
                     .pllenable(my_pllenable[4]),

                     .tx_in(w_tx_in04),
                     .tx_coreclk(i_tx_coreclk[19:16]), 

                     .tx_ctrlenable(i_tx_ctrlenable[39:32]), 
                     .tx_forcedisparity(i_tx_forcedisparity[39:32]), 
                     .tx_srlpbk(i_tx_srlpbk[19:16]), 
                     .pll_locked(i_pll_locked[4]),
                     .coreclk_out(i_coreclk_out[4]), 
                     .rx_out(w_rx_out04), 
                     .rx_clkout(i_rx_clkout[19:16]), 
                     .rx_locked(i_rx_locked[19:16]), 
                     .rx_freqlocked(i_rx_freqlocked[19:16]), 
                     .rx_rlv(i_rx_rlv[19:16]),
                     .rx_syncstatus(i_rx_syncstatus[39:32]), 
                     .rx_patterndetect(i_rx_patterndetect[39:32]), 
                     .rx_ctrldetect(i_rx_ctrldetect[39:32]), 
                     .rx_errdetect(i_rx_errdetect[39:32]), 
                     .rx_disperr(i_rx_disperr[39:32]), 
                     .rx_signaldetect(i_rx_signaldetect[19:16]),
                     .rx_fifoempty(i_rx_fifoempty[19:16]), 
                     .rx_fifofull(i_rx_fifofull[19:16]), 
                     .rx_fifoalmostempty(i_rx_fifoalmostempty[19:16]), 
                     .rx_fifoalmostfull(i_rx_fifoalmostfull[19:16]), 
                     .rx_channelaligned(i_rx_channelaligned[4]),
                     .rx_bisterr(i_rx_bisterr[19:16]),
                     .rx_bistdone(i_rx_bistdone[19:16]),
                     .rx_a1a2sizeout(i_rx_a1a2sizeout[39:32]),
                     .tx_out(w_tx_out[19:16]));
              defparam
                   quad4.operation_mode               = operation_mode,
                   quad4.loopback_mode                = loopback_mode,
                   quad4.reverse_loopback_mode        = reverse_loopback_mode,
                   quad4.pll_inclock_period           = pll_inclock_period,
                   quad4.data_rate                    = data_rate,
                   quad4.number_of_channels           = 4,
                   quad4.channel_width                = channel_width,
                   quad4.rx_channel_width             = rx_channel_width,
                   quad4.rx_dwidth_factor             = rx_dwidth_factor,
                   quad4.c_use_8b_10b_mode            = use_8b_10b_mode,
                   quad4.c_use_double_data_mode       = use_double_data_mode,
                   quad4.rx_use_double_data_mode      = rx_use_double_data_mode,
                   quad4.protocol                     = protocol,
                   quad4.run_length                   = run_length,
                   quad4.run_length_enable            = run_length_enable,
                   quad4.c_use_rate_match_fifo        = use_rate_match_fifo,
                   quad4.c_use_channel_align          = use_channel_align,
                   quad4.protocol_to_mode             = d_protocol_to_mode,
                   quad4.tx_transmit_protocol         = tx_transmit_protocol,
                   quad4.c_use_symbol_align           = d_use_symbol_align,
                   quad4.c_use_auto_bit_slip          = d_use_auto_bit_slip,
                   quad4.align_pattern                = d_align_pattern,
                   quad4.align_pattern_length         = d_align_pattern_length,
                   quad4.infiniband_invalid_code      = infiniband_invalid_code,
                   quad4.c_disparity_mode             = disparity_mode,
                   quad4.c_force_disparity_mode       = force_disparity_mode,
                   quad4.c_clk_out_mode_reference     = clk_out_mode_reference,
                   quad4.intended_device_family       = intended_device_family,
                   quad4.deserialization_factor       = deserialization_factor,
                   quad4.pll_mult_value               = pll_mult_value,
                   quad4.cru_inclock_period           = int_cru_inclock_period,
                   quad4.cruclk_mult                  = cruclk_mult,
                   quad4.cruclk_div                   = cruclk_div,
                   quad4.pllclk_mult                  = pllclk_mult,
                   quad4.pllclk0_div                  = pllclk0_div,
                   quad4.pllclk_div_adj               = pllclk_div_adj,
                   quad4.pllclk2_divisor              = pllclk2_divisor,
                   quad4.use_self_test_mode           = use_self_test_mode,
                   quad4.self_test_mode               = self_test_mode,
                   quad4.use_equalizer_ctrl_signal    = use_equalizer_ctrl_signal,
                   quad4.equalizer_ctrl_setting       = equalizer_ctrl_setting,
                   quad4.signal_threshold_select      = signal_threshold_select,
                   quad4.rx_bandwidth_type            = rx_bandwidth_type,
                   quad4.rx_enable_dc_coupling        = rx_enable_dc_coupling,
                   quad4.use_vod_ctrl_signal          = use_vod_ctrl_signal,
                   quad4.vod_ctrl_setting             = vod_ctrl_setting,
                   quad4.use_preemphasis_ctrl_signal  = use_preemphasis_ctrl_signal,
                   quad4.preemphasis_ctrl_setting     = preemphasis_ctrl_setting,
                   quad4.use_phase_shift              = use_phase_shift,
                   quad4.pll_bandwidth_type           = pll_bandwidth_type,
                   quad4.pll_use_dc_coupling          = pll_use_dc_coupling,
                   quad4.rx_ppm_setting               = rx_ppm_setting,
                   quad4.device_family                = device_family,
                   quad4.use_rx_cruclk                = use_rx_cruclk,
                   quad4.use_rx_clkout                = use_rx_clkout,
                   quad4.use_rx_coreclk               = use_rx_coreclk,
                   quad4.use_tx_coreclk               = use_tx_coreclk,
                   quad4.instantiate_transmitter_pll  = instantiate_transmitter_pll,
                   quad4.consider_instantiate_transmitter_pll_param  = consider_instantiate_transmitter_pll_param,
                   quad4.flip_rx_out                  = flip_rx_out,
                   quad4.flip_tx_in                   = flip_tx_in,
                   quad4.add_generic_fifo_we_synch_register= add_generic_fifo_we_synch_register,
                   quad4.for_engineering_sample_device     = for_engineering_sample_device;


  // For Receivers
  // Inputs

                        
    always @(rx_in)
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            i_rx_in[i] = (number_of_channels > i) ? rx_in[i] : 0;



    always @(rx_bitslip)
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            i_rx_bitslip[i] = (number_of_channels > i) ? rx_bitslip[i] : 0;

    always @(rx_enacdet)
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            i_rx_enacdet[i] = (number_of_channels > i) ? rx_enacdet[i] : 0;


    always @(rx_we)
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            i_rx_we[i] = (number_of_channels > i) ? rx_we[i] : 0;

    always @(rx_re)
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            i_rx_re[i] = (number_of_channels > i) ? rx_re[i] : 0;

    always @(rx_slpbk)
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            i_rx_slpbk[i] = (number_of_channels > i) ? rx_slpbk[i] : 0;


    always @(rx_equalizerctrl)
    begin
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            begin
            i_rx_equalizerctrl[i * 3]     = (number_of_channels > i) ? rx_equalizerctrl[i * 3] : 0; 
            i_rx_equalizerctrl[i * 3 + 1] = (number_of_channels > i) ? rx_equalizerctrl[i * 3 + 1] : 0; 
            i_rx_equalizerctrl[i * 3 + 2] = (number_of_channels > i) ? rx_equalizerctrl[i * 3 + 2] : 0; 

            end
    end

    always @(tx_vodctrl)
    begin
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            begin
            i_tx_vodctrl[i * 3]     = (number_of_channels > i) ? tx_vodctrl[i * 3] : 0; 
            i_tx_vodctrl[i * 3 + 1] = (number_of_channels > i) ? tx_vodctrl[i * 3 + 1] : 0; 
            i_tx_vodctrl[i * 3 + 2] = (number_of_channels > i) ? tx_vodctrl[i * 3 + 2] : 0; 

            end
    end
    always @(tx_preemphasisctrl)
    begin
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            begin
            i_tx_preemphasisctrl[i * 3]     = (number_of_channels > i) ? tx_preemphasisctrl[i * 3] : 0; 
            i_tx_preemphasisctrl[i * 3 + 1] = (number_of_channels > i) ? tx_preemphasisctrl[i * 3 + 1] : 0; 
            i_tx_preemphasisctrl[i * 3 + 2] = (number_of_channels > i) ? tx_preemphasisctrl[i * 3 + 2] : 0; 

            end
    end

    always @(rx_locktorefclk)
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            i_rx_locktorefclk[i] = (number_of_channels > i) ? rx_locktorefclk[i] : 0;

    always @(rx_locktodata)
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            i_rx_locktodata[i] = (number_of_channels > i) ? rx_locktodata[i] : 0;

    always @(inclk)
        for(i=0; i < `HSSI_MAXQUAD; i=i+1)
            i_inclk[i] = (number_of_quads > i) ? inclk[i] : 0;

    
    always @(txdigitalreset)
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            i_txdigitalreset[i] = (number_of_channels > i) ? txdigitalreset[i] : 0;


    always @(rxdigitalreset)
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            i_rxdigitalreset[i] = (number_of_channels > i) ? rxdigitalreset[i] : 0;


    always @(rxanalogreset)
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            i_rxanalogreset[i] = (number_of_channels > i) ? rxanalogreset[i] : 0;





    always @(rx_cruclk)
        for(i=0; i < `HSSI_MAXQUAD; i=i+1)
            i_rx_cruclk[i] = (number_of_quads > i) ? rx_cruclk[i] : 0;

    always @(rx_coreclk)
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            i_rx_coreclk[i] = (number_of_channels > i) ? rx_coreclk[i] : 0;

    always @(tx_coreclk)
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            i_tx_coreclk[i] = (number_of_channels > i) ? tx_coreclk[i] : 0;


  // For XGM State Machines only
  // Inputs



//  always @
//    output [number_of_quads-1:0] pll_locked;
//    output [number_of_quads-1:0] pll_clkout;



// For transmitter only
  // Inputs
    always @(tx_ctrlenable)
    begin
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
         begin

           if (dwidth_factor == 1) 
            begin
            i_tx_ctrlenable[i * 2] = (number_of_channels > i) ? tx_ctrlenable[i] : 0;
            i_tx_ctrlenable[(i +1) * 2 - 1] = 0;
           end
           if (dwidth_factor == 2)
            begin
            i_tx_ctrlenable[i * 2] = (number_of_channels > i) ? tx_ctrlenable[i * 2] : 0;
            i_tx_ctrlenable[(i +1) * 2 - 1] = (number_of_channels > i) ? tx_ctrlenable[(i+1) * 2 - 1] : 0;
           end
         end

    end
//            i_tx_ctrlenable[(i + 1) * 2 - 1: i * 2] = (number_of_channels > i) ? tx_ctrlenable[(i + 1) * 2 - 1: i * 2] : 0;


    always @(tx_forcedisparity)
    begin
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
         begin

           if (dwidth_factor == 1) 
            begin
            i_tx_forcedisparity[i * 2] = (number_of_channels > i) ? tx_forcedisparity[i] : 0;
            i_tx_forcedisparity[(i +1) * 2 - 1] = 0;
           end
           if (dwidth_factor == 2)
            begin
            i_tx_forcedisparity[i * 2] = (number_of_channels > i) ? tx_forcedisparity[i * 2] : 0;
            i_tx_forcedisparity[(i +1) * 2 - 1] = (number_of_channels > i) ? tx_forcedisparity[(i+1) * 2 - 1] : 0;
           end
         end
    end
    always @(tx_srlpbk)
        for(i=0; i < `HSSI_MAXCDR; i=i+1)
            i_tx_srlpbk[i] = (number_of_channels > i) ? tx_srlpbk[i] : 0;

    always @ (tx_in)
       i_tx_in[channel_width*number_of_channels-1: 0] = tx_in;


    always @(i_tx_in)
    begin
    if (flip_tx_in == "OFF")
       tx_in_int[channel_width*number_of_channels-1: 0] = i_tx_in[channel_width*number_of_channels-1: 0];


    if ((flip_tx_in == "ON") && (channel_width > 10))
    begin
       for(i=0; i < number_of_channels ; i=i+1)
       begin
         channel_pos = i * channel_width;
         for (j=0; j < channel_width_div2; j=j+1) 
          begin
            tx_in_int[channel_pos + j] = i_tx_in[channel_pos + channel_width_div2 - 1 - j];    
            tx_in_int[channel_pos + channel_width_div2  + j] = 
                   i_tx_in[channel_pos + channel_width_div2 + channel_width_div2 - 1 - j];    
          end
        end
    end
    if ((flip_tx_in == "ON") && (channel_width <= 10))
    begin
       for(i=0; i < number_of_channels ; i=i+1)
       begin
         channel_pos = i * channel_width;
         for (j=0; j < channel_width; j=j+1) 
            tx_in_int[channel_pos + j] = i_tx_in[i * channel_width + channel_width - 1 - j];    
       end
    end

        w_tx_in00 =
            tx_in_int[01*channel_width * 4 -1:00*channel_width * 4];

        w_tx_in01 =
            tx_in_int[02*channel_width * 4 -1:01*channel_width * 4];

        w_tx_in02 =
            tx_in_int[03*channel_width * 4 -1:02*channel_width * 4];

        w_tx_in03 =
            tx_in_int[04*channel_width * 4 -1:03*channel_width * 4];

        w_tx_in04 =
            tx_in_int[05*channel_width * 4 -1:04*channel_width * 4];
    end

  // Outputs for Receiver
   always @(w_rx_out00) 
      i_rx_out[rx_channel_width * 4 - 1: 0 * 4 ] = w_rx_out00[rx_channel_width * 4 - 1: 0 * 4 ];


   always @(w_rx_out01)
    i_rx_out[rx_channel_width * 8 - 1 : rx_channel_width *  4 ] = w_rx_out01;

   always @(w_rx_out02)
    i_rx_out[rx_channel_width * 12 - 1: rx_channel_width *  8 ] = w_rx_out02;

   always @(w_rx_out03)
    i_rx_out[rx_channel_width * 16 - 1: rx_channel_width *  12 ] = w_rx_out03;

   always @(w_rx_out04)
    i_rx_out[rx_channel_width * 20 - 1: rx_channel_width *  16 ] = w_rx_out04;


   always @(i_rx_out) 
   begin

    if (flip_rx_out == "OFF")
        t_rx_out             = i_rx_out[rx_channel_width * number_of_channels-1:0];


    if ((flip_rx_out == "ON") && (rx_channel_width > 10))
    begin
       for(i=0; i < number_of_channels ; i=i+1)
       begin
         channel_pos = i * rx_channel_width;
         for (j=0; j < rx_channel_width_div2; j=j+1) 
          begin
            t_rx_out[channel_pos + j] = i_rx_out[channel_pos + rx_channel_width_div2 - 1 - j];    
            t_rx_out[channel_pos + rx_channel_width_div2  + j] = 
                   i_rx_out[channel_pos + rx_channel_width_div2 + rx_channel_width_div2 - 1 - j];    
          end
        end
    end

    if ((flip_rx_out == "ON") && (rx_channel_width <= 10))
    begin
       for(i=0; i < number_of_channels ; i=i+1)
       begin
         channel_pos = i * rx_channel_width;
         for (j=0; j < rx_channel_width; j=j+1) 
            t_rx_out[channel_pos + j] = i_rx_out[i * rx_channel_width + rx_channel_width - 1 - j];    
       end
    end
   end



   assign rx_out             = t_rx_out[rx_channel_width * number_of_channels-1:0];
   assign rx_clkout          = i_rx_clkout[number_of_channels-1:0];
   assign rx_locked          = i_rx_locked[number_of_channels-1:0];
   assign rx_freqlocked      = i_rx_freqlocked[number_of_channels-1:0];
   assign rx_rlv             = i_rx_rlv[number_of_channels-1:0];
   assign rx_signaldetect    = i_rx_signaldetect[number_of_channels-1:0];
   assign rx_fifoempty       = i_rx_fifoempty[number_of_channels-1:0];
   assign rx_fifofull        = i_rx_fifofull[number_of_channels-1:0];
   assign rx_fifoalmostempty = i_rx_fifoalmostempty[number_of_channels-1:0];
   assign rx_fifoalmostfull  = i_rx_fifoalmostfull[number_of_channels-1:0];
   assign rx_bisterr         = i_rx_bisterr[number_of_channels-1:0];
   assign rx_bistdone        = i_rx_bistdone[number_of_channels-1:0];



    always @(i_rx_syncstatus)
    begin
        for(i=0; i < number_of_channels; i=i+1)
         begin

           if (rx_dwidth_factor == 1) 
            begin
            t_rx_syncstatus[i] = i_rx_syncstatus[i*2];
           end
           if (rx_dwidth_factor == 2)
            begin
             t_rx_syncstatus[i*2] = i_rx_syncstatus[i*2];
             t_rx_syncstatus[(i +1) * 2 - 1] = i_rx_syncstatus[(i +1) * 2 - 1];
           end
         end
    end

    always @(i_rx_patterndetect)
    begin
        for(i=0; i < number_of_channels; i=i+1)
         begin

           if (rx_dwidth_factor == 1) 
            begin
             t_rx_patterndetect[i] = i_rx_patterndetect[i*2];
           end
           if (rx_dwidth_factor == 2)
            begin
             t_rx_patterndetect[i*2] = i_rx_patterndetect[i*2];
             t_rx_patterndetect[(i +1) * 2 - 1] = i_rx_patterndetect[(i +1) * 2 - 1];
           end
         end
    end


    always @(i_rx_ctrldetect)
    begin
        for(i=0; i < number_of_channels; i=i+1)
         begin

           if (rx_dwidth_factor == 1) 
            begin
             t_rx_ctrldetect[i] = i_rx_ctrldetect[i*2];
           end
           if (rx_dwidth_factor == 2)
            begin
             t_rx_ctrldetect[i*2] = i_rx_ctrldetect[i*2];
             t_rx_ctrldetect[(i +1) * 2 - 1] = i_rx_ctrldetect[(i +1) * 2 - 1];
           end
         end
    end

    always @(i_rx_errdetect)
    begin
        for(i=0; i < number_of_channels; i=i+1)
         begin

           if (rx_dwidth_factor == 1) 
            begin
             t_rx_errdetect[i] = i_rx_errdetect[i*2];
           end
           if (rx_dwidth_factor == 2)
            begin
             t_rx_errdetect[i*2] = i_rx_errdetect[i*2];
             t_rx_errdetect[(i +1) * 2 - 1] = i_rx_errdetect[(i +1) * 2 - 1];
           end
         end
    end

    always @(i_rx_disperr)
    begin
        for(i=0; i < number_of_channels; i=i+1)
         begin

           if (rx_dwidth_factor == 1) 
            begin
             t_rx_disperr[i] = i_rx_disperr[i*2];
           end
           if (rx_dwidth_factor == 2)
            begin
             t_rx_disperr[i*2] = i_rx_disperr[i*2];
             t_rx_disperr[(i +1) * 2 - 1] = i_rx_disperr[(i +1) * 2 - 1];
           end
         end
    end

    always @(i_rx_a1a2sizeout)
    begin
        for(i=0; i < number_of_channels; i=i+1)
         begin

           if (rx_dwidth_factor == 1) 
            begin
             t_rx_a1a2sizeout[i] = i_rx_a1a2sizeout[i*2];
           end
           if (rx_dwidth_factor == 2)
            begin
             t_rx_a1a2sizeout[i*2] = i_rx_a1a2sizeout[i*2];
             t_rx_a1a2sizeout[(i +1) * 2 - 1] = i_rx_a1a2sizeout[(i +1) * 2 - 1];
           end
         end
    end






  // Outputs for Transmitter
  assign tx_out = w_tx_out[number_of_channels-1:0];

   assign rx_syncstatus    = t_rx_syncstatus[rx_dwidth_factor * number_of_channels-1:0];
   assign rx_patterndetect = t_rx_patterndetect[rx_dwidth_factor * number_of_channels-1:0];
   assign rx_ctrldetect    = t_rx_ctrldetect[rx_dwidth_factor * number_of_channels-1:0];
   assign rx_errdetect     = t_rx_errdetect[rx_dwidth_factor * number_of_channels-1:0];
   assign rx_disperr       = t_rx_disperr[rx_dwidth_factor * number_of_channels-1:0];
   assign rx_a1a2sizeout   = t_rx_a1a2sizeout[rx_dwidth_factor * number_of_channels-1:0];




 // Outputs For PLL Clock
   assign pll_locked = i_pll_locked[number_of_quads-1:0];
   assign coreclk_out = i_coreclk_out[number_of_quads-1:0];
   assign rx_channelaligned = i_rx_channelaligned[number_of_quads-1:0];

endmodule

`timescale 1 ps / 1 ps

module hssi_quad (
               inclk, 
               pll_areset, 
               rx_cruclk, 
               rx_coreclk, 
               rx_in, 
               rx_bitslip,                
               rx_enacdet, 
               rx_we, 
               rx_re, 
               rx_slpbk, 
               rx_a1a2size, 
               rx_equalizerctrl, 
               rx_locktorefclk, 
               rx_locktodata,
               tx_in,
               tx_coreclk, 
               tx_ctrlenable, 
               tx_forcedisparity, 
               tx_srlpbk, 
               tx_vodctrl,                
               tx_preemphasisctrl,
               txdigitalreset, 
               rxdigitalreset, 
               rxanalogreset, 
               pllenable,
               pll_locked, 
               coreclk_out, 
               rx_out, 
               rx_clkout, 
               rx_locked, 
               rx_freqlocked, 
               rx_rlv, 
               rx_syncstatus,
               rx_patterndetect, 
               rx_ctrldetect, 
               rx_errdetect, 
               rx_disperr, 
               rx_signaldetect,
               rx_fifoempty, 
               rx_fifofull, 
               rx_fifoalmostempty, 
               rx_fifoalmostfull,                
               rx_channelaligned,
               rx_bisterr, 
               rx_bistdone, 
               rx_a1a2sizeout,
               tx_out);
    
               
    parameter operation_mode = "DUPLEX";     // Other modes- "RX", "TX", "DUPLEX"
    parameter loopback_mode = "NONE"; // "SLB", "RSLB", "PLB", "RPLB", "P8LB"
    parameter reverse_loopback_mode = "NONE";

    parameter protocol  = "NONE";     // Other protocols -  "GIGE", "INFINIBAND", "RAPIDIO", "FIBRECHANNEL"
    parameter protocol_to_mode  = "NONE";     // Other protocols -  "GIGE", "INFINIBAND", "RAPIDIO", "FIBRECHANNEL"
    parameter tx_transmit_protocol = "NONE";
    parameter number_of_channels = 4;
    parameter channel_width = 20;
    parameter pll_inclock_period = 20000;       // 20000ps = 50MHz
    parameter data_rate = 10;  // May be unused
    parameter c_use_8b_10b_mode = "OFF";
    parameter c_use_double_data_mode = "OFF";
    parameter rx_use_double_data_mode = "OFF";

    parameter c_disparity_mode = "OFF";
    parameter c_force_disparity_mode = "OFF";
    parameter cru_inclock_period = 0;

     // RX mode
    parameter run_length = 128;              
    parameter run_length_enable = "OFF";              
    parameter c_use_channel_align = "OFF";
    parameter c_use_auto_bit_slip  = "ON";
    parameter c_use_rate_match_fifo = "ON";
    parameter c_use_symbol_align = "ON";
    parameter align_pattern = "";
    parameter align_pattern_length = 0;
    parameter infiniband_invalid_code = 0; 
    parameter c_clk_out_mode_reference = "ON";
    // TX mode
    parameter c_use_fifo_mode = "ON";
    parameter intended_device_family = "ALTGXB";
    parameter deserialization_factor = 8;
    parameter pll_mult_value = 1;
    parameter pllclk2_divisor = 2;
    parameter cruclk_mult = 0;
    parameter cruclk_div = "";
    parameter pllclk_mult = 1;
    parameter pllclk0_div = 1;
    parameter pllclk_div_adj = 1;

    // Quartus 2.2 new parameters
    // common
    parameter use_self_test_mode = "OFF";
    parameter self_test_mode = 0;
    
    // Receiver
    parameter use_equalizer_ctrl_signal = "OFF";
    parameter equalizer_ctrl_setting = 0;
    parameter signal_threshold_select  = 80;
    parameter rx_bandwidth_type = "NEW_MEDIUM";
    parameter rx_enable_dc_coupling = "OFF";
    parameter use_vod_ctrl_signal = "OFF";
    parameter vod_ctrl_setting = 1000;
    parameter use_preemphasis_ctrl_signal = "OFF";
    parameter preemphasis_ctrl_setting = 0;
    parameter use_phase_shift = "ON";
    parameter pll_bandwidth_type = "LOW";
    parameter pll_use_dc_coupling = "OFF";
    parameter rx_ppm_setting = 1000;
    parameter device_family = "";
    parameter use_rx_cruclk = "OFF";
    parameter use_rx_clkout = "OFF";
    parameter use_rx_coreclk   = "OFF";
    parameter use_tx_coreclk   = "OFF";
    parameter instantiate_transmitter_pll = "OFF";
    parameter consider_instantiate_transmitter_pll_param = "OFF";
    parameter use_generic_fifo = "OFF";
    parameter flip_rx_out = "OFF";
    parameter flip_tx_in = "OFF";
    parameter add_generic_fifo_we_synch_register = "OFF";

    parameter rx_channel_width = channel_width;
    parameter rx_dwidth_factor    = 2;
    parameter for_engineering_sample_device = "ON"; // new in 3.0 sp2

    // 2.2 Settings
    parameter c_use_parallel_feedback =  (loopback_mode  == "PLB")?"ON":"OFF";
    parameter c_use_post8b10b_feedback =  (loopback_mode  == "P8LB")?"ON":"OFF";
    parameter c_send_reverse_parallel_feedback =  (reverse_loopback_mode  == "RPLB")?"ON":"OFF";
    parameter c_use_reverse_parallel_feedback = (reverse_loopback_mode  == "RPLB")?"ON":"OFF";
    parameter mode_is_xaui = (protocol == "XAUI")?"ON":"OFF";

    // Phase shift usage
    parameter pllclk_mult_temp = (pllclk_mult == 0) ? 1 : pllclk_mult;
    parameter pllclk0_period   =  (1.0 * pll_inclock_period * pllclk0_div/pllclk_mult_temp) 
                                     + 0.5;
    parameter pllclk1_period   =  (1.0 * pll_inclock_period * deserialization_factor/ (pllclk_div_adj * pllclk_mult_temp)+ 0.5);

    parameter t_pll_phase_shift_0 = (use_phase_shift == "ON")?
               (((1.0 * pll_inclock_period * pllclk0_div/pllclk_mult_temp) + 0.5)/2.0):0.0;
    parameter t_pll_phase_shift_1 = (use_phase_shift == "ON")?
         ( (7.0 * pll_inclock_period * pllclk0_div/pllclk_mult_temp)/4.0 + 
           (1.0 * pll_inclock_period * deserialization_factor)/(pllclk_div_adj *             
             pllclk_mult_temp)/2.0 + 0.5):0.0;
    parameter t_pll_phase_shift_2 = (use_phase_shift == "ON")?t_pll_phase_shift_1:0.0;

    parameter pll_phase_shift_0 = t_pll_phase_shift_0 * 100/100;
    parameter pll_phase_shift_1 = t_pll_phase_shift_1 * 100/100;

    parameter pll_phase_shift_2 = t_pll_phase_shift_2* 100/100;







    // Common input ports for Rx and Tx mode
    input inclk;
    input pll_areset; // tri0
    input [number_of_channels-1:0] rx_coreclk;


    // Input ports for RX mode
    input rx_cruclk;
    input [number_of_channels-1:0] rx_in;

    input [number_of_channels-1:0] rx_bitslip;
    input [number_of_channels-1:0] rx_enacdet;
    input [number_of_channels-1:0] rx_we;
    input [number_of_channels-1:0] rx_re;
    input [number_of_channels-1:0] rx_slpbk;

    input [number_of_channels-1:0]   rx_a1a2size;
    input [number_of_channels * 3 -1:0] rx_equalizerctrl;
    input [number_of_channels-1:0]   rx_locktorefclk;
    input [number_of_channels-1:0]   rx_locktodata;


    // XGM Input ports, common for Both Rx and Tx Mode

    input [3:0] txdigitalreset;
    input [3:0] rxdigitalreset;
    input [3:0] rxanalogreset;
    input pllenable;





    // Input ports for TX mode
    input [channel_width * number_of_channels-1:0] tx_in;
    input [number_of_channels-1:0] tx_coreclk;


    input [2 * number_of_channels-1:0] tx_ctrlenable;
    input [2 * number_of_channels-1:0] tx_forcedisparity;
    input [number_of_channels-1:0] tx_srlpbk;


    input [number_of_channels * 3 -1:0] tx_vodctrl;
    input [number_of_channels * 3 -1:0] tx_preemphasisctrl;


    // Common output ports for RX and TX mode
    output pll_locked;
    output coreclk_out;

   // Output ports for RX mode
    output [rx_channel_width*number_of_channels-1:0] rx_out;
    output [number_of_channels-1:0] rx_clkout;
    output [number_of_channels-1:0] rx_locked;
    output [number_of_channels-1:0] rx_freqlocked;
    output [number_of_channels-1:0] rx_rlv;

    output [2 * number_of_channels-1:0] rx_syncstatus;
    output [2 * number_of_channels-1:0] rx_patterndetect;
    output [2 * number_of_channels-1:0] rx_ctrldetect;
    output [2 * number_of_channels-1:0] rx_errdetect;
    output [2 * number_of_channels-1:0] rx_disperr;

    output [number_of_channels-1:0] rx_signaldetect;
    output [number_of_channels-1:0] rx_fifoempty;
    output [number_of_channels-1:0] rx_fifofull;
    output [number_of_channels-1:0] rx_fifoalmostempty;
    output [number_of_channels-1:0] rx_fifoalmostfull;
    output rx_channelaligned;
    output [number_of_channels-1:0] rx_bisterr;
    output [number_of_channels-1:0] rx_bistdone;
    output [2 * number_of_channels-1:0] rx_a1a2sizeout;

   // Output ports for TX mode
    output [number_of_channels-1:0] tx_out;

 
    // Variables  for Receivers

    wire w_rx_inclk0;
    reg   [rx_channel_width* 4 -1:0] i_rx_out;
    reg   [rx_channel_width* 4 -1:0] i_w_rx_out;

    // Variables  for Transmitters

    wire  [`HSSI_MAXCDR-1:0] w_tx_out;

    wire  [`HSSI_MAXCWIDTH - 1:0] w_rx_out00;
    wire  [`HSSI_MAXCWIDTH - 1:0] w_rx_out01;
    wire  [`HSSI_MAXCWIDTH - 1:0] w_rx_out02;
    wire  [`HSSI_MAXCWIDTH - 1:0] w_rx_out03;



    reg  [`HSSI_MAXCWIDTH  -1:0] w_tx_in00;
    reg  [`HSSI_MAXCWIDTH  -1:0] w_tx_in01;
    reg  [`HSSI_MAXCWIDTH  -1:0] w_tx_in02;
    reg  [`HSSI_MAXCWIDTH  -1:0] w_tx_in03;

    wire [9:0] w_parallelfdbkdata00;
    wire [9:0] w_parallelfdbkdata01;
    wire [9:0] w_parallelfdbkdata02;
    wire [9:0] w_parallelfdbkdata03;

    wire [9:0] w_pre8b10bdata00;
    wire [9:0] w_pre8b10bdata01;
    wire [9:0] w_pre8b10bdata02;
    wire [9:0] w_pre8b10bdata03;
    wire i_pllaresetout;
    wire [3:0] t_rx_we;
    reg  [3:0] i_rx_we;
    wire [3:0] i_sync_rx;
  


    // Variables for XGM State Machines





    wire  [3:0] i_rx_syncstatusdeskew;
    wire  [3:0] i_rx_adetectdeskew;



    wire [31:0] i_xgm_txdatain;
    wire [3:0]  i_xgm_txctrl;
    wire tx00_rd_enable_sync;

    wire [31:0] i_xgm_rxdatain;
    wire [3:0]  i_xgm_rxctrl;
    wire [3:0]  i_xgm_rxrunningdisp;
    wire [3:0]  i_xgm_rx_data_valid_in;
    wire [3:0]  i_xgm_adet;
    wire [3:0]  i_xgm_syncstatus_deskew;
    wire [3:0]  i_xgm_rdalign;

    wire [31:0] i_xgm_txdataout;
   

    wire [3:0] i_xgm_txctrlout;


    wire channels_are_aligned;
    wire enable_deskew_fifo;
    wire recovered_clk0;
    wire reset_deskew_fifo;

    wire [31:0] i_xgm_rxdataout;
    wire [3:0]  i_xgm_rxctrlout;
 // Variables for PLL Clock

//    wire  [i_pll_locked;
    // Signals used for controlling the rate matching fifos
    wire fifo_rd_out0;
    wire disable_fifo_rd_out0;
    wire disable_fifo_wr_out0;

    integer i;
    wire slow_pll_clk, fast_pll_clk;
    wire [2:0] temp_clk;
    reg temp_inclk;
    reg i_cruclk;
    reg  [3:0] i_rx_coreclk;   
    reg  [3:0] i_tx_coreclk;   


    wire [3:0] i_txdigitalresetout;
    wire [3:0]i_rxdigitalresetout;
    wire [3:0]i_txanalogresetout;
    wire [3:0]i_rxanalogresetout;
    wire i_pllresetout;

   specify
      
   endspecify
   
   initial
      begin

      if (operation_mode == "RX")
       begin
       end
      if (operation_mode == "TX")
       begin
       end
      if (operation_mode == "DUPLEX")
       begin
       end
       temp_inclk = 1'b0;

      end
                                                   
    altgxb_dffe we_synch_rx0_a (.D(rx_we[0]),
                         .CLRN(1'b1),
                         .PRN(1'b1),
                         .ENA(1'b1),
                         .CLK(i_rx_coreclk[0]),
                         .Q(i_sync_rx[0])
                   );


    altgxb_dffe we_synch_rx0_b (.D(i_sync_rx[0]),
                         .CLRN(1'b1),
                         .PRN(1'b1),
                         .ENA(1'b1),
                         .CLK(i_rx_coreclk[0]),
                         .Q(t_rx_we[0])
                   );



                                                   
    altgxb_dffe we_synch_rx1_a (.D(rx_we[1]),
                         .CLRN(1'b1),
                         .PRN(1'b1),
                         .ENA(1'b1),
                         .CLK(i_rx_coreclk[1]),
                         .Q(i_sync_rx[1])
                   );


    altgxb_dffe we_synch_rx1_b (.D(i_sync_rx[1]),
                         .CLRN(1'b1),
                         .PRN(1'b1),
                         .ENA(1'b1),
                         .CLK(i_rx_coreclk[1]),
                         .Q(t_rx_we[1])
                   );


                                                   
    altgxb_dffe we_synch_rx2_a (.D(rx_we[2]),
                         .CLRN(1'b1),
                         .PRN(1'b1),
                         .ENA(1'b1),
                         .CLK(i_rx_coreclk[2]),
                         .Q(i_sync_rx[2])
                   );


    altgxb_dffe we_synch_rx2_b (.D(i_sync_rx[2]),
                         .CLRN(1'b1),
                         .PRN(1'b1),
                         .ENA(1'b1),
                         .CLK(i_rx_coreclk[2]),
                         .Q(t_rx_we[2])
                   );




                                                   
    altgxb_dffe we_synch_rx3_a (.D(rx_we[3]),
                         .CLRN(1'b1),
                         .PRN(1'b1),
                         .ENA(1'b1),
                         .CLK(i_rx_coreclk[3]),
                         .Q(i_sync_rx[3])
                   );


    altgxb_dffe we_synch_rx3_b (.D(i_sync_rx[3]),
                         .CLRN(1'b1),
                         .PRN(1'b1),
                         .ENA(1'b1),
                         .CLK(i_rx_coreclk[3]),
                         .Q(t_rx_we[3])
                   );







     altgxb_hssi_receiver rx00 ( 
                             // General Input
                            .datain(rx_in[0]), 
                            .cruclk(i_cruclk), 
                            .pllclk(slow_pll_clk), 
                            .coreclk(i_rx_coreclk[0]),
                            .softreset(i_rxdigitalresetout[0]),
                            .analogreset(i_rxanalogresetout[0]),
                            .serialfdbk(w_tx_out[0]), 
                            .slpbk(rx_slpbk[0]), 
                            .parallelfdbk(w_parallelfdbkdata00),

                            .post8b10b(w_pre8b10bdata00),

                            .bitslip(rx_bitslip[0]), 
                            .enacdet(rx_enacdet[0]), 
                            .we(i_rx_we[0]), 
                            .re(rx_re[0]), 
                            .devclrn(1'b1), 
                            .devpor(1'b1),
                            // Input from RX 0                                                    
                            .masterclk(recovered_clk0), 
                            .alignstatus(channels_are_aligned),
                            .disablefifordin(disable_fifo_rd_out0), 
                            .disablefifowrin(disable_fifo_wr_out0), 
                            .fifordin(fifo_rd_out0),

                            // Input from XGM/Deskew SM
                            .enabledeskew(enable_deskew_fifo),
                            .fiforesetrd(reset_deskew_fifo),
                            .xgmdatain(i_xgm_rxdataout[7:0]), 
                            .xgmctrlin(i_xgm_rxctrlout[0]),

                            // General Outputs 
                            .dataout(w_rx_out00),
                            .syncstatus(rx_syncstatus[1:0]), 
                            .patterndetect(rx_patterndetect[1:0]),
                            .ctrldetect(rx_ctrldetect[1:0]), 

                            .errdetect(rx_errdetect[1:0]),
                            .disperr(rx_disperr[1:0]), 
                            .fifofull(rx_fifofull[0]), 
                            .fifoalmostfull(rx_fifoalmostfull[0]),
                            .fifoempty(rx_fifoempty[0]), 
                            .fifoalmostempty(rx_fifoalmostempty[0]),
                            .signaldetect(rx_signaldetect[0]), 
                            .lock(rx_locked[0]), 
                            .freqlock(rx_freqlocked[0]),
                            .clkout(rx_clkout[0]), 
                            .rlv(rx_rlv[0]), 

                            // 2.2 Input ports
                            .a1a2size(rx_a1a2size[0]),
                            .equalizerctrl(rx_equalizerctrl[2:0]),
                            .locktorefclk(rx_locktorefclk[0]),
                            .locktodata(rx_locktodata[0]),




                            // 2.2 Output ports
                            .bisterr(rx_bisterr[0]), 
                            .bistdone(rx_bistdone[0]), 
                            .a1a2sizeout(rx_a1a2sizeout[1:0]), 
                            

                            // Outputs to XGM/Deskew SM                          
                            .adetectdeskew(i_xgm_adet[0]), 
                            .rdalign(i_xgm_rdalign[0]),
                            .xgmdataout(i_xgm_rxdatain[7:0]),
                            .xgmctrldet(i_xgm_rxctrl[0]),
                            .xgmrunningdisp(i_xgm_rxrunningdisp[0]),
                            .xgmdatavalid(i_xgm_rx_data_valid_in[0]),
                            .syncstatusdeskew(i_xgm_syncstatus_deskew[0]),
                            // outputs to other RX's
                            .fifordout(fifo_rd_out0),
                            .disablefifowrout(disable_fifo_wr_out0),
                            .disablefifordout(disable_fifo_rd_out0),
                            .recovclkout(recovered_clk0)
                          
                            );

                          defparam
                            rx00.channel_num             = 0,
                            rx00.channel_width           = rx_channel_width,
                            rx00.run_length              = run_length,
                            rx00.run_length_enable       = run_length_enable,
                            rx00.use_8b_10b_mode         = c_use_8b_10b_mode,
                            rx00.use_double_data_mode    = rx_use_double_data_mode,
                            rx00.use_rate_match_fifo     = c_use_rate_match_fifo,
                            rx00.rate_matching_fifo_mode = protocol_to_mode,
                            rx00.deserialization_factor  = deserialization_factor,
                            rx00.synchronization_mode    = protocol_to_mode,
                            rx00.use_channel_align       = c_use_channel_align,
                            rx00.use_symbol_align        = c_use_symbol_align,
                            rx00.use_auto_bit_slip       = c_use_auto_bit_slip,
                            rx00.align_pattern           = align_pattern,
                            rx00.align_pattern_length    = align_pattern_length,
                            rx00.infiniband_invalid_code = infiniband_invalid_code,
                            rx00.disparity_mode          = c_disparity_mode,
                            rx00.cruclk_period           = cru_inclock_period,
                            rx00.clk_out_mode_reference  = c_clk_out_mode_reference,
                            rx00.cruclk_multiplier       = cruclk_mult,
                            rx00.use_cruclk_divider      = cruclk_div,
                            rx00.use_self_test_mode      = use_self_test_mode,
                            rx00.self_test_mode          = self_test_mode,
                            rx00.use_parallel_feedback   = c_use_parallel_feedback,
                            rx00.use_post8b10b_feedback  = c_use_post8b10b_feedback,
                            rx00.send_reverse_parallel_feedback  = c_send_reverse_parallel_feedback,
                            rx00.use_equalizer_ctrl_signal  = use_equalizer_ctrl_signal,
                            rx00.equalizer_ctrl_setting  = equalizer_ctrl_setting,
                            rx00.bandwidth_type = rx_bandwidth_type,
                            rx00.enable_dc_coupling = rx_enable_dc_coupling,
                            rx00.for_engineering_sample_device = for_engineering_sample_device;



         






     altgxb_hssi_receiver rx01 ( 
                             // General Input
                            .datain(rx_in[1]), 
                            .cruclk(i_cruclk), 
                            .pllclk(slow_pll_clk), 
                            .coreclk(i_rx_coreclk[1]),
                            .softreset(i_rxdigitalresetout[1]),
                            .analogreset(i_rxanalogresetout[1]),
                            .serialfdbk(w_tx_out[1]), 
                            .slpbk(rx_slpbk[1]), 
                            .parallelfdbk(w_parallelfdbkdata01),
                            .post8b10b(w_pre8b10bdata01),
                            .bitslip(rx_bitslip[1]), 
                            .enacdet(rx_enacdet[1]), 
                            .we(i_rx_we[1]), 
                            .re(rx_re[1]), 
                            .devclrn(1'b1), 
                            .devpor(1'b1),
                            // Input from RX 0                                                    
                            .masterclk(recovered_clk0), 
                            .alignstatus(channels_are_aligned),
                            .disablefifordin(disable_fifo_rd_out0), 
                            .disablefifowrin(disable_fifo_wr_out0), 
                            .fifordin(fifo_rd_out0),

                            // Input from XGM/Deskew SM
                            .enabledeskew(enable_deskew_fifo),
                            .fiforesetrd(reset_deskew_fifo),
                            .xgmdatain(i_xgm_rxdataout[15:8]), 
                            .xgmctrlin(i_xgm_rxctrlout[1]),

                            // General Outputs 
                            .dataout(w_rx_out01),
                            .syncstatus(rx_syncstatus[3:2]), 
                            .patterndetect(rx_patterndetect[3:2]),
                            .ctrldetect(rx_ctrldetect[3:2]), 
                            .errdetect(rx_errdetect[3:2]),
                            .disperr(rx_disperr[3:2]), 
                            .fifofull(rx_fifofull[1]), 
                            .fifoalmostfull(rx_fifoalmostfull[1]),
                            .fifoempty(rx_fifoempty[1]), 
                            .fifoalmostempty(rx_fifoalmostempty[1]),
                            .signaldetect(rx_signaldetect[1]), 
                            .lock(rx_locked[1]), 
                            .freqlock(rx_freqlocked[1]),
                            .clkout(rx_clkout[1]), 
                            .rlv(rx_rlv[1]), 

                            // 2.2 Input ports
                            .a1a2size(rx_a1a2size[1]),
                            .equalizerctrl(rx_equalizerctrl[5:3]),
                            .locktorefclk(rx_locktorefclk[1]),
                            .locktodata(rx_locktodata[1]),

                            // 2.2 Output ports
                            .bisterr(rx_bisterr[1]), 
                            .bistdone(rx_bistdone[1]), 
                            .a1a2sizeout(rx_a1a2sizeout[3:2]), 

                            // Outputs to XGM/Deskew SM                          
                            .adetectdeskew(i_xgm_adet[1]), 
                            .rdalign(i_xgm_rdalign[1]),
                            .xgmdataout(i_xgm_rxdatain[15:8]),
                            .xgmctrldet(i_xgm_rxctrl[1]),
                            .xgmrunningdisp(i_xgm_rxrunningdisp[1]),
                            .xgmdatavalid(i_xgm_rx_data_valid_in[1]),
                            .syncstatusdeskew(i_xgm_syncstatus_deskew[1]),
                             // outputs to other RX's
                            .fifordout(),
                            .disablefifowrout(),
                            .disablefifordout(),
                            .recovclkout()
                          
                            );

                          defparam
                            rx01.channel_num             = 1,
                            rx01.channel_width           = rx_channel_width,
                            rx01.run_length              = run_length,
                            rx01.run_length_enable       = run_length_enable,
                            rx01.use_8b_10b_mode         = c_use_8b_10b_mode,
                            rx01.use_double_data_mode    = rx_use_double_data_mode,
                            rx01.use_rate_match_fifo     = c_use_rate_match_fifo,
                            rx01.rate_matching_fifo_mode = protocol_to_mode,
                            rx01.synchronization_mode    = protocol_to_mode,
                            rx01.deserialization_factor  = deserialization_factor,
                            rx01.use_channel_align       = c_use_channel_align,
                            rx01.use_symbol_align        = c_use_symbol_align,
                            rx01.use_auto_bit_slip       = c_use_auto_bit_slip,
                            rx01.align_pattern           = align_pattern,
                            rx01.align_pattern_length    = align_pattern_length,
                            rx01.infiniband_invalid_code = infiniband_invalid_code,
                            rx01.disparity_mode          = c_disparity_mode,
                            rx01.cruclk_period            = cru_inclock_period,
                            rx01.clk_out_mode_reference  = c_clk_out_mode_reference,
                            rx01.cruclk_multiplier = cruclk_mult,
                            rx01.use_cruclk_divider      = cruclk_div,
                            rx01.use_self_test_mode      = use_self_test_mode,
                            rx01.self_test_mode          = self_test_mode,
                            rx01.use_parallel_feedback   = c_use_parallel_feedback,
                            rx01.use_post8b10b_feedback  = c_use_post8b10b_feedback,
                            rx01.send_reverse_parallel_feedback  = c_send_reverse_parallel_feedback,
                            rx01.use_equalizer_ctrl_signal  = use_equalizer_ctrl_signal,
                            rx01.equalizer_ctrl_setting  = equalizer_ctrl_setting,
                            rx01.bandwidth_type = rx_bandwidth_type,
                            rx01.enable_dc_coupling = rx_enable_dc_coupling,
                            rx01.for_engineering_sample_device = for_engineering_sample_device;

            


     altgxb_hssi_receiver rx02 ( 
                             // General Input
                            .datain(rx_in[2]), 
                            .cruclk(i_cruclk), 
                            .pllclk(slow_pll_clk), 
                            .coreclk(i_rx_coreclk[2]),
                            .softreset(i_rxdigitalresetout[2]),
                            .analogreset(i_rxanalogresetout[2]),
                            .serialfdbk(w_tx_out[2]), 
                            .slpbk(rx_slpbk[2]), 
                            .parallelfdbk(w_parallelfdbkdata02),
                            .post8b10b(w_pre8b10bdata02),
                            .bitslip(rx_bitslip[2]), 
                            .enacdet(rx_enacdet[2]), 
                            .we(i_rx_we[2]), 
                            .re(rx_re[2]), 
                            .devclrn(1'b1), 
                            .devpor(1'b1),
                            // Input from RX 0                                                    
                            .masterclk(recovered_clk0), 
                            .alignstatus(channels_are_aligned),
                            .disablefifordin(disable_fifo_rd_out0), 
                            .disablefifowrin(disable_fifo_wr_out0), 
                            .fifordin(fifo_rd_out0),

                            // Input from XGM/Deskew SM
                            .enabledeskew(enable_deskew_fifo),
                            .fiforesetrd(reset_deskew_fifo),
                            .xgmdatain(i_xgm_rxdataout[23:16]), 
                            .xgmctrlin(i_xgm_rxctrlout[2]),

                            // General Outputs 
                            .dataout(w_rx_out02),
                            .syncstatus(rx_syncstatus[5:4]), 
                            .patterndetect(rx_patterndetect[5:4]),
                            .ctrldetect(rx_ctrldetect[5:4]), 
                            .errdetect(rx_errdetect[5:4]),
                            .disperr(rx_disperr[5:4]), 
                            .fifofull(rx_fifofull[2]), 
                            .fifoalmostfull(rx_fifoalmostfull[2]),
                            .fifoempty(rx_fifoempty[2]), 
                            .fifoalmostempty(rx_fifoalmostempty[2]),
                            .signaldetect(rx_signaldetect[2]), 
                            .lock(rx_locked[2]), 
                            .freqlock(rx_freqlocked[2]),
                            .clkout(rx_clkout[2]), 
                            .rlv(rx_rlv[2]), 

                            // 2.2 Input ports
                            .a1a2size(rx_a1a2size[2]),
                            .equalizerctrl(rx_equalizerctrl[8:6]),
                            .locktorefclk(rx_locktorefclk[2]),
                            .locktodata(rx_locktodata[2]),


                            // 2.2 Output ports
                            .bisterr(rx_bisterr[2]), 
                            .bistdone(rx_bistdone[2]), 
                            .a1a2sizeout(rx_a1a2sizeout[5:4]), 

                            // Outputs to XGM/Deskew SM                          
                            .adetectdeskew(i_xgm_adet[2]), 
                            .rdalign(i_xgm_rdalign[2]),
                            .xgmdataout(i_xgm_rxdatain[23:16]),
                            .xgmctrldet(i_xgm_rxctrl[2]),
                            .xgmrunningdisp(i_xgm_rxrunningdisp[2]),
                            .xgmdatavalid(i_xgm_rx_data_valid_in[2]),
                            .syncstatusdeskew(i_xgm_syncstatus_deskew[2]),
                            // outputs to other RX's
                            .fifordout(),
                            .disablefifowrout(),
                            .disablefifordout(),
                            .recovclkout()
                          
                            );

                          defparam
                            rx02.channel_num             = 2,
                            rx02.channel_width           = rx_channel_width,
                            rx02.run_length              = run_length,
                            rx02.run_length_enable       = run_length_enable,
                            rx02.use_8b_10b_mode         = c_use_8b_10b_mode,
                            rx02.use_double_data_mode    = rx_use_double_data_mode,
                            rx02.use_rate_match_fifo     = c_use_rate_match_fifo,
                            rx02.rate_matching_fifo_mode = protocol_to_mode,
                            rx02.synchronization_mode    = protocol_to_mode,
                            rx02.deserialization_factor  = deserialization_factor,
                            rx02.use_channel_align       = c_use_channel_align,
                            rx02.use_symbol_align        = c_use_symbol_align,
                            rx02.use_auto_bit_slip       = c_use_auto_bit_slip,
                            rx02.align_pattern           = align_pattern,
                            rx02.align_pattern_length    = align_pattern_length,
                            rx02.infiniband_invalid_code = infiniband_invalid_code,
                            rx02.disparity_mode          = c_disparity_mode,
                            rx02.cruclk_period            = cru_inclock_period,
                            rx02.clk_out_mode_reference  = c_clk_out_mode_reference,
                            rx02.cruclk_multiplier = cruclk_mult,
                            rx02.use_cruclk_divider      = cruclk_div,
                            rx02.use_self_test_mode      = use_self_test_mode,
                            rx02.self_test_mode          = self_test_mode,
                            rx02.use_parallel_feedback   = c_use_parallel_feedback,
                            rx02.use_post8b10b_feedback  = c_use_post8b10b_feedback,
                            rx02.send_reverse_parallel_feedback  = c_send_reverse_parallel_feedback,
                            rx02.use_equalizer_ctrl_signal  = use_equalizer_ctrl_signal,
                            rx02.equalizer_ctrl_setting  = equalizer_ctrl_setting,
                            rx02.bandwidth_type = rx_bandwidth_type,
                            rx02.enable_dc_coupling = rx_enable_dc_coupling,
                            rx02.for_engineering_sample_device = for_engineering_sample_device;
            


     altgxb_hssi_receiver rx03 ( 
                             // General Input
                            .datain(rx_in[3]), 
                            .cruclk(i_cruclk), 
                            .pllclk(slow_pll_clk), 
                            .coreclk(i_rx_coreclk[3]),
                            .softreset(i_rxdigitalresetout[3]),
                            .analogreset(i_rxanalogresetout[3]),
                            .serialfdbk(w_tx_out[3]), 
                            .slpbk(rx_slpbk[3]), 
                            .parallelfdbk(w_parallelfdbkdata03),
                            .post8b10b(w_pre8b10bdata03),
                            .bitslip(rx_bitslip[3]), 
                            .enacdet(rx_enacdet[3]), 
                            .we(i_rx_we[3]), 
                            .re(rx_re[3]), 
                            .devclrn(1'b1), 
                            .devpor(1'b1),
                            // Input from RX 0                                                    
                            .masterclk(recovered_clk0), 
                            .alignstatus(channels_are_aligned),
                            .disablefifordin(disable_fifo_rd_out0), 
                            .disablefifowrin(disable_fifo_wr_out0), 
                            .fifordin(fifo_rd_out0),

                            // Input from XGM/Deskew SM
                            .enabledeskew(enable_deskew_fifo),
                            .fiforesetrd(reset_deskew_fifo),
                            .xgmdatain(i_xgm_rxdataout[31:24]), 
                            .xgmctrlin(i_xgm_rxctrlout[3]),

                            // General Outputs 
                            .dataout(w_rx_out03),
                            .syncstatus(rx_syncstatus[7:6]), 
                            .patterndetect(rx_patterndetect[7:6]),
                            .ctrldetect(rx_ctrldetect[7:6]),
                            .errdetect(rx_errdetect[7:6]),
                            .disperr(rx_disperr[7:6]), 



                            .fifofull(rx_fifofull[3]), 
                            .fifoalmostfull(rx_fifoalmostfull[3]),
                            .fifoempty(rx_fifoempty[3]), 
                            .fifoalmostempty(rx_fifoalmostempty[3]),
                            .signaldetect(rx_signaldetect[3]), 
                            .lock(rx_locked[3]), 
                            .freqlock(rx_freqlocked[3]),
                            .clkout(rx_clkout[3]), 
                            .rlv(rx_rlv[3]), 

                            // 2.2 Input ports
                            .a1a2size(rx_a1a2size[3]),
                            .equalizerctrl(rx_equalizerctrl[11:9]),
                            .locktorefclk(rx_locktorefclk[3]),
                            .locktodata(rx_locktodata[3]),

                            // 2.2 Output ports
                            .bisterr(rx_bisterr[3]), 
                            .bistdone(rx_bistdone[3]), 
                            .a1a2sizeout(rx_a1a2sizeout[7:6]), 

                            // Outputs to XGM/Deskew SM                          
                            .adetectdeskew(i_xgm_adet[3]), 
                            .rdalign(i_xgm_rdalign[3]),
                            .xgmdataout(i_xgm_rxdatain[31:24]),
                            .xgmctrldet(i_xgm_rxctrl[3]),
                            .xgmrunningdisp(i_xgm_rxrunningdisp[3]),
                            .xgmdatavalid(i_xgm_rx_data_valid_in[3]),
                            .syncstatusdeskew(i_xgm_syncstatus_deskew[3]),
                            // outputs to other RX's
                            .fifordout(),
                            .disablefifowrout(),
                            .disablefifordout(),
                            .recovclkout()
                          
                            );

                          defparam
                            rx03.channel_num             = 3,
                            rx03.channel_width           = rx_channel_width,
                            rx03.run_length              = run_length,
                            rx03.run_length_enable       = run_length_enable,
                            rx03.use_8b_10b_mode         = c_use_8b_10b_mode,
                            rx03.use_double_data_mode    = rx_use_double_data_mode,
                            rx03.use_rate_match_fifo     = c_use_rate_match_fifo,
                            rx03.rate_matching_fifo_mode = protocol_to_mode,
                            rx03.synchronization_mode    = protocol_to_mode,
                            rx03.deserialization_factor  = deserialization_factor,
                            rx03.use_channel_align       = c_use_channel_align,
                            rx03.use_symbol_align        = c_use_symbol_align,
                            rx03.use_auto_bit_slip       = c_use_auto_bit_slip,
                            rx03.align_pattern           = align_pattern,
                            rx03.align_pattern_length    = align_pattern_length,
                            rx03.infiniband_invalid_code = infiniband_invalid_code,
                            rx03.disparity_mode          = c_disparity_mode,
                            rx03.cruclk_period           = cru_inclock_period,
                            rx03.clk_out_mode_reference  = c_clk_out_mode_reference,
                            rx03.cruclk_multiplier = cruclk_mult,
                            rx03.use_cruclk_divider      = cruclk_div,
                            rx03.use_self_test_mode      = use_self_test_mode,
                            rx03.self_test_mode          = self_test_mode,
                            rx03.use_parallel_feedback   = c_use_parallel_feedback,
                            rx03.use_post8b10b_feedback  = c_use_post8b10b_feedback,
                            rx03.send_reverse_parallel_feedback  = c_send_reverse_parallel_feedback,
                            rx03.use_equalizer_ctrl_signal  = use_equalizer_ctrl_signal,
                            rx03.equalizer_ctrl_setting  = equalizer_ctrl_setting,
                            rx03.bandwidth_type = rx_bandwidth_type,
                            rx03.enable_dc_coupling = rx_enable_dc_coupling,
                            rx03.for_engineering_sample_device = for_engineering_sample_device;
            
 








    altgxb_hssi_transmitter tx00 ( 
                             // Inputs
                            .datain(w_tx_in00), 
                            .pllclk(slow_pll_clk), 
                            .fastpllclk(fast_pll_clk),
                            .coreclk(i_tx_coreclk[0]),
                            .softreset(i_txdigitalresetout[0]),
                            .analogreset(i_txanalogresetout[0]),
                            .ctrlenable(tx_ctrlenable[1:0]),
                            .forcedisparity(tx_forcedisparity[1:0]), 
                            .xgmdatain(i_xgm_txdataout[7:0]),
                            .xgmctrl(i_xgm_txctrlout[0]),
                            .serialdatain(rx_in[0]),
                            .srlpbk(tx_srlpbk[0]), 
                            .devclrn(1'b1), 
                            .devpor(1'b1),
                            .vodctrl(tx_vodctrl[2:0]),
                            .preemphasisctrl(tx_preemphasisctrl[2:0]),
                            // Outputs
                            .dataout(w_tx_out[0]),
                            .xgmdataout(i_xgm_txdatain[7:0]), 
                            .xgmctrlenable(i_xgm_txctrl[0]), 
                            .rdenablesync(tx00_rd_enable_sync), 
                            .parallelfdbkdata(w_parallelfdbkdata00),
                            .pre8b10bdata(w_pre8b10bdata00)

                             );

                          defparam
                            tx00.channel_num           = 0,
                            tx00.channel_width         = channel_width,
                            tx00.serialization_factor  = deserialization_factor,
                            tx00.use_8b_10b_mode       = c_use_8b_10b_mode,
                            tx00.use_double_data_mode  = c_use_double_data_mode,
                            tx00.use_fifo_mode         = c_use_fifo_mode,
                            tx00.force_disparity_mode  = c_force_disparity_mode,
                            tx00.transmit_protocol     = tx_transmit_protocol,
                            tx00.use_self_test_mode    = use_self_test_mode,
                            tx00.self_test_mode        = self_test_mode,
                            tx00.use_vod_ctrl_signal   = use_vod_ctrl_signal,
                            tx00.vod_ctrl_setting      = vod_ctrl_setting,
                            tx00.use_preemphasis_ctrl_signal   = use_preemphasis_ctrl_signal,
                            tx00.preemphasis_ctrl_setting      = preemphasis_ctrl_setting,
                            tx00.use_reverse_parallel_feedback = c_use_reverse_parallel_feedback;

            
 

    altgxb_hssi_transmitter tx01 ( 
                             // Inputs
                            .datain(w_tx_in01), 
                            .pllclk(slow_pll_clk), 
                            .fastpllclk(fast_pll_clk),
                            .coreclk(i_tx_coreclk[1]),
                            .softreset(i_txdigitalresetout[1]),
                            .analogreset(i_txanalogresetout[1]),
                            .ctrlenable(tx_ctrlenable[3:2]),
                            .forcedisparity(tx_forcedisparity[3:2]), 
                            .xgmdatain(i_xgm_txdataout[15:8]),
                            .xgmctrl(i_xgm_txctrlout[1]),
                            .serialdatain(rx_in[1]),
                            .srlpbk(tx_srlpbk[1]), 
                            .devclrn(1'b1), 
                            .devpor(1'b1),
                            .vodctrl(tx_vodctrl[5:3]),
                            .preemphasisctrl(tx_preemphasisctrl[5:3]),
                            .dataout(w_tx_out[1]),
                            // Outputs
                            .xgmdataout(i_xgm_txdatain[15:8]), 
                            .xgmctrlenable(i_xgm_txctrl[1]), 
//                            .rdenablesync(tx00_rd_enable_sync), 
                            .rdenablesync(), 
                            .parallelfdbkdata(w_parallelfdbkdata01),
                            .pre8b10bdata(w_pre8b10bdata01)

                             );


                          defparam
                            tx01.channel_num           = 1,
                            tx01.serialization_factor  = deserialization_factor,
                            tx01.channel_width         = channel_width,
                            tx01.use_8b_10b_mode       = c_use_8b_10b_mode,
                            tx01.use_double_data_mode  = c_use_double_data_mode,
                            tx01.use_fifo_mode         = c_use_fifo_mode,
                            tx01.force_disparity_mode  = c_force_disparity_mode,
                            tx01.transmit_protocol     = tx_transmit_protocol,
                            tx01.use_self_test_mode    = use_self_test_mode,
                            tx01.self_test_mode        = self_test_mode,
                            tx01.use_vod_ctrl_signal   = use_vod_ctrl_signal,
                            tx01.vod_ctrl_setting      = vod_ctrl_setting,
                            tx01.use_preemphasis_ctrl_signal   = use_preemphasis_ctrl_signal,
                            tx01.preemphasis_ctrl_setting      = preemphasis_ctrl_setting,
                            tx01.use_reverse_parallel_feedback = c_use_reverse_parallel_feedback;


    altgxb_hssi_transmitter tx02 ( 
                             // Inputs
                            .datain(w_tx_in02), 
                            .pllclk(slow_pll_clk), 
                            .fastpllclk(fast_pll_clk),
                            .coreclk(i_tx_coreclk[2]),
                            .softreset(i_txdigitalresetout[2]),
                            .analogreset(i_txanalogresetout[2]),
                            .ctrlenable(tx_ctrlenable[5:4]),
                            .forcedisparity(tx_forcedisparity[5:4]), 
                            .xgmdatain(i_xgm_txdataout[23:16]),
                            .xgmctrl(i_xgm_txctrlout[2]),
                            .serialdatain(rx_in[2]),
                            .srlpbk(tx_srlpbk[2]), 
                            .devclrn(1'b1), 
                            .devpor(1'b1),
                            .vodctrl(tx_vodctrl[8:6]),
                            .preemphasisctrl(tx_preemphasisctrl[8:6]),
                            // Outputs
                            .dataout(w_tx_out[2]),
                            .xgmdataout(i_xgm_txdatain[23:16]), 
                            .xgmctrlenable(i_xgm_txctrl[2]), 
//                            .rdenablesync(tx00_rd_enable_sync), 
                            .rdenablesync(), 
                            .parallelfdbkdata(w_parallelfdbkdata02),
                            .pre8b10bdata(w_pre8b10bdata02)


                             );


                          defparam
                            tx02.channel_num           = 2,
                            tx02.serialization_factor  = deserialization_factor,
                            tx02.channel_width         = channel_width,
                            tx02.use_8b_10b_mode       = c_use_8b_10b_mode,
                            tx02.use_double_data_mode  = c_use_double_data_mode,
                            tx02.use_fifo_mode         = c_use_fifo_mode,
                            tx02.force_disparity_mode  = c_force_disparity_mode,
                            tx02.transmit_protocol     = tx_transmit_protocol,
                            tx02.use_self_test_mode    = use_self_test_mode,
                            tx02.self_test_mode        = self_test_mode,
                            tx02.use_vod_ctrl_signal   = use_vod_ctrl_signal,
                            tx02.vod_ctrl_setting      = vod_ctrl_setting,
                            tx02.use_preemphasis_ctrl_signal   = use_preemphasis_ctrl_signal,
                            tx02.preemphasis_ctrl_setting      = preemphasis_ctrl_setting,
                            tx02.use_reverse_parallel_feedback = c_use_reverse_parallel_feedback;




    altgxb_hssi_transmitter tx03 ( 
                             // Inputs
                            .datain(w_tx_in03), 
                            .pllclk(slow_pll_clk), 
                            .fastpllclk(fast_pll_clk),
                            .coreclk(i_tx_coreclk[3]),
                            .softreset(i_txdigitalresetout[3]),
                            .analogreset(i_txanalogresetout[3]),
                            .ctrlenable(tx_ctrlenable[7:6]),
                            .forcedisparity(tx_forcedisparity[7:6]), 
                            .xgmdatain(i_xgm_txdataout[31:24]),
                            .xgmctrl(i_xgm_txctrlout[3]),
                            .serialdatain(rx_in[3]),
                            .srlpbk(tx_srlpbk[3]), 
                            .devclrn(1'b1), 
                            .devpor(1'b1),
                            .vodctrl(tx_vodctrl[11:9]),
                            .preemphasisctrl(tx_preemphasisctrl[11:9]),
                            // Outputs
                            .dataout(w_tx_out[3]),
                            .xgmdataout(i_xgm_txdatain[31:24]), 
                            .xgmctrlenable(i_xgm_txctrl[3]), 
//                            .rdenablesync(tx00_rd_enable_sync), 
                            .rdenablesync(), 
                            .parallelfdbkdata(w_parallelfdbkdata03),
                            .pre8b10bdata(w_pre8b10bdata03)


                             );


                          defparam
                            tx03.channel_num           = 3,
                            tx03.serialization_factor  = deserialization_factor,
                            tx03.channel_width         = channel_width,
                            tx03.use_8b_10b_mode       = c_use_8b_10b_mode,
                            tx03.use_double_data_mode  = c_use_double_data_mode,
                            tx03.use_fifo_mode         = c_use_fifo_mode,
                            tx03.force_disparity_mode  = c_force_disparity_mode,
                            tx03.transmit_protocol     = tx_transmit_protocol,
                            tx03.use_self_test_mode    = use_self_test_mode,
                            tx03.self_test_mode        = self_test_mode,
                            tx03.use_vod_ctrl_signal   = use_vod_ctrl_signal,
                            tx03.vod_ctrl_setting      = vod_ctrl_setting,
                            tx03.use_preemphasis_ctrl_signal   = use_preemphasis_ctrl_signal,
                            tx03.preemphasis_ctrl_setting      = preemphasis_ctrl_setting,
                            tx03.use_reverse_parallel_feedback = c_use_reverse_parallel_feedback;







// PLL Atom


altgxb_pll quad_pll(
                 .inclk({temp_inclk,inclk}),
                 .pllena(1'b1),
                 .clkswitch(1'b0),
                 .areset(i_pllresetout),
                 .pfdena(1'b1),
                 .fbin(1'b1),
                 .clkena(6'b000111),
             .extclkena(4'b0000),
                 .scanclk(),
                 .scanaclr(1'b0),
                 .scandata(1'b0),
                 .clk({temp_clk, coreclk_out, slow_pll_clk, fast_pll_clk}),
                 .extclk(),
                 .clkbad(),
                 .activeclock(),
                 .clkloss(),
                 .locked(pll_locked), 
                 .scandataout()
              );
              
              
     defparam
         quad_pll.pll_type = "cdr",
         quad_pll.operation_mode = "normal",
         quad_pll.primary_clock = "inclk0",
         quad_pll.inclk0_input_frequency = pll_inclock_period,
         quad_pll.inclk1_input_frequency = pll_inclock_period,
         quad_pll.clk0_multiply_by = pllclk_mult,
         quad_pll.clk0_divide_by   = pllclk0_div,
         quad_pll.clk0_phase_shift_num = pll_phase_shift_0,
         quad_pll.clk1_multiply_by = pllclk_mult,
         quad_pll.clk1_divide_by   = deserialization_factor/pllclk_div_adj,
         quad_pll.clk1_phase_shift_num = pll_phase_shift_1,
         quad_pll.clk2_multiply_by = pllclk_mult,
         quad_pll.clk2_divide_by   = pllclk2_divisor/pllclk_div_adj,
         quad_pll.clk2_phase_shift_num = pll_phase_shift_2,
         quad_pll.simulation_type = "functional";



/*
                quad_pll.primary_clock = "inclk0",
                quad_pll.inclk0_input_frequency = 6400,
                quad_pll.clk0_multiply_by = 5,
                quad_pll.clk0_divide_by = 1,
                quad_pll.clk1_multiply_by = 5,
                quad_pll.clk1_divide_by = 5,
                quad_pll.clk2_multiply_by = 5,
                quad_pll.clk2_divide_by = 5;
*/


//  
// XGM Interface in atom level.

    altgxb_xgm_interface    xgm00 ( 
                                    // Input
                                    .txdatain(i_xgm_txdatain), 
                                    .txctrl(i_xgm_txctrl),

                                    .rdenablesync(tx00_rd_enable_sync), 
                                    .txclk(slow_pll_clk),
                                    .rxdatain(i_xgm_rxdatain), 
                                    .rxctrl(i_xgm_rxctrl),
                                    .rxrunningdisp(i_xgm_rxrunningdisp),
                                    .rxdatavalid(i_xgm_rx_data_valid_in),
  
                                    .rxclk(slow_pll_clk),
                                    .resetall(),
                                    .adet(i_xgm_adet),
                                    .syncstatus(i_xgm_syncstatus_deskew),
                                    .rdalign(i_xgm_rdalign),
                                    .recovclk(recovered_clk0),
                                    .devclrn(1'b1), 
                                    .devpor(1'b1),

                                    // PE ONLY PORTS
                                    .scanclk(), 
                                    .scanin(),
                                    .scanshift(),
                                    .scanmode(),
                                    .scanout(),
                                    .test(),
                                    .digitalsmtest(),
                                    .calibrationstatus(),
                                    // MDIO PORTS
                                    .mdiodisable(),
                                    .mdioclk(),
                                    .mdioin(),
                                    .rxppmselect(1'b0),
                                    .mdioout(),
                                    .mdiooe(),
                                    // RESET PORTS
                                    .txdigitalreset(txdigitalreset),
                                    .rxdigitalreset(rxdigitalreset),
                                    .rxanalogreset(rxanalogreset),
                                    .pllreset(pll_areset),
                                    .pllenable(pllenable),
                                    .txdigitalresetout(i_txdigitalresetout),
                                    .rxdigitalresetout(i_rxdigitalresetout),
                                    .txanalogresetout(i_txanalogresetout),
                                    .rxanalogresetout(i_rxanalogresetout),
                                    .pllresetout(i_pllresetout),


                                    // Output
                                    .txdataout(i_xgm_txdataout),
                                    .txctrlout(i_xgm_txctrlout),
                                    .rxdataout(i_xgm_rxdataout),
                                    .rxctrlout(i_xgm_rxctrlout),
                                    .alignstatus(channels_are_aligned),
                                .enabledeskew(enable_deskew_fifo),
                                    .fiforesetrd(reset_deskew_fifo),
                                    .resetout()
                                   );
                         defparam
                            xgm00.mode_is_xaui                    = mode_is_xaui,
                            xgm00.use_continuous_calibration_mode = "ON",
                            xgm00.rx_ppm_setting_0                = rx_ppm_setting,
                            xgm00.rx_ppm_setting_1                = rx_ppm_setting;
            


 





    always @ (tx_in)
    begin
     if (reverse_loopback_mode != "RPLB")
      begin
        w_tx_in00 =
            tx_in[01*channel_width -1:00*channel_width];

        w_tx_in01 =
            tx_in[02*channel_width -1:01*channel_width];

        w_tx_in02 =
            tx_in[03*channel_width -1:02*channel_width];

        w_tx_in03 =
            tx_in[04*channel_width -1:03*channel_width];
       end

    end


   always @(slow_pll_clk or rx_cruclk) 
    begin
      if ((protocol_to_mode == "XAUI") || (use_rx_cruclk == "OFF"))
          begin
             i_cruclk =slow_pll_clk; 
          end
      else 
          begin
             i_cruclk = rx_cruclk;
          end
    end

   always @(coreclk_out or rx_clkout or rx_coreclk or tx_coreclk)
    begin
    // connect RX's coreclk to pll.clk[2] in Reverse Parallel Loopback mode
    if (reverse_loopback_mode == "RPLB")
    begin
           i_rx_coreclk[0] = coreclk_out;
           i_rx_coreclk[1] = coreclk_out;
           i_rx_coreclk[2] = coreclk_out;
           i_rx_coreclk[3] = coreclk_out;
    end
    else if (use_rx_coreclk == "ON")
      begin
           i_rx_coreclk[0] = rx_coreclk[0];
           i_rx_coreclk[1] = rx_coreclk[1];
           i_rx_coreclk[2] = rx_coreclk[2];
           i_rx_coreclk[3] = rx_coreclk[3];
      end
   else if ((protocol_to_mode == "XAUI") || 
          (protocol_to_mode == "GIGE") || 
          (use_rx_clkout == "OFF"))
        begin
           i_rx_coreclk[0] = coreclk_out;
           i_rx_coreclk[1] = coreclk_out;
           i_rx_coreclk[2] = coreclk_out;
           i_rx_coreclk[3] = coreclk_out;
        end
    else 
    begin
           i_rx_coreclk[0] = rx_clkout[0];
           i_rx_coreclk[1] = rx_clkout[1];
           i_rx_coreclk[2] = rx_clkout[2];
           i_rx_coreclk[3] = rx_clkout[3];
    end



    if (use_tx_coreclk == "ON")
      begin
           i_tx_coreclk[0] = tx_coreclk[0];
           i_tx_coreclk[1] = tx_coreclk[1];
           i_tx_coreclk[2] = tx_coreclk[2];
           i_tx_coreclk[3] = tx_coreclk[3];
      end
   else 
    begin
           i_tx_coreclk[0] = coreclk_out;
           i_tx_coreclk[1] = coreclk_out;
           i_tx_coreclk[2] = coreclk_out;
           i_tx_coreclk[3] = coreclk_out;
    end


  end
   always @(rx_we or t_rx_we)
   begin
    if (add_generic_fifo_we_synch_register == "ON")
      begin
           i_rx_we[0] = t_rx_we[0];
           i_rx_we[1] = t_rx_we[1];
           i_rx_we[2] = t_rx_we[2];
           i_rx_we[3] = t_rx_we[3];
      end
   else 
    begin
           i_rx_we[0] = rx_we[0];
           i_rx_we[1] = rx_we[1];
           i_rx_we[2] = rx_we[2];
           i_rx_we[3] = rx_we[3];
    end

   end


   always @(w_rx_out00)
    begin
       i_rx_out[rx_channel_width * 1 - 1: rx_channel_width * 0 ] = w_rx_out00[rx_channel_width-1:0];
       if (reverse_loopback_mode == "RPLB")
        begin
          w_tx_in00 = w_rx_out00[rx_channel_width-1:0];
        end

    end

   always @(w_rx_out01)
    begin
       i_rx_out[rx_channel_width * 2 - 1: rx_channel_width * 1 ] = w_rx_out01[rx_channel_width-1:0];
       if (reverse_loopback_mode == "RPLB")
        begin
          w_tx_in01 = w_rx_out01[rx_channel_width-1:0];
        end

    end

   always @(w_rx_out02)
    begin
       i_rx_out[rx_channel_width * 3 - 1: rx_channel_width * 2 ] = w_rx_out02[rx_channel_width-1:0];
       if (reverse_loopback_mode == "RPLB")
        begin
          w_tx_in02 = w_rx_out02[rx_channel_width-1:0];
        end

    end

   always @(w_rx_out03)
     begin
       i_rx_out[rx_channel_width * 4 - 1: rx_channel_width * 3 ] = w_rx_out03[rx_channel_width-1:0];
       if (reverse_loopback_mode == "RPLB")
        begin
          w_tx_in03 = w_rx_out03[rx_channel_width-1:0];
        end

    end

  // Outputs for Receiver
   assign rx_out = i_rx_out[rx_channel_width * number_of_channels-1:0];

  // Outputs for Transmitter
  assign tx_out = w_tx_out[number_of_channels-1:0];
  assign rx_channelaligned = channels_are_aligned;


endmodule



///////////////////////////////////////////////////////////////////////////////
//
//                          end of altgxb megafunction
//
///////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////
//
//                         GXB Codes from atom level
//
///////////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////////
//
//                             altgxb_pll
//
///////////////////////////////////////////////////////////////////////////////




`timescale 1ps / 1ps

// ***** DFFE

primitive ALTGXB_PRIM_DFFE (Q, ENA, D, CLK, CLRN, PRN, notifier);
   input D;   
   input CLRN;
   input PRN;
   input CLK;
   input ENA;
   input notifier;
   output Q; reg Q;

   initial Q = 1'b0;

    table

    //  ENA  D   CLK   CLRN  PRN  notifier  :   Qt  :   Qt+1

        (??) ?    ?      1    1      ?      :   ?   :   -;  // pessimism
         x   ?    ?      1    1      ?      :   ?   :   -;  // pessimism
         1   1   (01)    1    1      ?      :   ?   :   1;  // clocked data
         1   1   (01)    1    x      ?      :   ?   :   1;  // pessimism
 
         1   1    ?      1    x      ?      :   1   :   1;  // pessimism
 
         1   0    0      1    x      ?      :   1   :   1;  // pessimism
         1   0    x      1  (?x)     ?      :   1   :   1;  // pessimism
         1   0    1      1  (?x)     ?      :   1   :   1;  // pessimism
 
         1   x    0      1    x      ?      :   1   :   1;  // pessimism
         1   x    x      1  (?x)     ?      :   1   :   1;  // pessimism
         1   x    1      1  (?x)     ?      :   1   :   1;  // pessimism
 
         1   0   (01)    1    1      ?      :   ?   :   0;  // clocked data

         1   0   (01)    x    1      ?      :   ?   :   0;  // pessimism

         1   0    ?      x    1      ?      :   0   :   0;  // pessimism
         0   ?    ?      x    1      ?      :   ?   :   -;

         1   1    0      x    1      ?      :   0   :   0;  // pessimism
         1   1    x    (?x)   1      ?      :   0   :   0;  // pessimism
         1   1    1    (?x)   1      ?      :   0   :   0;  // pessimism

         1   x    0      x    1      ?      :   0   :   0;  // pessimism
         1   x    x    (?x)   1      ?      :   0   :   0;  // pessimism
         1   x    1    (?x)   1      ?      :   0   :   0;  // pessimism

//       1   1   (x1)    1    1      ?      :   1   :   1;  // reducing pessimism
//       1   0   (x1)    1    1      ?      :   0   :   0;
         1   ?   (x1)    1    1      ?      :   ?   :   -;  // spr 80166-ignore
                                                            // x->1 edge
         1   1   (0x)    1    1      ?      :   1   :   1;
         1   0   (0x)    1    1      ?      :   0   :   0;

         ?   ?   ?       0    1      ?      :   ?   :   0;  // asynch clear

         ?   ?   ?       1    0      ?      :   ?   :   1;  // asynch set

         1   ?   (?0)    1    1      ?      :   ?   :   -;  // ignore falling clock
         1   ?   (1x)    1    1      ?      :   ?   :   -;  // ignore falling clock
         1   *    ?      ?    ?      ?      :   ?   :   -; // ignore data edges

         1   ?   ?     (?1)   ?      ?      :   ?   :   -;  // ignore edges on
         1   ?   ?       ?  (?1)     ?      :   ?   :   -;  //  set and clear

         0   ?   ?       1    1      ?      :   ?   :   -;  //  set and clear

     ?   ?   ?       1    1      *      :   ?   :   x; // spr 36954 - at any
                               // notifier event,
                               // output 'x'
    endtable

endprimitive

module altgxb_dffe ( Q, CLK, ENA, D, CLRN, PRN );
   input D;
   input CLK;
   input CLRN;
   input PRN;
   input ENA;
   output Q;
   
   // wire declarations
   wire D_ipd;
   wire ENA_ipd;
   wire CLK_ipd;
   wire PRN_ipd;
   wire CLRN_ipd;
   
   buf (D_ipd, D);
   buf (ENA_ipd, ENA);
   buf (CLK_ipd, CLK);
   buf (PRN_ipd, PRN);
   buf (CLRN_ipd, CLRN);
   
   wire   legal;
   reg    viol_notifier;
   
   ALTGXB_PRIM_DFFE ( Q, ENA_ipd, D_ipd, CLK_ipd, CLRN_ipd, PRN_ipd, viol_notifier );
   
   and(legal, ENA_ipd, CLRN_ipd, PRN_ipd);
   specify
      
      specparam TREG = 0;
      specparam TREN = 0;
      specparam TRSU = 0;
      specparam TRH  = 0;
      specparam TRPR = 0;
      specparam TRCL = 0;
      
      $setup  (  D, posedge CLK &&& legal, TRSU, viol_notifier  ) ;
      $hold   (  posedge CLK &&& legal, D, TRH, viol_notifier   ) ;
      $setup  (  ENA, posedge CLK &&& legal, TREN, viol_notifier  ) ;
      $hold   (  posedge CLK &&& legal, ENA, 0, viol_notifier   ) ;
 
      ( negedge CLRN => (Q  +: 1'b0)) = ( TRCL, TRCL) ;
      ( negedge PRN  => (Q  +: 1'b1)) = ( TRPR, TRPR) ;
      ( posedge CLK  => (Q  +: D)) = ( TREG, TREG) ;
      
   endspecify
endmodule     

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : altgxb_m_cntr
//
// Description : Timing simulation model for the M counter. This is the
//               loop feedback counter for the Stratix PLL.
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1 ps / 1 ps
module altgxb_m_cntr  (clk,
                        reset,
                        cout,
                        initial_value,
                        modulus,
                        time_delay);

    // INPUT PORTS
    input clk;
    input reset;
    input [31:0] initial_value;
    input [31:0] modulus;
    input [31:0] time_delay;

    // OUTPUT PORTS
    output cout;

    // INTERNAL VARIABLES AND NETS
    integer count;
    reg tmp_cout;
    reg first_rising_edge;
    reg clk_last_value;
    reg cout_tmp;

    initial
    begin
        count = 1;
        first_rising_edge = 1;
        clk_last_value = 0;
    end

    always @(reset or clk)
    begin
        if (reset)
        begin
            count = 1;
            tmp_cout = 0;
            first_rising_edge = 1;
        end
        else begin
            if (clk == 1 && clk_last_value !== clk && first_rising_edge)
            begin
                first_rising_edge = 0;
                tmp_cout = clk;
            end
            else if (first_rising_edge == 0)
            begin
                if (count < modulus)
                    count = count + 1;
                else
                begin
                    count = 1;
                    tmp_cout = ~tmp_cout;
                end
            end
        end
        clk_last_value = clk;

        cout_tmp <= #(time_delay) tmp_cout;
    end

    and (cout, cout_tmp, 1'b1);

endmodule // altgxb_m_cntr

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : altgxb_n_cntr
//
// Description : Timing simulation model for the N counter. This is the
//               input clock divide counter for the Stratix PLL.
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1 ps / 1 ps
module altgxb_n_cntr  (clk,
                        reset,
                        cout,
                        modulus,
                        time_delay);

    // INPUT PORTS
    input clk;
    input reset;
    input [31:0] modulus;
    input [31:0] time_delay;

    // OUTPUT PORTS
    output cout;

    // INTERNAL VARIABLES AND NETS
    integer count;
    reg tmp_cout;
    reg first_rising_edge;
    reg clk_last_value;
    reg clk_last_valid_value;
    reg cout_tmp;

    initial
    begin
        count = 1;
        first_rising_edge = 1;
        clk_last_value = 0;
    end

    always @(reset or clk)
    begin
        if (reset)
        begin
            count = 1;
            tmp_cout = 0;
            first_rising_edge = 1;
        end
        else begin
            if (clk_last_value !== clk)
            begin
                if (clk === 1'bx)
                begin
                    $display("Warning : Invalid transition to 'X' detected on Stratix PLL input clk. This edge will be ignored.");
                    $display("Time: %0t  Instance: %m", $time);
                end
                else if ((clk === 1'b1) && first_rising_edge)
                begin
                    first_rising_edge = 0;
                    tmp_cout = clk;
                end
                else if ((first_rising_edge == 0) && (clk_last_valid_value !== clk))
                begin
                    if (count < modulus)
                        count = count + 1;
                    else
                    begin
                        count = 1;
                        tmp_cout = ~tmp_cout;
                    end
                end
            end
        end
        clk_last_value = clk;
        if (clk !== 1'bx)
            clk_last_valid_value = clk;

        cout_tmp <= #(time_delay) tmp_cout;
    end

    and (cout, cout_tmp, 1'b1);

endmodule // altgxb_n_cntr

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : altgxb_scale_cntr
//
// Description : Timing simulation model for the output scale-down counters.
//               This is a common model for the L0, L1, G0, G1, G2, G3, E0,
//               E1, E2 and E3 output counters of the Stratix PLL.
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1 ps / 1 ps
module altgxb_scale_cntr  (clk,
                            reset,
                            cout,
                            high,
                            low,
                            initial_value,
                            mode,
                            time_delay,
                            ph_tap);

    // INPUT PORTS
    input clk;
    input reset;
    input [31:0] high;
    input [31:0] low;
    input [31:0] initial_value;
    input [8*6:1] mode;
    input [31:0] time_delay;
    input [31:0] ph_tap;

    // OUTPUT PORTS
    output cout;

    // INTERNAL VARIABLES AND NETS
    reg tmp_cout;
    reg first_rising_edge;
    reg clk_last_value;
    reg init;
    integer count;
    integer output_shift_count;
    reg cout_tmp;
    reg [31:0] high_reg;
    reg [31:0] low_reg;
    reg high_cnt_xfer_done;

    initial
    begin
        count = 1;
        first_rising_edge = 0;
        tmp_cout = 0;
        output_shift_count = 0;
        high_cnt_xfer_done = 0;
    end

    always @(clk or reset)
    begin
        if (init !== 1'b1)
        begin
            high_reg = high;
            low_reg = low;
            clk_last_value = 0;
            init = 1'b1;
        end
        if (reset)
        begin
            count = 1;
            output_shift_count = 0;
            tmp_cout = 0;
            first_rising_edge = 0;
        end
        else if (clk_last_value !== clk)
        begin
            if (mode == "off")
                tmp_cout = 0;
            else if (mode == "bypass")
                tmp_cout = clk;
            else if (first_rising_edge == 0)
            begin
                if (clk == 1)
                begin
                    output_shift_count = output_shift_count + 1;
                    if (output_shift_count == initial_value)
                    begin
                        tmp_cout = clk;
                        first_rising_edge = 1;
                    end
                end
            end
            else if (output_shift_count < initial_value)
            begin
                if (clk == 1)
                    output_shift_count = output_shift_count + 1;
            end
            else
            begin
                count = count + 1;
                if (mode == "even" && (count == (high_reg*2) + 1))
                begin
                    tmp_cout = 0;
                    if (high_cnt_xfer_done === 1'b1)
                    begin
                        low_reg = low;
                        high_cnt_xfer_done = 0;
                    end
                end
                else if (mode == "odd" && (count == (high_reg*2)))
                begin
                    tmp_cout = 0;
                    if (high_cnt_xfer_done === 1'b1)
                    begin
                        low_reg = low;
                        high_cnt_xfer_done = 0;
                    end
                end
                else if (count == (high_reg + low_reg)*2 + 1)
                begin
                    tmp_cout = 1;
                    count = 1;        // reset count
                    if (high_reg != high)
                    begin
                        high_reg = high;
                        high_cnt_xfer_done = 1;
                    end
                end
            end
        end
        clk_last_value = clk;
        cout_tmp <= #(time_delay) tmp_cout;
    end

    and (cout, cout_tmp, 1'b1);

endmodule // altgxb_scale_cntr

///////////////////////////////////////////////////////////////////////////////
//
// Module Name : altgxb_pll_reg
//
// Description : Simulation model for a simple DFF.
//               This is required for the generation of the bit slip-signals.
//               No timing, powers upto 0.
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1ps / 1ps
module altgxb_pll_reg (q,
                        clk,
                        ena,
                        d,
                        clrn,
                        prn);

    // INPUT PORTS
    input d;
    input clk;
    input clrn;
    input prn;
    input ena;

    // OUTPUT PORTS
    output q;

    // INTERNAL VARIABLES
    reg q;

    // DEFAULT VALUES THRO' PULLUPs
    tri1 prn, clrn, ena;

    initial q = 0;

    always @ (posedge clk or negedge clrn or negedge prn )
    begin
        if (prn == 1'b0)
            q <= 1;
        else if (clrn == 1'b0)
            q <= 0;
        else if ((clk == 1) & (ena == 1'b1))
            q <= d;
    end

endmodule // altgxb_pll_reg

//////////////////////////////////////////////////////////////////////////////
//
// Module Name : altgxb_stratix_pll
//
// Description : Timing simulation model for the Stratix StratixGX PLL.
//               In the functional mode, it is also the model for the altpll
//               megafunction.
// 
// Limitations : Does not support Spread Spectrum and Bandwidth.
//
// Outputs     : Up to 10 output clocks, each defined by its own set of
//               parameters. Locked output (active high) indicates when the
//               PLL locks. clkbad, clkloss and activeclock are used for
//               clock switchover to indicate which input clock has gone
//               bad, when the clock switchover initiates and which input
//               clock is being used as the reference, respectively.
//               scandataout is the data output of the serial scan chain.
//
//////////////////////////////////////////////////////////////////////////////

`timescale 1 ps/1 ps
`define ALTGXB_PLL_WORD_LENGTH 18

module altgxb_stratix_pll (inclk,
                    fbin,
                    ena,
                    clkswitch,
                    areset,
                    pfdena,
                    clkena,
                    extclkena,
                    scanclk,
                    scanaclr,
                    scandata,
                    clk,
                    extclk,
                    clkbad,
                    activeclock,
                    locked,
                    clkloss,
                    scandataout,
                    // lvds mode specific ports
                    comparator,
                    enable0,
                    enable1);

    parameter operation_mode = "normal";
    parameter qualify_conf_done = "off";
    parameter compensate_clock = "clk0";
    parameter pll_type = "auto";
    parameter scan_chain = "long";
    parameter lpm_type = "stratix_pll";

    parameter clk0_multiply_by = 1;
    parameter clk0_divide_by = 1;
    parameter clk0_phase_shift = 0;
    parameter clk0_time_delay = 0;
    parameter clk0_duty_cycle = 50;

    parameter clk1_multiply_by = 1;
    parameter clk1_divide_by = 1;
    parameter clk1_phase_shift = 0;
    parameter clk1_time_delay = 0;
    parameter clk1_duty_cycle = 50;

    parameter clk2_multiply_by = 1;
    parameter clk2_divide_by = 1;
    parameter clk2_phase_shift = 0;
    parameter clk2_time_delay = 0;
    parameter clk2_duty_cycle = 50;

    parameter clk3_multiply_by = 1;
    parameter clk3_divide_by = 1;
    parameter clk3_phase_shift = 0;
    parameter clk3_time_delay = 0;
    parameter clk3_duty_cycle = 50;

    parameter clk4_multiply_by = 1;
    parameter clk4_divide_by = 1;
    parameter clk4_phase_shift = 0;
    parameter clk4_time_delay = 0;
    parameter clk4_duty_cycle = 50;

    parameter clk5_multiply_by = 1;
    parameter clk5_divide_by = 1;
    parameter clk5_phase_shift = 0;
    parameter clk5_time_delay = 0;
    parameter clk5_duty_cycle = 50;

    parameter extclk0_multiply_by = 1;
    parameter extclk0_divide_by = 1;
    parameter extclk0_phase_shift = 0;
    parameter extclk0_time_delay = 0;
    parameter extclk0_duty_cycle = 50;

    parameter extclk1_multiply_by = 1;
    parameter extclk1_divide_by = 1;
    parameter extclk1_phase_shift = 0;
    parameter extclk1_time_delay = 0;
    parameter extclk1_duty_cycle = 50;

    parameter extclk2_multiply_by = 1;
    parameter extclk2_divide_by = 1;
    parameter extclk2_phase_shift = 0;
    parameter extclk2_time_delay = 0;
    parameter extclk2_duty_cycle = 50;

    parameter extclk3_multiply_by = 1;
    parameter extclk3_divide_by = 1;
    parameter extclk3_phase_shift = 0;
    parameter extclk3_time_delay = 0;
    parameter extclk3_duty_cycle = 50;

    parameter primary_clock = "inclk0";
    parameter inclk0_input_frequency = 10000;
    parameter inclk1_input_frequency = 10000;
    parameter gate_lock_signal = "no";
    parameter gate_lock_counter = 1;
    parameter valid_lock_multiplier = 5;
    parameter invalid_lock_multiplier = 5;

    parameter switch_over_on_lossclk = "off";
    parameter switch_over_on_gated_lock = "off";
    parameter switch_over_counter = 1;
    parameter enable_switch_over_counter = "off";
    parameter feedback_source = "e0";
    parameter bandwidth = 0;
    parameter bandwidth_type = "auto";
    parameter down_spread = "0.0";
    parameter spread_frequency = 0;
    parameter common_rx_tx = "off";
    parameter rx_outclock_resource = "auto";
    parameter use_vco_bypass = "OFF";
    parameter use_dc_coupling = "OFF";

    parameter pfd_min = 0;
    parameter pfd_max = 0;
    parameter vco_min = 0;
    parameter vco_max = 0;
    parameter vco_center = 0;

    // ADVANCED USE PARAMETERS
    parameter m_initial = 1;
    parameter m = 1;
    parameter n = 1;
    parameter m2 = 1;
    parameter n2 = 1;
    parameter ss = 0;

    parameter l0_high = 1;
    parameter l0_low = 1;
    parameter l0_initial = 1;
    parameter l0_mode = "bypass";
    parameter l0_ph = 0;
    parameter l0_time_delay = 0;

    parameter l1_high = 1;
    parameter l1_low = 1;
    parameter l1_initial = 1;
    parameter l1_mode = "bypass";
    parameter l1_ph = 0;
    parameter l1_time_delay = 0;

    parameter g0_high = 1;
    parameter g0_low = 1;
    parameter g0_initial = 1;
    parameter g0_mode = "bypass";
    parameter g0_ph = 0;
    parameter g0_time_delay = 0;

    parameter g1_high = 1;
    parameter g1_low = 1;
    parameter g1_initial = 1;
    parameter g1_mode = "bypass";
    parameter g1_ph = 0;
    parameter g1_time_delay = 0;

    parameter g2_high = 1;
    parameter g2_low = 1;
    parameter g2_initial = 1;
    parameter g2_mode = "bypass";
    parameter g2_ph = 0;
    parameter g2_time_delay = 0;

    parameter g3_high = 1;
    parameter g3_low = 1;
    parameter g3_initial = 1;
    parameter g3_mode = "bypass";
    parameter g3_ph = 0;
    parameter g3_time_delay = 0;

    parameter e0_high = 1;
    parameter e0_low = 1;
    parameter e0_initial = 1;
    parameter e0_mode = "bypass";
    parameter e0_ph = 0;
    parameter e0_time_delay = 0;

    parameter e1_high = 1;
    parameter e1_low = 1;
    parameter e1_initial = 1;
    parameter e1_mode = "bypass";
    parameter e1_ph = 0;
    parameter e1_time_delay = 0;

    parameter e2_high = 1;
    parameter e2_low = 1;
    parameter e2_initial = 1;
    parameter e2_mode = "bypass";
    parameter e2_ph = 0;
    parameter e2_time_delay = 0;

    parameter e3_high = 1;
    parameter e3_low = 1;
    parameter e3_initial = 1;
    parameter e3_mode = "bypass";
    parameter e3_ph = 0;
    parameter e3_time_delay = 0;

    parameter m_ph = 0;
    parameter m_time_delay = 0;
    parameter n_time_delay = 0;

    parameter extclk0_counter = "e0";
    parameter extclk1_counter = "e1";
    parameter extclk2_counter = "e2";
    parameter extclk3_counter = "e3";

    parameter clk0_counter = "g0";
    parameter clk1_counter = "g1";
    parameter clk2_counter = "g2";
    parameter clk3_counter = "g3";
    parameter clk4_counter = "l0";
    parameter clk5_counter = "l1";

    // LVDS mode parameters
    parameter enable0_counter = "l0";
    parameter enable1_counter = "l0";

    parameter charge_pump_current = 0;
    parameter loop_filter_r = "1.0";
    parameter loop_filter_c = 1;

    parameter pll_compensation_delay = 0;
    parameter simulation_type = "timing";
    parameter source_is_pll = "off";

    //parameter for stratix lvds
    parameter clk0_phase_shift_num = 0;
    parameter clk1_phase_shift_num = 0;
    parameter clk2_phase_shift_num = 0;

    parameter skip_vco = "off";

    parameter clk0_use_even_counter_mode = "off";
    parameter clk1_use_even_counter_mode = "off";
    parameter clk2_use_even_counter_mode = "off";
    parameter clk3_use_even_counter_mode = "off";
    parameter clk4_use_even_counter_mode = "off";
    parameter clk5_use_even_counter_mode = "off";
    parameter extclk0_use_even_counter_mode = "off";
    parameter extclk1_use_even_counter_mode = "off";
    parameter extclk2_use_even_counter_mode = "off";
    parameter extclk3_use_even_counter_mode = "off";

    parameter clk0_use_even_counter_value = "off";
    parameter clk1_use_even_counter_value = "off";
    parameter clk2_use_even_counter_value = "off";
    parameter clk3_use_even_counter_value = "off";
    parameter clk4_use_even_counter_value = "off";
    parameter clk5_use_even_counter_value = "off";
    parameter extclk0_use_even_counter_value = "off";
    parameter extclk1_use_even_counter_value = "off";
    parameter extclk2_use_even_counter_value = "off";
    parameter extclk3_use_even_counter_value = "off";

    // INPUT PORTS
    input [1:0] inclk;
    input fbin;
    input ena;
    input clkswitch;
    input areset;
    input pfdena;
    input [5:0] clkena;
    input [3:0] extclkena;
    input scanclk;
    input scanaclr;
    input scandata;
    // lvds specific input ports
    input comparator;

    // OUTPUT PORTS
    output [5:0] clk;
    output [3:0] extclk;
    output [1:0] clkbad;
    output activeclock;
    output locked;
    output clkloss;
    output scandataout;
    // lvds specific output ports
    output enable0;
    output enable1;

    // BUFFER INPUTS
    wire inclk0_ipd;
    wire inclk1_ipd;
    wire ena_ipd;
    wire fbin_ipd;
    wire areset_ipd;
    wire pfdena_ipd;
    wire clkena0_ipd;
    wire clkena1_ipd;
    wire clkena2_ipd;
    wire clkena3_ipd;
    wire clkena4_ipd;
    wire clkena5_ipd;
    wire extclkena0_ipd;
    wire extclkena1_ipd;
    wire extclkena2_ipd;
    wire extclkena3_ipd;
    wire scanclk_ipd;
    wire scanaclr_ipd;
    wire scandata_ipd;
    wire comparator_ipd;
    wire clkswitch_ipd;

    buf (inclk0_ipd, inclk[0]);
    buf (inclk1_ipd, inclk[1]);
    buf (ena_ipd, ena);
    buf (fbin_ipd, fbin);
    buf (areset_ipd, areset);
    buf (pfdena_ipd, pfdena);
    buf (clkena0_ipd, clkena[0]);
    buf (clkena1_ipd, clkena[1]);
    buf (clkena2_ipd, clkena[2]);
    buf (clkena3_ipd, clkena[3]);
    buf (clkena4_ipd, clkena[4]);
    buf (clkena5_ipd, clkena[5]);
    buf (extclkena0_ipd, extclkena[0]);
    buf (extclkena1_ipd, extclkena[1]);
    buf (extclkena2_ipd, extclkena[2]);
    buf (extclkena3_ipd, extclkena[3]);
    buf (scanclk_ipd, scanclk);
    buf (scanaclr_ipd, scanaclr);
    buf (scandata_ipd, scandata);
    buf (comparator_ipd, comparator);
    buf (clkswitch_ipd, clkswitch);

    // INTERNAL VARIABLES AND NETS
    integer scan_chain_length;
    integer i;
    integer j;
    integer k;
    integer l_index;
    integer gate_count;
    integer egpp_offset;
    integer sched_time;
    integer delay_chain;
    integer low;
    integer high;
    integer initial_delay;
    integer fbk_phase;
    integer fbk_delay;
    integer phase_shift[0:7];
    integer last_phase_shift[0:7];

    integer m_times_vco_period;
    integer new_m_times_vco_period;
    integer refclk_period;
    integer fbclk_period;
    integer primary_clock_frequency;
    integer high_time;
    integer low_time;
    integer my_rem;
    integer tmp_rem;
    integer rem;
    integer tmp_vco_per;
    integer vco_per;
    integer offset;
    integer temp_offset;
    integer cycles_to_lock;
    integer cycles_to_unlock;
    integer l0_count;
    integer l1_count;
    integer loop_xplier;
    integer loop_initial;
    integer loop_ph;
    integer loop_time_delay;
    integer cycle_to_adjust;
    integer total_pull_back;
    integer pull_back_M;
    integer pull_back_ext_cntr;

    time    fbclk_time;
    time    first_fbclk_time;
    time    refclk_time;
    time    scanaclr_rising_time;
    time    scanaclr_falling_time;
 
    reg got_first_refclk;
    reg got_second_refclk;
    reg got_first_fbclk;
    reg refclk_last_value;
    reg fbclk_last_value;
    reg inclk_last_value;
    reg pll_is_locked;
    reg pll_about_to_lock;
    reg locked_tmp;
    reg l0_got_first_rising_edge;
    reg l1_got_first_rising_edge;
    reg vco_l0_last_value;
    reg vco_l1_last_value;
    reg areset_ipd_last_value;
    reg ena_ipd_last_value;
    reg pfdena_ipd_last_value;
    reg inclk_out_of_range;
    reg schedule_vco_last_value;

    reg gate_out;
    reg vco_val;

    reg [31:0] m_initial_val;
    reg [31:0] m_val;
    reg [31:0] m_val_tmp;
    reg [31:0] m2_val;
    reg [31:0] n_val;
    reg [31:0] n_val_tmp;
    reg [31:0] n2_val;
    reg [31:0] m_time_delay_val;
    reg [31:0] n_time_delay_val;
    reg [31:0] m_delay;
    reg [8*6:1] m_mode_val;
    reg [8*6:1] m2_mode_val;
    reg [8*6:1] n_mode_val;
    reg [8*6:1] n2_mode_val;
    reg [31:0] l0_high_val;
    reg [31:0] l0_low_val;
    reg [31:0] l0_initial_val;
    reg [31:0] l0_time_delay_val;
    reg [8*6:1] l0_mode_val;
    reg [31:0] l1_high_val;
    reg [31:0] l1_low_val;
    reg [31:0] l1_initial_val;
    reg [31:0] l1_time_delay_val;
    reg [8*6:1] l1_mode_val;

    reg [31:0] g0_high_val;
    reg [31:0] g0_low_val;
    reg [31:0] g0_initial_val;
    reg [31:0] g0_time_delay_val;
    reg [8*6:1] g0_mode_val;

    reg [31:0] g1_high_val;
    reg [31:0] g1_low_val;
    reg [31:0] g1_initial_val;
    reg [31:0] g1_time_delay_val;
    reg [8*6:1] g1_mode_val;

    reg [31:0] g2_high_val;
    reg [31:0] g2_low_val;
    reg [31:0] g2_initial_val;
    reg [31:0] g2_time_delay_val;
    reg [8*6:1] g2_mode_val;

    reg [31:0] g3_high_val;
    reg [31:0] g3_low_val;
    reg [31:0] g3_initial_val;
    reg [31:0] g3_time_delay_val;
    reg [8*6:1] g3_mode_val;

    reg [31:0] e0_high_val;
    reg [31:0] e0_low_val;
    reg [31:0] e0_initial_val;
    reg [31:0] e0_time_delay_val;
    reg [8*6:1] e0_mode_val;

    reg [31:0] e1_high_val;
    reg [31:0] e1_low_val;
    reg [31:0] e1_initial_val;
    reg [31:0] e1_time_delay_val;
    reg [8*6:1] e1_mode_val;

    reg [31:0] e2_high_val;
    reg [31:0] e2_low_val;
    reg [31:0] e2_initial_val;
    reg [31:0] e2_time_delay_val;
    reg [8*6:1] e2_mode_val;

    reg [31:0] e3_high_val;
    reg [31:0] e3_low_val;
    reg [31:0] e3_initial_val;
    reg [31:0] e3_time_delay_val;
    reg [8*6:1] e3_mode_val;

    reg scanclk_last_value;
    reg scanaclr_last_value;
    reg transfer;
    reg transfer_enable;
    reg [288:0] scan_data;
    reg schedule_vco;
    reg schedule_offset;
    reg stop_vco;
    reg inclk_n;

    reg [7:0] vco_out;
    wire inclk_l0;
    wire inclk_l1;
    wire inclk_m;
    wire clk0_tmp;
    wire clk1_tmp;
    wire clk2_tmp;
    wire clk3_tmp;
    wire clk4_tmp;
    wire clk5_tmp;
    wire extclk0_tmp;
    wire extclk1_tmp;
    wire extclk2_tmp;
    wire extclk3_tmp;
    wire nce_l0;
    wire nce_l1;
    wire nce_temp;

    reg vco_l0;
    reg vco_l1;

    wire clk0;
    wire clk1;
    wire clk2;
    wire clk3;
    wire clk4;
    wire clk5;
    wire extclk0;
    wire extclk1;
    wire extclk2;
    wire extclk3;
    wire ena0;
    wire ena1;
    wire ena2;
    wire ena3;
    wire ena4;
    wire ena5;
    wire extena0;
    wire extena1;
    wire extena2;
    wire extena3;
    wire refclk;
    wire fbclk;
    wire l0_clk;
    wire l1_clk;
    wire g0_clk;
    wire g1_clk;
    wire g2_clk;
    wire g3_clk;
    wire e0_clk;
    wire e1_clk;
    wire e2_clk;
    wire e3_clk;
    wire dffa_out;
    wire dffb_out;
    wire dffc_out;
    wire dffd_out;
    wire lvds_dffb_clk;
    wire lvds_dffc_clk;
    wire lvds_dffd_clk;
    
    reg first_schedule;

    wire enable0_tmp;
    wire enable1_tmp;
    wire enable_0;
    wire enable_1;
    reg l0_tmp;
    reg l1_tmp;

    reg vco_period_was_phase_adjusted;
    reg phase_adjust_was_scheduled;

    // for external feedback mode

    reg [31:0] ext_fbk_cntr_high;
    reg [31:0] ext_fbk_cntr_low;
    reg [31:0] ext_fbk_cntr_modulus;
    reg [31:0] ext_fbk_cntr_delay;
    reg [8*2:1] ext_fbk_cntr;
    reg [8*6:1] ext_fbk_cntr_mode;
    integer ext_fbk_cntr_ph;
    integer ext_fbk_cntr_initial;

    wire inclk_e0;
    wire inclk_e1;
    wire inclk_e2;
    wire inclk_e3;
    wire [31:0] cntr_e0_initial;
    wire [31:0] cntr_e1_initial;
    wire [31:0] cntr_e2_initial;
    wire [31:0] cntr_e3_initial;
    wire [31:0] cntr_e0_delay;
    wire [31:0] cntr_e1_delay;
    wire [31:0] cntr_e2_delay;
    wire [31:0] cntr_e3_delay;
    reg  [31:0] ext_fbk_delay;

    // variables for clk_switch
    reg clk0_is_bad;
    reg clk1_is_bad;
    reg inclk0_last_value;
    reg inclk1_last_value;
    reg other_clock_value;
    reg other_clock_last_value;
    reg primary_clk_is_bad;
    reg current_clk_is_bad;
    reg external_switch;
//    reg [8*6:1] current_clock;
    reg active_clock;
    reg clkloss_tmp;
    reg got_curr_clk_falling_edge_after_clkswitch;
    reg active_clk_was_switched;

    integer clk0_count;
    integer clk1_count;
    integer switch_over_count;

    reg scandataout_tmp;
    integer quiet_time;
    reg pll_in_quiet_period;
    time start_quiet_time;
    reg quiet_period_violation;
    reg reconfig_err;
    reg scanclr_violation;
    reg scanclr_clk_violation;
    reg got_first_scanclk_after_scanclr_inactive_edge;
    reg error;

    reg no_warn;

    // internal parameters
    parameter EGPP_SCAN_CHAIN = 289;
    parameter GPP_SCAN_CHAIN = 193;
    parameter TRST = 5000;
    parameter TRSTCLK = 5000;

    // internal variables for scaling of multiply_by and divide_by values
    integer i_clk0_mult_by;
    integer i_clk0_div_by;
    integer i_clk1_mult_by;
    integer i_clk1_div_by;
    integer i_clk2_mult_by;
    integer i_clk2_div_by;
    integer i_clk3_mult_by;
    integer i_clk3_div_by;
    integer i_clk4_mult_by;
    integer i_clk4_div_by;
    integer i_clk5_mult_by;
    integer i_clk5_div_by;
    integer i_extclk0_mult_by;
    integer i_extclk0_div_by;
    integer i_extclk1_mult_by;
    integer i_extclk1_div_by;
    integer i_extclk2_mult_by;
    integer i_extclk2_div_by;
    integer i_extclk3_mult_by;
    integer i_extclk3_div_by;
    integer max_d_value;
    integer new_multiplier;

    // internal variables for storing the phase shift number.(used in lvds mode only)
    integer i_clk0_phase_shift;
    integer i_clk1_phase_shift;
    integer i_clk2_phase_shift;

    // user to advanced internal signals

    integer   i_m_initial;
    integer   i_m;
    integer   i_n;
    integer   i_m2;
    integer   i_n2;
    integer   i_ss;
    integer   i_l0_high;
    integer   i_l1_high;
    integer   i_g0_high;
    integer   i_g1_high;
    integer   i_g2_high;
    integer   i_g3_high;
    integer   i_e0_high;
    integer   i_e1_high;
    integer   i_e2_high;
    integer   i_e3_high;
    integer   i_l0_low;
    integer   i_l1_low;
    integer   i_g0_low;
    integer   i_g1_low;
    integer   i_g2_low;
    integer   i_g3_low;
    integer   i_e0_low;
    integer   i_e1_low;
    integer   i_e2_low;
    integer   i_e3_low;
    integer   i_l0_initial;
    integer   i_l1_initial;
    integer   i_g0_initial;
    integer   i_g1_initial;
    integer   i_g2_initial;
    integer   i_g3_initial;
    integer   i_e0_initial;
    integer   i_e1_initial;
    integer   i_e2_initial;
    integer   i_e3_initial;
    reg [8*6:1]   i_l0_mode;
    reg [8*6:1]   i_l1_mode;
    reg [8*6:1]   i_g0_mode;
    reg [8*6:1]   i_g1_mode;
    reg [8*6:1]   i_g2_mode;
    reg [8*6:1]   i_g3_mode;
    reg [8*6:1]   i_e0_mode;
    reg [8*6:1]   i_e1_mode;
    reg [8*6:1]   i_e2_mode;
    reg [8*6:1]   i_e3_mode;
    integer   i_vco_min;
    integer   i_vco_max;
    integer   i_vco_center;
    integer   i_pfd_min;
    integer   i_pfd_max;
    integer   i_l0_ph;
    integer   i_l1_ph;
    integer   i_g0_ph;
    integer   i_g1_ph;
    integer   i_g2_ph;
    integer   i_g3_ph;
    integer   i_e0_ph;
    integer   i_e1_ph;
    integer   i_e2_ph;
    integer   i_e3_ph;
    integer   i_m_ph;
    integer   m_ph_val;
    integer   i_l0_time_delay;
    integer   i_l1_time_delay;
    integer   i_g0_time_delay;
    integer   i_g1_time_delay;
    integer   i_g2_time_delay;
    integer   i_g3_time_delay;
    integer   i_e0_time_delay;
    integer   i_e1_time_delay;
    integer   i_e2_time_delay;
    integer   i_e3_time_delay;
    integer   i_m_time_delay;
    integer   i_n_time_delay;
    integer   i_extclk3_counter;
    integer   i_extclk2_counter;
    integer   i_extclk1_counter;
    integer   i_extclk0_counter;
    integer   i_clk5_counter;
    integer   i_clk4_counter;
    integer   i_clk3_counter;
    integer   i_clk2_counter;
    integer   i_clk1_counter;
    integer   i_clk0_counter;
    integer   i_charge_pump_current;
    integer   i_loop_filter_r;
    integer   max_neg_abs;
    integer   output_count;
    integer   new_divisor;

    reg pll_is_in_reset;

    // uppercase to lowercase parameter values
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_operation_mode;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_pll_type;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_qualify_conf_done;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_compensate_clock;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_scan_chain;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_primary_clock;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_gate_lock_signal;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_switch_over_on_lossclk;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_switch_over_on_gated_lock;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_enable_switch_over_counter;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_feedback_source;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_bandwidth_type;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_simulation_type;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_enable0_counter;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] l_enable1_counter;

    integer current_clock;
    reg is_fast_pll;
    reg op_mode;

    reg init;

    specify
    endspecify

    // finds the closest integer fraction of a given pair of numerator and denominator. 
    task find_simple_integer_fraction;
        input numerator;
        input denominator;
        input max_denom;
        output fraction_num; 
        output fraction_div; 
        parameter max_iter = 20;
        
        integer numerator;
        integer denominator;
        integer max_denom;
        integer fraction_num; 
        integer fraction_div; 
        
        integer quotient_array[max_iter-1:0];
        integer int_loop_iter;
        integer int_quot;
        integer m_value;
        integer d_value;
        integer old_m_value;
        integer swap;

        integer loop_iter;
        integer num;
        integer den;
        integer i_max_iter;

    begin      
        loop_iter = 0;
        num = numerator;
        den = denominator;
        i_max_iter = max_iter;
       
        while (loop_iter < i_max_iter)
        begin
            int_quot = num / den;
            quotient_array[loop_iter] = int_quot;
            num = num - (den*int_quot);
            loop_iter=loop_iter+1;
            
            if ((num == 0) || (max_denom != -1) || (loop_iter == i_max_iter)) 
            begin
                // calculate the numerator and denominator if there is a restriction on the
                // max denom value or if the loop is ending
                m_value = 0;
                d_value = 1;
                // get the rounded value at this stage for the remaining fraction
                if (den != 0)
                begin
                    m_value = (2*num/den);
                end
                // calculate the fraction numerator and denominator at this stage
                for (int_loop_iter = loop_iter-1; int_loop_iter >= 0; int_loop_iter=int_loop_iter-1)
                begin
                    if (m_value == 0)
                    begin
                        m_value = quotient_array[int_loop_iter];
                        d_value = 1;
                    end
                    else
                    begin
                        old_m_value = m_value;
                        m_value = quotient_array[int_loop_iter]*m_value + d_value;
                        d_value = old_m_value;
                    end
                end
                // if the denominator is less than the maximum denom_value or if there is no restriction save it
                if ((d_value <= max_denom) || (max_denom == -1))
                begin
                    if ((m_value == 0) || (d_value == 0))
                    begin
                        fraction_num = numerator;
                        fraction_div = denominator;
                    end
                    else
                    begin
                        fraction_num = m_value;
                        fraction_div = d_value;
                    end
                end
                // end the loop if the denomitor has overflown or the numerator is zero (no remainder during this round)
                if (((d_value > max_denom) && (max_denom != -1)) || (num == 0))
                begin
                    i_max_iter = loop_iter;
                end
            end
            // swap the numerator and denominator for the next round
            swap = den;
            den = num;
            num = swap;
        end
    end
    endtask // find_simple_integer_fraction

// get the absolute value
    function integer abs;
    input value;
    integer value;
    begin
        if (value < 0)
            abs = value * -1;
        else abs = value;
    end
    endfunction

    // find twice the period of the slowest clock
    function integer slowest_clk;
    input L0, L0_mode, L1, L1_mode, G0, G0_mode, G1, G1_mode, G2, G2_mode, G3, G3_mode, E0, E0_mode, E1, E1_mode, E2, E2_mode, E3, E3_mode, scan_chain, refclk, m_mod;
    integer L0, L1, G0, G1, G2, G3, E0, E1, E2, E3;
    reg [8*6:1] L0_mode, L1_mode, G0_mode, G1_mode, G2_mode, G3_mode, E0_mode, E1_mode, E2_mode, E3_mode;
    reg [8*5:1] scan_chain;
    integer refclk;
    reg [31:0] m_mod;
    integer max_modulus;
    begin
        max_modulus = 1;
        if (L0_mode != "bypass" && L0_mode != "   off")
            max_modulus = L0;
        if (L1 > max_modulus && L1_mode != "bypass" && L1_mode != "   off")
            max_modulus = L1;
        if (G0 > max_modulus && G0_mode != "bypass" && G0_mode != "   off")
            max_modulus = G0;
        if (G1 > max_modulus && G1_mode != "bypass" && G1_mode != "   off")
            max_modulus = G1;
        if (G2 > max_modulus && G2_mode != "bypass" && G2_mode != "   off")
            max_modulus = G2;
        if (G3 > max_modulus && G3_mode != "bypass" && G3_mode != "   off")
            max_modulus = G3;
        if (scan_chain == "long")
        begin
            if (E0 > max_modulus && E0_mode != "bypass" && E0_mode != "   off")
                max_modulus = E0;
            if (E1 > max_modulus && E1_mode != "bypass" && E1_mode != "   off")
                max_modulus = E1;
            if (E2 > max_modulus && E2_mode != "bypass" && E2_mode != "   off")
                max_modulus = E2;
            if (E3 > max_modulus && E3_mode != "bypass" && E3_mode != "   off")
                max_modulus = E3;
        end

        slowest_clk = ((refclk/m_mod) * max_modulus *2);
    end
    endfunction
    
    // count the number of digits in the given integer
    function integer count_digit;
    input X;
    integer X;
    integer count, result;
    begin
        count = 0;
        result = X;
        while (result != 0)
        begin
            result = (result / 10);
            count = count + 1;
        end
        
        count_digit = count;
    end
    endfunction

    // reduce the given huge number(X) to Y significant digits
    function integer scale_num;
    input X, Y;
    integer X, Y;
    integer count;
    integer fac_ten, lc;
    begin
        fac_ten = 1;
        count = count_digit(X);
        
        for (lc = 0; lc < (count-Y); lc = lc + 1)
            fac_ten = fac_ten * 10;

        scale_num = (X / fac_ten);
    end
    endfunction     

    // find the greatest common denominator of X and Y
    function integer gcd;
    input X,Y;
    integer X,Y;
    integer L, S, R, G;
    begin
        if (X < Y) // find which is smaller.
        begin
            S = X;
            L = Y;
        end
        else
        begin
            S = Y;
            L = X;
        end

        R = S;
        while ( R > 1)
        begin
            S = L;
            L = R;
            R = S % L;  // divide bigger number by smaller.
                        // remainder becomes smaller number.
        end
        if (R == 0)    // if evenly divisible then L is gcd else it is 1.
            G = L;
        else
            G = R;
        gcd = G;
    end
    endfunction

    // find the least common multiple of A1 to A10
    function integer lcm;
    input A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, P;
    integer A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, P;
    integer M1, M2, M3, M4, M5 , M6, M7, M8, M9, R;
    begin
        M1 = (A1 * A2)/gcd(A1, A2);
        M2 = (M1 * A3)/gcd(M1, A3);
        M3 = (M2 * A4)/gcd(M2, A4);
        M4 = (M3 * A5)/gcd(M3, A5);
        M5 = (M4 * A6)/gcd(M4, A6);
        M6 = (M5 * A7)/gcd(M5, A7);
        M7 = (M6 * A8)/gcd(M6, A8);
        M8 = (M7 * A9)/gcd(M7, A9);
        M9 = (M8 * A10)/gcd(M8, A10);
        if (M9 < 3)
            R = 10;
        else if ((M9 <= 10) && (M9 >= 3))
            R = 4 * M9;
        else if (M9 > 1000)
            R = scale_num(M9,3);
        else
            R = M9;
        lcm = R; 
    end
    endfunction

    // find the factor of division of the output clock frequency
    // compared to the VCO
    function integer output_counter_value;
    input clk_divide, clk_mult, M, N;
    integer clk_divide, clk_mult, M, N;
    integer R;
    begin
        R = (clk_divide * M)/(clk_mult * N);
        output_counter_value = R;
    end
    endfunction

    // find the mode of each of the PLL counters - bypass, even or odd
    function [8*6:1] counter_mode;
    input duty_cycle;
    input output_counter_value;
    integer duty_cycle;
    integer output_counter_value;
    integer half_cycle_high;
    reg [8*6:1] R;
    begin
        half_cycle_high = (2*duty_cycle*output_counter_value)/100;
        if (output_counter_value == 1)
            R = "bypass";
        else if ((half_cycle_high % 2) == 0)
            R = "even";
        else
            R = "odd";
        counter_mode = R;
    end
    endfunction

    // find the number of VCO clock cycles to hold the output clock high
    function integer counter_high;
    input output_counter_value, duty_cycle;
    integer output_counter_value, duty_cycle;
    integer half_cycle_high;
    integer tmp_counter_high;
    integer mode;
    begin
        half_cycle_high = (2*duty_cycle*output_counter_value)/100;
        mode = ((half_cycle_high % 2) == 0);
        tmp_counter_high = half_cycle_high/2;
        counter_high = tmp_counter_high + !mode;
    end
    endfunction

    // find the number of VCO clock cycles to hold the output clock low
    function integer counter_low;
    input output_counter_value, duty_cycle;
    integer output_counter_value, duty_cycle, counter_h;
    integer half_cycle_high;
    integer mode;
    integer tmp_counter_high;
    begin
        half_cycle_high = (2*duty_cycle*output_counter_value)/100;
        mode = ((half_cycle_high % 2) == 0);
        tmp_counter_high = half_cycle_high/2;
        counter_h = tmp_counter_high + !mode;
        counter_low =  output_counter_value - counter_h;
    end
    endfunction

    // find the smallest time delay amongst t1 to t10
    function integer mintimedelay;
    input t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    integer t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    integer m1,m2,m3,m4,m5,m6,m7,m8,m9;
    begin
        if (t1 < t2)
            m1 = t1;
        else
            m1 = t2;
        if (m1 < t3)
            m2 = m1;
        else
            m2 = t3;
        if (m2 < t4)
            m3 = m2;
        else
            m3 = t4;
        if (m3 < t5)
            m4 = m3;
        else
            m4 = t5;
        if (m4 < t6)
            m5 = m4;
        else
            m5 = t6;
        if (m5 < t7)
            m6 = m5;
        else
            m6 = t7;
        if (m6 < t8)
            m7 = m6;
        else
            m7 = t8;
        if (m7 < t9)
            m8 = m7;
        else
            m8 = t9;
        if (m8 < t10)
            m9 = m8;
        else
            m9 = t10;
        if (m9 > 0)
            mintimedelay = m9;
        else
            mintimedelay = 0;
    end
    endfunction

    // find the numerically largest negative number, and return its absolute value
    function integer maxnegabs;
    input t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    integer t1, t2, t3, t4, t5, t6, t7, t8, t9, t10;
    integer m1,m2,m3,m4,m5,m6,m7,m8,m9;
    begin
        if (t1 < t2) m1 = t1; else m1 = t2;
        if (m1 < t3) m2 = m1; else m2 = t3;
        if (m2 < t4) m3 = m2; else m3 = t4;
        if (m3 < t5) m4 = m3; else m4 = t5;
        if (m4 < t6) m5 = m4; else m5 = t6;
        if (m5 < t7) m6 = m5; else m6 = t7;
        if (m6 < t8) m7 = m6; else m7 = t8;
        if (m7 < t9) m8 = m7; else m8 = t9;
        if (m8 < t10) m9 = m8; else m9 = t10;
        maxnegabs = (m9 < 0) ? 0 - m9 : 0;
    end
    endfunction

    // adjust the given tap_phase by adding the largest negative number (ph_base) 
    function integer ph_adjust;
    input tap_phase, ph_base;
    integer tap_phase, ph_base;
    begin
        ph_adjust = tap_phase + ph_base;
    end
    endfunction

    // find the actual time delay for each PLL counter
    function integer counter_time_delay;
    input clk_time_delay, m_time_delay, n_time_delay;
    integer clk_time_delay, m_time_delay, n_time_delay;
    begin
        counter_time_delay = clk_time_delay + m_time_delay - n_time_delay;
    end
    endfunction

    // find the number of VCO clock cycles to wait initially before the first 
    // rising edge of the output clock
    function integer counter_initial;
    input tap_phase, m, n;
    integer tap_phase, m, n, phase;
    begin
        if (tap_phase < 0) tap_phase = 0 - tap_phase;
        // adding 0.5 for rounding correction (required in order to round
        // to the nearest integer instead of truncating)
        phase = ((tap_phase * m) / (360 * n)) + 0.5;
        counter_initial = phase;
    end
    endfunction

    // find which VCO phase tap to align the rising edge of the output clock to
    function integer counter_ph;
    input tap_phase;
    input m,n;
    integer m,n, phase;
    integer tap_phase;
    begin
    // adding 0.5 for rounding correction
        phase = (tap_phase * m / n) + 0.5;
        counter_ph = (phase % 360)/45;
    end
    endfunction

    // convert the given string to length 6 by padding with spaces
    function [8*6:1] translate_string;
    input mode;
    reg [8*6:1] new_mode;
    begin
        if (mode == "bypass")
            new_mode = "bypass";
        else if (mode == "even")
            new_mode = "  even";
        else if (mode == "odd")
            new_mode = "   odd";

        translate_string = new_mode;
    end
    endfunction

    // convert string to integer with sign
    function integer str2int; 
    input [8*16:1] s;

    reg [8*16:1] reg_s;
    reg [8:1] digit;
    reg [8:1] tmp;
    integer m, magnitude;
    integer sign;

    begin
        sign = 1;
        magnitude = 0;
        reg_s = s;
        for (m=1; m<=16; m=m+1)
        begin
            tmp = reg_s[128:121];
            digit = tmp & 8'b00001111;
            reg_s = reg_s << 8;
            // Accumulate ascii digits 0-9 only.
            if ((tmp>=48) && (tmp<=57)) 
                magnitude = (magnitude * 10) + digit;
            if (tmp == 45)
                sign = -1;  // Found a '-' character, i.e. number is negative.
        end
        str2int = sign*magnitude;
    end
    endfunction

    // this is for stratix lvds only
    // convert phase delay to integer
    function integer get_int_phase_shift; 
    input [8*16:1] s;
    input i_phase_shift;
    integer i_phase_shift;

    begin
        if (i_phase_shift != 0)
        begin                   
            get_int_phase_shift = i_phase_shift;
        end       
        else
        begin
            get_int_phase_shift = str2int(s);
        end        
    end
    endfunction

    // calculate the given phase shift (in ps) in terms of degrees
    function integer get_phase_degree; 
    input phase_shift;
    integer phase_shift, result;
    begin
        result = (phase_shift * 360) / inclk0_input_frequency;
        // this is to round up the calculation result
        if ( result > 0 )
            result = result + 1;
        else if ( result < 0 )
            result = result - 1;
        else
            result = 0;

        // assign the rounded up result
        get_phase_degree = result;
    end
    endfunction

    // convert uppercase parameter values to lowercase
    // assumes that the maximum character length of a parameter is 18
    function [8*`ALTGXB_PLL_WORD_LENGTH:1] alpha_tolower;
    input [8*`ALTGXB_PLL_WORD_LENGTH:1] given_string;

    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] return_string;
    reg [8*`ALTGXB_PLL_WORD_LENGTH:1] reg_string;
    reg [8:1] tmp;
    reg [8:1] conv_char;
    integer byte_count;
    begin
        return_string = "                    "; // initialise strings to spaces
        conv_char = "        ";
        reg_string = given_string;
        for (byte_count = `ALTGXB_PLL_WORD_LENGTH; byte_count >= 1; byte_count = byte_count - 1)
        begin
            tmp = reg_string[8*`ALTGXB_PLL_WORD_LENGTH:(8*(`ALTGXB_PLL_WORD_LENGTH-1)+1)];
            reg_string = reg_string << 8;
            if ((tmp >= 65) && (tmp <= 90)) // ASCII number of 'A' is 65, 'Z' is 90
            begin
                conv_char = tmp + 32; // 32 is the difference in the position of 'A' and 'a' in the ASCII char set
                return_string = {return_string, conv_char};
            end
            else
                return_string = {return_string, tmp};
        end
    
        alpha_tolower = return_string;
    end
    endfunction

    initial
    begin
        // convert string parameter values from uppercase to lowercase,
        // as expected in this model
        l_operation_mode             = alpha_tolower(operation_mode);
        l_pll_type                   = alpha_tolower(pll_type);
        l_qualify_conf_done          = alpha_tolower(qualify_conf_done);
        l_compensate_clock           = alpha_tolower(compensate_clock);
        l_scan_chain                 = alpha_tolower(scan_chain);
        l_primary_clock              = alpha_tolower(primary_clock);
        l_gate_lock_signal           = alpha_tolower(gate_lock_signal);
        l_switch_over_on_lossclk     = alpha_tolower(switch_over_on_lossclk);
        l_switch_over_on_gated_lock  = alpha_tolower(switch_over_on_gated_lock);
        l_enable_switch_over_counter = alpha_tolower(enable_switch_over_counter);
        l_feedback_source            = alpha_tolower(feedback_source);
        l_bandwidth_type             = alpha_tolower(bandwidth_type);
        l_simulation_type            = alpha_tolower(simulation_type);
        l_enable0_counter            = alpha_tolower(enable0_counter);
        l_enable1_counter            = alpha_tolower(enable1_counter);

        if (m == 0)
        begin 
            // set the limit of the divide_by value that can be returned by
            // the following function.
            max_d_value = 500;
            
            // scale down the multiply_by and divide_by values provided by the design
            // before attempting to use them in the calculations below
            find_simple_integer_fraction(clk0_multiply_by, clk0_divide_by,
                            max_d_value, i_clk0_mult_by, i_clk0_div_by);
            find_simple_integer_fraction(clk1_multiply_by, clk1_divide_by,
                            max_d_value, i_clk1_mult_by, i_clk1_div_by);
            find_simple_integer_fraction(clk2_multiply_by, clk2_divide_by,
                            max_d_value, i_clk2_mult_by, i_clk2_div_by);
            find_simple_integer_fraction(clk3_multiply_by, clk3_divide_by,
                            max_d_value, i_clk3_mult_by, i_clk3_div_by);
            find_simple_integer_fraction(clk4_multiply_by, clk4_divide_by,
                            max_d_value, i_clk4_mult_by, i_clk4_div_by);
            find_simple_integer_fraction(clk5_multiply_by, clk5_divide_by,
                            max_d_value, i_clk5_mult_by, i_clk5_div_by);
            find_simple_integer_fraction(extclk0_multiply_by, extclk0_divide_by,
                            max_d_value, i_extclk0_mult_by, i_extclk0_div_by);
            find_simple_integer_fraction(extclk1_multiply_by, extclk1_divide_by,
                            max_d_value, i_extclk1_mult_by, i_extclk1_div_by);
            find_simple_integer_fraction(extclk2_multiply_by, extclk2_divide_by,
                            max_d_value, i_extclk2_mult_by, i_extclk2_div_by);
            find_simple_integer_fraction(extclk3_multiply_by, extclk3_divide_by,
                            max_d_value, i_extclk3_mult_by, i_extclk3_div_by);

            // convert user parameters to advanced
            i_n = 1;
            if (l_pll_type == "lvds")
                i_m = clk0_multiply_by;
            else
                i_m = lcm  (i_clk0_mult_by, i_clk1_mult_by,
                            i_clk2_mult_by, i_clk3_mult_by,
                            i_clk4_mult_by, i_clk5_mult_by,
                            i_extclk0_mult_by,
                            i_extclk1_mult_by, i_extclk2_mult_by,
                            i_extclk3_mult_by, inclk0_input_frequency);
            i_m_time_delay = maxnegabs (str2int(clk0_time_delay),
                                        str2int(clk1_time_delay),
                                        str2int(clk2_time_delay),
                                        str2int(clk3_time_delay),
                                        str2int(clk4_time_delay),
                                        str2int(clk5_time_delay),
                                        str2int(extclk0_time_delay),
                                        str2int(extclk1_time_delay),
                                        str2int(extclk2_time_delay),
                                        str2int(extclk3_time_delay));
            i_n_time_delay = mintimedelay(str2int(clk0_time_delay),
                                        str2int(clk1_time_delay),
                                        str2int(clk2_time_delay),
                                        str2int(clk3_time_delay),
                                        str2int(clk4_time_delay),
                                        str2int(clk5_time_delay),
                                        str2int(extclk0_time_delay),
                                        str2int(extclk1_time_delay),
                                        str2int(extclk2_time_delay),
                                        str2int(extclk3_time_delay));
            if (l_pll_type == "lvds")
                i_g0_high = counter_high(output_counter_value(i_clk2_div_by,
                            i_clk2_mult_by, i_m, i_n), clk2_duty_cycle);
            else
                i_g0_high = counter_high(output_counter_value(i_clk0_div_by,
                            i_clk0_mult_by, i_m, i_n), clk0_duty_cycle);

            
            i_g1_high = counter_high(output_counter_value(i_clk1_div_by,
                        i_clk1_mult_by, i_m, i_n), clk1_duty_cycle);
            i_g2_high = counter_high(output_counter_value(i_clk2_div_by,
                        i_clk2_mult_by, i_m, i_n), clk2_duty_cycle);
            i_g3_high = counter_high(output_counter_value(i_clk3_div_by,
                        i_clk3_mult_by, i_m, i_n), clk3_duty_cycle);
            if (l_pll_type == "lvds")
            begin
                i_l0_high = i_g0_high;
                i_l1_high = i_g0_high;
            end
            else
            begin
                i_l0_high = counter_high(output_counter_value(i_clk4_div_by,
                            i_clk4_mult_by,  i_m, i_n), clk4_duty_cycle);
                i_l1_high = counter_high(output_counter_value(i_clk5_div_by,
                            i_clk5_mult_by,  i_m, i_n), clk5_duty_cycle);
            end
            i_e0_high = counter_high(output_counter_value(i_extclk0_div_by,
                        i_extclk0_mult_by,  i_m, i_n), extclk0_duty_cycle);
            i_e1_high = counter_high(output_counter_value(i_extclk1_div_by,
                        i_extclk1_mult_by,  i_m, i_n), extclk1_duty_cycle);
            i_e2_high = counter_high(output_counter_value(i_extclk2_div_by,
                        i_extclk2_mult_by,  i_m, i_n), extclk2_duty_cycle);
            i_e3_high = counter_high(output_counter_value(i_extclk3_div_by,
                        i_extclk3_mult_by,  i_m, i_n), extclk3_duty_cycle);
            if (l_pll_type == "lvds")
                i_g0_low  = counter_low(output_counter_value(i_clk2_div_by,
                            i_clk2_mult_by,  i_m, i_n), clk2_duty_cycle);
            else
                i_g0_low  = counter_low(output_counter_value(i_clk0_div_by,
                            i_clk0_mult_by,  i_m, i_n), clk0_duty_cycle);
            i_g1_low  = counter_low(output_counter_value(i_clk1_div_by,
                        i_clk1_mult_by,  i_m, i_n), clk1_duty_cycle);
            i_g2_low  = counter_low(output_counter_value(i_clk2_div_by,
                        i_clk2_mult_by,  i_m, i_n), clk2_duty_cycle);
            i_g3_low  = counter_low(output_counter_value(i_clk3_div_by,
                        i_clk3_mult_by,  i_m, i_n), clk3_duty_cycle);
            if (l_pll_type == "lvds")
            begin
                i_l0_low  = i_g0_low;
                i_l1_low  = i_g0_low;
            end
            else
            begin
                i_l0_low  = counter_low(output_counter_value(i_clk4_div_by,
                            i_clk4_mult_by,  i_m, i_n), clk4_duty_cycle);
                i_l1_low  = counter_low(output_counter_value(i_clk5_div_by,
                            i_clk5_mult_by,  i_m, i_n), clk5_duty_cycle);
            end
            i_e0_low  = counter_low(output_counter_value(i_extclk0_div_by,
                        i_extclk0_mult_by,  i_m, i_n), extclk0_duty_cycle);
            i_e1_low  = counter_low(output_counter_value(i_extclk1_div_by,
                        i_extclk1_mult_by,  i_m, i_n), extclk1_duty_cycle);
            i_e2_low  = counter_low(output_counter_value(i_extclk2_div_by,
                        i_extclk2_mult_by,  i_m, i_n), extclk2_duty_cycle);
            i_e3_low  = counter_low(output_counter_value(i_extclk3_div_by,
                        i_extclk3_mult_by,  i_m, i_n), extclk3_duty_cycle);            
            
            if (l_pll_type == "flvds")
            begin
                // Need to readjust phase shift values when the clock multiply value has been readjusted.
                new_multiplier = clk0_multiply_by / i_clk0_mult_by;
                i_clk0_phase_shift = (clk0_phase_shift_num * new_multiplier);
                i_clk1_phase_shift = (clk1_phase_shift_num * new_multiplier);
                i_clk2_phase_shift = (clk2_phase_shift_num * new_multiplier);
            end
            else
            begin
                i_clk0_phase_shift = get_int_phase_shift(clk0_phase_shift, clk0_phase_shift_num);
                i_clk1_phase_shift = get_int_phase_shift(clk1_phase_shift, clk1_phase_shift_num);
                i_clk2_phase_shift = get_int_phase_shift(clk2_phase_shift, clk2_phase_shift_num);
            end
            
            max_neg_abs = maxnegabs(i_clk0_phase_shift,
                                    i_clk1_phase_shift,
                                    i_clk2_phase_shift,
                                    str2int(clk3_phase_shift),
                                    str2int(clk4_phase_shift),
                                    str2int(clk5_phase_shift),
                                    str2int(extclk0_phase_shift),
                                    str2int(extclk1_phase_shift),
                                    str2int(extclk2_phase_shift),
                                    str2int(extclk3_phase_shift));
            if (l_pll_type == "lvds")
                i_g0_initial = counter_initial(get_phase_degree(ph_adjust(i_clk2_phase_shift, max_neg_abs)), i_m, i_n);
            else
                i_g0_initial = counter_initial(get_phase_degree(ph_adjust(i_clk0_phase_shift, max_neg_abs)), i_m, i_n);

            i_g1_initial = counter_initial(get_phase_degree(ph_adjust(i_clk1_phase_shift, max_neg_abs)), i_m, i_n);
            i_g2_initial = counter_initial(get_phase_degree(ph_adjust(i_clk2_phase_shift, max_neg_abs)), i_m, i_n);
            i_g3_initial = counter_initial(get_phase_degree(ph_adjust(str2int(clk3_phase_shift), max_neg_abs)), i_m, i_n);
            if (l_pll_type == "lvds")
            begin
                i_l0_initial = i_g0_initial;
                i_l1_initial = i_g0_initial;
            end
            else
            begin
                i_l0_initial = counter_initial(get_phase_degree(ph_adjust(str2int(clk4_phase_shift), max_neg_abs)), i_m, i_n);
                i_l1_initial = counter_initial(get_phase_degree(ph_adjust(str2int(clk5_phase_shift), max_neg_abs)), i_m, i_n);
            end
            i_e0_initial = counter_initial(get_phase_degree(ph_adjust(str2int(extclk0_phase_shift), max_neg_abs)), i_m, i_n);
            i_e1_initial = counter_initial(get_phase_degree(ph_adjust(str2int(extclk1_phase_shift), max_neg_abs)), i_m, i_n);
            i_e2_initial = counter_initial(get_phase_degree(ph_adjust(str2int(extclk2_phase_shift), max_neg_abs)), i_m, i_n);
            i_e3_initial = counter_initial(get_phase_degree(ph_adjust(str2int(extclk3_phase_shift), max_neg_abs)), i_m, i_n);
            if (l_pll_type == "lvds")
                i_g0_mode = counter_mode(clk2_duty_cycle, output_counter_value(i_clk2_div_by, i_clk2_mult_by,  i_m, i_n));
            else
                i_g0_mode = counter_mode(clk0_duty_cycle, output_counter_value(i_clk0_div_by, i_clk0_mult_by,  i_m, i_n));
            i_g1_mode = counter_mode(clk1_duty_cycle,output_counter_value(i_clk1_div_by, i_clk1_mult_by,  i_m, i_n));
            i_g2_mode = counter_mode(clk2_duty_cycle,output_counter_value(i_clk2_div_by, i_clk2_mult_by,  i_m, i_n));
            i_g3_mode = counter_mode(clk3_duty_cycle,output_counter_value(i_clk3_div_by, i_clk3_mult_by,  i_m, i_n));
            if (l_pll_type == "lvds")
            begin
                i_l0_mode = "bypass";
                i_l1_mode = "bypass";
            end
            else
            begin
                i_l0_mode = counter_mode(clk4_duty_cycle,output_counter_value(i_clk4_div_by, i_clk4_mult_by,  i_m, i_n));
                i_l1_mode = counter_mode(clk5_duty_cycle,output_counter_value(i_clk5_div_by, i_clk5_mult_by,  i_m, i_n));
            end
            i_e0_mode = counter_mode(extclk0_duty_cycle,output_counter_value(i_extclk0_div_by, i_extclk0_mult_by,  i_m, i_n));
            i_e1_mode = counter_mode(extclk1_duty_cycle,output_counter_value(i_extclk1_div_by, i_extclk1_mult_by,  i_m, i_n));
            i_e2_mode = counter_mode(extclk2_duty_cycle,output_counter_value(i_extclk2_div_by, i_extclk2_mult_by,  i_m, i_n));
            i_e3_mode = counter_mode(extclk3_duty_cycle,output_counter_value(i_extclk3_div_by, i_extclk3_mult_by,  i_m, i_n));
            i_m_ph    = counter_ph(get_phase_degree(max_neg_abs), i_m, i_n);
            i_m_initial = counter_initial(get_phase_degree(max_neg_abs), i_m, i_n);
            if (l_pll_type == "lvds")
                i_g0_ph = counter_ph(get_phase_degree(ph_adjust(i_clk2_phase_shift, max_neg_abs)), i_m, i_n);
            else
                i_g0_ph = counter_ph(get_phase_degree(ph_adjust(i_clk0_phase_shift, max_neg_abs)), i_m, i_n);

            i_g1_ph = counter_ph(get_phase_degree(ph_adjust(i_clk1_phase_shift, max_neg_abs)), i_m, i_n);
            i_g2_ph = counter_ph(get_phase_degree(ph_adjust(i_clk2_phase_shift, max_neg_abs)), i_m, i_n);
            i_g3_ph = counter_ph(get_phase_degree(ph_adjust(str2int(clk3_phase_shift),max_neg_abs)), i_m, i_n);
            if (l_pll_type == "lvds")
            begin
                i_l0_ph = i_g0_ph;
                i_l1_ph = i_g0_ph;
            end
            else
            begin
                i_l0_ph = counter_ph(get_phase_degree(ph_adjust(str2int(clk4_phase_shift),max_neg_abs)), i_m, i_n);
                i_l1_ph = counter_ph(get_phase_degree(ph_adjust(str2int(clk5_phase_shift),max_neg_abs)), i_m, i_n);
            end
            i_e0_ph = counter_ph(get_phase_degree(ph_adjust(str2int(extclk0_phase_shift),max_neg_abs)), i_m, i_n);
            i_e1_ph = counter_ph(get_phase_degree(ph_adjust(str2int(extclk1_phase_shift),max_neg_abs)), i_m, i_n);
            i_e2_ph = counter_ph(get_phase_degree(ph_adjust(str2int(extclk2_phase_shift),max_neg_abs)), i_m, i_n);
            i_e3_ph = counter_ph(get_phase_degree(ph_adjust(str2int(extclk3_phase_shift),max_neg_abs)), i_m, i_n);

            if (l_pll_type == "lvds")
                i_g0_time_delay = counter_time_delay  ( str2int(clk2_time_delay),
                                                        i_m_time_delay,
                                                        i_n_time_delay);
            else
                i_g0_time_delay = counter_time_delay  ( str2int(clk0_time_delay),
                                                        i_m_time_delay,
                                                        i_n_time_delay);
            i_g1_time_delay = counter_time_delay  ( str2int(clk1_time_delay),
                                                    i_m_time_delay,
                                                    i_n_time_delay);
            i_g2_time_delay = counter_time_delay  ( str2int(clk2_time_delay),
                                                    i_m_time_delay,
                                                    i_n_time_delay);
            i_g3_time_delay = counter_time_delay  ( str2int(clk3_time_delay),
                                                    i_m_time_delay,
                                                    i_n_time_delay);
            if (l_pll_type == "lvds")
            begin
                i_l0_time_delay = i_g0_time_delay;
                i_l1_time_delay = i_g0_time_delay;
            end
            else
            begin
                i_l0_time_delay = counter_time_delay  ( str2int(clk4_time_delay),
                                                        i_m_time_delay,
                                                        i_n_time_delay);
                i_l1_time_delay = counter_time_delay  ( str2int(clk5_time_delay),
                                                        i_m_time_delay,
                                                        i_n_time_delay);
            end
            i_e0_time_delay = counter_time_delay ( str2int( extclk0_time_delay),
                                                            i_m_time_delay,
                                                            i_n_time_delay);
            i_e1_time_delay = counter_time_delay ( str2int( extclk1_time_delay),
                                                            i_m_time_delay,
                                                            i_n_time_delay);
            i_e2_time_delay = counter_time_delay ( str2int( extclk2_time_delay),
                                                            i_m_time_delay,
                                                            i_n_time_delay);
            i_e3_time_delay = counter_time_delay ( str2int( extclk3_time_delay),
                                                            i_m_time_delay,
                                                            i_n_time_delay);
            i_extclk3_counter = "e3" ;
            i_extclk2_counter = "e2" ;
            i_extclk1_counter = "e1" ;
            i_extclk0_counter = "e0" ;
            i_clk5_counter    = "l1" ;
            i_clk4_counter    = "l0" ;
            i_clk3_counter    = "g3" ;
            i_clk2_counter    = "g2" ;
            i_clk1_counter    = "g1" ;

            if (l_pll_type == "lvds")
            begin
                l_enable0_counter = "l0";
                l_enable1_counter = "l1";
                i_clk0_counter    = "l0" ;
            end
            else
                i_clk0_counter    = "g0" ;

            // in external feedback mode, need to adjust M value to take
            // into consideration the external feedback counter value
            if (l_operation_mode == "external_feedback")
            begin
                // if there is a negative phase shift, m_initial can only be 1
                if (max_neg_abs > 0)
                    i_m_initial = 1;

                if (l_feedback_source == "extclk0")
                begin
                    if (i_e0_mode == "bypass")
                        output_count = 1;
                    else
                        output_count = i_e0_high + i_e0_low;
                end
                else if (l_feedback_source == "extclk1")
                begin
                    if (i_e1_mode == "bypass")
                        output_count = 1;
                    else
                        output_count = i_e1_high + i_e1_low;
                end
                else if (l_feedback_source == "extclk2")
                begin
                    if (i_e2_mode == "bypass")
                        output_count = 1;
                    else
                        output_count = i_e2_high + i_e2_low;
                end
                else if (l_feedback_source == "extclk3")
                begin
                    if (i_e3_mode == "bypass")
                        output_count = 1;
                    else
                        output_count = i_e3_high + i_e3_low;
                end
                else // default to e0
                begin
                    if (i_e0_mode == "bypass")
                        output_count = 1;
                    else
                        output_count = i_e0_high + i_e0_low;
                end

                new_divisor = gcd(i_m, output_count);
                i_m = i_m / new_divisor;
                i_n = output_count / new_divisor;
            end

        end
        else 
        begin //  m != 0

            i_n = n;
            i_m = m;
            i_l0_high = l0_high;
            i_l1_high = l1_high;
            i_g0_high = g0_high;
            i_g1_high = g1_high;
            i_g2_high = g2_high;
            i_g3_high = g3_high;
            i_e0_high = e0_high;
            i_e1_high = e1_high;
            i_e2_high = e2_high;
            i_e3_high = e3_high;
            i_l0_low  = l0_low;
            i_l1_low  = l1_low;
            i_g0_low  = g0_low;
            i_g1_low  = g1_low;
            i_g2_low  = g2_low;
            i_g3_low  = g3_low;
            i_e0_low  = e0_low;
            i_e1_low  = e1_low;
            i_e2_low  = e2_low;
            i_e3_low  = e3_low;
            i_l0_initial = l0_initial;
            i_l1_initial = l1_initial;
            i_g0_initial = g0_initial;
            i_g1_initial = g1_initial;
            i_g2_initial = g2_initial;
            i_g3_initial = g3_initial;
            i_e0_initial = e0_initial;
            i_e1_initial = e1_initial;
            i_e2_initial = e2_initial;
            i_e3_initial = e3_initial;
            i_l0_mode = alpha_tolower(l0_mode);
            i_l1_mode = alpha_tolower(l1_mode);
            i_g0_mode = alpha_tolower(g0_mode);
            i_g1_mode = alpha_tolower(g1_mode);
            i_g2_mode = alpha_tolower(g2_mode);
            i_g3_mode = alpha_tolower(g3_mode);
            i_e0_mode = alpha_tolower(e0_mode);
            i_e1_mode = alpha_tolower(e1_mode);
            i_e2_mode = alpha_tolower(e2_mode);
            i_e3_mode = alpha_tolower(e3_mode);
            i_l0_ph  = l0_ph;
            i_l1_ph  = l1_ph;
            i_g0_ph  = g0_ph;
            i_g1_ph  = g1_ph;
            i_g2_ph  = g2_ph;
            i_g3_ph  = g3_ph;
            i_e0_ph  = e0_ph;
            i_e1_ph  = e1_ph;
            i_e2_ph  = e2_ph;
            i_e3_ph  = e3_ph;
            i_m_ph   = m_ph;        // default
            i_m_initial = m_initial;
            i_l0_time_delay = l0_time_delay;
            i_l1_time_delay = l1_time_delay;
            i_g0_time_delay = g0_time_delay;
            i_g1_time_delay = g1_time_delay;
            i_g2_time_delay = g2_time_delay;
            i_g3_time_delay = g3_time_delay;
            i_e0_time_delay = e0_time_delay;
            i_e1_time_delay = e1_time_delay;
            i_e2_time_delay = e2_time_delay;
            i_e3_time_delay = e3_time_delay;
            i_m_time_delay  = m_time_delay;
            i_n_time_delay  = n_time_delay;
            i_extclk3_counter = alpha_tolower(extclk3_counter);
            i_extclk2_counter = alpha_tolower(extclk2_counter);
            i_extclk1_counter = alpha_tolower(extclk1_counter);
            i_extclk0_counter = alpha_tolower(extclk0_counter);
            i_clk5_counter    = alpha_tolower(clk5_counter);
            i_clk4_counter    = alpha_tolower(clk4_counter);
            i_clk3_counter    = alpha_tolower(clk3_counter);
            i_clk2_counter    = alpha_tolower(clk2_counter);
            i_clk1_counter    = alpha_tolower(clk1_counter);
            i_clk0_counter    = alpha_tolower(clk0_counter);

        end // user to advanced conversion

        // set the scan_chain length
        if (l_scan_chain == "long")
            scan_chain_length = EGPP_SCAN_CHAIN;
        else if (l_scan_chain == "short")
            scan_chain_length = GPP_SCAN_CHAIN;

        if (l_primary_clock == "inclk0")
        begin
            refclk_period = inclk0_input_frequency * i_n;
            primary_clock_frequency = inclk0_input_frequency;
        end
        else if (l_primary_clock == "inclk1")
        begin
            refclk_period = inclk1_input_frequency * i_n;
            primary_clock_frequency = inclk1_input_frequency;
        end

        m_times_vco_period = refclk_period;
        new_m_times_vco_period = refclk_period;

        fbclk_period = 0;
        high_time = 0;
        low_time = 0;
        schedule_vco = 0;
        schedule_offset = 1;
        vco_out[7:0] = 8'b0;
        fbclk_last_value = 0;
        offset = 0;
        temp_offset = 0;
        got_first_refclk = 0;
        got_first_fbclk = 0;
        fbclk_time = 0;
        first_fbclk_time = 0;
        refclk_time = 0;
        first_schedule = 1;
        sched_time = 0;
        vco_val = 0;
        l0_got_first_rising_edge = 0;
        l1_got_first_rising_edge = 0;
        vco_l0_last_value = 0;
        l0_count = 1;
        l1_count = 1;
        l0_tmp = 0;
        l1_tmp = 0;
        gate_count = 0;
        gate_out = 0;
        initial_delay = 0;
        fbk_phase = 0;
        for (i = 0; i <= 7; i = i + 1)
        begin
            phase_shift[i] = 0;
            last_phase_shift[i] = 0;
        end
        fbk_delay = 0;
        inclk_n = 0;
        cycle_to_adjust = 0;
        m_delay = 0;
        vco_l0 = 0;
        vco_l1 = 0;
        total_pull_back = 0;
        pull_back_M = 0;
        pull_back_ext_cntr = 0;
        vco_period_was_phase_adjusted = 0;
        phase_adjust_was_scheduled = 0;
        ena_ipd_last_value = 0;
        inclk_out_of_range = 0;
        scandataout_tmp = 0;
        schedule_vco_last_value = 0;

        // set initial values for counter parameters
        m_initial_val = i_m_initial;
        m_val = i_m;
        m_time_delay_val = i_m_time_delay;
        n_val = i_n;
        n_time_delay_val = i_n_time_delay;
        m_ph_val = i_m_ph;

        m2_val = m2;
        n2_val = n2;

        if (m_val == 1)
            m_mode_val = "bypass";
        if (m2_val == 1)
            m2_mode_val = "bypass";
        if (n_val == 1)
            n_mode_val = "bypass";
        if (n2_val == 1)
            n2_mode_val = "bypass";

        if (skip_vco == "on")
        begin
            m_val = 1;
            m_initial_val = 1;
            m_time_delay_val = 0;
            m_ph_val = 0;
        end

        l0_high_val = i_l0_high;
        l0_low_val = i_l0_low;
        l0_initial_val = i_l0_initial;
        l0_mode_val = i_l0_mode;
        l0_time_delay_val = i_l0_time_delay;

        l1_high_val = i_l1_high;
        l1_low_val = i_l1_low;
        l1_initial_val = i_l1_initial;
        l1_mode_val = i_l1_mode;
        l1_time_delay_val = i_l1_time_delay;

        g0_high_val = i_g0_high;
        g0_low_val = i_g0_low;
        g0_initial_val = i_g0_initial;
        g0_mode_val = i_g0_mode;
        g0_time_delay_val = i_g0_time_delay;

        g1_high_val = i_g1_high;
        g1_low_val = i_g1_low;
        g1_initial_val = i_g1_initial;
        g1_mode_val = i_g1_mode;
        g1_time_delay_val = i_g1_time_delay;

        g2_high_val = i_g2_high;
        g2_low_val = i_g2_low;
        g2_initial_val = i_g2_initial;
        g2_mode_val = i_g2_mode;
        g2_time_delay_val = i_g2_time_delay;

        g3_high_val = i_g3_high;
        g3_low_val = i_g3_low;
        g3_initial_val = i_g3_initial;
        g3_mode_val = i_g3_mode;
        g3_time_delay_val = i_g3_time_delay;

        e0_high_val = i_e0_high;
        e0_low_val = i_e0_low;
        e0_initial_val = i_e0_initial;
        e0_mode_val = i_e0_mode;
        e0_time_delay_val = i_e0_time_delay;

        e1_high_val = i_e1_high;
        e1_low_val = i_e1_low;
        e1_initial_val = i_e1_initial;
        e1_mode_val = i_e1_mode;
        e1_time_delay_val = i_e1_time_delay;

        e2_high_val = i_e2_high;
        e2_low_val = i_e2_low;
        e2_initial_val = i_e2_initial;
        e2_mode_val = i_e2_mode;
        e2_time_delay_val = i_e2_time_delay;

        e3_high_val = i_e3_high;
        e3_low_val = i_e3_low;
        e3_initial_val = i_e3_initial;
        e3_mode_val = i_e3_mode;
        e3_time_delay_val = i_e3_time_delay;

        i = 0;
        j = 0;
        inclk_last_value = 0;

        ext_fbk_cntr_ph = 0;
        ext_fbk_cntr_initial = 1;

        // initialize clkswitch variables

        clk0_is_bad = 0;
        clk1_is_bad = 0;
        inclk0_last_value = 0;
        inclk1_last_value = 0;
        other_clock_value = 0;
        other_clock_last_value = 0;
        primary_clk_is_bad = 0;
        current_clk_is_bad = 0;
        external_switch = 0;
//        current_clock = l_primary_clock;
        if (l_primary_clock == "inclk0")
            current_clock = 0;
        else
            current_clock = 1;
        if (l_primary_clock == "inclk0")
            active_clock = 0;
        else
            active_clock = 1;
        clkloss_tmp = 0;
        got_curr_clk_falling_edge_after_clkswitch = 0;
        clk0_count = 0;
        clk1_count = 0;
        switch_over_count = 0;
        active_clk_was_switched = 0;

        // initialize quiet_time
        quiet_time = slowest_clk  ( l0_high_val+l0_low_val, l0_mode_val,
                                    l1_high_val+l1_low_val, l1_mode_val,
                                    g0_high_val+g0_low_val, g0_mode_val,
                                    g1_high_val+g1_low_val, g1_mode_val,
                                    g2_high_val+g2_low_val, g2_mode_val,
                                    g3_high_val+g3_low_val, g3_mode_val,
                                    e0_high_val+e0_low_val, e0_mode_val,
                                    e1_high_val+e1_low_val, e1_mode_val,
                                    e2_high_val+e2_low_val, e2_mode_val,
                                    e3_high_val+e3_low_val, e3_mode_val,
                                    l_scan_chain,
                                    refclk_period, m_val);
        pll_in_quiet_period = 0;
        start_quiet_time = 0; 
        quiet_period_violation = 0;
        reconfig_err = 0;
        scanclr_violation = 0;
        scanclr_clk_violation = 0;
        got_first_scanclk_after_scanclr_inactive_edge = 0;
        error = 0;
        scanaclr_rising_time = 0;
        scanaclr_falling_time = 0;

        // VCO feedback loop settings for external feedback mode
        // first find which ext counter is used for feedback

        if (l_operation_mode == "external_feedback")
        begin
            if (l_feedback_source == "extclk0")
            begin
                if (i_extclk0_counter == "e0")
                    ext_fbk_cntr = "e0";
                else if (i_extclk0_counter == "e1")
                    ext_fbk_cntr = "e1";
                else if (i_extclk0_counter == "e2")
                    ext_fbk_cntr = "e2";
                else if (i_extclk0_counter == "e3")
                    ext_fbk_cntr = "e3";
                else ext_fbk_cntr = "e0";
            end
            else if (l_feedback_source == "extclk1")
            begin
                if (i_extclk1_counter == "e0")
                    ext_fbk_cntr = "e0";
                else if (i_extclk1_counter == "e1")
                    ext_fbk_cntr = "e1";
                else if (i_extclk1_counter == "e2")
                    ext_fbk_cntr = "e2";
                else if (i_extclk1_counter == "e3")
                    ext_fbk_cntr = "e3";
                else ext_fbk_cntr = "e0";
            end
            else if (l_feedback_source == "extclk2")
            begin
                if (i_extclk2_counter == "e0")
                    ext_fbk_cntr = "e0";
                else if (i_extclk2_counter == "e1")
                    ext_fbk_cntr = "e1";
                else if (i_extclk2_counter == "e2")
                    ext_fbk_cntr = "e2";
                else if (i_extclk2_counter == "e3")
                    ext_fbk_cntr = "e3";
                else ext_fbk_cntr = "e0";
            end
            else if (l_feedback_source == "extclk3")
            begin
                if (i_extclk3_counter == "e0")
                    ext_fbk_cntr = "e0";
                else if (i_extclk3_counter == "e1")
                    ext_fbk_cntr = "e1";
                else if (i_extclk3_counter == "e2")
                    ext_fbk_cntr = "e2";
                else if (i_extclk3_counter == "e3")
                    ext_fbk_cntr = "e3";
                else ext_fbk_cntr = "e0";
            end

            // now save this counter's parameters
            if (ext_fbk_cntr == "e0")
            begin
                ext_fbk_cntr_high = e0_high_val;
                ext_fbk_cntr_low = e0_low_val;
                ext_fbk_cntr_ph = i_e0_ph;
                ext_fbk_cntr_initial = i_e0_initial;
                ext_fbk_cntr_delay = e0_time_delay_val;
                ext_fbk_cntr_mode = e0_mode_val;
            end
            else if (ext_fbk_cntr == "e1")
            begin
                ext_fbk_cntr_high = e1_high_val;
                ext_fbk_cntr_low = e1_low_val;
                ext_fbk_cntr_ph = i_e1_ph;
                ext_fbk_cntr_initial = i_e1_initial;
                ext_fbk_cntr_delay = e1_time_delay_val;
                ext_fbk_cntr_mode = e1_mode_val;
            end
            else if (ext_fbk_cntr == "e2")
            begin
                ext_fbk_cntr_high = e2_high_val;
                ext_fbk_cntr_low = e2_low_val;
                ext_fbk_cntr_ph = i_e2_ph;
                ext_fbk_cntr_initial = i_e2_initial;
                ext_fbk_cntr_delay = e2_time_delay_val;
                ext_fbk_cntr_mode = e2_mode_val;
            end
            else if (ext_fbk_cntr == "e3")
            begin
                ext_fbk_cntr_high = e3_high_val;
                ext_fbk_cntr_low = e3_low_val;
                ext_fbk_cntr_ph = i_e3_ph;
                ext_fbk_cntr_initial = i_e3_initial;
                ext_fbk_cntr_delay = e3_time_delay_val;
                ext_fbk_cntr_mode = e3_mode_val;
            end

            if (ext_fbk_cntr_mode == "bypass")
                ext_fbk_cntr_modulus = 1;
            else
                ext_fbk_cntr_modulus = ext_fbk_cntr_high + ext_fbk_cntr_low;
        end

        l_index = 1;
        stop_vco = 0;
        cycles_to_lock = 0;
        cycles_to_unlock = 0;
        if (l_pll_type == "fast")
            locked_tmp = 1;
        else
            locked_tmp = 0;
        pll_is_locked = 0;
        pll_about_to_lock = 0;

        no_warn = 0;
        m_val_tmp = m_val;
        n_val_tmp = n_val;

        pll_is_in_reset = 0;
        if (l_pll_type == "fast" || l_pll_type == "lvds")
            is_fast_pll = 1;
        else is_fast_pll = 0;
    end

    assign inclk_m  =   l_operation_mode == "external_feedback" ? (l_feedback_source == "extclk0" ? extclk0_tmp :
                        l_feedback_source == "extclk1" ? extclk1_tmp :
                        l_feedback_source == "extclk2" ? extclk2_tmp :
                        l_feedback_source == "extclk3" ? extclk3_tmp : 'b0) :
                        vco_out[m_ph_val];

    altgxb_m_cntr m1 (.clk(inclk_m),
                .reset(areset_ipd || (!ena_ipd) || stop_vco),
                .cout(fbclk),
                .initial_value(m_initial_val),
                .modulus(m_val),
                .time_delay(m_delay));

    always @(clkswitch_ipd)
    begin
        if (clkswitch_ipd == 1'b1)
            external_switch = 1;
        clkloss_tmp <= clkswitch_ipd;
    end

    always @(inclk0_ipd or inclk1_ipd)
    begin
        // save the inclk event value
        if (inclk0_ipd !== inclk0_last_value)
        begin
            if (current_clock !== 0)
                other_clock_value = inclk0_ipd;
        end
        if (inclk1_ipd !== inclk1_last_value)
        begin
            if (current_clock !== 1)
                other_clock_value = inclk1_ipd;
        end

        // check if either input clk is bad
        if (inclk0_ipd === 1'b1 && inclk0_ipd !== inclk0_last_value)
        begin
            clk0_count = clk0_count + 1;
            clk0_is_bad = 0;
            if (current_clock == 0)
                current_clk_is_bad = 0;
            clk1_count = 0;
            if (clk0_count > 2)
            begin
                // no event on other clk for 2 cycles
                clk1_is_bad = 1;
                if (current_clock == 1)
                    current_clk_is_bad = 1;
            end
        end
        if (inclk1_ipd === 1'b1 && inclk1_ipd !== inclk1_last_value)
        begin
            clk1_count = clk1_count + 1;
            clk1_is_bad = 0;
            if (current_clock == 1)
                current_clk_is_bad = 0;
            clk0_count = 0;
            if (clk1_count > 2)
            begin
                // no event on other clk for 2 cycles
                clk0_is_bad = 1;
                if (current_clock == 0)
                    current_clk_is_bad = 1;
            end
        end

        // check if the bad clk is the primary clock
        if (((l_primary_clock == "inclk0") && (clk0_is_bad == 1'b1)) || ((l_primary_clock == "inclk1") && (clk1_is_bad == 1'b1)))
            primary_clk_is_bad = 1;
        else
            primary_clk_is_bad = 0;

        // actual switching
        if ((inclk0_ipd !== inclk0_last_value) && (current_clock == 0))
        begin
            if (external_switch == 1'b1)
            begin
                if (!got_curr_clk_falling_edge_after_clkswitch)
                begin
                    if (inclk0_ipd === 1'b0)
                        got_curr_clk_falling_edge_after_clkswitch = 1;
                    inclk_n = inclk0_ipd;
                end
            end
            else inclk_n = inclk0_ipd;
        end
        if ((inclk1_ipd !== inclk1_last_value) && (current_clock == 1))
        begin
            if (external_switch == 1'b1)
            begin
                if (!got_curr_clk_falling_edge_after_clkswitch)
                begin
                    if (inclk1_ipd === 1'b0)
                        got_curr_clk_falling_edge_after_clkswitch = 1;
                    inclk_n = inclk1_ipd;
                end
            end
            else inclk_n = inclk1_ipd;
        end
        if ((other_clock_value == 1'b1) && (other_clock_value != other_clock_last_value) && (l_switch_over_on_lossclk == "on") && (l_enable_switch_over_counter == "on") && primary_clk_is_bad)
            switch_over_count = switch_over_count + 1;
        if ((other_clock_value == 1'b0) && (other_clock_value != other_clock_last_value))
        begin
            if ((external_switch && (got_curr_clk_falling_edge_after_clkswitch || current_clk_is_bad)) || (l_switch_over_on_lossclk == "on" && primary_clk_is_bad && ((l_enable_switch_over_counter == "off" || switch_over_count == switch_over_counter))))
            begin
                got_curr_clk_falling_edge_after_clkswitch = 0;
                if (current_clock == 0)
                begin
                    current_clock = 1;
                end
                else
                begin
                    current_clock = 0;
                end
                active_clock = ~active_clock;
                active_clk_was_switched = 1;
                switch_over_count = 0;
                external_switch = 0;
                current_clk_is_bad = 0;
            end
        end

        if (l_switch_over_on_lossclk == "on" && (clkswitch_ipd != 1'b1))
        begin
            if (primary_clk_is_bad)
                clkloss_tmp = 1;
            else
                clkloss_tmp = 0;
        end

        inclk0_last_value = inclk0_ipd;
        inclk1_last_value = inclk1_ipd;
        other_clock_last_value = other_clock_value;

    end

    and (clkbad[0], clk0_is_bad, 1'b1);
    and (clkbad[1], clk1_is_bad, 1'b1);
    and (activeclock, active_clock, 1'b1);
    and (clkloss, clkloss_tmp, 1'b1);

    altgxb_n_cntr n1 ( .clk(inclk_n),
                        .reset(areset_ipd),
                        .cout(refclk),
                        .modulus(n_val),
                        .time_delay(n_time_delay_val));

    altgxb_scale_cntr l0 ( .clk(vco_out[i_l0_ph]),
                            .reset(areset_ipd || (!ena_ipd) || stop_vco),
                            .cout(l0_clk),
                            .high(l0_high_val),
                            .low(l0_low_val),
                            .initial_value(l0_initial_val),
                            .mode(l0_mode_val),
                            .time_delay(l0_time_delay_val),
                            .ph_tap(i_l0_ph));

    altgxb_scale_cntr l1 ( .clk(vco_out[i_l1_ph]),
                            .reset(areset_ipd || (!ena_ipd) || stop_vco),
                            .cout(l1_clk),
                            .high(l1_high_val),
                            .low(l1_low_val),
                            .initial_value(l1_initial_val),
                            .mode(l1_mode_val),
                            .time_delay(l1_time_delay_val),
                            .ph_tap(i_l1_ph));

    altgxb_scale_cntr g0 ( .clk(vco_out[i_g0_ph]),
                            .reset(areset_ipd || (!ena_ipd) || stop_vco),
                            .cout(g0_clk),
                            .high(g0_high_val),
                            .low(g0_low_val),
                            .initial_value(g0_initial_val),
                            .mode(g0_mode_val),
                            .time_delay(g0_time_delay_val),
                            .ph_tap(i_g0_ph));

    altgxb_pll_reg lvds_dffa ( .d(comparator_ipd),
                                .clrn(1'b1),
                                .prn(1'b1),
                                .ena(1'b1),
                                .clk(g0_clk),
                                .q(dffa_out));

    altgxb_pll_reg lvds_dffb ( .d(dffa_out),
                                .clrn(1'b1),
                                .prn(1'b1),
                                .ena(1'b1),
                                .clk(lvds_dffb_clk),
                                .q(dffb_out));

    assign lvds_dffb_clk = (l_enable0_counter == "l0") ? l0_clk : (l_enable0_counter == "l1") ? l1_clk : 1'b0;

    altgxb_pll_reg lvds_dffc ( .d(dffb_out),
                                .clrn(1'b1),
                                .prn(1'b1),
                                .ena(1'b1),
                                .clk(lvds_dffc_clk),
                                .q(dffc_out));

    assign lvds_dffc_clk = (l_enable0_counter == "l0") ? l0_clk : (l_enable0_counter == "l1") ? l1_clk : 1'b0;

    assign nce_temp = ~dffc_out && dffb_out;

    altgxb_pll_reg lvds_dffd ( .d(nce_temp),
                                .clrn(1'b1),
                                .prn(1'b1),
                                .ena(1'b1),
                                .clk(~lvds_dffd_clk),
                                .q(dffd_out));

    assign lvds_dffd_clk = (l_enable0_counter == "l0") ? l0_clk : (l_enable0_counter == "l1") ? l1_clk : 1'b0;

    assign nce_l0 = (l_enable0_counter == "l0") ? dffd_out : 'b0;
    assign nce_l1 = (l_enable0_counter == "l1") ? dffd_out : 'b0;

    altgxb_scale_cntr g1 ( .clk(vco_out[i_g1_ph]),
                            .reset(areset_ipd || (!ena_ipd) || stop_vco),
                            .cout(g1_clk),
                            .high(g1_high_val),
                            .low(g1_low_val),
                            .initial_value(g1_initial_val),
                            .mode(g1_mode_val),
                            .time_delay(g1_time_delay_val),
                            .ph_tap(i_g1_ph));

    altgxb_scale_cntr g2 ( .clk(vco_out[i_g2_ph]),
                            .reset(areset_ipd || (!ena_ipd) || stop_vco),
                            .cout(g2_clk),
                            .high(g2_high_val),
                            .low(g2_low_val),
                            .initial_value(g2_initial_val),
                            .mode(g2_mode_val),
                            .time_delay(g2_time_delay_val),
                            .ph_tap(i_g2_ph));

    altgxb_scale_cntr g3 ( .clk(vco_out[i_g3_ph]),
                            .reset(areset_ipd || (!ena_ipd) || stop_vco),
                            .cout(g3_clk),
                            .high(g3_high_val),
                            .low(g3_low_val),
                            .initial_value(g3_initial_val),
                            .mode(g3_mode_val),
                            .time_delay(g3_time_delay_val),
                            .ph_tap(i_g3_ph));
    assign cntr_e0_initial = (l_operation_mode == "external_feedback" && ext_fbk_cntr == "e0") ? 1 : e0_initial_val;
    assign cntr_e0_delay = (l_operation_mode == "external_feedback" && ext_fbk_cntr == "e0") ? ext_fbk_delay : e0_time_delay_val;

    altgxb_scale_cntr e0 ( .clk(vco_out[i_e0_ph]),
                            .reset(areset_ipd || (!ena_ipd) || stop_vco),
                            .cout(e0_clk),
                            .high(e0_high_val),
                            .low(e0_low_val),
                            .initial_value(cntr_e0_initial),
                            .mode(e0_mode_val),
                            .time_delay(cntr_e0_delay),
                            .ph_tap(i_e0_ph));

    assign cntr_e1_initial = (l_operation_mode == "external_feedback" && ext_fbk_cntr == "e1") ? 1 : e1_initial_val;
    assign cntr_e1_delay = (l_operation_mode == "external_feedback" && ext_fbk_cntr == "e1") ? ext_fbk_delay : e1_time_delay_val;
    altgxb_scale_cntr e1 ( .clk(vco_out[i_e1_ph]),
                            .reset(areset_ipd || (!ena_ipd) || stop_vco),
                            .cout(e1_clk),
                            .high(e1_high_val),
                            .low(e1_low_val),
                            .initial_value(cntr_e1_initial),
                            .mode(e1_mode_val),
                            .time_delay(cntr_e1_delay),
                            .ph_tap(i_e1_ph));

    assign cntr_e2_initial = (l_operation_mode == "external_feedback" && ext_fbk_cntr == "e2") ? 1 : e2_initial_val;
    assign cntr_e2_delay = (l_operation_mode == "external_feedback" && ext_fbk_cntr == "e2") ? ext_fbk_delay : e2_time_delay_val;
    altgxb_scale_cntr e2 ( .clk(vco_out[i_e2_ph]),
                            .reset(areset_ipd || (!ena_ipd) || stop_vco),
                            .cout(e2_clk),
                            .high(e2_high_val),
                            .low(e2_low_val),
                            .initial_value(cntr_e2_initial),
                            .mode(e2_mode_val),
                            .time_delay(cntr_e2_delay),
                            .ph_tap(i_e2_ph));

    assign cntr_e3_initial = (l_operation_mode == "external_feedback" && ext_fbk_cntr == "e3") ? 1 : e3_initial_val;
    assign cntr_e3_delay = (l_operation_mode == "external_feedback" && ext_fbk_cntr == "e3") ? ext_fbk_delay : e3_time_delay_val;
    altgxb_scale_cntr e3 ( .clk(vco_out[i_e3_ph]),
                            .reset(areset_ipd || (!ena_ipd) || stop_vco),
                            .cout(e3_clk),
                            .high(e3_high_val),
                            .low(e3_low_val),
                            .initial_value(cntr_e3_initial),
                            .mode(e3_mode_val),
                            .time_delay(cntr_e3_delay),
                            .ph_tap(i_e3_ph));


    always @((vco_out[i_l0_ph] && is_fast_pll) or posedge areset_ipd or negedge ena_ipd or stop_vco)
    begin
        if ((areset_ipd == 1'b1) || (ena_ipd == 1'b0) || (stop_vco == 1'b1))
        begin
            l0_count = 1;
            l0_got_first_rising_edge = 0;
        end
        else begin
            if (nce_l0 == 1'b0)
            begin
                if (l0_got_first_rising_edge == 1'b0)
                begin
                    if (vco_out[i_l0_ph] == 1'b1 && vco_out[i_l0_ph] != vco_l0_last_value)
                        l0_got_first_rising_edge = 1;
                end
                else if (vco_out[i_l0_ph] != vco_l0_last_value)
                begin
                    l0_count = l0_count + 1;
                    if (l0_count == (l0_high_val + l0_low_val) * 2)
                        l0_count  = 1;
                end
            end
            if (vco_out[i_l0_ph] == 1'b0 && vco_out[i_l0_ph] != vco_l0_last_value)
            begin
                if (l0_count == 1)
                begin
                    l0_tmp = 1;
                    l0_got_first_rising_edge = 0;
                end
                else l0_tmp = 0;
            end
        end
        vco_l0_last_value = vco_out[i_l0_ph];
    end

    always @((vco_out[i_l1_ph] && is_fast_pll) or posedge areset_ipd or negedge ena_ipd or stop_vco)
    begin
        if (areset_ipd == 1'b1 || ena_ipd == 1'b0 || stop_vco == 1'b1)
        begin
            l1_count = 1;
            l1_got_first_rising_edge = 0;
        end
        else begin
            if (nce_l1 == 1'b0)
            begin
                if (l1_got_first_rising_edge == 1'b0)
                begin
                    if (vco_out[i_l1_ph] == 1'b1 && vco_out[i_l1_ph] != vco_l1_last_value)
                        l1_got_first_rising_edge = 1;
                end
                else if (vco_out[i_l1_ph] != vco_l1_last_value)
                begin
                    l1_count = l1_count + 1;
                    if (l1_count == (l1_high_val + l1_low_val) * 2)
                        l1_count  = 1;
                end
            end
            if (vco_out[i_l1_ph] == 1'b0 && vco_out[i_l1_ph] != vco_l1_last_value)
            begin
                if (l1_count == 1)
                begin
                    l1_tmp = 1;
                    l1_got_first_rising_edge = 0;
                end
                else l1_tmp = 0;
            end
        end
        vco_l1_last_value = vco_out[i_l1_ph];
    end

    assign enable0_tmp = (l_enable0_counter == "l0") ? l0_tmp : l1_tmp;
    assign enable1_tmp = (l_enable1_counter == "l0") ? l0_tmp : l1_tmp;

    always @ (inclk_n or ena_ipd or areset_ipd)
    begin
        if (areset_ipd == 'b1)
        begin
            gate_count = 0;
            gate_out = 0; 
        end
        else if (inclk_n == 'b1 && inclk_last_value != inclk_n)
            if (ena_ipd == 'b1)
            begin
                gate_count = gate_count + 1;
                if (gate_count == gate_lock_counter)
                    gate_out = 1;
            end
        inclk_last_value = inclk_n;
    end

    assign locked = (l_gate_lock_signal == "yes") ? gate_out && locked_tmp : locked_tmp;

    always @ (scanclk_ipd or scanaclr_ipd)
    begin
        if (scanaclr_ipd === 1'b1 && scanaclr_last_value === 1'b0)
            scanaclr_rising_time = $time;
        else if (scanaclr_ipd === 1'b0 && scanaclr_last_value === 1'b1)
        begin
            scanaclr_falling_time = $time;
            // check for scanaclr active pulse width
            if ($time - scanaclr_rising_time < TRST)
            begin
                scanclr_violation = 1;
                $display ("Warning : Detected SCANACLR ACTIVE pulse width violation. Required is 5000 ps, actual is %0t. Reconfiguration may not work.", $time - scanaclr_rising_time);
                $display ("Time: %0t  Instance: %m", $time);
            end
            else begin
                scanclr_violation = 0;
                for (i = 0; i <= scan_chain_length; i = i + 1)
                    scan_data[i] = 0;
            end
            got_first_scanclk_after_scanclr_inactive_edge = 0;
        end
        else if ((scanclk_ipd === 'b1 && scanclk_last_value !== scanclk_ipd) && (got_first_scanclk_after_scanclr_inactive_edge === 1'b0) && ($time - scanaclr_falling_time < TRSTCLK))
        begin
            scanclr_clk_violation = 1;
            $display ("Warning : Detected SCANACLR INACTIVE time violation before rising edge of SCANCLK. Required is 5000 ps, actual is %0t. Reconfiguration may not work.", $time - scanaclr_falling_time);
            $display ("Time: %0t  Instance: %m", $time);
            got_first_scanclk_after_scanclr_inactive_edge = 1;
        end
        else if (scanclk_ipd == 'b1 && scanclk_last_value != scanclk_ipd && scanaclr_ipd === 1'b0)
        begin
            if (pll_in_quiet_period && ($time - start_quiet_time < quiet_time))
            begin
                $display("Time: %0t", $time, "   Warning : Detected transition on SCANCLK during quiet time. PLL may not function correctly."); 
                quiet_period_violation = 1;
            end
            else begin
                pll_in_quiet_period = 0;
                for (j = scan_chain_length-1; j >= 1; j = j - 1)
                begin
                    scan_data[j] = scan_data[j - 1];
                end
                scan_data[0] = scandata_ipd;
            end
            if (got_first_scanclk_after_scanclr_inactive_edge === 1'b0)
            begin
                got_first_scanclk_after_scanclr_inactive_edge = 1;
                scanclr_clk_violation = 0;
            end
        end
        else if (scanclk_ipd === 1'b0 && scanclk_last_value !== scanclk_ipd && scanaclr_ipd === 1'b0)
        begin
            if (pll_in_quiet_period && ($time - start_quiet_time < quiet_time))
            begin
                $display("Time: %0t", $time, "   Warning : Detected transition on SCANCLK during quiet time. PLL may not function correctly."); 
                quiet_period_violation = 1;
            end
            else if (scan_data[scan_chain_length-1] == 1'b1)
            begin
                pll_in_quiet_period = 1;
                quiet_period_violation = 0;
                reconfig_err = 0;
                start_quiet_time = $time;
                // initiate transfer
                scandataout_tmp <= 1'b1;
                quiet_time = slowest_clk  ( l0_high_val+l0_low_val, l0_mode_val,
                                            l1_high_val+l1_low_val, l1_mode_val,
                                            g0_high_val+g0_low_val, g0_mode_val,
                                            g1_high_val+g1_low_val, g1_mode_val,
                                            g2_high_val+g2_low_val, g2_mode_val,
                                            g3_high_val+g3_low_val, g3_mode_val,
                                            e0_high_val+e0_low_val, e0_mode_val,
                                            e1_high_val+e1_low_val, e1_mode_val,
                                            e2_high_val+e2_low_val, e2_mode_val,
                                            e3_high_val+e3_low_val, e3_mode_val,
                                            l_scan_chain,
                                            refclk_period, m_val);
                transfer <= 1;
            end
        end
        scanclk_last_value = scanclk_ipd;
        scanaclr_last_value = scanaclr_ipd;
    end

    always @(scandataout_tmp)
    begin
        if (scandataout_tmp == 1'b1)
            scandataout_tmp <= #(quiet_time) 1'b0;
    end

    always @(posedge transfer)
    begin
        if (transfer == 1'b1)
        begin
            $display("NOTE : Reconfiguring PLL");
            $display ("Time: %0t  Instance: %m", $time);
            if (l_scan_chain == "long")
            begin
                // cntr e3
                error = 0;
                if (scan_data[273] == 1'b1)
                begin
                    e3_mode_val = "bypass";
                    if (scan_data[283] == 1'b1)
                    begin
                        e3_mode_val = "off";
                        $display("Warning : The specified bit settings will turn OFF the E3 counter. It cannot be turned on unless the part is re-initialized.");
                    end
                end
                else if (scan_data[283] == 1'b1)
                    e3_mode_val = "odd";
                else
                    e3_mode_val = "even";
                // before reading delay bits, clear e3_time_delay_val
                e3_time_delay_val = 32'b0;
                e3_time_delay_val = scan_data[287:284];
                e3_time_delay_val = e3_time_delay_val * 250;
                if (e3_time_delay_val > 3000)
                    e3_time_delay_val = 3000;
                e3_high_val[8:0] <= scan_data[272:264];
                e3_low_val[8:0] <= scan_data[282:274];
                if (scan_data[272:264] == 9'b000000000)
                    e3_high_val[9:0] <= 10'b1000000000;
                if (scan_data[282:274] == 9'b000000000)
                    e3_low_val[9:0] <= 10'b1000000000;

                if (ext_fbk_cntr == "e3")
                begin
                    ext_fbk_cntr_high = e3_high_val;
                    ext_fbk_cntr_low = e3_low_val;
                    ext_fbk_cntr_delay = e3_time_delay_val;
                    ext_fbk_cntr_mode = e3_mode_val;
                end

                // cntr e2
                if (scan_data[249] == 1'b1)
                begin
                    e2_mode_val = "bypass";
                    if (scan_data[259] == 1'b1)
                    begin
                        e2_mode_val = "off";
                        $display("Warning : The specified bit settings will turn OFF the E2 counter. It cannot be turned on unless the part is re-initialized.");
                    end
                end
                else if (scan_data[259] == 1'b1)
                    e2_mode_val = "odd";
                else
                    e2_mode_val = "even";
                e2_time_delay_val = 32'b0;
                e2_time_delay_val = scan_data[263:260];
                e2_time_delay_val = e2_time_delay_val * 250;
                if (e2_time_delay_val > 3000)
                    e2_time_delay_val = 3000;
                e2_high_val[8:0] <= scan_data[248:240];
                e2_low_val[8:0] <= scan_data[258:250];
                if (scan_data[248:240] == 9'b000000000)
                    e2_high_val[9:0] <= 10'b1000000000;
                if (scan_data[258:250] == 9'b000000000)
                    e2_low_val[9:0] <= 10'b1000000000;

                if (ext_fbk_cntr == "e2")
                begin
                    ext_fbk_cntr_high = e2_high_val;
                    ext_fbk_cntr_low = e2_low_val;
                    ext_fbk_cntr_delay = e2_time_delay_val;
                    ext_fbk_cntr_mode = e2_mode_val;
                end

                // cntr e1
                if (scan_data[225] == 1'b1)
                begin
                    e1_mode_val = "bypass";
                    if (scan_data[235] == 1'b1)
                    begin
                        e1_mode_val = "off";
                        $display("Warning : The specified bit settings will turn OFF the E1 counter. It cannot be turned on unless the part is re-initialized.");
                    end
                end
                else if (scan_data[235] == 1'b1)
                    e1_mode_val = "odd";
                else
                    e1_mode_val = "even";
                e1_time_delay_val = 32'b0;
                e1_time_delay_val = scan_data[239:236];
                e1_time_delay_val = e1_time_delay_val * 250;
                if (e1_time_delay_val > 3000)
                    e1_time_delay_val = 3000;
                e1_high_val[8:0] <= scan_data[224:216];
                e1_low_val[8:0] <= scan_data[234:226];
                if (scan_data[224:216] == 9'b000000000)
                    e1_high_val[9:0] <= 10'b1000000000;
                if (scan_data[234:226] == 9'b000000000)
                    e1_low_val[9:0] <= 10'b1000000000;

                if (ext_fbk_cntr == "e1")
                begin
                    ext_fbk_cntr_high = e1_high_val;
                    ext_fbk_cntr_low = e1_low_val;
                    ext_fbk_cntr_delay = e1_time_delay_val;
                    ext_fbk_cntr_mode = e1_mode_val;
                end

                // cntr e0
                if (scan_data[201] == 1'b1)
                begin
                    e0_mode_val = "bypass";
                    if (scan_data[211] == 1'b1)
                    begin
                        e0_mode_val = "off";
                        $display("Warning : The specified bit settings will turn OFF the E0 counter. It cannot be turned on unless the part is re-initialized.");
                    end
                end
                else if (scan_data[211] == 1'b1)
                    e0_mode_val = "odd";
                else
                    e0_mode_val = "even";
                e0_time_delay_val = 32'b0;
                e0_time_delay_val = scan_data[215:212];
                e0_time_delay_val = e0_time_delay_val * 250;
                if (e0_time_delay_val > 3000)
                    e0_time_delay_val = 3000;
                e0_high_val[8:0] <= scan_data[200:192];
                e0_low_val[8:0] <= scan_data[210:202];
                if (scan_data[200:192] == 9'b000000000)
                    e0_high_val[9:0] <= 10'b1000000000;
                if (scan_data[210:202] == 9'b000000000)
                    e0_low_val[9:0] <= 10'b1000000000;

                if (ext_fbk_cntr == "e0")
                begin
                    ext_fbk_cntr_high = e0_high_val;
                    ext_fbk_cntr_low = e0_low_val;
                    ext_fbk_cntr_delay = e0_time_delay_val;
                    ext_fbk_cntr_mode = e0_mode_val;
                end
            end

            // cntr l1
            if (scan_data[177] == 1'b1)
            begin
                l1_mode_val = "bypass";
                if (scan_data[187] == 1'b1)
                begin
                    l1_mode_val = "off";
                    $display("Warning : The specified bit settings will turn OFF the L1 counter. It cannot be turned on unless the part is re-initialized.");
                end
            end
            else if (scan_data[187] == 1'b1)
                l1_mode_val = "odd";
            else
                l1_mode_val = "even";
            l1_time_delay_val = 32'b0;
            l1_time_delay_val = scan_data[191:188];
            l1_time_delay_val = l1_time_delay_val * 250;
            if (l1_time_delay_val > 3000)
                l1_time_delay_val = 3000;
            l1_high_val[8:0] <= scan_data[176:168];
            l1_low_val[8:0] <= scan_data[186:178];
            if (scan_data[176:168] == 9'b000000000)
                l1_high_val[9:0] <= 10'b1000000000;
            if (scan_data[186:178] == 9'b000000000)
                l1_low_val[9:0] <= 10'b1000000000;

            // cntr l0
            if (scan_data[153] == 1'b1)
            begin
                l0_mode_val = "bypass";
                if (scan_data[163] == 1'b1)
                begin
                    l0_mode_val = "off";
                    $display("Warning : The specified bit settings will turn OFF the L0 counter. It cannot be turned on unless the part is re-initialized.");
                end
            end
            else if (scan_data[163] == 1'b1)
                l0_mode_val = "odd";
            else
                l0_mode_val = "even";
            l0_time_delay_val = 32'b0;
            l0_time_delay_val = scan_data[167:164];
            l0_time_delay_val = l0_time_delay_val * 250;
            if (l0_time_delay_val > 3000)
                l0_time_delay_val = 3000;
            l0_high_val[8:0] <= scan_data[152:144];
            l0_low_val[8:0] <= scan_data[162:154];
            if (scan_data[152:144] == 9'b000000000)
                l0_high_val[9:0] <= 10'b1000000000;
            if (scan_data[162:154] == 9'b000000000)
                l0_low_val[9:0] <= 10'b1000000000;

            // cntr g3
            if (scan_data[129] == 1'b1)
            begin
                g3_mode_val = "bypass";
                if (scan_data[139] == 1'b1)
                begin
                    g3_mode_val = "off";
                    $display("Warning : The specified bit settings will turn OFF the G3 counter. It cannot be turned on unless the part is re-initialized.");
                end
            end
            else if (scan_data[139] == 1'b1)
                g3_mode_val = "odd";
            else
                g3_mode_val = "even";
            g3_time_delay_val = 32'b0;
            g3_time_delay_val = scan_data[143:140];
            g3_time_delay_val = g3_time_delay_val * 250;
            if (g3_time_delay_val > 3000)
                g3_time_delay_val = 3000;
            g3_high_val[8:0] <= scan_data[128:120];
            g3_low_val[8:0] <= scan_data[138:130];
            if (scan_data[128:120] == 9'b000000000)
                g3_high_val[9:0] <= 10'b1000000000;
            if (scan_data[138:130] == 9'b000000000)
                g3_low_val[9:0] <= 10'b1000000000;

            // cntr g2
            if (scan_data[105] == 1'b1)
            begin
                g2_mode_val = "bypass";
                if (scan_data[115] == 1'b1)
                begin
                    g2_mode_val = "off";
                    $display("Warning : The specified bit settings will turn OFF the G2 counter. It cannot be turned on unless the part is re-initialized.");
                end
            end
            else if (scan_data[115] == 1'b1)
                g2_mode_val = "odd";
            else
                g2_mode_val = "even";
            g2_time_delay_val = 32'b0;
            g2_time_delay_val = scan_data[119:116];
            g2_time_delay_val = g2_time_delay_val * 250;
            if (g2_time_delay_val > 3000)
                g2_time_delay_val = 3000;
            g2_high_val[8:0] <= scan_data[104:96];
            g2_low_val[8:0] <= scan_data[114:106];
            if (scan_data[104:96] == 9'b000000000)
                g2_high_val[9:0] <= 10'b1000000000;
            if (scan_data[114:106] == 9'b000000000)
                g2_low_val[9:0] <= 10'b1000000000;

            // cntr g1
            if (scan_data[81] == 1'b1)
            begin
                g1_mode_val = "bypass";
                if (scan_data[91] == 1'b1)
                begin
                    g1_mode_val = "off";
                    $display("Warning : The specified bit settings will turn OFF the G1 counter. It cannot be turned on unless the part is re-initialized.");
                end
            end
            else if (scan_data[91] == 1'b1)
                g1_mode_val = "odd";
            else
                g1_mode_val = "even";
            g1_time_delay_val = 32'b0;
            g1_time_delay_val = scan_data[95:92];
            g1_time_delay_val = g1_time_delay_val * 250;
            if (g1_time_delay_val > 3000)
                g1_time_delay_val = 3000;
            g1_high_val[8:0] <= scan_data[80:72];
            g1_low_val[8:0] <= scan_data[90:82];
            if (scan_data[80:72] == 9'b000000000)
                g1_high_val[9:0] <= 10'b1000000000;
            if (scan_data[90:82] == 9'b000000000)
                g1_low_val[9:0] <= 10'b1000000000;

            // cntr g0
            if (scan_data[57] == 1'b1)
            begin
                g0_mode_val = "bypass";
                if (scan_data[67] == 1'b1)
                begin
                    g0_mode_val = "off";
                    $display("Warning : The specified bit settings will turn OFF the G0 counter. It cannot be turned on unless the part is re-initialized.");
                end
            end
            else if (scan_data[67] == 1'b1)
                g0_mode_val = "odd";
            else
                g0_mode_val = "even";
            g0_time_delay_val = 32'b0;
            g0_time_delay_val = scan_data[71:68];
            g0_time_delay_val = g0_time_delay_val * 250;
            if (g0_time_delay_val > 3000)
                g0_time_delay_val = 3000;
            g0_high_val[8:0] <= scan_data[56:48];
            g0_low_val[8:0] <= scan_data[66:58];
            if (scan_data[56:48] == 9'b000000000)
                g0_high_val[9:0] <= 10'b1000000000;
            if (scan_data[66:58] == 9'b000000000)
                g0_low_val[9:0] <= 10'b1000000000;

            // cntr M
            error = 0;
            m_val_tmp[8:0] = scan_data[32:24];
            if (scan_data[33] !== 1'b1)
            begin
                if (m_val_tmp[8:0] == 9'b000000001)
                begin
                    reconfig_err = 1;
                    error = 1;
                    $display ("Warning : Illegal 1 value for M counter. Instead, the M counter should be BYPASSED. Reconfiguration may not work.");
                end
                else if (m_val_tmp[8:0] == 9'b000000000)
                    m_val_tmp[9:0] = 10'b1000000000;
                if (error == 1'b0)
                begin
                    if (m_mode_val === "bypass")
                        $display ("Warning : M counter switched from BYPASS mode to enabled (M modulus = %d). PLL may lose lock.", m_val_tmp[9:0]);
                    else
                        $display("PLL reconfigured with : M modulus = %d ", m_val_tmp[9:0]);
                    m_mode_val = "";
                end
            end
            else if (scan_data[33] == 1'b1)
            begin
                if (scan_data[24] !== 1'b0)
                begin
                    reconfig_err = 1;
                    error = 1;
                    $display ("Warning : Illegal value for counter M in BYPASS mode. The LSB of the counter should be set to 0 in order to operate the counter in BYPASS mode. Reconfiguration may not work.");
                end
                else begin
                    if (m_mode_val !== "bypass")
                        $display ("Warning : M counter switched from enabled to BYPASS mode. PLL may lose lock.");
                    m_val_tmp[9:0] = 10'b0000000001;
                    m_mode_val = "bypass";
                    $display("PLL reconfigured with : M modulus = %d ", m_val_tmp[9:0]);
                end
            end

            if (skip_vco == "on")
                m_val_tmp[9:0] = 10'b0000000001;

            // cntr M2
            if (ss > 0)
            begin
                error = 0;
                m2_val[8:0] = scan_data[42:34];
                if (scan_data[43] !== 1'b1)
                begin
                    if (m2_val[8:0] == 9'b000000001)
                    begin
                        reconfig_err = 1;
                        error = 1;
                        $display ("Warning : Illegal 1 value for M2 counter. Instead, the M2 counter should be BYPASSED. Reconfiguration may not work.");
                    end
                    else if (m2_val[8:0] == 9'b000000000)
                        m2_val[9:0] = 10'b1000000000;
                    if (error == 1'b0)
                    begin
                        if (m2_mode_val === "bypass")
                            $display ("Warning : M2 counter switched from BYPASS mode to enabled (M2 modulus = %d). Pll may lose lock.", m2_val[9:0]);
                        else
                            $display(" M2 modulus = %d ", m2_val[9:0]);
                        m2_mode_val = "";
                    end
                end
                else if (scan_data[43] == 1'b1)
                begin
                    if (scan_data[34] !== 1'b0)
                    begin
                        reconfig_err = 1;
                        error = 1;
                        $display ("Warning : Illegal value for counter M2 in BYPASS mode. The LSB of the counter should be set to 0 in order to operate the counter in BYPASS mode. Reconfiguration may not work.");
                    end
                    else begin
                        if (m2_mode_val !== "bypass")
                            $display ("Warning : M2 counter switched from enabled to BYPASS mode. PLL may lose lock.");
                        m2_val[9:0] = 10'b0000000001;
                        m2_mode_val = "bypass";
                        $display(" M2 modulus = %d ", m2_val[9:0]);
                    end
                end
                if (m_mode_val != m2_mode_val)
                begin
                    reconfig_err = 1;
                    error = 1;
                    $display ("Warning : Incompatible modes for M1/M2 counters. Either both should be BYASSED or both NON-BYPASSED. Reconfiguration may not work.");
                end
            end

            m_time_delay_val = 32'b0;
            m_time_delay_val = scan_data[47:44];
            m_time_delay_val = m_time_delay_val * 250;
            if (m_time_delay_val > 3000)
                m_time_delay_val = 3000;
            if (skip_vco == "on")
                m_time_delay_val = 32'b0;
            $display("                                     M time delay = %0d", m_time_delay_val);

            // cntr N
            error = 0;
            n_val_tmp[8:0] = scan_data[8:0];
            if (scan_data[9] !== 1'b1)
            begin
                if (n_val_tmp[8:0] == 9'b000000001)
                begin
                    reconfig_err = 1;
                    error = 1;
                    $display ("Warning : Illegal 1 value for N counter. Instead, the N counter should be BYPASSED. Reconfiguration may not work.");
                end
                else if (n_val_tmp[8:0] == 9'b000000000)
                    n_val_tmp[9:0] = 10'b1000000000;
                if (error == 1'b0)
                begin
                    if (n_mode_val === "bypass")
                        $display ("Warning : N counter switched from BYPASS mode to enabled (N modulus = %d). PLL may lose lock.", n_val_tmp[9:0]);
                    else
                        $display("                                     N modulus = %d ", n_val_tmp[9:0]);
                    n_mode_val = "";
                end
            end
            else if (scan_data[9] == 1'b1)     // bypass
            begin
                if (scan_data[0] !== 1'b0)
                begin
                    reconfig_err = 1;
                    error = 1;
                    $display ("Warning : Illegal value for counter N in BYPASS mode. The LSB of the counter should be set to 0 in order to operate the counter in BYPASS mode. Reconfiguration may not work.");
                end
                else begin
                    if (n_mode_val !== "bypass")
                        $display ("Warning : N counter switched from enabled to BYPASS mode. PLL may lose lock.");
                    n_val_tmp[9:0] = 10'b0000000001;
                    n_mode_val = "bypass";
                    $display("                                     N modulus = %d ", n_val_tmp[9:0]);
                end
            end

            // cntr N2
            if (ss > 0)
            begin
                error = 0;
                n2_val[8:0] = scan_data[18:10];
                if (scan_data[19] !== 1'b1)
                begin
                    if (n2_val[8:0] == 9'b000000001)
                    begin
                        reconfig_err = 1;
                        error = 1;
                        $display ("Warning : Illegal 1 value for N2 counter. Instead, the N2 counter should be BYPASSED. Reconfiguration may not work.");
                    end
                    else if (n2_val[8:0] == 9'b000000000)
                        n2_val = 10'b1000000000;
                    if (error == 1'b0)
                    begin
                        if (n2_mode_val === "bypass")
                            $display ("Warning : N2 counter switched from BYPASS mode to enabled (N2 modulus = %d). PLL may lose lock.", n2_val[9:0]);
                        else
                            $display(" N2 modulus = %d ", n2_val[9:0]);
                        n2_mode_val = "";
                    end
                end
                else if (scan_data[19] == 1'b1)     // bypass
                begin
                    if (scan_data[10] !== 1'b0)
                    begin
                        reconfig_err = 1;
                        error = 1;
                        $display ("Warning : Illegal value for counter N2 in BYPASS mode. The LSB of the counter should be set to 0 in order to operate the counter in BYPASS mode. Reconfiguration may not work.");
                    end
                    else begin
                        if (n2_mode_val !== "bypass")
                            $display ("Warning : N2 counter switched from enabled to BYPASS mode. PLL may lose lock.");
                        n2_val[9:0] = 10'b0000000001;
                        n2_mode_val = "bypass";
                        $display(" N2 modulus = %d ", n2_val[9:0]);
                    end
                end
                if (n_mode_val != n2_mode_val)
                begin
                    reconfig_err = 1;
                    error = 1;
                    $display ("Warning : Incompatible modes for N1/N2 counters. Either both should be BYASSED or both NON-BYPASSED.");
                end
            end // ss > 0

            n_time_delay_val = 32'b0;
            n_time_delay_val = scan_data[23:20];
            n_time_delay_val = n_time_delay_val * 250;
            if (n_time_delay_val > 3000)
                n_time_delay_val = 3000;
            $display("                                     N time delay = %0d", n_time_delay_val);

            transfer <= 0;
            // clear the scan_chain
            for (i = 0; i <= scan_chain_length; i = i + 1)
                scan_data[i] = 0;
        end
    end

    always @(negedge transfer)
    begin
        if (l_scan_chain == "long")
        begin
            $display("                                     E3 high = %d, E3 low = %d, E3 mode = %s, E3 time delay = %0d", e3_high_val[9:0], e3_low_val[9:0], e3_mode_val, e3_time_delay_val);
            $display("                                     E2 high = %d, E2 low = %d, E2 mode = %s, E2 time delay = %0d", e2_high_val[9:0], e2_low_val[9:0], e2_mode_val, e2_time_delay_val);
            $display("                                     E1 high = %d, E1 low = %d, E1 mode = %s, E1 time delay = %0d", e1_high_val[9:0], e1_low_val[9:0], e1_mode_val, e1_time_delay_val);
            $display("                                     E0 high = %d, E0 low = %d, E0 mode = %s, E0 time delay = %0d", e0_high_val[9:0], e0_low_val[9:0], e0_mode_val, e0_time_delay_val);
        end
        $display("                                     L1 high = %d, L1 low = %d, L1 mode = %s, L1 time delay = %0d", l1_high_val[9:0], l1_low_val[9:0], l1_mode_val, l1_time_delay_val);
        $display("                                     L0 high = %d, L0 low = %d, L0 mode = %s, L0 time delay = %0d", l0_high_val[9:0], l0_low_val[9:0], l0_mode_val, l0_time_delay_val);
        $display("                                     G3 high = %d, G3 low = %d, G3 mode = %s, G3 time delay = %0d", g3_high_val[9:0], g3_low_val[9:0], g3_mode_val, g3_time_delay_val);
        $display("                                     G2 high = %d, G2 low = %d, G2 mode = %s, G2 time delay = %0d", g2_high_val[9:0], g2_low_val[9:0], g2_mode_val, g2_time_delay_val);
        $display("                                     G1 high = %d, G1 low = %d, G1 mode = %s, G1 time delay = %0d", g1_high_val[9:0], g1_low_val[9:0], g1_mode_val, g1_time_delay_val);
        $display("                                     G0 high = %d, G0 low = %d, G0 mode = %s, G0 time delay = %0d", g0_high_val[9:0], g0_low_val[9:0], g0_mode_val, g0_time_delay_val);
    end

always @(schedule_vco or areset_ipd or ena_ipd)
begin
    sched_time = 0;

    for (i = 0; i <= 7; i=i+1)
        last_phase_shift[i] = phase_shift[i];
 
    cycle_to_adjust = 0;
    l_index = 1;
    m_times_vco_period = new_m_times_vco_period;

    // give appropriate messages
    // if areset was asserted
    if (areset_ipd == 1'b1 && areset_ipd_last_value !== areset_ipd)
    begin
        $display (" Note : Stratix PLL was reset");
        $display ("Time: %0t  Instance: %m", $time);
    end

    // if ena was deasserted
    if (ena_ipd == 1'b0 && ena_ipd_last_value !== ena_ipd)
    begin
        $display (" Note : Stratix PLL was disabled");
        $display ("Time: %0t  Instance: %m", $time);
    end

    // illegal value on areset_ipd
    if (areset_ipd === 1'bx && (areset_ipd_last_value === 1'b0 || areset_ipd_last_value === 1'b1))
    begin
        $display("Warning : Illegal value 'X' detected on ARESET input");
        $display ("Time: %0t  Instance: %m", $time);
    end

    if ((schedule_vco !== schedule_vco_last_value) && (areset_ipd == 1'b1 || ena_ipd == 1'b0 || stop_vco == 1'b1))
    begin
            if (areset_ipd === 1'b1)
                pll_is_in_reset = 1;

        // drop VCO taps to 0
        for (i = 0; i <= 7; i=i+1)
        begin
            for (j = 0; j <= last_phase_shift[i] + 1; j=j+1)
                vco_out[i] <= #(j) 1'b0;
            phase_shift[i] = 0;
            last_phase_shift[i] = 0;
        end

        // reset lock parameters
        locked_tmp = 0;
        if (l_pll_type == "fast")
            locked_tmp = 1;
        pll_is_locked = 0;
        pll_about_to_lock = 0;
        cycles_to_lock = 0;
        cycles_to_unlock = 0;

        got_first_refclk = 0;
        got_second_refclk = 0;
        refclk_time = 0;
        got_first_fbclk = 0;
        fbclk_time = 0;
        first_fbclk_time = 0;
        fbclk_period = 0;

        first_schedule = 1;
        schedule_offset = 1;
        vco_val = 0;
        vco_period_was_phase_adjusted = 0;
        phase_adjust_was_scheduled = 0;

        // reset enable0 and enable1 counter parameters
//      l0_count = 1;
//      l1_count = 1;
//      l0_got_first_rising_edge = 0;
//      l1_got_first_rising_edge = 0;

    end else if (ena_ipd === 1'b1 && areset_ipd === 1'b0 && stop_vco === 1'b0)
    begin

        // else note areset deassert time
        // note it as refclk_time to prevent false triggering
        // of stop_vco after areset
        if (areset_ipd === 1'b0 && areset_ipd_last_value === 1'b1 && pll_is_in_reset === 1'b1)
        begin
            refclk_time = $time;
            pll_is_in_reset = 0;
        end

        // calculate loop_xplier : this will be different from m_val in ext. fbk mode
        loop_xplier = m_val;
        loop_initial = i_m_initial - 1;
        loop_ph = i_m_ph;
        loop_time_delay = m_time_delay_val;

        if (l_operation_mode == "external_feedback")
        begin
            if (ext_fbk_cntr_mode == "bypass")
                ext_fbk_cntr_modulus = 1;
            else
                ext_fbk_cntr_modulus = ext_fbk_cntr_high + ext_fbk_cntr_low;

            loop_xplier = m_val * (ext_fbk_cntr_modulus);
            loop_ph = ext_fbk_cntr_ph;
            loop_initial = ext_fbk_cntr_initial - 1 + ((i_m_initial - 1) * (ext_fbk_cntr_modulus));
            loop_time_delay = m_time_delay_val + ext_fbk_cntr_delay;
        end

        // convert initial value to delay
        initial_delay = (loop_initial * m_times_vco_period)/loop_xplier;

        // convert loop ph_tap to delay
        rem = m_times_vco_period % loop_xplier;
        vco_per = m_times_vco_period/loop_xplier;
        if (rem != 0)
            vco_per = vco_per + 1;
        fbk_phase = (loop_ph * vco_per)/8;

        if (l_operation_mode == "external_feedback")
        begin
            pull_back_ext_cntr = ext_fbk_cntr_delay + (ext_fbk_cntr_initial - 1) * (m_times_vco_period/loop_xplier) + fbk_phase;

            while (pull_back_ext_cntr > refclk_period)
                pull_back_ext_cntr = pull_back_ext_cntr - refclk_period;

            pull_back_M =  m_time_delay_val + (i_m_initial - 1) * (ext_fbk_cntr_modulus) * (m_times_vco_period/loop_xplier);

            while (pull_back_M > refclk_period)
                pull_back_M = pull_back_M - refclk_period;
        end
        else begin
            pull_back_ext_cntr = 0;
            pull_back_M = initial_delay + m_time_delay_val + fbk_phase;
        end

        total_pull_back = pull_back_M + pull_back_ext_cntr;
        if (l_simulation_type == "timing")
            total_pull_back = total_pull_back + pll_compensation_delay;

        while (total_pull_back > refclk_period)
            total_pull_back = total_pull_back - refclk_period;

        if (total_pull_back > 0)
            offset = refclk_period - total_pull_back;

        if (l_operation_mode == "external_feedback")
        begin
            fbk_delay = pull_back_M;
            if (l_simulation_type == "timing")
                fbk_delay = fbk_delay + pll_compensation_delay;

            ext_fbk_delay = pull_back_ext_cntr - fbk_phase;
        end
        else begin
            fbk_delay = total_pull_back - fbk_phase;
            if (fbk_delay < 0)
            begin
                offset = offset - fbk_phase;
                fbk_delay = total_pull_back;
            end
        end

        // assign m_delay
        m_delay = fbk_delay;

        for (i = 1; i <= loop_xplier; i=i+1)
        begin
            // adjust cycles
            tmp_vco_per = m_times_vco_period/loop_xplier;
            if (rem != 0 && l_index <= rem)
            begin
                tmp_rem = (loop_xplier * l_index) % rem;
                cycle_to_adjust = (loop_xplier * l_index) / rem;
                if (tmp_rem != 0)
                    cycle_to_adjust = cycle_to_adjust + 1;
            end
            if (cycle_to_adjust == i)
            begin
                tmp_vco_per = tmp_vco_per + 1;
                l_index = l_index + 1;
            end

            // calculate high and low periods
            high_time = tmp_vco_per/2;
            if (tmp_vco_per % 2 != 0)
                high_time = high_time + 1;
            low_time = tmp_vco_per - high_time;

            // schedule the rising and falling egdes
            for (j=0; j<=1; j=j+1)
            begin
                vco_val = ~vco_val;
                if (vco_val == 1'b0)
                    sched_time = sched_time + high_time;
                else
                    sched_time = sched_time + low_time;

                // add offset
                if (schedule_offset == 1'b1)
                begin
                    sched_time = sched_time + offset;
                    schedule_offset = 0;
                end

                // schedule taps with appropriate phase shifts
                for (k = 0; k <= 7; k=k+1)
                begin
                    phase_shift[k] = (k*tmp_vco_per)/8;
                    if (first_schedule)
                        vco_out[k] <= #(sched_time + phase_shift[k]) vco_val;
                    else
                        vco_out[k] <= #(sched_time + last_phase_shift[k]) vco_val;
                end
            end
        end
        if (first_schedule)
        begin
            vco_val = ~vco_val;
            if (vco_val == 1'b0)
                sched_time = sched_time + high_time;
            else
                sched_time = sched_time + low_time;
            for (k = 0; k <= 7; k=k+1)
            begin
                phase_shift[k] = (k*tmp_vco_per)/8;
                vco_out[k] <= #(sched_time+phase_shift[k]) vco_val;
            end
            first_schedule = 0;
        end

        // this may no longer be required

        schedule_vco <= #(sched_time) ~schedule_vco;
        if (vco_period_was_phase_adjusted)
        begin
            m_times_vco_period = refclk_period;
            new_m_times_vco_period = refclk_period;
            vco_period_was_phase_adjusted = 0;
            phase_adjust_was_scheduled = 1;

            tmp_vco_per = m_times_vco_period/loop_xplier;
            for (k = 0; k <= 7; k=k+1)
                phase_shift[k] = (k*tmp_vco_per)/8;
        end
    end

    areset_ipd_last_value = areset_ipd;
    ena_ipd_last_value = ena_ipd;
    schedule_vco_last_value = schedule_vco;

end

always @(pfdena_ipd)
begin
    if (pfdena_ipd === 1'b0)
    begin
        locked_tmp = 1'bx;
        pll_is_locked = 0;
        cycles_to_lock = 0;
        $display (" Note : PFDENA was deasserted");
        $display ("Time: %0t  Instance: %m", $time);
    end
    else if (pfdena_ipd === 1'b1 && pfdena_ipd_last_value === 1'b0)
    begin
        // PFD was disabled, now enabled again
        got_first_refclk = 0;
        got_second_refclk = 0;
        refclk_time = $time;
    end
    pfdena_ipd_last_value = pfdena_ipd;
end

always @(negedge refclk)
begin
    refclk_last_value = refclk;
end

always @(negedge fbclk)
begin
    fbclk_last_value = fbclk;
end

always @(posedge refclk or posedge fbclk)
begin
    if (refclk == 1'b1 && refclk_last_value !== refclk && areset_ipd === 1'b0)
    begin
        n_val <= n_val_tmp;
        if (! got_first_refclk)
        begin
            got_first_refclk = 1;
        end else
        begin
            got_second_refclk = 1;
            refclk_period = $time - refclk_time;

            // check if incoming freq. will cause VCO range to be
            // exceeded
            if ( (vco_max != 0 && vco_min != 0) && (skip_vco == "off") && (pfdena_ipd === 1'b1) &&
                ((refclk_period/loop_xplier > vco_max) ||
                (refclk_period/loop_xplier < vco_min)) )
            begin
                if (pll_is_locked == 1'b1)
                begin
                    $display ("Warning : Input clock freq. is not within VCO range. PLL may lose lock");
                    $display ("Time: %0t  Instance: %m", $time);
                    if (inclk_out_of_range === 1'b1)
                    begin
                        // unlock
                        pll_is_locked = 0;
                        locked_tmp = 0;
                        if (l_pll_type == "fast")
                            locked_tmp = 1;
                        pll_about_to_lock = 0;
                        cycles_to_lock = 0;
                        $display ("Note : Stratix PLL lost lock");
                        $display ("Time: %0t  Instance: %m", $time);
                        first_schedule = 1;
                        schedule_offset = 1;
                        vco_period_was_phase_adjusted = 0;
                        phase_adjust_was_scheduled = 0;
                    end
                end
                else begin
                    if (no_warn == 0)
                    begin
                        $display ("Warning : Input clock freq. is not within VCO range. PLL may not lock");
                        $display ("Time: %0t  Instance: %m", $time);
                        no_warn = 1;
                    end
                end
                inclk_out_of_range = 1;
            end
            else if ( vco_min == 0 && vco_max == 0 && pll_type == "cdr")
            begin
                if (refclk_period != primary_clock_frequency)
                begin
                    if (no_warn == 0)
                    begin
                        $display("Warning : Incoming clock period %d for Stratix PLL does not match the specified inclock period %d. ALTGXB simulation may not function correctly.", refclk_period, primary_clock_frequency);
                        $display ("Time: %0t  Instance: %m", $time);
                        no_warn = 1;
                    end
                end
            end
            else begin
                inclk_out_of_range = 0;
            end

        end
        if (stop_vco == 1'b1)
        begin
            stop_vco = 0;
            schedule_vco = ~schedule_vco;
        end
        refclk_time = $time;
    end

    if (fbclk == 1'b1 && fbclk_last_value !== fbclk)
    begin
        m_val <= m_val_tmp;
        if (!got_first_fbclk)
        begin
            got_first_fbclk = 1;
            first_fbclk_time = $time;
        end
        else
            fbclk_period = $time - fbclk_time;

        // need refclk_period here, so initialized to proper value above
        if ( ( ($time - refclk_time > 1.5 * refclk_period) && pfdena_ipd === 1'b1 && pll_is_locked == 1'b1) || ( ($time - refclk_time > 5 * refclk_period) && pfdena_ipd === 1'b1) )
        begin
            stop_vco = 1;
            // reset
            got_first_refclk = 0;
            got_first_fbclk = 0;
            got_second_refclk = 0;
            if (pll_is_locked == 1'b1)
            begin
                pll_is_locked = 0;
                locked_tmp = 0;
                if (l_pll_type == "fast")
                    locked_tmp = 1;
                $display ("Note : Stratix PLL lost lock due to loss of input clock");
                $display ("Time: %0t  Instance: %m", $time);
            end
            pll_about_to_lock = 0;
            cycles_to_lock = 0;
            cycles_to_unlock = 0;
            first_schedule = 1;
            vco_period_was_phase_adjusted = 0;
            phase_adjust_was_scheduled = 0;
        end
        fbclk_time = $time;
    end

    if (got_second_refclk && pfdena_ipd === 1'b1 && (!inclk_out_of_range))
    begin
        // now we know actual incoming period
//       if (abs(refclk_period - fbclk_period) > 2)
//       begin
//           new_m_times_vco_period = refclk_period;
//       end
//       else if (abs(fbclk_time - refclk_time) <= 2 || (refclk_period - abs(fbclk_time - refclk_time) <= 2))
        if (abs(fbclk_time - refclk_time) <= 5 || (got_first_fbclk && abs(refclk_period - abs(fbclk_time - refclk_time)) <= 5))
        begin
            // considered in phase
            if (cycles_to_lock == valid_lock_multiplier - 1)
                pll_about_to_lock <= 1;
            if (cycles_to_lock == valid_lock_multiplier)
            begin
                if (pll_is_locked === 1'b0)
                begin
                    $display (" Note : Stratix PLL locked to incoming clock");
                    $display ("Time: %0t  Instance: %m", $time);
                end
                pll_is_locked = 1;
                locked_tmp = 1;
                if (l_pll_type == "fast")
                    locked_tmp = 0;
            end
            // increment lock counter only if the second part of the above
            // time check is NOT true
            if (!(abs(refclk_period - abs(fbclk_time - refclk_time)) <= 5))
            begin
                cycles_to_lock = cycles_to_lock + 1;
            end

            // adjust m_times_vco_period
            new_m_times_vco_period = refclk_period;

        end else
        begin
            // if locked, begin unlock
            if (pll_is_locked)
            begin
                cycles_to_unlock = cycles_to_unlock + 1;
                if (cycles_to_unlock == invalid_lock_multiplier)
                begin
                    pll_is_locked = 0;
                    locked_tmp = 0;
                    if (l_pll_type == "fast")
                        locked_tmp = 1;
                    pll_about_to_lock = 0;
                    cycles_to_lock = 0;
                    $display ("Note : Stratix PLL lost lock");
                    $display ("Time: %0t  Instance: %m", $time);
                    first_schedule = 1;
                    schedule_offset = 1;
                    vco_period_was_phase_adjusted = 0;
                    phase_adjust_was_scheduled = 0;
                end
            end
            if (abs(refclk_period - fbclk_period) <= 2)
            begin
                // frequency is still good
                if ($time == fbclk_time && (!phase_adjust_was_scheduled))
                begin
                    if (abs(fbclk_time - refclk_time) > refclk_period/2)
                    begin
                        if (abs(fbclk_time - refclk_time) > 1.5 * refclk_period)
                        begin
                            // input clock may have stopped : do nothing
                        end
                        else begin
                        new_m_times_vco_period = m_times_vco_period + (refclk_period - abs(fbclk_time - refclk_time));
                        vco_period_was_phase_adjusted = 1;
                        end
                    end else
                    begin
                        new_m_times_vco_period = m_times_vco_period - abs(fbclk_time - refclk_time);
                        vco_period_was_phase_adjusted = 1;
                    end
                end
            end else
            begin
                new_m_times_vco_period = refclk_period;
                phase_adjust_was_scheduled = 0;
            end
        end
    end

    if (quiet_period_violation == 1'b1 || reconfig_err == 1'b1 || scanclr_violation == 1'b1 || scanclr_clk_violation == 1'b1)
    begin
        locked_tmp = 0;
        if (l_pll_type == "fast")
            locked_tmp = 1;
    end

    refclk_last_value = refclk;
    fbclk_last_value = fbclk;
end

    assign clk0_tmp = i_clk0_counter == "l0" ? l0_clk : i_clk0_counter == "l1" ? l1_clk : i_clk0_counter == "g0" ? g0_clk : i_clk0_counter == "g1" ? g1_clk : i_clk0_counter == "g2" ? g2_clk : i_clk0_counter == "g3" ? g3_clk : 'b0;

    assign clk0 = (areset_ipd === 1'b1 || ena_ipd === 1'b0) || (pll_about_to_lock == 1'b1 && !quiet_period_violation && !reconfig_err && !scanclr_violation && !scanclr_clk_violation) ? clk0_tmp : 'bx;

    altgxb_dffe ena0_reg ( .D(clkena0_ipd),
                            .CLRN(1'b1),
                            .PRN(1'b1),
                            .ENA(1'b1),
                            .CLK(!clk0_tmp),
                            .Q(ena0));

    assign clk1_tmp = i_clk1_counter == "l0" ? l0_clk : i_clk1_counter == "l1" ? l1_clk : i_clk1_counter == "g0" ? g0_clk : i_clk1_counter == "g1" ? g1_clk : i_clk1_counter == "g2" ? g2_clk : i_clk1_counter == "g3" ? g3_clk : 'b0;

    assign clk1 = (areset_ipd === 1'b1 || ena_ipd === 1'b0) || (pll_about_to_lock == 1'b1 && !quiet_period_violation && !reconfig_err && !scanclr_violation && !scanclr_clk_violation) ? clk1_tmp : 'bx;

    altgxb_dffe ena1_reg ( .D(clkena1_ipd),
                            .CLRN(1'b1),
                            .PRN(1'b1),
                            .ENA(1'b1),
                            .CLK(!clk1_tmp),
                            .Q(ena1));

    assign clk2_tmp = i_clk2_counter == "l0" ? l0_clk : i_clk2_counter == "l1" ? l1_clk : i_clk2_counter == "g0" ? g0_clk : i_clk2_counter == "g1" ? g1_clk : i_clk2_counter == "g2" ? g2_clk : i_clk2_counter == "g3" ? g3_clk : 'b0;

    assign clk2 = (areset_ipd === 1'b1 || ena_ipd === 1'b0) || (pll_about_to_lock == 1'b1 && !quiet_period_violation && !reconfig_err && !scanclr_violation && !scanclr_clk_violation) ? clk2_tmp : 'bx;

    altgxb_dffe ena2_reg ( .D(clkena2_ipd),
                            .CLRN(1'b1),
                            .PRN(1'b1),
                            .ENA(1'b1),
                            .CLK(!clk2_tmp),
                            .Q(ena2));

    assign clk3_tmp = i_clk3_counter == "l0" ? l0_clk : i_clk3_counter == "l1" ? l1_clk : i_clk3_counter == "g0" ? g0_clk : i_clk3_counter == "g1" ? g1_clk : i_clk3_counter == "g2" ? g2_clk : i_clk3_counter == "g3" ? g3_clk : 'b0;

    assign clk3 = (areset_ipd === 1'b1 || ena_ipd === 1'b0) || (pll_about_to_lock == 1'b1 && !quiet_period_violation && !reconfig_err && !scanclr_violation && !scanclr_clk_violation) ? clk3_tmp : 'bx;

    altgxb_dffe ena3_reg ( .D(clkena3_ipd),
                            .CLRN(1'b1),
                            .PRN(1'b1),
                            .ENA(1'b1),
                            .CLK(!clk3_tmp),
                            .Q(ena3));

    assign clk4_tmp = i_clk4_counter == "l0" ? l0_clk : i_clk4_counter == "l1" ? l1_clk : i_clk4_counter == "g0" ? g0_clk : i_clk4_counter == "g1" ? g1_clk : i_clk4_counter == "g2" ? g2_clk : i_clk4_counter == "g3" ? g3_clk : 'b0;

    assign clk4 = (areset_ipd === 1'b1 || ena_ipd === 1'b0) || (pll_about_to_lock == 1'b1 && !quiet_period_violation && !reconfig_err && !scanclr_violation && !scanclr_clk_violation) ? clk4_tmp : 'bx;

    altgxb_dffe ena4_reg ( .D(clkena4_ipd),
                            .CLRN(1'b1),
                            .PRN(1'b1),
                            .ENA(1'b1),
                            .CLK(!clk4_tmp),
                            .Q(ena4));

    assign clk5_tmp = i_clk5_counter == "l0" ? l0_clk : i_clk5_counter == "l1" ? l1_clk : i_clk5_counter == "g0" ? g0_clk : i_clk5_counter == "g1" ? g1_clk : i_clk5_counter == "g2" ? g2_clk : i_clk5_counter == "g3" ? g3_clk : 'b0;

    assign clk5 = (areset_ipd === 1'b1 || ena_ipd === 1'b0) || (pll_about_to_lock == 1'b1 && !quiet_period_violation && !reconfig_err && !scanclr_violation && !scanclr_clk_violation) ? clk5_tmp : 'bx;

    altgxb_dffe ena5_reg ( .D(clkena5_ipd),
                            .CLRN(1'b1),
                            .PRN(1'b1),
                            .ENA(1'b1),
                            .CLK(!clk5_tmp),
                            .Q(ena5));

    assign extclk0_tmp = i_extclk0_counter == "e0" ? e0_clk : i_extclk0_counter == "e1" ? e1_clk : i_extclk0_counter == "e2" ? e2_clk : i_extclk0_counter == "e3" ? e3_clk : i_extclk0_counter == "g0" ? g0_clk : 'b0;

    assign extclk0 = (areset_ipd === 1'b1 || ena_ipd === 1'b0) || (pll_about_to_lock == 1'b1 && !quiet_period_violation && !reconfig_err && !scanclr_violation && !scanclr_clk_violation) ? extclk0_tmp : 'bx;

    altgxb_dffe extena0_reg  ( .D(extclkena0_ipd),
                                .CLRN(1'b1),
                                .PRN(1'b1),
                                .ENA(1'b1),
                                .CLK(!extclk0_tmp),
                                .Q(extena0));

    assign extclk1_tmp = i_extclk1_counter == "e0" ? e0_clk : i_extclk1_counter == "e1" ? e1_clk : i_extclk1_counter == "e2" ? e2_clk : i_extclk1_counter == "e3" ? e3_clk : i_extclk1_counter == "g0" ? g0_clk : 'b0;

    assign extclk1 = (areset_ipd === 1'b1 || ena_ipd === 1'b0) || (pll_about_to_lock == 1'b1 && !quiet_period_violation && !reconfig_err && !scanclr_violation && !scanclr_clk_violation) ? extclk1_tmp : 'bx;

    altgxb_dffe extena1_reg  ( .D(extclkena1_ipd),
                                .CLRN(1'b1),
                                .PRN(1'b1),
                                .ENA(1'b1),
                                .CLK(!extclk1_tmp),
                                .Q(extena1));

    assign extclk2_tmp = i_extclk2_counter == "e0" ? e0_clk : i_extclk2_counter == "e1" ? e1_clk : i_extclk2_counter == "e2" ? e2_clk : i_extclk2_counter == "e3" ? e3_clk : i_extclk2_counter == "g0" ? g0_clk : 'b0;

    assign extclk2 = (areset_ipd === 1'b1 || ena_ipd === 1'b0) || (pll_about_to_lock == 1'b1 && !quiet_period_violation && !reconfig_err && !scanclr_violation && !scanclr_clk_violation) ? extclk2_tmp : 'bx;

    altgxb_dffe extena2_reg  ( .D(extclkena2_ipd),
                                .CLRN(1'b1),
                                .PRN(1'b1),
                                .ENA(1'b1),
                                .CLK(!extclk2_tmp),
                                .Q(extena2));

    assign extclk3_tmp = i_extclk3_counter == "e0" ? e0_clk : i_extclk3_counter == "e1" ? e1_clk : i_extclk3_counter == "e2" ? e2_clk : i_extclk3_counter == "e3" ? e3_clk : i_extclk3_counter == "g0" ? g0_clk : 'b0;

    assign extclk3 = (areset_ipd === 1'b1 || ena_ipd === 1'b0) || (pll_about_to_lock == 1'b1 && !quiet_period_violation && !reconfig_err && !scanclr_violation && !scanclr_clk_violation) ? extclk3_tmp : 'bx;

    altgxb_dffe extena3_reg  ( .D(extclkena3_ipd),
                                .CLRN(1'b1),
                                .PRN(1'b1),
                                .ENA(1'b1),
                                .CLK(!extclk3_tmp),
                                .Q(extena3));

    assign enable_0 = (areset_ipd === 1'b1 || ena_ipd === 1'b0) || pll_about_to_lock == 1'b1 ? enable0_tmp : 'bx;
    assign enable_1 = (areset_ipd === 1'b1 || ena_ipd === 1'b0) || pll_about_to_lock == 1'b1 ? enable1_tmp : 'bx;

    // ACCELERATE OUTPUTS
    and (clk[0], ena0, clk0);
    and (clk[1], ena1, clk1);
    and (clk[2], ena2, clk2);
    and (clk[3], ena3, clk3);
    and (clk[4], ena4, clk4);
    and (clk[5], ena5, clk5);

    and (extclk[0], extena0, extclk0);
    and (extclk[1], extena1, extclk1);
    and (extclk[2], extena2, extclk2);
    and (extclk[3], extena3, extclk3);

    and (enable0, 1'b1, enable_0);
    and (enable1, 1'b1, enable_1);

    and (scandataout, 1'b1, scandataout_tmp);

endmodule // altgxb_stratix_pll

// START MODULE NAME -----------------------------------------------------------
//
// Module Name : altgxb_pll
//
// Description : Phase-Locked Loop (PLL) behavioral model. Model supports basic
//               PLL features such as clock division and multiplication,
//               programmable duty cycle and phase shifts, various feedback modes
//               and clock delays. Also supports real-time reconfiguration of
//               PLL "parameters" and clock switchover between the 2 input
//               reference clocks. Up to 10 clock outputs may be used.
//
// Limitations : Applicable to Stratix and Stratix-GX device families only
//               There is no support in the model for spread-spectrum feature
//
// Expected results : Up to 10 output clocks, each defined by its own set of
//                    parameters. Locked output (active high) indicates when the
//                    PLL locks. clkbad, clkloss and activeclock are used for
//                    clock switchover to inidicate which input clock has gone
//                    bad, when the clock switchover initiates and which input
//                    clock is being used as the reference, respectively.
//                    scandataout is the data output of the serial scan chain.

//END MODULE NAME --------------------------------------------------------------

`timescale 1 ps / 1ps

// MODULE DECLARATION
module altgxb_pll (   
    inclk,      // input reference clock - up to 2 can be used
    fbin,       // external feedback input port
    pllena,     // PLL enable signal
    clkswitch,  // switch between inclk0 and inclk1
    areset,     // asynchronous reset
    pfdena,     // enable the Phase Frequency Detector (PFD)
    clkena,     // enable clk0 to clk5 clock outputs
    extclkena,  // enable extclk0 to extclk3 clock outputs
    scanclk,    // clock for the serial scan chain
    scanaclr,   // asynchronous clear the serial scan chain
    scandata,   // data for the scan chain
    clk,        // internal clock outputs (feeds the core)
    extclk,     // external clock outputs (feeds pins)
    clkbad,     // indicates if inclk0/inclk1 has gone bad
    activeclock,// indicates which input clock is being used
    clkloss,    // indicates when clock switchover initiates
    locked,     // indicates when the PLL locks onto the input clock
    scandataout // data output of the serial scan chain
);

// GLOBAL PARAMETER DECLARATION
parameter   intended_device_family    = "Stratix" ;
parameter   operation_mode            = "NORMAL" ;
parameter   pll_type                  = "AUTO" ;
parameter   qualify_conf_done         = "OFF" ;
parameter   compensate_clock          = "CLK0" ;
parameter   scan_chain                = "LONG";
parameter   primary_clock             = "inclk0";
parameter   inclk0_input_frequency    = 1000;
parameter   inclk1_input_frequency    = 1000;
parameter   gate_lock_signal          = "NO";
parameter   gate_lock_counter         = 0;
parameter   lock_high                 = 1;
parameter   lock_low                  = 5;
parameter   valid_lock_multiplier     = 1;
parameter   invalid_lock_multiplier   = 5;
parameter   switch_over_on_lossclk    = "OFF" ;
parameter   switch_over_on_gated_lock = "OFF" ;
parameter   enable_switch_over_counter = "OFF";
parameter   switch_over_counter       = 0;
parameter   feedback_source           = "EXTCLK0" ;
parameter   bandwidth                 = 0;
parameter   bandwidth_type            = "UNUSED";
parameter   spread_frequency          = 0;
parameter   down_spread               = "0.0";
// simulation-only parameters
parameter   simulation_type           = "functional";

parameter   skip_vco                    = "off";

//  internal clock specifications
parameter   clk5_multiply_by        = 1;
parameter   clk4_multiply_by        = 1;
parameter   clk3_multiply_by        = 1;
parameter   clk2_multiply_by        = 1;
parameter   clk1_multiply_by        = 1;
parameter   clk0_multiply_by        = 1;
parameter   clk5_divide_by          = 1;
parameter   clk4_divide_by          = 1;
parameter   clk3_divide_by          = 1;
parameter   clk2_divide_by          = 1;
parameter   clk1_divide_by          = 1;
parameter   clk0_divide_by          = 1;
parameter   clk5_phase_shift        = "0";
parameter   clk4_phase_shift        = "0";
parameter   clk3_phase_shift        = "0";
parameter   clk2_phase_shift        = "0";
parameter   clk1_phase_shift        = "0";
parameter   clk0_phase_shift        = "0";
// the 3 phase_shift_num parameters are for altlvds use only
parameter   clk2_phase_shift_num    = 0;
parameter   clk1_phase_shift_num    = 0;
parameter   clk0_phase_shift_num    = 0;
parameter   clk5_time_delay         = "0";
parameter   clk4_time_delay         = "0";
parameter   clk3_time_delay         = "0";
parameter   clk2_time_delay         = "0";
parameter   clk1_time_delay         = "0";
parameter   clk0_time_delay         = "0";
parameter   clk5_duty_cycle         = 50;
parameter   clk4_duty_cycle         = 50;
parameter   clk3_duty_cycle         = 50;
parameter   clk2_duty_cycle         = 50;
parameter   clk1_duty_cycle         = 50;
parameter   clk0_duty_cycle         = 50;
//  external clock specifications
parameter   extclk3_multiply_by     = 1;
parameter   extclk2_multiply_by     = 1;
parameter   extclk1_multiply_by     = 1;
parameter   extclk0_multiply_by     = 1;
parameter   extclk3_divide_by       = 1;
parameter   extclk2_divide_by       = 1;
parameter   extclk1_divide_by       = 1;
parameter   extclk0_divide_by       = 1;
parameter   extclk3_phase_shift     = "0";
parameter   extclk2_phase_shift     = "0";
parameter   extclk1_phase_shift     = "0";
parameter   extclk0_phase_shift     = "0";
parameter   extclk3_time_delay      = "0";
parameter   extclk2_time_delay      = "0";
parameter   extclk1_time_delay      = "0";
parameter   extclk0_time_delay      = "0";
parameter   extclk3_duty_cycle      = 50;
parameter   extclk2_duty_cycle      = 50;
parameter   extclk1_duty_cycle      = 50;
parameter   extclk0_duty_cycle      = 50;
//  advanced user parameters
parameter   vco_min             = 0;
parameter   vco_max             = 0;
parameter   vco_center          = 0;
parameter   pfd_min             = 0;
parameter   pfd_max             = 0;
parameter   m_initial           = 1;
parameter   m                   = 0; // m must default to 0 in order for altpll to calculate advanced parameters for itself
parameter   n                   = 1;
parameter   m2                  = 1;
parameter   n2                  = 1;
parameter   ss                  = 1;
parameter   l0_high             = 1;
parameter   l1_high             = 1;
parameter   g0_high             = 1;
parameter   g1_high             = 1;
parameter   g2_high             = 1;
parameter   g3_high             = 1;
parameter   e0_high             = 1;
parameter   e1_high             = 1;
parameter   e2_high             = 1;
parameter   e3_high             = 1;
parameter   l0_low              = 1;
parameter   l1_low              = 1;
parameter   g0_low              = 1;
parameter   g1_low              = 1;
parameter   g2_low              = 1;
parameter   g3_low              = 1;
parameter   e0_low              = 1;
parameter   e1_low              = 1;
parameter   e2_low              = 1;
parameter   e3_low              = 1;
parameter   l0_initial          = 1;
parameter   l1_initial          = 1;
parameter   g0_initial          = 1;
parameter   g1_initial          = 1;
parameter   g2_initial          = 1;
parameter   g3_initial          = 1;
parameter   e0_initial          = 1;
parameter   e1_initial          = 1;
parameter   e2_initial          = 1;
parameter   e3_initial          = 1;
parameter   l0_mode             = "bypass";
parameter   l1_mode             = "bypass";
parameter   g0_mode             = "bypass";
parameter   g1_mode             = "bypass";
parameter   g2_mode             = "bypass";
parameter   g3_mode             = "bypass";
parameter   e0_mode             = "bypass";
parameter   e1_mode             = "bypass";
parameter   e2_mode             = "bypass";
parameter   e3_mode             = "bypass";
parameter   l0_ph               = 0;
parameter   l1_ph               = 0;
parameter   g0_ph               = 0;
parameter   g1_ph               = 0;
parameter   g2_ph               = 0;
parameter   g3_ph               = 0;
parameter   e0_ph               = 0;
parameter   e1_ph               = 0;
parameter   e2_ph               = 0;
parameter   e3_ph               = 0;
parameter   m_ph                = 0;
parameter   l0_time_delay       = 0;
parameter   l1_time_delay       = 0;
parameter   g0_time_delay       = 0;
parameter   g1_time_delay       = 0;
parameter   g2_time_delay       = 0;
parameter   g3_time_delay       = 0;
parameter   e0_time_delay       = 0;
parameter   e1_time_delay       = 0;
parameter   e2_time_delay       = 0;
parameter   e3_time_delay       = 0;
parameter   m_time_delay        = 0;
parameter   n_time_delay        = 0;
parameter   extclk3_counter     = "e3" ;
parameter   extclk2_counter     = "e2" ;
parameter   extclk1_counter     = "e1" ;
parameter   extclk0_counter     = "e0" ;
parameter   clk5_counter        = "l1" ;
parameter   clk4_counter        = "l0" ;
parameter   clk3_counter        = "g3" ;
parameter   clk2_counter        = "g2" ;
parameter   clk1_counter        = "g1" ;
parameter   clk0_counter        = "g0" ;
parameter   enable0_counter     = "l0";
parameter   enable1_counter     = "l0";
parameter   charge_pump_current = 2;
parameter   loop_filter_r       = "1.0";
parameter   loop_filter_c       = 5;
parameter   lpm_type            = "altpll";

// INPUT PORT DECLARATION
input       [1:0] inclk;
input       fbin;
input       pllena;
input       clkswitch;
input       areset;
input       pfdena;
input       [5:0] clkena;
input       [3:0] extclkena;
input       scanclk;
input       scanaclr;
input       scandata;

// OUTPUT PORT DECLARATION
output        [5:0] clk;
output        [3:0] extclk;
output        [1:0] clkbad;
output        activeclock;
output        clkloss;
output        locked;
output        scandataout;

// pullups
tri1 fbin_pullup;
tri1 ena_pullup;
tri1 pfdena_pullup;
tri1 [5:0] clkena_pullup;
tri1 [3:0] extclkena_pullup;

// pulldowns
tri0 [1:0] inclk_pulldown;
tri0 clkswitch_pulldown;
tri0 areset_pulldown;
tri0 scanclr_pulldown;
tri0 scandata_pulldown;

assign fbin_pullup = fbin;
assign ena_pullup = pllena;
assign pfdena_pullup = pfdena;
assign clkena_pullup = clkena;
assign extclkena_pullup = extclkena;
assign scandata_pulldown = scandata;
assign inclk_pulldown = inclk;
assign clkswitch_pulldown = clkswitch;
assign areset_pulldown = areset;
assign scanclr_pulldown = scanaclr;

// For fast mode, the stratix pll atom model will give active low signal on locked output.
// Therefore, need to invert the lock signal for fast mode as in user view, locked signal is
// always active high.
wire locked_tmp;

assign locked = ((pll_type == "fast") || (pll_type == "FAST")) ? (!locked_tmp) : locked_tmp;

// COMPONENT INSTANTIATION
altgxb_stratix_pll pll0
(
    .inclk (inclk_pulldown),
    .fbin (fbin_pullup),
    .ena (ena_pullup),
    .clkswitch (clkswitch_pulldown),
    .areset (areset_pulldown),
    .pfdena (pfdena_pullup),
    .clkena (clkena_pullup),
    .extclkena (extclkena_pullup),
    .scanclk (scanclk),
    .scanaclr (scanclr_pulldown),
    .scandata (scandata_pulldown),
    .comparator (1'b0),
    .clk (clk),
    .extclk (extclk),
    .clkbad (clkbad),
    .activeclock (activeclock),
    .locked (locked_tmp),
    .clkloss (clkloss),
    .scandataout (scandataout),
    .enable0 (),
    .enable1 ()
);
    defparam
        pll0.operation_mode         = operation_mode,
        pll0.pll_type               = pll_type,
        pll0.qualify_conf_done      = qualify_conf_done,
        pll0.compensate_clock       = compensate_clock,
        pll0.scan_chain             = scan_chain,
        pll0.primary_clock          = primary_clock,
        pll0.inclk0_input_frequency = inclk0_input_frequency,
        pll0.inclk1_input_frequency = inclk1_input_frequency,
        pll0.gate_lock_signal       = gate_lock_signal,
        pll0.gate_lock_counter      = gate_lock_counter,
        pll0.valid_lock_multiplier  = valid_lock_multiplier,
        pll0.invalid_lock_multiplier = invalid_lock_multiplier,
        pll0.switch_over_on_lossclk = switch_over_on_lossclk,
        pll0.switch_over_on_gated_lock = switch_over_on_gated_lock,
        pll0.enable_switch_over_counter = enable_switch_over_counter,
        pll0.switch_over_counter    = switch_over_counter,
        pll0.feedback_source        = feedback_source,
        pll0.bandwidth              = bandwidth,
        pll0.bandwidth_type         = bandwidth_type,
        pll0.spread_frequency       = spread_frequency,
        pll0.down_spread            = down_spread,
        pll0.simulation_type        = simulation_type,
        pll0.skip_vco               = skip_vco,

        //  internal clock specifications
        pll0.clk5_multiply_by       = clk5_multiply_by,
        pll0.clk4_multiply_by       = clk4_multiply_by,
        pll0.clk3_multiply_by       = clk3_multiply_by,
        pll0.clk2_multiply_by       = clk2_multiply_by,
        pll0.clk1_multiply_by       = clk1_multiply_by,
        pll0.clk0_multiply_by       = clk0_multiply_by,
        pll0.clk5_divide_by         = clk5_divide_by,
        pll0.clk4_divide_by         = clk4_divide_by,
        pll0.clk3_divide_by         = clk3_divide_by,
        pll0.clk2_divide_by         = clk2_divide_by,
        pll0.clk1_divide_by         = clk1_divide_by,
        pll0.clk0_divide_by         = clk0_divide_by,
        pll0.clk5_phase_shift       = clk5_phase_shift,
        pll0.clk4_phase_shift       = clk4_phase_shift,
        pll0.clk3_phase_shift       = clk3_phase_shift,
        pll0.clk2_phase_shift       = clk2_phase_shift,
        pll0.clk1_phase_shift       = clk1_phase_shift,
        pll0.clk0_phase_shift       = clk0_phase_shift,
        pll0.clk2_phase_shift_num   = clk2_phase_shift_num,
        pll0.clk1_phase_shift_num   = clk1_phase_shift_num,
        pll0.clk0_phase_shift_num   = clk0_phase_shift_num,
        pll0.clk5_time_delay        = clk5_time_delay,
        pll0.clk4_time_delay        = clk4_time_delay,
        pll0.clk3_time_delay        = clk3_time_delay,
        pll0.clk2_time_delay        = clk2_time_delay,
        pll0.clk1_time_delay        = clk1_time_delay,
        pll0.clk0_time_delay        = clk0_time_delay,
        pll0.clk5_duty_cycle        = clk5_duty_cycle,
        pll0.clk4_duty_cycle        = clk4_duty_cycle,
        pll0.clk3_duty_cycle        = clk3_duty_cycle,
        pll0.clk2_duty_cycle        = clk2_duty_cycle,
        pll0.clk1_duty_cycle        = clk1_duty_cycle,
        pll0.clk0_duty_cycle        = clk0_duty_cycle,

        //  external clock specifications
        pll0.extclk3_multiply_by    = extclk3_multiply_by,
        pll0.extclk2_multiply_by    = extclk2_multiply_by,
        pll0.extclk1_multiply_by    = extclk1_multiply_by,
        pll0.extclk0_multiply_by    = extclk0_multiply_by,
        pll0.extclk3_divide_by      = extclk3_divide_by,
        pll0.extclk2_divide_by      = extclk2_divide_by,
        pll0.extclk1_divide_by      = extclk1_divide_by,
        pll0.extclk0_divide_by      = extclk0_divide_by,
        pll0.extclk3_phase_shift    = extclk3_phase_shift,
        pll0.extclk2_phase_shift    = extclk2_phase_shift,
        pll0.extclk1_phase_shift    = extclk1_phase_shift,
        pll0.extclk0_phase_shift    = extclk0_phase_shift,
        pll0.extclk3_time_delay     = extclk3_time_delay,
        pll0.extclk2_time_delay     = extclk2_time_delay,
        pll0.extclk1_time_delay     = extclk1_time_delay,
        pll0.extclk0_time_delay     = extclk0_time_delay,
        pll0.extclk3_duty_cycle     = extclk3_duty_cycle,
        pll0.extclk2_duty_cycle     = extclk2_duty_cycle,
        pll0.extclk1_duty_cycle     = extclk1_duty_cycle,
        pll0.extclk0_duty_cycle     = extclk0_duty_cycle,

        // advanced parameters
        pll0.vco_min                = vco_min,
        pll0.vco_max                = vco_max,
        pll0.vco_center             = vco_center,
        pll0.pfd_min                = pfd_min,
        pll0.pfd_max                = pfd_max,
        pll0.m_initial              = m_initial,
        pll0.m                      = m,
        pll0.n                      = n,
        pll0.m2                     = m2,
        pll0.n2                     = n2,
        pll0.ss                     = ss,
        pll0.l0_high                = l0_high,
        pll0.l1_high                = l1_high,
        pll0.g0_high                = g0_high,
        pll0.g1_high                = g1_high,
        pll0.g2_high                = g2_high,
        pll0.g3_high                = g3_high,
        pll0.e0_high                = e0_high,
        pll0.e1_high                = e1_high,
        pll0.e2_high                = e2_high,
        pll0.e3_high                = e3_high,
        pll0.l0_low                 = l0_low,
        pll0.l1_low                 = l1_low,
        pll0.g0_low                 = g0_low,
        pll0.g1_low                 = g1_low,
        pll0.g2_low                 = g2_low,
        pll0.g3_low                 = g3_low,
        pll0.e0_low                 = e0_low,
        pll0.e1_low                 = e1_low,
        pll0.e2_low                 = e2_low,
        pll0.e3_low                 = e3_low,
        pll0.l0_initial             = l0_initial,
        pll0.l1_initial             = l1_initial,
        pll0.g0_initial             = g0_initial,
        pll0.g1_initial             = g1_initial,
        pll0.g2_initial             = g2_initial,
        pll0.g3_initial             = g3_initial,
        pll0.e0_initial             = e0_initial,
        pll0.e1_initial             = e1_initial,
        pll0.e2_initial             = e2_initial,
        pll0.e3_initial             = e3_initial,
        pll0.l0_mode                = l0_mode,
        pll0.l1_mode                = l1_mode,
        pll0.g0_mode                = g0_mode,
        pll0.g1_mode                = g1_mode,
        pll0.g2_mode                = g2_mode,
        pll0.g3_mode                = g3_mode,
        pll0.e0_mode                = e0_mode,
        pll0.e1_mode                = e1_mode,
        pll0.e2_mode                = e2_mode,
        pll0.e3_mode                = e3_mode,
        pll0.l0_ph                  = l0_ph,
        pll0.l1_ph                  = l1_ph,
        pll0.g0_ph                  = g0_ph,
        pll0.g1_ph                  = g1_ph,
        pll0.g2_ph                  = g2_ph,
        pll0.g3_ph                  = g3_ph,
        pll0.e0_ph                  = e0_ph,
        pll0.e1_ph                  = e1_ph,
        pll0.e2_ph                  = e2_ph,
        pll0.e3_ph                  = e3_ph,
        pll0.m_ph                   = m_ph,
        pll0.l0_time_delay          = l0_time_delay,
        pll0.l1_time_delay          = l1_time_delay,
        pll0.g0_time_delay          = g0_time_delay,
        pll0.g1_time_delay          = g1_time_delay,
        pll0.g2_time_delay          = g2_time_delay,
        pll0.g3_time_delay          = g3_time_delay,
        pll0.e0_time_delay          = e0_time_delay,
        pll0.e1_time_delay          = e1_time_delay,
        pll0.e2_time_delay          = e2_time_delay,
        pll0.e3_time_delay          = e3_time_delay,
        pll0.m_time_delay           = m_time_delay,
        pll0.n_time_delay           = n_time_delay,
        pll0.extclk3_counter        = extclk3_counter,
        pll0.extclk2_counter        = extclk2_counter,
        pll0.extclk1_counter        = extclk1_counter,
        pll0.extclk0_counter        = extclk0_counter,
        pll0.clk5_counter           = clk5_counter,
        pll0.clk4_counter           = clk4_counter,
        pll0.clk3_counter           = clk3_counter,
        pll0.clk2_counter           = clk2_counter,
        pll0.clk1_counter           = clk1_counter,
        pll0.clk0_counter           = clk0_counter,
        pll0.enable0_counter        = enable0_counter,
        pll0.enable1_counter        = enable1_counter,
        pll0.charge_pump_current    = charge_pump_current,
        pll0.loop_filter_r          = loop_filter_r,
        pll0.loop_filter_c          = loop_filter_c;

endmodule //altgxb_pll



///////////////////////////////////////////////////////////////////////////////
//
//                         end of altgxb_pll
//
///////////////////////////////////////////////////////////////////////////////
//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 137 mux21 348 
`timescale 1 ps / 1 ps
module  altgxb_xgm_rx_sm
	( 
	resetall,
	rxclk,
	rxctrl,
	rxctrlout,
	rxdatain,
	rxdataout,
	rxdatavalid,
	rxrunningdisp) /* synthesis synthesis_clearbox=1 */;
	input   resetall;
	input   rxclk;
	input   [3:0]  rxctrl;
	output   [3:0]  rxctrlout;
	input   [31:0]  rxdatain;
	output   [31:0]  rxdataout;
	input   [3:0]  rxdatavalid;
	input   [3:0]  rxrunningdisp;

	reg	nl00ll58;
	reg	nl00ll59;
	reg	nl00ll60;
	reg	nl00OO55;
	reg	nl00OO56;
	reg	nl00OO57;
	reg	nl0i0i52;
	reg	nl0i0i53;
	reg	nl0i0i54;
	reg	nl0iil49;
	reg	nl0iil50;
	reg	nl0iil51;
	reg	nl0ill46;
	reg	nl0ill47;
	reg	nl0ill48;
	reg	nl0iOl43;
	reg	nl0iOl44;
	reg	nl0iOl45;
	reg	nl0l0l37;
	reg	nl0l0l38;
	reg	nl0l0l39;
	reg	nl0l1i40;
	reg	nl0l1i41;
	reg	nl0l1i42;
	reg	nl0lil34;
	reg	nl0lil35;
	reg	nl0lil36;
	reg	nl0llO31;
	reg	nl0llO32;
	reg	nl0llO33;
	reg	nl0O1O28;
	reg	nl0O1O29;
	reg	nl0O1O30;
	reg	nl0Oii25;
	reg	nl0Oii26;
	reg	nl0Oii27;
	reg	nl0Oll22;
	reg	nl0Oll23;
	reg	nl0Oll24;
	reg	nli01i7;
	reg	nli01i8;
	reg	nli01i9;
	reg	nli0ii4;
	reg	nli0ii5;
	reg	nli0ii6;
	reg	nli0Oi1;
	reg	nli0Oi2;
	reg	nli0Oi3;
	reg	nli10i16;
	reg	nli10i17;
	reg	nli10i18;
	reg	nli10O13;
	reg	nli10O14;
	reg	nli10O15;
	reg	nli11i19;
	reg	nli11i20;
	reg	nli11i21;
	reg	nli1il10;
	reg	nli1il11;
	reg	nli1il12;
	reg	n011i;
	reg	n0i0i;
	reg	n0i0l;
	reg	n0i0O;
	reg	n0i1O;
	reg	n0iii;
	reg	n0iil;
	reg	n0iiO;
	reg	n100i;
	reg	n100l;
	reg	n100O;
	reg	n101i;
	reg	n101l;
	reg	n101O;
	reg	n10ii;
	reg	n11i;
	reg	n11l;
	reg	n11Ol;
	reg	n11OO;
	reg	n1OlO;
	reg	n1OOi;
	reg	n1OOl;
	reg	n1OOO;
	reg	ni00l;
	reg	ni00O;
	reg	ni0ii;
	reg	ni0il;
	reg	ni0iO;
	reg	ni0li;
	reg	ni0ll;
	reg	ni0lO;
	reg	ni0Oi;
	reg	niiO;
	reg	nili;
	reg	niOl;
	reg	nl01i;
	reg	nl01l;
	reg	nl1i;
	reg	nl1iO;
	reg	nl1li;
	reg	nl1ll;
	reg	nl1lO;
	reg	nl1Oi;
	reg	nl1Ol;
	reg	nl1OO;
	reg	nllOli;
	reg	nllOll;
	reg	nllOlO;
	reg	nllOOi;
	reg	nllOOl;
	reg	nllOOO;
	reg	nlO11i;
	reg	nlOi0i;
	reg	nlOi0l;
	reg	nlOi0O;
	reg	nlOi1l;
	reg	nlOi1O;
	reg	nlOiii;
	reg	nlOiil;
	reg	nlOiiO;
	reg	nlOili;
	reg	nlOOi;
	reg	nlOOl;
	reg	nlOOO;
	reg	nlllll;
	reg	nllllO;
	reg	nlllOi;
	reg	nlllOl;
	reg	nlllOO;
	reg	nllO0i;
	reg	nllO0l;
	reg	nllO0O;
	reg	nllO1i;
	reg	nllO1l;
	reg	nllO1O;
	reg	nllOii;
	reg	nllOiO;
	wire	wire_n000i_dataout;
	wire	wire_n000l_dataout;
	wire	wire_n000O_dataout;
	wire	wire_n001i_dataout;
	wire	wire_n001l_dataout;
	wire	wire_n001O_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00ii_dataout;
	wire	wire_n00il_dataout;
	wire	wire_n00iO_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00li_dataout;
	wire	wire_n00ll_dataout;
	wire	wire_n00lO_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n00Oi_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n011l_dataout;
	wire	wire_n011O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01ii_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01iO_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01lO_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01Oi_dataout;
	wire	wire_n01Ol_dataout;
	wire	wire_n01OO_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0ili_dataout;
	wire	wire_n0ill_dataout;
	wire	wire_n0ilO_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0iOi_dataout;
	wire	wire_n0iOl_dataout;
	wire	wire_n0iOO_dataout;
	wire	wire_n0l0i_dataout;
	wire	wire_n0l0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0l1i_dataout;
	wire	wire_n0l1l_dataout;
	wire	wire_n0l1O_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0lii_dataout;
	wire	wire_n0lil_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lli_dataout;
	wire	wire_n0lll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0lOi_dataout;
	wire	wire_n0lOl_dataout;
	wire	wire_n0lOO_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O0l_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Oil_dataout;
	wire	wire_n0OiO_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0Oll_dataout;
	wire	wire_n0OlO_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n0OOO_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10il_dataout;
	wire	wire_n10iO_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10li_dataout;
	wire	wire_n10ll_dataout;
	wire	wire_n10lO_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n10Oi_dataout;
	wire	wire_n10Ol_dataout;
	wire	wire_n10OO_dataout;
	wire	wire_n110i_dataout;
	wire	wire_n110l_dataout;
	wire	wire_n110O_dataout;
	wire	wire_n111i_dataout;
	wire	wire_n11ii_dataout;
	wire	wire_n11il_dataout;
	wire	wire_n11iO_dataout;
	wire	wire_n11li_dataout;
	wire	wire_n11ll_dataout;
	wire	wire_n11lO_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n1i0i_dataout;
	wire	wire_n1i0l_dataout;
	wire	wire_n1i0O_dataout;
	wire	wire_n1i1i_dataout;
	wire	wire_n1i1l_dataout;
	wire	wire_n1i1O_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1iii_dataout;
	wire	wire_n1iil_dataout;
	wire	wire_n1iiO_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1ili_dataout;
	wire	wire_n1ill_dataout;
	wire	wire_n1ilO_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1iOi_dataout;
	wire	wire_n1iOl_dataout;
	wire	wire_n1iOO_dataout;
	wire	wire_n1l0i_dataout;
	wire	wire_n1l0l_dataout;
	wire	wire_n1l0O_dataout;
	wire	wire_n1l1i_dataout;
	wire	wire_n1l1l_dataout;
	wire	wire_n1l1O_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1lii_dataout;
	wire	wire_n1lil_dataout;
	wire	wire_n1liO_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lli_dataout;
	wire	wire_n1lll_dataout;
	wire	wire_n1llO_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1lOi_dataout;
	wire	wire_n1O0i_dataout;
	wire	wire_n1O0l_dataout;
	wire	wire_n1O0O_dataout;
	wire	wire_n1O1l_dataout;
	wire	wire_n1O1O_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Oii_dataout;
	wire	wire_n1Oil_dataout;
	wire	wire_n1OiO_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1Oli_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_ni01i_dataout;
	wire	wire_ni01l_dataout;
	wire	wire_ni01O_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0Ol_dataout;
	wire	wire_ni0OO_dataout;
	wire	wire_ni10i_dataout;
	wire	wire_ni10l_dataout;
	wire	wire_ni10O_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni11l_dataout;
	wire	wire_ni11O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1ii_dataout;
	wire	wire_ni1il_dataout;
	wire	wire_ni1iO_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1li_dataout;
	wire	wire_ni1ll_dataout;
	wire	wire_ni1lO_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1Oi_dataout;
	wire	wire_ni1Ol_dataout;
	wire	wire_ni1OO_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii1i_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil1i_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nilii_dataout;
	wire	wire_nilil_dataout;
	wire	wire_niliO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilli_dataout;
	wire	wire_nilll_dataout;
	wire	wire_nillO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilOi_dataout;
	wire	wire_nilOl_dataout;
	wire	wire_nilOO_dataout;
	wire	wire_niO0i_dataout;
	wire	wire_niO0l_dataout;
	wire	wire_niO0O_dataout;
	wire	wire_niO1i_dataout;
	wire	wire_niO1l_dataout;
	wire	wire_niO1O_dataout;
	wire	wire_niOii_dataout;
	wire	wire_niOil_dataout;
	wire	wire_niOiO_dataout;
	wire	wire_niOli_dataout;
	wire	wire_niOll_dataout;
	wire	wire_niOlO_dataout;
	wire	wire_niOOi_dataout;
	wire	wire_niOOl_dataout;
	wire	wire_niOOO_dataout;
	wire	wire_nl00i_dataout;
	wire	wire_nl00l_dataout;
	wire	wire_nl00O_dataout;
	wire	wire_nl01O_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0ii_dataout;
	wire	wire_nl0il_dataout;
	wire	wire_nl0iO_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0li_dataout;
	wire	wire_nl0ll_dataout;
	wire	wire_nl0lO_dataout;
	wire	wire_nl0Oi_dataout;
	wire	wire_nl0Ol_dataout;
	wire	wire_nl0OO_dataout;
	wire	wire_nl10i_dataout;
	wire	wire_nl10l_dataout;
	wire	wire_nl10O_dataout;
	wire	wire_nl11i_dataout;
	wire	wire_nl11l_dataout;
	wire	wire_nl11O_dataout;
	wire	wire_nl1ii_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nli0i_dataout;
	wire	wire_nli0l_dataout;
	wire	wire_nli0O_dataout;
	wire	wire_nli1i_dataout;
	wire	wire_nli1l_dataout;
	wire	wire_nli1O_dataout;
	wire	wire_nliii_dataout;
	wire	wire_nliil_dataout;
	wire	wire_nliiO_dataout;
	wire	wire_nlili_dataout;
	wire	wire_nlill_dataout;
	wire	wire_nlilO_dataout;
	wire	wire_nliOi_dataout;
	wire	wire_nliOl_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nlO00i_dataout;
	wire	wire_nlO00l_dataout;
	wire	wire_nlO00O_dataout;
	wire	wire_nlO01i_dataout;
	wire	wire_nlO01l_dataout;
	wire	wire_nlO01O_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO0ii_dataout;
	wire	wire_nlO0il_dataout;
	wire	wire_nlO0iO_dataout;
	wire	wire_nlO0l_dataout;
	wire	wire_nlO0li_dataout;
	wire	wire_nlO0ll_dataout;
	wire	wire_nlO0lO_dataout;
	wire	wire_nlO0O_dataout;
	wire	wire_nlO0Oi_dataout;
	wire	wire_nlO10i_dataout;
	wire	wire_nlO10l_dataout;
	wire	wire_nlO10O_dataout;
	wire	wire_nlO11l_dataout;
	wire	wire_nlO11O_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1ii_dataout;
	wire	wire_nlO1il_dataout;
	wire	wire_nlO1iO_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1li_dataout;
	wire	wire_nlO1ll_dataout;
	wire	wire_nlO1lO_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlO1Oi_dataout;
	wire	wire_nlO1Ol_dataout;
	wire	wire_nlO1OO_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOill_dataout;
	wire	wire_nlOilO_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOiOi_dataout;
	wire	wire_nlOiOl_dataout;
	wire	wire_nlOiOO_dataout;
	wire	wire_nlOl0i_dataout;
	wire	wire_nlOl0l_dataout;
	wire	wire_nlOl0O_dataout;
	wire	wire_nlOl1i_dataout;
	wire	wire_nlOl1l_dataout;
	wire	wire_nlOl1O_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOlii_dataout;
	wire	wire_nlOlil_dataout;
	wire	wire_nlOliO_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOlli_dataout;
	wire	wire_nlOlll_dataout;
	wire	wire_nlOllO_dataout;
	wire	wire_nlOlOi_dataout;
	wire	wire_nlOlOl_dataout;
	wire	wire_nlOlOO_dataout;
	wire	wire_nlOO0i_dataout;
	wire	wire_nlOO0l_dataout;
	wire	wire_nlOO0O_dataout;
	wire	wire_nlOO1i_dataout;
	wire	wire_nlOO1l_dataout;
	wire	wire_nlOO1O_dataout;
	wire	wire_nlOOii_dataout;
	wire	wire_nlOOil_dataout;
	wire	wire_nlOOiO_dataout;
	wire	wire_nlOOli_dataout;
	wire	wire_nlOOll_dataout;
	wire	wire_nlOOlO_dataout;
	wire	wire_nlOOOi_dataout;
	wire	wire_nlOOOl_dataout;
	wire	wire_nlOOOO_dataout;
	wire  nl00iO;
	wire  nl00li;
	wire  nl00Oi;
	wire  nl00Ol;
	wire  nl0i0O;
	wire  nl0i1l;
	wire  nl0i1O;
	wire  nl0iii;
	wire  nl0ili;
	wire  nl0iOi;
	wire  nl0l0i;
	wire  nl0l1O;
	wire  nl0lii;
	wire  nl0lli;
	wire  nl0lll;
	wire  nl0lOl;
	wire  nl0lOO;
	wire  nl0O0l;
	wire  nl0O0O;
	wire  nl0O1i;
	wire  nl0O1l;
	wire  nl0OiO;
	wire  nl0Oli;
	wire  nl0OOi;
	wire  nl0OOl;
	wire  nl0OOO;
	wire  nli00i;
	wire  nli00l;
	wire  nli00O;
	wire  nli01O;
	wire  nli0iO;
	wire  nli0li;
	wire  nli0ll;
	wire  nli0lO;
	wire  nli11O;
	wire  nli1li;
	wire  nli1ll;
	wire  nli1lO;
	wire  nli1Oi;
	wire  nli1Ol;
	wire  nli1OO;
	wire  nlii1l;

	initial
		nl00ll58 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl00ll58 <= nl00ll60;
	initial
		nl00ll59 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl00ll59 <= (nl00ll60 ^ nl00ll58);
	initial
		nl00ll60 = 0;
	always @ ( posedge rxclk)
		  nl00ll60 <= nl00ll58;
	initial
		nl00OO55 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl00OO55 <= nl00OO57;
	initial
		nl00OO56 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl00OO56 <= (nl00OO57 ^ nl00OO55);
	initial
		nl00OO57 = 0;
	always @ ( posedge rxclk)
		  nl00OO57 <= nl00OO55;
	initial
		nl0i0i52 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0i0i52 <= nl0i0i54;
	initial
		nl0i0i53 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0i0i53 <= (nl0i0i54 ^ nl0i0i52);
	initial
		nl0i0i54 = 0;
	always @ ( posedge rxclk)
		  nl0i0i54 <= nl0i0i52;
	initial
		nl0iil49 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0iil49 <= nl0iil51;
	initial
		nl0iil50 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0iil50 <= (nl0iil51 ^ nl0iil49);
	initial
		nl0iil51 = 0;
	always @ ( posedge rxclk)
		  nl0iil51 <= nl0iil49;
	initial
		nl0ill46 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0ill46 <= nl0ill48;
	initial
		nl0ill47 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0ill47 <= (nl0ill48 ^ nl0ill46);
	initial
		nl0ill48 = 0;
	always @ ( posedge rxclk)
		  nl0ill48 <= nl0ill46;
	initial
		nl0iOl43 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0iOl43 <= nl0iOl45;
	initial
		nl0iOl44 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0iOl44 <= (nl0iOl45 ^ nl0iOl43);
	initial
		nl0iOl45 = 0;
	always @ ( posedge rxclk)
		  nl0iOl45 <= nl0iOl43;
	initial
		nl0l0l37 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0l0l37 <= nl0l0l39;
	initial
		nl0l0l38 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0l0l38 <= (nl0l0l39 ^ nl0l0l37);
	initial
		nl0l0l39 = 0;
	always @ ( posedge rxclk)
		  nl0l0l39 <= nl0l0l37;
	initial
		nl0l1i40 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0l1i40 <= nl0l1i42;
	initial
		nl0l1i41 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0l1i41 <= (nl0l1i42 ^ nl0l1i40);
	initial
		nl0l1i42 = 0;
	always @ ( posedge rxclk)
		  nl0l1i42 <= nl0l1i40;
	initial
		nl0lil34 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0lil34 <= nl0lil36;
	initial
		nl0lil35 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0lil35 <= (nl0lil36 ^ nl0lil34);
	initial
		nl0lil36 = 0;
	always @ ( posedge rxclk)
		  nl0lil36 <= nl0lil34;
	initial
		nl0llO31 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0llO31 <= nl0llO33;
	initial
		nl0llO32 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0llO32 <= (nl0llO33 ^ nl0llO31);
	initial
		nl0llO33 = 0;
	always @ ( posedge rxclk)
		  nl0llO33 <= nl0llO31;
	initial
		nl0O1O28 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0O1O28 <= nl0O1O30;
	initial
		nl0O1O29 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0O1O29 <= (nl0O1O30 ^ nl0O1O28);
	initial
		nl0O1O30 = 0;
	always @ ( posedge rxclk)
		  nl0O1O30 <= nl0O1O28;
	initial
		nl0Oii25 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0Oii25 <= nl0Oii27;
	initial
		nl0Oii26 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0Oii26 <= (nl0Oii27 ^ nl0Oii25);
	initial
		nl0Oii27 = 0;
	always @ ( posedge rxclk)
		  nl0Oii27 <= nl0Oii25;
	initial
		nl0Oll22 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0Oll22 <= nl0Oll24;
	initial
		nl0Oll23 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nl0Oll23 <= (nl0Oll24 ^ nl0Oll22);
	initial
		nl0Oll24 = 0;
	always @ ( posedge rxclk)
		  nl0Oll24 <= nl0Oll22;
	initial
		nli01i7 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nli01i7 <= nli01i9;
	initial
		nli01i8 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nli01i8 <= (nli01i9 ^ nli01i7);
	initial
		nli01i9 = 0;
	always @ ( posedge rxclk)
		  nli01i9 <= nli01i7;
	initial
		nli0ii4 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nli0ii4 <= nli0ii6;
	initial
		nli0ii5 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nli0ii5 <= (nli0ii6 ^ nli0ii4);
	initial
		nli0ii6 = 0;
	always @ ( posedge rxclk)
		  nli0ii6 <= nli0ii4;
	initial
		nli0Oi1 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nli0Oi1 <= nli0Oi3;
	initial
		nli0Oi2 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nli0Oi2 <= (nli0Oi3 ^ nli0Oi1);
	initial
		nli0Oi3 = 0;
	always @ ( posedge rxclk)
		  nli0Oi3 <= nli0Oi1;
	initial
		nli10i16 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nli10i16 <= nli10i18;
	initial
		nli10i17 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nli10i17 <= (nli10i18 ^ nli10i16);
	initial
		nli10i18 = 0;
	always @ ( posedge rxclk)
		  nli10i18 <= nli10i16;
	initial
		nli10O13 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nli10O13 <= nli10O15;
	initial
		nli10O14 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nli10O14 <= (nli10O15 ^ nli10O13);
	initial
		nli10O15 = 0;
	always @ ( posedge rxclk)
		  nli10O15 <= nli10O13;
	initial
		nli11i19 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nli11i19 <= nli11i21;
	initial
		nli11i20 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nli11i20 <= (nli11i21 ^ nli11i19);
	initial
		nli11i21 = 0;
	always @ ( posedge rxclk)
		  nli11i21 <= nli11i19;
	initial
		nli1il10 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nli1il10 <= nli1il12;
	initial
		nli1il11 = {1{1'b1}};
	always @ ( posedge rxclk)
		  nli1il11 <= (nli1il12 ^ nli1il10);
	initial
		nli1il12 = 0;
	always @ ( posedge rxclk)
		  nli1il12 <= nli1il10;
	initial
	begin
		n011i = 0;
		n0i0i = 0;
		n0i0l = 0;
		n0i0O = 0;
		n0i1O = 0;
		n0iii = 0;
		n0iil = 0;
		n0iiO = 0;
		n100i = 0;
		n100l = 0;
		n100O = 0;
		n101i = 0;
		n101l = 0;
		n101O = 0;
		n10ii = 0;
		n11i = 0;
		n11l = 0;
		n11Ol = 0;
		n11OO = 0;
		n1OlO = 0;
		n1OOi = 0;
		n1OOl = 0;
		n1OOO = 0;
		ni00l = 0;
		ni00O = 0;
		ni0ii = 0;
		ni0il = 0;
		ni0iO = 0;
		ni0li = 0;
		ni0ll = 0;
		ni0lO = 0;
		ni0Oi = 0;
		niiO = 0;
		nili = 0;
		niOl = 0;
		nl01i = 0;
		nl01l = 0;
		nl1i = 0;
		nl1iO = 0;
		nl1li = 0;
		nl1ll = 0;
		nl1lO = 0;
		nl1Oi = 0;
		nl1Ol = 0;
		nl1OO = 0;
		nllOli = 0;
		nllOll = 0;
		nllOlO = 0;
		nllOOi = 0;
		nllOOl = 0;
		nllOOO = 0;
		nlO11i = 0;
		nlOi0i = 0;
		nlOi0l = 0;
		nlOi0O = 0;
		nlOi1l = 0;
		nlOi1O = 0;
		nlOiii = 0;
		nlOiil = 0;
		nlOiiO = 0;
		nlOili = 0;
		nlOOi = 0;
		nlOOl = 0;
		nlOOO = 0;
	end
	always @ ( posedge rxclk or posedge resetall)
	begin
		if (resetall == 1'b1) 
		begin
			n011i <= 0;
			n0i0i <= 0;
			n0i0l <= 0;
			n0i0O <= 0;
			n0i1O <= 0;
			n0iii <= 0;
			n0iil <= 0;
			n0iiO <= 0;
			n100i <= 0;
			n100l <= 0;
			n100O <= 0;
			n101i <= 0;
			n101l <= 0;
			n101O <= 0;
			n10ii <= 0;
			n11i <= 0;
			n11l <= 0;
			n11Ol <= 0;
			n11OO <= 0;
			n1OlO <= 0;
			n1OOi <= 0;
			n1OOl <= 0;
			n1OOO <= 0;
			ni00l <= 0;
			ni00O <= 0;
			ni0ii <= 0;
			ni0il <= 0;
			ni0iO <= 0;
			ni0li <= 0;
			ni0ll <= 0;
			ni0lO <= 0;
			ni0Oi <= 0;
			niiO <= 0;
			nili <= 0;
			niOl <= 0;
			nl01i <= 0;
			nl01l <= 0;
			nl1i <= 0;
			nl1iO <= 0;
			nl1li <= 0;
			nl1ll <= 0;
			nl1lO <= 0;
			nl1Oi <= 0;
			nl1Ol <= 0;
			nl1OO <= 0;
			nllOli <= 0;
			nllOll <= 0;
			nllOlO <= 0;
			nllOOi <= 0;
			nllOOl <= 0;
			nllOOO <= 0;
			nlO11i <= 0;
			nlOi0i <= 0;
			nlOi0l <= 0;
			nlOi0O <= 0;
			nlOi1l <= 0;
			nlOi1O <= 0;
			nlOiii <= 0;
			nlOiil <= 0;
			nlOiiO <= 0;
			nlOili <= 0;
			nlOOi <= 0;
			nlOOl <= 0;
			nlOOO <= 0;
		end
		else 
		begin
			n011i <= wire_n01iO_dataout;
			n0i0i <= wire_n0ilO_dataout;
			n0i0l <= wire_n0iOi_dataout;
			n0i0O <= wire_n0iOl_dataout;
			n0i1O <= wire_n0ili_dataout;
			n0iii <= wire_n0iOO_dataout;
			n0iil <= wire_n0l1i_dataout;
			n0iiO <= wire_n0l1l_dataout;
			n100i <= wire_n10lO_dataout;
			n100l <= wire_n10Oi_dataout;
			n100O <= wire_n10Ol_dataout;
			n101i <= wire_n10iO_dataout;
			n101l <= wire_n10li_dataout;
			n101O <= wire_n10ll_dataout;
			n10ii <= wire_n10OO_dataout;
			n11i <= wire_n1iO_dataout;
			n11l <= wire_n1li_dataout;
			n11Ol <= wire_nlOl0i_dataout;
			n11OO <= wire_n10il_dataout;
			n1OlO <= wire_n1i1i_dataout;
			n1OOi <= wire_n011O_dataout;
			n1OOl <= wire_n010i_dataout;
			n1OOO <= wire_n01il_dataout;
			ni00l <= wire_n0l1O_dataout;
			ni00O <= wire_ni0Ol_dataout;
			ni0ii <= wire_ni0OO_dataout;
			ni0il <= wire_nii1i_dataout;
			ni0iO <= wire_nii1l_dataout;
			ni0li <= wire_nii1O_dataout;
			ni0ll <= wire_nii0i_dataout;
			ni0lO <= wire_nii0l_dataout;
			ni0Oi <= wire_nii0O_dataout;
			niiO <= ((~ wire_nl0l_dataout) & ((rxctrl[3] & nl0lli) & nl0lil35));
			nili <= nl0lOO;
			niOl <= nl0O1l;
			nl01i <= wire_nl0iO_dataout;
			nl01l <= wire_nl0li_dataout;
			nl1i <= wire_nilO_dataout;
			nl1iO <= wire_niiii_dataout;
			nl1li <= wire_nl01O_dataout;
			nl1ll <= wire_nl00i_dataout;
			nl1lO <= wire_nl00l_dataout;
			nl1Oi <= wire_nl00O_dataout;
			nl1Ol <= wire_nl0ii_dataout;
			nl1OO <= wire_nl0il_dataout;
			nllOli <= wire_nlO11l_dataout;
			nllOll <= wire_nlO10i_dataout;
			nllOlO <= wire_nlO10l_dataout;
			nllOOi <= wire_nlO10O_dataout;
			nllOOl <= wire_nlO1ii_dataout;
			nllOOO <= wire_nlO1il_dataout;
			nlO11i <= wire_nlO1iO_dataout;
			nlOi0i <= wire_nlOilO_dataout;
			nlOi0l <= wire_nlOiOi_dataout;
			nlOi0O <= wire_nlOiOl_dataout;
			nlOi1l <= wire_nlO1li_dataout;
			nlOi1O <= wire_nlOill_dataout;
			nlOiii <= wire_nlOiOO_dataout;
			nlOiil <= wire_nlOl1i_dataout;
			nlOiiO <= wire_nlOl1l_dataout;
			nlOili <= wire_nlOl1O_dataout;
			nlOOi <= wire_nl0ll_dataout;
			nlOOl <= wire_n10i_dataout;
			nlOOO <= wire_n10l_dataout;
		end
	end
	initial
	begin
		nlllll = 0;
		nllllO = 0;
		nlllOi = 0;
		nlllOl = 0;
		nlllOO = 0;
		nllO0i = 0;
		nllO0l = 0;
		nllO0O = 0;
		nllO1i = 0;
		nllO1l = 0;
		nllO1O = 0;
		nllOii = 0;
		nllOiO = 0;
	end
	always @ ( posedge rxclk or posedge resetall)
	begin
		if (resetall == 1'b1) 
		begin
			nlllll <= 1;
			nllllO <= 1;
			nlllOi <= 1;
			nlllOl <= 1;
			nlllOO <= 1;
			nllO0i <= 1;
			nllO0l <= 1;
			nllO0O <= 1;
			nllO1i <= 1;
			nllO1l <= 1;
			nllO1O <= 1;
			nllOii <= 1;
			nllOiO <= 1;
		end
		else 
		begin
			nlllll <= wire_nlO11O_dataout;
			nllllO <= wire_n011l_dataout;
			nlllOi <= wire_n010l_dataout;
			nlllOl <= wire_n010O_dataout;
			nlllOO <= wire_n01ii_dataout;
			nllO0i <= wire_n10O_dataout;
			nllO0l <= wire_n1ii_dataout;
			nllO0O <= wire_n1il_dataout;
			nllO1i <= wire_n01li_dataout;
			nllO1l <= wire_n0ill_dataout;
			nllO1O <= wire_n11O_dataout;
			nllOii <= wire_n1ll_dataout;
			nllOiO <= (~ nl0lll);
		end
	end
	assign		wire_n000i_dataout = (nl0iOi === 1'b1) ? wire_n00Oi_dataout : nllOii;
	or(wire_n000l_dataout, nllO1O, nl0ili);
	and(wire_n000O_dataout, nlOOl, ~{nl0ili});
	assign		wire_n001i_dataout = (nl0iOi === 1'b1) ? wire_n00li_dataout : nllO0O;
	assign		wire_n001l_dataout = (nl0iOi === 1'b1) ? wire_n00ll_dataout : n11i;
	assign		wire_n001O_dataout = (nl0iOi === 1'b1) ? wire_n00lO_dataout : n11l;
	and(wire_n00i_dataout, wire_n0Oi_dataout, ~{wire_nill_dataout});
	or(wire_n00ii_dataout, nlOOO, nl0ili);
	or(wire_n00il_dataout, nllO0i, nl0ili);
	or(wire_n00iO_dataout, nllO0l, nl0ili);
	and(wire_n00l_dataout, wire_n0Ol_dataout, ~{wire_nill_dataout});
	or(wire_n00li_dataout, nllO0O, nl0ili);
	or(wire_n00ll_dataout, n11i, nl0ili);
	or(wire_n00lO_dataout, n11l, nl0ili);
	assign		wire_n00O_dataout = (nl0O0O === 1'b1) ? rxctrl[0] : wire_n0OO_dataout;
	or(wire_n00Oi_dataout, nllOii, nl0ili);
	and(wire_n010i_dataout, wire_n01Oi_dataout, ~{nllOiO});
	or(wire_n010l_dataout, wire_n01Ol_dataout, nllOiO);
	or(wire_n010O_dataout, wire_n01OO_dataout, nllOiO);
	or(wire_n011l_dataout, wire_n01ll_dataout, nllOiO);
	and(wire_n011O_dataout, wire_n01lO_dataout, ~{nllOiO});
	and(wire_n01i_dataout, wire_n0li_dataout, ~{wire_nill_dataout});
	or(wire_n01ii_dataout, wire_n001i_dataout, nllOiO);
	and(wire_n01il_dataout, wire_n001l_dataout, ~{nllOiO});
	and(wire_n01iO_dataout, wire_n001O_dataout, ~{nllOiO});
	and(wire_n01l_dataout, wire_n0ll_dataout, ~{wire_nill_dataout});
	or(wire_n01li_dataout, wire_n000i_dataout, nllOiO);
	assign		wire_n01ll_dataout = (nl0iOi === 1'b1) ? wire_n000l_dataout : nllO1O;
	assign		wire_n01lO_dataout = (nl0iOi === 1'b1) ? wire_n000O_dataout : nlOOl;
	and(wire_n01O_dataout, wire_n0lO_dataout, ~{wire_nill_dataout});
	assign		wire_n01Oi_dataout = (nl0iOi === 1'b1) ? wire_n00ii_dataout : nlOOO;
	assign		wire_n01Ol_dataout = (nl0iOi === 1'b1) ? wire_n00il_dataout : nllO0i;
	assign		wire_n01OO_dataout = (nl0iOi === 1'b1) ? wire_n00iO_dataout : nllO0l;
	assign		wire_n0ii_dataout = (nl0O0O === 1'b1) ? rxdatain[0] : wire_ni1i_dataout;
	assign		wire_n0il_dataout = (nl0O0O === 1'b1) ? rxdatain[1] : wire_ni1l_dataout;
	assign		wire_n0ili_dataout = (nl1i === 1'b1) ? wire_ni11i_dataout : wire_n0llO_dataout;
	assign		wire_n0ill_dataout = (nl1i === 1'b1) ? wire_ni11l_dataout : wire_n0l0i_dataout;
	assign		wire_n0ilO_dataout = (nl1i === 1'b1) ? wire_ni11O_dataout : wire_n0l0l_dataout;
	assign		wire_n0iO_dataout = (nl0O0O === 1'b1) ? rxdatain[2] : wire_ni1O_dataout;
	assign		wire_n0iOi_dataout = (nl1i === 1'b1) ? wire_ni10i_dataout : wire_n0l0O_dataout;
	assign		wire_n0iOl_dataout = (nl1i === 1'b1) ? wire_ni10l_dataout : wire_n0lii_dataout;
	assign		wire_n0iOO_dataout = (nl1i === 1'b1) ? wire_ni10O_dataout : wire_n0lil_dataout;
	or(wire_n0l0i_dataout, wire_n0lOl_dataout, (~ nl0lll));
	and(wire_n0l0l_dataout, wire_n0lOO_dataout, ~{(~ nl0lll)});
	and(wire_n0l0O_dataout, wire_n0O1i_dataout, ~{(~ nl0lll)});
	assign		wire_n0l1i_dataout = (nl1i === 1'b1) ? wire_ni1ii_dataout : wire_n0liO_dataout;
	assign		wire_n0l1l_dataout = (nl1i === 1'b1) ? wire_ni1il_dataout : wire_n0lli_dataout;
	assign		wire_n0l1O_dataout = (nl1i === 1'b1) ? wire_ni1iO_dataout : wire_n0lll_dataout;
	assign		wire_n0li_dataout = (nl0O0O === 1'b1) ? rxdatain[3] : wire_ni0i_dataout;
	and(wire_n0lii_dataout, wire_n0O1l_dataout, ~{(~ nl0lll)});
	and(wire_n0lil_dataout, wire_n0O1O_dataout, ~{(~ nl0lll)});
	and(wire_n0liO_dataout, wire_n0O0i_dataout, ~{(~ nl0lll)});
	assign		wire_n0ll_dataout = (nl0O0O === 1'b1) ? rxdatain[4] : wire_ni0l_dataout;
	and(wire_n0lli_dataout, wire_n0O0l_dataout, ~{(~ nl0lll)});
	and(wire_n0lll_dataout, wire_n0O0O_dataout, ~{(~ nl0lll)});
	and(wire_n0llO_dataout, wire_n0lOi_dataout, ~{(~ nl0lll)});
	assign		wire_n0lO_dataout = (nl0O0O === 1'b1) ? rxdatain[5] : wire_ni0O_dataout;
	or(wire_n0lOi_dataout, wire_n0Oii_dataout, nl0Oli);
	or(wire_n0lOl_dataout, wire_n0Oil_dataout, nl0Oli);
	or(wire_n0lOO_dataout, wire_n0OiO_dataout, nl0Oli);
	and(wire_n0O0i_dataout, wire_n0OOi_dataout, ~{nl0Oli});
	and(wire_n0O0l_dataout, wire_n0OOl_dataout, ~{nl0Oli});
	and(wire_n0O0O_dataout, wire_n0OOO_dataout, ~{nl0Oli});
	or(wire_n0O1i_dataout, wire_n0Oli_dataout, nl0Oli);
	and(wire_n0O1l_dataout, wire_n0Oll_dataout, ~{nl0Oli});
	and(wire_n0O1O_dataout, wire_n0OlO_dataout, ~{nl0Oli});
	assign		wire_n0Oi_dataout = (nl0O0O === 1'b1) ? rxdatain[6] : wire_niii_dataout;
	or(wire_n0Oii_dataout, rxctrl[3], wire_nl0l_dataout);
	and(wire_n0Oil_dataout, rxdatain[24], ~{wire_nl0l_dataout});
	or(wire_n0OiO_dataout, rxdatain[25], wire_nl0l_dataout);
	assign		wire_n0Ol_dataout = (nl0O0O === 1'b1) ? rxdatain[7] : wire_niil_dataout;
	or(wire_n0Oli_dataout, rxdatain[26], wire_nl0l_dataout);
	or(wire_n0Oll_dataout, rxdatain[27], wire_nl0l_dataout);
	or(wire_n0OlO_dataout, rxdatain[28], wire_nl0l_dataout);
	or(wire_n0OO_dataout, rxctrl[0], wire_nl1l_dataout);
	or(wire_n0OOi_dataout, rxdatain[29], wire_nl0l_dataout);
	or(wire_n0OOl_dataout, rxdatain[30], wire_nl0l_dataout);
	or(wire_n0OOO_dataout, rxdatain[31], wire_nl0l_dataout);
	and(wire_n10i_dataout, wire_n1Oi_dataout, ~{(~ nl0lll)});
	and(wire_n10il_dataout, wire_n1i1l_dataout, ~{nllOiO});
	and(wire_n10iO_dataout, wire_n1i1O_dataout, ~{nllOiO});
	and(wire_n10l_dataout, wire_n1Ol_dataout, ~{(~ nl0lll)});
	and(wire_n10li_dataout, wire_n1i0i_dataout, ~{nllOiO});
	and(wire_n10ll_dataout, wire_n1i0l_dataout, ~{nllOiO});
	and(wire_n10lO_dataout, wire_n1i0O_dataout, ~{nllOiO});
	or(wire_n10O_dataout, wire_n1OO_dataout, (~ nl0lll));
	and(wire_n10Oi_dataout, wire_n1iii_dataout, ~{nllOiO});
	and(wire_n10Ol_dataout, wire_n1iil_dataout, ~{nllOiO});
	and(wire_n10OO_dataout, wire_n1iiO_dataout, ~{nllOiO});
	or(wire_n110i_dataout, ni00O, nl0i1l);
	and(wire_n110l_dataout, ni0ii, ~{nl0i1l});
	or(wire_n110O_dataout, ni0il, nl0i1l);
	or(wire_n111i_dataout, nl1iO, nl00Ol);
	or(wire_n11ii_dataout, ni0iO, nl0i1l);
	or(wire_n11il_dataout, ni0li, nl0i1l);
	or(wire_n11iO_dataout, ni0ll, nl0i1l);
	or(wire_n11li_dataout, ni0lO, nl0i1l);
	or(wire_n11ll_dataout, ni0Oi, nl0i1l);
	or(wire_n11lO_dataout, nl1iO, nl0i1l);
	or(wire_n11O_dataout, wire_n1lO_dataout, (~ nl0lll));
	assign		wire_n1i0i_dataout = (nl0O0O === 1'b1) ? wire_n1O0i_dataout : wire_n1iOi_dataout;
	assign		wire_n1i0l_dataout = (nl0O0O === 1'b1) ? wire_n1O0l_dataout : wire_n1iOl_dataout;
	assign		wire_n1i0O_dataout = (nl0O0O === 1'b1) ? wire_n1O0O_dataout : wire_n1iOO_dataout;
	and(wire_n1i1i_dataout, wire_n1ili_dataout, ~{nllOiO});
	assign		wire_n1i1l_dataout = (nl0O0O === 1'b1) ? wire_n1O1l_dataout : wire_n1ill_dataout;
	assign		wire_n1i1O_dataout = (nl0O0O === 1'b1) ? wire_n1O1O_dataout : wire_n1ilO_dataout;
	or(wire_n1ii_dataout, wire_n01i_dataout, (~ nl0lll));
	assign		wire_n1iii_dataout = (nl0O0O === 1'b1) ? wire_n1Oii_dataout : wire_n1l1i_dataout;
	assign		wire_n1iil_dataout = (nl0O0O === 1'b1) ? wire_n1Oil_dataout : wire_n1l1l_dataout;
	assign		wire_n1iiO_dataout = (nl0O0O === 1'b1) ? wire_n1OiO_dataout : wire_n1l1O_dataout;
	or(wire_n1il_dataout, wire_n01l_dataout, (~ nl0lll));
	assign		wire_n1ili_dataout = (nl0O0O === 1'b1) ? wire_n1Oli_dataout : wire_n1l0i_dataout;
	assign		wire_n1ill_dataout = (nl0i0O === 1'b1) ? wire_n1l0l_dataout : nl1li;
	assign		wire_n1ilO_dataout = (nl0i0O === 1'b1) ? wire_n1l0O_dataout : nl1ll;
	and(wire_n1iO_dataout, wire_n01O_dataout, ~{(~ nl0lll)});
	assign		wire_n1iOi_dataout = (nl0i0O === 1'b1) ? wire_n1lii_dataout : nl1lO;
	assign		wire_n1iOl_dataout = (nl0i0O === 1'b1) ? wire_n1lil_dataout : nl1Oi;
	assign		wire_n1iOO_dataout = (nl0i0O === 1'b1) ? wire_n1liO_dataout : nl1Ol;
	assign		wire_n1l0i_dataout = (nl0i0O === 1'b1) ? wire_n1lOi_dataout : nlOOi;
	or(wire_n1l0l_dataout, nl1li, nl0i1O);
	and(wire_n1l0O_dataout, nl1ll, ~{nl0i1O});
	assign		wire_n1l1i_dataout = (nl0i0O === 1'b1) ? wire_n1lli_dataout : nl1OO;
	assign		wire_n1l1l_dataout = (nl0i0O === 1'b1) ? wire_n1lll_dataout : nl01i;
	assign		wire_n1l1O_dataout = (nl0i0O === 1'b1) ? wire_n1llO_dataout : nl01l;
	and(wire_n1li_dataout, wire_n00i_dataout, ~{(~ nl0lll)});
	or(wire_n1lii_dataout, nl1lO, nl0i1O);
	or(wire_n1lil_dataout, nl1Oi, nl0i1O);
	or(wire_n1liO_dataout, nl1Ol, nl0i1O);
	or(wire_n1ll_dataout, wire_n00l_dataout, (~ nl0lll));
	or(wire_n1lli_dataout, nl1OO, nl0i1O);
	or(wire_n1lll_dataout, nl01i, nl0i1O);
	or(wire_n1llO_dataout, nl01l, nl0i1O);
	or(wire_n1lO_dataout, wire_n00O_dataout, wire_nill_dataout);
	or(wire_n1lOi_dataout, nlOOi, nl0i1O);
	or(wire_n1O0i_dataout, nl1lO, nl0iii);
	or(wire_n1O0l_dataout, nl1Oi, nl0iii);
	or(wire_n1O0O_dataout, nl1Ol, nl0iii);
	or(wire_n1O1l_dataout, nl1li, nl0iii);
	and(wire_n1O1O_dataout, nl1ll, ~{nl0iii});
	or(wire_n1Oi_dataout, wire_n0ii_dataout, wire_nill_dataout);
	or(wire_n1Oii_dataout, nl1OO, nl0iii);
	or(wire_n1Oil_dataout, nl01i, nl0iii);
	or(wire_n1OiO_dataout, nl01l, nl0iii);
	or(wire_n1Ol_dataout, wire_n0il_dataout, wire_nill_dataout);
	or(wire_n1Oli_dataout, nlOOi, nl0iii);
	or(wire_n1OO_dataout, wire_n0iO_dataout, wire_nill_dataout);
	and(wire_ni01i_dataout, wire_n0OOi_dataout, ~{nl0l1O});
	and(wire_ni01l_dataout, wire_n0OOl_dataout, ~{nl0l1O});
	and(wire_ni01O_dataout, wire_n0OOO_dataout, ~{nl0l1O});
	or(wire_ni0i_dataout, rxdatain[3], wire_nl1l_dataout);
	or(wire_ni0l_dataout, rxdatain[4], wire_nl1l_dataout);
	or(wire_ni0O_dataout, rxdatain[5], wire_nl1l_dataout);
	assign		wire_ni0Ol_dataout = (nl1i === 1'b1) ? wire_niO0l_dataout : wire_niiil_dataout;
	assign		wire_ni0OO_dataout = (nl1i === 1'b1) ? wire_niO0O_dataout : wire_niiiO_dataout;
	and(wire_ni10i_dataout, wire_ni1Oi_dataout, ~{(~ nl0lll)});
	and(wire_ni10l_dataout, wire_ni1Ol_dataout, ~{(~ nl0lll)});
	and(wire_ni10O_dataout, wire_ni1OO_dataout, ~{(~ nl0lll)});
	and(wire_ni11i_dataout, wire_ni1li_dataout, ~{(~ nl0lll)});
	or(wire_ni11l_dataout, wire_ni1ll_dataout, (~ nl0lll));
	and(wire_ni11O_dataout, wire_ni1lO_dataout, ~{(~ nl0lll)});
	and(wire_ni1i_dataout, rxdatain[0], ~{wire_nl1l_dataout});
	and(wire_ni1ii_dataout, wire_ni01i_dataout, ~{(~ nl0lll)});
	and(wire_ni1il_dataout, wire_ni01l_dataout, ~{(~ nl0lll)});
	and(wire_ni1iO_dataout, wire_ni01O_dataout, ~{(~ nl0lll)});
	or(wire_ni1l_dataout, rxdatain[1], wire_nl1l_dataout);
	or(wire_ni1li_dataout, wire_n0Oii_dataout, nl0l1O);
	or(wire_ni1ll_dataout, wire_n0Oil_dataout, nl0l1O);
	or(wire_ni1lO_dataout, wire_n0OiO_dataout, nl0l1O);
	or(wire_ni1O_dataout, rxdatain[2], wire_nl1l_dataout);
	or(wire_ni1Oi_dataout, wire_n0Oli_dataout, nl0l1O);
	and(wire_ni1Ol_dataout, wire_n0Oll_dataout, ~{nl0l1O});
	and(wire_ni1OO_dataout, wire_n0OlO_dataout, ~{nl0l1O});
	assign		wire_nii0i_dataout = (nl1i === 1'b1) ? wire_niOli_dataout : wire_niiOi_dataout;
	assign		wire_nii0l_dataout = (nl1i === 1'b1) ? wire_niOll_dataout : wire_niiOl_dataout;
	assign		wire_nii0O_dataout = (nl1i === 1'b1) ? wire_niOlO_dataout : wire_niiOO_dataout;
	assign		wire_nii1i_dataout = (nl1i === 1'b1) ? wire_niOii_dataout : wire_niili_dataout;
	assign		wire_nii1l_dataout = (nl1i === 1'b1) ? wire_niOil_dataout : wire_niill_dataout;
	assign		wire_nii1O_dataout = (nl1i === 1'b1) ? wire_niOiO_dataout : wire_niilO_dataout;
	or(wire_niii_dataout, rxdatain[6], wire_nl1l_dataout);
	assign		wire_niiii_dataout = (nl1i === 1'b1) ? wire_niOOi_dataout : wire_nil1i_dataout;
	and(wire_niiil_dataout, wire_nil1l_dataout, ~{(~ nl0lll)});
	or(wire_niiiO_dataout, wire_nil1O_dataout, (~ nl0lll));
	or(wire_niil_dataout, rxdatain[7], wire_nl1l_dataout);
	and(wire_niili_dataout, wire_nil0i_dataout, ~{(~ nl0lll)});
	and(wire_niill_dataout, wire_nil0l_dataout, ~{(~ nl0lll)});
	and(wire_niilO_dataout, wire_nil0O_dataout, ~{(~ nl0lll)});
	and(wire_niiOi_dataout, wire_nilii_dataout, ~{(~ nl0lll)});
	and(wire_niiOl_dataout, wire_nilil_dataout, ~{(~ nl0lll)});
	and(wire_niiOO_dataout, wire_niliO_dataout, ~{(~ nl0lll)});
	or(wire_nil0i_dataout, wire_nilOi_dataout, nl0Oli);
	or(wire_nil0l_dataout, wire_nilOl_dataout, nl0Oli);
	and(wire_nil0O_dataout, wire_nilOO_dataout, ~{nl0Oli});
	and(wire_nil1i_dataout, wire_nilli_dataout, ~{(~ nl0lll)});
	or(wire_nil1l_dataout, wire_nilll_dataout, nl0Oli);
	or(wire_nil1O_dataout, wire_nillO_dataout, nl0Oli);
	and(wire_nilii_dataout, wire_niO1i_dataout, ~{nl0Oli});
	and(wire_nilil_dataout, wire_niO1l_dataout, ~{nl0Oli});
	and(wire_niliO_dataout, wire_niO1O_dataout, ~{nl0Oli});
	and(wire_nill_dataout, nl0Oli, ~{(~ nl0lll)});
	and(wire_nilli_dataout, wire_niO0i_dataout, ~{nl0Oli});
	or(wire_nilll_dataout, rxctrl[2], wire_nl0i_dataout);
	and(wire_nillO_dataout, rxdatain[16], ~{wire_nl0i_dataout});
	and(wire_nilO_dataout, (~ nl0Oli), ~{(~ nl0lll)});
	or(wire_nilOi_dataout, rxdatain[17], wire_nl0i_dataout);
	or(wire_nilOl_dataout, rxdatain[18], wire_nl0i_dataout);
	or(wire_nilOO_dataout, rxdatain[19], wire_nl0i_dataout);
	or(wire_niO0i_dataout, rxdatain[23], wire_nl0i_dataout);
	and(wire_niO0l_dataout, wire_niOOl_dataout, ~{(~ nl0lll)});
	and(wire_niO0O_dataout, wire_niOOO_dataout, ~{(~ nl0lll)});
	or(wire_niO1i_dataout, rxdatain[20], wire_nl0i_dataout);
	or(wire_niO1l_dataout, rxdatain[21], wire_nl0i_dataout);
	or(wire_niO1O_dataout, rxdatain[22], wire_nl0i_dataout);
	and(wire_niOii_dataout, wire_nl11i_dataout, ~{(~ nl0lll)});
	and(wire_niOil_dataout, wire_nl11l_dataout, ~{(~ nl0lll)});
	and(wire_niOiO_dataout, wire_nl11O_dataout, ~{(~ nl0lll)});
	and(wire_niOli_dataout, wire_nl10i_dataout, ~{(~ nl0lll)});
	and(wire_niOll_dataout, wire_nl10l_dataout, ~{(~ nl0lll)});
	and(wire_niOlO_dataout, wire_nl10O_dataout, ~{(~ nl0lll)});
	and(wire_niOOi_dataout, wire_nl1ii_dataout, ~{(~ nl0lll)});
	or(wire_niOOl_dataout, wire_nilll_dataout, nl0l0i);
	or(wire_niOOO_dataout, wire_nillO_dataout, nl0l0i);
	assign		wire_nl00i_dataout = (nl1i === 1'b1) ? wire_nllli_dataout : wire_nl0Oi_dataout;
	assign		wire_nl00l_dataout = (nl1i === 1'b1) ? wire_nllll_dataout : wire_nl0Ol_dataout;
	assign		wire_nl00O_dataout = (nl1i === 1'b1) ? wire_nlllO_dataout : wire_nl0OO_dataout;
	assign		wire_nl01O_dataout = (nl1i === 1'b1) ? wire_nlliO_dataout : wire_nl0lO_dataout;
	and(wire_nl0i_dataout, rxrunningdisp[2], ~{nllOiO});
	assign		wire_nl0ii_dataout = (nl1i === 1'b1) ? wire_nllOi_dataout : wire_nli1i_dataout;
	assign		wire_nl0il_dataout = (nl1i === 1'b1) ? wire_nllOl_dataout : wire_nli1l_dataout;
	assign		wire_nl0iO_dataout = (nl1i === 1'b1) ? wire_nllOO_dataout : wire_nli1O_dataout;
	and(wire_nl0l_dataout, rxrunningdisp[3], ~{nllOiO});
	assign		wire_nl0li_dataout = (nl1i === 1'b1) ? wire_nlO1i_dataout : wire_nli0i_dataout;
	assign		wire_nl0ll_dataout = (nl1i === 1'b1) ? wire_nlO1l_dataout : wire_nli0l_dataout;
	and(wire_nl0lO_dataout, wire_nli0O_dataout, ~{(~ nl0lll)});
	and(wire_nl0Oi_dataout, wire_nliii_dataout, ~{(~ nl0lll)});
	and(wire_nl0Ol_dataout, wire_nliil_dataout, ~{(~ nl0lll)});
	and(wire_nl0OO_dataout, wire_nliiO_dataout, ~{(~ nl0lll)});
	and(wire_nl10i_dataout, wire_niO1i_dataout, ~{nl0l0i});
	and(wire_nl10l_dataout, wire_niO1l_dataout, ~{nl0l0i});
	and(wire_nl10O_dataout, wire_niO1O_dataout, ~{nl0l0i});
	or(wire_nl11i_dataout, wire_nilOi_dataout, nl0l0i);
	or(wire_nl11l_dataout, wire_nilOl_dataout, nl0l0i);
	and(wire_nl11O_dataout, wire_nilOO_dataout, ~{nl0l0i});
	and(wire_nl1ii_dataout, wire_niO0i_dataout, ~{nl0l0i});
	and(wire_nl1l_dataout, rxrunningdisp[0], ~{nllOiO});
	and(wire_nl1O_dataout, rxrunningdisp[1], ~{nllOiO});
	and(wire_nli0i_dataout, wire_nliOi_dataout, ~{(~ nl0lll)});
	and(wire_nli0l_dataout, wire_nliOl_dataout, ~{(~ nl0lll)});
	or(wire_nli0O_dataout, wire_nliOO_dataout, nl0Oli);
	and(wire_nli1i_dataout, wire_nlili_dataout, ~{(~ nl0lll)});
	and(wire_nli1l_dataout, wire_nlill_dataout, ~{(~ nl0lll)});
	and(wire_nli1O_dataout, wire_nlilO_dataout, ~{(~ nl0lll)});
	or(wire_nliii_dataout, wire_nll1i_dataout, nl0Oli);
	or(wire_nliil_dataout, wire_nll1l_dataout, nl0Oli);
	or(wire_nliiO_dataout, wire_nll1O_dataout, nl0Oli);
	and(wire_nlili_dataout, wire_nll0i_dataout, ~{nl0Oli});
	and(wire_nlill_dataout, wire_nll0l_dataout, ~{nl0Oli});
	and(wire_nlilO_dataout, wire_nll0O_dataout, ~{nl0Oli});
	and(wire_nliOi_dataout, wire_nllii_dataout, ~{nl0Oli});
	and(wire_nliOl_dataout, wire_nllil_dataout, ~{nl0Oli});
	or(wire_nliOO_dataout, rxctrl[1], wire_nl1O_dataout);
	or(wire_nll0i_dataout, rxdatain[11], wire_nl1O_dataout);
	or(wire_nll0l_dataout, rxdatain[12], wire_nl1O_dataout);
	or(wire_nll0O_dataout, rxdatain[13], wire_nl1O_dataout);
	and(wire_nll1i_dataout, rxdatain[8], ~{wire_nl1O_dataout});
	or(wire_nll1l_dataout, rxdatain[9], wire_nl1O_dataout);
	or(wire_nll1O_dataout, rxdatain[10], wire_nl1O_dataout);
	or(wire_nllii_dataout, rxdatain[14], wire_nl1O_dataout);
	or(wire_nllil_dataout, rxdatain[15], wire_nl1O_dataout);
	and(wire_nlliO_dataout, wire_nlO1O_dataout, ~{(~ nl0lll)});
	and(wire_nllli_dataout, wire_nlO0i_dataout, ~{(~ nl0lll)});
	and(wire_nllll_dataout, wire_nlO0l_dataout, ~{(~ nl0lll)});
	and(wire_nlllO_dataout, wire_nlO0O_dataout, ~{(~ nl0lll)});
	and(wire_nllOi_dataout, wire_nlOii_dataout, ~{(~ nl0lll)});
	and(wire_nllOl_dataout, wire_nlOil_dataout, ~{(~ nl0lll)});
	and(wire_nllOO_dataout, wire_nlOiO_dataout, ~{(~ nl0lll)});
	assign		wire_nlO00i_dataout = (nl00li === 1'b1) ? wire_nlO0Oi_dataout : n0i1O;
	and(wire_nlO00l_dataout, nllO1l, ~{nl00iO});
	or(wire_nlO00O_dataout, n0i0i, nl00iO);
	assign		wire_nlO01i_dataout = (nl00li === 1'b1) ? wire_nlO0li_dataout : n0iil;
	assign		wire_nlO01l_dataout = (nl00li === 1'b1) ? wire_nlO0ll_dataout : n0iiO;
	assign		wire_nlO01O_dataout = (nl00li === 1'b1) ? wire_nlO0lO_dataout : ni00l;
	or(wire_nlO0i_dataout, wire_nll1i_dataout, nl0lii);
	or(wire_nlO0ii_dataout, n0i0l, nl00iO);
	or(wire_nlO0il_dataout, n0i0O, nl00iO);
	or(wire_nlO0iO_dataout, n0iii, nl00iO);
	or(wire_nlO0l_dataout, wire_nll1l_dataout, nl0lii);
	or(wire_nlO0li_dataout, n0iil, nl00iO);
	or(wire_nlO0ll_dataout, n0iiO, nl00iO);
	or(wire_nlO0lO_dataout, ni00l, nl00iO);
	or(wire_nlO0O_dataout, wire_nll1O_dataout, nl0lii);
	or(wire_nlO0Oi_dataout, n0i1O, nl00iO);
	and(wire_nlO10i_dataout, wire_nlO1lO_dataout, ~{nllOiO});
	and(wire_nlO10l_dataout, wire_nlO1Oi_dataout, ~{nllOiO});
	and(wire_nlO10O_dataout, wire_nlO1Ol_dataout, ~{nllOiO});
	and(wire_nlO11l_dataout, wire_nlO00i_dataout, ~{nllOiO});
	or(wire_nlO11O_dataout, wire_nlO1ll_dataout, nllOiO);
	and(wire_nlO1i_dataout, wire_nlOli_dataout, ~{(~ nl0lll)});
	and(wire_nlO1ii_dataout, wire_nlO1OO_dataout, ~{nllOiO});
	and(wire_nlO1il_dataout, wire_nlO01i_dataout, ~{nllOiO});
	and(wire_nlO1iO_dataout, wire_nlO01l_dataout, ~{nllOiO});
	and(wire_nlO1l_dataout, wire_nlOll_dataout, ~{(~ nl0lll)});
	and(wire_nlO1li_dataout, wire_nlO01O_dataout, ~{nllOiO});
	assign		wire_nlO1ll_dataout = (nl00li === 1'b1) ? wire_nlO00l_dataout : nllO1l;
	assign		wire_nlO1lO_dataout = (nl00li === 1'b1) ? wire_nlO00O_dataout : n0i0i;
	or(wire_nlO1O_dataout, wire_nliOO_dataout, nl0lii);
	assign		wire_nlO1Oi_dataout = (nl00li === 1'b1) ? wire_nlO0ii_dataout : n0i0l;
	assign		wire_nlO1Ol_dataout = (nl00li === 1'b1) ? wire_nlO0il_dataout : n0i0O;
	assign		wire_nlO1OO_dataout = (nl00li === 1'b1) ? wire_nlO0iO_dataout : n0iii;
	and(wire_nlOii_dataout, wire_nll0i_dataout, ~{nl0lii});
	and(wire_nlOil_dataout, wire_nll0l_dataout, ~{nl0lii});
	and(wire_nlOill_dataout, wire_nlOl0l_dataout, ~{nllOiO});
	and(wire_nlOilO_dataout, wire_nlOl0O_dataout, ~{nllOiO});
	and(wire_nlOiO_dataout, wire_nll0O_dataout, ~{nl0lii});
	and(wire_nlOiOi_dataout, wire_nlOlii_dataout, ~{nllOiO});
	and(wire_nlOiOl_dataout, wire_nlOlil_dataout, ~{nllOiO});
	and(wire_nlOiOO_dataout, wire_nlOliO_dataout, ~{nllOiO});
	and(wire_nlOl0i_dataout, wire_nlOlOi_dataout, ~{nllOiO});
	assign		wire_nlOl0l_dataout = (nl00Oi === 1'b1) ? wire_n110i_dataout : wire_nlOlOl_dataout;
	assign		wire_nlOl0O_dataout = (nl00Oi === 1'b1) ? wire_n110l_dataout : wire_nlOlOO_dataout;
	and(wire_nlOl1i_dataout, wire_nlOlli_dataout, ~{nllOiO});
	and(wire_nlOl1l_dataout, wire_nlOlll_dataout, ~{nllOiO});
	and(wire_nlOl1O_dataout, wire_nlOllO_dataout, ~{nllOiO});
	and(wire_nlOli_dataout, wire_nllii_dataout, ~{nl0lii});
	assign		wire_nlOlii_dataout = (nl00Oi === 1'b1) ? wire_n110O_dataout : wire_nlOO1i_dataout;
	assign		wire_nlOlil_dataout = (nl00Oi === 1'b1) ? wire_n11ii_dataout : wire_nlOO1l_dataout;
	assign		wire_nlOliO_dataout = (nl00Oi === 1'b1) ? wire_n11il_dataout : wire_nlOO1O_dataout;
	and(wire_nlOll_dataout, wire_nllil_dataout, ~{nl0lii});
	assign		wire_nlOlli_dataout = (nl00Oi === 1'b1) ? wire_n11iO_dataout : wire_nlOO0i_dataout;
	assign		wire_nlOlll_dataout = (nl00Oi === 1'b1) ? wire_n11li_dataout : wire_nlOO0l_dataout;
	assign		wire_nlOllO_dataout = (nl00Oi === 1'b1) ? wire_n11ll_dataout : wire_nlOO0O_dataout;
	assign		wire_nlOlOi_dataout = (nl00Oi === 1'b1) ? wire_n11lO_dataout : wire_nlOOii_dataout;
	assign		wire_nlOlOl_dataout = (niiO === 1'b1) ? wire_nlOOil_dataout : ni00O;
	assign		wire_nlOlOO_dataout = (niiO === 1'b1) ? wire_nlOOiO_dataout : ni0ii;
	assign		wire_nlOO0i_dataout = (niiO === 1'b1) ? wire_nlOOOi_dataout : ni0ll;
	assign		wire_nlOO0l_dataout = (niiO === 1'b1) ? wire_nlOOOl_dataout : ni0lO;
	assign		wire_nlOO0O_dataout = (niiO === 1'b1) ? wire_nlOOOO_dataout : ni0Oi;
	assign		wire_nlOO1i_dataout = (niiO === 1'b1) ? wire_nlOOli_dataout : ni0il;
	assign		wire_nlOO1l_dataout = (niiO === 1'b1) ? wire_nlOOll_dataout : ni0iO;
	assign		wire_nlOO1O_dataout = (niiO === 1'b1) ? wire_nlOOlO_dataout : ni0li;
	assign		wire_nlOOii_dataout = (niiO === 1'b1) ? wire_n111i_dataout : nl1iO;
	or(wire_nlOOil_dataout, ni00O, nl00Ol);
	and(wire_nlOOiO_dataout, ni0ii, ~{nl00Ol});
	or(wire_nlOOli_dataout, ni0il, nl00Ol);
	or(wire_nlOOll_dataout, ni0iO, nl00Ol);
	or(wire_nlOOlO_dataout, ni0li, nl00Ol);
	or(wire_nlOOOi_dataout, ni0ll, nl00Ol);
	or(wire_nlOOOl_dataout, ni0lO, nl00Ol);
	or(wire_nlOOOO_dataout, ni0Oi, nl00Ol);
	assign
		nl00iO = (nli00i | wire_nl0l_dataout),
		nl00li = ((nl00Oi | nl0lOO) | (~ nl00ll59)),
		nl00Oi = (nl0O0O | nl0O1l),
		nl00Ol = (wire_nl0i_dataout | ((nli1ll & nli00O) & nl00OO56)),
		nl0i0O = (niiO | nili),
		nl0i1l = (wire_nl0i_dataout | nli00O),
		nl0i1O = (wire_nl1O_dataout | ((nli1Oi & nli0li) & nl0i0i53)),
		nl0iii = ((wire_nl1O_dataout | nli0li) | (~ nl0iil50)),
		nl0ili = (wire_nl1l_dataout | ((nli1OO & nli0lO) & nl0ill47)),
		nl0iOi = ((niiO | ((niOl | nili) | (~ nl0l1i41))) | (~ nl0iOl44)),
		nl0l0i = ((nl0O1l | nl0lii) | (~ nl0l0l38)),
		nl0l1O = (nl0lOO | nl0l0i),
		nl0lii = (nl0O0O | nl0Oli),
		nl0lli = (((((((rxdatain[24] & (~ rxdatain[25])) & rxdatain[26]) & rxdatain[27]) & rxdatain[28]) & rxdatain[29]) & rxdatain[30]) & rxdatain[31]),
		nl0lll = ((((rxdatavalid[3] & rxdatavalid[2]) & rxdatavalid[1]) & rxdatavalid[0]) & nl0llO32),
		nl0lOl = 1'b1,
		nl0lOO = ((~ wire_nl0i_dataout) & (rxctrl[2] & nl0O1i)),
		nl0O0l = (((((((rxdatain[8] & (~ rxdatain[9])) & rxdatain[10]) & rxdatain[11]) & rxdatain[12]) & rxdatain[13]) & rxdatain[14]) & rxdatain[15]),
		nl0O0O = (((~ wire_nl1l_dataout) & (rxctrl[0] & nl0OiO)) & nl0Oii26),
		nl0O1i = (((((((rxdatain[16] & (~ rxdatain[17])) & rxdatain[18]) & rxdatain[19]) & rxdatain[20]) & rxdatain[21]) & rxdatain[22]) & rxdatain[23]),
		nl0O1l = ((~ wire_nl1O_dataout) & ((rxctrl[1] & nl0O0l) & nl0O1O29)),
		nl0OiO = (((((((rxdatain[0] & (~ rxdatain[1])) & rxdatain[2]) & rxdatain[3]) & rxdatain[4]) & rxdatain[5]) & rxdatain[6]) & rxdatain[7]),
		nl0Oli = (((~ ((((nli1OO | nli1Oi) | nli1ll) | (((~ rxctrl[3]) | (~ nli1li)) | (~ nli1il11))) | (~ nli10O14))) | (~ ((((nli0lO | nli0li) | nli00O) | nli00i) | (~ nli10i17)))) | (~ (((((((~ rxctrl[3]) | (~ nli11O)) | (~ nli11i20)) | ((~ rxctrl[2]) | (~ nl0OOO))) | ((~ rxctrl[1]) | (~ nl0OOl))) | ((~ rxctrl[0]) | (~ nl0OOi))) | (~ nl0Oll23)))),
		nl0OOi = ((((((((~ rxdatain[0]) & (~ rxdatain[1])) & rxdatain[2]) & rxdatain[3]) & rxdatain[4]) & (~ rxdatain[5])) & (~ rxdatain[6])) & (~ rxdatain[7])),
		nl0OOl = ((((((((~ rxdatain[8]) & (~ rxdatain[9])) & rxdatain[10]) & rxdatain[11]) & rxdatain[12]) & (~ rxdatain[13])) & (~ rxdatain[14])) & (~ rxdatain[15])),
		nl0OOO = ((((((((~ rxdatain[16]) & (~ rxdatain[17])) & rxdatain[18]) & rxdatain[19]) & rxdatain[20]) & (~ rxdatain[21])) & (~ rxdatain[22])) & (~ rxdatain[23])),
		nli00i = ((~ rxctrl[3]) | (~ nli00l)),
		nli00l = ((((((((~ rxdatain[24]) & (~ rxdatain[25])) & rxdatain[26]) & rxdatain[27]) & rxdatain[28]) & rxdatain[29]) & (~ rxdatain[30])) & rxdatain[31]),
		nli00O = (((~ rxctrl[2]) | (~ nli0iO)) | (~ nli0ii5)),
		nli01O = ((((((((~ rxdatain[0]) & (~ rxdatain[1])) & rxdatain[2]) & rxdatain[3]) & rxdatain[4]) & rxdatain[5]) & rxdatain[6]) & (~ rxdatain[7])),
		nli0iO = ((((((((~ rxdatain[16]) & (~ rxdatain[17])) & rxdatain[18]) & rxdatain[19]) & rxdatain[20]) & rxdatain[21]) & (~ rxdatain[22])) & rxdatain[23]),
		nli0li = ((~ rxctrl[1]) | (~ nli0ll)),
		nli0ll = ((((((((~ rxdatain[8]) & (~ rxdatain[9])) & rxdatain[10]) & rxdatain[11]) & rxdatain[12]) & rxdatain[13]) & (~ rxdatain[14])) & rxdatain[15]),
		nli0lO = (((~ rxctrl[0]) | (~ nlii1l)) | (~ nli0Oi2)),
		nli11O = ((((((((~ rxdatain[24]) & (~ rxdatain[25])) & rxdatain[26]) & rxdatain[27]) & rxdatain[28]) & (~ rxdatain[29])) & (~ rxdatain[30])) & (~ rxdatain[31])),
		nli1li = ((((((((~ rxdatain[24]) & (~ rxdatain[25])) & rxdatain[26]) & rxdatain[27]) & rxdatain[28]) & rxdatain[29]) & rxdatain[30]) & (~ rxdatain[31])),
		nli1ll = ((~ rxctrl[2]) | (~ nli1lO)),
		nli1lO = ((((((((~ rxdatain[16]) & (~ rxdatain[17])) & rxdatain[18]) & rxdatain[19]) & rxdatain[20]) & rxdatain[21]) & rxdatain[22]) & (~ rxdatain[23])),
		nli1Oi = ((~ rxctrl[1]) | (~ nli1Ol)),
		nli1Ol = ((((((((~ rxdatain[8]) & (~ rxdatain[9])) & rxdatain[10]) & rxdatain[11]) & rxdatain[12]) & rxdatain[13]) & rxdatain[14]) & (~ rxdatain[15])),
		nli1OO = (((~ rxctrl[0]) | (~ nli01O)) | (~ nli01i8)),
		nlii1l = ((((((((~ rxdatain[0]) & (~ rxdatain[1])) & rxdatain[2]) & rxdatain[3]) & rxdatain[4]) & rxdatain[5]) & (~ rxdatain[6])) & rxdatain[7]),
		rxctrlout = {nllOli, nlOi1O, n11OO, nllllO},
		rxdataout = {nlOi1l, nlO11i, nllOOO, nllOOl, nllOOi, nllOlO, nllOll, nlllll, n11Ol, nlOili, nlOiiO, nlOiil, nlOiii, nlOi0O, nlOi0l, nlOi0i, n1OlO, n10ii, n100O, n100l, n100i, n101O, n101l, n101i, nllO1i, n011i, n1OOO, nlllOO, nlllOl, nlllOi, n1OOl, n1OOi};
endmodule //altgxb_xgm_rx_sm
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 75 mux21 20 oper_selector 10 
`timescale 1 ps / 1 ps
module  altgxb_xgm_dskw_sm
	( 
	adet,
	alignstatus,
	enabledeskew,
	fiforesetrd,
	rdalign,
	recovclk,
	resetall,
	syncstatus) /* synthesis synthesis_clearbox=1 */;
	input   [3:0]  adet;
	output   alignstatus;
	output   enabledeskew;
	output   fiforesetrd;
	input   [3:0]  rdalign;
	input   recovclk;
	input   resetall;
	input   [3:0]  syncstatus;

	reg	nl0li58;
	reg	nl0li59;
	reg	nl0li60;
	reg	nl0ll55;
	reg	nl0ll56;
	reg	nl0ll57;
	reg	nl0Oi52;
	reg	nl0Oi53;
	reg	nl0Oi54;
	reg	nl0OO49;
	reg	nl0OO50;
	reg	nl0OO51;
	reg	nli0l40;
	reg	nli0l41;
	reg	nli0l42;
	reg	nli1l46;
	reg	nli1l47;
	reg	nli1l48;
	reg	nli1O43;
	reg	nli1O44;
	reg	nli1O45;
	reg	nliii37;
	reg	nliii38;
	reg	nliii39;
	reg	nliiO34;
	reg	nliiO35;
	reg	nliiO36;
	reg	nlill31;
	reg	nlill32;
	reg	nlill33;
	reg	nlilO28;
	reg	nlilO29;
	reg	nlilO30;
	reg	nliOl25;
	reg	nliOl26;
	reg	nliOl27;
	reg	nliOO22;
	reg	nliOO23;
	reg	nliOO24;
	reg	nll0l13;
	reg	nll0l14;
	reg	nll0l15;
	reg	nll1l19;
	reg	nll1l20;
	reg	nll1l21;
	reg	nll1O16;
	reg	nll1O17;
	reg	nll1O18;
	reg	nllil10;
	reg	nllil11;
	reg	nllil12;
	reg	nllOi7;
	reg	nllOi8;
	reg	nllOi9;
	reg	nlO0l1;
	reg	nlO0l2;
	reg	nlO0l3;
	reg	nlO1l4;
	reg	nlO1l5;
	reg	nlO1l6;
	reg	n1ll;
	reg	n1lO;
	reg	n1Oi;
	reg	n1OO;
	reg	n01i;
	reg	n0i;
	reg	n0l;
	reg	n1i;
	reg	n1l;
	reg	n1O;
	reg	nii;
	reg	nil;
	reg	nli;
	reg	nlOl;
	reg	nlOO;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niil_dataout;
	wire	wire_nili_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nllO_dataout;
	wire  wire_n00i_o;
	wire  wire_n00l_o;
	wire  wire_n00O_o;
	wire  wire_n01l_o;
	wire  wire_n0il_o;
	wire  wire_n0li_o;
	wire  wire_n0lO_o;
	wire  wire_n0Ol_o;
	wire  wire_ni1i_o;
	wire  wire_ni1O_o;
	wire  nl0lO;
	wire  nli0i;
	wire  nli1i;
	wire  nliil;
	wire  nliOi;
	wire  nll0i;
	wire  nll1i;
	wire  nllii;
	wire  nllli;
	wire  nllll;
	wire  nlllO;
	wire  nllOO;
	wire  nlO0i;
	wire  nlO1i;

	initial
		nl0li58 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nl0li58 <= nl0li60;
	initial
		nl0li59 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nl0li59 <= (nl0li60 ^ nl0li58);
	initial
		nl0li60 = 0;
	always @ ( posedge recovclk)
		  nl0li60 <= nl0li58;
	initial
		nl0ll55 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nl0ll55 <= nl0ll57;
	initial
		nl0ll56 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nl0ll56 <= (nl0ll57 ^ nl0ll55);
	initial
		nl0ll57 = 0;
	always @ ( posedge recovclk)
		  nl0ll57 <= nl0ll55;
	initial
		nl0Oi52 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nl0Oi52 <= nl0Oi54;
	initial
		nl0Oi53 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nl0Oi53 <= (nl0Oi54 ^ nl0Oi52);
	initial
		nl0Oi54 = 0;
	always @ ( posedge recovclk)
		  nl0Oi54 <= nl0Oi52;
	initial
		nl0OO49 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nl0OO49 <= nl0OO51;
	initial
		nl0OO50 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nl0OO50 <= (nl0OO51 ^ nl0OO49);
	initial
		nl0OO51 = 0;
	always @ ( posedge recovclk)
		  nl0OO51 <= nl0OO49;
	initial
		nli0l40 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nli0l40 <= nli0l42;
	initial
		nli0l41 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nli0l41 <= (nli0l42 ^ nli0l40);
	initial
		nli0l42 = 0;
	always @ ( posedge recovclk)
		  nli0l42 <= nli0l40;
	initial
		nli1l46 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nli1l46 <= nli1l48;
	initial
		nli1l47 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nli1l47 <= (nli1l48 ^ nli1l46);
	initial
		nli1l48 = 0;
	always @ ( posedge recovclk)
		  nli1l48 <= nli1l46;
	initial
		nli1O43 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nli1O43 <= nli1O45;
	initial
		nli1O44 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nli1O44 <= (nli1O45 ^ nli1O43);
	initial
		nli1O45 = 0;
	always @ ( posedge recovclk)
		  nli1O45 <= nli1O43;
	initial
		nliii37 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nliii37 <= nliii39;
	initial
		nliii38 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nliii38 <= (nliii39 ^ nliii37);
	initial
		nliii39 = 0;
	always @ ( posedge recovclk)
		  nliii39 <= nliii37;
	initial
		nliiO34 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nliiO34 <= nliiO36;
	initial
		nliiO35 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nliiO35 <= (nliiO36 ^ nliiO34);
	initial
		nliiO36 = 0;
	always @ ( posedge recovclk)
		  nliiO36 <= nliiO34;
	initial
		nlill31 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nlill31 <= nlill33;
	initial
		nlill32 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nlill32 <= (nlill33 ^ nlill31);
	initial
		nlill33 = 0;
	always @ ( posedge recovclk)
		  nlill33 <= nlill31;
	initial
		nlilO28 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nlilO28 <= nlilO30;
	initial
		nlilO29 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nlilO29 <= (nlilO30 ^ nlilO28);
	initial
		nlilO30 = 0;
	always @ ( posedge recovclk)
		  nlilO30 <= nlilO28;
	initial
		nliOl25 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nliOl25 <= nliOl27;
	initial
		nliOl26 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nliOl26 <= (nliOl27 ^ nliOl25);
	initial
		nliOl27 = 0;
	always @ ( posedge recovclk)
		  nliOl27 <= nliOl25;
	initial
		nliOO22 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nliOO22 <= nliOO24;
	initial
		nliOO23 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nliOO23 <= (nliOO24 ^ nliOO22);
	initial
		nliOO24 = 0;
	always @ ( posedge recovclk)
		  nliOO24 <= nliOO22;
	initial
		nll0l13 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nll0l13 <= nll0l15;
	initial
		nll0l14 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nll0l14 <= (nll0l15 ^ nll0l13);
	initial
		nll0l15 = 0;
	always @ ( posedge recovclk)
		  nll0l15 <= nll0l13;
	initial
		nll1l19 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nll1l19 <= nll1l21;
	initial
		nll1l20 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nll1l20 <= (nll1l21 ^ nll1l19);
	initial
		nll1l21 = 0;
	always @ ( posedge recovclk)
		  nll1l21 <= nll1l19;
	initial
		nll1O16 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nll1O16 <= nll1O18;
	initial
		nll1O17 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nll1O17 <= (nll1O18 ^ nll1O16);
	initial
		nll1O18 = 0;
	always @ ( posedge recovclk)
		  nll1O18 <= nll1O16;
	initial
		nllil10 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nllil10 <= nllil12;
	initial
		nllil11 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nllil11 <= (nllil12 ^ nllil10);
	initial
		nllil12 = 0;
	always @ ( posedge recovclk)
		  nllil12 <= nllil10;
	initial
		nllOi7 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nllOi7 <= nllOi9;
	initial
		nllOi8 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nllOi8 <= (nllOi9 ^ nllOi7);
	initial
		nllOi9 = 0;
	always @ ( posedge recovclk)
		  nllOi9 <= nllOi7;
	initial
		nlO0l1 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nlO0l1 <= nlO0l3;
	initial
		nlO0l2 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nlO0l2 <= (nlO0l3 ^ nlO0l1);
	initial
		nlO0l3 = 0;
	always @ ( posedge recovclk)
		  nlO0l3 <= nlO0l1;
	initial
		nlO1l4 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nlO1l4 <= nlO1l6;
	initial
		nlO1l5 = {1{1'b1}};
	always @ ( posedge recovclk)
		  nlO1l5 <= (nlO1l6 ^ nlO1l4);
	initial
		nlO1l6 = 0;
	always @ ( posedge recovclk)
		  nlO1l6 <= nlO1l4;
	initial
	begin
		n1ll = 0;
		n1lO = 0;
		n1Oi = 0;
		n1OO = 0;
	end
	always @ ( posedge recovclk or posedge resetall)
	begin
		if (resetall == 1'b1) 
		begin
			n1ll <= 1;
			n1lO <= 1;
			n1Oi <= 1;
			n1OO <= 1;
		end
		else 
		begin
			n1ll <= wire_n00l_o;
			n1lO <= n1Oi;
			n1Oi <= n1OO;
			n1OO <= wire_n00i_o;
		end
	end
	initial
	begin
		n01i = 0;
		n0i = 0;
		n0l = 0;
		n1i = 0;
		n1l = 0;
		n1O = 0;
		nii = 0;
		nil = 0;
		nli = 0;
		nlOl = 0;
		nlOO = 0;
	end
	always @ ( posedge recovclk or posedge resetall)
	begin
		if (resetall == 1'b1) 
		begin
			n01i <= 0;
			n0i <= 0;
			n0l <= 0;
			n1i <= 0;
			n1l <= 0;
			n1O <= 0;
			nii <= 0;
			nil <= 0;
			nli <= 0;
			nlOl <= 0;
			nlOO <= 0;
		end
		else 
		begin
			n01i <= (((syncstatus[3] & syncstatus[2]) & syncstatus[1]) & syncstatus[0]);
			n0i <= wire_ni1i_o;
			n0l <= wire_ni1O_o;
			n1i <= wire_n0li_o;
			n1l <= wire_n0lO_o;
			n1O <= wire_n0Ol_o;
			nii <= nil;
			nil <= wire_n01l_o;
			nli <= n01i;
			nlOl <= wire_n00O_o;
			nlOO <= wire_n0il_o;
		end
	end
	or(wire_ni0l_dataout, n1OO, nllii);
	and(wire_ni0O_dataout, nil, ~{nllii});
	and(wire_niii_dataout, nlO0i, ~{nllii});
	and(wire_niil_dataout, (~ nlO0i), ~{nllii});
	and(wire_nili_dataout, wire_niOi_dataout, ~{(~ nli)});
	and(wire_nill_dataout, wire_niOl_dataout, ~{(~ nli)});
	and(wire_nilO_dataout, nlO1i, ~{(~ nli)});
	and(wire_niOi_dataout, nlO0i, ~{nlO1i});
	and(wire_niOl_dataout, (~ nlO0i), ~{nlO1i});
	or(wire_niOO_dataout, n1OO, (~ nli));
	and(wire_nl0i_dataout, (~ nlO0i), ~{nllll});
	and(wire_nl0l_dataout, nlO0i, ~{nllll});
	or(wire_nl0O_dataout, nil, nlO0i);
	and(wire_nl1i_dataout, nil, ~{(~ nli)});
	and(wire_nl1l_dataout, (~ nlO1i), ~{(~ nli)});
	assign		wire_nl1O_dataout = (nllll === 1'b1) ? nil : wire_nl0O_dataout;
	or(wire_nlii_dataout, n1OO, nllll);
	and(wire_nlil_dataout, (~ nllli), ~{nllll});
	and(wire_nliO_dataout, nllli, ~{nllll});
	and(wire_nllO_dataout, n1OO, ~{nlllO});
	oper_selector   n00i
	( 
	.data({wire_nllO_dataout, {3{wire_nlii_dataout}}, {3{wire_niOO_dataout}}, wire_ni0l_dataout}),
	.o(wire_n00i_o),
	.sel({n1ll, nlOl, nlOO, n1i, n1l, n1O, n0i, n0l}));
	defparam
		n00i.width_data = 8,
		n00i.width_sel = 8;
	oper_selector   n00l
	( 
	.data({(~ nlllO), {3{nllll}}, (~ nli), (nl0li59 & (~ nli)), (~ nli), nllii}),
	.o(wire_n00l_o),
	.sel({n1ll, nlOl, nlOO, n1i, n1l, n1O, n0i, n0l}));
	defparam
		n00l.width_data = 8,
		n00l.width_sel = 8;
	oper_selector   n00O
	( 
	.data({nlllO, wire_nlil_dataout, 1'b0}),
	.o(wire_n00O_o),
	.sel({n1ll, (nl0ll56 & nlOl), nl0lO}));
	defparam
		n00O.width_data = 3,
		n00O.width_sel = 3;
	oper_selector   n01l
	( 
	.data({nil, wire_nl1O_dataout, {3{wire_nl1i_dataout}}, wire_ni0O_dataout}),
	.o(wire_n01l_o),
	.sel({((nlOO | nlOl) | n1ll), n1i, n1l, n1O, n0i, n0l}));
	defparam
		n01l.width_data = 6,
		n01l.width_sel = 6;
	oper_selector   n0il
	( 
	.data({1'b0, (nl0OO50 & wire_nliO_dataout), wire_nl0i_dataout}),
	.o(wire_n0il_o),
	.sel({nli1i, nlOl, nlOO}));
	defparam
		n0il.width_data = 3,
		n0il.width_sel = 3;
	oper_selector   n0li
	( 
	.data({1'b0, wire_nl0l_dataout, (nli1l47 & wire_nl0i_dataout)}),
	.o(wire_n0li_o),
	.sel({(nli1O44 & nli0i), nlOO, n1i}));
	defparam
		n0li.width_data = 3,
		n0li.width_sel = 3;
	oper_selector   n0lO
	( 
	.data({1'b0, wire_nl0l_dataout, wire_nl1l_dataout, wire_nili_dataout}),
	.o(wire_n0lO_o),
	.sel({nliil, (nliii38 & n1i), n1l, n1O}));
	defparam
		n0lO.width_data = 4,
		n0lO.width_sel = 4;
	oper_selector   n0Ol
	( 
	.data({1'b0, wire_nilO_dataout, wire_nill_dataout, wire_nili_dataout}),
	.o(wire_n0Ol_o),
	.sel({(nlill32 & nliOi), (nlilO29 & n1l), n1O, n0i}));
	defparam
		n0Ol.width_data = 4,
		n0Ol.width_sel = 4;
	oper_selector   ni1i
	( 
	.data({1'b0, (nliOl26 & wire_nilO_dataout), wire_nill_dataout, wire_niii_dataout}),
	.o(wire_ni1i_o),
	.sel({nll1i, (nliOO23 & n1O), n0i, n0l}));
	defparam
		ni1i.width_data = 4,
		ni1i.width_sel = 4;
	oper_selector   ni1O
	( 
	.data({1'b0, wire_nilO_dataout, wire_niil_dataout}),
	.o(wire_ni1O_o),
	.sel({(nll1l20 & nll0i), n0i, (nll1O17 & n0l)}));
	defparam
		ni1O.width_data = 3,
		ni1O.width_sel = 3;
	assign
		alignstatus = nii,
		enabledeskew = n1OO,
		fiforesetrd = (n1OO & (~ n1Oi)),
		nl0lO = ((((((n0l | n0i) | n1O) | n1l) | n1i) | nlOO) | (~ nl0Oi53)),
		nli0i = ((((((n0l | n0i) | n1O) | n1l) | nlOl) | n1ll) | (~ nli0l41)),
		nli1i = (((((n0l | n0i) | n1O) | n1l) | n1i) | n1ll),
		nliil = (((((n0l | n0i) | nlOO) | nlOl) | n1ll) | (~ nliiO35)),
		nliOi = ((((n0l | n1i) | nlOO) | nlOl) | n1ll),
		nll0i = ((((((n1O | n1l) | n1i) | nlOO) | nlOl) | n1ll) | (~ nll0l14)),
		nll1i = ((((n1l | n1i) | nlOO) | nlOl) | n1ll),
		nllii = (((~ nli) | nlO1i) | (~ nllil11)),
		nllli = (nlO0i & (~ n1lO)),
		nllll = ((~ nli) | nlO1i),
		nlllO = ((nli & (((adet[3] & adet[2]) & adet[1]) & adet[0])) & nllOi8),
		nllOO = 1'b1,
		nlO0i = ((((rdalign[3] & rdalign[2]) & rdalign[1]) & rdalign[0]) & nlO0l2),
		nlO1i = (((~ nlO0i) & (((rdalign[3] | rdalign[2]) | rdalign[1]) | rdalign[0])) & nlO1l5);
endmodule //altgxb_xgm_dskw_sm
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 146 mux21 317 oper_add 1 oper_decoder 1 oper_less_than 1 oper_selector 39 
`timescale 1 ps / 1 ps
module  altgxb_xgm_tx_sm
	( 
	rdenablesync,
	resetall,
	txclk,
	txctrl,
	txctrlout,
	txdatain,
	txdataout) /* synthesis synthesis_clearbox=1 */;
	input   rdenablesync;
	input   resetall;
	input   txclk;
	input   [3:0]  txctrl;
	output   [3:0]  txctrlout;
	input   [31:0]  txdatain;
	output   [31:0]  txdataout;

	reg	nl000O1;
	reg	nl000O2;
	reg	nl000O3;
	reg	nl001O4;
	reg	nl001O5;
	reg	nl001O6;
	reg	nl010O13;
	reg	nl010O14;
	reg	nl010O15;
	reg	nl011l16;
	reg	nl011l17;
	reg	nl011l18;
	reg	nl01iO10;
	reg	nl01iO11;
	reg	nl01iO12;
	reg	nl01Ol7;
	reg	nl01Ol8;
	reg	nl01Ol9;
	reg	nl100l55;
	reg	nl100l56;
	reg	nl100l57;
	reg	nl10li52;
	reg	nl10li53;
	reg	nl10li54;
	reg	nl10Ol49;
	reg	nl10Ol50;
	reg	nl10Ol51;
	reg	nl11OO58;
	reg	nl11OO59;
	reg	nl11OO60;
	reg	nl1i0O43;
	reg	nl1i0O44;
	reg	nl1i0O45;
	reg	nl1i1O46;
	reg	nl1i1O47;
	reg	nl1i1O48;
	reg	nl1iil40;
	reg	nl1iil41;
	reg	nl1iil42;
	reg	nl1ilO37;
	reg	nl1ilO38;
	reg	nl1ilO39;
	reg	nl1l0i34;
	reg	nl1l0i35;
	reg	nl1l0i36;
	reg	nl1lii31;
	reg	nl1lii32;
	reg	nl1lii33;
	reg	nl1lOi28;
	reg	nl1lOi29;
	reg	nl1lOi30;
	reg	nl1O1i25;
	reg	nl1O1i26;
	reg	nl1O1i27;
	reg	nl1Oii22;
	reg	nl1Oii23;
	reg	nl1Oii24;
	reg	nl1OOi19;
	reg	nl1OOi20;
	reg	nl1OOi21;
	reg	n00i;
	reg	n00l;
	reg	n00O;
	reg	n01i;
	reg	n01l;
	reg	n01O;
	reg	n0il;
	reg	n10i;
	reg	n10l;
	reg	n10O;
	reg	n11i;
	reg	n11l;
	reg	n11O;
	reg	n1ii;
	reg	n1il;
	reg	n1iO;
	reg	n1li;
	reg	n1ll;
	reg	n1lO;
	reg	n1Oi;
	reg	n1Ol;
	reg	n1OO;
	reg	nlOll;
	reg	nlOlO;
	reg	nlOOi;
	reg	nlOOl;
	reg	nlOOO;
	reg	n011i;
	reg	n011l;
	reg	n011O;
	reg	n0OO;
	reg	ni1l;
	reg	ni1Oi;
	reg	ni1Ol;
	reg	ni1OO;
	reg	nll0l;
	reg	nll0O;
	reg	nllii;
	reg	nllil;
	reg	nlliOl;
	reg	nlliOO;
	reg	nlll1i;
	reg	nlll1l;
	reg	nlOO0i;
	reg	nlOO0l;
	reg	nlOO0O;
	reg	nlli0l;
	reg	nlli0O;
	reg	nlliii;
	reg	nlliil;
	reg	nllili;
	reg	nll00i;
	reg	nll00l;
	reg	nll00O;
	reg	nll01i;
	reg	nll01l;
	reg	nll01O;
	reg	nll0ii;
	reg	nll0il;
	reg	nll0iO;
	reg	nll0li;
	reg	nll0ll;
	reg	nll0lO;
	reg	nll0Oi;
	reg	nll0Ol;
	reg	nll0OO;
	reg	nll10i;
	reg	nll10l;
	reg	nll10O;
	reg	nll11l;
	reg	nll11O;
	reg	nll1ii;
	reg	nll1il;
	reg	nll1iO;
	reg	nll1li;
	reg	nll1ll;
	reg	nll1lO;
	reg	nll1Oi;
	reg	nll1Ol;
	reg	nll1OO;
	reg	nlli0i;
	reg	nlli1i;
	reg	nlli1l;
	reg	nlli1O;
	reg	nllill;
	reg	nlliOi;
	wire	wire_n00il_dataout;
	wire	wire_n00iO_dataout;
	wire	wire_n00li_dataout;
	wire	wire_n00ll_dataout;
	wire	wire_n00lO_dataout;
	wire	wire_n00Oi_dataout;
	wire	wire_n00Ol_dataout;
	wire	wire_n00OO_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n01ii_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01iO_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01lO_dataout;
	wire	wire_n0i0i_dataout;
	wire	wire_n0i0l_dataout;
	wire	wire_n0i0O_dataout;
	wire	wire_n0i1i_dataout;
	wire	wire_n0i1l_dataout;
	wire	wire_n0i1O_dataout;
	wire	wire_n0iii_dataout;
	wire	wire_n0iil_dataout;
	wire	wire_n0iiO_dataout;
	wire	wire_n0ili_dataout;
	wire	wire_n0ill_dataout;
	wire	wire_n0ilO_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0iOi_dataout;
	wire	wire_n0iOl_dataout;
	wire	wire_n0iOO_dataout;
	wire	wire_n0l0i_dataout;
	wire	wire_n0l0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0l1i_dataout;
	wire	wire_n0l1l_dataout;
	wire	wire_n0l1O_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0lii_dataout;
	wire	wire_n0lil_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0lli_dataout;
	wire	wire_n0lll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lOi_dataout;
	wire	wire_n0lOl_dataout;
	wire	wire_n0lOO_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O0l_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1O_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Oil_dataout;
	wire	wire_n0OiO_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0Oll_dataout;
	wire	wire_n0OlO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n0OOO_dataout;
	wire	wire_n100i_dataout;
	wire	wire_n100l_dataout;
	wire	wire_n100O_dataout;
	wire	wire_n101i_dataout;
	wire	wire_n101l_dataout;
	wire	wire_n101O_dataout;
	wire	wire_n10ii_dataout;
	wire	wire_n10il_dataout;
	wire	wire_n10iO_dataout;
	wire	wire_n10li_dataout;
	wire	wire_n10ll_dataout;
	wire	wire_n10lO_dataout;
	wire	wire_n10Oi_dataout;
	wire	wire_n10Ol_dataout;
	wire	wire_n10OO_dataout;
	wire	wire_n11ll_dataout;
	wire	wire_n11lO_dataout;
	wire	wire_n11Oi_dataout;
	wire	wire_n11Ol_dataout;
	wire	wire_n11OO_dataout;
	wire	wire_n1i0i_dataout;
	wire	wire_n1i0l_dataout;
	wire	wire_n1i0O_dataout;
	wire	wire_n1i1i_dataout;
	wire	wire_n1i1l_dataout;
	wire	wire_n1i1O_dataout;
	wire	wire_n1iii_dataout;
	wire	wire_n1iil_dataout;
	wire	wire_n1iiO_dataout;
	wire	wire_n1ili_dataout;
	wire	wire_n1ill_dataout;
	wire	wire_n1ilO_dataout;
	wire	wire_n1iOi_dataout;
	wire	wire_n1iOl_dataout;
	wire	wire_n1iOO_dataout;
	wire	wire_n1l0i_dataout;
	wire	wire_n1l0l_dataout;
	wire	wire_n1l0O_dataout;
	wire	wire_n1l1i_dataout;
	wire	wire_n1l1l_dataout;
	wire	wire_n1l1O_dataout;
	wire	wire_n1lii_dataout;
	wire	wire_n1lil_dataout;
	wire	wire_n1liO_dataout;
	wire	wire_n1lli_dataout;
	wire	wire_n1lll_dataout;
	wire	wire_n1llO_dataout;
	wire	wire_n1lOi_dataout;
	wire	wire_n1lOl_dataout;
	wire	wire_n1lOO_dataout;
	wire	wire_n1O0i_dataout;
	wire	wire_n1O0l_dataout;
	wire	wire_n1O0O_dataout;
	wire	wire_n1O1i_dataout;
	wire	wire_n1O1l_dataout;
	wire	wire_n1O1O_dataout;
	wire	wire_n1Oii_dataout;
	wire	wire_n1Oil_dataout;
	wire	wire_n1OiO_dataout;
	wire	wire_n1Oli_dataout;
	wire	wire_n1Oll_dataout;
	wire	wire_n1OlO_dataout;
	wire	wire_n1OOi_dataout;
	wire	wire_n1OOl_dataout;
	wire	wire_n1OOO_dataout;
	wire	wire_ni00i_dataout;
	wire	wire_ni00l_dataout;
	wire	wire_ni00O_dataout;
	wire	wire_ni01i_dataout;
	wire	wire_ni01l_dataout;
	wire	wire_ni01O_dataout;
	wire	wire_ni0ii_dataout;
	wire	wire_ni0il_dataout;
	wire	wire_ni0iO_dataout;
	wire	wire_ni10i_dataout;
	wire	wire_ni10l_dataout;
	wire	wire_ni10O_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni11l_dataout;
	wire	wire_ni11O_dataout;
	wire	wire_ni1ii_dataout;
	wire	wire_ni1il_dataout;
	wire	wire_ni1iO_dataout;
	wire	wire_ni1li_dataout;
	wire	wire_ni1ll_dataout;
	wire	wire_ni1lO_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil1i_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nilii_dataout;
	wire	wire_nilil_dataout;
	wire	wire_niliO_dataout;
	wire	wire_nilli_dataout;
	wire	wire_nilll_dataout;
	wire	wire_nillO_dataout;
	wire	wire_nilOi_dataout;
	wire	wire_nilOl_dataout;
	wire	wire_nilOO_dataout;
	wire	wire_niO0i_dataout;
	wire	wire_niO0l_dataout;
	wire	wire_niO0O_dataout;
	wire	wire_niO1i_dataout;
	wire	wire_niO1l_dataout;
	wire	wire_niO1O_dataout;
	wire	wire_niOii_dataout;
	wire	wire_niOil_dataout;
	wire	wire_niOiO_dataout;
	wire	wire_niOli_dataout;
	wire	wire_niOll_dataout;
	wire	wire_niOlO_dataout;
	wire	wire_niOOi_dataout;
	wire	wire_niOOl_dataout;
	wire	wire_niOOO_dataout;
	wire	wire_nl00O_dataout;
	wire	wire_nl0ii_dataout;
	wire	wire_nl0il_dataout;
	wire	wire_nl0iO_dataout;
	wire	wire_nl0li_dataout;
	wire	wire_nl0ll_dataout;
	wire	wire_nl0lO_dataout;
	wire	wire_nl0Oi_dataout;
	wire	wire_nl0Ol_dataout;
	wire	wire_nl0OO_dataout;
	wire	wire_nl10i_dataout;
	wire	wire_nl10l_dataout;
	wire	wire_nl10O_dataout;
	wire	wire_nl11i_dataout;
	wire	wire_nl11l_dataout;
	wire	wire_nl11O_dataout;
	wire	wire_nl1ii_dataout;
	wire	wire_nl1il_dataout;
	wire	wire_nl1iO_dataout;
	wire	wire_nl1li_dataout;
	wire	wire_nl1ll_dataout;
	wire	wire_nl1lO_dataout;
	wire	wire_nl1Oi_dataout;
	wire	wire_nl1Ol_dataout;
	wire	wire_nli0i_dataout;
	wire	wire_nli0l_dataout;
	wire	wire_nli0O_dataout;
	wire	wire_nli1i_dataout;
	wire	wire_nli1l_dataout;
	wire	wire_nli1O_dataout;
	wire	wire_nliii_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlll0i_dataout;
	wire	wire_nlll0l_dataout;
	wire	wire_nlll0O_dataout;
	wire	wire_nlll1O_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nlllii_dataout;
	wire	wire_nlllil_dataout;
	wire	wire_nllliO_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllli_dataout;
	wire	wire_nlllll_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOil_dataout;
	wire	wire_nllOiO_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOli_dataout;
	wire	wire_nllOll_dataout;
	wire	wire_nllOlO_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nllOOi_dataout;
	wire	wire_nllOOl_dataout;
	wire	wire_nllOOO_dataout;
	wire	wire_nlO00i_dataout;
	wire	wire_nlO01i_dataout;
	wire	wire_nlO01l_dataout;
	wire	wire_nlO01O_dataout;
	wire	wire_nlO0il_dataout;
	wire	wire_nlO0iO_dataout;
	wire	wire_nlO0li_dataout;
	wire	wire_nlO0ll_dataout;
	wire	wire_nlO0lO_dataout;
	wire	wire_nlO0Oi_dataout;
	wire	wire_nlO0Ol_dataout;
	wire	wire_nlO0OO_dataout;
	wire	wire_nlO10i_dataout;
	wire	wire_nlO10l_dataout;
	wire	wire_nlO10O_dataout;
	wire	wire_nlO11i_dataout;
	wire	wire_nlO11l_dataout;
	wire	wire_nlO11O_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1ii_dataout;
	wire	wire_nlO1il_dataout;
	wire	wire_nlO1iO_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1li_dataout;
	wire	wire_nlO1ll_dataout;
	wire	wire_nlO1lO_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlO1Oi_dataout;
	wire	wire_nlO1Ol_dataout;
	wire	wire_nlO1OO_dataout;
	wire	wire_nlOi0i_dataout;
	wire	wire_nlOi0l_dataout;
	wire	wire_nlOi0O_dataout;
	wire	wire_nlOi1i_dataout;
	wire	wire_nlOi1l_dataout;
	wire	wire_nlOi1O_dataout;
	wire	wire_nlOiii_dataout;
	wire	wire_nlOiil_dataout;
	wire	wire_nlOiiO_dataout;
	wire	wire_nlOili_dataout;
	wire	wire_nlOill_dataout;
	wire	wire_nlOilO_dataout;
	wire	wire_nlOiOi_dataout;
	wire	wire_nlOiOl_dataout;
	wire	wire_nlOiOO_dataout;
	wire	wire_nlOl0i_dataout;
	wire	wire_nlOl0l_dataout;
	wire	wire_nlOl0O_dataout;
	wire	wire_nlOl1i_dataout;
	wire	wire_nlOl1l_dataout;
	wire	wire_nlOl1O_dataout;
	wire	wire_nlOlii_dataout;
	wire	wire_nlOlil_dataout;
	wire	wire_nlOlli_dataout;
	wire	wire_nlOlll_dataout;
	wire	wire_nlOllO_dataout;
	wire	wire_nlOlOi_dataout;
	wire	wire_nlOlOl_dataout;
	wire	wire_nlOlOO_dataout;
	wire	wire_nlOO1i_dataout;
	wire	wire_nlOO1l_dataout;
	wire	wire_nlOO1O_dataout;
	wire	wire_nlOOii_dataout;
	wire	wire_nlOOil_dataout;
	wire	wire_nlOOiO_dataout;
	wire	wire_nlOOli_dataout;
	wire	wire_nlOOll_dataout;
	wire	wire_nlOOlO_dataout;
	wire	wire_nlOOOi_dataout;
	wire	wire_nlOOOl_dataout;
	wire	wire_nlOOOO_dataout;
	wire  [5:0]   wire_nlO0i_o;
	wire  [15:0]   wire_nllOii_o;
	wire  wire_nll1l_o;
	wire  wire_n000i_o;
	wire  wire_n000l_o;
	wire  wire_n000O_o;
	wire  wire_n001i_o;
	wire  wire_n001l_o;
	wire  wire_n001O_o;
	wire  wire_n01Oi_o;
	wire  wire_n01Ol_o;
	wire  wire_n01OO_o;
	wire  wire_n110i_o;
	wire  wire_n110l_o;
	wire  wire_n110O_o;
	wire  wire_n111i_o;
	wire  wire_n111l_o;
	wire  wire_n111O_o;
	wire  wire_n11ii_o;
	wire  wire_n11il_o;
	wire  wire_n11iO_o;
	wire  wire_ni0li_o;
	wire  wire_ni0ll_o;
	wire  wire_ni0lO_o;
	wire  wire_ni0Oi_o;
	wire  wire_ni0Ol_o;
	wire  wire_ni0OO_o;
	wire  wire_nii1i_o;
	wire  wire_nii1l_o;
	wire  wire_nii1O_o;
	wire  wire_nl00i_o;
	wire  wire_nl01l_o;
	wire  wire_nl1OO_o;
	wire  wire_nllllO_o;
	wire  wire_nlllOi_o;
	wire  wire_nlllOl_o;
	wire  wire_nlllOO_o;
	wire  wire_nllO0i_o;
	wire  wire_nllO0l_o;
	wire  wire_nllO1i_o;
	wire  wire_nllO1l_o;
	wire  wire_nllO1O_o;
	wire  niOOil;
	wire  niOOiO;
	wire  niOOli;
	wire  niOOll;
	wire  niOOlO;
	wire  niOOOi;
	wire  niOOOl;
	wire  niOOOO;
	wire  nl000l;
	wire  nl001i;
	wire  nl001l;
	wire  nl00il;
	wire  nl00ll;
	wire  nl010i;
	wire  nl010l;
	wire  nl011i;
	wire  nl01il;
	wire  nl01ll;
	wire  nl01lO;
	wire  nl01Oi;
	wire  nl100i;
	wire  nl101l;
	wire  nl101O;
	wire  nl10ii;
	wire  nl10il;
	wire  nl10iO;
	wire  nl10lO;
	wire  nl10Oi;
	wire  nl110i;
	wire  nl110l;
	wire  nl110O;
	wire  nl111i;
	wire  nl111l;
	wire  nl111O;
	wire  nl11ii;
	wire  nl11il;
	wire  nl11iO;
	wire  nl11li;
	wire  nl11ll;
	wire  nl11lO;
	wire  nl11Oi;
	wire  nl11Ol;
	wire  nl1i0l;
	wire  nl1i1i;
	wire  nl1i1l;
	wire  nl1ili;
	wire  nl1ill;
	wire  nl1iOl;
	wire  nl1iOO;
	wire  nl1l0O;
	wire  nl1l1i;
	wire  nl1l1l;
	wire  nl1l1O;
	wire  nl1liO;
	wire  nl1lli;
	wire  nl1lll;
	wire  nl1llO;
	wire  nl1lOO;
	wire  nl1O0i;
	wire  nl1O0l;
	wire  nl1O0O;
	wire  nl1O1O;
	wire  nl1OiO;
	wire  nl1Oli;
	wire  nl1Oll;
	wire  nl1OlO;
	wire  nl1OOO;

	initial
		nl000O1 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl000O1 <= nl000O3;
	initial
		nl000O2 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl000O2 <= (nl000O3 ^ nl000O1);
	initial
		nl000O3 = 0;
	always @ ( posedge txclk)
		  nl000O3 <= nl000O1;
	initial
		nl001O4 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl001O4 <= nl001O6;
	initial
		nl001O5 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl001O5 <= (nl001O6 ^ nl001O4);
	initial
		nl001O6 = 0;
	always @ ( posedge txclk)
		  nl001O6 <= nl001O4;
	initial
		nl010O13 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl010O13 <= nl010O15;
	initial
		nl010O14 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl010O14 <= (nl010O15 ^ nl010O13);
	initial
		nl010O15 = 0;
	always @ ( posedge txclk)
		  nl010O15 <= nl010O13;
	initial
		nl011l16 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl011l16 <= nl011l18;
	initial
		nl011l17 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl011l17 <= (nl011l18 ^ nl011l16);
	initial
		nl011l18 = 0;
	always @ ( posedge txclk)
		  nl011l18 <= nl011l16;
	initial
		nl01iO10 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl01iO10 <= nl01iO12;
	initial
		nl01iO11 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl01iO11 <= (nl01iO12 ^ nl01iO10);
	initial
		nl01iO12 = 0;
	always @ ( posedge txclk)
		  nl01iO12 <= nl01iO10;
	initial
		nl01Ol7 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl01Ol7 <= nl01Ol9;
	initial
		nl01Ol8 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl01Ol8 <= (nl01Ol9 ^ nl01Ol7);
	initial
		nl01Ol9 = 0;
	always @ ( posedge txclk)
		  nl01Ol9 <= nl01Ol7;
	initial
		nl100l55 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl100l55 <= nl100l57;
	initial
		nl100l56 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl100l56 <= (nl100l57 ^ nl100l55);
	initial
		nl100l57 = 0;
	always @ ( posedge txclk)
		  nl100l57 <= nl100l55;
	initial
		nl10li52 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl10li52 <= nl10li54;
	initial
		nl10li53 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl10li53 <= (nl10li54 ^ nl10li52);
	initial
		nl10li54 = 0;
	always @ ( posedge txclk)
		  nl10li54 <= nl10li52;
	initial
		nl10Ol49 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl10Ol49 <= nl10Ol51;
	initial
		nl10Ol50 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl10Ol50 <= (nl10Ol51 ^ nl10Ol49);
	initial
		nl10Ol51 = 0;
	always @ ( posedge txclk)
		  nl10Ol51 <= nl10Ol49;
	initial
		nl11OO58 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl11OO58 <= nl11OO60;
	initial
		nl11OO59 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl11OO59 <= (nl11OO60 ^ nl11OO58);
	initial
		nl11OO60 = 0;
	always @ ( posedge txclk)
		  nl11OO60 <= nl11OO58;
	initial
		nl1i0O43 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1i0O43 <= nl1i0O45;
	initial
		nl1i0O44 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1i0O44 <= (nl1i0O45 ^ nl1i0O43);
	initial
		nl1i0O45 = 0;
	always @ ( posedge txclk)
		  nl1i0O45 <= nl1i0O43;
	initial
		nl1i1O46 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1i1O46 <= nl1i1O48;
	initial
		nl1i1O47 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1i1O47 <= (nl1i1O48 ^ nl1i1O46);
	initial
		nl1i1O48 = 0;
	always @ ( posedge txclk)
		  nl1i1O48 <= nl1i1O46;
	initial
		nl1iil40 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1iil40 <= nl1iil42;
	initial
		nl1iil41 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1iil41 <= (nl1iil42 ^ nl1iil40);
	initial
		nl1iil42 = 0;
	always @ ( posedge txclk)
		  nl1iil42 <= nl1iil40;
	initial
		nl1ilO37 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1ilO37 <= nl1ilO39;
	initial
		nl1ilO38 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1ilO38 <= (nl1ilO39 ^ nl1ilO37);
	initial
		nl1ilO39 = 0;
	always @ ( posedge txclk)
		  nl1ilO39 <= nl1ilO37;
	initial
		nl1l0i34 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1l0i34 <= nl1l0i36;
	initial
		nl1l0i35 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1l0i35 <= (nl1l0i36 ^ nl1l0i34);
	initial
		nl1l0i36 = 0;
	always @ ( posedge txclk)
		  nl1l0i36 <= nl1l0i34;
	initial
		nl1lii31 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1lii31 <= nl1lii33;
	initial
		nl1lii32 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1lii32 <= (nl1lii33 ^ nl1lii31);
	initial
		nl1lii33 = 0;
	always @ ( posedge txclk)
		  nl1lii33 <= nl1lii31;
	initial
		nl1lOi28 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1lOi28 <= nl1lOi30;
	initial
		nl1lOi29 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1lOi29 <= (nl1lOi30 ^ nl1lOi28);
	initial
		nl1lOi30 = 0;
	always @ ( posedge txclk)
		  nl1lOi30 <= nl1lOi28;
	initial
		nl1O1i25 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1O1i25 <= nl1O1i27;
	initial
		nl1O1i26 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1O1i26 <= (nl1O1i27 ^ nl1O1i25);
	initial
		nl1O1i27 = 0;
	always @ ( posedge txclk)
		  nl1O1i27 <= nl1O1i25;
	initial
		nl1Oii22 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1Oii22 <= nl1Oii24;
	initial
		nl1Oii23 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1Oii23 <= (nl1Oii24 ^ nl1Oii22);
	initial
		nl1Oii24 = 0;
	always @ ( posedge txclk)
		  nl1Oii24 <= nl1Oii22;
	initial
		nl1OOi19 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1OOi19 <= nl1OOi21;
	initial
		nl1OOi20 = {1{1'b1}};
	always @ ( posedge txclk)
		  nl1OOi20 <= (nl1OOi21 ^ nl1OOi19);
	initial
		nl1OOi21 = 0;
	always @ ( posedge txclk)
		  nl1OOi21 <= nl1OOi19;
	initial
	begin
		n00i = 0;
		n00l = 0;
		n00O = 0;
		n01i = 0;
		n01l = 0;
		n01O = 0;
		n0il = 0;
		n10i = 0;
		n10l = 0;
		n10O = 0;
		n11i = 0;
		n11l = 0;
		n11O = 0;
		n1ii = 0;
		n1il = 0;
		n1iO = 0;
		n1li = 0;
		n1ll = 0;
		n1lO = 0;
		n1Oi = 0;
		n1Ol = 0;
		n1OO = 0;
		nlOll = 0;
		nlOlO = 0;
		nlOOi = 0;
		nlOOl = 0;
		nlOOO = 0;
	end
	always @ ( posedge txclk or posedge resetall)
	begin
		if (resetall == 1'b1) 
		begin
			n00i <= 0;
			n00l <= 0;
			n00O <= 0;
			n01i <= 0;
			n01l <= 0;
			n01O <= 0;
			n0il <= 0;
			n10i <= 0;
			n10l <= 0;
			n10O <= 0;
			n11i <= 0;
			n11l <= 0;
			n11O <= 0;
			n1ii <= 0;
			n1il <= 0;
			n1iO <= 0;
			n1li <= 0;
			n1ll <= 0;
			n1lO <= 0;
			n1Oi <= 0;
			n1Ol <= 0;
			n1OO <= 0;
			nlOll <= 0;
			nlOlO <= 0;
			nlOOi <= 0;
			nlOOl <= 0;
			nlOOO <= 0;
		end
		else if  (nl11li == 1'b1) 
		begin
			n00i <= txdatain[28];
			n00l <= txdatain[29];
			n00O <= txdatain[30];
			n01i <= txdatain[24];
			n01l <= txdatain[26];
			n01O <= txdatain[27];
			n0il <= txdatain[31];
			n10i <= txdatain[12];
			n10l <= txdatain[13];
			n10O <= txdatain[14];
			n11i <= txdatain[9];
			n11l <= txdatain[10];
			n11O <= txdatain[11];
			n1ii <= txdatain[15];
			n1il <= txdatain[16];
			n1iO <= txdatain[17];
			n1li <= txdatain[18];
			n1ll <= txdatain[19];
			n1lO <= txdatain[20];
			n1Oi <= txdatain[21];
			n1Ol <= txdatain[22];
			n1OO <= txdatain[23];
			nlOll <= txdatain[0];
			nlOlO <= txdatain[1];
			nlOOi <= txdatain[5];
			nlOOl <= txdatain[6];
			nlOOO <= txdatain[8];
		end
	end
	initial
	begin
		n011i = 0;
		n011l = 0;
		n011O = 0;
		n0OO = 0;
		ni1l = 0;
		ni1Oi = 0;
		ni1Ol = 0;
		ni1OO = 0;
		nll0l = 0;
		nll0O = 0;
		nllii = 0;
		nllil = 0;
		nlliOl = 0;
		nlliOO = 0;
		nlll1i = 0;
		nlll1l = 0;
		nlOO0i = 0;
		nlOO0l = 0;
		nlOO0O = 0;
	end
	always @ ( posedge txclk or posedge resetall)
	begin
		if (resetall == 1'b1) 
		begin
			n011i <= 0;
			n011l <= 0;
			n011O <= 0;
			n0OO <= 0;
			ni1l <= 0;
			ni1Oi <= 0;
			ni1Ol <= 0;
			ni1OO <= 0;
			nll0l <= 0;
			nll0O <= 0;
			nllii <= 0;
			nllil <= 0;
			nlliOl <= 0;
			nlliOO <= 0;
			nlll1i <= 0;
			nlll1l <= 0;
			nlOO0i <= 0;
			nlOO0l <= 0;
			nlOO0O <= 0;
		end
		else 
		begin
			n011i <= wire_n010l_dataout;
			n011l <= wire_n010O_dataout;
			n011O <= wire_n01ll_dataout;
			n0OO <= wire_n0iO_dataout;
			ni1l <= wire_nl00i_o;
			ni1Oi <= wire_ni01l_dataout;
			ni1Ol <= wire_ni01O_dataout;
			ni1OO <= wire_ni0il_dataout;
			nll0l <= wire_nlliO_dataout;
			nll0O <= wire_nllli_dataout;
			nllii <= wire_nllll_dataout;
			nllil <= wire_nlllO_dataout;
			nlliOl <= wire_nl00O_dataout;
			nlliOO <= wire_nlll0i_dataout;
			nlll1i <= wire_nlll0l_dataout;
			nlll1l <= wire_nlllli_dataout;
			nlOO0i <= wire_nlOOil_dataout;
			nlOO0l <= wire_nlOOiO_dataout;
			nlOO0O <= wire_nlOOOl_dataout;
		end
	end
	initial
	begin
		nlli0l = 0;
		nlli0O = 0;
		nlliii = 0;
		nlliil = 0;
		nllili = 0;
	end
	always @ ( posedge txclk or posedge resetall)
	begin
		if (resetall == 1'b1) 
		begin
			nlli0l <= 1;
			nlli0O <= 1;
			nlliii <= 1;
			nlliil <= 1;
			nllili <= 1;
		end
		else if  (nl11li == 1'b1) 
		begin
			nlli0l <= txdatain[2];
			nlli0O <= txdatain[3];
			nlliii <= txdatain[4];
			nlliil <= txdatain[7];
			nllili <= txdatain[25];
		end
	end
	initial
	begin
		nll00i = 0;
		nll00l = 0;
		nll00O = 0;
		nll01i = 0;
		nll01l = 0;
		nll01O = 0;
		nll0ii = 0;
		nll0il = 0;
		nll0iO = 0;
		nll0li = 0;
		nll0ll = 0;
		nll0lO = 0;
		nll0Oi = 0;
		nll0Ol = 0;
		nll0OO = 0;
		nll10i = 0;
		nll10l = 0;
		nll10O = 0;
		nll11l = 0;
		nll11O = 0;
		nll1ii = 0;
		nll1il = 0;
		nll1iO = 0;
		nll1li = 0;
		nll1ll = 0;
		nll1lO = 0;
		nll1Oi = 0;
		nll1Ol = 0;
		nll1OO = 0;
		nlli0i = 0;
		nlli1i = 0;
		nlli1l = 0;
		nlli1O = 0;
		nllill = 0;
		nlliOi = 0;
	end
	always @ ( posedge txclk or posedge resetall)
	begin
		if (resetall == 1'b1) 
		begin
			nll00i <= 1;
			nll00l <= 1;
			nll00O <= 1;
			nll01i <= 1;
			nll01l <= 1;
			nll01O <= 1;
			nll0ii <= 1;
			nll0il <= 1;
			nll0iO <= 1;
			nll0li <= 1;
			nll0ll <= 1;
			nll0lO <= 1;
			nll0Oi <= 1;
			nll0Ol <= 1;
			nll0OO <= 1;
			nll10i <= 1;
			nll10l <= 1;
			nll10O <= 1;
			nll11l <= 1;
			nll11O <= 1;
			nll1ii <= 1;
			nll1il <= 1;
			nll1iO <= 1;
			nll1li <= 1;
			nll1ll <= 1;
			nll1lO <= 1;
			nll1Oi <= 1;
			nll1Ol <= 1;
			nll1OO <= 1;
			nlli0i <= 1;
			nlli1i <= 1;
			nlli1l <= 1;
			nlli1O <= 1;
			nllill <= 1;
			nlliOi <= 1;
		end
		else 
		begin
			nll00i <= wire_n01lO_dataout;
			nll00l <= wire_ni01i_dataout;
			nll00O <= wire_ni00i_dataout;
			nll01i <= wire_n01il_dataout;
			nll01l <= wire_n01iO_dataout;
			nll01O <= wire_n01li_dataout;
			nll0ii <= wire_ni00l_dataout;
			nll0il <= wire_ni00O_dataout;
			nll0iO <= wire_ni0ii_dataout;
			nll0li <= wire_ni0iO_dataout;
			nll0ll <= wire_nli0O_dataout;
			nll0lO <= wire_nllOi_dataout;
			nll0Oi <= (nlli0i ^ nlli1O);
			nll0Ol <= nll0Oi;
			nll0OO <= nll0Ol;
			nll10i <= wire_nlllii_dataout;
			nll10l <= wire_nlllil_dataout;
			nll10O <= wire_nllliO_dataout;
			nll11l <= wire_nlll1O_dataout;
			nll11O <= wire_nlll0O_dataout;
			nll1ii <= wire_nlllll_dataout;
			nll1il <= wire_nlOOii_dataout;
			nll1iO <= wire_nlOOli_dataout;
			nll1li <= wire_nlOOll_dataout;
			nll1ll <= wire_nlOOlO_dataout;
			nll1lO <= wire_nlOOOi_dataout;
			nll1Oi <= wire_nlOOOO_dataout;
			nll1Ol <= wire_n010i_dataout;
			nll1OO <= wire_n01ii_dataout;
			nlli0i <= nlli1O;
			nlli1i <= nll0OO;
			nlli1l <= nlli1i;
			nlli1O <= nlli1l;
			nllill <= wire_nl1OO_o;
			nlliOi <= wire_nl01l_o;
		end
	end
	or(wire_n00il_dataout, wire_n0i1l_dataout, ~{nl111i});
	and(wire_n00iO_dataout, wire_n0i1O_dataout, nl111i);
	and(wire_n00li_dataout, wire_n0i0i_dataout, nl111i);
	or(wire_n00ll_dataout, wire_n0i0l_dataout, ~{nl111i});
	or(wire_n00lO_dataout, wire_n0i0O_dataout, ~{nl111i});
	or(wire_n00Oi_dataout, wire_n0iii_dataout, ~{nl111i});
	assign		wire_n00Ol_dataout = (nl111i === 1'b1) ? wire_n0iil_dataout : (~ nll0Oi);
	and(wire_n00OO_dataout, wire_n0iiO_dataout, nl111i);
	or(wire_n010i_dataout, wire_n01Oi_o, nl1O0i);
	and(wire_n010l_dataout, wire_n01Ol_o, ~{nl1O0i});
	or(wire_n010O_dataout, wire_n01OO_o, nl1O0i);
	or(wire_n01ii_dataout, wire_n001i_o, nl1O0i);
	or(wire_n01il_dataout, wire_n001l_o, nl1O0i);
	or(wire_n01iO_dataout, wire_n001O_o, nl1O0i);
	or(wire_n01li_dataout, wire_n000i_o, nl1O0i);
	or(wire_n01ll_dataout, wire_n000l_o, nl1O0i);
	or(wire_n01lO_dataout, wire_n000O_o, nl1O0i);
	and(wire_n0i0i_dataout, wire_n0iOi_dataout, ~{nl101O});
	or(wire_n0i0l_dataout, wire_n0iOl_dataout, nl101O);
	or(wire_n0i0O_dataout, wire_n0iOO_dataout, nl101O);
	assign		wire_n0i1i_dataout = (nl111i === 1'b1) ? wire_n0ili_dataout : (~ nll0Oi);
	or(wire_n0i1l_dataout, wire_n0ill_dataout, nl101O);
	and(wire_n0i1O_dataout, wire_n0ilO_dataout, ~{nl101O});
	or(wire_n0iii_dataout, wire_n0l1i_dataout, nl101O);
	or(wire_n0iil_dataout, wire_n0l1l_dataout, nl101O);
	and(wire_n0iiO_dataout, wire_n0l1O_dataout, ~{nl101O});
	or(wire_n0ili_dataout, wire_n0l0i_dataout, nl101O);
	or(wire_n0ill_dataout, txctrl[1], nl11Ol);
	or(wire_n0ilO_dataout, txdatain[8], nl11Ol);
	or(wire_n0iO_dataout, wire_n0li_dataout, nl11li);
	and(wire_n0iOi_dataout, txdatain[9], ~{nl11Ol});
	or(wire_n0iOl_dataout, txdatain[10], nl11Ol);
	or(wire_n0iOO_dataout, txdatain[11], nl11Ol);
	or(wire_n0l0i_dataout, txdatain[15], nl11Ol);
	assign		wire_n0l0l_dataout = (nl111i === 1'b1) ? wire_n0i1l_dataout : (~ n0OO);
	assign		wire_n0l0O_dataout = (nl111i === 1'b1) ? wire_n0i1O_dataout : wire_n0lOl_dataout;
	or(wire_n0l1i_dataout, txdatain[12], nl11Ol);
	or(wire_n0l1l_dataout, txdatain[13], nl11Ol);
	or(wire_n0l1O_dataout, txdatain[14], nl11Ol);
	and(wire_n0li_dataout, n0OO, ~{(n0OO & ((((((~ nlliOl) & (~ ni1l)) & nlliOi) & (~ nllill)) | ((((~ nlliOl) & ni1l) & nlliOi) & nllill)) & nl11il))});
	assign		wire_n0lii_dataout = (nl111i === 1'b1) ? wire_n0i0i_dataout : wire_n0lOO_dataout;
	assign		wire_n0lil_dataout = (nl111i === 1'b1) ? wire_n0i0l_dataout : wire_n0O1i_dataout;
	assign		wire_n0liO_dataout = (nl111i === 1'b1) ? wire_n0i0O_dataout : wire_n0O1l_dataout;
	assign		wire_n0lli_dataout = (nl111i === 1'b1) ? wire_n0iii_dataout : wire_n0O1O_dataout;
	assign		wire_n0lll_dataout = (nl111i === 1'b1) ? wire_n0iil_dataout : wire_n0O0i_dataout;
	assign		wire_n0llO_dataout = (nl111i === 1'b1) ? wire_n0iiO_dataout : wire_n0O0l_dataout;
	assign		wire_n0lOi_dataout = (nl111i === 1'b1) ? wire_n0ili_dataout : wire_n0O0O_dataout;
	and(wire_n0lOl_dataout, nlOOO, n0OO);
	and(wire_n0lOO_dataout, n11i, n0OO);
	assign		wire_n0O0i_dataout = (n0OO === 1'b1) ? n10l : (~ nll0Oi);
	and(wire_n0O0l_dataout, n10O, n0OO);
	assign		wire_n0O0O_dataout = (n0OO === 1'b1) ? n1ii : (~ nll0Oi);
	or(wire_n0O1i_dataout, n11l, ~{n0OO});
	or(wire_n0O1l_dataout, n11O, ~{n0OO});
	or(wire_n0O1O_dataout, n10i, ~{n0OO});
	assign		wire_n0Oii_dataout = (nl111i === 1'b1) ? wire_n0iil_dataout : wire_nlOiOi_dataout;
	assign		wire_n0Oil_dataout = (nl111i === 1'b1) ? wire_n0iiO_dataout : (~ nl11ii);
	assign		wire_n0OiO_dataout = (nl111i === 1'b1) ? wire_n0ili_dataout : wire_nlOiOl_dataout;
	and(wire_n0Oli_dataout, wire_n0iil_dataout, nl111i);
	and(wire_n0Oll_dataout, wire_n0ili_dataout, nl111i);
	assign		wire_n0OlO_dataout = (nl111i === 1'b1) ? wire_n0iil_dataout : wire_n0OOl_dataout;
	assign		wire_n0OOi_dataout = (nl111i === 1'b1) ? wire_n0ili_dataout : wire_n0OOO_dataout;
	and(wire_n0OOl_dataout, n10l, n0OO);
	and(wire_n0OOO_dataout, n1ii, n0OO);
	assign		wire_n100i_dataout = (nl111i === 1'b1) ? wire_n10Oi_dataout : (~ nll0Oi);
	or(wire_n100l_dataout, wire_n10Ol_dataout, niOOll);
	and(wire_n100O_dataout, wire_n10OO_dataout, ~{niOOll});
	or(wire_n101i_dataout, wire_n10li_dataout, ~{nl111i});
	assign		wire_n101l_dataout = (nl111i === 1'b1) ? wire_n10ll_dataout : (~ nll0Oi);
	and(wire_n101O_dataout, wire_n10lO_dataout, nl111i);
	and(wire_n10ii_dataout, wire_n1i1i_dataout, ~{niOOll});
	or(wire_n10il_dataout, wire_n1i1l_dataout, niOOll);
	or(wire_n10iO_dataout, wire_n1i1O_dataout, niOOll);
	or(wire_n10li_dataout, wire_n1i0i_dataout, niOOll);
	or(wire_n10ll_dataout, wire_n1i0l_dataout, niOOll);
	and(wire_n10lO_dataout, wire_n1i0O_dataout, ~{niOOll});
	or(wire_n10Oi_dataout, wire_n1iii_dataout, niOOll);
	or(wire_n10Ol_dataout, txctrl[2], nl11lO);
	or(wire_n10OO_dataout, txdatain[16], nl11lO);
	or(wire_n11ll_dataout, wire_n100l_dataout, ~{nl111i});
	and(wire_n11lO_dataout, wire_n100O_dataout, nl111i);
	and(wire_n11Oi_dataout, wire_n10ii_dataout, nl111i);
	or(wire_n11Ol_dataout, wire_n10il_dataout, ~{nl111i});
	or(wire_n11OO_dataout, wire_n10iO_dataout, ~{nl111i});
	or(wire_n1i0i_dataout, txdatain[20], nl11lO);
	or(wire_n1i0l_dataout, txdatain[21], nl11lO);
	or(wire_n1i0O_dataout, txdatain[22], nl11lO);
	and(wire_n1i1i_dataout, txdatain[17], ~{nl11lO});
	or(wire_n1i1l_dataout, txdatain[18], nl11lO);
	or(wire_n1i1O_dataout, txdatain[19], nl11lO);
	or(wire_n1iii_dataout, txdatain[23], nl11lO);
	assign		wire_n1iil_dataout = (nl111i === 1'b1) ? wire_n100l_dataout : (~ n0OO);
	assign		wire_n1iiO_dataout = (nl111i === 1'b1) ? wire_n100O_dataout : wire_n1l1l_dataout;
	assign		wire_n1ili_dataout = (nl111i === 1'b1) ? wire_n10ii_dataout : wire_n1l1O_dataout;
	assign		wire_n1ill_dataout = (nl111i === 1'b1) ? wire_n10il_dataout : wire_n1l0i_dataout;
	assign		wire_n1ilO_dataout = (nl111i === 1'b1) ? wire_n10iO_dataout : wire_n1l0l_dataout;
	assign		wire_n1iOi_dataout = (nl111i === 1'b1) ? wire_n10li_dataout : wire_n1l0O_dataout;
	assign		wire_n1iOl_dataout = (nl111i === 1'b1) ? wire_n10ll_dataout : wire_n1lii_dataout;
	assign		wire_n1iOO_dataout = (nl111i === 1'b1) ? wire_n10lO_dataout : wire_n1lil_dataout;
	or(wire_n1l0i_dataout, n1li, ~{n0OO});
	or(wire_n1l0l_dataout, n1ll, ~{n0OO});
	or(wire_n1l0O_dataout, n1lO, ~{n0OO});
	assign		wire_n1l1i_dataout = (nl111i === 1'b1) ? wire_n10Oi_dataout : wire_n1liO_dataout;
	and(wire_n1l1l_dataout, n1il, n0OO);
	and(wire_n1l1O_dataout, n1iO, n0OO);
	assign		wire_n1lii_dataout = (n0OO === 1'b1) ? n1Oi : (~ nll0Oi);
	and(wire_n1lil_dataout, n1Ol, n0OO);
	assign		wire_n1liO_dataout = (n0OO === 1'b1) ? n1OO : (~ nll0Oi);
	assign		wire_n1lli_dataout = (nl111i === 1'b1) ? wire_n10ll_dataout : wire_nlOiOi_dataout;
	assign		wire_n1lll_dataout = (nl111i === 1'b1) ? wire_n10lO_dataout : (~ nl11ii);
	assign		wire_n1llO_dataout = (nl111i === 1'b1) ? wire_n10Oi_dataout : wire_nlOiOl_dataout;
	and(wire_n1lOi_dataout, wire_n10ll_dataout, nl111i);
	and(wire_n1lOl_dataout, wire_n10Oi_dataout, nl111i);
	assign		wire_n1lOO_dataout = (nl111i === 1'b1) ? wire_n10ll_dataout : wire_n1O1l_dataout;
	or(wire_n1O0i_dataout, wire_n10ll_dataout, ~{nl111i});
	assign		wire_n1O0l_dataout = (nl111i === 1'b1) ? wire_n10lO_dataout : nl111O;
	assign		wire_n1O0O_dataout = (nl111i === 1'b1) ? wire_n10Oi_dataout : (~ nl111O);
	assign		wire_n1O1i_dataout = (nl111i === 1'b1) ? wire_n10Oi_dataout : wire_n1O1O_dataout;
	and(wire_n1O1l_dataout, n1Oi, n0OO);
	and(wire_n1O1O_dataout, n1OO, n0OO);
	or(wire_n1Oii_dataout, wire_n11ll_dataout, ~{rdenablesync});
	and(wire_n1Oil_dataout, wire_n11lO_dataout, rdenablesync);
	and(wire_n1OiO_dataout, wire_n11Oi_dataout, rdenablesync);
	or(wire_n1Oli_dataout, wire_n11Ol_dataout, ~{rdenablesync});
	or(wire_n1Oll_dataout, wire_n11OO_dataout, ~{rdenablesync});
	or(wire_n1OlO_dataout, wire_n101i_dataout, ~{rdenablesync});
	or(wire_n1OOi_dataout, wire_n1lOi_dataout, ~{rdenablesync});
	and(wire_n1OOl_dataout, wire_n101O_dataout, rdenablesync);
	or(wire_n1OOO_dataout, wire_n1lOl_dataout, ~{rdenablesync});
	or(wire_ni00i_dataout, wire_ni0Oi_o, nl010l);
	or(wire_ni00l_dataout, wire_ni0Ol_o, nl010l);
	or(wire_ni00O_dataout, wire_ni0OO_o, nl010l);
	or(wire_ni01i_dataout, wire_ni0li_o, nl010l);
	and(wire_ni01l_dataout, wire_ni0ll_o, ~{nl010l});
	or(wire_ni01O_dataout, wire_ni0lO_o, nl010l);
	or(wire_ni0ii_dataout, wire_nii1i_o, nl010l);
	or(wire_ni0il_dataout, wire_nii1l_o, nl010l);
	or(wire_ni0iO_dataout, wire_nii1O_o, nl010l);
	or(wire_ni10i_dataout, wire_n00il_dataout, ~{rdenablesync});
	and(wire_ni10l_dataout, wire_n00iO_dataout, rdenablesync);
	and(wire_ni10O_dataout, wire_n00li_dataout, rdenablesync);
	or(wire_ni11i_dataout, wire_n0iil_dataout, ~{nl111i});
	assign		wire_ni11l_dataout = (nl111i === 1'b1) ? wire_n0iiO_dataout : nl111O;
	assign		wire_ni11O_dataout = (nl111i === 1'b1) ? wire_n0ili_dataout : (~ nl111O);
	or(wire_ni1ii_dataout, wire_n00ll_dataout, ~{rdenablesync});
	or(wire_ni1il_dataout, wire_n00lO_dataout, ~{rdenablesync});
	or(wire_ni1iO_dataout, wire_n00Oi_dataout, ~{rdenablesync});
	or(wire_ni1li_dataout, wire_n0Oli_dataout, ~{rdenablesync});
	and(wire_ni1ll_dataout, wire_n00OO_dataout, rdenablesync);
	or(wire_ni1lO_dataout, wire_n0Oll_dataout, ~{rdenablesync});
	or(wire_nii0l_dataout, wire_niiOl_dataout, ~{nl111i});
	and(wire_nii0O_dataout, wire_niiOO_dataout, nl111i);
	and(wire_niiii_dataout, wire_nil1i_dataout, nl111i);
	or(wire_niiil_dataout, wire_nil1l_dataout, ~{nl111i});
	or(wire_niiiO_dataout, wire_nil1O_dataout, ~{nl111i});
	or(wire_niili_dataout, wire_nil0i_dataout, ~{nl111i});
	assign		wire_niill_dataout = (nl111i === 1'b1) ? wire_nil0l_dataout : (~ nll0Oi);
	and(wire_niilO_dataout, wire_nil0O_dataout, nl111i);
	assign		wire_niiOi_dataout = (nl111i === 1'b1) ? wire_nilii_dataout : (~ nll0Oi);
	or(wire_niiOl_dataout, txctrl[0], nl101O);
	or(wire_niiOO_dataout, txdatain[0], nl101O);
	or(wire_nil0i_dataout, txdatain[4], nl101O);
	or(wire_nil0l_dataout, txdatain[5], nl101O);
	or(wire_nil0O_dataout, txdatain[6], nl101O);
	and(wire_nil1i_dataout, txdatain[1], ~{nl101O});
	or(wire_nil1l_dataout, txdatain[2], nl101O);
	or(wire_nil1O_dataout, txdatain[3], nl101O);
	or(wire_nilii_dataout, txdatain[7], nl101O);
	assign		wire_nilil_dataout = (nl111i === 1'b1) ? wire_niiOO_dataout : wire_niO1i_dataout;
	assign		wire_niliO_dataout = (nl111i === 1'b1) ? wire_nil1i_dataout : wire_niO1l_dataout;
	assign		wire_nilli_dataout = (nl111i === 1'b1) ? wire_nil1l_dataout : wire_niO1O_dataout;
	assign		wire_nilll_dataout = (nl111i === 1'b1) ? wire_nil1O_dataout : wire_niO0i_dataout;
	assign		wire_nillO_dataout = (nl111i === 1'b1) ? wire_nil0i_dataout : wire_niO0l_dataout;
	assign		wire_nilOi_dataout = (nl111i === 1'b1) ? wire_nil0l_dataout : wire_niO0O_dataout;
	assign		wire_nilOl_dataout = (nl111i === 1'b1) ? wire_nil0O_dataout : wire_niOii_dataout;
	assign		wire_nilOO_dataout = (nl111i === 1'b1) ? wire_nilii_dataout : wire_niOil_dataout;
	or(wire_niO0i_dataout, nlli0O, ~{n0OO});
	or(wire_niO0l_dataout, nlliii, ~{n0OO});
	assign		wire_niO0O_dataout = (n0OO === 1'b1) ? nlOOi : (~ nll0Oi);
	and(wire_niO1i_dataout, nlOll, n0OO);
	and(wire_niO1l_dataout, nlOlO, n0OO);
	or(wire_niO1O_dataout, nlli0l, ~{n0OO});
	and(wire_niOii_dataout, nlOOl, n0OO);
	assign		wire_niOil_dataout = (n0OO === 1'b1) ? nlliil : (~ nll0Oi);
	assign		wire_niOiO_dataout = (nl111i === 1'b1) ? wire_nil0l_dataout : wire_nlOiOi_dataout;
	assign		wire_niOli_dataout = (nl111i === 1'b1) ? wire_nil0O_dataout : (~ nl11ii);
	assign		wire_niOll_dataout = (nl111i === 1'b1) ? wire_nilii_dataout : wire_nlOiOl_dataout;
	and(wire_niOlO_dataout, wire_nil0l_dataout, nl111i);
	and(wire_niOOi_dataout, wire_nilii_dataout, nl111i);
	assign		wire_niOOl_dataout = (nl111i === 1'b1) ? wire_nil0l_dataout : wire_nl11i_dataout;
	assign		wire_niOOO_dataout = (nl111i === 1'b1) ? wire_nilii_dataout : wire_nl11l_dataout;
	and(wire_nl00O_dataout, wire_nl0lO_dataout, wire_nllOii_o[7]);
	or(wire_nl0ii_dataout, nll0Oi, nl111i);
	and(wire_nl0il_dataout, (~ nll0Oi), ~{nl111i});
	or(wire_nl0iO_dataout, wire_nl0Oi_dataout, nl111i);
	and(wire_nl0li_dataout, wire_nl0Ol_dataout, ~{nl111i});
	and(wire_nl0ll_dataout, (~ n0OO), ~{nl111i});
	and(wire_nl0lO_dataout, n0OO, ~{nl111i});
	and(wire_nl0Oi_dataout, nll0Oi, ~{n0OO});
	and(wire_nl0Ol_dataout, (~ nll0Oi), ~{n0OO});
	or(wire_nl0OO_dataout, wire_nli1l_dataout, nl111i);
	assign		wire_nl10i_dataout = (nl111i === 1'b1) ? wire_nil0O_dataout : nl111O;
	assign		wire_nl10l_dataout = (nl111i === 1'b1) ? wire_nilii_dataout : (~ nl111O);
	or(wire_nl10O_dataout, wire_nii0l_dataout, ~{rdenablesync});
	and(wire_nl11i_dataout, nlOOi, n0OO);
	and(wire_nl11l_dataout, nlliil, n0OO);
	or(wire_nl11O_dataout, wire_nil0l_dataout, ~{nl111i});
	and(wire_nl1ii_dataout, wire_nii0O_dataout, rdenablesync);
	and(wire_nl1il_dataout, wire_niiii_dataout, rdenablesync);
	or(wire_nl1iO_dataout, wire_niiil_dataout, ~{rdenablesync});
	or(wire_nl1li_dataout, wire_niiiO_dataout, ~{rdenablesync});
	or(wire_nl1ll_dataout, wire_niili_dataout, ~{rdenablesync});
	or(wire_nl1lO_dataout, wire_niOlO_dataout, ~{rdenablesync});
	and(wire_nl1Oi_dataout, wire_niilO_dataout, rdenablesync);
	or(wire_nl1Ol_dataout, wire_niOOi_dataout, ~{rdenablesync});
	or(wire_nli0i_dataout, (~ nl111O), nl111i);
	and(wire_nli0l_dataout, (~ nl111i), rdenablesync);
	or(wire_nli0O_dataout, wire_nliii_dataout, (((((~ rdenablesync) & nl111l) | wire_nll1l_o) | (nl11il & (rdenablesync & nl111l))) | (nl110i & (nl11ii | (~ nll0ll)))));
	and(wire_nli1i_dataout, wire_nlOiOi_dataout, ~{nl111i});
	or(wire_nli1l_dataout, nll0Oi, (~ nl11ii));
	or(wire_nli1O_dataout, (~ n0OO), nl111i);
	and(wire_nliii_dataout, nll0ll, ~{(nl111O & nl110i)});
	assign		wire_nlliO_dataout = (nl110l === 1'b1) ? nll0Oi : wire_nllOl_dataout;
	and(wire_nlll0i_dataout, wire_nlllOi_o, ~{nl10iO});
	or(wire_nlll0l_dataout, wire_nlllOl_o, nl10iO);
	or(wire_nlll0O_dataout, wire_nlllOO_o, nl10iO);
	or(wire_nlll1O_dataout, wire_nllllO_o, nl10iO);
	assign		wire_nllli_dataout = (nl110l === 1'b1) ? nll0Ol : wire_nllOO_dataout;
	or(wire_nlllii_dataout, wire_nllO1i_o, nl10iO);
	or(wire_nlllil_dataout, wire_nllO1l_o, nl10iO);
	or(wire_nllliO_dataout, wire_nllO1O_o, nl10iO);
	assign		wire_nllll_dataout = (nl110l === 1'b1) ? nll0OO : wire_nlO1i_dataout;
	or(wire_nlllli_dataout, wire_nllO0i_o, nl10iO);
	or(wire_nlllll_dataout, wire_nllO0l_o, nl10iO);
	assign		wire_nlllO_dataout = (nl110l === 1'b1) ? nlli1i : wire_nlO1l_dataout;
	or(wire_nllOi_dataout, wire_nlO1O_dataout, nl110l);
	or(wire_nllOil_dataout, wire_nlO11l_dataout, ~{nl111i});
	and(wire_nllOiO_dataout, wire_nlO11O_dataout, nl111i);
	assign		wire_nllOl_dataout = (nl11ii === 1'b1) ? wire_nlO0i_o[1] : nll0l;
	and(wire_nllOli_dataout, wire_nlO10i_dataout, nl111i);
	or(wire_nllOll_dataout, wire_nlO10l_dataout, ~{nl111i});
	or(wire_nllOlO_dataout, wire_nlO10O_dataout, ~{nl111i});
	assign		wire_nllOO_dataout = (nl11ii === 1'b1) ? wire_nlO0i_o[2] : nll0O;
	or(wire_nllOOi_dataout, wire_nlO1ii_dataout, ~{nl111i});
	assign		wire_nllOOl_dataout = (nl111i === 1'b1) ? wire_nlO1il_dataout : (~ nll0Oi);
	and(wire_nllOOO_dataout, wire_nlO1iO_dataout, nl111i);
	or(wire_nlO00i_dataout, txdatain[31], nl11ll);
	or(wire_nlO01i_dataout, txdatain[28], nl11ll);
	or(wire_nlO01l_dataout, txdatain[29], nl11ll);
	or(wire_nlO01O_dataout, txdatain[30], nl11ll);
	assign		wire_nlO0il_dataout = (nl111i === 1'b1) ? wire_nlO11l_dataout : (~ n0OO);
	assign		wire_nlO0iO_dataout = (nl111i === 1'b1) ? wire_nlO11O_dataout : wire_nlOi1l_dataout;
	assign		wire_nlO0li_dataout = (nl111i === 1'b1) ? wire_nlO10i_dataout : wire_nlOi1O_dataout;
	assign		wire_nlO0ll_dataout = (nl111i === 1'b1) ? wire_nlO10l_dataout : wire_nlOi0i_dataout;
	assign		wire_nlO0lO_dataout = (nl111i === 1'b1) ? wire_nlO10O_dataout : wire_nlOi0l_dataout;
	assign		wire_nlO0Oi_dataout = (nl111i === 1'b1) ? wire_nlO1ii_dataout : wire_nlOi0O_dataout;
	assign		wire_nlO0Ol_dataout = (nl111i === 1'b1) ? wire_nlO1il_dataout : wire_nlOiii_dataout;
	assign		wire_nlO0OO_dataout = (nl111i === 1'b1) ? wire_nlO1iO_dataout : wire_nlOiil_dataout;
	and(wire_nlO10i_dataout, wire_nlO1Oi_dataout, ~{niOOiO});
	or(wire_nlO10l_dataout, wire_nlO1Ol_dataout, niOOiO);
	or(wire_nlO10O_dataout, wire_nlO1OO_dataout, niOOiO);
	assign		wire_nlO11i_dataout = (nl111i === 1'b1) ? wire_nlO1li_dataout : (~ nll0Oi);
	or(wire_nlO11l_dataout, wire_nlO1ll_dataout, niOOiO);
	and(wire_nlO11O_dataout, wire_nlO1lO_dataout, ~{niOOiO});
	assign		wire_nlO1i_dataout = (nl11ii === 1'b1) ? wire_nlO0i_o[3] : nllii;
	or(wire_nlO1ii_dataout, wire_nlO01i_dataout, niOOiO);
	or(wire_nlO1il_dataout, wire_nlO01l_dataout, niOOiO);
	and(wire_nlO1iO_dataout, wire_nlO01O_dataout, ~{niOOiO});
	assign		wire_nlO1l_dataout = (nl11ii === 1'b1) ? wire_nlO0i_o[4] : nllil;
	or(wire_nlO1li_dataout, wire_nlO00i_dataout, niOOiO);
	or(wire_nlO1ll_dataout, txctrl[3], nl11ll);
	or(wire_nlO1lO_dataout, txdatain[24], nl11ll);
	assign		wire_nlO1O_dataout = (nl11ii === 1'b1) ? wire_nlO0i_o[5] : nll0lO;
	and(wire_nlO1Oi_dataout, txdatain[25], ~{nl11ll});
	or(wire_nlO1Ol_dataout, txdatain[26], nl11ll);
	or(wire_nlO1OO_dataout, txdatain[27], nl11ll);
	or(wire_nlOi0i_dataout, n01l, ~{n0OO});
	or(wire_nlOi0l_dataout, n01O, ~{n0OO});
	or(wire_nlOi0O_dataout, n00i, ~{n0OO});
	assign		wire_nlOi1i_dataout = (nl111i === 1'b1) ? wire_nlO1li_dataout : wire_nlOiiO_dataout;
	and(wire_nlOi1l_dataout, n01i, n0OO);
	and(wire_nlOi1O_dataout, nllili, n0OO);
	assign		wire_nlOiii_dataout = (n0OO === 1'b1) ? n00l : (~ nll0Oi);
	and(wire_nlOiil_dataout, n00O, n0OO);
	assign		wire_nlOiiO_dataout = (n0OO === 1'b1) ? n0il : (~ nll0Oi);
	assign		wire_nlOili_dataout = (nl111i === 1'b1) ? wire_nlO1il_dataout : wire_nlOiOi_dataout;
	assign		wire_nlOill_dataout = (nl111i === 1'b1) ? wire_nlO1iO_dataout : (~ nl11ii);
	assign		wire_nlOilO_dataout = (nl111i === 1'b1) ? wire_nlO1li_dataout : wire_nlOiOl_dataout;
	or(wire_nlOiOi_dataout, (~ nll0Oi), (~ nl11ii));
	and(wire_nlOiOl_dataout, (~ nll0Oi), ~{(~ nl11ii)});
	and(wire_nlOiOO_dataout, wire_nlO1il_dataout, nl111i);
	and(wire_nlOl0i_dataout, n00l, n0OO);
	and(wire_nlOl0l_dataout, n0il, n0OO);
	or(wire_nlOl0O_dataout, wire_nlO1il_dataout, ~{nl111i});
	and(wire_nlOl1i_dataout, wire_nlO1li_dataout, nl111i);
	assign		wire_nlOl1l_dataout = (nl111i === 1'b1) ? wire_nlO1il_dataout : wire_nlOl0i_dataout;
	assign		wire_nlOl1O_dataout = (nl111i === 1'b1) ? wire_nlO1li_dataout : wire_nlOl0l_dataout;
	assign		wire_nlOlii_dataout = (nl111i === 1'b1) ? wire_nlO1iO_dataout : nl111O;
	assign		wire_nlOlil_dataout = (nl111i === 1'b1) ? wire_nlO1li_dataout : (~ nl111O);
	or(wire_nlOlli_dataout, wire_nllOil_dataout, ~{rdenablesync});
	and(wire_nlOlll_dataout, wire_nllOiO_dataout, rdenablesync);
	and(wire_nlOllO_dataout, wire_nllOli_dataout, rdenablesync);
	or(wire_nlOlOi_dataout, wire_nllOll_dataout, ~{rdenablesync});
	or(wire_nlOlOl_dataout, wire_nllOlO_dataout, ~{rdenablesync});
	or(wire_nlOlOO_dataout, wire_nllOOi_dataout, ~{rdenablesync});
	or(wire_nlOO1i_dataout, wire_nlOiOO_dataout, ~{rdenablesync});
	and(wire_nlOO1l_dataout, wire_nllOOO_dataout, rdenablesync);
	or(wire_nlOO1O_dataout, wire_nlOl1i_dataout, ~{rdenablesync});
	or(wire_nlOOii_dataout, wire_n111i_o, nl1l1i);
	and(wire_nlOOil_dataout, wire_n111l_o, ~{nl1l1i});
	or(wire_nlOOiO_dataout, wire_n111O_o, nl1l1i);
	or(wire_nlOOli_dataout, wire_n110i_o, nl1l1i);
	or(wire_nlOOll_dataout, wire_n110l_o, nl1l1i);
	or(wire_nlOOlO_dataout, wire_n110O_o, nl1l1i);
	or(wire_nlOOOi_dataout, wire_n11ii_o, nl1l1i);
	or(wire_nlOOOl_dataout, wire_n11il_o, nl1l1i);
	or(wire_nlOOOO_dataout, wire_n11iO_o, nl1l1i);
	oper_add   nlO0i
	( 
	.a({nll0lO, nllil, nllii, nll0O, nll0l, 1'b1}),
	.b({{4{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO0i_o));
	defparam
		nlO0i.sgate_representation = 0,
		nlO0i.width_a = 6,
		nlO0i.width_b = 6,
		nlO0i.width_o = 6;
	oper_decoder   nllOii
	( 
	.i({nlliOl, ni1l, nlliOi, nllill}),
	.o(wire_nllOii_o));
	defparam
		nllOii.width_i = 4,
		nllOii.width_o = 16;
	oper_less_than   nll1l
	( 
	.a({1'b1, {3{1'b0}}}),
	.b({nlliOl, ni1l, nlliOi, nllill}),
	.cin(1'b0),
	.o(wire_nll1l_o));
	defparam
		nll1l.sgate_representation = 0,
		nll1l.width_a = 4,
		nll1l.width_b = 4;
	oper_selector   n000i
	( 
	.data({1'b1, wire_n00Ol_dataout, wire_n0lll_dataout, {2{wire_n0Oii_dataout}}, wire_n0Oli_dataout, wire_ni1li_dataout, wire_n0OlO_dataout, wire_ni11i_dataout}),
	.o(wire_n000i_o),
	.sel({niOOlO, wire_nllOii_o[8:1]}));
	defparam
		n000i.width_data = 9,
		n000i.width_sel = 9;
	oper_selector   n000l
	( 
	.data({1'b0, wire_n00OO_dataout, wire_n0llO_dataout, {2{wire_n0Oil_dataout}}, wire_n00OO_dataout, wire_ni1ll_dataout, wire_n0llO_dataout, wire_ni11l_dataout}),
	.o(wire_n000l_o),
	.sel({niOOlO, wire_nllOii_o[8:1]}));
	defparam
		n000l.width_data = 9,
		n000l.width_sel = 9;
	oper_selector   n000O
	( 
	.data({1'b1, wire_n0i1i_dataout, wire_n0lOi_dataout, {2{wire_n0OiO_dataout}}, wire_n0Oll_dataout, wire_ni1lO_dataout, wire_n0OOi_dataout, wire_ni11O_dataout}),
	.o(wire_n000O_o),
	.sel({niOOlO, wire_nllOii_o[8:1]}));
	defparam
		n000O.width_data = 9,
		n000O.width_sel = 9;
	oper_selector   n001i
	( 
	.data({1'b1, wire_n00ll_dataout, wire_n0lil_dataout, {3{wire_n00ll_dataout}}, wire_ni1ii_dataout, wire_n0lil_dataout, wire_n00ll_dataout}),
	.o(wire_n001i_o),
	.sel({niOOlO, wire_nllOii_o[8:1]}));
	defparam
		n001i.width_data = 9,
		n001i.width_sel = 9;
	oper_selector   n001l
	( 
	.data({1'b1, wire_n00lO_dataout, wire_n0liO_dataout, {3{wire_n00lO_dataout}}, wire_ni1il_dataout, wire_n0liO_dataout, wire_n00lO_dataout}),
	.o(wire_n001l_o),
	.sel({niOOlO, wire_nllOii_o[8:1]}));
	defparam
		n001l.width_data = 9,
		n001l.width_sel = 9;
	oper_selector   n001O
	( 
	.data({1'b1, wire_n00Oi_dataout, wire_n0lli_dataout, {3{wire_n00Oi_dataout}}, wire_ni1iO_dataout, wire_n0lli_dataout, wire_n00Oi_dataout}),
	.o(wire_n001O_o),
	.sel({niOOlO, wire_nllOii_o[8:1]}));
	defparam
		n001O.width_data = 9,
		n001O.width_sel = 9;
	oper_selector   n01Oi
	( 
	.data({1'b1, wire_n00il_dataout, wire_n0l0l_dataout, {3{wire_n00il_dataout}}, wire_ni10i_dataout, wire_n0l0l_dataout, wire_n00il_dataout}),
	.o(wire_n01Oi_o),
	.sel({niOOOl, wire_nllOii_o[8:1]}));
	defparam
		n01Oi.width_data = 9,
		n01Oi.width_sel = 9;
	oper_selector   n01Ol
	( 
	.data({1'b0, wire_n00iO_dataout, wire_n0l0O_dataout, {3{wire_n00iO_dataout}}, wire_ni10l_dataout, wire_n0l0O_dataout, wire_n00iO_dataout}),
	.o(wire_n01Ol_o),
	.sel({niOOlO, wire_nllOii_o[8:1]}));
	defparam
		n01Ol.width_data = 9,
		n01Ol.width_sel = 9;
	oper_selector   n01OO
	( 
	.data({1'b0, wire_n00li_dataout, wire_n0lii_dataout, {3{wire_n00li_dataout}}, wire_ni10O_dataout, wire_n0lii_dataout, wire_n00li_dataout}),
	.o(wire_n01OO_o),
	.sel({niOOlO, wire_nllOii_o[8:1]}));
	defparam
		n01OO.width_data = 9,
		n01OO.width_sel = 9;
	oper_selector   n110i
	( 
	.data({1'b1, wire_n11Ol_dataout, wire_n1ill_dataout, {3{wire_n11Ol_dataout}}, wire_n1Oli_dataout, wire_n1ill_dataout, wire_n11Ol_dataout}),
	.o(wire_n110i_o),
	.sel({niOOli, wire_nllOii_o[8:1]}));
	defparam
		n110i.width_data = 9,
		n110i.width_sel = 9;
	oper_selector   n110l
	( 
	.data({1'b1, wire_n11OO_dataout, wire_n1ilO_dataout, {3{wire_n11OO_dataout}}, wire_n1Oll_dataout, wire_n1ilO_dataout, wire_n11OO_dataout}),
	.o(wire_n110l_o),
	.sel({niOOli, wire_nllOii_o[8:1]}));
	defparam
		n110l.width_data = 9,
		n110l.width_sel = 9;
	oper_selector   n110O
	( 
	.data({1'b1, wire_n101i_dataout, wire_n1iOi_dataout, {3{wire_n101i_dataout}}, wire_n1OlO_dataout, wire_n1iOi_dataout, wire_n101i_dataout}),
	.o(wire_n110O_o),
	.sel({niOOli, wire_nllOii_o[8:1]}));
	defparam
		n110O.width_data = 9,
		n110O.width_sel = 9;
	oper_selector   n111i
	( 
	.data({1'b1, wire_n11ll_dataout, wire_n1iil_dataout, {3{wire_n11ll_dataout}}, wire_n1Oii_dataout, wire_n1iil_dataout, wire_n11ll_dataout}),
	.o(wire_n111i_o),
	.sel({niOOOl, wire_nllOii_o[8:1]}));
	defparam
		n111i.width_data = 9,
		n111i.width_sel = 9;
	oper_selector   n111l
	( 
	.data({1'b0, wire_n11lO_dataout, wire_n1iiO_dataout, {3{wire_n11lO_dataout}}, wire_n1Oil_dataout, wire_n1iiO_dataout, wire_n11lO_dataout}),
	.o(wire_n111l_o),
	.sel({niOOli, wire_nllOii_o[8:1]}));
	defparam
		n111l.width_data = 9,
		n111l.width_sel = 9;
	oper_selector   n111O
	( 
	.data({1'b0, wire_n11Oi_dataout, wire_n1ili_dataout, {3{wire_n11Oi_dataout}}, wire_n1OiO_dataout, wire_n1ili_dataout, wire_n11Oi_dataout}),
	.o(wire_n111O_o),
	.sel({niOOli, wire_nllOii_o[8:1]}));
	defparam
		n111O.width_data = 9,
		n111O.width_sel = 9;
	oper_selector   n11ii
	( 
	.data({1'b1, wire_n101l_dataout, wire_n1iOl_dataout, {2{wire_n1lli_dataout}}, wire_n1lOi_dataout, wire_n1OOi_dataout, wire_n1lOO_dataout, wire_n1O0i_dataout}),
	.o(wire_n11ii_o),
	.sel({niOOli, wire_nllOii_o[8:1]}));
	defparam
		n11ii.width_data = 9,
		n11ii.width_sel = 9;
	oper_selector   n11il
	( 
	.data({1'b0, wire_n101O_dataout, wire_n1iOO_dataout, {2{wire_n1lll_dataout}}, wire_n101O_dataout, wire_n1OOl_dataout, wire_n1iOO_dataout, wire_n1O0l_dataout}),
	.o(wire_n11il_o),
	.sel({niOOli, wire_nllOii_o[8:1]}));
	defparam
		n11il.width_data = 9,
		n11il.width_sel = 9;
	oper_selector   n11iO
	( 
	.data({1'b1, wire_n100i_dataout, wire_n1l1i_dataout, {2{wire_n1llO_dataout}}, wire_n1lOl_dataout, wire_n1OOO_dataout, wire_n1O1i_dataout, wire_n1O0O_dataout}),
	.o(wire_n11iO_o),
	.sel({niOOli, wire_nllOii_o[8:1]}));
	defparam
		n11iO.width_data = 9,
		n11iO.width_sel = 9;
	oper_selector   ni0li
	( 
	.data({1'b1, {5{wire_nii0l_dataout}}, wire_nl10O_dataout, {2{wire_nii0l_dataout}}}),
	.o(wire_ni0li_o),
	.sel({niOOOl, wire_nllOii_o[8:1]}));
	defparam
		ni0li.width_data = 9,
		ni0li.width_sel = 9;
	oper_selector   ni0ll
	( 
	.data({1'b0, wire_nii0O_dataout, wire_nilil_dataout, {3{wire_nii0O_dataout}}, wire_nl1ii_dataout, wire_nilil_dataout, wire_nii0O_dataout}),
	.o(wire_ni0ll_o),
	.sel({niOOOl, wire_nllOii_o[8:1]}));
	defparam
		ni0ll.width_data = 9,
		ni0ll.width_sel = 9;
	oper_selector   ni0lO
	( 
	.data({1'b0, wire_niiii_dataout, wire_niliO_dataout, {3{wire_niiii_dataout}}, wire_nl1il_dataout, wire_niliO_dataout, wire_niiii_dataout}),
	.o(wire_ni0lO_o),
	.sel({niOOOl, wire_nllOii_o[8:1]}));
	defparam
		ni0lO.width_data = 9,
		ni0lO.width_sel = 9;
	oper_selector   ni0Oi
	( 
	.data({1'b1, wire_niiil_dataout, wire_nilli_dataout, {3{wire_niiil_dataout}}, wire_nl1iO_dataout, wire_nilli_dataout, wire_niiil_dataout}),
	.o(wire_ni0Oi_o),
	.sel({niOOOl, wire_nllOii_o[8:1]}));
	defparam
		ni0Oi.width_data = 9,
		ni0Oi.width_sel = 9;
	oper_selector   ni0Ol
	( 
	.data({1'b1, wire_niiiO_dataout, wire_nilll_dataout, {3{wire_niiiO_dataout}}, wire_nl1li_dataout, wire_nilll_dataout, wire_niiiO_dataout}),
	.o(wire_ni0Ol_o),
	.sel({niOOOl, wire_nllOii_o[8:1]}));
	defparam
		ni0Ol.width_data = 9,
		ni0Ol.width_sel = 9;
	oper_selector   ni0OO
	( 
	.data({1'b1, wire_niili_dataout, wire_nillO_dataout, {3{wire_niili_dataout}}, wire_nl1ll_dataout, wire_nillO_dataout, wire_niili_dataout}),
	.o(wire_ni0OO_o),
	.sel({niOOOl, wire_nllOii_o[8:1]}));
	defparam
		ni0OO.width_data = 9,
		ni0OO.width_sel = 9;
	oper_selector   nii1i
	( 
	.data({1'b1, wire_niill_dataout, wire_nilOi_dataout, {2{wire_niOiO_dataout}}, wire_niOlO_dataout, wire_nl1lO_dataout, wire_niOOl_dataout, wire_nl11O_dataout}),
	.o(wire_nii1i_o),
	.sel({niOOOl, wire_nllOii_o[8:1]}));
	defparam
		nii1i.width_data = 9,
		nii1i.width_sel = 9;
	oper_selector   nii1l
	( 
	.data({1'b0, wire_niilO_dataout, wire_nilOl_dataout, {2{wire_niOli_dataout}}, wire_niilO_dataout, wire_nl1Oi_dataout, wire_nilOl_dataout, wire_nl10i_dataout}),
	.o(wire_nii1l_o),
	.sel({niOOOl, wire_nllOii_o[8:1]}));
	defparam
		nii1l.width_data = 9,
		nii1l.width_sel = 9;
	oper_selector   nii1O
	( 
	.data({1'b1, wire_niiOi_dataout, wire_nilOO_dataout, {2{wire_niOll_dataout}}, wire_niOOi_dataout, wire_nl1Ol_dataout, wire_niOOO_dataout, wire_nl10l_dataout}),
	.o(wire_nii1O_o),
	.sel({niOOOl, wire_nllOii_o[8:1]}));
	defparam
		nii1O.width_data = 9,
		nii1O.width_sel = 9;
	oper_selector   nl00i
	( 
	.data({1'b0, (~ nl111i), wire_nl0ll_dataout, {3{(~ nl111i)}}, wire_nli0l_dataout, (~ nl111i)}),
	.o(wire_nl00i_o),
	.sel({niOOOO, wire_nllOii_o[8:2]}));
	defparam
		nl00i.width_data = 8,
		nl00i.width_sel = 8;
	oper_selector   nl01l
	( 
	.data({1'b1, wire_nl0il_dataout, wire_nl0li_dataout, {2{wire_nli1i_dataout}}, 1'b0, (~ rdenablesync), (~ nl111i)}),
	.o(wire_nl01l_o),
	.sel({niOOOl, wire_nllOii_o[8:5], (wire_nllOii_o[4] | wire_nllOii_o[2]), wire_nllOii_o[3], wire_nllOii_o[1]}));
	defparam
		nl01l.width_data = 8,
		nl01l.width_sel = 8;
	oper_selector   nl1OO
	( 
	.data({1'b1, wire_nl0ii_dataout, wire_nl0iO_dataout, {2{wire_nl0OO_dataout}}, wire_nli1O_dataout, wire_nli0i_dataout}),
	.o(wire_nl1OO_o),
	.sel({niOOOi, wire_nllOii_o[8:5], wire_nllOii_o[2:1]}));
	defparam
		nl1OO.width_data = 7,
		nl1OO.width_sel = 7;
	oper_selector   nllllO
	( 
	.data({1'b1, wire_nllOil_dataout, wire_nlO0il_dataout, {3{wire_nllOil_dataout}}, wire_nlOlli_dataout, wire_nlO0il_dataout, wire_nllOil_dataout}),
	.o(wire_nllllO_o),
	.sel({niOOOl, wire_nllOii_o[8:1]}));
	defparam
		nllllO.width_data = 9,
		nllllO.width_sel = 9;
	oper_selector   nlllOi
	( 
	.data({1'b0, wire_nllOiO_dataout, wire_nlO0iO_dataout, {3{wire_nllOiO_dataout}}, wire_nlOlll_dataout, wire_nlO0iO_dataout, wire_nllOiO_dataout}),
	.o(wire_nlllOi_o),
	.sel({niOOil, wire_nllOii_o[8:1]}));
	defparam
		nlllOi.width_data = 9,
		nlllOi.width_sel = 9;
	oper_selector   nlllOl
	( 
	.data({1'b0, wire_nllOli_dataout, wire_nlO0li_dataout, {3{wire_nllOli_dataout}}, wire_nlOllO_dataout, wire_nlO0li_dataout, wire_nllOli_dataout}),
	.o(wire_nlllOl_o),
	.sel({niOOil, wire_nllOii_o[8:1]}));
	defparam
		nlllOl.width_data = 9,
		nlllOl.width_sel = 9;
	oper_selector   nlllOO
	( 
	.data({1'b1, wire_nllOll_dataout, wire_nlO0ll_dataout, {3{wire_nllOll_dataout}}, wire_nlOlOi_dataout, wire_nlO0ll_dataout, wire_nllOll_dataout}),
	.o(wire_nlllOO_o),
	.sel({niOOil, wire_nllOii_o[8:1]}));
	defparam
		nlllOO.width_data = 9,
		nlllOO.width_sel = 9;
	oper_selector   nllO0i
	( 
	.data({1'b0, wire_nllOOO_dataout, wire_nlO0OO_dataout, {2{wire_nlOill_dataout}}, wire_nllOOO_dataout, wire_nlOO1l_dataout, wire_nlO0OO_dataout, wire_nlOlii_dataout}),
	.o(wire_nllO0i_o),
	.sel({niOOil, wire_nllOii_o[8:1]}));
	defparam
		nllO0i.width_data = 9,
		nllO0i.width_sel = 9;
	oper_selector   nllO0l
	( 
	.data({1'b1, wire_nlO11i_dataout, wire_nlOi1i_dataout, {2{wire_nlOilO_dataout}}, wire_nlOl1i_dataout, wire_nlOO1O_dataout, wire_nlOl1O_dataout, wire_nlOlil_dataout}),
	.o(wire_nllO0l_o),
	.sel({niOOil, wire_nllOii_o[8:1]}));
	defparam
		nllO0l.width_data = 9,
		nllO0l.width_sel = 9;
	oper_selector   nllO1i
	( 
	.data({1'b1, wire_nllOlO_dataout, wire_nlO0lO_dataout, {3{wire_nllOlO_dataout}}, wire_nlOlOl_dataout, wire_nlO0lO_dataout, wire_nllOlO_dataout}),
	.o(wire_nllO1i_o),
	.sel({niOOil, wire_nllOii_o[8:1]}));
	defparam
		nllO1i.width_data = 9,
		nllO1i.width_sel = 9;
	oper_selector   nllO1l
	( 
	.data({1'b1, wire_nllOOi_dataout, wire_nlO0Oi_dataout, {3{wire_nllOOi_dataout}}, wire_nlOlOO_dataout, wire_nlO0Oi_dataout, wire_nllOOi_dataout}),
	.o(wire_nllO1l_o),
	.sel({niOOil, wire_nllOii_o[8:1]}));
	defparam
		nllO1l.width_data = 9,
		nllO1l.width_sel = 9;
	oper_selector   nllO1O
	( 
	.data({1'b1, wire_nllOOl_dataout, wire_nlO0Ol_dataout, {2{wire_nlOili_dataout}}, wire_nlOiOO_dataout, wire_nlOO1i_dataout, wire_nlOl1l_dataout, wire_nlOl0O_dataout}),
	.o(wire_nllO1O_o),
	.sel({niOOil, wire_nllOii_o[8:1]}));
	defparam
		nllO1O.width_data = 9,
		nllO1O.width_sel = 9;
	assign
		niOOil = (((((((wire_nllOii_o[15] | wire_nllOii_o[14]) | wire_nllOii_o[13]) | wire_nllOii_o[12]) | wire_nllOii_o[11]) | wire_nllOii_o[10]) | wire_nllOii_o[9]) | wire_nllOii_o[0]),
		niOOiO = (nl11lO | niOOll),
		niOOli = (((((((wire_nllOii_o[15] | wire_nllOii_o[14]) | wire_nllOii_o[13]) | wire_nllOii_o[12]) | wire_nllOii_o[11]) | wire_nllOii_o[10]) | wire_nllOii_o[9]) | wire_nllOii_o[0]),
		niOOll = (nl101O | nl11Ol),
		niOOlO = (((((((wire_nllOii_o[15] | wire_nllOii_o[14]) | wire_nllOii_o[13]) | wire_nllOii_o[12]) | wire_nllOii_o[11]) | wire_nllOii_o[10]) | wire_nllOii_o[9]) | wire_nllOii_o[0]),
		niOOOi = (((((((((wire_nllOii_o[15] | wire_nllOii_o[14]) | wire_nllOii_o[13]) | wire_nllOii_o[12]) | wire_nllOii_o[11]) | wire_nllOii_o[10]) | wire_nllOii_o[9]) | wire_nllOii_o[0]) | wire_nllOii_o[4]) | wire_nllOii_o[3]),
		niOOOl = (((((((wire_nllOii_o[15] | wire_nllOii_o[14]) | wire_nllOii_o[13]) | wire_nllOii_o[12]) | wire_nllOii_o[11]) | wire_nllOii_o[10]) | wire_nllOii_o[9]) | wire_nllOii_o[0]),
		niOOOO = ((((((((wire_nllOii_o[15] | wire_nllOii_o[14]) | wire_nllOii_o[13]) | wire_nllOii_o[12]) | wire_nllOii_o[11]) | wire_nllOii_o[10]) | wire_nllOii_o[9]) | wire_nllOii_o[0]) | wire_nllOii_o[1]),
		nl000l = (((((((txdatain[0] & txdatain[1]) & (~ txdatain[2])) & txdatain[3]) & txdatain[4]) & txdatain[5]) & txdatain[6]) & txdatain[7]),
		nl001i = ((((((((~ txdatain[0]) & (~ txdatain[1])) & txdatain[2]) & txdatain[3]) & txdatain[4]) & txdatain[5]) & (~ txdatain[6])) & (~ txdatain[7])),
		nl001l = (((((((txdatain[0] & (~ txdatain[1])) & txdatain[2]) & txdatain[3]) & txdatain[4]) & txdatain[5]) & txdatain[6]) & txdatain[7]),
		nl00il = (((((((txdatain[0] & txdatain[1]) & txdatain[2]) & (~ txdatain[3])) & (~ txdatain[4])) & (~ txdatain[5])) & (~ txdatain[6])) & (~ txdatain[7])),
		nl00ll = ((((((((~ txdatain[0]) & (~ txdatain[1])) & txdatain[2]) & txdatain[3]) & txdatain[4]) & (~ txdatain[5])) & (~ txdatain[6])) & txdatain[7]),
		nl010i = (((((((txdatain[8] & txdatain[9]) & txdatain[10]) & (~ txdatain[11])) & (~ txdatain[12])) & (~ txdatain[13])) & (~ txdatain[14])) & (~ txdatain[15])),
		nl010l = (((((((((((((~ nl00ll) & ((txctrl[0] & (~ nl00il)) & nl000O2)) & (~ nl000l)) & nl001O5) & (~ nl001l)) & (~ nl001i)) & nl01Ol8) & (~ nl01Oi)) & (~ nl01lO)) & (~ nl01ll)) & nl01iO11) & (~ nl01il)) & nl010O14),
		nl011i = ((((((((~ txdatain[8]) & (~ txdatain[9])) & txdatain[10]) & txdatain[11]) & txdatain[12]) & (~ txdatain[13])) & (~ txdatain[14])) & txdatain[15]),
		nl01il = (((((((txdatain[0] & txdatain[1]) & txdatain[2]) & (~ txdatain[3])) & txdatain[4]) & txdatain[5]) & txdatain[6]) & txdatain[7]),
		nl01ll = ((((((((~ txdatain[0]) & (~ txdatain[1])) & txdatain[2]) & txdatain[3]) & txdatain[4]) & txdatain[5]) & txdatain[6]) & txdatain[7]),
		nl01lO = ((((((((~ txdatain[0]) & (~ txdatain[1])) & txdatain[2]) & txdatain[3]) & txdatain[4]) & (~ txdatain[5])) & txdatain[6]) & txdatain[7]),
		nl01Oi = ((((((((~ txdatain[0]) & (~ txdatain[1])) & txdatain[2]) & txdatain[3]) & txdatain[4]) & (~ txdatain[5])) & txdatain[6]) & (~ txdatain[7])),
		nl100i = (((((((((((((((((((((((((((((((txdatain[0] & (~ txdatain[1])) & txdatain[2]) & txdatain[3]) & txdatain[4]) & txdatain[5]) & txdatain[6]) & txdatain[7]) & txdatain[8]) & txdatain[9]) & txdatain[10]) & (~ txdatain[11])) & (~ txdatain[12])) & (~ txdatain[13])) & (~ txdatain[14])) & (~ txdatain[15])) & txdatain[16]) & txdatain[17]) & txdatain[18]) & (~ txdatain[19])) & (~ txdatain[20])) & (~ txdatain[21])) & (~ txdatain[22])) & (~ txdatain[23])) & txdatain[24]) & txdatain[25]) & txdatain[26]) & (~ txdatain[27])) & (~ txdatain[28])) & (~ txdatain[29])) & (~ txdatain[30])) & (~ txdatain[31])),
		nl101l = (((((((((((((((((((((((txdatain[8] & (~ txdatain[9])) & txdatain[10]) & txdatain[11]) & txdatain[12]) & txdatain[13]) & txdatain[14]) & txdatain[15]) & txdatain[16]) & txdatain[17]) & txdatain[18]) & (~ txdatain[19])) & (~ txdatain[20])) & (~ txdatain[21])) & (~ txdatain[22])) & (~ txdatain[23])) & txdatain[24]) & txdatain[25]) & txdatain[26]) & (~ txdatain[27])) & (~ txdatain[28])) & (~ txdatain[29])) & (~ txdatain[30])) & (~ txdatain[31])),
		nl101O = (((((txctrl[3] & txctrl[2]) & txctrl[1]) & txctrl[0]) & nl100l56) & nl100i),
		nl10ii = ((((txctrl[3] & txctrl[2]) & txctrl[1]) & txctrl[0]) & nl10il),
		nl10il = (((((((((((((((((((((((((((((((txdatain[0] & txdatain[1]) & txdatain[2]) & (~ txdatain[3])) & (~ txdatain[4])) & (~ txdatain[5])) & (~ txdatain[6])) & (~ txdatain[7])) & txdatain[8]) & txdatain[9]) & txdatain[10]) & (~ txdatain[11])) & (~ txdatain[12])) & (~ txdatain[13])) & (~ txdatain[14])) & (~ txdatain[15])) & txdatain[16]) & txdatain[17]) & txdatain[18]) & (~ txdatain[19])) & (~ txdatain[20])) & (~ txdatain[21])) & (~ txdatain[22])) & (~ txdatain[23])) & txdatain[24]) & txdatain[25]) & txdatain[26]) & (~ txdatain[27])) & (~ txdatain[28])) & (~ txdatain[29])) & (~ txdatain[30])) & (~ txdatain[31])),
		nl10iO = (((((((((((~ nl1iOO) & (((((txctrl[3] & (~ nl1iOl)) & nl1ilO38) & (~ nl1ill)) & (~ nl1ili)) & nl1iil41)) & nl1i0O44) & (~ nl1i0l)) & nl1i1O47) & (~ nl1i1l)) & (~ nl1i1i)) & nl10Ol50) & (~ nl10Oi)) & (~ nl10lO)) & nl10li53),
		nl10lO = (((((((txdatain[24] & txdatain[25]) & txdatain[26]) & (~ txdatain[27])) & txdatain[28]) & txdatain[29]) & txdatain[30]) & txdatain[31]),
		nl10Oi = ((((((((~ txdatain[24]) & (~ txdatain[25])) & txdatain[26]) & txdatain[27]) & txdatain[28]) & txdatain[29]) & txdatain[30]) & txdatain[31]),
		nl110i = (nl11il & nl110O),
		nl110l = (((~ nl11ii) & nl11il) & ((((((~ nlliOl) & ni1l) & nlliOi) & (~ nllill)) | ((((~ nlliOl) & ni1l) & (~ nlliOi)) & nllill)) | (nll0ll & nl110O))),
		nl110O = ((((~ nlliOl) & (~ ni1l)) & (~ nlliOi)) & nllill),
		nl111i = ((~ nl10ii) & (~ nl11li)),
		nl111l = ((((~ nlliOl) & (~ ni1l)) & nlliOi) & nllill),
		nl111O = ((~ nl11ii) & nll0ll),
		nl11ii = ((((nllil | nllii) | nll0O) | nll0l) | nll0lO),
		nl11il = (nl10ii | nl11li),
		nl11iO = 1'b1,
		nl11li = (((((~ txctrl[3]) & (~ txctrl[2])) & (~ txctrl[1])) & txctrl[0]) & nl00ll),
		nl11ll = (txctrl[3] & nl1iOO),
		nl11lO = ((txctrl[3] & txctrl[2]) & nl11Oi),
		nl11Oi = (((((((((((((((txdatain[16] & (~ txdatain[17])) & txdatain[18]) & txdatain[19]) & txdatain[20]) & txdatain[21]) & txdatain[22]) & txdatain[23]) & txdatain[24]) & txdatain[25]) & txdatain[26]) & (~ txdatain[27])) & (~ txdatain[28])) & (~ txdatain[29])) & (~ txdatain[30])) & (~ txdatain[31])),
		nl11Ol = ((((txctrl[3] & txctrl[2]) & txctrl[1]) & nl101l) & nl11OO59),
		nl1i0l = ((((((((~ txdatain[24]) & (~ txdatain[25])) & txdatain[26]) & txdatain[27]) & txdatain[28]) & txdatain[29]) & (~ txdatain[30])) & (~ txdatain[31])),
		nl1i1i = ((((((((~ txdatain[24]) & (~ txdatain[25])) & txdatain[26]) & txdatain[27]) & txdatain[28]) & (~ txdatain[29])) & txdatain[30]) & txdatain[31]),
		nl1i1l = ((((((((~ txdatain[24]) & (~ txdatain[25])) & txdatain[26]) & txdatain[27]) & txdatain[28]) & (~ txdatain[29])) & txdatain[30]) & (~ txdatain[31])),
		nl1ili = (((((((txdatain[24] & txdatain[25]) & (~ txdatain[26])) & txdatain[27]) & txdatain[28]) & txdatain[29]) & txdatain[30]) & txdatain[31]),
		nl1ill = ((((((((~ txdatain[24]) & (~ txdatain[25])) & txdatain[26]) & txdatain[27]) & txdatain[28]) & (~ txdatain[29])) & (~ txdatain[30])) & txdatain[31]),
		nl1iOl = (((((((txdatain[24] & txdatain[25]) & txdatain[26]) & (~ txdatain[27])) & (~ txdatain[28])) & (~ txdatain[29])) & (~ txdatain[30])) & (~ txdatain[31])),
		nl1iOO = (((((((txdatain[24] & (~ txdatain[25])) & txdatain[26]) & txdatain[27]) & txdatain[28]) & txdatain[29]) & txdatain[30]) & txdatain[31]),
		nl1l0O = ((((((((~ txdatain[16]) & (~ txdatain[17])) & txdatain[18]) & txdatain[19]) & txdatain[20]) & (~ txdatain[21])) & txdatain[22]) & txdatain[23]),
		nl1l1i = (((((((((((((txctrl[2] & (~ nl1O1O)) & nl1O1i26) & (~ nl1lOO)) & nl1lOi29) & (~ nl1llO)) & (~ nl1lll)) & (~ nl1lli)) & (~ nl1liO)) & nl1lii32) & (~ nl1l0O)) & nl1l0i35) & (~ nl1l1O)) & (~ nl1l1l)),
		nl1l1l = (((((((txdatain[16] & txdatain[17]) & txdatain[18]) & (~ txdatain[19])) & txdatain[20]) & txdatain[21]) & txdatain[22]) & txdatain[23]),
		nl1l1O = ((((((((~ txdatain[16]) & (~ txdatain[17])) & txdatain[18]) & txdatain[19]) & txdatain[20]) & txdatain[21]) & txdatain[22]) & txdatain[23]),
		nl1liO = ((((((((~ txdatain[16]) & (~ txdatain[17])) & txdatain[18]) & txdatain[19]) & txdatain[20]) & (~ txdatain[21])) & txdatain[22]) & (~ txdatain[23])),
		nl1lli = ((((((((~ txdatain[16]) & (~ txdatain[17])) & txdatain[18]) & txdatain[19]) & txdatain[20]) & txdatain[21]) & (~ txdatain[22])) & (~ txdatain[23])),
		nl1lll = (((((((txdatain[16] & (~ txdatain[17])) & txdatain[18]) & txdatain[19]) & txdatain[20]) & txdatain[21]) & txdatain[22]) & txdatain[23]),
		nl1llO = (((((((txdatain[16] & txdatain[17]) & (~ txdatain[18])) & txdatain[19]) & txdatain[20]) & txdatain[21]) & txdatain[22]) & txdatain[23]),
		nl1lOO = ((((((((~ txdatain[16]) & (~ txdatain[17])) & txdatain[18]) & txdatain[19]) & txdatain[20]) & (~ txdatain[21])) & (~ txdatain[22])) & txdatain[23]),
		nl1O0i = ((((((((((((txctrl[1] & (~ nl010i)) & nl011l17) & (~ nl011i)) & (~ nl1OOO)) & nl1OOi20) & (~ nl1OlO)) & (~ nl1Oll)) & (~ nl1Oli)) & (~ nl1OiO)) & nl1Oii23) & (~ nl1O0O)) & (~ nl1O0l)),
		nl1O0l = (((((((txdatain[8] & txdatain[9]) & txdatain[10]) & (~ txdatain[11])) & txdatain[12]) & txdatain[13]) & txdatain[14]) & txdatain[15]),
		nl1O0O = ((((((((~ txdatain[8]) & (~ txdatain[9])) & txdatain[10]) & txdatain[11]) & txdatain[12]) & txdatain[13]) & txdatain[14]) & txdatain[15]),
		nl1O1O = (((((((txdatain[16] & txdatain[17]) & txdatain[18]) & (~ txdatain[19])) & (~ txdatain[20])) & (~ txdatain[21])) & (~ txdatain[22])) & (~ txdatain[23])),
		nl1OiO = ((((((((~ txdatain[8]) & (~ txdatain[9])) & txdatain[10]) & txdatain[11]) & txdatain[12]) & (~ txdatain[13])) & txdatain[14]) & txdatain[15]),
		nl1Oli = ((((((((~ txdatain[8]) & (~ txdatain[9])) & txdatain[10]) & txdatain[11]) & txdatain[12]) & (~ txdatain[13])) & txdatain[14]) & (~ txdatain[15])),
		nl1Oll = ((((((((~ txdatain[8]) & (~ txdatain[9])) & txdatain[10]) & txdatain[11]) & txdatain[12]) & txdatain[13]) & (~ txdatain[14])) & (~ txdatain[15])),
		nl1OlO = (((((((txdatain[8] & (~ txdatain[9])) & txdatain[10]) & txdatain[11]) & txdatain[12]) & txdatain[13]) & txdatain[14]) & txdatain[15]),
		nl1OOO = (((((((txdatain[8] & txdatain[9]) & (~ txdatain[10])) & txdatain[11]) & txdatain[12]) & txdatain[13]) & txdatain[14]) & txdatain[15]),
		txctrlout = {nll11l, nll1il, nll1Ol, nll00l},
		txdataout = {nll1ii, nlll1l, nll10O, nll10l, nll10i, nll11O, nlll1i, nlliOO, nll1Oi, nlOO0O, nll1lO, nll1ll, nll1li, nll1iO, nlOO0l, nlOO0i, nll00i, n011O, nll01O, nll01l, nll01i, nll1OO, n011l, n011i, nll0li, ni1OO, nll0iO, nll0il, nll0ii, nll00O, ni1Ol, ni1Oi};
endmodule //altgxb_xgm_tx_sm
//synopsys translate_on
//VALID FILE
//
// altgxb_reset
//

module altgxb_xgm_reset_block
   (
    txdigitalreset,
    rxdigitalreset,
    rxanalogreset,
    pllreset,
    pllenable,
    txdigitalresetout,
    rxdigitalresetout,   
    txanalogresetout,
    rxanalogresetout,
    pllresetout
    );

   // INPUTs
   input [3:0] txdigitalreset;
   input [3:0] rxdigitalreset;
   input [3:0] rxanalogreset;
   input       pllreset;
   input       pllenable;

   // OUTPUTs:
   output [3:0] txdigitalresetout;
   output [3:0] rxdigitalresetout;   
   output [3:0] txanalogresetout;
   output [3:0] rxanalogresetout;
   output   pllresetout;

   // WIREs:
   wire     HARD_RESET;

   assign HARD_RESET = pllreset || !pllenable;

   // RESET OUTPUTs
   assign rxanalogresetout = {(HARD_RESET | rxanalogreset[3]),
                  (HARD_RESET | rxanalogreset[2]),
                  (HARD_RESET | rxanalogreset[1]),
                  (HARD_RESET | rxanalogreset[0])};
   
   assign txanalogresetout = {HARD_RESET, HARD_RESET,
                  HARD_RESET, HARD_RESET};
      
   assign pllresetout       = rxanalogresetout[0] & rxanalogresetout[1] & 
                  rxanalogresetout[2] & rxanalogresetout[3] & 
                  txanalogresetout[0] & txanalogresetout[1] & 
                  txanalogresetout[2] & txanalogresetout[3];

   assign rxdigitalresetout = {(HARD_RESET | rxdigitalreset[3]),
                   (HARD_RESET | rxdigitalreset[2]),
                   (HARD_RESET | rxdigitalreset[1]),
                   (HARD_RESET | rxdigitalreset[0])};

   assign txdigitalresetout = {(HARD_RESET | txdigitalreset[3]),
                   (HARD_RESET | txdigitalreset[2]),
                   (HARD_RESET | txdigitalreset[1]),
                   (HARD_RESET | txdigitalreset[0])};
         
endmodule // altgxb_reset_block
///////////////////////////////////////////////////////////////////////////////
//
//                           ALTGXB_XGM_INTERFACE
//
///////////////////////////////////////////////////////////////////////////////



//
// altgxb_xgm_interface
//

`timescale 1 ps/1 ps

module altgxb_xgm_interface
   (
    txdatain,
    txctrl,
    rdenablesync,
    txclk,
    rxdatain,
    rxctrl,
    rxrunningdisp,
    rxdatavalid,
    rxclk,
    resetall,
    adet,
    syncstatus,
    rdalign,
    recovclk,
    devpor,
    devclrn,
    txdataout,
    txctrlout,
    rxdataout,
    rxctrlout,
    resetout,
    alignstatus,
    enabledeskew,
    fiforesetrd,
    // PE ONLY PORTS
    scanclk, 
    scanin, 
    scanshift,
    scanmode,
    scanout,
    test,
    digitalsmtest,
    calibrationstatus,
    // MDIO PORTS
    mdiodisable,
    mdioclk,
    mdioin,
    rxppmselect,
    mdioout,
    mdiooe,
    // RESET PORTS
    txdigitalreset,
    rxdigitalreset,
    rxanalogreset,
    pllreset,
    pllenable,
    txdigitalresetout,
    rxdigitalresetout,   
    txanalogresetout,
    rxanalogresetout,
    pllresetout
    );

   parameter use_continuous_calibration_mode = "OFF";
   parameter mode_is_xaui = "OFF";
   parameter digital_test_output_select = 0;
   parameter analog_test_output_signal_select = 0;
   parameter analog_test_output_channel_select = 0;
   parameter rx_ppm_setting_0 = 0;
   parameter rx_ppm_setting_1 = 0;
   parameter use_rx_calibration_status = "OFF";
   parameter use_global_serial_loopback = "OFF";
   parameter rx_calibration_test_write_value = 0;
   parameter enable_rx_calibration_test_write = "OFF";
   parameter tx_calibration_test_write_value = 0;
   parameter enable_tx_calibration_test_write = "OFF";
      
   input [31 : 0] txdatain;
   input [3 : 0]  txctrl;
   input      rdenablesync;
   input      txclk;
   input [31 : 0] rxdatain;
   input [3 : 0]  rxctrl;
   input [3 : 0]  rxrunningdisp;
   input [3 : 0]  rxdatavalid;
   input      rxclk;
   input      resetall;
   input [3 : 0]  adet;
   input [3 : 0]  syncstatus;
   input [3 : 0]  rdalign;
   input      recovclk;
   input      devpor;
   input      devclrn;
   
   // RESET PORTS
   input [3:0]    txdigitalreset;
   input [3:0]    rxdigitalreset;
   input [3:0]    rxanalogreset;
   input      pllreset;
   input      pllenable;

   // NEW MDIO/PE ONLY PORTS
   input      mdioclk;
   input      mdiodisable;
   input      mdioin;
   input      rxppmselect;
   input      scanclk;
   input      scanin;
   input      scanmode;
   input      scanshift;
   
   output [31 : 0] txdataout;
   output [3 : 0]  txctrlout;
   output [31 : 0] rxdataout;
   output [3 : 0]  rxctrlout;
   output      resetout;
   output      alignstatus;
   output      enabledeskew;
   output      fiforesetrd;
   
   // RESET PORTS
   output [3:0]    txdigitalresetout;
   output [3:0]    rxdigitalresetout;   
   output [3:0]    txanalogresetout;
   output [3:0]    rxanalogresetout;
   output      pllresetout;

   // NEW MDIO/PE ONLY PORTS
   output [4:0]    calibrationstatus;
   output [3:0]    digitalsmtest;
   output      mdiooe;
   output      mdioout;
   output      scanout;
   output      test;

// wire declarations
wire txdatain_in0;
wire txdatain_in1;
wire txdatain_in2;
wire txdatain_in3;
wire txdatain_in4;
wire txdatain_in5;
wire txdatain_in6;
wire txdatain_in7;
wire txdatain_in8;
wire txdatain_in9;
wire txdatain_in10;
wire txdatain_in11;
wire txdatain_in12;
wire txdatain_in13;
wire txdatain_in14;
wire txdatain_in15;
wire txdatain_in16;
wire txdatain_in17;
wire txdatain_in18;
wire txdatain_in19;
wire txdatain_in20;
wire txdatain_in21;
wire txdatain_in22;
wire txdatain_in23;
wire txdatain_in24;
wire txdatain_in25;
wire txdatain_in26;
wire txdatain_in27;
wire txdatain_in28;
wire txdatain_in29;
wire txdatain_in30;
wire txdatain_in31;
wire rxdatain_in0;
wire rxdatain_in1;
wire rxdatain_in2;
wire rxdatain_in3;
wire rxdatain_in4;
wire rxdatain_in5;
wire rxdatain_in6;
wire rxdatain_in7;
wire rxdatain_in8;
wire rxdatain_in9;
wire rxdatain_in10;
wire rxdatain_in11;
wire rxdatain_in12;
wire rxdatain_in13;
wire rxdatain_in14;
wire rxdatain_in15;
wire rxdatain_in16;
wire rxdatain_in17;
wire rxdatain_in18;
wire rxdatain_in19;
wire rxdatain_in20;
wire rxdatain_in21;
wire rxdatain_in22;
wire rxdatain_in23;
wire rxdatain_in24;
wire rxdatain_in25;
wire rxdatain_in26;
wire rxdatain_in27;
wire rxdatain_in28;
wire rxdatain_in29;
wire rxdatain_in30;
wire rxdatain_in31;
wire txctrl_in0;
wire txctrl_in1;
wire txctrl_in2;
wire txctrl_in3;
wire rxctrl_in0;
wire rxctrl_in1;
wire rxctrl_in2;
wire rxctrl_in3;
wire txclk_in;
wire rxclk_in;
wire recovclk_in;
wire rdenablesync_in;
wire resetall_in;
wire rxrunningdisp_in0;
wire rxrunningdisp_in1;
wire rxrunningdisp_in2;
wire rxrunningdisp_in3;
wire rxdatavalid_in0;
wire rxdatavalid_in1;
wire rxdatavalid_in2;
wire rxdatavalid_in3;
wire adet_in0;
wire adet_in1;
wire adet_in2;
wire adet_in3;
wire syncstatus_in0;
wire syncstatus_in1;
wire syncstatus_in2;
wire syncstatus_in3;
wire rdalign_in0;
wire rdalign_in1;
wire rdalign_in2;
wire rdalign_in3;

// input buffers
buf(txdatain_in0, txdatain[0]);
buf(txdatain_in1, txdatain[1]);
buf(txdatain_in2, txdatain[2]);
buf(txdatain_in3, txdatain[3]);
buf(txdatain_in4, txdatain[4]);
buf(txdatain_in5, txdatain[5]);
buf(txdatain_in6, txdatain[6]);
buf(txdatain_in7, txdatain[7]);
buf(txdatain_in8, txdatain[8]);
buf(txdatain_in9, txdatain[9]);
buf(txdatain_in10, txdatain[10]);
buf(txdatain_in11, txdatain[11]);
buf(txdatain_in12, txdatain[12]);
buf(txdatain_in13, txdatain[13]);
buf(txdatain_in14, txdatain[14]);
buf(txdatain_in15, txdatain[15]);
buf(txdatain_in16, txdatain[16]);
buf(txdatain_in17, txdatain[17]);
buf(txdatain_in18, txdatain[18]);
buf(txdatain_in19, txdatain[19]);
buf(txdatain_in20, txdatain[20]);
buf(txdatain_in21, txdatain[21]);
buf(txdatain_in22, txdatain[22]);
buf(txdatain_in23, txdatain[23]);
buf(txdatain_in24, txdatain[24]);
buf(txdatain_in25, txdatain[25]);
buf(txdatain_in26, txdatain[26]);
buf(txdatain_in27, txdatain[27]);
buf(txdatain_in28, txdatain[28]);
buf(txdatain_in29, txdatain[29]);
buf(txdatain_in30, txdatain[30]);
buf(txdatain_in31, txdatain[31]);

buf(rxdatain_in0, rxdatain[0]);
buf(rxdatain_in1, rxdatain[1]);
buf(rxdatain_in2, rxdatain[2]);
buf(rxdatain_in3, rxdatain[3]);
buf(rxdatain_in4, rxdatain[4]);
buf(rxdatain_in5, rxdatain[5]);
buf(rxdatain_in6, rxdatain[6]);
buf(rxdatain_in7, rxdatain[7]);
buf(rxdatain_in8, rxdatain[8]);
buf(rxdatain_in9, rxdatain[9]);
buf(rxdatain_in10, rxdatain[10]);
buf(rxdatain_in11, rxdatain[11]);
buf(rxdatain_in12, rxdatain[12]);
buf(rxdatain_in13, rxdatain[13]);
buf(rxdatain_in14, rxdatain[14]);
buf(rxdatain_in15, rxdatain[15]);
buf(rxdatain_in16, rxdatain[16]);
buf(rxdatain_in17, rxdatain[17]);
buf(rxdatain_in18, rxdatain[18]);
buf(rxdatain_in19, rxdatain[19]);
buf(rxdatain_in20, rxdatain[20]);
buf(rxdatain_in21, rxdatain[21]);
buf(rxdatain_in22, rxdatain[22]);
buf(rxdatain_in23, rxdatain[23]);
buf(rxdatain_in24, rxdatain[24]);
buf(rxdatain_in25, rxdatain[25]);
buf(rxdatain_in26, rxdatain[26]);
buf(rxdatain_in27, rxdatain[27]);
buf(rxdatain_in28, rxdatain[28]);
buf(rxdatain_in29, rxdatain[29]);
buf(rxdatain_in30, rxdatain[30]);
buf(rxdatain_in31, rxdatain[31]);

buf(txctrl_in0, txctrl[0]);
buf(txctrl_in1, txctrl[1]);
buf(txctrl_in2, txctrl[2]);
buf(txctrl_in3, txctrl[3]);

buf(rxctrl_in0, rxctrl[0]);
buf(rxctrl_in1, rxctrl[1]);
buf(rxctrl_in2, rxctrl[2]);
buf(rxctrl_in3, rxctrl[3]);

buf(txclk_in, txclk);
buf(rxclk_in, rxclk);
buf(recovclk_in, recovclk);

buf (rdenablesync_in, rdenablesync);
buf (resetall_in, resetall);

buf(rxrunningdisp_in0, rxrunningdisp[0]);
buf(rxrunningdisp_in1, rxrunningdisp[1]);
buf(rxrunningdisp_in2, rxrunningdisp[2]);
buf(rxrunningdisp_in3, rxrunningdisp[3]);

buf(rxdatavalid_in0, rxdatavalid[0]);
buf(rxdatavalid_in1, rxdatavalid[1]);
buf(rxdatavalid_in2, rxdatavalid[2]);
buf(rxdatavalid_in3, rxdatavalid[3]);

buf(adet_in0, adet[0]);
buf(adet_in1, adet[1]);
buf(adet_in2, adet[2]);
buf(adet_in3, adet[3]);

buf(syncstatus_in0, syncstatus[0]);
buf(syncstatus_in1, syncstatus[1]);
buf(syncstatus_in2, syncstatus[2]);
buf(syncstatus_in3, syncstatus[3]);

buf(rdalign_in0, rdalign[0]);
buf(rdalign_in1, rdalign[1]);
buf(rdalign_in2, rdalign[2]);
buf(rdalign_in3, rdalign[3]);

// internal input signals
wire reset_int;

assign reset_int = resetall_in;

// internal data bus
wire [31 : 0] txdatain_in;
wire [31 : 0] rxdatain_in;
wire [3 : 0] txctrl_in;
wire [3 : 0] rxctrl_in;
wire [3 : 0] rxrunningdisp_in;
wire [3 : 0] rxdatavalid_in;
wire [3 : 0] adet_in;
wire [3 : 0] syncstatus_in;
wire [3 : 0] rdalign_in;

assign txdatain_in = {
                            txdatain_in31, txdatain_in30, txdatain_in29,
                            txdatain_in28, txdatain_in27, txdatain_in26,
                            txdatain_in25, txdatain_in24, txdatain_in23,
                            txdatain_in22, txdatain_in21, txdatain_in20,
                            txdatain_in19, txdatain_in18, txdatain_in17,
                            txdatain_in16, txdatain_in15, txdatain_in14,
                            txdatain_in13, txdatain_in12, txdatain_in11,
                            txdatain_in10, txdatain_in9, txdatain_in8,
                            txdatain_in7, txdatain_in6, txdatain_in5,
                            txdatain_in4, txdatain_in3, txdatain_in2,
                            txdatain_in1, txdatain_in0
                            };
                            
assign rxdatain_in = {
                            rxdatain_in31, rxdatain_in30, rxdatain_in29,
                            rxdatain_in28, rxdatain_in27, rxdatain_in26,
                            rxdatain_in25, rxdatain_in24, rxdatain_in23,
                            rxdatain_in22, rxdatain_in21, rxdatain_in20,
                            rxdatain_in19, rxdatain_in18, rxdatain_in17,
                            rxdatain_in16, rxdatain_in15, rxdatain_in14,
                            rxdatain_in13, rxdatain_in12, rxdatain_in11,
                            rxdatain_in10, rxdatain_in9, rxdatain_in8,
                            rxdatain_in7, rxdatain_in6, rxdatain_in5,
                            rxdatain_in4, rxdatain_in3, rxdatain_in2,
                            rxdatain_in1, rxdatain_in0
                            };
                            
assign txctrl_in = {txctrl_in3, txctrl_in2, txctrl_in1, txctrl_in0};
assign rxctrl_in = {rxctrl_in3, rxctrl_in2, rxctrl_in1, rxctrl_in0};

assign rxrunningdisp_in = {rxrunningdisp_in3, rxrunningdisp_in2, 
                                    rxrunningdisp_in1, rxrunningdisp_in0};

assign rxdatavalid_in = {rxdatavalid_in3, rxdatavalid_in2, 
                                rxdatavalid_in1, rxdatavalid_in0};

assign adet_in = {adet_in3, adet_in2, adet_in1, adet_in0};

assign syncstatus_in = {syncstatus_in3, syncstatus_in2, 
                                syncstatus_in1, syncstatus_in0};

assign rdalign_in = {rdalign_in3, rdalign_in2, 
                            rdalign_in1, rdalign_in0};

// internal output signals
wire resetout_tmp;

assign resetout_tmp = resetall_in;

// adding devpor and devclrn - do not merge to MF models
wire extended_pllreset;
assign extended_pllreset = pllreset || (!devpor) || (!devclrn);

   altgxb_xgm_reset_block altgxb_reset
      (
       .txdigitalreset(txdigitalreset),
       .rxdigitalreset(rxdigitalreset),
       .rxanalogreset(rxanalogreset),
       .pllreset(extended_pllreset),
       .pllenable(pllenable),
       .txdigitalresetout(txdigitalresetout),
       .rxdigitalresetout(rxdigitalresetout),
       .txanalogresetout(txanalogresetout),
       .rxanalogresetout(rxanalogresetout),
       .pllresetout(pllresetout)
       );

   altgxb_xgm_rx_sm s_xgm_rx_sm 
      (
       .rxdatain(rxdatain_in),
       .rxctrl(rxctrl_in),
       .rxrunningdisp(rxrunningdisp_in),
       .rxdatavalid(rxdatavalid_in),
       .rxclk(rxclk_in),
       .resetall(rxdigitalresetout[0]),
       .rxdataout(rxdataout),
       .rxctrlout(rxctrlout)
       );
   
   altgxb_xgm_tx_sm s_xgm_tx_sm 
      (
       .txdatain(txdatain_in),
       .txctrl(txctrl_in),
       .rdenablesync(rdenablesync_in),
       .txclk(txclk_in),
       .resetall(txdigitalresetout[0]),
       .txdataout(txdataout),
       .txctrlout(txctrlout)
       );
   
   altgxb_xgm_dskw_sm s_xgm_dskw_sm 
      (
       .resetall(rxdigitalresetout[0]),
       .adet(adet_in),
       .syncstatus(syncstatus_in),
       .rdalign(rdalign_in),
       .recovclk(recovclk_in),
       .alignstatus(alignstatus),
       .enabledeskew(enabledeskew),
       .fiforesetrd(fiforesetrd)
       );
   
   and (resetout, resetout_tmp,  1'b1);
   
endmodule

///////////////////////////////////////////////////////////////////////////////
//
//                               ALTGXB_TX_CORE
//
///////////////////////////////////////////////////////////////////////////////
   
`timescale 10 ps / 1 ps
module altgxb_tx_core 
   (
    reset,
    datain,
    writeclk,
    readclk,
    ctrlena,
    forcedisp,
    dataout,
    forcedispout,
    ctrlenaout,
    rdenasync,
    xgmctrlena,
    xgmdataout,
    pre8b10bdataout
    );

   parameter use_double_data_mode = "OFF";    
   parameter use_fifo_mode        = "ON";
   parameter transmit_protocol    = "NONE";
   parameter channel_width        = 10;
   parameter KCHAR  = 1'b0; // enable control char 
   parameter ECHAR  = 1'b0; // enable error char

   input reset;
   input [19:0] datain;
   input writeclk;
   input readclk;
   input [1:0] ctrlena;
   input [1:0] forcedisp;
   
   output      forcedispout;
   output      ctrlenaout;
   output      rdenasync;
   output      xgmctrlena;
   output [9:0] dataout;
   output [7:0] xgmdataout;
   output [9:0] pre8b10bdataout;
   
   reg      kchar_sync_1;
   reg      kchar_sync;
   reg      echar_sync_1;
   reg      echar_sync;
   reg [11:0]   datain_high;
   reg [11:0]   datain_low;
   reg [11:0]   fifo_high_tmp;
   reg [11:0]   fifo_high_dly1;
   reg [11:0]   fifo_high_dly2;
   reg [11:0]   fifo_high_dly3;
   reg [11:0]   fifo_low_tmp;
   reg [11:0]   fifo_low_dly1;
   reg [11:0]   fifo_low_dly2;
   reg [11:0]   fifo_low_dly3;
   reg      wr_enable;
   reg      rd_enable_sync_1;
   reg      rd_enable_sync_2; 
   reg      rd_enable_sync_out;
   reg      fifo_select_out;
   wire     rdenasync_tmp; 

   reg      writeclk_dly; 
   reg [11:0]   dataout_read;

   wire     out_ena1;
   wire     out_ena2;
   wire     out_ena3;
   wire     out_ena4;
   wire     out_ena5;
   wire     doublewidth;
   wire     disablefifo;
   wire     individual;

   assign doublewidth = (use_double_data_mode == "ON") ? 1'b1 : 1'b0;
   assign disablefifo = (use_fifo_mode == "OFF") ? 1'b1 : 1'b0;
   assign individual  = (transmit_protocol != "XAUI") ? 1'b1 : 1'b0;

   always @ (writeclk)
     begin
       writeclk_dly <= writeclk;
     end

   // READ CLOCK SYNC LOGIC
   always @ (posedge reset or posedge readclk)
      begin
     if (reset)
        begin
           kchar_sync_1 <= 1'b0;
           kchar_sync   <= 1'b0;
           echar_sync_1 <= 1'b0;
           echar_sync   <= 1'b0;
        end
     else
        begin
           kchar_sync_1 <= KCHAR;
           kchar_sync   <= kchar_sync_1;
           echar_sync_1 <= ECHAR;
           echar_sync   <= echar_sync_1;
        end
      end
   
   assign dataout         = dataout_read[9:0];
   assign xgmdataout      = dataout_read[7:0];
   assign pre8b10bdataout = dataout_read[9:0];

   assign forcedispout    = dataout_read[10];
   assign ctrlenaout      = dataout_read[11];
   assign xgmctrlena      = dataout_read[11];

   assign rdenasync       = rdenasync_tmp;
      
   always @ (reset or writeclk_dly or datain or forcedisp or ctrlena)
   begin
     if (reset)
       begin
          datain_high[11:0]   <= 'b0;
          datain_low[11:0]   <= 'b0;
       end
     else
       begin
          if (channel_width == 10 || channel_width == 20)
            begin
              if (doublewidth)
                datain_high[11:0] <= {ctrlena[1], forcedisp[1], datain[19:10]};
              else
                datain_high[11:0] <= {ctrlena[0], forcedisp[0], datain[9:0]};
           
              datain_low[11:0] <= {ctrlena[0], forcedisp[0], datain[9:0]};
            end
          else
            begin
              if (doublewidth)
                datain_high[11:0] <= {ctrlena[1], forcedisp[1], 2'b00, datain[15:8]};
              else
                datain_high[11:0] <= {ctrlena[0], forcedisp[0], 2'b00, datain[7:0]};
           
             datain_low[11:0] <= {ctrlena[0], forcedisp[0], 2'b00, datain[7:0]};
            end

       end
   end
   
   // FIFO FOR HIGH BITS
   always @ (posedge reset or posedge writeclk_dly)
      begin
     if (reset)
        begin
           fifo_high_dly1 <= 10'b0;
           fifo_high_dly2 <= 10'b0;
           fifo_high_dly3 <= 10'b0;
           fifo_high_tmp  <= 10'b0;
        end
     else
        begin
           fifo_high_dly1 <= datain_high;
           fifo_high_dly2 <= fifo_high_dly1;
           fifo_high_dly3 <= fifo_high_dly2;
           fifo_high_tmp  <= fifo_high_dly3;
        end
      end 

   // FIFO FOR LOWER BITS
   always @ (posedge reset or posedge writeclk_dly)
      begin
     if (reset)
        begin
           fifo_low_dly1 <= 'b0;
           fifo_low_dly2 <= 'b0;
           fifo_low_dly3 <= 'b0;
           fifo_low_tmp  <= 'b0;
        end
     else
        begin
           fifo_low_dly1 <= datain_low;
           fifo_low_dly2 <= fifo_low_dly1;
           fifo_low_dly3 <= fifo_low_dly2;
           fifo_low_tmp  <= fifo_low_dly3;
        end
      end 

   // DATAOUT ENABLE LOGIC
   assign out_ena1 = (~disablefifo & rdenasync_tmp & (~doublewidth | fifo_select_out) & ~kchar_sync & ~echar_sync);
   assign out_ena2 = (~disablefifo & rdenasync_tmp & (doublewidth & ~fifo_select_out) & ~kchar_sync & ~echar_sync);
   assign out_ena3 = (disablefifo & (~doublewidth | ~fifo_select_out) & ~kchar_sync & ~echar_sync);
   assign out_ena4 = (~kchar_sync & echar_sync);
   assign out_ena5 = (disablefifo & doublewidth & fifo_select_out & ~kchar_sync & ~echar_sync);
   
   // Dataout, CTRL, FORCE_DISP registered by read clock
   always @ (posedge reset or posedge readclk)
     begin
     if (reset)
         dataout_read      <= 'b0;
     else
       begin
       if (out_ena1)
         dataout_read <= fifo_low_tmp;
       else if (out_ena2)
         dataout_read <= fifo_high_tmp;
       else if (out_ena3)
         dataout_read <= datain_low;         
       else if (out_ena4)
         begin
           dataout_read[7:0] <= 8'b11111110;
           dataout_read[10] <= 1'b0;
           dataout_read[11] <= 1'b1;
         end
       else if (out_ena5)
         begin
           dataout_read <= datain_high;
         end
       else 
         begin
           dataout_read[10] <= 1'b0;
           dataout_read[11] <= 1'b1;  // fixed from 3.0
           if (~individual)
             dataout_read[7:0] <= 8'b00000111; 
           else
             dataout_read[7:0] <= 8'b10111100;
         end
         
       end // end of not reset
     end // end of always


   // fifo_select_out == 1: send out low byte

   always @(posedge reset or writeclk_dly)
     begin
       if (reset | writeclk_dly)
         fifo_select_out  <= 1'b1;
       else
         fifo_select_out  <= 1'b0;
       end

   // Delay chains on RD_ENA 
   always @(posedge reset or posedge readclk)
     begin
    if (reset)
      begin
         rd_enable_sync_1 <= 1'b0;
         rd_enable_sync_2 <= 1'b0;
         rd_enable_sync_out <= 1'b0;
      end
    else
      begin
         rd_enable_sync_1 <= wr_enable | disablefifo;
         rd_enable_sync_2 <= rd_enable_sync_1;
         rd_enable_sync_out <= rd_enable_sync_2;
      end
     end
   
   always @ (posedge reset or posedge writeclk_dly)
     begin
    if (reset)
      wr_enable <= 1'b0;
    else
      wr_enable <= 1'b1;
     end

   assign rdenasync_tmp  = (individual)? rd_enable_sync_out : rd_enable_sync_1;
   
endmodule // altgxb_tx_core

//
// ALTGXB_HSSI_TX_SERDES
//

`timescale 1 ps/1 ps

module altgxb_hssi_tx_serdes
    (
        clk, 
        clk1, 
        datain, 
        serialdatain, 
        srlpbk, 
        areset, 
        dataout 
    );

input [9:0] datain;
input clk; // fast clock
input clk1; //slow clock
input   serialdatain;
input   srlpbk;
input areset;

output dataout;

parameter channel_width = 10;

integer i;
integer pclk_count;
integer shift_edge;
reg dataout_tmp;
reg [9:0] regdata;
reg [9:0] shiftdata;

reg clk_dly;
reg clk1_dly;

wire datain_in0,datain_in1,datain_in2,datain_in3,datain_in4;
wire datain_in5,datain_in6,datain_in7,datain_in8,datain_in9;

buf (datain_in0, datain[0]);
buf (datain_in1, datain[1]);
buf (datain_in2, datain[2]);
buf (datain_in3, datain[3]);
buf (datain_in4, datain[4]);
buf (datain_in5, datain[5]);
buf (datain_in6, datain[6]);
buf (datain_in7, datain[7]);
buf (datain_in8, datain[8]);
buf (datain_in9, datain[9]);

initial
begin
   i = 0;
   pclk_count = 0;
   shift_edge = channel_width/2;
   dataout_tmp = 1'bX;
    for (i = 9; i >= 0; i = i - 1) 
    begin
        regdata[i] = 1'bZ;
        shiftdata[i] = 1'bZ;
    end
end

always @(clk or clk1)
begin
   clk_dly <= clk;
   clk1_dly = clk1;
end

always @(clk_dly or areset)
begin
    if (areset == 1'b1)
      dataout_tmp = 1'bZ;
   else 
   begin // dataout comes out on both edges 
      //load on the first fast clk after slow clk to avoid race condition
      if (pclk_count == 1)
      begin
            regdata[0] = datain_in9; 
          regdata[1] = datain_in8; 
          regdata[2] = datain_in7; 
          regdata[3] = datain_in6; 
          regdata[4] = datain_in5; 
          regdata[5] = datain_in4; 
          regdata[6] = datain_in3; 
          regdata[7] = datain_in2; 
          regdata[8] = datain_in1; 
          regdata[9] = datain_in0; 
      end

      if (clk == 1'b1) // rising edge
      begin
         pclk_count = pclk_count + 1;

         // loading edge
         if (pclk_count == shift_edge) 
            shiftdata = regdata;
      end

        if (srlpbk == 1'b1)
        dataout_tmp = serialdatain;
        else
        dataout_tmp = shiftdata[9];

      for (i = 9; i > (10 - channel_width); i = i - 1)
            shiftdata[i] = shiftdata[i-1];
    end
end

always @(posedge clk1_dly or areset)
begin
    if (areset == 1'b1)
   begin
    for (i = 9; i >= 0; i = i - 1) 
        begin
            regdata[i] = 1'bZ;
            shiftdata[i] = 1'bZ;
        end
   end
   else 
      begin
         pclk_count = 0;
        end
end

and (dataout, dataout_tmp,  1'b1);

endmodule
//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 83 mux21 46 oper_decoder 1 oper_selector 10 
`timescale 1 ps / 1 ps
module  altgxb_hssi_tx_enc_rtl
	( 
	ENDEC,
	GE_XAUI_SEL,
	IB_FORCE_DISPARITY,
	INDV,
	prbs_en,
	PUDR,
	soft_reset,
	tx_clk,
	tx_ctl_tc,
	tx_ctl_ts,
	tx_data_9_tc,
	tx_data_pg,
	tx_data_tc,
	tx_data_ts,
	TXLP10B) /* synthesis synthesis_clearbox=1 */;
	input   ENDEC;
	input   GE_XAUI_SEL;
	input   IB_FORCE_DISPARITY;
	input   INDV;
	input   prbs_en;
	output   [9:0]  PUDR;
	input   soft_reset;
	input   tx_clk;
	input   tx_ctl_tc;
	input   tx_ctl_ts;
	input   tx_data_9_tc;
	input   [9:0]  tx_data_pg;
	input   [7:0]  tx_data_tc;
	input   [7:0]  tx_data_ts;
	output   [9:0]  TXLP10B;

	reg	n100i43;
	reg	n100i44;
	reg	n100i45;
	reg	n100O40;
	reg	n100O41;
	reg	n100O42;
	reg	n101i49;
	reg	n101i50;
	reg	n101i51;
	reg	n101l46;
	reg	n101l47;
	reg	n101l48;
	reg	n10ii37;
	reg	n10ii38;
	reg	n10ii39;
	reg	n10il34;
	reg	n10il35;
	reg	n10il36;
	reg	n10li31;
	reg	n10li32;
	reg	n10li33;
	reg	n11Oi58;
	reg	n11Oi59;
	reg	n11Oi60;
	reg	n11Ol55;
	reg	n11Ol56;
	reg	n11Ol57;
	reg	n11OO52;
	reg	n11OO53;
	reg	n11OO54;
	reg	n1i0l22;
	reg	n1i0l23;
	reg	n1i0l24;
	reg	n1i1i28;
	reg	n1i1i29;
	reg	n1i1i30;
	reg	n1i1O25;
	reg	n1i1O26;
	reg	n1i1O27;
	reg	n1iil19;
	reg	n1iil20;
	reg	n1iil21;
	reg	n1ili16;
	reg	n1ili17;
	reg	n1ili18;
	reg	n1ilO13;
	reg	n1ilO14;
	reg	n1ilO15;
	reg	n1iOl10;
	reg	n1iOl11;
	reg	n1iOl12;
	reg	n1l0l1;
	reg	n1l0l2;
	reg	n1l0l3;
	reg	n1l1i7;
	reg	n1l1i8;
	reg	n1l1i9;
	reg	n1l1O4;
	reg	n1l1O5;
	reg	n1l1O6;
	reg	n00i;
	reg	n00l;
	reg	n00O;
	reg	n01i;
	reg	n01l;
	reg	n01O;
	reg	n0ii;
	reg	n0il;
	reg	n0li;
	reg	n10O;
	reg	n1iO;
	reg	n1li;
	reg	n1ll;
	reg	n1lO;
	reg	n1OO;
	reg	nlOil;
	reg	n1il;
	wire	wire_n1ii_ENA;
	reg	nlO0i;
	reg	nlO0l;
	reg	nlO1i;
	reg	nlO1l;
	reg	nlO1O;
	reg	nlOii;
	wire	wire_n0i_dataout;
	wire	wire_n0i0O_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0lii_dataout;
	wire	wire_n0lil_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0lli_dataout;
	wire	wire_n0lll_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1ii_dataout;
	wire	wire_ni1il_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1Ol_dataout;
	wire	wire_niii_dataout;
	wire	wire_niil_dataout;
	wire	wire_niiO_dataout;
	wire	wire_nili_dataout;
	wire	wire_nill_dataout;
	wire	wire_nillO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilOO_dataout;
	wire	wire_niO0l_dataout;
	wire	wire_niO1i_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOii_dataout;
	wire	wire_niOil_dataout;
	wire	wire_niOiO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOli_dataout;
	wire	wire_niOll_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nlii_dataout;
	wire  [3:0]   wire_n10l_o;
	wire  wire_n11i_o;
	wire  wire_n11l_o;
	wire  wire_n11O_o;
	wire  wire_nlOiO_o;
	wire  wire_nlOli_o;
	wire  wire_nlOll_o;
	wire  wire_nlOlO_o;
	wire  wire_nlOOi_o;
	wire  wire_nlOOl_o;
	wire  wire_nlOOO_o;
	wire  n101O;
	wire  n10lO;
	wire  n10Oi;
	wire  n10Ol;
	wire  n10OO;
	wire  n110i;
	wire  n110l;
	wire  n110O;
	wire  n111i;
	wire  n111l;
	wire  n111O;
	wire  n11ii;
	wire  n11il;
	wire  n11iO;
	wire  n11li;
	wire  n11ll;
	wire  n11lO;
	wire  n1iii;
	wire  n1lii;
	wire  n1lil;
	wire  nlOO0i;
	wire  nlOO0l;
	wire  nlOO0O;
	wire  nlOO1O;
	wire  nlOOii;
	wire  nlOOil;
	wire  nlOOiO;
	wire  nlOOli;
	wire  nlOOll;
	wire  nlOOlO;
	wire  nlOOOi;
	wire  nlOOOl;
	wire  nlOOOO;

	initial
		n100i43 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n100i43 <= n100i45;
	initial
		n100i44 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n100i44 <= (n100i45 ^ n100i43);
	initial
		n100i45 = 0;
	always @ ( posedge tx_clk)
		  n100i45 <= n100i43;
	initial
		n100O40 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n100O40 <= n100O42;
	initial
		n100O41 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n100O41 <= (n100O42 ^ n100O40);
	initial
		n100O42 = 0;
	always @ ( posedge tx_clk)
		  n100O42 <= n100O40;
	initial
		n101i49 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n101i49 <= n101i51;
	initial
		n101i50 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n101i50 <= (n101i51 ^ n101i49);
	initial
		n101i51 = 0;
	always @ ( posedge tx_clk)
		  n101i51 <= n101i49;
	initial
		n101l46 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n101l46 <= n101l48;
	initial
		n101l47 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n101l47 <= (n101l48 ^ n101l46);
	initial
		n101l48 = 0;
	always @ ( posedge tx_clk)
		  n101l48 <= n101l46;
	initial
		n10ii37 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n10ii37 <= n10ii39;
	initial
		n10ii38 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n10ii38 <= (n10ii39 ^ n10ii37);
	initial
		n10ii39 = 0;
	always @ ( posedge tx_clk)
		  n10ii39 <= n10ii37;
	initial
		n10il34 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n10il34 <= n10il36;
	initial
		n10il35 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n10il35 <= (n10il36 ^ n10il34);
	initial
		n10il36 = 0;
	always @ ( posedge tx_clk)
		  n10il36 <= n10il34;
	initial
		n10li31 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n10li31 <= n10li33;
	initial
		n10li32 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n10li32 <= (n10li33 ^ n10li31);
	initial
		n10li33 = 0;
	always @ ( posedge tx_clk)
		  n10li33 <= n10li31;
	initial
		n11Oi58 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n11Oi58 <= n11Oi60;
	initial
		n11Oi59 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n11Oi59 <= (n11Oi60 ^ n11Oi58);
	initial
		n11Oi60 = 0;
	always @ ( posedge tx_clk)
		  n11Oi60 <= n11Oi58;
	initial
		n11Ol55 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n11Ol55 <= n11Ol57;
	initial
		n11Ol56 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n11Ol56 <= (n11Ol57 ^ n11Ol55);
	initial
		n11Ol57 = 0;
	always @ ( posedge tx_clk)
		  n11Ol57 <= n11Ol55;
	initial
		n11OO52 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n11OO52 <= n11OO54;
	initial
		n11OO53 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n11OO53 <= (n11OO54 ^ n11OO52);
	initial
		n11OO54 = 0;
	always @ ( posedge tx_clk)
		  n11OO54 <= n11OO52;
	initial
		n1i0l22 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1i0l22 <= n1i0l24;
	initial
		n1i0l23 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1i0l23 <= (n1i0l24 ^ n1i0l22);
	initial
		n1i0l24 = 0;
	always @ ( posedge tx_clk)
		  n1i0l24 <= n1i0l22;
	initial
		n1i1i28 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1i1i28 <= n1i1i30;
	initial
		n1i1i29 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1i1i29 <= (n1i1i30 ^ n1i1i28);
	initial
		n1i1i30 = 0;
	always @ ( posedge tx_clk)
		  n1i1i30 <= n1i1i28;
	initial
		n1i1O25 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1i1O25 <= n1i1O27;
	initial
		n1i1O26 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1i1O26 <= (n1i1O27 ^ n1i1O25);
	initial
		n1i1O27 = 0;
	always @ ( posedge tx_clk)
		  n1i1O27 <= n1i1O25;
	initial
		n1iil19 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1iil19 <= n1iil21;
	initial
		n1iil20 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1iil20 <= (n1iil21 ^ n1iil19);
	initial
		n1iil21 = 0;
	always @ ( posedge tx_clk)
		  n1iil21 <= n1iil19;
	initial
		n1ili16 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1ili16 <= n1ili18;
	initial
		n1ili17 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1ili17 <= (n1ili18 ^ n1ili16);
	initial
		n1ili18 = 0;
	always @ ( posedge tx_clk)
		  n1ili18 <= n1ili16;
	initial
		n1ilO13 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1ilO13 <= n1ilO15;
	initial
		n1ilO14 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1ilO14 <= (n1ilO15 ^ n1ilO13);
	initial
		n1ilO15 = 0;
	always @ ( posedge tx_clk)
		  n1ilO15 <= n1ilO13;
	initial
		n1iOl10 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1iOl10 <= n1iOl12;
	initial
		n1iOl11 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1iOl11 <= (n1iOl12 ^ n1iOl10);
	initial
		n1iOl12 = 0;
	always @ ( posedge tx_clk)
		  n1iOl12 <= n1iOl10;
	initial
		n1l0l1 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1l0l1 <= n1l0l3;
	initial
		n1l0l2 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1l0l2 <= (n1l0l3 ^ n1l0l1);
	initial
		n1l0l3 = 0;
	always @ ( posedge tx_clk)
		  n1l0l3 <= n1l0l1;
	initial
		n1l1i7 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1l1i7 <= n1l1i9;
	initial
		n1l1i8 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1l1i8 <= (n1l1i9 ^ n1l1i7);
	initial
		n1l1i9 = 0;
	always @ ( posedge tx_clk)
		  n1l1i9 <= n1l1i7;
	initial
		n1l1O4 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1l1O4 <= n1l1O6;
	initial
		n1l1O5 = {1{1'b1}};
	always @ ( posedge tx_clk)
		  n1l1O5 <= (n1l1O6 ^ n1l1O4);
	initial
		n1l1O6 = 0;
	always @ ( posedge tx_clk)
		  n1l1O6 <= n1l1O4;
	initial
	begin
		n00i = 0;
		n00l = 0;
		n00O = 0;
		n01i = 0;
		n01l = 0;
		n01O = 0;
		n0ii = 0;
		n0il = 0;
		n0li = 0;
		n10O = 0;
		n1iO = 0;
		n1li = 0;
		n1ll = 0;
		n1lO = 0;
		n1OO = 0;
		nlOil = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n00i <= 0;
			n00l <= 0;
			n00O <= 0;
			n01i <= 0;
			n01l <= 0;
			n01O <= 0;
			n0ii <= 0;
			n0il <= 0;
			n0li <= 0;
			n10O <= 0;
			n1iO <= 0;
			n1li <= 0;
			n1ll <= 0;
			n1lO <= 0;
			n1OO <= 0;
			nlOil <= 0;
		end
		else 
		begin
			n00i <= wire_nlOlO_o;
			n00l <= wire_nlOOi_o;
			n00O <= wire_nlOOl_o;
			n01i <= wire_nlOiO_o;
			n01l <= wire_nlOli_o;
			n01O <= wire_nlOll_o;
			n0ii <= wire_nlOOO_o;
			n0il <= wire_n11i_o;
			n0li <= wire_n11l_o;
			n10O <= wire_nillO_dataout;
			n1iO <= n10lO;
			n1li <= wire_n0l0O_dataout;
			n1ll <= wire_n0lii_dataout;
			n1lO <= wire_niOiO_dataout;
			n1OO <= wire_niOll_dataout;
			nlOil <= wire_n11O_o;
		end
	end
	initial
	begin
		n1il = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1il <= 0;
		end
		else if  (wire_n1ii_ENA == 1'b1) 
		begin
			n1il <= n10Oi;
		end
	end
	assign
		wire_n1ii_ENA = (((~ n1il) & ((tx_data_9_tc & IB_FORCE_DISPARITY) & n10li32)) & n10il35);
	initial
	begin
		nlO0i = 0;
		nlO0l = 0;
		nlO1i = 0;
		nlO1l = 0;
		nlO1O = 0;
		nlOii = 0;
	end
	always @ ( posedge tx_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			nlO0i <= 1;
			nlO0l <= 1;
			nlO1i <= 1;
			nlO1l <= 1;
			nlO1O <= 1;
			nlOii <= 1;
		end
		else 
		begin
			nlO0i <= wire_n0lll_dataout;
			nlO0l <= wire_niOil_dataout;
			nlO1i <= wire_n0lil_dataout;
			nlO1l <= wire_n0liO_dataout;
			nlO1O <= wire_n0lli_dataout;
			nlOii <= wire_niOli_dataout;
		end
	end
	and(wire_n0i_dataout, wire_n0l_dataout, ~{((n10O & ((n1iO & (((~ tx_ctl_tc) & (GE_XAUI_SEL & ((~ n1lil) & (~ n1lii)))) & n1iOl11)) & n1ilO14)) & n1ili17)});
	assign		wire_n0i0O_dataout = ((nlOOil | (nlOOOO | (n111l | (wire_n0i_dataout | n111O)))) === 1'b1) ? (~ n10Ol) : n10Ol;
	and(wire_n0l_dataout, wire_n1O_dataout, ~{(((~ n10O) & (n1iO & (((~ tx_ctl_tc) & (GE_XAUI_SEL & (((~ n1lil) & (~ n1lii)) & n1l0l2))) & n1l1O5))) & n1l1i8)});
	assign		wire_n0l0O_dataout = (nlOOii === 1'b1) ? (~ wire_niii_dataout) : wire_niii_dataout;
	assign		wire_n0lii_dataout = (nlOOii === 1'b1) ? (~ wire_ni1Ol_dataout) : wire_ni1Ol_dataout;
	assign		wire_n0lil_dataout = (nlOOii === 1'b1) ? (~ wire_ni1il_dataout) : wire_ni1il_dataout;
	assign		wire_n0liO_dataout = (nlOOii === 1'b1) ? (~ wire_ni1ii_dataout) : wire_ni1ii_dataout;
	assign		wire_n0lli_dataout = (nlOOii === 1'b1) ? (~ nlOOOi) : nlOOOi;
	assign		wire_n0lll_dataout = (nlOOii === 1'b1) ? (~ nlOOli) : nlOOli;
	assign		wire_n0Ol_dataout = (INDV === 1'b1) ? tx_data_tc[0] : tx_data_ts[0];
	assign		wire_n0OO_dataout = (INDV === 1'b1) ? tx_data_tc[1] : tx_data_ts[1];
	assign		wire_n1O_dataout = (INDV === 1'b1) ? tx_ctl_tc : tx_ctl_ts;
	assign		wire_ni0i_dataout = (INDV === 1'b1) ? tx_data_tc[5] : tx_data_ts[5];
	assign		wire_ni0l_dataout = (INDV === 1'b1) ? tx_data_tc[6] : tx_data_ts[6];
	assign		wire_ni0O_dataout = (INDV === 1'b1) ? tx_data_tc[7] : tx_data_ts[7];
	assign		wire_ni1i_dataout = (INDV === 1'b1) ? tx_data_tc[2] : tx_data_ts[2];
	assign		wire_ni1ii_dataout = (n111l === 1'b1) ? (~ wire_nili_dataout) : wire_nili_dataout;
	assign		wire_ni1il_dataout = ((n111O | (wire_nill_dataout & (wire_nili_dataout & ((~ wire_niiO_dataout) & ((~ wire_niii_dataout) & (~ wire_niil_dataout)))))) === 1'b1) ? (~ wire_niiO_dataout) : wire_niiO_dataout;
	assign		wire_ni1l_dataout = (INDV === 1'b1) ? tx_data_tc[3] : tx_data_ts[3];
	assign		wire_ni1O_dataout = (INDV === 1'b1) ? tx_data_tc[4] : tx_data_ts[4];
	assign		wire_ni1Ol_dataout = (n110i === 1'b1) ? (~ wire_niil_dataout) : wire_niil_dataout;
	and(wire_niii_dataout, wire_niOO_dataout, ~{n1iii});
	and(wire_niil_dataout, wire_nl1i_dataout, ~{n1iii});
	and(wire_niiO_dataout, wire_nl1l_dataout, ~{n1iii});
	and(wire_nili_dataout, wire_nl1O_dataout, ~{n1iii});
	or(wire_nill_dataout, wire_nl0i_dataout, n1iii);
	assign		wire_nillO_dataout = ((n11ii | (wire_niOl_dataout & n11lO)) === 1'b1) ? (~ wire_n0i0O_dataout) : wire_n0i0O_dataout;
	and(wire_nilO_dataout, wire_nl0l_dataout, ~{n1iii});
	or(wire_nilOO_dataout, wire_niO1i_dataout, n11iO);
	assign		wire_niO0l_dataout = (n11ii === 1'b1) ? (~ wire_niOi_dataout) : wire_niOi_dataout;
	and(wire_niO1i_dataout, (~ n11lO), ~{wire_niOl_dataout});
	or(wire_niOi_dataout, wire_nl0O_dataout, n1iii);
	and(wire_niOii_dataout, wire_nilO_dataout, ~{n11iO});
	assign		wire_niOil_dataout = (n11li === 1'b1) ? (~ wire_niOii_dataout) : wire_niOii_dataout;
	assign		wire_niOiO_dataout = (n11li === 1'b1) ? (~ wire_niO0l_dataout) : wire_niO0l_dataout;
	and(wire_niOl_dataout, wire_nlii_dataout, ~{n1iii});
	assign		wire_niOli_dataout = (n11li === 1'b1) ? (~ wire_niOl_dataout) : wire_niOl_dataout;
	assign		wire_niOll_dataout = (n11li === 1'b1) ? (~ wire_nilOO_dataout) : wire_nilOO_dataout;
	or(wire_niOO_dataout, wire_n0Ol_dataout, n10OO);
	and(wire_nl0i_dataout, wire_ni1O_dataout, ~{n10OO});
	and(wire_nl0l_dataout, wire_ni0i_dataout, ~{n10OO});
	or(wire_nl0O_dataout, wire_ni0l_dataout, n10OO);
	and(wire_nl1i_dataout, wire_n0OO_dataout, ~{n10OO});
	or(wire_nl1l_dataout, wire_ni1i_dataout, n10OO);
	and(wire_nl1O_dataout, wire_ni1l_dataout, ~{n10OO});
	or(wire_nlii_dataout, wire_ni0O_dataout, n10OO);
	oper_decoder   n10l
	( 
	.i({(n100O41 & ENDEC), (n10ii38 & prbs_en)}),
	.o(wire_n10l_o));
	defparam
		n10l.width_i = 2,
		n10l.width_o = 4;
	oper_selector   n11i
	( 
	.data({tx_data_pg[7], n1lO, tx_data_tc[7]}),
	.o(wire_n11i_o),
	.sel({(n11OO53 & n101O), (n101i50 & wire_n10l_o[2]), wire_n10l_o[0]}));
	defparam
		n11i.width_data = 3,
		n11i.width_sel = 3;
	oper_selector   n11l
	( 
	.data({tx_data_pg[8], nlOii, tx_ctl_tc}),
	.o(wire_n11l_o),
	.sel({n101O, wire_n10l_o[2], wire_n10l_o[0]}));
	defparam
		n11l.width_data = 3,
		n11l.width_sel = 3;
	oper_selector   n11O
	( 
	.data({(n101l47 & tx_data_pg[9]), n1OO, tx_data_9_tc}),
	.o(wire_n11O_o),
	.sel({n101O, wire_n10l_o[2], wire_n10l_o[0]}));
	defparam
		n11O.width_data = 3,
		n11O.width_sel = 3;
	oper_selector   nlOiO
	( 
	.data({tx_data_pg[0], n1li, tx_data_tc[0]}),
	.o(wire_nlOiO_o),
	.sel({n101O, wire_n10l_o[2], wire_n10l_o[0]}));
	defparam
		nlOiO.width_data = 3,
		nlOiO.width_sel = 3;
	oper_selector   nlOli
	( 
	.data({tx_data_pg[1], n1ll, tx_data_tc[1]}),
	.o(wire_nlOli_o),
	.sel({n101O, wire_n10l_o[2], wire_n10l_o[0]}));
	defparam
		nlOli.width_data = 3,
		nlOli.width_sel = 3;
	oper_selector   nlOll
	( 
	.data({tx_data_pg[2], nlO1i, tx_data_tc[2]}),
	.o(wire_nlOll_o),
	.sel({n101O, wire_n10l_o[2], wire_n10l_o[0]}));
	defparam
		nlOll.width_data = 3,
		nlOll.width_sel = 3;
	oper_selector   nlOlO
	( 
	.data({tx_data_pg[3], nlO1l, tx_data_tc[3]}),
	.o(wire_nlOlO_o),
	.sel({n101O, wire_n10l_o[2], wire_n10l_o[0]}));
	defparam
		nlOlO.width_data = 3,
		nlOlO.width_sel = 3;
	oper_selector   nlOOi
	( 
	.data({tx_data_pg[4], nlO1O, tx_data_tc[4]}),
	.o(wire_nlOOi_o),
	.sel({n101O, wire_n10l_o[2], wire_n10l_o[0]}));
	defparam
		nlOOi.width_data = 3,
		nlOOi.width_sel = 3;
	oper_selector   nlOOl
	( 
	.data({tx_data_pg[5], nlO0i, tx_data_tc[5]}),
	.o(wire_nlOOl_o),
	.sel({n101O, wire_n10l_o[2], (n11Oi59 & wire_n10l_o[0])}));
	defparam
		nlOOl.width_data = 3,
		nlOOl.width_sel = 3;
	oper_selector   nlOOO
	( 
	.data({tx_data_pg[6], nlO0l, (n11Ol56 & tx_data_tc[6])}),
	.o(wire_nlOOO_o),
	.sel({n101O, wire_n10l_o[2], wire_n10l_o[0]}));
	defparam
		nlOOO.width_data = 3,
		nlOOO.width_sel = 3;
	assign
		n101O = ((wire_n10l_o[3] | wire_n10l_o[1]) | (~ n100i44)),
		n10lO = (((((((((~ tx_data_tc[0]) & (~ tx_data_tc[1])) & tx_data_tc[2]) & tx_data_tc[3]) & tx_data_tc[4]) & tx_data_tc[5]) & (~ tx_data_tc[6])) & tx_data_tc[7]) & tx_ctl_tc),
		n10Oi = 1'b1,
		n10Ol = (n10O | ((~ n1il) & (tx_data_9_tc & IB_FORCE_DISPARITY))),
		n10OO = (((~ n10O) & ((n1iO & ((~ tx_ctl_tc) & ((((~ n1lil) & (~ n1lii)) & n1i0l23) & GE_XAUI_SEL))) & n1i1O26)) & n1i1i29),
		n110i = (n111l | n111O),
		n110l = (wire_niii_dataout & wire_niil_dataout),
		n110O = ((~ wire_niii_dataout) & (~ wire_niil_dataout)),
		n111i = (((((~ wire_nili_dataout) & ((~ wire_niiO_dataout) & (wire_niii_dataout & (~ wire_niil_dataout)))) | ((~ wire_nili_dataout) & ((~ wire_niiO_dataout) & ((~ wire_niii_dataout) & wire_niil_dataout)))) | ((~ wire_nili_dataout) & (wire_niiO_dataout & nlOO0i))) | (wire_nili_dataout & ((~ wire_niiO_dataout) & nlOO0i))),
		n111l = (wire_nili_dataout & (wire_niiO_dataout & (wire_niii_dataout & wire_niil_dataout))),
		n111O = ((~ wire_nili_dataout) & ((~ wire_niiO_dataout) & ((~ wire_niii_dataout) & (~ wire_niil_dataout)))),
		n11ii = ((~ wire_niOl_dataout) & n11il),
		n11il = ((~ wire_nilO_dataout) & (~ wire_niOi_dataout)),
		n11iO = (wire_niOl_dataout & (wire_niOi_dataout & (wire_nilO_dataout & (((((((((~ wire_nili_dataout) & ((~ wire_niiO_dataout) & (wire_niii_dataout & (~ wire_niil_dataout)))) | ((~ wire_nili_dataout) & ((~ wire_niiO_dataout) & ((~ wire_niii_dataout) & wire_niil_dataout)))) | ((~ wire_nili_dataout) & (wire_niiO_dataout & n110O))) | (wire_nili_dataout & ((~ wire_niiO_dataout) & n110O))) & ((~ wire_nili_dataout) & wire_nill_dataout)) & (~ wire_n0i0O_dataout)) | (wire_n0i0O_dataout & ((((((~ wire_nili_dataout) & (wire_niiO_dataout & n110l)) | (wire_nili_dataout & ((~ wire_niiO_dataout) & n110l))) | (wire_nili_dataout & (wire_niiO_dataout & (wire_niii_dataout & (~ wire_niil_dataout))))) | (wire_nili_dataout & (wire_niiO_dataout & ((~ wire_niii_dataout) & wire_niil_dataout)))) & (wire_nili_dataout & (~ wire_nill_dataout))))) | (wire_niOl_dataout & (wire_niOi_dataout & (wire_n0i_dataout & wire_nilO_dataout))))))),
		n11li = (((~ wire_n0i0O_dataout) & n11lO) ^ (n11ll | ((~ wire_n0i0O_dataout) & (wire_n0i_dataout & (~ n11lO))))),
		n11ll = (wire_nilO_dataout & wire_niOi_dataout),
		n11lO = (n11ll | n11il),
		n1iii = (n10O & (n1iO & ((~ tx_ctl_tc) & ((GE_XAUI_SEL & ((~ n1lil) & (~ n1lii))) & n1iil20)))),
		n1lii = (((((((((~ tx_data_tc[0]) & tx_data_tc[1]) & (~ tx_data_tc[2])) & (~ tx_data_tc[3])) & (~ tx_data_tc[4])) & (~ tx_data_tc[5])) & tx_data_tc[6]) & (~ tx_data_tc[7])) & (~ tx_ctl_tc)),
		n1lil = ((((((((tx_data_tc[0] & (~ tx_data_tc[1])) & tx_data_tc[2]) & (~ tx_data_tc[3])) & tx_data_tc[4]) & tx_data_tc[5]) & (~ tx_data_tc[6])) & tx_data_tc[7]) & (~ tx_ctl_tc)),
		nlOO0i = ((~ wire_niii_dataout) & (~ wire_niil_dataout)),
		nlOO0l = ((~ wire_niii_dataout) & wire_niil_dataout),
		nlOO0O = (wire_niii_dataout & (~ wire_niil_dataout)),
		nlOO1O = (wire_niii_dataout & wire_niil_dataout),
		nlOOii = (((~ n10Ol) & (nlOOiO | (nlOOil | (n110i | ((~ wire_nill_dataout) & (n111i | ((~ wire_nili_dataout) & nlOOll))))))) ^ (nlOOiO | (((((~ wire_nili_dataout) & (wire_niiO_dataout & (wire_niii_dataout & wire_niil_dataout))) | (wire_nill_dataout & n111O)) | (wire_nill_dataout & n111l)) | (wire_nill_dataout & nlOOll)))),
		nlOOil = (wire_nill_dataout & (nlOOll | (wire_nili_dataout & n111i))),
		nlOOiO = (wire_n0i_dataout & nlOOlO),
		nlOOli = ((nlOOlO & (wire_n0i_dataout | (~ wire_nill_dataout))) | (wire_nill_dataout & (nlOOOl & ((~ nlOOlO) & (~ nlOOll))))),
		nlOOll = (((((~ wire_nili_dataout) & (wire_niiO_dataout & nlOO1O)) | (wire_nili_dataout & ((~ wire_niiO_dataout) & nlOO1O))) | (wire_nili_dataout & (wire_niiO_dataout & (wire_niii_dataout & (~ wire_niil_dataout))))) | (wire_nili_dataout & (wire_niiO_dataout & ((~ wire_niii_dataout) & wire_niil_dataout)))),
		nlOOlO = (((((((~ wire_nili_dataout) & ((~ wire_niiO_dataout) & (wire_niii_dataout & wire_niil_dataout))) | ((~ wire_nili_dataout) & (wire_niiO_dataout & nlOO0O))) | ((~ wire_nili_dataout) & (wire_niiO_dataout & nlOO0l))) | (wire_nili_dataout & ((~ wire_niiO_dataout) & nlOO0O))) | (wire_nili_dataout & ((~ wire_niiO_dataout) & nlOO0l))) | (wire_nili_dataout & (wire_niiO_dataout & ((~ wire_niii_dataout) & (~ wire_niil_dataout))))),
		nlOOOi = (nlOOOO | (wire_nill_dataout & nlOOOl)),
		nlOOOl = ((~ wire_nili_dataout) | (wire_niiO_dataout | (wire_niii_dataout | wire_niil_dataout))),
		nlOOOO = ((~ wire_nill_dataout) & n111i),
		PUDR = {wire_n11O_o, wire_n11l_o, wire_n11i_o, wire_nlOOO_o, wire_nlOOl_o, wire_nlOOi_o, wire_nlOlO_o, wire_nlOll_o, wire_nlOli_o, wire_nlOiO_o},
		TXLP10B = {nlOil, n0li, n0il, n0ii, n00O, n00l, n00i, n01O, n01l, n01i};
endmodule //altgxb_hssi_tx_enc_rtl
//synopsys translate_on
//VALID FILE
///////////////////////////////////////////////////////////////////////////////
//
//                           ALTGXB_8b10b_ENCODER
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1 ns / 1 ps

  module altgxb_8b10b_encoder 
    (
     clk, 
     reset,
     xgmctrl,
     kin,
     xgmdatain,
     datain,
     forcedisparity,
     dataout,
     parafbkdataout
     );
   
   parameter    transmit_protocol = "NONE";
   parameter    use_8b_10b_mode = "ON";
   parameter    force_disparity_mode = "OFF";
   
   input    clk; 
   input    reset;   // asynchronously resets the core
   input    kin;     // command byte indicator 
   input [7:0]  datain;   // data or command word
   input [7:0]  xgmdatain;// XGM State Machine Data Input
   input    xgmctrl;  // XGM Control Enable
   input    forcedisparity;
   
   output [9:0] dataout; // 10-bit encoded output
   output [9:0] parafbkdataout; // Parallel Feedback To Top Level
   
   // CORE MODULE INPUTs
   wire     tx_clk; 
   wire     soft_reset;
   wire     INDV;
   wire     ENDEC;
   wire     GE_XAUI_SEL;
   wire     IB_FORCE_DISPARITY;
   wire     prbs_en;
   wire     tx_ctl_ts;
   wire     tx_ctl_tc;
   wire [7:0]   tx_data_ts;
   wire [7:0]   tx_data_tc;
   wire     tx_data_9_tc;
   wire [9:0]   tx_data_pg;

   // CORE MODULE OUTPUTs
   wire [9:0]   TXLP10B;
   wire [9:0]   PUDR;

   // ASSIGN INPUTS
   assign  tx_clk = clk;
   assign  soft_reset = reset;
   assign INDV = (transmit_protocol != "XAUI") ? 1'b1 : 1'b0;
   assign ENDEC = (use_8b_10b_mode == "ON") ? 1'b1 : 1'b0;
   assign GE_XAUI_SEL = (transmit_protocol == "GIGE") ? 1'b1 : 1'b0;
   assign IB_FORCE_DISPARITY = (force_disparity_mode == "ON") ? 1'b1 : 1'b0;
   assign prbs_en = 1'b0;
   assign tx_ctl_ts = xgmctrl;
   assign tx_ctl_tc = kin;
   assign tx_data_ts = xgmdatain;
   assign tx_data_tc = datain;
   assign tx_data_9_tc = forcedisparity;
   assign tx_data_pg = 'b0;
   
   // ASSIGN OUTPUTS
   assign dataout = PUDR;
   assign parafbkdataout = TXLP10B;

   // Instantiate core module
   altgxb_hssi_tx_enc_rtl m_enc_core (
                .tx_clk(tx_clk), 
                .soft_reset(soft_reset),
                .INDV(INDV), 
                .ENDEC(ENDEC), 
                .GE_XAUI_SEL(GE_XAUI_SEL),
                .IB_FORCE_DISPARITY(IB_FORCE_DISPARITY),
                .prbs_en(prbs_en),
                .tx_ctl_ts(tx_ctl_ts),
                .tx_ctl_tc(tx_ctl_tc),
                .tx_data_ts(tx_data_ts),
                .tx_data_tc(tx_data_tc),
                .tx_data_9_tc(tx_data_9_tc),
                .tx_data_pg(tx_data_pg), 
                .PUDR(PUDR),
                .TXLP10B(TXLP10B)
    );
   
endmodule

///////////////////////////////////////////////////////////////////////////////
//
//                           ALTGXB_HSSI_TRANSMITTER
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1 ps/1 ps

module altgxb_hssi_transmitter
   (
    pllclk,
    fastpllclk,
    coreclk,
    softreset,
    serialdatain,
    xgmctrl,
    srlpbk,
    analogreset,
    datain,
    ctrlenable,
    forcedisparity,
    xgmdatain,
    vodctrl,
    preemphasisctrl,
    devclrn,
    devpor,
    dataout,
    xgmctrlenable,
    rdenablesync,
    xgmdataout,
    parallelfdbkdata,
    pre8b10bdata
    );

parameter channel_num = 1; 
parameter channel_width = 8; // (The width of the datain port)>;    
parameter serialization_factor = 8; 
parameter use_double_data_mode = "OFF";
parameter use_8b_10b_mode = "OFF";
parameter use_fifo_mode = "OFF";
parameter use_reverse_parallel_feedback = "OFF";
parameter force_disparity_mode = "OFF";
parameter transmit_protocol = "NONE"; // <gige, xaui, none>;
parameter use_vod_ctrl_signal = "OFF";
parameter use_preemphasis_ctrl_signal = "OFF";
parameter use_self_test_mode = "OFF";
parameter self_test_mode = 0;
parameter vod_ctrl_setting = 4;  
parameter preemphasis_ctrl_setting = 5;
parameter termination = 0; // new in 3.0


input [19 : 0] datain; // (<input bus>),
input pllclk; // (<pll clock source (ref_clk)>), 
input fastpllclk; // (<pll clock source powering SERDES>),
input coreclk; // (<core clock source>), 
input softreset; // (<unknown reset source>),
input [1 : 0] ctrlenable; // (<data sent is control code>),
input [1 : 0] forcedisparity; // (<force disparity for 8B / 10B>),
input serialdatain; // (<data to be sent directly to data output>),
input [7 : 0] xgmdatain; // (<data input from the XGM SM system>),
input xgmctrl; // (<control input from the XGM SM system>),
input srlpbk; 
input devpor;
input devclrn;
input analogreset;
input [2 : 0] vodctrl;
input [2 : 0] preemphasisctrl;
   
output dataout; // (<data output of HSSI channel>),
output [7 : 0] xgmdataout; // (<data output before 8B/10B to XGM SM>),
output xgmctrlenable; // (<ctrlenable output before 8B/10B to XGM SM>),
output rdenablesync; 
output [9 : 0] parallelfdbkdata; // (<parallel data output>),
output [9 : 0] pre8b10bdata; // (<pararrel non-encoded data output>)
   
// wire declarations
wire datain_in0,datain_in1,datain_in2,datain_in3,datain_in4;
wire datain_in5,datain_in6,datain_in7,datain_in8,datain_in9;
wire datain_in10,datain_in11,datain_in12,datain_in13,datain_in14;
wire datain_in15,datain_in16,datain_in17,datain_in18,datain_in19;
wire pllclk_in,fastpllclk_in,coreclk_in,softreset_in,analogreset_in;
wire vodctrl_in0,vodctrl_in1,vodctrl_in2;
wire preemphasisctrl_in0,preemphasisctrl_in1,preemphasisctrl_in2;
wire ctrlenable_in0,ctrlenable_in1;
wire forcedisparity_in0,forcedisparity_in1;
wire serialdatain_in;
wire xgmdatain_in0,xgmdatain_in1,xgmdatain_in2,xgmdatain_in3,xgmdatain_in4,xgmdatain_in5,xgmdatain_in6,xgmdatain_in7;
wire xgmctrl_in, srlpbk_in;

buf (datain_in0, datain[0]);
buf (datain_in1, datain[1]);
buf (datain_in2, datain[2]);
buf (datain_in3, datain[3]);
buf (datain_in4, datain[4]);
buf (datain_in5, datain[5]);
buf (datain_in6, datain[6]);
buf (datain_in7, datain[7]);
buf (datain_in8, datain[8]);
buf (datain_in9, datain[9]);
buf (datain_in10, datain[10]);
buf (datain_in11, datain[11]);
buf (datain_in12, datain[12]);
buf (datain_in13, datain[13]);
buf (datain_in14, datain[14]);
buf (datain_in15, datain[15]);
buf (datain_in16, datain[16]);
buf (datain_in17, datain[17]);
buf (datain_in18, datain[18]);
buf (datain_in19, datain[19]);

buf (pllclk_in, pllclk);
buf (fastpllclk_in, fastpllclk);
buf (coreclk_in, coreclk);
buf (softreset_in, softreset);
buf (analogreset_in, analogreset);
buf (vodctrl_in0, vodctrl[0]);
buf (vodctrl_in1, vodctrl[1]);
buf (vodctrl_in2, vodctrl[2]);
buf (preemphasisctrl_in0, preemphasisctrl[0]);
buf (preemphasisctrl_in1, preemphasisctrl[1]);
buf (preemphasisctrl_in2, preemphasisctrl[2]);
buf (ctrlenable_in0, ctrlenable[0]);
buf (ctrlenable_in1, ctrlenable[1]);
buf (forcedisparity_in0, forcedisparity[0]);
buf (forcedisparity_in1, forcedisparity[1]);
buf (serialdatain_in, serialdatain);

buf (xgmdatain_in0, xgmdatain[0]);
buf (xgmdatain_in1, xgmdatain[1]);
buf (xgmdatain_in2, xgmdatain[2]);
buf (xgmdatain_in3, xgmdatain[3]);
buf (xgmdatain_in4, xgmdatain[4]);
buf (xgmdatain_in5, xgmdatain[5]);
buf (xgmdatain_in6, xgmdatain[6]);
buf (xgmdatain_in7, xgmdatain[7]);

buf (xgmctrl_in, xgmctrl);
buf (srlpbk_in, srlpbk);
   
//constant signals
wire vcc, gnd;
wire [9 : 0] idle_bus;

//lower lever softreset
wire reset_int;

// internal bus for XGM data
wire [7 : 0] xgmdatain_in;
wire [19 : 0] datain_in;

assign xgmdatain_in = {
                                xgmdatain_in7, xgmdatain_in6,
                                xgmdatain_in5, xgmdatain_in4,
                                xgmdatain_in3, xgmdatain_in2,
                                xgmdatain_in1, xgmdatain_in0
                             };
assign datain_in = {
                                datain_in19, datain_in18,
                                datain_in17, datain_in16,
                                datain_in15, datain_in14,
                                datain_in13, datain_in12,
                                datain_in11, datain_in10,
                                datain_in9, datain_in8,
                                datain_in7, datain_in6,
                                datain_in5, datain_in4,
                                datain_in3, datain_in2,
                                datain_in1, datain_in0
                             };

assign reset_int = softreset_in;
assign vcc = 1'b1;
assign gnd = 1'b0;
assign idle_bus = 10'b0000000000;

// tx_core input/output signals
wire [19:0] core_datain;
wire core_writeclk;
wire core_readclk;
wire [1:0] core_ctrlena;
wire [1:0] core_forcedisp;
   
wire [9:0] core_dataout;
wire core_forcedispout;
wire core_ctrlenaout;
wire core_rdenasync;
wire core_xgmctrlena;
wire [7:0] core_xgmdataout;
wire [9:0] core_pre8b10bdataout;

// serdes input/output signals
wire [9:0] serdes_datain;
wire serdes_clk;
wire serdes_clk1;
wire serdes_serialdatain;
wire serdes_srlpbk;

wire serdes_dataout;

// encoder input/output signals
wire encoder_clk; 
wire encoder_kin; 
wire [7:0] encoder_datain;
wire [7:0] encoder_xgmdatain;
wire encoder_xgmctrl; 
      
wire [9:0] encoder_dataout;
wire [9:0] encoder_para;

// internal signal for parallelfdbkdata
wire [9 : 0] parallelfdbkdata_tmp; 

// TX CLOCK MUX
wire      txclk;
wire      pllclk_int;
      
specify

    $setuphold(posedge coreclk, datain[0], 0, 0);
    $setuphold(posedge coreclk, datain[1], 0, 0);
    $setuphold(posedge coreclk, datain[2], 0, 0);
    $setuphold(posedge coreclk, datain[3], 0, 0);
    $setuphold(posedge coreclk, datain[4], 0, 0);
    $setuphold(posedge coreclk, datain[5], 0, 0);
    $setuphold(posedge coreclk, datain[6], 0, 0);
    $setuphold(posedge coreclk, datain[7], 0, 0);
    $setuphold(posedge coreclk, datain[8], 0, 0);
    $setuphold(posedge coreclk, datain[9], 0, 0);
    $setuphold(posedge coreclk, datain[10], 0, 0);
    $setuphold(posedge coreclk, datain[11], 0, 0);
    $setuphold(posedge coreclk, datain[12], 0, 0);
    $setuphold(posedge coreclk, datain[13], 0, 0);
    $setuphold(posedge coreclk, datain[14], 0, 0);
    $setuphold(posedge coreclk, datain[15], 0, 0);
    $setuphold(posedge coreclk, datain[16], 0, 0);
    $setuphold(posedge coreclk, datain[17], 0, 0);
    $setuphold(posedge coreclk, datain[18], 0, 0);
    $setuphold(posedge coreclk, datain[19], 0, 0);

    $setuphold(posedge coreclk, ctrlenable[0], 0, 0);
    $setuphold(posedge coreclk, ctrlenable[1], 0, 0);

    $setuphold(posedge coreclk, forcedisparity[0], 0, 0);
    $setuphold(posedge coreclk, forcedisparity[1], 0, 0);
endspecify
   
// generate internal inut signals

// TX CLOCK MUX
altgxb_hssi_divide_by_two txclk_block   
   (
    .reset(1'b0),
    .clkin(pllclk_in), 
    .clkout(pllclk_int)
    );
   defparam  txclk_block.divide = use_double_data_mode;

assign txclk = (use_reverse_parallel_feedback == "ON") ?  pllclk_int : coreclk_in;
   
// tx_core inputs
assign core_datain = datain_in;
assign core_writeclk = txclk;
assign core_readclk = pllclk_in;
assign core_ctrlena = {ctrlenable_in1, ctrlenable_in0};
assign core_forcedisp = {forcedisparity_in1, forcedisparity_in0};
     
// encoder inputs
assign encoder_clk = pllclk_in; 
assign encoder_kin = core_ctrlenaout;
assign encoder_datain = core_dataout[7:0];
assign encoder_xgmdatain = xgmdatain_in;
assign encoder_xgmctrl = xgmctrl_in; 

// serdes inputs
assign serdes_datain = (use_8b_10b_mode == "ON") ? encoder_dataout : core_dataout;
assign serdes_clk = fastpllclk_in;
assign serdes_clk1 = pllclk_in;
assign serdes_serialdatain = serialdatain_in;
assign serdes_srlpbk = srlpbk_in;

// parallelfdbkdata generation
assign parallelfdbkdata_tmp = (use_8b_10b_mode == "ON") ? encoder_dataout : core_dataout; 

// sub modules

altgxb_tx_core s_tx_core    
   (
    .reset(reset_int),
    .datain(core_datain),
    .writeclk(core_writeclk),
    .readclk(core_readclk),
    .ctrlena(core_ctrlena),
    .forcedisp(core_forcedisp),
    .dataout(core_dataout),
    .forcedispout(core_forcedispout),
    .ctrlenaout(core_ctrlenaout),
    .rdenasync(core_rdenasync),
    .xgmctrlena(core_xgmctrlena),
    .xgmdataout(core_xgmdataout),
    .pre8b10bdataout(core_pre8b10bdataout)
    );
   defparam  s_tx_core.use_double_data_mode = use_double_data_mode;
   defparam  s_tx_core.use_fifo_mode = use_fifo_mode;
   defparam  s_tx_core.channel_width = channel_width;
   defparam  s_tx_core.transmit_protocol = transmit_protocol;   
   
altgxb_8b10b_encoder s_encoder  
   (
    .clk(encoder_clk), 
    .reset(reset_int), 
    .kin(encoder_kin),
    .datain(encoder_datain),
    .xgmdatain(encoder_xgmdatain),
    .xgmctrl(encoder_xgmctrl),
    .forcedisparity(core_forcedispout),
    .dataout(encoder_dataout),
    .parafbkdataout(encoder_para)
    );
   defparam  s_encoder.transmit_protocol = transmit_protocol;
   defparam  s_encoder.use_8b_10b_mode = use_8b_10b_mode;
   defparam  s_encoder.force_disparity_mode = force_disparity_mode;

altgxb_hssi_tx_serdes s_tx_serdes   
  (
   .clk(serdes_clk), 
   .clk1(serdes_clk1), 
   .datain(serdes_datain),
   .serialdatain(serdes_serialdatain),
   .srlpbk(serdes_srlpbk),
   .areset(analogreset_in),
   .dataout(serdes_dataout)
   );
   defparam  s_tx_serdes.channel_width = serialization_factor;

// gererate output signals
and (dataout, 1'b1, serdes_dataout); 
and (xgmctrlenable, 1'b1, core_xgmctrlena);
and (rdenablesync, 1'b1, core_rdenasync); 

buf (xgmdataout[0], core_xgmdataout[0]);
buf (xgmdataout[1], core_xgmdataout[1]);
buf (xgmdataout[2], core_xgmdataout[2]);
buf (xgmdataout[3], core_xgmdataout[3]);
buf (xgmdataout[4], core_xgmdataout[4]);
buf (xgmdataout[5], core_xgmdataout[5]);
buf (xgmdataout[6], core_xgmdataout[6]);
buf (xgmdataout[7], core_xgmdataout[7]);

buf (pre8b10bdata[0], core_pre8b10bdataout[0]);
buf (pre8b10bdata[1], core_pre8b10bdataout[1]);
buf (pre8b10bdata[2], core_pre8b10bdataout[2]);
buf (pre8b10bdata[3], core_pre8b10bdataout[3]);
buf (pre8b10bdata[4], core_pre8b10bdataout[4]);
buf (pre8b10bdata[5], core_pre8b10bdataout[5]);
buf (pre8b10bdata[6], core_pre8b10bdataout[6]);
buf (pre8b10bdata[7], core_pre8b10bdataout[7]);
buf (pre8b10bdata[8], core_pre8b10bdataout[8]);
buf (pre8b10bdata[9], core_pre8b10bdataout[9]);

buf (parallelfdbkdata[0], parallelfdbkdata_tmp[0]); 
buf (parallelfdbkdata[1], parallelfdbkdata_tmp[1]); 
buf (parallelfdbkdata[2], parallelfdbkdata_tmp[2]); 
buf (parallelfdbkdata[3], parallelfdbkdata_tmp[3]); 
buf (parallelfdbkdata[4], parallelfdbkdata_tmp[4]); 
buf (parallelfdbkdata[5], parallelfdbkdata_tmp[5]); 
buf (parallelfdbkdata[6], parallelfdbkdata_tmp[6]); 
buf (parallelfdbkdata[7], parallelfdbkdata_tmp[7]); 
buf (parallelfdbkdata[8], parallelfdbkdata_tmp[8]); 
buf (parallelfdbkdata[9], parallelfdbkdata_tmp[9]); 

endmodule // altgxb_hssi_transmitter

//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 97 mux21 43 
`timescale 1 ps / 1 ps
module  altgxb_8b10b_decoder
	( 
	clk,
	datain,
	datainvalid,
	dataout,
	decdatavalid,
	disperr,
	disperrin,
	errdetect,
	errdetectin,
	kout,
	patterndetect,
	patterndetectin,
	rderr,
	reset,
	syncstatus,
	syncstatusin,
	tenBdata,
	valid,
	xgmctrldet,
	xgmdataout,
	xgmdatavalid,
	xgmrunningdisp) /* synthesis synthesis_clearbox=1 */;
	input   clk;
	input   [9:0]  datain;
	input   datainvalid;
	output   [7:0]  dataout;
	output   decdatavalid;
	output   disperr;
	input   disperrin;
	output   errdetect;
	input   errdetectin;
	output   kout;
	output   patterndetect;
	input   patterndetectin;
	output   rderr;
	input   reset;
	output   syncstatus;
	input   syncstatusin;
	output   [9:0]  tenBdata;
	output   valid;
	output   xgmctrldet;
	output   [7:0]  xgmdataout;
	output   xgmdatavalid;
	output   xgmrunningdisp;

	reg	n0l0i55;
	reg	n0l0i56;
	reg	n0l0i57;
	reg	n0l1l58;
	reg	n0l1l59;
	reg	n0l1l60;
	reg	n0lii52;
	reg	n0lii53;
	reg	n0lii54;
	reg	n0liO49;
	reg	n0liO50;
	reg	n0liO51;
	reg	n0lll46;
	reg	n0lll47;
	reg	n0lll48;
	reg	n0lOi43;
	reg	n0lOi44;
	reg	n0lOi45;
	reg	n0lOO40;
	reg	n0lOO41;
	reg	n0lOO42;
	reg	n0O0i34;
	reg	n0O0i35;
	reg	n0O0i36;
	reg	n0O1l37;
	reg	n0O1l38;
	reg	n0O1l39;
	reg	n0Oii31;
	reg	n0Oii32;
	reg	n0Oii33;
	reg	n0Oli28;
	reg	n0Oli29;
	reg	n0Oli30;
	reg	n0OlO25;
	reg	n0OlO26;
	reg	n0OlO27;
	reg	n0OOO22;
	reg	n0OOO23;
	reg	n0OOO24;
	reg	ni00O1;
	reg	ni00O2;
	reg	ni00O3;
	reg	ni10l16;
	reg	ni10l17;
	reg	ni10l18;
	reg	ni11O19;
	reg	ni11O20;
	reg	ni11O21;
	reg	ni1ii13;
	reg	ni1ii14;
	reg	ni1ii15;
	reg	ni1iO10;
	reg	ni1iO11;
	reg	ni1iO12;
	reg	ni1ll7;
	reg	ni1ll8;
	reg	ni1ll9;
	reg	ni1Oi4;
	reg	ni1Oi5;
	reg	ni1Oi6;
	reg	niii;
	reg	niil;
	reg	niiO;
	reg	nili;
	reg	nill;
	reg	nilO;
	reg	niOi;
	reg	niOO;
	reg	n0i;
	reg	n0l;
	reg	n0O;
	reg	n1i;
	reg	n1l;
	reg	n1O;
	reg	ni;
	reg	nii;
	reg	nil;
	reg	niO;
	reg	nl0i;
	reg	nl0l;
	reg	nl0O;
	reg	nl1i;
	reg	nl1l;
	reg	nl1O;
	reg	nli;
	reg	nlii;
	reg	nlil;
	reg	nliO;
	reg	nll;
	reg	nlli;
	reg	nlll;
	reg	nllO;
	reg	nlO;
	reg	nlOi;
	reg	nlOl;
	reg	nlOO;
	reg	nO;
	wire	wire_niO0i_dataout;
	wire	wire_niO0l_dataout;
	wire	wire_niO0O_dataout;
	wire	wire_niO1l_dataout;
	wire	wire_niO1O_dataout;
	wire	wire_niOii_dataout;
	wire	wire_niOil_dataout;
	wire	wire_niOiO_dataout;
	wire	wire_niOli_dataout;
	wire	wire_niOll_dataout;
	wire	wire_niOlO_dataout;
	wire	wire_niOOi_dataout;
	wire	wire_niOOl_dataout;
	wire	wire_niOOO_dataout;
	wire	wire_nl10i_dataout;
	wire	wire_nl10l_dataout;
	wire	wire_nl10O_dataout;
	wire	wire_nl11i_dataout;
	wire	wire_nl11l_dataout;
	wire	wire_nl11O_dataout;
	wire	wire_nl1il_dataout;
	wire	wire_nl1iO_dataout;
	wire	wire_nl1li_dataout;
	wire	wire_nli0i_dataout;
	wire	wire_nli0l_dataout;
	wire	wire_nli0O_dataout;
	wire	wire_nli1l_dataout;
	wire	wire_nli1O_dataout;
	wire	wire_nlill_dataout;
	wire	wire_nlilO_dataout;
	wire	wire_nliOi_dataout;
	wire	wire_nliOl_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllO_dataout;
	wire  n0iOi;
	wire  n0iOl;
	wire  n0iOO;
	wire  n0l0O;
	wire  n0l1i;
	wire  n0O0O;
	wire  n0OiO;
	wire  n0OOl;
	wire  ni00i;
	wire  ni00l;
	wire  ni01i;
	wire  ni01l;
	wire  ni01O;
	wire  ni0iO;
	wire  ni0li;
	wire  ni11l;
	wire  ni1OO;

	initial
		n0l0i55 = {1{1'b1}};
	always @ ( posedge clk)
		  n0l0i55 <= n0l0i57;
	initial
		n0l0i56 = {1{1'b1}};
	always @ ( posedge clk)
		  n0l0i56 <= (n0l0i57 ^ n0l0i55);
	initial
		n0l0i57 = 0;
	always @ ( posedge clk)
		  n0l0i57 <= n0l0i55;
	initial
		n0l1l58 = {1{1'b1}};
	always @ ( posedge clk)
		  n0l1l58 <= n0l1l60;
	initial
		n0l1l59 = {1{1'b1}};
	always @ ( posedge clk)
		  n0l1l59 <= (n0l1l60 ^ n0l1l58);
	initial
		n0l1l60 = 0;
	always @ ( posedge clk)
		  n0l1l60 <= n0l1l58;
	initial
		n0lii52 = {1{1'b1}};
	always @ ( posedge clk)
		  n0lii52 <= n0lii54;
	initial
		n0lii53 = {1{1'b1}};
	always @ ( posedge clk)
		  n0lii53 <= (n0lii54 ^ n0lii52);
	initial
		n0lii54 = 0;
	always @ ( posedge clk)
		  n0lii54 <= n0lii52;
	initial
		n0liO49 = {1{1'b1}};
	always @ ( posedge clk)
		  n0liO49 <= n0liO51;
	initial
		n0liO50 = {1{1'b1}};
	always @ ( posedge clk)
		  n0liO50 <= (n0liO51 ^ n0liO49);
	initial
		n0liO51 = 0;
	always @ ( posedge clk)
		  n0liO51 <= n0liO49;
	initial
		n0lll46 = {1{1'b1}};
	always @ ( posedge clk)
		  n0lll46 <= n0lll48;
	initial
		n0lll47 = {1{1'b1}};
	always @ ( posedge clk)
		  n0lll47 <= (n0lll48 ^ n0lll46);
	initial
		n0lll48 = 0;
	always @ ( posedge clk)
		  n0lll48 <= n0lll46;
	initial
		n0lOi43 = {1{1'b1}};
	always @ ( posedge clk)
		  n0lOi43 <= n0lOi45;
	initial
		n0lOi44 = {1{1'b1}};
	always @ ( posedge clk)
		  n0lOi44 <= (n0lOi45 ^ n0lOi43);
	initial
		n0lOi45 = 0;
	always @ ( posedge clk)
		  n0lOi45 <= n0lOi43;
	initial
		n0lOO40 = {1{1'b1}};
	always @ ( posedge clk)
		  n0lOO40 <= n0lOO42;
	initial
		n0lOO41 = {1{1'b1}};
	always @ ( posedge clk)
		  n0lOO41 <= (n0lOO42 ^ n0lOO40);
	initial
		n0lOO42 = 0;
	always @ ( posedge clk)
		  n0lOO42 <= n0lOO40;
	initial
		n0O0i34 = {1{1'b1}};
	always @ ( posedge clk)
		  n0O0i34 <= n0O0i36;
	initial
		n0O0i35 = {1{1'b1}};
	always @ ( posedge clk)
		  n0O0i35 <= (n0O0i36 ^ n0O0i34);
	initial
		n0O0i36 = 0;
	always @ ( posedge clk)
		  n0O0i36 <= n0O0i34;
	initial
		n0O1l37 = {1{1'b1}};
	always @ ( posedge clk)
		  n0O1l37 <= n0O1l39;
	initial
		n0O1l38 = {1{1'b1}};
	always @ ( posedge clk)
		  n0O1l38 <= (n0O1l39 ^ n0O1l37);
	initial
		n0O1l39 = 0;
	always @ ( posedge clk)
		  n0O1l39 <= n0O1l37;
	initial
		n0Oii31 = {1{1'b1}};
	always @ ( posedge clk)
		  n0Oii31 <= n0Oii33;
	initial
		n0Oii32 = {1{1'b1}};
	always @ ( posedge clk)
		  n0Oii32 <= (n0Oii33 ^ n0Oii31);
	initial
		n0Oii33 = 0;
	always @ ( posedge clk)
		  n0Oii33 <= n0Oii31;
	initial
		n0Oli28 = {1{1'b1}};
	always @ ( posedge clk)
		  n0Oli28 <= n0Oli30;
	initial
		n0Oli29 = {1{1'b1}};
	always @ ( posedge clk)
		  n0Oli29 <= (n0Oli30 ^ n0Oli28);
	initial
		n0Oli30 = 0;
	always @ ( posedge clk)
		  n0Oli30 <= n0Oli28;
	initial
		n0OlO25 = {1{1'b1}};
	always @ ( posedge clk)
		  n0OlO25 <= n0OlO27;
	initial
		n0OlO26 = {1{1'b1}};
	always @ ( posedge clk)
		  n0OlO26 <= (n0OlO27 ^ n0OlO25);
	initial
		n0OlO27 = 0;
	always @ ( posedge clk)
		  n0OlO27 <= n0OlO25;
	initial
		n0OOO22 = {1{1'b1}};
	always @ ( posedge clk)
		  n0OOO22 <= n0OOO24;
	initial
		n0OOO23 = {1{1'b1}};
	always @ ( posedge clk)
		  n0OOO23 <= (n0OOO24 ^ n0OOO22);
	initial
		n0OOO24 = 0;
	always @ ( posedge clk)
		  n0OOO24 <= n0OOO22;
	initial
		ni00O1 = {1{1'b1}};
	always @ ( posedge clk)
		  ni00O1 <= ni00O3;
	initial
		ni00O2 = {1{1'b1}};
	always @ ( posedge clk)
		  ni00O2 <= (ni00O3 ^ ni00O1);
	initial
		ni00O3 = 0;
	always @ ( posedge clk)
		  ni00O3 <= ni00O1;
	initial
		ni10l16 = {1{1'b1}};
	always @ ( posedge clk)
		  ni10l16 <= ni10l18;
	initial
		ni10l17 = {1{1'b1}};
	always @ ( posedge clk)
		  ni10l17 <= (ni10l18 ^ ni10l16);
	initial
		ni10l18 = 0;
	always @ ( posedge clk)
		  ni10l18 <= ni10l16;
	initial
		ni11O19 = {1{1'b1}};
	always @ ( posedge clk)
		  ni11O19 <= ni11O21;
	initial
		ni11O20 = {1{1'b1}};
	always @ ( posedge clk)
		  ni11O20 <= (ni11O21 ^ ni11O19);
	initial
		ni11O21 = 0;
	always @ ( posedge clk)
		  ni11O21 <= ni11O19;
	initial
		ni1ii13 = {1{1'b1}};
	always @ ( posedge clk)
		  ni1ii13 <= ni1ii15;
	initial
		ni1ii14 = {1{1'b1}};
	always @ ( posedge clk)
		  ni1ii14 <= (ni1ii15 ^ ni1ii13);
	initial
		ni1ii15 = 0;
	always @ ( posedge clk)
		  ni1ii15 <= ni1ii13;
	initial
		ni1iO10 = {1{1'b1}};
	always @ ( posedge clk)
		  ni1iO10 <= ni1iO12;
	initial
		ni1iO11 = {1{1'b1}};
	always @ ( posedge clk)
		  ni1iO11 <= (ni1iO12 ^ ni1iO10);
	initial
		ni1iO12 = 0;
	always @ ( posedge clk)
		  ni1iO12 <= ni1iO10;
	initial
		ni1ll7 = {1{1'b1}};
	always @ ( posedge clk)
		  ni1ll7 <= ni1ll9;
	initial
		ni1ll8 = {1{1'b1}};
	always @ ( posedge clk)
		  ni1ll8 <= (ni1ll9 ^ ni1ll7);
	initial
		ni1ll9 = 0;
	always @ ( posedge clk)
		  ni1ll9 <= ni1ll7;
	initial
		ni1Oi4 = {1{1'b1}};
	always @ ( posedge clk)
		  ni1Oi4 <= ni1Oi6;
	initial
		ni1Oi5 = {1{1'b1}};
	always @ ( posedge clk)
		  ni1Oi5 <= (ni1Oi6 ^ ni1Oi4);
	initial
		ni1Oi6 = 0;
	always @ ( posedge clk)
		  ni1Oi6 <= ni1Oi4;
	initial
	begin
		niii = 0;
		niil = 0;
		niiO = 0;
		nili = 0;
		nill = 0;
		nilO = 0;
		niOi = 0;
		niOO = 0;
	end
	always @ ( posedge clk or posedge reset)
	begin
		if (reset == 1'b1) 
		begin
			niii <= 1;
			niil <= 1;
			niiO <= 1;
			nili <= 1;
			nill <= 1;
			nilO <= 1;
			niOi <= 1;
			niOO <= 1;
		end
		else 
		begin
			niii <= ni0iO;
			niil <= ni0iO;
			niiO <= wire_niO0O_dataout;
			nili <= wire_niO0l_dataout;
			nill <= wire_niO0i_dataout;
			nilO <= wire_niO0O_dataout;
			niOi <= wire_niO0l_dataout;
			niOO <= wire_niO0i_dataout;
		end
	end
	initial
	begin
		n0i = 0;
		n0l = 0;
		n0O = 0;
		n1i = 0;
		n1l = 0;
		n1O = 0;
		ni = 0;
		nii = 0;
		nil = 0;
		niO = 0;
		nl0i = 0;
		nl0l = 0;
		nl0O = 0;
		nl1i = 0;
		nl1l = 0;
		nl1O = 0;
		nli = 0;
		nlii = 0;
		nlil = 0;
		nliO = 0;
		nll = 0;
		nlli = 0;
		nlll = 0;
		nllO = 0;
		nlO = 0;
		nlOi = 0;
		nlOl = 0;
		nlOO = 0;
		nO = 0;
	end
	always @ ( posedge clk or posedge reset)
	begin
		if (reset == 1'b1) 
		begin
			n0i <= 0;
			n0l <= 0;
			n0O <= 0;
			n1i <= 0;
			n1l <= 0;
			n1O <= 0;
			ni <= 0;
			nii <= 0;
			nil <= 0;
			niO <= 0;
			nl0i <= 0;
			nl0l <= 0;
			nl0O <= 0;
			nl1i <= 0;
			nl1l <= 0;
			nl1O <= 0;
			nli <= 0;
			nlii <= 0;
			nlil <= 0;
			nliO <= 0;
			nll <= 0;
			nlli <= 0;
			nlll <= 0;
			nllO <= 0;
			nlO <= 0;
			nlOi <= 0;
			nlOl <= 0;
			nlOO <= 0;
			nO <= 0;
		end
		else 
		begin
			n0i <= errdetectin;
			n0l <= datainvalid;
			n0O <= wire_niO1O_dataout;
			n1i <= patterndetectin;
			n1l <= syncstatusin;
			n1O <= disperrin;
			ni <= wire_nliOi_dataout;
			nii <= wire_niO1l_dataout;
			nil <= wire_nliOi_dataout;
			niO <= wire_nlilO_dataout;
			nl0i <= datain[2];
			nl0l <= datain[3];
			nl0O <= datain[4];
			nl1i <= wire_nlill_dataout;
			nl1l <= datain[0];
			nl1O <= datain[1];
			nli <= wire_nlill_dataout;
			nlii <= datain[5];
			nlil <= datain[6];
			nliO <= datain[7];
			nll <= wire_niO1O_dataout;
			nlli <= datain[8];
			nlll <= datain[9];
			nllO <= disperrin;
			nlO <= wire_niO1l_dataout;
			nlOi <= datainvalid;
			nlOl <= datainvalid;
			nlOO <= disperrin;
			nO <= wire_nlilO_dataout;
		end
	end
	or(wire_niO0i_dataout, wire_niOiO_dataout, ni00i);
	and(wire_niO0l_dataout, wire_niOli_dataout, ~{ni00i});
	and(wire_niO0O_dataout, wire_niOll_dataout, ~{ni00i});
	or(wire_niO1l_dataout, wire_niOii_dataout, ni00i);
	or(wire_niO1O_dataout, wire_niOil_dataout, ni00i);
	or(wire_niOii_dataout, wire_niOlO_dataout, ni11l);
	or(wire_niOil_dataout, wire_niOOi_dataout, ni11l);
	and(wire_niOiO_dataout, wire_niOOl_dataout, ~{ni11l});
	and(wire_niOli_dataout, wire_niOOO_dataout, ~{ni11l});
	and(wire_niOll_dataout, wire_nl11i_dataout, ~{ni11l});
	assign		wire_niOlO_dataout = (n0OOl === 1'b1) ? wire_nl1il_dataout : wire_nl11l_dataout;
	assign		wire_niOOi_dataout = (n0OOl === 1'b1) ? wire_nl1iO_dataout : wire_nl11O_dataout;
	assign		wire_niOOl_dataout = (n0OOl === 1'b1) ? wire_nl1iO_dataout : wire_nl10i_dataout;
	assign		wire_niOOO_dataout = (n0OOl === 1'b1) ? wire_nl1iO_dataout : wire_nl10l_dataout;
	assign		wire_nl10i_dataout = (n0l1i === 1'b1) ? datain[2] : (~ wire_nli0i_dataout);
	assign		wire_nl10l_dataout = (n0l1i === 1'b1) ? datain[1] : (~ wire_nli0l_dataout);
	assign		wire_nl10O_dataout = (n0l1i === 1'b1) ? datain[0] : (~ wire_nli0O_dataout);
	assign		wire_nl11i_dataout = (n0OOl === 1'b1) ? wire_nl1iO_dataout : wire_nl10O_dataout;
	assign		wire_nl11l_dataout = (n0l1i === 1'b1) ? datain[4] : ni1OO;
	assign		wire_nl11O_dataout = (n0l1i === 1'b1) ? datain[3] : (~ wire_nli1O_dataout);
	and(wire_nl1il_dataout, wire_nl1li_dataout, ~{n0iOO});
	and(wire_nl1iO_dataout, (~ n0iOl), ~{n0iOO});
	or(wire_nl1li_dataout, (~ ((~ wire_nli0i_dataout) & wire_nli0l_dataout)), n0iOl);
	assign		wire_nli0i_dataout = (datain[5] === 1'b1) ? datain[2] : (~ datain[2]);
	assign		wire_nli0l_dataout = (datain[5] === 1'b1) ? datain[1] : (~ datain[1]);
	assign		wire_nli0O_dataout = (datain[5] === 1'b1) ? datain[0] : (~ datain[0]);
	assign		wire_nli1l_dataout = (datain[5] === 1'b1) ? datain[4] : (~ datain[4]);
	assign		wire_nli1O_dataout = (datain[5] === 1'b1) ? datain[3] : (~ datain[3]);
	and(wire_nlill_dataout, wire_nliOl_dataout, ~{ni01i});
	and(wire_nlilO_dataout, wire_nliOO_dataout, ~{ni01i});
	and(wire_nliOi_dataout, wire_nll1i_dataout, ~{ni01i});
	or(wire_nliOl_dataout, wire_nll1l_dataout, ni01l);
	or(wire_nliOO_dataout, wire_nll1O_dataout, ni01l);
	assign		wire_nll0i_dataout = ((~ ni00l) === 1'b1) ? wire_nlllO_dataout : wire_nllii_dataout;
	assign		wire_nll0l_dataout = (ni01O === 1'b1) ? (~ datain[8]) : datain[8];
	assign		wire_nll0O_dataout = (ni01O === 1'b1) ? (~ datain[7]) : datain[7];
	or(wire_nll1i_dataout, wire_nll0i_dataout, ni01l);
	assign		wire_nll1l_dataout = ((~ ni00l) === 1'b1) ? wire_nllli_dataout : wire_nll0l_dataout;
	assign		wire_nll1O_dataout = ((~ ni00l) === 1'b1) ? wire_nllll_dataout : wire_nll0O_dataout;
	assign		wire_nllii_dataout = (ni01O === 1'b1) ? (~ datain[6]) : datain[6];
	assign		wire_nllli_dataout = (datain[9] === 1'b1) ? (~ datain[8]) : datain[8];
	assign		wire_nllll_dataout = (datain[9] === 1'b1) ? (~ datain[7]) : datain[7];
	assign		wire_nlllO_dataout = (datain[9] === 1'b1) ? (~ datain[6]) : datain[6];
	assign
		dataout = {nl1i, nO, ni, nlO, nll, niOO, niOi, nilO},
		decdatavalid = nlOl,
		disperr = nlOO,
		errdetect = n0i,
		kout = niil,
		n0iOi = ((~ wire_nli0O_dataout) & (~ wire_nli0l_dataout)),
		n0iOl = (wire_nli0i_dataout & wire_nli0l_dataout),
		n0iOO = ((~ wire_nli0i_dataout) & (~ wire_nli0l_dataout)),
		n0l0O = (((((~ wire_nli1O_dataout) & ((~ wire_nli0i_dataout) & (wire_nli0O_dataout & (~ wire_nli0l_dataout)))) | ((~ wire_nli1O_dataout) & ((~ wire_nli0i_dataout) & ((~ wire_nli0O_dataout) & wire_nli0l_dataout)))) | ((~ wire_nli1O_dataout) & (wire_nli0i_dataout & n0iOi))) | (wire_nli1O_dataout & ((~ wire_nli0i_dataout) & n0iOi))),
		n0l1i = ((((~ wire_nli1l_dataout) & (((((((((~ wire_nli1O_dataout) & (((~ wire_nli0i_dataout) & ((wire_nli0O_dataout & wire_nli0l_dataout) & n0OlO26)) & n0Oli29)) | ((~ wire_nli1O_dataout) & (wire_nli0i_dataout & n0OiO))) | (~ n0Oii32)) | ((~ wire_nli1O_dataout) & ((wire_nli0i_dataout & n0O0O) & n0O0i35))) | (wire_nli1O_dataout & (((~ wire_nli0i_dataout) & n0OiO) & n0O1l38))) | (~ n0lOO41)) | ((wire_nli1O_dataout & (((~ wire_nli0i_dataout) & n0O0O) & n0lOi44)) & n0lll47)) | ((wire_nli1O_dataout & (wire_nli0i_dataout & (((~ wire_nli0O_dataout) & (~ wire_nli0l_dataout)) & n0liO50))) & n0lii53))) | ((wire_nli1l_dataout & n0l0O) & n0l0i56)) & ((wire_nli0i_dataout | (wire_nli0O_dataout | wire_nli0l_dataout)) | (~ n0l1l59))),
		n0O0O = ((~ wire_nli0O_dataout) & wire_nli0l_dataout),
		n0OiO = (wire_nli0O_dataout & (~ wire_nli0l_dataout)),
		n0OOl = (wire_nli1l_dataout & ((wire_nli0O_dataout ^ wire_nli0l_dataout) & ((wire_nli1O_dataout ^ wire_nli0i_dataout) ^ (~ n0OOO23)))),
		ni00i = ((wire_nli1l_dataout & ((wire_nli1O_dataout & ((wire_nli0i_dataout & ((~ wire_nli0O_dataout) & (~ wire_nli0l_dataout))) & ni1iO11)) & ni1ii14)) & ni10l17),
		ni00l = ((datain[6] ^ datain[7]) ^ (~ ni00O2)),
		ni01i = ((((~ wire_nlllO_dataout) & wire_nllll_dataout) & (~ wire_nllli_dataout)) & ni1ll8),
		ni01l = ((wire_nlllO_dataout & (~ wire_nllll_dataout)) & (~ wire_nllli_dataout)),
		ni01O = ((~ datain[5]) & ni00i),
		ni0iO = (ni00i | ((ni1OO & ni01l) & ni1Oi5)),
		ni0li = 1'b1,
		ni11l = (wire_nli1l_dataout & ((~ wire_nli1O_dataout) & (((~ wire_nli0i_dataout) & (wire_nli0O_dataout & wire_nli0l_dataout)) & ni11O20))),
		ni1OO = ((~ wire_nli1l_dataout) & n0l0O),
		patterndetect = n1i,
		rderr = n1O,
		syncstatus = n1l,
		tenBdata = {nlll, nlli, nliO, nlil, nlii, nl0O, nl0l, nl0i, nl1O, nl1l},
		valid = n0l,
		xgmctrldet = niii,
		xgmdataout = {nli, niO, nil, nii, n0O, nill, nili, niiO},
		xgmdatavalid = nlOi,
		xgmrunningdisp = nllO;
endmodule //altgxb_8b10b_decoder
//synopsys translate_on
//VALID FILE
///////////////////////////////////////////////////////////////////////////////
//
//                            DESKEW FIFO RAM MODULE
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1ns / 1ps

module deskew_ram_block (
    clk,
    reset, 
    addrwr,
    addrrd1,
    addrrd2,
    datain,
    we,
    re,
    dataout1,
    dataout2
    );

input       clk;
input       reset;
input   [15:0]  addrwr;
input   [15:0]  addrrd1;
input   [15:0]  addrrd2;
input   [13:0]  datain;
input       we, re;
output  [13:0]  dataout1;
output  [13:0]  dataout2;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 14;

reg [ram_width-1:0] dataout1_i, dataout2_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, ram_array_d_3,
            ram_array_d_4, ram_array_d_5, ram_array_d_6, ram_array_d_7,
            ram_array_d_8, ram_array_d_9, ram_array_d_10, ram_array_d_11,
            ram_array_d_12, ram_array_d_13, ram_array_d_14, ram_array_d_15,
            ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3,
            ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7,
            ram_array_q_8, ram_array_q_9, ram_array_q_10, ram_array_q_11,
            ram_array_q_12, ram_array_q_13, ram_array_q_14, ram_array_q_15;
wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
             data_reg_4, data_reg_5, data_reg_6, data_reg_7,
             data_reg_8, data_reg_9, data_reg_10, data_reg_11,
             data_reg_12, data_reg_13, data_reg_14, data_reg_15;

 /* Modelling the read port */
 /* Assuming address trigerred operation only */
//assignment
assign
    data_reg_0 = ( addrwr[0] == 1'b1 ) ? datain : ram_array_q_0,
    data_reg_1 = ( addrwr[1] == 1'b1 ) ? datain : ram_array_q_1,
    data_reg_2 = ( addrwr[2] == 1'b1 ) ? datain : ram_array_q_2,
    data_reg_3 = ( addrwr[3] == 1'b1 ) ? datain : ram_array_q_3,
    data_reg_4 = ( addrwr[4] == 1'b1 ) ? datain : ram_array_q_4,
    data_reg_5 = ( addrwr[5] == 1'b1 ) ? datain : ram_array_q_5,
    data_reg_6 = ( addrwr[6] == 1'b1 ) ? datain : ram_array_q_6,
    data_reg_7 = ( addrwr[7] == 1'b1 ) ? datain : ram_array_q_7,
    data_reg_8 = ( addrwr[8] == 1'b1 ) ? datain : ram_array_q_8,
    data_reg_9 = ( addrwr[9] == 1'b1 ) ? datain : ram_array_q_9,
    data_reg_10 = ( addrwr[10] == 1'b1 ) ? datain : ram_array_q_10,
    data_reg_11 = ( addrwr[11] == 1'b1 ) ? datain : ram_array_q_11,
    data_reg_12 = ( addrwr[12] == 1'b1 ) ? datain : ram_array_q_12,
    data_reg_13 = ( addrwr[13] == 1'b1 ) ? datain : ram_array_q_13,
    data_reg_14 = ( addrwr[14] == 1'b1 ) ? datain : ram_array_q_14,
    data_reg_15 = ( addrwr[15] == 1'b1 ) ? datain : ram_array_q_15;


assign #read_access_time dataout1 = re ? 13'b0000000000000 : dataout1_i;
assign #read_access_time dataout2 = re ? 13'b0000000000000 : dataout2_i;


always @(
    ram_array_q_0   or 
    ram_array_q_1   or 
    ram_array_q_2   or 
    ram_array_q_3   or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11      or 
    ram_array_q_12      or
    ram_array_q_13      or
    ram_array_q_14      or
    ram_array_q_15      or 
    addrrd1     or
    addrrd2     )
begin
    case ( addrrd1 )  // synopsys parallel_case full_case
    16'b0000000000000001 : dataout1_i = ram_array_q_0;
    16'b0000000000000010 : dataout1_i = ram_array_q_1;
    16'b0000000000000100 : dataout1_i = ram_array_q_2;
    16'b0000000000001000 : dataout1_i = ram_array_q_3;
    16'b0000000000010000 : dataout1_i = ram_array_q_4;
    16'b0000000000100000 : dataout1_i = ram_array_q_5;
    16'b0000000001000000 : dataout1_i = ram_array_q_6;
    16'b0000000010000000 : dataout1_i = ram_array_q_7;
    16'b0000000100000000 : dataout1_i = ram_array_q_8;
    16'b0000001000000000 : dataout1_i = ram_array_q_9;
    16'b0000010000000000 : dataout1_i = ram_array_q_10;
    16'b0000100000000000 : dataout1_i = ram_array_q_11;
    16'b0001000000000000 : dataout1_i = ram_array_q_12;
    16'b0010000000000000 : dataout1_i = ram_array_q_13;
    16'b0100000000000000 : dataout1_i = ram_array_q_14;
    16'b1000000000000000 : dataout1_i = ram_array_q_15;
    endcase

    case ( addrrd2 )  // synopsys parallel_case full_case
    16'b0000000000000001 : dataout2_i = ram_array_q_0;
    16'b0000000000000010 : dataout2_i = ram_array_q_1;
    16'b0000000000000100 : dataout2_i = ram_array_q_2;
    16'b0000000000001000 : dataout2_i = ram_array_q_3;
    16'b0000000000010000 : dataout2_i = ram_array_q_4;
    16'b0000000000100000 : dataout2_i = ram_array_q_5;
    16'b0000000001000000 : dataout2_i = ram_array_q_6;
    16'b0000000010000000 : dataout2_i = ram_array_q_7;
    16'b0000000100000000 : dataout2_i = ram_array_q_8;
    16'b0000001000000000 : dataout2_i = ram_array_q_9;
    16'b0000010000000000 : dataout2_i = ram_array_q_10;
    16'b0000100000000000 : dataout2_i = ram_array_q_11;
    16'b0001000000000000 : dataout2_i = ram_array_q_12;
    16'b0010000000000000 : dataout2_i = ram_array_q_13;
    16'b0100000000000000 : dataout2_i = ram_array_q_14;
    16'b1000000000000000 : dataout2_i = ram_array_q_15;
    endcase

end


/* Modelling the write port */
always @(posedge clk or posedge reset) 
begin
    if(reset) begin
    ram_array_q_0 <= #write_access_time 0;
    ram_array_q_1 <= #write_access_time 0;
    ram_array_q_2 <= #write_access_time 0; 
    ram_array_q_3 <= #write_access_time 0; 
        ram_array_q_4 <= #write_access_time 0;
        ram_array_q_5 <= #write_access_time 0;
        ram_array_q_6 <= #write_access_time 0;
        ram_array_q_7 <= #write_access_time 0; 
        ram_array_q_8 <= #write_access_time 0;
        ram_array_q_9 <= #write_access_time 0;
        ram_array_q_10 <= #write_access_time 0;
        ram_array_q_11 <= #write_access_time 0; 
        ram_array_q_12 <= #write_access_time 0;
        ram_array_q_13 <= #write_access_time 0;
        ram_array_q_14 <= #write_access_time 0;
        ram_array_q_15 <= #write_access_time 0; 
    end
    else begin
    ram_array_q_0 <= #write_access_time ram_array_d_0;
    ram_array_q_1 <= #write_access_time ram_array_d_1;
    ram_array_q_2 <= #write_access_time ram_array_d_2;
    ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
        ram_array_q_8 <= #write_access_time ram_array_d_8;
        ram_array_q_9 <= #write_access_time ram_array_d_9;
        ram_array_q_10 <= #write_access_time ram_array_d_10;
        ram_array_q_11 <= #write_access_time ram_array_d_11;
        ram_array_q_12 <= #write_access_time ram_array_d_12;
        ram_array_q_13 <= #write_access_time ram_array_d_13;
        ram_array_q_14 <= #write_access_time ram_array_d_14;
        ram_array_q_15 <= #write_access_time ram_array_d_15;
    end
end
         

always @( 
    we          or 
    data_reg_0      or 
    data_reg_1      or 
    data_reg_2      or 
    data_reg_3      or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    data_reg_8          or
    data_reg_9          or
    data_reg_10         or
    data_reg_11         or
    data_reg_12         or
    data_reg_13         or
    data_reg_14         or
    data_reg_15         or
    ram_array_q_0   or 
    ram_array_q_1   or
    ram_array_q_2   or
    ram_array_q_3   or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7   or
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11  or
    ram_array_q_12      or
    ram_array_q_13      or
    ram_array_q_14      or
    ram_array_q_15  )
begin
    if(we) begin
    ram_array_d_0 <= #write_access_time data_reg_0;
    ram_array_d_1 <= #write_access_time data_reg_1;
    ram_array_d_2 <= #write_access_time data_reg_2;
    ram_array_d_3 <= #write_access_time data_reg_3;
        ram_array_d_4 <= #write_access_time data_reg_4;
        ram_array_d_5 <= #write_access_time data_reg_5;
        ram_array_d_6 <= #write_access_time data_reg_6;
        ram_array_d_7 <= #write_access_time data_reg_7; 
        ram_array_d_8 <= #write_access_time data_reg_8;
        ram_array_d_9 <= #write_access_time data_reg_9;
        ram_array_d_10 <= #write_access_time data_reg_10;
        ram_array_d_11 <= #write_access_time data_reg_11; 
        ram_array_d_12 <= #write_access_time data_reg_12;
        ram_array_d_13 <= #write_access_time data_reg_13;
        ram_array_d_14 <= #write_access_time data_reg_14;
        ram_array_d_15 <= #write_access_time data_reg_15; 
    end
    else begin
    ram_array_d_0 <= #write_access_time ram_array_q_0;
    ram_array_d_1 <= #write_access_time ram_array_q_1;
    ram_array_d_2 <= #write_access_time ram_array_q_2;
    ram_array_d_3 <= #write_access_time ram_array_q_3;
        ram_array_d_4 <= #write_access_time ram_array_q_4;
        ram_array_d_5 <= #write_access_time ram_array_q_5;
        ram_array_d_6 <= #write_access_time ram_array_q_6;
        ram_array_d_7 <= #write_access_time ram_array_q_7;
        ram_array_d_8 <= #write_access_time ram_array_q_8;
        ram_array_d_9 <= #write_access_time ram_array_q_9;
        ram_array_d_10 <= #write_access_time ram_array_q_10;
        ram_array_d_11 <= #write_access_time ram_array_q_11;
        ram_array_d_12 <= #write_access_time ram_array_q_12;
        ram_array_d_13 <= #write_access_time ram_array_q_13;
        ram_array_d_14 <= #write_access_time ram_array_q_14;
        ram_array_d_15 <= #write_access_time ram_array_q_15;

    end
end

endmodule

//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = deskew_ram_block 1 lut 105 mux21 112 oper_add 1 
`timescale 1 ps / 1 ps
module  altgxb_deskew_fifo_rtl
	( 
	adetectdeskew,
	datain,
	dataout,
	dataoutpre,
	disperr,
	disperrin,
	disperrpre,
	enabledeskew,
	errdetect,
	errdetectin,
	errdetectpre,
	fiforesetrd,
	patterndetect,
	patterndetectin,
	patterndetectpre,
	readclock,
	reset,
	syncstatus,
	syncstatusin,
	syncstatuspre,
	wr_align,
	writeclock) /* synthesis synthesis_clearbox=1 */;
	output   adetectdeskew;
	input   [9:0]  datain;
	output   [9:0]  dataout;
	output   [9:0]  dataoutpre;
	output   disperr;
	input   disperrin;
	output   disperrpre;
	input   enabledeskew;
	output   errdetect;
	input   errdetectin;
	output   errdetectpre;
	input   fiforesetrd;
	output   patterndetect;
	input   patterndetectin;
	output   patterndetectpre;
	input   readclock;
	input   reset;
	output   syncstatus;
	input   syncstatusin;
	output   syncstatuspre;
	input   wr_align;
	input   writeclock;

	wire  [13:0]   wire_n0ill_dataout1;
	wire  [13:0]   wire_n0ill_dataout2;
	reg	n00li16;
	reg	n00li17;
	reg	n00li18;
	reg	n00lO13;
	reg	n00lO14;
	reg	n00lO15;
	reg	n00Oi10;
	reg	n00Oi11;
	reg	n00Oi12;
	reg	n0i0l4;
	reg	n0i0l5;
	reg	n0i0l6;
	reg	n0i1l7;
	reg	n0i1l8;
	reg	n0i1l9;
	reg	n0iii1;
	reg	n0iii2;
	reg	n0iii3;
	reg	n0ll;
	reg	ni0Ol;
	reg	ni0OO;
	reg	niliO;
	reg	nilli;
	reg	nilll;
	reg	nillO;
	reg	nilOi;
	reg	nilOl;
	reg	nilOO;
	reg	niO0i;
	reg	niO0l;
	reg	niO0O;
	reg	niO1i;
	reg	niO1l;
	reg	niO1O;
	reg	niOii;
	reg	niOil;
	reg	niOiO;
	reg	niOli;
	reg	niOll;
	reg	niOlO;
	reg	niOOi;
	reg	niOOl;
	reg	niOOO;
	reg	nl00i;
	reg	nl00l;
	reg	nl00O;
	reg	nl01i;
	reg	nl01l;
	reg	nl01O;
	reg	nl0ii;
	reg	nl0il;
	reg	nl0iO;
	reg	nl0li;
	reg	nl0ll;
	reg	nl0lO;
	reg	nl0Oi;
	reg	nl0Ol;
	reg	nl0OO;
	reg	nl10i;
	reg	nl10l;
	reg	nl10O;
	reg	nl11i;
	reg	nl11l;
	reg	nl11O;
	reg	nl1ii;
	reg	nl1il;
	reg	nl1iO;
	reg	nl1li;
	reg	nl1ll;
	reg	nl1lO;
	reg	nl1Oi;
	reg	nl1Ol;
	reg	nl1OO;
	reg	nli0i;
	reg	nli0l;
	reg	nli1i;
	reg	nli1l;
	reg	nli1O;
	reg	ni00l;
	reg	ni0ii;
	reg	ni00i;
	reg	ni01l;
	reg	ni01O;
	reg	ni0iO;
	reg	n0lO;
	reg	n0Oi;
	reg	n0Ol;
	reg	n0OO;
	reg	ni0i;
	reg	ni0l;
	reg	ni0li;
	reg	ni0O;
	reg	ni1i;
	reg	ni1l;
	reg	ni1O;
	reg	nii1i;
	reg	nii1l;
	reg	nii1O;
	reg	niii;
	reg	niil;
	reg	niiO;
	reg	nil0l;
	reg	nil1l;
	reg	nilil;
	reg	nill;
	wire	wire_n00i_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_ni_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nilii_dataout;
	wire	wire_nilO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli0O_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nliii_dataout;
	wire	wire_nliil_dataout;
	wire	wire_nliiO_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlili_dataout;
	wire	wire_nlill_dataout;
	wire	wire_nlilO_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliOi_dataout;
	wire	wire_nliOl_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO0l_dataout;
	wire	wire_nlO0O_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOO_dataout;
	wire  [4:0]   wire_nil1i_o;
	wire  n00Ol;
	wire  n00OO;
	wire  n0i0i;
	wire  n0i1i;

	deskew_ram_block   n0ill
	( 
	.addrrd1({n0ll, nli0l, nli0i, nli1O, nli1l, nli1i, nl0OO, nl0Ol, nl0Oi, nl0lO, nl0ll, nl0li, nl0iO, nl0il, nl0ii, ni0ii}),
	.addrrd2({nl00O, nl00l, nl00i, nl01O, nl01l, nl01i, nl1OO, nl1Ol, nl1Oi, nl1lO, nl1ll, nl1li, nl1iO, nl1il, ni00l, nl1ii}),
	.addrwr({ni0li, nill, niiO, niil, niii, ni0O, ni0l, ni0i, ni1O, ni1l, ni1i, n0OO, n0Ol, n0Oi, n0lO, ni0iO}),
	.clk(writeclock),
	.datain({patterndetectin, disperrin, syncstatusin, errdetectin, datain[9:0]}),
	.dataout1(wire_n0ill_dataout1),
	.dataout2(wire_n0ill_dataout2),
	.re(1'b0),
	.reset(reset),
	.we(1'b1));
	defparam
		n0ill.ram_width = 14,
		n0ill.read_access_time = 0,
		n0ill.write_access_time = 0;
	initial
		n00li16 = {1{1'b1}};
	always @ ( posedge readclock)
		  n00li16 <= n00li18;
	initial
		n00li17 = {1{1'b1}};
	always @ ( posedge readclock)
		  n00li17 <= (n00li18 ^ n00li16);
	initial
		n00li18 = 0;
	always @ ( posedge readclock)
		  n00li18 <= n00li16;
	initial
		n00lO13 = {1{1'b1}};
	always @ ( posedge readclock)
		  n00lO13 <= n00lO15;
	initial
		n00lO14 = {1{1'b1}};
	always @ ( posedge readclock)
		  n00lO14 <= (n00lO15 ^ n00lO13);
	initial
		n00lO15 = 0;
	always @ ( posedge readclock)
		  n00lO15 <= n00lO13;
	initial
		n00Oi10 = {1{1'b1}};
	always @ ( posedge readclock)
		  n00Oi10 <= n00Oi12;
	initial
		n00Oi11 = {1{1'b1}};
	always @ ( posedge readclock)
		  n00Oi11 <= (n00Oi12 ^ n00Oi10);
	initial
		n00Oi12 = 0;
	always @ ( posedge readclock)
		  n00Oi12 <= n00Oi10;
	initial
		n0i0l4 = {1{1'b1}};
	always @ ( posedge readclock)
		  n0i0l4 <= n0i0l6;
	initial
		n0i0l5 = {1{1'b1}};
	always @ ( posedge readclock)
		  n0i0l5 <= (n0i0l6 ^ n0i0l4);
	initial
		n0i0l6 = 0;
	always @ ( posedge readclock)
		  n0i0l6 <= n0i0l4;
	initial
		n0i1l7 = {1{1'b1}};
	always @ ( posedge readclock)
		  n0i1l7 <= n0i1l9;
	initial
		n0i1l8 = {1{1'b1}};
	always @ ( posedge readclock)
		  n0i1l8 <= (n0i1l9 ^ n0i1l7);
	initial
		n0i1l9 = 0;
	always @ ( posedge readclock)
		  n0i1l9 <= n0i1l7;
	initial
		n0iii1 = {1{1'b1}};
	always @ ( posedge readclock)
		  n0iii1 <= n0iii3;
	initial
		n0iii2 = {1{1'b1}};
	always @ ( posedge readclock)
		  n0iii2 <= (n0iii3 ^ n0iii1);
	initial
		n0iii3 = 0;
	always @ ( posedge readclock)
		  n0iii3 <= n0iii1;
	initial
	begin
		n0ll = 0;
		ni0Ol = 0;
		ni0OO = 0;
		niliO = 0;
		nilli = 0;
		nilll = 0;
		nillO = 0;
		nilOi = 0;
		nilOl = 0;
		nilOO = 0;
		niO0i = 0;
		niO0l = 0;
		niO0O = 0;
		niO1i = 0;
		niO1l = 0;
		niO1O = 0;
		niOii = 0;
		niOil = 0;
		niOiO = 0;
		niOli = 0;
		niOll = 0;
		niOlO = 0;
		niOOi = 0;
		niOOl = 0;
		niOOO = 0;
		nl00i = 0;
		nl00l = 0;
		nl00O = 0;
		nl01i = 0;
		nl01l = 0;
		nl01O = 0;
		nl0ii = 0;
		nl0il = 0;
		nl0iO = 0;
		nl0li = 0;
		nl0ll = 0;
		nl0lO = 0;
		nl0Oi = 0;
		nl0Ol = 0;
		nl0OO = 0;
		nl10i = 0;
		nl10l = 0;
		nl10O = 0;
		nl11i = 0;
		nl11l = 0;
		nl11O = 0;
		nl1ii = 0;
		nl1il = 0;
		nl1iO = 0;
		nl1li = 0;
		nl1ll = 0;
		nl1lO = 0;
		nl1Oi = 0;
		nl1Ol = 0;
		nl1OO = 0;
		nli0i = 0;
		nli0l = 0;
		nli1i = 0;
		nli1l = 0;
		nli1O = 0;
	end
	always @ ( posedge readclock or posedge reset)
	begin
		if (reset == 1'b1) 
		begin
			n0ll <= 0;
			ni0Ol <= 0;
			ni0OO <= 0;
			niliO <= 0;
			nilli <= 0;
			nilll <= 0;
			nillO <= 0;
			nilOi <= 0;
			nilOl <= 0;
			nilOO <= 0;
			niO0i <= 0;
			niO0l <= 0;
			niO0O <= 0;
			niO1i <= 0;
			niO1l <= 0;
			niO1O <= 0;
			niOii <= 0;
			niOil <= 0;
			niOiO <= 0;
			niOli <= 0;
			niOll <= 0;
			niOlO <= 0;
			niOOi <= 0;
			niOOl <= 0;
			niOOO <= 0;
			nl00i <= 0;
			nl00l <= 0;
			nl00O <= 0;
			nl01i <= 0;
			nl01l <= 0;
			nl01O <= 0;
			nl0ii <= 0;
			nl0il <= 0;
			nl0iO <= 0;
			nl0li <= 0;
			nl0ll <= 0;
			nl0lO <= 0;
			nl0Oi <= 0;
			nl0Ol <= 0;
			nl0OO <= 0;
			nl10i <= 0;
			nl10l <= 0;
			nl10O <= 0;
			nl11i <= 0;
			nl11l <= 0;
			nl11O <= 0;
			nl1ii <= 0;
			nl1il <= 0;
			nl1iO <= 0;
			nl1li <= 0;
			nl1ll <= 0;
			nl1lO <= 0;
			nl1Oi <= 0;
			nl1Ol <= 0;
			nl1OO <= 0;
			nli0i <= 0;
			nli0l <= 0;
			nli1i <= 0;
			nli1l <= 0;
			nli1O <= 0;
		end
		else 
		begin
			n0ll <= wire_nlOii_dataout;
			ni0Ol <= ni0OO;
			ni0OO <= nil0l;
			niliO <= wire_n0ill_dataout2[13];
			nilli <= wire_n0ill_dataout1[13];
			nilll <= wire_n0ill_dataout2[12];
			nillO <= wire_n0ill_dataout2[11];
			nilOi <= wire_n0ill_dataout2[10];
			nilOl <= wire_n0ill_dataout2[0];
			nilOO <= wire_n0ill_dataout2[1];
			niO0i <= wire_n0ill_dataout2[5];
			niO0l <= wire_n0ill_dataout2[6];
			niO0O <= wire_n0ill_dataout2[7];
			niO1i <= wire_n0ill_dataout2[2];
			niO1l <= wire_n0ill_dataout2[3];
			niO1O <= wire_n0ill_dataout2[4];
			niOii <= wire_n0ill_dataout2[8];
			niOil <= wire_n0ill_dataout2[9];
			niOiO <= wire_n0ill_dataout1[12];
			niOli <= wire_n0ill_dataout1[11];
			niOll <= wire_n0ill_dataout1[10];
			niOlO <= wire_n0ill_dataout1[0];
			niOOi <= wire_n0ill_dataout1[1];
			niOOl <= wire_n0ill_dataout1[2];
			niOOO <= wire_n0ill_dataout1[3];
			nl00i <= wire_nll0i_dataout;
			nl00l <= wire_nll0l_dataout;
			nl00O <= wire_nll0O_dataout;
			nl01i <= wire_nll1i_dataout;
			nl01l <= wire_nll1l_dataout;
			nl01O <= wire_nll1O_dataout;
			nl0ii <= wire_nllil_dataout;
			nl0il <= wire_nlliO_dataout;
			nl0iO <= wire_nllli_dataout;
			nl0li <= wire_nllll_dataout;
			nl0ll <= wire_nlllO_dataout;
			nl0lO <= wire_nllOi_dataout;
			nl0Oi <= wire_nllOl_dataout;
			nl0Ol <= wire_nllOO_dataout;
			nl0OO <= wire_nlO1i_dataout;
			nl10i <= wire_n0ill_dataout1[7];
			nl10l <= wire_n0ill_dataout1[8];
			nl10O <= wire_n0ill_dataout1[9];
			nl11i <= wire_n0ill_dataout1[4];
			nl11l <= wire_n0ill_dataout1[5];
			nl11O <= wire_n0ill_dataout1[6];
			nl1ii <= wire_nli0O_dataout;
			nl1il <= wire_nliil_dataout;
			nl1iO <= wire_nliiO_dataout;
			nl1li <= wire_nlili_dataout;
			nl1ll <= wire_nlill_dataout;
			nl1lO <= wire_nlilO_dataout;
			nl1Oi <= wire_nliOi_dataout;
			nl1Ol <= wire_nliOl_dataout;
			nl1OO <= wire_nliOO_dataout;
			nli0i <= wire_nlO0l_dataout;
			nli0l <= wire_nlO0O_dataout;
			nli1i <= wire_nlO1l_dataout;
			nli1l <= wire_nlO1O_dataout;
			nli1O <= wire_nlO0i_dataout;
		end
	end
	initial
	begin
		ni00l = 0;
		ni0ii = 0;
	end
	always @ ( posedge readclock or posedge reset)
	begin
		if (reset == 1'b1) 
		begin
			ni00l <= 1;
			ni0ii <= 1;
		end
		else 
		begin
			ni00l <= wire_nliii_dataout;
			ni0ii <= wire_nllii_dataout;
		end
	end
	initial
	begin
		ni00i = 0;
		ni01l = 0;
		ni01O = 0;
		ni0iO = 0;
	end
	always @ ( posedge writeclock or posedge reset)
	begin
		if (reset == 1'b1) 
		begin
			ni00i <= 1;
			ni01l <= 1;
			ni01O <= 1;
			ni0iO <= 1;
		end
		else 
		begin
			ni00i <= enabledeskew;
			ni01l <= ni01O;
			ni01O <= ni00i;
			ni0iO <= wire_nilO_dataout;
		end
	end
	initial
	begin
		n0lO = 0;
		n0Oi = 0;
		n0Ol = 0;
		n0OO = 0;
		ni0i = 0;
		ni0l = 0;
		ni0li = 0;
		ni0O = 0;
		ni1i = 0;
		ni1l = 0;
		ni1O = 0;
		nii1i = 0;
		nii1l = 0;
		nii1O = 0;
		niii = 0;
		niil = 0;
		niiO = 0;
		nil0l = 0;
		nil1l = 0;
		nilil = 0;
		nill = 0;
	end
	always @ ( posedge writeclock or posedge reset)
	begin
		if (reset == 1'b1) 
		begin
			n0lO <= 0;
			n0Oi <= 0;
			n0Ol <= 0;
			n0OO <= 0;
			ni0i <= 0;
			ni0l <= 0;
			ni0li <= 0;
			ni0O <= 0;
			ni1i <= 0;
			ni1l <= 0;
			ni1O <= 0;
			nii1i <= 0;
			nii1l <= 0;
			nii1O <= 0;
			niii <= 0;
			niil <= 0;
			niiO <= 0;
			nil0l <= 0;
			nil1l <= 0;
			nilil <= 0;
			nill <= 0;
		end
		else 
		begin
			n0lO <= wire_niOi_dataout;
			n0Oi <= wire_niOl_dataout;
			n0Ol <= wire_niOO_dataout;
			n0OO <= wire_nl1i_dataout;
			ni0i <= wire_nl0l_dataout;
			ni0l <= wire_nl0O_dataout;
			ni0li <= wire_nllO_dataout;
			ni0O <= wire_nlii_dataout;
			ni1i <= wire_nl1l_dataout;
			ni1l <= wire_nl1O_dataout;
			ni1O <= wire_nl0i_dataout;
			nii1i <= wire_nii0i_dataout;
			nii1l <= wire_nii0l_dataout;
			nii1O <= wire_nii0O_dataout;
			niii <= wire_nlil_dataout;
			niil <= wire_nliO_dataout;
			niiO <= wire_nlli_dataout;
			nil0l <= wire_nil1O_dataout;
			nil1l <= wire_niiii_dataout;
			nilil <= wire_nil0O_dataout;
			nill <= wire_nlll_dataout;
		end
	end
	and(wire_n00i_dataout, nl0OO, (~ enabledeskew));
	and(wire_n00l_dataout, nli1i, (~ enabledeskew));
	and(wire_n00O_dataout, nli1l, (~ enabledeskew));
	and(wire_n01i_dataout, nl0lO, (~ enabledeskew));
	and(wire_n01l_dataout, nl0Oi, (~ enabledeskew));
	and(wire_n01O_dataout, nl0Ol, (~ enabledeskew));
	assign		wire_n0i_dataout = (n0i1i === 1'b1) ? ni1i : ni1l;
	and(wire_n0ii_dataout, nli1O, (~ enabledeskew));
	and(wire_n0il_dataout, nli0i, (~ enabledeskew));
	and(wire_n0iO_dataout, nli0l, (~ enabledeskew));
	assign		wire_n0l_dataout = (n0i1i === 1'b1) ? ni1l : ni1O;
	assign		wire_n0O_dataout = (n0i1i === 1'b1) ? ni1O : ni0i;
	and(wire_n10i_dataout, nl01i, (~ enabledeskew));
	and(wire_n10l_dataout, nl01l, (~ enabledeskew));
	and(wire_n10O_dataout, nl01O, (~ enabledeskew));
	and(wire_n11i_dataout, nl1Oi, (~ enabledeskew));
	and(wire_n11l_dataout, nl1Ol, (~ enabledeskew));
	and(wire_n11O_dataout, nl1OO, (~ enabledeskew));
	assign		wire_n1i_dataout = (n0i1i === 1'b1) ? n0Oi : n0Ol;
	and(wire_n1ii_dataout, nl00i, (~ enabledeskew));
	and(wire_n1il_dataout, nl00l, (~ enabledeskew));
	or(wire_n1iO_dataout, n0ll, ~{(~ enabledeskew)});
	assign		wire_n1l_dataout = (n0i1i === 1'b1) ? n0Ol : n0OO;
	and(wire_n1li_dataout, ni0ii, (~ enabledeskew));
	and(wire_n1ll_dataout, nl0ii, (~ enabledeskew));
	and(wire_n1lO_dataout, nl0il, (~ enabledeskew));
	assign		wire_n1O_dataout = (n0i1i === 1'b1) ? n0OO : ni1i;
	and(wire_n1Oi_dataout, nl0iO, (~ enabledeskew));
	and(wire_n1Ol_dataout, nl0li, (~ enabledeskew));
	and(wire_n1OO_dataout, nl0ll, (~ enabledeskew));
	assign		wire_ni_dataout = (n0i1i === 1'b1) ? nill : ni0li;
	assign		wire_nii_dataout = (n0i1i === 1'b1) ? ni0i : ni0l;
	and(wire_nii0i_dataout, wire_niiil_dataout, ~{(~ ni01O)});
	and(wire_nii0l_dataout, wire_niiiO_dataout, ~{(~ ni01O)});
	and(wire_nii0O_dataout, wire_niili_dataout, ~{(~ ni01O)});
	and(wire_niiii_dataout, wire_niill_dataout, ~{(~ ni01O)});
	or(wire_niiil_dataout, wire_niilO_dataout, wr_align);
	and(wire_niiiO_dataout, wire_niiOi_dataout, ~{wr_align});
	and(wire_niili_dataout, wire_niiOl_dataout, ~{wr_align});
	or(wire_niill_dataout, wire_niiOO_dataout, wr_align);
	assign		wire_niilO_dataout = ((~ n00Ol) === 1'b1) ? wire_nil1i_o[1] : nii1i;
	assign		wire_niiOi_dataout = ((~ n00Ol) === 1'b1) ? wire_nil1i_o[2] : nii1l;
	assign		wire_niiOl_dataout = ((~ n00Ol) === 1'b1) ? wire_nil1i_o[3] : nii1O;
	assign		wire_niiOO_dataout = ((~ n00Ol) === 1'b1) ? wire_nil1i_o[4] : nil1l;
	assign		wire_nil_dataout = (n0i1i === 1'b1) ? ni0l : ni0O;
	and(wire_nil0i_dataout, nil0l, ~{n00Ol});
	and(wire_nil0O_dataout, wire_nilii_dataout, ~{n0i0i});
	or(wire_nil1O_dataout, wire_nil0i_dataout, wr_align);
	or(wire_nilii_dataout, nilil, wr_align);
	or(wire_nilO_dataout, wire_nlOi_dataout, n0i0i);
	assign		wire_niO_dataout = (n0i1i === 1'b1) ? ni0O : niii;
	and(wire_niOi_dataout, wire_nlOl_dataout, ~{n0i0i});
	and(wire_niOl_dataout, wire_nlOO_dataout, ~{n0i0i});
	and(wire_niOO_dataout, wire_n1i_dataout, ~{n0i0i});
	and(wire_nl0i_dataout, wire_n0l_dataout, ~{n0i0i});
	and(wire_nl0l_dataout, wire_n0O_dataout, ~{n0i0i});
	and(wire_nl0O_dataout, wire_nii_dataout, ~{n0i0i});
	and(wire_nl1i_dataout, wire_n1l_dataout, ~{n0i0i});
	and(wire_nl1l_dataout, wire_n1O_dataout, ~{n0i0i});
	and(wire_nl1O_dataout, wire_n0i_dataout, ~{n0i0i});
	assign		wire_nli_dataout = (n0i1i === 1'b1) ? niii : niil;
	and(wire_nli0O_dataout, wire_nlOil_dataout, ~{fiforesetrd});
	and(wire_nlii_dataout, wire_nil_dataout, ~{n0i0i});
	or(wire_nliii_dataout, wire_nlOiO_dataout, fiforesetrd);
	and(wire_nliil_dataout, wire_nlOli_dataout, ~{fiforesetrd});
	and(wire_nliiO_dataout, wire_nlOll_dataout, ~{fiforesetrd});
	and(wire_nlil_dataout, wire_niO_dataout, ~{n0i0i});
	and(wire_nlili_dataout, wire_nlOlO_dataout, ~{fiforesetrd});
	and(wire_nlill_dataout, wire_nlOOi_dataout, ~{fiforesetrd});
	and(wire_nlilO_dataout, wire_nlOOl_dataout, ~{fiforesetrd});
	and(wire_nliO_dataout, wire_nli_dataout, ~{n0i0i});
	and(wire_nliOi_dataout, wire_nlOOO_dataout, ~{fiforesetrd});
	and(wire_nliOl_dataout, wire_n11i_dataout, ~{fiforesetrd});
	and(wire_nliOO_dataout, wire_n11l_dataout, ~{fiforesetrd});
	assign		wire_nll_dataout = (n0i1i === 1'b1) ? niil : niiO;
	and(wire_nll0i_dataout, wire_n10O_dataout, ~{fiforesetrd});
	and(wire_nll0l_dataout, wire_n1ii_dataout, ~{fiforesetrd});
	and(wire_nll0O_dataout, wire_n1il_dataout, ~{fiforesetrd});
	and(wire_nll1i_dataout, wire_n11O_dataout, ~{fiforesetrd});
	and(wire_nll1l_dataout, wire_n10i_dataout, ~{fiforesetrd});
	and(wire_nll1O_dataout, wire_n10l_dataout, ~{fiforesetrd});
	and(wire_nlli_dataout, wire_nll_dataout, ~{n0i0i});
	or(wire_nllii_dataout, wire_n1iO_dataout, fiforesetrd);
	and(wire_nllil_dataout, wire_n1li_dataout, ~{fiforesetrd});
	and(wire_nlliO_dataout, wire_n1ll_dataout, ~{fiforesetrd});
	and(wire_nlll_dataout, wire_nlO_dataout, ~{n0i0i});
	and(wire_nllli_dataout, wire_n1lO_dataout, ~{fiforesetrd});
	and(wire_nllll_dataout, wire_n1Oi_dataout, ~{fiforesetrd});
	and(wire_nlllO_dataout, wire_n1Ol_dataout, ~{fiforesetrd});
	and(wire_nllO_dataout, wire_ni_dataout, ~{n0i0i});
	and(wire_nllOi_dataout, wire_n1OO_dataout, ~{fiforesetrd});
	and(wire_nllOl_dataout, wire_n01i_dataout, ~{fiforesetrd});
	and(wire_nllOO_dataout, wire_n01l_dataout, ~{fiforesetrd});
	assign		wire_nlO_dataout = (n0i1i === 1'b1) ? niiO : nill;
	and(wire_nlO0i_dataout, wire_n00O_dataout, ~{fiforesetrd});
	and(wire_nlO0l_dataout, wire_n0ii_dataout, ~{fiforesetrd});
	and(wire_nlO0O_dataout, wire_n0il_dataout, ~{fiforesetrd});
	and(wire_nlO1i_dataout, wire_n01O_dataout, ~{fiforesetrd});
	and(wire_nlO1l_dataout, wire_n00i_dataout, ~{fiforesetrd});
	and(wire_nlO1O_dataout, wire_n00l_dataout, ~{fiforesetrd});
	assign		wire_nlOi_dataout = (n0i1i === 1'b1) ? ni0li : ni0iO;
	and(wire_nlOii_dataout, wire_n0iO_dataout, ~{fiforesetrd});
	and(wire_nlOil_dataout, nl00O, (~ enabledeskew));
	or(wire_nlOiO_dataout, nl1ii, ~{(~ enabledeskew)});
	assign		wire_nlOl_dataout = (n0i1i === 1'b1) ? ni0iO : n0lO;
	and(wire_nlOli_dataout, ni00l, (~ enabledeskew));
	and(wire_nlOll_dataout, nl1il, (~ enabledeskew));
	and(wire_nlOlO_dataout, nl1iO, (~ enabledeskew));
	assign		wire_nlOO_dataout = (n0i1i === 1'b1) ? n0lO : n0Oi;
	and(wire_nlOOi_dataout, nl1li, (~ enabledeskew));
	and(wire_nlOOl_dataout, nl1ll, (~ enabledeskew));
	and(wire_nlOOO_dataout, nl1lO, (~ enabledeskew));
	oper_add   nil1i
	( 
	.a({(n00lO14 & nil1l), nii1O, nii1l, (n00Oi11 & nii1i), 1'b1}),
	.b({{3{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nil1i_o));
	defparam
		nil1i.sgate_representation = 0,
		nil1i.width_a = 5,
		nil1i.width_b = 5,
		nil1i.width_o = 5;
	assign
		adetectdeskew = ni0Ol,
		dataout = {nl10O, nl10l, nl10i, nl11O, nl11l, nl11i, niOOO, niOOl, niOOi, niOlO},
		dataoutpre = {niOil, niOii, niO0O, niO0l, niO0i, niO1O, niO1l, niO1i, nilOO, nilOl},
		disperr = niOiO,
		disperrpre = nilll,
		errdetect = niOll,
		errdetectpre = nilOi,
		n00Ol = (((((~ nil1l) & (~ nii1O)) & (~ nii1l)) & (~ nii1i)) & n00li17),
		n00OO = 1'b1,
		n0i0i = ((ni01O & ((ni0li & nilil) & n0iii2)) | ((ni01O & (~ ni01l)) & n0i0l5)),
		n0i1i = ((nilil | wr_align) | (~ n0i1l8)),
		patterndetect = nilli,
		patterndetectpre = niliO,
		syncstatus = niOli,
		syncstatuspre = nillO;
endmodule //altgxb_deskew_fifo_rtl
//synopsys translate_on
//VALID FILE
///////////////////////////////////////////////////////////////////////////////
//
//                            ALTGXB_DESKEW_FIFO
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1 ps/1 ps

   module altgxb_deskew_fifo
      (
       datain,
       errdetectin,
       syncstatusin,
       disperrin,   
       patterndetectin,   
       writeclock,  
       readclock,   
       adetectdeskew,
       fiforesetrd,
       enabledeskew,
       reset,
       dataout,      
       dataoutpre,      
       errdetect,    
       syncstatus,   
       disperr,
       patterndetect,
       errdetectpre,    
       syncstatuspre,
       disperrpre,
       patterndetectpre,
       rdalign
       );

   input [9:0] datain;        // encoded word
   input       errdetectin;   // From word aligner (if invalid_code)
   input       syncstatusin;  // From word aligner (not used)
   input       disperrin;     // From word aligner (not used)
   input       patterndetectin;
   input       writeclock;    // From recovered clock 
   input       readclock;     // From master clock
   input       fiforesetrd;   // reset read ptr 
   input       enabledeskew;  // enable the deskw fifo      
   input       reset;
   output [9:0] dataout;      // aligned data
   output [9:0] dataoutpre;   // aligned data
   output errdetect;          // straight output from invalid_code_in and synchronized with output
   output syncstatus;         // straight output from syncstatusin and synchronized with output
   output disperr;            // straight output from disperrin and synchronized with output
   output patterndetect;      // from word align 
   output errdetectpre;       // straight output from invalid_code_in and synchronized with output
   output syncstatuspre;      // straight output from syncstatusin and synchronized with output
   output disperrpre;         // straight output from disperrin and synchronized with output
   output patterndetectpre;   // from word align WARNING: CRITICAL TO ADD FUNCT
   output adetectdeskew;      // |A| is detected. It goes to input port adet of XGM_ATOM
   output rdalign;            // <deskew state machine |A| detect after read>
   
   parameter a = 10'b0011000011; //10'b0011110011;  - K28.3

   wire wr_align;
   wire wr_align_tmp;
   wire rdalign;
   wire rdalign_tmp;

   reg  enabledeskew_dly0;
   reg  enabledeskew_dly1;


   assign rdalign_tmp = ((dataout[9:0] == a) || (dataout[9:0] == ~a)) && ~disperr && ~errdetect;
   assign wr_align_tmp = ((datain[9:0] == a) || (datain[9:0] == ~a)) && enabledeskew_dly1 && ~disperrin && ~errdetectin;

   // filtering X
   assign wr_align = (wr_align_tmp === 1'b1) ? 1'b1 : 1'b0;
   assign rdalign = (rdalign_tmp === 1'b1) ? 1'b1 : 1'b0;

   
   // ENABLE DESKEW DELAY LOGIC - enable delay chain
   always@(posedge writeclock or posedge reset)
   begin
     if(reset)
        begin
           enabledeskew_dly0 <= 1'b1;
           enabledeskew_dly1 <= 1'b1;
        end 
     else
        begin
           enabledeskew_dly0 <= enabledeskew;
           enabledeskew_dly1 <= enabledeskew_dly0;
        end
   end 
   

   // instantiate core
   altgxb_deskew_fifo_rtl m_dskw_fifo_rtl
   (
       .wr_align(wr_align),
       .datain(datain),
       .errdetectin(errdetectin),
       .syncstatusin(syncstatusin),
       .disperrin(disperrin),   
       .patterndetectin(patterndetectin),   
       .writeclock(writeclock),  
       .readclock(readclock),   
       .fiforesetrd(fiforesetrd),
       .enabledeskew(enabledeskew),
       .reset(reset),
       .adetectdeskew(adetectdeskew),
       .dataout(dataout),      
       .dataoutpre(dataoutpre),      
       .errdetect(errdetect),    
       .syncstatus(syncstatus),   
       .disperr(disperr),
       .patterndetect(patterndetect),
       .errdetectpre(errdetectpre),    
       .syncstatuspre(syncstatuspre),
       .disperrpre(disperrpre),
       .patterndetectpre(patterndetectpre)
   );
      
endmodule

//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 289 mux21 301 oper_add 5 oper_decoder 10 oper_less_than 1 oper_selector 60 
`timescale 1 ps / 1 ps
module  altgxb_hssi_rx_wal_rtl
	( 
	A1A2_SIZE,
	AUTOBYTEALIGN_DIS,
	BITSLIP,
	cg_comma,
	DISABLE_RX_DISP,
	DWIDTH,
	encdet_prbs,
	ENCDT,
	GE_XAUI_SEL,
	IB_INVALID_CODE,
	LP10BEN,
	PMADATAWIDTH,
	prbs_en,
	PUDI,
	PUDR,
	rcvd_clk,
	RLV,
	RLV_EN,
	RLV_lt,
	RUNDISP_SEL,
	signal_detect,
	signal_detect_sync,
	soft_reset,
	SUDI,
	SUDI_pre,
	SYNC_COMP_PAT,
	SYNC_COMP_SIZE,
	sync_curr_st,
	SYNC_SM_DIS,
	sync_status) /* synthesis synthesis_clearbox=1 */;
	input   A1A2_SIZE;
	input   AUTOBYTEALIGN_DIS;
	input   BITSLIP;
	output   cg_comma;
	input   DISABLE_RX_DISP;
	input   DWIDTH;
	input   encdet_prbs;
	input   ENCDT;
	input   GE_XAUI_SEL;
	input   [1:0]  IB_INVALID_CODE;
	input   LP10BEN;
	input   PMADATAWIDTH;
	input   prbs_en;
	input   [9:0]  PUDI;
	input   [9:0]  PUDR;
	input   rcvd_clk;
	output   RLV;
	input   RLV_EN;
	output   RLV_lt;
	input   [4:0]  RUNDISP_SEL;
	input   signal_detect;
	output   signal_detect_sync;
	input   soft_reset;
	output   [12:0]  SUDI;
	output   [9:0]  SUDI_pre;
	input   [15:0]  SYNC_COMP_PAT;
	input   [1:0]  SYNC_COMP_SIZE;
	output   [3:0]  sync_curr_st;
	input   SYNC_SM_DIS;
	output   sync_status;

	reg	n1liiO58;
	reg	n1liiO59;
	reg	n1liiO60;
	reg	n1liOi55;
	reg	n1liOi56;
	reg	n1liOi57;
	reg	n1liOO52;
	reg	n1liOO53;
	reg	n1liOO54;
	reg	n1ll0i49;
	reg	n1ll0i50;
	reg	n1ll0i51;
	reg	n1ll0O46;
	reg	n1ll0O47;
	reg	n1ll0O48;
	reg	n1llil43;
	reg	n1llil44;
	reg	n1llil45;
	reg	n1lllO40;
	reg	n1lllO41;
	reg	n1lllO42;
	reg	n1llOl37;
	reg	n1llOl38;
	reg	n1llOl39;
	reg	n1lO1i34;
	reg	n1lO1i35;
	reg	n1lO1i36;
	reg	n1lO1O31;
	reg	n1lO1O32;
	reg	n1lO1O33;
	reg	n1lOli28;
	reg	n1lOli29;
	reg	n1lOli30;
	reg	n1lOll25;
	reg	n1lOll26;
	reg	n1lOll27;
	reg	n1lOlO22;
	reg	n1lOlO23;
	reg	n1lOlO24;
	reg	n1lOOi19;
	reg	n1lOOi20;
	reg	n1lOOi21;
	reg	n1lOOl16;
	reg	n1lOOl17;
	reg	n1lOOl18;
	reg	n1lOOO13;
	reg	n1lOOO14;
	reg	n1lOOO15;
	reg	n1O01i4;
	reg	n1O01i5;
	reg	n1O01i6;
	reg	n1O01O1;
	reg	n1O01O2;
	reg	n1O01O3;
	reg	n1O11i10;
	reg	n1O11i11;
	reg	n1O11i12;
	reg	n1O11O7;
	reg	n1O11O8;
	reg	n1O11O9;
	reg	n1i1i;
	reg	n1i1l;
	reg	n1i1O;
	reg	n1l1i;
	reg	n1lOl;
	reg	n1lOO;
	reg	n1O1i;
	reg	nil1O;
	reg	n01lil;
	reg	n01liO;
	reg	n01lli;
	reg	n01lll;
	reg	n01llO;
	reg	n01lOi;
	reg	n01lOl;
	reg	n01lOO;
	reg	n01O0i;
	reg	n01O0l;
	reg	n01O0O;
	reg	n01O1i;
	reg	n01O1l;
	reg	n01O1O;
	reg	n01Oii;
	reg	n1lll;
	reg	n1llO;
	reg	n1O0Oi;
	reg	n1O0Ol;
	reg	n1Oi1O;
	reg	ni0i0i;
	reg	ni0i0l;
	reg	ni0i0O;
	reg	ni0iii;
	reg	ni0iil;
	reg	ni0iiO;
	reg	ni0ili;
	reg	ni0lli;
	reg	ni0lll;
	reg	ni0llO;
	reg	ni0lOi;
	reg	ni0O0i;
	reg	ni0O0l;
	reg	ni0O0O;
	reg	ni0Oii;
	reg	ni1iOO;
	reg	ni1l0i;
	reg	ni1l0l;
	reg	ni1l0O;
	reg	ni1l1i;
	reg	ni1l1l;
	reg	ni1l1O;
	reg	ni1lii;
	reg	nii00O;
	reg	nii0ii;
	reg	nii0il;
	reg	nii0iO;
	reg	nii0li;
	reg	nii0ll;
	reg	nii0lO;
	reg	nii0Oi;
	reg	nii0Ol;
	reg	nii0OO;
	reg	niii0i;
	reg	niii0l;
	reg	niii1i;
	reg	niii1l;
	reg	niii1O;
	reg	niil0O;
	reg	niilii;
	reg	niilil;
	reg	niiliO;
	reg	niilli;
	reg	niilll;
	reg	niillO;
	reg	niilOi;
	reg	niilOl;
	reg	niilOO;
	reg	niiO0i;
	reg	niiO1i;
	reg	niiO1l;
	reg	niiO1O;
	reg	nil0i;
	reg	nil0l;
	reg	nil0O;
	reg	nilii;
	reg	nilil;
	reg	niliO;
	reg	nilli;
	reg	nilll;
	reg	nillO;
	reg	nilOl;
	reg	nlliOO;
	reg	nlll0i;
	reg	nlll0l;
	reg	nlll0O;
	reg	nlll1i;
	reg	nlllii;
	reg	nlllil;
	reg	nllliO;
	reg	nlllli;
	reg	nlllll;
	reg	nllllO;
	reg	nlllOi;
	reg	nlllOl;
	reg	nlllOO;
	reg	nllO0i;
	reg	nllO0l;
	reg	nllO0O;
	reg	nllO1i;
	reg	nllO1l;
	reg	nllO1O;
	reg	nllOii;
	reg	nllOil;
	reg	nllOiO;
	reg	nllOli;
	reg	nllOll;
	reg	nllOlO;
	reg	nllOOi;
	reg	nllOOl;
	reg	nllOOO;
	reg	nlO01i;
	reg	nlO01l;
	reg	nlO10i;
	reg	nlO10l;
	reg	nlO10O;
	reg	nlO11i;
	reg	nlO11l;
	reg	nlO11O;
	reg	nlO1ii;
	reg	nlO1il;
	reg	nlO1iO;
	reg	nlO1li;
	reg	nlO1ll;
	reg	nlO1lO;
	reg	nlO1Oi;
	reg	nlO1Ol;
	reg	nlO1OO;
	reg	nlOOiO;
	reg	nilOO;
	reg	niO1i;
	reg	niO1l;
	reg	nl1Oi;
	reg	nlliOl;
	reg	n1O0ll;
	reg	nlill;
	reg	nllili;
	reg	nllill;
	reg	nllilO;
	reg	nlliOi;
	reg	n1O0iO;
	reg	n1O0li;
	reg	ni1iOl;
	reg	nlliiO;
	reg	n00O0i;
	reg	n00O0l;
	reg	n00O0O;
	reg	n00O1l;
	reg	n00O1O;
	reg	n00Oii;
	reg	n00Oil;
	reg	n00OiO;
	reg	n00Oli;
	reg	n00Oll;
	reg	n00OlO;
	reg	n00OOi;
	reg	n00OOl;
	reg	n00OOO;
	reg	n01Oil;
	reg	n01OiO;
	reg	n01Oli;
	reg	n0i00i;
	reg	n0i00l;
	reg	n0i00O;
	reg	n0i0ii;
	reg	n0i0il;
	reg	n0i0iO;
	reg	n0i0li;
	reg	n0i0ll;
	reg	n0i11i;
	reg	n0i11l;
	reg	n10li;
	reg	n10ll;
	reg	n10lO;
	reg	n10Oi;
	reg	n10OO;
	reg	n111i;
	reg	n111l;
	reg	n111O;
	reg	n1l0i;
	reg	n1l0l;
	reg	n1l0O;
	reg	n1l1O;
	reg	n1lii;
	reg	n1lil;
	reg	n1liO;
	reg	n1lli;
	reg	n1lOi;
	reg	n1O0lO;
	reg	niO0i;
	reg	niO0l;
	reg	niO0O;
	reg	niO1O;
	reg	niOii;
	reg	niOil;
	reg	niOiO;
	reg	niOli;
	reg	niOll;
	reg	niOlO;
	reg	niOOi;
	reg	niOOl;
	reg	niOOO;
	reg	nl10i;
	reg	nl10l;
	reg	nl10O;
	reg	nl11i;
	reg	nl11l;
	reg	nl11O;
	reg	nl1ii;
	reg	nl1il;
	reg	nl1iO;
	reg	nl1li;
	reg	nl1ll;
	reg	nlilO;
	reg	nlllO;
	reg	nlOOli;
	reg	nlOOll;
	reg	nlOOlO;
	reg	nlOOOi;
	reg	nlOOOl;
	reg	nlOOOO;
	wire	wire_n0000i_dataout;
	wire	wire_n000i_dataout;
	wire	wire_n000ll_dataout;
	wire	wire_n001i_dataout;
	wire	wire_n001lO_dataout;
	wire	wire_n00i1O_dataout;
	wire	wire_n00ii_dataout;
	wire	wire_n00ili_dataout;
	wire	wire_n00l1l_dataout;
	wire	wire_n00li_dataout;
	wire	wire_n00liO_dataout;
	wire	wire_n00O1i_dataout;
	wire	wire_n00Oi_dataout;
	wire	wire_n0100i_dataout;
	wire	wire_n0100l_dataout;
	wire	wire_n0100O_dataout;
	wire	wire_n0101i_dataout;
	wire	wire_n0101O_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010ii_dataout;
	wire	wire_n010il_dataout;
	wire	wire_n010iO_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n0110i_dataout;
	wire	wire_n0110l_dataout;
	wire	wire_n0111i_dataout;
	wire	wire_n0111l_dataout;
	wire	wire_n0111O_dataout;
	wire	wire_n011ii_dataout;
	wire	wire_n011il_dataout;
	wire	wire_n011iO_dataout;
	wire	wire_n011l_dataout;
	wire	wire_n011li_dataout;
	wire	wire_n011ll_dataout;
	wire	wire_n011lO_dataout;
	wire	wire_n011O_dataout;
	wire	wire_n011Oi_dataout;
	wire	wire_n011Ol_dataout;
	wire	wire_n011OO_dataout;
	wire	wire_n01i0i_dataout;
	wire	wire_n01i1O_dataout;
	wire	wire_n01iii_dataout;
	wire	wire_n01iil_dataout;
	wire	wire_n01iiO_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01ili_dataout;
	wire	wire_n01ill_dataout;
	wire	wire_n01iOl_dataout;
	wire	wire_n01iOO_dataout;
	wire	wire_n01l0i_dataout;
	wire	wire_n01l0l_dataout;
	wire	wire_n01l0O_dataout;
	wire	wire_n01l1i_dataout;
	wire	wire_n01l1l_dataout;
	wire	wire_n01l1O_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01Oi_dataout;
	wire	wire_n0i0i_dataout;
	wire	wire_n0i0l_dataout;
	wire	wire_n0i0O_dataout;
	wire	wire_n0i1i_dataout;
	wire	wire_n0iii_dataout;
	wire	wire_n0iil_dataout;
	wire	wire_n0iiO_dataout;
	wire	wire_n0ili_dataout;
	wire	wire_n0ill_dataout;
	wire	wire_n0ilO_dataout;
	wire	wire_n0iOi_dataout;
	wire	wire_n0iOl_dataout;
	wire	wire_n0iOO_dataout;
	wire	wire_n0l0i_dataout;
	wire	wire_n0l0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0l1i_dataout;
	wire	wire_n0l1l_dataout;
	wire	wire_n0l1lO_dataout;
	wire	wire_n0l1O_dataout;
	wire	wire_n0lii_dataout;
	wire	wire_n0lil_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0lli_dataout;
	wire	wire_n0lll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lOi_dataout;
	wire	wire_n0lOl_dataout;
	wire	wire_n0lOO_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O0l_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1O_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Oil_dataout;
	wire	wire_n0OiO_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0Oll_dataout;
	wire	wire_n0OlO_dataout;
	wire	wire_n0OO1l_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n0OOO_dataout;
	wire	wire_n1i0i_dataout;
	wire	wire_n1i0l_dataout;
	wire	wire_n1i0O_dataout;
	wire	wire_n1iii_dataout;
	wire	wire_n1iil_dataout;
	wire	wire_n1iiO_dataout;
	wire	wire_n1ili_dataout;
	wire	wire_n1ill_dataout;
	wire	wire_n1O0OO_dataout;
	wire	wire_n1Oi1i_dataout;
	wire	wire_n1Oi1l_dataout;
	wire	wire_n1OO0l_dataout;
	wire	wire_n1OO0O_dataout;
	wire	wire_n1OOii_dataout;
	wire	wire_n1OOil_dataout;
	wire	wire_n1OOll_dataout;
	wire	wire_n1OOlO_dataout;
	wire	wire_n1OOOi_dataout;
	wire	wire_n1OOOO_dataout;
	wire	wire_ni000l_dataout;
	wire	wire_ni000O_dataout;
	wire	wire_ni001i_dataout;
	wire	wire_ni001l_dataout;
	wire	wire_ni00i_dataout;
	wire	wire_ni00ii_dataout;
	wire	wire_ni00il_dataout;
	wire	wire_ni00l_dataout;
	wire	wire_ni00li_dataout;
	wire	wire_ni00ll_dataout;
	wire	wire_ni00lO_dataout;
	wire	wire_ni00O_dataout;
	wire	wire_ni00Oi_dataout;
	wire	wire_ni00Ol_dataout;
	wire	wire_ni011i_dataout;
	wire	wire_ni01i_dataout;
	wire	wire_ni01iO_dataout;
	wire	wire_ni01l_dataout;
	wire	wire_ni01li_dataout;
	wire	wire_ni01ll_dataout;
	wire	wire_ni01lO_dataout;
	wire	wire_ni01O_dataout;
	wire	wire_ni01Oi_dataout;
	wire	wire_ni01Ol_dataout;
	wire	wire_ni01OO_dataout;
	wire	wire_ni0i1l_dataout;
	wire	wire_ni0i1O_dataout;
	wire	wire_ni0ii_dataout;
	wire	wire_ni0il_dataout;
	wire	wire_ni0ill_dataout;
	wire	wire_ni0ilO_dataout;
	wire	wire_ni0iO_dataout;
	wire	wire_ni0iOi_dataout;
	wire	wire_ni0iOl_dataout;
	wire	wire_ni0iOO_dataout;
	wire	wire_ni0l1i_dataout;
	wire	wire_ni0l1l_dataout;
	wire	wire_ni0l1O_dataout;
	wire	wire_ni0li_dataout;
	wire	wire_ni0ll_dataout;
	wire	wire_ni0lO_dataout;
	wire	wire_ni0lOl_dataout;
	wire	wire_ni0lOO_dataout;
	wire	wire_ni0O1i_dataout;
	wire	wire_ni0O1l_dataout;
	wire	wire_ni0Oi_dataout;
	wire	wire_ni0Ol_dataout;
	wire	wire_ni0OO_dataout;
	wire	wire_ni10i_dataout;
	wire	wire_ni10l_dataout;
	wire	wire_ni10O_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni11l_dataout;
	wire	wire_ni11O_dataout;
	wire	wire_ni1ii_dataout;
	wire	wire_ni1il_dataout;
	wire	wire_ni1iO_dataout;
	wire	wire_ni1li_dataout;
	wire	wire_ni1lil_dataout;
	wire	wire_ni1liO_dataout;
	wire	wire_ni1ll_dataout;
	wire	wire_ni1lli_dataout;
	wire	wire_ni1lll_dataout;
	wire	wire_ni1lO_dataout;
	wire	wire_ni1lOl_dataout;
	wire	wire_ni1lOO_dataout;
	wire	wire_ni1O1i_dataout;
	wire	wire_ni1O1l_dataout;
	wire	wire_ni1Oi_dataout;
	wire	wire_ni1Ol_dataout;
	wire	wire_ni1OO_dataout;
	wire	wire_ni1OOl_dataout;
	wire	wire_ni1OOO_dataout;
	wire	wire_nii00l_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii1i_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_niii0O_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiiii_dataout;
	wire	wire_niiiil_dataout;
	wire	wire_niiiiO_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiili_dataout;
	wire	wire_niiill_dataout;
	wire	wire_niiilO_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niiiOi_dataout;
	wire	wire_niiiOl_dataout;
	wire	wire_niiiOO_dataout;
	wire	wire_niil0i_dataout;
	wire	wire_niil0l_dataout;
	wire	wire_niil1i_dataout;
	wire	wire_niil1l_dataout;
	wire	wire_niil1O_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO0l_dataout;
	wire	wire_niiO0O_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOii_dataout;
	wire	wire_niiOil_dataout;
	wire	wire_niiOiO_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOli_dataout;
	wire	wire_niiOll_dataout;
	wire	wire_niiOlO_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_niiOOi_dataout;
	wire	wire_niiOOl_dataout;
	wire	wire_niiOOO_dataout;
	wire	wire_nil11i_dataout;
	wire	wire_nil11l_dataout;
	wire	wire_nil11O_dataout;
	wire	wire_nil1i_dataout;
	wire	wire_nl00i_dataout;
	wire	wire_nl00l_dataout;
	wire	wire_nl00O_dataout;
	wire	wire_nl01i_dataout;
	wire	wire_nl01l_dataout;
	wire	wire_nl01O_dataout;
	wire	wire_nl0ii_dataout;
	wire	wire_nl0il_dataout;
	wire	wire_nl0iO_dataout;
	wire	wire_nl0li_dataout;
	wire	wire_nl0ll_dataout;
	wire	wire_nl0lO_dataout;
	wire	wire_nl0Oi_dataout;
	wire	wire_nl0Ol_dataout;
	wire	wire_nl0OO_dataout;
	wire	wire_nl1Ol_dataout;
	wire	wire_nl1OO_dataout;
	wire	wire_nli0i_dataout;
	wire	wire_nli0l_dataout;
	wire	wire_nli0O_dataout;
	wire	wire_nli1i_dataout;
	wire	wire_nli1l_dataout;
	wire	wire_nli1O_dataout;
	wire	wire_nliii_dataout;
	wire	wire_nliil_dataout;
	wire	wire_nliiO_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nlO0lO_dataout;
	wire	wire_nlO0Oi_dataout;
	wire	wire_nlO0Ol_dataout;
	wire	wire_nlO0OO_dataout;
	wire	wire_nlOi0i_dataout;
	wire	wire_nlOi0l_dataout;
	wire	wire_nlOi0O_dataout;
	wire	wire_nlOi1i_dataout;
	wire	wire_nlOi1l_dataout;
	wire	wire_nlOi1O_dataout;
	wire	wire_nlOiii_dataout;
	wire	wire_nlOiil_dataout;
	wire	wire_nlOiiO_dataout;
	wire	wire_nlOili_dataout;
	wire	wire_nlOill_dataout;
	wire	wire_nlOilO_dataout;
	wire	wire_nlOiOi_dataout;
	wire	wire_nlOiOl_dataout;
	wire	wire_nlOiOO_dataout;
	wire	wire_nlOl0O_dataout;
	wire	wire_nlOl1i_dataout;
	wire	wire_nlOlii_dataout;
	wire	wire_nlOlil_dataout;
	wire	wire_nlOliO_dataout;
	wire	wire_nlOlli_dataout;
	wire	wire_nlOlll_dataout;
	wire	wire_nlOllO_dataout;
	wire	wire_nlOlOi_dataout;
	wire  [1:0]   wire_n0101l_o;
	wire  [4:0]   wire_n1ilO_o;
	wire  [5:0]   wire_ni0l0i_o;
	wire  [3:0]   wire_ni1llO_o;
	wire  [4:0]   wire_ni1lOi_o;
	wire  [3:0]   wire_n0001O_o;
	wire  [3:0]   wire_n000li_o;
	wire  [3:0]   wire_n001ll_o;
	wire  [3:0]   wire_n00i1l_o;
	wire  [3:0]   wire_n00iiO_o;
	wire  [3:0]   wire_n00l1i_o;
	wire  [3:0]   wire_n00lil_o;
	wire  [3:0]   wire_n00lOO_o;
	wire  [31:0]   wire_n10iO_o;
	wire  [3:0]   wire_nlOOil_o;
	wire  wire_ni0O1O_o;
	wire  wire_n0001i_o;
	wire  wire_n000il_o;
	wire  wire_n000OO_o;
	wire  wire_n001iO_o;
	wire  wire_n00iii_o;
	wire  wire_n00iOl_o;
	wire  wire_n00l0O_o;
	wire  wire_n00lOi_o;
	wire  wire_n100l_o;
	wire  wire_n100O_o;
	wire  wire_n110i_o;
	wire  wire_n110l_o;
	wire  wire_n110O_o;
	wire  wire_n11ii_o;
	wire  wire_n11il_o;
	wire  wire_n11iO_o;
	wire  wire_n11li_o;
	wire  wire_n11ll_o;
	wire  wire_n1Oi0i_o;
	wire  wire_n1Oi0l_o;
	wire  wire_n1Oiii_o;
	wire  wire_n1OiiO_o;
	wire  wire_n1Oili_o;
	wire  wire_n1Oill_o;
	wire  wire_n1OilO_o;
	wire  wire_n1OiOl_o;
	wire  wire_n1Ol0l_o;
	wire  wire_n1Ol1i_o;
	wire  wire_n1Ol1O_o;
	wire  wire_n1Olii_o;
	wire  wire_n1OliO_o;
	wire  wire_n1Olll_o;
	wire  wire_n1OlOi_o;
	wire  wire_n1OlOO_o;
	wire  wire_n1OO1l_o;
	wire  wire_n1OO1O_o;
	wire  wire_ni010i_o;
	wire  wire_ni010l_o;
	wire  wire_ni011l_o;
	wire  wire_ni01ii_o;
	wire  wire_ni1O0i_o;
	wire  wire_ni1O0l_o;
	wire  wire_ni1O0O_o;
	wire  wire_ni1Oii_o;
	wire  wire_ni1Oil_o;
	wire  wire_ni1OiO_o;
	wire  wire_ni1Oli_o;
	wire  wire_ni1Oll_o;
	wire  wire_nliOi_o;
	wire  wire_nliOl_o;
	wire  wire_nliOO_o;
	wire  wire_nll1i_o;
	wire  wire_nlOlOl_o;
	wire  wire_nlOlOO_o;
	wire  wire_nlOO0i_o;
	wire  wire_nlOO0l_o;
	wire  wire_nlOO0O_o;
	wire  wire_nlOO1i_o;
	wire  wire_nlOO1l_o;
	wire  wire_nlOO1O_o;
	wire  n1000i;
	wire  n1000l;
	wire  n1000O;
	wire  n1001i;
	wire  n1001l;
	wire  n1001O;
	wire  n100ii;
	wire  n100il;
	wire  n100iO;
	wire  n100li;
	wire  n100ll;
	wire  n100lO;
	wire  n100Oi;
	wire  n100Ol;
	wire  n100OO;
	wire  n1010i;
	wire  n1010l;
	wire  n1010O;
	wire  n1011i;
	wire  n1011l;
	wire  n1011O;
	wire  n101ii;
	wire  n101il;
	wire  n101iO;
	wire  n101li;
	wire  n101ll;
	wire  n101lO;
	wire  n101Oi;
	wire  n101Ol;
	wire  n101OO;
	wire  n10i0i;
	wire  n10i0l;
	wire  n10i0O;
	wire  n10i1i;
	wire  n10i1l;
	wire  n10i1O;
	wire  n10iii;
	wire  n10iil;
	wire  n10iiO;
	wire  n10ili;
	wire  n10ill;
	wire  n10ilO;
	wire  n10iOi;
	wire  n10iOl;
	wire  n10iOO;
	wire  n10l0i;
	wire  n10l0l;
	wire  n10l0O;
	wire  n10l1i;
	wire  n10l1l;
	wire  n10l1O;
	wire  n10lii;
	wire  n10lil;
	wire  n10liO;
	wire  n10lli;
	wire  n10lll;
	wire  n10llO;
	wire  n10lOi;
	wire  n10lOl;
	wire  n10lOO;
	wire  n10O0i;
	wire  n10O0l;
	wire  n10O0O;
	wire  n10O1i;
	wire  n10O1l;
	wire  n10O1O;
	wire  n10Oii;
	wire  n10Oil;
	wire  n10OiO;
	wire  n10Oli;
	wire  n10Oll;
	wire  n10OlO;
	wire  n10OOi;
	wire  n10OOl;
	wire  n10OOO;
	wire  n110Oi;
	wire  n110Ol;
	wire  n110OO;
	wire  n11i0i;
	wire  n11i0l;
	wire  n11i0O;
	wire  n11i1i;
	wire  n11i1l;
	wire  n11i1O;
	wire  n11iii;
	wire  n11iil;
	wire  n11iiO;
	wire  n11ili;
	wire  n11ill;
	wire  n11ilO;
	wire  n11iOi;
	wire  n11iOl;
	wire  n11iOO;
	wire  n11l0i;
	wire  n11l0l;
	wire  n11l0O;
	wire  n11l1i;
	wire  n11l1l;
	wire  n11l1O;
	wire  n11lii;
	wire  n11lil;
	wire  n11liO;
	wire  n11lli;
	wire  n11lll;
	wire  n11llO;
	wire  n11lOi;
	wire  n11lOl;
	wire  n11lOO;
	wire  n11O0i;
	wire  n11O0l;
	wire  n11O0O;
	wire  n11O1i;
	wire  n11O1l;
	wire  n11O1O;
	wire  n11Oii;
	wire  n11Oil;
	wire  n11OiO;
	wire  n11Oli;
	wire  n11Oll;
	wire  n11OlO;
	wire  n11OOi;
	wire  n11OOl;
	wire  n11OOO;
	wire  n1i00i;
	wire  n1i00l;
	wire  n1i00O;
	wire  n1i01i;
	wire  n1i01l;
	wire  n1i01O;
	wire  n1i0ii;
	wire  n1i0il;
	wire  n1i0iO;
	wire  n1i0li;
	wire  n1i0ll;
	wire  n1i0lO;
	wire  n1i0Oi;
	wire  n1i0Ol;
	wire  n1i0OO;
	wire  n1i10i;
	wire  n1i10l;
	wire  n1i10O;
	wire  n1i11i;
	wire  n1i11l;
	wire  n1i11O;
	wire  n1i1ii;
	wire  n1i1il;
	wire  n1i1iO;
	wire  n1i1li;
	wire  n1i1ll;
	wire  n1i1lO;
	wire  n1i1Oi;
	wire  n1i1Ol;
	wire  n1i1OO;
	wire  n1ii0i;
	wire  n1ii0l;
	wire  n1ii0O;
	wire  n1ii1i;
	wire  n1ii1l;
	wire  n1ii1O;
	wire  n1iiii;
	wire  n1iiil;
	wire  n1iiiO;
	wire  n1iili;
	wire  n1iill;
	wire  n1iilO;
	wire  n1iiOi;
	wire  n1iiOl;
	wire  n1iiOO;
	wire  n1il0i;
	wire  n1il0l;
	wire  n1il0O;
	wire  n1il1i;
	wire  n1il1l;
	wire  n1il1O;
	wire  n1ilii;
	wire  n1ilil;
	wire  n1iliO;
	wire  n1illi;
	wire  n1illl;
	wire  n1illO;
	wire  n1ilOi;
	wire  n1ilOl;
	wire  n1ilOO;
	wire  n1iO0i;
	wire  n1iO0l;
	wire  n1iO0O;
	wire  n1iO1i;
	wire  n1iO1l;
	wire  n1iO1O;
	wire  n1iOii;
	wire  n1iOil;
	wire  n1iOiO;
	wire  n1iOli;
	wire  n1iOll;
	wire  n1iOlO;
	wire  n1iOOi;
	wire  n1iOOl;
	wire  n1iOOO;
	wire  n1l00i;
	wire  n1l00l;
	wire  n1l00O;
	wire  n1l01i;
	wire  n1l01l;
	wire  n1l01O;
	wire  n1l0ii;
	wire  n1l0il;
	wire  n1l0iO;
	wire  n1l0li;
	wire  n1l0ll;
	wire  n1l0lO;
	wire  n1l0Oi;
	wire  n1l0Ol;
	wire  n1l0OO;
	wire  n1l10i;
	wire  n1l10l;
	wire  n1l10O;
	wire  n1l11i;
	wire  n1l11l;
	wire  n1l11O;
	wire  n1l1ii;
	wire  n1l1il;
	wire  n1l1iO;
	wire  n1l1li;
	wire  n1l1ll;
	wire  n1l1lO;
	wire  n1l1Oi;
	wire  n1l1Ol;
	wire  n1l1OO;
	wire  n1li0i;
	wire  n1li0l;
	wire  n1li0O;
	wire  n1li1i;
	wire  n1li1l;
	wire  n1li1O;
	wire  n1liii;
	wire  n1liil;
	wire  n1lill;
	wire  n1lilO;
	wire  n1ll1l;
	wire  n1ll1O;
	wire  n1llli;
	wire  n1llll;
	wire  n1lO0l;
	wire  n1lO0O;
	wire  n1lOii;
	wire  n1lOil;
	wire  n1lOiO;
	wire  n1O0ii;
	wire  n1O10l;
	wire  n1O10O;
	wire  n1O11l;
	wire  n1O1ii;
	wire  n1O1il;
	wire  n1O1iO;
	wire  n1O1li;
	wire  n1O1ll;
	wire  n1O1lO;
	wire  n1O1Oi;
	wire  n1O1Ol;
	wire  n1O1OO;

	initial
		n1liiO58 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1liiO58 <= n1liiO60;
	initial
		n1liiO59 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1liiO59 <= (n1liiO60 ^ n1liiO58);
	initial
		n1liiO60 = 0;
	always @ ( posedge rcvd_clk)
		  n1liiO60 <= n1liiO58;
	initial
		n1liOi55 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1liOi55 <= n1liOi57;
	initial
		n1liOi56 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1liOi56 <= (n1liOi57 ^ n1liOi55);
	initial
		n1liOi57 = 0;
	always @ ( posedge rcvd_clk)
		  n1liOi57 <= n1liOi55;
	initial
		n1liOO52 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1liOO52 <= n1liOO54;
	initial
		n1liOO53 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1liOO53 <= (n1liOO54 ^ n1liOO52);
	initial
		n1liOO54 = 0;
	always @ ( posedge rcvd_clk)
		  n1liOO54 <= n1liOO52;
	initial
		n1ll0i49 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1ll0i49 <= n1ll0i51;
	initial
		n1ll0i50 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1ll0i50 <= (n1ll0i51 ^ n1ll0i49);
	initial
		n1ll0i51 = 0;
	always @ ( posedge rcvd_clk)
		  n1ll0i51 <= n1ll0i49;
	initial
		n1ll0O46 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1ll0O46 <= n1ll0O48;
	initial
		n1ll0O47 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1ll0O47 <= (n1ll0O48 ^ n1ll0O46);
	initial
		n1ll0O48 = 0;
	always @ ( posedge rcvd_clk)
		  n1ll0O48 <= n1ll0O46;
	initial
		n1llil43 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1llil43 <= n1llil45;
	initial
		n1llil44 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1llil44 <= (n1llil45 ^ n1llil43);
	initial
		n1llil45 = 0;
	always @ ( posedge rcvd_clk)
		  n1llil45 <= n1llil43;
	initial
		n1lllO40 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lllO40 <= n1lllO42;
	initial
		n1lllO41 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lllO41 <= (n1lllO42 ^ n1lllO40);
	initial
		n1lllO42 = 0;
	always @ ( posedge rcvd_clk)
		  n1lllO42 <= n1lllO40;
	initial
		n1llOl37 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1llOl37 <= n1llOl39;
	initial
		n1llOl38 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1llOl38 <= (n1llOl39 ^ n1llOl37);
	initial
		n1llOl39 = 0;
	always @ ( posedge rcvd_clk)
		  n1llOl39 <= n1llOl37;
	initial
		n1lO1i34 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lO1i34 <= n1lO1i36;
	initial
		n1lO1i35 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lO1i35 <= (n1lO1i36 ^ n1lO1i34);
	initial
		n1lO1i36 = 0;
	always @ ( posedge rcvd_clk)
		  n1lO1i36 <= n1lO1i34;
	initial
		n1lO1O31 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lO1O31 <= n1lO1O33;
	initial
		n1lO1O32 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lO1O32 <= (n1lO1O33 ^ n1lO1O31);
	initial
		n1lO1O33 = 0;
	always @ ( posedge rcvd_clk)
		  n1lO1O33 <= n1lO1O31;
	initial
		n1lOli28 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lOli28 <= n1lOli30;
	initial
		n1lOli29 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lOli29 <= (n1lOli30 ^ n1lOli28);
	initial
		n1lOli30 = 0;
	always @ ( posedge rcvd_clk)
		  n1lOli30 <= n1lOli28;
	initial
		n1lOll25 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lOll25 <= n1lOll27;
	initial
		n1lOll26 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lOll26 <= (n1lOll27 ^ n1lOll25);
	initial
		n1lOll27 = 0;
	always @ ( posedge rcvd_clk)
		  n1lOll27 <= n1lOll25;
	initial
		n1lOlO22 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lOlO22 <= n1lOlO24;
	initial
		n1lOlO23 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lOlO23 <= (n1lOlO24 ^ n1lOlO22);
	initial
		n1lOlO24 = 0;
	always @ ( posedge rcvd_clk)
		  n1lOlO24 <= n1lOlO22;
	initial
		n1lOOi19 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lOOi19 <= n1lOOi21;
	initial
		n1lOOi20 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lOOi20 <= (n1lOOi21 ^ n1lOOi19);
	initial
		n1lOOi21 = 0;
	always @ ( posedge rcvd_clk)
		  n1lOOi21 <= n1lOOi19;
	initial
		n1lOOl16 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lOOl16 <= n1lOOl18;
	initial
		n1lOOl17 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lOOl17 <= (n1lOOl18 ^ n1lOOl16);
	initial
		n1lOOl18 = 0;
	always @ ( posedge rcvd_clk)
		  n1lOOl18 <= n1lOOl16;
	initial
		n1lOOO13 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lOOO13 <= n1lOOO15;
	initial
		n1lOOO14 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1lOOO14 <= (n1lOOO15 ^ n1lOOO13);
	initial
		n1lOOO15 = 0;
	always @ ( posedge rcvd_clk)
		  n1lOOO15 <= n1lOOO13;
	initial
		n1O01i4 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1O01i4 <= n1O01i6;
	initial
		n1O01i5 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1O01i5 <= (n1O01i6 ^ n1O01i4);
	initial
		n1O01i6 = 0;
	always @ ( posedge rcvd_clk)
		  n1O01i6 <= n1O01i4;
	initial
		n1O01O1 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1O01O1 <= n1O01O3;
	initial
		n1O01O2 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1O01O2 <= (n1O01O3 ^ n1O01O1);
	initial
		n1O01O3 = 0;
	always @ ( posedge rcvd_clk)
		  n1O01O3 <= n1O01O1;
	initial
		n1O11i10 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1O11i10 <= n1O11i12;
	initial
		n1O11i11 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1O11i11 <= (n1O11i12 ^ n1O11i10);
	initial
		n1O11i12 = 0;
	always @ ( posedge rcvd_clk)
		  n1O11i12 <= n1O11i10;
	initial
		n1O11O7 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1O11O7 <= n1O11O9;
	initial
		n1O11O8 = {1{1'b1}};
	always @ ( posedge rcvd_clk)
		  n1O11O8 <= (n1O11O9 ^ n1O11O7);
	initial
		n1O11O9 = 0;
	always @ ( posedge rcvd_clk)
		  n1O11O9 <= n1O11O7;
	initial
	begin
		n1i1i = 0;
		n1i1l = 0;
		n1i1O = 0;
		n1l1i = 0;
	end
	always @ ( negedge rcvd_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1i1i <= 0;
			n1i1l <= 0;
			n1i1O <= 0;
			n1l1i <= 0;
		end
		else if  (n10ll == 1'b1) 
		begin
			n1i1i <= wire_n1i0i_dataout;
			n1i1l <= wire_n1i0l_dataout;
			n1i1O <= wire_n1i0O_dataout;
			n1l1i <= wire_n1iii_dataout;
		end
	end
	initial
	begin
		n1lOl = 0;
		n1lOO = 0;
		n1O1i = 0;
		nil1O = 0;
	end
	always @ ( negedge rcvd_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1lOl <= 0;
			n1lOO <= 0;
			n1O1i <= 0;
			nil1O <= 0;
		end
		else if  (n1lOiO == 1'b1) 
		begin
			n1lOl <= (~ n1O10l);
			n1lOO <= n1O10O;
			n1O1i <= n1O1ii;
			nil1O <= n1O1il;
		end
	end
	initial
	begin
		n01lil = 0;
		n01liO = 0;
		n01lli = 0;
		n01lll = 0;
		n01llO = 0;
		n01lOi = 0;
		n01lOl = 0;
		n01lOO = 0;
		n01O0i = 0;
		n01O0l = 0;
		n01O0O = 0;
		n01O1i = 0;
		n01O1l = 0;
		n01O1O = 0;
		n01Oii = 0;
		n1lll = 0;
		n1llO = 0;
		n1O0Oi = 0;
		n1O0Ol = 0;
		n1Oi1O = 0;
		ni0i0i = 0;
		ni0i0l = 0;
		ni0i0O = 0;
		ni0iii = 0;
		ni0iil = 0;
		ni0iiO = 0;
		ni0ili = 0;
		ni0lli = 0;
		ni0lll = 0;
		ni0llO = 0;
		ni0lOi = 0;
		ni0O0i = 0;
		ni0O0l = 0;
		ni0O0O = 0;
		ni0Oii = 0;
		ni1iOO = 0;
		ni1l0i = 0;
		ni1l0l = 0;
		ni1l0O = 0;
		ni1l1i = 0;
		ni1l1l = 0;
		ni1l1O = 0;
		ni1lii = 0;
		nii00O = 0;
		nii0ii = 0;
		nii0il = 0;
		nii0iO = 0;
		nii0li = 0;
		nii0ll = 0;
		nii0lO = 0;
		nii0Oi = 0;
		nii0Ol = 0;
		nii0OO = 0;
		niii0i = 0;
		niii0l = 0;
		niii1i = 0;
		niii1l = 0;
		niii1O = 0;
		niil0O = 0;
		niilii = 0;
		niilil = 0;
		niiliO = 0;
		niilli = 0;
		niilll = 0;
		niillO = 0;
		niilOi = 0;
		niilOl = 0;
		niilOO = 0;
		niiO0i = 0;
		niiO1i = 0;
		niiO1l = 0;
		niiO1O = 0;
		nil0i = 0;
		nil0l = 0;
		nil0O = 0;
		nilii = 0;
		nilil = 0;
		niliO = 0;
		nilli = 0;
		nilll = 0;
		nillO = 0;
		nilOl = 0;
		nlliOO = 0;
		nlll0i = 0;
		nlll0l = 0;
		nlll0O = 0;
		nlll1i = 0;
		nlllii = 0;
		nlllil = 0;
		nllliO = 0;
		nlllli = 0;
		nlllll = 0;
		nllllO = 0;
		nlllOi = 0;
		nlllOl = 0;
		nlllOO = 0;
		nllO0i = 0;
		nllO0l = 0;
		nllO0O = 0;
		nllO1i = 0;
		nllO1l = 0;
		nllO1O = 0;
		nllOii = 0;
		nllOil = 0;
		nllOiO = 0;
		nllOli = 0;
		nllOll = 0;
		nllOlO = 0;
		nllOOi = 0;
		nllOOl = 0;
		nllOOO = 0;
		nlO01i = 0;
		nlO01l = 0;
		nlO10i = 0;
		nlO10l = 0;
		nlO10O = 0;
		nlO11i = 0;
		nlO11l = 0;
		nlO11O = 0;
		nlO1ii = 0;
		nlO1il = 0;
		nlO1iO = 0;
		nlO1li = 0;
		nlO1ll = 0;
		nlO1lO = 0;
		nlO1Oi = 0;
		nlO1Ol = 0;
		nlO1OO = 0;
		nlOOiO = 0;
	end
	always @ ( posedge rcvd_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n01lil <= 0;
			n01liO <= 0;
			n01lli <= 0;
			n01lll <= 0;
			n01llO <= 0;
			n01lOi <= 0;
			n01lOl <= 0;
			n01lOO <= 0;
			n01O0i <= 0;
			n01O0l <= 0;
			n01O0O <= 0;
			n01O1i <= 0;
			n01O1l <= 0;
			n01O1O <= 0;
			n01Oii <= 0;
			n1lll <= 0;
			n1llO <= 0;
			n1O0Oi <= 0;
			n1O0Ol <= 0;
			n1Oi1O <= 0;
			ni0i0i <= 0;
			ni0i0l <= 0;
			ni0i0O <= 0;
			ni0iii <= 0;
			ni0iil <= 0;
			ni0iiO <= 0;
			ni0ili <= 0;
			ni0lli <= 0;
			ni0lll <= 0;
			ni0llO <= 0;
			ni0lOi <= 0;
			ni0O0i <= 0;
			ni0O0l <= 0;
			ni0O0O <= 0;
			ni0Oii <= 0;
			ni1iOO <= 0;
			ni1l0i <= 0;
			ni1l0l <= 0;
			ni1l0O <= 0;
			ni1l1i <= 0;
			ni1l1l <= 0;
			ni1l1O <= 0;
			ni1lii <= 0;
			nii00O <= 0;
			nii0ii <= 0;
			nii0il <= 0;
			nii0iO <= 0;
			nii0li <= 0;
			nii0ll <= 0;
			nii0lO <= 0;
			nii0Oi <= 0;
			nii0Ol <= 0;
			nii0OO <= 0;
			niii0i <= 0;
			niii0l <= 0;
			niii1i <= 0;
			niii1l <= 0;
			niii1O <= 0;
			niil0O <= 0;
			niilii <= 0;
			niilil <= 0;
			niiliO <= 0;
			niilli <= 0;
			niilll <= 0;
			niillO <= 0;
			niilOi <= 0;
			niilOl <= 0;
			niilOO <= 0;
			niiO0i <= 0;
			niiO1i <= 0;
			niiO1l <= 0;
			niiO1O <= 0;
			nil0i <= 0;
			nil0l <= 0;
			nil0O <= 0;
			nilii <= 0;
			nilil <= 0;
			niliO <= 0;
			nilli <= 0;
			nilll <= 0;
			nillO <= 0;
			nilOl <= 0;
			nlliOO <= 0;
			nlll0i <= 0;
			nlll0l <= 0;
			nlll0O <= 0;
			nlll1i <= 0;
			nlllii <= 0;
			nlllil <= 0;
			nllliO <= 0;
			nlllli <= 0;
			nlllll <= 0;
			nllllO <= 0;
			nlllOi <= 0;
			nlllOl <= 0;
			nlllOO <= 0;
			nllO0i <= 0;
			nllO0l <= 0;
			nllO0O <= 0;
			nllO1i <= 0;
			nllO1l <= 0;
			nllO1O <= 0;
			nllOii <= 0;
			nllOil <= 0;
			nllOiO <= 0;
			nllOli <= 0;
			nllOll <= 0;
			nllOlO <= 0;
			nllOOi <= 0;
			nllOOl <= 0;
			nllOOO <= 0;
			nlO01i <= 0;
			nlO01l <= 0;
			nlO10i <= 0;
			nlO10l <= 0;
			nlO10O <= 0;
			nlO11i <= 0;
			nlO11l <= 0;
			nlO11O <= 0;
			nlO1ii <= 0;
			nlO1il <= 0;
			nlO1iO <= 0;
			nlO1li <= 0;
			nlO1ll <= 0;
			nlO1lO <= 0;
			nlO1Oi <= 0;
			nlO1Ol <= 0;
			nlO1OO <= 0;
			nlOOiO <= 0;
		end
		else 
		begin
			n01lil <= wire_n1Oi0l_o;
			n01liO <= wire_n1OilO_o;
			n01lli <= wire_n1Ol1i_o;
			n01lll <= wire_n1Ol0l_o;
			n01llO <= wire_n1OiOl_o;
			n01lOi <= wire_n1Ol1O_o;
			n01lOl <= wire_n1Olii_o;
			n01lOO <= wire_n1OliO_o;
			n01O0i <= wire_n1OlOO_o;
			n01O0l <= wire_n1OO1O_o;
			n01O0O <= ((~ SYNC_SM_DIS) & (LP10BEN | signal_detect));
			n01O1i <= wire_n1OlOi_o;
			n01O1l <= wire_n1Olll_o;
			n01O1O <= wire_n1OO1l_o;
			n01Oii <= n01O0O;
			n1lll <= n1l0i;
			n1llO <= n1lOi;
			n1O0Oi <= wire_n1Oiii_o;
			n1O0Ol <= wire_n1Oili_o;
			n1Oi1O <= wire_n1Oi0i_o;
			ni0i0i <= wire_ni1lll_dataout;
			ni0i0l <= wire_ni1OOl_dataout;
			ni0i0O <= wire_ni011i_dataout;
			ni0iii <= wire_ni010i_o;
			ni0iil <= wire_ni010l_o;
			ni0iiO <= wire_ni1OOO_dataout;
			ni0ili <= wire_ni011l_o;
			ni0lli <= wire_ni01ii_o;
			ni0lll <= wire_ni0lOl_dataout;
			ni0llO <= wire_ni0lOO_dataout;
			ni0lOi <= wire_ni0O1i_dataout;
			ni0O0i <= wire_ni0O1l_dataout;
			ni0O0l <= ni0O0O;
			ni0O0O <= (niilii | nii0ii);
			ni0Oii <= nii00O;
			ni1iOO <= wire_nil11O_dataout;
			ni1l0i <= wire_ni1lOi_o[3];
			ni1l0l <= wire_ni1lil_dataout;
			ni1l0O <= wire_ni1liO_dataout;
			ni1l1i <= wire_ni1lOi_o[0];
			ni1l1l <= wire_ni1lOi_o[1];
			ni1l1O <= wire_ni1lOi_o[2];
			ni1lii <= wire_ni1lli_dataout;
			nii00O <= RLV_EN;
			nii0ii <= wire_niii0O_dataout;
			nii0il <= wire_niiiii_dataout;
			nii0iO <= wire_niiiil_dataout;
			nii0li <= wire_niiiiO_dataout;
			nii0ll <= wire_niiili_dataout;
			nii0lO <= wire_niiill_dataout;
			nii0Oi <= wire_niiilO_dataout;
			nii0Ol <= wire_niiiOi_dataout;
			nii0OO <= wire_niiiOl_dataout;
			niii0i <= wire_niil1O_dataout;
			niii0l <= wire_niil0i_dataout;
			niii1i <= wire_niiiOO_dataout;
			niii1l <= wire_niil1i_dataout;
			niii1O <= wire_niil1l_dataout;
			niil0O <= wire_niil0l_dataout;
			niilii <= wire_niiO0l_dataout;
			niilil <= wire_niiO0O_dataout;
			niiliO <= wire_niiOii_dataout;
			niilli <= wire_niiOil_dataout;
			niilll <= wire_niiOiO_dataout;
			niillO <= wire_niiOli_dataout;
			niilOi <= wire_niiOll_dataout;
			niilOl <= wire_niiOlO_dataout;
			niilOO <= wire_niiOOi_dataout;
			niiO0i <= wire_nil11l_dataout;
			niiO1i <= wire_niiOOl_dataout;
			niiO1l <= wire_niiOOO_dataout;
			niiO1O <= wire_nil11i_dataout;
			nil0i <= nl10i;
			nil0l <= nl10l;
			nil0O <= nl10O;
			nilii <= nl1ii;
			nilil <= nl1il;
			niliO <= nl1iO;
			nilli <= nl1li;
			nilll <= nl1ll;
			nillO <= nl1Oi;
			nilOl <= nlliOl;
			nlliOO <= (((n1iliO | n1ilil) | ((~ nlOOiO) & ((~ nlO01l) & ((~ nlO01i) & n1ilii)))) | (nlOOiO & (nlO01l & (nlO01i & n1il0O))));
			nlll0i <= ((~ PMADATAWIDTH) & (n1illl | n1illi));
			nlll0l <= nlll0O;
			nlll0O <= nlllii;
			nlll1i <= wire_n0OO1l_dataout;
			nlllii <= n1l1O;
			nlllil <= wire_nlO0lO_dataout;
			nllliO <= wire_nlO0Oi_dataout;
			nlllli <= wire_nlO0Ol_dataout;
			nlllll <= wire_nlO0OO_dataout;
			nllllO <= wire_nlOi1i_dataout;
			nlllOi <= wire_nlOi1l_dataout;
			nlllOl <= wire_nlOi1O_dataout;
			nlllOO <= wire_nlOi0i_dataout;
			nllO0i <= ((((~ PMADATAWIDTH) & (nlllii & SYNC_SM_DIS)) | (PMADATAWIDTH & (SYNC_SM_DIS & nlll0l))) | (n1O0Oi & (~ SYNC_SM_DIS)));
			nllO0l <= n1ilOi;
			nllO0O <= wire_nlOl0O_dataout;
			nllO1i <= wire_nlOi0l_dataout;
			nllO1l <= wire_nlOi0O_dataout;
			nllO1O <= (~ n1illO);
			nllOii <= wire_nlOlii_dataout;
			nllOil <= wire_nlOlil_dataout;
			nllOiO <= wire_nlOliO_dataout;
			nllOli <= wire_nlOlli_dataout;
			nllOll <= wire_nlOlll_dataout;
			nllOlO <= wire_nlOllO_dataout;
			nllOOi <= wire_nlOlOi_dataout;
			nllOOl <= nlO1il;
			nllOOO <= wire_nlOlOl_o;
			nlO01i <= n111l;
			nlO01l <= n111O;
			nlO10i <= wire_nlOO1O_o;
			nlO10l <= wire_nlOO0i_o;
			nlO10O <= wire_nlOO0l_o;
			nlO11i <= wire_nlOlOO_o;
			nlO11l <= wire_nlOO1i_o;
			nlO11O <= wire_nlOO1l_o;
			nlO1ii <= wire_nlOO0O_o;
			nlO1il <= n1lll;
			nlO1iO <= nlOOli;
			nlO1li <= nlOOll;
			nlO1ll <= nlOOlO;
			nlO1lO <= nlOOOi;
			nlO1Oi <= nlOOOl;
			nlO1Ol <= nlOOOO;
			nlO1OO <= n111i;
			nlOOiO <= n10li;
		end
	end
	initial
	begin
		nilOO = 0;
		niO1i = 0;
		niO1l = 0;
		nl1Oi = 0;
		nlliOl = 0;
	end
	always @ ( negedge rcvd_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			nilOO <= 0;
			niO1i <= 0;
			niO1l <= 0;
			nl1Oi <= 0;
			nlliOl <= 0;
		end
		else if  (PMADATAWIDTH == 1'b0) 
		begin
			nilOO <= niOli;
			niO1i <= niOll;
			niO1l <= niOlO;
			nl1Oi <= wire_nliil_dataout;
			nlliOl <= wire_nliiO_dataout;
		end
	end
	initial
	begin
		n1O0ll = 0;
		nlill = 0;
		nllili = 0;
		nllill = 0;
		nllilO = 0;
		nlliOi = 0;
	end
	always @ ( negedge rcvd_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1O0ll <= 1;
			nlill <= 1;
			nllili <= 1;
			nllill <= 1;
			nllilO <= 1;
			nlliOi <= 1;
		end
		else 
		begin
			n1O0ll <= n1O0iO;
			nlill <= wire_nll1i_o;
			nllili <= (~ n1O10l);
			nllill <= n1O10O;
			nllilO <= n1O1ii;
			nlliOi <= n1O1il;
		end
	end
	initial
	begin
		n1O0iO = 0;
		n1O0li = 0;
		ni1iOl = 0;
		nlliiO = 0;
	end
	always @ ( posedge rcvd_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1O0iO <= 1;
			n1O0li <= 1;
			ni1iOl <= 1;
			nlliiO <= 1;
		end
		else 
		begin
			n1O0iO <= wire_n1OiiO_o;
			n1O0li <= wire_n1Oill_o;
			ni1iOl <= (~ ni0Oii);
			nlliiO <= ((~ n1illO) | n1ilOi);
		end
	end
	initial
	begin
		n00O0i = 0;
		n00O0l = 0;
		n00O0O = 0;
		n00O1l = 0;
		n00O1O = 0;
		n00Oii = 0;
		n00Oil = 0;
		n00OiO = 0;
		n00Oli = 0;
		n00Oll = 0;
		n00OlO = 0;
		n00OOi = 0;
		n00OOl = 0;
		n00OOO = 0;
		n01Oil = 0;
		n01OiO = 0;
		n01Oli = 0;
		n0i00i = 0;
		n0i00l = 0;
		n0i00O = 0;
		n0i0ii = 0;
		n0i0il = 0;
		n0i0iO = 0;
		n0i0li = 0;
		n0i0ll = 0;
		n0i11i = 0;
		n0i11l = 0;
		n10li = 0;
		n10ll = 0;
		n10lO = 0;
		n10Oi = 0;
		n10OO = 0;
		n111i = 0;
		n111l = 0;
		n111O = 0;
		n1l0i = 0;
		n1l0l = 0;
		n1l0O = 0;
		n1l1O = 0;
		n1lii = 0;
		n1lil = 0;
		n1liO = 0;
		n1lli = 0;
		n1lOi = 0;
		n1O0lO = 0;
		niO0i = 0;
		niO0l = 0;
		niO0O = 0;
		niO1O = 0;
		niOii = 0;
		niOil = 0;
		niOiO = 0;
		niOli = 0;
		niOll = 0;
		niOlO = 0;
		niOOi = 0;
		niOOl = 0;
		niOOO = 0;
		nl10i = 0;
		nl10l = 0;
		nl10O = 0;
		nl11i = 0;
		nl11l = 0;
		nl11O = 0;
		nl1ii = 0;
		nl1il = 0;
		nl1iO = 0;
		nl1li = 0;
		nl1ll = 0;
		nlilO = 0;
		nlllO = 0;
		nlOOli = 0;
		nlOOll = 0;
		nlOOlO = 0;
		nlOOOi = 0;
		nlOOOl = 0;
		nlOOOO = 0;
	end
	always @ ( negedge rcvd_clk or posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n00O0i <= 0;
			n00O0l <= 0;
			n00O0O <= 0;
			n00O1l <= 0;
			n00O1O <= 0;
			n00Oii <= 0;
			n00Oil <= 0;
			n00OiO <= 0;
			n00Oli <= 0;
			n00Oll <= 0;
			n00OlO <= 0;
			n00OOi <= 0;
			n00OOl <= 0;
			n00OOO <= 0;
			n01Oil <= 0;
			n01OiO <= 0;
			n01Oli <= 0;
			n0i00i <= 0;
			n0i00l <= 0;
			n0i00O <= 0;
			n0i0ii <= 0;
			n0i0il <= 0;
			n0i0iO <= 0;
			n0i0li <= 0;
			n0i0ll <= 0;
			n0i11i <= 0;
			n0i11l <= 0;
			n10li <= 0;
			n10ll <= 0;
			n10lO <= 0;
			n10Oi <= 0;
			n10OO <= 0;
			n111i <= 0;
			n111l <= 0;
			n111O <= 0;
			n1l0i <= 0;
			n1l0l <= 0;
			n1l0O <= 0;
			n1l1O <= 0;
			n1lii <= 0;
			n1lil <= 0;
			n1liO <= 0;
			n1lli <= 0;
			n1lOi <= 0;
			n1O0lO <= 0;
			niO0i <= 0;
			niO0l <= 0;
			niO0O <= 0;
			niO1O <= 0;
			niOii <= 0;
			niOil <= 0;
			niOiO <= 0;
			niOli <= 0;
			niOll <= 0;
			niOlO <= 0;
			niOOi <= 0;
			niOOl <= 0;
			niOOO <= 0;
			nl10i <= 0;
			nl10l <= 0;
			nl10O <= 0;
			nl11i <= 0;
			nl11l <= 0;
			nl11O <= 0;
			nl1ii <= 0;
			nl1il <= 0;
			nl1iO <= 0;
			nl1li <= 0;
			nl1ll <= 0;
			nlilO <= 0;
			nlllO <= 0;
			nlOOli <= 0;
			nlOOll <= 0;
			nlOOlO <= 0;
			nlOOOi <= 0;
			nlOOOl <= 0;
			nlOOOO <= 0;
		end
		else 
		begin
			n00O0i <= wire_n00lOi_o;
			n00O0l <= n1li1O;
			n00O0O <= wire_n00l0O_o;
			n00O1l <= n1li1i;
			n00O1O <= n1li1i;
			n00Oii <= n1li0l;
			n00Oil <= wire_n00iOl_o;
			n00OiO <= n1liii;
			n00Oli <= wire_n00iii_o;
			n00Oll <= n1lill;
			n00OlO <= wire_n000OO_o;
			n00OOi <= n1ll1l;
			n00OOl <= wire_n000il_o;
			n00OOO <= n1llli;
			n01Oil <= n01OiO;
			n01OiO <= prbs_en;
			n01Oli <= n1O0lO;
			n0i00i <= wire_n001iO_o;
			n0i00l <= n1lO0l;
			n0i00O <= n1llli;
			n0i0ii <= n1ll1l;
			n0i0il <= n1lill;
			n0i0iO <= n1liii;
			n0i0li <= n1li0l;
			n0i0ll <= n1li1O;
			n0i11i <= wire_n0001i_o;
			n0i11l <= n1lO0l;
			n10li <= wire_n100O_o;
			n10ll <= (n10Oi & (~ n10lO));
			n10lO <= n10Oi;
			n10Oi <= n10OO;
			n10OO <= BITSLIP;
			n111i <= wire_n11li_o;
			n111l <= wire_n11ll_o;
			n111O <= wire_n100l_o;
			n1l0i <= n1l0l;
			n1l0l <= n1l0O;
			n1l0O <= A1A2_SIZE;
			n1l1O <= (~ ((((nlliOi & nllilO) & nllill) & nllili) | ((((~ (nllili ^ n1lii)) & (~ (nllill ^ n1lil))) & (~ (nllilO ^ n1liO))) & (~ (nlliOi ^ n1lli)))));
			n1lii <= n1lOl;
			n1lil <= n1lOO;
			n1liO <= n1O1i;
			n1lli <= nil1O;
			n1lOi <= n1lOiO;
			n1O0lO <= ENCDT;
			niO0i <= wire_nl1OO_dataout;
			niO0l <= wire_nl01i_dataout;
			niO0O <= wire_nl01l_dataout;
			niO1O <= wire_nl1Ol_dataout;
			niOii <= wire_nl01O_dataout;
			niOil <= wire_nl00i_dataout;
			niOiO <= wire_nl00l_dataout;
			niOli <= wire_nl00O_dataout;
			niOll <= wire_nl0ii_dataout;
			niOlO <= wire_nl0il_dataout;
			niOOi <= wire_nl0iO_dataout;
			niOOl <= wire_nl0li_dataout;
			niOOO <= wire_nl0ll_dataout;
			nl10i <= wire_nl0OO_dataout;
			nl10l <= wire_nli1i_dataout;
			nl10O <= wire_nli1l_dataout;
			nl11i <= wire_nl0lO_dataout;
			nl11l <= wire_nl0Oi_dataout;
			nl11O <= wire_nl0Ol_dataout;
			nl1ii <= wire_nli1O_dataout;
			nl1il <= wire_nli0i_dataout;
			nl1iO <= wire_nli0l_dataout;
			nl1li <= wire_nli0O_dataout;
			nl1ll <= wire_nliii_dataout;
			nlilO <= wire_nliOO_o;
			nlllO <= wire_nliOl_o;
			nlOOli <= wire_n110i_o;
			nlOOll <= wire_n110l_o;
			nlOOlO <= wire_n110O_o;
			nlOOOi <= wire_n11ii_o;
			nlOOOl <= wire_n11il_o;
			nlOOOO <= wire_n11iO_o;
		end
	end
	or(wire_n0000i_dataout, n1llll, n1llli);
	assign		wire_n000i_dataout = (PMADATAWIDTH === 1'b1) ? (((~ n1l0l) & (n1liil & n0i0iO)) | (n1l0l & (n1liil & (n00Oli & (~ n00OiO))))) : (n1liil | n1liii);
	or(wire_n000ll_dataout, n1ll1O, n1ll1l);
	assign		wire_n001i_dataout = (PMADATAWIDTH === 1'b1) ? (((~ n1l0l) & (n1li0O & n0i0li)) | (n1l0l & (n1li0O & (n00Oil & (~ n00Oii))))) : (n1li0O | n1li0l);
	or(wire_n001lO_dataout, n1lO0O, n1lO0l);
	or(wire_n00i1O_dataout, n1lilO, n1lill);
	assign		wire_n00ii_dataout = (PMADATAWIDTH === 1'b1) ? (((~ n1l0l) & (n1lilO & n0i0il)) | (n1l0l & (n1lilO & (n00OlO & (~ n00Oll))))) : ((n1lilO | n1lill) | (~ n1liiO59));
	or(wire_n00ili_dataout, n1liil, n1liii);
	or(wire_n00l1l_dataout, n1li0O, n1li0l);
	assign		wire_n00li_dataout = (PMADATAWIDTH === 1'b1) ? (((~ n1l0l) & (n1ll1O & n0i0ii)) | ((n1l0l & (n1ll1O & (n00OOl & (~ n00OOi)))) & n1liOi56)) : ((n1ll1O | n1ll1l) | (~ n1liOO53));
	or(wire_n00liO_dataout, n1li0i, n1li1O);
	or(wire_n00O1i_dataout, n1li1l, n1li1i);
	assign		wire_n00Oi_dataout = (PMADATAWIDTH === 1'b1) ? ((((~ n1l0l) & (n1llll & n0i00O)) | (n1l0l & (n1llll & ((n0i11i & (~ n00OOO)) & n1ll0O47)))) | (~ n1ll0i50)) : ((n1llll | n1llli) | (~ n1llil44));
	and(wire_n0100i_dataout, n1O0Oi, ~{(~ n01Oii)});
	assign		wire_n0100l_dataout = (n11iOl === 1'b1) ? n1O0Oi : wire_n010iO_dataout;
	or(wire_n0100O_dataout, n1O0iO, n11iOl);
	and(wire_n0101i_dataout, wire_n0101l_o[1], ~{n11ilO});
	or(wire_n0101O_dataout, n1O0iO, (~ n01Oii));
	assign		wire_n010i_dataout = (AUTOBYTEALIGN_DIS === 1'b1) ? n1i1O : n1O1i;
	and(wire_n010ii_dataout, (~ n11iOi), ~{n11iOl});
	and(wire_n010il_dataout, n11iOi, ~{n11iOl});
	or(wire_n010iO_dataout, n1O0Oi, n11iOi);
	assign		wire_n010l_dataout = (AUTOBYTEALIGN_DIS === 1'b1) ? n1l1i : nil1O;
	and(wire_n010O_dataout, (n1l0Oi | n1l0lO), ~{PMADATAWIDTH});
	and(wire_n0110i_dataout, n11ilO, ~{(~ n01Oii)});
	and(wire_n0110l_dataout, (~ n11ilO), ~{(~ n01Oii)});
	and(wire_n0111i_dataout, wire_n0111O_dataout, ~{(~ n01Oii)});
	and(wire_n0111l_dataout, n11ill, ~{n11ilO});
	and(wire_n0111O_dataout, (~ n11ill), ~{n11ilO});
	and(wire_n011ii_dataout, wire_n011iO_dataout, ~{(~ n01Oii)});
	and(wire_n011il_dataout, wire_n011li_dataout, ~{(~ n01Oii)});
	and(wire_n011iO_dataout, wire_n011ll_dataout, ~{n11ilO});
	assign		wire_n011l_dataout = (AUTOBYTEALIGN_DIS === 1'b1) ? n1i1i : n1lOl;
	and(wire_n011li_dataout, wire_n011lO_dataout, ~{n11ilO});
	and(wire_n011ll_dataout, wire_n0101l_o[0], ~{n11ill});
	and(wire_n011lO_dataout, wire_n0101l_o[1], ~{n11ill});
	assign		wire_n011O_dataout = (AUTOBYTEALIGN_DIS === 1'b1) ? n1i1l : n1lOO;
	and(wire_n011Oi_dataout, wire_n011OO_dataout, ~{(~ n01Oii)});
	and(wire_n011Ol_dataout, wire_n0101i_dataout, ~{(~ n01Oii)});
	and(wire_n011OO_dataout, wire_n0101l_o[0], ~{n11ilO});
	and(wire_n01i0i_dataout, n11l0i, ~{n11l1O});
	and(wire_n01i1O_dataout, (~ n11l0i), ~{n11l1O});
	and(wire_n01iii_dataout, wire_n01ili_dataout, ~{n11l0l});
	and(wire_n01iil_dataout, n11l0O, ~{n11l0l});
	and(wire_n01iiO_dataout, wire_n01ill_dataout, ~{n11l0l});
	and(wire_n01il_dataout, (n1l0OO | n1l0Ol), ~{PMADATAWIDTH});
	and(wire_n01ili_dataout, (~ n11iOO), ~{n11l0O});
	and(wire_n01ill_dataout, n11iOO, ~{n11l0O});
	assign		wire_n01iOl_dataout = (n11l1O === 1'b1) ? (~ n1O0Ol) : wire_n01l1i_dataout;
	or(wire_n01iOO_dataout, n1O0iO, n11l1O);
	assign		wire_n01l0i_dataout = (n11l0O === 1'b1) ? (~ n1O0Ol) : n1O0Ol;
	and(wire_n01l0l_dataout, n1O0iO, n11lii);
	or(wire_n01l0O_dataout, (~ n1O0Ol), ~{n11lii});
	or(wire_n01l1i_dataout, (~ n1O0Ol), n11l0i);
	assign		wire_n01l1l_dataout = (n11l0l === 1'b1) ? (~ n1O0Ol) : wire_n01l0i_dataout;
	or(wire_n01l1O_dataout, n1O0iO, n11l0l);
	assign		wire_n01li_dataout = (PMADATAWIDTH === 1'b1) ? (((~ n1l0l) & (n1li1l & n00O1l)) | (n1l0l & (n1li1l & (n00O0i & (~ n00O1O))))) : (n1li1l | n1li1i);
	assign		wire_n01Oi_dataout = (PMADATAWIDTH === 1'b1) ? (((~ n1l0l) & (n1li0i & n0i0ll)) | (n1l0l & (n1li0i & (n00O0O & (~ n00O0l))))) : (n1li0i | n1li1O);
	assign		wire_n0i0i_dataout = (n1lOii === 1'b1) ? niOli : wire_n0iOl_dataout;
	assign		wire_n0i0l_dataout = (n1lOii === 1'b1) ? niOll : wire_n0iOO_dataout;
	assign		wire_n0i0O_dataout = (n1lOii === 1'b1) ? niOlO : wire_n0l1i_dataout;
	assign		wire_n0i1i_dataout = (PMADATAWIDTH === 1'b1) ? ((((~ n1l0l) & ((n1lO0O & n0i00l) & n1lO1O32)) & n1lO1i35) | ((n1l0l & (n1lO0O & ((n0i00i & (~ n0i11l)) & n1llOl38))) & n1lllO41)) : (n1lO0O | n1lO0l);
	assign		wire_n0iii_dataout = (n1lOii === 1'b1) ? niOOi : wire_n0l1l_dataout;
	assign		wire_n0iil_dataout = (n1lOii === 1'b1) ? niOOl : wire_n0l1O_dataout;
	assign		wire_n0iiO_dataout = (n1lOii === 1'b1) ? niOOO : wire_n0l0i_dataout;
	assign		wire_n0ili_dataout = (n1lOii === 1'b1) ? nl11i : wire_n0l0l_dataout;
	and(wire_n0ill_dataout, wire_n0l0O_dataout, ~{n1lOii});
	and(wire_n0ilO_dataout, wire_n0lii_dataout, ~{n1lOii});
	and(wire_n0iOi_dataout, wire_n0lil_dataout, ~{n1lOii});
	and(wire_n0iOl_dataout, niOli, ~{n1lOil});
	and(wire_n0iOO_dataout, niOll, ~{n1lOil});
	and(wire_n0l0i_dataout, niOOO, ~{n1lOil});
	and(wire_n0l0l_dataout, nl11i, ~{n1lOil});
	and(wire_n0l0O_dataout, nl11l, ~{n1lOil});
	and(wire_n0l1i_dataout, niOlO, ~{n1lOil});
	and(wire_n0l1l_dataout, niOOi, ~{n1lOil});
	assign		wire_n0l1lO_dataout = (((((~ nlO1lO) & n11lOl) | (nlO1lO & n1iO0i)) | (n1iOiO & n1iO0O)) === 1'b1) ? nlll1i : (n1iOOl | n1iO0l);
	and(wire_n0l1O_dataout, niOOl, ~{n1lOil});
	and(wire_n0lii_dataout, nl11O, ~{n1lOil});
	and(wire_n0lil_dataout, nl10i, ~{n1lOil});
	assign		wire_n0liO_dataout = (n1lOii === 1'b1) ? niOll : wire_n0iOO_dataout;
	assign		wire_n0lli_dataout = (n1lOii === 1'b1) ? niOlO : wire_n0l1i_dataout;
	assign		wire_n0lll_dataout = (n1lOii === 1'b1) ? niOOi : wire_n0l1l_dataout;
	assign		wire_n0llO_dataout = (n1lOii === 1'b1) ? niOOl : wire_n0l1O_dataout;
	assign		wire_n0lOi_dataout = (n1lOii === 1'b1) ? niOOO : wire_n0l0i_dataout;
	assign		wire_n0lOl_dataout = (n1lOii === 1'b1) ? nl11i : wire_n0l0l_dataout;
	assign		wire_n0lOO_dataout = (n1lOii === 1'b1) ? nl11l : wire_n0l0O_dataout;
	and(wire_n0O0i_dataout, nl10l, ~{n1lOil});
	and(wire_n0O0l_dataout, nl10i, ~{n1lOii});
	and(wire_n0O0O_dataout, wire_n0O0i_dataout, ~{n1lOii});
	and(wire_n0O1i_dataout, wire_n0lii_dataout, ~{n1lOii});
	and(wire_n0O1l_dataout, wire_n0lil_dataout, ~{n1lOii});
	and(wire_n0O1O_dataout, wire_n0O0i_dataout, ~{n1lOii});
	and(wire_n0Oii_dataout, wire_n0Oil_dataout, ~{n1lOii});
	and(wire_n0Oil_dataout, nl10O, ~{n1lOil});
	and(wire_n0OiO_dataout, nl10l, ~{n1lOii});
	and(wire_n0Oli_dataout, wire_n0Oil_dataout, ~{n1lOii});
	and(wire_n0Oll_dataout, wire_n0OlO_dataout, ~{n1lOii});
	and(wire_n0OlO_dataout, nl1ii, ~{n1lOil});
	assign		wire_n0OO1l_dataout = ((n1ilOl & (nlO1OO ^ nlO01i)) === 1'b1) ? wire_n0l1lO_dataout : (n1iO1i | n1ilOO);
	and(wire_n0OOi_dataout, nl10O, ~{n1lOii});
	and(wire_n0OOl_dataout, wire_n0OlO_dataout, ~{n1lOii});
	and(wire_n0OOO_dataout, wire_ni11i_dataout, ~{n1lOii});
	or(wire_n1i0i_dataout, wire_n1iil_dataout, n1l1OO);
	and(wire_n1i0l_dataout, wire_n1iiO_dataout, ~{n1l1OO});
	and(wire_n1i0O_dataout, wire_n1ili_dataout, ~{n1l1OO});
	or(wire_n1iii_dataout, wire_n1ill_dataout, n1l1OO);
	or(wire_n1iil_dataout, wire_n1ilO_o[1], n1l1Ol);
	or(wire_n1iiO_dataout, wire_n1ilO_o[2], n1l1Ol);
	or(wire_n1ili_dataout, wire_n1ilO_o[3], n1l1Ol);
	and(wire_n1ill_dataout, wire_n1ilO_o[4], ~{n1l1Ol});
	assign		wire_n1O0OO_dataout = (n01Oil === 1'b1) ? encdet_prbs : wire_n1Oi1i_dataout;
	assign		wire_n1Oi1i_dataout = (SYNC_SM_DIS === 1'b1) ? wire_n1Oi1l_dataout : n1O0ll;
	assign		wire_n1Oi1l_dataout = (PMADATAWIDTH === 1'b1) ? wire_nliOi_o : n01Oli;
	and(wire_n1OO0l_dataout, wire_n011ll_dataout, ~{n11l1O});
	and(wire_n1OO0O_dataout, wire_n011lO_dataout, ~{n11l1O});
	and(wire_n1OOii_dataout, n11ill, ~{n11l1O});
	and(wire_n1OOil_dataout, (~ n11ill), ~{n11l1O});
	and(wire_n1OOll_dataout, wire_n0101l_o[0], ~{n11l1O});
	and(wire_n1OOlO_dataout, wire_n0101l_o[1], ~{n11l1O});
	and(wire_n1OOOi_dataout, n1O0Oi, ~{n11l1O});
	and(wire_n1OOOO_dataout, wire_n0111l_dataout, ~{(~ n01Oii)});
	and(wire_ni000l_dataout, niiliO, ~{n101il});
	and(wire_ni000O_dataout, niilli, ~{n101il});
	and(wire_ni001i_dataout, n1010O, ~{n101ii});
	and(wire_ni001l_dataout, (~ n1010O), ~{n101ii});
	and(wire_ni00i_dataout, wire_ni01l_dataout, ~{n1lOii});
	and(wire_ni00ii_dataout, niilll, ~{n101il});
	and(wire_ni00il_dataout, niillO, ~{n101il});
	and(wire_ni00l_dataout, wire_ni00O_dataout, ~{n1lOii});
	and(wire_ni00li_dataout, n101li, ~{(~ ni0Oii)});
	and(wire_ni00ll_dataout, wire_ni00Oi_dataout, ~{(~ ni0Oii)});
	and(wire_ni00lO_dataout, wire_ni00Ol_dataout, ~{(~ ni0Oii)});
	and(wire_ni00O_dataout, nlliOl, ~{n1lOil});
	and(wire_ni00Oi_dataout, n101iO, ~{n101li});
	and(wire_ni00Ol_dataout, (~ n101iO), ~{n101li});
	and(wire_ni011i_dataout, wire_ni0i1O_dataout, ni0i0l);
	and(wire_ni01i_dataout, wire_ni01l_dataout, ~{n1lOii});
	and(wire_ni01iO_dataout, nii0li, ~{n101il});
	and(wire_ni01l_dataout, nl1Oi, ~{n1lOil});
	and(wire_ni01li_dataout, nii0ll, ~{n101il});
	and(wire_ni01ll_dataout, nii0lO, ~{n101il});
	and(wire_ni01lO_dataout, nii0Oi, ~{n101il});
	and(wire_ni01O_dataout, nl1ll, ~{n1lOii});
	and(wire_ni01Oi_dataout, n101ii, ~{(~ ni0Oii)});
	and(wire_ni01Ol_dataout, wire_ni001i_dataout, ~{(~ ni0Oii)});
	and(wire_ni01OO_dataout, wire_ni001l_dataout, ~{(~ ni0Oii)});
	and(wire_ni0i1l_dataout, nii0il, ~{(~ ni0Oii)});
	and(wire_ni0i1O_dataout, (~ nii0il), ~{(~ ni0Oii)});
	assign		wire_ni0ii_dataout = (n1lOii === 1'b1) ? (~ SYNC_COMP_PAT[0]) : wire_nii1l_dataout;
	assign		wire_ni0il_dataout = (n1lOii === 1'b1) ? (~ SYNC_COMP_PAT[1]) : wire_nii1O_dataout;
	and(wire_ni0ill_dataout, RUNDISP_SEL[0], ~{PMADATAWIDTH});
	and(wire_ni0ilO_dataout, RUNDISP_SEL[1], ~{PMADATAWIDTH});
	assign		wire_ni0iO_dataout = (n1lOii === 1'b1) ? (~ SYNC_COMP_PAT[2]) : wire_nii0i_dataout;
	assign		wire_ni0iOi_dataout = (PMADATAWIDTH === 1'b1) ? RUNDISP_SEL[0] : wire_ni0l0i_o[0];
	assign		wire_ni0iOl_dataout = (PMADATAWIDTH === 1'b1) ? RUNDISP_SEL[1] : wire_ni0l0i_o[1];
	assign		wire_ni0iOO_dataout = (PMADATAWIDTH === 1'b1) ? RUNDISP_SEL[2] : wire_ni0l0i_o[2];
	assign		wire_ni0l1i_dataout = (PMADATAWIDTH === 1'b1) ? RUNDISP_SEL[3] : wire_ni0l0i_o[3];
	assign		wire_ni0l1l_dataout = (PMADATAWIDTH === 1'b1) ? RUNDISP_SEL[4] : wire_ni0l0i_o[4];
	assign		wire_ni0l1O_dataout = (PMADATAWIDTH === 1'b1) ? (~ n101ll) : wire_ni0l0i_o[5];
	assign		wire_ni0li_dataout = (n1lOii === 1'b1) ? (~ SYNC_COMP_PAT[3]) : wire_nii0l_dataout;
	assign		wire_ni0ll_dataout = (n1lOii === 1'b1) ? (~ SYNC_COMP_PAT[4]) : wire_nii0O_dataout;
	assign		wire_ni0lO_dataout = (n1lOii === 1'b1) ? (~ SYNC_COMP_PAT[5]) : wire_niiii_dataout;
	and(wire_ni0lOl_dataout, ni0llO, ni0Oii);
	and(wire_ni0lOO_dataout, ni0lOi, ni0Oii);
	and(wire_ni0O1i_dataout, n1O0ii, ni0Oii);
	and(wire_ni0O1l_dataout, wire_ni0O1O_o, ni0Oii);
	assign		wire_ni0Oi_dataout = (n1lOii === 1'b1) ? (~ SYNC_COMP_PAT[6]) : wire_niiil_dataout;
	and(wire_ni0Ol_dataout, wire_niiiO_dataout, ~{n1lOii});
	and(wire_ni0OO_dataout, wire_niili_dataout, ~{n1lOii});
	and(wire_ni10i_dataout, wire_ni10l_dataout, ~{n1lOii});
	and(wire_ni10l_dataout, nl1iO, ~{n1lOil});
	and(wire_ni10O_dataout, nl1il, ~{n1lOii});
	and(wire_ni11i_dataout, nl1il, ~{n1lOil});
	and(wire_ni11l_dataout, nl1ii, ~{n1lOii});
	and(wire_ni11O_dataout, wire_ni11i_dataout, ~{n1lOii});
	and(wire_ni1ii_dataout, wire_ni10l_dataout, ~{n1lOii});
	and(wire_ni1il_dataout, wire_ni1iO_dataout, ~{n1lOii});
	and(wire_ni1iO_dataout, nl1li, ~{n1lOil});
	and(wire_ni1li_dataout, nl1iO, ~{n1lOii});
	assign		wire_ni1lil_dataout = (wire_ni1lOi_o[4] === 1'b1) ? wire_ni1llO_o[0] : wire_ni1lOl_dataout;
	assign		wire_ni1liO_dataout = (wire_ni1lOi_o[4] === 1'b1) ? wire_ni1llO_o[1] : wire_ni1lOO_dataout;
	and(wire_ni1ll_dataout, wire_ni1iO_dataout, ~{n1lOii});
	assign		wire_ni1lli_dataout = (wire_ni1lOi_o[4] === 1'b1) ? wire_ni1llO_o[2] : wire_ni1O1i_dataout;
	assign		wire_ni1lll_dataout = (wire_ni1lOi_o[4] === 1'b1) ? wire_ni1llO_o[3] : wire_ni1O1l_dataout;
	and(wire_ni1lO_dataout, wire_ni1Oi_dataout, ~{n1lOii});
	and(wire_ni1lOl_dataout, ni1l0l, n11OOO);
	and(wire_ni1lOO_dataout, ni1l0O, n11OOO);
	and(wire_ni1O1i_dataout, ni1lii, n11OOO);
	and(wire_ni1O1l_dataout, ni0i0i, n11OOO);
	and(wire_ni1Oi_dataout, nl1ll, ~{n1lOil});
	and(wire_ni1Ol_dataout, nl1li, ~{n1lOii});
	and(wire_ni1OO_dataout, wire_ni1Oi_dataout, ~{n1lOii});
	and(wire_ni1OOl_dataout, ni0Oii, ni1iOl);
	and(wire_ni1OOO_dataout, wire_ni0i1l_dataout, ni0i0l);
	assign		wire_nii00l_dataout = (PMADATAWIDTH === 1'b1) ? n101lO : n101Oi;
	assign		wire_nii0i_dataout = (n1lOil === 1'b1) ? SYNC_COMP_PAT[10] : (~ SYNC_COMP_PAT[2]);
	assign		wire_nii0l_dataout = (n1lOil === 1'b1) ? SYNC_COMP_PAT[11] : (~ SYNC_COMP_PAT[3]);
	assign		wire_nii0O_dataout = (n1lOil === 1'b1) ? SYNC_COMP_PAT[12] : (~ SYNC_COMP_PAT[4]);
	and(wire_nii1i_dataout, wire_niill_dataout, ~{n1lOii});
	assign		wire_nii1l_dataout = (n1lOil === 1'b1) ? SYNC_COMP_PAT[8] : (~ SYNC_COMP_PAT[0]);
	assign		wire_nii1O_dataout = (n1lOil === 1'b1) ? SYNC_COMP_PAT[9] : (~ SYNC_COMP_PAT[1]);
	and(wire_niii0O_dataout, ((~ n1000l) | ((~ n1000i) | ((~ n1001O) | ((~ n1001l) | ((~ n1001i) | ((~ n101OO) | (~ n101Ol))))))), ni0Oii);
	assign		wire_niiii_dataout = (n1lOil === 1'b1) ? SYNC_COMP_PAT[13] : (~ SYNC_COMP_PAT[5]);
	and(wire_niiiii_dataout, (n1i0ii | n1i00O), ni0Oii);
	and(wire_niiiil_dataout, (((~ PMADATAWIDTH) & n10Oil) | (PMADATAWIDTH & n1i1ii)), ni0Oii);
	and(wire_niiiiO_dataout, n100Oi, ni0Oii);
	assign		wire_niiil_dataout = (n1lOil === 1'b1) ? SYNC_COMP_PAT[14] : (~ SYNC_COMP_PAT[6]);
	and(wire_niiili_dataout, n100OO, ni0Oii);
	and(wire_niiill_dataout, ((((~ n10i0O) | (~ n10i0l)) | (~ n10i0i)) | (~ n10i1O)), ni0Oii);
	and(wire_niiilO_dataout, ((n10Oil | (~ n10iii)) | (~ ((n10Oil | n10OiO) | (~ n1i1ii)))), ni0Oii);
	assign		wire_niiiO_dataout = (n1lOil === 1'b1) ? SYNC_COMP_PAT[15] : (~ SYNC_COMP_PAT[7]);
	and(wire_niiiOi_dataout, niii1O, ni0Oii);
	and(wire_niiiOl_dataout, niii0i, ni0Oii);
	and(wire_niiiOO_dataout, niii0l, ni0Oii);
	and(wire_niil0i_dataout, ((((~ n10l1i) | (~ n10iOO)) | (~ n10iOl)) | (~ n10iOi)), ni0Oii);
	and(wire_niil0l_dataout, ((n1i11l | (~ n10l1l)) | (~ ((n1i11l | n1i10i) | (~ n1i10O)))), ni0Oii);
	and(wire_niil1i_dataout, niil0O, ni0Oii);
	and(wire_niil1l_dataout, n10iil, ni0Oii);
	and(wire_niil1O_dataout, n10ili, ni0Oii);
	and(wire_niili_dataout, (~ SYNC_COMP_PAT[8]), ~{n1lOil});
	and(wire_niill_dataout, (~ SYNC_COMP_PAT[9]), ~{n1lOil});
	and(wire_niilO_dataout, SYNC_COMP_PAT[7], ~{n1lOii});
	and(wire_niiO0l_dataout, ((~ n100lO) | ((~ n100ll) | ((~ n100li) | ((~ n100iO) | ((~ n100il) | ((~ n100ii) | (~ n1000O))))))), ni0Oii);
	and(wire_niiO0O_dataout, (((~ PMADATAWIDTH) & n1i0il) | (PMADATAWIDTH & (~ n1iiii))), ni0Oii);
	and(wire_niiOi_dataout, wire_niiOO_dataout, ~{n1lOii});
	and(wire_niiOii_dataout, n10l1O, ni0Oii);
	and(wire_niiOil_dataout, n10l0l, ni0Oii);
	and(wire_niiOiO_dataout, ((((~ n10lll) | (~ n10lli)) | (~ n10liO)) | (~ n10lil)), ni0Oii);
	and(wire_niiOl_dataout, wire_nil1i_dataout, ~{n1lOii});
	and(wire_niiOli_dataout, ((n1i0il | (~ n10llO)) | (~ ((n1i0il | n1i0iO) | n1iiii))), ni0Oii);
	and(wire_niiOll_dataout, niiO1l, ni0Oii);
	and(wire_niiOlO_dataout, niiO1O, ni0Oii);
	and(wire_niiOO_dataout, SYNC_COMP_PAT[8], ~{n1lOil});
	and(wire_niiOOi_dataout, niiO0i, ni0Oii);
	and(wire_niiOOl_dataout, ni1iOO, ni0Oii);
	and(wire_niiOOO_dataout, n10lOi, ni0Oii);
	and(wire_nil11i_dataout, n10lOO, ni0Oii);
	and(wire_nil11l_dataout, ((((~ n10O0O) | (~ n10O0l)) | (~ n10O0i)) | (~ n10O1O)), ni0Oii);
	and(wire_nil11O_dataout, ((n1ii1l | (~ n10Oii)) | (~ ((n1ii1l | n1ii0i) | (~ n1ii0O)))), ni0Oii);
	and(wire_nil1i_dataout, SYNC_COMP_PAT[9], ~{n1lOil});
	assign		wire_nl00i_dataout = ((~ PMADATAWIDTH) === 1'b1) ? nl11O : nl11i;
	assign		wire_nl00l_dataout = ((~ PMADATAWIDTH) === 1'b1) ? nl10i : nl11l;
	assign		wire_nl00O_dataout = ((~ PMADATAWIDTH) === 1'b1) ? nl10l : nl11O;
	assign		wire_nl01i_dataout = ((~ PMADATAWIDTH) === 1'b1) ? niOOO : niOOi;
	assign		wire_nl01l_dataout = ((~ PMADATAWIDTH) === 1'b1) ? nl11i : niOOl;
	assign		wire_nl01O_dataout = ((~ PMADATAWIDTH) === 1'b1) ? nl11l : niOOO;
	assign		wire_nl0ii_dataout = ((~ PMADATAWIDTH) === 1'b1) ? nl10O : nl10i;
	assign		wire_nl0il_dataout = ((~ PMADATAWIDTH) === 1'b1) ? nl1ii : nl10l;
	assign		wire_nl0iO_dataout = ((~ PMADATAWIDTH) === 1'b1) ? nl1il : nl10O;
	assign		wire_nl0li_dataout = ((~ PMADATAWIDTH) === 1'b1) ? nl1iO : nl1ii;
	assign		wire_nl0ll_dataout = ((~ PMADATAWIDTH) === 1'b1) ? nl1li : nl1il;
	assign		wire_nl0lO_dataout = ((~ PMADATAWIDTH) === 1'b1) ? nl1ll : nl1iO;
	assign		wire_nl0Oi_dataout = ((~ PMADATAWIDTH) === 1'b1) ? nl1Oi : nl1li;
	assign		wire_nl0Ol_dataout = ((~ PMADATAWIDTH) === 1'b1) ? nlliOl : nl1ll;
	assign		wire_nl0OO_dataout = (LP10BEN === 1'b1) ? PUDR[0] : PUDI[0];
	assign		wire_nl1Ol_dataout = ((~ PMADATAWIDTH) === 1'b1) ? niOOi : niOll;
	assign		wire_nl1OO_dataout = ((~ PMADATAWIDTH) === 1'b1) ? niOOl : niOlO;
	assign		wire_nli0i_dataout = (LP10BEN === 1'b1) ? PUDR[4] : PUDI[4];
	assign		wire_nli0l_dataout = (LP10BEN === 1'b1) ? PUDR[5] : PUDI[5];
	assign		wire_nli0O_dataout = (LP10BEN === 1'b1) ? PUDR[6] : PUDI[6];
	assign		wire_nli1i_dataout = (LP10BEN === 1'b1) ? PUDR[1] : PUDI[1];
	assign		wire_nli1l_dataout = (LP10BEN === 1'b1) ? PUDR[2] : PUDI[2];
	assign		wire_nli1O_dataout = (LP10BEN === 1'b1) ? PUDR[3] : PUDI[3];
	assign		wire_nliii_dataout = (LP10BEN === 1'b1) ? PUDR[7] : PUDI[7];
	assign		wire_nliil_dataout = (LP10BEN === 1'b1) ? PUDR[8] : PUDI[8];
	assign		wire_nliiO_dataout = (LP10BEN === 1'b1) ? PUDR[9] : PUDI[9];
	and(wire_nll0i_dataout, (~ n1O1iO), ~{n1O11l});
	or(wire_nll0l_dataout, n1O11l, n1O1iO);
	and(wire_nll0O_dataout, n1O11l, ~{n1O1iO});
	or(wire_nll1l_dataout, n1O1iO, n1O11l);
	and(wire_nll1O_dataout, n1O1iO, ~{n1O11l});
	and(wire_nllii_dataout, (~ n1O11l), ~{n1O1iO});
	assign		wire_nlO0lO_dataout = (n1l11i === 1'b1) ? SYNC_COMP_PAT[0] : wire_nlOiii_dataout;
	assign		wire_nlO0Oi_dataout = (n1l11i === 1'b1) ? SYNC_COMP_PAT[1] : wire_nlOiil_dataout;
	assign		wire_nlO0Ol_dataout = (n1l11i === 1'b1) ? SYNC_COMP_PAT[2] : wire_nlOiiO_dataout;
	assign		wire_nlO0OO_dataout = (n1l11i === 1'b1) ? SYNC_COMP_PAT[3] : wire_nlOili_dataout;
	assign		wire_nlOi0i_dataout = (n1l11i === 1'b1) ? SYNC_COMP_PAT[7] : wire_nlOiOl_dataout;
	assign		wire_nlOi0l_dataout = (n1l11i === 1'b1) ? nllOOl : wire_nlOiOO_dataout;
	and(wire_nlOi0O_dataout, wire_nlOl1i_dataout, ~{n1l11i});
	assign		wire_nlOi1i_dataout = (n1l11i === 1'b1) ? SYNC_COMP_PAT[4] : wire_nlOill_dataout;
	assign		wire_nlOi1l_dataout = (n1l11i === 1'b1) ? SYNC_COMP_PAT[5] : wire_nlOilO_dataout;
	assign		wire_nlOi1O_dataout = (n1l11i === 1'b1) ? SYNC_COMP_PAT[6] : wire_nlOiOi_dataout;
	assign		wire_nlOiii_dataout = (n1iOOO === 1'b1) ? nllO0O : nlO1iO;
	assign		wire_nlOiil_dataout = (n1iOOO === 1'b1) ? nllOii : nlO1li;
	assign		wire_nlOiiO_dataout = (n1iOOO === 1'b1) ? nllOil : nlO1ll;
	assign		wire_nlOili_dataout = (n1iOOO === 1'b1) ? nllOiO : nlO1lO;
	assign		wire_nlOill_dataout = (n1iOOO === 1'b1) ? nllOli : nlO1Oi;
	assign		wire_nlOilO_dataout = (n1iOOO === 1'b1) ? nllOll : nlO1Ol;
	assign		wire_nlOiOi_dataout = (n1iOOO === 1'b1) ? nllOlO : nlO1OO;
	assign		wire_nlOiOl_dataout = (n1iOOO === 1'b1) ? nllOOi : nlO01i;
	assign		wire_nlOiOO_dataout = (n1iOOO === 1'b1) ? nllOOl : nlO01l;
	assign		wire_nlOl0O_dataout = (n1l11l === 1'b1) ? SYNC_COMP_PAT[0] : nllOOO;
	and(wire_nlOl1i_dataout, nlOOiO, ~{n1iOOO});
	assign		wire_nlOlii_dataout = (n1l11l === 1'b1) ? SYNC_COMP_PAT[1] : nlO11i;
	assign		wire_nlOlil_dataout = (n1l11l === 1'b1) ? SYNC_COMP_PAT[2] : nlO11l;
	assign		wire_nlOliO_dataout = (n1l11l === 1'b1) ? SYNC_COMP_PAT[3] : nlO11O;
	assign		wire_nlOlli_dataout = (n1l11l === 1'b1) ? SYNC_COMP_PAT[4] : nlO10i;
	assign		wire_nlOlll_dataout = (n1l11l === 1'b1) ? SYNC_COMP_PAT[5] : nlO10l;
	assign		wire_nlOllO_dataout = (n1l11l === 1'b1) ? SYNC_COMP_PAT[6] : nlO10O;
	assign		wire_nlOlOi_dataout = (n1l11l === 1'b1) ? SYNC_COMP_PAT[7] : nlO1ii;
	oper_add   n0101l
	( 
	.a({n01lil, n1Oi1O}),
	.b({1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n0101l_o));
	defparam
		n0101l.sgate_representation = 0,
		n0101l.width_a = 2,
		n0101l.width_b = 2,
		n0101l.width_o = 2;
	oper_add   n1ilO
	( 
	.a({n1l1i, n1i1O, n1i1l, n1i1i, 1'b1}),
	.b({{3{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1ilO_o));
	defparam
		n1ilO.sgate_representation = 0,
		n1ilO.width_a = 5,
		n1ilO.width_b = 5,
		n1ilO.width_o = 5;
	oper_add   ni0l0i
	( 
	.a({{2{1'b0}}, (~ n101ll), RUNDISP_SEL[4:2]}),
	.b({(~ n101ll), RUNDISP_SEL[4:0]}),
	.cin(1'b0),
	.cout(),
	.o(wire_ni0l0i_o));
	defparam
		ni0l0i.sgate_representation = 0,
		ni0l0i.width_a = 6,
		ni0l0i.width_b = 6,
		ni0l0i.width_o = 6;
	oper_add   ni1llO
	( 
	.a({wire_ni1O1l_dataout, wire_ni1O1i_dataout, wire_ni1lOO_dataout, wire_ni1lOl_dataout}),
	.b({{3{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_ni1llO_o));
	defparam
		ni1llO.sgate_representation = 0,
		ni1llO.width_a = 4,
		ni1llO.width_b = 4,
		ni1llO.width_o = 4;
	oper_add   ni1lOi
	( 
	.a({1'b0, wire_ni1Oll_o, wire_ni1Oli_o, wire_ni1OiO_o, wire_ni1Oil_o}),
	.b({1'b0, wire_ni1Oii_o, wire_ni1O0O_o, wire_ni1O0l_o, wire_ni1O0i_o}),
	.cin(1'b0),
	.cout(),
	.o(wire_ni1lOi_o));
	defparam
		ni1lOi.sgate_representation = 0,
		ni1lOi.width_a = 5,
		ni1lOi.width_b = 5,
		ni1lOi.width_o = 5;
	oper_decoder   n0001O
	( 
	.i({n0i11i, n00OOO}),
	.o(wire_n0001O_o));
	defparam
		n0001O.width_i = 2,
		n0001O.width_o = 4;
	oper_decoder   n000li
	( 
	.i({n00OOl, n00OOi}),
	.o(wire_n000li_o));
	defparam
		n000li.width_i = 2,
		n000li.width_o = 4;
	oper_decoder   n001ll
	( 
	.i({n0i00i, n0i11l}),
	.o(wire_n001ll_o));
	defparam
		n001ll.width_i = 2,
		n001ll.width_o = 4;
	oper_decoder   n00i1l
	( 
	.i({n00OlO, n00Oll}),
	.o(wire_n00i1l_o));
	defparam
		n00i1l.width_i = 2,
		n00i1l.width_o = 4;
	oper_decoder   n00iiO
	( 
	.i({n00Oli, n00OiO}),
	.o(wire_n00iiO_o));
	defparam
		n00iiO.width_i = 2,
		n00iiO.width_o = 4;
	oper_decoder   n00l1i
	( 
	.i({n00Oil, n00Oii}),
	.o(wire_n00l1i_o));
	defparam
		n00l1i.width_i = 2,
		n00l1i.width_o = 4;
	oper_decoder   n00lil
	( 
	.i({n00O0O, n00O0l}),
	.o(wire_n00lil_o));
	defparam
		n00lil.width_i = 2,
		n00lil.width_o = 4;
	oper_decoder   n00lOO
	( 
	.i({n00O0i, n00O1O}),
	.o(wire_n00lOO_o));
	defparam
		n00lOO.width_i = 2,
		n00lOO.width_o = 4;
	oper_decoder   n10iO
	( 
	.i({PMADATAWIDTH, wire_n010l_dataout, wire_n010i_dataout, wire_n011O_dataout, wire_n011l_dataout}),
	.o(wire_n10iO_o));
	defparam
		n10iO.width_i = 5,
		n10iO.width_o = 32;
	oper_decoder   nlOOil
	( 
	.i({n1llO, n1lll}),
	.o(wire_nlOOil_o));
	defparam
		nlOOil.width_i = 2,
		nlOOil.width_o = 4;
	oper_less_than   ni0O1O
	( 
	.a({wire_ni0l1O_dataout, wire_ni0l1l_dataout, wire_ni0l1i_dataout, wire_ni0iOO_dataout, wire_ni0iOl_dataout, wire_ni0iOi_dataout, wire_ni0ilO_dataout, wire_ni0ill_dataout}),
	.b({ni0i0i, ni1lii, ni1l0O, ni1l0l, ni1l0i, ni1l1O, ni1l1l, ni1l1i}),
	.cin(1'b0),
	.o(wire_ni0O1O_o));
	defparam
		ni0O1O.sgate_representation = 0,
		ni0O1O.width_a = 8,
		ni0O1O.width_b = 8;
	oper_selector   n0001i
	( 
	.data({wire_n0000i_dataout, 1'b0, n1llli}),
	.o(wire_n0001i_o),
	.sel({wire_n0001O_o[3], (wire_n0001O_o[2] | wire_n0001O_o[0]), wire_n0001O_o[1]}));
	defparam
		n0001i.width_data = 3,
		n0001i.width_sel = 3;
	oper_selector   n000il
	( 
	.data({wire_n000ll_dataout, 1'b0, n1ll1l}),
	.o(wire_n000il_o),
	.sel({wire_n000li_o[3], (wire_n000li_o[2] | wire_n000li_o[0]), wire_n000li_o[1]}));
	defparam
		n000il.width_data = 3,
		n000il.width_sel = 3;
	oper_selector   n000OO
	( 
	.data({wire_n00i1O_dataout, 1'b0, n1lill}),
	.o(wire_n000OO_o),
	.sel({wire_n00i1l_o[3], (wire_n00i1l_o[2] | wire_n00i1l_o[0]), wire_n00i1l_o[1]}));
	defparam
		n000OO.width_data = 3,
		n000OO.width_sel = 3;
	oper_selector   n001iO
	( 
	.data({wire_n001lO_dataout, 1'b0, n1lO0l}),
	.o(wire_n001iO_o),
	.sel({wire_n001ll_o[3], (wire_n001ll_o[2] | wire_n001ll_o[0]), wire_n001ll_o[1]}));
	defparam
		n001iO.width_data = 3,
		n001iO.width_sel = 3;
	oper_selector   n00iii
	( 
	.data({wire_n00ili_dataout, 1'b0, n1liii}),
	.o(wire_n00iii_o),
	.sel({wire_n00iiO_o[3], (wire_n00iiO_o[2] | wire_n00iiO_o[0]), wire_n00iiO_o[1]}));
	defparam
		n00iii.width_data = 3,
		n00iii.width_sel = 3;
	oper_selector   n00iOl
	( 
	.data({wire_n00l1l_dataout, 1'b0, n1li0l}),
	.o(wire_n00iOl_o),
	.sel({wire_n00l1i_o[3], (wire_n00l1i_o[2] | wire_n00l1i_o[0]), wire_n00l1i_o[1]}));
	defparam
		n00iOl.width_data = 3,
		n00iOl.width_sel = 3;
	oper_selector   n00l0O
	( 
	.data({wire_n00liO_dataout, 1'b0, n1li1O}),
	.o(wire_n00l0O_o),
	.sel({wire_n00lil_o[3], (wire_n00lil_o[2] | wire_n00lil_o[0]), wire_n00lil_o[1]}));
	defparam
		n00l0O.width_data = 3,
		n00l0O.width_sel = 3;
	oper_selector   n00lOi
	( 
	.data({wire_n00O1i_dataout, 1'b0, n1li1i}),
	.o(wire_n00lOi_o),
	.sel({wire_n00lOO_o[3], (wire_n00lOO_o[2] | wire_n00lOO_o[0]), wire_n00lOO_o[1]}));
	defparam
		n00lOi.width_data = 3,
		n00lOi.width_sel = 3;
	oper_selector   n100l
	( 
	.data({nl11l, n111O, niOil, niOiO, niOli, niOll, niOlO, niOOi, niOOl, niOOO, nl11i}),
	.o(wire_n100l_o),
	.sel({n1l1Oi, n1l1lO, wire_n10iO_o[9:1]}));
	defparam
		n100l.width_data = 11,
		n100l.width_sel = 11;
	oper_selector   n100O
	( 
	.data({nl11O, n10li, niOiO, niOli, niOll, niOlO, niOOi, niOOl, niOOO, nl11i, nl11l}),
	.o(wire_n100O_o),
	.sel({n1l1Oi, n1l1lO, wire_n10iO_o[9:1]}));
	defparam
		n100O.width_data = 11,
		n100O.width_sel = 11;
	oper_selector   n110i
	( 
	.data({niOiO, niO1l, niO1O, niO0i, niO0l, niO0O, niOii, niOil, niOli, niOll, nilOO, niO1i}),
	.o(wire_n110i_o),
	.sel({n1l1ll, n1l1li, n1l1iO, n1l1il, n1l1ii, n1l10O, n1l10l, n1l10i, wire_n10iO_o[17:16], wire_n10iO_o[9:8]}));
	defparam
		n110i.width_data = 12,
		n110i.width_sel = 12;
	oper_selector   n110l
	( 
	.data({niOli, niO1O, niO0i, niO0l, niO0O, niOii, niOil, niOiO, niOll, niOlO, niO1i, niO1l}),
	.o(wire_n110l_o),
	.sel({n1l1ll, n1l1li, n1l1iO, n1l1il, n1l1ii, n1l10O, n1l10l, n1l10i, wire_n10iO_o[17:16], wire_n10iO_o[9:8]}));
	defparam
		n110l.width_data = 12,
		n110l.width_sel = 12;
	oper_selector   n110O
	( 
	.data({niOll, niO0i, niO0l, niO0O, niOii, niOil, niOiO, niOli, niOlO, niOOi, niO1l, niO1O}),
	.o(wire_n110O_o),
	.sel({n1l1ll, n1l1li, n1l1iO, n1l1il, n1l1ii, n1l10O, n1l10l, n1l10i, wire_n10iO_o[17:16], wire_n10iO_o[9:8]}));
	defparam
		n110O.width_data = 12,
		n110O.width_sel = 12;
	oper_selector   n11ii
	( 
	.data({niOlO, niO0l, niO0O, niOii, niOil, niOiO, niOli, niOll, niOOi, niOOl, niO1O, niO0i}),
	.o(wire_n11ii_o),
	.sel({n1l1ll, n1l1li, n1l1iO, n1l1il, n1l1ii, n1l10O, n1l10l, n1l10i, wire_n10iO_o[17:16], wire_n10iO_o[9:8]}));
	defparam
		n11ii.width_data = 12,
		n11ii.width_sel = 12;
	oper_selector   n11il
	( 
	.data({niOOi, niO0O, niOii, niOil, niOiO, niOli, niOll, niOlO, niOOl, niOOO, niO0i, niO0l}),
	.o(wire_n11il_o),
	.sel({n1l1ll, n1l1li, n1l1iO, n1l1il, n1l1ii, n1l10O, n1l10l, n1l10i, wire_n10iO_o[17:16], wire_n10iO_o[9:8]}));
	defparam
		n11il.width_data = 12,
		n11il.width_sel = 12;
	oper_selector   n11iO
	( 
	.data({niOOl, niOii, niOil, niOiO, niOli, niOll, niOlO, niOOi, niOOO, nl11i, niO0l, niO0O}),
	.o(wire_n11iO_o),
	.sel({n1l1ll, n1l1li, n1l1iO, n1l1il, n1l1ii, n1l10O, n1l10l, n1l10i, wire_n10iO_o[17:16], wire_n10iO_o[9:8]}));
	defparam
		n11iO.width_data = 12,
		n11iO.width_sel = 12;
	oper_selector   n11li
	( 
	.data({niOOO, niOil, niOiO, niOli, niOll, niOlO, niOOi, niOOl, nl11i, nl11l, niO0O, niOii}),
	.o(wire_n11li_o),
	.sel({n1l1ll, n1l1li, n1l1iO, n1l1il, n1l1ii, n1l10O, n1l10l, n1l10i, wire_n10iO_o[17:16], wire_n10iO_o[9:8]}));
	defparam
		n11li.width_data = 12,
		n11li.width_sel = 12;
	oper_selector   n11ll
	( 
	.data({nl11i, niOiO, niOli, niOll, niOlO, niOOi, niOOl, niOOO, nl11l, nl11O, niOii, niOil}),
	.o(wire_n11ll_o),
	.sel({n1l1ll, n1l1li, n1l1iO, n1l1il, n1l1ii, n1l10O, n1l10l, n1l10i, wire_n10iO_o[17:16], wire_n10iO_o[9:8]}));
	defparam
		n11ll.width_data = 12,
		n11ll.width_sel = 12;
	oper_selector   n1Oi0i
	( 
	.data({1'b0, wire_n011Oi_dataout, wire_n011ii_dataout, wire_n011Oi_dataout, wire_n011ii_dataout, wire_n1OOll_dataout, wire_n1OO0l_dataout}),
	.o(wire_n1Oi0i_o),
	.sel({n110Oi, n01lOO, n01O1i, n01O1l, n01O1O, n01O0i, n01O0l}));
	defparam
		n1Oi0i.width_data = 7,
		n1Oi0i.width_sel = 7;
	oper_selector   n1Oi0l
	( 
	.data({1'b0, wire_n011Ol_dataout, wire_n011il_dataout, wire_n011Ol_dataout, wire_n011il_dataout, wire_n1OOlO_dataout, wire_n1OO0O_dataout}),
	.o(wire_n1Oi0l_o),
	.sel({n110Oi, n01lOO, n01O1i, n01O1l, n01O1O, n01O0i, n01O0l}));
	defparam
		n1Oi0l.width_data = 7,
		n1Oi0l.width_sel = 7;
	oper_selector   n1Oiii
	( 
	.data({n1O0Oi, wire_n0100l_dataout, {5{wire_n0100i_dataout}}, {2{wire_n1OOOi_dataout}}}),
	.o(wire_n1Oiii_o),
	.sel({n110Ol, n01lll, n01lOl, n01lOO, n01O1i, n01O1l, n01O1O, n01O0i, n01O0l}));
	defparam
		n1Oiii.width_data = 9,
		n1Oiii.width_sel = 9;
	oper_selector   n1OiiO
	( 
	.data({wire_n01l0l_dataout, wire_n01l1O_dataout, wire_n01iOO_dataout, wire_n01l1O_dataout, wire_n01iOO_dataout, wire_n0100O_dataout, {5{wire_n0101O_dataout}}, {2{wire_n01iOO_dataout}}}),
	.o(wire_n1OiiO_o),
	.sel({n1O0li, n01liO, n01llO, n01lli, n01lOi, n01lll, n01lOl, n01lOO, n01O1i, n01O1l, n01O1O, n01O0i, n01O0l}));
	defparam
		n1OiiO.width_data = 13,
		n1OiiO.width_sel = 13;
	oper_selector   n1Oili
	( 
	.data({wire_n01l0O_dataout, wire_n01l1l_dataout, wire_n01iOl_dataout, wire_n01l1l_dataout, wire_n01iOl_dataout, {8{(~ n1O0Ol)}}}),
	.o(wire_n1Oili_o),
	.sel({n1O0li, n01liO, n01llO, n01lli, n01lOi, n01lll, n01lOl, n01lOO, n01O1i, n01O1l, n01O1O, n01O0i, n01O0l}));
	defparam
		n1Oili.width_data = 13,
		n1Oili.width_sel = 13;
	oper_selector   n1Oill
	( 
	.data({n11lii, n11l0l, n11l1O, n11l0l, n11l1O, n11iOl, {5{(~ n01Oii)}}, {2{n11l1O}}}),
	.o(wire_n1Oill_o),
	.sel({n1O0li, n01liO, n01llO, n01lli, n01lOi, n01lll, n01lOl, n01lOO, n01O1i, n01O1l, n01O1O, n01O0i, n01O0l}));
	defparam
		n1Oill.width_data = 13,
		n1Oill.width_sel = 13;
	oper_selector   n1OilO
	( 
	.data({(~ n11lii), wire_n01iii_dataout, 1'b0}),
	.o(wire_n1OilO_o),
	.sel({n1O0li, n01liO, n110OO}));
	defparam
		n1OilO.width_data = 3,
		n1OilO.width_sel = 3;
	oper_selector   n1OiOl
	( 
	.data({1'b0, wire_n01iil_dataout, wire_n01i1O_dataout}),
	.o(wire_n1OiOl_o),
	.sel({n11i1i, n01liO, n01llO}));
	defparam
		n1OiOl.width_data = 3,
		n1OiOl.width_sel = 3;
	oper_selector   n1Ol0l
	( 
	.data({1'b0, wire_n01iiO_dataout, wire_n01i0i_dataout, wire_n010ii_dataout}),
	.o(wire_n1Ol0l_o),
	.sel({n11i0i, n01lli, n01lOi, n01lll}));
	defparam
		n1Ol0l.width_data = 4,
		n1Ol0l.width_sel = 4;
	oper_selector   n1Ol1i
	( 
	.data({1'b0, wire_n01iiO_dataout, wire_n01i0i_dataout, wire_n01iii_dataout}),
	.o(wire_n1Ol1i_o),
	.sel({n11i1l, n01liO, n01llO, n01lli}));
	defparam
		n1Ol1i.width_data = 4,
		n1Ol1i.width_sel = 4;
	oper_selector   n1Ol1O
	( 
	.data({1'b0, wire_n01iil_dataout, wire_n01i1O_dataout}),
	.o(wire_n1Ol1O_o),
	.sel({n11i1O, n01lli, n01lOi}));
	defparam
		n1Ol1O.width_data = 3,
		n1Ol1O.width_sel = 3;
	oper_selector   n1Olii
	( 
	.data({1'b0, wire_n010il_dataout, wire_n0110l_dataout, wire_n1OOOO_dataout}),
	.o(wire_n1Olii_o),
	.sel({n11i0l, n01lll, n01lOl, n01O1i}));
	defparam
		n1Olii.width_data = 4,
		n1Olii.width_sel = 4;
	oper_selector   n1OliO
	( 
	.data({1'b0, wire_n0110i_dataout, wire_n1OOOO_dataout}),
	.o(wire_n1OliO_o),
	.sel({n11i0O, n01lOl, n01O1O}));
	defparam
		n1OliO.width_data = 3,
		n1OliO.width_sel = 3;
	oper_selector   n1Olll
	( 
	.data({1'b0, {2{wire_n0110i_dataout}}, wire_n1OOii_dataout}),
	.o(wire_n1Olll_o),
	.sel({n11iii, n01lOO, n01O1i, n01O0l}));
	defparam
		n1Olll.width_data = 4,
		n1Olll.width_sel = 4;
	oper_selector   n1OlOi
	( 
	.data({1'b0, wire_n0110l_dataout, wire_n0111i_dataout}),
	.o(wire_n1OlOi_o),
	.sel({n11iil, n01lOO, n01O1i}));
	defparam
		n1OlOi.width_data = 3,
		n1OlOi.width_sel = 3;
	oper_selector   n1OlOO
	( 
	.data({1'b0, wire_n0110i_dataout}),
	.o(wire_n1OlOO_o),
	.sel({n11iiO, (~ n11iiO)}));
	defparam
		n1OlOO.width_data = 2,
		n1OlOO.width_sel = 2;
	oper_selector   n1OO1l
	( 
	.data({1'b0, wire_n0110l_dataout, wire_n0111i_dataout}),
	.o(wire_n1OO1l_o),
	.sel({n11iiO, n01O1l, n01O1O}));
	defparam
		n1OO1l.width_data = 3,
		n1OO1l.width_sel = 3;
	oper_selector   n1OO1O
	( 
	.data({1'b0, (~ n11l1O), wire_n1OOil_dataout}),
	.o(wire_n1OO1O_o),
	.sel({n11ili, n01O0i, n01O0l}));
	defparam
		n1OO1O.width_data = 3,
		n1OO1O.width_sel = 3;
	oper_selector   ni010i
	( 
	.data({1'b0, {3{wire_ni00ll_dataout}}, {3{wire_ni01Ol_dataout}}}),
	.o(wire_ni010i_o),
	.sel({n1011O, ni0i0O, ni0iii, ni0iil, ni0iiO, ni0ili, ni0lli}));
	defparam
		ni010i.width_data = 7,
		ni010i.width_sel = 7;
	oper_selector   ni010l
	( 
	.data({1'b0, wire_ni00lO_dataout}),
	.o(wire_ni010l_o),
	.sel({n1010i, (~ n1010i)}));
	defparam
		ni010l.width_data = 2,
		ni010l.width_sel = 2;
	oper_selector   ni011l
	( 
	.data({1'b0, {3{wire_ni00li_dataout}}, {3{wire_ni01Oi_dataout}}}),
	.o(wire_ni011l_o),
	.sel({n1011O, ni0i0O, ni0iii, ni0iil, ni0iiO, ni0ili, ni0lli}));
	defparam
		ni011l.width_data = 7,
		ni011l.width_sel = 7;
	oper_selector   ni01ii
	( 
	.data({1'b0, wire_ni01OO_dataout}),
	.o(wire_ni01ii_o),
	.sel({n1010l, (~ n1010l)}));
	defparam
		ni01ii.width_data = 2,
		ni01ii.width_sel = 2;
	oper_selector   ni1O0i
	( 
	.data({1'b0, niilOi, ni1l1i, nii0Ol}),
	.o(wire_ni1O0i_o),
	.sel({n1011O, n1011l, n11OOO, n1011i}));
	defparam
		ni1O0i.width_data = 4,
		ni1O0i.width_sel = 4;
	oper_selector   ni1O0l
	( 
	.data({1'b0, niilOl, ni1l1l, nii0OO}),
	.o(wire_ni1O0l_o),
	.sel({n1011O, n1011l, n11OOO, n1011i}));
	defparam
		ni1O0l.width_data = 4,
		ni1O0l.width_sel = 4;
	oper_selector   ni1O0O
	( 
	.data({1'b0, niilOO, ni1l1O, niii1i}),
	.o(wire_ni1O0O_o),
	.sel({n1011O, n1011l, n11OOO, n1011i}));
	defparam
		ni1O0O.width_data = 4,
		ni1O0O.width_sel = 4;
	oper_selector   ni1Oii
	( 
	.data({1'b0, niiO1i, ni1l0i, niii1l}),
	.o(wire_ni1Oii_o),
	.sel({n1011O, n1011l, n11OOO, n1011i}));
	defparam
		ni1Oii.width_data = 4,
		ni1Oii.width_sel = 4;
	oper_selector   ni1Oil
	( 
	.data({1'b0, niiliO, wire_ni000l_dataout, nii0li, wire_ni01iO_dataout}),
	.o(wire_ni1Oil_o),
	.sel({n1011O, n1011l, ni0iil, n1011i, ni0lli}));
	defparam
		ni1Oil.width_data = 5,
		ni1Oil.width_sel = 5;
	oper_selector   ni1OiO
	( 
	.data({1'b0, niilli, wire_ni000O_dataout, nii0ll, wire_ni01li_dataout}),
	.o(wire_ni1OiO_o),
	.sel({n1011O, n1011l, ni0iil, n1011i, ni0lli}));
	defparam
		ni1OiO.width_data = 5,
		ni1OiO.width_sel = 5;
	oper_selector   ni1Oli
	( 
	.data({1'b0, niilll, wire_ni00ii_dataout, nii0lO, wire_ni01ll_dataout}),
	.o(wire_ni1Oli_o),
	.sel({n1011O, n1011l, ni0iil, n1011i, ni0lli}));
	defparam
		ni1Oli.width_data = 5,
		ni1Oli.width_sel = 5;
	oper_selector   ni1Oll
	( 
	.data({1'b0, niillO, wire_ni00il_dataout, nii0Oi, wire_ni01lO_dataout}),
	.o(wire_ni1Oll_o),
	.sel({n1011O, n1011l, ni0iil, n1011i, ni0lli}));
	defparam
		ni1Oll.width_data = 5,
		ni1Oll.width_sel = 5;
	oper_selector   nliOi
	( 
	.data({wire_nll0l_dataout, (n1lOli29 & wire_nll1l_dataout), 1'b0}),
	.o(wire_nliOi_o),
	.sel({(n1lOll26 & nlill), nlllO, nlilO}));
	defparam
		nliOi.width_data = 3,
		nliOi.width_sel = 3;
	oper_selector   nliOl
	( 
	.data({n1O1iO, (n1lOlO23 & wire_nll1O_dataout), 1'b0}),
	.o(wire_nliOl_o),
	.sel({nlill, nlllO, nlilO}));
	defparam
		nliOl.width_data = 3,
		nliOl.width_sel = 3;
	oper_selector   nliOO
	( 
	.data({(n1lOOi20 & wire_nll0O_dataout), n1O11l, n01Oli}),
	.o(wire_nliOO_o),
	.sel({nlill, nlllO, nlilO}));
	defparam
		nliOO.width_data = 3,
		nliOO.width_sel = 3;
	oper_selector   nll1i
	( 
	.data({(n1lOOl17 & wire_nllii_dataout), wire_nll0i_dataout, (n1lOOO14 & (~ n01Oli))}),
	.o(wire_nll1i_o),
	.sel({(n1O11i11 & nlill), nlllO, nlilO}));
	defparam
		nll1i.width_data = 3,
		nll1i.width_sel = 3;
	oper_selector   nlOlOl
	( 
	.data({SYNC_COMP_PAT[8], SYNC_COMP_PAT[0], nlO1iO}),
	.o(wire_nlOlOl_o),
	.sel({wire_nlOOil_o[3:2], n1l11O}));
	defparam
		nlOlOl.width_data = 3,
		nlOlOl.width_sel = 3;
	oper_selector   nlOlOO
	( 
	.data({SYNC_COMP_PAT[9], SYNC_COMP_PAT[1], nlO1li}),
	.o(wire_nlOlOO_o),
	.sel({wire_nlOOil_o[3:2], n1l11O}));
	defparam
		nlOlOO.width_data = 3,
		nlOlOO.width_sel = 3;
	oper_selector   nlOO0i
	( 
	.data({SYNC_COMP_PAT[13], SYNC_COMP_PAT[5], nlO1Ol}),
	.o(wire_nlOO0i_o),
	.sel({wire_nlOOil_o[3:2], n1l11O}));
	defparam
		nlOO0i.width_data = 3,
		nlOO0i.width_sel = 3;
	oper_selector   nlOO0l
	( 
	.data({SYNC_COMP_PAT[14], SYNC_COMP_PAT[6], nlO1OO}),
	.o(wire_nlOO0l_o),
	.sel({wire_nlOOil_o[3:2], n1l11O}));
	defparam
		nlOO0l.width_data = 3,
		nlOO0l.width_sel = 3;
	oper_selector   nlOO0O
	( 
	.data({SYNC_COMP_PAT[15], SYNC_COMP_PAT[7], nlO01i}),
	.o(wire_nlOO0O_o),
	.sel({wire_nlOOil_o[3:2], n1l11O}));
	defparam
		nlOO0O.width_data = 3,
		nlOO0O.width_sel = 3;
	oper_selector   nlOO1i
	( 
	.data({SYNC_COMP_PAT[10], SYNC_COMP_PAT[2], nlO1ll}),
	.o(wire_nlOO1i_o),
	.sel({wire_nlOOil_o[3:2], n1l11O}));
	defparam
		nlOO1i.width_data = 3,
		nlOO1i.width_sel = 3;
	oper_selector   nlOO1l
	( 
	.data({SYNC_COMP_PAT[11], SYNC_COMP_PAT[3], nlO1lO}),
	.o(wire_nlOO1l_o),
	.sel({wire_nlOOil_o[3:2], n1l11O}));
	defparam
		nlOO1l.width_data = 3,
		nlOO1l.width_sel = 3;
	oper_selector   nlOO1O
	( 
	.data({SYNC_COMP_PAT[12], SYNC_COMP_PAT[4], nlO1Oi}),
	.o(wire_nlOO1O_o),
	.sel({wire_nlOOil_o[3:2], n1l11O}));
	defparam
		nlOO1O.width_data = 3,
		nlOO1O.width_sel = 3;
	assign
		cg_comma = nlll0i,
		n1000i = ((((((((PMADATAWIDTH | (~ ni0Oii)) | (~ niliO)) | (~ nilil)) | (~ nilii)) | (~ nil0O)) | (~ nil0l)) | (~ wire_nii00l_dataout)) | (~ nilli)),
		n1000l = ((((((((PMADATAWIDTH | (~ ni0Oii)) | (~ niliO)) | (~ nilil)) | (~ nilii)) | (~ nil0O)) | (~ nil0l)) | (~ nil0i)) | (~ wire_nii00l_dataout)),
		n1000O = ((((((((~ PMADATAWIDTH) | (~ ni0Oii)) | niliO) | nilil) | nilii) | nil0O) | nil0l) | (~ wire_nii00l_dataout)),
		n1001i = ((((((((~ PMADATAWIDTH) | (~ ni0Oii)) | (~ nilil)) | (~ nilii)) | (~ nil0O)) | (~ nil0l)) | (~ nil0i)) | (~ wire_nii00l_dataout)),
		n1001l = ((((((((PMADATAWIDTH | (~ ni0Oii)) | (~ niliO)) | (~ nilil)) | (~ nilii)) | (~ wire_nii00l_dataout)) | (~ nilli)) | (~ nilll)) | (~ nillO)),
		n1001O = ((((((((PMADATAWIDTH | (~ ni0Oii)) | (~ niliO)) | (~ nilil)) | (~ nilii)) | (~ nil0O)) | (~ wire_nii00l_dataout)) | (~ nilli)) | (~ nilll)),
		n100ii = ((((((((~ PMADATAWIDTH) | (~ ni0Oii)) | niliO) | nilil) | nilii) | nil0O) | (~ wire_nii00l_dataout)) | nilli),
		n100il = ((((((((~ PMADATAWIDTH) | (~ ni0Oii)) | nilil) | nilii) | nil0O) | nil0l) | nil0i) | (~ wire_nii00l_dataout)),
		n100iO = ((((((((PMADATAWIDTH | (~ ni0Oii)) | niliO) | nilil) | nilii) | (~ wire_nii00l_dataout)) | nilli) | nilll) | nillO),
		n100li = ((((((((PMADATAWIDTH | (~ ni0Oii)) | niliO) | nilil) | nilii) | nil0O) | (~ wire_nii00l_dataout)) | nilli) | nilll),
		n100ll = ((((((((PMADATAWIDTH | (~ ni0Oii)) | niliO) | nilil) | nilii) | nil0O) | nil0l) | (~ wire_nii00l_dataout)) | nilli),
		n100lO = ((((((((PMADATAWIDTH | (~ ni0Oii)) | niliO) | nilil) | nilii) | nil0O) | nil0l) | nil0i) | (~ wire_nii00l_dataout)),
		n100Oi = (((((~ n10iii) | (~ n10i0O)) | (~ n10i0i)) | (~ n10i1l)) | n100Ol),
		n100Ol = (((((((((nil0i & (~ n10Oil)) & (~ n10OiO)) & (~ n1i1ii)) & (~ n10Oll)) & (~ n10OlO)) & (~ n10OOi)) & (~ n10OOl)) & (~ n10OOO)) & (~ n1i11i)),
		n100OO = ((((n10Oil | (~ n10i0O)) | (~ n10i0l)) | (~ n10i1l)) | (~ n10i1i)),
		n1010i = ((((ni0lli | ni0i0l) | ni1iOl) | ni0ili) | ni0iiO),
		n1010l = ((((ni0iil | ni0i0l) | ni1iOl) | ni0iii) | ni0i0O),
		n1010O = ((~ nii0iO) & (~ nii0il)),
		n1011i = (ni0ili | ni0iiO),
		n1011l = (ni0iii | ni0i0O),
		n1011O = (ni0i0l | ni1iOl),
		n101ii = ((~ nii0iO) & nii0il),
		n101il = (ni0i0i & ni1lii),
		n101iO = ((~ nii0il) & (~ niilil)),
		n101li = (nii0il & (~ niilil)),
		n101ll = ((((RUNDISP_SEL[0] | RUNDISP_SEL[1]) | RUNDISP_SEL[4]) | RUNDISP_SEL[3]) | RUNDISP_SEL[2]),
		n101lO = ((((((((~ wire_ni0l1O_dataout) & (~ wire_ni0l1l_dataout)) & (~ wire_ni0l1i_dataout)) & (~ wire_ni0iOO_dataout)) & (~ wire_ni0iOl_dataout)) & wire_ni0iOi_dataout) & (~ wire_ni0ilO_dataout)) & (~ wire_ni0ill_dataout)),
		n101Oi = ((((((((~ wire_ni0l1O_dataout) & (~ wire_ni0l1l_dataout)) & (~ wire_ni0l1i_dataout)) & (~ wire_ni0iOO_dataout)) & (~ wire_ni0iOl_dataout)) & wire_ni0iOi_dataout) & (~ wire_ni0ilO_dataout)) & wire_ni0ill_dataout),
		n101Ol = ((((((((~ PMADATAWIDTH) | (~ ni0Oii)) | (~ niliO)) | (~ nilil)) | (~ nilii)) | (~ nil0O)) | (~ nil0l)) | (~ wire_nii00l_dataout)),
		n101OO = ((((((((~ PMADATAWIDTH) | (~ ni0Oii)) | (~ niliO)) | (~ nilil)) | (~ nilii)) | (~ nil0O)) | (~ wire_nii00l_dataout)) | (~ nilli)),
		n10i0i = (((((n10Oil | n10OiO) | n1i1ii) | n10Oll) | n10OlO) | (~ n10OOi)),
		n10i0l = ((((n10Oil | n10OiO) | n1i1ii) | n10Oll) | (~ n10OlO)),
		n10i0O = (((n10Oil | n10OiO) | n1i1ii) | (~ n10Oll)),
		n10i1i = ((((((((n10Oil | n10OiO) | n1i1ii) | n10Oll) | n10OlO) | n10OOi) | n10OOl) | n10OOO) | (~ n1i11i)),
		n10i1l = (((((((n10Oil | n10OiO) | n1i1ii) | n10Oll) | n10OlO) | n10OOi) | n10OOl) | (~ n10OOO)),
		n10i1O = ((((((n10Oil | n10OiO) | n1i1ii) | n10Oll) | n10OlO) | n10OOi) | (~ n10OOl)),
		n10iii = (n10Oil | (~ n10OiO)),
		n10iil = (((((~ n10l1l) | (~ n10l1i)) | (~ n10iOl)) | (~ n10ilO)) | n10iiO),
		n10iiO = ((((((((((~ n1i11l) & (~ n1i10i)) & (~ n1i10O)) & (~ n1i1iO)) & (~ n1i1lO)) & (~ n1i1OO)) & (~ n1i01O)) & (~ n1i00i)) & (~ n1i00l)) & (n1i0ii | n1i00O)),
		n10ili = ((((n1i11l | (~ n10l1i)) | (~ n10iOO)) | (~ n10ilO)) | (~ n10ill)),
		n10ill = ((((((((n1i11l | n1i10i) | n1i10O) | n1i1iO) | n1i1lO) | n1i1OO) | n1i01O) | n1i00i) | (~ n1i00l)),
		n10ilO = (((((((n1i11l | n1i10i) | n1i10O) | n1i1iO) | n1i1lO) | n1i1OO) | n1i01O) | (~ n1i00i)),
		n10iOi = ((((((n1i11l | n1i10i) | n1i10O) | n1i1iO) | n1i1lO) | n1i1OO) | (~ n1i01O)),
		n10iOl = (((((n1i11l | n1i10i) | n1i10O) | n1i1iO) | n1i1lO) | (~ n1i1OO)),
		n10iOO = ((((n1i11l | n1i10i) | n1i10O) | n1i1iO) | (~ n1i1lO)),
		n10l0i = ((((((((((~ nil0i) & (~ n1i0il)) & (~ n1i0iO)) & n1iiii) & n1i0ll) & n1i0lO) & n1i0Oi) & n1i0Ol) & n1i0OO) & n1ii1i),
		n10l0l = ((((n1i0il | (~ n10lll)) | (~ n10lli)) | (~ n10lii)) | (~ n10l0O)),
		n10l0O = ((((((((n1i0il | n1i0iO) | (~ n1iiii)) | (~ n1i0ll)) | (~ n1i0lO)) | (~ n1i0Oi)) | (~ n1i0Ol)) | (~ n1i0OO)) | n1ii1i),
		n10l1i = (((n1i11l | n1i10i) | n1i10O) | (~ n1i1iO)),
		n10l1l = (n1i11l | (~ n1i10i)),
		n10l1O = (((((~ n10llO) | (~ n10lll)) | (~ n10liO)) | (~ n10lii)) | n10l0i),
		n10lii = (((((((n1i0il | n1i0iO) | (~ n1iiii)) | (~ n1i0ll)) | (~ n1i0lO)) | (~ n1i0Oi)) | (~ n1i0Ol)) | n1i0OO),
		n10lil = ((((((n1i0il | n1i0iO) | (~ n1iiii)) | (~ n1i0ll)) | (~ n1i0lO)) | (~ n1i0Oi)) | n1i0Ol),
		n10liO = (((((n1i0il | n1i0iO) | (~ n1iiii)) | (~ n1i0ll)) | (~ n1i0lO)) | n1i0Oi),
		n10lli = ((((n1i0il | n1i0iO) | (~ n1iiii)) | (~ n1i0ll)) | n1i0lO),
		n10lll = (((n1i0il | n1i0iO) | (~ n1iiii)) | n1i0ll),
		n10llO = (n1i0il | (~ n1i0iO)),
		n10lOi = (((((~ n10Oii) | (~ n10O0O)) | (~ n10O0i)) | (~ n10O1l)) | n10lOl),
		n10lOl = ((((((((((~ n1ii1l) & (~ n1ii0i)) & (~ n1ii0O)) & (~ n1iiiO)) & (~ n1iilO)) & (~ n1iiOO)) & (~ n1il1O)) & (~ n1il0i)) & (~ n1il0l)) & (((~ PMADATAWIDTH) & (~ nilOl)) | (PMADATAWIDTH & (~ nilll)))),
		n10lOO = ((((n1ii1l | (~ n10O0O)) | (~ n10O0l)) | (~ n10O1l)) | (~ n10O1i)),
		n10O0i = (((((n1ii1l | n1ii0i) | n1ii0O) | n1iiiO) | n1iilO) | (~ n1iiOO)),
		n10O0l = ((((n1ii1l | n1ii0i) | n1ii0O) | n1iiiO) | (~ n1iilO)),
		n10O0O = (((n1ii1l | n1ii0i) | n1ii0O) | (~ n1iiiO)),
		n10O1i = ((((((((n1ii1l | n1ii0i) | n1ii0O) | n1iiiO) | n1iilO) | n1iiOO) | n1il1O) | n1il0i) | (~ n1il0l)),
		n10O1l = (((((((n1ii1l | n1ii0i) | n1ii0O) | n1iiiO) | n1iilO) | n1iiOO) | n1il1O) | (~ n1il0i)),
		n10O1O = ((((((n1ii1l | n1ii0i) | n1ii0O) | n1iiiO) | n1iilO) | n1iiOO) | (~ n1il1O)),
		n10Oii = (n1ii1l | (~ n1ii0i)),
		n10Oil = ((~ PMADATAWIDTH) & n1i11O),
		n10OiO = ((~ PMADATAWIDTH) & n10Oli),
		n10Oli = ((((((((niliO & nilil) & nilii) & nil0O) & nil0l) & nil0i) & nilli) & nilll) & nillO),
		n10Oll = ((((((niliO & nilil) & nilii) & nil0O) & nil0l) & nil0i) & nilli),
		n10OlO = (((((niliO & nilil) & nilii) & nil0O) & nil0l) & nil0i),
		n10OOi = ((((nilil & nilii) & nil0O) & nil0l) & nil0i),
		n10OOl = (((nilii & nil0O) & nil0l) & nil0i),
		n10OOO = ((nil0O & nil0l) & nil0i),
		n110Oi = ((((((n01llO | n01lll) | n01liO) | n01lOl) | n1O0li) | n01lOi) | n01lli),
		n110Ol = ((((n01llO | n01liO) | n1O0li) | n01lOi) | n01lli),
		n110OO = ((((((((((n01O0i | n01O1l) | n01lOO) | n01llO) | n01lll) | n01O1O) | n01lOl) | n01O1i) | n01lOi) | n01O0l) | n01lli),
		n11i0i = (((((((((n01O0i | n01O1l) | n01lOO) | n01llO) | n01liO) | n01O1O) | n01lOl) | n1O0li) | n01O1i) | n01O0l),
		n11i0l = (((((((((n01O0i | n01O1l) | n01lOO) | n01llO) | n01liO) | n01O1O) | n1O0li) | n01lOi) | n01O0l) | n01lli),
		n11i0O = ((((((((((n01O0i | n01O1l) | n01lOO) | n01llO) | n01lll) | n01liO) | n1O0li) | n01O1i) | n01lOi) | n01O0l) | n01lli),
		n11i1i = ((((((((((n01O0i | n01O1l) | n01lOO) | n01lll) | n01O1O) | n01lOl) | n1O0li) | n01O1i) | n01lOi) | n01O0l) | n01lli),
		n11i1l = (((((((((n01O0i | n01O1l) | n01lOO) | n01lll) | n01O1O) | n01lOl) | n1O0li) | n01O1i) | n01lOi) | n01O0l),
		n11i1O = ((((((((((n01O0i | n01O1l) | n01lOO) | n01llO) | n01lll) | n01liO) | n01O1O) | n01lOl) | n1O0li) | n01O1i) | n01O0l),
		n11iii = (((((((((n01O0i | n01O1l) | n01llO) | n01lll) | n01liO) | n01O1O) | n01lOl) | n1O0li) | n01lOi) | n01lli),
		n11iil = ((((((((((n01O0i | n01O1l) | n01llO) | n01lll) | n01liO) | n01O1O) | n01lOl) | n1O0li) | n01lOi) | n01O0l) | n01lli),
		n11iiO = ((((((((((n01O0i | n01lOO) | n01llO) | n01lll) | n01liO) | n01lOl) | n1O0li) | n01O1i) | n01lOi) | n01O0l) | n01lli),
		n11ili = ((((((((((n01O1l | n01lOO) | n01llO) | n01lll) | n01liO) | n01O1O) | n01lOl) | n1O0li) | n01O1i) | n01lOi) | n01lli),
		n11ill = ((n01Oii & (~ n11lil)) & (n01lil & n1Oi1O)),
		n11ilO = (n01Oii & n11lil),
		n11iOi = (n11l1i | n11iOO),
		n11iOl = ((~ n01Oii) | n11l1l),
		n11iOO = (n01Oii & (nlll0i & (~ GE_XAUI_SEL))),
		n11l0i = (n01Oii & (nlll0i & (~ n1O0Ol))),
		n11l0l = ((~ n01Oii) | n11l1l),
		n11l0O = (n01Oii & n11l1i),
		n11l1i = (GE_XAUI_SEL & n11liO),
		n11l1l = ((GE_XAUI_SEL & (~ n11liO)) | ((~ GE_XAUI_SEL) & nlliiO)),
		n11l1O = ((~ n01Oii) | n11lil),
		n11lii = ((~ nlll0i) | (~ n01Oii)),
		n11lil = (nlliiO | (n1O0Ol & (nlll0i & GE_XAUI_SEL))),
		n11liO = ((~ nlliOO) & (~ nlliiO)),
		n11lli = (nlO1iO & nlO1li),
		n11lll = ((~ nlO1iO) & (~ nlO1li)),
		n11llO = ((~ nlO1iO) & nlO1li),
		n11lOi = (nlO1iO & (~ nlO1li)),
		n11lOl = (n11O1l & n1iOii),
		n11lOO = ((~ nlO1lO) & ((~ nlO1ll) & ((~ nlO1iO) & (~ nlO1li)))),
		n11O0i = (nlO1OO & nlO01i),
		n11O0l = ((~ nlO1OO) & (~ nlO01i)),
		n11O0O = ((~ nlO1OO) & nlO01i),
		n11O1i = (nlO1lO & (nlO1ll & (nlO1iO & nlO1li))),
		n11O1l = (nlO1Oi & nlO1Ol),
		n11O1O = (((((~ nlO1lO) & (nlO1ll & n11lli)) | (nlO1lO & ((~ nlO1ll) & n11lli))) | (nlO1lO & (nlO1ll & (nlO1iO & (~ nlO1li))))) | (nlO1lO & (nlO1ll & ((~ nlO1iO) & nlO1li)))),
		n11Oii = (nlO1OO & (~ nlO01i)),
		n11Oil = (n11O1i & n1iO0O),
		n11OiO = ((n11O1l & n11O1i) | (n11O1l & n11O1O)),
		n11Oli = (n11O1i & n1iOil),
		n11Oll = ((n11O1l & (~ wire_n0l1lO_dataout)) | (n1iOil & wire_n0l1lO_dataout)),
		n11OlO = (nlO1OO ^ nlO01l),
		n11OOi = (((((~ nlOOiO) & (nlO01l & n11O0i)) | (nlOOiO & ((~ nlO01l) & n11O0i))) | (nlOOiO & (nlO01l & (nlO1OO & (~ nlO01i))))) | (nlOOiO & (nlO01l & ((~ nlO1OO) & nlO01i)))),
		n11OOl = (nlOOiO & (nlO01l & (nlO1OO & nlO01i))),
		n11OOO = (ni0lli | ni0iil),
		n1i00i = (((~ PMADATAWIDTH) & ((nilll & nillO) & nilOl)) | (PMADATAWIDTH & ((niliO & nilli) & nilll))),
		n1i00l = (((~ PMADATAWIDTH) & (nillO & nilOl)) | (PMADATAWIDTH & (nilli & nilll))),
		n1i00O = (PMADATAWIDTH & nilll),
		n1i01i = ((((niliO & nilil) & nilii) & nilli) & nilll),
		n1i01l = ((((niliO & nilli) & nilll) & nillO) & nilOl),
		n1i01O = (((~ PMADATAWIDTH) & (((nilli & nilll) & nillO) & nilOl)) | (PMADATAWIDTH & (((niliO & nilil) & nilli) & nilll))),
		n1i0ii = ((~ PMADATAWIDTH) & nilOl),
		n1i0il = ((~ PMADATAWIDTH) & (~ n1ii1O)),
		n1i0iO = ((~ PMADATAWIDTH) & (~ n1i0li)),
		n1i0li = ((((((((niliO | nilil) | nilii) | nil0O) | nil0l) | nil0i) | nilli) | nilll) | nillO),
		n1i0ll = ((((((niliO | nilil) | nilii) | nil0O) | nil0l) | nil0i) | nilli),
		n1i0lO = (((((niliO | nilil) | nilii) | nil0O) | nil0l) | nil0i),
		n1i0Oi = ((((nilil | nilii) | nil0O) | nil0l) | nil0i),
		n1i0Ol = (((nilii | nil0O) | nil0l) | nil0i),
		n1i0OO = ((nil0O | nil0l) | nil0i),
		n1i10i = ((~ PMADATAWIDTH) & n1i10l),
		n1i10l = ((((((((niliO & nilil) & nilii) & nil0O) & nil0l) & nilli) & nilll) & nillO) & nilOl),
		n1i10O = (((~ PMADATAWIDTH) & n1i1il) | (PMADATAWIDTH & n1i1ii)),
		n1i11i = (nil0l & nil0i),
		n1i11l = ((~ PMADATAWIDTH) & n1i11O),
		n1i11O = (((((((((niliO & nilil) & nilii) & nil0O) & nil0l) & nil0i) & nilli) & nilll) & nillO) & nilOl),
		n1i1ii = (((((((niliO & nilil) & nilii) & nil0O) & nil0l) & nil0i) & nilli) & nilll),
		n1i1il = (((((((niliO & nilil) & nilii) & nil0O) & nilli) & nilll) & nillO) & nilOl),
		n1i1iO = (((~ PMADATAWIDTH) & n1i1ll) | (PMADATAWIDTH & n1i1li)),
		n1i1li = ((((((niliO & nilil) & nilii) & nil0O) & nil0l) & nilli) & nilll),
		n1i1ll = ((((((niliO & nilil) & nilii) & nilli) & nilll) & nillO) & nilOl),
		n1i1lO = (((~ PMADATAWIDTH) & n1i1Ol) | (PMADATAWIDTH & n1i1Oi)),
		n1i1Oi = (((((niliO & nilil) & nilii) & nil0O) & nilli) & nilll),
		n1i1Ol = (((((niliO & nilil) & nilli) & nilll) & nillO) & nilOl),
		n1i1OO = (((~ PMADATAWIDTH) & n1i01l) | (PMADATAWIDTH & n1i01i)),
		n1ii0i = ((~ PMADATAWIDTH) & (~ n1ii0l)),
		n1ii0l = ((((((((niliO | nilil) | nilii) | nil0O) | nil0l) | nilli) | nilll) | nillO) | nilOl),
		n1ii0O = (((~ PMADATAWIDTH) & (~ n1iiil)) | (PMADATAWIDTH & (~ n1iiii))),
		n1ii1i = (nil0l | nil0i),
		n1ii1l = ((~ PMADATAWIDTH) & (~ n1ii1O)),
		n1ii1O = (((((((((niliO | nilil) | nilii) | nil0O) | nil0l) | nil0i) | nilli) | nilll) | nillO) | nilOl),
		n1iiii = (((((((niliO | nilil) | nilii) | nil0O) | nil0l) | nil0i) | nilli) | nilll),
		n1iiil = (((((((niliO | nilil) | nilii) | nil0O) | nilli) | nilll) | nillO) | nilOl),
		n1iiiO = (((~ PMADATAWIDTH) & (~ n1iill)) | (PMADATAWIDTH & (~ n1iili))),
		n1iili = ((((((niliO | nilil) | nilii) | nil0O) | nil0l) | nilli) | nilll),
		n1iill = ((((((niliO | nilil) | nilii) | nilli) | nilll) | nillO) | nilOl),
		n1iilO = (((~ PMADATAWIDTH) & (~ n1iiOl)) | (PMADATAWIDTH & (~ n1iiOi))),
		n1iiOi = (((((niliO | nilil) | nilii) | nil0O) | nilli) | nilll),
		n1iiOl = (((((niliO | nilil) | nilli) | nilll) | nillO) | nilOl),
		n1iiOO = (((~ PMADATAWIDTH) & (~ n1il1l)) | (PMADATAWIDTH & (~ n1il1i))),
		n1il0i = (((~ PMADATAWIDTH) & (~ ((nilll | nillO) | nilOl))) | (PMADATAWIDTH & (~ ((niliO | nilli) | nilll)))),
		n1il0l = (((~ PMADATAWIDTH) & (~ (nillO | nilOl))) | (PMADATAWIDTH & (~ (nilli | nilll)))),
		n1il0O = (nlO1Ol & ((~ nlO1Oi) & n1iOii)),
		n1il1i = ((((niliO | nilil) | nilii) | nilli) | nilll),
		n1il1l = ((((niliO | nilli) | nilll) | nillO) | nilOl),
		n1il1O = (((~ PMADATAWIDTH) & (~ (((nilli | nilll) | nillO) | nilOl))) | (PMADATAWIDTH & (~ (((niliO | nilil) | nilli) | nilll)))),
		n1ilii = ((~ nlO1Ol) & (nlO1Oi & n11O1O)),
		n1ilil = ((~ nlO1Ol) & ((~ nlO1Oi) & ((~ nlO1lO) & ((~ nlO1ll) & (nlO1iO & nlO1li))))),
		n1iliO = (nlO1Ol & (nlO1Oi & (nlO1lO & (nlO1ll & ((~ nlO1iO) & (~ nlO1li)))))),
		n1illi = ((((((((((~ (nlO1iO ^ (~ SYNC_COMP_PAT[0]))) & (~ (nlO1li ^ (~ SYNC_COMP_PAT[1])))) & (~ (nlO1ll ^ (~ SYNC_COMP_PAT[2])))) & (~ (nlO1lO ^ (~ SYNC_COMP_PAT[3])))) & (~ (nlO1Oi ^ (~ SYNC_COMP_PAT[4])))) & (~ (nlO1Ol ^ (~ SYNC_COMP_PAT[5])))) & (~ (nlO1OO ^ (~ SYNC_COMP_PAT[6])))) & (~ (nlO01i ^ (~ SYNC_COMP_PAT[7])))) & (~ (nlO01l ^ (~ SYNC_COMP_PAT[8])))) & (~ (nlOOiO ^ (~ SYNC_COMP_PAT[9])))),
		n1illl = ((((((((((~ (nlO1iO ^ SYNC_COMP_PAT[0])) & (~ (nlO1li ^ SYNC_COMP_PAT[1]))) & (~ (nlO1ll ^ SYNC_COMP_PAT[2]))) & (~ (nlO1lO ^ SYNC_COMP_PAT[3]))) & (~ (nlO1Oi ^ SYNC_COMP_PAT[4]))) & (~ (nlO1Ol ^ SYNC_COMP_PAT[5]))) & (~ (nlO1OO ^ SYNC_COMP_PAT[6]))) & (~ (nlO01i ^ SYNC_COMP_PAT[7]))) & (~ (nlO01l ^ SYNC_COMP_PAT[8]))) & (~ (nlOOiO ^ SYNC_COMP_PAT[9]))),
		n1illO = (((~ (((n1iO1O | n11OOl) | (((((~ nlO1OO) & n11OOi) | (nlO1OO & n1iO1l)) & (~ n11Oll)) & (~ (((n1iliO | n1ilil) | n1il0O) | n1ilii)))) | ((((~ nlOOiO) & n11OOi) | (nlOOiO & n1iO1l)) & (n1ilil | (n11Oll | n1iliO))))) & (~ ((n11Oli | (n11OiO | n11Oil)) | (n1iOOi | (n1iOll | (n1iOlO | n1iOli)))))) & (~ ((((((~ nlO01i) & n1iliO) & n11OlO) | (n11OlO & (nlO01i & n1ilil))) & IB_INVALID_CODE[0]) | (((nlO01l & (nlO01i & (n1iliO & n1ilOl))) | ((~ nlO01l) & ((~ nlO01i) & (n1ilil & n1ilOl)))) & IB_INVALID_CODE[1])))),
		n1ilOi = ((((((~ nlll1i) & (n1iOOl | (n1iOOi | (((n1iOlO | (n1iOll | n1iOli)) | (n1iOiO & n1iOil)) | (n1iOii & n1iO0O))))) | (nlll1i & (n1iO0l | ((~ nlO1lO) & n1iO0i)))) | ((~ wire_n0l1lO_dataout) & ((n1iO1O | n1iO1l) | n1iO1i))) | (wire_n0l1lO_dataout & (n1ilOO | (nlO01i & (nlO1OO & n1ilOl))))) & (~ DISABLE_RX_DISP)),
		n1ilOl = (((((((~ nlOOiO) & ((~ nlO01l) & (nlO1OO & nlO01i))) | ((~ nlOOiO) & (nlO01l & n11Oii))) | ((~ nlOOiO) & (nlO01l & n11O0O))) | (nlOOiO & ((~ nlO01l) & n11Oii))) | (nlOOiO & ((~ nlO01l) & n11O0O))) | (nlOOiO & (nlO01l & ((~ nlO1OO) & (~ nlO01i))))),
		n1ilOO = (n11OOl | n11OOi),
		n1iO0i = (n11O1O & n1iOil),
		n1iO0l = ((((n11OiO | (n11O1l & n1iOiO)) | (n11O1O & n1iO0O)) | n11Oil) | n11Oli),
		n1iO0O = ((nlO1Oi & (~ nlO1Ol)) | ((~ nlO1Oi) & nlO1Ol)),
		n1iO1i = ((~ nlO01i) & ((~ nlO1OO) & n1ilOl)),
		n1iO1l = (((((~ nlOOiO) & ((~ nlO01l) & (nlO1OO & (~ nlO01i)))) | ((~ nlOOiO) & ((~ nlO01l) & ((~ nlO1OO) & nlO01i)))) | ((~ nlOOiO) & (nlO01l & n11O0l))) | (nlOOiO & ((~ nlO01l) & n11O0l))),
		n1iO1O = ((~ nlOOiO) & ((~ nlO01l) & ((~ nlO1OO) & (~ nlO01i)))),
		n1iOii = (((((~ nlO1lO) & ((~ nlO1ll) & (nlO1iO & (~ nlO1li)))) | ((~ nlO1lO) & ((~ nlO1ll) & ((~ nlO1iO) & nlO1li)))) | ((~ nlO1lO) & (nlO1ll & n11lll))) | (nlO1lO & ((~ nlO1ll) & n11lll))),
		n1iOil = ((~ nlO1Oi) & (~ nlO1Ol)),
		n1iOiO = (((((((~ nlO1lO) & ((~ nlO1ll) & (nlO1iO & nlO1li))) | ((~ nlO1lO) & (nlO1ll & n11lOi))) | ((~ nlO1lO) & (nlO1ll & n11llO))) | (nlO1lO & ((~ nlO1ll) & n11lOi))) | (nlO1lO & ((~ nlO1ll) & n11llO))) | (nlO1lO & (nlO1ll & ((~ nlO1iO) & (~ nlO1li))))),
		n1iOli = (n1iOil & n11lOO),
		n1iOll = (n1iO0O & n11lOO),
		n1iOlO = (n1iOii & n1iOil),
		n1iOOi = (n11O1l & n11lOO),
		n1iOOl = (nlO1lO & n11lOl),
		n1iOOO = (PMADATAWIDTH & (~ n1l11l)),
		n1l00i = ((((((((wire_n010O_dataout | wire_n01il_dataout) | wire_n01li_dataout) | wire_n01Oi_dataout) | wire_n001i_dataout) | wire_n000i_dataout) | wire_n00ii_dataout) | wire_n00li_dataout) | (~ wire_n00Oi_dataout)),
		n1l00l = (((((((wire_n010O_dataout | wire_n01il_dataout) | wire_n01li_dataout) | wire_n01Oi_dataout) | wire_n001i_dataout) | wire_n000i_dataout) | wire_n00ii_dataout) | (~ wire_n00li_dataout)),
		n1l00O = ((((((wire_n010O_dataout | wire_n01il_dataout) | wire_n01li_dataout) | wire_n01Oi_dataout) | wire_n001i_dataout) | wire_n000i_dataout) | (~ wire_n00ii_dataout)),
		n1l01i = ((((~ n1l1i) & (~ n1i1O)) & (~ n1i1l)) & (~ n1i1i)),
		n1l01l = (((((((((wire_n010O_dataout | (~ n1l0ll)) | (~ n1l0li)) | (~ n1l0iO)) | (~ n1l0il)) | (~ n1l0ii)) | (~ n1l00O)) | (~ n1l00l)) | (~ n1l00i)) | n1l01O),
		n1l01O = ((((((((((~ wire_n010O_dataout) & (~ wire_n01il_dataout)) & (~ wire_n01li_dataout)) & (~ wire_n01Oi_dataout)) & (~ wire_n001i_dataout)) & (~ wire_n000i_dataout)) & (~ wire_n00ii_dataout)) & (~ wire_n00li_dataout)) & (~ wire_n00Oi_dataout)) & wire_n0i1i_dataout),
		n1l0ii = (((((wire_n010O_dataout | wire_n01il_dataout) | wire_n01li_dataout) | wire_n01Oi_dataout) | wire_n001i_dataout) | (~ wire_n000i_dataout)),
		n1l0il = ((((wire_n010O_dataout | wire_n01il_dataout) | wire_n01li_dataout) | wire_n01Oi_dataout) | (~ wire_n001i_dataout)),
		n1l0iO = (((wire_n010O_dataout | wire_n01il_dataout) | wire_n01li_dataout) | (~ wire_n01Oi_dataout)),
		n1l0li = ((wire_n010O_dataout | wire_n01il_dataout) | (~ wire_n01li_dataout)),
		n1l0ll = (wire_n010O_dataout | (~ wire_n01il_dataout)),
		n1l0lO = ((((((((((~ (SYNC_COMP_PAT[0] ^ wire_n0i0i_dataout)) & (~ (SYNC_COMP_PAT[1] ^ wire_n0i0l_dataout))) & (~ (SYNC_COMP_PAT[2] ^ wire_n0i0O_dataout))) & (~ (SYNC_COMP_PAT[3] ^ wire_n0iii_dataout))) & (~ (SYNC_COMP_PAT[4] ^ wire_n0iil_dataout))) & (~ (SYNC_COMP_PAT[5] ^ wire_n0iiO_dataout))) & (~ (SYNC_COMP_PAT[6] ^ wire_n0ili_dataout))) & (~ (wire_n0ill_dataout ^ wire_niilO_dataout))) & (~ (wire_n0ilO_dataout ^ wire_niiOi_dataout))) & (~ (wire_n0iOi_dataout ^ wire_niiOl_dataout))),
		n1l0Oi = ((((((((((~ (wire_ni0ii_dataout ^ wire_n0i0i_dataout)) & (~ (wire_ni0il_dataout ^ wire_n0i0l_dataout))) & (~ (wire_ni0iO_dataout ^ wire_n0i0O_dataout))) & (~ (wire_ni0li_dataout ^ wire_n0iii_dataout))) & (~ (wire_ni0ll_dataout ^ wire_n0iil_dataout))) & (~ (wire_ni0lO_dataout ^ wire_n0iiO_dataout))) & (~ (wire_ni0Oi_dataout ^ wire_n0ili_dataout))) & (~ (wire_ni0Ol_dataout ^ wire_n0ill_dataout))) & (~ (wire_ni0OO_dataout ^ wire_n0ilO_dataout))) & (~ (wire_nii1i_dataout ^ wire_n0iOi_dataout))),
		n1l0Ol = ((((((((((~ (SYNC_COMP_PAT[0] ^ wire_n0liO_dataout)) & (~ (SYNC_COMP_PAT[1] ^ wire_n0lli_dataout))) & (~ (SYNC_COMP_PAT[2] ^ wire_n0lll_dataout))) & (~ (SYNC_COMP_PAT[3] ^ wire_n0llO_dataout))) & (~ (SYNC_COMP_PAT[4] ^ wire_n0lOi_dataout))) & (~ (SYNC_COMP_PAT[5] ^ wire_n0lOl_dataout))) & (~ (SYNC_COMP_PAT[6] ^ wire_n0lOO_dataout))) & (~ (wire_niilO_dataout ^ wire_n0O1i_dataout))) & (~ (wire_niiOi_dataout ^ wire_n0O1l_dataout))) & (~ (wire_niiOl_dataout ^ wire_n0O1O_dataout))),
		n1l0OO = ((((((((((~ (wire_ni0ii_dataout ^ wire_n0liO_dataout)) & (~ (wire_ni0il_dataout ^ wire_n0lli_dataout))) & (~ (wire_ni0iO_dataout ^ wire_n0lll_dataout))) & (~ (wire_ni0li_dataout ^ wire_n0llO_dataout))) & (~ (wire_ni0ll_dataout ^ wire_n0lOi_dataout))) & (~ (wire_ni0lO_dataout ^ wire_n0lOl_dataout))) & (~ (wire_ni0Oi_dataout ^ wire_n0lOO_dataout))) & (~ (wire_ni0Ol_dataout ^ wire_n0O1i_dataout))) & (~ (wire_ni0OO_dataout ^ wire_n0O1l_dataout))) & (~ (wire_nii1i_dataout ^ wire_n0O1O_dataout))),
		n1l10i = (wire_n10iO_o[1] | wire_n10iO_o[19]),
		n1l10l = (wire_n10iO_o[2] | wire_n10iO_o[20]),
		n1l10O = (wire_n10iO_o[3] | wire_n10iO_o[21]),
		n1l11i = (n1lll & (PMADATAWIDTH & n1llO)),
		n1l11l = (n1llO & n1lll),
		n1l11O = (wire_nlOOil_o[1] | wire_nlOOil_o[0]),
		n1l1ii = (wire_n10iO_o[4] | wire_n10iO_o[22]),
		n1l1il = (wire_n10iO_o[5] | wire_n10iO_o[23]),
		n1l1iO = (wire_n10iO_o[6] | wire_n10iO_o[24]),
		n1l1li = (wire_n10iO_o[7] | wire_n10iO_o[25]),
		n1l1ll = (((((((((((((wire_n10iO_o[31] | wire_n10iO_o[30]) | wire_n10iO_o[29]) | wire_n10iO_o[28]) | wire_n10iO_o[27]) | wire_n10iO_o[26]) | wire_n10iO_o[15]) | wire_n10iO_o[14]) | wire_n10iO_o[13]) | wire_n10iO_o[12]) | wire_n10iO_o[11]) | wire_n10iO_o[10]) | wire_n10iO_o[0]) | wire_n10iO_o[18]),
		n1l1lO = (((((((((wire_n10iO_o[17] | wire_n10iO_o[16]) | wire_n10iO_o[18]) | wire_n10iO_o[25]) | wire_n10iO_o[24]) | wire_n10iO_o[23]) | wire_n10iO_o[22]) | wire_n10iO_o[21]) | wire_n10iO_o[20]) | wire_n10iO_o[19]),
		n1l1Oi = ((((((((((((wire_n10iO_o[31] | wire_n10iO_o[30]) | wire_n10iO_o[29]) | wire_n10iO_o[28]) | wire_n10iO_o[27]) | wire_n10iO_o[26]) | wire_n10iO_o[15]) | wire_n10iO_o[14]) | wire_n10iO_o[13]) | wire_n10iO_o[12]) | wire_n10iO_o[11]) | wire_n10iO_o[10]) | wire_n10iO_o[0]),
		n1l1Ol = (PMADATAWIDTH & n1l01i),
		n1l1OO = ((~ PMADATAWIDTH) & n1l01i),
		n1li0i = ((((((((((~ (niOOi ^ wire_ni0ii_dataout)) & (~ (niOOl ^ wire_ni0il_dataout))) & (~ (niOOO ^ wire_ni0iO_dataout))) & (~ (nl11i ^ wire_ni0li_dataout))) & (~ (nl11l ^ wire_ni0ll_dataout))) & (~ (nl11O ^ wire_ni0lO_dataout))) & (~ (wire_ni0Oi_dataout ^ nl10i))) & (~ (wire_ni0Ol_dataout ^ wire_n0OiO_dataout))) & (~ (wire_ni0OO_dataout ^ wire_n0Oli_dataout))) & (~ (wire_nii1i_dataout ^ wire_n0Oll_dataout))),
		n1li0l = ((((((((((~ (SYNC_COMP_PAT[0] ^ niOOl)) & (~ (SYNC_COMP_PAT[1] ^ niOOO))) & (~ (SYNC_COMP_PAT[2] ^ nl11i))) & (~ (SYNC_COMP_PAT[3] ^ nl11l))) & (~ (SYNC_COMP_PAT[4] ^ nl11O))) & (~ (SYNC_COMP_PAT[5] ^ nl10i))) & (~ (SYNC_COMP_PAT[6] ^ nl10l))) & (~ (wire_niilO_dataout ^ wire_n0OOi_dataout))) & (~ (wire_niiOi_dataout ^ wire_n0OOl_dataout))) & (~ (wire_niiOl_dataout ^ wire_n0OOO_dataout))),
		n1li0O = ((((((((((~ (niOOl ^ wire_ni0ii_dataout)) & (~ (niOOO ^ wire_ni0il_dataout))) & (~ (nl11i ^ wire_ni0iO_dataout))) & (~ (nl11l ^ wire_ni0li_dataout))) & (~ (nl11O ^ wire_ni0ll_dataout))) & (~ (wire_ni0lO_dataout ^ nl10i))) & (~ (wire_ni0Oi_dataout ^ nl10l))) & (~ (wire_ni0Ol_dataout ^ wire_n0OOi_dataout))) & (~ (wire_ni0OO_dataout ^ wire_n0OOl_dataout))) & (~ (wire_nii1i_dataout ^ wire_n0OOO_dataout))),
		n1li1i = ((((((((((~ (SYNC_COMP_PAT[0] ^ niOlO)) & (~ (SYNC_COMP_PAT[1] ^ niOOi))) & (~ (SYNC_COMP_PAT[2] ^ niOOl))) & (~ (SYNC_COMP_PAT[3] ^ niOOO))) & (~ (SYNC_COMP_PAT[4] ^ nl11i))) & (~ (SYNC_COMP_PAT[5] ^ nl11l))) & (~ (SYNC_COMP_PAT[6] ^ nl11O))) & (~ (wire_niilO_dataout ^ wire_n0O0l_dataout))) & (~ (wire_niiOi_dataout ^ wire_n0O0O_dataout))) & (~ (wire_niiOl_dataout ^ wire_n0Oii_dataout))),
		n1li1l = ((((((((((~ (niOlO ^ wire_ni0ii_dataout)) & (~ (niOOi ^ wire_ni0il_dataout))) & (~ (niOOl ^ wire_ni0iO_dataout))) & (~ (niOOO ^ wire_ni0li_dataout))) & (~ (nl11i ^ wire_ni0ll_dataout))) & (~ (nl11l ^ wire_ni0lO_dataout))) & (~ (nl11O ^ wire_ni0Oi_dataout))) & (~ (wire_ni0Ol_dataout ^ wire_n0O0l_dataout))) & (~ (wire_ni0OO_dataout ^ wire_n0O0O_dataout))) & (~ (wire_nii1i_dataout ^ wire_n0Oii_dataout))),
		n1li1O = ((((((((((~ (SYNC_COMP_PAT[0] ^ niOOi)) & (~ (SYNC_COMP_PAT[1] ^ niOOl))) & (~ (SYNC_COMP_PAT[2] ^ niOOO))) & (~ (SYNC_COMP_PAT[3] ^ nl11i))) & (~ (SYNC_COMP_PAT[4] ^ nl11l))) & (~ (SYNC_COMP_PAT[5] ^ nl11O))) & (~ (SYNC_COMP_PAT[6] ^ nl10i))) & (~ (wire_niilO_dataout ^ wire_n0OiO_dataout))) & (~ (wire_niiOi_dataout ^ wire_n0Oli_dataout))) & (~ (wire_niiOl_dataout ^ wire_n0Oll_dataout))),
		n1liii = ((((((((((~ (SYNC_COMP_PAT[0] ^ niOOO)) & (~ (SYNC_COMP_PAT[1] ^ nl11i))) & (~ (SYNC_COMP_PAT[2] ^ nl11l))) & (~ (SYNC_COMP_PAT[3] ^ nl11O))) & (~ (SYNC_COMP_PAT[4] ^ nl10i))) & (~ (SYNC_COMP_PAT[5] ^ nl10l))) & (~ (SYNC_COMP_PAT[6] ^ nl10O))) & (~ (wire_niilO_dataout ^ wire_ni11l_dataout))) & (~ (wire_niiOi_dataout ^ wire_ni11O_dataout))) & (~ (wire_niiOl_dataout ^ wire_ni10i_dataout))),
		n1liil = ((((((((((~ (niOOO ^ wire_ni0ii_dataout)) & (~ (nl11i ^ wire_ni0il_dataout))) & (~ (nl11l ^ wire_ni0iO_dataout))) & (~ (nl11O ^ wire_ni0li_dataout))) & (~ (wire_ni0ll_dataout ^ nl10i))) & (~ (wire_ni0lO_dataout ^ nl10l))) & (~ (wire_ni0Oi_dataout ^ nl10O))) & (~ (wire_ni0Ol_dataout ^ wire_ni11l_dataout))) & (~ (wire_ni0OO_dataout ^ wire_ni11O_dataout))) & (~ (wire_nii1i_dataout ^ wire_ni10i_dataout))),
		n1lill = ((((((((((~ (SYNC_COMP_PAT[0] ^ nl11i)) & (~ (SYNC_COMP_PAT[1] ^ nl11l))) & (~ (SYNC_COMP_PAT[2] ^ nl11O))) & (~ (SYNC_COMP_PAT[3] ^ nl10i))) & (~ (SYNC_COMP_PAT[4] ^ nl10l))) & (~ (SYNC_COMP_PAT[5] ^ nl10O))) & (~ (SYNC_COMP_PAT[6] ^ nl1ii))) & (~ (wire_niilO_dataout ^ wire_ni10O_dataout))) & (~ (wire_niiOi_dataout ^ wire_ni1ii_dataout))) & (~ (wire_niiOl_dataout ^ wire_ni1il_dataout))),
		n1lilO = ((((((((((~ (nl11i ^ wire_ni0ii_dataout)) & (~ (nl11l ^ wire_ni0il_dataout))) & (~ (nl11O ^ wire_ni0iO_dataout))) & (~ (wire_ni0li_dataout ^ nl10i))) & (~ (wire_ni0ll_dataout ^ nl10l))) & (~ (wire_ni0lO_dataout ^ nl10O))) & (~ (wire_ni0Oi_dataout ^ nl1ii))) & (~ (wire_ni0Ol_dataout ^ wire_ni10O_dataout))) & (~ (wire_ni0OO_dataout ^ wire_ni1ii_dataout))) & (~ (wire_nii1i_dataout ^ wire_ni1il_dataout))),
		n1ll1l = ((((((((((~ (SYNC_COMP_PAT[0] ^ nl11l)) & (~ (SYNC_COMP_PAT[1] ^ nl11O))) & (~ (SYNC_COMP_PAT[2] ^ nl10i))) & (~ (SYNC_COMP_PAT[3] ^ nl10l))) & (~ (SYNC_COMP_PAT[4] ^ nl10O))) & (~ (SYNC_COMP_PAT[5] ^ nl1ii))) & (~ (SYNC_COMP_PAT[6] ^ nl1il))) & (~ (wire_niilO_dataout ^ wire_ni1li_dataout))) & (~ (wire_niiOi_dataout ^ wire_ni1ll_dataout))) & (~ (wire_niiOl_dataout ^ wire_ni1lO_dataout))),
		n1ll1O = ((((((((((~ (nl11l ^ wire_ni0ii_dataout)) & (~ (nl11O ^ wire_ni0il_dataout))) & (~ (wire_ni0iO_dataout ^ nl10i))) & (~ (wire_ni0li_dataout ^ nl10l))) & (~ (wire_ni0ll_dataout ^ nl10O))) & (~ (wire_ni0lO_dataout ^ nl1ii))) & (~ (wire_ni0Oi_dataout ^ nl1il))) & (~ (wire_ni0Ol_dataout ^ wire_ni1li_dataout))) & (~ (wire_ni0OO_dataout ^ wire_ni1ll_dataout))) & (~ (wire_nii1i_dataout ^ wire_ni1lO_dataout))),
		n1llli = ((((((((((~ (SYNC_COMP_PAT[0] ^ nl11O)) & (~ (SYNC_COMP_PAT[1] ^ nl10i))) & (~ (SYNC_COMP_PAT[2] ^ nl10l))) & (~ (SYNC_COMP_PAT[3] ^ nl10O))) & (~ (SYNC_COMP_PAT[4] ^ nl1ii))) & (~ (SYNC_COMP_PAT[5] ^ nl1il))) & (~ (SYNC_COMP_PAT[6] ^ nl1iO))) & (~ (wire_niilO_dataout ^ wire_ni1Ol_dataout))) & (~ (wire_niiOi_dataout ^ wire_ni1OO_dataout))) & (~ (wire_niiOl_dataout ^ wire_ni01i_dataout))),
		n1llll = ((((((((((~ (nl11O ^ wire_ni0ii_dataout)) & (~ (wire_ni0il_dataout ^ nl10i))) & (~ (wire_ni0iO_dataout ^ nl10l))) & (~ (wire_ni0li_dataout ^ nl10O))) & (~ (wire_ni0ll_dataout ^ nl1ii))) & (~ (wire_ni0lO_dataout ^ nl1il))) & (~ (wire_ni0Oi_dataout ^ nl1iO))) & (~ (wire_ni0Ol_dataout ^ wire_ni1Ol_dataout))) & (~ (wire_ni0OO_dataout ^ wire_ni1OO_dataout))) & (~ (wire_nii1i_dataout ^ wire_ni01i_dataout))),
		n1lO0l = ((((((((((~ (SYNC_COMP_PAT[0] ^ nl10i)) & (~ (SYNC_COMP_PAT[1] ^ nl10l))) & (~ (SYNC_COMP_PAT[2] ^ nl10O))) & (~ (SYNC_COMP_PAT[3] ^ nl1ii))) & (~ (SYNC_COMP_PAT[4] ^ nl1il))) & (~ (SYNC_COMP_PAT[5] ^ nl1iO))) & (~ (SYNC_COMP_PAT[6] ^ nl1li))) & (~ (wire_niilO_dataout ^ wire_ni01O_dataout))) & (~ (wire_niiOi_dataout ^ wire_ni00i_dataout))) & (~ (wire_niiOl_dataout ^ wire_ni00l_dataout))),
		n1lO0O = ((((((((((~ (wire_ni0ii_dataout ^ nl10i)) & (~ (wire_ni0il_dataout ^ nl10l))) & (~ (wire_ni0iO_dataout ^ nl10O))) & (~ (wire_ni0li_dataout ^ nl1ii))) & (~ (wire_ni0ll_dataout ^ nl1il))) & (~ (wire_ni0lO_dataout ^ nl1iO))) & (~ (wire_ni0Oi_dataout ^ nl1li))) & (~ (wire_ni0Ol_dataout ^ wire_ni01O_dataout))) & (~ (wire_ni0OO_dataout ^ wire_ni00i_dataout))) & (~ (wire_nii1i_dataout ^ wire_ni00l_dataout))),
		n1lOii = ((~ SYNC_COMP_SIZE[0]) & (~ SYNC_COMP_SIZE[1])),
		n1lOil = (SYNC_COMP_SIZE[0] & (~ SYNC_COMP_SIZE[1])),
		n1lOiO = ((~ (((n1O1il & n1O1ii) & n1O10O) & (~ n1O10l))) & wire_n1O0OO_dataout),
		n1O0ii = (ni0O0l | ni0O0i),
		n1O10l = (((((~ n1l0ll) | (~ n1l0iO)) | (~ n1l0ii)) | (~ n1l00l)) | n1l01O),
		n1O10O = (((((~ n1l0li) | (~ n1l0iO)) | (~ n1l00O)) | (~ n1l00l)) | (~ n1l01l)),
		n1O11l = (n01Oli & (~ n1O1li)),
		n1O1ii = (((((~ n1l0li) | (~ n1l0iO)) | (~ n1l0il)) | (~ n1l0ii)) | (~ n1l01l)),
		n1O1il = ((wire_n010O_dataout | (~ n1l0ll)) | (~ n1l01l)),
		n1O1iO = (n01Oli & n1O1li),
		n1O1li = ((((n1O1il & n1O1ii) & n1O10O) & (~ n1O10l)) & n1O11O8),
		n1O1ll = 1'b1,
		n1O1lO = ((((n01O0i | n01llO) | n01O1O) | n01lOi) | n01O0l),
		n1O1Oi = ((((n01O1l | n01lOO) | n01lOl) | n01O1i) | n01lOi),
		n1O1Ol = (((((n01O0i | n01lOO) | n01liO) | n01O1O) | n01lOl) | n1O0li),
		n1O1OO = (((((n01O0i | n01O1l) | n01lOO) | n01llO) | n01lll) | n01liO),
		RLV = n1O0ii,
		RLV_lt = ((((ni0lOi | ni0llO) | (~ n1O01O2)) | (ni0lll & DWIDTH)) | (~ n1O01i5)),
		signal_detect_sync = n01Oii,
		SUDI = {nllO0l, nllO0i, nllO1O, nllO1l, nllO1i, nlllOO, nlllOl, nlllOi, nllllO, nlllll, nlllli, nllliO, nlllil},
		SUDI_pre = {nlOOiO, nlO01l, nlO01i, nlO1OO, nlO1Ol, nlO1Oi, nlO1lO, nlO1ll, nlO1li, nlO1iO},
		sync_curr_st = {n1O1lO, n1O1Oi, (~ n1O1Ol), n1O1OO},
		sync_status = n1O0Oi;
endmodule //altgxb_hssi_rx_wal_rtl
//synopsys translate_on
//VALID FILE
//
// ALTGXB_HSSI_WORD_ALIGNER
//

`timescale 1 ps/1 ps

module altgxb_hssi_word_aligner 
    (
        datain, 
        clk, 
        softreset, 
        enacdet, 
        bitslip, 
        a1a2size, 
        aligneddata, 
        aligneddatapre, 
        invalidcode, 
        invalidcodepre, 
        syncstatus, 
        syncstatusdeskew, 
        disperr, 
        disperrpre, 
        patterndetectpre,
        patterndetect
    );

input [9:0] datain;
input clk;
input softreset;
input enacdet;
input bitslip;
input a1a2size;

output [9:0] aligneddata;
output [9:0] aligneddatapre;
output invalidcode;
output invalidcodepre;
output syncstatus;
output syncstatusdeskew;
output disperr;
output disperrpre;
output patterndetect;
output patterndetectpre;

parameter channel_width = 10;
parameter align_pattern_length = 10;
parameter infiniband_invalid_code = 0;
parameter align_pattern = "0000000101111100";
parameter synchronization_mode = "XAUI";
parameter use_8b_10b_mode = "ON";
parameter use_auto_bit_slip = "ON"; 


// input interface

wire         rcvd_clk;
wire         soft_reset;
wire         LP10BEN;
wire         RLV_EN;
wire  [4:0]  RUNDISP_SEL;
wire         PMADATAWIDTH;
wire  [15:0] SYNC_COMP_PAT; 
wire  [1:0]  SYNC_COMP_SIZE;
wire  [1:0]  IB_INVALID_CODE;
wire         AUTOBYTEALIGN_DIS;
wire         SYNC_SM_DIS;
wire         GE_XAUI_SEL;
wire         encdet_prbs;
wire         BITSLIP;
wire         ENCDT;
wire         prbs_en;
wire         DISABLE_RX_DISP;
wire         signal_detect;       // signaldetect from PMA
wire  [9:0]  PUDI;                // from rx serdes
wire  [9:0]  PUDR;                // Loopback data from TX 

wire         A1A2_SIZE;           // PLD signal to select between 
                                  // A1A2 and A1A1A2A2 pattern detection
wire         DWIDTH;

// output interface

wire         cg_comma;            // is patterndetect when J = 10
wire         sync_status;         // from Sync SM to deskew state machine
wire         signal_detect_sync;  // Synchronized signal_detect
wire [12:0]  SUDI;               
wire [9:0]   SUDI_pre;            // to deskew fifo
wire         RLV;
wire         RLV_lt; 
wire [3:0]   sync_curr_st;        // Current state of Sync SM

// function to convert align_pattern to binary
function [15 : 0] pattern_conversion;
    input  [127 : 0] s;
    reg [127 : 0] reg_s;
    reg [15 : 0] digit;
    reg [7 : 0] tmp;
    integer   m;
    begin
      
        reg_s = s;
        for (m = 15; m >= 0; m = m-1 )
        begin
            tmp = reg_s[127 : 120];
            digit[m] = tmp & 8'b00000001;
            reg_s = reg_s << 8;
        end
          
        pattern_conversion = {digit[15], digit[14], digit[13], digit[12], digit[11], digit[10], digit[9], digit[8], digit[7], digit[6], digit[5], digit[4], digit[3], digit[2], digit[1], digit[0]};
    end   
endfunction


// assing input interface

assign RLV_EN      = 1'b0;          // in RX_SERDES
assign RUNDISP_SEL = 4'b1000;       // in RX_SERDES
assign DWIDTH      = 1'b0;          // in RX_SERDES - Only used in run length check
assign LP10BEN     = 1'b0;           // Mux is taken cared in top level
assign DISABLE_RX_DISP = 1'b0;      

assign PMADATAWIDTH   = (align_pattern_length == 16 || align_pattern_length == 8) ? 1'b1 : 1'b0; 
assign SYNC_COMP_PAT  = pattern_conversion(align_pattern);                                       
assign SYNC_COMP_SIZE = (align_pattern_length == 7)  ? 2'b00 : 
                        (align_pattern_length == 16 || align_pattern_length == 8) ? 2'b01 : 2'b10;  
                                  

assign SYNC_SM_DIS = (synchronization_mode == "NONE" || synchronization_mode == "NONE") ? 1'b1 : 1'b0;
assign GE_XAUI_SEL = (synchronization_mode == "GIGE" || synchronization_mode == "GIGE") ? 1'b1 : 1'b0;  

assign AUTOBYTEALIGN_DIS = (use_auto_bit_slip == "ON" || use_auto_bit_slip == "ON") ? 1'b0 : 1'b1;
       
assign IB_INVALID_CODE = (infiniband_invalid_code == 0) ? 2'b00 :
                         (infiniband_invalid_code == 1) ? 2'b01 : 
                         (infiniband_invalid_code == 2) ? 2'b10 :  2'b11;

assign prbs_en = 1'b0;  
assign encdet_prbs = 1'b0;
assign signal_detect = 1'b1;

assign rcvd_clk   = clk;           
assign soft_reset = softreset;
assign BITSLIP    = bitslip;
assign ENCDT      = enacdet;

// filtering X values that impact state machines (cg_common, cg_invalid, kchar)
assign PUDI[0]    = (datain[0] === 1'b1 || datain[0] === 1'b0) ? datain[0] : 1'b0;
assign PUDI[1]    = (datain[1] === 1'b1 || datain[1] === 1'b0) ? datain[1] : 1'b0;
assign PUDI[2]    = (datain[2] === 1'b1 || datain[2] === 1'b0) ? datain[2] : 1'b0;
assign PUDI[3]    = (datain[3] === 1'b1 || datain[3] === 1'b0) ? datain[3] : 1'b0;
assign PUDI[4]    = (datain[4] === 1'b1 || datain[4] === 1'b0) ? datain[4] : 1'b0;
assign PUDI[5]    = (datain[5] === 1'b1 || datain[5] === 1'b0) ? datain[5] : 1'b0;
assign PUDI[6]    = (datain[6] === 1'b1 || datain[6] === 1'b0) ? datain[6] : 1'b0;
assign PUDI[7]    = (datain[7] === 1'b1 || datain[7] === 1'b0) ? datain[7] : 1'b0;
assign PUDI[8]    = (datain[8] === 1'b1 || datain[8] === 1'b0) ? datain[8] : 1'b0;
assign PUDI[9]    = (datain[9] === 1'b1 || datain[9] === 1'b0) ? datain[9] : 1'b0;

assign A1A2_SIZE  = a1a2size;
assign PUDR       = 10'bxxxxxxxxxx;  // Taken cared in top-level          


// assing output interface

assign aligneddata    = SUDI[9:0];
assign invalidcode    = SUDI[10];
assign syncstatus     = SUDI[11];
assign disperr        = SUDI[12];

// from GIGE/XAUI sync state machine - to XGM dskw SM and Rate Matching
assign syncstatusdeskew = sync_status;

assign patterndetect = cg_comma;    // only for J=10

assign aligneddatapre = SUDI_pre;
assign invalidcodepre = 1'b0;       // unused
assign disperrpre     = 1'b0;       // unused
assign patterndetectpre = 1'b0;     // unused


// instantiating RTL

altgxb_hssi_rx_wal_rtl m_wal_rtl (
                 .rcvd_clk (rcvd_clk),
                 .soft_reset (soft_reset),
                 .LP10BEN (LP10BEN),
                 .RLV_EN (RLV_EN),
                 .RUNDISP_SEL (RUNDISP_SEL),
                 .PMADATAWIDTH (PMADATAWIDTH),
                 .SYNC_COMP_PAT (SYNC_COMP_PAT),
                 .SYNC_COMP_SIZE (SYNC_COMP_SIZE),
                 .IB_INVALID_CODE (IB_INVALID_CODE),
                 .AUTOBYTEALIGN_DIS (AUTOBYTEALIGN_DIS),
                 .BITSLIP (BITSLIP),
                 .DISABLE_RX_DISP (DISABLE_RX_DISP),
                 .ENCDT (ENCDT),
                 .SYNC_SM_DIS (SYNC_SM_DIS),
                 .prbs_en (prbs_en),
                 .encdet_prbs (encdet_prbs),
                 .GE_XAUI_SEL (GE_XAUI_SEL),
                 .signal_detect (signal_detect),
                 .PUDI (PUDI),
                 .PUDR (PUDR),
                 .cg_comma (cg_comma),
                 .sync_status (sync_status),
                 .signal_detect_sync (signal_detect_sync),
                 .SUDI (SUDI),
                 .SUDI_pre (SUDI_pre),
                 .RLV (RLV),
                 .RLV_lt (RLV_lt),
                 .sync_curr_st (sync_curr_st),
                 .A1A2_SIZE(A1A2_SIZE),
                 .DWIDTH(DWIDTH)
);

endmodule
///////////////////////////////////////////////////////////////////////////////
//
//                            ALTGXB_COMP_FIFO_CORE
//
///////////////////////////////////////////////////////////////////////////////

module altgxb_comp_fifo_core
   (
    reset, 
    writeclk, 
    readclk, 
    underflow, 
    overflow,
    errdetectin,
    disperrin,   
    patterndetectin,
    disablefifowrin, 
    disablefifordin, 
    re, 
    we,
    datain,
    datainpre,
    syncstatusin, 
    disperr,
    alignstatus,
    fifordin, 
    fifordout,
    decsync, 
    fifocntlt5, 
    fifocntgt9, 
    done,
    fifoalmostful, 
    fifofull, 
    fifoalmostempty, 
    fifoempty,
    alignsyncstatus, 
    smenable, 
    disablefifordout,
    disablefifowrout, 
    dataout, 
    codevalid,
    errdetectout,
    patterndetect,    
    syncstatus
    );

   parameter     use_rate_match_fifo = "ON";
   parameter     rate_matching_fifo_mode = "XAUI";
   parameter     use_channel_align = "ON";
   parameter     channel_num = 0;
   parameter     for_engineering_sample_device = "ON";  // new in 3.0 sp2

   input    reset;
   input    writeclk;
   input    readclk;
   input    underflow;
   input    overflow;
   input    errdetectin;    
   input    disperrin;      
   input    patterndetectin;
   input    disablefifordin;
   input    disablefifowrin;
   wire     ge_xaui_sel;
   input    re;
   input    we;
   input [9:0]  datain;
   input [9:0]  datainpre;
   input    syncstatusin;
   input    alignstatus;
   input    fifordin;
   output   fifordout;
   output   fifoalmostful;
   output   fifofull;
   output   fifoalmostempty;
   output   fifoempty;
   output   decsync;
   output   fifocntlt5;
   output   fifocntgt9;
   output   done;
   output   alignsyncstatus;
   output   smenable;
   output   disablefifordout;
   output   disablefifowrout;
   output [9:0] dataout;
   output    codevalid;
   output    errdetectout;
   output    syncstatus;
   output    patterndetect;
   output    disperr;

   reg       decsync;
   reg       decsync_1;
   wire      alignsyncstatus;
   wire          alignstatus_dly;
   wire          re_dly;
   wire [9:0]    dataout;
   wire      fifocntlt5;
   wire      fifo_cnt_lt_8;
   wire      fifo_cnt_lt_9;
   wire      fifo_cnt_lt_7;
   wire      fifo_cnt_lt_12;
   wire      fifo_cnt_lt_4;
   wire      fifo_cnt_gt_10;
   wire      fifocntgt9;
   wire      fifo_cnt_gt_8;
   wire      fifo_cnt_gt_13;
   wire      fifo_cnt_gt_5;
   wire      fifo_cnt_gt_6;
   wire      done;
   wire      smenable;
   wire      codevalid;
   
   reg       fifoalmostful;
   reg       fifofull;
   reg       fifoalmostempty;
   reg       fifoempty;
   reg       almostfull_1;
   reg       almostfull_sync;
   reg       almostempty_1;
   reg       almostempty_sync;
   reg       full_1;
   reg       full_sync;
   reg       empty_1;
   reg       empty_sync;
   reg       rdenable_sync_1;
   reg       rdenable_sync;
   reg       write_enable_sync;
   reg       write_enable_sync_1;
   reg       fifo_dec_dly;
   reg [3:0]     count;
   reg [1:0]     count_read;
   wire      comp_write_d;
   reg       comp_write_pre;
   wire      comp_write;
   wire      write_detect_d;
   reg       write_detect_pre;
   wire      write_detect;
   wire      comp_read_d;
   reg       comp_read;
   wire      detect_read_d;
   reg       detect_read;
   reg       comp_read_ext;
   wire      disablefifowrout;
   wire      disablefifordout;
   wire      fifordout;
   reg       read_eco;
   wire          read_eco_dly;
   wire      reset_fifo_dec;
   
   reg       read_sync_int_1;
   reg       read_sync_int;
   wire      read_sync;
   reg       fifo_dec;
   reg       done_write;
   reg       done_read;
   reg       underflow_sync_1;
   reg       underflow_sync;
   reg       done_read_sync_1;
   reg       done_read_sync;
   wire      alignsyncstatus_sync;
   reg       alignstatus_sync_1;
   reg       alignstatus_sync;
   reg       syncstatus_sync_1;
   reg       syncstatus_sync;
   
   integer   write_ptr, read_ptr1, read_ptr2;
   integer   i, j, k;
   reg [14*12-1:0] fifo;
   
   wire [10:0]     fifo_data_in;
   wire [11:0]     comp_pat1;
   wire [11:0]     comp_pat2;
   wire [12:0]     fifo_data_in_pre;
   reg [13:0]      fifo_data_out1_sync;
   reg [13:0]      fifo_data_out1_sync_dly;
   reg         fifo_data_out1_sync_valid;
   reg [13:0]      fifo_data_out2_sync;
   reg [13:0]      fifo_data_out1_tmp;
   reg [12:0]      fifo_data_out2_tmp;

   wire [13:0]     fifo_data_out1;
   wire [13:0]     fifo_data_out2;
   reg         genericfifo_sync_clk2_1, genericfifo_sync_clk2, genericfifo_sync_clk1_1, genericfifo_sync_clk1; 

   wire        onechannel;
   wire        deskewenable;
   wire        matchenable;
   wire        menable;
   wire        genericfifo;
   wire        globalenable;
   reg             writeclk_dly;
      
   assign onechannel   = (channel_num == 0) ? 1'b1 : 1'b0;
   assign deskewenable = (use_channel_align == "ON") ? 1'b1 : 1'b0;
   assign matchenable  = (use_rate_match_fifo == "ON") ? 1'b1 : 1'b0;
   assign menable      = matchenable && ~deskewenable;
   assign genericfifo  = (rate_matching_fifo_mode == "NONE") ? 1'b1 : 1'b0;
   assign globalenable = matchenable && deskewenable;
   assign ge_xaui_sel = (rate_matching_fifo_mode == "GIGE") ? 1'b1 : 1'b0;
   
   always @ (writeclk)
     begin
   writeclk_dly <= writeclk;
     end
   
   // COMPOSTION WRITE LOGIC
   always @ (posedge reset or posedge writeclk_dly)
      begin
     if (reset)
        comp_write_pre <= 1'b0;
     else if (alignsyncstatus && (write_detect || ~ge_xaui_sel))
        comp_write_pre <= comp_write_d;
          else
         comp_write_pre <= 1'b0;
      end
   
   // WRITE DETECT LOGIC
   always @ (posedge reset or posedge writeclk_dly)
      begin
     if (reset)
        write_detect_pre <= 1'b0;
     else if (alignsyncstatus && ge_xaui_sel)
        write_detect_pre <= write_detect_d;
          else
         write_detect_pre <= 1'b0;
      end
   
   // CLOCK COMP READ   
   always @ (posedge reset or posedge readclk)
      begin
     if (reset)
        begin
           comp_read <= 1'b0;
           comp_read_ext <= 1'b0;
        end
     else 
        begin
           comp_read_ext <= underflow_sync && comp_read && ge_xaui_sel;
           if (alignsyncstatus_sync && (detect_read || ~ge_xaui_sel))
          comp_read <= comp_read_d & ~fifo_data_out2_sync[10] & ~fifo_data_out2_sync[12];
           else
          comp_read <= 1'b0;
        end
      end
   
   // READ DETECT LOGIC 
   always @ (posedge reset or posedge readclk)
      begin
     if (reset)
        detect_read <= 1'b0;
     else if (alignsyncstatus_sync && ge_xaui_sel)
        detect_read <= detect_read_d & ~fifo_data_out2_sync[10] & ~fifo_data_out2_sync[12];
          else
         detect_read <= 1'b0;
      end
   
   assign fifo_cnt_lt_4 = (count < 4);
   assign fifocntlt5 = (count < 5);
   assign fifo_cnt_lt_7 = (count < 7);
   assign fifo_cnt_lt_8 = (count < 8);  // added in REV-C
   assign fifo_cnt_lt_9 = (count < 9);
   assign fifo_cnt_lt_12 = (count < 12);
   assign fifo_cnt_gt_5 = (count > 5);
   assign fifo_cnt_gt_6 = (count > 6);  // added in REV-C
   assign fifo_cnt_gt_8 = (count > 8);
   assign fifocntgt9 = (count > 9);
   assign fifo_cnt_gt_10 = (count > 10);
   assign fifo_cnt_gt_13 = (count > 13);

   assign disablefifowrout = (globalenable && !onechannel) ? disablefifowrin : overflow & comp_write & ~done_write;

   // FIFO COUNT LOGIC   
   always @(posedge reset or posedge writeclk_dly)
      begin
     if (reset)
        count <= 4'b0000;
     else if (genericfifo_sync_clk1)
        begin
           if (write_enable_sync && ~decsync)
          count <= count + 1;
           else if (write_enable_sync && decsync)
          count <= count -2;
            else if (~write_enable_sync && decsync)
               count <= count - 3;
             else
                count <= count;
        end
          else 
         begin
            if (!alignsyncstatus)
               count <= 4'b0000;
            else if (~decsync && ~disablefifowrout)
               count <= count + 1;
             else if (decsync && ~disablefifowrout)
                count <= count -2;
                  else if (~ge_xaui_sel && decsync && disablefifowrout)
                 count <= count - 3;
                   else if (ge_xaui_sel && decsync && disablefifowrout)
                      count <= count - 4;
                    else if (ge_xaui_sel && ~decsync && disablefifowrout)
                       count <= count - 1;
                         else
                        count <= count;
         end
      end
   
   // COMPENSATION DONE LOGIC   
   always @(posedge reset or posedge writeclk_dly)
      begin
     if (reset)
        done_write <= 1'b0;
     else
        done_write <= overflow && comp_write; 
      end
   
   // FIFO ALMOST FULL   
   always @(posedge reset or posedge writeclk_dly)
      begin
     if (reset)
        almostfull_1 <= 1'b0;
     else if (almostfull_1)
        almostfull_1 <= ~fifo_cnt_lt_8;
          else 
         almostfull_1 <= fifocntgt9;
      end
   
   // FIFO ALMOST EMPTY LOGIC
   always @(posedge reset or posedge writeclk_dly)
      begin
     if (reset)
        almostempty_1 <= 1'b1;
     else if (almostempty_1)
        almostempty_1 <= ~fifo_cnt_gt_6;
          else
         almostempty_1 <= fifocntlt5;
      end
   
   // FIFO FULL LOGIC
   always @(posedge reset or posedge writeclk_dly)
      begin
     if (reset)
        full_1 <= 1'b0;
     else if (full_1)
        full_1 <= ~fifo_cnt_lt_12;
          else
         full_1 <= fifo_cnt_gt_13;
      end
   
   // FIFO EMPTY LOGIC
   always @(posedge reset or posedge writeclk_dly)
      begin
     if (reset)
        empty_1 <= 1'b1;
     else if (empty_1)
        empty_1 <= ~fifo_cnt_gt_5;
          else
         empty_1 <= fifo_cnt_lt_4;
      end
   
   assign read_sync = (globalenable && !onechannel)? fifordin : fifordout;
   assign fifordout = read_sync_int;

   always @ (posedge reset or posedge writeclk_dly)
      begin
     if (reset)
        read_eco <= 1'b0;
     else if (read_eco && (count <= 4'd2))
        read_eco <= 1'b0;
          else if (!read_eco && (count == 4'd2))
         read_eco <= 1'b1;
      end
   
   assign #1 alignstatus_dly = alignstatus;
   assign #1 read_eco_dly = read_eco;
   assign #1 re_dly = re;

   always @(posedge reset or posedge readclk)
      begin
     if (reset)
        begin
           read_sync_int_1 <= 1'b0;
           read_sync_int <= 1'b0;
           underflow_sync_1 <= 1'b0;
           underflow_sync <= 1'b0;
           alignstatus_sync_1 <= 1'b0;
           alignstatus_sync <= 1'b0;
           syncstatus_sync_1 <= 1'b0;
           syncstatus_sync <= 1'b0;
           rdenable_sync_1 <= 1'b0;
           rdenable_sync <= 1'b0;
           fifo_data_out1_sync_valid <= 1'b0;
           fifo_dec_dly <= 1'b0;
           almostfull_sync <= 1'b0;
           almostempty_sync <= 1'b1;
           full_sync <= 1'b0;
           empty_sync <= 1'b1;
           fifoalmostful <= 1'b0;
           fifoalmostempty <= 1'b1;
           fifofull <= 1'b0;
           fifoempty <= 1'b1;
           genericfifo_sync_clk2_1 <= 1'b0;
           genericfifo_sync_clk2   <= 1'b0;
        end
     else
        begin
          read_sync_int_1 <= read_eco_dly & ~genericfifo_sync_clk2;
           read_sync_int <= read_sync_int_1;
           underflow_sync_1 <= underflow;
           underflow_sync <= underflow_sync_1;
          alignstatus_sync_1 <= alignstatus_dly;
           alignstatus_sync <= alignstatus_sync_1;
           syncstatus_sync_1 <= syncstatusin;
           syncstatus_sync <= syncstatus_sync_1;
           rdenable_sync_1 <= (re_dly & genericfifo);
           rdenable_sync <= rdenable_sync_1;
           fifo_data_out1_sync_valid <= (~genericfifo_sync_clk2 & alignsyncstatus_sync & read_sync) |
                        (genericfifo_sync_clk2 & rdenable_sync);
           fifo_dec_dly <= fifo_dec;
           almostfull_sync <= almostfull_1;
           almostempty_sync <= almostempty_1;
           full_sync <= full_1;
           empty_sync <= empty_1;
           fifoalmostful <= almostfull_sync;
           fifoalmostempty <= almostempty_sync;
           fifofull <= full_sync;
           fifoempty <= empty_sync;
           genericfifo_sync_clk2_1 <= genericfifo;
           genericfifo_sync_clk2   <= genericfifo_sync_clk2_1;
        end
      end
   
   // DISABLE READ LOGIC
   assign disablefifordout = (globalenable && !onechannel) ? disablefifordin
                : (underflow_sync & (comp_read | comp_read_ext) & ~done_read);
   
   // 2 BIT COUNTER LOGIC   
   always @(posedge reset or posedge readclk)
      begin
     if (reset)
        count_read <= 2'b00;
     else if (!alignsyncstatus_sync && !genericfifo_sync_clk2)
        count_read <= 2'b00;
          else if ((read_sync && ~disablefifordout) || rdenable_sync)
         if (count_read == 2'b10)
            count_read <= 2'b00;
         else
            count_read <= count_read + 1;
           else
              count_read <= count_read;
      end
   
   // COMPENSATION DONE (READ)   
   always @(posedge reset or posedge readclk)
      begin
     if (reset)
        done_read <= 1'b0;
     else if (underflow_sync && ((comp_read && ~ge_xaui_sel) || (comp_read_ext && ge_xaui_sel))) 
        done_read <= 1'b1;
          else if (~underflow_sync)
         done_read <= 1'b0;
           else
              done_read <= done_read;
      end
   
   //DECREMENT FIFO LOGIC
   assign reset_fifo_dec = (reset | ~(~fifo_dec_dly | readclk));
   always @(posedge reset_fifo_dec or posedge readclk)
      begin
     if (reset_fifo_dec) 
        fifo_dec <= 1'b0;
     else if (count_read == 2'b01 && ( (~disablefifordout && ~genericfifo_sync_clk2) || 
                        (rdenable_sync && genericfifo_sync_clk2) ))
        fifo_dec <= 1'b1;
          else
         fifo_dec <= fifo_dec;
      end
   
   // WRITE CLOCK DELAY LOGIC
   always @(posedge reset or posedge writeclk_dly)
      begin
     if (reset)
        begin
           decsync_1 <= 1'b0;
           decsync <= 1'b0;
           done_read_sync_1 <= 1'b0;
           done_read_sync <= 1'b0;
           write_enable_sync_1 <= 1'b0;
           write_enable_sync <= 1'b0;
           genericfifo_sync_clk1_1 <= 1'b0;
           genericfifo_sync_clk1   <= 1'b0;
        end
     else
        begin
           decsync_1 <= fifo_dec;
           decsync <= decsync_1 && ~decsync;
           done_read_sync_1 <= done_read;
           done_read_sync <= done_read_sync_1;
           write_enable_sync_1 <= (we & genericfifo);
           write_enable_sync <= write_enable_sync_1;
           genericfifo_sync_clk1_1 <= genericfifo;
           genericfifo_sync_clk1   <= genericfifo_sync_clk1_1;
        end
      end

   // FIFO WRITE POINTER LOGIC 
   always @(posedge reset or writeclk_dly)
      begin
     if (reset)
        write_ptr <= 0; 
    if(writeclk_dly)
      begin
         if (!alignsyncstatus && !genericfifo_sync_clk1)
        write_ptr <= 0; 
          else if ( ((write_enable_sync && genericfifo_sync_clk1) || (!disablefifowrout && !genericfifo_sync_clk1)) )
         begin
            if(write_ptr != 11)
               write_ptr <= write_ptr + 1;
            else
               write_ptr <= 0;
         end
           else if (disablefifowrout && ge_xaui_sel && !genericfifo_sync_clk1)
              begin
             if(write_ptr != 0)
                write_ptr <= write_ptr - 1; 
             else
                write_ptr <= 11;
              end 
      end
   end
   
   // FIFO READ POINTER LOGIC
   always @(posedge reset or posedge readclk)
      begin
     if (reset)
        begin
           read_ptr1 <= 0;
           read_ptr2 <= 1;
        end
     else if (!alignsyncstatus_sync && !genericfifo_sync_clk2)
        begin
           read_ptr1 <= 0;
           read_ptr2 <= 1;
        end
          else if ((read_sync && !disablefifordout && !genericfifo_sync_clk2) ||
               (rdenable_sync && genericfifo_sync_clk2))
         begin
            if(read_ptr1 != 11)
               read_ptr1 <= read_ptr1 + 1;
            else
               read_ptr1 <= 0;
            if(read_ptr2 != 11)
               read_ptr2 <= read_ptr2 + 1;
            else
               read_ptr2 <= 0;
         end
      end 
   
   // MAIN FIFO BLOCK
   always @(fifo_data_in or write_ptr or reset or errdetectin or syncstatusin or disperrin or patterndetectin)
      begin
          #1;
          if (reset)
              begin
                  for (i = 0; i < 168; i = i + 1)  // 14*12 = 168
                      fifo[i] = 1'b0;
              end
          else 
              begin
                  for (i = 0; i < 10; i = i + 1)
                      fifo[write_ptr*14+i] = fifo_data_in[i];
                  fifo[write_ptr*14+10] = errdetectin;
                  fifo[write_ptr*14+11] = syncstatusin;
                  fifo[write_ptr*14+12] = disperrin;
                  fifo[write_ptr*14+13] = patterndetectin;
              end
      end 
   
   always @ (posedge writeclk_dly or reset or read_ptr1 or read_ptr2)
      begin
     for (j = 0; j < 14; j = j + 1)
        fifo_data_out1_tmp[j] = fifo[read_ptr1*14+j];
     for (k = 0; k < 13; k = k + 1)
        fifo_data_out2_tmp[k] = fifo[read_ptr2*14+k];
      end 

   assign fifo_data_out1 = fifo_data_out1_tmp;
   assign fifo_data_out2 = fifo_data_out2_tmp;

   // DATAOUT DELAY LOGIC
   always @ (posedge reset or posedge readclk)
      begin
     if (reset)
        begin
           fifo_data_out1_sync <= 'b0;
           fifo_data_out1_sync_dly <= 'b0;
           fifo_data_out2_sync <= 'b0;
        end
     else  
        begin
           if (ge_xaui_sel)
          fifo_data_out1_sync_dly <=  fifo_data_out1_sync;
           else
          fifo_data_out1_sync_dly <= 'b0;
           if (!disablefifordout)
          begin
             fifo_data_out1_sync <= fifo_data_out1;
             fifo_data_out2_sync <= fifo_data_out2;
          end
           else if (ge_xaui_sel)
          fifo_data_out1_sync <= fifo_data_out1_sync_dly;
        end
      end
   
   assign done = done_write || done_read_sync;
   assign smenable = ((menable || (globalenable && onechannel)) && ~genericfifo_sync_clk1) ? 1'b1 : 1'b0;
   assign comp_pat1 = (ge_xaui_sel) ? 10'b1010110110 : 10'b0010111100;
   assign comp_pat2 = (ge_xaui_sel) ? ((for_engineering_sample_device == "ON") ? 10'b1010001010 : 10'b1010001001)  : 10'b1101000011;
   assign comp_write_d = (fifo_data_in_pre[9:0] == comp_pat1) || (fifo_data_in_pre[9:0] == comp_pat2) ? 1'b1 : 1'b0;
   assign comp_read_d = (fifo_data_out2_sync[9:0] == comp_pat1) || (fifo_data_out2_sync[9:0] == comp_pat2) ? 1'b1 : 1'b0;
   assign write_detect_d = (fifo_data_in_pre[9:0] == 10'b0101111100) || (fifo_data_in_pre[9:0] == 10'b1010000011) ? 1'b1 : 1'b0;
   assign detect_read_d = (fifo_data_out2_sync[9:0] == 10'b0101111100) || (fifo_data_out2_sync[9:0] == 10'b1010000011) ? 1'b1 : 1'b0;
   assign dataout = (matchenable || genericfifo_sync_clk2) ? fifo_data_out1_sync[9:0] : datain;
   assign errdetectout = (matchenable || genericfifo_sync_clk2) ? fifo_data_out1_sync[10] : errdetectin; 
   assign syncstatus = (matchenable || genericfifo_sync_clk2) ? fifo_data_out1_sync[11] : syncstatusin; 
   assign disperr = (matchenable || genericfifo_sync_clk2) ? fifo_data_out1_sync[12] : disperrin;
   assign patterndetect = (matchenable || genericfifo_sync_clk2) ? fifo_data_out1_sync[13]: patterndetectin;
   assign codevalid = (matchenable || genericfifo_sync_clk2) ? fifo_data_out1_sync_valid : (deskewenable) ? alignstatus_dly : syncstatusin;
   assign alignsyncstatus = (~matchenable || genericfifo_sync_clk1) ? 1'b0 : (deskewenable) ? alignstatus_dly : syncstatusin;
   assign alignsyncstatus_sync = (~matchenable || genericfifo_sync_clk2) ? 1'b0 : (deskewenable) ? alignstatus_sync : syncstatus_sync;
   assign fifo_data_in = datain; 
   assign fifo_data_in_pre = datainpre;
   assign comp_write = comp_write_pre & ~errdetectin & ~disperrin; 
   assign write_detect = write_detect_pre & ~errdetectin & ~disperrin; 
   
endmodule

//IP Functional Simulation Model
//VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


// Legal Notice:  2003 Altera Corporation. All rights reserved.
// You may only use these  simulation  model  output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event  Altera disclaims all warranties of any kind). Your use of  Altera
// Corporation's design tools, logic functions and other software and tools,
// and its AMPP partner logic functions, and any output files any of the
// foregoing (including device programming or simulation files), and any
// associated documentation or information  are expressly subject to the
// terms and conditions of the  Altera Program License Subscription Agreement
// or other applicable license agreement, including, without limitation, that
// your use is for the sole purpose of programming logic devices manufactured
// by Altera and sold by Altera or its authorized distributors.  Please refer
// to the applicable agreement for further details.


//synopsys translate_off

//synthesis_resources = lut 39 mux21 14 oper_selector 6 
`timescale 1 ps / 1 ps
module  altgxb_comp_fifo_sm
	( 
	alignsyncstatus,
	decsync,
	done,
	fifocntgt9,
	fifocntlt5,
	overflow,
	reset,
	smenable,
	underflow,
	writeclk) /* synthesis synthesis_clearbox=1 */;
	input   alignsyncstatus;
	input   decsync;
	input   done;
	input   fifocntgt9;
	input   fifocntlt5;
	output   overflow;
	input   reset;
	input   smenable;
	output   underflow;
	input   writeclk;

	reg	n00i19;
	reg	n00i20;
	reg	n00i21;
	reg	n00l16;
	reg	n00l17;
	reg	n00l18;
	reg	n00O13;
	reg	n00O14;
	reg	n00O15;
	reg	n01i25;
	reg	n01i26;
	reg	n01i27;
	reg	n01l22;
	reg	n01l23;
	reg	n01l24;
	reg	n0ii10;
	reg	n0ii11;
	reg	n0ii12;
	reg	n0iO7;
	reg	n0iO8;
	reg	n0iO9;
	reg	n0li4;
	reg	n0li5;
	reg	n0li6;
	reg	n0Ol1;
	reg	n0Ol2;
	reg	n0Ol3;
	reg	n1Ol31;
	reg	n1Ol32;
	reg	n1Ol33;
	reg	n1OO28;
	reg	n1OO29;
	reg	n1OO30;
	reg	niOO;
	reg	ni;
	reg	nl1i;
	reg	nll;
	reg	nlO;
	reg	nO;
	wire	wire_n0i_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1O_dataout;
	wire	wire_nil_dataout;
	wire	wire_niO_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOO_dataout;
	wire  wire_nl0l_o;
	wire  wire_nl0O_o;
	wire  wire_nl1l_o;
	wire  wire_nl1O_o;
	wire  wire_nlii_o;
	wire  wire_nliO_o;
	wire  n0ll;
	wire  n0lO;
	wire  n0Oi;
	wire  ni1l;

	initial
		n00i19 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n00i19 <= n00i21;
	initial
		n00i20 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n00i20 <= (n00i21 ^ n00i19);
	initial
		n00i21 = 0;
	always @ ( posedge writeclk)
		  n00i21 <= n00i19;
	initial
		n00l16 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n00l16 <= n00l18;
	initial
		n00l17 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n00l17 <= (n00l18 ^ n00l16);
	initial
		n00l18 = 0;
	always @ ( posedge writeclk)
		  n00l18 <= n00l16;
	initial
		n00O13 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n00O13 <= n00O15;
	initial
		n00O14 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n00O14 <= (n00O15 ^ n00O13);
	initial
		n00O15 = 0;
	always @ ( posedge writeclk)
		  n00O15 <= n00O13;
	initial
		n01i25 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n01i25 <= n01i27;
	initial
		n01i26 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n01i26 <= (n01i27 ^ n01i25);
	initial
		n01i27 = 0;
	always @ ( posedge writeclk)
		  n01i27 <= n01i25;
	initial
		n01l22 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n01l22 <= n01l24;
	initial
		n01l23 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n01l23 <= (n01l24 ^ n01l22);
	initial
		n01l24 = 0;
	always @ ( posedge writeclk)
		  n01l24 <= n01l22;
	initial
		n0ii10 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n0ii10 <= n0ii12;
	initial
		n0ii11 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n0ii11 <= (n0ii12 ^ n0ii10);
	initial
		n0ii12 = 0;
	always @ ( posedge writeclk)
		  n0ii12 <= n0ii10;
	initial
		n0iO7 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n0iO7 <= n0iO9;
	initial
		n0iO8 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n0iO8 <= (n0iO9 ^ n0iO7);
	initial
		n0iO9 = 0;
	always @ ( posedge writeclk)
		  n0iO9 <= n0iO7;
	initial
		n0li4 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n0li4 <= n0li6;
	initial
		n0li5 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n0li5 <= (n0li6 ^ n0li4);
	initial
		n0li6 = 0;
	always @ ( posedge writeclk)
		  n0li6 <= n0li4;
	initial
		n0Ol1 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n0Ol1 <= n0Ol3;
	initial
		n0Ol2 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n0Ol2 <= (n0Ol3 ^ n0Ol1);
	initial
		n0Ol3 = 0;
	always @ ( posedge writeclk)
		  n0Ol3 <= n0Ol1;
	initial
		n1Ol31 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n1Ol31 <= n1Ol33;
	initial
		n1Ol32 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n1Ol32 <= (n1Ol33 ^ n1Ol31);
	initial
		n1Ol33 = 0;
	always @ ( posedge writeclk)
		  n1Ol33 <= n1Ol31;
	initial
		n1OO28 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n1OO28 <= n1OO30;
	initial
		n1OO29 = {1{1'b1}};
	always @ ( posedge writeclk)
		  n1OO29 <= (n1OO30 ^ n1OO28);
	initial
		n1OO30 = 0;
	always @ ( posedge writeclk)
		  n1OO30 <= n1OO28;
	initial
	begin
		niOO = 0;
	end
	always @ ( posedge writeclk or posedge reset)
	begin
		if (reset == 1'b1) 
		begin
			niOO <= 1;
		end
		else 
		begin
			niOO <= wire_nl0O_o;
		end
	end
	initial
	begin
		ni = 0;
		nl1i = 0;
		nll = 0;
		nlO = 0;
		nO = 0;
	end
	always @ ( posedge writeclk or posedge reset)
	begin
		if (reset == 1'b1) 
		begin
			ni <= 0;
			nl1i <= 0;
			nll <= 0;
			nlO <= 0;
			nO <= 0;
		end
		else 
		begin
			ni <= wire_nl0l_o;
			nl1i <= wire_nliO_o;
			nll <= wire_nl1l_o;
			nlO <= wire_nl1O_o;
			nO <= wire_nlii_o;
		end
	end
	and(wire_n0i_dataout, n0lO, ~{(~ alignsyncstatus)});
	assign		wire_n0l_dataout = (n0lO === 1'b1) ? fifocntgt9 : nll;
	assign		wire_n0O_dataout = (n0lO === 1'b1) ? fifocntlt5 : nlO;
	assign		wire_n1i_dataout = ((~ alignsyncstatus) === 1'b1) ? nll : wire_n0l_dataout;
	assign		wire_n1l_dataout = ((~ alignsyncstatus) === 1'b1) ? nlO : wire_n0O_dataout;
	and(wire_n1O_dataout, (~ n0lO), ~{(~ alignsyncstatus)});
	and(wire_nil_dataout, (~ decsync), ~{(~ alignsyncstatus)});
	and(wire_niO_dataout, decsync, ~{(~ alignsyncstatus)});
	and(wire_nlli_dataout, done, ~{(~ alignsyncstatus)});
	and(wire_nlll_dataout, (~ done), ~{(~ alignsyncstatus)});
	and(wire_nllO_dataout, wire_nlOl_dataout, ~{(~ alignsyncstatus)});
	and(wire_nlOi_dataout, wire_nlOO_dataout, ~{(~ alignsyncstatus)});
	and(wire_nlOl_dataout, nlO, ~{done});
	and(wire_nlOO_dataout, nll, ~{done});
	oper_selector   nl0l
	( 
	.data({n0Oi, wire_nil_dataout, 1'b0, (n00i20 & wire_nlli_dataout)}),
	.o(wire_nl0l_o),
	.sel({niOO, ni, nO, (n00l17 & nl1i)}));
	defparam
		nl0l.width_data = 4,
		nl0l.width_sel = 4;
	oper_selector   nl0O
	( 
	.data({(~ n0Oi), (~ alignsyncstatus)}),
	.o(wire_nl0O_o),
	.sel({niOO, (~ niOO)}));
	defparam
		nl0O.width_data = 2,
		nl0O.width_sel = 2;
	oper_selector   nl1l
	( 
	.data({nll, wire_n1i_dataout, wire_nlOi_dataout}),
	.o(wire_nl1l_o),
	.sel({(n1Ol32 & n0ll), nO, nl1i}));
	defparam
		nl1l.width_data = 3,
		nl1l.width_sel = 3;
	oper_selector   nl1O
	( 
	.data({nlO, wire_n1l_dataout, wire_nllO_dataout}),
	.o(wire_nl1O_o),
	.sel({n0ll, (n1OO29 & nO), (n01i26 & nl1i)}));
	defparam
		nl1O.width_data = 3,
		nl1O.width_sel = 3;
	oper_selector   nlii
	( 
	.data({1'b0, wire_niO_dataout, (n00O14 & wire_n1O_dataout)}),
	.o(wire_nlii_o),
	.sel({((niOO | nl1i) | (~ n0ii11)), (n0iO8 & ni), nO}));
	defparam
		nlii.width_data = 3,
		nlii.width_sel = 3;
	oper_selector   nliO
	( 
	.data({1'b0, wire_n0i_dataout, (n0li5 & wire_nlll_dataout)}),
	.o(wire_nliO_o),
	.sel({n0ll, nO, nl1i}));
	defparam
		nliO.width_data = 3,
		nliO.width_sel = 3;
	assign
		n0ll = ((ni | niOO) | (~ n01l23)),
		n0lO = (fifocntlt5 | fifocntgt9),
		n0Oi = ((alignsyncstatus & smenable) & n0Ol2),
		ni1l = 1'b1,
		overflow = nll,
		underflow = nlO;
endmodule //altgxb_comp_fifo_sm
//synopsys translate_on
//VALID FILE
///////////////////////////////////////////////////////////////////////////////
//
//                              ALTGXB_COMP_FIFO
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1 ps/1 ps

   module altgxb_comp_fifo
      (
       datain,
       datainpre,
       reset,
       errdetectin, 
       syncstatusin,
       disperrin,   
       patterndetectin,
       errdetectinpre,
       syncstatusinpre,
       disperrinpre,
       patterndetectinpre,
       writeclk,
       readclk,
       re,
       we,
       fifordin,
       disablefifordin,
       disablefifowrin,
       alignstatus,
       dataout,
       errdetectout,
       syncstatus,
       disperr,
       patterndetect,
       codevalid,
       fifofull,
       fifoalmostful,
       fifoempty,
       fifoalmostempty,
       disablefifordout,
       disablefifowrout,
       fifordout
       );

   parameter     use_rate_match_fifo = "ON";
   parameter     rate_matching_fifo_mode = "XAUI";
   parameter     use_channel_align = "ON";
   parameter     channel_num = 0;
   parameter     for_engineering_sample_device = "ON";
      
   input [9:0] datain;          // encoded word
   input [9:0] datainpre;       // word or dskw fifo
   input       reset;           // reset state machine
   input       errdetectin;     // from previous module
   input       syncstatusin;    // from previous module
   input       disperrin;       // from previous module
   input       patterndetectin; // from previous module
   input       errdetectinpre;     // from previous module
   input       syncstatusinpre;    // from previous module
   input       disperrinpre;       // from previous module
   input       patterndetectinpre; // from previous module
   input       writeclk;        // write clock to the internal FIFO
   input       readclk;         // read clock to the FIFO
   input       re;              // from core
   input       we;              // from core
   input       fifordin;        // indicates initial state of FIFO read
   input       disablefifordin; // do not move read pointer of FIFO
   input       disablefifowrin; // do not move write pointer of FIFO
   input       alignstatus;     // all channels aligned
   
   output [9:0] dataout;        // compensated output (sync with readclk)
   output    errdetectout;   // straight output from invalidcodein and synchronized with output
   output    syncstatus;     // straight output from syncstatusin and synchronized with output
   output    disperr;        // disperrin
   output        patterndetect;  // from previous module
   output    codevalid;      //indicating data is synchronized and aligned. Also feeding to xgmdatavalid
   output    fifofull;       // FIFO has 13 words
   output    fifoalmostful;  // FIFO contains 10 or more words
   output    fifoempty;      // FIFO has less than 4 words
   output    fifoalmostempty;// FIFO contains less than 7
   output    disablefifordout;// output of RX0
   output    disablefifowrout;// output of RX0
   output    fifordout;      // output of RX0
   
   wire      done;
   wire      fifocntgt9;
   wire      fifocntlt5;
   wire      decsync;
   wire      alignsyncstatus;
   wire      smenable;
   wire      overflow;
   wire      underflow;
   wire      disablefifordin;
   wire      disablefifowrin;
   wire [9:0]    dataout;
   
   altgxb_comp_fifo_core comp_fifo_core 
      (
       .reset(reset),
       .writeclk(writeclk),
       .readclk(readclk),
       .underflow(underflow),
       .overflow(overflow),
       .errdetectin(errdetectin),
       .disperrin(disperrin),   
       .patterndetectin(patterndetectin),
       .disablefifordin(disablefifordin),
       .disablefifowrin(disablefifowrin),
       .re (re),
       .we (we),
       .datain(datain),
       .datainpre(datainpre),
       .syncstatusin(syncstatusin),
       .disperr(disperr),
       .alignstatus(alignstatus),                        
       .fifordin (fifordin),
       .fifordout (fifordout),
       .fifoalmostful (fifoalmostful), 
       .fifofull (fifofull), 
       .fifoalmostempty (fifoalmostempty), 
       .fifoempty (fifoempty),
       .decsync(decsync),
       .fifocntlt5(fifocntlt5),
       .fifocntgt9(fifocntgt9),
       .done(done),
       .alignsyncstatus(alignsyncstatus),
       .smenable(smenable),
       .disablefifordout(disablefifordout),
       .disablefifowrout(disablefifowrout),
       .dataout(dataout),
       .codevalid (codevalid),
       .errdetectout(errdetectout),
       .patterndetect(patterndetect),
       .syncstatus(syncstatus)
       ); 
   defparam      comp_fifo_core.use_rate_match_fifo = use_rate_match_fifo;
   defparam      comp_fifo_core.rate_matching_fifo_mode = rate_matching_fifo_mode;
   defparam      comp_fifo_core.use_channel_align = use_channel_align;
   defparam      comp_fifo_core.channel_num = channel_num;
   defparam      comp_fifo_core.for_engineering_sample_device = for_engineering_sample_device; // new in 3.0 sp2
   
   altgxb_comp_fifo_sm comp_fifo_sm 
      (
       .writeclk(writeclk),
       .alignsyncstatus(alignsyncstatus),
       .reset(reset),
       .smenable(smenable),
       .done(done),
       .decsync(decsync),
       .fifocntlt5(fifocntlt5),
       .fifocntgt9(fifocntgt9),
       .underflow(underflow),
       .overflow(overflow)
       );
   
endmodule

///////////////////////////////////////////////////////////////////////////////
//
//                               ALTGXB_RX_CORE
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1 ns / 1 ps
  module altgxb_rx_core
    (
     reset,
     writeclk,
     readclk,
     errdetectin,
     patterndetectin, 
     decdatavalid,
     xgmdatain,
     post8b10b,
     datain,
     xgmctrlin,
     ctrldetectin,
     syncstatusin,
     disparityerrin,
     syncstatus, 
     errdetect,  
     ctrldetect, 
     disparityerr, 
     patterndetect, 
     dataout, 
     a1a2sizeout, 
     clkout
     );

   parameter channel_width = 10;
   parameter use_double_data_mode = "OFF";
   parameter use_channel_align    = "OFF";
   parameter use_8b_10b_mode      = "ON";
   parameter synchronization_mode = "NONE";
   parameter align_pattern = "0000000101111100";
      
   input     reset;
   input     writeclk;
   input     readclk; 
   input     errdetectin;
   input     patterndetectin; 
   input     decdatavalid;
   input [7:0]   xgmdatain;
   input [9:0]   post8b10b;
   input [9:0]   datain;
   input     xgmctrlin;
   input     ctrldetectin;
   input     syncstatusin;
   input     disparityerrin;
   
   output [1:0]  syncstatus;
   output [1:0]  errdetect;
   output [1:0]  ctrldetect;
   output [1:0]  disparityerr;
   output [1:0]  patterndetect;
   output [19:0] dataout; 
   output [1:0]  a1a2sizeout;
   output    clkout;

   wire [19:0]   dataout;
   wire [1:0]    ctrldetect;
   wire      detect;
   wire [7:0]    xgmxor;
   wire      running_disp;
   
   reg       clkout;
   reg       resync_d;
   reg       disperr_d;
   reg       patterndetect_d;
   reg       syncstatusin_1;
   reg       syncstatusin_2;
   reg       disparityerrin_1;
   reg       disparityerrin_2;
   reg       patterndetectin_1;
   reg       patterndetectin_2;
   reg       writeclk_by2;
   reg [12:0]    data_low_sync;
   reg [12:0]    data_low;
   reg [12:0]    data_high;
   reg [9:0]     data_int;
   reg [19:0]    dataout_tmp;
   reg [1:0]     patterndetect_tmp;
   reg [1:0]     disparityerr_tmp;
   reg [1:0]     syncstatus_tmp;
   reg [1:0]     errdetect_tmp;
   reg [1:0]     ctrldetect_tmp;
   reg [1:0]     a1a2sizeout_tmp;
   reg [19:0]    dataout_sync1;
   reg [1:0]     patterndetect_sync1;
   reg [1:0]     disparityerr_sync1;
   reg [1:0]     syncstatus_sync1;
   reg [1:0]     errdetect_sync1;
   reg [1:0]     ctrldetect_sync1;
   reg [1:0]     a1a2sizeout_sync1;
   reg [19:0]    dataout_sync2;
   reg [1:0]     patterndetect_sync2;
   reg [1:0]     disparityerr_sync2;
   reg [1:0]     syncstatus_sync2;
   reg [1:0]     errdetect_sync2;
   reg [1:0]     ctrldetect_sync2;
   reg [1:0]     a1a2sizeout_sync2;

   wire      doublewidth;
   wire      individual;
   wire      ena8b10b;
   wire      smdisable;

   // A1A2 patterndetect related variables
   reg patterndetect_8b;
   reg patterndetect_1_latch;
   reg patterndetect_2_latch;
   reg patterndetect_3_latch;
   
   wire [15 : 0] align_pattern_int;

// function to convert align_pattern to binary
function [15 : 0] pattern_conversion;
    input  [127 : 0] s;
    reg [127 : 0] reg_s;
    reg [15 : 0] digit;
    reg [7 : 0] tmp;
    integer   m;
    begin

        reg_s = s;
        for (m = 15; m >= 0; m = m-1 )
        begin
            tmp = reg_s[127 : 120];
            digit[m] = tmp & 8'b00000001;
            reg_s = reg_s << 8;
        end

        pattern_conversion = {digit[15], digit[14], digit[13], digit[12], digit[11], digit[10], digit[9], digit[8], digit[7], digit[6], digit[5], digit[4], digit[3], digit[2], digit[1], digit[0]};
    end   
endfunction

   assign align_pattern_int = pattern_conversion(align_pattern);
   assign doublewidth = (use_double_data_mode == "ON") ? 1'b1 : 1'b0;
   assign individual  = (use_channel_align != "ON") ? 1'b1 : 1'b0;
   assign ena8b10b    = (use_8b_10b_mode == "ON") ? 1'b1 : 1'b0;
   assign smdisable   = (synchronization_mode == "NONE") ? 1'b1 : 1'b0;

   initial
      begin
     writeclk_by2 = 1'b0;
      end
   
   // A1A2 patterndetect block
   always @ (datain or align_pattern_int or patterndetect_1_latch or patterndetect_3_latch)
   begin
      if (datain[8] == 1'b1)
         patterndetect_8b = (datain[7:0] == align_pattern_int[15:8])
                                      && patterndetect_3_latch;
      else 
         patterndetect_8b = (datain[7:0] == align_pattern_int[15:8]) 
                                      && patterndetect_1_latch;                 
   end

   // A1A2 patterndetect latch
   always @(posedge reset or posedge writeclk)
   begin
      if (reset)
      begin
         patterndetect_1_latch <= 1'b0;  // For first A1 match 
         patterndetect_2_latch <= 1'b0;  // For second A1 match
         patterndetect_3_latch <= 1'b0;  // For first A2 match
      end
      else
      begin
         patterndetect_1_latch <= (datain[7:0] == align_pattern_int[7:0]);
         patterndetect_2_latch <= (patterndetect_1_latch) &
                                (datain[7:0] == align_pattern_int[7:0]);  
         patterndetect_3_latch <= (patterndetect_2_latch) &
                                (datain[7:0] == align_pattern_int[15:8]); 
      end
   end
   
   assign running_disp = disparityerrin | errdetectin;
   
   always @ (xgmdatain or datain or xgmctrlin or 
         ctrldetectin or decdatavalid or data_int or 
         syncstatusin or disparityerrin or patterndetectin or
         patterndetect_8b or syncstatusin_2 or disparityerrin_2 or 
         patterndetectin_2 or running_disp)
      begin
     if (ena8b10b)
        if (individual)
           begin
          resync_d <= syncstatusin;
          disperr_d <= disparityerrin;
          if (!decdatavalid && !smdisable)
             begin
            data_int[8:0] <= 9'h19C; 
            data_int[9]   <= 1'b0;   
            patterndetect_d <= 1'b0;
             end
          else 
          begin
         if (channel_width == 10) 
               patterndetect_d     <= patterndetectin;
         else
               patterndetect_d     <= patterndetect_8b;

            if (decdatavalid && !smdisable && running_disp)
               begin
                  data_int[8:0] <= 9'h1FE;
                  data_int[9]   <= running_disp;
               end
            else
               begin
                  data_int[8:0] <= {ctrldetectin, datain[7:0]};
                  data_int[9]   <= running_disp;
               end
             end
           end
        else
           begin
          resync_d        <= syncstatusin_2;
          disperr_d       <= disparityerrin_2;
          patterndetect_d <= patterndetectin_2;
          data_int[8:0]   <= {xgmctrlin, xgmdatain[7:0]};
          data_int[9]     <= xgmctrlin & ~(detect); 
           end
     else
        begin
           resync_d           <= syncstatusin;
           disperr_d          <= disparityerrin;
           data_int           <= datain;
           if (!decdatavalid && !smdisable)
               patterndetect_d <= 1'b0;
           else
             if (channel_width == 10) 
                   patterndetect_d     <= patterndetectin;
             else
                   patterndetect_d     <= patterndetect_8b;
        end
      end

   assign xgmxor = (xgmdatain[7:0]^8'hFE);
   assign detect = 1'b1 ? (xgmxor != 8'b00000000) : 1'b0;
      
   // MAIN FIFO BLOCK
   always @(posedge reset or posedge writeclk)
      begin
     if (reset)
        begin
           writeclk_by2      <= 1'b0;
           data_high         <= 13'h0000;
           data_low          <= 13'h0000;
           data_low_sync     <= 13'h0000;
           syncstatusin_1    <= 1'b0;
           syncstatusin_2    <= 1'b0;
           disparityerrin_1  <= 1'b0;
           disparityerrin_2  <= 1'b0;
           patterndetectin_1 <= 1'b0;
           patterndetectin_2 <= 1'b0;
        end
     else
        begin
           writeclk_by2      <= ~((writeclk_by2 && individual) || (writeclk_by2 && ~individual));
           syncstatusin_1    <= syncstatusin;
           syncstatusin_2    <= syncstatusin_1;
           disparityerrin_1  <= disparityerrin;
           disparityerrin_2  <= disparityerrin_1;
           patterndetectin_1 <= patterndetectin;
           patterndetectin_2 <= patterndetectin_1;
           
           if (doublewidth && !writeclk_by2)
          begin
             data_high[9:0] <= data_int;
             data_high[10]  <= resync_d;
             data_high[11]  <= disperr_d;
             data_high[12]  <= patterndetect_d;          
          end
           if (doublewidth & writeclk_by2)
          begin
             data_low[9:0]  <= data_int;
             data_low[10]   <= resync_d;
             data_low[11]   <= disperr_d;
             data_low[12]   <= patterndetect_d;
          end
           if (!doublewidth)
          begin
             data_low_sync[9:0] <= data_int;
             data_low_sync[10]  <= resync_d;
             data_low_sync[11]  <= disperr_d;
             data_low_sync[12]  <= patterndetect_d;
          end
           else 
          data_low_sync <= data_low;
        end
      end

   // CLOCK OUT BLOCK
   always @(writeclk_by2 or writeclk)
      begin
     if (doublewidth)
        clkout <= ~writeclk_by2; 
     else
        clkout <= ~writeclk;
      end
   
   // READ CLOCK BLOCK
   always @(posedge reset or posedge readclk)
      begin
     if(reset)
        begin
           dataout_tmp       <= 20'b0;
           patterndetect_tmp <= 2'b0;
           disparityerr_tmp  <= 2'b0;
           syncstatus_tmp    <= 2'b0;
           errdetect_tmp     <= 2'b0;
           ctrldetect_tmp    <= 2'b0;
           a1a2sizeout_tmp    <= 2'b0;
           dataout_sync1       <= 20'b0;
           patterndetect_sync1 <= 2'b0;
           disparityerr_sync1  <= 2'b0;
           syncstatus_sync1    <= 2'b0;
           errdetect_sync1     <= 2'b0;
           ctrldetect_sync1    <= 2'b0;
           a1a2sizeout_sync1    <= 2'b0;
           dataout_sync2       <= 20'b0;
           patterndetect_sync2 <= 2'b0;
           disparityerr_sync2  <= 2'b0;
           syncstatus_sync2    <= 2'b0;
           errdetect_sync2     <= 2'b0;
           ctrldetect_sync2    <= 2'b0;
           a1a2sizeout_sync2    <= 2'b0;
        end
     else
        begin
           if (ena8b10b || channel_width == 8 || channel_width == 16)
              dataout_sync1 <= {4'b0000, data_high[7:0], data_low_sync[7:0]};
          else
              dataout_sync1 <= {data_high[9:0], data_low_sync[9:0]};

           patterndetect_sync1 <= {data_high[12], data_low_sync[12]};
           disparityerr_sync1  <= {data_high[11], data_low_sync[11]};
           syncstatus_sync1    <= {data_high[10], data_low_sync[10]};
           errdetect_sync1     <= {data_high[9], data_low_sync[9]};
           ctrldetect_sync1    <= {data_high[8], data_low_sync[8]};
          if (channel_width == 8)
              a1a2sizeout_sync1   <= {data_high[8], data_low_sync[8]};
          else
              a1a2sizeout_sync1   <= 2'b0;
           dataout_sync2       <= dataout_sync1;
           patterndetect_sync2 <= patterndetect_sync1;
           disparityerr_sync2  <= disparityerr_sync1;
           syncstatus_sync2    <= syncstatus_sync1;
           errdetect_sync2     <= errdetect_sync1;
           ctrldetect_sync2    <= ctrldetect_sync1;
           a1a2sizeout_sync2   <= a1a2sizeout_sync1;
           dataout_tmp         <= dataout_sync2;
           patterndetect_tmp   <= patterndetect_sync2;
           disparityerr_tmp    <= disparityerr_sync2;
           syncstatus_tmp      <= syncstatus_sync2;
           errdetect_tmp       <= errdetect_sync2;
           ctrldetect_tmp      <= ctrldetect_sync2;
           a1a2sizeout_tmp     <= a1a2sizeout_sync2;
        end
      end

   assign dataout = dataout_tmp;
   assign a1a2sizeout = a1a2sizeout_tmp;
   assign patterndetect = patterndetect_tmp;
   assign disparityerr = disparityerr_tmp;
   assign syncstatus = syncstatus_tmp;
   assign errdetect = errdetect_tmp;
   assign ctrldetect = ctrldetect_tmp;
      
endmodule // altgxb_rx_core
 
//
// ALTGXB_HSSI_RX_SERDES
//

`timescale 1 ps/1 ps

module altgxb_hssi_rx_serdes 
    (
        cruclk, 
        datain, 
        areset, 
        feedback, 
        fbkcntl, 
        ltr,        // q3.0ll
        ltd,        // q3.0ll
        clkout, 
        dataout, 
        rlv, 
        lock, 
        freqlock, 
        signaldetect 
    );

input datain;
input cruclk;
input areset;
input feedback;
input fbkcntl;
input ltr;
input ltd;

output [9:0] dataout;
output clkout;
output rlv;
output lock;
output freqlock;
output signaldetect;

parameter channel_width = 10;
parameter run_length = 4; 
parameter run_length_enable = "OFF";
parameter cruclk_period = 5000;
parameter cruclk_multiplier = 4;
parameter use_cruclk_divider = "OFF"; 
parameter use_double_data_mode = "OFF"; 
parameter channel_width_max = 10;

parameter init_lock_latency = 9;  // internal used for q3.0ll
integer cruclk_cnt;                
reg freqlock_tmp_dly;             
reg freqlock_tmp_dly1;           
reg freqlock_tmp_dly2;         
reg freqlock_tmp_dly3;        
reg freqlock_tmp_dly4;        

integer i, clk_count, rlv_count;
reg fastclk_last_value, clkout_last_value;
reg cruclk_last_value;
reg [channel_width_max-1:0] deser_data_arr;
reg [channel_width_max-1:0] deser_data_arr_tmp;
reg rlv_flag, rlv_set;
reg clkout_tmp;
reg lock_tmp;
reg freqlock_tmp;
reg signaldetect_tmp;
reg [9:0] dataout_tmp;
wire [9:0] data_out;
reg datain_in;
reg last_datain;
reg data_changed;

// clock generation
reg fastclk1;
reg fastclk;
integer n_fastclk;
integer fastclk_period;
integer rem;
integer my_rem;
integer tmp_fastclk_period;
integer cycle_to_adjust;
integer high_time;
integer low_time;
integer k;
integer sched_time;
reg     sched_val;

// new RLV variables
wire rlv_tmp;
reg rlv_tmp1, rlv_tmp2, rlv_tmp3;
wire min_length;

// wire declarations
wire cruclk_in;
wire datain_buf;
wire fbin_in;
wire fbena_in;
wire areset_in;
wire ltr_in;
wire ltd_in;

buf (cruclk_in, cruclk);
buf (datain_buf, datain);
buf (fbin_in, feedback);
buf (fbena_in, fbkcntl);
buf (areset_in, areset);
buf (ltr_in, ltr);          // q3.0ll
buf (ltd_in, ltd);          // q3.0ll

initial
begin
    i = 0;
    clk_count = channel_width;
    rlv_count = 0;
    fastclk_last_value = 'b0;
    //cruclk_last_value = 'b0;
    clkout_last_value = 'b0;
    clkout_tmp = 'b0;
    rlv_tmp1 = 'b0;
    rlv_tmp2 = 'b0;
    rlv_tmp3 = 'b0;
    rlv_flag = 'b0;
    rlv_set = 'b0;

    lock_tmp = 'b1;             // q3.0ll
    freqlock_tmp = 'b0;         
    cruclk_cnt = 0;            
    freqlock_tmp_dly = 'b0;     
    freqlock_tmp_dly1 = 'b0;     
    freqlock_tmp_dly2 = 'b0;     
    freqlock_tmp_dly3 = 'b0;     
    freqlock_tmp_dly4 = 'b0;    //
      
    signaldetect_tmp = 'b1;
    dataout_tmp = 10'bX;
    last_datain = 'bX;
    data_changed = 'b0;
   for (i = channel_width_max - 1; i >= 0; i = i - 1)
    deser_data_arr[i] = 1'b0;
   for (i = channel_width_max - 1; i >= 0; i = i - 1)
    deser_data_arr_tmp[i] = 1'b0;

   // q4.0 -    
   if (use_cruclk_divider == "OFF")
       n_fastclk = cruclk_multiplier;
   else
       n_fastclk = cruclk_multiplier / 2;
       
   fastclk_period = cruclk_period / n_fastclk;
   rem = cruclk_period % n_fastclk;
end
        
assign min_length = (channel_width == 8) ? 4 : 5;
        
always @(cruclk_in)
begin
   if ((cruclk_in === 'b1) && (cruclk_last_value === 'b0))
   begin 
       // schedule n_fastclk of clk with period fastclk_period
       sched_time = 0;
       sched_val = 1'b1; // start with rising to match cruclk
       
       k = 1; // used to distribute rem ps to n_fastclk internals
       for (i = 1; i <= n_fastclk; i = i + 1)
       begin
           fastclk1 <= #(sched_time) sched_val; // rising
             
           // wether it needs to add extra ps to the period
           tmp_fastclk_period = fastclk_period;
           if (rem != 0 && k <= rem)
           begin
               cycle_to_adjust = (n_fastclk * k) / rem;
               my_rem = (n_fastclk * k) % rem;
               if (my_rem != 0)
                   cycle_to_adjust = cycle_to_adjust + 1;
                     
               if (cycle_to_adjust == i)
               begin
                   tmp_fastclk_period = tmp_fastclk_period + 1;
                   k = k + 1;
               end
           end
                     
           high_time = tmp_fastclk_period / 2;
           low_time  = tmp_fastclk_period - high_time; 
           sched_val = ~sched_val;
           sched_time = sched_time + high_time;
           fastclk1 <= #(sched_time) sched_val; // falling edge
           sched_time = sched_time + low_time;
           sched_val = ~sched_val;
       end           
   end // rising cruclk
             
   cruclk_last_value <= cruclk_in;
end

always @(fastclk1)
    fastclk <= fastclk1;
      
always @(fastclk or areset_in or fbena_in)
begin

    if (areset_in == 1'b1)
    begin
        dataout_tmp = 10'b0;
        clk_count = channel_width;
        clkout_tmp = 1'b0;
    clkout_last_value = fastclk;
      rlv_tmp1 = 1'b0;
      rlv_tmp2 = 1'b0;
      rlv_tmp3 = 1'b0;
      rlv_flag = 1'b0;
      rlv_set = 1'b0;
      signaldetect_tmp = 1'b1;
      last_datain = 'bX;
      rlv_count = 0;
      data_changed = 'b0;
       for (i = channel_width_max - 1; i >= 0; i = i - 1)
           deser_data_arr[i] = 1'b0;
       for (i = channel_width_max - 1; i >= 0; i = i - 1)
           deser_data_arr_tmp[i] = 1'b0;
    end
   else 
    begin
        if (fbena_in == 1'b1)
            datain_in = fbin_in;
        else
            datain_in = datain_buf;

    if (((fastclk == 'b1) && (fastclk_last_value !== fastclk)) ||
         ((fastclk == 'b0) && (fastclk_last_value !== fastclk)))
       begin
            if (clk_count == channel_width)
            begin
                clk_count = 0;
                clkout_tmp = !clkout_last_value;
            end
            else if (clk_count == channel_width/2)
                clkout_tmp = !clkout_last_value;
            else if (clk_count < channel_width)
                clkout_tmp = clkout_last_value;
          clk_count = clk_count + 1;
       end

        // data loaded on both edges
    if (((fastclk == 'b1) && (fastclk_last_value !== fastclk)) ||
         ((fastclk == 'b0) && (fastclk_last_value !== fastclk)))
    begin
       for (i = 1; i < channel_width_max; i = i + 1)
           deser_data_arr[i - 1] <= deser_data_arr[i];
       deser_data_arr[channel_width_max - 1] <= datain_in;

            if (run_length_enable == "ON") //rlv checking
            begin
                if (last_datain !== datain_in)
                begin
                    data_changed = 'b1;
                    last_datain = datain_in;
                    rlv_count = 1;
                    rlv_set = 'b0;
                end
                else //data not changed
                begin
                    rlv_count = rlv_count + 1;
                    data_changed = 'b0;
                end
                if (rlv_count > run_length && rlv_count > min_length)
                begin
                    rlv_flag = 'b1;
                    rlv_set = 'b1;
                end
            end
    end

    clkout_last_value = clkout_tmp;

    end

   fastclk_last_value = fastclk;

end

always @(posedge clkout_tmp)
begin
    deser_data_arr_tmp <= deser_data_arr;

   dataout_tmp[channel_width_max-1:0] <= deser_data_arr_tmp;

    if (run_length_enable == "ON") //rlv checking
    begin
        if (rlv_flag == 'b1)
            if (rlv_set == 'b0)
                rlv_flag = 'b0;

        if (rlv_flag == 'b1)
           rlv_tmp1 <= 'b1;
        else
            rlv_tmp1 <= 'b0;

      rlv_tmp2 <= rlv_tmp1;
      rlv_tmp3 <= rlv_tmp2;
    end

end

// q3.0ll - locked and freqlock based on LTR and LTD
always @(posedge areset_in or cruclk_in)
begin
  if ((cruclk_in == 1'b1) && (cruclk_last_value == 1'b0))
  begin
    if (areset_in == 1'b1)
        begin
            cruclk_cnt <= 0;
            lock_tmp <= 1'b1;
            freqlock_tmp <= 1'b0;
            freqlock_tmp_dly <= 1'b0;
            freqlock_tmp_dly1 <= 1'b0;     
            freqlock_tmp_dly2 <= 1'b0;     
            freqlock_tmp_dly3 <= 1'b0;     
            freqlock_tmp_dly4 <= 1'b0;
        end
    else if (cruclk_last_value == 'b0)
        begin
            freqlock_tmp_dly <= freqlock_tmp_dly4;
            freqlock_tmp_dly4 <= freqlock_tmp_dly3;
            freqlock_tmp_dly3 <= freqlock_tmp_dly2;
            freqlock_tmp_dly2 <= freqlock_tmp_dly1;
            freqlock_tmp_dly1 <= freqlock_tmp;

            // initial latency
            if (cruclk_cnt < init_lock_latency)
                cruclk_cnt <= cruclk_cnt + 1;
        
            if (cruclk_cnt == init_lock_latency)
                begin
                    if (ltd_in == 1'b1)
                        begin
                            freqlock_tmp <= 1'b1;
                        end
                    else if (ltr_in == 1'b1)
                        begin
                            lock_tmp <= 1'b0;
                            freqlock_tmp <= 1'b0;
                        end
                    else     // auto switch
                        begin
                            lock_tmp <= 1'b0;
                            freqlock_tmp <= 1'b1;
                        end
                end             
        end
  end // end of cruclk == 1
end
 
assign rlv_tmp = (use_double_data_mode == "ON") ? (rlv_tmp1 | rlv_tmp2 | rlv_tmp3) : (rlv_tmp1 | rlv_tmp2);

assign data_out = dataout_tmp;

buf (dataout[0], data_out[0]);
buf (dataout[1], data_out[1]);
buf (dataout[2], data_out[2]);
buf (dataout[3], data_out[3]);
buf (dataout[4], data_out[4]);
buf (dataout[5], data_out[5]);
buf (dataout[6], data_out[6]);
buf (dataout[7], data_out[7]);
buf (dataout[8], data_out[8]);
buf (dataout[9], data_out[9]);

and (rlv, rlv_tmp, 1'b1);
and (lock, lock_tmp, 1'b1);
and (freqlock, freqlock_tmp_dly, 1'b1);      // q3.0ll extra latency on freqlock
and (signaldetect, signaldetect_tmp, 1'b1);
and (clkout, clkout_tmp, 1'b1);

endmodule

// 4 to 1 MULTIPLEXER
module altgxb_hssi_mux4(Y,I0,I1,I2,I3,C0,C1); 
  input I0,I1,I2,I3,C0,C1; 
  output Y; 
  reg   Y; 
  always@(I0 or I1 or I2 or I3 or C0 or C1) begin 
      case ({C1,C0})  
          2'b00 : Y = I0 ; 
          2'b01 : Y = I1 ; 
          2'b10 : Y = I2 ; 
          2'b11 : Y = I3 ; 
      endcase 
  end 
endmodule // altgxb_hssi_mux4

// DIVIDE BY TWO LOGIC
module altgxb_hssi_divide_by_two 
   (
    reset,
    clkin,
    clkout
    );
   parameter divide = "ON";

   input     reset;
   input     clkin;
   output    clkout;
   reg       clktmp;

   tri0      reset;

   initial
      begin
     clktmp = 1'b0;
      end

   always@(clkin or posedge reset) 
   begin
    if(divide == "OFF")
       clktmp <= clkin;
    else if (reset === 1'b1)
       clktmp <= 1'b0;
    else
       if(clkin == 1'b1)
          clktmp <= ~clktmp;
   end 

   assign clkout = clktmp;

endmodule
   

///////////////////////////////////////////////////////////////////////////////
//
//                           ALTGXB_HSSI_RECEIVER
//
///////////////////////////////////////////////////////////////////////////////

`timescale 1 ps/1 ps

module altgxb_hssi_receiver 
   (
    datain,
    cruclk,
    pllclk,
    masterclk,
    coreclk,
    softreset,
    analogreset,
    serialfdbk,
    slpbk,
    bitslip,
    enacdet,
    we,
    re,
    alignstatus,
    disablefifordin,
    disablefifowrin,
    fifordin,
    enabledeskew,
    fiforesetrd,
    xgmctrlin,
    a1a2size,
    locktorefclk,
    locktodata,
    parallelfdbk,
    post8b10b,
    equalizerctrl,
    xgmdatain,
    devclrn,
    devpor,
    syncstatusdeskew,
    adetectdeskew,
    rdalign,
    xgmctrldet,
    xgmrunningdisp,
    xgmdatavalid,
    fifofull,
    fifoalmostfull,
    fifoempty,
    fifoalmostempty,
    disablefifordout,
    disablefifowrout,
    fifordout,
    bisterr,
    bistdone,
    a1a2sizeout,
    signaldetect,
    lock,
    freqlock,
    rlv,
    clkout,
    recovclkout,
    syncstatus,
    patterndetect,
    ctrldetect,
    errdetect,
    disperr,
    dataout,
    xgmdataout
    );
   
parameter channel_num = 1;
parameter channel_width = 20;
parameter deserialization_factor = 10;
parameter run_length = 4; 
parameter run_length_enable = "OFF"; 
parameter use_8b_10b_mode = "OFF"; 
parameter use_double_data_mode = "OFF"; 
parameter use_rate_match_fifo = "OFF"; 
parameter rate_matching_fifo_mode = "NONE"; 
parameter use_channel_align = "OFF"; 
parameter use_symbol_align = "ON"; 
parameter use_auto_bit_slip = "ON"; 
parameter synchronization_mode = "NONE"; 
parameter align_pattern = "0000000101111100";
parameter align_pattern_length = 7; 
parameter infiniband_invalid_code = 0; 
parameter disparity_mode = "OFF";
parameter clk_out_mode_reference = "ON";
parameter cruclk_period = 5000;
parameter cruclk_multiplier = 4;
parameter use_cruclk_divider = "OFF"; 
parameter use_parallel_feedback = "OFF";
parameter use_post8b10b_feedback = "OFF";
parameter send_reverse_parallel_feedback = "OFF";
parameter use_self_test_mode = "OFF";
parameter self_test_mode = 0;
parameter use_equalizer_ctrl_signal = "OFF";
parameter enable_dc_coupling = "OFF";
parameter equalizer_ctrl_setting = 20;
parameter signal_threshold_select = 2;
parameter vco_bypass = "OFF";
parameter force_signal_detect = "OFF";
parameter bandwidth_type = "LOW";
parameter for_engineering_sample_device = "ON"; // new in 3.0 sp2
     
input datain;
input cruclk;
input pllclk;
input masterclk;
input coreclk;
input softreset;
input serialfdbk;
input [9 : 0] parallelfdbk;
input [9 : 0] post8b10b;
input slpbk;
input bitslip;
input enacdet;
input we;
input re;
input alignstatus;
input disablefifordin;
input disablefifowrin;
input fifordin;
input enabledeskew;
input fiforesetrd;
input [7 : 0] xgmdatain;
input xgmctrlin;
input devclrn;
input devpor;
input analogreset;
input a1a2size;
input locktorefclk;
input locktodata;
input [2:0] equalizerctrl;
   
   
output [1 : 0] syncstatus;
output [1 : 0] patterndetect;
output [1 : 0] ctrldetect;
output [1 : 0] errdetect;
output [1 : 0] disperr;
output syncstatusdeskew;
output adetectdeskew;
output rdalign;
output [19:0] dataout;
output [7:0] xgmdataout;
output xgmctrldet;
output xgmrunningdisp;
output xgmdatavalid;
output fifofull;
output fifoalmostfull;
output fifoempty;
output fifoalmostempty;
output disablefifordout;
output disablefifowrout;
output fifordout;
output signaldetect;
output lock;
output freqlock;
output rlv;
output clkout;
output recovclkout;
output bisterr;
output bistdone;
output [1 : 0] a1a2sizeout; 
      
assign bisterr = 1'b0;
assign bistdone = 1'b1;

// input buffers
wire datain_in;
wire cruclk_in;
wire pllclk_in;
wire masterclk_in;
wire coreclk_in;
wire softreset_in;
wire serialfdbk_in;
wire analogreset_in;
wire locktorefclk_in;
wire locktodata_in;
   
wire parallelfdbk_in0;
wire parallelfdbk_in1;
wire parallelfdbk_in2;
wire parallelfdbk_in3;
wire parallelfdbk_in4;
wire parallelfdbk_in5;
wire parallelfdbk_in6;
wire parallelfdbk_in7;
wire parallelfdbk_in8;
wire parallelfdbk_in9;

wire post8b10b_in0;
wire post8b10b_in1;
wire post8b10b_in2;
wire post8b10b_in3;
wire post8b10b_in4;
wire post8b10b_in5;
wire post8b10b_in6;
wire post8b10b_in7;
wire post8b10b_in8;
wire post8b10b_in9;

wire slpbk_in;
wire bitslip_in;
wire a1a2size_in;
wire enacdet_in;
wire we_in;
wire re_in;
wire alignstatus_in;
wire disablefifordin_in;
wire disablefifowrin_in;
wire fifordin_in;
wire enabledeskew_in;
wire fiforesetrd_in;

wire xgmdatain_in0;
wire xgmdatain_in1;
wire xgmdatain_in2;
wire xgmdatain_in3;
wire xgmdatain_in4;
wire xgmdatain_in5;
wire xgmdatain_in6;
wire xgmdatain_in7;

wire xgmctrlin_in;
      
// input buffers
buf(datain_in, datain);
buf(cruclk_in, cruclk);
buf(pllclk_in, pllclk);
buf(masterclk_in, masterclk);
buf(coreclk_in, coreclk);
buf(softreset_in, softreset);
buf(serialfdbk_in, serialfdbk);
buf(analogreset_in, analogreset);
buf(locktorefclk_in, locktorefclk);
buf(locktodata_in, locktodata);
   
buf(parallelfdbk_in0, parallelfdbk[0]);
buf(parallelfdbk_in1, parallelfdbk[1]);
buf(parallelfdbk_in2, parallelfdbk[2]);
buf(parallelfdbk_in3, parallelfdbk[3]);
buf(parallelfdbk_in4, parallelfdbk[4]);
buf(parallelfdbk_in5, parallelfdbk[5]);
buf(parallelfdbk_in6, parallelfdbk[6]);
buf(parallelfdbk_in7, parallelfdbk[7]);
buf(parallelfdbk_in8, parallelfdbk[8]);
buf(parallelfdbk_in9, parallelfdbk[9]);

buf(post8b10b_in0, post8b10b[0]);
buf(post8b10b_in1, post8b10b[1]);
buf(post8b10b_in2, post8b10b[2]);
buf(post8b10b_in3, post8b10b[3]);
buf(post8b10b_in4, post8b10b[4]);
buf(post8b10b_in5, post8b10b[5]);
buf(post8b10b_in6, post8b10b[6]);
buf(post8b10b_in7, post8b10b[7]);
buf(post8b10b_in8, post8b10b[8]);
buf(post8b10b_in9, post8b10b[9]);

buf(slpbk_in, slpbk);
buf(bitslip_in, bitslip);
buf(a1a2size_in, a1a2size);
buf(enacdet_in, enacdet);
buf(we_in, we);
buf(re_in, re);
buf(alignstatus_in, alignstatus);
buf(disablefifordin_in, disablefifordin);
buf(disablefifowrin_in, disablefifowrin);
buf(fifordin_in, fifordin);
buf(enabledeskew_in, enabledeskew);
buf(fiforesetrd_in, fiforesetrd);

buf(xgmdatain_in0, xgmdatain[0]);
buf(xgmdatain_in1, xgmdatain[1]);
buf(xgmdatain_in2, xgmdatain[2]);
buf(xgmdatain_in3, xgmdatain[3]);
buf(xgmdatain_in4, xgmdatain[4]);
buf(xgmdatain_in5, xgmdatain[5]);
buf(xgmdatain_in6, xgmdatain[6]);
buf(xgmdatain_in7, xgmdatain[7]);

buf(xgmctrlin_in, xgmctrlin);

//constant signals
wire vcc, gnd;
wire [9 : 0] idle_bus;

//lower lever softreset
wire reset_int;

// internal bus for XGM/post8b10b data
wire [7 : 0] xgmdatain_in;
wire [9 : 0] post8b10b_in;

assign xgmdatain_in = {
                                xgmdatain_in7, xgmdatain_in6,
                                xgmdatain_in5, xgmdatain_in4,
                                xgmdatain_in3, xgmdatain_in2,
                                xgmdatain_in1, xgmdatain_in0
                             };
assign post8b10b_in = {                     post8b10b_in9, post8b10b_in8,
                                post8b10b_in7, post8b10b_in6,
                                post8b10b_in5, post8b10b_in4,
                                post8b10b_in3, post8b10b_in2,
                                post8b10b_in1, post8b10b_in0
                             };

assign reset_int = softreset_in;
assign vcc = 1'b1;
assign gnd = 1'b0;
assign idle_bus = 10'b0000000000;

// serdes output signals
wire serdes_clkout; //receovered clock
wire serdes_rlv;
wire serdes_signaldetect;
wire serdes_lock;
wire serdes_freqlock;
wire [9 : 0] serdes_dataout;

// word aligner input/output signals
wire [9 : 0] wa_datain;
wire wa_clk;
wire wa_enacdet;
wire wa_bitslip;
wire wa_a1a2size;

wire [9 : 0] wa_aligneddata;
wire [9 : 0] wa_aligneddatapre;
wire wa_invalidcode;
wire wa_invalidcodepre;
wire wa_disperr;
wire wa_disperrpre;
wire wa_patterndetect;
wire wa_patterndetectpre;
wire wa_syncstatus;
wire wa_syncstatusdeskew;

// deskew FIFO input/output signals
wire [9:0] dsfifo_datain;     
wire dsfifo_errdetectin;   
wire dsfifo_syncstatusin;  
wire dsfifo_disperrin; 
wire dsfifo_patterndetectin; 
wire dsfifo_writeclock;
wire dsfifo_readclock; 
wire dsfifo_fiforesetrd; 
wire dsfifo_enabledeskew;

wire [9:0] dsfifo_dataout; 
wire [9:0] dsfifo_dataoutpre; 
wire dsfifo_errdetect;   
wire dsfifo_syncstatus; 
wire dsfifo_disperr;    
wire dsfifo_errdetectpre;   
wire dsfifo_syncstatuspre; 
wire dsfifo_disperrpre;    
wire dsfifo_patterndetect; 
wire dsfifo_patterndetectpre; 
wire dsfifo_adetectdeskew;
wire dsfifo_rdalign;     
   
// comp FIFO input/output signals
   
wire [9:0] cmfifo_datain;
wire [9:0] cmfifo_datainpre;
wire cmfifo_invalidcodein; 
wire cmfifo_syncstatusin;
wire cmfifo_disperrin;  
wire cmfifo_patterndetectin;
wire cmfifo_invalidcodeinpre; 
wire cmfifo_syncstatusinpre;
wire cmfifo_disperrinpre;  
wire cmfifo_patterndetectinpre;
wire cmfifo_writeclk;      
wire cmfifo_readclk;      
wire cmfifo_alignstatus;
wire cmfifo_re;
wire cmfifo_we;
wire cmfifo_fifordin;
wire cmfifo_disablefifordin; 
wire cmfifo_disablefifowrin;
   
wire [9:0] cmfifo_dataout; 
wire cmfifo_invalidcode;
wire cmfifo_syncstatus;
wire cmfifo_disperr;
wire cmfifo_patterndetect;
wire cmfifo_datavalid;
wire cmfifo_fifofull;
wire cmfifo_fifoalmostfull;
wire cmfifo_fifoempty;
wire cmfifo_fifoalmostempty;
wire cmfifo_disablefifordout;
wire cmfifo_disablefifowrout;
wire cmfifo_fifordout;

// 8B10B decode input/output signals
wire decoder_clk; 
wire [9 : 0] decoder_datain;   
wire decoder_errdetectin;         
wire decoder_syncstatusin;         
wire decoder_disperrin;         
wire decoder_patterndetectin;         
wire decoder_indatavalid;         
   
wire [7 : 0] decoder_dataout;
wire [9 : 0] decoder_tenBdata; 
wire decoder_valid;         
wire decoder_errdetect;
wire decoder_rderr;         
wire decoder_syncstatus;         
wire decoder_disperr;         
wire decoder_patterndetect;         
wire decoder_decdatavalid;    
wire decoder_ctrldetect;   
wire decoder_xgmdatavalid;
wire decoder_xgmrunningdisp;
wire decoder_xgmctrldet;
wire [7 : 0] decoder_xgmdataout; 

// core interface input/output signals
wire [9:0] core_datain;
wire core_writeclk;
wire core_readclk;
wire core_decdatavalid;
wire [7:0] core_xgmdatain;
wire core_xgmctrlin;
wire [9:0] core_post8b10b;
wire core_syncstatusin;
wire core_errdetectin;
wire core_ctrldetectin;
wire core_disparityerrin;
wire core_patterndetectin;
   
wire [19:0] core_dataout;
wire core_clkout;
wire [1:0]  core_a1a2sizeout; 
wire [1:0]  core_syncstatus;
wire [1:0]  core_errdetect;
wire [1:0]  core_ctrldetect;
wire [1:0]  core_disparityerr;
wire [1:0]  core_patterndetect;

// interconnection variables
wire invalidcode;
wire [19 : 0] dataout_tmp;

// clkout mux output
// - added gfifo
wire clkoutmux_clkout;
wire clkoutmux_clkout_pre;

// wire declarations from lint
wire clk2mux1_c0;
wire  clk2mux1_c1;
wire  rxrdclk_mux1;
wire  rxrdclkmux1_c0;
wire  rxrdclkmux1_c1;
wire  rxrdclk_mux1_by2;
wire  rxrdclkmux2_c0;
wire  rxrdclkmux2_c1;

// MAIN CLOCKS
wire     rcvd_clk;
wire     clk_1;
wire     clk_2;
wire     rx_rd_clk;
wire     clk2_mux1;
wire     rx_rd_clk_mux;
   

specify


    (posedge coreclk => (dataout[0] +: dataout_tmp[0])) = (0, 0);
    (posedge coreclk => (dataout[1] +: dataout_tmp[1])) = (0, 0);
    (posedge coreclk => (dataout[2] +: dataout_tmp[2])) = (0, 0);
    (posedge coreclk => (dataout[3] +: dataout_tmp[3])) = (0, 0);
    (posedge coreclk => (dataout[4] +: dataout_tmp[4])) = (0, 0);
    (posedge coreclk => (dataout[5] +: dataout_tmp[5])) = (0, 0);
    (posedge coreclk => (dataout[6] +: dataout_tmp[6])) = (0, 0);
    (posedge coreclk => (dataout[7] +: dataout_tmp[7])) = (0, 0);
    (posedge coreclk => (dataout[8] +: dataout_tmp[8])) = (0, 0);
    (posedge coreclk => (dataout[9] +: dataout_tmp[9])) = (0, 0);
    (posedge coreclk => (dataout[10] +: dataout_tmp[10])) = (0, 0);
    (posedge coreclk => (dataout[11] +: dataout_tmp[11])) = (0, 0);
    (posedge coreclk => (dataout[12] +: dataout_tmp[12])) = (0, 0);
    (posedge coreclk => (dataout[13] +: dataout_tmp[13])) = (0, 0);
    (posedge coreclk => (dataout[14] +: dataout_tmp[14])) = (0, 0);
    (posedge coreclk => (dataout[15] +: dataout_tmp[15])) = (0, 0);
    (posedge coreclk => (dataout[16] +: dataout_tmp[16])) = (0, 0);
    (posedge coreclk => (dataout[17] +: dataout_tmp[17])) = (0, 0);
    (posedge coreclk => (dataout[18] +: dataout_tmp[18])) = (0, 0);
    (posedge coreclk => (dataout[19] +: dataout_tmp[19])) = (0, 0);

    (posedge coreclk => (syncstatus[0] +: core_syncstatus[0])) = (0, 0);
    (posedge coreclk => (syncstatus[1] +: core_syncstatus[1])) = (0, 0);

    (posedge coreclk => (patterndetect[0] +: core_patterndetect[0])) = (0, 0);
    (posedge coreclk => (patterndetect[1] +: core_patterndetect[1])) = (0, 0);

    (posedge coreclk => (ctrldetect[0] +: core_ctrldetect[0])) = (0, 0);
    (posedge coreclk => (ctrldetect[1] +: core_ctrldetect[1])) = (0, 0);

    (posedge coreclk => (errdetect[0] +: core_errdetect[0])) = (0, 0);
    (posedge coreclk => (errdetect[1] +: core_errdetect[1])) = (0, 0);

    (posedge coreclk => (disperr[0] +: core_disparityerr[0])) = (0, 0);
    (posedge coreclk => (disperr[1] +: core_disparityerr[1])) = (0, 0);

    (posedge coreclk => (a1a2sizeout[0] +: core_a1a2sizeout[0])) = (0, 0);
    (posedge coreclk => (a1a2sizeout[1] +: core_a1a2sizeout[1])) = (0, 0);

    (posedge coreclk => (fifofull +: cmfifo_fifofull)) = (0, 0);
    (posedge coreclk => (fifoempty +: cmfifo_fifoempty)) = (0, 0);
    (posedge coreclk => (fifoalmostfull +: cmfifo_fifoalmostfull)) = (0, 0);
    (posedge coreclk => (fifoalmostempty +: cmfifo_fifoalmostempty)) = (0, 0);
    $setuphold(posedge coreclk, re, 0, 0);


endspecify

// generate internal inut signals

   // generate internal input signals

   // RCVD_CLK LOGIC
   assign rcvd_clk = (use_parallel_feedback == "ON") ? pllclk_in : serdes_clkout;

   // CLK_1 LOGIC
   assign clk_1 = (use_parallel_feedback == "ON") ? pllclk_in : (use_channel_align == "ON") ? masterclk_in : serdes_clkout;
   
   // CLK_2 LOGIC
   // - added gfifo
   assign clk_2 = (clk_out_mode_reference == "OFF") ? coreclk_in : clk2_mux1;

   // RX_RD_CLK
   // - added gfifo
   assign rx_rd_clk = (clk_out_mode_reference == "OFF") ? coreclk_in : rx_rd_clk_mux;

   altgxb_hssi_mux4 clk2mux1 
      (
       .Y(clk2_mux1),
       .I0(serdes_clkout),
       .I1(masterclk_in),
       .I2(1'b0),
       .I3(pllclk_in),
       .C0(clk2mux1_c0),
       .C1(clk2mux1_c1)
       );
   
   assign clk2mux1_c0 = (use_parallel_feedback == "ON") | (use_channel_align == "ON") | (use_rate_match_fifo == "ON") ? 1'b1 : 1'b0;
   assign clk2mux1_c1 = (use_parallel_feedback == "ON") | (use_rate_match_fifo == "ON") ? 1'b1 : 1'b0;

   altgxb_hssi_mux4 rxrdclkmux1 
      (
       .Y(rxrdclk_mux1),
       .I0(serdes_clkout),
       .I1(masterclk_in),
       .I2(1'b0),
       .I3(pllclk_in),
       .C0(rxrdclkmux1_c0),
       .C1(rxrdclkmux1_c1)
       );
   
   assign rxrdclkmux1_c1 = (use_parallel_feedback == "ON") | (use_rate_match_fifo == "ON") ? 1'b1 : 1'b0;
   assign rxrdclkmux1_c0 = (use_parallel_feedback == "ON") | (use_channel_align == "ON") | (use_rate_match_fifo == "ON") ? 1'b1 : 1'b0;
      
   altgxb_hssi_mux4 rxrdclkmux2 
      (
       .Y(rx_rd_clk_mux),
       .I0(coreclk_in),
       .I1(1'b0),
       .I2(rxrdclk_mux1_by2),
       .I3(rxrdclk_mux1),
       .C0(rxrdclkmux2_c0),
       .C1(rxrdclkmux2_c1)
       );

   assign rxrdclkmux2_c1 = (send_reverse_parallel_feedback == "ON") ? 1'b1 : 1'b0;
   assign rxrdclkmux2_c0 = (use_double_data_mode == "OFF") && (send_reverse_parallel_feedback == "ON") ? 1'b1 : 1'b0;

   altgxb_hssi_divide_by_two rxrdclkmux_by2 
   (
    .reset(1'b0),
    .clkin(rxrdclk_mux1), 
    .clkout(rxrdclk_mux1_by2)
    );
   defparam rxrdclkmux_by2.divide = use_double_data_mode;
   
   // word_align inputs
   assign wa_datain = (use_parallel_feedback == "ON") ? parallelfdbk : serdes_dataout;
   assign wa_clk = rcvd_clk;
   assign wa_enacdet = enacdet_in; 
   assign wa_bitslip = bitslip_in; 
   assign wa_a1a2size = a1a2size_in; 
   
   // deskew FIFO inputs
   assign dsfifo_datain = (use_symbol_align == "ON") ? wa_aligneddata : idle_bus;     
   assign dsfifo_errdetectin = (use_symbol_align == "ON") ? wa_invalidcode : 1'b0;   
   assign dsfifo_syncstatusin = (use_symbol_align == "ON") ? wa_syncstatus : 1'b1;  
   assign dsfifo_disperrin = (use_symbol_align == "ON") ? wa_disperr : 1'b0; 
   assign dsfifo_patterndetectin = (use_symbol_align == "ON") ? wa_patterndetect : 1'b0; 
   assign dsfifo_writeclock = rcvd_clk;
   assign dsfifo_readclock = clk_1;
   assign dsfifo_fiforesetrd = fiforesetrd_in; 
   assign dsfifo_enabledeskew = enabledeskew_in;

// comp FIFO inputs
assign cmfifo_datain = (use_channel_align == "ON") ? dsfifo_dataout : ((use_symbol_align == "ON") ? wa_aligneddata : serdes_dataout);

assign cmfifo_datainpre = (use_channel_align == "ON") ? dsfifo_dataoutpre : ((use_symbol_align == "ON") ? wa_aligneddatapre : idle_bus);

assign cmfifo_invalidcodein = (use_channel_align == "ON") ? dsfifo_errdetect : ((use_symbol_align == "ON") ? wa_invalidcode : 1'b0);

assign cmfifo_syncstatusin = (use_channel_align == "ON") ? dsfifo_syncstatus : ((use_symbol_align == "ON") ? wa_syncstatus : 1'b1);

assign cmfifo_disperrin = (use_channel_align == "ON") ? dsfifo_disperr : ((use_symbol_align == "ON") ? wa_disperr : 1'b1);

assign cmfifo_patterndetectin = (use_channel_align == "ON") ? dsfifo_patterndetect : ((use_symbol_align == "ON") ? wa_patterndetect : 1'b1);

assign cmfifo_invalidcodeinpre = (use_channel_align == "ON") ? dsfifo_errdetectpre : ((use_symbol_align == "ON") ? wa_invalidcodepre : 1'b0);

assign cmfifo_syncstatusinpre = (use_channel_align == "ON") ? dsfifo_syncstatuspre : ((use_symbol_align == "ON") ? wa_syncstatusdeskew : 1'b1);

assign cmfifo_disperrinpre = (use_channel_align == "ON") ? dsfifo_disperrpre : ((use_symbol_align == "ON") ? wa_disperrpre : 1'b1);

assign cmfifo_patterndetectinpre = (use_channel_align == "ON") ? dsfifo_patterndetectpre : ((use_symbol_align == "ON") ? wa_patterndetectpre : 1'b1);

assign cmfifo_writeclk = clk_1;
assign cmfifo_readclk = clk_2;
assign cmfifo_alignstatus = alignstatus_in;
assign cmfifo_re = re_in;
assign cmfifo_we = we_in;
assign cmfifo_fifordin = fifordin_in;
assign cmfifo_disablefifordin = disablefifordin_in; 
assign cmfifo_disablefifowrin = disablefifowrin_in;

// 8B10B decoder inputs
assign decoder_clk = clk_2;
assign decoder_datain = (use_rate_match_fifo == "ON") ? cmfifo_dataout : (use_channel_align == "ON" ? dsfifo_dataout : (use_symbol_align == "ON" ? wa_aligneddata : serdes_dataout));   

assign decoder_errdetectin = (use_rate_match_fifo == "ON") ? cmfifo_invalidcode : (use_channel_align == "ON" ? dsfifo_errdetect : (use_symbol_align == "ON" ? wa_invalidcode : 1'b0));   

assign decoder_syncstatusin = (use_rate_match_fifo == "ON") ? cmfifo_syncstatus : (use_channel_align == "ON" ? dsfifo_syncstatus : (use_symbol_align == "ON" ? wa_syncstatus : 1'b1));   

assign decoder_disperrin = (use_rate_match_fifo == "ON") ? cmfifo_disperr : (use_channel_align == "ON" ? dsfifo_disperr : (use_symbol_align == "ON" ? wa_disperr : 1'b0));   

assign decoder_patterndetectin = (use_rate_match_fifo == "ON") ? cmfifo_patterndetect : (use_channel_align == "ON" ? dsfifo_patterndetect : (use_symbol_align == "ON" ? wa_patterndetect : 1'b0));   

assign decoder_indatavalid = (use_rate_match_fifo == "ON") ? cmfifo_datavalid : 1'b1;   

// rx_core inputs
assign core_datain          = (use_post8b10b_feedback == "ON") ? post8b10b : ((use_8b_10b_mode == "ON") ? {2'b00, decoder_dataout} : decoder_tenBdata);
assign core_writeclk        = clk_2;
assign core_readclk         = rx_rd_clk;
assign core_decdatavalid    = (use_8b_10b_mode == "ON") ? decoder_decdatavalid : 1'b1;
assign core_xgmdatain       = xgmdatain_in;
assign core_xgmctrlin       = xgmctrlin_in;
assign core_post8b10b       = post8b10b_in;
assign core_syncstatusin    = decoder_syncstatus;
assign core_errdetectin     = decoder_errdetect; 
assign core_ctrldetectin    = decoder_ctrldetect; 
assign core_disparityerrin  = decoder_disperr; 
assign core_patterndetectin = decoder_patterndetect; 

// sub modules
altgxb_hssi_rx_serdes s_rx_serdes   
  (
   .cruclk(cruclk), 
   .datain(datain), 
   .areset(analogreset_in), 
   .feedback(serialfdbk), 
   .fbkcntl(slpbk), 
   .ltr(locktorefclk),
   .ltd(locktodata),
   .clkout(serdes_clkout), 
   .dataout(serdes_dataout), 
   .rlv(serdes_rlv), 
   .lock(serdes_lock), 
   .freqlock(serdes_freqlock), 
   .signaldetect(serdes_signaldetect) 
   );
   defparam s_rx_serdes.channel_width = deserialization_factor;
   defparam s_rx_serdes.run_length_enable = run_length_enable;
   defparam s_rx_serdes.run_length = run_length; 
   defparam s_rx_serdes.cruclk_period = cruclk_period;
   defparam s_rx_serdes.cruclk_multiplier = cruclk_multiplier;
   defparam s_rx_serdes.use_cruclk_divider = use_cruclk_divider; 
   defparam s_rx_serdes.use_double_data_mode = use_double_data_mode; 

altgxb_hssi_word_aligner s_wordalign    (   
                                                    .datain(wa_datain), 
                                                    .clk(wa_clk), 
                                                    .softreset(reset_int), 
                                                    .enacdet(wa_enacdet), 
                                                    .bitslip(wa_bitslip), 
                                                    .a1a2size(wa_a1a2size), 
                                                    .aligneddata(wa_aligneddata), 
                                                    .aligneddatapre(wa_aligneddatapre), 
                                                    .invalidcode(wa_invalidcode), 
                                                    .invalidcodepre(wa_invalidcodepre), 
                                                    .syncstatus(wa_syncstatus), 
                                                    .syncstatusdeskew(wa_syncstatusdeskew), 
                                                    .disperr(wa_disperr), 
                                                    .disperrpre(wa_disperrpre), 
                                                    .patterndetect(wa_patterndetect),
                                                    .patterndetectpre(wa_patterndetectpre)
                                                    );
    defparam s_wordalign.channel_width = deserialization_factor;
    defparam s_wordalign.align_pattern_length = align_pattern_length;
    defparam s_wordalign.infiniband_invalid_code = infiniband_invalid_code;
    defparam s_wordalign.align_pattern = align_pattern;
    defparam s_wordalign.synchronization_mode = synchronization_mode;
    defparam s_wordalign.use_auto_bit_slip = use_auto_bit_slip; 

altgxb_deskew_fifo s_dsfifo (
                                        .datain(dsfifo_datain),
                                        .errdetectin(dsfifo_errdetectin),
                                        .syncstatusin(dsfifo_syncstatusin),
                                        .disperrin(dsfifo_disperrin),   
                                        .patterndetectin(dsfifo_patterndetectin),
                                        .writeclock(dsfifo_writeclock),  
                                        .readclock(dsfifo_readclock),   
                                        .adetectdeskew(dsfifo_adetectdeskew),
                                        .fiforesetrd(dsfifo_fiforesetrd),
                                        .enabledeskew(dsfifo_enabledeskew),
                                        .reset(reset_int),
                                        .dataout(dsfifo_dataout),   
                                        .dataoutpre(dsfifo_dataoutpre),   
                                        .errdetect(dsfifo_errdetect),    
                                        .syncstatus(dsfifo_syncstatus),
                                        .disperr(dsfifo_disperr),
                                        .errdetectpre(dsfifo_errdetectpre),    
                                        .syncstatuspre(dsfifo_syncstatuspre),
                                        .disperrpre(dsfifo_disperrpre),
                                        .patterndetect(dsfifo_patterndetect),
                                        .patterndetectpre(dsfifo_patterndetectpre),
                                        .rdalign(dsfifo_rdalign)
                                        );

altgxb_comp_fifo s_cmfifo   
   (
    .datain(cmfifo_datain),
    .datainpre(cmfifo_datainpre),
    .reset(reset_int),
    .errdetectin(cmfifo_invalidcodein), 
    .syncstatusin(cmfifo_syncstatusin),
    .disperrin(cmfifo_disperrin),
    .patterndetectin(cmfifo_patterndetectin),
    .errdetectinpre(cmfifo_invalidcodeinpre), 
    .syncstatusinpre(cmfifo_syncstatusinpre),
    .disperrinpre(cmfifo_disperrinpre),
    .patterndetectinpre(cmfifo_patterndetectinpre),
    .writeclk(cmfifo_writeclk),
    .readclk(cmfifo_readclk),
    .re(cmfifo_re),
    .we(cmfifo_we),
    .fifordin(cmfifo_fifordin),
    .disablefifordin(cmfifo_disablefifordin),
    .disablefifowrin(cmfifo_disablefifowrin),
    .alignstatus(cmfifo_alignstatus),
    .dataout(cmfifo_dataout),
    .errdetectout(cmfifo_invalidcode),
    .syncstatus(cmfifo_syncstatus),
    .disperr(cmfifo_disperr),
    .patterndetect(cmfifo_patterndetect),
    .codevalid(cmfifo_datavalid),
    .fifofull(cmfifo_fifofull),
    .fifoalmostful(cmfifo_fifoalmostfull),
    .fifoempty(cmfifo_fifoempty),
    .fifoalmostempty(cmfifo_fifoalmostempty),
    .disablefifordout(cmfifo_disablefifordout),
    .disablefifowrout(cmfifo_disablefifowrout),
    .fifordout(cmfifo_fifordout)
    );
   defparam      s_cmfifo.use_rate_match_fifo = use_rate_match_fifo;
   defparam      s_cmfifo.rate_matching_fifo_mode = rate_matching_fifo_mode;
   defparam      s_cmfifo.use_channel_align = use_channel_align;
   defparam      s_cmfifo.channel_num = channel_num;
   defparam      s_cmfifo.for_engineering_sample_device = for_engineering_sample_device; // new in 3.0 sp2 
      
altgxb_8b10b_decoder    s_decoder   
  (
   .clk(decoder_clk), 
   .reset(reset_int),  
   .errdetectin(decoder_errdetectin), 
   .syncstatusin(decoder_syncstatusin), 
   .disperrin(decoder_disperrin),
   .patterndetectin(decoder_patterndetectin),
   .datainvalid(decoder_indatavalid), 
   .datain(decoder_datain), 
   .valid(decoder_valid), 
   .dataout(decoder_dataout), 
   .tenBdata(decoder_tenBdata),
   .errdetect(decoder_errdetect),
   .rderr(decoder_rderr),
   .syncstatus(decoder_syncstatus),
   .disperr(decoder_disperr),
   .patterndetect(decoder_patterndetect),
   .kout(decoder_ctrldetect),
   .decdatavalid(decoder_decdatavalid),
   .xgmdatavalid(decoder_xgmdatavalid),
   .xgmrunningdisp(decoder_xgmrunningdisp),
   .xgmctrldet(decoder_xgmctrldet),
   .xgmdataout(decoder_xgmdataout)
   );
      
altgxb_rx_core s_rx_core    
   (
    .reset(reset_int),
    .datain(core_datain),
    .writeclk(core_writeclk),
    .readclk(core_readclk),
    .decdatavalid(core_decdatavalid),
    .xgmdatain(core_xgmdatain),
    .xgmctrlin(core_xgmctrlin),
    .post8b10b(core_post8b10b),
    .syncstatusin(core_syncstatusin),
    .errdetectin(core_errdetectin),
    .ctrldetectin(core_ctrldetectin),
    .disparityerrin(core_disparityerrin),
    .patterndetectin(core_patterndetectin),
    .dataout(core_dataout),
    .a1a2sizeout(core_a1a2sizeout),
    .syncstatus(core_syncstatus),
    .errdetect(core_errdetect),
    .ctrldetect(core_ctrldetect),
    .disparityerr(core_disparityerr),
    .patterndetect(core_patterndetect),
    .clkout(core_clkout)
    );
   defparam s_rx_core.channel_width        = deserialization_factor;
   defparam s_rx_core.use_double_data_mode = use_double_data_mode;
   defparam s_rx_core.use_channel_align    = use_channel_align;
   defparam s_rx_core.use_8b_10b_mode      = use_8b_10b_mode;
   defparam s_rx_core.synchronization_mode = synchronization_mode;
   defparam s_rx_core.align_pattern        = align_pattern;

// - added gfifo
altgxb_hssi_divide_by_two s_rx_clkout_mux   
(
   .reset(reset_int),
   .clkin(rxrdclk_mux1), 
   .clkout(clkoutmux_clkout_pre)
);
defparam s_rx_clkout_mux.divide = use_double_data_mode;

// gererate output signals

// outputs from serdes
and (recovclkout, 1'b1, serdes_clkout);
and (rlv, 1'b1, serdes_rlv);
and (lock, serdes_lock, 1'b1);
and (freqlock, serdes_freqlock, 1'b1);
and (signaldetect, serdes_signaldetect, 1'b1);

// outputs from word_aligner
and (syncstatusdeskew, wa_syncstatusdeskew, 1'b1);

// outputs from deskew FIFO
and (adetectdeskew, dsfifo_adetectdeskew, 1'b1);
and (rdalign, dsfifo_rdalign, 1'b1);

// outputs from comp FIFO
and (fifofull, cmfifo_fifofull, 1'b1);
and (fifoalmostfull, cmfifo_fifoalmostfull, 1'b1);
and (fifoempty, cmfifo_fifoempty, 1'b1);
and (fifoalmostempty, cmfifo_fifoalmostempty, 1'b1);
and (fifordout, cmfifo_fifordout, 1'b1);
and (disablefifordout, cmfifo_disablefifordout, 1'b1);
and (disablefifowrout, cmfifo_disablefifowrout, 1'b1);

// outputs from decoder 
and (xgmctrldet, decoder_xgmctrldet, 1'b1);
and (xgmrunningdisp, decoder_xgmrunningdisp, 1'b1);
and (xgmdatavalid, decoder_xgmdatavalid, 1'b1);

buf (xgmdataout[0], decoder_xgmdataout[0]);
buf (xgmdataout[1], decoder_xgmdataout[1]);
buf (xgmdataout[2], decoder_xgmdataout[2]);
buf (xgmdataout[3], decoder_xgmdataout[3]);
buf (xgmdataout[4], decoder_xgmdataout[4]);
buf (xgmdataout[5], decoder_xgmdataout[5]);
buf (xgmdataout[6], decoder_xgmdataout[6]);
buf (xgmdataout[7], decoder_xgmdataout[7]);

// outputs from rx_core
and (syncstatus[0], core_syncstatus[0], 1'b1);
and (syncstatus[1], core_syncstatus[1], 1'b1);

and (patterndetect[0], core_patterndetect[0], 1'b1);
and (patterndetect[1], core_patterndetect[1], 1'b1);

and (ctrldetect[0], core_ctrldetect[0], 1'b1);
and (ctrldetect[1], core_ctrldetect[1], 1'b1);

and (errdetect[0], core_errdetect[0], 1'b1);
and (errdetect[1], core_errdetect[1], 1'b1);

and (disperr[0], core_disparityerr[0], 1'b1);
and (disperr[1], core_disparityerr[1], 1'b1);

and (a1a2sizeout[0], core_a1a2sizeout[0], 1'b1);
and (a1a2sizeout[1], core_a1a2sizeout[1], 1'b1);

assign dataout_tmp = core_dataout;

buf (dataout[0], dataout_tmp[0]);
buf (dataout[1], dataout_tmp[1]);
buf (dataout[2], dataout_tmp[2]);
buf (dataout[3], dataout_tmp[3]);
buf (dataout[4], dataout_tmp[4]);
buf (dataout[5], dataout_tmp[5]);
buf (dataout[6], dataout_tmp[6]);
buf (dataout[7], dataout_tmp[7]);
buf (dataout[8], dataout_tmp[8]);
buf (dataout[9], dataout_tmp[9]);
buf (dataout[10], dataout_tmp[10]);
buf (dataout[11], dataout_tmp[11]);
buf (dataout[12], dataout_tmp[12]);
buf (dataout[13], dataout_tmp[13]);
buf (dataout[14], dataout_tmp[14]);
buf (dataout[15], dataout_tmp[15]);
buf (dataout[16], dataout_tmp[16]);
buf (dataout[17], dataout_tmp[17]);
buf (dataout[18], dataout_tmp[18]);
buf (dataout[19], dataout_tmp[19]);

// output from clkout mux
// - added gfifo
assign clkoutmux_clkout = ((use_parallel_feedback == "OFF") && clk_out_mode_reference == "OFF") ? serdes_clkout : clkoutmux_clkout_pre;
and (clkout, 1'b1, clkoutmux_clkout);

endmodule




