
-- package for Boolean vector
--

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.VITAL_Timing.all;
use IEEE.VITAL_Primitives.all;

package hssi_pack is

   TYPE boolean_vec IS ARRAY (0 to 3) of BOOLEAN;

-- default generic values
   CONSTANT DefWireDelay        : VitalDelayType01      := (0 ns, 0 ns);
   CONSTANT DefPropDelay01      : VitalDelayType01      := (0 ns, 0 ns);
   CONSTANT DefPropDelay01Z     : VitalDelayType01Z     := (OTHERS => 0 ns);
   CONSTANT DefSetupHoldCnst    : TIME := 0 ns;
   CONSTANT DefPulseWdthCnst    : TIME := 0 ns;
-- default control options
--   CONSTANT DefGlitchMode       : VitalGlitchKindType   := OnEvent;
-- change default delay type to Transport : for spr 68748
   CONSTANT DefGlitchMode       : VitalGlitchKindType   := VitalTransport;
   CONSTANT DefGlitchMsgOn      : BOOLEAN       := FALSE;
   CONSTANT DefGlitchXOn        : BOOLEAN       := FALSE;
   CONSTANT DefMsgOnChecks      : BOOLEAN       := TRUE;
   CONSTANT DefXOnChecks        : BOOLEAN       := TRUE;
-- output strength mapping
                                                --  UX01ZWHL-
   CONSTANT PullUp      : VitalOutputMapType    := "UX01HX01X";
   CONSTANT NoPullUpZ   : VitalOutputMapType    := "UX01ZX01X";
   CONSTANT PullDown    : VitalOutputMapType    := "UX01LX01X";
-- primitive result strength mapping
   CONSTANT wiredOR     : VitalResultMapType    := ( 'U', 'X', 'L', '1' );
   CONSTANT wiredAND    : VitalResultMapType    := ( 'U', 'X', '0', 'H' );
   CONSTANT L : VitalTableSymbolType := '0';
   CONSTANT H : VitalTableSymbolType := '1';
   CONSTANT x : VitalTableSymbolType := '-';
   CONSTANT S : VitalTableSymbolType := 'S';
   CONSTANT R : VitalTableSymbolType := '/';
   CONSTANT U : VitalTableSymbolType := 'X';
   CONSTANT V : VitalTableSymbolType := 'B'; -- valid clock signal (non-rising)

	-- function to convert align_pattern to binary
	function pattern_conversion (align_pattern : string) return std_logic_vector;
 
end hssi_pack;

library IEEE;
use IEEE.std_logic_1164.all;

package body hssi_pack is
	function pattern_conversion 
		( 	
			align_pattern			: string
		)
		return std_logic_vector is
		variable i : integer;
		variable j : integer := 15;
		variable bin_pat : std_logic_vector(15 downto 0) := (OTHERS => '0');
	begin

		for i in 1 to align_pattern'length loop
			case align_pattern(i) is
				when '0' => bin_pat(j) := '0';
				when '1' => bin_pat(j) := '1';
				when others => bin_pat(j) := '0';
			end case;
			j := j - 1;
		end loop;

		return (bin_pat);

	end pattern_conversion;

end hssi_pack;

--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

--synthesis_resources = lut 97 mux21 43 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixgx_8b10b_decoder IS 
	 PORT 
	 ( 
		 clk	:	IN  STD_LOGIC;
		 datain	:	IN  STD_LOGIC_VECTOR (9 DOWNTO 0);
		 datainvalid	:	IN  STD_LOGIC;
		 dataout	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 decdatavalid	:	OUT  STD_LOGIC;
		 disperr	:	OUT  STD_LOGIC;
		 disperrin	:	IN  STD_LOGIC;
		 errdetect	:	OUT  STD_LOGIC;
		 errdetectin	:	IN  STD_LOGIC;
		 kout	:	OUT  STD_LOGIC;
		 patterndetect	:	OUT  STD_LOGIC;
		 patterndetectin	:	IN  STD_LOGIC;
		 rderr	:	OUT  STD_LOGIC;
		 reset	:	IN  STD_LOGIC;
		 syncstatus	:	OUT  STD_LOGIC;
		 syncstatusin	:	IN  STD_LOGIC;
		 tenBdata	:	OUT  STD_LOGIC_VECTOR (9 DOWNTO 0);
		 valid	:	OUT  STD_LOGIC;
		 xgmctrldet	:	OUT  STD_LOGIC;
		 xgmdataout	:	OUT  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 xgmdatavalid	:	OUT  STD_LOGIC;
		 xgmrunningdisp	:	OUT  STD_LOGIC
	 ); 
 END stratixgx_8b10b_decoder;

 ARCHITECTURE RTL OF stratixgx_8b10b_decoder IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 n0l0i55	:	STD_LOGIC := '1';
	 SIGNAL	 n0l0i56	:	STD_LOGIC := '1';
	 SIGNAL	 n0l0i57	:	STD_LOGIC := '0';
	 SIGNAL	 n0l1l58	:	STD_LOGIC := '1';
	 SIGNAL	 n0l1l59	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0l1l59_w_lg_Q164w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0l1l60	:	STD_LOGIC := '0';
	 SIGNAL	 n0lii52	:	STD_LOGIC := '1';
	 SIGNAL	 n0lii53	:	STD_LOGIC := '1';
	 SIGNAL	 n0lii54	:	STD_LOGIC := '0';
	 SIGNAL	 n0liO49	:	STD_LOGIC := '1';
	 SIGNAL	 n0liO50	:	STD_LOGIC := '1';
	 SIGNAL	 n0liO51	:	STD_LOGIC := '0';
	 SIGNAL	 n0lll46	:	STD_LOGIC := '1';
	 SIGNAL	 n0lll47	:	STD_LOGIC := '1';
	 SIGNAL	 n0lll48	:	STD_LOGIC := '0';
	 SIGNAL	 n0lOi43	:	STD_LOGIC := '1';
	 SIGNAL	 n0lOi44	:	STD_LOGIC := '1';
	 SIGNAL	 n0lOi45	:	STD_LOGIC := '0';
	 SIGNAL	 n0lOO40	:	STD_LOGIC := '1';
	 SIGNAL	 n0lOO41	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0lOO41_w_lg_Q134w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0lOO42	:	STD_LOGIC := '0';
	 SIGNAL	 n0O0i34	:	STD_LOGIC := '1';
	 SIGNAL	 n0O0i35	:	STD_LOGIC := '1';
	 SIGNAL	 n0O0i36	:	STD_LOGIC := '0';
	 SIGNAL	 n0O1l37	:	STD_LOGIC := '1';
	 SIGNAL	 n0O1l38	:	STD_LOGIC := '1';
	 SIGNAL	 n0O1l39	:	STD_LOGIC := '0';
	 SIGNAL	 n0Oii31	:	STD_LOGIC := '1';
	 SIGNAL	 n0Oii32	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0Oii32_w_lg_Q118w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0Oii33	:	STD_LOGIC := '0';
	 SIGNAL	 n0Oli28	:	STD_LOGIC := '1';
	 SIGNAL	 n0Oli29	:	STD_LOGIC := '1';
	 SIGNAL	 n0Oli30	:	STD_LOGIC := '0';
	 SIGNAL	 n0OlO25	:	STD_LOGIC := '1';
	 SIGNAL	 n0OlO26	:	STD_LOGIC := '1';
	 SIGNAL	 n0OlO27	:	STD_LOGIC := '0';
	 SIGNAL	 n0OOO22	:	STD_LOGIC := '1';
	 SIGNAL	 n0OOO23	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0OOO23_w_lg_Q100w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0OOO24	:	STD_LOGIC := '0';
	 SIGNAL	 ni00O1	:	STD_LOGIC := '1';
	 SIGNAL	 ni00O2	:	STD_LOGIC := '1';
	 SIGNAL  wire_ni00O2_w_lg_Q47w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 ni00O3	:	STD_LOGIC := '0';
	 SIGNAL	 ni10l16	:	STD_LOGIC := '1';
	 SIGNAL	 ni10l17	:	STD_LOGIC := '1';
	 SIGNAL	 ni10l18	:	STD_LOGIC := '0';
	 SIGNAL	 ni11O19	:	STD_LOGIC := '1';
	 SIGNAL	 ni11O20	:	STD_LOGIC := '1';
	 SIGNAL	 ni11O21	:	STD_LOGIC := '0';
	 SIGNAL	 ni1ii13	:	STD_LOGIC := '1';
	 SIGNAL	 ni1ii14	:	STD_LOGIC := '1';
	 SIGNAL	 ni1ii15	:	STD_LOGIC := '0';
	 SIGNAL	 ni1iO10	:	STD_LOGIC := '1';
	 SIGNAL	 ni1iO11	:	STD_LOGIC := '1';
	 SIGNAL	 ni1iO12	:	STD_LOGIC := '0';
	 SIGNAL	 ni1ll7	:	STD_LOGIC := '1';
	 SIGNAL	 ni1ll8	:	STD_LOGIC := '1';
	 SIGNAL	 ni1ll9	:	STD_LOGIC := '0';
	 SIGNAL	 ni1Oi4	:	STD_LOGIC := '1';
	 SIGNAL	 ni1Oi5	:	STD_LOGIC := '1';
	 SIGNAL	 ni1Oi6	:	STD_LOGIC := '0';
	 SIGNAL	niii	:	STD_LOGIC := '0';
	 SIGNAL	niil	:	STD_LOGIC := '0';
	 SIGNAL	niiO	:	STD_LOGIC := '0';
	 SIGNAL	nili	:	STD_LOGIC := '0';
	 SIGNAL	nill	:	STD_LOGIC := '0';
	 SIGNAL	nilO	:	STD_LOGIC := '0';
	 SIGNAL	niOi	:	STD_LOGIC := '0';
	 SIGNAL	niOO	:	STD_LOGIC := '0';
	 SIGNAL	n0i	:	STD_LOGIC := '0';
	 SIGNAL	n0l	:	STD_LOGIC := '0';
	 SIGNAL	n0O	:	STD_LOGIC := '0';
	 SIGNAL	n1i	:	STD_LOGIC := '0';
	 SIGNAL	n1l	:	STD_LOGIC := '0';
	 SIGNAL	n1O	:	STD_LOGIC := '0';
	 SIGNAL	ni	:	STD_LOGIC := '0';
	 SIGNAL	nii	:	STD_LOGIC := '0';
	 SIGNAL	nil	:	STD_LOGIC := '0';
	 SIGNAL	niO	:	STD_LOGIC := '0';
	 SIGNAL	nl0i	:	STD_LOGIC := '0';
	 SIGNAL	nl0l	:	STD_LOGIC := '0';
	 SIGNAL	nl0O	:	STD_LOGIC := '0';
	 SIGNAL	nl1i	:	STD_LOGIC := '0';
	 SIGNAL	nl1l	:	STD_LOGIC := '0';
	 SIGNAL	nl1O	:	STD_LOGIC := '0';
	 SIGNAL	nli	:	STD_LOGIC := '0';
	 SIGNAL	nlii	:	STD_LOGIC := '0';
	 SIGNAL	nlil	:	STD_LOGIC := '0';
	 SIGNAL	nliO	:	STD_LOGIC := '0';
	 SIGNAL	nll	:	STD_LOGIC := '0';
	 SIGNAL	nlli	:	STD_LOGIC := '0';
	 SIGNAL	nlll	:	STD_LOGIC := '0';
	 SIGNAL	nllO	:	STD_LOGIC := '0';
	 SIGNAL	nlO	:	STD_LOGIC := '0';
	 SIGNAL	nlOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOO	:	STD_LOGIC := '0';
	 SIGNAL	nO	:	STD_LOGIC := '0';
	 SIGNAL	wire_niO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli0i_w_lg_w_lg_w_lg_dataout88w108w111w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0i_w_lg_w_lg_w_lg_dataout88w90w93w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0i_w_lg_w_lg_w_lg_dataout88w136w139w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0i_w_lg_w_lg_w_lg_dataout88w126w129w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0i_w_lg_w_lg_dataout120w123w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0i_w_lg_w_lg_dataout88w108w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0i_w_lg_w_lg_dataout88w90w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0i_w_lg_w_lg_dataout88w183w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0i_w_lg_w_lg_dataout88w136w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0i_w_lg_w_lg_dataout88w126w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0i_w_lg_dataout148w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0i_w_lg_dataout120w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0i_w_lg_dataout88w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0i_w_lg_dataout161w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nli0l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli0l_w_lg_dataout73w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nli0O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli0O_w_lg_w_lg_w_lg_dataout72w74w147w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0O_w_lg_w_lg_dataout89w107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0O_w_lg_w_lg_dataout72w74w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0O_w_lg_w_lg_dataout72w174w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0O_w_lg_dataout173w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0O_w_lg_dataout89w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0O_w_lg_dataout72w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli0O_w_lg_dataout160w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nli1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli1l_w_lg_w_lg_dataout155w158w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1l_w_lg_dataout155w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1l_w_lg_dataout104w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nli1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nli1O_w_lg_w_lg_dataout140w143w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1O_w_lg_w_lg_dataout149w152w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1O_w_lg_dataout140w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1O_w_lg_dataout130w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1O_w_lg_dataout184w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1O_w_lg_dataout149w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nli1O_w_lg_dataout87w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllli_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nllli_w_lg_dataout59w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nllll_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nllll_w_lg_dataout64w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nlllO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlllO_w_lg_w_lg_dataout57w58w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlllO_w_lg_dataout65w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlllO_w_lg_dataout57w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0iOl171w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_ni00l51w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_reset1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  n0iOi :	STD_LOGIC;
	 SIGNAL  n0iOl :	STD_LOGIC;
	 SIGNAL  n0iOO :	STD_LOGIC;
	 SIGNAL  n0l0O :	STD_LOGIC;
	 SIGNAL  n0l1i :	STD_LOGIC;
	 SIGNAL  n0O0O :	STD_LOGIC;
	 SIGNAL  n0OiO :	STD_LOGIC;
	 SIGNAL  n0OOl :	STD_LOGIC;
	 SIGNAL  ni00i :	STD_LOGIC;
	 SIGNAL  ni00l :	STD_LOGIC;
	 SIGNAL  ni01i :	STD_LOGIC;
	 SIGNAL  ni01l :	STD_LOGIC;
	 SIGNAL  ni01O :	STD_LOGIC;
	 SIGNAL  ni0iO :	STD_LOGIC;
	 SIGNAL  ni0li :	STD_LOGIC;
	 SIGNAL  ni11l :	STD_LOGIC;
	 SIGNAL  ni1OO :	STD_LOGIC;
 BEGIN

	wire_w_lg_n0iOl171w(0) <= NOT n0iOl;
	wire_w_lg_ni00l51w(0) <= NOT ni00l;
	wire_w_lg_reset1w(0) <= NOT reset;
	dataout <= ( nl1i & nO & ni & nlO & nll & niOO & niOi & nilO);
	decdatavalid <= nlOl;
	disperr <= nlOO;
	errdetect <= n0i;
	kout <= niil;
	n0iOi <= wire_nli0O_w_lg_w_lg_dataout72w74w(0);
	n0iOl <= (wire_nli0i_dataout AND wire_nli0l_dataout);
	n0iOO <= (wire_nli0i_w_lg_dataout88w(0) AND wire_nli0l_w_lg_dataout73w(0));
	n0l0O <= ((((wire_nli1O_w_lg_dataout87w(0) AND (wire_nli0i_w_lg_dataout88w(0) AND wire_nli0O_w_lg_dataout173w(0))) OR (wire_nli1O_w_lg_dataout87w(0) AND (wire_nli0i_w_lg_dataout88w(0) AND wire_nli0O_w_lg_w_lg_dataout72w174w(0)))) OR (wire_nli1O_w_lg_dataout87w(0) AND (wire_nli0i_dataout AND n0iOi))) OR wire_nli1O_w_lg_dataout184w(0));
	n0l1i <= (((wire_nli1l_w_lg_dataout104w(0) AND ((((((((wire_nli1O_w_lg_dataout87w(0) AND wire_nli0i_w_lg_w_lg_w_lg_dataout88w108w111w(0)) OR (wire_nli1O_w_lg_dataout87w(0) AND (wire_nli0i_dataout AND n0OiO))) OR wire_n0Oii32_w_lg_Q118w(0)) OR (wire_nli1O_w_lg_dataout87w(0) AND wire_nli0i_w_lg_w_lg_dataout120w123w(0))) OR wire_nli1O_w_lg_dataout130w(0)) OR wire_n0lOO41_w_lg_Q134w(0)) OR wire_nli1O_w_lg_w_lg_dataout140w143w(0)) OR wire_nli1O_w_lg_w_lg_dataout149w152w(0))) OR wire_nli1l_w_lg_w_lg_dataout155w158w(0)) AND (wire_nli0i_w_lg_dataout161w(0) OR wire_n0l1l59_w_lg_Q164w(0)));
	n0O0O <= wire_nli0O_w_lg_w_lg_dataout72w174w(0);
	n0OiO <= wire_nli0O_w_lg_dataout173w(0);
	n0OOl <= (wire_nli1l_dataout AND ((wire_nli0O_dataout XOR wire_nli0l_dataout) AND ((wire_nli1O_dataout XOR wire_nli0i_dataout) XOR wire_n0OOO23_w_lg_Q100w(0))));
	ni00i <= ((wire_nli1l_dataout AND ((wire_nli1O_dataout AND ((wire_nli0i_dataout AND wire_nli0O_w_lg_w_lg_dataout72w74w(0)) AND ni1iO11)) AND ni1ii14)) AND ni10l17);
	ni00l <= ((datain(6) XOR datain(7)) XOR wire_ni00O2_w_lg_Q47w(0));
	ni01i <= ((wire_nlllO_w_lg_w_lg_dataout57w58w(0) AND wire_nllli_w_lg_dataout59w(0)) AND ni1ll8);
	ni01l <= (wire_nlllO_w_lg_dataout65w(0) AND wire_nllli_w_lg_dataout59w(0));
	ni01O <= ((NOT datain(5)) AND ni00i);
	ni0iO <= (ni00i OR ((ni1OO AND ni01l) AND ni1Oi5));
	ni0li <= '1';
	ni11l <= (wire_nli1l_dataout AND (wire_nli1O_w_lg_dataout87w(0) AND wire_nli0i_w_lg_w_lg_w_lg_dataout88w90w93w(0)));
	ni1OO <= (wire_nli1l_w_lg_dataout104w(0) AND n0l0O);
	patterndetect <= n1i;
	rderr <= n1O;
	syncstatus <= n1l;
	tenBdata <= ( nlll & nlli & nliO & nlil & nlii & nl0O & nl0l & nl0i & nl1O & nl1l);
	valid <= n0l;
	xgmctrldet <= niii;
	xgmdataout <= ( nli & niO & nil & nii & n0O & nill & nili & niiO);
	xgmdatavalid <= nlOi;
	xgmrunningdisp <= nllO;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0l0i55 <= n0l0i57;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0l0i56 <= (n0l0i57 XOR n0l0i55);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0l0i57 <= n0l0i55;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0l1l58 <= n0l1l60;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0l1l59 <= (n0l1l60 XOR n0l1l58);
		END IF;
	END PROCESS;
	wire_n0l1l59_w_lg_Q164w(0) <= NOT n0l1l59;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0l1l60 <= n0l1l58;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0lii52 <= n0lii54;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0lii53 <= (n0lii54 XOR n0lii52);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0lii54 <= n0lii52;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0liO49 <= n0liO51;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0liO50 <= (n0liO51 XOR n0liO49);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0liO51 <= n0liO49;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0lll46 <= n0lll48;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0lll47 <= (n0lll48 XOR n0lll46);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0lll48 <= n0lll46;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0lOi43 <= n0lOi45;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0lOi44 <= (n0lOi45 XOR n0lOi43);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0lOi45 <= n0lOi43;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0lOO40 <= n0lOO42;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0lOO41 <= (n0lOO42 XOR n0lOO40);
		END IF;
	END PROCESS;
	wire_n0lOO41_w_lg_Q134w(0) <= NOT n0lOO41;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0lOO42 <= n0lOO40;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0O0i34 <= n0O0i36;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0O0i35 <= (n0O0i36 XOR n0O0i34);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0O0i36 <= n0O0i34;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0O1l37 <= n0O1l39;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0O1l38 <= (n0O1l39 XOR n0O1l37);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0O1l39 <= n0O1l37;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0Oii31 <= n0Oii33;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0Oii32 <= (n0Oii33 XOR n0Oii31);
		END IF;
	END PROCESS;
	wire_n0Oii32_w_lg_Q118w(0) <= NOT n0Oii32;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0Oii33 <= n0Oii31;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0Oli28 <= n0Oli30;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0Oli29 <= (n0Oli30 XOR n0Oli28);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0Oli30 <= n0Oli28;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0OlO25 <= n0OlO27;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0OlO26 <= (n0OlO27 XOR n0OlO25);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0OlO27 <= n0OlO25;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0OOO22 <= n0OOO24;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0OOO23 <= (n0OOO24 XOR n0OOO22);
		END IF;
	END PROCESS;
	wire_n0OOO23_w_lg_Q100w(0) <= NOT n0OOO23;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN n0OOO24 <= n0OOO22;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni00O1 <= ni00O3;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni00O2 <= (ni00O3 XOR ni00O1);
		END IF;
	END PROCESS;
	wire_ni00O2_w_lg_Q47w(0) <= NOT ni00O2;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni00O3 <= ni00O1;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni10l16 <= ni10l18;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni10l17 <= (ni10l18 XOR ni10l16);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni10l18 <= ni10l16;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni11O19 <= ni11O21;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni11O20 <= (ni11O21 XOR ni11O19);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni11O21 <= ni11O19;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni1ii13 <= ni1ii15;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni1ii14 <= (ni1ii15 XOR ni1ii13);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni1ii15 <= ni1ii13;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni1iO10 <= ni1iO12;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni1iO11 <= (ni1iO12 XOR ni1iO10);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni1iO12 <= ni1iO10;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni1ll7 <= ni1ll9;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni1ll8 <= (ni1ll9 XOR ni1ll7);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni1ll9 <= ni1ll7;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni1Oi4 <= ni1Oi6;
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni1Oi5 <= (ni1Oi6 XOR ni1Oi4);
		END IF;
	END PROCESS;
	PROCESS (clk)
	BEGIN
		IF (clk = '1' AND clk'event) THEN ni1Oi6 <= ni1Oi4;
		END IF;
	END PROCESS;
	PROCESS (clk, reset)
	BEGIN
		IF (reset = '1') THEN
				niii <= '1';
				niil <= '1';
				niiO <= '1';
				nili <= '1';
				nill <= '1';
				nilO <= '1';
				niOi <= '1';
				niOO <= '1';
		ELSIF (clk = '1' AND clk'event) THEN
				niii <= ni0iO;
				niil <= ni0iO;
				niiO <= wire_niO0O_dataout;
				nili <= wire_niO0l_dataout;
				nill <= wire_niO0i_dataout;
				nilO <= wire_niO0O_dataout;
				niOi <= wire_niO0l_dataout;
				niOO <= wire_niO0i_dataout;
		END IF;
	END PROCESS;
	PROCESS (clk, reset)
	BEGIN
		IF (reset = '1') THEN
				n0i <= '0';
				n0l <= '0';
				n0O <= '0';
				n1i <= '0';
				n1l <= '0';
				n1O <= '0';
				ni <= '0';
				nii <= '0';
				nil <= '0';
				niO <= '0';
				nl0i <= '0';
				nl0l <= '0';
				nl0O <= '0';
				nl1i <= '0';
				nl1l <= '0';
				nl1O <= '0';
				nli <= '0';
				nlii <= '0';
				nlil <= '0';
				nliO <= '0';
				nll <= '0';
				nlli <= '0';
				nlll <= '0';
				nllO <= '0';
				nlO <= '0';
				nlOi <= '0';
				nlOl <= '0';
				nlOO <= '0';
				nO <= '0';
		ELSIF (clk = '1' AND clk'event) THEN
				n0i <= errdetectin;
				n0l <= datainvalid;
				n0O <= wire_niO1O_dataout;
				n1i <= patterndetectin;
				n1l <= syncstatusin;
				n1O <= disperrin;
				ni <= wire_nliOi_dataout;
				nii <= wire_niO1l_dataout;
				nil <= wire_nliOi_dataout;
				niO <= wire_nlilO_dataout;
				nl0i <= datain(2);
				nl0l <= datain(3);
				nl0O <= datain(4);
				nl1i <= wire_nlill_dataout;
				nl1l <= datain(0);
				nl1O <= datain(1);
				nli <= wire_nlill_dataout;
				nlii <= datain(5);
				nlil <= datain(6);
				nliO <= datain(7);
				nll <= wire_niO1O_dataout;
				nlli <= datain(8);
				nlll <= datain(9);
				nllO <= disperrin;
				nlO <= wire_niO1l_dataout;
				nlOi <= datainvalid;
				nlOl <= datainvalid;
				nlOO <= disperrin;
				nO <= wire_nlilO_dataout;
		END IF;
	END PROCESS;
	wire_niO0i_dataout <= wire_niOiO_dataout OR ni00i;
	wire_niO0l_dataout <= wire_niOli_dataout AND NOT(ni00i);
	wire_niO0O_dataout <= wire_niOll_dataout AND NOT(ni00i);
	wire_niO1l_dataout <= wire_niOii_dataout OR ni00i;
	wire_niO1O_dataout <= wire_niOil_dataout OR ni00i;
	wire_niOii_dataout <= wire_niOlO_dataout OR ni11l;
	wire_niOil_dataout <= wire_niOOi_dataout OR ni11l;
	wire_niOiO_dataout <= wire_niOOl_dataout AND NOT(ni11l);
	wire_niOli_dataout <= wire_niOOO_dataout AND NOT(ni11l);
	wire_niOll_dataout <= wire_nl11i_dataout AND NOT(ni11l);
	wire_niOlO_dataout <= wire_nl1il_dataout WHEN n0OOl = '1'  ELSE wire_nl11l_dataout;
	wire_niOOi_dataout <= wire_nl1iO_dataout WHEN n0OOl = '1'  ELSE wire_nl11O_dataout;
	wire_niOOl_dataout <= wire_nl1iO_dataout WHEN n0OOl = '1'  ELSE wire_nl10i_dataout;
	wire_niOOO_dataout <= wire_nl1iO_dataout WHEN n0OOl = '1'  ELSE wire_nl10l_dataout;
	wire_nl10i_dataout <= datain(2) WHEN n0l1i = '1'  ELSE wire_nli0i_w_lg_dataout88w(0);
	wire_nl10l_dataout <= datain(1) WHEN n0l1i = '1'  ELSE wire_nli0l_w_lg_dataout73w(0);
	wire_nl10O_dataout <= datain(0) WHEN n0l1i = '1'  ELSE wire_nli0O_w_lg_dataout72w(0);
	wire_nl11i_dataout <= wire_nl1iO_dataout WHEN n0OOl = '1'  ELSE wire_nl10O_dataout;
	wire_nl11l_dataout <= datain(4) WHEN n0l1i = '1'  ELSE ni1OO;
	wire_nl11O_dataout <= datain(3) WHEN n0l1i = '1'  ELSE wire_nli1O_w_lg_dataout87w(0);
	wire_nl1il_dataout <= wire_nl1li_dataout AND NOT(n0iOO);
	wire_nl1iO_dataout <= wire_w_lg_n0iOl171w(0) AND NOT(n0iOO);
	wire_nl1li_dataout <= (NOT (wire_nli0i_w_lg_dataout88w(0) AND wire_nli0l_dataout)) OR n0iOl;
	wire_nli0i_dataout <= datain(2) WHEN datain(5) = '1'  ELSE (NOT datain(2));
	wire_nli0i_w_lg_w_lg_w_lg_dataout88w108w111w(0) <= wire_nli0i_w_lg_w_lg_dataout88w108w(0) AND n0Oli29;
	wire_nli0i_w_lg_w_lg_w_lg_dataout88w90w93w(0) <= wire_nli0i_w_lg_w_lg_dataout88w90w(0) AND ni11O20;
	wire_nli0i_w_lg_w_lg_w_lg_dataout88w136w139w(0) <= wire_nli0i_w_lg_w_lg_dataout88w136w(0) AND n0lOi44;
	wire_nli0i_w_lg_w_lg_w_lg_dataout88w126w129w(0) <= wire_nli0i_w_lg_w_lg_dataout88w126w(0) AND n0O1l38;
	wire_nli0i_w_lg_w_lg_dataout120w123w(0) <= wire_nli0i_w_lg_dataout120w(0) AND n0O0i35;
	wire_nli0i_w_lg_w_lg_dataout88w108w(0) <= wire_nli0i_w_lg_dataout88w(0) AND wire_nli0O_w_lg_w_lg_dataout89w107w(0);
	wire_nli0i_w_lg_w_lg_dataout88w90w(0) <= wire_nli0i_w_lg_dataout88w(0) AND wire_nli0O_w_lg_dataout89w(0);
	wire_nli0i_w_lg_w_lg_dataout88w183w(0) <= wire_nli0i_w_lg_dataout88w(0) AND n0iOi;
	wire_nli0i_w_lg_w_lg_dataout88w136w(0) <= wire_nli0i_w_lg_dataout88w(0) AND n0O0O;
	wire_nli0i_w_lg_w_lg_dataout88w126w(0) <= wire_nli0i_w_lg_dataout88w(0) AND n0OiO;
	wire_nli0i_w_lg_dataout148w(0) <= wire_nli0i_dataout AND wire_nli0O_w_lg_w_lg_w_lg_dataout72w74w147w(0);
	wire_nli0i_w_lg_dataout120w(0) <= wire_nli0i_dataout AND n0O0O;
	wire_nli0i_w_lg_dataout88w(0) <= NOT wire_nli0i_dataout;
	wire_nli0i_w_lg_dataout161w(0) <= wire_nli0i_dataout OR wire_nli0O_w_lg_dataout160w(0);
	wire_nli0l_dataout <= datain(1) WHEN datain(5) = '1'  ELSE (NOT datain(1));
	wire_nli0l_w_lg_dataout73w(0) <= NOT wire_nli0l_dataout;
	wire_nli0O_dataout <= datain(0) WHEN datain(5) = '1'  ELSE (NOT datain(0));
	wire_nli0O_w_lg_w_lg_w_lg_dataout72w74w147w(0) <= wire_nli0O_w_lg_w_lg_dataout72w74w(0) AND n0liO50;
	wire_nli0O_w_lg_w_lg_dataout89w107w(0) <= wire_nli0O_w_lg_dataout89w(0) AND n0OlO26;
	wire_nli0O_w_lg_w_lg_dataout72w74w(0) <= wire_nli0O_w_lg_dataout72w(0) AND wire_nli0l_w_lg_dataout73w(0);
	wire_nli0O_w_lg_w_lg_dataout72w174w(0) <= wire_nli0O_w_lg_dataout72w(0) AND wire_nli0l_dataout;
	wire_nli0O_w_lg_dataout173w(0) <= wire_nli0O_dataout AND wire_nli0l_w_lg_dataout73w(0);
	wire_nli0O_w_lg_dataout89w(0) <= wire_nli0O_dataout AND wire_nli0l_dataout;
	wire_nli0O_w_lg_dataout72w(0) <= NOT wire_nli0O_dataout;
	wire_nli0O_w_lg_dataout160w(0) <= wire_nli0O_dataout OR wire_nli0l_dataout;
	wire_nli1l_dataout <= datain(4) WHEN datain(5) = '1'  ELSE (NOT datain(4));
	wire_nli1l_w_lg_w_lg_dataout155w158w(0) <= wire_nli1l_w_lg_dataout155w(0) AND n0l0i56;
	wire_nli1l_w_lg_dataout155w(0) <= wire_nli1l_dataout AND n0l0O;
	wire_nli1l_w_lg_dataout104w(0) <= NOT wire_nli1l_dataout;
	wire_nli1O_dataout <= datain(3) WHEN datain(5) = '1'  ELSE (NOT datain(3));
	wire_nli1O_w_lg_w_lg_dataout140w143w(0) <= wire_nli1O_w_lg_dataout140w(0) AND n0lll47;
	wire_nli1O_w_lg_w_lg_dataout149w152w(0) <= wire_nli1O_w_lg_dataout149w(0) AND n0lii53;
	wire_nli1O_w_lg_dataout140w(0) <= wire_nli1O_dataout AND wire_nli0i_w_lg_w_lg_w_lg_dataout88w136w139w(0);
	wire_nli1O_w_lg_dataout130w(0) <= wire_nli1O_dataout AND wire_nli0i_w_lg_w_lg_w_lg_dataout88w126w129w(0);
	wire_nli1O_w_lg_dataout184w(0) <= wire_nli1O_dataout AND wire_nli0i_w_lg_w_lg_dataout88w183w(0);
	wire_nli1O_w_lg_dataout149w(0) <= wire_nli1O_dataout AND wire_nli0i_w_lg_dataout148w(0);
	wire_nli1O_w_lg_dataout87w(0) <= NOT wire_nli1O_dataout;
	wire_nlill_dataout <= wire_nliOl_dataout AND NOT(ni01i);
	wire_nlilO_dataout <= wire_nliOO_dataout AND NOT(ni01i);
	wire_nliOi_dataout <= wire_nll1i_dataout AND NOT(ni01i);
	wire_nliOl_dataout <= wire_nll1l_dataout OR ni01l;
	wire_nliOO_dataout <= wire_nll1O_dataout OR ni01l;
	wire_nll0i_dataout <= wire_nlllO_dataout WHEN wire_w_lg_ni00l51w(0) = '1'  ELSE wire_nllii_dataout;
	wire_nll0l_dataout <= (NOT datain(8)) WHEN ni01O = '1'  ELSE datain(8);
	wire_nll0O_dataout <= (NOT datain(7)) WHEN ni01O = '1'  ELSE datain(7);
	wire_nll1i_dataout <= wire_nll0i_dataout OR ni01l;
	wire_nll1l_dataout <= wire_nllli_dataout WHEN wire_w_lg_ni00l51w(0) = '1'  ELSE wire_nll0l_dataout;
	wire_nll1O_dataout <= wire_nllll_dataout WHEN wire_w_lg_ni00l51w(0) = '1'  ELSE wire_nll0O_dataout;
	wire_nllii_dataout <= (NOT datain(6)) WHEN ni01O = '1'  ELSE datain(6);
	wire_nllli_dataout <= (NOT datain(8)) WHEN datain(9) = '1'  ELSE datain(8);
	wire_nllli_w_lg_dataout59w(0) <= NOT wire_nllli_dataout;
	wire_nllll_dataout <= (NOT datain(7)) WHEN datain(9) = '1'  ELSE datain(7);
	wire_nllll_w_lg_dataout64w(0) <= NOT wire_nllll_dataout;
	wire_nlllO_dataout <= (NOT datain(6)) WHEN datain(9) = '1'  ELSE datain(6);
	wire_nlllO_w_lg_w_lg_dataout57w58w(0) <= wire_nlllO_w_lg_dataout57w(0) AND wire_nllll_dataout;
	wire_nlllO_w_lg_dataout65w(0) <= wire_nlllO_dataout AND wire_nllll_w_lg_dataout64w(0);
	wire_nlllO_w_lg_dataout57w(0) <= NOT wire_nlllO_dataout;

 END RTL; --stratixgx_8b10b_decoder
--synopsys translate_on
--VALID FILE
--/////////////////////////////////////////////////////////////////////////////
--
--                            STRATIXGX_COMP_FIFO_CORE
--
--/////////////////////////////////////////////////////////////////////////////
 
LIBRARY ieee, stratixgx_gxb,std;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
 
ENTITY stratixgx_comp_fifo_core IS
  GENERIC (
    use_rate_match_fifo     : string  := "true";
    rate_matching_fifo_mode : string  := "xaui";
    use_channel_align       : string  := "true";
    for_engineering_sample_device : string := "true";    
    channel_num             : integer := 0
    );
  PORT (
      reset                   : IN std_logic;   
      writeclk                : IN std_logic;   
      readclk                 : IN std_logic;   
      underflow               : IN std_logic;   
      overflow                : IN std_logic;   
      errdetectin             : IN std_logic;   
      disperrin               : IN std_logic;   
      patterndetectin         : IN std_logic;   
      disablefifowrin         : IN std_logic;   
      disablefifordin         : IN std_logic;   
      re                      : IN std_logic;   
      we                      : IN std_logic;   
      datain                  : IN std_logic_vector(9 DOWNTO 0);   
      datainpre               : IN std_logic_vector(9 DOWNTO 0);   
      syncstatusin            : IN std_logic;   
      disperr                 : OUT std_logic;   
      alignstatus             : IN std_logic;   
      fifordin                : IN std_logic;   
      fifordout               : OUT std_logic;   
      decsync                 : OUT std_logic;   
      fifocntlt5                  : OUT std_logic;   
      fifocntgt9                : OUT std_logic;   
      done                    : OUT std_logic;   
      fifoalmostful           : OUT std_logic;   
      fifofull                : OUT std_logic;   
      fifoalmostempty         : OUT std_logic;   
      fifoempty               : OUT std_logic;   
      alignsyncstatus         : OUT std_logic;   
      smenable                : OUT std_logic;   
      disablefifordout        : OUT std_logic;   
      disablefifowrout        : OUT std_logic;   
      dataout                 : OUT std_logic_vector(9 DOWNTO 0);   
      codevalid               : OUT std_logic;   
      errdetectout            : OUT std_logic;   
      patterndetect           : OUT std_logic;   
      syncstatus              : OUT std_logic);
END stratixgx_comp_fifo_core;
 
ARCHITECTURE arch_stratixgx_comp_fifo_core OF stratixgx_comp_fifo_core IS
 
   SIGNAL ge_xaui_sel              :  std_logic;   
   SIGNAL decsync_1                :  std_logic;   
   SIGNAL fifo_cnt_lt_8                   :  std_logic;   
   SIGNAL fifo_cnt_lt_9                   :  std_logic;   
   SIGNAL fifo_cnt_lt_7                   :  std_logic;   
   SIGNAL fifo_cnt_lt_12                  :  std_logic;   
   SIGNAL fifo_cnt_lt_4                   :  std_logic;   
   SIGNAL fifo_cnt_gt_10                  :  std_logic;   
   SIGNAL fifo_cnt_gt_8                   :  std_logic;   
   SIGNAL fifo_cnt_gt_13                  :  std_logic;   
   SIGNAL fifo_cnt_gt_5                 :  std_logic;   
   SIGNAL fifo_cnt_gt_6                 :  std_logic;   
   SIGNAL almostfull_1             :  std_logic;   
   SIGNAL almostfull_sync          :  std_logic;   
   SIGNAL almostempty_1            :  std_logic;   
   SIGNAL almostempty_sync         :  std_logic;   
   SIGNAL full_1                   :  std_logic;   
   SIGNAL full_sync                :  std_logic;   
   SIGNAL empty_1                  :  std_logic;   
   SIGNAL empty_sync               :  std_logic;   
   SIGNAL rdenable_sync_1          :  std_logic;   
   SIGNAL rdenable_sync            :  std_logic;   
   SIGNAL write_enable_sync        :  std_logic;   
   SIGNAL write_enable_sync_1      :  std_logic;   
   SIGNAL fifo_dec_dly             :  std_logic;   
   SIGNAL count                    :  std_logic_vector(3 DOWNTO 0);   
   SIGNAL count_read               :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL comp_write_d             :  std_logic;   
   SIGNAL comp_write_pre           :  std_logic;   
   SIGNAL comp_write               :  std_logic;   
   SIGNAL write_detect_d           :  std_logic;   
   SIGNAL write_detect_pre         :  std_logic;   
   SIGNAL write_detect             :  std_logic;   
   SIGNAL comp_read_d              :  std_logic;   
   SIGNAL comp_read                :  std_logic;   
   SIGNAL detect_read_d            :  std_logic;   
   SIGNAL detect_read              :  std_logic;   
   SIGNAL comp_read_ext            :  std_logic;   
   SIGNAL read_eco                 :  std_logic;   
   SIGNAL read_eco_dly             :  std_logic;
   SIGNAL reset_fifo_dec           :  std_logic;   
   SIGNAL read_sync_int_1          :  std_logic;   
   SIGNAL read_sync_int            :  std_logic;   
   SIGNAL read_sync                :  std_logic;   
   SIGNAL fifo_dec                 :  std_logic;   
   SIGNAL done_write               :  std_logic;   
   SIGNAL done_read                :  std_logic;   
   SIGNAL underflow_sync_1         :  std_logic;   
   SIGNAL underflow_sync           :  std_logic;   
   SIGNAL done_read_sync_1         :  std_logic;   
   SIGNAL done_read_sync           :  std_logic;   
   SIGNAL alignsyncstatus_sync     :  std_logic;   
   SIGNAL alignstatus_sync_1       :  std_logic;   
   SIGNAL alignstatus_sync         :  std_logic;   
   SIGNAL alignstatus_dly          :  std_logic;   
   SIGNAL re_dly                   :  std_logic;   
   SIGNAL syncstatus_sync_1        :  std_logic;   
   SIGNAL syncstatus_sync          :  std_logic;   
   SIGNAL write_ptr                :  integer := 0 ;   
   SIGNAL read_ptr1                :  integer := 0 ;   
   SIGNAL read_ptr2                :  integer := 0 ;   
   SIGNAL i                        :  integer;   
   SIGNAL j                        :  integer;   
   SIGNAL k                        :  integer;   
   SIGNAL fifo                     :  std_logic_vector(14 * 12 - 1 DOWNTO 0);   
   SIGNAL fifo_errdetectin         :  std_logic;   
   SIGNAL fifo_errdetectin_dly     :  std_logic;   
   SIGNAL fifo_disperrin           :  std_logic;   
   SIGNAL fifo_disperrin_dly       :  std_logic;   
   SIGNAL fifo_patterndetectin     :  std_logic;   
   SIGNAL fifo_patterndetectin_dly :  std_logic;   
   SIGNAL fifo_syncstatusin         :  std_logic;   
   SIGNAL fifo_syncstatusin_dly     :  std_logic;   
   SIGNAL fifo_data_in             :  std_logic_vector(10 DOWNTO 0);   
   SIGNAL fifo_data_in_dly         :  std_logic_vector(10 DOWNTO 0);
   SIGNAL comp_pat1                :  std_logic_vector(11 DOWNTO 0);   
   SIGNAL comp_pat2                :  std_logic_vector(11 DOWNTO 0);   
   SIGNAL fifo_data_in_pre         :  std_logic_vector(12 DOWNTO 0);   
   SIGNAL fifo_data_out1_sync      :  std_logic_vector(13 DOWNTO 0);   
   SIGNAL fifo_data_out1_sync_dly  :  std_logic_vector(13 DOWNTO 0);   
   SIGNAL fifo_data_out1_sync_valid:  std_logic;   
   SIGNAL fifo_data_out2_sync      :  std_logic_vector(13 DOWNTO 0);   
   SIGNAL fifo_data_out1_tmp       :  std_logic_vector(13 DOWNTO 0);   
   SIGNAL fifo_data_out2_tmp       :  std_logic_vector(12 DOWNTO 0);   
   SIGNAL fifo_data_out1           :  std_logic_vector(13 DOWNTO 0);   
   SIGNAL fifo_data_out2           :  std_logic_vector(13 DOWNTO 0);   
   SIGNAL genericfifo_sync_clk2_1  :  std_logic;   
   SIGNAL genericfifo_sync_clk2    :  std_logic;   
   SIGNAL genericfifo_sync_clk1_1  :  std_logic;   
   SIGNAL genericfifo_sync_clk1    :  std_logic;   
   SIGNAL onechannel               :  std_logic;   
   SIGNAL deskewenable             :  std_logic;   
   SIGNAL matchenable              :  std_logic;   
   SIGNAL menable                  :  std_logic;   
   SIGNAL genericfifo              :  std_logic;   
   SIGNAL globalenable             :  std_logic;   
   SIGNAL fifordout_tmp1          :  std_logic;   
   SIGNAL fifoalmostful_tmp2      :  std_logic;   
   SIGNAL fifofull_tmp3           :  std_logic;   
   SIGNAL fifoalmostempty_tmp4    :  std_logic;   
   SIGNAL fifoempty_tmp5          :  std_logic;   
   SIGNAL decsync_tmp6            :  std_logic;   
   SIGNAL fifocntlt5_tmp7             :  std_logic;   
   SIGNAL fifocntgt9_tmp8           :  std_logic;   
   SIGNAL done_tmp9               :  std_logic;   
   SIGNAL alignsyncstatus_tmp10   :  std_logic;   
   SIGNAL smenable_tmp11          :  std_logic;   
   SIGNAL disablefifordout_tmp12  :  std_logic;   
   SIGNAL disablefifowrout_tmp13  :  std_logic;   
   SIGNAL dataout_tmp14           :  std_logic_vector(9 DOWNTO 0);   
   SIGNAL codevalid_tmp15         :  std_logic;   
   SIGNAL errdetectout_tmp16      :  std_logic;   
   SIGNAL syncstatus_tmp17        :  std_logic;   
   SIGNAL patterndetect_tmp18     :  std_logic;   
   SIGNAL disperr_tmp19           :  std_logic;   
   SIGNAL count_less3_tmp         :  std_logic;
   SIGNAL count_2_tmp             :  std_logic;
   SIGNAL count_read_tmp          :  std_logic;
   SIGNAL writeclk_dly            :  std_logic;
   SIGNAL write_done              :  std_logic := '0';
  
BEGIN
   fifordout <= fifordout_tmp1;
   fifoalmostful <= fifoalmostful_tmp2;
   fifofull <= fifofull_tmp3;
   fifoalmostempty <= fifoalmostempty_tmp4;
   fifoempty <= fifoempty_tmp5;
   decsync <= decsync_tmp6;
   fifocntlt5 <= fifocntlt5_tmp7;
   fifocntgt9 <= fifocntgt9_tmp8;
   done <= done_tmp9;
   alignsyncstatus <= alignsyncstatus_tmp10;
   smenable <= smenable_tmp11;
   disablefifordout <= disablefifordout_tmp12;
   disablefifowrout <= disablefifowrout_tmp13;
   dataout <= dataout_tmp14;
   codevalid <= codevalid_tmp15;
   errdetectout <= errdetectout_tmp16;
   syncstatus <= syncstatus_tmp17;
   patterndetect <= patterndetect_tmp18;
   disperr <= disperr_tmp19;
   onechannel <= '1' WHEN (channel_num = 0) ELSE '0' ;
   deskewenable <= '1' WHEN (use_channel_align = "true") ELSE '0' ;
   matchenable <= '1' WHEN (use_rate_match_fifo = "true") ELSE '0' ;
   menable <= matchenable AND NOT deskewenable ;
   genericfifo <= '1' WHEN (rate_matching_fifo_mode = "none") ELSE '0' ;
   globalenable <= matchenable AND deskewenable ;
   ge_xaui_sel <= '1' WHEN (rate_matching_fifo_mode = "gige") ELSE '0' ;

   PROCESS (writeclk)
   BEGIN
     writeclk_dly <= writeclk;
   END PROCESS;

   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1') THEN
         comp_write_pre <= '0';    
      ELSIF (writeclk_dly'EVENT AND writeclk_dly = '1') THEN
         IF ((alignsyncstatus_tmp10 AND (write_detect OR NOT ge_xaui_sel)) = '1') THEN
            comp_write_pre <= comp_write_d;    
         ELSE
            comp_write_pre <= '0';    
         END IF;
      END IF;
   END PROCESS;

   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1') THEN
         write_detect_pre <= '0';    
      ELSIF (writeclk_dly'EVENT AND writeclk_dly = '1') THEN
         IF ((alignsyncstatus_tmp10 AND ge_xaui_sel) = '1') THEN
            write_detect_pre <= write_detect_d;    
         ELSE
            write_detect_pre <= '0';    
         END IF;
      END IF;
   END PROCESS;

   PROCESS (reset, readclk)
   BEGIN
      IF (reset = '1') THEN
         comp_read <= '0';    
         comp_read_ext <= '0';    
      ELSIF (readclk'EVENT AND readclk = '1') THEN
         comp_read_ext <= (underflow_sync AND comp_read) AND ge_xaui_sel;    
         IF ((alignsyncstatus_sync AND (detect_read OR NOT ge_xaui_sel)) = '1') THEN
            comp_read <= (comp_read_d AND NOT fifo_data_out2_sync(10)) AND NOT fifo_data_out2_sync(12);    
         ELSE
            comp_read <= '0';    
         END IF;
      END IF;
   END PROCESS;

   PROCESS (reset, readclk)
   BEGIN
      IF (reset = '1') THEN
         detect_read <= '0';    
      ELSIF (readclk'EVENT AND readclk = '1') THEN
         IF ((alignsyncstatus_sync AND ge_xaui_sel) = '1') THEN
            detect_read <= (detect_read_d AND NOT fifo_data_out2_sync(10)) AND NOT fifo_data_out2_sync(12);    
         ELSE
            detect_read <= '0';    
         END IF;
      END IF;
   END PROCESS;
   fifo_cnt_lt_4 <= '1' when (count <4) else '0';
   fifocntlt5_tmp7 <= '1' when (count < 5) else '0';
   fifo_cnt_lt_7 <= '1' when (count < 7) else '0';
   fifo_cnt_lt_8 <= '1' when (count < 8) else '0';  -- added in REV-C
   fifo_cnt_lt_9 <= '1' when (count < 9) else '0';
   fifo_cnt_lt_12 <= '1' when (count < 12) else '0';
   fifo_cnt_gt_5 <= '1' when (count > 5) else '0';
   fifo_cnt_gt_6 <= '1' when (count > 6) else '0';  -- added in REV-C
   fifo_cnt_gt_8 <= '1' when (count > 8) else '0';
   fifocntgt9_tmp8 <= '1' when (count > 9) else '0';
   fifo_cnt_gt_10 <= '1' when (count > 10) else '0';
   fifo_cnt_gt_13 <= '1' when (count > 13) else '0';
   disablefifowrout_tmp13 <= disablefifowrin WHEN (globalenable AND NOT onechannel) = '1' ELSE ((overflow AND comp_write) AND NOT done_write) ;

   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1') THEN
         count <= "0000";    
      ELSIF (writeclk_dly'EVENT AND writeclk_dly = '1') THEN
         IF (genericfifo_sync_clk1 = '1') THEN
            IF ((write_enable_sync AND NOT decsync_tmp6) = '1') THEN
               count <= count + "0001";    
            ELSE
               IF ((write_enable_sync AND decsync_tmp6) = '1') THEN
                  count <= count - "0010";    
               ELSE
                  IF ((NOT write_enable_sync AND decsync_tmp6) = '1') THEN
                     count <= count - "0011";    
                  ELSE
                     count <= count;    
                  END IF;
               END IF;
            END IF;
         ELSE
            IF (NOT alignsyncstatus_tmp10 = '1') THEN
               count <= "0000";    
            ELSE
               IF ((NOT decsync_tmp6 AND NOT disablefifowrout_tmp13) = '1') THEN
                  count <= count + "0001";    
               ELSE
                  IF ((decsync_tmp6 AND NOT disablefifowrout_tmp13) = '1') THEN
                     count <= count - "0010";    
                  ELSE
                     IF (((NOT ge_xaui_sel AND decsync_tmp6) AND disablefifowrout_tmp13) = '1') THEN
                        count <= count - "0011";    
                     ELSE
                        IF (((ge_xaui_sel AND decsync_tmp6) AND disablefifowrout_tmp13) = '1') THEN
                           count <= count - "0100";    
                        ELSE
                           IF (((ge_xaui_sel AND NOT decsync_tmp6) AND disablefifowrout_tmp13) = '1') THEN
                              count <= count - "0001";    
                           ELSE
                              count <= count;    
                           END IF;
                        END IF;
                     END IF;
                  END IF;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1') THEN
         done_write <= '0';    
      ELSIF (writeclk_dly'EVENT AND writeclk_dly = '1') THEN
         done_write <= overflow AND comp_write;    
      END IF;
   END PROCESS;

   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1') THEN
         almostfull_1 <= '0';    
      ELSIF (writeclk_dly'EVENT AND writeclk_dly = '1') THEN
         IF (almostfull_1 = '1') THEN
            almostfull_1 <= NOT fifo_cnt_lt_8;    
         ELSE
            almostfull_1 <= fifocntgt9_tmp8;    
         END IF;
      END IF;
   END PROCESS;

   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1') THEN
         almostempty_1 <= '1';    
      ELSIF (writeclk_dly'EVENT AND writeclk_dly = '1') THEN
         IF (almostempty_1 = '1') THEN
            almostempty_1 <= NOT fifo_cnt_gt_6;    
         ELSE
            almostempty_1 <= fifocntlt5_tmp7;    
         END IF;
      END IF;
   END PROCESS;

   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1') THEN
         full_1 <= '0';    
      ELSIF (writeclk_dly'EVENT AND writeclk_dly = '1') THEN
         IF (full_1 = '1') THEN
            full_1 <= NOT fifo_cnt_lt_12;    
         ELSE
            full_1 <= fifo_cnt_gt_13;    
         END IF;
      END IF;
   END PROCESS;

   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1') THEN
         empty_1 <= '1';    
      ELSIF (writeclk_dly'EVENT AND writeclk_dly = '1') THEN
         IF (empty_1 = '1') THEN
            empty_1 <= NOT fifo_cnt_gt_5;    
         ELSE
            empty_1 <= fifo_cnt_lt_4;    
         END IF;
      END IF;
   END PROCESS;
   read_sync <= fifordin WHEN (globalenable AND NOT onechannel) = '1' ELSE fifordout_tmp1 ;
   fifordout_tmp1 <= read_sync_int ;

   count_less3_tmp <= '1' when (count <= 2) else '0';
   count_2_tmp <= '1' when (count = 2) else '0';

   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1') THEN
         read_eco <= '0';    
      ELSIF (writeclk_dly'EVENT AND writeclk_dly = '1') THEN
         IF ((read_eco AND count_less3_tmp) = '1') THEN
            read_eco <= '0';    
         ELSE
            IF ((NOT read_eco AND count_2_tmp) = '1') THEN
               read_eco <= '1';    
            END IF;
         END IF;
      END IF;
   END PROCESS;

   alignstatus_dly <= alignstatus after 1 ps;
   read_eco_dly <= read_eco after 1 ps;
   re_dly <= re after 1 ps;

   PROCESS (reset, readclk)
   BEGIN
      IF (reset = '1') THEN
         read_sync_int_1 <= '0';    
         read_sync_int <= '0';    
         underflow_sync_1 <= '0';    
         underflow_sync <= '0';    
         alignstatus_sync_1 <= '0';    
         alignstatus_sync <= '0';    
         syncstatus_sync_1 <= '0';    
         syncstatus_sync <= '0';    
         rdenable_sync_1 <= '0';    
         rdenable_sync <= '0';    
         fifo_data_out1_sync_valid <= '0';    
         fifo_dec_dly <= '0';    
         almostfull_sync <= '0';    
         almostempty_sync <= '1';    
         full_sync <= '0';    
         empty_sync <= '1';    
         fifoalmostful_tmp2 <= '0';    
         fifoalmostempty_tmp4 <= '1';    
         fifofull_tmp3 <= '0';    
         fifoempty_tmp5 <= '1';    
         genericfifo_sync_clk2_1 <= '0';    
         genericfifo_sync_clk2 <= '0';    
      ELSIF (readclk'EVENT AND readclk = '1') THEN
         read_sync_int_1 <= read_eco_dly AND NOT genericfifo_sync_clk2;    
         read_sync_int <= read_sync_int_1;    
         underflow_sync_1 <= underflow;    
         underflow_sync <= underflow_sync_1;    
         alignstatus_sync_1 <= alignstatus_dly;    
         alignstatus_sync <= alignstatus_sync_1;    
         syncstatus_sync_1 <= syncstatusin;    
         syncstatus_sync <= syncstatus_sync_1;    
         rdenable_sync_1 <= re_dly AND genericfifo;    
         rdenable_sync <= rdenable_sync_1;    
         fifo_data_out1_sync_valid <= ((NOT genericfifo_sync_clk2 AND alignsyncstatus_sync) AND read_sync) OR (genericfifo_sync_clk2 AND rdenable_sync);    
         fifo_dec_dly <= fifo_dec;    
         almostfull_sync <= almostfull_1;    
         almostempty_sync <= almostempty_1;    
         full_sync <= full_1;    
         empty_sync <= empty_1;    
         fifoalmostful_tmp2 <= almostfull_sync;    
         fifoalmostempty_tmp4 <= almostempty_sync;    
         fifofull_tmp3 <= full_sync;    
         fifoempty_tmp5 <= empty_sync;    
         genericfifo_sync_clk2_1 <= genericfifo;    
         genericfifo_sync_clk2 <= genericfifo_sync_clk2_1;    
      END IF;
   END PROCESS;
   disablefifordout_tmp12 <= disablefifordin WHEN (globalenable AND NOT onechannel) = '1' ELSE ((underflow_sync AND (comp_read OR comp_read_ext)) AND NOT done_read) ;

   PROCESS (reset, readclk)
   BEGIN
      IF (reset = '1') THEN
         count_read <= "00";    
      ELSIF (readclk'EVENT AND readclk = '1') THEN
         IF ((NOT alignsyncstatus_sync AND NOT genericfifo_sync_clk2) = '1') THEN
            count_read <= "00";    
         ELSE
            IF (((read_sync AND NOT disablefifordout_tmp12) OR rdenable_sync) = '1') THEN
               IF (count_read = 2) THEN
                  count_read <= "00";    
               ELSE
                  count_read <= count_read + "01";    
               END IF;
            ELSE
               count_read <= count_read;    
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (reset, readclk)
   BEGIN
      IF (reset = '1') THEN
         done_read <= '0';    
      ELSIF (readclk'EVENT AND readclk = '1') THEN
         IF ((underflow_sync AND ((comp_read AND NOT ge_xaui_sel) OR (comp_read_ext AND ge_xaui_sel))) = '1') THEN
            done_read <= '1';    
         ELSE
            IF (NOT underflow_sync = '1') THEN
               done_read <= '0';    
            ELSE
               done_read <= done_read;    
            END IF;
         END IF;
      END IF;
   END PROCESS;
   reset_fifo_dec <= reset OR NOT (NOT fifo_dec_dly OR readclk) ;

   -- count_read_tmp <= '1' when (count_read = 2) else '0';
   count_read_tmp <= '1' when (count_read = 1) else '0';

   PROCESS (reset_fifo_dec, readclk)
   BEGIN
      IF (reset_fifo_dec = '1') THEN
         fifo_dec <= '0';    
      ELSIF (readclk'EVENT AND readclk = '1') THEN
         IF ((count_read_tmp AND ((NOT disablefifordout_tmp12 AND NOT genericfifo_sync_clk2) OR (rdenable_sync AND genericfifo_sync_clk2))) = '1') THEN
            fifo_dec <= '1';    
         ELSE
            fifo_dec <= fifo_dec;    
         END IF;
      END IF;
   END PROCESS;

   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1') THEN
         decsync_1 <= '0';    
         decsync_tmp6 <= '0';    
         done_read_sync_1 <= '0';    
         done_read_sync <= '0';    
         write_enable_sync_1 <= '0';    
         write_enable_sync <= '0';    
         genericfifo_sync_clk1_1 <= '0';    
         genericfifo_sync_clk1 <= '0';    
      ELSIF (writeclk_dly'EVENT AND writeclk_dly = '1') THEN
         decsync_1 <= fifo_dec;    
         decsync_tmp6 <= decsync_1 AND NOT decsync_tmp6;    
         done_read_sync_1 <= done_read;    
         done_read_sync <= done_read_sync_1;    
         write_enable_sync_1 <= we AND genericfifo;    
         write_enable_sync <= write_enable_sync_1;    
         genericfifo_sync_clk1_1 <= genericfifo;    
         genericfifo_sync_clk1 <= genericfifo_sync_clk1_1;    
      END IF;
   END PROCESS;

   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1') then 
         write_ptr <= 0;
         write_done <= '0';
      ELSIF (writeclk_dly'EVENT AND writeclk_dly = '1') THEN
         IF ((NOT alignsyncstatus_tmp10 AND NOT genericfifo_sync_clk1) = '1') THEN
            write_ptr <= 0;    
         ELSE
            IF (((write_enable_sync AND genericfifo_sync_clk1) OR (NOT disablefifowrout_tmp13 AND NOT genericfifo_sync_clk1)) = '1') THEN
               IF (write_ptr /= 11) THEN
                  write_ptr <= write_ptr + 1;    
               ELSE
                  write_ptr <= 0;    
               END IF;
            ELSE
               IF (((disablefifowrout_tmp13 AND ge_xaui_sel) AND NOT genericfifo_sync_clk1) = '1') THEN
                  IF (write_ptr /= 0) THEN
                     write_ptr <= write_ptr - 1;    
                  ELSE
                     write_ptr <= 11;    
                  END IF;
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (reset, readclk)
   BEGIN
      IF (reset = '1') THEN
         read_ptr1 <= 0;    
         read_ptr2 <= 1;    
      ELSIF (readclk'EVENT AND readclk = '1') THEN
         IF ((NOT alignsyncstatus_sync AND NOT genericfifo_sync_clk2) = '1') THEN
            read_ptr1 <= 0;    
            read_ptr2 <= 1;    
         ELSE
            IF ((((read_sync AND NOT disablefifordout_tmp12) AND NOT genericfifo_sync_clk2) OR (rdenable_sync AND genericfifo_sync_clk2)) = '1') THEN
               IF (read_ptr1 /= 11) THEN
                  read_ptr1 <= read_ptr1 + 1;    
               ELSE
                  read_ptr1 <= 0;    
               END IF;
               IF (read_ptr2 /= 11) THEN
                  read_ptr2 <= read_ptr2 + 1;    
               ELSE
                  read_ptr2 <= 0;    
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS(fifo_data_in)
   BEGIN
       fifo_data_in_dly <= fifo_data_in;
   END PROCESS;

   PROCESS(fifo_errdetectin, fifo_disperrin, fifo_patterndetectin, fifo_syncstatusin)
   BEGIN
       fifo_errdetectin_dly <= fifo_errdetectin;
       fifo_disperrin_dly <= fifo_disperrin;
       fifo_patterndetectin_dly <= fifo_patterndetectin;
       fifo_syncstatusin_dly <= fifo_syncstatusin;
   END PROCESS;

   PROCESS(write_ptr, fifo_data_in_dly, fifo_errdetectin_dly, fifo_syncstatusin_dly, fifo_disperrin_dly, fifo_patterndetectin_dly, reset)
     VARIABLE fifo_tmp  : std_logic_vector(14 * 12 - 1 DOWNTO 0);
   BEGIN
      IF (reset = '1') THEN
          FOR i IN 0 TO (168 - 1) LOOP
             fifo_tmp(i) := '0';    
          END LOOP;
      ELSE
          FOR i IN 0 TO (10 - 1) LOOP
             fifo_tmp(write_ptr * 14 + i) := fifo_data_in_dly(i);    
          END LOOP;
          fifo_tmp(write_ptr * 14 + 10) := fifo_errdetectin_dly;    
          fifo_tmp(write_ptr * 14 + 11) := fifo_syncstatusin_dly;    
          fifo_tmp(write_ptr * 14 + 12) := fifo_disperrin_dly;    
          fifo_tmp(write_ptr * 14 + 13) := fifo_patterndetectin_dly;
      END IF;
      fifo <= fifo_tmp;
   END PROCESS;

   PROCESS (writeclk_dly, reset, read_ptr1, read_ptr2)
      VARIABLE fifo_data_out1_tmp_tmp21  : std_logic_vector(13 DOWNTO 0);
      VARIABLE fifo_data_out2_tmp_tmp22  : std_logic_vector(12 DOWNTO 0);
   BEGIN
      IF ((writeclk_dly = '1') OR read_ptr1'event OR read_ptr2'event) THEN
         FOR j IN 0 TO (14 - 1) LOOP
            fifo_data_out1_tmp_tmp21(j) := fifo(read_ptr1 * 14 + j);    
         END LOOP;
         FOR k IN 0 TO (13 - 1) LOOP
            fifo_data_out2_tmp_tmp22(k) := fifo(read_ptr2 * 14 + k);    
         END LOOP;
      END IF;
      fifo_data_out1_tmp <= fifo_data_out1_tmp_tmp21;
      fifo_data_out2_tmp <= fifo_data_out2_tmp_tmp22;
   END PROCESS;

   fifo_data_out1 <= fifo_data_out1_tmp after 1 ps;
   fifo_data_out2 <= '0' & fifo_data_out2_tmp after 1 ps;

   PROCESS (reset, readclk)
   BEGIN
      IF (reset = '1') THEN
         fifo_data_out1_sync <= "00000000000000";    
         fifo_data_out1_sync_dly <= "00000000000000";    
         fifo_data_out2_sync <= "00000000000000";    
      ELSIF (readclk'EVENT AND readclk = '1') THEN
         IF (ge_xaui_sel = '1') THEN
            fifo_data_out1_sync_dly <= fifo_data_out1_sync;    
         ELSE
            fifo_data_out1_sync_dly <= "00000000000000";    
         END IF;
         IF (NOT disablefifordout_tmp12 = '1') THEN
            fifo_data_out1_sync <= fifo_data_out1;    
            fifo_data_out2_sync <= fifo_data_out2;    
         ELSE
            IF (ge_xaui_sel = '1') THEN
               fifo_data_out1_sync <= fifo_data_out1_sync_dly;    
            END IF;
         END IF;
      END IF;
   END PROCESS;

   done_tmp9 <= done_write OR done_read_sync ;
   smenable_tmp11 <= '1' WHEN ((menable OR (globalenable AND onechannel)) AND NOT genericfifo_sync_clk1) = '1' ELSE '0' ;
   comp_pat1 <= "001010110110" WHEN (ge_xaui_sel) = '1' ELSE "000010111100" ;
   comp_pat2 <= "001101000011" WHEN (ge_xaui_sel) = '0' ELSE "001010001010" WHEN (for_engineering_sample_device) = "true" ELSE "001010001001";
   comp_write_d <= '1' WHEN (fifo_data_in_pre(9 DOWNTO 0) = CONV_INTEGER(comp_pat1)) OR (fifo_data_in_pre(9 DOWNTO 0) = CONV_INTEGER(comp_pat2)) ELSE '0' ;
   comp_read_d <= '1' WHEN (fifo_data_out2_sync(9 DOWNTO 0) = CONV_INTEGER(comp_pat1)) OR (fifo_data_out2_sync(9 DOWNTO 0) = CONV_INTEGER(comp_pat2)) ELSE '0' ;
   write_detect_d <= '1' WHEN (fifo_data_in_pre(9 DOWNTO 0) = CONV_INTEGER("0101111100")) OR (fifo_data_in_pre(9 DOWNTO 0) = CONV_INTEGER("1010000011")) ELSE '0' ;
   detect_read_d <= '1' WHEN (fifo_data_out2_sync(9 DOWNTO 0) = CONV_INTEGER("0101111100")) OR (fifo_data_out2_sync(9 DOWNTO 0) = CONV_INTEGER("1010000011")) ELSE '0' ;
   dataout_tmp14 <= fifo_data_out1_sync(9 DOWNTO 0) WHEN (matchenable OR genericfifo_sync_clk2) = '1' ELSE datain ;
   errdetectout_tmp16 <= fifo_data_out1_sync(10) WHEN (matchenable OR genericfifo_sync_clk2) = '1' ELSE errdetectin ;
   syncstatus_tmp17 <= fifo_data_out1_sync(11) WHEN (matchenable OR genericfifo_sync_clk2) = '1' ELSE syncstatusin ;
   disperr_tmp19 <= fifo_data_out1_sync(12) WHEN (matchenable OR genericfifo_sync_clk2) = '1' ELSE disperrin ;
   patterndetect_tmp18 <= fifo_data_out1_sync(13) WHEN (matchenable OR genericfifo_sync_clk2) = '1' ELSE patterndetectin ;
   codevalid_tmp15 <= fifo_data_out1_sync_valid WHEN (matchenable OR genericfifo_sync_clk2) = '1' ELSE alignstatus_dly WHEN (deskewenable) = '1' ELSE syncstatusin ;
   alignsyncstatus_tmp10 <= '0' WHEN (NOT matchenable OR genericfifo_sync_clk1) = '1' ELSE alignstatus_dly WHEN (deskewenable) = '1' ELSE syncstatusin ;
   alignsyncstatus_sync <= '0' WHEN (NOT matchenable OR genericfifo_sync_clk2) = '1' ELSE alignstatus_sync WHEN (deskewenable) = '1' ELSE syncstatus_sync ;
   fifo_data_in <= '0' & datain ;
   fifo_data_in_pre <= "000" & datainpre ;
   fifo_errdetectin <= errdetectin ;
   fifo_disperrin <= disperrin ;
   fifo_patterndetectin <= patterndetectin ;
   fifo_syncstatusin <= syncstatusin ;
   comp_write <= (comp_write_pre AND NOT errdetectin) AND NOT disperrin ;
   write_detect <= (write_detect_pre AND NOT errdetectin) AND NOT disperrin ;
 
END arch_stratixgx_comp_fifo_core;
 
--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 39 mux21 14 oper_selector 6 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixgx_comp_fifo_sm IS 
	 PORT 
	 ( 
		 alignsyncstatus	:	IN  STD_LOGIC;
		 decsync	:	IN  STD_LOGIC;
		 done	:	IN  STD_LOGIC;
		 fifocntgt9	:	IN  STD_LOGIC;
		 fifocntlt5	:	IN  STD_LOGIC;
		 overflow	:	OUT  STD_LOGIC;
		 reset	:	IN  STD_LOGIC;
		 smenable	:	IN  STD_LOGIC;
		 underflow	:	OUT  STD_LOGIC;
		 writeclk	:	IN  STD_LOGIC
	 ); 
 END stratixgx_comp_fifo_sm;

 ARCHITECTURE RTL OF stratixgx_comp_fifo_sm IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 n00i19	:	STD_LOGIC := '1';
	 SIGNAL	 n00i20	:	STD_LOGIC := '1';
	 SIGNAL  wire_n00i20_w_lg_Q57w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n00i21	:	STD_LOGIC := '0';
	 SIGNAL	 n00l16	:	STD_LOGIC := '1';
	 SIGNAL	 n00l17	:	STD_LOGIC := '1';
	 SIGNAL  wire_n00l17_w_lg_Q50w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n00l18	:	STD_LOGIC := '0';
	 SIGNAL	 n00O13	:	STD_LOGIC := '1';
	 SIGNAL	 n00O14	:	STD_LOGIC := '1';
	 SIGNAL  wire_n00O14_w_lg_Q35w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n00O15	:	STD_LOGIC := '0';
	 SIGNAL	 n01i25	:	STD_LOGIC := '1';
	 SIGNAL	 n01i26	:	STD_LOGIC := '1';
	 SIGNAL  wire_n01i26_w_lg_Q70w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n01i27	:	STD_LOGIC := '0';
	 SIGNAL	 n01l22	:	STD_LOGIC := '1';
	 SIGNAL	 n01l23	:	STD_LOGIC := '1';
	 SIGNAL  wire_n01l23_w_lg_Q66w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n01l24	:	STD_LOGIC := '0';
	 SIGNAL	 n0ii10	:	STD_LOGIC := '1';
	 SIGNAL	 n0ii11	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0ii11_w_lg_Q30w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0ii12	:	STD_LOGIC := '0';
	 SIGNAL	 n0iO7	:	STD_LOGIC := '1';
	 SIGNAL	 n0iO8	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0iO8_w_lg_Q26w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0iO9	:	STD_LOGIC := '0';
	 SIGNAL	 n0li4	:	STD_LOGIC := '1';
	 SIGNAL	 n0li5	:	STD_LOGIC := '1';
	 SIGNAL  wire_n0li5_w_lg_Q17w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n0li6	:	STD_LOGIC := '0';
	 SIGNAL	 n0Ol1	:	STD_LOGIC := '1';
	 SIGNAL	 n0Ol2	:	STD_LOGIC := '1';
	 SIGNAL	 n0Ol3	:	STD_LOGIC := '0';
	 SIGNAL	 n1Ol31	:	STD_LOGIC := '1';
	 SIGNAL	 n1Ol32	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1Ol32_w_lg_Q85w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1Ol33	:	STD_LOGIC := '0';
	 SIGNAL	 n1OO28	:	STD_LOGIC := '1';
	 SIGNAL	 n1OO29	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1OO29_w_lg_Q74w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1OO30	:	STD_LOGIC := '0';
	 SIGNAL	niOO	:	STD_LOGIC := '0';
	 SIGNAL  wire_niOl_w_lg_niOO41w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOl_w_lg_w_lg_niOO27w31w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOl_w_lg_niOO27w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	ni	:	STD_LOGIC := '0';
	 SIGNAL	nl1i	:	STD_LOGIC := '0';
	 SIGNAL	nll	:	STD_LOGIC := '0';
	 SIGNAL	nlO	:	STD_LOGIC := '0';
	 SIGNAL	nO	:	STD_LOGIC := '0';
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0l_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nl0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nl0l_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nl0O_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nl0O_o	:	STD_LOGIC;
	 SIGNAL  wire_nl0O_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nl1l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nl1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlii_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlii_o	:	STD_LOGIC;
	 SIGNAL  wire_nlii_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliO_o	:	STD_LOGIC;
	 SIGNAL  wire_nliO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_w_lg_alignsyncstatus6w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_decsync7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_done10w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0lO9w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n0Oi47w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_reset1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  n0ll :	STD_LOGIC;
	 SIGNAL  n0lO :	STD_LOGIC;
	 SIGNAL  n0Oi :	STD_LOGIC;
	 SIGNAL  ni1l :	STD_LOGIC;
 BEGIN

	wire_w_lg_alignsyncstatus6w(0) <= NOT alignsyncstatus;
	wire_w_lg_decsync7w(0) <= NOT decsync;
	wire_w_lg_done10w(0) <= NOT done;
	wire_w_lg_n0lO9w(0) <= NOT n0lO;
	wire_w_lg_n0Oi47w(0) <= NOT n0Oi;
	wire_w_lg_reset1w(0) <= NOT reset;
	n0ll <= ((ni OR niOO) OR wire_n01l23_w_lg_Q66w(0));
	n0lO <= (fifocntlt5 OR fifocntgt9);
	n0Oi <= ((alignsyncstatus AND smenable) AND n0Ol2);
	ni1l <= '1';
	overflow <= nll;
	underflow <= nlO;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n00i19 <= n00i21;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n00i20 <= (n00i21 XOR n00i19);
		END IF;
	END PROCESS;
	wire_n00i20_w_lg_Q57w(0) <= n00i20 AND wire_nlli_dataout;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n00i21 <= n00i19;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n00l16 <= n00l18;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n00l17 <= (n00l18 XOR n00l16);
		END IF;
	END PROCESS;
	wire_n00l17_w_lg_Q50w(0) <= n00l17 AND nl1i;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n00l18 <= n00l16;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n00O13 <= n00O15;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n00O14 <= (n00O15 XOR n00O13);
		END IF;
	END PROCESS;
	wire_n00O14_w_lg_Q35w(0) <= n00O14 AND wire_n1O_dataout;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n00O15 <= n00O13;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n01i25 <= n01i27;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n01i26 <= (n01i27 XOR n01i25);
		END IF;
	END PROCESS;
	wire_n01i26_w_lg_Q70w(0) <= n01i26 AND nl1i;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n01i27 <= n01i25;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n01l22 <= n01l24;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n01l23 <= (n01l24 XOR n01l22);
		END IF;
	END PROCESS;
	wire_n01l23_w_lg_Q66w(0) <= NOT n01l23;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n01l24 <= n01l22;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n0ii10 <= n0ii12;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n0ii11 <= (n0ii12 XOR n0ii10);
		END IF;
	END PROCESS;
	wire_n0ii11_w_lg_Q30w(0) <= NOT n0ii11;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n0ii12 <= n0ii10;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n0iO7 <= n0iO9;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n0iO8 <= (n0iO9 XOR n0iO7);
		END IF;
	END PROCESS;
	wire_n0iO8_w_lg_Q26w(0) <= n0iO8 AND ni;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n0iO9 <= n0iO7;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n0li4 <= n0li6;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n0li5 <= (n0li6 XOR n0li4);
		END IF;
	END PROCESS;
	wire_n0li5_w_lg_Q17w(0) <= n0li5 AND wire_nlll_dataout;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n0li6 <= n0li4;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n0Ol1 <= n0Ol3;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n0Ol2 <= (n0Ol3 XOR n0Ol1);
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n0Ol3 <= n0Ol1;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n1Ol31 <= n1Ol33;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n1Ol32 <= (n1Ol33 XOR n1Ol31);
		END IF;
	END PROCESS;
	wire_n1Ol32_w_lg_Q85w(0) <= n1Ol32 AND n0ll;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n1Ol33 <= n1Ol31;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n1OO28 <= n1OO30;
		END IF;
	END PROCESS;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n1OO29 <= (n1OO30 XOR n1OO28);
		END IF;
	END PROCESS;
	wire_n1OO29_w_lg_Q74w(0) <= n1OO29 AND nO;
	PROCESS (writeclk)
	BEGIN
		IF (writeclk = '1' AND writeclk'event) THEN n1OO30 <= n1OO28;
		END IF;
	END PROCESS;
	PROCESS (writeclk, reset)
	BEGIN
		IF (reset = '1') THEN
				niOO <= '1';
		ELSIF (writeclk = '1' AND writeclk'event) THEN
				niOO <= wire_nl0O_o;
		END IF;
	END PROCESS;
	wire_niOl_w_lg_niOO41w(0) <= NOT niOO;
	wire_niOl_w_lg_w_lg_niOO27w31w(0) <= wire_niOl_w_lg_niOO27w(0) OR wire_n0ii11_w_lg_Q30w(0);
	wire_niOl_w_lg_niOO27w(0) <= niOO OR nl1i;
	PROCESS (writeclk, reset)
	BEGIN
		IF (reset = '1') THEN
				ni <= '0';
				nl1i <= '0';
				nll <= '0';
				nlO <= '0';
				nO <= '0';
		ELSIF (writeclk = '1' AND writeclk'event) THEN
				ni <= wire_nl0l_o;
				nl1i <= wire_nliO_o;
				nll <= wire_nl1l_o;
				nlO <= wire_nl1O_o;
				nO <= wire_nlii_o;
		END IF;
	END PROCESS;
	wire_n0i_dataout <= n0lO AND NOT(wire_w_lg_alignsyncstatus6w(0));
	wire_n0l_dataout <= fifocntgt9 WHEN n0lO = '1'  ELSE nll;
	wire_n0O_dataout <= fifocntlt5 WHEN n0lO = '1'  ELSE nlO;
	wire_n1i_dataout <= nll WHEN wire_w_lg_alignsyncstatus6w(0) = '1'  ELSE wire_n0l_dataout;
	wire_n1l_dataout <= nlO WHEN wire_w_lg_alignsyncstatus6w(0) = '1'  ELSE wire_n0O_dataout;
	wire_n1O_dataout <= wire_w_lg_n0lO9w(0) AND NOT(wire_w_lg_alignsyncstatus6w(0));
	wire_nil_dataout <= wire_w_lg_decsync7w(0) AND NOT(wire_w_lg_alignsyncstatus6w(0));
	wire_niO_dataout <= decsync AND NOT(wire_w_lg_alignsyncstatus6w(0));
	wire_nlli_dataout <= done AND NOT(wire_w_lg_alignsyncstatus6w(0));
	wire_nlll_dataout <= wire_w_lg_done10w(0) AND NOT(wire_w_lg_alignsyncstatus6w(0));
	wire_nllO_dataout <= wire_nlOl_dataout AND NOT(wire_w_lg_alignsyncstatus6w(0));
	wire_nlOi_dataout <= wire_nlOO_dataout AND NOT(wire_w_lg_alignsyncstatus6w(0));
	wire_nlOl_dataout <= nlO AND NOT(done);
	wire_nlOO_dataout <= nll AND NOT(done);
	wire_nl0l_data <= ( n0Oi & wire_nil_dataout & "0" & wire_n00i20_w_lg_Q57w);
	wire_nl0l_sel <= ( niOO & ni & nO & wire_n00l17_w_lg_Q50w);
	nl0l :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_nl0l_data,
		o => wire_nl0l_o,
		sel => wire_nl0l_sel
	  );
	wire_nl0O_data <= ( wire_w_lg_n0Oi47w & wire_w_lg_alignsyncstatus6w);
	wire_nl0O_sel <= ( niOO & wire_niOl_w_lg_niOO41w);
	nl0O :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_nl0O_data,
		o => wire_nl0O_o,
		sel => wire_nl0O_sel
	  );
	wire_nl1l_data <= ( nll & wire_n1i_dataout & wire_nlOi_dataout);
	wire_nl1l_sel <= ( wire_n1Ol32_w_lg_Q85w & nO & nl1i);
	nl1l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1l_data,
		o => wire_nl1l_o,
		sel => wire_nl1l_sel
	  );
	wire_nl1O_data <= ( nlO & wire_n1l_dataout & wire_nllO_dataout);
	wire_nl1O_sel <= ( n0ll & wire_n1OO29_w_lg_Q74w & wire_n01i26_w_lg_Q70w);
	nl1O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nl1O_data,
		o => wire_nl1O_o,
		sel => wire_nl1O_sel
	  );
	wire_nlii_data <= ( "0" & wire_niO_dataout & wire_n00O14_w_lg_Q35w);
	wire_nlii_sel <= ( wire_niOl_w_lg_w_lg_niOO27w31w & wire_n0iO8_w_lg_Q26w & nO);
	nlii :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlii_data,
		o => wire_nlii_o,
		sel => wire_nlii_sel
	  );
	wire_nliO_data <= ( "0" & wire_n0i_dataout & wire_n0li5_w_lg_Q17w);
	wire_nliO_sel <= ( n0ll & nO & nl1i);
	nliO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nliO_data,
		o => wire_nliO_o,
		sel => wire_nliO_sel
	  );

 END RTL; --stratixgx_comp_fifo_sm
--synopsys translate_on
--VALID FILE
--/////////////////////////////////////////////////////////////////////////////
--
--                            STRATIXGX_COMP_FIFO
--
--/////////////////////////////////////////////////////////////////////////////
 
LIBRARY ieee, stratixgx_gxb,std;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
 
ENTITY stratixgx_comp_fifo IS
  GENERIC (
    use_rate_match_fifo     : string  := "true";
    rate_matching_fifo_mode : string  := "xaui";
    use_channel_align       : string  := "true";
    for_engineering_sample_device    : String := "true"; -- new in 3.0 SP2 
    channel_num             : integer := 0
    );
   PORT (
      datain                  : IN std_logic_vector(9 DOWNTO 0);   
      datainpre               : IN std_logic_vector(9 DOWNTO 0);   
      reset                   : IN std_logic;   
      errdetectin             : IN std_logic;   
      syncstatusin            : IN std_logic;   
      disperrin               : IN std_logic;   
      patterndetectin         : IN std_logic;   
      errdetectinpre          : IN std_logic;   
      syncstatusinpre         : IN std_logic;   
      disperrinpre            : IN std_logic;   
      patterndetectinpre      : IN std_logic;   
      writeclk                : IN std_logic;   
      readclk                 : IN std_logic;   
      re                      : IN std_logic;   
      we                      : IN std_logic;   
      fifordin                : IN std_logic;   
      disablefifordin         : IN std_logic;   
      disablefifowrin         : IN std_logic;   
      alignstatus             : IN std_logic;   
      dataout                 : OUT std_logic_vector(9 DOWNTO 0);   
      errdetectout            : OUT std_logic;   
      syncstatus              : OUT std_logic;   
      disperr                 : OUT std_logic;   
      patterndetect           : OUT std_logic;   
      codevalid               : OUT std_logic;   
      fifofull                : OUT std_logic;   
      fifoalmostful           : OUT std_logic;   
      fifoempty               : OUT std_logic;   
      fifoalmostempty         : OUT std_logic;   
      disablefifordout        : OUT std_logic;   
      disablefifowrout        : OUT std_logic;   
      fifordout               : OUT std_logic);   
end stratixgx_comp_fifo;
 
ARCHITECTURE arch_stratixgx_comp_fifo OF stratixgx_comp_fifo IS

   COMPONENT stratixgx_comp_fifo_core
      GENERIC (
          channel_num                    :  integer := 0;    
          rate_matching_fifo_mode        :  string := "xaui";    
          use_channel_align              :  string := "true";    
          for_engineering_sample_device  :  string := "true"; -- new in 3.0 SP2 
          use_rate_match_fifo            :  string := "true");
      PORT (
         reset                   : IN  std_logic;
         writeclk                : IN  std_logic;
         readclk                 : IN  std_logic;
         underflow               : IN  std_logic;
         overflow                : IN  std_logic;
         errdetectin             : IN  std_logic;
         disperrin               : IN  std_logic;
         patterndetectin         : IN  std_logic;
         disablefifowrin         : IN  std_logic;
         disablefifordin         : IN  std_logic;
         re                      : IN  std_logic;
         we                      : IN  std_logic;
         datain                  : IN  std_logic_vector(9 DOWNTO 0);
         datainpre               : IN  std_logic_vector(9 DOWNTO 0);
         syncstatusin            : IN  std_logic;
         disperr                 : OUT std_logic;
         alignstatus             : IN  std_logic;
         fifordin                : IN  std_logic;
         fifordout               : OUT std_logic;
         decsync                 : OUT std_logic;
         fifocntlt5                  : OUT std_logic;
         fifocntgt9                : OUT std_logic;
         done                    : OUT std_logic;
         fifoalmostful           : OUT std_logic;
         fifofull                : OUT std_logic;
         fifoalmostempty         : OUT std_logic;
         fifoempty               : OUT std_logic;
         alignsyncstatus         : OUT std_logic;
         smenable                : OUT std_logic;
         disablefifordout        : OUT std_logic;
         disablefifowrout        : OUT std_logic;
         dataout                 : OUT std_logic_vector(9 DOWNTO 0);
         codevalid               : OUT std_logic;
         errdetectout            : OUT std_logic;
         patterndetect           : OUT std_logic;
         syncstatus              : OUT std_logic);
   END COMPONENT;

   COMPONENT stratixgx_comp_fifo_sm
      PORT (
         writeclk                : IN  std_logic;
         alignsyncstatus         : IN  std_logic;
         reset                   : IN  std_logic;
         smenable                : IN  std_logic;
         done                    : IN  std_logic;
         decsync                 : IN  std_logic;
         fifocntlt5                  : IN  std_logic;
         fifocntgt9                : IN  std_logic;
         underflow               : OUT std_logic;
         overflow                : OUT std_logic);
   END COMPONENT;


   SIGNAL done                     :  std_logic;   
   SIGNAL fifocntgt9                 :  std_logic;   
   SIGNAL fifocntlt5                   :  std_logic;   
   SIGNAL decsync                  :  std_logic;   
   SIGNAL alignsyncstatus          :  std_logic;   
   SIGNAL smenable                 :  std_logic;   
   SIGNAL overflow                 :  std_logic;   
   SIGNAL underflow                :  std_logic;   
   SIGNAL dataout_tmp1            :  std_logic_vector(9 DOWNTO 0);   
   SIGNAL errdetectout_tmp2       :  std_logic;   
   SIGNAL syncstatus_tmp3         :  std_logic;   
   SIGNAL disperr_tmp4            :  std_logic;   
   SIGNAL patterndetect_tmp5      :  std_logic;   
   SIGNAL codevalid_tmp6          :  std_logic;   
   SIGNAL fifofull_tmp7           :  std_logic;   
   SIGNAL fifoalmostful_tmp8      :  std_logic;   
   SIGNAL fifoempty_tmp9          :  std_logic;   
   SIGNAL fifoalmostempty_tmp10   :  std_logic;   
   SIGNAL disablefifordout_tmp11  :  std_logic;   
   SIGNAL disablefifowrout_tmp12  :  std_logic;   
   SIGNAL fifordout_tmp13         :  std_logic;   

BEGIN
   dataout <= dataout_tmp1;
   errdetectout <= errdetectout_tmp2;
   syncstatus <= syncstatus_tmp3;
   disperr <= disperr_tmp4;
   patterndetect <= patterndetect_tmp5;
   codevalid <= codevalid_tmp6;
   fifofull <= fifofull_tmp7;
   fifoalmostful <= fifoalmostful_tmp8;
   fifoempty <= fifoempty_tmp9;
   fifoalmostempty <= fifoalmostempty_tmp10;
   disablefifordout <= disablefifordout_tmp11;
   disablefifowrout <= disablefifowrout_tmp12;
   fifordout <= fifordout_tmp13;
 
   comp_fifo_core : stratixgx_comp_fifo_core 
      GENERIC MAP (
         channel_num => channel_num,
         rate_matching_fifo_mode => rate_matching_fifo_mode,
         use_channel_align => use_channel_align,
         for_engineering_sample_device => for_engineering_sample_device, -- new in 3.0 SP2 
         use_rate_match_fifo => use_rate_match_fifo)
      PORT MAP (
         reset => reset,
         writeclk => writeclk,
         readclk => readclk,
         underflow => underflow,
         overflow => overflow,
         errdetectin => errdetectin,
         disperrin => disperrin,
         patterndetectin => patterndetectin,
         disablefifordin => disablefifordin,
         disablefifowrin => disablefifowrin,
         re => re,
         we => we,
         datain => datain,
         datainpre => datainpre,
         syncstatusin => syncstatusin,
         disperr => disperr_tmp4,
         alignstatus => alignstatus,
         fifordin => fifordin,
         fifordout => fifordout_tmp13,
         fifoalmostful => fifoalmostful_tmp8,
         fifofull => fifofull_tmp7,
         fifoalmostempty => fifoalmostempty_tmp10,
         fifoempty => fifoempty_tmp9,
         decsync => decsync,
         fifocntlt5 => fifocntlt5,
         fifocntgt9 => fifocntgt9,
         done => done,
         alignsyncstatus => alignsyncstatus,
         smenable => smenable,
         disablefifordout => disablefifordout_tmp11,
         disablefifowrout => disablefifowrout_tmp12,
         dataout => dataout_tmp1,
         codevalid => codevalid_tmp6,
         errdetectout => errdetectout_tmp2,
         patterndetect => patterndetect_tmp5,
         syncstatus => syncstatus_tmp3);   
   
   comp_fifo_sm : stratixgx_comp_fifo_sm 
      PORT MAP (
         writeclk => writeclk,
         alignsyncstatus => alignsyncstatus,
         reset => reset,
         smenable => smenable,
         done => done,
         decsync => decsync,
         fifocntlt5 => fifocntlt5,
         fifocntgt9 => fifocntgt9,
         underflow => underflow,
         overflow => overflow);   
   
END arch_stratixgx_comp_fifo;
 

--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 289 mux21 301 oper_add 5 oper_decoder 10 oper_less_than 1 oper_selector 60 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixgx_hssi_rx_wal_rtl IS 
	 PORT 
	 ( 
		 A1A2_SIZE	:	IN  STD_LOGIC;
		 AUTOBYTEALIGN_DIS	:	IN  STD_LOGIC;
		 BITSLIP	:	IN  STD_LOGIC;
		 cg_comma	:	OUT  STD_LOGIC;
		 DISABLE_RX_DISP	:	IN  STD_LOGIC;
		 DWIDTH	:	IN  STD_LOGIC;
		 encdet_prbs	:	IN  STD_LOGIC;
		 ENCDT	:	IN  STD_LOGIC;
		 GE_XAUI_SEL	:	IN  STD_LOGIC;
		 IB_INVALID_CODE	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 LP10BEN	:	IN  STD_LOGIC;
		 PMADATAWIDTH	:	IN  STD_LOGIC;
		 prbs_en	:	IN  STD_LOGIC;
		 PUDI	:	IN  STD_LOGIC_VECTOR (9 DOWNTO 0);
		 PUDR	:	IN  STD_LOGIC_VECTOR (9 DOWNTO 0);
		 rcvd_clk	:	IN  STD_LOGIC;
		 RLV	:	OUT  STD_LOGIC;
		 RLV_EN	:	IN  STD_LOGIC;
		 RLV_lt	:	OUT  STD_LOGIC;
		 RUNDISP_SEL	:	IN  STD_LOGIC_VECTOR (4 DOWNTO 0);
		 signal_detect	:	IN  STD_LOGIC;
		 signal_detect_sync	:	OUT  STD_LOGIC;
		 soft_reset	:	IN  STD_LOGIC;
		 SUDI	:	OUT  STD_LOGIC_VECTOR (12 DOWNTO 0);
		 SUDI_pre	:	OUT  STD_LOGIC_VECTOR (9 DOWNTO 0);
		 SYNC_COMP_PAT	:	IN  STD_LOGIC_VECTOR (15 DOWNTO 0);
		 SYNC_COMP_SIZE	:	IN  STD_LOGIC_VECTOR (1 DOWNTO 0);
		 sync_curr_st	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 SYNC_SM_DIS	:	IN  STD_LOGIC;
		 sync_status	:	OUT  STD_LOGIC
	 ); 
 END stratixgx_hssi_rx_wal_rtl;

 ARCHITECTURE RTL OF stratixgx_hssi_rx_wal_rtl IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 n1liiO58	:	STD_LOGIC := '1';
	 SIGNAL	 n1liiO59	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1liiO59_w_lg_Q211w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1liiO60	:	STD_LOGIC := '0';
	 SIGNAL	 n1liOi55	:	STD_LOGIC := '1';
	 SIGNAL	 n1liOi56	:	STD_LOGIC := '1';
	 SIGNAL	 n1liOi57	:	STD_LOGIC := '0';
	 SIGNAL	 n1liOO52	:	STD_LOGIC := '1';
	 SIGNAL	 n1liOO53	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1liOO53_w_lg_Q196w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1liOO54	:	STD_LOGIC := '0';
	 SIGNAL	 n1ll0i49	:	STD_LOGIC := '1';
	 SIGNAL	 n1ll0i50	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1ll0i50_w_lg_Q191w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1ll0i51	:	STD_LOGIC := '0';
	 SIGNAL	 n1ll0O46	:	STD_LOGIC := '1';
	 SIGNAL	 n1ll0O47	:	STD_LOGIC := '1';
	 SIGNAL	 n1ll0O48	:	STD_LOGIC := '0';
	 SIGNAL	 n1llil43	:	STD_LOGIC := '1';
	 SIGNAL	 n1llil44	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1llil44_w_lg_Q177w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1llil45	:	STD_LOGIC := '0';
	 SIGNAL	 n1lllO40	:	STD_LOGIC := '1';
	 SIGNAL	 n1lllO41	:	STD_LOGIC := '1';
	 SIGNAL	 n1lllO42	:	STD_LOGIC := '0';
	 SIGNAL	 n1llOl37	:	STD_LOGIC := '1';
	 SIGNAL	 n1llOl38	:	STD_LOGIC := '1';
	 SIGNAL	 n1llOl39	:	STD_LOGIC := '0';
	 SIGNAL	 n1lO1i34	:	STD_LOGIC := '1';
	 SIGNAL	 n1lO1i35	:	STD_LOGIC := '1';
	 SIGNAL	 n1lO1i36	:	STD_LOGIC := '0';
	 SIGNAL	 n1lO1O31	:	STD_LOGIC := '1';
	 SIGNAL	 n1lO1O32	:	STD_LOGIC := '1';
	 SIGNAL	 n1lO1O33	:	STD_LOGIC := '0';
	 SIGNAL	 n1lOli28	:	STD_LOGIC := '1';
	 SIGNAL	 n1lOli29	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1lOli29_w_lg_Q104w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1lOli30	:	STD_LOGIC := '0';
	 SIGNAL	 n1lOll25	:	STD_LOGIC := '1';
	 SIGNAL	 n1lOll26	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1lOll26_w_lg_Q98w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1lOll27	:	STD_LOGIC := '0';
	 SIGNAL	 n1lOlO22	:	STD_LOGIC := '1';
	 SIGNAL	 n1lOlO23	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1lOlO23_w_lg_Q91w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1lOlO24	:	STD_LOGIC := '0';
	 SIGNAL	 n1lOOi19	:	STD_LOGIC := '1';
	 SIGNAL	 n1lOOi20	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1lOOi20_w_lg_Q81w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1lOOi21	:	STD_LOGIC := '0';
	 SIGNAL	 n1lOOl16	:	STD_LOGIC := '1';
	 SIGNAL	 n1lOOl17	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1lOOl17_w_lg_Q71w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1lOOl18	:	STD_LOGIC := '0';
	 SIGNAL	 n1lOOO13	:	STD_LOGIC := '1';
	 SIGNAL	 n1lOOO14	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1lOOO14_w_lg_Q66w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1lOOO15	:	STD_LOGIC := '0';
	 SIGNAL	 n1O01i4	:	STD_LOGIC := '1';
	 SIGNAL	 n1O01i5	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1O01i5_w_lg_Q35w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1O01i6	:	STD_LOGIC := '0';
	 SIGNAL	 n1O01O1	:	STD_LOGIC := '1';
	 SIGNAL	 n1O01O2	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1O01O2_w_lg_Q29w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1O01O3	:	STD_LOGIC := '0';
	 SIGNAL	 n1O11i10	:	STD_LOGIC := '1';
	 SIGNAL	 n1O11i11	:	STD_LOGIC := '1';
	 SIGNAL  wire_n1O11i11_w_lg_Q62w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n1O11i12	:	STD_LOGIC := '0';
	 SIGNAL	 n1O11O7	:	STD_LOGIC := '1';
	 SIGNAL	 n1O11O8	:	STD_LOGIC := '1';
	 SIGNAL	 n1O11O9	:	STD_LOGIC := '0';
	 SIGNAL	n1i1i	:	STD_LOGIC := '0';
	 SIGNAL	n1i1l	:	STD_LOGIC := '0';
	 SIGNAL	n1i1O	:	STD_LOGIC := '0';
	 SIGNAL	n1l1i	:	STD_LOGIC := '0';
	 SIGNAL  wire_n1iOO_w_lg_n1i1i1443w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1iOO_w_lg_n1i1l1441w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1iOO_w_lg_n1i1O1439w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1iOO_w_lg_n1l1i1438w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n1lOl	:	STD_LOGIC := '0';
	 SIGNAL	n1lOO	:	STD_LOGIC := '0';
	 SIGNAL	n1O1i	:	STD_LOGIC := '0';
	 SIGNAL	nil1O	:	STD_LOGIC := '0';
	 SIGNAL	n01lil	:	STD_LOGIC := '0';
	 SIGNAL	n01liO	:	STD_LOGIC := '0';
	 SIGNAL	n01lli	:	STD_LOGIC := '0';
	 SIGNAL	n01lll	:	STD_LOGIC := '0';
	 SIGNAL	n01llO	:	STD_LOGIC := '0';
	 SIGNAL	n01lOi	:	STD_LOGIC := '0';
	 SIGNAL	n01lOl	:	STD_LOGIC := '0';
	 SIGNAL	n01lOO	:	STD_LOGIC := '0';
	 SIGNAL	n01O0i	:	STD_LOGIC := '0';
	 SIGNAL	n01O0l	:	STD_LOGIC := '0';
	 SIGNAL	n01O0O	:	STD_LOGIC := '0';
	 SIGNAL	n01O1i	:	STD_LOGIC := '0';
	 SIGNAL	n01O1l	:	STD_LOGIC := '0';
	 SIGNAL	n01O1O	:	STD_LOGIC := '0';
	 SIGNAL	n01Oii	:	STD_LOGIC := '0';
	 SIGNAL	n1lll	:	STD_LOGIC := '0';
	 SIGNAL	n1llO	:	STD_LOGIC := '0';
	 SIGNAL	n1O0Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1O0Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi1O	:	STD_LOGIC := '0';
	 SIGNAL	ni0i0i	:	STD_LOGIC := '0';
	 SIGNAL	ni0i0l	:	STD_LOGIC := '0';
	 SIGNAL	ni0i0O	:	STD_LOGIC := '0';
	 SIGNAL	ni0iii	:	STD_LOGIC := '0';
	 SIGNAL	ni0iil	:	STD_LOGIC := '0';
	 SIGNAL	ni0iiO	:	STD_LOGIC := '0';
	 SIGNAL	ni0ili	:	STD_LOGIC := '0';
	 SIGNAL	ni0lli	:	STD_LOGIC := '0';
	 SIGNAL	ni0lll	:	STD_LOGIC := '0';
	 SIGNAL	ni0llO	:	STD_LOGIC := '0';
	 SIGNAL	ni0lOi	:	STD_LOGIC := '0';
	 SIGNAL	ni0O0i	:	STD_LOGIC := '0';
	 SIGNAL	ni0O0l	:	STD_LOGIC := '0';
	 SIGNAL	ni0O0O	:	STD_LOGIC := '0';
	 SIGNAL	ni0Oii	:	STD_LOGIC := '0';
	 SIGNAL	ni1iOO	:	STD_LOGIC := '0';
	 SIGNAL	ni1l0i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l0l	:	STD_LOGIC := '0';
	 SIGNAL	ni1l0O	:	STD_LOGIC := '0';
	 SIGNAL	ni1l1i	:	STD_LOGIC := '0';
	 SIGNAL	ni1l1l	:	STD_LOGIC := '0';
	 SIGNAL	ni1l1O	:	STD_LOGIC := '0';
	 SIGNAL	ni1lii	:	STD_LOGIC := '0';
	 SIGNAL	nii00O	:	STD_LOGIC := '0';
	 SIGNAL	nii0ii	:	STD_LOGIC := '0';
	 SIGNAL	nii0il	:	STD_LOGIC := '0';
	 SIGNAL	nii0iO	:	STD_LOGIC := '0';
	 SIGNAL	nii0li	:	STD_LOGIC := '0';
	 SIGNAL	nii0ll	:	STD_LOGIC := '0';
	 SIGNAL	nii0lO	:	STD_LOGIC := '0';
	 SIGNAL	nii0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nii0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nii0OO	:	STD_LOGIC := '0';
	 SIGNAL	niii0i	:	STD_LOGIC := '0';
	 SIGNAL	niii0l	:	STD_LOGIC := '0';
	 SIGNAL	niii1i	:	STD_LOGIC := '0';
	 SIGNAL	niii1l	:	STD_LOGIC := '0';
	 SIGNAL	niii1O	:	STD_LOGIC := '0';
	 SIGNAL	niil0O	:	STD_LOGIC := '0';
	 SIGNAL	niilii	:	STD_LOGIC := '0';
	 SIGNAL	niilil	:	STD_LOGIC := '0';
	 SIGNAL	niiliO	:	STD_LOGIC := '0';
	 SIGNAL	niilli	:	STD_LOGIC := '0';
	 SIGNAL	niilll	:	STD_LOGIC := '0';
	 SIGNAL	niillO	:	STD_LOGIC := '0';
	 SIGNAL	niilOi	:	STD_LOGIC := '0';
	 SIGNAL	niilOl	:	STD_LOGIC := '0';
	 SIGNAL	niilOO	:	STD_LOGIC := '0';
	 SIGNAL	niiO0i	:	STD_LOGIC := '0';
	 SIGNAL	niiO1i	:	STD_LOGIC := '0';
	 SIGNAL	niiO1l	:	STD_LOGIC := '0';
	 SIGNAL	niiO1O	:	STD_LOGIC := '0';
	 SIGNAL	nil0i	:	STD_LOGIC := '0';
	 SIGNAL	nil0l	:	STD_LOGIC := '0';
	 SIGNAL	nil0O	:	STD_LOGIC := '0';
	 SIGNAL	nilii	:	STD_LOGIC := '0';
	 SIGNAL	nilil	:	STD_LOGIC := '0';
	 SIGNAL	niliO	:	STD_LOGIC := '0';
	 SIGNAL	nilli	:	STD_LOGIC := '0';
	 SIGNAL	nilll	:	STD_LOGIC := '0';
	 SIGNAL	nillO	:	STD_LOGIC := '0';
	 SIGNAL	nilOl	:	STD_LOGIC := '0';
	 SIGNAL	nlliOO	:	STD_LOGIC := '0';
	 SIGNAL	nlll0i	:	STD_LOGIC := '0';
	 SIGNAL	nlll0l	:	STD_LOGIC := '0';
	 SIGNAL	nlll0O	:	STD_LOGIC := '0';
	 SIGNAL	nlll1i	:	STD_LOGIC := '0';
	 SIGNAL	nlllii	:	STD_LOGIC := '0';
	 SIGNAL	nlllil	:	STD_LOGIC := '0';
	 SIGNAL	nllliO	:	STD_LOGIC := '0';
	 SIGNAL	nlllli	:	STD_LOGIC := '0';
	 SIGNAL	nlllll	:	STD_LOGIC := '0';
	 SIGNAL	nllllO	:	STD_LOGIC := '0';
	 SIGNAL	nlllOi	:	STD_LOGIC := '0';
	 SIGNAL	nlllOl	:	STD_LOGIC := '0';
	 SIGNAL	nlllOO	:	STD_LOGIC := '0';
	 SIGNAL	nllO0i	:	STD_LOGIC := '0';
	 SIGNAL	nllO0l	:	STD_LOGIC := '0';
	 SIGNAL	nllO0O	:	STD_LOGIC := '0';
	 SIGNAL	nllO1i	:	STD_LOGIC := '0';
	 SIGNAL	nllO1l	:	STD_LOGIC := '0';
	 SIGNAL	nllO1O	:	STD_LOGIC := '0';
	 SIGNAL	nllOii	:	STD_LOGIC := '0';
	 SIGNAL	nllOil	:	STD_LOGIC := '0';
	 SIGNAL	nllOiO	:	STD_LOGIC := '0';
	 SIGNAL	nllOli	:	STD_LOGIC := '0';
	 SIGNAL	nllOll	:	STD_LOGIC := '0';
	 SIGNAL	nllOlO	:	STD_LOGIC := '0';
	 SIGNAL	nllOOi	:	STD_LOGIC := '0';
	 SIGNAL	nllOOl	:	STD_LOGIC := '0';
	 SIGNAL	nllOOO	:	STD_LOGIC := '0';
	 SIGNAL	nlO01i	:	STD_LOGIC := '0';
	 SIGNAL	nlO01l	:	STD_LOGIC := '0';
	 SIGNAL	nlO10i	:	STD_LOGIC := '0';
	 SIGNAL	nlO10l	:	STD_LOGIC := '0';
	 SIGNAL	nlO10O	:	STD_LOGIC := '0';
	 SIGNAL	nlO11i	:	STD_LOGIC := '0';
	 SIGNAL	nlO11l	:	STD_LOGIC := '0';
	 SIGNAL	nlO11O	:	STD_LOGIC := '0';
	 SIGNAL	nlO1ii	:	STD_LOGIC := '0';
	 SIGNAL	nlO1il	:	STD_LOGIC := '0';
	 SIGNAL	nlO1iO	:	STD_LOGIC := '0';
	 SIGNAL	nlO1li	:	STD_LOGIC := '0';
	 SIGNAL	nlO1ll	:	STD_LOGIC := '0';
	 SIGNAL	nlO1lO	:	STD_LOGIC := '0';
	 SIGNAL	nlO1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlO1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nlO1OO	:	STD_LOGIC := '0';
	 SIGNAL	nlOOiO	:	STD_LOGIC := '0';
	 SIGNAL  wire_nilOi_w_lg_w_lg_w_lg_niliO1606w1607w1608w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_w_lg_nilli1593w1603w1604w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_w_lg_nlO01i832w2292w2293w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_niliO1606w1607w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_niliO1599w1600w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nilli1593w1603w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nilll1596w1597w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO01i832w833w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO01i832w2292w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO01l831w2352w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO01l831w2347w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO01l831w2328w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO01l831w2325w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO1iO2379w2381w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO1iO2379w2417w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO1ll2388w2444w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO1ll2388w2439w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO1ll2388w2427w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO1ll2388w2424w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO1lO801w2402w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO1lO801w802w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO1Oi2387w2408w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO1OO2261w2331w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO1OO2261w2266w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO1OO2261w2262w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlO1OO2261w2315w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nlOOiO830w2276w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_n01Oii2650w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_n1O0Oi824w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nil0i2236w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_niliO1606w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_niliO1599w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nilli1593w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nilll1596w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlll1i804w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO01i2300w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO01i812w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO01i837w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO01i2294w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO01l2332w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO01l2358w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO01l2301w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO01l838w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO01l2355w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1iO2416w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1ll2382w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1ll2450w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1ll2447w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1lO2445w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1lO2440w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1lO2428w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1lO2425w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1lO2383w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1lO2451w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1lO2448w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1Oi2407w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1OO2314w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1OO811w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlOOiO2353w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlOOiO2348w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlOOiO2329w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlOOiO2326w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlOOiO2333w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlOOiO2359w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlOOiO839w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlOOiO2356w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_w_lg_w_lg_niliO1523w1524w1525w1526w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_w_lg_niliO1514w1515w1516w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_nilli1506w1507w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_n01Oii2616w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_n1O0Ol2618w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_ni0Oii1865w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nii0il1996w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nii0iO2002w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_niilil1997w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nil0i1917w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nil0l1910w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nil0O1905w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nilii1903w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nilil1901w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_niliO1899w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nilli1908w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nilll1925w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nillO1927w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nilOl2210w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlliOO2589w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlll0i2615w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlll1i791w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO01i832w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO01l831w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1iO2379w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1li2380w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1ll2388w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1lO801w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1Oi2387w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1Ol2386w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlO1OO2261w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nlOOiO830w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_w_lg_niliO1523w1524w1525w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_niliO1523w1524w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_w_lg_niliO1514w1515w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_niliO1523w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_niliO1514w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nilOi_w_lg_nilli1506w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nilOO	:	STD_LOGIC := '0';
	 SIGNAL	niO1i	:	STD_LOGIC := '0';
	 SIGNAL	niO1l	:	STD_LOGIC := '0';
	 SIGNAL	nl1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nlliOl	:	STD_LOGIC := '0';
	 SIGNAL	n1O0ll	:	STD_LOGIC := '0';
	 SIGNAL	nlill	:	STD_LOGIC := '0';
	 SIGNAL	nllili	:	STD_LOGIC := '0';
	 SIGNAL	nllill	:	STD_LOGIC := '0';
	 SIGNAL	nllilO	:	STD_LOGIC := '0';
	 SIGNAL	nlliOi	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlili_w_lg_w_lg_w_lg_nlliOi309w310w311w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlili_w_lg_w_lg_nlliOi309w310w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nlili_w_lg_nlliOi309w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n1O0iO	:	STD_LOGIC := '0';
	 SIGNAL	n1O0li	:	STD_LOGIC := '0';
	 SIGNAL	ni1iOl	:	STD_LOGIC := '0';
	 SIGNAL	nlliiO	:	STD_LOGIC := '0';
	 SIGNAL  wire_nlliil_w_lg_nlliiO2590w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n00O0i	:	STD_LOGIC := '0';
	 SIGNAL	n00O0l	:	STD_LOGIC := '0';
	 SIGNAL	n00O0O	:	STD_LOGIC := '0';
	 SIGNAL	n00O1l	:	STD_LOGIC := '0';
	 SIGNAL	n00O1O	:	STD_LOGIC := '0';
	 SIGNAL	n00Oii	:	STD_LOGIC := '0';
	 SIGNAL	n00Oil	:	STD_LOGIC := '0';
	 SIGNAL	n00OiO	:	STD_LOGIC := '0';
	 SIGNAL	n00Oli	:	STD_LOGIC := '0';
	 SIGNAL	n00Oll	:	STD_LOGIC := '0';
	 SIGNAL	n00OlO	:	STD_LOGIC := '0';
	 SIGNAL	n00OOi	:	STD_LOGIC := '0';
	 SIGNAL	n00OOl	:	STD_LOGIC := '0';
	 SIGNAL	n00OOO	:	STD_LOGIC := '0';
	 SIGNAL	n01Oil	:	STD_LOGIC := '0';
	 SIGNAL	n01OiO	:	STD_LOGIC := '0';
	 SIGNAL	n01Oli	:	STD_LOGIC := '0';
	 SIGNAL	n0i00i	:	STD_LOGIC := '0';
	 SIGNAL	n0i00l	:	STD_LOGIC := '0';
	 SIGNAL	n0i00O	:	STD_LOGIC := '0';
	 SIGNAL	n0i0ii	:	STD_LOGIC := '0';
	 SIGNAL	n0i0il	:	STD_LOGIC := '0';
	 SIGNAL	n0i0iO	:	STD_LOGIC := '0';
	 SIGNAL	n0i0li	:	STD_LOGIC := '0';
	 SIGNAL	n0i0ll	:	STD_LOGIC := '0';
	 SIGNAL	n0i11i	:	STD_LOGIC := '0';
	 SIGNAL	n0i11l	:	STD_LOGIC := '0';
	 SIGNAL	n10li	:	STD_LOGIC := '0';
	 SIGNAL	n10ll	:	STD_LOGIC := '0';
	 SIGNAL	n10lO	:	STD_LOGIC := '0';
	 SIGNAL	n10Oi	:	STD_LOGIC := '0';
	 SIGNAL	n10OO	:	STD_LOGIC := '0';
	 SIGNAL	n111i	:	STD_LOGIC := '0';
	 SIGNAL	n111l	:	STD_LOGIC := '0';
	 SIGNAL	n111O	:	STD_LOGIC := '0';
	 SIGNAL	n1l0i	:	STD_LOGIC := '0';
	 SIGNAL	n1l0l	:	STD_LOGIC := '0';
	 SIGNAL	n1l0O	:	STD_LOGIC := '0';
	 SIGNAL	n1l1O	:	STD_LOGIC := '0';
	 SIGNAL	n1lii	:	STD_LOGIC := '0';
	 SIGNAL	n1lil	:	STD_LOGIC := '0';
	 SIGNAL	n1liO	:	STD_LOGIC := '0';
	 SIGNAL	n1lli	:	STD_LOGIC := '0';
	 SIGNAL	n1lOi	:	STD_LOGIC := '0';
	 SIGNAL	n1O0lO	:	STD_LOGIC := '0';
	 SIGNAL	niO0i	:	STD_LOGIC := '0';
	 SIGNAL	niO0l	:	STD_LOGIC := '0';
	 SIGNAL	niO0O	:	STD_LOGIC := '0';
	 SIGNAL	niO1O	:	STD_LOGIC := '0';
	 SIGNAL	niOii	:	STD_LOGIC := '0';
	 SIGNAL	niOil	:	STD_LOGIC := '0';
	 SIGNAL	niOiO	:	STD_LOGIC := '0';
	 SIGNAL	niOli	:	STD_LOGIC := '0';
	 SIGNAL	niOll	:	STD_LOGIC := '0';
	 SIGNAL	niOlO	:	STD_LOGIC := '0';
	 SIGNAL	niOOi	:	STD_LOGIC := '0';
	 SIGNAL	niOOl	:	STD_LOGIC := '0';
	 SIGNAL	niOOO	:	STD_LOGIC := '0';
	 SIGNAL	nl10i	:	STD_LOGIC := '0';
	 SIGNAL	nl10l	:	STD_LOGIC := '0';
	 SIGNAL	nl10O	:	STD_LOGIC := '0';
	 SIGNAL	nl11i	:	STD_LOGIC := '0';
	 SIGNAL	nl11l	:	STD_LOGIC := '0';
	 SIGNAL	nl11O	:	STD_LOGIC := '0';
	 SIGNAL	nl1ii	:	STD_LOGIC := '0';
	 SIGNAL	nl1il	:	STD_LOGIC := '0';
	 SIGNAL	nl1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl1li	:	STD_LOGIC := '0';
	 SIGNAL	nl1ll	:	STD_LOGIC := '0';
	 SIGNAL	nlilO	:	STD_LOGIC := '0';
	 SIGNAL	nlllO	:	STD_LOGIC := '0';
	 SIGNAL	nlOOli	:	STD_LOGIC := '0';
	 SIGNAL	nlOOll	:	STD_LOGIC := '0';
	 SIGNAL	nlOOlO	:	STD_LOGIC := '0';
	 SIGNAL	nlOOOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOOOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOOOO	:	STD_LOGIC := '0';
	 SIGNAL  wire_nllll_w_lg_w_lg_w_lg_n1l0l154w159w162w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_w_lg_n0i00i164w167w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_w_lg_n0i11i182w185w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_w_lg_n1l0l203w206w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_w_lg_n1l0l169w172w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_w_lg_n1l0l154w159w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n00O0i248w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n00O0O240w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n00Oil232w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n00Oli224w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n00OlO216w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n00OOl201w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n0i00i164w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n0i11i182w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n1l0l242w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n1l0l234w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n1l0l250w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n1l0l226w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n1l0l218w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n1l0l203w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n1l0l187w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n1l0l169w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n00O0l239w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n00O1O247w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n00Oii231w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n00OiO223w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n00Oll215w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n00OOi200w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n00OOO181w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n01Oli65w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n0i11l163w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n10lO349w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllll_w_lg_n1l0l154w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n000i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n000i_w_lg_dataout266w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n000ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n001i_w_lg_dataout263w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n001lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00ii_w_lg_dataout269w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n00ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00li_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00li_w_lg_dataout272w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n00liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00Oi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00Oi_w_lg_dataout275w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0100i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0100l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0100O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0101i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0101O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n010O_w_lg_dataout1428w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n010O_w_lg_w_lg_w268w271w274w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n010O_w_lg_w268w271w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n010O_w268w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n010O_w_lg_w_lg_w_lg_w_lg_dataout256w259w262w265w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n010O_w_lg_w_lg_w_lg_dataout256w259w262w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n010O_w_lg_w_lg_dataout256w259w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n010O_w_lg_dataout278w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n010O_w_lg_dataout256w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0110i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0110l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0111i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0111l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0111O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01il_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n01il_w_lg_dataout254w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n01ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01li_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n01li_w_lg_dataout257w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n01Oi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n01Oi_w_lg_dataout260w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1lO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0l1lO_w_lg_dataout814w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0l1lO_w_lg_dataout806w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oi1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oi1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni000l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni000O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni011i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ill_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0ill_w_lg_dataout2257w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni0ilO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0ilO_w_lg_dataout2255w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0iOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0iOl_w_lg_dataout2252w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni0iOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0iOO_w_lg_dataout2250w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni0l1i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0l1i_w_lg_dataout2248w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni0l1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0l1l_w_lg_dataout2246w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni0l1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni0l1O_w_lg_w2253w2254w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0l1O_w2253w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0l1O_w_lg_w_lg_w_lg_w_lg_dataout2245w2247w2249w2251w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0l1O_w_lg_w_lg_w_lg_dataout2245w2247w2249w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0l1O_w_lg_w_lg_dataout2245w2247w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni0l1O_w_lg_dataout2245w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii00l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nii00l_w_lg_dataout1871w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nii0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0101l_a	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0101l_b	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_n0101l_o	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n1ilO_a	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n1ilO_b	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n1ilO_o	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_ni0l0i_a	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_ni0l0i_b	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_ni0l0i_o	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_ni1llO_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1llO_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1llO_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1lOi_a	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_ni1lOi_b	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_ni1lOi_o	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n0001O_w_lg_w_o_range2561w2563w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0001O_i	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n0001O_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0001O_w_o_range2562w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0001O_w_o_range2561w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n000li_w_lg_w_o_range2544w2546w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n000li_i	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n000li_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n000li_w_o_range2545w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n000li_w_o_range2544w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n001ll_w_lg_w_o_range2578w2580w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n001ll_i	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n001ll_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n001ll_w_o_range2579w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n001ll_w_o_range2578w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i1l_w_lg_w_o_range2527w2529w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i1l_i	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n00i1l_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n00i1l_w_o_range2528w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00i1l_w_o_range2527w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00iiO_w_lg_w_o_range2510w2512w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00iiO_i	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n00iiO_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n00iiO_w_o_range2511w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00iiO_w_o_range2510w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l1i_w_lg_w_o_range2493w2495w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l1i_i	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n00l1i_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n00l1i_w_o_range2494w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00l1i_w_o_range2493w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00lil_w_lg_w_o_range2476w2478w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00lil_i	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n00lil_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n00lil_w_o_range2477w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00lil_w_o_range2476w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00lOO_w_lg_w_o_range2459w2461w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00lOO_i	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n00lOO_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n00lOO_w_o_range2460w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n00lOO_w_o_range2459w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n10iO_i	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_n10iO_o	:	STD_LOGIC_VECTOR (31 DOWNTO 0);
	 SIGNAL  wire_nlOOil_i	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_nlOOil_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni0O1O_a	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_ni0O1O_b	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_ni0O1O_o	:	STD_LOGIC;
	 SIGNAL  wire_n0001i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0001i_o	:	STD_LOGIC;
	 SIGNAL  wire_n0001i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n000il_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n000il_o	:	STD_LOGIC;
	 SIGNAL  wire_n000il_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n000OO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n000OO_o	:	STD_LOGIC;
	 SIGNAL  wire_n000OO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n001iO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n001iO_o	:	STD_LOGIC;
	 SIGNAL  wire_n001iO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n00iii_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n00iii_o	:	STD_LOGIC;
	 SIGNAL  wire_n00iii_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n00iOl_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n00iOl_o	:	STD_LOGIC;
	 SIGNAL  wire_n00iOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n00l0O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n00l0O_o	:	STD_LOGIC;
	 SIGNAL  wire_n00l0O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n00lOi_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n00lOi_o	:	STD_LOGIC;
	 SIGNAL  wire_n00lOi_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n100l_data	:	STD_LOGIC_VECTOR (10 DOWNTO 0);
	 SIGNAL  wire_n100l_o	:	STD_LOGIC;
	 SIGNAL  wire_n100l_sel	:	STD_LOGIC_VECTOR (10 DOWNTO 0);
	 SIGNAL  wire_n100O_data	:	STD_LOGIC_VECTOR (10 DOWNTO 0);
	 SIGNAL  wire_n100O_o	:	STD_LOGIC;
	 SIGNAL  wire_n100O_sel	:	STD_LOGIC_VECTOR (10 DOWNTO 0);
	 SIGNAL  wire_n110i_data	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n110i_o	:	STD_LOGIC;
	 SIGNAL  wire_n110i_sel	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n110l_data	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n110l_o	:	STD_LOGIC;
	 SIGNAL  wire_n110l_sel	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n110O_data	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n110O_o	:	STD_LOGIC;
	 SIGNAL  wire_n110O_sel	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n11ii_data	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n11ii_o	:	STD_LOGIC;
	 SIGNAL  wire_n11ii_sel	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n11il_data	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n11il_o	:	STD_LOGIC;
	 SIGNAL  wire_n11il_sel	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n11iO_data	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n11iO_o	:	STD_LOGIC;
	 SIGNAL  wire_n11iO_sel	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n11li_data	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n11li_o	:	STD_LOGIC;
	 SIGNAL  wire_n11li_sel	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n11ll_data	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n11ll_o	:	STD_LOGIC;
	 SIGNAL  wire_n11ll_sel	:	STD_LOGIC_VECTOR (11 DOWNTO 0);
	 SIGNAL  wire_n1Oi0i_data	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n1Oi0i_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oi0i_sel	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n1Oi0l_data	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n1Oi0l_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oi0l_sel	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_n1Oiii_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1Oiii_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oiii_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n1OiiO_data	:	STD_LOGIC_VECTOR (12 DOWNTO 0);
	 SIGNAL  wire_n1OiiO_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OiiO_sel	:	STD_LOGIC_VECTOR (12 DOWNTO 0);
	 SIGNAL  wire_n1Oili_data	:	STD_LOGIC_VECTOR (12 DOWNTO 0);
	 SIGNAL  wire_n1Oili_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oili_sel	:	STD_LOGIC_VECTOR (12 DOWNTO 0);
	 SIGNAL  wire_n1Oill_data	:	STD_LOGIC_VECTOR (12 DOWNTO 0);
	 SIGNAL  wire_n1Oill_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Oill_sel	:	STD_LOGIC_VECTOR (12 DOWNTO 0);
	 SIGNAL  wire_n1OilO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1OilO_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OilO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1OiOl_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1OiOl_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OiOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1Ol0l_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Ol0l_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Ol0l_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Ol1i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Ol1i_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Ol1i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Ol1O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1Ol1O_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Ol1O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1Olii_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Olii_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Olii_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OliO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1OliO_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OliO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1Olll_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1Olll_o	:	STD_LOGIC;
	 SIGNAL  wire_n1Olll_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n1OlOi_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1OlOi_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OlOi_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1OlOO_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n1OlOO_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OlOO_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n1OO1l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1OO1l_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OO1l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1OO1O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n1OO1O_o	:	STD_LOGIC;
	 SIGNAL  wire_n1OO1O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni010i_data	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_ni010i_o	:	STD_LOGIC;
	 SIGNAL  wire_ni010i_sel	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_ni010l_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni010l_o	:	STD_LOGIC;
	 SIGNAL  wire_ni010l_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni011l_data	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_ni011l_o	:	STD_LOGIC;
	 SIGNAL  wire_ni011l_sel	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_ni01ii_data	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni01ii_o	:	STD_LOGIC;
	 SIGNAL  wire_ni01ii_sel	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_ni1O0i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1O0i_o	:	STD_LOGIC;
	 SIGNAL  wire_ni1O0i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1O0l_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1O0l_o	:	STD_LOGIC;
	 SIGNAL  wire_ni1O0l_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1O0O_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1O0O_o	:	STD_LOGIC;
	 SIGNAL  wire_ni1O0O_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1Oii_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1Oii_o	:	STD_LOGIC;
	 SIGNAL  wire_ni1Oii_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1Oil_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_ni1Oil_o	:	STD_LOGIC;
	 SIGNAL  wire_ni1Oil_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_ni1OiO_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_ni1OiO_o	:	STD_LOGIC;
	 SIGNAL  wire_ni1OiO_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_ni1Oli_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_ni1Oli_o	:	STD_LOGIC;
	 SIGNAL  wire_ni1Oli_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_ni1Oll_data	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_ni1Oll_o	:	STD_LOGIC;
	 SIGNAL  wire_ni1Oll_sel	:	STD_LOGIC_VECTOR (4 DOWNTO 0);
	 SIGNAL  wire_nliOi_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOi_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOl_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nliOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nliOO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll1i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nll1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nll1i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOlOl_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOlOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOlOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOlOO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOlOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOlOO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOO0i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOO0i_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOO0i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOO0l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOO0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOO0l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOO0O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOO0O_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOO0O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOO1i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOO1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOO1i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOO1l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOO1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOO1l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOO1O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOO1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOO1O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_n1lO0O155w158w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_n1O1il46w47w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_GE_XAUI_SEL2627w2628w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_PMADATAWIDTH126w1849w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_PMADATAWIDTH126w1616w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_PMADATAWIDTH126w1816w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_PMADATAWIDTH126w1640w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_PMADATAWIDTH126w1632w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_PMADATAWIDTH126w1624w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_GE_XAUI_SEL2626w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11O1l2398w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11O1l2367w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11OlO2295w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iliO2299w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iOii796w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iOiO794w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1li0i241w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1li0O233w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1li1l249w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1liil225w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1lilO217w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1ll1O202w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1llll186w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1lO0O168w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1lO0O155w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1O1il46w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_PMADATAWIDTH1609w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_PMADATAWIDTH1601w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_PMADATAWIDTH1594w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_PMADATAWIDTH821w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_PMADATAWIDTH1527w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_PMADATAWIDTH1517w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_PMADATAWIDTH1508w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_PMADATAWIDTH1567w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_PMADATAWIDTH1557w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_PMADATAWIDTH1547w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_PMADATAWIDTH1537w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_PMADATAWIDTH2212w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_SYNC_SM_DIS820w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_SYNC_COMP_SIZE_range842w847w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_DISABLE_RX_DISP816w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_GE_XAUI_SEL2627w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1000i1853w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1000l1852w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1000O1824w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1001i1856w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1001l1855w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1001O1854w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n100ii1823w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n100il1822w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n100iO1821w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n100li1820w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n100ll1819w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n100lO1818w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1010i2023w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1010l2011w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1010O2005w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n101iO2000w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n101ll1974w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n101Ol1858w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n101OO1857w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10i0i1795w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10i0l1787w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10i0O1785w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10i1i1791w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10i1l1789w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10i1O1847w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10iii1793w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10ill1756w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10ilO1754w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10iOi1838w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10iOl1760w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10iOO1752w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10l0O1721w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10l1i1750w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10l1l1758w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10lii1719w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10lil1814w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10liO1725w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10lli1717w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10lll1715w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10llO1723w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10O0i1691w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10O0l1683w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10O0O1681w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10O1i1687w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10O1l1685w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10O1O1806w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10Oii1689w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10Oil2235w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10OiO1764w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10Oll1768w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10OlO1771w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10OOi1774w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10OOl1777w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10OOO1780w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11iiO2691w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11ill2647w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11ilO2646w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11iOi2634w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11iOO2621w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11l0i2624w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11l1O2669w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11lii2831w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11lil2649w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11liO2625w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11Oll2269w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i00i1745w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i00l1748w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i01O1742w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i0il2215w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i0iO1695w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i0li1587w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i0ll1700w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i0lO1703w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i0Oi1706w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i0Ol1709w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i0OO1712w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i10i1729w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i10O1832w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i11i1783w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i11l2225w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i1ii1841w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i1iO1733w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i1lO1736w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i1OO1739w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1ii0i1660w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1ii0l1571w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1ii0O1800w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1ii1l2201w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1ii1O1575w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iiii1566w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iiil1564w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iiiO1664w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iili1556w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iill1554w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iilO1667w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iiOi1546w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iiOl1544w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iiOO1670w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1il0i1676w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1il0l1679w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1il1i1536w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1il1l1534w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1il1O1673w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1illO826w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1l00i291w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1l00l289w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1l00O287w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1l01l294w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1l0ii285w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1l0il283w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1l0iO281w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1l0li279w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1l0ll277w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1l11l789w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1O10l48w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1O11l55w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1O1iO56w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1O1li53w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1O1Ol40w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_PMADATAWIDTH126w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rcvd_clk43w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_soft_reset44w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_SYNC_SM_DIS823w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_SYNC_COMP_SIZE_range844w845w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_PMADATAWIDTH126w1866w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_PMADATAWIDTH126w1866w1876w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_PMADATAWIDTH126w1866w1867w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w1877w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w1868w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w1877w1878w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w1868w1869w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w1877w1878w1879w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w1868w1869w1870w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w1877w1878w1879w1880w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w1868w1869w1870w1874w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w1776w1779w1782w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w1741w1744w1747w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w1672w1675w1678w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w1885w1890w1894w1897w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w1776w1779w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w1741w1744w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w1672w1675w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w1885w1890w1894w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w1776w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w1741w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w1672w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w1885w1890w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_n10Oil1766w1767w1770w1773w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_n1i11l1731w1732w1735w1738w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_n1ii1l1662w1663w1666w1669w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w1885w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_n10Oil1766w1767w1770w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_n1i11l1731w1732w1735w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_n1ii1l1662w1663w1666w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_n1iOlO793w795w797w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_PMADATAWIDTH1882w1883w1884w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_n10Oil1766w1767w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_n1i11l1731w1732w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_n1ii1l1662w1663w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_n1iO1O807w808w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_n1iOlO793w795w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_PMADATAWIDTH1882w1883w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10Oil1786w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10Oil1840w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10Oil1766w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11OiO2368w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11OiO2284w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11Oli2285w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11Oll2279w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i0il1716w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i0il1808w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i11l1751w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i11l1831w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1i11l1731w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1ii1l1682w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1ii1l1799w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1ii1l1662w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1ilil2280w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1ilOO813w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iO0l803w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iO1O807w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iOll2287w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iOll792w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iOlO793w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iOlO2286w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iOOi798w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iOOi2288w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1iOOl799w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_PMADATAWIDTH1882w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  n1000i :	STD_LOGIC;
	 SIGNAL  n1000l :	STD_LOGIC;
	 SIGNAL  n1000O :	STD_LOGIC;
	 SIGNAL  n1001i :	STD_LOGIC;
	 SIGNAL  n1001l :	STD_LOGIC;
	 SIGNAL  n1001O :	STD_LOGIC;
	 SIGNAL  n100ii :	STD_LOGIC;
	 SIGNAL  n100il :	STD_LOGIC;
	 SIGNAL  n100iO :	STD_LOGIC;
	 SIGNAL  n100li :	STD_LOGIC;
	 SIGNAL  n100ll :	STD_LOGIC;
	 SIGNAL  n100lO :	STD_LOGIC;
	 SIGNAL  n100Oi :	STD_LOGIC;
	 SIGNAL  n100Ol :	STD_LOGIC;
	 SIGNAL  n100OO :	STD_LOGIC;
	 SIGNAL  n1010i :	STD_LOGIC;
	 SIGNAL  n1010l :	STD_LOGIC;
	 SIGNAL  n1010O :	STD_LOGIC;
	 SIGNAL  n1011i :	STD_LOGIC;
	 SIGNAL  n1011l :	STD_LOGIC;
	 SIGNAL  n1011O :	STD_LOGIC;
	 SIGNAL  n101ii :	STD_LOGIC;
	 SIGNAL  n101il :	STD_LOGIC;
	 SIGNAL  n101iO :	STD_LOGIC;
	 SIGNAL  n101li :	STD_LOGIC;
	 SIGNAL  n101ll :	STD_LOGIC;
	 SIGNAL  n101lO :	STD_LOGIC;
	 SIGNAL  n101Oi :	STD_LOGIC;
	 SIGNAL  n101Ol :	STD_LOGIC;
	 SIGNAL  n101OO :	STD_LOGIC;
	 SIGNAL  n10i0i :	STD_LOGIC;
	 SIGNAL  n10i0l :	STD_LOGIC;
	 SIGNAL  n10i0O :	STD_LOGIC;
	 SIGNAL  n10i1i :	STD_LOGIC;
	 SIGNAL  n10i1l :	STD_LOGIC;
	 SIGNAL  n10i1O :	STD_LOGIC;
	 SIGNAL  n10iii :	STD_LOGIC;
	 SIGNAL  n10iil :	STD_LOGIC;
	 SIGNAL  n10iiO :	STD_LOGIC;
	 SIGNAL  n10ili :	STD_LOGIC;
	 SIGNAL  n10ill :	STD_LOGIC;
	 SIGNAL  n10ilO :	STD_LOGIC;
	 SIGNAL  n10iOi :	STD_LOGIC;
	 SIGNAL  n10iOl :	STD_LOGIC;
	 SIGNAL  n10iOO :	STD_LOGIC;
	 SIGNAL  n10l0i :	STD_LOGIC;
	 SIGNAL  n10l0l :	STD_LOGIC;
	 SIGNAL  n10l0O :	STD_LOGIC;
	 SIGNAL  n10l1i :	STD_LOGIC;
	 SIGNAL  n10l1l :	STD_LOGIC;
	 SIGNAL  n10l1O :	STD_LOGIC;
	 SIGNAL  n10lii :	STD_LOGIC;
	 SIGNAL  n10lil :	STD_LOGIC;
	 SIGNAL  n10liO :	STD_LOGIC;
	 SIGNAL  n10lli :	STD_LOGIC;
	 SIGNAL  n10lll :	STD_LOGIC;
	 SIGNAL  n10llO :	STD_LOGIC;
	 SIGNAL  n10lOi :	STD_LOGIC;
	 SIGNAL  n10lOl :	STD_LOGIC;
	 SIGNAL  n10lOO :	STD_LOGIC;
	 SIGNAL  n10O0i :	STD_LOGIC;
	 SIGNAL  n10O0l :	STD_LOGIC;
	 SIGNAL  n10O0O :	STD_LOGIC;
	 SIGNAL  n10O1i :	STD_LOGIC;
	 SIGNAL  n10O1l :	STD_LOGIC;
	 SIGNAL  n10O1O :	STD_LOGIC;
	 SIGNAL  n10Oii :	STD_LOGIC;
	 SIGNAL  n10Oil :	STD_LOGIC;
	 SIGNAL  n10OiO :	STD_LOGIC;
	 SIGNAL  n10Oli :	STD_LOGIC;
	 SIGNAL  n10Oll :	STD_LOGIC;
	 SIGNAL  n10OlO :	STD_LOGIC;
	 SIGNAL  n10OOi :	STD_LOGIC;
	 SIGNAL  n10OOl :	STD_LOGIC;
	 SIGNAL  n10OOO :	STD_LOGIC;
	 SIGNAL  n110Oi :	STD_LOGIC;
	 SIGNAL  n110Ol :	STD_LOGIC;
	 SIGNAL  n110OO :	STD_LOGIC;
	 SIGNAL  n11i0i :	STD_LOGIC;
	 SIGNAL  n11i0l :	STD_LOGIC;
	 SIGNAL  n11i0O :	STD_LOGIC;
	 SIGNAL  n11i1i :	STD_LOGIC;
	 SIGNAL  n11i1l :	STD_LOGIC;
	 SIGNAL  n11i1O :	STD_LOGIC;
	 SIGNAL  n11iii :	STD_LOGIC;
	 SIGNAL  n11iil :	STD_LOGIC;
	 SIGNAL  n11iiO :	STD_LOGIC;
	 SIGNAL  n11ili :	STD_LOGIC;
	 SIGNAL  n11ill :	STD_LOGIC;
	 SIGNAL  n11ilO :	STD_LOGIC;
	 SIGNAL  n11iOi :	STD_LOGIC;
	 SIGNAL  n11iOl :	STD_LOGIC;
	 SIGNAL  n11iOO :	STD_LOGIC;
	 SIGNAL  n11l0i :	STD_LOGIC;
	 SIGNAL  n11l0l :	STD_LOGIC;
	 SIGNAL  n11l0O :	STD_LOGIC;
	 SIGNAL  n11l1i :	STD_LOGIC;
	 SIGNAL  n11l1l :	STD_LOGIC;
	 SIGNAL  n11l1O :	STD_LOGIC;
	 SIGNAL  n11lii :	STD_LOGIC;
	 SIGNAL  n11lil :	STD_LOGIC;
	 SIGNAL  n11liO :	STD_LOGIC;
	 SIGNAL  n11lli :	STD_LOGIC;
	 SIGNAL  n11lll :	STD_LOGIC;
	 SIGNAL  n11llO :	STD_LOGIC;
	 SIGNAL  n11lOi :	STD_LOGIC;
	 SIGNAL  n11lOl :	STD_LOGIC;
	 SIGNAL  n11lOO :	STD_LOGIC;
	 SIGNAL  n11O0i :	STD_LOGIC;
	 SIGNAL  n11O0l :	STD_LOGIC;
	 SIGNAL  n11O0O :	STD_LOGIC;
	 SIGNAL  n11O1i :	STD_LOGIC;
	 SIGNAL  n11O1l :	STD_LOGIC;
	 SIGNAL  n11O1O :	STD_LOGIC;
	 SIGNAL  n11Oii :	STD_LOGIC;
	 SIGNAL  n11Oil :	STD_LOGIC;
	 SIGNAL  n11OiO :	STD_LOGIC;
	 SIGNAL  n11Oli :	STD_LOGIC;
	 SIGNAL  n11Oll :	STD_LOGIC;
	 SIGNAL  n11OlO :	STD_LOGIC;
	 SIGNAL  n11OOi :	STD_LOGIC;
	 SIGNAL  n11OOl :	STD_LOGIC;
	 SIGNAL  n11OOO :	STD_LOGIC;
	 SIGNAL  n1i00i :	STD_LOGIC;
	 SIGNAL  n1i00l :	STD_LOGIC;
	 SIGNAL  n1i00O :	STD_LOGIC;
	 SIGNAL  n1i01i :	STD_LOGIC;
	 SIGNAL  n1i01l :	STD_LOGIC;
	 SIGNAL  n1i01O :	STD_LOGIC;
	 SIGNAL  n1i0ii :	STD_LOGIC;
	 SIGNAL  n1i0il :	STD_LOGIC;
	 SIGNAL  n1i0iO :	STD_LOGIC;
	 SIGNAL  n1i0li :	STD_LOGIC;
	 SIGNAL  n1i0ll :	STD_LOGIC;
	 SIGNAL  n1i0lO :	STD_LOGIC;
	 SIGNAL  n1i0Oi :	STD_LOGIC;
	 SIGNAL  n1i0Ol :	STD_LOGIC;
	 SIGNAL  n1i0OO :	STD_LOGIC;
	 SIGNAL  n1i10i :	STD_LOGIC;
	 SIGNAL  n1i10l :	STD_LOGIC;
	 SIGNAL  n1i10O :	STD_LOGIC;
	 SIGNAL  n1i11i :	STD_LOGIC;
	 SIGNAL  n1i11l :	STD_LOGIC;
	 SIGNAL  n1i11O :	STD_LOGIC;
	 SIGNAL  n1i1ii :	STD_LOGIC;
	 SIGNAL  n1i1il :	STD_LOGIC;
	 SIGNAL  n1i1iO :	STD_LOGIC;
	 SIGNAL  n1i1li :	STD_LOGIC;
	 SIGNAL  n1i1ll :	STD_LOGIC;
	 SIGNAL  n1i1lO :	STD_LOGIC;
	 SIGNAL  n1i1Oi :	STD_LOGIC;
	 SIGNAL  n1i1Ol :	STD_LOGIC;
	 SIGNAL  n1i1OO :	STD_LOGIC;
	 SIGNAL  n1ii0i :	STD_LOGIC;
	 SIGNAL  n1ii0l :	STD_LOGIC;
	 SIGNAL  n1ii0O :	STD_LOGIC;
	 SIGNAL  n1ii1i :	STD_LOGIC;
	 SIGNAL  n1ii1l :	STD_LOGIC;
	 SIGNAL  n1ii1O :	STD_LOGIC;
	 SIGNAL  n1iiii :	STD_LOGIC;
	 SIGNAL  n1iiil :	STD_LOGIC;
	 SIGNAL  n1iiiO :	STD_LOGIC;
	 SIGNAL  n1iili :	STD_LOGIC;
	 SIGNAL  n1iill :	STD_LOGIC;
	 SIGNAL  n1iilO :	STD_LOGIC;
	 SIGNAL  n1iiOi :	STD_LOGIC;
	 SIGNAL  n1iiOl :	STD_LOGIC;
	 SIGNAL  n1iiOO :	STD_LOGIC;
	 SIGNAL  n1il0i :	STD_LOGIC;
	 SIGNAL  n1il0l :	STD_LOGIC;
	 SIGNAL  n1il0O :	STD_LOGIC;
	 SIGNAL  n1il1i :	STD_LOGIC;
	 SIGNAL  n1il1l :	STD_LOGIC;
	 SIGNAL  n1il1O :	STD_LOGIC;
	 SIGNAL  n1ilii :	STD_LOGIC;
	 SIGNAL  n1ilil :	STD_LOGIC;
	 SIGNAL  n1iliO :	STD_LOGIC;
	 SIGNAL  n1illi :	STD_LOGIC;
	 SIGNAL  n1illl :	STD_LOGIC;
	 SIGNAL  n1illO :	STD_LOGIC;
	 SIGNAL  n1ilOi :	STD_LOGIC;
	 SIGNAL  n1ilOl :	STD_LOGIC;
	 SIGNAL  n1ilOO :	STD_LOGIC;
	 SIGNAL  n1iO0i :	STD_LOGIC;
	 SIGNAL  n1iO0l :	STD_LOGIC;
	 SIGNAL  n1iO0O :	STD_LOGIC;
	 SIGNAL  n1iO1i :	STD_LOGIC;
	 SIGNAL  n1iO1l :	STD_LOGIC;
	 SIGNAL  n1iO1O :	STD_LOGIC;
	 SIGNAL  n1iOii :	STD_LOGIC;
	 SIGNAL  n1iOil :	STD_LOGIC;
	 SIGNAL  n1iOiO :	STD_LOGIC;
	 SIGNAL  n1iOli :	STD_LOGIC;
	 SIGNAL  n1iOll :	STD_LOGIC;
	 SIGNAL  n1iOlO :	STD_LOGIC;
	 SIGNAL  n1iOOi :	STD_LOGIC;
	 SIGNAL  n1iOOl :	STD_LOGIC;
	 SIGNAL  n1iOOO :	STD_LOGIC;
	 SIGNAL  n1l00i :	STD_LOGIC;
	 SIGNAL  n1l00l :	STD_LOGIC;
	 SIGNAL  n1l00O :	STD_LOGIC;
	 SIGNAL  n1l01i :	STD_LOGIC;
	 SIGNAL  n1l01l :	STD_LOGIC;
	 SIGNAL  n1l01O :	STD_LOGIC;
	 SIGNAL  n1l0ii :	STD_LOGIC;
	 SIGNAL  n1l0il :	STD_LOGIC;
	 SIGNAL  n1l0iO :	STD_LOGIC;
	 SIGNAL  n1l0li :	STD_LOGIC;
	 SIGNAL  n1l0ll :	STD_LOGIC;
	 SIGNAL  n1l0lO :	STD_LOGIC;
	 SIGNAL  n1l0Oi :	STD_LOGIC;
	 SIGNAL  n1l0Ol :	STD_LOGIC;
	 SIGNAL  n1l0OO :	STD_LOGIC;
	 SIGNAL  n1l10i :	STD_LOGIC;
	 SIGNAL  n1l10l :	STD_LOGIC;
	 SIGNAL  n1l10O :	STD_LOGIC;
	 SIGNAL  n1l11i :	STD_LOGIC;
	 SIGNAL  n1l11l :	STD_LOGIC;
	 SIGNAL  n1l11O :	STD_LOGIC;
	 SIGNAL  n1l1ii :	STD_LOGIC;
	 SIGNAL  n1l1il :	STD_LOGIC;
	 SIGNAL  n1l1iO :	STD_LOGIC;
	 SIGNAL  n1l1li :	STD_LOGIC;
	 SIGNAL  n1l1ll :	STD_LOGIC;
	 SIGNAL  n1l1lO :	STD_LOGIC;
	 SIGNAL  n1l1Oi :	STD_LOGIC;
	 SIGNAL  n1l1Ol :	STD_LOGIC;
	 SIGNAL  n1l1OO :	STD_LOGIC;
	 SIGNAL  n1li0i :	STD_LOGIC;
	 SIGNAL  n1li0l :	STD_LOGIC;
	 SIGNAL  n1li0O :	STD_LOGIC;
	 SIGNAL  n1li1i :	STD_LOGIC;
	 SIGNAL  n1li1l :	STD_LOGIC;
	 SIGNAL  n1li1O :	STD_LOGIC;
	 SIGNAL  n1liii :	STD_LOGIC;
	 SIGNAL  n1liil :	STD_LOGIC;
	 SIGNAL  n1lill :	STD_LOGIC;
	 SIGNAL  n1lilO :	STD_LOGIC;
	 SIGNAL  n1ll1l :	STD_LOGIC;
	 SIGNAL  n1ll1O :	STD_LOGIC;
	 SIGNAL  n1llli :	STD_LOGIC;
	 SIGNAL  n1llll :	STD_LOGIC;
	 SIGNAL  n1lO0l :	STD_LOGIC;
	 SIGNAL  n1lO0O :	STD_LOGIC;
	 SIGNAL  n1lOii :	STD_LOGIC;
	 SIGNAL  n1lOil :	STD_LOGIC;
	 SIGNAL  n1lOiO :	STD_LOGIC;
	 SIGNAL  n1O0ii :	STD_LOGIC;
	 SIGNAL  n1O10l :	STD_LOGIC;
	 SIGNAL  n1O10O :	STD_LOGIC;
	 SIGNAL  n1O11l :	STD_LOGIC;
	 SIGNAL  n1O1ii :	STD_LOGIC;
	 SIGNAL  n1O1il :	STD_LOGIC;
	 SIGNAL  n1O1iO :	STD_LOGIC;
	 SIGNAL  n1O1li :	STD_LOGIC;
	 SIGNAL  n1O1ll :	STD_LOGIC;
	 SIGNAL  n1O1lO :	STD_LOGIC;
	 SIGNAL  n1O1Oi :	STD_LOGIC;
	 SIGNAL  n1O1Ol :	STD_LOGIC;
	 SIGNAL  n1O1OO :	STD_LOGIC;
	 SIGNAL  wire_w_SYNC_COMP_SIZE_range842w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_SYNC_COMP_SIZE_range844w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_gnd <= '0';
	wire_w_lg_w_lg_n1lO0O155w158w(0) <= wire_w_lg_n1lO0O155w(0) AND n1lO1O32;
	wire_w_lg_w_lg_n1O1il46w47w(0) <= wire_w_lg_n1O1il46w(0) AND n1O10O;
	wire_w_lg_w_lg_GE_XAUI_SEL2627w2628w(0) <= wire_w_lg_GE_XAUI_SEL2627w(0) AND nlliiO;
	wire_w_lg_w_lg_PMADATAWIDTH126w1849w(0) <= wire_w_lg_PMADATAWIDTH126w(0) AND n10Oil;
	wire_w_lg_w_lg_PMADATAWIDTH126w1616w(0) <= wire_w_lg_PMADATAWIDTH126w(0) AND n1i01l;
	wire_w_lg_w_lg_PMADATAWIDTH126w1816w(0) <= wire_w_lg_PMADATAWIDTH126w(0) AND n1i0il;
	wire_w_lg_w_lg_PMADATAWIDTH126w1640w(0) <= wire_w_lg_PMADATAWIDTH126w(0) AND n1i1il;
	wire_w_lg_w_lg_PMADATAWIDTH126w1632w(0) <= wire_w_lg_PMADATAWIDTH126w(0) AND n1i1ll;
	wire_w_lg_w_lg_PMADATAWIDTH126w1624w(0) <= wire_w_lg_PMADATAWIDTH126w(0) AND n1i1Ol;
	wire_w_lg_GE_XAUI_SEL2626w(0) <= GE_XAUI_SEL AND wire_w_lg_n11liO2625w(0);
	wire_w_lg_n11O1l2398w(0) <= n11O1l AND wire_n0l1lO_w_lg_dataout806w(0);
	wire_w_lg_n11O1l2367w(0) <= n11O1l AND n1iOiO;
	wire_w_lg_n11OlO2295w(0) <= n11OlO AND wire_nilOi_w_lg_nlO01i2294w(0);
	wire_w_lg_n1iliO2299w(0) <= n1iliO AND n1ilOl;
	wire_w_lg_n1iOii796w(0) <= n1iOii AND n1iO0O;
	wire_w_lg_n1iOiO794w(0) <= n1iOiO AND n1iOil;
	wire_w_lg_n1li0i241w(0) <= n1li0i AND wire_nllll_w_lg_n00O0O240w(0);
	wire_w_lg_n1li0O233w(0) <= n1li0O AND wire_nllll_w_lg_n00Oil232w(0);
	wire_w_lg_n1li1l249w(0) <= n1li1l AND wire_nllll_w_lg_n00O0i248w(0);
	wire_w_lg_n1liil225w(0) <= n1liil AND wire_nllll_w_lg_n00Oli224w(0);
	wire_w_lg_n1lilO217w(0) <= n1lilO AND wire_nllll_w_lg_n00OlO216w(0);
	wire_w_lg_n1ll1O202w(0) <= n1ll1O AND wire_nllll_w_lg_n00OOl201w(0);
	wire_w_lg_n1llll186w(0) <= n1llll AND wire_nllll_w_lg_w_lg_n0i11i182w185w(0);
	wire_w_lg_n1lO0O168w(0) <= n1lO0O AND wire_nllll_w_lg_w_lg_n0i00i164w167w(0);
	wire_w_lg_n1lO0O155w(0) <= n1lO0O AND n0i00l;
	wire_w_lg_n1O1il46w(0) <= n1O1il AND n1O1ii;
	wire_w_lg_PMADATAWIDTH1609w(0) <= PMADATAWIDTH AND wire_nilOi_w_lg_w_lg_w_lg_niliO1606w1607w1608w(0);
	wire_w_lg_PMADATAWIDTH1601w(0) <= PMADATAWIDTH AND wire_nilOi_w_lg_w_lg_niliO1599w1600w(0);
	wire_w_lg_PMADATAWIDTH1594w(0) <= PMADATAWIDTH AND wire_nilOi_w_lg_nilli1593w(0);
	wire_w_lg_PMADATAWIDTH821w(0) <= PMADATAWIDTH AND wire_w_lg_SYNC_SM_DIS820w(0);
	wire_w_lg_PMADATAWIDTH1527w(0) <= PMADATAWIDTH AND wire_nilOi_w_lg_w_lg_w_lg_w_lg_niliO1523w1524w1525w1526w(0);
	wire_w_lg_PMADATAWIDTH1517w(0) <= PMADATAWIDTH AND wire_nilOi_w_lg_w_lg_w_lg_niliO1514w1515w1516w(0);
	wire_w_lg_PMADATAWIDTH1508w(0) <= PMADATAWIDTH AND wire_nilOi_w_lg_w_lg_nilli1506w1507w(0);
	wire_w_lg_PMADATAWIDTH1567w(0) <= PMADATAWIDTH AND wire_w_lg_n1iiii1566w(0);
	wire_w_lg_PMADATAWIDTH1557w(0) <= PMADATAWIDTH AND wire_w_lg_n1iili1556w(0);
	wire_w_lg_PMADATAWIDTH1547w(0) <= PMADATAWIDTH AND wire_w_lg_n1iiOi1546w(0);
	wire_w_lg_PMADATAWIDTH1537w(0) <= PMADATAWIDTH AND wire_w_lg_n1il1i1536w(0);
	wire_w_lg_PMADATAWIDTH2212w(0) <= PMADATAWIDTH AND wire_nilOi_w_lg_nilll1925w(0);
	wire_w_lg_SYNC_SM_DIS820w(0) <= SYNC_SM_DIS AND nlll0l;
	wire_w_lg_w_SYNC_COMP_SIZE_range842w847w(0) <= wire_w_SYNC_COMP_SIZE_range842w(0) AND wire_w_lg_w_SYNC_COMP_SIZE_range844w845w(0);
	wire_w_lg_DISABLE_RX_DISP816w(0) <= NOT DISABLE_RX_DISP;
	wire_w_lg_GE_XAUI_SEL2627w(0) <= NOT GE_XAUI_SEL;
	wire_w_lg_n1000i1853w(0) <= NOT n1000i;
	wire_w_lg_n1000l1852w(0) <= NOT n1000l;
	wire_w_lg_n1000O1824w(0) <= NOT n1000O;
	wire_w_lg_n1001i1856w(0) <= NOT n1001i;
	wire_w_lg_n1001l1855w(0) <= NOT n1001l;
	wire_w_lg_n1001O1854w(0) <= NOT n1001O;
	wire_w_lg_n100ii1823w(0) <= NOT n100ii;
	wire_w_lg_n100il1822w(0) <= NOT n100il;
	wire_w_lg_n100iO1821w(0) <= NOT n100iO;
	wire_w_lg_n100li1820w(0) <= NOT n100li;
	wire_w_lg_n100ll1819w(0) <= NOT n100ll;
	wire_w_lg_n100lO1818w(0) <= NOT n100lO;
	wire_w_lg_n1010i2023w(0) <= NOT n1010i;
	wire_w_lg_n1010l2011w(0) <= NOT n1010l;
	wire_w_lg_n1010O2005w(0) <= NOT n1010O;
	wire_w_lg_n101iO2000w(0) <= NOT n101iO;
	wire_w_lg_n101ll1974w(0) <= NOT n101ll;
	wire_w_lg_n101Ol1858w(0) <= NOT n101Ol;
	wire_w_lg_n101OO1857w(0) <= NOT n101OO;
	wire_w_lg_n10i0i1795w(0) <= NOT n10i0i;
	wire_w_lg_n10i0l1787w(0) <= NOT n10i0l;
	wire_w_lg_n10i0O1785w(0) <= NOT n10i0O;
	wire_w_lg_n10i1i1791w(0) <= NOT n10i1i;
	wire_w_lg_n10i1l1789w(0) <= NOT n10i1l;
	wire_w_lg_n10i1O1847w(0) <= NOT n10i1O;
	wire_w_lg_n10iii1793w(0) <= NOT n10iii;
	wire_w_lg_n10ill1756w(0) <= NOT n10ill;
	wire_w_lg_n10ilO1754w(0) <= NOT n10ilO;
	wire_w_lg_n10iOi1838w(0) <= NOT n10iOi;
	wire_w_lg_n10iOl1760w(0) <= NOT n10iOl;
	wire_w_lg_n10iOO1752w(0) <= NOT n10iOO;
	wire_w_lg_n10l0O1721w(0) <= NOT n10l0O;
	wire_w_lg_n10l1i1750w(0) <= NOT n10l1i;
	wire_w_lg_n10l1l1758w(0) <= NOT n10l1l;
	wire_w_lg_n10lii1719w(0) <= NOT n10lii;
	wire_w_lg_n10lil1814w(0) <= NOT n10lil;
	wire_w_lg_n10liO1725w(0) <= NOT n10liO;
	wire_w_lg_n10lli1717w(0) <= NOT n10lli;
	wire_w_lg_n10lll1715w(0) <= NOT n10lll;
	wire_w_lg_n10llO1723w(0) <= NOT n10llO;
	wire_w_lg_n10O0i1691w(0) <= NOT n10O0i;
	wire_w_lg_n10O0l1683w(0) <= NOT n10O0l;
	wire_w_lg_n10O0O1681w(0) <= NOT n10O0O;
	wire_w_lg_n10O1i1687w(0) <= NOT n10O1i;
	wire_w_lg_n10O1l1685w(0) <= NOT n10O1l;
	wire_w_lg_n10O1O1806w(0) <= NOT n10O1O;
	wire_w_lg_n10Oii1689w(0) <= NOT n10Oii;
	wire_w_lg_n10Oil2235w(0) <= NOT n10Oil;
	wire_w_lg_n10OiO1764w(0) <= NOT n10OiO;
	wire_w_lg_n10Oll1768w(0) <= NOT n10Oll;
	wire_w_lg_n10OlO1771w(0) <= NOT n10OlO;
	wire_w_lg_n10OOi1774w(0) <= NOT n10OOi;
	wire_w_lg_n10OOl1777w(0) <= NOT n10OOl;
	wire_w_lg_n10OOO1780w(0) <= NOT n10OOO;
	wire_w_lg_n11iiO2691w(0) <= NOT n11iiO;
	wire_w_lg_n11ill2647w(0) <= NOT n11ill;
	wire_w_lg_n11ilO2646w(0) <= NOT n11ilO;
	wire_w_lg_n11iOi2634w(0) <= NOT n11iOi;
	wire_w_lg_n11iOO2621w(0) <= NOT n11iOO;
	wire_w_lg_n11l0i2624w(0) <= NOT n11l0i;
	wire_w_lg_n11l1O2669w(0) <= NOT n11l1O;
	wire_w_lg_n11lii2831w(0) <= NOT n11lii;
	wire_w_lg_n11lil2649w(0) <= NOT n11lil;
	wire_w_lg_n11liO2625w(0) <= NOT n11liO;
	wire_w_lg_n11Oll2269w(0) <= NOT n11Oll;
	wire_w_lg_n1i00i1745w(0) <= NOT n1i00i;
	wire_w_lg_n1i00l1748w(0) <= NOT n1i00l;
	wire_w_lg_n1i01O1742w(0) <= NOT n1i01O;
	wire_w_lg_n1i0il2215w(0) <= NOT n1i0il;
	wire_w_lg_n1i0iO1695w(0) <= NOT n1i0iO;
	wire_w_lg_n1i0li1587w(0) <= NOT n1i0li;
	wire_w_lg_n1i0ll1700w(0) <= NOT n1i0ll;
	wire_w_lg_n1i0lO1703w(0) <= NOT n1i0lO;
	wire_w_lg_n1i0Oi1706w(0) <= NOT n1i0Oi;
	wire_w_lg_n1i0Ol1709w(0) <= NOT n1i0Ol;
	wire_w_lg_n1i0OO1712w(0) <= NOT n1i0OO;
	wire_w_lg_n1i10i1729w(0) <= NOT n1i10i;
	wire_w_lg_n1i10O1832w(0) <= NOT n1i10O;
	wire_w_lg_n1i11i1783w(0) <= NOT n1i11i;
	wire_w_lg_n1i11l2225w(0) <= NOT n1i11l;
	wire_w_lg_n1i1ii1841w(0) <= NOT n1i1ii;
	wire_w_lg_n1i1iO1733w(0) <= NOT n1i1iO;
	wire_w_lg_n1i1lO1736w(0) <= NOT n1i1lO;
	wire_w_lg_n1i1OO1739w(0) <= NOT n1i1OO;
	wire_w_lg_n1ii0i1660w(0) <= NOT n1ii0i;
	wire_w_lg_n1ii0l1571w(0) <= NOT n1ii0l;
	wire_w_lg_n1ii0O1800w(0) <= NOT n1ii0O;
	wire_w_lg_n1ii1l2201w(0) <= NOT n1ii1l;
	wire_w_lg_n1ii1O1575w(0) <= NOT n1ii1O;
	wire_w_lg_n1iiii1566w(0) <= NOT n1iiii;
	wire_w_lg_n1iiil1564w(0) <= NOT n1iiil;
	wire_w_lg_n1iiiO1664w(0) <= NOT n1iiiO;
	wire_w_lg_n1iili1556w(0) <= NOT n1iili;
	wire_w_lg_n1iill1554w(0) <= NOT n1iill;
	wire_w_lg_n1iilO1667w(0) <= NOT n1iilO;
	wire_w_lg_n1iiOi1546w(0) <= NOT n1iiOi;
	wire_w_lg_n1iiOl1544w(0) <= NOT n1iiOl;
	wire_w_lg_n1iiOO1670w(0) <= NOT n1iiOO;
	wire_w_lg_n1il0i1676w(0) <= NOT n1il0i;
	wire_w_lg_n1il0l1679w(0) <= NOT n1il0l;
	wire_w_lg_n1il1i1536w(0) <= NOT n1il1i;
	wire_w_lg_n1il1l1534w(0) <= NOT n1il1l;
	wire_w_lg_n1il1O1673w(0) <= NOT n1il1O;
	wire_w_lg_n1illO826w(0) <= NOT n1illO;
	wire_w_lg_n1l00i291w(0) <= NOT n1l00i;
	wire_w_lg_n1l00l289w(0) <= NOT n1l00l;
	wire_w_lg_n1l00O287w(0) <= NOT n1l00O;
	wire_w_lg_n1l01l294w(0) <= NOT n1l01l;
	wire_w_lg_n1l0ii285w(0) <= NOT n1l0ii;
	wire_w_lg_n1l0il283w(0) <= NOT n1l0il;
	wire_w_lg_n1l0iO281w(0) <= NOT n1l0iO;
	wire_w_lg_n1l0li279w(0) <= NOT n1l0li;
	wire_w_lg_n1l0ll277w(0) <= NOT n1l0ll;
	wire_w_lg_n1l11l789w(0) <= NOT n1l11l;
	wire_w_lg_n1O10l48w(0) <= NOT n1O10l;
	wire_w_lg_n1O11l55w(0) <= NOT n1O11l;
	wire_w_lg_n1O1iO56w(0) <= NOT n1O1iO;
	wire_w_lg_n1O1li53w(0) <= NOT n1O1li;
	wire_w_lg_n1O1Ol40w(0) <= NOT n1O1Ol;
	wire_w_lg_PMADATAWIDTH126w(0) <= NOT PMADATAWIDTH;
	wire_w_lg_rcvd_clk43w(0) <= NOT rcvd_clk;
	wire_w_lg_soft_reset44w(0) <= NOT soft_reset;
	wire_w_lg_SYNC_SM_DIS823w(0) <= NOT SYNC_SM_DIS;
	wire_w_lg_w_SYNC_COMP_SIZE_range844w845w(0) <= NOT wire_w_SYNC_COMP_SIZE_range844w(0);
	wire_w_lg_w_lg_PMADATAWIDTH126w1866w(0) <= wire_w_lg_PMADATAWIDTH126w(0) OR wire_nilOi_w_lg_ni0Oii1865w(0);
	wire_w_lg_w_lg_w_lg_PMADATAWIDTH126w1866w1876w(0) <= wire_w_lg_w_lg_PMADATAWIDTH126w1866w(0) OR nilil;
	wire_w_lg_w_lg_w_lg_PMADATAWIDTH126w1866w1867w(0) <= wire_w_lg_w_lg_PMADATAWIDTH126w1866w(0) OR niliO;
	wire_w1877w(0) <= wire_w_lg_w_lg_w_lg_PMADATAWIDTH126w1866w1876w(0) OR nilii;
	wire_w1868w(0) <= wire_w_lg_w_lg_w_lg_PMADATAWIDTH126w1866w1867w(0) OR nilil;
	wire_w_lg_w1877w1878w(0) <= wire_w1877w(0) OR nil0O;
	wire_w_lg_w1868w1869w(0) <= wire_w1868w(0) OR nilii;
	wire_w_lg_w_lg_w1877w1878w1879w(0) <= wire_w_lg_w1877w1878w(0) OR nil0l;
	wire_w_lg_w_lg_w1868w1869w1870w(0) <= wire_w_lg_w1868w1869w(0) OR nil0O;
	wire_w_lg_w_lg_w_lg_w1877w1878w1879w1880w(0) <= wire_w_lg_w_lg_w1877w1878w1879w(0) OR nil0i;
	wire_w_lg_w_lg_w_lg_w1868w1869w1870w1874w(0) <= wire_w_lg_w_lg_w1868w1869w1870w(0) OR nil0l;
	wire_w_lg_w_lg_w1776w1779w1782w(0) <= wire_w_lg_w1776w1779w(0) OR n10OOO;
	wire_w_lg_w_lg_w1741w1744w1747w(0) <= wire_w_lg_w1741w1744w(0) OR n1i00i;
	wire_w_lg_w_lg_w1672w1675w1678w(0) <= wire_w_lg_w1672w1675w(0) OR n1il0i;
	wire_w_lg_w_lg_w_lg_w1885w1890w1894w1897w(0) <= wire_w_lg_w_lg_w1885w1890w1894w(0) OR nil0i;
	wire_w_lg_w1776w1779w(0) <= wire_w1776w(0) OR n10OOl;
	wire_w_lg_w1741w1744w(0) <= wire_w1741w(0) OR n1i01O;
	wire_w_lg_w1672w1675w(0) <= wire_w1672w(0) OR n1il1O;
	wire_w_lg_w_lg_w1885w1890w1894w(0) <= wire_w_lg_w1885w1890w(0) OR nil0l;
	wire_w1776w(0) <= wire_w_lg_w_lg_w_lg_w_lg_n10Oil1766w1767w1770w1773w(0) OR n10OOi;
	wire_w1741w(0) <= wire_w_lg_w_lg_w_lg_w_lg_n1i11l1731w1732w1735w1738w(0) OR n1i1OO;
	wire_w1672w(0) <= wire_w_lg_w_lg_w_lg_w_lg_n1ii1l1662w1663w1666w1669w(0) OR n1iiOO;
	wire_w_lg_w1885w1890w(0) <= wire_w1885w(0) OR nil0O;
	wire_w_lg_w_lg_w_lg_w_lg_n10Oil1766w1767w1770w1773w(0) <= wire_w_lg_w_lg_w_lg_n10Oil1766w1767w1770w(0) OR n10OlO;
	wire_w_lg_w_lg_w_lg_w_lg_n1i11l1731w1732w1735w1738w(0) <= wire_w_lg_w_lg_w_lg_n1i11l1731w1732w1735w(0) OR n1i1lO;
	wire_w_lg_w_lg_w_lg_w_lg_n1ii1l1662w1663w1666w1669w(0) <= wire_w_lg_w_lg_w_lg_n1ii1l1662w1663w1666w(0) OR n1iilO;
	wire_w1885w(0) <= wire_w_lg_w_lg_w_lg_PMADATAWIDTH1882w1883w1884w(0) OR nilii;
	wire_w_lg_w_lg_w_lg_n10Oil1766w1767w1770w(0) <= wire_w_lg_w_lg_n10Oil1766w1767w(0) OR n10Oll;
	wire_w_lg_w_lg_w_lg_n1i11l1731w1732w1735w(0) <= wire_w_lg_w_lg_n1i11l1731w1732w(0) OR n1i1iO;
	wire_w_lg_w_lg_w_lg_n1ii1l1662w1663w1666w(0) <= wire_w_lg_w_lg_n1ii1l1662w1663w(0) OR n1iiiO;
	wire_w_lg_w_lg_w_lg_n1iOlO793w795w797w(0) <= wire_w_lg_w_lg_n1iOlO793w795w(0) OR wire_w_lg_n1iOii796w(0);
	wire_w_lg_w_lg_w_lg_PMADATAWIDTH1882w1883w1884w(0) <= wire_w_lg_w_lg_PMADATAWIDTH1882w1883w(0) OR nilil;
	wire_w_lg_w_lg_n10Oil1766w1767w(0) <= wire_w_lg_n10Oil1766w(0) OR n1i1ii;
	wire_w_lg_w_lg_n1i11l1731w1732w(0) <= wire_w_lg_n1i11l1731w(0) OR n1i10O;
	wire_w_lg_w_lg_n1ii1l1662w1663w(0) <= wire_w_lg_n1ii1l1662w(0) OR n1ii0O;
	wire_w_lg_w_lg_n1iO1O807w808w(0) <= wire_w_lg_n1iO1O807w(0) OR n1iO1i;
	wire_w_lg_w_lg_n1iOlO793w795w(0) <= wire_w_lg_n1iOlO793w(0) OR wire_w_lg_n1iOiO794w(0);
	wire_w_lg_w_lg_PMADATAWIDTH1882w1883w(0) <= wire_w_lg_PMADATAWIDTH1882w(0) OR niliO;
	wire_w_lg_n10Oil1786w(0) <= n10Oil OR wire_w_lg_n10i0O1785w(0);
	wire_w_lg_n10Oil1840w(0) <= n10Oil OR wire_w_lg_n10iii1793w(0);
	wire_w_lg_n10Oil1766w(0) <= n10Oil OR n10OiO;
	wire_w_lg_n11OiO2368w(0) <= n11OiO OR wire_w_lg_n11O1l2367w(0);
	wire_w_lg_n11OiO2284w(0) <= n11OiO OR n11Oil;
	wire_w_lg_n11Oli2285w(0) <= n11Oli OR wire_w_lg_n11OiO2284w(0);
	wire_w_lg_n11Oll2279w(0) <= n11Oll OR n1iliO;
	wire_w_lg_n1i0il1716w(0) <= n1i0il OR wire_w_lg_n10lll1715w(0);
	wire_w_lg_n1i0il1808w(0) <= n1i0il OR wire_w_lg_n10llO1723w(0);
	wire_w_lg_n1i11l1751w(0) <= n1i11l OR wire_w_lg_n10l1i1750w(0);
	wire_w_lg_n1i11l1831w(0) <= n1i11l OR wire_w_lg_n10l1l1758w(0);
	wire_w_lg_n1i11l1731w(0) <= n1i11l OR n1i10i;
	wire_w_lg_n1ii1l1682w(0) <= n1ii1l OR wire_w_lg_n10O0O1681w(0);
	wire_w_lg_n1ii1l1799w(0) <= n1ii1l OR wire_w_lg_n10Oii1689w(0);
	wire_w_lg_n1ii1l1662w(0) <= n1ii1l OR n1ii0i;
	wire_w_lg_n1ilil2280w(0) <= n1ilil OR wire_w_lg_n11Oll2279w(0);
	wire_w_lg_n1ilOO813w(0) <= n1ilOO OR wire_nilOi_w_lg_nlO01i812w(0);
	wire_w_lg_n1iO0l803w(0) <= n1iO0l OR wire_nilOi_w_lg_w_lg_nlO1lO801w802w(0);
	wire_w_lg_n1iO1O807w(0) <= n1iO1O OR n1iO1l;
	wire_w_lg_n1iOll2287w(0) <= n1iOll OR wire_w_lg_n1iOlO2286w(0);
	wire_w_lg_n1iOll792w(0) <= n1iOll OR n1iOli;
	wire_w_lg_n1iOlO793w(0) <= n1iOlO OR wire_w_lg_n1iOll792w(0);
	wire_w_lg_n1iOlO2286w(0) <= n1iOlO OR n1iOli;
	wire_w_lg_n1iOOi798w(0) <= n1iOOi OR wire_w_lg_w_lg_w_lg_n1iOlO793w795w797w(0);
	wire_w_lg_n1iOOi2288w(0) <= n1iOOi OR wire_w_lg_n1iOll2287w(0);
	wire_w_lg_n1iOOl799w(0) <= n1iOOl OR wire_w_lg_n1iOOi798w(0);
	wire_w_lg_PMADATAWIDTH1882w(0) <= PMADATAWIDTH OR wire_nilOi_w_lg_ni0Oii1865w(0);
	cg_comma <= nlll0i;
	n1000i <= (((((((wire_w_lg_PMADATAWIDTH1882w(0) OR wire_nilOi_w_lg_niliO1899w(0)) OR wire_nilOi_w_lg_nilil1901w(0)) OR wire_nilOi_w_lg_nilii1903w(0)) OR wire_nilOi_w_lg_nil0O1905w(0)) OR wire_nilOi_w_lg_nil0l1910w(0)) OR wire_nii00l_w_lg_dataout1871w(0)) OR wire_nilOi_w_lg_nilli1908w(0));
	n1000l <= (((((((wire_w_lg_PMADATAWIDTH1882w(0) OR wire_nilOi_w_lg_niliO1899w(0)) OR wire_nilOi_w_lg_nilil1901w(0)) OR wire_nilOi_w_lg_nilii1903w(0)) OR wire_nilOi_w_lg_nil0O1905w(0)) OR wire_nilOi_w_lg_nil0l1910w(0)) OR wire_nilOi_w_lg_nil0i1917w(0)) OR wire_nii00l_w_lg_dataout1871w(0));
	n1000O <= (wire_w_lg_w_lg_w_lg_w1868w1869w1870w1874w(0) OR wire_nii00l_w_lg_dataout1871w(0));
	n1001i <= ((((((wire_w_lg_w_lg_PMADATAWIDTH126w1866w(0) OR wire_nilOi_w_lg_nilil1901w(0)) OR wire_nilOi_w_lg_nilii1903w(0)) OR wire_nilOi_w_lg_nil0O1905w(0)) OR wire_nilOi_w_lg_nil0l1910w(0)) OR wire_nilOi_w_lg_nil0i1917w(0)) OR wire_nii00l_w_lg_dataout1871w(0));
	n1001l <= (((((((wire_w_lg_PMADATAWIDTH1882w(0) OR wire_nilOi_w_lg_niliO1899w(0)) OR wire_nilOi_w_lg_nilil1901w(0)) OR wire_nilOi_w_lg_nilii1903w(0)) OR wire_nii00l_w_lg_dataout1871w(0)) OR wire_nilOi_w_lg_nilli1908w(0)) OR wire_nilOi_w_lg_nilll1925w(0)) OR wire_nilOi_w_lg_nillO1927w(0));
	n1001O <= (((((((wire_w_lg_PMADATAWIDTH1882w(0) OR wire_nilOi_w_lg_niliO1899w(0)) OR wire_nilOi_w_lg_nilil1901w(0)) OR wire_nilOi_w_lg_nilii1903w(0)) OR wire_nilOi_w_lg_nil0O1905w(0)) OR wire_nii00l_w_lg_dataout1871w(0)) OR wire_nilOi_w_lg_nilli1908w(0)) OR wire_nilOi_w_lg_nilll1925w(0));
	n100ii <= ((wire_w_lg_w_lg_w1868w1869w1870w(0) OR wire_nii00l_w_lg_dataout1871w(0)) OR nilli);
	n100il <= (wire_w_lg_w_lg_w_lg_w1877w1878w1879w1880w(0) OR wire_nii00l_w_lg_dataout1871w(0));
	n100iO <= ((((wire_w1885w(0) OR wire_nii00l_w_lg_dataout1871w(0)) OR nilli) OR nilll) OR nillO);
	n100li <= (((wire_w_lg_w1885w1890w(0) OR wire_nii00l_w_lg_dataout1871w(0)) OR nilli) OR nilll);
	n100ll <= ((wire_w_lg_w_lg_w1885w1890w1894w(0) OR wire_nii00l_w_lg_dataout1871w(0)) OR nilli);
	n100lO <= (wire_w_lg_w_lg_w_lg_w1885w1890w1894w1897w(0) OR wire_nii00l_w_lg_dataout1871w(0));
	n100Oi <= ((((wire_w_lg_n10iii1793w(0) OR wire_w_lg_n10i0O1785w(0)) OR wire_w_lg_n10i0i1795w(0)) OR wire_w_lg_n10i1l1789w(0)) OR n100Ol);
	n100Ol <= ((((((((wire_nilOi_w_lg_nil0i2236w(0) AND wire_w_lg_n10OiO1764w(0)) AND wire_w_lg_n1i1ii1841w(0)) AND wire_w_lg_n10Oll1768w(0)) AND wire_w_lg_n10OlO1771w(0)) AND wire_w_lg_n10OOi1774w(0)) AND wire_w_lg_n10OOl1777w(0)) AND wire_w_lg_n10OOO1780w(0)) AND wire_w_lg_n1i11i1783w(0));
	n100OO <= (((wire_w_lg_n10Oil1786w(0) OR wire_w_lg_n10i0l1787w(0)) OR wire_w_lg_n10i1l1789w(0)) OR wire_w_lg_n10i1i1791w(0));
	n1010i <= ((((ni0lli OR ni0i0l) OR ni1iOl) OR ni0ili) OR ni0iiO);
	n1010l <= ((((ni0iil OR ni0i0l) OR ni1iOl) OR ni0iii) OR ni0i0O);
	n1010O <= (wire_nilOi_w_lg_nii0iO2002w(0) AND wire_nilOi_w_lg_nii0il1996w(0));
	n1011i <= (ni0ili OR ni0iiO);
	n1011l <= (ni0iii OR ni0i0O);
	n1011O <= (ni0i0l OR ni1iOl);
	n101ii <= (wire_nilOi_w_lg_nii0iO2002w(0) AND nii0il);
	n101il <= (ni0i0i AND ni1lii);
	n101iO <= (wire_nilOi_w_lg_nii0il1996w(0) AND wire_nilOi_w_lg_niilil1997w(0));
	n101li <= (nii0il AND wire_nilOi_w_lg_niilil1997w(0));
	n101ll <= ((((RUNDISP_SEL(0) OR RUNDISP_SEL(1)) OR RUNDISP_SEL(4)) OR RUNDISP_SEL(3)) OR RUNDISP_SEL(2));
	n101lO <= ((wire_ni0l1O_w_lg_w2253w2254w(0) AND wire_ni0ilO_w_lg_dataout2255w(0)) AND wire_ni0ill_w_lg_dataout2257w(0));
	n101Oi <= ((wire_ni0l1O_w_lg_w2253w2254w(0) AND wire_ni0ilO_w_lg_dataout2255w(0)) AND wire_ni0ill_dataout);
	n101Ol <= ((((((wire_w_lg_w_lg_PMADATAWIDTH126w1866w(0) OR wire_nilOi_w_lg_niliO1899w(0)) OR wire_nilOi_w_lg_nilil1901w(0)) OR wire_nilOi_w_lg_nilii1903w(0)) OR wire_nilOi_w_lg_nil0O1905w(0)) OR wire_nilOi_w_lg_nil0l1910w(0)) OR wire_nii00l_w_lg_dataout1871w(0));
	n101OO <= ((((((wire_w_lg_w_lg_PMADATAWIDTH126w1866w(0) OR wire_nilOi_w_lg_niliO1899w(0)) OR wire_nilOi_w_lg_nilil1901w(0)) OR wire_nilOi_w_lg_nilii1903w(0)) OR wire_nilOi_w_lg_nil0O1905w(0)) OR wire_nii00l_w_lg_dataout1871w(0)) OR wire_nilOi_w_lg_nilli1908w(0));
	n10i0i <= (wire_w_lg_w_lg_w_lg_w_lg_n10Oil1766w1767w1770w1773w(0) OR wire_w_lg_n10OOi1774w(0));
	n10i0l <= (wire_w_lg_w_lg_w_lg_n10Oil1766w1767w1770w(0) OR wire_w_lg_n10OlO1771w(0));
	n10i0O <= (wire_w_lg_w_lg_n10Oil1766w1767w(0) OR wire_w_lg_n10Oll1768w(0));
	n10i1i <= (wire_w_lg_w_lg_w1776w1779w1782w(0) OR wire_w_lg_n1i11i1783w(0));
	n10i1l <= (wire_w_lg_w1776w1779w(0) OR wire_w_lg_n10OOO1780w(0));
	n10i1O <= (wire_w1776w(0) OR wire_w_lg_n10OOl1777w(0));
	n10iii <= (n10Oil OR wire_w_lg_n10OiO1764w(0));
	n10iil <= ((((wire_w_lg_n10l1l1758w(0) OR wire_w_lg_n10l1i1750w(0)) OR wire_w_lg_n10iOl1760w(0)) OR wire_w_lg_n10ilO1754w(0)) OR n10iiO);
	n10iiO <= (((((((((wire_w_lg_n1i11l2225w(0) AND wire_w_lg_n1i10i1729w(0)) AND wire_w_lg_n1i10O1832w(0)) AND wire_w_lg_n1i1iO1733w(0)) AND wire_w_lg_n1i1lO1736w(0)) AND wire_w_lg_n1i1OO1739w(0)) AND wire_w_lg_n1i01O1742w(0)) AND wire_w_lg_n1i00i1745w(0)) AND wire_w_lg_n1i00l1748w(0)) AND (n1i0ii OR n1i00O));
	n10ili <= (((wire_w_lg_n1i11l1751w(0) OR wire_w_lg_n10iOO1752w(0)) OR wire_w_lg_n10ilO1754w(0)) OR wire_w_lg_n10ill1756w(0));
	n10ill <= (wire_w_lg_w_lg_w1741w1744w1747w(0) OR wire_w_lg_n1i00l1748w(0));
	n10ilO <= (wire_w_lg_w1741w1744w(0) OR wire_w_lg_n1i00i1745w(0));
	n10iOi <= (wire_w1741w(0) OR wire_w_lg_n1i01O1742w(0));
	n10iOl <= (wire_w_lg_w_lg_w_lg_w_lg_n1i11l1731w1732w1735w1738w(0) OR wire_w_lg_n1i1OO1739w(0));
	n10iOO <= (wire_w_lg_w_lg_w_lg_n1i11l1731w1732w1735w(0) OR wire_w_lg_n1i1lO1736w(0));
	n10l0i <= (((((((((wire_nilOi_w_lg_nil0i1917w(0) AND wire_w_lg_n1i0il2215w(0)) AND wire_w_lg_n1i0iO1695w(0)) AND n1iiii) AND n1i0ll) AND n1i0lO) AND n1i0Oi) AND n1i0Ol) AND n1i0OO) AND n1ii1i);
	n10l0l <= (((wire_w_lg_n1i0il1716w(0) OR wire_w_lg_n10lli1717w(0)) OR wire_w_lg_n10lii1719w(0)) OR wire_w_lg_n10l0O1721w(0));
	n10l0O <= ((((((((n1i0il OR n1i0iO) OR wire_w_lg_n1iiii1566w(0)) OR wire_w_lg_n1i0ll1700w(0)) OR wire_w_lg_n1i0lO1703w(0)) OR wire_w_lg_n1i0Oi1706w(0)) OR wire_w_lg_n1i0Ol1709w(0)) OR wire_w_lg_n1i0OO1712w(0)) OR n1ii1i);
	n10l1i <= (wire_w_lg_w_lg_n1i11l1731w1732w(0) OR wire_w_lg_n1i1iO1733w(0));
	n10l1l <= (n1i11l OR wire_w_lg_n1i10i1729w(0));
	n10l1O <= ((((wire_w_lg_n10llO1723w(0) OR wire_w_lg_n10lll1715w(0)) OR wire_w_lg_n10liO1725w(0)) OR wire_w_lg_n10lii1719w(0)) OR n10l0i);
	n10lii <= (((((((n1i0il OR n1i0iO) OR wire_w_lg_n1iiii1566w(0)) OR wire_w_lg_n1i0ll1700w(0)) OR wire_w_lg_n1i0lO1703w(0)) OR wire_w_lg_n1i0Oi1706w(0)) OR wire_w_lg_n1i0Ol1709w(0)) OR n1i0OO);
	n10lil <= ((((((n1i0il OR n1i0iO) OR wire_w_lg_n1iiii1566w(0)) OR wire_w_lg_n1i0ll1700w(0)) OR wire_w_lg_n1i0lO1703w(0)) OR wire_w_lg_n1i0Oi1706w(0)) OR n1i0Ol);
	n10liO <= (((((n1i0il OR n1i0iO) OR wire_w_lg_n1iiii1566w(0)) OR wire_w_lg_n1i0ll1700w(0)) OR wire_w_lg_n1i0lO1703w(0)) OR n1i0Oi);
	n10lli <= ((((n1i0il OR n1i0iO) OR wire_w_lg_n1iiii1566w(0)) OR wire_w_lg_n1i0ll1700w(0)) OR n1i0lO);
	n10lll <= (((n1i0il OR n1i0iO) OR wire_w_lg_n1iiii1566w(0)) OR n1i0ll);
	n10llO <= (n1i0il OR wire_w_lg_n1i0iO1695w(0));
	n10lOi <= ((((wire_w_lg_n10Oii1689w(0) OR wire_w_lg_n10O0O1681w(0)) OR wire_w_lg_n10O0i1691w(0)) OR wire_w_lg_n10O1l1685w(0)) OR n10lOl);
	n10lOl <= (((((((((wire_w_lg_n1ii1l2201w(0) AND wire_w_lg_n1ii0i1660w(0)) AND wire_w_lg_n1ii0O1800w(0)) AND wire_w_lg_n1iiiO1664w(0)) AND wire_w_lg_n1iilO1667w(0)) AND wire_w_lg_n1iiOO1670w(0)) AND wire_w_lg_n1il1O1673w(0)) AND wire_w_lg_n1il0i1676w(0)) AND wire_w_lg_n1il0l1679w(0)) AND ((wire_w_lg_PMADATAWIDTH126w(0) AND wire_nilOi_w_lg_nilOl2210w(0)) OR wire_w_lg_PMADATAWIDTH2212w(0)));
	n10lOO <= (((wire_w_lg_n1ii1l1682w(0) OR wire_w_lg_n10O0l1683w(0)) OR wire_w_lg_n10O1l1685w(0)) OR wire_w_lg_n10O1i1687w(0));
	n10O0i <= (wire_w_lg_w_lg_w_lg_w_lg_n1ii1l1662w1663w1666w1669w(0) OR wire_w_lg_n1iiOO1670w(0));
	n10O0l <= (wire_w_lg_w_lg_w_lg_n1ii1l1662w1663w1666w(0) OR wire_w_lg_n1iilO1667w(0));
	n10O0O <= (wire_w_lg_w_lg_n1ii1l1662w1663w(0) OR wire_w_lg_n1iiiO1664w(0));
	n10O1i <= (wire_w_lg_w_lg_w1672w1675w1678w(0) OR wire_w_lg_n1il0l1679w(0));
	n10O1l <= (wire_w_lg_w1672w1675w(0) OR wire_w_lg_n1il0i1676w(0));
	n10O1O <= (wire_w1672w(0) OR wire_w_lg_n1il1O1673w(0));
	n10Oii <= (n1ii1l OR wire_w_lg_n1ii0i1660w(0));
	n10Oil <= (wire_w_lg_PMADATAWIDTH126w(0) AND n1i11O);
	n10OiO <= (wire_w_lg_PMADATAWIDTH126w(0) AND n10Oli);
	n10Oli <= (((((((wire_nilOi_w_lg_niliO1606w(0) AND nilii) AND nil0O) AND nil0l) AND nil0i) AND nilli) AND nilll) AND nillO);
	n10Oll <= (((((wire_nilOi_w_lg_niliO1606w(0) AND nilii) AND nil0O) AND nil0l) AND nil0i) AND nilli);
	n10OlO <= ((((wire_nilOi_w_lg_niliO1606w(0) AND nilii) AND nil0O) AND nil0l) AND nil0i);
	n10OOi <= ((((nilil AND nilii) AND nil0O) AND nil0l) AND nil0i);
	n10OOl <= (((nilii AND nil0O) AND nil0l) AND nil0i);
	n10OOO <= ((nil0O AND nil0l) AND nil0i);
	n110Oi <= ((((((n01llO OR n01lll) OR n01liO) OR n01lOl) OR n1O0li) OR n01lOi) OR n01lli);
	n110Ol <= ((((n01llO OR n01liO) OR n1O0li) OR n01lOi) OR n01lli);
	n110OO <= ((((((((((n01O0i OR n01O1l) OR n01lOO) OR n01llO) OR n01lll) OR n01O1O) OR n01lOl) OR n01O1i) OR n01lOi) OR n01O0l) OR n01lli);
	n11i0i <= (((((((((n01O0i OR n01O1l) OR n01lOO) OR n01llO) OR n01liO) OR n01O1O) OR n01lOl) OR n1O0li) OR n01O1i) OR n01O0l);
	n11i0l <= (((((((((n01O0i OR n01O1l) OR n01lOO) OR n01llO) OR n01liO) OR n01O1O) OR n1O0li) OR n01lOi) OR n01O0l) OR n01lli);
	n11i0O <= ((((((((((n01O0i OR n01O1l) OR n01lOO) OR n01llO) OR n01lll) OR n01liO) OR n1O0li) OR n01O1i) OR n01lOi) OR n01O0l) OR n01lli);
	n11i1i <= ((((((((((n01O0i OR n01O1l) OR n01lOO) OR n01lll) OR n01O1O) OR n01lOl) OR n1O0li) OR n01O1i) OR n01lOi) OR n01O0l) OR n01lli);
	n11i1l <= (((((((((n01O0i OR n01O1l) OR n01lOO) OR n01lll) OR n01O1O) OR n01lOl) OR n1O0li) OR n01O1i) OR n01lOi) OR n01O0l);
	n11i1O <= ((((((((((n01O0i OR n01O1l) OR n01lOO) OR n01llO) OR n01lll) OR n01liO) OR n01O1O) OR n01lOl) OR n1O0li) OR n01O1i) OR n01O0l);
	n11iii <= (((((((((n01O0i OR n01O1l) OR n01llO) OR n01lll) OR n01liO) OR n01O1O) OR n01lOl) OR n1O0li) OR n01lOi) OR n01lli);
	n11iil <= ((((((((((n01O0i OR n01O1l) OR n01llO) OR n01lll) OR n01liO) OR n01O1O) OR n01lOl) OR n1O0li) OR n01lOi) OR n01O0l) OR n01lli);
	n11iiO <= ((((((((((n01O0i OR n01lOO) OR n01llO) OR n01lll) OR n01liO) OR n01lOl) OR n1O0li) OR n01O1i) OR n01lOi) OR n01O0l) OR n01lli);
	n11ili <= ((((((((((n01O1l OR n01lOO) OR n01llO) OR n01lll) OR n01liO) OR n01O1O) OR n01lOl) OR n1O0li) OR n01O1i) OR n01lOi) OR n01lli);
	n11ill <= (wire_nilOi_w_lg_n01Oii2650w(0) AND (n01lil AND n1Oi1O));
	n11ilO <= (n01Oii AND n11lil);
	n11iOi <= (n11l1i OR n11iOO);
	n11iOl <= (wire_nilOi_w_lg_n01Oii2616w(0) OR n11l1l);
	n11iOO <= (n01Oii AND (nlll0i AND wire_w_lg_GE_XAUI_SEL2627w(0)));
	n11l0i <= (n01Oii AND (nlll0i AND wire_nilOi_w_lg_n1O0Ol2618w(0)));
	n11l0l <= (wire_nilOi_w_lg_n01Oii2616w(0) OR n11l1l);
	n11l0O <= (n01Oii AND n11l1i);
	n11l1i <= (GE_XAUI_SEL AND n11liO);
	n11l1l <= (wire_w_lg_GE_XAUI_SEL2626w(0) OR wire_w_lg_w_lg_GE_XAUI_SEL2627w2628w(0));
	n11l1O <= (wire_nilOi_w_lg_n01Oii2616w(0) OR n11lil);
	n11lii <= (wire_nilOi_w_lg_nlll0i2615w(0) OR wire_nilOi_w_lg_n01Oii2616w(0));
	n11lil <= (nlliiO OR (n1O0Ol AND (nlll0i AND GE_XAUI_SEL)));
	n11liO <= (wire_nilOi_w_lg_nlliOO2589w(0) AND wire_nlliil_w_lg_nlliiO2590w(0));
	n11lli <= (nlO1iO AND nlO1li);
	n11lll <= wire_nilOi_w_lg_w_lg_nlO1iO2379w2381w(0);
	n11llO <= wire_nilOi_w_lg_w_lg_nlO1iO2379w2417w(0);
	n11lOi <= wire_nilOi_w_lg_nlO1iO2416w(0);
	n11lOl <= (n11O1l AND n1iOii);
	n11lOO <= (wire_nilOi_w_lg_nlO1lO801w(0) AND (wire_nilOi_w_lg_nlO1ll2388w(0) AND wire_nilOi_w_lg_w_lg_nlO1iO2379w2381w(0)));
	n11O0i <= (nlO1OO AND nlO01i);
	n11O0l <= wire_nilOi_w_lg_w_lg_nlO1OO2261w2331w(0);
	n11O0O <= wire_nilOi_w_lg_w_lg_nlO1OO2261w2315w(0);
	n11O1i <= (nlO1lO AND (nlO1ll AND (nlO1iO AND nlO1li)));
	n11O1l <= (nlO1Oi AND nlO1Ol);
	n11O1O <= ((((wire_nilOi_w_lg_nlO1lO801w(0) AND (nlO1ll AND n11lli)) OR wire_nilOi_w_lg_nlO1lO2445w(0)) OR wire_nilOi_w_lg_nlO1lO2448w(0)) OR wire_nilOi_w_lg_nlO1lO2451w(0));
	n11Oii <= wire_nilOi_w_lg_nlO1OO2314w(0);
	n11Oil <= (n11O1i AND n1iO0O);
	n11OiO <= ((n11O1l AND n11O1i) OR (n11O1l AND n11O1O));
	n11Oli <= (n11O1i AND n1iOil);
	n11Oll <= (wire_w_lg_n11O1l2398w(0) OR (n1iOil AND wire_n0l1lO_dataout));
	n11OlO <= (nlO1OO XOR nlO01l);
	n11OOi <= ((((wire_nilOi_w_lg_nlOOiO830w(0) AND (nlO01l AND n11O0i)) OR wire_nilOi_w_lg_nlOOiO2353w(0)) OR wire_nilOi_w_lg_nlOOiO2356w(0)) OR wire_nilOi_w_lg_nlOOiO2359w(0));
	n11OOl <= (nlOOiO AND (nlO01l AND (nlO1OO AND nlO01i)));
	n11OOO <= (ni0lli OR ni0iil);
	n1i00i <= ((wire_w_lg_PMADATAWIDTH126w(0) AND wire_nilOi_w_lg_w_lg_nilll1596w1597w(0)) OR wire_w_lg_PMADATAWIDTH1601w(0));
	n1i00l <= ((wire_w_lg_PMADATAWIDTH126w(0) AND (nillO AND nilOl)) OR wire_w_lg_PMADATAWIDTH1594w(0));
	n1i00O <= (PMADATAWIDTH AND nilll);
	n1i01i <= (((wire_nilOi_w_lg_niliO1606w(0) AND nilii) AND nilli) AND nilll);
	n1i01l <= ((wire_nilOi_w_lg_w_lg_niliO1599w1600w(0) AND nillO) AND nilOl);
	n1i01O <= ((wire_w_lg_PMADATAWIDTH126w(0) AND wire_nilOi_w_lg_w_lg_w_lg_nilli1593w1603w1604w(0)) OR wire_w_lg_PMADATAWIDTH1609w(0));
	n1i0ii <= (wire_w_lg_PMADATAWIDTH126w(0) AND nilOl);
	n1i0il <= (wire_w_lg_PMADATAWIDTH126w(0) AND wire_w_lg_n1ii1O1575w(0));
	n1i0iO <= (wire_w_lg_PMADATAWIDTH126w(0) AND wire_w_lg_n1i0li1587w(0));
	n1i0li <= (((((((wire_nilOi_w_lg_niliO1523w(0) OR nilii) OR nil0O) OR nil0l) OR nil0i) OR nilli) OR nilll) OR nillO);
	n1i0ll <= (((((wire_nilOi_w_lg_niliO1523w(0) OR nilii) OR nil0O) OR nil0l) OR nil0i) OR nilli);
	n1i0lO <= ((((wire_nilOi_w_lg_niliO1523w(0) OR nilii) OR nil0O) OR nil0l) OR nil0i);
	n1i0Oi <= ((((nilil OR nilii) OR nil0O) OR nil0l) OR nil0i);
	n1i0Ol <= (((nilii OR nil0O) OR nil0l) OR nil0i);
	n1i0OO <= ((nil0O OR nil0l) OR nil0i);
	n1i10i <= (wire_w_lg_PMADATAWIDTH126w(0) AND n1i10l);
	n1i10l <= (((((((wire_nilOi_w_lg_niliO1606w(0) AND nilii) AND nil0O) AND nil0l) AND nilli) AND nilll) AND nillO) AND nilOl);
	n1i10O <= (wire_w_lg_w_lg_PMADATAWIDTH126w1640w(0) OR (PMADATAWIDTH AND n1i1ii));
	n1i11i <= (nil0l AND nil0i);
	n1i11l <= (wire_w_lg_PMADATAWIDTH126w(0) AND n1i11O);
	n1i11O <= ((((((((wire_nilOi_w_lg_niliO1606w(0) AND nilii) AND nil0O) AND nil0l) AND nil0i) AND nilli) AND nilll) AND nillO) AND nilOl);
	n1i1ii <= ((((((wire_nilOi_w_lg_niliO1606w(0) AND nilii) AND nil0O) AND nil0l) AND nil0i) AND nilli) AND nilll);
	n1i1il <= ((((((wire_nilOi_w_lg_niliO1606w(0) AND nilii) AND nil0O) AND nilli) AND nilll) AND nillO) AND nilOl);
	n1i1iO <= (wire_w_lg_w_lg_PMADATAWIDTH126w1632w(0) OR (PMADATAWIDTH AND n1i1li));
	n1i1li <= (((((wire_nilOi_w_lg_niliO1606w(0) AND nilii) AND nil0O) AND nil0l) AND nilli) AND nilll);
	n1i1ll <= (((((wire_nilOi_w_lg_niliO1606w(0) AND nilii) AND nilli) AND nilll) AND nillO) AND nilOl);
	n1i1lO <= (wire_w_lg_w_lg_PMADATAWIDTH126w1624w(0) OR (PMADATAWIDTH AND n1i1Oi));
	n1i1Oi <= ((((wire_nilOi_w_lg_niliO1606w(0) AND nilii) AND nil0O) AND nilli) AND nilll);
	n1i1Ol <= ((wire_nilOi_w_lg_w_lg_w_lg_niliO1606w1607w1608w(0) AND nillO) AND nilOl);
	n1i1OO <= (wire_w_lg_w_lg_PMADATAWIDTH126w1616w(0) OR (PMADATAWIDTH AND n1i01i));
	n1ii0i <= (wire_w_lg_PMADATAWIDTH126w(0) AND wire_w_lg_n1ii0l1571w(0));
	n1ii0l <= (((((((wire_nilOi_w_lg_niliO1523w(0) OR nilii) OR nil0O) OR nil0l) OR nilli) OR nilll) OR nillO) OR nilOl);
	n1ii0O <= ((wire_w_lg_PMADATAWIDTH126w(0) AND wire_w_lg_n1iiil1564w(0)) OR wire_w_lg_PMADATAWIDTH1567w(0));
	n1ii1i <= (nil0l OR nil0i);
	n1ii1l <= (wire_w_lg_PMADATAWIDTH126w(0) AND wire_w_lg_n1ii1O1575w(0));
	n1ii1O <= ((((((((wire_nilOi_w_lg_niliO1523w(0) OR nilii) OR nil0O) OR nil0l) OR nil0i) OR nilli) OR nilll) OR nillO) OR nilOl);
	n1iiii <= ((((((wire_nilOi_w_lg_niliO1523w(0) OR nilii) OR nil0O) OR nil0l) OR nil0i) OR nilli) OR nilll);
	n1iiil <= ((((((wire_nilOi_w_lg_niliO1523w(0) OR nilii) OR nil0O) OR nilli) OR nilll) OR nillO) OR nilOl);
	n1iiiO <= ((wire_w_lg_PMADATAWIDTH126w(0) AND wire_w_lg_n1iill1554w(0)) OR wire_w_lg_PMADATAWIDTH1557w(0));
	n1iili <= (((((wire_nilOi_w_lg_niliO1523w(0) OR nilii) OR nil0O) OR nil0l) OR nilli) OR nilll);
	n1iill <= (((((wire_nilOi_w_lg_niliO1523w(0) OR nilii) OR nilli) OR nilll) OR nillO) OR nilOl);
	n1iilO <= ((wire_w_lg_PMADATAWIDTH126w(0) AND wire_w_lg_n1iiOl1544w(0)) OR wire_w_lg_PMADATAWIDTH1547w(0));
	n1iiOi <= ((((wire_nilOi_w_lg_niliO1523w(0) OR nilii) OR nil0O) OR nilli) OR nilll);
	n1iiOl <= ((wire_nilOi_w_lg_w_lg_w_lg_niliO1523w1524w1525w(0) OR nillO) OR nilOl);
	n1iiOO <= ((wire_w_lg_PMADATAWIDTH126w(0) AND wire_w_lg_n1il1l1534w(0)) OR wire_w_lg_PMADATAWIDTH1537w(0));
	n1il0i <= ((wire_w_lg_PMADATAWIDTH126w(0) AND (NOT ((nilll OR nillO) OR nilOl))) OR wire_w_lg_PMADATAWIDTH1517w(0));
	n1il0l <= ((wire_w_lg_PMADATAWIDTH126w(0) AND (NOT (nillO OR nilOl))) OR wire_w_lg_PMADATAWIDTH1508w(0));
	n1il0O <= (nlO1Ol AND (wire_nilOi_w_lg_nlO1Oi2387w(0) AND n1iOii));
	n1il1i <= (((wire_nilOi_w_lg_niliO1523w(0) OR nilii) OR nilli) OR nilll);
	n1il1l <= ((wire_nilOi_w_lg_w_lg_niliO1514w1515w(0) OR nillO) OR nilOl);
	n1il1O <= ((wire_w_lg_PMADATAWIDTH126w(0) AND (NOT ((wire_nilOi_w_lg_nilli1506w(0) OR nillO) OR nilOl))) OR wire_w_lg_PMADATAWIDTH1527w(0));
	n1ilii <= (wire_nilOi_w_lg_nlO1Ol2386w(0) AND (nlO1Oi AND n11O1O));
	n1ilil <= (wire_nilOi_w_lg_nlO1Ol2386w(0) AND (wire_nilOi_w_lg_nlO1Oi2387w(0) AND (wire_nilOi_w_lg_nlO1lO801w(0) AND (wire_nilOi_w_lg_nlO1ll2388w(0) AND (nlO1iO AND nlO1li)))));
	n1iliO <= (nlO1Ol AND (nlO1Oi AND wire_nilOi_w_lg_nlO1lO2383w(0)));
	n1illi <= ((((((((((NOT (nlO1iO XOR (NOT SYNC_COMP_PAT(0)))) AND (NOT (nlO1li XOR (NOT SYNC_COMP_PAT(1))))) AND (NOT (nlO1ll XOR (NOT SYNC_COMP_PAT(2))))) AND (NOT (nlO1lO XOR (NOT SYNC_COMP_PAT(3))))) AND (NOT (nlO1Oi XOR (NOT SYNC_COMP_PAT(4))))) AND (NOT (nlO1Ol XOR (NOT SYNC_COMP_PAT(5))))) AND (NOT (nlO1OO XOR (NOT SYNC_COMP_PAT(6))))) AND (NOT (nlO01i XOR (NOT SYNC_COMP_PAT(7))))) AND (NOT (nlO01l XOR (NOT SYNC_COMP_PAT(8))))) AND (NOT (nlOOiO XOR (NOT SYNC_COMP_PAT(9)))));
	n1illl <= ((((((((((NOT (nlO1iO XOR SYNC_COMP_PAT(0))) AND (NOT (nlO1li XOR SYNC_COMP_PAT(1)))) AND (NOT (nlO1ll XOR SYNC_COMP_PAT(2)))) AND (NOT (nlO1lO XOR SYNC_COMP_PAT(3)))) AND (NOT (nlO1Oi XOR SYNC_COMP_PAT(4)))) AND (NOT (nlO1Ol XOR SYNC_COMP_PAT(5)))) AND (NOT (nlO1OO XOR SYNC_COMP_PAT(6)))) AND (NOT (nlO01i XOR SYNC_COMP_PAT(7)))) AND (NOT (nlO01l XOR SYNC_COMP_PAT(8)))) AND (NOT (nlOOiO XOR SYNC_COMP_PAT(9))));
	n1illO <= (((NOT (((n1iO1O OR n11OOl) OR (((wire_nilOi_w_lg_w_lg_nlO1OO2261w2266w(0) OR (nlO1OO AND n1iO1l)) AND wire_w_lg_n11Oll2269w(0)) AND (NOT (((n1iliO OR n1ilil) OR n1il0O) OR n1ilii)))) OR ((wire_nilOi_w_lg_w_lg_nlOOiO830w2276w(0) OR (nlOOiO AND n1iO1l)) AND wire_w_lg_n1ilil2280w(0)))) AND (NOT (wire_w_lg_n11Oli2285w(0) OR wire_w_lg_n1iOOi2288w(0)))) AND (NOT (((wire_nilOi_w_lg_w_lg_w_lg_nlO01i832w2292w2293w(0) OR wire_w_lg_n11OlO2295w(0)) AND IB_INVALID_CODE(0)) OR ((wire_nilOi_w_lg_nlO01l2301w(0) OR (wire_nilOi_w_lg_nlO01l831w(0) AND (wire_nilOi_w_lg_nlO01i832w(0) AND (n1ilil AND n1ilOl)))) AND IB_INVALID_CODE(1)))));
	n1ilOi <= (((((wire_nilOi_w_lg_nlll1i791w(0) AND wire_w_lg_n1iOOl799w(0)) OR wire_nilOi_w_lg_nlll1i804w(0)) OR (wire_n0l1lO_w_lg_dataout806w(0) AND wire_w_lg_w_lg_n1iO1O807w808w(0))) OR wire_n0l1lO_w_lg_dataout814w(0)) AND wire_w_lg_DISABLE_RX_DISP816w(0));
	n1ilOl <= ((((((wire_nilOi_w_lg_nlOOiO830w(0) AND (wire_nilOi_w_lg_nlO01l831w(0) AND (nlO1OO AND nlO01i))) OR (wire_nilOi_w_lg_nlOOiO830w(0) AND (nlO01l AND n11Oii))) OR (wire_nilOi_w_lg_nlOOiO830w(0) AND (nlO01l AND n11O0O))) OR wire_nilOi_w_lg_nlOOiO2326w(0)) OR wire_nilOi_w_lg_nlOOiO2329w(0)) OR wire_nilOi_w_lg_nlOOiO2333w(0));
	n1ilOO <= (n11OOl OR n11OOi);
	n1iO0i <= (n11O1O AND n1iOil);
	n1iO0l <= (((wire_w_lg_n11OiO2368w(0) OR (n11O1O AND n1iO0O)) OR n11Oil) OR n11Oli);
	n1iO0O <= (wire_nilOi_w_lg_nlO1Oi2407w(0) OR wire_nilOi_w_lg_w_lg_nlO1Oi2387w2408w(0));
	n1iO1i <= (wire_nilOi_w_lg_nlO01i832w(0) AND wire_nilOi_w_lg_w_lg_nlO1OO2261w2262w(0));
	n1iO1l <= ((((wire_nilOi_w_lg_nlOOiO830w(0) AND (wire_nilOi_w_lg_nlO01l831w(0) AND wire_nilOi_w_lg_nlO1OO2314w(0))) OR (wire_nilOi_w_lg_nlOOiO830w(0) AND (wire_nilOi_w_lg_nlO01l831w(0) AND wire_nilOi_w_lg_w_lg_nlO1OO2261w2315w(0)))) OR (wire_nilOi_w_lg_nlOOiO830w(0) AND (nlO01l AND n11O0l))) OR wire_nilOi_w_lg_nlOOiO2348w(0));
	n1iO1O <= (wire_nilOi_w_lg_nlOOiO830w(0) AND (wire_nilOi_w_lg_nlO01l831w(0) AND wire_nilOi_w_lg_w_lg_nlO1OO2261w2331w(0)));
	n1iOii <= ((((wire_nilOi_w_lg_nlO1lO801w(0) AND (wire_nilOi_w_lg_nlO1ll2388w(0) AND wire_nilOi_w_lg_nlO1iO2416w(0))) OR (wire_nilOi_w_lg_nlO1lO801w(0) AND (wire_nilOi_w_lg_nlO1ll2388w(0) AND wire_nilOi_w_lg_w_lg_nlO1iO2379w2417w(0)))) OR (wire_nilOi_w_lg_nlO1lO801w(0) AND (nlO1ll AND n11lll))) OR wire_nilOi_w_lg_nlO1lO2440w(0));
	n1iOil <= (wire_nilOi_w_lg_nlO1Oi2387w(0) AND wire_nilOi_w_lg_nlO1Ol2386w(0));
	n1iOiO <= ((((((wire_nilOi_w_lg_nlO1lO801w(0) AND (wire_nilOi_w_lg_nlO1ll2388w(0) AND (nlO1iO AND nlO1li))) OR (wire_nilOi_w_lg_nlO1lO801w(0) AND (nlO1ll AND n11lOi))) OR (wire_nilOi_w_lg_nlO1lO801w(0) AND (nlO1ll AND n11llO))) OR wire_nilOi_w_lg_nlO1lO2425w(0)) OR wire_nilOi_w_lg_nlO1lO2428w(0)) OR wire_nilOi_w_lg_nlO1lO2383w(0));
	n1iOli <= (n1iOil AND n11lOO);
	n1iOll <= (n1iO0O AND n11lOO);
	n1iOlO <= (n1iOii AND n1iOil);
	n1iOOi <= (n11O1l AND n11lOO);
	n1iOOl <= (nlO1lO AND n11lOl);
	n1iOOO <= (PMADATAWIDTH AND wire_w_lg_n1l11l789w(0));
	n1l00i <= (wire_n010O_w_lg_w_lg_w268w271w274w(0) OR wire_n00Oi_w_lg_dataout275w(0));
	n1l00l <= (wire_n010O_w_lg_w268w271w(0) OR wire_n00li_w_lg_dataout272w(0));
	n1l00O <= (wire_n010O_w268w(0) OR wire_n00ii_w_lg_dataout269w(0));
	n1l01i <= (((wire_n1iOO_w_lg_n1l1i1438w(0) AND wire_n1iOO_w_lg_n1i1O1439w(0)) AND wire_n1iOO_w_lg_n1i1l1441w(0)) AND wire_n1iOO_w_lg_n1i1i1443w(0));
	n1l01l <= ((((((((wire_n010O_w_lg_dataout278w(0) OR wire_w_lg_n1l0li279w(0)) OR wire_w_lg_n1l0iO281w(0)) OR wire_w_lg_n1l0il283w(0)) OR wire_w_lg_n1l0ii285w(0)) OR wire_w_lg_n1l00O287w(0)) OR wire_w_lg_n1l00l289w(0)) OR wire_w_lg_n1l00i291w(0)) OR n1l01O);
	n1l01O <= (((((((((wire_n010O_w_lg_dataout1428w(0) AND wire_n01il_w_lg_dataout254w(0)) AND wire_n01li_w_lg_dataout257w(0)) AND wire_n01Oi_w_lg_dataout260w(0)) AND wire_n001i_w_lg_dataout263w(0)) AND wire_n000i_w_lg_dataout266w(0)) AND wire_n00ii_w_lg_dataout269w(0)) AND wire_n00li_w_lg_dataout272w(0)) AND wire_n00Oi_w_lg_dataout275w(0)) AND wire_n0i1i_dataout);
	n1l0ii <= (wire_n010O_w_lg_w_lg_w_lg_w_lg_dataout256w259w262w265w(0) OR wire_n000i_w_lg_dataout266w(0));
	n1l0il <= (wire_n010O_w_lg_w_lg_w_lg_dataout256w259w262w(0) OR wire_n001i_w_lg_dataout263w(0));
	n1l0iO <= (wire_n010O_w_lg_w_lg_dataout256w259w(0) OR wire_n01Oi_w_lg_dataout260w(0));
	n1l0li <= (wire_n010O_w_lg_dataout256w(0) OR wire_n01li_w_lg_dataout257w(0));
	n1l0ll <= (wire_n010O_dataout OR wire_n01il_w_lg_dataout254w(0));
	n1l0lO <= ((((((((((NOT (SYNC_COMP_PAT(0) XOR wire_n0i0i_dataout)) AND (NOT (SYNC_COMP_PAT(1) XOR wire_n0i0l_dataout))) AND (NOT (SYNC_COMP_PAT(2) XOR wire_n0i0O_dataout))) AND (NOT (SYNC_COMP_PAT(3) XOR wire_n0iii_dataout))) AND (NOT (SYNC_COMP_PAT(4) XOR wire_n0iil_dataout))) AND (NOT (SYNC_COMP_PAT(5) XOR wire_n0iiO_dataout))) AND (NOT (SYNC_COMP_PAT(6) XOR wire_n0ili_dataout))) AND (NOT (wire_n0ill_dataout XOR wire_niilO_dataout))) AND (NOT (wire_n0ilO_dataout XOR wire_niiOi_dataout))) AND (NOT (wire_n0iOi_dataout XOR wire_niiOl_dataout)));
	n1l0Oi <= ((((((((((NOT (wire_ni0ii_dataout XOR wire_n0i0i_dataout)) AND (NOT (wire_ni0il_dataout XOR wire_n0i0l_dataout))) AND (NOT (wire_ni0iO_dataout XOR wire_n0i0O_dataout))) AND (NOT (wire_ni0li_dataout XOR wire_n0iii_dataout))) AND (NOT (wire_ni0ll_dataout XOR wire_n0iil_dataout))) AND (NOT (wire_ni0lO_dataout XOR wire_n0iiO_dataout))) AND (NOT (wire_ni0Oi_dataout XOR wire_n0ili_dataout))) AND (NOT (wire_ni0Ol_dataout XOR wire_n0ill_dataout))) AND (NOT (wire_ni0OO_dataout XOR wire_n0ilO_dataout))) AND (NOT (wire_nii1i_dataout XOR wire_n0iOi_dataout)));
	n1l0Ol <= ((((((((((NOT (SYNC_COMP_PAT(0) XOR wire_n0liO_dataout)) AND (NOT (SYNC_COMP_PAT(1) XOR wire_n0lli_dataout))) AND (NOT (SYNC_COMP_PAT(2) XOR wire_n0lll_dataout))) AND (NOT (SYNC_COMP_PAT(3) XOR wire_n0llO_dataout))) AND (NOT (SYNC_COMP_PAT(4) XOR wire_n0lOi_dataout))) AND (NOT (SYNC_COMP_PAT(5) XOR wire_n0lOl_dataout))) AND (NOT (SYNC_COMP_PAT(6) XOR wire_n0lOO_dataout))) AND (NOT (wire_niilO_dataout XOR wire_n0O1i_dataout))) AND (NOT (wire_niiOi_dataout XOR wire_n0O1l_dataout))) AND (NOT (wire_niiOl_dataout XOR wire_n0O1O_dataout)));
	n1l0OO <= ((((((((((NOT (wire_ni0ii_dataout XOR wire_n0liO_dataout)) AND (NOT (wire_ni0il_dataout XOR wire_n0lli_dataout))) AND (NOT (wire_ni0iO_dataout XOR wire_n0lll_dataout))) AND (NOT (wire_ni0li_dataout XOR wire_n0llO_dataout))) AND (NOT (wire_ni0ll_dataout XOR wire_n0lOi_dataout))) AND (NOT (wire_ni0lO_dataout XOR wire_n0lOl_dataout))) AND (NOT (wire_ni0Oi_dataout XOR wire_n0lOO_dataout))) AND (NOT (wire_ni0Ol_dataout XOR wire_n0O1i_dataout))) AND (NOT (wire_ni0OO_dataout XOR wire_n0O1l_dataout))) AND (NOT (wire_nii1i_dataout XOR wire_n0O1O_dataout)));
	n1l10i <= (wire_n10iO_o(1) OR wire_n10iO_o(19));
	n1l10l <= (wire_n10iO_o(2) OR wire_n10iO_o(20));
	n1l10O <= (wire_n10iO_o(3) OR wire_n10iO_o(21));
	n1l11i <= (n1lll AND (PMADATAWIDTH AND n1llO));
	n1l11l <= (n1llO AND n1lll);
	n1l11O <= (wire_nlOOil_o(1) OR wire_nlOOil_o(0));
	n1l1ii <= (wire_n10iO_o(4) OR wire_n10iO_o(22));
	n1l1il <= (wire_n10iO_o(5) OR wire_n10iO_o(23));
	n1l1iO <= (wire_n10iO_o(6) OR wire_n10iO_o(24));
	n1l1li <= (wire_n10iO_o(7) OR wire_n10iO_o(25));
	n1l1ll <= (((((((((((((wire_n10iO_o(31) OR wire_n10iO_o(30)) OR wire_n10iO_o(29)) OR wire_n10iO_o(28)) OR wire_n10iO_o(27)) OR wire_n10iO_o(26)) OR wire_n10iO_o(15)) OR wire_n10iO_o(14)) OR wire_n10iO_o(13)) OR wire_n10iO_o(12)) OR wire_n10iO_o(11)) OR wire_n10iO_o(10)) OR wire_n10iO_o(0)) OR wire_n10iO_o(18));
	n1l1lO <= (((((((((wire_n10iO_o(17) OR wire_n10iO_o(16)) OR wire_n10iO_o(18)) OR wire_n10iO_o(25)) OR wire_n10iO_o(24)) OR wire_n10iO_o(23)) OR wire_n10iO_o(22)) OR wire_n10iO_o(21)) OR wire_n10iO_o(20)) OR wire_n10iO_o(19));
	n1l1Oi <= ((((((((((((wire_n10iO_o(31) OR wire_n10iO_o(30)) OR wire_n10iO_o(29)) OR wire_n10iO_o(28)) OR wire_n10iO_o(27)) OR wire_n10iO_o(26)) OR wire_n10iO_o(15)) OR wire_n10iO_o(14)) OR wire_n10iO_o(13)) OR wire_n10iO_o(12)) OR wire_n10iO_o(11)) OR wire_n10iO_o(10)) OR wire_n10iO_o(0));
	n1l1Ol <= (PMADATAWIDTH AND n1l01i);
	n1l1OO <= (wire_w_lg_PMADATAWIDTH126w(0) AND n1l01i);
	n1li0i <= ((((((((((NOT (niOOi XOR wire_ni0ii_dataout)) AND (NOT (niOOl XOR wire_ni0il_dataout))) AND (NOT (niOOO XOR wire_ni0iO_dataout))) AND (NOT (nl11i XOR wire_ni0li_dataout))) AND (NOT (nl11l XOR wire_ni0ll_dataout))) AND (NOT (nl11O XOR wire_ni0lO_dataout))) AND (NOT (wire_ni0Oi_dataout XOR nl10i))) AND (NOT (wire_ni0Ol_dataout XOR wire_n0OiO_dataout))) AND (NOT (wire_ni0OO_dataout XOR wire_n0Oli_dataout))) AND (NOT (wire_nii1i_dataout XOR wire_n0Oll_dataout)));
	n1li0l <= ((((((((((NOT (SYNC_COMP_PAT(0) XOR niOOl)) AND (NOT (SYNC_COMP_PAT(1) XOR niOOO))) AND (NOT (SYNC_COMP_PAT(2) XOR nl11i))) AND (NOT (SYNC_COMP_PAT(3) XOR nl11l))) AND (NOT (SYNC_COMP_PAT(4) XOR nl11O))) AND (NOT (SYNC_COMP_PAT(5) XOR nl10i))) AND (NOT (SYNC_COMP_PAT(6) XOR nl10l))) AND (NOT (wire_niilO_dataout XOR wire_n0OOi_dataout))) AND (NOT (wire_niiOi_dataout XOR wire_n0OOl_dataout))) AND (NOT (wire_niiOl_dataout XOR wire_n0OOO_dataout)));
	n1li0O <= ((((((((((NOT (niOOl XOR wire_ni0ii_dataout)) AND (NOT (niOOO XOR wire_ni0il_dataout))) AND (NOT (nl11i XOR wire_ni0iO_dataout))) AND (NOT (nl11l XOR wire_ni0li_dataout))) AND (NOT (nl11O XOR wire_ni0ll_dataout))) AND (NOT (wire_ni0lO_dataout XOR nl10i))) AND (NOT (wire_ni0Oi_dataout XOR nl10l))) AND (NOT (wire_ni0Ol_dataout XOR wire_n0OOi_dataout))) AND (NOT (wire_ni0OO_dataout XOR wire_n0OOl_dataout))) AND (NOT (wire_nii1i_dataout XOR wire_n0OOO_dataout)));
	n1li1i <= ((((((((((NOT (SYNC_COMP_PAT(0) XOR niOlO)) AND (NOT (SYNC_COMP_PAT(1) XOR niOOi))) AND (NOT (SYNC_COMP_PAT(2) XOR niOOl))) AND (NOT (SYNC_COMP_PAT(3) XOR niOOO))) AND (NOT (SYNC_COMP_PAT(4) XOR nl11i))) AND (NOT (SYNC_COMP_PAT(5) XOR nl11l))) AND (NOT (SYNC_COMP_PAT(6) XOR nl11O))) AND (NOT (wire_niilO_dataout XOR wire_n0O0l_dataout))) AND (NOT (wire_niiOi_dataout XOR wire_n0O0O_dataout))) AND (NOT (wire_niiOl_dataout XOR wire_n0Oii_dataout)));
	n1li1l <= ((((((((((NOT (niOlO XOR wire_ni0ii_dataout)) AND (NOT (niOOi XOR wire_ni0il_dataout))) AND (NOT (niOOl XOR wire_ni0iO_dataout))) AND (NOT (niOOO XOR wire_ni0li_dataout))) AND (NOT (nl11i XOR wire_ni0ll_dataout))) AND (NOT (nl11l XOR wire_ni0lO_dataout))) AND (NOT (nl11O XOR wire_ni0Oi_dataout))) AND (NOT (wire_ni0Ol_dataout XOR wire_n0O0l_dataout))) AND (NOT (wire_ni0OO_dataout XOR wire_n0O0O_dataout))) AND (NOT (wire_nii1i_dataout XOR wire_n0Oii_dataout)));
	n1li1O <= ((((((((((NOT (SYNC_COMP_PAT(0) XOR niOOi)) AND (NOT (SYNC_COMP_PAT(1) XOR niOOl))) AND (NOT (SYNC_COMP_PAT(2) XOR niOOO))) AND (NOT (SYNC_COMP_PAT(3) XOR nl11i))) AND (NOT (SYNC_COMP_PAT(4) XOR nl11l))) AND (NOT (SYNC_COMP_PAT(5) XOR nl11O))) AND (NOT (SYNC_COMP_PAT(6) XOR nl10i))) AND (NOT (wire_niilO_dataout XOR wire_n0OiO_dataout))) AND (NOT (wire_niiOi_dataout XOR wire_n0Oli_dataout))) AND (NOT (wire_niiOl_dataout XOR wire_n0Oll_dataout)));
	n1liii <= ((((((((((NOT (SYNC_COMP_PAT(0) XOR niOOO)) AND (NOT (SYNC_COMP_PAT(1) XOR nl11i))) AND (NOT (SYNC_COMP_PAT(2) XOR nl11l))) AND (NOT (SYNC_COMP_PAT(3) XOR nl11O))) AND (NOT (SYNC_COMP_PAT(4) XOR nl10i))) AND (NOT (SYNC_COMP_PAT(5) XOR nl10l))) AND (NOT (SYNC_COMP_PAT(6) XOR nl10O))) AND (NOT (wire_niilO_dataout XOR wire_ni11l_dataout))) AND (NOT (wire_niiOi_dataout XOR wire_ni11O_dataout))) AND (NOT (wire_niiOl_dataout XOR wire_ni10i_dataout)));
	n1liil <= ((((((((((NOT (niOOO XOR wire_ni0ii_dataout)) AND (NOT (nl11i XOR wire_ni0il_dataout))) AND (NOT (nl11l XOR wire_ni0iO_dataout))) AND (NOT (nl11O XOR wire_ni0li_dataout))) AND (NOT (wire_ni0ll_dataout XOR nl10i))) AND (NOT (wire_ni0lO_dataout XOR nl10l))) AND (NOT (wire_ni0Oi_dataout XOR nl10O))) AND (NOT (wire_ni0Ol_dataout XOR wire_ni11l_dataout))) AND (NOT (wire_ni0OO_dataout XOR wire_ni11O_dataout))) AND (NOT (wire_nii1i_dataout XOR wire_ni10i_dataout)));
	n1lill <= ((((((((((NOT (SYNC_COMP_PAT(0) XOR nl11i)) AND (NOT (SYNC_COMP_PAT(1) XOR nl11l))) AND (NOT (SYNC_COMP_PAT(2) XOR nl11O))) AND (NOT (SYNC_COMP_PAT(3) XOR nl10i))) AND (NOT (SYNC_COMP_PAT(4) XOR nl10l))) AND (NOT (SYNC_COMP_PAT(5) XOR nl10O))) AND (NOT (SYNC_COMP_PAT(6) XOR nl1ii))) AND (NOT (wire_niilO_dataout XOR wire_ni10O_dataout))) AND (NOT (wire_niiOi_dataout XOR wire_ni1ii_dataout))) AND (NOT (wire_niiOl_dataout XOR wire_ni1il_dataout)));
	n1lilO <= ((((((((((NOT (nl11i XOR wire_ni0ii_dataout)) AND (NOT (nl11l XOR wire_ni0il_dataout))) AND (NOT (nl11O XOR wire_ni0iO_dataout))) AND (NOT (wire_ni0li_dataout XOR nl10i))) AND (NOT (wire_ni0ll_dataout XOR nl10l))) AND (NOT (wire_ni0lO_dataout XOR nl10O))) AND (NOT (wire_ni0Oi_dataout XOR nl1ii))) AND (NOT (wire_ni0Ol_dataout XOR wire_ni10O_dataout))) AND (NOT (wire_ni0OO_dataout XOR wire_ni1ii_dataout))) AND (NOT (wire_nii1i_dataout XOR wire_ni1il_dataout)));
	n1ll1l <= ((((((((((NOT (SYNC_COMP_PAT(0) XOR nl11l)) AND (NOT (SYNC_COMP_PAT(1) XOR nl11O))) AND (NOT (SYNC_COMP_PAT(2) XOR nl10i))) AND (NOT (SYNC_COMP_PAT(3) XOR nl10l))) AND (NOT (SYNC_COMP_PAT(4) XOR nl10O))) AND (NOT (SYNC_COMP_PAT(5) XOR nl1ii))) AND (NOT (SYNC_COMP_PAT(6) XOR nl1il))) AND (NOT (wire_niilO_dataout XOR wire_ni1li_dataout))) AND (NOT (wire_niiOi_dataout XOR wire_ni1ll_dataout))) AND (NOT (wire_niiOl_dataout XOR wire_ni1lO_dataout)));
	n1ll1O <= ((((((((((NOT (nl11l XOR wire_ni0ii_dataout)) AND (NOT (nl11O XOR wire_ni0il_dataout))) AND (NOT (wire_ni0iO_dataout XOR nl10i))) AND (NOT (wire_ni0li_dataout XOR nl10l))) AND (NOT (wire_ni0ll_dataout XOR nl10O))) AND (NOT (wire_ni0lO_dataout XOR nl1ii))) AND (NOT (wire_ni0Oi_dataout XOR nl1il))) AND (NOT (wire_ni0Ol_dataout XOR wire_ni1li_dataout))) AND (NOT (wire_ni0OO_dataout XOR wire_ni1ll_dataout))) AND (NOT (wire_nii1i_dataout XOR wire_ni1lO_dataout)));
	n1llli <= ((((((((((NOT (SYNC_COMP_PAT(0) XOR nl11O)) AND (NOT (SYNC_COMP_PAT(1) XOR nl10i))) AND (NOT (SYNC_COMP_PAT(2) XOR nl10l))) AND (NOT (SYNC_COMP_PAT(3) XOR nl10O))) AND (NOT (SYNC_COMP_PAT(4) XOR nl1ii))) AND (NOT (SYNC_COMP_PAT(5) XOR nl1il))) AND (NOT (SYNC_COMP_PAT(6) XOR nl1iO))) AND (NOT (wire_niilO_dataout XOR wire_ni1Ol_dataout))) AND (NOT (wire_niiOi_dataout XOR wire_ni1OO_dataout))) AND (NOT (wire_niiOl_dataout XOR wire_ni01i_dataout)));
	n1llll <= ((((((((((NOT (nl11O XOR wire_ni0ii_dataout)) AND (NOT (wire_ni0il_dataout XOR nl10i))) AND (NOT (wire_ni0iO_dataout XOR nl10l))) AND (NOT (wire_ni0li_dataout XOR nl10O))) AND (NOT (wire_ni0ll_dataout XOR nl1ii))) AND (NOT (wire_ni0lO_dataout XOR nl1il))) AND (NOT (wire_ni0Oi_dataout XOR nl1iO))) AND (NOT (wire_ni0Ol_dataout XOR wire_ni1Ol_dataout))) AND (NOT (wire_ni0OO_dataout XOR wire_ni1OO_dataout))) AND (NOT (wire_nii1i_dataout XOR wire_ni01i_dataout)));
	n1lO0l <= ((((((((((NOT (SYNC_COMP_PAT(0) XOR nl10i)) AND (NOT (SYNC_COMP_PAT(1) XOR nl10l))) AND (NOT (SYNC_COMP_PAT(2) XOR nl10O))) AND (NOT (SYNC_COMP_PAT(3) XOR nl1ii))) AND (NOT (SYNC_COMP_PAT(4) XOR nl1il))) AND (NOT (SYNC_COMP_PAT(5) XOR nl1iO))) AND (NOT (SYNC_COMP_PAT(6) XOR nl1li))) AND (NOT (wire_niilO_dataout XOR wire_ni01O_dataout))) AND (NOT (wire_niiOi_dataout XOR wire_ni00i_dataout))) AND (NOT (wire_niiOl_dataout XOR wire_ni00l_dataout)));
	n1lO0O <= ((((((((((NOT (wire_ni0ii_dataout XOR nl10i)) AND (NOT (wire_ni0il_dataout XOR nl10l))) AND (NOT (wire_ni0iO_dataout XOR nl10O))) AND (NOT (wire_ni0li_dataout XOR nl1ii))) AND (NOT (wire_ni0ll_dataout XOR nl1il))) AND (NOT (wire_ni0lO_dataout XOR nl1iO))) AND (NOT (wire_ni0Oi_dataout XOR nl1li))) AND (NOT (wire_ni0Ol_dataout XOR wire_ni01O_dataout))) AND (NOT (wire_ni0OO_dataout XOR wire_ni00i_dataout))) AND (NOT (wire_nii1i_dataout XOR wire_ni00l_dataout)));
	n1lOii <= ((NOT SYNC_COMP_SIZE(0)) AND wire_w_lg_w_SYNC_COMP_SIZE_range844w845w(0));
	n1lOil <= wire_w_lg_w_SYNC_COMP_SIZE_range842w847w(0);
	n1lOiO <= ((NOT (wire_w_lg_w_lg_n1O1il46w47w(0) AND wire_w_lg_n1O10l48w(0))) AND wire_n1O0OO_dataout);
	n1O0ii <= (ni0O0l OR ni0O0i);
	n1O10l <= ((((wire_w_lg_n1l0ll277w(0) OR wire_w_lg_n1l0iO281w(0)) OR wire_w_lg_n1l0ii285w(0)) OR wire_w_lg_n1l00l289w(0)) OR n1l01O);
	n1O10O <= ((((wire_w_lg_n1l0li279w(0) OR wire_w_lg_n1l0iO281w(0)) OR wire_w_lg_n1l00O287w(0)) OR wire_w_lg_n1l00l289w(0)) OR wire_w_lg_n1l01l294w(0));
	n1O11l <= (n01Oli AND wire_w_lg_n1O1li53w(0));
	n1O1ii <= ((((wire_w_lg_n1l0li279w(0) OR wire_w_lg_n1l0iO281w(0)) OR wire_w_lg_n1l0il283w(0)) OR wire_w_lg_n1l0ii285w(0)) OR wire_w_lg_n1l01l294w(0));
	n1O1il <= (wire_n010O_w_lg_dataout278w(0) OR wire_w_lg_n1l01l294w(0));
	n1O1iO <= (n01Oli AND n1O1li);
	n1O1li <= ((wire_w_lg_w_lg_n1O1il46w47w(0) AND wire_w_lg_n1O10l48w(0)) AND n1O11O8);
	n1O1ll <= '1';
	n1O1lO <= ((((n01O0i OR n01llO) OR n01O1O) OR n01lOi) OR n01O0l);
	n1O1Oi <= ((((n01O1l OR n01lOO) OR n01lOl) OR n01O1i) OR n01lOi);
	n1O1Ol <= (((((n01O0i OR n01lOO) OR n01liO) OR n01O1O) OR n01lOl) OR n1O0li);
	n1O1OO <= (((((n01O0i OR n01O1l) OR n01lOO) OR n01llO) OR n01lll) OR n01liO);
	RLV <= n1O0ii;
	RLV_lt <= ((((ni0lOi OR ni0llO) OR wire_n1O01O2_w_lg_Q29w(0)) OR (ni0lll AND DWIDTH)) OR wire_n1O01i5_w_lg_Q35w(0));
	signal_detect_sync <= n01Oii;
	SUDI <= ( nllO0l & nllO0i & nllO1O & nllO1l & nllO1i & nlllOO & nlllOl & nlllOi & nllllO & nlllll & nlllli & nllliO & nlllil);
	SUDI_pre <= ( nlOOiO & nlO01l & nlO01i & nlO1OO & nlO1Ol & nlO1Oi & nlO1lO & nlO1ll & nlO1li & nlO1iO);
	sync_curr_st <= ( n1O1lO & n1O1Oi & wire_w_lg_n1O1Ol40w & n1O1OO);
	sync_status <= n1O0Oi;
	wire_w_SYNC_COMP_SIZE_range842w(0) <= SYNC_COMP_SIZE(0);
	wire_w_SYNC_COMP_SIZE_range844w(0) <= SYNC_COMP_SIZE(1);
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1liiO58 <= n1liiO60;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1liiO59 <= (n1liiO60 XOR n1liiO58);
		END IF;
	END PROCESS;
	wire_n1liiO59_w_lg_Q211w(0) <= NOT n1liiO59;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1liiO60 <= n1liiO58;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1liOi55 <= n1liOi57;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1liOi56 <= (n1liOi57 XOR n1liOi55);
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1liOi57 <= n1liOi55;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1liOO52 <= n1liOO54;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1liOO53 <= (n1liOO54 XOR n1liOO52);
		END IF;
	END PROCESS;
	wire_n1liOO53_w_lg_Q196w(0) <= NOT n1liOO53;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1liOO54 <= n1liOO52;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1ll0i49 <= n1ll0i51;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1ll0i50 <= (n1ll0i51 XOR n1ll0i49);
		END IF;
	END PROCESS;
	wire_n1ll0i50_w_lg_Q191w(0) <= NOT n1ll0i50;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1ll0i51 <= n1ll0i49;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1ll0O46 <= n1ll0O48;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1ll0O47 <= (n1ll0O48 XOR n1ll0O46);
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1ll0O48 <= n1ll0O46;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1llil43 <= n1llil45;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1llil44 <= (n1llil45 XOR n1llil43);
		END IF;
	END PROCESS;
	wire_n1llil44_w_lg_Q177w(0) <= NOT n1llil44;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1llil45 <= n1llil43;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lllO40 <= n1lllO42;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lllO41 <= (n1lllO42 XOR n1lllO40);
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lllO42 <= n1lllO40;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1llOl37 <= n1llOl39;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1llOl38 <= (n1llOl39 XOR n1llOl37);
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1llOl39 <= n1llOl37;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lO1i34 <= n1lO1i36;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lO1i35 <= (n1lO1i36 XOR n1lO1i34);
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lO1i36 <= n1lO1i34;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lO1O31 <= n1lO1O33;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lO1O32 <= (n1lO1O33 XOR n1lO1O31);
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lO1O33 <= n1lO1O31;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOli28 <= n1lOli30;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOli29 <= (n1lOli30 XOR n1lOli28);
		END IF;
	END PROCESS;
	wire_n1lOli29_w_lg_Q104w(0) <= n1lOli29 AND wire_nll1l_dataout;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOli30 <= n1lOli28;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOll25 <= n1lOll27;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOll26 <= (n1lOll27 XOR n1lOll25);
		END IF;
	END PROCESS;
	wire_n1lOll26_w_lg_Q98w(0) <= n1lOll26 AND nlill;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOll27 <= n1lOll25;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOlO22 <= n1lOlO24;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOlO23 <= (n1lOlO24 XOR n1lOlO22);
		END IF;
	END PROCESS;
	wire_n1lOlO23_w_lg_Q91w(0) <= n1lOlO23 AND wire_nll1O_dataout;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOlO24 <= n1lOlO22;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOOi19 <= n1lOOi21;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOOi20 <= (n1lOOi21 XOR n1lOOi19);
		END IF;
	END PROCESS;
	wire_n1lOOi20_w_lg_Q81w(0) <= n1lOOi20 AND wire_nll0O_dataout;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOOi21 <= n1lOOi19;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOOl16 <= n1lOOl18;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOOl17 <= (n1lOOl18 XOR n1lOOl16);
		END IF;
	END PROCESS;
	wire_n1lOOl17_w_lg_Q71w(0) <= n1lOOl17 AND wire_nllii_dataout;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOOl18 <= n1lOOl16;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOOO13 <= n1lOOO15;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOOO14 <= (n1lOOO15 XOR n1lOOO13);
		END IF;
	END PROCESS;
	wire_n1lOOO14_w_lg_Q66w(0) <= n1lOOO14 AND wire_nllll_w_lg_n01Oli65w(0);
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1lOOO15 <= n1lOOO13;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1O01i4 <= n1O01i6;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1O01i5 <= (n1O01i6 XOR n1O01i4);
		END IF;
	END PROCESS;
	wire_n1O01i5_w_lg_Q35w(0) <= NOT n1O01i5;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1O01i6 <= n1O01i4;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1O01O1 <= n1O01O3;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1O01O2 <= (n1O01O3 XOR n1O01O1);
		END IF;
	END PROCESS;
	wire_n1O01O2_w_lg_Q29w(0) <= NOT n1O01O2;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1O01O3 <= n1O01O1;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1O11i10 <= n1O11i12;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1O11i11 <= (n1O11i12 XOR n1O11i10);
		END IF;
	END PROCESS;
	wire_n1O11i11_w_lg_Q62w(0) <= n1O11i11 AND nlill;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1O11i12 <= n1O11i10;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1O11O7 <= n1O11O9;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1O11O8 <= (n1O11O9 XOR n1O11O7);
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk)
	BEGIN
		IF (rcvd_clk = '1' AND rcvd_clk'event) THEN n1O11O9 <= n1O11O7;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n1i1i <= '0';
				n1i1l <= '0';
				n1i1O <= '0';
				n1l1i <= '0';
		ELSIF (rcvd_clk = '0' AND rcvd_clk'event) THEN
			IF (n10ll = '1') THEN
				n1i1i <= wire_n1i0i_dataout;
				n1i1l <= wire_n1i0l_dataout;
				n1i1O <= wire_n1i0O_dataout;
				n1l1i <= wire_n1iii_dataout;
			END IF;
		END IF;
	END PROCESS;
	wire_n1iOO_w_lg_n1i1i1443w(0) <= NOT n1i1i;
	wire_n1iOO_w_lg_n1i1l1441w(0) <= NOT n1i1l;
	wire_n1iOO_w_lg_n1i1O1439w(0) <= NOT n1i1O;
	wire_n1iOO_w_lg_n1l1i1438w(0) <= NOT n1l1i;
	PROCESS (rcvd_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n1lOl <= '0';
				n1lOO <= '0';
				n1O1i <= '0';
				nil1O <= '0';
		ELSIF (rcvd_clk = '0' AND rcvd_clk'event) THEN
			IF (n1lOiO = '1') THEN
				n1lOl <= wire_w_lg_n1O10l48w(0);
				n1lOO <= n1O10O;
				n1O1i <= n1O1ii;
				nil1O <= n1O1il;
			END IF;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n01lil <= '0';
				n01liO <= '0';
				n01lli <= '0';
				n01lll <= '0';
				n01llO <= '0';
				n01lOi <= '0';
				n01lOl <= '0';
				n01lOO <= '0';
				n01O0i <= '0';
				n01O0l <= '0';
				n01O0O <= '0';
				n01O1i <= '0';
				n01O1l <= '0';
				n01O1O <= '0';
				n01Oii <= '0';
				n1lll <= '0';
				n1llO <= '0';
				n1O0Oi <= '0';
				n1O0Ol <= '0';
				n1Oi1O <= '0';
				ni0i0i <= '0';
				ni0i0l <= '0';
				ni0i0O <= '0';
				ni0iii <= '0';
				ni0iil <= '0';
				ni0iiO <= '0';
				ni0ili <= '0';
				ni0lli <= '0';
				ni0lll <= '0';
				ni0llO <= '0';
				ni0lOi <= '0';
				ni0O0i <= '0';
				ni0O0l <= '0';
				ni0O0O <= '0';
				ni0Oii <= '0';
				ni1iOO <= '0';
				ni1l0i <= '0';
				ni1l0l <= '0';
				ni1l0O <= '0';
				ni1l1i <= '0';
				ni1l1l <= '0';
				ni1l1O <= '0';
				ni1lii <= '0';
				nii00O <= '0';
				nii0ii <= '0';
				nii0il <= '0';
				nii0iO <= '0';
				nii0li <= '0';
				nii0ll <= '0';
				nii0lO <= '0';
				nii0Oi <= '0';
				nii0Ol <= '0';
				nii0OO <= '0';
				niii0i <= '0';
				niii0l <= '0';
				niii1i <= '0';
				niii1l <= '0';
				niii1O <= '0';
				niil0O <= '0';
				niilii <= '0';
				niilil <= '0';
				niiliO <= '0';
				niilli <= '0';
				niilll <= '0';
				niillO <= '0';
				niilOi <= '0';
				niilOl <= '0';
				niilOO <= '0';
				niiO0i <= '0';
				niiO1i <= '0';
				niiO1l <= '0';
				niiO1O <= '0';
				nil0i <= '0';
				nil0l <= '0';
				nil0O <= '0';
				nilii <= '0';
				nilil <= '0';
				niliO <= '0';
				nilli <= '0';
				nilll <= '0';
				nillO <= '0';
				nilOl <= '0';
				nlliOO <= '0';
				nlll0i <= '0';
				nlll0l <= '0';
				nlll0O <= '0';
				nlll1i <= '0';
				nlllii <= '0';
				nlllil <= '0';
				nllliO <= '0';
				nlllli <= '0';
				nlllll <= '0';
				nllllO <= '0';
				nlllOi <= '0';
				nlllOl <= '0';
				nlllOO <= '0';
				nllO0i <= '0';
				nllO0l <= '0';
				nllO0O <= '0';
				nllO1i <= '0';
				nllO1l <= '0';
				nllO1O <= '0';
				nllOii <= '0';
				nllOil <= '0';
				nllOiO <= '0';
				nllOli <= '0';
				nllOll <= '0';
				nllOlO <= '0';
				nllOOi <= '0';
				nllOOl <= '0';
				nllOOO <= '0';
				nlO01i <= '0';
				nlO01l <= '0';
				nlO10i <= '0';
				nlO10l <= '0';
				nlO10O <= '0';
				nlO11i <= '0';
				nlO11l <= '0';
				nlO11O <= '0';
				nlO1ii <= '0';
				nlO1il <= '0';
				nlO1iO <= '0';
				nlO1li <= '0';
				nlO1ll <= '0';
				nlO1lO <= '0';
				nlO1Oi <= '0';
				nlO1Ol <= '0';
				nlO1OO <= '0';
				nlOOiO <= '0';
		ELSIF (rcvd_clk = '1' AND rcvd_clk'event) THEN
				n01lil <= wire_n1Oi0l_o;
				n01liO <= wire_n1OilO_o;
				n01lli <= wire_n1Ol1i_o;
				n01lll <= wire_n1Ol0l_o;
				n01llO <= wire_n1OiOl_o;
				n01lOi <= wire_n1Ol1O_o;
				n01lOl <= wire_n1Olii_o;
				n01lOO <= wire_n1OliO_o;
				n01O0i <= wire_n1OlOO_o;
				n01O0l <= wire_n1OO1O_o;
				n01O0O <= (wire_w_lg_SYNC_SM_DIS823w(0) AND (LP10BEN OR signal_detect));
				n01O1i <= wire_n1OlOi_o;
				n01O1l <= wire_n1Olll_o;
				n01O1O <= wire_n1OO1l_o;
				n01Oii <= n01O0O;
				n1lll <= n1l0i;
				n1llO <= n1lOi;
				n1O0Oi <= wire_n1Oiii_o;
				n1O0Ol <= wire_n1Oili_o;
				n1Oi1O <= wire_n1Oi0i_o;
				ni0i0i <= wire_ni1lll_dataout;
				ni0i0l <= wire_ni1OOl_dataout;
				ni0i0O <= wire_ni011i_dataout;
				ni0iii <= wire_ni010i_o;
				ni0iil <= wire_ni010l_o;
				ni0iiO <= wire_ni1OOO_dataout;
				ni0ili <= wire_ni011l_o;
				ni0lli <= wire_ni01ii_o;
				ni0lll <= wire_ni0lOl_dataout;
				ni0llO <= wire_ni0lOO_dataout;
				ni0lOi <= wire_ni0O1i_dataout;
				ni0O0i <= wire_ni0O1l_dataout;
				ni0O0l <= ni0O0O;
				ni0O0O <= (niilii OR nii0ii);
				ni0Oii <= nii00O;
				ni1iOO <= wire_nil11O_dataout;
				ni1l0i <= wire_ni1lOi_o(3);
				ni1l0l <= wire_ni1lil_dataout;
				ni1l0O <= wire_ni1liO_dataout;
				ni1l1i <= wire_ni1lOi_o(0);
				ni1l1l <= wire_ni1lOi_o(1);
				ni1l1O <= wire_ni1lOi_o(2);
				ni1lii <= wire_ni1lli_dataout;
				nii00O <= RLV_EN;
				nii0ii <= wire_niii0O_dataout;
				nii0il <= wire_niiiii_dataout;
				nii0iO <= wire_niiiil_dataout;
				nii0li <= wire_niiiiO_dataout;
				nii0ll <= wire_niiili_dataout;
				nii0lO <= wire_niiill_dataout;
				nii0Oi <= wire_niiilO_dataout;
				nii0Ol <= wire_niiiOi_dataout;
				nii0OO <= wire_niiiOl_dataout;
				niii0i <= wire_niil1O_dataout;
				niii0l <= wire_niil0i_dataout;
				niii1i <= wire_niiiOO_dataout;
				niii1l <= wire_niil1i_dataout;
				niii1O <= wire_niil1l_dataout;
				niil0O <= wire_niil0l_dataout;
				niilii <= wire_niiO0l_dataout;
				niilil <= wire_niiO0O_dataout;
				niiliO <= wire_niiOii_dataout;
				niilli <= wire_niiOil_dataout;
				niilll <= wire_niiOiO_dataout;
				niillO <= wire_niiOli_dataout;
				niilOi <= wire_niiOll_dataout;
				niilOl <= wire_niiOlO_dataout;
				niilOO <= wire_niiOOi_dataout;
				niiO0i <= wire_nil11l_dataout;
				niiO1i <= wire_niiOOl_dataout;
				niiO1l <= wire_niiOOO_dataout;
				niiO1O <= wire_nil11i_dataout;
				nil0i <= nl10i;
				nil0l <= nl10l;
				nil0O <= nl10O;
				nilii <= nl1ii;
				nilil <= nl1il;
				niliO <= nl1iO;
				nilli <= nl1li;
				nilll <= nl1ll;
				nillO <= nl1Oi;
				nilOl <= nlliOl;
				nlliOO <= (((n1iliO OR n1ilil) OR (wire_nilOi_w_lg_nlOOiO830w(0) AND (wire_nilOi_w_lg_nlO01l831w(0) AND wire_nilOi_w_lg_w_lg_nlO01i832w833w(0)))) OR wire_nilOi_w_lg_nlOOiO839w(0));
				nlll0i <= (wire_w_lg_PMADATAWIDTH126w(0) AND (n1illl OR n1illi));
				nlll0l <= nlll0O;
				nlll0O <= nlllii;
				nlll1i <= wire_n0OO1l_dataout;
				nlllii <= n1l1O;
				nlllil <= wire_nlO0lO_dataout;
				nllliO <= wire_nlO0Oi_dataout;
				nlllli <= wire_nlO0Ol_dataout;
				nlllll <= wire_nlO0OO_dataout;
				nllllO <= wire_nlOi1i_dataout;
				nlllOi <= wire_nlOi1l_dataout;
				nlllOl <= wire_nlOi1O_dataout;
				nlllOO <= wire_nlOi0i_dataout;
				nllO0i <= (((wire_w_lg_PMADATAWIDTH126w(0) AND (nlllii AND SYNC_SM_DIS)) OR wire_w_lg_PMADATAWIDTH821w(0)) OR wire_nilOi_w_lg_n1O0Oi824w(0));
				nllO0l <= n1ilOi;
				nllO0O <= wire_nlOl0O_dataout;
				nllO1i <= wire_nlOi0l_dataout;
				nllO1l <= wire_nlOi0O_dataout;
				nllO1O <= wire_w_lg_n1illO826w(0);
				nllOii <= wire_nlOlii_dataout;
				nllOil <= wire_nlOlil_dataout;
				nllOiO <= wire_nlOliO_dataout;
				nllOli <= wire_nlOlli_dataout;
				nllOll <= wire_nlOlll_dataout;
				nllOlO <= wire_nlOllO_dataout;
				nllOOi <= wire_nlOlOi_dataout;
				nllOOl <= nlO1il;
				nllOOO <= wire_nlOlOl_o;
				nlO01i <= n111l;
				nlO01l <= n111O;
				nlO10i <= wire_nlOO1O_o;
				nlO10l <= wire_nlOO0i_o;
				nlO10O <= wire_nlOO0l_o;
				nlO11i <= wire_nlOlOO_o;
				nlO11l <= wire_nlOO1i_o;
				nlO11O <= wire_nlOO1l_o;
				nlO1ii <= wire_nlOO0O_o;
				nlO1il <= n1lll;
				nlO1iO <= nlOOli;
				nlO1li <= nlOOll;
				nlO1ll <= nlOOlO;
				nlO1lO <= nlOOOi;
				nlO1Oi <= nlOOOl;
				nlO1Ol <= nlOOOO;
				nlO1OO <= n111i;
				nlOOiO <= n10li;
		END IF;
	END PROCESS;
	wire_nilOi_w_lg_w_lg_w_lg_niliO1606w1607w1608w(0) <= wire_nilOi_w_lg_w_lg_niliO1606w1607w(0) AND nilll;
	wire_nilOi_w_lg_w_lg_w_lg_nilli1593w1603w1604w(0) <= wire_nilOi_w_lg_w_lg_nilli1593w1603w(0) AND nilOl;
	wire_nilOi_w_lg_w_lg_w_lg_nlO01i832w2292w2293w(0) <= wire_nilOi_w_lg_w_lg_nlO01i832w2292w(0) AND n11OlO;
	wire_nilOi_w_lg_w_lg_niliO1606w1607w(0) <= wire_nilOi_w_lg_niliO1606w(0) AND nilli;
	wire_nilOi_w_lg_w_lg_niliO1599w1600w(0) <= wire_nilOi_w_lg_niliO1599w(0) AND nilll;
	wire_nilOi_w_lg_w_lg_nilli1593w1603w(0) <= wire_nilOi_w_lg_nilli1593w(0) AND nillO;
	wire_nilOi_w_lg_w_lg_nilll1596w1597w(0) <= wire_nilOi_w_lg_nilll1596w(0) AND nilOl;
	wire_nilOi_w_lg_w_lg_nlO01i832w833w(0) <= wire_nilOi_w_lg_nlO01i832w(0) AND n1ilii;
	wire_nilOi_w_lg_w_lg_nlO01i832w2292w(0) <= wire_nilOi_w_lg_nlO01i832w(0) AND n1iliO;
	wire_nilOi_w_lg_w_lg_nlO01l831w2352w(0) <= wire_nilOi_w_lg_nlO01l831w(0) AND n11O0i;
	wire_nilOi_w_lg_w_lg_nlO01l831w2347w(0) <= wire_nilOi_w_lg_nlO01l831w(0) AND n11O0l;
	wire_nilOi_w_lg_w_lg_nlO01l831w2328w(0) <= wire_nilOi_w_lg_nlO01l831w(0) AND n11O0O;
	wire_nilOi_w_lg_w_lg_nlO01l831w2325w(0) <= wire_nilOi_w_lg_nlO01l831w(0) AND n11Oii;
	wire_nilOi_w_lg_w_lg_nlO1iO2379w2381w(0) <= wire_nilOi_w_lg_nlO1iO2379w(0) AND wire_nilOi_w_lg_nlO1li2380w(0);
	wire_nilOi_w_lg_w_lg_nlO1iO2379w2417w(0) <= wire_nilOi_w_lg_nlO1iO2379w(0) AND nlO1li;
	wire_nilOi_w_lg_w_lg_nlO1ll2388w2444w(0) <= wire_nilOi_w_lg_nlO1ll2388w(0) AND n11lli;
	wire_nilOi_w_lg_w_lg_nlO1ll2388w2439w(0) <= wire_nilOi_w_lg_nlO1ll2388w(0) AND n11lll;
	wire_nilOi_w_lg_w_lg_nlO1ll2388w2427w(0) <= wire_nilOi_w_lg_nlO1ll2388w(0) AND n11llO;
	wire_nilOi_w_lg_w_lg_nlO1ll2388w2424w(0) <= wire_nilOi_w_lg_nlO1ll2388w(0) AND n11lOi;
	wire_nilOi_w_lg_w_lg_nlO1lO801w2402w(0) <= wire_nilOi_w_lg_nlO1lO801w(0) AND n11lOl;
	wire_nilOi_w_lg_w_lg_nlO1lO801w802w(0) <= wire_nilOi_w_lg_nlO1lO801w(0) AND n1iO0i;
	wire_nilOi_w_lg_w_lg_nlO1Oi2387w2408w(0) <= wire_nilOi_w_lg_nlO1Oi2387w(0) AND nlO1Ol;
	wire_nilOi_w_lg_w_lg_nlO1OO2261w2331w(0) <= wire_nilOi_w_lg_nlO1OO2261w(0) AND wire_nilOi_w_lg_nlO01i832w(0);
	wire_nilOi_w_lg_w_lg_nlO1OO2261w2266w(0) <= wire_nilOi_w_lg_nlO1OO2261w(0) AND n11OOi;
	wire_nilOi_w_lg_w_lg_nlO1OO2261w2262w(0) <= wire_nilOi_w_lg_nlO1OO2261w(0) AND n1ilOl;
	wire_nilOi_w_lg_w_lg_nlO1OO2261w2315w(0) <= wire_nilOi_w_lg_nlO1OO2261w(0) AND nlO01i;
	wire_nilOi_w_lg_w_lg_nlOOiO830w2276w(0) <= wire_nilOi_w_lg_nlOOiO830w(0) AND n11OOi;
	wire_nilOi_w_lg_n01Oii2650w(0) <= n01Oii AND wire_w_lg_n11lil2649w(0);
	wire_nilOi_w_lg_n1O0Oi824w(0) <= n1O0Oi AND wire_w_lg_SYNC_SM_DIS823w(0);
	wire_nilOi_w_lg_nil0i2236w(0) <= nil0i AND wire_w_lg_n10Oil2235w(0);
	wire_nilOi_w_lg_niliO1606w(0) <= niliO AND nilil;
	wire_nilOi_w_lg_niliO1599w(0) <= niliO AND nilli;
	wire_nilOi_w_lg_nilli1593w(0) <= nilli AND nilll;
	wire_nilOi_w_lg_nilll1596w(0) <= nilll AND nillO;
	wire_nilOi_w_lg_nlll1i804w(0) <= nlll1i AND wire_w_lg_n1iO0l803w(0);
	wire_nilOi_w_lg_nlO01i2300w(0) <= nlO01i AND wire_w_lg_n1iliO2299w(0);
	wire_nilOi_w_lg_nlO01i812w(0) <= nlO01i AND wire_nilOi_w_lg_nlO1OO811w(0);
	wire_nilOi_w_lg_nlO01i837w(0) <= nlO01i AND n1il0O;
	wire_nilOi_w_lg_nlO01i2294w(0) <= nlO01i AND n1ilil;
	wire_nilOi_w_lg_nlO01l2332w(0) <= nlO01l AND wire_nilOi_w_lg_w_lg_nlO1OO2261w2331w(0);
	wire_nilOi_w_lg_nlO01l2358w(0) <= nlO01l AND wire_nilOi_w_lg_w_lg_nlO1OO2261w2315w(0);
	wire_nilOi_w_lg_nlO01l2301w(0) <= nlO01l AND wire_nilOi_w_lg_nlO01i2300w(0);
	wire_nilOi_w_lg_nlO01l838w(0) <= nlO01l AND wire_nilOi_w_lg_nlO01i837w(0);
	wire_nilOi_w_lg_nlO01l2355w(0) <= nlO01l AND wire_nilOi_w_lg_nlO1OO2314w(0);
	wire_nilOi_w_lg_nlO1iO2416w(0) <= nlO1iO AND wire_nilOi_w_lg_nlO1li2380w(0);
	wire_nilOi_w_lg_nlO1ll2382w(0) <= nlO1ll AND wire_nilOi_w_lg_w_lg_nlO1iO2379w2381w(0);
	wire_nilOi_w_lg_nlO1ll2450w(0) <= nlO1ll AND wire_nilOi_w_lg_w_lg_nlO1iO2379w2417w(0);
	wire_nilOi_w_lg_nlO1ll2447w(0) <= nlO1ll AND wire_nilOi_w_lg_nlO1iO2416w(0);
	wire_nilOi_w_lg_nlO1lO2445w(0) <= nlO1lO AND wire_nilOi_w_lg_w_lg_nlO1ll2388w2444w(0);
	wire_nilOi_w_lg_nlO1lO2440w(0) <= nlO1lO AND wire_nilOi_w_lg_w_lg_nlO1ll2388w2439w(0);
	wire_nilOi_w_lg_nlO1lO2428w(0) <= nlO1lO AND wire_nilOi_w_lg_w_lg_nlO1ll2388w2427w(0);
	wire_nilOi_w_lg_nlO1lO2425w(0) <= nlO1lO AND wire_nilOi_w_lg_w_lg_nlO1ll2388w2424w(0);
	wire_nilOi_w_lg_nlO1lO2383w(0) <= nlO1lO AND wire_nilOi_w_lg_nlO1ll2382w(0);
	wire_nilOi_w_lg_nlO1lO2451w(0) <= nlO1lO AND wire_nilOi_w_lg_nlO1ll2450w(0);
	wire_nilOi_w_lg_nlO1lO2448w(0) <= nlO1lO AND wire_nilOi_w_lg_nlO1ll2447w(0);
	wire_nilOi_w_lg_nlO1Oi2407w(0) <= nlO1Oi AND wire_nilOi_w_lg_nlO1Ol2386w(0);
	wire_nilOi_w_lg_nlO1OO2314w(0) <= nlO1OO AND wire_nilOi_w_lg_nlO01i832w(0);
	wire_nilOi_w_lg_nlO1OO811w(0) <= nlO1OO AND n1ilOl;
	wire_nilOi_w_lg_nlOOiO2353w(0) <= nlOOiO AND wire_nilOi_w_lg_w_lg_nlO01l831w2352w(0);
	wire_nilOi_w_lg_nlOOiO2348w(0) <= nlOOiO AND wire_nilOi_w_lg_w_lg_nlO01l831w2347w(0);
	wire_nilOi_w_lg_nlOOiO2329w(0) <= nlOOiO AND wire_nilOi_w_lg_w_lg_nlO01l831w2328w(0);
	wire_nilOi_w_lg_nlOOiO2326w(0) <= nlOOiO AND wire_nilOi_w_lg_w_lg_nlO01l831w2325w(0);
	wire_nilOi_w_lg_nlOOiO2333w(0) <= nlOOiO AND wire_nilOi_w_lg_nlO01l2332w(0);
	wire_nilOi_w_lg_nlOOiO2359w(0) <= nlOOiO AND wire_nilOi_w_lg_nlO01l2358w(0);
	wire_nilOi_w_lg_nlOOiO839w(0) <= nlOOiO AND wire_nilOi_w_lg_nlO01l838w(0);
	wire_nilOi_w_lg_nlOOiO2356w(0) <= nlOOiO AND wire_nilOi_w_lg_nlO01l2355w(0);
	wire_nilOi_w_lg_w_lg_w_lg_w_lg_niliO1523w1524w1525w1526w(0) <= NOT wire_nilOi_w_lg_w_lg_w_lg_niliO1523w1524w1525w(0);
	wire_nilOi_w_lg_w_lg_w_lg_niliO1514w1515w1516w(0) <= NOT wire_nilOi_w_lg_w_lg_niliO1514w1515w(0);
	wire_nilOi_w_lg_w_lg_nilli1506w1507w(0) <= NOT wire_nilOi_w_lg_nilli1506w(0);
	wire_nilOi_w_lg_n01Oii2616w(0) <= NOT n01Oii;
	wire_nilOi_w_lg_n1O0Ol2618w(0) <= NOT n1O0Ol;
	wire_nilOi_w_lg_ni0Oii1865w(0) <= NOT ni0Oii;
	wire_nilOi_w_lg_nii0il1996w(0) <= NOT nii0il;
	wire_nilOi_w_lg_nii0iO2002w(0) <= NOT nii0iO;
	wire_nilOi_w_lg_niilil1997w(0) <= NOT niilil;
	wire_nilOi_w_lg_nil0i1917w(0) <= NOT nil0i;
	wire_nilOi_w_lg_nil0l1910w(0) <= NOT nil0l;
	wire_nilOi_w_lg_nil0O1905w(0) <= NOT nil0O;
	wire_nilOi_w_lg_nilii1903w(0) <= NOT nilii;
	wire_nilOi_w_lg_nilil1901w(0) <= NOT nilil;
	wire_nilOi_w_lg_niliO1899w(0) <= NOT niliO;
	wire_nilOi_w_lg_nilli1908w(0) <= NOT nilli;
	wire_nilOi_w_lg_nilll1925w(0) <= NOT nilll;
	wire_nilOi_w_lg_nillO1927w(0) <= NOT nillO;
	wire_nilOi_w_lg_nilOl2210w(0) <= NOT nilOl;
	wire_nilOi_w_lg_nlliOO2589w(0) <= NOT nlliOO;
	wire_nilOi_w_lg_nlll0i2615w(0) <= NOT nlll0i;
	wire_nilOi_w_lg_nlll1i791w(0) <= NOT nlll1i;
	wire_nilOi_w_lg_nlO01i832w(0) <= NOT nlO01i;
	wire_nilOi_w_lg_nlO01l831w(0) <= NOT nlO01l;
	wire_nilOi_w_lg_nlO1iO2379w(0) <= NOT nlO1iO;
	wire_nilOi_w_lg_nlO1li2380w(0) <= NOT nlO1li;
	wire_nilOi_w_lg_nlO1ll2388w(0) <= NOT nlO1ll;
	wire_nilOi_w_lg_nlO1lO801w(0) <= NOT nlO1lO;
	wire_nilOi_w_lg_nlO1Oi2387w(0) <= NOT nlO1Oi;
	wire_nilOi_w_lg_nlO1Ol2386w(0) <= NOT nlO1Ol;
	wire_nilOi_w_lg_nlO1OO2261w(0) <= NOT nlO1OO;
	wire_nilOi_w_lg_nlOOiO830w(0) <= NOT nlOOiO;
	wire_nilOi_w_lg_w_lg_w_lg_niliO1523w1524w1525w(0) <= wire_nilOi_w_lg_w_lg_niliO1523w1524w(0) OR nilll;
	wire_nilOi_w_lg_w_lg_niliO1523w1524w(0) <= wire_nilOi_w_lg_niliO1523w(0) OR nilli;
	wire_nilOi_w_lg_w_lg_niliO1514w1515w(0) <= wire_nilOi_w_lg_niliO1514w(0) OR nilll;
	wire_nilOi_w_lg_niliO1523w(0) <= niliO OR nilil;
	wire_nilOi_w_lg_niliO1514w(0) <= niliO OR nilli;
	wire_nilOi_w_lg_nilli1506w(0) <= nilli OR nilll;
	PROCESS (rcvd_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				nilOO <= '0';
				niO1i <= '0';
				niO1l <= '0';
				nl1Oi <= '0';
				nlliOl <= '0';
		ELSIF (rcvd_clk = '0' AND rcvd_clk'event) THEN
			IF (PMADATAWIDTH = '0') THEN
				nilOO <= niOli;
				niO1i <= niOll;
				niO1l <= niOlO;
				nl1Oi <= wire_nliil_dataout;
				nlliOl <= wire_nliiO_dataout;
			END IF;
		END IF;
	END PROCESS;
	PROCESS (rcvd_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n1O0ll <= '1';
				nlill <= '1';
				nllili <= '1';
				nllill <= '1';
				nllilO <= '1';
				nlliOi <= '1';
		ELSIF (rcvd_clk = '0' AND rcvd_clk'event) THEN
				n1O0ll <= n1O0iO;
				nlill <= wire_nll1i_o;
				nllili <= wire_w_lg_n1O10l48w(0);
				nllill <= n1O10O;
				nllilO <= n1O1ii;
				nlliOi <= n1O1il;
		END IF;
	END PROCESS;
	wire_nlili_w_lg_w_lg_w_lg_nlliOi309w310w311w(0) <= wire_nlili_w_lg_w_lg_nlliOi309w310w(0) AND nllili;
	wire_nlili_w_lg_w_lg_nlliOi309w310w(0) <= wire_nlili_w_lg_nlliOi309w(0) AND nllill;
	wire_nlili_w_lg_nlliOi309w(0) <= nlliOi AND nllilO;
	PROCESS (rcvd_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n1O0iO <= '1';
				n1O0li <= '1';
				ni1iOl <= '1';
				nlliiO <= '1';
		ELSIF (rcvd_clk = '1' AND rcvd_clk'event) THEN
				n1O0iO <= wire_n1OiiO_o;
				n1O0li <= wire_n1Oill_o;
				ni1iOl <= wire_nilOi_w_lg_ni0Oii1865w(0);
				nlliiO <= (wire_w_lg_n1illO826w(0) OR n1ilOi);
		END IF;
	END PROCESS;
	wire_nlliil_w_lg_nlliiO2590w(0) <= NOT nlliiO;
	PROCESS (rcvd_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n00O0i <= '0';
				n00O0l <= '0';
				n00O0O <= '0';
				n00O1l <= '0';
				n00O1O <= '0';
				n00Oii <= '0';
				n00Oil <= '0';
				n00OiO <= '0';
				n00Oli <= '0';
				n00Oll <= '0';
				n00OlO <= '0';
				n00OOi <= '0';
				n00OOl <= '0';
				n00OOO <= '0';
				n01Oil <= '0';
				n01OiO <= '0';
				n01Oli <= '0';
				n0i00i <= '0';
				n0i00l <= '0';
				n0i00O <= '0';
				n0i0ii <= '0';
				n0i0il <= '0';
				n0i0iO <= '0';
				n0i0li <= '0';
				n0i0ll <= '0';
				n0i11i <= '0';
				n0i11l <= '0';
				n10li <= '0';
				n10ll <= '0';
				n10lO <= '0';
				n10Oi <= '0';
				n10OO <= '0';
				n111i <= '0';
				n111l <= '0';
				n111O <= '0';
				n1l0i <= '0';
				n1l0l <= '0';
				n1l0O <= '0';
				n1l1O <= '0';
				n1lii <= '0';
				n1lil <= '0';
				n1liO <= '0';
				n1lli <= '0';
				n1lOi <= '0';
				n1O0lO <= '0';
				niO0i <= '0';
				niO0l <= '0';
				niO0O <= '0';
				niO1O <= '0';
				niOii <= '0';
				niOil <= '0';
				niOiO <= '0';
				niOli <= '0';
				niOll <= '0';
				niOlO <= '0';
				niOOi <= '0';
				niOOl <= '0';
				niOOO <= '0';
				nl10i <= '0';
				nl10l <= '0';
				nl10O <= '0';
				nl11i <= '0';
				nl11l <= '0';
				nl11O <= '0';
				nl1ii <= '0';
				nl1il <= '0';
				nl1iO <= '0';
				nl1li <= '0';
				nl1ll <= '0';
				nlilO <= '0';
				nlllO <= '0';
				nlOOli <= '0';
				nlOOll <= '0';
				nlOOlO <= '0';
				nlOOOi <= '0';
				nlOOOl <= '0';
				nlOOOO <= '0';
		ELSIF (rcvd_clk = '0' AND rcvd_clk'event) THEN
				n00O0i <= wire_n00lOi_o;
				n00O0l <= n1li1O;
				n00O0O <= wire_n00l0O_o;
				n00O1l <= n1li1i;
				n00O1O <= n1li1i;
				n00Oii <= n1li0l;
				n00Oil <= wire_n00iOl_o;
				n00OiO <= n1liii;
				n00Oli <= wire_n00iii_o;
				n00Oll <= n1lill;
				n00OlO <= wire_n000OO_o;
				n00OOi <= n1ll1l;
				n00OOl <= wire_n000il_o;
				n00OOO <= n1llli;
				n01Oil <= n01OiO;
				n01OiO <= prbs_en;
				n01Oli <= n1O0lO;
				n0i00i <= wire_n001iO_o;
				n0i00l <= n1lO0l;
				n0i00O <= n1llli;
				n0i0ii <= n1ll1l;
				n0i0il <= n1lill;
				n0i0iO <= n1liii;
				n0i0li <= n1li0l;
				n0i0ll <= n1li1O;
				n0i11i <= wire_n0001i_o;
				n0i11l <= n1lO0l;
				n10li <= wire_n100O_o;
				n10ll <= (n10Oi AND wire_nllll_w_lg_n10lO349w(0));
				n10lO <= n10Oi;
				n10Oi <= n10OO;
				n10OO <= BITSLIP;
				n111i <= wire_n11li_o;
				n111l <= wire_n11ll_o;
				n111O <= wire_n100l_o;
				n1l0i <= n1l0l;
				n1l0l <= n1l0O;
				n1l0O <= A1A2_SIZE;
				n1l1O <= (NOT (wire_nlili_w_lg_w_lg_w_lg_nlliOi309w310w311w(0) OR ((((NOT (nllili XOR n1lii)) AND (NOT (nllill XOR n1lil))) AND (NOT (nllilO XOR n1liO))) AND (NOT (nlliOi XOR n1lli)))));
				n1lii <= n1lOl;
				n1lil <= n1lOO;
				n1liO <= n1O1i;
				n1lli <= nil1O;
				n1lOi <= n1lOiO;
				n1O0lO <= ENCDT;
				niO0i <= wire_nl1OO_dataout;
				niO0l <= wire_nl01i_dataout;
				niO0O <= wire_nl01l_dataout;
				niO1O <= wire_nl1Ol_dataout;
				niOii <= wire_nl01O_dataout;
				niOil <= wire_nl00i_dataout;
				niOiO <= wire_nl00l_dataout;
				niOli <= wire_nl00O_dataout;
				niOll <= wire_nl0ii_dataout;
				niOlO <= wire_nl0il_dataout;
				niOOi <= wire_nl0iO_dataout;
				niOOl <= wire_nl0li_dataout;
				niOOO <= wire_nl0ll_dataout;
				nl10i <= wire_nl0OO_dataout;
				nl10l <= wire_nli1i_dataout;
				nl10O <= wire_nli1l_dataout;
				nl11i <= wire_nl0lO_dataout;
				nl11l <= wire_nl0Oi_dataout;
				nl11O <= wire_nl0Ol_dataout;
				nl1ii <= wire_nli1O_dataout;
				nl1il <= wire_nli0i_dataout;
				nl1iO <= wire_nli0l_dataout;
				nl1li <= wire_nli0O_dataout;
				nl1ll <= wire_nliii_dataout;
				nlilO <= wire_nliOO_o;
				nlllO <= wire_nliOl_o;
				nlOOli <= wire_n110i_o;
				nlOOll <= wire_n110l_o;
				nlOOlO <= wire_n110O_o;
				nlOOOi <= wire_n11ii_o;
				nlOOOl <= wire_n11il_o;
				nlOOOO <= wire_n11iO_o;
		END IF;
	END PROCESS;
	wire_nllll_w_lg_w_lg_w_lg_n1l0l154w159w162w(0) <= wire_nllll_w_lg_w_lg_n1l0l154w159w(0) AND n1lO1i35;
	wire_nllll_w_lg_w_lg_n0i00i164w167w(0) <= wire_nllll_w_lg_n0i00i164w(0) AND n1llOl38;
	wire_nllll_w_lg_w_lg_n0i11i182w185w(0) <= wire_nllll_w_lg_n0i11i182w(0) AND n1ll0O47;
	wire_nllll_w_lg_w_lg_n1l0l203w206w(0) <= wire_nllll_w_lg_n1l0l203w(0) AND n1liOi56;
	wire_nllll_w_lg_w_lg_n1l0l169w172w(0) <= wire_nllll_w_lg_n1l0l169w(0) AND n1lllO41;
	wire_nllll_w_lg_w_lg_n1l0l154w159w(0) <= wire_nllll_w_lg_n1l0l154w(0) AND wire_w_lg_w_lg_n1lO0O155w158w(0);
	wire_nllll_w_lg_n00O0i248w(0) <= n00O0i AND wire_nllll_w_lg_n00O1O247w(0);
	wire_nllll_w_lg_n00O0O240w(0) <= n00O0O AND wire_nllll_w_lg_n00O0l239w(0);
	wire_nllll_w_lg_n00Oil232w(0) <= n00Oil AND wire_nllll_w_lg_n00Oii231w(0);
	wire_nllll_w_lg_n00Oli224w(0) <= n00Oli AND wire_nllll_w_lg_n00OiO223w(0);
	wire_nllll_w_lg_n00OlO216w(0) <= n00OlO AND wire_nllll_w_lg_n00Oll215w(0);
	wire_nllll_w_lg_n00OOl201w(0) <= n00OOl AND wire_nllll_w_lg_n00OOi200w(0);
	wire_nllll_w_lg_n0i00i164w(0) <= n0i00i AND wire_nllll_w_lg_n0i11l163w(0);
	wire_nllll_w_lg_n0i11i182w(0) <= n0i11i AND wire_nllll_w_lg_n00OOO181w(0);
	wire_nllll_w_lg_n1l0l242w(0) <= n1l0l AND wire_w_lg_n1li0i241w(0);
	wire_nllll_w_lg_n1l0l234w(0) <= n1l0l AND wire_w_lg_n1li0O233w(0);
	wire_nllll_w_lg_n1l0l250w(0) <= n1l0l AND wire_w_lg_n1li1l249w(0);
	wire_nllll_w_lg_n1l0l226w(0) <= n1l0l AND wire_w_lg_n1liil225w(0);
	wire_nllll_w_lg_n1l0l218w(0) <= n1l0l AND wire_w_lg_n1lilO217w(0);
	wire_nllll_w_lg_n1l0l203w(0) <= n1l0l AND wire_w_lg_n1ll1O202w(0);
	wire_nllll_w_lg_n1l0l187w(0) <= n1l0l AND wire_w_lg_n1llll186w(0);
	wire_nllll_w_lg_n1l0l169w(0) <= n1l0l AND wire_w_lg_n1lO0O168w(0);
	wire_nllll_w_lg_n00O0l239w(0) <= NOT n00O0l;
	wire_nllll_w_lg_n00O1O247w(0) <= NOT n00O1O;
	wire_nllll_w_lg_n00Oii231w(0) <= NOT n00Oii;
	wire_nllll_w_lg_n00OiO223w(0) <= NOT n00OiO;
	wire_nllll_w_lg_n00Oll215w(0) <= NOT n00Oll;
	wire_nllll_w_lg_n00OOi200w(0) <= NOT n00OOi;
	wire_nllll_w_lg_n00OOO181w(0) <= NOT n00OOO;
	wire_nllll_w_lg_n01Oli65w(0) <= NOT n01Oli;
	wire_nllll_w_lg_n0i11l163w(0) <= NOT n0i11l;
	wire_nllll_w_lg_n10lO349w(0) <= NOT n10lO;
	wire_nllll_w_lg_n1l0l154w(0) <= NOT n1l0l;
	wire_n0000i_dataout <= n1llll OR n1llli;
	wire_n000i_dataout <= ((wire_nllll_w_lg_n1l0l154w(0) AND (n1liil AND n0i0iO)) OR wire_nllll_w_lg_n1l0l226w(0)) WHEN PMADATAWIDTH = '1'  ELSE (n1liil OR n1liii);
	wire_n000i_w_lg_dataout266w(0) <= NOT wire_n000i_dataout;
	wire_n000ll_dataout <= n1ll1O OR n1ll1l;
	wire_n001i_dataout <= ((wire_nllll_w_lg_n1l0l154w(0) AND (n1li0O AND n0i0li)) OR wire_nllll_w_lg_n1l0l234w(0)) WHEN PMADATAWIDTH = '1'  ELSE (n1li0O OR n1li0l);
	wire_n001i_w_lg_dataout263w(0) <= NOT wire_n001i_dataout;
	wire_n001lO_dataout <= n1lO0O OR n1lO0l;
	wire_n00i1O_dataout <= n1lilO OR n1lill;
	wire_n00ii_dataout <= ((wire_nllll_w_lg_n1l0l154w(0) AND (n1lilO AND n0i0il)) OR wire_nllll_w_lg_n1l0l218w(0)) WHEN PMADATAWIDTH = '1'  ELSE ((n1lilO OR n1lill) OR wire_n1liiO59_w_lg_Q211w(0));
	wire_n00ii_w_lg_dataout269w(0) <= NOT wire_n00ii_dataout;
	wire_n00ili_dataout <= n1liil OR n1liii;
	wire_n00l1l_dataout <= n1li0O OR n1li0l;
	wire_n00li_dataout <= ((wire_nllll_w_lg_n1l0l154w(0) AND (n1ll1O AND n0i0ii)) OR wire_nllll_w_lg_w_lg_n1l0l203w206w(0)) WHEN PMADATAWIDTH = '1'  ELSE ((n1ll1O OR n1ll1l) OR wire_n1liOO53_w_lg_Q196w(0));
	wire_n00li_w_lg_dataout272w(0) <= NOT wire_n00li_dataout;
	wire_n00liO_dataout <= n1li0i OR n1li1O;
	wire_n00O1i_dataout <= n1li1l OR n1li1i;
	wire_n00Oi_dataout <= (((wire_nllll_w_lg_n1l0l154w(0) AND (n1llll AND n0i00O)) OR wire_nllll_w_lg_n1l0l187w(0)) OR wire_n1ll0i50_w_lg_Q191w(0)) WHEN PMADATAWIDTH = '1'  ELSE ((n1llll OR n1llli) OR wire_n1llil44_w_lg_Q177w(0));
	wire_n00Oi_w_lg_dataout275w(0) <= NOT wire_n00Oi_dataout;
	wire_n0100i_dataout <= n1O0Oi AND NOT(wire_nilOi_w_lg_n01Oii2616w(0));
	wire_n0100l_dataout <= n1O0Oi WHEN n11iOl = '1'  ELSE wire_n010iO_dataout;
	wire_n0100O_dataout <= n1O0iO OR n11iOl;
	wire_n0101i_dataout <= wire_n0101l_o(1) AND NOT(n11ilO);
	wire_n0101O_dataout <= n1O0iO OR wire_nilOi_w_lg_n01Oii2616w(0);
	wire_n010i_dataout <= n1i1O WHEN AUTOBYTEALIGN_DIS = '1'  ELSE n1O1i;
	wire_n010ii_dataout <= wire_w_lg_n11iOi2634w(0) AND NOT(n11iOl);
	wire_n010il_dataout <= n11iOi AND NOT(n11iOl);
	wire_n010iO_dataout <= n1O0Oi OR n11iOi;
	wire_n010l_dataout <= n1l1i WHEN AUTOBYTEALIGN_DIS = '1'  ELSE nil1O;
	wire_n010O_dataout <= (n1l0Oi OR n1l0lO) AND NOT(PMADATAWIDTH);
	wire_n010O_w_lg_dataout1428w(0) <= NOT wire_n010O_dataout;
	wire_n010O_w_lg_w_lg_w268w271w274w(0) <= wire_n010O_w_lg_w268w271w(0) OR wire_n00li_dataout;
	wire_n010O_w_lg_w268w271w(0) <= wire_n010O_w268w(0) OR wire_n00ii_dataout;
	wire_n010O_w268w(0) <= wire_n010O_w_lg_w_lg_w_lg_w_lg_dataout256w259w262w265w(0) OR wire_n000i_dataout;
	wire_n010O_w_lg_w_lg_w_lg_w_lg_dataout256w259w262w265w(0) <= wire_n010O_w_lg_w_lg_w_lg_dataout256w259w262w(0) OR wire_n001i_dataout;
	wire_n010O_w_lg_w_lg_w_lg_dataout256w259w262w(0) <= wire_n010O_w_lg_w_lg_dataout256w259w(0) OR wire_n01Oi_dataout;
	wire_n010O_w_lg_w_lg_dataout256w259w(0) <= wire_n010O_w_lg_dataout256w(0) OR wire_n01li_dataout;
	wire_n010O_w_lg_dataout278w(0) <= wire_n010O_dataout OR wire_w_lg_n1l0ll277w(0);
	wire_n010O_w_lg_dataout256w(0) <= wire_n010O_dataout OR wire_n01il_dataout;
	wire_n0110i_dataout <= n11ilO AND NOT(wire_nilOi_w_lg_n01Oii2616w(0));
	wire_n0110l_dataout <= wire_w_lg_n11ilO2646w(0) AND NOT(wire_nilOi_w_lg_n01Oii2616w(0));
	wire_n0111i_dataout <= wire_n0111O_dataout AND NOT(wire_nilOi_w_lg_n01Oii2616w(0));
	wire_n0111l_dataout <= n11ill AND NOT(n11ilO);
	wire_n0111O_dataout <= wire_w_lg_n11ill2647w(0) AND NOT(n11ilO);
	wire_n011ii_dataout <= wire_n011iO_dataout AND NOT(wire_nilOi_w_lg_n01Oii2616w(0));
	wire_n011il_dataout <= wire_n011li_dataout AND NOT(wire_nilOi_w_lg_n01Oii2616w(0));
	wire_n011iO_dataout <= wire_n011ll_dataout AND NOT(n11ilO);
	wire_n011l_dataout <= n1i1i WHEN AUTOBYTEALIGN_DIS = '1'  ELSE n1lOl;
	wire_n011li_dataout <= wire_n011lO_dataout AND NOT(n11ilO);
	wire_n011ll_dataout <= wire_n0101l_o(0) AND NOT(n11ill);
	wire_n011lO_dataout <= wire_n0101l_o(1) AND NOT(n11ill);
	wire_n011O_dataout <= n1i1l WHEN AUTOBYTEALIGN_DIS = '1'  ELSE n1lOO;
	wire_n011Oi_dataout <= wire_n011OO_dataout AND NOT(wire_nilOi_w_lg_n01Oii2616w(0));
	wire_n011Ol_dataout <= wire_n0101i_dataout AND NOT(wire_nilOi_w_lg_n01Oii2616w(0));
	wire_n011OO_dataout <= wire_n0101l_o(0) AND NOT(n11ilO);
	wire_n01i0i_dataout <= n11l0i AND NOT(n11l1O);
	wire_n01i1O_dataout <= wire_w_lg_n11l0i2624w(0) AND NOT(n11l1O);
	wire_n01iii_dataout <= wire_n01ili_dataout AND NOT(n11l0l);
	wire_n01iil_dataout <= n11l0O AND NOT(n11l0l);
	wire_n01iiO_dataout <= wire_n01ill_dataout AND NOT(n11l0l);
	wire_n01il_dataout <= (n1l0OO OR n1l0Ol) AND NOT(PMADATAWIDTH);
	wire_n01il_w_lg_dataout254w(0) <= NOT wire_n01il_dataout;
	wire_n01ili_dataout <= wire_w_lg_n11iOO2621w(0) AND NOT(n11l0O);
	wire_n01ill_dataout <= n11iOO AND NOT(n11l0O);
	wire_n01iOl_dataout <= wire_nilOi_w_lg_n1O0Ol2618w(0) WHEN n11l1O = '1'  ELSE wire_n01l1i_dataout;
	wire_n01iOO_dataout <= n1O0iO OR n11l1O;
	wire_n01l0i_dataout <= wire_nilOi_w_lg_n1O0Ol2618w(0) WHEN n11l0O = '1'  ELSE n1O0Ol;
	wire_n01l0l_dataout <= n1O0iO AND n11lii;
	wire_n01l0O_dataout <= wire_nilOi_w_lg_n1O0Ol2618w(0) OR NOT(n11lii);
	wire_n01l1i_dataout <= wire_nilOi_w_lg_n1O0Ol2618w(0) OR n11l0i;
	wire_n01l1l_dataout <= wire_nilOi_w_lg_n1O0Ol2618w(0) WHEN n11l0l = '1'  ELSE wire_n01l0i_dataout;
	wire_n01l1O_dataout <= n1O0iO OR n11l0l;
	wire_n01li_dataout <= ((wire_nllll_w_lg_n1l0l154w(0) AND (n1li1l AND n00O1l)) OR wire_nllll_w_lg_n1l0l250w(0)) WHEN PMADATAWIDTH = '1'  ELSE (n1li1l OR n1li1i);
	wire_n01li_w_lg_dataout257w(0) <= NOT wire_n01li_dataout;
	wire_n01Oi_dataout <= ((wire_nllll_w_lg_n1l0l154w(0) AND (n1li0i AND n0i0ll)) OR wire_nllll_w_lg_n1l0l242w(0)) WHEN PMADATAWIDTH = '1'  ELSE (n1li0i OR n1li1O);
	wire_n01Oi_w_lg_dataout260w(0) <= NOT wire_n01Oi_dataout;
	wire_n0i0i_dataout <= niOli WHEN n1lOii = '1'  ELSE wire_n0iOl_dataout;
	wire_n0i0l_dataout <= niOll WHEN n1lOii = '1'  ELSE wire_n0iOO_dataout;
	wire_n0i0O_dataout <= niOlO WHEN n1lOii = '1'  ELSE wire_n0l1i_dataout;
	wire_n0i1i_dataout <= (wire_nllll_w_lg_w_lg_w_lg_n1l0l154w159w162w(0) OR wire_nllll_w_lg_w_lg_n1l0l169w172w(0)) WHEN PMADATAWIDTH = '1'  ELSE (n1lO0O OR n1lO0l);
	wire_n0iii_dataout <= niOOi WHEN n1lOii = '1'  ELSE wire_n0l1l_dataout;
	wire_n0iil_dataout <= niOOl WHEN n1lOii = '1'  ELSE wire_n0l1O_dataout;
	wire_n0iiO_dataout <= niOOO WHEN n1lOii = '1'  ELSE wire_n0l0i_dataout;
	wire_n0ili_dataout <= nl11i WHEN n1lOii = '1'  ELSE wire_n0l0l_dataout;
	wire_n0ill_dataout <= wire_n0l0O_dataout AND NOT(n1lOii);
	wire_n0ilO_dataout <= wire_n0lii_dataout AND NOT(n1lOii);
	wire_n0iOi_dataout <= wire_n0lil_dataout AND NOT(n1lOii);
	wire_n0iOl_dataout <= niOli AND NOT(n1lOil);
	wire_n0iOO_dataout <= niOll AND NOT(n1lOil);
	wire_n0l0i_dataout <= niOOO AND NOT(n1lOil);
	wire_n0l0l_dataout <= nl11i AND NOT(n1lOil);
	wire_n0l0O_dataout <= nl11l AND NOT(n1lOil);
	wire_n0l1i_dataout <= niOlO AND NOT(n1lOil);
	wire_n0l1l_dataout <= niOOi AND NOT(n1lOil);
	wire_n0l1lO_dataout <= nlll1i WHEN ((wire_nilOi_w_lg_w_lg_nlO1lO801w2402w(0) OR (nlO1lO AND n1iO0i)) OR (n1iOiO AND n1iO0O)) = '1'  ELSE (n1iOOl OR n1iO0l);
	wire_n0l1lO_w_lg_dataout814w(0) <= wire_n0l1lO_dataout AND wire_w_lg_n1ilOO813w(0);
	wire_n0l1lO_w_lg_dataout806w(0) <= NOT wire_n0l1lO_dataout;
	wire_n0l1O_dataout <= niOOl AND NOT(n1lOil);
	wire_n0lii_dataout <= nl11O AND NOT(n1lOil);
	wire_n0lil_dataout <= nl10i AND NOT(n1lOil);
	wire_n0liO_dataout <= niOll WHEN n1lOii = '1'  ELSE wire_n0iOO_dataout;
	wire_n0lli_dataout <= niOlO WHEN n1lOii = '1'  ELSE wire_n0l1i_dataout;
	wire_n0lll_dataout <= niOOi WHEN n1lOii = '1'  ELSE wire_n0l1l_dataout;
	wire_n0llO_dataout <= niOOl WHEN n1lOii = '1'  ELSE wire_n0l1O_dataout;
	wire_n0lOi_dataout <= niOOO WHEN n1lOii = '1'  ELSE wire_n0l0i_dataout;
	wire_n0lOl_dataout <= nl11i WHEN n1lOii = '1'  ELSE wire_n0l0l_dataout;
	wire_n0lOO_dataout <= nl11l WHEN n1lOii = '1'  ELSE wire_n0l0O_dataout;
	wire_n0O0i_dataout <= nl10l AND NOT(n1lOil);
	wire_n0O0l_dataout <= nl10i AND NOT(n1lOii);
	wire_n0O0O_dataout <= wire_n0O0i_dataout AND NOT(n1lOii);
	wire_n0O1i_dataout <= wire_n0lii_dataout AND NOT(n1lOii);
	wire_n0O1l_dataout <= wire_n0lil_dataout AND NOT(n1lOii);
	wire_n0O1O_dataout <= wire_n0O0i_dataout AND NOT(n1lOii);
	wire_n0Oii_dataout <= wire_n0Oil_dataout AND NOT(n1lOii);
	wire_n0Oil_dataout <= nl10O AND NOT(n1lOil);
	wire_n0OiO_dataout <= nl10l AND NOT(n1lOii);
	wire_n0Oli_dataout <= wire_n0Oil_dataout AND NOT(n1lOii);
	wire_n0Oll_dataout <= wire_n0OlO_dataout AND NOT(n1lOii);
	wire_n0OlO_dataout <= nl1ii AND NOT(n1lOil);
	wire_n0OO1l_dataout <= wire_n0l1lO_dataout WHEN (n1ilOl AND (nlO1OO XOR nlO01i)) = '1'  ELSE (n1iO1i OR n1ilOO);
	wire_n0OOi_dataout <= nl10O AND NOT(n1lOii);
	wire_n0OOl_dataout <= wire_n0OlO_dataout AND NOT(n1lOii);
	wire_n0OOO_dataout <= wire_ni11i_dataout AND NOT(n1lOii);
	wire_n1i0i_dataout <= wire_n1iil_dataout OR n1l1OO;
	wire_n1i0l_dataout <= wire_n1iiO_dataout AND NOT(n1l1OO);
	wire_n1i0O_dataout <= wire_n1ili_dataout AND NOT(n1l1OO);
	wire_n1iii_dataout <= wire_n1ill_dataout OR n1l1OO;
	wire_n1iil_dataout <= wire_n1ilO_o(1) OR n1l1Ol;
	wire_n1iiO_dataout <= wire_n1ilO_o(2) OR n1l1Ol;
	wire_n1ili_dataout <= wire_n1ilO_o(3) OR n1l1Ol;
	wire_n1ill_dataout <= wire_n1ilO_o(4) AND NOT(n1l1Ol);
	wire_n1O0OO_dataout <= encdet_prbs WHEN n01Oil = '1'  ELSE wire_n1Oi1i_dataout;
	wire_n1Oi1i_dataout <= wire_n1Oi1l_dataout WHEN SYNC_SM_DIS = '1'  ELSE n1O0ll;
	wire_n1Oi1l_dataout <= wire_nliOi_o WHEN PMADATAWIDTH = '1'  ELSE n01Oli;
	wire_n1OO0l_dataout <= wire_n011ll_dataout AND NOT(n11l1O);
	wire_n1OO0O_dataout <= wire_n011lO_dataout AND NOT(n11l1O);
	wire_n1OOii_dataout <= n11ill AND NOT(n11l1O);
	wire_n1OOil_dataout <= wire_w_lg_n11ill2647w(0) AND NOT(n11l1O);
	wire_n1OOll_dataout <= wire_n0101l_o(0) AND NOT(n11l1O);
	wire_n1OOlO_dataout <= wire_n0101l_o(1) AND NOT(n11l1O);
	wire_n1OOOi_dataout <= n1O0Oi AND NOT(n11l1O);
	wire_n1OOOO_dataout <= wire_n0111l_dataout AND NOT(wire_nilOi_w_lg_n01Oii2616w(0));
	wire_ni000l_dataout <= niiliO AND NOT(n101il);
	wire_ni000O_dataout <= niilli AND NOT(n101il);
	wire_ni001i_dataout <= n1010O AND NOT(n101ii);
	wire_ni001l_dataout <= wire_w_lg_n1010O2005w(0) AND NOT(n101ii);
	wire_ni00i_dataout <= wire_ni01l_dataout AND NOT(n1lOii);
	wire_ni00ii_dataout <= niilll AND NOT(n101il);
	wire_ni00il_dataout <= niillO AND NOT(n101il);
	wire_ni00l_dataout <= wire_ni00O_dataout AND NOT(n1lOii);
	wire_ni00li_dataout <= n101li AND NOT(wire_nilOi_w_lg_ni0Oii1865w(0));
	wire_ni00ll_dataout <= wire_ni00Oi_dataout AND NOT(wire_nilOi_w_lg_ni0Oii1865w(0));
	wire_ni00lO_dataout <= wire_ni00Ol_dataout AND NOT(wire_nilOi_w_lg_ni0Oii1865w(0));
	wire_ni00O_dataout <= nlliOl AND NOT(n1lOil);
	wire_ni00Oi_dataout <= n101iO AND NOT(n101li);
	wire_ni00Ol_dataout <= wire_w_lg_n101iO2000w(0) AND NOT(n101li);
	wire_ni011i_dataout <= wire_ni0i1O_dataout AND ni0i0l;
	wire_ni01i_dataout <= wire_ni01l_dataout AND NOT(n1lOii);
	wire_ni01iO_dataout <= nii0li AND NOT(n101il);
	wire_ni01l_dataout <= nl1Oi AND NOT(n1lOil);
	wire_ni01li_dataout <= nii0ll AND NOT(n101il);
	wire_ni01ll_dataout <= nii0lO AND NOT(n101il);
	wire_ni01lO_dataout <= nii0Oi AND NOT(n101il);
	wire_ni01O_dataout <= nl1ll AND NOT(n1lOii);
	wire_ni01Oi_dataout <= n101ii AND NOT(wire_nilOi_w_lg_ni0Oii1865w(0));
	wire_ni01Ol_dataout <= wire_ni001i_dataout AND NOT(wire_nilOi_w_lg_ni0Oii1865w(0));
	wire_ni01OO_dataout <= wire_ni001l_dataout AND NOT(wire_nilOi_w_lg_ni0Oii1865w(0));
	wire_ni0i1l_dataout <= nii0il AND NOT(wire_nilOi_w_lg_ni0Oii1865w(0));
	wire_ni0i1O_dataout <= wire_nilOi_w_lg_nii0il1996w(0) AND NOT(wire_nilOi_w_lg_ni0Oii1865w(0));
	wire_ni0ii_dataout <= (NOT SYNC_COMP_PAT(0)) WHEN n1lOii = '1'  ELSE wire_nii1l_dataout;
	wire_ni0il_dataout <= (NOT SYNC_COMP_PAT(1)) WHEN n1lOii = '1'  ELSE wire_nii1O_dataout;
	wire_ni0ill_dataout <= RUNDISP_SEL(0) AND NOT(PMADATAWIDTH);
	wire_ni0ill_w_lg_dataout2257w(0) <= NOT wire_ni0ill_dataout;
	wire_ni0ilO_dataout <= RUNDISP_SEL(1) AND NOT(PMADATAWIDTH);
	wire_ni0ilO_w_lg_dataout2255w(0) <= NOT wire_ni0ilO_dataout;
	wire_ni0iO_dataout <= (NOT SYNC_COMP_PAT(2)) WHEN n1lOii = '1'  ELSE wire_nii0i_dataout;
	wire_ni0iOi_dataout <= RUNDISP_SEL(0) WHEN PMADATAWIDTH = '1'  ELSE wire_ni0l0i_o(0);
	wire_ni0iOl_dataout <= RUNDISP_SEL(1) WHEN PMADATAWIDTH = '1'  ELSE wire_ni0l0i_o(1);
	wire_ni0iOl_w_lg_dataout2252w(0) <= NOT wire_ni0iOl_dataout;
	wire_ni0iOO_dataout <= RUNDISP_SEL(2) WHEN PMADATAWIDTH = '1'  ELSE wire_ni0l0i_o(2);
	wire_ni0iOO_w_lg_dataout2250w(0) <= NOT wire_ni0iOO_dataout;
	wire_ni0l1i_dataout <= RUNDISP_SEL(3) WHEN PMADATAWIDTH = '1'  ELSE wire_ni0l0i_o(3);
	wire_ni0l1i_w_lg_dataout2248w(0) <= NOT wire_ni0l1i_dataout;
	wire_ni0l1l_dataout <= RUNDISP_SEL(4) WHEN PMADATAWIDTH = '1'  ELSE wire_ni0l0i_o(4);
	wire_ni0l1l_w_lg_dataout2246w(0) <= NOT wire_ni0l1l_dataout;
	wire_ni0l1O_dataout <= wire_w_lg_n101ll1974w(0) WHEN PMADATAWIDTH = '1'  ELSE wire_ni0l0i_o(5);
	wire_ni0l1O_w_lg_w2253w2254w(0) <= wire_ni0l1O_w2253w(0) AND wire_ni0iOi_dataout;
	wire_ni0l1O_w2253w(0) <= wire_ni0l1O_w_lg_w_lg_w_lg_w_lg_dataout2245w2247w2249w2251w(0) AND wire_ni0iOl_w_lg_dataout2252w(0);
	wire_ni0l1O_w_lg_w_lg_w_lg_w_lg_dataout2245w2247w2249w2251w(0) <= wire_ni0l1O_w_lg_w_lg_w_lg_dataout2245w2247w2249w(0) AND wire_ni0iOO_w_lg_dataout2250w(0);
	wire_ni0l1O_w_lg_w_lg_w_lg_dataout2245w2247w2249w(0) <= wire_ni0l1O_w_lg_w_lg_dataout2245w2247w(0) AND wire_ni0l1i_w_lg_dataout2248w(0);
	wire_ni0l1O_w_lg_w_lg_dataout2245w2247w(0) <= wire_ni0l1O_w_lg_dataout2245w(0) AND wire_ni0l1l_w_lg_dataout2246w(0);
	wire_ni0l1O_w_lg_dataout2245w(0) <= NOT wire_ni0l1O_dataout;
	wire_ni0li_dataout <= (NOT SYNC_COMP_PAT(3)) WHEN n1lOii = '1'  ELSE wire_nii0l_dataout;
	wire_ni0ll_dataout <= (NOT SYNC_COMP_PAT(4)) WHEN n1lOii = '1'  ELSE wire_nii0O_dataout;
	wire_ni0lO_dataout <= (NOT SYNC_COMP_PAT(5)) WHEN n1lOii = '1'  ELSE wire_niiii_dataout;
	wire_ni0lOl_dataout <= ni0llO AND ni0Oii;
	wire_ni0lOO_dataout <= ni0lOi AND ni0Oii;
	wire_ni0O1i_dataout <= n1O0ii AND ni0Oii;
	wire_ni0O1l_dataout <= wire_ni0O1O_o AND ni0Oii;
	wire_ni0Oi_dataout <= (NOT SYNC_COMP_PAT(6)) WHEN n1lOii = '1'  ELSE wire_niiil_dataout;
	wire_ni0Ol_dataout <= wire_niiiO_dataout AND NOT(n1lOii);
	wire_ni0OO_dataout <= wire_niili_dataout AND NOT(n1lOii);
	wire_ni10i_dataout <= wire_ni10l_dataout AND NOT(n1lOii);
	wire_ni10l_dataout <= nl1iO AND NOT(n1lOil);
	wire_ni10O_dataout <= nl1il AND NOT(n1lOii);
	wire_ni11i_dataout <= nl1il AND NOT(n1lOil);
	wire_ni11l_dataout <= nl1ii AND NOT(n1lOii);
	wire_ni11O_dataout <= wire_ni11i_dataout AND NOT(n1lOii);
	wire_ni1ii_dataout <= wire_ni10l_dataout AND NOT(n1lOii);
	wire_ni1il_dataout <= wire_ni1iO_dataout AND NOT(n1lOii);
	wire_ni1iO_dataout <= nl1li AND NOT(n1lOil);
	wire_ni1li_dataout <= nl1iO AND NOT(n1lOii);
	wire_ni1lil_dataout <= wire_ni1llO_o(0) WHEN wire_ni1lOi_o(4) = '1'  ELSE wire_ni1lOl_dataout;
	wire_ni1liO_dataout <= wire_ni1llO_o(1) WHEN wire_ni1lOi_o(4) = '1'  ELSE wire_ni1lOO_dataout;
	wire_ni1ll_dataout <= wire_ni1iO_dataout AND NOT(n1lOii);
	wire_ni1lli_dataout <= wire_ni1llO_o(2) WHEN wire_ni1lOi_o(4) = '1'  ELSE wire_ni1O1i_dataout;
	wire_ni1lll_dataout <= wire_ni1llO_o(3) WHEN wire_ni1lOi_o(4) = '1'  ELSE wire_ni1O1l_dataout;
	wire_ni1lO_dataout <= wire_ni1Oi_dataout AND NOT(n1lOii);
	wire_ni1lOl_dataout <= ni1l0l AND n11OOO;
	wire_ni1lOO_dataout <= ni1l0O AND n11OOO;
	wire_ni1O1i_dataout <= ni1lii AND n11OOO;
	wire_ni1O1l_dataout <= ni0i0i AND n11OOO;
	wire_ni1Oi_dataout <= nl1ll AND NOT(n1lOil);
	wire_ni1Ol_dataout <= nl1li AND NOT(n1lOii);
	wire_ni1OO_dataout <= wire_ni1Oi_dataout AND NOT(n1lOii);
	wire_ni1OOl_dataout <= ni0Oii AND ni1iOl;
	wire_ni1OOO_dataout <= wire_ni0i1l_dataout AND ni0i0l;
	wire_nii00l_dataout <= n101lO WHEN PMADATAWIDTH = '1'  ELSE n101Oi;
	wire_nii00l_w_lg_dataout1871w(0) <= NOT wire_nii00l_dataout;
	wire_nii0i_dataout <= SYNC_COMP_PAT(10) WHEN n1lOil = '1'  ELSE (NOT SYNC_COMP_PAT(2));
	wire_nii0l_dataout <= SYNC_COMP_PAT(11) WHEN n1lOil = '1'  ELSE (NOT SYNC_COMP_PAT(3));
	wire_nii0O_dataout <= SYNC_COMP_PAT(12) WHEN n1lOil = '1'  ELSE (NOT SYNC_COMP_PAT(4));
	wire_nii1i_dataout <= wire_niill_dataout AND NOT(n1lOii);
	wire_nii1l_dataout <= SYNC_COMP_PAT(8) WHEN n1lOil = '1'  ELSE (NOT SYNC_COMP_PAT(0));
	wire_nii1O_dataout <= SYNC_COMP_PAT(9) WHEN n1lOil = '1'  ELSE (NOT SYNC_COMP_PAT(1));
	wire_niii0O_dataout <= (wire_w_lg_n1000l1852w(0) OR (wire_w_lg_n1000i1853w(0) OR (wire_w_lg_n1001O1854w(0) OR (wire_w_lg_n1001l1855w(0) OR (wire_w_lg_n1001i1856w(0) OR (wire_w_lg_n101OO1857w(0) OR wire_w_lg_n101Ol1858w(0))))))) AND ni0Oii;
	wire_niiii_dataout <= SYNC_COMP_PAT(13) WHEN n1lOil = '1'  ELSE (NOT SYNC_COMP_PAT(5));
	wire_niiiii_dataout <= (n1i0ii OR n1i00O) AND ni0Oii;
	wire_niiiil_dataout <= (wire_w_lg_w_lg_PMADATAWIDTH126w1849w(0) OR (PMADATAWIDTH AND n1i1ii)) AND ni0Oii;
	wire_niiiiO_dataout <= n100Oi AND ni0Oii;
	wire_niiil_dataout <= SYNC_COMP_PAT(14) WHEN n1lOil = '1'  ELSE (NOT SYNC_COMP_PAT(6));
	wire_niiili_dataout <= n100OO AND ni0Oii;
	wire_niiill_dataout <= (((wire_w_lg_n10i0O1785w(0) OR wire_w_lg_n10i0l1787w(0)) OR wire_w_lg_n10i0i1795w(0)) OR wire_w_lg_n10i1O1847w(0)) AND ni0Oii;
	wire_niiilO_dataout <= (wire_w_lg_n10Oil1840w(0) OR (NOT (wire_w_lg_n10Oil1766w(0) OR wire_w_lg_n1i1ii1841w(0)))) AND ni0Oii;
	wire_niiiO_dataout <= SYNC_COMP_PAT(15) WHEN n1lOil = '1'  ELSE (NOT SYNC_COMP_PAT(7));
	wire_niiiOi_dataout <= niii1O AND ni0Oii;
	wire_niiiOl_dataout <= niii0i AND ni0Oii;
	wire_niiiOO_dataout <= niii0l AND ni0Oii;
	wire_niil0i_dataout <= (((wire_w_lg_n10l1i1750w(0) OR wire_w_lg_n10iOO1752w(0)) OR wire_w_lg_n10iOl1760w(0)) OR wire_w_lg_n10iOi1838w(0)) AND ni0Oii;
	wire_niil0l_dataout <= (wire_w_lg_n1i11l1831w(0) OR (NOT (wire_w_lg_n1i11l1731w(0) OR wire_w_lg_n1i10O1832w(0)))) AND ni0Oii;
	wire_niil1i_dataout <= niil0O AND ni0Oii;
	wire_niil1l_dataout <= n10iil AND ni0Oii;
	wire_niil1O_dataout <= n10ili AND ni0Oii;
	wire_niili_dataout <= (NOT SYNC_COMP_PAT(8)) AND NOT(n1lOil);
	wire_niill_dataout <= (NOT SYNC_COMP_PAT(9)) AND NOT(n1lOil);
	wire_niilO_dataout <= SYNC_COMP_PAT(7) AND NOT(n1lOii);
	wire_niiO0l_dataout <= (wire_w_lg_n100lO1818w(0) OR (wire_w_lg_n100ll1819w(0) OR (wire_w_lg_n100li1820w(0) OR (wire_w_lg_n100iO1821w(0) OR (wire_w_lg_n100il1822w(0) OR (wire_w_lg_n100ii1823w(0) OR wire_w_lg_n1000O1824w(0))))))) AND ni0Oii;
	wire_niiO0O_dataout <= (wire_w_lg_w_lg_PMADATAWIDTH126w1816w(0) OR wire_w_lg_PMADATAWIDTH1567w(0)) AND ni0Oii;
	wire_niiOi_dataout <= wire_niiOO_dataout AND NOT(n1lOii);
	wire_niiOii_dataout <= n10l1O AND ni0Oii;
	wire_niiOil_dataout <= n10l0l AND ni0Oii;
	wire_niiOiO_dataout <= (((wire_w_lg_n10lll1715w(0) OR wire_w_lg_n10lli1717w(0)) OR wire_w_lg_n10liO1725w(0)) OR wire_w_lg_n10lil1814w(0)) AND ni0Oii;
	wire_niiOl_dataout <= wire_nil1i_dataout AND NOT(n1lOii);
	wire_niiOli_dataout <= (wire_w_lg_n1i0il1808w(0) OR (NOT ((n1i0il OR n1i0iO) OR n1iiii))) AND ni0Oii;
	wire_niiOll_dataout <= niiO1l AND ni0Oii;
	wire_niiOlO_dataout <= niiO1O AND ni0Oii;
	wire_niiOO_dataout <= SYNC_COMP_PAT(8) AND NOT(n1lOil);
	wire_niiOOi_dataout <= niiO0i AND ni0Oii;
	wire_niiOOl_dataout <= ni1iOO AND ni0Oii;
	wire_niiOOO_dataout <= n10lOi AND ni0Oii;
	wire_nil11i_dataout <= n10lOO AND ni0Oii;
	wire_nil11l_dataout <= (((wire_w_lg_n10O0O1681w(0) OR wire_w_lg_n10O0l1683w(0)) OR wire_w_lg_n10O0i1691w(0)) OR wire_w_lg_n10O1O1806w(0)) AND ni0Oii;
	wire_nil11O_dataout <= (wire_w_lg_n1ii1l1799w(0) OR (NOT (wire_w_lg_n1ii1l1662w(0) OR wire_w_lg_n1ii0O1800w(0)))) AND ni0Oii;
	wire_nil1i_dataout <= SYNC_COMP_PAT(9) AND NOT(n1lOil);
	wire_nl00i_dataout <= nl11O WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE nl11i;
	wire_nl00l_dataout <= nl10i WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE nl11l;
	wire_nl00O_dataout <= nl10l WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE nl11O;
	wire_nl01i_dataout <= niOOO WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE niOOi;
	wire_nl01l_dataout <= nl11i WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE niOOl;
	wire_nl01O_dataout <= nl11l WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE niOOO;
	wire_nl0ii_dataout <= nl10O WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE nl10i;
	wire_nl0il_dataout <= nl1ii WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE nl10l;
	wire_nl0iO_dataout <= nl1il WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE nl10O;
	wire_nl0li_dataout <= nl1iO WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE nl1ii;
	wire_nl0ll_dataout <= nl1li WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE nl1il;
	wire_nl0lO_dataout <= nl1ll WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE nl1iO;
	wire_nl0Oi_dataout <= nl1Oi WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE nl1li;
	wire_nl0Ol_dataout <= nlliOl WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE nl1ll;
	wire_nl0OO_dataout <= PUDR(0) WHEN LP10BEN = '1'  ELSE PUDI(0);
	wire_nl1Ol_dataout <= niOOi WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE niOll;
	wire_nl1OO_dataout <= niOOl WHEN wire_w_lg_PMADATAWIDTH126w(0) = '1'  ELSE niOlO;
	wire_nli0i_dataout <= PUDR(4) WHEN LP10BEN = '1'  ELSE PUDI(4);
	wire_nli0l_dataout <= PUDR(5) WHEN LP10BEN = '1'  ELSE PUDI(5);
	wire_nli0O_dataout <= PUDR(6) WHEN LP10BEN = '1'  ELSE PUDI(6);
	wire_nli1i_dataout <= PUDR(1) WHEN LP10BEN = '1'  ELSE PUDI(1);
	wire_nli1l_dataout <= PUDR(2) WHEN LP10BEN = '1'  ELSE PUDI(2);
	wire_nli1O_dataout <= PUDR(3) WHEN LP10BEN = '1'  ELSE PUDI(3);
	wire_nliii_dataout <= PUDR(7) WHEN LP10BEN = '1'  ELSE PUDI(7);
	wire_nliil_dataout <= PUDR(8) WHEN LP10BEN = '1'  ELSE PUDI(8);
	wire_nliiO_dataout <= PUDR(9) WHEN LP10BEN = '1'  ELSE PUDI(9);
	wire_nll0i_dataout <= wire_w_lg_n1O1iO56w(0) AND NOT(n1O11l);
	wire_nll0l_dataout <= n1O11l OR n1O1iO;
	wire_nll0O_dataout <= n1O11l AND NOT(n1O1iO);
	wire_nll1l_dataout <= n1O1iO OR n1O11l;
	wire_nll1O_dataout <= n1O1iO AND NOT(n1O11l);
	wire_nllii_dataout <= wire_w_lg_n1O11l55w(0) AND NOT(n1O1iO);
	wire_nlO0lO_dataout <= SYNC_COMP_PAT(0) WHEN n1l11i = '1'  ELSE wire_nlOiii_dataout;
	wire_nlO0Oi_dataout <= SYNC_COMP_PAT(1) WHEN n1l11i = '1'  ELSE wire_nlOiil_dataout;
	wire_nlO0Ol_dataout <= SYNC_COMP_PAT(2) WHEN n1l11i = '1'  ELSE wire_nlOiiO_dataout;
	wire_nlO0OO_dataout <= SYNC_COMP_PAT(3) WHEN n1l11i = '1'  ELSE wire_nlOili_dataout;
	wire_nlOi0i_dataout <= SYNC_COMP_PAT(7) WHEN n1l11i = '1'  ELSE wire_nlOiOl_dataout;
	wire_nlOi0l_dataout <= nllOOl WHEN n1l11i = '1'  ELSE wire_nlOiOO_dataout;
	wire_nlOi0O_dataout <= wire_nlOl1i_dataout AND NOT(n1l11i);
	wire_nlOi1i_dataout <= SYNC_COMP_PAT(4) WHEN n1l11i = '1'  ELSE wire_nlOill_dataout;
	wire_nlOi1l_dataout <= SYNC_COMP_PAT(5) WHEN n1l11i = '1'  ELSE wire_nlOilO_dataout;
	wire_nlOi1O_dataout <= SYNC_COMP_PAT(6) WHEN n1l11i = '1'  ELSE wire_nlOiOi_dataout;
	wire_nlOiii_dataout <= nllO0O WHEN n1iOOO = '1'  ELSE nlO1iO;
	wire_nlOiil_dataout <= nllOii WHEN n1iOOO = '1'  ELSE nlO1li;
	wire_nlOiiO_dataout <= nllOil WHEN n1iOOO = '1'  ELSE nlO1ll;
	wire_nlOili_dataout <= nllOiO WHEN n1iOOO = '1'  ELSE nlO1lO;
	wire_nlOill_dataout <= nllOli WHEN n1iOOO = '1'  ELSE nlO1Oi;
	wire_nlOilO_dataout <= nllOll WHEN n1iOOO = '1'  ELSE nlO1Ol;
	wire_nlOiOi_dataout <= nllOlO WHEN n1iOOO = '1'  ELSE nlO1OO;
	wire_nlOiOl_dataout <= nllOOi WHEN n1iOOO = '1'  ELSE nlO01i;
	wire_nlOiOO_dataout <= nllOOl WHEN n1iOOO = '1'  ELSE nlO01l;
	wire_nlOl0O_dataout <= SYNC_COMP_PAT(0) WHEN n1l11l = '1'  ELSE nllOOO;
	wire_nlOl1i_dataout <= nlOOiO AND NOT(n1iOOO);
	wire_nlOlii_dataout <= SYNC_COMP_PAT(1) WHEN n1l11l = '1'  ELSE nlO11i;
	wire_nlOlil_dataout <= SYNC_COMP_PAT(2) WHEN n1l11l = '1'  ELSE nlO11l;
	wire_nlOliO_dataout <= SYNC_COMP_PAT(3) WHEN n1l11l = '1'  ELSE nlO11O;
	wire_nlOlli_dataout <= SYNC_COMP_PAT(4) WHEN n1l11l = '1'  ELSE nlO10i;
	wire_nlOlll_dataout <= SYNC_COMP_PAT(5) WHEN n1l11l = '1'  ELSE nlO10l;
	wire_nlOllO_dataout <= SYNC_COMP_PAT(6) WHEN n1l11l = '1'  ELSE nlO10O;
	wire_nlOlOi_dataout <= SYNC_COMP_PAT(7) WHEN n1l11l = '1'  ELSE nlO1ii;
	wire_n0101l_a <= ( n01lil & n1Oi1O);
	wire_n0101l_b <= ( "0" & "1");
	n0101l :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 2,
		width_b => 2,
		width_o => 2
	  )
	  PORT MAP ( 
		a => wire_n0101l_a,
		b => wire_n0101l_b,
		cin => wire_gnd,
		o => wire_n0101l_o
	  );
	wire_n1ilO_a <= ( n1l1i & n1i1O & n1i1l & n1i1i & "1");
	wire_n1ilO_b <= ( "1" & "1" & "1" & "0" & "1");
	n1ilO :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 5,
		width_b => 5,
		width_o => 5
	  )
	  PORT MAP ( 
		a => wire_n1ilO_a,
		b => wire_n1ilO_b,
		cin => wire_gnd,
		o => wire_n1ilO_o
	  );
	wire_ni0l0i_a <= ( "0" & "0" & wire_w_lg_n101ll1974w & RUNDISP_SEL(4 DOWNTO 2));
	wire_ni0l0i_b <= ( wire_w_lg_n101ll1974w & RUNDISP_SEL(4 DOWNTO 0));
	ni0l0i :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 6,
		width_b => 6,
		width_o => 6
	  )
	  PORT MAP ( 
		a => wire_ni0l0i_a,
		b => wire_ni0l0i_b,
		cin => wire_gnd,
		o => wire_ni0l0i_o
	  );
	wire_ni1llO_a <= ( wire_ni1O1l_dataout & wire_ni1O1i_dataout & wire_ni1lOO_dataout & wire_ni1lOl_dataout);
	wire_ni1llO_b <= ( "0" & "0" & "0" & "1");
	ni1llO :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4,
		width_o => 4
	  )
	  PORT MAP ( 
		a => wire_ni1llO_a,
		b => wire_ni1llO_b,
		cin => wire_gnd,
		o => wire_ni1llO_o
	  );
	wire_ni1lOi_a <= ( "0" & wire_ni1Oll_o & wire_ni1Oli_o & wire_ni1OiO_o & wire_ni1Oil_o);
	wire_ni1lOi_b <= ( "0" & wire_ni1Oii_o & wire_ni1O0O_o & wire_ni1O0l_o & wire_ni1O0i_o);
	ni1lOi :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 5,
		width_b => 5,
		width_o => 5
	  )
	  PORT MAP ( 
		a => wire_ni1lOi_a,
		b => wire_ni1lOi_b,
		cin => wire_gnd,
		o => wire_ni1lOi_o
	  );
	wire_n0001O_w_lg_w_o_range2561w2563w(0) <= wire_n0001O_w_o_range2561w(0) OR wire_n0001O_w_o_range2562w(0);
	wire_n0001O_i <= ( n0i11i & n00OOO);
	wire_n0001O_w_o_range2562w(0) <= wire_n0001O_o(0);
	wire_n0001O_w_o_range2561w(0) <= wire_n0001O_o(2);
	n0001O :  oper_decoder
	  GENERIC MAP (
		width_i => 2,
		width_o => 4
	  )
	  PORT MAP ( 
		i => wire_n0001O_i,
		o => wire_n0001O_o
	  );
	wire_n000li_w_lg_w_o_range2544w2546w(0) <= wire_n000li_w_o_range2544w(0) OR wire_n000li_w_o_range2545w(0);
	wire_n000li_i <= ( n00OOl & n00OOi);
	wire_n000li_w_o_range2545w(0) <= wire_n000li_o(0);
	wire_n000li_w_o_range2544w(0) <= wire_n000li_o(2);
	n000li :  oper_decoder
	  GENERIC MAP (
		width_i => 2,
		width_o => 4
	  )
	  PORT MAP ( 
		i => wire_n000li_i,
		o => wire_n000li_o
	  );
	wire_n001ll_w_lg_w_o_range2578w2580w(0) <= wire_n001ll_w_o_range2578w(0) OR wire_n001ll_w_o_range2579w(0);
	wire_n001ll_i <= ( n0i00i & n0i11l);
	wire_n001ll_w_o_range2579w(0) <= wire_n001ll_o(0);
	wire_n001ll_w_o_range2578w(0) <= wire_n001ll_o(2);
	n001ll :  oper_decoder
	  GENERIC MAP (
		width_i => 2,
		width_o => 4
	  )
	  PORT MAP ( 
		i => wire_n001ll_i,
		o => wire_n001ll_o
	  );
	wire_n00i1l_w_lg_w_o_range2527w2529w(0) <= wire_n00i1l_w_o_range2527w(0) OR wire_n00i1l_w_o_range2528w(0);
	wire_n00i1l_i <= ( n00OlO & n00Oll);
	wire_n00i1l_w_o_range2528w(0) <= wire_n00i1l_o(0);
	wire_n00i1l_w_o_range2527w(0) <= wire_n00i1l_o(2);
	n00i1l :  oper_decoder
	  GENERIC MAP (
		width_i => 2,
		width_o => 4
	  )
	  PORT MAP ( 
		i => wire_n00i1l_i,
		o => wire_n00i1l_o
	  );
	wire_n00iiO_w_lg_w_o_range2510w2512w(0) <= wire_n00iiO_w_o_range2510w(0) OR wire_n00iiO_w_o_range2511w(0);
	wire_n00iiO_i <= ( n00Oli & n00OiO);
	wire_n00iiO_w_o_range2511w(0) <= wire_n00iiO_o(0);
	wire_n00iiO_w_o_range2510w(0) <= wire_n00iiO_o(2);
	n00iiO :  oper_decoder
	  GENERIC MAP (
		width_i => 2,
		width_o => 4
	  )
	  PORT MAP ( 
		i => wire_n00iiO_i,
		o => wire_n00iiO_o
	  );
	wire_n00l1i_w_lg_w_o_range2493w2495w(0) <= wire_n00l1i_w_o_range2493w(0) OR wire_n00l1i_w_o_range2494w(0);
	wire_n00l1i_i <= ( n00Oil & n00Oii);
	wire_n00l1i_w_o_range2494w(0) <= wire_n00l1i_o(0);
	wire_n00l1i_w_o_range2493w(0) <= wire_n00l1i_o(2);
	n00l1i :  oper_decoder
	  GENERIC MAP (
		width_i => 2,
		width_o => 4
	  )
	  PORT MAP ( 
		i => wire_n00l1i_i,
		o => wire_n00l1i_o
	  );
	wire_n00lil_w_lg_w_o_range2476w2478w(0) <= wire_n00lil_w_o_range2476w(0) OR wire_n00lil_w_o_range2477w(0);
	wire_n00lil_i <= ( n00O0O & n00O0l);
	wire_n00lil_w_o_range2477w(0) <= wire_n00lil_o(0);
	wire_n00lil_w_o_range2476w(0) <= wire_n00lil_o(2);
	n00lil :  oper_decoder
	  GENERIC MAP (
		width_i => 2,
		width_o => 4
	  )
	  PORT MAP ( 
		i => wire_n00lil_i,
		o => wire_n00lil_o
	  );
	wire_n00lOO_w_lg_w_o_range2459w2461w(0) <= wire_n00lOO_w_o_range2459w(0) OR wire_n00lOO_w_o_range2460w(0);
	wire_n00lOO_i <= ( n00O0i & n00O1O);
	wire_n00lOO_w_o_range2460w(0) <= wire_n00lOO_o(0);
	wire_n00lOO_w_o_range2459w(0) <= wire_n00lOO_o(2);
	n00lOO :  oper_decoder
	  GENERIC MAP (
		width_i => 2,
		width_o => 4
	  )
	  PORT MAP ( 
		i => wire_n00lOO_i,
		o => wire_n00lOO_o
	  );
	wire_n10iO_i <= ( PMADATAWIDTH & wire_n010l_dataout & wire_n010i_dataout & wire_n011O_dataout & wire_n011l_dataout);
	n10iO :  oper_decoder
	  GENERIC MAP (
		width_i => 5,
		width_o => 32
	  )
	  PORT MAP ( 
		i => wire_n10iO_i,
		o => wire_n10iO_o
	  );
	wire_nlOOil_i <= ( n1llO & n1lll);
	nlOOil :  oper_decoder
	  GENERIC MAP (
		width_i => 2,
		width_o => 4
	  )
	  PORT MAP ( 
		i => wire_nlOOil_i,
		o => wire_nlOOil_o
	  );
	wire_ni0O1O_a <= ( wire_ni0l1O_dataout & wire_ni0l1l_dataout & wire_ni0l1i_dataout & wire_ni0iOO_dataout & wire_ni0iOl_dataout & wire_ni0iOi_dataout & wire_ni0ilO_dataout & wire_ni0ill_dataout);
	wire_ni0O1O_b <= ( ni0i0i & ni1lii & ni1l0O & ni1l0l & ni1l0i & ni1l1O & ni1l1l & ni1l1i);
	ni0O1O :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 8,
		width_b => 8
	  )
	  PORT MAP ( 
		a => wire_ni0O1O_a,
		b => wire_ni0O1O_b,
		cin => wire_gnd,
		o => wire_ni0O1O_o
	  );
	wire_n0001i_data <= ( wire_n0000i_dataout & "0" & n1llli);
	wire_n0001i_sel <= ( wire_n0001O_o(3) & wire_n0001O_w_lg_w_o_range2561w2563w & wire_n0001O_o(1));
	n0001i :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0001i_data,
		o => wire_n0001i_o,
		sel => wire_n0001i_sel
	  );
	wire_n000il_data <= ( wire_n000ll_dataout & "0" & n1ll1l);
	wire_n000il_sel <= ( wire_n000li_o(3) & wire_n000li_w_lg_w_o_range2544w2546w & wire_n000li_o(1));
	n000il :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n000il_data,
		o => wire_n000il_o,
		sel => wire_n000il_sel
	  );
	wire_n000OO_data <= ( wire_n00i1O_dataout & "0" & n1lill);
	wire_n000OO_sel <= ( wire_n00i1l_o(3) & wire_n00i1l_w_lg_w_o_range2527w2529w & wire_n00i1l_o(1));
	n000OO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n000OO_data,
		o => wire_n000OO_o,
		sel => wire_n000OO_sel
	  );
	wire_n001iO_data <= ( wire_n001lO_dataout & "0" & n1lO0l);
	wire_n001iO_sel <= ( wire_n001ll_o(3) & wire_n001ll_w_lg_w_o_range2578w2580w & wire_n001ll_o(1));
	n001iO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n001iO_data,
		o => wire_n001iO_o,
		sel => wire_n001iO_sel
	  );
	wire_n00iii_data <= ( wire_n00ili_dataout & "0" & n1liii);
	wire_n00iii_sel <= ( wire_n00iiO_o(3) & wire_n00iiO_w_lg_w_o_range2510w2512w & wire_n00iiO_o(1));
	n00iii :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n00iii_data,
		o => wire_n00iii_o,
		sel => wire_n00iii_sel
	  );
	wire_n00iOl_data <= ( wire_n00l1l_dataout & "0" & n1li0l);
	wire_n00iOl_sel <= ( wire_n00l1i_o(3) & wire_n00l1i_w_lg_w_o_range2493w2495w & wire_n00l1i_o(1));
	n00iOl :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n00iOl_data,
		o => wire_n00iOl_o,
		sel => wire_n00iOl_sel
	  );
	wire_n00l0O_data <= ( wire_n00liO_dataout & "0" & n1li1O);
	wire_n00l0O_sel <= ( wire_n00lil_o(3) & wire_n00lil_w_lg_w_o_range2476w2478w & wire_n00lil_o(1));
	n00l0O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n00l0O_data,
		o => wire_n00l0O_o,
		sel => wire_n00l0O_sel
	  );
	wire_n00lOi_data <= ( wire_n00O1i_dataout & "0" & n1li1i);
	wire_n00lOi_sel <= ( wire_n00lOO_o(3) & wire_n00lOO_w_lg_w_o_range2459w2461w & wire_n00lOO_o(1));
	n00lOi :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n00lOi_data,
		o => wire_n00lOi_o,
		sel => wire_n00lOi_sel
	  );
	wire_n100l_data <= ( nl11l & n111O & niOil & niOiO & niOli & niOll & niOlO & niOOi & niOOl & niOOO & nl11i);
	wire_n100l_sel <= ( n1l1Oi & n1l1lO & wire_n10iO_o(9 DOWNTO 1));
	n100l :  oper_selector
	  GENERIC MAP (
		width_data => 11,
		width_sel => 11
	  )
	  PORT MAP ( 
		data => wire_n100l_data,
		o => wire_n100l_o,
		sel => wire_n100l_sel
	  );
	wire_n100O_data <= ( nl11O & n10li & niOiO & niOli & niOll & niOlO & niOOi & niOOl & niOOO & nl11i & nl11l);
	wire_n100O_sel <= ( n1l1Oi & n1l1lO & wire_n10iO_o(9 DOWNTO 1));
	n100O :  oper_selector
	  GENERIC MAP (
		width_data => 11,
		width_sel => 11
	  )
	  PORT MAP ( 
		data => wire_n100O_data,
		o => wire_n100O_o,
		sel => wire_n100O_sel
	  );
	wire_n110i_data <= ( niOiO & niO1l & niO1O & niO0i & niO0l & niO0O & niOii & niOil & niOli & niOll & nilOO & niO1i);
	wire_n110i_sel <= ( n1l1ll & n1l1li & n1l1iO & n1l1il & n1l1ii & n1l10O & n1l10l & n1l10i & wire_n10iO_o(17 DOWNTO 16) & wire_n10iO_o(9 DOWNTO 8));
	n110i :  oper_selector
	  GENERIC MAP (
		width_data => 12,
		width_sel => 12
	  )
	  PORT MAP ( 
		data => wire_n110i_data,
		o => wire_n110i_o,
		sel => wire_n110i_sel
	  );
	wire_n110l_data <= ( niOli & niO1O & niO0i & niO0l & niO0O & niOii & niOil & niOiO & niOll & niOlO & niO1i & niO1l);
	wire_n110l_sel <= ( n1l1ll & n1l1li & n1l1iO & n1l1il & n1l1ii & n1l10O & n1l10l & n1l10i & wire_n10iO_o(17 DOWNTO 16) & wire_n10iO_o(9 DOWNTO 8));
	n110l :  oper_selector
	  GENERIC MAP (
		width_data => 12,
		width_sel => 12
	  )
	  PORT MAP ( 
		data => wire_n110l_data,
		o => wire_n110l_o,
		sel => wire_n110l_sel
	  );
	wire_n110O_data <= ( niOll & niO0i & niO0l & niO0O & niOii & niOil & niOiO & niOli & niOlO & niOOi & niO1l & niO1O);
	wire_n110O_sel <= ( n1l1ll & n1l1li & n1l1iO & n1l1il & n1l1ii & n1l10O & n1l10l & n1l10i & wire_n10iO_o(17 DOWNTO 16) & wire_n10iO_o(9 DOWNTO 8));
	n110O :  oper_selector
	  GENERIC MAP (
		width_data => 12,
		width_sel => 12
	  )
	  PORT MAP ( 
		data => wire_n110O_data,
		o => wire_n110O_o,
		sel => wire_n110O_sel
	  );
	wire_n11ii_data <= ( niOlO & niO0l & niO0O & niOii & niOil & niOiO & niOli & niOll & niOOi & niOOl & niO1O & niO0i);
	wire_n11ii_sel <= ( n1l1ll & n1l1li & n1l1iO & n1l1il & n1l1ii & n1l10O & n1l10l & n1l10i & wire_n10iO_o(17 DOWNTO 16) & wire_n10iO_o(9 DOWNTO 8));
	n11ii :  oper_selector
	  GENERIC MAP (
		width_data => 12,
		width_sel => 12
	  )
	  PORT MAP ( 
		data => wire_n11ii_data,
		o => wire_n11ii_o,
		sel => wire_n11ii_sel
	  );
	wire_n11il_data <= ( niOOi & niO0O & niOii & niOil & niOiO & niOli & niOll & niOlO & niOOl & niOOO & niO0i & niO0l);
	wire_n11il_sel <= ( n1l1ll & n1l1li & n1l1iO & n1l1il & n1l1ii & n1l10O & n1l10l & n1l10i & wire_n10iO_o(17 DOWNTO 16) & wire_n10iO_o(9 DOWNTO 8));
	n11il :  oper_selector
	  GENERIC MAP (
		width_data => 12,
		width_sel => 12
	  )
	  PORT MAP ( 
		data => wire_n11il_data,
		o => wire_n11il_o,
		sel => wire_n11il_sel
	  );
	wire_n11iO_data <= ( niOOl & niOii & niOil & niOiO & niOli & niOll & niOlO & niOOi & niOOO & nl11i & niO0l & niO0O);
	wire_n11iO_sel <= ( n1l1ll & n1l1li & n1l1iO & n1l1il & n1l1ii & n1l10O & n1l10l & n1l10i & wire_n10iO_o(17 DOWNTO 16) & wire_n10iO_o(9 DOWNTO 8));
	n11iO :  oper_selector
	  GENERIC MAP (
		width_data => 12,
		width_sel => 12
	  )
	  PORT MAP ( 
		data => wire_n11iO_data,
		o => wire_n11iO_o,
		sel => wire_n11iO_sel
	  );
	wire_n11li_data <= ( niOOO & niOil & niOiO & niOli & niOll & niOlO & niOOi & niOOl & nl11i & nl11l & niO0O & niOii);
	wire_n11li_sel <= ( n1l1ll & n1l1li & n1l1iO & n1l1il & n1l1ii & n1l10O & n1l10l & n1l10i & wire_n10iO_o(17 DOWNTO 16) & wire_n10iO_o(9 DOWNTO 8));
	n11li :  oper_selector
	  GENERIC MAP (
		width_data => 12,
		width_sel => 12
	  )
	  PORT MAP ( 
		data => wire_n11li_data,
		o => wire_n11li_o,
		sel => wire_n11li_sel
	  );
	wire_n11ll_data <= ( nl11i & niOiO & niOli & niOll & niOlO & niOOi & niOOl & niOOO & nl11l & nl11O & niOii & niOil);
	wire_n11ll_sel <= ( n1l1ll & n1l1li & n1l1iO & n1l1il & n1l1ii & n1l10O & n1l10l & n1l10i & wire_n10iO_o(17 DOWNTO 16) & wire_n10iO_o(9 DOWNTO 8));
	n11ll :  oper_selector
	  GENERIC MAP (
		width_data => 12,
		width_sel => 12
	  )
	  PORT MAP ( 
		data => wire_n11ll_data,
		o => wire_n11ll_o,
		sel => wire_n11ll_sel
	  );
	wire_n1Oi0i_data <= ( "0" & wire_n011Oi_dataout & wire_n011ii_dataout & wire_n011Oi_dataout & wire_n011ii_dataout & wire_n1OOll_dataout & wire_n1OO0l_dataout);
	wire_n1Oi0i_sel <= ( n110Oi & n01lOO & n01O1i & n01O1l & n01O1O & n01O0i & n01O0l);
	n1Oi0i :  oper_selector
	  GENERIC MAP (
		width_data => 7,
		width_sel => 7
	  )
	  PORT MAP ( 
		data => wire_n1Oi0i_data,
		o => wire_n1Oi0i_o,
		sel => wire_n1Oi0i_sel
	  );
	wire_n1Oi0l_data <= ( "0" & wire_n011Ol_dataout & wire_n011il_dataout & wire_n011Ol_dataout & wire_n011il_dataout & wire_n1OOlO_dataout & wire_n1OO0O_dataout);
	wire_n1Oi0l_sel <= ( n110Oi & n01lOO & n01O1i & n01O1l & n01O1O & n01O0i & n01O0l);
	n1Oi0l :  oper_selector
	  GENERIC MAP (
		width_data => 7,
		width_sel => 7
	  )
	  PORT MAP ( 
		data => wire_n1Oi0l_data,
		o => wire_n1Oi0l_o,
		sel => wire_n1Oi0l_sel
	  );
	wire_n1Oiii_data <= ( n1O0Oi & wire_n0100l_dataout & wire_n0100i_dataout & wire_n0100i_dataout & wire_n0100i_dataout & wire_n0100i_dataout & wire_n0100i_dataout & wire_n1OOOi_dataout & wire_n1OOOi_dataout);
	wire_n1Oiii_sel <= ( n110Ol & n01lll & n01lOl & n01lOO & n01O1i & n01O1l & n01O1O & n01O0i & n01O0l);
	n1Oiii :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n1Oiii_data,
		o => wire_n1Oiii_o,
		sel => wire_n1Oiii_sel
	  );
	wire_n1OiiO_data <= ( wire_n01l0l_dataout & wire_n01l1O_dataout & wire_n01iOO_dataout & wire_n01l1O_dataout & wire_n01iOO_dataout & wire_n0100O_dataout & wire_n0101O_dataout & wire_n0101O_dataout & wire_n0101O_dataout & wire_n0101O_dataout & wire_n0101O_dataout & wire_n01iOO_dataout & wire_n01iOO_dataout);
	wire_n1OiiO_sel <= ( n1O0li & n01liO & n01llO & n01lli & n01lOi & n01lll & n01lOl & n01lOO & n01O1i & n01O1l & n01O1O & n01O0i & n01O0l);
	n1OiiO :  oper_selector
	  GENERIC MAP (
		width_data => 13,
		width_sel => 13
	  )
	  PORT MAP ( 
		data => wire_n1OiiO_data,
		o => wire_n1OiiO_o,
		sel => wire_n1OiiO_sel
	  );
	wire_n1Oili_data <= ( wire_n01l0O_dataout & wire_n01l1l_dataout & wire_n01iOl_dataout & wire_n01l1l_dataout & wire_n01iOl_dataout & wire_nilOi_w_lg_n1O0Ol2618w & wire_nilOi_w_lg_n1O0Ol2618w & wire_nilOi_w_lg_n1O0Ol2618w & wire_nilOi_w_lg_n1O0Ol2618w & wire_nilOi_w_lg_n1O0Ol2618w & wire_nilOi_w_lg_n1O0Ol2618w & wire_nilOi_w_lg_n1O0Ol2618w & wire_nilOi_w_lg_n1O0Ol2618w);
	wire_n1Oili_sel <= ( n1O0li & n01liO & n01llO & n01lli & n01lOi & n01lll & n01lOl & n01lOO & n01O1i & n01O1l & n01O1O & n01O0i & n01O0l);
	n1Oili :  oper_selector
	  GENERIC MAP (
		width_data => 13,
		width_sel => 13
	  )
	  PORT MAP ( 
		data => wire_n1Oili_data,
		o => wire_n1Oili_o,
		sel => wire_n1Oili_sel
	  );
	wire_n1Oill_data <= ( n11lii & n11l0l & n11l1O & n11l0l & n11l1O & n11iOl & wire_nilOi_w_lg_n01Oii2616w & wire_nilOi_w_lg_n01Oii2616w & wire_nilOi_w_lg_n01Oii2616w & wire_nilOi_w_lg_n01Oii2616w & wire_nilOi_w_lg_n01Oii2616w & n11l1O & n11l1O);
	wire_n1Oill_sel <= ( n1O0li & n01liO & n01llO & n01lli & n01lOi & n01lll & n01lOl & n01lOO & n01O1i & n01O1l & n01O1O & n01O0i & n01O0l);
	n1Oill :  oper_selector
	  GENERIC MAP (
		width_data => 13,
		width_sel => 13
	  )
	  PORT MAP ( 
		data => wire_n1Oill_data,
		o => wire_n1Oill_o,
		sel => wire_n1Oill_sel
	  );
	wire_n1OilO_data <= ( wire_w_lg_n11lii2831w & wire_n01iii_dataout & "0");
	wire_n1OilO_sel <= ( n1O0li & n01liO & n110OO);
	n1OilO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1OilO_data,
		o => wire_n1OilO_o,
		sel => wire_n1OilO_sel
	  );
	wire_n1OiOl_data <= ( "0" & wire_n01iil_dataout & wire_n01i1O_dataout);
	wire_n1OiOl_sel <= ( n11i1i & n01liO & n01llO);
	n1OiOl :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1OiOl_data,
		o => wire_n1OiOl_o,
		sel => wire_n1OiOl_sel
	  );
	wire_n1Ol0l_data <= ( "0" & wire_n01iiO_dataout & wire_n01i0i_dataout & wire_n010ii_dataout);
	wire_n1Ol0l_sel <= ( n11i0i & n01lli & n01lOi & n01lll);
	n1Ol0l :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1Ol0l_data,
		o => wire_n1Ol0l_o,
		sel => wire_n1Ol0l_sel
	  );
	wire_n1Ol1i_data <= ( "0" & wire_n01iiO_dataout & wire_n01i0i_dataout & wire_n01iii_dataout);
	wire_n1Ol1i_sel <= ( n11i1l & n01liO & n01llO & n01lli);
	n1Ol1i :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1Ol1i_data,
		o => wire_n1Ol1i_o,
		sel => wire_n1Ol1i_sel
	  );
	wire_n1Ol1O_data <= ( "0" & wire_n01iil_dataout & wire_n01i1O_dataout);
	wire_n1Ol1O_sel <= ( n11i1O & n01lli & n01lOi);
	n1Ol1O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1Ol1O_data,
		o => wire_n1Ol1O_o,
		sel => wire_n1Ol1O_sel
	  );
	wire_n1Olii_data <= ( "0" & wire_n010il_dataout & wire_n0110l_dataout & wire_n1OOOO_dataout);
	wire_n1Olii_sel <= ( n11i0l & n01lll & n01lOl & n01O1i);
	n1Olii :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1Olii_data,
		o => wire_n1Olii_o,
		sel => wire_n1Olii_sel
	  );
	wire_n1OliO_data <= ( "0" & wire_n0110i_dataout & wire_n1OOOO_dataout);
	wire_n1OliO_sel <= ( n11i0O & n01lOl & n01O1O);
	n1OliO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1OliO_data,
		o => wire_n1OliO_o,
		sel => wire_n1OliO_sel
	  );
	wire_n1Olll_data <= ( "0" & wire_n0110i_dataout & wire_n0110i_dataout & wire_n1OOii_dataout);
	wire_n1Olll_sel <= ( n11iii & n01lOO & n01O1i & n01O0l);
	n1Olll :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n1Olll_data,
		o => wire_n1Olll_o,
		sel => wire_n1Olll_sel
	  );
	wire_n1OlOi_data <= ( "0" & wire_n0110l_dataout & wire_n0111i_dataout);
	wire_n1OlOi_sel <= ( n11iil & n01lOO & n01O1i);
	n1OlOi :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1OlOi_data,
		o => wire_n1OlOi_o,
		sel => wire_n1OlOi_sel
	  );
	wire_n1OlOO_data <= ( "0" & wire_n0110i_dataout);
	wire_n1OlOO_sel <= ( n11iiO & wire_w_lg_n11iiO2691w);
	n1OlOO :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_n1OlOO_data,
		o => wire_n1OlOO_o,
		sel => wire_n1OlOO_sel
	  );
	wire_n1OO1l_data <= ( "0" & wire_n0110l_dataout & wire_n0111i_dataout);
	wire_n1OO1l_sel <= ( n11iiO & n01O1l & n01O1O);
	n1OO1l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1OO1l_data,
		o => wire_n1OO1l_o,
		sel => wire_n1OO1l_sel
	  );
	wire_n1OO1O_data <= ( "0" & wire_w_lg_n11l1O2669w & wire_n1OOil_dataout);
	wire_n1OO1O_sel <= ( n11ili & n01O0i & n01O0l);
	n1OO1O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n1OO1O_data,
		o => wire_n1OO1O_o,
		sel => wire_n1OO1O_sel
	  );
	wire_ni010i_data <= ( "0" & wire_ni00ll_dataout & wire_ni00ll_dataout & wire_ni00ll_dataout & wire_ni01Ol_dataout & wire_ni01Ol_dataout & wire_ni01Ol_dataout);
	wire_ni010i_sel <= ( n1011O & ni0i0O & ni0iii & ni0iil & ni0iiO & ni0ili & ni0lli);
	ni010i :  oper_selector
	  GENERIC MAP (
		width_data => 7,
		width_sel => 7
	  )
	  PORT MAP ( 
		data => wire_ni010i_data,
		o => wire_ni010i_o,
		sel => wire_ni010i_sel
	  );
	wire_ni010l_data <= ( "0" & wire_ni00lO_dataout);
	wire_ni010l_sel <= ( n1010i & wire_w_lg_n1010i2023w);
	ni010l :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_ni010l_data,
		o => wire_ni010l_o,
		sel => wire_ni010l_sel
	  );
	wire_ni011l_data <= ( "0" & wire_ni00li_dataout & wire_ni00li_dataout & wire_ni00li_dataout & wire_ni01Oi_dataout & wire_ni01Oi_dataout & wire_ni01Oi_dataout);
	wire_ni011l_sel <= ( n1011O & ni0i0O & ni0iii & ni0iil & ni0iiO & ni0ili & ni0lli);
	ni011l :  oper_selector
	  GENERIC MAP (
		width_data => 7,
		width_sel => 7
	  )
	  PORT MAP ( 
		data => wire_ni011l_data,
		o => wire_ni011l_o,
		sel => wire_ni011l_sel
	  );
	wire_ni01ii_data <= ( "0" & wire_ni01OO_dataout);
	wire_ni01ii_sel <= ( n1010l & wire_w_lg_n1010l2011w);
	ni01ii :  oper_selector
	  GENERIC MAP (
		width_data => 2,
		width_sel => 2
	  )
	  PORT MAP ( 
		data => wire_ni01ii_data,
		o => wire_ni01ii_o,
		sel => wire_ni01ii_sel
	  );
	wire_ni1O0i_data <= ( "0" & niilOi & ni1l1i & nii0Ol);
	wire_ni1O0i_sel <= ( n1011O & n1011l & n11OOO & n1011i);
	ni1O0i :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_ni1O0i_data,
		o => wire_ni1O0i_o,
		sel => wire_ni1O0i_sel
	  );
	wire_ni1O0l_data <= ( "0" & niilOl & ni1l1l & nii0OO);
	wire_ni1O0l_sel <= ( n1011O & n1011l & n11OOO & n1011i);
	ni1O0l :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_ni1O0l_data,
		o => wire_ni1O0l_o,
		sel => wire_ni1O0l_sel
	  );
	wire_ni1O0O_data <= ( "0" & niilOO & ni1l1O & niii1i);
	wire_ni1O0O_sel <= ( n1011O & n1011l & n11OOO & n1011i);
	ni1O0O :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_ni1O0O_data,
		o => wire_ni1O0O_o,
		sel => wire_ni1O0O_sel
	  );
	wire_ni1Oii_data <= ( "0" & niiO1i & ni1l0i & niii1l);
	wire_ni1Oii_sel <= ( n1011O & n1011l & n11OOO & n1011i);
	ni1Oii :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_ni1Oii_data,
		o => wire_ni1Oii_o,
		sel => wire_ni1Oii_sel
	  );
	wire_ni1Oil_data <= ( "0" & niiliO & wire_ni000l_dataout & nii0li & wire_ni01iO_dataout);
	wire_ni1Oil_sel <= ( n1011O & n1011l & ni0iil & n1011i & ni0lli);
	ni1Oil :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_ni1Oil_data,
		o => wire_ni1Oil_o,
		sel => wire_ni1Oil_sel
	  );
	wire_ni1OiO_data <= ( "0" & niilli & wire_ni000O_dataout & nii0ll & wire_ni01li_dataout);
	wire_ni1OiO_sel <= ( n1011O & n1011l & ni0iil & n1011i & ni0lli);
	ni1OiO :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_ni1OiO_data,
		o => wire_ni1OiO_o,
		sel => wire_ni1OiO_sel
	  );
	wire_ni1Oli_data <= ( "0" & niilll & wire_ni00ii_dataout & nii0lO & wire_ni01ll_dataout);
	wire_ni1Oli_sel <= ( n1011O & n1011l & ni0iil & n1011i & ni0lli);
	ni1Oli :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_ni1Oli_data,
		o => wire_ni1Oli_o,
		sel => wire_ni1Oli_sel
	  );
	wire_ni1Oll_data <= ( "0" & niillO & wire_ni00il_dataout & nii0Oi & wire_ni01lO_dataout);
	wire_ni1Oll_sel <= ( n1011O & n1011l & ni0iil & n1011i & ni0lli);
	ni1Oll :  oper_selector
	  GENERIC MAP (
		width_data => 5,
		width_sel => 5
	  )
	  PORT MAP ( 
		data => wire_ni1Oll_data,
		o => wire_ni1Oll_o,
		sel => wire_ni1Oll_sel
	  );
	wire_nliOi_data <= ( wire_nll0l_dataout & wire_n1lOli29_w_lg_Q104w & "0");
	wire_nliOi_sel <= ( wire_n1lOll26_w_lg_Q98w & nlllO & nlilO);
	nliOi :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nliOi_data,
		o => wire_nliOi_o,
		sel => wire_nliOi_sel
	  );
	wire_nliOl_data <= ( n1O1iO & wire_n1lOlO23_w_lg_Q91w & "0");
	wire_nliOl_sel <= ( nlill & nlllO & nlilO);
	nliOl :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nliOl_data,
		o => wire_nliOl_o,
		sel => wire_nliOl_sel
	  );
	wire_nliOO_data <= ( wire_n1lOOi20_w_lg_Q81w & n1O11l & n01Oli);
	wire_nliOO_sel <= ( nlill & nlllO & nlilO);
	nliOO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nliOO_data,
		o => wire_nliOO_o,
		sel => wire_nliOO_sel
	  );
	wire_nll1i_data <= ( wire_n1lOOl17_w_lg_Q71w & wire_nll0i_dataout & wire_n1lOOO14_w_lg_Q66w);
	wire_nll1i_sel <= ( wire_n1O11i11_w_lg_Q62w & nlllO & nlilO);
	nll1i :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nll1i_data,
		o => wire_nll1i_o,
		sel => wire_nll1i_sel
	  );
	wire_nlOlOl_data <= ( SYNC_COMP_PAT(8) & SYNC_COMP_PAT(0) & nlO1iO);
	wire_nlOlOl_sel <= ( wire_nlOOil_o(3 DOWNTO 2) & n1l11O);
	nlOlOl :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOlOl_data,
		o => wire_nlOlOl_o,
		sel => wire_nlOlOl_sel
	  );
	wire_nlOlOO_data <= ( SYNC_COMP_PAT(9) & SYNC_COMP_PAT(1) & nlO1li);
	wire_nlOlOO_sel <= ( wire_nlOOil_o(3 DOWNTO 2) & n1l11O);
	nlOlOO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOlOO_data,
		o => wire_nlOlOO_o,
		sel => wire_nlOlOO_sel
	  );
	wire_nlOO0i_data <= ( SYNC_COMP_PAT(13) & SYNC_COMP_PAT(5) & nlO1Ol);
	wire_nlOO0i_sel <= ( wire_nlOOil_o(3 DOWNTO 2) & n1l11O);
	nlOO0i :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOO0i_data,
		o => wire_nlOO0i_o,
		sel => wire_nlOO0i_sel
	  );
	wire_nlOO0l_data <= ( SYNC_COMP_PAT(14) & SYNC_COMP_PAT(6) & nlO1OO);
	wire_nlOO0l_sel <= ( wire_nlOOil_o(3 DOWNTO 2) & n1l11O);
	nlOO0l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOO0l_data,
		o => wire_nlOO0l_o,
		sel => wire_nlOO0l_sel
	  );
	wire_nlOO0O_data <= ( SYNC_COMP_PAT(15) & SYNC_COMP_PAT(7) & nlO01i);
	wire_nlOO0O_sel <= ( wire_nlOOil_o(3 DOWNTO 2) & n1l11O);
	nlOO0O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOO0O_data,
		o => wire_nlOO0O_o,
		sel => wire_nlOO0O_sel
	  );
	wire_nlOO1i_data <= ( SYNC_COMP_PAT(10) & SYNC_COMP_PAT(2) & nlO1ll);
	wire_nlOO1i_sel <= ( wire_nlOOil_o(3 DOWNTO 2) & n1l11O);
	nlOO1i :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOO1i_data,
		o => wire_nlOO1i_o,
		sel => wire_nlOO1i_sel
	  );
	wire_nlOO1l_data <= ( SYNC_COMP_PAT(11) & SYNC_COMP_PAT(3) & nlO1lO);
	wire_nlOO1l_sel <= ( wire_nlOOil_o(3 DOWNTO 2) & n1l11O);
	nlOO1l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOO1l_data,
		o => wire_nlOO1l_o,
		sel => wire_nlOO1l_sel
	  );
	wire_nlOO1O_data <= ( SYNC_COMP_PAT(12) & SYNC_COMP_PAT(4) & nlO1Oi);
	wire_nlOO1O_sel <= ( wire_nlOOil_o(3 DOWNTO 2) & n1l11O);
	nlOO1O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOO1O_data,
		o => wire_nlOO1O_o,
		sel => wire_nlOO1O_sel
	  );

 END RTL; --stratixgx_hssi_rx_wal_rtl
--synopsys translate_on
--VALID FILE
--
-- STRATIXGX_HSSI_WORD_ALIGNER
--

library IEEE, stratixgx_gxb;
use IEEE.std_logic_1164.all;
use stratixgx_gxb.hssi_pack.all;

ENTITY stratixgx_hssi_word_aligner IS
    generic (
        channel_width       : integer := 10;
        align_pattern_length: integer := 10;
        infiniband_invalid_code: integer := 0;
        align_pattern   : string := "0000000101111100";
        synchronization_mode: string := "XAUI";
        use_8b_10b_mode : string := "true";
        use_auto_bit_slip   : string := "true");
    PORT (
        datain                  : IN std_logic_vector(9 DOWNTO 0);   
        clk                     : IN std_logic;   
        softreset               : IN std_logic;   
        enacdet                 : IN std_logic;   
        bitslip                 : IN std_logic;   
        a1a2size                : IN std_logic;   
        aligneddata             : OUT std_logic_vector(9 DOWNTO 0);   
        aligneddatapre          : OUT std_logic_vector(9 DOWNTO 0);   
        invalidcode             : OUT std_logic;   
        invalidcodepre          : OUT std_logic;   
        syncstatus              : OUT std_logic;   
        syncstatusdeskew        : OUT std_logic;   
        disperr                 : OUT std_logic;   
        disperrpre              : OUT std_logic;   
        patterndetectpre        : OUT std_logic;   
        patterndetect           : OUT std_logic);   
END stratixgx_hssi_word_aligner;

ARCHITECTURE auto_translated OF stratixgx_hssi_word_aligner IS

    COMPONENT stratixgx_hssi_rx_wal_rtl
        PORT (
            rcvd_clk                : IN  std_logic;
            soft_reset              : IN  std_logic;
            LP10BEN                 : IN  std_logic;
            RLV_EN                  : IN  std_logic;
            RUNDISP_SEL             : IN  std_logic_vector(4 DOWNTO 0);
            PMADATAWIDTH            : IN  std_logic;
            SYNC_COMP_PAT           : IN  std_logic_vector(15 DOWNTO 0);
            SYNC_COMP_SIZE          : IN  std_logic_vector(1 DOWNTO 0);
            IB_INVALID_CODE         : IN  std_logic_vector(1 DOWNTO 0);
            AUTOBYTEALIGN_DIS       : IN  std_logic;
            BITSLIP                 : IN  std_logic;
            DISABLE_RX_DISP         : IN  std_logic;
            ENCDT                   : IN  std_logic;
            SYNC_SM_DIS             : IN  std_logic;
            prbs_en                 : IN  std_logic;
            encdet_prbs             : IN  std_logic;
            GE_XAUI_SEL             : IN  std_logic;
            signal_detect           : IN  std_logic;
            PUDI                    : IN  std_logic_vector(9 DOWNTO 0);
            PUDR                    : IN  std_logic_vector(9 DOWNTO 0);
            A1A2_SIZE               : IN  std_logic;
            DWIDTH                  : IN  std_logic;
            cg_comma                : OUT std_logic;
            sync_status             : OUT std_logic;
            signal_detect_sync      : OUT std_logic;
            SUDI                    : OUT std_logic_vector(12 DOWNTO 0);
            SUDI_pre                : OUT std_logic_vector(9 DOWNTO 0);
            RLV                     : OUT std_logic;
            RLV_lt                  : OUT std_logic;
            sync_curr_st            : OUT std_logic_vector(3 DOWNTO 0));
    END COMPONENT;


    -- input interface
    SIGNAL rcvd_clk                 :  std_logic;   
    SIGNAL soft_reset               :  std_logic;   
    SIGNAL LP10BEN                  :  std_logic;   
    SIGNAL RLV_EN                   :  std_logic;   
    SIGNAL RUNDISP_SEL              :  std_logic_vector(4 DOWNTO 0);   
    SIGNAL PMADATAWIDTH             :  std_logic;   
    SIGNAL SYNC_COMP_PAT            :  std_logic_vector(15 DOWNTO 0);   
    SIGNAL SYNC_COMP_SIZE           :  std_logic_vector(1 DOWNTO 0);   
    SIGNAL IB_INVALID_CODE          :  std_logic_vector(1 DOWNTO 0);   
    SIGNAL AUTOBYTEALIGN_DIS        :  std_logic;   
    SIGNAL SYNC_SM_DIS              :  std_logic;   
    SIGNAL GE_XAUI_SEL              :  std_logic;   
    SIGNAL encdet_prbs              :  std_logic;   
    SIGNAL BITSLIP_xhdl11           :  std_logic;   
    SIGNAL ENCDT                    :  std_logic;   
    SIGNAL prbs_en                  :  std_logic;   
    SIGNAL DISABLE_RX_DISP          :  std_logic;   
    SIGNAL signal_detect            :  std_logic;   
    SIGNAL PUDI                     :  std_logic_vector(9 DOWNTO 0);   
    SIGNAL PUDR                     :  std_logic_vector(9 DOWNTO 0);   
    SIGNAL A1A2_SIZE                :  std_logic;  
     
    -- A1A2 and A1A1A2A2 pattern detection
    SIGNAL DWIDTH                   :  std_logic;   

    -- output interface
    SIGNAL cg_comma                 :  std_logic;   
    SIGNAL sync_status              :  std_logic;   
    SIGNAL signal_detect_sync       :  std_logic;   
    SIGNAL SUDI                     :  std_logic_vector(12 DOWNTO 0);   
    SIGNAL SUDI_pre                 :  std_logic_vector(9 DOWNTO 0);   
    SIGNAL RLV                      :  std_logic;   
    SIGNAL RLV_lt                   :  std_logic;   
    SIGNAL sync_curr_st             :  std_logic_vector(3 DOWNTO 0);   
    SIGNAL temp_xhdl12              :  std_logic;   
    SIGNAL temp_xhdl13              :  std_logic_vector(1 DOWNTO 0);   
    SIGNAL temp_xhdl14              :  std_logic_vector(1 DOWNTO 0);   
    SIGNAL temp_xhdl15              :  std_logic;   
    SIGNAL temp_xhdl16              :  std_logic;   
    SIGNAL temp_xhdl17              :  std_logic;   
    SIGNAL temp_xhdl18              :  std_logic_vector(1 DOWNTO 0);   
    SIGNAL temp_xhdl19              :  std_logic_vector(1 DOWNTO 0);   
    SIGNAL temp_xhdl20              :  std_logic_vector(1 DOWNTO 0);   
    SIGNAL aligneddata_xhdl1        :  std_logic_vector(9 DOWNTO 0);   
    SIGNAL aligneddatapre_xhdl2     :  std_logic_vector(9 DOWNTO 0);   
    SIGNAL invalidcode_xhdl3        :  std_logic;   
    SIGNAL invalidcodepre_xhdl4     :  std_logic;   
    SIGNAL syncstatus_xhdl5         :  std_logic;   
    SIGNAL syncstatusdeskew_xhdl6   :  std_logic;   
    SIGNAL disperr_xhdl7            :  std_logic;   
    SIGNAL disperrpre_xhdl8         :  std_logic;   
    SIGNAL patterndetect_xhdl9      :  std_logic;   
    SIGNAL patterndetectpre_xhdl10  :  std_logic;   

BEGIN
    aligneddata <= aligneddata_xhdl1;
    aligneddatapre <= aligneddatapre_xhdl2;
    invalidcode <= invalidcode_xhdl3;
    invalidcodepre <= invalidcodepre_xhdl4;
    syncstatus <= syncstatus_xhdl5;
    syncstatusdeskew <= syncstatusdeskew_xhdl6;
    disperr <= disperr_xhdl7;
    disperrpre <= disperrpre_xhdl8;
    patterndetect <= patterndetect_xhdl9;
    patterndetectpre <= patterndetectpre_xhdl10;
    RLV_EN <= '0' ;
    RUNDISP_SEL <= "01000" ;
    DWIDTH <= '0' ;
    LP10BEN <= '0' ;
    DISABLE_RX_DISP <= '0' ;
    temp_xhdl12 <= '1' WHEN (align_pattern_length = 16 OR align_pattern_length = 8) ELSE '0';
    PMADATAWIDTH <= temp_xhdl12 ;
    SYNC_COMP_PAT <= pattern_conversion(align_pattern) ;
    temp_xhdl13 <= "01" WHEN (align_pattern_length = 16 OR align_pattern_length = 8) ELSE "10";
    temp_xhdl14 <= "00" WHEN (align_pattern_length = 7) ELSE temp_xhdl13;
    SYNC_COMP_SIZE <= temp_xhdl14 ;
    temp_xhdl15 <= '1' WHEN (synchronization_mode = "none" OR synchronization_mode = "NONE") ELSE '0';
    SYNC_SM_DIS <= temp_xhdl15 ;
    temp_xhdl16 <= '1' WHEN (synchronization_mode = "gige" OR synchronization_mode = "GIGE") ELSE '0';
    GE_XAUI_SEL <= temp_xhdl16 ;
    temp_xhdl17 <= '0' WHEN (use_auto_bit_slip = "true" OR use_auto_bit_slip = "ON") ELSE '1';
    AUTOBYTEALIGN_DIS <= temp_xhdl17 ;
    temp_xhdl18 <= "10" WHEN (infiniband_invalid_code = 2) ELSE "11";
    temp_xhdl19 <= "01" WHEN (infiniband_invalid_code = 1) ELSE temp_xhdl18;
    temp_xhdl20 <= "00" WHEN (infiniband_invalid_code = 0) ELSE temp_xhdl19;
    IB_INVALID_CODE <= temp_xhdl20 ;
    prbs_en <= '0' ;
    encdet_prbs <= '0' ;
    signal_detect <= '1' ;
    rcvd_clk <= clk ;
    soft_reset <= softreset ;
    BITSLIP_xhdl11 <= bitslip ;
    ENCDT <= enacdet ;

    -- filtering X valus
    PUDI(0) <= datain(0) WHEN (datain(0) = '0' OR datain(0) = '1') ELSE '0';
    PUDI(1) <= datain(1) WHEN (datain(1) = '0' OR datain(1) = '1') ELSE '0';
    PUDI(2) <= datain(2) WHEN (datain(2) = '0' OR datain(2) = '1') ELSE '0';
    PUDI(3) <= datain(3) WHEN (datain(3) = '0' OR datain(3) = '1') ELSE '0';
    PUDI(4) <= datain(4) WHEN (datain(4) = '0' OR datain(4) = '1') ELSE '0';
    PUDI(5) <= datain(5) WHEN (datain(5) = '0' OR datain(5) = '1') ELSE '0';
    PUDI(6) <= datain(6) WHEN (datain(6) = '0' OR datain(6) = '1') ELSE '0';
    PUDI(7) <= datain(7) WHEN (datain(7) = '0' OR datain(7) = '1') ELSE '0';
    PUDI(8) <= datain(8) WHEN (datain(8) = '0' OR datain(8) = '1') ELSE '0';
    PUDI(9) <= datain(9) WHEN (datain(9) = '0' OR datain(9) = '1') ELSE '0';

    A1A2_SIZE <= a1a2size ;
    PUDR <= "XXXXXXXXXX" ;
    aligneddata_xhdl1 <= SUDI(9 DOWNTO 0) ;
    invalidcode_xhdl3 <= SUDI(10) ;
    syncstatus_xhdl5 <= SUDI(11) ;
    disperr_xhdl7 <= SUDI(12) ;
    syncstatusdeskew_xhdl6 <= sync_status ;
    patterndetect_xhdl9 <= cg_comma ;
    aligneddatapre_xhdl2 <= SUDI_pre ;
    invalidcodepre_xhdl4 <= '0' ;
    disperrpre_xhdl8 <= '0' ;
    patterndetectpre_xhdl10 <= '0' ;
    m_wal_rtl : stratixgx_hssi_rx_wal_rtl 
        PORT MAP (
            rcvd_clk => rcvd_clk,
            soft_reset => soft_reset,
            LP10BEN => LP10BEN,
            RLV_EN => RLV_EN,
            RUNDISP_SEL => RUNDISP_SEL,
            PMADATAWIDTH => PMADATAWIDTH,
            SYNC_COMP_PAT => SYNC_COMP_PAT,
            SYNC_COMP_SIZE => SYNC_COMP_SIZE,
            IB_INVALID_CODE => IB_INVALID_CODE,
            AUTOBYTEALIGN_DIS => AUTOBYTEALIGN_DIS,
            BITSLIP => BITSLIP_xhdl11,
            DISABLE_RX_DISP => DISABLE_RX_DISP,
            ENCDT => ENCDT,
            SYNC_SM_DIS => SYNC_SM_DIS,
            prbs_en => prbs_en,
            encdet_prbs => encdet_prbs,
            GE_XAUI_SEL => GE_XAUI_SEL,
            signal_detect => signal_detect,
            PUDI => PUDI,
            PUDR => PUDR,
            cg_comma => cg_comma,
            sync_status => sync_status,
            signal_detect_sync => signal_detect_sync,
            SUDI => SUDI,
            SUDI_pre => SUDI_pre,
            RLV => RLV,
            RLV_lt => RLV_lt,
            sync_curr_st => sync_curr_st,
            A1A2_SIZE => A1A2_SIZE,
            DWIDTH => DWIDTH);   
    

END auto_translated;

--
-- STRATIXGX_HSSI_RX_SERDES
--

library IEEE, stratixgx_gxb,std;
use IEEE.std_logic_1164.all;
use stratixgx_gxb.hssi_pack.all;
use std.textio.all;

entity stratixgx_hssi_rx_serdes is
    generic (
                    channel_width           : integer := 10;
                    rlv_length              : integer := 1;
                    run_length_enable       : String := "false";
                    cruclk_period           : integer :=5000; 
                    cruclk_multiplier       : integer :=4; 
                    use_cruclk_divider  : String := "false";
               use_double_data_mode :  string  := "false"    
                );

    port (
                datain      : in std_logic := '0';
                cruclk      : in std_logic := '0';
                areset      : in std_logic := '0';
                feedback        : in std_logic := '0';
                fbkcntl     : in std_logic := '0';
                ltr         : in std_logic := '0';  -- q3.0ll
                ltd         : in std_logic := '0';  -- q3.0ll
                dataout     : out std_logic_vector(9 downto 0);
                clkout      : out std_logic;
                rlv         : out std_logic;
                lock            : out std_logic;
                freqlock        : out std_logic;
                signaldetect: out std_logic
            );

end stratixgx_hssi_rx_serdes;

architecture vital_rx_serdes_atom of stratixgx_hssi_rx_serdes is

   constant channel_width_max       : integer := 10;

    constant    init_lock_latency       : integer := 9; -- q3.0ll
    signal ltr_ipd            :  std_logic;
    signal ltd_ipd            :  std_logic;
    signal lock_tmp           :  std_logic;
    signal freqlock_tmp       :  std_logic;
    signal freqlock_tmp_dly   :  std_logic;             
    signal freqlock_tmp_dly1  :  std_logic;           
    signal freqlock_tmp_dly2  :  std_logic;         
    signal freqlock_tmp_dly3  :  std_logic;        
    signal freqlock_tmp_dly4  :  std_logic;        

    signal databuf_ipd : std_logic;
    signal cruclk_ipd  : std_logic;
    signal areset_ipd : std_logic;
    signal fbin_ipd : std_logic;
    signal fbena_ipd : std_logic;

    -- add 2 deltas to balance new fastclk_gen - always read prev data
    -- The 1st fastclk has: in_delta + 1(ipd) + 1 (fastclk <= after 0)
    -- remaining fastclk has 0 delta
    -- in summary: fastclk_delta = x(from top) + 1(ipd) + 1 or    0 (no delta)
    --             data          = x(from top) + 1(ipd) + 2 (new)
    signal databuf_tmp1, databuf_tmp2 : std_logic;
    signal areset_tmp1, areset_tmp2   : std_logic;
    signal fbin_tmp1,  fbin_tmp2      : std_logic;
    signal fbena_tmp1, fbena_tmp2     : std_logic;
    signal ltr_tmp1, ltr_tmp2         : std_logic;
    signal ltd_tmp1, ltd_tmp2         : std_logic;

    -- clock gen
    signal fastclk  : std_logic;
    signal cruclk_ipd_last_value : std_logic := 'X';

    signal rlv_flag : std_logic := '0';
    signal rlv_flag_tmp : std_logic := '0';
    signal rlv_set : std_logic := '0';
    signal clkout_int : std_logic := '0';
   signal deser_data_arr : std_logic_vector(channel_width_max-1 downto 0);
    signal deser_data_arr_int : std_logic_vector(channel_width_max-1 downto 0);
    signal deser_data_arr_tmp : std_logic_vector(channel_width_max-1 downto 0);
   signal min_length : integer := 0;
    signal rlv_tmp1 : std_logic := '0';
    signal rlv_tmp2 : std_logic := '0';
    signal rlv_tmp3 : std_logic := '0';
    signal dataout_tmp : std_logic_vector(channel_width_max-1 downto 0);

begin

    ----------------------
    --  INPUT PATH DELAYs
    ----------------------
   -- for now assuming all delays on top level

    WireDelay : block
    begin
        cruclk_ipd   <= cruclk;

        databuf_tmp1 <= datain;
        fbin_tmp1    <= feedback;
        fbena_tmp1   <= fbkcntl;
        areset_tmp1  <= areset;
        ltr_tmp1     <= ltr;
        ltd_tmp1     <= ltd;

        databuf_tmp2 <= databuf_tmp1;
        fbin_tmp2    <= fbin_tmp1;
        fbena_tmp2   <= fbena_tmp1;
        areset_tmp2  <= areset_tmp1;
        ltr_tmp2     <= ltr_tmp1;
        ltd_tmp2     <= ltd_tmp1;
         
        databuf_ipd <= databuf_tmp2;
        fbin_ipd    <= fbin_tmp2;
        fbena_ipd   <= fbena_tmp2;
        areset_ipd  <= areset_tmp2;
        ltr_ipd     <= ltr_tmp2;
        ltd_ipd     <= ltd_tmp2;

    end block;

    min_length <= 4 WHEN (channel_width = 8) ELSE 5;

process (cruclk_ipd)
    variable init                  : boolean   := true;
    variable n_fastclk             : integer   := 5;
    variable fastclk_period        : integer   := 320;
    variable cru_rem               : integer   := 0;
    variable my_rem                : integer   := 0;
    variable tmp_fastclk_period    : integer   := 320;
    variable cycle_to_adjust       : integer   := 0;
    variable k                     : integer   := 1;
    variable high_time             : integer   := 160;
    variable low_time              : integer   := 160;
    variable sched_time            : time      := 0 ps;
    variable sched_val             : std_logic := '0';
begin
    if (init) then
        if (use_cruclk_divider = "false") then
            n_fastclk := cruclk_multiplier;
        else
            n_fastclk := cruclk_multiplier / 2;
        end if;        
        fastclk_period := cruclk_period / n_fastclk;
        cru_rem := cruclk_period rem n_fastclk;
                      
        init := false;
    end if;

    if ((cruclk_ipd = '1') and (cruclk_ipd_last_value = '0')) then     
        -- schedule n_fastclk of clk with period fastclk_period
        sched_time := 0 ps;
        sched_val  := '1';  -- start with rising to match cruclk
        
        k := 1; -- used to distribute rem ps to n_fastclk internals
        for i in 1 to n_fastclk loop
            fastclk <= transport sched_val after sched_time; -- rising
             
            -- wether it needs to add extra ps to the period
            tmp_fastclk_period := fastclk_period;
            if (cru_rem /= 0 and k <= cru_rem) then
               cycle_to_adjust := (n_fastclk * k) / cru_rem;
               my_rem := (n_fastclk * k) rem cru_rem;
               if (my_rem /= 0) then
                   cycle_to_adjust := cycle_to_adjust + 1;
               end if;
                     
               if (cycle_to_adjust = i) then
                   tmp_fastclk_period := tmp_fastclk_period + 1;
                   k := k + 1;
               end if;
            end if;
                     
            high_time := tmp_fastclk_period / 2;
            low_time  := tmp_fastclk_period - high_time; 
            sched_val := not sched_val;
            sched_time := sched_time + (high_time * 1 ps);
            fastclk <= transport sched_val after sched_time; -- falling
            sched_time := sched_time + (low_time * 1 ps);
            sched_val  := not sched_val;
        end loop;          
    end if; -- rising cruclk
    
    cruclk_ipd_last_value <= cruclk_ipd;
end process;

process (fastclk, areset_ipd, fbena_ipd)

variable clk_count : integer := channel_width; --follow the 1st edge
variable signaldetect_tmp : std_logic := '0';
variable clkout_last_value : std_logic;
variable    clkout_tmp : std_logic;
variable datain_ipd : std_logic;
variable last_datain : std_logic;
variable rlv_count : integer := 0; 
variable data_changed : std_logic := '0';

begin

    if (now = 0 ns) then
        data_changed :=  '0';
        clk_count := channel_width;
        clkout_tmp := '0';
        signaldetect_tmp := '1';
      for i in channel_width_max-1 downto 0 loop
            deser_data_arr(i) <= '0';
            deser_data_arr_int(i) <= '0';
        end loop;
        last_datain := 'X';
    end if;

    ------------------------
    --  Timing Check Section
    ------------------------

    -- for now assuming all delays on top level module

    if (areset_ipd = '1') then
        clkout_tmp :=  '0';
        clkout_last_value := fastclk;
        clk_count := channel_width;
        signaldetect_tmp := '1';
      for i in channel_width_max-1 downto 0 loop
            deser_data_arr(i) <= '0';
            deser_data_arr_int(i) <= '0';
      end loop;
        rlv_count := 0;
        rlv_flag <= '0';
        rlv_set <= '0';
        last_datain := 'X';
        data_changed := '0';
    else
        if (fbena_ipd = '1') then
            datain_ipd := fbin_ipd;
        else
            datain_ipd := databuf_ipd;
        end if;
       if (fastclk'event and fastclk /= 'X' and fastclk /= 'U') then
            if (clkout_last_value = 'U') then
                clkout_last_value := fastclk;
                clkout_tmp := fastclk;
            elsif (clk_count = channel_width) then
                clkout_tmp := NOT (clkout_last_value);
            elsif (clk_count = channel_width/2) then
                clkout_tmp := NOT (clkout_last_value);
            elsif (clk_count < channel_width) then
                clkout_tmp := clkout_last_value;
            end if;

            if (clk_count = channel_width) then
                clk_count := 0;
            end if;

            clk_count := clk_count + 1;

            if (run_length_enable = "true") then
                if (last_datain /= datain_ipd) then
                    data_changed := '1';
                    last_datain := datain_ipd;
                    rlv_count := 1;
                    rlv_set <= '0';
                else
                    rlv_count := rlv_count + 1;
                    data_changed := '0';
                end if;
                if (rlv_count > rlv_length AND rlv_count > min_length) then
                    rlv_set <= '1';
                    rlv_flag <= '1';
                else
                    rlv_flag <= rlv_flag_tmp;
                end if;
            end if;
       end if;

       if (fastclk'event and fastclk /= 'X'and fastclk /= 'U') then
          for i in 1 to channel_width_max-1 loop
                deser_data_arr(i - 1) <= deser_data_arr(i);
          end loop;
          deser_data_arr(channel_width_max - 1) <= datain_ipd;

            deser_data_arr_int <= deser_data_arr;
       end if;

        if (clkout_tmp /= 'U') then
            clkout_last_value := clkout_tmp;
        end if;
    end if;

    ----------------------
    --  Path Delay Section
    ----------------------
    
    -- for now assuming all delays on top level module

    clkout_int <= clkout_tmp;
    signaldetect <= signaldetect_tmp;
    
end process;

process (clkout_int, areset_ipd)
begin

    if (now = 0 ns) then
        dataout_tmp <= (OTHERS => '0');
      for i in channel_width_max-1 downto 0 loop
            deser_data_arr_tmp(i) <= '0';
        end loop;
        rlv_tmp1 <=  '0';
        rlv_tmp2 <=  '0';
        rlv_tmp3 <=  '0';
        rlv_flag_tmp <= '0';
    end if;

    if (areset_ipd = '1') then
        dataout_tmp <= (OTHERS => '0');
      for i in channel_width_max-1 downto 0 loop
            deser_data_arr_tmp(i) <= '0';
        end loop;
        rlv_tmp1 <=  '0';
        rlv_tmp2 <=  '0';
        rlv_tmp3 <=  '0';
    elsif (clkout_int'event and clkout_int = '1') then

        deser_data_arr_tmp <= deser_data_arr_int;

        dataout_tmp(channel_width_max-1 downto 0) <= deser_data_arr_tmp;

        if (run_length_enable = "true") then
         rlv_tmp2 <= rlv_tmp1;
         rlv_tmp3 <= rlv_tmp2;

            if (rlv_flag = '1') then
                if (rlv_set = '0') then
                    rlv_flag_tmp <= '0';
                   rlv_tmp1 <= '0';
                else
                   rlv_tmp1 <= '1';
                    rlv_flag_tmp <= '1';
                end if;
            else
                rlv_tmp1 <= '0';
                rlv_flag_tmp <= '0';
            end if;
        end if;
   end if;

end process;

-- q3.0ll lock and freqlock based on LTR and LTD
process (cruclk_ipd, areset_ipd)
variable cruclk_cnt : integer := 0;
begin

    if (now = 0 ns) then
        cruclk_cnt := 0;
        lock_tmp <= '1';
        freqlock_tmp <= '0';
        freqlock_tmp_dly <= '0';
        freqlock_tmp_dly1 <= '0';     
        freqlock_tmp_dly2 <= '0';     
        freqlock_tmp_dly3 <= '0';     
        freqlock_tmp_dly4 <= '0';
    end if;

    if (areset_ipd = '1') then
        cruclk_cnt := 0;
        lock_tmp <= '1';
        freqlock_tmp <= '0';
        freqlock_tmp_dly <= '0';
        freqlock_tmp_dly1 <= '0';     
        freqlock_tmp_dly2 <= '0';     
        freqlock_tmp_dly3 <= '0';     
        freqlock_tmp_dly4 <= '0';
    elsif (cruclk_ipd'event and cruclk_ipd = '1' and cruclk_ipd_last_value = '0') then
        freqlock_tmp_dly <= freqlock_tmp_dly4;
        freqlock_tmp_dly4 <= freqlock_tmp_dly3;
        freqlock_tmp_dly3 <= freqlock_tmp_dly2;
        freqlock_tmp_dly2 <= freqlock_tmp_dly1;
        freqlock_tmp_dly1 <= freqlock_tmp;

        if (cruclk_cnt = init_lock_latency) then
            if (ltd_ipd = '1') then
                freqlock_tmp <= '1';
            elsif (ltr_ipd = '1') then
                lock_tmp <= '0';
                freqlock_tmp <= '0';
            else                      -- auto switch
                lock_tmp <= '0';
                freqlock_tmp <= '1';
            end if;
        end if;             

        -- initial latency
        if (cruclk_cnt < init_lock_latency) then
            cruclk_cnt := cruclk_cnt + 1;
        end if;
    end if;
                
end process;

rlv <= '0' WHEN (run_length_enable = "false") ELSE (rlv_tmp1 OR rlv_tmp2) WHEN (use_double_data_mode = "false") ELSE  (rlv_tmp1 OR rlv_tmp2 OR rlv_tmp3);

lock <= lock_tmp;
freqlock <= freqlock_tmp_dly;
clkout <= clkout_int;
dataout <= dataout_tmp;

end vital_rx_serdes_atom;

--
-- stratixgx_hssi_tx_serdes
--

library IEEE, stratixgx_gxb;
use IEEE.std_logic_1164.all;
use stratixgx_gxb.hssi_pack.all;

entity stratixgx_hssi_tx_serdes is
    generic (
                channel_width           : integer := 10
                );

        port (
                clk             : in std_logic := '0';
                clk1            : in std_logic := '0';
                datain          : in std_logic_vector(9 downto 0) := "0000000000";
                     serialdatain     : in std_logic := '0';
                     srlpbk               : in std_logic := '0';
                areset          : in std_logic := '0';
                dataout         : out std_logic
                );

end stratixgx_hssi_tx_serdes;

architecture vital_tx_serdes_atom of stratixgx_hssi_tx_serdes is
   constant shift_edge : integer := channel_width / 2;
    signal indata : std_logic_vector(channel_width-1 downto 0);
    signal regdata : std_logic_vector(9 downto 0);
   signal clk_dly : std_logic;

begin
    ----------------------
    --  INPUT PATH DELAYs
    ----------------------
    
    -- for now assuming all timing done at top level

VITAL_clk0_dly: process (clk)  
begin
   clk_dly <= clk;
end process;

VITAL_clk0: process (clk_dly, clk1, areset)  

variable i : integer := 0;
variable dataout_tmp : std_logic;
variable pclk_count : integer := 0;
variable shiftdata : std_logic_vector(9 downto 0);
begin

    if (now = 0 ns) then
        dataout_tmp := '0';
      for i in 9 downto 0 loop --reset register
            regdata(i) <= '0';
            shiftdata(i) := '0';
        end loop;
   end if;

   ------------------------
   --  Timing Check Section
   ------------------------
    
    -- for now assuming all timing done at top level

   if (areset = '1') then
        dataout_tmp := 'Z';
      for i in 9 downto 0 loop --reset register
            regdata(i) <= 'Z';
            shiftdata(i) := 'Z';
        end loop;
   else
      if (clk_dly'event and clk_dly = '1') then
         pclk_count := pclk_count + 1;

         if (pclk_count = shift_edge) then
             shiftdata := regdata;  
         end if;
      end if;

      if (clk_dly'event) then
         -- loading parallel data
         if (pclk_count = 1) then
           for i in 9 downto 0 loop 
                regdata(i) <= datain(9 - i);
               end loop;
         end if;

         if (srlpbk = '1') then
            dataout_tmp := serialdatain;
         else
            dataout_tmp := shiftdata(9);
         end if;

         for i in 9 downto (10 - channel_width + 1) loop
                shiftdata(i) := shiftdata(i-1);
            end loop;
      end if;

      if (clk1'event and clk1 = '1') then  -- rising edge
         pclk_count := 0;
      end if;
   end if;

   ----------------------
   --  Path Delay Section
   ----------------------

    -- for now assuming all delays on top level module

    dataout <= dataout_tmp;
    
end process;

end vital_tx_serdes_atom;

--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

--synthesis_resources = lut 137 mux21 348 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixgx_xgm_rx_sm IS 
	 PORT 
	 ( 
		 resetall	:	IN  STD_LOGIC;
		 rxclk	:	IN  STD_LOGIC;
		 rxctrl	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rxctrlout	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rxdatain	:	IN  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 rxdataout	:	OUT  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 rxdatavalid	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 rxrunningdisp	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0)
	 ); 
 END stratixgx_xgm_rx_sm;

 ARCHITECTURE RTL OF stratixgx_xgm_rx_sm IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 nl00ll58	:	STD_LOGIC := '1';
	 SIGNAL	 nl00ll59	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl00ll59_w_lg_Q192w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl00ll60	:	STD_LOGIC := '0';
	 SIGNAL	 nl00OO55	:	STD_LOGIC := '1';
	 SIGNAL	 nl00OO56	:	STD_LOGIC := '1';
	 SIGNAL	 nl00OO57	:	STD_LOGIC := '0';
	 SIGNAL	 nl0i0i52	:	STD_LOGIC := '1';
	 SIGNAL	 nl0i0i53	:	STD_LOGIC := '1';
	 SIGNAL	 nl0i0i54	:	STD_LOGIC := '0';
	 SIGNAL	 nl0iil49	:	STD_LOGIC := '1';
	 SIGNAL	 nl0iil50	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0iil50_w_lg_Q174w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0iil51	:	STD_LOGIC := '0';
	 SIGNAL	 nl0ill46	:	STD_LOGIC := '1';
	 SIGNAL	 nl0ill47	:	STD_LOGIC := '1';
	 SIGNAL	 nl0ill48	:	STD_LOGIC := '0';
	 SIGNAL	 nl0iOl43	:	STD_LOGIC := '1';
	 SIGNAL	 nl0iOl44	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0iOl44_w_lg_Q164w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0iOl45	:	STD_LOGIC := '0';
	 SIGNAL	 nl0l0l37	:	STD_LOGIC := '1';
	 SIGNAL	 nl0l0l38	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0l0l38_w_lg_Q137w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0l0l39	:	STD_LOGIC := '0';
	 SIGNAL	 nl0l1i40	:	STD_LOGIC := '1';
	 SIGNAL	 nl0l1i41	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0l1i41_w_lg_Q159w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0l1i42	:	STD_LOGIC := '0';
	 SIGNAL	 nl0lil34	:	STD_LOGIC := '1';
	 SIGNAL	 nl0lil35	:	STD_LOGIC := '1';
	 SIGNAL	 nl0lil36	:	STD_LOGIC := '0';
	 SIGNAL	 nl0llO31	:	STD_LOGIC := '1';
	 SIGNAL	 nl0llO32	:	STD_LOGIC := '1';
	 SIGNAL	 nl0llO33	:	STD_LOGIC := '0';
	 SIGNAL	 nl0O1O28	:	STD_LOGIC := '1';
	 SIGNAL	 nl0O1O29	:	STD_LOGIC := '1';
	 SIGNAL	 nl0O1O30	:	STD_LOGIC := '0';
	 SIGNAL	 nl0Oii25	:	STD_LOGIC := '1';
	 SIGNAL	 nl0Oii26	:	STD_LOGIC := '1';
	 SIGNAL	 nl0Oii27	:	STD_LOGIC := '0';
	 SIGNAL	 nl0Oll22	:	STD_LOGIC := '1';
	 SIGNAL	 nl0Oll23	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0Oll23_w_lg_Q75w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0Oll24	:	STD_LOGIC := '0';
	 SIGNAL	 nli01i7	:	STD_LOGIC := '1';
	 SIGNAL	 nli01i8	:	STD_LOGIC := '1';
	 SIGNAL  wire_nli01i8_w_lg_Q29w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli01i9	:	STD_LOGIC := '0';
	 SIGNAL	 nli0ii4	:	STD_LOGIC := '1';
	 SIGNAL	 nli0ii5	:	STD_LOGIC := '1';
	 SIGNAL  wire_nli0ii5_w_lg_Q19w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli0ii6	:	STD_LOGIC := '0';
	 SIGNAL	 nli0Oi1	:	STD_LOGIC := '1';
	 SIGNAL	 nli0Oi2	:	STD_LOGIC := '1';
	 SIGNAL  wire_nli0Oi2_w_lg_Q7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli0Oi3	:	STD_LOGIC := '0';
	 SIGNAL	 nli10i16	:	STD_LOGIC := '1';
	 SIGNAL	 nli10i17	:	STD_LOGIC := '1';
	 SIGNAL  wire_nli10i17_w_lg_Q54w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli10i18	:	STD_LOGIC := '0';
	 SIGNAL	 nli10O13	:	STD_LOGIC := '1';
	 SIGNAL	 nli10O14	:	STD_LOGIC := '1';
	 SIGNAL  wire_nli10O14_w_lg_Q46w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli10O15	:	STD_LOGIC := '0';
	 SIGNAL	 nli11i19	:	STD_LOGIC := '1';
	 SIGNAL	 nli11i20	:	STD_LOGIC := '1';
	 SIGNAL  wire_nli11i20_w_lg_Q62w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli11i21	:	STD_LOGIC := '0';
	 SIGNAL	 nli1il10	:	STD_LOGIC := '1';
	 SIGNAL	 nli1il11	:	STD_LOGIC := '1';
	 SIGNAL  wire_nli1il11_w_lg_Q41w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli1il12	:	STD_LOGIC := '0';
	 SIGNAL	n011i	:	STD_LOGIC := '0';
	 SIGNAL	n0i0i	:	STD_LOGIC := '0';
	 SIGNAL	n0i0l	:	STD_LOGIC := '0';
	 SIGNAL	n0i0O	:	STD_LOGIC := '0';
	 SIGNAL	n0i1O	:	STD_LOGIC := '0';
	 SIGNAL	n0iii	:	STD_LOGIC := '0';
	 SIGNAL	n0iil	:	STD_LOGIC := '0';
	 SIGNAL	n0iiO	:	STD_LOGIC := '0';
	 SIGNAL	n100i	:	STD_LOGIC := '0';
	 SIGNAL	n100l	:	STD_LOGIC := '0';
	 SIGNAL	n100O	:	STD_LOGIC := '0';
	 SIGNAL	n101i	:	STD_LOGIC := '0';
	 SIGNAL	n101l	:	STD_LOGIC := '0';
	 SIGNAL	n101O	:	STD_LOGIC := '0';
	 SIGNAL	n10ii	:	STD_LOGIC := '0';
	 SIGNAL	n11i	:	STD_LOGIC := '0';
	 SIGNAL	n11l	:	STD_LOGIC := '0';
	 SIGNAL	n11Ol	:	STD_LOGIC := '0';
	 SIGNAL	n11OO	:	STD_LOGIC := '0';
	 SIGNAL	n1OlO	:	STD_LOGIC := '0';
	 SIGNAL	n1OOi	:	STD_LOGIC := '0';
	 SIGNAL	n1OOl	:	STD_LOGIC := '0';
	 SIGNAL	n1OOO	:	STD_LOGIC := '0';
	 SIGNAL	ni00l	:	STD_LOGIC := '0';
	 SIGNAL	ni00O	:	STD_LOGIC := '0';
	 SIGNAL	ni0ii	:	STD_LOGIC := '0';
	 SIGNAL	ni0il	:	STD_LOGIC := '0';
	 SIGNAL	ni0iO	:	STD_LOGIC := '0';
	 SIGNAL	ni0li	:	STD_LOGIC := '0';
	 SIGNAL	ni0ll	:	STD_LOGIC := '0';
	 SIGNAL	ni0lO	:	STD_LOGIC := '0';
	 SIGNAL	ni0Oi	:	STD_LOGIC := '0';
	 SIGNAL	niiO	:	STD_LOGIC := '0';
	 SIGNAL	nili	:	STD_LOGIC := '0';
	 SIGNAL	niOl	:	STD_LOGIC := '0';
	 SIGNAL	nl01i	:	STD_LOGIC := '0';
	 SIGNAL	nl01l	:	STD_LOGIC := '0';
	 SIGNAL	nl1i	:	STD_LOGIC := '0';
	 SIGNAL	nl1iO	:	STD_LOGIC := '0';
	 SIGNAL	nl1li	:	STD_LOGIC := '0';
	 SIGNAL	nl1ll	:	STD_LOGIC := '0';
	 SIGNAL	nl1lO	:	STD_LOGIC := '0';
	 SIGNAL	nl1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nl1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nl1OO	:	STD_LOGIC := '0';
	 SIGNAL	nllOli	:	STD_LOGIC := '0';
	 SIGNAL	nllOll	:	STD_LOGIC := '0';
	 SIGNAL	nllOlO	:	STD_LOGIC := '0';
	 SIGNAL	nllOOi	:	STD_LOGIC := '0';
	 SIGNAL	nllOOl	:	STD_LOGIC := '0';
	 SIGNAL	nllOOO	:	STD_LOGIC := '0';
	 SIGNAL	nlO11i	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOi0O	:	STD_LOGIC := '0';
	 SIGNAL	nlOi1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOi1O	:	STD_LOGIC := '0';
	 SIGNAL	nlOiii	:	STD_LOGIC := '0';
	 SIGNAL	nlOiil	:	STD_LOGIC := '0';
	 SIGNAL	nlOiiO	:	STD_LOGIC := '0';
	 SIGNAL	nlOili	:	STD_LOGIC := '0';
	 SIGNAL	nlOOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOOO	:	STD_LOGIC := '0';
	 SIGNAL  wire_niOO_w_lg_w_lg_niOl156w160w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_niiO161w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOO_w_lg_niOl156w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlllll	:	STD_LOGIC := '0';
	 SIGNAL	nllllO	:	STD_LOGIC := '0';
	 SIGNAL	nlllOi	:	STD_LOGIC := '0';
	 SIGNAL	nlllOl	:	STD_LOGIC := '0';
	 SIGNAL	nlllOO	:	STD_LOGIC := '0';
	 SIGNAL	nllO0i	:	STD_LOGIC := '0';
	 SIGNAL	nllO0l	:	STD_LOGIC := '0';
	 SIGNAL	nllO0O	:	STD_LOGIC := '0';
	 SIGNAL	nllO1i	:	STD_LOGIC := '0';
	 SIGNAL	nllO1l	:	STD_LOGIC := '0';
	 SIGNAL	nllO1O	:	STD_LOGIC := '0';
	 SIGNAL	nllOii	:	STD_LOGIC := '0';
	 SIGNAL	nllOiO	:	STD_LOGIC := '0';
	 SIGNAL	wire_n000i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n000l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n000O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n001O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n011O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n110O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n111i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0i_w_lg_dataout91w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nl0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl0l_w_lg_dataout111w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nl0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1l_w_lg_dataout79w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nl1O_w_lg_dataout85w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nli0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nll1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_w_lg_w_lg_w_rxctrl_range9w86w89w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_rxctrl_range21w112w115w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxctrl_range1w80w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxctrl_range9w86w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxctrl_range13w92w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxctrl_range21w112w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxdatain_range124w301w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxdatain_range146w315w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxdatain_range155w322w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxdatain_range133w308w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0lll110w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0Oli109w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0OOi70w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0OOl67w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl0OOO64w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli00l23w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli01O25w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0iO15w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0ll11w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli11O58w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1li37w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1lO33w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1Ol31w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlii1l3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_resetall98w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxdatain_range145w254w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxdatain_range123w234w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxdatain_range154w264w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_rxdatain_range132w244w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nli0lO49w50w51w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nli0lO49w50w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nli1OO35w36w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli0lO49w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nli1OO35w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nl00iO :	STD_LOGIC;
	 SIGNAL  nl00li :	STD_LOGIC;
	 SIGNAL  nl00Oi :	STD_LOGIC;
	 SIGNAL  nl00Ol :	STD_LOGIC;
	 SIGNAL  nl0i0O :	STD_LOGIC;
	 SIGNAL  nl0i1l :	STD_LOGIC;
	 SIGNAL  nl0i1O :	STD_LOGIC;
	 SIGNAL  nl0iii :	STD_LOGIC;
	 SIGNAL  nl0ili :	STD_LOGIC;
	 SIGNAL  nl0iOi :	STD_LOGIC;
	 SIGNAL  nl0l0i :	STD_LOGIC;
	 SIGNAL  nl0l1O :	STD_LOGIC;
	 SIGNAL  nl0lii :	STD_LOGIC;
	 SIGNAL  nl0lli :	STD_LOGIC;
	 SIGNAL  nl0lll :	STD_LOGIC;
	 SIGNAL  nl0lOl :	STD_LOGIC;
	 SIGNAL  nl0lOO :	STD_LOGIC;
	 SIGNAL  nl0O0l :	STD_LOGIC;
	 SIGNAL  nl0O0O :	STD_LOGIC;
	 SIGNAL  nl0O1i :	STD_LOGIC;
	 SIGNAL  nl0O1l :	STD_LOGIC;
	 SIGNAL  nl0OiO :	STD_LOGIC;
	 SIGNAL  nl0Oli :	STD_LOGIC;
	 SIGNAL  nl0OOi :	STD_LOGIC;
	 SIGNAL  nl0OOl :	STD_LOGIC;
	 SIGNAL  nl0OOO :	STD_LOGIC;
	 SIGNAL  nli00i :	STD_LOGIC;
	 SIGNAL  nli00l :	STD_LOGIC;
	 SIGNAL  nli00O :	STD_LOGIC;
	 SIGNAL  nli01O :	STD_LOGIC;
	 SIGNAL  nli0iO :	STD_LOGIC;
	 SIGNAL  nli0li :	STD_LOGIC;
	 SIGNAL  nli0ll :	STD_LOGIC;
	 SIGNAL  nli0lO :	STD_LOGIC;
	 SIGNAL  nli11O :	STD_LOGIC;
	 SIGNAL  nli1li :	STD_LOGIC;
	 SIGNAL  nli1ll :	STD_LOGIC;
	 SIGNAL  nli1lO :	STD_LOGIC;
	 SIGNAL  nli1Oi :	STD_LOGIC;
	 SIGNAL  nli1Ol :	STD_LOGIC;
	 SIGNAL  nli1OO :	STD_LOGIC;
	 SIGNAL  nlii1l :	STD_LOGIC;
	 SIGNAL  wire_w_rxctrl_range1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxctrl_range9w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxctrl_range13w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxctrl_range21w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxdatain_range124w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxdatain_range146w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxdatain_range145w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxdatain_range123w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxdatain_range155w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxdatain_range154w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxdatain_range133w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_rxdatain_range132w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_w_lg_w_lg_w_rxctrl_range9w86w89w(0) <= wire_w_lg_w_rxctrl_range9w86w(0) AND nl0O1O29;
	wire_w_lg_w_lg_w_rxctrl_range21w112w115w(0) <= wire_w_lg_w_rxctrl_range21w112w(0) AND nl0lil35;
	wire_w_lg_w_rxctrl_range1w80w(0) <= wire_w_rxctrl_range1w(0) AND nl0OiO;
	wire_w_lg_w_rxctrl_range9w86w(0) <= wire_w_rxctrl_range9w(0) AND nl0O0l;
	wire_w_lg_w_rxctrl_range13w92w(0) <= wire_w_rxctrl_range13w(0) AND nl0O1i;
	wire_w_lg_w_rxctrl_range21w112w(0) <= wire_w_rxctrl_range21w(0) AND nl0lli;
	wire_w_lg_w_rxdatain_range124w301w(0) <= wire_w_rxdatain_range124w(0) AND wire_w_lg_w_rxdatain_range123w234w(0);
	wire_w_lg_w_rxdatain_range146w315w(0) <= wire_w_rxdatain_range146w(0) AND wire_w_lg_w_rxdatain_range145w254w(0);
	wire_w_lg_w_rxdatain_range155w322w(0) <= wire_w_rxdatain_range155w(0) AND wire_w_lg_w_rxdatain_range154w264w(0);
	wire_w_lg_w_rxdatain_range133w308w(0) <= wire_w_rxdatain_range133w(0) AND wire_w_lg_w_rxdatain_range132w244w(0);
	wire_w_lg_nl0lll110w(0) <= NOT nl0lll;
	wire_w_lg_nl0Oli109w(0) <= NOT nl0Oli;
	wire_w_lg_nl0OOi70w(0) <= NOT nl0OOi;
	wire_w_lg_nl0OOl67w(0) <= NOT nl0OOl;
	wire_w_lg_nl0OOO64w(0) <= NOT nl0OOO;
	wire_w_lg_nli00l23w(0) <= NOT nli00l;
	wire_w_lg_nli01O25w(0) <= NOT nli01O;
	wire_w_lg_nli0iO15w(0) <= NOT nli0iO;
	wire_w_lg_nli0ll11w(0) <= NOT nli0ll;
	wire_w_lg_nli11O58w(0) <= NOT nli11O;
	wire_w_lg_nli1li37w(0) <= NOT nli1li;
	wire_w_lg_nli1lO33w(0) <= NOT nli1lO;
	wire_w_lg_nli1Ol31w(0) <= NOT nli1Ol;
	wire_w_lg_nlii1l3w(0) <= NOT nlii1l;
	wire_w_lg_resetall98w(0) <= NOT resetall;
	wire_w_lg_w_rxdatain_range145w254w(0) <= NOT wire_w_rxdatain_range145w(0);
	wire_w_lg_w_rxdatain_range123w234w(0) <= NOT wire_w_rxdatain_range123w(0);
	wire_w_lg_w_rxdatain_range154w264w(0) <= NOT wire_w_rxdatain_range154w(0);
	wire_w_lg_w_rxdatain_range132w244w(0) <= NOT wire_w_rxdatain_range132w(0);
	wire_w_lg_w_lg_w_lg_nli0lO49w50w51w(0) <= wire_w_lg_w_lg_nli0lO49w50w(0) OR nli00i;
	wire_w_lg_w_lg_nli0lO49w50w(0) <= wire_w_lg_nli0lO49w(0) OR nli00O;
	wire_w_lg_w_lg_nli1OO35w36w(0) <= wire_w_lg_nli1OO35w(0) OR nli1ll;
	wire_w_lg_nli0lO49w(0) <= nli0lO OR nli0li;
	wire_w_lg_nli1OO35w(0) <= nli1OO OR nli1Oi;
	nl00iO <= (nli00i OR wire_nl0l_dataout);
	nl00li <= ((nl00Oi OR nl0lOO) OR wire_nl00ll59_w_lg_Q192w(0));
	nl00Oi <= (nl0O0O OR nl0O1l);
	nl00Ol <= (wire_nl0i_dataout OR ((nli1ll AND nli00O) AND nl00OO56));
	nl0i0O <= (niiO OR nili);
	nl0i1l <= (wire_nl0i_dataout OR nli00O);
	nl0i1O <= (wire_nl1O_dataout OR ((nli1Oi AND nli0li) AND nl0i0i53));
	nl0iii <= ((wire_nl1O_dataout OR nli0li) OR wire_nl0iil50_w_lg_Q174w(0));
	nl0ili <= (wire_nl1l_dataout OR ((nli1OO AND nli0lO) AND nl0ill47));
	nl0iOi <= (wire_niOO_w_lg_niiO161w(0) OR wire_nl0iOl44_w_lg_Q164w(0));
	nl0l0i <= ((nl0O1l OR nl0lii) OR wire_nl0l0l38_w_lg_Q137w(0));
	nl0l1O <= (nl0lOO OR nl0l0i);
	nl0lii <= (nl0O0O OR nl0Oli);
	nl0lli <= ((((((wire_w_lg_w_rxdatain_range155w322w(0) AND rxdatain(26)) AND rxdatain(27)) AND rxdatain(28)) AND rxdatain(29)) AND rxdatain(30)) AND rxdatain(31));
	nl0lll <= ((((rxdatavalid(3) AND rxdatavalid(2)) AND rxdatavalid(1)) AND rxdatavalid(0)) AND nl0llO32);
	nl0lOl <= '1';
	nl0lOO <= (wire_nl0i_w_lg_dataout91w(0) AND wire_w_lg_w_rxctrl_range13w92w(0));
	nl0O0l <= ((((((wire_w_lg_w_rxdatain_range133w308w(0) AND rxdatain(10)) AND rxdatain(11)) AND rxdatain(12)) AND rxdatain(13)) AND rxdatain(14)) AND rxdatain(15));
	nl0O0O <= ((wire_nl1l_w_lg_dataout79w(0) AND wire_w_lg_w_rxctrl_range1w80w(0)) AND nl0Oii26);
	nl0O1i <= ((((((wire_w_lg_w_rxdatain_range146w315w(0) AND rxdatain(18)) AND rxdatain(19)) AND rxdatain(20)) AND rxdatain(21)) AND rxdatain(22)) AND rxdatain(23));
	nl0O1l <= (wire_nl1O_w_lg_dataout85w(0) AND wire_w_lg_w_lg_w_rxctrl_range9w86w89w(0));
	nl0OiO <= ((((((wire_w_lg_w_rxdatain_range124w301w(0) AND rxdatain(2)) AND rxdatain(3)) AND rxdatain(4)) AND rxdatain(5)) AND rxdatain(6)) AND rxdatain(7));
	nl0Oli <= (((NOT ((wire_w_lg_w_lg_nli1OO35w36w(0) OR (((NOT rxctrl(3)) OR wire_w_lg_nli1li37w(0)) OR wire_nli1il11_w_lg_Q41w(0))) OR wire_nli10O14_w_lg_Q46w(0))) OR (NOT (wire_w_lg_w_lg_w_lg_nli0lO49w50w51w(0) OR wire_nli10i17_w_lg_Q54w(0)))) OR (NOT (((((((NOT rxctrl(3)) OR wire_w_lg_nli11O58w(0)) OR wire_nli11i20_w_lg_Q62w(0)) OR ((NOT rxctrl(2)) OR wire_w_lg_nl0OOO64w(0))) OR ((NOT rxctrl(1)) OR wire_w_lg_nl0OOl67w(0))) OR ((NOT rxctrl(0)) OR wire_w_lg_nl0OOi70w(0))) OR wire_nl0Oll23_w_lg_Q75w(0))));
	nl0OOi <= ((((((((NOT rxdatain(0)) AND wire_w_lg_w_rxdatain_range123w234w(0)) AND rxdatain(2)) AND rxdatain(3)) AND rxdatain(4)) AND (NOT rxdatain(5))) AND (NOT rxdatain(6))) AND (NOT rxdatain(7)));
	nl0OOl <= ((((((((NOT rxdatain(8)) AND wire_w_lg_w_rxdatain_range132w244w(0)) AND rxdatain(10)) AND rxdatain(11)) AND rxdatain(12)) AND (NOT rxdatain(13))) AND (NOT rxdatain(14))) AND (NOT rxdatain(15)));
	nl0OOO <= ((((((((NOT rxdatain(16)) AND wire_w_lg_w_rxdatain_range145w254w(0)) AND rxdatain(18)) AND rxdatain(19)) AND rxdatain(20)) AND (NOT rxdatain(21))) AND (NOT rxdatain(22))) AND (NOT rxdatain(23)));
	nli00i <= ((NOT rxctrl(3)) OR wire_w_lg_nli00l23w(0));
	nli00l <= ((((((((NOT rxdatain(24)) AND wire_w_lg_w_rxdatain_range154w264w(0)) AND rxdatain(26)) AND rxdatain(27)) AND rxdatain(28)) AND rxdatain(29)) AND (NOT rxdatain(30))) AND rxdatain(31));
	nli00O <= (((NOT rxctrl(2)) OR wire_w_lg_nli0iO15w(0)) OR wire_nli0ii5_w_lg_Q19w(0));
	nli01O <= ((((((((NOT rxdatain(0)) AND wire_w_lg_w_rxdatain_range123w234w(0)) AND rxdatain(2)) AND rxdatain(3)) AND rxdatain(4)) AND rxdatain(5)) AND rxdatain(6)) AND (NOT rxdatain(7)));
	nli0iO <= ((((((((NOT rxdatain(16)) AND wire_w_lg_w_rxdatain_range145w254w(0)) AND rxdatain(18)) AND rxdatain(19)) AND rxdatain(20)) AND rxdatain(21)) AND (NOT rxdatain(22))) AND rxdatain(23));
	nli0li <= ((NOT rxctrl(1)) OR wire_w_lg_nli0ll11w(0));
	nli0ll <= ((((((((NOT rxdatain(8)) AND wire_w_lg_w_rxdatain_range132w244w(0)) AND rxdatain(10)) AND rxdatain(11)) AND rxdatain(12)) AND rxdatain(13)) AND (NOT rxdatain(14))) AND rxdatain(15));
	nli0lO <= (((NOT rxctrl(0)) OR wire_w_lg_nlii1l3w(0)) OR wire_nli0Oi2_w_lg_Q7w(0));
	nli11O <= ((((((((NOT rxdatain(24)) AND wire_w_lg_w_rxdatain_range154w264w(0)) AND rxdatain(26)) AND rxdatain(27)) AND rxdatain(28)) AND (NOT rxdatain(29))) AND (NOT rxdatain(30))) AND (NOT rxdatain(31)));
	nli1li <= ((((((((NOT rxdatain(24)) AND wire_w_lg_w_rxdatain_range154w264w(0)) AND rxdatain(26)) AND rxdatain(27)) AND rxdatain(28)) AND rxdatain(29)) AND rxdatain(30)) AND (NOT rxdatain(31)));
	nli1ll <= ((NOT rxctrl(2)) OR wire_w_lg_nli1lO33w(0));
	nli1lO <= ((((((((NOT rxdatain(16)) AND wire_w_lg_w_rxdatain_range145w254w(0)) AND rxdatain(18)) AND rxdatain(19)) AND rxdatain(20)) AND rxdatain(21)) AND rxdatain(22)) AND (NOT rxdatain(23)));
	nli1Oi <= ((NOT rxctrl(1)) OR wire_w_lg_nli1Ol31w(0));
	nli1Ol <= ((((((((NOT rxdatain(8)) AND wire_w_lg_w_rxdatain_range132w244w(0)) AND rxdatain(10)) AND rxdatain(11)) AND rxdatain(12)) AND rxdatain(13)) AND rxdatain(14)) AND (NOT rxdatain(15)));
	nli1OO <= (((NOT rxctrl(0)) OR wire_w_lg_nli01O25w(0)) OR wire_nli01i8_w_lg_Q29w(0));
	nlii1l <= ((((((((NOT rxdatain(0)) AND wire_w_lg_w_rxdatain_range123w234w(0)) AND rxdatain(2)) AND rxdatain(3)) AND rxdatain(4)) AND rxdatain(5)) AND (NOT rxdatain(6))) AND rxdatain(7));
	rxctrlout <= ( nllOli & nlOi1O & n11OO & nllllO);
	rxdataout <= ( nlOi1l & nlO11i & nllOOO & nllOOl & nllOOi & nllOlO & nllOll & nlllll & n11Ol & nlOili & nlOiiO & nlOiil & nlOiii & nlOi0O & nlOi0l & nlOi0i & n1OlO & n10ii & n100O & n100l & n100i & n101O & n101l & n101i & nllO1i & n011i & n1OOO & nlllOO & nlllOl & nlllOi & n1OOl & n1OOi);
	wire_w_rxctrl_range1w(0) <= rxctrl(0);
	wire_w_rxctrl_range9w(0) <= rxctrl(1);
	wire_w_rxctrl_range13w(0) <= rxctrl(2);
	wire_w_rxctrl_range21w(0) <= rxctrl(3);
	wire_w_rxdatain_range124w(0) <= rxdatain(0);
	wire_w_rxdatain_range146w(0) <= rxdatain(16);
	wire_w_rxdatain_range145w(0) <= rxdatain(17);
	wire_w_rxdatain_range123w(0) <= rxdatain(1);
	wire_w_rxdatain_range155w(0) <= rxdatain(24);
	wire_w_rxdatain_range154w(0) <= rxdatain(25);
	wire_w_rxdatain_range133w(0) <= rxdatain(8);
	wire_w_rxdatain_range132w(0) <= rxdatain(9);
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl00ll58 <= nl00ll60;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl00ll59 <= (nl00ll60 XOR nl00ll58);
		END IF;
	END PROCESS;
	wire_nl00ll59_w_lg_Q192w(0) <= NOT nl00ll59;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl00ll60 <= nl00ll58;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl00OO55 <= nl00OO57;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl00OO56 <= (nl00OO57 XOR nl00OO55);
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl00OO57 <= nl00OO55;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0i0i52 <= nl0i0i54;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0i0i53 <= (nl0i0i54 XOR nl0i0i52);
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0i0i54 <= nl0i0i52;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0iil49 <= nl0iil51;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0iil50 <= (nl0iil51 XOR nl0iil49);
		END IF;
	END PROCESS;
	wire_nl0iil50_w_lg_Q174w(0) <= NOT nl0iil50;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0iil51 <= nl0iil49;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0ill46 <= nl0ill48;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0ill47 <= (nl0ill48 XOR nl0ill46);
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0ill48 <= nl0ill46;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0iOl43 <= nl0iOl45;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0iOl44 <= (nl0iOl45 XOR nl0iOl43);
		END IF;
	END PROCESS;
	wire_nl0iOl44_w_lg_Q164w(0) <= NOT nl0iOl44;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0iOl45 <= nl0iOl43;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0l0l37 <= nl0l0l39;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0l0l38 <= (nl0l0l39 XOR nl0l0l37);
		END IF;
	END PROCESS;
	wire_nl0l0l38_w_lg_Q137w(0) <= NOT nl0l0l38;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0l0l39 <= nl0l0l37;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0l1i40 <= nl0l1i42;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0l1i41 <= (nl0l1i42 XOR nl0l1i40);
		END IF;
	END PROCESS;
	wire_nl0l1i41_w_lg_Q159w(0) <= NOT nl0l1i41;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0l1i42 <= nl0l1i40;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0lil34 <= nl0lil36;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0lil35 <= (nl0lil36 XOR nl0lil34);
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0lil36 <= nl0lil34;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0llO31 <= nl0llO33;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0llO32 <= (nl0llO33 XOR nl0llO31);
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0llO33 <= nl0llO31;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0O1O28 <= nl0O1O30;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0O1O29 <= (nl0O1O30 XOR nl0O1O28);
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0O1O30 <= nl0O1O28;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0Oii25 <= nl0Oii27;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0Oii26 <= (nl0Oii27 XOR nl0Oii25);
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0Oii27 <= nl0Oii25;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0Oll22 <= nl0Oll24;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0Oll23 <= (nl0Oll24 XOR nl0Oll22);
		END IF;
	END PROCESS;
	wire_nl0Oll23_w_lg_Q75w(0) <= NOT nl0Oll23;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nl0Oll24 <= nl0Oll22;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli01i7 <= nli01i9;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli01i8 <= (nli01i9 XOR nli01i7);
		END IF;
	END PROCESS;
	wire_nli01i8_w_lg_Q29w(0) <= NOT nli01i8;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli01i9 <= nli01i7;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli0ii4 <= nli0ii6;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli0ii5 <= (nli0ii6 XOR nli0ii4);
		END IF;
	END PROCESS;
	wire_nli0ii5_w_lg_Q19w(0) <= NOT nli0ii5;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli0ii6 <= nli0ii4;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli0Oi1 <= nli0Oi3;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli0Oi2 <= (nli0Oi3 XOR nli0Oi1);
		END IF;
	END PROCESS;
	wire_nli0Oi2_w_lg_Q7w(0) <= NOT nli0Oi2;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli0Oi3 <= nli0Oi1;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli10i16 <= nli10i18;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli10i17 <= (nli10i18 XOR nli10i16);
		END IF;
	END PROCESS;
	wire_nli10i17_w_lg_Q54w(0) <= NOT nli10i17;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli10i18 <= nli10i16;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli10O13 <= nli10O15;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli10O14 <= (nli10O15 XOR nli10O13);
		END IF;
	END PROCESS;
	wire_nli10O14_w_lg_Q46w(0) <= NOT nli10O14;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli10O15 <= nli10O13;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli11i19 <= nli11i21;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli11i20 <= (nli11i21 XOR nli11i19);
		END IF;
	END PROCESS;
	wire_nli11i20_w_lg_Q62w(0) <= NOT nli11i20;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli11i21 <= nli11i19;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli1il10 <= nli1il12;
		END IF;
	END PROCESS;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli1il11 <= (nli1il12 XOR nli1il10);
		END IF;
	END PROCESS;
	wire_nli1il11_w_lg_Q41w(0) <= NOT nli1il11;
	PROCESS (rxclk)
	BEGIN
		IF (rxclk = '1' AND rxclk'event) THEN nli1il12 <= nli1il10;
		END IF;
	END PROCESS;
	PROCESS (rxclk, resetall)
	BEGIN
		IF (resetall = '1') THEN
				n011i <= '0';
				n0i0i <= '0';
				n0i0l <= '0';
				n0i0O <= '0';
				n0i1O <= '0';
				n0iii <= '0';
				n0iil <= '0';
				n0iiO <= '0';
				n100i <= '0';
				n100l <= '0';
				n100O <= '0';
				n101i <= '0';
				n101l <= '0';
				n101O <= '0';
				n10ii <= '0';
				n11i <= '0';
				n11l <= '0';
				n11Ol <= '0';
				n11OO <= '0';
				n1OlO <= '0';
				n1OOi <= '0';
				n1OOl <= '0';
				n1OOO <= '0';
				ni00l <= '0';
				ni00O <= '0';
				ni0ii <= '0';
				ni0il <= '0';
				ni0iO <= '0';
				ni0li <= '0';
				ni0ll <= '0';
				ni0lO <= '0';
				ni0Oi <= '0';
				niiO <= '0';
				nili <= '0';
				niOl <= '0';
				nl01i <= '0';
				nl01l <= '0';
				nl1i <= '0';
				nl1iO <= '0';
				nl1li <= '0';
				nl1ll <= '0';
				nl1lO <= '0';
				nl1Oi <= '0';
				nl1Ol <= '0';
				nl1OO <= '0';
				nllOli <= '0';
				nllOll <= '0';
				nllOlO <= '0';
				nllOOi <= '0';
				nllOOl <= '0';
				nllOOO <= '0';
				nlO11i <= '0';
				nlOi0i <= '0';
				nlOi0l <= '0';
				nlOi0O <= '0';
				nlOi1l <= '0';
				nlOi1O <= '0';
				nlOiii <= '0';
				nlOiil <= '0';
				nlOiiO <= '0';
				nlOili <= '0';
				nlOOi <= '0';
				nlOOl <= '0';
				nlOOO <= '0';
		ELSIF (rxclk = '1' AND rxclk'event) THEN
				n011i <= wire_n01iO_dataout;
				n0i0i <= wire_n0ilO_dataout;
				n0i0l <= wire_n0iOi_dataout;
				n0i0O <= wire_n0iOl_dataout;
				n0i1O <= wire_n0ili_dataout;
				n0iii <= wire_n0iOO_dataout;
				n0iil <= wire_n0l1i_dataout;
				n0iiO <= wire_n0l1l_dataout;
				n100i <= wire_n10lO_dataout;
				n100l <= wire_n10Oi_dataout;
				n100O <= wire_n10Ol_dataout;
				n101i <= wire_n10iO_dataout;
				n101l <= wire_n10li_dataout;
				n101O <= wire_n10ll_dataout;
				n10ii <= wire_n10OO_dataout;
				n11i <= wire_n1iO_dataout;
				n11l <= wire_n1li_dataout;
				n11Ol <= wire_nlOl0i_dataout;
				n11OO <= wire_n10il_dataout;
				n1OlO <= wire_n1i1i_dataout;
				n1OOi <= wire_n011O_dataout;
				n1OOl <= wire_n010i_dataout;
				n1OOO <= wire_n01il_dataout;
				ni00l <= wire_n0l1O_dataout;
				ni00O <= wire_ni0Ol_dataout;
				ni0ii <= wire_ni0OO_dataout;
				ni0il <= wire_nii1i_dataout;
				ni0iO <= wire_nii1l_dataout;
				ni0li <= wire_nii1O_dataout;
				ni0ll <= wire_nii0i_dataout;
				ni0lO <= wire_nii0l_dataout;
				ni0Oi <= wire_nii0O_dataout;
				niiO <= (wire_nl0l_w_lg_dataout111w(0) AND wire_w_lg_w_lg_w_rxctrl_range21w112w115w(0));
				nili <= nl0lOO;
				niOl <= nl0O1l;
				nl01i <= wire_nl0iO_dataout;
				nl01l <= wire_nl0li_dataout;
				nl1i <= wire_nilO_dataout;
				nl1iO <= wire_niiii_dataout;
				nl1li <= wire_nl01O_dataout;
				nl1ll <= wire_nl00i_dataout;
				nl1lO <= wire_nl00l_dataout;
				nl1Oi <= wire_nl00O_dataout;
				nl1Ol <= wire_nl0ii_dataout;
				nl1OO <= wire_nl0il_dataout;
				nllOli <= wire_nlO11l_dataout;
				nllOll <= wire_nlO10i_dataout;
				nllOlO <= wire_nlO10l_dataout;
				nllOOi <= wire_nlO10O_dataout;
				nllOOl <= wire_nlO1ii_dataout;
				nllOOO <= wire_nlO1il_dataout;
				nlO11i <= wire_nlO1iO_dataout;
				nlOi0i <= wire_nlOilO_dataout;
				nlOi0l <= wire_nlOiOi_dataout;
				nlOi0O <= wire_nlOiOl_dataout;
				nlOi1l <= wire_nlO1li_dataout;
				nlOi1O <= wire_nlOill_dataout;
				nlOiii <= wire_nlOiOO_dataout;
				nlOiil <= wire_nlOl1i_dataout;
				nlOiiO <= wire_nlOl1l_dataout;
				nlOili <= wire_nlOl1O_dataout;
				nlOOi <= wire_nl0ll_dataout;
				nlOOl <= wire_n10i_dataout;
				nlOOO <= wire_n10l_dataout;
		END IF;
	END PROCESS;
	wire_niOO_w_lg_w_lg_niOl156w160w(0) <= wire_niOO_w_lg_niOl156w(0) OR wire_nl0l1i41_w_lg_Q159w(0);
	wire_niOO_w_lg_niiO161w(0) <= niiO OR wire_niOO_w_lg_w_lg_niOl156w160w(0);
	wire_niOO_w_lg_niOl156w(0) <= niOl OR nili;
	PROCESS (rxclk, resetall)
	BEGIN
		IF (resetall = '1') THEN
				nlllll <= '1';
				nllllO <= '1';
				nlllOi <= '1';
				nlllOl <= '1';
				nlllOO <= '1';
				nllO0i <= '1';
				nllO0l <= '1';
				nllO0O <= '1';
				nllO1i <= '1';
				nllO1l <= '1';
				nllO1O <= '1';
				nllOii <= '1';
				nllOiO <= '1';
		ELSIF (rxclk = '1' AND rxclk'event) THEN
				nlllll <= wire_nlO11O_dataout;
				nllllO <= wire_n011l_dataout;
				nlllOi <= wire_n010l_dataout;
				nlllOl <= wire_n010O_dataout;
				nlllOO <= wire_n01ii_dataout;
				nllO0i <= wire_n10O_dataout;
				nllO0l <= wire_n1ii_dataout;
				nllO0O <= wire_n1il_dataout;
				nllO1i <= wire_n01li_dataout;
				nllO1l <= wire_n0ill_dataout;
				nllO1O <= wire_n11O_dataout;
				nllOii <= wire_n1ll_dataout;
				nllOiO <= wire_w_lg_nl0lll110w(0);
		END IF;
	END PROCESS;
	wire_n000i_dataout <= wire_n00Oi_dataout WHEN nl0iOi = '1'  ELSE nllOii;
	wire_n000l_dataout <= nllO1O OR nl0ili;
	wire_n000O_dataout <= nlOOl AND NOT(nl0ili);
	wire_n001i_dataout <= wire_n00li_dataout WHEN nl0iOi = '1'  ELSE nllO0O;
	wire_n001l_dataout <= wire_n00ll_dataout WHEN nl0iOi = '1'  ELSE n11i;
	wire_n001O_dataout <= wire_n00lO_dataout WHEN nl0iOi = '1'  ELSE n11l;
	wire_n00i_dataout <= wire_n0Oi_dataout AND NOT(wire_nill_dataout);
	wire_n00ii_dataout <= nlOOO OR nl0ili;
	wire_n00il_dataout <= nllO0i OR nl0ili;
	wire_n00iO_dataout <= nllO0l OR nl0ili;
	wire_n00l_dataout <= wire_n0Ol_dataout AND NOT(wire_nill_dataout);
	wire_n00li_dataout <= nllO0O OR nl0ili;
	wire_n00ll_dataout <= n11i OR nl0ili;
	wire_n00lO_dataout <= n11l OR nl0ili;
	wire_n00O_dataout <= rxctrl(0) WHEN nl0O0O = '1'  ELSE wire_n0OO_dataout;
	wire_n00Oi_dataout <= nllOii OR nl0ili;
	wire_n010i_dataout <= wire_n01Oi_dataout AND NOT(nllOiO);
	wire_n010l_dataout <= wire_n01Ol_dataout OR nllOiO;
	wire_n010O_dataout <= wire_n01OO_dataout OR nllOiO;
	wire_n011l_dataout <= wire_n01ll_dataout OR nllOiO;
	wire_n011O_dataout <= wire_n01lO_dataout AND NOT(nllOiO);
	wire_n01i_dataout <= wire_n0li_dataout AND NOT(wire_nill_dataout);
	wire_n01ii_dataout <= wire_n001i_dataout OR nllOiO;
	wire_n01il_dataout <= wire_n001l_dataout AND NOT(nllOiO);
	wire_n01iO_dataout <= wire_n001O_dataout AND NOT(nllOiO);
	wire_n01l_dataout <= wire_n0ll_dataout AND NOT(wire_nill_dataout);
	wire_n01li_dataout <= wire_n000i_dataout OR nllOiO;
	wire_n01ll_dataout <= wire_n000l_dataout WHEN nl0iOi = '1'  ELSE nllO1O;
	wire_n01lO_dataout <= wire_n000O_dataout WHEN nl0iOi = '1'  ELSE nlOOl;
	wire_n01O_dataout <= wire_n0lO_dataout AND NOT(wire_nill_dataout);
	wire_n01Oi_dataout <= wire_n00ii_dataout WHEN nl0iOi = '1'  ELSE nlOOO;
	wire_n01Ol_dataout <= wire_n00il_dataout WHEN nl0iOi = '1'  ELSE nllO0i;
	wire_n01OO_dataout <= wire_n00iO_dataout WHEN nl0iOi = '1'  ELSE nllO0l;
	wire_n0ii_dataout <= rxdatain(0) WHEN nl0O0O = '1'  ELSE wire_ni1i_dataout;
	wire_n0il_dataout <= rxdatain(1) WHEN nl0O0O = '1'  ELSE wire_ni1l_dataout;
	wire_n0ili_dataout <= wire_ni11i_dataout WHEN nl1i = '1'  ELSE wire_n0llO_dataout;
	wire_n0ill_dataout <= wire_ni11l_dataout WHEN nl1i = '1'  ELSE wire_n0l0i_dataout;
	wire_n0ilO_dataout <= wire_ni11O_dataout WHEN nl1i = '1'  ELSE wire_n0l0l_dataout;
	wire_n0iO_dataout <= rxdatain(2) WHEN nl0O0O = '1'  ELSE wire_ni1O_dataout;
	wire_n0iOi_dataout <= wire_ni10i_dataout WHEN nl1i = '1'  ELSE wire_n0l0O_dataout;
	wire_n0iOl_dataout <= wire_ni10l_dataout WHEN nl1i = '1'  ELSE wire_n0lii_dataout;
	wire_n0iOO_dataout <= wire_ni10O_dataout WHEN nl1i = '1'  ELSE wire_n0lil_dataout;
	wire_n0l0i_dataout <= wire_n0lOl_dataout OR wire_w_lg_nl0lll110w(0);
	wire_n0l0l_dataout <= wire_n0lOO_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_n0l0O_dataout <= wire_n0O1i_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_n0l1i_dataout <= wire_ni1ii_dataout WHEN nl1i = '1'  ELSE wire_n0liO_dataout;
	wire_n0l1l_dataout <= wire_ni1il_dataout WHEN nl1i = '1'  ELSE wire_n0lli_dataout;
	wire_n0l1O_dataout <= wire_ni1iO_dataout WHEN nl1i = '1'  ELSE wire_n0lll_dataout;
	wire_n0li_dataout <= rxdatain(3) WHEN nl0O0O = '1'  ELSE wire_ni0i_dataout;
	wire_n0lii_dataout <= wire_n0O1l_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_n0lil_dataout <= wire_n0O1O_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_n0liO_dataout <= wire_n0O0i_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_n0ll_dataout <= rxdatain(4) WHEN nl0O0O = '1'  ELSE wire_ni0l_dataout;
	wire_n0lli_dataout <= wire_n0O0l_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_n0lll_dataout <= wire_n0O0O_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_n0llO_dataout <= wire_n0lOi_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_n0lO_dataout <= rxdatain(5) WHEN nl0O0O = '1'  ELSE wire_ni0O_dataout;
	wire_n0lOi_dataout <= wire_n0Oii_dataout OR nl0Oli;
	wire_n0lOl_dataout <= wire_n0Oil_dataout OR nl0Oli;
	wire_n0lOO_dataout <= wire_n0OiO_dataout OR nl0Oli;
	wire_n0O0i_dataout <= wire_n0OOi_dataout AND NOT(nl0Oli);
	wire_n0O0l_dataout <= wire_n0OOl_dataout AND NOT(nl0Oli);
	wire_n0O0O_dataout <= wire_n0OOO_dataout AND NOT(nl0Oli);
	wire_n0O1i_dataout <= wire_n0Oli_dataout OR nl0Oli;
	wire_n0O1l_dataout <= wire_n0Oll_dataout AND NOT(nl0Oli);
	wire_n0O1O_dataout <= wire_n0OlO_dataout AND NOT(nl0Oli);
	wire_n0Oi_dataout <= rxdatain(6) WHEN nl0O0O = '1'  ELSE wire_niii_dataout;
	wire_n0Oii_dataout <= rxctrl(3) OR wire_nl0l_dataout;
	wire_n0Oil_dataout <= rxdatain(24) AND NOT(wire_nl0l_dataout);
	wire_n0OiO_dataout <= rxdatain(25) OR wire_nl0l_dataout;
	wire_n0Ol_dataout <= rxdatain(7) WHEN nl0O0O = '1'  ELSE wire_niil_dataout;
	wire_n0Oli_dataout <= rxdatain(26) OR wire_nl0l_dataout;
	wire_n0Oll_dataout <= rxdatain(27) OR wire_nl0l_dataout;
	wire_n0OlO_dataout <= rxdatain(28) OR wire_nl0l_dataout;
	wire_n0OO_dataout <= rxctrl(0) OR wire_nl1l_dataout;
	wire_n0OOi_dataout <= rxdatain(29) OR wire_nl0l_dataout;
	wire_n0OOl_dataout <= rxdatain(30) OR wire_nl0l_dataout;
	wire_n0OOO_dataout <= rxdatain(31) OR wire_nl0l_dataout;
	wire_n10i_dataout <= wire_n1Oi_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_n10il_dataout <= wire_n1i1l_dataout AND NOT(nllOiO);
	wire_n10iO_dataout <= wire_n1i1O_dataout AND NOT(nllOiO);
	wire_n10l_dataout <= wire_n1Ol_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_n10li_dataout <= wire_n1i0i_dataout AND NOT(nllOiO);
	wire_n10ll_dataout <= wire_n1i0l_dataout AND NOT(nllOiO);
	wire_n10lO_dataout <= wire_n1i0O_dataout AND NOT(nllOiO);
	wire_n10O_dataout <= wire_n1OO_dataout OR wire_w_lg_nl0lll110w(0);
	wire_n10Oi_dataout <= wire_n1iii_dataout AND NOT(nllOiO);
	wire_n10Ol_dataout <= wire_n1iil_dataout AND NOT(nllOiO);
	wire_n10OO_dataout <= wire_n1iiO_dataout AND NOT(nllOiO);
	wire_n110i_dataout <= ni00O OR nl0i1l;
	wire_n110l_dataout <= ni0ii AND NOT(nl0i1l);
	wire_n110O_dataout <= ni0il OR nl0i1l;
	wire_n111i_dataout <= nl1iO OR nl00Ol;
	wire_n11ii_dataout <= ni0iO OR nl0i1l;
	wire_n11il_dataout <= ni0li OR nl0i1l;
	wire_n11iO_dataout <= ni0ll OR nl0i1l;
	wire_n11li_dataout <= ni0lO OR nl0i1l;
	wire_n11ll_dataout <= ni0Oi OR nl0i1l;
	wire_n11lO_dataout <= nl1iO OR nl0i1l;
	wire_n11O_dataout <= wire_n1lO_dataout OR wire_w_lg_nl0lll110w(0);
	wire_n1i0i_dataout <= wire_n1O0i_dataout WHEN nl0O0O = '1'  ELSE wire_n1iOi_dataout;
	wire_n1i0l_dataout <= wire_n1O0l_dataout WHEN nl0O0O = '1'  ELSE wire_n1iOl_dataout;
	wire_n1i0O_dataout <= wire_n1O0O_dataout WHEN nl0O0O = '1'  ELSE wire_n1iOO_dataout;
	wire_n1i1i_dataout <= wire_n1ili_dataout AND NOT(nllOiO);
	wire_n1i1l_dataout <= wire_n1O1l_dataout WHEN nl0O0O = '1'  ELSE wire_n1ill_dataout;
	wire_n1i1O_dataout <= wire_n1O1O_dataout WHEN nl0O0O = '1'  ELSE wire_n1ilO_dataout;
	wire_n1ii_dataout <= wire_n01i_dataout OR wire_w_lg_nl0lll110w(0);
	wire_n1iii_dataout <= wire_n1Oii_dataout WHEN nl0O0O = '1'  ELSE wire_n1l1i_dataout;
	wire_n1iil_dataout <= wire_n1Oil_dataout WHEN nl0O0O = '1'  ELSE wire_n1l1l_dataout;
	wire_n1iiO_dataout <= wire_n1OiO_dataout WHEN nl0O0O = '1'  ELSE wire_n1l1O_dataout;
	wire_n1il_dataout <= wire_n01l_dataout OR wire_w_lg_nl0lll110w(0);
	wire_n1ili_dataout <= wire_n1Oli_dataout WHEN nl0O0O = '1'  ELSE wire_n1l0i_dataout;
	wire_n1ill_dataout <= wire_n1l0l_dataout WHEN nl0i0O = '1'  ELSE nl1li;
	wire_n1ilO_dataout <= wire_n1l0O_dataout WHEN nl0i0O = '1'  ELSE nl1ll;
	wire_n1iO_dataout <= wire_n01O_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_n1iOi_dataout <= wire_n1lii_dataout WHEN nl0i0O = '1'  ELSE nl1lO;
	wire_n1iOl_dataout <= wire_n1lil_dataout WHEN nl0i0O = '1'  ELSE nl1Oi;
	wire_n1iOO_dataout <= wire_n1liO_dataout WHEN nl0i0O = '1'  ELSE nl1Ol;
	wire_n1l0i_dataout <= wire_n1lOi_dataout WHEN nl0i0O = '1'  ELSE nlOOi;
	wire_n1l0l_dataout <= nl1li OR nl0i1O;
	wire_n1l0O_dataout <= nl1ll AND NOT(nl0i1O);
	wire_n1l1i_dataout <= wire_n1lli_dataout WHEN nl0i0O = '1'  ELSE nl1OO;
	wire_n1l1l_dataout <= wire_n1lll_dataout WHEN nl0i0O = '1'  ELSE nl01i;
	wire_n1l1O_dataout <= wire_n1llO_dataout WHEN nl0i0O = '1'  ELSE nl01l;
	wire_n1li_dataout <= wire_n00i_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_n1lii_dataout <= nl1lO OR nl0i1O;
	wire_n1lil_dataout <= nl1Oi OR nl0i1O;
	wire_n1liO_dataout <= nl1Ol OR nl0i1O;
	wire_n1ll_dataout <= wire_n00l_dataout OR wire_w_lg_nl0lll110w(0);
	wire_n1lli_dataout <= nl1OO OR nl0i1O;
	wire_n1lll_dataout <= nl01i OR nl0i1O;
	wire_n1llO_dataout <= nl01l OR nl0i1O;
	wire_n1lO_dataout <= wire_n00O_dataout OR wire_nill_dataout;
	wire_n1lOi_dataout <= nlOOi OR nl0i1O;
	wire_n1O0i_dataout <= nl1lO OR nl0iii;
	wire_n1O0l_dataout <= nl1Oi OR nl0iii;
	wire_n1O0O_dataout <= nl1Ol OR nl0iii;
	wire_n1O1l_dataout <= nl1li OR nl0iii;
	wire_n1O1O_dataout <= nl1ll AND NOT(nl0iii);
	wire_n1Oi_dataout <= wire_n0ii_dataout OR wire_nill_dataout;
	wire_n1Oii_dataout <= nl1OO OR nl0iii;
	wire_n1Oil_dataout <= nl01i OR nl0iii;
	wire_n1OiO_dataout <= nl01l OR nl0iii;
	wire_n1Ol_dataout <= wire_n0il_dataout OR wire_nill_dataout;
	wire_n1Oli_dataout <= nlOOi OR nl0iii;
	wire_n1OO_dataout <= wire_n0iO_dataout OR wire_nill_dataout;
	wire_ni01i_dataout <= wire_n0OOi_dataout AND NOT(nl0l1O);
	wire_ni01l_dataout <= wire_n0OOl_dataout AND NOT(nl0l1O);
	wire_ni01O_dataout <= wire_n0OOO_dataout AND NOT(nl0l1O);
	wire_ni0i_dataout <= rxdatain(3) OR wire_nl1l_dataout;
	wire_ni0l_dataout <= rxdatain(4) OR wire_nl1l_dataout;
	wire_ni0O_dataout <= rxdatain(5) OR wire_nl1l_dataout;
	wire_ni0Ol_dataout <= wire_niO0l_dataout WHEN nl1i = '1'  ELSE wire_niiil_dataout;
	wire_ni0OO_dataout <= wire_niO0O_dataout WHEN nl1i = '1'  ELSE wire_niiiO_dataout;
	wire_ni10i_dataout <= wire_ni1Oi_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_ni10l_dataout <= wire_ni1Ol_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_ni10O_dataout <= wire_ni1OO_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_ni11i_dataout <= wire_ni1li_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_ni11l_dataout <= wire_ni1ll_dataout OR wire_w_lg_nl0lll110w(0);
	wire_ni11O_dataout <= wire_ni1lO_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_ni1i_dataout <= rxdatain(0) AND NOT(wire_nl1l_dataout);
	wire_ni1ii_dataout <= wire_ni01i_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_ni1il_dataout <= wire_ni01l_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_ni1iO_dataout <= wire_ni01O_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_ni1l_dataout <= rxdatain(1) OR wire_nl1l_dataout;
	wire_ni1li_dataout <= wire_n0Oii_dataout OR nl0l1O;
	wire_ni1ll_dataout <= wire_n0Oil_dataout OR nl0l1O;
	wire_ni1lO_dataout <= wire_n0OiO_dataout OR nl0l1O;
	wire_ni1O_dataout <= rxdatain(2) OR wire_nl1l_dataout;
	wire_ni1Oi_dataout <= wire_n0Oli_dataout OR nl0l1O;
	wire_ni1Ol_dataout <= wire_n0Oll_dataout AND NOT(nl0l1O);
	wire_ni1OO_dataout <= wire_n0OlO_dataout AND NOT(nl0l1O);
	wire_nii0i_dataout <= wire_niOli_dataout WHEN nl1i = '1'  ELSE wire_niiOi_dataout;
	wire_nii0l_dataout <= wire_niOll_dataout WHEN nl1i = '1'  ELSE wire_niiOl_dataout;
	wire_nii0O_dataout <= wire_niOlO_dataout WHEN nl1i = '1'  ELSE wire_niiOO_dataout;
	wire_nii1i_dataout <= wire_niOii_dataout WHEN nl1i = '1'  ELSE wire_niili_dataout;
	wire_nii1l_dataout <= wire_niOil_dataout WHEN nl1i = '1'  ELSE wire_niill_dataout;
	wire_nii1O_dataout <= wire_niOiO_dataout WHEN nl1i = '1'  ELSE wire_niilO_dataout;
	wire_niii_dataout <= rxdatain(6) OR wire_nl1l_dataout;
	wire_niiii_dataout <= wire_niOOi_dataout WHEN nl1i = '1'  ELSE wire_nil1i_dataout;
	wire_niiil_dataout <= wire_nil1l_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niiiO_dataout <= wire_nil1O_dataout OR wire_w_lg_nl0lll110w(0);
	wire_niil_dataout <= rxdatain(7) OR wire_nl1l_dataout;
	wire_niili_dataout <= wire_nil0i_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niill_dataout <= wire_nil0l_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niilO_dataout <= wire_nil0O_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niiOi_dataout <= wire_nilii_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niiOl_dataout <= wire_nilil_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niiOO_dataout <= wire_niliO_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nil0i_dataout <= wire_nilOi_dataout OR nl0Oli;
	wire_nil0l_dataout <= wire_nilOl_dataout OR nl0Oli;
	wire_nil0O_dataout <= wire_nilOO_dataout AND NOT(nl0Oli);
	wire_nil1i_dataout <= wire_nilli_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nil1l_dataout <= wire_nilll_dataout OR nl0Oli;
	wire_nil1O_dataout <= wire_nillO_dataout OR nl0Oli;
	wire_nilii_dataout <= wire_niO1i_dataout AND NOT(nl0Oli);
	wire_nilil_dataout <= wire_niO1l_dataout AND NOT(nl0Oli);
	wire_niliO_dataout <= wire_niO1O_dataout AND NOT(nl0Oli);
	wire_nill_dataout <= nl0Oli AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nilli_dataout <= wire_niO0i_dataout AND NOT(nl0Oli);
	wire_nilll_dataout <= rxctrl(2) OR wire_nl0i_dataout;
	wire_nillO_dataout <= rxdatain(16) AND NOT(wire_nl0i_dataout);
	wire_nilO_dataout <= wire_w_lg_nl0Oli109w(0) AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nilOi_dataout <= rxdatain(17) OR wire_nl0i_dataout;
	wire_nilOl_dataout <= rxdatain(18) OR wire_nl0i_dataout;
	wire_nilOO_dataout <= rxdatain(19) OR wire_nl0i_dataout;
	wire_niO0i_dataout <= rxdatain(23) OR wire_nl0i_dataout;
	wire_niO0l_dataout <= wire_niOOl_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niO0O_dataout <= wire_niOOO_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niO1i_dataout <= rxdatain(20) OR wire_nl0i_dataout;
	wire_niO1l_dataout <= rxdatain(21) OR wire_nl0i_dataout;
	wire_niO1O_dataout <= rxdatain(22) OR wire_nl0i_dataout;
	wire_niOii_dataout <= wire_nl11i_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niOil_dataout <= wire_nl11l_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niOiO_dataout <= wire_nl11O_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niOli_dataout <= wire_nl10i_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niOll_dataout <= wire_nl10l_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niOlO_dataout <= wire_nl10O_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niOOi_dataout <= wire_nl1ii_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_niOOl_dataout <= wire_nilll_dataout OR nl0l0i;
	wire_niOOO_dataout <= wire_nillO_dataout OR nl0l0i;
	wire_nl00i_dataout <= wire_nllli_dataout WHEN nl1i = '1'  ELSE wire_nl0Oi_dataout;
	wire_nl00l_dataout <= wire_nllll_dataout WHEN nl1i = '1'  ELSE wire_nl0Ol_dataout;
	wire_nl00O_dataout <= wire_nlllO_dataout WHEN nl1i = '1'  ELSE wire_nl0OO_dataout;
	wire_nl01O_dataout <= wire_nlliO_dataout WHEN nl1i = '1'  ELSE wire_nl0lO_dataout;
	wire_nl0i_dataout <= rxrunningdisp(2) AND NOT(nllOiO);
	wire_nl0i_w_lg_dataout91w(0) <= NOT wire_nl0i_dataout;
	wire_nl0ii_dataout <= wire_nllOi_dataout WHEN nl1i = '1'  ELSE wire_nli1i_dataout;
	wire_nl0il_dataout <= wire_nllOl_dataout WHEN nl1i = '1'  ELSE wire_nli1l_dataout;
	wire_nl0iO_dataout <= wire_nllOO_dataout WHEN nl1i = '1'  ELSE wire_nli1O_dataout;
	wire_nl0l_dataout <= rxrunningdisp(3) AND NOT(nllOiO);
	wire_nl0l_w_lg_dataout111w(0) <= NOT wire_nl0l_dataout;
	wire_nl0li_dataout <= wire_nlO1i_dataout WHEN nl1i = '1'  ELSE wire_nli0i_dataout;
	wire_nl0ll_dataout <= wire_nlO1l_dataout WHEN nl1i = '1'  ELSE wire_nli0l_dataout;
	wire_nl0lO_dataout <= wire_nli0O_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nl0Oi_dataout <= wire_nliii_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nl0Ol_dataout <= wire_nliil_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nl0OO_dataout <= wire_nliiO_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nl10i_dataout <= wire_niO1i_dataout AND NOT(nl0l0i);
	wire_nl10l_dataout <= wire_niO1l_dataout AND NOT(nl0l0i);
	wire_nl10O_dataout <= wire_niO1O_dataout AND NOT(nl0l0i);
	wire_nl11i_dataout <= wire_nilOi_dataout OR nl0l0i;
	wire_nl11l_dataout <= wire_nilOl_dataout OR nl0l0i;
	wire_nl11O_dataout <= wire_nilOO_dataout AND NOT(nl0l0i);
	wire_nl1ii_dataout <= wire_niO0i_dataout AND NOT(nl0l0i);
	wire_nl1l_dataout <= rxrunningdisp(0) AND NOT(nllOiO);
	wire_nl1l_w_lg_dataout79w(0) <= NOT wire_nl1l_dataout;
	wire_nl1O_dataout <= rxrunningdisp(1) AND NOT(nllOiO);
	wire_nl1O_w_lg_dataout85w(0) <= NOT wire_nl1O_dataout;
	wire_nli0i_dataout <= wire_nliOi_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nli0l_dataout <= wire_nliOl_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nli0O_dataout <= wire_nliOO_dataout OR nl0Oli;
	wire_nli1i_dataout <= wire_nlili_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nli1l_dataout <= wire_nlill_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nli1O_dataout <= wire_nlilO_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nliii_dataout <= wire_nll1i_dataout OR nl0Oli;
	wire_nliil_dataout <= wire_nll1l_dataout OR nl0Oli;
	wire_nliiO_dataout <= wire_nll1O_dataout OR nl0Oli;
	wire_nlili_dataout <= wire_nll0i_dataout AND NOT(nl0Oli);
	wire_nlill_dataout <= wire_nll0l_dataout AND NOT(nl0Oli);
	wire_nlilO_dataout <= wire_nll0O_dataout AND NOT(nl0Oli);
	wire_nliOi_dataout <= wire_nllii_dataout AND NOT(nl0Oli);
	wire_nliOl_dataout <= wire_nllil_dataout AND NOT(nl0Oli);
	wire_nliOO_dataout <= rxctrl(1) OR wire_nl1O_dataout;
	wire_nll0i_dataout <= rxdatain(11) OR wire_nl1O_dataout;
	wire_nll0l_dataout <= rxdatain(12) OR wire_nl1O_dataout;
	wire_nll0O_dataout <= rxdatain(13) OR wire_nl1O_dataout;
	wire_nll1i_dataout <= rxdatain(8) AND NOT(wire_nl1O_dataout);
	wire_nll1l_dataout <= rxdatain(9) OR wire_nl1O_dataout;
	wire_nll1O_dataout <= rxdatain(10) OR wire_nl1O_dataout;
	wire_nllii_dataout <= rxdatain(14) OR wire_nl1O_dataout;
	wire_nllil_dataout <= rxdatain(15) OR wire_nl1O_dataout;
	wire_nlliO_dataout <= wire_nlO1O_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nllli_dataout <= wire_nlO0i_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nllll_dataout <= wire_nlO0l_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nlllO_dataout <= wire_nlO0O_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nllOi_dataout <= wire_nlOii_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nllOl_dataout <= wire_nlOil_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nllOO_dataout <= wire_nlOiO_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nlO00i_dataout <= wire_nlO0Oi_dataout WHEN nl00li = '1'  ELSE n0i1O;
	wire_nlO00l_dataout <= nllO1l AND NOT(nl00iO);
	wire_nlO00O_dataout <= n0i0i OR nl00iO;
	wire_nlO01i_dataout <= wire_nlO0li_dataout WHEN nl00li = '1'  ELSE n0iil;
	wire_nlO01l_dataout <= wire_nlO0ll_dataout WHEN nl00li = '1'  ELSE n0iiO;
	wire_nlO01O_dataout <= wire_nlO0lO_dataout WHEN nl00li = '1'  ELSE ni00l;
	wire_nlO0i_dataout <= wire_nll1i_dataout OR nl0lii;
	wire_nlO0ii_dataout <= n0i0l OR nl00iO;
	wire_nlO0il_dataout <= n0i0O OR nl00iO;
	wire_nlO0iO_dataout <= n0iii OR nl00iO;
	wire_nlO0l_dataout <= wire_nll1l_dataout OR nl0lii;
	wire_nlO0li_dataout <= n0iil OR nl00iO;
	wire_nlO0ll_dataout <= n0iiO OR nl00iO;
	wire_nlO0lO_dataout <= ni00l OR nl00iO;
	wire_nlO0O_dataout <= wire_nll1O_dataout OR nl0lii;
	wire_nlO0Oi_dataout <= n0i1O OR nl00iO;
	wire_nlO10i_dataout <= wire_nlO1lO_dataout AND NOT(nllOiO);
	wire_nlO10l_dataout <= wire_nlO1Oi_dataout AND NOT(nllOiO);
	wire_nlO10O_dataout <= wire_nlO1Ol_dataout AND NOT(nllOiO);
	wire_nlO11l_dataout <= wire_nlO00i_dataout AND NOT(nllOiO);
	wire_nlO11O_dataout <= wire_nlO1ll_dataout OR nllOiO;
	wire_nlO1i_dataout <= wire_nlOli_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nlO1ii_dataout <= wire_nlO1OO_dataout AND NOT(nllOiO);
	wire_nlO1il_dataout <= wire_nlO01i_dataout AND NOT(nllOiO);
	wire_nlO1iO_dataout <= wire_nlO01l_dataout AND NOT(nllOiO);
	wire_nlO1l_dataout <= wire_nlOll_dataout AND NOT(wire_w_lg_nl0lll110w(0));
	wire_nlO1li_dataout <= wire_nlO01O_dataout AND NOT(nllOiO);
	wire_nlO1ll_dataout <= wire_nlO00l_dataout WHEN nl00li = '1'  ELSE nllO1l;
	wire_nlO1lO_dataout <= wire_nlO00O_dataout WHEN nl00li = '1'  ELSE n0i0i;
	wire_nlO1O_dataout <= wire_nliOO_dataout OR nl0lii;
	wire_nlO1Oi_dataout <= wire_nlO0ii_dataout WHEN nl00li = '1'  ELSE n0i0l;
	wire_nlO1Ol_dataout <= wire_nlO0il_dataout WHEN nl00li = '1'  ELSE n0i0O;
	wire_nlO1OO_dataout <= wire_nlO0iO_dataout WHEN nl00li = '1'  ELSE n0iii;
	wire_nlOii_dataout <= wire_nll0i_dataout AND NOT(nl0lii);
	wire_nlOil_dataout <= wire_nll0l_dataout AND NOT(nl0lii);
	wire_nlOill_dataout <= wire_nlOl0l_dataout AND NOT(nllOiO);
	wire_nlOilO_dataout <= wire_nlOl0O_dataout AND NOT(nllOiO);
	wire_nlOiO_dataout <= wire_nll0O_dataout AND NOT(nl0lii);
	wire_nlOiOi_dataout <= wire_nlOlii_dataout AND NOT(nllOiO);
	wire_nlOiOl_dataout <= wire_nlOlil_dataout AND NOT(nllOiO);
	wire_nlOiOO_dataout <= wire_nlOliO_dataout AND NOT(nllOiO);
	wire_nlOl0i_dataout <= wire_nlOlOi_dataout AND NOT(nllOiO);
	wire_nlOl0l_dataout <= wire_n110i_dataout WHEN nl00Oi = '1'  ELSE wire_nlOlOl_dataout;
	wire_nlOl0O_dataout <= wire_n110l_dataout WHEN nl00Oi = '1'  ELSE wire_nlOlOO_dataout;
	wire_nlOl1i_dataout <= wire_nlOlli_dataout AND NOT(nllOiO);
	wire_nlOl1l_dataout <= wire_nlOlll_dataout AND NOT(nllOiO);
	wire_nlOl1O_dataout <= wire_nlOllO_dataout AND NOT(nllOiO);
	wire_nlOli_dataout <= wire_nllii_dataout AND NOT(nl0lii);
	wire_nlOlii_dataout <= wire_n110O_dataout WHEN nl00Oi = '1'  ELSE wire_nlOO1i_dataout;
	wire_nlOlil_dataout <= wire_n11ii_dataout WHEN nl00Oi = '1'  ELSE wire_nlOO1l_dataout;
	wire_nlOliO_dataout <= wire_n11il_dataout WHEN nl00Oi = '1'  ELSE wire_nlOO1O_dataout;
	wire_nlOll_dataout <= wire_nllil_dataout AND NOT(nl0lii);
	wire_nlOlli_dataout <= wire_n11iO_dataout WHEN nl00Oi = '1'  ELSE wire_nlOO0i_dataout;
	wire_nlOlll_dataout <= wire_n11li_dataout WHEN nl00Oi = '1'  ELSE wire_nlOO0l_dataout;
	wire_nlOllO_dataout <= wire_n11ll_dataout WHEN nl00Oi = '1'  ELSE wire_nlOO0O_dataout;
	wire_nlOlOi_dataout <= wire_n11lO_dataout WHEN nl00Oi = '1'  ELSE wire_nlOOii_dataout;
	wire_nlOlOl_dataout <= wire_nlOOil_dataout WHEN niiO = '1'  ELSE ni00O;
	wire_nlOlOO_dataout <= wire_nlOOiO_dataout WHEN niiO = '1'  ELSE ni0ii;
	wire_nlOO0i_dataout <= wire_nlOOOi_dataout WHEN niiO = '1'  ELSE ni0ll;
	wire_nlOO0l_dataout <= wire_nlOOOl_dataout WHEN niiO = '1'  ELSE ni0lO;
	wire_nlOO0O_dataout <= wire_nlOOOO_dataout WHEN niiO = '1'  ELSE ni0Oi;
	wire_nlOO1i_dataout <= wire_nlOOli_dataout WHEN niiO = '1'  ELSE ni0il;
	wire_nlOO1l_dataout <= wire_nlOOll_dataout WHEN niiO = '1'  ELSE ni0iO;
	wire_nlOO1O_dataout <= wire_nlOOlO_dataout WHEN niiO = '1'  ELSE ni0li;
	wire_nlOOii_dataout <= wire_n111i_dataout WHEN niiO = '1'  ELSE nl1iO;
	wire_nlOOil_dataout <= ni00O OR nl00Ol;
	wire_nlOOiO_dataout <= ni0ii AND NOT(nl00Ol);
	wire_nlOOli_dataout <= ni0il OR nl00Ol;
	wire_nlOOll_dataout <= ni0iO OR nl00Ol;
	wire_nlOOlO_dataout <= ni0li OR nl00Ol;
	wire_nlOOOi_dataout <= ni0ll OR nl00Ol;
	wire_nlOOOl_dataout <= ni0lO OR nl00Ol;
	wire_nlOOOO_dataout <= ni0Oi OR nl00Ol;

 END RTL; --stratixgx_xgm_rx_sm
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 146 mux21 317 oper_add 1 oper_decoder 1 oper_less_than 1 oper_selector 39 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixgx_xgm_tx_sm IS 
	 PORT 
	 ( 
		 rdenablesync	:	IN  STD_LOGIC;
		 resetall	:	IN  STD_LOGIC;
		 txclk	:	IN  STD_LOGIC;
		 txctrl	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 txctrlout	:	OUT  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 txdatain	:	IN  STD_LOGIC_VECTOR (31 DOWNTO 0);
		 txdataout	:	OUT  STD_LOGIC_VECTOR (31 DOWNTO 0)
	 ); 
 END stratixgx_xgm_tx_sm;

 ARCHITECTURE RTL OF stratixgx_xgm_tx_sm IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 nl000O1	:	STD_LOGIC := '1';
	 SIGNAL	 nl000O2	:	STD_LOGIC := '1';
	 SIGNAL	 nl000O3	:	STD_LOGIC := '0';
	 SIGNAL	 nl001O4	:	STD_LOGIC := '1';
	 SIGNAL	 nl001O5	:	STD_LOGIC := '1';
	 SIGNAL	 nl001O6	:	STD_LOGIC := '0';
	 SIGNAL	 nl010O13	:	STD_LOGIC := '1';
	 SIGNAL	 nl010O14	:	STD_LOGIC := '1';
	 SIGNAL	 nl010O15	:	STD_LOGIC := '0';
	 SIGNAL	 nl011l16	:	STD_LOGIC := '1';
	 SIGNAL	 nl011l17	:	STD_LOGIC := '1';
	 SIGNAL	 nl011l18	:	STD_LOGIC := '0';
	 SIGNAL	 nl01iO10	:	STD_LOGIC := '1';
	 SIGNAL	 nl01iO11	:	STD_LOGIC := '1';
	 SIGNAL	 nl01iO12	:	STD_LOGIC := '0';
	 SIGNAL	 nl01Ol7	:	STD_LOGIC := '1';
	 SIGNAL	 nl01Ol8	:	STD_LOGIC := '1';
	 SIGNAL	 nl01Ol9	:	STD_LOGIC := '0';
	 SIGNAL	 nl100l55	:	STD_LOGIC := '1';
	 SIGNAL	 nl100l56	:	STD_LOGIC := '1';
	 SIGNAL	 nl100l57	:	STD_LOGIC := '0';
	 SIGNAL	 nl10li52	:	STD_LOGIC := '1';
	 SIGNAL	 nl10li53	:	STD_LOGIC := '1';
	 SIGNAL	 nl10li54	:	STD_LOGIC := '0';
	 SIGNAL	 nl10Ol49	:	STD_LOGIC := '1';
	 SIGNAL	 nl10Ol50	:	STD_LOGIC := '1';
	 SIGNAL	 nl10Ol51	:	STD_LOGIC := '0';
	 SIGNAL	 nl11OO58	:	STD_LOGIC := '1';
	 SIGNAL	 nl11OO59	:	STD_LOGIC := '1';
	 SIGNAL	 nl11OO60	:	STD_LOGIC := '0';
	 SIGNAL	 nl1i0O43	:	STD_LOGIC := '1';
	 SIGNAL	 nl1i0O44	:	STD_LOGIC := '1';
	 SIGNAL	 nl1i0O45	:	STD_LOGIC := '0';
	 SIGNAL	 nl1i1O46	:	STD_LOGIC := '1';
	 SIGNAL	 nl1i1O47	:	STD_LOGIC := '1';
	 SIGNAL	 nl1i1O48	:	STD_LOGIC := '0';
	 SIGNAL	 nl1iil40	:	STD_LOGIC := '1';
	 SIGNAL	 nl1iil41	:	STD_LOGIC := '1';
	 SIGNAL	 nl1iil42	:	STD_LOGIC := '0';
	 SIGNAL	 nl1ilO37	:	STD_LOGIC := '1';
	 SIGNAL	 nl1ilO38	:	STD_LOGIC := '1';
	 SIGNAL	 nl1ilO39	:	STD_LOGIC := '0';
	 SIGNAL	 nl1l0i34	:	STD_LOGIC := '1';
	 SIGNAL	 nl1l0i35	:	STD_LOGIC := '1';
	 SIGNAL	 nl1l0i36	:	STD_LOGIC := '0';
	 SIGNAL	 nl1lii31	:	STD_LOGIC := '1';
	 SIGNAL	 nl1lii32	:	STD_LOGIC := '1';
	 SIGNAL	 nl1lii33	:	STD_LOGIC := '0';
	 SIGNAL	 nl1lOi28	:	STD_LOGIC := '1';
	 SIGNAL	 nl1lOi29	:	STD_LOGIC := '1';
	 SIGNAL	 nl1lOi30	:	STD_LOGIC := '0';
	 SIGNAL	 nl1O1i25	:	STD_LOGIC := '1';
	 SIGNAL	 nl1O1i26	:	STD_LOGIC := '1';
	 SIGNAL	 nl1O1i27	:	STD_LOGIC := '0';
	 SIGNAL	 nl1Oii22	:	STD_LOGIC := '1';
	 SIGNAL	 nl1Oii23	:	STD_LOGIC := '1';
	 SIGNAL	 nl1Oii24	:	STD_LOGIC := '0';
	 SIGNAL	 nl1OOi19	:	STD_LOGIC := '1';
	 SIGNAL	 nl1OOi20	:	STD_LOGIC := '1';
	 SIGNAL	 nl1OOi21	:	STD_LOGIC := '0';
	 SIGNAL	n00i	:	STD_LOGIC := '0';
	 SIGNAL	n00l	:	STD_LOGIC := '0';
	 SIGNAL	n00O	:	STD_LOGIC := '0';
	 SIGNAL	n01i	:	STD_LOGIC := '0';
	 SIGNAL	n01l	:	STD_LOGIC := '0';
	 SIGNAL	n01O	:	STD_LOGIC := '0';
	 SIGNAL	n0il	:	STD_LOGIC := '0';
	 SIGNAL	n10i	:	STD_LOGIC := '0';
	 SIGNAL	n10l	:	STD_LOGIC := '0';
	 SIGNAL	n10O	:	STD_LOGIC := '0';
	 SIGNAL	n11i	:	STD_LOGIC := '0';
	 SIGNAL	n11l	:	STD_LOGIC := '0';
	 SIGNAL	n11O	:	STD_LOGIC := '0';
	 SIGNAL	n1ii	:	STD_LOGIC := '0';
	 SIGNAL	n1il	:	STD_LOGIC := '0';
	 SIGNAL	n1iO	:	STD_LOGIC := '0';
	 SIGNAL	n1li	:	STD_LOGIC := '0';
	 SIGNAL	n1ll	:	STD_LOGIC := '0';
	 SIGNAL	n1lO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1Ol	:	STD_LOGIC := '0';
	 SIGNAL	n1OO	:	STD_LOGIC := '0';
	 SIGNAL	nlOll	:	STD_LOGIC := '0';
	 SIGNAL	nlOlO	:	STD_LOGIC := '0';
	 SIGNAL	nlOOi	:	STD_LOGIC := '0';
	 SIGNAL	nlOOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOOO	:	STD_LOGIC := '0';
	 SIGNAL	n011i	:	STD_LOGIC := '0';
	 SIGNAL	n011l	:	STD_LOGIC := '0';
	 SIGNAL	n011O	:	STD_LOGIC := '0';
	 SIGNAL	n0OO	:	STD_LOGIC := '0';
	 SIGNAL	ni1l	:	STD_LOGIC := '0';
	 SIGNAL	ni1Oi	:	STD_LOGIC := '0';
	 SIGNAL	ni1Ol	:	STD_LOGIC := '0';
	 SIGNAL	ni1OO	:	STD_LOGIC := '0';
	 SIGNAL	nll0l	:	STD_LOGIC := '0';
	 SIGNAL	nll0O	:	STD_LOGIC := '0';
	 SIGNAL	nllii	:	STD_LOGIC := '0';
	 SIGNAL	nllil	:	STD_LOGIC := '0';
	 SIGNAL	nlliOl	:	STD_LOGIC := '0';
	 SIGNAL	nlliOO	:	STD_LOGIC := '0';
	 SIGNAL	nlll1i	:	STD_LOGIC := '0';
	 SIGNAL	nlll1l	:	STD_LOGIC := '0';
	 SIGNAL	nlOO0i	:	STD_LOGIC := '0';
	 SIGNAL	nlOO0l	:	STD_LOGIC := '0';
	 SIGNAL	nlOO0O	:	STD_LOGIC := '0';
	 SIGNAL  wire_ni1i_w_lg_w_lg_w_lg_w_lg_nlliOl154w160w197w198w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_w_lg_w_lg_w_lg_nlliOl154w160w161w162w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_w_lg_w_lg_nlliOl154w156w157w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_w_lg_w_lg_nlliOl154w160w197w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_w_lg_w_lg_nlliOl154w160w161w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_w_lg_nlliOl154w156w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_w_lg_nlliOl154w160w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_n0OO261w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_ni1l155w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_ni1i_w_lg_nlliOl154w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlli0l	:	STD_LOGIC := '0';
	 SIGNAL	nlli0O	:	STD_LOGIC := '0';
	 SIGNAL	nlliii	:	STD_LOGIC := '0';
	 SIGNAL	nlliil	:	STD_LOGIC := '0';
	 SIGNAL	nllili	:	STD_LOGIC := '0';
	 SIGNAL	nll00i	:	STD_LOGIC := '0';
	 SIGNAL	nll00l	:	STD_LOGIC := '0';
	 SIGNAL	nll00O	:	STD_LOGIC := '0';
	 SIGNAL	nll01i	:	STD_LOGIC := '0';
	 SIGNAL	nll01l	:	STD_LOGIC := '0';
	 SIGNAL	nll01O	:	STD_LOGIC := '0';
	 SIGNAL	nll0ii	:	STD_LOGIC := '0';
	 SIGNAL	nll0il	:	STD_LOGIC := '0';
	 SIGNAL	nll0iO	:	STD_LOGIC := '0';
	 SIGNAL	nll0li	:	STD_LOGIC := '0';
	 SIGNAL	nll0ll	:	STD_LOGIC := '0';
	 SIGNAL	nll0lO	:	STD_LOGIC := '0';
	 SIGNAL	nll0Oi	:	STD_LOGIC := '0';
	 SIGNAL	nll0Ol	:	STD_LOGIC := '0';
	 SIGNAL	nll0OO	:	STD_LOGIC := '0';
	 SIGNAL	nll10i	:	STD_LOGIC := '0';
	 SIGNAL	nll10l	:	STD_LOGIC := '0';
	 SIGNAL	nll10O	:	STD_LOGIC := '0';
	 SIGNAL	nll11l	:	STD_LOGIC := '0';
	 SIGNAL	nll11O	:	STD_LOGIC := '0';
	 SIGNAL	nll1ii	:	STD_LOGIC := '0';
	 SIGNAL	nll1il	:	STD_LOGIC := '0';
	 SIGNAL	nll1iO	:	STD_LOGIC := '0';
	 SIGNAL	nll1li	:	STD_LOGIC := '0';
	 SIGNAL	nll1ll	:	STD_LOGIC := '0';
	 SIGNAL	nll1lO	:	STD_LOGIC := '0';
	 SIGNAL	nll1Oi	:	STD_LOGIC := '0';
	 SIGNAL	nll1Ol	:	STD_LOGIC := '0';
	 SIGNAL	nll1OO	:	STD_LOGIC := '0';
	 SIGNAL	nlli0i	:	STD_LOGIC := '0';
	 SIGNAL	nlli1i	:	STD_LOGIC := '0';
	 SIGNAL	nlli1l	:	STD_LOGIC := '0';
	 SIGNAL	nlli1O	:	STD_LOGIC := '0';
	 SIGNAL	nllill	:	STD_LOGIC := '0';
	 SIGNAL	nlliOi	:	STD_LOGIC := '0';
	 SIGNAL  wire_nllilO_w_lg_nll0ll255w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllilO_w_lg_nll0Oi262w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllilO_w_lg_nllill158w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllilO_w_lg_nlliOi196w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n00il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n00OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n010O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n01lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n100O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n101O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n10OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n11OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1i1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1ilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1iOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1l1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1llO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1lOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1Oll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1OOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nii0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nil1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nillO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl00O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nli1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlll1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllOOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO00i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO01O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO10O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO11O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1il_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1iO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1li_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1ll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1lO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1Oi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlO1OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOi1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOiOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOllO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOlOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOO1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOlO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlOOOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nlO0i_a	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nlO0i_b	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_gnd	:	STD_LOGIC;
	 SIGNAL  wire_nlO0i_o	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_lg_w_o_range287w315w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_i	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nllOii_o	:	STD_LOGIC_VECTOR (15 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_o_range281w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nllOii_w_o_range287w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nll1l_a	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll1l_b	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_nll1l_o	:	STD_LOGIC;
	 SIGNAL  wire_n000i_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n000i_o	:	STD_LOGIC;
	 SIGNAL  wire_n000i_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n000l_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n000l_o	:	STD_LOGIC;
	 SIGNAL  wire_n000l_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n000O_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n000O_o	:	STD_LOGIC;
	 SIGNAL  wire_n000O_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n001i_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n001i_o	:	STD_LOGIC;
	 SIGNAL  wire_n001i_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n001l_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n001l_o	:	STD_LOGIC;
	 SIGNAL  wire_n001l_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n001O_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n001O_o	:	STD_LOGIC;
	 SIGNAL  wire_n001O_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n01Oi_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n01Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_n01Oi_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n01Ol_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n01Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_n01Ol_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n01OO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n01OO_o	:	STD_LOGIC;
	 SIGNAL  wire_n01OO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n110i_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n110i_o	:	STD_LOGIC;
	 SIGNAL  wire_n110i_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n110l_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n110l_o	:	STD_LOGIC;
	 SIGNAL  wire_n110l_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n110O_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n110O_o	:	STD_LOGIC;
	 SIGNAL  wire_n110O_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n111i_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n111i_o	:	STD_LOGIC;
	 SIGNAL  wire_n111i_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n111l_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n111l_o	:	STD_LOGIC;
	 SIGNAL  wire_n111l_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n111O_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n111O_o	:	STD_LOGIC;
	 SIGNAL  wire_n111O_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n11ii_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n11ii_o	:	STD_LOGIC;
	 SIGNAL  wire_n11ii_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n11il_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n11il_o	:	STD_LOGIC;
	 SIGNAL  wire_n11il_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n11iO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_n11iO_o	:	STD_LOGIC;
	 SIGNAL  wire_n11iO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni0li_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni0li_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0li_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni0ll_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni0ll_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0ll_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni0lO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni0lO_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0lO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni0Oi_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni0Oi_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0Oi_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni0Ol_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni0Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0Ol_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni0OO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_ni0OO_o	:	STD_LOGIC;
	 SIGNAL  wire_ni0OO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nii1i_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nii1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nii1i_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nii1l_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nii1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nii1l_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nii1O_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nii1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nii1O_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nl00i_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl00i_o	:	STD_LOGIC;
	 SIGNAL  wire_nl00i_sel	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl01l_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl01l_o	:	STD_LOGIC;
	 SIGNAL  wire_nl01l_sel	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_nl1OO_data	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nl1OO_o	:	STD_LOGIC;
	 SIGNAL  wire_nl1OO_sel	:	STD_LOGIC_VECTOR (6 DOWNTO 0);
	 SIGNAL  wire_nllllO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nllllO_o	:	STD_LOGIC;
	 SIGNAL  wire_nllllO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlllOi_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlllOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nlllOi_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlllOl_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlllOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nlllOl_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlllOO_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nlllOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlllOO_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nllO0i_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nllO0i_o	:	STD_LOGIC;
	 SIGNAL  wire_nllO0i_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nllO0l_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nllO0l_o	:	STD_LOGIC;
	 SIGNAL  wire_nllO0l_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nllO1i_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nllO1i_o	:	STD_LOGIC;
	 SIGNAL  wire_nllO1i_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nllO1l_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nllO1l_o	:	STD_LOGIC;
	 SIGNAL  wire_nllO1l_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nllO1O_data	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_nllO1O_o	:	STD_LOGIC;
	 SIGNAL  wire_nllO1O_sel	:	STD_LOGIC_VECTOR (8 DOWNTO 0);
	 SIGNAL  wire_w89w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_lg_w17w20w22w24w26w29w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_lg_w47w49w51w53w55w58w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_lg_w75w77w79w81w84w86w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w17w20w22w24w26w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w47w49w51w53w55w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w75w77w79w81w84w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w17w20w22w24w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w47w49w51w53w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w75w77w79w81w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w17w20w22w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w118w120w123w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w47w49w51w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w75w77w79w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w17w20w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w118w120w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w47w49w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w75w77w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w17w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w118w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w47w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w75w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w104w107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_lg_nl00ll1w8w10w13w15w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_lg_nl1iOO94w108w111w113w116w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_txctrl_range35w37w40w42w44w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_w_txctrl_range63w65w68w70w73w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w104w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_nl00ll1w8w10w13w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_nl1iOO94w108w111w113w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_txctrl_range35w37w40w42w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_txctrl_range63w65w68w70w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_txctrl_range95w97w100w102w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nl00ll1w8w10w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_nl1iOO94w108w111w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_txctrl_range2w4w7w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_txctrl_range35w37w40w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_txctrl_range63w65w68w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_txctrl_range95w97w100w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nl00ll1w8w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nl11ii193w194w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nl1iOO94w108w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_rdenablesync249w250w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl110i257w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl11il253w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rdenablesync252w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_txctrl_range2w4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_txctrl_range35w37w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_txctrl_range63w65w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_txctrl_range95w97w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_txdatain_range192w1526w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_txdatain_range180w1540w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_txdatain_range172w1673w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_txdatain_range188w1533w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl000l9w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl001i16w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl001l14w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl00il3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl00ll1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl010i36w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl011i41w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl01il30w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl01ll25w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl01lO23w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl01Oi21w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl10ii1120w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl10lO126w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl10Oi124w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl111i259w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl111O260w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl11ii193w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl11li1121w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1i0l112w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1i1i119w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1i1l117w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1ili103w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1ill101w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1iOl96w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1iOO94w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1l0O85w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1l1l92w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1l1O90w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1liO80w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1lli78w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1lll76w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1llO74w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1lOO69w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1O0l61w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1O0O59w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1O1O64w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1OiO54w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1Oli52w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1Oll50w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1OlO48w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl1OOO43w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_rdenablesync249w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_resetall152w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_txdatain_range179w1480w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_txdatain_range191w1525w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_txdatain_range1125w1489w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_txdatain_range187w1471w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_rdenablesync249w250w251w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nl11ii256w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  niOOil :	STD_LOGIC;
	 SIGNAL  niOOiO :	STD_LOGIC;
	 SIGNAL  niOOli :	STD_LOGIC;
	 SIGNAL  niOOll :	STD_LOGIC;
	 SIGNAL  niOOlO :	STD_LOGIC;
	 SIGNAL  niOOOi :	STD_LOGIC;
	 SIGNAL  niOOOl :	STD_LOGIC;
	 SIGNAL  niOOOO :	STD_LOGIC;
	 SIGNAL  nl000l :	STD_LOGIC;
	 SIGNAL  nl001i :	STD_LOGIC;
	 SIGNAL  nl001l :	STD_LOGIC;
	 SIGNAL  nl00il :	STD_LOGIC;
	 SIGNAL  nl00ll :	STD_LOGIC;
	 SIGNAL  nl010i :	STD_LOGIC;
	 SIGNAL  nl010l :	STD_LOGIC;
	 SIGNAL  nl011i :	STD_LOGIC;
	 SIGNAL  nl01il :	STD_LOGIC;
	 SIGNAL  nl01ll :	STD_LOGIC;
	 SIGNAL  nl01lO :	STD_LOGIC;
	 SIGNAL  nl01Oi :	STD_LOGIC;
	 SIGNAL  nl100i :	STD_LOGIC;
	 SIGNAL  nl101l :	STD_LOGIC;
	 SIGNAL  nl101O :	STD_LOGIC;
	 SIGNAL  nl10ii :	STD_LOGIC;
	 SIGNAL  nl10il :	STD_LOGIC;
	 SIGNAL  nl10iO :	STD_LOGIC;
	 SIGNAL  nl10lO :	STD_LOGIC;
	 SIGNAL  nl10Oi :	STD_LOGIC;
	 SIGNAL  nl110i :	STD_LOGIC;
	 SIGNAL  nl110l :	STD_LOGIC;
	 SIGNAL  nl110O :	STD_LOGIC;
	 SIGNAL  nl111i :	STD_LOGIC;
	 SIGNAL  nl111l :	STD_LOGIC;
	 SIGNAL  nl111O :	STD_LOGIC;
	 SIGNAL  nl11ii :	STD_LOGIC;
	 SIGNAL  nl11il :	STD_LOGIC;
	 SIGNAL  nl11iO :	STD_LOGIC;
	 SIGNAL  nl11li :	STD_LOGIC;
	 SIGNAL  nl11ll :	STD_LOGIC;
	 SIGNAL  nl11lO :	STD_LOGIC;
	 SIGNAL  nl11Oi :	STD_LOGIC;
	 SIGNAL  nl11Ol :	STD_LOGIC;
	 SIGNAL  nl1i0l :	STD_LOGIC;
	 SIGNAL  nl1i1i :	STD_LOGIC;
	 SIGNAL  nl1i1l :	STD_LOGIC;
	 SIGNAL  nl1ili :	STD_LOGIC;
	 SIGNAL  nl1ill :	STD_LOGIC;
	 SIGNAL  nl1iOl :	STD_LOGIC;
	 SIGNAL  nl1iOO :	STD_LOGIC;
	 SIGNAL  nl1l0O :	STD_LOGIC;
	 SIGNAL  nl1l1i :	STD_LOGIC;
	 SIGNAL  nl1l1l :	STD_LOGIC;
	 SIGNAL  nl1l1O :	STD_LOGIC;
	 SIGNAL  nl1liO :	STD_LOGIC;
	 SIGNAL  nl1lli :	STD_LOGIC;
	 SIGNAL  nl1lll :	STD_LOGIC;
	 SIGNAL  nl1llO :	STD_LOGIC;
	 SIGNAL  nl1lOO :	STD_LOGIC;
	 SIGNAL  nl1O0i :	STD_LOGIC;
	 SIGNAL  nl1O0l :	STD_LOGIC;
	 SIGNAL  nl1O0O :	STD_LOGIC;
	 SIGNAL  nl1O1O :	STD_LOGIC;
	 SIGNAL  nl1OiO :	STD_LOGIC;
	 SIGNAL  nl1Oli :	STD_LOGIC;
	 SIGNAL  nl1Oll :	STD_LOGIC;
	 SIGNAL  nl1OlO :	STD_LOGIC;
	 SIGNAL  nl1OOO :	STD_LOGIC;
	 SIGNAL  wire_w_txctrl_range2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_txctrl_range35w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_txctrl_range63w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_txctrl_range95w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_txdatain_range192w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_txdatain_range180w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_txdatain_range179w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_txdatain_range191w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_txdatain_range172w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_txdatain_range1125w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_txdatain_range188w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_txdatain_range187w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_gnd <= '0';
	wire_w89w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w_lg_w75w77w79w81w84w86w(0) AND nl1l0i35;
	wire_w_lg_w_lg_w_lg_w_lg_w_lg_w17w20w22w24w26w29w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w17w20w22w24w26w(0) AND nl01iO11;
	wire_w_lg_w_lg_w_lg_w_lg_w_lg_w47w49w51w53w55w58w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w47w49w51w53w55w(0) AND nl1Oii23;
	wire_w_lg_w_lg_w_lg_w_lg_w_lg_w75w77w79w81w84w86w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w75w77w79w81w84w(0) AND wire_w_lg_nl1l0O85w(0);
	wire_w_lg_w_lg_w_lg_w_lg_w17w20w22w24w26w(0) <= wire_w_lg_w_lg_w_lg_w17w20w22w24w(0) AND wire_w_lg_nl01ll25w(0);
	wire_w_lg_w_lg_w_lg_w_lg_w47w49w51w53w55w(0) <= wire_w_lg_w_lg_w_lg_w47w49w51w53w(0) AND wire_w_lg_nl1OiO54w(0);
	wire_w_lg_w_lg_w_lg_w_lg_w75w77w79w81w84w(0) <= wire_w_lg_w_lg_w_lg_w75w77w79w81w(0) AND nl1lii32;
	wire_w_lg_w_lg_w_lg_w17w20w22w24w(0) <= wire_w_lg_w_lg_w17w20w22w(0) AND wire_w_lg_nl01lO23w(0);
	wire_w_lg_w_lg_w_lg_w47w49w51w53w(0) <= wire_w_lg_w_lg_w47w49w51w(0) AND wire_w_lg_nl1Oli52w(0);
	wire_w_lg_w_lg_w_lg_w75w77w79w81w(0) <= wire_w_lg_w_lg_w75w77w79w(0) AND wire_w_lg_nl1liO80w(0);
	wire_w_lg_w_lg_w17w20w22w(0) <= wire_w_lg_w17w20w(0) AND wire_w_lg_nl01Oi21w(0);
	wire_w_lg_w_lg_w118w120w123w(0) <= wire_w_lg_w118w120w(0) AND nl10Ol50;
	wire_w_lg_w_lg_w47w49w51w(0) <= wire_w_lg_w47w49w(0) AND wire_w_lg_nl1Oll50w(0);
	wire_w_lg_w_lg_w75w77w79w(0) <= wire_w_lg_w75w77w(0) AND wire_w_lg_nl1lli78w(0);
	wire_w_lg_w17w20w(0) <= wire_w17w(0) AND nl01Ol8;
	wire_w_lg_w118w120w(0) <= wire_w118w(0) AND wire_w_lg_nl1i1i119w(0);
	wire_w_lg_w47w49w(0) <= wire_w47w(0) AND wire_w_lg_nl1OlO48w(0);
	wire_w_lg_w75w77w(0) <= wire_w75w(0) AND wire_w_lg_nl1lll76w(0);
	wire_w17w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w_lg_nl00ll1w8w10w13w15w(0) AND wire_w_lg_nl001i16w(0);
	wire_w118w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w_lg_nl1iOO94w108w111w113w116w(0) AND wire_w_lg_nl1i1l117w(0);
	wire_w47w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w_txctrl_range35w37w40w42w44w(0) AND nl1OOi20;
	wire_w75w(0) <= wire_w_lg_w_lg_w_lg_w_lg_w_txctrl_range63w65w68w70w73w(0) AND wire_w_lg_nl1llO74w(0);
	wire_w_lg_w104w107w(0) <= wire_w104w(0) AND nl1iil41;
	wire_w_lg_w_lg_w_lg_w_lg_w_lg_nl00ll1w8w10w13w15w(0) <= wire_w_lg_w_lg_w_lg_w_lg_nl00ll1w8w10w13w(0) AND wire_w_lg_nl001l14w(0);
	wire_w_lg_w_lg_w_lg_w_lg_w_lg_nl1iOO94w108w111w113w116w(0) <= wire_w_lg_w_lg_w_lg_w_lg_nl1iOO94w108w111w113w(0) AND nl1i1O47;
	wire_w_lg_w_lg_w_lg_w_lg_w_txctrl_range35w37w40w42w44w(0) <= wire_w_lg_w_lg_w_lg_w_txctrl_range35w37w40w42w(0) AND wire_w_lg_nl1OOO43w(0);
	wire_w_lg_w_lg_w_lg_w_lg_w_txctrl_range63w65w68w70w73w(0) <= wire_w_lg_w_lg_w_lg_w_txctrl_range63w65w68w70w(0) AND nl1lOi29;
	wire_w104w(0) <= wire_w_lg_w_lg_w_lg_w_txctrl_range95w97w100w102w(0) AND wire_w_lg_nl1ili103w(0);
	wire_w_lg_w_lg_w_lg_w_lg_nl00ll1w8w10w13w(0) <= wire_w_lg_w_lg_w_lg_nl00ll1w8w10w(0) AND nl001O5;
	wire_w_lg_w_lg_w_lg_w_lg_nl1iOO94w108w111w113w(0) <= wire_w_lg_w_lg_w_lg_nl1iOO94w108w111w(0) AND wire_w_lg_nl1i0l112w(0);
	wire_w_lg_w_lg_w_lg_w_txctrl_range35w37w40w42w(0) <= wire_w_lg_w_lg_w_txctrl_range35w37w40w(0) AND wire_w_lg_nl011i41w(0);
	wire_w_lg_w_lg_w_lg_w_txctrl_range63w65w68w70w(0) <= wire_w_lg_w_lg_w_txctrl_range63w65w68w(0) AND wire_w_lg_nl1lOO69w(0);
	wire_w_lg_w_lg_w_lg_w_txctrl_range95w97w100w102w(0) <= wire_w_lg_w_lg_w_txctrl_range95w97w100w(0) AND wire_w_lg_nl1ill101w(0);
	wire_w_lg_w_lg_w_lg_nl00ll1w8w10w(0) <= wire_w_lg_w_lg_nl00ll1w8w(0) AND wire_w_lg_nl000l9w(0);
	wire_w_lg_w_lg_w_lg_nl1iOO94w108w111w(0) <= wire_w_lg_w_lg_nl1iOO94w108w(0) AND nl1i0O44;
	wire_w_lg_w_lg_w_txctrl_range2w4w7w(0) <= wire_w_lg_w_txctrl_range2w4w(0) AND nl000O2;
	wire_w_lg_w_lg_w_txctrl_range35w37w40w(0) <= wire_w_lg_w_txctrl_range35w37w(0) AND nl011l17;
	wire_w_lg_w_lg_w_txctrl_range63w65w68w(0) <= wire_w_lg_w_txctrl_range63w65w(0) AND nl1O1i26;
	wire_w_lg_w_lg_w_txctrl_range95w97w100w(0) <= wire_w_lg_w_txctrl_range95w97w(0) AND nl1ilO38;
	wire_w_lg_w_lg_nl00ll1w8w(0) <= wire_w_lg_nl00ll1w(0) AND wire_w_lg_w_lg_w_txctrl_range2w4w7w(0);
	wire_w_lg_w_lg_nl11ii193w194w(0) <= wire_w_lg_nl11ii193w(0) AND nl11il;
	wire_w_lg_w_lg_nl1iOO94w108w(0) <= wire_w_lg_nl1iOO94w(0) AND wire_w_lg_w104w107w(0);
	wire_w_lg_w_lg_rdenablesync249w250w(0) <= wire_w_lg_rdenablesync249w(0) AND nl111l;
	wire_w_lg_nl110i257w(0) <= nl110i AND wire_w_lg_nl11ii256w(0);
	wire_w_lg_nl11il253w(0) <= nl11il AND wire_w_lg_rdenablesync252w(0);
	wire_w_lg_rdenablesync252w(0) <= rdenablesync AND nl111l;
	wire_w_lg_w_txctrl_range2w4w(0) <= wire_w_txctrl_range2w(0) AND wire_w_lg_nl00il3w(0);
	wire_w_lg_w_txctrl_range35w37w(0) <= wire_w_txctrl_range35w(0) AND wire_w_lg_nl010i36w(0);
	wire_w_lg_w_txctrl_range63w65w(0) <= wire_w_txctrl_range63w(0) AND wire_w_lg_nl1O1O64w(0);
	wire_w_lg_w_txctrl_range95w97w(0) <= wire_w_txctrl_range95w(0) AND wire_w_lg_nl1iOl96w(0);
	wire_w_lg_w_txdatain_range192w1526w(0) <= wire_w_txdatain_range192w(0) AND wire_w_lg_w_txdatain_range191w1525w(0);
	wire_w_lg_w_txdatain_range180w1540w(0) <= wire_w_txdatain_range180w(0) AND wire_w_lg_w_txdatain_range179w1480w(0);
	wire_w_lg_w_txdatain_range172w1673w(0) <= wire_w_txdatain_range172w(0) AND wire_w_lg_w_txdatain_range1125w1489w(0);
	wire_w_lg_w_txdatain_range188w1533w(0) <= wire_w_txdatain_range188w(0) AND wire_w_lg_w_txdatain_range187w1471w(0);
	wire_w_lg_nl000l9w(0) <= NOT nl000l;
	wire_w_lg_nl001i16w(0) <= NOT nl001i;
	wire_w_lg_nl001l14w(0) <= NOT nl001l;
	wire_w_lg_nl00il3w(0) <= NOT nl00il;
	wire_w_lg_nl00ll1w(0) <= NOT nl00ll;
	wire_w_lg_nl010i36w(0) <= NOT nl010i;
	wire_w_lg_nl011i41w(0) <= NOT nl011i;
	wire_w_lg_nl01il30w(0) <= NOT nl01il;
	wire_w_lg_nl01ll25w(0) <= NOT nl01ll;
	wire_w_lg_nl01lO23w(0) <= NOT nl01lO;
	wire_w_lg_nl01Oi21w(0) <= NOT nl01Oi;
	wire_w_lg_nl10ii1120w(0) <= NOT nl10ii;
	wire_w_lg_nl10lO126w(0) <= NOT nl10lO;
	wire_w_lg_nl10Oi124w(0) <= NOT nl10Oi;
	wire_w_lg_nl111i259w(0) <= NOT nl111i;
	wire_w_lg_nl111O260w(0) <= NOT nl111O;
	wire_w_lg_nl11ii193w(0) <= NOT nl11ii;
	wire_w_lg_nl11li1121w(0) <= NOT nl11li;
	wire_w_lg_nl1i0l112w(0) <= NOT nl1i0l;
	wire_w_lg_nl1i1i119w(0) <= NOT nl1i1i;
	wire_w_lg_nl1i1l117w(0) <= NOT nl1i1l;
	wire_w_lg_nl1ili103w(0) <= NOT nl1ili;
	wire_w_lg_nl1ill101w(0) <= NOT nl1ill;
	wire_w_lg_nl1iOl96w(0) <= NOT nl1iOl;
	wire_w_lg_nl1iOO94w(0) <= NOT nl1iOO;
	wire_w_lg_nl1l0O85w(0) <= NOT nl1l0O;
	wire_w_lg_nl1l1l92w(0) <= NOT nl1l1l;
	wire_w_lg_nl1l1O90w(0) <= NOT nl1l1O;
	wire_w_lg_nl1liO80w(0) <= NOT nl1liO;
	wire_w_lg_nl1lli78w(0) <= NOT nl1lli;
	wire_w_lg_nl1lll76w(0) <= NOT nl1lll;
	wire_w_lg_nl1llO74w(0) <= NOT nl1llO;
	wire_w_lg_nl1lOO69w(0) <= NOT nl1lOO;
	wire_w_lg_nl1O0l61w(0) <= NOT nl1O0l;
	wire_w_lg_nl1O0O59w(0) <= NOT nl1O0O;
	wire_w_lg_nl1O1O64w(0) <= NOT nl1O1O;
	wire_w_lg_nl1OiO54w(0) <= NOT nl1OiO;
	wire_w_lg_nl1Oli52w(0) <= NOT nl1Oli;
	wire_w_lg_nl1Oll50w(0) <= NOT nl1Oll;
	wire_w_lg_nl1OlO48w(0) <= NOT nl1OlO;
	wire_w_lg_nl1OOO43w(0) <= NOT nl1OOO;
	wire_w_lg_rdenablesync249w(0) <= NOT rdenablesync;
	wire_w_lg_resetall152w(0) <= NOT resetall;
	wire_w_lg_w_txdatain_range179w1480w(0) <= NOT wire_w_txdatain_range179w(0);
	wire_w_lg_w_txdatain_range191w1525w(0) <= NOT wire_w_txdatain_range191w(0);
	wire_w_lg_w_txdatain_range1125w1489w(0) <= NOT wire_w_txdatain_range1125w(0);
	wire_w_lg_w_txdatain_range187w1471w(0) <= NOT wire_w_txdatain_range187w(0);
	wire_w_lg_w_lg_w_lg_rdenablesync249w250w251w(0) <= wire_w_lg_w_lg_rdenablesync249w250w(0) OR wire_nll1l_o;
	wire_w_lg_nl11ii256w(0) <= nl11ii OR wire_nllilO_w_lg_nll0ll255w(0);
	niOOil <= (((((((wire_nllOii_o(15) OR wire_nllOii_o(14)) OR wire_nllOii_o(13)) OR wire_nllOii_o(12)) OR wire_nllOii_o(11)) OR wire_nllOii_o(10)) OR wire_nllOii_o(9)) OR wire_nllOii_o(0));
	niOOiO <= (nl11lO OR niOOll);
	niOOli <= (((((((wire_nllOii_o(15) OR wire_nllOii_o(14)) OR wire_nllOii_o(13)) OR wire_nllOii_o(12)) OR wire_nllOii_o(11)) OR wire_nllOii_o(10)) OR wire_nllOii_o(9)) OR wire_nllOii_o(0));
	niOOll <= (nl101O OR nl11Ol);
	niOOlO <= (((((((wire_nllOii_o(15) OR wire_nllOii_o(14)) OR wire_nllOii_o(13)) OR wire_nllOii_o(12)) OR wire_nllOii_o(11)) OR wire_nllOii_o(10)) OR wire_nllOii_o(9)) OR wire_nllOii_o(0));
	niOOOi <= (((((((((wire_nllOii_o(15) OR wire_nllOii_o(14)) OR wire_nllOii_o(13)) OR wire_nllOii_o(12)) OR wire_nllOii_o(11)) OR wire_nllOii_o(10)) OR wire_nllOii_o(9)) OR wire_nllOii_o(0)) OR wire_nllOii_o(4)) OR wire_nllOii_o(3));
	niOOOl <= (((((((wire_nllOii_o(15) OR wire_nllOii_o(14)) OR wire_nllOii_o(13)) OR wire_nllOii_o(12)) OR wire_nllOii_o(11)) OR wire_nllOii_o(10)) OR wire_nllOii_o(9)) OR wire_nllOii_o(0));
	niOOOO <= ((((((((wire_nllOii_o(15) OR wire_nllOii_o(14)) OR wire_nllOii_o(13)) OR wire_nllOii_o(12)) OR wire_nllOii_o(11)) OR wire_nllOii_o(10)) OR wire_nllOii_o(9)) OR wire_nllOii_o(0)) OR wire_nllOii_o(1));
	nl000l <= (((((((txdatain(0) AND txdatain(1)) AND (NOT txdatain(2))) AND txdatain(3)) AND txdatain(4)) AND txdatain(5)) AND txdatain(6)) AND txdatain(7));
	nl001i <= ((((((((NOT txdatain(0)) AND wire_w_lg_w_txdatain_range191w1525w(0)) AND txdatain(2)) AND txdatain(3)) AND txdatain(4)) AND txdatain(5)) AND (NOT txdatain(6))) AND (NOT txdatain(7)));
	nl001l <= ((((((wire_w_lg_w_txdatain_range192w1526w(0) AND txdatain(2)) AND txdatain(3)) AND txdatain(4)) AND txdatain(5)) AND txdatain(6)) AND txdatain(7));
	nl00il <= (((((((txdatain(0) AND txdatain(1)) AND txdatain(2)) AND (NOT txdatain(3))) AND (NOT txdatain(4))) AND (NOT txdatain(5))) AND (NOT txdatain(6))) AND (NOT txdatain(7)));
	nl00ll <= ((((((((NOT txdatain(0)) AND wire_w_lg_w_txdatain_range191w1525w(0)) AND txdatain(2)) AND txdatain(3)) AND txdatain(4)) AND (NOT txdatain(5))) AND (NOT txdatain(6))) AND txdatain(7));
	nl010i <= (((((((txdatain(8) AND txdatain(9)) AND txdatain(10)) AND (NOT txdatain(11))) AND (NOT txdatain(12))) AND (NOT txdatain(13))) AND (NOT txdatain(14))) AND (NOT txdatain(15)));
	nl010l <= ((wire_w_lg_w_lg_w_lg_w_lg_w_lg_w17w20w22w24w26w29w(0) AND wire_w_lg_nl01il30w(0)) AND nl010O14);
	nl011i <= ((((((((NOT txdatain(8)) AND wire_w_lg_w_txdatain_range187w1471w(0)) AND txdatain(10)) AND txdatain(11)) AND txdatain(12)) AND (NOT txdatain(13))) AND (NOT txdatain(14))) AND txdatain(15));
	nl01il <= (((((((txdatain(0) AND txdatain(1)) AND txdatain(2)) AND (NOT txdatain(3))) AND txdatain(4)) AND txdatain(5)) AND txdatain(6)) AND txdatain(7));
	nl01ll <= ((((((((NOT txdatain(0)) AND wire_w_lg_w_txdatain_range191w1525w(0)) AND txdatain(2)) AND txdatain(3)) AND txdatain(4)) AND txdatain(5)) AND txdatain(6)) AND txdatain(7));
	nl01lO <= ((((((((NOT txdatain(0)) AND wire_w_lg_w_txdatain_range191w1525w(0)) AND txdatain(2)) AND txdatain(3)) AND txdatain(4)) AND (NOT txdatain(5))) AND txdatain(6)) AND txdatain(7));
	nl01Oi <= ((((((((NOT txdatain(0)) AND wire_w_lg_w_txdatain_range191w1525w(0)) AND txdatain(2)) AND txdatain(3)) AND txdatain(4)) AND (NOT txdatain(5))) AND txdatain(6)) AND (NOT txdatain(7)));
	nl100i <= ((((((((((((((((((((((((((((((wire_w_lg_w_txdatain_range192w1526w(0) AND txdatain(2)) AND txdatain(3)) AND txdatain(4)) AND txdatain(5)) AND txdatain(6)) AND txdatain(7)) AND txdatain(8)) AND txdatain(9)) AND txdatain(10)) AND (NOT txdatain(11))) AND (NOT txdatain(12))) AND (NOT txdatain(13))) AND (NOT txdatain(14))) AND (NOT txdatain(15))) AND txdatain(16)) AND txdatain(17)) AND txdatain(18)) AND (NOT txdatain(19))) AND (NOT txdatain(20))) AND (NOT txdatain(21))) AND (NOT txdatain(22))) AND (NOT txdatain(23))) AND txdatain(24)) AND txdatain(25)) AND txdatain(26)) AND (NOT txdatain(27))) AND (NOT txdatain(28))) AND (NOT txdatain(29))) AND (NOT txdatain(30))) AND (NOT txdatain(31)));
	nl101l <= ((((((((((((((((((((((wire_w_lg_w_txdatain_range188w1533w(0) AND txdatain(10)) AND txdatain(11)) AND txdatain(12)) AND txdatain(13)) AND txdatain(14)) AND txdatain(15)) AND txdatain(16)) AND txdatain(17)) AND txdatain(18)) AND (NOT txdatain(19))) AND (NOT txdatain(20))) AND (NOT txdatain(21))) AND (NOT txdatain(22))) AND (NOT txdatain(23))) AND txdatain(24)) AND txdatain(25)) AND txdatain(26)) AND (NOT txdatain(27))) AND (NOT txdatain(28))) AND (NOT txdatain(29))) AND (NOT txdatain(30))) AND (NOT txdatain(31)));
	nl101O <= (((((txctrl(3) AND txctrl(2)) AND txctrl(1)) AND txctrl(0)) AND nl100l56) AND nl100i);
	nl10ii <= ((((txctrl(3) AND txctrl(2)) AND txctrl(1)) AND txctrl(0)) AND nl10il);
	nl10il <= (((((((((((((((((((((((((((((((txdatain(0) AND txdatain(1)) AND txdatain(2)) AND (NOT txdatain(3))) AND (NOT txdatain(4))) AND (NOT txdatain(5))) AND (NOT txdatain(6))) AND (NOT txdatain(7))) AND txdatain(8)) AND txdatain(9)) AND txdatain(10)) AND (NOT txdatain(11))) AND (NOT txdatain(12))) AND (NOT txdatain(13))) AND (NOT txdatain(14))) AND (NOT txdatain(15))) AND txdatain(16)) AND txdatain(17)) AND txdatain(18)) AND (NOT txdatain(19))) AND (NOT txdatain(20))) AND (NOT txdatain(21))) AND (NOT txdatain(22))) AND (NOT txdatain(23))) AND txdatain(24)) AND txdatain(25)) AND txdatain(26)) AND (NOT txdatain(27))) AND (NOT txdatain(28))) AND (NOT txdatain(29))) AND (NOT txdatain(30))) AND (NOT txdatain(31)));
	nl10iO <= (((wire_w_lg_w_lg_w118w120w123w(0) AND wire_w_lg_nl10Oi124w(0)) AND wire_w_lg_nl10lO126w(0)) AND nl10li53);
	nl10lO <= (((((((txdatain(24) AND txdatain(25)) AND txdatain(26)) AND (NOT txdatain(27))) AND txdatain(28)) AND txdatain(29)) AND txdatain(30)) AND txdatain(31));
	nl10Oi <= ((((((((NOT txdatain(24)) AND wire_w_lg_w_txdatain_range1125w1489w(0)) AND txdatain(26)) AND txdatain(27)) AND txdatain(28)) AND txdatain(29)) AND txdatain(30)) AND txdatain(31));
	nl110i <= (nl11il AND nl110O);
	nl110l <= (wire_w_lg_w_lg_nl11ii193w194w(0) AND (((wire_ni1i_w_lg_w_lg_w_lg_nlliOl154w160w161w(0) AND wire_nllilO_w_lg_nllill158w(0)) OR wire_ni1i_w_lg_w_lg_w_lg_w_lg_nlliOl154w160w197w198w(0)) OR (nll0ll AND nl110O)));
	nl110O <= ((wire_ni1i_w_lg_w_lg_nlliOl154w156w(0) AND wire_nllilO_w_lg_nlliOi196w(0)) AND nllill);
	nl111i <= (wire_w_lg_nl10ii1120w(0) AND wire_w_lg_nl11li1121w(0));
	nl111l <= (wire_ni1i_w_lg_w_lg_w_lg_nlliOl154w156w157w(0) AND nllill);
	nl111O <= (wire_w_lg_nl11ii193w(0) AND nll0ll);
	nl11ii <= ((((nllil OR nllii) OR nll0O) OR nll0l) OR nll0lO);
	nl11il <= (nl10ii OR nl11li);
	nl11iO <= '1';
	nl11li <= (((((NOT txctrl(3)) AND (NOT txctrl(2))) AND (NOT txctrl(1))) AND txctrl(0)) AND nl00ll);
	nl11ll <= (txctrl(3) AND nl1iOO);
	nl11lO <= ((txctrl(3) AND txctrl(2)) AND nl11Oi);
	nl11Oi <= ((((((((((((((wire_w_lg_w_txdatain_range180w1540w(0) AND txdatain(18)) AND txdatain(19)) AND txdatain(20)) AND txdatain(21)) AND txdatain(22)) AND txdatain(23)) AND txdatain(24)) AND txdatain(25)) AND txdatain(26)) AND (NOT txdatain(27))) AND (NOT txdatain(28))) AND (NOT txdatain(29))) AND (NOT txdatain(30))) AND (NOT txdatain(31)));
	nl11Ol <= ((((txctrl(3) AND txctrl(2)) AND txctrl(1)) AND nl101l) AND nl11OO59);
	nl1i0l <= ((((((((NOT txdatain(24)) AND wire_w_lg_w_txdatain_range1125w1489w(0)) AND txdatain(26)) AND txdatain(27)) AND txdatain(28)) AND txdatain(29)) AND (NOT txdatain(30))) AND (NOT txdatain(31)));
	nl1i1i <= ((((((((NOT txdatain(24)) AND wire_w_lg_w_txdatain_range1125w1489w(0)) AND txdatain(26)) AND txdatain(27)) AND txdatain(28)) AND (NOT txdatain(29))) AND txdatain(30)) AND txdatain(31));
	nl1i1l <= ((((((((NOT txdatain(24)) AND wire_w_lg_w_txdatain_range1125w1489w(0)) AND txdatain(26)) AND txdatain(27)) AND txdatain(28)) AND (NOT txdatain(29))) AND txdatain(30)) AND (NOT txdatain(31)));
	nl1ili <= (((((((txdatain(24) AND txdatain(25)) AND (NOT txdatain(26))) AND txdatain(27)) AND txdatain(28)) AND txdatain(29)) AND txdatain(30)) AND txdatain(31));
	nl1ill <= ((((((((NOT txdatain(24)) AND wire_w_lg_w_txdatain_range1125w1489w(0)) AND txdatain(26)) AND txdatain(27)) AND txdatain(28)) AND (NOT txdatain(29))) AND (NOT txdatain(30))) AND txdatain(31));
	nl1iOl <= (((((((txdatain(24) AND txdatain(25)) AND txdatain(26)) AND (NOT txdatain(27))) AND (NOT txdatain(28))) AND (NOT txdatain(29))) AND (NOT txdatain(30))) AND (NOT txdatain(31)));
	nl1iOO <= ((((((wire_w_lg_w_txdatain_range172w1673w(0) AND txdatain(26)) AND txdatain(27)) AND txdatain(28)) AND txdatain(29)) AND txdatain(30)) AND txdatain(31));
	nl1l0O <= ((((((((NOT txdatain(16)) AND wire_w_lg_w_txdatain_range179w1480w(0)) AND txdatain(18)) AND txdatain(19)) AND txdatain(20)) AND (NOT txdatain(21))) AND txdatain(22)) AND txdatain(23));
	nl1l1i <= ((wire_w89w(0) AND wire_w_lg_nl1l1O90w(0)) AND wire_w_lg_nl1l1l92w(0));
	nl1l1l <= (((((((txdatain(16) AND txdatain(17)) AND txdatain(18)) AND (NOT txdatain(19))) AND txdatain(20)) AND txdatain(21)) AND txdatain(22)) AND txdatain(23));
	nl1l1O <= ((((((((NOT txdatain(16)) AND wire_w_lg_w_txdatain_range179w1480w(0)) AND txdatain(18)) AND txdatain(19)) AND txdatain(20)) AND txdatain(21)) AND txdatain(22)) AND txdatain(23));
	nl1liO <= ((((((((NOT txdatain(16)) AND wire_w_lg_w_txdatain_range179w1480w(0)) AND txdatain(18)) AND txdatain(19)) AND txdatain(20)) AND (NOT txdatain(21))) AND txdatain(22)) AND (NOT txdatain(23)));
	nl1lli <= ((((((((NOT txdatain(16)) AND wire_w_lg_w_txdatain_range179w1480w(0)) AND txdatain(18)) AND txdatain(19)) AND txdatain(20)) AND txdatain(21)) AND (NOT txdatain(22))) AND (NOT txdatain(23)));
	nl1lll <= ((((((wire_w_lg_w_txdatain_range180w1540w(0) AND txdatain(18)) AND txdatain(19)) AND txdatain(20)) AND txdatain(21)) AND txdatain(22)) AND txdatain(23));
	nl1llO <= (((((((txdatain(16) AND txdatain(17)) AND (NOT txdatain(18))) AND txdatain(19)) AND txdatain(20)) AND txdatain(21)) AND txdatain(22)) AND txdatain(23));
	nl1lOO <= ((((((((NOT txdatain(16)) AND wire_w_lg_w_txdatain_range179w1480w(0)) AND txdatain(18)) AND txdatain(19)) AND txdatain(20)) AND (NOT txdatain(21))) AND (NOT txdatain(22))) AND txdatain(23));
	nl1O0i <= ((wire_w_lg_w_lg_w_lg_w_lg_w_lg_w47w49w51w53w55w58w(0) AND wire_w_lg_nl1O0O59w(0)) AND wire_w_lg_nl1O0l61w(0));
	nl1O0l <= (((((((txdatain(8) AND txdatain(9)) AND txdatain(10)) AND (NOT txdatain(11))) AND txdatain(12)) AND txdatain(13)) AND txdatain(14)) AND txdatain(15));
	nl1O0O <= ((((((((NOT txdatain(8)) AND wire_w_lg_w_txdatain_range187w1471w(0)) AND txdatain(10)) AND txdatain(11)) AND txdatain(12)) AND txdatain(13)) AND txdatain(14)) AND txdatain(15));
	nl1O1O <= (((((((txdatain(16) AND txdatain(17)) AND txdatain(18)) AND (NOT txdatain(19))) AND (NOT txdatain(20))) AND (NOT txdatain(21))) AND (NOT txdatain(22))) AND (NOT txdatain(23)));
	nl1OiO <= ((((((((NOT txdatain(8)) AND wire_w_lg_w_txdatain_range187w1471w(0)) AND txdatain(10)) AND txdatain(11)) AND txdatain(12)) AND (NOT txdatain(13))) AND txdatain(14)) AND txdatain(15));
	nl1Oli <= ((((((((NOT txdatain(8)) AND wire_w_lg_w_txdatain_range187w1471w(0)) AND txdatain(10)) AND txdatain(11)) AND txdatain(12)) AND (NOT txdatain(13))) AND txdatain(14)) AND (NOT txdatain(15)));
	nl1Oll <= ((((((((NOT txdatain(8)) AND wire_w_lg_w_txdatain_range187w1471w(0)) AND txdatain(10)) AND txdatain(11)) AND txdatain(12)) AND txdatain(13)) AND (NOT txdatain(14))) AND (NOT txdatain(15)));
	nl1OlO <= ((((((wire_w_lg_w_txdatain_range188w1533w(0) AND txdatain(10)) AND txdatain(11)) AND txdatain(12)) AND txdatain(13)) AND txdatain(14)) AND txdatain(15));
	nl1OOO <= (((((((txdatain(8) AND txdatain(9)) AND (NOT txdatain(10))) AND txdatain(11)) AND txdatain(12)) AND txdatain(13)) AND txdatain(14)) AND txdatain(15));
	txctrlout <= ( nll11l & nll1il & nll1Ol & nll00l);
	txdataout <= ( nll1ii & nlll1l & nll10O & nll10l & nll10i & nll11O & nlll1i & nlliOO & nll1Oi & nlOO0O & nll1lO & nll1ll & nll1li & nll1iO & nlOO0l & nlOO0i & nll00i & n011O & nll01O & nll01l & nll01i & nll1OO & n011l & n011i & nll0li & ni1OO & nll0iO & nll0il & nll0ii & nll00O & ni1Ol & ni1Oi);
	wire_w_txctrl_range2w(0) <= txctrl(0);
	wire_w_txctrl_range35w(0) <= txctrl(1);
	wire_w_txctrl_range63w(0) <= txctrl(2);
	wire_w_txctrl_range95w(0) <= txctrl(3);
	wire_w_txdatain_range192w(0) <= txdatain(0);
	wire_w_txdatain_range180w(0) <= txdatain(16);
	wire_w_txdatain_range179w(0) <= txdatain(17);
	wire_w_txdatain_range191w(0) <= txdatain(1);
	wire_w_txdatain_range172w(0) <= txdatain(24);
	wire_w_txdatain_range1125w(0) <= txdatain(25);
	wire_w_txdatain_range188w(0) <= txdatain(8);
	wire_w_txdatain_range187w(0) <= txdatain(9);
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl000O1 <= nl000O3;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl000O2 <= (nl000O3 XOR nl000O1);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl000O3 <= nl000O1;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl001O4 <= nl001O6;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl001O5 <= (nl001O6 XOR nl001O4);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl001O6 <= nl001O4;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl010O13 <= nl010O15;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl010O14 <= (nl010O15 XOR nl010O13);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl010O15 <= nl010O13;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl011l16 <= nl011l18;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl011l17 <= (nl011l18 XOR nl011l16);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl011l18 <= nl011l16;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl01iO10 <= nl01iO12;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl01iO11 <= (nl01iO12 XOR nl01iO10);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl01iO12 <= nl01iO10;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl01Ol7 <= nl01Ol9;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl01Ol8 <= (nl01Ol9 XOR nl01Ol7);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl01Ol9 <= nl01Ol7;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl100l55 <= nl100l57;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl100l56 <= (nl100l57 XOR nl100l55);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl100l57 <= nl100l55;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl10li52 <= nl10li54;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl10li53 <= (nl10li54 XOR nl10li52);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl10li54 <= nl10li52;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl10Ol49 <= nl10Ol51;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl10Ol50 <= (nl10Ol51 XOR nl10Ol49);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl10Ol51 <= nl10Ol49;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl11OO58 <= nl11OO60;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl11OO59 <= (nl11OO60 XOR nl11OO58);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl11OO60 <= nl11OO58;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1i0O43 <= nl1i0O45;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1i0O44 <= (nl1i0O45 XOR nl1i0O43);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1i0O45 <= nl1i0O43;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1i1O46 <= nl1i1O48;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1i1O47 <= (nl1i1O48 XOR nl1i1O46);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1i1O48 <= nl1i1O46;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1iil40 <= nl1iil42;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1iil41 <= (nl1iil42 XOR nl1iil40);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1iil42 <= nl1iil40;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1ilO37 <= nl1ilO39;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1ilO38 <= (nl1ilO39 XOR nl1ilO37);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1ilO39 <= nl1ilO37;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1l0i34 <= nl1l0i36;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1l0i35 <= (nl1l0i36 XOR nl1l0i34);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1l0i36 <= nl1l0i34;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1lii31 <= nl1lii33;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1lii32 <= (nl1lii33 XOR nl1lii31);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1lii33 <= nl1lii31;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1lOi28 <= nl1lOi30;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1lOi29 <= (nl1lOi30 XOR nl1lOi28);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1lOi30 <= nl1lOi28;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1O1i25 <= nl1O1i27;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1O1i26 <= (nl1O1i27 XOR nl1O1i25);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1O1i27 <= nl1O1i25;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1Oii22 <= nl1Oii24;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1Oii23 <= (nl1Oii24 XOR nl1Oii22);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1Oii24 <= nl1Oii22;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1OOi19 <= nl1OOi21;
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1OOi20 <= (nl1OOi21 XOR nl1OOi19);
		END IF;
	END PROCESS;
	PROCESS (txclk)
	BEGIN
		IF (txclk = '1' AND txclk'event) THEN nl1OOi21 <= nl1OOi19;
		END IF;
	END PROCESS;
	PROCESS (txclk, resetall)
	BEGIN
		IF (resetall = '1') THEN
				n00i <= '0';
				n00l <= '0';
				n00O <= '0';
				n01i <= '0';
				n01l <= '0';
				n01O <= '0';
				n0il <= '0';
				n10i <= '0';
				n10l <= '0';
				n10O <= '0';
				n11i <= '0';
				n11l <= '0';
				n11O <= '0';
				n1ii <= '0';
				n1il <= '0';
				n1iO <= '0';
				n1li <= '0';
				n1ll <= '0';
				n1lO <= '0';
				n1Oi <= '0';
				n1Ol <= '0';
				n1OO <= '0';
				nlOll <= '0';
				nlOlO <= '0';
				nlOOi <= '0';
				nlOOl <= '0';
				nlOOO <= '0';
		ELSIF (txclk = '1' AND txclk'event) THEN
			IF (nl11li = '1') THEN
				n00i <= txdatain(28);
				n00l <= txdatain(29);
				n00O <= txdatain(30);
				n01i <= txdatain(24);
				n01l <= txdatain(26);
				n01O <= txdatain(27);
				n0il <= txdatain(31);
				n10i <= txdatain(12);
				n10l <= txdatain(13);
				n10O <= txdatain(14);
				n11i <= txdatain(9);
				n11l <= txdatain(10);
				n11O <= txdatain(11);
				n1ii <= txdatain(15);
				n1il <= txdatain(16);
				n1iO <= txdatain(17);
				n1li <= txdatain(18);
				n1ll <= txdatain(19);
				n1lO <= txdatain(20);
				n1Oi <= txdatain(21);
				n1Ol <= txdatain(22);
				n1OO <= txdatain(23);
				nlOll <= txdatain(0);
				nlOlO <= txdatain(1);
				nlOOi <= txdatain(5);
				nlOOl <= txdatain(6);
				nlOOO <= txdatain(8);
			END IF;
		END IF;
	END PROCESS;
	PROCESS (txclk, resetall)
	BEGIN
		IF (resetall = '1') THEN
				n011i <= '0';
				n011l <= '0';
				n011O <= '0';
				n0OO <= '0';
				ni1l <= '0';
				ni1Oi <= '0';
				ni1Ol <= '0';
				ni1OO <= '0';
				nll0l <= '0';
				nll0O <= '0';
				nllii <= '0';
				nllil <= '0';
				nlliOl <= '0';
				nlliOO <= '0';
				nlll1i <= '0';
				nlll1l <= '0';
				nlOO0i <= '0';
				nlOO0l <= '0';
				nlOO0O <= '0';
		ELSIF (txclk = '1' AND txclk'event) THEN
				n011i <= wire_n010l_dataout;
				n011l <= wire_n010O_dataout;
				n011O <= wire_n01ll_dataout;
				n0OO <= wire_n0iO_dataout;
				ni1l <= wire_nl00i_o;
				ni1Oi <= wire_ni01l_dataout;
				ni1Ol <= wire_ni01O_dataout;
				ni1OO <= wire_ni0il_dataout;
				nll0l <= wire_nlliO_dataout;
				nll0O <= wire_nllli_dataout;
				nllii <= wire_nllll_dataout;
				nllil <= wire_nlllO_dataout;
				nlliOl <= wire_nl00O_dataout;
				nlliOO <= wire_nlll0i_dataout;
				nlll1i <= wire_nlll0l_dataout;
				nlll1l <= wire_nlllli_dataout;
				nlOO0i <= wire_nlOOil_dataout;
				nlOO0l <= wire_nlOOiO_dataout;
				nlOO0O <= wire_nlOOOl_dataout;
		END IF;
	END PROCESS;
	wire_ni1i_w_lg_w_lg_w_lg_w_lg_nlliOl154w160w197w198w(0) <= wire_ni1i_w_lg_w_lg_w_lg_nlliOl154w160w197w(0) AND nllill;
	wire_ni1i_w_lg_w_lg_w_lg_w_lg_nlliOl154w160w161w162w(0) <= wire_ni1i_w_lg_w_lg_w_lg_nlliOl154w160w161w(0) AND nllill;
	wire_ni1i_w_lg_w_lg_w_lg_nlliOl154w156w157w(0) <= wire_ni1i_w_lg_w_lg_nlliOl154w156w(0) AND nlliOi;
	wire_ni1i_w_lg_w_lg_w_lg_nlliOl154w160w197w(0) <= wire_ni1i_w_lg_w_lg_nlliOl154w160w(0) AND wire_nllilO_w_lg_nlliOi196w(0);
	wire_ni1i_w_lg_w_lg_w_lg_nlliOl154w160w161w(0) <= wire_ni1i_w_lg_w_lg_nlliOl154w160w(0) AND nlliOi;
	wire_ni1i_w_lg_w_lg_nlliOl154w156w(0) <= wire_ni1i_w_lg_nlliOl154w(0) AND wire_ni1i_w_lg_ni1l155w(0);
	wire_ni1i_w_lg_w_lg_nlliOl154w160w(0) <= wire_ni1i_w_lg_nlliOl154w(0) AND ni1l;
	wire_ni1i_w_lg_n0OO261w(0) <= NOT n0OO;
	wire_ni1i_w_lg_ni1l155w(0) <= NOT ni1l;
	wire_ni1i_w_lg_nlliOl154w(0) <= NOT nlliOl;
	PROCESS (txclk, resetall)
	BEGIN
		IF (resetall = '1') THEN
				nlli0l <= '1';
				nlli0O <= '1';
				nlliii <= '1';
				nlliil <= '1';
				nllili <= '1';
		ELSIF (txclk = '1' AND txclk'event) THEN
			IF (nl11li = '1') THEN
				nlli0l <= txdatain(2);
				nlli0O <= txdatain(3);
				nlliii <= txdatain(4);
				nlliil <= txdatain(7);
				nllili <= txdatain(25);
			END IF;
		END IF;
	END PROCESS;
	PROCESS (txclk, resetall)
	BEGIN
		IF (resetall = '1') THEN
				nll00i <= '1';
				nll00l <= '1';
				nll00O <= '1';
				nll01i <= '1';
				nll01l <= '1';
				nll01O <= '1';
				nll0ii <= '1';
				nll0il <= '1';
				nll0iO <= '1';
				nll0li <= '1';
				nll0ll <= '1';
				nll0lO <= '1';
				nll0Oi <= '1';
				nll0Ol <= '1';
				nll0OO <= '1';
				nll10i <= '1';
				nll10l <= '1';
				nll10O <= '1';
				nll11l <= '1';
				nll11O <= '1';
				nll1ii <= '1';
				nll1il <= '1';
				nll1iO <= '1';
				nll1li <= '1';
				nll1ll <= '1';
				nll1lO <= '1';
				nll1Oi <= '1';
				nll1Ol <= '1';
				nll1OO <= '1';
				nlli0i <= '1';
				nlli1i <= '1';
				nlli1l <= '1';
				nlli1O <= '1';
				nllill <= '1';
				nlliOi <= '1';
		ELSIF (txclk = '1' AND txclk'event) THEN
				nll00i <= wire_n01lO_dataout;
				nll00l <= wire_ni01i_dataout;
				nll00O <= wire_ni00i_dataout;
				nll01i <= wire_n01il_dataout;
				nll01l <= wire_n01iO_dataout;
				nll01O <= wire_n01li_dataout;
				nll0ii <= wire_ni00l_dataout;
				nll0il <= wire_ni00O_dataout;
				nll0iO <= wire_ni0ii_dataout;
				nll0li <= wire_ni0iO_dataout;
				nll0ll <= wire_nli0O_dataout;
				nll0lO <= wire_nllOi_dataout;
				nll0Oi <= (nlli0i XOR nlli1O);
				nll0Ol <= nll0Oi;
				nll0OO <= nll0Ol;
				nll10i <= wire_nlllii_dataout;
				nll10l <= wire_nlllil_dataout;
				nll10O <= wire_nllliO_dataout;
				nll11l <= wire_nlll1O_dataout;
				nll11O <= wire_nlll0O_dataout;
				nll1ii <= wire_nlllll_dataout;
				nll1il <= wire_nlOOii_dataout;
				nll1iO <= wire_nlOOli_dataout;
				nll1li <= wire_nlOOll_dataout;
				nll1ll <= wire_nlOOlO_dataout;
				nll1lO <= wire_nlOOOi_dataout;
				nll1Oi <= wire_nlOOOO_dataout;
				nll1Ol <= wire_n010i_dataout;
				nll1OO <= wire_n01ii_dataout;
				nlli0i <= nlli1O;
				nlli1i <= nll0OO;
				nlli1l <= nlli1i;
				nlli1O <= nlli1l;
				nllill <= wire_nl1OO_o;
				nlliOi <= wire_nl01l_o;
		END IF;
	END PROCESS;
	wire_nllilO_w_lg_nll0ll255w(0) <= NOT nll0ll;
	wire_nllilO_w_lg_nll0Oi262w(0) <= NOT nll0Oi;
	wire_nllilO_w_lg_nllill158w(0) <= NOT nllill;
	wire_nllilO_w_lg_nlliOi196w(0) <= NOT nlliOi;
	wire_n00il_dataout <= wire_n0i1l_dataout OR NOT(nl111i);
	wire_n00iO_dataout <= wire_n0i1O_dataout AND nl111i;
	wire_n00li_dataout <= wire_n0i0i_dataout AND nl111i;
	wire_n00ll_dataout <= wire_n0i0l_dataout OR NOT(nl111i);
	wire_n00lO_dataout <= wire_n0i0O_dataout OR NOT(nl111i);
	wire_n00Oi_dataout <= wire_n0iii_dataout OR NOT(nl111i);
	wire_n00Ol_dataout <= wire_n0iil_dataout WHEN nl111i = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_n00OO_dataout <= wire_n0iiO_dataout AND nl111i;
	wire_n010i_dataout <= wire_n01Oi_o OR nl1O0i;
	wire_n010l_dataout <= wire_n01Ol_o AND NOT(nl1O0i);
	wire_n010O_dataout <= wire_n01OO_o OR nl1O0i;
	wire_n01ii_dataout <= wire_n001i_o OR nl1O0i;
	wire_n01il_dataout <= wire_n001l_o OR nl1O0i;
	wire_n01iO_dataout <= wire_n001O_o OR nl1O0i;
	wire_n01li_dataout <= wire_n000i_o OR nl1O0i;
	wire_n01ll_dataout <= wire_n000l_o OR nl1O0i;
	wire_n01lO_dataout <= wire_n000O_o OR nl1O0i;
	wire_n0i0i_dataout <= wire_n0iOi_dataout AND NOT(nl101O);
	wire_n0i0l_dataout <= wire_n0iOl_dataout OR nl101O;
	wire_n0i0O_dataout <= wire_n0iOO_dataout OR nl101O;
	wire_n0i1i_dataout <= wire_n0ili_dataout WHEN nl111i = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_n0i1l_dataout <= wire_n0ill_dataout OR nl101O;
	wire_n0i1O_dataout <= wire_n0ilO_dataout AND NOT(nl101O);
	wire_n0iii_dataout <= wire_n0l1i_dataout OR nl101O;
	wire_n0iil_dataout <= wire_n0l1l_dataout OR nl101O;
	wire_n0iiO_dataout <= wire_n0l1O_dataout AND NOT(nl101O);
	wire_n0ili_dataout <= wire_n0l0i_dataout OR nl101O;
	wire_n0ill_dataout <= txctrl(1) OR nl11Ol;
	wire_n0ilO_dataout <= txdatain(8) OR nl11Ol;
	wire_n0iO_dataout <= wire_n0li_dataout OR nl11li;
	wire_n0iOi_dataout <= txdatain(9) AND NOT(nl11Ol);
	wire_n0iOl_dataout <= txdatain(10) OR nl11Ol;
	wire_n0iOO_dataout <= txdatain(11) OR nl11Ol;
	wire_n0l0i_dataout <= txdatain(15) OR nl11Ol;
	wire_n0l0l_dataout <= wire_n0i1l_dataout WHEN nl111i = '1'  ELSE wire_ni1i_w_lg_n0OO261w(0);
	wire_n0l0O_dataout <= wire_n0i1O_dataout WHEN nl111i = '1'  ELSE wire_n0lOl_dataout;
	wire_n0l1i_dataout <= txdatain(12) OR nl11Ol;
	wire_n0l1l_dataout <= txdatain(13) OR nl11Ol;
	wire_n0l1O_dataout <= txdatain(14) OR nl11Ol;
	wire_n0li_dataout <= n0OO AND NOT((n0OO AND (((wire_ni1i_w_lg_w_lg_w_lg_nlliOl154w156w157w(0) AND wire_nllilO_w_lg_nllill158w(0)) OR wire_ni1i_w_lg_w_lg_w_lg_w_lg_nlliOl154w160w161w162w(0)) AND nl11il)));
	wire_n0lii_dataout <= wire_n0i0i_dataout WHEN nl111i = '1'  ELSE wire_n0lOO_dataout;
	wire_n0lil_dataout <= wire_n0i0l_dataout WHEN nl111i = '1'  ELSE wire_n0O1i_dataout;
	wire_n0liO_dataout <= wire_n0i0O_dataout WHEN nl111i = '1'  ELSE wire_n0O1l_dataout;
	wire_n0lli_dataout <= wire_n0iii_dataout WHEN nl111i = '1'  ELSE wire_n0O1O_dataout;
	wire_n0lll_dataout <= wire_n0iil_dataout WHEN nl111i = '1'  ELSE wire_n0O0i_dataout;
	wire_n0llO_dataout <= wire_n0iiO_dataout WHEN nl111i = '1'  ELSE wire_n0O0l_dataout;
	wire_n0lOi_dataout <= wire_n0ili_dataout WHEN nl111i = '1'  ELSE wire_n0O0O_dataout;
	wire_n0lOl_dataout <= nlOOO AND n0OO;
	wire_n0lOO_dataout <= n11i AND n0OO;
	wire_n0O0i_dataout <= n10l WHEN n0OO = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_n0O0l_dataout <= n10O AND n0OO;
	wire_n0O0O_dataout <= n1ii WHEN n0OO = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_n0O1i_dataout <= n11l OR NOT(n0OO);
	wire_n0O1l_dataout <= n11O OR NOT(n0OO);
	wire_n0O1O_dataout <= n10i OR NOT(n0OO);
	wire_n0Oii_dataout <= wire_n0iil_dataout WHEN nl111i = '1'  ELSE wire_nlOiOi_dataout;
	wire_n0Oil_dataout <= wire_n0iiO_dataout WHEN nl111i = '1'  ELSE wire_w_lg_nl11ii193w(0);
	wire_n0OiO_dataout <= wire_n0ili_dataout WHEN nl111i = '1'  ELSE wire_nlOiOl_dataout;
	wire_n0Oli_dataout <= wire_n0iil_dataout AND nl111i;
	wire_n0Oll_dataout <= wire_n0ili_dataout AND nl111i;
	wire_n0OlO_dataout <= wire_n0iil_dataout WHEN nl111i = '1'  ELSE wire_n0OOl_dataout;
	wire_n0OOi_dataout <= wire_n0ili_dataout WHEN nl111i = '1'  ELSE wire_n0OOO_dataout;
	wire_n0OOl_dataout <= n10l AND n0OO;
	wire_n0OOO_dataout <= n1ii AND n0OO;
	wire_n100i_dataout <= wire_n10Oi_dataout WHEN nl111i = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_n100l_dataout <= wire_n10Ol_dataout OR niOOll;
	wire_n100O_dataout <= wire_n10OO_dataout AND NOT(niOOll);
	wire_n101i_dataout <= wire_n10li_dataout OR NOT(nl111i);
	wire_n101l_dataout <= wire_n10ll_dataout WHEN nl111i = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_n101O_dataout <= wire_n10lO_dataout AND nl111i;
	wire_n10ii_dataout <= wire_n1i1i_dataout AND NOT(niOOll);
	wire_n10il_dataout <= wire_n1i1l_dataout OR niOOll;
	wire_n10iO_dataout <= wire_n1i1O_dataout OR niOOll;
	wire_n10li_dataout <= wire_n1i0i_dataout OR niOOll;
	wire_n10ll_dataout <= wire_n1i0l_dataout OR niOOll;
	wire_n10lO_dataout <= wire_n1i0O_dataout AND NOT(niOOll);
	wire_n10Oi_dataout <= wire_n1iii_dataout OR niOOll;
	wire_n10Ol_dataout <= txctrl(2) OR nl11lO;
	wire_n10OO_dataout <= txdatain(16) OR nl11lO;
	wire_n11ll_dataout <= wire_n100l_dataout OR NOT(nl111i);
	wire_n11lO_dataout <= wire_n100O_dataout AND nl111i;
	wire_n11Oi_dataout <= wire_n10ii_dataout AND nl111i;
	wire_n11Ol_dataout <= wire_n10il_dataout OR NOT(nl111i);
	wire_n11OO_dataout <= wire_n10iO_dataout OR NOT(nl111i);
	wire_n1i0i_dataout <= txdatain(20) OR nl11lO;
	wire_n1i0l_dataout <= txdatain(21) OR nl11lO;
	wire_n1i0O_dataout <= txdatain(22) OR nl11lO;
	wire_n1i1i_dataout <= txdatain(17) AND NOT(nl11lO);
	wire_n1i1l_dataout <= txdatain(18) OR nl11lO;
	wire_n1i1O_dataout <= txdatain(19) OR nl11lO;
	wire_n1iii_dataout <= txdatain(23) OR nl11lO;
	wire_n1iil_dataout <= wire_n100l_dataout WHEN nl111i = '1'  ELSE wire_ni1i_w_lg_n0OO261w(0);
	wire_n1iiO_dataout <= wire_n100O_dataout WHEN nl111i = '1'  ELSE wire_n1l1l_dataout;
	wire_n1ili_dataout <= wire_n10ii_dataout WHEN nl111i = '1'  ELSE wire_n1l1O_dataout;
	wire_n1ill_dataout <= wire_n10il_dataout WHEN nl111i = '1'  ELSE wire_n1l0i_dataout;
	wire_n1ilO_dataout <= wire_n10iO_dataout WHEN nl111i = '1'  ELSE wire_n1l0l_dataout;
	wire_n1iOi_dataout <= wire_n10li_dataout WHEN nl111i = '1'  ELSE wire_n1l0O_dataout;
	wire_n1iOl_dataout <= wire_n10ll_dataout WHEN nl111i = '1'  ELSE wire_n1lii_dataout;
	wire_n1iOO_dataout <= wire_n10lO_dataout WHEN nl111i = '1'  ELSE wire_n1lil_dataout;
	wire_n1l0i_dataout <= n1li OR NOT(n0OO);
	wire_n1l0l_dataout <= n1ll OR NOT(n0OO);
	wire_n1l0O_dataout <= n1lO OR NOT(n0OO);
	wire_n1l1i_dataout <= wire_n10Oi_dataout WHEN nl111i = '1'  ELSE wire_n1liO_dataout;
	wire_n1l1l_dataout <= n1il AND n0OO;
	wire_n1l1O_dataout <= n1iO AND n0OO;
	wire_n1lii_dataout <= n1Oi WHEN n0OO = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_n1lil_dataout <= n1Ol AND n0OO;
	wire_n1liO_dataout <= n1OO WHEN n0OO = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_n1lli_dataout <= wire_n10ll_dataout WHEN nl111i = '1'  ELSE wire_nlOiOi_dataout;
	wire_n1lll_dataout <= wire_n10lO_dataout WHEN nl111i = '1'  ELSE wire_w_lg_nl11ii193w(0);
	wire_n1llO_dataout <= wire_n10Oi_dataout WHEN nl111i = '1'  ELSE wire_nlOiOl_dataout;
	wire_n1lOi_dataout <= wire_n10ll_dataout AND nl111i;
	wire_n1lOl_dataout <= wire_n10Oi_dataout AND nl111i;
	wire_n1lOO_dataout <= wire_n10ll_dataout WHEN nl111i = '1'  ELSE wire_n1O1l_dataout;
	wire_n1O0i_dataout <= wire_n10ll_dataout OR NOT(nl111i);
	wire_n1O0l_dataout <= wire_n10lO_dataout WHEN nl111i = '1'  ELSE nl111O;
	wire_n1O0O_dataout <= wire_n10Oi_dataout WHEN nl111i = '1'  ELSE wire_w_lg_nl111O260w(0);
	wire_n1O1i_dataout <= wire_n10Oi_dataout WHEN nl111i = '1'  ELSE wire_n1O1O_dataout;
	wire_n1O1l_dataout <= n1Oi AND n0OO;
	wire_n1O1O_dataout <= n1OO AND n0OO;
	wire_n1Oii_dataout <= wire_n11ll_dataout OR NOT(rdenablesync);
	wire_n1Oil_dataout <= wire_n11lO_dataout AND rdenablesync;
	wire_n1OiO_dataout <= wire_n11Oi_dataout AND rdenablesync;
	wire_n1Oli_dataout <= wire_n11Ol_dataout OR NOT(rdenablesync);
	wire_n1Oll_dataout <= wire_n11OO_dataout OR NOT(rdenablesync);
	wire_n1OlO_dataout <= wire_n101i_dataout OR NOT(rdenablesync);
	wire_n1OOi_dataout <= wire_n1lOi_dataout OR NOT(rdenablesync);
	wire_n1OOl_dataout <= wire_n101O_dataout AND rdenablesync;
	wire_n1OOO_dataout <= wire_n1lOl_dataout OR NOT(rdenablesync);
	wire_ni00i_dataout <= wire_ni0Oi_o OR nl010l;
	wire_ni00l_dataout <= wire_ni0Ol_o OR nl010l;
	wire_ni00O_dataout <= wire_ni0OO_o OR nl010l;
	wire_ni01i_dataout <= wire_ni0li_o OR nl010l;
	wire_ni01l_dataout <= wire_ni0ll_o AND NOT(nl010l);
	wire_ni01O_dataout <= wire_ni0lO_o OR nl010l;
	wire_ni0ii_dataout <= wire_nii1i_o OR nl010l;
	wire_ni0il_dataout <= wire_nii1l_o OR nl010l;
	wire_ni0iO_dataout <= wire_nii1O_o OR nl010l;
	wire_ni10i_dataout <= wire_n00il_dataout OR NOT(rdenablesync);
	wire_ni10l_dataout <= wire_n00iO_dataout AND rdenablesync;
	wire_ni10O_dataout <= wire_n00li_dataout AND rdenablesync;
	wire_ni11i_dataout <= wire_n0iil_dataout OR NOT(nl111i);
	wire_ni11l_dataout <= wire_n0iiO_dataout WHEN nl111i = '1'  ELSE nl111O;
	wire_ni11O_dataout <= wire_n0ili_dataout WHEN nl111i = '1'  ELSE wire_w_lg_nl111O260w(0);
	wire_ni1ii_dataout <= wire_n00ll_dataout OR NOT(rdenablesync);
	wire_ni1il_dataout <= wire_n00lO_dataout OR NOT(rdenablesync);
	wire_ni1iO_dataout <= wire_n00Oi_dataout OR NOT(rdenablesync);
	wire_ni1li_dataout <= wire_n0Oli_dataout OR NOT(rdenablesync);
	wire_ni1ll_dataout <= wire_n00OO_dataout AND rdenablesync;
	wire_ni1lO_dataout <= wire_n0Oll_dataout OR NOT(rdenablesync);
	wire_nii0l_dataout <= wire_niiOl_dataout OR NOT(nl111i);
	wire_nii0O_dataout <= wire_niiOO_dataout AND nl111i;
	wire_niiii_dataout <= wire_nil1i_dataout AND nl111i;
	wire_niiil_dataout <= wire_nil1l_dataout OR NOT(nl111i);
	wire_niiiO_dataout <= wire_nil1O_dataout OR NOT(nl111i);
	wire_niili_dataout <= wire_nil0i_dataout OR NOT(nl111i);
	wire_niill_dataout <= wire_nil0l_dataout WHEN nl111i = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_niilO_dataout <= wire_nil0O_dataout AND nl111i;
	wire_niiOi_dataout <= wire_nilii_dataout WHEN nl111i = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_niiOl_dataout <= txctrl(0) OR nl101O;
	wire_niiOO_dataout <= txdatain(0) OR nl101O;
	wire_nil0i_dataout <= txdatain(4) OR nl101O;
	wire_nil0l_dataout <= txdatain(5) OR nl101O;
	wire_nil0O_dataout <= txdatain(6) OR nl101O;
	wire_nil1i_dataout <= txdatain(1) AND NOT(nl101O);
	wire_nil1l_dataout <= txdatain(2) OR nl101O;
	wire_nil1O_dataout <= txdatain(3) OR nl101O;
	wire_nilii_dataout <= txdatain(7) OR nl101O;
	wire_nilil_dataout <= wire_niiOO_dataout WHEN nl111i = '1'  ELSE wire_niO1i_dataout;
	wire_niliO_dataout <= wire_nil1i_dataout WHEN nl111i = '1'  ELSE wire_niO1l_dataout;
	wire_nilli_dataout <= wire_nil1l_dataout WHEN nl111i = '1'  ELSE wire_niO1O_dataout;
	wire_nilll_dataout <= wire_nil1O_dataout WHEN nl111i = '1'  ELSE wire_niO0i_dataout;
	wire_nillO_dataout <= wire_nil0i_dataout WHEN nl111i = '1'  ELSE wire_niO0l_dataout;
	wire_nilOi_dataout <= wire_nil0l_dataout WHEN nl111i = '1'  ELSE wire_niO0O_dataout;
	wire_nilOl_dataout <= wire_nil0O_dataout WHEN nl111i = '1'  ELSE wire_niOii_dataout;
	wire_nilOO_dataout <= wire_nilii_dataout WHEN nl111i = '1'  ELSE wire_niOil_dataout;
	wire_niO0i_dataout <= nlli0O OR NOT(n0OO);
	wire_niO0l_dataout <= nlliii OR NOT(n0OO);
	wire_niO0O_dataout <= nlOOi WHEN n0OO = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_niO1i_dataout <= nlOll AND n0OO;
	wire_niO1l_dataout <= nlOlO AND n0OO;
	wire_niO1O_dataout <= nlli0l OR NOT(n0OO);
	wire_niOii_dataout <= nlOOl AND n0OO;
	wire_niOil_dataout <= nlliil WHEN n0OO = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_niOiO_dataout <= wire_nil0l_dataout WHEN nl111i = '1'  ELSE wire_nlOiOi_dataout;
	wire_niOli_dataout <= wire_nil0O_dataout WHEN nl111i = '1'  ELSE wire_w_lg_nl11ii193w(0);
	wire_niOll_dataout <= wire_nilii_dataout WHEN nl111i = '1'  ELSE wire_nlOiOl_dataout;
	wire_niOlO_dataout <= wire_nil0l_dataout AND nl111i;
	wire_niOOi_dataout <= wire_nilii_dataout AND nl111i;
	wire_niOOl_dataout <= wire_nil0l_dataout WHEN nl111i = '1'  ELSE wire_nl11i_dataout;
	wire_niOOO_dataout <= wire_nilii_dataout WHEN nl111i = '1'  ELSE wire_nl11l_dataout;
	wire_nl00O_dataout <= wire_nl0lO_dataout AND wire_nllOii_o(7);
	wire_nl0ii_dataout <= nll0Oi OR nl111i;
	wire_nl0il_dataout <= wire_nllilO_w_lg_nll0Oi262w(0) AND NOT(nl111i);
	wire_nl0iO_dataout <= wire_nl0Oi_dataout OR nl111i;
	wire_nl0li_dataout <= wire_nl0Ol_dataout AND NOT(nl111i);
	wire_nl0ll_dataout <= wire_ni1i_w_lg_n0OO261w(0) AND NOT(nl111i);
	wire_nl0lO_dataout <= n0OO AND NOT(nl111i);
	wire_nl0Oi_dataout <= nll0Oi AND NOT(n0OO);
	wire_nl0Ol_dataout <= wire_nllilO_w_lg_nll0Oi262w(0) AND NOT(n0OO);
	wire_nl0OO_dataout <= wire_nli1l_dataout OR nl111i;
	wire_nl10i_dataout <= wire_nil0O_dataout WHEN nl111i = '1'  ELSE nl111O;
	wire_nl10l_dataout <= wire_nilii_dataout WHEN nl111i = '1'  ELSE wire_w_lg_nl111O260w(0);
	wire_nl10O_dataout <= wire_nii0l_dataout OR NOT(rdenablesync);
	wire_nl11i_dataout <= nlOOi AND n0OO;
	wire_nl11l_dataout <= nlliil AND n0OO;
	wire_nl11O_dataout <= wire_nil0l_dataout OR NOT(nl111i);
	wire_nl1ii_dataout <= wire_nii0O_dataout AND rdenablesync;
	wire_nl1il_dataout <= wire_niiii_dataout AND rdenablesync;
	wire_nl1iO_dataout <= wire_niiil_dataout OR NOT(rdenablesync);
	wire_nl1li_dataout <= wire_niiiO_dataout OR NOT(rdenablesync);
	wire_nl1ll_dataout <= wire_niili_dataout OR NOT(rdenablesync);
	wire_nl1lO_dataout <= wire_niOlO_dataout OR NOT(rdenablesync);
	wire_nl1Oi_dataout <= wire_niilO_dataout AND rdenablesync;
	wire_nl1Ol_dataout <= wire_niOOi_dataout OR NOT(rdenablesync);
	wire_nli0i_dataout <= wire_w_lg_nl111O260w(0) OR nl111i;
	wire_nli0l_dataout <= wire_w_lg_nl111i259w(0) AND rdenablesync;
	wire_nli0O_dataout <= wire_nliii_dataout OR ((wire_w_lg_w_lg_w_lg_rdenablesync249w250w251w(0) OR wire_w_lg_nl11il253w(0)) OR wire_w_lg_nl110i257w(0));
	wire_nli1i_dataout <= wire_nlOiOi_dataout AND NOT(nl111i);
	wire_nli1l_dataout <= nll0Oi OR wire_w_lg_nl11ii193w(0);
	wire_nli1O_dataout <= wire_ni1i_w_lg_n0OO261w(0) OR nl111i;
	wire_nliii_dataout <= nll0ll AND NOT((nl111O AND nl110i));
	wire_nlliO_dataout <= nll0Oi WHEN nl110l = '1'  ELSE wire_nllOl_dataout;
	wire_nlll0i_dataout <= wire_nlllOi_o AND NOT(nl10iO);
	wire_nlll0l_dataout <= wire_nlllOl_o OR nl10iO;
	wire_nlll0O_dataout <= wire_nlllOO_o OR nl10iO;
	wire_nlll1O_dataout <= wire_nllllO_o OR nl10iO;
	wire_nllli_dataout <= nll0Ol WHEN nl110l = '1'  ELSE wire_nllOO_dataout;
	wire_nlllii_dataout <= wire_nllO1i_o OR nl10iO;
	wire_nlllil_dataout <= wire_nllO1l_o OR nl10iO;
	wire_nllliO_dataout <= wire_nllO1O_o OR nl10iO;
	wire_nllll_dataout <= nll0OO WHEN nl110l = '1'  ELSE wire_nlO1i_dataout;
	wire_nlllli_dataout <= wire_nllO0i_o OR nl10iO;
	wire_nlllll_dataout <= wire_nllO0l_o OR nl10iO;
	wire_nlllO_dataout <= nlli1i WHEN nl110l = '1'  ELSE wire_nlO1l_dataout;
	wire_nllOi_dataout <= wire_nlO1O_dataout OR nl110l;
	wire_nllOil_dataout <= wire_nlO11l_dataout OR NOT(nl111i);
	wire_nllOiO_dataout <= wire_nlO11O_dataout AND nl111i;
	wire_nllOl_dataout <= wire_nlO0i_o(1) WHEN nl11ii = '1'  ELSE nll0l;
	wire_nllOli_dataout <= wire_nlO10i_dataout AND nl111i;
	wire_nllOll_dataout <= wire_nlO10l_dataout OR NOT(nl111i);
	wire_nllOlO_dataout <= wire_nlO10O_dataout OR NOT(nl111i);
	wire_nllOO_dataout <= wire_nlO0i_o(2) WHEN nl11ii = '1'  ELSE nll0O;
	wire_nllOOi_dataout <= wire_nlO1ii_dataout OR NOT(nl111i);
	wire_nllOOl_dataout <= wire_nlO1il_dataout WHEN nl111i = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_nllOOO_dataout <= wire_nlO1iO_dataout AND nl111i;
	wire_nlO00i_dataout <= txdatain(31) OR nl11ll;
	wire_nlO01i_dataout <= txdatain(28) OR nl11ll;
	wire_nlO01l_dataout <= txdatain(29) OR nl11ll;
	wire_nlO01O_dataout <= txdatain(30) OR nl11ll;
	wire_nlO0il_dataout <= wire_nlO11l_dataout WHEN nl111i = '1'  ELSE wire_ni1i_w_lg_n0OO261w(0);
	wire_nlO0iO_dataout <= wire_nlO11O_dataout WHEN nl111i = '1'  ELSE wire_nlOi1l_dataout;
	wire_nlO0li_dataout <= wire_nlO10i_dataout WHEN nl111i = '1'  ELSE wire_nlOi1O_dataout;
	wire_nlO0ll_dataout <= wire_nlO10l_dataout WHEN nl111i = '1'  ELSE wire_nlOi0i_dataout;
	wire_nlO0lO_dataout <= wire_nlO10O_dataout WHEN nl111i = '1'  ELSE wire_nlOi0l_dataout;
	wire_nlO0Oi_dataout <= wire_nlO1ii_dataout WHEN nl111i = '1'  ELSE wire_nlOi0O_dataout;
	wire_nlO0Ol_dataout <= wire_nlO1il_dataout WHEN nl111i = '1'  ELSE wire_nlOiii_dataout;
	wire_nlO0OO_dataout <= wire_nlO1iO_dataout WHEN nl111i = '1'  ELSE wire_nlOiil_dataout;
	wire_nlO10i_dataout <= wire_nlO1Oi_dataout AND NOT(niOOiO);
	wire_nlO10l_dataout <= wire_nlO1Ol_dataout OR niOOiO;
	wire_nlO10O_dataout <= wire_nlO1OO_dataout OR niOOiO;
	wire_nlO11i_dataout <= wire_nlO1li_dataout WHEN nl111i = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_nlO11l_dataout <= wire_nlO1ll_dataout OR niOOiO;
	wire_nlO11O_dataout <= wire_nlO1lO_dataout AND NOT(niOOiO);
	wire_nlO1i_dataout <= wire_nlO0i_o(3) WHEN nl11ii = '1'  ELSE nllii;
	wire_nlO1ii_dataout <= wire_nlO01i_dataout OR niOOiO;
	wire_nlO1il_dataout <= wire_nlO01l_dataout OR niOOiO;
	wire_nlO1iO_dataout <= wire_nlO01O_dataout AND NOT(niOOiO);
	wire_nlO1l_dataout <= wire_nlO0i_o(4) WHEN nl11ii = '1'  ELSE nllil;
	wire_nlO1li_dataout <= wire_nlO00i_dataout OR niOOiO;
	wire_nlO1ll_dataout <= txctrl(3) OR nl11ll;
	wire_nlO1lO_dataout <= txdatain(24) OR nl11ll;
	wire_nlO1O_dataout <= wire_nlO0i_o(5) WHEN nl11ii = '1'  ELSE nll0lO;
	wire_nlO1Oi_dataout <= txdatain(25) AND NOT(nl11ll);
	wire_nlO1Ol_dataout <= txdatain(26) OR nl11ll;
	wire_nlO1OO_dataout <= txdatain(27) OR nl11ll;
	wire_nlOi0i_dataout <= n01l OR NOT(n0OO);
	wire_nlOi0l_dataout <= n01O OR NOT(n0OO);
	wire_nlOi0O_dataout <= n00i OR NOT(n0OO);
	wire_nlOi1i_dataout <= wire_nlO1li_dataout WHEN nl111i = '1'  ELSE wire_nlOiiO_dataout;
	wire_nlOi1l_dataout <= n01i AND n0OO;
	wire_nlOi1O_dataout <= nllili AND n0OO;
	wire_nlOiii_dataout <= n00l WHEN n0OO = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_nlOiil_dataout <= n00O AND n0OO;
	wire_nlOiiO_dataout <= n0il WHEN n0OO = '1'  ELSE wire_nllilO_w_lg_nll0Oi262w(0);
	wire_nlOili_dataout <= wire_nlO1il_dataout WHEN nl111i = '1'  ELSE wire_nlOiOi_dataout;
	wire_nlOill_dataout <= wire_nlO1iO_dataout WHEN nl111i = '1'  ELSE wire_w_lg_nl11ii193w(0);
	wire_nlOilO_dataout <= wire_nlO1li_dataout WHEN nl111i = '1'  ELSE wire_nlOiOl_dataout;
	wire_nlOiOi_dataout <= wire_nllilO_w_lg_nll0Oi262w(0) OR wire_w_lg_nl11ii193w(0);
	wire_nlOiOl_dataout <= wire_nllilO_w_lg_nll0Oi262w(0) AND NOT(wire_w_lg_nl11ii193w(0));
	wire_nlOiOO_dataout <= wire_nlO1il_dataout AND nl111i;
	wire_nlOl0i_dataout <= n00l AND n0OO;
	wire_nlOl0l_dataout <= n0il AND n0OO;
	wire_nlOl0O_dataout <= wire_nlO1il_dataout OR NOT(nl111i);
	wire_nlOl1i_dataout <= wire_nlO1li_dataout AND nl111i;
	wire_nlOl1l_dataout <= wire_nlO1il_dataout WHEN nl111i = '1'  ELSE wire_nlOl0i_dataout;
	wire_nlOl1O_dataout <= wire_nlO1li_dataout WHEN nl111i = '1'  ELSE wire_nlOl0l_dataout;
	wire_nlOlii_dataout <= wire_nlO1iO_dataout WHEN nl111i = '1'  ELSE nl111O;
	wire_nlOlil_dataout <= wire_nlO1li_dataout WHEN nl111i = '1'  ELSE wire_w_lg_nl111O260w(0);
	wire_nlOlli_dataout <= wire_nllOil_dataout OR NOT(rdenablesync);
	wire_nlOlll_dataout <= wire_nllOiO_dataout AND rdenablesync;
	wire_nlOllO_dataout <= wire_nllOli_dataout AND rdenablesync;
	wire_nlOlOi_dataout <= wire_nllOll_dataout OR NOT(rdenablesync);
	wire_nlOlOl_dataout <= wire_nllOlO_dataout OR NOT(rdenablesync);
	wire_nlOlOO_dataout <= wire_nllOOi_dataout OR NOT(rdenablesync);
	wire_nlOO1i_dataout <= wire_nlOiOO_dataout OR NOT(rdenablesync);
	wire_nlOO1l_dataout <= wire_nllOOO_dataout AND rdenablesync;
	wire_nlOO1O_dataout <= wire_nlOl1i_dataout OR NOT(rdenablesync);
	wire_nlOOii_dataout <= wire_n111i_o OR nl1l1i;
	wire_nlOOil_dataout <= wire_n111l_o AND NOT(nl1l1i);
	wire_nlOOiO_dataout <= wire_n111O_o OR nl1l1i;
	wire_nlOOli_dataout <= wire_n110i_o OR nl1l1i;
	wire_nlOOll_dataout <= wire_n110l_o OR nl1l1i;
	wire_nlOOlO_dataout <= wire_n110O_o OR nl1l1i;
	wire_nlOOOi_dataout <= wire_n11ii_o OR nl1l1i;
	wire_nlOOOl_dataout <= wire_n11il_o OR nl1l1i;
	wire_nlOOOO_dataout <= wire_n11iO_o OR nl1l1i;
	wire_nlO0i_a <= ( nll0lO & nllil & nllii & nll0O & nll0l & "1");
	wire_nlO0i_b <= ( "1" & "1" & "1" & "1" & "0" & "1");
	nlO0i :  oper_add
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 6,
		width_b => 6,
		width_o => 6
	  )
	  PORT MAP ( 
		a => wire_nlO0i_a,
		b => wire_nlO0i_b,
		cin => wire_gnd,
		o => wire_nlO0i_o
	  );
	wire_nllOii_w_lg_w_o_range287w315w(0) <= wire_nllOii_w_o_range287w(0) OR wire_nllOii_w_o_range281w(0);
	wire_nllOii_i <= ( nlliOl & ni1l & nlliOi & nllill);
	wire_nllOii_w_o_range281w(0) <= wire_nllOii_o(2);
	wire_nllOii_w_o_range287w(0) <= wire_nllOii_o(4);
	nllOii :  oper_decoder
	  GENERIC MAP (
		width_i => 4,
		width_o => 16
	  )
	  PORT MAP ( 
		i => wire_nllOii_i,
		o => wire_nllOii_o
	  );
	wire_nll1l_a <= ( "1" & "0" & "0" & "0");
	wire_nll1l_b <= ( nlliOl & ni1l & nlliOi & nllill);
	nll1l :  oper_less_than
	  GENERIC MAP (
		sgate_representation => 0,
		width_a => 4,
		width_b => 4
	  )
	  PORT MAP ( 
		a => wire_nll1l_a,
		b => wire_nll1l_b,
		cin => wire_gnd,
		o => wire_nll1l_o
	  );
	wire_n000i_data <= ( "1" & wire_n00Ol_dataout & wire_n0lll_dataout & wire_n0Oii_dataout & wire_n0Oii_dataout & wire_n0Oli_dataout & wire_ni1li_dataout & wire_n0OlO_dataout & wire_ni11i_dataout);
	wire_n000i_sel <= ( niOOlO & wire_nllOii_o(8 DOWNTO 1));
	n000i :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n000i_data,
		o => wire_n000i_o,
		sel => wire_n000i_sel
	  );
	wire_n000l_data <= ( "0" & wire_n00OO_dataout & wire_n0llO_dataout & wire_n0Oil_dataout & wire_n0Oil_dataout & wire_n00OO_dataout & wire_ni1ll_dataout & wire_n0llO_dataout & wire_ni11l_dataout);
	wire_n000l_sel <= ( niOOlO & wire_nllOii_o(8 DOWNTO 1));
	n000l :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n000l_data,
		o => wire_n000l_o,
		sel => wire_n000l_sel
	  );
	wire_n000O_data <= ( "1" & wire_n0i1i_dataout & wire_n0lOi_dataout & wire_n0OiO_dataout & wire_n0OiO_dataout & wire_n0Oll_dataout & wire_ni1lO_dataout & wire_n0OOi_dataout & wire_ni11O_dataout);
	wire_n000O_sel <= ( niOOlO & wire_nllOii_o(8 DOWNTO 1));
	n000O :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n000O_data,
		o => wire_n000O_o,
		sel => wire_n000O_sel
	  );
	wire_n001i_data <= ( "1" & wire_n00ll_dataout & wire_n0lil_dataout & wire_n00ll_dataout & wire_n00ll_dataout & wire_n00ll_dataout & wire_ni1ii_dataout & wire_n0lil_dataout & wire_n00ll_dataout);
	wire_n001i_sel <= ( niOOlO & wire_nllOii_o(8 DOWNTO 1));
	n001i :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n001i_data,
		o => wire_n001i_o,
		sel => wire_n001i_sel
	  );
	wire_n001l_data <= ( "1" & wire_n00lO_dataout & wire_n0liO_dataout & wire_n00lO_dataout & wire_n00lO_dataout & wire_n00lO_dataout & wire_ni1il_dataout & wire_n0liO_dataout & wire_n00lO_dataout);
	wire_n001l_sel <= ( niOOlO & wire_nllOii_o(8 DOWNTO 1));
	n001l :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n001l_data,
		o => wire_n001l_o,
		sel => wire_n001l_sel
	  );
	wire_n001O_data <= ( "1" & wire_n00Oi_dataout & wire_n0lli_dataout & wire_n00Oi_dataout & wire_n00Oi_dataout & wire_n00Oi_dataout & wire_ni1iO_dataout & wire_n0lli_dataout & wire_n00Oi_dataout);
	wire_n001O_sel <= ( niOOlO & wire_nllOii_o(8 DOWNTO 1));
	n001O :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n001O_data,
		o => wire_n001O_o,
		sel => wire_n001O_sel
	  );
	wire_n01Oi_data <= ( "1" & wire_n00il_dataout & wire_n0l0l_dataout & wire_n00il_dataout & wire_n00il_dataout & wire_n00il_dataout & wire_ni10i_dataout & wire_n0l0l_dataout & wire_n00il_dataout);
	wire_n01Oi_sel <= ( niOOOl & wire_nllOii_o(8 DOWNTO 1));
	n01Oi :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n01Oi_data,
		o => wire_n01Oi_o,
		sel => wire_n01Oi_sel
	  );
	wire_n01Ol_data <= ( "0" & wire_n00iO_dataout & wire_n0l0O_dataout & wire_n00iO_dataout & wire_n00iO_dataout & wire_n00iO_dataout & wire_ni10l_dataout & wire_n0l0O_dataout & wire_n00iO_dataout);
	wire_n01Ol_sel <= ( niOOlO & wire_nllOii_o(8 DOWNTO 1));
	n01Ol :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n01Ol_data,
		o => wire_n01Ol_o,
		sel => wire_n01Ol_sel
	  );
	wire_n01OO_data <= ( "0" & wire_n00li_dataout & wire_n0lii_dataout & wire_n00li_dataout & wire_n00li_dataout & wire_n00li_dataout & wire_ni10O_dataout & wire_n0lii_dataout & wire_n00li_dataout);
	wire_n01OO_sel <= ( niOOlO & wire_nllOii_o(8 DOWNTO 1));
	n01OO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n01OO_data,
		o => wire_n01OO_o,
		sel => wire_n01OO_sel
	  );
	wire_n110i_data <= ( "1" & wire_n11Ol_dataout & wire_n1ill_dataout & wire_n11Ol_dataout & wire_n11Ol_dataout & wire_n11Ol_dataout & wire_n1Oli_dataout & wire_n1ill_dataout & wire_n11Ol_dataout);
	wire_n110i_sel <= ( niOOli & wire_nllOii_o(8 DOWNTO 1));
	n110i :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n110i_data,
		o => wire_n110i_o,
		sel => wire_n110i_sel
	  );
	wire_n110l_data <= ( "1" & wire_n11OO_dataout & wire_n1ilO_dataout & wire_n11OO_dataout & wire_n11OO_dataout & wire_n11OO_dataout & wire_n1Oll_dataout & wire_n1ilO_dataout & wire_n11OO_dataout);
	wire_n110l_sel <= ( niOOli & wire_nllOii_o(8 DOWNTO 1));
	n110l :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n110l_data,
		o => wire_n110l_o,
		sel => wire_n110l_sel
	  );
	wire_n110O_data <= ( "1" & wire_n101i_dataout & wire_n1iOi_dataout & wire_n101i_dataout & wire_n101i_dataout & wire_n101i_dataout & wire_n1OlO_dataout & wire_n1iOi_dataout & wire_n101i_dataout);
	wire_n110O_sel <= ( niOOli & wire_nllOii_o(8 DOWNTO 1));
	n110O :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n110O_data,
		o => wire_n110O_o,
		sel => wire_n110O_sel
	  );
	wire_n111i_data <= ( "1" & wire_n11ll_dataout & wire_n1iil_dataout & wire_n11ll_dataout & wire_n11ll_dataout & wire_n11ll_dataout & wire_n1Oii_dataout & wire_n1iil_dataout & wire_n11ll_dataout);
	wire_n111i_sel <= ( niOOOl & wire_nllOii_o(8 DOWNTO 1));
	n111i :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n111i_data,
		o => wire_n111i_o,
		sel => wire_n111i_sel
	  );
	wire_n111l_data <= ( "0" & wire_n11lO_dataout & wire_n1iiO_dataout & wire_n11lO_dataout & wire_n11lO_dataout & wire_n11lO_dataout & wire_n1Oil_dataout & wire_n1iiO_dataout & wire_n11lO_dataout);
	wire_n111l_sel <= ( niOOli & wire_nllOii_o(8 DOWNTO 1));
	n111l :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n111l_data,
		o => wire_n111l_o,
		sel => wire_n111l_sel
	  );
	wire_n111O_data <= ( "0" & wire_n11Oi_dataout & wire_n1ili_dataout & wire_n11Oi_dataout & wire_n11Oi_dataout & wire_n11Oi_dataout & wire_n1OiO_dataout & wire_n1ili_dataout & wire_n11Oi_dataout);
	wire_n111O_sel <= ( niOOli & wire_nllOii_o(8 DOWNTO 1));
	n111O :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n111O_data,
		o => wire_n111O_o,
		sel => wire_n111O_sel
	  );
	wire_n11ii_data <= ( "1" & wire_n101l_dataout & wire_n1iOl_dataout & wire_n1lli_dataout & wire_n1lli_dataout & wire_n1lOi_dataout & wire_n1OOi_dataout & wire_n1lOO_dataout & wire_n1O0i_dataout);
	wire_n11ii_sel <= ( niOOli & wire_nllOii_o(8 DOWNTO 1));
	n11ii :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n11ii_data,
		o => wire_n11ii_o,
		sel => wire_n11ii_sel
	  );
	wire_n11il_data <= ( "0" & wire_n101O_dataout & wire_n1iOO_dataout & wire_n1lll_dataout & wire_n1lll_dataout & wire_n101O_dataout & wire_n1OOl_dataout & wire_n1iOO_dataout & wire_n1O0l_dataout);
	wire_n11il_sel <= ( niOOli & wire_nllOii_o(8 DOWNTO 1));
	n11il :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n11il_data,
		o => wire_n11il_o,
		sel => wire_n11il_sel
	  );
	wire_n11iO_data <= ( "1" & wire_n100i_dataout & wire_n1l1i_dataout & wire_n1llO_dataout & wire_n1llO_dataout & wire_n1lOl_dataout & wire_n1OOO_dataout & wire_n1O1i_dataout & wire_n1O0O_dataout);
	wire_n11iO_sel <= ( niOOli & wire_nllOii_o(8 DOWNTO 1));
	n11iO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_n11iO_data,
		o => wire_n11iO_o,
		sel => wire_n11iO_sel
	  );
	wire_ni0li_data <= ( "1" & wire_nii0l_dataout & wire_nii0l_dataout & wire_nii0l_dataout & wire_nii0l_dataout & wire_nii0l_dataout & wire_nl10O_dataout & wire_nii0l_dataout & wire_nii0l_dataout);
	wire_ni0li_sel <= ( niOOOl & wire_nllOii_o(8 DOWNTO 1));
	ni0li :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_ni0li_data,
		o => wire_ni0li_o,
		sel => wire_ni0li_sel
	  );
	wire_ni0ll_data <= ( "0" & wire_nii0O_dataout & wire_nilil_dataout & wire_nii0O_dataout & wire_nii0O_dataout & wire_nii0O_dataout & wire_nl1ii_dataout & wire_nilil_dataout & wire_nii0O_dataout);
	wire_ni0ll_sel <= ( niOOOl & wire_nllOii_o(8 DOWNTO 1));
	ni0ll :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_ni0ll_data,
		o => wire_ni0ll_o,
		sel => wire_ni0ll_sel
	  );
	wire_ni0lO_data <= ( "0" & wire_niiii_dataout & wire_niliO_dataout & wire_niiii_dataout & wire_niiii_dataout & wire_niiii_dataout & wire_nl1il_dataout & wire_niliO_dataout & wire_niiii_dataout);
	wire_ni0lO_sel <= ( niOOOl & wire_nllOii_o(8 DOWNTO 1));
	ni0lO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_ni0lO_data,
		o => wire_ni0lO_o,
		sel => wire_ni0lO_sel
	  );
	wire_ni0Oi_data <= ( "1" & wire_niiil_dataout & wire_nilli_dataout & wire_niiil_dataout & wire_niiil_dataout & wire_niiil_dataout & wire_nl1iO_dataout & wire_nilli_dataout & wire_niiil_dataout);
	wire_ni0Oi_sel <= ( niOOOl & wire_nllOii_o(8 DOWNTO 1));
	ni0Oi :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_ni0Oi_data,
		o => wire_ni0Oi_o,
		sel => wire_ni0Oi_sel
	  );
	wire_ni0Ol_data <= ( "1" & wire_niiiO_dataout & wire_nilll_dataout & wire_niiiO_dataout & wire_niiiO_dataout & wire_niiiO_dataout & wire_nl1li_dataout & wire_nilll_dataout & wire_niiiO_dataout);
	wire_ni0Ol_sel <= ( niOOOl & wire_nllOii_o(8 DOWNTO 1));
	ni0Ol :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_ni0Ol_data,
		o => wire_ni0Ol_o,
		sel => wire_ni0Ol_sel
	  );
	wire_ni0OO_data <= ( "1" & wire_niili_dataout & wire_nillO_dataout & wire_niili_dataout & wire_niili_dataout & wire_niili_dataout & wire_nl1ll_dataout & wire_nillO_dataout & wire_niili_dataout);
	wire_ni0OO_sel <= ( niOOOl & wire_nllOii_o(8 DOWNTO 1));
	ni0OO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_ni0OO_data,
		o => wire_ni0OO_o,
		sel => wire_ni0OO_sel
	  );
	wire_nii1i_data <= ( "1" & wire_niill_dataout & wire_nilOi_dataout & wire_niOiO_dataout & wire_niOiO_dataout & wire_niOlO_dataout & wire_nl1lO_dataout & wire_niOOl_dataout & wire_nl11O_dataout);
	wire_nii1i_sel <= ( niOOOl & wire_nllOii_o(8 DOWNTO 1));
	nii1i :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nii1i_data,
		o => wire_nii1i_o,
		sel => wire_nii1i_sel
	  );
	wire_nii1l_data <= ( "0" & wire_niilO_dataout & wire_nilOl_dataout & wire_niOli_dataout & wire_niOli_dataout & wire_niilO_dataout & wire_nl1Oi_dataout & wire_nilOl_dataout & wire_nl10i_dataout);
	wire_nii1l_sel <= ( niOOOl & wire_nllOii_o(8 DOWNTO 1));
	nii1l :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nii1l_data,
		o => wire_nii1l_o,
		sel => wire_nii1l_sel
	  );
	wire_nii1O_data <= ( "1" & wire_niiOi_dataout & wire_nilOO_dataout & wire_niOll_dataout & wire_niOll_dataout & wire_niOOi_dataout & wire_nl1Ol_dataout & wire_niOOO_dataout & wire_nl10l_dataout);
	wire_nii1O_sel <= ( niOOOl & wire_nllOii_o(8 DOWNTO 1));
	nii1O :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nii1O_data,
		o => wire_nii1O_o,
		sel => wire_nii1O_sel
	  );
	wire_nl00i_data <= ( "0" & wire_w_lg_nl111i259w & wire_nl0ll_dataout & wire_w_lg_nl111i259w & wire_w_lg_nl111i259w & wire_w_lg_nl111i259w & wire_nli0l_dataout & wire_w_lg_nl111i259w);
	wire_nl00i_sel <= ( niOOOO & wire_nllOii_o(8 DOWNTO 2));
	nl00i :  oper_selector
	  GENERIC MAP (
		width_data => 8,
		width_sel => 8
	  )
	  PORT MAP ( 
		data => wire_nl00i_data,
		o => wire_nl00i_o,
		sel => wire_nl00i_sel
	  );
	wire_nl01l_data <= ( "1" & wire_nl0il_dataout & wire_nl0li_dataout & wire_nli1i_dataout & wire_nli1i_dataout & "0" & wire_w_lg_rdenablesync249w & wire_w_lg_nl111i259w);
	wire_nl01l_sel <= ( niOOOl & wire_nllOii_o(8 DOWNTO 5) & wire_nllOii_w_lg_w_o_range287w315w & wire_nllOii_o(3) & wire_nllOii_o(1));
	nl01l :  oper_selector
	  GENERIC MAP (
		width_data => 8,
		width_sel => 8
	  )
	  PORT MAP ( 
		data => wire_nl01l_data,
		o => wire_nl01l_o,
		sel => wire_nl01l_sel
	  );
	wire_nl1OO_data <= ( "1" & wire_nl0ii_dataout & wire_nl0iO_dataout & wire_nl0OO_dataout & wire_nl0OO_dataout & wire_nli1O_dataout & wire_nli0i_dataout);
	wire_nl1OO_sel <= ( niOOOi & wire_nllOii_o(8 DOWNTO 5) & wire_nllOii_o(2 DOWNTO 1));
	nl1OO :  oper_selector
	  GENERIC MAP (
		width_data => 7,
		width_sel => 7
	  )
	  PORT MAP ( 
		data => wire_nl1OO_data,
		o => wire_nl1OO_o,
		sel => wire_nl1OO_sel
	  );
	wire_nllllO_data <= ( "1" & wire_nllOil_dataout & wire_nlO0il_dataout & wire_nllOil_dataout & wire_nllOil_dataout & wire_nllOil_dataout & wire_nlOlli_dataout & wire_nlO0il_dataout & wire_nllOil_dataout);
	wire_nllllO_sel <= ( niOOOl & wire_nllOii_o(8 DOWNTO 1));
	nllllO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nllllO_data,
		o => wire_nllllO_o,
		sel => wire_nllllO_sel
	  );
	wire_nlllOi_data <= ( "0" & wire_nllOiO_dataout & wire_nlO0iO_dataout & wire_nllOiO_dataout & wire_nllOiO_dataout & wire_nllOiO_dataout & wire_nlOlll_dataout & wire_nlO0iO_dataout & wire_nllOiO_dataout);
	wire_nlllOi_sel <= ( niOOil & wire_nllOii_o(8 DOWNTO 1));
	nlllOi :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nlllOi_data,
		o => wire_nlllOi_o,
		sel => wire_nlllOi_sel
	  );
	wire_nlllOl_data <= ( "0" & wire_nllOli_dataout & wire_nlO0li_dataout & wire_nllOli_dataout & wire_nllOli_dataout & wire_nllOli_dataout & wire_nlOllO_dataout & wire_nlO0li_dataout & wire_nllOli_dataout);
	wire_nlllOl_sel <= ( niOOil & wire_nllOii_o(8 DOWNTO 1));
	nlllOl :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nlllOl_data,
		o => wire_nlllOl_o,
		sel => wire_nlllOl_sel
	  );
	wire_nlllOO_data <= ( "1" & wire_nllOll_dataout & wire_nlO0ll_dataout & wire_nllOll_dataout & wire_nllOll_dataout & wire_nllOll_dataout & wire_nlOlOi_dataout & wire_nlO0ll_dataout & wire_nllOll_dataout);
	wire_nlllOO_sel <= ( niOOil & wire_nllOii_o(8 DOWNTO 1));
	nlllOO :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nlllOO_data,
		o => wire_nlllOO_o,
		sel => wire_nlllOO_sel
	  );
	wire_nllO0i_data <= ( "0" & wire_nllOOO_dataout & wire_nlO0OO_dataout & wire_nlOill_dataout & wire_nlOill_dataout & wire_nllOOO_dataout & wire_nlOO1l_dataout & wire_nlO0OO_dataout & wire_nlOlii_dataout);
	wire_nllO0i_sel <= ( niOOil & wire_nllOii_o(8 DOWNTO 1));
	nllO0i :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nllO0i_data,
		o => wire_nllO0i_o,
		sel => wire_nllO0i_sel
	  );
	wire_nllO0l_data <= ( "1" & wire_nlO11i_dataout & wire_nlOi1i_dataout & wire_nlOilO_dataout & wire_nlOilO_dataout & wire_nlOl1i_dataout & wire_nlOO1O_dataout & wire_nlOl1O_dataout & wire_nlOlil_dataout);
	wire_nllO0l_sel <= ( niOOil & wire_nllOii_o(8 DOWNTO 1));
	nllO0l :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nllO0l_data,
		o => wire_nllO0l_o,
		sel => wire_nllO0l_sel
	  );
	wire_nllO1i_data <= ( "1" & wire_nllOlO_dataout & wire_nlO0lO_dataout & wire_nllOlO_dataout & wire_nllOlO_dataout & wire_nllOlO_dataout & wire_nlOlOl_dataout & wire_nlO0lO_dataout & wire_nllOlO_dataout);
	wire_nllO1i_sel <= ( niOOil & wire_nllOii_o(8 DOWNTO 1));
	nllO1i :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nllO1i_data,
		o => wire_nllO1i_o,
		sel => wire_nllO1i_sel
	  );
	wire_nllO1l_data <= ( "1" & wire_nllOOi_dataout & wire_nlO0Oi_dataout & wire_nllOOi_dataout & wire_nllOOi_dataout & wire_nllOOi_dataout & wire_nlOlOO_dataout & wire_nlO0Oi_dataout & wire_nllOOi_dataout);
	wire_nllO1l_sel <= ( niOOil & wire_nllOii_o(8 DOWNTO 1));
	nllO1l :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nllO1l_data,
		o => wire_nllO1l_o,
		sel => wire_nllO1l_sel
	  );
	wire_nllO1O_data <= ( "1" & wire_nllOOl_dataout & wire_nlO0Ol_dataout & wire_nlOili_dataout & wire_nlOili_dataout & wire_nlOiOO_dataout & wire_nlOO1i_dataout & wire_nlOl1l_dataout & wire_nlOl0O_dataout);
	wire_nllO1O_sel <= ( niOOil & wire_nllOii_o(8 DOWNTO 1));
	nllO1O :  oper_selector
	  GENERIC MAP (
		width_data => 9,
		width_sel => 9
	  )
	  PORT MAP ( 
		data => wire_nllO1O_data,
		o => wire_nllO1O_o,
		sel => wire_nllO1O_sel
	  );

 END RTL; --stratixgx_xgm_tx_sm
--synopsys translate_on
--VALID FILE
--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 75 mux21 20 oper_selector 10 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixgx_xgm_dskw_sm IS 
	 PORT 
	 ( 
		 adet	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 alignstatus	:	OUT  STD_LOGIC;
		 enabledeskew	:	OUT  STD_LOGIC;
		 fiforesetrd	:	OUT  STD_LOGIC;
		 rdalign	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0);
		 recovclk	:	IN  STD_LOGIC;
		 resetall	:	IN  STD_LOGIC;
		 syncstatus	:	IN  STD_LOGIC_VECTOR (3 DOWNTO 0)
	 ); 
 END stratixgx_xgm_dskw_sm;

 ARCHITECTURE RTL OF stratixgx_xgm_dskw_sm IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 nl0li58	:	STD_LOGIC := '1';
	 SIGNAL	 nl0li59	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0li59_w_lg_Q186w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0li60	:	STD_LOGIC := '0';
	 SIGNAL	 nl0ll55	:	STD_LOGIC := '1';
	 SIGNAL	 nl0ll56	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0ll56_w_lg_Q165w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0ll57	:	STD_LOGIC := '0';
	 SIGNAL	 nl0Oi52	:	STD_LOGIC := '1';
	 SIGNAL	 nl0Oi53	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0Oi53_w_lg_Q159w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0Oi54	:	STD_LOGIC := '0';
	 SIGNAL	 nl0OO49	:	STD_LOGIC := '1';
	 SIGNAL	 nl0OO50	:	STD_LOGIC := '1';
	 SIGNAL  wire_nl0OO50_w_lg_Q153w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nl0OO51	:	STD_LOGIC := '0';
	 SIGNAL	 nli0l40	:	STD_LOGIC := '1';
	 SIGNAL	 nli0l41	:	STD_LOGIC := '1';
	 SIGNAL  wire_nli0l41_w_lg_Q128w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli0l42	:	STD_LOGIC := '0';
	 SIGNAL	 nli1l46	:	STD_LOGIC := '1';
	 SIGNAL	 nli1l47	:	STD_LOGIC := '1';
	 SIGNAL  wire_nli1l47_w_lg_Q138w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli1l48	:	STD_LOGIC := '0';
	 SIGNAL	 nli1O43	:	STD_LOGIC := '1';
	 SIGNAL	 nli1O44	:	STD_LOGIC := '1';
	 SIGNAL  wire_nli1O44_w_lg_Q135w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nli1O45	:	STD_LOGIC := '0';
	 SIGNAL	 nliii37	:	STD_LOGIC := '1';
	 SIGNAL	 nliii38	:	STD_LOGIC := '1';
	 SIGNAL  wire_nliii38_w_lg_Q114w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliii39	:	STD_LOGIC := '0';
	 SIGNAL	 nliiO34	:	STD_LOGIC := '1';
	 SIGNAL	 nliiO35	:	STD_LOGIC := '1';
	 SIGNAL  wire_nliiO35_w_lg_Q107w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliiO36	:	STD_LOGIC := '0';
	 SIGNAL	 nlill31	:	STD_LOGIC := '1';
	 SIGNAL	 nlill32	:	STD_LOGIC := '1';
	 SIGNAL  wire_nlill32_w_lg_Q94w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlill33	:	STD_LOGIC := '0';
	 SIGNAL	 nlilO28	:	STD_LOGIC := '1';
	 SIGNAL	 nlilO29	:	STD_LOGIC := '1';
	 SIGNAL  wire_nlilO29_w_lg_Q91w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nlilO30	:	STD_LOGIC := '0';
	 SIGNAL	 nliOl25	:	STD_LOGIC := '1';
	 SIGNAL	 nliOl26	:	STD_LOGIC := '1';
	 SIGNAL  wire_nliOl26_w_lg_Q79w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliOl27	:	STD_LOGIC := '0';
	 SIGNAL	 nliOO22	:	STD_LOGIC := '1';
	 SIGNAL	 nliOO23	:	STD_LOGIC := '1';
	 SIGNAL  wire_nliOO23_w_lg_Q72w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nliOO24	:	STD_LOGIC := '0';
	 SIGNAL	 nll0l13	:	STD_LOGIC := '1';
	 SIGNAL	 nll0l14	:	STD_LOGIC := '1';
	 SIGNAL  wire_nll0l14_w_lg_Q48w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nll0l15	:	STD_LOGIC := '0';
	 SIGNAL	 nll1l19	:	STD_LOGIC := '1';
	 SIGNAL	 nll1l20	:	STD_LOGIC := '1';
	 SIGNAL  wire_nll1l20_w_lg_Q57w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nll1l21	:	STD_LOGIC := '0';
	 SIGNAL	 nll1O16	:	STD_LOGIC := '1';
	 SIGNAL	 nll1O17	:	STD_LOGIC := '1';
	 SIGNAL  wire_nll1O17_w_lg_Q52w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nll1O18	:	STD_LOGIC := '0';
	 SIGNAL	 nllil10	:	STD_LOGIC := '1';
	 SIGNAL	 nllil11	:	STD_LOGIC := '1';
	 SIGNAL  wire_nllil11_w_lg_Q39w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 nllil12	:	STD_LOGIC := '0';
	 SIGNAL	 nllOi7	:	STD_LOGIC := '1';
	 SIGNAL	 nllOi8	:	STD_LOGIC := '1';
	 SIGNAL	 nllOi9	:	STD_LOGIC := '0';
	 SIGNAL	 nlO0l1	:	STD_LOGIC := '1';
	 SIGNAL	 nlO0l2	:	STD_LOGIC := '1';
	 SIGNAL	 nlO0l3	:	STD_LOGIC := '0';
	 SIGNAL	 nlO1l4	:	STD_LOGIC := '1';
	 SIGNAL	 nlO1l5	:	STD_LOGIC := '1';
	 SIGNAL	 nlO1l6	:	STD_LOGIC := '0';
	 SIGNAL	n1ll	:	STD_LOGIC := '0';
	 SIGNAL	n1lO	:	STD_LOGIC := '0';
	 SIGNAL	n1Oi	:	STD_LOGIC := '0';
	 SIGNAL	n1OO	:	STD_LOGIC := '0';
	 SIGNAL  wire_n1Ol_w_lg_n1lO33w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n1Ol_w_lg_n1Oi234w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n01i	:	STD_LOGIC := '0';
	 SIGNAL	n0i	:	STD_LOGIC := '0';
	 SIGNAL	n0l	:	STD_LOGIC := '0';
	 SIGNAL	n1i	:	STD_LOGIC := '0';
	 SIGNAL	n1l	:	STD_LOGIC := '0';
	 SIGNAL	n1O	:	STD_LOGIC := '0';
	 SIGNAL	nii	:	STD_LOGIC := '0';
	 SIGNAL	nil	:	STD_LOGIC := '0';
	 SIGNAL	nli	:	STD_LOGIC := '0';
	 SIGNAL	nlOl	:	STD_LOGIC := '0';
	 SIGNAL	nlOO	:	STD_LOGIC := '0';
	 SIGNAL  wire_niO_w_lg_nli31w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_nli31w32w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_w_lg_w_lg_w_lg_n0l101w122w123w143w156w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_w_lg_w_lg_w_lg_n0l101w122w123w124w125w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_w_lg_w_lg_w_lg_n1O41w42w43w44w45w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_w_lg_w_lg_n0l101w122w123w143w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_w_lg_w_lg_n0l101w122w123w124w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_w_lg_w_lg_n0l101w102w103w104w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_w_lg_w_lg_n1O41w42w43w44w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_w_lg_n0l101w122w123w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_w_lg_n0l101w102w103w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_w_lg_n1O41w42w43w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_n0l101w122w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_n0l101w102w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_n1O41w42w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_w_lg_nlOO217w218w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_n0l101w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_n1O41w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niO_w_lg_nlOO217w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nliO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nllO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n00i_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n00i_o	:	STD_LOGIC;
	 SIGNAL  wire_n00i_sel	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n00l_data	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n00l_o	:	STD_LOGIC;
	 SIGNAL  wire_n00l_sel	:	STD_LOGIC_VECTOR (7 DOWNTO 0);
	 SIGNAL  wire_n00O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n00O_o	:	STD_LOGIC;
	 SIGNAL  wire_n00O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n01l_data	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n01l_o	:	STD_LOGIC;
	 SIGNAL  wire_n01l_sel	:	STD_LOGIC_VECTOR (5 DOWNTO 0);
	 SIGNAL  wire_n0il_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0il_o	:	STD_LOGIC;
	 SIGNAL  wire_n0il_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0li_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0li_o	:	STD_LOGIC;
	 SIGNAL  wire_n0li_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n0lO_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0lO_o	:	STD_LOGIC;
	 SIGNAL  wire_n0lO_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0Ol_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n0Ol_o	:	STD_LOGIC;
	 SIGNAL  wire_n0Ol_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1i_data	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1i_o	:	STD_LOGIC;
	 SIGNAL  wire_ni1i_sel	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_ni1O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_ni1O_o	:	STD_LOGIC;
	 SIGNAL  wire_ni1O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_w_lg_nllli35w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlllO192w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO0i11w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlO1i36w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_resetall19w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  nl0lO :	STD_LOGIC;
	 SIGNAL  nli0i :	STD_LOGIC;
	 SIGNAL  nli1i :	STD_LOGIC;
	 SIGNAL  nliil :	STD_LOGIC;
	 SIGNAL  nliOi :	STD_LOGIC;
	 SIGNAL  nll0i :	STD_LOGIC;
	 SIGNAL  nll1i :	STD_LOGIC;
	 SIGNAL  nllii :	STD_LOGIC;
	 SIGNAL  nllli :	STD_LOGIC;
	 SIGNAL  nllll :	STD_LOGIC;
	 SIGNAL  nlllO :	STD_LOGIC;
	 SIGNAL  nllOO :	STD_LOGIC;
	 SIGNAL  nlO0i :	STD_LOGIC;
	 SIGNAL  nlO1i :	STD_LOGIC;
 BEGIN

	wire_w_lg_nllli35w(0) <= NOT nllli;
	wire_w_lg_nlllO192w(0) <= NOT nlllO;
	wire_w_lg_nlO0i11w(0) <= NOT nlO0i;
	wire_w_lg_nlO1i36w(0) <= NOT nlO1i;
	wire_w_lg_resetall19w(0) <= NOT resetall;
	alignstatus <= nii;
	enabledeskew <= n1OO;
	fiforesetrd <= (n1OO AND wire_n1Ol_w_lg_n1Oi234w(0));
	nl0lO <= (wire_niO_w_lg_w_lg_w_lg_w_lg_w_lg_n0l101w122w123w143w156w(0) OR wire_nl0Oi53_w_lg_Q159w(0));
	nli0i <= (wire_niO_w_lg_w_lg_w_lg_w_lg_w_lg_n0l101w122w123w124w125w(0) OR wire_nli0l41_w_lg_Q128w(0));
	nli1i <= (wire_niO_w_lg_w_lg_w_lg_w_lg_n0l101w122w123w143w(0) OR n1ll);
	nliil <= (wire_niO_w_lg_w_lg_w_lg_w_lg_n0l101w102w103w104w(0) OR wire_nliiO35_w_lg_Q107w(0));
	nliOi <= ((((n0l OR n1i) OR nlOO) OR nlOl) OR n1ll);
	nll0i <= (wire_niO_w_lg_w_lg_w_lg_w_lg_w_lg_n1O41w42w43w44w45w(0) OR wire_nll0l14_w_lg_Q48w(0));
	nll1i <= ((((n1l OR n1i) OR nlOO) OR nlOl) OR n1ll);
	nllii <= (wire_niO_w_lg_w_lg_nli31w32w(0) OR wire_nllil11_w_lg_Q39w(0));
	nllli <= (nlO0i AND wire_n1Ol_w_lg_n1lO33w(0));
	nllll <= wire_niO_w_lg_w_lg_nli31w32w(0);
	nlllO <= ((nli AND (((adet(3) AND adet(2)) AND adet(1)) AND adet(0))) AND nllOi8);
	nllOO <= '1';
	nlO0i <= ((((rdalign(3) AND rdalign(2)) AND rdalign(1)) AND rdalign(0)) AND nlO0l2);
	nlO1i <= ((wire_w_lg_nlO0i11w(0) AND (((rdalign(3) OR rdalign(2)) OR rdalign(1)) OR rdalign(0))) AND nlO1l5);
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nl0li58 <= nl0li60;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nl0li59 <= (nl0li60 XOR nl0li58);
		END IF;
	END PROCESS;
	wire_nl0li59_w_lg_Q186w(0) <= nl0li59 AND wire_niO_w_lg_nli31w(0);
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nl0li60 <= nl0li58;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nl0ll55 <= nl0ll57;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nl0ll56 <= (nl0ll57 XOR nl0ll55);
		END IF;
	END PROCESS;
	wire_nl0ll56_w_lg_Q165w(0) <= nl0ll56 AND nlOl;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nl0ll57 <= nl0ll55;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nl0Oi52 <= nl0Oi54;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nl0Oi53 <= (nl0Oi54 XOR nl0Oi52);
		END IF;
	END PROCESS;
	wire_nl0Oi53_w_lg_Q159w(0) <= NOT nl0Oi53;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nl0Oi54 <= nl0Oi52;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nl0OO49 <= nl0OO51;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nl0OO50 <= (nl0OO51 XOR nl0OO49);
		END IF;
	END PROCESS;
	wire_nl0OO50_w_lg_Q153w(0) <= nl0OO50 AND wire_nliO_dataout;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nl0OO51 <= nl0OO49;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nli0l40 <= nli0l42;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nli0l41 <= (nli0l42 XOR nli0l40);
		END IF;
	END PROCESS;
	wire_nli0l41_w_lg_Q128w(0) <= NOT nli0l41;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nli0l42 <= nli0l40;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nli1l46 <= nli1l48;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nli1l47 <= (nli1l48 XOR nli1l46);
		END IF;
	END PROCESS;
	wire_nli1l47_w_lg_Q138w(0) <= nli1l47 AND wire_nl0i_dataout;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nli1l48 <= nli1l46;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nli1O43 <= nli1O45;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nli1O44 <= (nli1O45 XOR nli1O43);
		END IF;
	END PROCESS;
	wire_nli1O44_w_lg_Q135w(0) <= nli1O44 AND nli0i;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nli1O45 <= nli1O43;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nliii37 <= nliii39;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nliii38 <= (nliii39 XOR nliii37);
		END IF;
	END PROCESS;
	wire_nliii38_w_lg_Q114w(0) <= nliii38 AND n1i;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nliii39 <= nliii37;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nliiO34 <= nliiO36;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nliiO35 <= (nliiO36 XOR nliiO34);
		END IF;
	END PROCESS;
	wire_nliiO35_w_lg_Q107w(0) <= NOT nliiO35;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nliiO36 <= nliiO34;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nlill31 <= nlill33;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nlill32 <= (nlill33 XOR nlill31);
		END IF;
	END PROCESS;
	wire_nlill32_w_lg_Q94w(0) <= nlill32 AND nliOi;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nlill33 <= nlill31;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nlilO28 <= nlilO30;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nlilO29 <= (nlilO30 XOR nlilO28);
		END IF;
	END PROCESS;
	wire_nlilO29_w_lg_Q91w(0) <= nlilO29 AND n1l;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nlilO30 <= nlilO28;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nliOl25 <= nliOl27;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nliOl26 <= (nliOl27 XOR nliOl25);
		END IF;
	END PROCESS;
	wire_nliOl26_w_lg_Q79w(0) <= nliOl26 AND wire_nilO_dataout;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nliOl27 <= nliOl25;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nliOO22 <= nliOO24;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nliOO23 <= (nliOO24 XOR nliOO22);
		END IF;
	END PROCESS;
	wire_nliOO23_w_lg_Q72w(0) <= nliOO23 AND n1O;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nliOO24 <= nliOO22;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nll0l13 <= nll0l15;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nll0l14 <= (nll0l15 XOR nll0l13);
		END IF;
	END PROCESS;
	wire_nll0l14_w_lg_Q48w(0) <= NOT nll0l14;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nll0l15 <= nll0l13;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nll1l19 <= nll1l21;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nll1l20 <= (nll1l21 XOR nll1l19);
		END IF;
	END PROCESS;
	wire_nll1l20_w_lg_Q57w(0) <= nll1l20 AND nll0i;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nll1l21 <= nll1l19;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nll1O16 <= nll1O18;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nll1O17 <= (nll1O18 XOR nll1O16);
		END IF;
	END PROCESS;
	wire_nll1O17_w_lg_Q52w(0) <= nll1O17 AND n0l;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nll1O18 <= nll1O16;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nllil10 <= nllil12;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nllil11 <= (nllil12 XOR nllil10);
		END IF;
	END PROCESS;
	wire_nllil11_w_lg_Q39w(0) <= NOT nllil11;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nllil12 <= nllil10;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nllOi7 <= nllOi9;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nllOi8 <= (nllOi9 XOR nllOi7);
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nllOi9 <= nllOi7;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nlO0l1 <= nlO0l3;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nlO0l2 <= (nlO0l3 XOR nlO0l1);
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nlO0l3 <= nlO0l1;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nlO1l4 <= nlO1l6;
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nlO1l5 <= (nlO1l6 XOR nlO1l4);
		END IF;
	END PROCESS;
	PROCESS (recovclk)
	BEGIN
		IF (recovclk = '1' AND recovclk'event) THEN nlO1l6 <= nlO1l4;
		END IF;
	END PROCESS;
	PROCESS (recovclk, resetall)
	BEGIN
		IF (resetall = '1') THEN
				n1ll <= '1';
				n1lO <= '1';
				n1Oi <= '1';
				n1OO <= '1';
		ELSIF (recovclk = '1' AND recovclk'event) THEN
				n1ll <= wire_n00l_o;
				n1lO <= n1Oi;
				n1Oi <= n1OO;
				n1OO <= wire_n00i_o;
		END IF;
	END PROCESS;
	wire_n1Ol_w_lg_n1lO33w(0) <= NOT n1lO;
	wire_n1Ol_w_lg_n1Oi234w(0) <= NOT n1Oi;
	PROCESS (recovclk, resetall)
	BEGIN
		IF (resetall = '1') THEN
				n01i <= '0';
				n0i <= '0';
				n0l <= '0';
				n1i <= '0';
				n1l <= '0';
				n1O <= '0';
				nii <= '0';
				nil <= '0';
				nli <= '0';
				nlOl <= '0';
				nlOO <= '0';
		ELSIF (recovclk = '1' AND recovclk'event) THEN
				n01i <= (((syncstatus(3) AND syncstatus(2)) AND syncstatus(1)) AND syncstatus(0));
				n0i <= wire_ni1i_o;
				n0l <= wire_ni1O_o;
				n1i <= wire_n0li_o;
				n1l <= wire_n0lO_o;
				n1O <= wire_n0Ol_o;
				nii <= nil;
				nil <= wire_n01l_o;
				nli <= n01i;
				nlOl <= wire_n00O_o;
				nlOO <= wire_n0il_o;
		END IF;
	END PROCESS;
	wire_niO_w_lg_nli31w(0) <= NOT nli;
	wire_niO_w_lg_w_lg_nli31w32w(0) <= wire_niO_w_lg_nli31w(0) OR nlO1i;
	wire_niO_w_lg_w_lg_w_lg_w_lg_w_lg_n0l101w122w123w143w156w(0) <= wire_niO_w_lg_w_lg_w_lg_w_lg_n0l101w122w123w143w(0) OR nlOO;
	wire_niO_w_lg_w_lg_w_lg_w_lg_w_lg_n0l101w122w123w124w125w(0) <= wire_niO_w_lg_w_lg_w_lg_w_lg_n0l101w122w123w124w(0) OR n1ll;
	wire_niO_w_lg_w_lg_w_lg_w_lg_w_lg_n1O41w42w43w44w45w(0) <= wire_niO_w_lg_w_lg_w_lg_w_lg_n1O41w42w43w44w(0) OR n1ll;
	wire_niO_w_lg_w_lg_w_lg_w_lg_n0l101w122w123w143w(0) <= wire_niO_w_lg_w_lg_w_lg_n0l101w122w123w(0) OR n1i;
	wire_niO_w_lg_w_lg_w_lg_w_lg_n0l101w122w123w124w(0) <= wire_niO_w_lg_w_lg_w_lg_n0l101w122w123w(0) OR nlOl;
	wire_niO_w_lg_w_lg_w_lg_w_lg_n0l101w102w103w104w(0) <= wire_niO_w_lg_w_lg_w_lg_n0l101w102w103w(0) OR n1ll;
	wire_niO_w_lg_w_lg_w_lg_w_lg_n1O41w42w43w44w(0) <= wire_niO_w_lg_w_lg_w_lg_n1O41w42w43w(0) OR nlOl;
	wire_niO_w_lg_w_lg_w_lg_n0l101w122w123w(0) <= wire_niO_w_lg_w_lg_n0l101w122w(0) OR n1l;
	wire_niO_w_lg_w_lg_w_lg_n0l101w102w103w(0) <= wire_niO_w_lg_w_lg_n0l101w102w(0) OR nlOl;
	wire_niO_w_lg_w_lg_w_lg_n1O41w42w43w(0) <= wire_niO_w_lg_w_lg_n1O41w42w(0) OR nlOO;
	wire_niO_w_lg_w_lg_n0l101w122w(0) <= wire_niO_w_lg_n0l101w(0) OR n1O;
	wire_niO_w_lg_w_lg_n0l101w102w(0) <= wire_niO_w_lg_n0l101w(0) OR nlOO;
	wire_niO_w_lg_w_lg_n1O41w42w(0) <= wire_niO_w_lg_n1O41w(0) OR n1i;
	wire_niO_w_lg_w_lg_nlOO217w218w(0) <= wire_niO_w_lg_nlOO217w(0) OR n1ll;
	wire_niO_w_lg_n0l101w(0) <= n0l OR n0i;
	wire_niO_w_lg_n1O41w(0) <= n1O OR n1l;
	wire_niO_w_lg_nlOO217w(0) <= nlOO OR nlOl;
	wire_ni0l_dataout <= n1OO OR nllii;
	wire_ni0O_dataout <= nil AND NOT(nllii);
	wire_niii_dataout <= nlO0i AND NOT(nllii);
	wire_niil_dataout <= wire_w_lg_nlO0i11w(0) AND NOT(nllii);
	wire_nili_dataout <= wire_niOi_dataout AND NOT(wire_niO_w_lg_nli31w(0));
	wire_nill_dataout <= wire_niOl_dataout AND NOT(wire_niO_w_lg_nli31w(0));
	wire_nilO_dataout <= nlO1i AND NOT(wire_niO_w_lg_nli31w(0));
	wire_niOi_dataout <= nlO0i AND NOT(nlO1i);
	wire_niOl_dataout <= wire_w_lg_nlO0i11w(0) AND NOT(nlO1i);
	wire_niOO_dataout <= n1OO OR wire_niO_w_lg_nli31w(0);
	wire_nl0i_dataout <= wire_w_lg_nlO0i11w(0) AND NOT(nllll);
	wire_nl0l_dataout <= nlO0i AND NOT(nllll);
	wire_nl0O_dataout <= nil OR nlO0i;
	wire_nl1i_dataout <= nil AND NOT(wire_niO_w_lg_nli31w(0));
	wire_nl1l_dataout <= wire_w_lg_nlO1i36w(0) AND NOT(wire_niO_w_lg_nli31w(0));
	wire_nl1O_dataout <= nil WHEN nllll = '1'  ELSE wire_nl0O_dataout;
	wire_nlii_dataout <= n1OO OR nllll;
	wire_nlil_dataout <= wire_w_lg_nllli35w(0) AND NOT(nllll);
	wire_nliO_dataout <= nllli AND NOT(nllll);
	wire_nllO_dataout <= n1OO AND NOT(nlllO);
	wire_n00i_data <= ( wire_nllO_dataout & wire_nlii_dataout & wire_nlii_dataout & wire_nlii_dataout & wire_niOO_dataout & wire_niOO_dataout & wire_niOO_dataout & wire_ni0l_dataout);
	wire_n00i_sel <= ( n1ll & nlOl & nlOO & n1i & n1l & n1O & n0i & n0l);
	n00i :  oper_selector
	  GENERIC MAP (
		width_data => 8,
		width_sel => 8
	  )
	  PORT MAP ( 
		data => wire_n00i_data,
		o => wire_n00i_o,
		sel => wire_n00i_sel
	  );
	wire_n00l_data <= ( wire_w_lg_nlllO192w & nllll & nllll & nllll & wire_niO_w_lg_nli31w & wire_nl0li59_w_lg_Q186w & wire_niO_w_lg_nli31w & nllii);
	wire_n00l_sel <= ( n1ll & nlOl & nlOO & n1i & n1l & n1O & n0i & n0l);
	n00l :  oper_selector
	  GENERIC MAP (
		width_data => 8,
		width_sel => 8
	  )
	  PORT MAP ( 
		data => wire_n00l_data,
		o => wire_n00l_o,
		sel => wire_n00l_sel
	  );
	wire_n00O_data <= ( nlllO & wire_nlil_dataout & "0");
	wire_n00O_sel <= ( n1ll & wire_nl0ll56_w_lg_Q165w & nl0lO);
	n00O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n00O_data,
		o => wire_n00O_o,
		sel => wire_n00O_sel
	  );
	wire_n01l_data <= ( nil & wire_nl1O_dataout & wire_nl1i_dataout & wire_nl1i_dataout & wire_nl1i_dataout & wire_ni0O_dataout);
	wire_n01l_sel <= ( wire_niO_w_lg_w_lg_nlOO217w218w & n1i & n1l & n1O & n0i & n0l);
	n01l :  oper_selector
	  GENERIC MAP (
		width_data => 6,
		width_sel => 6
	  )
	  PORT MAP ( 
		data => wire_n01l_data,
		o => wire_n01l_o,
		sel => wire_n01l_sel
	  );
	wire_n0il_data <= ( "0" & wire_nl0OO50_w_lg_Q153w & wire_nl0i_dataout);
	wire_n0il_sel <= ( nli1i & nlOl & nlOO);
	n0il :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0il_data,
		o => wire_n0il_o,
		sel => wire_n0il_sel
	  );
	wire_n0li_data <= ( "0" & wire_nl0l_dataout & wire_nli1l47_w_lg_Q138w);
	wire_n0li_sel <= ( wire_nli1O44_w_lg_Q135w & nlOO & n1i);
	n0li :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n0li_data,
		o => wire_n0li_o,
		sel => wire_n0li_sel
	  );
	wire_n0lO_data <= ( "0" & wire_nl0l_dataout & wire_nl1l_dataout & wire_nili_dataout);
	wire_n0lO_sel <= ( nliil & wire_nliii38_w_lg_Q114w & n1l & n1O);
	n0lO :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0lO_data,
		o => wire_n0lO_o,
		sel => wire_n0lO_sel
	  );
	wire_n0Ol_data <= ( "0" & wire_nilO_dataout & wire_nill_dataout & wire_nili_dataout);
	wire_n0Ol_sel <= ( wire_nlill32_w_lg_Q94w & wire_nlilO29_w_lg_Q91w & n1O & n0i);
	n0Ol :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_n0Ol_data,
		o => wire_n0Ol_o,
		sel => wire_n0Ol_sel
	  );
	wire_ni1i_data <= ( "0" & wire_nliOl26_w_lg_Q79w & wire_nill_dataout & wire_niii_dataout);
	wire_ni1i_sel <= ( nll1i & wire_nliOO23_w_lg_Q72w & n0i & n0l);
	ni1i :  oper_selector
	  GENERIC MAP (
		width_data => 4,
		width_sel => 4
	  )
	  PORT MAP ( 
		data => wire_ni1i_data,
		o => wire_ni1i_o,
		sel => wire_ni1i_sel
	  );
	wire_ni1O_data <= ( "0" & wire_nilO_dataout & wire_niil_dataout);
	wire_ni1O_sel <= ( wire_nll1l20_w_lg_Q57w & n0i & wire_nll1O17_w_lg_Q52w);
	ni1O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_ni1O_data,
		o => wire_ni1O_o,
		sel => wire_ni1O_sel
	  );

 END RTL; --stratixgx_xgm_dskw_sm
--synopsys translate_on
--VALID FILE
--
-- stratixgx_reset_block
-- 

library IEEE, stratixgx_gxb;
use IEEE.std_logic_1164.all;
use stratixgx_gxb.hssi_pack.all;

ENTITY stratixgx_reset_block IS
   PORT (
      txdigitalreset          : IN std_logic_vector(3 DOWNTO 0);   
      rxdigitalreset          : IN std_logic_vector(3 DOWNTO 0);   
      rxanalogreset           : IN std_logic_vector(3 DOWNTO 0);   
      pllreset                : IN std_logic;   
      pllenable               : IN std_logic;   
      txdigitalresetout       : OUT std_logic_vector(3 DOWNTO 0);   
      rxdigitalresetout       : OUT std_logic_vector(3 DOWNTO 0);   
      txanalogresetout        : OUT std_logic_vector(3 DOWNTO 0);   
      rxanalogresetout        : OUT std_logic_vector(3 DOWNTO 0);   
      pllresetout             : OUT std_logic);   
END stratixgx_reset_block;

ARCHITECTURE stratixgx_reset_arch OF stratixgx_reset_block IS
   -- WIREs:
   signal HARD_RESET              :  std_logic;   
   signal txdigitalresetout_tmp   :  std_logic_vector(3 DOWNTO 0);   
   signal rxdigitalresetout_tmp   :  std_logic_vector(3 DOWNTO 0);   
   signal txanalogresetout_tmp    :  std_logic_vector(3 DOWNTO 0);   
   signal rxanalogresetout_tmp    :  std_logic_vector(3 DOWNTO 0);   
   signal pllresetout_tmp         :  std_logic;   

BEGIN

  txdigitalresetout <= txdigitalresetout_tmp;
   
  rxdigitalresetout <= rxdigitalresetout_tmp;

  txanalogresetout <= txanalogresetout_tmp;

  rxanalogresetout <= rxanalogresetout_tmp;

  pllresetout <= pllresetout_tmp;

  HARD_RESET <= pllreset OR NOT pllenable ;

  rxanalogresetout_tmp <= (HARD_RESET OR rxanalogreset(3)) &
                          (HARD_RESET OR rxanalogreset(2)) &
                          (HARD_RESET OR rxanalogreset(1)) &
                          (HARD_RESET OR rxanalogreset(0)) ;
   
  txanalogresetout_tmp <= (HARD_RESET & HARD_RESET &
                           HARD_RESET & HARD_RESET);
   
  pllresetout_tmp <= ((((((rxanalogresetout_tmp(0) AND rxanalogresetout_tmp(1)) AND
                          rxanalogresetout_tmp(2)) AND rxanalogresetout_tmp(3)) AND
                        txanalogresetout_tmp(0)) AND txanalogresetout_tmp(1)) AND
                      txanalogresetout_tmp(2)) AND txanalogresetout_tmp(3) ;

  rxdigitalresetout_tmp <= (HARD_RESET OR rxdigitalreset(3)) &
                           (HARD_RESET OR rxdigitalreset(2)) &
                           (HARD_RESET OR rxdigitalreset(1)) &
                           (HARD_RESET OR rxdigitalreset(0)) ;
   
  txdigitalresetout_tmp <= (HARD_RESET OR txdigitalreset(3)) &
                           (HARD_RESET OR txdigitalreset(2)) &
                           (HARD_RESET OR txdigitalreset(1)) &
                           (HARD_RESET OR txdigitalreset(0)) ;

END stratixgx_reset_arch;


--IP Functional Simulation Model
--VERSION_BEGIN 6.0 cbx_mgl 2006:04:14:19:14:36:SJ cbx_simgen 2006:03:22:01:13:28:SJ  VERSION_END


-- Legal Notice:  2003 Altera Corporation. All rights reserved.
-- You may only use these  simulation  model  output files for simulation
-- purposes and expressly not for synthesis or any other purposes (in which
-- event  Altera disclaims all warranties of any kind). Your use of  Altera
-- Corporation's design tools, logic functions and other software and tools,
-- and its AMPP partner logic functions, and any output files any of the
-- foregoing (including device programming or simulation files), and any
-- associated documentation or information  are expressly subject to the
-- terms and conditions of the  Altera Program License Subscription Agreement
-- or other applicable license agreement, including, without limitation, that
-- your use is for the sole purpose of programming logic devices manufactured
-- by Altera and sold by Altera or its authorized distributors.  Please refer
-- to the applicable agreement for further details.


--synopsys translate_off

 LIBRARY sgate;
 USE sgate.sgate_pack.all;

--synthesis_resources = lut 83 mux21 46 oper_decoder 1 oper_selector 10 
 LIBRARY ieee;
 USE ieee.std_logic_1164.all;

 ENTITY  stratixgx_hssi_tx_enc_rtl IS 
	 PORT 
	 ( 
		 ENDEC	:	IN  STD_LOGIC;
		 GE_XAUI_SEL	:	IN  STD_LOGIC;
		 IB_FORCE_DISPARITY	:	IN  STD_LOGIC;
		 INDV	:	IN  STD_LOGIC;
		 prbs_en	:	IN  STD_LOGIC;
		 PUDR	:	OUT  STD_LOGIC_VECTOR (9 DOWNTO 0);
		 soft_reset	:	IN  STD_LOGIC;
		 tx_clk	:	IN  STD_LOGIC;
		 tx_ctl_tc	:	IN  STD_LOGIC;
		 tx_ctl_ts	:	IN  STD_LOGIC;
		 tx_data_9_tc	:	IN  STD_LOGIC;
		 tx_data_pg	:	IN  STD_LOGIC_VECTOR (9 DOWNTO 0);
		 tx_data_tc	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 tx_data_ts	:	IN  STD_LOGIC_VECTOR (7 DOWNTO 0);
		 TXLP10B	:	OUT  STD_LOGIC_VECTOR (9 DOWNTO 0)
	 ); 
 END stratixgx_hssi_tx_enc_rtl;

 ARCHITECTURE RTL OF stratixgx_hssi_tx_enc_rtl IS

	 ATTRIBUTE synthesis_clearbox : boolean;
	 ATTRIBUTE synthesis_clearbox OF RTL : ARCHITECTURE IS true;
	 SIGNAL	 n100i43	:	STD_LOGIC := '1';
	 SIGNAL	 n100i44	:	STD_LOGIC := '1';
	 SIGNAL  wire_n100i44_w_lg_Q91w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n100i45	:	STD_LOGIC := '0';
	 SIGNAL	 n100O40	:	STD_LOGIC := '1';
	 SIGNAL	 n100O41	:	STD_LOGIC := '1';
	 SIGNAL  wire_n100O41_w_lg_Q85w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n100O42	:	STD_LOGIC := '0';
	 SIGNAL	 n101i49	:	STD_LOGIC := '1';
	 SIGNAL	 n101i50	:	STD_LOGIC := '1';
	 SIGNAL  wire_n101i50_w_lg_Q119w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n101i51	:	STD_LOGIC := '0';
	 SIGNAL	 n101l46	:	STD_LOGIC := '1';
	 SIGNAL	 n101l47	:	STD_LOGIC := '1';
	 SIGNAL  wire_n101l47_w_lg_Q105w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n101l48	:	STD_LOGIC := '0';
	 SIGNAL	 n10ii37	:	STD_LOGIC := '1';
	 SIGNAL	 n10ii38	:	STD_LOGIC := '1';
	 SIGNAL  wire_n10ii38_w_lg_Q81w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n10ii39	:	STD_LOGIC := '0';
	 SIGNAL	 n10il34	:	STD_LOGIC := '1';
	 SIGNAL	 n10il35	:	STD_LOGIC := '1';
	 SIGNAL	 n10il36	:	STD_LOGIC := '0';
	 SIGNAL	 n10li31	:	STD_LOGIC := '1';
	 SIGNAL	 n10li32	:	STD_LOGIC := '1';
	 SIGNAL	 n10li33	:	STD_LOGIC := '0';
	 SIGNAL	 n11Oi58	:	STD_LOGIC := '1';
	 SIGNAL	 n11Oi59	:	STD_LOGIC := '1';
	 SIGNAL  wire_n11Oi59_w_lg_Q141w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n11Oi60	:	STD_LOGIC := '0';
	 SIGNAL	 n11Ol55	:	STD_LOGIC := '1';
	 SIGNAL	 n11Ol56	:	STD_LOGIC := '1';
	 SIGNAL  wire_n11Ol56_w_lg_Q134w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n11Ol57	:	STD_LOGIC := '0';
	 SIGNAL	 n11OO52	:	STD_LOGIC := '1';
	 SIGNAL	 n11OO53	:	STD_LOGIC := '1';
	 SIGNAL  wire_n11OO53_w_lg_Q122w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	 n11OO54	:	STD_LOGIC := '0';
	 SIGNAL	 n1i0l22	:	STD_LOGIC := '1';
	 SIGNAL	 n1i0l23	:	STD_LOGIC := '1';
	 SIGNAL	 n1i0l24	:	STD_LOGIC := '0';
	 SIGNAL	 n1i1i28	:	STD_LOGIC := '1';
	 SIGNAL	 n1i1i29	:	STD_LOGIC := '1';
	 SIGNAL	 n1i1i30	:	STD_LOGIC := '0';
	 SIGNAL	 n1i1O25	:	STD_LOGIC := '1';
	 SIGNAL	 n1i1O26	:	STD_LOGIC := '1';
	 SIGNAL	 n1i1O27	:	STD_LOGIC := '0';
	 SIGNAL	 n1iil19	:	STD_LOGIC := '1';
	 SIGNAL	 n1iil20	:	STD_LOGIC := '1';
	 SIGNAL	 n1iil21	:	STD_LOGIC := '0';
	 SIGNAL	 n1ili16	:	STD_LOGIC := '1';
	 SIGNAL	 n1ili17	:	STD_LOGIC := '1';
	 SIGNAL	 n1ili18	:	STD_LOGIC := '0';
	 SIGNAL	 n1ilO13	:	STD_LOGIC := '1';
	 SIGNAL	 n1ilO14	:	STD_LOGIC := '1';
	 SIGNAL	 n1ilO15	:	STD_LOGIC := '0';
	 SIGNAL	 n1iOl10	:	STD_LOGIC := '1';
	 SIGNAL	 n1iOl11	:	STD_LOGIC := '1';
	 SIGNAL	 n1iOl12	:	STD_LOGIC := '0';
	 SIGNAL	 n1l0l1	:	STD_LOGIC := '1';
	 SIGNAL	 n1l0l2	:	STD_LOGIC := '1';
	 SIGNAL	 n1l0l3	:	STD_LOGIC := '0';
	 SIGNAL	 n1l1i7	:	STD_LOGIC := '1';
	 SIGNAL	 n1l1i8	:	STD_LOGIC := '1';
	 SIGNAL	 n1l1i9	:	STD_LOGIC := '0';
	 SIGNAL	 n1l1O4	:	STD_LOGIC := '1';
	 SIGNAL	 n1l1O5	:	STD_LOGIC := '1';
	 SIGNAL	 n1l1O6	:	STD_LOGIC := '0';
	 SIGNAL	n00i	:	STD_LOGIC := '0';
	 SIGNAL	n00l	:	STD_LOGIC := '0';
	 SIGNAL	n00O	:	STD_LOGIC := '0';
	 SIGNAL	n01i	:	STD_LOGIC := '0';
	 SIGNAL	n01l	:	STD_LOGIC := '0';
	 SIGNAL	n01O	:	STD_LOGIC := '0';
	 SIGNAL	n0ii	:	STD_LOGIC := '0';
	 SIGNAL	n0il	:	STD_LOGIC := '0';
	 SIGNAL	n0li	:	STD_LOGIC := '0';
	 SIGNAL	n10O	:	STD_LOGIC := '0';
	 SIGNAL	n1iO	:	STD_LOGIC := '0';
	 SIGNAL	n1li	:	STD_LOGIC := '0';
	 SIGNAL	n1ll	:	STD_LOGIC := '0';
	 SIGNAL	n1lO	:	STD_LOGIC := '0';
	 SIGNAL	n1OO	:	STD_LOGIC := '0';
	 SIGNAL	nlOil	:	STD_LOGIC := '0';
	 SIGNAL  wire_n0iO_w_lg_w_lg_n1iO43w46w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0iO_w_lg_n1iO14w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0iO_w_lg_n1iO43w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0iO_w_lg_n10O1w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	n1il	:	STD_LOGIC := '0';
	 SIGNAL	wire_n1ii_ENA	:	STD_LOGIC;
	 SIGNAL  wire_n1ii_w_lg_n1il67w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	nlO0i	:	STD_LOGIC := '0';
	 SIGNAL	nlO0l	:	STD_LOGIC := '0';
	 SIGNAL	nlO1i	:	STD_LOGIC := '0';
	 SIGNAL	nlO1l	:	STD_LOGIC := '0';
	 SIGNAL	nlO1O	:	STD_LOGIC := '0';
	 SIGNAL	nlOii	:	STD_LOGIC := '0';
	 SIGNAL	wire_n0i_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0i_w_lg_dataout252w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0i_w_lg_dataout298w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0i_w_lg_dataout323w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0i0O_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n0i0O_w_lg_w_lg_dataout249w253w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0i0O_w_lg_w_lg_dataout249w250w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0i0O_w_lg_dataout296w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n0i0O_w_lg_dataout249w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_n0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0l0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lii_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0liO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0lll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0Ol_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n0OO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_n1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1ii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1ii_w_lg_dataout352w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni1il_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1il_w_lg_dataout353w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_ni1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_ni1Ol_dataout	:	STD_LOGIC;
	 SIGNAL  wire_ni1Ol_w_lg_dataout354w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_niii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niii_w_lg_w_lg_dataout268w311w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii_w_lg_w_lg_dataout268w269w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii_w_lg_dataout265w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii_w_lg_dataout312w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii_w_lg_dataout268w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niii_w_lg_dataout320w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_niil_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niil_w_lg_dataout264w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_niiO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niiO_w_lg_w_lg_dataout263w284w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_dataout263w276w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_dataout263w385w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_dataout263w376w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_dataout263w373w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_w_lg_dataout263w390w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_dataout379w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_dataout290w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_dataout287w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_dataout340w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_dataout282w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_dataout263w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niiO_w_lg_dataout321w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nili_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nili_w_lg_w_lg_dataout262w341w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_w_lg_dataout262w283w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_w_lg_dataout262w279w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_w_lg_dataout262w333w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_w292w295w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_dataout285w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_dataout277w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_dataout386w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_dataout377w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_dataout374w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_dataout391w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_dataout380w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_dataout291w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_dataout288w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_dataout294w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_dataout262w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_w_lg_w_lg_dataout262w341w343w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_w_lg_w_lg_dataout262w283w286w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_w_lg_w_lg_w_lg_dataout262w341w343w345w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w_lg_w_lg_w_lg_w_lg_dataout262w283w286w289w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w347w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nili_w292w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nill_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nill_w_lg_w_lg_dataout293w335w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nill_w_lg_dataout329w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nill_w_lg_dataout344w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nill_w_lg_dataout342w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nill_w_lg_dataout346w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_nill_w_lg_dataout293w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nillO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nilO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nilO_w_lg_dataout308w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_nilOO_dataout	:	STD_LOGIC;
	 SIGNAL  wire_nilOO_w_lg_dataout256w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_niO0l_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niO0l_w_lg_dataout258w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_niO1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOi_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOi_w_lg_dataout299w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOi_w_lg_dataout261w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_niOii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOii_w_lg_dataout259w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_niOil_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOiO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOl_dataout	:	STD_LOGIC;
	 SIGNAL  wire_niOl_w_lg_dataout300w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_niOl_w_lg_dataout257w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL	wire_niOli_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOll_dataout	:	STD_LOGIC;
	 SIGNAL	wire_niOO_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl0O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1i_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1l_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nl1O_dataout	:	STD_LOGIC;
	 SIGNAL	wire_nlii_dataout	:	STD_LOGIC;
	 SIGNAL  wire_n10l_i	:	STD_LOGIC_VECTOR (1 DOWNTO 0);
	 SIGNAL  wire_n10l_o	:	STD_LOGIC_VECTOR (3 DOWNTO 0);
	 SIGNAL  wire_n10l_w_o_range93w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n10l_w_o_range96w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_n11i_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n11i_o	:	STD_LOGIC;
	 SIGNAL  wire_n11i_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n11l_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n11l_o	:	STD_LOGIC;
	 SIGNAL  wire_n11l_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n11O_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_n11O_o	:	STD_LOGIC;
	 SIGNAL  wire_n11O_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOiO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOiO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOiO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOli_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOli_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOli_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOll_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOll_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOll_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOlO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOlO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOlO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOOi_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOOi_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOOi_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOOl_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOOl_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOOl_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOOO_data	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_nlOOO_o	:	STD_LOGIC;
	 SIGNAL  wire_nlOOO_sel	:	STD_LOGIC_VECTOR (2 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_w_lg_n1lil3w5w40w41w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_n1lil3w5w40w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_n1lil3w5w8w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_w_lg_tx_ctl_tc2w10w13w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_GE_XAUI_SEL19w34w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_tx_data_9_tc68w74w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_n1lil3w5w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_nlOOlO325w327w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_tx_ctl_tc2w42w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_lg_tx_ctl_tc2w10w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_GE_XAUI_SEL9w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_GE_XAUI_SEL19w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOOlO324w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOOOl328w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_tx_data_9_tc68w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_tc_range66w218w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n10Ol332w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11lO251w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1lii4w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n1lil3w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOOli350w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOOll326w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOOlO325w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOOOi351w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_soft_reset71w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_tx_ctl_tc2w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_w_tx_data_tc_range64w217w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n110i336w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n111i334w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_n11ll254w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOOil337w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOOiO348w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_lg_nlOOiO338w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  n101O :	STD_LOGIC;
	 SIGNAL  n10lO :	STD_LOGIC;
	 SIGNAL  n10Oi :	STD_LOGIC;
	 SIGNAL  n10Ol :	STD_LOGIC;
	 SIGNAL  n10OO :	STD_LOGIC;
	 SIGNAL  n110i :	STD_LOGIC;
	 SIGNAL  n110l :	STD_LOGIC;
	 SIGNAL  n110O :	STD_LOGIC;
	 SIGNAL  n111i :	STD_LOGIC;
	 SIGNAL  n111l :	STD_LOGIC;
	 SIGNAL  n111O :	STD_LOGIC;
	 SIGNAL  n11ii :	STD_LOGIC;
	 SIGNAL  n11il :	STD_LOGIC;
	 SIGNAL  n11iO :	STD_LOGIC;
	 SIGNAL  n11li :	STD_LOGIC;
	 SIGNAL  n11ll :	STD_LOGIC;
	 SIGNAL  n11lO :	STD_LOGIC;
	 SIGNAL  n1iii :	STD_LOGIC;
	 SIGNAL  n1lii :	STD_LOGIC;
	 SIGNAL  n1lil :	STD_LOGIC;
	 SIGNAL  nlOO0i :	STD_LOGIC;
	 SIGNAL  nlOO0l :	STD_LOGIC;
	 SIGNAL  nlOO0O :	STD_LOGIC;
	 SIGNAL  nlOO1O :	STD_LOGIC;
	 SIGNAL  nlOOii :	STD_LOGIC;
	 SIGNAL  nlOOil :	STD_LOGIC;
	 SIGNAL  nlOOiO :	STD_LOGIC;
	 SIGNAL  nlOOli :	STD_LOGIC;
	 SIGNAL  nlOOll :	STD_LOGIC;
	 SIGNAL  nlOOlO :	STD_LOGIC;
	 SIGNAL  nlOOOi :	STD_LOGIC;
	 SIGNAL  nlOOOl :	STD_LOGIC;
	 SIGNAL  nlOOOO :	STD_LOGIC;
	 SIGNAL  wire_w_tx_data_pg_range102w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_tc_range66w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_tc_range64w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
	 SIGNAL  wire_w_tx_data_tc_range54w	:	STD_LOGIC_VECTOR (0 DOWNTO 0);
 BEGIN

	wire_w_lg_w_lg_w_lg_w_lg_n1lil3w5w40w41w(0) <= wire_w_lg_w_lg_w_lg_n1lil3w5w40w(0) AND GE_XAUI_SEL;
	wire_w_lg_w_lg_w_lg_n1lil3w5w40w(0) <= wire_w_lg_w_lg_n1lil3w5w(0) AND n1i0l23;
	wire_w_lg_w_lg_w_lg_n1lil3w5w8w(0) <= wire_w_lg_w_lg_n1lil3w5w(0) AND n1l0l2;
	wire_w_lg_w_lg_w_lg_tx_ctl_tc2w10w13w(0) <= wire_w_lg_w_lg_tx_ctl_tc2w10w(0) AND n1l1O5;
	wire_w_lg_w_lg_GE_XAUI_SEL19w34w(0) <= wire_w_lg_GE_XAUI_SEL19w(0) AND n1iil20;
	wire_w_lg_w_lg_tx_data_9_tc68w74w(0) <= wire_w_lg_tx_data_9_tc68w(0) AND n10li32;
	wire_w_lg_w_lg_n1lil3w5w(0) <= wire_w_lg_n1lil3w(0) AND wire_w_lg_n1lii4w(0);
	wire_w_lg_w_lg_nlOOlO325w327w(0) <= wire_w_lg_nlOOlO325w(0) AND wire_w_lg_nlOOll326w(0);
	wire_w_lg_w_lg_tx_ctl_tc2w42w(0) <= wire_w_lg_tx_ctl_tc2w(0) AND wire_w_lg_w_lg_w_lg_w_lg_n1lil3w5w40w41w(0);
	wire_w_lg_w_lg_tx_ctl_tc2w10w(0) <= wire_w_lg_tx_ctl_tc2w(0) AND wire_w_lg_GE_XAUI_SEL9w(0);
	wire_w_lg_GE_XAUI_SEL9w(0) <= GE_XAUI_SEL AND wire_w_lg_w_lg_w_lg_n1lil3w5w8w(0);
	wire_w_lg_GE_XAUI_SEL19w(0) <= GE_XAUI_SEL AND wire_w_lg_w_lg_n1lil3w5w(0);
	wire_w_lg_nlOOlO324w(0) <= nlOOlO AND wire_n0i_w_lg_dataout323w(0);
	wire_w_lg_nlOOOl328w(0) <= nlOOOl AND wire_w_lg_w_lg_nlOOlO325w327w(0);
	wire_w_lg_tx_data_9_tc68w(0) <= tx_data_9_tc AND IB_FORCE_DISPARITY;
	wire_w_lg_w_tx_data_tc_range66w218w(0) <= wire_w_tx_data_tc_range66w(0) AND wire_w_lg_w_tx_data_tc_range64w217w(0);
	wire_w_lg_n10Ol332w(0) <= NOT n10Ol;
	wire_w_lg_n11lO251w(0) <= NOT n11lO;
	wire_w_lg_n1lii4w(0) <= NOT n1lii;
	wire_w_lg_n1lil3w(0) <= NOT n1lil;
	wire_w_lg_nlOOli350w(0) <= NOT nlOOli;
	wire_w_lg_nlOOll326w(0) <= NOT nlOOll;
	wire_w_lg_nlOOlO325w(0) <= NOT nlOOlO;
	wire_w_lg_nlOOOi351w(0) <= NOT nlOOOi;
	wire_w_lg_soft_reset71w(0) <= NOT soft_reset;
	wire_w_lg_tx_ctl_tc2w(0) <= NOT tx_ctl_tc;
	wire_w_lg_w_tx_data_tc_range64w217w(0) <= NOT wire_w_tx_data_tc_range64w(0);
	wire_w_lg_n110i336w(0) <= n110i OR wire_nill_w_lg_w_lg_dataout293w335w(0);
	wire_w_lg_n111i334w(0) <= n111i OR wire_nili_w_lg_w_lg_dataout262w333w(0);
	wire_w_lg_n11ll254w(0) <= n11ll OR wire_n0i0O_w_lg_w_lg_dataout249w253w(0);
	wire_w_lg_nlOOil337w(0) <= nlOOil OR wire_w_lg_n110i336w(0);
	wire_w_lg_nlOOiO348w(0) <= nlOOiO OR wire_nili_w347w(0);
	wire_w_lg_nlOOiO338w(0) <= nlOOiO OR wire_w_lg_nlOOil337w(0);
	n101O <= ((wire_n10l_o(3) OR wire_n10l_o(1)) OR wire_n100i44_w_lg_Q91w(0));
	n10lO <= (((((((((NOT tx_data_tc(0)) AND wire_w_lg_w_tx_data_tc_range64w217w(0)) AND tx_data_tc(2)) AND tx_data_tc(3)) AND tx_data_tc(4)) AND tx_data_tc(5)) AND (NOT tx_data_tc(6))) AND tx_data_tc(7)) AND tx_ctl_tc);
	n10Oi <= '1';
	n10Ol <= (n10O OR (wire_n1ii_w_lg_n1il67w(0) AND wire_w_lg_tx_data_9_tc68w(0)));
	n10OO <= ((wire_n0iO_w_lg_n10O1w(0) AND wire_n0iO_w_lg_w_lg_n1iO43w46w(0)) AND n1i1i29);
	n110i <= (n111l OR n111O);
	n110l <= wire_niii_w_lg_dataout312w(0);
	n110O <= wire_niii_w_lg_w_lg_dataout268w311w(0);
	n111i <= ((((wire_nili_w_lg_dataout262w(0) AND (wire_niiO_w_lg_dataout263w(0) AND wire_niii_w_lg_dataout265w(0))) OR (wire_nili_w_lg_dataout262w(0) AND (wire_niiO_w_lg_dataout263w(0) AND wire_niii_w_lg_w_lg_dataout268w269w(0)))) OR (wire_nili_w_lg_dataout262w(0) AND (wire_niiO_dataout AND nlOO0i))) OR wire_nili_w_lg_dataout386w(0));
	n111l <= (wire_nili_dataout AND wire_niiO_w_lg_dataout340w(0));
	n111O <= (wire_nili_w_lg_dataout262w(0) AND (wire_niiO_w_lg_dataout263w(0) AND wire_niii_w_lg_w_lg_dataout268w311w(0)));
	n11ii <= (wire_niOl_w_lg_dataout257w(0) AND n11il);
	n11il <= (wire_nilO_w_lg_dataout308w(0) AND wire_niOi_w_lg_dataout261w(0));
	n11iO <= (wire_niOl_dataout AND (wire_niOi_dataout AND (wire_nilO_dataout AND ((((((((wire_nili_w_lg_dataout262w(0) AND (wire_niiO_w_lg_dataout263w(0) AND wire_niii_w_lg_dataout265w(0))) OR (wire_nili_w_lg_dataout262w(0) AND (wire_niiO_w_lg_dataout263w(0) AND wire_niii_w_lg_w_lg_dataout268w269w(0)))) OR (wire_nili_w_lg_dataout262w(0) AND (wire_niiO_dataout AND n110O))) OR wire_nili_w_lg_dataout277w(0)) AND wire_nili_w_lg_w_lg_dataout262w279w(0)) AND wire_n0i0O_w_lg_dataout249w(0)) OR wire_n0i0O_w_lg_dataout296w(0)) OR wire_niOl_w_lg_dataout300w(0)))));
	n11li <= (wire_n0i0O_w_lg_w_lg_dataout249w250w(0) XOR wire_w_lg_n11ll254w(0));
	n11ll <= (wire_nilO_dataout AND wire_niOi_dataout);
	n11lO <= (n11ll OR n11il);
	n1iii <= (n10O AND (n1iO AND (wire_w_lg_tx_ctl_tc2w(0) AND wire_w_lg_w_lg_GE_XAUI_SEL19w34w(0))));
	n1lii <= (((((((((NOT tx_data_tc(0)) AND tx_data_tc(1)) AND (NOT tx_data_tc(2))) AND (NOT tx_data_tc(3))) AND (NOT tx_data_tc(4))) AND (NOT tx_data_tc(5))) AND tx_data_tc(6)) AND (NOT tx_data_tc(7))) AND wire_w_lg_tx_ctl_tc2w(0));
	n1lil <= (((((((wire_w_lg_w_tx_data_tc_range66w218w(0) AND tx_data_tc(2)) AND (NOT tx_data_tc(3))) AND tx_data_tc(4)) AND tx_data_tc(5)) AND (NOT tx_data_tc(6))) AND tx_data_tc(7)) AND wire_w_lg_tx_ctl_tc2w(0));
	nlOO0i <= wire_niii_w_lg_w_lg_dataout268w311w(0);
	nlOO0l <= wire_niii_w_lg_w_lg_dataout268w269w(0);
	nlOO0O <= wire_niii_w_lg_dataout265w(0);
	nlOO1O <= wire_niii_w_lg_dataout312w(0);
	nlOOii <= ((wire_w_lg_n10Ol332w(0) AND wire_w_lg_nlOOiO338w(0)) XOR wire_w_lg_nlOOiO348w(0));
	nlOOil <= (wire_nill_dataout AND (nlOOll OR (wire_nili_dataout AND n111i)));
	nlOOiO <= (wire_n0i_dataout AND nlOOlO);
	nlOOli <= (wire_w_lg_nlOOlO324w(0) OR wire_nill_w_lg_dataout329w(0));
	nlOOll <= ((((wire_nili_w_lg_dataout262w(0) AND (wire_niiO_dataout AND nlOO1O)) OR wire_nili_w_lg_dataout391w(0)) OR wire_nili_w_lg_dataout288w(0)) OR wire_nili_w_lg_dataout291w(0));
	nlOOlO <= ((((((wire_nili_w_lg_dataout262w(0) AND (wire_niiO_w_lg_dataout263w(0) AND wire_niii_w_lg_dataout312w(0))) OR (wire_nili_w_lg_dataout262w(0) AND (wire_niiO_dataout AND nlOO0O))) OR (wire_nili_w_lg_dataout262w(0) AND (wire_niiO_dataout AND nlOO0l))) OR wire_nili_w_lg_dataout374w(0)) OR wire_nili_w_lg_dataout377w(0)) OR wire_nili_w_lg_dataout380w(0));
	nlOOOi <= (nlOOOO OR (wire_nill_dataout AND nlOOOl));
	nlOOOl <= (wire_nili_w_lg_dataout262w(0) OR wire_niiO_w_lg_dataout321w(0));
	nlOOOO <= (wire_nill_w_lg_dataout293w(0) AND n111i);
	PUDR <= ( wire_n11O_o & wire_n11l_o & wire_n11i_o & wire_nlOOO_o & wire_nlOOl_o & wire_nlOOi_o & wire_nlOlO_o & wire_nlOll_o & wire_nlOli_o & wire_nlOiO_o);
	TXLP10B <= ( nlOil & n0li & n0il & n0ii & n00O & n00l & n00i & n01O & n01l & n01i);
	wire_w_tx_data_pg_range102w(0) <= tx_data_pg(9);
	wire_w_tx_data_tc_range66w(0) <= tx_data_tc(0);
	wire_w_tx_data_tc_range64w(0) <= tx_data_tc(1);
	wire_w_tx_data_tc_range54w(0) <= tx_data_tc(6);
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n100i43 <= n100i45;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n100i44 <= (n100i45 XOR n100i43);
		END IF;
	END PROCESS;
	wire_n100i44_w_lg_Q91w(0) <= NOT n100i44;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n100i45 <= n100i43;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n100O40 <= n100O42;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n100O41 <= (n100O42 XOR n100O40);
		END IF;
	END PROCESS;
	wire_n100O41_w_lg_Q85w(0) <= n100O41 AND ENDEC;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n100O42 <= n100O40;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n101i49 <= n101i51;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n101i50 <= (n101i51 XOR n101i49);
		END IF;
	END PROCESS;
	wire_n101i50_w_lg_Q119w(0) <= n101i50 AND wire_n10l_w_o_range96w(0);
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n101i51 <= n101i49;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n101l46 <= n101l48;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n101l47 <= (n101l48 XOR n101l46);
		END IF;
	END PROCESS;
	wire_n101l47_w_lg_Q105w(0) <= n101l47 AND wire_w_tx_data_pg_range102w(0);
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n101l48 <= n101l46;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n10ii37 <= n10ii39;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n10ii38 <= (n10ii39 XOR n10ii37);
		END IF;
	END PROCESS;
	wire_n10ii38_w_lg_Q81w(0) <= n10ii38 AND prbs_en;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n10ii39 <= n10ii37;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n10il34 <= n10il36;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n10il35 <= (n10il36 XOR n10il34);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n10il36 <= n10il34;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n10li31 <= n10li33;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n10li32 <= (n10li33 XOR n10li31);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n10li33 <= n10li31;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n11Oi58 <= n11Oi60;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n11Oi59 <= (n11Oi60 XOR n11Oi58);
		END IF;
	END PROCESS;
	wire_n11Oi59_w_lg_Q141w(0) <= n11Oi59 AND wire_n10l_w_o_range93w(0);
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n11Oi60 <= n11Oi58;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n11Ol55 <= n11Ol57;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n11Ol56 <= (n11Ol57 XOR n11Ol55);
		END IF;
	END PROCESS;
	wire_n11Ol56_w_lg_Q134w(0) <= n11Ol56 AND wire_w_tx_data_tc_range54w(0);
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n11Ol57 <= n11Ol55;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n11OO52 <= n11OO54;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n11OO53 <= (n11OO54 XOR n11OO52);
		END IF;
	END PROCESS;
	wire_n11OO53_w_lg_Q122w(0) <= n11OO53 AND n101O;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n11OO54 <= n11OO52;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1i0l22 <= n1i0l24;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1i0l23 <= (n1i0l24 XOR n1i0l22);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1i0l24 <= n1i0l22;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1i1i28 <= n1i1i30;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1i1i29 <= (n1i1i30 XOR n1i1i28);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1i1i30 <= n1i1i28;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1i1O25 <= n1i1O27;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1i1O26 <= (n1i1O27 XOR n1i1O25);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1i1O27 <= n1i1O25;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1iil19 <= n1iil21;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1iil20 <= (n1iil21 XOR n1iil19);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1iil21 <= n1iil19;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1ili16 <= n1ili18;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1ili17 <= (n1ili18 XOR n1ili16);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1ili18 <= n1ili16;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1ilO13 <= n1ilO15;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1ilO14 <= (n1ilO15 XOR n1ilO13);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1ilO15 <= n1ilO13;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1iOl10 <= n1iOl12;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1iOl11 <= (n1iOl12 XOR n1iOl10);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1iOl12 <= n1iOl10;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1l0l1 <= n1l0l3;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1l0l2 <= (n1l0l3 XOR n1l0l1);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1l0l3 <= n1l0l1;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1l1i7 <= n1l1i9;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1l1i8 <= (n1l1i9 XOR n1l1i7);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1l1i9 <= n1l1i7;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1l1O4 <= n1l1O6;
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1l1O5 <= (n1l1O6 XOR n1l1O4);
		END IF;
	END PROCESS;
	PROCESS (tx_clk)
	BEGIN
		IF (tx_clk = '1' AND tx_clk'event) THEN n1l1O6 <= n1l1O4;
		END IF;
	END PROCESS;
	PROCESS (tx_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n00i <= '0';
				n00l <= '0';
				n00O <= '0';
				n01i <= '0';
				n01l <= '0';
				n01O <= '0';
				n0ii <= '0';
				n0il <= '0';
				n0li <= '0';
				n10O <= '0';
				n1iO <= '0';
				n1li <= '0';
				n1ll <= '0';
				n1lO <= '0';
				n1OO <= '0';
				nlOil <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
				n00i <= wire_nlOlO_o;
				n00l <= wire_nlOOi_o;
				n00O <= wire_nlOOl_o;
				n01i <= wire_nlOiO_o;
				n01l <= wire_nlOli_o;
				n01O <= wire_nlOll_o;
				n0ii <= wire_nlOOO_o;
				n0il <= wire_n11i_o;
				n0li <= wire_n11l_o;
				n10O <= wire_nillO_dataout;
				n1iO <= n10lO;
				n1li <= wire_n0l0O_dataout;
				n1ll <= wire_n0lii_dataout;
				n1lO <= wire_niOiO_dataout;
				n1OO <= wire_niOll_dataout;
				nlOil <= wire_n11O_o;
		END IF;
	END PROCESS;
	wire_n0iO_w_lg_w_lg_n1iO43w46w(0) <= wire_n0iO_w_lg_n1iO43w(0) AND n1i1O26;
	wire_n0iO_w_lg_n1iO14w(0) <= n1iO AND wire_w_lg_w_lg_w_lg_tx_ctl_tc2w10w13w(0);
	wire_n0iO_w_lg_n1iO43w(0) <= n1iO AND wire_w_lg_w_lg_tx_ctl_tc2w42w(0);
	wire_n0iO_w_lg_n10O1w(0) <= NOT n10O;
	PROCESS (tx_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				n1il <= '0';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
			IF (wire_n1ii_ENA = '1') THEN
				n1il <= n10Oi;
			END IF;
		END IF;
	END PROCESS;
	wire_n1ii_ENA <= ((wire_n1ii_w_lg_n1il67w(0) AND wire_w_lg_w_lg_tx_data_9_tc68w74w(0)) AND n10il35);
	wire_n1ii_w_lg_n1il67w(0) <= NOT n1il;
	PROCESS (tx_clk, soft_reset)
	BEGIN
		IF (soft_reset = '1') THEN
				nlO0i <= '1';
				nlO0l <= '1';
				nlO1i <= '1';
				nlO1l <= '1';
				nlO1O <= '1';
				nlOii <= '1';
		ELSIF (tx_clk = '1' AND tx_clk'event) THEN
				nlO0i <= wire_n0lll_dataout;
				nlO0l <= wire_niOil_dataout;
				nlO1i <= wire_n0lil_dataout;
				nlO1l <= wire_n0liO_dataout;
				nlO1O <= wire_n0lli_dataout;
				nlOii <= wire_niOli_dataout;
		END IF;
	END PROCESS;
	wire_n0i_dataout <= wire_n0l_dataout AND NOT(((n10O AND ((n1iO AND ((wire_w_lg_tx_ctl_tc2w(0) AND wire_w_lg_GE_XAUI_SEL19w(0)) AND n1iOl11)) AND n1ilO14)) AND n1ili17));
	wire_n0i_w_lg_dataout252w(0) <= wire_n0i_dataout AND wire_w_lg_n11lO251w(0);
	wire_n0i_w_lg_dataout298w(0) <= wire_n0i_dataout AND wire_nilO_dataout;
	wire_n0i_w_lg_dataout323w(0) <= wire_n0i_dataout OR wire_nill_w_lg_dataout293w(0);
	wire_n0i0O_dataout <= wire_w_lg_n10Ol332w(0) WHEN (nlOOil OR (nlOOOO OR (n111l OR (wire_n0i_dataout OR n111O)))) = '1'  ELSE n10Ol;
	wire_n0i0O_w_lg_w_lg_dataout249w253w(0) <= wire_n0i0O_w_lg_dataout249w(0) AND wire_n0i_w_lg_dataout252w(0);
	wire_n0i0O_w_lg_w_lg_dataout249w250w(0) <= wire_n0i0O_w_lg_dataout249w(0) AND n11lO;
	wire_n0i0O_w_lg_dataout296w(0) <= wire_n0i0O_dataout AND wire_nili_w_lg_w292w295w(0);
	wire_n0i0O_w_lg_dataout249w(0) <= NOT wire_n0i0O_dataout;
	wire_n0l_dataout <= wire_n1O_dataout AND NOT(((wire_n0iO_w_lg_n10O1w(0) AND wire_n0iO_w_lg_n1iO14w(0)) AND n1l1i8));
	wire_n0l0O_dataout <= wire_niii_w_lg_dataout268w(0) WHEN nlOOii = '1'  ELSE wire_niii_dataout;
	wire_n0lii_dataout <= wire_ni1Ol_w_lg_dataout354w(0) WHEN nlOOii = '1'  ELSE wire_ni1Ol_dataout;
	wire_n0lil_dataout <= wire_ni1il_w_lg_dataout353w(0) WHEN nlOOii = '1'  ELSE wire_ni1il_dataout;
	wire_n0liO_dataout <= wire_ni1ii_w_lg_dataout352w(0) WHEN nlOOii = '1'  ELSE wire_ni1ii_dataout;
	wire_n0lli_dataout <= wire_w_lg_nlOOOi351w(0) WHEN nlOOii = '1'  ELSE nlOOOi;
	wire_n0lll_dataout <= wire_w_lg_nlOOli350w(0) WHEN nlOOii = '1'  ELSE nlOOli;
	wire_n0Ol_dataout <= tx_data_tc(0) WHEN INDV = '1'  ELSE tx_data_ts(0);
	wire_n0OO_dataout <= tx_data_tc(1) WHEN INDV = '1'  ELSE tx_data_ts(1);
	wire_n1O_dataout <= tx_ctl_tc WHEN INDV = '1'  ELSE tx_ctl_ts;
	wire_ni0i_dataout <= tx_data_tc(5) WHEN INDV = '1'  ELSE tx_data_ts(5);
	wire_ni0l_dataout <= tx_data_tc(6) WHEN INDV = '1'  ELSE tx_data_ts(6);
	wire_ni0O_dataout <= tx_data_tc(7) WHEN INDV = '1'  ELSE tx_data_ts(7);
	wire_ni1i_dataout <= tx_data_tc(2) WHEN INDV = '1'  ELSE tx_data_ts(2);
	wire_ni1ii_dataout <= wire_nili_w_lg_dataout262w(0) WHEN n111l = '1'  ELSE wire_nili_dataout;
	wire_ni1ii_w_lg_dataout352w(0) <= NOT wire_ni1ii_dataout;
	wire_ni1il_dataout <= wire_niiO_w_lg_dataout263w(0) WHEN (n111O OR (wire_nill_dataout AND (wire_nili_dataout AND (wire_niiO_w_lg_dataout263w(0) AND wire_niii_w_lg_w_lg_dataout268w311w(0))))) = '1'  ELSE wire_niiO_dataout;
	wire_ni1il_w_lg_dataout353w(0) <= NOT wire_ni1il_dataout;
	wire_ni1l_dataout <= tx_data_tc(3) WHEN INDV = '1'  ELSE tx_data_ts(3);
	wire_ni1O_dataout <= tx_data_tc(4) WHEN INDV = '1'  ELSE tx_data_ts(4);
	wire_ni1Ol_dataout <= wire_niil_w_lg_dataout264w(0) WHEN n110i = '1'  ELSE wire_niil_dataout;
	wire_ni1Ol_w_lg_dataout354w(0) <= NOT wire_ni1Ol_dataout;
	wire_niii_dataout <= wire_niOO_dataout AND NOT(n1iii);
	wire_niii_w_lg_w_lg_dataout268w311w(0) <= wire_niii_w_lg_dataout268w(0) AND wire_niil_w_lg_dataout264w(0);
	wire_niii_w_lg_w_lg_dataout268w269w(0) <= wire_niii_w_lg_dataout268w(0) AND wire_niil_dataout;
	wire_niii_w_lg_dataout265w(0) <= wire_niii_dataout AND wire_niil_w_lg_dataout264w(0);
	wire_niii_w_lg_dataout312w(0) <= wire_niii_dataout AND wire_niil_dataout;
	wire_niii_w_lg_dataout268w(0) <= NOT wire_niii_dataout;
	wire_niii_w_lg_dataout320w(0) <= wire_niii_dataout OR wire_niil_dataout;
	wire_niil_dataout <= wire_nl1i_dataout AND NOT(n1iii);
	wire_niil_w_lg_dataout264w(0) <= NOT wire_niil_dataout;
	wire_niiO_dataout <= wire_nl1l_dataout AND NOT(n1iii);
	wire_niiO_w_lg_w_lg_dataout263w284w(0) <= wire_niiO_w_lg_dataout263w(0) AND n110l;
	wire_niiO_w_lg_w_lg_dataout263w276w(0) <= wire_niiO_w_lg_dataout263w(0) AND n110O;
	wire_niiO_w_lg_w_lg_dataout263w385w(0) <= wire_niiO_w_lg_dataout263w(0) AND nlOO0i;
	wire_niiO_w_lg_w_lg_dataout263w376w(0) <= wire_niiO_w_lg_dataout263w(0) AND nlOO0l;
	wire_niiO_w_lg_w_lg_dataout263w373w(0) <= wire_niiO_w_lg_dataout263w(0) AND nlOO0O;
	wire_niiO_w_lg_w_lg_dataout263w390w(0) <= wire_niiO_w_lg_dataout263w(0) AND nlOO1O;
	wire_niiO_w_lg_dataout379w(0) <= wire_niiO_dataout AND wire_niii_w_lg_w_lg_dataout268w311w(0);
	wire_niiO_w_lg_dataout290w(0) <= wire_niiO_dataout AND wire_niii_w_lg_w_lg_dataout268w269w(0);
	wire_niiO_w_lg_dataout287w(0) <= wire_niiO_dataout AND wire_niii_w_lg_dataout265w(0);
	wire_niiO_w_lg_dataout340w(0) <= wire_niiO_dataout AND wire_niii_w_lg_dataout312w(0);
	wire_niiO_w_lg_dataout282w(0) <= wire_niiO_dataout AND n110l;
	wire_niiO_w_lg_dataout263w(0) <= NOT wire_niiO_dataout;
	wire_niiO_w_lg_dataout321w(0) <= wire_niiO_dataout OR wire_niii_w_lg_dataout320w(0);
	wire_nili_dataout <= wire_nl1O_dataout AND NOT(n1iii);
	wire_nili_w_lg_w_lg_dataout262w341w(0) <= wire_nili_w_lg_dataout262w(0) AND wire_niiO_w_lg_dataout340w(0);
	wire_nili_w_lg_w_lg_dataout262w283w(0) <= wire_nili_w_lg_dataout262w(0) AND wire_niiO_w_lg_dataout282w(0);
	wire_nili_w_lg_w_lg_dataout262w279w(0) <= wire_nili_w_lg_dataout262w(0) AND wire_nill_dataout;
	wire_nili_w_lg_w_lg_dataout262w333w(0) <= wire_nili_w_lg_dataout262w(0) AND nlOOll;
	wire_nili_w_lg_w292w295w(0) <= wire_nili_w292w(0) AND wire_nili_w_lg_dataout294w(0);
	wire_nili_w_lg_dataout285w(0) <= wire_nili_dataout AND wire_niiO_w_lg_w_lg_dataout263w284w(0);
	wire_nili_w_lg_dataout277w(0) <= wire_nili_dataout AND wire_niiO_w_lg_w_lg_dataout263w276w(0);
	wire_nili_w_lg_dataout386w(0) <= wire_nili_dataout AND wire_niiO_w_lg_w_lg_dataout263w385w(0);
	wire_nili_w_lg_dataout377w(0) <= wire_nili_dataout AND wire_niiO_w_lg_w_lg_dataout263w376w(0);
	wire_nili_w_lg_dataout374w(0) <= wire_nili_dataout AND wire_niiO_w_lg_w_lg_dataout263w373w(0);
	wire_nili_w_lg_dataout391w(0) <= wire_nili_dataout AND wire_niiO_w_lg_w_lg_dataout263w390w(0);
	wire_nili_w_lg_dataout380w(0) <= wire_nili_dataout AND wire_niiO_w_lg_dataout379w(0);
	wire_nili_w_lg_dataout291w(0) <= wire_nili_dataout AND wire_niiO_w_lg_dataout290w(0);
	wire_nili_w_lg_dataout288w(0) <= wire_nili_dataout AND wire_niiO_w_lg_dataout287w(0);
	wire_nili_w_lg_dataout294w(0) <= wire_nili_dataout AND wire_nill_w_lg_dataout293w(0);
	wire_nili_w_lg_dataout262w(0) <= NOT wire_nili_dataout;
	wire_nili_w_lg_w_lg_w_lg_dataout262w341w343w(0) <= wire_nili_w_lg_w_lg_dataout262w341w(0) OR wire_nill_w_lg_dataout342w(0);
	wire_nili_w_lg_w_lg_w_lg_dataout262w283w286w(0) <= wire_nili_w_lg_w_lg_dataout262w283w(0) OR wire_nili_w_lg_dataout285w(0);
	wire_nili_w_lg_w_lg_w_lg_w_lg_dataout262w341w343w345w(0) <= wire_nili_w_lg_w_lg_w_lg_dataout262w341w343w(0) OR wire_nill_w_lg_dataout344w(0);
	wire_nili_w_lg_w_lg_w_lg_w_lg_dataout262w283w286w289w(0) <= wire_nili_w_lg_w_lg_w_lg_dataout262w283w286w(0) OR wire_nili_w_lg_dataout288w(0);
	wire_nili_w347w(0) <= wire_nili_w_lg_w_lg_w_lg_w_lg_dataout262w341w343w345w(0) OR wire_nill_w_lg_dataout346w(0);
	wire_nili_w292w(0) <= wire_nili_w_lg_w_lg_w_lg_w_lg_dataout262w283w286w289w(0) OR wire_nili_w_lg_dataout291w(0);
	wire_nill_dataout <= wire_nl0i_dataout OR n1iii;
	wire_nill_w_lg_w_lg_dataout293w335w(0) <= wire_nill_w_lg_dataout293w(0) AND wire_w_lg_n111i334w(0);
	wire_nill_w_lg_dataout329w(0) <= wire_nill_dataout AND wire_w_lg_nlOOOl328w(0);
	wire_nill_w_lg_dataout344w(0) <= wire_nill_dataout AND n111l;
	wire_nill_w_lg_dataout342w(0) <= wire_nill_dataout AND n111O;
	wire_nill_w_lg_dataout346w(0) <= wire_nill_dataout AND nlOOll;
	wire_nill_w_lg_dataout293w(0) <= NOT wire_nill_dataout;
	wire_nillO_dataout <= wire_n0i0O_w_lg_dataout249w(0) WHEN (n11ii OR (wire_niOl_dataout AND n11lO)) = '1'  ELSE wire_n0i0O_dataout;
	wire_nilO_dataout <= wire_nl0l_dataout AND NOT(n1iii);
	wire_nilO_w_lg_dataout308w(0) <= NOT wire_nilO_dataout;
	wire_nilOO_dataout <= wire_niO1i_dataout OR n11iO;
	wire_nilOO_w_lg_dataout256w(0) <= NOT wire_nilOO_dataout;
	wire_niO0l_dataout <= wire_niOi_w_lg_dataout261w(0) WHEN n11ii = '1'  ELSE wire_niOi_dataout;
	wire_niO0l_w_lg_dataout258w(0) <= NOT wire_niO0l_dataout;
	wire_niO1i_dataout <= wire_w_lg_n11lO251w(0) AND NOT(wire_niOl_dataout);
	wire_niOi_dataout <= wire_nl0O_dataout OR n1iii;
	wire_niOi_w_lg_dataout299w(0) <= wire_niOi_dataout AND wire_n0i_w_lg_dataout298w(0);
	wire_niOi_w_lg_dataout261w(0) <= NOT wire_niOi_dataout;
	wire_niOii_dataout <= wire_nilO_dataout AND NOT(n11iO);
	wire_niOii_w_lg_dataout259w(0) <= NOT wire_niOii_dataout;
	wire_niOil_dataout <= wire_niOii_w_lg_dataout259w(0) WHEN n11li = '1'  ELSE wire_niOii_dataout;
	wire_niOiO_dataout <= wire_niO0l_w_lg_dataout258w(0) WHEN n11li = '1'  ELSE wire_niO0l_dataout;
	wire_niOl_dataout <= wire_nlii_dataout AND NOT(n1iii);
	wire_niOl_w_lg_dataout300w(0) <= wire_niOl_dataout AND wire_niOi_w_lg_dataout299w(0);
	wire_niOl_w_lg_dataout257w(0) <= NOT wire_niOl_dataout;
	wire_niOli_dataout <= wire_niOl_w_lg_dataout257w(0) WHEN n11li = '1'  ELSE wire_niOl_dataout;
	wire_niOll_dataout <= wire_nilOO_w_lg_dataout256w(0) WHEN n11li = '1'  ELSE wire_nilOO_dataout;
	wire_niOO_dataout <= wire_n0Ol_dataout OR n10OO;
	wire_nl0i_dataout <= wire_ni1O_dataout AND NOT(n10OO);
	wire_nl0l_dataout <= wire_ni0i_dataout AND NOT(n10OO);
	wire_nl0O_dataout <= wire_ni0l_dataout OR n10OO;
	wire_nl1i_dataout <= wire_n0OO_dataout AND NOT(n10OO);
	wire_nl1l_dataout <= wire_ni1i_dataout OR n10OO;
	wire_nl1O_dataout <= wire_ni1l_dataout AND NOT(n10OO);
	wire_nlii_dataout <= wire_ni0O_dataout OR n10OO;
	wire_n10l_i <= ( wire_n100O41_w_lg_Q85w & wire_n10ii38_w_lg_Q81w);
	wire_n10l_w_o_range93w(0) <= wire_n10l_o(0);
	wire_n10l_w_o_range96w(0) <= wire_n10l_o(2);
	n10l :  oper_decoder
	  GENERIC MAP (
		width_i => 2,
		width_o => 4
	  )
	  PORT MAP ( 
		i => wire_n10l_i,
		o => wire_n10l_o
	  );
	wire_n11i_data <= ( tx_data_pg(7) & n1lO & tx_data_tc(7));
	wire_n11i_sel <= ( wire_n11OO53_w_lg_Q122w & wire_n101i50_w_lg_Q119w & wire_n10l_o(0));
	n11i :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n11i_data,
		o => wire_n11i_o,
		sel => wire_n11i_sel
	  );
	wire_n11l_data <= ( tx_data_pg(8) & nlOii & tx_ctl_tc);
	wire_n11l_sel <= ( n101O & wire_n10l_o(2) & wire_n10l_o(0));
	n11l :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n11l_data,
		o => wire_n11l_o,
		sel => wire_n11l_sel
	  );
	wire_n11O_data <= ( wire_n101l47_w_lg_Q105w & n1OO & tx_data_9_tc);
	wire_n11O_sel <= ( n101O & wire_n10l_o(2) & wire_n10l_o(0));
	n11O :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_n11O_data,
		o => wire_n11O_o,
		sel => wire_n11O_sel
	  );
	wire_nlOiO_data <= ( tx_data_pg(0) & n1li & tx_data_tc(0));
	wire_nlOiO_sel <= ( n101O & wire_n10l_o(2) & wire_n10l_o(0));
	nlOiO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOiO_data,
		o => wire_nlOiO_o,
		sel => wire_nlOiO_sel
	  );
	wire_nlOli_data <= ( tx_data_pg(1) & n1ll & tx_data_tc(1));
	wire_nlOli_sel <= ( n101O & wire_n10l_o(2) & wire_n10l_o(0));
	nlOli :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOli_data,
		o => wire_nlOli_o,
		sel => wire_nlOli_sel
	  );
	wire_nlOll_data <= ( tx_data_pg(2) & nlO1i & tx_data_tc(2));
	wire_nlOll_sel <= ( n101O & wire_n10l_o(2) & wire_n10l_o(0));
	nlOll :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOll_data,
		o => wire_nlOll_o,
		sel => wire_nlOll_sel
	  );
	wire_nlOlO_data <= ( tx_data_pg(3) & nlO1l & tx_data_tc(3));
	wire_nlOlO_sel <= ( n101O & wire_n10l_o(2) & wire_n10l_o(0));
	nlOlO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOlO_data,
		o => wire_nlOlO_o,
		sel => wire_nlOlO_sel
	  );
	wire_nlOOi_data <= ( tx_data_pg(4) & nlO1O & tx_data_tc(4));
	wire_nlOOi_sel <= ( n101O & wire_n10l_o(2) & wire_n10l_o(0));
	nlOOi :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOOi_data,
		o => wire_nlOOi_o,
		sel => wire_nlOOi_sel
	  );
	wire_nlOOl_data <= ( tx_data_pg(5) & nlO0i & tx_data_tc(5));
	wire_nlOOl_sel <= ( n101O & wire_n10l_o(2) & wire_n11Oi59_w_lg_Q141w);
	nlOOl :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOOl_data,
		o => wire_nlOOl_o,
		sel => wire_nlOOl_sel
	  );
	wire_nlOOO_data <= ( tx_data_pg(6) & nlO0l & wire_n11Ol56_w_lg_Q134w);
	wire_nlOOO_sel <= ( n101O & wire_n10l_o(2) & wire_n10l_o(0));
	nlOOO :  oper_selector
	  GENERIC MAP (
		width_data => 3,
		width_sel => 3
	  )
	  PORT MAP ( 
		data => wire_nlOOO_data,
		o => wire_nlOOO_o,
		sel => wire_nlOOO_sel
	  );

 END RTL; --stratixgx_hssi_tx_enc_rtl
--synopsys translate_on
--VALID FILE
--/////////////////////////////////////////////////////////////////////////////
--
--                           STRATIXGX_8b10b_ENCODER
--
--/////////////////////////////////////////////////////////////////////////////

library IEEE, stratixgx_gxb;
use IEEE.std_logic_1164.all;

ENTITY stratixgx_8b10b_encoder IS
    GENERIC (
        transmit_protocol              :  string := "none";    
        use_8b_10b_mode                :  string := "true";    
        force_disparity_mode           :  string := "false");    
    PORT (
        clk                     : IN std_logic;   
        reset                   : IN std_logic;   
        xgmctrl                 : IN std_logic;   
        kin                     : IN std_logic;   
        xgmdatain               : IN std_logic_vector(7 DOWNTO 0);   
        datain                  : IN std_logic_vector(7 DOWNTO 0);   
        forcedisparity          : IN std_logic;   
        dataout                 : OUT std_logic_vector(9 DOWNTO 0);   
        parafbkdataout          : OUT std_logic_vector(9 DOWNTO 0));   
END stratixgx_8b10b_encoder;

ARCHITECTURE auto_translated OF stratixgx_8b10b_encoder IS

    COMPONENT stratixgx_hssi_tx_enc_rtl
        PORT (
            tx_clk                  : IN  std_logic;
            soft_reset              : IN  std_logic;
            INDV                    : IN  std_logic;
            ENDEC                   : IN  std_logic;
            GE_XAUI_SEL             : IN  std_logic;
            IB_FORCE_DISPARITY      : IN  std_logic;
            prbs_en                 : IN  std_logic;
            tx_ctl_ts               : IN  std_logic;
            tx_ctl_tc               : IN  std_logic;
            tx_data_ts              : IN  std_logic_vector(7 DOWNTO 0);
            tx_data_tc              : IN  std_logic_vector(7 DOWNTO 0);
            tx_data_9_tc            : IN  std_logic;
            tx_data_pg              : IN  std_logic_vector(9 DOWNTO 0);
            PUDR                    : OUT std_logic_vector(9 DOWNTO 0);
            TXLP10B                 : OUT std_logic_vector(9 DOWNTO 0));
    END COMPONENT;


    -- CORE MODULE INPUTs
    SIGNAL tx_clk                   :  std_logic;   
    SIGNAL soft_reset               :  std_logic;   
    SIGNAL INDV                     :  std_logic;   
    SIGNAL ENDEC                    :  std_logic;   
    SIGNAL GE_XAUI_SEL              :  std_logic;   
    SIGNAL IB_FORCE_DISPARITY       :  std_logic;   
    SIGNAL prbs_en                  :  std_logic;   
    SIGNAL tx_ctl_ts                :  std_logic;   
    SIGNAL tx_ctl_tc                :  std_logic;   
    SIGNAL tx_data_ts               :  std_logic_vector(7 DOWNTO 0);   
    SIGNAL tx_data_tc               :  std_logic_vector(7 DOWNTO 0);   
    SIGNAL tx_data_9_tc             :  std_logic;   
    SIGNAL tx_data_pg               :  std_logic_vector(9 DOWNTO 0);   
    -- CORE MODULE OUTPUTs
    SIGNAL TXLP10B                  :  std_logic_vector(9 DOWNTO 0);   
    SIGNAL PUDR                     :  std_logic_vector(9 DOWNTO 0);   
    SIGNAL temp_xhdl3               :  std_logic;   
    SIGNAL temp_xhdl4               :  std_logic;   
    SIGNAL temp_xhdl5               :  std_logic;   
    SIGNAL temp_xhdl6               :  std_logic;   
    SIGNAL dataout_xhdl1            :  std_logic_vector(9 DOWNTO 0);   
    SIGNAL parafbkdataout_xhdl2     :  std_logic_vector(9 DOWNTO 0);   

BEGIN
    dataout <= dataout_xhdl1;
    parafbkdataout <= parafbkdataout_xhdl2;
    tx_clk <= clk ;
    soft_reset <= reset ;
    temp_xhdl3 <= '1' WHEN (transmit_protocol /= "xaui") ELSE '0';
    INDV <= temp_xhdl3 ;
    temp_xhdl4 <= '1' WHEN (use_8b_10b_mode = "true") ELSE '0';
    ENDEC <= temp_xhdl4 ;
    temp_xhdl5 <= '1' WHEN (transmit_protocol = "gige") ELSE '0';
    GE_XAUI_SEL <= temp_xhdl5 ;
    temp_xhdl6 <= '1' WHEN (force_disparity_mode = "true") ELSE '0';
    IB_FORCE_DISPARITY <= temp_xhdl6 ;
    prbs_en <= '0' ;
    tx_ctl_ts <= xgmctrl ;
    tx_ctl_tc <= kin ;
    tx_data_ts <= xgmdatain ;
    tx_data_tc <= datain ;
    tx_data_9_tc <= forcedisparity ;
    tx_data_pg <= "0000000000" ;
    dataout_xhdl1 <= PUDR ;
    parafbkdataout_xhdl2 <= TXLP10B ;
    m_enc_core : stratixgx_hssi_tx_enc_rtl 
        PORT MAP (
            tx_clk => tx_clk,
            soft_reset => soft_reset,
            INDV => INDV,
            ENDEC => ENDEC,
            GE_XAUI_SEL => GE_XAUI_SEL,
            IB_FORCE_DISPARITY => IB_FORCE_DISPARITY,
            prbs_en => prbs_en,
            tx_ctl_ts => tx_ctl_ts,
            tx_ctl_tc => tx_ctl_tc,
            tx_data_ts => tx_data_ts,
            tx_data_tc => tx_data_tc,
            tx_data_9_tc => tx_data_9_tc,
            tx_data_pg => tx_data_pg,
            PUDR => PUDR,
            TXLP10B => TXLP10B);   
    

END auto_translated;
--/////////////////////////////////////////////////////////////////////////////
--
--                            DESKEW FIFO RAM MODULE
--
--/////////////////////////////////////////////////////////////////////////////

library IEEE, stratixgx_gxb, std;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

ENTITY deskew_ram_block IS
   PORT (
      clk                     : IN std_logic;   
      reset                   : IN std_logic;   
      addrwr                  : IN std_logic_vector(15 DOWNTO 0);   
      addrrd1                 : IN std_logic_vector(15 DOWNTO 0);   
      addrrd2                 : IN std_logic_vector(15 DOWNTO 0);   
      datain                  : IN std_logic_vector(13 DOWNTO 0);   
      we                      : IN std_logic;   
      re                      : IN std_logic;   
      dataout1                : OUT std_logic_vector(13 DOWNTO 0);   
      dataout2                : OUT std_logic_vector(13 DOWNTO 0));   
END deskew_ram_block;

ARCHITECTURE arch_deskew_ram_block OF deskew_ram_block IS

   CONSTANT  read_access_time      :  integer := 0;    
   CONSTANT  write_access_time     :  integer := 0;    
   CONSTANT  ram_width             :  integer := 14;    
   SIGNAL dataout1_i               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL dataout2_i               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_0            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_1            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_2            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_3            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_4            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_5            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_6            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_7            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_8            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_9            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_10           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_11           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_12           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_13           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_14           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_d_15           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_0            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_1            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_2            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_3            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_4            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_5            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_6            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_7            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_8            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_9            :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_10           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_11           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_12           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_13           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_14           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL ram_array_q_15           :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_0               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_1               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_2               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_3               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_4               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_5               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_6               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_7               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_8               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_9               :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_10              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_11              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_12              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_13              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_14              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL data_reg_15              :  std_logic_vector(ram_width - 1 DOWNTO 0);   
   SIGNAL dataout1_tmp1           :  std_logic_vector(13 DOWNTO 0);   
   SIGNAL dataout2_tmp2           :  std_logic_vector(13 DOWNTO 0);   

BEGIN
   dataout1 <= dataout1_tmp1;
   dataout2 <= dataout2_tmp2;
   data_reg_0 <= datain WHEN (addrwr(0) = '1') ELSE ram_array_q_0 ;
   data_reg_1 <= datain WHEN (addrwr(1) = '1') ELSE ram_array_q_1 ;
   data_reg_2 <= datain WHEN (addrwr(2) = '1') ELSE ram_array_q_2 ;
   data_reg_3 <= datain WHEN (addrwr(3) = '1') ELSE ram_array_q_3 ;
   data_reg_4 <= datain WHEN (addrwr(4) = '1') ELSE ram_array_q_4 ;
   data_reg_5 <= datain WHEN (addrwr(5) = '1') ELSE ram_array_q_5 ;
   data_reg_6 <= datain WHEN (addrwr(6) = '1') ELSE ram_array_q_6 ;
   data_reg_7 <= datain WHEN (addrwr(7) = '1') ELSE ram_array_q_7 ;
   data_reg_8 <= datain WHEN (addrwr(8) = '1') ELSE ram_array_q_8 ;
   data_reg_9 <= datain WHEN (addrwr(9) = '1') ELSE ram_array_q_9 ;
   data_reg_10 <= datain WHEN (addrwr(10) = '1') ELSE ram_array_q_10 ;
   data_reg_11 <= datain WHEN (addrwr(11) = '1') ELSE ram_array_q_11 ;
   data_reg_12 <= datain WHEN (addrwr(12) = '1') ELSE ram_array_q_12 ;
   data_reg_13 <= datain WHEN (addrwr(13) = '1') ELSE ram_array_q_13 ;
   data_reg_14 <= datain WHEN (addrwr(14) = '1') ELSE ram_array_q_14 ;
   data_reg_15 <= datain WHEN (addrwr(15) = '1') ELSE ram_array_q_15 ;
   dataout1_tmp1 <= "00000000000000" WHEN re = '1' ELSE dataout1_i after 0 ns;
   dataout2_tmp2 <= "00000000000000" WHEN re = '1' ELSE dataout2_i after 0 ns;

   PROCESS (ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3, ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7, ram_array_q_8, ram_array_q_9, ram_array_q_10, ram_array_q_11, ram_array_q_12, ram_array_q_13, ram_array_q_14, ram_array_q_15, addrrd1, addrrd2)
      VARIABLE dataout1_i_tmp3  : std_logic_vector(ram_width - 1 DOWNTO 0);
      VARIABLE dataout2_i_tmp4  : std_logic_vector(ram_width - 1 DOWNTO 0);
   BEGIN
      CASE addrrd1 IS
         WHEN "0000000000000001" =>
                  dataout1_i_tmp3 := ram_array_q_0;    
         WHEN "0000000000000010" =>
                  dataout1_i_tmp3 := ram_array_q_1;    
         WHEN "0000000000000100" =>
                  dataout1_i_tmp3 := ram_array_q_2;    
         WHEN "0000000000001000" =>
                  dataout1_i_tmp3 := ram_array_q_3;    
         WHEN "0000000000010000" =>
                  dataout1_i_tmp3 := ram_array_q_4;    
         WHEN "0000000000100000" =>
                  dataout1_i_tmp3 := ram_array_q_5;    
         WHEN "0000000001000000" =>
                  dataout1_i_tmp3 := ram_array_q_6;    
         WHEN "0000000010000000" =>
                  dataout1_i_tmp3 := ram_array_q_7;    
         WHEN "0000000100000000" =>
                  dataout1_i_tmp3 := ram_array_q_8;    
         WHEN "0000001000000000" =>
                  dataout1_i_tmp3 := ram_array_q_9;    
         WHEN "0000010000000000" =>
                  dataout1_i_tmp3 := ram_array_q_10;    
         WHEN "0000100000000000" =>
                  dataout1_i_tmp3 := ram_array_q_11;    
         WHEN "0001000000000000" =>
                  dataout1_i_tmp3 := ram_array_q_12;    
         WHEN "0010000000000000" =>
                  dataout1_i_tmp3 := ram_array_q_13;    
         WHEN "0100000000000000" =>
                  dataout1_i_tmp3 := ram_array_q_14;    
         WHEN "1000000000000000" =>
                  dataout1_i_tmp3 := ram_array_q_15;    
         WHEN OTHERS =>
                  NULL;
         
      END CASE;
      CASE addrrd2 IS
         WHEN "0000000000000001" =>
                  dataout2_i_tmp4 := ram_array_q_0;    
         WHEN "0000000000000010" =>
                  dataout2_i_tmp4 := ram_array_q_1;    
         WHEN "0000000000000100" =>
                  dataout2_i_tmp4 := ram_array_q_2;    
         WHEN "0000000000001000" =>
                  dataout2_i_tmp4 := ram_array_q_3;    
         WHEN "0000000000010000" =>
                  dataout2_i_tmp4 := ram_array_q_4;    
         WHEN "0000000000100000" =>
                  dataout2_i_tmp4 := ram_array_q_5;    
         WHEN "0000000001000000" =>
                  dataout2_i_tmp4 := ram_array_q_6;    
         WHEN "0000000010000000" =>
                  dataout2_i_tmp4 := ram_array_q_7;    
         WHEN "0000000100000000" =>
                  dataout2_i_tmp4 := ram_array_q_8;    
         WHEN "0000001000000000" =>
                  dataout2_i_tmp4 := ram_array_q_9;    
         WHEN "0000010000000000" =>
                  dataout2_i_tmp4 := ram_array_q_10;    
         WHEN "0000100000000000" =>
                  dataout2_i_tmp4 := ram_array_q_11;    
         WHEN "0001000000000000" =>
                  dataout2_i_tmp4 := ram_array_q_12;    
         WHEN "0010000000000000" =>
                  dataout2_i_tmp4 := ram_array_q_13;    
         WHEN "0100000000000000" =>
                  dataout2_i_tmp4 := ram_array_q_14;    
         WHEN "1000000000000000" =>
                  dataout2_i_tmp4 := ram_array_q_15;    
         WHEN OTHERS =>
                  NULL;
         
      END CASE;
      dataout1_i <= dataout1_i_tmp3;
      dataout2_i <= dataout2_i_tmp4;
   END PROCESS;

   PROCESS (clk, reset)
   BEGIN
      IF (reset = '1') THEN
         ram_array_q_0 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_1 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_2 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_3 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_4 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_5 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_6 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_7 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_8 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_9 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_10 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_11 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_12 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_13 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_14 <= "00000000000000" AFTER 0 ns;    
         ram_array_q_15 <= "00000000000000" AFTER 0 ns;    
      ELSIF (clk'EVENT AND clk = '1') THEN
         ram_array_q_0 <= ram_array_d_0 AFTER 0 ns;    
         ram_array_q_1 <= ram_array_d_1 AFTER 0 ns;    
         ram_array_q_2 <= ram_array_d_2 AFTER 0 ns;    
         ram_array_q_3 <= ram_array_d_3 AFTER 0 ns;    
         ram_array_q_4 <= ram_array_d_4 AFTER 0 ns;    
         ram_array_q_5 <= ram_array_d_5 AFTER 0 ns;    
         ram_array_q_6 <= ram_array_d_6 AFTER 0 ns;    
         ram_array_q_7 <= ram_array_d_7 AFTER 0 ns;    
         ram_array_q_8 <= ram_array_d_8 AFTER 0 ns;    
         ram_array_q_9 <= ram_array_d_9 AFTER 0 ns;    
         ram_array_q_10 <= ram_array_d_10 AFTER 0 ns;    
         ram_array_q_11 <= ram_array_d_11 AFTER 0 ns;    
         ram_array_q_12 <= ram_array_d_12 AFTER 0 ns;    
         ram_array_q_13 <= ram_array_d_13 AFTER 0 ns;    
         ram_array_q_14 <= ram_array_d_14 AFTER 0 ns;    
         ram_array_q_15 <= ram_array_d_15 AFTER 0 ns;    
      END IF;
   END PROCESS;

   PROCESS (we, data_reg_0, data_reg_1, data_reg_2, data_reg_3, data_reg_4, data_reg_5, data_reg_6, data_reg_7, data_reg_8, data_reg_9, data_reg_10, data_reg_11, data_reg_12, data_reg_13, data_reg_14, data_reg_15, ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3, ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7, ram_array_q_8, ram_array_q_9, ram_array_q_10, ram_array_q_11, ram_array_q_12, ram_array_q_13, ram_array_q_14, ram_array_q_15)
   BEGIN
      IF (we = '1') THEN
         ram_array_d_0 <= data_reg_0 AFTER 0 ns;    
         ram_array_d_1 <= data_reg_1 AFTER 0 ns;    
         ram_array_d_2 <= data_reg_2 AFTER 0 ns;    
         ram_array_d_3 <= data_reg_3 AFTER 0 ns;    
         ram_array_d_4 <= data_reg_4 AFTER 0 ns;    
         ram_array_d_5 <= data_reg_5 AFTER 0 ns;    
         ram_array_d_6 <= data_reg_6 AFTER 0 ns;    
         ram_array_d_7 <= data_reg_7 AFTER 0 ns;    
         ram_array_d_8 <= data_reg_8 AFTER 0 ns;    
         ram_array_d_9 <= data_reg_9 AFTER 0 ns;    
         ram_array_d_10 <= data_reg_10 AFTER 0 ns;    
         ram_array_d_11 <= data_reg_11 AFTER 0 ns;    
         ram_array_d_12 <= data_reg_12 AFTER 0 ns;    
         ram_array_d_13 <= data_reg_13 AFTER 0 ns;    
         ram_array_d_14 <= data_reg_14 AFTER 0 ns;    
         ram_array_d_15 <= data_reg_15 AFTER 0 ns;    
      ELSE
         ram_array_d_0 <= ram_array_q_0 AFTER 0 ns;    
         ram_array_d_1 <= ram_array_q_1 AFTER 0 ns;    
         ram_array_d_2 <= ram_array_q_2 AFTER 0 ns;    
         ram_array_d_3 <= ram_array_q_3 AFTER 0 ns;    
         ram_array_d_4 <= ram_array_q_4 AFTER 0 ns;    
         ram_array_d_5 <= ram_array_q_5 AFTER 0 ns;    
         ram_array_d_6 <= ram_array_q_6 AFTER 0 ns;    
         ram_array_d_7 <= ram_array_q_7 AFTER 0 ns;    
         ram_array_d_8 <= ram_array_q_8 AFTER 0 ns;    
         ram_array_d_9 <= ram_array_q_9 AFTER 0 ns;    
         ram_array_d_10 <= ram_array_q_10 AFTER 0 ns;    
         ram_array_d_11 <= ram_array_q_11 AFTER 0 ns;    
         ram_array_d_12 <= ram_array_q_12 AFTER 0 ns;    
         ram_array_d_13 <= ram_array_q_13 AFTER 0 ns;    
         ram_array_d_14 <= ram_array_q_14 AFTER 0 ns;    
         ram_array_d_15 <= ram_array_q_15 AFTER 0 ns;    
      END IF;
   END PROCESS;

END arch_deskew_ram_block;

--/////////////////////////////////////////////////////////////////////////////
--
--                              STRATIXGX_DESKEW_FIFO
--
--/////////////////////////////////////////////////////////////////////////////

library IEEE, stratixgx_gxb, std;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;
USE ieee.std_logic_arith.all; 

ENTITY stratixgx_deskew_fifo IS
   PORT (
      datain                  : IN std_logic_vector(9 DOWNTO 0);   
      errdetectin             : IN std_logic;   
      syncstatusin            : IN std_logic;   
      disperrin               : IN std_logic;   
      patterndetectin         : IN std_logic;   
      writeclock              : IN std_logic;   
      readclock               : IN std_logic;   
      adetectdeskew           : OUT std_logic;   
      fiforesetrd             : IN std_logic;   
      enabledeskew            : IN std_logic;   
      reset                   : IN std_logic;   
      dataout                 : OUT std_logic_vector(9 DOWNTO 0);   
      dataoutpre              : OUT std_logic_vector(9 DOWNTO 0);   
      errdetect               : OUT std_logic;   
      syncstatus              : OUT std_logic;   
      disperr                 : OUT std_logic;   
      patterndetect           : OUT std_logic;   
      errdetectpre            : OUT std_logic;   
      syncstatuspre           : OUT std_logic;   
      disperrpre              : OUT std_logic;   
      patterndetectpre        : OUT std_logic;   
      rdalign                 : OUT std_logic);   
END stratixgx_deskew_fifo;

ARCHITECTURE arch_stratixgx_deskew_fifo OF stratixgx_deskew_fifo IS

   COMPONENT deskew_ram_block
      PORT (
         clk                     : IN  std_logic;
         reset                   : IN  std_logic;
         addrwr                  : IN  std_logic_vector(15 DOWNTO 0);
         addrrd1                 : IN  std_logic_vector(15 DOWNTO 0);
         addrrd2                 : IN  std_logic_vector(15 DOWNTO 0);
         datain                  : IN  std_logic_vector(13 DOWNTO 0);
         we                      : IN  std_logic;
         re                      : IN  std_logic;
         dataout1                : OUT std_logic_vector(13 DOWNTO 0);
         dataout2                : OUT std_logic_vector(13 DOWNTO 0));
   END COMPONENT;


   CONSTANT  a                     :  std_logic_vector(9 DOWNTO 0) := "0011000011";    
   CONSTANT  FIFO_DEPTH            :  integer := 16;    
   SIGNAL fifo                     :  std_logic_vector(16 * 15 - 1 DOWNTO 0);   
   SIGNAL dataout_tmp              :  std_logic_vector(9 DOWNTO 0);   
   SIGNAL dataout_tmp_pre          :  std_logic_vector(9 DOWNTO 0);   
   SIGNAL dataout_fifo             :  std_logic_vector(13 DOWNTO 0);   
   SIGNAL adetectdeskew_tmp        :  std_logic;   
   SIGNAL errdetect_tmp            :  std_logic;   
   SIGNAL syncstatus_tmp           :  std_logic;   
   SIGNAL disperr_tmp              :  std_logic;   
   SIGNAL errdetect_tmp_pre        :  std_logic;   
   SIGNAL syncstatus_tmp_pre       :  std_logic;   
   SIGNAL disperr_tmp_pre          :  std_logic;   
   SIGNAL patterndetect_tmp        :  std_logic;   
   SIGNAL patterndetect_tmp_pre    :  std_logic;   
   SIGNAL align_count              :  std_logic_vector(3 DOWNTO 0);   
   SIGNAL adetect_deskew           :  std_logic;   
   SIGNAL adetect_deskew_dly       :  std_logic;
   SIGNAL enabledeskew_dly0        :  std_logic;   
   SIGNAL enabledeskew_dly1        :  std_logic;   
   SIGNAL enabledeskew_dly2        :  std_logic;   
   SIGNAL adetectdeskew_dly        :  std_logic;   
   SIGNAL write_enable             :  std_logic;   
   SIGNAL wr_enable                :  std_logic;   
   SIGNAL reset_fifo               :  std_logic;   
   SIGNAL reset_write              :  std_logic;   
   SIGNAL wr_align                 :  std_logic;   
   SIGNAL AUDI_d                   :  std_logic_vector(13 DOWNTO 0);   
   SIGNAL AUDI_pre_d               :  std_logic_vector(13 DOWNTO 0);   
   SIGNAL write_ptr                :  std_logic_vector(FIFO_DEPTH - 1 DOWNTO 0);   
   SIGNAL read_ptr1                :  std_logic_vector(FIFO_DEPTH - 1 DOWNTO 0);   
   SIGNAL read_ptr2                :  std_logic_vector(FIFO_DEPTH - 1 DOWNTO 0);   
   -- WRITE ENABLE LOGIC
   SIGNAL tmp_23                  :  std_logic_vector(13 DOWNTO 0);   
   -- active low
   -- active high
   SIGNAL port_tmp24              :  std_logic;   
   SIGNAL port_tmp25              :  std_logic;   
   SIGNAL adetect_out              :  std_logic;
   SIGNAL adetect_in               :  std_logic;

BEGIN

   PROCESS (reset, writeclock)
   BEGIN
      IF (reset = '1') THEN
         write_ptr <= "0000000000000001";    
      ELSIF (writeclock'EVENT AND writeclock = '1') THEN
         IF ((reset_fifo OR reset_write) = '1') THEN
            write_ptr <= "0000000000000001";    
         ELSE
            IF ((wr_enable OR wr_align) = '1') THEN
               write_ptr <= write_ptr(FIFO_DEPTH - 2 DOWNTO 0) & write_ptr(FIFO_DEPTH - 1);    
            ELSE
               write_ptr <= write_ptr;    
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (reset, readclock)
   BEGIN
      IF (reset = '1') THEN
         read_ptr1 <= "0000000000000001";    
         read_ptr2 <= "0000000000000010";    
      ELSIF (readclock'EVENT AND readclock = '1') THEN
         IF (fiforesetrd = '1') THEN
            read_ptr1 <= "0000000000000001";    
            read_ptr2 <= "0000000000000010";    
         ELSE
            IF (NOT enabledeskew = '1') THEN
               read_ptr1 <= read_ptr1(FIFO_DEPTH - 2 DOWNTO 0) & read_ptr1(FIFO_DEPTH - 1);    
               read_ptr2 <= read_ptr2(FIFO_DEPTH - 2 DOWNTO 0) & read_ptr2(FIFO_DEPTH - 1);    
            ELSE
               read_ptr1 <= "0000000000000001";    
               read_ptr2 <= "0000000000000010";    
            END IF;
         END IF;
      END IF;
   END PROCESS;
   tmp_23 <= patterndetectin & disperrin & syncstatusin & errdetectin & datain(9 DOWNTO 0);
   port_tmp24 <= '1';
   port_tmp25 <= '0';
   deskew_ram : deskew_ram_block 
      PORT MAP (
         clk => writeclock,
         reset => reset,
         addrwr => write_ptr,
         addrrd1 => read_ptr1,
         addrrd2 => read_ptr2,
         datain => tmp_23,
         we => port_tmp24,
         re => port_tmp25,
         dataout1 => AUDI_d,
         dataout2 => AUDI_pre_d);   
   
   PROCESS (reset, readclock)
      VARIABLE dataout_tmp_tmp26  : std_logic_vector(9 DOWNTO 0);
      VARIABLE errdetect_tmp_tmp27  : std_logic;
      VARIABLE syncstatus_tmp_tmp28  : std_logic;
      VARIABLE disperr_tmp_tmp29  : std_logic;
      VARIABLE dataout_tmp_pre_tmp30  : std_logic_vector(9 DOWNTO 0);
      VARIABLE errdetect_tmp_pre_tmp31  : std_logic;
      VARIABLE syncstatus_tmp_pre_tmp32  : std_logic;
      VARIABLE disperr_tmp_pre_tmp33  : std_logic;
      VARIABLE patterndetect_tmp_tmp34  : std_logic;
      VARIABLE patterndetect_tmp_pre_tmp35  : std_logic;
   BEGIN
      IF (reset = '1') THEN
         dataout_tmp_tmp26 := "0000000000";    
         errdetect_tmp_tmp27 := '0';    
         syncstatus_tmp_tmp28 := '0';    
         disperr_tmp_tmp29 := '0';    
         dataout_tmp_pre_tmp30 := "0000000000";    
         errdetect_tmp_pre_tmp31 := '0';    
         syncstatus_tmp_pre_tmp32 := '0';    
         disperr_tmp_pre_tmp33 := '0';    
         patterndetect_tmp_tmp34 := '0';    
         patterndetect_tmp_pre_tmp35 := '0';    
      ELSIF (readclock'EVENT AND readclock = '1') THEN
         dataout_tmp_tmp26 := AUDI_d(9 DOWNTO 0);    
         errdetect_tmp_tmp27 := AUDI_d(10);    
         syncstatus_tmp_tmp28 := AUDI_d(11);    
         disperr_tmp_tmp29 := AUDI_d(12);    
         patterndetect_tmp_tmp34 := AUDI_d(13);    
         dataout_tmp_pre_tmp30 := AUDI_pre_d(9 DOWNTO 0);    
         errdetect_tmp_pre_tmp31 := AUDI_pre_d(10);    
         syncstatus_tmp_pre_tmp32 := AUDI_pre_d(11);    
         disperr_tmp_pre_tmp33 := AUDI_pre_d(12);    
         patterndetect_tmp_pre_tmp35 := AUDI_pre_d(13);    
      END IF;
      dataout_tmp <= dataout_tmp_tmp26;
      errdetect_tmp <= errdetect_tmp_tmp27;
      syncstatus_tmp <= syncstatus_tmp_tmp28;
      disperr_tmp <= disperr_tmp_tmp29;
      dataout_tmp_pre <= dataout_tmp_pre_tmp30;
      errdetect_tmp_pre <= errdetect_tmp_pre_tmp31;
      syncstatus_tmp_pre <= syncstatus_tmp_pre_tmp32;
      disperr_tmp_pre <= disperr_tmp_pre_tmp33;
      patterndetect_tmp <= patterndetect_tmp_tmp34;
      patterndetect_tmp_pre <= patterndetect_tmp_pre_tmp35;
   END PROCESS;

   PROCESS (reset, writeclock)
   BEGIN
      IF (reset = '1') THEN
         wr_enable <= '0';    
      ELSIF (writeclock'EVENT AND writeclock = '1') THEN
         IF ((reset_fifo OR reset_write) = '1') THEN
            wr_enable <= '0';    
         ELSE
            IF (wr_align = '1') THEN
               wr_enable <= '1';    
            ELSE
               wr_enable <= wr_enable;    
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (writeclock, reset)
   BEGIN
      IF (reset = '1') THEN
         adetect_deskew <= '0';    
      ELSIF (writeclock'EVENT AND writeclock = '1') THEN
         IF (wr_align = '1') THEN
            adetect_deskew <= '1';    
         ELSE
            IF (align_count = 0) THEN
               adetect_deskew <= '0';    
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (reset, writeclock)
   BEGIN
      IF (reset = '1') THEN
         align_count <= "0000";    
      ELSIF (writeclock'EVENT AND writeclock = '1') THEN
         IF (NOT enabledeskew_dly1 = '1') THEN
            align_count <= "0000";    
         ELSE
            IF (wr_align = '1') THEN
               align_count <= "1001";    
            ELSE
               IF (align_count /= 0) THEN
                  align_count <= align_count - "0001";    
               END IF;
            END IF;
         END IF;
      END IF;
   END PROCESS;

   PROCESS (writeclock, reset)
   BEGIN
      IF (reset = '1') THEN
         enabledeskew_dly0 <= '1';    
         enabledeskew_dly1 <= '1';    
         enabledeskew_dly2 <= '1';    
      ELSIF (writeclock'EVENT AND writeclock = '1') THEN
         enabledeskew_dly0 <= enabledeskew;    
         enabledeskew_dly1 <= enabledeskew_dly0;    
         enabledeskew_dly2 <= enabledeskew_dly1;    
      END IF;
   END PROCESS;

   adetect_deskew_dly <= adetect_deskew after 1 ps;

   PROCESS (reset, readclock)
   BEGIN
      IF (reset = '1') THEN
         adetectdeskew_dly <= '0';    
         adetectdeskew_tmp <= '0';    
      ELSIF (readclock'EVENT AND readclock = '1') THEN
         adetectdeskew_dly <= adetect_deskew_dly;    
         adetectdeskew_tmp <= adetectdeskew_dly;    
      END IF;
   END PROCESS;

   adetect_out <= '1' when ((unsigned(dataout_tmp(9 DOWNTO 0)) = unsigned(a)) OR 
   (unsigned(dataout_tmp(9 DOWNTO 0)) = unsigned(NOT a))) else '0';
   adetect_in <= '1' when ((unsigned(datain(9 DOWNTO 0)) = unsigned(a)) OR 
   (unsigned(datain(9 DOWNTO 0)) = unsigned(NOT a))) else '0';
   rdalign <= '1' when ( (adetect_out = '1') AND (disperr_tmp = '0') AND (errdetect_tmp = '0') ) else '0' ;
   wr_align <= '1' when ((adetect_in = '1') AND (enabledeskew_dly1 = '1') AND (disperrin = '0') AND (errdetectin = '0')) else '0';
   reset_fifo <= (wr_enable AND write_ptr(FIFO_DEPTH - 1)) AND enabledeskew_dly1 ;
   reset_write <= enabledeskew_dly1 AND NOT enabledeskew_dly2 ;
   adetectdeskew <= adetectdeskew_tmp ;
   dataout <= dataout_tmp ;
   errdetect <= errdetect_tmp ;
   syncstatus <= syncstatus_tmp ;
   disperr <= disperr_tmp ;
   dataoutpre <= dataout_tmp_pre ;
   errdetectpre <= errdetect_tmp_pre ;
   syncstatuspre <= syncstatus_tmp_pre ;
   disperrpre <= disperr_tmp_pre ;
   patterndetect <= patterndetect_tmp ;
   patterndetectpre <= patterndetect_tmp_pre ;

END arch_stratixgx_deskew_fifo;


--/////////////////////////////////////////////////////////////////////////////
--
--                               STRATIXGX_RX_CORE
--
--/////////////////////////////////////////////////////////////////////////////

LIBRARY ieee, stratixgx_gxb;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;
USE ieee.std_logic_arith.all;
use stratixgx_gxb.hssi_pack.all;

ENTITY stratixgx_rx_core IS
   GENERIC (
      channel_width                  :  integer := 10;    
      use_double_data_mode           :  string  := "false";    
      use_channel_align              :  string  := "false";    
      use_8b_10b_mode                :  string  := "true";    
      align_pattern                      :  string  := "0000000000000000";
      synchronization_mode           :  string  := "none");
   PORT (
      reset                   : IN std_logic;   
      writeclk                : IN std_logic;   
      readclk                 : IN std_logic;   
      errdetectin             : IN std_logic;   
      patterndetectin         : IN std_logic;   
      decdatavalid            : IN std_logic;   
      xgmdatain               : IN std_logic_vector(7 DOWNTO 0);   
      post8b10b               : IN std_logic_vector(9 DOWNTO 0);   
      datain                  : IN std_logic_vector(9 DOWNTO 0);   
      xgmctrlin               : IN std_logic;   
      ctrldetectin            : IN std_logic;   
      syncstatusin            : IN std_logic;   
      disparityerrin          : IN std_logic;   
      syncstatus              : OUT std_logic_vector(1 DOWNTO 0);   
      errdetect               : OUT std_logic_vector(1 DOWNTO 0);   
      ctrldetect              : OUT std_logic_vector(1 DOWNTO 0);   
      disparityerr            : OUT std_logic_vector(1 DOWNTO 0);   
      patterndetect           : OUT std_logic_vector(1 DOWNTO 0);   
      dataout                 : OUT std_logic_vector(19 DOWNTO 0);   
      a1a2sizeout             : OUT std_logic_vector(1 DOWNTO 0);   
      clkout                  : OUT std_logic);   
END stratixgx_rx_core;

ARCHITECTURE arch_stratixgx_rx_core OF stratixgx_rx_core IS
   SIGNAL detect                   :  std_logic;   
   SIGNAL xgmxor                   :  std_logic_vector(7 DOWNTO 0);   
   SIGNAL resync_d                 :  std_logic;   
   SIGNAL disperr_d                :  std_logic;   
   SIGNAL patterndetect_d          :  std_logic;   
   SIGNAL syncstatusin_1           :  std_logic;   
   SIGNAL syncstatusin_2           :  std_logic;   
   SIGNAL disparityerrin_1         :  std_logic;   
   SIGNAL disparityerrin_2         :  std_logic;   
   SIGNAL patterndetectin_1        :  std_logic;   
   SIGNAL patterndetectin_2        :  std_logic;   
   SIGNAL writeclk_by2             :  std_logic := '0';   
   SIGNAL data_low_sync            :  std_logic_vector(12 DOWNTO 0);   
   SIGNAL data_low                 :  std_logic_vector(12 DOWNTO 0);   
   SIGNAL data_high                :  std_logic_vector(12 DOWNTO 0);   
   SIGNAL data_int                 :  std_logic_vector(9 DOWNTO 0);   
   SIGNAL dataout_tmp              :  std_logic_vector(19 DOWNTO 0);   
   SIGNAL patterndetect_tmp        :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL disparityerr_tmp         :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL syncstatus_tmp           :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL errdetect_tmp            :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL ctrldetect_tmp           :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL a1a2sizeout_tmp          :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL dataout_sync1            :  std_logic_vector(19 DOWNTO 0);   
   SIGNAL patterndetect_sync1      :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL disparityerr_sync1       :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL syncstatus_sync1         :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL errdetect_sync1          :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL ctrldetect_sync1         :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL a1a2sizeout_sync1        :  std_logic_vector(1 DOWNTO 0) := "00";
   SIGNAL dataout_sync2            :  std_logic_vector(19 DOWNTO 0);   
   SIGNAL patterndetect_sync2      :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL disparityerr_sync2       :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL syncstatus_sync2         :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL errdetect_sync2          :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL ctrldetect_sync2         :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL a1a2sizeout_sync2        :  std_logic_vector(1 DOWNTO 0) := "00";
   SIGNAL doublewidth              :  std_logic;   
   SIGNAL individual               :  std_logic;   
   SIGNAL ena8b10b                 :  std_logic;   
   SIGNAL smdisable                :  std_logic;   
   SIGNAL syncstatus_tmp1         :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL errdetect_tmp2          :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL ctrldetect_tmp3         :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL disparityerr_tmp4       :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL patterndetect_tmp5      :  std_logic_vector(1 DOWNTO 0);   
   SIGNAL dataout_tmp6            :  std_logic_vector(19 DOWNTO 0);   
   SIGNAL a1a2sizeout_tmp7        :  std_logic_vector(1 downto 0);   
   SIGNAL clkout_tmp8             :  std_logic;   
   SIGNAL running_disp            :  std_logic;
   -- A1A2 patterndetect related signals
   signal align_pattern_int : std_logic_vector(15 downto 0);
   signal patterndetect_8b : std_logic;
   signal patterndetect_1_latch : std_logic;
   signal patterndetect_2_latch : std_logic;
   signal patterndetect_3_latch : std_logic;

BEGIN
  
   syncstatus <= syncstatus_tmp1;
   errdetect <= errdetect_tmp2;
   ctrldetect <= ctrldetect_tmp3;
   disparityerr <= disparityerr_tmp4;
   patterndetect <= patterndetect_tmp5;
   dataout <= dataout_tmp6;
   a1a2sizeout <= a1a2sizeout_tmp7;
   clkout <= clkout_tmp8;
   doublewidth <= '1' WHEN (use_double_data_mode = "true") ELSE '0' ;
   individual <= '1' WHEN (use_channel_align /= "true") ELSE '0' ;
   ena8b10b <= '1' WHEN (use_8b_10b_mode = "true") ELSE '0' ;
   smdisable <= '1' WHEN (synchronization_mode = "none") ELSE '0' ;
   running_disp <= disparityerrin OR errdetectin;
   
   -- A1A2 pattern detection
   align_pattern_int <= pattern_conversion(align_pattern);

   -- A1A2 patterndetect block
   PROCESS (datain, align_pattern_int, patterndetect_1_latch, patterndetect_3_latch)
      VARIABLE patterndetect_8b_tmp10  : std_logic;
      VARIABLE match_tmp  : std_logic := '0';
   BEGIN
      IF (datain(8) = '1') THEN
         if (UNSIGNED(datain(7 DOWNTO 0)) = UNSIGNED(align_pattern_int(15 DOWNTO 8))) then
            match_tmp := '1';
         else
            match_tmp := '0';
         end if;
         patterndetect_8b_tmp10 := match_tmp AND patterndetect_3_latch;    
      ELSE
         if (UNSIGNED(datain(7 DOWNTO 0)) = UNSIGNED(align_pattern_int(15 DOWNTO 8))) then
            match_tmp := '1';
         else
            match_tmp := '0';
         end if;
         patterndetect_8b_tmp10 := match_tmp AND patterndetect_1_latch;    
      END IF;
      patterndetect_8b <= patterndetect_8b_tmp10;
   END PROCESS;

   -- A1A2 patterndetect latch
   PROCESS (reset, writeclk)
      VARIABLE match_low  : std_logic := '0';
      VARIABLE match_high  : std_logic := '0';
   BEGIN
      IF (reset = '1') THEN
         patterndetect_1_latch <= '0';    
         patterndetect_2_latch <= '0';    
         patterndetect_3_latch <= '0';    
      ELSIF (writeclk'EVENT AND writeclk = '1') THEN
         if (UNSIGNED(datain(7 DOWNTO 0)) = UNSIGNED(align_pattern_int(7 DOWNTO 0))) then
            match_low := '1';
         else
            match_low := '0';
         end if;    

         if (UNSIGNED(datain(7 DOWNTO 0)) = UNSIGNED(align_pattern_int(15 DOWNTO 8))) then
            match_high := '1';
         else
            match_high := '0';
         end if;    

         patterndetect_1_latch <= match_low;
         patterndetect_2_latch <= (patterndetect_1_latch) AND match_low;
         patterndetect_3_latch <= (patterndetect_2_latch) AND match_high;
      END IF;
   END PROCESS;

   PROCESS (xgmdatain, datain, xgmctrlin, ctrldetectin, decdatavalid, data_int, syncstatusin, disparityerrin, patterndetectin, patterndetect_8b, syncstatusin_2, disparityerrin_2, patterndetectin_2, running_disp)
    variable i_detect : std_logic;
   BEGIN
      IF (ena8b10b = '1') THEN
         IF (individual = '1') THEN
            resync_d <= syncstatusin;    
            disperr_d <= disparityerrin;    
            IF ((NOT decdatavalid AND NOT smdisable) = '1') THEN
               data_int(8 DOWNTO 0) <= "110011100";    
               data_int(9) <= '0';    
               patterndetect_d <= '0';    
            ELSE
               IF (channel_width = 10) THEN
                  patterndetect_d <= patterndetectin;    
               ELSE
                  patterndetect_d <= patterndetect_8b;    
               END IF;

               IF (((decdatavalid AND NOT smdisable) AND running_disp) = '1') THEN
                  data_int(8 DOWNTO 0) <= "111111110";    
                  data_int(9) <= running_disp;    
               ELSE
                  data_int(8 DOWNTO 0) <= ctrldetectin & datain(7 DOWNTO 0);    
                  data_int(9) <= running_disp;    
               END IF;
            END IF;
         ELSE
            resync_d <= syncstatusin_2;    
            disperr_d <= disparityerrin_2;    
            patterndetect_d <= patterndetectin_2;    
            data_int(8 DOWNTO 0) <= xgmctrlin & xgmdatain(7 DOWNTO 0);    
            i_detect := '0';
            if (xgmxor /= 0) then
            i_detect := '1';
            end if;
        data_int(9) <= xgmctrlin AND NOT i_detect;    

         END IF;
      ELSE
         resync_d <= syncstatusin;    
         disperr_d <= disparityerrin;    
         data_int <= datain;    
         IF ((NOT decdatavalid AND NOT smdisable) = '1') THEN
            patterndetect_d <= '0';    
         ELSE
            IF (channel_width = 10) THEN
               patterndetect_d <= patterndetectin;    
            ELSE
               patterndetect_d <= patterndetect_8b;    
            END IF;
         END IF;
      END IF;
   END PROCESS;
   xgmxor <= xgmdatain(7 DOWNTO 0) XOR "11111110" ;

   PROCESS (reset, writeclk)
   BEGIN
      IF (reset = '1') THEN
         writeclk_by2 <= '0';    
         data_high <= "0000000000000";    
         data_low <= "0000000000000";    
         data_low_sync <= "0000000000000";    
         syncstatusin_1 <= '0';    
         syncstatusin_2 <= '0';    
         disparityerrin_1 <= '0';    
         disparityerrin_2 <= '0';    
         patterndetectin_1 <= '0';    
         patterndetectin_2 <= '0';    
      ELSIF (writeclk'EVENT AND writeclk = '1') THEN
         writeclk_by2 <= NOT ((writeclk_by2 AND individual) OR (writeclk_by2 AND NOT individual));    
         syncstatusin_1 <= syncstatusin;    
         syncstatusin_2 <= syncstatusin_1;    
         disparityerrin_1 <= disparityerrin;    
         disparityerrin_2 <= disparityerrin_1;    
         patterndetectin_1 <= patterndetectin;    
         patterndetectin_2 <= patterndetectin_1;    
         IF ((doublewidth AND NOT writeclk_by2) = '1') THEN
            data_high(9 DOWNTO 0) <= data_int;    
            data_high(10) <= resync_d;    
            data_high(11) <= disperr_d;    
            data_high(12) <= patterndetect_d;    
         END IF;
         IF ((doublewidth AND writeclk_by2) = '1') THEN
            data_low(9 DOWNTO 0) <= data_int;    
            data_low(10) <= resync_d;    
            data_low(11) <= disperr_d;    
            data_low(12) <= patterndetect_d;    
         END IF;
         IF (NOT doublewidth = '1') THEN
            data_low_sync(9 DOWNTO 0) <= data_int;    
            data_low_sync(10) <= resync_d;    
            data_low_sync(11) <= disperr_d;    
            data_low_sync(12) <= patterndetect_d;    
         ELSE
            data_low_sync <= data_low;    
         END IF;
      END IF;
   END PROCESS;

   PROCESS (writeclk_by2, writeclk)
   BEGIN
      IF (doublewidth = '1') THEN
         clkout_tmp8 <= NOT writeclk_by2;    
      ELSE
         clkout_tmp8 <= NOT writeclk;    
      END IF;
   END PROCESS;

   PROCESS (reset, readclk)
   BEGIN
      IF (reset = '1') THEN
         dataout_tmp <= "00000000000000000000";    
         patterndetect_tmp <= "00";    
         disparityerr_tmp <= "00";    
         syncstatus_tmp <= "00";    
         errdetect_tmp <= "00";    
         ctrldetect_tmp <= "00";    
         a1a2sizeout_tmp <= "00";    
         dataout_sync1 <= "00000000000000000000";    
         patterndetect_sync1 <= "00";    
         disparityerr_sync1 <= "00";    
         syncstatus_sync1 <= "00";    
         errdetect_sync1 <= "00";    
         ctrldetect_sync1 <= "00";    
         a1a2sizeout_sync1 <= "00";   
         dataout_sync2 <= "00000000000000000000";    
         patterndetect_sync2 <= "00";    
         disparityerr_sync2 <= "00";    
         syncstatus_sync2 <= "00";    
         errdetect_sync2 <= "00";    
         ctrldetect_sync2 <= "00";
         a1a2sizeout_sync2 <= "00";   
      ELSIF (readclk'EVENT AND readclk = '1') THEN
         IF (ena8b10b = '1' OR channel_width = 8 OR channel_width = 16) THEN
            dataout_sync1 <= "0000" & data_high(7 DOWNTO 0) & data_low_sync(7 DOWNTO 0);    
         ELSE
            dataout_sync1 <= data_high(9 DOWNTO 0) & data_low_sync(9 DOWNTO 0);    
         END IF;

         patterndetect_sync1 <= data_high(12) & data_low_sync(12);    
         disparityerr_sync1 <= data_high(11) & data_low_sync(11);    
         syncstatus_sync1 <= data_high(10) & data_low_sync(10);    
         errdetect_sync1 <= data_high(9) & data_low_sync(9);    
         ctrldetect_sync1 <= data_high(8) & data_low_sync(8);    
         IF (channel_width = 8) THEN
            a1a2sizeout_sync1 <= data_high(8) & data_low_sync(8);    
         ELSE
            a1a2sizeout_sync1 <= "00";    
         END IF;
         dataout_sync2 <= dataout_sync1;    
         patterndetect_sync2 <= patterndetect_sync1;    
         disparityerr_sync2 <= disparityerr_sync1;    
         syncstatus_sync2 <= syncstatus_sync1;    
         errdetect_sync2 <= errdetect_sync1;    
         ctrldetect_sync2 <= ctrldetect_sync1;    
         a1a2sizeout_sync2 <= a1a2sizeout_sync1;    
         dataout_tmp <= dataout_sync2;    
         patterndetect_tmp <= patterndetect_sync2;    
         disparityerr_tmp <= disparityerr_sync2;    
         syncstatus_tmp <= syncstatus_sync2;    
         errdetect_tmp <= errdetect_sync2;    
         ctrldetect_tmp <= ctrldetect_sync2;    
         a1a2sizeout_tmp <= a1a2sizeout_sync2;    
      END IF;
   END PROCESS;
   dataout_tmp6 <= dataout_tmp ;
   a1a2sizeout_tmp7 <= a1a2sizeout_tmp;
   patterndetect_tmp5 <= patterndetect_tmp ;
   disparityerr_tmp4 <= disparityerr_tmp ;
   syncstatus_tmp1 <= syncstatus_tmp ;
   errdetect_tmp2 <= errdetect_tmp ;
   ctrldetect_tmp3 <= ctrldetect_tmp ;

END arch_stratixgx_rx_core;

--/////////////////////////////////////////////////////////////////////////////
--
--                               STRATIXGX_TX_CORE
--
--/////////////////////////////////////////////////////////////////////////////

LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_unsigned.all;

ENTITY stratixgx_tx_core IS
   GENERIC (
      use_double_data_mode           :  string := "false";    
      use_fifo_mode                  :  string := "true";    
      transmit_protocol              :  string := "none";
      channel_width                  :  integer := 10;    
      KCHAR                          :  std_logic := '0';    
      ECHAR                          :  std_logic := '0');
   PORT (
      reset                   : IN std_logic;   
      datain                  : IN std_logic_vector(19 DOWNTO 0);   
      writeclk                : IN std_logic;   
      readclk                 : IN std_logic;   
      ctrlena                 : IN std_logic_vector(1 DOWNTO 0);   
      forcedisp               : IN std_logic_vector(1 DOWNTO 0);   
      dataout                 : OUT std_logic_vector(9 DOWNTO 0);   
      forcedispout            : OUT std_logic;   
      ctrlenaout              : OUT std_logic;   
      rdenasync               : OUT std_logic;   
      xgmctrlena              : OUT std_logic;   
      xgmdataout              : OUT std_logic_vector(7 DOWNTO 0);   
      pre8b10bdataout         : OUT std_logic_vector(9 DOWNTO 0));   
END stratixgx_tx_core;

ARCHITECTURE arch_stratixgx_tx_core OF stratixgx_tx_core IS
   SIGNAL kchar_sync_1             :  std_logic;   
   SIGNAL kchar_sync               :  std_logic;   
   SIGNAL echar_sync_1             :  std_logic;   
   SIGNAL echar_sync               :  std_logic;   
   SIGNAL datain_high              :  std_logic_vector(11 DOWNTO 0);   
   SIGNAL datain_low               :  std_logic_vector(11 DOWNTO 0);   
   SIGNAL fifo_high_tmp            :  std_logic_vector(11 DOWNTO 0);   
   SIGNAL fifo_high_dly1           :  std_logic_vector(11 DOWNTO 0);   
   SIGNAL fifo_high_dly2           :  std_logic_vector(11 DOWNTO 0);   
   SIGNAL fifo_high_dly3           :  std_logic_vector(11 DOWNTO 0);   
   SIGNAL fifo_low_tmp             :  std_logic_vector(11 DOWNTO 0);   
   SIGNAL fifo_low_dly1            :  std_logic_vector(11 DOWNTO 0);   
   SIGNAL fifo_low_dly2            :  std_logic_vector(11 DOWNTO 0);   
   SIGNAL fifo_low_dly3            :  std_logic_vector(11 DOWNTO 0);   
   SIGNAL dataout_read             :  std_logic_vector(11 DOWNTO 0);   
   SIGNAL wr_enable                :  std_logic;   
   SIGNAL rd_enable_sync_1         :  std_logic;   
   SIGNAL rd_enable_sync_2         :  std_logic;   
   SIGNAL rd_enable_sync_out       :  std_logic;   
   SIGNAL fifo_select_out          :  std_logic;   
   SIGNAL rdenasync_tmp            :  std_logic;   
   SIGNAL out_ena1                 :  std_logic;   
   SIGNAL out_ena2                 :  std_logic;   
   SIGNAL out_ena3                 :  std_logic;   
   SIGNAL out_ena4                 :  std_logic;   
   SIGNAL out_ena5                 :  std_logic;   
   SIGNAL doublewidth              :  std_logic;   
   SIGNAL disablefifo              :  std_logic;   
   SIGNAL individual               :  std_logic;   
   SIGNAL writeclk_dly             :  std_logic;   

BEGIN
   doublewidth <= '1' WHEN (use_double_data_mode = "true") ELSE '0' ;
   disablefifo <= '1' WHEN (use_fifo_mode = "false") ELSE '0' ;
   individual <= '1' WHEN (transmit_protocol /= "xaui") ELSE '0' ;

   PROCESS (writeclk)
   BEGIN
     writeclk_dly <= writeclk;
   END PROCESS;

   PROCESS (reset, readclk)
   BEGIN
      IF (reset = '1') THEN
         kchar_sync_1 <= '0';    
         kchar_sync <= '0';    
         echar_sync_1 <= '0';    
         echar_sync <= '0';    
      ELSIF (readclk'EVENT AND readclk = '1') THEN
         kchar_sync_1 <= KCHAR;    
         kchar_sync <= kchar_sync_1;    
         echar_sync_1 <= ECHAR;    
         echar_sync <= echar_sync_1;    
      END IF;
   END PROCESS;

   -- outputs
   dataout         <= dataout_read(9 DOWNTO 0);
   xgmdataout      <= dataout_read(7 DOWNTO 0);
   pre8b10bdataout <= dataout_read(9 DOWNTO 0);

   forcedispout    <= dataout_read(10);
   ctrlenaout      <= dataout_read(11);
   xgmctrlena      <= dataout_read(11);

   rdenasync       <= rdenasync_tmp;

   PROCESS (reset, writeclk_dly, datain, forcedisp, ctrlena)
   BEGIN
      IF (reset = '1') THEN
         datain_high(11 DOWNTO 0) <= "000000000000";    
         datain_low(11 DOWNTO 0) <= "000000000000";    
      ELSE
         IF (channel_width = 10 OR channel_width = 20) THEN
              IF (doublewidth = '1') THEN
                datain_high(11 DOWNTO 0) <= ctrlena(1) & forcedisp(1) & datain(19 DOWNTO 10);
              ELSE
                datain_high(11 DOWNTO 0) <= ctrlena(0) & forcedisp(0) & datain(9 DOWNTO 0);
              END IF;

              datain_low(11 DOWNTO 0) <= ctrlena(0) & forcedisp(0) & datain(9 DOWNTO 0);   
        ELSE
              IF (doublewidth = '1') THEN
                datain_high(11 DOWNTO 0) <= ctrlena(1) & forcedisp(1) & "00" & datain(15 DOWNTO 8);
              ELSE
                datain_high(11 DOWNTO 0) <= ctrlena(0) & forcedisp(0) & "00" & datain(7 DOWNTO 0);
              END IF;

              datain_low(11 DOWNTO 0) <= ctrlena(0) & forcedisp(0) & "00" & datain(7 DOWNTO 0);
        END IF;
      END IF;
   END PROCESS;

   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1') THEN
         fifo_high_dly1 <= "000000000000";    
         fifo_high_dly2 <= "000000000000";    
         fifo_high_dly3 <= "000000000000";    
         fifo_high_tmp <= "000000000000";    
      ELSIF (writeclk_dly'EVENT AND writeclk_dly = '1') THEN
         fifo_high_dly1 <= datain_high;    
         fifo_high_dly2 <= fifo_high_dly1;    
         fifo_high_dly3 <= fifo_high_dly2;    
         fifo_high_tmp <= fifo_high_dly3;    
      END IF;
   END PROCESS;

   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1') THEN
         fifo_low_dly1 <= "000000000000";    
         fifo_low_dly2 <= "000000000000";    
         fifo_low_dly3 <= "000000000000";    
         fifo_low_tmp <= "000000000000";    
      ELSIF (writeclk_dly'EVENT AND writeclk_dly = '1') THEN
         fifo_low_dly1 <= datain_low;    
         fifo_low_dly2 <= fifo_low_dly1;    
         fifo_low_dly3 <= fifo_low_dly2;    
         fifo_low_tmp <= fifo_low_dly3;    
      END IF;
   END PROCESS;

   -- DATAOUT ENALBE LOGIC
   out_ena1 <= (((NOT disablefifo AND rdenasync_tmp) AND (NOT doublewidth OR fifo_select_out)) AND NOT kchar_sync) AND NOT echar_sync ;
   out_ena2 <= (((NOT disablefifo AND rdenasync_tmp) AND (doublewidth AND NOT fifo_select_out)) AND NOT kchar_sync) AND NOT echar_sync ;
   out_ena3 <= ((disablefifo AND (NOT doublewidth OR NOT fifo_select_out)) AND NOT kchar_sync) AND NOT echar_sync ;
   out_ena4 <= NOT kchar_sync AND echar_sync ;
   out_ena5 <= (((disablefifo AND doublewidth) AND fifo_select_out) AND NOT kchar_sync) AND NOT echar_sync ;

   -- Dataout, CTRL, FORCE_DISP registered by read clock
   PROCESS (reset, readclk)
   BEGIN
      IF (reset = '1') THEN
         dataout_read(11 DOWNTO 0) <= "000000000000";    
      ELSIF (readclk'EVENT AND readclk = '1') THEN
       IF (out_ena1 = '1') THEN
         dataout_read <= fifo_low_tmp;
       ELSIF (out_ena2 = '1') THEN
         dataout_read <= fifo_high_tmp;
       ELSIF (out_ena3 = '1') THEN
         dataout_read <= datain_low;         
       ELSIF (out_ena4 = '1') THEN
           dataout_read(7 DOWNTO 0) <= "11111110";
           dataout_read(10) <= '0';
           dataout_read(11) <= '1';
       ELSIF (out_ena5 = '1') THEN
           dataout_read <= datain_high;
       ELSE 
           dataout_read(10) <= '0';
           dataout_read(11) <= '1';  -- fixed from 0 to 1 in 3.0 .
           IF ((NOT individual) = '1') THEN
             dataout_read(7 DOWNTO 0) <= "00000111"; 
           ELSE
             dataout_read(7 DOWNTO 0) <= "10111100";
           END IF;
       END IF;
         
     END IF; -- end of not reset
   END PROCESS;

   -- fifo select
   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1' OR writeclk_dly = '1') THEN
         fifo_select_out <= '1';    
      ELSE
         fifo_select_out <= '0';    
      END IF;
   END PROCESS;

   PROCESS (reset, readclk)
   BEGIN
      IF (reset = '1') THEN
         rd_enable_sync_1 <= '0';    
         rd_enable_sync_2 <= '0';    
         rd_enable_sync_out <= '0';    
      ELSIF (readclk'EVENT AND readclk = '1') THEN
         rd_enable_sync_1 <= wr_enable OR disablefifo;    
         rd_enable_sync_2 <= rd_enable_sync_1;    
         rd_enable_sync_out <= rd_enable_sync_2;    
      END IF;
   END PROCESS;

   PROCESS (reset, writeclk_dly)
   BEGIN
      IF (reset = '1') THEN
         wr_enable <= '0';    
      ELSIF (writeclk_dly'EVENT AND writeclk_dly = '1') THEN
         wr_enable <= '1';    
      END IF;
   END PROCESS;
   rdenasync_tmp <= rd_enable_sync_out WHEN (individual) = '1' ELSE rd_enable_sync_1 ;

END arch_stratixgx_tx_core;


-- 
-- 4 to 1 MULTIPLEXER
--

library IEEE, stratixgx_gxb,std;
use IEEE.std_logic_1164.all;
use stratixgx_gxb.hssi_pack.all;

ENTITY stratixgx_hssi_mux4 IS
   PORT (
      Y                       : OUT std_logic;   
      I0                      : IN std_logic;   
      I1                      : IN std_logic;   
      I2                      : IN std_logic;   
      I3                      : IN std_logic;   
      C0                      : IN std_logic;   
      C1                      : IN std_logic);
END stratixgx_hssi_mux4;

ARCHITECTURE stratixgx_hssi_mux4_arch OF stratixgx_hssi_mux4 IS
  SIGNAL Y_tmp                  :  std_logic;   
BEGIN
   Y <= Y_tmp;

   PROCESS (I0, I1, I2, I3, C0, C1)
      VARIABLE Y_tmp1  : std_logic;
      VARIABLE ctrl  : std_logic_vector(1 DOWNTO 0);
   BEGIN
      ctrl := C1 & C0;
      CASE ctrl IS
         WHEN "00" =>
                  Y_tmp1 := I0;    
         WHEN "01" =>
                  Y_tmp1 := I1;    
         WHEN "10" =>
                  Y_tmp1 := I2;    
         WHEN "11" =>
                  Y_tmp1 := I3;    
         WHEN OTHERS =>
                  NULL;
      END CASE;
      Y_tmp <= Y_tmp1;
   END PROCESS;

END stratixgx_hssi_mux4_arch;

--
-- DIVIDE BY TWO LOGIC
--

library IEEE, stratixgx_gxb,std;
use IEEE.std_logic_1164.all;
use stratixgx_gxb.hssi_pack.all;

ENTITY stratixgx_hssi_divide_by_two IS
   GENERIC (
      divide                  :  string := "true");
   PORT (
      reset                   : IN std_logic := '0';   
      clkin                   : IN std_logic;   
      clkout                  : OUT std_logic);   
END stratixgx_hssi_divide_by_two;

ARCHITECTURE stratixgx_hssi_divide_by_two_arch OF stratixgx_hssi_divide_by_two IS
  SIGNAL clktmp                   :  std_logic := '0';   
BEGIN
   PROCESS (clkin, reset)
   BEGIN
      IF (divide = "false") THEN
         clktmp <= clkin;    
      ELSIF (reset'event and (reset = '1')) THEN
         clktmp <= '0';
      ELSE
         IF (reset = '0' and clkin'event and (clkin = '1')) THEN
            clktmp <= NOT clktmp;    
         END IF;
      END IF;
   END PROCESS;
   clkout <= clktmp;
END stratixgx_hssi_divide_by_two_arch;

--
-- stratixgx_xgm_interface
--

library IEEE, stratixgx_gxb;
use IEEE.std_logic_1164.all;
use IEEE.VITAL_Timing.all;
use IEEE.VITAL_Primitives.all;
use stratixgx_gxb.hssi_pack.all;

ENTITY stratixgx_xgm_interface IS
  generic (
    use_continuous_calibration_mode : String := "false";
    mode_is_xaui : String := "false";
    rx_ppm_setting_0    : integer := 0;
    rx_ppm_setting_1    : integer := 0;
    digital_test_output_select          : integer := 0;
    analog_test_output_signal_select    : integer := 0;
    analog_test_output_channel_select   : integer := 0;
    use_rx_calibration_status           : String  := "false";
    use_global_serial_loopback          : String  := "false";
    rx_calibration_test_write_value     : integer := 0;
    enable_rx_calibration_test_write    : String  := "false";
    tx_calibration_test_write_value     : integer := 0;
    enable_tx_calibration_test_write    : String  := "false";
    TimingChecksOn      : Boolean := True;
    MsgOn               : Boolean := DefGlitchMsgOn;
    XOn                 : Boolean := DefGlitchXOn;
    MsgOnChecks		: Boolean := DefMsgOnChecks;
    XOnChecks		: Boolean := DefXOnChecks;
    InstancePath	: String  := "*";
    tipd_txdatain       : VitalDelayArrayType01(31 downto 0) := (OTHERS => DefPropDelay01);
    tipd_txctrl		: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
    tipd_rdenablesync	: VitalDelayType01 := DefpropDelay01;
    tipd_txclk		: VitalDelayType01 := DefpropDelay01;
    tipd_rxdatain       : VitalDelayArrayType01(31 downto 0) := (OTHERS => DefPropDelay01);
    tipd_rxctrl		: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
    tipd_rxclk		: VitalDelayType01 := DefpropDelay01;
    tipd_rxrunningdisp  : VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
    tipd_rxdatavalid	: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
    tipd_resetall	: VitalDelayType01 := DefpropDelay01;
    tipd_adet		: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
    tipd_syncstatus	: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
    tipd_rdalign	: VitalDelayArrayType01(3 downto 0) := (OTHERS => DefPropDelay01);
    tipd_recovclk	: VitalDelayType01 := DefpropDelay01
    );

   PORT (
      txdatain                : IN std_logic_vector(31 DOWNTO 0) := "00000000000000000000000000000000";
      txctrl                  : IN std_logic_vector(3 DOWNTO 0) := "0000";
      rdenablesync            : IN std_logic := '0';
      txclk                   : IN std_logic := '0';   
      rxdatain                : IN std_logic_vector(31 DOWNTO 0) := "00000000000000000000000000000000";
      rxctrl                  : IN std_logic_vector(3 DOWNTO 0) := "0000";   
      rxrunningdisp           : IN std_logic_vector(3 DOWNTO 0) := "0000";   
      rxdatavalid             : IN std_logic_vector(3 DOWNTO 0) := "0000";   
      rxclk                   : IN std_logic := '0';   
      resetall                : IN std_logic := '0';   
      adet                    : IN std_logic_vector(3 DOWNTO 0) := "0000";   
      syncstatus              : IN std_logic_vector(3 DOWNTO 0) := "0000";   
      rdalign                 : IN std_logic_vector(3 DOWNTO 0) := "0000";   
      recovclk                : IN std_logic := '0';   
      devpor                  : IN std_logic := '0';   
      devclrn                 : IN std_logic := '0';   
      txdataout               : OUT std_logic_vector(31 DOWNTO 0);   
      txctrlout               : OUT std_logic_vector(3 DOWNTO 0);   
      rxdataout               : OUT std_logic_vector(31 DOWNTO 0);   
      rxctrlout               : OUT std_logic_vector(3 DOWNTO 0);   
      resetout                : OUT std_logic;   
      alignstatus             : OUT std_logic;   
      enabledeskew            : OUT std_logic;   
      fiforesetrd             : OUT std_logic;
      -- NEW MDIO/PE ONLY PORTS
      mdioclk                 : IN std_logic := '0';
      mdiodisable             : IN std_logic := '0';
      mdioin                  : IN std_logic := '0';
      rxppmselect             : IN std_logic := '0';
      scanclk                 : IN std_logic := '0';
      scanin                  : IN std_logic := '0';
      scanmode                : IN std_logic := '0';
      scanshift               : IN std_logic := '0';
      -- NEW MDIO/PE ONLY PORTS
      calibrationstatus       : OUT std_logic_vector(4 DOWNTO 0);
      digitalsmtest           : OUT std_logic_vector(3 DOWNTO 0);
      mdiooe                  : OUT std_logic;
      mdioout                 : OUT std_logic;
      scanout                 : OUT std_logic;
      test                    : OUT std_logic;
      -- RESET PORTS
      txdigitalreset          : IN std_logic_vector(3 DOWNTO 0) := "0000";   
      rxdigitalreset          : IN std_logic_vector(3 DOWNTO 0) := "0000";   
      rxanalogreset           : IN std_logic_vector(3 DOWNTO 0) := "0000";   
      pllreset                : IN std_logic := '0';   
      pllenable               : IN std_logic := '1';   
      txdigitalresetout       : OUT std_logic_vector(3 DOWNTO 0);   
      rxdigitalresetout       : OUT std_logic_vector(3 DOWNTO 0);   
      txanalogresetout        : OUT std_logic_vector(3 DOWNTO 0);   
      rxanalogresetout        : OUT std_logic_vector(3 DOWNTO 0);   
      pllresetout             : OUT std_logic
    );   

END stratixgx_xgm_interface;

ARCHITECTURE vital_stratixgx_xgm_interface_atom OF stratixgx_xgm_interface IS

	-- input buffers
	signal txdatain_ipd : std_logic_vector(31 downto 0);
	signal txctrl_ipd : std_logic_vector(3 downto 0);
	signal rdenablesync_ipd : std_logic;
	signal txclk_ipd : std_logic;
	signal rxdatain_ipd : std_logic_vector(31 downto 0);
	signal rxctrl_ipd : std_logic_vector(3 downto 0);
	signal rxrunningdisp_ipd : std_logic_vector(3 downto 0);
	signal rxdatavalid_ipd : std_logic_vector(3 downto 0);
	signal rxclk_ipd : std_logic;
	signal resetall_ipd : std_logic;
	signal adet_ipd : std_logic_vector(3 downto 0);
	signal syncstatus_ipd : std_logic_vector(3 downto 0);
	signal rdalign_ipd : std_logic_vector(3 downto 0);
	signal recovclk_ipd : std_logic;

   -- internal input signals
   SIGNAL reset_int                :  std_logic;
   SIGNAL extended_pllreset        :  std_logic;
   SIGNAL rxdigitalresetout_tmp    :  std_logic_vector(3 downto 0) := "0000";
   SIGNAL txdigitalresetout_tmp    :  std_logic_vector(3 downto 0) := "0000";
   -- internal output signals
   SIGNAL resetout_tmp             :  std_logic;   
   SIGNAL txdataout_xtmp1          :  std_logic_vector(31 DOWNTO 0);   
   SIGNAL txctrlout_xtmp2          :  std_logic_vector(3 DOWNTO 0);   
   SIGNAL rxdataout_xtmp3          :  std_logic_vector(31 DOWNTO 0);   
   SIGNAL rxctrlout_xtmp4          :  std_logic_vector(3 DOWNTO 0);   
   SIGNAL resetout_xtmp5           :  std_logic;   
   SIGNAL alignstatus_xtmp6        :  std_logic;   
   SIGNAL enabledeskew_xtmp7       :  std_logic;   
   SIGNAL fiforesetrd_xtmp8        :  std_logic;   

component stratixgx_reset_block
   PORT (
      txdigitalreset          : IN std_logic_vector(3 DOWNTO 0);   
      rxdigitalreset          : IN std_logic_vector(3 DOWNTO 0);   
      rxanalogreset           : IN std_logic_vector(3 DOWNTO 0);   
      pllreset                : IN std_logic;   
      pllenable               : IN std_logic;   
      txdigitalresetout       : OUT std_logic_vector(3 DOWNTO 0);   
      rxdigitalresetout       : OUT std_logic_vector(3 DOWNTO 0);   
      txanalogresetout        : OUT std_logic_vector(3 DOWNTO 0);   
      rxanalogresetout        : OUT std_logic_vector(3 DOWNTO 0);   
      pllresetout             : OUT std_logic);   
END component;

component stratixgx_xgm_rx_sm 
   port (
     rxdatain			: IN std_logic_vector(31 DOWNTO 0) := "00000000000000000000000000000000";
     rxctrl         : IN std_logic_vector(3 DOWNTO 0) := "0000";
     rxrunningdisp  : IN std_logic_vector(3 DOWNTO 0) := "0000";   
     rxdatavalid    : IN std_logic_vector(3 DOWNTO 0) := "0000";   
     rxclk          : IN std_logic := '0';   
     resetall       : IN std_logic := '0';   
     rxdataout      : OUT std_logic_vector(31 DOWNTO 0);   
     rxctrlout      : OUT std_logic_vector(3 DOWNTO 0)
     );   
end component;

component stratixgx_xgm_tx_sm 
   port (
     txdatain			: IN std_logic_vector(31 DOWNTO 0) := "00000000000000000000000000000000";   
     txctrl         : IN std_logic_vector(3 DOWNTO 0) := "0000";   
     rdenablesync   : IN std_logic := '0';   
     txclk          : IN std_logic := '0';   
     resetall       : IN std_logic := '0';   
     txdataout      : OUT std_logic_vector(31 DOWNTO 0);   
     txctrlout      : OUT std_logic_vector(3 DOWNTO 0));   
end component;

component stratixgx_xgm_dskw_sm 
   port (
     resetall       : IN std_logic := '0';   
     adet           : IN std_logic_vector(3 DOWNTO 0) := "0000";   
     syncstatus     : IN std_logic_vector(3 DOWNTO 0) := "0000";   
     rdalign        : IN std_logic_vector(3 DOWNTO 0) := "0000";   
     recovclk       : IN std_logic := '0';   
     alignstatus    : OUT std_logic;   
     enabledeskew   : OUT std_logic;   
     fiforesetrd    : OUT std_logic);   
end component;

BEGIN
	----------------------
	--  INPUT PATH DELAYs
	----------------------
	WireDelay : block
	begin
		VitalWireDelay (txdatain_ipd(0), txdatain(0), tipd_txdatain(0));
		VitalWireDelay (txdatain_ipd(1), txdatain(1), tipd_txdatain(1));
		VitalWireDelay (txdatain_ipd(2), txdatain(2), tipd_txdatain(2));
		VitalWireDelay (txdatain_ipd(3), txdatain(3), tipd_txdatain(3));
		VitalWireDelay (txdatain_ipd(4), txdatain(4), tipd_txdatain(4));
		VitalWireDelay (txdatain_ipd(5), txdatain(5), tipd_txdatain(5));
		VitalWireDelay (txdatain_ipd(6), txdatain(6), tipd_txdatain(6));
		VitalWireDelay (txdatain_ipd(7), txdatain(7), tipd_txdatain(7));
		VitalWireDelay (txdatain_ipd(8), txdatain(8), tipd_txdatain(8));
		VitalWireDelay (txdatain_ipd(9), txdatain(9), tipd_txdatain(9));
		VitalWireDelay (txdatain_ipd(10), txdatain(10), tipd_txdatain(10));
		VitalWireDelay (txdatain_ipd(11), txdatain(11), tipd_txdatain(11));
		VitalWireDelay (txdatain_ipd(12), txdatain(12), tipd_txdatain(12));
		VitalWireDelay (txdatain_ipd(13), txdatain(13), tipd_txdatain(13));
		VitalWireDelay (txdatain_ipd(14), txdatain(14), tipd_txdatain(14));
		VitalWireDelay (txdatain_ipd(15), txdatain(15), tipd_txdatain(15));
		VitalWireDelay (txdatain_ipd(16), txdatain(16), tipd_txdatain(16));
		VitalWireDelay (txdatain_ipd(17), txdatain(17), tipd_txdatain(17));
		VitalWireDelay (txdatain_ipd(18), txdatain(18), tipd_txdatain(18));
		VitalWireDelay (txdatain_ipd(19), txdatain(19), tipd_txdatain(19));
		VitalWireDelay (txdatain_ipd(20), txdatain(20), tipd_txdatain(20));
		VitalWireDelay (txdatain_ipd(21), txdatain(21), tipd_txdatain(21));
		VitalWireDelay (txdatain_ipd(22), txdatain(22), tipd_txdatain(22));
		VitalWireDelay (txdatain_ipd(23), txdatain(23), tipd_txdatain(23));
		VitalWireDelay (txdatain_ipd(24), txdatain(24), tipd_txdatain(24));
		VitalWireDelay (txdatain_ipd(25), txdatain(25), tipd_txdatain(25));
		VitalWireDelay (txdatain_ipd(26), txdatain(26), tipd_txdatain(26));
		VitalWireDelay (txdatain_ipd(27), txdatain(27), tipd_txdatain(27));
		VitalWireDelay (txdatain_ipd(28), txdatain(28), tipd_txdatain(28));
		VitalWireDelay (txdatain_ipd(29), txdatain(29), tipd_txdatain(29));
		VitalWireDelay (txdatain_ipd(30), txdatain(30), tipd_txdatain(30));
		VitalWireDelay (txdatain_ipd(31), txdatain(31), tipd_txdatain(31));

		VitalWireDelay (rxdatain_ipd(0), rxdatain(0), tipd_rxdatain(0));
		VitalWireDelay (rxdatain_ipd(1), rxdatain(1), tipd_rxdatain(1));
		VitalWireDelay (rxdatain_ipd(2), rxdatain(2), tipd_rxdatain(2));
		VitalWireDelay (rxdatain_ipd(3), rxdatain(3), tipd_rxdatain(3));
		VitalWireDelay (rxdatain_ipd(4), rxdatain(4), tipd_rxdatain(4));
		VitalWireDelay (rxdatain_ipd(5), rxdatain(5), tipd_rxdatain(5));
		VitalWireDelay (rxdatain_ipd(6), rxdatain(6), tipd_rxdatain(6));
		VitalWireDelay (rxdatain_ipd(7), rxdatain(7), tipd_rxdatain(7));
		VitalWireDelay (rxdatain_ipd(8), rxdatain(8), tipd_rxdatain(8));
		VitalWireDelay (rxdatain_ipd(9), rxdatain(9), tipd_rxdatain(9));
		VitalWireDelay (rxdatain_ipd(10), rxdatain(10), tipd_rxdatain(10));
		VitalWireDelay (rxdatain_ipd(11), rxdatain(11), tipd_rxdatain(11));
		VitalWireDelay (rxdatain_ipd(12), rxdatain(12), tipd_rxdatain(12));
		VitalWireDelay (rxdatain_ipd(13), rxdatain(13), tipd_rxdatain(13));
		VitalWireDelay (rxdatain_ipd(14), rxdatain(14), tipd_rxdatain(14));
		VitalWireDelay (rxdatain_ipd(15), rxdatain(15), tipd_rxdatain(15));
		VitalWireDelay (rxdatain_ipd(16), rxdatain(16), tipd_rxdatain(16));
		VitalWireDelay (rxdatain_ipd(17), rxdatain(17), tipd_rxdatain(17));
		VitalWireDelay (rxdatain_ipd(18), rxdatain(18), tipd_rxdatain(18));
		VitalWireDelay (rxdatain_ipd(19), rxdatain(19), tipd_rxdatain(19));
		VitalWireDelay (rxdatain_ipd(20), rxdatain(20), tipd_rxdatain(20));
		VitalWireDelay (rxdatain_ipd(21), rxdatain(21), tipd_rxdatain(21));
		VitalWireDelay (rxdatain_ipd(22), rxdatain(22), tipd_rxdatain(22));
		VitalWireDelay (rxdatain_ipd(23), rxdatain(23), tipd_rxdatain(23));
		VitalWireDelay (rxdatain_ipd(24), rxdatain(24), tipd_rxdatain(24));
		VitalWireDelay (rxdatain_ipd(25), rxdatain(25), tipd_rxdatain(25));
		VitalWireDelay (rxdatain_ipd(26), rxdatain(26), tipd_rxdatain(26));
		VitalWireDelay (rxdatain_ipd(27), rxdatain(27), tipd_rxdatain(27));
		VitalWireDelay (rxdatain_ipd(28), rxdatain(28), tipd_rxdatain(28));
		VitalWireDelay (rxdatain_ipd(29), rxdatain(29), tipd_rxdatain(29));
		VitalWireDelay (rxdatain_ipd(30), rxdatain(30), tipd_rxdatain(30));
		VitalWireDelay (rxdatain_ipd(31), rxdatain(31), tipd_rxdatain(31));

		VitalWireDelay (txctrl_ipd(0), txctrl(0), tipd_txctrl(0));
		VitalWireDelay (txctrl_ipd(1), txctrl(1), tipd_txctrl(1));
		VitalWireDelay (txctrl_ipd(2), txctrl(2), tipd_txctrl(2));
		VitalWireDelay (txctrl_ipd(3), txctrl(3), tipd_txctrl(3));

		VitalWireDelay (rxctrl_ipd(0), rxctrl(0), tipd_rxctrl(0));
		VitalWireDelay (rxctrl_ipd(1), rxctrl(1), tipd_rxctrl(1));
		VitalWireDelay (rxctrl_ipd(2), rxctrl(2), tipd_rxctrl(2));
		VitalWireDelay (rxctrl_ipd(3), rxctrl(3), tipd_rxctrl(3));

		VitalWireDelay (rxrunningdisp_ipd(0), rxrunningdisp(0), tipd_rxrunningdisp(0));
		VitalWireDelay (rxrunningdisp_ipd(1), rxrunningdisp(1), tipd_rxrunningdisp(1));
		VitalWireDelay (rxrunningdisp_ipd(2), rxrunningdisp(2), tipd_rxrunningdisp(2));
		VitalWireDelay (rxrunningdisp_ipd(3), rxrunningdisp(3), tipd_rxrunningdisp(3));

		VitalWireDelay (rxdatavalid_ipd(0), rxdatavalid(0), tipd_rxdatavalid(0));
		VitalWireDelay (rxdatavalid_ipd(1), rxdatavalid(1), tipd_rxdatavalid(1));
		VitalWireDelay (rxdatavalid_ipd(2), rxdatavalid(2), tipd_rxdatavalid(2));
		VitalWireDelay (rxdatavalid_ipd(3), rxdatavalid(3), tipd_rxdatavalid(3));

		VitalWireDelay (rdenablesync_ipd, rdenablesync, tipd_rdenablesync);

		VitalWireDelay (txclk_ipd, txclk, tipd_txclk);
		VitalWireDelay (rxclk_ipd, rxclk, tipd_rxclk);
		VitalWireDelay (recovclk_ipd, recovclk, tipd_recovclk);

		VitalWireDelay (resetall_ipd, resetall, tipd_resetall);

		VitalWireDelay (adet_ipd(0), adet(0), tipd_adet(0));
		VitalWireDelay (adet_ipd(1), adet(1), tipd_adet(1));
		VitalWireDelay (adet_ipd(2), adet(2), tipd_adet(2));
		VitalWireDelay (adet_ipd(3), adet(3), tipd_adet(3));

		VitalWireDelay (syncstatus_ipd(0), syncstatus(0), tipd_syncstatus(0));
		VitalWireDelay (syncstatus_ipd(1), syncstatus(1), tipd_syncstatus(1));
		VitalWireDelay (syncstatus_ipd(2), syncstatus(2), tipd_syncstatus(2));
		VitalWireDelay (syncstatus_ipd(3), syncstatus(3), tipd_syncstatus(3));

		VitalWireDelay (rdalign_ipd(0), rdalign(0), tipd_rdalign(0));
		VitalWireDelay (rdalign_ipd(1), rdalign(1), tipd_rdalign(1));
		VitalWireDelay (rdalign_ipd(2), rdalign(2), tipd_rdalign(2));
		VitalWireDelay (rdalign_ipd(3), rdalign(3), tipd_rdalign(3));
	end block;

	------------------------
	--  Timing Check Section
	------------------------

   txdataout <= txdataout_xtmp1;
   txctrlout <= txctrlout_xtmp2;
   rxdataout <= rxdataout_xtmp3;
   rxctrlout <= rxctrlout_xtmp4;
   resetout <= resetout_xtmp5;
   alignstatus <= alignstatus_xtmp6;
   enabledeskew <= enabledeskew_xtmp7;
   fiforesetrd <= fiforesetrd_xtmp8;
   reset_int <= resetall_ipd ;
   rxdigitalresetout <= rxdigitalresetout_tmp;
   txdigitalresetout <= txdigitalresetout_tmp;
   resetout_tmp <= resetall_ipd ;
   extended_pllreset <= pllreset OR (NOT devpor) OR (NOT devclrn);
        
   stratixgx_reset : stratixgx_reset_block
     port map (
       txdigitalreset => txdigitalreset,
       rxdigitalreset => rxdigitalreset,
       rxanalogreset  => rxanalogreset,
       pllreset       => extended_pllreset,
       pllenable      => pllenable,
       txdigitalresetout => txdigitalresetout_tmp,
       rxdigitalresetout => rxdigitalresetout_tmp,
       txanalogresetout  => txanalogresetout,
       rxanalogresetout  => rxanalogresetout,
       pllresetout       => pllresetout);
        
   s_xgm_rx_sm : stratixgx_xgm_rx_sm 
      PORT MAP (
         rxdatain => rxdatain_ipd,
         rxctrl => rxctrl_ipd,
         rxrunningdisp => rxrunningdisp_ipd,
         rxdatavalid => rxdatavalid_ipd,
         rxclk => rxclk_ipd,
         resetall => rxdigitalresetout_tmp(0),
         rxdataout => rxdataout_xtmp3,
         rxctrlout => rxctrlout_xtmp4);   
   
   s_xgm_tx_sm : stratixgx_xgm_tx_sm 
      PORT MAP (
         txdatain => txdatain_ipd,
         txctrl => txctrl_ipd,
         rdenablesync => rdenablesync_ipd,
         txclk => txclk_ipd,
         resetall => txdigitalresetout_tmp(0),
         txdataout => txdataout_xtmp1,
         txctrlout => txctrlout_xtmp2);   
   
   s_xgm_dskw_sm : stratixgx_xgm_dskw_sm 
      PORT MAP (
         resetall => rxdigitalresetout_tmp(0),
         adet => adet_ipd,
         syncstatus => syncstatus_ipd,
         rdalign => rdalign_ipd,
         recovclk => recovclk_ipd,
         alignstatus => alignstatus_xtmp6,
         enabledeskew => enabledeskew_xtmp7,
         fiforesetrd => fiforesetrd_xtmp8);   
   
   resetout_xtmp5 <= resetout_tmp AND '1';   

	----------------------
	--  Path Delay Section
	----------------------

END vital_stratixgx_xgm_interface_atom;

--
-- STRATIXGX_HSSI_RECEIVER
--

library IEEE, stratixgx_gxb,std;
use IEEE.std_logic_1164.all;
use IEEE.VITAL_Timing.all;
use IEEE.VITAL_Primitives.all;
use stratixgx_gxb.hssi_pack.all;
use std.textio.all;

entity stratixgx_hssi_receiver is
  generic (
    channel_num                 : integer := 1;
    channel_width		: integer := 20;
    deserialization_factor	: integer := 10;
    run_length			: integer := 4;
    run_length_enable		: String  := "false";
    use_8b_10b_mode		: String  := "false";
    use_double_data_mode	: String  := "false";
    use_rate_match_fifo		: String  := "false";
    rate_matching_fifo_mode	: String  := "none";
    use_channel_align		: String  := "false";
    use_symbol_align		: String  := "true";
    use_auto_bit_slip		: String  := "false";
    use_parallel_feedback       : String  := "false";
    use_post8b10b_feedback      : String  := "false";
    send_reverse_parallel_feedback : String := "false";
    synchronization_mode	: String  := "none";
    align_pattern		: String  := "0000000000000000";
    align_pattern_length	: integer  := 7;
    infiniband_invalid_code	: integer  := 0;
    disparity_mode		: String  := "false";
    clk_out_mode_reference	: String  := "true";
    cruclk_period		: integer := 5000;
    cruclk_multiplier 		: integer := 4;
    use_cruclk_divider		: String  := "false";
    use_self_test_mode          : String  := "false";
    self_test_mode          : integer  := 0;
    use_equalizer_ctrl_signal   : String  := "false";
    enable_dc_coupling          : String  := "false";
    equalizer_ctrl_setting      : integer := 20;
    signal_threshold_select     : integer := 2;
    vco_bypass                  : String  := "false";
    force_signal_detect         : String  := "false";
    bandwidth_type          : String  := "low";
    for_engineering_sample_device    : String := "true"; -- new in 3.0 SP2 
    TimingChecksOn		: Boolean := True;
    MsgOn			: Boolean := DefGlitchMsgOn;
    XOn				: Boolean := DefGlitchXOn;
    MsgOnChecks			: Boolean := DefMsgOnChecks;
    XOnChecks			: Boolean := DefXOnChecks;
    InstancePath		: String  := "*";
    tipd_datain			: VitalDelayType01 := DefpropDelay01;
    tipd_cruclk			: VitalDelayType01 := DefpropDelay01;
    tipd_pllclk			: VitalDelayType01 := DefpropDelay01;
    tipd_masterclk		: VitalDelayType01 := DefpropDelay01;
    tipd_coreclk		: VitalDelayType01 := DefpropDelay01;
    tipd_softreset		: VitalDelayType01 := DefpropDelay01;
    tipd_serialfdbk		: VitalDelayType01 := DefpropDelay01;
    tipd_analogreset		: VitalDelayType01 := DefpropDelay01;
    tipd_locktorefclk		: VitalDelayType01 := DefpropDelay01;
    tipd_locktodata		: VitalDelayType01 := DefpropDelay01;
    tipd_equalizerctrl          : VitalDelayArrayType01(2 downto 0) := (OTHERS => DefPropDelay01);
    tipd_parallelfdbk           : VitalDelayArrayType01(9 downto 0) := (OTHERS => DefPropDelay01);
    tipd_post8b10b              : VitalDelayArrayType01(9 downto 0) := (OTHERS => DefPropDelay01);
    tipd_slpbk                  : VitalDelayType01 := DefpropDelay01;
    tipd_bitslip		: VitalDelayType01 := DefpropDelay01;
    tipd_a1a2size		: VitalDelayType01 := DefpropDelay01;
    tipd_enacdet		: VitalDelayType01 := DefpropDelay01;
    tipd_we			: VitalDelayType01 := DefpropDelay01;
    tipd_re			: VitalDelayType01 := DefpropDelay01;
    tipd_alignstatus		: VitalDelayType01 := DefpropDelay01;
    tipd_disablefifordin	: VitalDelayType01 := DefpropDelay01;
    tipd_disablefifowrin	: VitalDelayType01 := DefpropDelay01;
    tipd_fifordin		: VitalDelayType01 := DefpropDelay01;
    tipd_enabledeskew		: VitalDelayType01 := DefpropDelay01;
    tipd_fiforesetrd		: VitalDelayType01 := DefpropDelay01;
    tipd_xgmdatain              : VitalDelayArrayType01(7 downto 0) := (OTHERS => DefPropDelay01);
    tipd_xgmctrlin		: VitalDelayType01 := DefpropDelay01;
    tsetup_re_coreclk_noedge_posedge    : VitalDelayType := DefSetupHoldCnst;
    thold_re_coreclk_noedge_posedge     : VitalDelayType := DefSetupHoldCnst;
    tpd_coreclk_dataout_posedge : VitalDelayArrayType01(19 downto 0) := (OTHERS => DefPropDelay01);
    tpd_coreclk_syncstatus_posedge      : VitalDelayArrayType01(1 downto 0) := (OTHERS => DefPropDelay01);
    tpd_coreclk_patterndetect_posedge   : VitalDelayArrayType01(1 downto 0) := (OTHERS => DefPropDelay01);
    tpd_coreclk_ctrldetect_posedge      : VitalDelayArrayType01(1 downto 0) := (OTHERS => DefPropDelay01);
    tpd_coreclk_errdetect_posedge       : VitalDelayArrayType01(1 downto 0) := (OTHERS => DefPropDelay01);
    tpd_coreclk_disperr_posedge         : VitalDelayArrayType01(1 downto 0) := (OTHERS => DefPropDelay01);
    tpd_coreclk_a1a2sizeout_posedge     : VitalDelayArrayType01(1 downto 0) := (OTHERS => DefPropDelay01);
    tpd_coreclk_fifofull_posedge        : VitalDelayType01 := DefPropDelay01;
    tpd_coreclk_fifoempty_posedge       : VitalDelayType01 := DefPropDelay01;
    tpd_coreclk_fifoalmostfull_posedge  : VitalDelayType01 := DefPropDelay01;
    tpd_coreclk_fifoalmostempty_posedge : VitalDelayType01 := DefPropDelay01
    );

  port (
    datain		: in std_logic := '0';
    cruclk		: in std_logic := '0';
    pllclk		: in std_logic := '0';
    masterclk		: in std_logic := '0';
    coreclk		: in std_logic := '0';
    softreset		: in std_logic := '0';
    serialfdbk		: in std_logic := '0';
    parallelfdbk	: in std_logic_vector(9 downto 0) := "0000000000";
    post8b10b		: in std_logic_vector(9 downto 0) := "0000000000";
    slpbk		: in std_logic := '0';
    bitslip		: in std_logic := '0';
    enacdet		: in std_logic := '0';
    we			: in std_logic := '0';
    re			: in std_logic := '0';
    alignstatus		: in std_logic := '0';
    disablefifordin	: in std_logic := '0';
    disablefifowrin	: in std_logic := '0';
    fifordin		: in std_logic := '0';
    enabledeskew	: in std_logic := '0';
    fiforesetrd		: in std_logic := '0';
    xgmdatain		: in std_logic_vector(7 downto 0) := "00000000";
    xgmctrlin		: in std_logic := '0';
    devclrn		: in std_logic := '1';
    devpor		: in std_logic := '1';
    analogreset		: in std_logic := '0';
    a1a2size		: in std_logic := '0';
    locktorefclk	: in std_logic := '0';
    locktodata		: in std_logic := '0';
    equalizerctrl	: in std_logic_vector(2 downto 0) := "000";
    syncstatus		: out std_logic_vector(1 downto 0);
    patterndetect	: out std_logic_vector(1 downto 0);
    ctrldetect		: out std_logic_vector(1 downto 0);
    errdetect		: out std_logic_vector(1 downto 0);
    disperr		: out std_logic_vector(1 downto 0);
    syncstatusdeskew	: out std_logic;
    adetectdeskew	: out std_logic;
    rdalign		: out std_logic;
    dataout		: out std_logic_vector(19 downto 0);
    xgmdataout		: out std_logic_vector(7 downto 0);
    xgmctrldet		: out std_logic;
    xgmrunningdisp	: out std_logic;
    xgmdatavalid	: out std_logic;
    fifofull		: out std_logic;
    fifoalmostfull	: out std_logic;
    fifoempty		: out std_logic;
    fifoalmostempty	: out std_logic;
    disablefifordout	: out std_logic;
    disablefifowrout	: out std_logic;
    fifordout		: out std_logic;
    signaldetect	: out std_logic;
    lock		: out std_logic;
    freqlock		: out std_logic;
    rlv			: out std_logic;
    clkout		: out std_logic;
    recovclkout		: out std_logic;
    bisterr             : out std_logic := '0';
    bistdone            : out std_logic := '1';
    a1a2sizeout         : out std_logic_vector(1 downto 0) 
    );
end stratixgx_hssi_receiver;

architecture vital_receiver_atom of stratixgx_hssi_receiver is
  signal datain_ipd : std_logic;
  signal cruclk_ipd  : std_logic;
  signal pllclk_ipd  : std_logic;
  signal masterclk_ipd  : std_logic;
  signal coreclk_ipd  : std_logic;
  signal softreset_ipd	: std_logic := '0';
  signal serialfdbk_ipd : std_logic := '0';
  signal analogreset_ipd : std_logic := '0';
  signal locktorefclk_ipd : std_logic := '0';
  signal locktodata_ipd : std_logic := '0';
  signal equalizerctrl_ipd : std_logic_vector(2 downto 0);
  signal parallelfdbk_ipd  : std_logic_vector(9 downto 0);
  signal post8b10b_ipd	: std_logic_vector(9 downto 0);
  signal slpbk_ipd : std_logic := '0';
  signal bitslip_ipd : std_logic := '0';
  signal a1a2size_ipd : std_logic := '0';
  signal enacdet_ipd : std_logic := '0';
  signal we_ipd: std_logic := '0';
  signal re_ipd : std_logic := '0';
  signal alignstatus_ipd : std_logic := '0';
  signal disablefifordin_ipd : std_logic := '0';
  signal disablefifowrin_ipd : std_logic := '0';
  signal fifordin_ipd : std_logic := '0';
  signal enabledeskew_ipd : std_logic := '0';
  signal fiforesetrd_ipd : std_logic := '0';
  signal xgmdatain_ipd : std_logic_vector(7 downto 0);
  signal xgmctrlin_ipd : std_logic := '0';
  
  signal clkout_tmp : std_logic;
  signal dataout_tmp : std_logic_vector(19 downto 0);
  
  --constant signals
  signal vcc : std_logic := '1';
  signal gnd : std_logic := '0';
  signal idle_bus : std_logic_vector(9 downto 0) := "0000000000";

  --lower lever softreset 
  signal reset_int : std_logic;
  
  -- serdes output signals
  signal serdes_clkout : std_logic; --receovered clock
  signal serdes_rlv : std_logic;
  signal serdes_signaldetect : std_logic;
  signal serdes_lock : std_logic;
  signal serdes_freqlock : std_logic;
  signal serdes_dataout : std_logic_vector(9 downto 0);

  -- word aligner input/output signals
  signal wa_datain : std_logic_vector(9 downto 0);
  signal wa_clk : std_logic;
  signal wa_enacdet : std_logic;
  signal wa_bitslip : std_logic;
  signal wa_a1a2size : std_logic;
  
  signal wa_aligneddata : std_logic_vector(9 downto 0);
  signal wa_aligneddatapre : std_logic_vector(9 downto 0);
  signal wa_invalidcode : std_logic;
  signal wa_invalidcodepre : std_logic;
  signal wa_disperr : std_logic;
  signal wa_disperrpre : std_logic;
  signal wa_patterndetect : std_logic;
  signal wa_patterndetectpre : std_logic;
  signal wa_syncstatus : std_logic;
  signal wa_syncstatusdeskew : std_logic;

  -- deskew FIFO input/output signals
  signal dsfifo_datain : std_logic_vector(9 downto 0);     
  signal dsfifo_errdetectin : std_logic;
  signal dsfifo_syncstatusin : std_logic;
  signal dsfifo_disperrin : std_logic; 
  signal dsfifo_patterndetectin : std_logic; 
  signal dsfifo_writeclock : std_logic;
  signal dsfifo_readclock : std_logic; 
  signal dsfifo_fiforesetrd : std_logic; 
  signal dsfifo_enabledeskew : std_logic;
  
  signal dsfifo_dataout : std_logic_vector(9 downto 0); 
  signal dsfifo_dataoutpre : std_logic_vector(9 downto 0); 
  signal dsfifo_errdetect : std_logic;   
  signal dsfifo_syncstatus : std_logic; 
  signal dsfifo_disperr : std_logic;    
  signal dsfifo_patterndetect : std_logic; 
  signal dsfifo_errdetectpre : std_logic;   
  signal dsfifo_syncstatuspre : std_logic; 
  signal dsfifo_disperrpre : std_logic;    
  signal dsfifo_patterndetectpre : std_logic; 
  signal dsfifo_adetectdeskew : std_logic;
  signal dsfifo_rdalign : std_logic;     
   
  -- comp FIFO input/output signals
  signal cmfifo_datain : std_logic_vector(9 downto 0);
  signal cmfifo_datainpre : std_logic_vector(9 downto 0);
  signal cmfifo_invalidcodein : std_logic; 
  signal cmfifo_invalidcodeinpre : std_logic; 
  signal cmfifo_disperrin : std_logic;  
  signal cmfifo_disperrinpre : std_logic;  
  signal cmfifo_patterndetectin : std_logic;
  signal cmfifo_patterndetectinpre : std_logic;
  signal cmfifo_syncstatusin : std_logic;
  signal cmfifo_syncstatusinpre : std_logic;
  signal cmfifo_writeclk : std_logic;      
  signal cmfifo_readclk : std_logic;      
  signal cmfifo_alignstatus : std_logic;
  signal cmfifo_re : std_logic;
  signal cmfifo_we : std_logic;
  signal cmfifo_fifordin : std_logic;
  signal cmfifo_disablefifordin : std_logic; 
  signal cmfifo_disablefifowrin : std_logic;
  
  signal cmfifo_dataout : std_logic_vector(9 downto 0); 
  signal cmfifo_invalidcode : std_logic;
  signal cmfifo_syncstatus : std_logic;
  signal cmfifo_disperr : std_logic;
  signal cmfifo_patterndetect : std_logic;
  signal cmfifo_datavalid : std_logic;
  signal cmfifo_fifofull : std_logic;
  signal cmfifo_fifoalmostfull : std_logic;
  signal cmfifo_fifoempty : std_logic;
  signal cmfifo_fifoalmostempty : std_logic;
  signal cmfifo_disablefifordout : std_logic;
  signal cmfifo_disablefifowrout : std_logic;
  signal cmfifo_fifordout : std_logic;

  -- 8B10B decode input/output signals
  signal decoder_clk : std_logic; 
  signal decoder_datain : std_logic_vector(9 downto 0);   
  signal decoder_errdetectin : std_logic;         
  signal decoder_syncstatusin : std_logic;         
  signal decoder_disperrin : std_logic;         
  signal decoder_patterndetectin : std_logic;         
  signal decoder_indatavalid : std_logic;         
   
  signal decoder_dataout : std_logic_vector(7 downto 0); 
  signal decoder_tenBdata : std_logic_vector(9 downto 0); 
  signal decoder_valid : std_logic;         
  signal decoder_errdetect : std_logic;         
  signal decoder_syncstatus : std_logic;         
  signal decoder_disperr : std_logic;         
  signal decoder_patterndetect : std_logic;         
  signal decoder_rderr : std_logic;         
  signal decoder_decdatavalid : std_logic;    
  signal decoder_ctrldetect : std_logic;   
  signal decoder_xgmdatavalid : std_logic;   
  signal decoder_xgmrunningdisp : std_logic;   
  signal decoder_xgmctrldet : std_logic;   
  signal decoder_xgmdataout : std_logic_vector(7 downto 0); 

  -- rx_core input/output signals
  signal core_datain : std_logic_vector(9 downto 0);
  signal core_writeclk : std_logic;   
  signal core_readclk : std_logic;   
  signal core_decdatavalid : std_logic;   
  signal core_xgmdatain : std_logic_vector(7 downto 0);
  signal core_xgmctrlin : std_logic;   
  signal core_post8b10b : std_logic_vector(9 downto 0);   
  signal core_syncstatusin : std_logic;   
  signal core_errdetectin: std_logic;   
  signal core_ctrldetectin: std_logic;   
  signal core_disparityerrin: std_logic;   
  signal core_patterndetectin: std_logic;   

  signal core_dataout : std_logic_vector(19 downto 0);
  signal core_clkout : std_logic;   
  signal core_syncstatus : std_logic_vector(1 downto 0);   
  signal core_errdetect : std_logic_vector(1 downto 0);   
  signal core_ctrldetect : std_logic_vector(1 downto 0);   
  signal core_disparityerr : std_logic_vector(1 downto 0);   
  signal core_patterndetect : std_logic_vector(1 downto 0);   
  signal core_a1a2sizeout : std_logic_vector(1 downto 0);   

  -- clkout mux output
  -- added gfifo
  signal clkoutmux_clkout     : std_logic;
  signal clkoutmux_clkout_pre : std_logic;

  -- MAIN CLOCKS
  SIGNAL rxrdclk_mux1             :  std_logic;   
  SIGNAL rxrdclk_mux1_by2         :  std_logic;   
  SIGNAL rxrdclkmux1_c0           :  std_logic;   
  SIGNAL rxrdclkmux1_c1           :  std_logic;   
  SIGNAL rxrdclkmux2_c0           :  std_logic;   
  SIGNAL rxrdclkmux2_c1           :  std_logic;  
  
  SIGNAL clk2_mux1                :  std_logic;   
  SIGNAL clk2mux1_c0              :  std_logic;   
  SIGNAL clk2mux1_c1              :  std_logic;   
  
  SIGNAL rcvd_clk                 :  std_logic;   
  SIGNAL clk_1                    :  std_logic;   
  SIGNAL clk_2                    :  std_logic;   
  SIGNAL rx_rd_clk                :  std_logic;   
  SIGNAL rx_rd_clk_mux            :  std_logic;  

-- sub module componet declaration
component stratixgx_hssi_rx_serdes 
  generic (
    channel_width	: integer := 10;
    rlv_length		: integer := 1;
    run_length_enable	: String := "false";
    cruclk_period	: integer :=5000; 
    cruclk_multiplier	: integer :=4; 
    use_cruclk_divider	: String := "false";
    use_double_data_mode :  string  := "false"    
    );
  
  port (
    datain		: in std_logic := '0';
    cruclk		: in std_logic := '0';
    areset		: in std_logic := '0';
    feedback		: in std_logic := '0';
    fbkcntl		: in std_logic := '0';
    ltr		    : in std_logic := '0';
    ltd		    : in std_logic := '0';
    dataout		: out std_logic_vector(9 downto 0);
    clkout		: out std_logic;
    rlv			: out std_logic;
    lock		: out std_logic;
    freqlock		: out std_logic;
    signaldetect        : out std_logic
    );

end component;

component stratixgx_hssi_word_aligner 
  generic	(
    channel_width       : integer := 10;
    align_pattern_length: integer := 10;
    infiniband_invalid_code : integer := 0;
    align_pattern 	: string := "0000000101111100";
    synchronization_mode: string := "XAUI";
    use_8b_10b_mode	: string := "true";
    use_auto_bit_slip   : string := "true"
    );
  port	(
    datain		: in std_logic_vector(9 downto 0) := "0000000000"; 
    clk			: in std_logic := '0'; 
    softreset		: in std_logic := '0'; 
    enacdet		: in std_logic := '0'; 
    bitslip		: in std_logic := '0'; 
    a1a2size		: in std_logic := '0'; 
    aligneddata		: out std_logic_vector(9 downto 0); 
    aligneddatapre	: out std_logic_vector(9 downto 0); 
    invalidcode		: out std_logic;
    invalidcodepre	: out std_logic;
    syncstatus		: out std_logic;
    syncstatusdeskew	: out std_logic;
    disperr		: out std_logic;
    disperrpre		: out std_logic;
    patterndetect	: out std_logic;
    patterndetectpre	: out std_logic
    );

end component;

component stratixgx_deskew_fifo
  port 
	(
    datain        : IN std_logic_vector(9 DOWNTO 0) := "0000000000";   
    errdetectin   : IN std_logic := '0';   
    syncstatusin  : IN std_logic := '0';   
    disperrin     : IN std_logic := '0';   
    patterndetectin : IN std_logic := '0';   
    writeclock	  : IN std_logic := '0';   
    readclock	  : IN std_logic := '0';   
    adetectdeskew : OUT std_logic := '0';  
    fiforesetrd   : IN std_logic := '0';   
    enabledeskew  : IN std_logic := '0';   
    reset         : IN std_logic := '0';   
    dataout       : OUT std_logic_vector(9 DOWNTO 0) := "0000000000";   
    dataoutpre    : OUT std_logic_vector(9 DOWNTO 0) := "0000000000";   
    errdetect     : OUT std_logic := '0';   
    syncstatus    : OUT std_logic := '0';   
    disperr       : OUT std_logic := '0';   
    patterndetect : OUT std_logic := '0';   
    errdetectpre  : OUT std_logic := '0';   
    syncstatuspre : OUT std_logic := '0';   
    disperrpre    : OUT std_logic := '0';   
    patterndetectpre : OUT std_logic := '0';   
    rdalign       : OUT std_logic := '0'
    );  

end component;

component stratixgx_comp_fifo
  GENERIC (
    use_rate_match_fifo     : string  := "true";
    rate_matching_fifo_mode : string  := "xaui";
    use_channel_align       : string  := "true";
    for_engineering_sample_device    : String := "true"; -- new in 3.0 SP2 
    channel_num             : integer := 0
    );
   port (
     datain                  : IN std_logic_vector(9 DOWNTO 0);   
     datainpre               : IN std_logic_vector(9 DOWNTO 0);   
     reset                   : IN std_logic;   
     errdetectin             : IN std_logic;   
     syncstatusin            : IN std_logic;   
     disperrin               : IN std_logic;   
     patterndetectin         : IN std_logic;   
     errdetectinpre          : IN std_logic;   
     syncstatusinpre         : IN std_logic;   
     disperrinpre            : IN std_logic;   
     patterndetectinpre      : IN std_logic;   
     writeclk                : IN std_logic;   
     readclk                 : IN std_logic;   
     re                      : IN std_logic;   
     we                      : IN std_logic;   
     fifordin                : IN std_logic;   
     disablefifordin         : IN std_logic;   
     disablefifowrin         : IN std_logic;   
     alignstatus             : IN std_logic;   
     dataout                 : OUT std_logic_vector(9 DOWNTO 0);   
     errdetectout            : OUT std_logic;   
     syncstatus              : OUT std_logic;   
     disperr                 : OUT std_logic;   
     patterndetect	      : OUT std_logic;   
     codevalid               : OUT std_logic;   
     fifofull                : OUT std_logic;   
     fifoalmostful           : OUT std_logic;   
     fifoempty               : OUT std_logic;   
     fifoalmostempty         : OUT std_logic;   
     disablefifordout        : OUT std_logic;   
     disablefifowrout        : OUT std_logic;   
     fifordout               : OUT std_logic
     );   

end component;

component stratixgx_8b10b_decoder 
  port (
    clk         : in std_logic := '0'; 
    reset       : in std_logic := '0'; -- reset the decoder
    errdetectin : in std_logic := '0';
    syncstatusin: in std_logic := '0';
    disperrin   : in std_logic := '0';
    patterndetectin : in std_logic := '0';
    datainvalid : in std_logic := '0';
    datain      : in std_logic_vector(9 downto 0) := "0000000000"; 
    valid       : out std_logic := '1'; -- valid decode
    dataout     : out std_logic_vector(7 downto 0) := "00000000";  
    tenBdata    : OUT std_logic_vector(9 DOWNTO 0) := "0000000000";   
    errdetect   : out std_logic := '0';
    syncstatus  : out std_logic := '0';
    disperr     : out std_logic := '0';
    patterndetect : out std_logic := '0';
    kout        : out std_logic := '0'; -- high if decode of control word 
    rderr       : out std_logic := '0'; -- running disparity error
    decdatavalid: out std_logic := '0';
    xgmdatavalid: out std_logic := '0';
    xgmrunningdisp : out std_logic := '0';
    xgmctrldet  : out std_logic := '0';
    xgmdataout  : out std_logic_vector(7 downto 0) := "00000000"
    );
end component;

component stratixgx_rx_core
   GENERIC (
      channel_width                  :  integer := 10;    
      use_double_data_mode           :  string  := "false";    
      use_channel_align              :  string  := "false";    
      use_8b_10b_mode                :  string  := "true";    
      align_pattern						 :  string  := "0000000000000000";
      synchronization_mode           :  string  := "none");
   PORT (
      reset                   : IN std_logic;   
      writeclk                : IN std_logic;   
      readclk                 : IN std_logic;   
      errdetectin             : IN std_logic;   
      patterndetectin         : IN std_logic;   
      decdatavalid            : IN std_logic;   
      xgmdatain               : IN std_logic_vector(7 DOWNTO 0);   
      post8b10b               : IN std_logic_vector(9 DOWNTO 0);   
      datain                  : IN std_logic_vector(9 DOWNTO 0);   
      xgmctrlin               : IN std_logic;   
      ctrldetectin            : IN std_logic;   
      syncstatusin            : IN std_logic;   
      disparityerrin          : IN std_logic;   
      syncstatus              : OUT std_logic_vector(1 DOWNTO 0);   
      errdetect               : OUT std_logic_vector(1 DOWNTO 0);   
      ctrldetect              : OUT std_logic_vector(1 DOWNTO 0);   
      disparityerr            : OUT std_logic_vector(1 DOWNTO 0);   
      patterndetect           : OUT std_logic_vector(1 DOWNTO 0);   
      dataout                 : OUT std_logic_vector(19 DOWNTO 0);   
      a1a2sizeout             : OUT std_logic_vector(1 DOWNTO 0);   
      clkout                  : OUT std_logic);   
end component;

component stratixgx_hssi_mux4 
   PORT (
      Y                       : OUT std_logic;   
      I0                      : IN std_logic;   
      I1                      : IN std_logic;   
      I2                      : IN std_logic;   
      I3                      : IN std_logic;   
      C0                      : IN std_logic;   
      C1                      : IN std_logic);   
END component;

component stratixgx_hssi_divide_by_two 
  GENERIC (
    divide                  :  string := "true");
  PORT (
    reset                   : IN std_logic := '0';   
    clkin                   : IN std_logic;   
    clkout                  : OUT std_logic);   
END component;

-- end of sub module componet declaration

begin
	----------------------
	--  INPUT PATH DELAYs
	----------------------
	WireDelay : block
	begin
		VitalWireDelay (datain_ipd, datain, tipd_datain);
		VitalWireDelay (cruclk_ipd, cruclk, tipd_cruclk);
		VitalWireDelay (pllclk_ipd, pllclk, tipd_pllclk);
		VitalWireDelay (masterclk_ipd, masterclk, tipd_masterclk);
		VitalWireDelay (coreclk_ipd, coreclk, tipd_coreclk);
		VitalWireDelay (softreset_ipd, softreset, tipd_softreset);
		VitalWireDelay (serialfdbk_ipd, serialfdbk, tipd_serialfdbk);
		VitalWireDelay (analogreset_ipd, analogreset, tipd_analogreset);
		VitalWireDelay (locktorefclk_ipd, locktorefclk, tipd_locktorefclk);
		VitalWireDelay (locktodata_ipd, locktodata, tipd_locktodata);

		VitalWireDelay (equalizerctrl_ipd(0), equalizerctrl(0), tipd_equalizerctrl(0));
		VitalWireDelay (equalizerctrl_ipd(1), equalizerctrl(1), tipd_equalizerctrl(1));
		VitalWireDelay (equalizerctrl_ipd(2), equalizerctrl(2), tipd_equalizerctrl(2));

		VitalWireDelay (parallelfdbk_ipd(0), parallelfdbk(0), tipd_parallelfdbk(0));
		VitalWireDelay (parallelfdbk_ipd(1), parallelfdbk(1), tipd_parallelfdbk(1));
		VitalWireDelay (parallelfdbk_ipd(2), parallelfdbk(2), tipd_parallelfdbk(2));
		VitalWireDelay (parallelfdbk_ipd(3), parallelfdbk(3), tipd_parallelfdbk(3));
		VitalWireDelay (parallelfdbk_ipd(4), parallelfdbk(4), tipd_parallelfdbk(4));
		VitalWireDelay (parallelfdbk_ipd(5), parallelfdbk(5), tipd_parallelfdbk(5));
		VitalWireDelay (parallelfdbk_ipd(6), parallelfdbk(6), tipd_parallelfdbk(6));
		VitalWireDelay (parallelfdbk_ipd(7), parallelfdbk(7), tipd_parallelfdbk(7));
		VitalWireDelay (parallelfdbk_ipd(8), parallelfdbk(8), tipd_parallelfdbk(8));
		VitalWireDelay (parallelfdbk_ipd(9), parallelfdbk(9), tipd_parallelfdbk(9));

		VitalWireDelay (post8b10b_ipd(0), post8b10b(0), tipd_post8b10b(0));
		VitalWireDelay (post8b10b_ipd(1), post8b10b(1), tipd_post8b10b(1));
		VitalWireDelay (post8b10b_ipd(2), post8b10b(2), tipd_post8b10b(2));
		VitalWireDelay (post8b10b_ipd(3), post8b10b(3), tipd_post8b10b(3));
		VitalWireDelay (post8b10b_ipd(4), post8b10b(4), tipd_post8b10b(4));
		VitalWireDelay (post8b10b_ipd(5), post8b10b(5), tipd_post8b10b(5));
		VitalWireDelay (post8b10b_ipd(6), post8b10b(6), tipd_post8b10b(6));
		VitalWireDelay (post8b10b_ipd(7), post8b10b(7), tipd_post8b10b(7));
                VitalWireDelay (post8b10b_ipd(8), post8b10b(8), tipd_post8b10b(8));
                VitalWireDelay (post8b10b_ipd(9), post8b10b(9), tipd_post8b10b(9));

		VitalWireDelay (slpbk_ipd, slpbk, tipd_slpbk);
		VitalWireDelay (bitslip_ipd, bitslip, tipd_bitslip);
		VitalWireDelay (a1a2size_ipd, a1a2size, tipd_a1a2size);
		VitalWireDelay (enacdet_ipd, enacdet, tipd_enacdet);
		VitalWireDelay (we_ipd, we, tipd_we);
		VitalWireDelay (re_ipd, re, tipd_re);
		VitalWireDelay (alignstatus_ipd, alignstatus, tipd_alignstatus);
		VitalWireDelay (disablefifordin_ipd, disablefifordin, tipd_disablefifordin);
		VitalWireDelay (disablefifowrin_ipd, disablefifowrin, tipd_disablefifowrin);
		VitalWireDelay (fifordin_ipd, fifordin, tipd_fifordin);
		VitalWireDelay (enabledeskew_ipd, enabledeskew, tipd_enabledeskew);
		VitalWireDelay (fiforesetrd_ipd, fiforesetrd, tipd_fiforesetrd);

		VitalWireDelay (xgmdatain_ipd(0), xgmdatain(0), tipd_xgmdatain(0));
		VitalWireDelay (xgmdatain_ipd(1), xgmdatain(1), tipd_xgmdatain(1));
		VitalWireDelay (xgmdatain_ipd(2), xgmdatain(2), tipd_xgmdatain(2));
		VitalWireDelay (xgmdatain_ipd(3), xgmdatain(3), tipd_xgmdatain(3));
		VitalWireDelay (xgmdatain_ipd(4), xgmdatain(4), tipd_xgmdatain(4));
		VitalWireDelay (xgmdatain_ipd(5), xgmdatain(5), tipd_xgmdatain(5));
		VitalWireDelay (xgmdatain_ipd(6), xgmdatain(6), tipd_xgmdatain(6));
		VitalWireDelay (xgmdatain_ipd(7), xgmdatain(7), tipd_xgmdatain(7));
		VitalWireDelay (xgmctrlin_ipd, xgmctrlin, tipd_xgmctrlin);
	end block;

-- generate internal inut signals

reset_int <= softreset_ipd;

-- word_align inputs
wa_datain  <= parallelfdbk when (use_parallel_feedback = "true") else serdes_dataout;
wa_clk     <= rcvd_clk;
wa_enacdet <= enacdet_ipd; 
wa_bitslip <= bitslip_ipd; 
wa_a1a2size <= a1a2size_ipd; 

-- deskew FIFO inputs
dsfifo_datain       <= wa_aligneddata WHEN (use_symbol_align = "true") ELSE idle_bus;     
dsfifo_errdetectin  <= wa_invalidcode WHEN (use_symbol_align = "true") ELSE '0';   
dsfifo_syncstatusin <= wa_syncstatus WHEN (use_symbol_align = "true") ELSE '1';  
dsfifo_disperrin    <= wa_disperr WHEN (use_symbol_align = "true") ELSE '0';
dsfifo_patterndetectin <= wa_patterndetect WHEN (use_symbol_align = "true") ELSE '0';
dsfifo_writeclock   <= rcvd_clk;
dsfifo_readclock    <= clk_1;
dsfifo_fiforesetrd  <= fiforesetrd_ipd; 
dsfifo_enabledeskew <= enabledeskew_ipd;

-- comp FIFO inputs
cmfifo_datain <= dsfifo_dataout WHEN (use_channel_align = "true") ELSE wa_aligneddata WHEN (use_symbol_align = "true") ELSE serdes_dataout;

cmfifo_datainpre <= dsfifo_dataoutpre WHEN (use_channel_align = "true") ELSE wa_aligneddatapre WHEN (use_symbol_align = "true") ELSE idle_bus;

cmfifo_invalidcodein <= dsfifo_errdetect WHEN (use_channel_align = "true") ELSE wa_invalidcode WHEN (use_symbol_align = "true") ELSE '0';

cmfifo_syncstatusin <= dsfifo_syncstatus WHEN (use_channel_align = "true") ELSE wa_syncstatus WHEN (use_symbol_align = "true") ELSE '1';

cmfifo_disperrin <= dsfifo_disperr WHEN (use_channel_align = "true") ELSE wa_disperr WHEN (use_symbol_align = "true") ELSE '0';

cmfifo_patterndetectin <= dsfifo_patterndetect WHEN (use_channel_align = "true") ELSE wa_patterndetect WHEN (use_symbol_align = "true") ELSE '1';

cmfifo_invalidcodeinpre <= dsfifo_errdetectpre WHEN (use_channel_align = "true") ELSE wa_invalidcodepre WHEN (use_symbol_align = "true") ELSE '0';

cmfifo_syncstatusinpre <= dsfifo_syncstatuspre WHEN (use_channel_align = "true") ELSE wa_syncstatusdeskew WHEN (use_symbol_align = "true") ELSE '1';

cmfifo_disperrinpre <= dsfifo_disperrpre WHEN (use_channel_align = "true") ELSE wa_disperrpre WHEN (use_symbol_align = "true") ELSE '0';

cmfifo_patterndetectinpre <= dsfifo_patterndetectpre WHEN (use_channel_align = "true") ELSE wa_patterndetectpre WHEN (use_symbol_align = "true") ELSE '0';

cmfifo_writeclk <= clk_1;

cmfifo_readclk <=  clk_2;

cmfifo_alignstatus <= alignstatus_ipd;
cmfifo_re <= re_ipd;
cmfifo_we <= we_ipd;
cmfifo_fifordin <= fifordin_ipd;
cmfifo_disablefifordin <= disablefifordin_ipd; 
cmfifo_disablefifowrin <= disablefifowrin_ipd;

-- 8B10B decoder inputs
decoder_clk  <= clk_2;
decoder_datain <= cmfifo_dataout WHEN (use_rate_match_fifo = "true") ELSE dsfifo_dataout WHEN (use_channel_align = "true") ELSE wa_aligneddata WHEN (use_symbol_align = "true") ELSE serdes_dataout;   

decoder_errdetectin <= cmfifo_invalidcode WHEN (use_rate_match_fifo = "true") ELSE dsfifo_errdetect WHEN (use_channel_align = "true") ELSE wa_invalidcode WHEN (use_symbol_align = "true") ELSE '0';   

decoder_syncstatusin <= cmfifo_syncstatus WHEN (use_rate_match_fifo = "true") ELSE dsfifo_syncstatus WHEN (use_channel_align = "true") ELSE wa_syncstatus WHEN (use_symbol_align = "true") ELSE '1';   

decoder_disperrin <= cmfifo_disperr WHEN (use_rate_match_fifo = "true") ELSE dsfifo_disperr WHEN (use_channel_align = "true") ELSE wa_disperr WHEN (use_symbol_align = "true") ELSE '0';   

decoder_patterndetectin <= cmfifo_patterndetect WHEN (use_rate_match_fifo = "true") ELSE dsfifo_patterndetect WHEN (use_channel_align = "true") ELSE wa_patterndetect WHEN (use_symbol_align = "true") ELSE '0';   

decoder_indatavalid <= cmfifo_datavalid WHEN (use_rate_match_fifo = "true") ELSE '1';   

-- rx_core inputs
core_datain <= post8b10b when (use_post8b10b_feedback = "true") else ("00" & decoder_dataout) WHEN (use_8b_10b_mode = "true") ELSE decoder_tenBdata;
core_writeclk <= clk_2;
core_readclk <= rx_rd_clk;
core_decdatavalid <= decoder_decdatavalid WHEN (use_8b_10b_mode = "true") ELSE '1'; 
core_xgmdatain <= xgmdatain_ipd;
core_xgmctrlin <= xgmctrlin_ipd;
core_post8b10b <= post8b10b_ipd;
core_syncstatusin <= decoder_syncstatus;
core_errdetectin <= decoder_errdetect;
core_ctrldetectin <= decoder_ctrldetect;
core_disparityerrin <= decoder_disperr;
core_patterndetectin <= decoder_patterndetect;

   rcvd_clk <= pllclk_ipd WHEN (use_parallel_feedback = "true") ELSE serdes_clkout ;
   clk_1 <= pllclk_ipd WHEN (use_parallel_feedback = "true") ELSE masterclk_ipd WHEN (use_channel_align = "true") ELSE serdes_clkout ;
   
   -- added gfifo
   clk_2 <= coreclk_ipd WHEN (clk_out_mode_reference = "false") ELSE clk2_mux1 ;
   rx_rd_clk <= coreclk_ipd WHEN (clk_out_mode_reference = "false") ELSE rx_rd_clk_mux ;

clk2mux1 : stratixgx_hssi_mux4 
      PORT MAP (
         Y => clk2_mux1,
         I0 => serdes_clkout,
         I1 => masterclk_ipd,
         I2 => gnd,
         I3 => pllclk_ipd,
         C0 => clk2mux1_c0,
         C1 => clk2mux1_c1);   
   
   clk2mux1_c0 <= '1' WHEN (use_parallel_feedback = "true") OR (use_channel_align = "true") OR (use_rate_match_fifo = "true") ELSE '0' ;
   clk2mux1_c1 <= '1' WHEN (use_parallel_feedback = "true") OR (use_rate_match_fifo = "true") ELSE '0' ;

   rxrdclkmux1 : stratixgx_hssi_mux4 
      PORT MAP (
         Y => rxrdclk_mux1,
         I0 => serdes_clkout,
         I1 => masterclk_ipd,
         I2 => gnd,
         I3 => pllclk_ipd,
         C0 => rxrdclkmux1_c0,
         C1 => rxrdclkmux1_c1);   

   rxrdclkmux1_c1 <= '1' WHEN (use_parallel_feedback = "true") OR (use_rate_match_fifo = "true") ELSE '0' ;
   rxrdclkmux1_c0 <= '1' WHEN (use_parallel_feedback = "true") OR (use_channel_align = "true") OR (use_rate_match_fifo = "true") ELSE '0' ;

   rxrdclkmux2 : stratixgx_hssi_mux4 
      PORT MAP (
         Y => rx_rd_clk_mux,
         I0 => coreclk_ipd,
         I1 => gnd,
         I2 => rxrdclk_mux1_by2,
         I3 => rxrdclk_mux1,
         C0 => rxrdclkmux2_c0,
         C1 => rxrdclkmux2_c1);   
   
   rxrdclkmux2_c1 <= '1' WHEN (send_reverse_parallel_feedback = "true") ELSE '0' ;
   rxrdclkmux2_c0 <= '1' WHEN ((use_double_data_mode = "false") AND (send_reverse_parallel_feedback = "true")) ELSE '0' ;

   rxrdclkmux_by2 : stratixgx_hssi_divide_by_two 
      GENERIC MAP (
         divide => use_double_data_mode)
      PORT MAP (
         clkin => rxrdclk_mux1,
         clkout => rxrdclk_mux1_by2);   

-- sub modules
s_rx_serdes :	stratixgx_hssi_rx_serdes
					generic map (
									channel_width => deserialization_factor,
									rlv_length => run_length,
									run_length_enable => run_length_enable,
									cruclk_period => cruclk_period,
									cruclk_multiplier => cruclk_multiplier,
	                        use_cruclk_divider => use_cruclk_divider,
                           use_double_data_mode => use_double_data_mode
									)
					port map (
								datain => datain,
							 	cruclk => cruclk,
								areset => analogreset_ipd,
								feedback => serialfdbk,
								fbkcntl => slpbk,
                                ltr => locktorefclk,
                                ltd => locktodata,
								dataout => serdes_dataout,
								clkout => serdes_clkout,
								rlv => serdes_rlv,
								lock => serdes_lock,
								freqlock => serdes_freqlock,
								signaldetect => serdes_signaldetect
								);
				
s_word_align :	stratixgx_hssi_word_aligner
  generic map	(
    channel_width => deserialization_factor,
    align_pattern_length => align_pattern_length,
    infiniband_invalid_code => infiniband_invalid_code,
    align_pattern => align_pattern,
    synchronization_mode => synchronization_mode,
    use_auto_bit_slip => use_auto_bit_slip
    )
  port map	(	
    datain => wa_datain, 
    clk => wa_clk, 
    softreset => reset_int, 
    enacdet => wa_enacdet, 
    bitslip => wa_bitslip, 
    a1a2size => wa_a1a2size, 
    aligneddata => wa_aligneddata, 
    aligneddatapre => wa_aligneddatapre, 
    invalidcode => wa_invalidcode, 
    invalidcodepre => wa_invalidcodepre, 
    syncstatus => wa_syncstatus, 
    syncstatusdeskew => wa_syncstatusdeskew, 
    disperr => wa_disperr, 
    disperrpre => wa_disperrpre, 
    patterndetect => wa_patterndetect,
    patterndetectpre => wa_patterndetectpre
    );

s_dsfifo :	stratixgx_deskew_fifo 
  port map	(
    datain => dsfifo_datain,
    errdetectin => dsfifo_errdetectin,
    syncstatusin => dsfifo_syncstatusin,
    disperrin => dsfifo_disperrin,   
    patterndetectin => dsfifo_patterndetectin,
    writeclock => dsfifo_writeclock,  
    readclock => dsfifo_readclock,   
    adetectdeskew => dsfifo_adetectdeskew,
    fiforesetrd => dsfifo_fiforesetrd,
    enabledeskew => dsfifo_enabledeskew,
    reset => reset_int,
    dataout => dsfifo_dataout,   
    dataoutpre => dsfifo_dataoutpre,   
    errdetect => dsfifo_errdetect,    
    syncstatus => dsfifo_syncstatus,
    disperr => dsfifo_disperr,
    patterndetect => dsfifo_patterndetect,
    errdetectpre => dsfifo_errdetectpre,    
    syncstatuspre => dsfifo_syncstatuspre,
    disperrpre => dsfifo_disperrpre,
    patterndetectpre => dsfifo_patterndetectpre,
    rdalign => dsfifo_rdalign
    );

s_cmfifo :	stratixgx_comp_fifo
  generic map (
    use_rate_match_fifo     => use_rate_match_fifo,
    rate_matching_fifo_mode => rate_matching_fifo_mode,
    use_channel_align       => use_channel_align,
    for_engineering_sample_device  => for_engineering_sample_device, -- new in 3.0 SP2 
    channel_num             => channel_num
    )
  port map (
    datain => cmfifo_datain,
    datainpre => cmfifo_datainpre,
    reset => reset_int,
    errdetectin => cmfifo_invalidcodein, 
    syncstatusin => cmfifo_syncstatusin,
    disperrin => cmfifo_disperrin,
    patterndetectin => cmfifo_patterndetectin,
    errdetectinpre => cmfifo_invalidcodeinpre, 
    syncstatusinpre => cmfifo_syncstatusinpre,
    disperrinpre => cmfifo_disperrinpre,
    patterndetectinpre => cmfifo_patterndetectinpre,
    writeclk => cmfifo_writeclk,
    readclk => cmfifo_readclk,
    re => cmfifo_re,
    we => cmfifo_we,
    fifordin => cmfifo_fifordin,
    disablefifordin => cmfifo_disablefifordin,
    disablefifowrin => cmfifo_disablefifowrin,
    alignstatus => cmfifo_alignstatus,
    dataout => cmfifo_dataout,
    errdetectout => cmfifo_invalidcode,
    syncstatus => cmfifo_syncstatus,
    disperr => cmfifo_disperr,
    patterndetect => cmfifo_patterndetect,
    codevalid => cmfifo_datavalid,
    fifofull => cmfifo_fifofull,
    fifoalmostful => cmfifo_fifoalmostfull,
    fifoempty => cmfifo_fifoempty,
    fifoalmostempty => cmfifo_fifoalmostempty,
    disablefifordout => cmfifo_disablefifordout,
    disablefifowrout => cmfifo_disablefifowrout,
    fifordout => cmfifo_fifordout
    );

s_decoder :	stratixgx_8b10b_decoder
  port map	( 
    clk => decoder_clk, 
    reset => reset_int, 
    errdetectin => decoder_errdetectin, 
    syncstatusin => decoder_syncstatusin, 
    disperrin => decoder_disperrin, 
    patterndetectin => decoder_patterndetectin, 
    datainvalid => decoder_indatavalid, 
    datain => decoder_datain, 
    valid => decoder_valid, 
    dataout => decoder_dataout,
    tenBdata => decoder_tenBdata,
    errdetect => decoder_errdetect,
    syncstatus => decoder_syncstatus,
    disperr => decoder_disperr,
    patterndetect => decoder_patterndetect,
    kout => decoder_ctrldetect,
    rderr => decoder_rderr,
    decdatavalid => decoder_decdatavalid,
    xgmdatavalid => decoder_xgmdatavalid,
    xgmrunningdisp => decoder_xgmrunningdisp,
    xgmctrldet => decoder_xgmctrldet,
    xgmdataout => decoder_xgmdataout
    );

s_rx_clkout_mux : stratixgx_hssi_divide_by_two 
   GENERIC MAP (
      divide => use_double_data_mode)
   PORT MAP (
      reset => reset_int,
      clkin => rxrdclk_mux1,
      clkout => clkoutmux_clkout_pre
   );   

s_rx_core :	stratixgx_rx_core 
generic map (
  channel_width => deserialization_factor,
  use_double_data_mode => use_double_data_mode,
  use_channel_align    => use_channel_align,
  use_8b_10b_mode      => use_8b_10b_mode,
  align_pattern	     => align_pattern,
  synchronization_mode => synchronization_mode
  )
  port map
  (
    reset => reset_int,
    datain => core_datain,
    writeclk => core_writeclk,
    readclk => core_readclk,
    decdatavalid => core_decdatavalid,
    xgmdatain => core_xgmdatain,
    xgmctrlin => core_xgmctrlin,
    post8b10b => core_post8b10b,
    syncstatusin => core_syncstatusin,
    errdetectin => core_errdetectin,
    ctrldetectin => core_ctrldetectin,
    disparityerrin => core_disparityerrin,
    patterndetectin => core_patterndetectin,
    dataout => core_dataout,
    syncstatus => core_syncstatus,
    errdetect => core_errdetect,
    ctrldetect => core_ctrldetect,
    disparityerr => core_disparityerr,
	 patterndetect => core_patterndetect,
	 a1a2sizeout => core_a1a2sizeout,
    clkout => core_clkout
  );   

dataout_tmp <= core_dataout;

-- output from clkout mux
-- - added gfifo
clkoutmux_clkout <= serdes_clkout WHEN ((use_parallel_feedback = "false") AND (clk_out_mode_reference = "false")) ELSE clkoutmux_clkout_pre;

clkout <= clkoutmux_clkout;

VITAL: process (pllclk_ipd, coreclk_ipd, dataout_tmp, core_syncstatus, core_patterndetect,
    cmfifo_fifofull, cmfifo_fifoempty, cmfifo_fifoalmostfull, cmfifo_fifoalmostempty, re_ipd,
	core_a1a2sizeout,
	core_ctrldetect, core_errdetect, core_disparityerr)

variable Tviol_datain_clk : std_ulogic := '0';
variable TimingData_datain_clk : VitalTimingDataType := VitalTimingDataInit;
variable dataout_VitalGlitchDataArray : VitalGlitchDataArrayType(19 downto 0);
variable syncstatus_VitalGlitchDataArray : VitalGlitchDataArrayType(1 downto 0);
variable patterndetect_VitalGlitchDataArray : VitalGlitchDataArrayType(1 downto 0);
variable ctrldetect_VitalGlitchDataArray : VitalGlitchDataArrayType(1 downto 0);
variable errdetect_VitalGlitchDataArray : VitalGlitchDataArrayType(1 downto 0);
variable disperr_VitalGlitchDataArray : VitalGlitchDataArrayType(1 downto 0);
variable a1a2sizeout_VitalGlitchDataArray : VitalGlitchDataArrayType(1 downto 0);
variable fifofull_VitalGlitchData: VitalGlitchDataType;
variable fifoempty_VitalGlitchData: VitalGlitchDataType;
variable fifoalmostfull_VitalGlitchData: VitalGlitchDataType;
variable fifoalmostempty_VitalGlitchData: VitalGlitchDataType;
variable Tviol_re_clk : std_ulogic := '0';
variable TimingData_re_clk : VitalTimingDataType := VitalTimingDataInit;

begin


	------------------------
	--  Timing Check Section
	------------------------

	if (TimingChecksOn) then

		VitalSetupHoldCheck (
			Violation       => Tviol_re_clk,
			TimingData      => TimingData_re_clk,
			TestSignal      => re_ipd,
			TestSignalName  => "RE",
			RefSignal       => coreclk_ipd,
			RefSignalName   => "CORECLK",
			SetupHigh       => tsetup_re_coreclk_noedge_posedge,
			SetupLow        => tsetup_re_coreclk_noedge_posedge,
			HoldHigh        => thold_re_coreclk_noedge_posedge,
			HoldLow         => thold_re_coreclk_noedge_posedge,
			RefTransition   => '/',
			HeaderMsg       => InstancePath & "/STRATIXGX_HSSI_RECEIVER",
			XOn             => XOnChecks,
			MsgOn           => MsgOnChecks );
   end if;



   ----------------------
   --  Path Delay Section
   ----------------------


   VitalPathDelay01 (
      OutSignal => fifofull,
      OutSignalName => "FIFOFULL",
      OutTemp => cmfifo_fifofull,
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_fifofull_posedge, TRUE)),
      GlitchData => fifofull_VitalGlitchData,
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

   VitalPathDelay01 (
      OutSignal => fifoempty,
      OutSignalName => "FIFOEMPTY",
      OutTemp => cmfifo_fifoempty,
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_fifoempty_posedge, TRUE)),
      GlitchData => fifoempty_VitalGlitchData,
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

   VitalPathDelay01 (
      OutSignal => fifoalmostfull,
      OutSignalName => "FIFOALMOSTFULL",
      OutTemp => cmfifo_fifoalmostfull,
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_fifoalmostfull_posedge, TRUE)),
      GlitchData => fifoalmostfull_VitalGlitchData,
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

   VitalPathDelay01 (
      OutSignal => fifoalmostempty,
      OutSignalName => "FIFOALMOSTEMPTY",
      OutTemp => cmfifo_fifoalmostempty,
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_fifoalmostempty_posedge, TRUE)),
      GlitchData => fifoalmostempty_VitalGlitchData,
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(0),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(0),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(0), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(0),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(1),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(1),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(1), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(1),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(2),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(2),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(2), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(2),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(3),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(3),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(3), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(3),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(4),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(4),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(4), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(4),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(5),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(5),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(5), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(5),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(6),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(6),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(6), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(6),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(7),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(7),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(7), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(7),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(8),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(8),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(8), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(8),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(9),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(9),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(9), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(9),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(10),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(10),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(10), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(10),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(11),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(11),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(11), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(11),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(12),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(12),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(12), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(12),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(13),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(13),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(13), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(13),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(14),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(14),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(14), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(14),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(15),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(15),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(15), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(15),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(16),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(16),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(16), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(16),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(17),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(17),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(17), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(17),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(18),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(18),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(18), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(18),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	VitalPathDelay01 (
		OutSignal => dataout(19),
		OutSignalName => "DATAOUT",
		OutTemp => dataout_tmp(19),
		Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_dataout_posedge(19), TRUE)),
		GlitchData => dataout_VitalGlitchDataArray(19),
		Mode => DefGlitchMode,
		XOn  => XOn,
		MsgOn  => MsgOn );

	-- control signals
   VitalPathDelay01 (
      OutSignal => syncstatus(0),
      OutSignalName => "SYNCSTATUS",
      OutTemp => core_syncstatus(0),
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_syncstatus_posedge(0), TRUE)),
      GlitchData => syncstatus_VitalGlitchDataArray(0),
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

   VitalPathDelay01 (
      OutSignal => syncstatus(1),
      OutSignalName => "SYNCSTATUS",
      OutTemp => core_syncstatus(1),
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_syncstatus_posedge(1), TRUE)),
      GlitchData => syncstatus_VitalGlitchDataArray(1),
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

   VitalPathDelay01 (
      OutSignal => patterndetect(0),
      OutSignalName => "patterndetect(0)",
      OutTemp => core_patterndetect(0),
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_patterndetect_posedge(0), TRUE)),
      GlitchData => patterndetect_VitalGlitchDataArray(0),
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

   VitalPathDelay01 (
      OutSignal => patterndetect(1),
      OutSignalName => "patterndetect(1)",
      OutTemp => core_patterndetect(1),
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_patterndetect_posedge(1), TRUE)),
      GlitchData => patterndetect_VitalGlitchDataArray(1),
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

   VitalPathDelay01 (
      OutSignal => ctrldetect(0),
      OutSignalName => "ctrldetect(0)",
      OutTemp => core_ctrldetect(0),
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_ctrldetect_posedge(0), TRUE)),
      GlitchData => ctrldetect_VitalGlitchDataArray(0),
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

   VitalPathDelay01 (
      OutSignal => ctrldetect(1),
      OutSignalName => "ctrldetect(1)",
      OutTemp => core_ctrldetect(1),
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_ctrldetect_posedge(1), TRUE)),
      GlitchData => ctrldetect_VitalGlitchDataArray(1),
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

   VitalPathDelay01 (
      OutSignal => errdetect(0),
      OutSignalName => "errdetect(0)",
      OutTemp => core_errdetect(0),
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_errdetect_posedge(0), TRUE)),
      GlitchData => errdetect_VitalGlitchDataArray(0),
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

   VitalPathDelay01 (
      OutSignal => errdetect(1),
      OutSignalName => "errdetect(1)",
      OutTemp => core_errdetect(1),
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_errdetect_posedge(1), TRUE)),
      GlitchData => errdetect_VitalGlitchDataArray(1),
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

   VitalPathDelay01 (
      OutSignal => disperr(0),
      OutSignalName => "disperr(0)",
      OutTemp => core_disparityerr(0),
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_disperr_posedge(0), TRUE)),
      GlitchData => disperr_VitalGlitchDataArray(0),
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

   VitalPathDelay01 (
      OutSignal => disperr(1),
      OutSignalName => "disperr(1)",
      OutTemp => core_disparityerr(1),
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_disperr_posedge(1), TRUE)),
      GlitchData => disperr_VitalGlitchDataArray(1),
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

   VitalPathDelay01 (
      OutSignal => a1a2sizeout(0),
      OutSignalName => "a1a2sizeout(0)",
      OutTemp => core_a1a2sizeout(0),
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_a1a2sizeout_posedge(0), TRUE)),
      GlitchData => a1a2sizeout_VitalGlitchDataArray(0),
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

   VitalPathDelay01 (
      OutSignal => a1a2sizeout(1),
      OutSignalName => "a1a2sizeout(1)",
      OutTemp => core_a1a2sizeout(1),
      Paths => (1 => (coreclk_ipd'last_event, tpd_coreclk_a1a2sizeout_posedge(1), TRUE)),
      GlitchData => a1a2sizeout_VitalGlitchDataArray(1),
      Mode => DefGlitchMode,
      XOn  => XOn,
      MsgOn  => MsgOn );

end process;


-- generate output signals

-- outputs from serdes
recovclkout <= serdes_clkout;
rlv <= serdes_rlv;
lock <= serdes_lock;
freqlock <= serdes_freqlock;
signaldetect <= serdes_signaldetect;

-- outputs from word_aligner
syncstatusdeskew <= wa_syncstatusdeskew;

-- outputs from deskew FIFO
adetectdeskew <= dsfifo_adetectdeskew;
rdalign <= dsfifo_rdalign;

-- outputs from comp FIFO
-- fifofull <= cmfifo_fifofull;
-- fifoalmostfull <= cmfifo_fifoalmostfull;
-- fifoempty <= cmfifo_fifoempty;
-- fifoalmostempty <= cmfifo_fifoalmostempty;
fifordout <= cmfifo_fifordout;
disablefifordout <= cmfifo_disablefifordout;
disablefifowrout <= cmfifo_disablefifowrout;

-- outputs from decoder
xgmctrldet <= decoder_xgmctrldet;
xgmrunningdisp <= decoder_xgmrunningdisp;
xgmdatavalid <= decoder_xgmdatavalid;
xgmdataout <= decoder_xgmdataout;

end vital_receiver_atom;

--
-- STRATIXGX_HSSI_TRANSMITTER
--

library IEEE, stratixgx_gxb,std;
use IEEE.std_logic_1164.all;
use IEEE.VITAL_Timing.all;
use IEEE.VITAL_Primitives.all;
use stratixgx_gxb.hssi_pack.all;
use std.textio.all;

entity stratixgx_hssi_transmitter is
  generic (
    channel_num		: integer := 1;
    channel_width	: integer := 20;
    serialization_factor: integer := 10;
    use_8b_10b_mode	: String  := "false";
    use_double_data_mode: String  := "false";
    use_fifo_mode	: String  := "false";
    use_reverse_parallel_feedback : String := "false";
    force_disparity_mode: String  := "false";
    transmit_protocol	: String  := "none";
    use_vod_ctrl_signal : String := "false";
    use_preemphasis_ctrl_signal : String := "false";
    use_self_test_mode          : String := "false";
    self_test_mode          : integer  := 0;
    vod_ctrl_setting            : integer := 4;  
    preemphasis_ctrl_setting    : integer := 5;
    termination                 : integer := 0;
    TimingChecksOn	: Boolean := True;
    MsgOn		: Boolean := DefGlitchMsgOn;
    XOn			: Boolean := DefGlitchXOn;
    MsgOnChecks		: Boolean := DefMsgOnChecks;
    XOnChecks		: Boolean := DefXOnChecks;
    InstancePath	: String  := "*";
    tipd_datain         : VitalDelayArrayType01(19 downto 0) := (OTHERS => DefPropDelay01);
    tipd_pllclk		: VitalDelayType01 := DefpropDelay01;
    tipd_fastpllclk	: VitalDelayType01 := DefpropDelay01;
    tipd_coreclk	: VitalDelayType01 := DefpropDelay01;
    tipd_softreset	: VitalDelayType01 := DefpropDelay01;
    tipd_ctrlenable     : VitalDelayArrayType01(1 downto 0) := (OTHERS => DefPropDelay01);
    tipd_forcedisparity : VitalDelayArrayType01(1 downto 0) := (OTHERS => DefPropDelay01);
    tipd_serialdatain	: VitalDelayType01 := DefpropDelay01;
    tipd_xgmdatain	: VitalDelayArrayType01(7 downto 0) := (OTHERS => DefPropDelay01);
    tipd_xgmctrl	: VitalDelayType01 := DefpropDelay01;
    tipd_srlpbk		: VitalDelayType01 := DefpropDelay01;
    tipd_analogreset	: VitalDelayType01 := DefpropDelay01;
    tipd_vodctrl	: VitalDelayArrayType01(2 downto 0) := (OTHERS => DefPropDelay01);
    tipd_preemphasisctrl: VitalDelayArrayType01(2 downto 0) := (OTHERS => DefPropDelay01);
    tsetup_datain_coreclk_noedge_posedge        : VitalDelayArrayType(19 downto 0) := (OTHERS => DefSetupHoldCnst);
    thold_datain_coreclk_noedge_posedge         : VitalDelayArrayType(19 downto 0) := (OTHERS => DefSetupHoldCnst);
    tsetup_ctrlenable_coreclk_noedge_posedge    : VitalDelayArrayType(1 downto 0) := (OTHERS => DefSetupHoldCnst);
    thold_ctrlenable_coreclk_noedge_posedge     : VitalDelayArrayType(1 downto 0) := (OTHERS => DefSetupHoldCnst);
    tsetup_forcedisparity_coreclk_noedge_posedge: VitalDelayArrayType(1 downto 0) := (OTHERS => DefSetupHoldCnst);
    thold_forcedisparity_coreclk_noedge_posedge : VitalDelayArrayType(1 downto 0) := (OTHERS => DefSetupHoldCnst)
    );
  
  port (
    datain      : in std_logic_vector(19 downto 0);
    pllclk	: in std_logic := '0';
    fastpllclk	: in std_logic := '0';
    coreclk	: in std_logic := '0';
    softreset	: in std_logic := '0';
    ctrlenable	: in std_logic_vector(1 downto 0) := "00";
    forcedisparity : in std_logic_vector(1 downto 0) := "00";
    serialdatain   : in std_logic := '0';
    xgmdatain	: in std_logic_vector(7 downto 0) := "00000000";
    xgmctrl	: in std_logic := '0';
    srlpbk      : in std_logic := '0';
    devclrn	: in std_logic := '1';
    devpor	: in std_logic := '1';
    analogreset	: in std_logic := '0'; 
    vodctrl	: in std_logic_vector(2 downto 0) := "000";
    preemphasisctrl : in std_logic_vector(2 downto 0) := "000";
    dataout	: out std_logic;
    xgmdataout	: out std_logic_vector(7 downto 0);
    xgmctrlenable : out std_logic;
    rdenablesync  : out std_logic;
    parallelfdbkdata : out std_logic_vector(9 downto 0);
    pre8b10bdata     : out std_logic_vector(9 downto 0)
    );
end stratixgx_hssi_transmitter;

architecture vital_transmitter_atom of stratixgx_hssi_transmitter is
	signal datain_ipd : std_logic_vector(19 downto 0);
	signal pllclk_ipd  : std_logic;
	signal fastpllclk_ipd  : std_logic;
	signal coreclk_ipd  : std_logic;
	signal softreset_ipd  : std_logic;
	signal ctrlenable_ipd : std_logic_vector(1 downto 0);
	signal forcedisparity_ipd : std_logic_vector(1 downto 0);
	signal analogreset_ipd : std_logic;
	signal vodctrl_ipd : std_logic_vector(2 downto 0);
	signal preemphasisctrl_ipd : std_logic_vector(2 downto 0);
	signal serialdatain_ipd  : std_logic;
	signal xgmdatain_ipd : std_logic_vector(7 downto 0);
	signal xgmctrl_ipd  : std_logic;
	signal srlpbk_ipd  : std_logic;

	--constant signals
	signal vcc : std_logic := '1';
	signal gnd : std_logic := '0';
	signal idle_bus : std_logic_vector(9 downto 0) := "0000000000";

	--lower lever softreset 
	signal reset_int : std_logic;

	-- tx_core input/output signals
	signal core_datain : std_logic_vector(19 downto 0);
	signal core_writeclk : std_logic;
	signal core_readclk : std_logic;
	signal core_ctrlena : std_logic_vector(1 downto 0);
	signal core_forcedisp : std_logic_vector(1 downto 0);

	signal core_dataout : std_logic_vector(9 downto 0);
	signal core_forcedispout : std_logic;
	signal core_ctrlenaout : std_logic;
	signal core_rdenasync : std_logic;
	signal core_xgmctrlena : std_logic;
	signal core_xgmdataout : std_logic_vector(7 downto 0);
	signal core_pre8b10bdataout : std_logic_vector(9 downto 0);

	-- serdes input/output signals
	signal serdes_clk : std_logic;
	signal serdes_clk1 : std_logic;
	signal serdes_datain : std_logic_vector(9 downto 0);
	signal serdes_serialdatain : std_logic;
	signal serdes_srlpbk : std_logic;

	signal serdes_dataout : std_logic;

	-- encoder input/output signals
	signal encoder_clk : std_logic := '0'; 
	signal encoder_kin : std_logic := '0';  
	signal encoder_datain : std_logic_vector(7 downto 0) := "00000000";
   signal encoder_para : std_logic_vector(9 downto 0) := "0000000000";
   signal encoder_xgmdatain : std_logic_vector(7 downto 0) := "00000000";
   signal encoder_xgmctrl : std_logic := '0';

	signal encoder_dataout : std_logic_vector(9 downto 0) := "0000000000"; 
	signal encoder_rdout : std_logic := '0'; 

	-- internal signal for parallelfdbkdata
	signal parallelfdbkdata_tmp : std_logic_vector(9 downto 0);

   signal txclk : std_logic;
   signal pllclk_int : std_logic;
    
-- sub module component declaration

component stratixgx_tx_core
  GENERIC (
    use_double_data_mode           :  string := "false";    
    use_fifo_mode                  :  string := "true"; 
    channel_width                  :  integer := 10;   
    transmit_protocol              :  string  := "none";
    KCHAR                          :  std_logic := '0';    
    ECHAR                          :  std_logic := '0');
   port (
	      reset                   : IN std_logic;   
	      datain                  : IN std_logic_vector(19 DOWNTO 0);   
	      writeclk                : IN std_logic;   
	      readclk                 : IN std_logic;   
	      ctrlena                 : IN std_logic_vector(1 DOWNTO 0);   
	      forcedisp               : IN std_logic_vector(1 DOWNTO 0);   
	      dataout                 : OUT std_logic_vector(9 DOWNTO 0);   
	      forcedispout            : OUT std_logic;   
	      ctrlenaout              : OUT std_logic;   
	      rdenasync               : OUT std_logic;   
	      xgmctrlena              : OUT std_logic;   
	      xgmdataout              : OUT std_logic_vector(7 DOWNTO 0);   
	      pre8b10bdataout         : OUT std_logic_vector(9 DOWNTO 0)
		);   

end component;

component stratixgx_hssi_tx_serdes 
  generic (
    channel_width           : integer := 10
    );
  port (
    clk             : in std_logic := '0';
    clk1            : in std_logic := '0';
    datain          : in std_logic_vector(9 downto 0) := "0000000000";
    serialdatain	 : in std_logic := '0';
    srlpbk			 : in std_logic := '0';
    areset          : in std_logic := '0';
    dataout         : out std_logic
    );
end component;

component stratixgx_8b10b_encoder
   GENERIC (
      transmit_protocol              :  string := "none";    
      use_8b_10b_mode                :  string := "true";    
      force_disparity_mode           :  string := "false");
   PORT (
      clk                     : IN std_logic;   
      reset                   : IN std_logic;   
      xgmctrl                 : IN std_logic;   
      kin                     : IN std_logic;   
      xgmdatain               : IN std_logic_vector(7 DOWNTO 0);   
      datain                  : IN std_logic_vector(7 DOWNTO 0);   
      forcedisparity          : IN std_logic;   
      dataout                 : OUT std_logic_vector(9 DOWNTO 0);   
      parafbkdataout          : OUT std_logic_vector(9 DOWNTO 0));   
END component;

component stratixgx_hssi_divide_by_two 
  GENERIC (
    divide                  :  string := "true");
  PORT (
    reset                   : IN std_logic := '0';   
    clkin                   : IN std_logic;   
    clkout                  : OUT std_logic);   
END component;

-- end of sub module component declaration

begin

	----------------------
	--  INPUT PATH DELAYs
	----------------------
	WireDelay : block
	begin
		VitalWireDelay (datain_ipd(0), datain(0), tipd_datain(0));
		VitalWireDelay (datain_ipd(1), datain(1), tipd_datain(1));
		VitalWireDelay (datain_ipd(2), datain(2), tipd_datain(2));
		VitalWireDelay (datain_ipd(3), datain(3), tipd_datain(3));
		VitalWireDelay (datain_ipd(4), datain(4), tipd_datain(4));
		VitalWireDelay (datain_ipd(5), datain(5), tipd_datain(5));
		VitalWireDelay (datain_ipd(6), datain(6), tipd_datain(6));
		VitalWireDelay (datain_ipd(7), datain(7), tipd_datain(7));
		VitalWireDelay (datain_ipd(8), datain(8), tipd_datain(8));
		VitalWireDelay (datain_ipd(9), datain(9), tipd_datain(9));
		VitalWireDelay (datain_ipd(10), datain(10), tipd_datain(10));
		VitalWireDelay (datain_ipd(11), datain(11), tipd_datain(11));
		VitalWireDelay (datain_ipd(12), datain(12), tipd_datain(12));
		VitalWireDelay (datain_ipd(13), datain(13), tipd_datain(13));
		VitalWireDelay (datain_ipd(14), datain(14), tipd_datain(14));
		VitalWireDelay (datain_ipd(15), datain(15), tipd_datain(15));
		VitalWireDelay (datain_ipd(16), datain(16), tipd_datain(16));
		VitalWireDelay (datain_ipd(17), datain(17), tipd_datain(17));
		VitalWireDelay (datain_ipd(18), datain(18), tipd_datain(18));
		VitalWireDelay (datain_ipd(19), datain(19), tipd_datain(19));

		VitalWireDelay (pllclk_ipd, pllclk, tipd_pllclk);
		VitalWireDelay (fastpllclk_ipd, fastpllclk, tipd_fastpllclk);
		VitalWireDelay (coreclk_ipd, coreclk, tipd_coreclk);
		VitalWireDelay (softreset_ipd, softreset, tipd_softreset);

		VitalWireDelay (ctrlenable_ipd(0), ctrlenable(0), tipd_ctrlenable(0));
		VitalWireDelay (ctrlenable_ipd(1), ctrlenable(1), tipd_ctrlenable(1));

		VitalWireDelay (forcedisparity_ipd(0), forcedisparity(0), tipd_forcedisparity(0));
		VitalWireDelay (forcedisparity_ipd(1), forcedisparity(1), tipd_forcedisparity(1));

		VitalWireDelay (analogreset_ipd, analogreset, tipd_analogreset);
		VitalWireDelay (vodctrl_ipd(0), vodctrl(0), tipd_vodctrl(0));
		VitalWireDelay (vodctrl_ipd(1), vodctrl(1), tipd_vodctrl(1));
		VitalWireDelay (vodctrl_ipd(2), vodctrl(2), tipd_vodctrl(2));
		VitalWireDelay (preemphasisctrl_ipd(0), preemphasisctrl(0), tipd_preemphasisctrl(0));
		VitalWireDelay (preemphasisctrl_ipd(1), preemphasisctrl(1), tipd_preemphasisctrl(1));
		VitalWireDelay (preemphasisctrl_ipd(2), preemphasisctrl(2), tipd_preemphasisctrl(2));

		VitalWireDelay (serialdatain_ipd, serialdatain, tipd_serialdatain);

		VitalWireDelay (xgmdatain_ipd(0), xgmdatain(0), tipd_xgmdatain(0));
		VitalWireDelay (xgmdatain_ipd(1), xgmdatain(1), tipd_xgmdatain(1));
		VitalWireDelay (xgmctrl_ipd, xgmctrl, tipd_xgmctrl);
		VitalWireDelay (srlpbk_ipd, srlpbk, tipd_srlpbk);
	end block;

-- generate internal inut signals

    txclk_block : stratixgx_hssi_divide_by_two 
      GENERIC MAP (
        divide => use_double_data_mode)
      PORT MAP (
        clkin => pllclk_ipd,
        clkout => pllclk_int);   

    txclk <= pllclk_int when use_reverse_parallel_feedback = "true" else coreclk_ipd;
        
reset_int <= softreset_ipd;

-- core_interface inputs
core_datain <= datain_ipd;
core_writeclk <= txclk;
core_readclk <= pllclk_ipd;
core_ctrlena <= ctrlenable_ipd;
core_forcedisp <= forcedisparity_ipd;

-- encoder inputs
encoder_clk <= pllclk_ipd;
encoder_kin <=  core_ctrlenaout; 
encoder_datain <= core_dataout(7 downto 0);
encoder_xgmdatain <= xgmdatain(7 downto 0);
encoder_xgmctrl <= xgmctrl_ipd;

-- serdes inputs
serdes_clk <= fastpllclk_ipd;
serdes_clk1 <= pllclk_ipd;
serdes_datain <= encoder_dataout WHEN (use_8b_10b_mode = "true") ELSE core_dataout;
serdes_serialdatain <= serialdatain_ipd;
serdes_srlpbk <= srlpbk_ipd;

-- sub modules

s_tx_core :	stratixgx_tx_core 
  generic map (
    use_double_data_mode => use_double_data_mode, 
    use_fifo_mode => use_fifo_mode,
    channel_width => channel_width,
    transmit_protocol => transmit_protocol)
  port map (
    reset => reset_int,
    datain => core_datain, 
    writeclk => core_writeclk,
    readclk => core_readclk,
    ctrlena => core_ctrlena,
    forcedisp => core_forcedisp,
    dataout => core_dataout,
    forcedispout => core_forcedispout,
    ctrlenaout => core_ctrlenaout,
    rdenasync => core_rdenasync,
    xgmctrlena => core_xgmctrlena,
    xgmdataout => core_xgmdataout,
    pre8b10bdataout => core_pre8b10bdataout
    );   

s_encoder :	stratixgx_8b10b_encoder
  generic map (
    transmit_protocol => transmit_protocol,
    use_8b_10b_mode   => use_8b_10b_mode,
    force_disparity_mode => force_disparity_mode 
    )
  port map (
    clk             => encoder_clk,
    reset           => reset_int,
    kin             => encoder_kin,
    datain          => encoder_datain,
    xgmdatain       => encoder_xgmdatain,
    xgmctrl         => encoder_xgmctrl,
    forcedisparity  => core_forcedispout,
    dataout         => encoder_dataout,
    parafbkdataout  => encoder_para
    );
        
s_tx_serdes :	stratixgx_hssi_tx_serdes 
  generic map (
    channel_width => serialization_factor
    )
  port map (
    clk => serdes_clk,
    clk1 => serdes_clk1,
    datain => serdes_datain,
    serialdatain => serdes_serialdatain,
    srlpbk => serdes_srlpbk,
    areset => analogreset_ipd,
    dataout => serdes_dataout
    );

-- end of sub modules
 
-- generate output signals
parallelfdbkdata_tmp <= encoder_dataout WHEN (use_8b_10b_mode = "true") ELSE core_dataout; 

dataout <= serdes_dataout;
xgmctrlenable <= core_xgmctrlena;
rdenablesync <= core_rdenasync;
xgmdataout <= core_xgmdataout;
pre8b10bdata <= core_pre8b10bdataout;
parallelfdbkdata <= parallelfdbkdata_tmp;

VITAL: process (pllclk_ipd, fastpllclk_ipd, coreclk_ipd)

variable Tviol_datain_clk : std_ulogic := '0';
variable TimingData_datain_clk : VitalTimingDataType := VitalTimingDataInit;
variable Tviol_ctrlenable_clk : std_ulogic := '0';
variable TimingData_ctrlenable_clk : VitalTimingDataType := VitalTimingDataInit;
variable Tviol_forcedisparity_clk : std_ulogic := '0';
variable TimingData_forcedisparity_clk : VitalTimingDataType := VitalTimingDataInit;
variable dataout_VitalGlitchDataArray : VitalGlitchDataArrayType(19 downto 0);
variable clkout_VitalGlitchData: VitalGlitchDataType;

begin

	------------------------
	--  Timing Check Section
	------------------------

	if (TimingChecksOn) then

		VitalSetupHoldCheck (
			Violation       => Tviol_datain_clk,
			TimingData      => TimingData_datain_clk,
			TestSignal      => datain_ipd,
			TestSignalName  => "DATAIN",
			RefSignal       => coreclk_ipd,
			RefSignalName   => "CORECLK",
			SetupHigh       => tsetup_datain_coreclk_noedge_posedge(0),
			SetupLow        => tsetup_datain_coreclk_noedge_posedge(0),
			HoldHigh        => thold_datain_coreclk_noedge_posedge(0),
			HoldLow         => thold_datain_coreclk_noedge_posedge(0),
			RefTransition   => '/',
			HeaderMsg       => InstancePath & "/STRATIXGX_HSSI_TRANSMITTER",
			XOn             => XOn,
			MsgOn           => MsgOnChecks );

		VitalSetupHoldCheck (
			Violation       => Tviol_ctrlenable_clk,
			TimingData      => TimingData_ctrlenable_clk,
			TestSignal      => ctrlenable_ipd,
			TestSignalName  => "CTRLENABLE",
			RefSignal       => coreclk_ipd,
			RefSignalName   => "CORECLK",
			SetupHigh       => tsetup_ctrlenable_coreclk_noedge_posedge(0),
			SetupLow        => tsetup_ctrlenable_coreclk_noedge_posedge(0),
			HoldHigh        => thold_ctrlenable_coreclk_noedge_posedge(0),
			HoldLow         => thold_ctrlenable_coreclk_noedge_posedge(0),
			RefTransition   => '/',
			HeaderMsg       => InstancePath & "/STRATIXGX_HSSI_TRANSMITTER",
			XOn             => XOn,
			MsgOn           => MsgOnChecks );

		VitalSetupHoldCheck (
			Violation       => Tviol_forcedisparity_clk,
			TimingData      => TimingData_forcedisparity_clk,
			TestSignal      => forcedisparity_ipd,
			TestSignalName  => "FORCEDISPARITY",
			RefSignal       => coreclk_ipd,
			RefSignalName   => "CORECLK",
			SetupHigh       => tsetup_forcedisparity_coreclk_noedge_posedge(0),
			SetupLow        => tsetup_forcedisparity_coreclk_noedge_posedge(0),
			HoldHigh        => thold_forcedisparity_coreclk_noedge_posedge(0),
			HoldLow         => thold_forcedisparity_coreclk_noedge_posedge(0),
			RefTransition   => '/',
			HeaderMsg       => InstancePath & "/STRATIXGX_HSSI_TRANSMITTER",
			XOn             => XOn,
			MsgOn           => MsgOnChecks );

   end if;

	----------------------
	--  Path Delay Section
	----------------------

end process;

end vital_transmitter_atom;

