-- Copyright (C) 1991-2006 Altera Corporation
-- Your use of Altera Corporation's design tools, logic functions 
-- and other software and tools, and its AMPP partner logic 
-- functions, and any output files any of the foregoing 
-- (including device programming or simulation files), and any 
-- associated documentation or information are expressly subject 
-- to the terms and conditions of the Altera Program License 
-- Subscription Agreement, Altera MegaCore Function License 
-- Agreement, or other applicable license agreement, including, 
-- without limitation, that your use is for the sole purpose of 
-- programming logic devices manufactured by Altera and sold by 
-- Altera or its authorized distributors.  Please refer to the 
-- applicable agreement for further details.


-- Quartus II 6.0 Build 178 04/27/2006


Library ieee;
use ieee.std_logic_1164.all;
entity GLOBAL is
    port(
        a_in                           :  in    std_logic;
        a_out                          :  out   std_logic);
end GLOBAL;
architecture BEHAVIOR of GLOBAL is
begin
    a_out <= a_in;
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity CARRY is
    port(
        a_in                           :  in    std_logic;
        a_out                          :  out   std_logic);
end CARRY;
architecture BEHAVIOR of CARRY is
begin
    a_out <= a_in;
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity CASCADE is
    port(
        a_in                           :  in    std_logic;
        a_out                          :  out   std_logic);
end CASCADE;
architecture BEHAVIOR of CASCADE is
begin
    a_out <= a_in;
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity CARRY_SUM is
    port(
        sin                           :  in    std_logic;
        cin                           :  in    std_logic;
        sout                          :  out   std_logic;
        cout                          :  out   std_logic);
end CARRY_SUM;
architecture BEHAVIOR of CARRY_SUM is
begin
    sout <= sin;
    cout <= cin;
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity EXP is
    port(
        a_in                           :  in    std_logic;
        a_out                          :  out   std_logic);
end EXP;
architecture BEHAVIOR of EXP is
begin
    a_out <= not a_in;
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity SOFT is
    port(
        a_in                        :  in    std_logic;
        a_out                       :  out   std_logic);
end SOFT;
architecture BEHAVIOR of SOFT is
begin
    a_out <= a_in;
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity OPNDRN is
    port(
        a_in                        :  in    std_logic;
        a_out                       :  out   std_logic);
end OPNDRN;
architecture BEHAVIOR of OPNDRN is
begin
    process (a_in)
    begin
        if (a_in = '0') then
            a_out <= '0';
        elsif (a_in = '1') then
            a_out <= 'Z';
        else
            a_out <= 'X';
        end if;
    end process;
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity ROW_GLOBAL is
    port(
        a_in                        :  in    std_logic;
        a_out                       :  out   std_logic);
end ROW_GLOBAL;
architecture BEHAVIOR of ROW_GLOBAL is
begin
    a_out <= a_in;
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity TRI is
    port(
        a_in                        :  in    std_logic;
        oe                          :  in    std_logic;
        a_out                       :  out   std_logic);
end TRI;
architecture BEHAVIOR of TRI is
begin
    a_out <= a_in when oe = '1'
        else 'Z';
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity LUT_INPUT is
    port(
        a_in                        :  in    std_logic;
        a_out                       :  out   std_logic);
end LUT_INPUT;
architecture BEHAVIOR of LUT_INPUT is
begin
    a_out <= a_in;
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity LUT_OUTPUT is
    port(
        a_in                        :  in    std_logic;
        a_out                       :  out   std_logic);
end LUT_OUTPUT;
architecture BEHAVIOR of LUT_OUTPUT is
begin
    a_out <= a_in;
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity latch is
    port(
        d                        :  in    std_logic;
        ena                      :  in    std_logic;
        q                        :  out   std_logic);
end latch;
architecture BEHAVIOR of latch is
signal iq : std_logic := '0';
begin
    process (d, ena)
    begin
        if (ena = '1') then
            iq <= d;
        end if;
    end process;
    q <= iq;
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity PRIM_GDFF is
    port(
        d, clk, ena, clr, pre, ald, adt, sclr, sload :  in  std_logic;
        q                                            :  out std_logic);
end PRIM_GDFF;

architecture BEHAVIOR of PRIM_GDFF is

signal iq : std_logic := '0';
signal init : std_logic := '0';
signal stalled_adata : std_logic := '0';

begin
    process (clk, clr, pre, ald, stalled_adata)
    begin
        if (clr =  '1') then
            iq <= '0';
        elsif (pre = '1') then
            iq <= '1';
        elsif (ald = '1') then
            iq <= stalled_adata;
        elsif (clk'event and (clk = '1') and (clk'last_value = '0')) then
            if (ena = '1') then
                if (sclr = '1') then
                    iq <= '0';
                elsif (sload = '1') then
                    iq <= stalled_adata;
                else
                    iq <= d;
                end if;
            end if;
        end if;
    end process;

    process (adt, init)
    begin
        if (init = '0') then
            stalled_adata <= adt;
            init <= '1';
        else
            stalled_adata <= adt after 1 ps;
        end if;
    end process;

    q <= iq;

end BEHAVIOR; -- PRIM_GDFF

Library ieee;
use ieee.std_logic_1164.all;
use work.PRIM_GDFF;

entity DFF is
    port(
        d, clk, clrn, prn :  in  std_logic;
        q                 :  out std_logic);
end DFF;

architecture BEHAVIOR of DFF is

    component PRIM_GDFF
        port(
            d, clk, ena, clr, pre, ald, adt, sclr, sload :  in  std_logic;
            q                                            :  out std_logic);
    end component;
    
signal clear         : std_logic := '0';
signal preset        : std_logic := '0';
signal zero_bit      : std_logic := '0';
signal one_bit       : std_logic := '1';

begin
   
    PRIM_GDFF_INST :  PRIM_GDFF       
        port map (
            d     => d, 
            clk   => clk,
            ena   => one_bit,
            clr   => clear,
            pre   => preset,
            ald   => zero_bit,
            adt   => zero_bit,
            sclr  => zero_bit,
            sload => zero_bit,
            q     => q );

    clear  <= not clrn;
    preset <= not prn;
    

end BEHAVIOR; -- DFF

Library ieee;
use ieee.std_logic_1164.all;
use work.PRIM_GDFF;

entity DFFE is
    port(
        d, clk, ena, clrn, prn :  in  std_logic;
        q                      :  out std_logic);
end DFFE;

architecture BEHAVIOR of DFFE is

    component PRIM_GDFF
        port(
            d, clk, ena, clr, pre, ald, adt, sclr, sload :  in  std_logic;
            q                                            :  out std_logic);
    end component;
    
signal clear         : std_logic := '0';
signal preset        : std_logic := '0';
signal zero_bit      : std_logic := '0';

begin
   
    PRIM_GDFF_INST :  PRIM_GDFF       
        port map (
            d     => d, 
            clk   => clk,
            ena   => ena,
            clr   => clear,
            pre   => preset,
            ald   => zero_bit,
            adt   => zero_bit,
            sclr  => zero_bit,
            sload => zero_bit,
            q     => q );

    clear  <= not clrn;
    preset <= not prn;
    

end BEHAVIOR; -- DFFE

Library ieee;
use ieee.std_logic_1164.all;
use work.PRIM_GDFF;

entity DFFEA is
    port(
        d, clk, ena, clrn, prn, aload, adata :  in  std_logic;
        q                                    :  out std_logic);
end DFFEA;

architecture BEHAVIOR of DFFEA is

    component PRIM_GDFF
        port(
            d, clk, ena, clr, pre, ald, adt, sclr, sload :  in  std_logic;
            q                                            :  out std_logic);
    end component;
    
signal clear         : std_logic := '0';
signal preset        : std_logic := '0';
signal zero_bit      : std_logic := '0';

begin
   
    PRIM_GDFF_INST :  PRIM_GDFF       
        port map (
            d     => d, 
            clk   => clk,
            ena   => ena,
            clr   => clear,
            pre   => preset,
            ald   => aload,
            adt   => adata,
            sclr  => zero_bit,
            sload => zero_bit,
            q     => q );

    clear  <= not clrn;
    preset <= not prn;
    

end BEHAVIOR; -- DFFEA

Library ieee;
use ieee.std_logic_1164.all;
use work.PRIM_GDFF;

entity DFFEAS is
    port(
        d, clk, ena, clrn, prn, aload, asdata, sclr, sload :  in  std_logic;
        q                                                  :  out std_logic);
end DFFEAS;

architecture BEHAVIOR of DFFEAS is

    component PRIM_GDFF
        port(
            d, clk, ena, clr, pre, ald, adt, sclr, sload :  in  std_logic;
            q                                            :  out std_logic);
    end component;

signal clear         : std_logic := '0';
signal preset        : std_logic := '0';

begin

    
    PRIM_GDFF_INST :  PRIM_GDFF       
        port map (
            d     => d, 
            clk   => clk,
            ena   => ena,
            clr   => clear,
            pre   => preset,
            ald   => aload,
            adt   => asdata,
            sclr  => sclr,
            sload => sload,
            q     => q );

    clear  <= not clrn;
    preset <= not prn;

end BEHAVIOR; -- DFFEAS

Library ieee;
use ieee.std_logic_1164.all;
entity PRIM_GTFF is
    port(
        t, clk, ena, clr, pre :  in  std_logic;
        q                     :  out std_logic);
end PRIM_GTFF;

architecture BEHAVIOR of PRIM_GTFF is

signal iq : std_logic := '0';
signal init : std_logic := '0';

begin
    process (clk, clr, pre)
    begin
        if (clr =  '1') then
            iq <= '0';
        elsif (pre = '1') then
            iq <= '1';
        elsif (clk'event and (clk = '1') and (clk'last_value = '0')) then
            if (ena = '1') then
                if (t = '1') then
                    iq <= not iq;
                end if;
            end if;
        end if;
    end process;

    q <= iq;

end BEHAVIOR; -- PRIM_GTFF

Library ieee;
use ieee.std_logic_1164.all;
use work.PRIM_GTFF;

entity TFF is
    port(
        t, clk, clrn, prn :  in  std_logic;
        q                 :  out std_logic);
end TFF;

architecture BEHAVIOR of TFF is

    component PRIM_GTFF
        port(
            t, clk, ena, clr, pre :  in  std_logic;
            q                     :  out std_logic);
    end component;
    
signal clear         : std_logic := '0';
signal preset        : std_logic := '0';
signal one_bit       : std_logic := '1';

begin
   
    PRIM_GTFF_INST :  PRIM_GTFF       
        port map (
            t     => t, 
            clk   => clk,
            ena   => one_bit,
            clr   => clear,
            pre   => preset,
            q     => q );

    clear  <= not clrn;
    preset <= not prn;
    

end BEHAVIOR; -- TFF

Library ieee;
use ieee.std_logic_1164.all;
use work.PRIM_GTFF;

entity TFFE is
    port(
        t, clk, ena, clrn, prn :  in  std_logic;
        q                      :  out std_logic);
end TFFE;

architecture BEHAVIOR of TFFE is

    component PRIM_GTFF
        port(
            t, clk, ena, clr, pre :  in  std_logic;
            q                     :  out std_logic);
    end component;
    
signal clear         : std_logic := '0';
signal preset        : std_logic := '0';

begin
   
    PRIM_GTFF_INST :  PRIM_GTFF       
        port map (
            t     => t, 
            clk   => clk,
            ena   => ena,
            clr   => clear,
            pre   => preset,
            q     => q );

    clear  <= not clrn;
    preset <= not prn;
    

end BEHAVIOR; -- TFFE


Library ieee;
use ieee.std_logic_1164.all;
entity PRIM_GJKFF is
    port(
        j, k, clk, ena, clr, pre :  in  std_logic;
        q                        :  out std_logic);
end PRIM_GJKFF;

architecture BEHAVIOR of PRIM_GJKFF is

signal iq : std_logic := '0';

begin
    process (clk, clr, pre)
    begin
        if (clr =  '1') then
            iq <= '0';
        elsif (pre = '1') then
            iq <= '1';
        elsif (clk'event and (clk = '1') and (clk'last_value = '0')) then
            if (ena = '1') then
                if ((j = '1') and (k = '0')) then
                    iq <= '1';
                elsif ((j = '0') and (k = '1')) then
                    iq <= '0';
                elsif ((j = '1') and (k = '1')) then
                    iq <= not iq;
                end if;
            end if;
        end if;
    end process;

    q <= iq;

end BEHAVIOR; -- PRIM_GJKFF

Library ieee;
use ieee.std_logic_1164.all;
use work.PRIM_GJKFF;

entity JKFF is
    port(
        j, k, clk, clrn, prn :  in  std_logic;
        q                    :  out std_logic);
end JKFF;

architecture BEHAVIOR of JKFF is

    component PRIM_GJKFF
        port(
            j, k, clk, ena, clr, pre :  in  std_logic;
            q                        :  out std_logic);
    end component;
    
signal clear         : std_logic := '0';
signal preset        : std_logic := '0';
signal one_bit       : std_logic := '1';

begin
   
    PRIM_GJKFF_INST :  PRIM_GJKFF       
        port map (
            j     => j, 
            k     => k, 
            clk   => clk,
            ena   => one_bit,
            clr   => clear,
            pre   => preset,
            q     => q );

    clear  <= not clrn;
    preset <= not prn;
    

end BEHAVIOR; -- JKFF

Library ieee;
use ieee.std_logic_1164.all;
use work.PRIM_GJKFF;

entity JKFFE is
    port(
        j, k, clk, ena, clrn, prn :  in  std_logic;
        q                         :  out std_logic);
end JKFFE;

architecture BEHAVIOR of JKFFE is

    component PRIM_GJKFF
        port(
            j, k, clk, ena, clr, pre :  in  std_logic;
            q                        :  out std_logic);
    end component;
    
signal clear         : std_logic := '0';
signal preset        : std_logic := '0';

begin
   
    PRIM_GJKFF_INST :  PRIM_GJKFF
        port map (
            j     => j, 
            k     => k, 
            clk   => clk,
            ena   => ena,
            clr   => clear,
            pre   => preset,
            q     => q );

    clear  <= not clrn;
    preset <= not prn;
    

end BEHAVIOR; -- JKFFE

Library ieee;
use ieee.std_logic_1164.all;
entity PRIM_GSRFF is
    port(
        s, r, clk, ena, clr, pre :  in  std_logic;
        q                        :  out std_logic);
end PRIM_GSRFF;

architecture BEHAVIOR of PRIM_GSRFF is

signal iq : std_logic := '0';

begin
    process (clk, clr, pre)
    begin
        if (clr =  '1') then
            iq <= '0';
        elsif (pre = '1') then
            iq <= '1';
        elsif (clk'event and (clk = '1') and (clk'last_value = '0')) then
            if (ena = '1') then
                if ((s = '1') and (r = '0')) then
                    iq <= '1';
                elsif ((s = '0') and (r = '1')) then
                    iq <= '0';
                elsif ((s = '1') and (r = '1')) then
                    iq <= not iq;
                end if;
            end if;
        end if;
    end process;

    q <= iq;

end BEHAVIOR; -- PRIM_GSRFF

Library ieee;
use ieee.std_logic_1164.all;
use work.PRIM_GSRFF;

entity SRFF is
    port(
        s, r, clk, clrn, prn :  in  std_logic;
        q                    :  out std_logic);
end SRFF;

architecture BEHAVIOR of SRFF is

    component PRIM_GSRFF
        port(
            s, r, clk, ena, clr, pre :  in  std_logic;
            q                        :  out std_logic);
    end component;
    
signal clear         : std_logic := '0';
signal preset        : std_logic := '0';
signal one_bit       : std_logic := '1';

begin
   
    PRIM_GSRFF_INST :  PRIM_GSRFF       
        port map (
            s     => s, 
            r     => r, 
            clk   => clk,
            ena   => one_bit,
            clr   => clear,
            pre   => preset,
            q     => q );

    clear  <= not clrn;
    preset <= not prn;
    

end BEHAVIOR; -- SRFF

Library ieee;
use ieee.std_logic_1164.all;
use work.PRIM_GSRFF;

entity SRFFE is
    port(
        s, r, clk, ena, clrn, prn :  in  std_logic;
        q                         :  out std_logic);
end SRFFE;

architecture BEHAVIOR of SRFFE is

    component PRIM_GSRFF
        port(
            s, r, clk, ena, clr, pre :  in  std_logic;
            q                        :  out std_logic);
    end component;
    
signal clear         : std_logic := '0';
signal preset        : std_logic := '0';

begin
   
    PRIM_GSRFF_INST :  PRIM_GSRFF
        port map (
            s     => s, 
            r     => r, 
            clk   => clk,
            ena   => ena,
            clr   => clear,
            pre   => preset,
            q     => q );

    clear  <= not clrn;
    preset <= not prn;
    

end BEHAVIOR; -- SRFFE


library ieee;
use ieee.std_logic_1164.all;

-- ENTITY DECLARATION
entity clklock is
generic(
    input_frequency       : natural := 10000;   -- units in ps
    clockboost            : natural := 1

);
port(
    inclk   : in std_logic;  -- required port, input reference clock
    outclk  : out std_logic  -- outclk output
);
end clklock;
-- END ENTITY DECLARATION

-- BEGINNING OF ARCHITECTURE BEHAVIOR
architecture behavior of clklock is

-- CONSTANT DECLARATION
constant valid_lock_cycles       : natural := 1;
constant invalid_lock_cycles     : natural := 2;

-- SIGNAL DECLARATION
SIGNAL pll_lock      : std_logic := '0';
SIGNAL check_lock    : std_logic := '0';
SIGNAL outclk_tmp    : std_logic := 'X';
begin

-- checking for invalid parameters
MSG: process
begin
    if (input_frequency <= 0) then
        ASSERT FALSE
        REPORT "The period of the input clock (input_frequency) must be greater than 0!"
        SEVERITY ERROR;
    end if;

    if ((clockboost /= 1) and (clockboost /= 2)) then
        ASSERT FALSE
        REPORT "The clock multiplication factor (clockboost) must be a value of 1 or 2!"
        SEVERITY ERROR;
    end if;

    wait;

end process MSG;

LOCK: process(inclk, pll_lock, check_lock)
    -- VARIABLE DECLARATION
    variable inclk_ps : time := 0 ps;
    variable violation : boolean := false;
    variable pll_lock_tmp : std_logic := '0';
    variable start_lock_count, stop_lock_count : integer := 0;
    variable pll_last_rising_edge, pll_last_falling_edge : time := 0 ps;
    variable pll_rising_edge_count : integer := 0;
    variable pll_cycle, pll_duty_cycle : time := 0 ps;
    variable expected_next_clk_edge : time := 0 ps;
    variable clk_per_tolerance : time := 0 ps;

    variable last_synchronizing_rising_edge_for_outclk : time := 0 ps;
    variable input_cycles_per_outclk            : integer := 1;
    variable input_cycle_count_to_sync0 : integer := 0;
    variable init : boolean := true;
    variable output_value : std_logic := '0';
    variable vco_per : time := 0 ps;
    variable high_time : time := 0 ps;
    variable low_time : time := 0 ps;
    variable sched_time : time := 0 ps;
    variable tmp_per  : integer := 0;
    variable temp, tmp_rem, my_rem : integer := 0;
    variable inc : integer := 1;
    variable cycle_to_adjust : integer := 0;
    variable outclk_synchronizing_period : time;
    variable outclk_cycles_per_sync_period      : integer := clockboost;
    variable schedule_outclk : boolean := false;
begin
    if (init) then
        outclk_cycles_per_sync_period := clockboost;
        input_cycles_per_outclk := 1;
        
        clk_per_tolerance := (0.1 * real(input_frequency)) * 1 ps;
        init := false;
    end if;

    if (inclk'event and inclk = '1') then
        if (pll_lock_tmp = '1') then
            check_lock <= not check_lock after (inclk_ps+clk_per_tolerance)/2.0;
        end if;
        if pll_rising_edge_count = 0 then      -- at 1st rising edge
            inclk_ps := (input_frequency / 1) * 1 ps;
            pll_duty_cycle := inclk_ps/2;
        elsif pll_rising_edge_count = 1 then      -- at 2nd rising edge
            pll_cycle := now - pll_last_rising_edge;    -- calculate period
            if ((NOW - pll_last_rising_edge) < (inclk_ps - clk_per_tolerance)  or
                (NOW - pll_last_rising_edge) > (inclk_ps + clk_per_tolerance)) then
                ASSERT FALSE
                REPORT "Inclock_Period Violation"
                SEVERITY WARNING;
                violation := true;
                if (pll_lock = '1') then
                    stop_lock_count := stop_lock_count + 1;
                    if (stop_lock_count = invalid_lock_cycles) then
                        pll_lock_tmp := '0';
                        ASSERT FALSE
                        REPORT "clklock out of lock."
                        SEVERITY WARNING;
                    end if;
                else
                    start_lock_count := 1;
                end if;
            else
                violation := false;
            end if;
            if ((now - pll_last_falling_edge) < (pll_duty_cycle - clk_per_tolerance/2) or
                (now - pll_last_falling_edge) > (pll_duty_cycle + clk_per_tolerance/2)) then
                ASSERT FALSE
                REPORT "Duty Cycle Violation"
                SEVERITY WARNING;
                violation := true;
            else
                violation := false;
            end if;
        else
            pll_cycle := now - pll_last_rising_edge;    -- calculate period
            if ((now - pll_last_rising_edge) < (inclk_ps - clk_per_tolerance) or
                (now - pll_last_rising_edge) > (inclk_ps + clk_per_tolerance)) then
                ASSERT FALSE
                REPORT "Cycle Violation"
                SEVERITY WARNING;
                violation := true;
                if (pll_lock = '1') then
                    stop_lock_count := stop_lock_count + 1;
                    if (stop_lock_count = invalid_lock_cycles) then
                        pll_lock_tmp := '0';
                        ASSERT FALSE
                        REPORT "clklock out of lock."
                        SEVERITY WARNING;
                    end if;
                else
                    start_lock_count := 1;
                end if;
            else
                violation := false;
            end if;
        end if;
        pll_last_rising_edge := now;
        pll_rising_edge_count := pll_rising_edge_count +1;
        if (not violation) then
            if (pll_lock_tmp = '1') then
                input_cycle_count_to_sync0 := input_cycle_count_to_sync0 + 1;
                if (input_cycle_count_to_sync0 = input_cycles_per_outclk) then
                    outclk_synchronizing_period := now - last_synchronizing_rising_edge_for_outclk;
                    last_synchronizing_rising_edge_for_outclk := now;
                    schedule_outclk := true;
                    input_cycle_count_to_sync0 := 0;
                end if;
            else
                start_lock_count := start_lock_count + 1;
                if (start_lock_count >= valid_lock_cycles) then
                    pll_lock_tmp := '1';
                    input_cycle_count_to_sync0 := 0;
                    outclk_synchronizing_period := ((pll_cycle/1 ps) * input_cycles_per_outclk) * 1 ps;
                    last_synchronizing_rising_edge_for_outclk := now;
                    schedule_outclk := true;
                end if;
            end if;
        else
            start_lock_count := 1;
        end if;

    elsif (inclk'event and inclk= '0') then
        if (pll_lock_tmp = '1') then
            check_lock <= not check_lock after (inclk_ps+clk_per_tolerance)/2.0;
            if (now > 0 ns and ((now - pll_last_rising_edge) < (pll_duty_cycle - clk_per_tolerance/2) or
                (now - pll_last_rising_edge) > (pll_duty_cycle + clk_per_tolerance/2))) then
                ASSERT FALSE
                REPORT "Duty Cycle Violation"
                SEVERITY WARNING;
                violation := true;
                if (pll_lock = '1') then
                    stop_lock_count := stop_lock_count + 1;
                    if (stop_lock_count = invalid_lock_cycles) then
                        pll_lock_tmp := '0';
                        ASSERT FALSE
                        REPORT "clklock out of lock."
                        SEVERITY WARNING;
                    end if;
                end if;
            else
                violation := false;
            end if;
        else
            start_lock_count := start_lock_count + 1;
        end if;
        pll_last_falling_edge := now;
    else
        if pll_lock_tmp = '1' then
            if (inclk = '1') then
                expected_next_clk_edge := pll_last_rising_edge + (inclk_ps+clk_per_tolerance)/2.0;
            else
                expected_next_clk_edge := pll_last_falling_edge + (inclk_ps+clk_per_tolerance)/2.0;
            end if;
            violation := false;
            if (now < expected_next_clk_edge) then
                check_lock <= not check_lock after (expected_next_clk_edge - now);
            elsif (now = expected_next_clk_edge) then
                check_lock <= not check_lock after (inclk_ps+clk_per_tolerance)/2.0;
            else
                ASSERT FALSE
                REPORT "Inclock_Period Violation"
                SEVERITY WARNING;
                violation := true;
                if (pll_lock = '1') then
                    stop_lock_count := stop_lock_count + 1;
                    if (stop_lock_count = invalid_lock_cycles) then
                        pll_lock_tmp := '0';
                        ASSERT FALSE
                        REPORT "clklock out of lock."
                        SEVERITY WARNING;
                    else
                        check_lock <= not check_lock after (inclk_ps/2.0);
                    end if;
                end if;
            end if;
        end if;
    end if;
    pll_lock <= pll_lock_tmp;
    if (pll_lock'event and pll_lock = '0') then
        start_lock_count := 1;
        stop_lock_count := 0;
        outclk_tmp <= 'X';
    end if;

    -- outclk output
    if (schedule_outclk = true) then
        -- initialize variables
        sched_time := 0 ps;
        cycle_to_adjust := 0;
        inc := 1;
        output_value := '1';
        temp := outclk_synchronizing_period / 1 ps;
        my_rem := temp rem outclk_cycles_per_sync_period;

        -- schedule <outclk_cycles_per_sync_period> number of output clock
        -- cycles in this loop in order to synchronize the output clock to the
        -- input clock - to get rid of drifting for cases where the input clock
        -- period is not always divisible
        for i in 1 to outclk_cycles_per_sync_period loop
            tmp_per := temp/outclk_cycles_per_sync_period;
            if ((my_rem /= 0) and (inc <= my_rem)) then
                tmp_rem := (outclk_cycles_per_sync_period * inc) rem my_rem;
                cycle_to_adjust := (outclk_cycles_per_sync_period * inc) / my_rem;
                if (tmp_rem /= 0) then
                    cycle_to_adjust := cycle_to_adjust + 1;
                end if;
            end if;

            -- if this cycle is the one to adjust the output period in, then
            -- increment the period by 1 unit
            if (cycle_to_adjust = i) then
                tmp_per := tmp_per + 1;
                inc := inc + 1;
            end if;

            -- adjust the high and low cycle period
            vco_per := tmp_per * 1 ps;
            high_time := (tmp_per / 2) * 1 ps;
            if ((tmp_per rem 2) /= 0) then
                high_time := high_time + 1 ps;
            end if;

            low_time := vco_per - high_time;

            -- schedule the high and low cycle of 1 output clock period
            for j in 1 to 2 loop
                outclk_tmp <= transport output_value after sched_time;
                output_value := not output_value;
                if (output_value = '0') then
                    sched_time := sched_time + high_time;
                elsif (output_value = '1') then
                    sched_time := sched_time + low_time;
                end if;
            end loop;
        end loop;

        -- reset schedule_outclk
        schedule_outclk := false;
    end if; -- schedule_outclk
end process LOCK;

    outclk <= outclk_tmp;

end behavior;
-- END ARCHITECTURE BEHAVIOR


Library ieee;
use ieee.std_logic_1164.all;
entity alt_inbuf is
    generic(
        io_standard           : string := "";
        location              : string := "";
        enable_bus_hold       : string := "";
        weak_pull_up_resistor : string := ""; 
        termination           : string := "" );
    port(
        i : in  std_logic;
        o : out std_logic);
end alt_inbuf;
architecture BEHAVIOR of alt_inbuf is
begin
    o <= i;
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity alt_outbuf is
    generic(
        io_standard           : string := "";
        current_strength_new  : string := "";
        slow_slew_rate        : string := "";
        location              : string := "";
        enable_bus_hold       : string := "";
        weak_pull_up_resistor : string := ""; 
        termination           : string := "" );
    port(
        i : in  std_logic;
        o : out std_logic);
end alt_outbuf;
architecture BEHAVIOR of alt_outbuf is
begin
    o <= i;
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity alt_outbuf_tri is
    generic(
        io_standard           : string := "";
        current_strength_new  : string := "";
        slow_slew_rate        : string := "";
        location              : string := "";
        enable_bus_hold       : string := "";
        weak_pull_up_resistor : string := "";
        termination           : string := "" );
    port(
        i  : in  std_logic;
        oe : in  std_logic;
        o  : out std_logic);
end alt_outbuf_tri;
architecture BEHAVIOR of alt_outbuf_tri is
begin
    o <= i when oe = '1'
        else 'Z';
end BEHAVIOR;

Library ieee;
use ieee.std_logic_1164.all;
entity alt_iobuf is
    generic(
        io_standard           : string := "";
        current_strength_new  : string := "";
        slow_slew_rate        : string := "";
        location              : string := "";
        enable_bus_hold       : string := "";
        weak_pull_up_resistor : string := "";
        termination           : string := "" );
    port(
        i  : in    std_logic;
        oe : in    std_logic;
        io : inout std_logic;
        o  : out   std_logic);
end alt_iobuf;
architecture BEHAVIOR of alt_iobuf is
begin
    process(i, io, oe)
    begin
        if oe = '1' then
            io <= i;
        else
            io <= 'Z';
        end if;
        o <= io;
    end process;
end BEHAVIOR;

