-----------------------------------------------------------------------------
--                                                                         --
-- Copyright (c) 1994 by Altera Corp.  All rights reserved.                --
--                                                                         --
--                                                                         --
--  Description:  Package file for Altera macro functions and primitives   --
--                                                                         --
--                                                                         --
--                                                                         --
------------------------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_signed.all;

package maxplus2 is
    component A_81MUX
        port (A, B, C, GN : in STD_LOGIC;
              D0, D1, D2, D3, D4, D5, D6, D7 : in STD_LOGIC;
              Y, WN : out STD_LOGIC);
    end component;

    component A_8COUNT
        port (A, B, C, D, E, F, G, H : in STD_LOGIC;
              LDN, GN, DNUP, SETN, CLRN, CLK: in STD_LOGIC;
              QA, QB, QC, QD, QE, QF, QG, QH, COUT : out STD_LOGIC);
    end component;

    component A_8FADD
        port (A8, A7, A6, A5, A4, A3, A2, A1 : in STD_LOGIC;
              B8, B7, B6, B5, B4, B3, B2, B1 : in STD_LOGIC;
              CIN : in STD_LOGIC;
              SUM8, SUM7, SUM6, SUM5, SUM4, SUM3, SUM2, SUM1, COUT : out STD_LOGIC);

    end component;

    component A_8MCOMP
        port (A7, A6, A5, A4, A3, A2, A1, A0 : in STD_LOGIC;
              B7, B6, B5, B4, B3, B2, B1, B0 : in STD_LOGIC;
              ALTB, AEQB, AGTB : out STD_LOGIC;
              AEB7, AEB6, AEB5, AEB4, AEB3, AEB2, AEB1, AEB0 : out STD_LOGIC);
    end component;

    component CARRY
        port (A : in STD_LOGIC;
              Q : out STD_LOGIC);
    end component;
 
    component CASCADE
        port (A : in STD_LOGIC;
              Q : out STD_LOGIC);
    end component;

    component LCELL
        port (A : in STD_LOGIC;
              Q : out STD_LOGIC);
    end component;

    component MCELL
        port (A : in STD_LOGIC;
              Q : out STD_LOGIC);
    end component;

    component SOFT
        port (A : in STD_LOGIC;
              Q : out STD_LOGIC);
    end component;

    component GLOBAL
        port (A : in STD_LOGIC;
              Q : out STD_LOGIC);
    end component;

    component SCLK
        port (A : in STD_LOGIC;
              Q : out STD_LOGIC);
    end component;

    component EXP
        port (A : in STD_LOGIC;
              Q : out STD_LOGIC);
    end component;

    component CLKLOCK
        port (INCLK : in STD_LOGIC;
              OUTCLK : out STD_LOGIC);
    end component;

    component OPNDRN
        port (IN1 : in STD_LOGIC;
              Y : out STD_LOGIC);
    end component;

end maxplus2;
