--
--Copyright (c) 1996 by Altera Corporation.  All rights reserved.  This text
--contains proprietary, confidential information of Altera Corporation, and
--may be used, copied, and/or disclosed only pursuant to the terms of a
--valid software license agreement with Altera Corporation.  This copyright
--notice must be retained as part of this text at all times.
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_signed.all;

entity A_8COUNT is
	port (A, B, C, D, E, F, G, H : in std_logic;
	      LDN, GN, DNUP, SETN, CLRN, CLK: in std_logic;
	      QA, QB, QC, QD, QE, QF, QG, QH, COUT : out std_logic);
end A_8COUNT;

architecture BEHAVIOR of A_8COUNT is
        constant SIZE : integer := 7;
        constant ONE : std_logic_vector(SIZE downto 0) := "00000001";
        signal QBUS : std_logic_vector(SIZE downto 0);
	signal tmp : std_logic_vector(SIZE downto 0);
        signal ASYN: std_logic;
        signal ASYN_VAL: std_logic_vector(SIZE downto 0);

begin
        process (SETN, CLRN, H, G, F, E, D, C, B, A)
        begin
            if (CLRN = '0') and (SETN = '1') then
                 ASYN_VAL <= "00000000";
            elsif (CLRN = '1') and (SETN = '0') then
                 ASYN_VAL <= (H&G&F&E&D&C&B&A);
            end if;

        end process;

        ASYN <= CLRN AND SETN;
             
  	process (CLK,ASYN,ASYN_VAL)
	begin
		if (ASYN = '0') then
                       tmp <= ASYN_VAL;
		elsif (CLK'event and CLK = '1') then
		   if LDN = '0' then
			tmp <= (H&G&F&E&D&C&B&A);
		   elsif DNUP = '1' and GN = '0' then
		   	tmp <= tmp - ONE;
		   elsif DNUP = '0' and GN = '0' then
		   	tmp <= tmp + ONE;
		   end if;
		end if;
	end process;

             COUT <= ((not DNUP) and (not GN) and LDN and tmp(0) and tmp(1)
                     and tmp(2) and tmp(3) and tmp(4) and tmp(5) and tmp(6)
                     and tmp(7))    or
                     (DNUP and (not GN) and LDN and ((not tmp(0)) and
                     (not tmp(1)) and (not tmp(2)) and (not tmp(3)) and
                     (not tmp(4)) and (not tmp(5)) and (not tmp(6)) and
                     (not tmp(7))));


	QBUS <= tmp;

        QA <= QBUS(0); 
        QB <= QBUS(1);
        QC <= QBUS(2);
        QD <= QBUS(3);
        QE <= QBUS(4);
        QF <= QBUS(5);
        QG <= QBUS(6);
        QH <= QBUS(7);
end BEHAVIOR;
