library pack1076;
use pack1076.pack1076.all;


entity LPMADD8 is port (
   signal DataA, DataB: in vlbit_vector (7 downto 0);
   signal Cin: in vlbit;
   signal Sum: out vlbit_vector (7 downto 0));
end LPMADD8;

architecture lpm of LPMADD8 is
   signal int_s: vlbit_vector (9 downto 0);
   signal int_b: vlbit_vector (7 downto 0);
   signal int_cin: vlbit;

begin

   -- Set up internal copies of input signals
   int_b <= DataB;
   int_cin <= Cin;
   
   -- Add
   int_s <= addum (DataA & int_cin, int_b & int_cin);

   -- Connect internal outputs to outputs with delay
   Sum <= int_s (8 downto 1) after 0 ns;

end lpm;
