-------------------------------------------------------------- 
--                                                          --
--    Copyright 1993 Altera Corporation                     --
--    VHDL example for macrocell instantiation              --
--    Description : Example for macro cell                  --
--                  8 bit counter and clklock               --
--                                                          --
--------------------------------------------------------------
LIBRARY ieee;
USE ieee.std_logic_1164.all;

library synth;
use synth.stdsynth.all;

LIBRARY alt_mf;
USE alt_mf.maxplus2.all;


ENTITY COUNT8 IS
        PORT (
              clk  : IN STD_LOGIC;
              clrn : IN STD_LOGIC;
              ldn  : IN STD_LOGIC;
              gn   : IN STD_LOGIC;
              dnup : IN STD_LOGIC;
              setn : IN STD_LOGIC;
              a    : IN STD_LOGIC_VECTOR(7 DOWNTO 0);
              Q    : OUT STD_LOGIC_VECTOR(7 DOWNTO 0);
              co   : OUT STD_LOGIC);
end COUNT8;

ARCHITECTURE behavior OF COUNT8 IS
     signal clk2x : STD_LOGIC;

   component clklock_2_50
        port (
             INCLK : IN STD_LOGIC;
             OUTCLK : OUT STD_LOGIC
        );
   end component;

   component A_8COUNT
       port (A, B, C, D, E, F, G, H : in STD_LOGIC;
              LDN, GN, DNUP, SETN, CLRN, CLK: in STD_LOGIC;
              QA, QB, QC, QD, QE, QF, QG, QH, COUT : out STD_LOGIC);
   end component;

for all : clklock_2_50 use entity work.clklock_2_50 (behavior);
for all : a_8count use entity alt_mf.a_8count (behavior);

BEGIN

        u1: clklock_2_50
        PORT MAP ( inclk=>clk, outclk=>clk2x);
 
        u2: a_8count
        PORT MAP ( a=>a(0), b=>a(1), c=>a(2), d=>a(3),
                   e=>a(4), f=>a(5), g=>a(6), h=>a(7),
                   clk=>clk2x,
                   ldn=>ldn,
                   gn=>gn,
                   dnup=>dnup,
                   setn=>setn,
                   clrn=>clrn,
                   qa=>q(0), qb=>q(1), qc=>q(2), qd=>q(3),
                   qe=>q(4), qf=>q(5), qg=>q(6), qh=>q(7),
                   cout=>co);
 
END behavior;

