--------------------------------------------------------------
--                                                          --
--    Copyright 1993 Altera Corporation                     --
--    VHDL example for 4 bit counter                        --
--    Description : 4 bit counter.                          --
--                                                          --
--------------------------------------------------------------
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_signed.all;

entity COUNT4 is
	port(CLK, RST, ENABLE, LOAD : in std_logic;
             DATA: INOUT std_logic_vector (3 downto 0));

end COUNT4;

architecture MAXPLUS of COUNT4 is
        constant ONE : std_logic := '1';
        signal COUNT : std_logic_vector(4 downto 0);
begin

	CNT: process(RST, CLK)
		begin
                    if rst = '1' then
                          COUNT <= "00000";
                    elsif (CLK'event and (CLK = '1')) then
                        if (LOAD = '1') then
                           COUNT(3 downto 0) <= DATA;
                        else
                           COUNT <= COUNT + ONE;
                        end if;
                     end if;

	end process CNT;

         DATA <= COUNT(3 downto 0) WHEN (ENABLE = '1') else "ZZZZ";

end MAXPLUS;
