// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


///////////////////////////////////////////////////////////////////////////////
// STRATIXII IO atom for Formal Verification
///////////////////////////////////////////////////////////////////////////////


// MODEL BEGIN
module stratixii_io (
// INTERFACE BEGIN
       datain,                  // data in
       ddiodatain,              // ddio data in
       oe,                      // output enable
       outclk,                  // output register clock
       inclk,                   // input register clock
       outclkena,               // output register clock enable
       inclkena,                // input register clock enable
       areset,                  // asynchronous set/reset source
       sreset,                  // synchronous set/reset source
       ddioinclk,		// negative edge DDIO input register clock
       delayctrlin, 		// DQS delay setting source
       offsetctrlin, 		// DQS delay offset source
       dqsupdateen, 		// DQS update enable source
       linkin, 			// linkin source
       terminationcontrol, 	// control bus
       combout,                 // combinational output
       regout,                  // registered output
       ddioregout,              // ddio registered output
       dqsbusout,		// Delayed DQS bus output
       dftdelayctrlout,		// DQS delay setting output
       linkout,			// linkout output
       padio,                   // pad I/O source/output
       dffdataout,              // internal output register
       dffoe,           	// internal output enable register
       dffddiodataout,          // internal ddio output register 
       dffddiooe,               // internal ddio output enable register
       dffddiodatain            // internal ddio input register
// INTERFACE END
);
////  default parameters ////
parameter operation_mode = "unused";
parameter ddio_mode = "none";
parameter open_drain_output = "false";
parameter bus_hold = "false";


parameter output_register_mode = "none";
parameter output_async_reset = "none";
parameter output_power_up = "low";
parameter output_sync_reset = "none";

parameter tie_off_output_clock_enable = "false";
parameter oe_register_mode = "none";
parameter oe_async_reset = "none";
parameter oe_power_up = "low";
parameter oe_sync_reset = "none";
parameter tie_off_oe_clock_enable = "false";

parameter input_register_mode = "none";
parameter input_async_reset = "none";
parameter input_power_up = "low";
parameter input_sync_reset = "none";
parameter extend_oe_disable = "false";

parameter dqs_input_frequency = "unused";
parameter dqs_out_mode = "none";
parameter dqs_delay_buffer_mode = "none";
parameter dqs_phase_shift = 0;
parameter inclk_input = "normal";
parameter ddioinclk_input = "negated_inclk";
parameter dqs_offsetctrl_enable = "false";
parameter dqs_ctrl_latches_enable = "false";
parameter dqs_edge_detect_enable = "false";
parameter gated_dqs = "false";

parameter dqs_delay_setting_ctrl = "0"; // ** CHECK actual param name and def val
parameter lpm_type = "stratixii_io";

parameter sim_dqs_delay_increment = 0;
parameter sim_dqs_intrinsic_delay = 0;
parameter sim_dqs_offset_increment = 0;

//// port declarations ////

input  datain,ddiodatain,oe,inclk,inclkena,outclk,outclkena,areset,sreset;
input  ddioinclk;
input [5:0] delayctrlin;
input [5:0] offsetctrlin;
input  dqsupdateen, linkin;
input [13:0] terminationcontrol;
output combout,regout,ddioregout,dqsbusout,dftdelayctrlout,linkout;
output dffdataout,dffddiodataout,dffoe,dffddiooe,dffddiodatain;
inout  padio;

//// nets/registers ////

wire oe_delayed,oe_actual;

wire enreg_clken,ireg_clken,oreg_clken;                 // clock enables

wire enreg_clr,ireg_clr,oreg_clr;                       // i/o/en aclr
wire enreg_pre,ireg_pre,oreg_pre;                       // i/o/en apre
wire enreg_sclr,ireg_sclr,oreg_sclr;                    // i/o/en sclr
wire enreg_spre,ireg_spre,oreg_spre;                    // i/o/en spre

wire ireg_in,oreg_in,enreg_in,enpsreg_in;               // i/o/en(ps) reg inputs
wire idreg_in,idregn_in,odreg_in;                       // ddio reg inputs
wire ddioinclk_actual;		// select between ddioinclk and dqs#_bus
reg  tristate_in,tristate_out;
wire ireg_out,oreg_out,enreg_out,enpsreg_out;           // i/o/en(ps) reg outputs
wire idreg_out,idregn_out,odreg_out;                    // ddio reg outputs

reg  ddio_data;

// IMPLEMENTATION BEGIN
/////////////////////////////////// asynchronous logic /////////////////////////////////////
//////////// tristate logic ///////////////////////////////////////
always @(tristate_in or oe_delayed)
begin
    if (open_drain_output == "true")
      begin
        if (oe_delayed == 1'b1)
           tristate_out = (tristate_in == 1'b0) ? 1'b0 : 1'bz;
        else
           tristate_out = 1'bz;
      end
    else
      tristate_out = (oe_delayed == 1'b1) ? tristate_in : 1'bz;
end
//////////// remainder combinational logic /////////////////////////

// ***** tristate input ****** //

always @(datain or oreg_out or ddio_data)
begin
     if ((ddio_mode == "output") || (ddio_mode == "bidir"))
         tristate_in = ddio_data;
     else
         tristate_in = (output_register_mode == "register") ? oreg_out : datain;
end

// ***** ddio data      ****** //
// mux with clock select for ddio output
always @(odreg_out or oreg_out or outclk)
begin
     ddio_data = (outclk == 1'b1) ? oreg_out : odreg_out;
end

/////////////// net assignments ///////////////////////

assign oe_actual  = (operation_mode == "input") ? 1'b0 : oe;
assign oe_delayed = (oe_register_mode == "register") 
                    ? (extend_oe_disable == "true")
                      ? enpsreg_out && enreg_out 
                      : enreg_out
                    : oe_actual;

assign ireg_clr   = (input_async_reset == "clear")   ? !areset : 1'b1;                 // i/o/en reg aclr/apre
assign ireg_pre   = (input_async_reset == "preset")  ? !areset : 1'b1;
assign oreg_clr   = (output_async_reset == "clear")  ? !areset : 1'b1;
assign oreg_pre   = (output_async_reset == "preset") ? !areset : 1'b1;
assign enreg_clr  = (oe_async_reset == "clear")      ? !areset : 1'b1;
assign enreg_pre  = (oe_async_reset == "preset")     ? !areset : 1'b1;

assign ireg_sclr   = (input_sync_reset == "clear")   ? !sreset : 1'b1;                 // i/o/en reg sclr/spre
assign ireg_spre   = (input_sync_reset == "preset")  ? !sreset : 1'b1;
assign oreg_sclr   = (output_sync_reset == "clear")  ? !sreset : 1'b1;
assign oreg_spre   = (output_sync_reset == "preset") ? !sreset : 1'b1;
assign enreg_sclr  = (oe_sync_reset == "clear")      ? !sreset : 1'b1;
assign enreg_spre  = (oe_sync_reset == "preset")     ? !sreset : 1'b1;

assign enreg_clken= (tie_off_oe_clock_enable == "false")     ? outclkena : 1'b1,
       oreg_clken = (tie_off_output_clock_enable == "false") ? outclkena : 1'b1,
       ireg_clken = inclkena;

assign combout    = padio;
assign regout     = (input_register_mode == "register") ? ireg_out : 1'bz;
assign ddioregout = idreg_out;

assign ireg_in    = padio,                                                       // i/o/en(ps) reg inputs
         oreg_in  = datain, 
            enreg_in = oe_actual, enpsreg_in = enreg_out,  
         odreg_in = ddiodatain,                                                  // ddio reg inputs      
       idreg_in   = idregn_out , idregn_in = padio; 

assign padio      = tristate_out; 

assign dffoe     = enreg_out;
assign dffddiodataout = odreg_out;
assign dffdataout = oreg_out;

/////////////////////////////////// synchronous logic ///////////////////////////////////


// Output enable register (enreg)

generate 
if (oe_register_mode != "none")
begin

stratix_io_register enreg (
	.clk(outclk),.clken(enreg_clken),
	.clr(enreg_clr),.pre(enreg_pre),
	.sclr(enreg_sclr),.spre(enreg_spre),
	.reg_in(enreg_in),.reg_out(enreg_out)
	);

end
endgenerate

// Output enable pulse register (enpsreg)

generate
if ((oe_register_mode != "none") && (extend_oe_disable == "true"))
begin

stratix_io_register enpsreg (
        .clk(!outclk),.clken(enreg_clken),
        .clr(enreg_clr),.pre(enreg_pre),
        .sclr(enreg_sclr),.spre(enreg_spre),
        .reg_in(enpsreg_in),.reg_out(enpsreg_out)
        );

end
endgenerate

// Input register (ireg)

generate
if (input_register_mode != "none")
begin

stratix_io_register ireg (
        .clk(inclk),.clken(ireg_clken),
        .clr(ireg_clr),.pre(ireg_pre),
        .sclr(ireg_sclr),.spre(ireg_spre),
        .reg_in(ireg_in),.reg_out(ireg_out)
        );

end
endgenerate

// Output register (oreg)

generate
if (output_register_mode != "none")
begin

stratix_io_register oreg (
        .clk(outclk),.clken(oreg_clken),
        .clr(oreg_clr),.pre(oreg_pre),
        .sclr(oreg_sclr),.spre(oreg_spre),
        .reg_in(oreg_in),.reg_out(oreg_out)
        );

end
endgenerate

// DDIO input register (idregn)

generate
if ((ddio_mode == "input") || (ddio_mode == "bidir"))
begin
assign ddioinclk_actual = (ddioinclk_input == "negated_inclk")? 
				(!inclk) : ddioinclk;
stratix_io_register  idregn (
        .clk(ddioinclk_actual),.clken(ireg_clken),
        .clr(ireg_clr),.pre(ireg_pre),
        .sclr(ireg_sclr),.spre(ireg_spre),
        .reg_in(idregn_in),.reg_out(idregn_out)
        );

end
endgenerate

// DDIO input register (idreg)

generate
if ((ddio_mode == "input") || (ddio_mode == "bidir"))
begin

stratix_io_register idreg (
        .clk(inclk),.clken(ireg_clken),
        .clr(ireg_clr),.pre(ireg_pre),
        .sclr(ireg_sclr),.spre(ireg_spre),
        .reg_in(idreg_in),.reg_out(idreg_out)
        );

end
endgenerate

// DDIO output register (odreg)

generate
if ((ddio_mode == "output") || (ddio_mode == "bidir"))
begin

stratix_io_register odreg (
        .clk(outclk),.clken(oreg_clken),
        .clr(oreg_clr),.pre(oreg_pre),
        .sclr(oreg_sclr),.spre(oreg_spre),
        .reg_in(odreg_in),.reg_out(odreg_out)
        );

end
endgenerate

// IMPLEMENTATION END
endmodule
// MODEL END
