// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////// STRATIXGX MAC UDP REGISTER  for Formal Verification ///////////////////
//////////////////////////////////////////////////////////////////////////////////////////
// MODEL BEGIN
module stratixgx_mac_udp_register (
// INTERFACE BEGIN
	clk,aclr,clken,
	reg_in,
	reg_out
);
// INTERFACE END
//// default parameters ////

parameter width = 8;

//// constants ////
//// variables ////

//// port declarations ////

input  clk,aclr,clken;
input  [ width - 1 : 0 ] reg_in;
output [ width - 1 : 0 ] reg_out;

//// pullups/pulldowns ////
//// nets/registers ////

// IMPLEMENTATION BEGIN


// IMPLEMENTATION BEGIN

generate
if( width == 1 ) begin
	wire feedback;
	wire d_w;
	assign reg_out[0] = feedback;
	assign d_w = clken ? reg_in[0] : feedback;
	dffp reg_prim_inst (feedback,clk,d_w,1'b0,aclr);
end
else begin
	wire [width-1:0] feedback;
	wire [width-1:0] d_w;
	assign reg_out = feedback;
	assign d_w = clken ? reg_in : feedback;
	dffp reg_prim_inst[width-1:0] (feedback,clk,d_w,1'b0,aclr);
end
endgenerate

// IMPLEMENTATION END
endmodule
// MODEL END

