// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////// STRATIXGX LCELL REGISTER  for Formal Verification /////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
// MODEL BEGIN
module stratixgx_lcell_register (
// INTERFACE BEGIN
	clk,ena,
	aclr,aload,sclr,sload,
	datac,
	regin,
	regout
);
// INTERFACE END
//// default parameters ////

parameter sum_lutc_input               = "datac";
parameter output_mode                  = "reg_and_comb";
parameter synch_mode                   = "on";

//// constants ////
//// variables ////

//// port declarations ////

input  clk,ena;
input  aclr,aload,sclr,sload;
input  datac,regin;
output regout;

//// pullups/pulldowns ////
//// nets/registers ////

wire   actual_regin;
wire arst_w;
wire aset_w;
wire d_w;
wire inv_aclr;

assign actual_regin = (synch_mode == "on") ? (
				sclr ? 1'b0 : ( sload ? datac : regin )
			        ) : regin;

assign inv_aclr = ~ aclr;
assign aset_w = inv_aclr & aload & datac;
assign arst_w = aclr | inv_aclr & aload & (~datac);
assign d_w = ena ? actual_regin : regout;

// IMPLEMENTATION BEGIN

dffp reg_prim_inst (regout,clk,d_w,aset_w,arst_w);

// IMPLEMENTATION END

endmodule
// MODEL END
