// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////// STRATIX_MAC_MULT for Formal Verification ////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
// MODEL BEGIN

`define MULTIPLICAND_DEFAULT_WIDTH 18
`define MULTIPLIER_DEFAULT_WIDTH   18

module stratix_mac_mult (
// INTERFACE BEGIN
	dataa,
	datab,
	signa,
	signb,
	clk,aclr,ena,
	dataout,
	scanouta,
	scanoutb
);
// INTERFACE END
//// default parameters ////

parameter dataa_width = 1;
parameter datab_width = 1;

// Local parameters
parameter max_width = ( dataa_width >= datab_width ) ? dataa_width :
	datab_width;

`ifdef MULT_NORMALIZE_SIZE
parameter normalized_width = ( max_width <= 9 ) ? 9 :
	( ( max_width <= 18 ) ? 18 : max_width );
`else
parameter normalized_width = 1;
`endif

parameter dataa_clock = "none";
parameter datab_clock = "none";
parameter dataa_clear = "none";
parameter datab_clear = "none";

parameter signa_clock = "none";
parameter signb_clock = "none";
parameter signa_clear = "none";
parameter signb_clear = "none";
parameter signa_internally_grounded = "false";
parameter signb_internally_grounded = "false";

parameter output_clock = "none";
parameter output_clear = "none";

parameter lpm_hint = "true";
parameter lpm_type = "stratix_mac_mult";

//// constants ////
//// variables ////

//// port declarations ////

input  [ dataa_width - 1 : 0 ] dataa;
input  [ datab_width - 1 : 0 ] datab;

input  signa, signb;
input  [3:0] clk, ena, aclr;

output [dataa_width - 1 : 0] scanouta;
output [datab_width - 1 : 0] scanoutb;
output [dataa_width + datab_width - 1 : 0] dataout;

//// nets/registers ////

wire [ dataa_width - 1 : 0 ] dataa_reg;
wire [ dataa_width - 1 : 0 ] mult_a_reg;
wire [ datab_width - 1 : 0 ] datab_reg;
wire [ datab_width - 1 : 0 ] mult_b_reg;

wire signa_reg, signb_reg;
wire signa_in_reg, signb_in_reg;

wire [ dataa_width + datab_width - 1 : 0 ] mult_in_reg;
wire [ dataa_width + datab_width - 1 : 0 ] mult_reg;
wire [ dataa_width + datab_width - 1 : 0 ] out;

wire clock_a, clock_b;         // A/B input clocks
wire clear_a, clear_b;         // A/B input clears
wire ena_a, ena_b;             // A/B input clock enables

wire clock_signa, clock_signb; // A/B sign clocks
wire clear_signa, clear_signb; // A/B sign clears
wire ena_signa, ena_signb;     // A/B sign clock enables

wire clock_out;                // Output clock
wire clear_out;                // Output clear
wire ena_out;                  // Output clock enable

// IMPLEMENTATION BEGIN

//////////////////////////// asynchronous logic ////////////////////////////

assign clock_signa = ( signa_clock == "0" ? clk[0] :
			( signa_clock == "1" ? clk[1] : 
				( signa_clock == "2" ? clk[2] :
					( signa_clock == "3" ? clk[3] : clk[0] ))));

assign clock_signb = ( signb_clock == "0" ? clk[0] :
			( signb_clock == "1" ? clk[1] : 
				( signb_clock == "2" ? clk[2] :
					( signb_clock == "3" ? clk[3] : clk[0] ))));

assign clear_signa = ( signa_clear == "0" ? aclr[0] :
			( signa_clear == "1" ? aclr[1] : 
				( signa_clear == "2" ? aclr[2] :
					( signa_clear == "3" ? aclr[3] : 
					( signa_clear == "none" ? 1'b0 : aclr[0] )))));

assign clear_signb = ( signb_clear == "0" ? aclr[0] :
			( signb_clear == "1" ? aclr[1] : 
				( signb_clear == "2" ? aclr[2] :
					( signb_clear == "3" ? aclr[3] : 
					( signb_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_signa   = ( signa_clock == "0" ? ena[0] :
			( signa_clock == "1" ? ena[1] : 
				( signa_clock == "2" ? ena[2] :
					( signa_clock == "3" ? ena[3] : ena[0] ))));

assign ena_signb   = ( signb_clock == "0" ? ena[0] :
			( signb_clock == "1" ? ena[1] : 
				( signb_clock == "2" ? ena[2] :
					( signb_clock == "3" ? ena[3] : ena[0] ))));

assign clock_a = ( dataa_clock == "0" ? clk[0] :
			( dataa_clock == "1" ? clk[1] : 
				( dataa_clock == "2" ? clk[2] :
					( dataa_clock == "3" ? clk[3] : clk[0] ))));

assign clock_b = ( datab_clock == "0" ? clk[0] :
			( datab_clock == "1" ? clk[1] : 
				( datab_clock == "2" ? clk[2] :
					( datab_clock == "3" ? clk[3] : clk[0] ))));

assign clear_a = ( dataa_clear == "0" ? aclr[0] :
			( dataa_clear == "1" ? aclr[1] : 
				( dataa_clear == "2" ? aclr[2] :
					( dataa_clear == "3" ? aclr[3] : 
					( dataa_clear == "none" ? 1'b0 : aclr[0] )))));

assign clear_b = ( datab_clear == "0" ? aclr[0] :
			( datab_clear == "1" ? aclr[1] : 
				( datab_clear == "2" ? aclr[2] :
					( datab_clear == "3" ? aclr[3] :
					( dataa_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_a = ( dataa_clock == "0" ? ena[0] :
			( dataa_clock == "1" ? ena[1] : 
				( dataa_clock == "2" ? ena[2] :
					( dataa_clock == "3" ? ena[3] : ena[0] ))));

assign ena_b = ( datab_clock == "0" ? ena[0] :
			( datab_clock == "1" ? ena[1] : 
				( datab_clock == "2" ? ena[2] :
					( datab_clock == "3" ? ena[3] : ena[0] ))));

assign clock_out = ( output_clock == "0" ? clk[0] :
                        ( output_clock == "1" ? clk[1] :
                                ( output_clock == "2" ? clk[2] :
                                        ( output_clock == "3" ? clk[3] : clk[0] ))));

assign ena_out = ( output_clock == "0" ? ena[0] :
                        ( output_clock == "1" ? ena[1] :
                                ( output_clock == "2" ? ena[2] :
                                        ( output_clock == "3" ? ena[3] : ena[0] ))));

assign clear_out = ( output_clear == "0" ? aclr[0] :
                        ( output_clear == "1" ? aclr[1] :
                                ( output_clear == "2" ? aclr[2] :
                                        ( output_clear == "3" ? aclr[3] :
                                        ( output_clear == "none" ? 1'b0 : aclr[0] )))));

//////////////////////////// synchronous logic /////////////////////////////

// A input register

generate
begin
if (dataa_clock != "none")

stratix_mac_udp_register #(dataa_width) dataa_reg_inst (
        .clk(clock_a),
        .aclr(clear_a),
        .clken(ena_a),
        .reg_in(dataa),
        .reg_out(mult_a_reg)
);

end
endgenerate
assign dataa_reg = (dataa_clock == "none") ? dataa : mult_a_reg;

// B input register
generate
begin
if (datab_clock != "none")
stratix_mac_udp_register #(datab_width) datab_reg_inst (
        .clk(clock_b),
        .aclr(clear_b),
        .clken(ena_b),
        .reg_in(datab),
        .reg_out(mult_b_reg)
);

end
endgenerate

assign datab_reg = (datab_clock == "none") ? datab : mult_b_reg;

// signa register

generate

if (signa_clock != "none")
begin

stratix_mac_udp_register #(1) signa_reg_inst (
        .clk(clock_signa),
        .aclr(clear_signa),
        .clken(ena_signa),
        .reg_in(signa),
        .reg_out(signa_in_reg)
);

end
endgenerate

assign signa_reg = (signa_internally_grounded == "true") ? 1'b0 : 
			((signa_clock != "none") ? signa_in_reg : signa);

// signb register

generate

if (signb_clock != "none")
begin


stratix_mac_udp_register #(1) signb_reg_inst (
        .clk(clock_signb),
        .aclr(clear_signb),
        .clken(ena_signb),
        .reg_in(signb),
        .reg_out(signb_in_reg)
);

end
endgenerate

assign signb_reg = (signb_internally_grounded == "true") ? 1'b0 : 
			((signb_clock != "none") ? signb_in_reg : signb);


// output register

generate
if (output_clock != "none")
begin

stratix_mac_udp_register #(dataa_width + datab_width) mult_reg_inst (
        .clk(clock_out),
        .aclr(clear_out),
        .clken(ena_out),
        .reg_in(out),
        .reg_out(mult_in_reg)
);

end
endgenerate

assign mult_reg = (output_clock != "none") ? mult_in_reg : out;

assign scanouta = dataa_reg;
assign scanoutb = datab_reg;

// ************** Multiplier logic ************** //

mult_block #(
	.width_a(dataa_width),
	.width_b(datab_width),
	.normalized_width(normalized_width)
) mult (
                .dataa(dataa_reg), .datab(datab_reg),
                .signa(signa_reg), .signb(signb_reg),
                .product(out)
		);

assign dataout = (output_clock == "none") ? out : mult_reg;

// IMPLEMENTATION END
endmodule
// MODEL END
