// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


////////////////////////////////////////////////////////////////////////////
// Rounding and Saturation Block
////////////////////////////////////////////////////////////////////////////
module rs_block(rs_output, sat_overflow, round, saturate, datain, sign);

parameter width_sign=2;			// width of the sign bits
parameter width_total=32;		// width of the result
parameter width_fraction_round=15;	// width of fraction to round to
parameter block_type="default";

input round;
input saturate;
input [width_total-1 : 0] datain;	// the input to round/saturate
input sign;
output [width_total-1 : 0] rs_output;		// output of the rs_block
output sat_overflow;

wire [width_total-1 : 0] round_adder_out;
wire [width_total-1 : 0] round_out;
wire sat_overflow;
wire [width_total-1 : 0] sat_out;
wire [width_total-1 : 0] rs_output;

wire [width_total-1 : width_total-(width_sign+width_fraction_round+2)] round_out_top;

generate if (width_total > width_sign+width_fraction_round+3) begin
	assign round_out_top = (sign)? 
		datain[width_total-1:width_total-(width_sign+width_fraction_round+2)] - {{width_sign+width_fraction_round{1'b0}},{1'b1}} :
		datain[width_total-1:width_total-(width_sign+width_fraction_round+2)] + {{width_sign+width_fraction_round{1'b0}},{1'b1}};

	assign round_adder_out = {round_out_top,datain[width_total-(width_sign+width_fraction_round+3):0]};
end else begin
	assign round_adder_out = datain;
end
endgenerate

assign round_out = (round)? round_adder_out : datain;

generate if (block_type=="mac_mult")
assign sat_overflow = (saturate)? 
	// for the multiplier this is the only valid case when saturation occurs
 (round_out[width_total-1:width_total-2]==2'b01) : 1'b0;
else
    // if saturation is enabled and if any of the sign bits are different, 
    // set sat_overflow

assign sat_overflow = (saturate)? (
   ~&round_out[width_total-1 : width_total-width_sign] &&
    |round_out[width_total-1 : width_total-width_sign]) : 1'b0;
endgenerate

assign sat_out = (saturate && sat_overflow)? 
	{{width_sign{round_out[width_total-1]}},
	 {width_total-width_sign{!round_out[width_total-1]}}} : round_out;

generate if(width_total >= width_sign+width_fraction_round) begin
	assign rs_output = (sat_out & {{width_sign+width_fraction_round{1'b1}},
	 {width_total-width_sign-width_fraction_round{!round}}});
end else begin
	assign rs_output = sat_out;
end
endgenerate
endmodule
