// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


///////////////////////////////////////////////////////////////////////////////
//
// Module Name : HARDCOPYII_RAM_BLOCK
//
// Description : Black Box model for Formal Verification
//
///////////////////////////////////////////////////////////////////////////////

module hardcopyii_ram_block (
	portadatain, 
	portaaddr, 
	portawe, 
	portabyteenamasks, 
	portaaddrstall,
	portbdatain, 
	portbaddr, 
	portbrewe, 
	portbbyteenamasks,
	portbaddrstall,
	clk0, clk1, 
	ena0, ena1, 
	clr0, clr1,
	portadataout, 
	portbdataout
);

	parameter operation_mode = "unused";
	parameter mixed_port_feed_through_mode = "UNUSED";
	parameter ram_block_type = "unused"; 
	parameter logical_ram_name = "unused"; 
	parameter init_file = "UNUSED"; 
	parameter init_file_layout = "UNUSED";
	parameter data_interleave_width_in_bits = 1;
	parameter data_interleave_offset_in_bits = 1;
	parameter port_a_logical_ram_depth = 0; 
	parameter port_a_logical_ram_width = 0;
	parameter port_a_data_out_clock = "none";
	parameter port_a_data_out_clear = "UNUSED";

	parameter port_a_first_address = 1;
	parameter port_a_last_address = 1;
	parameter port_a_first_bit_number = 1;
	parameter port_a_data_width = 1;
	parameter port_a_address_width = 1; 
	parameter port_a_byte_enable_mask_width = 1; 
	parameter port_a_byte_size = 8;

	parameter port_a_disable_ce_on_input_registers = "off"; 
	parameter port_a_disable_ce_on_output_registers = "off";

	parameter port_b_logical_ram_depth = 0;
	parameter port_b_logical_ram_width = 0;
	parameter port_b_data_in_clock = "UNUSED";
	parameter port_b_address_clock = "UNUSED";
	parameter port_b_read_enable_write_enable_clock = "UNUSED"; 
	parameter port_b_byte_enable_clock = "UNUSED";
	parameter port_b_data_out_clock = "none";
	parameter port_b_data_out_clear = "UNUSED";

	parameter port_b_first_address = 0;
	parameter port_b_last_address = 0;
	parameter port_b_first_bit_number = 0;
	parameter port_b_data_width = 1;
	parameter port_b_address_width = 1; 
	parameter port_b_byte_enable_mask_width = 1; 
	parameter port_b_byte_size = 8;
	parameter port_b_disable_ce_on_input_registers = "off";
	parameter port_b_disable_ce_on_output_registers = "off";

	parameter power_up_uninitialized = "false";
	parameter lpm_type = "hardcopyii_ram_block";
	parameter connectivity_checking = "OFF";
	parameter mem_init0 = 2048'b0;
	parameter mem_init1 = 2560'b0;
	parameter lpm_hint = "unused";
   
	input [port_a_data_width-1:0] 		portadatain;
	input [port_a_address_width-1:0]  		portaaddr;
	input 	portawe;
	input [port_a_byte_enable_mask_width-1:0] 	portabyteenamasks; 
	input 	portaaddrstall;
	input [port_b_data_width-1:0] 		portbdatain;
	input [port_b_address_width-1:0]  		portbaddr;
	input 	portbrewe;
	input [port_b_byte_enable_mask_width-1:0] 	portbbyteenamasks; 
	input 	portbaddrstall;
	input 	clk0;
	input 	clk1;
	input 	ena0;
	input 	ena1;
	input 	clr0;
	input 	clr1;
	output [port_a_data_width-1:0] portadataout;
	output [port_b_data_width-1:0] portbdataout; 

endmodule // hardcopyii_ram_block
