// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


////////////////////////////////////////////////////////////////////////////
// HARDCOPYII_MAC_OUT  for Formal Verification 
//
// MODEL BEGIN

`define DEFAULT_DATA_WIDTH 18
`define W_FRACTION_ROUND 15
`define W_SIGN 2

module hardcopyii_mac_out (
// INTERFACE BEGIN
	dataa,
	datab,
	datac,
	datad,
	zeroacc,
	addnsub0,
	addnsub1,
	round0,
	round1,
	saturate,
	multabsaturate,
	multcdsaturate,
	signa,
	signb,
	clk,aclr,ena,
	dataout,
	accoverflow
);
// INTERFACE END
//// default parameters ////

parameter operation_mode = "unused";

parameter dataa_width = 1;
parameter datab_width = 1; 
parameter datac_width = 1;
parameter datad_width = 1;       // data widths

parameter zeroacc_clock  = "none";
parameter addnsub0_clock = "none";
parameter addnsub1_clock = "none";
parameter round0_clock = "none";
parameter round1_clock = "none";
parameter saturate_clock = "none";
parameter multabsaturate_clock = "none";
parameter multcdsaturate_clock = "none";
parameter signa_clock = "none";
parameter signb_clock = "none";
parameter output_clock = "none";

parameter zeroacc_clear  = "none"; 
parameter addnsub0_clear = "none";
parameter addnsub1_clear = "none";
parameter round0_clear = "none";
parameter round1_clear = "none";
parameter saturate_clear = "none";
parameter multabsaturate_clear = "none";
parameter multcdsaturate_clear = "none";
parameter signa_clear = "none";
parameter signb_clear = "none";
parameter output_clear = "none";

parameter addnsub0_pipeline_clock = "none";
parameter addnsub1_pipeline_clock = "none";
parameter round0_pipeline_clock = "none";
parameter round1_pipeline_clock = "none";
parameter saturate_pipeline_clock = "none";
parameter multabsaturate_pipeline_clock = "none";
parameter multcdsaturate_pipeline_clock = "none";
parameter zeroacc_pipeline_clock = "none";
parameter signa_pipeline_clock = "none";
parameter signb_pipeline_clock = "none";

parameter addnsub0_pipeline_clear = "none";
parameter addnsub1_pipeline_clear = "none";
parameter round0_pipeline_clear = "none";
parameter round1_pipeline_clear = "none";
parameter saturate_pipeline_clear = "none";
parameter multabsaturate_pipeline_clear = "none";
parameter multcdsaturate_pipeline_clear = "none";
parameter zeroacc_pipeline_clear = "none";
parameter signa_pipeline_clear = "none";
parameter signb_pipeline_clear = "none";


parameter lpm_hint           = "true";
parameter lpm_type           = "hardcopyii_mac_out";
parameter dataout_width 	  = 144; // simulation only parameter

parameter rs_feature_used = "yes";	// parameter for FV use only

localparam
in0_width = ( dataa_width > datab_width ) ? dataa_width + 1 : datab_width + 1 ,
in1_width = ( datac_width > datad_width ) ? datac_width + 1 : datad_width + 1 ,
sum_width  = ( in0_width  > in1_width )  ? in0_width + 1  : in1_width + 1 ,

out_width = (operation_mode == "accumulator") ? datab_width + 16 : (
            (operation_mode == "output_only") ? dataa_width      : (
            (operation_mode == "36_bit_multiply") ? dataa_width+datab_width : (
	    (operation_mode == "one_level_adder") ? sum_width - 1 : sum_width )));

//// constants ////
//// variables ////

//// port declarations ////

input [ dataa_width - 1 : 0 ] dataa;
input [ datab_width - 1 : 0 ] datab;
input [ datac_width - 1 : 0 ] datac;
input [ datad_width - 1 : 0 ] datad;

input signa, signb;
input zeroacc;
input addnsub0, addnsub1;
input round0, round1;
input saturate;
input multabsaturate;
input multcdsaturate;
input [3:0] clk, aclr, ena;

output accoverflow;
output [ out_width - 1 : 0 ] dataout;

//// nets/registers ////

wire clock_signa, clock_signb; // A/B sign clocks
wire clear_signa, clear_signb; // A/B sign clears
wire ena_signa, ena_signb;     // A/B sign clock enables

wire clock_pipe_signa, clock_pipe_signb; // A/B sign pipe clocks
wire clear_pipe_signa, clear_pipe_signb; // A/B sign pipe clears
wire ena_pipe_signa, ena_pipe_signb;     // A/B sign pipe clock enables

wire clock_zeroacc, clear_zeroacc, ena_zeroacc;                  // Zero accum clock,clr,ena
wire clock_pipe_zeroacc, clear_pipe_zeroacc, ena_pipe_zeroacc;   // Zero accum pipeline clock,clr,ena

wire clock_addnsub0, clear_addnsub0, ena_addnsub0;                  // Addnsub0 clock,clr,ena
wire clock_pipe_addnsub0, clear_pipe_addnsub0, ena_pipe_addnsub0;   // Addnsub0 pipeline clock,clr,ena

wire clock_addnsub1, clear_addnsub1, ena_addnsub1;                  // Addnsub1 clock,clr,ena
wire clock_pipe_addnsub1, clear_pipe_addnsub1, ena_pipe_addnsub1;   // Addnsub1 pipeline clock,clr,ena

wire clock_out, clear_out, ena_out;                                 // Output clock,clr,ena

wire [out_width - 1 : 0] dataa_u,datab_u,datac_u,datad_u;  
				// Holds unsigned vectors for 36bit add
wire [out_width - 1 : 0] datab_s,datac_s,datad_s;  
				// Holds sign extended vectors for 36bit add
// A/B Sign bits

wire signa_in_reg;
wire signa_in_pipe;
wire signa_reg,signa_pipe;               // signa reg/pipe 

wire signb_in_reg;
wire signb_in_pipe;
wire signb_reg,signb_pipe;               // signb reg/pipe

// Zeroacc
wire zeroacc_in_reg,zeroacc_in_pipe;     // zeroacc reg/pipe
wire zeroacc_reg,zeroacc_pipe;


// Round0
wire clock_round0, clear_round0, ena_round0;
wire clock_pipe_round0, clear_pipe_round0, ena_pipe_round0;
wire round0_in_reg,round0_pipe_in_reg;     // round0 reg/pipe
wire round0_reg,round0_pipe_reg;

//Round1
wire clock_round1, clear_round1, ena_round1;
wire clock_pipe_round1, clear_pipe_round1, ena_pipe_round1;
wire round1_in_reg,round1_pipe_in_reg;     // round1 reg/pipe
wire round1_reg,round1_pipe_reg;

//saturate
wire clock_saturate, clear_saturate, ena_saturate;
wire clock_pipe_saturate, clear_pipe_saturate, ena_pipe_saturate;
wire saturate_in_reg,saturate_pipe_in_reg;     // saturate reg/pipe
wire saturate_reg,saturate_pipe_reg;

// Accumulator input and output

wire [datab_width + 15 : 0] accum_in_fedback;
wire [datab_width + 15 : 0] accum_in;
wire [datab_width + 16 : 0] accum_out;

// Accumulator overflow

wire overflow;
wire overflow_reg;
wire Overflow0;
wire Overflow1;

// accum saturation
wire accum_sat_overflow;
wire [datab_width + 16 : 0] accum_rs_output;
//wire [datab_width + 16 : 0] accum_out_postrs;

// Output

wire [ in0_width - 1  : 0 ] out0;
wire [ in0_width - 1  : 0 ] out0_postround;
wire [ in1_width - 1  : 0 ] out1;
wire [ in1_width - 1  : 0 ] out1_postround;

wire [ out_width - 1 : 0 ] sum;
wire [ out_width - 1 : 0 ] sum_int;

wire [ out_width - 1 : 0  ] out;
wire [ out_width - 1 : 0  ] add_reg;
wire [ out_width - 1 : 0  ] dataout_pre;

wire [ out_width - 1 : 0  ] add_in_reg;

// Addnsub0

wire addnsub0_in_reg,addnsub0_in_pipe;     // addsub0 reg/pipe
wire addnsub0_reg,addnsub0_pipe;

// Addnsub1

wire addnsub1_in_reg,addnsub1_in_pipe;     // addsub1 reg/pipe
wire addnsub1_reg,addnsub1_pipe;


//multabsaturate
wire clock_multabsaturate, clear_multabsaturate, ena_multabsaturate;
wire clock_pipe_multabsaturate, clear_pipe_multabsaturate,
ena_pipe_multabsaturate;
wire multabsaturate_in_reg,multabsaturate_pipe_in_reg;
                                        // multabsaturate reg/pipe
wire multabsaturate_reg,multabsaturate_pipe_reg;

//multcdsaturate
wire clock_multcdsaturate, clear_multcdsaturate, ena_multcdsaturate;
wire clock_pipe_multcdsaturate, clear_pipe_multcdsaturate,
ena_pipe_multcdsaturate;
wire multcdsaturate_in_reg,multcdsaturate_pipe_in_reg;
                                        // multcdsaturate reg/pipe
wire multcdsaturate_reg,multcdsaturate_pipe_reg;

wire [2:1] accum_rs_bits;
wire mult1_sat_status, mult2_sat_status;
wire dataa_bit_0, datab_bit_0;

// IMPLEMENTATION BEGIN

//////////////////////////// asynchronous logic ////////////////////////////

// select clock,aclr,ena for Sign A/B
assign clock_signa = ( signa_clock == "0" ? clk[0] :
                        ( signa_clock == "1" ? clk[1] :
                                ( signa_clock == "2" ? clk[2] :
                                        ( signa_clock == "3" ? clk[3] : clk[0] ))));

assign clock_signb = ( signb_clock == "0" ? clk[0] :
                        ( signb_clock == "1" ? clk[1] :
                                ( signb_clock == "2" ? clk[2] :
                                        ( signb_clock == "3" ? clk[3] : clk[0] ))));

assign clear_signa = ( signa_clear == "0" ? aclr[0] :
                        ( signa_clear == "1" ? aclr[1] :
                                ( signa_clear == "2" ? aclr[2] :
                                        ( signa_clear == "3" ? aclr[3] :
                                        ( signa_clear == "none" ? 1'b0 : aclr[0] )))));

assign clear_signb = ( signb_clear == "0" ? aclr[0] :
                        ( signb_clear == "1" ? aclr[1] :
                                ( signb_clear == "2" ? aclr[2] :
                                        ( signb_clear == "3" ? aclr[3] :
                                        ( signb_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_signa   = ( signa_clock == "0" ? ena[0] :
                        ( signa_clock == "1" ? ena[1] :
                                ( signa_clock == "2" ? ena[2] :
                                        ( signa_clock == "3" ? ena[3] : ena[0] ))));

assign ena_signb   = ( signb_clock == "0" ? ena[0] :
                        ( signb_clock == "1" ? ena[1] :
                                ( signb_clock == "2" ? ena[2] :
                                        ( signb_clock == "3" ? ena[3] : ena[0] ))));

// select clock,aclr,ena for pipelined Sign A/B

assign clock_pipe_signa = ( signa_pipeline_clock == "0" ? clk[0] :
                             ( signa_pipeline_clock == "1" ? clk[1] :
                                ( signa_pipeline_clock == "2" ? clk[2] :
                                        ( signa_pipeline_clock == "3" ? clk[3] : clk[0] ))));

assign clock_pipe_signb = ( signb_pipeline_clock == "0" ? clk[0] :
                             ( signb_pipeline_clock == "1" ? clk[1] :
                                ( signb_pipeline_clock == "2" ? clk[2] :
                                        ( signb_pipeline_clock == "3" ? clk[3] : clk[0] ))));

assign clear_pipe_signa = ( signa_pipeline_clear == "0" ? aclr[0] :
                             ( signa_pipeline_clear == "1" ? aclr[1] :
                                ( signa_pipeline_clear == "2" ? aclr[2] :
                                        ( signa_pipeline_clear == "3" ? aclr[3] :
                                        ( signa_pipeline_clear == "none" ? 1'b0 : aclr[0] )))));

assign clear_pipe_signb = ( signb_pipeline_clear == "0" ? aclr[0] :
                             ( signb_pipeline_clear == "1" ? aclr[1] :
                                ( signb_pipeline_clear == "2" ? aclr[2] :
                                        ( signb_pipeline_clear == "3" ? aclr[3] :
                                        ( signb_pipeline_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_pipe_signa   = ( signa_pipeline_clock == "0" ? ena[0] :
                             ( signa_pipeline_clock == "1" ? ena[1] :
                                ( signa_pipeline_clock == "2" ? ena[2] :
                                        ( signa_pipeline_clock == "3" ? ena[3] : ena[0] ))));

assign ena_pipe_signb   = ( signb_pipeline_clock == "0" ? ena[0] :
                             ( signb_pipeline_clock == "1" ? ena[1] :
                                ( signb_pipeline_clock == "2" ? ena[2] :
                                        ( signb_pipeline_clock == "3" ? ena[3] : ena[0] ))));

// select clock,aclr,ena for Zeroacc

assign clock_zeroacc = ( zeroacc_clock == "0" ? clk[0] :
                           ( zeroacc_clock == "1" ? clk[1] :
                                ( zeroacc_clock == "2" ? clk[2] :
                                        ( zeroacc_clock == "3" ? clk[3] : clk[0] ))));

assign clear_zeroacc = ( zeroacc_clear == "0" ? aclr[0] :
                           ( zeroacc_clear == "1" ? aclr[1] :
                                ( zeroacc_clear == "2" ? aclr[2] :
                                        ( zeroacc_clear == "3" ? aclr[3] : 
                                        ( zeroacc_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_zeroacc   = ( zeroacc_clock == "0" ? ena[0] :
                           ( zeroacc_clock == "1" ? ena[1] :
                                ( zeroacc_clock == "2" ? ena[2] :
                                        ( zeroacc_clock == "3" ? ena[3] : ena[0] ))));

// select pipelined clock,aclr,ena for Zeroacc

assign clock_pipe_zeroacc = ( zeroacc_pipeline_clock == "0" ? clk[0] :
                              ( zeroacc_pipeline_clock == "1" ? clk[1] :
                                ( zeroacc_pipeline_clock == "2" ? clk[2] :
                                        ( zeroacc_pipeline_clock == "3" ? clk[3] : clk[0] ))));

assign clear_pipe_zeroacc = ( zeroacc_pipeline_clear == "0" ? aclr[0] :
                              ( zeroacc_pipeline_clear == "1" ? aclr[1] :
                                ( zeroacc_pipeline_clear == "2" ? aclr[2] :
                                        ( zeroacc_pipeline_clear == "3" ? aclr[3] : 
                                        ( zeroacc_pipeline_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_pipe_zeroacc   = ( zeroacc_pipeline_clock == "0" ? ena[0] :
                              ( zeroacc_pipeline_clock == "1" ? ena[1] :
                                ( zeroacc_pipeline_clock == "2" ? ena[2] :
                                        ( zeroacc_pipeline_clock == "3" ? ena[3] : ena[0] ))));

// select clock,aclr,ena for Addnsub0

assign clock_addnsub0 = ( addnsub0_clock == "0" ? clk[0] :
                           ( addnsub0_clock == "1" ? clk[1] :
                                ( addnsub0_clock == "2" ? clk[2] :
                                        ( addnsub0_clock == "3" ? clk[3] : clk[0] ))));

assign clear_addnsub0 = ( addnsub0_clear == "0" ? aclr[0] :
                           ( addnsub0_clear == "1" ? aclr[1] :
                                ( addnsub0_clear == "2" ? aclr[2] :
                                        ( addnsub0_clear == "3" ? aclr[3] :
                                        ( addnsub0_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_addnsub0   = ( addnsub0_clock == "0" ? ena[0] :
                           ( addnsub0_clock == "1" ? ena[1] :
                                ( addnsub0_clock == "2" ? ena[2] :
                                        ( addnsub0_clock == "3" ? ena[3] : ena[0] ))));

// select pipeline clock,aclr,ena for Addnsub0

assign clock_pipe_addnsub0 = ( addnsub0_pipeline_clock == "0" ? clk[0] :
                              ( addnsub0_pipeline_clock == "1" ? clk[1] :
                                ( addnsub0_pipeline_clock == "2" ? clk[2] :
                                        ( addnsub0_pipeline_clock == "3" ? clk[3] : clk[0] ))));

assign clear_pipe_addnsub0 = ( addnsub0_pipeline_clear == "0" ? aclr[0] :
                              ( addnsub0_pipeline_clear == "1" ? aclr[1] :
                                ( addnsub0_pipeline_clear == "2" ? aclr[2] :
                                        ( addnsub0_pipeline_clear == "3" ? aclr[3] :
                                        ( addnsub0_pipeline_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_pipe_addnsub0   = ( addnsub0_pipeline_clock == "0" ? ena[0] :
                              ( addnsub0_pipeline_clock == "1" ? ena[1] :
                                ( addnsub0_pipeline_clock == "2" ? ena[2] :
                                   ( addnsub0_pipeline_clock == "3" ? ena[3] : ena[0] ))));

// select clock,aclr,ena for Addnsub1

assign clock_addnsub1 = ( addnsub1_clock == "0" ? clk[0] :
                           ( addnsub1_clock == "1" ? clk[1] :
                                ( addnsub1_clock == "2" ? clk[2] :
                                        ( addnsub1_clock == "3" ? clk[3] : clk[0] ))));

assign clear_addnsub1 = ( addnsub1_clear == "0" ? aclr[0] :
                           ( addnsub1_clear == "1" ? aclr[1] :
                                ( addnsub1_clear == "2" ? aclr[2] :
                                        ( addnsub1_clear == "3" ? aclr[3] :
                                        ( addnsub1_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_addnsub1   = ( addnsub1_clock == "0" ? ena[0] :
                           ( addnsub1_clock == "1" ? ena[1] :
                                ( addnsub1_clock == "2" ? ena[2] :
                                        ( addnsub1_clock == "3" ? ena[3] : ena[0] ))));


// select pipeline clock,aclr,ena for Addnsub1

assign clock_pipe_addnsub1 = ( addnsub1_pipeline_clock == "0" ? clk[0] :
                              ( addnsub1_pipeline_clock == "1" ? clk[1] :
                                ( addnsub1_pipeline_clock == "2" ? clk[2] :
                                        ( addnsub1_pipeline_clock == "3" ? clk[3] : clk[0] ))));

assign clear_pipe_addnsub1 = ( addnsub1_pipeline_clear == "0" ? aclr[0] :
                              ( addnsub1_pipeline_clear == "1" ? aclr[1] :
                                ( addnsub1_pipeline_clear == "2" ? aclr[2] :
                                        ( addnsub1_pipeline_clear == "3" ? aclr[3] :
                                        ( addnsub1_pipeline_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_pipe_addnsub1   = ( addnsub1_pipeline_clock == "0" ? ena[0] :
                              ( addnsub1_pipeline_clock == "1" ? ena[1] :
                                ( addnsub1_pipeline_clock == "2" ? ena[2] :
                                     ( addnsub1_pipeline_clock == "3" ? ena[3] : ena[0] ))));

// select clock,aclr,ena for output

assign clock_out = ( output_clock == "0" ? clk[0] :
                           ( output_clock == "1" ? clk[1] :
                                ( output_clock == "2" ? clk[2] :
                                        ( output_clock == "3" ? clk[3] : clk[0] ))));

assign clear_out = ( output_clear == "0" ? aclr[0] :
                           ( output_clear == "1" ? aclr[1] :
                                ( output_clear == "2" ? aclr[2] :
                                    ( output_clear == "3" ? aclr[3] :
                                       ( output_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_out   = ( output_clock == "0" ? ena[0] :
                           ( output_clock == "1" ? ena[1] :
                                ( output_clock == "2" ? ena[2] :
                                        ( output_clock == "3" ? ena[3] : ena[0] ))));

// select clock, aclr, ena for round0
assign clock_round0 = ( round0_clock == "0" ? clk[0] :
                      ( round0_clock == "1" ? clk[1] :
                      ( round0_clock == "2" ? clk[2] :
                      ( round0_clock == "3" ? clk[3] : clk[0]))));

assign clear_round0 = ( round0_clear == "0" ? aclr[0] :
                      ( round0_clear == "1" ? aclr[1] :
                      ( round0_clear == "2" ? aclr[2] :
                      ( round0_clear == "3" ? aclr[3] :
                      ( round0_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_round0 = ( round0_clock == "0" ? ena[0] :
                    ( round0_clock == "1" ? ena[1] :
                    ( round0_clock == "2" ? ena[2] :
                    ( round0_clock == "3" ? ena[3] : ena[0]))));

// select pipeline clock, aclr, ena for round0
assign clock_pipe_round0 = ( round0_pipeline_clock == "0" ? clk[0] :
                           ( round0_pipeline_clock == "1" ? clk[1] :
                           ( round0_pipeline_clock == "2" ? clk[2] :
                           ( round0_pipeline_clock == "3" ? clk[3] : clk[0]))));

assign clear_pipe_round0 = ( round0_pipeline_clear == "0" ? aclr[0] :
                           ( round0_pipeline_clear == "1" ? aclr[1] :
                           ( round0_pipeline_clear == "2" ? aclr[2] :
                           ( round0_pipeline_clear == "3" ? aclr[3] :
                           ( round0_pipeline_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_pipe_round0 = ( round0_pipeline_clock == "0" ? ena[0] :
                         ( round0_pipeline_clock == "1" ? ena[1] :
                         ( round0_pipeline_clock == "2" ? ena[2] :
                         ( round0_pipeline_clock == "3" ? ena[3] : ena[0]))));

// select clock, aclr, ena for round1
assign clock_round1 = ( round1_clock == "0" ? clk[0] :
                      ( round1_clock == "1" ? clk[1] :
                      ( round1_clock == "2" ? clk[2] :
                      ( round1_clock == "3" ? clk[3] : clk[0]))));

assign clear_round1 = ( round1_clear == "0" ? aclr[0] :
                      ( round1_clear == "1" ? aclr[1] :
                      ( round1_clear == "2" ? aclr[2] :
                      ( round1_clear == "3" ? aclr[3] :
                      ( round1_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_round1 = ( round1_clock == "0" ? ena[0] :
                    ( round1_clock == "1" ? ena[1] :
                    ( round1_clock == "2" ? ena[2] :
                    ( round1_clock == "3" ? ena[3] : ena[0]))));

// select pipeline clock, aclr, ena for round1
assign clock_pipe_round1 = ( round1_pipeline_clock == "0" ? clk[0] :
                           ( round1_pipeline_clock == "1" ? clk[1] :
                           ( round1_pipeline_clock == "2" ? clk[2] :
                           ( round1_pipeline_clock == "3" ? clk[3] : clk[0]))));

assign clear_pipe_round1 = ( round1_pipeline_clear == "0" ? aclr[0] :
                           ( round1_pipeline_clear == "1" ? aclr[1] :
                           ( round1_pipeline_clear == "2" ? aclr[2] :
                           ( round1_pipeline_clear == "3" ? aclr[3] :
                           ( round1_pipeline_clear == "none" ? 1'b0 : aclr[0] ))
)));

assign ena_pipe_round1 = ( round1_pipeline_clock == "0" ? ena[0] :
                         ( round1_pipeline_clock == "1" ? ena[1] :
                         ( round1_pipeline_clock == "2" ? ena[2] :
                         ( round1_pipeline_clock == "3" ? ena[3] : ena[0]))));

// select clock, aclr, ena for saturate
assign clock_saturate = ( saturate_clock == "0" ? clk[0] :
                      ( saturate_clock == "1" ? clk[1] :
                      ( saturate_clock == "2" ? clk[2] :
                      ( saturate_clock == "3" ? clk[3] : clk[0]))));

assign clear_saturate = ( saturate_clear == "0" ? aclr[0] :
                      ( saturate_clear == "1" ? aclr[1] :
                      ( saturate_clear == "2" ? aclr[2] :
                      ( saturate_clear == "3" ? aclr[3] :
                      ( saturate_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_saturate = ( saturate_clock == "0" ? ena[0] :
                    ( saturate_clock == "1" ? ena[1] :
                    ( saturate_clock == "2" ? ena[2] :
                    ( saturate_clock == "3" ? ena[3] : ena[0]))));

// select pipeline clock, aclr, ena for saturate
assign clock_pipe_saturate = ( saturate_pipeline_clock == "0" ? clk[0] :
                           ( saturate_pipeline_clock == "1" ? clk[1] :
                           ( saturate_pipeline_clock == "2" ? clk[2] :
                           ( saturate_pipeline_clock == "3" ? clk[3] : clk[0])))
);

assign clear_pipe_saturate = ( saturate_pipeline_clear == "0" ? aclr[0] :
                           ( saturate_pipeline_clear == "1" ? aclr[1] :
                           ( saturate_pipeline_clear == "2" ? aclr[2] :
                           ( saturate_pipeline_clear == "3" ? aclr[3] :
                          ( saturate_pipeline_clear == "none" ? 1'b0 : aclr[0]
)))));

assign ena_pipe_saturate = ( saturate_pipeline_clock == "0" ? ena[0] :
                         ( saturate_pipeline_clock == "1" ? ena[1] :
                         ( saturate_pipeline_clock == "2" ? ena[2] :
                         ( saturate_pipeline_clock == "3" ? ena[3] : ena[0]))));

// select clock, aclr, ena for multabsaturate
assign clock_multabsaturate = ( multabsaturate_clock == "0" ? clk[0] :
                      ( multabsaturate_clock == "1" ? clk[1] :
                      ( multabsaturate_clock == "2" ? clk[2] :
                      ( multabsaturate_clock == "3" ? clk[3] : clk[0]))));

assign clear_multabsaturate = ( multabsaturate_clear == "0" ? aclr[0] :
                      ( multabsaturate_clear == "1" ? aclr[1] :
                      ( multabsaturate_clear == "2" ? aclr[2] :
                      ( multabsaturate_clear == "3" ? aclr[3] :
                      ( multabsaturate_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_multabsaturate = ( multabsaturate_clock == "0" ? ena[0] :
                    ( multabsaturate_clock == "1" ? ena[1] :
                    ( multabsaturate_clock == "2" ? ena[2] :
                    ( multabsaturate_clock == "3" ? ena[3] : ena[0]))));

// select pipeline clock, aclr, ena for multabsaturate
assign clock_pipe_multabsaturate = ( multabsaturate_pipeline_clock == "0" ?
                           clk[0] :
                           ( multabsaturate_pipeline_clock == "1" ? clk[1] :
                           ( multabsaturate_pipeline_clock == "2" ? clk[2] :
                           ( multabsaturate_pipeline_clock == "3" ? clk[3] :
                           clk[0]))));

assign clear_pipe_multabsaturate = ( multabsaturate_pipeline_clear == "0" ?
                        aclr[0] :
                          ( multabsaturate_pipeline_clear == "1" ? aclr[1] :
                          ( multabsaturate_pipeline_clear == "2" ? aclr[2] :
                          ( multabsaturate_pipeline_clear == "3" ? aclr[3] :
                          ( multabsaturate_pipeline_clear == "none" ? 1'b0 :
                                aclr[0])))));

assign ena_pipe_multabsaturate = ( multabsaturate_pipeline_clock == "0" ?
                        ena[0] :
                         ( multabsaturate_pipeline_clock == "1" ? ena[1] :
                         ( multabsaturate_pipeline_clock == "2" ? ena[2] :
                         ( multabsaturate_pipeline_clock == "3" ? ena[3] :
                        ena[0])))) ;

// select clock, aclr, ena for multcdsaturate
assign clock_multcdsaturate = ( multcdsaturate_clock == "0" ? clk[0] :
                      ( multcdsaturate_clock == "1" ? clk[1] :
                      ( multcdsaturate_clock == "2" ? clk[2] :
                      ( multcdsaturate_clock == "3" ? clk[3] : clk[0]))));

assign clear_multcdsaturate = ( multcdsaturate_clear == "0" ? aclr[0] :
                      ( multcdsaturate_clear == "1" ? aclr[1] :
                      ( multcdsaturate_clear == "2" ? aclr[2] :
                      ( multcdsaturate_clear == "3" ? aclr[3] :
                      ( multcdsaturate_clear == "none" ? 1'b0 : aclr[0] )))));

assign ena_multcdsaturate = ( multcdsaturate_clock == "0" ? ena[0] :
                    ( multcdsaturate_clock == "1" ? ena[1] :
                    ( multcdsaturate_clock == "2" ? ena[2] :
                    ( multcdsaturate_clock == "3" ? ena[3] : ena[0]))));

// select pipeline clock, aclr, ena for multcdsaturate
assign clock_pipe_multcdsaturate = ( multcdsaturate_pipeline_clock == "0" ?
                           clk[0] :
                           ( multcdsaturate_pipeline_clock == "1" ? clk[1] :
                           ( multcdsaturate_pipeline_clock == "2" ? clk[2] :
                           ( multcdsaturate_pipeline_clock == "3" ? clk[3] :
                           clk[0]))));

assign clear_pipe_multcdsaturate = ( multcdsaturate_pipeline_clear == "0" ?
                        aclr[0] :
                          ( multcdsaturate_pipeline_clear == "1" ? aclr[1] :
                          ( multcdsaturate_pipeline_clear == "2" ? aclr[2] :
                          ( multcdsaturate_pipeline_clear == "3" ? aclr[3] :
                          ( multcdsaturate_pipeline_clear == "none" ? 1'b0 :
                                aclr[0])))));

assign ena_pipe_multcdsaturate = ( multcdsaturate_pipeline_clock == "0" ?
                        ena[0] :
                         ( multcdsaturate_pipeline_clock == "1" ? ena[1] :
                         ( multcdsaturate_pipeline_clock == "2" ? ena[2] :
                         ( multcdsaturate_pipeline_clock == "3" ? ena[3] :
                        ena[0])))) ;

// ************** Mac Output logic ************** //

generate

case (operation_mode)

// Multiplier only mode
  "output_only" : 
		assign out = dataa;

// Two multipliers adder mode
  "one_level_adder" : 
  begin 
	// save the status of the multiplier saturation overflow 
   assign mult1_sat_status = (multabsaturate_pipe_reg & dataa[0]);
   assign mult2_sat_status = (multabsaturate_pipe_reg & datab[0]);
	// and reset the bit if it is really the multiplier saturation status
	assign dataa_bit_0 = (multabsaturate_pipe_reg)? 1'b0 : dataa[0];
	assign datab_bit_0 = (multabsaturate_pipe_reg)? 1'b0 : datab[0];

		addsub_block #(dataa_width,datab_width) adder_level1 (
        .dataa(dataa),
		  .datab(datab),
        .signa(signa_pipe | signb_pipe),.signb(signa_pipe | signb_pipe),
        .addsub(addnsub0_pipe),
        .sum(out0)
        );
	if (rs_feature_used=="yes") begin
		rs_block #(
				.width_sign(`W_SIGN+1),
				.width_total(in0_width),
				.width_fraction_round(`W_FRACTION_ROUND)
				) addr1_rs (
			.round(round0_pipe_reg),
			.saturate(1'b0),
			.datain(out0[in0_width-1 : 0]),
			.sign(signa_pipe | signb_pipe),
			.rs_output(out0_postround[in0_width-1 : 0]),
			.sat_overflow()
		);
	assign sum_int = out0_postround;
	end
	else begin
		assign sum_int = out0;
	end
	assign out = sum_int;
  end

// Four multipliers adder mode
  "two_level_adder" : 
  begin
		addsub_block #(dataa_width,datab_width) adder_level1_1 (
			.dataa(dataa),
			.datab(datab),
			.signa(signa_pipe | signb_pipe),.signb(signa_pipe | signb_pipe),
			.addsub(addnsub0_pipe),
			.sum(out0),
			.sumsign(addr11_sumsign)
		);

	if (rs_feature_used=="yes") begin
		rs_block #(
				.width_sign(`W_SIGN+1),
				.width_total(in0_width),
				.width_fraction_round(`W_FRACTION_ROUND)
			) addr11_rs (
			.round(round0_pipe_reg),
			.saturate(1'b0),
			.datain(out0[in0_width-1 : 0]),
			.sign(signa_pipe | signb_pipe | addr11_sumsign),
			.rs_output(out0_postround[in0_width-1 : 0]),
			.sat_overflow()
		);
	end
	else begin
		assign out0_postround = out0;
	end

		addsub_block #(datac_width,datad_width) adder_level1_2 (
			.dataa(datac),
			.datab(datad),
			.signa(signa_pipe | signb_pipe),.signb(signa_pipe | signb_pipe),
			.addsub(addnsub1_pipe),
			.sum(out1),
			.sumsign(addr12_sumsign)
		);

	if (rs_feature_used=="yes") begin
		rs_block #(
			.width_sign(`W_SIGN+1),
			.width_total(in0_width),
			.width_fraction_round(`W_FRACTION_ROUND)
		) addr12_rs (
		.round(round1_pipe_reg),
		.saturate(1'b0),
		.datain(out1[in0_width-1 : 0]),
		.sign(signa_pipe | signb_pipe | addr12_sumsign),
		.rs_output(out1_postround[in0_width-1 : 0]),
		.sat_overflow()
		);
	end else begin
		assign out1_postround = out1;
	end

		addsub_block #(in0_width,in1_width) adder_level2 (
			.dataa(out0_postround),
			.datab(out1_postround),
			.signa(signa_pipe | signb_pipe | addr11_sumsign),
			.signb(signa_pipe | signb_pipe | addr12_sumsign),
			.addsub(1'b1),
			.sum(sum_int)
		);

	if (rs_feature_used=="yes" && out_width==38) begin
  		assign sum = {sum_int[out_width-1:3],
			multcdsaturate_pipe_reg & datac[0],
			multabsaturate_pipe_reg & datab[0],
			multabsaturate_pipe_reg & dataa[0]};
	end else if (operation_mode == "two_level_adder") begin
		assign sum = sum_int;
	end
	assign out = sum;

  end

// Multiply accumulator mode
  "accumulator" :
  begin

// dataa loads the upper 36 bits of the accumulator for
// fully loadable accumulator
// if dataa is not connected it defaults to ground
	assign accum_in_fedback = (zeroacc_pipe == 1'b1) ? dataa<<16 : 
                                                dataout_pre[datab_width + 15:0];
	// save the status of the multiplier saturation overflow 
   assign mult2_sat_status = (multabsaturate_pipe_reg & datab[0]);
	// and reset the bit if it is really the multiplier saturation status
	assign datab_bit_0 = (multabsaturate_pipe_reg)? 1'b0 : datab[0];

	assign accum_in = {{16{datab[datab_width-1] & 
				(signa_pipe | signb_pipe)}},datab[datab_width-1:1],datab_bit_0};

	addsub_block #(datab_width + 16, datab_width + 16) accumulator (
		.dataa(accum_in_fedback),.datab(accum_in),
		.signa(signa_pipe | signb_pipe),.signb(signa_pipe | signb_pipe),
		.addsub(addnsub0_pipe),
		.sum(accum_out)
	);
	assign overflow = (signa_pipe | signb_pipe) ?
                  (accum_out[datab_width + 16] ^ accum_out[datab_width + 15])
                          : accum_out[datab_width + 16];

        /* Rounding and Saturation in the accum */
	if (rs_feature_used=="yes") begin
	rs_block #(
			.width_sign(18),
			.width_total(datab_width+16),
			.width_fraction_round(`W_FRACTION_ROUND)
		) accum_rs (
		.rs_output(accum_rs_output[datab_width+15 : 0]),
		.sat_overflow(accum_sat_overflow),
		.round(round0_pipe_reg),
		.saturate(saturate_pipe_reg),
		.datain(accum_out[datab_width+15 : 0]),
		.sign(signa_pipe | signb_pipe)
		);
	end
	else begin
		assign accum_rs_output = accum_out;
	end
	assign out = accum_rs_output[out_width - 1:0];
  end
// 36-bit multiplier mode
  "36_bit_multiply" :
  begin
    assign dataa_u = dataa;
    assign datab_u = datab;
    assign datab_s = {{(out_width - datab_width){datab[datab_width - 1]}}, datab};
    assign datac_u = datac;
    assign datac_s = {{(out_width - datac_width){datac[datac_width - 1]}}, datac};
    assign datad_u = datad;
    assign datad_s = {{(out_width - datad_width){datad[datad_width - 1]}}, datad};


    assign sum =
                ((signa_pipe == 1'b0) && (signb_pipe == 1'b0))
                  ? dataa_u + (datab_u << 2*`DEFAULT_DATA_WIDTH)
                    + (datac_u << `DEFAULT_DATA_WIDTH)
                    + (datad_u << `DEFAULT_DATA_WIDTH) : (
                ((signa_pipe == 1'b0) && (signb_pipe == 1'b1))
                  ? dataa_u + (datab_s << 2*`DEFAULT_DATA_WIDTH)
                    + (datac_u << `DEFAULT_DATA_WIDTH)
                    + (datad_s << `DEFAULT_DATA_WIDTH) : (
                ((signa_pipe == 1'b1) && (signb_pipe == 1'b0))
                  ? dataa_u + (datab_s << 2*`DEFAULT_DATA_WIDTH)
                    + (datac_s << `DEFAULT_DATA_WIDTH)
                    + (datad_u << `DEFAULT_DATA_WIDTH) : (
                ((signa_pipe == 1'b1) && (signb_pipe == 1'b1))
                  ? dataa_u + (datab_s << 2*`DEFAULT_DATA_WIDTH)
                    + (datac_s << `DEFAULT_DATA_WIDTH)
                    + (datad_s << `DEFAULT_DATA_WIDTH) : (
                 dataa_u + (datab_u << 2*`DEFAULT_DATA_WIDTH)
                    + (datac_u << `DEFAULT_DATA_WIDTH)
                    + (datad_u << `DEFAULT_DATA_WIDTH) ))));

	assign out = sum;
  end

  default : assign out = dataa;
endcase
endgenerate

//////////////////////////// synchronous logic /////////////////////////////

// Sign A register

generate
if (signa_clock != "none")
begin

stratix_mac_udp_register #(1) signa_reg_inst (
	.clk(clock_signa),
	.aclr(clear_signa),
	.clken(ena_signa),
	.reg_in(signa),
	.reg_out(signa_in_reg)
);

end
endgenerate

assign signa_reg = (signa_clock != "none") ? signa_in_reg : signa;

// Sign A pipe

generate
if (signa_pipeline_clock != "none")
begin

stratix_mac_udp_register #(1) signa_in_pipe_inst (
        .clk(clock_pipe_signa),
        .aclr(clear_pipe_signa),
        .clken(ena_pipe_signa),
        .reg_in(signa_reg),
        .reg_out(signa_in_pipe)
);

end
endgenerate

assign signa_pipe = (signa_pipeline_clock == "none") ? signa_reg : signa_in_pipe;


// Sign B register

generate
if (signb_clock != "none")
begin

stratix_mac_udp_register #(1) signb_reg_inst (
        .clk(clock_signb),
        .aclr(clear_signb),
        .clken(ena_signb),
        .reg_in(signb),
        .reg_out(signb_in_reg)
);

end
endgenerate

assign signb_reg = (signb_clock != "none") ? signb_in_reg : signb;


// Sign B pipe

generate

if (signb_pipeline_clock != "none")
begin

stratix_mac_udp_register #(1) signb_in_pipe_inst (
        .clk(clock_pipe_signb),
        .aclr(clear_pipe_signb),
        .clken(ena_pipe_signb),
        .reg_in(signb_reg),
        .reg_out(signb_in_pipe)
);

end
endgenerate

assign signb_pipe = (signb_pipeline_clock == "none") ? signb_reg : signb_in_pipe;

// Zeroacc register

generate
if (zeroacc_clock != "none")
begin

stratix_mac_udp_register #(1) zeroacc_reg_inst (
        .clk(clock_zeroacc),
        .aclr(clear_zeroacc),
        .clken(ena_zeroacc),
        .reg_in(zeroacc),
        .reg_out(zeroacc_in_reg)
);

end
endgenerate

assign zeroacc_reg = (zeroacc_clock != "none") ? zeroacc_in_reg : zeroacc;

// Zeroacc pipe

generate
if (zeroacc_pipeline_clock != "none")
begin

stratix_mac_udp_register #(1) zeroacc_in_pipe_inst (
        .clk(clock_pipe_zeroacc),
        .aclr(clear_pipe_zeroacc),
        .clken(ena_pipe_zeroacc),
        .reg_in(zeroacc_reg),
        .reg_out(zeroacc_in_pipe)
);

end
endgenerate

assign zeroacc_pipe = (zeroacc_pipeline_clock == "none") ? zeroacc_reg : zeroacc_in_pipe;

// Addnsub0 register

generate

if (addnsub0_clock != "none")
begin

stratix_mac_udp_register #(1) addnsub0_reg_inst (
        .clk(clock_addnsub0),
        .aclr(clear_addnsub0),
        .clken(ena_addnsub0),
        .reg_in(addnsub0),
        .reg_out(addnsub0_in_reg)
);

end
endgenerate

assign addnsub0_reg = (addnsub0_clock == "none") ? addnsub0 : addnsub0_in_reg;

// Addnsub0 pipe

generate

if (addnsub0_pipeline_clock != "none")
begin

stratix_mac_udp_register #(1) addnsub0_in_pipe_inst (
        .clk(clock_pipe_addnsub0),
        .aclr(clear_pipe_addnsub0),
        .clken(ena_pipe_addnsub0),
        .reg_in(addnsub0_reg),
        .reg_out(addnsub0_in_pipe)
);


end
endgenerate

assign addnsub0_pipe = (addnsub0_pipeline_clock == "none") ? addnsub0_reg : addnsub0_in_pipe;

// Addnsub1 register

generate

if (addnsub1_clock != "none")
begin

stratix_mac_udp_register #(1) addnsub1_reg_inst (
        .clk(clock_addnsub1),
        .aclr(clear_addnsub1),
        .clken(ena_addnsub1),
        .reg_in(addnsub1),
        .reg_out(addnsub1_in_reg)
);

end
endgenerate

assign addnsub1_reg = (addnsub1_clock == "none") ? addnsub1 : addnsub1_in_reg;

// Addnsub1 pipe

generate

if (addnsub1_pipeline_clock != "none")
begin

stratix_mac_udp_register #(1) addnsub1_in_pipe_inst (
        .clk(clock_pipe_addnsub1),
        .aclr(clear_pipe_addnsub1),
        .clken(ena_pipe_addnsub1),
        .reg_in(addnsub1_reg),
        .reg_out(addnsub1_in_pipe)
);

end
endgenerate

assign addnsub1_pipe = (addnsub1_pipeline_clock == "none") ? addnsub1_reg : addnsub1_in_pipe;

// Output register

generate
if (output_clock != "none")
begin

stratix_mac_udp_register #(out_width) add_reg_inst (
        .clk(clock_out),
        .aclr(clear_out),
        .clken(ena_out),
        .reg_in(out),
        .reg_out(add_in_reg)
);

end
endgenerate

assign add_reg = (output_clock != "none") ? add_in_reg : out;

// Overflow register

generate
if ((operation_mode == "accumulator") && (output_clock != "none"))
begin

stratix_mac_udp_register #(1) overflow_reg_inst (
        .clk(clock_out),
        .aclr(clear_out),
        .clken(ena_out),
        .reg_in(overflow),
        .reg_out(overflow_reg)
);

end
endgenerate

assign accoverflow = (operation_mode=="two_level_adder" && out_width == 38 
		// && multcdsaturate_pipe_reg - dont need this for accoverflow
							)? datad[0] : 
			  (((operation_mode == "accumulator") && (output_clock != "none")) ? 
			    overflow_reg : overflow);

// round0 register

generate
if (round0_clock != "none")
begin

stratix_mac_udp_register #(1) round0_reg_inst (
        .clk(clock_round0),
        .aclr(clear_round0),
        .clken(ena_round0),
        .reg_in(round0),
        .reg_out(round0_in_reg)
);

end
endgenerate
assign round0_reg = (round0_clock == "none")? round0 : round0_in_reg;

// round0 pipeline register

generate
if (round0_pipeline_clock != "none")
begin

stratix_mac_udp_register #(1) round0_pipe_reg_inst (
        .clk(clock_pipe_round0),
        .aclr(clear_pipe_round0),
        .clken(ena_pipe_round0),
        .reg_in(round0_reg),
        .reg_out(round0_pipe_in_reg)
);

end
endgenerate
assign round0_pipe_reg = (round0_pipeline_clock == "none")?
                          round0_reg : round0_pipe_in_reg;

// round1 register

generate
if (round1_clock != "none")
begin

stratix_mac_udp_register #(1) round1_reg_inst (
        .clk(clock_round1),
        .aclr(clear_round1),
        .clken(ena_round1),
        .reg_in(round1),
        .reg_out(round1_in_reg)
);

end
endgenerate
assign round1_reg = (round1_clock == "none")? round1 : round1_in_reg;

// round1 pipeline register

generate
if (round1_pipeline_clock != "none")
begin

stratix_mac_udp_register #(1) round1_pipe_reg_inst (
        .clk(clock_pipe_round1),
        .aclr(clear_pipe_round1),
        .clken(ena_pipe_round1),
        .reg_in(round1_reg),
        .reg_out(round1_pipe_in_reg)
);

end
endgenerate
assign round1_pipe_reg = (round1_pipeline_clock == "none")?
                          round1_reg : round1_pipe_in_reg;

// saturate register

generate
if (saturate_clock != "none")
begin

stratix_mac_udp_register #(1) saturate_reg_inst (
        .clk(clock_saturate),
        .aclr(clear_saturate),
        .clken(ena_saturate),
        .reg_in(saturate),
        .reg_out(saturate_in_reg)
);

end
endgenerate
assign saturate_reg = (saturate_clock == "none")? saturate : saturate_in_reg;

// saturate pipeline register

generate
if (saturate_pipeline_clock != "none")
begin

stratix_mac_udp_register #(1) saturate_pipe_reg_inst (
        .clk(clock_pipe_saturate),
        .aclr(clear_pipe_saturate),
        .clken(ena_pipe_saturate),
        .reg_in(saturate_reg),
        .reg_out(saturate_pipe_in_reg)
);

end
endgenerate
assign saturate_pipe_reg = (saturate_pipeline_clock == "none")?
                          saturate_reg : saturate_pipe_in_reg;

// multabsaturate register

generate
if (multabsaturate_clock != "none")
begin

stratix_mac_udp_register #(1) multabsaturate_reg_inst (
        .clk(clock_multabsaturate),
        .aclr(clear_multabsaturate),
        .clken(ena_multabsaturate),
        .reg_in(multabsaturate),
        .reg_out(multabsaturate_in_reg)
);

end
endgenerate
assign multabsaturate_reg = (multabsaturate_clock == "none")?
                        multabsaturate : multabsaturate_in_reg;

// multabsaturate pipeline register

generate
if (multabsaturate_pipeline_clock != "none")
begin

stratix_mac_udp_register #(1) multabsaturate_pipe_reg_inst (
        .clk(clock_pipe_multabsaturate),
        .aclr(clear_pipe_multabsaturate),
        .clken(ena_pipe_multabsaturate),
        .reg_in(multabsaturate_reg),
        .reg_out(multabsaturate_pipe_in_reg)
);

end
endgenerate
assign multabsaturate_pipe_reg = (multabsaturate_pipeline_clock == "none")?
                          multabsaturate_reg : multabsaturate_pipe_in_reg;

// multcdsaturate register

generate
if (multcdsaturate_clock != "none")
begin

stratix_mac_udp_register #(1) multcdsaturate_reg_inst (
        .clk(clock_multcdsaturate),
        .aclr(clear_multcdsaturate),
        .clken(ena_multcdsaturate),
        .reg_in(multcdsaturate),
        .reg_out(multcdsaturate_in_reg)
);

end
endgenerate
assign multcdsaturate_reg = (multcdsaturate_clock == "none")?
                        multcdsaturate : multcdsaturate_in_reg;

// multcdsaturate pipeline register

generate
if (multcdsaturate_pipeline_clock != "none")
begin

stratix_mac_udp_register #(1) multcdsaturate_pipe_reg_inst (
        .clk(clock_pipe_multcdsaturate),
        .aclr(clear_pipe_multcdsaturate),
        .clken(ena_pipe_multcdsaturate),
        .reg_in(multcdsaturate_reg),
        .reg_out(multcdsaturate_pipe_in_reg)
);

end
endgenerate

assign multcdsaturate_pipe_reg = (multcdsaturate_pipeline_clock == "none")?
                          multcdsaturate_reg : multcdsaturate_pipe_in_reg;

generate if (operation_mode == "one_level_adder" && out_width==37)
	assign dataout = {dataout_pre[out_width-1:2], mult2_sat_status, mult1_sat_status};
else if (operation_mode == "accumulator" && out_width==52) begin
	assign accum_rs_bits[2] = (saturate_pipe_reg)? accum_sat_overflow : dataout_pre[2];
	assign accum_rs_bits[1] = (multabsaturate_pipe_reg)? mult2_sat_status : dataout_pre[1];
	assign dataout = {dataout_pre[out_width-1:3],
								accum_rs_bits[2:1],dataout_pre[0]};
end
else 
	assign dataout = dataout_pre;
endgenerate

assign dataout_pre = (output_clock == "none") ? out : add_reg ;

// IMPLEMENTATION END
endmodule
// MODEL END
