// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


//------------------------------------------------------------------
//
// Module Name : hardcopyii_lcell_ff
//
// Description : HARDCOPYII LCELL_FF Verilog model for Formal Verification
//
//------------------------------------------------------------------
// MODEL BEGIN
// INTERFACE BEGIN
module hardcopyii_lcell_ff (
                   datain, 	// data input
                   clk, 	// clock input
                   aclr, 	// async clear 
                   aload, 	// aync load
                   sclr, 	// sync clear
                   sload, 	// sync load
                   adatasdata, 	// asyn/sync load data source
                   ena, 	// clock enable
                   regout	// registered output
                  );

// INTERFACE END

//// parameter declarations
parameter lpm_type = "hardcopyii_lcell_ff";

//// port declarations   
input datain;
input clk;
input aclr;
input aload; 
input sclr; 
input sload; 
input adatasdata; 
input ena; 
output regout;

//// wires/registers ////

wire actual_datain;
wire arst_w;
wire aset_w;
wire d_w;
wire inv_aclr;

assign actual_datain = sclr? 1'b0 : (sload? adatasdata : datain);

assign inv_aclr = ~ aclr;
assign aset_w = inv_aclr & aload & adatasdata;
assign arst_w = aclr | (inv_aclr & aload & (~adatasdata));
assign d_w = ena ? actual_datain : regout;

dffp lc_ff (regout, clk, d_w, aset_w, arst_w);
   
endmodule
