// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


module flvds_tx (
    tx_in,
    tx_inclock,
    tx_enable,
    sync_inclock,
    tx_pll_enable,
    pll_areset,
    tx_out,
    tx_outclock,
    tx_coreclock,
    tx_locked
);

	parameter number_of_channels = 1;
	parameter deserialization_factor = 4;
	parameter registered_input = "ON";
	parameter multi_clock = "OFF";
	parameter inclock_period = 0;
	parameter outclock_divide_by = 1;
	parameter inclock_boost = 0;
	parameter center_align_msb = "UNUSED";
	parameter intended_device_family = "APEX20KE";
	parameter output_data_rate = 0;
	parameter inclock_data_alignment = "EDGE_ALIGNED";
	parameter outclock_alignment = "EDGE_ALIGNED";
	parameter common_rx_tx_pll = "ON";
	parameter outclock_resource = "AUTO";
	parameter use_external_pll = "OFF";
	parameter preemphasis_setting = 0;
	parameter vod_setting = 0;
	parameter differential_drive = 0;

	parameter lpm_type = "altlvds_tx";
	parameter clk_src_is_pll = "off";

    parameter width_des_channels_ = deserialization_factor*number_of_channels;

	parameter PLL_M_VALUE = (((output_data_rate * inclock_period)
		+ (5 * 100000)) / 1000000);
	parameter STRATIX_INCLOCK_BOOST =
		((output_data_rate !=0) && (inclock_period !=0))
			? PLL_M_VALUE : ((inclock_boost == 0) ? deserialization_factor
			: inclock_boost);
	parameter CLOCK_PERIOD = (deserialization_factor > 2) ? inclock_period :
		10000;
    parameter PHASE_OUTCLOCK = (outclock_alignment == "EDGE_ALIGNED") ?
		0:
		(outclock_alignment == "CENTER_ALIGNED") ?
		((0.5 * inclock_period / STRATIX_INCLOCK_BOOST) +
		0.5):
		(outclock_alignment == "45_DEGREES") ?
			((0.125 * inclock_period / STRATIX_INCLOCK_BOOST) +
				0.5):
		(outclock_alignment == "90_DEGREES") ?
		((0.25 * inclock_period / STRATIX_INCLOCK_BOOST) +
			0.5):
		(outclock_alignment == "135_DEGREES") ?
			((0.375 * inclock_period / STRATIX_INCLOCK_BOOST) +
				0.5):
		(outclock_alignment == "180_DEGREES") ?
			((0.5 * inclock_period / STRATIX_INCLOCK_BOOST) +
				0.5):
		(outclock_alignment == "225_DEGREES") ?
			((0.625 * inclock_period / STRATIX_INCLOCK_BOOST) +
				0.5):
		(outclock_alignment == "270_DEGREES") ?
			((0.75 * inclock_period / STRATIX_INCLOCK_BOOST) +
				0.5):
		(outclock_alignment == "315_DEGREES") ?
			((0.875 * inclock_period / STRATIX_INCLOCK_BOOST) +
				0.5): 0;
	parameter PHASE_INCLOCK = (inclock_data_alignment == "EDGE_ALIGNED")?
			0 :
		(inclock_data_alignment == "CENTER_ALIGNED") ?
			(0.5 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5:
		(inclock_data_alignment == "45_DEGREES") ?
			(0.125 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5:
		(inclock_data_alignment == "90_DEGREES") ?
			(0.25 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5:
		(inclock_data_alignment == "135_DEGREES") ?
			(0.375 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5:
		(inclock_data_alignment == "180_DEGREES") ?
			(0.5 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5:
		(inclock_data_alignment == "225_DEGREES") ?
			(0.625 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5:
		(inclock_data_alignment == "270_DEGREES") ?
			(0.75 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5:
		(inclock_data_alignment == "315_DEGREES") ?
			(0.875 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5: 0;
    parameter STX_PHASE_OUTCLOCK  = ((outclock_divide_by == 1) ||
		(outclock_alignment == "45_DEGREES") ||
		(outclock_alignment == "90_DEGREES") ||
		(outclock_alignment == "135_DEGREES")) ?
			PHASE_OUTCLOCK + PHASE_INCLOCK:
		((outclock_alignment == "180_DEGREES") ||
		(outclock_alignment == "CENTER_ALIGNED")) ?
			PHASE_INCLOCK :
		(outclock_alignment == "225_DEGREES") ?
			((0.125 * inclock_period / STRATIX_INCLOCK_BOOST) +
				0.5 + PHASE_INCLOCK):
		(outclock_alignment == "270_DEGREES") ?
			((0.25 * inclock_period / STRATIX_INCLOCK_BOOST) +
				0.5 + PHASE_INCLOCK):
		(outclock_alignment == "315_DEGREES") ?
			((0.375 * inclock_period / STRATIX_INCLOCK_BOOST) +
				0.5 + PHASE_INCLOCK): PHASE_INCLOCK;
	parameter STXII_PHASE_OUTCLOCK = STX_PHASE_OUTCLOCK - (0.5 *
		inclock_period / STRATIX_INCLOCK_BOOST);
    parameter STXII_PHASE_INCLOCK = PHASE_INCLOCK - (0.5 *
		inclock_period / STRATIX_INCLOCK_BOOST);

	localparam tx_data_width = ( deserialization_factor % 2 == 0 ) ?
		deserialization_factor : deserialization_factor * 2;

	localparam TXDATA_FROM_PHASE_SHIFT_4_4 = 4'd3;
	localparam TXDATA_FROM_PHASE_SHIFT_6_6 = 6'd35;
	localparam TXDATA_FROM_PHASE_SHIFT_7_7 = 7'd99;
	localparam TXDATA_FROM_PHASE_SHIFT_8_4 = 8'd51;
	localparam TXDATA_FROM_PHASE_SHIFT_8_8 = 8'd195;
	localparam TXDATA_FROM_PHASE_SHIFT_10_10 = 10'd899;
	localparam TXDATA_FROM_PHASE_SHIFT_4_2 = 4'd10;
	localparam TXDATA_FROM_PHASE_SHIFT_5_5 = 5'd19;
	localparam TXDATA_FROM_PHASE_SHIFT_6_2 = 6'd42;
	localparam TXDATA_FROM_PHASE_SHIFT_8_2 = 8'd170;
	localparam TXDATA_FROM_PHASE_SHIFT_9_9 = 9'd391;
	localparam TXDATA_FROM_PHASE_SHIFT_10_2 = 10'd682;

	localparam tx_count_upto_number = tx_data_width / 2;
	localparam oclk_count_upto_number = deserialization_factor;
	localparam tx_counter_size =
		( tx_count_upto_number <= 2 ) ?  1 : (
		( tx_count_upto_number <= 4 ) ?  2 : (
		( tx_count_upto_number <= 8 ) ?  3 : (
		( tx_count_upto_number <= 14 ) ?  4 : (
		( tx_count_upto_number <= 18 ) ?  5 : tx_count_upto_number ))));
	localparam oclk_counter_size =
		( oclk_count_upto_number <= 2 ) ?  1 : (
		( oclk_count_upto_number <= 4 ) ?  2 : (
		( oclk_count_upto_number <= 8 ) ?  3 : (
		( oclk_count_upto_number <= 14 ) ?  4 : (
		( oclk_count_upto_number <= 18 ) ?  5 : oclk_count_upto_number ))));

    input  [ width_des_channels_ - 1 : 0 ] tx_in;
    input tx_inclock;
    input tx_enable;
    input sync_inclock;
    input tx_pll_enable;
    input pll_areset;

    output [ number_of_channels - 1 : 0 ] tx_out;
    output tx_outclock;
    output tx_coreclock;
    output tx_locked;

	wire tx_inclock_or_pll;
	wire [5:0] pll_outclock;
	wire [3:0] pll_extclock;
	wire [ deserialization_factor - 1 : 0 ] oclk_din;
	wire locked;
	wire sclkout0;
	wire sclkout1;
	wire enable0;
	wire enable1;
	wire [5:0] clk_ena;
	wire [3:0] ext_clk_ena;
	wire oclk_ddo_clk;
	wire oclk_shrg_ld_ctrl;
	wire [ oclk_counter_size - 1 : 0 ] oclk_ld_cntr_out;
	wire [ tx_counter_size - 1 : 0 ] tx_ld_cntr_out;
	wire slow_clock;
	wire fast_clock;

	assign tx_coreclock = slow_clock;
	assign tx_locked = locked;
	assign clk_ena = 6'b111111;
	assign ext_clk_ena = 4'b1111;

	lpm_counter #(
		.lpm_width( tx_counter_size ),
		.lpm_modulus( tx_count_upto_number )
	) tx_ld_cntr (
		.clock(fast_clock),
		.aclr(1'b0),
		.aload(1'b0),
		.aset(1'b0),
		.cin(1'b1),
		.clk_en(1'b1),
		.cnt_en(locked),
		.data(1'b0),
		.sclr(1'b0),
		.sload(1'b0),
		.sset(1'b0),
		.updown(1'b1),
		.q(tx_ld_cntr_out)
	);

`include "altera_mf_macros.i"

	generate
	genvar i, j;

	if( IS_FAMILY_STRATIXII( intended_device_family ) ) begin
		assign slow_clock = pll_outclock[0];
		assign fast_clock = sclkout0;

		stratixii_pll #(
			.primary_clock( "inclk0" ),
			.pll_type( "fast" ),
			.vco_multiply_by( STRATIX_INCLOCK_BOOST ),
			.vco_divide_by( 1 ),
			.inclk0_input_frequency( CLOCK_PERIOD ),
			.clk0_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk0_divide_by( deserialization_factor ),
			.clk1_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk1_divide_by( deserialization_factor ),
			.clk2_multiply_by( 1 ),
			.clk2_divide_by( 1 ),
			.sclkout0_phase_shift( STXII_PHASE_INCLOCK ),
			.sclkout1_phase_shift( STXII_PHASE_OUTCLOCK ),
			.clk0_phase_shift( STXII_PHASE_INCLOCK ),
			.clk1_phase_shift( STXII_PHASE_OUTCLOCK ),
			.clk2_phase_shift( 1 ),
			.m( 0 )
		) pll (
			.inclk( {1'b0, tx_inclock} ),
			.ena( tx_pll_enable ),
			.areset( pll_areset ),
			.clkena( clk_ena ),
			.extclkena( ext_clk_ena ),
			.fbin( 1'b1 ),
			.clkswitch( 1'b0 ),
			.pfdena( 1'b1 ),
			.scanclk( 1'b0 ),
			.scanaclr( 1'b0 ),
			.scandata( 1'b1 ),
			.clk( pll_outclock ),
			.extclk( pll_extclock ),
			.locked( locked ),
			.enable0( enable0 ),
			.enable1( enable1 )
		);
	end
	else if( IS_FAMILY_STRATIX( intended_device_family ) ) begin
		assign slow_clock = pll_outclock[2];
		assign fast_clock = pll_outclock[0];

		stratix_pll #(
			.primary_clock( "inclk0" ),
			.pll_type( "fast" ),
			.vco_multiply_by( STRATIX_INCLOCK_BOOST ),
			.vco_divide_by( 1 ),
			.inclk0_input_frequency( CLOCK_PERIOD ),
			.clk0_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk0_divide_by( deserialization_factor ),
			.clk1_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk1_divide_by( deserialization_factor ),
			.clk2_multiply_by( 1 ),
			.clk2_divide_by( 1 ),
			.sclkout0_phase_shift( STXII_PHASE_INCLOCK ),
			.sclkout1_phase_shift( STXII_PHASE_OUTCLOCK ),
			.clk0_phase_shift( STXII_PHASE_INCLOCK ),
			.clk1_phase_shift( STXII_PHASE_OUTCLOCK ),
			.clk2_phase_shift( 1 ),
			.m( 0 )
		) pll (
			.inclk( {1'b0, tx_inclock} ),
			.ena( tx_pll_enable ),
			.areset( pll_areset ),
			.clkena( clk_ena ),
			.extclkena( ext_clk_ena ),
			.fbin( 1'b1 ),
			.clkswitch( 1'b0 ),
			.pfdena( 1'b1 ),
			.scanclk( 1'b0 ),
			.scanaclr( 1'b0 ),
			.scandata( 1'b1 ),
			.clk( pll_outclock ),
			.extclk( pll_extclock ),
			.locked( locked ),
			.enable0( enable0 ),
			.enable1( enable1 )
		);
	end
	else if( IS_FAMILY_STRATIXGX( intended_device_family ) ) begin
		assign slow_clock = pll_outclock[2];
		assign fast_clock = pll_outclock[0];

		stratixgx_pll #(
			.primary_clock( "inclk0" ),
			.pll_type( "fast" ),
			.vco_multiply_by( STRATIX_INCLOCK_BOOST ),
			.vco_divide_by( 1 ),
			.inclk0_input_frequency( CLOCK_PERIOD ),
			.clk0_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk0_divide_by( deserialization_factor ),
			.clk1_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk1_divide_by( deserialization_factor ),
			.clk2_multiply_by( 1 ),
			.clk2_divide_by( 1 ),
			.sclkout0_phase_shift( STXII_PHASE_INCLOCK ),
			.sclkout1_phase_shift( STXII_PHASE_OUTCLOCK ),
			.clk0_phase_shift( STXII_PHASE_INCLOCK ),
			.clk1_phase_shift( STXII_PHASE_OUTCLOCK ),
			.clk2_phase_shift( 1 ),
			.m( 0 )
		) pll (
			.inclk( {1'b0, tx_inclock} ),
			.ena( tx_pll_enable ),
			.areset( pll_areset ),
			.clkena( clk_ena ),
			.extclkena( ext_clk_ena ),
			.fbin( 1'b1 ),
			.clkswitch( 1'b0 ),
			.pfdena( 1'b1 ),
			.scanclk( 1'b0 ),
			.scanaclr( 1'b0 ),
			.scandata( 1'b1 ),
			.clk( pll_outclock ),
			.extclk( pll_extclock ),
			.locked( locked ),
			.enable0( enable0 ),
			.enable1( enable1 )
		);
	end
	else if( IS_FAMILY_CYCLONE( intended_device_family ) ) begin
		assign slow_clock = pll_outclock[1];
		assign fast_clock = pll_outclock[0];

		cyclone_pll #(
			.primary_clock( "inclk0" ),
			.pll_type( "fast" ),
			.vco_multiply_by( STRATIX_INCLOCK_BOOST ),
			.vco_divide_by( 1 ),
			.inclk0_input_frequency( CLOCK_PERIOD ),
			.clk0_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk0_divide_by( deserialization_factor ),
			.clk1_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk1_divide_by( deserialization_factor ),
			.clk2_multiply_by( 1 ),
			.clk2_divide_by( 1 ),
			.sclkout0_phase_shift( STXII_PHASE_INCLOCK ),
			.sclkout1_phase_shift( STXII_PHASE_OUTCLOCK ),
			.clk0_phase_shift( STXII_PHASE_INCLOCK ),
			.clk1_phase_shift( STXII_PHASE_OUTCLOCK ),
			.clk2_phase_shift( 1 ),
			.m( 0 )
		) pll (
			.inclk( {1'b0, tx_inclock} ),
			.ena( tx_pll_enable ),
			.areset( pll_areset ),
			.clkena( clk_ena ),
			.extclkena( ext_clk_ena ),
			.fbin( 1'b1 ),
			.clkswitch( 1'b0 ),
			.pfdena( 1'b1 ),
			.scanclk( 1'b0 ),
			.scanaclr( 1'b0 ),
			.scandata( 1'b1 ),
			.clk( pll_outclock ),
			.extclk( pll_extclock ),
			.locked( locked ),
			.enable0( enable0 ),
			.enable1( enable1 )
		);
	end

	for( i = 0 ; i < number_of_channels ; i = i + 1 ) begin : channel
		wire [ tx_data_width - 1 : 0 ] tx_in_regd;
		wire [ tx_data_width - 1 : 0 ] tx_in_after_x2;
		wire tx_shrg_ld_ctrl;
		wire datain_l;
		wire datain_h;
		wire [ tx_data_width/2 - 1 : 0 ] data_l;
		wire [ tx_data_width/2 - 1 : 0 ] data_h;

		for( j = 0 ; j < tx_data_width ; j = j + 1 ) begin : dsplit
			if( j % 2 ) begin
				assign data_h[ tx_data_width/2 - j/2 - 1 ] = tx_in_regd[j];
			end
			else begin
				assign data_l[ tx_data_width/2 - j/2 - 1 ] = tx_in_regd[j];
			end
		end

		lpm_shiftreg #(
			.lpm_width( tx_data_width / 2 ),
			.lpm_direction( "RIGHT" )
		) shrg_l (
			.enable(1'b1),
			.load(tx_shrg_ld_ctrl),
			.sclr(1'b0),
			.aclr(1'b0),
			.clock(fast_clock),
			.data(data_l),
			.sset(1'b0),
			.shiftin(1'b0),
			.aset(1'b0),
			.shiftout(datain_l) );

		lpm_shiftreg #(
			.lpm_width( tx_data_width / 2 ),
			.lpm_direction( "RIGHT" )
		) shrg_h (
			.enable(1'b1),
			.load(tx_shrg_ld_ctrl),
			.sclr(1'b0),
			.aclr(1'b0),
			.clock(fast_clock),
			.data(data_h),
			.sset(1'b0),
			.shiftin(1'b0),
			.aset(1'b0),
			.shiftout(datain_h) );

		assign tx_shrg_ld_ctrl = ( tx_ld_cntr_out == 0 ) ? 1'b1 : 1'b0;

		altddio_out #(
			.width( 1 )
		) tx_ddo (
			.outclock(fast_clock),
			.datain_h(datain_h),
			.aclr(1'b0),
			.datain_l(datain_l),
			.dataout(tx_out[i]),
			.aset(1'b0),
			.oe(1'b1),
			.outclocken(1'b1) );

		if( deserialization_factor % 2 ) begin
			wire [ deserialization_factor - 1 : 0 ] tx_in_sync_l_regd;
			wire [ deserialization_factor - 1 : 0 ] tx_in_sync_h_regd;

			dffp sync_a_l_ff[deserialization_factor-1:0] (
				.q( tx_in_sync_l_regd ),
				.d( tx_in[ deserialization_factor * ( i + 1 ) - 1 :
					deserialization_factor * i ] ),
				.ck( ~slow_clock ), .s( 1'b0 ), .r( 1'b0 ) );
			dffp sync_b_l_ff[deserialization_factor-1:0] (
				.q( tx_in_after_x2[deserialization_factor-1:0] ),
				.d( tx_in_sync_l_regd ), .ck( ~slow_clock ),
				.s( 1'b0 ), .r( 1'b0 ) );
			dffp sync_a_h_ff[deserialization_factor-1:0] (
				.q( tx_in_sync_h_regd ),
				.d( tx_in[ deserialization_factor * ( i + 1 ) - 1 :
					deserialization_factor * i ] ),
				.ck( slow_clock ), .s( 1'b0 ), .r( 1'b0 ) );
			dffp sync_b_h_ff[deserialization_factor-1:0] (
				.q( tx_in_after_x2[ 2 * deserialization_factor - 1 :
					deserialization_factor ] ),
				.d( tx_in_sync_h_regd ), .ck( ~slow_clock ),
				.s( 1'b0 ), .r( 1'b0 ) );
		end
		else begin
			assign tx_in_after_x2 = tx_in[ deserialization_factor * ( i + 1 )
				- 1 : deserialization_factor * i ];
		end

		if( registered_input == "TX_CLKIN" ) begin
			dffp tx_in_ff[ tx_data_width - 1 : 0 ]
				( tx_in_regd,
					tx_inclock,
					tx_in_after_x2[ tx_data_width - 1 : 0 ],
					1'b0, 1'b0 );
		end
		else if( registered_input == "TX_CORECLK" ||
			( registered_input == "ON" ) ) begin
			dffp tx_in_ff[ tx_data_width - 1 : 0 ] (
				tx_in_regd,
				slow_clock,
				tx_in_after_x2[ tx_data_width - 1 : 0 ],
				1'b0, 1'b0 );
		end
		else begin
			assign tx_in_regd = tx_in_after_x2;
		end
	end

	if( outclock_alignment == "EDGE_ALIGNED" && outclock_divide_by > 1 
			&& inclock_data_alignment == "EDGE_ALIGNED") begin
		if( outclock_divide_by == 2 ) begin
			if( deserialization_factor == 4 ) begin
				assign oclk_din = TXDATA_FROM_PHASE_SHIFT_4_2;
			end
			else if( deserialization_factor == 6 ) begin
				assign oclk_din = TXDATA_FROM_PHASE_SHIFT_6_2;
			end
			else if( deserialization_factor == 8 ) begin
				assign oclk_din = TXDATA_FROM_PHASE_SHIFT_8_2;
			end
			else if( deserialization_factor == 10 ) begin
				assign oclk_din = TXDATA_FROM_PHASE_SHIFT_10_2;
			end
		end
		else if( outclock_divide_by == 4 ) begin
			if( deserialization_factor == 4 ) begin
				assign oclk_din = TXDATA_FROM_PHASE_SHIFT_4_4;
			end
			else if( deserialization_factor == 8 ) begin
				assign oclk_din = TXDATA_FROM_PHASE_SHIFT_8_4;
			end
		end
		else if( outclock_divide_by == 5 ) begin
			if( deserialization_factor == 5 ) begin
				assign oclk_din = TXDATA_FROM_PHASE_SHIFT_5_5;
			end
		end
		else if( outclock_divide_by == 6 ) begin
			if( deserialization_factor == 6 ) begin
				assign oclk_din = TXDATA_FROM_PHASE_SHIFT_6_6;
			end
		end
		else if( outclock_divide_by == 7 ) begin
			if( deserialization_factor == 7 ) begin
				assign oclk_din = TXDATA_FROM_PHASE_SHIFT_7_7;
			end
		end
		else if( outclock_divide_by == 8 ) begin
			if( deserialization_factor == 8 ) begin
				assign oclk_din = TXDATA_FROM_PHASE_SHIFT_8_8;
			end
		end
		else if( outclock_divide_by == 9 ) begin
			if( deserialization_factor == 9 ) begin
				assign oclk_din = TXDATA_FROM_PHASE_SHIFT_9_9;
			end
		end
		else if( outclock_divide_by == 10 ) begin
			if( deserialization_factor == 10 ) begin
				assign oclk_din = TXDATA_FROM_PHASE_SHIFT_10_10;
			end
		end

		lpm_counter #(
			.lpm_width( oclk_counter_size ),
			.lpm_modulus( oclk_count_upto_number )
		) oclk_ld_cntr (
			.clock(fast_clock),
			.aclr(1'b0),
			.aload(1'b0),
			.aset(1'b0),
			.cin(1'b1),
			.clk_en(1'b1),
			.cnt_en(locked),
			.data(1'b0),
			.sclr(1'b0),
			.sload(1'b0),
			.sset(1'b0),
			.updown(1'b1),
			.q(oclk_ld_cntr_out)
		);

		lpm_shiftreg #(
			.lpm_width( deserialization_factor ),
			.lpm_direction( "RIGHT" )
		) shrg_o (
			.enable(1'b1),
			.load(oclk_shrg_ld_ctrl),
			.sclr(1'b0),
			.aclr(1'b0),
			.clock(fast_clock),
			.data(oclk_din),
			.sset(1'b0),
			.shiftin(1'b0),
			.aset(1'b0),
			.shiftout(oclk_ddo_clk) );

		assign oclk_shrg_ld_ctrl = ( oclk_ld_cntr_out ==
			( oclk_count_upto_number - 1 ) ) ?  1'b1 : 1'b0;

		altddio_out #(
			.width( 1 )
		) oclk_ddo (
			.outclock(oclk_ddo_clk),
			.datain_h(1'b1),
			.aclr(1'b0),
			.datain_l(1'b0),
			.dataout(tx_outclock),
			.aset(1'b0),
			.oe(1'b1),
			.outclocken(1'b1) );
	end
	else if( outclock_alignment != inclock_data_alignment ) 
	begin
		assign tx_outclock = pll_extclock[0];
	end
	else begin
		assign tx_outclock = fast_clock;
	end
	endgenerate
endmodule

