// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


module flvds_rx (
    rx_in,
    rx_inclock,
    rx_enable,
    rx_deskew,
    rx_pll_enable,
    rx_data_align,
    rx_reset,
    rx_dpll_reset,
    rx_dpll_hold,
    rx_dpll_enable,
    rx_fifo_reset,
    rx_channel_data_align,
    rx_cda_reset,
    rx_coreclk,
    pll_areset,
    rx_out,
    rx_outclock,
    rx_locked,
    rx_dpa_locked,
    rx_cda_max
);

	parameter number_of_channels = 1;
	parameter deserialization_factor = 4;
	parameter registered_output = "ON";
	parameter inclock_period = 0;
	parameter inclock_boost = 0;
	parameter cds_mode = "UNUSED";
	parameter intended_device_family = "APEX20KE";
	parameter input_data_rate =0;
	parameter inclock_data_alignment = "EDGE_ALIGNED";
	parameter registered_data_align_input = "ON";
	parameter common_rx_tx_pll = "ON";
	parameter enable_dpa_fifo = "OFF";
	parameter use_dpll_rawperror = "OFF";
	parameter use_coreclock_input = "OFF";
	parameter dpll_lock_count = 0; 
	parameter dpll_lock_window = 0;
	parameter outclock_resource = "AUTO";
	parameter data_align_rollover = 4;
	parameter lose_lock_on_one_change ="OFF" ;
	parameter reset_fifo_at_first_lock ="ON" ;

	parameter enable_dpa_mode = "OFF";
	parameter use_external_pll = "OFF";
	parameter lpm_hint = "UNUSED";
	parameter lpm_type = "altlvds_rx";

    parameter clk_src_is_pll = "off";

    parameter STRATIX_INCLOCK_BOOST = ((input_data_rate !=0) && (inclock_period !=0))
		  ? (((input_data_rate * inclock_period) + (5 * 100000)) / 1000000) :
		 ((inclock_boost == 0) ? deserialization_factor : inclock_boost);


    parameter PHASE_SHIFT = (inclock_data_alignment == "EDGE_ALIGNED")? 0:
		(inclock_data_alignment == "CENTER_ALIGNED")? (0.5 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5 :
		(inclock_data_alignment == "45_DEGREES")? (0.125 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5 :
		(inclock_data_alignment == "90_DEGREES")? (0.25 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5 :
		(inclock_data_alignment == "135_DEGREES")? (0.375 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5 :
		(inclock_data_alignment == "180_DEGREES")? (0.5 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5 :
		(inclock_data_alignment == "225_DEGREES")? (0.625 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5 :
		(inclock_data_alignment == "270_DEGREES")? (0.75 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5 :
		(inclock_data_alignment == "315_DEGREES")? (0.875 * inclock_period / STRATIX_INCLOCK_BOOST) + 0.5 : 0;
	parameter CLOCK_PERIOD = (deserialization_factor > 2) ? inclock_period :
		10000;
	parameter STXII_PHASE_SHIFT = PHASE_SHIFT -
		(0.5 * inclock_period / STRATIX_INCLOCK_BOOST);

    parameter width_des_channels_ = deserialization_factor*number_of_channels;

	localparam pll_type = "fast";

	localparam shiftreg_size = ( deserialization_factor % 2 ) ?
		deserialization_factor : deserialization_factor / 2;

	localparam use_fifo_data_sync = "ON";

    input [number_of_channels -1 :0] rx_in;
    input rx_inclock;
    input rx_enable;
    input rx_deskew;
    input rx_pll_enable;
    input rx_data_align;
    input [number_of_channels -1 :0] rx_reset;
    input [number_of_channels -1 :0] rx_dpll_reset;
    input [number_of_channels -1 :0] rx_dpll_hold;
    input [number_of_channels -1 :0] rx_dpll_enable;
    input [number_of_channels -1 :0] rx_fifo_reset;
    input [number_of_channels -1 :0] rx_channel_data_align;
    input [number_of_channels -1 :0] rx_cda_reset;
    input [number_of_channels -1 :0] rx_coreclk;
    input pll_areset;

    output [width_des_channels_ -1: 0] rx_out;
    output rx_outclock;
    output rx_locked;
    output [number_of_channels -1: 0] rx_dpa_locked;
    output [number_of_channels -1: 0] rx_cda_max;

	wire [5:0] pll_outclock;
	wire [ deserialization_factor - 1 : 0 ] oclk_din;
    wire [width_des_channels_ -1: 0] rx_out_int;
	wire locked;
	wire [5:0] clk_ena;
	wire [3:0] ext_clk_ena;
    wire [width_des_channels_ * 2 - 1: 0] rx_in_il_ch;
    wire [width_des_channels_ * 2 - 1: 0] rx_in_il_ch_regd;
	wire fast_clock;
	wire read_clock;
	wire slow_clock;
	wire wrcnt_bit0_cout;
	wire enable0;
	wire enable1;
	wire sclkout0;
	wire sclkout1;

    assign rx_locked = locked;
	assign clk_ena = 6'b111111;
	assign ext_clk_ena = 4'b1111;
	assign rx_outclock = read_clock;

`include "altera_mf_macros.i"

	generate
	genvar i, j;

	if( IS_FAMILY_STRATIXII( intended_device_family ) ) begin
		assign read_clock = ( deserialization_factor % 2 == 0 ) ?
			pll_outclock[0] : pll_outclock[2];
		assign fast_clock = ( use_external_pll == "OFF" ) ?
			pll_outclock[0] : rx_inclock;

		stratixii_pll #(
			.primary_clock( "inclk0" ),
			.pll_type( "fast" ),
			.vco_multiply_by( STRATIX_INCLOCK_BOOST ),
			.vco_divide_by( 1 ),
			.inclk0_input_frequency( CLOCK_PERIOD ),
			.clk0_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk0_divide_by( deserialization_factor ),
			.clk1_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk1_divide_by( deserialization_factor ),
			.clk2_multiply_by( 1 ),
			.clk2_divide_by( 1 ),
			.sclkout0_phase_shift( STXII_PHASE_SHIFT ),
			.clk0_phase_shift( STXII_PHASE_SHIFT ),
			.clk2_phase_shift( STXII_PHASE_SHIFT ),
			.m( 0 )
		) pll (
			.inclk( {1'b0, rx_inclock} ), 
			.ena( rx_pll_enable ),
			.areset( pll_areset ),
			.sclkout( { sclkout1, sclkout0 } ),
			.fbin( 1'b1 ),
			.clkswitch( 1'b0 ),
			.pfdena( 1'b1 ),
			.scanclk( 1'b0 ),
			.scandata( 1'b1 ),
			.clk( pll_outclock ),
			.locked( locked ),
			.enable0( enable0 ),
			.enable1( enable1 )
		);
	end
	else if( IS_FAMILY_STRATIX( intended_device_family ) ) begin
		assign read_clock = ( deserialization_factor % 2 == 0 ) ?
			pll_outclock[0] : pll_outclock[2];
		assign fast_clock = ( use_external_pll == "OFF" ) ?
			pll_outclock[0] : rx_inclock;

		stratix_pll #(
			.primary_clock( "inclk0" ),
			.pll_type( "fast" ),
			.vco_multiply_by( STRATIX_INCLOCK_BOOST ),
			.vco_divide_by( 1 ),
			.inclk0_input_frequency( CLOCK_PERIOD ),
			.clk0_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk0_divide_by( deserialization_factor ),
			.clk1_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk1_divide_by( deserialization_factor ),
			.clk2_multiply_by( 1 ),
			.clk2_divide_by( 1 ),
			.sclkout0_phase_shift( STXII_PHASE_SHIFT ),
			.clk0_phase_shift( STXII_PHASE_SHIFT ),
			.clk2_phase_shift( STXII_PHASE_SHIFT ),
			.m( 0 )
		) pll (
			.inclk( {1'b0, rx_inclock} ), 
			.ena( rx_pll_enable ),
			.areset( pll_areset ),
			.clkena( clk_ena ),
			.extclkena( ext_clk_ena ),
			.scanaclr( 1'b0 ),
			.fbin( 1'b1 ),
			.clkswitch( 1'b0 ),
			.pfdena( 1'b1 ),
			.scanclk( 1'b0 ),
			.scandata( 1'b1 ),
			.clk( pll_outclock ),
			.locked( locked ),
			.enable0( enable0 ),
			.enable1( enable1 )
		);
	end
	else if( IS_FAMILY_STRATIXGX( intended_device_family ) ) begin
		assign read_clock = ( deserialization_factor % 2 == 0 ) ?
			pll_outclock[0] : pll_outclock[2];
		assign fast_clock = ( use_external_pll == "OFF" ) ?
			pll_outclock[0] : rx_inclock;

		stratixgx_pll #(
			.primary_clock( "inclk0" ),
			.pll_type( "fast" ),
			.vco_multiply_by( STRATIX_INCLOCK_BOOST ),
			.vco_divide_by( 1 ),
			.inclk0_input_frequency( CLOCK_PERIOD ),
			.clk0_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk0_divide_by( deserialization_factor ),
			.clk1_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk1_divide_by( deserialization_factor ),
			.clk2_multiply_by( 1 ),
			.clk2_divide_by( 1 ),
			.sclkout0_phase_shift( STXII_PHASE_SHIFT ),
			.clk0_phase_shift( STXII_PHASE_SHIFT ),
			.clk2_phase_shift( STXII_PHASE_SHIFT ),
			.m( 0 )
		) pll (
			.inclk( {1'b0, rx_inclock} ), 
			.ena( rx_pll_enable ),
			.areset( pll_areset ),
			.clkena( clk_ena ),
			.extclkena( ext_clk_ena ),
			.scanaclr( 1'b0 ),
			.fbin( 1'b1 ),
			.clkswitch( 1'b0 ),
			.pfdena( 1'b1 ),
			.scanclk( 1'b0 ),
			.scandata( 1'b1 ),
			.clk( pll_outclock ),
			.locked( locked ),
			.enable0( enable0 ),
			.enable1( enable1 )
		);
	end
	else if( IS_FAMILY_CYCLONE( intended_device_family ) ) begin
		assign read_clock = pll_outclock[1];
		assign fast_clock = ( use_external_pll == "OFF" ) ?
			pll_outclock[0] : rx_inclock;

		cyclone_pll #(
			.primary_clock( "inclk0" ),
			.pll_type( "fast" ),
			.vco_multiply_by( STRATIX_INCLOCK_BOOST ),
			.vco_divide_by( 1 ),
			.inclk0_input_frequency( CLOCK_PERIOD ),
			.clk0_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk0_divide_by( deserialization_factor ),
			.clk1_multiply_by( STRATIX_INCLOCK_BOOST ),
			.clk1_divide_by( deserialization_factor ),
			.clk2_multiply_by( 1 ),
			.clk2_divide_by( 1 ),
			.sclkout0_phase_shift( STXII_PHASE_SHIFT ),
			.clk0_phase_shift( STXII_PHASE_SHIFT ),
			.clk2_phase_shift( STXII_PHASE_SHIFT ),
			.m( 0 )
		) pll (
			.inclk( {1'b0, rx_inclock} ), 
			.ena( rx_pll_enable ),
			.areset( pll_areset ),
			.clkena( clk_ena ),
			.extclkena( ext_clk_ena ),
			.scanaclr( 1'b0 ),
			.fbin( 1'b1 ),
			.clkswitch( 1'b0 ),
			.pfdena( 1'b1 ),
			.scanclk( 1'b0 ),
			.scandata( 1'b1 ),
			.clk( pll_outclock ),
			.locked( locked ),
			.enable0( enable0 ),
			.enable1( enable1 )
		);
	end

	for( i = 0 ; i < number_of_channels ; i = i + 1 ) begin : channel
		wire bit_slip;
		wire rx_in_sync_h_regd;
		wire rx_in_after_lat_h;
		wire rx_in_sync_l_regd;
		wire rx_in_l;
		wire rx_in_h;
		wire [ shiftreg_size - 1 : 0 ] datain_l;
		wire [ shiftreg_size - 1 : 0 ] datain_h;
		wire [ shiftreg_size * 2 - 1 : 0 ] rx_in_interleaved;

		dffp sync_a_h_ff (
			.q( rx_in_sync_h_regd ),
			.d( rx_in[i] ), .ck( fast_clock ), .s( 1'b0 ), .r( 1'b0 ) );
		dffp sync_a_l_ff (
			.q( rx_in_sync_l_regd ), .d( rx_in[i] ),
			.ck( ~fast_clock ), .s( 1'b0 ), .r( 1'b0 ) );
		dffp sync_b_l_ff (
			.q( rx_in_l ), .d( rx_in_after_lat_h ), .ck( fast_clock ),
			.s( 1'b0 ), .r( 1'b0 ) );

		if( IS_FAMILY_CYCLONE( intended_device_family ) ) begin
			dffp sync_b_h_ff (
				.q( rx_in_h ), .d( rx_in_sync_h_regd ), .ck( fast_clock ),
				.s( 1'b0 ), .r( 1'b0 ) );
			dffp sync_lat_l_ff (
				.q( rx_in_after_lat_h ), .d( rx_in_sync_l_regd ),
				.ck( ~fast_clock ), .s( 1'b0 ), .r( 1'b0 ) );
		end
		else begin
			assign rx_in_after_lat_h = rx_in_sync_l_regd;
			assign rx_in_h = rx_in_sync_h_regd;
		end

		for( j = 0 ; j < shiftreg_size * 2 ; j = j + 1 ) begin : ilv
			if( j % 2 ) begin
				assign rx_in_interleaved[j] = datain_l[j/2];
			end
			else begin
				assign rx_in_interleaved[j] = datain_h[j/2];
			end
		end

		lpm_shiftreg #(
			.lpm_width( shiftreg_size ),
			.lpm_direction( "LEFT" )
		) shrg_l (
			.enable(1'b1),
			.load(1'b0),
			.sclr(1'b0),
			.aclr(1'b0),
			.clock(fast_clock),
			.data( { shiftreg_size { 1'b0 } } ),
			.sset(1'b0),
			.shiftin(rx_in_l),
			.aset(1'b0),
			.q(datain_l) );

		lpm_shiftreg #(
			.lpm_width( shiftreg_size ),
			.lpm_direction( "LEFT" )
		) shrg_h (
			.enable(1'b1),
			.load(1'b0),
			.sclr(1'b0),
			.aclr(1'b0),
			.clock(fast_clock),
			.data( { shiftreg_size { 1'b0 } } ),
			.sset(1'b0),
			.shiftin(rx_in_h),
			.aset(1'b0),
			.q(datain_h) );

		if( registered_data_align_input == "ON" ) begin
			dffp data_align_ff
				( bit_slip, fast_clock,
				rx_data_align, 1'b0, 1'b0 );
		end
		else begin
			assign bit_slip = 1'b0;
		end

		if( deserialization_factor % 2 == 0 ) begin
			assign rx_out_int[ deserialization_factor * ( i + 1 ) - 1 :
				deserialization_factor * i ] = rx_in_interleaved;
		end
		else begin
			assign rx_in_il_ch[ deserialization_factor * 2 * ( i + 1 ) - 1 :
				deserialization_factor * 2 * i ] =
				{ rx_in_interleaved[ deserialization_factor - 1 : 0 ],
					rx_in_interleaved[ deserialization_factor * 2 - 1 :
						deserialization_factor ] } ;
		end
	end

	if( registered_output == "ON" ) begin
		dffp rx_out_ff[ width_des_channels_ - 1 : 0 ] (
			rx_out, read_clock,
			rx_out_int, 1'b0, 1'b0 );
	end
	else begin
		assign rx_out = rx_out_int;
	end

	if( deserialization_factor % 2 ) begin
		wire [4:0] wrcnt;
		wire [5:0] rdcnt;

		if( IS_FAMILY_CYCLONE( intended_device_family ) ) begin
			lpm_counter #(
				.lpm_width( 1 )
			) clk_cntr (
				.clock(read_clock),
				.aclr(1'b0),
				.aload(1'b0),
				.aset(1'b0),
				.cin(1'b1),
				.clk_en(1'b1),
				.cnt_en(locked),
				.data(1'b0),
				.sclr(1'b0),
				.sload(1'b0),
				.sset(1'b0),
				.updown(1'b1),
				.q(slow_clock)
			);
		end
		else begin
			assign slow_clock = pll_outclock[1];
		end

		if( use_fifo_data_sync == "ON" ) begin
			dffp sync_ff [ width_des_channels_ * 2 - 1 : 0 ] (
				rx_in_il_ch_regd, read_clock, rx_in_il_ch, 1'b0, 1'b0 );

			altsyncram #(
				.operation_mode( "dual_port" ),
				.widthad_a( 4 ),
				.widthad_b( 5 ),
				.width_a( width_des_channels_ * 2 ),
				.width_b( width_des_channels_ )
			) fifo (
				.address_a( { wrcnt[3:1], ~ wrcnt[0] } ),
				.address_b( rdcnt ),
				.clock0( slow_clock ),
				.clock1( read_clock ),
				.data_a( rx_in_il_ch_regd ),
				.data_b( { width_des_channels_ { 1'b0 } } ),
				.clocken0( 1'b1 ),
				.clocken1( 1'b1 ),
				.aclr0( 1'b0 ),
				.aclr1( 1'b0 ),
				.byteena_a( 1'b0 ),
				.byteena_b( 1'b0 ),
				.addressstall_a( 1'b1 ),
				.addressstall_b( 1'b1 ),
				.wren_a( 1'b1 ),
				.wren_b( 1'b0 ),
				.rden_b( 1'b1 ),
				.q_b( rx_out_int )
			);

			lpm_counter #(
				.lpm_width( 1 )
			) wr_cntr_bit0 (
				.clock(slow_clock),
				.aclr(1'b0),
				.aload(1'b0),
				.aset(1'b0),
				.cin(1'b1),
				.clk_en(1'b1),
				.cnt_en(locked),
				.data(1'b0),
				.sclr(1'b0),
				.sload(1'b0),
				.sset(1'b0),
				.updown(1'b1),
				.cout( wrcnt_bit0_cout ),
				.q(wrcnt[0])
			);

			lpm_counter #(
				.lpm_width( 3 )
			) wr_cntr (
				.clock(slow_clock),
				.aclr(1'b0),
				.aload(1'b0),
				.aset(1'b0),
				.cin( ~wrcnt_bit0_cout ),
				.clk_en(1'b1),
				.cnt_en(locked),
				.data(1'b0),
				.sclr(1'b0),
				.sload(1'b0),
				.sset(1'b0),
				.updown(1'b1),
				.q( wrcnt[3:1] )
			);

			lpm_counter #(
				.lpm_width( 5 )
			) rd_cntr (
				.clock(read_clock),
				.aclr(1'b0),
				.aload(1'b0),
				.aset(1'b0),
				.cin(1'b1),
				.clk_en(1'b1),
				.cnt_en(locked),
				.data(1'b0),
				.sclr(1'b0),
				.sload(1'b0),
				.sset(1'b0),
				.updown(1'b1),
				.q(rdcnt)
			);
		end
		else begin
			dffp sync_ff [ width_des_channels_ * 2 - 1 : 0 ] (
				rx_in_il_ch_regd, slow_clock, rx_in_il_ch, 1'b0, 1'b0 );

			dffp muxsel_ff ( muxsel, read_clock, ~muxsel, 1'b0, 1'b0 );
			assign rx_out_int = muxsel ?
				rx_in_il_ch_regd[ width_des_channels_ * 2 - 1 :
					width_des_channels_ ] :
				rx_in_il_ch_regd[ width_des_channels_ - 1 : 0 ];
		end
	end
	endgenerate
endmodule

