// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.



//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////// CYCLONE LCELL LUT for Formal Verification ///////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////



// MODEL BEGIN
// INTERFACE BEGIN
module cyclone_lut (
        dataa,           // data a
        datab,           // data b
        datac,           // data c
        datad,           // data d
        cin,             // carry in 
        cin0,            // internal carry in 0-chain
	cin1,            // internal carry in 1-chain
	inverta,         // invert for dataa
        regcascin,       // cascade in
	feedback,        // feedback from register	
        combout,         // combinational output
        regin,           // input to register
        cout,            // carry out
	cout0,           // internal carry out 0-chain
	cout1            // internal carry out 1-chain
) ;
// INTERFACE END

//// default parameters ////

parameter operation_mode               = "normal";
parameter lut_mask                     = "ffff";
parameter register_cascade_mode        = "off";
parameter sum_lutc_input               = "datac";
parameter cin_used                     = "false";
parameter cin0_used                    = "false";
parameter cin1_used                    = "false";

//// constants ////

//// port declarations ////

input  dataa, datab, datac, datad;
input  cin;
input  cin0, cin1;
input  inverta;
input  regcascin;
input  feedback;
output cout, cout0, cout1;
output combout,regin;

//// pullups/pulldowns ////

//// nets/registers ////

wire actual_dataa, actual_datad, actual_cin;


reg  cout, cout0, cout1;
reg  lutout;

// IMPLEMENTATION BEGIN
/////////////////////////////////// asynchronous logic /////////////////////////////////////

////////// special purpose functions ////////////////////////////

// ** function converting a 4-digit hex string to 4-digit hex number ** //

    function [16:1] str_to_bin ;
      input  [8*4:1] s;
      reg [8*4:1] reg_s;
      reg [4:1]   digit [8:1];
      reg [8:1] tmp;
      integer   m , ivalue ;
      begin
 
         ivalue = 0;
         reg_s = s;
         for (m=1; m<=4; m= m+1 )
         begin
                tmp = reg_s[32:25];
                digit[m] = tmp & 8'b00001111;
                reg_s = reg_s << 8;
                if (tmp[7] == 'b1)
                   digit[m] = digit[m] + 9;
         end
         str_to_bin = {digit[1], digit[2], digit[3], digit[4]};
    end   
    endfunction

// ** function returns the lut output value ** // 

    function lut4 ;
        input  [4*8:1] lut_mask ;
        input dataa, datab, datac, datad ;
        reg  [15:0] mask ;
	integer  mask_index;
	reg  [3:0] mask_reg_index;
	reg  lut_value ;
        begin
            mask = str_to_bin (lut_mask) ;
	    lut_value = 0;
	    for ( mask_index = 0; mask_index <= 15; mask_index = mask_index + 1 )
	    begin
		mask_reg_index = mask_index;
		lut_value = lut_value | ((datad ~^ mask_reg_index[3]) &
                              (datac ~^ mask_reg_index[2]) &
			      (datab ~^ mask_reg_index[1]) &
			      (dataa ~^ mask_reg_index[0]) &
			      (mask[mask_index]));
	    end
	    lut4 = lut_value;
 	end
     endfunction

///////////// LUT logic ///////////////////////////////////////////////

////// Sum Logic

always @(actual_dataa or datab or datac or actual_datad or actual_cin or cin or cin0 or cin1 or feedback)
begin
 	if (sum_lutc_input == "datac")
	begin
		lutout = lut4(lut_mask,actual_dataa,datab,datac,actual_datad);
	end
	else if (sum_lutc_input == "qfbk")
	begin
		lutout = lut4(lut_mask,actual_dataa,datab,feedback,actual_datad);
	end
	else  
	begin
		if (cin0_used == "true" || cin1_used == "true")
		begin
			lutout = (actual_cin == 1'b0) ?
			 lut4(lut_mask,actual_dataa,datab,cin0,actual_datad):
			 lut4(lut_mask,actual_dataa,datab,cin1,actual_datad);
		end
		else
		begin
		    	if (operation_mode == "normal")
				lutout = lut4(lut_mask,actual_dataa,datab,cin,actual_datad);
			else
				lutout = lut4(lut_mask,actual_dataa,datab,actual_cin,actual_datad);
		end
	end
end

////// Carry Logic

always @(actual_dataa or datab or actual_cin or cin0 or cin1)
begin
	if (operation_mode == "arithmetic")
	begin
      cout0 = lut4(lut_mask,actual_dataa,datab,cin0,1'b0);
      cout1 = lut4(lut_mask,actual_dataa,datab,cin1,1'b0);
		if (cin0_used == "true" || cin1_used == "true")
			cout = (actual_cin == 1'b0) ? cout0 : cout1;
		else
         cout = lut4(lut_mask,actual_dataa,datab,actual_cin,1'b0);
	end
end

/////////////// remainder combinational logic ///////////////////////////////

// ***** cascade logic ****** //

assign regin = (register_cascade_mode == "on") ? regcascin : lutout;

/////////////// net assignments ////////////////////////////////////

assign actual_dataa = (inverta == 1'b1) ? !dataa : dataa;

assign actual_datad = (operation_mode == "normal") ? datad : 1'b1;

assign actual_cin   = (cin_used == "true") ? cin : inverta;

assign combout  = lutout;

///////////////////////////////////// synchronous logic /////////////////////////////////////////

// IMPLEMENTATION END

endmodule

// MODEL END
