// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////// CYCLONE IO atom for Formal Verification ///////////////////////////
////////////////////////////////////////////////////////////////////////////////////////


// MODEL BEGIN
module cyclone_io (
// INTERFACE BEGIN
       datain,                          // data in
       oe,                              // output enable
       outclk,                          // output register clock
       inclk,                           // input register clock
       outclkena,                       // output register clock enable
       inclkena,                        // input register clock enable
       areset,                          // asynchronous reset
       sreset,                          // synchronous reset
       padio,                           // external pad
       combout,                         // combinational output
       regout,                          // registered output
       dff_data_out,                    // internal register output
       dff_oe                           // internal output enable register output

// INTERFACE END
);
////  default parameters ////
parameter open_drain_output = "false";
parameter bus_hold = "false";

parameter operation_mode = "unused";

parameter output_register_mode = "none";
parameter tie_off_output_clock_enable = "false";
parameter output_async_reset = "none";
parameter output_sync_reset = "none";
parameter output_power_up = "low";

parameter oe_register_mode = "none";
parameter tie_off_oe_clock_enable = "false";
parameter oe_async_reset = "none";
parameter oe_sync_reset = "none";
parameter oe_power_up = "low";

parameter input_register_mode = "none";
parameter input_async_reset = "none";
parameter input_sync_reset = "none";
parameter input_power_up = "low";
parameter lpm_type = "cyclone_io";

//// port declarations ////

input  datain,oe,inclk,inclkena,outclk,outclkena,areset,sreset;
output combout,regout;
output dff_data_out,dff_oe;
inout  padio;

//// nets/registers ////

wire oe_delayed,oe_actual;

wire enreg_clken,ireg_clken,oreg_clken;                 // clock enables

wire enreg_clr,ireg_clr,oreg_clr;                       // i/o/en aclr
wire enreg_pre,ireg_pre,oreg_pre;                       // i/o/en apre
wire enreg_sclr,ireg_sclr,oreg_sclr;                    // i/o/en sclr
wire enreg_spre,ireg_spre,oreg_spre;                    // i/o/en spre

wire ireg_in,oreg_in,enreg_in;                          // i/o/en reg inputs

reg  tristate_in,tristate_out;                          // tristate buffer
wire ireg_out,oreg_out,enreg_out;                       // i/o/en reg outputs


// IMPLEMENTATION BEGIN
/////////////////////////////////// asynchronous logic /////////////////////////////////////
//////////// tristate logic ///////////////////////////////////////
always @(tristate_in or oe_delayed)
begin
    if (open_drain_output == "true")
      begin
        if (oe_delayed == 1'b1)
           tristate_out = (tristate_in == 1'b0) ? 1'b0 : 1'bz;
        else
           tristate_out = 1'bz;
      end
    else
      tristate_out = (oe_delayed == 1'b1) ? tristate_in : 1'bz;
end
//////////// remainder combinational logic /////////////////////////

// ***** tristate input ****** //

always @(datain or oreg_out)
begin
     tristate_in = (output_register_mode == "register") ? oreg_out : datain;
end

/////////////// net assignments ///////////////////////

assign oe_actual  = (operation_mode == "input") ? 1'b0 : oe;
assign oe_delayed = (oe_register_mode == "register") ? enreg_out : oe_actual;

assign ireg_clr   = (input_async_reset == "clear")   ? !areset : 1'b1;                 // i/o/en reg aclr/apre
assign ireg_pre   = (input_async_reset == "preset")  ? !areset : 1'b1;
assign oreg_clr   = (output_async_reset == "clear")  ? !areset : 1'b1;
assign oreg_pre   = (output_async_reset == "preset") ? !areset : 1'b1;
assign enreg_clr  = (oe_async_reset == "clear")      ? !areset : 1'b1;
assign enreg_pre  = (oe_async_reset == "preset")     ? !areset : 1'b1;

assign ireg_sclr   = (input_sync_reset == "clear")   ? !sreset : 1'b1;                 // i/o/en reg sclr/spre
assign ireg_spre   = (input_sync_reset == "preset")  ? !sreset : 1'b1;
assign oreg_sclr   = (output_sync_reset == "clear")  ? !sreset : 1'b1;
assign oreg_spre   = (output_sync_reset == "preset") ? !sreset : 1'b1;
assign enreg_sclr  = (oe_sync_reset == "clear")      ? !sreset : 1'b1;
assign enreg_spre  = (oe_sync_reset == "preset")     ? !sreset : 1'b1;

assign enreg_clken = (tie_off_oe_clock_enable == "false")     ? outclkena : 1'b1,
       oreg_clken  = (tie_off_output_clock_enable == "false") ? outclkena : 1'b1,
       ireg_clken  = inclkena;

assign combout    = padio;
assign regout     = (input_register_mode == "register") ? ireg_out : 1'bz;

assign ireg_in    = padio,                                                       // i/o/en reg inputs
         oreg_in  = datain, 
            enreg_in = oe_actual;                                              


assign padio      = tristate_out; 

assign dff_oe     = enreg_out;
assign dff_data_out = oreg_out;

/////////////////////////////////// synchronous logic ///////////////////////////////////

// Output enable register (enreg)

generate
if (oe_register_mode != "none")
begin

cyclone_io_register enreg (
        .clk(outclk),.clken(enreg_clken),
        .clr(enreg_clr),.pre(enreg_pre),
        .sclr(enreg_sclr),.spre(enreg_spre),
        .reg_in(enreg_in),.reg_out(enreg_out)
        );

end
endgenerate

// Input register (ireg)

generate
if (input_register_mode != "none")
begin

cyclone_io_register ireg (
        .clk(inclk),.clken(ireg_clken),
        .clr(ireg_clr),.pre(ireg_pre),
        .sclr(ireg_sclr),.spre(ireg_spre),
        .reg_in(ireg_in),.reg_out(ireg_out)
        );

end
endgenerate


// Output register (oreg)

generate
if (output_register_mode != "none")
begin

cyclone_io_register oreg (
        .clk(outclk),.clken(oreg_clken),
        .clr(oreg_clr),.pre(oreg_pre),
        .sclr(oreg_sclr),.spre(oreg_spre),
        .reg_in(oreg_in),.reg_out(oreg_out)
        );
end
endgenerate

// IMPLEMENTATION END
endmodule
// MODEL END
