// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


//////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////// ALTMULT_ADD for Formal Verification /////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////
// MODEL BEGIN
`define W_FRACTION_ROUND 15
`define W_SIGN 2

module altmult_add (
// INTERFACE BEGIN
	dataa,datab,                 // multiplicand,multiplier
	scanina,scaninb,             // scan in
	sourcea,sourceb,             // source
	clock3,clock2,clock1,clock0, // clock inputs clk[3:0]
	aclr3,aclr2,aclr1,aclr0,     // async clear inputs aclr[3:0]
	ena3,ena2,ena1,ena0,         // clock enable inputs ena[3:0]
	signa,signb,                 // sign bits
	addnsub1,addnsub3,           // add or subtract
        mult01_round, mult23_round,  // round enable
        mult01_saturation, mult23_saturation,  // saturation enable
        addnsub1_round, addnsub3_round, // round enable
	scanouta,scanoutb,           // scan out
	result,                       // product
	mult0_is_saturated,	     // saturated output flag
	mult1_is_saturated,
	mult2_is_saturated,
	mult3_is_saturated

);
// INTERFACE END
//// top level parameters ////

parameter width_a               = 1;              // Width of the dataa[] operand of each multiplier.
parameter width_b               = 1;              // Width of the datab[] operand of each multiplier.
parameter width_result          = 1;              // Width of the result[] of each multiplier.
parameter number_of_multipliers = 1;              // Number of multipliers used
parameter lpm_type              = "altmult_add";  // lpm type

//// A port related parameters ////

// Input registers for A

parameter input_register_a0 = "CLOCK0";
parameter input_aclr_a0     = "ACLR3";
parameter input_source_a0   = "DATAA";

parameter input_register_a1 = "CLOCK0";
parameter input_aclr_a1     = "ACLR3";
parameter input_source_a1   = "DATAA";

parameter input_register_a2 = "CLOCK0";
parameter input_aclr_a2     = "ACLR3";
parameter input_source_a2   = "DATAA";

parameter input_register_a3 = "CLOCK0";
parameter input_aclr_a3     = "ACLR3";
parameter input_source_a3   = "DATAA";

// Sign representation for A
parameter representation_a           = "UNSIGNED";

// signa port registers/pipeline

parameter signed_register_a          = "CLOCK0";
parameter signed_aclr_a              = "ACLR3";
parameter signed_pipeline_register_a = "CLOCK0";
parameter signed_pipeline_aclr_a     = "ACLR3";

// Input registers for B 

parameter input_register_b0 = "CLOCK0";
parameter input_aclr_b0     = "ACLR3";
parameter input_source_b0   = "DATAB";

parameter input_register_b1 = "CLOCK0";
parameter input_aclr_b1     = "ACLR3";
parameter input_source_b1   = "DATAB";

parameter input_register_b2 = "CLOCK0";
parameter input_aclr_b2     = "ACLR3";
parameter input_source_b2   = "DATAB";

parameter input_register_b3 = "CLOCK0";
parameter input_aclr_b3     = "ACLR3";
parameter input_source_b3   = "DATAB";

// Multiplier registers 

parameter multiplier_register0 = "CLOCK0";
parameter multiplier_aclr0     = "ACLR3";
parameter multiplier_register1 = "CLOCK0";
parameter multiplier_aclr1     = "ACLR3";
parameter multiplier_register2 = "CLOCK0";
parameter multiplier_aclr2     = "ACLR3";
parameter multiplier_register3 = "CLOCK0";
parameter multiplier_aclr3     = "ACLR3";

// Addnsub for 1st level adders

parameter multiplier1_direction = "ADD";
parameter multiplier3_direction = "ADD";

// Addnsub port registers/pipeline for 1st level adders

parameter addnsub_multiplier_register1          = "CLOCK0";
parameter addnsub_multiplier_aclr1              = "ACLR3";
parameter addnsub_multiplier_pipeline_register1 = "CLOCK0";
parameter addnsub_multiplier_pipeline_aclr1     = "ACLR3";

parameter addnsub_multiplier_register3          = "CLOCK0";
parameter addnsub_multiplier_aclr3              = "ACLR3";
parameter addnsub_multiplier_pipeline_register3 = "CLOCK0";
parameter addnsub_multiplier_pipeline_aclr3     = "ACLR3";

// Sign representation for B
parameter representation_b           = "UNSIGNED";

// signb port registers/pipeline
parameter signed_register_b          = "CLOCK0";
parameter signed_aclr_b              = "ACLR3";
parameter signed_pipeline_register_b = "CLOCK0";
parameter signed_pipeline_aclr_b     = "ACLR3";

// Output Register

parameter output_register = "CLOCK0";
parameter output_aclr     = "ACLR3";

// Misc parameters

parameter extra_latency                  = 0;
parameter dedicated_multiplier_circuitry = "AUTO";
parameter dsp_block_balancing            = "Auto";
parameter intended_device_family         = "UNUSED";

parameter width_a_ = number_of_multipliers * width_a;
parameter width_b_ = number_of_multipliers * width_b;

// Rounding and Saturation
parameter multiplier01_rounding = "NO";
parameter multiplier01_saturation = "NO";
parameter multiplier23_rounding = "NO";
parameter multiplier23_saturation = "NO";

parameter adder1_rounding = "NO";
parameter adder3_rounding = "NO";

parameter port_mult0_is_saturated = "UNUSED";
parameter port_mult1_is_saturated = "UNUSED";
parameter port_mult2_is_saturated = "UNUSED";
parameter port_mult3_is_saturated = "UNUSED";

parameter mult01_round_register = "CLOCK0";
parameter mult01_round_aclr = "ACLR3";
parameter mult23_round_register = "CLOCK0";
parameter mult23_round_aclr = "ACLR3";

parameter mult01_saturation_register = "CLOCK0";
parameter mult01_saturation_aclr = "ACLR2";
parameter mult23_saturation_register = "CLOCK0";
parameter mult23_saturation_aclr = "ACLR3";
 
parameter addnsub1_round_register = "CLOCK0";
parameter addnsub1_round_aclr = "ACLR3";
parameter addnsub1_round_pipeline_register = "CLOCK0";
parameter addnsub1_round_pipeline_aclr = "ACLR3";

parameter addnsub3_round_register = "CLOCK0";
parameter addnsub3_round_aclr = "ACLR3";
parameter addnsub3_round_pipeline_register = "CLOCK0";
parameter addnsub3_round_pipeline_aclr = "ACLR3";

parameter port_addnsub1 = "PORT_CONNECTIVITY";
parameter port_addnsub3 = "PORT_CONNECTIVITY";
parameter port_signa = "PORT_CONNECTIVITY";
parameter port_signb = "PORT_CONNECTIVITY";

parameter lpm_hint = "UNUSED";

// Local parameters
parameter mult01_rs_enabled = (
                multiplier01_rounding !="NO" ||
                multiplier01_saturation !="NO");

parameter mult23_rs_enabled = (
                multiplier23_rounding !="NO" ||
                multiplier23_saturation !="NO");

parameter max_width = ( width_a >= width_b ) ? width_a : width_b;

`ifdef MULT_NORMALIZE_SIZE
parameter normalized_width = ( dedicated_multiplier_circuitry != "NO" ) ?
	( ( max_width <= 9 ) ? 9 : ( ( max_width <= 18 ) ? 18 : max_width ) ) : 1;
`else
parameter normalized_width = 1;
`endif

parameter width_l1addrout = width_a + width_b + 1;
parameter width_l2addrout = width_a + width_b + 2;

//// port declarations ////

// data input ports
input [(number_of_multipliers * width_a) -1 : 0] dataa;
input [(number_of_multipliers * width_b) -1 : 0] datab;

// clock ports
input clock3;
input clock2;
input clock1;
input clock0;

// asynch clear ports
input aclr3;
input aclr2;
input aclr1;
input aclr0;

// clock enable ports
input ena3;
input ena2;
input ena1;
input ena0;

// control signals
input signa;            // sign of dataa
input signb;            // sign of datab
input addnsub1;         // addnsub for 1st 1-level adder
input addnsub3;         // addnsub for 2nd 1-level adder

input [width_a-1 : 0] scanina; 
input [width_b-1 : 0] scaninb;
input [number_of_multipliers-1 : 0] sourcea; 
input [number_of_multipliers-1 : 0] sourceb;

input mult01_round, mult23_round;
input mult01_saturation, mult23_saturation;
input addnsub1_round;
input addnsub3_round;

// output ports
output [width_result -1 : 0] result;
output [width_a -1 : 0] scanouta;
output [width_b -1 : 0] scanoutb;
output mult0_is_saturated;
output mult1_is_saturated;
output mult2_is_saturated;
output mult3_is_saturated;

//// constants ////
//// variables ////

integer i;

//// nets/registers ////

// Data inputs

wire [(4 * width_a) -1 : 0] dataa_wide;
wire [(4 * width_b) -1 : 0] datab_wide;

// data/scanin input
wire [ (4 * width_a) -1 : 0 ] dataa_in;
wire [ (4 * width_b) -1 : 0 ] datab_in;

// Clocks
wire input_reg_a0_clk,input_reg_a1_clk,input_reg_a2_clk,input_reg_a3_clk; // input A reg clocks
wire input_reg_b0_clk,input_reg_b1_clk,input_reg_b2_clk,input_reg_b3_clk; // input B reg clocks
wire addsub1_reg_clk,addsub1_pipe_clk;                                    // addnsub1 reg/pipe clocks
wire addsub3_reg_clk,addsub3_pipe_clk;                                    // addnsub3 reg/pipe clocks
wire sign_reg_a_clk,sign_pipe_a_clk;                                      // signa reg/pipe clocks
wire sign_reg_b_clk,sign_pipe_b_clk;                                      // signb reg/pipe clocks
wire multiplier_reg0_clk,multiplier_reg1_clk,multiplier_reg2_clk,multiplier_reg3_clk;
                                                                          // multiplier reg clocks
wire output_reg_clk;                                                      // output register clocks

// Asynch Clears
wire input_reg_a0_clr,input_reg_a1_clr,input_reg_a2_clr,input_reg_a3_clr; // input A reg aclr
wire input_reg_b0_clr,input_reg_b1_clr,input_reg_b2_clr,input_reg_b3_clr; // input B reg aclr
wire addsub1_reg_clr,addsub1_pipe_clr;                                    // addnsub1 reg/pipe aclr
wire addsub3_reg_clr,addsub3_pipe_clr;                                    // addnsub3 reg/pipe aclr
wire sign_reg_a_clr,sign_pipe_a_clr;                                      // signa reg/pipe aclr
wire sign_reg_b_clr,sign_pipe_b_clr;                                      // signb reg/pipe aclr
wire multiplier_reg0_clr,multiplier_reg1_clr,multiplier_reg2_clr,multiplier_reg3_clr;
                                                                          // multiplier reg aclr
wire output_reg_clr;                                                      // output register aclr

// Clock enables
wire input_reg_a0_en,input_reg_a1_en,input_reg_a2_en,input_reg_a3_en;     // input A reg enable
wire input_reg_b0_en,input_reg_b1_en,input_reg_b2_en,input_reg_b3_en;     // input B reg enable
wire addsub1_reg_en,addsub1_pipe_en;                                      // addnsub1 reg/pipe enable
wire addsub3_reg_en,addsub3_pipe_en;                                      // addnsub3 reg/pipe enable
wire sign_reg_a_en,sign_pipe_a_en;                                        // signa reg/pipe enable
wire sign_reg_b_en,sign_pipe_b_en;                                        // signb reg/pipe enable
wire multiplier_reg0_en,multiplier_reg1_en,multiplier_reg2_en,multiplier_reg3_en;
                                          // multiplier reg enable
wire output_reg_en;                       // output register enable

// Sign bits
wire signa_rev,signb_rev;

wire signa_in_reg,signa_in_pipe;          // signa reg/pipe
wire signa_reg,signa_pipe;
wire signb_in_reg,signb_in_pipe;          // signb reg/pipe
wire signb_reg,signb_pipe;

wire addnsub1_rev,addnsub3_rev;

wire addsub1_in_reg,addsub1_in_pipe;      // addsub1 reg/pipe
wire addsub1_reg,addsub1_pipe;
wire addsub3_in_reg,addsub3_in_pipe;      // addsub3 reg/pipe
wire addsub3_reg,addsub3_pipe;

// Multiplier inputs

wire signed [width_a - 1 : 0] mult1_a_in,mult2_a_in,mult3_a_in,mult4_a_in;
wire signed [width_b - 1 : 0] mult1_b_in,mult2_b_in,mult3_b_in,mult4_b_in;


// Multiplier registered inputs

wire signed [width_a - 1 : 0] mult1_a_reg_in,mult2_a_reg_in,mult3_a_reg_in,mult4_a_reg_in;
wire signed [width_a - 1 : 0] mult1_a_reg,mult2_a_reg,mult3_a_reg,mult4_a_reg;
wire signed [width_b - 1 : 0] mult1_b_reg_in,mult2_b_reg_in,mult3_b_reg_in,mult4_b_reg_in;
wire signed [width_b - 1 : 0] mult1_b_reg,mult2_b_reg,mult3_b_reg,mult4_b_reg;

wire signed [(4*width_a) - 1 : 0] mult_a_reg_in;
wire signed [(4*width_b) - 1 : 0] mult_b_reg_in;

// rounding and saturation
wire mult01_round_clk, mult01_round_en, mult01_round_clr;
wire mult01_round_in_reg, mult01_round_signal_reg;
wire mult23_round_clk, mult23_round_en, mult23_round_clr;
wire mult23_round_in_reg, mult23_round_signal_reg;

wire mult01_saturation_clk, mult01_saturation_en, mult01_saturation_clr;
wire mult01_saturation_in_reg, mult01_saturation_signal_reg;
wire mult23_saturation_clk, mult23_saturation_en, mult23_saturation_clr;
wire mult23_saturation_in_reg, mult23_saturation_signal_reg;

wire addnsub1_round_clk, addnsub1_round_en, addnsub1_round_clr;
wire addnsub1_round_in_reg, addnsub1_round_signal_reg;
wire addnsub1_round_pipe_clk, addnsub1_round_pipe_en, addnsub1_round_pipe_clr;
wire addnsub1_round_pipe_in_reg, addnsub1_round_pipe_signal_reg;

wire addnsub3_round_clk, addnsub3_round_en, addnsub3_round_clr;
wire addnsub3_round_in_reg, addnsub3_round_signal_reg;
wire addnsub3_round_pipe_clk, addnsub3_round_pipe_en, addnsub3_round_pipe_clr;
wire addnsub3_round_pipe_in_reg, addnsub3_round_pipe_signal_reg;

// Multiplier outputs

wire signed [width_a + width_b - 1 : 0] mult1_out,mult2_out,mult3_out,mult4_out;
wire signed [4*(width_a + width_b) - 1 : 0] mult_out;

// Multiplier registered outputs

wire signed [width_a + width_b - 1 : 0] mult1_reg,mult2_reg,mult3_reg,mult4_reg;
wire signed [width_a + width_b - 1 : 0] mult1_reg_out,mult2_reg_out,mult3_reg_out,mult4_reg_out;

// Multiplier round/saturate 
wire signed [4*(width_a + width_b) - 1 : 0] mult_rs_out;
wire mult1_sat_overflow, mult2_sat_overflow, mult3_sat_overflow, mult4_sat_overflow;
wire mult1_sat_reg_out, mult2_sat_reg_out, mult3_sat_reg_out, mult4_sat_reg_out;
wire mult1_sat_reg, mult2_sat_reg, mult3_sat_reg, mult4_sat_reg;

// Addsub block outputs

wire signed [width_l1addrout - 1 : 0] addsub1_out,addsub3_out;
wire signed [width_l1addrout - 1 : 0] addsub1_rs_out,addsub3_rs_out;
wire signed [width_l1addrout - 1 : 0] addsub1_addblock_out,addsub3_addblock_out;

// Output

wire signed [width_l2addrout - 1 : 0] add_out,add_reg_out;
wire signed [width_l2addrout - 1 : 0] add_reg;
wire addr11_sumsign, addr12_sumsign, extend_bit;
wire extend_bit_pre;

// IMPLEMENTATION BEGIN
//////////////////////////// asynchronous logic ////////////////////////////////////////

// ************** Multipliers      *************** //

generate 
genvar m;
    for (m = 0; m < number_of_multipliers; m=m+1) begin:mlt
	mult_block #(
		width_a,
		width_b,
		normalized_width
	) mult (
		.dataa(mult_a_reg_in[(m+1)*width_a - 1:m*width_a]),
		.datab(mult_b_reg_in[(m+1)*width_b - 1:m*width_b]),
		.signa(signa_reg),.signb(signb_reg),
		.product(mult_out[(m+1)*(width_a + width_b) - 1 : m*(width_a + width_b)])
		);
    end
endgenerate

generate
if(mult01_rs_enabled)
    assign mult1_out = mult_rs_out[width_a+width_b-1 : 0] ;
else
    assign mult1_out = mult_out[width_a+width_b-1 : 0]; 
endgenerate

generate 
if ((number_of_multipliers > 1) && (mult01_rs_enabled))
    assign mult2_out = mult_rs_out[2*(width_a+width_b)-1 : width_a+width_b];
else if(number_of_multipliers > 1)
    assign mult2_out = mult_out[2*(width_a+width_b)-1 : width_a+width_b];
else 
    assign mult2_out = 'b0;
endgenerate

generate
if ((number_of_multipliers > 2) && (mult23_rs_enabled))
    assign mult3_out = mult_rs_out[3*(width_a+width_b)-1 : 2*(width_a+width_b)];
else if (number_of_multipliers > 2)
    assign mult3_out = mult_out[3*(width_a+width_b)-1 : 2*(width_a+width_b)]; 
else 
    assign mult3_out = 'b0;
endgenerate

generate
if ((number_of_multipliers > 3) && (mult23_rs_enabled))
    assign mult4_out = mult_rs_out[4*(width_a+width_b)-1 : 3*(width_a+width_b)];
else if (number_of_multipliers > 3)
      assign mult4_out = mult_out[4*(width_a+width_b)-1 : 3*(width_a+width_b)];
else
      assign mult4_out = 'b0;
endgenerate

// ************** Round/Saturate ******************** //
generate
if (mult01_rs_enabled)
begin
rs_block #( `W_SIGN, width_a+width_b, `W_FRACTION_ROUND) mult1_rs (
	.round(multiplier01_rounding == "YES" || (multiplier01_rounding == "VARIABLE" && mult01_round_signal_reg == 1'b1)),
	.saturate(multiplier01_saturation == "YES" || (multiplier01_saturation == "VARIABLE" && mult01_saturation_signal_reg==1'b1)),
	.datain(mult_out[width_a + width_b - 1:0]),
	.sign(signa_reg|signb_reg),
	.rs_output(mult_rs_out[width_a + width_b - 1:0]),
	.sat_overflow(mult1_sat_overflow)
	);

end
endgenerate

generate
if (mult01_rs_enabled && number_of_multipliers > 1)
begin
rs_block #(`W_SIGN, width_a+width_b, `W_FRACTION_ROUND) mult2_rs (
	.round(multiplier01_rounding == "YES" || (multiplier01_rounding == "VARIABLE" && mult01_round_signal_reg == 1'b1)),
	.saturate(multiplier01_saturation == "YES" || (multiplier01_saturation == "VARIABLE" && mult01_saturation_signal_reg==1'b1)),
	.datain(mult_out[2*(width_a + width_b) - 1:width_a + width_b]),
	.sign(signa_reg|signb_reg),
	.rs_output(mult_rs_out[2*(width_a + width_b) - 1:width_a + width_b]),
	.sat_overflow(mult2_sat_overflow)
	);

end
endgenerate

generate
if (mult23_rs_enabled && number_of_multipliers > 2)
begin
rs_block #(`W_SIGN, width_a+width_b, `W_FRACTION_ROUND) mult3_rs (
	.round(multiplier23_rounding == "YES" || (multiplier23_rounding == "VARIABLE" && mult23_round_signal_reg == 1'b1)),
	.saturate(multiplier23_saturation == "YES" || (multiplier23_saturation == "VARIABLE" && mult23_saturation_signal_reg==1'b1)),
	.datain(mult_out[3*(width_a+width_b)-1 : 2*(width_a+width_b)]),
	.sign(signa_reg|signb_reg),
	.rs_output(mult_rs_out[3*(width_a+width_b)-1 : 2*(width_a+width_b)]),
	.sat_overflow(mult3_sat_overflow)
	);

end
endgenerate

generate
if (mult23_rs_enabled && number_of_multipliers > 3)
begin
rs_block #(`W_SIGN, width_a+width_b, `W_FRACTION_ROUND) mult4_rs (
	.round(multiplier23_rounding == "YES" || (multiplier23_rounding == "VARIABLE" && mult23_round_signal_reg == 1'b1)),
	.saturate(multiplier23_saturation == "YES" || (multiplier23_saturation == "VARIABLE" && mult23_saturation_signal_reg==1'b1)),
	.datain(mult_out[4*(width_a+width_b)-1 : 3*(width_a+width_b)]),
	.sign(signa_reg|signb_reg),
	.rs_output(mult_rs_out[4*(width_a+width_b)-1 : 3*(width_a+width_b)]),
	.sat_overflow(mult4_sat_overflow)
	);

end
endgenerate

// ************** Addsub block ******************** //

addsub_block #(width_a+width_b, width_a+width_b) adder11 (
	.dataa(mult1_reg_out),
	.datab(mult2_reg_out),
	.signa(signa_pipe|signb_pipe),
	.signb(signa_pipe|signb_pipe),
	.addsub(addsub1_pipe),
	.sum(addsub1_addblock_out),
	.sumsign(addr11_sumsign)
	);

generate
if (adder1_rounding !="NO")
begin
rs_block #(`W_SIGN+1, width_l1addrout, `W_FRACTION_ROUND) addr11_rs (
	.round(adder1_rounding=="YES" || (adder1_rounding=="VARIABLE" && addnsub1_round_pipe_signal_reg==1'b1)),
	.saturate(1'b0),
	.datain(addsub1_addblock_out),
	.sign(signa_pipe | signb_pipe),
	.rs_output(addsub1_rs_out),
	.sat_overflow()
	);

	assign addsub1_out = addsub1_rs_out;
end
else
	assign addsub1_out = addsub1_addblock_out;
endgenerate

addsub_block #(width_a+width_b, width_a+width_b) adder12 (
	.dataa(mult3_reg_out),
	.datab(mult4_reg_out),
	.signa(signa_pipe|signb_pipe),
	.signb(signa_pipe|signb_pipe),
	.addsub(addsub3_pipe),
	.sum(addsub3_addblock_out),
	.sumsign(addr12_sumsign)
	);

generate
if (adder3_rounding !="NO")
begin
rs_block #(`W_SIGN+1, width_l1addrout, `W_FRACTION_ROUND) addr12_rs (
	.round(adder3_rounding=="YES" || (adder3_rounding=="VARIABLE" && addnsub3_round_pipe_signal_reg==1'b1)),
	.saturate(1'b0),
	.datain(addsub3_addblock_out),
	.sign(signa_pipe | signb_pipe),
	.rs_output(addsub3_rs_out),
	.sat_overflow()
);

	assign addsub3_out = addsub3_rs_out ;
end
else
	assign addsub3_out = addsub3_addblock_out;
endgenerate

addsub_block #(width_l1addrout, width_l1addrout) adder2 (
	.dataa(addsub1_out),
	.datab(addsub3_out),    
	.signa(signa_pipe | signb_pipe | addr11_sumsign ),
	.signb(signa_pipe | signb_pipe | addr12_sumsign ),       
	.addsub(1'b1), 
	.sum(add_out),
	.sumsign(addr2signout)
);

/////////////////////////// net assignments //////////////////////////


// input A register clocks

assign input_reg_a0_clk =
        ((input_register_a0 == "CLOCK0") ? clock0
                : ((input_register_a0 == "CLOCK1") ? clock1
                        : ((input_register_a0 == "CLOCK2") ? clock2
                                : ((input_register_a0 == "CLOCK3") ? clock3
                                : 1'b0))));


assign input_reg_a1_clk = 
	((input_register_a1 == "CLOCK0") ? clock0
		: ((input_register_a1 == "CLOCK1") ? clock1 
			: ((input_register_a1 == "CLOCK2") ? clock2
				: ((input_register_a1 == "CLOCK3") ? clock3
				: 1'b0))));


assign input_reg_a2_clk = 
	((input_register_a2 == "CLOCK0") ? clock0
		: ((input_register_a2 == "CLOCK1") ? clock1 
			: ((input_register_a2 == "CLOCK2") ? clock2
				: ((input_register_a2 == "CLOCK3") ? clock3
				: 1'b0))));


assign input_reg_a3_clk = 
	((input_register_a3 == "CLOCK0") ? clock0
		: ((input_register_a3 == "CLOCK1") ? clock1 
			: ((input_register_a3 == "CLOCK2") ? clock2
				: ((input_register_a3 == "CLOCK3") ? clock3
				: 1'b0))));

// input B register clocks

assign input_reg_b0_clk =
        ((input_register_b0 == "CLOCK0") ? clock0
                : ((input_register_b0 == "CLOCK1") ? clock1
                        : ((input_register_b0 == "CLOCK2") ? clock2
                                : ((input_register_b0 == "CLOCK3") ? clock3
                                : 1'b0))));


assign input_reg_b1_clk = 
	((input_register_b1 == "CLOCK0") ? clock0
		: ((input_register_b1 == "CLOCK1") ? clock1 
			: ((input_register_b1 == "CLOCK2") ? clock2
				: ((input_register_b1 == "CLOCK3") ? clock3
				: 1'b0))));


assign input_reg_b2_clk = 
	((input_register_b2 == "CLOCK0") ? clock0
		: ((input_register_b2 == "CLOCK1") ? clock1 
			: ((input_register_b2 == "CLOCK2") ? clock2
				: ((input_register_b2 == "CLOCK3") ? clock3
				: 1'b0))));


assign input_reg_b3_clk = 
	((input_register_b3 == "CLOCK0") ? clock0
		: ((input_register_b3 == "CLOCK1") ? clock1 
			: ((input_register_b3 == "CLOCK2") ? clock2
				: ((input_register_b3 == "CLOCK3") ? clock3
				: 1'b0))));

// addsub register clocks
assign addsub1_reg_clk = 
	((addnsub_multiplier_register1 == "CLOCK0") ? clock0
		: ((addnsub_multiplier_register1 == "CLOCK1") ? clock1 
			: ((addnsub_multiplier_register1 == "CLOCK2") ? clock2
				: ((addnsub_multiplier_register1 == "CLOCK3") ? clock3
				: 1'b0))));


assign addsub1_pipe_clk = 
	((addnsub_multiplier_pipeline_register1 == "CLOCK0") ? clock0
		: ((addnsub_multiplier_pipeline_register1 == "CLOCK1") ? clock1 
			: ((addnsub_multiplier_pipeline_register1 == "CLOCK2") ? clock2
				: ((addnsub_multiplier_pipeline_register1 == "CLOCK3") ? clock3
				: 1'b0))));


assign addsub3_reg_clk = 
	((addnsub_multiplier_register3 == "CLOCK0") ? clock0
		: ((addnsub_multiplier_register3 == "CLOCK1") ? clock1 
			: ((addnsub_multiplier_register3 == "CLOCK2") ? clock2
				: ((addnsub_multiplier_register3 == "CLOCK3") ? clock3
				: 1'b0))));


assign addsub3_pipe_clk = 
	((addnsub_multiplier_pipeline_register3 == "CLOCK0") ? clock0
		: ((addnsub_multiplier_pipeline_register3 == "CLOCK1") ? clock1 
			: ((addnsub_multiplier_pipeline_register3 == "CLOCK2") ? clock2
				: ((addnsub_multiplier_pipeline_register3 == "CLOCK3") ? clock3
				: 1'b0))));

// sign register clocks
assign sign_reg_a_clk = 
	((signed_register_a == "CLOCK0") ? clock0
		: ((signed_register_a == "CLOCK1") ? clock1 
			: ((signed_register_a == "CLOCK2") ? clock2
				: ((signed_register_a == "CLOCK3") ? clock3
				: 1'b0))));


assign sign_reg_b_clk = 
	((signed_register_b == "CLOCK0") ? clock0
		: ((signed_register_b == "CLOCK1") ? clock1 
			: ((signed_register_b == "CLOCK2") ? clock2
				: ((signed_register_b == "CLOCK3") ? clock3
				: 1'b0))));


assign sign_pipe_a_clk = 
	((signed_pipeline_register_a == "CLOCK0") ? clock0
		: ((signed_pipeline_register_a == "CLOCK1") ? clock1 
			: ((signed_pipeline_register_a == "CLOCK2") ? clock2
				: ((signed_pipeline_register_a == "CLOCK3") ? clock3
				: 1'b0))));


assign sign_pipe_b_clk = 
	((signed_pipeline_register_b == "CLOCK0") ? clock0
		: ((signed_pipeline_register_b == "CLOCK1") ? clock1 
			: ((signed_pipeline_register_b == "CLOCK2") ? clock2
				: ((signed_pipeline_register_b == "CLOCK3") ? clock3
				: 1'b0))));

// multiplier register clocks

assign multiplier_reg0_clk =
        ((multiplier_register0 == "CLOCK0") ? clock0
                : ((multiplier_register0 == "CLOCK1") ? clock1
                        : ((multiplier_register0 == "CLOCK2") ? clock2
                                : ((multiplier_register0 == "CLOCK3") ? clock3
                                : 1'b0))));


assign multiplier_reg1_clk = 
	((multiplier_register1 == "CLOCK0") ? clock0
		: ((multiplier_register1 == "CLOCK1") ? clock1 
			: ((multiplier_register1 == "CLOCK2") ? clock2
				: ((multiplier_register1 == "CLOCK3") ? clock3
				: 1'b0))));


assign multiplier_reg2_clk = 
	((multiplier_register2 == "CLOCK0") ? clock0
		: ((multiplier_register2 == "CLOCK1") ? clock1 
			: ((multiplier_register2 == "CLOCK2") ? clock2
				: ((multiplier_register2 == "CLOCK3") ? clock3
				: 1'b0))));


assign multiplier_reg3_clk = 
	((multiplier_register3 == "CLOCK0") ? clock0
		: ((multiplier_register3 == "CLOCK1") ? clock1 
			: ((multiplier_register3 == "CLOCK2") ? clock2
				: ((multiplier_register3 == "CLOCK3") ? clock3
				: 1'b0))));

// output register clocks
assign output_reg_clk = 
	((output_register == "CLOCK0") ? clock0
		: ((output_register == "CLOCK1") ? clock1 
			: ((output_register == "CLOCK2") ? clock2
				: ((output_register == "CLOCK3") ? clock3
				: 1'b0))));

// input register clear signals

assign input_reg_a0_clr =
        ((input_aclr_a0 == "ACLR0") ? aclr0
                : ((input_aclr_a0 == "ACLR1") ? aclr1
                        : ((input_aclr_a0 == "ACLR2") ? aclr2
                                : ((input_aclr_a0 == "ACLR3") ? aclr3
                                : 1'b0))));

assign input_reg_a1_clr = 
	((input_aclr_a1 == "ACLR0") ? aclr0
                : ((input_aclr_a1 == "ACLR1") ? aclr1
                        : ((input_aclr_a1 == "ACLR2") ? aclr2
                                : ((input_aclr_a1 == "ACLR3") ? aclr3
                                : 1'b0))));


assign input_reg_a2_clr = 
	((input_aclr_a2 == "ACLR0") ? aclr0
                : ((input_aclr_a2 == "ACLR1") ? aclr1
                        : ((input_aclr_a2 == "ACLR2") ? aclr2
                                : ((input_aclr_a2 == "ACLR3") ? aclr3
                                : 1'b0))));


assign input_reg_a3_clr = 
	((input_aclr_a3 == "ACLR0") ? aclr0
                : ((input_aclr_a3 == "ACLR1") ? aclr1
                        : ((input_aclr_a3 == "ACLR2") ? aclr2
                                : ((input_aclr_a3 == "ACLR3") ? aclr3
                                : 1'b0))));

assign input_reg_b0_clr =
        ((input_aclr_b0 == "ACLR0") ? aclr0
                : ((input_aclr_b0 == "ACLR1") ? aclr1
                        : ((input_aclr_b0 == "ACLR2") ? aclr2
                                : ((input_aclr_b0 == "ACLR3") ? aclr3
                                : 1'b0))));


assign input_reg_b1_clr = 
	((input_aclr_b1 == "ACLR0") ? aclr0
                : ((input_aclr_b1 == "ACLR1") ? aclr1
                        : ((input_aclr_b1 == "ACLR2") ? aclr2
                                : ((input_aclr_b1 == "ACLR3") ? aclr3
                                : 1'b0))));


assign input_reg_b2_clr = 
	((input_aclr_b2 == "ACLR0") ? aclr0
                : ((input_aclr_b2 == "ACLR1") ? aclr1
                        : ((input_aclr_b2 == "ACLR2") ? aclr2
                                : ((input_aclr_b2 == "ACLR3") ? aclr3
                                : 1'b0))));


assign input_reg_b3_clr = 
	((input_aclr_b3 == "ACLR0") ? aclr0
                : ((input_aclr_b3 == "ACLR1") ? aclr1
                        : ((input_aclr_b3 == "ACLR2") ? aclr2
                                : ((input_aclr_b3 == "ACLR3") ? aclr3
                                : 1'b0))));

// addsub register clear signals
assign addsub1_reg_clr = 
	((addnsub_multiplier_aclr1 == "ACLR0") ? aclr0
                : ((addnsub_multiplier_aclr1 == "ACLR1") ? aclr1
                        : ((addnsub_multiplier_aclr1 == "ACLR2") ? aclr2
                                : ((addnsub_multiplier_aclr1 == "ACLR3") ? aclr3
                                : 1'b0))));


assign addsub1_pipe_clr = 
	((addnsub_multiplier_pipeline_aclr1 == "ACLR0") ? aclr0
                : ((addnsub_multiplier_pipeline_aclr1 == "ACLR1") ? aclr1
                        : ((addnsub_multiplier_pipeline_aclr1 == "ACLR2") ? aclr2
                                : ((addnsub_multiplier_pipeline_aclr1 == "ACLR3") ? aclr3
                                : 1'b0))));


assign addsub3_reg_clr = 
	((addnsub_multiplier_aclr3 == "ACLR0") ? aclr0
                : ((addnsub_multiplier_aclr3 == "ACLR1") ? aclr1
                        : ((addnsub_multiplier_aclr3 == "ACLR2") ? aclr2
                                : ((addnsub_multiplier_aclr3 == "ACLR3") ? aclr3
                                : 1'b0))));


assign addsub3_pipe_clr = 
	((addnsub_multiplier_pipeline_aclr3 == "ACLR0") ? aclr0
                : ((addnsub_multiplier_pipeline_aclr3 == "ACLR1") ? aclr1
                        : ((addnsub_multiplier_pipeline_aclr3 == "ACLR2") ? aclr2
                                : ((addnsub_multiplier_pipeline_aclr3 == "ACLR3") ? aclr3
                                : 1'b0))));

// sign register/pipe clear signals
assign sign_reg_a_clr = 
	((signed_aclr_a == "ACLR0") ? aclr0
                : ((signed_aclr_a == "ACLR1") ? aclr1
                        : ((signed_aclr_a == "ACLR2") ? aclr2
                                : ((signed_aclr_a == "ACLR3") ? aclr3
                                : 1'b0))));


assign sign_reg_b_clr = 
	((signed_aclr_b == "ACLR0") ? aclr0
                : ((signed_aclr_b == "ACLR1") ? aclr1
                        : ((signed_aclr_b == "ACLR2") ? aclr2
                                : ((signed_aclr_b == "ACLR3") ? aclr3
                                : 1'b0))));


assign sign_pipe_a_clr = 
	((signed_pipeline_aclr_a == "ACLR0") ? aclr0
                : ((signed_pipeline_aclr_a == "ACLR1") ? aclr1
                        : ((signed_pipeline_aclr_a == "ACLR2") ? aclr2
                                : ((signed_pipeline_aclr_a == "ACLR3") ? aclr3
                                : 1'b0))));


assign sign_pipe_b_clr = 
	((signed_pipeline_aclr_b == "ACLR0") ? aclr0
                : ((signed_pipeline_aclr_b == "ACLR1") ? aclr1
                        : ((signed_pipeline_aclr_b == "ACLR2") ? aclr2
                                : ((signed_pipeline_aclr_b == "ACLR3") ? aclr3
                                : 1'b0))));

// multiplier register clear signals

assign multiplier_reg0_clr =
        ((multiplier_aclr0 == "ACLR0") ? aclr0
                : ((multiplier_aclr0 == "ACLR1") ? aclr1
                        : ((multiplier_aclr0 == "ACLR2") ? aclr2
                                : ((multiplier_aclr0 == "ACLR3") ? aclr3
                                : 1'b0))));


assign multiplier_reg1_clr = 
	((multiplier_aclr1 == "ACLR0") ? aclr0
                : ((multiplier_aclr1 == "ACLR1") ? aclr1
                        : ((multiplier_aclr1 == "ACLR2") ? aclr2
                                : ((multiplier_aclr1 == "ACLR3") ? aclr3
                                : 1'b0))));


assign multiplier_reg2_clr = 
	((multiplier_aclr2 == "ACLR0") ? aclr0
                : ((multiplier_aclr2 == "ACLR1") ? aclr1
                        : ((multiplier_aclr2 == "ACLR2") ? aclr2
                                : ((multiplier_aclr2 == "ACLR3") ? aclr3
                                : 1'b0))));


assign multiplier_reg3_clr = 
	((multiplier_aclr3 == "ACLR0") ? aclr0
                : ((multiplier_aclr3 == "ACLR1") ? aclr1
                        : ((multiplier_aclr3 == "ACLR2") ? aclr2
                                : ((multiplier_aclr3 == "ACLR3") ? aclr3
                                : 1'b0))));

// output register clear signals
assign output_reg_clr = 
	((output_aclr == "ACLR0") ? aclr0
                : ((output_aclr == "ACLR1") ? aclr1
                        : ((output_aclr == "ACLR2") ? aclr2
                                : ((output_aclr == "ACLR3") ? aclr3
                                : 1'b0))));

// input register enables

assign input_reg_a0_en =
        ((input_register_a0 == "CLOCK0") ? ena0
                : ((input_register_a0 == "CLOCK1") ? ena1
                        : ((input_register_a0 == "CLOCK2") ? ena2
                                : ((input_register_a0 == "CLOCK3") ? ena3
                                : 1'b1))));


assign input_reg_a1_en = 
	((input_register_a1 == "CLOCK0") ? ena0 
                : ((input_register_a1 == "CLOCK1") ? ena1
                        : ((input_register_a1 == "CLOCK2") ? ena2
                                : ((input_register_a1 == "CLOCK3") ? ena3
                                : 1'b1))));


assign input_reg_a2_en = 
	((input_register_a2 == "CLOCK0") ? ena0 
                : ((input_register_a2 == "CLOCK1") ? ena1
                        : ((input_register_a2 == "CLOCK2") ? ena2
                                : ((input_register_a2 == "CLOCK3") ? ena3
                                : 1'b1))));


assign input_reg_a3_en = 
	((input_register_a3 == "CLOCK0") ? ena0 
                : ((input_register_a3 == "CLOCK1") ? ena1
                        : ((input_register_a3 == "CLOCK2") ? ena2
                                : ((input_register_a3 == "CLOCK3") ? ena3
                                : 1'b1))));

assign input_reg_b0_en =
        ((input_register_b0 == "CLOCK0") ? ena0
                : ((input_register_b0 == "CLOCK1") ? ena1
                        : ((input_register_b0 == "CLOCK2") ? ena2
                                : ((input_register_b0 == "CLOCK3") ? ena3
                                : 1'b1))));

assign input_reg_b1_en = 
	((input_register_b1 == "CLOCK0") ? ena0 
                : ((input_register_b1 == "CLOCK1") ? ena1
                        : ((input_register_b1 == "CLOCK2") ? ena2
                                : ((input_register_b1 == "CLOCK3") ? ena3
                                : 1'b1))));


assign input_reg_b2_en = 
	((input_register_b2 == "CLOCK0") ? ena0 
                : ((input_register_b2 == "CLOCK1") ? ena1
                        : ((input_register_b2 == "CLOCK2") ? ena2
                                : ((input_register_b2 == "CLOCK3") ? ena3
                                : 1'b1))));


assign input_reg_b3_en = 
	((input_register_b3 == "CLOCK0") ? ena0 
                : ((input_register_b3 == "CLOCK1") ? ena1
                        : ((input_register_b3 == "CLOCK2") ? ena2
                                : ((input_register_b3 == "CLOCK3") ? ena3
                                : 1'b1))));

// addsub register enables
assign addsub1_reg_en = 
	((addnsub_multiplier_register1 == "CLOCK0") ? ena0 
                : ((addnsub_multiplier_register1 == "CLOCK1") ? ena1
                        : ((addnsub_multiplier_register1 == "CLOCK2") ? ena2
                                : ((addnsub_multiplier_register1 == "CLOCK3") ? ena3
                                : 1'b1))));


assign addsub1_pipe_en = 
	((addnsub_multiplier_pipeline_register1 == "CLOCK0") ? ena0 
                : ((addnsub_multiplier_pipeline_register1 == "CLOCK1") ? ena1
                        : ((addnsub_multiplier_pipeline_register1 == "CLOCK2") ? ena2
                                : ((addnsub_multiplier_pipeline_register1 == "CLOCK3") ? ena3
                                : 1'b1))));


assign addsub3_reg_en = 
	((addnsub_multiplier_register3 == "CLOCK0") ? ena0 
                : ((addnsub_multiplier_register3 == "CLOCK1") ? ena1
                        : ((addnsub_multiplier_register3 == "CLOCK2") ? ena2
                                : ((addnsub_multiplier_register3 == "CLOCK3") ? ena3
                                : 1'b1))));


assign addsub3_pipe_en = 
	((addnsub_multiplier_pipeline_register3 == "CLOCK0") ? ena0 
                : ((addnsub_multiplier_pipeline_register3 == "CLOCK1") ? ena1
                        : ((addnsub_multiplier_pipeline_register3 == "CLOCK2") ? ena2
                                : ((addnsub_multiplier_pipeline_register3 == "CLOCK3") ? ena3
                                : 1'b1))));

// sign register enables
assign sign_reg_a_en = 
	((signed_register_a == "CLOCK0") ? ena0 
                : ((signed_register_a == "CLOCK1") ? ena1
                        : ((signed_register_a == "CLOCK2") ? ena2
                                : ((signed_register_a == "CLOCK3") ? ena3
                                : 1'b1))));


assign sign_reg_b_en = 
	((signed_register_b == "CLOCK0") ? ena0 
                : ((signed_register_b == "CLOCK1") ? ena1
                        : ((signed_register_b == "CLOCK2") ? ena2
                                : ((signed_register_b == "CLOCK3") ? ena3
                                : 1'b1))));


assign sign_pipe_a_en = 
	((signed_pipeline_register_a == "CLOCK0") ? ena0 
                : ((signed_pipeline_register_a == "CLOCK1") ? ena1
                        : ((signed_pipeline_register_a == "CLOCK2") ? ena2
                                : ((signed_pipeline_register_a == "CLOCK3") ? ena3
                                : 1'b1))));


assign sign_pipe_b_en = 
	((signed_pipeline_register_b == "CLOCK0") ? ena0 
                : ((signed_pipeline_register_b == "CLOCK1") ? ena1
                        : ((signed_pipeline_register_b == "CLOCK2") ? ena2
                                : ((signed_pipeline_register_b == "CLOCK3") ? ena3
                                : 1'b1))));

// multiplier register enables

assign multiplier_reg0_en =
        ((multiplier_register0 == "CLOCK0") ? ena0
                : ((multiplier_register0 == "CLOCK1") ? ena1
                        : ((multiplier_register0 == "CLOCK2") ? ena2
                                : ((multiplier_register0 == "CLOCK3") ? ena3
                                : 1'b1))));

assign multiplier_reg1_en = 
	((multiplier_register1 == "CLOCK0") ? ena0 
                : ((multiplier_register1 == "CLOCK1") ? ena1
                        : ((multiplier_register1 == "CLOCK2") ? ena2
                                : ((multiplier_register1 == "CLOCK3") ? ena3
                                : 1'b1))));


assign multiplier_reg2_en = 
	((multiplier_register2 == "CLOCK0") ? ena0 
                : ((multiplier_register2 == "CLOCK1") ? ena1
                        : ((multiplier_register2 == "CLOCK2") ? ena2
                                : ((multiplier_register2 == "CLOCK3") ? ena3
                                : 1'b1))));


assign multiplier_reg3_en = 
	((multiplier_register3 == "CLOCK0") ? ena0 
                : ((multiplier_register3 == "CLOCK1") ? ena1
                        : ((multiplier_register3 == "CLOCK2") ? ena2
                                : ((multiplier_register3 == "CLOCK3") ? ena3
                                : 1'b1))));

// output register enables
assign output_reg_en = 
	((output_register == "CLOCK0") ? ena0 
                : ((output_register == "CLOCK1") ? ena1
                        : ((output_register == "CLOCK2") ? ena2
                                : ((output_register == "CLOCK3") ? ena3
                                : 1'b1))));

// rounding and saturation control signals 
// mult01 round clk
assign mult01_round_clk =
        ((mult01_round_register == "CLOCK0") ? clock0
                : ((mult01_round_register == "CLOCK1") ? clock1
                        : ((mult01_round_register == "CLOCK2") ? clock2
                                : ((mult01_round_register == "CLOCK3") ? clock3
                                : 1'b0))));

// mult round en
assign mult01_round_en =
        ((mult01_round_register == "CLOCK0") ? ena0
                : ((mult01_round_register == "CLOCK1") ? ena1
                        : ((mult01_round_register == "CLOCK2") ? ena2
                                : ((mult01_round_register == "CLOCK3") ? ena3
                                : 1'b0))));

// mult round clear
assign mult01_round_clr =
        ((mult01_round_aclr == "ACLR0") ? aclr0
                : ((mult01_round_aclr == "ACLR1") ? aclr1
                        : ((mult01_round_aclr == "ACLR2") ? aclr2
                                : ((mult01_round_aclr == "ACLR3") ? aclr3
                                : 1'b0))));

// mult23 round clk
assign mult23_round_clk =
        ((mult23_round_register == "CLOCK0") ? clock0
                : ((mult23_round_register == "CLOCK1") ? clock1
                        : ((mult23_round_register == "CLOCK2") ? clock2
                                : ((mult23_round_register == "CLOCK3") ? clock3
                                : 1'b0))));

// mult round en
assign mult23_round_en =
        ((mult23_round_register == "CLOCK0") ? ena0
                : ((mult23_round_register == "CLOCK1") ? ena1
                        : ((mult23_round_register == "CLOCK2") ? ena2
                                : ((mult23_round_register == "CLOCK3") ? ena3
                                : 1'b0))));

// mult round clear
assign mult23_round_clr =
        ((mult23_round_aclr == "ACLR0") ? aclr0
                : ((mult23_round_aclr == "ACLR1") ? aclr1
                        : ((mult23_round_aclr == "ACLR2") ? aclr2
                                : ((mult23_round_aclr == "ACLR3") ? aclr3
                                : 1'b0))));

// mult01 saturation clk
assign mult01_saturation_clk =
    ((mult01_saturation_register == "CLOCK0") ? clock0
        : ((mult01_saturation_register == "CLOCK1") ? clock1
              : ((mult01_saturation_register == "CLOCK2") ? clock2
                    : ((mult01_saturation_register == "CLOCK3") ? clock3
                          : 1'b0))));

// mult01 saturation en
assign mult01_saturation_en =
    ((mult01_saturation_register == "CLOCK0") ? ena0
        : ((mult01_saturation_register == "CLOCK1") ? ena1
              : ((mult01_saturation_register == "CLOCK2") ? ena2
                    : ((mult01_saturation_register == "CLOCK3") ? ena3
                          : 1'b0))));

// mult01 saturation clear
assign mult01_saturation_clr =
    ((mult01_saturation_aclr == "ACLR0") ? aclr0
        : ((mult01_saturation_aclr == "ACLR1") ? aclr1
              : ((mult01_saturation_aclr == "ACLR2") ? aclr2
                    : ((mult01_saturation_aclr == "ACLR3") ? aclr3
                          : 1'b0))));


// mult23 saturation clk
assign mult23_saturation_clk =
    ((mult23_saturation_register == "CLOCK0") ? clock0
        : ((mult23_saturation_register == "CLOCK1") ? clock1
              : ((mult23_saturation_register == "CLOCK2") ? clock2
                    : ((mult23_saturation_register == "CLOCK3") ? clock3
                          : 1'b0))));

// mult23 saturation en
assign mult23_saturation_en =
    ((mult23_saturation_register == "CLOCK0") ? ena0
        : ((mult23_saturation_register == "CLOCK1") ? ena1
              : ((mult23_saturation_register == "CLOCK2") ? ena2
                    : ((mult23_saturation_register == "CLOCK3") ? ena3
                          : 1'b0))));

// mult23 saturation clear
assign mult23_saturation_clr =
    ((mult23_saturation_aclr == "ACLR0") ? aclr0
        : ((mult23_saturation_aclr == "ACLR1") ? aclr1
              : ((mult23_saturation_aclr == "ACLR2") ? aclr2
                    : ((mult23_saturation_aclr == "ACLR3") ? aclr3
                          : 1'b0))));

// addnsub1 round clk
assign addnsub1_round_clk =
    ((addnsub1_round_register == "CLOCK0") ? clock0
        : ((addnsub1_round_register == "CLOCK1") ? clock1
              : ((addnsub1_round_register == "CLOCK2") ? clock2
                    : ((addnsub1_round_register == "CLOCK3") ? clock3
                          : 1'b0))));

// addnsub1 round en
assign addnsub1_round_en =
    ((addnsub1_round_register == "CLOCK0") ? ena0
        : ((addnsub1_round_register == "CLOCK1") ? ena1
              : ((addnsub1_round_register == "CLOCK2") ? ena2
                    : ((addnsub1_round_register == "CLOCK3") ? ena3
                          : 1'b0))));

// addnsub1 round clear
assign addnsub1_round_clr =
    ((addnsub1_round_aclr == "ACLR0") ? aclr0
        : ((addnsub1_round_aclr == "ACLR1") ? aclr1
              : ((addnsub1_round_aclr == "ACLR2") ? aclr2
                    : ((addnsub1_round_aclr == "ACLR3") ? aclr3
                          : 1'b0))));

// addnsub1 round pipe clk
assign addnsub1_round_pipe_clk =
    ((addnsub1_round_pipeline_register == "CLOCK0") ? clock0
        : ((addnsub1_round_pipeline_register == "CLOCK1") ? clock1
              : ((addnsub1_round_pipeline_register == "CLOCK2") ? clock2
                    : ((addnsub1_round_pipeline_register == "CLOCK3") ? clock3
                          : 1'b0))));

// addnsub1 round pipe en
assign addnsub1_round_pipe_en =
    ((addnsub1_round_pipeline_register == "CLOCK0") ? ena0
        : ((addnsub1_round_pipeline_register == "CLOCK1") ? ena1
              : ((addnsub1_round_pipeline_register == "CLOCK2") ? ena2
                    : ((addnsub1_round_pipeline_register == "CLOCK3") ? ena3
                          : 1'b0))));

// addnsub1 round pipe clear
assign addnsub1_round_pipe_clr =
    ((addnsub1_round_pipeline_aclr == "ACLR0") ? aclr0
        : ((addnsub1_round_pipeline_aclr == "ACLR1") ? aclr1
              : ((addnsub1_round_pipeline_aclr == "ACLR2") ? aclr2
                    : ((addnsub1_round_pipeline_aclr == "ACLR3") ? aclr3
                          : 1'b0))));

// addnsub3 round clk
assign addnsub3_round_clk =
    ((addnsub3_round_register == "CLOCK0") ? clock0
        : ((addnsub3_round_register == "CLOCK1") ? clock1
              : ((addnsub3_round_register == "CLOCK2") ? clock2
                    : ((addnsub3_round_register == "CLOCK3") ? clock3
                          : 1'b0))));

// addnsub3 round en
assign addnsub3_round_en =
    ((addnsub3_round_register == "CLOCK0") ? ena0
        : ((addnsub3_round_register == "CLOCK1") ? ena1
              : ((addnsub3_round_register == "CLOCK2") ? ena2
                    : ((addnsub3_round_register == "CLOCK3") ? ena3
                          : 1'b0))));

// addnsub3 round clear
assign addnsub3_round_clr =
    ((addnsub3_round_aclr == "ACLR0") ? aclr0
        : ((addnsub3_round_aclr == "ACLR1") ? aclr1
              : ((addnsub3_round_aclr == "ACLR2") ? aclr2
                    : ((addnsub3_round_aclr == "ACLR3") ? aclr3
                          : 1'b0))));

// addnsub3 round pipe clk
assign addnsub3_round_pipe_clk =
    ((addnsub3_round_pipeline_register == "CLOCK0") ? clock0
        : ((addnsub3_round_pipeline_register == "CLOCK1") ? clock1
              : ((addnsub3_round_pipeline_register == "CLOCK2") ? clock2
                    : ((addnsub3_round_pipeline_register == "CLOCK3") ? clock3
                          : 1'b0))));

// addnsub3 round pipe en
assign addnsub3_round_pipe_en =
    ((addnsub3_round_pipeline_register == "CLOCK0") ? ena0
        : ((addnsub3_round_pipeline_register == "CLOCK1") ? ena1
              : ((addnsub3_round_pipeline_register == "CLOCK2") ? ena2
                    : ((addnsub3_round_pipeline_register == "CLOCK3") ? ena3
                          : 1'b0))));

// addnsub3 round pipe clear
assign addnsub3_round_pipe_clr =
    ((addnsub3_round_pipeline_aclr == "ACLR0") ? aclr0
        : ((addnsub3_round_pipeline_aclr == "ACLR1") ? aclr1
              : ((addnsub3_round_pipeline_aclr == "ACLR2") ? aclr2
                    : ((addnsub3_round_pipeline_aclr == "ACLR3") ? aclr3
                          : 1'b0))));


// ************** Output block ******************** //
generate
if (width_result > width_a+width_b+2)
begin
	assign result = {{(width_result-(width_a+width_b+2)){extend_bit}},add_reg_out};
end
else
   assign result = add_reg_out;
endgenerate

// ************** Dynamic Source Selection ********** //
assign dataa_in[width_a-1:0] = (input_source_a0 == "DATAA" || (
	input_source_a0 == "VARIABLE" && sourcea[0] == 1'b0))? 
		dataa[width_a-1:0] : scanina;

generate
if (number_of_multipliers > 1)
begin

assign dataa_in[2*width_a-1:width_a] = (
	(input_source_a1 == "DATAA" || 
	(input_source_a1 == "VARIABLE" && sourcea[1] == 1'b0))? 
		dataa[2*width_a-1:width_a] : mult1_a_reg_in );
end
else
assign dataa_in[2*width_a-1:width_a] = 'b0;
endgenerate

generate
if (number_of_multipliers > 2)
begin
assign dataa_in[3*width_a-1:2*width_a] = (
	(input_source_a2 == "DATAA" || 
	(input_source_a2 == "VARIABLE" && sourcea[2] == 1'b0))? 
		dataa[3*width_a-1:2*width_a] : mult2_a_reg_in );
end
else
assign dataa_in[3*width_a-1:2*width_a] = 'b0;
endgenerate

generate
if (number_of_multipliers > 3)
begin
assign dataa_in[4*width_a-1:3*width_a] = (
	(input_source_a3 == "DATAA" || 
	(input_source_a3 == "VARIABLE" && sourcea[3] == 1'b0))? 
		dataa[4*width_a-1:3*width_a] : mult3_a_reg_in ) ;
end
else
assign dataa_in[4*width_a-1:3*width_a] = 'b0;
endgenerate

assign datab_in[width_b-1:0] = (input_source_b0 == "DATAB" || 
        (input_source_b0 == "VARIABLE" && sourceb[0] == 1'b0))?
                datab[width_b-1:0] : scaninb;

generate
if (number_of_multipliers > 1)
begin
assign datab_in[2*width_b-1:width_b] =  (
	(input_source_b1 == "DATAB" ||
        (input_source_b1 == "VARIABLE" && sourceb[1] == 1'b0))?
                datab[2*width_b-1:width_b] : mult1_b_reg_in );
end
else
assign datab_in[2*width_b-1:width_b] = 'b0;
endgenerate

generate
if (number_of_multipliers > 2)
begin
assign datab_in[3*width_b-1:2*width_b] = (
	(input_source_b2 == "DATAB" || 
        (input_source_b2 == "VARIABLE" && sourceb[2] == 1'b0))?
                datab[3*width_b-1:2*width_b] : mult2_b_reg_in );
end
else
assign datab_in[3*width_b-1:2*width_b] = 'b0;
endgenerate

generate
if (number_of_multipliers > 3)
begin
assign datab_in[4*width_b-1:3*width_b] = (
	(input_source_b3 == "DATAB" || 
        (input_source_b3 == "VARIABLE" && sourceb[3] == 1'b0))?
                datab[4*width_b-1:3*width_b] : mult3_b_reg_in );
end
else 
assign datab_in[4*width_b-1:3*width_b] = 'b0;
endgenerate

// ************** Multiplier inputs ************ //
assign dataa_wide = {dataa_in};
assign datab_wide = {datab_in};

// for input A
assign mult1_a_in = dataa_wide[width_a-1:0];
assign mult2_a_in = dataa_wide[(2*width_a)-1:width_a];
assign mult3_a_in = dataa_wide[(3*width_a)-1:(2*width_a)];
assign mult4_a_in = dataa_wide[(4*width_a)-1:(3*width_a)];

// for input B
assign mult1_b_in = datab_wide[width_b-1:0];
assign mult2_b_in = datab_wide[(2*width_b)-1:width_b];
assign mult3_b_in = datab_wide[(3*width_b)-1:(2*width_b)];
assign mult4_b_in = datab_wide[(4*width_b)-1:(3*width_b)];

assign mult_a_reg_in = {mult4_a_reg_in,mult3_a_reg_in,mult2_a_reg_in,mult1_a_reg_in};
assign mult_b_reg_in = {mult4_b_reg_in,mult3_b_reg_in,mult2_b_reg_in,mult1_b_reg_in};

// ************** Scan outputs ************ //

assign scanouta = mult_a_reg_in[(number_of_multipliers * width_a)-1 : ((number_of_multipliers-1) * width_a)];
assign scanoutb = mult_b_reg_in[(number_of_multipliers * width_b)-1 : ((number_of_multipliers-1) * width_b)];

//////////////////////////// synchronous logic  ////////////////////////////////////////

// ************** Sign A/B logic ************ //

assign signa_rev = (port_signa == "PORT_UNUSED")?
                    ((representation_a != "UNUSED") ? 
                      (representation_a == "SIGNED" ? 1'b1 : 1'b0) : 1'b0
                    ) : (
		   (port_signa == "PORT_USED")? signa : (
		    ((representation_a != "UNUSED") ?
			(representation_a == "SIGNED" ? 1'b1 : 1'b0) : signa)
		    				       )
		    );
// signa reg

generate
if ((signed_register_a != "UNREGISTERED")  && 
	((port_signa!="PORT_UNUSED") || (representation_a=="UNUSED")))
	// don't register a signa_rev if it is permanently set to 1 or 0
begin

	dffep signa_ff (
		.q(signa_in_reg),
		.ck(sign_reg_a_clk),
		.en(sign_reg_a_en),
		.d(signa_rev),
		.s(1'b0),
		.r(sign_reg_a_clr)
	);

    assign signa_reg = signa_in_reg;
end
else
    assign signa_reg = signa_rev; 
endgenerate


// signa pipe

generate
if ((signed_pipeline_register_a != "UNREGISTERED") &&
	((port_signa!="PORT_UNUSED") || (representation_a=="UNUSED")))
begin

	dffep signa_pipe_ff (
		.q(signa_in_pipe),
		.ck(sign_pipe_a_clk),
		.en(sign_pipe_a_en),
		.d(signa_reg),
		.s(1'b0),
		.r(sign_pipe_a_clr)
	);
    assign signa_pipe = signa_in_pipe;
end
else
    assign signa_pipe = signa_reg;
endgenerate

assign signb_rev = (port_signb == "PORT_UNUSED")?
                    ((representation_b != "UNUSED") ? 
                      (representation_b == "SIGNED" ? 1'b1 : 1'b0) : 1'b0
                    ) : (
		   (port_signb == "PORT_USED")? signb : (
		    ((representation_b != "UNUSED") ?
			(representation_b == "SIGNED" ? 1'b1 : 1'b0) : signb)
		    				       )
		    );
// signb reg

generate
if ((signed_register_b != "UNREGISTERED") &&
	((port_signb!="PORT_UNUSED") || (representation_b=="UNUSED")))
begin

	dffep signb_ff (
		.q(signb_in_reg),
		.ck(sign_reg_b_clk),
		.en(sign_reg_b_en),
		.d(signb_rev),
		.s(1'b0),
		.r(sign_reg_b_clr)
	);

    assign signb_reg = signb_in_reg;

end
else
    assign signb_reg = signb_rev;
endgenerate


// signb pipe

generate
if ((signed_pipeline_register_b != "UNREGISTERED") &&
	((port_signb!="PORT_UNUSED") || (representation_b=="UNUSED")))
begin

	dffep signb_pipe_ff (
		.q(signb_in_pipe),
		.ck(sign_pipe_b_clk),
		.en(sign_pipe_b_en),
		.d(signb_reg),
		.s(1'b0),
		.r(sign_pipe_b_clr)
	);

	assign signb_pipe = signb_in_pipe;
end
else
	assign signb_pipe = signb_reg;
endgenerate


// ************** Addnsub 1/3 logic ************ //

// addsub1
assign addnsub1_rev = (port_addnsub1 == "PORT_UNUSED")?
                       (( multiplier1_direction != "UNUSED") ? 
                         (multiplier1_direction == "ADD" ? 1'b1 : 1'b0) : 
                        1'b1 ) : (
                      (port_addnsub1 == "PORT_USED")? addnsub1 : (
                       ((multiplier1_direction != "UNUSED") ? 
                         (multiplier1_direction == "ADD" ? 1'b1 : 1'b0) :
			addnsub1) 
				)
			);

// addsub1 reg

generate
if ((addnsub_multiplier_register1 != "UNREGISTERED") &&
	((port_addnsub1!="PORT_UNUSED") || (multiplier1_direction=="UNUSED")))
begin

	dffep addsub1_ff (
		.q(addsub1_in_reg),
		.ck(addsub1_reg_clk),
		.en(addsub1_reg_en),
		.d(addnsub1_rev),
		.s(1'b0),
		.r(addsub1_reg_clr)
	);

	assign addsub1_reg = addsub1_in_reg;
end
else
	assign addsub1_reg = addnsub1_rev;
endgenerate


// addsub1 pipe

generate
if ((addnsub_multiplier_pipeline_register1 != "UNREGISTERED") &&
	((port_addnsub1!="PORT_UNUSED") || (multiplier1_direction=="UNUSED")))
begin

	dffep addsub1_pipe_ff (
		.q(addsub1_in_pipe),
		.ck(addsub1_pipe_clk),
		.en(addsub1_pipe_en),
		.d(addsub1_reg),
		.s(1'b0),
		.r(addsub1_pipe_clr)
	);

	assign addsub1_pipe = addsub1_in_pipe;
end
else
	assign addsub1_pipe = addsub1_reg;

endgenerate


// addsub3
assign addnsub3_rev = (port_addnsub3 == "PORT_UNUSED")?
                       ((multiplier3_direction != "UNUSED")? 
                        (multiplier3_direction == "ADD" ? 1'b1 : 1'b0) : 1'b1 
                       ) : (
                      (port_addnsub3 == "PORT_USED")? addnsub3 : (
                       ((multiplier3_direction != "UNUSED") ?
                         (multiplier3_direction == "ADD" ? 1'b1 : 1'b0) :
                        addnsub3)
                                )
                       );

// addsub3 reg

generate
if ((number_of_multipliers>3) && 
	(addnsub_multiplier_register3 != "UNREGISTERED") &&
	((port_addnsub3!="PORT_UNUSED") || (multiplier3_direction=="UNUSED")))
begin

	dffep addsub3_ff (
		.q(addsub3_in_reg),
		.ck(addsub3_reg_clk),
		.en(addsub3_reg_en),
		.d(addnsub3_rev),
		.s(1'b0),
		.r(addsub3_reg_clr)
	);
	assign addsub3_reg = addsub3_in_reg;

end
else
	assign addsub3_reg = addnsub3_rev;
endgenerate


// addsub3 pipe

generate
if ((number_of_multipliers>3) &&
	(addnsub_multiplier_pipeline_register3 != "UNREGISTERED") &&
	((port_addnsub3!="PORT_UNUSED") || (multiplier3_direction=="UNUSED")))
begin

	dffep addsub3_pipe_ff (
		.q(addsub3_in_pipe),
		.ck(addsub3_pipe_clk),
		.en(addsub3_pipe_en),
		.d(addsub3_reg),
		.s(1'b0),
		.r(addsub3_pipe_clr)
	);

	assign addsub3_pipe = addsub3_in_pipe;

end
else
	assign addsub3_pipe = addsub3_reg;
endgenerate



// ************** Multiplier input ************ //

// for input A

generate
if (input_register_a0 != "UNREGISTERED")
begin

	dffep mult1_dina_ff[ width_a - 1 : 0 ] (
		.q( mult1_a_reg ),
		.ck( input_reg_a0_clk ),
		.en( input_reg_a0_en ),
		.d( mult1_a_in ),
		.s( 1'b0 ),
		.r( input_reg_a0_clr )
	);

	assign mult1_a_reg_in = mult1_a_reg;
end
else
	assign mult1_a_reg_in = mult1_a_in;
endgenerate


generate
if ((number_of_multipliers > 1) && (input_register_a1 != "UNREGISTERED"))
begin

	dffep mult2_dina_ff[ width_a - 1 : 0 ] (
		.q( mult2_a_reg ),
		.ck( input_reg_a1_clk ),
		.en( input_reg_a1_en ),
		.d( mult2_a_in ),
		.s( 1'b0 ),
		.r( input_reg_a1_clr )
	);

	assign mult2_a_reg_in = mult2_a_reg;
end
else
	assign mult2_a_reg_in = mult2_a_in;
endgenerate


generate
if ((number_of_multipliers > 2) && (input_register_a2 != "UNREGISTERED"))
begin

	dffep mult3_dina_ff[ width_a - 1 : 0 ] (
		.q( mult3_a_reg ),
		.ck( input_reg_a2_clk ),
		.en( input_reg_a2_en ),
		.d( mult3_a_in ),
		.s( 1'b0 ),
		.r( input_reg_a2_clr )
	);

	assign mult3_a_reg_in = mult3_a_reg;

end
else
	assign mult3_a_reg_in = mult3_a_in;
endgenerate



generate
if ((number_of_multipliers > 3) && (input_register_a3 != "UNREGISTERED"))
begin

	dffep mult4_dina_ff[ width_a - 1 : 0 ] (
		.q( mult4_a_reg ),
		.ck( input_reg_a3_clk ),
		.en( input_reg_a3_en ),
		.d( mult4_a_in ),
		.s( 1'b0 ),
		.r( input_reg_a3_clr )
	);

	assign mult4_a_reg_in = mult4_a_reg;

end
else
	assign mult4_a_reg_in = mult4_a_in;
endgenerate


// for input B

generate
if (input_register_b0 != "UNREGISTERED")
begin

	dffep mult1_dinb_ff[ width_b - 1 : 0 ] (
		.q( mult1_b_reg ),
		.ck( input_reg_b0_clk ),
		.en( input_reg_b0_en ),
		.d( mult1_b_in ),
		.s( 1'b0 ),
		.r( input_reg_b0_clr )
	);

	assign mult1_b_reg_in = mult1_b_reg;

end
else
	assign mult1_b_reg_in = mult1_b_in;
endgenerate


generate
if ((number_of_multipliers>1) && (input_register_b1 != "UNREGISTERED"))
begin

	dffep mult2_dinb_ff[ width_b - 1 : 0 ] (
		.q( mult2_b_reg ),
		.ck( input_reg_b1_clk ),
		.en( input_reg_b1_en ),
		.d( mult2_b_in ),
		.s( 1'b0 ),
		.r( input_reg_b1_clr )
	);

	assign mult2_b_reg_in = mult2_b_reg;

end
else
	assign mult2_b_reg_in = mult2_b_in;
endgenerate


generate
if ((number_of_multipliers>2) && (input_register_b2 != "UNREGISTERED"))
begin

	dffep mult3_dinb_ff[ width_b - 1 : 0 ] (
		.q( mult3_b_reg ),
		.ck( input_reg_b2_clk ),
		.en( input_reg_b2_en ),
		.d( mult3_b_in ),
		.s( 1'b0 ),
		.r( input_reg_b2_clr )
	);

	assign mult3_b_reg_in = mult3_b_reg;

end
else
	assign mult3_b_reg_in = mult3_b_in;
endgenerate



generate
if ((number_of_multipliers>3) && (input_register_b3 != "UNREGISTERED"))
begin

	dffep mult4_dinb_ff[ width_b - 1 : 0 ] (
		.q( mult4_b_reg ),
		.ck( input_reg_b3_clk ),
		.en( input_reg_b3_en ),
		.d( mult4_b_in ),
		.s( 1'b0 ),
		.r( input_reg_b3_clr )
	);

	assign mult4_b_reg_in = mult4_b_reg;

end
else
	assign mult4_b_reg_in = mult4_b_in;
endgenerate



// ************** Rounding and Saturation Control ************ //
generate
if (multiplier01_rounding =="VARIABLE" && 
	mult01_round_register != "UNREGISTERED")
begin

	dffep mult01_round_ff (
		.q(mult01_round_in_reg),
		.ck(mult01_round_clk),
		.en(mult01_round_en),
		.d(mult01_round),
		.s(1'b0),
		.r(mult01_round_clr)
	);

	assign mult01_round_signal_reg = mult01_round_in_reg;
end
else
	assign mult01_round_signal_reg = mult01_round;
endgenerate

generate
if (multiplier23_rounding=="VARIABLE" && 
	mult23_round_register != "UNREGISTERED")
begin

	dffep mult23_round_ff (
		.q(mult23_round_in_reg),
		.ck(mult23_round_clk),
		.en(mult23_round_en),
		.d(mult23_round),
		.s(1'b0),
		.r(mult23_round_clr)
	);

	assign mult23_round_signal_reg = mult23_round_in_reg;
end
else
	assign mult23_round_signal_reg = mult23_round; 
endgenerate

generate
if (multiplier01_saturation=="VARIABLE" && 
	mult01_saturation_register != "UNREGISTERED")
begin

	dffep mult01_saturation_ff (
		.q(mult01_saturation_in_reg),
		.ck(mult01_saturation_clk),
		.en(mult01_saturation_en),
		.d(mult01_saturation),
		.s(1'b0),
		.r(mult01_saturation_clr)
	);

assign mult01_saturation_signal_reg = mult01_saturation_in_reg;
end
else
	assign mult01_saturation_signal_reg = mult01_saturation;
endgenerate

generate
if (multiplier23_saturation=="VARIABLE" &&
	mult23_saturation_register != "UNREGISTERED")
begin

	dffep mult23_saturation_ff (
		.q(mult23_saturation_in_reg),
		.ck(mult23_saturation_clk),
		.en(mult23_saturation_en),
		.d(mult23_saturation),
		.s(1'b0),
		.r(mult23_saturation_clr)
	);
	assign mult23_saturation_signal_reg = mult23_saturation_in_reg;

end
else
	assign mult23_saturation_signal_reg = mult23_saturation;
endgenerate

generate
if (adder1_rounding=="VARIABLE" && addnsub1_round_register != "UNREGISTERED")
begin

	dffep addnsub1_round_ff (
		.q(addnsub1_round_in_reg),
		.ck(addnsub1_round_clk),
		.en(addnsub1_round_en),
		.d(addnsub1_round),
		.s(1'b0),
		.r(addnsub1_round_clr)
	);

assign addnsub1_round_signal_reg = addnsub1_round_in_reg;
end
else
assign addnsub1_round_signal_reg = addnsub1_round;
endgenerate

generate
if (adder1_rounding=="VARIABLE" && 
	addnsub1_round_pipeline_register != "UNREGISTERED")
begin

	dffep addnsub1_round_pipe_ff (
		.q(addnsub1_round_pipe_in_reg),
		.ck(addnsub1_round_pipe_clk),
		.en(addnsub1_round_pipe_en),
		.d(addnsub1_round_signal_reg),
		.s(1'b0),
		.r(addnsub1_round_pipe_clr)
	);
assign addnsub1_round_pipe_signal_reg = addnsub1_round_pipe_in_reg;

end
else
assign addnsub1_round_pipe_signal_reg = addnsub1_round_signal_reg ;
endgenerate


generate
if (adder3_rounding=="VARIABLE" && addnsub3_round_register != "UNREGISTERED")
begin

	dffep addnsub3_round_ff (
		.q(addnsub3_round_in_reg),
		.ck(addnsub3_round_clk),
		.en(addnsub3_round_en),
		.d(addnsub3_round),
		.s(1'b0),
		.r(addnsub3_round_clr)
	);
assign addnsub3_round_signal_reg = addnsub3_round_in_reg;

end
else
assign addnsub3_round_signal_reg = addnsub3_round;

endgenerate


generate
if (adder3_rounding=="VARIABLE" && 
	addnsub3_round_pipeline_register != "UNREGISTERED")
begin

	dffep addnsub3_round_pipe_ff (
		.q(addnsub3_round_pipe_in_reg),
		.ck(addnsub3_round_pipe_clk),
		.en(addnsub3_round_pipe_en),
		.d(addnsub3_round_signal_reg),
		.s(1'b0),
		.r(addnsub3_round_pipe_clr)
	);
assign addnsub3_round_pipe_signal_reg = addnsub3_round_pipe_in_reg;

end
else
assign addnsub3_round_pipe_signal_reg = addnsub3_round_signal_reg;
endgenerate



// ************** port is saturated outputs ************ //
assign mult0_is_saturated = mult1_sat_reg_out;

assign mult1_is_saturated = mult2_sat_reg_out;

assign mult2_is_saturated = mult3_sat_reg_out;

assign mult3_is_saturated = mult4_sat_reg_out;

generate
if ((port_mult0_is_saturated!="UNUSED") && 
	(output_register != "UNREGISTERED"))
begin

	dffep mult1_sat_ff (
		.ck(output_reg_clk),
		.r(output_reg_clr),
		.s( 1'b0 ),
		.en(output_reg_en),
		.d(mult1_sat_overflow),
		.q(mult1_sat_reg)
	);
	assign mult1_sat_reg_out = mult1_sat_reg;

end
else if (port_mult0_is_saturated!="UNUSED")
assign mult1_sat_reg_out = mult1_sat_overflow;
else
assign mult1_sat_reg_out = 1'b0;
endgenerate

generate
if ((port_mult1_is_saturated!="UNUSED") &&
	(output_register != "UNREGISTERED"))
begin

	dffep mult2_sat_ff (
		.q(mult2_sat_reg),
		.ck(output_reg_clk),
		.en(output_reg_en),
		.d(mult2_sat_overflow),
		.s(1'b0),
		.r(output_reg_clr)
	);

assign mult2_sat_reg_out = mult2_sat_reg;
end
else if (port_mult1_is_saturated!="UNUSED")
assign mult2_sat_reg_out = mult2_sat_overflow;
else
assign mult2_sat_reg_out = 1'b0;
endgenerate


generate
if ((port_mult2_is_saturated!="UNUSED") &&
     (output_register != "UNREGISTERED"))
begin

	dffep mult3_sat_ff (
		.q(mult3_sat_reg),
		.ck(output_reg_clk),
		.en(output_reg_en),
		.d(mult3_sat_overflow),
		.s(1'b0),
		.r(output_reg_clr)
	);

assign mult3_sat_reg_out = mult3_sat_reg;
end
else if (port_mult2_is_saturated!="UNUSED")
assign mult3_sat_reg_out = mult3_sat_overflow;
else
assign mult3_sat_reg_out = 1'b0;
endgenerate

generate
if ((port_mult3_is_saturated!="UNUSED") &&
	(output_register != "UNREGISTERED"))
begin

	dffep mult4_sat_ff (
		.q(mult4_sat_reg),
		.ck(output_reg_clk),
		.en(output_reg_en),
		.d(mult4_sat_overflow),
		.s(1'b0),
		.r(output_reg_clr)
	);
assign mult4_sat_reg_out = mult4_sat_reg;
end

else if (port_mult3_is_saturated!="UNUSED")
assign mult4_sat_reg_out = mult4_sat_overflow;
else
assign mult4_sat_reg_out = 1'b0;
endgenerate



// ************** Multiplier output ************ //

generate
if (multiplier_register0 != "UNREGISTERED")
begin

	dffep mult1_dout_ff[ width_a + width_b - 1 : 0 ] (
		.q( mult1_reg ),
		.ck( multiplier_reg0_clk ),
		.en( multiplier_reg0_en ),
		.d( mult1_out ),
		.s( 1'b0 ),
		.r( multiplier_reg0_clr )
	);

	assign mult1_reg_out = mult1_reg;
end

else
	assign mult1_reg_out = mult1_out;
endgenerate


generate
if ((number_of_multipliers>1) && (multiplier_register1 != "UNREGISTERED"))
begin

	dffep mult2_dout_ff[ width_a + width_b - 1 : 0 ] (
		.q( mult2_reg ),
		.ck( multiplier_reg1_clk ),
		.en( multiplier_reg1_en ),
		.d( mult2_out ),
		.s( 1'b0 ),
		.r( multiplier_reg1_clr )
	);

	assign mult2_reg_out = mult2_reg;
end

else
	assign mult2_reg_out = mult2_out;
endgenerate


generate
if ((number_of_multipliers>2) && (multiplier_register2 != "UNREGISTERED"))
begin

	dffep mult3_dout_ff[ width_a + width_b - 1 : 0 ] (
		.q( mult3_reg ),
		.ck( multiplier_reg2_clk ),
		.en( multiplier_reg2_en ),
		.d( mult3_out ),
		.s( 1'b0 ),
		.r( multiplier_reg2_clr )
	);

	assign mult3_reg_out = mult3_reg;
end

else
	assign mult3_reg_out = mult3_out;
endgenerate


generate
if ((number_of_multipliers>3) && (multiplier_register3 != "UNREGISTERED"))
begin

	dffep mult4_dout_ff[ width_a + width_b - 1 : 0 ] (
		.q( mult4_reg ),
		.ck( multiplier_reg3_clk ),
		.en( multiplier_reg3_en ),
		.d( mult4_out ),
		.s( 1'b0 ),
		.r( multiplier_reg3_clr )
	);

	assign mult4_reg_out = mult4_reg;
end
else
	assign mult4_reg_out = mult4_out;
endgenerate


// register for output 

generate
if (output_register != "UNREGISTERED") begin
	dffep add_dout_ff[ width_a + width_b + 1 : 0 ] (
		.q( add_reg_out ),
		.ck( output_reg_clk ),
		.en( output_reg_en ),
		.d( add_out ),
		.s( 1'b0 ),
		.r( output_reg_clr )
	);
end 
else begin
	assign add_reg_out = add_out;
end
endgenerate

generate 
if (width_result > width_a+width_b+2) begin
	if (output_register != "UNREGISTERED") begin 
		dffep sign_extend_ff (
			.q( extend_bit ),
			.ck( output_reg_clk ),
			.en( output_reg_en ),
			.d( extend_bit_pre ),
			.s( 1'b0 ),
			.r( output_reg_clr )
		);
	end
	else begin
		assign extend_bit = extend_bit_pre;
	end
end
endgenerate

assign extend_bit_pre = (add_out[width_l2addrout-1] == 1)? (
	(signa_pipe | signb_pipe | ((!signa_pipe & !signb_pipe) 
 		& (!addsub1_pipe & !addsub3_pipe)))? add_out[width_l2addrout - 1] : 
	(( !signa_pipe & !signb_pipe & (!addsub1_pipe ^ !addsub3_pipe))? 
			add_out[width_l2addrout - 2] : 1'b0)
		) : 1'b0;

// IMPLEMENTATION END
endmodule
// MODEL END
