// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


module altddio_out (
	aclr,
	aset,
	datain_h,
	datain_l,
	dataout,
	oe,
	outclock,
	outclocken);

	parameter	intended_device_family = "UNUSED";
	parameter	extend_oe_disable = "OFF";
	parameter	invert_output = "OFF";
	parameter	oe_reg = "UNREGISTERED";
	parameter	power_up_high = "OFF";
	parameter	width = 1;
	parameter	lpm_type = "altddio_out";
	parameter	lpm_hint = "UNUSED";

	input	aclr;
	input	aset;
	input	[width-1:0]	datain_h;
	input	[width-1:0]	datain_l;
	input	oe;
	input	outclock;
	input	outclocken;

	output	[width-1:0]	dataout;

`include "altera_mf_macros.i"

//// nets/registers ////

wire   [width-1:0] oreg, odreg;
wire   [width-1:0] latched_dataout;

wire   [width-1:0] enreg,enpsreg;
wire   [width-1:0] oe_actual;

wire [width-1:0] d_w_h, d_w_l, oe_w, en_w;

wire [width-1:0] dataout_tmp;

assign d_w_h = (outclocken)? datain_h : oreg;
assign d_w_l = (outclocken)? datain_l : odreg;
assign oe_w = (outclocken)? {width{oe}} : enreg;
assign en_w = (outclocken)? enreg : enpsreg;

generate
        if(width==1) begin
                dffp oreg_reg (oreg,outclock,d_w_h,aset,aclr);
        end
        else begin
                dffp oreg_reg[width-1:0] (oreg,outclock,d_w_h,aset,aclr);
        end
endgenerate

generate
        if(width==1) begin
                dffp odreg_reg (odreg,outclock,d_w_l,aset,aclr);
        end
        else begin
                dffp odreg_reg[width-1:0] (odreg,outclock,d_w_l,aset,aclr);
        end
endgenerate

generate
        if(width==1) begin
                dffp enreg_reg (enreg,outclock,oe_w,aset,aclr);
        end
        else begin
                dffp enreg_reg[width-1:0] (enreg,outclock,oe_w,aset,aclr);
        end
endgenerate

generate
        if(width==1) begin
                dffp enpsreg_reg (enpsreg,~outclock,en_w,aset,aclr);
        end
        else begin
                dffp enpsreg_reg[width-1:0] (enpsreg,~outclock,en_w,aset,aclr);
        end
endgenerate

generate
genvar i;
for (i=0; i < width; i=i+1) begin:bit

assign oe_actual[i] = ((extend_oe_disable == "ON") ?
                        (enreg[i] & enpsreg[i]) : (
                          ((oe_reg == "REGISTERED") && (extend_oe_disable != "ON")) ?
                                                                 enreg[i] : oe
                          )
                       );

assign dataout_tmp[i] = (oe_actual[i]) ? ((outclock) ? oreg[i] : odreg[i]) : 1'bz;

assign dataout[i] = (FEATURE_FAMILY_HAS_INVERTED_OUTPUT_DDIO(intended_device_family) && (invert_output == "ON"))? ~dataout_tmp[i] : dataout_tmp[i];

end
endgenerate


endmodule //altddio_out

