// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


/////////////////////////////////////////////////////////////////////////////////////
////////////////////////////// ALTDDIO_IN  for Formal Verification //////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
// MODEL BEGIN
module altddio_in (
// INTERFACE BEGIN
    datain,    // DDR input data
    inclock,   // input reference clock to sample data by
    inclocken, // clock enable 
    aset,      // asynchronous set
    aclr,      // asynchronous clear
    dataout_h, // data sampled at the rising edge of inclock
    dataout_l  // data sampled at the falling edge of inclock
);
// INTERFACE END
//// default parameters ////

parameter width = 1;
parameter intended_device_family = "UNUSED";
parameter power_up_high = "OFF";
parameter implement_input_in_lcell = "ON";
parameter lpm_type = "altddio_in";
parameter lpm_hint = "UNUSED";
parameter invert_input_clocks = "OFF";

//// constants ////
//// variables ////

//// port declarations ////

input [width-1:0] datain;
input inclock;
input inclocken;
input aset;
input aclr;
output [width-1:0] dataout_h;
output [width-1:0] dataout_l;

//// nets/registers ////

wire [width-1:0] d_w_h, d_w_l;
wire [width-1:0] d_w, ddio_datain;
wire actual_inclock;

// IMPLEMENTATION BEGIN

// ***************** synchronous logic ***************** //
assign d_w_h = (inclocken)? datain : dataout_h;
assign d_w_l = (inclocken)? ddio_datain : dataout_l;
assign d_w = (inclocken)? datain : ddio_datain;

generate
	if(invert_input_clocks=="OFF") begin
		assign actual_inclock = inclock;
	end
	else begin
		assign actual_inclock = ~inclock;
	end
endgenerate

generate
	if(width==1) begin
		dffp dinh_reg (dataout_h,actual_inclock,d_w_h,aset,aclr);
	end
	else begin
		dffp dinh_reg[width-1:0] (dataout_h,actual_inclock,d_w_h,aset,aclr);
	end
endgenerate

generate
	if(width==1) begin
		dffp dinl_reg (dataout_l,actual_inclock,d_w_l,aset,aclr);
	end
	else begin
		dffp dinl_reg[width-1:0] (dataout_l,actual_inclock,d_w_l,aset,aclr);
	end
endgenerate

generate
	if(width==1) begin
		dffp ddio_din_reg (ddio_datain,~actual_inclock,d_w,aset,aclr);
	end
	else begin
		dffp ddio_din_reg[width-1:0] (ddio_datain,~actual_inclock,d_w,aset,aclr);
	end
endgenerate


// IMPLEMENTATION END
endmodule
// MODEL END
