// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


/////////////////////////////////////////////////////////////////////////////////////
//////////////////////////// ALTDDIO_BIDIR  for Formal Verification /////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
// MODEL BEGIN
module altddio_bidir (
// INTERFACE BEGIN
    datain_h,  // input data to be output of padio port at the
               // rising edge of outclock
    datain_l,  // input data to be output of padio port at the
               // falling edge of outclock
    inclock,   // input reference clock to sample data by
    inclocken, // inclock enable
    outclock,  // input reference clock to register data output
    outclocken,// outclock enable
    aset,      // asynchronous set
    aclr,      // asynchronous clear
    oe,        // output enable for padio port
    dataout_h, // data sampled from the padio port at the rising edge of inclock
    dataout_l, // data sampled from the padio port at the falling edge of inclock
    combout,   // combinatorial output directly fed by padio
    dqsundelayedout, // undelayed DQS signal to the PLD core
    padio      // bidirectional DDR port

);
// INTERFACE END
//// default parameters ////

parameter width = 1; 
parameter power_up_high = "OFF";
parameter oe_reg = "UNREGISTERED";
parameter extend_oe_disable = "OFF";
parameter intended_device_family = "UNUSED";
parameter implement_input_in_lcell = "OFF";
parameter invert_output = "OFF";
parameter lpm_type = "altddio_bidir";
parameter lpm_hint = "UNUSED";

//// constants ////
//// variables ////

//// port declarations ////

input [width-1:0] datain_l,datain_h;
input inclock,outclock;
input inclocken,outclocken;
input aset;
input aclr;
input oe;
output [width-1:0] dataout_h;
output [width-1:0] dataout_l;
output [width-1:0] combout;
output [width-1:0] dqsundelayedout;
inout  [width-1:0] padio;

//// nets/registers ////

// IMPLEMENTATION BEGIN

// ********************** synchronous logic ***************** //

// ***************** ddio logic ***************** //

// ddio input

altddio_in #(
		.width(width),
		.intended_device_family(intended_device_family),
		.power_up_high(power_up_high)
	    ) ddio_in (
    .datain(padio),
    .inclock(inclock),
    .inclocken(inclocken),
    .aset(aset),
    .aclr(aclr),
    .dataout_h(dataout_h),
    .dataout_l(dataout_l)
);

// ddio output

altddio_out #(
		.width(width),
		.intended_device_family(intended_device_family),
		.power_up_high(power_up_high),
               	.oe_reg(oe_reg),
                .extend_oe_disable(extend_oe_disable)
	     ) ddio_out (
    .datain_h(datain_h),
    .datain_l(datain_l),
    .outclock(outclock),
    .oe(oe),
    .outclocken(outclocken),
    .aset(aset),
    .aclr(aclr),
    .dataout(padio)
);

// ********************** asynchronous logic ***************** //

assign combout = padio;
assign dqsundelayedout = padio;


// IMPLEMENTATION END
endmodule
// MODEL END
