// Copyright (C) 1991-2006 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.


module addsub_block (
	dataa,
	datab,
	signa,
	signb,
	addsub,
	sum,
	sumsign
);

	parameter width_a = 1;
	parameter width_b = 1;

	localparam width_sum = ( width_a >= width_b ) ? ( width_a + 1 ) :
		( width_b + 1 );

	input [ width_a - 1 : 0 ] dataa;
	input [ width_b - 1 : 0 ] datab;

	input signa;
	input signb;
	input addsub;

	output [ width_sum - 1 : 0 ] sum;
	output sumsign;

	wire [ width_sum - 1 : 0 ] sum;
	wire signed sumsign;

	wire signed [ width_a : 0 ] signed_a;
	wire signed [ width_b : 0 ] signed_b;
	wire signed [ width_sum : 0 ] signed_sum;

	assign signed_a = signa ? { dataa[width_a-1], dataa } :
		{ 1'b0, dataa };
	assign signed_b = signb ? { datab[width_b-1], datab } :
		{ 1'b0, datab };

	assign signed_sum = addsub ? signed_a + signed_b : signed_a - signed_b;
	assign sum = signed_sum[ width_sum - 1 : 0 ];
	assign sumsign = signed_sum[ width_sum ];

endmodule
