# Copyright (c) 2005 Altera Corporation. All rights reserved.  

# Your use of Altera Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output files 
# any of the foregoing (including device programming or simulation files), and 
# any associated documentation or information are expressly subject to the terms 
# and conditions of the Altera Program License Subscription Agreement, Altera 
# MegaCore Function License Agreement, or other applicable license agreement, 
# including, without limitation, that your use is for the sole purpose of 
# programming logic devices manufactured by Altera and sold by Altera or its 
# authorized distributors.  Please refer to the applicable agreement for 
# further details.

if ( ! $?QUARTUS_QENV ) then
setenv QUARTUS_QENV 1
setenv QENV_STATUS 0

if ( ! $?QUARTUS_ROOTDIR ) then
	echo "You must set the QUARTUS_ROOTDIR environment variable"
	echo "to point to a valid Quartus II installation before"
	echo "sourcing this script!"
	exit
endif

if (! $?TMP) then
	setenv TMP /tmp
else if ( ! -d $TMP ) then
	setenv TMP /tmp
endif

# quartus doesn't support other languages
# so if LANG is set make sure its C
if ($?LANG) then
	if ("$LANG" != "C") setenv LANG C
endif
# if any LC_* variable is set, set LC_ALL to C to override
env | grep LC_ >& /dev/null
if ($status == 0) setenv LC_ALL C


setenv QUARTUS_PATH /usr/bin
if ( $?QUARTUS_INIT_PATH ) then
	setenv QUARTUS_PATH ${QUARTUS_PATH}:${QUARTUS_INIT_PATH}
endif

if ( $?QUARTUS_INIT_LIBPATH ) then
	setenv QUARTUS_LIBPATH ${QUARTUS_INIT_LIBPATH}
else
	setenv QUARTUS_LIBPATH ""
endif

setenv QUARTUS_ORIG_PATH $PATH
setenv PATH /usr/bin:/bin:/usr/sbin
setenv QUARTUS_BIT_TYPE 32
setenv UNAME_SYSTEM `uname -s`
setenv UNAME_REVISION `uname -r`
setenv UNAME_VERSION `uname -v`

if (${UNAME_SYSTEM} == "SunOS") then
	setenv QUARTUS_PLATFORM solaris
	setenv PATCH_CMD "showrev -a"
	setenv AWK_CMD "nawk"
	setenv MIN_OS_REVISION 8
	setenv LD_BIND_NOW 1
	setenv SYSTEM_MEMORY "`/usr/sbin/prtconf | /bin/grep Memory | /usr/bin/sed -e 's/Memory size: \([0-9]*\).*/\1/'`"
	if (`isainfo -b` == "64") then
		setenv QUARTUS_BIT_TYPE 64
	endif
	setenv UNAME_REVISION `uname -r | sed -e 's/5\.//g'`
	# We used to use these for Mainwin, but now they cause Quartus to hang, so make sure they are not set
	unsetenv MWNO_RIT
	unsetenv MWDONT_XINITTHREAD
else if (${UNAME_SYSTEM} == "Linux") then
	setenv QUARTUS_PLATFORM linux
	setenv PATCH_CMD ""
	setenv AWK_CMD "awk"
	setenv MWRT_MODE classic
	if ( $?LC_CTYPE ) then
		if ( $LC_CTYPE == "POSIX" ) then
			setenv LC_CTYPE en_US
		endif
		if ( $LC_CTYPE == "C" ) then
			setenv LC_CTYPE en_US
		endif
	else
		unsetenv LC_ALL
		setenv LC_CTYPE en_US
	endif

	# We want to check if we are running on a supported version of Red Hat Linux (8.0, RHEL3).
	# If not, we set the MWWM environment variable to put Mainwin into compatibility mode
	# for better interaction with non-supported distributions. Users can turn this on 
	# as well by setting the QUARTUS_MWWM env. variable to allwm.
	if ( -f /etc/redhat-release ) then
		setenv REDHAT_VERSION `cat /etc/redhat-release | grep release | sed -e 's/Red Hat Linux release //g' -e 's/(.*//g'`
		if ( "$REDHAT_VERSION" =~ *Red?Hat?Enterprise* ) then
			if ("$REDHAT_VERSION" =~ *release?3 ) setenv REDHAT_VERSION 3.0rhel
			if ("$REDHAT_VERSION" =~ *release?4 ) setenv REDHAT_VERSION 4.0rhel
		endif

		if ( "$REDHAT_VERSION" =~ *Fedora?Core* ) then
			if ("$REDHAT_VERSION" =~ *release?4 ) setenv REDHAT_VERSION 4.0rhel
		endif

		if ( "$REDHAT_VERSION" == "8.0" || "$REDHAT_VERSION" == "3.0rhel" || "$REDHAT_VERSION" == "4.0rhel" ) then
		# do nothing
		else
		# Go into window compatibility mode (allwm mode)
			if (! $?QUARTUS_MWWM ) then
				setenv MWWM allwm
			endif
		endif

		# If we are on RH 9.0 and Enterprise 3.0/4.0, we know LD_ASSUME_KERNEL is needed. 
		# It might be needed on other unsupported distributions as well. Not needed under RH8.
		if ( "$REDHAT_VERSION" != "8" ) then
			setenv LD_ASSUME_KERNEL 2.4
		endif
	else
		# This is the case for a non-supported Linux distribution.  We don't prevent Quartus II
		# from running on this distribution, but we don't do anything special either. Individual
		# users may need to set QUARTUS_MWWM, LD_ASSUME_KERNEL, etc. as needed.
   		if (! $?QUARTUS_MWWM ) then
	   		setenv MWWM allwm
		endif
	endif
	
	if (`uname -m` == "x86_64") then
		setenv QUARTUS_BIT_TYPE 64
	endif

	# We don't support processors without SSE extensions (e.g. Pentium II and older CPUs).
	set cpumodel=`grep 'model name' /proc/cpuinfo | sed -e's/model name.*: //g' | uniq`
	grep sse /proc/cpuinfo >& /dev/null
	if ($status != 0) then
		echo ""
		echo "The Quartus II software is optimized for the Intel Pentium III processor"
		echo "and newer processors.  The required extensions were not found on:"
		echo "'$cpumodel'"
		echo ""
		echo "The Quartus II software will not function properly on this processor model."
		echo "Terminating..."
		setenv QENV_STATUS -1
	endif
	
	set QTB_CPU_FREQ=`cat /proc/cpuinfo | grep "cpu MHz" | cut -c 12-18 | uniq`
   
else
	echo "This operating system platform is unsupported by the Quartus II software."
	setenv QENV_STATUS -1
	exit
endif

if ( $QUARTUS_PLATFORM == "solaris" ) then
	if ( `expr $UNAME_REVISION \< $MIN_OS_REVISION` ) then
		echo "You must run the Quartus II software under an operating"
		echo "system of version $QUARTUS_PLATFORM $MIN_OS_REVISION or later."
		setenv QENV_STATUS -2
		exit
	endif
endif

if ( ! -f ${QUARTUS_ROOTDIR}/common/devinfo/ddb_cumulative_info.ddb ) then
	echo ""
	echo "The Quartus II software installation appears incomplete.  Please"
	echo "mount the Quartus II Device Information CD and run the 'install'"
	echo "script in order to complete the installation."
	echo ""
	setenv QENV_STATUS -3
	exit
endif

if ( ! $?CMD_NAME) setenv CMD_NAME `basename $0`

unsetenv USE_64BIT 
# This will only happen for quartus_fit, quartus_tan or quartus_map on 64-bit systems
if ( $QUARTUS_BIT_TYPE == "64" && -f ${QUARTUS_ROOTDIR}/${QUARTUS_PLATFORM}64/${CMD_NAME} ) then
	if ( "$CMD_NAME" == "jtagd" ) then
		setenv USE_64BIT
	else
		set old_lib_path=$LD_LIBRARY_PATH
		setenv LD_LIBRARY_PATH ${QUARTUS_ROOTDIR}/${QUARTUS_PLATFORM}
		${QUARTUS_ROOTDIR}/${QUARTUS_PLATFORM}/quartus_sh -t ${QUARTUS_ROOTDIR}/adm/check_64bit.tcl >& /dev/null
		set result=$status
		if ($result == 0) then
			if ($?QUARTUS_64BIT) then
				if (${QUARTUS_64BIT} != "0") then
					setenv USE_64BIT
				endif
				endif
		else if ($result == 1) then
			unsetenv USE_64BIT
		else if ($result == 2) then
			setenv USE_64BIT
		endif
		setenv LD_LIBRARY_PATH $old_lib_path
	endif
else
	# For any other executable, we unset QUARTUS_64BIT
	unsetenv USE_64BIT
endif

# If 64-bit flag is not set or this system is strictly 32-bit capable, 
# setup the Mainwin/UI environment for 32-bit executables
if ( ! $?USE_64BIT || $QUARTUS_BIT_TYPE == "32" ) then
	if ( $?QUARTUS_MWHOME ) then
		setenv MWHOME $QUARTUS_MWHOME
	else
		setenv MWHOME ${QUARTUS_ROOTDIR}/mw
	endif
	# Need to unset MWCURRENT_LIBPATH so environment gets initialized from scratch
	unsetenv MWCURRENT_LIBPATH
	# set PATH to basic so we can use it to pick up the Mainwin required paths
	# saving original path first

	if ( -f ${MWHOME}/setupmainwin.csh && ! $?MWRELEASE) then
		source ${MWHOME}/setupmainwin.csh
		else
		source ${MWHOME}/setmwruntime.csh
	endif

	if ( $?QUARTUS_MWWM ) then
		setenv MWWM ${QUARTUS_MWWM}
	endif

	setenv MWUSE_FIXED_SCREENDPI 1

	# this makes Quartus shared memory segment unique
	if (! $?QUARTUS_NO_SHM_KEY) then
		set id=`id`
		set id=`echo $id | sed -e 's/uid=//g' -e 's/(.*//g'`
		setenv MWSHM_KEY `expr 10000 + $$ + $id`
	endif

	setenv QUARTUS_LIBPATH ${MWCURRENT_LIBPATH}:${QUARTUS_LIBPATH}
	setenv QUARTUS_PATH ${PATH}:${QUARTUS_PATH}

	setenv OBJ_STUDIO_HOME ${QUARTUS_ROOTDIR}/stingray
   	setenv QUARTUS_LIBPATH ${OBJ_STUDIO_HOME}/lib-${MWOS}_optimized:${QUARTUS_LIBPATH}
endif

setenv TCL_LIBRARY ${QUARTUS_ROOTDIR}/${QUARTUS_PLATFORM}/tcl8.4

# If 64-bit flag is set and this system is 64-bit capable then setup environment to run 64-bit
if ($?USE_64BIT && $QUARTUS_BIT_TYPE == "64") then   
	setenv QUARTUS_LIBPATH ${QUARTUS_ROOTDIR}/${QUARTUS_PLATFORM}64:${QUARTUS_ROOTDIR}/${QUARTUS_PLATFORM}:${QUARTUS_LIBPATH}
	setenv QUARTUS_PATH ${QUARTUS_ROOTDIR}/adm:${QUARTUS_ROOTDIR}/${QUARTUS_PLATFORM}64:${QUARTUS_ROOTDIR}/${QUARTUS_PLATFORM}:${QUARTUS_PATH}
else
   	setenv QUARTUS_LIBPATH ${QUARTUS_ROOTDIR}/${QUARTUS_PLATFORM}:${QUARTUS_LIBPATH}
   	setenv QUARTUS_PATH ${QUARTUS_ROOTDIR}/adm:${QUARTUS_ROOTDIR}/${QUARTUS_PLATFORM}:${QUARTUS_PATH}
endif

if (-f ${QUARTUS_ROOTDIR}/adm/qtb.csh) then
	source ${QUARTUS_ROOTDIR}/adm/qtb.csh
endif

# Save original library path before setting for Quartus
if (${QUARTUS_PLATFORM} =~ solaris* || ${QUARTUS_PLATFORM} == "linux") then
	setenv QUARTUS_ORIG_LIBPATH $LD_LIBRARY_PATH
	setenv LD_LIBRARY_PATH $QUARTUS_LIBPATH
else if (${QUARTUS_PLATFORM} == "hp11") then
	setenv QUARTUS_ORIG_LIBPATH $SHLIB_PATH
	setenv SHLIB_PATH $QUARTUS_LIBPATH
endif
unsetenv QUARTUS_LIBPATH

# original path is already saved in QUARTUS_ORIG_PATH before mainwin init
setenv PATH $QUARTUS_PATH
unsetenv QUARTUS_PATH

if ($QUARTUS_PLATFORM == "hp11") then
	unset noglob
	if ( ! -d ~/windows ) mkdir ~/windows
	if ( ! -d ~/windows/system ) mkdir ~/windows/system
endif

if ( $?MWOS ) then
	if ($?QUARTUS_MWREGISTRY) then
		setenv MWREGISTRY $QUARTUS_MWREGISTRY
	else
		if ($QUARTUS_PLATFORM == "hp11") then
			setenv MWREGISTRY ${HOME}/windows/system/q2_mw4_registry_${MWOS}.bin:${HOME}/windows/system/q2_mw4_registry_hkcu_${MWOS}.bin
		else
			setenv MWREGISTRY ${HOME}/.mw/q2_registry_${MWOS}.bin:${HOME}/.mw/q2_registry_hkcu_${MWOS}.bin
		endif
	endif
endif	

if (! -d ${QUARTUS_ROOTDIR}/${QUARTUS_PLATFORM}) then
	echo "*** The Quartus II software cannot be started because the current platform,"
	echo "    '$QUARTUS_PLATFORM', does not appear to be installed in:"
	echo "    '$QUARTUS_ROOTDIR'."
	echo ""
	setenv QENV_STATUS -1
else
	setenv PROC_ID `getpid`
endif 

# endif for "if ( ! $?QUARTUS_QENV ) then"
endif
