# codes for each patch (in $2 field):
# 3: Mandatory patch, disable help if not available
# 2: Mandatory patch, add syslibs if not available
# 1: incompatible patch, $4 patch fixes problem
# 0: optional graphics patch
BEGIN { missing = 0 }
{
if (( $1 == ENVIRON["UNAME_SYSTEM"] ) && ( $3 == ENVIRON["UNAME_REVISION"] ))
{
	if ( $2 == 1 )
	{
		not_overridden = 1
		if (system("$PATCH_CMD | grep " $4 " 1>/dev/null 2>&1") == 0)
		{
			for (i = 5; i <= NF; ++i)
			{
				if (system("$PATCH_CMD | grep " $i " 1>/dev/null 2>&1") == 0)
				{
					not_overridden = 0
					break
				}
			}
			if (not_overridden)
			{
				printf "Warning! Quartus II is incompatible with operating system\n"
				printf "patch \"%s\". Please see readme.txt for more info.\n\n",$4
				missing = $2
			}
		}
	}
	else if ( $2 != "0" )
	{
		installed = 0
		for (i = 4; i <= NF; ++i)
		{
			if (system("$PATCH_CMD | grep " $i " 1>/dev/null 2>&1") == 0)
			{
				installed = 1
				break
			}
		}
		if (installed == 0)
		{
			printf "Warning! Quartus II requires operating system patch \"%s\"\n",$4
			  printf "to function properly. Please see readme.txt for more info.\n\n"
			missing = $2
		}
	}
}
}
END { 
  # For some reason we can just exit with $missing, that always does exit 0
  if (missing == 3) { exit 3 }
  if (missing == 2) { exit 2 }
  if (missing == 1) { exit 1 }
  exit 0
}
