/*******************************************************************
 * 
 * Barrel Shifter function units.
 * 
 * 
 * 
 * Abbreviations :
 *  W          = WIDTH
 *  L          = LATENCY
 *  R          = RESTART
 * 
 * 
 * Notes :
 *  (1) Do not include this file directly - include alt_cusp.h
 * 
 * 
 * Function Unit Models:
 * 
 * ALT_SHIFT the following operations for simulation and synthesis :
 * (1)  Barrel Shifting
 *       (a) Unsigned integer
 *       (b) Signed integer
 *       (c) Unsigned fixed point
 *       (d) Signed fixed point
 *       (e) Bit vector.
 * 
 *******************************************************************/
 
#ifndef __ALT_CUSP_H
#include <alt_cusp.h>
#endif


#ifndef __ALT_SHIFT_H
#define __ALT_SHIFT_H


#define ALT_SHIFT_MODE_LOGICAL  0
#define ALT_SHIFT_MODE_ARITH    1
#define ALT_SHIFT_MODE_ROTATE   2

#define ALT_SHIFT_DIREC_LEFT   0
#define ALT_SHIFT_DIREC_RIGHT  1
#define ALT_SHIFT_DIREC_BOTH   2

#ifndef ALT_CUSP_SYNTHESIS_ON
template <int W=16, int L=0, int R=1, int SHIFT_W=4, int MODE=ALT_SHIFT_MODE_LOGICAL, int DIRECTION=ALT_SHIFT_DIREC_RIGHT> class ALT_SHIFT
{
public:
    sc_uint<W> leftUI(const sc_uint<W> &data, const sc_uint<SHIFT_W> &shift)
    {
    	if(DIRECTION == ALT_SHIFT_DIREC_RIGHT)
    	{
    		cout << "WARNING: Left shift is not supported on ALT_SHIT with DIRECTION = ALT_SHIFT_DIREC_RIGHT.\n";
			cout << "         Consider using DIRECTION = ALT_SHIFT_DIREC_LEFT or  DIRECTION = ALT_SHIFT_DIREC_BOTH.\n";
    		return data;
    	}
		
    	
    	sc_uint<W> result;
    	
    	if(MODE == ALT_SHIFT_MODE_ROTATE)
    	{
    		sc_bv<W> result_bv;
			sc_bv<W> data_bv;
			data_bv = (sc_bv<W>) data;
			result_bv = data_bv.lrotate(shift);
			result = (sc_uint<W>) result_bv;
			
    	}
    	else if(MODE == ALT_SHIFT_MODE_LOGICAL)
    	{
    		result = data << shift;
    	} 
    	else if(MODE == ALT_SHIFT_MODE_ARITH)
    	{
		    result = data << shift;
    	} 
    	else
    	{
            cout << "WARNING: Shift Mode " << MODE << " is not supported\n";    		
    	}
    	
    	return result;
    }

	sc_int<W> leftSI(const sc_int<W> &data, const sc_uint<SHIFT_W> &shift)
    {
    	if(DIRECTION == ALT_SHIFT_DIREC_RIGHT)
    	{
    		cout << "WARNING: Left shift is not supported on ALT_SHIT with DIRECTION = ALT_SHIFT_DIREC_RIGHT.\n";
			cout << "         Consider using DIRECTION = ALT_SHIFT_DIREC_LEFT or  DIRECTION = ALT_SHIFT_DIREC_BOTH.\n";
    		return data;
    	}
		
    	
    	sc_int<W> result;
    	
    	if(MODE == ALT_SHIFT_MODE_ROTATE)
    	{
    		sc_bv<W> result_bv;
			sc_bv<W> data_bv;
			data_bv = (sc_bv<W>) data;
			result_bv = data_bv.lrotate(shift);
			result = (sc_int<W>) result_bv;
			
    	}
    	else if(MODE == ALT_SHIFT_MODE_LOGICAL)
    	{
    		result = data << shift;
    	} 
    	else if(MODE == ALT_SHIFT_MODE_ARITH)
    	{
    		result = data << shift;
    	} 
    	else
    	{
            cout << "WARNING: Shift Mode " << MODE << " is not supported\n";    		
    	}
    	
    	return result;
    }

	sc_bv<W> leftBV(const sc_bv<W> &data, const sc_uint<SHIFT_W> &shift)
    {
    	if(DIRECTION == ALT_SHIFT_DIREC_RIGHT)
    	{
    		cout << "WARNING: Left shift is not supported on ALT_SHIT with DIRECTION = ALT_SHIFT_DIREC_RIGHT.\n";
			cout << "         Consider using DIRECTION = ALT_SHIFT_DIREC_LEFT or  DIRECTION = ALT_SHIFT_DIREC_BOTH.\n";
    		return data;
    	}
		
    	
    	sc_bv<W> result;
    	
    	if(MODE == ALT_SHIFT_MODE_ROTATE)
    	{
			result = data;
			result = result.lrotate(shift);
    	}
    	else if(MODE == ALT_SHIFT_MODE_LOGICAL)
    	{
    		result = data << shift;
    	} 
    	else if(MODE == ALT_SHIFT_MODE_ARITH)
    	{
    		result = data << shift;
    	} 
    	else
    	{
            cout << "WARNING: Shift Mode " << MODE << " is not supported\n";    		
    	}
    	
    	return result;
    }


    sc_ufix leftUF(const sc_ufix &data, const sc_uint<SHIFT_W> &shift)
    {
    	if(DIRECTION == ALT_SHIFT_DIREC_RIGHT)
    	{
    		cout << "WARNING: Left shift is not supported on ALT_SHIT with DIRECTION = ALT_SHIFT_DIREC_RIGHT.\n";
			cout << "         Consider using DIRECTION = ALT_SHIFT_DIREC_LEFT or  DIRECTION = ALT_SHIFT_DIREC_BOTH.\n";
    		return data;
    	}
		
    	
    	sc_ufix result(W, data.iwl(), SC_TRN, SC_WRAP, 0);

    	if(MODE == ALT_SHIFT_MODE_ROTATE)
    	{
    		
			cout << "WARNING: Fixed Rotation not supported on ALT_SHIFT,\n"; 
			result = data;
			
    	}
    	else if(MODE == ALT_SHIFT_MODE_LOGICAL)
    	{
    		result = data << shift;
    	} 
    	else if(MODE == ALT_SHIFT_MODE_ARITH)
    	{
		    result = data << shift;
			
    	} 
    	else
    	{
            cout << "WARNING: Shift Mode " << MODE << " is not supported\n";    		
    	}
    	
    	return result;
    }

	sc_fix leftSF(const sc_fix &data, const sc_uint<SHIFT_W> &shift)
    {
    	if(DIRECTION == ALT_SHIFT_DIREC_RIGHT)
    	{
    		cout << "WARNING: Left shift is not supported on ALT_SHIT with DIRECTION = ALT_SHIFT_DIREC_RIGHT.\n";
			cout << "         Consider using DIRECTION = ALT_SHIFT_DIREC_LEFT or  DIRECTION = ALT_SHIFT_DIREC_BOTH.\n";
    		return data;
    	}
		
    	
    	sc_fix result(W, data.iwl(), SC_TRN, SC_WRAP, 0);
    	
    	if(MODE == ALT_SHIFT_MODE_ROTATE)
    	{
   		   cout << "WARNING: Fixed Rotation not supported on ALT_SHIFT,\n"; 
		   result = data;

    	}
    	else if(MODE == ALT_SHIFT_MODE_LOGICAL)
    	{
    		result = data << shift;
			
    	} 
    	else if(MODE == ALT_SHIFT_MODE_ARITH)
    	{
    		result = data << shift;
    	} 
    	else
    	{
            cout << "WARNING: Shift Mode " << MODE << " is not supported\n";    		
    	}
    	
    	return result;
    }


    
    sc_uint<W> rightUI(const sc_uint<W> &data, const sc_uint<SHIFT_W> &shift)
    {
    	if(DIRECTION == ALT_SHIFT_DIREC_LEFT)
    	{
    		cout << "WARNING: Right shift is not supported on ALT_SHIT with DIRECTION = ALT_SHIFT_DIREC_LEFT.\n";
			cout << "         Consider using DIRECTION = ALT_SHIFT_DIREC_RIGHT or  DIRECTION = ALT_SHIFT_DIREC_BOTH.\n";
    		return data;
    	}
		
    	
    	sc_uint<W> result;
    	
    	if(MODE == ALT_SHIFT_MODE_ROTATE)
    	{
    		sc_bv<W> result_bv;
			sc_bv<W> data_bv;
			data_bv = (sc_bv<W>) data;
			result_bv = data_bv.rrotate(shift);
			result = (sc_uint<W>) result_bv;
			
    	}
    	else if(MODE == ALT_SHIFT_MODE_LOGICAL)
    	{
			result = data >> shift;
    	} 
    	else if(MODE == ALT_SHIFT_MODE_ARITH)
    	{
    		cout << "WARNING: Unsigned integer arithmetic right shift is not supported on ALT_SHIFT.\n";
			cout << "         Consider using logical shift instead.\n";
		    result = data;
    	} 
    	else
    	{
            cout << "WARNING: Shift Mode " << MODE << " is not supported\n";    		
    	}
    	
    	return result;
    }


	sc_int<W> rightSI(const sc_int<W> &data, const sc_uint<SHIFT_W> &shift)
    {
    	if(DIRECTION == ALT_SHIFT_DIREC_LEFT)
    	{
    		cout << "WARNING: Right shift is not supported on ALT_SHIT with DIRECTION = ALT_SHIFT_DIREC_LEFT.\n";
    		cout << "         Consider using DIRECTION = ALT_SHIFT_DIREC_RIGHT or  DIRECTION = ALT_SHIFT_DIREC_BOTH.\n";
			return data;
    	}
		
    	
    	sc_int<W> result;
    	
    	if(MODE == ALT_SHIFT_MODE_ROTATE)
    	{
    		sc_bv<W> result_bv;
			sc_bv<W> data_bv;
			data_bv = (sc_bv<W>) data;
			result_bv = data_bv.rrotate(shift);
			result = (sc_int<W>) result_bv;
			
    	}
    	else if(MODE == ALT_SHIFT_MODE_LOGICAL)
    	{
    		sc_uint<W> data_int;
			data_int = (sc_uint<W>) data;
			result = data_int >> shift;
    	} 
    	else if(MODE == ALT_SHIFT_MODE_ARITH)
    	{
    		result = data >> shift;
    	} 
    	else
    	{
            cout << "WARNING: Shift Mode " << MODE << " is not supported\n";    		
    	}
    	
    	return result;
    }


	sc_bv<W> rightBV(const sc_bv<W> &data, const sc_uint<SHIFT_W> &shift)
    {
    	if(DIRECTION == ALT_SHIFT_DIREC_LEFT)
    	{
    		cout << "WARNING: Right shift is not supported on ALT_SHIT with DIRECTION = ALT_SHIFT_DIREC_LEFT.\n";
            cout << "         Consider using DIRECTION = ALT_SHIFT_DIREC_RIGHT or  DIRECTION = ALT_SHIFT_DIREC_BOTH.\n";
    		return data;
    	}
		
    	
    	sc_bv<W> result;
    	
    	if(MODE == ALT_SHIFT_MODE_ROTATE)
    	{
			result = data;
			result = result.rrotate(shift);
    	}
    	else if(MODE == ALT_SHIFT_MODE_LOGICAL)
    	{
    		result = data >> shift;
    	} 
    	else if(MODE == ALT_SHIFT_MODE_ARITH)
    	{
    		result = data >> shift;
    	} 
    	else
    	{
            cout << "WARNING: Shift Mode " << MODE << " is not supported\n";    		
    	}
    	
    	return result;
    }



	sc_ufix rightUF(const sc_ufix &data, const sc_uint<SHIFT_W> &shift)
    {
    	if(DIRECTION == ALT_SHIFT_DIREC_LEFT)
    	{
    		cout << "WARNING: Right shift is not supported on ALT_SHIT with DIRECTION = ALT_SHIFT_DIREC_LEFT.\n";
			cout << "         Consider using DIRECTION = ALT_SHIFT_DIREC_RIGHT or  DIRECTION = ALT_SHIFT_DIREC_BOTH.\n";
    		return data;
    	}
		
    	
    	sc_ufix result(W, data.iwl(), SC_TRN, SC_WRAP, 0);
    	    	
    	if(MODE == ALT_SHIFT_MODE_ROTATE)
    	{
    		cout << "WARNING: Fixed Rotation not supported on ALT_SHIFT,\n"; 
			result = data;
			
    	}
    	else if(MODE == ALT_SHIFT_MODE_LOGICAL)
    	{
    		result = data >> shift;
    	} 
    	else if(MODE == ALT_SHIFT_MODE_ARITH)
    	{
    		result = data >> shift;
    	} 
    	else
    	{
            cout << "WARNING: Shift Mode " << MODE << " is not supported\n";    		
    	}
    	
    	return result;
    }


	sc_fix rightSF(const sc_fix &data, const sc_uint<SHIFT_W> &shift)
    {
    	if(DIRECTION == ALT_SHIFT_DIREC_LEFT)
    	{
    		cout << "WARNING: Right shift is not supported on ALT_SHIT with DIRECTION = ALT_SHIFT_DIREC_LEFT.\n";
    		cout << "         Consider using DIRECTION = ALT_SHIFT_DIREC_RIGHT or  DIRECTION = ALT_SHIFT_DIREC_BOTH.\n";
			return data;
    	}
		
    	
    	sc_fix result(W, data.iwl(), SC_TRN, SC_WRAP, 0);
    	
    	if(MODE == ALT_SHIFT_MODE_ROTATE)
    	{
    	    cout << "WARNING: Fixed Rotation not supported on ALT_SHIFT,\n"; 
			result = data;
			
    	}
    	else if(MODE == ALT_SHIFT_MODE_LOGICAL)
    	{
    		sc_ufix data_int(W, data.iwl(), SC_TRN, SC_WRAP, 0);
			data_int = data;
			result = data_int >> shift;
    	} 
    	else if(MODE == ALT_SHIFT_MODE_ARITH)
    	{
    		result = data >> shift;
    	} 
    	else
    	{
            cout << "WARNING: Shift Mode " << MODE << " is not supported\n";    		
    	}
    	
    	return result;
    }
    
    
    /*


 
	sc_uint<W> rotrUI(sc_uint<W> data,  sc_uint<SHIFT_W> shift)
	{
		//dummy body
		sc_uint<W> me;
		for(int i = 0; i < W; i++){
		   me[(int(shift) + i) % W] = data[i];
		}
	   return me;    	
	}

	sc_int<W> rotrSI(sc_int<W> data,  sc_uint<SHIFT_W> shift)
	{
		//dummy body
		sc_int<W> me;
		for(int i = 0; i < W; i++){
		   me[(int(shift) + i) % W] = data[i];
		}
	   return me;    	
	}

  */
};
#endif
#endif
