/*******************************************************************
 * 
 * Immediate function units.
 * 
 * 
 * 
 * Abbreviations :
 *  W          = WIDTH
 *  L          = LATENCY
 *  R          = RESTART
 * 
 * 
 * Notes :
 *  (1) Do not include this file directly - include alt_cusp.h
 * 
 * 
 * Function Unit Models:
 * 
 * ALT_IMMED the following operations for simulation and synthesis :
 * (1)  Value setting
 *       (a) Unsigned integer
 *       (b) Signed integer
 *       (c) Unsigned fixed point
 *       (d) Signed fixed point
 *       (e) Bit vector
 * 
 *  
 *******************************************************************/


#ifndef __ALT_CUSP_H
#include <alt_cusp.h>
#endif


#ifndef __ALT_IMMED_H
#define __ALT_IMMED_H
/*******************************************************************
 * Immediate function unit and its named static operators
 *******************************************************************/
 
template <int W=16, int L=0, int R=1> 
class ALT_IMMED
{

public:
	static sc_int<W> setSI(sc_int<W> a)
	{
		return a; 
	}
   
	static sc_uint<W> setUI(sc_uint<W> a)
	{
		return a; 	 
	}
   
	static sc_bv<W> setBV(sc_bv<W> a)
	{
		return a; 	 
	}
   
	static sc_fix setSF(sc_fix a)
	{
		sc_fix aTrn = ALT_UTIL::truncateSF(a, W);
		ALT_UTIL::warnIfNotEqualsSF(a, aTrn);
		return aTrn;
	}
   
	static sc_ufix setUF(sc_fix a)
	{
		sc_ufix aTrn = ALT_UTIL::truncateUF(a, W);
		ALT_UTIL::warnIfNotEqualsUF(a, aTrn);
		return aTrn;
	}
	
	static float setSP(float a)
	{
		return a; 
	}
   
	static double setDP(double a)
	{
		return a; 	 
	}
};
#endif
