/*******************************************************************
 * 
 * Utility methods.
 * 
 *******************************************************************/


#ifndef __ALT_CUSP_H
#include <alt_cusp.h>
#endif

#ifndef __ALT_UTIL_H
#define __ALT_UTIL_H

class ALT_UTIL
{
public:
    static void warnIfNotEqualsSF(const sc_fix &originalVal, const sc_fix &transformedVal) 
    {
    	if(originalVal != transformedVal)
    	{
    	    std::cout << "Value " << originalVal << " (" << originalVal.wl() 
    	              << "," << originalVal.iwl() << ") truncated and/or wrapped to value " 
    	              << transformedVal << " (" << transformedVal.wl() << "," 
    	              << transformedVal.iwl() <<")\n";
    	}
    }

	static void warnIfNotEqualsUF(const sc_ufix &originalVal, const sc_ufix &transformedVal) 
    {
    	if(originalVal != transformedVal)
    	{
    	    std::cout << "Value " << originalVal << " (" << originalVal.wl() 
    	              << "," << originalVal.iwl() << ") truncated and/or wrapped to value " 
    	              << transformedVal << " (" << transformedVal.wl() << "," 
    	              << transformedVal.iwl() <<")\n";
    	}
    }
    static sc_fix truncateSF(const sc_fix &a, int bitWidth) 
    {
       sc_fix result(bitWidth, a.iwl(), SC_TRN, SC_WRAP, 0);
       result = a;
       return result;
    } 
    
    static sc_ufix truncateUF(const sc_ufix &a, int bitWidth) 
    {
       sc_ufix result(bitWidth, a.iwl(), SC_TRN, SC_WRAP, 0);
       result = a;
       return result;
    } 
};
#endif
