 
#ifdef SYSTEMC_H
#ifndef SC_INCLUDE_FX
#error "SystemC must be built with SC_INCLUDE_FX defined for cusp"
#endif
#endif

#ifndef SC_INCLUDE_FX
#define SC_INCLUDE_FX 
#endif 

#ifndef SYSTEMC_H
/* We put the same guard around included systemc.h as is in systemc.h
   to not have to have a dummy file around */
#include <systemc.h>
#endif
 
#ifndef __ALT_CUSP_H
#define __ALT_CUSP_H

#include <cusp/fuLib/alt_shift.h>
#include <cusp/fuLib/alt_mem.h>

#ifndef ALT_CUSP_SYNTHESIS_ON

#include <cusp/alt_util.h>
#include <cusp/alt_exception.h>

#include <cusp/fuLib/alt_au.h>
#include <cusp/fuLib/alt_reg.h>
#include <cusp/fuLib/alt_mult.h>
#include <cusp/fuLib/alt_immed.h>
#include <cusp/fuLib/alt_cmp.h>



#include <cusp/fuLib/alt_gpio.h>
#include <cusp/simlib/alt_gpio_channel.h>
#include <cusp/fuLib/alt_atlantic.h>
#include <cusp/simlib/alt_atlantic_channel.h>

#include <cusp/simlib/alt_avalon_bus.h>
#include <cusp/fuLib/alt_avalon.h>

#include <cusp/fuLib/alt_fifo.h>
#include <cusp/fuLib/alt_fifo_paged.h>

#include <cusp/simlib/alt_pc.h>
#include <cusp/simlib/alt_exit.h>
#include <cusp/simlib/alt_debug.h>
#include <cusp/simlib/alt_overlay.h>

#include <cusp/fuLib/alt_fp_mult.h>
#include <cusp/fuLib/alt_fp_au.h>
#include <cusp/fuLib/alt_fp_cmp.h>

// ignore the synthesis directives if not needed
#define ALT_CUSP_SYNTHESIS_ON
#define ALT_CUSP_SYNTHESIS_OFF
#define BIND(ARG)
#define ALT_CUSP_MAKE_INIT_STATE(ARRAYNAME, HEXFILENMAME)

#define ALT_ATTRIB(ATTRIB_CODE, ATTRIB_VALUE)

// hints to the scheduler

#define ALT_BARRIER0()
#define ALT_BARRIER1()

// memory port binding
#define ALT_PORTA(X) (X)
#define ALT_PORTB(X) (X)
// number evaluation
#define ALT_EVALUATE(X) (X)
// no sequencing edge
#define ALT_NOSEQUENCE(X) (X)
// add pipeline registers to the read from X of N stages, 0 for none/default
#define ALT_STAGE(X, N) (X)
// delay the start of a statement X for N cycles, 0 for none/default
#define ALT_DELAY(X, N) (X)

#else

#define BIND(ARG) __attribute__((section(#ARG)))

#endif 



// First Parameters for the ALT_ATTRIB(x,y) attribute
#define ALT_MIN_ITER -1000 // Minimum iterations of loop
#define ALT_MAX_ITER -1001 // Maximum iterations of loop
#define ALT_STEP_ITER -1002 // Step of the loop - eg. if the loop stops at either 0,3,6,9,etc iterations. its step is 3
#define ALT_MOD_SCHED -1003 // Whether to modulo schedule or not 
#define ALT_UNROLL -1004 // Whether to unroll or not
#define ALT_TILE -1005 // whether to tile or not
#define ALT_MOD_TARGET -1006 // Target number of clock cycles for modulo'd loop

#define ALT_UNDEFINED -1
#define ALT_INFINITY -2
#define ALT_MOD_SCHED_ON -3
#define ALT_MOD_SCHED_OFF -4
#define ALT_MOD_SCHED_ON_NOPROLOG -9 // Modulo schedule on, but with no prolog (may make first few cycles behave unexpectedly)
#define ALT_UNROLL_ON -5
#define ALT_UNROLL_OFF -6
#define ALT_TILE_ON -7
#define ALT_TILE_OFF -8

#endif 


