--------------------------------------------------------------------------------
--------------------------
--
-- STRATIXGX_HSSI_TRANSMITTER
--
-- Wysiwyg include file for Aurora HSSI Transmitter
--
-- (c) Altera Corporation, 2002
--
--------------------------------------------------------------------------------

FUNCTION stratixgx_hssi_transmitter(
                                  datain[CHANNEL_WIDTH-1..0],
                                  pllclk,
                                  fastpllclk,
                                  coreclk,
                                  softreset,
                                  analogreset,
                                  ctrlenable[(USE_DOUBLE_DATA_MODE=="TRUE") ? 1 : 0..0],
                                  forcedisparity[(USE_DOUBLE_DATA_MODE=="TRUE") ? 1 : 0..0],
                                  serialdatain,
                                  xgmdatain[7..0],
                                  xgmctrl,
                                  srlpbk,
                                  vodctrl[2..0],
                                  preemphasisctrl[2..0]
                                ) 
                         WITH ( 
                                  CHANNEL_NUM,
                                  CHANNEL_WIDTH,
                                  USE_DOUBLE_DATA_MODE,
                                  USE_8B_10B_MODE,
                                  USE_FIFO_MODE,
                                  FORCE_DISPARITY_MODE,
                                  TRANSMIT_PROTOCOL,
                                  USE_VOD_CTRL_SIGNAL,
                                  VOD_CTRL_SETTING,
                                  USE_PREEMPHASIS_CTRL_SIGNAL,
                                  PREEMPHASIS_CTRL_SETTING,
                                  USE_SELF_TEST_MODE,
                                  SELF_TEST_MODE,
                                  USE_REVERSE_PARALLEL_FEEDBACK,
                                  TERMINATION
                                )
                        RETURNS (
                                  dataout,
                                  xgmdataout[7..0],
                                  xgmctrlenable,
                                  rdenablesync,
                                  parallelfdbkdata[(USE_8B_10B_MODE == "TRUE") ? 9 : (USE_DOUBLE_DATA_MODE == "TRUE") ? ((CHANNEL_WIDTH / 2) - 1) : (CHANNEL_WIDTH - 1)..0],
                                  pre8b10bdata[(USE_8B_10B_MODE == "TRUE") ? 7 : (USE_DOUBLE_DATA_MODE == "TRUE") ? ((CHANNEL_WIDTH / 2) - 1) : (CHANNEL_WIDTH - 1)..0]
                                );
