--------------------------------------------------------------------------------
--------------------------
--
-- STRATIXGX_HSSI_RECEIVER.INC
--
-- Wysiwyg include file for Aurora HSSI receiver
--
-- (c) Altera Corporation, 2002
--
--------------------------------------------------------------------------------

FUNCTION stratixgx_hssi_receiver(
                               datain, 
                               cruclk,
                               pllclk,
                               masterclk,
                               coreclk,
                               softreset,
                               analogreset,
                               serialfdbk,
                               parallelfdbk[(USE_8B_10B_MODE == "TRUE") ? 9 : (USE_DOUBLE_DATA_MODE == "TRUE") ? ((CHANNEL_WIDTH / 2) - 1) : (CHANNEL_WIDTH - 1)..0],
                               post8b10b[(USE_8B_10B_MODE == "TRUE") ? 7 : (USE_DOUBLE_DATA_MODE == "TRUE") ? ((CHANNEL_WIDTH / 2) - 1) : (CHANNEL_WIDTH - 1)..0],
                               slpbk,
                               bitslip,
                               enacdet,
                               we,
                               re,
                               alignstatus,
                               disablefifordin,
                               disablefifowrin,
                               fifordin,
                               enabledeskew,
                               fiforesetrd,
                               xgmdatain[7..0],
                               xgmctrlin,
                               a1a2size,
                               equalizerctrl[2..0],
                               locktorefclk,
                               locktodata
                             )
	                WITH (
                               CHANNEL_NUM,
                               CHANNEL_WIDTH,
                               RUN_LENGTH,
                               RUN_LENGTH_ENABLE,
                               USE_8B_10B_MODE,
                               USE_DOUBLE_DATA_MODE,
                               USE_RATE_MATCH_FIFO,
                               RATE_MATCHING_FIFO_MODE,
                               USE_CHANNEL_ALIGN,
                               USE_SYMBOL_ALIGN,
                               USE_AUTO_BIT_SLIP,
                               SYNCHRONIZATION_MODE, 
                               ALIGN_PATTERN, 
                               ALIGN_PATTERN_LENGTH, 
                               INFINIBAND_INVALID_CODE, 
                               DISPARITY_MODE,
                               CLK_OUT_MODE_REFERENCE,
                               CRUCLK_PERIOD,
	                       CRUCLK_MULTIPLIER,
                               USE_CRUCLK_DIVIDER,
                               USE_SELF_TEST_MODE,
                               SELF_TEST_MODE,
                               USE_PARALLEL_FEEDBACK,
                               USE_POST8B10B_FEEDBACK,
                               USE_EQUALIZER_CTRL_SIGNAL,
                               EQUALIZER_CTRL_SETTING,
			       SIGNAL_THRESHOLD_SELECT,
                               BANDWIDTH_TYPE,
                               ENABLE_DC_COUPLING,
                               VCO_BYPASS,
                               FORCE_SIGNAL_DETECT,
                               FOR_ENGINEERING_SAMPLE_DEVICE
                             )
	             RETURNS (
                               dataout[CHANNEL_WIDTH-1..0],
                               syncstatus[(USE_DOUBLE_DATA_MODE=="TRUE") ? 1 : 0..0], 
                               patterndetect[(USE_DOUBLE_DATA_MODE=="TRUE") ? 1 : 0..0], 
                               ctrldetect[(USE_DOUBLE_DATA_MODE=="TRUE") ? 1 : 0..0], 
                               errdetect[(USE_DOUBLE_DATA_MODE=="TRUE") ? 1 : 0..0], 
                               disperr[(USE_DOUBLE_DATA_MODE=="TRUE") ? 1 : 0..0], 
                               syncstatusdeskew,
                               adetectdeskew,
                               rdalign,
                               xgmdataout[7..0],
                               xgmctrldet,
                               xgmrunningdisp,
                               xgmdatavalid,
                               fifofull, 
                               fifoalmostfull, 
                               fifoempty, 
                               fifoalmostempty, 
                               disablefifordout,
                               disablefifowrout,
                               fifordout,
                               signaldetect, 
                               lock, 
                               freqlock, 
                               rlv, 
                               clkout, 
                               recovclkout,
                               bisterr,
                               bistdone,
                               a1a2sizeout[(USE_DOUBLE_DATA_MODE=="TRUE") ? 1 : 0..0]
                             );
