----------------------------------------------------------------------------------------------------------
--
-- ALTPLL.INC
--
-- Include file for the ALTPLL megafunction
--
-- (c) Altera Corporation, 2001
--
----------------------------------------------------------------------------------------------------------
FUNCTION altpll	(
					inclk[1..0],
					fbin,
					pllena,
					clkswitch,
					areset,
					pfdena,
					clkena[5..0],
					extclkena[3..0],
					scanclk,
					scanaclr,
					scandata,
					scanread,
					scanwrite
				)
				WITH
				(
					OPERATION_MODE,
					PLL_TYPE,
					QUALIFY_CONF_DONE,
					COMPENSATE_CLOCK,
					SCAN_CHAIN,
					-- Internal clock specifications
					CLK5_MULTIPLY_BY,
					CLK4_MULTIPLY_BY,
					CLK3_MULTIPLY_BY,
					CLK2_MULTIPLY_BY,
					CLK1_MULTIPLY_BY,
					CLK0_MULTIPLY_BY,
					CLK5_DIVIDE_BY,
					CLK4_DIVIDE_BY,
					CLK3_DIVIDE_BY,
					CLK2_DIVIDE_BY,
					CLK1_DIVIDE_BY,
					CLK0_DIVIDE_BY,
					CLK5_PHASE_SHIFT,
					CLK4_PHASE_SHIFT,
					CLK3_PHASE_SHIFT,
					CLK2_PHASE_SHIFT,
					CLK1_PHASE_SHIFT,
					CLK0_PHASE_SHIFT,
					CLK5_TIME_DELAY,
					CLK4_TIME_DELAY,
					CLK3_TIME_DELAY,
					CLK2_TIME_DELAY,
					CLK1_TIME_DELAY,
					CLK0_TIME_DELAY,
					CLK5_DUTY_CYCLE,
					CLK4_DUTY_CYCLE,
					CLK3_DUTY_CYCLE,
					CLK2_DUTY_CYCLE,
					CLK1_DUTY_CYCLE,
					CLK0_DUTY_CYCLE,
					-- External clock specifications
					EXTCLK3_MULTIPLY_BY,
					EXTCLK2_MULTIPLY_BY,
					EXTCLK1_MULTIPLY_BY,
					EXTCLK0_MULTIPLY_BY,
					EXTCLK3_DIVIDE_BY,
					EXTCLK2_DIVIDE_BY,
					EXTCLK1_DIVIDE_BY,
					EXTCLK0_DIVIDE_BY,
					EXTCLK3_PHASE_SHIFT,
					EXTCLK2_PHASE_SHIFT,
					EXTCLK1_PHASE_SHIFT,
					EXTCLK0_PHASE_SHIFT,
					EXTCLK3_TIME_DELAY,
					EXTCLK2_TIME_DELAY,
					EXTCLK1_TIME_DELAY,
					EXTCLK0_TIME_DELAY,
					EXTCLK3_DUTY_CYCLE,
					EXTCLK2_DUTY_CYCLE,
					EXTCLK1_DUTY_CYCLE,
					EXTCLK0_DUTY_CYCLE,
					PRIMARY_CLOCK,
					INCLK0_INPUT_FREQUENCY,
					INCLK1_INPUT_FREQUENCY,
					GATE_LOCK_SIGNAL,
					GATE_LOCK_COUNTER,
					LOCK_HIGH,
					LOCK_LOW,
					VALID_LOCK_MULTIPLIER,
					INVALID_LOCK_MULTIPLIER,
					SWITCH_OVER_ON_LOSSCLK,
					SWITCH_OVER_ON_GATED_LOCK,
					ENABLE_SWITCH_OVER_COUNTER,
					SWITCH_OVER_COUNTER,
					FEEDBACK_SOURCE,
					BANDWIDTH,
					BANDWIDTH_TYPE,
					SPREAD_FREQUENCY,
					DOWN_SPREAD,
					SWITCH_OVER_TYPE,
					-- Advanced use parameters
					VCO_MIN,
					VCO_MAX,
					VCO_CENTER,
					PFD_MIN,
					PFD_MAX,
					M_INITIAL,
					M,
					N,
					M2,
					N2,
					SS,
					L0_HIGH,
					L1_HIGH,
					G0_HIGH,
					G1_HIGH,
					G2_HIGH,
					G3_HIGH,
					E0_HIGH,
					E1_HIGH,
					E2_HIGH,
					E3_HIGH,
					L0_LOW,
					L1_LOW,
					G0_LOW,
					G1_LOW,
					G2_LOW,
					G3_LOW,
					E0_LOW,
					E1_LOW,
					E2_LOW,
					E3_LOW,
					L0_INITIAL,
					L1_INITIAL,
					G0_INITIAL,
					G1_INITIAL,
					G2_INITIAL,
					G3_INITIAL,
					E0_INITIAL,
					E1_INITIAL,
					E2_INITIAL,
					E3_INITIAL,
					L0_MODE,
					L1_MODE,
					G0_MODE,
					G1_MODE,
					G2_MODE,
					G3_MODE,
					E0_MODE,
					E1_MODE,
					E2_MODE,
					E3_MODE,
					L0_PH,
					L1_PH,
					G0_PH,
					G1_PH,
					G2_PH,
					G3_PH,
					E0_PH,
					E1_PH,
					E2_PH,
					E3_PH,
					M_PH,
					L0_TIME_DELAY,
					L1_TIME_DELAY,
					G0_TIME_DELAY,
					G1_TIME_DELAY,
					G2_TIME_DELAY,
					G3_TIME_DELAY,
					E0_TIME_DELAY,
					E1_TIME_DELAY,
					E2_TIME_DELAY,
					E3_TIME_DELAY,
					M_TIME_DELAY,
					N_TIME_DELAY,
					EXTCLK3_COUNTER,
					EXTCLK2_COUNTER,
					EXTCLK1_COUNTER,
					EXTCLK0_COUNTER,
					CLK5_COUNTER,
					CLK4_COUNTER,
					CLK3_COUNTER,
					CLK2_COUNTER,
					CLK1_COUNTER,
					CLK0_COUNTER,
					ENABLE0_COUNTER,
					ENABLE1_COUNTER,
					CHARGE_PUMP_CURRENT,
					LOOP_FILTER_R,
					LOOP_FILTER_C,
					SKIP_VCO,
					C0_HIGH,
					C1_HIGH,
					C2_HIGH,
					C3_HIGH,
					C4_HIGH,
					C5_HIGH,
					C0_LOW,
					C1_LOW,
					C2_LOW,
					C3_LOW,
					C4_LOW,
					C5_LOW,
					CO_INITIAL,
					C1_INITIAL,
					C2_INITIAL,
					C3_INITIAL,
					C4_INITIAL,
					C5_INITIAL,
					C0_MODE,
					C1_MODE,
					C2_MODE,
					C3_MODE,
					C4_MODE,
					C5_MODE,
					C0_PH,
					C1_PH,
					C2_PH,
					C3_PH,
					C4_PH,
					C5_PH,
					M_PH,
					C1_USE_CASC_IN,
					C2_USE_CASC_IN,
					C3_USE_CASC_IN,
					C4_USE_CASC_IN,
					C5_USE_CASC_IN,
					CLK5_COUNTER,
					CLK4_COUNTER,
					CLK3_COUNTER,
					CLK2_COUNTER,
					CLK1_COUNTER,
					CLK0_COUNTER,
					SCLKOUT0_PHASE_SHIFT,
					SCLKOUT1_PHASE_SHIFT,
					VCO_MULTIPLY_BY,
					VCO_DIVIDE_BY,
					VCO_POST_SCALE,
					-- Cyclone ii
					CLK2_OUTPUT_FREQUENCY,
					CLK1_OUTPUT_FREQUENCY,
					CLK0_OUTPUT_FREQUENCY,
					-- Connectivity Information
					PORT_CLKENA0,
					PORT_CLKENA1,
					PORT_CLKENA2,
					PORT_CLKENA3,
					PORT_CLKENA4,
					PORT_CLKENA5,
					PORT_EXTCLKENA0,
					PORT_EXTCLKENA1,
					PORT_EXTCLKENA2,
					PORT_EXTCLKENA3,
					PORT_EXTCLK0,
					PORT_EXTCLK1,
					PORT_EXTCLK2,
					PORT_EXTCLK3,
					PORT_CLKBAD0,
					PORT_CLKBAD1,
					PORT_ACTIVECLOCK,
					PORT_CLKLOSS,
					PORT_CLK5,
					PORT_CLK4,
					PORT_CLK3,
					PORT_CLK2,
					PORT_CLK1,
					PORT_CLK0,
					PORT_SCANDATA,
					PORT_SCANDATAOUT,
					PORT_SCANDONE,
					PORT_SCLKOUT1,
					PORT_SCLKOUT0,
					PORT_INCLK1,
					PORT_INCLK0,
					PORT_FBIN,
					PORT_PLLENA,
					PORT_CLKSWITCH,
					PORT_ARESET,
					PORT_PFDENA,
					PORT_SCANCLK,
					PORT_SCANACLR,
					PORT_SCANDATA,
					PORT_SCANREAD,
					PORT_SCANWRITE,
					PORT_ENABLE0,
					PORT_ENABLE1,
					PORT_LOCKED,
					-- Test Parameters
					M_TEST_SOURCE,
					C0_TEST_SOURCE,
					C1_TEST_SOURCE,
					C2_TEST_SOURCE,
					C3_TEST_SOURCE,
					C4_TEST_SOURCE,
					C5_TEST_SOURCE,
					SELF_RESET_ON_GATED_LOSS_LOCK
				)
				RETURNS
				(
					clk[5..0],
					extclk[3..0],
					clkbad[1..0],
					activeclock,
					locked,
					clkloss,
					scandataout,
					scandone,
					sclkout1,
					sclkout0,
					enable0,
					enable1
				);
