 
#define HAS_LONG_DOUBLE
#define HAS_PRIgldbl
#ifdef TRY_gconvert
#define Gconvert(x,n,t,b) gconvert((x),(n),(t),(b))
char *myname = "gconvert";
#endif
#ifdef TRY_gcvt
#define Gconvert(x,n,t,b) gcvt((x),(n),(b))
char *myname = "gcvt";
#endif
#ifdef TRY_qgcvt
#define Gconvert(x,n,t,b) qgcvt((x),(n),(b))
char *myname = "qgcvt";
#define DOUBLETYPE long double
#endif
#ifdef TRY_sprintf
#if defined(USE_LONG_DOUBLE) && defined(HAS_LONG_DOUBLE) && defined(HAS_PRIgldbl)
#define Gconvert(x,n,t,b) sprintf((b),"%.*""Lg",(n),(x))
#else
#define Gconvert(x,n,t,b) sprintf((b),"%.*g",(n),(x))
#endif
char *myname = "sprintf";
#endif

#ifndef DOUBLETYPE
#if defined(USE_LONG_DOUBLE) && defined(HAS_LONG_DOUBLE)
#define DOUBLETYPE long double
#else
#define DOUBLETYPE double
#endif
#endif

#include <stdio.h>

#define I_STDLIB define
#ifdef I_STDLIB
#include <stdlib.h>
#endif

int
checkit(expect, got)
char *expect;
char *got;
{
    if (strcmp(expect, got)) {
		printf("%s oddity:  Expected %s, got %s\n",
			myname, expect, got);
		exit(1);
	}
}

int main()
{ 
	char buf[64]; 
	buf[63] = '\0';

	/* This must be 1st test on (which?) platform */
	/* Alan Burlison <AlanBurlsin@unn.unisys.com> */
	Gconvert((DOUBLETYPE)0.1, 8, 0, buf);
	checkit("0.1", buf);

	Gconvert((DOUBLETYPE)1.0, 8, 0, buf); 
	checkit("1", buf);

	Gconvert((DOUBLETYPE)1.1, 8, 0, buf); 
	checkit("1.1", buf);

	Gconvert((DOUBLETYPE)1.01, 8, 0, buf); 
	checkit("1.01", buf);

	Gconvert((DOUBLETYPE)1.001, 8, 0, buf); 
	checkit("1.001", buf);

	Gconvert((DOUBLETYPE)1.0001, 8, 0, buf); 
	checkit("1.0001", buf);

	Gconvert((DOUBLETYPE)1.00001, 8, 0, buf); 
	checkit("1.00001", buf);

	Gconvert((DOUBLETYPE)1.000001, 8, 0, buf); 
	checkit("1.000001", buf);

	Gconvert((DOUBLETYPE)0.0, 8, 0, buf); 
	checkit("0", buf);

	Gconvert((DOUBLETYPE)-1.0, 8, 0, buf); 
	checkit("-1", buf);

	/* Some Linux gcvt's give 1.e+5 here. */
	Gconvert((DOUBLETYPE)100000.0, 8, 0, buf); 
	checkit("100000", buf);
	
	/* Some Linux gcvt's give -1.e+5 here. */
	Gconvert((DOUBLETYPE)-100000.0, 8, 0, buf); 
	checkit("-100000", buf);

	Gconvert((DOUBLETYPE)123.456, 8, 0, buf); 
	checkit("123.456", buf);

	exit(0);
}
