#########################################################################
# setup-mwuser.csh
# This file is to be "sourced" by C-shell users of Visual MainWin to set up the
# necessary environment variables for MainWin
#
# This file is used internally by setupmainwin.csh and setmwruntime.csh. Do not
# source it directly.
##########################################################################



if ( ${?MWSETUP_GUARD}) then
        if ("${MWHOME}" == "${MWSETUP_GUARD}" ) then
                exit 0;
        endif
endif

setenv lib_path_name LD_LIBRARY_PATH

#
# set the printarch variable if you want the message
#
if ($?printarch) then
    echo "Defining environment for Visual MainWin..."
endif

if (`uname` == SunOS) then
    if (`uname -r` =~ 5*) then 
	setenv MWOS sunos5
	if (`uname -m` =~ sun4*) then
	    setenv MWARCH sparc
	else
	    echo "Machine under sunos must be sun4"
	endif
    endif	
else if (`uname` == HP-UX) then
	if (`uname -r` =~ [AB].10*) then
	    setenv MWOS ux10
	    if (`uname -m` =~ 9000/[78]*) then
	    	setenv MWARCH hp700
	    else	
		echo "HP-UX machine must be 9000/700 or 800 series"
	    endif	
	else if (`uname -r` =~ [AB].11*) then
	          setenv MWOS ux11
	          if (`uname -m` =~ 9000/[78]*) then
	    		setenv MWARCH hp700
	          else if (`uname -m` =~ ia64) then
    		        setenv MWARCH ia64
  	          else	
	    	        echo "HP-UX machine must be 9000/700 or 800 series"
	          endif 
	else
	    echo "Unknown HP-UX version"
        endif
else if (`uname` == Linux) then
    setenv MWOS linux
    if ((`arch` =~ i*86) || (`arch` =~ ia64) || (`arch` =~ x86*)) then
        setenv MWARCH i86
    else
        echo "Unknown Linux processor"
    endif
else if (`uname` == AIX) then
    if (`uname -v` =~ [45]) then
        setenv MWOS aix4
        setenv MWARCH rs6000
    else
        echo "Unknown version of AIX"
    endif
else if (`uname` =~ IRIX*) then
    if (`uname -r` =~ 6.*) then 
    # Silicon Graphics
        setenv MWOS irix6
	setenv MWARCH mips
    else
        echo "Versions of IRIX other than 6.x are not supported"
    endif
else if (`uname` == OSF1) then
    if (`uname -r` =~ V[45].*) then
	setenv MWOS osf1v4
	setenv MWARCH alpha
    else
	echo "Versions of Compaq Tru64 UNIX other than 4.x/5.x are not supported"
    endif
else
    echo Unknown architecture and operating system.
endif

setenv MWARCH_OS "${MWARCH}_${MWOS}"
if ($?printarch) then
    echo "Architecture for Visual MainWin is ${MWARCH_OS}"
endif


#
# shared library path variables and aliases
#

switch(${MWOS})
case sunos5:
    if (! ${?OPENWINHOME}) then
        setenv OPENWINHOME /usr/openwin
    endif
    if (! ${?LD_LIBRARY_PATH}) then
        setenv LD_LIBRARY_PATH ""
    endif
    breaksw
case linux:
    if (! ${?LD_LIBRARY_PATH}) then
        setenv LD_LIBRARY_PATH ""
    endif
    breaksw
case ux10:
case ux11:
    if (! ${?SHLIB_PATH}) then
        setenv SHLIB_PATH ""
    endif
    setenv lib_path_name SHLIB_PATH
    breaksw
case aix4:
    if (! ${?LIBPATH}) then
        setenv LIBPATH ""
    endif
    setenv lib_path_name LIBPATH
    # For critical section (pthread_mutex) performance.
    setenv SPINLOOPTIME 1000
    setenv AIXTHREAD_MNRATIO 1:1
    breaksw
endsw

# Define the aliases
alias mwsetonce         'if (! ${?\!:1}) setenv \!:1 \!:2'
alias expand_lib_path    "eval setenv $lib_path_name "'\"$'"{${lib_path_name}}:\!*"'\"'
alias push_lib_path      "eval setenv $lib_path_name \!*\:"'\"$'"{${lib_path_name}}"'\"'

alias mwprefix 'set \!:1=\!:2\:"${\!:1}"'
alias mwpostfix 'set \!:1="${\!:1}":\!:2'

#
# Set minimal path
#
if (! ${?PATH} ) then
setenv PATH /bin:/usr/bin
endif

#
# Set path to include the MFW executables
#
setenv PATH "${MWHOME}"/bin:"${MWHOME}"/bin-${MWARCH_OS}:${PATH}

if ( -d "${MWHOME}"/../stingray ) then 
  setenv MWSTINGRAY_HOME `dirname "$MWHOME"`/stingray
endif

#
# Set ODBC home path
#
if ( -d "${MWHOME}"/../odbc/. ) then 
  setenv MWODBC_HOME `dirname "$MWHOME"`/odbc
  setenv ODBCINI     "$MWODBC_HOME/$MWOS/odbc.ini"
endif

if (! ${?HOME} ) then
setenv HOME "`gethome`"
endif

# setup usaer directory
if (! ${?MWUSER_DIRECTORY}) then
setenv MWUSER_DIRECTORY "${HOME}/.mw"
endif

# when in clearcase, set up MWCHROOT accordingly.
if (${?CLEARCASE_ROOT}) then
setenv MWCHROOT ${CLEARCASE_ROOT}
endif

#
# Set WinHelp search path
#
if (! ${?WINHELPPATH}) then
  setenv WINHELPPATH ".:${MWUSER_DIRECTORY}/helpfile:${MWHOME}/helpfile"
endif
