#!/bin/csh -x -f

if ( ! ${?MWHOME} )  then
    echo "You must set the MWHOME enviroment variable to use the MainWin Runtime Environment"
    exit
endif

source "$MWHOME"/setup-mwuser.csh


if (! ${?LD_LIBRARY_PATH}) then
        setenv LD_LIBRARY_PATH ""
endif
if (! ${?SHLIB_PATH}) then
        setenv SHLIB_PATH ""
endif
if (! ${?LIBPATH}) then
        setenv LIBPATH ""
endif


switch (${MWARCH_OS})
     case sparc_sunos5:			
			setenv PATH "${PATH}":/usr/openwin/bin
		    if (${?LD_LIBRARY_PATH}) then
				setenv LD_LIBRARY_PATH "${LD_LIBRARY_PATH}":/usr/openwin/lib
			else
			    setenv LD_LIBRARY_PATH /usr/openwin/lib
			endif
            setenv MWCONFIG_NAME sunos5
            breaksw
     case hp700_ux10:			
			setenv PATH "${PATH}":/usr/contrib/bin/X11
            setenv MWCONFIG_NAME ux10
            breaksw
     case hp700_ux11:
			setenv PATH "${PATH}":/usr/contrib/bin/X11
            setenv MWCONFIG_NAME ux11
            breaksw
     case ia64_ux11:
		setenv PATH "${PATH}":/usr/contrib/bin/X11
		setenv MWCONFIG_NAME ia64_ux11
		breaksw
  #case i86_sysvr4_2:
            #setenv MWCONFIG_NAME i86
            #breaksw
     case rs6000_aix4:
			setenv PATH "${PATH}":/usr/bin/X11
            setenv MWCONFIG_NAME aix4
            breaksw
     case alpha_osf1v4:
			setenv PATH "${PATH}":/usr/bin/X11
            setenv MWCONFIG_NAME osf1v4
            breaksw
     case mips_irix6:
			setenv PATH "${PATH}":/usr/bin/X11
		    setenv MWCLIPBOARD_WITHOUT_TIMER 1
            setenv MWCONFIG_NAME irix6
            breaksw
	 case i86_linux:
                if (${?PATH}) then
                     setenv PATH "${PATH}":/usr/bin/X11
                 else
                     setenv PATH /bin:/usr/bin:/sbin:/usr/etc:/usr/local/bin:/usr/bin/X11
                 endif

			setenv MWCONFIG_NAME linux
			breaksw
endsw

# setup MWREGISTRY to point to HKEY LOCAL MACHINE file
if (! ${?MWREGISTRY}) then
setenv MWREGISTRY "${MWUSER_DIRECTORY}/hklm_${MWCONFIG_NAME}.bin"
endif

set new_path = "${MWHOME}/bin-${MWCONFIG_NAME}_optimized"

if ( ${?MWDEBUG} ) then
	set new_libpath = "${MWHOME}/lib-${MWCONFIG_NAME}:${MWHOME}/lib-${MWCONFIG_NAME}_debug:${MWHOME}/lib-${MWCONFIG_NAME}_optimized"
else
	set new_libpath = "${MWHOME}/lib-${MWCONFIG_NAME}:${MWHOME}/lib-${MWCONFIG_NAME}_optimized"
endif

#Adding support for the stingray
if ( ${?MWSTINGRAY_HOME} ) then
   if ( -d "${MWSTINGRAY_HOME}" ) then
     set new_path = "${new_path}:${MWSTINGRAY_HOME}/bin-${MWCONFIG_NAME}_optimized"
      if ( ${?MWDEBUG} ) then
        set new_libpath = "${new_libpath}:${MWSTINGRAY_HOME}/lib-${MWCONFIG_NAME}_debug:${MWSTINGRAY_HOME}/lib-${MWCONFIG_NAME}_optimized"
      else
        set new_libpath = "${new_libpath}:${MWSTINGRAY_HOME}/lib-${MWCONFIG_NAME}_optimized"
      endif
   endif
endif

# Adding support for ODBC
if ( ${?MWODBC_HOME} ) then
   if ( -d "${MWODBC_HOME}"/. ) then
     set new_libpath = "${new_libpath}:${MWODBC_HOME}/${MWCONFIG_NAME}/lib"
   endif
endif

if (${MWOS} == linux) then
    setenv X11_LIB_DIR /usr/X11R6/lib
else if (${MWOS} == sunos5) then
    setenv X11_LIB_DIR ${OPENWINHOME}/lib
else if (${MWOS} == ux11) then
    setenv X11_LIB_DIR /usr/lib/X11R5
    mwsetonce OGL_LIB_DIR /opt/graphics/OpenGL/lib
else if (${MWOS} == aix4) then
    setenv X11_LIB_DIR /usr/lib
endif

#Add the GCC libraries for Linux
if ( "${MWARCH_OS}" == "i86_linux" ) then
   set gcclibdir = "${MWHOME}/../misc/linux/gcc/fixed3/lib"
   if ( -d "${gcclibdir}"/. ) then
      set new_libpath = "${new_libpath}:${gcclibdir}"
   endif
   set libgcc = libgcc_s.so.1
   if (( ! -r /lib/$libgcc ) && ( ! -r /usr/lib/$libgcc ) && ( -d ${gcclibdir}_rh7.3/. )) then
      set new_libpath = "${new_libpath}:${gcclibdir}_rh7.3"
   endif
   unset libgcc
   unset gcclibdir
endif

if (! ${?MWCURRENT_LIBPATH}) then
   setenv LD_LIBRARY_PATH "${new_libpath}":"${LD_LIBRARY_PATH}"
   setenv SHLIB_PATH "${new_libpath}":"${SHLIB_PATH}"
   setenv LIBPATH "${new_libpath}":"${LIBPATH}"
   # Tricky: PATH may already contain MainWin directories,
   # add the new ones after these.
   setenv PATH `echo :$PATH | sed "s,:${MWHOME},:@${MWHOME},g" | sed "s,:\([^@]\),:${new_path}:\1,"|sed -e 's,:@,:,g' -e 's,^:,,'`
#
else
   setenv LD_LIBRARY_PATH `echo ${LD_LIBRARY_PATH} | sed -e 's@'${MWCURRENT_LIBPATH}@"${new_libpath}"'@'`
    setenv SHLIB_PATH `echo ${SHLIB_PATH} | sed -e 's@'${MWCURRENT_LIBPATH}@"${new_libpath}"'@'`
    setenv LIBPATH `echo ${LIBPATH} | sed -e 's@'${MWCURRENT_LIBPATH}@"${new_libpath}"'@'`
    setenv PATH `echo ${PATH} | sed -e 's@'${MWCURRENT_PATH}@"${new_path}"'@'`
endif

setenv MWCURRENT_LIBPATH "${new_libpath}"
setenv MWCURRENT_PATH "${new_path}"
unset new_libpath
unset new_path
setenv MWRUNTIME 1

if ( "${MWOS}" == "aix4" || "${MWOS}" == "linux" ) then
    setenv LIBPATH `echo $LIBPATH |tr ":" "\012"|grep -v '^/usr/lib$'|tr "\012" ":"`
endif

if (${?X11_LIB_DIR}) then
    expand_lib_path $X11_LIB_DIR
endif

if (${?OGL_LIB_DIR}) then
   if (-d ${OGL_LIB_DIR}) then
       expand_lib_path ${OGL_LIB_DIR}
   endif
endif
