# -*- ksh -*-
# this function modifies the current LD_LIBRARY_PATH (on suns and sysVR4),
# SHLIB_PATH on HPUX LIBPATH on AIX to take into account the current
# configuration.
#
# mwuseconfig can be passed arguments like MWTECHNO=<value> or
# CC=<value> etc... to force a given configuration.
#

mwuseconfig () {
export MWCONFIG_NAME
export MWCURRENT_LIBPATH
export MWCURRENT_PATH
export LD_LIBRARY_PATH
export SHLIB_PATH
export LIBPATH
export PATH
old_env=${ENV:-}
ENV=
MWCONFIG_NAME=`"${MWHOME}/bin/mwgetconfigname" ${@:-} OUTPUT_FORMAT=SUFFIX`
ENV=${old_env}
#

export new_path
export new_libpath
new_path="${MWHOME}/bin-${MWCONFIG_NAME}_optimized"
new_libpath="${MWHOME}/lib-${MWCONFIG_NAME}_optimized"
if [ ! -z "${MWDEBUG:-}" -o ! -z "${MAINSOFT_DEBUG:-}" ];then
  mwprefix new_libpath "${MWHOME}/lib-${MWCONFIG_NAME}_debug"
  mwprefix new_path "${MWHOME}/bin-${MWCONFIG_NAME}_debug"
  if [ ! -z "${MWSTINGRAY_HOME:-}" ];then
    mwpostfix new_libpath "${MWSTINGRAY_HOME}/lib-${MWCONFIG_NAME}_debug"
    mwpostfix new_libpath "${MWSTINGRAY_HOME}/lib-${MWCONFIG_NAME}_optimized"
    mwpostfix new_path "${MWSTINGRAY_HOME}/bin-${MWCONFIG_NAME}_debug"
    mwpostfix new_path "${MWSTINGRAY_HOME}/bin-${MWCONFIG_NAME}_optimized"
  fi
else
  mwpostfix new_libpath "${MWHOME}/lib-${MWCONFIG_NAME}_debug"
  mwpostfix new_path "${MWHOME}/bin-${MWCONFIG_NAME}_debug"
  if [ ! -z "${MWSTINGRAY_HOME:-}" ];then
    mwpostfix new_libpath "${MWSTINGRAY_HOME}/lib-${MWCONFIG_NAME}_optimized"
    mwpostfix new_libpath "${MWSTINGRAY_HOME}/lib-${MWCONFIG_NAME}_debug"
    mwpostfix new_path "${MWSTINGRAY_HOME}/bin-${MWCONFIG_NAME}_optimized"
    mwpostfix new_path "${MWSTINGRAY_HOME}/bin-${MWCONFIG_NAME}_debug"
  fi
fi
if [ ! -z "${MWODBC_HOME:-}" ];then
  mwpostfix new_libpath ${MWODBC_HOME}/${MWCONFIG_NAME}/lib
fi

# Do NOT add the GCC libraries for Linux
# This should be taken care of by compiler_setup or setmwruntime,
#  depending on whether we are in development or runtime env.
#if [ "${MWARCH_OS}" = "i86_linux" ] ; then
#   gcclibdir=${MWHOME}/lib-${MWARCH_OS}
#   if [ -d ${gcclibdir}/. ] ; then
#      mwpostfix new_libpath ${gcclibdir}
#   fi
#   unset gcclibdir
#fi

#
#echo "library path becomes: ${new_libpath}"
#
if [ "${MWCURRENT_LIBPATH:-notset}" = "notset" ] ; then
    LD_LIBRARY_PATH="${new_libpath}":"${LD_LIBRARY_PATH:-}"
    SHLIB_PATH="${new_libpath}":"${SHLIB_PATH:-}"
    LIBPATH="${new_libpath}":"${LIBPATH:-}"
    PATH="${new_path}":"${PATH}"
#
else
#
  LD_LIBRARY_PATH=`echo $LD_LIBRARY_PATH | sed -e 's@'"${MWCURRENT_LIBPATH}"@"$new_libpath"'@'`
  SHLIB_PATH=`echo $SHLIB_PATH | sed -e 's@'"${MWCURRENT_LIBPATH}"@"$new_libpath"'@'`
  LIBPATH=`echo $LIBPATH | sed -e 's@'"${MWCURRENT_LIBPATH}"@"$new_libpath"'@'`
  PATH=`echo $PATH | sed -e 's@'"${MWCURRENT_PATH}"@"$new_path"'@'`
fi
#
MWCURRENT_LIBPATH="${new_libpath}"
MWCURRENT_PATH="${new_path}"
unset new_libpath
unset new_path
}
