setenv MWCONFIG_NAME `"${MWHOME}"/bin/mwgetconfigname ${*} OUTPUT_FORMAT=SUFFIX`

if (! ${?LD_LIBRARY_PATH}) then
	setenv LD_LIBRARY_PATH ""
endif
if (! ${?SHLIB_PATH}) then
	setenv SHLIB_PATH ""
endif
if (! ${?LIBPATH}) then
	setenv LIBPATH ""
endif

set new_path="${MWHOME}/bin-${MWCONFIG_NAME}_optimized"
set new_libpath="${MWHOME}/lib-${MWCONFIG_NAME}_optimized"
if ( ${?MWDEBUG}  ||  ${?MAINSOFT_DEBUG} ) then
  mwprefix new_libpath "${MWHOME}/lib-${MWCONFIG_NAME}_debug"
  mwprefix new_path "${MWHOME}/bin-${MWCONFIG_NAME}_debug"
  if ( ${?MWSTINGRAY_HOME} ) then
    mwpostfix new_libpath "${MWSTINGRAY_HOME}/lib-${MWCONFIG_NAME}_debug"
    mwpostfix new_libpath "${MWSTINGRAY_HOME}/lib-${MWCONFIG_NAME}_optimized"
    mwpostfix new_path "${MWSTINGRAY_HOME}/bin-${MWCONFIG_NAME}_debug"
    mwpostfix new_path "${MWSTINGRAY_HOME}/bin-${MWCONFIG_NAME}_optimized"
  endif
else
  mwpostfix new_libpath "${MWHOME}/lib-${MWCONFIG_NAME}_debug"
  mwpostfix new_path "${MWHOME}/bin-${MWCONFIG_NAME}_debug"
  if ( ${?MWSTINGRAY_HOME} ) then
    mwpostfix new_libpath "${MWSTINGRAY_HOME}/lib-${MWCONFIG_NAME}_optimized"
    mwpostfix new_libpath "${MWSTINGRAY_HOME}/lib-${MWCONFIG_NAME}_debug"
    mwpostfix new_path "${MWSTINGRAY_HOME}/bin-${MWCONFIG_NAME}_optimized"
    mwpostfix new_path "${MWSTINGRAY_HOME}/bin-${MWCONFIG_NAME}_debug"
  endif
endif

if ( ${?MWODBC_HOME} ) then
  mwpostfix new_libpath "${MWODBC_HOME}/${MWCONFIG_NAME}/lib"
endif

# Do NOT add the GCC libraries for Linux
# This should be taken care of by compiler_setup or setmwruntime,
#  depending on whether we are in development or runtime env.
#if ( "${MWARCH_OS}" == "i86_linux" ) then
#   set gcclibdir = ${MWHOME}/lib-${MWARCH_OS}
#   if ( -d ${gcclibdir}/. ) then
#      mwpostfix new_libpath ${gcclibdir}
#   endif
#   unset gcclibdir
#endif

if (! ${?MWCURRENT_LIBPATH}) then
    setenv LD_LIBRARY_PATH "${new_libpath}":"${LD_LIBRARY_PATH}"
    setenv SHLIB_PATH "${new_libpath}":"${SHLIB_PATH}"
    setenv LIBPATH "${new_libpath}":"${LIBPATH}"
    setenv PATH "${new_path}":"${PATH}"
else
    setenv LD_LIBRARY_PATH `echo ${LD_LIBRARY_PATH} | sed -e 's@'${MWCURRENT_LIBPATH}@"${new_libpath}"'@'`
    setenv SHLIB_PATH `echo ${SHLIB_PATH} | sed -e 's@'${MWCURRENT_LIBPATH}@"${new_libpath}"'@'`
    setenv LIBPATH `echo ${LIBPATH} | sed -e 's@'${MWCURRENT_LIBPATH}@"${new_libpath}"'@'`
    setenv PATH `printenv PATH | sed -e 's@'${MWCURRENT_PATH}@"${new_path}"'@'`
endif
setenv MWCURRENT_LIBPATH "${new_libpath}"
setenv MWCURRENT_PATH "${new_path}"
unset new_libpath
unset new_path

