# mwgetether.pl
# Returns ethernet address of the localhost
# Used in rpcrt4 lib where ioctl SIOCGARP fails


package EthernetAddress;
{
    sub new;           # polymorphism
    sub print;
    sub format;        # pure virtual
    sub getStatus;


    sub new
    {
	my $type = shift;
	my $self = bless {}, $type;
	$self->{"ethernet_pattern"} = '([0-9a-fA-F]{2}:){5}[0-9a-fA-F]{2}';
	return $self;
    }

    sub print
    {
	my $self = shift;
	open (RESULT, "$self->{'command'}|") 
	    || die "cannot perform $self->{'command'}";
	$self->{"status"} = $self->format(\*RESULT);
	if (! $self->{"status"}) {
	    print $self->{"address"};
	}
	else {
	    print STDERR  "Unable to Extract Ethernet Address from $self->{'command'}\n";
	}
    }   

    sub getStatus
    {
	my $self = shift;
	return $self->{"status"};
    }

}

package EthernetAddress_sunos5; @ISA = qw (EthernetAddress);
{
    sub new;
    sub format;

    sub new
    {
	my $self = EthernetAddress::new (shift);
	$self->{"command"} = "/usr/sbin/arp -a";
	return $self;
    }

    sub format
    {
	my ($self, $fh) = @_;
	my $host = $ENV{'HOST'};
	while (<$fh>) 
	{
	    if (/$host/) {
		s/.*\s+($self->{"ethernet_pattern"})/$1/;
		s/://g;
		$self->{"address"} = $_;
		return 0;
	    }
	}
	return -1;
    }
}

package EthernetAddress_irix6; @ISA = qw (EthernetAddress);
{
    sub new;
    sub format;

    sub new
    {
	my $self = EthernetAddress::new (shift);
	$self->{"command"} = "/usr/etc/netstat -ia";
	return $self;
    }

    sub format
    {
	my ($self, $fh) = @_;
	while (<$fh>) 
	{
	    if (s/.*\s+($self->{"ethernet_pattern"})/$1/) {
		s/://g;
		$self->{"address"} = $_;
		return 0;
	    }
	}
	return -1;
    }
}

package EthernetAddress_ux10; @ISA = qw (EthernetAddress);
{
    sub new;
    sub format;

    sub new
    {
	my $self = EthernetAddress::new (shift);
	$self->{"command"} = "/etc/lanscan -a";
	return $self;
    }

    sub format
    {
	my ($self, $fh) = @_;
	while (<$fh>) 
	{
	    if (s/^0[xX]([0-9A-Fa-f]{12})/$1/) {
		$self->{"address"} = $_;
		return 0;
	    }
	}
	return -1;
    }
}

# ux11 is like ux10
package EthernetAddress_ux11; @ISA = qw (EthernetAddress_ux10);

# aix looks almost like irix
package EthernetAddress_aix4; @ISA = qw (EthernetAddress_irix6);
{
	sub new;

	sub new
	{
		my $self = EthernetAddress::new (shift);
		$self->{"command"} = "/bin/netstat -ia";
		return $self;
	}
}

package EthernetAddress_osf1v4; @ISA = qw (EthernetAddress);
{
    sub new;
    sub format;

    sub new
    {
	my $self = EthernetAddress::new (shift);
	$self->{"command"} = "/usr/sbin/netstat -i";
	return $self;
    }

    sub format
    {
	my ($self, $fh) = @_;
	while (<$fh>) 
	{
	    if (s/.*\s+($self->{"ethernet_pattern"})/$1/) {
		s/://g;
		$self->{"address"} = $_;
		return 0;
	    }
	}
	return -1;
    }
}

package EthernetAddress_linux; @ISA = qw (EthernetAddress);
{
    sub new;
    sub format;

    sub new
    {
	my $self = EthernetAddress::new (shift);
	$self->{"command"} = "/sbin/ifconfig";
	return $self;
    }

    sub format
    {
	my ($self, $fh) = @_;
	while (<$fh>) 
	{
	    if (s/.*\s+($self->{"ethernet_pattern"})/$1/) {
		s/://g;
		$self->{"address"} = $_;
		return 0;
	    }
	}
	return -1;
    }
}
package main;

my $os = $ENV{'MWOS'};

my $etheraddclass = "EthernetAddress_${os}";
my $etheradd = new  $etheraddclass ();


$etheradd->print();
 
exit $etheradd->getStatus();


