#! /bin/sh

# local vars
env_script=""
exec_dir=""
executable=""
exec_name=""
exec_line=""
exec_dir_inited=0
arg=""
found=0
cmd_line=""

# parse args
while [ $# -ge 1 ] ; do
    case $1 in
    -exec_dir) shift; exec_dir=$1; exec_dir_inited=1 ;;
    -exec)     shift; executable=$1; exec_line=$exec_line" "$executable ;;
    *)         exec_line=$exec_line" "$1 ;;
    esac
    shift
done

# get executable base name
exec_name=`basename $executable`

if [ $exec_dir_inited -eq 0  ]; then
    exec_dir=`dirname $executable`
fi

# echo "exec_dir  = "$exec_dir
# echo "exec_name = "$exec_name
# echo "exec_line = "$exec_line

# routine checks file
CheckForFile() 
{
    if test -f $1; then
        env_script=$1
        found=1
    fi
    return
}

# if exe name is name.exe - look for name.init
# check that the exe extension really exists
temp_name=`echo $exec_name | sed 's/\.exe$/\.init/'`
if test $temp_name != $exec_name; then
    CheckForFile $exec_dir"/"$temp_name
fi

# look for <exe_name>.init
if [ $found -eq 0 ]; then
    CheckForFile $exec_dir"/"$exec_name".init"
fi

# if server's init file not found - look for common init file in the server's directory
if [ $found -eq 0 ]; then
    CheckForFile $exec_dir"/init"
fi

if [ $found -eq 0 ]; then
    echo "cannot find initialization script for server"$exec_dir/$exec_name
    exit 2
fi

# last check point - lets check that the file is exe
if test -x $env_script; then
    cmd_line=$env_script" "$exec_line
    exec $cmd_line
else
    echo "the init file "$env_script" is not an executable"
    exit 8
fi

exit 0
