# --- This is a perl file ----


BEGIN {
  $curdir=`dirname "$0"`;
  chomp($curdir);
  $pwd="`pwd`";
  chomp($pwd);
  if($curdir eq "."){ $fulldir="$pwd";}
  elsif ($curdir =~ /^\//) {$fulldir=$curdir;}
  else {$fulldir="$pwd/$curdir";}
  push(@INC,"$fulldir","$fulldir/tools");
}

do "core_defines.pl";
do "config.pl";

# set autoflush for STDOUT
select(STDOUT);
$|=1;

package command_parse;
sub new{
  my ($type,) = @_;
  my $self = bless{}, $type;
  
  open(SCRIPT,"$::fulldir/../mwadm") || die "Cannot get information for commands from 'mwadm'\n";
  my @lines=<SCRIPT>;
  close(SCRIPT);
  my $start=0;
  while($line = shift @lines){
    chomp($line);
    $line =~ s/^\s+//;
    $line =~ s/^\#//;
    if ($line =~ /^Start Commands/){$start=1;next;}
    next if (($line !~ /^Start Commands/) && !$start);
    last if ($line =~ /^End Commands/);
    my ($command,$command_line,$description)=split(/:/,$line);
    push(@{$self->{command_list}},$command);
    $self->{description}{$command}=$description;
    $self->{command_line}{$command}=$command_line;
  }
  ::trace(1,"command_list=@{$self->{command_list}}\n");
  return $self;
}

sub is_valid_command{
  my $self = shift;
  my $command=shift;
  return 1 if (grep (/$command/,@{$self->{command_list}}));
  return 0;
}

sub get_command_line(){
  my $self  =shift;
  my $command=shift;
  my $my_command=$self->{command_line}{$command};
  # set mwos and mwcore installation directory
  $my_command=~ s/\$mwos/$::mwos/g;
  $my_command=~ s%\$mwcore_dir%$::curdir/\.\.%g;
  $inst_path=convert_path("$::curdir/../../..");
  $my_command=~ s%\$mwcore_inst%$inst_path%g;
  return $my_command;
}

sub convert_path{
  my $path= shift;
  @dirs=split(/\//,$path);
  my @new_dirs=undef;
  foreach $dir (@dirs){
    if (("$dir" ne "..") && ("$dir" ne ".")){
       push(@new_dirs,$dir);
    }
    elsif("$dir" eq ".."){pop(@new_dirs);}
  }
  if ("$new_dirs[0]" eq ""){shift @new_dirs;}
  $new_path = join("/",@new_dirs);
  return $new_path;
}

sub get_command_description(){
  my $self  =shift;
  my $command=shift;
  return $self->{description}{$command};
}

sub get_all_commands{
  my $self = shift;
  return @{$self->{command_list}};
}

package main;

#Global variables
$version_flag=0;
$help_flag=0;
$status=0;
$command=undef;
$version=undef;
$command_run=undef;
$command_params=undef;
$mwos=$ENV{'MWOS'}; # defined by mwadm script
$mwcore_dir="$curdir/..";
if (defined $ENV{'MWDEBUG'}){
  $trace = $ENV{'MWDEBUG'};
}

# Work start here
$command_mng=new command_parse();
$type=shift @ARGV; # 'mainwin' if runing from mainwin installation, 'local' - if running from separate Core Services Installation
while  ($arg=shift @ARGV){
  if($arg eq "help" && !$help_flag){
    $help_flag=1;
  }
  else{
    if (defined($command)){
     $command_params .=" $arg";next;
    }
    $command=$arg;
    ::trace(1,"command is $command\n");
    if(!$command_mng->is_valid_command($command)){
      print STDERR "*** Command '$command' is not valid\n";exit 1;
    }
  }
}
# Command not specified
if ( !$help_flag && !defined($command)){
  usage();
}

if ($help_flag && !defined $command){
 $command="help";
}
elsif ($help_flag){
 $status=help($command);
 exit $status;
}

$command_run=$command_mng->get_command_line($command);
$config = new config($::config_file);
$user = $config->get_sys_admin();
$data_dir = $config->get_path_to_data();
$install_dir = $config->get_path_to_core();
$data_dir = $config->get_path_to_data();

if ($command eq "sec"){
  $command_run .=" $data_dir";
}
$command_run .=" $command_params";
my $rt_mode = $ENV{MWRT_MODE};
if ($rt_mode eq ""){
	if (open(FILE, "$ENV{MWHOME}/default.mode") == 0) {
		$rt_mode = 'enterprise';
		$ENV{'MWRT_MODE'} = 'enterprise';
	} else {
		$rt_mode = <FILE>;
		chomp($rt_mode);
	}
}
if ($rt_mode eq "classic") {
	print STDERR "*** The 'mwadm' command is irrelevant when running under the 'Classic' run-time mode.\n";
	exit 1;
}

if ($command eq "log") {
  $status=system("\"$ENV{MWPERL}\" \"$curdir/log.pl\" $command_run");
  exit $status;
}
if ( $rt_mode =~ /^professional$/ or $rt_mode =~ /^professional:/) {
  $ENV{MWPROF_STRING} = lc($'); 
  ::trace(1,"Full command line is $command_run\n");

  $status=system("$command_run");
} elsif ( $rt_mode =~ /^enterprise$/){
  if ("$install_dir" eq "") {
    print STDERR "Enterprise Core Services are not installed on this computer!\n";
    exit 1;
  }
  if ($command eq "stop" || $command eq "start"){
    $command_run .=" $user $install_dir $data_dir";
  }
  $ent_command = "HOME=\"$data_dir\";export HOME;MWHOME=\"$install_dir/mw\";export MWHOME;. \"\$MWHOME/setmwruntime\";$command_run";
  ::trace(1,"Full command line is $ent_command\n");
  $status=system("$ent_command");

} else {
	print STDERR "Error: Run-time mode is: \'$rt_mode\'; must be "
		. "\'enterprise\' or \'professional\'.\n";
	exit 1;
}
if ($status){
  $error="Error: failed to run command $command_run\n";
}
exit $status;

########################################################
# Global Functions
########################################################
sub usage{
  print STDERR "\nUsage: mwadm command [parameters]\n\n";
  print STDERR "Following is the list of commands supported by the mwadm utility:\n\nversion	displays the version number of the MSC.\nhelp 		displays help on using mwadm and its commands.\nstop		stops all MSC services in an orderly manner.\nstart		manually starts all MSC services.\nstatus		provides vital signs of the MSC services.\nlog		administers the MSC logs.\nsec		administers MSC DCOM security settings.\nreg		administers the MSC registry service.\n\n";
}

sub help{
  my $command = shift;
  if (!-f "$::fulldir/$command.txt"){
    print STDERR "The help file for '$command' does not exist.\n\n";
    return 1;
  }
  return(system("cat \"$::fulldir/$command.txt\""));
  
}

sub trace{
  my ($level,$message)=@_;
  if ($level <= $::trace){
        print STDERR "trace $level: $message\n";
  }
}
