#!/bin/sh 

# input from user
user=$1
installdir=$2

umask 0077

MWHOME=$installdir/mw
export MWHOME

. $MWHOME/setmwruntime 

MyOS=`/bin/uname`
if [ "$MyOS" = "SunOS" ]; then
        id=/usr/xpg4/bin/id
else
	if [ "$MyOS" = "Linux" ]; then
		id=/usr/bin/id
	else
#good for AIX and HP
	        id=/bin/id
	fi
fi

curuser=`$id -u -n`
if [ "${curuser:-}" != "${user:-}" ] ; then
    uid=`$id -u ${user:-}`
    exec exec_as_user $uid noenv $0 $user $installdir
    echo "Start of core services failed, probably due to permissions to su to user ${user:-}"
    exit 1
fi

mwadm=$installdir/mw/bin/mwadm 
__regchmod="${mwadm} reg -chmod"
__regchown="${mwadm} reg -chown"
group=`$id -g -n $user`

$__regchown -r $user 'HKEY_LOCAL_MACHINE'
if [ $? != 0 ]; then
	exit 4
fi
${mwadm} reg -chgrp -r $group HKEY_LOCAL_MACHINE
if [ $? != 0 ]; then
	exit 5
fi
$__regchmod -r 0755 'HKEY_LOCAL_MACHINE'
if [ $? != 0 ]; then
	exit 6
fi
$__regchmod 0777 'HKEY_LOCAL_MACHINE\\Software'
if [ $? != 0 ]; then
	exit 7
fi
$__regchmod -r 0777 'HKEY_LOCAL_MACHINE\\Software\\Classes'
if [ $? != 0 ]; then
	exit 8
fi
exit 0
