#! /bin/sh

MyOS=`uname`
if [ "$MyOS" = "SunOS" ]; then
    id=/usr/xpg4/bin/id
else
# Good for AIX and HP
    id=id
fi

user=$1
installdir=$2
datadir=$3
group=`$id -ng $user`

# initialize data directory
/bin/mkdir -p $datadir/registry_run $datadir/rpcss_run
/bin/chown -R $user $datadir
/bin/chgrp -R $group $datadir
/bin/chmod -R 0700 $datadir
/bin/chmod 755 $datadir/registry_run $datadir/rpcss_run

logfile=/var/tmp/mwmsc_is.log
# make sure /tmp/mw doesn't exist
# as rm sometimes fails if there are files in the directory we move it first
if [ -d /tmp/mw ]; then
	/bin/mv /tmp/mw /tmp/mw_dir_to_be_removed.$$ 
fi

if [ -d /tmp/mw -a -w $logfile ]; then 
	echo "core_hook2.sh: Failed to remove /tmp/mw (mv failed)" >> $logfile
fi

# Now remove the directory.
/bin/rm -rf /tmp/mw_dir_to_be_removed.$$
if [ -d /tmp/mw_dir_to_be_removed.$$ -a -w $logfile ]; then
	echo "core_hook2.sh Failed to delete /tmp/mw_dir_to_be_removed.$$" >> $logfile 
fi

MWOS_INT=`$installdir/mw/bin/getplatinfo config`

cp $installdir/mw/bin-${MWOS_INT}_optimized/run_with_uid $datadir/run_with_uid 

chown root $datadir/run_with_uid
chmod 04555 $datadir/run_with_uid

