$core_name = "MainWin System Core";

$create_boot_script = "$::fulldir/start_core_at_boot";
$start_core = "mwcore";
$core_user = "mwcore";
$show_core_apps = "$::fulldir/show_mwcore_applications";
# configuration file, contain path to Core installation, version of Core
# and list of applications that use Core
$config_file = "/etc/mainwin.conf"; 
$change_admin = "mwadm chadm"; # TO DO implement this script
$version_file = "core_version";
$hook1 = "$::fulldir/core_hook1.sh";
$hook2 = "$::fulldir/core_hook2.sh";
$hook3 = "$::fulldir/core_hook3.sh";
$default_inst_dir = "/opt/mainsoft/mwcore";
$default_data_dir = "/opt/mainsoft/mwcoredata";
$tmp_core_dir="/tmp/mw";
$CORE_PATH_TAG = "CORE_PATH";
$CORE_DATA_TAG = "CORE_DATA";
$CORE_SYS_ADMIN_TAG = "CORE_ADMIN";
$CORE_RPC_ENDPOINT_TAG = "CORE_RPC_ENDPOINT";
$CONFIG_DESC="\# File: mainwin.conf\n#\n\# Copyright (c) 2001, 2002, Mainsoft Corporation.\n\# All rights reserved.\n\#\n\# Mainwin Core Services Configuration File\n\#\n\# This file contains information required to locate and run the\n\# MainWin Core Services.\n\n";
$CORE_PATH_DESC="\# The following variable points to the full path of the mwcore\n\# installation directory\n";
$CORE_DATA_DESC="\# The following variable points to the full path of the mwcore\n\# data directory\n";
$CORE_SYS_ADMIN_DESC="\# The following variable must be set to the user name of the user\n\# who is the MainWin Core Administrator. This user is the only user,\n\# apart from root, allowed to start and stop the MainWin Core Services.\n";
$CORE_RPC_ENDPOINT_DESC="# The following variable must be set to port number to be used by core services\n\# Setting it to 'dynamic' instructs core services to choose dynamic endpoint\n\# DCOM services will be disabled in this case.\n";
sub trace{
  my ($level,$message)=@_;
  if ($level <= $::trace){
	print STDERR "trace $level: $message\n";
  }
}


sub printlog{
  $message=shift;
  return if (! -w $::logfile); # don't want to fail because of logfile
  ::trace(1,"message is $message\n");
  open(LOGFILE,">>$::logfile")|| print STDOUT "Cannot open $::logfile: $! \n";
  if (! -w LOGFILE){print "in printlog, cannot write into $::logfile\n";}
  print LOGFILE "$message";
  close(LOGFILE);

}
