#####################################################################
# package config
# handles writing and reading to and from configuration file
#####################################################################
package config;

# receives configuration file name
# if file exists - read it and save data in package
sub new {
  my ($type, $config_file) = @_;
  my $self = bless{}, $type;
  $self->{config_file} = $config_file;
  
  if (-e $self->{config_file}) {
    if (! open(FILE,"$config_file"))
      {print STDERR "Error: Failed to open file '$config_file': $!.\n"; ::my_exit()}
    @{$self->{lines}}=<FILE>;
    close(FILE);

    foreach $line (@{$self->{lines}}) {
      chomp($line);
      next if ($line =~ /^\#/);
      next if ($line eq "");
      if ($line =~ /^$::CORE_DATA_TAG/) {
	($trush,$self->{data}) = split(/=/,$line);
      }
      elsif ($line =~ /^$::CORE_PATH_TAG/) {
	($trush,$self->{path}) = split(/=/,$line);
      }
      elsif ($line =~ /^$::CORE_SYS_ADMIN_TAG/) {
	($trush,$self->{user}) = split(/=/,$line);
      }
      elsif ($line =~ /^$::CORE_RPC_ENDPOINT_TAG/) {
	($trush,$self->{endpoint}) = split(/=/,$line);
      }
    }
  }
  return $self;
}

# returns path of core installation
sub get_path_to_core {
  ::trace(4, "in get_path_to_core");
  my $self = shift;
  return $self->{path};
}

# returns path of core data
sub get_path_to_data {
  ::trace(4, "in get_path_to_data");
  my $self = shift;
  return $self->{data};
}

# returns system admin
sub get_sys_admin {
  ::trace(4, "in get_sys_admin");
  my $self = shift;
  return $self->{user};
}

# returns rpc endpoint
sub get_rpc_endpoint {
  ::trace(4, "in get_rpc_endpoint");
  my $self = shift;
  return $self->{endpoint};
}

# updates configuration file with new path, version and application
# returns 1 in case of error, 0 in success
sub update_config_file {
  ::trace(4, "in update_config_file");
  my $self = shift;
  $self->{path} = shift;
  $self->{data} = shift;
  $self->{user} = shift;
  $self->{endpoint} = shift;
  my $tmpconfig; # first create config file in temdir, then copy it to /etc to get status of copy
  $self->{config_file} =~ /.*\/(.*)/;
  my $configname = $1;

  if ($ENV{'MWTEMP'} ne ""){$tmpconfig="$ENV{'MWTEMP'}/${configname}";}
  else{$tmpconfig="/var/tmp/${configname}";}

  if (! open (FILE, ">$tmpconfig"))
    {print STDERR "Failed.\nError: Failed to open file '$tmpconfig': $!.\n"; return 1;}
  
  print FILE "$::CONFIG_DESC";
  print FILE "$::CORE_PATH_DESC";
  print FILE "$::CORE_PATH_TAG=$self->{path}\n\n";
  print FILE "$::CORE_DATA_DESC";
  print FILE "$::CORE_DATA_TAG=$self->{data}\n\n";
  print FILE "$::CORE_SYS_ADMIN_DESC";
  print FILE "$::CORE_SYS_ADMIN_TAG=$self->{user}\n\n";
  print FILE "$::CORE_RPC_ENDPOINT_DESC";
  print FILE "$::CORE_RPC_ENDPOINT_TAG=$self->{endpoint}\n\n";
  close(FILE);
  system("cp -f $tmpconfig $self->{config_file}");
  if ($? != 0){
      print STDERR "Failed.\nError: Failed to create '$self->{config_file}'\n";
      return 1;
  }
  unlink($tmpconfig);
  chmod 0644, $self->{config_file};
  if (system("chown", $self->{user}, $self->{config_file}))
    {print STDERR "Failed.\nError: Failed to change owner of file '$self->{config_file}' to '$self->{user}'.\n"; return 1;}
  return 0;
}

