#!/bin/sh 

if [ ! -r /etc/mainwin.conf ]; then
	echo "MainWin core services are not installed on this machine" 
	exit 1
fi

. /etc/mainwin.conf
setport=$CORE_PATH/mw/bin-${MWCONFIG_NAME}_optimized/mwsetport

# check if core services are really down.
MWHOME=$CORE_PATH/mw
export MWHOME
. $MWHOME/setmwruntime

mwpingreg

if [ $? -eq 0 ] && [ -n "$1" ]; then
    echo "This command can not be executed if MSC services are running."
    echo "Please stop the MSC services and try again."
    exit 1
fi

MyOS=`/bin/uname`
if [ "$MyOS" = "SunOS" ]; then
    id=/usr/xpg4/bin/id
else
    if [ "$MyOS" = "Linux" ]; then
        id=/usr/bin/id
    else
#good for AIX and HP
        id=/bin/id
    fi
fi


if [ `$id -u` -eq 0 ]; then
	$setport $*
else
	$CORE_DATA/run_with_uid 0 noenv $setport $*
	if [ $? -eq 2 ]; then
		echo "Failed to view/change port: No permissions."
		exit 2
	fi
fi

