#! /bin/csh -f

# Copyright (c) 2005 Altera Corporation. All rights reserved.  

# Your use of Altera Corporation's design tools, logic functions and other 
# software and tools, and its AMPP partner logic functions, and any output files 
# any of the foregoing (including device programming or simulation files), and 
# any associated documentation or information are expressly subject to the terms 
# and conditions of the Altera Program License Subscription Agreement, Altera 
# MegaCore Function License Agreement, or other applicable license agreement, 
# including, without limitation, that your use is for the sole purpose of 
# programming logic devices manufactured by Altera and sold by Altera or its 
# authorized distributors.  Please refer to the applicable agreement for 
# further details.

# don't let CTRL-C stop this script from continuing
onintr -

if (! $?QUARTUS_ROOTDIR) then
	setenv SCRIPT_PATH `dirname $0`

	if ("${SCRIPT_PATH}" == "") then
        # in case the dirname doesn't work, use "which" (slower)
		setenv SCRIPT_PATH `which $0 |& tail -1`
	endif

	if ("${SCRIPT_PATH}" == "." || "${SCRIPT_PATH}" == "") then
		setenv QUARTUS_ROOTDIR `dirname $cwd`
	else 
		setenv QUARTUS_ROOTDIR `dirname ${SCRIPT_PATH}`
	endif

	if ("${QUARTUS_ROOTDIR}" == "..") then
		setenv QUARTUS_ROOTDIR `dirname $cwd`
	endif
endif

if ( "${QUARTUS_ROOTDIR}" !~ /* ) then
	setenv QUARTUS_ROOTDIR `(cd ${QUARTUS_ROOTDIR} ; pwd)`
endif

setenv CMD_NAME `basename $0`

# Reset MWHOME for standalone HtmlHelp only, to use the MW 4.0.2 version
# on Solaris 8 only.
if ($CMD_NAME == hh) then
	if (`uname -s` == "SunOS" && `uname -r` == 5.8) then
		setenv QUARTUS_MWHOME ${QUARTUS_ROOTDIR}/hh
	endif
endif

# Need this so shell won't try to match a * or ? inside a quoted arg
set noglob=1

set cmd_line=
@ count=1;
while ($count <= $#argv)
	if ("$argv[$count]" == "--64bit") then
		setenv QUARTUS_64BIT 1
	else
		set cmd_line=($cmd_line \"$argv[$count]\")
	endif
	@ count++
end

source ${QUARTUS_ROOTDIR}/adm/qenv.csh

if ($QENV_STATUS != 0) exit $QENV_STATUS

set gui_exes=(quartus qtb_install qmegawiz quartus_pgmw hh)

foreach exe ($gui_exes)
	if ($CMD_NAME == $exe) setenv CHECK_PATCHES 1
end	

if ($CMD_NAME =~ mw*) then
	setenv CHECK_PATCHES 1
endif

# Check to make sure the right system patches are installed
if ( $?CHECK_PATCHES ) then
	check_patches
	set result=$status
	if ( $result == 3 ) then
		if ($UNAME_REVISION == 5.8) then
			setenv HLP_WINDOW_OUTPROC 1
		else
			echo "Because some operating system patches are not installed, the Quartus II software"
			echo "Help is unavailable."
			setenv QUARTUS_DISABLE_HELP 1
		endif
	else if ( $result != 0 ) then
		echo "Because some operating system patches are not installed, the Quartus II software"
		echo "graphical user interface performance and general stability may also be affected."
		if ( $PORT == SOLARIS ) setenv LD_LIBRARY_PATH ${QUARTUS_ROOTDIR}/adm/syslibs/${UNAME_REVISION}:$LD_LIBRARY_PATH
	endif
endif

if ($CMD_NAME == "mwcleanup") then
	$CMD_NAME $*
	exec qcleanup
endif

# Need quotes around command with noglob set
eval exec "$CMD_NAME $cmd_line"
