/*
 * This Verilog module encapsulates the header connector on which the two
 * Calypso UARTs will be brought out, as well as pull-up resistors to keep
 * Calypso UART inputs from floating when unconnected.
 */

module uart_bringout (GND, Vio, TX_MODEM, RX_MODEM, RTS_MODEM, CTS_MODEM,
			TX_IRDA, RX_IRDA);

input GND, Vio;

input TX_MODEM, RTS_MODEM, TX_IRDA;
output RX_MODEM, CTS_MODEM, RX_IRDA;

header_10pin uart_header (.pin_1(GND),
			  .pin_2(GND),
			  .pin_3(TX_IRDA),
			  .pin_4(TX_MODEM),
			  .pin_5(RX_IRDA),
			  .pin_6(RX_MODEM),
			  .pin_7(),
			  .pin_8(RTS_MODEM),
			  .pin_9(),
			  .pin_10(CTS_MODEM)
	);

/* pull-ups */
resistor R101 (RX_MODEM, Vio);
resistor R102 (CTS_MODEM, Vio);
resistor R103 (RX_IRDA, Vio);

endmodule
